// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4785__auto___64519 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null)))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_64570){
var state_val_64571 = (state_64570[(1)]);
if((state_val_64571 === (7))){
var inst_64565 = (state_64570[(2)]);
var _ = (function (){var statearr_64572 = state_64570;
(statearr_64572[(4)] = cljs.core.rest.call(null,(state_64570[(4)])));

return statearr_64572;
})();
var state_64570__$1 = state_64570;
var statearr_64573_64600 = state_64570__$1;
(statearr_64573_64600[(2)] = inst_64565);

(statearr_64573_64600[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64571 === (1))){
var state_64570__$1 = state_64570;
var statearr_64574_64601 = state_64570__$1;
(statearr_64574_64601[(2)] = null);

(statearr_64574_64601[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64571 === (4))){
var inst_64520 = (state_64570[(2)]);
var state_64570__$1 = state_64570;
var statearr_64575_64602 = state_64570__$1;
(statearr_64575_64602[(2)] = inst_64520);

(statearr_64575_64602[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64571 === (13))){
var inst_64561 = (state_64570[(2)]);
var state_64570__$1 = state_64570;
var statearr_64576_64603 = state_64570__$1;
(statearr_64576_64603[(2)] = inst_64561);

(statearr_64576_64603[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64571 === (6))){
var inst_64538 = (state_64570[(7)]);
var inst_64545 = (state_64570[(8)]);
var inst_64544 = cljs.core.seq.call(null,inst_64538);
var inst_64545__$1 = cljs.core.first.call(null,inst_64544);
var inst_64546 = cljs.core.next.call(null,inst_64544);
var inst_64547 = cljs.core.not.call(null,inst_64545__$1);
var state_64570__$1 = (function (){var statearr_64577 = state_64570;
(statearr_64577[(8)] = inst_64545__$1);

(statearr_64577[(9)] = inst_64546);

return statearr_64577;
})();
if(inst_64547){
var statearr_64578_64604 = state_64570__$1;
(statearr_64578_64604[(1)] = (8));

} else {
var statearr_64579_64605 = state_64570__$1;
(statearr_64579_64605[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64571 === (3))){
var inst_64568 = (state_64570[(2)]);
var state_64570__$1 = state_64570;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64570__$1,inst_64568);
} else {
if((state_val_64571 === (12))){
var inst_64539 = (state_64570[(10)]);
var inst_64545 = (state_64570[(8)]);
var inst_64546 = (state_64570[(9)]);
var inst_64558 = cljs.core.conj.call(null,inst_64539,inst_64545);
var inst_64538 = inst_64546;
var inst_64539__$1 = inst_64558;
var state_64570__$1 = (function (){var statearr_64580 = state_64570;
(statearr_64580[(7)] = inst_64538);

(statearr_64580[(10)] = inst_64539__$1);

return statearr_64580;
})();
var statearr_64581_64606 = state_64570__$1;
(statearr_64581_64606[(2)] = null);

(statearr_64581_64606[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64571 === (2))){
var _ = (function (){var statearr_64582 = state_64570;
(statearr_64582[(4)] = cljs.core.cons.call(null,(5),(state_64570[(4)])));

return statearr_64582;
})();
var inst_64533 = args;
var inst_64534 = cljs.core.seq.call(null,inst_64533);
var inst_64535 = cljs.core.first.call(null,inst_64534);
var inst_64536 = cljs.core.next.call(null,inst_64534);
var inst_64537 = cljs.core.PersistentVector.EMPTY;
var inst_64538 = inst_64533;
var inst_64539 = inst_64537;
var state_64570__$1 = (function (){var statearr_64583 = state_64570;
(statearr_64583[(7)] = inst_64538);

(statearr_64583[(10)] = inst_64539);

(statearr_64583[(11)] = inst_64535);

(statearr_64583[(12)] = inst_64536);

return statearr_64583;
})();
var statearr_64584_64607 = state_64570__$1;
(statearr_64584_64607[(2)] = null);

(statearr_64584_64607[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64571 === (11))){
var inst_64545 = (state_64570[(8)]);
var state_64570__$1 = state_64570;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64570__$1,(14),inst_64545);
} else {
if((state_val_64571 === (9))){
var inst_64545 = (state_64570[(8)]);
var inst_64550 = fluree.db.util.async.channel_QMARK_.call(null,inst_64545);
var state_64570__$1 = state_64570;
if(inst_64550){
var statearr_64586_64608 = state_64570__$1;
(statearr_64586_64608[(1)] = (11));

} else {
var statearr_64587_64609 = state_64570__$1;
(statearr_64587_64609[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64571 === (5))){
var _ = (function (){var statearr_64588 = state_64570;
(statearr_64588[(4)] = cljs.core.rest.call(null,(state_64570[(4)])));

return statearr_64588;
})();
var state_64570__$1 = state_64570;
var ex64585 = (state_64570__$1[(2)]);
var statearr_64589_64610 = state_64570__$1;
(statearr_64589_64610[(5)] = ex64585);


if((ex64585 instanceof Error)){
var statearr_64590_64611 = state_64570__$1;
(statearr_64590_64611[(1)] = (4));

(statearr_64590_64611[(5)] = null);

} else {
throw ex64585;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64571 === (14))){
var inst_64539 = (state_64570[(10)]);
var inst_64546 = (state_64570[(9)]);
var inst_64553 = (state_64570[(2)]);
var inst_64554 = fluree.db.util.async.throw_err.call(null,inst_64553);
var inst_64555 = cljs.core.conj.call(null,inst_64539,inst_64554);
var inst_64538 = inst_64546;
var inst_64539__$1 = inst_64555;
var state_64570__$1 = (function (){var statearr_64591 = state_64570;
(statearr_64591[(7)] = inst_64538);

(statearr_64591[(10)] = inst_64539__$1);

return statearr_64591;
})();
var statearr_64592_64612 = state_64570__$1;
(statearr_64592_64612[(2)] = null);

(statearr_64592_64612[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64571 === (10))){
var inst_64563 = (state_64570[(2)]);
var state_64570__$1 = state_64570;
var statearr_64593_64613 = state_64570__$1;
(statearr_64593_64613[(2)] = inst_64563);

(statearr_64593_64613[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64571 === (8))){
var inst_64539 = (state_64570[(10)]);
var state_64570__$1 = state_64570;
var statearr_64594_64614 = state_64570__$1;
(statearr_64594_64614[(2)] = inst_64539);

(statearr_64594_64614[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11469__auto____0 = (function (){
var statearr_64595 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64595[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11469__auto__);

(statearr_64595[(1)] = (1));

return statearr_64595;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11469__auto____1 = (function (state_64570){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_64570);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e64596){var ex__11472__auto__ = e64596;
var statearr_64597_64615 = state_64570;
(statearr_64597_64615[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_64570[(4)]))){
var statearr_64598_64616 = state_64570;
(statearr_64598_64616[(1)] = cljs.core.first.call(null,(state_64570[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64617 = state_64570;
state_64570 = G__64617;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11469__auto__ = function(state_64570){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11469__auto____1.call(this,state_64570);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_64599 = f__11543__auto__.call(null);
(statearr_64599[(6)] = c__11542__auto__);

return statearr_64599;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__64618 = entry;
var res = cljs.core.nth.call(null,vec__64618,(0),null);
var cost = cljs.core.nth.call(null,vec__64618,(1),null);
fluree.db.util.log.debug.call(null,"Smart function stack: ",res);

return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj.call(null,new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(s),entry),new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._.call(null,new cljs.core.Keyword(null,"credits","credits",785860820).cljs$core$IFn$_invoke$arity$1(s),cost),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_.call(null,new cljs.core.Keyword(null,"spent","spent",-62769180).cljs$core$IFn$_invoke$arity$1(s),cost));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.call(null,msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack.call(null,_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_64666){
var state_val_64667 = (state_64666[(1)]);
if((state_val_64667 === (7))){
var state_64666__$1 = state_64666;
var statearr_64668_64697 = state_64666__$1;
(statearr_64668_64697[(2)] = coll);

(statearr_64668_64697[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64667 === (1))){
var state_64666__$1 = state_64666;
var statearr_64669_64698 = state_64666__$1;
(statearr_64669_64698[(2)] = null);

(statearr_64669_64698[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64667 === (4))){
var inst_64621 = (state_64666[(2)]);
var state_64666__$1 = state_64666;
var statearr_64670_64699 = state_64666__$1;
(statearr_64670_64699[(2)] = inst_64621);

(statearr_64670_64699[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64667 === (15))){
var inst_64640 = (state_64666[(7)]);
var inst_64648 = (state_64666[(2)]);
var inst_64649 = fluree.db.dbfunctions.internal.nth.call(null,inst_64640,inst_64648);
var inst_64650 = cljs.core.count.call(null,inst_64640);
var inst_64651 = ((9) + inst_64650);
var inst_64652 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64653 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64654 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64655 = [inst_64640,inst_64648];
var inst_64656 = (new cljs.core.PersistentVector(null,2,(5),inst_64654,inst_64655,null));
var inst_64657 = ["nth",inst_64656,inst_64649];
var inst_64658 = cljs.core.PersistentHashMap.fromArrays(inst_64653,inst_64657);
var inst_64659 = [inst_64658,inst_64651];
var inst_64660 = (new cljs.core.PersistentVector(null,2,(5),inst_64652,inst_64659,null));
var inst_64661 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64660);
var _ = (function (){var statearr_64671 = state_64666;
(statearr_64671[(4)] = cljs.core.rest.call(null,(state_64666[(4)])));

return statearr_64671;
})();
var state_64666__$1 = (function (){var statearr_64672 = state_64666;
(statearr_64672[(8)] = inst_64661);

return statearr_64672;
})();
var statearr_64673_64700 = state_64666__$1;
(statearr_64673_64700[(2)] = inst_64649);

(statearr_64673_64700[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64667 === (13))){
var state_64666__$1 = state_64666;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64666__$1,(16),key);
} else {
if((state_val_64667 === (6))){
var state_64666__$1 = state_64666;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64666__$1,(9),coll);
} else {
if((state_val_64667 === (3))){
var inst_64664 = (state_64666[(2)]);
var state_64666__$1 = state_64666;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64666__$1,inst_64664);
} else {
if((state_val_64667 === (12))){
var inst_64640 = (state_64666[(2)]);
var inst_64641 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_64666__$1 = (function (){var statearr_64674 = state_64666;
(statearr_64674[(7)] = inst_64640);

return statearr_64674;
})();
if(inst_64641){
var statearr_64675_64701 = state_64666__$1;
(statearr_64675_64701[(1)] = (13));

} else {
var statearr_64676_64702 = state_64666__$1;
(statearr_64676_64702[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64667 === (2))){
var _ = (function (){var statearr_64677 = state_64666;
(statearr_64677[(4)] = cljs.core.cons.call(null,(5),(state_64666[(4)])));

return statearr_64677;
})();
var inst_64627 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_64666__$1 = state_64666;
if(inst_64627){
var statearr_64678_64703 = state_64666__$1;
(statearr_64678_64703[(1)] = (6));

} else {
var statearr_64679_64704 = state_64666__$1;
(statearr_64679_64704[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64667 === (11))){
var inst_64634 = (state_64666[(9)]);
var state_64666__$1 = state_64666;
var statearr_64681_64705 = state_64666__$1;
(statearr_64681_64705[(2)] = inst_64634);

(statearr_64681_64705[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64667 === (9))){
var inst_64630 = (state_64666[(2)]);
var inst_64631 = fluree.db.util.async.throw_err.call(null,inst_64630);
var state_64666__$1 = state_64666;
var statearr_64682_64706 = state_64666__$1;
(statearr_64682_64706[(2)] = inst_64631);

(statearr_64682_64706[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64667 === (5))){
var _ = (function (){var statearr_64683 = state_64666;
(statearr_64683[(4)] = cljs.core.rest.call(null,(state_64666[(4)])));

return statearr_64683;
})();
var state_64666__$1 = state_64666;
var ex64680 = (state_64666__$1[(2)]);
var statearr_64684_64707 = state_64666__$1;
(statearr_64684_64707[(5)] = ex64680);


if((ex64680 instanceof Error)){
var statearr_64685_64708 = state_64666__$1;
(statearr_64685_64708[(1)] = (4));

(statearr_64685_64708[(5)] = null);

} else {
throw ex64680;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64667 === (14))){
var state_64666__$1 = state_64666;
var statearr_64686_64709 = state_64666__$1;
(statearr_64686_64709[(2)] = key);

(statearr_64686_64709[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64667 === (16))){
var inst_64644 = (state_64666[(2)]);
var inst_64645 = fluree.db.util.async.throw_err.call(null,inst_64644);
var state_64666__$1 = state_64666;
var statearr_64687_64710 = state_64666__$1;
(statearr_64687_64710[(2)] = inst_64645);

(statearr_64687_64710[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64667 === (10))){
var inst_64634 = (state_64666[(9)]);
var inst_64637 = cljs.core.vec.call(null,inst_64634);
var state_64666__$1 = state_64666;
var statearr_64688_64711 = state_64666__$1;
(statearr_64688_64711[(2)] = inst_64637);

(statearr_64688_64711[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64667 === (8))){
var inst_64634 = (state_64666[(9)]);
var inst_64634__$1 = (state_64666[(2)]);
var inst_64635 = cljs.core.set_QMARK_.call(null,inst_64634__$1);
var state_64666__$1 = (function (){var statearr_64689 = state_64666;
(statearr_64689[(9)] = inst_64634__$1);

return statearr_64689;
})();
if(inst_64635){
var statearr_64690_64712 = state_64666__$1;
(statearr_64690_64712[(1)] = (10));

} else {
var statearr_64691_64713 = state_64666__$1;
(statearr_64691_64713[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__11469__auto____0 = (function (){
var statearr_64692 = [null,null,null,null,null,null,null,null,null,null];
(statearr_64692[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__11469__auto__);

(statearr_64692[(1)] = (1));

return statearr_64692;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__11469__auto____1 = (function (state_64666){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_64666);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e64693){var ex__11472__auto__ = e64693;
var statearr_64694_64714 = state_64666;
(statearr_64694_64714[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_64666[(4)]))){
var statearr_64695_64715 = state_64666;
(statearr_64695_64715[(1)] = cljs.core.first.call(null,(state_64666[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64716 = state_64666;
state_64666 = G__64716;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__11469__auto__ = function(state_64666){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__11469__auto____1.call(this,state_64666);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_64696 = f__11543__auto__.call(null);
(statearr_64696[(6)] = c__11542__auto__);

return statearr_64696;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_64777){
var state_val_64778 = (state_64777[(1)]);
if((state_val_64778 === (7))){
var state_64777__$1 = state_64777;
var statearr_64779_64813 = state_64777__$1;
(statearr_64779_64813[(2)] = test);

(statearr_64779_64813[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64778 === (20))){
var inst_64751 = (state_64777[(2)]);
var inst_64752 = fluree.db.util.async.throw_err.call(null,inst_64751);
var state_64777__$1 = state_64777;
var statearr_64780_64814 = state_64777__$1;
(statearr_64780_64814[(2)] = inst_64752);

(statearr_64780_64814[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64778 === (1))){
var state_64777__$1 = state_64777;
var statearr_64781_64815 = state_64777__$1;
(statearr_64781_64815[(2)] = null);

(statearr_64781_64815[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64778 === (4))){
var inst_64717 = (state_64777[(2)]);
var state_64777__$1 = state_64777;
var statearr_64782_64816 = state_64777__$1;
(statearr_64782_64816[(2)] = inst_64717);

(statearr_64782_64816[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64778 === (15))){
var inst_64735 = (state_64777[(7)]);
var inst_64743 = (state_64777[(2)]);
var inst_64744 = [inst_64743,f];
var inst_64745 = (new cljs.core.PersistentVector(null,2,(5),inst_64735,inst_64744,null));
var state_64777__$1 = state_64777;
var statearr_64783_64817 = state_64777__$1;
(statearr_64783_64817[(2)] = inst_64745);

(statearr_64783_64817[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64778 === (13))){
var state_64777__$1 = state_64777;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64777__$1,(16),t);
} else {
if((state_val_64778 === (6))){
var state_64777__$1 = state_64777;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64777__$1,(9),test);
} else {
if((state_val_64778 === (17))){
var state_64777__$1 = state_64777;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64777__$1,(20),f);
} else {
if((state_val_64778 === (3))){
var inst_64775 = (state_64777[(2)]);
var state_64777__$1 = state_64777;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64777__$1,inst_64775);
} else {
if((state_val_64778 === (12))){
var inst_64733 = (state_64777[(8)]);
var inst_64759 = (state_64777[(2)]);
var inst_64760 = cljs.core.nth.call(null,inst_64759,(0),null);
var inst_64761 = cljs.core.nth.call(null,inst_64759,(1),null);
var inst_64762 = fluree.db.dbfunctions.internal.if_else.call(null,inst_64733,inst_64760,inst_64761);
var inst_64763 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64764 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64765 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64766 = [inst_64733,inst_64760,inst_64761];
var inst_64767 = (new cljs.core.PersistentVector(null,3,(5),inst_64765,inst_64766,null));
var inst_64768 = ["if-else",inst_64767,inst_64762];
var inst_64769 = cljs.core.PersistentHashMap.fromArrays(inst_64764,inst_64768);
var inst_64770 = [inst_64769,(10)];
var inst_64771 = (new cljs.core.PersistentVector(null,2,(5),inst_64763,inst_64770,null));
var inst_64772 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64771);
var _ = (function (){var statearr_64784 = state_64777;
(statearr_64784[(4)] = cljs.core.rest.call(null,(state_64777[(4)])));

return statearr_64784;
})();
var state_64777__$1 = (function (){var statearr_64785 = state_64777;
(statearr_64785[(9)] = inst_64772);

return statearr_64785;
})();
var statearr_64786_64818 = state_64777__$1;
(statearr_64786_64818[(2)] = inst_64762);

(statearr_64786_64818[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64778 === (2))){
var _ = (function (){var statearr_64787 = state_64777;
(statearr_64787[(4)] = cljs.core.cons.call(null,(5),(state_64777[(4)])));

return statearr_64787;
})();
var inst_64726 = fluree.db.util.async.channel_QMARK_.call(null,test);
var state_64777__$1 = state_64777;
if(inst_64726){
var statearr_64788_64819 = state_64777__$1;
(statearr_64788_64819[(1)] = (6));

} else {
var statearr_64789_64820 = state_64777__$1;
(statearr_64789_64820[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64778 === (19))){
var inst_64747 = (state_64777[(10)]);
var inst_64755 = (state_64777[(2)]);
var inst_64756 = [f,inst_64755];
var inst_64757 = (new cljs.core.PersistentVector(null,2,(5),inst_64747,inst_64756,null));
var state_64777__$1 = state_64777;
var statearr_64790_64821 = state_64777__$1;
(statearr_64790_64821[(2)] = inst_64757);

(statearr_64790_64821[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64778 === (11))){
var inst_64747 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64748 = fluree.db.util.async.channel_QMARK_.call(null,f);
var state_64777__$1 = (function (){var statearr_64792 = state_64777;
(statearr_64792[(10)] = inst_64747);

return statearr_64792;
})();
if(inst_64748){
var statearr_64793_64822 = state_64777__$1;
(statearr_64793_64822[(1)] = (17));

} else {
var statearr_64794_64823 = state_64777__$1;
(statearr_64794_64823[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64778 === (9))){
var inst_64729 = (state_64777[(2)]);
var inst_64730 = fluree.db.util.async.throw_err.call(null,inst_64729);
var state_64777__$1 = state_64777;
var statearr_64795_64824 = state_64777__$1;
(statearr_64795_64824[(2)] = inst_64730);

(statearr_64795_64824[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64778 === (5))){
var _ = (function (){var statearr_64796 = state_64777;
(statearr_64796[(4)] = cljs.core.rest.call(null,(state_64777[(4)])));

return statearr_64796;
})();
var state_64777__$1 = state_64777;
var ex64791 = (state_64777__$1[(2)]);
var statearr_64797_64825 = state_64777__$1;
(statearr_64797_64825[(5)] = ex64791);


if((ex64791 instanceof Error)){
var statearr_64798_64826 = state_64777__$1;
(statearr_64798_64826[(1)] = (4));

(statearr_64798_64826[(5)] = null);

} else {
throw ex64791;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64778 === (14))){
var state_64777__$1 = state_64777;
var statearr_64799_64827 = state_64777__$1;
(statearr_64799_64827[(2)] = t);

(statearr_64799_64827[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64778 === (16))){
var inst_64739 = (state_64777[(2)]);
var inst_64740 = fluree.db.util.async.throw_err.call(null,inst_64739);
var state_64777__$1 = state_64777;
var statearr_64800_64828 = state_64777__$1;
(statearr_64800_64828[(2)] = inst_64740);

(statearr_64800_64828[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64778 === (10))){
var inst_64735 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64736 = fluree.db.util.async.channel_QMARK_.call(null,t);
var state_64777__$1 = (function (){var statearr_64801 = state_64777;
(statearr_64801[(7)] = inst_64735);

return statearr_64801;
})();
if(inst_64736){
var statearr_64802_64829 = state_64777__$1;
(statearr_64802_64829[(1)] = (13));

} else {
var statearr_64803_64830 = state_64777__$1;
(statearr_64803_64830[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64778 === (18))){
var state_64777__$1 = state_64777;
var statearr_64804_64831 = state_64777__$1;
(statearr_64804_64831[(2)] = f);

(statearr_64804_64831[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64778 === (8))){
var inst_64733 = (state_64777[(8)]);
var inst_64733__$1 = (state_64777[(2)]);
var state_64777__$1 = (function (){var statearr_64805 = state_64777;
(statearr_64805[(8)] = inst_64733__$1);

return statearr_64805;
})();
if(cljs.core.truth_(inst_64733__$1)){
var statearr_64806_64832 = state_64777__$1;
(statearr_64806_64832[(1)] = (10));

} else {
var statearr_64807_64833 = state_64777__$1;
(statearr_64807_64833[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__11469__auto____0 = (function (){
var statearr_64808 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_64808[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__11469__auto__);

(statearr_64808[(1)] = (1));

return statearr_64808;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__11469__auto____1 = (function (state_64777){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_64777);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e64809){var ex__11472__auto__ = e64809;
var statearr_64810_64834 = state_64777;
(statearr_64810_64834[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_64777[(4)]))){
var statearr_64811_64835 = state_64777;
(statearr_64811_64835[(1)] = cljs.core.first.call(null,(state_64777[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64836 = state_64777;
state_64777 = G__64836;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__11469__auto__ = function(state_64777){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__11469__auto____1.call(this,state_64777);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_64812 = f__11543__auto__.call(null);
(statearr_64812[(6)] = c__11542__auto__);

return statearr_64812;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_64866){
var state_val_64867 = (state_64866[(1)]);
if((state_val_64867 === (7))){
var state_64866__$1 = state_64866;
var statearr_64868_64887 = state_64866__$1;
(statearr_64868_64887[(2)] = arg);

(statearr_64868_64887[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64867 === (1))){
var state_64866__$1 = state_64866;
var statearr_64869_64888 = state_64866__$1;
(statearr_64869_64888[(2)] = null);

(statearr_64869_64888[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64867 === (4))){
var inst_64837 = (state_64866[(2)]);
var state_64866__$1 = state_64866;
var statearr_64870_64889 = state_64866__$1;
(statearr_64870_64889[(2)] = inst_64837);

(statearr_64870_64889[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64867 === (6))){
var state_64866__$1 = state_64866;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64866__$1,(9),arg);
} else {
if((state_val_64867 === (3))){
var inst_64864 = (state_64866[(2)]);
var state_64866__$1 = state_64866;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64866__$1,inst_64864);
} else {
if((state_val_64867 === (2))){
var _ = (function (){var statearr_64872 = state_64866;
(statearr_64872[(4)] = cljs.core.cons.call(null,(5),(state_64866[(4)])));

return statearr_64872;
})();
var inst_64843 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_64866__$1 = state_64866;
if(inst_64843){
var statearr_64873_64890 = state_64866__$1;
(statearr_64873_64890[(1)] = (6));

} else {
var statearr_64874_64891 = state_64866__$1;
(statearr_64874_64891[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64867 === (9))){
var inst_64846 = (state_64866[(2)]);
var inst_64847 = fluree.db.util.async.throw_err.call(null,inst_64846);
var state_64866__$1 = state_64866;
var statearr_64875_64892 = state_64866__$1;
(statearr_64875_64892[(2)] = inst_64847);

(statearr_64875_64892[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64867 === (5))){
var _ = (function (){var statearr_64876 = state_64866;
(statearr_64876[(4)] = cljs.core.rest.call(null,(state_64866[(4)])));

return statearr_64876;
})();
var state_64866__$1 = state_64866;
var ex64871 = (state_64866__$1[(2)]);
var statearr_64877_64893 = state_64866__$1;
(statearr_64877_64893[(5)] = ex64871);


if((ex64871 instanceof Error)){
var statearr_64878_64894 = state_64866__$1;
(statearr_64878_64894[(1)] = (4));

(statearr_64878_64894[(5)] = null);

} else {
throw ex64871;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64867 === (8))){
var inst_64850 = (state_64866[(2)]);
var inst_64851 = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,inst_64850);
var inst_64852 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64853 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64854 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64855 = [inst_64850];
var inst_64856 = (new cljs.core.PersistentVector(null,1,(5),inst_64854,inst_64855,null));
var inst_64857 = ["nil?",inst_64856,inst_64851];
var inst_64858 = cljs.core.PersistentHashMap.fromArrays(inst_64853,inst_64857);
var inst_64859 = [inst_64858,(10)];
var inst_64860 = (new cljs.core.PersistentVector(null,2,(5),inst_64852,inst_64859,null));
var inst_64861 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64860);
var _ = (function (){var statearr_64879 = state_64866;
(statearr_64879[(4)] = cljs.core.rest.call(null,(state_64866[(4)])));

return statearr_64879;
})();
var state_64866__$1 = (function (){var statearr_64880 = state_64866;
(statearr_64880[(7)] = inst_64861);

return statearr_64880;
})();
var statearr_64881_64895 = state_64866__$1;
(statearr_64881_64895[(2)] = inst_64851);

(statearr_64881_64895[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11469__auto____0 = (function (){
var statearr_64882 = [null,null,null,null,null,null,null,null];
(statearr_64882[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11469__auto__);

(statearr_64882[(1)] = (1));

return statearr_64882;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11469__auto____1 = (function (state_64866){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_64866);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e64883){var ex__11472__auto__ = e64883;
var statearr_64884_64896 = state_64866;
(statearr_64884_64896[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_64866[(4)]))){
var statearr_64885_64897 = state_64866;
(statearr_64885_64897[(1)] = cljs.core.first.call(null,(state_64866[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64898 = state_64866;
state_64866 = G__64898;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11469__auto__ = function(state_64866){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11469__auto____1.call(this,state_64866);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_64886 = f__11543__auto__.call(null);
(statearr_64886[(6)] = c__11542__auto__);

return statearr_64886;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_64928){
var state_val_64929 = (state_64928[(1)]);
if((state_val_64929 === (7))){
var state_64928__$1 = state_64928;
var statearr_64930_64949 = state_64928__$1;
(statearr_64930_64949[(2)] = arg);

(statearr_64930_64949[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64929 === (1))){
var state_64928__$1 = state_64928;
var statearr_64931_64950 = state_64928__$1;
(statearr_64931_64950[(2)] = null);

(statearr_64931_64950[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64929 === (4))){
var inst_64899 = (state_64928[(2)]);
var state_64928__$1 = state_64928;
var statearr_64932_64951 = state_64928__$1;
(statearr_64932_64951[(2)] = inst_64899);

(statearr_64932_64951[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64929 === (6))){
var state_64928__$1 = state_64928;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64928__$1,(9),arg);
} else {
if((state_val_64929 === (3))){
var inst_64926 = (state_64928[(2)]);
var state_64928__$1 = state_64928;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64928__$1,inst_64926);
} else {
if((state_val_64929 === (2))){
var _ = (function (){var statearr_64934 = state_64928;
(statearr_64934[(4)] = cljs.core.cons.call(null,(5),(state_64928[(4)])));

return statearr_64934;
})();
var inst_64905 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_64928__$1 = state_64928;
if(inst_64905){
var statearr_64935_64952 = state_64928__$1;
(statearr_64935_64952[(1)] = (6));

} else {
var statearr_64936_64953 = state_64928__$1;
(statearr_64936_64953[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64929 === (9))){
var inst_64908 = (state_64928[(2)]);
var inst_64909 = fluree.db.util.async.throw_err.call(null,inst_64908);
var state_64928__$1 = state_64928;
var statearr_64937_64954 = state_64928__$1;
(statearr_64937_64954[(2)] = inst_64909);

(statearr_64937_64954[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64929 === (5))){
var _ = (function (){var statearr_64938 = state_64928;
(statearr_64938[(4)] = cljs.core.rest.call(null,(state_64928[(4)])));

return statearr_64938;
})();
var state_64928__$1 = state_64928;
var ex64933 = (state_64928__$1[(2)]);
var statearr_64939_64955 = state_64928__$1;
(statearr_64939_64955[(5)] = ex64933);


if((ex64933 instanceof Error)){
var statearr_64940_64956 = state_64928__$1;
(statearr_64940_64956[(1)] = (4));

(statearr_64940_64956[(5)] = null);

} else {
throw ex64933;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64929 === (8))){
var inst_64912 = (state_64928[(2)]);
var inst_64913 = fluree.db.dbfunctions.internal.not.call(null,inst_64912);
var inst_64914 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64915 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64916 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64917 = [inst_64912];
var inst_64918 = (new cljs.core.PersistentVector(null,1,(5),inst_64916,inst_64917,null));
var inst_64919 = ["not?",inst_64918,inst_64913];
var inst_64920 = cljs.core.PersistentHashMap.fromArrays(inst_64915,inst_64919);
var inst_64921 = [inst_64920,(10)];
var inst_64922 = (new cljs.core.PersistentVector(null,2,(5),inst_64914,inst_64921,null));
var inst_64923 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64922);
var _ = (function (){var statearr_64941 = state_64928;
(statearr_64941[(4)] = cljs.core.rest.call(null,(state_64928[(4)])));

return statearr_64941;
})();
var state_64928__$1 = (function (){var statearr_64942 = state_64928;
(statearr_64942[(7)] = inst_64923);

return statearr_64942;
})();
var statearr_64943_64957 = state_64928__$1;
(statearr_64943_64957[(2)] = inst_64913);

(statearr_64943_64957[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__11469__auto____0 = (function (){
var statearr_64944 = [null,null,null,null,null,null,null,null];
(statearr_64944[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__11469__auto__);

(statearr_64944[(1)] = (1));

return statearr_64944;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__11469__auto____1 = (function (state_64928){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_64928);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e64945){var ex__11472__auto__ = e64945;
var statearr_64946_64958 = state_64928;
(statearr_64946_64958[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_64928[(4)]))){
var statearr_64947_64959 = state_64928;
(statearr_64947_64959[(1)] = cljs.core.first.call(null,(state_64928[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64960 = state_64928;
state_64928 = G__64960;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__11469__auto__ = function(state_64928){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__11469__auto____1.call(this,state_64928);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_64948 = f__11543__auto__.call(null);
(statearr_64948[(6)] = c__11542__auto__);

return statearr_64948;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_64990){
var state_val_64991 = (state_64990[(1)]);
if((state_val_64991 === (7))){
var state_64990__$1 = state_64990;
var statearr_64992_65011 = state_64990__$1;
(statearr_64992_65011[(2)] = arg);

(statearr_64992_65011[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64991 === (1))){
var state_64990__$1 = state_64990;
var statearr_64993_65012 = state_64990__$1;
(statearr_64993_65012[(2)] = null);

(statearr_64993_65012[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64991 === (4))){
var inst_64961 = (state_64990[(2)]);
var state_64990__$1 = state_64990;
var statearr_64994_65013 = state_64990__$1;
(statearr_64994_65013[(2)] = inst_64961);

(statearr_64994_65013[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64991 === (6))){
var state_64990__$1 = state_64990;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64990__$1,(9),arg);
} else {
if((state_val_64991 === (3))){
var inst_64988 = (state_64990[(2)]);
var state_64990__$1 = state_64990;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64990__$1,inst_64988);
} else {
if((state_val_64991 === (2))){
var _ = (function (){var statearr_64996 = state_64990;
(statearr_64996[(4)] = cljs.core.cons.call(null,(5),(state_64990[(4)])));

return statearr_64996;
})();
var inst_64967 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_64990__$1 = state_64990;
if(inst_64967){
var statearr_64997_65014 = state_64990__$1;
(statearr_64997_65014[(1)] = (6));

} else {
var statearr_64998_65015 = state_64990__$1;
(statearr_64998_65015[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64991 === (9))){
var inst_64970 = (state_64990[(2)]);
var inst_64971 = fluree.db.util.async.throw_err.call(null,inst_64970);
var state_64990__$1 = state_64990;
var statearr_64999_65016 = state_64990__$1;
(statearr_64999_65016[(2)] = inst_64971);

(statearr_64999_65016[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64991 === (5))){
var _ = (function (){var statearr_65000 = state_64990;
(statearr_65000[(4)] = cljs.core.rest.call(null,(state_64990[(4)])));

return statearr_65000;
})();
var state_64990__$1 = state_64990;
var ex64995 = (state_64990__$1[(2)]);
var statearr_65001_65017 = state_64990__$1;
(statearr_65001_65017[(5)] = ex64995);


if((ex64995 instanceof Error)){
var statearr_65002_65018 = state_64990__$1;
(statearr_65002_65018[(1)] = (4));

(statearr_65002_65018[(5)] = null);

} else {
throw ex64995;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64991 === (8))){
var inst_64974 = (state_64990[(2)]);
var inst_64975 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_64974);
var inst_64976 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64977 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64978 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64979 = [inst_64974];
var inst_64980 = (new cljs.core.PersistentVector(null,1,(5),inst_64978,inst_64979,null));
var inst_64981 = ["empty?",inst_64980,inst_64975];
var inst_64982 = cljs.core.PersistentHashMap.fromArrays(inst_64977,inst_64981);
var inst_64983 = [inst_64982,(10)];
var inst_64984 = (new cljs.core.PersistentVector(null,2,(5),inst_64976,inst_64983,null));
var inst_64985 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64984);
var _ = (function (){var statearr_65003 = state_64990;
(statearr_65003[(4)] = cljs.core.rest.call(null,(state_64990[(4)])));

return statearr_65003;
})();
var state_64990__$1 = (function (){var statearr_65004 = state_64990;
(statearr_65004[(7)] = inst_64985);

return statearr_65004;
})();
var statearr_65005_65019 = state_64990__$1;
(statearr_65005_65019[(2)] = inst_64975);

(statearr_65005_65019[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11469__auto____0 = (function (){
var statearr_65006 = [null,null,null,null,null,null,null,null];
(statearr_65006[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11469__auto__);

(statearr_65006[(1)] = (1));

return statearr_65006;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11469__auto____1 = (function (state_64990){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_64990);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e65007){var ex__11472__auto__ = e65007;
var statearr_65008_65020 = state_64990;
(statearr_65008_65020[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_64990[(4)]))){
var statearr_65009_65021 = state_64990;
(statearr_65009_65021[(1)] = cljs.core.first.call(null,(state_64990[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65022 = state_64990;
state_64990 = G__65022;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11469__auto__ = function(state_64990){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11469__auto____1.call(this,state_64990);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_65010 = f__11543__auto__.call(null);
(statearr_65010[(6)] = c__11542__auto__);

return statearr_65010;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4742__auto__ = [];
var len__4736__auto___65067 = arguments.length;
var i__4737__auto___65068 = (0);
while(true){
if((i__4737__auto___65068 < len__4736__auto___65067)){
args__4742__auto__.push((arguments[i__4737__auto___65068]));

var G__65069 = (i__4737__auto___65068 + (1));
i__4737__auto___65068 = G__65069;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_65050){
var state_val_65051 = (state_65050[(1)]);
if((state_val_65051 === (1))){
var state_65050__$1 = state_65050;
var statearr_65052_65070 = state_65050__$1;
(statearr_65052_65070[(2)] = null);

(statearr_65052_65070[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65051 === (2))){
var _ = (function (){var statearr_65053 = state_65050;
(statearr_65053[(4)] = cljs.core.cons.call(null,(5),(state_65050[(4)])));

return statearr_65053;
})();
var inst_65031 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_65050__$1 = state_65050;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65050__$1,(6),inst_65031);
} else {
if((state_val_65051 === (3))){
var inst_65048 = (state_65050[(2)]);
var state_65050__$1 = state_65050;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65050__$1,inst_65048);
} else {
if((state_val_65051 === (4))){
var inst_65025 = (state_65050[(2)]);
var state_65050__$1 = state_65050;
var statearr_65055_65071 = state_65050__$1;
(statearr_65055_65071[(2)] = inst_65025);

(statearr_65055_65071[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65051 === (5))){
var _ = (function (){var statearr_65056 = state_65050;
(statearr_65056[(4)] = cljs.core.rest.call(null,(state_65050[(4)])));

return statearr_65056;
})();
var state_65050__$1 = state_65050;
var ex65054 = (state_65050__$1[(2)]);
var statearr_65057_65072 = state_65050__$1;
(statearr_65057_65072[(5)] = ex65054);


if((ex65054 instanceof Error)){
var statearr_65058_65073 = state_65050__$1;
(statearr_65058_65073[(1)] = (4));

(statearr_65058_65073[(5)] = null);

} else {
throw ex65054;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65051 === (6))){
var inst_65033 = (state_65050[(2)]);
var inst_65034 = fluree.db.util.async.throw_err.call(null,inst_65033);
var inst_65035 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.str,inst_65034);
var inst_65036 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65037 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65038 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65039 = [inst_65034];
var inst_65040 = (new cljs.core.PersistentVector(null,1,(5),inst_65038,inst_65039,null));
var inst_65041 = ["str",inst_65040,inst_65035];
var inst_65042 = cljs.core.PersistentHashMap.fromArrays(inst_65037,inst_65041);
var inst_65043 = [inst_65042,(10)];
var inst_65044 = (new cljs.core.PersistentVector(null,2,(5),inst_65036,inst_65043,null));
var inst_65045 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65044);
var _ = (function (){var statearr_65059 = state_65050;
(statearr_65059[(4)] = cljs.core.rest.call(null,(state_65050[(4)])));

return statearr_65059;
})();
var state_65050__$1 = (function (){var statearr_65060 = state_65050;
(statearr_65060[(7)] = inst_65045);

return statearr_65060;
})();
var statearr_65061_65074 = state_65050__$1;
(statearr_65061_65074[(2)] = inst_65035);

(statearr_65061_65074[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11469__auto____0 = (function (){
var statearr_65062 = [null,null,null,null,null,null,null,null];
(statearr_65062[(0)] = fluree$db$dbfunctions$fns$state_machine__11469__auto__);

(statearr_65062[(1)] = (1));

return statearr_65062;
});
var fluree$db$dbfunctions$fns$state_machine__11469__auto____1 = (function (state_65050){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_65050);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e65063){var ex__11472__auto__ = e65063;
var statearr_65064_65075 = state_65050;
(statearr_65064_65075[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_65050[(4)]))){
var statearr_65065_65076 = state_65050;
(statearr_65065_65076[(1)] = cljs.core.first.call(null,(state_65050[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65077 = state_65050;
state_65050 = G__65077;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11469__auto__ = function(state_65050){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____1.call(this,state_65050);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_65066 = f__11543__auto__.call(null);
(statearr_65066[(6)] = c__11542__auto__);

return statearr_65066;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq65023){
var G__65024 = cljs.core.first.call(null,seq65023);
var seq65023__$1 = cljs.core.next.call(null,seq65023);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65024,seq65023__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_65103){
var state_val_65104 = (state_65103[(1)]);
if((state_val_65104 === (1))){
var state_65103__$1 = state_65103;
var statearr_65105_65120 = state_65103__$1;
(statearr_65105_65120[(2)] = null);

(statearr_65105_65120[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65104 === (2))){
var _ = (function (){var statearr_65106 = state_65103;
(statearr_65106[(4)] = cljs.core.cons.call(null,(5),(state_65103[(4)])));

return statearr_65106;
})();
var inst_65084 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_65103__$1 = state_65103;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65103__$1,(6),inst_65084);
} else {
if((state_val_65104 === (3))){
var inst_65101 = (state_65103[(2)]);
var state_65103__$1 = state_65103;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65103__$1,inst_65101);
} else {
if((state_val_65104 === (4))){
var inst_65078 = (state_65103[(2)]);
var state_65103__$1 = state_65103;
var statearr_65108_65121 = state_65103__$1;
(statearr_65108_65121[(2)] = inst_65078);

(statearr_65108_65121[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65104 === (5))){
var _ = (function (){var statearr_65109 = state_65103;
(statearr_65109[(4)] = cljs.core.rest.call(null,(state_65103[(4)])));

return statearr_65109;
})();
var state_65103__$1 = state_65103;
var ex65107 = (state_65103__$1[(2)]);
var statearr_65110_65122 = state_65103__$1;
(statearr_65110_65122[(5)] = ex65107);


if((ex65107 instanceof Error)){
var statearr_65111_65123 = state_65103__$1;
(statearr_65111_65123[(1)] = (4));

(statearr_65111_65123[(5)] = null);

} else {
throw ex65107;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65104 === (6))){
var inst_65086 = (state_65103[(2)]);
var inst_65087 = fluree.db.util.async.throw_err.call(null,inst_65086);
var inst_65088 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.subs,inst_65087);
var inst_65089 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65090 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65091 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65092 = [inst_65087];
var inst_65093 = (new cljs.core.PersistentVector(null,1,(5),inst_65091,inst_65092,null));
var inst_65094 = ["subs",inst_65093,inst_65088];
var inst_65095 = cljs.core.PersistentHashMap.fromArrays(inst_65090,inst_65094);
var inst_65096 = [inst_65095,(30)];
var inst_65097 = (new cljs.core.PersistentVector(null,2,(5),inst_65089,inst_65096,null));
var inst_65098 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65097);
var _ = (function (){var statearr_65112 = state_65103;
(statearr_65112[(4)] = cljs.core.rest.call(null,(state_65103[(4)])));

return statearr_65112;
})();
var state_65103__$1 = (function (){var statearr_65113 = state_65103;
(statearr_65113[(7)] = inst_65098);

return statearr_65113;
})();
var statearr_65114_65124 = state_65103__$1;
(statearr_65114_65124[(2)] = inst_65088);

(statearr_65114_65124[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__11469__auto____0 = (function (){
var statearr_65115 = [null,null,null,null,null,null,null,null];
(statearr_65115[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__11469__auto__);

(statearr_65115[(1)] = (1));

return statearr_65115;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__11469__auto____1 = (function (state_65103){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_65103);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e65116){var ex__11472__auto__ = e65116;
var statearr_65117_65125 = state_65103;
(statearr_65117_65125[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_65103[(4)]))){
var statearr_65118_65126 = state_65103;
(statearr_65118_65126[(1)] = cljs.core.first.call(null,(state_65103[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65127 = state_65103;
state_65103 = G__65127;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__11469__auto__ = function(state_65103){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__11469__auto____1.call(this,state_65103);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_65119 = f__11543__auto__.call(null);
(statearr_65119[(6)] = c__11542__auto__);

return statearr_65119;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_65157){
var state_val_65158 = (state_65157[(1)]);
if((state_val_65158 === (7))){
var state_65157__$1 = state_65157;
var statearr_65159_65178 = state_65157__$1;
(statearr_65159_65178[(2)] = str);

(statearr_65159_65178[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65158 === (1))){
var state_65157__$1 = state_65157;
var statearr_65160_65179 = state_65157__$1;
(statearr_65160_65179[(2)] = null);

(statearr_65160_65179[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65158 === (4))){
var inst_65128 = (state_65157[(2)]);
var state_65157__$1 = state_65157;
var statearr_65161_65180 = state_65157__$1;
(statearr_65161_65180[(2)] = inst_65128);

(statearr_65161_65180[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65158 === (6))){
var state_65157__$1 = state_65157;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65157__$1,(9),str);
} else {
if((state_val_65158 === (3))){
var inst_65155 = (state_65157[(2)]);
var state_65157__$1 = state_65157;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65157__$1,inst_65155);
} else {
if((state_val_65158 === (2))){
var _ = (function (){var statearr_65163 = state_65157;
(statearr_65163[(4)] = cljs.core.cons.call(null,(5),(state_65157[(4)])));

return statearr_65163;
})();
var inst_65134 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_65157__$1 = state_65157;
if(inst_65134){
var statearr_65164_65181 = state_65157__$1;
(statearr_65164_65181[(1)] = (6));

} else {
var statearr_65165_65182 = state_65157__$1;
(statearr_65165_65182[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65158 === (9))){
var inst_65137 = (state_65157[(2)]);
var inst_65138 = fluree.db.util.async.throw_err.call(null,inst_65137);
var state_65157__$1 = state_65157;
var statearr_65166_65183 = state_65157__$1;
(statearr_65166_65183[(2)] = inst_65138);

(statearr_65166_65183[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65158 === (5))){
var _ = (function (){var statearr_65167 = state_65157;
(statearr_65167[(4)] = cljs.core.rest.call(null,(state_65157[(4)])));

return statearr_65167;
})();
var state_65157__$1 = state_65157;
var ex65162 = (state_65157__$1[(2)]);
var statearr_65168_65184 = state_65157__$1;
(statearr_65168_65184[(5)] = ex65162);


if((ex65162 instanceof Error)){
var statearr_65169_65185 = state_65157__$1;
(statearr_65169_65185[(1)] = (4));

(statearr_65169_65185[(5)] = null);

} else {
throw ex65162;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65158 === (8))){
var inst_65141 = (state_65157[(2)]);
var inst_65142 = fluree.db.dbfunctions.internal.lower_case.call(null,inst_65141);
var inst_65143 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65144 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65145 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65146 = [inst_65141];
var inst_65147 = (new cljs.core.PersistentVector(null,1,(5),inst_65145,inst_65146,null));
var inst_65148 = ["lower-case",inst_65147,inst_65142];
var inst_65149 = cljs.core.PersistentHashMap.fromArrays(inst_65144,inst_65148);
var inst_65150 = [inst_65149,(10)];
var inst_65151 = (new cljs.core.PersistentVector(null,2,(5),inst_65143,inst_65150,null));
var inst_65152 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65151);
var _ = (function (){var statearr_65170 = state_65157;
(statearr_65170[(4)] = cljs.core.rest.call(null,(state_65157[(4)])));

return statearr_65170;
})();
var state_65157__$1 = (function (){var statearr_65171 = state_65157;
(statearr_65171[(7)] = inst_65152);

return statearr_65171;
})();
var statearr_65172_65186 = state_65157__$1;
(statearr_65172_65186[(2)] = inst_65142);

(statearr_65172_65186[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__11469__auto____0 = (function (){
var statearr_65173 = [null,null,null,null,null,null,null,null];
(statearr_65173[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__11469__auto__);

(statearr_65173[(1)] = (1));

return statearr_65173;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__11469__auto____1 = (function (state_65157){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_65157);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e65174){var ex__11472__auto__ = e65174;
var statearr_65175_65187 = state_65157;
(statearr_65175_65187[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_65157[(4)]))){
var statearr_65176_65188 = state_65157;
(statearr_65176_65188[(1)] = cljs.core.first.call(null,(state_65157[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65189 = state_65157;
state_65157 = G__65189;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__11469__auto__ = function(state_65157){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__11469__auto____1.call(this,state_65157);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_65177 = f__11543__auto__.call(null);
(statearr_65177[(6)] = c__11542__auto__);

return statearr_65177;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_65219){
var state_val_65220 = (state_65219[(1)]);
if((state_val_65220 === (7))){
var state_65219__$1 = state_65219;
var statearr_65221_65240 = state_65219__$1;
(statearr_65221_65240[(2)] = str);

(statearr_65221_65240[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65220 === (1))){
var state_65219__$1 = state_65219;
var statearr_65222_65241 = state_65219__$1;
(statearr_65222_65241[(2)] = null);

(statearr_65222_65241[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65220 === (4))){
var inst_65190 = (state_65219[(2)]);
var state_65219__$1 = state_65219;
var statearr_65223_65242 = state_65219__$1;
(statearr_65223_65242[(2)] = inst_65190);

(statearr_65223_65242[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65220 === (6))){
var state_65219__$1 = state_65219;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65219__$1,(9),str);
} else {
if((state_val_65220 === (3))){
var inst_65217 = (state_65219[(2)]);
var state_65219__$1 = state_65219;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65219__$1,inst_65217);
} else {
if((state_val_65220 === (2))){
var _ = (function (){var statearr_65225 = state_65219;
(statearr_65225[(4)] = cljs.core.cons.call(null,(5),(state_65219[(4)])));

return statearr_65225;
})();
var inst_65196 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_65219__$1 = state_65219;
if(inst_65196){
var statearr_65226_65243 = state_65219__$1;
(statearr_65226_65243[(1)] = (6));

} else {
var statearr_65227_65244 = state_65219__$1;
(statearr_65227_65244[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65220 === (9))){
var inst_65199 = (state_65219[(2)]);
var inst_65200 = fluree.db.util.async.throw_err.call(null,inst_65199);
var state_65219__$1 = state_65219;
var statearr_65228_65245 = state_65219__$1;
(statearr_65228_65245[(2)] = inst_65200);

(statearr_65228_65245[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65220 === (5))){
var _ = (function (){var statearr_65229 = state_65219;
(statearr_65229[(4)] = cljs.core.rest.call(null,(state_65219[(4)])));

return statearr_65229;
})();
var state_65219__$1 = state_65219;
var ex65224 = (state_65219__$1[(2)]);
var statearr_65230_65246 = state_65219__$1;
(statearr_65230_65246[(5)] = ex65224);


if((ex65224 instanceof Error)){
var statearr_65231_65247 = state_65219__$1;
(statearr_65231_65247[(1)] = (4));

(statearr_65231_65247[(5)] = null);

} else {
throw ex65224;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65220 === (8))){
var inst_65203 = (state_65219[(2)]);
var inst_65204 = fluree.db.dbfunctions.internal.upper_case.call(null,inst_65203);
var inst_65205 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65206 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65207 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65208 = [inst_65203];
var inst_65209 = (new cljs.core.PersistentVector(null,1,(5),inst_65207,inst_65208,null));
var inst_65210 = ["upper-case",inst_65209,inst_65204];
var inst_65211 = cljs.core.PersistentHashMap.fromArrays(inst_65206,inst_65210);
var inst_65212 = [inst_65211,(10)];
var inst_65213 = (new cljs.core.PersistentVector(null,2,(5),inst_65205,inst_65212,null));
var inst_65214 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65213);
var _ = (function (){var statearr_65232 = state_65219;
(statearr_65232[(4)] = cljs.core.rest.call(null,(state_65219[(4)])));

return statearr_65232;
})();
var state_65219__$1 = (function (){var statearr_65233 = state_65219;
(statearr_65233[(7)] = inst_65214);

return statearr_65233;
})();
var statearr_65234_65248 = state_65219__$1;
(statearr_65234_65248[(2)] = inst_65204);

(statearr_65234_65248[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__11469__auto____0 = (function (){
var statearr_65235 = [null,null,null,null,null,null,null,null];
(statearr_65235[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__11469__auto__);

(statearr_65235[(1)] = (1));

return statearr_65235;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__11469__auto____1 = (function (state_65219){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_65219);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e65236){var ex__11472__auto__ = e65236;
var statearr_65237_65249 = state_65219;
(statearr_65237_65249[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_65219[(4)]))){
var statearr_65238_65250 = state_65219;
(statearr_65238_65250[(1)] = cljs.core.first.call(null,(state_65219[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65251 = state_65219;
state_65219 = G__65251;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__11469__auto__ = function(state_65219){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__11469__auto____1.call(this,state_65219);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_65239 = f__11543__auto__.call(null);
(statearr_65239[(6)] = c__11542__auto__);

return statearr_65239;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4115__auto__)){
return (!(typeof cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__4115__auto__;
}
})())){
var res = cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__65253 = arguments.length;
switch (G__65253) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_65281){
var state_val_65282 = (state_65281[(1)]);
if((state_val_65282 === (1))){
var state_65281__$1 = state_65281;
var statearr_65283_65299 = state_65281__$1;
(statearr_65283_65299[(2)] = null);

(statearr_65283_65299[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65282 === (2))){
var _ = (function (){var statearr_65284 = state_65281;
(statearr_65284[(4)] = cljs.core.cons.call(null,(5),(state_65281[(4)])));

return statearr_65284;
})();
var inst_65263 = fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,additional_select);
var state_65281__$1 = state_65281;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65281__$1,(6),inst_65263);
} else {
if((state_val_65282 === (3))){
var inst_65279 = (state_65281[(2)]);
var state_65281__$1 = state_65281;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65281__$1,inst_65279);
} else {
if((state_val_65282 === (4))){
var inst_65254 = (state_65281[(2)]);
var state_65281__$1 = state_65281;
var statearr_65286_65300 = state_65281__$1;
(statearr_65286_65300[(2)] = inst_65254);

(statearr_65286_65300[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65282 === (5))){
var _ = (function (){var statearr_65287 = state_65281;
(statearr_65287[(4)] = cljs.core.rest.call(null,(state_65281[(4)])));

return statearr_65287;
})();
var state_65281__$1 = state_65281;
var ex65285 = (state_65281__$1[(2)]);
var statearr_65288_65301 = state_65281__$1;
(statearr_65288_65301[(5)] = ex65285);


if((ex65285 instanceof Error)){
var statearr_65289_65302 = state_65281__$1;
(statearr_65289_65302[(1)] = (4));

(statearr_65289_65302[(5)] = null);

} else {
throw ex65285;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65282 === (6))){
var inst_65265 = (state_65281[(2)]);
var inst_65266 = fluree.db.util.async.throw_err.call(null,inst_65265);
var inst_65267 = cljs.core.nth.call(null,inst_65266,(0),null);
var inst_65268 = cljs.core.nth.call(null,inst_65266,(1),null);
var inst_65269 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65270 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65271 = ["?s","?ctx",inst_65267];
var inst_65272 = cljs.core.PersistentHashMap.fromArrays(inst_65270,inst_65271);
var inst_65273 = ((10) + inst_65268);
var inst_65274 = [inst_65272,inst_65273];
var inst_65275 = (new cljs.core.PersistentVector(null,2,(5),inst_65269,inst_65274,null));
var inst_65276 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65275);
var _ = (function (){var statearr_65290 = state_65281;
(statearr_65290[(4)] = cljs.core.rest.call(null,(state_65281[(4)])));

return statearr_65290;
})();
var state_65281__$1 = (function (){var statearr_65291 = state_65281;
(statearr_65291[(7)] = inst_65276);

return statearr_65291;
})();
var statearr_65292_65303 = state_65281__$1;
(statearr_65292_65303[(2)] = inst_65267);

(statearr_65292_65303[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11469__auto____0 = (function (){
var statearr_65293 = [null,null,null,null,null,null,null,null];
(statearr_65293[(0)] = fluree$db$dbfunctions$fns$state_machine__11469__auto__);

(statearr_65293[(1)] = (1));

return statearr_65293;
});
var fluree$db$dbfunctions$fns$state_machine__11469__auto____1 = (function (state_65281){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_65281);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e65294){var ex__11472__auto__ = e65294;
var statearr_65295_65304 = state_65281;
(statearr_65295_65304[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_65281[(4)]))){
var statearr_65296_65305 = state_65281;
(statearr_65296_65305[(1)] = cljs.core.first.call(null,(state_65281[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65306 = state_65281;
state_65281 = G__65306;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11469__auto__ = function(state_65281){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____1.call(this,state_65281);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_65297 = f__11543__auto__.call(null);
(statearr_65297[(6)] = c__11542__auto__);

return statearr_65297;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__65308 = arguments.length;
switch (G__65308) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_65346){
var state_val_65347 = (state_65346[(1)]);
if((state_val_65347 === (7))){
var inst_65339 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?p from this function interface");
var state_65346__$1 = state_65346;
var statearr_65348_65368 = state_65346__$1;
(statearr_65348_65368[(2)] = inst_65339);

(statearr_65348_65368[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65347 === (1))){
var state_65346__$1 = state_65346;
var statearr_65349_65369 = state_65346__$1;
(statearr_65349_65369[(2)] = null);

(statearr_65349_65369[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65347 === (4))){
var inst_65309 = (state_65346[(2)]);
var state_65346__$1 = state_65346;
var statearr_65350_65370 = state_65346__$1;
(statearr_65350_65370[(2)] = inst_65309);

(statearr_65350_65370[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65347 === (6))){
var inst_65320 = fluree.db.dbfunctions.fns.coerce_args.call(null,additional_select);
var state_65346__$1 = state_65346;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65346__$1,(10),inst_65320);
} else {
if((state_val_65347 === (3))){
var inst_65344 = (state_65346[(2)]);
var state_65346__$1 = state_65346;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65346__$1,inst_65344);
} else {
if((state_val_65347 === (2))){
var _ = (function (){var statearr_65352 = state_65346;
(statearr_65352[(4)] = cljs.core.cons.call(null,(5),(state_65346[(4)])));

return statearr_65352;
})();
var inst_65315 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_65346__$1 = state_65346;
if(cljs.core.truth_(inst_65315)){
var statearr_65353_65371 = state_65346__$1;
(statearr_65353_65371[(1)] = (6));

} else {
var statearr_65354_65372 = state_65346__$1;
(statearr_65354_65372[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65347 === (9))){
var inst_65326 = (state_65346[(2)]);
var inst_65327 = fluree.db.util.async.throw_err.call(null,inst_65326);
var inst_65328 = cljs.core.nth.call(null,inst_65327,(0),null);
var inst_65329 = cljs.core.nth.call(null,inst_65327,(1),null);
var inst_65330 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65331 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65332 = ["?p","?ctx",inst_65328];
var inst_65333 = cljs.core.PersistentHashMap.fromArrays(inst_65331,inst_65332);
var inst_65334 = ((10) + inst_65329);
var inst_65335 = [inst_65333,inst_65334];
var inst_65336 = (new cljs.core.PersistentVector(null,2,(5),inst_65330,inst_65335,null));
var inst_65337 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65336);
var state_65346__$1 = (function (){var statearr_65355 = state_65346;
(statearr_65355[(7)] = inst_65337);

return statearr_65355;
})();
var statearr_65356_65373 = state_65346__$1;
(statearr_65356_65373[(2)] = inst_65328);

(statearr_65356_65373[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65347 === (5))){
var _ = (function (){var statearr_65357 = state_65346;
(statearr_65357[(4)] = cljs.core.rest.call(null,(state_65346[(4)])));

return statearr_65357;
})();
var state_65346__$1 = state_65346;
var ex65351 = (state_65346__$1[(2)]);
var statearr_65358_65374 = state_65346__$1;
(statearr_65358_65374[(5)] = ex65351);


if((ex65351 instanceof Error)){
var statearr_65359_65375 = state_65346__$1;
(statearr_65359_65375[(1)] = (4));

(statearr_65359_65375[(5)] = null);

} else {
throw ex65351;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65347 === (10))){
var inst_65322 = (state_65346[(2)]);
var inst_65323 = fluree.db.util.async.throw_err.call(null,inst_65322);
var inst_65324 = fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,inst_65323);
var state_65346__$1 = state_65346;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65346__$1,(9),inst_65324);
} else {
if((state_val_65347 === (8))){
var inst_65341 = (state_65346[(2)]);
var _ = (function (){var statearr_65360 = state_65346;
(statearr_65360[(4)] = cljs.core.rest.call(null,(state_65346[(4)])));

return statearr_65360;
})();
var state_65346__$1 = state_65346;
var statearr_65361_65376 = state_65346__$1;
(statearr_65361_65376[(2)] = inst_65341);

(statearr_65361_65376[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11469__auto____0 = (function (){
var statearr_65362 = [null,null,null,null,null,null,null,null];
(statearr_65362[(0)] = fluree$db$dbfunctions$fns$state_machine__11469__auto__);

(statearr_65362[(1)] = (1));

return statearr_65362;
});
var fluree$db$dbfunctions$fns$state_machine__11469__auto____1 = (function (state_65346){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_65346);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e65363){var ex__11472__auto__ = e65363;
var statearr_65364_65377 = state_65346;
(statearr_65364_65377[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_65346[(4)]))){
var statearr_65365_65378 = state_65346;
(statearr_65365_65378[(1)] = cljs.core.first.call(null,(state_65346[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65379 = state_65346;
state_65346 = G__65379;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11469__auto__ = function(state_65346){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____1.call(this,state_65346);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_65366 = f__11543__auto__.call(null);
(statearr_65366[(6)] = c__11542__auto__);

return statearr_65366;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4742__auto__ = [];
var len__4736__auto___65428 = arguments.length;
var i__4737__auto___65429 = (0);
while(true){
if((i__4737__auto___65429 < len__4736__auto___65428)){
args__4742__auto__.push((arguments[i__4737__auto___65429]));

var G__65430 = (i__4737__auto___65429 + (1));
i__4737__auto___65429 = G__65430;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_65411){
var state_val_65412 = (state_65411[(1)]);
if((state_val_65412 === (1))){
var state_65411__$1 = state_65411;
var statearr_65413_65431 = state_65411__$1;
(statearr_65413_65431[(2)] = null);

(statearr_65413_65431[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65412 === (2))){
var _ = (function (){var statearr_65414 = state_65411;
(statearr_65414[(4)] = cljs.core.cons.call(null,(5),(state_65411[(4)])));

return statearr_65414;
})();
var inst_65388 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_65411__$1 = state_65411;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65411__$1,(6),inst_65388);
} else {
if((state_val_65412 === (3))){
var inst_65409 = (state_65411[(2)]);
var state_65411__$1 = state_65411;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65411__$1,inst_65409);
} else {
if((state_val_65412 === (4))){
var inst_65382 = (state_65411[(2)]);
var state_65411__$1 = state_65411;
var statearr_65416_65432 = state_65411__$1;
(statearr_65416_65432[(2)] = inst_65382);

(statearr_65416_65432[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65412 === (5))){
var _ = (function (){var statearr_65417 = state_65411;
(statearr_65417[(4)] = cljs.core.rest.call(null,(state_65411[(4)])));

return statearr_65417;
})();
var state_65411__$1 = state_65411;
var ex65415 = (state_65411__$1[(2)]);
var statearr_65418_65433 = state_65411__$1;
(statearr_65418_65433[(5)] = ex65415);


if((ex65415 instanceof Error)){
var statearr_65419_65434 = state_65411__$1;
(statearr_65419_65434[(1)] = (4));

(statearr_65419_65434[(5)] = null);

} else {
throw ex65415;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65412 === (6))){
var inst_65390 = (state_65411[(2)]);
var inst_65391 = fluree.db.util.async.throw_err.call(null,inst_65390);
var inst_65392 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.and,inst_65391);
var inst_65393 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65394 = [inst_65391];
var inst_65395 = (new cljs.core.PersistentVector(null,1,(5),inst_65393,inst_65394,null));
var inst_65396 = cljs.core.count.call(null,inst_65395);
var inst_65397 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65398 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65399 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65400 = [inst_65391];
var inst_65401 = (new cljs.core.PersistentVector(null,1,(5),inst_65399,inst_65400,null));
var inst_65402 = ["and",inst_65401,inst_65392];
var inst_65403 = cljs.core.PersistentHashMap.fromArrays(inst_65398,inst_65402);
var inst_65404 = [inst_65403,inst_65396];
var inst_65405 = (new cljs.core.PersistentVector(null,2,(5),inst_65397,inst_65404,null));
var inst_65406 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65405);
var _ = (function (){var statearr_65420 = state_65411;
(statearr_65420[(4)] = cljs.core.rest.call(null,(state_65411[(4)])));

return statearr_65420;
})();
var state_65411__$1 = (function (){var statearr_65421 = state_65411;
(statearr_65421[(7)] = inst_65406);

return statearr_65421;
})();
var statearr_65422_65435 = state_65411__$1;
(statearr_65422_65435[(2)] = inst_65392);

(statearr_65422_65435[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11469__auto____0 = (function (){
var statearr_65423 = [null,null,null,null,null,null,null,null];
(statearr_65423[(0)] = fluree$db$dbfunctions$fns$state_machine__11469__auto__);

(statearr_65423[(1)] = (1));

return statearr_65423;
});
var fluree$db$dbfunctions$fns$state_machine__11469__auto____1 = (function (state_65411){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_65411);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e65424){var ex__11472__auto__ = e65424;
var statearr_65425_65436 = state_65411;
(statearr_65425_65436[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_65411[(4)]))){
var statearr_65426_65437 = state_65411;
(statearr_65426_65437[(1)] = cljs.core.first.call(null,(state_65411[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65438 = state_65411;
state_65411 = G__65438;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11469__auto__ = function(state_65411){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____1.call(this,state_65411);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_65427 = f__11543__auto__.call(null);
(statearr_65427[(6)] = c__11542__auto__);

return statearr_65427;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq65380){
var G__65381 = cljs.core.first.call(null,seq65380);
var seq65380__$1 = cljs.core.next.call(null,seq65380);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65381,seq65380__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4742__auto__ = [];
var len__4736__auto___65487 = arguments.length;
var i__4737__auto___65488 = (0);
while(true){
if((i__4737__auto___65488 < len__4736__auto___65487)){
args__4742__auto__.push((arguments[i__4737__auto___65488]));

var G__65489 = (i__4737__auto___65488 + (1));
i__4737__auto___65488 = G__65489;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_65470){
var state_val_65471 = (state_65470[(1)]);
if((state_val_65471 === (1))){
var state_65470__$1 = state_65470;
var statearr_65472_65490 = state_65470__$1;
(statearr_65472_65490[(2)] = null);

(statearr_65472_65490[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65471 === (2))){
var _ = (function (){var statearr_65473 = state_65470;
(statearr_65473[(4)] = cljs.core.cons.call(null,(5),(state_65470[(4)])));

return statearr_65473;
})();
var inst_65447 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_65470__$1 = state_65470;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65470__$1,(6),inst_65447);
} else {
if((state_val_65471 === (3))){
var inst_65468 = (state_65470[(2)]);
var state_65470__$1 = state_65470;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65470__$1,inst_65468);
} else {
if((state_val_65471 === (4))){
var inst_65441 = (state_65470[(2)]);
var state_65470__$1 = state_65470;
var statearr_65475_65491 = state_65470__$1;
(statearr_65475_65491[(2)] = inst_65441);

(statearr_65475_65491[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65471 === (5))){
var _ = (function (){var statearr_65476 = state_65470;
(statearr_65476[(4)] = cljs.core.rest.call(null,(state_65470[(4)])));

return statearr_65476;
})();
var state_65470__$1 = state_65470;
var ex65474 = (state_65470__$1[(2)]);
var statearr_65477_65492 = state_65470__$1;
(statearr_65477_65492[(5)] = ex65474);


if((ex65474 instanceof Error)){
var statearr_65478_65493 = state_65470__$1;
(statearr_65478_65493[(1)] = (4));

(statearr_65478_65493[(5)] = null);

} else {
throw ex65474;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65471 === (6))){
var inst_65449 = (state_65470[(2)]);
var inst_65450 = fluree.db.util.async.throw_err.call(null,inst_65449);
var inst_65451 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.or,inst_65450);
var inst_65452 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65453 = [inst_65450];
var inst_65454 = (new cljs.core.PersistentVector(null,1,(5),inst_65452,inst_65453,null));
var inst_65455 = cljs.core.count.call(null,inst_65454);
var inst_65456 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65457 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65458 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65459 = [inst_65450];
var inst_65460 = (new cljs.core.PersistentVector(null,1,(5),inst_65458,inst_65459,null));
var inst_65461 = ["or",inst_65460,inst_65451];
var inst_65462 = cljs.core.PersistentHashMap.fromArrays(inst_65457,inst_65461);
var inst_65463 = [inst_65462,inst_65455];
var inst_65464 = (new cljs.core.PersistentVector(null,2,(5),inst_65456,inst_65463,null));
var inst_65465 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65464);
var _ = (function (){var statearr_65479 = state_65470;
(statearr_65479[(4)] = cljs.core.rest.call(null,(state_65470[(4)])));

return statearr_65479;
})();
var state_65470__$1 = (function (){var statearr_65480 = state_65470;
(statearr_65480[(7)] = inst_65465);

return statearr_65480;
})();
var statearr_65481_65494 = state_65470__$1;
(statearr_65481_65494[(2)] = inst_65451);

(statearr_65481_65494[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11469__auto____0 = (function (){
var statearr_65482 = [null,null,null,null,null,null,null,null];
(statearr_65482[(0)] = fluree$db$dbfunctions$fns$state_machine__11469__auto__);

(statearr_65482[(1)] = (1));

return statearr_65482;
});
var fluree$db$dbfunctions$fns$state_machine__11469__auto____1 = (function (state_65470){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_65470);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e65483){var ex__11472__auto__ = e65483;
var statearr_65484_65495 = state_65470;
(statearr_65484_65495[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_65470[(4)]))){
var statearr_65485_65496 = state_65470;
(statearr_65485_65496[(1)] = cljs.core.first.call(null,(state_65470[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65497 = state_65470;
state_65470 = G__65497;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11469__auto__ = function(state_65470){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____1.call(this,state_65470);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_65486 = f__11543__auto__.call(null);
(statearr_65486[(6)] = c__11542__auto__);

return statearr_65486;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq65439){
var G__65440 = cljs.core.first.call(null,seq65439);
var seq65439__$1 = cljs.core.next.call(null,seq65439);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65440,seq65439__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_65535){
var state_val_65536 = (state_65535[(1)]);
if((state_val_65536 === (7))){
var inst_65511 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_65535__$1 = state_65535;
if(inst_65511){
var statearr_65537_65560 = state_65535__$1;
(statearr_65537_65560[(1)] = (10));

} else {
var statearr_65538_65561 = state_65535__$1;
(statearr_65538_65561[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65536 === (1))){
var state_65535__$1 = state_65535;
var statearr_65539_65562 = state_65535__$1;
(statearr_65539_65562[(2)] = null);

(statearr_65539_65562[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65536 === (4))){
var inst_65498 = (state_65535[(2)]);
var state_65535__$1 = state_65535;
var statearr_65540_65563 = state_65535__$1;
(statearr_65540_65563[(2)] = inst_65498);

(statearr_65540_65563[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65536 === (13))){
var inst_65514 = (state_65535[(2)]);
var inst_65515 = fluree.db.util.async.throw_err.call(null,inst_65514);
var state_65535__$1 = state_65535;
var statearr_65541_65564 = state_65535__$1;
(statearr_65541_65564[(2)] = inst_65515);

(statearr_65541_65564[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65536 === (6))){
var inst_65506 = fluree.db.dbfunctions.fns.coerce_args.call(null,coll);
var state_65535__$1 = state_65535;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65535__$1,(9),inst_65506);
} else {
if((state_val_65536 === (3))){
var inst_65533 = (state_65535[(2)]);
var state_65535__$1 = state_65535;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65535__$1,inst_65533);
} else {
if((state_val_65536 === (12))){
var inst_65518 = (state_65535[(2)]);
var state_65535__$1 = state_65535;
var statearr_65542_65565 = state_65535__$1;
(statearr_65542_65565[(2)] = inst_65518);

(statearr_65542_65565[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65536 === (2))){
var _ = (function (){var statearr_65543 = state_65535;
(statearr_65543[(4)] = cljs.core.cons.call(null,(5),(state_65535[(4)])));

return statearr_65543;
})();
var inst_65504 = cljs.core.vector_QMARK_.call(null,coll);
var state_65535__$1 = state_65535;
if(inst_65504){
var statearr_65544_65566 = state_65535__$1;
(statearr_65544_65566[(1)] = (6));

} else {
var statearr_65545_65567 = state_65535__$1;
(statearr_65545_65567[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65536 === (11))){
var state_65535__$1 = state_65535;
var statearr_65547_65568 = state_65535__$1;
(statearr_65547_65568[(2)] = coll);

(statearr_65547_65568[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65536 === (9))){
var inst_65508 = (state_65535[(2)]);
var inst_65509 = fluree.db.util.async.throw_err.call(null,inst_65508);
var state_65535__$1 = state_65535;
var statearr_65548_65569 = state_65535__$1;
(statearr_65548_65569[(2)] = inst_65509);

(statearr_65548_65569[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65536 === (5))){
var _ = (function (){var statearr_65549 = state_65535;
(statearr_65549[(4)] = cljs.core.rest.call(null,(state_65535[(4)])));

return statearr_65549;
})();
var state_65535__$1 = state_65535;
var ex65546 = (state_65535__$1[(2)]);
var statearr_65550_65570 = state_65535__$1;
(statearr_65550_65570[(5)] = ex65546);


if((ex65546 instanceof Error)){
var statearr_65551_65571 = state_65535__$1;
(statearr_65551_65571[(1)] = (4));

(statearr_65551_65571[(5)] = null);

} else {
throw ex65546;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65536 === (10))){
var state_65535__$1 = state_65535;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65535__$1,(13),coll);
} else {
if((state_val_65536 === (8))){
var inst_65520 = (state_65535[(2)]);
var inst_65521 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_65520);
var inst_65522 = cljs.core.count.call(null,inst_65521);
var inst_65523 = ((9) + inst_65522);
var inst_65524 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65525 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65526 = ["count",inst_65520,inst_65522];
var inst_65527 = cljs.core.PersistentHashMap.fromArrays(inst_65525,inst_65526);
var inst_65528 = [inst_65527,inst_65523];
var inst_65529 = (new cljs.core.PersistentVector(null,2,(5),inst_65524,inst_65528,null));
var inst_65530 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65529);
var _ = (function (){var statearr_65552 = state_65535;
(statearr_65552[(4)] = cljs.core.rest.call(null,(state_65535[(4)])));

return statearr_65552;
})();
var state_65535__$1 = (function (){var statearr_65553 = state_65535;
(statearr_65553[(7)] = inst_65530);

return statearr_65553;
})();
var statearr_65554_65572 = state_65535__$1;
(statearr_65554_65572[(2)] = inst_65522);

(statearr_65554_65572[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__11469__auto____0 = (function (){
var statearr_65555 = [null,null,null,null,null,null,null,null];
(statearr_65555[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__11469__auto__);

(statearr_65555[(1)] = (1));

return statearr_65555;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__11469__auto____1 = (function (state_65535){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_65535);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e65556){var ex__11472__auto__ = e65556;
var statearr_65557_65573 = state_65535;
(statearr_65557_65573[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_65535[(4)]))){
var statearr_65558_65574 = state_65535;
(statearr_65558_65574[(1)] = cljs.core.first.call(null,(state_65535[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65575 = state_65535;
state_65535 = G__65575;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__11469__auto__ = function(state_65535){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__11469__auto____1.call(this,state_65535);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_65559 = f__11543__auto__.call(null);
(statearr_65559[(6)] = c__11542__auto__);

return statearr_65559;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_65625){
var state_val_65626 = (state_65625[(1)]);
if((state_val_65626 === (7))){
var state_65625__$1 = state_65625;
var statearr_65627_65660 = state_65625__$1;
(statearr_65627_65660[(2)] = subject);

(statearr_65627_65660[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65626 === (1))){
var state_65625__$1 = state_65625;
var statearr_65628_65661 = state_65625__$1;
(statearr_65628_65661[(2)] = null);

(statearr_65628_65661[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65626 === (4))){
var inst_65576 = (state_65625[(2)]);
var state_65625__$1 = state_65625;
var statearr_65629_65662 = state_65625__$1;
(statearr_65629_65662[(2)] = inst_65576);

(statearr_65629_65662[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65626 === (15))){
var inst_65589 = (state_65625[(7)]);
var state_65625__$1 = state_65625;
var statearr_65630_65663 = state_65625__$1;
(statearr_65630_65663[(2)] = inst_65589);

(statearr_65630_65663[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65626 === (13))){
var inst_65593 = (state_65625[(2)]);
var inst_65594 = fluree.db.util.async.throw_err.call(null,inst_65593);
var state_65625__$1 = state_65625;
var statearr_65631_65664 = state_65625__$1;
(statearr_65631_65664[(2)] = inst_65594);

(statearr_65631_65664[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65626 === (6))){
var state_65625__$1 = state_65625;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65625__$1,(9),subject);
} else {
if((state_val_65626 === (17))){
var inst_65589 = (state_65625[(7)]);
var inst_65603 = cljs.core.first.call(null,inst_65589);
var state_65625__$1 = state_65625;
var statearr_65632_65665 = state_65625__$1;
(statearr_65632_65665[(2)] = inst_65603);

(statearr_65632_65665[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65626 === (3))){
var inst_65623 = (state_65625[(2)]);
var state_65625__$1 = state_65625;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65625__$1,inst_65623);
} else {
if((state_val_65626 === (12))){
var inst_65589 = (state_65625[(7)]);
var inst_65597 = (state_65625[(2)]);
var inst_65598 = cljs.core.vector_QMARK_.call(null,inst_65589);
var state_65625__$1 = (function (){var statearr_65633 = state_65625;
(statearr_65633[(8)] = inst_65597);

return statearr_65633;
})();
if(inst_65598){
var statearr_65634_65666 = state_65625__$1;
(statearr_65634_65666[(1)] = (14));

} else {
var statearr_65635_65667 = state_65625__$1;
(statearr_65635_65667[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65626 === (2))){
var _ = (function (){var statearr_65636 = state_65625;
(statearr_65636[(4)] = cljs.core.cons.call(null,(5),(state_65625[(4)])));

return statearr_65636;
})();
var inst_65582 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_65625__$1 = state_65625;
if(inst_65582){
var statearr_65637_65668 = state_65625__$1;
(statearr_65637_65668[(1)] = (6));

} else {
var statearr_65638_65669 = state_65625__$1;
(statearr_65638_65669[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65626 === (19))){
var inst_65606 = (state_65625[(2)]);
var state_65625__$1 = state_65625;
var statearr_65639_65670 = state_65625__$1;
(statearr_65639_65670[(2)] = inst_65606);

(statearr_65639_65670[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65626 === (11))){
var state_65625__$1 = state_65625;
var statearr_65641_65671 = state_65625__$1;
(statearr_65641_65671[(2)] = pred);

(statearr_65641_65671[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65626 === (9))){
var inst_65585 = (state_65625[(2)]);
var inst_65586 = fluree.db.util.async.throw_err.call(null,inst_65585);
var state_65625__$1 = state_65625;
var statearr_65642_65672 = state_65625__$1;
(statearr_65642_65672[(2)] = inst_65586);

(statearr_65642_65672[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65626 === (5))){
var _ = (function (){var statearr_65643 = state_65625;
(statearr_65643[(4)] = cljs.core.rest.call(null,(state_65625[(4)])));

return statearr_65643;
})();
var state_65625__$1 = state_65625;
var ex65640 = (state_65625__$1[(2)]);
var statearr_65644_65673 = state_65625__$1;
(statearr_65644_65673[(5)] = ex65640);


if((ex65640 instanceof Error)){
var statearr_65645_65674 = state_65625__$1;
(statearr_65645_65674[(1)] = (4));

(statearr_65645_65674[(5)] = null);

} else {
throw ex65640;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65626 === (14))){
var inst_65589 = (state_65625[(7)]);
var inst_65600 = cljs.core.count.call(null,inst_65589);
var inst_65601 = cljs.core._EQ_.call(null,(1),inst_65600);
var state_65625__$1 = state_65625;
if(inst_65601){
var statearr_65646_65675 = state_65625__$1;
(statearr_65646_65675[(1)] = (17));

} else {
var statearr_65647_65676 = state_65625__$1;
(statearr_65647_65676[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65626 === (16))){
var inst_65589 = (state_65625[(7)]);
var inst_65597 = (state_65625[(8)]);
var inst_65609 = (state_65625[(2)]);
var inst_65610 = fluree.db.dbfunctions.internal.get.call(null,inst_65609,inst_65597);
var inst_65611 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65612 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65613 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65614 = [inst_65589,inst_65597];
var inst_65615 = (new cljs.core.PersistentVector(null,2,(5),inst_65613,inst_65614,null));
var inst_65616 = ["get",inst_65615,inst_65610];
var inst_65617 = cljs.core.PersistentHashMap.fromArrays(inst_65612,inst_65616);
var inst_65618 = [inst_65617,(10)];
var inst_65619 = (new cljs.core.PersistentVector(null,2,(5),inst_65611,inst_65618,null));
var inst_65620 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65619);
var _ = (function (){var statearr_65648 = state_65625;
(statearr_65648[(4)] = cljs.core.rest.call(null,(state_65625[(4)])));

return statearr_65648;
})();
var state_65625__$1 = (function (){var statearr_65649 = state_65625;
(statearr_65649[(9)] = inst_65620);

return statearr_65649;
})();
var statearr_65650_65677 = state_65625__$1;
(statearr_65650_65677[(2)] = inst_65610);

(statearr_65650_65677[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65626 === (10))){
var state_65625__$1 = state_65625;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65625__$1,(13),pred);
} else {
if((state_val_65626 === (18))){
var inst_65589 = (state_65625[(7)]);
var state_65625__$1 = state_65625;
var statearr_65651_65678 = state_65625__$1;
(statearr_65651_65678[(2)] = inst_65589);

(statearr_65651_65678[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65626 === (8))){
var inst_65589 = (state_65625[(2)]);
var inst_65590 = fluree.db.util.async.channel_QMARK_.call(null,pred);
var state_65625__$1 = (function (){var statearr_65652 = state_65625;
(statearr_65652[(7)] = inst_65589);

return statearr_65652;
})();
if(inst_65590){
var statearr_65653_65679 = state_65625__$1;
(statearr_65653_65679[(1)] = (10));

} else {
var statearr_65654_65680 = state_65625__$1;
(statearr_65654_65680[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__11469__auto____0 = (function (){
var statearr_65655 = [null,null,null,null,null,null,null,null,null,null];
(statearr_65655[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__11469__auto__);

(statearr_65655[(1)] = (1));

return statearr_65655;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__11469__auto____1 = (function (state_65625){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_65625);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e65656){var ex__11472__auto__ = e65656;
var statearr_65657_65681 = state_65625;
(statearr_65657_65681[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_65625[(4)]))){
var statearr_65658_65682 = state_65625;
(statearr_65658_65682[(1)] = cljs.core.first.call(null,(state_65625[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65683 = state_65625;
state_65625 = G__65683;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__11469__auto__ = function(state_65625){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__11469__auto____1.call(this,state_65625);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_65659 = f__11543__auto__.call(null);
(statearr_65659[(6)] = c__11542__auto__);

return statearr_65659;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_65722){
var state_val_65723 = (state_65722[(1)]);
if((state_val_65723 === (7))){
var inst_65690 = (state_65722[(7)]);
var state_65722__$1 = state_65722;
var statearr_65724_65748 = state_65722__$1;
(statearr_65724_65748[(2)] = inst_65690);

(statearr_65724_65748[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65723 === (1))){
var state_65722__$1 = state_65722;
var statearr_65725_65749 = state_65722__$1;
(statearr_65725_65749[(2)] = null);

(statearr_65725_65749[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65723 === (4))){
var inst_65684 = (state_65722[(2)]);
var state_65722__$1 = state_65722;
var statearr_65726_65750 = state_65722__$1;
(statearr_65726_65750[(2)] = inst_65684);

(statearr_65726_65750[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65723 === (6))){
var inst_65692 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_65722__$1 = state_65722;
var statearr_65727_65751 = state_65722__$1;
(statearr_65727_65751[(2)] = inst_65692);

(statearr_65727_65751[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65723 === (3))){
var inst_65720 = (state_65722[(2)]);
var state_65722__$1 = state_65722;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65722__$1,inst_65720);
} else {
if((state_val_65723 === (12))){
var inst_65702 = (state_65722[(2)]);
var inst_65703 = fluree.db.util.async.throw_err.call(null,inst_65702);
var inst_65704 = cljs.core.nth.call(null,inst_65703,(0),null);
var inst_65705 = cljs.core.nth.call(null,inst_65703,(1),null);
var inst_65706 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65707 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65708 = ["?pO","?ctx",inst_65704];
var inst_65709 = cljs.core.PersistentHashMap.fromArrays(inst_65707,inst_65708);
var inst_65710 = ((10) + inst_65705);
var inst_65711 = [inst_65709,inst_65710];
var inst_65712 = (new cljs.core.PersistentVector(null,2,(5),inst_65706,inst_65711,null));
var inst_65713 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65712);
var state_65722__$1 = (function (){var statearr_65728 = state_65722;
(statearr_65728[(8)] = inst_65713);

return statearr_65728;
})();
var statearr_65729_65752 = state_65722__$1;
(statearr_65729_65752[(2)] = inst_65704);

(statearr_65729_65752[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65723 === (2))){
var inst_65690 = (state_65722[(7)]);
var _ = (function (){var statearr_65730 = state_65722;
(statearr_65730[(4)] = cljs.core.cons.call(null,(5),(state_65722[(4)])));

return statearr_65730;
})();
var inst_65690__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_65722__$1 = (function (){var statearr_65731 = state_65722;
(statearr_65731[(7)] = inst_65690__$1);

return statearr_65731;
})();
if(cljs.core.truth_(inst_65690__$1)){
var statearr_65732_65753 = state_65722__$1;
(statearr_65732_65753[(1)] = (6));

} else {
var statearr_65733_65754 = state_65722__$1;
(statearr_65733_65754[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65723 === (11))){
var inst_65717 = (state_65722[(2)]);
var _ = (function (){var statearr_65735 = state_65722;
(statearr_65735[(4)] = cljs.core.rest.call(null,(state_65722[(4)])));

return statearr_65735;
})();
var state_65722__$1 = state_65722;
var statearr_65736_65755 = state_65722__$1;
(statearr_65736_65755[(2)] = inst_65717);

(statearr_65736_65755[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65723 === (9))){
var inst_65700 = fluree.db.dbfunctions.internal._QMARK_pO.call(null,_QMARK_ctx);
var state_65722__$1 = state_65722;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65722__$1,(12),inst_65700);
} else {
if((state_val_65723 === (5))){
var _ = (function (){var statearr_65737 = state_65722;
(statearr_65737[(4)] = cljs.core.rest.call(null,(state_65722[(4)])));

return statearr_65737;
})();
var state_65722__$1 = state_65722;
var ex65734 = (state_65722__$1[(2)]);
var statearr_65738_65756 = state_65722__$1;
(statearr_65738_65756[(5)] = ex65734);


if((ex65734 instanceof Error)){
var statearr_65739_65757 = state_65722__$1;
(statearr_65739_65757[(1)] = (4));

(statearr_65739_65757[(5)] = null);

} else {
throw ex65734;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65723 === (10))){
var inst_65715 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_65722__$1 = state_65722;
var statearr_65740_65758 = state_65722__$1;
(statearr_65740_65758[(2)] = inst_65715);

(statearr_65740_65758[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65723 === (8))){
var inst_65695 = (state_65722[(2)]);
var state_65722__$1 = state_65722;
if(cljs.core.truth_(inst_65695)){
var statearr_65741_65759 = state_65722__$1;
(statearr_65741_65759[(1)] = (9));

} else {
var statearr_65742_65760 = state_65722__$1;
(statearr_65742_65760[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11469__auto____0 = (function (){
var statearr_65743 = [null,null,null,null,null,null,null,null,null];
(statearr_65743[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11469__auto__);

(statearr_65743[(1)] = (1));

return statearr_65743;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11469__auto____1 = (function (state_65722){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_65722);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e65744){var ex__11472__auto__ = e65744;
var statearr_65745_65761 = state_65722;
(statearr_65745_65761[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_65722[(4)]))){
var statearr_65746_65762 = state_65722;
(statearr_65746_65762[(1)] = cljs.core.first.call(null,(state_65722[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65763 = state_65722;
state_65722 = G__65763;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11469__auto__ = function(state_65722){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11469__auto____1.call(this,state_65722);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_65747 = f__11543__auto__.call(null);
(statearr_65747[(6)] = c__11542__auto__);

return statearr_65747;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_65815){
var state_val_65816 = (state_65815[(1)]);
if((state_val_65816 === (7))){
var state_65815__$1 = state_65815;
var statearr_65817_65850 = state_65815__$1;
(statearr_65817_65850[(2)] = subject);

(statearr_65817_65850[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65816 === (1))){
var state_65815__$1 = state_65815;
var statearr_65818_65851 = state_65815__$1;
(statearr_65818_65851[(2)] = null);

(statearr_65818_65851[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65816 === (4))){
var inst_65764 = (state_65815[(2)]);
var state_65815__$1 = state_65815;
var statearr_65819_65852 = state_65815__$1;
(statearr_65819_65852[(2)] = inst_65764);

(statearr_65819_65852[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65816 === (15))){
var inst_65777 = (state_65815[(7)]);
var state_65815__$1 = state_65815;
var statearr_65820_65853 = state_65815__$1;
(statearr_65820_65853[(2)] = inst_65777);

(statearr_65820_65853[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65816 === (13))){
var inst_65781 = (state_65815[(2)]);
var inst_65782 = fluree.db.util.async.throw_err.call(null,inst_65781);
var state_65815__$1 = state_65815;
var statearr_65821_65854 = state_65815__$1;
(statearr_65821_65854[(2)] = inst_65782);

(statearr_65821_65854[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65816 === (6))){
var state_65815__$1 = state_65815;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65815__$1,(9),subject);
} else {
if((state_val_65816 === (17))){
var inst_65777 = (state_65815[(7)]);
var inst_65791 = cljs.core.first.call(null,inst_65777);
var state_65815__$1 = state_65815;
var statearr_65822_65855 = state_65815__$1;
(statearr_65822_65855[(2)] = inst_65791);

(statearr_65822_65855[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65816 === (3))){
var inst_65813 = (state_65815[(2)]);
var state_65815__$1 = state_65815;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65815__$1,inst_65813);
} else {
if((state_val_65816 === (12))){
var inst_65777 = (state_65815[(7)]);
var inst_65785 = (state_65815[(2)]);
var inst_65786 = cljs.core.vector_QMARK_.call(null,inst_65777);
var state_65815__$1 = (function (){var statearr_65823 = state_65815;
(statearr_65823[(8)] = inst_65785);

return statearr_65823;
})();
if(inst_65786){
var statearr_65824_65856 = state_65815__$1;
(statearr_65824_65856[(1)] = (14));

} else {
var statearr_65825_65857 = state_65815__$1;
(statearr_65825_65857[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65816 === (2))){
var _ = (function (){var statearr_65826 = state_65815;
(statearr_65826[(4)] = cljs.core.cons.call(null,(5),(state_65815[(4)])));

return statearr_65826;
})();
var inst_65770 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_65815__$1 = state_65815;
if(inst_65770){
var statearr_65827_65858 = state_65815__$1;
(statearr_65827_65858[(1)] = (6));

} else {
var statearr_65828_65859 = state_65815__$1;
(statearr_65828_65859[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65816 === (19))){
var inst_65794 = (state_65815[(2)]);
var state_65815__$1 = state_65815;
var statearr_65829_65860 = state_65815__$1;
(statearr_65829_65860[(2)] = inst_65794);

(statearr_65829_65860[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65816 === (11))){
var state_65815__$1 = state_65815;
var statearr_65831_65861 = state_65815__$1;
(statearr_65831_65861[(2)] = path);

(statearr_65831_65861[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65816 === (9))){
var inst_65773 = (state_65815[(2)]);
var inst_65774 = fluree.db.util.async.throw_err.call(null,inst_65773);
var state_65815__$1 = state_65815;
var statearr_65832_65862 = state_65815__$1;
(statearr_65832_65862[(2)] = inst_65774);

(statearr_65832_65862[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65816 === (5))){
var _ = (function (){var statearr_65833 = state_65815;
(statearr_65833[(4)] = cljs.core.rest.call(null,(state_65815[(4)])));

return statearr_65833;
})();
var state_65815__$1 = state_65815;
var ex65830 = (state_65815__$1[(2)]);
var statearr_65834_65863 = state_65815__$1;
(statearr_65834_65863[(5)] = ex65830);


if((ex65830 instanceof Error)){
var statearr_65835_65864 = state_65815__$1;
(statearr_65835_65864[(1)] = (4));

(statearr_65835_65864[(5)] = null);

} else {
throw ex65830;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65816 === (14))){
var inst_65777 = (state_65815[(7)]);
var inst_65788 = cljs.core.count.call(null,inst_65777);
var inst_65789 = cljs.core._EQ_.call(null,(1),inst_65788);
var state_65815__$1 = state_65815;
if(inst_65789){
var statearr_65836_65865 = state_65815__$1;
(statearr_65836_65865[(1)] = (17));

} else {
var statearr_65837_65866 = state_65815__$1;
(statearr_65837_65866[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65816 === (16))){
var inst_65777 = (state_65815[(7)]);
var inst_65785 = (state_65815[(8)]);
var inst_65797 = (state_65815[(2)]);
var inst_65798 = fluree.db.dbfunctions.internal.get_all.call(null,inst_65797,inst_65785);
var inst_65799 = cljs.core.count.call(null,inst_65785);
var inst_65800 = ((9) + inst_65799);
var inst_65801 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65802 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65803 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65804 = [inst_65777,inst_65785];
var inst_65805 = (new cljs.core.PersistentVector(null,2,(5),inst_65803,inst_65804,null));
var inst_65806 = ["get-all",inst_65805,inst_65798];
var inst_65807 = cljs.core.PersistentHashMap.fromArrays(inst_65802,inst_65806);
var inst_65808 = [inst_65807,inst_65800];
var inst_65809 = (new cljs.core.PersistentVector(null,2,(5),inst_65801,inst_65808,null));
var inst_65810 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65809);
var _ = (function (){var statearr_65838 = state_65815;
(statearr_65838[(4)] = cljs.core.rest.call(null,(state_65815[(4)])));

return statearr_65838;
})();
var state_65815__$1 = (function (){var statearr_65839 = state_65815;
(statearr_65839[(9)] = inst_65810);

return statearr_65839;
})();
var statearr_65840_65867 = state_65815__$1;
(statearr_65840_65867[(2)] = inst_65798);

(statearr_65840_65867[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65816 === (10))){
var state_65815__$1 = state_65815;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65815__$1,(13),path);
} else {
if((state_val_65816 === (18))){
var inst_65777 = (state_65815[(7)]);
var state_65815__$1 = state_65815;
var statearr_65841_65868 = state_65815__$1;
(statearr_65841_65868[(2)] = inst_65777);

(statearr_65841_65868[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65816 === (8))){
var inst_65777 = (state_65815[(2)]);
var inst_65778 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_65815__$1 = (function (){var statearr_65842 = state_65815;
(statearr_65842[(7)] = inst_65777);

return statearr_65842;
})();
if(inst_65778){
var statearr_65843_65869 = state_65815__$1;
(statearr_65843_65869[(1)] = (10));

} else {
var statearr_65844_65870 = state_65815__$1;
(statearr_65844_65870[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__11469__auto____0 = (function (){
var statearr_65845 = [null,null,null,null,null,null,null,null,null,null];
(statearr_65845[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__11469__auto__);

(statearr_65845[(1)] = (1));

return statearr_65845;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__11469__auto____1 = (function (state_65815){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_65815);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e65846){var ex__11472__auto__ = e65846;
var statearr_65847_65871 = state_65815;
(statearr_65847_65871[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_65815[(4)]))){
var statearr_65848_65872 = state_65815;
(statearr_65848_65872[(1)] = cljs.core.first.call(null,(state_65815[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65873 = state_65815;
state_65815 = G__65873;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__11469__auto__ = function(state_65815){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__11469__auto____1.call(this,state_65815);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_65849 = f__11543__auto__.call(null);
(statearr_65849[(6)] = c__11542__auto__);

return statearr_65849;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [_QMARK_ctx,subject,path], null);

var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_65912){
var state_val_65913 = (state_65912[(1)]);
if((state_val_65913 === (7))){
var state_65912__$1 = state_65912;
var statearr_65914_65938 = state_65912__$1;
(statearr_65914_65938[(2)] = subject);

(statearr_65914_65938[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65913 === (1))){
var state_65912__$1 = state_65912;
var statearr_65915_65939 = state_65912__$1;
(statearr_65915_65939[(2)] = null);

(statearr_65915_65939[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65913 === (4))){
var inst_65874 = (state_65912[(2)]);
var state_65912__$1 = state_65912;
var statearr_65916_65940 = state_65912__$1;
(statearr_65916_65940[(2)] = inst_65874);

(statearr_65916_65940[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65913 === (13))){
var inst_65891 = (state_65912[(2)]);
var inst_65892 = fluree.db.util.async.throw_err.call(null,inst_65891);
var state_65912__$1 = state_65912;
var statearr_65917_65941 = state_65912__$1;
(statearr_65917_65941[(2)] = inst_65892);

(statearr_65917_65941[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65913 === (6))){
var state_65912__$1 = state_65912;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65912__$1,(9),subject);
} else {
if((state_val_65913 === (3))){
var inst_65910 = (state_65912[(2)]);
var state_65912__$1 = state_65912;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65912__$1,inst_65910);
} else {
if((state_val_65913 === (12))){
var inst_65887 = (state_65912[(7)]);
var inst_65895 = (state_65912[(2)]);
var inst_65896 = fluree.db.dbfunctions.internal.get_in.call(null,inst_65887,inst_65895);
var inst_65897 = cljs.core.count.call(null,inst_65895);
var inst_65898 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65899 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65900 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65901 = [inst_65887,inst_65895];
var inst_65902 = (new cljs.core.PersistentVector(null,2,(5),inst_65900,inst_65901,null));
var inst_65903 = ["get-in",inst_65902,inst_65896];
var inst_65904 = cljs.core.PersistentHashMap.fromArrays(inst_65899,inst_65903);
var inst_65905 = [inst_65904,inst_65897];
var inst_65906 = (new cljs.core.PersistentVector(null,2,(5),inst_65898,inst_65905,null));
var inst_65907 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65906);
var _ = (function (){var statearr_65918 = state_65912;
(statearr_65918[(4)] = cljs.core.rest.call(null,(state_65912[(4)])));

return statearr_65918;
})();
var state_65912__$1 = (function (){var statearr_65919 = state_65912;
(statearr_65919[(8)] = inst_65907);

return statearr_65919;
})();
var statearr_65920_65942 = state_65912__$1;
(statearr_65920_65942[(2)] = inst_65896);

(statearr_65920_65942[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65913 === (2))){
var _ = (function (){var statearr_65921 = state_65912;
(statearr_65921[(4)] = cljs.core.cons.call(null,(5),(state_65912[(4)])));

return statearr_65921;
})();
var inst_65880 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_65912__$1 = state_65912;
if(inst_65880){
var statearr_65922_65943 = state_65912__$1;
(statearr_65922_65943[(1)] = (6));

} else {
var statearr_65923_65944 = state_65912__$1;
(statearr_65923_65944[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65913 === (11))){
var state_65912__$1 = state_65912;
var statearr_65925_65945 = state_65912__$1;
(statearr_65925_65945[(2)] = path);

(statearr_65925_65945[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65913 === (9))){
var inst_65883 = (state_65912[(2)]);
var inst_65884 = fluree.db.util.async.throw_err.call(null,inst_65883);
var state_65912__$1 = state_65912;
var statearr_65926_65946 = state_65912__$1;
(statearr_65926_65946[(2)] = inst_65884);

(statearr_65926_65946[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65913 === (5))){
var _ = (function (){var statearr_65927 = state_65912;
(statearr_65927[(4)] = cljs.core.rest.call(null,(state_65912[(4)])));

return statearr_65927;
})();
var state_65912__$1 = state_65912;
var ex65924 = (state_65912__$1[(2)]);
var statearr_65928_65947 = state_65912__$1;
(statearr_65928_65947[(5)] = ex65924);


if((ex65924 instanceof Error)){
var statearr_65929_65948 = state_65912__$1;
(statearr_65929_65948[(1)] = (4));

(statearr_65929_65948[(5)] = null);

} else {
throw ex65924;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65913 === (10))){
var state_65912__$1 = state_65912;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65912__$1,(13),path);
} else {
if((state_val_65913 === (8))){
var inst_65887 = (state_65912[(2)]);
var inst_65888 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_65912__$1 = (function (){var statearr_65930 = state_65912;
(statearr_65930[(7)] = inst_65887);

return statearr_65930;
})();
if(inst_65888){
var statearr_65931_65949 = state_65912__$1;
(statearr_65931_65949[(1)] = (10));

} else {
var statearr_65932_65950 = state_65912__$1;
(statearr_65932_65950[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__11469__auto____0 = (function (){
var statearr_65933 = [null,null,null,null,null,null,null,null,null];
(statearr_65933[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__11469__auto__);

(statearr_65933[(1)] = (1));

return statearr_65933;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__11469__auto____1 = (function (state_65912){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_65912);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e65934){var ex__11472__auto__ = e65934;
var statearr_65935_65951 = state_65912;
(statearr_65935_65951[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_65912[(4)]))){
var statearr_65936_65952 = state_65912;
(statearr_65936_65952[(1)] = cljs.core.first.call(null,(state_65912[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65953 = state_65912;
state_65912 = G__65953;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__11469__auto__ = function(state_65912){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__11469__auto____1.call(this,state_65912);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_65937 = f__11543__auto__.call(null);
(statearr_65937[(6)] = c__11542__auto__);

return statearr_65937;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_65998){
var state_val_65999 = (state_65998[(1)]);
if((state_val_65999 === (7))){
var state_65998__$1 = state_65998;
var statearr_66000_66029 = state_65998__$1;
(statearr_66000_66029[(2)] = coll);

(statearr_66000_66029[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65999 === (1))){
var state_65998__$1 = state_65998;
var statearr_66001_66030 = state_65998__$1;
(statearr_66001_66030[(2)] = null);

(statearr_66001_66030[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65999 === (4))){
var inst_65954 = (state_65998[(2)]);
var state_65998__$1 = state_65998;
var statearr_66002_66031 = state_65998__$1;
(statearr_66002_66031[(2)] = inst_65954);

(statearr_66002_66031[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65999 === (15))){
var inst_65974 = (state_65998[(7)]);
var inst_65982 = (state_65998[(2)]);
var inst_65983 = fluree.db.dbfunctions.internal.contains_QMARK_.call(null,inst_65974,inst_65982);
var inst_65984 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65985 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65986 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65987 = [inst_65974,inst_65982];
var inst_65988 = (new cljs.core.PersistentVector(null,2,(5),inst_65986,inst_65987,null));
var inst_65989 = ["contains?",inst_65988,inst_65983];
var inst_65990 = cljs.core.PersistentHashMap.fromArrays(inst_65985,inst_65989);
var inst_65991 = [inst_65990,(10)];
var inst_65992 = (new cljs.core.PersistentVector(null,2,(5),inst_65984,inst_65991,null));
var inst_65993 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65992);
var _ = (function (){var statearr_66003 = state_65998;
(statearr_66003[(4)] = cljs.core.rest.call(null,(state_65998[(4)])));

return statearr_66003;
})();
var state_65998__$1 = (function (){var statearr_66004 = state_65998;
(statearr_66004[(8)] = inst_65993);

return statearr_66004;
})();
var statearr_66005_66032 = state_65998__$1;
(statearr_66005_66032[(2)] = inst_65983);

(statearr_66005_66032[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65999 === (13))){
var state_65998__$1 = state_65998;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65998__$1,(16),key);
} else {
if((state_val_65999 === (6))){
var state_65998__$1 = state_65998;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65998__$1,(9),coll);
} else {
if((state_val_65999 === (3))){
var inst_65996 = (state_65998[(2)]);
var state_65998__$1 = state_65998;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65998__$1,inst_65996);
} else {
if((state_val_65999 === (12))){
var inst_65974 = (state_65998[(2)]);
var inst_65975 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_65998__$1 = (function (){var statearr_66006 = state_65998;
(statearr_66006[(7)] = inst_65974);

return statearr_66006;
})();
if(inst_65975){
var statearr_66007_66033 = state_65998__$1;
(statearr_66007_66033[(1)] = (13));

} else {
var statearr_66008_66034 = state_65998__$1;
(statearr_66008_66034[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65999 === (2))){
var _ = (function (){var statearr_66009 = state_65998;
(statearr_66009[(4)] = cljs.core.cons.call(null,(5),(state_65998[(4)])));

return statearr_66009;
})();
var inst_65960 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_65998__$1 = state_65998;
if(inst_65960){
var statearr_66010_66035 = state_65998__$1;
(statearr_66010_66035[(1)] = (6));

} else {
var statearr_66011_66036 = state_65998__$1;
(statearr_66011_66036[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65999 === (11))){
var inst_65967 = (state_65998[(9)]);
var inst_65971 = cljs.core.flatten.call(null,inst_65967);
var inst_65972 = cljs.core.set.call(null,inst_65971);
var state_65998__$1 = state_65998;
var statearr_66013_66037 = state_65998__$1;
(statearr_66013_66037[(2)] = inst_65972);

(statearr_66013_66037[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65999 === (9))){
var inst_65963 = (state_65998[(2)]);
var inst_65964 = fluree.db.util.async.throw_err.call(null,inst_65963);
var state_65998__$1 = state_65998;
var statearr_66014_66038 = state_65998__$1;
(statearr_66014_66038[(2)] = inst_65964);

(statearr_66014_66038[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65999 === (5))){
var _ = (function (){var statearr_66015 = state_65998;
(statearr_66015[(4)] = cljs.core.rest.call(null,(state_65998[(4)])));

return statearr_66015;
})();
var state_65998__$1 = state_65998;
var ex66012 = (state_65998__$1[(2)]);
var statearr_66016_66039 = state_65998__$1;
(statearr_66016_66039[(5)] = ex66012);


if((ex66012 instanceof Error)){
var statearr_66017_66040 = state_65998__$1;
(statearr_66017_66040[(1)] = (4));

(statearr_66017_66040[(5)] = null);

} else {
throw ex66012;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65999 === (14))){
var state_65998__$1 = state_65998;
var statearr_66018_66041 = state_65998__$1;
(statearr_66018_66041[(2)] = key);

(statearr_66018_66041[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65999 === (16))){
var inst_65978 = (state_65998[(2)]);
var inst_65979 = fluree.db.util.async.throw_err.call(null,inst_65978);
var state_65998__$1 = state_65998;
var statearr_66019_66042 = state_65998__$1;
(statearr_66019_66042[(2)] = inst_65979);

(statearr_66019_66042[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65999 === (10))){
var inst_65967 = (state_65998[(9)]);
var state_65998__$1 = state_65998;
var statearr_66020_66043 = state_65998__$1;
(statearr_66020_66043[(2)] = inst_65967);

(statearr_66020_66043[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65999 === (8))){
var inst_65967 = (state_65998[(9)]);
var inst_65967__$1 = (state_65998[(2)]);
var inst_65968 = cljs.core.set_QMARK_.call(null,inst_65967__$1);
var state_65998__$1 = (function (){var statearr_66021 = state_65998;
(statearr_66021[(9)] = inst_65967__$1);

return statearr_66021;
})();
if(inst_65968){
var statearr_66022_66044 = state_65998__$1;
(statearr_66022_66044[(1)] = (10));

} else {
var statearr_66023_66045 = state_65998__$1;
(statearr_66023_66045[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11469__auto____0 = (function (){
var statearr_66024 = [null,null,null,null,null,null,null,null,null,null];
(statearr_66024[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11469__auto__);

(statearr_66024[(1)] = (1));

return statearr_66024;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11469__auto____1 = (function (state_65998){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_65998);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e66025){var ex__11472__auto__ = e66025;
var statearr_66026_66046 = state_65998;
(statearr_66026_66046[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_65998[(4)]))){
var statearr_66027_66047 = state_65998;
(statearr_66027_66047[(1)] = cljs.core.first.call(null,(state_65998[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66048 = state_65998;
state_65998 = G__66048;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11469__auto__ = function(state_65998){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11469__auto____1.call(this,state_65998);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_66028 = f__11543__auto__.call(null);
(statearr_66028[(6)] = c__11542__auto__);

return statearr_66028;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4742__auto__ = [];
var len__4736__auto___66113 = arguments.length;
var i__4737__auto___66114 = (0);
while(true){
if((i__4737__auto___66114 < len__4736__auto___66113)){
args__4742__auto__.push((arguments[i__4737__auto___66114]));

var G__66115 = (i__4737__auto___66114 + (1));
i__4737__auto___66114 = G__66115;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_66091){
var state_val_66092 = (state_66091[(1)]);
if((state_val_66092 === (7))){
var inst_66060 = (state_66091[(7)]);
var inst_66067 = cljs.core.first.call(null,inst_66060);
var state_66091__$1 = state_66091;
var statearr_66093_66116 = state_66091__$1;
(statearr_66093_66116[(2)] = inst_66067);

(statearr_66093_66116[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66092 === (1))){
var state_66091__$1 = state_66091;
var statearr_66094_66117 = state_66091__$1;
(statearr_66094_66117[(2)] = null);

(statearr_66094_66117[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66092 === (4))){
var inst_66051 = (state_66091[(2)]);
var state_66091__$1 = state_66091;
var statearr_66095_66118 = state_66091__$1;
(statearr_66095_66118[(2)] = inst_66051);

(statearr_66095_66118[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66092 === (6))){
var inst_66060 = (state_66091[(7)]);
var inst_66059 = (state_66091[(2)]);
var inst_66060__$1 = fluree.db.util.async.throw_err.call(null,inst_66059);
var inst_66061 = cljs.core.count.call(null,inst_66060__$1);
var inst_66062 = cljs.core._EQ_.call(null,(1),inst_66061);
var inst_66063 = cljs.core.first.call(null,inst_66060__$1);
var inst_66064 = cljs.core.coll_QMARK_.call(null,inst_66063);
var inst_66065 = ((inst_66062) && (inst_66064));
var state_66091__$1 = (function (){var statearr_66096 = state_66091;
(statearr_66096[(7)] = inst_66060__$1);

return statearr_66096;
})();
if(cljs.core.truth_(inst_66065)){
var statearr_66097_66119 = state_66091__$1;
(statearr_66097_66119[(1)] = (7));

} else {
var statearr_66098_66120 = state_66091__$1;
(statearr_66098_66120[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66092 === (3))){
var inst_66089 = (state_66091[(2)]);
var state_66091__$1 = state_66091;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66091__$1,inst_66089);
} else {
if((state_val_66092 === (2))){
var _ = (function (){var statearr_66100 = state_66091;
(statearr_66100[(4)] = cljs.core.cons.call(null,(5),(state_66091[(4)])));

return statearr_66100;
})();
var inst_66057 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_66091__$1 = state_66091;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66091__$1,(6),inst_66057);
} else {
if((state_val_66092 === (9))){
var inst_66070 = (state_66091[(2)]);
var inst_66071 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.hash_set,inst_66070);
var inst_66072 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66073 = [inst_66070];
var inst_66074 = (new cljs.core.PersistentVector(null,1,(5),inst_66072,inst_66073,null));
var inst_66075 = cljs.core.count.call(null,inst_66074);
var inst_66076 = ((9) + inst_66075);
var inst_66077 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66078 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66079 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66080 = [inst_66070];
var inst_66081 = (new cljs.core.PersistentVector(null,1,(5),inst_66079,inst_66080,null));
var inst_66082 = ["hash-set",inst_66081,inst_66071];
var inst_66083 = cljs.core.PersistentHashMap.fromArrays(inst_66078,inst_66082);
var inst_66084 = [inst_66083,inst_66076];
var inst_66085 = (new cljs.core.PersistentVector(null,2,(5),inst_66077,inst_66084,null));
var inst_66086 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66085);
var _ = (function (){var statearr_66101 = state_66091;
(statearr_66101[(4)] = cljs.core.rest.call(null,(state_66091[(4)])));

return statearr_66101;
})();
var state_66091__$1 = (function (){var statearr_66102 = state_66091;
(statearr_66102[(8)] = inst_66086);

return statearr_66102;
})();
var statearr_66103_66121 = state_66091__$1;
(statearr_66103_66121[(2)] = inst_66071);

(statearr_66103_66121[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66092 === (5))){
var _ = (function (){var statearr_66104 = state_66091;
(statearr_66104[(4)] = cljs.core.rest.call(null,(state_66091[(4)])));

return statearr_66104;
})();
var state_66091__$1 = state_66091;
var ex66099 = (state_66091__$1[(2)]);
var statearr_66105_66122 = state_66091__$1;
(statearr_66105_66122[(5)] = ex66099);


if((ex66099 instanceof Error)){
var statearr_66106_66123 = state_66091__$1;
(statearr_66106_66123[(1)] = (4));

(statearr_66106_66123[(5)] = null);

} else {
throw ex66099;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66092 === (8))){
var inst_66060 = (state_66091[(7)]);
var state_66091__$1 = state_66091;
var statearr_66107_66124 = state_66091__$1;
(statearr_66107_66124[(2)] = inst_66060);

(statearr_66107_66124[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11469__auto____0 = (function (){
var statearr_66108 = [null,null,null,null,null,null,null,null,null];
(statearr_66108[(0)] = fluree$db$dbfunctions$fns$state_machine__11469__auto__);

(statearr_66108[(1)] = (1));

return statearr_66108;
});
var fluree$db$dbfunctions$fns$state_machine__11469__auto____1 = (function (state_66091){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_66091);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e66109){var ex__11472__auto__ = e66109;
var statearr_66110_66125 = state_66091;
(statearr_66110_66125[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_66091[(4)]))){
var statearr_66111_66126 = state_66091;
(statearr_66111_66126[(1)] = cljs.core.first.call(null,(state_66091[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66127 = state_66091;
state_66091 = G__66127;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11469__auto__ = function(state_66091){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____1.call(this,state_66091);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_66112 = f__11543__auto__.call(null);
(statearr_66112[(6)] = c__11542__auto__);

return statearr_66112;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq66049){
var G__66050 = cljs.core.first.call(null,seq66049);
var seq66049__$1 = cljs.core.next.call(null,seq66049);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66050,seq66049__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___66177 = arguments.length;
var i__4737__auto___66178 = (0);
while(true){
if((i__4737__auto___66178 < len__4736__auto___66177)){
args__4742__auto__.push((arguments[i__4737__auto___66178]));

var G__66179 = (i__4737__auto___66178 + (1));
i__4737__auto___66178 = G__66179;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_66160){
var state_val_66161 = (state_66160[(1)]);
if((state_val_66161 === (1))){
var state_66160__$1 = state_66160;
var statearr_66162_66180 = state_66160__$1;
(statearr_66162_66180[(2)] = null);

(statearr_66162_66180[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66161 === (2))){
var _ = (function (){var statearr_66163 = state_66160;
(statearr_66163[(4)] = cljs.core.cons.call(null,(5),(state_66160[(4)])));

return statearr_66163;
})();
var inst_66136 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_66160__$1 = state_66160;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66160__$1,(6),inst_66136);
} else {
if((state_val_66161 === (3))){
var inst_66158 = (state_66160[(2)]);
var state_66160__$1 = state_66160;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66160__$1,inst_66158);
} else {
if((state_val_66161 === (4))){
var inst_66130 = (state_66160[(2)]);
var state_66160__$1 = state_66160;
var statearr_66165_66181 = state_66160__$1;
(statearr_66165_66181[(2)] = inst_66130);

(statearr_66165_66181[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66161 === (5))){
var _ = (function (){var statearr_66166 = state_66160;
(statearr_66166[(4)] = cljs.core.rest.call(null,(state_66160[(4)])));

return statearr_66166;
})();
var state_66160__$1 = state_66160;
var ex66164 = (state_66160__$1[(2)]);
var statearr_66167_66182 = state_66160__$1;
(statearr_66167_66182[(5)] = ex66164);


if((ex66164 instanceof Error)){
var statearr_66168_66183 = state_66160__$1;
(statearr_66168_66183[(1)] = (4));

(statearr_66168_66183[(5)] = null);

} else {
throw ex66164;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66161 === (6))){
var inst_66138 = (state_66160[(2)]);
var inst_66139 = fluree.db.util.async.throw_err.call(null,inst_66138);
var inst_66140 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._EQ__EQ_,inst_66139);
var inst_66141 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66142 = [inst_66139];
var inst_66143 = (new cljs.core.PersistentVector(null,1,(5),inst_66141,inst_66142,null));
var inst_66144 = cljs.core.count.call(null,inst_66143);
var inst_66145 = ((9) + inst_66144);
var inst_66146 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66147 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66148 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66149 = [inst_66139];
var inst_66150 = (new cljs.core.PersistentVector(null,1,(5),inst_66148,inst_66149,null));
var inst_66151 = ["==",inst_66150,inst_66140];
var inst_66152 = cljs.core.PersistentHashMap.fromArrays(inst_66147,inst_66151);
var inst_66153 = [inst_66152,inst_66145];
var inst_66154 = (new cljs.core.PersistentVector(null,2,(5),inst_66146,inst_66153,null));
var inst_66155 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66154);
var _ = (function (){var statearr_66169 = state_66160;
(statearr_66169[(4)] = cljs.core.rest.call(null,(state_66160[(4)])));

return statearr_66169;
})();
var state_66160__$1 = (function (){var statearr_66170 = state_66160;
(statearr_66170[(7)] = inst_66155);

return statearr_66170;
})();
var statearr_66171_66184 = state_66160__$1;
(statearr_66171_66184[(2)] = inst_66140);

(statearr_66171_66184[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11469__auto____0 = (function (){
var statearr_66172 = [null,null,null,null,null,null,null,null];
(statearr_66172[(0)] = fluree$db$dbfunctions$fns$state_machine__11469__auto__);

(statearr_66172[(1)] = (1));

return statearr_66172;
});
var fluree$db$dbfunctions$fns$state_machine__11469__auto____1 = (function (state_66160){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_66160);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e66173){var ex__11472__auto__ = e66173;
var statearr_66174_66185 = state_66160;
(statearr_66174_66185[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_66160[(4)]))){
var statearr_66175_66186 = state_66160;
(statearr_66175_66186[(1)] = cljs.core.first.call(null,(state_66160[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66187 = state_66160;
state_66160 = G__66187;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11469__auto__ = function(state_66160){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____1.call(this,state_66160);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_66176 = f__11543__auto__.call(null);
(statearr_66176[(6)] = c__11542__auto__);

return statearr_66176;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq66128){
var G__66129 = cljs.core.first.call(null,seq66128);
var seq66128__$1 = cljs.core.next.call(null,seq66128);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66129,seq66128__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___66237 = arguments.length;
var i__4737__auto___66238 = (0);
while(true){
if((i__4737__auto___66238 < len__4736__auto___66237)){
args__4742__auto__.push((arguments[i__4737__auto___66238]));

var G__66239 = (i__4737__auto___66238 + (1));
i__4737__auto___66238 = G__66239;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_66220){
var state_val_66221 = (state_66220[(1)]);
if((state_val_66221 === (1))){
var state_66220__$1 = state_66220;
var statearr_66222_66240 = state_66220__$1;
(statearr_66222_66240[(2)] = null);

(statearr_66222_66240[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66221 === (2))){
var _ = (function (){var statearr_66223 = state_66220;
(statearr_66223[(4)] = cljs.core.cons.call(null,(5),(state_66220[(4)])));

return statearr_66223;
})();
var inst_66196 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_66220__$1 = state_66220;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66220__$1,(6),inst_66196);
} else {
if((state_val_66221 === (3))){
var inst_66218 = (state_66220[(2)]);
var state_66220__$1 = state_66220;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66220__$1,inst_66218);
} else {
if((state_val_66221 === (4))){
var inst_66190 = (state_66220[(2)]);
var state_66220__$1 = state_66220;
var statearr_66225_66241 = state_66220__$1;
(statearr_66225_66241[(2)] = inst_66190);

(statearr_66225_66241[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66221 === (5))){
var _ = (function (){var statearr_66226 = state_66220;
(statearr_66226[(4)] = cljs.core.rest.call(null,(state_66220[(4)])));

return statearr_66226;
})();
var state_66220__$1 = state_66220;
var ex66224 = (state_66220__$1[(2)]);
var statearr_66227_66242 = state_66220__$1;
(statearr_66227_66242[(5)] = ex66224);


if((ex66224 instanceof Error)){
var statearr_66228_66243 = state_66220__$1;
(statearr_66228_66243[(1)] = (4));

(statearr_66228_66243[(5)] = null);

} else {
throw ex66224;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66221 === (6))){
var inst_66198 = (state_66220[(2)]);
var inst_66199 = fluree.db.util.async.throw_err.call(null,inst_66198);
var inst_66200 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT_,inst_66199);
var inst_66201 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66202 = [inst_66199];
var inst_66203 = (new cljs.core.PersistentVector(null,1,(5),inst_66201,inst_66202,null));
var inst_66204 = cljs.core.count.call(null,inst_66203);
var inst_66205 = ((9) + inst_66204);
var inst_66206 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66207 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66208 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66209 = [inst_66199];
var inst_66210 = (new cljs.core.PersistentVector(null,1,(5),inst_66208,inst_66209,null));
var inst_66211 = [">",inst_66210,inst_66200];
var inst_66212 = cljs.core.PersistentHashMap.fromArrays(inst_66207,inst_66211);
var inst_66213 = [inst_66212,inst_66205];
var inst_66214 = (new cljs.core.PersistentVector(null,2,(5),inst_66206,inst_66213,null));
var inst_66215 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66214);
var _ = (function (){var statearr_66229 = state_66220;
(statearr_66229[(4)] = cljs.core.rest.call(null,(state_66220[(4)])));

return statearr_66229;
})();
var state_66220__$1 = (function (){var statearr_66230 = state_66220;
(statearr_66230[(7)] = inst_66215);

return statearr_66230;
})();
var statearr_66231_66244 = state_66220__$1;
(statearr_66231_66244[(2)] = inst_66200);

(statearr_66231_66244[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11469__auto____0 = (function (){
var statearr_66232 = [null,null,null,null,null,null,null,null];
(statearr_66232[(0)] = fluree$db$dbfunctions$fns$state_machine__11469__auto__);

(statearr_66232[(1)] = (1));

return statearr_66232;
});
var fluree$db$dbfunctions$fns$state_machine__11469__auto____1 = (function (state_66220){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_66220);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e66233){var ex__11472__auto__ = e66233;
var statearr_66234_66245 = state_66220;
(statearr_66234_66245[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_66220[(4)]))){
var statearr_66235_66246 = state_66220;
(statearr_66235_66246[(1)] = cljs.core.first.call(null,(state_66220[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66247 = state_66220;
state_66220 = G__66247;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11469__auto__ = function(state_66220){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____1.call(this,state_66220);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_66236 = f__11543__auto__.call(null);
(statearr_66236[(6)] = c__11542__auto__);

return statearr_66236;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq66188){
var G__66189 = cljs.core.first.call(null,seq66188);
var seq66188__$1 = cljs.core.next.call(null,seq66188);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66189,seq66188__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___66297 = arguments.length;
var i__4737__auto___66298 = (0);
while(true){
if((i__4737__auto___66298 < len__4736__auto___66297)){
args__4742__auto__.push((arguments[i__4737__auto___66298]));

var G__66299 = (i__4737__auto___66298 + (1));
i__4737__auto___66298 = G__66299;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_66280){
var state_val_66281 = (state_66280[(1)]);
if((state_val_66281 === (1))){
var state_66280__$1 = state_66280;
var statearr_66282_66300 = state_66280__$1;
(statearr_66282_66300[(2)] = null);

(statearr_66282_66300[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66281 === (2))){
var _ = (function (){var statearr_66283 = state_66280;
(statearr_66283[(4)] = cljs.core.cons.call(null,(5),(state_66280[(4)])));

return statearr_66283;
})();
var inst_66256 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_66280__$1 = state_66280;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66280__$1,(6),inst_66256);
} else {
if((state_val_66281 === (3))){
var inst_66278 = (state_66280[(2)]);
var state_66280__$1 = state_66280;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66280__$1,inst_66278);
} else {
if((state_val_66281 === (4))){
var inst_66250 = (state_66280[(2)]);
var state_66280__$1 = state_66280;
var statearr_66285_66301 = state_66280__$1;
(statearr_66285_66301[(2)] = inst_66250);

(statearr_66285_66301[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66281 === (5))){
var _ = (function (){var statearr_66286 = state_66280;
(statearr_66286[(4)] = cljs.core.rest.call(null,(state_66280[(4)])));

return statearr_66286;
})();
var state_66280__$1 = state_66280;
var ex66284 = (state_66280__$1[(2)]);
var statearr_66287_66302 = state_66280__$1;
(statearr_66287_66302[(5)] = ex66284);


if((ex66284 instanceof Error)){
var statearr_66288_66303 = state_66280__$1;
(statearr_66288_66303[(1)] = (4));

(statearr_66288_66303[(5)] = null);

} else {
throw ex66284;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66281 === (6))){
var inst_66258 = (state_66280[(2)]);
var inst_66259 = fluree.db.util.async.throw_err.call(null,inst_66258);
var inst_66260 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT_,inst_66259);
var inst_66261 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66262 = [inst_66259];
var inst_66263 = (new cljs.core.PersistentVector(null,1,(5),inst_66261,inst_66262,null));
var inst_66264 = cljs.core.count.call(null,inst_66263);
var inst_66265 = ((9) + inst_66264);
var inst_66266 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66267 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66268 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66269 = [inst_66259];
var inst_66270 = (new cljs.core.PersistentVector(null,1,(5),inst_66268,inst_66269,null));
var inst_66271 = ["<",inst_66270,inst_66260];
var inst_66272 = cljs.core.PersistentHashMap.fromArrays(inst_66267,inst_66271);
var inst_66273 = [inst_66272,inst_66265];
var inst_66274 = (new cljs.core.PersistentVector(null,2,(5),inst_66266,inst_66273,null));
var inst_66275 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66274);
var _ = (function (){var statearr_66289 = state_66280;
(statearr_66289[(4)] = cljs.core.rest.call(null,(state_66280[(4)])));

return statearr_66289;
})();
var state_66280__$1 = (function (){var statearr_66290 = state_66280;
(statearr_66290[(7)] = inst_66275);

return statearr_66290;
})();
var statearr_66291_66304 = state_66280__$1;
(statearr_66291_66304[(2)] = inst_66260);

(statearr_66291_66304[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11469__auto____0 = (function (){
var statearr_66292 = [null,null,null,null,null,null,null,null];
(statearr_66292[(0)] = fluree$db$dbfunctions$fns$state_machine__11469__auto__);

(statearr_66292[(1)] = (1));

return statearr_66292;
});
var fluree$db$dbfunctions$fns$state_machine__11469__auto____1 = (function (state_66280){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_66280);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e66293){var ex__11472__auto__ = e66293;
var statearr_66294_66305 = state_66280;
(statearr_66294_66305[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_66280[(4)]))){
var statearr_66295_66306 = state_66280;
(statearr_66295_66306[(1)] = cljs.core.first.call(null,(state_66280[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66307 = state_66280;
state_66280 = G__66307;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11469__auto__ = function(state_66280){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____1.call(this,state_66280);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_66296 = f__11543__auto__.call(null);
(statearr_66296[(6)] = c__11542__auto__);

return statearr_66296;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq66248){
var G__66249 = cljs.core.first.call(null,seq66248);
var seq66248__$1 = cljs.core.next.call(null,seq66248);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66249,seq66248__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___66357 = arguments.length;
var i__4737__auto___66358 = (0);
while(true){
if((i__4737__auto___66358 < len__4736__auto___66357)){
args__4742__auto__.push((arguments[i__4737__auto___66358]));

var G__66359 = (i__4737__auto___66358 + (1));
i__4737__auto___66358 = G__66359;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_66340){
var state_val_66341 = (state_66340[(1)]);
if((state_val_66341 === (1))){
var state_66340__$1 = state_66340;
var statearr_66342_66360 = state_66340__$1;
(statearr_66342_66360[(2)] = null);

(statearr_66342_66360[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66341 === (2))){
var _ = (function (){var statearr_66343 = state_66340;
(statearr_66343[(4)] = cljs.core.cons.call(null,(5),(state_66340[(4)])));

return statearr_66343;
})();
var inst_66316 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_66340__$1 = state_66340;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66340__$1,(6),inst_66316);
} else {
if((state_val_66341 === (3))){
var inst_66338 = (state_66340[(2)]);
var state_66340__$1 = state_66340;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66340__$1,inst_66338);
} else {
if((state_val_66341 === (4))){
var inst_66310 = (state_66340[(2)]);
var state_66340__$1 = state_66340;
var statearr_66345_66361 = state_66340__$1;
(statearr_66345_66361[(2)] = inst_66310);

(statearr_66345_66361[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66341 === (5))){
var _ = (function (){var statearr_66346 = state_66340;
(statearr_66346[(4)] = cljs.core.rest.call(null,(state_66340[(4)])));

return statearr_66346;
})();
var state_66340__$1 = state_66340;
var ex66344 = (state_66340__$1[(2)]);
var statearr_66347_66362 = state_66340__$1;
(statearr_66347_66362[(5)] = ex66344);


if((ex66344 instanceof Error)){
var statearr_66348_66363 = state_66340__$1;
(statearr_66348_66363[(1)] = (4));

(statearr_66348_66363[(5)] = null);

} else {
throw ex66344;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66341 === (6))){
var inst_66318 = (state_66340[(2)]);
var inst_66319 = fluree.db.util.async.throw_err.call(null,inst_66318);
var inst_66320 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT__EQ_,inst_66319);
var inst_66321 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66322 = [inst_66319];
var inst_66323 = (new cljs.core.PersistentVector(null,1,(5),inst_66321,inst_66322,null));
var inst_66324 = cljs.core.count.call(null,inst_66323);
var inst_66325 = ((9) + inst_66324);
var inst_66326 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66327 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66328 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66329 = [inst_66319];
var inst_66330 = (new cljs.core.PersistentVector(null,1,(5),inst_66328,inst_66329,null));
var inst_66331 = ["<=",inst_66330,inst_66320];
var inst_66332 = cljs.core.PersistentHashMap.fromArrays(inst_66327,inst_66331);
var inst_66333 = [inst_66332,inst_66325];
var inst_66334 = (new cljs.core.PersistentVector(null,2,(5),inst_66326,inst_66333,null));
var inst_66335 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66334);
var _ = (function (){var statearr_66349 = state_66340;
(statearr_66349[(4)] = cljs.core.rest.call(null,(state_66340[(4)])));

return statearr_66349;
})();
var state_66340__$1 = (function (){var statearr_66350 = state_66340;
(statearr_66350[(7)] = inst_66335);

return statearr_66350;
})();
var statearr_66351_66364 = state_66340__$1;
(statearr_66351_66364[(2)] = inst_66320);

(statearr_66351_66364[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11469__auto____0 = (function (){
var statearr_66352 = [null,null,null,null,null,null,null,null];
(statearr_66352[(0)] = fluree$db$dbfunctions$fns$state_machine__11469__auto__);

(statearr_66352[(1)] = (1));

return statearr_66352;
});
var fluree$db$dbfunctions$fns$state_machine__11469__auto____1 = (function (state_66340){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_66340);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e66353){var ex__11472__auto__ = e66353;
var statearr_66354_66365 = state_66340;
(statearr_66354_66365[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_66340[(4)]))){
var statearr_66355_66366 = state_66340;
(statearr_66355_66366[(1)] = cljs.core.first.call(null,(state_66340[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66367 = state_66340;
state_66340 = G__66367;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11469__auto__ = function(state_66340){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____1.call(this,state_66340);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_66356 = f__11543__auto__.call(null);
(statearr_66356[(6)] = c__11542__auto__);

return statearr_66356;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq66308){
var G__66309 = cljs.core.first.call(null,seq66308);
var seq66308__$1 = cljs.core.next.call(null,seq66308);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66309,seq66308__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___66417 = arguments.length;
var i__4737__auto___66418 = (0);
while(true){
if((i__4737__auto___66418 < len__4736__auto___66417)){
args__4742__auto__.push((arguments[i__4737__auto___66418]));

var G__66419 = (i__4737__auto___66418 + (1));
i__4737__auto___66418 = G__66419;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_66400){
var state_val_66401 = (state_66400[(1)]);
if((state_val_66401 === (1))){
var state_66400__$1 = state_66400;
var statearr_66402_66420 = state_66400__$1;
(statearr_66402_66420[(2)] = null);

(statearr_66402_66420[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66401 === (2))){
var _ = (function (){var statearr_66403 = state_66400;
(statearr_66403[(4)] = cljs.core.cons.call(null,(5),(state_66400[(4)])));

return statearr_66403;
})();
var inst_66376 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_66400__$1 = state_66400;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66400__$1,(6),inst_66376);
} else {
if((state_val_66401 === (3))){
var inst_66398 = (state_66400[(2)]);
var state_66400__$1 = state_66400;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66400__$1,inst_66398);
} else {
if((state_val_66401 === (4))){
var inst_66370 = (state_66400[(2)]);
var state_66400__$1 = state_66400;
var statearr_66405_66421 = state_66400__$1;
(statearr_66405_66421[(2)] = inst_66370);

(statearr_66405_66421[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66401 === (5))){
var _ = (function (){var statearr_66406 = state_66400;
(statearr_66406[(4)] = cljs.core.rest.call(null,(state_66400[(4)])));

return statearr_66406;
})();
var state_66400__$1 = state_66400;
var ex66404 = (state_66400__$1[(2)]);
var statearr_66407_66422 = state_66400__$1;
(statearr_66407_66422[(5)] = ex66404);


if((ex66404 instanceof Error)){
var statearr_66408_66423 = state_66400__$1;
(statearr_66408_66423[(1)] = (4));

(statearr_66408_66423[(5)] = null);

} else {
throw ex66404;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66401 === (6))){
var inst_66378 = (state_66400[(2)]);
var inst_66379 = fluree.db.util.async.throw_err.call(null,inst_66378);
var inst_66380 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT__EQ_,inst_66379);
var inst_66381 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66382 = [inst_66379];
var inst_66383 = (new cljs.core.PersistentVector(null,1,(5),inst_66381,inst_66382,null));
var inst_66384 = cljs.core.count.call(null,inst_66383);
var inst_66385 = ((9) + inst_66384);
var inst_66386 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66387 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66388 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66389 = [inst_66379];
var inst_66390 = (new cljs.core.PersistentVector(null,1,(5),inst_66388,inst_66389,null));
var inst_66391 = [">=",inst_66390,inst_66380];
var inst_66392 = cljs.core.PersistentHashMap.fromArrays(inst_66387,inst_66391);
var inst_66393 = [inst_66392,inst_66385];
var inst_66394 = (new cljs.core.PersistentVector(null,2,(5),inst_66386,inst_66393,null));
var inst_66395 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66394);
var _ = (function (){var statearr_66409 = state_66400;
(statearr_66409[(4)] = cljs.core.rest.call(null,(state_66400[(4)])));

return statearr_66409;
})();
var state_66400__$1 = (function (){var statearr_66410 = state_66400;
(statearr_66410[(7)] = inst_66395);

return statearr_66410;
})();
var statearr_66411_66424 = state_66400__$1;
(statearr_66411_66424[(2)] = inst_66380);

(statearr_66411_66424[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11469__auto____0 = (function (){
var statearr_66412 = [null,null,null,null,null,null,null,null];
(statearr_66412[(0)] = fluree$db$dbfunctions$fns$state_machine__11469__auto__);

(statearr_66412[(1)] = (1));

return statearr_66412;
});
var fluree$db$dbfunctions$fns$state_machine__11469__auto____1 = (function (state_66400){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_66400);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e66413){var ex__11472__auto__ = e66413;
var statearr_66414_66425 = state_66400;
(statearr_66414_66425[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_66400[(4)]))){
var statearr_66415_66426 = state_66400;
(statearr_66415_66426[(1)] = cljs.core.first.call(null,(state_66400[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66427 = state_66400;
state_66400 = G__66427;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11469__auto__ = function(state_66400){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____1.call(this,state_66400);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_66416 = f__11543__auto__.call(null);
(statearr_66416[(6)] = c__11542__auto__);

return statearr_66416;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq66368){
var G__66369 = cljs.core.first.call(null,seq66368);
var seq66368__$1 = cljs.core.next.call(null,seq66368);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66369,seq66368__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___66477 = arguments.length;
var i__4737__auto___66478 = (0);
while(true){
if((i__4737__auto___66478 < len__4736__auto___66477)){
args__4742__auto__.push((arguments[i__4737__auto___66478]));

var G__66479 = (i__4737__auto___66478 + (1));
i__4737__auto___66478 = G__66479;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_66460){
var state_val_66461 = (state_66460[(1)]);
if((state_val_66461 === (1))){
var state_66460__$1 = state_66460;
var statearr_66462_66480 = state_66460__$1;
(statearr_66462_66480[(2)] = null);

(statearr_66462_66480[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66461 === (2))){
var _ = (function (){var statearr_66463 = state_66460;
(statearr_66463[(4)] = cljs.core.cons.call(null,(5),(state_66460[(4)])));

return statearr_66463;
})();
var inst_66436 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_66460__$1 = state_66460;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66460__$1,(6),inst_66436);
} else {
if((state_val_66461 === (3))){
var inst_66458 = (state_66460[(2)]);
var state_66460__$1 = state_66460;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66460__$1,inst_66458);
} else {
if((state_val_66461 === (4))){
var inst_66430 = (state_66460[(2)]);
var state_66460__$1 = state_66460;
var statearr_66465_66481 = state_66460__$1;
(statearr_66465_66481[(2)] = inst_66430);

(statearr_66465_66481[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66461 === (5))){
var _ = (function (){var statearr_66466 = state_66460;
(statearr_66466[(4)] = cljs.core.rest.call(null,(state_66460[(4)])));

return statearr_66466;
})();
var state_66460__$1 = state_66460;
var ex66464 = (state_66460__$1[(2)]);
var statearr_66467_66482 = state_66460__$1;
(statearr_66467_66482[(5)] = ex66464);


if((ex66464 instanceof Error)){
var statearr_66468_66483 = state_66460__$1;
(statearr_66468_66483[(1)] = (4));

(statearr_66468_66483[(5)] = null);

} else {
throw ex66464;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66461 === (6))){
var inst_66438 = (state_66460[(2)]);
var inst_66439 = fluree.db.util.async.throw_err.call(null,inst_66438);
var inst_66440 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.not_EQ_,inst_66439);
var inst_66441 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66442 = [inst_66439];
var inst_66443 = (new cljs.core.PersistentVector(null,1,(5),inst_66441,inst_66442,null));
var inst_66444 = cljs.core.count.call(null,inst_66443);
var inst_66445 = ((9) + inst_66444);
var inst_66446 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66447 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66448 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66449 = [inst_66439];
var inst_66450 = (new cljs.core.PersistentVector(null,1,(5),inst_66448,inst_66449,null));
var inst_66451 = ["not=",inst_66450,inst_66440];
var inst_66452 = cljs.core.PersistentHashMap.fromArrays(inst_66447,inst_66451);
var inst_66453 = [inst_66452,inst_66445];
var inst_66454 = (new cljs.core.PersistentVector(null,2,(5),inst_66446,inst_66453,null));
var inst_66455 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66454);
var _ = (function (){var statearr_66469 = state_66460;
(statearr_66469[(4)] = cljs.core.rest.call(null,(state_66460[(4)])));

return statearr_66469;
})();
var state_66460__$1 = (function (){var statearr_66470 = state_66460;
(statearr_66470[(7)] = inst_66455);

return statearr_66470;
})();
var statearr_66471_66484 = state_66460__$1;
(statearr_66471_66484[(2)] = inst_66440);

(statearr_66471_66484[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11469__auto____0 = (function (){
var statearr_66472 = [null,null,null,null,null,null,null,null];
(statearr_66472[(0)] = fluree$db$dbfunctions$fns$state_machine__11469__auto__);

(statearr_66472[(1)] = (1));

return statearr_66472;
});
var fluree$db$dbfunctions$fns$state_machine__11469__auto____1 = (function (state_66460){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_66460);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e66473){var ex__11472__auto__ = e66473;
var statearr_66474_66485 = state_66460;
(statearr_66474_66485[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_66460[(4)]))){
var statearr_66475_66486 = state_66460;
(statearr_66475_66486[(1)] = cljs.core.first.call(null,(state_66460[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66487 = state_66460;
state_66460 = G__66487;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11469__auto__ = function(state_66460){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____1.call(this,state_66460);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_66476 = f__11543__auto__.call(null);
(statearr_66476[(6)] = c__11542__auto__);

return statearr_66476;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq66428){
var G__66429 = cljs.core.first.call(null,seq66428);
var seq66428__$1 = cljs.core.next.call(null,seq66428);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66429,seq66428__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4742__auto__ = [];
var len__4736__auto___66537 = arguments.length;
var i__4737__auto___66538 = (0);
while(true){
if((i__4737__auto___66538 < len__4736__auto___66537)){
args__4742__auto__.push((arguments[i__4737__auto___66538]));

var G__66539 = (i__4737__auto___66538 + (1));
i__4737__auto___66538 = G__66539;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_66520){
var state_val_66521 = (state_66520[(1)]);
if((state_val_66521 === (1))){
var state_66520__$1 = state_66520;
var statearr_66522_66540 = state_66520__$1;
(statearr_66522_66540[(2)] = null);

(statearr_66522_66540[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66521 === (2))){
var _ = (function (){var statearr_66523 = state_66520;
(statearr_66523[(4)] = cljs.core.cons.call(null,(5),(state_66520[(4)])));

return statearr_66523;
})();
var inst_66496 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_66520__$1 = state_66520;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66520__$1,(6),inst_66496);
} else {
if((state_val_66521 === (3))){
var inst_66518 = (state_66520[(2)]);
var state_66520__$1 = state_66520;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66520__$1,inst_66518);
} else {
if((state_val_66521 === (4))){
var inst_66490 = (state_66520[(2)]);
var state_66520__$1 = state_66520;
var statearr_66525_66541 = state_66520__$1;
(statearr_66525_66541[(2)] = inst_66490);

(statearr_66525_66541[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66521 === (5))){
var _ = (function (){var statearr_66526 = state_66520;
(statearr_66526[(4)] = cljs.core.rest.call(null,(state_66520[(4)])));

return statearr_66526;
})();
var state_66520__$1 = state_66520;
var ex66524 = (state_66520__$1[(2)]);
var statearr_66527_66542 = state_66520__$1;
(statearr_66527_66542[(5)] = ex66524);


if((ex66524 instanceof Error)){
var statearr_66528_66543 = state_66520__$1;
(statearr_66528_66543[(1)] = (4));

(statearr_66528_66543[(5)] = null);

} else {
throw ex66524;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66521 === (6))){
var inst_66498 = (state_66520[(2)]);
var inst_66499 = fluree.db.util.async.throw_err.call(null,inst_66498);
var inst_66500 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_66499);
var inst_66501 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66502 = [inst_66499];
var inst_66503 = (new cljs.core.PersistentVector(null,1,(5),inst_66501,inst_66502,null));
var inst_66504 = cljs.core.count.call(null,inst_66503);
var inst_66505 = ((9) + inst_66504);
var inst_66506 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66507 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66508 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66509 = [inst_66499];
var inst_66510 = (new cljs.core.PersistentVector(null,1,(5),inst_66508,inst_66509,null));
var inst_66511 = ["max",inst_66510,inst_66500];
var inst_66512 = cljs.core.PersistentHashMap.fromArrays(inst_66507,inst_66511);
var inst_66513 = [inst_66512,inst_66505];
var inst_66514 = (new cljs.core.PersistentVector(null,2,(5),inst_66506,inst_66513,null));
var inst_66515 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66514);
var _ = (function (){var statearr_66529 = state_66520;
(statearr_66529[(4)] = cljs.core.rest.call(null,(state_66520[(4)])));

return statearr_66529;
})();
var state_66520__$1 = (function (){var statearr_66530 = state_66520;
(statearr_66530[(7)] = inst_66515);

return statearr_66530;
})();
var statearr_66531_66544 = state_66520__$1;
(statearr_66531_66544[(2)] = inst_66500);

(statearr_66531_66544[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11469__auto____0 = (function (){
var statearr_66532 = [null,null,null,null,null,null,null,null];
(statearr_66532[(0)] = fluree$db$dbfunctions$fns$state_machine__11469__auto__);

(statearr_66532[(1)] = (1));

return statearr_66532;
});
var fluree$db$dbfunctions$fns$state_machine__11469__auto____1 = (function (state_66520){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_66520);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e66533){var ex__11472__auto__ = e66533;
var statearr_66534_66545 = state_66520;
(statearr_66534_66545[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_66520[(4)]))){
var statearr_66535_66546 = state_66520;
(statearr_66535_66546[(1)] = cljs.core.first.call(null,(state_66520[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66547 = state_66520;
state_66520 = G__66547;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11469__auto__ = function(state_66520){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____1.call(this,state_66520);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_66536 = f__11543__auto__.call(null);
(statearr_66536[(6)] = c__11542__auto__);

return statearr_66536;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq66488){
var G__66489 = cljs.core.first.call(null,seq66488);
var seq66488__$1 = cljs.core.next.call(null,seq66488);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66489,seq66488__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4742__auto__ = [];
var len__4736__auto___66597 = arguments.length;
var i__4737__auto___66598 = (0);
while(true){
if((i__4737__auto___66598 < len__4736__auto___66597)){
args__4742__auto__.push((arguments[i__4737__auto___66598]));

var G__66599 = (i__4737__auto___66598 + (1));
i__4737__auto___66598 = G__66599;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_66580){
var state_val_66581 = (state_66580[(1)]);
if((state_val_66581 === (1))){
var state_66580__$1 = state_66580;
var statearr_66582_66600 = state_66580__$1;
(statearr_66582_66600[(2)] = null);

(statearr_66582_66600[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66581 === (2))){
var _ = (function (){var statearr_66583 = state_66580;
(statearr_66583[(4)] = cljs.core.cons.call(null,(5),(state_66580[(4)])));

return statearr_66583;
})();
var inst_66556 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_66580__$1 = state_66580;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66580__$1,(6),inst_66556);
} else {
if((state_val_66581 === (3))){
var inst_66578 = (state_66580[(2)]);
var state_66580__$1 = state_66580;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66580__$1,inst_66578);
} else {
if((state_val_66581 === (4))){
var inst_66550 = (state_66580[(2)]);
var state_66580__$1 = state_66580;
var statearr_66585_66601 = state_66580__$1;
(statearr_66585_66601[(2)] = inst_66550);

(statearr_66585_66601[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66581 === (5))){
var _ = (function (){var statearr_66586 = state_66580;
(statearr_66586[(4)] = cljs.core.rest.call(null,(state_66580[(4)])));

return statearr_66586;
})();
var state_66580__$1 = state_66580;
var ex66584 = (state_66580__$1[(2)]);
var statearr_66587_66602 = state_66580__$1;
(statearr_66587_66602[(5)] = ex66584);


if((ex66584 instanceof Error)){
var statearr_66588_66603 = state_66580__$1;
(statearr_66588_66603[(1)] = (4));

(statearr_66588_66603[(5)] = null);

} else {
throw ex66584;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66581 === (6))){
var inst_66558 = (state_66580[(2)]);
var inst_66559 = fluree.db.util.async.throw_err.call(null,inst_66558);
var inst_66560 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.min,inst_66559);
var inst_66561 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66562 = [inst_66559];
var inst_66563 = (new cljs.core.PersistentVector(null,1,(5),inst_66561,inst_66562,null));
var inst_66564 = cljs.core.count.call(null,inst_66563);
var inst_66565 = ((9) + inst_66564);
var inst_66566 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66567 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66568 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66569 = [inst_66559];
var inst_66570 = (new cljs.core.PersistentVector(null,1,(5),inst_66568,inst_66569,null));
var inst_66571 = ["min",inst_66570,inst_66560];
var inst_66572 = cljs.core.PersistentHashMap.fromArrays(inst_66567,inst_66571);
var inst_66573 = [inst_66572,inst_66565];
var inst_66574 = (new cljs.core.PersistentVector(null,2,(5),inst_66566,inst_66573,null));
var inst_66575 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66574);
var _ = (function (){var statearr_66589 = state_66580;
(statearr_66589[(4)] = cljs.core.rest.call(null,(state_66580[(4)])));

return statearr_66589;
})();
var state_66580__$1 = (function (){var statearr_66590 = state_66580;
(statearr_66590[(7)] = inst_66575);

return statearr_66590;
})();
var statearr_66591_66604 = state_66580__$1;
(statearr_66591_66604[(2)] = inst_66560);

(statearr_66591_66604[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11469__auto____0 = (function (){
var statearr_66592 = [null,null,null,null,null,null,null,null];
(statearr_66592[(0)] = fluree$db$dbfunctions$fns$state_machine__11469__auto__);

(statearr_66592[(1)] = (1));

return statearr_66592;
});
var fluree$db$dbfunctions$fns$state_machine__11469__auto____1 = (function (state_66580){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_66580);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e66593){var ex__11472__auto__ = e66593;
var statearr_66594_66605 = state_66580;
(statearr_66594_66605[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_66580[(4)]))){
var statearr_66595_66606 = state_66580;
(statearr_66595_66606[(1)] = cljs.core.first.call(null,(state_66580[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66607 = state_66580;
state_66580 = G__66607;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11469__auto__ = function(state_66580){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____1.call(this,state_66580);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_66596 = f__11543__auto__.call(null);
(statearr_66596[(6)] = c__11542__auto__);

return statearr_66596;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq66548){
var G__66549 = cljs.core.first.call(null,seq66548);
var seq66548__$1 = cljs.core.next.call(null,seq66548);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66549,seq66548__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__66609 = arguments.length;
switch (G__66609) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_66654){
var state_val_66655 = (state_66654[(1)]);
if((state_val_66655 === (7))){
var state_66654__$1 = state_66654;
var statearr_66656_66793 = state_66654__$1;
(statearr_66656_66793[(2)] = query_map);

(statearr_66656_66793[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66655 === (1))){
var state_66654__$1 = state_66654;
var statearr_66657_66794 = state_66654__$1;
(statearr_66657_66794[(2)] = null);

(statearr_66657_66794[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66655 === (4))){
var inst_66610 = (state_66654[(2)]);
var state_66654__$1 = state_66654;
var statearr_66658_66795 = state_66654__$1;
(statearr_66658_66795[(2)] = inst_66610);

(statearr_66658_66795[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66655 === (13))){
var inst_66632 = (state_66654[(7)]);
var inst_66636 = (state_66654[(2)]);
var inst_66637 = fluree.db.util.async.throw_err.call(null,inst_66636);
var inst_66638 = cljs.core.nth.call(null,inst_66637,(0),null);
var inst_66639 = cljs.core.nth.call(null,inst_66637,(1),null);
var inst_66640 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66641 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66642 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66643 = [inst_66632];
var inst_66644 = (new cljs.core.PersistentVector(null,1,(5),inst_66642,inst_66643,null));
var inst_66645 = ["query",inst_66644,inst_66638];
var inst_66646 = cljs.core.PersistentHashMap.fromArrays(inst_66641,inst_66645);
var inst_66647 = [inst_66646,inst_66639];
var inst_66648 = (new cljs.core.PersistentVector(null,2,(5),inst_66640,inst_66647,null));
var inst_66649 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66648);
var _ = (function (){var statearr_66659 = state_66654;
(statearr_66659[(4)] = cljs.core.rest.call(null,(state_66654[(4)])));

return statearr_66659;
})();
var state_66654__$1 = (function (){var statearr_66660 = state_66654;
(statearr_66660[(8)] = inst_66649);

return statearr_66660;
})();
var statearr_66661_66796 = state_66654__$1;
(statearr_66661_66796[(2)] = inst_66638);

(statearr_66661_66796[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66655 === (6))){
var state_66654__$1 = state_66654;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66654__$1,(9),query_map);
} else {
if((state_val_66655 === (3))){
var inst_66652 = (state_66654[(2)]);
var state_66654__$1 = state_66654;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66654__$1,inst_66652);
} else {
if((state_val_66655 === (12))){
var inst_66632 = (state_66654[(7)]);
var inst_66632__$1 = (state_66654[(2)]);
var inst_66633 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_66634 = fluree.db.dbfunctions.internal.query.call(null,inst_66633,inst_66632__$1);
var state_66654__$1 = (function (){var statearr_66662 = state_66654;
(statearr_66662[(7)] = inst_66632__$1);

return statearr_66662;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66654__$1,(13),inst_66634);
} else {
if((state_val_66655 === (2))){
var _ = (function (){var statearr_66663 = state_66654;
(statearr_66663[(4)] = cljs.core.cons.call(null,(5),(state_66654[(4)])));

return statearr_66663;
})();
var inst_66619 = fluree.db.util.async.channel_QMARK_.call(null,query_map);
var state_66654__$1 = state_66654;
if(inst_66619){
var statearr_66664_66797 = state_66654__$1;
(statearr_66664_66797[(1)] = (6));

} else {
var statearr_66665_66798 = state_66654__$1;
(statearr_66665_66798[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66655 === (11))){
var inst_66626 = (state_66654[(9)]);
var state_66654__$1 = state_66654;
var statearr_66667_66799 = state_66654__$1;
(statearr_66667_66799[(2)] = inst_66626);

(statearr_66667_66799[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66655 === (9))){
var inst_66622 = (state_66654[(2)]);
var inst_66623 = fluree.db.util.async.throw_err.call(null,inst_66622);
var state_66654__$1 = state_66654;
var statearr_66668_66800 = state_66654__$1;
(statearr_66668_66800[(2)] = inst_66623);

(statearr_66668_66800[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66655 === (5))){
var _ = (function (){var statearr_66669 = state_66654;
(statearr_66669[(4)] = cljs.core.rest.call(null,(state_66654[(4)])));

return statearr_66669;
})();
var state_66654__$1 = state_66654;
var ex66666 = (state_66654__$1[(2)]);
var statearr_66670_66801 = state_66654__$1;
(statearr_66670_66801[(5)] = ex66666);


if((ex66666 instanceof Error)){
var statearr_66671_66802 = state_66654__$1;
(statearr_66671_66802[(1)] = (4));

(statearr_66671_66802[(5)] = null);

} else {
throw ex66666;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66655 === (10))){
var inst_66626 = (state_66654[(9)]);
var inst_66629 = fluree.db.util.json.parse.call(null,inst_66626);
var state_66654__$1 = state_66654;
var statearr_66672_66803 = state_66654__$1;
(statearr_66672_66803[(2)] = inst_66629);

(statearr_66672_66803[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66655 === (8))){
var inst_66626 = (state_66654[(9)]);
var inst_66626__$1 = (state_66654[(2)]);
var inst_66627 = typeof inst_66626__$1 === 'string';
var state_66654__$1 = (function (){var statearr_66673 = state_66654;
(statearr_66673[(9)] = inst_66626__$1);

return statearr_66673;
})();
if(cljs.core.truth_(inst_66627)){
var statearr_66674_66804 = state_66654__$1;
(statearr_66674_66804[(1)] = (10));

} else {
var statearr_66675_66805 = state_66654__$1;
(statearr_66675_66805[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11469__auto____0 = (function (){
var statearr_66676 = [null,null,null,null,null,null,null,null,null,null];
(statearr_66676[(0)] = fluree$db$dbfunctions$fns$state_machine__11469__auto__);

(statearr_66676[(1)] = (1));

return statearr_66676;
});
var fluree$db$dbfunctions$fns$state_machine__11469__auto____1 = (function (state_66654){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_66654);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e66677){var ex__11472__auto__ = e66677;
var statearr_66678_66806 = state_66654;
(statearr_66678_66806[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_66654[(4)]))){
var statearr_66679_66807 = state_66654;
(statearr_66679_66807[(1)] = cljs.core.first.call(null,(state_66654[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66808 = state_66654;
state_66654 = G__66808;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11469__auto__ = function(state_66654){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____1.call(this,state_66654);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_66680 = f__11543__auto__.call(null);
(statearr_66680[(6)] = c__11542__auto__);

return statearr_66680;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_66751){
var state_val_66752 = (state_66751[(1)]);
if((state_val_66752 === (7))){
var state_66751__$1 = state_66751;
var statearr_66753_66809 = state_66751__$1;
(statearr_66753_66809[(2)] = select);

(statearr_66753_66809[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66752 === (20))){
var inst_66721 = (state_66751[(2)]);
var inst_66722 = fluree.db.util.async.channel_QMARK_.call(null,limit);
var state_66751__$1 = (function (){var statearr_66754 = state_66751;
(statearr_66754[(7)] = inst_66721);

return statearr_66754;
})();
if(inst_66722){
var statearr_66755_66810 = state_66751__$1;
(statearr_66755_66810[(1)] = (22));

} else {
var statearr_66756_66811 = state_66751__$1;
(statearr_66756_66811[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66752 === (1))){
var state_66751__$1 = state_66751;
var statearr_66757_66812 = state_66751__$1;
(statearr_66757_66812[(2)] = null);

(statearr_66757_66812[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66752 === (24))){
var inst_66697 = (state_66751[(8)]);
var inst_66721 = (state_66751[(7)]);
var inst_66705 = (state_66751[(9)]);
var inst_66713 = (state_66751[(10)]);
var inst_66729 = (state_66751[(2)]);
var inst_66730 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_66731 = fluree.db.dbfunctions.internal.query.call(null,inst_66730,inst_66697,inst_66705,inst_66713,inst_66721,inst_66729);
var state_66751__$1 = state_66751;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66751__$1,(26),inst_66731);
} else {
if((state_val_66752 === (4))){
var inst_66681 = (state_66751[(2)]);
var state_66751__$1 = state_66751;
var statearr_66758_66813 = state_66751__$1;
(statearr_66758_66813[(2)] = inst_66681);

(statearr_66758_66813[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66752 === (15))){
var state_66751__$1 = state_66751;
var statearr_66759_66814 = state_66751__$1;
(statearr_66759_66814[(2)] = where);

(statearr_66759_66814[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66752 === (21))){
var inst_66717 = (state_66751[(2)]);
var inst_66718 = fluree.db.util.async.throw_err.call(null,inst_66717);
var state_66751__$1 = state_66751;
var statearr_66760_66815 = state_66751__$1;
(statearr_66760_66815[(2)] = inst_66718);

(statearr_66760_66815[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66752 === (13))){
var inst_66701 = (state_66751[(2)]);
var inst_66702 = fluree.db.util.async.throw_err.call(null,inst_66701);
var state_66751__$1 = state_66751;
var statearr_66761_66816 = state_66751__$1;
(statearr_66761_66816[(2)] = inst_66702);

(statearr_66761_66816[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66752 === (22))){
var state_66751__$1 = state_66751;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66751__$1,(25),limit);
} else {
if((state_val_66752 === (6))){
var state_66751__$1 = state_66751;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66751__$1,(9),select);
} else {
if((state_val_66752 === (25))){
var inst_66725 = (state_66751[(2)]);
var inst_66726 = fluree.db.util.async.throw_err.call(null,inst_66725);
var state_66751__$1 = state_66751;
var statearr_66762_66817 = state_66751__$1;
(statearr_66762_66817[(2)] = inst_66726);

(statearr_66762_66817[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66752 === (17))){
var inst_66709 = (state_66751[(2)]);
var inst_66710 = fluree.db.util.async.throw_err.call(null,inst_66709);
var state_66751__$1 = state_66751;
var statearr_66763_66818 = state_66751__$1;
(statearr_66763_66818[(2)] = inst_66710);

(statearr_66763_66818[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66752 === (3))){
var inst_66749 = (state_66751[(2)]);
var state_66751__$1 = state_66751;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66751__$1,inst_66749);
} else {
if((state_val_66752 === (12))){
var inst_66705 = (state_66751[(2)]);
var inst_66706 = fluree.db.util.async.channel_QMARK_.call(null,where);
var state_66751__$1 = (function (){var statearr_66764 = state_66751;
(statearr_66764[(9)] = inst_66705);

return statearr_66764;
})();
if(inst_66706){
var statearr_66765_66819 = state_66751__$1;
(statearr_66765_66819[(1)] = (14));

} else {
var statearr_66766_66820 = state_66751__$1;
(statearr_66766_66820[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66752 === (2))){
var _ = (function (){var statearr_66767 = state_66751;
(statearr_66767[(4)] = cljs.core.cons.call(null,(5),(state_66751[(4)])));

return statearr_66767;
})();
var inst_66690 = fluree.db.util.async.channel_QMARK_.call(null,select);
var state_66751__$1 = state_66751;
if(inst_66690){
var statearr_66768_66821 = state_66751__$1;
(statearr_66768_66821[(1)] = (6));

} else {
var statearr_66769_66822 = state_66751__$1;
(statearr_66769_66822[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66752 === (23))){
var state_66751__$1 = state_66751;
var statearr_66770_66823 = state_66751__$1;
(statearr_66770_66823[(2)] = limit);

(statearr_66770_66823[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66752 === (19))){
var state_66751__$1 = state_66751;
var statearr_66771_66824 = state_66751__$1;
(statearr_66771_66824[(2)] = block);

(statearr_66771_66824[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66752 === (11))){
var state_66751__$1 = state_66751;
var statearr_66773_66825 = state_66751__$1;
(statearr_66773_66825[(2)] = from);

(statearr_66773_66825[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66752 === (9))){
var inst_66693 = (state_66751[(2)]);
var inst_66694 = fluree.db.util.async.throw_err.call(null,inst_66693);
var state_66751__$1 = state_66751;
var statearr_66774_66826 = state_66751__$1;
(statearr_66774_66826[(2)] = inst_66694);

(statearr_66774_66826[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66752 === (5))){
var _ = (function (){var statearr_66775 = state_66751;
(statearr_66775[(4)] = cljs.core.rest.call(null,(state_66751[(4)])));

return statearr_66775;
})();
var state_66751__$1 = state_66751;
var ex66772 = (state_66751__$1[(2)]);
var statearr_66776_66827 = state_66751__$1;
(statearr_66776_66827[(5)] = ex66772);


if((ex66772 instanceof Error)){
var statearr_66777_66828 = state_66751__$1;
(statearr_66777_66828[(1)] = (4));

(statearr_66777_66828[(5)] = null);

} else {
throw ex66772;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66752 === (14))){
var state_66751__$1 = state_66751;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66751__$1,(17),where);
} else {
if((state_val_66752 === (26))){
var inst_66697 = (state_66751[(8)]);
var inst_66721 = (state_66751[(7)]);
var inst_66705 = (state_66751[(9)]);
var inst_66713 = (state_66751[(10)]);
var inst_66733 = (state_66751[(2)]);
var inst_66734 = fluree.db.util.async.throw_err.call(null,inst_66733);
var inst_66735 = cljs.core.nth.call(null,inst_66734,(0),null);
var inst_66736 = cljs.core.nth.call(null,inst_66734,(1),null);
var inst_66737 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66738 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66739 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66740 = [inst_66697,inst_66705,inst_66713,inst_66721];
var inst_66741 = (new cljs.core.PersistentVector(null,4,(5),inst_66739,inst_66740,null));
var inst_66742 = ["query",inst_66741,inst_66735];
var inst_66743 = cljs.core.PersistentHashMap.fromArrays(inst_66738,inst_66742);
var inst_66744 = [inst_66743,inst_66736];
var inst_66745 = (new cljs.core.PersistentVector(null,2,(5),inst_66737,inst_66744,null));
var inst_66746 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66745);
var _ = (function (){var statearr_66778 = state_66751;
(statearr_66778[(4)] = cljs.core.rest.call(null,(state_66751[(4)])));

return statearr_66778;
})();
var state_66751__$1 = (function (){var statearr_66779 = state_66751;
(statearr_66779[(11)] = inst_66746);

return statearr_66779;
})();
var statearr_66780_66829 = state_66751__$1;
(statearr_66780_66829[(2)] = inst_66735);

(statearr_66780_66829[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66752 === (16))){
var inst_66713 = (state_66751[(2)]);
var inst_66714 = fluree.db.util.async.channel_QMARK_.call(null,block);
var state_66751__$1 = (function (){var statearr_66781 = state_66751;
(statearr_66781[(10)] = inst_66713);

return statearr_66781;
})();
if(inst_66714){
var statearr_66782_66830 = state_66751__$1;
(statearr_66782_66830[(1)] = (18));

} else {
var statearr_66783_66831 = state_66751__$1;
(statearr_66783_66831[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66752 === (10))){
var state_66751__$1 = state_66751;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66751__$1,(13),from);
} else {
if((state_val_66752 === (18))){
var state_66751__$1 = state_66751;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66751__$1,(21),block);
} else {
if((state_val_66752 === (8))){
var inst_66697 = (state_66751[(2)]);
var inst_66698 = fluree.db.util.async.channel_QMARK_.call(null,from);
var state_66751__$1 = (function (){var statearr_66784 = state_66751;
(statearr_66784[(8)] = inst_66697);

return statearr_66784;
})();
if(inst_66698){
var statearr_66785_66832 = state_66751__$1;
(statearr_66785_66832[(1)] = (10));

} else {
var statearr_66786_66833 = state_66751__$1;
(statearr_66786_66833[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11469__auto____0 = (function (){
var statearr_66787 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66787[(0)] = fluree$db$dbfunctions$fns$state_machine__11469__auto__);

(statearr_66787[(1)] = (1));

return statearr_66787;
});
var fluree$db$dbfunctions$fns$state_machine__11469__auto____1 = (function (state_66751){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_66751);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e66788){var ex__11472__auto__ = e66788;
var statearr_66789_66834 = state_66751;
(statearr_66789_66834[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_66751[(4)]))){
var statearr_66790_66835 = state_66751;
(statearr_66790_66835[(1)] = cljs.core.first.call(null,(state_66751[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66836 = state_66751;
state_66751 = G__66836;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11469__auto__ = function(state_66751){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____1.call(this,state_66751);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_66791 = f__11543__auto__.call(null);
(statearr_66791[(6)] = c__11542__auto__);

return statearr_66791;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_66892){
var state_val_66893 = (state_66892[(1)]);
if((state_val_66893 === (7))){
var state_66892__$1 = state_66892;
var statearr_66894_66925 = state_66892__$1;
(statearr_66894_66925[(2)] = startSubject);

(statearr_66894_66925[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66893 === (1))){
var state_66892__$1 = state_66892;
var statearr_66895_66926 = state_66892__$1;
(statearr_66895_66926[(2)] = null);

(statearr_66895_66926[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66893 === (4))){
var inst_66837 = (state_66892[(2)]);
var state_66892__$1 = state_66892;
var statearr_66896_66927 = state_66892__$1;
(statearr_66896_66927[(2)] = inst_66837);

(statearr_66896_66927[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66893 === (15))){
var inst_66869 = (state_66892[(2)]);
var inst_66870 = fluree.db.util.async.throw_err.call(null,inst_66869);
var inst_66871 = cljs.core.nth.call(null,inst_66870,(0),null);
var inst_66872 = cljs.core.nth.call(null,inst_66870,(1),null);
var inst_66873 = cljs.core.empty_QMARK_.call(null,inst_66871);
var state_66892__$1 = (function (){var statearr_66897 = state_66892;
(statearr_66897[(7)] = inst_66872);

return statearr_66897;
})();
if(inst_66873){
var statearr_66898_66928 = state_66892__$1;
(statearr_66898_66928[(1)] = (16));

} else {
var statearr_66899_66929 = state_66892__$1;
(statearr_66899_66929[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66893 === (13))){
var inst_66857 = (state_66892[(8)]);
var inst_66853 = (state_66892[(9)]);
var inst_66865 = (state_66892[(10)]);
var inst_66865__$1 = (state_66892[(2)]);
var inst_66866 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_66867 = fluree.db.dbfunctions.internal.relationship_QMARK_.call(null,inst_66866,inst_66853,inst_66857,inst_66865__$1);
var state_66892__$1 = (function (){var statearr_66900 = state_66892;
(statearr_66900[(10)] = inst_66865__$1);

return statearr_66900;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66892__$1,(15),inst_66867);
} else {
if((state_val_66893 === (6))){
var state_66892__$1 = state_66892;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66892__$1,(9),startSubject);
} else {
if((state_val_66893 === (17))){
var state_66892__$1 = state_66892;
var statearr_66901_66930 = state_66892__$1;
(statearr_66901_66930[(2)] = true);

(statearr_66901_66930[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66893 === (3))){
var inst_66890 = (state_66892[(2)]);
var state_66892__$1 = state_66892;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66892__$1,inst_66890);
} else {
if((state_val_66893 === (12))){
var state_66892__$1 = state_66892;
var statearr_66902_66931 = state_66892__$1;
(statearr_66902_66931[(2)] = endSubject);

(statearr_66902_66931[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66893 === (2))){
var _ = (function (){var statearr_66903 = state_66892;
(statearr_66903[(4)] = cljs.core.cons.call(null,(5),(state_66892[(4)])));

return statearr_66903;
})();
var inst_66846 = fluree.db.util.async.channel_QMARK_.call(null,startSubject);
var state_66892__$1 = state_66892;
if(inst_66846){
var statearr_66904_66932 = state_66892__$1;
(statearr_66904_66932[(1)] = (6));

} else {
var statearr_66905_66933 = state_66892__$1;
(statearr_66905_66933[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66893 === (11))){
var state_66892__$1 = state_66892;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66892__$1,(14),endSubject);
} else {
if((state_val_66893 === (9))){
var inst_66849 = (state_66892[(2)]);
var inst_66850 = fluree.db.util.async.throw_err.call(null,inst_66849);
var state_66892__$1 = state_66892;
var statearr_66907_66934 = state_66892__$1;
(statearr_66907_66934[(2)] = inst_66850);

(statearr_66907_66934[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66893 === (5))){
var _ = (function (){var statearr_66908 = state_66892;
(statearr_66908[(4)] = cljs.core.rest.call(null,(state_66892[(4)])));

return statearr_66908;
})();
var state_66892__$1 = state_66892;
var ex66906 = (state_66892__$1[(2)]);
var statearr_66909_66935 = state_66892__$1;
(statearr_66909_66935[(5)] = ex66906);


if((ex66906 instanceof Error)){
var statearr_66910_66936 = state_66892__$1;
(statearr_66910_66936[(1)] = (4));

(statearr_66910_66936[(5)] = null);

} else {
throw ex66906;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66893 === (14))){
var inst_66861 = (state_66892[(2)]);
var inst_66862 = fluree.db.util.async.throw_err.call(null,inst_66861);
var state_66892__$1 = state_66892;
var statearr_66911_66937 = state_66892__$1;
(statearr_66911_66937[(2)] = inst_66862);

(statearr_66911_66937[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66893 === (16))){
var state_66892__$1 = state_66892;
var statearr_66912_66938 = state_66892__$1;
(statearr_66912_66938[(2)] = false);

(statearr_66912_66938[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66893 === (10))){
var inst_66856 = (state_66892[(2)]);
var inst_66857 = fluree.db.util.async.throw_err.call(null,inst_66856);
var inst_66858 = fluree.db.util.async.channel_QMARK_.call(null,endSubject);
var state_66892__$1 = (function (){var statearr_66913 = state_66892;
(statearr_66913[(8)] = inst_66857);

return statearr_66913;
})();
if(inst_66858){
var statearr_66914_66939 = state_66892__$1;
(statearr_66914_66939[(1)] = (11));

} else {
var statearr_66915_66940 = state_66892__$1;
(statearr_66915_66940[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66893 === (18))){
var inst_66872 = (state_66892[(7)]);
var inst_66857 = (state_66892[(8)]);
var inst_66853 = (state_66892[(9)]);
var inst_66865 = (state_66892[(10)]);
var inst_66877 = (state_66892[(2)]);
var inst_66878 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66879 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66880 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66881 = [inst_66853,inst_66857,inst_66865];
var inst_66882 = (new cljs.core.PersistentVector(null,3,(5),inst_66880,inst_66881,null));
var inst_66883 = ["relationship?",inst_66882,inst_66877];
var inst_66884 = cljs.core.PersistentHashMap.fromArrays(inst_66879,inst_66883);
var inst_66885 = [inst_66884,inst_66872];
var inst_66886 = (new cljs.core.PersistentVector(null,2,(5),inst_66878,inst_66885,null));
var inst_66887 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66886);
var _ = (function (){var statearr_66916 = state_66892;
(statearr_66916[(4)] = cljs.core.rest.call(null,(state_66892[(4)])));

return statearr_66916;
})();
var state_66892__$1 = (function (){var statearr_66917 = state_66892;
(statearr_66917[(11)] = inst_66887);

return statearr_66917;
})();
var statearr_66918_66941 = state_66892__$1;
(statearr_66918_66941[(2)] = inst_66877);

(statearr_66918_66941[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66893 === (8))){
var inst_66853 = (state_66892[(2)]);
var inst_66854 = fluree.db.dbfunctions.fns.coerce_args.call(null,path);
var state_66892__$1 = (function (){var statearr_66919 = state_66892;
(statearr_66919[(9)] = inst_66853);

return statearr_66919;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66892__$1,(10),inst_66854);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11469__auto____0 = (function (){
var statearr_66920 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66920[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11469__auto__);

(statearr_66920[(1)] = (1));

return statearr_66920;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11469__auto____1 = (function (state_66892){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_66892);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e66921){var ex__11472__auto__ = e66921;
var statearr_66922_66942 = state_66892;
(statearr_66922_66942[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_66892[(4)]))){
var statearr_66923_66943 = state_66892;
(statearr_66923_66943[(1)] = cljs.core.first.call(null,(state_66892[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66944 = state_66892;
state_66892 = G__66944;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11469__auto__ = function(state_66892){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11469__auto____1.call(this,state_66892);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_66924 = f__11543__auto__.call(null);
(statearr_66924[(6)] = c__11542__auto__);

return statearr_66924;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_66981){
var state_val_66982 = (state_66981[(1)]);
if((state_val_66982 === (7))){
var state_66981__$1 = state_66981;
var statearr_66983_67003 = state_66981__$1;
(statearr_66983_67003[(2)] = pred_name);

(statearr_66983_67003[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66982 === (1))){
var state_66981__$1 = state_66981;
var statearr_66984_67004 = state_66981__$1;
(statearr_66984_67004[(2)] = null);

(statearr_66984_67004[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66982 === (4))){
var inst_66945 = (state_66981[(2)]);
var state_66981__$1 = state_66981;
var statearr_66985_67005 = state_66981__$1;
(statearr_66985_67005[(2)] = inst_66945);

(statearr_66985_67005[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66982 === (6))){
var state_66981__$1 = state_66981;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66981__$1,(9),pred_name);
} else {
if((state_val_66982 === (3))){
var inst_66979 = (state_66981[(2)]);
var state_66981__$1 = state_66981;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66981__$1,inst_66979);
} else {
if((state_val_66982 === (2))){
var _ = (function (){var statearr_66987 = state_66981;
(statearr_66987[(4)] = cljs.core.cons.call(null,(5),(state_66981[(4)])));

return statearr_66987;
})();
var inst_66954 = fluree.db.util.async.channel_QMARK_.call(null,pred_name);
var state_66981__$1 = state_66981;
if(inst_66954){
var statearr_66988_67006 = state_66981__$1;
(statearr_66988_67006[(1)] = (6));

} else {
var statearr_66989_67007 = state_66981__$1;
(statearr_66989_67007[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66982 === (9))){
var inst_66957 = (state_66981[(2)]);
var inst_66958 = fluree.db.util.async.throw_err.call(null,inst_66957);
var state_66981__$1 = state_66981;
var statearr_66990_67008 = state_66981__$1;
(statearr_66990_67008[(2)] = inst_66958);

(statearr_66990_67008[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66982 === (5))){
var _ = (function (){var statearr_66991 = state_66981;
(statearr_66991[(4)] = cljs.core.rest.call(null,(state_66981[(4)])));

return statearr_66991;
})();
var state_66981__$1 = state_66981;
var ex66986 = (state_66981__$1[(2)]);
var statearr_66992_67009 = state_66981__$1;
(statearr_66992_67009[(5)] = ex66986);


if((ex66986 instanceof Error)){
var statearr_66993_67010 = state_66981__$1;
(statearr_66993_67010[(1)] = (4));

(statearr_66993_67010[(5)] = null);

} else {
throw ex66986;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66982 === (10))){
var inst_66961 = (state_66981[(7)]);
var inst_66965 = (state_66981[(2)]);
var inst_66966 = fluree.db.util.async.throw_err.call(null,inst_66965);
var inst_66967 = cljs.core.nth.call(null,inst_66966,(0),null);
var inst_66968 = cljs.core.nth.call(null,inst_66966,(1),null);
var inst_66969 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66970 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66971 = ["max-pred-val",inst_66961,inst_66967];
var inst_66972 = cljs.core.PersistentHashMap.fromArrays(inst_66970,inst_66971);
var inst_66973 = (inst_66968 + (10));
var inst_66974 = [inst_66972,inst_66973];
var inst_66975 = (new cljs.core.PersistentVector(null,2,(5),inst_66969,inst_66974,null));
var inst_66976 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66975);
var _ = (function (){var statearr_66994 = state_66981;
(statearr_66994[(4)] = cljs.core.rest.call(null,(state_66981[(4)])));

return statearr_66994;
})();
var state_66981__$1 = (function (){var statearr_66995 = state_66981;
(statearr_66995[(8)] = inst_66976);

return statearr_66995;
})();
var statearr_66996_67011 = state_66981__$1;
(statearr_66996_67011[(2)] = inst_66967);

(statearr_66996_67011[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66982 === (8))){
var inst_66961 = (state_66981[(7)]);
var inst_66961__$1 = (state_66981[(2)]);
var inst_66962 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_66963 = fluree.db.dbfunctions.internal.max_pred_val.call(null,inst_66962,inst_66961__$1,null);
var state_66981__$1 = (function (){var statearr_66997 = state_66981;
(statearr_66997[(7)] = inst_66961__$1);

return statearr_66997;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66981__$1,(10),inst_66963);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11469__auto____0 = (function (){
var statearr_66998 = [null,null,null,null,null,null,null,null,null];
(statearr_66998[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11469__auto__);

(statearr_66998[(1)] = (1));

return statearr_66998;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11469__auto____1 = (function (state_66981){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_66981);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e66999){var ex__11472__auto__ = e66999;
var statearr_67000_67012 = state_66981;
(statearr_67000_67012[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_66981[(4)]))){
var statearr_67001_67013 = state_66981;
(statearr_67001_67013[(1)] = cljs.core.first.call(null,(state_66981[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67014 = state_66981;
state_66981 = G__67014;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11469__auto__ = function(state_66981){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11469__auto____1.call(this,state_66981);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_67002 = f__11543__auto__.call(null);
(statearr_67002[(6)] = c__11542__auto__);

return statearr_67002;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_67041){
var state_val_67042 = (state_67041[(1)]);
if((state_val_67042 === (7))){
var state_67041__$1 = state_67041;
var statearr_67043_67062 = state_67041__$1;
(statearr_67043_67062[(2)] = n);

(statearr_67043_67062[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (1))){
var state_67041__$1 = state_67041;
var statearr_67044_67063 = state_67041__$1;
(statearr_67044_67063[(2)] = null);

(statearr_67044_67063[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (4))){
var inst_67015 = (state_67041[(2)]);
var state_67041__$1 = state_67041;
var statearr_67045_67064 = state_67041__$1;
(statearr_67045_67064[(2)] = inst_67015);

(statearr_67045_67064[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (6))){
var state_67041__$1 = state_67041;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67041__$1,(9),n);
} else {
if((state_val_67042 === (3))){
var inst_67039 = (state_67041[(2)]);
var state_67041__$1 = state_67041;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67041__$1,inst_67039);
} else {
if((state_val_67042 === (2))){
var _ = (function (){var statearr_67047 = state_67041;
(statearr_67047[(4)] = cljs.core.cons.call(null,(5),(state_67041[(4)])));

return statearr_67047;
})();
var inst_67021 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_67041__$1 = state_67041;
if(inst_67021){
var statearr_67048_67065 = state_67041__$1;
(statearr_67048_67065[(1)] = (6));

} else {
var statearr_67049_67066 = state_67041__$1;
(statearr_67049_67066[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (9))){
var inst_67024 = (state_67041[(2)]);
var inst_67025 = fluree.db.util.async.throw_err.call(null,inst_67024);
var state_67041__$1 = state_67041;
var statearr_67050_67067 = state_67041__$1;
(statearr_67050_67067[(2)] = inst_67025);

(statearr_67050_67067[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (5))){
var _ = (function (){var statearr_67051 = state_67041;
(statearr_67051[(4)] = cljs.core.rest.call(null,(state_67041[(4)])));

return statearr_67051;
})();
var state_67041__$1 = state_67041;
var ex67046 = (state_67041__$1[(2)]);
var statearr_67052_67068 = state_67041__$1;
(statearr_67052_67068[(5)] = ex67046);


if((ex67046 instanceof Error)){
var statearr_67053_67069 = state_67041__$1;
(statearr_67053_67069[(1)] = (4));

(statearr_67053_67069[(5)] = null);

} else {
throw ex67046;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67042 === (8))){
var inst_67028 = (state_67041[(2)]);
var inst_67029 = fluree.db.dbfunctions.internal.inc.call(null,inst_67028);
var inst_67030 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67031 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67032 = ["inc",inst_67028,inst_67029];
var inst_67033 = cljs.core.PersistentHashMap.fromArrays(inst_67031,inst_67032);
var inst_67034 = [inst_67033,(10)];
var inst_67035 = (new cljs.core.PersistentVector(null,2,(5),inst_67030,inst_67034,null));
var inst_67036 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67035);
var _ = (function (){var statearr_67054 = state_67041;
(statearr_67054[(4)] = cljs.core.rest.call(null,(state_67041[(4)])));

return statearr_67054;
})();
var state_67041__$1 = (function (){var statearr_67055 = state_67041;
(statearr_67055[(7)] = inst_67036);

return statearr_67055;
})();
var statearr_67056_67070 = state_67041__$1;
(statearr_67056_67070[(2)] = inst_67029);

(statearr_67056_67070[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__11469__auto____0 = (function (){
var statearr_67057 = [null,null,null,null,null,null,null,null];
(statearr_67057[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__11469__auto__);

(statearr_67057[(1)] = (1));

return statearr_67057;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__11469__auto____1 = (function (state_67041){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_67041);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e67058){var ex__11472__auto__ = e67058;
var statearr_67059_67071 = state_67041;
(statearr_67059_67071[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_67041[(4)]))){
var statearr_67060_67072 = state_67041;
(statearr_67060_67072[(1)] = cljs.core.first.call(null,(state_67041[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67073 = state_67041;
state_67041 = G__67073;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__11469__auto__ = function(state_67041){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__11469__auto____1.call(this,state_67041);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_67061 = f__11543__auto__.call(null);
(statearr_67061[(6)] = c__11542__auto__);

return statearr_67061;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_67100){
var state_val_67101 = (state_67100[(1)]);
if((state_val_67101 === (7))){
var state_67100__$1 = state_67100;
var statearr_67102_67121 = state_67100__$1;
(statearr_67102_67121[(2)] = n);

(statearr_67102_67121[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67101 === (1))){
var state_67100__$1 = state_67100;
var statearr_67103_67122 = state_67100__$1;
(statearr_67103_67122[(2)] = null);

(statearr_67103_67122[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67101 === (4))){
var inst_67074 = (state_67100[(2)]);
var state_67100__$1 = state_67100;
var statearr_67104_67123 = state_67100__$1;
(statearr_67104_67123[(2)] = inst_67074);

(statearr_67104_67123[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67101 === (6))){
var state_67100__$1 = state_67100;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67100__$1,(9),n);
} else {
if((state_val_67101 === (3))){
var inst_67098 = (state_67100[(2)]);
var state_67100__$1 = state_67100;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67100__$1,inst_67098);
} else {
if((state_val_67101 === (2))){
var _ = (function (){var statearr_67106 = state_67100;
(statearr_67106[(4)] = cljs.core.cons.call(null,(5),(state_67100[(4)])));

return statearr_67106;
})();
var inst_67080 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_67100__$1 = state_67100;
if(inst_67080){
var statearr_67107_67124 = state_67100__$1;
(statearr_67107_67124[(1)] = (6));

} else {
var statearr_67108_67125 = state_67100__$1;
(statearr_67108_67125[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67101 === (9))){
var inst_67083 = (state_67100[(2)]);
var inst_67084 = fluree.db.util.async.throw_err.call(null,inst_67083);
var state_67100__$1 = state_67100;
var statearr_67109_67126 = state_67100__$1;
(statearr_67109_67126[(2)] = inst_67084);

(statearr_67109_67126[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67101 === (5))){
var _ = (function (){var statearr_67110 = state_67100;
(statearr_67110[(4)] = cljs.core.rest.call(null,(state_67100[(4)])));

return statearr_67110;
})();
var state_67100__$1 = state_67100;
var ex67105 = (state_67100__$1[(2)]);
var statearr_67111_67127 = state_67100__$1;
(statearr_67111_67127[(5)] = ex67105);


if((ex67105 instanceof Error)){
var statearr_67112_67128 = state_67100__$1;
(statearr_67112_67128[(1)] = (4));

(statearr_67112_67128[(5)] = null);

} else {
throw ex67105;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67101 === (8))){
var inst_67087 = (state_67100[(2)]);
var inst_67088 = fluree.db.dbfunctions.internal.dec.call(null,inst_67087);
var inst_67089 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67090 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67091 = ["dec",inst_67087,inst_67088];
var inst_67092 = cljs.core.PersistentHashMap.fromArrays(inst_67090,inst_67091);
var inst_67093 = [inst_67092,(10)];
var inst_67094 = (new cljs.core.PersistentVector(null,2,(5),inst_67089,inst_67093,null));
var inst_67095 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67094);
var _ = (function (){var statearr_67113 = state_67100;
(statearr_67113[(4)] = cljs.core.rest.call(null,(state_67100[(4)])));

return statearr_67113;
})();
var state_67100__$1 = (function (){var statearr_67114 = state_67100;
(statearr_67114[(7)] = inst_67095);

return statearr_67114;
})();
var statearr_67115_67129 = state_67100__$1;
(statearr_67115_67129[(2)] = inst_67088);

(statearr_67115_67129[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__11469__auto____0 = (function (){
var statearr_67116 = [null,null,null,null,null,null,null,null];
(statearr_67116[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__11469__auto__);

(statearr_67116[(1)] = (1));

return statearr_67116;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__11469__auto____1 = (function (state_67100){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_67100);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e67117){var ex__11472__auto__ = e67117;
var statearr_67118_67130 = state_67100;
(statearr_67118_67130[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_67100[(4)]))){
var statearr_67119_67131 = state_67100;
(statearr_67119_67131[(1)] = cljs.core.first.call(null,(state_67100[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67132 = state_67100;
state_67100 = G__67132;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__11469__auto__ = function(state_67100){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__11469__auto____1.call(this,state_67100);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_67120 = f__11543__auto__.call(null);
(statearr_67120[(6)] = c__11542__auto__);

return statearr_67120;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx).toEpochMilli();
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___67182 = arguments.length;
var i__4737__auto___67183 = (0);
while(true){
if((i__4737__auto___67183 < len__4736__auto___67182)){
args__4742__auto__.push((arguments[i__4737__auto___67183]));

var G__67184 = (i__4737__auto___67183 + (1));
i__4737__auto___67183 = G__67184;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_67165){
var state_val_67166 = (state_67165[(1)]);
if((state_val_67166 === (1))){
var state_67165__$1 = state_67165;
var statearr_67167_67185 = state_67165__$1;
(statearr_67167_67185[(2)] = null);

(statearr_67167_67185[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67166 === (2))){
var _ = (function (){var statearr_67168 = state_67165;
(statearr_67168[(4)] = cljs.core.cons.call(null,(5),(state_67165[(4)])));

return statearr_67168;
})();
var inst_67141 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_67165__$1 = state_67165;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67165__$1,(6),inst_67141);
} else {
if((state_val_67166 === (3))){
var inst_67163 = (state_67165[(2)]);
var state_67165__$1 = state_67165;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67165__$1,inst_67163);
} else {
if((state_val_67166 === (4))){
var inst_67135 = (state_67165[(2)]);
var state_67165__$1 = state_67165;
var statearr_67170_67186 = state_67165__$1;
(statearr_67170_67186[(2)] = inst_67135);

(statearr_67170_67186[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67166 === (5))){
var _ = (function (){var statearr_67171 = state_67165;
(statearr_67171[(4)] = cljs.core.rest.call(null,(state_67165[(4)])));

return statearr_67171;
})();
var state_67165__$1 = state_67165;
var ex67169 = (state_67165__$1[(2)]);
var statearr_67172_67187 = state_67165__$1;
(statearr_67172_67187[(5)] = ex67169);


if((ex67169 instanceof Error)){
var statearr_67173_67188 = state_67165__$1;
(statearr_67173_67188[(1)] = (4));

(statearr_67173_67188[(5)] = null);

} else {
throw ex67169;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67166 === (6))){
var inst_67143 = (state_67165[(2)]);
var inst_67144 = fluree.db.util.async.throw_err.call(null,inst_67143);
var inst_67145 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._PLUS_,inst_67144);
var inst_67146 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67147 = [inst_67144];
var inst_67148 = (new cljs.core.PersistentVector(null,1,(5),inst_67146,inst_67147,null));
var inst_67149 = cljs.core.count.call(null,inst_67148);
var inst_67150 = ((9) + inst_67149);
var inst_67151 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67152 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67153 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67154 = [inst_67144];
var inst_67155 = (new cljs.core.PersistentVector(null,1,(5),inst_67153,inst_67154,null));
var inst_67156 = ["+",inst_67155,inst_67145];
var inst_67157 = cljs.core.PersistentHashMap.fromArrays(inst_67152,inst_67156);
var inst_67158 = [inst_67157,inst_67150];
var inst_67159 = (new cljs.core.PersistentVector(null,2,(5),inst_67151,inst_67158,null));
var inst_67160 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67159);
var _ = (function (){var statearr_67174 = state_67165;
(statearr_67174[(4)] = cljs.core.rest.call(null,(state_67165[(4)])));

return statearr_67174;
})();
var state_67165__$1 = (function (){var statearr_67175 = state_67165;
(statearr_67175[(7)] = inst_67160);

return statearr_67175;
})();
var statearr_67176_67189 = state_67165__$1;
(statearr_67176_67189[(2)] = inst_67145);

(statearr_67176_67189[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11469__auto____0 = (function (){
var statearr_67177 = [null,null,null,null,null,null,null,null];
(statearr_67177[(0)] = fluree$db$dbfunctions$fns$state_machine__11469__auto__);

(statearr_67177[(1)] = (1));

return statearr_67177;
});
var fluree$db$dbfunctions$fns$state_machine__11469__auto____1 = (function (state_67165){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_67165);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e67178){var ex__11472__auto__ = e67178;
var statearr_67179_67190 = state_67165;
(statearr_67179_67190[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_67165[(4)]))){
var statearr_67180_67191 = state_67165;
(statearr_67180_67191[(1)] = cljs.core.first.call(null,(state_67165[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67192 = state_67165;
state_67165 = G__67192;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11469__auto__ = function(state_67165){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____1.call(this,state_67165);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_67181 = f__11543__auto__.call(null);
(statearr_67181[(6)] = c__11542__auto__);

return statearr_67181;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq67133){
var G__67134 = cljs.core.first.call(null,seq67133);
var seq67133__$1 = cljs.core.next.call(null,seq67133);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67134,seq67133__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___67242 = arguments.length;
var i__4737__auto___67243 = (0);
while(true){
if((i__4737__auto___67243 < len__4736__auto___67242)){
args__4742__auto__.push((arguments[i__4737__auto___67243]));

var G__67244 = (i__4737__auto___67243 + (1));
i__4737__auto___67243 = G__67244;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_67225){
var state_val_67226 = (state_67225[(1)]);
if((state_val_67226 === (1))){
var state_67225__$1 = state_67225;
var statearr_67227_67245 = state_67225__$1;
(statearr_67227_67245[(2)] = null);

(statearr_67227_67245[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67226 === (2))){
var _ = (function (){var statearr_67228 = state_67225;
(statearr_67228[(4)] = cljs.core.cons.call(null,(5),(state_67225[(4)])));

return statearr_67228;
})();
var inst_67201 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_67225__$1 = state_67225;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67225__$1,(6),inst_67201);
} else {
if((state_val_67226 === (3))){
var inst_67223 = (state_67225[(2)]);
var state_67225__$1 = state_67225;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67225__$1,inst_67223);
} else {
if((state_val_67226 === (4))){
var inst_67195 = (state_67225[(2)]);
var state_67225__$1 = state_67225;
var statearr_67230_67246 = state_67225__$1;
(statearr_67230_67246[(2)] = inst_67195);

(statearr_67230_67246[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67226 === (5))){
var _ = (function (){var statearr_67231 = state_67225;
(statearr_67231[(4)] = cljs.core.rest.call(null,(state_67225[(4)])));

return statearr_67231;
})();
var state_67225__$1 = state_67225;
var ex67229 = (state_67225__$1[(2)]);
var statearr_67232_67247 = state_67225__$1;
(statearr_67232_67247[(5)] = ex67229);


if((ex67229 instanceof Error)){
var statearr_67233_67248 = state_67225__$1;
(statearr_67233_67248[(1)] = (4));

(statearr_67233_67248[(5)] = null);

} else {
throw ex67229;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67226 === (6))){
var inst_67203 = (state_67225[(2)]);
var inst_67204 = fluree.db.util.async.throw_err.call(null,inst_67203);
var inst_67205 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._,inst_67204);
var inst_67206 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67207 = [inst_67204];
var inst_67208 = (new cljs.core.PersistentVector(null,1,(5),inst_67206,inst_67207,null));
var inst_67209 = cljs.core.count.call(null,inst_67208);
var inst_67210 = ((9) + inst_67209);
var inst_67211 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67212 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67213 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67214 = [inst_67204];
var inst_67215 = (new cljs.core.PersistentVector(null,1,(5),inst_67213,inst_67214,null));
var inst_67216 = ["-",inst_67215,inst_67205];
var inst_67217 = cljs.core.PersistentHashMap.fromArrays(inst_67212,inst_67216);
var inst_67218 = [inst_67217,inst_67210];
var inst_67219 = (new cljs.core.PersistentVector(null,2,(5),inst_67211,inst_67218,null));
var inst_67220 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67219);
var _ = (function (){var statearr_67234 = state_67225;
(statearr_67234[(4)] = cljs.core.rest.call(null,(state_67225[(4)])));

return statearr_67234;
})();
var state_67225__$1 = (function (){var statearr_67235 = state_67225;
(statearr_67235[(7)] = inst_67220);

return statearr_67235;
})();
var statearr_67236_67249 = state_67225__$1;
(statearr_67236_67249[(2)] = inst_67205);

(statearr_67236_67249[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11469__auto____0 = (function (){
var statearr_67237 = [null,null,null,null,null,null,null,null];
(statearr_67237[(0)] = fluree$db$dbfunctions$fns$state_machine__11469__auto__);

(statearr_67237[(1)] = (1));

return statearr_67237;
});
var fluree$db$dbfunctions$fns$state_machine__11469__auto____1 = (function (state_67225){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_67225);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e67238){var ex__11472__auto__ = e67238;
var statearr_67239_67250 = state_67225;
(statearr_67239_67250[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_67225[(4)]))){
var statearr_67240_67251 = state_67225;
(statearr_67240_67251[(1)] = cljs.core.first.call(null,(state_67225[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67252 = state_67225;
state_67225 = G__67252;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11469__auto__ = function(state_67225){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____1.call(this,state_67225);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_67241 = f__11543__auto__.call(null);
(statearr_67241[(6)] = c__11542__auto__);

return statearr_67241;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq67193){
var G__67194 = cljs.core.first.call(null,seq67193);
var seq67193__$1 = cljs.core.next.call(null,seq67193);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67194,seq67193__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___67302 = arguments.length;
var i__4737__auto___67303 = (0);
while(true){
if((i__4737__auto___67303 < len__4736__auto___67302)){
args__4742__auto__.push((arguments[i__4737__auto___67303]));

var G__67304 = (i__4737__auto___67303 + (1));
i__4737__auto___67303 = G__67304;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_67285){
var state_val_67286 = (state_67285[(1)]);
if((state_val_67286 === (1))){
var state_67285__$1 = state_67285;
var statearr_67287_67305 = state_67285__$1;
(statearr_67287_67305[(2)] = null);

(statearr_67287_67305[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67286 === (2))){
var _ = (function (){var statearr_67288 = state_67285;
(statearr_67288[(4)] = cljs.core.cons.call(null,(5),(state_67285[(4)])));

return statearr_67288;
})();
var inst_67261 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_67285__$1 = state_67285;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67285__$1,(6),inst_67261);
} else {
if((state_val_67286 === (3))){
var inst_67283 = (state_67285[(2)]);
var state_67285__$1 = state_67285;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67285__$1,inst_67283);
} else {
if((state_val_67286 === (4))){
var inst_67255 = (state_67285[(2)]);
var state_67285__$1 = state_67285;
var statearr_67290_67306 = state_67285__$1;
(statearr_67290_67306[(2)] = inst_67255);

(statearr_67290_67306[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67286 === (5))){
var _ = (function (){var statearr_67291 = state_67285;
(statearr_67291[(4)] = cljs.core.rest.call(null,(state_67285[(4)])));

return statearr_67291;
})();
var state_67285__$1 = state_67285;
var ex67289 = (state_67285__$1[(2)]);
var statearr_67292_67307 = state_67285__$1;
(statearr_67292_67307[(5)] = ex67289);


if((ex67289 instanceof Error)){
var statearr_67293_67308 = state_67285__$1;
(statearr_67293_67308[(1)] = (4));

(statearr_67293_67308[(5)] = null);

} else {
throw ex67289;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67286 === (6))){
var inst_67263 = (state_67285[(2)]);
var inst_67264 = fluree.db.util.async.throw_err.call(null,inst_67263);
var inst_67265 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._STAR_,inst_67264);
var inst_67266 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67267 = [inst_67264];
var inst_67268 = (new cljs.core.PersistentVector(null,1,(5),inst_67266,inst_67267,null));
var inst_67269 = cljs.core.count.call(null,inst_67268);
var inst_67270 = ((9) + inst_67269);
var inst_67271 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67272 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67273 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67274 = [inst_67264];
var inst_67275 = (new cljs.core.PersistentVector(null,1,(5),inst_67273,inst_67274,null));
var inst_67276 = ["*",inst_67275,inst_67265];
var inst_67277 = cljs.core.PersistentHashMap.fromArrays(inst_67272,inst_67276);
var inst_67278 = [inst_67277,inst_67270];
var inst_67279 = (new cljs.core.PersistentVector(null,2,(5),inst_67271,inst_67278,null));
var inst_67280 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67279);
var _ = (function (){var statearr_67294 = state_67285;
(statearr_67294[(4)] = cljs.core.rest.call(null,(state_67285[(4)])));

return statearr_67294;
})();
var state_67285__$1 = (function (){var statearr_67295 = state_67285;
(statearr_67295[(7)] = inst_67280);

return statearr_67295;
})();
var statearr_67296_67309 = state_67285__$1;
(statearr_67296_67309[(2)] = inst_67265);

(statearr_67296_67309[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11469__auto____0 = (function (){
var statearr_67297 = [null,null,null,null,null,null,null,null];
(statearr_67297[(0)] = fluree$db$dbfunctions$fns$state_machine__11469__auto__);

(statearr_67297[(1)] = (1));

return statearr_67297;
});
var fluree$db$dbfunctions$fns$state_machine__11469__auto____1 = (function (state_67285){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_67285);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e67298){var ex__11472__auto__ = e67298;
var statearr_67299_67310 = state_67285;
(statearr_67299_67310[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_67285[(4)]))){
var statearr_67300_67311 = state_67285;
(statearr_67300_67311[(1)] = cljs.core.first.call(null,(state_67285[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67312 = state_67285;
state_67285 = G__67312;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11469__auto__ = function(state_67285){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____1.call(this,state_67285);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_67301 = f__11543__auto__.call(null);
(statearr_67301[(6)] = c__11542__auto__);

return statearr_67301;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq67253){
var G__67254 = cljs.core.first.call(null,seq67253);
var seq67253__$1 = cljs.core.next.call(null,seq67253);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67254,seq67253__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___67362 = arguments.length;
var i__4737__auto___67363 = (0);
while(true){
if((i__4737__auto___67363 < len__4736__auto___67362)){
args__4742__auto__.push((arguments[i__4737__auto___67363]));

var G__67364 = (i__4737__auto___67363 + (1));
i__4737__auto___67363 = G__67364;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_67345){
var state_val_67346 = (state_67345[(1)]);
if((state_val_67346 === (1))){
var state_67345__$1 = state_67345;
var statearr_67347_67365 = state_67345__$1;
(statearr_67347_67365[(2)] = null);

(statearr_67347_67365[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67346 === (2))){
var _ = (function (){var statearr_67348 = state_67345;
(statearr_67348[(4)] = cljs.core.cons.call(null,(5),(state_67345[(4)])));

return statearr_67348;
})();
var inst_67321 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_67345__$1 = state_67345;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67345__$1,(6),inst_67321);
} else {
if((state_val_67346 === (3))){
var inst_67343 = (state_67345[(2)]);
var state_67345__$1 = state_67345;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67345__$1,inst_67343);
} else {
if((state_val_67346 === (4))){
var inst_67315 = (state_67345[(2)]);
var state_67345__$1 = state_67345;
var statearr_67350_67366 = state_67345__$1;
(statearr_67350_67366[(2)] = inst_67315);

(statearr_67350_67366[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67346 === (5))){
var _ = (function (){var statearr_67351 = state_67345;
(statearr_67351[(4)] = cljs.core.rest.call(null,(state_67345[(4)])));

return statearr_67351;
})();
var state_67345__$1 = state_67345;
var ex67349 = (state_67345__$1[(2)]);
var statearr_67352_67367 = state_67345__$1;
(statearr_67352_67367[(5)] = ex67349);


if((ex67349 instanceof Error)){
var statearr_67353_67368 = state_67345__$1;
(statearr_67353_67368[(1)] = (4));

(statearr_67353_67368[(5)] = null);

} else {
throw ex67349;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67346 === (6))){
var inst_67323 = (state_67345[(2)]);
var inst_67324 = fluree.db.util.async.throw_err.call(null,inst_67323);
var inst_67325 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._SLASH_,inst_67324);
var inst_67326 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67327 = [inst_67324];
var inst_67328 = (new cljs.core.PersistentVector(null,1,(5),inst_67326,inst_67327,null));
var inst_67329 = cljs.core.count.call(null,inst_67328);
var inst_67330 = ((9) + inst_67329);
var inst_67331 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67332 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67333 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67334 = [inst_67324];
var inst_67335 = (new cljs.core.PersistentVector(null,1,(5),inst_67333,inst_67334,null));
var inst_67336 = ["/",inst_67335,inst_67325];
var inst_67337 = cljs.core.PersistentHashMap.fromArrays(inst_67332,inst_67336);
var inst_67338 = [inst_67337,inst_67330];
var inst_67339 = (new cljs.core.PersistentVector(null,2,(5),inst_67331,inst_67338,null));
var inst_67340 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67339);
var _ = (function (){var statearr_67354 = state_67345;
(statearr_67354[(4)] = cljs.core.rest.call(null,(state_67345[(4)])));

return statearr_67354;
})();
var state_67345__$1 = (function (){var statearr_67355 = state_67345;
(statearr_67355[(7)] = inst_67340);

return statearr_67355;
})();
var statearr_67356_67369 = state_67345__$1;
(statearr_67356_67369[(2)] = inst_67325);

(statearr_67356_67369[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11469__auto____0 = (function (){
var statearr_67357 = [null,null,null,null,null,null,null,null];
(statearr_67357[(0)] = fluree$db$dbfunctions$fns$state_machine__11469__auto__);

(statearr_67357[(1)] = (1));

return statearr_67357;
});
var fluree$db$dbfunctions$fns$state_machine__11469__auto____1 = (function (state_67345){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_67345);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e67358){var ex__11472__auto__ = e67358;
var statearr_67359_67370 = state_67345;
(statearr_67359_67370[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_67345[(4)]))){
var statearr_67360_67371 = state_67345;
(statearr_67360_67371[(1)] = cljs.core.first.call(null,(state_67345[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67372 = state_67345;
state_67345 = G__67372;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11469__auto__ = function(state_67345){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____1.call(this,state_67345);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_67361 = f__11543__auto__.call(null);
(statearr_67361[(6)] = c__11542__auto__);

return statearr_67361;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq67313){
var G__67314 = cljs.core.first.call(null,seq67313);
var seq67313__$1 = cljs.core.next.call(null,seq67313);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67314,seq67313__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_67410){
var state_val_67411 = (state_67410[(1)]);
if((state_val_67411 === (7))){
var state_67410__$1 = state_67410;
var statearr_67412_67436 = state_67410__$1;
(statearr_67412_67436[(2)] = n);

(statearr_67412_67436[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67411 === (1))){
var state_67410__$1 = state_67410;
var statearr_67413_67437 = state_67410__$1;
(statearr_67413_67437[(2)] = null);

(statearr_67413_67437[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67411 === (4))){
var inst_67373 = (state_67410[(2)]);
var state_67410__$1 = state_67410;
var statearr_67414_67438 = state_67410__$1;
(statearr_67414_67438[(2)] = inst_67373);

(statearr_67414_67438[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67411 === (13))){
var inst_67390 = (state_67410[(2)]);
var inst_67391 = fluree.db.util.async.throw_err.call(null,inst_67390);
var state_67410__$1 = state_67410;
var statearr_67415_67439 = state_67410__$1;
(statearr_67415_67439[(2)] = inst_67391);

(statearr_67415_67439[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67411 === (6))){
var state_67410__$1 = state_67410;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67410__$1,(9),n);
} else {
if((state_val_67411 === (3))){
var inst_67408 = (state_67410[(2)]);
var state_67410__$1 = state_67410;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67410__$1,inst_67408);
} else {
if((state_val_67411 === (12))){
var inst_67386 = (state_67410[(7)]);
var inst_67394 = (state_67410[(2)]);
var inst_67395 = fluree.db.dbfunctions.internal.quot.call(null,inst_67386,inst_67394);
var inst_67396 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67397 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67398 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67399 = [inst_67386,inst_67394];
var inst_67400 = (new cljs.core.PersistentVector(null,2,(5),inst_67398,inst_67399,null));
var inst_67401 = ["quot",inst_67400,inst_67395];
var inst_67402 = cljs.core.PersistentHashMap.fromArrays(inst_67397,inst_67401);
var inst_67403 = [inst_67402,(2)];
var inst_67404 = (new cljs.core.PersistentVector(null,2,(5),inst_67396,inst_67403,null));
var inst_67405 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67404);
var _ = (function (){var statearr_67416 = state_67410;
(statearr_67416[(4)] = cljs.core.rest.call(null,(state_67410[(4)])));

return statearr_67416;
})();
var state_67410__$1 = (function (){var statearr_67417 = state_67410;
(statearr_67417[(8)] = inst_67405);

return statearr_67417;
})();
var statearr_67418_67440 = state_67410__$1;
(statearr_67418_67440[(2)] = inst_67395);

(statearr_67418_67440[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67411 === (2))){
var _ = (function (){var statearr_67419 = state_67410;
(statearr_67419[(4)] = cljs.core.cons.call(null,(5),(state_67410[(4)])));

return statearr_67419;
})();
var inst_67379 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_67410__$1 = state_67410;
if(inst_67379){
var statearr_67420_67441 = state_67410__$1;
(statearr_67420_67441[(1)] = (6));

} else {
var statearr_67421_67442 = state_67410__$1;
(statearr_67421_67442[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67411 === (11))){
var state_67410__$1 = state_67410;
var statearr_67423_67443 = state_67410__$1;
(statearr_67423_67443[(2)] = d);

(statearr_67423_67443[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67411 === (9))){
var inst_67382 = (state_67410[(2)]);
var inst_67383 = fluree.db.util.async.throw_err.call(null,inst_67382);
var state_67410__$1 = state_67410;
var statearr_67424_67444 = state_67410__$1;
(statearr_67424_67444[(2)] = inst_67383);

(statearr_67424_67444[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67411 === (5))){
var _ = (function (){var statearr_67425 = state_67410;
(statearr_67425[(4)] = cljs.core.rest.call(null,(state_67410[(4)])));

return statearr_67425;
})();
var state_67410__$1 = state_67410;
var ex67422 = (state_67410__$1[(2)]);
var statearr_67426_67445 = state_67410__$1;
(statearr_67426_67445[(5)] = ex67422);


if((ex67422 instanceof Error)){
var statearr_67427_67446 = state_67410__$1;
(statearr_67427_67446[(1)] = (4));

(statearr_67427_67446[(5)] = null);

} else {
throw ex67422;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67411 === (10))){
var state_67410__$1 = state_67410;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67410__$1,(13),d);
} else {
if((state_val_67411 === (8))){
var inst_67386 = (state_67410[(2)]);
var inst_67387 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_67410__$1 = (function (){var statearr_67428 = state_67410;
(statearr_67428[(7)] = inst_67386);

return statearr_67428;
})();
if(inst_67387){
var statearr_67429_67447 = state_67410__$1;
(statearr_67429_67447[(1)] = (10));

} else {
var statearr_67430_67448 = state_67410__$1;
(statearr_67430_67448[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__11469__auto____0 = (function (){
var statearr_67431 = [null,null,null,null,null,null,null,null,null];
(statearr_67431[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__11469__auto__);

(statearr_67431[(1)] = (1));

return statearr_67431;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__11469__auto____1 = (function (state_67410){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_67410);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e67432){var ex__11472__auto__ = e67432;
var statearr_67433_67449 = state_67410;
(statearr_67433_67449[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_67410[(4)]))){
var statearr_67434_67450 = state_67410;
(statearr_67434_67450[(1)] = cljs.core.first.call(null,(state_67410[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67451 = state_67410;
state_67410 = G__67451;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__11469__auto__ = function(state_67410){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__11469__auto____1.call(this,state_67410);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_67435 = f__11543__auto__.call(null);
(statearr_67435[(6)] = c__11542__auto__);

return statearr_67435;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_67489){
var state_val_67490 = (state_67489[(1)]);
if((state_val_67490 === (7))){
var state_67489__$1 = state_67489;
var statearr_67491_67515 = state_67489__$1;
(statearr_67491_67515[(2)] = n);

(statearr_67491_67515[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67490 === (1))){
var state_67489__$1 = state_67489;
var statearr_67492_67516 = state_67489__$1;
(statearr_67492_67516[(2)] = null);

(statearr_67492_67516[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67490 === (4))){
var inst_67452 = (state_67489[(2)]);
var state_67489__$1 = state_67489;
var statearr_67493_67517 = state_67489__$1;
(statearr_67493_67517[(2)] = inst_67452);

(statearr_67493_67517[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67490 === (13))){
var inst_67469 = (state_67489[(2)]);
var inst_67470 = fluree.db.util.async.throw_err.call(null,inst_67469);
var state_67489__$1 = state_67489;
var statearr_67494_67518 = state_67489__$1;
(statearr_67494_67518[(2)] = inst_67470);

(statearr_67494_67518[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67490 === (6))){
var state_67489__$1 = state_67489;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67489__$1,(9),n);
} else {
if((state_val_67490 === (3))){
var inst_67487 = (state_67489[(2)]);
var state_67489__$1 = state_67489;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67489__$1,inst_67487);
} else {
if((state_val_67490 === (12))){
var inst_67465 = (state_67489[(7)]);
var inst_67473 = (state_67489[(2)]);
var inst_67474 = fluree.db.dbfunctions.internal.mod.call(null,inst_67465,inst_67473);
var inst_67475 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67476 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67477 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67478 = [inst_67465,inst_67473];
var inst_67479 = (new cljs.core.PersistentVector(null,2,(5),inst_67477,inst_67478,null));
var inst_67480 = ["mod",inst_67479,inst_67474];
var inst_67481 = cljs.core.PersistentHashMap.fromArrays(inst_67476,inst_67480);
var inst_67482 = [inst_67481,(2)];
var inst_67483 = (new cljs.core.PersistentVector(null,2,(5),inst_67475,inst_67482,null));
var inst_67484 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67483);
var _ = (function (){var statearr_67495 = state_67489;
(statearr_67495[(4)] = cljs.core.rest.call(null,(state_67489[(4)])));

return statearr_67495;
})();
var state_67489__$1 = (function (){var statearr_67496 = state_67489;
(statearr_67496[(8)] = inst_67484);

return statearr_67496;
})();
var statearr_67497_67519 = state_67489__$1;
(statearr_67497_67519[(2)] = inst_67474);

(statearr_67497_67519[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67490 === (2))){
var _ = (function (){var statearr_67498 = state_67489;
(statearr_67498[(4)] = cljs.core.cons.call(null,(5),(state_67489[(4)])));

return statearr_67498;
})();
var inst_67458 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_67489__$1 = state_67489;
if(inst_67458){
var statearr_67499_67520 = state_67489__$1;
(statearr_67499_67520[(1)] = (6));

} else {
var statearr_67500_67521 = state_67489__$1;
(statearr_67500_67521[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67490 === (11))){
var state_67489__$1 = state_67489;
var statearr_67502_67522 = state_67489__$1;
(statearr_67502_67522[(2)] = d);

(statearr_67502_67522[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67490 === (9))){
var inst_67461 = (state_67489[(2)]);
var inst_67462 = fluree.db.util.async.throw_err.call(null,inst_67461);
var state_67489__$1 = state_67489;
var statearr_67503_67523 = state_67489__$1;
(statearr_67503_67523[(2)] = inst_67462);

(statearr_67503_67523[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67490 === (5))){
var _ = (function (){var statearr_67504 = state_67489;
(statearr_67504[(4)] = cljs.core.rest.call(null,(state_67489[(4)])));

return statearr_67504;
})();
var state_67489__$1 = state_67489;
var ex67501 = (state_67489__$1[(2)]);
var statearr_67505_67524 = state_67489__$1;
(statearr_67505_67524[(5)] = ex67501);


if((ex67501 instanceof Error)){
var statearr_67506_67525 = state_67489__$1;
(statearr_67506_67525[(1)] = (4));

(statearr_67506_67525[(5)] = null);

} else {
throw ex67501;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67490 === (10))){
var state_67489__$1 = state_67489;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67489__$1,(13),d);
} else {
if((state_val_67490 === (8))){
var inst_67465 = (state_67489[(2)]);
var inst_67466 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_67489__$1 = (function (){var statearr_67507 = state_67489;
(statearr_67507[(7)] = inst_67465);

return statearr_67507;
})();
if(inst_67466){
var statearr_67508_67526 = state_67489__$1;
(statearr_67508_67526[(1)] = (10));

} else {
var statearr_67509_67527 = state_67489__$1;
(statearr_67509_67527[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__11469__auto____0 = (function (){
var statearr_67510 = [null,null,null,null,null,null,null,null,null];
(statearr_67510[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__11469__auto__);

(statearr_67510[(1)] = (1));

return statearr_67510;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__11469__auto____1 = (function (state_67489){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_67489);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e67511){var ex__11472__auto__ = e67511;
var statearr_67512_67528 = state_67489;
(statearr_67512_67528[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_67489[(4)]))){
var statearr_67513_67529 = state_67489;
(statearr_67513_67529[(1)] = cljs.core.first.call(null,(state_67489[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67530 = state_67489;
state_67489 = G__67530;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__11469__auto__ = function(state_67489){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__11469__auto____1.call(this,state_67489);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_67514 = f__11543__auto__.call(null);
(statearr_67514[(6)] = c__11542__auto__);

return statearr_67514;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_67568){
var state_val_67569 = (state_67568[(1)]);
if((state_val_67569 === (7))){
var state_67568__$1 = state_67568;
var statearr_67570_67594 = state_67568__$1;
(statearr_67570_67594[(2)] = n);

(statearr_67570_67594[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67569 === (1))){
var state_67568__$1 = state_67568;
var statearr_67571_67595 = state_67568__$1;
(statearr_67571_67595[(2)] = null);

(statearr_67571_67595[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67569 === (4))){
var inst_67531 = (state_67568[(2)]);
var state_67568__$1 = state_67568;
var statearr_67572_67596 = state_67568__$1;
(statearr_67572_67596[(2)] = inst_67531);

(statearr_67572_67596[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67569 === (13))){
var inst_67548 = (state_67568[(2)]);
var inst_67549 = fluree.db.util.async.throw_err.call(null,inst_67548);
var state_67568__$1 = state_67568;
var statearr_67573_67597 = state_67568__$1;
(statearr_67573_67597[(2)] = inst_67549);

(statearr_67573_67597[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67569 === (6))){
var state_67568__$1 = state_67568;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67568__$1,(9),n);
} else {
if((state_val_67569 === (3))){
var inst_67566 = (state_67568[(2)]);
var state_67568__$1 = state_67568;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67568__$1,inst_67566);
} else {
if((state_val_67569 === (12))){
var inst_67544 = (state_67568[(7)]);
var inst_67552 = (state_67568[(2)]);
var inst_67553 = fluree.db.dbfunctions.internal.rem.call(null,inst_67544,inst_67552);
var inst_67554 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67555 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67556 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67557 = [inst_67544,inst_67552];
var inst_67558 = (new cljs.core.PersistentVector(null,2,(5),inst_67556,inst_67557,null));
var inst_67559 = ["rem",inst_67558,inst_67553];
var inst_67560 = cljs.core.PersistentHashMap.fromArrays(inst_67555,inst_67559);
var inst_67561 = [inst_67560,(2)];
var inst_67562 = (new cljs.core.PersistentVector(null,2,(5),inst_67554,inst_67561,null));
var inst_67563 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67562);
var _ = (function (){var statearr_67574 = state_67568;
(statearr_67574[(4)] = cljs.core.rest.call(null,(state_67568[(4)])));

return statearr_67574;
})();
var state_67568__$1 = (function (){var statearr_67575 = state_67568;
(statearr_67575[(8)] = inst_67563);

return statearr_67575;
})();
var statearr_67576_67598 = state_67568__$1;
(statearr_67576_67598[(2)] = inst_67553);

(statearr_67576_67598[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67569 === (2))){
var _ = (function (){var statearr_67577 = state_67568;
(statearr_67577[(4)] = cljs.core.cons.call(null,(5),(state_67568[(4)])));

return statearr_67577;
})();
var inst_67537 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_67568__$1 = state_67568;
if(inst_67537){
var statearr_67578_67599 = state_67568__$1;
(statearr_67578_67599[(1)] = (6));

} else {
var statearr_67579_67600 = state_67568__$1;
(statearr_67579_67600[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67569 === (11))){
var state_67568__$1 = state_67568;
var statearr_67581_67601 = state_67568__$1;
(statearr_67581_67601[(2)] = d);

(statearr_67581_67601[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67569 === (9))){
var inst_67540 = (state_67568[(2)]);
var inst_67541 = fluree.db.util.async.throw_err.call(null,inst_67540);
var state_67568__$1 = state_67568;
var statearr_67582_67602 = state_67568__$1;
(statearr_67582_67602[(2)] = inst_67541);

(statearr_67582_67602[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67569 === (5))){
var _ = (function (){var statearr_67583 = state_67568;
(statearr_67583[(4)] = cljs.core.rest.call(null,(state_67568[(4)])));

return statearr_67583;
})();
var state_67568__$1 = state_67568;
var ex67580 = (state_67568__$1[(2)]);
var statearr_67584_67603 = state_67568__$1;
(statearr_67584_67603[(5)] = ex67580);


if((ex67580 instanceof Error)){
var statearr_67585_67604 = state_67568__$1;
(statearr_67585_67604[(1)] = (4));

(statearr_67585_67604[(5)] = null);

} else {
throw ex67580;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67569 === (10))){
var state_67568__$1 = state_67568;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67568__$1,(13),d);
} else {
if((state_val_67569 === (8))){
var inst_67544 = (state_67568[(2)]);
var inst_67545 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_67568__$1 = (function (){var statearr_67586 = state_67568;
(statearr_67586[(7)] = inst_67544);

return statearr_67586;
})();
if(inst_67545){
var statearr_67587_67605 = state_67568__$1;
(statearr_67587_67605[(1)] = (10));

} else {
var statearr_67588_67606 = state_67568__$1;
(statearr_67588_67606[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__11469__auto____0 = (function (){
var statearr_67589 = [null,null,null,null,null,null,null,null,null];
(statearr_67589[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__11469__auto__);

(statearr_67589[(1)] = (1));

return statearr_67589;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__11469__auto____1 = (function (state_67568){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_67568);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e67590){var ex__11472__auto__ = e67590;
var statearr_67591_67607 = state_67568;
(statearr_67591_67607[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_67568[(4)]))){
var statearr_67592_67608 = state_67568;
(statearr_67592_67608[(1)] = cljs.core.first.call(null,(state_67568[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67609 = state_67568;
state_67568 = G__67609;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__11469__auto__ = function(state_67568){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__11469__auto____1.call(this,state_67568);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_67593 = f__11543__auto__.call(null);
(statearr_67593[(6)] = c__11542__auto__);

return statearr_67593;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_67636){
var state_val_67637 = (state_67636[(1)]);
if((state_val_67637 === (7))){
var state_67636__$1 = state_67636;
var statearr_67638_67657 = state_67636__$1;
(statearr_67638_67657[(2)] = x);

(statearr_67638_67657[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67637 === (1))){
var state_67636__$1 = state_67636;
var statearr_67639_67658 = state_67636__$1;
(statearr_67639_67658[(2)] = null);

(statearr_67639_67658[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67637 === (4))){
var inst_67610 = (state_67636[(2)]);
var state_67636__$1 = state_67636;
var statearr_67640_67659 = state_67636__$1;
(statearr_67640_67659[(2)] = inst_67610);

(statearr_67640_67659[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67637 === (6))){
var state_67636__$1 = state_67636;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67636__$1,(9),x);
} else {
if((state_val_67637 === (3))){
var inst_67634 = (state_67636[(2)]);
var state_67636__$1 = state_67636;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67636__$1,inst_67634);
} else {
if((state_val_67637 === (2))){
var _ = (function (){var statearr_67642 = state_67636;
(statearr_67642[(4)] = cljs.core.cons.call(null,(5),(state_67636[(4)])));

return statearr_67642;
})();
var inst_67616 = fluree.db.util.async.channel_QMARK_.call(null,x);
var state_67636__$1 = state_67636;
if(inst_67616){
var statearr_67643_67660 = state_67636__$1;
(statearr_67643_67660[(1)] = (6));

} else {
var statearr_67644_67661 = state_67636__$1;
(statearr_67644_67661[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67637 === (9))){
var inst_67619 = (state_67636[(2)]);
var inst_67620 = fluree.db.util.async.throw_err.call(null,inst_67619);
var state_67636__$1 = state_67636;
var statearr_67645_67662 = state_67636__$1;
(statearr_67645_67662[(2)] = inst_67620);

(statearr_67645_67662[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67637 === (5))){
var _ = (function (){var statearr_67646 = state_67636;
(statearr_67646[(4)] = cljs.core.rest.call(null,(state_67636[(4)])));

return statearr_67646;
})();
var state_67636__$1 = state_67636;
var ex67641 = (state_67636__$1[(2)]);
var statearr_67647_67663 = state_67636__$1;
(statearr_67647_67663[(5)] = ex67641);


if((ex67641 instanceof Error)){
var statearr_67648_67664 = state_67636__$1;
(statearr_67648_67664[(1)] = (4));

(statearr_67648_67664[(5)] = null);

} else {
throw ex67641;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67637 === (8))){
var inst_67623 = (state_67636[(2)]);
var inst_67624 = fluree.db.dbfunctions.internal.boolean$.call(null,inst_67623);
var inst_67625 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67626 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67627 = ["boolean",inst_67623,inst_67624];
var inst_67628 = cljs.core.PersistentHashMap.fromArrays(inst_67626,inst_67627);
var inst_67629 = [inst_67628,(10)];
var inst_67630 = (new cljs.core.PersistentVector(null,2,(5),inst_67625,inst_67629,null));
var inst_67631 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67630);
var _ = (function (){var statearr_67649 = state_67636;
(statearr_67649[(4)] = cljs.core.rest.call(null,(state_67636[(4)])));

return statearr_67649;
})();
var state_67636__$1 = (function (){var statearr_67650 = state_67636;
(statearr_67650[(7)] = inst_67631);

return statearr_67650;
})();
var statearr_67651_67665 = state_67636__$1;
(statearr_67651_67665[(2)] = inst_67624);

(statearr_67651_67665[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__11469__auto____0 = (function (){
var statearr_67652 = [null,null,null,null,null,null,null,null];
(statearr_67652[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__11469__auto__);

(statearr_67652[(1)] = (1));

return statearr_67652;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__11469__auto____1 = (function (state_67636){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_67636);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e67653){var ex__11472__auto__ = e67653;
var statearr_67654_67666 = state_67636;
(statearr_67654_67666[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_67636[(4)]))){
var statearr_67655_67667 = state_67636;
(statearr_67655_67667[(1)] = cljs.core.first.call(null,(state_67636[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67668 = state_67636;
state_67636 = G__67668;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__11469__auto__ = function(state_67636){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__11469__auto____1.call(this,state_67636);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_67656 = f__11543__auto__.call(null);
(statearr_67656[(6)] = c__11542__auto__);

return statearr_67656;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_67706){
var state_val_67707 = (state_67706[(1)]);
if((state_val_67707 === (7))){
var state_67706__$1 = state_67706;
var statearr_67708_67732 = state_67706__$1;
(statearr_67708_67732[(2)] = pattern);

(statearr_67708_67732[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67707 === (1))){
var state_67706__$1 = state_67706;
var statearr_67709_67733 = state_67706__$1;
(statearr_67709_67733[(2)] = null);

(statearr_67709_67733[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67707 === (4))){
var inst_67669 = (state_67706[(2)]);
var state_67706__$1 = state_67706;
var statearr_67710_67734 = state_67706__$1;
(statearr_67710_67734[(2)] = inst_67669);

(statearr_67710_67734[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67707 === (13))){
var inst_67686 = (state_67706[(2)]);
var inst_67687 = fluree.db.util.async.throw_err.call(null,inst_67686);
var state_67706__$1 = state_67706;
var statearr_67711_67735 = state_67706__$1;
(statearr_67711_67735[(2)] = inst_67687);

(statearr_67711_67735[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67707 === (6))){
var state_67706__$1 = state_67706;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67706__$1,(9),pattern);
} else {
if((state_val_67707 === (3))){
var inst_67704 = (state_67706[(2)]);
var state_67706__$1 = state_67706;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67706__$1,inst_67704);
} else {
if((state_val_67707 === (12))){
var inst_67682 = (state_67706[(7)]);
var inst_67690 = (state_67706[(2)]);
var inst_67691 = fluree.db.dbfunctions.internal.re_find.call(null,inst_67682,inst_67690);
var inst_67692 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67693 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67694 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67695 = [inst_67682,inst_67690];
var inst_67696 = (new cljs.core.PersistentVector(null,2,(5),inst_67694,inst_67695,null));
var inst_67697 = ["re-find",inst_67696,inst_67691];
var inst_67698 = cljs.core.PersistentHashMap.fromArrays(inst_67693,inst_67697);
var inst_67699 = [inst_67698,(10)];
var inst_67700 = (new cljs.core.PersistentVector(null,2,(5),inst_67692,inst_67699,null));
var inst_67701 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67700);
var _ = (function (){var statearr_67712 = state_67706;
(statearr_67712[(4)] = cljs.core.rest.call(null,(state_67706[(4)])));

return statearr_67712;
})();
var state_67706__$1 = (function (){var statearr_67713 = state_67706;
(statearr_67713[(8)] = inst_67701);

return statearr_67713;
})();
var statearr_67714_67736 = state_67706__$1;
(statearr_67714_67736[(2)] = inst_67691);

(statearr_67714_67736[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67707 === (2))){
var _ = (function (){var statearr_67715 = state_67706;
(statearr_67715[(4)] = cljs.core.cons.call(null,(5),(state_67706[(4)])));

return statearr_67715;
})();
var inst_67675 = fluree.db.util.async.channel_QMARK_.call(null,pattern);
var state_67706__$1 = state_67706;
if(inst_67675){
var statearr_67716_67737 = state_67706__$1;
(statearr_67716_67737[(1)] = (6));

} else {
var statearr_67717_67738 = state_67706__$1;
(statearr_67717_67738[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67707 === (11))){
var state_67706__$1 = state_67706;
var statearr_67719_67739 = state_67706__$1;
(statearr_67719_67739[(2)] = string);

(statearr_67719_67739[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67707 === (9))){
var inst_67678 = (state_67706[(2)]);
var inst_67679 = fluree.db.util.async.throw_err.call(null,inst_67678);
var state_67706__$1 = state_67706;
var statearr_67720_67740 = state_67706__$1;
(statearr_67720_67740[(2)] = inst_67679);

(statearr_67720_67740[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67707 === (5))){
var _ = (function (){var statearr_67721 = state_67706;
(statearr_67721[(4)] = cljs.core.rest.call(null,(state_67706[(4)])));

return statearr_67721;
})();
var state_67706__$1 = state_67706;
var ex67718 = (state_67706__$1[(2)]);
var statearr_67722_67741 = state_67706__$1;
(statearr_67722_67741[(5)] = ex67718);


if((ex67718 instanceof Error)){
var statearr_67723_67742 = state_67706__$1;
(statearr_67723_67742[(1)] = (4));

(statearr_67723_67742[(5)] = null);

} else {
throw ex67718;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67707 === (10))){
var state_67706__$1 = state_67706;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67706__$1,(13),string);
} else {
if((state_val_67707 === (8))){
var inst_67682 = (state_67706[(2)]);
var inst_67683 = fluree.db.util.async.channel_QMARK_.call(null,string);
var state_67706__$1 = (function (){var statearr_67724 = state_67706;
(statearr_67724[(7)] = inst_67682);

return statearr_67724;
})();
if(inst_67683){
var statearr_67725_67743 = state_67706__$1;
(statearr_67725_67743[(1)] = (10));

} else {
var statearr_67726_67744 = state_67706__$1;
(statearr_67726_67744[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__11469__auto____0 = (function (){
var statearr_67727 = [null,null,null,null,null,null,null,null,null];
(statearr_67727[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__11469__auto__);

(statearr_67727[(1)] = (1));

return statearr_67727;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__11469__auto____1 = (function (state_67706){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_67706);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e67728){var ex__11472__auto__ = e67728;
var statearr_67729_67745 = state_67706;
(statearr_67729_67745[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_67706[(4)]))){
var statearr_67730_67746 = state_67706;
(statearr_67730_67746[(1)] = cljs.core.first.call(null,(state_67706[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67747 = state_67706;
state_67706 = G__67747;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__11469__auto__ = function(state_67706){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__11469__auto____1.call(this,state_67706);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_67731 = f__11543__auto__.call(null);
(statearr_67731[(6)] = c__11542__auto__);

return statearr_67731;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_67774){
var state_val_67775 = (state_67774[(1)]);
if((state_val_67775 === (7))){
var state_67774__$1 = state_67774;
var statearr_67776_67795 = state_67774__$1;
(statearr_67776_67795[(2)] = email);

(statearr_67776_67795[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67775 === (1))){
var state_67774__$1 = state_67774;
var statearr_67777_67796 = state_67774__$1;
(statearr_67777_67796[(2)] = null);

(statearr_67777_67796[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67775 === (4))){
var inst_67748 = (state_67774[(2)]);
var state_67774__$1 = state_67774;
var statearr_67778_67797 = state_67774__$1;
(statearr_67778_67797[(2)] = inst_67748);

(statearr_67778_67797[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67775 === (6))){
var state_67774__$1 = state_67774;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67774__$1,(9),email);
} else {
if((state_val_67775 === (3))){
var inst_67772 = (state_67774[(2)]);
var state_67774__$1 = state_67774;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67774__$1,inst_67772);
} else {
if((state_val_67775 === (2))){
var _ = (function (){var statearr_67780 = state_67774;
(statearr_67780[(4)] = cljs.core.cons.call(null,(5),(state_67774[(4)])));

return statearr_67780;
})();
var inst_67754 = fluree.db.util.async.channel_QMARK_.call(null,email);
var state_67774__$1 = state_67774;
if(inst_67754){
var statearr_67781_67798 = state_67774__$1;
(statearr_67781_67798[(1)] = (6));

} else {
var statearr_67782_67799 = state_67774__$1;
(statearr_67782_67799[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67775 === (9))){
var inst_67757 = (state_67774[(2)]);
var inst_67758 = fluree.db.util.async.throw_err.call(null,inst_67757);
var state_67774__$1 = state_67774;
var statearr_67783_67800 = state_67774__$1;
(statearr_67783_67800[(2)] = inst_67758);

(statearr_67783_67800[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67775 === (5))){
var _ = (function (){var statearr_67784 = state_67774;
(statearr_67784[(4)] = cljs.core.rest.call(null,(state_67774[(4)])));

return statearr_67784;
})();
var state_67774__$1 = state_67774;
var ex67779 = (state_67774__$1[(2)]);
var statearr_67785_67801 = state_67774__$1;
(statearr_67785_67801[(5)] = ex67779);


if((ex67779 instanceof Error)){
var statearr_67786_67802 = state_67774__$1;
(statearr_67786_67802[(1)] = (4));

(statearr_67786_67802[(5)] = null);

} else {
throw ex67779;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67775 === (8))){
var inst_67761 = (state_67774[(2)]);
var inst_67762 = fluree.db.dbfunctions.internal.valid_email_QMARK_.call(null,inst_67761);
var inst_67763 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67764 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67765 = ["re-find",inst_67761,inst_67762];
var inst_67766 = cljs.core.PersistentHashMap.fromArrays(inst_67764,inst_67765);
var inst_67767 = [inst_67766,(10)];
var inst_67768 = (new cljs.core.PersistentVector(null,2,(5),inst_67763,inst_67767,null));
var inst_67769 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67768);
var _ = (function (){var statearr_67787 = state_67774;
(statearr_67787[(4)] = cljs.core.rest.call(null,(state_67774[(4)])));

return statearr_67787;
})();
var state_67774__$1 = (function (){var statearr_67788 = state_67774;
(statearr_67788[(7)] = inst_67769);

return statearr_67788;
})();
var statearr_67789_67803 = state_67774__$1;
(statearr_67789_67803[(2)] = inst_67762);

(statearr_67789_67803[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11469__auto____0 = (function (){
var statearr_67790 = [null,null,null,null,null,null,null,null];
(statearr_67790[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11469__auto__);

(statearr_67790[(1)] = (1));

return statearr_67790;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11469__auto____1 = (function (state_67774){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_67774);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e67791){var ex__11472__auto__ = e67791;
var statearr_67792_67804 = state_67774;
(statearr_67792_67804[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_67774[(4)]))){
var statearr_67793_67805 = state_67774;
(statearr_67793_67805[(1)] = cljs.core.first.call(null,(state_67774[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67806 = state_67774;
state_67774 = G__67806;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11469__auto__ = function(state_67774){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11469__auto____1.call(this,state_67774);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_67794 = f__11543__auto__.call(null);
(statearr_67794[(6)] = c__11542__auto__);

return statearr_67794;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_67853){
var state_val_67854 = (state_67853[(1)]);
if((state_val_67854 === (7))){
var inst_67823 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_67853__$1 = state_67853;
if(cljs.core.truth_(inst_67823)){
var statearr_67855_67882 = state_67853__$1;
(statearr_67855_67882[(1)] = (9));

} else {
var statearr_67856_67883 = state_67853__$1;
(statearr_67856_67883[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67854 === (1))){
var state_67853__$1 = state_67853;
var statearr_67857_67884 = state_67853__$1;
(statearr_67857_67884[(2)] = null);

(statearr_67857_67884[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67854 === (4))){
var inst_67807 = (state_67853[(2)]);
var state_67853__$1 = state_67853;
var statearr_67858_67885 = state_67853__$1;
(statearr_67858_67885[(2)] = inst_67807);

(statearr_67858_67885[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67854 === (15))){
var inst_67834 = (state_67853[(2)]);
var state_67853__$1 = state_67853;
var statearr_67859_67886 = state_67853__$1;
(statearr_67859_67886[(2)] = inst_67834);

(statearr_67859_67886[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67854 === (13))){
var inst_67831 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_67853__$1 = state_67853;
var statearr_67860_67887 = state_67853__$1;
(statearr_67860_67887[(2)] = inst_67831);

(statearr_67860_67887[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67854 === (6))){
var inst_67818 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67819 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_67820 = [inst_67819,(0)];
var inst_67821 = (new cljs.core.PersistentVector(null,2,(5),inst_67818,inst_67820,null));
var state_67853__$1 = state_67853;
var statearr_67861_67888 = state_67853__$1;
(statearr_67861_67888[(2)] = inst_67821);

(statearr_67861_67888[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67854 === (3))){
var inst_67851 = (state_67853[(2)]);
var state_67853__$1 = state_67853;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67853__$1,inst_67851);
} else {
if((state_val_67854 === (12))){
var inst_67827 = (state_67853[(2)]);
var inst_67828 = fluree.db.util.async.throw_err.call(null,inst_67827);
var state_67853__$1 = state_67853;
var statearr_67862_67889 = state_67853__$1;
(statearr_67862_67889[(2)] = inst_67828);

(statearr_67862_67889[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67854 === (2))){
var _ = (function (){var statearr_67863 = state_67853;
(statearr_67863[(4)] = cljs.core.cons.call(null,(5),(state_67853[(4)])));

return statearr_67863;
})();
var inst_67816 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_67853__$1 = state_67853;
if(cljs.core.truth_(inst_67816)){
var statearr_67864_67890 = state_67853__$1;
(statearr_67864_67890[(1)] = (6));

} else {
var statearr_67865_67891 = state_67853__$1;
(statearr_67865_67891[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67854 === (11))){
var inst_67836 = (state_67853[(2)]);
var state_67853__$1 = state_67853;
var statearr_67867_67892 = state_67853__$1;
(statearr_67867_67892[(2)] = inst_67836);

(statearr_67867_67892[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67854 === (9))){
var inst_67825 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth.call(null,_QMARK_ctx);
var state_67853__$1 = state_67853;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67853__$1,(12),inst_67825);
} else {
if((state_val_67854 === (5))){
var _ = (function (){var statearr_67868 = state_67853;
(statearr_67868[(4)] = cljs.core.rest.call(null,(state_67853[(4)])));

return statearr_67868;
})();
var state_67853__$1 = state_67853;
var ex67866 = (state_67853__$1[(2)]);
var statearr_67869_67893 = state_67853__$1;
(statearr_67869_67893[(5)] = ex67866);


if((ex67866 instanceof Error)){
var statearr_67870_67894 = state_67853__$1;
(statearr_67870_67894[(1)] = (4));

(statearr_67870_67894[(5)] = null);

} else {
throw ex67866;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67854 === (14))){
var state_67853__$1 = state_67853;
var statearr_67871_67895 = state_67853__$1;
(statearr_67871_67895[(2)] = null);

(statearr_67871_67895[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67854 === (10))){
var state_67853__$1 = state_67853;
var statearr_67872_67896 = state_67853__$1;
(statearr_67872_67896[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67854 === (8))){
var inst_67838 = (state_67853[(2)]);
var inst_67839 = cljs.core.nth.call(null,inst_67838,(0),null);
var inst_67840 = cljs.core.nth.call(null,inst_67838,(1),null);
var inst_67841 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67842 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67843 = ["?user_id","?ctx",inst_67839];
var inst_67844 = cljs.core.PersistentHashMap.fromArrays(inst_67842,inst_67843);
var inst_67845 = ((10) + inst_67840);
var inst_67846 = [inst_67844,inst_67845];
var inst_67847 = (new cljs.core.PersistentVector(null,2,(5),inst_67841,inst_67846,null));
var inst_67848 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67847);
var _ = (function (){var statearr_67874 = state_67853;
(statearr_67874[(4)] = cljs.core.rest.call(null,(state_67853[(4)])));

return statearr_67874;
})();
var state_67853__$1 = (function (){var statearr_67875 = state_67853;
(statearr_67875[(7)] = inst_67848);

return statearr_67875;
})();
var statearr_67876_67897 = state_67853__$1;
(statearr_67876_67897[(2)] = inst_67839);

(statearr_67876_67897[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11469__auto____0 = (function (){
var statearr_67877 = [null,null,null,null,null,null,null,null];
(statearr_67877[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11469__auto__);

(statearr_67877[(1)] = (1));

return statearr_67877;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11469__auto____1 = (function (state_67853){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_67853);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e67878){var ex__11472__auto__ = e67878;
var statearr_67879_67898 = state_67853;
(statearr_67879_67898[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_67853[(4)]))){
var statearr_67880_67899 = state_67853;
(statearr_67880_67899[(1)] = cljs.core.first.call(null,(state_67853[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67900 = state_67853;
state_67853 = G__67900;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11469__auto__ = function(state_67853){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11469__auto____1.call(this,state_67853);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_67881 = f__11543__auto__.call(null);
(statearr_67881[(6)] = c__11542__auto__);

return statearr_67881;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_67928){
var state_val_67929 = (state_67928[(1)]);
if((state_val_67929 === (7))){
var inst_67921 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_67928__$1 = state_67928;
var statearr_67930_67949 = state_67928__$1;
(statearr_67930_67949[(2)] = inst_67921);

(statearr_67930_67949[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67929 === (1))){
var state_67928__$1 = state_67928;
var statearr_67931_67950 = state_67928__$1;
(statearr_67931_67950[(2)] = null);

(statearr_67931_67950[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67929 === (4))){
var inst_67901 = (state_67928[(2)]);
var state_67928__$1 = state_67928;
var statearr_67932_67951 = state_67928__$1;
(statearr_67932_67951[(2)] = inst_67901);

(statearr_67932_67951[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67929 === (6))){
var inst_67909 = fluree.db.dbfunctions.internal._QMARK_auth_id.call(null,_QMARK_ctx);
var state_67928__$1 = state_67928;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67928__$1,(9),inst_67909);
} else {
if((state_val_67929 === (3))){
var inst_67926 = (state_67928[(2)]);
var state_67928__$1 = state_67928;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67928__$1,inst_67926);
} else {
if((state_val_67929 === (2))){
var _ = (function (){var statearr_67934 = state_67928;
(statearr_67934[(4)] = cljs.core.cons.call(null,(5),(state_67928[(4)])));

return statearr_67934;
})();
var inst_67907 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_67928__$1 = state_67928;
if(cljs.core.truth_(inst_67907)){
var statearr_67935_67952 = state_67928__$1;
(statearr_67935_67952[(1)] = (6));

} else {
var statearr_67936_67953 = state_67928__$1;
(statearr_67936_67953[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67929 === (9))){
var inst_67911 = (state_67928[(2)]);
var inst_67912 = fluree.db.util.async.throw_err.call(null,inst_67911);
var inst_67913 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67914 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67915 = ["?auth_id","?ctx",inst_67912];
var inst_67916 = cljs.core.PersistentHashMap.fromArrays(inst_67914,inst_67915);
var inst_67917 = [inst_67916,(10)];
var inst_67918 = (new cljs.core.PersistentVector(null,2,(5),inst_67913,inst_67917,null));
var inst_67919 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67918);
var state_67928__$1 = (function (){var statearr_67937 = state_67928;
(statearr_67937[(7)] = inst_67919);

return statearr_67937;
})();
var statearr_67938_67954 = state_67928__$1;
(statearr_67938_67954[(2)] = inst_67912);

(statearr_67938_67954[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67929 === (5))){
var _ = (function (){var statearr_67939 = state_67928;
(statearr_67939[(4)] = cljs.core.rest.call(null,(state_67928[(4)])));

return statearr_67939;
})();
var state_67928__$1 = state_67928;
var ex67933 = (state_67928__$1[(2)]);
var statearr_67940_67955 = state_67928__$1;
(statearr_67940_67955[(5)] = ex67933);


if((ex67933 instanceof Error)){
var statearr_67941_67956 = state_67928__$1;
(statearr_67941_67956[(1)] = (4));

(statearr_67941_67956[(5)] = null);

} else {
throw ex67933;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67929 === (8))){
var inst_67923 = (state_67928[(2)]);
var _ = (function (){var statearr_67942 = state_67928;
(statearr_67942[(4)] = cljs.core.rest.call(null,(state_67928[(4)])));

return statearr_67942;
})();
var state_67928__$1 = state_67928;
var statearr_67943_67957 = state_67928__$1;
(statearr_67943_67957[(2)] = inst_67923);

(statearr_67943_67957[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11469__auto____0 = (function (){
var statearr_67944 = [null,null,null,null,null,null,null,null];
(statearr_67944[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11469__auto__);

(statearr_67944[(1)] = (1));

return statearr_67944;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11469__auto____1 = (function (state_67928){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_67928);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e67945){var ex__11472__auto__ = e67945;
var statearr_67946_67958 = state_67928;
(statearr_67946_67958[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_67928[(4)]))){
var statearr_67947_67959 = state_67928;
(statearr_67947_67959[(1)] = cljs.core.first.call(null,(state_67928[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67960 = state_67928;
state_67928 = G__67960;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11469__auto__ = function(state_67928){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11469__auto____1.call(this,state_67928);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_67948 = f__11543__auto__.call(null);
(statearr_67948[(6)] = c__11542__auto__);

return statearr_67948;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__67962 = arguments.length;
switch (G__67962) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.call(null,_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx).toEpochMilli());
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_68004){
var state_val_68005 = (state_68004[(1)]);
if((state_val_68005 === (7))){
var state_68004__$1 = state_68004;
var statearr_68006_68036 = state_68004__$1;
(statearr_68006_68036[(2)] = seed);

(statearr_68006_68036[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68005 === (1))){
var state_68004__$1 = state_68004;
var statearr_68007_68037 = state_68004__$1;
(statearr_68007_68037[(2)] = null);

(statearr_68007_68037[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68005 === (4))){
var inst_67963 = (state_68004[(2)]);
var state_68004__$1 = state_68004;
var statearr_68008_68038 = state_68004__$1;
(statearr_68008_68038[(2)] = inst_67963);

(statearr_68008_68038[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68005 === (15))){
var state_68004__$1 = state_68004;
var statearr_68009_68039 = state_68004__$1;
(statearr_68009_68039[(2)] = (10));

(statearr_68009_68039[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68005 === (13))){
var inst_67980 = (state_68004[(2)]);
var inst_67981 = fluree.db.util.async.throw_err.call(null,inst_67980);
var state_68004__$1 = state_68004;
var statearr_68010_68040 = state_68004__$1;
(statearr_68010_68040[(2)] = inst_67981);

(statearr_68010_68040[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68005 === (6))){
var state_68004__$1 = state_68004;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68004__$1,(9),seed);
} else {
if((state_val_68005 === (3))){
var inst_68002 = (state_68004[(2)]);
var state_68004__$1 = state_68004;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68004__$1,inst_68002);
} else {
if((state_val_68005 === (12))){
var inst_67984 = (state_68004[(7)]);
var inst_67984__$1 = (state_68004[(2)]);
var state_68004__$1 = (function (){var statearr_68011 = state_68004;
(statearr_68011[(7)] = inst_67984__$1);

return statearr_68011;
})();
if(cljs.core.truth_(inst_67984__$1)){
var statearr_68012_68041 = state_68004__$1;
(statearr_68012_68041[(1)] = (14));

} else {
var statearr_68013_68042 = state_68004__$1;
(statearr_68013_68042[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68005 === (2))){
var _ = (function (){var statearr_68014 = state_68004;
(statearr_68014[(4)] = cljs.core.cons.call(null,(5),(state_68004[(4)])));

return statearr_68014;
})();
var inst_67969 = fluree.db.util.async.channel_QMARK_.call(null,seed);
var state_68004__$1 = state_68004;
if(inst_67969){
var statearr_68015_68043 = state_68004__$1;
(statearr_68015_68043[(1)] = (6));

} else {
var statearr_68016_68044 = state_68004__$1;
(statearr_68016_68044[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68005 === (11))){
var state_68004__$1 = state_68004;
var statearr_68018_68045 = state_68004__$1;
(statearr_68018_68045[(2)] = max);

(statearr_68018_68045[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68005 === (9))){
var inst_67972 = (state_68004[(2)]);
var inst_67973 = fluree.db.util.async.throw_err.call(null,inst_67972);
var state_68004__$1 = state_68004;
var statearr_68019_68046 = state_68004__$1;
(statearr_68019_68046[(2)] = inst_67973);

(statearr_68019_68046[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68005 === (5))){
var _ = (function (){var statearr_68020 = state_68004;
(statearr_68020[(4)] = cljs.core.rest.call(null,(state_68004[(4)])));

return statearr_68020;
})();
var state_68004__$1 = state_68004;
var ex68017 = (state_68004__$1[(2)]);
var statearr_68021_68047 = state_68004__$1;
(statearr_68021_68047[(5)] = ex68017);


if((ex68017 instanceof Error)){
var statearr_68022_68048 = state_68004__$1;
(statearr_68022_68048[(1)] = (4));

(statearr_68022_68048[(5)] = null);

} else {
throw ex68017;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68005 === (14))){
var inst_67984 = (state_68004[(7)]);
var state_68004__$1 = state_68004;
var statearr_68023_68049 = state_68004__$1;
(statearr_68023_68049[(2)] = inst_67984);

(statearr_68023_68049[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68005 === (16))){
var inst_67976 = (state_68004[(8)]);
var inst_67988 = (state_68004[(2)]);
var inst_67989 = fluree.db.dbfunctions.internal.rand.call(null,inst_67976,inst_67988);
var inst_67990 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67991 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67992 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67993 = [max,seed];
var inst_67994 = (new cljs.core.PersistentVector(null,2,(5),inst_67992,inst_67993,null));
var inst_67995 = ["rand",inst_67994,inst_67989];
var inst_67996 = cljs.core.PersistentHashMap.fromArrays(inst_67991,inst_67995);
var inst_67997 = [inst_67996,(10)];
var inst_67998 = (new cljs.core.PersistentVector(null,2,(5),inst_67990,inst_67997,null));
var inst_67999 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_67998);
var _ = (function (){var statearr_68024 = state_68004;
(statearr_68024[(4)] = cljs.core.rest.call(null,(state_68004[(4)])));

return statearr_68024;
})();
var state_68004__$1 = (function (){var statearr_68025 = state_68004;
(statearr_68025[(9)] = inst_67999);

return statearr_68025;
})();
var statearr_68026_68050 = state_68004__$1;
(statearr_68026_68050[(2)] = inst_67989);

(statearr_68026_68050[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68005 === (10))){
var state_68004__$1 = state_68004;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68004__$1,(13),max);
} else {
if((state_val_68005 === (8))){
var inst_67976 = (state_68004[(2)]);
var inst_67977 = fluree.db.util.async.channel_QMARK_.call(null,max);
var state_68004__$1 = (function (){var statearr_68027 = state_68004;
(statearr_68027[(8)] = inst_67976);

return statearr_68027;
})();
if(inst_67977){
var statearr_68028_68051 = state_68004__$1;
(statearr_68028_68051[(1)] = (10));

} else {
var statearr_68029_68052 = state_68004__$1;
(statearr_68029_68052[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11469__auto____0 = (function (){
var statearr_68030 = [null,null,null,null,null,null,null,null,null,null];
(statearr_68030[(0)] = fluree$db$dbfunctions$fns$state_machine__11469__auto__);

(statearr_68030[(1)] = (1));

return statearr_68030;
});
var fluree$db$dbfunctions$fns$state_machine__11469__auto____1 = (function (state_68004){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_68004);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e68031){var ex__11472__auto__ = e68031;
var statearr_68032_68053 = state_68004;
(statearr_68032_68053[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_68004[(4)]))){
var statearr_68033_68054 = state_68004;
(statearr_68033_68054[(1)] = cljs.core.first.call(null,(state_68004[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68055 = state_68004;
state_68004 = G__68055;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11469__auto__ = function(state_68004){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11469__auto____1.call(this,state_68004);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_68034 = f__11543__auto__.call(null);
(statearr_68034[(6)] = c__11542__auto__);

return statearr_68034;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_68076){
var state_val_68077 = (state_68076[(1)]);
if((state_val_68077 === (1))){
var state_68076__$1 = state_68076;
var statearr_68078_68093 = state_68076__$1;
(statearr_68078_68093[(2)] = null);

(statearr_68078_68093[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68077 === (2))){
var _ = (function (){var statearr_68079 = state_68076;
(statearr_68079[(4)] = cljs.core.cons.call(null,(5),(state_68076[(4)])));

return statearr_68079;
})();
var inst_68062 = fluree.db.util.core.random_uuid.call(null);
var inst_68063 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68062);
var inst_68064 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68065 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68066 = cljs.core.PersistentVector.EMPTY;
var inst_68067 = ["uuid",inst_68066,inst_68063];
var inst_68068 = cljs.core.PersistentHashMap.fromArrays(inst_68065,inst_68067);
var inst_68069 = [inst_68068,(10)];
var inst_68070 = (new cljs.core.PersistentVector(null,2,(5),inst_68064,inst_68069,null));
var inst_68071 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_68070);
var ___$1 = (function (){var statearr_68080 = state_68076;
(statearr_68080[(4)] = cljs.core.rest.call(null,(state_68076[(4)])));

return statearr_68080;
})();
var state_68076__$1 = (function (){var statearr_68081 = state_68076;
(statearr_68081[(7)] = inst_68071);

return statearr_68081;
})();
var statearr_68082_68094 = state_68076__$1;
(statearr_68082_68094[(2)] = inst_68063);

(statearr_68082_68094[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68077 === (3))){
var inst_68074 = (state_68076[(2)]);
var state_68076__$1 = state_68076;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68076__$1,inst_68074);
} else {
if((state_val_68077 === (4))){
var inst_68056 = (state_68076[(2)]);
var state_68076__$1 = state_68076;
var statearr_68084_68095 = state_68076__$1;
(statearr_68084_68095[(2)] = inst_68056);

(statearr_68084_68095[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68077 === (5))){
var _ = (function (){var statearr_68085 = state_68076;
(statearr_68085[(4)] = cljs.core.rest.call(null,(state_68076[(4)])));

return statearr_68085;
})();
var state_68076__$1 = state_68076;
var ex68083 = (state_68076__$1[(2)]);
var statearr_68086_68096 = state_68076__$1;
(statearr_68086_68096[(5)] = ex68083);


if((ex68083 instanceof Error)){
var statearr_68087_68097 = state_68076__$1;
(statearr_68087_68097[(1)] = (4));

(statearr_68087_68097[(5)] = null);

} else {
throw ex68083;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__11469__auto____0 = (function (){
var statearr_68088 = [null,null,null,null,null,null,null,null];
(statearr_68088[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__11469__auto__);

(statearr_68088[(1)] = (1));

return statearr_68088;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__11469__auto____1 = (function (state_68076){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_68076);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e68089){var ex__11472__auto__ = e68089;
var statearr_68090_68098 = state_68076;
(statearr_68090_68098[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_68076[(4)]))){
var statearr_68091_68099 = state_68076;
(statearr_68091_68099[(1)] = cljs.core.first.call(null,(state_68076[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68100 = state_68076;
state_68076 = G__68100;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__11469__auto__ = function(state_68076){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__11469__auto____1.call(this,state_68076);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_68092 = f__11543__auto__.call(null);
(statearr_68092[(6)] = c__11542__auto__);

return statearr_68092;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_68130){
var state_val_68131 = (state_68130[(1)]);
if((state_val_68131 === (7))){
var state_68130__$1 = state_68130;
var statearr_68132_68151 = state_68130__$1;
(statearr_68132_68151[(2)] = num);

(statearr_68132_68151[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (1))){
var state_68130__$1 = state_68130;
var statearr_68133_68152 = state_68130__$1;
(statearr_68133_68152[(2)] = null);

(statearr_68133_68152[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (4))){
var inst_68101 = (state_68130[(2)]);
var state_68130__$1 = state_68130;
var statearr_68134_68153 = state_68130__$1;
(statearr_68134_68153[(2)] = inst_68101);

(statearr_68134_68153[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (6))){
var state_68130__$1 = state_68130;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68130__$1,(9),num);
} else {
if((state_val_68131 === (3))){
var inst_68128 = (state_68130[(2)]);
var state_68130__$1 = state_68130;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68130__$1,inst_68128);
} else {
if((state_val_68131 === (2))){
var _ = (function (){var statearr_68136 = state_68130;
(statearr_68136[(4)] = cljs.core.cons.call(null,(5),(state_68130[(4)])));

return statearr_68136;
})();
var inst_68107 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_68130__$1 = state_68130;
if(inst_68107){
var statearr_68137_68154 = state_68130__$1;
(statearr_68137_68154[(1)] = (6));

} else {
var statearr_68138_68155 = state_68130__$1;
(statearr_68138_68155[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (9))){
var inst_68110 = (state_68130[(2)]);
var inst_68111 = fluree.db.util.async.throw_err.call(null,inst_68110);
var state_68130__$1 = state_68130;
var statearr_68139_68156 = state_68130__$1;
(statearr_68139_68156[(2)] = inst_68111);

(statearr_68139_68156[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (5))){
var _ = (function (){var statearr_68140 = state_68130;
(statearr_68140[(4)] = cljs.core.rest.call(null,(state_68130[(4)])));

return statearr_68140;
})();
var state_68130__$1 = state_68130;
var ex68135 = (state_68130__$1[(2)]);
var statearr_68141_68157 = state_68130__$1;
(statearr_68141_68157[(5)] = ex68135);


if((ex68135 instanceof Error)){
var statearr_68142_68158 = state_68130__$1;
(statearr_68142_68158[(1)] = (4));

(statearr_68142_68158[(5)] = null);

} else {
throw ex68135;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (8))){
var inst_68114 = (state_68130[(2)]);
var inst_68115 = fluree.db.dbfunctions.internal.ceil.call(null,inst_68114);
var inst_68116 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68117 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68118 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68119 = [fluree.db.dbfunctions.fns.ceil];
var inst_68120 = (new cljs.core.PersistentVector(null,1,(5),inst_68118,inst_68119,null));
var inst_68121 = ["",inst_68120,inst_68115];
var inst_68122 = cljs.core.PersistentHashMap.fromArrays(inst_68117,inst_68121);
var inst_68123 = [inst_68122,(10)];
var inst_68124 = (new cljs.core.PersistentVector(null,2,(5),inst_68116,inst_68123,null));
var inst_68125 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_68124);
var _ = (function (){var statearr_68143 = state_68130;
(statearr_68143[(4)] = cljs.core.rest.call(null,(state_68130[(4)])));

return statearr_68143;
})();
var state_68130__$1 = (function (){var statearr_68144 = state_68130;
(statearr_68144[(7)] = inst_68125);

return statearr_68144;
})();
var statearr_68145_68159 = state_68130__$1;
(statearr_68145_68159[(2)] = inst_68115);

(statearr_68145_68159[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__11469__auto____0 = (function (){
var statearr_68146 = [null,null,null,null,null,null,null,null];
(statearr_68146[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__11469__auto__);

(statearr_68146[(1)] = (1));

return statearr_68146;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__11469__auto____1 = (function (state_68130){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_68130);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e68147){var ex__11472__auto__ = e68147;
var statearr_68148_68160 = state_68130;
(statearr_68148_68160[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_68130[(4)]))){
var statearr_68149_68161 = state_68130;
(statearr_68149_68161[(1)] = cljs.core.first.call(null,(state_68130[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68162 = state_68130;
state_68130 = G__68162;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__11469__auto__ = function(state_68130){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__11469__auto____1.call(this,state_68130);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_68150 = f__11543__auto__.call(null);
(statearr_68150[(6)] = c__11542__auto__);

return statearr_68150;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_68192){
var state_val_68193 = (state_68192[(1)]);
if((state_val_68193 === (7))){
var state_68192__$1 = state_68192;
var statearr_68194_68213 = state_68192__$1;
(statearr_68194_68213[(2)] = num);

(statearr_68194_68213[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68193 === (1))){
var state_68192__$1 = state_68192;
var statearr_68195_68214 = state_68192__$1;
(statearr_68195_68214[(2)] = null);

(statearr_68195_68214[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68193 === (4))){
var inst_68163 = (state_68192[(2)]);
var state_68192__$1 = state_68192;
var statearr_68196_68215 = state_68192__$1;
(statearr_68196_68215[(2)] = inst_68163);

(statearr_68196_68215[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68193 === (6))){
var state_68192__$1 = state_68192;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68192__$1,(9),num);
} else {
if((state_val_68193 === (3))){
var inst_68190 = (state_68192[(2)]);
var state_68192__$1 = state_68192;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68192__$1,inst_68190);
} else {
if((state_val_68193 === (2))){
var _ = (function (){var statearr_68198 = state_68192;
(statearr_68198[(4)] = cljs.core.cons.call(null,(5),(state_68192[(4)])));

return statearr_68198;
})();
var inst_68169 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_68192__$1 = state_68192;
if(inst_68169){
var statearr_68199_68216 = state_68192__$1;
(statearr_68199_68216[(1)] = (6));

} else {
var statearr_68200_68217 = state_68192__$1;
(statearr_68200_68217[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68193 === (9))){
var inst_68172 = (state_68192[(2)]);
var inst_68173 = fluree.db.util.async.throw_err.call(null,inst_68172);
var state_68192__$1 = state_68192;
var statearr_68201_68218 = state_68192__$1;
(statearr_68201_68218[(2)] = inst_68173);

(statearr_68201_68218[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68193 === (5))){
var _ = (function (){var statearr_68202 = state_68192;
(statearr_68202[(4)] = cljs.core.rest.call(null,(state_68192[(4)])));

return statearr_68202;
})();
var state_68192__$1 = state_68192;
var ex68197 = (state_68192__$1[(2)]);
var statearr_68203_68219 = state_68192__$1;
(statearr_68203_68219[(5)] = ex68197);


if((ex68197 instanceof Error)){
var statearr_68204_68220 = state_68192__$1;
(statearr_68204_68220[(1)] = (4));

(statearr_68204_68220[(5)] = null);

} else {
throw ex68197;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68193 === (8))){
var inst_68176 = (state_68192[(2)]);
var inst_68177 = fluree.db.dbfunctions.internal.floor.call(null,inst_68176);
var inst_68178 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68179 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68180 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68181 = [fluree.db.dbfunctions.fns.floor];
var inst_68182 = (new cljs.core.PersistentVector(null,1,(5),inst_68180,inst_68181,null));
var inst_68183 = ["",inst_68182,inst_68177];
var inst_68184 = cljs.core.PersistentHashMap.fromArrays(inst_68179,inst_68183);
var inst_68185 = [inst_68184,(10)];
var inst_68186 = (new cljs.core.PersistentVector(null,2,(5),inst_68178,inst_68185,null));
var inst_68187 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_68186);
var _ = (function (){var statearr_68205 = state_68192;
(statearr_68205[(4)] = cljs.core.rest.call(null,(state_68192[(4)])));

return statearr_68205;
})();
var state_68192__$1 = (function (){var statearr_68206 = state_68192;
(statearr_68206[(7)] = inst_68187);

return statearr_68206;
})();
var statearr_68207_68221 = state_68192__$1;
(statearr_68207_68221[(2)] = inst_68177);

(statearr_68207_68221[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__11469__auto____0 = (function (){
var statearr_68208 = [null,null,null,null,null,null,null,null];
(statearr_68208[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__11469__auto__);

(statearr_68208[(1)] = (1));

return statearr_68208;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__11469__auto____1 = (function (state_68192){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_68192);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e68209){var ex__11472__auto__ = e68209;
var statearr_68210_68222 = state_68192;
(statearr_68210_68222[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_68192[(4)]))){
var statearr_68211_68223 = state_68192;
(statearr_68211_68223[(1)] = cljs.core.first.call(null,(state_68192[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68224 = state_68192;
state_68192 = G__68224;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__11469__auto__ = function(state_68192){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__11469__auto____1.call(this,state_68192);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_68212 = f__11543__auto__.call(null);
(statearr_68212[(6)] = c__11542__auto__);

return statearr_68212;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_68249){
var state_val_68250 = (state_68249[(1)]);
if((state_val_68250 === (1))){
var state_68249__$1 = state_68249;
var statearr_68251_68266 = state_68249__$1;
(statearr_68251_68266[(2)] = null);

(statearr_68251_68266[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68250 === (2))){
var _ = (function (){var statearr_68252 = state_68249;
(statearr_68252[(4)] = cljs.core.cons.call(null,(5),(state_68249[(4)])));

return statearr_68252;
})();
var inst_68231 = fluree.db.dbfunctions.internal.cas.call(null,_QMARK_ctx,compare_val,new_val);
var state_68249__$1 = state_68249;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68249__$1,(6),inst_68231);
} else {
if((state_val_68250 === (3))){
var inst_68247 = (state_68249[(2)]);
var state_68249__$1 = state_68249;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68249__$1,inst_68247);
} else {
if((state_val_68250 === (4))){
var inst_68225 = (state_68249[(2)]);
var state_68249__$1 = state_68249;
var statearr_68254_68267 = state_68249__$1;
(statearr_68254_68267[(2)] = inst_68225);

(statearr_68254_68267[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68250 === (5))){
var _ = (function (){var statearr_68255 = state_68249;
(statearr_68255[(4)] = cljs.core.rest.call(null,(state_68249[(4)])));

return statearr_68255;
})();
var state_68249__$1 = state_68249;
var ex68253 = (state_68249__$1[(2)]);
var statearr_68256_68268 = state_68249__$1;
(statearr_68256_68268[(5)] = ex68253);


if((ex68253 instanceof Error)){
var statearr_68257_68269 = state_68249__$1;
(statearr_68257_68269[(1)] = (4));

(statearr_68257_68269[(5)] = null);

} else {
throw ex68253;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68250 === (6))){
var inst_68233 = (state_68249[(2)]);
var inst_68234 = fluree.db.util.async.throw_err.call(null,inst_68233);
var inst_68235 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68236 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_68237 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68238 = [compare_val,new_val];
var inst_68239 = (new cljs.core.PersistentVector(null,2,(5),inst_68237,inst_68238,null));
var inst_68240 = ["",inst_68239,inst_68234];
var inst_68241 = cljs.core.PersistentHashMap.fromArrays(inst_68236,inst_68240);
var inst_68242 = [inst_68241,(10)];
var inst_68243 = (new cljs.core.PersistentVector(null,2,(5),inst_68235,inst_68242,null));
var inst_68244 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_68243);
var _ = (function (){var statearr_68258 = state_68249;
(statearr_68258[(4)] = cljs.core.rest.call(null,(state_68249[(4)])));

return statearr_68258;
})();
var state_68249__$1 = (function (){var statearr_68259 = state_68249;
(statearr_68259[(7)] = inst_68244);

return statearr_68259;
})();
var statearr_68260_68270 = state_68249__$1;
(statearr_68260_68270[(2)] = inst_68234);

(statearr_68260_68270[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__11469__auto____0 = (function (){
var statearr_68261 = [null,null,null,null,null,null,null,null];
(statearr_68261[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__11469__auto__);

(statearr_68261[(1)] = (1));

return statearr_68261;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__11469__auto____1 = (function (state_68249){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_68249);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e68262){var ex__11472__auto__ = e68262;
var statearr_68263_68271 = state_68249;
(statearr_68263_68271[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_68249[(4)]))){
var statearr_68264_68272 = state_68249;
(statearr_68264_68272[(1)] = cljs.core.first.call(null,(state_68249[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68273 = state_68249;
state_68249 = G__68273;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__11469__auto__ = function(state_68249){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__11469__auto____1.call(this,state_68249);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__11469__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_68265 = f__11543__auto__.call(null);
(statearr_68265[(6)] = c__11542__auto__);

return statearr_68265;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
