// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_exists_fn.cljs$core$IFn$_invoke$arity$1 ? storage_exists_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_exists_fn.call(null,key));
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_read_fn.cljs$core$IFn$_invoke$arity$1 ? storage_read_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_read_fn.call(null,key));
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_write_fn.cljs$core$IFn$_invoke$arity$2 ? storage_write_fn.cljs$core$IFn$_invoke$arity$2(key,val) : storage_write_fn.call(null,key,val));
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name(idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad(block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_17252){
var state_val_17253 = (state_17252[(1)]);
if((state_val_17253 === (7))){
var inst_17241 = (state_17252[(7)]);
var inst_17243 = fluree.db.storage.core.serde(conn);
var inst_17244 = fluree.db.serde.protocol._deserialize_block(inst_17243,inst_17241);
var state_17252__$1 = state_17252;
var statearr_17254_17273 = state_17252__$1;
(statearr_17254_17273[(2)] = inst_17244);

(statearr_17254_17273[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17253 === (1))){
var state_17252__$1 = state_17252;
var statearr_17255_17274 = state_17252__$1;
(statearr_17255_17274[(2)] = null);

(statearr_17255_17274[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17253 === (4))){
var inst_17231 = (state_17252[(2)]);
var state_17252__$1 = state_17252;
var statearr_17256_17275 = state_17252__$1;
(statearr_17256_17275[(2)] = inst_17231);

(statearr_17256_17275[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17253 === (6))){
var inst_17241 = (state_17252[(7)]);
var inst_17240 = (state_17252[(2)]);
var inst_17241__$1 = fluree.db.util.async.throw_err(inst_17240);
var state_17252__$1 = (function (){var statearr_17257 = state_17252;
(statearr_17257[(7)] = inst_17241__$1);

return statearr_17257;
})();
if(cljs.core.truth_(inst_17241__$1)){
var statearr_17258_17276 = state_17252__$1;
(statearr_17258_17276[(1)] = (7));

} else {
var statearr_17259_17277 = state_17252__$1;
(statearr_17259_17277[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17253 === (3))){
var inst_17250 = (state_17252[(2)]);
var state_17252__$1 = state_17252;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17252__$1,inst_17250);
} else {
if((state_val_17253 === (2))){
var _ = (function (){var statearr_17261 = state_17252;
(statearr_17261[(4)] = cljs.core.cons((5),(state_17252[(4)])));

return statearr_17261;
})();
var inst_17237 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_17238 = fluree.db.storage.core.storage_read(conn,inst_17237);
var state_17252__$1 = state_17252;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17252__$1,(6),inst_17238);
} else {
if((state_val_17253 === (9))){
var inst_17247 = (state_17252[(2)]);
var _ = (function (){var statearr_17262 = state_17252;
(statearr_17262[(4)] = cljs.core.rest((state_17252[(4)])));

return statearr_17262;
})();
var state_17252__$1 = state_17252;
var statearr_17263_17278 = state_17252__$1;
(statearr_17263_17278[(2)] = inst_17247);

(statearr_17263_17278[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17253 === (5))){
var _ = (function (){var statearr_17264 = state_17252;
(statearr_17264[(4)] = cljs.core.rest((state_17252[(4)])));

return statearr_17264;
})();
var state_17252__$1 = state_17252;
var ex17260 = (state_17252__$1[(2)]);
var statearr_17265_17279 = state_17252__$1;
(statearr_17265_17279[(5)] = ex17260);


if((ex17260 instanceof Error)){
var statearr_17266_17280 = state_17252__$1;
(statearr_17266_17280[(1)] = (4));

(statearr_17266_17280[(5)] = null);

} else {
throw ex17260;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17253 === (8))){
var state_17252__$1 = state_17252;
var statearr_17267_17281 = state_17252__$1;
(statearr_17267_17281[(2)] = null);

(statearr_17267_17281[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__2741__auto____0 = (function (){
var statearr_17268 = [null,null,null,null,null,null,null,null];
(statearr_17268[(0)] = fluree$db$storage$core$read_block_$_state_machine__2741__auto__);

(statearr_17268[(1)] = (1));

return statearr_17268;
});
var fluree$db$storage$core$read_block_$_state_machine__2741__auto____1 = (function (state_17252){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_17252);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e17269){var ex__2744__auto__ = e17269;
var statearr_17270_17282 = state_17252;
(statearr_17270_17282[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_17252[(4)]))){
var statearr_17271_17283 = state_17252;
(statearr_17271_17283[(1)] = cljs.core.first((state_17252[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17284 = state_17252;
state_17252 = G__17284;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__2741__auto__ = function(state_17252){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__2741__auto____1.call(this,state_17252);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__2741__auto____0;
fluree$db$storage$core$read_block_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__2741__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_17272 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_17272[(6)] = c__2763__auto__);

return statearr_17272;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_17307){
var state_val_17308 = (state_17307[(1)]);
if((state_val_17308 === (7))){
var inst_17296 = (state_17307[(7)]);
var inst_17298 = fluree.db.storage.core.serde(conn);
var inst_17299 = fluree.db.serde.protocol._deserialize_block(inst_17298,inst_17296);
var state_17307__$1 = state_17307;
var statearr_17309_17328 = state_17307__$1;
(statearr_17309_17328[(2)] = inst_17299);

(statearr_17309_17328[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17308 === (1))){
var state_17307__$1 = state_17307;
var statearr_17310_17329 = state_17307__$1;
(statearr_17310_17329[(2)] = null);

(statearr_17310_17329[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17308 === (4))){
var inst_17285 = (state_17307[(2)]);
var state_17307__$1 = state_17307;
var statearr_17311_17330 = state_17307__$1;
(statearr_17311_17330[(2)] = inst_17285);

(statearr_17311_17330[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17308 === (6))){
var inst_17296 = (state_17307[(7)]);
var inst_17295 = (state_17307[(2)]);
var inst_17296__$1 = fluree.db.util.async.throw_err(inst_17295);
var state_17307__$1 = (function (){var statearr_17312 = state_17307;
(statearr_17312[(7)] = inst_17296__$1);

return statearr_17312;
})();
if(cljs.core.truth_(inst_17296__$1)){
var statearr_17313_17331 = state_17307__$1;
(statearr_17313_17331[(1)] = (7));

} else {
var statearr_17314_17332 = state_17307__$1;
(statearr_17314_17332[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17308 === (3))){
var inst_17305 = (state_17307[(2)]);
var state_17307__$1 = state_17307;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17307__$1,inst_17305);
} else {
if((state_val_17308 === (2))){
var _ = (function (){var statearr_17316 = state_17307;
(statearr_17316[(4)] = cljs.core.cons((5),(state_17307[(4)])));

return statearr_17316;
})();
var inst_17291 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_17292 = [inst_17291,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_17293 = fluree.db.storage.core.storage_read(conn,inst_17292);
var state_17307__$1 = state_17307;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17307__$1,(6),inst_17293);
} else {
if((state_val_17308 === (9))){
var inst_17302 = (state_17307[(2)]);
var _ = (function (){var statearr_17317 = state_17307;
(statearr_17317[(4)] = cljs.core.rest((state_17307[(4)])));

return statearr_17317;
})();
var state_17307__$1 = state_17307;
var statearr_17318_17333 = state_17307__$1;
(statearr_17318_17333[(2)] = inst_17302);

(statearr_17318_17333[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17308 === (5))){
var _ = (function (){var statearr_17319 = state_17307;
(statearr_17319[(4)] = cljs.core.rest((state_17307[(4)])));

return statearr_17319;
})();
var state_17307__$1 = state_17307;
var ex17315 = (state_17307__$1[(2)]);
var statearr_17320_17334 = state_17307__$1;
(statearr_17320_17334[(5)] = ex17315);


if((ex17315 instanceof Error)){
var statearr_17321_17335 = state_17307__$1;
(statearr_17321_17335[(1)] = (4));

(statearr_17321_17335[(5)] = null);

} else {
throw ex17315;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17308 === (8))){
var state_17307__$1 = state_17307;
var statearr_17322_17336 = state_17307__$1;
(statearr_17322_17336[(2)] = null);

(statearr_17322_17336[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__2741__auto____0 = (function (){
var statearr_17323 = [null,null,null,null,null,null,null,null];
(statearr_17323[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__2741__auto__);

(statearr_17323[(1)] = (1));

return statearr_17323;
});
var fluree$db$storage$core$read_block_version_$_state_machine__2741__auto____1 = (function (state_17307){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_17307);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e17324){var ex__2744__auto__ = e17324;
var statearr_17325_17337 = state_17307;
(statearr_17325_17337[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_17307[(4)]))){
var statearr_17326_17338 = state_17307;
(statearr_17326_17338[(1)] = cljs.core.first((state_17307[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17339 = state_17307;
state_17307 = G__17339;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__2741__auto__ = function(state_17307){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__2741__auto____1.call(this,state_17307);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__2741__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__2741__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_17327 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_17327[(6)] = c__2763__auto__);

return statearr_17327;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_17363){
var state_val_17364 = (state_17363[(1)]);
if((state_val_17364 === (1))){
var state_17363__$1 = state_17363;
var statearr_17365_17379 = state_17363__$1;
(statearr_17365_17379[(2)] = null);

(statearr_17365_17379[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17364 === (2))){
var _ = (function (){var statearr_17366 = state_17363;
(statearr_17366[(4)] = cljs.core.cons((5),(state_17363[(4)])));

return statearr_17366;
})();
var inst_17346 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17347 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_17348 = (new cljs.core.PersistentVector(null,3,(5),inst_17346,inst_17347,null));
var inst_17349 = cljs.core.select_keys(block_data,inst_17348);
var inst_17350 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_17349);
var inst_17351 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_17350);
var inst_17352 = [inst_17351,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_17353 = fluree.db.storage.core.serde(conn);
var inst_17354 = fluree.db.serde.protocol._serialize_block(inst_17353,inst_17349);
var inst_17355 = fluree.db.storage.core.storage_write(conn,inst_17352,inst_17354);
var state_17363__$1 = state_17363;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17363__$1,(6),inst_17355);
} else {
if((state_val_17364 === (3))){
var inst_17361 = (state_17363[(2)]);
var state_17363__$1 = state_17363;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17363__$1,inst_17361);
} else {
if((state_val_17364 === (4))){
var inst_17340 = (state_17363[(2)]);
var state_17363__$1 = state_17363;
var statearr_17368_17380 = state_17363__$1;
(statearr_17368_17380[(2)] = inst_17340);

(statearr_17368_17380[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17364 === (5))){
var _ = (function (){var statearr_17369 = state_17363;
(statearr_17369[(4)] = cljs.core.rest((state_17363[(4)])));

return statearr_17369;
})();
var state_17363__$1 = state_17363;
var ex17367 = (state_17363__$1[(2)]);
var statearr_17370_17381 = state_17363__$1;
(statearr_17370_17381[(5)] = ex17367);


if((ex17367 instanceof Error)){
var statearr_17371_17382 = state_17363__$1;
(statearr_17371_17382[(1)] = (4));

(statearr_17371_17382[(5)] = null);

} else {
throw ex17367;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17364 === (6))){
var inst_17357 = (state_17363[(2)]);
var inst_17358 = fluree.db.util.async.throw_err(inst_17357);
var _ = (function (){var statearr_17372 = state_17363;
(statearr_17372[(4)] = cljs.core.rest((state_17363[(4)])));

return statearr_17372;
})();
var state_17363__$1 = state_17363;
var statearr_17373_17383 = state_17363__$1;
(statearr_17373_17383[(2)] = inst_17358);

(statearr_17373_17383[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__2741__auto____0 = (function (){
var statearr_17374 = [null,null,null,null,null,null,null];
(statearr_17374[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__2741__auto__);

(statearr_17374[(1)] = (1));

return statearr_17374;
});
var fluree$db$storage$core$write_block_version_$_state_machine__2741__auto____1 = (function (state_17363){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_17363);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e17375){var ex__2744__auto__ = e17375;
var statearr_17376_17384 = state_17363;
(statearr_17376_17384[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_17363[(4)]))){
var statearr_17377_17385 = state_17363;
(statearr_17377_17385[(1)] = cljs.core.first((state_17363[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17386 = state_17363;
state_17363 = G__17386;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__2741__auto__ = function(state_17363){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__2741__auto____1.call(this,state_17363);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__2741__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__2741__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_17378 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_17378[(6)] = c__2763__auto__);

return statearr_17378;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_17409){
var state_val_17410 = (state_17409[(1)]);
if((state_val_17410 === (1))){
var state_17409__$1 = state_17409;
var statearr_17411_17425 = state_17409__$1;
(statearr_17411_17425[(2)] = null);

(statearr_17411_17425[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17410 === (2))){
var _ = (function (){var statearr_17412 = state_17409;
(statearr_17412[(4)] = cljs.core.cons((5),(state_17409[(4)])));

return statearr_17412;
})();
var inst_17393 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17394 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_17395 = (new cljs.core.PersistentVector(null,3,(5),inst_17393,inst_17394,null));
var inst_17396 = cljs.core.select_keys(block_data,inst_17395);
var inst_17397 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_17396);
var inst_17398 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_17397);
var inst_17399 = fluree.db.storage.core.serde(conn);
var inst_17400 = fluree.db.serde.protocol._serialize_block(inst_17399,inst_17396);
var inst_17401 = fluree.db.storage.core.storage_write(conn,inst_17398,inst_17400);
var state_17409__$1 = state_17409;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17409__$1,(6),inst_17401);
} else {
if((state_val_17410 === (3))){
var inst_17407 = (state_17409[(2)]);
var state_17409__$1 = state_17409;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17409__$1,inst_17407);
} else {
if((state_val_17410 === (4))){
var inst_17387 = (state_17409[(2)]);
var state_17409__$1 = state_17409;
var statearr_17414_17426 = state_17409__$1;
(statearr_17414_17426[(2)] = inst_17387);

(statearr_17414_17426[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17410 === (5))){
var _ = (function (){var statearr_17415 = state_17409;
(statearr_17415[(4)] = cljs.core.rest((state_17409[(4)])));

return statearr_17415;
})();
var state_17409__$1 = state_17409;
var ex17413 = (state_17409__$1[(2)]);
var statearr_17416_17427 = state_17409__$1;
(statearr_17416_17427[(5)] = ex17413);


if((ex17413 instanceof Error)){
var statearr_17417_17428 = state_17409__$1;
(statearr_17417_17428[(1)] = (4));

(statearr_17417_17428[(5)] = null);

} else {
throw ex17413;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17410 === (6))){
var inst_17403 = (state_17409[(2)]);
var inst_17404 = fluree.db.util.async.throw_err(inst_17403);
var _ = (function (){var statearr_17418 = state_17409;
(statearr_17418[(4)] = cljs.core.rest((state_17409[(4)])));

return statearr_17418;
})();
var state_17409__$1 = state_17409;
var statearr_17419_17429 = state_17409__$1;
(statearr_17419_17429[(2)] = inst_17404);

(statearr_17419_17429[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__2741__auto____0 = (function (){
var statearr_17420 = [null,null,null,null,null,null,null];
(statearr_17420[(0)] = fluree$db$storage$core$write_block_$_state_machine__2741__auto__);

(statearr_17420[(1)] = (1));

return statearr_17420;
});
var fluree$db$storage$core$write_block_$_state_machine__2741__auto____1 = (function (state_17409){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_17409);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e17421){var ex__2744__auto__ = e17421;
var statearr_17422_17430 = state_17409;
(statearr_17422_17430[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_17409[(4)]))){
var statearr_17423_17431 = state_17409;
(statearr_17423_17431[(1)] = cljs.core.first((state_17409[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17432 = state_17409;
state_17409 = G__17432;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__2741__auto__ = function(state_17409){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__2741__auto____1.call(this,state_17409);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__2741__auto____0;
fluree$db$storage$core$write_block_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__2741__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_17424 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_17424[(6)] = c__2763__auto__);

return statearr_17424;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys(child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_17452){
var state_val_17453 = (state_17452[(1)]);
if((state_val_17453 === (1))){
var state_17452__$1 = state_17452;
var statearr_17454_17468 = state_17452__$1;
(statearr_17454_17468[(2)] = null);

(statearr_17454_17468[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17453 === (2))){
var _ = (function (){var statearr_17455 = state_17452;
(statearr_17455[(4)] = cljs.core.cons((5),(state_17452[(4)])));

return statearr_17455;
})();
var inst_17439 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_17440 = [history,next_his_key];
var inst_17441 = cljs.core.PersistentHashMap.fromArrays(inst_17439,inst_17440);
var inst_17442 = fluree.db.storage.core.serde(conn);
var inst_17443 = fluree.db.serde.protocol._serialize_leaf(inst_17442,inst_17441);
var inst_17444 = fluree.db.storage.core.storage_write(conn,his_key,inst_17443);
var state_17452__$1 = state_17452;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17452__$1,(6),inst_17444);
} else {
if((state_val_17453 === (3))){
var inst_17450 = (state_17452[(2)]);
var state_17452__$1 = state_17452;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17452__$1,inst_17450);
} else {
if((state_val_17453 === (4))){
var inst_17433 = (state_17452[(2)]);
var state_17452__$1 = state_17452;
var statearr_17457_17469 = state_17452__$1;
(statearr_17457_17469[(2)] = inst_17433);

(statearr_17457_17469[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17453 === (5))){
var _ = (function (){var statearr_17458 = state_17452;
(statearr_17458[(4)] = cljs.core.rest((state_17452[(4)])));

return statearr_17458;
})();
var state_17452__$1 = state_17452;
var ex17456 = (state_17452__$1[(2)]);
var statearr_17459_17470 = state_17452__$1;
(statearr_17459_17470[(5)] = ex17456);


if((ex17456 instanceof Error)){
var statearr_17460_17471 = state_17452__$1;
(statearr_17460_17471[(1)] = (4));

(statearr_17460_17471[(5)] = null);

} else {
throw ex17456;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17453 === (6))){
var inst_17446 = (state_17452[(2)]);
var inst_17447 = fluree.db.util.async.throw_err(inst_17446);
var _ = (function (){var statearr_17461 = state_17452;
(statearr_17461[(4)] = cljs.core.rest((state_17452[(4)])));

return statearr_17461;
})();
var state_17452__$1 = state_17452;
var statearr_17462_17472 = state_17452__$1;
(statearr_17462_17472[(2)] = inst_17447);

(statearr_17462_17472[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__2741__auto____0 = (function (){
var statearr_17463 = [null,null,null,null,null,null,null];
(statearr_17463[(0)] = fluree$db$storage$core$write_history_$_state_machine__2741__auto__);

(statearr_17463[(1)] = (1));

return statearr_17463;
});
var fluree$db$storage$core$write_history_$_state_machine__2741__auto____1 = (function (state_17452){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_17452);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e17464){var ex__2744__auto__ = e17464;
var statearr_17465_17473 = state_17452;
(statearr_17465_17473[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_17452[(4)]))){
var statearr_17466_17474 = state_17452;
(statearr_17466_17474[(1)] = cljs.core.first((state_17452[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17475 = state_17452;
state_17452 = G__17475;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__2741__auto__ = function(state_17452){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__2741__auto____1.call(this,state_17452);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__2741__auto____0;
fluree$db$storage$core$write_history_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__2741__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_17467 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_17467[(6)] = c__2763__auto__);

return statearr_17467;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_17501){
var state_val_17502 = (state_17501[(1)]);
if((state_val_17502 === (1))){
var state_17501__$1 = state_17501;
var statearr_17503_17520 = state_17501__$1;
(statearr_17503_17520[(2)] = null);

(statearr_17503_17520[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17502 === (2))){
var inst_17482 = (state_17501[(7)]);
var _ = (function (){var statearr_17504 = state_17501;
(statearr_17504[(4)] = cljs.core.cons((5),(state_17501[(4)])));

return statearr_17504;
})();
var inst_17482__$1 = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"l");
var inst_17483 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_17482__$1),"-his"].join('');
var inst_17484 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_17485 = [flakes,inst_17483];
var inst_17486 = cljs.core.PersistentHashMap.fromArrays(inst_17484,inst_17485);
var inst_17487 = fluree.db.storage.core.serde(conn);
var inst_17488 = fluree.db.serde.protocol._serialize_leaf(inst_17487,inst_17486);
var inst_17489 = fluree.db.storage.core.write_history(conn,history,inst_17483,null);
var inst_17490 = fluree.db.storage.core.storage_write(conn,inst_17482__$1,inst_17488);
var state_17501__$1 = (function (){var statearr_17505 = state_17501;
(statearr_17505[(8)] = inst_17490);

(statearr_17505[(7)] = inst_17482__$1);

return statearr_17505;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17501__$1,(6),inst_17489);
} else {
if((state_val_17502 === (3))){
var inst_17499 = (state_17501[(2)]);
var state_17501__$1 = state_17501;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17501__$1,inst_17499);
} else {
if((state_val_17502 === (4))){
var inst_17476 = (state_17501[(2)]);
var state_17501__$1 = state_17501;
var statearr_17507_17521 = state_17501__$1;
(statearr_17507_17521[(2)] = inst_17476);

(statearr_17507_17521[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17502 === (5))){
var _ = (function (){var statearr_17508 = state_17501;
(statearr_17508[(4)] = cljs.core.rest((state_17501[(4)])));

return statearr_17508;
})();
var state_17501__$1 = state_17501;
var ex17506 = (state_17501__$1[(2)]);
var statearr_17509_17522 = state_17501__$1;
(statearr_17509_17522[(5)] = ex17506);


if((ex17506 instanceof Error)){
var statearr_17510_17523 = state_17501__$1;
(statearr_17510_17523[(1)] = (4));

(statearr_17510_17523[(5)] = null);

} else {
throw ex17506;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17502 === (6))){
var inst_17490 = (state_17501[(8)]);
var inst_17492 = (state_17501[(2)]);
var inst_17493 = fluree.db.util.async.throw_err(inst_17492);
var state_17501__$1 = (function (){var statearr_17511 = state_17501;
(statearr_17511[(9)] = inst_17493);

return statearr_17511;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17501__$1,(7),inst_17490);
} else {
if((state_val_17502 === (7))){
var inst_17482 = (state_17501[(7)]);
var inst_17495 = (state_17501[(2)]);
var inst_17496 = fluree.db.util.async.throw_err(inst_17495);
var _ = (function (){var statearr_17512 = state_17501;
(statearr_17512[(4)] = cljs.core.rest((state_17501[(4)])));

return statearr_17512;
})();
var state_17501__$1 = (function (){var statearr_17513 = state_17501;
(statearr_17513[(10)] = inst_17496);

return statearr_17513;
})();
var statearr_17514_17524 = state_17501__$1;
(statearr_17514_17524[(2)] = inst_17482);

(statearr_17514_17524[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__2741__auto____0 = (function (){
var statearr_17515 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17515[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__2741__auto__);

(statearr_17515[(1)] = (1));

return statearr_17515;
});
var fluree$db$storage$core$write_leaf_$_state_machine__2741__auto____1 = (function (state_17501){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_17501);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e17516){var ex__2744__auto__ = e17516;
var statearr_17517_17525 = state_17501;
(statearr_17517_17525[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_17501[(4)]))){
var statearr_17518_17526 = state_17501;
(statearr_17518_17526[(1)] = cljs.core.first((state_17501[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17527 = state_17501;
state_17501 = G__17527;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__2741__auto__ = function(state_17501){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__2741__auto____1.call(this,state_17501);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__2741__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__2741__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_17519 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_17519[(6)] = c__2763__auto__);

return statearr_17519;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_17544){
var state_val_17545 = (state_17544[(1)]);
if((state_val_17545 === (1))){
var state_17544__$1 = state_17544;
var statearr_17546_17561 = state_17544__$1;
(statearr_17546_17561[(2)] = null);

(statearr_17546_17561[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17545 === (2))){
var _ = (function (){var statearr_17547 = state_17544;
(statearr_17547[(4)] = cljs.core.cons((5),(state_17544[(4)])));

return statearr_17547;
})();
var inst_17534 = fluree.db.storage.core.serde(conn);
var inst_17535 = fluree.db.serde.protocol._serialize_branch(inst_17534,data);
var inst_17536 = fluree.db.storage.core.storage_write(conn,key,inst_17535);
var state_17544__$1 = state_17544;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17544__$1,(6),inst_17536);
} else {
if((state_val_17545 === (3))){
var inst_17542 = (state_17544[(2)]);
var state_17544__$1 = state_17544;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17544__$1,inst_17542);
} else {
if((state_val_17545 === (4))){
var inst_17528 = (state_17544[(2)]);
var state_17544__$1 = state_17544;
var statearr_17549_17562 = state_17544__$1;
(statearr_17549_17562[(2)] = inst_17528);

(statearr_17549_17562[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17545 === (5))){
var _ = (function (){var statearr_17550 = state_17544;
(statearr_17550[(4)] = cljs.core.rest((state_17544[(4)])));

return statearr_17550;
})();
var state_17544__$1 = state_17544;
var ex17548 = (state_17544__$1[(2)]);
var statearr_17551_17563 = state_17544__$1;
(statearr_17551_17563[(5)] = ex17548);


if((ex17548 instanceof Error)){
var statearr_17552_17564 = state_17544__$1;
(statearr_17552_17564[(1)] = (4));

(statearr_17552_17564[(5)] = null);

} else {
throw ex17548;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17545 === (6))){
var inst_17538 = (state_17544[(2)]);
var inst_17539 = fluree.db.util.async.throw_err(inst_17538);
var _ = (function (){var statearr_17553 = state_17544;
(statearr_17553[(4)] = cljs.core.rest((state_17544[(4)])));

return statearr_17553;
})();
var state_17544__$1 = (function (){var statearr_17554 = state_17544;
(statearr_17554[(7)] = inst_17539);

return statearr_17554;
})();
var statearr_17555_17565 = state_17544__$1;
(statearr_17555_17565[(2)] = key);

(statearr_17555_17565[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__2741__auto____0 = (function (){
var statearr_17556 = [null,null,null,null,null,null,null,null];
(statearr_17556[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__2741__auto__);

(statearr_17556[(1)] = (1));

return statearr_17556;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__2741__auto____1 = (function (state_17544){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_17544);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e17557){var ex__2744__auto__ = e17557;
var statearr_17558_17566 = state_17544;
(statearr_17558_17566[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_17544[(4)]))){
var statearr_17559_17567 = state_17544;
(statearr_17559_17567[(1)] = cljs.core.first((state_17544[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17568 = state_17544;
state_17544 = G__17568;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__2741__auto__ = function(state_17544){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__2741__auto____1.call(this,state_17544);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__2741__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__2741__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_17560 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_17560[(6)] = c__2763__auto__);

return statearr_17560;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__17569_SHARP_){
return fluree.db.storage.core.child_data(cljs.core.val(p1__17569_SHARP_));
}),children);
var rhs = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(cljs.core.last(child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"children","children",-940561982),child_vals,new cljs.core.Keyword(null,"rhs","rhs",-229356739),rhs], null);
return fluree.db.storage.core.write_branch_data(conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__17570){
var map__17571 = p__17570;
var map__17571__$1 = cljs.core.__destructure_map(map__17571);
var progress = map__17571__$1;
var garbage = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17571__$1,new cljs.core.Keyword(null,"garbage","garbage",-2063107600));
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_17599){
var state_val_17600 = (state_17599[(1)]);
if((state_val_17600 === (1))){
var state_17599__$1 = state_17599;
var statearr_17601_17617 = state_17599__$1;
(statearr_17601_17617[(2)] = null);

(statearr_17601_17617[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17600 === (2))){
var inst_17585 = (state_17599[(7)]);
var _ = (function (){var statearr_17602 = state_17599;
(statearr_17602[(4)] = cljs.core.cons((5),(state_17599[(4)])));

return statearr_17602;
})();
var inst_17579 = db;
var inst_17580 = cljs.core.__destructure_map(inst_17579);
var inst_17581 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17580,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_17582 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17580,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_17583 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17580,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_17584 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17580,new cljs.core.Keyword(null,"block","block",664686210));
var inst_17585__$1 = fluree.db.storage.core.ledger_garbage_key(inst_17582,inst_17583,inst_17584);
var inst_17586 = [new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_17587 = [inst_17583,inst_17584,garbage];
var inst_17588 = cljs.core.PersistentHashMap.fromArrays(inst_17586,inst_17587);
var inst_17589 = fluree.db.storage.core.serde(inst_17581);
var inst_17590 = fluree.db.serde.protocol._serialize_garbage(inst_17589,inst_17588);
var inst_17591 = fluree.db.storage.core.storage_write(inst_17581,inst_17585__$1,inst_17590);
var state_17599__$1 = (function (){var statearr_17603 = state_17599;
(statearr_17603[(7)] = inst_17585__$1);

return statearr_17603;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17599__$1,(6),inst_17591);
} else {
if((state_val_17600 === (3))){
var inst_17597 = (state_17599[(2)]);
var state_17599__$1 = state_17599;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17599__$1,inst_17597);
} else {
if((state_val_17600 === (4))){
var inst_17572 = (state_17599[(2)]);
var state_17599__$1 = state_17599;
var statearr_17605_17618 = state_17599__$1;
(statearr_17605_17618[(2)] = inst_17572);

(statearr_17605_17618[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17600 === (5))){
var _ = (function (){var statearr_17606 = state_17599;
(statearr_17606[(4)] = cljs.core.rest((state_17599[(4)])));

return statearr_17606;
})();
var state_17599__$1 = state_17599;
var ex17604 = (state_17599__$1[(2)]);
var statearr_17607_17619 = state_17599__$1;
(statearr_17607_17619[(5)] = ex17604);


if((ex17604 instanceof Error)){
var statearr_17608_17620 = state_17599__$1;
(statearr_17608_17620[(1)] = (4));

(statearr_17608_17620[(5)] = null);

} else {
throw ex17604;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17600 === (6))){
var inst_17585 = (state_17599[(7)]);
var inst_17593 = (state_17599[(2)]);
var inst_17594 = fluree.db.util.async.throw_err(inst_17593);
var _ = (function (){var statearr_17609 = state_17599;
(statearr_17609[(4)] = cljs.core.rest((state_17599[(4)])));

return statearr_17609;
})();
var state_17599__$1 = (function (){var statearr_17610 = state_17599;
(statearr_17610[(8)] = inst_17594);

return statearr_17610;
})();
var statearr_17611_17621 = state_17599__$1;
(statearr_17611_17621[(2)] = inst_17585);

(statearr_17611_17621[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__2741__auto____0 = (function (){
var statearr_17612 = [null,null,null,null,null,null,null,null,null];
(statearr_17612[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__2741__auto__);

(statearr_17612[(1)] = (1));

return statearr_17612;
});
var fluree$db$storage$core$write_garbage_$_state_machine__2741__auto____1 = (function (state_17599){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_17599);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e17613){var ex__2744__auto__ = e17613;
var statearr_17614_17622 = state_17599;
(statearr_17614_17622[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_17599[(4)]))){
var statearr_17615_17623 = state_17599;
(statearr_17615_17623[(1)] = cljs.core.first((state_17599[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17624 = state_17599;
state_17599 = G__17624;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__2741__auto__ = function(state_17599){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__2741__auto____1.call(this,state_17599);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__2741__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__2741__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_17616 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_17616[(6)] = c__2763__auto__);

return statearr_17616;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__17626 = arguments.length;
switch (G__17626) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2(db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_17682){
var state_val_17683 = (state_17682[(1)]);
if((state_val_17683 === (7))){
var state_17682__$1 = state_17682;
var statearr_17684_17710 = state_17682__$1;
(statearr_17684_17710[(2)] = (0));

(statearr_17684_17710[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17683 === (1))){
var state_17682__$1 = state_17682;
var statearr_17685_17711 = state_17682__$1;
(statearr_17685_17711[(2)] = null);

(statearr_17685_17711[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17683 === (4))){
var inst_17627 = (state_17682[(2)]);
var state_17682__$1 = state_17682;
var statearr_17686_17712 = state_17682__$1;
(statearr_17686_17712[(2)] = inst_17627);

(statearr_17686_17712[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17683 === (6))){
var inst_17652 = (state_17682[(7)]);
var state_17682__$1 = state_17682;
var statearr_17687_17713 = state_17682__$1;
(statearr_17687_17713[(2)] = inst_17652);

(statearr_17687_17713[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17683 === (3))){
var inst_17680 = (state_17682[(2)]);
var state_17682__$1 = state_17682;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17682__$1,inst_17680);
} else {
if((state_val_17683 === (12))){
var inst_17649 = (state_17682[(8)]);
var inst_17676 = (state_17682[(2)]);
var inst_17677 = fluree.db.util.async.throw_err(inst_17676);
var _ = (function (){var statearr_17688 = state_17682;
(statearr_17688[(4)] = cljs.core.rest((state_17682[(4)])));

return statearr_17688;
})();
var state_17682__$1 = (function (){var statearr_17689 = state_17682;
(statearr_17689[(9)] = inst_17677);

return statearr_17689;
})();
var statearr_17690_17714 = state_17682__$1;
(statearr_17690_17714[(2)] = inst_17649);

(statearr_17690_17714[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17683 === (2))){
var inst_17640 = (state_17682[(10)]);
var inst_17642 = (state_17682[(11)]);
var inst_17644 = (state_17682[(12)]);
var inst_17652 = (state_17682[(7)]);
var _ = (function (){var statearr_17691 = state_17682;
(statearr_17691[(4)] = cljs.core.cons((5),(state_17682[(4)])));

return statearr_17691;
})();
var inst_17634 = db;
var inst_17635 = cljs.core.__destructure_map(inst_17634);
var inst_17636 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17635,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_17637 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17635,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_17638 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17635,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_17639 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17635,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_17640__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17635,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_17641 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17635,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_17642__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17635,new cljs.core.Keyword(null,"block","block",664686210));
var inst_17643 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17635,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_17644__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17635,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_17645 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17635,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_17646 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17635,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_17647 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17635,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_17648 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17635,new cljs.core.Keyword(null,"post","post",269697687));
var inst_17649 = fluree.db.storage.core.ledger_root_key(inst_17636,inst_17644__$1,inst_17642__$1);
var inst_17650 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_17651 = fluree.db.storage.core.child_data(inst_17643);
var inst_17652__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_17640__$1);
var state_17682__$1 = (function (){var statearr_17692 = state_17682;
(statearr_17692[(10)] = inst_17640__$1);

(statearr_17692[(11)] = inst_17642__$1);

(statearr_17692[(13)] = inst_17647);

(statearr_17692[(14)] = inst_17651);

(statearr_17692[(15)] = inst_17645);

(statearr_17692[(16)] = inst_17646);

(statearr_17692[(17)] = inst_17650);

(statearr_17692[(18)] = inst_17639);

(statearr_17692[(19)] = inst_17637);

(statearr_17692[(12)] = inst_17644__$1);

(statearr_17692[(20)] = inst_17638);

(statearr_17692[(21)] = inst_17641);

(statearr_17692[(22)] = inst_17648);

(statearr_17692[(8)] = inst_17649);

(statearr_17692[(7)] = inst_17652__$1);

return statearr_17692;
})();
if(cljs.core.truth_(inst_17652__$1)){
var statearr_17693_17715 = state_17682__$1;
(statearr_17693_17715[(1)] = (6));

} else {
var statearr_17694_17716 = state_17682__$1;
(statearr_17694_17716[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17683 === (11))){
var inst_17640 = (state_17682[(10)]);
var inst_17642 = (state_17682[(11)]);
var inst_17647 = (state_17682[(13)]);
var inst_17651 = (state_17682[(14)]);
var inst_17656 = (state_17682[(23)]);
var inst_17646 = (state_17682[(16)]);
var inst_17650 = (state_17682[(17)]);
var inst_17639 = (state_17682[(18)]);
var inst_17637 = (state_17682[(19)]);
var inst_17644 = (state_17682[(12)]);
var inst_17638 = (state_17682[(20)]);
var inst_17641 = (state_17682[(21)]);
var inst_17648 = (state_17682[(22)]);
var inst_17649 = (state_17682[(8)]);
var inst_17661 = (state_17682[(2)]);
var inst_17662 = fluree.db.storage.core.child_data(inst_17646);
var inst_17663 = fluree.db.storage.core.child_data(inst_17648);
var inst_17664 = fluree.db.util.core.current_time_millis();
var inst_17665 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17666 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_17667 = (new cljs.core.PersistentVector(null,2,(5),inst_17665,inst_17666,null));
var inst_17668 = cljs.core.select_keys(inst_17640,inst_17667);
var inst_17669 = fluree.db.storage.core.child_data(inst_17639);
var inst_17670 = [inst_17642,inst_17651,inst_17644,inst_17656,inst_17661,inst_17662,inst_17663,inst_17637,inst_17664,inst_17638,inst_17647,inst_17668,inst_17669];
var inst_17671 = cljs.core.PersistentHashMap.fromArrays(inst_17650,inst_17670);
var inst_17672 = fluree.db.storage.core.serde(inst_17641);
var inst_17673 = fluree.db.serde.protocol._serialize_db_root(inst_17672,inst_17671);
var inst_17674 = fluree.db.storage.core.storage_write(inst_17641,inst_17649,inst_17673);
var state_17682__$1 = state_17682;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17682__$1,(12),inst_17674);
} else {
if((state_val_17683 === (9))){
var inst_17657 = (state_17682[(24)]);
var state_17682__$1 = state_17682;
var statearr_17696_17717 = state_17682__$1;
(statearr_17696_17717[(2)] = inst_17657);

(statearr_17696_17717[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17683 === (5))){
var _ = (function (){var statearr_17697 = state_17682;
(statearr_17697[(4)] = cljs.core.rest((state_17682[(4)])));

return statearr_17697;
})();
var state_17682__$1 = state_17682;
var ex17695 = (state_17682__$1[(2)]);
var statearr_17698_17718 = state_17682__$1;
(statearr_17698_17718[(5)] = ex17695);


if((ex17695 instanceof Error)){
var statearr_17699_17719 = state_17682__$1;
(statearr_17699_17719[(1)] = (4));

(statearr_17699_17719[(5)] = null);

} else {
throw ex17695;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17683 === (10))){
var inst_17645 = (state_17682[(15)]);
var state_17682__$1 = state_17682;
var statearr_17700_17720 = state_17682__$1;
(statearr_17700_17720[(2)] = inst_17645);

(statearr_17700_17720[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17683 === (8))){
var inst_17657 = (state_17682[(24)]);
var inst_17656 = (state_17682[(2)]);
var inst_17657__$1 = custom_ecount;
var state_17682__$1 = (function (){var statearr_17701 = state_17682;
(statearr_17701[(23)] = inst_17656);

(statearr_17701[(24)] = inst_17657__$1);

return statearr_17701;
})();
if(cljs.core.truth_(inst_17657__$1)){
var statearr_17702_17721 = state_17682__$1;
(statearr_17702_17721[(1)] = (9));

} else {
var statearr_17703_17722 = state_17682__$1;
(statearr_17703_17722[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2741__auto__ = null;
var fluree$db$storage$core$state_machine__2741__auto____0 = (function (){
var statearr_17704 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17704[(0)] = fluree$db$storage$core$state_machine__2741__auto__);

(statearr_17704[(1)] = (1));

return statearr_17704;
});
var fluree$db$storage$core$state_machine__2741__auto____1 = (function (state_17682){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_17682);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e17705){var ex__2744__auto__ = e17705;
var statearr_17706_17723 = state_17682;
(statearr_17706_17723[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_17682[(4)]))){
var statearr_17707_17724 = state_17682;
(statearr_17707_17724[(1)] = cljs.core.first((state_17682[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17725 = state_17682;
state_17682 = G__17725;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2741__auto__ = function(state_17682){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2741__auto____1.call(this,state_17682);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2741__auto____0;
fluree$db$storage$core$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2741__auto____1;
return fluree$db$storage$core$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_17708 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_17708[(6)] = c__2763__auto__);

return statearr_17708;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2763__auto___17784 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_17758){
var state_val_17759 = (state_17758[(1)]);
if((state_val_17759 === (7))){
var inst_17738 = (state_17758[(7)]);
var state_17758__$1 = state_17758;
var statearr_17760_17785 = state_17758__$1;
(statearr_17760_17785[(2)] = inst_17738);

(statearr_17760_17785[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17759 === (1))){
var state_17758__$1 = state_17758;
var statearr_17761_17786 = state_17758__$1;
(statearr_17761_17786[(2)] = null);

(statearr_17761_17786[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17759 === (4))){
var inst_17726 = (state_17758[(2)]);
var inst_17727 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_17728 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_17726);
var inst_17729 = cljs.core.async.close_BANG_(return_ch);
var state_17758__$1 = (function (){var statearr_17762 = state_17758;
(statearr_17762[(8)] = inst_17728);

(statearr_17762[(9)] = inst_17727);

return statearr_17762;
})();
var statearr_17763_17787 = state_17758__$1;
(statearr_17763_17787[(2)] = inst_17729);

(statearr_17763_17787[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17759 === (6))){
var inst_17738 = (state_17758[(7)]);
var inst_17737 = (state_17758[(10)]);
var inst_17737__$1 = (state_17758[(2)]);
var inst_17738__$1 = (inst_17737__$1 == null);
var state_17758__$1 = (function (){var statearr_17764 = state_17758;
(statearr_17764[(7)] = inst_17738__$1);

(statearr_17764[(10)] = inst_17737__$1);

return statearr_17764;
})();
if(cljs.core.truth_(inst_17738__$1)){
var statearr_17765_17788 = state_17758__$1;
(statearr_17765_17788[(1)] = (7));

} else {
var statearr_17766_17789 = state_17758__$1;
(statearr_17766_17789[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17759 === (3))){
var inst_17756 = (state_17758[(2)]);
var state_17758__$1 = state_17758;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17758__$1,inst_17756);
} else {
if((state_val_17759 === (12))){
var inst_17753 = (state_17758[(2)]);
var _ = (function (){var statearr_17767 = state_17758;
(statearr_17767[(4)] = cljs.core.rest((state_17758[(4)])));

return statearr_17767;
})();
var state_17758__$1 = state_17758;
var statearr_17768_17790 = state_17758__$1;
(statearr_17768_17790[(2)] = inst_17753);

(statearr_17768_17790[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17759 === (2))){
var _ = (function (){var statearr_17769 = state_17758;
(statearr_17769[(4)] = cljs.core.cons((5),(state_17758[(4)])));

return statearr_17769;
})();
var inst_17735 = fluree.db.storage.core.storage_read(conn,key);
var state_17758__$1 = state_17758;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17758__$1,(6),inst_17735);
} else {
if((state_val_17759 === (11))){
var inst_17737 = (state_17758[(10)]);
var inst_17747 = fluree.db.storage.core.serde(conn);
var inst_17748 = fluree.db.serde.protocol._deserialize_leaf(inst_17747,inst_17737);
var inst_17749 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_17748);
var inst_17750 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_history,inst_17749);
var inst_17751 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_17750);
var state_17758__$1 = state_17758;
var statearr_17771_17791 = state_17758__$1;
(statearr_17771_17791[(2)] = inst_17751);

(statearr_17771_17791[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17759 === (9))){
var inst_17743 = (state_17758[(2)]);
var state_17758__$1 = state_17758;
if(cljs.core.truth_(inst_17743)){
var statearr_17772_17792 = state_17758__$1;
(statearr_17772_17792[(1)] = (10));

} else {
var statearr_17773_17793 = state_17758__$1;
(statearr_17773_17793[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17759 === (5))){
var _ = (function (){var statearr_17774 = state_17758;
(statearr_17774[(4)] = cljs.core.rest((state_17758[(4)])));

return statearr_17774;
})();
var state_17758__$1 = state_17758;
var ex17770 = (state_17758__$1[(2)]);
var statearr_17775_17794 = state_17758__$1;
(statearr_17775_17794[(5)] = ex17770);


var statearr_17776_17795 = state_17758__$1;
(statearr_17776_17795[(1)] = (4));

(statearr_17776_17795[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17759 === (10))){
var inst_17745 = cljs.core.async.close_BANG_(return_ch);
var state_17758__$1 = state_17758;
var statearr_17777_17796 = state_17758__$1;
(statearr_17777_17796[(2)] = inst_17745);

(statearr_17777_17796[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17759 === (8))){
var inst_17737 = (state_17758[(10)]);
var inst_17741 = (inst_17737 instanceof Error);
var state_17758__$1 = state_17758;
var statearr_17778_17797 = state_17758__$1;
(statearr_17778_17797[(2)] = inst_17741);

(statearr_17778_17797[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__2741__auto____0 = (function (){
var statearr_17779 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17779[(0)] = fluree$db$storage$core$reify_history_$_state_machine__2741__auto__);

(statearr_17779[(1)] = (1));

return statearr_17779;
});
var fluree$db$storage$core$reify_history_$_state_machine__2741__auto____1 = (function (state_17758){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_17758);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e17780){var ex__2744__auto__ = e17780;
var statearr_17781_17798 = state_17758;
(statearr_17781_17798[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_17758[(4)]))){
var statearr_17782_17799 = state_17758;
(statearr_17782_17799[(1)] = cljs.core.first((state_17758[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17800 = state_17758;
state_17758 = G__17800;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__2741__auto__ = function(state_17758){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__2741__auto____1.call(this,state_17758);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__2741__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__2741__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_17783 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_17783[(6)] = c__2763__auto___17784);

return statearr_17783;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__17802 = arguments.length;
switch (G__17802) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__4251__auto__ = rhs;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not(leftmost_QMARK_);
} else {
return and__4251__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4251__auto__ = rhs;
if(cljs.core.truth_(and__4251__auto__)){
return leftmost_QMARK_;
} else {
return and__4251__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not(leftmost_QMARK_))))?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__4251__auto__ = (rhs == null);
if(and__4251__auto__){
return leftmost_QMARK_;
} else {
return and__4251__auto__;
}
})())?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2763__auto___17914 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_17865){
var state_val_17866 = (state_17865[(1)]);
if((state_val_17866 === (7))){
var state_17865__$1 = state_17865;
var statearr_17867_17915 = state_17865__$1;
(statearr_17867_17915[(2)] = new cljs.core.Keyword(null,"novelty","novelty",-1590246024));

(statearr_17867_17915[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17866 === (20))){
var inst_17844 = cljs.core.PersistentVector.EMPTY;
var state_17865__$1 = state_17865;
var statearr_17868_17916 = state_17865__$1;
(statearr_17868_17916[(2)] = inst_17844);

(statearr_17868_17916[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17866 === (1))){
var state_17865__$1 = state_17865;
var statearr_17869_17917 = state_17865__$1;
(statearr_17869_17917[(2)] = null);

(statearr_17869_17917[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17866 === (24))){
var state_17865__$1 = state_17865;
var statearr_17870_17918 = state_17865__$1;
(statearr_17870_17918[(2)] = null);

(statearr_17870_17918[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17866 === (4))){
var inst_17805 = (state_17865[(2)]);
var inst_17806 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_17807 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_17805);
var inst_17808 = cljs.core.async.close_BANG_(result_ch);
var state_17865__$1 = (function (){var statearr_17871 = state_17865;
(statearr_17871[(7)] = inst_17806);

(statearr_17871[(8)] = inst_17807);

return statearr_17871;
})();
var statearr_17872_17919 = state_17865__$1;
(statearr_17872_17919[(2)] = inst_17808);

(statearr_17872_17919[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17866 === (15))){
var inst_17830 = (state_17865[(2)]);
var state_17865__$1 = state_17865;
var statearr_17873_17920 = state_17865__$1;
(statearr_17873_17920[(2)] = inst_17830);

(statearr_17873_17920[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17866 === (21))){
var inst_17819 = (state_17865[(9)]);
var inst_17847 = (state_17865[(10)]);
var inst_17834 = (state_17865[(11)]);
var inst_17817 = (state_17865[(12)]);
var inst_17818 = (state_17865[(13)]);
var inst_17854 = (state_17865[(2)]);
var inst_17855 = (function (){var base_node = inst_17817;
var first_flake = inst_17818;
var node_t = inst_17819;
var source = inst_17834;
var coll = inst_17847;
var conj_QMARK_ = inst_17854;
return (function (acc,f){
if(cljs.core.truth_((function (){var G__17875 = f.p;
var fexpr__17874 = (function (){var or__4253__auto__ = remove_preds;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})();
return (fexpr__17874.cljs$core$IFn$_invoke$arity$1 ? fexpr__17874.cljs$core$IFn$_invoke$arity$1(G__17875) : fexpr__17874.call(null,G__17875));
})())){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
if(cljs.core.truth_((conj_QMARK_.cljs$core$IFn$_invoke$arity$1 ? conj_QMARK_.cljs$core$IFn$_invoke$arity$1(f) : conj_QMARK_.call(null,f)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);

}
}
});
})();
var inst_17856 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_17817);
var inst_17857 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_17855,inst_17856,inst_17847);
var inst_17858 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_17857);
var inst_17859 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_17817,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_17858);
var inst_17860 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_17859);
var _ = (function (){var statearr_17876 = state_17865;
(statearr_17876[(4)] = cljs.core.rest((state_17865[(4)])));

return statearr_17876;
})();
var state_17865__$1 = state_17865;
var statearr_17877_17921 = state_17865__$1;
(statearr_17877_17921[(2)] = inst_17860);

(statearr_17877_17921[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17866 === (13))){
var state_17865__$1 = state_17865;
var statearr_17878_17922 = state_17865__$1;
(statearr_17878_17922[(2)] = new cljs.core.Keyword(null,"none","none",1333468478));

(statearr_17878_17922[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17866 === (22))){
var inst_17819 = (state_17865[(9)]);
var inst_17847 = (state_17865[(10)]);
var inst_17834 = (state_17865[(11)]);
var inst_17817 = (state_17865[(12)]);
var inst_17818 = (state_17865[(13)]);
var inst_17848 = (function (){var base_node = inst_17817;
var first_flake = inst_17818;
var node_t = inst_17819;
var source = inst_17834;
var coll = inst_17847;
return (function (f){
return f.op === true;
});
})();
var state_17865__$1 = state_17865;
var statearr_17879_17923 = state_17865__$1;
(statearr_17879_17923[(2)] = inst_17848);

(statearr_17879_17923[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17866 === (6))){
var inst_17819 = (state_17865[(9)]);
var inst_17817 = (state_17865[(12)]);
var inst_17816 = (state_17865[(2)]);
var inst_17817__$1 = fluree.db.util.async.throw_err(inst_17816);
var inst_17818 = fluree.db.dbproto._first_flake(inst_17817__$1);
var inst_17819__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_17817__$1);
var inst_17820 = (inst_17819__$1 > t);
var state_17865__$1 = (function (){var statearr_17880 = state_17865;
(statearr_17880[(9)] = inst_17819__$1);

(statearr_17880[(12)] = inst_17817__$1);

(statearr_17880[(13)] = inst_17818);

return statearr_17880;
})();
if(cljs.core.truth_(inst_17820)){
var statearr_17881_17924 = state_17865__$1;
(statearr_17881_17924[(1)] = (7));

} else {
var statearr_17882_17925 = state_17865__$1;
(statearr_17882_17925[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17866 === (17))){
var inst_17818 = (state_17865[(13)]);
var inst_17835 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_17818,rhs,leftmost_QMARK_,t);
var state_17865__$1 = state_17865;
var statearr_17883_17926 = state_17865__$1;
(statearr_17883_17926[(2)] = inst_17835);

(statearr_17883_17926[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17866 === (3))){
var inst_17863 = (state_17865[(2)]);
var state_17865__$1 = state_17865;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17865__$1,inst_17863);
} else {
if((state_val_17866 === (12))){
var inst_17832 = (state_17865[(2)]);
var state_17865__$1 = state_17865;
var statearr_17884_17927 = state_17865__$1;
(statearr_17884_17927[(2)] = inst_17832);

(statearr_17884_17927[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17866 === (2))){
var _ = (function (){var statearr_17885 = state_17865;
(statearr_17885[(4)] = cljs.core.cons((5),(state_17865[(4)])));

return statearr_17885;
})();
var inst_17814 = fluree.db.dbproto._resolve(node);
var state_17865__$1 = state_17865;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17865__$1,(6),inst_17814);
} else {
if((state_val_17866 === (23))){
var inst_17819 = (state_17865[(9)]);
var inst_17847 = (state_17865[(10)]);
var inst_17834 = (state_17865[(11)]);
var inst_17817 = (state_17865[(12)]);
var inst_17818 = (state_17865[(13)]);
var inst_17850 = (function (){var base_node = inst_17817;
var first_flake = inst_17818;
var node_t = inst_17819;
var source = inst_17834;
var coll = inst_17847;
return (function (f){
return f.op === false;
});
})();
var state_17865__$1 = state_17865;
var statearr_17886_17928 = state_17865__$1;
(statearr_17886_17928[(2)] = inst_17850);

(statearr_17886_17928[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17866 === (19))){
var inst_17837 = (state_17865[(14)]);
var inst_17840 = (state_17865[(2)]);
var inst_17841 = fluree.db.util.async.throw_err(inst_17840);
var inst_17842 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_17837,inst_17841);
var state_17865__$1 = state_17865;
var statearr_17887_17929 = state_17865__$1;
(statearr_17887_17929[(2)] = inst_17842);

(statearr_17887_17929[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17866 === (11))){
var inst_17819 = (state_17865[(9)]);
var inst_17826 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_17819,t);
var state_17865__$1 = state_17865;
if(inst_17826){
var statearr_17889_17930 = state_17865__$1;
(statearr_17889_17930[(1)] = (13));

} else {
var statearr_17890_17931 = state_17865__$1;
(statearr_17890_17931[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17866 === (9))){
var inst_17834 = (state_17865[(11)]);
var inst_17834__$1 = (state_17865[(2)]);
var state_17865__$1 = (function (){var statearr_17891 = state_17865;
(statearr_17891[(11)] = inst_17834__$1);

return statearr_17891;
})();
var G__17892_17932 = inst_17834__$1;
var G__17892_17933__$1 = (((G__17892_17932 instanceof cljs.core.Keyword))?G__17892_17932.fqn:null);
switch (G__17892_17933__$1) {
case "novelty":
var statearr_17893_17935 = state_17865__$1;
(statearr_17893_17935[(1)] = (17));


break;
case "history":
var statearr_17894_17936 = state_17865__$1;
(statearr_17894_17936[(1)] = (18));


break;
case "none":
var statearr_17895_17937 = state_17865__$1;
(statearr_17895_17937[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__17892_17933__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17866 === (5))){
var _ = (function (){var statearr_17896 = state_17865;
(statearr_17896[(4)] = cljs.core.rest((state_17865[(4)])));

return statearr_17896;
})();
var state_17865__$1 = state_17865;
var ex17888 = (state_17865__$1[(2)]);
var statearr_17897_17938 = state_17865__$1;
(statearr_17897_17938[(5)] = ex17888);


var statearr_17898_17939 = state_17865__$1;
(statearr_17898_17939[(1)] = (4));

(statearr_17898_17939[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17866 === (14))){
var state_17865__$1 = state_17865;
var statearr_17899_17940 = state_17865__$1;
(statearr_17899_17940[(2)] = null);

(statearr_17899_17940[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17866 === (16))){
var inst_17834 = (state_17865[(11)]);
var inst_17847 = (state_17865[(2)]);
var state_17865__$1 = (function (){var statearr_17900 = state_17865;
(statearr_17900[(10)] = inst_17847);

return statearr_17900;
})();
var G__17901_17941 = inst_17834;
var G__17901_17942__$1 = (((G__17901_17941 instanceof cljs.core.Keyword))?G__17901_17941.fqn:null);
switch (G__17901_17942__$1) {
case "novelty":
var statearr_17902_17944 = state_17865__$1;
(statearr_17902_17944[(1)] = (22));


break;
case "history":
var statearr_17903_17945 = state_17865__$1;
(statearr_17903_17945[(1)] = (23));


break;
case "none":
var statearr_17904_17946 = state_17865__$1;
(statearr_17904_17946[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__17901_17942__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17866 === (10))){
var state_17865__$1 = state_17865;
var statearr_17905_17947 = state_17865__$1;
(statearr_17905_17947[(2)] = new cljs.core.Keyword(null,"history","history",-247395220));

(statearr_17905_17947[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17866 === (18))){
var inst_17819 = (state_17865[(9)]);
var inst_17834 = (state_17865[(11)]);
var inst_17817 = (state_17865[(12)]);
var inst_17818 = (state_17865[(13)]);
var inst_17837 = (function (){var base_node = inst_17817;
var first_flake = inst_17818;
var node_t = inst_17819;
var source = inst_17834;
return (function (p1__17804_SHARP_){
return (p1__17804_SHARP_.t <= t);
});
})();
var inst_17838 = fluree.db.dbproto._resolve_history(node);
var state_17865__$1 = (function (){var statearr_17906 = state_17865;
(statearr_17906[(14)] = inst_17837);

return statearr_17906;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17865__$1,(19),inst_17838);
} else {
if((state_val_17866 === (8))){
var inst_17819 = (state_17865[(9)]);
var inst_17823 = (inst_17819 < t);
var state_17865__$1 = state_17865;
if(cljs.core.truth_(inst_17823)){
var statearr_17907_17948 = state_17865__$1;
(statearr_17907_17948[(1)] = (10));

} else {
var statearr_17908_17949 = state_17865__$1;
(statearr_17908_17949[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__2741__auto____0 = (function (){
var statearr_17909 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17909[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__2741__auto__);

(statearr_17909[(1)] = (1));

return statearr_17909;
});
var fluree$db$storage$core$resolve_t_$_state_machine__2741__auto____1 = (function (state_17865){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_17865);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e17910){var ex__2744__auto__ = e17910;
var statearr_17911_17950 = state_17865;
(statearr_17911_17950[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_17865[(4)]))){
var statearr_17912_17951 = state_17865;
(statearr_17912_17951[(1)] = cljs.core.first((state_17865[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17952 = state_17865;
state_17865 = G__17952;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__2741__auto__ = function(state_17865){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__2741__auto____1.call(this,state_17865);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__2741__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__2741__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_17913 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_17913[(6)] = c__2763__auto___17914);

return statearr_17913;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_18012){
var state_val_18013 = (state_18012[(1)]);
if((state_val_18013 === (7))){
var inst_17963 = (state_18012[(7)]);
var inst_17967 = (inst_17963 <= from_t);
var state_18012__$1 = state_18012;
var statearr_18014_18054 = state_18012__$1;
(statearr_18014_18054[(2)] = inst_17967);

(statearr_18014_18054[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18013 === (20))){
var inst_17997 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(node);
var inst_17998 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_17997)].join('');
var inst_17999 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18000 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_18001 = cljs.core.PersistentHashMap.fromArrays(inst_17999,inst_18000);
var inst_18002 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_17998,inst_18001);
var inst_18003 = (function(){throw inst_18002})();
var state_18012__$1 = state_18012;
var statearr_18015_18055 = state_18012__$1;
(statearr_18015_18055[(2)] = inst_18003);

(statearr_18015_18055[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18013 === (1))){
var state_18012__$1 = state_18012;
var statearr_18016_18056 = state_18012__$1;
(statearr_18016_18056[(2)] = null);

(statearr_18016_18056[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18013 === (4))){
var inst_17955 = (state_18012[(2)]);
var inst_17956 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_17955], 0));
var inst_17957 = (function(){throw inst_17955})();
var state_18012__$1 = (function (){var statearr_18017 = state_18012;
(statearr_18017[(8)] = inst_17956);

return statearr_18017;
})();
var statearr_18018_18057 = state_18012__$1;
(statearr_18018_18057[(2)] = inst_17957);

(statearr_18018_18057[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18013 === (15))){
var inst_17982 = (state_18012[(2)]);
var state_18012__$1 = (function (){var statearr_18019 = state_18012;
(statearr_18019[(9)] = inst_17982);

return statearr_18019;
})();
if(cljs.core.truth_(from_t)){
var statearr_18020_18058 = state_18012__$1;
(statearr_18020_18058[(1)] = (16));

} else {
var statearr_18021_18059 = state_18012__$1;
(statearr_18021_18059[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18013 === (21))){
var inst_17992 = (state_18012[(10)]);
var inst_17991 = (state_18012[(11)]);
var inst_17993 = (state_18012[(12)]);
var inst_18005 = (state_18012[(2)]);
var inst_18006 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_17992,inst_17993,leftmost_QMARK_,to_t);
var inst_18007 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_18006,inst_17991);
var _ = (function (){var statearr_18022 = state_18012;
(statearr_18022[(4)] = cljs.core.rest((state_18012[(4)])));

return statearr_18022;
})();
var state_18012__$1 = (function (){var statearr_18023 = state_18012;
(statearr_18023[(13)] = inst_18005);

return statearr_18023;
})();
var statearr_18024_18060 = state_18012__$1;
(statearr_18024_18060[(2)] = inst_18007);

(statearr_18024_18060[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18013 === (13))){
var inst_17963 = (state_18012[(7)]);
var inst_17975 = (state_18012[(14)]);
var inst_17978 = (function (){var node_t = inst_17963;
var G__17971 = inst_17975;
return (function (p1__17953_SHARP_){
return (p1__17953_SHARP_.t < to_t);
});
})();
var inst_17979 = cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(inst_17978,inst_17975);
var state_18012__$1 = state_18012;
var statearr_18025_18061 = state_18012__$1;
(statearr_18025_18061[(2)] = inst_17979);

(statearr_18025_18061[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18013 === (6))){
var inst_17964 = (state_18012[(15)]);
var state_18012__$1 = state_18012;
var statearr_18026_18062 = state_18012__$1;
(statearr_18026_18062[(2)] = inst_17964);

(statearr_18026_18062[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18013 === (17))){
var inst_17982 = (state_18012[(9)]);
var state_18012__$1 = state_18012;
var statearr_18027_18063 = state_18012__$1;
(statearr_18027_18063[(2)] = inst_17982);

(statearr_18027_18063[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18013 === (3))){
var inst_18010 = (state_18012[(2)]);
var state_18012__$1 = state_18012;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18012__$1,inst_18010);
} else {
if((state_val_18013 === (12))){
var inst_17963 = (state_18012[(7)]);
var inst_17974 = (state_18012[(2)]);
var inst_17975 = fluree.db.util.async.throw_err(inst_17974);
var inst_17976 = (to_t > inst_17963);
var state_18012__$1 = (function (){var statearr_18028 = state_18012;
(statearr_18028[(14)] = inst_17975);

return statearr_18028;
})();
if(cljs.core.truth_(inst_17976)){
var statearr_18029_18064 = state_18012__$1;
(statearr_18029_18064[(1)] = (13));

} else {
var statearr_18030_18065 = state_18012__$1;
(statearr_18030_18065[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18013 === (2))){
var inst_17964 = (state_18012[(15)]);
var _ = (function (){var statearr_18031 = state_18012;
(statearr_18031[(4)] = cljs.core.cons((5),(state_18012[(4)])));

return statearr_18031;
})();
var inst_17963 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(node);
var inst_17964__$1 = (from_t == null);
var state_18012__$1 = (function (){var statearr_18032 = state_18012;
(statearr_18032[(7)] = inst_17963);

(statearr_18032[(15)] = inst_17964__$1);

return statearr_18032;
})();
if(cljs.core.truth_(inst_17964__$1)){
var statearr_18033_18066 = state_18012__$1;
(statearr_18033_18066[(1)] = (6));

} else {
var statearr_18034_18067 = state_18012__$1;
(statearr_18034_18067[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18013 === (19))){
var state_18012__$1 = state_18012;
var statearr_18035_18068 = state_18012__$1;
(statearr_18035_18068[(2)] = null);

(statearr_18035_18068[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18013 === (11))){
var inst_17991 = (state_18012[(2)]);
var inst_17992 = fluree.db.dbproto._first_flake(node);
var inst_17993 = fluree.db.dbproto._rhs(node);
var inst_17994 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node);
var state_18012__$1 = (function (){var statearr_18037 = state_18012;
(statearr_18037[(10)] = inst_17992);

(statearr_18037[(11)] = inst_17991);

(statearr_18037[(12)] = inst_17993);

return statearr_18037;
})();
if(cljs.core.truth_(inst_17994)){
var statearr_18038_18069 = state_18012__$1;
(statearr_18038_18069[(1)] = (19));

} else {
var statearr_18039_18070 = state_18012__$1;
(statearr_18039_18070[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18013 === (9))){
var inst_17972 = fluree.db.dbproto._resolve_history(node);
var state_18012__$1 = state_18012;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18012__$1,(12),inst_17972);
} else {
if((state_val_18013 === (5))){
var _ = (function (){var statearr_18040 = state_18012;
(statearr_18040[(4)] = cljs.core.rest((state_18012[(4)])));

return statearr_18040;
})();
var state_18012__$1 = state_18012;
var ex18036 = (state_18012__$1[(2)]);
var statearr_18041_18071 = state_18012__$1;
(statearr_18041_18071[(5)] = ex18036);


var statearr_18042_18072 = state_18012__$1;
(statearr_18042_18072[(1)] = (4));

(statearr_18042_18072[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18013 === (14))){
var inst_17975 = (state_18012[(14)]);
var state_18012__$1 = state_18012;
var statearr_18043_18073 = state_18012__$1;
(statearr_18043_18073[(2)] = inst_17975);

(statearr_18043_18073[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18013 === (16))){
var inst_17963 = (state_18012[(7)]);
var inst_17982 = (state_18012[(9)]);
var inst_17984 = (function (){var node_t = inst_17963;
var G__17971 = inst_17982;
return (function (p1__17954_SHARP_){
return (p1__17954_SHARP_.t <= from_t);
});
})();
var inst_17985 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_17984,inst_17982);
var state_18012__$1 = state_18012;
var statearr_18044_18074 = state_18012__$1;
(statearr_18044_18074[(2)] = inst_17985);

(statearr_18044_18074[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18013 === (10))){
var state_18012__$1 = state_18012;
var statearr_18045_18075 = state_18012__$1;
(statearr_18045_18075[(2)] = null);

(statearr_18045_18075[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18013 === (18))){
var inst_17988 = (state_18012[(2)]);
var state_18012__$1 = state_18012;
var statearr_18046_18076 = state_18012__$1;
(statearr_18046_18076[(2)] = inst_17988);

(statearr_18046_18076[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18013 === (8))){
var inst_17969 = (state_18012[(2)]);
var state_18012__$1 = state_18012;
if(cljs.core.truth_(inst_17969)){
var statearr_18047_18077 = state_18012__$1;
(statearr_18047_18077[(1)] = (9));

} else {
var statearr_18048_18078 = state_18012__$1;
(statearr_18048_18078[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__2741__auto____0 = (function (){
var statearr_18049 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18049[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__2741__auto__);

(statearr_18049[(1)] = (1));

return statearr_18049;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__2741__auto____1 = (function (state_18012){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_18012);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e18050){var ex__2744__auto__ = e18050;
var statearr_18051_18079 = state_18012;
(statearr_18051_18079[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_18012[(4)]))){
var statearr_18052_18080 = state_18012;
(statearr_18052_18080[(1)] = cljs.core.first((state_18012[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18081 = state_18012;
state_18012 = G__18081;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__2741__auto__ = function(state_18012){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2741__auto____1.call(this,state_18012);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__2741__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__2741__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_18053 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_18053[(6)] = c__2763__auto__);

return statearr_18053;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__4253__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"empty","empty",767870958),id);
}
})())){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_(remove_preds)))){
var G__18082_18092 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__18083_18093 = null;
(object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18082_18092,G__18083_18093) : object_cache.call(null,G__18082_18092,G__18083_18093));

var G__18084 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__18085 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__18086 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__18087 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18086,G__18087) : object_cache.call(null,G__18086,G__18087));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18084,G__18085) : object_cache.call(null,G__18084,G__18085));
} else {
var G__18088 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__18089 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__18090 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__18091 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18090,G__18091) : object_cache.call(null,G__18090,G__18091));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18088,G__18089) : object_cache.call(null,G__18088,G__18089));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_18114){
var state_val_18115 = (state_18114[(1)]);
if((state_val_18115 === (7))){
var inst_18103 = (state_18114[(7)]);
var inst_18105 = fluree.db.storage.core.serde(conn);
var inst_18106 = fluree.db.serde.protocol._deserialize_branch(inst_18105,inst_18103);
var state_18114__$1 = state_18114;
var statearr_18116_18135 = state_18114__$1;
(statearr_18116_18135[(2)] = inst_18106);

(statearr_18116_18135[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18115 === (1))){
var state_18114__$1 = state_18114;
var statearr_18117_18136 = state_18114__$1;
(statearr_18117_18136[(2)] = null);

(statearr_18117_18136[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18115 === (4))){
var inst_18094 = (state_18114[(2)]);
var state_18114__$1 = state_18114;
var statearr_18118_18137 = state_18114__$1;
(statearr_18118_18137[(2)] = inst_18094);

(statearr_18118_18137[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18115 === (6))){
var inst_18103 = (state_18114[(7)]);
var inst_18102 = (state_18114[(2)]);
var inst_18103__$1 = fluree.db.util.async.throw_err(inst_18102);
var state_18114__$1 = (function (){var statearr_18119 = state_18114;
(statearr_18119[(7)] = inst_18103__$1);

return statearr_18119;
})();
if(cljs.core.truth_(inst_18103__$1)){
var statearr_18120_18138 = state_18114__$1;
(statearr_18120_18138[(1)] = (7));

} else {
var statearr_18121_18139 = state_18114__$1;
(statearr_18121_18139[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18115 === (3))){
var inst_18112 = (state_18114[(2)]);
var state_18114__$1 = state_18114;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18114__$1,inst_18112);
} else {
if((state_val_18115 === (2))){
var _ = (function (){var statearr_18123 = state_18114;
(statearr_18123[(4)] = cljs.core.cons((5),(state_18114[(4)])));

return statearr_18123;
})();
var inst_18100 = fluree.db.storage.core.storage_read(conn,key);
var state_18114__$1 = state_18114;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18114__$1,(6),inst_18100);
} else {
if((state_val_18115 === (9))){
var inst_18109 = (state_18114[(2)]);
var _ = (function (){var statearr_18124 = state_18114;
(statearr_18124[(4)] = cljs.core.rest((state_18114[(4)])));

return statearr_18124;
})();
var state_18114__$1 = state_18114;
var statearr_18125_18140 = state_18114__$1;
(statearr_18125_18140[(2)] = inst_18109);

(statearr_18125_18140[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18115 === (5))){
var _ = (function (){var statearr_18126 = state_18114;
(statearr_18126[(4)] = cljs.core.rest((state_18114[(4)])));

return statearr_18126;
})();
var state_18114__$1 = state_18114;
var ex18122 = (state_18114__$1[(2)]);
var statearr_18127_18141 = state_18114__$1;
(statearr_18127_18141[(5)] = ex18122);


if((ex18122 instanceof Error)){
var statearr_18128_18142 = state_18114__$1;
(statearr_18128_18142[(1)] = (4));

(statearr_18128_18142[(5)] = null);

} else {
throw ex18122;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18115 === (8))){
var state_18114__$1 = state_18114;
var statearr_18129_18143 = state_18114__$1;
(statearr_18129_18143[(2)] = null);

(statearr_18129_18143[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__2741__auto____0 = (function (){
var statearr_18130 = [null,null,null,null,null,null,null,null];
(statearr_18130[(0)] = fluree$db$storage$core$read_branch_$_state_machine__2741__auto__);

(statearr_18130[(1)] = (1));

return statearr_18130;
});
var fluree$db$storage$core$read_branch_$_state_machine__2741__auto____1 = (function (state_18114){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_18114);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e18131){var ex__2744__auto__ = e18131;
var statearr_18132_18144 = state_18114;
(statearr_18132_18144[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_18114[(4)]))){
var statearr_18133_18145 = state_18114;
(statearr_18133_18145[(1)] = cljs.core.first((state_18114[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18146 = state_18114;
state_18114 = G__18146;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__2741__auto__ = function(state_18114){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__2741__auto____1.call(this,state_18114);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__2741__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__2741__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_18134 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_18134[(6)] = c__2763__auto__);

return statearr_18134;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2763__auto___18225 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_18197){
var state_val_18198 = (state_18197[(1)]);
if((state_val_18198 === (7))){
var inst_18164 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_18165 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18166 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_18167 = cljs.core.PersistentHashMap.fromArrays(inst_18165,inst_18166);
var inst_18168 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_18164,inst_18167);
var inst_18169 = (function(){throw inst_18168})();
var state_18197__$1 = state_18197;
var statearr_18199_18226 = state_18197__$1;
(statearr_18199_18226[(2)] = inst_18169);

(statearr_18199_18226[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18198 === (1))){
var state_18197__$1 = state_18197;
var statearr_18200_18227 = state_18197__$1;
(statearr_18200_18227[(2)] = null);

(statearr_18200_18227[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18198 === (4))){
var inst_18147 = (state_18197[(2)]);
var inst_18148 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_18149 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_18147);
var inst_18150 = cljs.core.async.close_BANG_(return_ch);
var state_18197__$1 = (function (){var statearr_18201 = state_18197;
(statearr_18201[(7)] = inst_18148);

(statearr_18201[(8)] = inst_18149);

return statearr_18201;
})();
var statearr_18202_18228 = state_18197__$1;
(statearr_18202_18228[(2)] = inst_18150);

(statearr_18202_18228[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18198 === (6))){
var inst_18161 = (state_18197[(9)]);
var inst_18160 = (state_18197[(2)]);
var inst_18161__$1 = fluree.db.util.async.throw_err(inst_18160);
var inst_18162 = (inst_18161__$1 == null);
var state_18197__$1 = (function (){var statearr_18203 = state_18197;
(statearr_18203[(9)] = inst_18161__$1);

return statearr_18203;
})();
if(cljs.core.truth_(inst_18162)){
var statearr_18204_18229 = state_18197__$1;
(statearr_18204_18229[(1)] = (7));

} else {
var statearr_18205_18230 = state_18197__$1;
(statearr_18205_18230[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18198 === (3))){
var inst_18195 = (state_18197[(2)]);
var state_18197__$1 = state_18197;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18197__$1,inst_18195);
} else {
if((state_val_18198 === (12))){
var inst_18161 = (state_18197[(9)]);
var inst_18178 = (state_18197[(2)]);
var inst_18179 = cljs.core.__destructure_map(inst_18161);
var inst_18180 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18179,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_18181 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18179,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var inst_18182 = config;
var inst_18183 = cljs.core.__destructure_map(inst_18182);
var inst_18184 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18183,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_18186 = (function (){var data = inst_18161;
var _ = inst_18178;
var map__18156 = inst_18179;
var children = inst_18180;
var rhs = inst_18181;
var map__18157 = inst_18183;
var comparator = inst_18184;
return (function (idx,p__18185){
var map__18206 = p__18185;
var map__18206__$1 = cljs.core.__destructure_map(map__18206);
var child = map__18206__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18206__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18206__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18206__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18206__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18206__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var at_leftmost_QMARK_ = (function (){var and__4251__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return (idx === (0));
} else {
return and__4251__auto__;
}
})();
return (fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14 ? fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14(conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid) : fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid));
});
})();
var inst_18187 = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(inst_18186,inst_18180);
var inst_18188 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"first","first",-644103046),inst_18187);
var inst_18189 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(inst_18188,inst_18187);
var inst_18190 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(clojure.data.avl.sorted_map_by,inst_18184,inst_18189);
var inst_18191 = fluree.db.index.__GT_IndexNode(block,t,inst_18181,inst_18190,config,leftmost_QMARK_);
var inst_18192 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_18191);
var _ = (function (){var statearr_18207 = state_18197;
(statearr_18207[(4)] = cljs.core.rest((state_18197[(4)])));

return statearr_18207;
})();
var state_18197__$1 = state_18197;
var statearr_18208_18231 = state_18197__$1;
(statearr_18208_18231[(2)] = inst_18192);

(statearr_18208_18231[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18198 === (2))){
var _ = (function (){var statearr_18209 = state_18197;
(statearr_18209[(4)] = cljs.core.cons((5),(state_18197[(4)])));

return statearr_18209;
})();
var inst_18158 = fluree.db.storage.core.read_branch(conn,key);
var state_18197__$1 = state_18197;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18197__$1,(6),inst_18158);
} else {
if((state_val_18198 === (11))){
var state_18197__$1 = state_18197;
var statearr_18211_18232 = state_18197__$1;
(statearr_18211_18232[(2)] = null);

(statearr_18211_18232[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18198 === (9))){
var inst_18161 = (state_18197[(9)]);
var inst_18172 = (state_18197[(2)]);
var inst_18173 = fluree.db.util.core.exception_QMARK_(inst_18161);
var state_18197__$1 = (function (){var statearr_18212 = state_18197;
(statearr_18212[(10)] = inst_18172);

return statearr_18212;
})();
if(inst_18173){
var statearr_18213_18233 = state_18197__$1;
(statearr_18213_18233[(1)] = (10));

} else {
var statearr_18214_18234 = state_18197__$1;
(statearr_18214_18234[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18198 === (5))){
var _ = (function (){var statearr_18215 = state_18197;
(statearr_18215[(4)] = cljs.core.rest((state_18197[(4)])));

return statearr_18215;
})();
var state_18197__$1 = state_18197;
var ex18210 = (state_18197__$1[(2)]);
var statearr_18216_18235 = state_18197__$1;
(statearr_18216_18235[(5)] = ex18210);


var statearr_18217_18236 = state_18197__$1;
(statearr_18217_18236[(1)] = (4));

(statearr_18217_18236[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18198 === (10))){
var inst_18161 = (state_18197[(9)]);
var inst_18175 = (function(){throw inst_18161})();
var state_18197__$1 = state_18197;
var statearr_18218_18237 = state_18197__$1;
(statearr_18218_18237[(2)] = inst_18175);

(statearr_18218_18237[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18198 === (8))){
var state_18197__$1 = state_18197;
var statearr_18219_18238 = state_18197__$1;
(statearr_18219_18238[(2)] = null);

(statearr_18219_18238[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__2741__auto____0 = (function (){
var statearr_18220 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18220[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__2741__auto__);

(statearr_18220[(1)] = (1));

return statearr_18220;
});
var fluree$db$storage$core$reify_branch_$_state_machine__2741__auto____1 = (function (state_18197){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_18197);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e18221){var ex__2744__auto__ = e18221;
var statearr_18222_18239 = state_18197;
(statearr_18222_18239[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_18197[(4)]))){
var statearr_18223_18240 = state_18197;
(statearr_18223_18240[(1)] = cljs.core.first((state_18197[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18241 = state_18197;
state_18197 = G__18241;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__2741__auto__ = function(state_18197){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__2741__auto____1.call(this,state_18197);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__2741__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__2741__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_18224 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_18224[(6)] = c__2763__auto___18225);

return statearr_18224;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_18262){
var state_val_18263 = (state_18262[(1)]);
if((state_val_18263 === (7))){
var state_18262__$1 = state_18262;
var statearr_18264_18284 = state_18262__$1;
(statearr_18264_18284[(2)] = null);

(statearr_18264_18284[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18263 === (1))){
var state_18262__$1 = state_18262;
var statearr_18265_18285 = state_18262__$1;
(statearr_18265_18285[(2)] = null);

(statearr_18265_18285[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18263 === (4))){
var inst_18242 = (state_18262[(2)]);
var state_18262__$1 = state_18262;
var statearr_18266_18286 = state_18262__$1;
(statearr_18266_18286[(2)] = inst_18242);

(statearr_18266_18286[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18263 === (6))){
var inst_18248 = (state_18262[(7)]);
var inst_18250 = fluree.db.storage.core.serde(conn);
var state_18262__$1 = (function (){var statearr_18267 = state_18262;
(statearr_18267[(8)] = inst_18250);

return statearr_18267;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18262__$1,(9),inst_18248);
} else {
if((state_val_18263 === (3))){
var inst_18260 = (state_18262[(2)]);
var state_18262__$1 = state_18262;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18262__$1,inst_18260);
} else {
if((state_val_18263 === (2))){
var inst_18248 = (state_18262[(7)]);
var _ = (function (){var statearr_18269 = state_18262;
(statearr_18269[(4)] = cljs.core.cons((5),(state_18262[(4)])));

return statearr_18269;
})();
var inst_18248__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_18262__$1 = (function (){var statearr_18270 = state_18262;
(statearr_18270[(7)] = inst_18248__$1);

return statearr_18270;
})();
if(cljs.core.truth_(inst_18248__$1)){
var statearr_18271_18287 = state_18262__$1;
(statearr_18271_18287[(1)] = (6));

} else {
var statearr_18272_18288 = state_18262__$1;
(statearr_18272_18288[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18263 === (9))){
var inst_18250 = (state_18262[(8)]);
var inst_18252 = (state_18262[(2)]);
var inst_18253 = fluree.db.util.async.throw_err(inst_18252);
var inst_18254 = fluree.db.serde.protocol._deserialize_leaf(inst_18250,inst_18253);
var state_18262__$1 = state_18262;
var statearr_18273_18289 = state_18262__$1;
(statearr_18273_18289[(2)] = inst_18254);

(statearr_18273_18289[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18263 === (5))){
var _ = (function (){var statearr_18274 = state_18262;
(statearr_18274[(4)] = cljs.core.rest((state_18262[(4)])));

return statearr_18274;
})();
var state_18262__$1 = state_18262;
var ex18268 = (state_18262__$1[(2)]);
var statearr_18275_18290 = state_18262__$1;
(statearr_18275_18290[(5)] = ex18268);


if((ex18268 instanceof Error)){
var statearr_18276_18291 = state_18262__$1;
(statearr_18276_18291[(1)] = (4));

(statearr_18276_18291[(5)] = null);

} else {
throw ex18268;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18263 === (8))){
var inst_18257 = (state_18262[(2)]);
var _ = (function (){var statearr_18277 = state_18262;
(statearr_18277[(4)] = cljs.core.rest((state_18262[(4)])));

return statearr_18277;
})();
var state_18262__$1 = state_18262;
var statearr_18278_18292 = state_18262__$1;
(statearr_18278_18292[(2)] = inst_18257);

(statearr_18278_18292[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__2741__auto____0 = (function (){
var statearr_18279 = [null,null,null,null,null,null,null,null,null];
(statearr_18279[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__2741__auto__);

(statearr_18279[(1)] = (1));

return statearr_18279;
});
var fluree$db$storage$core$read_leaf_$_state_machine__2741__auto____1 = (function (state_18262){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_18262);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e18280){var ex__2744__auto__ = e18280;
var statearr_18281_18293 = state_18262;
(statearr_18281_18293[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_18262[(4)]))){
var statearr_18282_18294 = state_18262;
(statearr_18282_18294[(1)] = cljs.core.first((state_18262[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18295 = state_18262;
state_18262 = G__18295;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__2741__auto__ = function(state_18262){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__2741__auto____1.call(this,state_18262);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__2741__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__2741__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_18283 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_18283[(6)] = c__2763__auto__);

return statearr_18283;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([config], 0))].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2763__auto___18368 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_18340){
var state_val_18341 = (state_18340[(1)]);
if((state_val_18341 === (7))){
var inst_18312 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_18313 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18314 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_18315 = cljs.core.PersistentHashMap.fromArrays(inst_18313,inst_18314);
var inst_18316 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_18312,inst_18315);
var inst_18317 = (function(){throw inst_18316})();
var state_18340__$1 = state_18340;
var statearr_18342_18369 = state_18340__$1;
(statearr_18342_18369[(2)] = inst_18317);

(statearr_18342_18369[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18341 === (1))){
var state_18340__$1 = state_18340;
var statearr_18343_18370 = state_18340__$1;
(statearr_18343_18370[(2)] = null);

(statearr_18343_18370[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18341 === (4))){
var inst_18296 = (state_18340[(2)]);
var inst_18297 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_18298 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_18296);
var inst_18299 = cljs.core.async.close_BANG_(return_ch);
var state_18340__$1 = (function (){var statearr_18344 = state_18340;
(statearr_18344[(7)] = inst_18298);

(statearr_18344[(8)] = inst_18297);

return statearr_18344;
})();
var statearr_18345_18371 = state_18340__$1;
(statearr_18345_18371[(2)] = inst_18299);

(statearr_18345_18371[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18341 === (6))){
var inst_18309 = (state_18340[(9)]);
var inst_18309__$1 = (state_18340[(2)]);
var inst_18310 = (inst_18309__$1 == null);
var state_18340__$1 = (function (){var statearr_18346 = state_18340;
(statearr_18346[(9)] = inst_18309__$1);

return statearr_18346;
})();
if(cljs.core.truth_(inst_18310)){
var statearr_18347_18372 = state_18340__$1;
(statearr_18347_18372[(1)] = (7));

} else {
var statearr_18348_18373 = state_18340__$1;
(statearr_18348_18373[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18341 === (3))){
var inst_18338 = (state_18340[(2)]);
var state_18340__$1 = state_18340;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18340__$1,inst_18338);
} else {
if((state_val_18341 === (12))){
var inst_18309 = (state_18340[(9)]);
var inst_18326 = (state_18340[(2)]);
var inst_18327 = cljs.core.__destructure_map(inst_18309);
var inst_18328 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18327,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_18329 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18327,new cljs.core.Keyword(null,"his","his",-1294347076));
var inst_18330 = config;
var inst_18331 = cljs.core.__destructure_map(inst_18330);
var inst_18332 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18331,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_18333 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,inst_18332,inst_18328);
var inst_18334 = fluree.db.index.data_node(block,t,inst_18333,rhs,config);
var inst_18335 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_18334);
var _ = (function (){var statearr_18349 = state_18340;
(statearr_18349[(4)] = cljs.core.rest((state_18340[(4)])));

return statearr_18349;
})();
var state_18340__$1 = (function (){var statearr_18350 = state_18340;
(statearr_18350[(10)] = inst_18326);

(statearr_18350[(11)] = inst_18329);

return statearr_18350;
})();
var statearr_18351_18374 = state_18340__$1;
(statearr_18351_18374[(2)] = inst_18335);

(statearr_18351_18374[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18341 === (2))){
var _ = (function (){var statearr_18352 = state_18340;
(statearr_18352[(4)] = cljs.core.cons((5),(state_18340[(4)])));

return statearr_18352;
})();
var inst_18307 = fluree.db.storage.core.read_leaf(conn,key);
var state_18340__$1 = state_18340;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18340__$1,(6),inst_18307);
} else {
if((state_val_18341 === (11))){
var state_18340__$1 = state_18340;
var statearr_18354_18375 = state_18340__$1;
(statearr_18354_18375[(2)] = null);

(statearr_18354_18375[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18341 === (9))){
var inst_18309 = (state_18340[(9)]);
var inst_18320 = (state_18340[(2)]);
var inst_18321 = fluree.db.util.core.exception_QMARK_(inst_18309);
var state_18340__$1 = (function (){var statearr_18355 = state_18340;
(statearr_18355[(12)] = inst_18320);

return statearr_18355;
})();
if(inst_18321){
var statearr_18356_18376 = state_18340__$1;
(statearr_18356_18376[(1)] = (10));

} else {
var statearr_18357_18377 = state_18340__$1;
(statearr_18357_18377[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18341 === (5))){
var _ = (function (){var statearr_18358 = state_18340;
(statearr_18358[(4)] = cljs.core.rest((state_18340[(4)])));

return statearr_18358;
})();
var state_18340__$1 = state_18340;
var ex18353 = (state_18340__$1[(2)]);
var statearr_18359_18378 = state_18340__$1;
(statearr_18359_18378[(5)] = ex18353);


var statearr_18360_18379 = state_18340__$1;
(statearr_18360_18379[(1)] = (4));

(statearr_18360_18379[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18341 === (10))){
var inst_18309 = (state_18340[(9)]);
var inst_18323 = (function(){throw inst_18309})();
var state_18340__$1 = state_18340;
var statearr_18361_18380 = state_18340__$1;
(statearr_18361_18380[(2)] = inst_18323);

(statearr_18361_18380[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18341 === (8))){
var state_18340__$1 = state_18340;
var statearr_18362_18381 = state_18340__$1;
(statearr_18362_18381[(2)] = null);

(statearr_18362_18381[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__2741__auto____0 = (function (){
var statearr_18363 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18363[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__2741__auto__);

(statearr_18363[(1)] = (1));

return statearr_18363;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__2741__auto____1 = (function (state_18340){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_18340);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e18364){var ex__2744__auto__ = e18364;
var statearr_18365_18382 = state_18340;
(statearr_18365_18382[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_18340[(4)]))){
var statearr_18366_18383 = state_18340;
(statearr_18366_18383[(1)] = cljs.core.first((state_18340[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18384 = state_18340;
state_18340 = G__18384;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__2741__auto__ = function(state_18340){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__2741__auto____1.call(this,state_18340);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__2741__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__2741__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_18367 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_18367[(6)] = c__2763__auto___18368);

return statearr_18367;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k18386,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__18390 = k18386;
var G__18390__$1 = (((G__18390 instanceof cljs.core.Keyword))?G__18390.fqn:null);
switch (G__18390__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k18386,else__4505__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4525__auto__,p__18391){
var vec__18392 = p__18391;
var k__4526__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18392,(0),null);
var v__4527__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18392,(1),null);
return (f__4523__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4523__auto__.cljs$core$IFn$_invoke$arity$3(ret__4525__auto__,k__4526__auto__,v__4527__auto__) : f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__));
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer(writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer(writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__4519__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"first","first",-644103046),self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"size","size",1098693007),self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__18385){
var self__ = this;
var G__18385__$1 = this;
return (new cljs.core.RecordIter((0),G__18385__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"empty","empty",767870958),self__.id)){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,fluree.db.index.data_node((0),(0),fluree.db.flake.sorted_set_by(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var G__18395 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__18396 = (function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf(self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
var G__18397 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__18398 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18397,G__18398) : object_cache.call(null,G__18397,G__18398));
}));
} else {
return fluree.db.storage.core.reify_branch(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
var G__18399 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__18400 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18399,G__18400) : object_cache.call(null,G__18399,G__18400));
}));
}
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18395,G__18396) : object_cache.call(null,G__18395,G__18396));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(history_id,null) : object_cache.call(null,history_id,null));
});
var G__18401 = history_id;
var G__18402 = (function (___$2){
return fluree.db.storage.core.reify_history(self__.conn,history_id,error_fn);
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18401,G__18402) : object_cache.call(null,G__18401,G__18402));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (14 + cljs.core.count(self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (){var fexpr__18403 = (function (coll__4499__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll(coll__4499__auto__));
});
return fexpr__18403(this__4498__auto____$1);
})();
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this18387,other18388){
var self__ = this;
var this18387__$1 = this;
return (((!((other18388 == null)))) && ((((this18387__$1.constructor === other18388.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18387__$1.conn,other18388.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18387__$1.config,other18388.config)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18387__$1.network,other18388.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18387__$1.dbid,other18388.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18387__$1.id,other18388.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18387__$1.leaf,other18388.leaf)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18387__$1.first,other18388.first)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18387__$1.rhs,other18388.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18387__$1.size,other18388.size)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18387__$1.block,other18388.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18387__$1.t,other18388.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18387__$1.tt_id,other18388.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18387__$1.leftmost_QMARK_,other18388.leftmost_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18387__$1.tempid,other18388.tempid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18387__$1.__extmap,other18388.__extmap)))))))))))))))))))))))))))))))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"first","first",-644103046),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k18386){
var self__ = this;
var this__4509__auto____$1 = this;
var G__18404 = k18386;
var G__18404__$1 = (((G__18404 instanceof cljs.core.Keyword))?G__18404.fqn:null);
switch (G__18404__$1) {
case "conn":
case "config":
case "network":
case "dbid":
case "id":
case "leaf":
case "first":
case "rhs":
case "size":
case "block":
case "t":
case "tt-id":
case "leftmost?":
case "tempid":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k18386);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__18385){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__18405 = cljs.core.keyword_identical_QMARK_;
var expr__18406 = k__4511__auto__;
if(cljs.core.truth_((function (){var G__18408 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__18409 = expr__18406;
return (pred__18405.cljs$core$IFn$_invoke$arity$2 ? pred__18405.cljs$core$IFn$_invoke$arity$2(G__18408,G__18409) : pred__18405.call(null,G__18408,G__18409));
})())){
return (new fluree.db.storage.core.UnresolvedNode(G__18385,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18410 = new cljs.core.Keyword(null,"config","config",994861415);
var G__18411 = expr__18406;
return (pred__18405.cljs$core$IFn$_invoke$arity$2 ? pred__18405.cljs$core$IFn$_invoke$arity$2(G__18410,G__18411) : pred__18405.call(null,G__18410,G__18411));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__18385,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18412 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__18413 = expr__18406;
return (pred__18405.cljs$core$IFn$_invoke$arity$2 ? pred__18405.cljs$core$IFn$_invoke$arity$2(G__18412,G__18413) : pred__18405.call(null,G__18412,G__18413));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__18385,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18414 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__18415 = expr__18406;
return (pred__18405.cljs$core$IFn$_invoke$arity$2 ? pred__18405.cljs$core$IFn$_invoke$arity$2(G__18414,G__18415) : pred__18405.call(null,G__18414,G__18415));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__18385,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18416 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__18417 = expr__18406;
return (pred__18405.cljs$core$IFn$_invoke$arity$2 ? pred__18405.cljs$core$IFn$_invoke$arity$2(G__18416,G__18417) : pred__18405.call(null,G__18416,G__18417));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__18385,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18418 = new cljs.core.Keyword(null,"leaf","leaf",1306118732);
var G__18419 = expr__18406;
return (pred__18405.cljs$core$IFn$_invoke$arity$2 ? pred__18405.cljs$core$IFn$_invoke$arity$2(G__18418,G__18419) : pred__18405.call(null,G__18418,G__18419));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__18385,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18420 = new cljs.core.Keyword(null,"first","first",-644103046);
var G__18421 = expr__18406;
return (pred__18405.cljs$core$IFn$_invoke$arity$2 ? pred__18405.cljs$core$IFn$_invoke$arity$2(G__18420,G__18421) : pred__18405.call(null,G__18420,G__18421));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__18385,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18422 = new cljs.core.Keyword(null,"rhs","rhs",-229356739);
var G__18423 = expr__18406;
return (pred__18405.cljs$core$IFn$_invoke$arity$2 ? pred__18405.cljs$core$IFn$_invoke$arity$2(G__18422,G__18423) : pred__18405.call(null,G__18422,G__18423));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__18385,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18424 = new cljs.core.Keyword(null,"size","size",1098693007);
var G__18425 = expr__18406;
return (pred__18405.cljs$core$IFn$_invoke$arity$2 ? pred__18405.cljs$core$IFn$_invoke$arity$2(G__18424,G__18425) : pred__18405.call(null,G__18424,G__18425));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__18385,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18426 = new cljs.core.Keyword(null,"block","block",664686210);
var G__18427 = expr__18406;
return (pred__18405.cljs$core$IFn$_invoke$arity$2 ? pred__18405.cljs$core$IFn$_invoke$arity$2(G__18426,G__18427) : pred__18405.call(null,G__18426,G__18427));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__18385,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18428 = new cljs.core.Keyword(null,"t","t",-1397832519);
var G__18429 = expr__18406;
return (pred__18405.cljs$core$IFn$_invoke$arity$2 ? pred__18405.cljs$core$IFn$_invoke$arity$2(G__18428,G__18429) : pred__18405.call(null,G__18428,G__18429));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__18385,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18430 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484);
var G__18431 = expr__18406;
return (pred__18405.cljs$core$IFn$_invoke$arity$2 ? pred__18405.cljs$core$IFn$_invoke$arity$2(G__18430,G__18431) : pred__18405.call(null,G__18430,G__18431));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__18385,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18432 = new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559);
var G__18433 = expr__18406;
return (pred__18405.cljs$core$IFn$_invoke$arity$2 ? pred__18405.cljs$core$IFn$_invoke$arity$2(G__18432,G__18433) : pred__18405.call(null,G__18432,G__18433));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__18385,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18434 = new cljs.core.Keyword(null,"tempid","tempid",1427663222);
var G__18435 = expr__18406;
return (pred__18405.cljs$core$IFn$_invoke$arity$2 ? pred__18405.cljs$core$IFn$_invoke$arity$2(G__18434,G__18435) : pred__18405.call(null,G__18434,G__18435));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__18385,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4511__auto__,G__18385),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"first","first",-644103046),self__.first,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"size","size",1098693007),self__.size,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__18385){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__18385,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"config","config",-1659574354,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"leaf","leaf",-1348317037,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"leftmost?","leftmost?",-31657032,null),new cljs.core.Symbol(null,"tempid","tempid",-1226772547,null)], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write(writer__4547__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__18389){
var extmap__4542__auto__ = (function (){var G__18436 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__18389,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], 0));
if(cljs.core.record_QMARK_(G__18389)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__18436);
} else {
return G__18436;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__18389),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__18389),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__18389),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__18389),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__18389),new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(G__18389),new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(G__18389),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__18389),new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(G__18389),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__18389),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__18389),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__18389),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(G__18389),new cljs.core.Keyword(null,"tempid","tempid",1427663222).cljs$core$IFn$_invoke$arity$1(G__18389),null,cljs.core.not_empty(extmap__4542__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,index);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Internal error reifying db root index: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([index], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(index_data,new cljs.core.Keyword(null,"conn","conn",278309663),conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"config","config",994861415),cfg,new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true], 0)));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__18439 = blank_db;
var map__18439__$1 = cljs.core.__destructure_map(map__18439);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18439__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18439__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var index_configs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18439__$1,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280));
var map__18440 = root_data;
var map__18440__$1 = cljs.core.__destructure_map(map__18440);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18440__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18440__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18440__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18440__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block)], 0));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (db,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,idx,fluree.db.storage.core.reify_index_root(conn,index_configs,network,dbid,idx,cljs.core.get.cljs$core$IFn$_invoke$arity$2(root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_18462){
var state_val_18463 = (state_18462[(1)]);
if((state_val_18463 === (7))){
var state_18462__$1 = state_18462;
var statearr_18464_18484 = state_18462__$1;
(statearr_18464_18484[(2)] = null);

(statearr_18464_18484[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18463 === (1))){
var state_18462__$1 = state_18462;
var statearr_18465_18485 = state_18462__$1;
(statearr_18465_18485[(2)] = null);

(statearr_18465_18485[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18463 === (4))){
var inst_18441 = (state_18462[(2)]);
var state_18462__$1 = state_18462;
var statearr_18466_18486 = state_18462__$1;
(statearr_18466_18486[(2)] = inst_18441);

(statearr_18466_18486[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18463 === (6))){
var inst_18448 = (state_18462[(7)]);
var inst_18450 = fluree.db.storage.core.serde(conn);
var state_18462__$1 = (function (){var statearr_18467 = state_18462;
(statearr_18467[(8)] = inst_18450);

return statearr_18467;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18462__$1,(9),inst_18448);
} else {
if((state_val_18463 === (3))){
var inst_18460 = (state_18462[(2)]);
var state_18462__$1 = state_18462;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18462__$1,inst_18460);
} else {
if((state_val_18463 === (2))){
var inst_18448 = (state_18462[(7)]);
var _ = (function (){var statearr_18469 = state_18462;
(statearr_18469[(4)] = cljs.core.cons((5),(state_18462[(4)])));

return statearr_18469;
})();
var inst_18447 = fluree.db.storage.core.ledger_garbage_key(network,dbid,block);
var inst_18448__$1 = fluree.db.storage.core.storage_read(conn,inst_18447);
var state_18462__$1 = (function (){var statearr_18470 = state_18462;
(statearr_18470[(7)] = inst_18448__$1);

return statearr_18470;
})();
if(cljs.core.truth_(inst_18448__$1)){
var statearr_18471_18487 = state_18462__$1;
(statearr_18471_18487[(1)] = (6));

} else {
var statearr_18472_18488 = state_18462__$1;
(statearr_18472_18488[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18463 === (9))){
var inst_18450 = (state_18462[(8)]);
var inst_18452 = (state_18462[(2)]);
var inst_18453 = fluree.db.util.async.throw_err(inst_18452);
var inst_18454 = fluree.db.serde.protocol._deserialize_garbage(inst_18450,inst_18453);
var state_18462__$1 = state_18462;
var statearr_18473_18489 = state_18462__$1;
(statearr_18473_18489[(2)] = inst_18454);

(statearr_18473_18489[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18463 === (5))){
var _ = (function (){var statearr_18474 = state_18462;
(statearr_18474[(4)] = cljs.core.rest((state_18462[(4)])));

return statearr_18474;
})();
var state_18462__$1 = state_18462;
var ex18468 = (state_18462__$1[(2)]);
var statearr_18475_18490 = state_18462__$1;
(statearr_18475_18490[(5)] = ex18468);


if((ex18468 instanceof Error)){
var statearr_18476_18491 = state_18462__$1;
(statearr_18476_18491[(1)] = (4));

(statearr_18476_18491[(5)] = null);

} else {
throw ex18468;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18463 === (8))){
var inst_18457 = (state_18462[(2)]);
var _ = (function (){var statearr_18477 = state_18462;
(statearr_18477[(4)] = cljs.core.rest((state_18462[(4)])));

return statearr_18477;
})();
var state_18462__$1 = state_18462;
var statearr_18478_18492 = state_18462__$1;
(statearr_18478_18492[(2)] = inst_18457);

(statearr_18478_18492[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__2741__auto____0 = (function (){
var statearr_18479 = [null,null,null,null,null,null,null,null,null];
(statearr_18479[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__2741__auto__);

(statearr_18479[(1)] = (1));

return statearr_18479;
});
var fluree$db$storage$core$read_garbage_$_state_machine__2741__auto____1 = (function (state_18462){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_18462);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e18480){var ex__2744__auto__ = e18480;
var statearr_18481_18493 = state_18462;
(statearr_18481_18493[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_18462[(4)]))){
var statearr_18482_18494 = state_18462;
(statearr_18482_18494[(1)] = cljs.core.first((state_18462[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18495 = state_18462;
state_18462 = G__18495;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__2741__auto__ = function(state_18462){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__2741__auto____1.call(this,state_18462);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__2741__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__2741__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_18483 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_18483[(6)] = c__2763__auto__);

return statearr_18483;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_18517){
var state_val_18518 = (state_18517[(1)]);
if((state_val_18518 === (7))){
var inst_18506 = (state_18517[(7)]);
var inst_18508 = fluree.db.storage.core.serde(conn);
var inst_18509 = fluree.db.serde.protocol._deserialize_db_root(inst_18508,inst_18506);
var state_18517__$1 = state_18517;
var statearr_18519_18538 = state_18517__$1;
(statearr_18519_18538[(2)] = inst_18509);

(statearr_18519_18538[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (1))){
var state_18517__$1 = state_18517;
var statearr_18520_18539 = state_18517__$1;
(statearr_18520_18539[(2)] = null);

(statearr_18520_18539[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (4))){
var inst_18496 = (state_18517[(2)]);
var state_18517__$1 = state_18517;
var statearr_18521_18540 = state_18517__$1;
(statearr_18521_18540[(2)] = inst_18496);

(statearr_18521_18540[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (6))){
var inst_18506 = (state_18517[(7)]);
var inst_18505 = (state_18517[(2)]);
var inst_18506__$1 = fluree.db.util.async.throw_err(inst_18505);
var state_18517__$1 = (function (){var statearr_18522 = state_18517;
(statearr_18522[(7)] = inst_18506__$1);

return statearr_18522;
})();
if(cljs.core.truth_(inst_18506__$1)){
var statearr_18523_18541 = state_18517__$1;
(statearr_18523_18541[(1)] = (7));

} else {
var statearr_18524_18542 = state_18517__$1;
(statearr_18524_18542[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (3))){
var inst_18515 = (state_18517[(2)]);
var state_18517__$1 = state_18517;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18517__$1,inst_18515);
} else {
if((state_val_18518 === (2))){
var _ = (function (){var statearr_18526 = state_18517;
(statearr_18526[(4)] = cljs.core.cons((5),(state_18517[(4)])));

return statearr_18526;
})();
var inst_18502 = fluree.db.storage.core.ledger_root_key(network,dbid,block);
var inst_18503 = fluree.db.storage.core.storage_read(conn,inst_18502);
var state_18517__$1 = state_18517;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18517__$1,(6),inst_18503);
} else {
if((state_val_18518 === (9))){
var inst_18512 = (state_18517[(2)]);
var _ = (function (){var statearr_18527 = state_18517;
(statearr_18527[(4)] = cljs.core.rest((state_18517[(4)])));

return statearr_18527;
})();
var state_18517__$1 = state_18517;
var statearr_18528_18543 = state_18517__$1;
(statearr_18528_18543[(2)] = inst_18512);

(statearr_18528_18543[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (5))){
var _ = (function (){var statearr_18529 = state_18517;
(statearr_18529[(4)] = cljs.core.rest((state_18517[(4)])));

return statearr_18529;
})();
var state_18517__$1 = state_18517;
var ex18525 = (state_18517__$1[(2)]);
var statearr_18530_18544 = state_18517__$1;
(statearr_18530_18544[(5)] = ex18525);


if((ex18525 instanceof Error)){
var statearr_18531_18545 = state_18517__$1;
(statearr_18531_18545[(1)] = (4));

(statearr_18531_18545[(5)] = null);

} else {
throw ex18525;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18518 === (8))){
var state_18517__$1 = state_18517;
var statearr_18532_18546 = state_18517__$1;
(statearr_18532_18546[(2)] = null);

(statearr_18532_18546[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__2741__auto____0 = (function (){
var statearr_18533 = [null,null,null,null,null,null,null,null];
(statearr_18533[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__2741__auto__);

(statearr_18533[(1)] = (1));

return statearr_18533;
});
var fluree$db$storage$core$read_db_root_$_state_machine__2741__auto____1 = (function (state_18517){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_18517);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e18534){var ex__2744__auto__ = e18534;
var statearr_18535_18547 = state_18517;
(statearr_18535_18547[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_18517[(4)]))){
var statearr_18536_18548 = state_18517;
(statearr_18536_18548[(1)] = cljs.core.first((state_18517[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18549 = state_18517;
state_18517 = G__18549;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__2741__auto__ = function(state_18517){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__2741__auto____1.call(this,state_18517);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__2741__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__2741__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_18537 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_18537[(6)] = c__2763__auto__);

return statearr_18537;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_18585){
var state_val_18586 = (state_18585[(1)]);
if((state_val_18586 === (7))){
var inst_18559 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_18560 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18561 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_18562 = cljs.core.PersistentHashMap.fromArrays(inst_18560,inst_18561);
var inst_18563 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_18559,inst_18562);
var inst_18564 = (function(){throw inst_18563})();
var state_18585__$1 = state_18585;
var statearr_18587_18609 = state_18585__$1;
(statearr_18587_18609[(2)] = inst_18564);

(statearr_18587_18609[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (1))){
var state_18585__$1 = state_18585;
var statearr_18588_18610 = state_18585__$1;
(statearr_18588_18610[(2)] = null);

(statearr_18588_18610[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (4))){
var inst_18550 = (state_18585[(2)]);
var state_18585__$1 = state_18585;
var statearr_18589_18611 = state_18585__$1;
(statearr_18589_18611[(2)] = inst_18550);

(statearr_18589_18611[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (6))){
var state_18585__$1 = state_18585;
var statearr_18590_18612 = state_18585__$1;
(statearr_18590_18612[(2)] = null);

(statearr_18590_18612[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (3))){
var inst_18583 = (state_18585[(2)]);
var state_18585__$1 = state_18585;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18585__$1,inst_18583);
} else {
if((state_val_18586 === (2))){
var inst_18556 = (state_18585[(7)]);
var _ = (function (){var statearr_18591 = state_18585;
(statearr_18591[(4)] = cljs.core.cons((5),(state_18585[(4)])));

return statearr_18591;
})();
var inst_18556__$1 = fluree.db.storage.core.read_db_root(conn,network,dbid,index);
var state_18585__$1 = (function (){var statearr_18592 = state_18585;
(statearr_18592[(7)] = inst_18556__$1);

return statearr_18592;
})();
if(cljs.core.truth_(inst_18556__$1)){
var statearr_18593_18613 = state_18585__$1;
(statearr_18593_18613[(1)] = (6));

} else {
var statearr_18594_18614 = state_18585__$1;
(statearr_18594_18614[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (11))){
var inst_18575 = (state_18585[(8)]);
var inst_18578 = (state_18585[(2)]);
var inst_18579 = fluree.db.util.async.throw_err(inst_18578);
var inst_18580 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_18575,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_18579);
var _ = (function (){var statearr_18596 = state_18585;
(statearr_18596[(4)] = cljs.core.rest((state_18585[(4)])));

return statearr_18596;
})();
var state_18585__$1 = state_18585;
var statearr_18597_18615 = state_18585__$1;
(statearr_18597_18615[(2)] = inst_18580);

(statearr_18597_18615[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (9))){
var inst_18570 = (state_18585[(9)]);
var inst_18568 = (state_18585[(2)]);
var inst_18569 = fluree.db.util.async.throw_err(inst_18568);
var inst_18570__$1 = fluree.db.storage.core.reify_db_root(conn,blank_db,inst_18569);
var inst_18571 = fluree.db.query.schema.schema_map(inst_18570__$1);
var state_18585__$1 = (function (){var statearr_18598 = state_18585;
(statearr_18598[(9)] = inst_18570__$1);

return statearr_18598;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18585__$1,(10),inst_18571);
} else {
if((state_val_18586 === (5))){
var _ = (function (){var statearr_18599 = state_18585;
(statearr_18599[(4)] = cljs.core.rest((state_18585[(4)])));

return statearr_18599;
})();
var state_18585__$1 = state_18585;
var ex18595 = (state_18585__$1[(2)]);
var statearr_18600_18616 = state_18585__$1;
(statearr_18600_18616[(5)] = ex18595);


if((ex18595 instanceof Error)){
var statearr_18601_18617 = state_18585__$1;
(statearr_18601_18617[(1)] = (4));

(statearr_18601_18617[(5)] = null);

} else {
throw ex18595;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (10))){
var inst_18570 = (state_18585[(9)]);
var inst_18575 = (state_18585[(8)]);
var inst_18573 = (state_18585[(2)]);
var inst_18574 = fluree.db.util.async.throw_err(inst_18573);
var inst_18575__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_18570,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_18574);
var inst_18576 = fluree.db.query.schema.setting_map(inst_18575__$1);
var state_18585__$1 = (function (){var statearr_18602 = state_18585;
(statearr_18602[(8)] = inst_18575__$1);

return statearr_18602;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18585__$1,(11),inst_18576);
} else {
if((state_val_18586 === (8))){
var inst_18556 = (state_18585[(7)]);
var inst_18566 = (state_18585[(2)]);
var state_18585__$1 = (function (){var statearr_18603 = state_18585;
(statearr_18603[(10)] = inst_18566);

return statearr_18603;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18585__$1,(9),inst_18556);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__2741__auto____0 = (function (){
var statearr_18604 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18604[(0)] = fluree$db$storage$core$reify_db_$_state_machine__2741__auto__);

(statearr_18604[(1)] = (1));

return statearr_18604;
});
var fluree$db$storage$core$reify_db_$_state_machine__2741__auto____1 = (function (state_18585){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_18585);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e18605){var ex__2744__auto__ = e18605;
var statearr_18606_18618 = state_18585;
(statearr_18606_18618[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_18585[(4)]))){
var statearr_18607_18619 = state_18585;
(statearr_18607_18619[(1)] = cljs.core.first((state_18585[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18620 = state_18585;
state_18585 = G__18620;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__2741__auto__ = function(state_18585){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__2741__auto____1.call(this,state_18585);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__2741__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__2741__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_18608 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_18608[(6)] = c__2763__auto__);

return statearr_18608;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__18622 = arguments.length;
switch (G__18622) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Block-range request: ",network,dbid,start,end], 0));

var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_18675){
var state_val_18676 = (state_18675[(1)]);
if((state_val_18676 === (7))){
var inst_18632 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_18633 = (new Error(inst_18632));
var inst_18634 = (function(){throw inst_18633})();
var state_18675__$1 = state_18675;
var statearr_18677_18717 = state_18675__$1;
(statearr_18677_18717[(2)] = inst_18634);

(statearr_18677_18717[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (20))){
var inst_18666 = (state_18675[(2)]);
var state_18675__$1 = state_18675;
var statearr_18678_18718 = state_18675__$1;
(statearr_18678_18718[(2)] = inst_18666);

(statearr_18678_18718[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (1))){
var state_18675__$1 = state_18675;
var statearr_18679_18719 = state_18675__$1;
(statearr_18679_18719[(2)] = null);

(statearr_18679_18719[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (4))){
var inst_18623 = (state_18675[(2)]);
var state_18675__$1 = state_18675;
var statearr_18680_18720 = state_18675__$1;
(statearr_18680_18720[(2)] = inst_18623);

(statearr_18680_18720[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (15))){
var inst_18641 = (state_18675[(7)]);
var state_18675__$1 = state_18675;
var statearr_18681_18721 = state_18675__$1;
(statearr_18681_18721[(2)] = inst_18641);

(statearr_18681_18721[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (21))){
var inst_18641 = (state_18675[(7)]);
var inst_18640 = (state_18675[(8)]);
var inst_18645 = (state_18675[(9)]);
var inst_18659 = (inst_18640 + (1));
var inst_18660 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_18641,inst_18645);
var inst_18640__$1 = inst_18659;
var inst_18641__$1 = inst_18660;
var state_18675__$1 = (function (){var statearr_18682 = state_18675;
(statearr_18682[(7)] = inst_18641__$1);

(statearr_18682[(8)] = inst_18640__$1);

return statearr_18682;
})();
var statearr_18683_18722 = state_18675__$1;
(statearr_18683_18722[(2)] = null);

(statearr_18683_18722[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (13))){
var inst_18645 = (state_18675[(9)]);
var inst_18649 = (inst_18645 instanceof Error);
var state_18675__$1 = state_18675;
var statearr_18684_18723 = state_18675__$1;
(statearr_18684_18723[(2)] = inst_18649);

(statearr_18684_18723[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (22))){
var state_18675__$1 = state_18675;
var statearr_18685_18724 = state_18675__$1;
(statearr_18685_18724[(2)] = null);

(statearr_18685_18724[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (6))){
var state_18675__$1 = state_18675;
var statearr_18686_18725 = state_18675__$1;
(statearr_18686_18725[(2)] = null);

(statearr_18686_18725[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (17))){
var inst_18668 = (state_18675[(2)]);
var state_18675__$1 = state_18675;
var statearr_18687_18726 = state_18675__$1;
(statearr_18687_18726[(2)] = inst_18668);

(statearr_18687_18726[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (3))){
var inst_18673 = (state_18675[(2)]);
var state_18675__$1 = state_18675;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18675__$1,inst_18673);
} else {
if((state_val_18676 === (12))){
var inst_18646 = (state_18675[(10)]);
var state_18675__$1 = state_18675;
var statearr_18688_18727 = state_18675__$1;
(statearr_18688_18727[(2)] = inst_18646);

(statearr_18688_18727[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (2))){
var _ = (function (){var statearr_18689 = state_18675;
(statearr_18689[(4)] = cljs.core.cons((5),(state_18675[(4)])));

return statearr_18689;
})();
var inst_18629 = (end >= start);
var state_18675__$1 = state_18675;
if(cljs.core.truth_(inst_18629)){
var statearr_18690_18728 = state_18675__$1;
(statearr_18690_18728[(1)] = (6));

} else {
var statearr_18691_18729 = state_18675__$1;
(statearr_18691_18729[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (23))){
var inst_18664 = (state_18675[(2)]);
var state_18675__$1 = state_18675;
var statearr_18692_18730 = state_18675__$1;
(statearr_18692_18730[(2)] = inst_18664);

(statearr_18692_18730[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (19))){
var state_18675__$1 = state_18675;
var statearr_18693_18731 = state_18675__$1;
(statearr_18693_18731[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (11))){
var inst_18646 = (state_18675[(10)]);
var inst_18645 = (state_18675[(9)]);
var inst_18645__$1 = (state_18675[(2)]);
var inst_18646__$1 = (inst_18645__$1 == null);
var state_18675__$1 = (function (){var statearr_18696 = state_18675;
(statearr_18696[(10)] = inst_18646__$1);

(statearr_18696[(9)] = inst_18645__$1);

return statearr_18696;
})();
if(cljs.core.truth_(inst_18646__$1)){
var statearr_18697_18732 = state_18675__$1;
(statearr_18697_18732[(1)] = (12));

} else {
var statearr_18698_18733 = state_18675__$1;
(statearr_18698_18733[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (9))){
var inst_18640 = (state_18675[(8)]);
var inst_18643 = fluree.db.storage.core.read_block(conn,network,dbid,inst_18640);
var state_18675__$1 = state_18675;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18675__$1,(11),inst_18643);
} else {
if((state_val_18676 === (5))){
var _ = (function (){var statearr_18699 = state_18675;
(statearr_18699[(4)] = cljs.core.rest((state_18675[(4)])));

return statearr_18699;
})();
var state_18675__$1 = state_18675;
var ex18695 = (state_18675__$1[(2)]);
var statearr_18700_18734 = state_18675__$1;
(statearr_18700_18734[(5)] = ex18695);


if((ex18695 instanceof Error)){
var statearr_18701_18735 = state_18675__$1;
(statearr_18701_18735[(1)] = (4));

(statearr_18701_18735[(5)] = null);

} else {
throw ex18695;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (14))){
var inst_18651 = (state_18675[(2)]);
var state_18675__$1 = state_18675;
if(cljs.core.truth_(inst_18651)){
var statearr_18702_18736 = state_18675__$1;
(statearr_18702_18736[(1)] = (15));

} else {
var statearr_18703_18737 = state_18675__$1;
(statearr_18703_18737[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (16))){
var inst_18640 = (state_18675[(8)]);
var inst_18654 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_18640,end);
var state_18675__$1 = state_18675;
if(inst_18654){
var statearr_18704_18738 = state_18675__$1;
(statearr_18704_18738[(1)] = (18));

} else {
var statearr_18705_18739 = state_18675__$1;
(statearr_18705_18739[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (10))){
var inst_18670 = (state_18675[(2)]);
var _ = (function (){var statearr_18706 = state_18675;
(statearr_18706[(4)] = cljs.core.rest((state_18675[(4)])));

return statearr_18706;
})();
var state_18675__$1 = state_18675;
var statearr_18707_18740 = state_18675__$1;
(statearr_18707_18740[(2)] = inst_18670);

(statearr_18707_18740[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (18))){
var inst_18641 = (state_18675[(7)]);
var inst_18645 = (state_18675[(9)]);
var inst_18656 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_18641,inst_18645);
var state_18675__$1 = state_18675;
var statearr_18708_18741 = state_18675__$1;
(statearr_18708_18741[(2)] = inst_18656);

(statearr_18708_18741[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18676 === (8))){
var inst_18636 = (state_18675[(2)]);
var inst_18637 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(conn);
var inst_18638 = start;
var inst_18639 = cljs.core.PersistentVector.EMPTY;
var inst_18640 = inst_18638;
var inst_18641 = inst_18639;
var state_18675__$1 = (function (){var statearr_18709 = state_18675;
(statearr_18709[(7)] = inst_18641);

(statearr_18709[(11)] = inst_18637);

(statearr_18709[(8)] = inst_18640);

(statearr_18709[(12)] = inst_18636);

return statearr_18709;
})();
var statearr_18710_18742 = state_18675__$1;
(statearr_18710_18742[(2)] = null);

(statearr_18710_18742[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2741__auto__ = null;
var fluree$db$storage$core$state_machine__2741__auto____0 = (function (){
var statearr_18711 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18711[(0)] = fluree$db$storage$core$state_machine__2741__auto__);

(statearr_18711[(1)] = (1));

return statearr_18711;
});
var fluree$db$storage$core$state_machine__2741__auto____1 = (function (state_18675){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_18675);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e18712){var ex__2744__auto__ = e18712;
var statearr_18713_18743 = state_18675;
(statearr_18713_18743[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_18675[(4)]))){
var statearr_18714_18744 = state_18675;
(statearr_18714_18744[(1)] = cljs.core.first((state_18675[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18745 = state_18675;
state_18675 = G__18745;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2741__auto__ = function(state_18675){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2741__auto____1.call(this,state_18675);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2741__auto____0;
fluree$db$storage$core$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2741__auto____1;
return fluree$db$storage$core$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_18715 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_18715[(6)] = c__2763__auto__);

return statearr_18715;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_18761){
var state_val_18762 = (state_18761[(1)]);
if((state_val_18762 === (1))){
var state_18761__$1 = state_18761;
var statearr_18763_18777 = state_18761__$1;
(statearr_18763_18777[(2)] = null);

(statearr_18763_18777[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18762 === (2))){
var _ = (function (){var statearr_18764 = state_18761;
(statearr_18764[(4)] = cljs.core.cons((5),(state_18761[(4)])));

return statearr_18764;
})();
var inst_18752 = fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,block,block);
var state_18761__$1 = state_18761;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18761__$1,(6),inst_18752);
} else {
if((state_val_18762 === (3))){
var inst_18759 = (state_18761[(2)]);
var state_18761__$1 = state_18761;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18761__$1,inst_18759);
} else {
if((state_val_18762 === (4))){
var inst_18746 = (state_18761[(2)]);
var state_18761__$1 = state_18761;
var statearr_18766_18778 = state_18761__$1;
(statearr_18766_18778[(2)] = inst_18746);

(statearr_18766_18778[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18762 === (5))){
var _ = (function (){var statearr_18767 = state_18761;
(statearr_18767[(4)] = cljs.core.rest((state_18761[(4)])));

return statearr_18767;
})();
var state_18761__$1 = state_18761;
var ex18765 = (state_18761__$1[(2)]);
var statearr_18768_18779 = state_18761__$1;
(statearr_18768_18779[(5)] = ex18765);


if((ex18765 instanceof Error)){
var statearr_18769_18780 = state_18761__$1;
(statearr_18769_18780[(1)] = (4));

(statearr_18769_18780[(5)] = null);

} else {
throw ex18765;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18762 === (6))){
var inst_18754 = (state_18761[(2)]);
var inst_18755 = fluree.db.util.async.throw_err(inst_18754);
var inst_18756 = cljs.core.first(inst_18755);
var _ = (function (){var statearr_18770 = state_18761;
(statearr_18770[(4)] = cljs.core.rest((state_18761[(4)])));

return statearr_18770;
})();
var state_18761__$1 = state_18761;
var statearr_18771_18781 = state_18761__$1;
(statearr_18771_18781[(2)] = inst_18756);

(statearr_18771_18781[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__2741__auto____0 = (function (){
var statearr_18772 = [null,null,null,null,null,null,null];
(statearr_18772[(0)] = fluree$db$storage$core$block_$_state_machine__2741__auto__);

(statearr_18772[(1)] = (1));

return statearr_18772;
});
var fluree$db$storage$core$block_$_state_machine__2741__auto____1 = (function (state_18761){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_18761);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e18773){var ex__2744__auto__ = e18773;
var statearr_18774_18782 = state_18761;
(statearr_18774_18782[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_18761[(4)]))){
var statearr_18775_18783 = state_18761;
(statearr_18775_18783[(1)] = cljs.core.first((state_18761[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18784 = state_18761;
state_18761 = G__18784;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__2741__auto__ = function(state_18761){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__2741__auto____1.call(this,state_18761);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__2741__auto____0;
fluree$db$storage$core$block_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__2741__auto____1;
return fluree$db$storage$core$block_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_18776 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_18776[(6)] = c__2763__auto__);

return statearr_18776;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
