// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.flake');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28767 = arguments.length;
var i__4865__auto___28768 = (0);
while(true){
if((i__4865__auto___28768 < len__4864__auto___28767)){
args__4870__auto__.push((arguments[i__4865__auto___28768]));

var G__28769 = (i__4865__auto___28768 + (1));
i__4865__auto___28768 = G__28769;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0))], 0));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var e_SINGLEQUOTE_ = e;
var msg = e_SINGLEQUOTE_.getMessage();
var err_msg = (((msg == null))?e_SINGLEQUOTE_.getClass():msg);
var args_SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args);
return ["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(err_msg),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(args_SINGLEQUOTE_)].join('');
})(),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq28764){
var G__28765 = cljs.core.first(seq28764);
var seq28764__$1 = cljs.core.next(seq28764);
var G__28766 = cljs.core.first(seq28764__$1);
var seq28764__$2 = cljs.core.next(seq28764__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28765,G__28766,seq28764__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e28770){var e = e28770;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e28771){var e = e28771;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e28772){var e = e28772;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e28773){var e = e28773;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e28774){var e = e28774;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28777 = arguments.length;
var i__4865__auto___28778 = (0);
while(true){
if((i__4865__auto___28778 < len__4864__auto___28777)){
args__4870__auto__.push((arguments[i__4865__auto___28778]));

var G__28779 = (i__4865__auto___28778 + (1));
i__4865__auto___28778 = G__28779;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e28776){var e = e28776;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq28775){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28775));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28782 = arguments.length;
var i__4865__auto___28783 = (0);
while(true){
if((i__4865__auto___28783 < len__4864__auto___28782)){
args__4870__auto__.push((arguments[i__4865__auto___28783]));

var G__28784 = (i__4865__auto___28783 + (1));
i__4865__auto___28783 = G__28784;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e28781){var e = e28781;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq28780){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28780));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e28785){var e = e28785;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28788 = arguments.length;
var i__4865__auto___28789 = (0);
while(true){
if((i__4865__auto___28789 < len__4864__auto___28788)){
args__4870__auto__.push((arguments[i__4865__auto___28789]));

var G__28790 = (i__4865__auto___28789 + (1));
i__4865__auto___28789 = G__28790;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e28787){var e = e28787;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq28786){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28786));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28793 = arguments.length;
var i__4865__auto___28794 = (0);
while(true){
if((i__4865__auto___28794 < len__4864__auto___28793)){
args__4870__auto__.push((arguments[i__4865__auto___28794]));

var G__28795 = (i__4865__auto___28794 + (1));
i__4865__auto___28794 = G__28795;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e28792){var e = e28792;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq28791){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28791));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e28796){var e = e28796;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e28797){var e = e28797;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28800 = arguments.length;
var i__4865__auto___28801 = (0);
while(true){
if((i__4865__auto___28801 < len__4864__auto___28800)){
args__4870__auto__.push((arguments[i__4865__auto___28801]));

var G__28802 = (i__4865__auto___28801 + (1));
i__4865__auto___28801 = G__28802;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e28799){var e = e28799;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq28798){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28798));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28805 = arguments.length;
var i__4865__auto___28806 = (0);
while(true){
if((i__4865__auto___28806 < len__4864__auto___28805)){
args__4870__auto__.push((arguments[i__4865__auto___28806]));

var G__28807 = (i__4865__auto___28806 + (1));
i__4865__auto___28806 = G__28807;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e28804){var e = e28804;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq28803){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28803));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28810 = arguments.length;
var i__4865__auto___28811 = (0);
while(true){
if((i__4865__auto___28811 < len__4864__auto___28810)){
args__4870__auto__.push((arguments[i__4865__auto___28811]));

var G__28812 = (i__4865__auto___28811 + (1));
i__4865__auto___28811 = G__28812;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e28809){var e = e28809;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq28808){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28808));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28815 = arguments.length;
var i__4865__auto___28816 = (0);
while(true){
if((i__4865__auto___28816 < len__4864__auto___28815)){
args__4870__auto__.push((arguments[i__4865__auto___28816]));

var G__28817 = (i__4865__auto___28816 + (1));
i__4865__auto___28816 = G__28817;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e28814){var e = e28814;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq28813){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28813));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28820 = arguments.length;
var i__4865__auto___28821 = (0);
while(true){
if((i__4865__auto___28821 < len__4864__auto___28820)){
args__4870__auto__.push((arguments[i__4865__auto___28821]));

var G__28822 = (i__4865__auto___28821 + (1));
i__4865__auto___28821 = G__28822;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e28819){var e = e28819;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq28818){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28818));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28825 = arguments.length;
var i__4865__auto___28826 = (0);
while(true){
if((i__4865__auto___28826 < len__4864__auto___28825)){
args__4870__auto__.push((arguments[i__4865__auto___28826]));

var G__28827 = (i__4865__auto___28826 + (1));
i__4865__auto___28826 = G__28827;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e28824){var e = e28824;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq28823){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28823));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28830 = arguments.length;
var i__4865__auto___28831 = (0);
while(true){
if((i__4865__auto___28831 < len__4864__auto___28830)){
args__4870__auto__.push((arguments[i__4865__auto___28831]));

var G__28832 = (i__4865__auto___28831 + (1));
i__4865__auto___28831 = G__28832;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e28829){var e = e28829;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq28828){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28828));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__28834 = arguments.length;
switch (G__28834) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_28862){
var state_val_28863 = (state_28862[(1)]);
if((state_val_28863 === (7))){
var inst_28847 = (state_28862[(7)]);
var inst_28850 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28847,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_28862__$1 = state_28862;
var statearr_28864_28950 = state_28862__$1;
(statearr_28864_28950[(2)] = inst_28850);

(statearr_28864_28950[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28863 === (1))){
var state_28862__$1 = state_28862;
var statearr_28865_28951 = state_28862__$1;
(statearr_28865_28951[(2)] = null);

(statearr_28865_28951[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28863 === (4))){
var inst_28835 = (state_28862[(2)]);
var state_28862__$1 = state_28862;
var statearr_28866_28952 = state_28862__$1;
(statearr_28866_28952[(2)] = inst_28835);

(statearr_28866_28952[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28863 === (6))){
var inst_28847 = (state_28862[(7)]);
var inst_28847__$1 = (state_28862[(2)]);
var inst_28848 = fluree.db.util.core.exception_QMARK_(inst_28847__$1);
var state_28862__$1 = (function (){var statearr_28867 = state_28862;
(statearr_28867[(7)] = inst_28847__$1);

return statearr_28867;
})();
if(inst_28848){
var statearr_28868_28953 = state_28862__$1;
(statearr_28868_28953[(1)] = (7));

} else {
var statearr_28869_28954 = state_28862__$1;
(statearr_28869_28954[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28863 === (3))){
var inst_28860 = (state_28862[(2)]);
var state_28862__$1 = state_28862;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28862__$1,inst_28860);
} else {
if((state_val_28863 === (2))){
var inst_28841 = (state_28862[(8)]);
var _ = (function (){var statearr_28871 = state_28862;
(statearr_28871[(4)] = cljs.core.cons((5),(state_28862[(4)])));

return statearr_28871;
})();
var inst_28841__$1 = cljs.core.volatile_BANG_((0));
var inst_28842 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_28843 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_28842,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_28841__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000)], 0));
var inst_28844 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_28843);
var inst_28845 = fluree.db.query.fql.query(db,inst_28844);
var state_28862__$1 = (function (){var statearr_28872 = state_28862;
(statearr_28872[(8)] = inst_28841__$1);

return statearr_28872;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28862__$1,(6),inst_28845);
} else {
if((state_val_28863 === (9))){
var inst_28857 = (state_28862[(2)]);
var _ = (function (){var statearr_28873 = state_28862;
(statearr_28873[(4)] = cljs.core.rest((state_28862[(4)])));

return statearr_28873;
})();
var state_28862__$1 = state_28862;
var statearr_28874_28955 = state_28862__$1;
(statearr_28874_28955[(2)] = inst_28857);

(statearr_28874_28955[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28863 === (5))){
var _ = (function (){var statearr_28875 = state_28862;
(statearr_28875[(4)] = cljs.core.rest((state_28862[(4)])));

return statearr_28875;
})();
var state_28862__$1 = state_28862;
var ex28870 = (state_28862__$1[(2)]);
var statearr_28876_28956 = state_28862__$1;
(statearr_28876_28956[(5)] = ex28870);


if((ex28870 instanceof Error)){
var statearr_28877_28957 = state_28862__$1;
(statearr_28877_28957[(1)] = (4));

(statearr_28877_28957[(5)] = null);

} else {
throw ex28870;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28863 === (8))){
var inst_28841 = (state_28862[(8)]);
var inst_28847 = (state_28862[(7)]);
var inst_28852 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28853 = cljs.core.deref(inst_28841);
var inst_28854 = [inst_28847,inst_28853];
var inst_28855 = (new cljs.core.PersistentVector(null,2,(5),inst_28852,inst_28854,null));
var state_28862__$1 = state_28862;
var statearr_28878_28958 = state_28862__$1;
(statearr_28878_28958[(2)] = inst_28855);

(statearr_28878_28958[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2741__auto____0 = (function (){
var statearr_28879 = [null,null,null,null,null,null,null,null,null];
(statearr_28879[(0)] = fluree$db$dbfunctions$internal$state_machine__2741__auto__);

(statearr_28879[(1)] = (1));

return statearr_28879;
});
var fluree$db$dbfunctions$internal$state_machine__2741__auto____1 = (function (state_28862){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_28862);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e28880){var ex__2744__auto__ = e28880;
var statearr_28881_28959 = state_28862;
(statearr_28881_28959[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_28862[(4)]))){
var statearr_28882_28960 = state_28862;
(statearr_28882_28960[(1)] = cljs.core.first((state_28862[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28961 = state_28862;
state_28862 = G__28961;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2741__auto__ = function(state_28862){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2741__auto____1.call(this,state_28862);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2741__auto____0;
fluree$db$dbfunctions$internal$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2741__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_28883 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_28883[(6)] = c__2763__auto__);

return statearr_28883;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_28928){
var state_val_28929 = (state_28928[(1)]);
if((state_val_28929 === (7))){
var inst_28914 = (state_28928[(2)]);
var inst_28915 = fluree.db.query.fql.query(db,inst_28914);
var state_28928__$1 = state_28928;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28928__$1,(8),inst_28915);
} else {
if((state_val_28929 === (1))){
var inst_28884 = typeof select === 'string';
var state_28928__$1 = state_28928;
if(cljs.core.truth_(inst_28884)){
var statearr_28930_28962 = state_28928__$1;
(statearr_28930_28962[(1)] = (2));

} else {
var statearr_28931_28963 = state_28928__$1;
(statearr_28931_28963[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28929 === (4))){
var inst_28890 = (state_28928[(7)]);
var inst_28897 = (state_28928[(8)]);
var inst_28889 = (state_28928[(2)]);
var inst_28890__$1 = cljs.core.volatile_BANG_((0));
var inst_28891 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28892 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_28893 = [inst_28890__$1,(100000)];
var inst_28894 = cljs.core.PersistentHashMap.fromArrays(inst_28892,inst_28893);
var inst_28895 = [inst_28889,from,where,block,limit,inst_28894];
var inst_28896 = cljs.core.PersistentHashMap.fromArrays(inst_28891,inst_28895);
var inst_28897__$1 = fluree.db.util.core.without_nils(inst_28896);
var inst_28898 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28897__$1);
var inst_28899 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28897__$1);
var inst_28900 = cljs.core.first(inst_28899);
var inst_28901 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28900], 0));
var inst_28902 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_28901);
var inst_28903 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28897__$1);
var inst_28904 = cljs.core.last(inst_28903);
var inst_28905 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28904], 0));
var inst_28906 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_28905);
var inst_28907 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28898,inst_28902,inst_28906], 0));
var state_28928__$1 = (function (){var statearr_28932 = state_28928;
(statearr_28932[(7)] = inst_28890__$1);

(statearr_28932[(8)] = inst_28897__$1);

return statearr_28932;
})();
if(cljs.core.truth_(inst_28907)){
var statearr_28933_28964 = state_28928__$1;
(statearr_28933_28964[(1)] = (5));

} else {
var statearr_28934_28965 = state_28928__$1;
(statearr_28934_28965[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28929 === (6))){
var inst_28897 = (state_28928[(8)]);
var state_28928__$1 = state_28928;
var statearr_28935_28966 = state_28928__$1;
(statearr_28935_28966[(2)] = inst_28897);

(statearr_28935_28966[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28929 === (3))){
var state_28928__$1 = state_28928;
var statearr_28936_28967 = state_28928__$1;
(statearr_28936_28967[(2)] = select);

(statearr_28936_28967[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28929 === (2))){
var inst_28886 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_28928__$1 = state_28928;
var statearr_28937_28968 = state_28928__$1;
(statearr_28937_28968[(2)] = inst_28886);

(statearr_28937_28968[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28929 === (11))){
var inst_28926 = (state_28928[(2)]);
var state_28928__$1 = state_28928;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28928__$1,inst_28926);
} else {
if((state_val_28929 === (9))){
var inst_28917 = (state_28928[(9)]);
var state_28928__$1 = state_28928;
var statearr_28938_28969 = state_28928__$1;
(statearr_28938_28969[(2)] = inst_28917);

(statearr_28938_28969[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28929 === (5))){
var inst_28897 = (state_28928[(8)]);
var inst_28909 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28897);
var inst_28910 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_28909);
var inst_28911 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_28897,new cljs.core.Keyword(null,"where","where",-2044795965),inst_28910);
var state_28928__$1 = state_28928;
var statearr_28939_28970 = state_28928__$1;
(statearr_28939_28970[(2)] = inst_28911);

(statearr_28939_28970[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28929 === (10))){
var inst_28890 = (state_28928[(7)]);
var inst_28917 = (state_28928[(9)]);
var inst_28921 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28922 = cljs.core.deref(inst_28890);
var inst_28923 = [inst_28917,inst_28922];
var inst_28924 = (new cljs.core.PersistentVector(null,2,(5),inst_28921,inst_28923,null));
var state_28928__$1 = state_28928;
var statearr_28940_28971 = state_28928__$1;
(statearr_28940_28971[(2)] = inst_28924);

(statearr_28940_28971[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28929 === (8))){
var inst_28917 = (state_28928[(9)]);
var inst_28917__$1 = (state_28928[(2)]);
var inst_28918 = fluree.db.util.core.exception_QMARK_(inst_28917__$1);
var state_28928__$1 = (function (){var statearr_28941 = state_28928;
(statearr_28941[(9)] = inst_28917__$1);

return statearr_28941;
})();
if(inst_28918){
var statearr_28942_28972 = state_28928__$1;
(statearr_28942_28972[(1)] = (9));

} else {
var statearr_28943_28973 = state_28928__$1;
(statearr_28943_28973[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2741__auto____0 = (function (){
var statearr_28944 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28944[(0)] = fluree$db$dbfunctions$internal$state_machine__2741__auto__);

(statearr_28944[(1)] = (1));

return statearr_28944;
});
var fluree$db$dbfunctions$internal$state_machine__2741__auto____1 = (function (state_28928){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_28928);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e28945){var ex__2744__auto__ = e28945;
var statearr_28946_28974 = state_28928;
(statearr_28946_28974[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_28928[(4)]))){
var statearr_28947_28975 = state_28928;
(statearr_28947_28975[(1)] = cljs.core.first((state_28928[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28976 = state_28928;
state_28928 = G__28976;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2741__auto__ = function(state_28928){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2741__auto____1.call(this,state_28928);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2741__auto____0;
fluree$db$dbfunctions$internal$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2741__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_28948 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_28948[(6)] = c__2763__auto__);

return statearr_28948;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__28980 = path;
var vec__28981 = G__28980;
var seq__28982 = cljs.core.seq(vec__28981);
var first__28983 = cljs.core.first(seq__28982);
var seq__28982__$1 = cljs.core.next(seq__28982);
var var$ = first__28983;
var r = seq__28982__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__28980__$1 = G__28980;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__28987 = G__28980__$1;
var seq__28988 = cljs.core.seq(vec__28987);
var first__28989 = cljs.core.first(seq__28988);
var seq__28988__$1 = cljs.core.next(seq__28988);
var var$__$1 = first__28989;
var r__$1 = seq__28988__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__28990 = r__$1;
var G__28991 = n__$2;
var G__28992 = next_clauses;
G__28980__$1 = G__28990;
n__$1 = G__28991;
where_clauses__$1 = G__28992;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__28993 = r__$1;
var G__28994 = next_n;
var G__28995 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__28980__$1 = G__28993;
n__$1 = G__28994;
where_clauses__$1 = G__28995;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_29032){
var state_val_29033 = (state_29032[(1)]);
if((state_val_29033 === (7))){
var inst_29005 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29006 = [path];
var inst_29007 = (new cljs.core.PersistentVector(null,1,(5),inst_29005,inst_29006,null));
var state_29032__$1 = state_29032;
var statearr_29034_29062 = state_29032__$1;
(statearr_29034_29062[(2)] = inst_29007);

(statearr_29034_29062[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29033 === (1))){
var state_29032__$1 = state_29032;
var statearr_29035_29063 = state_29032__$1;
(statearr_29035_29063[(2)] = null);

(statearr_29035_29063[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29033 === (4))){
var inst_28996 = (state_29032[(2)]);
var state_29032__$1 = state_29032;
var statearr_29036_29064 = state_29032__$1;
(statearr_29036_29064[(2)] = inst_28996);

(statearr_29036_29064[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29033 === (13))){
var inst_29023 = (state_29032[(2)]);
var inst_29024 = fluree.db.util.async.throw_err(inst_29023);
var _ = (function (){var statearr_29037 = state_29032;
(statearr_29037[(4)] = cljs.core.rest((state_29032[(4)])));

return statearr_29037;
})();
var state_29032__$1 = state_29032;
var statearr_29038_29065 = state_29032__$1;
(statearr_29038_29065[(2)] = inst_29024);

(statearr_29038_29065[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29033 === (6))){
var state_29032__$1 = state_29032;
var statearr_29040_29066 = state_29032__$1;
(statearr_29040_29066[(2)] = path);

(statearr_29040_29066[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29033 === (3))){
var inst_29030 = (state_29032[(2)]);
var state_29032__$1 = state_29032;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29032__$1,inst_29030);
} else {
if((state_val_29033 === (12))){
var _ = (function (){var statearr_29041 = state_29032;
(statearr_29041[(4)] = cljs.core.rest((state_29032[(4)])));

return statearr_29041;
})();
var state_29032__$1 = state_29032;
var ex29039 = (state_29032__$1[(2)]);
var statearr_29042_29067 = state_29032__$1;
(statearr_29042_29067[(5)] = ex29039);


var statearr_29043_29068 = state_29032__$1;
(statearr_29043_29068[(1)] = (11));

(statearr_29043_29068[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29033 === (2))){
var _ = (function (){var statearr_29044 = state_29032;
(statearr_29044[(4)] = cljs.core.cons((5),(state_29032[(4)])));

return statearr_29044;
})();
var inst_29002 = cljs.core.vector_QMARK_(path);
var state_29032__$1 = state_29032;
if(inst_29002){
var statearr_29045_29069 = state_29032__$1;
(statearr_29045_29069[(1)] = (6));

} else {
var statearr_29046_29070 = state_29032__$1;
(statearr_29046_29070[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29033 === (11))){
var inst_29009 = (state_29032[(7)]);
var inst_29014 = (state_29032[(2)]);
var inst_29015 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29014,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_29009,endSubject], 0));
var state_29032__$1 = state_29032;
var statearr_29048_29071 = state_29032__$1;
(statearr_29048_29071[(2)] = inst_29015);

(statearr_29048_29071[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29033 === (9))){
var inst_29013 = (state_29032[(8)]);
var _ = (function (){var statearr_29049 = state_29032;
(statearr_29049[(4)] = cljs.core.cons((12),(state_29032[(4)])));

return statearr_29049;
})();
var inst_29021 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_29013);
var state_29032__$1 = state_29032;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29032__$1,(13),inst_29021);
} else {
if((state_val_29033 === (5))){
var _ = (function (){var statearr_29050 = state_29032;
(statearr_29050[(4)] = cljs.core.rest((state_29032[(4)])));

return statearr_29050;
})();
var state_29032__$1 = state_29032;
var ex29047 = (state_29032__$1[(2)]);
var statearr_29051_29072 = state_29032__$1;
(statearr_29051_29072[(5)] = ex29047);


if((ex29047 instanceof Error)){
var statearr_29052_29073 = state_29032__$1;
(statearr_29052_29073[(1)] = (4));

(statearr_29052_29073[(5)] = null);

} else {
throw ex29047;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29033 === (10))){
var inst_29027 = (state_29032[(2)]);
var _ = (function (){var statearr_29053 = state_29032;
(statearr_29053[(4)] = cljs.core.rest((state_29032[(4)])));

return statearr_29053;
})();
var state_29032__$1 = state_29032;
var statearr_29054_29074 = state_29032__$1;
(statearr_29054_29074[(2)] = inst_29027);

(statearr_29054_29074[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29033 === (8))){
var inst_29009 = (state_29032[(7)]);
var inst_29009__$1 = (state_29032[(2)]);
var inst_29010 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_29009__$1,endSubject);
var inst_29011 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_29012 = ["?var1",inst_29010];
var inst_29013 = cljs.core.PersistentHashMap.fromArrays(inst_29011,inst_29012);
var state_29032__$1 = (function (){var statearr_29055 = state_29032;
(statearr_29055[(7)] = inst_29009__$1);

(statearr_29055[(8)] = inst_29013);

return statearr_29055;
})();
var statearr_29056_29075 = state_29032__$1;
(statearr_29056_29075[(2)] = null);

(statearr_29056_29075[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2741__auto____0 = (function (){
var statearr_29057 = [null,null,null,null,null,null,null,null,null];
(statearr_29057[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2741__auto__);

(statearr_29057[(1)] = (1));

return statearr_29057;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2741__auto____1 = (function (state_29032){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_29032);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e29058){var ex__2744__auto__ = e29058;
var statearr_29059_29076 = state_29032;
(statearr_29059_29076[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_29032[(4)]))){
var statearr_29060_29077 = state_29032;
(statearr_29060_29077[(1)] = cljs.core.first((state_29032[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29078 = state_29032;
state_29032 = G__29078;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2741__auto__ = function(state_29032){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2741__auto____1.call(this,state_29032);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2741__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_29061 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_29061[(6)] = c__2763__auto__);

return statearr_29061;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e29079){var e = e29079;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e29080){var e = e29080;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e29081){var e = e29081;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e29082){var e = e29082;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___29085 = arguments.length;
var i__4865__auto___29086 = (0);
while(true){
if((i__4865__auto___29086 < len__4864__auto___29085)){
args__4870__auto__.push((arguments[i__4865__auto___29086]));

var G__29087 = (i__4865__auto___29086 + (1));
i__4865__auto___29086 = G__29087;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e29084){var e = e29084;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq29083){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29083));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___29090 = arguments.length;
var i__4865__auto___29091 = (0);
while(true){
if((i__4865__auto___29091 < len__4864__auto___29090)){
args__4870__auto__.push((arguments[i__4865__auto___29091]));

var G__29092 = (i__4865__auto___29091 + (1));
i__4865__auto___29091 = G__29092;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e29089){var e = e29089;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq29088){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29088));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___29095 = arguments.length;
var i__4865__auto___29096 = (0);
while(true){
if((i__4865__auto___29096 < len__4864__auto___29095)){
args__4870__auto__.push((arguments[i__4865__auto___29096]));

var G__29097 = (i__4865__auto___29096 + (1));
i__4865__auto___29096 = G__29097;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4253__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e29094){var e = e29094;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq29093){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29093));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___29100 = arguments.length;
var i__4865__auto___29101 = (0);
while(true){
if((i__4865__auto___29101 < len__4864__auto___29100)){
args__4870__auto__.push((arguments[i__4865__auto___29101]));

var G__29102 = (i__4865__auto___29101 + (1));
i__4865__auto___29101 = G__29102;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e29099){var e = e29099;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq29098){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29098));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e29103){var e = e29103;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e29104){var e = e29104;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e29105){var e = e29105;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e29106){var e = e29106;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e29107){var e = e29107;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__29113 = path;
var vec__29114 = G__29113;
var seq__29115 = cljs.core.seq(vec__29114);
var first__29116 = cljs.core.first(seq__29115);
var seq__29115__$1 = cljs.core.next(seq__29115);
var pred = first__29116;
var r = seq__29115__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__29113__$1 = G__29113;
var subjects__$1 = subjects;
while(true){
var vec__29120 = G__29113__$1;
var seq__29121 = cljs.core.seq(vec__29120);
var first__29122 = cljs.core.first(seq__29121);
var seq__29121__$1 = cljs.core.next(seq__29121);
var pred__$1 = first__29122;
var r__$1 = seq__29121__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__29113__$1,subjects__$1,vec__29120,seq__29121,first__29122,seq__29121__$1,pred__$1,r__$1,subjects__$2,G__29113,vec__29114,seq__29115,first__29116,seq__29115__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__29113__$1,subjects__$1,vec__29120,seq__29121,first__29122,seq__29121__$1,pred__$1,r__$1,subjects__$2,G__29113,vec__29114,seq__29115,first__29116,seq__29115__$1,pred,r,subjects){
return (function (p1__29108_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__29108_SHARP_,pred__$1);
});})(G__29113__$1,subjects__$1,vec__29120,seq__29121,first__29122,seq__29121__$1,pred__$1,r__$1,subjects__$2,G__29113,vec__29114,seq__29115,first__29116,seq__29115__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__29113__$1,subjects__$1,vec__29120,seq__29121,first__29122,seq__29121__$1,pred__$1,r__$1,subjects__$2,G__29113,vec__29114,seq__29115,first__29116,seq__29115__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4251__auto__ = r__$1;
if(and__4251__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__4251__auto__;
}
})())){
var G__29123 = r__$1;
var G__29124 = next_subjects;
G__29113__$1 = G__29123;
subjects__$1 = G__29124;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e29109){var e = e29109;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e29125){var e = e29125;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_(coll,key);
}catch (e29126){var e = e29126;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4870__auto__ = [];
var len__4864__auto___29129 = arguments.length;
var i__4865__auto___29130 = (0);
while(true){
if((i__4865__auto___29130 < len__4864__auto___29129)){
args__4870__auto__.push((arguments[i__4865__auto___29130]));

var G__29131 = (i__4865__auto___29130 + (1));
i__4865__auto___29130 = G__29131;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e29128){var e = e29128;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq29127){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29127));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e29132){var e = e29132;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___29135 = arguments.length;
var i__4865__auto___29136 = (0);
while(true){
if((i__4865__auto___29136 < len__4864__auto___29135)){
args__4870__auto__.push((arguments[i__4865__auto___29136]));

var G__29137 = (i__4865__auto___29136 + (1));
i__4865__auto___29136 = G__29137;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e29134){var e = e29134;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq29133){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29133));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e29138){var e = e29138;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_29195){
var state_val_29196 = (state_29195[(1)]);
if((state_val_29196 === (7))){
var inst_29141 = (state_29195[(2)]);
var state_29195__$1 = state_29195;
var statearr_29197_29231 = state_29195__$1;
(statearr_29197_29231[(2)] = inst_29141);

(statearr_29197_29231[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29196 === (1))){
var state_29195__$1 = state_29195;
var statearr_29198_29232 = state_29195__$1;
(statearr_29198_29232[(2)] = null);

(statearr_29198_29232[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29196 === (4))){
var inst_29140 = (state_29195[(2)]);
var state_29195__$1 = (function (){var statearr_29199 = state_29195;
(statearr_29199[(7)] = inst_29140);

return statearr_29199;
})();
var statearr_29200_29233 = state_29195__$1;
(statearr_29200_29233[(2)] = null);

(statearr_29200_29233[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29196 === (15))){
var inst_29178 = (state_29195[(8)]);
var inst_29176 = (state_29195[(9)]);
var inst_29165 = (state_29195[(10)]);
var inst_29166 = (state_29195[(11)]);
var inst_29175 = (state_29195[(12)]);
var inst_29163 = (state_29195[(13)]);
var inst_29182 = (function (){var db = inst_29163;
var prevT = inst_29165;
var db_SINGLEQUOTE_ = inst_29166;
var prev_vals = inst_29175;
var fuel = inst_29176;
var G__29177 = inst_29178;
return (function (p1__29139_SHARP_){
var f = p1__29139_SHARP_;
return f.o;
});
})();
var inst_29183 = (inst_29182.cljs$core$IFn$_invoke$arity$1 ? inst_29182.cljs$core$IFn$_invoke$arity$1(inst_29178) : inst_29182.call(null,inst_29178));
var state_29195__$1 = state_29195;
var statearr_29201_29234 = state_29195__$1;
(statearr_29201_29234[(2)] = inst_29183);

(statearr_29201_29234[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29196 === (13))){
var inst_29178 = (state_29195[(8)]);
var inst_29175 = (state_29195[(12)]);
var inst_29174 = (state_29195[(2)]);
var inst_29175__$1 = fluree.db.util.async.throw_err(inst_29174);
var inst_29176 = fluree.db.dbfunctions.internal.count(inst_29175__$1);
var inst_29178__$1 = cljs.core.first(inst_29175__$1);
var inst_29179 = (inst_29178__$1 == null);
var state_29195__$1 = (function (){var statearr_29202 = state_29195;
(statearr_29202[(8)] = inst_29178__$1);

(statearr_29202[(9)] = inst_29176);

(statearr_29202[(12)] = inst_29175__$1);

return statearr_29202;
})();
if(cljs.core.truth_(inst_29179)){
var statearr_29203_29235 = state_29195__$1;
(statearr_29203_29235[(1)] = (14));

} else {
var statearr_29204_29236 = state_29195__$1;
(statearr_29204_29236[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29196 === (6))){
var inst_29150 = (state_29195[(2)]);
var state_29195__$1 = state_29195;
var statearr_29205_29237 = state_29195__$1;
(statearr_29205_29237[(2)] = inst_29150);

(statearr_29205_29237[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29196 === (3))){
var inst_29193 = (state_29195[(2)]);
var state_29195__$1 = state_29195;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29195__$1,inst_29193);
} else {
if((state_val_29196 === (12))){
var inst_29190 = (state_29195[(2)]);
var _ = (function (){var statearr_29206 = state_29195;
(statearr_29206[(4)] = cljs.core.rest((state_29195[(4)])));

return statearr_29206;
})();
var state_29195__$1 = state_29195;
var statearr_29207_29238 = state_29195__$1;
(statearr_29207_29238[(2)] = inst_29190);

(statearr_29207_29238[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29196 === (2))){
var _ = (function (){var statearr_29209 = state_29195;
(statearr_29209[(4)] = cljs.core.cons((9),(state_29195[(4)])));

return statearr_29209;
})();
var inst_29156 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29157 = typeof inst_29156 === 'string';
var state_29195__$1 = state_29195;
if(cljs.core.truth_(inst_29157)){
var statearr_29210_29239 = state_29195__$1;
(statearr_29210_29239[(1)] = (10));

} else {
var statearr_29211_29240 = state_29195__$1;
(statearr_29211_29240[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29196 === (11))){
var inst_29165 = (state_29195[(10)]);
var inst_29166 = (state_29195[(11)]);
var inst_29163 = (state_29195[(13)]);
var inst_29163__$1 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29164 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_29163__$1);
var inst_29165__$1 = fluree.db.dbfunctions.internal.inc(inst_29164);
var inst_29166__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_29163__$1,new cljs.core.Keyword(null,"t","t",-1397832519),inst_29165__$1);
var inst_29167 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29168 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29169 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29170 = [inst_29168,inst_29169];
var inst_29171 = (new cljs.core.PersistentVector(null,2,(5),inst_29167,inst_29170,null));
var inst_29172 = fluree.db.dbproto._search(inst_29166__$1,inst_29171);
var state_29195__$1 = (function (){var statearr_29212 = state_29195;
(statearr_29212[(10)] = inst_29165__$1);

(statearr_29212[(11)] = inst_29166__$1);

(statearr_29212[(13)] = inst_29163__$1);

return statearr_29212;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29195__$1,(13),inst_29172);
} else {
if((state_val_29196 === (9))){
var _ = (function (){var statearr_29213 = state_29195;
(statearr_29213[(4)] = cljs.core.rest((state_29195[(4)])));

return statearr_29213;
})();
var state_29195__$1 = state_29195;
var ex29208 = (state_29195__$1[(2)]);
var statearr_29214_29241 = state_29195__$1;
(statearr_29214_29241[(5)] = ex29208);


var statearr_29215_29242 = state_29195__$1;
(statearr_29215_29242[(1)] = (4));

(statearr_29215_29242[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29196 === (5))){
var inst_29140 = (state_29195[(7)]);
var _ = (function (){var statearr_29216 = state_29195;
(statearr_29216[(4)] = cljs.core.cons((8),(state_29195[(4)])));

return statearr_29216;
})();
var inst_29147 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29140,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_29217 = state_29195;
(statearr_29217[(4)] = cljs.core.rest((state_29195[(4)])));

return statearr_29217;
})();
var state_29195__$1 = state_29195;
var statearr_29218_29243 = state_29195__$1;
(statearr_29218_29243[(2)] = inst_29147);

(statearr_29218_29243[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29196 === (14))){
var state_29195__$1 = state_29195;
var statearr_29219_29244 = state_29195__$1;
(statearr_29219_29244[(2)] = null);

(statearr_29219_29244[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29196 === (16))){
var inst_29176 = (state_29195[(9)]);
var inst_29185 = (state_29195[(2)]);
var inst_29186 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29187 = [inst_29185,inst_29176];
var inst_29188 = (new cljs.core.PersistentVector(null,2,(5),inst_29186,inst_29187,null));
var state_29195__$1 = state_29195;
var statearr_29221_29245 = state_29195__$1;
(statearr_29221_29245[(2)] = inst_29188);

(statearr_29221_29245[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29196 === (10))){
var inst_29159 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29160 = [null,(0)];
var inst_29161 = (new cljs.core.PersistentVector(null,2,(5),inst_29159,inst_29160,null));
var state_29195__$1 = state_29195;
var statearr_29222_29246 = state_29195__$1;
(statearr_29222_29246[(2)] = inst_29161);

(statearr_29222_29246[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29196 === (8))){
var _ = (function (){var statearr_29223 = state_29195;
(statearr_29223[(4)] = cljs.core.rest((state_29195[(4)])));

return statearr_29223;
})();
var state_29195__$1 = state_29195;
var ex29220 = (state_29195__$1[(2)]);
var statearr_29224_29247 = state_29195__$1;
(statearr_29224_29247[(5)] = ex29220);


var statearr_29225_29248 = state_29195__$1;
(statearr_29225_29248[(1)] = (7));

(statearr_29225_29248[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2741__auto____0 = (function (){
var statearr_29226 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29226[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2741__auto__);

(statearr_29226[(1)] = (1));

return statearr_29226;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2741__auto____1 = (function (state_29195){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_29195);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e29227){var ex__2744__auto__ = e29227;
var statearr_29228_29249 = state_29195;
(statearr_29228_29249[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_29195[(4)]))){
var statearr_29229_29250 = state_29195;
(statearr_29229_29250[(1)] = cljs.core.first((state_29195[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29251 = state_29195;
state_29195 = G__29251;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2741__auto__ = function(state_29195){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2741__auto____1.call(this,state_29195);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_29230 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_29230[(6)] = c__2763__auto__);

return statearr_29230;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_29303){
var state_val_29304 = (state_29303[(1)]);
if((state_val_29304 === (7))){
var inst_29253 = (state_29303[(2)]);
var state_29303__$1 = state_29303;
var statearr_29305_29334 = state_29303__$1;
(statearr_29305_29334[(2)] = inst_29253);

(statearr_29305_29334[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29304 === (1))){
var state_29303__$1 = state_29303;
var statearr_29306_29335 = state_29303__$1;
(statearr_29306_29335[(2)] = null);

(statearr_29306_29335[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29304 === (4))){
var inst_29252 = (state_29303[(2)]);
var state_29303__$1 = (function (){var statearr_29307 = state_29303;
(statearr_29307[(7)] = inst_29252);

return statearr_29307;
})();
var statearr_29308_29336 = state_29303__$1;
(statearr_29308_29336[(2)] = null);

(statearr_29308_29336[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29304 === (13))){
var inst_29298 = (state_29303[(2)]);
var _ = (function (){var statearr_29309 = state_29303;
(statearr_29309[(4)] = cljs.core.rest((state_29303[(4)])));

return statearr_29309;
})();
var state_29303__$1 = state_29303;
var statearr_29310_29337 = state_29303__$1;
(statearr_29310_29337[(2)] = inst_29298);

(statearr_29310_29337[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29304 === (6))){
var inst_29262 = (state_29303[(2)]);
var state_29303__$1 = state_29303;
var statearr_29311_29338 = state_29303__$1;
(statearr_29311_29338[(2)] = inst_29262);

(statearr_29311_29338[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29304 === (3))){
var inst_29301 = (state_29303[(2)]);
var state_29303__$1 = state_29303;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29303__$1,inst_29301);
} else {
if((state_val_29304 === (12))){
var inst_29285 = (state_29303[(8)]);
var inst_29294 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29295 = [null,inst_29285];
var inst_29296 = (new cljs.core.PersistentVector(null,2,(5),inst_29294,inst_29295,null));
var state_29303__$1 = state_29303;
var statearr_29312_29339 = state_29303__$1;
(statearr_29312_29339[(2)] = inst_29296);

(statearr_29312_29339[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29304 === (2))){
var _ = (function (){var statearr_29314 = state_29303;
(statearr_29314[(4)] = cljs.core.cons((9),(state_29303[(4)])));

return statearr_29314;
})();
var inst_29271 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29272 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29273 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29274 = [null,pred_name,"?o"];
var inst_29275 = (new cljs.core.PersistentVector(null,3,(5),inst_29273,inst_29274,null));
var inst_29276 = [inst_29275];
var inst_29277 = (new cljs.core.PersistentVector(null,1,(5),inst_29272,inst_29276,null));
var inst_29278 = ["?o",inst_29277,opts];
var inst_29279 = cljs.core.PersistentHashMap.fromArrays(inst_29271,inst_29278);
var inst_29280 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_29279);
var state_29303__$1 = state_29303;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29303__$1,(10),inst_29280);
} else {
if((state_val_29304 === (11))){
var inst_29284 = (state_29303[(9)]);
var inst_29285 = (state_29303[(8)]);
var inst_29289 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29290 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_29284);
var inst_29291 = [inst_29290,inst_29285];
var inst_29292 = (new cljs.core.PersistentVector(null,2,(5),inst_29289,inst_29291,null));
var state_29303__$1 = state_29303;
var statearr_29315_29340 = state_29303__$1;
(statearr_29315_29340[(2)] = inst_29292);

(statearr_29315_29340[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29304 === (9))){
var _ = (function (){var statearr_29316 = state_29303;
(statearr_29316[(4)] = cljs.core.rest((state_29303[(4)])));

return statearr_29316;
})();
var state_29303__$1 = state_29303;
var ex29313 = (state_29303__$1[(2)]);
var statearr_29317_29341 = state_29303__$1;
(statearr_29317_29341[(5)] = ex29313);


var statearr_29318_29342 = state_29303__$1;
(statearr_29318_29342[(1)] = (4));

(statearr_29318_29342[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29304 === (5))){
var inst_29252 = (state_29303[(7)]);
var _ = (function (){var statearr_29320 = state_29303;
(statearr_29320[(4)] = cljs.core.cons((8),(state_29303[(4)])));

return statearr_29320;
})();
var inst_29259 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29252,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_29321 = state_29303;
(statearr_29321[(4)] = cljs.core.rest((state_29303[(4)])));

return statearr_29321;
})();
var state_29303__$1 = state_29303;
var statearr_29322_29343 = state_29303__$1;
(statearr_29322_29343[(2)] = inst_29259);

(statearr_29322_29343[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29304 === (10))){
var inst_29284 = (state_29303[(9)]);
var inst_29282 = (state_29303[(2)]);
var inst_29283 = fluree.db.util.async.throw_err(inst_29282);
var inst_29284__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29283,(0),null);
var inst_29285 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29283,(1),null);
var inst_29286 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_29284__$1);
var inst_29287 = cljs.core.not(inst_29286);
var state_29303__$1 = (function (){var statearr_29323 = state_29303;
(statearr_29323[(9)] = inst_29284__$1);

(statearr_29323[(8)] = inst_29285);

return statearr_29323;
})();
if(inst_29287){
var statearr_29324_29344 = state_29303__$1;
(statearr_29324_29344[(1)] = (11));

} else {
var statearr_29325_29345 = state_29303__$1;
(statearr_29325_29345[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29304 === (8))){
var _ = (function (){var statearr_29326 = state_29303;
(statearr_29326[(4)] = cljs.core.rest((state_29303[(4)])));

return statearr_29326;
})();
var state_29303__$1 = state_29303;
var ex29319 = (state_29303__$1[(2)]);
var statearr_29327_29346 = state_29303__$1;
(statearr_29327_29346[(5)] = ex29319);


var statearr_29328_29347 = state_29303__$1;
(statearr_29328_29347[(1)] = (7));

(statearr_29328_29347[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2741__auto____0 = (function (){
var statearr_29329 = [null,null,null,null,null,null,null,null,null,null];
(statearr_29329[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2741__auto__);

(statearr_29329[(1)] = (1));

return statearr_29329;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2741__auto____1 = (function (state_29303){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_29303);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e29330){var ex__2744__auto__ = e29330;
var statearr_29331_29348 = state_29303;
(statearr_29331_29348[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_29303[(4)]))){
var statearr_29332_29349 = state_29303;
(statearr_29332_29349[(1)] = cljs.core.first((state_29303[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29350 = state_29303;
state_29303 = G__29350;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2741__auto__ = function(state_29303){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2741__auto____1.call(this,state_29303);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_29333 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_29333[(6)] = c__2763__auto__);

return statearr_29333;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$((function (){var and__4251__auto__ = typeof email === 'string';
if(and__4251__auto__){
return cljs.core.re_matches(pattern,email);
} else {
return and__4251__auto__;
}
})());
}catch (e29351){var e = e29351;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__29353 = arguments.length;
switch (G__29353) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_29423){
var state_val_29424 = (state_29423[(1)]);
if((state_val_29424 === (7))){
var inst_29355 = (state_29423[(2)]);
var state_29423__$1 = state_29423;
var statearr_29425_29469 = state_29423__$1;
(statearr_29425_29469[(2)] = inst_29355);

(statearr_29425_29469[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29424 === (20))){
var inst_29399 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29400 = ["*"];
var inst_29401 = (new cljs.core.PersistentVector(null,1,(5),inst_29399,inst_29400,null));
var state_29423__$1 = state_29423;
var statearr_29426_29470 = state_29423__$1;
(statearr_29426_29470[(2)] = inst_29401);

(statearr_29426_29470[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29424 === (1))){
var state_29423__$1 = state_29423;
var statearr_29427_29471 = state_29423__$1;
(statearr_29427_29471[(2)] = null);

(statearr_29427_29471[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29424 === (4))){
var inst_29354 = (state_29423[(2)]);
var state_29423__$1 = (function (){var statearr_29428 = state_29423;
(statearr_29428[(7)] = inst_29354);

return statearr_29428;
})();
var statearr_29429_29472 = state_29423__$1;
(statearr_29429_29472[(2)] = null);

(statearr_29429_29472[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29424 === (15))){
var inst_29418 = (state_29423[(2)]);
var _ = (function (){var statearr_29430 = state_29423;
(statearr_29430[(4)] = cljs.core.rest((state_29423[(4)])));

return statearr_29430;
})();
var state_29423__$1 = state_29423;
var statearr_29431_29473 = state_29423__$1;
(statearr_29431_29473[(2)] = inst_29418);

(statearr_29431_29473[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29424 === (21))){
var inst_29382 = (state_29423[(8)]);
var inst_29389 = (state_29423[(9)]);
var inst_29403 = (state_29423[(2)]);
var inst_29404 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29405 = cljs.core.PersistentHashMap.EMPTY;
var inst_29406 = [inst_29403,inst_29389,inst_29405];
var inst_29407 = cljs.core.PersistentHashMap.fromArrays(inst_29404,inst_29406);
var inst_29408 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29382,inst_29407);
var state_29423__$1 = state_29423;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29423__$1,(22),inst_29408);
} else {
if((state_val_29424 === (13))){
var inst_29377 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29423__$1 = state_29423;
var statearr_29432_29474 = state_29423__$1;
(statearr_29432_29474[(2)] = inst_29377);

(statearr_29432_29474[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29424 === (22))){
var inst_29410 = (state_29423[(2)]);
var inst_29411 = fluree.db.util.async.throw_err(inst_29410);
var inst_29412 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29411,(0),null);
var inst_29413 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29411,(1),null);
var inst_29414 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29415 = [inst_29412,inst_29413];
var inst_29416 = (new cljs.core.PersistentVector(null,2,(5),inst_29414,inst_29415,null));
var state_29423__$1 = state_29423;
var statearr_29433_29475 = state_29423__$1;
(statearr_29433_29475[(2)] = inst_29416);

(statearr_29433_29475[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29424 === (6))){
var inst_29364 = (state_29423[(2)]);
var state_29423__$1 = state_29423;
var statearr_29434_29476 = state_29423__$1;
(statearr_29434_29476[(2)] = inst_29364);

(statearr_29434_29476[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29424 === (17))){
var inst_29386 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29387 = fluree.db.dbfunctions.internal.get(inst_29386,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_29423__$1 = state_29423;
var statearr_29435_29477 = state_29423__$1;
(statearr_29435_29477[(2)] = inst_29387);

(statearr_29435_29477[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29424 === (3))){
var inst_29421 = (state_29423[(2)]);
var state_29423__$1 = state_29423;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29423__$1,inst_29421);
} else {
if((state_val_29424 === (12))){
var inst_29375 = (state_29423[(2)]);
var state_29423__$1 = state_29423;
if(cljs.core.truth_(inst_29375)){
var statearr_29436_29478 = state_29423__$1;
(statearr_29436_29478[(1)] = (13));

} else {
var statearr_29437_29479 = state_29423__$1;
(statearr_29437_29479[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29424 === (2))){
var inst_29370 = (state_29423[(10)]);
var _ = (function (){var statearr_29438 = state_29423;
(statearr_29438[(4)] = cljs.core.cons((9),(state_29423[(4)])));

return statearr_29438;
})();
var inst_29370__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29423__$1 = (function (){var statearr_29439 = state_29423;
(statearr_29439[(10)] = inst_29370__$1);

return statearr_29439;
})();
if(cljs.core.truth_(inst_29370__$1)){
var statearr_29440_29480 = state_29423__$1;
(statearr_29440_29480[(1)] = (10));

} else {
var statearr_29441_29481 = state_29423__$1;
(statearr_29441_29481[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29424 === (19))){
var inst_29391 = cljs.core.PersistentVector.EMPTY;
var inst_29392 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29393 = ["*"];
var inst_29394 = (new cljs.core.PersistentVector(null,1,(5),inst_29392,inst_29393,null));
var inst_29395 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_29396 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_29394,inst_29395);
var inst_29397 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29391,inst_29396);
var state_29423__$1 = state_29423;
var statearr_29443_29482 = state_29423__$1;
(statearr_29443_29482[(2)] = inst_29397);

(statearr_29443_29482[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29424 === (11))){
var inst_29370 = (state_29423[(10)]);
var state_29423__$1 = state_29423;
var statearr_29444_29483 = state_29423__$1;
(statearr_29444_29483[(2)] = inst_29370);

(statearr_29444_29483[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29424 === (9))){
var _ = (function (){var statearr_29445 = state_29423;
(statearr_29445[(4)] = cljs.core.rest((state_29423[(4)])));

return statearr_29445;
})();
var state_29423__$1 = state_29423;
var ex29442 = (state_29423__$1[(2)]);
var statearr_29446_29484 = state_29423__$1;
(statearr_29446_29484[(5)] = ex29442);


var statearr_29447_29485 = state_29423__$1;
(statearr_29447_29485[(1)] = (4));

(statearr_29447_29485[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29424 === (5))){
var inst_29354 = (state_29423[(7)]);
var _ = (function (){var statearr_29448 = state_29423;
(statearr_29448[(4)] = cljs.core.cons((8),(state_29423[(4)])));

return statearr_29448;
})();
var inst_29361 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29354,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_29449 = state_29423;
(statearr_29449[(4)] = cljs.core.rest((state_29423[(4)])));

return statearr_29449;
})();
var state_29423__$1 = state_29423;
var statearr_29450_29486 = state_29423__$1;
(statearr_29450_29486[(2)] = inst_29361);

(statearr_29450_29486[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29424 === (14))){
var inst_29383 = (state_29423[(11)]);
var inst_29382 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29383__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29423__$1 = (function (){var statearr_29451 = state_29423;
(statearr_29451[(11)] = inst_29383__$1);

(statearr_29451[(8)] = inst_29382);

return statearr_29451;
})();
if(cljs.core.truth_(inst_29383__$1)){
var statearr_29452_29487 = state_29423__$1;
(statearr_29452_29487[(1)] = (16));

} else {
var statearr_29453_29488 = state_29423__$1;
(statearr_29453_29488[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29424 === (16))){
var inst_29383 = (state_29423[(11)]);
var state_29423__$1 = state_29423;
var statearr_29454_29489 = state_29423__$1;
(statearr_29454_29489[(2)] = inst_29383);

(statearr_29454_29489[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29424 === (10))){
var inst_29372 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_29423__$1 = state_29423;
var statearr_29456_29490 = state_29423__$1;
(statearr_29456_29490[(2)] = inst_29372);

(statearr_29456_29490[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29424 === (18))){
var inst_29389 = (state_29423[(2)]);
var state_29423__$1 = (function (){var statearr_29457 = state_29423;
(statearr_29457[(9)] = inst_29389);

return statearr_29457;
})();
if(cljs.core.truth_(additional_params)){
var statearr_29458_29491 = state_29423__$1;
(statearr_29458_29491[(1)] = (19));

} else {
var statearr_29459_29492 = state_29423__$1;
(statearr_29459_29492[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29424 === (8))){
var _ = (function (){var statearr_29460 = state_29423;
(statearr_29460[(4)] = cljs.core.rest((state_29423[(4)])));

return statearr_29460;
})();
var state_29423__$1 = state_29423;
var ex29455 = (state_29423__$1[(2)]);
var statearr_29461_29493 = state_29423__$1;
(statearr_29461_29493[(5)] = ex29455);


var statearr_29462_29494 = state_29423__$1;
(statearr_29462_29494[(1)] = (7));

(statearr_29462_29494[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2741__auto____0 = (function (){
var statearr_29463 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29463[(0)] = fluree$db$dbfunctions$internal$state_machine__2741__auto__);

(statearr_29463[(1)] = (1));

return statearr_29463;
});
var fluree$db$dbfunctions$internal$state_machine__2741__auto____1 = (function (state_29423){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_29423);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e29464){var ex__2744__auto__ = e29464;
var statearr_29465_29495 = state_29423;
(statearr_29465_29495[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_29423[(4)]))){
var statearr_29466_29496 = state_29423;
(statearr_29466_29496[(1)] = cljs.core.first((state_29423[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29497 = state_29423;
state_29423 = G__29497;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2741__auto__ = function(state_29423){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2741__auto____1.call(this,state_29423);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2741__auto____0;
fluree$db$dbfunctions$internal$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2741__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_29467 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_29467[(6)] = c__2763__auto__);

return statearr_29467;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__29499 = arguments.length;
switch (G__29499) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_29543){
var state_val_29544 = (state_29543[(1)]);
if((state_val_29544 === (7))){
var inst_29521 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29522 = ["*"];
var inst_29523 = (new cljs.core.PersistentVector(null,1,(5),inst_29521,inst_29522,null));
var state_29543__$1 = state_29543;
var statearr_29545_29565 = state_29543__$1;
(statearr_29545_29565[(2)] = inst_29523);

(statearr_29545_29565[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29544 === (1))){
var state_29543__$1 = state_29543;
var statearr_29546_29566 = state_29543__$1;
(statearr_29546_29566[(2)] = null);

(statearr_29546_29566[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29544 === (4))){
var inst_29500 = (state_29543[(2)]);
var inst_29501 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29500,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_29543__$1 = state_29543;
var statearr_29547_29567 = state_29543__$1;
(statearr_29547_29567[(2)] = inst_29501);

(statearr_29547_29567[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29544 === (6))){
var inst_29513 = cljs.core.PersistentVector.EMPTY;
var inst_29514 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29515 = ["*"];
var inst_29516 = (new cljs.core.PersistentVector(null,1,(5),inst_29514,inst_29515,null));
var inst_29517 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_29518 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_29516,inst_29517);
var inst_29519 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29513,inst_29518);
var state_29543__$1 = state_29543;
var statearr_29548_29568 = state_29543__$1;
(statearr_29548_29568[(2)] = inst_29519);

(statearr_29548_29568[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29544 === (3))){
var inst_29541 = (state_29543[(2)]);
var state_29543__$1 = state_29543;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29543__$1,inst_29541);
} else {
if((state_val_29544 === (2))){
var _ = (function (){var statearr_29550 = state_29543;
(statearr_29550[(4)] = cljs.core.cons((5),(state_29543[(4)])));

return statearr_29550;
})();
var inst_29510 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29511 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29543__$1 = (function (){var statearr_29551 = state_29543;
(statearr_29551[(7)] = inst_29511);

(statearr_29551[(8)] = inst_29510);

return statearr_29551;
})();
if(cljs.core.truth_(additional_params)){
var statearr_29552_29569 = state_29543__$1;
(statearr_29552_29569[(1)] = (6));

} else {
var statearr_29553_29570 = state_29543__$1;
(statearr_29553_29570[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29544 === (9))){
var inst_29532 = (state_29543[(2)]);
var inst_29533 = fluree.db.util.async.throw_err(inst_29532);
var inst_29534 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29533,(0),null);
var inst_29535 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29533,(1),null);
var inst_29536 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29537 = [inst_29534,inst_29535];
var inst_29538 = (new cljs.core.PersistentVector(null,2,(5),inst_29536,inst_29537,null));
var _ = (function (){var statearr_29554 = state_29543;
(statearr_29554[(4)] = cljs.core.rest((state_29543[(4)])));

return statearr_29554;
})();
var state_29543__$1 = state_29543;
var statearr_29555_29571 = state_29543__$1;
(statearr_29555_29571[(2)] = inst_29538);

(statearr_29555_29571[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29544 === (5))){
var _ = (function (){var statearr_29556 = state_29543;
(statearr_29556[(4)] = cljs.core.rest((state_29543[(4)])));

return statearr_29556;
})();
var state_29543__$1 = state_29543;
var ex29549 = (state_29543__$1[(2)]);
var statearr_29557_29572 = state_29543__$1;
(statearr_29557_29572[(5)] = ex29549);


var statearr_29558_29573 = state_29543__$1;
(statearr_29558_29573[(1)] = (4));

(statearr_29558_29573[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29544 === (8))){
var inst_29511 = (state_29543[(7)]);
var inst_29510 = (state_29543[(8)]);
var inst_29525 = (state_29543[(2)]);
var inst_29526 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29527 = cljs.core.PersistentHashMap.EMPTY;
var inst_29528 = [inst_29525,inst_29511,inst_29527];
var inst_29529 = cljs.core.PersistentHashMap.fromArrays(inst_29526,inst_29528);
var inst_29530 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29510,inst_29529);
var state_29543__$1 = state_29543;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29543__$1,(9),inst_29530);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2741__auto____0 = (function (){
var statearr_29559 = [null,null,null,null,null,null,null,null,null];
(statearr_29559[(0)] = fluree$db$dbfunctions$internal$state_machine__2741__auto__);

(statearr_29559[(1)] = (1));

return statearr_29559;
});
var fluree$db$dbfunctions$internal$state_machine__2741__auto____1 = (function (state_29543){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_29543);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e29560){var ex__2744__auto__ = e29560;
var statearr_29561_29574 = state_29543;
(statearr_29561_29574[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_29543[(4)]))){
var statearr_29562_29575 = state_29543;
(statearr_29562_29575[(1)] = cljs.core.first((state_29543[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29576 = state_29543;
state_29543 = G__29576;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2741__auto__ = function(state_29543){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2741__auto____1.call(this,state_29543);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2741__auto____0;
fluree$db$dbfunctions$internal$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2741__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_29563 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_29563[(6)] = c__2763__auto__);

return statearr_29563;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_29620){
var state_val_29621 = (state_29620[(1)]);
if((state_val_29621 === (1))){
var state_29620__$1 = state_29620;
var statearr_29622_29636 = state_29620__$1;
(statearr_29622_29636[(2)] = null);

(statearr_29622_29636[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (2))){
var _ = (function (){var statearr_29623 = state_29620;
(statearr_29623[(4)] = cljs.core.cons((5),(state_29620[(4)])));

return statearr_29623;
})();
var inst_29587 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29588 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29589 = ["_user/_auth"];
var inst_29590 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29591 = ["*"];
var inst_29592 = (new cljs.core.PersistentVector(null,1,(5),inst_29590,inst_29591,null));
var inst_29593 = [inst_29592];
var inst_29594 = cljs.core.PersistentHashMap.fromArrays(inst_29589,inst_29593);
var inst_29595 = [inst_29594];
var inst_29596 = (new cljs.core.PersistentVector(null,1,(5),inst_29588,inst_29595,null));
var inst_29597 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29598 = cljs.core.PersistentHashMap.EMPTY;
var inst_29599 = [inst_29596,inst_29597,inst_29598];
var inst_29600 = cljs.core.PersistentHashMap.fromArrays(inst_29587,inst_29599);
var inst_29601 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29602 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29601,inst_29600);
var state_29620__$1 = state_29620;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29620__$1,(6),inst_29602);
} else {
if((state_val_29621 === (3))){
var inst_29618 = (state_29620[(2)]);
var state_29620__$1 = state_29620;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29620__$1,inst_29618);
} else {
if((state_val_29621 === (4))){
var inst_29577 = (state_29620[(2)]);
var inst_29578 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29577,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_29620__$1 = state_29620;
var statearr_29625_29637 = state_29620__$1;
(statearr_29625_29637[(2)] = inst_29578);

(statearr_29625_29637[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (5))){
var _ = (function (){var statearr_29626 = state_29620;
(statearr_29626[(4)] = cljs.core.rest((state_29620[(4)])));

return statearr_29626;
})();
var state_29620__$1 = state_29620;
var ex29624 = (state_29620__$1[(2)]);
var statearr_29627_29638 = state_29620__$1;
(statearr_29627_29638[(5)] = ex29624);


var statearr_29628_29639 = state_29620__$1;
(statearr_29628_29639[(1)] = (4));

(statearr_29628_29639[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29621 === (6))){
var inst_29604 = (state_29620[(2)]);
var inst_29605 = fluree.db.util.async.throw_err(inst_29604);
var inst_29606 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29605,(0),null);
var inst_29607 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29605,(1),null);
var inst_29608 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29609 = ["_user/_auth","_id"];
var inst_29610 = (new cljs.core.PersistentVector(null,2,(5),inst_29608,inst_29609,null));
var inst_29611 = fluree.db.dbfunctions.internal.get_in(inst_29606,inst_29610);
var inst_29612 = cljs.core.first(inst_29611);
var inst_29613 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29614 = [inst_29612,inst_29607];
var inst_29615 = (new cljs.core.PersistentVector(null,2,(5),inst_29613,inst_29614,null));
var _ = (function (){var statearr_29629 = state_29620;
(statearr_29629[(4)] = cljs.core.rest((state_29620[(4)])));

return statearr_29629;
})();
var state_29620__$1 = state_29620;
var statearr_29630_29640 = state_29620__$1;
(statearr_29630_29640[(2)] = inst_29615);

(statearr_29630_29640[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2741__auto____0 = (function (){
var statearr_29631 = [null,null,null,null,null,null,null];
(statearr_29631[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2741__auto__);

(statearr_29631[(1)] = (1));

return statearr_29631;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2741__auto____1 = (function (state_29620){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_29620);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e29632){var ex__2744__auto__ = e29632;
var statearr_29633_29641 = state_29620;
(statearr_29633_29641[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_29620[(4)]))){
var statearr_29634_29642 = state_29620;
(statearr_29634_29642[(1)] = cljs.core.first((state_29620[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29643 = state_29620;
state_29620 = G__29643;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2741__auto__ = function(state_29620){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2741__auto____1.call(this,state_29620);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_29635 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_29635[(6)] = c__2763__auto__);

return statearr_29635;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_29660){
var state_val_29661 = (state_29660[(1)]);
if((state_val_29661 === (1))){
var state_29660__$1 = state_29660;
var statearr_29662_29676 = state_29660__$1;
(statearr_29662_29676[(2)] = null);

(statearr_29662_29676[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29661 === (2))){
var _ = (function (){var statearr_29663 = state_29660;
(statearr_29663[(4)] = cljs.core.cons((5),(state_29660[(4)])));

return statearr_29663;
})();
var inst_29650 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29651 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29652 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_29651,inst_29650);
var state_29660__$1 = state_29660;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29660__$1,(6),inst_29652);
} else {
if((state_val_29661 === (3))){
var inst_29658 = (state_29660[(2)]);
var state_29660__$1 = state_29660;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29660__$1,inst_29658);
} else {
if((state_val_29661 === (4))){
var inst_29644 = (state_29660[(2)]);
var state_29660__$1 = state_29660;
var statearr_29665_29677 = state_29660__$1;
(statearr_29665_29677[(2)] = inst_29644);

(statearr_29665_29677[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29661 === (5))){
var _ = (function (){var statearr_29666 = state_29660;
(statearr_29666[(4)] = cljs.core.rest((state_29660[(4)])));

return statearr_29666;
})();
var state_29660__$1 = state_29660;
var ex29664 = (state_29660__$1[(2)]);
var statearr_29667_29678 = state_29660__$1;
(statearr_29667_29678[(5)] = ex29664);


if((ex29664 instanceof Error)){
var statearr_29668_29679 = state_29660__$1;
(statearr_29668_29679[(1)] = (4));

(statearr_29668_29679[(5)] = null);

} else {
throw ex29664;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29661 === (6))){
var inst_29654 = (state_29660[(2)]);
var inst_29655 = fluree.db.util.async.throw_err(inst_29654);
var _ = (function (){var statearr_29669 = state_29660;
(statearr_29669[(4)] = cljs.core.rest((state_29660[(4)])));

return statearr_29669;
})();
var state_29660__$1 = state_29660;
var statearr_29670_29680 = state_29660__$1;
(statearr_29670_29680[(2)] = inst_29655);

(statearr_29670_29680[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2741__auto____0 = (function (){
var statearr_29671 = [null,null,null,null,null,null,null];
(statearr_29671[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2741__auto__);

(statearr_29671[(1)] = (1));

return statearr_29671;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2741__auto____1 = (function (state_29660){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_29660);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e29672){var ex__2744__auto__ = e29672;
var statearr_29673_29681 = state_29660;
(statearr_29673_29681[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_29660[(4)]))){
var statearr_29674_29682 = state_29660;
(statearr_29674_29682[(1)] = cljs.core.first((state_29660[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29683 = state_29660;
state_29660 = G__29683;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2741__auto__ = function(state_29660){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2741__auto____1.call(this,state_29660);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_29675 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_29675[(6)] = c__2763__auto__);

return statearr_29675;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__29684_SHARP_){
return p1__29684_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__29685_SHARP_){
return p1__29685_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e29686){var e = e29686;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__29687_SHARP_){
return p1__29687_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__29688_SHARP_){
return p1__29688_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e29689){var e = e29689;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__29691 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__29691);
})() | (0));
return num;
}catch (e29690){var e = e29690;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_29771){
var state_val_29772 = (state_29771[(1)]);
if((state_val_29772 === (7))){
var inst_29710 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_29711 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29712 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29713 = cljs.core.PersistentHashMap.fromArrays(inst_29711,inst_29712);
var inst_29714 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29710,inst_29713);
var inst_29715 = (function(){throw inst_29714})();
var state_29771__$1 = state_29771;
var statearr_29773_29808 = state_29771__$1;
(statearr_29773_29808[(2)] = inst_29715);

(statearr_29773_29808[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29772 === (1))){
var state_29771__$1 = state_29771;
var statearr_29774_29809 = state_29771__$1;
(statearr_29774_29809[(2)] = null);

(statearr_29774_29809[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29772 === (4))){
var inst_29692 = (state_29771[(2)]);
var state_29771__$1 = state_29771;
var statearr_29775_29810 = state_29771__$1;
(statearr_29775_29810[(2)] = inst_29692);

(statearr_29775_29810[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29772 === (15))){
var inst_29755 = (state_29771[(7)]);
var inst_29751 = (state_29771[(2)]);
var inst_29752 = fluree.db.util.async.throw_err(inst_29751);
var inst_29753 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29752,(0),null);
var inst_29754 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29752,(1),null);
var inst_29755__$1 = cljs.core.first(inst_29753);
var inst_29756 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29755__$1,compare_val);
var state_29771__$1 = (function (){var statearr_29776 = state_29771;
(statearr_29776[(7)] = inst_29755__$1);

(statearr_29776[(8)] = inst_29754);

return statearr_29776;
})();
if(inst_29756){
var statearr_29777_29811 = state_29771__$1;
(statearr_29777_29811[(1)] = (16));

} else {
var statearr_29778_29812 = state_29771__$1;
(statearr_29778_29812[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29772 === (13))){
var state_29771__$1 = state_29771;
var statearr_29779_29813 = state_29771__$1;
(statearr_29779_29813[(2)] = null);

(statearr_29779_29813[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29772 === (6))){
var state_29771__$1 = state_29771;
var statearr_29780_29814 = state_29771__$1;
(statearr_29780_29814[(2)] = null);

(statearr_29780_29814[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29772 === (17))){
var inst_29755 = (state_29771[(7)]);
var inst_29759 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29755)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_29760 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29761 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29762 = cljs.core.PersistentHashMap.fromArrays(inst_29760,inst_29761);
var inst_29763 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29759,inst_29762);
var inst_29764 = (function(){throw inst_29763})();
var state_29771__$1 = state_29771;
var statearr_29781_29815 = state_29771__$1;
(statearr_29781_29815[(2)] = inst_29764);

(statearr_29781_29815[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29772 === (3))){
var inst_29769 = (state_29771[(2)]);
var state_29771__$1 = state_29771;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29771__$1,inst_29769);
} else {
if((state_val_29772 === (12))){
var inst_29707 = (state_29771[(9)]);
var inst_29730 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_29707], 0));
var inst_29731 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29732 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29733 = cljs.core.PersistentHashMap.fromArrays(inst_29731,inst_29732);
var inst_29734 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29730,inst_29733);
var inst_29735 = (function(){throw inst_29734})();
var state_29771__$1 = state_29771;
var statearr_29782_29816 = state_29771__$1;
(statearr_29782_29816[(2)] = inst_29735);

(statearr_29782_29816[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29772 === (2))){
var inst_29706 = (state_29771[(10)]);
var inst_29704 = (state_29771[(11)]);
var inst_29705 = (state_29771[(12)]);
var _ = (function (){var statearr_29783 = state_29771;
(statearr_29783[(4)] = cljs.core.cons((5),(state_29771[(4)])));

return statearr_29783;
})();
var inst_29702 = _QMARK_ctx;
var inst_29703 = cljs.core.__destructure_map(inst_29702);
var inst_29704__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29703,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_29705__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29703,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_29706__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29703,new cljs.core.Keyword(null,"db","db",993250759));
var inst_29707 = fluree.db.dbproto._p_prop(inst_29706__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_29705__$1);
var state_29771__$1 = (function (){var statearr_29784 = state_29771;
(statearr_29784[(10)] = inst_29706__$1);

(statearr_29784[(11)] = inst_29704__$1);

(statearr_29784[(12)] = inst_29705__$1);

(statearr_29784[(9)] = inst_29707);

return statearr_29784;
})();
if(cljs.core.truth_(inst_29704__$1)){
var statearr_29785_29817 = state_29771__$1;
(statearr_29785_29817[(1)] = (6));

} else {
var statearr_29786_29818 = state_29771__$1;
(statearr_29786_29818[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29772 === (11))){
var inst_29706 = (state_29771[(10)]);
var inst_29705 = (state_29771[(12)]);
var inst_29727 = (state_29771[(2)]);
var inst_29728 = fluree.db.dbproto._p_prop(inst_29706,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_29705);
var state_29771__$1 = (function (){var statearr_29788 = state_29771;
(statearr_29788[(13)] = inst_29727);

return statearr_29788;
})();
if(cljs.core.truth_(inst_29728)){
var statearr_29789_29819 = state_29771__$1;
(statearr_29789_29819[(1)] = (12));

} else {
var statearr_29790_29820 = state_29771__$1;
(statearr_29790_29820[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29772 === (9))){
var state_29771__$1 = state_29771;
var statearr_29791_29821 = state_29771__$1;
(statearr_29791_29821[(2)] = null);

(statearr_29791_29821[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29772 === (5))){
var _ = (function (){var statearr_29792 = state_29771;
(statearr_29792[(4)] = cljs.core.rest((state_29771[(4)])));

return statearr_29792;
})();
var state_29771__$1 = state_29771;
var ex29787 = (state_29771__$1[(2)]);
var statearr_29793_29822 = state_29771__$1;
(statearr_29793_29822[(5)] = ex29787);


if((ex29787 instanceof Error)){
var statearr_29794_29823 = state_29771__$1;
(statearr_29794_29823[(1)] = (4));

(statearr_29794_29823[(5)] = null);

} else {
throw ex29787;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29772 === (14))){
var inst_29706 = (state_29771[(10)]);
var inst_29704 = (state_29771[(11)]);
var inst_29707 = (state_29771[(9)]);
var inst_29738 = (state_29771[(2)]);
var inst_29739 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29740 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29741 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29742 = [inst_29704,inst_29707,"?current-val"];
var inst_29743 = (new cljs.core.PersistentVector(null,3,(5),inst_29741,inst_29742,null));
var inst_29744 = [inst_29743];
var inst_29745 = (new cljs.core.PersistentVector(null,1,(5),inst_29740,inst_29744,null));
var inst_29746 = cljs.core.PersistentHashMap.EMPTY;
var inst_29747 = ["?current-val",inst_29745,inst_29746];
var inst_29748 = cljs.core.PersistentHashMap.fromArrays(inst_29739,inst_29747);
var inst_29749 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29706,inst_29748);
var state_29771__$1 = (function (){var statearr_29795 = state_29771;
(statearr_29795[(14)] = inst_29738);

return statearr_29795;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29771__$1,(15),inst_29749);
} else {
if((state_val_29772 === (16))){
var state_29771__$1 = state_29771;
var statearr_29796_29824 = state_29771__$1;
(statearr_29796_29824[(2)] = new_val);

(statearr_29796_29824[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29772 === (10))){
var inst_29720 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_29721 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29722 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29723 = cljs.core.PersistentHashMap.fromArrays(inst_29721,inst_29722);
var inst_29724 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29720,inst_29723);
var inst_29725 = (function(){throw inst_29724})();
var state_29771__$1 = state_29771;
var statearr_29797_29825 = state_29771__$1;
(statearr_29797_29825[(2)] = inst_29725);

(statearr_29797_29825[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29772 === (18))){
var inst_29766 = (state_29771[(2)]);
var _ = (function (){var statearr_29798 = state_29771;
(statearr_29798[(4)] = cljs.core.rest((state_29771[(4)])));

return statearr_29798;
})();
var state_29771__$1 = state_29771;
var statearr_29799_29826 = state_29771__$1;
(statearr_29799_29826[(2)] = inst_29766);

(statearr_29799_29826[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29772 === (8))){
var inst_29707 = (state_29771[(9)]);
var inst_29717 = (state_29771[(2)]);
var state_29771__$1 = (function (){var statearr_29800 = state_29771;
(statearr_29800[(15)] = inst_29717);

return statearr_29800;
})();
if(cljs.core.truth_(inst_29707)){
var statearr_29801_29827 = state_29771__$1;
(statearr_29801_29827[(1)] = (9));

} else {
var statearr_29802_29828 = state_29771__$1;
(statearr_29802_29828[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__2741__auto____0 = (function (){
var statearr_29803 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29803[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__2741__auto__);

(statearr_29803[(1)] = (1));

return statearr_29803;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__2741__auto____1 = (function (state_29771){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_29771);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e29804){var ex__2744__auto__ = e29804;
var statearr_29805_29829 = state_29771;
(statearr_29805_29829[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_29771[(4)]))){
var statearr_29806_29830 = state_29771;
(statearr_29806_29830[(1)] = cljs.core.first((state_29771[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29831 = state_29771;
state_29771 = G__29831;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__2741__auto__ = function(state_29771){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2741__auto____1.call(this,state_29771);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_29807 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_29807[(6)] = c__2763__auto__);

return statearr_29807;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
