// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__63045 = arguments.length;
switch (G__63045) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5751__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5751__auto__)){
var block = temp__5751__auto__;
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2763__auto___63084 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_63066){
var state_val_63067 = (state_63066[(1)]);
if((state_val_63067 === (1))){
var state_63066__$1 = state_63066;
var statearr_63068_63085 = state_63066__$1;
(statearr_63068_63085[(2)] = null);

(statearr_63068_63085[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63067 === (2))){
var _ = (function (){var statearr_63069 = state_63066;
(statearr_63069[(4)] = cljs.core.cons((5),(state_63066[(4)])));

return statearr_63069;
})();
var inst_63052 = fluree.db.session.db(conn,ledger,null);
var state_63066__$1 = state_63066;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63066__$1,(7),inst_63052);
} else {
if((state_val_63067 === (3))){
var inst_63062 = (state_63066[(2)]);
var inst_63063 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_63062);
var inst_63064 = cljs.core.async.close_BANG_(pc);
var state_63066__$1 = (function (){var statearr_63071 = state_63066;
(statearr_63071[(7)] = inst_63063);

return statearr_63071;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_63066__$1,inst_63064);
} else {
if((state_val_63067 === (4))){
var inst_63046 = (state_63066[(2)]);
var state_63066__$1 = state_63066;
var statearr_63072_63086 = state_63066__$1;
(statearr_63072_63086[(2)] = inst_63046);

(statearr_63072_63086[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63067 === (5))){
var _ = (function (){var statearr_63073 = state_63066;
(statearr_63073[(4)] = cljs.core.rest((state_63066[(4)])));

return statearr_63073;
})();
var state_63066__$1 = state_63066;
var ex63070 = (state_63066__$1[(2)]);
var statearr_63074_63087 = state_63066__$1;
(statearr_63074_63087[(5)] = ex63070);


var statearr_63075_63088 = state_63066__$1;
(statearr_63075_63088[(1)] = (4));

(statearr_63075_63088[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63067 === (6))){
var inst_63058 = (state_63066[(2)]);
var inst_63059 = fluree.db.util.async.throw_err(inst_63058);
var _ = (function (){var statearr_63076 = state_63066;
(statearr_63076[(4)] = cljs.core.rest((state_63066[(4)])));

return statearr_63076;
})();
var state_63066__$1 = state_63066;
var statearr_63077_63089 = state_63066__$1;
(statearr_63077_63089[(2)] = inst_63059);

(statearr_63077_63089[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63067 === (7))){
var inst_63054 = (state_63066[(2)]);
var inst_63055 = fluree.db.util.async.throw_err(inst_63054);
var inst_63056 = fluree.db.time_travel.as_of_block(inst_63055,block);
var state_63066__$1 = state_63066;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63066__$1,(6),inst_63056);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2741__auto__ = null;
var fluree$db$api$ledger$state_machine__2741__auto____0 = (function (){
var statearr_63078 = [null,null,null,null,null,null,null,null];
(statearr_63078[(0)] = fluree$db$api$ledger$state_machine__2741__auto__);

(statearr_63078[(1)] = (1));

return statearr_63078;
});
var fluree$db$api$ledger$state_machine__2741__auto____1 = (function (state_63066){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_63066);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e63079){var ex__2744__auto__ = e63079;
var statearr_63080_63090 = state_63066;
(statearr_63080_63090[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_63066[(4)]))){
var statearr_63081_63091 = state_63066;
(statearr_63081_63091[(1)] = cljs.core.first((state_63066[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63092 = state_63066;
state_63066 = G__63092;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2741__auto__ = function(state_63066){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2741__auto____1.call(this,state_63066);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2741__auto____0;
fluree$db$api$ledger$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2741__auto____1;
return fluree$db$api$ledger$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_63082 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_63082[(6)] = c__2763__auto___63084);

return statearr_63082;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));


return pc;
} else {
return fluree.db.session.db(conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t(db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_63133){
var state_val_63134 = (state_63133[(1)]);
if((state_val_63134 === (7))){
var inst_63102 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_63133__$1 = state_63133;
if(inst_63102){
var statearr_63135_63166 = state_63133__$1;
(statearr_63135_63166[(1)] = (9));

} else {
var statearr_63136_63167 = state_63133__$1;
(statearr_63136_63167[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63134 === (1))){
var state_63133__$1 = state_63133;
var statearr_63137_63168 = state_63133__$1;
(statearr_63137_63168[(2)] = null);

(statearr_63137_63168[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63134 === (4))){
var inst_63093 = (state_63133[(2)]);
var state_63133__$1 = state_63133;
var statearr_63138_63169 = state_63133__$1;
(statearr_63138_63169[(2)] = inst_63093);

(statearr_63138_63169[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63134 === (15))){
var inst_63110 = (state_63133[(7)]);
var inst_63109 = (state_63133[(2)]);
var inst_63110__$1 = fluree.db.util.async.throw_err(inst_63109);
var state_63133__$1 = (function (){var statearr_63139 = state_63133;
(statearr_63139[(7)] = inst_63110__$1);

return statearr_63139;
})();
if(cljs.core.truth_(inst_63110__$1)){
var statearr_63140_63170 = state_63133__$1;
(statearr_63140_63170[(1)] = (16));

} else {
var statearr_63141_63171 = state_63133__$1;
(statearr_63141_63171[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63134 === (13))){
var state_63133__$1 = state_63133;
var statearr_63142_63172 = state_63133__$1;
(statearr_63142_63172[(2)] = null);

(statearr_63142_63172[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63134 === (6))){
var state_63133__$1 = state_63133;
var statearr_63143_63173 = state_63133__$1;
(statearr_63143_63173[(2)] = db);

(statearr_63143_63173[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63134 === (17))){
var inst_63114 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_63115 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63116 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_63117 = cljs.core.PersistentHashMap.fromArrays(inst_63115,inst_63116);
var inst_63118 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_63114,inst_63117);
var inst_63119 = (function(){throw inst_63118})();
var state_63133__$1 = state_63133;
var statearr_63144_63174 = state_63133__$1;
(statearr_63144_63174[(2)] = inst_63119);

(statearr_63144_63174[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63134 === (3))){
var inst_63131 = (state_63133[(2)]);
var state_63133__$1 = state_63133;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63133__$1,inst_63131);
} else {
if((state_val_63134 === (12))){
var inst_63107 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_63133__$1 = state_63133;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63133__$1,(15),inst_63107);
} else {
if((state_val_63134 === (2))){
var _ = (function (){var statearr_63145 = state_63133;
(statearr_63145[(4)] = cljs.core.cons((5),(state_63133[(4)])));

return statearr_63145;
})();
var inst_63099 = cljs.core.not(auth);
var state_63133__$1 = state_63133;
if(inst_63099){
var statearr_63146_63175 = state_63133__$1;
(statearr_63146_63175[(1)] = (6));

} else {
var statearr_63147_63176 = state_63133__$1;
(statearr_63147_63176[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63134 === (11))){
var inst_63126 = (state_63133[(2)]);
var state_63133__$1 = state_63133;
var statearr_63149_63177 = state_63133__$1;
(statearr_63149_63177[(2)] = inst_63126);

(statearr_63149_63177[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63134 === (9))){
var inst_63104 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_63133__$1 = state_63133;
var statearr_63150_63178 = state_63133__$1;
(statearr_63150_63178[(2)] = inst_63104);

(statearr_63150_63178[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63134 === (5))){
var _ = (function (){var statearr_63151 = state_63133;
(statearr_63151[(4)] = cljs.core.rest((state_63133[(4)])));

return statearr_63151;
})();
var state_63133__$1 = state_63133;
var ex63148 = (state_63133__$1[(2)]);
var statearr_63152_63179 = state_63133__$1;
(statearr_63152_63179[(5)] = ex63148);


if((ex63148 instanceof Error)){
var statearr_63153_63180 = state_63133__$1;
(statearr_63153_63180[(1)] = (4));

(statearr_63153_63180[(5)] = null);

} else {
throw ex63148;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63134 === (14))){
var inst_63124 = (state_63133[(2)]);
var state_63133__$1 = state_63133;
var statearr_63154_63181 = state_63133__$1;
(statearr_63154_63181[(2)] = inst_63124);

(statearr_63154_63181[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63134 === (16))){
var inst_63110 = (state_63133[(7)]);
var inst_63112 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_63110);
var state_63133__$1 = state_63133;
var statearr_63155_63182 = state_63133__$1;
(statearr_63155_63182[(2)] = inst_63112);

(statearr_63155_63182[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63134 === (10))){
var state_63133__$1 = state_63133;
var statearr_63156_63183 = state_63133__$1;
(statearr_63156_63183[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63134 === (18))){
var inst_63121 = (state_63133[(2)]);
var state_63133__$1 = state_63133;
var statearr_63158_63184 = state_63133__$1;
(statearr_63158_63184[(2)] = inst_63121);

(statearr_63158_63184[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63134 === (8))){
var inst_63128 = (state_63133[(2)]);
var _ = (function (){var statearr_63159 = state_63133;
(statearr_63159[(4)] = cljs.core.rest((state_63133[(4)])));

return statearr_63159;
})();
var state_63133__$1 = state_63133;
var statearr_63160_63185 = state_63133__$1;
(statearr_63160_63185[(2)] = inst_63128);

(statearr_63160_63185[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto____0 = (function (){
var statearr_63161 = [null,null,null,null,null,null,null,null];
(statearr_63161[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto__);

(statearr_63161[(1)] = (1));

return statearr_63161;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto____1 = (function (state_63133){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_63133);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e63162){var ex__2744__auto__ = e63162;
var statearr_63163_63186 = state_63133;
(statearr_63163_63186[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_63133[(4)]))){
var statearr_63164_63187 = state_63133;
(statearr_63164_63187[(1)] = cljs.core.first((state_63133[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63188 = state_63133;
state_63133 = G__63188;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto__ = function(state_63133){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto____1.call(this,state_63133);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_63165 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_63165[(6)] = c__2763__auto__);

return statearr_63165;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_63252){
var state_val_63253 = (state_63252[(1)]);
if((state_val_63253 === (7))){
var inst_63198 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_63252__$1 = state_63252;
if(inst_63198){
var statearr_63254_63303 = state_63252__$1;
(statearr_63254_63303[(1)] = (9));

} else {
var statearr_63255_63304 = state_63252__$1;
(statearr_63255_63304[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63253 === (20))){
var inst_63222 = (state_63252[(7)]);
var state_63252__$1 = state_63252;
if(cljs.core.truth_(inst_63222)){
var statearr_63256_63305 = state_63252__$1;
(statearr_63256_63305[(1)] = (22));

} else {
var statearr_63257_63306 = state_63252__$1;
(statearr_63257_63306[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63253 === (27))){
var state_63252__$1 = state_63252;
var statearr_63258_63307 = state_63252__$1;
(statearr_63258_63307[(2)] = null);

(statearr_63258_63307[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63253 === (1))){
var state_63252__$1 = state_63252;
var statearr_63259_63308 = state_63252__$1;
(statearr_63259_63308[(2)] = null);

(statearr_63259_63308[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63253 === (24))){
var inst_63236 = (state_63252[(2)]);
var state_63252__$1 = state_63252;
var statearr_63260_63309 = state_63252__$1;
(statearr_63260_63309[(2)] = inst_63236);

(statearr_63260_63309[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63253 === (4))){
var inst_63189 = (state_63252[(2)]);
var state_63252__$1 = state_63252;
var statearr_63261_63310 = state_63252__$1;
(statearr_63261_63310[(2)] = inst_63189);

(statearr_63261_63310[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63253 === (15))){
var inst_63205 = (state_63252[(8)]);
var inst_63204 = (state_63252[(2)]);
var inst_63205__$1 = fluree.db.util.async.throw_err(inst_63204);
var state_63252__$1 = (function (){var statearr_63262 = state_63252;
(statearr_63262[(8)] = inst_63205__$1);

return statearr_63262;
})();
if(cljs.core.truth_(inst_63205__$1)){
var statearr_63263_63311 = state_63252__$1;
(statearr_63263_63311[(1)] = (16));

} else {
var statearr_63264_63312 = state_63252__$1;
(statearr_63264_63312[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63253 === (21))){
var inst_63238 = (state_63252[(9)]);
var inst_63238__$1 = (state_63252[(2)]);
var state_63252__$1 = (function (){var statearr_63265 = state_63252;
(statearr_63265[(9)] = inst_63238__$1);

return statearr_63265;
})();
if(cljs.core.truth_(inst_63238__$1)){
var statearr_63266_63313 = state_63252__$1;
(statearr_63266_63313[(1)] = (29));

} else {
var statearr_63267_63314 = state_63252__$1;
(statearr_63267_63314[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63253 === (31))){
var inst_63238 = (state_63252[(9)]);
var inst_63222 = (state_63252[(7)]);
var inst_63246 = (state_63252[(2)]);
var inst_63247 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_63222,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"roles","roles",143379530),inst_63238,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_63246], 0));
var _ = (function (){var statearr_63268 = state_63252;
(statearr_63268[(4)] = cljs.core.rest((state_63252[(4)])));

return statearr_63268;
})();
var state_63252__$1 = state_63252;
var statearr_63269_63315 = state_63252__$1;
(statearr_63269_63315[(2)] = inst_63247);

(statearr_63269_63315[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63253 === (32))){
var inst_63242 = (state_63252[(2)]);
var inst_63243 = fluree.db.util.async.throw_err(inst_63242);
var state_63252__$1 = state_63252;
var statearr_63270_63316 = state_63252__$1;
(statearr_63270_63316[(2)] = inst_63243);

(statearr_63270_63316[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63253 === (13))){
var state_63252__$1 = state_63252;
var statearr_63271_63317 = state_63252__$1;
(statearr_63271_63317[(2)] = null);

(statearr_63271_63317[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63253 === (22))){
var inst_63222 = (state_63252[(7)]);
var inst_63226 = fluree.db.auth.roles(db,inst_63222);
var state_63252__$1 = state_63252;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63252__$1,(25),inst_63226);
} else {
if((state_val_63253 === (29))){
var inst_63238 = (state_63252[(9)]);
var inst_63240 = fluree.db.permissions.permission_map(db,inst_63238,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_63252__$1 = state_63252;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63252__$1,(32),inst_63240);
} else {
if((state_val_63253 === (6))){
var state_63252__$1 = state_63252;
var statearr_63272_63318 = state_63252__$1;
(statearr_63272_63318[(2)] = null);

(statearr_63272_63318[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63253 === (28))){
var inst_63234 = (state_63252[(2)]);
var state_63252__$1 = state_63252;
var statearr_63273_63319 = state_63252__$1;
(statearr_63273_63319[(2)] = inst_63234);

(statearr_63273_63319[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63253 === (25))){
var inst_63228 = (state_63252[(2)]);
var inst_63229 = fluree.db.util.async.throw_err(inst_63228);
var state_63252__$1 = state_63252;
var statearr_63274_63320 = state_63252__$1;
(statearr_63274_63320[(2)] = inst_63229);

(statearr_63274_63320[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63253 === (17))){
var inst_63208 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_63209 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63210 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_63211 = cljs.core.PersistentHashMap.fromArrays(inst_63209,inst_63210);
var inst_63212 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_63208,inst_63211);
var inst_63213 = (function(){throw inst_63212})();
var state_63252__$1 = state_63252;
var statearr_63275_63321 = state_63252__$1;
(statearr_63275_63321[(2)] = inst_63213);

(statearr_63275_63321[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63253 === (3))){
var inst_63250 = (state_63252[(2)]);
var state_63252__$1 = state_63252;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63252__$1,inst_63250);
} else {
if((state_val_63253 === (12))){
var inst_63202 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_63252__$1 = state_63252;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63252__$1,(15),inst_63202);
} else {
if((state_val_63253 === (2))){
var _ = (function (){var statearr_63276 = state_63252;
(statearr_63276[(4)] = cljs.core.cons((5),(state_63252[(4)])));

return statearr_63276;
})();
var inst_63195 = (auth == null);
var state_63252__$1 = state_63252;
if(cljs.core.truth_(inst_63195)){
var statearr_63277_63322 = state_63252__$1;
(statearr_63277_63322[(1)] = (6));

} else {
var statearr_63278_63323 = state_63252__$1;
(statearr_63278_63323[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63253 === (23))){
var state_63252__$1 = state_63252;
var statearr_63279_63324 = state_63252__$1;
(statearr_63279_63324[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63253 === (19))){
var state_63252__$1 = state_63252;
var statearr_63281_63325 = state_63252__$1;
(statearr_63281_63325[(2)] = roles);

(statearr_63281_63325[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63253 === (11))){
var inst_63220 = (state_63252[(2)]);
var state_63252__$1 = state_63252;
var statearr_63283_63326 = state_63252__$1;
(statearr_63283_63326[(2)] = inst_63220);

(statearr_63283_63326[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63253 === (9))){
var state_63252__$1 = state_63252;
var statearr_63284_63327 = state_63252__$1;
(statearr_63284_63327[(2)] = (0));

(statearr_63284_63327[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63253 === (5))){
var _ = (function (){var statearr_63285 = state_63252;
(statearr_63285[(4)] = cljs.core.rest((state_63252[(4)])));

return statearr_63285;
})();
var state_63252__$1 = state_63252;
var ex63282 = (state_63252__$1[(2)]);
var statearr_63286_63328 = state_63252__$1;
(statearr_63286_63328[(5)] = ex63282);


if((ex63282 instanceof Error)){
var statearr_63287_63329 = state_63252__$1;
(statearr_63287_63329[(1)] = (4));

(statearr_63287_63329[(5)] = null);

} else {
throw ex63282;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63253 === (14))){
var inst_63218 = (state_63252[(2)]);
var state_63252__$1 = state_63252;
var statearr_63288_63330 = state_63252__$1;
(statearr_63288_63330[(2)] = inst_63218);

(statearr_63288_63330[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63253 === (26))){
var state_63252__$1 = state_63252;
var statearr_63289_63331 = state_63252__$1;
(statearr_63289_63331[(2)] = null);

(statearr_63289_63331[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63253 === (16))){
var inst_63205 = (state_63252[(8)]);
var state_63252__$1 = state_63252;
var statearr_63290_63332 = state_63252__$1;
(statearr_63290_63332[(2)] = inst_63205);

(statearr_63290_63332[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63253 === (30))){
var state_63252__$1 = state_63252;
var statearr_63291_63333 = state_63252__$1;
(statearr_63291_63333[(2)] = null);

(statearr_63291_63333[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63253 === (10))){
var state_63252__$1 = state_63252;
if(cljs.core.truth_(auth)){
var statearr_63292_63334 = state_63252__$1;
(statearr_63292_63334[(1)] = (12));

} else {
var statearr_63293_63335 = state_63252__$1;
(statearr_63293_63335[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63253 === (18))){
var inst_63215 = (state_63252[(2)]);
var state_63252__$1 = state_63252;
var statearr_63294_63336 = state_63252__$1;
(statearr_63294_63336[(2)] = inst_63215);

(statearr_63294_63336[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63253 === (8))){
var inst_63222 = (state_63252[(2)]);
var state_63252__$1 = (function (){var statearr_63295 = state_63252;
(statearr_63295[(7)] = inst_63222);

return statearr_63295;
})();
if(cljs.core.truth_(roles)){
var statearr_63296_63337 = state_63252__$1;
(statearr_63296_63337[(1)] = (19));

} else {
var statearr_63297_63338 = state_63252__$1;
(statearr_63297_63338[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto____0 = (function (){
var statearr_63298 = [null,null,null,null,null,null,null,null,null,null];
(statearr_63298[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto__);

(statearr_63298[(1)] = (1));

return statearr_63298;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto____1 = (function (state_63252){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_63252);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e63299){var ex__2744__auto__ = e63299;
var statearr_63300_63339 = state_63252;
(statearr_63300_63339[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_63252[(4)]))){
var statearr_63301_63340 = state_63252;
(statearr_63301_63340[(1)] = cljs.core.first((state_63252[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63341 = state_63252;
state_63252 = G__63341;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto__ = function(state_63252){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto____1.call(this,state_63252);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_63302 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_63302[(6)] = c__2763__auto__);

return statearr_63302;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__63342 = db;
var map__63342__$1 = cljs.core.__destructure_map(map__63342);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63342__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63342__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63342__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NEW EVENT:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([evt], 0)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([data], 0))], 0));

if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener(conn,network,dbid,listen_id);

var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_63349){
var state_val_63350 = (state_63349[(1)]);
if((state_val_63350 === (1))){
var inst_63343 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_63344 = fluree.db.session.db(conn,inst_63343,null);
var state_63349__$1 = state_63349;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63349__$1,(2),inst_63344);
} else {
if((state_val_63350 === (2))){
var inst_63346 = (state_63349[(2)]);
var inst_63347 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_63346);
var state_63349__$1 = state_63349;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63349__$1,inst_63347);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____0 = (function (){
var statearr_63351 = [null,null,null,null,null,null,null];
(statearr_63351[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__);

(statearr_63351[(1)] = (1));

return statearr_63351;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____1 = (function (state_63349){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_63349);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e63352){var ex__2744__auto__ = e63352;
var statearr_63353_63380 = state_63349;
(statearr_63353_63380[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_63349[(4)]))){
var statearr_63354_63381 = state_63349;
(statearr_63354_63381[(1)] = cljs.core.first((state_63349[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63382 = state_63349;
state_63349 = G__63382;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__ = function(state_63349){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____1.call(this,state_63349);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_63355 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_63355[(6)] = c__2763__auto__);

return statearr_63355;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener(conn,network,dbid,listen_id,event_fn);

var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_63368){
var state_val_63369 = (state_63368[(1)]);
if((state_val_63369 === (1))){
var inst_63356 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_63357 = fluree.db.session.db(conn,inst_63356,null);
var state_63368__$1 = state_63368;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63368__$1,(2),inst_63357);
} else {
if((state_val_63369 === (2))){
var inst_63359 = (state_63368[(7)]);
var inst_63359__$1 = (state_63368[(2)]);
var inst_63360 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_63359__$1);
var inst_63361 = newer_block_QMARK_(inst_63360);
var state_63368__$1 = (function (){var statearr_63370 = state_63368;
(statearr_63370[(7)] = inst_63359__$1);

return statearr_63370;
})();
if(inst_63361){
var statearr_63371_63383 = state_63368__$1;
(statearr_63371_63383[(1)] = (3));

} else {
var statearr_63372_63384 = state_63368__$1;
(statearr_63372_63384[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63369 === (3))){
var inst_63359 = (state_63368[(7)]);
var inst_63363 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_63359);
var state_63368__$1 = state_63368;
var statearr_63373_63385 = state_63368__$1;
(statearr_63373_63385[(2)] = inst_63363);

(statearr_63373_63385[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63369 === (4))){
var state_63368__$1 = state_63368;
var statearr_63374_63386 = state_63368__$1;
(statearr_63374_63386[(2)] = null);

(statearr_63374_63386[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63369 === (5))){
var inst_63366 = (state_63368[(2)]);
var state_63368__$1 = state_63368;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63368__$1,inst_63366);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____0 = (function (){
var statearr_63375 = [null,null,null,null,null,null,null,null];
(statearr_63375[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__);

(statearr_63375[(1)] = (1));

return statearr_63375;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____1 = (function (state_63368){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_63368);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e63376){var ex__2744__auto__ = e63376;
var statearr_63377_63387 = state_63368;
(statearr_63377_63387[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_63368[(4)]))){
var statearr_63378_63388 = state_63368;
(statearr_63378_63388[(1)] = cljs.core.first((state_63368[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63389 = state_63368;
state_63368 = G__63389;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__ = function(state_63368){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____1.call(this,state_63368);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_63379 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_63379[(6)] = c__2763__auto__);

return statearr_63379;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_(syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var map__63390 = db;
var map__63390__$1 = cljs.core.__destructure_map(map__63390);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63390__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63390__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63390__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var listen_id = fluree.db.util.core.random_uuid();
var timeout = ((cljs.core.pos_int_QMARK_(syncTimeout))?(function (){var x__4339__auto__ = syncTimeout;
var y__4340__auto__ = (120000);
return ((x__4339__auto__ < y__4340__auto__) ? x__4339__auto__ : y__4340__auto__);
})():(60000));
var res_port = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,db);
} else {
fluree.db.api.ledger.syncTo_wait(db,syncTo,listen_id,res_port);

var c__2763__auto___63466 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_63440){
var state_val_63441 = (state_63440[(1)]);
if((state_val_63441 === (7))){
var inst_63406 = (state_63440[(7)]);
var inst_63417 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_63406,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_63440__$1 = state_63440;
if(inst_63417){
var statearr_63442_63467 = state_63440__$1;
(statearr_63442_63467[(1)] = (9));

} else {
var statearr_63443_63468 = state_63440__$1;
(statearr_63443_63468[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63441 === (1))){
var inst_63391 = (state_63440[(8)]);
var inst_63399 = (state_63440[(9)]);
var inst_63391__$1 = cljs.core.async.timeout(timeout);
var inst_63399__$1 = res_port;
var inst_63400 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63401 = [inst_63391__$1,inst_63399__$1];
var inst_63402 = (new cljs.core.PersistentVector(null,2,(5),inst_63400,inst_63401,null));
var state_63440__$1 = (function (){var statearr_63444 = state_63440;
(statearr_63444[(8)] = inst_63391__$1);

(statearr_63444[(9)] = inst_63399__$1);

return statearr_63444;
})();
return cljs.core.async.ioc_alts_BANG_(state_63440__$1,(2),inst_63402);
} else {
if((state_val_63441 === (4))){
var inst_63399 = (state_63440[(9)]);
var inst_63406 = (state_63440[(7)]);
var inst_63410 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_63406,inst_63399);
var state_63440__$1 = state_63440;
if(inst_63410){
var statearr_63445_63469 = state_63440__$1;
(statearr_63445_63469[(1)] = (6));

} else {
var statearr_63446_63470 = state_63440__$1;
(statearr_63446_63470[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63441 === (13))){
var inst_63425 = (state_63440[(10)]);
var inst_63436 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_63425);
var state_63440__$1 = state_63440;
var statearr_63447_63471 = state_63440__$1;
(statearr_63447_63471[(2)] = inst_63436);

(statearr_63447_63471[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63441 === (6))){
var inst_63404 = (state_63440[(11)]);
var inst_63415 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63404,(0),null);
var state_63440__$1 = state_63440;
var statearr_63448_63472 = state_63440__$1;
(statearr_63448_63472[(2)] = inst_63415);

(statearr_63448_63472[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63441 === (3))){
var state_63440__$1 = state_63440;
var statearr_63449_63473 = state_63440__$1;
(statearr_63449_63473[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_63449_63473[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63441 === (12))){
var inst_63429 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_63430 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63431 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_63432 = cljs.core.PersistentHashMap.fromArrays(inst_63430,inst_63431);
var inst_63433 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_63429,inst_63432);
var inst_63434 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_63433);
var state_63440__$1 = state_63440;
var statearr_63450_63474 = state_63440__$1;
(statearr_63450_63474[(2)] = inst_63434);

(statearr_63450_63474[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63441 === (2))){
var inst_63391 = (state_63440[(8)]);
var inst_63406 = (state_63440[(7)]);
var inst_63404 = (state_63440[(11)]);
var inst_63404__$1 = (state_63440[(2)]);
var inst_63405 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63404__$1,(0),null);
var inst_63406__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63404__$1,(1),null);
var inst_63407 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_63406__$1,inst_63391);
var state_63440__$1 = (function (){var statearr_63451 = state_63440;
(statearr_63451[(7)] = inst_63406__$1);

(statearr_63451[(11)] = inst_63404__$1);

(statearr_63451[(12)] = inst_63405);

return statearr_63451;
})();
if(inst_63407){
var statearr_63452_63475 = state_63440__$1;
(statearr_63452_63475[(1)] = (3));

} else {
var statearr_63453_63476 = state_63440__$1;
(statearr_63453_63476[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63441 === (11))){
var inst_63421 = (state_63440[(2)]);
var state_63440__$1 = state_63440;
var statearr_63454_63477 = state_63440__$1;
(statearr_63454_63477[(2)] = inst_63421);

(statearr_63454_63477[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63441 === (9))){
var inst_63405 = (state_63440[(12)]);
var state_63440__$1 = state_63440;
var statearr_63455_63478 = state_63440__$1;
(statearr_63455_63478[(2)] = inst_63405);

(statearr_63455_63478[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63441 === (5))){
var inst_63425 = (state_63440[(10)]);
var inst_63425__$1 = (state_63440[(2)]);
var inst_63426 = fluree.db.connection.remove_listener(conn,network,dbid,listen_id);
var inst_63427 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_63425__$1);
var state_63440__$1 = (function (){var statearr_63456 = state_63440;
(statearr_63456[(13)] = inst_63426);

(statearr_63456[(10)] = inst_63425__$1);

return statearr_63456;
})();
if(inst_63427){
var statearr_63457_63479 = state_63440__$1;
(statearr_63457_63479[(1)] = (12));

} else {
var statearr_63458_63480 = state_63440__$1;
(statearr_63458_63480[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63441 === (14))){
var inst_63438 = (state_63440[(2)]);
var state_63440__$1 = state_63440;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63440__$1,inst_63438);
} else {
if((state_val_63441 === (10))){
var state_63440__$1 = state_63440;
var statearr_63459_63481 = state_63440__$1;
(statearr_63459_63481[(2)] = null);

(statearr_63459_63481[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63441 === (8))){
var inst_63423 = (state_63440[(2)]);
var state_63440__$1 = state_63440;
var statearr_63460_63482 = state_63440__$1;
(statearr_63460_63482[(2)] = inst_63423);

(statearr_63460_63482[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto____0 = (function (){
var statearr_63461 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63461[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto__);

(statearr_63461[(1)] = (1));

return statearr_63461;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto____1 = (function (state_63440){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_63440);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e63462){var ex__2744__auto__ = e63462;
var statearr_63463_63483 = state_63440;
(statearr_63463_63483[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_63440[(4)]))){
var statearr_63464_63484 = state_63440;
(statearr_63464_63484[(1)] = cljs.core.first((state_63440[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63485 = state_63440;
state_63440 = G__63485;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto__ = function(state_63440){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto____1.call(this,state_63440);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_63465 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_63465[(6)] = c__2763__auto___63466);

return statearr_63465;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__63487 = arguments.length;
switch (G__63487) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__63488){
var map__63489 = p__63488;
var map__63489__$1 = cljs.core.__destructure_map(map__63489);
var opts = map__63489__$1;
var roles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63489__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63489__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63489__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63489__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63489__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2763__auto___63578 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_63540){
var state_val_63541 = (state_63540[(1)]);
if((state_val_63541 === (7))){
var inst_63502 = (state_63540[(7)]);
var inst_63504 = fluree.db.api.ledger.syncTo_db(inst_63502,syncTo,syncTimeout);
var state_63540__$1 = state_63540;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63540__$1,(10),inst_63504);
} else {
if((state_val_63541 === (20))){
var inst_63526 = (state_63540[(8)]);
var state_63540__$1 = state_63540;
var statearr_63542_63579 = state_63540__$1;
(statearr_63542_63579[(2)] = inst_63526);

(statearr_63542_63579[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63541 === (1))){
var state_63540__$1 = state_63540;
var statearr_63543_63580 = state_63540__$1;
(statearr_63543_63580[(2)] = null);

(statearr_63543_63580[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63541 === (4))){
var inst_63490 = (state_63540[(2)]);
var inst_63491 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_63490);
var inst_63492 = cljs.core.async.close_BANG_(pc);
var state_63540__$1 = (function (){var statearr_63544 = state_63540;
(statearr_63544[(9)] = inst_63491);

return statearr_63544;
})();
var statearr_63545_63581 = state_63540__$1;
(statearr_63545_63581[(2)] = inst_63492);

(statearr_63545_63581[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63541 === (15))){
var inst_63518 = (state_63540[(10)]);
var inst_63520 = fluree.db.api.ledger.add_db_permissions(inst_63518,auth,roles);
var state_63540__$1 = state_63540;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63540__$1,(18),inst_63520);
} else {
if((state_val_63541 === (21))){
var inst_63534 = (state_63540[(2)]);
var inst_63535 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_63534);
var _ = (function (){var statearr_63546 = state_63540;
(statearr_63546[(4)] = cljs.core.rest((state_63540[(4)])));

return statearr_63546;
})();
var state_63540__$1 = state_63540;
var statearr_63547_63582 = state_63540__$1;
(statearr_63547_63582[(2)] = inst_63535);

(statearr_63547_63582[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63541 === (13))){
var inst_63518 = (state_63540[(2)]);
var state_63540__$1 = (function (){var statearr_63548 = state_63540;
(statearr_63548[(10)] = inst_63518);

return statearr_63548;
})();
if(cljs.core.truth_(roles)){
var statearr_63549_63583 = state_63540__$1;
(statearr_63549_63583[(1)] = (15));

} else {
var statearr_63550_63584 = state_63540__$1;
(statearr_63550_63584[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63541 === (22))){
var inst_63530 = (state_63540[(2)]);
var inst_63531 = fluree.db.util.async.throw_err(inst_63530);
var state_63540__$1 = state_63540;
var statearr_63551_63585 = state_63540__$1;
(statearr_63551_63585[(2)] = inst_63531);

(statearr_63551_63585[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63541 === (6))){
var inst_63501 = (state_63540[(2)]);
var inst_63502 = fluree.db.util.async.throw_err(inst_63501);
var state_63540__$1 = (function (){var statearr_63552 = state_63540;
(statearr_63552[(7)] = inst_63502);

return statearr_63552;
})();
if(cljs.core.truth_(syncTo)){
var statearr_63553_63586 = state_63540__$1;
(statearr_63553_63586[(1)] = (7));

} else {
var statearr_63554_63587 = state_63540__$1;
(statearr_63554_63587[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63541 === (17))){
var inst_63526 = (state_63540[(2)]);
var state_63540__$1 = (function (){var statearr_63555 = state_63540;
(statearr_63555[(8)] = inst_63526);

return statearr_63555;
})();
if(cljs.core.truth_(auth)){
var statearr_63556_63588 = state_63540__$1;
(statearr_63556_63588[(1)] = (19));

} else {
var statearr_63557_63589 = state_63540__$1;
(statearr_63557_63589[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63541 === (3))){
var inst_63538 = (state_63540[(2)]);
var state_63540__$1 = state_63540;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63540__$1,inst_63538);
} else {
if((state_val_63541 === (12))){
var inst_63510 = (state_63540[(11)]);
var state_63540__$1 = state_63540;
var statearr_63558_63590 = state_63540__$1;
(statearr_63558_63590[(2)] = inst_63510);

(statearr_63558_63590[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63541 === (2))){
var _ = (function (){var statearr_63559 = state_63540;
(statearr_63559[(4)] = cljs.core.cons((5),(state_63540[(4)])));

return statearr_63559;
})();
var inst_63499 = fluree.db.session.db(conn,ledger,opts_SINGLEQUOTE_);
var state_63540__$1 = state_63540;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63540__$1,(6),inst_63499);
} else {
if((state_val_63541 === (19))){
var inst_63526 = (state_63540[(8)]);
var inst_63528 = fluree.db.api.ledger.add_db_permissions(inst_63526,auth,roles);
var state_63540__$1 = state_63540;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63540__$1,(22),inst_63528);
} else {
if((state_val_63541 === (11))){
var inst_63510 = (state_63540[(11)]);
var inst_63512 = fluree.db.time_travel.as_of_block(inst_63510,block);
var state_63540__$1 = state_63540;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63540__$1,(14),inst_63512);
} else {
if((state_val_63541 === (9))){
var inst_63510 = (state_63540[(2)]);
var state_63540__$1 = (function (){var statearr_63561 = state_63540;
(statearr_63561[(11)] = inst_63510);

return statearr_63561;
})();
if(cljs.core.truth_(block)){
var statearr_63562_63591 = state_63540__$1;
(statearr_63562_63591[(1)] = (11));

} else {
var statearr_63563_63592 = state_63540__$1;
(statearr_63563_63592[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63541 === (5))){
var _ = (function (){var statearr_63564 = state_63540;
(statearr_63564[(4)] = cljs.core.rest((state_63540[(4)])));

return statearr_63564;
})();
var state_63540__$1 = state_63540;
var ex63560 = (state_63540__$1[(2)]);
var statearr_63565_63593 = state_63540__$1;
(statearr_63565_63593[(5)] = ex63560);


var statearr_63566_63594 = state_63540__$1;
(statearr_63566_63594[(1)] = (4));

(statearr_63566_63594[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63541 === (14))){
var inst_63514 = (state_63540[(2)]);
var inst_63515 = fluree.db.util.async.throw_err(inst_63514);
var state_63540__$1 = state_63540;
var statearr_63567_63595 = state_63540__$1;
(statearr_63567_63595[(2)] = inst_63515);

(statearr_63567_63595[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63541 === (16))){
var inst_63518 = (state_63540[(10)]);
var state_63540__$1 = state_63540;
var statearr_63568_63596 = state_63540__$1;
(statearr_63568_63596[(2)] = inst_63518);

(statearr_63568_63596[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63541 === (10))){
var inst_63506 = (state_63540[(2)]);
var inst_63507 = fluree.db.util.async.throw_err(inst_63506);
var state_63540__$1 = state_63540;
var statearr_63569_63597 = state_63540__$1;
(statearr_63569_63597[(2)] = inst_63507);

(statearr_63569_63597[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63541 === (18))){
var inst_63522 = (state_63540[(2)]);
var inst_63523 = fluree.db.util.async.throw_err(inst_63522);
var state_63540__$1 = state_63540;
var statearr_63570_63598 = state_63540__$1;
(statearr_63570_63598[(2)] = inst_63523);

(statearr_63570_63598[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63541 === (8))){
var inst_63502 = (state_63540[(7)]);
var state_63540__$1 = state_63540;
var statearr_63571_63599 = state_63540__$1;
(statearr_63571_63599[(2)] = inst_63502);

(statearr_63571_63599[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2741__auto__ = null;
var fluree$db$api$ledger$state_machine__2741__auto____0 = (function (){
var statearr_63572 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63572[(0)] = fluree$db$api$ledger$state_machine__2741__auto__);

(statearr_63572[(1)] = (1));

return statearr_63572;
});
var fluree$db$api$ledger$state_machine__2741__auto____1 = (function (state_63540){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_63540);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e63573){var ex__2744__auto__ = e63573;
var statearr_63574_63600 = state_63540;
(statearr_63574_63600[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_63540[(4)]))){
var statearr_63575_63601 = state_63540;
(statearr_63575_63601[(1)] = cljs.core.first((state_63540[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63602 = state_63540;
state_63540 = G__63602;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2741__auto__ = function(state_63540){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2741__auto____1.call(this,state_63540);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2741__auto____0;
fluree$db$api$ledger$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2741__auto____1;
return fluree$db$api$ledger$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_63576 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_63576[(6)] = c__2763__auto___63578);

return statearr_63576;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

