// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
fluree.db.util.xhttp.node$module$axios = require('axios');
fluree.db.util.xhttp.node$module$ws = require('ws');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5753__auto__ = e.response;
if(cljs.core.truth_(temp__5753__auto__)){
var resp = temp__5753__auto__;
var temp__5753__auto____$1 = resp.status;
if(cljs.core.truth_(temp__5753__auto____$1)){
var st = temp__5753__auto____$1;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
})();
var error = ((clojure.string.starts_with_QMARK_.call(null,e.message,"timeout"))?new cljs.core.Keyword("xhttp","timeout","xhttp/timeout",357433562):(cljs.core.truth_((function (){var and__4251__auto__ = status;
if(cljs.core.truth_(and__4251__auto__)){
return ((((300) <= status)) && ((status <= (499))));
} else {
return and__4251__auto__;
}
})())?new cljs.core.Keyword("xhttp","http-error","xhttp/http-error",-960604305):(cljs.core.truth_((function (){var and__4251__auto__ = status;
if(cljs.core.truth_(and__4251__auto__)){
return (status >= (500));
} else {
return and__4251__auto__;
}
})())?new cljs.core.Keyword("xhttp","exception","xhttp/exception",1363682040):(function (){
fluree.db.util.log.error.call(null,"XHTTP Request Error:",e.request);

return new cljs.core.Keyword("xhttp","unknown-error","xhttp/unknown-error",693274399);
})()

)));
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4251__auto__ = status;
if(cljs.core.truth_(and__4251__auto__)){
return (status > (0));
} else {
return and__4251__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.call(null,message,(function (){var G__29822 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.call(null,G__29822,new cljs.core.Keyword(null,"status","status",-1997798413),status);
} else {
return G__29822;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__29823 = opts;
var map__29823__$1 = cljs.core.__destructure_map.call(null,map__29823);
var request_timeout = cljs.core.get.call(null,map__29823__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.call(null,map__29823__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.call(null,map__29823__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var response_chan = cljs.core.async.chan.call(null);
var headers__$1 = (function (){var G__29824 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__29824__$1 = (cljs.core.truth_(headers)?cljs.core.merge.call(null,G__29824,headers):G__29824);
if(cljs.core.truth_(token)){
return cljs.core.assoc.call(null,G__29824__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__29824__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"post",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1,new cljs.core.Keyword(null,"data","data",-232669377),message], null))).then((function (resp){
return cljs.core.async.put_BANG_.call(null,response_chan,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.call(null,resp,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true)));
})).catch((function (err){
return cljs.core.async.put_BANG_.call(null,response_chan,fluree.db.util.xhttp.format_error_response.call(null,url,err));
}));

return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__29825 = opts;
var map__29825__$1 = cljs.core.__destructure_map.call(null,map__29825);
var request_timeout = cljs.core.get.call(null,map__29825__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.call(null,map__29825__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.call(null,map__29825__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.call(null,map__29825__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var output_format = cljs.core.get.call(null,map__29825__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"text","text",-1790561697));
var response_chan = cljs.core.async.chan.call(null);
var headers__$1 = (function (){var G__29826 = cljs.core.PersistentArrayMap.EMPTY;
var G__29826__$1 = (cljs.core.truth_(headers)?cljs.core.merge.call(null,G__29826,headers):G__29826);
if(cljs.core.truth_(token)){
return cljs.core.assoc.call(null,G__29826__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__29826__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"get",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1], null))).then((function (resp){
var data = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.call(null,resp,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true));
return cljs.core.async.put_BANG_.call(null,response_chan,(function (){var G__29827 = output_format;
var G__29827__$1 = (((G__29827 instanceof cljs.core.Keyword))?G__29827.fqn:null);
switch (G__29827__$1) {
case "text":
return data;

break;
case "json":
return fluree.db.util.json.stringify.call(null,data);

break;
default:
throw cljs.core.ex_info.call(null,"http get only supports output formats of json and text.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
})).catch((function (err){
return cljs.core.async.put_BANG_.call(null,response_chan,fluree.db.util.xhttp.format_error_response.call(null,url,err));
}));

return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__29829 = cljs.core.assoc.call(null,cljs.core.assoc_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Accept"], null),"application/json"),new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"json","json",1279968570));
if(cljs.core.truth_(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.call(null,G__29829,new cljs.core.Keyword(null,"body","body",-2049205669),fluree.db.util.json.stringify.call(null,new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__29829;
}
})();
return fluree.db.util.xhttp.get.call(null,url,opts_STAR_);
});
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_29861){
var state_val_29862 = (state_29861[(1)]);
if((state_val_29862 === (7))){
var inst_29857 = (state_29861[(2)]);
var state_29861__$1 = state_29861;
var statearr_29863_29888 = state_29861__$1;
(statearr_29863_29888[(2)] = inst_29857);

(statearr_29863_29888[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29862 === (1))){
var state_29861__$1 = state_29861;
var statearr_29864_29889 = state_29861__$1;
(statearr_29864_29889[(2)] = null);

(statearr_29864_29889[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29862 === (4))){
var inst_29832 = (state_29861[(7)]);
var inst_29832__$1 = (state_29861[(2)]);
var inst_29833 = (inst_29832__$1 == null);
var state_29861__$1 = (function (){var statearr_29865 = state_29861;
(statearr_29865[(7)] = inst_29832__$1);

return statearr_29865;
})();
if(cljs.core.truth_(inst_29833)){
var statearr_29866_29890 = state_29861__$1;
(statearr_29866_29890[(1)] = (5));

} else {
var statearr_29867_29891 = state_29861__$1;
(statearr_29867_29891[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29862 === (6))){
var inst_29832 = (state_29861[(7)]);
var inst_29840 = cljs.core.nth.call(null,inst_29832,(0),null);
var inst_29841 = cljs.core.nth.call(null,inst_29832,(1),null);
var state_29861__$1 = (function (){var statearr_29868 = state_29861;
(statearr_29868[(8)] = inst_29841);

(statearr_29868[(9)] = inst_29840);

return statearr_29868;
})();
var statearr_29869_29892 = state_29861__$1;
(statearr_29869_29892[(2)] = null);

(statearr_29869_29892[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29862 === (3))){
var inst_29859 = (state_29861[(2)]);
var state_29861__$1 = state_29861;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29861__$1,inst_29859);
} else {
if((state_val_29862 === (2))){
var state_29861__$1 = state_29861;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29861__$1,(4),pub_chan);
} else {
if((state_val_29862 === (11))){
var _ = (function (){var statearr_29871 = state_29861;
(statearr_29871[(4)] = cljs.core.rest.call(null,(state_29861[(4)])));

return statearr_29871;
})();
var state_29861__$1 = state_29861;
var ex29870 = (state_29861__$1[(2)]);
var statearr_29872_29893 = state_29861__$1;
(statearr_29872_29893[(5)] = ex29870);


var statearr_29873_29894 = state_29861__$1;
(statearr_29873_29894[(1)] = (10));

(statearr_29873_29894[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29862 === (9))){
var inst_29854 = (state_29861[(2)]);
var state_29861__$1 = (function (){var statearr_29874 = state_29861;
(statearr_29874[(10)] = inst_29854);

return statearr_29874;
})();
var statearr_29875_29895 = state_29861__$1;
(statearr_29875_29895[(2)] = null);

(statearr_29875_29895[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29862 === (5))){
var inst_29835 = fluree.db.util.log.info.call(null,"Web socket pub/producer channel closed.");
var state_29861__$1 = state_29861;
var statearr_29876_29896 = state_29861__$1;
(statearr_29876_29896[(2)] = inst_29835);

(statearr_29876_29896[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29862 === (10))){
var inst_29841 = (state_29861[(8)]);
var inst_29840 = (state_29861[(9)]);
var inst_29842 = (state_29861[(2)]);
var inst_29843 = fluree.db.util.log.error.call(null,inst_29842,"Error sending websocket message:",inst_29840);
var inst_29844 = cljs.core.async.put_BANG_.call(null,inst_29841,false);
var state_29861__$1 = (function (){var statearr_29877 = state_29861;
(statearr_29877[(11)] = inst_29843);

return statearr_29877;
})();
var statearr_29878_29897 = state_29861__$1;
(statearr_29878_29897[(2)] = inst_29844);

(statearr_29878_29897[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29862 === (8))){
var inst_29841 = (state_29861[(8)]);
var inst_29840 = (state_29861[(9)]);
var _ = (function (){var statearr_29879 = state_29861;
(statearr_29879[(4)] = cljs.core.cons.call(null,(11),(state_29861[(4)])));

return statearr_29879;
})();
var inst_29850 = ws.send(inst_29840);
var inst_29851 = cljs.core.async.put_BANG_.call(null,inst_29841,true);
var ___$1 = (function (){var statearr_29880 = state_29861;
(statearr_29880[(4)] = cljs.core.rest.call(null,(state_29861[(4)])));

return statearr_29880;
})();
var state_29861__$1 = (function (){var statearr_29881 = state_29861;
(statearr_29881[(12)] = inst_29850);

return statearr_29881;
})();
var statearr_29882_29898 = state_29861__$1;
(statearr_29882_29898[(2)] = inst_29851);

(statearr_29882_29898[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10903__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10903__auto____0 = (function (){
var statearr_29883 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29883[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10903__auto__);

(statearr_29883[(1)] = (1));

return statearr_29883;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10903__auto____1 = (function (state_29861){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_29861);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e29884){var ex__10906__auto__ = e29884;
var statearr_29885_29899 = state_29861;
(statearr_29885_29899[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_29861[(4)]))){
var statearr_29886_29900 = state_29861;
(statearr_29886_29900[(1)] = cljs.core.first.call(null,(state_29861[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29901 = state_29861;
state_29861 = G__29901;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10903__auto__ = function(state_29861){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10903__auto____1.call(this,state_29861);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10903__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10903__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_29887 = f__10977__auto__.call(null);
(statearr_29887[(6)] = c__10976__auto__);

return statearr_29887;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (((cljs.core._STAR_target_STAR_ === "nodejs"))?(new fluree.db.util.xhttp.node$module$ws(url)):(new WebSocket(url)));
var open_QMARK_ = cljs.core.async.promise_chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.call(null,open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.call(null,sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.call(null,"Websocket closed: ",e.reason,"Code: ",e.code);

return close_fn.call(null);
}));

var c__10976__auto___29939 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_29926){
var state_val_29927 = (state_29926[(1)]);
if((state_val_29927 === (1))){
var inst_29905 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29906 = [open_QMARK_,timeout_chan];
var inst_29907 = (new cljs.core.PersistentVector(null,2,(5),inst_29905,inst_29906,null));
var state_29926__$1 = state_29926;
return cljs.core.async.ioc_alts_BANG_.call(null,state_29926__$1,(2),inst_29907,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_29927 === (2))){
var inst_29909 = (state_29926[(2)]);
var inst_29910 = cljs.core.nth.call(null,inst_29909,(0),null);
var inst_29911 = cljs.core.nth.call(null,inst_29909,(1),null);
var inst_29912 = cljs.core._EQ_.call(null,inst_29911,timeout_chan);
var state_29926__$1 = (function (){var statearr_29928 = state_29926;
(statearr_29928[(7)] = inst_29910);

return statearr_29928;
})();
if(inst_29912){
var statearr_29929_29940 = state_29926__$1;
(statearr_29929_29940[(1)] = (3));

} else {
var statearr_29930_29941 = state_29926__$1;
(statearr_29930_29941[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29927 === (3))){
var inst_29914 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_29915 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29916 = [(400),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_29917 = cljs.core.PersistentHashMap.fromArrays(inst_29915,inst_29916);
var inst_29918 = cljs.core.ex_info.call(null,inst_29914,inst_29917);
var inst_29919 = cljs.core.async.put_BANG_.call(null,resp_chan,inst_29918);
var inst_29920 = fluree.db.util.xhttp.close_websocket.call(null,ws);
var state_29926__$1 = (function (){var statearr_29931 = state_29926;
(statearr_29931[(8)] = inst_29919);

return statearr_29931;
})();
var statearr_29932_29942 = state_29926__$1;
(statearr_29932_29942[(2)] = inst_29920);

(statearr_29932_29942[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29927 === (4))){
var inst_29922 = fluree.db.util.xhttp.socket_publish_loop.call(null,ws,pub_chan);
var state_29926__$1 = state_29926;
var statearr_29933_29943 = state_29926__$1;
(statearr_29933_29943[(2)] = inst_29922);

(statearr_29933_29943[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29927 === (5))){
var inst_29924 = (state_29926[(2)]);
var state_29926__$1 = state_29926;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29926__$1,inst_29924);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__10903__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__10903__auto____0 = (function (){
var statearr_29934 = [null,null,null,null,null,null,null,null,null];
(statearr_29934[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__10903__auto__);

(statearr_29934[(1)] = (1));

return statearr_29934;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__10903__auto____1 = (function (state_29926){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_29926);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e29935){var ex__10906__auto__ = e29935;
var statearr_29936_29944 = state_29926;
(statearr_29936_29944[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_29926[(4)]))){
var statearr_29937_29945 = state_29926;
(statearr_29937_29945[(1)] = cljs.core.first.call(null,(state_29926[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29946 = state_29926;
state_29926 = G__29946;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__10903__auto__ = function(state_29926){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__10903__auto____1.call(this,state_29926);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__10903__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__10903__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_29938 = f__10977__auto__.call(null);
(statearr_29938[(6)] = c__10976__auto___29939);

return statearr_29938;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));


return new cljs.core.Keyword("fluree.db.util.xhttp","no-return","fluree.db.util.xhttp/no-return",1591333002);
});
