// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k38110,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__38114 = k38110;
var G__38114__$1 = (((G__38114 instanceof cljs.core.Keyword))?G__38114.fqn:null);
switch (G__38114__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k38110,else__4505__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4525__auto__,p__38115){
var vec__38116 = p__38115;
var k__4526__auto__ = cljs.core.nth.call(null,vec__38116,(0),null);
var v__4527__auto__ = cljs.core.nth.call(null,vec__38116,(1),null);
return f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__);
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.session.DbSession{",", ","}",opts__4519__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__38109){
var self__ = this;
var G__38109__$1 = this;
return (new cljs.core.RecordIter((0),G__38109__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (11 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (coll__4499__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll.call(null,coll__4499__auto__));
}).call(null,this__4498__auto____$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this38111,other38112){
var self__ = this;
var this38111__$1 = this;
return (((!((other38112 == null)))) && ((((this38111__$1.constructor === other38112.constructor)) && (((cljs.core._EQ_.call(null,this38111__$1.conn,other38112.conn)) && (((cljs.core._EQ_.call(null,this38111__$1.network,other38112.network)) && (((cljs.core._EQ_.call(null,this38111__$1.dbid,other38112.dbid)) && (((cljs.core._EQ_.call(null,this38111__$1.db_name,other38112.db_name)) && (((cljs.core._EQ_.call(null,this38111__$1.update_chan,other38112.update_chan)) && (((cljs.core._EQ_.call(null,this38111__$1.transact_chan,other38112.transact_chan)) && (((cljs.core._EQ_.call(null,this38111__$1.state,other38112.state)) && (((cljs.core._EQ_.call(null,this38111__$1.schema_cache,other38112.schema_cache)) && (((cljs.core._EQ_.call(null,this38111__$1.blank_db,other38112.blank_db)) && (((cljs.core._EQ_.call(null,this38111__$1.close,other38112.close)) && (((cljs.core._EQ_.call(null,this38111__$1.id,other38112.id)) && (cljs.core._EQ_.call(null,this38111__$1.__extmap,other38112.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k38110){
var self__ = this;
var this__4509__auto____$1 = this;
var G__38119 = k38110;
var G__38119__$1 = (((G__38119 instanceof cljs.core.Keyword))?G__38119.fqn:null);
switch (G__38119__$1) {
case "conn":
case "network":
case "dbid":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k38110);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__38109){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__38120 = cljs.core.keyword_identical_QMARK_;
var expr__38121 = k__4511__auto__;
if(cljs.core.truth_(pred__38120.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__38121))){
return (new fluree.db.session.DbSession(G__38109,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38120.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__38121))){
return (new fluree.db.session.DbSession(self__.conn,G__38109,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38120.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__38121))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__38109,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38120.call(null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),expr__38121))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__38109,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38120.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),expr__38121))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__38109,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38120.call(null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),expr__38121))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__38109,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38120.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__38121))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__38109,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38120.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__38121))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__38109,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38120.call(null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),expr__38121))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__38109,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38120.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__38121))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__38109,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38120.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__38121))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__38109,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4511__auto__,G__38109),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__38109){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__38109,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4508__auto__,(0)),cljs.core._nth.call(null,entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write.call(null,writer__4547__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__38113){
var extmap__4542__auto__ = (function (){var G__38123 = cljs.core.dissoc.call(null,G__38113,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092));
if(cljs.core.record_QMARK_.call(null,G__38113)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__38123);
} else {
return G__38123;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__38113),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__38113),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__38113),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__38113),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__38113),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__38113),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__38113),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__38113),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__38113),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__38113),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__38113),null,cljs.core.not_empty.call(null,extmap__4542__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.call(null,fluree.db.session.cache_factory.call(null));
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__38126 = session;
var map__38126__$1 = cljs.core.__destructure_map.call(null,map__38126);
var network = cljs.core.get.call(null,map__38126__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__38126__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.call(null,c,cache_key))){
return c;
} else {
return cljs.core.assoc.call(null,c,cache_key,session);
}
}));

return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_.call(null,fluree.db.session.session_cache,fluree.db.session.cache_factory.call(null));
});
fluree.db.session.full_load_existing_db = (function fluree$db$session$full_load_existing_db(session){
var pc = cljs.core.async.promise_chan.call(null);
var c__10976__auto___38277 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_38229){
var state_val_38230 = (state_38229[(1)]);
if((state_val_38230 === (7))){
var inst_38147 = (state_38229[(7)]);
var inst_38152 = cljs.core.empty_QMARK_.call(null,inst_38147);
var state_38229__$1 = state_38229;
if(inst_38152){
var statearr_38231_38278 = state_38229__$1;
(statearr_38231_38278[(1)] = (10));

} else {
var statearr_38232_38279 = state_38229__$1;
(statearr_38232_38279[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38230 === (20))){
var inst_38178 = (state_38229[(8)]);
var inst_38139 = (state_38229[(9)]);
var inst_38140 = (state_38229[(10)]);
var inst_38138 = (state_38229[(11)]);
var inst_38183 = fluree.db.storage.core.read_block.call(null,inst_38138,inst_38139,inst_38140,inst_38178);
var state_38229__$1 = state_38229;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38229__$1,(22),inst_38183);
} else {
if((state_val_38230 === (27))){
var inst_38216 = (state_38229[(12)]);
var inst_38218 = (state_38229[(2)]);
var inst_38219 = fluree.db.util.async.throw_err.call(null,inst_38218);
var state_38229__$1 = (function (){var statearr_38233 = state_38229;
(statearr_38233[(13)] = inst_38219);

return statearr_38233;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38229__$1,(28),inst_38216);
} else {
if((state_val_38230 === (1))){
var state_38229__$1 = state_38229;
var statearr_38234_38280 = state_38229__$1;
(statearr_38234_38280[(2)] = null);

(statearr_38234_38280[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38230 === (24))){
var inst_38178 = (state_38229[(8)]);
var inst_38139 = (state_38229[(9)]);
var inst_38140 = (state_38229[(10)]);
var inst_38200 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38178)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38139),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38140),"."].join('');
var inst_38201 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_38202 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_38203 = cljs.core.PersistentHashMap.fromArrays(inst_38201,inst_38202);
var inst_38204 = cljs.core.ex_info.call(null,inst_38200,inst_38203);
var inst_38205 = (function(){throw inst_38204})();
var state_38229__$1 = state_38229;
var statearr_38235_38281 = state_38229__$1;
(statearr_38235_38281[(2)] = inst_38205);

(statearr_38235_38281[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38230 === (4))){
var inst_38127 = (state_38229[(2)]);
var inst_38128 = cljs.core.async.put_BANG_.call(null,pc,inst_38127);
var state_38229__$1 = state_38229;
var statearr_38236_38282 = state_38229__$1;
(statearr_38236_38282[(2)] = inst_38128);

(statearr_38236_38282[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38230 === (15))){
var state_38229__$1 = state_38229;
var statearr_38237_38283 = state_38229__$1;
(statearr_38237_38283[(2)] = null);

(statearr_38237_38283[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38230 === (21))){
var inst_38209 = (state_38229[(2)]);
var state_38229__$1 = state_38229;
var statearr_38238_38284 = state_38229__$1;
(statearr_38238_38284[(2)] = inst_38209);

(statearr_38238_38284[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38230 === (13))){
var inst_38172 = (state_38229[(14)]);
var inst_38147 = (state_38229[(7)]);
var inst_38171 = (state_38229[(2)]);
var inst_38172__$1 = fluree.db.util.async.throw_err.call(null,inst_38171);
var inst_38173 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_38147);
var state_38229__$1 = (function (){var statearr_38239 = state_38229;
(statearr_38239[(15)] = inst_38173);

(statearr_38239[(14)] = inst_38172__$1);

return statearr_38239;
})();
if(cljs.core.truth_(inst_38172__$1)){
var statearr_38240_38285 = state_38229__$1;
(statearr_38240_38285[(1)] = (14));

} else {
var statearr_38241_38286 = state_38229__$1;
(statearr_38241_38286[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38230 === (22))){
var inst_38186 = (state_38229[(16)]);
var inst_38185 = (state_38229[(2)]);
var inst_38186__$1 = fluree.db.util.async.throw_err.call(null,inst_38185);
var state_38229__$1 = (function (){var statearr_38242 = state_38229;
(statearr_38242[(16)] = inst_38186__$1);

return statearr_38242;
})();
if(cljs.core.truth_(inst_38186__$1)){
var statearr_38243_38287 = state_38229__$1;
(statearr_38243_38287[(1)] = (23));

} else {
var statearr_38244_38288 = state_38229__$1;
(statearr_38244_38288[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38230 === (6))){
var inst_38147 = (state_38229[(7)]);
var inst_38146 = (state_38229[(2)]);
var inst_38147__$1 = fluree.db.util.async.throw_err.call(null,inst_38146);
var inst_38148 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_38147__$1);
var inst_38149 = cljs.core.keyword.call(null,inst_38148);
var inst_38150 = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"ready","ready",1086465795),inst_38149);
var state_38229__$1 = (function (){var statearr_38245 = state_38229;
(statearr_38245[(7)] = inst_38147__$1);

return statearr_38245;
})();
if(inst_38150){
var statearr_38246_38289 = state_38229__$1;
(statearr_38246_38289[(1)] = (7));

} else {
var statearr_38247_38290 = state_38229__$1;
(statearr_38247_38290[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38230 === (28))){
var inst_38219 = (state_38229[(13)]);
var inst_38214 = (state_38229[(17)]);
var inst_38221 = (state_38229[(2)]);
var inst_38222 = fluree.db.util.async.throw_err.call(null,inst_38221);
var inst_38223 = cljs.core.assoc.call(null,inst_38214,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_38219,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_38222);
var inst_38224 = cljs.core.async.put_BANG_.call(null,pc,inst_38223);
var _ = (function (){var statearr_38248 = state_38229;
(statearr_38248[(4)] = cljs.core.rest.call(null,(state_38229[(4)])));

return statearr_38248;
})();
var state_38229__$1 = state_38229;
var statearr_38249_38291 = state_38229__$1;
(statearr_38249_38291[(2)] = inst_38224);

(statearr_38249_38291[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38230 === (25))){
var inst_38207 = (state_38229[(2)]);
var state_38229__$1 = state_38229;
var statearr_38250_38292 = state_38229__$1;
(statearr_38250_38292[(2)] = inst_38207);

(statearr_38250_38292[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38230 === (17))){
var inst_38178 = (state_38229[(8)]);
var inst_38173 = (state_38229[(15)]);
var inst_38180 = (inst_38178 > inst_38173);
var state_38229__$1 = state_38229;
if(cljs.core.truth_(inst_38180)){
var statearr_38251_38293 = state_38229__$1;
(statearr_38251_38293[(1)] = (19));

} else {
var statearr_38252_38294 = state_38229__$1;
(statearr_38252_38294[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38230 === (3))){
var inst_38227 = (state_38229[(2)]);
var state_38229__$1 = state_38229;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38229__$1,inst_38227);
} else {
if((state_val_38230 === (12))){
var inst_38159 = (state_38229[(2)]);
var inst_38160 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_38161 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_38162 = cljs.core.PersistentHashMap.fromArrays(inst_38160,inst_38161);
var inst_38163 = cljs.core.ex_info.call(null,inst_38159,inst_38162);
var inst_38164 = (function(){throw inst_38163})();
var state_38229__$1 = state_38229;
var statearr_38253_38295 = state_38229__$1;
(statearr_38253_38295[(2)] = inst_38164);

(statearr_38253_38295[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38230 === (2))){
var inst_38139 = (state_38229[(9)]);
var inst_38140 = (state_38229[(10)]);
var inst_38138 = (state_38229[(11)]);
var _ = (function (){var statearr_38254 = state_38229;
(statearr_38254[(4)] = cljs.core.cons.call(null,(5),(state_38229[(4)])));

return statearr_38254;
})();
var inst_38135 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
var inst_38136 = session;
var inst_38137 = cljs.core.__destructure_map.call(null,inst_38136);
var inst_38138__$1 = cljs.core.get.call(null,inst_38137,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_38139__$1 = cljs.core.get.call(null,inst_38137,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_38140__$1 = cljs.core.get.call(null,inst_38137,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_38141 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38142 = [inst_38139__$1,inst_38140__$1];
var inst_38143 = (new cljs.core.PersistentVector(null,2,(5),inst_38141,inst_38142,null));
var inst_38144 = fluree.db.operations.ledger_info_async.call(null,inst_38138__$1,inst_38143);
var state_38229__$1 = (function (){var statearr_38255 = state_38229;
(statearr_38255[(9)] = inst_38139__$1);

(statearr_38255[(18)] = inst_38135);

(statearr_38255[(10)] = inst_38140__$1);

(statearr_38255[(11)] = inst_38138__$1);

return statearr_38255;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38229__$1,(6),inst_38144);
} else {
if((state_val_38230 === (23))){
var inst_38186 = (state_38229[(16)]);
var inst_38177 = (state_38229[(19)]);
var inst_38189 = cljs.core.__destructure_map.call(null,inst_38186);
var inst_38190 = cljs.core.get.call(null,inst_38189,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_38191 = cljs.core.get.call(null,inst_38189,new cljs.core.Keyword(null,"block","block",664686210));
var inst_38192 = cljs.core.get.call(null,inst_38189,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_38193 = fluree.db.dbproto._with.call(null,inst_38177,inst_38191,inst_38190);
var state_38229__$1 = (function (){var statearr_38256 = state_38229;
(statearr_38256[(20)] = inst_38192);

return statearr_38256;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38229__$1,(26),inst_38193);
} else {
if((state_val_38230 === (19))){
var inst_38177 = (state_38229[(19)]);
var state_38229__$1 = state_38229;
var statearr_38257_38296 = state_38229__$1;
(statearr_38257_38296[(2)] = inst_38177);

(statearr_38257_38296[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38230 === (11))){
var inst_38139 = (state_38229[(9)]);
var inst_38147 = (state_38229[(7)]);
var inst_38140 = (state_38229[(10)]);
var inst_38156 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_38147);
var inst_38157 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38139),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38140)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38156),"."].join('');
var state_38229__$1 = state_38229;
var statearr_38259_38297 = state_38229__$1;
(statearr_38259_38297[(2)] = inst_38157);

(statearr_38259_38297[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38230 === (9))){
var inst_38139 = (state_38229[(9)]);
var inst_38135 = (state_38229[(18)]);
var inst_38147 = (state_38229[(7)]);
var inst_38140 = (state_38229[(10)]);
var inst_38138 = (state_38229[(11)]);
var inst_38167 = (state_38229[(2)]);
var inst_38168 = new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(inst_38147);
var inst_38169 = fluree.db.storage.core.reify_db.call(null,inst_38138,inst_38139,inst_38140,inst_38135,inst_38168);
var state_38229__$1 = (function (){var statearr_38260 = state_38229;
(statearr_38260[(21)] = inst_38167);

return statearr_38260;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38229__$1,(13),inst_38169);
} else {
if((state_val_38230 === (5))){
var _ = (function (){var statearr_38261 = state_38229;
(statearr_38261[(4)] = cljs.core.rest.call(null,(state_38229[(4)])));

return statearr_38261;
})();
var state_38229__$1 = state_38229;
var ex38258 = (state_38229__$1[(2)]);
var statearr_38262_38298 = state_38229__$1;
(statearr_38262_38298[(5)] = ex38258);


var statearr_38263_38299 = state_38229__$1;
(statearr_38263_38299[(1)] = (4));

(statearr_38263_38299[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38230 === (14))){
var inst_38172 = (state_38229[(14)]);
var inst_38175 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_38172);
var inst_38176 = (inst_38175 + (1));
var inst_38177 = inst_38172;
var inst_38178 = inst_38176;
var state_38229__$1 = (function (){var statearr_38264 = state_38229;
(statearr_38264[(8)] = inst_38178);

(statearr_38264[(19)] = inst_38177);

return statearr_38264;
})();
var statearr_38265_38300 = state_38229__$1;
(statearr_38265_38300[(2)] = null);

(statearr_38265_38300[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38230 === (26))){
var inst_38178 = (state_38229[(8)]);
var inst_38195 = (state_38229[(2)]);
var inst_38196 = fluree.db.util.async.throw_err.call(null,inst_38195);
var inst_38197 = (inst_38178 + (1));
var inst_38177 = inst_38196;
var inst_38178__$1 = inst_38197;
var state_38229__$1 = (function (){var statearr_38266 = state_38229;
(statearr_38266[(8)] = inst_38178__$1);

(statearr_38266[(19)] = inst_38177);

return statearr_38266;
})();
var statearr_38267_38301 = state_38229__$1;
(statearr_38267_38301[(2)] = null);

(statearr_38267_38301[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38230 === (16))){
var inst_38214 = (state_38229[(17)]);
var inst_38214__$1 = (state_38229[(2)]);
var inst_38215 = fluree.db.query.schema.schema_map.call(null,inst_38214__$1);
var inst_38216 = fluree.db.query.schema.setting_map.call(null,inst_38214__$1);
var state_38229__$1 = (function (){var statearr_38268 = state_38229;
(statearr_38268[(12)] = inst_38216);

(statearr_38268[(17)] = inst_38214__$1);

return statearr_38268;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38229__$1,(27),inst_38215);
} else {
if((state_val_38230 === (10))){
var inst_38139 = (state_38229[(9)]);
var inst_38140 = (state_38229[(10)]);
var inst_38154 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38139),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38140)," is not found on this ledger group."].join('');
var state_38229__$1 = state_38229;
var statearr_38269_38302 = state_38229__$1;
(statearr_38269_38302[(2)] = inst_38154);

(statearr_38269_38302[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38230 === (18))){
var inst_38211 = (state_38229[(2)]);
var state_38229__$1 = state_38229;
var statearr_38270_38303 = state_38229__$1;
(statearr_38270_38303[(2)] = inst_38211);

(statearr_38270_38303[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38230 === (8))){
var state_38229__$1 = state_38229;
var statearr_38271_38304 = state_38229__$1;
(statearr_38271_38304[(2)] = null);

(statearr_38271_38304[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$full_load_existing_db_$_state_machine__10903__auto__ = null;
var fluree$db$session$full_load_existing_db_$_state_machine__10903__auto____0 = (function (){
var statearr_38272 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38272[(0)] = fluree$db$session$full_load_existing_db_$_state_machine__10903__auto__);

(statearr_38272[(1)] = (1));

return statearr_38272;
});
var fluree$db$session$full_load_existing_db_$_state_machine__10903__auto____1 = (function (state_38229){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_38229);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e38273){var ex__10906__auto__ = e38273;
var statearr_38274_38305 = state_38229;
(statearr_38274_38305[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_38229[(4)]))){
var statearr_38275_38306 = state_38229;
(statearr_38275_38306[(1)] = cljs.core.first.call(null,(state_38229[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38307 = state_38229;
state_38229 = G__38307;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$session$full_load_existing_db_$_state_machine__10903__auto__ = function(state_38229){
switch(arguments.length){
case 0:
return fluree$db$session$full_load_existing_db_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$session$full_load_existing_db_$_state_machine__10903__auto____1.call(this,state_38229);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$full_load_existing_db_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$full_load_existing_db_$_state_machine__10903__auto____0;
fluree$db$session$full_load_existing_db_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$full_load_existing_db_$_state_machine__10903__auto____1;
return fluree$db$session$full_load_existing_db_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_38276 = f__10977__auto__.call(null);
(statearr_38276[(6)] = c__10976__auto___38277);

return statearr_38276;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));


return pc;
});
/**
 * Performs a compare and set! to update db, but only does so if
 *   existing db promise-chan is the same as old-db-ch.
 * 
 *   Returns true if successful, false if it did not replace.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(session,old_db_ch,new_db_ch){
var new_state = cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (state){
if(cljs.core._EQ_.call(null,old_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(state))){
return cljs.core.assoc.call(null,state,new cljs.core.Keyword("db","db","db/db",993247817),new_db_ch);
} else {
return state;
}
}));
return cljs.core._EQ_.call(null,new_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(new_state));
});
/**
 * Clears db from cache, forcing a new full load next time db is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(session){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),null);
});
/**
 * Clears any current db that is cached and forces a db reload.
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(session){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db.call(null,session));
});
/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_promise_ch = (function fluree$db$session$indexing_promise_ch(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock. Returns two-tuple of [lock? promise-chan]
 *   where lock? indicates if the lock was successful, and promise-chan is whatever
 *   promise-chan is registered for indexing.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,pc){
var swap_res = cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),pc);
} else {
return s;
}
}));
var res_pc = new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(swap_res);
var lock_QMARK_ = cljs.core._EQ_.call(null,pc,res_pc);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lock_QMARK_,res_pc], null);
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword("db","indexed","db/indexed",390759770),block);
}));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.call(null,cljs.cache.lru_cache_factory.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__4253__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.call(null,fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_.call(null,ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.call(null,ledger);
var network = cljs.core.namespace.call(null,ledger__$1);
var maybe_alias = cljs.core.name.call(null,ledger__$1);
var _ = (cljs.core.truth_((function (){var and__4251__auto__ = network;
if(cljs.core.truth_(and__4251__auto__)){
return maybe_alias;
} else {
return and__4251__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.pr_str.call(null,ledger__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
if(clojure.string.starts_with_QMARK_.call(null,maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.call(null,maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id.call(null,network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__4747__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4748__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4749__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4750__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4751__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4751__auto__,method_table__4747__auto__,prefer_table__4748__auto__,method_cache__4749__auto__,cached_hierarchy__4750__auto__));
})();
}
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),(function (_,___$1,___$2){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_38309){
var state_val_38310 = (state_38309[(1)]);
if((state_val_38310 === (1))){
var state_38309__$1 = state_38309;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38309__$1,new cljs.core.Keyword("fluree.db.session","no-op","fluree.db.session/no-op",1159713170));
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__10903__auto__ = null;
var fluree$db$session$state_machine__10903__auto____0 = (function (){
var statearr_38311 = [null,null,null,null,null,null,null];
(statearr_38311[(0)] = fluree$db$session$state_machine__10903__auto__);

(statearr_38311[(1)] = (1));

return statearr_38311;
});
var fluree$db$session$state_machine__10903__auto____1 = (function (state_38309){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_38309);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e38312){var ex__10906__auto__ = e38312;
var statearr_38313_38316 = state_38309;
(statearr_38313_38316[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_38309[(4)]))){
var statearr_38314_38317 = state_38309;
(statearr_38314_38317[(1)] = cljs.core.first.call(null,(state_38309[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38318 = state_38309;
state_38309 = G__38318;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$session$state_machine__10903__auto__ = function(state_38309){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__10903__auto____1.call(this,state_38309);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__10903__auto____0;
fluree$db$session$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__10903__auto____1;
return fluree$db$session$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_38315 = f__10977__auto__.call(null);
(statearr_38315[(6)] = c__10976__auto__);

return statearr_38315;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__38320){
var map__38321 = p__38320;
var map__38321__$1 = cljs.core.__destructure_map.call(null,map__38321);
var data = map__38321__$1;
var block = cljs.core.get.call(null,map__38321__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__38321__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__38321__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_38380){
var state_val_38381 = (state_38380[(1)]);
if((state_val_38381 === (7))){
var inst_38332 = (state_38380[(7)]);
var inst_38335 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_38336 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_38337 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38335),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38336),": Received block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current at block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38332),". No-op."].join('');
var inst_38338 = fluree.db.util.log.info.call(null,inst_38337);
var state_38380__$1 = state_38380;
var statearr_38382_38416 = state_38380__$1;
(statearr_38382_38416[(2)] = inst_38338);

(statearr_38382_38416[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38381 === (1))){
var state_38380__$1 = state_38380;
var statearr_38383_38417 = state_38380__$1;
(statearr_38383_38417[(2)] = null);

(statearr_38383_38417[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38381 === (4))){
var inst_38322 = (state_38380[(2)]);
var state_38380__$1 = state_38380;
var statearr_38384_38418 = state_38380__$1;
(statearr_38384_38418[(2)] = inst_38322);

(statearr_38384_38418[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38381 === (15))){
var inst_38361 = (state_38380[(2)]);
var state_38380__$1 = state_38380;
var statearr_38385_38419 = state_38380__$1;
(statearr_38385_38419[(2)] = inst_38361);

(statearr_38385_38419[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38381 === (13))){
var inst_38352 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var inst_38353 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38354 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_38355 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_38356 = [inst_38354,inst_38355];
var inst_38357 = (new cljs.core.PersistentVector(null,2,(5),inst_38353,inst_38356,null));
var inst_38358 = fluree.db.conn_events.process_event.call(null,inst_38352,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),inst_38357,data);
var state_38380__$1 = state_38380;
var statearr_38386_38420 = state_38380__$1;
(statearr_38386_38420[(2)] = inst_38358);

(statearr_38386_38420[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38381 === (6))){
var inst_38332 = (state_38380[(7)]);
var inst_38331 = (state_38380[(8)]);
var inst_38330 = (state_38380[(2)]);
var inst_38331__$1 = fluree.db.util.async.throw_err.call(null,inst_38330);
var inst_38332__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_38331__$1);
var inst_38333 = (block <= inst_38332__$1);
var state_38380__$1 = (function (){var statearr_38387 = state_38380;
(statearr_38387[(7)] = inst_38332__$1);

(statearr_38387[(8)] = inst_38331__$1);

return statearr_38387;
})();
if(cljs.core.truth_(inst_38333)){
var statearr_38388_38421 = state_38380__$1;
(statearr_38388_38421[(1)] = (7));

} else {
var statearr_38389_38422 = state_38380__$1;
(statearr_38389_38422[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38381 === (17))){
var state_38380__$1 = state_38380;
var statearr_38390_38423 = state_38380__$1;
(statearr_38390_38423[(2)] = null);

(statearr_38390_38423[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38381 === (3))){
var inst_38378 = (state_38380[(2)]);
var state_38380__$1 = state_38380;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38380__$1,inst_38378);
} else {
if((state_val_38381 === (12))){
var inst_38373 = (state_38380[(2)]);
var state_38380__$1 = state_38380;
var statearr_38391_38424 = state_38380__$1;
(statearr_38391_38424[(2)] = inst_38373);

(statearr_38391_38424[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38381 === (2))){
var inst_38328 = (state_38380[(9)]);
var _ = (function (){var statearr_38392 = state_38380;
(statearr_38392[(4)] = cljs.core.cons.call(null,(5),(state_38380[(4)])));

return statearr_38392;
})();
var inst_38328__$1 = fluree.db.session.current_db.call(null,session);
var state_38380__$1 = (function (){var statearr_38393 = state_38380;
(statearr_38393[(9)] = inst_38328__$1);

return statearr_38393;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38380__$1,(6),inst_38328__$1);
} else {
if((state_val_38381 === (11))){
var state_38380__$1 = state_38380;
var statearr_38395_38425 = state_38380__$1;
(statearr_38395_38425[(1)] = (16));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38381 === (9))){
var inst_38375 = (state_38380[(2)]);
var _ = (function (){var statearr_38397 = state_38380;
(statearr_38397[(4)] = cljs.core.rest.call(null,(state_38380[(4)])));

return statearr_38397;
})();
var state_38380__$1 = state_38380;
var statearr_38398_38426 = state_38380__$1;
(statearr_38398_38426[(2)] = inst_38375);

(statearr_38398_38426[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38381 === (5))){
var _ = (function (){var statearr_38399 = state_38380;
(statearr_38399[(4)] = cljs.core.rest.call(null,(state_38380[(4)])));

return statearr_38399;
})();
var state_38380__$1 = state_38380;
var ex38394 = (state_38380__$1[(2)]);
var statearr_38400_38427 = state_38380__$1;
(statearr_38400_38427[(5)] = ex38394);


if((ex38394 instanceof Error)){
var statearr_38401_38428 = state_38380__$1;
(statearr_38401_38428[(1)] = (4));

(statearr_38401_38428[(5)] = null);

} else {
throw ex38394;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38381 === (14))){
var state_38380__$1 = state_38380;
var statearr_38402_38429 = state_38380__$1;
(statearr_38402_38429[(2)] = null);

(statearr_38402_38429[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38381 === (16))){
var inst_38332 = (state_38380[(7)]);
var inst_38364 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_38365 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_38366 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38364),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38365),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38332),". Forcing a db reload."].join('');
var inst_38367 = fluree.db.util.log.info.call(null,inst_38366);
var inst_38368 = fluree.db.session.reload_db_BANG_.call(null,session);
var state_38380__$1 = (function (){var statearr_38403 = state_38380;
(statearr_38403[(10)] = inst_38367);

return statearr_38403;
})();
var statearr_38404_38430 = state_38380__$1;
(statearr_38404_38430[(2)] = inst_38368);

(statearr_38404_38430[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38381 === (10))){
var inst_38328 = (state_38380[(9)]);
var inst_38332 = (state_38380[(7)]);
var inst_38331 = (state_38380[(8)]);
var inst_38343 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_38344 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_38345 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38343),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38344),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_38346 = fluree.db.util.log.trace.call(null,inst_38345);
var inst_38347 = (function (){var current_db_ch = inst_38328;
var current_db = inst_38331;
var current_block = inst_38332;
return (function (p1__38319_SHARP_){
if((p1__38319_SHARP_ instanceof fluree.db.flake.Flake)){
return p1__38319_SHARP_;
} else {
return fluree.db.flake.parts__GT_Flake.call(null,p1__38319_SHARP_);
}
});
})();
var inst_38348 = cljs.core.map.call(null,inst_38347,flakes);
var inst_38349 = fluree.db.dbproto._with.call(null,inst_38331,block,inst_38348);
var inst_38350 = fluree.db.session.cas_db_BANG_.call(null,session,inst_38328,inst_38349);
var state_38380__$1 = (function (){var statearr_38405 = state_38380;
(statearr_38405[(11)] = inst_38346);

return statearr_38405;
})();
if(inst_38350){
var statearr_38406_38431 = state_38380__$1;
(statearr_38406_38431[(1)] = (13));

} else {
var statearr_38407_38432 = state_38380__$1;
(statearr_38407_38432[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38381 === (18))){
var inst_38371 = (state_38380[(2)]);
var state_38380__$1 = state_38380;
var statearr_38408_38433 = state_38380__$1;
(statearr_38408_38433[(2)] = inst_38371);

(statearr_38408_38433[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38381 === (8))){
var inst_38332 = (state_38380[(7)]);
var inst_38340 = ((1) + inst_38332);
var inst_38341 = cljs.core._EQ_.call(null,block,inst_38340);
var state_38380__$1 = state_38380;
if(inst_38341){
var statearr_38409_38434 = state_38380__$1;
(statearr_38409_38434[(1)] = (10));

} else {
var statearr_38410_38435 = state_38380__$1;
(statearr_38410_38435[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__10903__auto__ = null;
var fluree$db$session$state_machine__10903__auto____0 = (function (){
var statearr_38411 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38411[(0)] = fluree$db$session$state_machine__10903__auto__);

(statearr_38411[(1)] = (1));

return statearr_38411;
});
var fluree$db$session$state_machine__10903__auto____1 = (function (state_38380){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_38380);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e38412){var ex__10906__auto__ = e38412;
var statearr_38413_38436 = state_38380;
(statearr_38413_38436[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_38380[(4)]))){
var statearr_38414_38437 = state_38380;
(statearr_38414_38437[(1)] = cljs.core.first.call(null,(state_38380[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38438 = state_38380;
state_38380 = G__38438;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$session$state_machine__10903__auto__ = function(state_38380){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__10903__auto____1.call(this,state_38380);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__10903__auto____0;
fluree$db$session$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__10903__auto____1;
return fluree$db$session$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_38415 = f__10977__auto__.call(null);
(statearr_38415[(6)] = c__10976__auto__);

return statearr_38415;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_38445){
var state_val_38446 = (state_38445[(1)]);
if((state_val_38446 === (1))){
var inst_38439 = fluree.db.session.clear_db_BANG_.call(null,session);
var inst_38440 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_38441 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_38442 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38440),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38441)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_38443 = fluree.db.util.log.debug.call(null,inst_38442);
var state_38445__$1 = (function (){var statearr_38447 = state_38445;
(statearr_38447[(7)] = inst_38443);

(statearr_38447[(8)] = inst_38439);

return statearr_38447;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38445__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__10903__auto__ = null;
var fluree$db$session$state_machine__10903__auto____0 = (function (){
var statearr_38448 = [null,null,null,null,null,null,null,null,null];
(statearr_38448[(0)] = fluree$db$session$state_machine__10903__auto__);

(statearr_38448[(1)] = (1));

return statearr_38448;
});
var fluree$db$session$state_machine__10903__auto____1 = (function (state_38445){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_38445);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e38449){var ex__10906__auto__ = e38449;
var statearr_38450_38453 = state_38445;
(statearr_38450_38453[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_38445[(4)]))){
var statearr_38451_38454 = state_38445;
(statearr_38451_38454[(1)] = cljs.core.first.call(null,(state_38445[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38455 = state_38445;
state_38445 = G__38455;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$session$state_machine__10903__auto__ = function(state_38445){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__10903__auto____1.call(this,state_38445);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__10903__auto____0;
fluree$db$session$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__10903__auto____1;
return fluree$db$session$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_38452 = f__10977__auto__.call(null);
(statearr_38452[(6)] = c__10976__auto__);

return statearr_38452;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__38457 = arguments.length;
switch (G__38457) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (session){
var map__38458 = session;
var map__38458__$1 = cljs.core.__destructure_map.call(null,map__38458);
var conn = cljs.core.get.call(null,map__38458__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.call(null,map__38458__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.call(null,map__38458__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.call(null,map__38458__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.call(null,map__38458__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__38458__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var id = cljs.core.get.call(null,map__38458__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var closed_QMARK_ = fluree.db.session.closed_QMARK_.call(null,session);
if(cljs.core.truth_(closed_QMARK_)){
fluree.db.session.remove_cache_BANG_.call(null,network,dbid);

return false;
} else {
cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,dbid,id);

cljs.core.async.close_BANG_.call(null,update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_.call(null,transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_.call(null,network,dbid);

if(cljs.core.fn_QMARK_.call(null,new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session).call(null);
} else {
}

return true;
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5751__auto__ = fluree.db.session.from_cache.call(null,network,dbid);
if(cljs.core.truth_(temp__5751__auto__)){
var session = temp__5751__auto__;
return fluree.db.session.close.call(null,session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_38512){
var state_val_38513 = (state_38512[(1)]);
if((state_val_38513 === (7))){
var inst_38508 = (state_38512[(2)]);
var state_38512__$1 = state_38512;
var statearr_38514_38545 = state_38512__$1;
(statearr_38514_38545[(2)] = inst_38508);

(statearr_38514_38545[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38513 === (1))){
var state_38512__$1 = state_38512;
var statearr_38515_38546 = state_38512__$1;
(statearr_38515_38546[(2)] = null);

(statearr_38515_38546[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38513 === (4))){
var inst_38463 = (state_38512[(7)]);
var inst_38462 = (state_38512[(2)]);
var inst_38463__$1 = fluree.db.util.async.throw_err.call(null,inst_38462);
var inst_38464 = fluree.db.session.from_cache.call(null,network,ledger_id);
var inst_38465 = (inst_38463__$1 == null);
var state_38512__$1 = (function (){var statearr_38516 = state_38512;
(statearr_38516[(7)] = inst_38463__$1);

(statearr_38516[(8)] = inst_38464);

return statearr_38516;
})();
if(cljs.core.truth_(inst_38465)){
var statearr_38517_38547 = state_38512__$1;
(statearr_38517_38547[(1)] = (5));

} else {
var statearr_38518_38548 = state_38512__$1;
(statearr_38518_38548[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38513 === (15))){
var inst_38500 = (state_38512[(2)]);
var state_38512__$1 = (function (){var statearr_38519 = state_38512;
(statearr_38519[(9)] = inst_38500);

return statearr_38519;
})();
var statearr_38520_38549 = state_38512__$1;
(statearr_38520_38549[(2)] = null);

(statearr_38520_38549[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38513 === (13))){
var inst_38504 = (state_38512[(2)]);
var state_38512__$1 = state_38512;
var statearr_38522_38550 = state_38512__$1;
(statearr_38522_38550[(2)] = inst_38504);

(statearr_38522_38550[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38513 === (6))){
var inst_38464 = (state_38512[(8)]);
var inst_38470 = (inst_38464 == null);
var state_38512__$1 = state_38512;
if(cljs.core.truth_(inst_38470)){
var statearr_38523_38551 = state_38512__$1;
(statearr_38523_38551[(1)] = (8));

} else {
var statearr_38524_38552 = state_38512__$1;
(statearr_38524_38552[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38513 === (17))){
var _ = (function (){var statearr_38525 = state_38512;
(statearr_38525[(4)] = cljs.core.rest.call(null,(state_38512[(4)])));

return statearr_38525;
})();
var state_38512__$1 = state_38512;
var ex38521 = (state_38512__$1[(2)]);
var statearr_38526_38553 = state_38512__$1;
(statearr_38526_38553[(5)] = ex38521);


var statearr_38527_38554 = state_38512__$1;
(statearr_38527_38554[(1)] = (16));

(statearr_38527_38554[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38513 === (3))){
var inst_38510 = (state_38512[(2)]);
var state_38512__$1 = state_38512;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38512__$1,inst_38510);
} else {
if((state_val_38513 === (12))){
var state_38512__$1 = state_38512;
var statearr_38528_38555 = state_38512__$1;
(statearr_38528_38555[(2)] = null);

(statearr_38528_38555[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38513 === (2))){
var state_38512__$1 = state_38512;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38512__$1,(4),update_chan);
} else {
if((state_val_38513 === (11))){
var state_38512__$1 = state_38512;
var statearr_38529_38556 = state_38512__$1;
(statearr_38529_38556[(2)] = null);

(statearr_38529_38556[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38513 === (9))){
var state_38512__$1 = state_38512;
var statearr_38530_38557 = state_38512__$1;
(statearr_38530_38557[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38513 === (5))){
var inst_38467 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_38468 = fluree.db.util.log.info.call(null,inst_38467);
var state_38512__$1 = state_38512;
var statearr_38532_38558 = state_38512__$1;
(statearr_38532_38558[(2)] = inst_38468);

(statearr_38532_38558[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38513 === (14))){
var inst_38463 = (state_38512[(7)]);
var inst_38464 = (state_38512[(8)]);
var _ = (function (){var statearr_38533 = state_38512;
(statearr_38533[(4)] = cljs.core.cons.call(null,(17),(state_38512[(4)])));

return statearr_38533;
})();
var inst_38488 = cljs.core.nth.call(null,inst_38463,(0),null);
var inst_38489 = cljs.core.nth.call(null,inst_38463,(1),null);
var inst_38490 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_38491 = cljs.core.pr_str.call(null,inst_38463);
var inst_38492 = fluree.db.util.core.trunc.call(null,inst_38491,(200));
var inst_38493 = fluree.db.util.log.trace.call(null,inst_38490,inst_38492);
var inst_38494 = fluree.db.session.process_ledger_update.call(null,inst_38464,inst_38488,inst_38489);
var state_38512__$1 = (function (){var statearr_38534 = state_38512;
(statearr_38534[(10)] = inst_38493);

return statearr_38534;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38512__$1,(18),inst_38494);
} else {
if((state_val_38513 === (16))){
var inst_38463 = (state_38512[(7)]);
var inst_38478 = (state_38512[(2)]);
var inst_38479 = fluree.db.util.log.error.call(null,inst_38478,"Exception processing ledger updates for message: ",inst_38463);
var state_38512__$1 = state_38512;
var statearr_38535_38559 = state_38512__$1;
(statearr_38535_38559[(2)] = inst_38479);

(statearr_38535_38559[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38513 === (10))){
var inst_38506 = (state_38512[(2)]);
var state_38512__$1 = state_38512;
var statearr_38536_38560 = state_38512__$1;
(statearr_38536_38560[(2)] = inst_38506);

(statearr_38536_38560[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38513 === (18))){
var inst_38496 = (state_38512[(2)]);
var inst_38497 = fluree.db.util.async.throw_err.call(null,inst_38496);
var _ = (function (){var statearr_38537 = state_38512;
(statearr_38537[(4)] = cljs.core.rest.call(null,(state_38512[(4)])));

return statearr_38537;
})();
var state_38512__$1 = state_38512;
var statearr_38538_38561 = state_38512__$1;
(statearr_38538_38561[(2)] = inst_38497);

(statearr_38538_38561[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38513 === (8))){
var inst_38463 = (state_38512[(7)]);
var inst_38472 = cljs.core.first.call(null,inst_38463);
var inst_38473 = cljs.core.pr_str.call(null,inst_38472);
var inst_38474 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_38473].join('');
var inst_38475 = fluree.db.util.log.warn.call(null,inst_38474);
var state_38512__$1 = state_38512;
var statearr_38539_38562 = state_38512__$1;
(statearr_38539_38562[(2)] = inst_38475);

(statearr_38539_38562[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__10903__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__10903__auto____0 = (function (){
var statearr_38540 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_38540[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__10903__auto__);

(statearr_38540[(1)] = (1));

return statearr_38540;
});
var fluree$db$session$process_ledger_updates_$_state_machine__10903__auto____1 = (function (state_38512){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_38512);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e38541){var ex__10906__auto__ = e38541;
var statearr_38542_38563 = state_38512;
(statearr_38542_38563[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_38512[(4)]))){
var statearr_38543_38564 = state_38512;
(statearr_38543_38564[(1)] = cljs.core.first.call(null,(state_38512[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38565 = state_38512;
state_38512 = G__38565;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__10903__auto__ = function(state_38512){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__10903__auto____1.call(this,state_38512);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__10903__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__10903__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_38544 = f__10977__auto__.call(null);
(statearr_38544[(6)] = c__10976__auto__);

return statearr_38544;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Creates a connection without first checking if db exists. Only useful if reloading
 *   and replacing an existing DB.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__38566){
var map__38567 = p__38566;
var map__38567__$1 = cljs.core.__destructure_map.call(null,map__38567);
var network = cljs.core.get.call(null,map__38567__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.call(null,map__38567__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var dbid = cljs.core.get.call(null,map__38567__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var db = cljs.core.get.call(null,map__38567__$1,new cljs.core.Keyword(null,"db","db",993250759));
var transactor_QMARK_ = cljs.core.get.call(null,map__38567__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.call(null,map__38567__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.call(null,map__38567__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.call(null,map__38567__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.call(null,map__38567__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var update_chan = cljs.core.async.chan.call(null);
var transact_chan = (cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.call(null):null);
var state__$1 = cljs.core.atom.call(null,cljs.core.merge.call(null,state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","db","db/db",993247817),(cljs.core.truth_(db)?cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null),new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)));
var session = fluree.db.session.map__GT_DbSession.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[dbid,update_chan,db_name,state__$1,close,id,schema_cache,transact_chan,network,null,conn]));
var current_db_fn = (function (){
return fluree.db.session.current_db.call(null,session);
});
var blank_db = fluree.db.graphdb.blank_db.call(null,conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.call(null,session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__38571 = block_result;
var map__38571__$1 = cljs.core.__destructure_map.call(null,map__38571);
var block = cljs.core.get.call(null,map__38571__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.call(null,map__38571__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.call(null,map__38571__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.call(null,map__38571__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.call(null,map__38571__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__4253__auto__ = cljs.core.get.call(null,txns,cljs.core.keyword.call(null,txid));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.call(null,txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.call(null,["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.call(null,block_result)], null))})());
var map__38572 = tx_result;
var map__38572__$1 = cljs.core.__destructure_map.call(null,map__38572);
var t = cljs.core.get.call(null,map__38572__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.call(null,map__38572__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first.call(null,flakes) instanceof fluree.db.flake.Flake))?(function (p1__38568_SHARP_){
return cljs.core._EQ_.call(null,t,p1__38568_SHARP_.t);
}):(function (p1__38569_SHARP_){
return cljs.core._EQ_.call(null,t,cljs.core.nth.call(null,p1__38569_SHARP_,(3)));
}));
var response = cljs.core.assoc.call(null,tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.call(null,t_filter,flakes));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some.call(null,(function (p1__38570_SHARP_){
if(cljs.core._EQ_.call(null,(109),cljs.core.second.call(null,p1__38570_SHARP_))){
return cljs.core.nth.call(null,p1__38570_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__38573 = (cljs.core.truth_(error_msg)?cljs.core.re_find.call(null,/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.call(null,vec__38573,(0),null);
var status__$1 = cljs.core.nth.call(null,vec__38573,(1),null);
var error = cljs.core.nth.call(null,vec__38573,(2),null);
var message = cljs.core.nth.call(null,vec__38573,(3),null);
return cljs.core.ex_info.call(null,(function (){var or__4253__auto__ = message;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.call(null,error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var _ = fluree.db.util.log.trace.call(null,"Create and cache session. Opt keys: ",cljs.core.keys.call(null,opts));
var id = cljs.core.keyword.call(null,"session",cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid.call(null)),(0),(7)));
var session = fluree.db.session.session_factory.call(null,cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_.call(null,session);
var new_QMARK_ = cljs.core._EQ_.call(null,id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.call(null,session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__38577 = arguments.length;
switch (G__38577) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.call(null,conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__38578){
var map__38579 = p__38578;
var map__38579__$1 = cljs.core.__destructure_map.call(null,map__38579);
var state = cljs.core.get.call(null,map__38579__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.call(null,map__38579__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.call(null,map__38579__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.call(null,map__38579__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__38580 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__38580,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__38580,(1),null);
var ledger_alias = cljs.core.nth.call(null,vec__38580,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__4253__auto__ = fluree.db.session.from_cache.call(null,network,ledger_id);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var session = fluree.db.session.create_and_cache_session.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__4253__auto____$1 = state;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.call(null,session,opts);

new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,ledger_id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session),(function (event_type,event_data){
cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5753__auto__ = cljs.core.not_empty.call(null,cljs.core.get.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5753__auto__)){
var tx_callbacks = temp__5753__auto__;
var tids = cljs.core.keys.call(null,new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__38583 = cljs.core.seq.call(null,tids);
var chunk__38584 = null;
var count__38585 = (0);
var i__38586 = (0);
while(true){
if((i__38586 < count__38585)){
var tid = cljs.core._nth.call(null,chunk__38584,i__38586);
var temp__5753__auto___38699__$1 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5753__auto___38699__$1)){
var keyed_callbacks_38700 = temp__5753__auto___38699__$1;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_38701 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__38627_38702 = cljs.core.seq.call(null,keyed_callbacks_38700);
var chunk__38628_38703 = null;
var count__38629_38704 = (0);
var i__38630_38705 = (0);
while(true){
if((i__38630_38705 < count__38629_38704)){
var vec__38639_38706 = cljs.core._nth.call(null,chunk__38628_38703,i__38630_38705);
var k_38707 = cljs.core.nth.call(null,vec__38639_38706,(0),null);
var f_38708 = cljs.core.nth.call(null,vec__38639_38706,(1),null);
try{f_38708.call(null,tx_response_38701);
}catch (e38642){var e_38709 = e38642;
fluree.db.util.log.error.call(null,e_38709,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__38710 = seq__38627_38702;
var G__38711 = chunk__38628_38703;
var G__38712 = count__38629_38704;
var G__38713 = (i__38630_38705 + (1));
seq__38627_38702 = G__38710;
chunk__38628_38703 = G__38711;
count__38629_38704 = G__38712;
i__38630_38705 = G__38713;
continue;
} else {
var temp__5753__auto___38714__$2 = cljs.core.seq.call(null,seq__38627_38702);
if(temp__5753__auto___38714__$2){
var seq__38627_38715__$1 = temp__5753__auto___38714__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__38627_38715__$1)){
var c__4679__auto___38716 = cljs.core.chunk_first.call(null,seq__38627_38715__$1);
var G__38717 = cljs.core.chunk_rest.call(null,seq__38627_38715__$1);
var G__38718 = c__4679__auto___38716;
var G__38719 = cljs.core.count.call(null,c__4679__auto___38716);
var G__38720 = (0);
seq__38627_38702 = G__38717;
chunk__38628_38703 = G__38718;
count__38629_38704 = G__38719;
i__38630_38705 = G__38720;
continue;
} else {
var vec__38643_38721 = cljs.core.first.call(null,seq__38627_38715__$1);
var k_38722 = cljs.core.nth.call(null,vec__38643_38721,(0),null);
var f_38723 = cljs.core.nth.call(null,vec__38643_38721,(1),null);
try{f_38723.call(null,tx_response_38701);
}catch (e38646){var e_38724 = e38646;
fluree.db.util.log.error.call(null,e_38724,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__38725 = cljs.core.next.call(null,seq__38627_38715__$1);
var G__38726 = null;
var G__38727 = (0);
var G__38728 = (0);
seq__38627_38702 = G__38725;
chunk__38628_38703 = G__38726;
count__38629_38704 = G__38727;
i__38630_38705 = G__38728;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__38729 = seq__38583;
var G__38730 = chunk__38584;
var G__38731 = count__38585;
var G__38732 = (i__38586 + (1));
seq__38583 = G__38729;
chunk__38584 = G__38730;
count__38585 = G__38731;
i__38586 = G__38732;
continue;
} else {
var temp__5753__auto____$1 = cljs.core.seq.call(null,seq__38583);
if(temp__5753__auto____$1){
var seq__38583__$1 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__38583__$1)){
var c__4679__auto__ = cljs.core.chunk_first.call(null,seq__38583__$1);
var G__38733 = cljs.core.chunk_rest.call(null,seq__38583__$1);
var G__38734 = c__4679__auto__;
var G__38735 = cljs.core.count.call(null,c__4679__auto__);
var G__38736 = (0);
seq__38583 = G__38733;
chunk__38584 = G__38734;
count__38585 = G__38735;
i__38586 = G__38736;
continue;
} else {
var tid = cljs.core.first.call(null,seq__38583__$1);
var temp__5753__auto___38737__$2 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5753__auto___38737__$2)){
var keyed_callbacks_38738 = temp__5753__auto___38737__$2;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_38739 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__38647_38740 = cljs.core.seq.call(null,keyed_callbacks_38738);
var chunk__38648_38741 = null;
var count__38649_38742 = (0);
var i__38650_38743 = (0);
while(true){
if((i__38650_38743 < count__38649_38742)){
var vec__38659_38744 = cljs.core._nth.call(null,chunk__38648_38741,i__38650_38743);
var k_38745 = cljs.core.nth.call(null,vec__38659_38744,(0),null);
var f_38746 = cljs.core.nth.call(null,vec__38659_38744,(1),null);
try{f_38746.call(null,tx_response_38739);
}catch (e38662){var e_38747 = e38662;
fluree.db.util.log.error.call(null,e_38747,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__38748 = seq__38647_38740;
var G__38749 = chunk__38648_38741;
var G__38750 = count__38649_38742;
var G__38751 = (i__38650_38743 + (1));
seq__38647_38740 = G__38748;
chunk__38648_38741 = G__38749;
count__38649_38742 = G__38750;
i__38650_38743 = G__38751;
continue;
} else {
var temp__5753__auto___38752__$3 = cljs.core.seq.call(null,seq__38647_38740);
if(temp__5753__auto___38752__$3){
var seq__38647_38753__$1 = temp__5753__auto___38752__$3;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__38647_38753__$1)){
var c__4679__auto___38754 = cljs.core.chunk_first.call(null,seq__38647_38753__$1);
var G__38755 = cljs.core.chunk_rest.call(null,seq__38647_38753__$1);
var G__38756 = c__4679__auto___38754;
var G__38757 = cljs.core.count.call(null,c__4679__auto___38754);
var G__38758 = (0);
seq__38647_38740 = G__38755;
chunk__38648_38741 = G__38756;
count__38649_38742 = G__38757;
i__38650_38743 = G__38758;
continue;
} else {
var vec__38663_38759 = cljs.core.first.call(null,seq__38647_38753__$1);
var k_38760 = cljs.core.nth.call(null,vec__38663_38759,(0),null);
var f_38761 = cljs.core.nth.call(null,vec__38663_38759,(1),null);
try{f_38761.call(null,tx_response_38739);
}catch (e38666){var e_38762 = e38666;
fluree.db.util.log.error.call(null,e_38762,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__38763 = cljs.core.next.call(null,seq__38647_38753__$1);
var G__38764 = null;
var G__38765 = (0);
var G__38766 = (0);
seq__38647_38740 = G__38763;
chunk__38648_38741 = G__38764;
count__38649_38742 = G__38765;
i__38650_38743 = G__38766;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__38767 = cljs.core.next.call(null,seq__38583__$1);
var G__38768 = null;
var G__38769 = (0);
var G__38770 = (0);
seq__38583 = G__38767;
chunk__38584 = G__38768;
count__38585 = G__38769;
i__38586 = G__38770;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
}));

fluree.db.session.process_ledger_updates.call(null,conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_38771 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__10976__auto___38772 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_38683){
var state_val_38684 = (state_38683[(1)]);
if((state_val_38684 === (1))){
var state_38683__$1 = state_38683;
var statearr_38685_38773 = state_38683__$1;
(statearr_38685_38773[(2)] = null);

(statearr_38685_38773[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38684 === (2))){
var inst_38668 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_38683__$1 = state_38683;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38683__$1,(4),inst_38668);
} else {
if((state_val_38684 === (3))){
var inst_38681 = (state_38683[(2)]);
var state_38683__$1 = state_38683;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38683__$1,inst_38681);
} else {
if((state_val_38684 === (4))){
var inst_38670 = (state_38683[(7)]);
var inst_38670__$1 = (state_38683[(2)]);
var inst_38671 = (inst_38670__$1 == null);
var state_38683__$1 = (function (){var statearr_38686 = state_38683;
(statearr_38686[(7)] = inst_38670__$1);

return statearr_38686;
})();
if(cljs.core.truth_(inst_38671)){
var statearr_38687_38774 = state_38683__$1;
(statearr_38687_38774[(1)] = (5));

} else {
var statearr_38688_38775 = state_38683__$1;
(statearr_38688_38775[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38684 === (5))){
var inst_38673 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_38674 = fluree.db.util.log.info.call(null,inst_38673);
var state_38683__$1 = state_38683;
var statearr_38689_38776 = state_38683__$1;
(statearr_38689_38776[(2)] = inst_38674);

(statearr_38689_38776[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38684 === (6))){
var inst_38670 = (state_38683[(7)]);
var inst_38676 = transact_handler_38771.call(null,conn,inst_38670);
var state_38683__$1 = (function (){var statearr_38690 = state_38683;
(statearr_38690[(8)] = inst_38676);

return statearr_38690;
})();
var statearr_38691_38777 = state_38683__$1;
(statearr_38691_38777[(2)] = null);

(statearr_38691_38777[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38684 === (7))){
var inst_38679 = (state_38683[(2)]);
var state_38683__$1 = state_38683;
var statearr_38692_38778 = state_38683__$1;
(statearr_38692_38778[(2)] = inst_38679);

(statearr_38692_38778[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__10903__auto__ = null;
var fluree$db$session$state_machine__10903__auto____0 = (function (){
var statearr_38693 = [null,null,null,null,null,null,null,null,null];
(statearr_38693[(0)] = fluree$db$session$state_machine__10903__auto__);

(statearr_38693[(1)] = (1));

return statearr_38693;
});
var fluree$db$session$state_machine__10903__auto____1 = (function (state_38683){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_38683);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e38694){var ex__10906__auto__ = e38694;
var statearr_38695_38779 = state_38683;
(statearr_38695_38779[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_38683[(4)]))){
var statearr_38696_38780 = state_38683;
(statearr_38696_38780[(1)] = cljs.core.first.call(null,(state_38683[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38781 = state_38683;
state_38683 = G__38781;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$session$state_machine__10903__auto__ = function(state_38683){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__10903__auto____1.call(this,state_38683);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__10903__auto____0;
fluree$db$session$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__10903__auto____1;
return fluree$db$session$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_38697 = f__10977__auto__.call(null);
(statearr_38697[(6)] = c__10976__auto___38772);

return statearr_38697;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Gets the latest db from the central DB atom if available, or loads it from scratch.
 *   DB is returned as a core async promise channel.
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(p__38783){
var map__38784 = p__38783;
var map__38784__$1 = cljs.core.__destructure_map.call(null,map__38784);
var session = map__38784__$1;
var state = cljs.core.get.call(null,map__38784__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
cljs.core.swap_BANG_.call(null,state,(function (p1__38782_SHARP_){
return cljs.core.assoc.call(null,p1__38782_SHARP_,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis.call(null),new cljs.core.Keyword("req","count","req/count",2145574363),(new cljs.core.Keyword("req","count","req/count",2145574363).cljs$core$IFn$_invoke$arity$1(p1__38782_SHARP_) + (1)));
}));

var or__4253__auto__ = new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,state));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var _ = cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(session),cljs.core.empty);
var new_state = cljs.core.swap_BANG_.call(null,state,(function (st){
if(cljs.core.truth_(new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(st))){
return st;
} else {
return cljs.core.assoc.call(null,st,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db.call(null,session));
}
}));
return new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(new_state);
}
});
/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.call(null,conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.call(null,conn,ledger,opts);
return fluree.db.session.current_db.call(null,session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__38787 = arguments.length;
switch (G__38787) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.call(null,null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__38788 = cljs.core.vals.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.call(null,(function (p1__38785_SHARP_){
return cljs.core._EQ_.call(null,conn_id,cljs.core.get_in.call(null,p1__38785_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__38788);
} else {
return G__38788;
}
})();
var seq__38789 = cljs.core.seq.call(null,sessions);
var chunk__38790 = null;
var count__38791 = (0);
var i__38792 = (0);
while(true){
if((i__38792 < count__38791)){
var session = cljs.core._nth.call(null,chunk__38790,i__38792);
fluree.db.session.close.call(null,session);


var G__38794 = seq__38789;
var G__38795 = chunk__38790;
var G__38796 = count__38791;
var G__38797 = (i__38792 + (1));
seq__38789 = G__38794;
chunk__38790 = G__38795;
count__38791 = G__38796;
i__38792 = G__38797;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__38789);
if(temp__5753__auto__){
var seq__38789__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__38789__$1)){
var c__4679__auto__ = cljs.core.chunk_first.call(null,seq__38789__$1);
var G__38798 = cljs.core.chunk_rest.call(null,seq__38789__$1);
var G__38799 = c__4679__auto__;
var G__38800 = cljs.core.count.call(null,c__4679__auto__);
var G__38801 = (0);
seq__38789 = G__38798;
chunk__38790 = G__38799;
count__38791 = G__38800;
i__38792 = G__38801;
continue;
} else {
var session = cljs.core.first.call(null,seq__38789__$1);
fluree.db.session.close.call(null,session);


var G__38802 = cljs.core.next.call(null,seq__38789__$1);
var G__38803 = null;
var G__38804 = (0);
var G__38805 = (0);
seq__38789 = G__38802;
chunk__38790 = G__38803;
count__38791 = G__38804;
i__38792 = G__38805;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.call(null,"Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.call(null,pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_.call(null,cljs.core.get.call(null,updated,tid))){
return cljs.core.dissoc.call(null,updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
