// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.call(null,cljs.core.re_find.call(null,/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_25854){
var state_val_25855 = (state_25854[(1)]);
if((state_val_25855 === (1))){
var state_25854__$1 = state_25854;
var statearr_25856_25870 = state_25854__$1;
(statearr_25856_25870[(2)] = null);

(statearr_25856_25870[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25855 === (2))){
var _ = (function (){var statearr_25857 = state_25854;
(statearr_25857[(4)] = cljs.core.cons.call(null,(5),(state_25854[(4)])));

return statearr_25857;
})();
var inst_25845 = fluree.db.dbproto._tag.call(null,db,type_tag_sid,"_predicate/type");
var state_25854__$1 = state_25854;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25854__$1,(6),inst_25845);
} else {
if((state_val_25855 === (3))){
var inst_25852 = (state_25854[(2)]);
var state_25854__$1 = state_25854;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25854__$1,inst_25852);
} else {
if((state_val_25855 === (4))){
var inst_25839 = (state_25854[(2)]);
var state_25854__$1 = state_25854;
var statearr_25859_25871 = state_25854__$1;
(statearr_25859_25871[(2)] = inst_25839);

(statearr_25859_25871[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25855 === (5))){
var _ = (function (){var statearr_25860 = state_25854;
(statearr_25860[(4)] = cljs.core.rest.call(null,(state_25854[(4)])));

return statearr_25860;
})();
var state_25854__$1 = state_25854;
var ex25858 = (state_25854__$1[(2)]);
var statearr_25861_25872 = state_25854__$1;
(statearr_25861_25872[(5)] = ex25858);


if((ex25858 instanceof Error)){
var statearr_25862_25873 = state_25854__$1;
(statearr_25862_25873[(1)] = (4));

(statearr_25862_25873[(5)] = null);

} else {
throw ex25858;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25855 === (6))){
var inst_25847 = (state_25854[(2)]);
var inst_25848 = fluree.db.util.async.throw_err.call(null,inst_25847);
var inst_25849 = cljs.core.keyword.call(null,inst_25848);
var _ = (function (){var statearr_25863 = state_25854;
(statearr_25863[(4)] = cljs.core.rest.call(null,(state_25854[(4)])));

return statearr_25863;
})();
var state_25854__$1 = state_25854;
var statearr_25864_25874 = state_25854__$1;
(statearr_25864_25874[(2)] = inst_25849);

(statearr_25864_25874[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__10903__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__10903__auto____0 = (function (){
var statearr_25865 = [null,null,null,null,null,null,null];
(statearr_25865[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__10903__auto__);

(statearr_25865[(1)] = (1));

return statearr_25865;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__10903__auto____1 = (function (state_25854){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_25854);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e25866){var ex__10906__auto__ = e25866;
var statearr_25867_25875 = state_25854;
(statearr_25867_25875[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_25854[(4)]))){
var statearr_25868_25876 = state_25854;
(statearr_25868_25876[(1)] = cljs.core.first.call(null,(state_25854[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25877 = state_25854;
state_25854 = G__25877;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__10903__auto__ = function(state_25854){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__10903__auto____1.call(this,state_25854);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__10903__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__10903__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_25869 = f__10977__auto__.call(null);
(statearr_25869[(6)] = c__10976__auto__);

return statearr_25869;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_25909){
var state_val_25910 = (state_25909[(1)]);
if((state_val_25910 === (7))){
var inst_25893 = (state_25909[(7)]);
var inst_25895 = cljs.core.empty_QMARK_.call(null,inst_25893);
var inst_25896 = (!(inst_25895));
var state_25909__$1 = state_25909;
var statearr_25911_25935 = state_25909__$1;
(statearr_25911_25935[(2)] = inst_25896);

(statearr_25911_25935[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25910 === (1))){
var state_25909__$1 = state_25909;
var statearr_25912_25936 = state_25909__$1;
(statearr_25912_25936[(2)] = null);

(statearr_25912_25936[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25910 === (4))){
var inst_25879 = (state_25909[(2)]);
var state_25909__$1 = state_25909;
var statearr_25913_25937 = state_25909__$1;
(statearr_25913_25937[(2)] = inst_25879);

(statearr_25913_25937[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25910 === (6))){
var inst_25885 = (state_25909[(8)]);
var inst_25893 = (state_25909[(7)]);
var inst_25891 = (state_25909[(2)]);
var inst_25892 = fluree.db.util.async.throw_err.call(null,inst_25891);
var inst_25893__$1 = cljs.core.map.call(null,inst_25885,inst_25892);
var state_25909__$1 = (function (){var statearr_25914 = state_25909;
(statearr_25914[(7)] = inst_25893__$1);

return statearr_25914;
})();
if(cljs.core.truth_(inst_25893__$1)){
var statearr_25915_25938 = state_25909__$1;
(statearr_25915_25938[(1)] = (7));

} else {
var statearr_25916_25939 = state_25909__$1;
(statearr_25916_25939[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25910 === (3))){
var inst_25907 = (state_25909[(2)]);
var state_25909__$1 = state_25909;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25909__$1,inst_25907);
} else {
if((state_val_25910 === (12))){
var inst_25904 = (state_25909[(2)]);
var _ = (function (){var statearr_25917 = state_25909;
(statearr_25917[(4)] = cljs.core.rest.call(null,(state_25909[(4)])));

return statearr_25917;
})();
var state_25909__$1 = state_25909;
var statearr_25918_25940 = state_25909__$1;
(statearr_25918_25940[(2)] = inst_25904);

(statearr_25918_25940[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25910 === (2))){
var _ = (function (){var statearr_25919 = state_25909;
(statearr_25919[(4)] = cljs.core.cons.call(null,(5),(state_25909[(4)])));

return statearr_25919;
})();
var inst_25885 = (function (){return (function (p1__25878_SHARP_){
return p1__25878_SHARP_.o;
});
})();
var inst_25886 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25887 = [pred_id];
var inst_25888 = (new cljs.core.PersistentVector(null,1,(5),inst_25886,inst_25887,null));
var inst_25889 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_25888);
var state_25909__$1 = (function (){var statearr_25920 = state_25909;
(statearr_25920[(8)] = inst_25885);

return statearr_25920;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25909__$1,(6),inst_25889);
} else {
if((state_val_25910 === (11))){
var state_25909__$1 = state_25909;
var statearr_25922_25941 = state_25909__$1;
(statearr_25922_25941[(2)] = true);

(statearr_25922_25941[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25910 === (9))){
var inst_25899 = (state_25909[(2)]);
var state_25909__$1 = state_25909;
if(cljs.core.truth_(inst_25899)){
var statearr_25923_25942 = state_25909__$1;
(statearr_25923_25942[(1)] = (10));

} else {
var statearr_25924_25943 = state_25909__$1;
(statearr_25924_25943[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25910 === (5))){
var _ = (function (){var statearr_25925 = state_25909;
(statearr_25925[(4)] = cljs.core.rest.call(null,(state_25909[(4)])));

return statearr_25925;
})();
var state_25909__$1 = state_25909;
var ex25921 = (state_25909__$1[(2)]);
var statearr_25926_25944 = state_25909__$1;
(statearr_25926_25944[(5)] = ex25921);


if((ex25921 instanceof Error)){
var statearr_25927_25945 = state_25909__$1;
(statearr_25927_25945[(1)] = (4));

(statearr_25927_25945[(5)] = null);

} else {
throw ex25921;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25910 === (10))){
var inst_25893 = (state_25909[(7)]);
var inst_25901 = cljs.core.apply.call(null,cljs.core.distinct_QMARK_,inst_25893);
var state_25909__$1 = state_25909;
var statearr_25928_25946 = state_25909__$1;
(statearr_25928_25946[(2)] = inst_25901);

(statearr_25928_25946[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25910 === (8))){
var inst_25893 = (state_25909[(7)]);
var state_25909__$1 = state_25909;
var statearr_25929_25947 = state_25909__$1;
(statearr_25929_25947[(2)] = inst_25893);

(statearr_25929_25947[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10903__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10903__auto____0 = (function (){
var statearr_25930 = [null,null,null,null,null,null,null,null,null];
(statearr_25930[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10903__auto__);

(statearr_25930[(1)] = (1));

return statearr_25930;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10903__auto____1 = (function (state_25909){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_25909);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e25931){var ex__10906__auto__ = e25931;
var statearr_25932_25948 = state_25909;
(statearr_25932_25948[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_25909[(4)]))){
var statearr_25933_25949 = state_25909;
(statearr_25933_25949[(1)] = cljs.core.first.call(null,(state_25909[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25950 = state_25909;
state_25909 = G__25950;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10903__auto__ = function(state_25909){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10903__auto____1.call(this,state_25909);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10903__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10903__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_25934 = f__10977__auto__.call(null);
(statearr_25934[(6)] = c__10976__auto__);

return statearr_25934;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_26031){
var state_val_26032 = (state_26031[(1)]);
if((state_val_26032 === (7))){
var state_26031__$1 = state_26031;
var statearr_26033_26070 = state_26031__$1;
(statearr_26033_26070[(2)] = flakes);

(statearr_26033_26070[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26032 === (20))){
var inst_25988 = (state_26031[(7)]);
var inst_26021 = (state_26031[(2)]);
var inst_25980 = inst_25988;
var inst_25981 = inst_26021;
var state_26031__$1 = (function (){var statearr_26034 = state_26031;
(statearr_26034[(8)] = inst_25980);

(statearr_26034[(9)] = inst_25981);

return statearr_26034;
})();
var statearr_26035_26071 = state_26031__$1;
(statearr_26035_26071[(2)] = null);

(statearr_26035_26071[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26032 === (1))){
var state_26031__$1 = state_26031;
var statearr_26036_26072 = state_26031__$1;
(statearr_26036_26072[(2)] = null);

(statearr_26036_26072[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26032 === (4))){
var inst_25953 = (state_26031[(2)]);
var state_26031__$1 = state_26031;
var statearr_26037_26073 = state_26031__$1;
(statearr_26037_26073[(2)] = inst_25953);

(statearr_26037_26073[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26032 === (15))){
var inst_25987 = (state_26031[(10)]);
var inst_26005 = inst_25987.o;
var state_26031__$1 = state_26031;
var statearr_26038_26074 = state_26031__$1;
(statearr_26038_26074[(2)] = inst_26005);

(statearr_26038_26074[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26032 === (13))){
var inst_26024 = (state_26031[(2)]);
var state_26031__$1 = state_26031;
var statearr_26039_26075 = state_26031__$1;
(statearr_26039_26075[(2)] = inst_26024);

(statearr_26039_26075[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26032 === (6))){
var inst_25960 = cljs.core.filter.call(null,fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_26031__$1 = state_26031;
var statearr_26040_26076 = state_26031__$1;
(statearr_26040_26076[(2)] = inst_25960);

(statearr_26040_26076[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26032 === (17))){
var inst_26002 = (state_26031[(2)]);
var inst_26003 = fluree.db.util.async.throw_err.call(null,inst_26002);
var state_26031__$1 = state_26031;
var statearr_26041_26077 = state_26031__$1;
(statearr_26041_26077[(2)] = inst_26003);

(statearr_26041_26077[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26032 === (3))){
var inst_26029 = (state_26031[(2)]);
var state_26031__$1 = state_26031;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26031__$1,inst_26029);
} else {
if((state_val_26032 === (12))){
var inst_25994 = (state_26031[(11)]);
var inst_25987 = (state_26031[(10)]);
var inst_25992 = inst_25987.p;
var inst_25993 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_25992);
var inst_25994__$1 = fluree.db.query.schema.pred_name__GT_keyword.call(null,inst_25993);
var inst_25995 = inst_25987.op;
var inst_25996 = inst_25995 === false;
var inst_25997 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348),inst_25994__$1);
var state_26031__$1 = (function (){var statearr_26042 = state_26031;
(statearr_26042[(11)] = inst_25994__$1);

(statearr_26042[(12)] = inst_25996);

return statearr_26042;
})();
if(inst_25997){
var statearr_26043_26078 = state_26031__$1;
(statearr_26043_26078[(1)] = (14));

} else {
var statearr_26044_26079 = state_26031__$1;
(statearr_26044_26079[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26032 === (2))){
var _ = (function (){var statearr_26045 = state_26031;
(statearr_26045[(4)] = cljs.core.cons.call(null,(5),(state_26031[(4)])));

return statearr_26045;
})();
var state_26031__$1 = state_26031;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_26046_26080 = state_26031__$1;
(statearr_26046_26080[(1)] = (6));

} else {
var statearr_26047_26081 = state_26031__$1;
(statearr_26047_26081[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26032 === (19))){
var inst_25994 = (state_26031[(11)]);
var inst_25987 = (state_26031[(10)]);
var inst_25981 = (state_26031[(9)]);
var inst_26007 = (state_26031[(13)]);
var inst_26015 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26016 = inst_25987.s;
var inst_26017 = [inst_26016,inst_25994,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_26018 = (new cljs.core.PersistentVector(null,3,(5),inst_26015,inst_26017,null));
var inst_26019 = cljs.core.assoc_in.call(null,inst_25981,inst_26018,inst_26007);
var state_26031__$1 = state_26031;
var statearr_26048_26082 = state_26031__$1;
(statearr_26048_26082[(2)] = inst_26019);

(statearr_26048_26082[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26032 === (11))){
var inst_25981 = (state_26031[(9)]);
var state_26031__$1 = state_26031;
var statearr_26050_26083 = state_26031__$1;
(statearr_26050_26083[(2)] = inst_25981);

(statearr_26050_26083[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26032 === (9))){
var inst_25980 = (state_26031[(8)]);
var inst_25987 = (state_26031[(10)]);
var inst_25986 = cljs.core.seq.call(null,inst_25980);
var inst_25987__$1 = cljs.core.first.call(null,inst_25986);
var inst_25988 = cljs.core.next.call(null,inst_25986);
var inst_25989 = cljs.core.not.call(null,inst_25987__$1);
var state_26031__$1 = (function (){var statearr_26051 = state_26031;
(statearr_26051[(7)] = inst_25988);

(statearr_26051[(10)] = inst_25987__$1);

return statearr_26051;
})();
if(inst_25989){
var statearr_26052_26084 = state_26031__$1;
(statearr_26052_26084[(1)] = (11));

} else {
var statearr_26053_26085 = state_26031__$1;
(statearr_26053_26085[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26032 === (5))){
var _ = (function (){var statearr_26054 = state_26031;
(statearr_26054[(4)] = cljs.core.rest.call(null,(state_26031[(4)])));

return statearr_26054;
})();
var state_26031__$1 = state_26031;
var ex26049 = (state_26031__$1[(2)]);
var statearr_26055_26086 = state_26031__$1;
(statearr_26055_26086[(5)] = ex26049);


if((ex26049 instanceof Error)){
var statearr_26056_26087 = state_26031__$1;
(statearr_26056_26087[(1)] = (4));

(statearr_26056_26087[(5)] = null);

} else {
throw ex26049;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26032 === (14))){
var inst_25987 = (state_26031[(10)]);
var inst_25999 = inst_25987.o;
var inst_26000 = fluree.db.query.schema.convert_type_to_kw.call(null,inst_25999,db);
var state_26031__$1 = state_26031;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26031__$1,(17),inst_26000);
} else {
if((state_val_26032 === (16))){
var inst_25996 = (state_26031[(12)]);
var inst_26007 = (state_26031[(2)]);
var state_26031__$1 = (function (){var statearr_26057 = state_26031;
(statearr_26057[(13)] = inst_26007);

return statearr_26057;
})();
if(cljs.core.truth_(inst_25996)){
var statearr_26058_26088 = state_26031__$1;
(statearr_26058_26088[(1)] = (18));

} else {
var statearr_26059_26089 = state_26031__$1;
(statearr_26059_26089[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26032 === (10))){
var inst_26026 = (state_26031[(2)]);
var _ = (function (){var statearr_26060 = state_26031;
(statearr_26060[(4)] = cljs.core.rest.call(null,(state_26031[(4)])));

return statearr_26060;
})();
var state_26031__$1 = state_26031;
var statearr_26061_26090 = state_26031__$1;
(statearr_26061_26090[(2)] = inst_26026);

(statearr_26061_26090[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26032 === (18))){
var inst_25994 = (state_26031[(11)]);
var inst_25987 = (state_26031[(10)]);
var inst_25981 = (state_26031[(9)]);
var inst_26007 = (state_26031[(13)]);
var inst_26009 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26010 = inst_25987.s;
var inst_26011 = [inst_26010,inst_25994,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_26012 = (new cljs.core.PersistentVector(null,3,(5),inst_26009,inst_26011,null));
var inst_26013 = cljs.core.assoc_in.call(null,inst_25981,inst_26012,inst_26007);
var state_26031__$1 = state_26031;
var statearr_26062_26091 = state_26031__$1;
(statearr_26062_26091[(2)] = inst_26013);

(statearr_26062_26091[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26032 === (8))){
var inst_25963 = (state_26031[(2)]);
var inst_25964 = cljs.core.PersistentHashSet.EMPTY;
var inst_25965 = cljs.core.vals.call(null,tempids);
var inst_25966 = cljs.core.into.call(null,inst_25964,inst_25965);
var inst_25967 = (function (){var pred_flakes = inst_25963;
var is_new_QMARK_ = inst_25966;
return (function (p1__25952_SHARP_,p2__25951_SHARP_){
var f = p2__25951_SHARP_;
return cljs.core.assoc_in.call(null,p1__25952_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s,new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$.call(null,is_new_QMARK_.call(null,f.s)));
});
})();
var inst_25968 = cljs.core.PersistentHashMap.EMPTY;
var inst_25969 = cljs.core.reduce.call(null,inst_25967,inst_25968,inst_25963);
var inst_25977 = cljs.core.seq.call(null,inst_25963);
var inst_25978 = cljs.core.first.call(null,inst_25977);
var inst_25979 = cljs.core.next.call(null,inst_25977);
var inst_25980 = inst_25963;
var inst_25981 = inst_25969;
var state_26031__$1 = (function (){var statearr_26063 = state_26031;
(statearr_26063[(14)] = inst_25978);

(statearr_26063[(8)] = inst_25980);

(statearr_26063[(15)] = inst_25979);

(statearr_26063[(9)] = inst_25981);

return statearr_26063;
})();
var statearr_26064_26092 = state_26031__$1;
(statearr_26064_26092[(2)] = null);

(statearr_26064_26092[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__10903__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__10903__auto____0 = (function (){
var statearr_26065 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26065[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__10903__auto__);

(statearr_26065[(1)] = (1));

return statearr_26065;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__10903__auto____1 = (function (state_26031){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_26031);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e26066){var ex__10906__auto__ = e26066;
var statearr_26067_26093 = state_26031;
(statearr_26067_26093[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_26031[(4)]))){
var statearr_26068_26094 = state_26031;
(statearr_26068_26094[(1)] = cljs.core.first.call(null,(state_26031[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26095 = state_26031;
state_26031 = G__26095;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__10903__auto__ = function(state_26031){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__10903__auto____1.call(this,state_26031);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__10903__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__10903__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_26069 = f__10977__auto__.call(null);
(statearr_26069[(6)] = c__10976__auto__);

return statearr_26069;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__26097 = arguments.length;
switch (G__26097) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.call(null,null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name.call(null,current_type)," to ",cljs.core.name.call(null,new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__26100 = arguments.length;
switch (G__26100) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.call(null,pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_26412){
var state_val_26413 = (state_26412[(1)]);
if((state_val_26413 === (121))){
var inst_26367 = (state_26412[(7)]);
var state_26412__$1 = state_26412;
var statearr_26414_26607 = state_26412__$1;
(statearr_26414_26607[(2)] = inst_26367);

(statearr_26414_26607[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (65))){
var inst_26266 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
if(cljs.core.truth_(inst_26266)){
var statearr_26415_26608 = state_26412__$1;
(statearr_26415_26608[(1)] = (66));

} else {
var statearr_26416_26609 = state_26412__$1;
(statearr_26416_26609[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (70))){
var inst_26271 = (state_26412[(8)]);
var inst_26272 = (state_26412[(9)]);
var inst_26276 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_26277 = inst_26272.call(null,cljs.core.PersistentArrayMap,null,3,inst_26276,null);
var inst_26278 = inst_26272.call(null,cljs.core.PersistentHashSet,null,inst_26277,null);
var inst_26279 = inst_26278.call(null,inst_26271);
var state_26412__$1 = state_26412;
if(cljs.core.truth_(inst_26279)){
var statearr_26417_26610 = state_26412__$1;
(statearr_26417_26610[(1)] = (72));

} else {
var statearr_26418_26611 = state_26412__$1;
(statearr_26418_26611[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (62))){
var inst_26256 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
var statearr_26419_26612 = state_26412__$1;
(statearr_26419_26612[(2)] = inst_26256);

(statearr_26419_26612[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (74))){
var inst_26362 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
var statearr_26420_26613 = state_26412__$1;
(statearr_26420_26613[(2)] = inst_26362);

(statearr_26420_26613[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (110))){
var inst_26389 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
if(cljs.core.truth_(inst_26389)){
var statearr_26421_26614 = state_26412__$1;
(statearr_26421_26614[(1)] = (117));

} else {
var statearr_26422_26615 = state_26412__$1;
(statearr_26422_26615[(1)] = (118));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (7))){
var inst_26407 = (state_26412[(2)]);
var _ = (function (){var statearr_26423 = state_26412;
(statearr_26423[(4)] = cljs.core.rest.call(null,(state_26412[(4)])));

return statearr_26423;
})();
var state_26412__$1 = state_26412;
var statearr_26424_26616 = state_26412__$1;
(statearr_26424_26616[(2)] = inst_26407);

(statearr_26424_26616[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (59))){
var inst_26140 = (state_26412[(10)]);
var inst_26260 = (state_26412[(11)]);
var inst_26259 = (state_26412[(2)]);
var inst_26260__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_26140);
var state_26412__$1 = (function (){var statearr_26425 = state_26412;
(statearr_26425[(11)] = inst_26260__$1);

(statearr_26425[(12)] = inst_26259);

return statearr_26425;
})();
if(cljs.core.truth_(inst_26260__$1)){
var statearr_26426_26617 = state_26412__$1;
(statearr_26426_26617[(1)] = (63));

} else {
var statearr_26427_26618 = state_26412__$1;
(statearr_26427_26618[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (86))){
var inst_26302 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
var statearr_26428_26619 = state_26412__$1;
(statearr_26428_26619[(2)] = inst_26302);

(statearr_26428_26619[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (20))){
var inst_26166 = (state_26412[(13)]);
var inst_26140 = (state_26412[(10)]);
var inst_26166__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_26140);
var state_26412__$1 = (function (){var statearr_26429 = state_26412;
(statearr_26429[(13)] = inst_26166__$1);

return statearr_26429;
})();
if(cljs.core.truth_(inst_26166__$1)){
var statearr_26430_26620 = state_26412__$1;
(statearr_26430_26620[(1)] = (23));

} else {
var statearr_26431_26621 = state_26412__$1;
(statearr_26431_26621[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (72))){
var inst_26271 = (state_26412[(8)]);
var inst_26272 = (state_26412[(9)]);
var inst_26281 = fluree.db.query.schema.type_error.call(null,inst_26271,inst_26272,throw_QMARK_);
var state_26412__$1 = state_26412;
var statearr_26432_26622 = state_26412__$1;
(statearr_26432_26622[(2)] = inst_26281);

(statearr_26432_26622[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (58))){
var inst_26221 = (state_26412[(14)]);
var state_26412__$1 = state_26412;
var statearr_26433_26623 = state_26412__$1;
(statearr_26433_26623[(2)] = inst_26221);

(statearr_26433_26623[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (60))){
var inst_26139 = (state_26412[(15)]);
var inst_26128 = (state_26412[(16)]);
var inst_26247 = fluree.db.dbproto._p_prop.call(null,inst_26128,new cljs.core.Keyword(null,"name","name",1843675177),inst_26139);
var inst_26248 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26247)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_26249 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26250 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_26251 = cljs.core.PersistentHashMap.fromArrays(inst_26249,inst_26250);
var inst_26252 = cljs.core.ex_info.call(null,inst_26248,inst_26251);
var inst_26253 = (function(){throw inst_26252})();
var state_26412__$1 = state_26412;
var statearr_26434_26624 = state_26412__$1;
(statearr_26434_26624[(2)] = inst_26253);

(statearr_26434_26624[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (27))){
var inst_26169 = (state_26412[(17)]);
var state_26412__$1 = state_26412;
var statearr_26435_26625 = state_26412__$1;
(statearr_26435_26625[(2)] = inst_26169);

(statearr_26435_26625[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (1))){
var state_26412__$1 = state_26412;
var statearr_26436_26626 = state_26412__$1;
(statearr_26436_26626[(2)] = null);

(statearr_26436_26626[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (69))){
var inst_26259 = (state_26412[(12)]);
var state_26412__$1 = state_26412;
var statearr_26437_26627 = state_26412__$1;
(statearr_26437_26627[(2)] = inst_26259);

(statearr_26437_26627[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (101))){
var inst_26271 = (state_26412[(8)]);
var inst_26272 = (state_26412[(9)]);
var inst_26340 = fluree.db.query.schema.type_error.call(null,inst_26271,inst_26272,throw_QMARK_);
var state_26412__$1 = state_26412;
var statearr_26438_26628 = state_26412__$1;
(statearr_26438_26628[(2)] = inst_26340);

(statearr_26438_26628[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (24))){
var inst_26166 = (state_26412[(13)]);
var state_26412__$1 = state_26412;
var statearr_26439_26629 = state_26412__$1;
(statearr_26439_26629[(2)] = inst_26166);

(statearr_26439_26629[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (102))){
var inst_26342 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
var statearr_26440_26630 = state_26412__$1;
(statearr_26440_26630[(2)] = inst_26342);

(statearr_26440_26630[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (55))){
var inst_26238 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
var statearr_26441_26631 = state_26412__$1;
(statearr_26441_26631[(2)] = inst_26238);

(statearr_26441_26631[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (85))){
var inst_26271 = (state_26412[(8)]);
var inst_26272 = (state_26412[(9)]);
var inst_26300 = fluree.db.query.schema.type_error.call(null,inst_26271,inst_26272,throw_QMARK_);
var state_26412__$1 = state_26412;
var statearr_26442_26632 = state_26412__$1;
(statearr_26442_26632[(2)] = inst_26300);

(statearr_26442_26632[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (39))){
var inst_26203 = (state_26412[(18)]);
var state_26412__$1 = state_26412;
var statearr_26443_26633 = state_26412__$1;
(statearr_26443_26633[(2)] = inst_26203);

(statearr_26443_26633[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (88))){
var inst_26259 = (state_26412[(12)]);
var state_26412__$1 = state_26412;
var statearr_26444_26634 = state_26412__$1;
(statearr_26444_26634[(2)] = inst_26259);

(statearr_26444_26634[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (46))){
var inst_26140 = (state_26412[(10)]);
var inst_26222 = (state_26412[(19)]);
var inst_26221 = (state_26412[(2)]);
var inst_26222__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_26140);
var state_26412__$1 = (function (){var statearr_26445 = state_26412;
(statearr_26445[(19)] = inst_26222__$1);

(statearr_26445[(14)] = inst_26221);

return statearr_26445;
})();
if(cljs.core.truth_(inst_26222__$1)){
var statearr_26446_26635 = state_26412__$1;
(statearr_26446_26635[(1)] = (47));

} else {
var statearr_26447_26636 = state_26412__$1;
(statearr_26447_26636[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (4))){
var inst_26101 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
var statearr_26448_26637 = state_26412__$1;
(statearr_26448_26637[(2)] = inst_26101);

(statearr_26448_26637[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (77))){
var inst_26360 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
var statearr_26449_26638 = state_26412__$1;
(statearr_26449_26638[(2)] = inst_26360);

(statearr_26449_26638[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (106))){
var inst_26352 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
var statearr_26450_26639 = state_26412__$1;
(statearr_26450_26639[(2)] = inst_26352);

(statearr_26450_26639[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (119))){
var inst_26138 = (state_26412[(20)]);
var inst_26402 = (state_26412[(2)]);
var inst_26127 = inst_26138;
var inst_26128 = inst_26402;
var state_26412__$1 = (function (){var statearr_26451 = state_26412;
(statearr_26451[(21)] = inst_26127);

(statearr_26451[(16)] = inst_26128);

return statearr_26451;
})();
var statearr_26452_26640 = state_26412__$1;
(statearr_26452_26640[(2)] = null);

(statearr_26452_26640[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (95))){
var inst_26271 = (state_26412[(8)]);
var inst_26272 = (state_26412[(9)]);
var inst_26324 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_26325 = inst_26272.call(null,cljs.core.PersistentArrayMap,null,5,inst_26324,null);
var inst_26326 = inst_26272.call(null,cljs.core.PersistentHashSet,null,inst_26325,null);
var inst_26327 = inst_26326.call(null,inst_26271);
var state_26412__$1 = state_26412;
if(cljs.core.truth_(inst_26327)){
var statearr_26453_26641 = state_26412__$1;
(statearr_26453_26641[(1)] = (96));

} else {
var statearr_26454_26642 = state_26412__$1;
(statearr_26454_26642[(1)] = (97));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (54))){
var inst_26229 = (state_26412[(22)]);
var state_26412__$1 = state_26412;
var statearr_26455_26643 = state_26412__$1;
(statearr_26455_26643[(2)] = inst_26229);

(statearr_26455_26643[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (92))){
var inst_26259 = (state_26412[(12)]);
var state_26412__$1 = state_26412;
var statearr_26456_26644 = state_26412__$1;
(statearr_26456_26644[(2)] = inst_26259);

(statearr_26456_26644[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (104))){
var inst_26259 = (state_26412[(12)]);
var state_26412__$1 = state_26412;
var statearr_26457_26645 = state_26412__$1;
(statearr_26457_26645[(2)] = inst_26259);

(statearr_26457_26645[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (15))){
var inst_26148 = (state_26412[(23)]);
var state_26412__$1 = state_26412;
var statearr_26458_26646 = state_26412__$1;
(statearr_26458_26646[(2)] = inst_26148);

(statearr_26458_26646[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (48))){
var inst_26222 = (state_26412[(19)]);
var state_26412__$1 = state_26412;
var statearr_26459_26647 = state_26412__$1;
(statearr_26459_26647[(2)] = inst_26222);

(statearr_26459_26647[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (50))){
var inst_26140 = (state_26412[(10)]);
var inst_26229 = (state_26412[(22)]);
var inst_26227 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_26140);
var inst_26228 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_26227);
var inst_26229__$1 = inst_26228 === true;
var state_26412__$1 = (function (){var statearr_26460 = state_26412;
(statearr_26460[(22)] = inst_26229__$1);

return statearr_26460;
})();
if(cljs.core.truth_(inst_26229__$1)){
var statearr_26461_26648 = state_26412__$1;
(statearr_26461_26648[(1)] = (53));

} else {
var statearr_26462_26649 = state_26412__$1;
(statearr_26462_26649[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (116))){
var inst_26383 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
var statearr_26463_26650 = state_26412__$1;
(statearr_26463_26650[(2)] = inst_26383);

(statearr_26463_26650[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (75))){
var inst_26272 = (state_26412[(9)]);
var state_26412__$1 = state_26412;
var G__26464_26651 = inst_26272;
var G__26464_26652__$1 = (((G__26464_26651 instanceof cljs.core.Keyword))?G__26464_26651.fqn:null);
switch (G__26464_26652__$1) {
case "long":
var statearr_26465_26654 = state_26412__$1;
(statearr_26465_26654[(1)] = (79));


break;
case "bigint":
var statearr_26466_26655 = state_26412__$1;
(statearr_26466_26655[(1)] = (83));


break;
case "double":
var statearr_26467_26656 = state_26412__$1;
(statearr_26467_26656[(1)] = (87));


break;
case "float":
var statearr_26468_26657 = state_26412__$1;
(statearr_26468_26657[(1)] = (91));


break;
case "bigdec":
var statearr_26469_26658 = state_26412__$1;
(statearr_26469_26658[(1)] = (95));


break;
case "string":
var statearr_26470_26659 = state_26412__$1;
(statearr_26470_26659[(1)] = (99));


break;
case "instant":
var statearr_26471_26660 = state_26412__$1;
(statearr_26471_26660[(1)] = (103));


break;
default:
var statearr_26472_26661 = state_26412__$1;
(statearr_26472_26661[(1)] = (107));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (99))){
var inst_26271 = (state_26412[(8)]);
var inst_26272 = (state_26412[(9)]);
var inst_26334 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_26335 = inst_26272.call(null,cljs.core.PersistentArrayMap,null,5,inst_26334,null);
var inst_26336 = inst_26272.call(null,cljs.core.PersistentHashSet,null,inst_26335,null);
var inst_26337 = inst_26336.call(null,inst_26271);
var state_26412__$1 = state_26412;
if(cljs.core.truth_(inst_26337)){
var statearr_26473_26662 = state_26412__$1;
(statearr_26473_26662[(1)] = (100));

} else {
var statearr_26474_26663 = state_26412__$1;
(statearr_26474_26663[(1)] = (101));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (21))){
var inst_26164 = (state_26412[(24)]);
var state_26412__$1 = state_26412;
var statearr_26475_26664 = state_26412__$1;
(statearr_26475_26664[(2)] = inst_26164);

(statearr_26475_26664[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (31))){
var inst_26180 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
var statearr_26476_26665 = state_26412__$1;
(statearr_26476_26665[(2)] = inst_26180);

(statearr_26476_26665[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (113))){
var inst_26386 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
var statearr_26477_26666 = state_26412__$1;
(statearr_26477_26666[(2)] = inst_26386);

(statearr_26477_26666[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (32))){
var state_26412__$1 = state_26412;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_26478_26667 = state_26412__$1;
(statearr_26478_26667[(1)] = (35));

} else {
var statearr_26479_26668 = state_26412__$1;
(statearr_26479_26668[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (40))){
var inst_26216 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
if(cljs.core.truth_(inst_26216)){
var statearr_26480_26669 = state_26412__$1;
(statearr_26480_26669[(1)] = (44));

} else {
var statearr_26481_26670 = state_26412__$1;
(statearr_26481_26670[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (91))){
var inst_26271 = (state_26412[(8)]);
var inst_26272 = (state_26412[(9)]);
var inst_26314 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_26315 = inst_26272.call(null,cljs.core.PersistentArrayMap,null,3,inst_26314,null);
var inst_26316 = inst_26272.call(null,cljs.core.PersistentHashSet,null,inst_26315,null);
var inst_26317 = inst_26316.call(null,inst_26271);
var state_26412__$1 = state_26412;
if(cljs.core.truth_(inst_26317)){
var statearr_26482_26671 = state_26412__$1;
(statearr_26482_26671[(1)] = (92));

} else {
var statearr_26483_26672 = state_26412__$1;
(statearr_26483_26672[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (117))){
var state_26412__$1 = state_26412;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_26484_26673 = state_26412__$1;
(statearr_26484_26673[(1)] = (120));

} else {
var statearr_26485_26674 = state_26412__$1;
(statearr_26485_26674[(1)] = (121));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (108))){
var inst_26140 = (state_26412[(10)]);
var inst_26371 = (state_26412[(25)]);
var inst_26371__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_26140);
var state_26412__$1 = (function (){var statearr_26486 = state_26412;
(statearr_26486[(25)] = inst_26371__$1);

return statearr_26486;
})();
if(cljs.core.truth_(inst_26371__$1)){
var statearr_26487_26675 = state_26412__$1;
(statearr_26487_26675[(1)] = (111));

} else {
var statearr_26488_26676 = state_26412__$1;
(statearr_26488_26676[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (56))){
var inst_26233 = (state_26412[(2)]);
var inst_26234 = fluree.db.util.async.throw_err.call(null,inst_26233);
var inst_26235 = cljs.core.not.call(null,inst_26234);
var state_26412__$1 = state_26412;
var statearr_26489_26677 = state_26412__$1;
(statearr_26489_26677[(2)] = inst_26235);

(statearr_26489_26677[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (33))){
var inst_26163 = (state_26412[(26)]);
var state_26412__$1 = state_26412;
var statearr_26490_26678 = state_26412__$1;
(statearr_26490_26678[(2)] = inst_26163);

(statearr_26490_26678[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (13))){
var inst_26158 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
if(cljs.core.truth_(inst_26158)){
var statearr_26491_26679 = state_26412__$1;
(statearr_26491_26679[(1)] = (17));

} else {
var statearr_26492_26680 = state_26412__$1;
(statearr_26492_26680[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (22))){
var inst_26189 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
if(cljs.core.truth_(inst_26189)){
var statearr_26493_26681 = state_26412__$1;
(statearr_26493_26681[(1)] = (32));

} else {
var statearr_26494_26682 = state_26412__$1;
(statearr_26494_26682[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (90))){
var inst_26312 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
var statearr_26495_26683 = state_26412__$1;
(statearr_26495_26683[(2)] = inst_26312);

(statearr_26495_26683[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (109))){
var inst_26369 = (state_26412[(27)]);
var state_26412__$1 = state_26412;
var statearr_26496_26684 = state_26412__$1;
(statearr_26496_26684[(2)] = inst_26369);

(statearr_26496_26684[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (36))){
var inst_26163 = (state_26412[(26)]);
var state_26412__$1 = state_26412;
var statearr_26497_26685 = state_26412__$1;
(statearr_26497_26685[(2)] = inst_26163);

(statearr_26497_26685[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (41))){
var inst_26140 = (state_26412[(10)]);
var inst_26208 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_26140);
var inst_26209 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_26208);
var inst_26210 = inst_26209 === true;
var state_26412__$1 = state_26412;
var statearr_26498_26686 = state_26412__$1;
(statearr_26498_26686[(2)] = inst_26210);

(statearr_26498_26686[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (118))){
var inst_26367 = (state_26412[(7)]);
var state_26412__$1 = state_26412;
var statearr_26499_26687 = state_26412__$1;
(statearr_26499_26687[(2)] = inst_26367);

(statearr_26499_26687[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (89))){
var inst_26271 = (state_26412[(8)]);
var inst_26272 = (state_26412[(9)]);
var inst_26310 = fluree.db.query.schema.type_error.call(null,inst_26271,inst_26272,throw_QMARK_);
var state_26412__$1 = state_26412;
var statearr_26500_26688 = state_26412__$1;
(statearr_26500_26688[(2)] = inst_26310);

(statearr_26500_26688[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (100))){
var inst_26259 = (state_26412[(12)]);
var state_26412__$1 = state_26412;
var statearr_26501_26689 = state_26412__$1;
(statearr_26501_26689[(2)] = inst_26259);

(statearr_26501_26689[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (122))){
var inst_26399 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
var statearr_26502_26690 = state_26412__$1;
(statearr_26502_26690[(2)] = inst_26399);

(statearr_26502_26690[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (43))){
var inst_26213 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
var statearr_26503_26691 = state_26412__$1;
(statearr_26503_26691[(2)] = inst_26213);

(statearr_26503_26691[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (61))){
var inst_26221 = (state_26412[(14)]);
var state_26412__$1 = state_26412;
var statearr_26504_26692 = state_26412__$1;
(statearr_26504_26692[(2)] = inst_26221);

(statearr_26504_26692[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (29))){
var inst_26140 = (state_26412[(10)]);
var inst_26175 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_26140);
var inst_26176 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_26175);
var inst_26177 = inst_26176 === true;
var state_26412__$1 = state_26412;
var statearr_26505_26693 = state_26412__$1;
(statearr_26505_26693[(2)] = inst_26177);

(statearr_26505_26693[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (44))){
var inst_26202 = (state_26412[(28)]);
var inst_26218 = fluree.db.query.schema.type_error.call(null,inst_26202,"a component","a non-component",throw_QMARK_);
var state_26412__$1 = state_26412;
var statearr_26506_26694 = state_26412__$1;
(statearr_26506_26694[(2)] = inst_26218);

(statearr_26506_26694[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (93))){
var inst_26271 = (state_26412[(8)]);
var inst_26272 = (state_26412[(9)]);
var inst_26320 = fluree.db.query.schema.type_error.call(null,inst_26271,inst_26272,throw_QMARK_);
var state_26412__$1 = state_26412;
var statearr_26507_26695 = state_26412__$1;
(statearr_26507_26695[(2)] = inst_26320);

(statearr_26507_26695[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (6))){
var inst_26139 = (state_26412[(15)]);
var inst_26127 = (state_26412[(21)]);
var inst_26136 = cljs.core.seq.call(null,inst_26127);
var inst_26137 = cljs.core.first.call(null,inst_26136);
var inst_26138 = cljs.core.next.call(null,inst_26136);
var inst_26139__$1 = cljs.core.nth.call(null,inst_26137,(0),null);
var inst_26140 = cljs.core.nth.call(null,inst_26137,(1),null);
var inst_26141 = cljs.core.not.call(null,inst_26139__$1);
var state_26412__$1 = (function (){var statearr_26508 = state_26412;
(statearr_26508[(20)] = inst_26138);

(statearr_26508[(10)] = inst_26140);

(statearr_26508[(15)] = inst_26139__$1);

return statearr_26508;
})();
if(inst_26141){
var statearr_26509_26696 = state_26412__$1;
(statearr_26509_26696[(1)] = (8));

} else {
var statearr_26510_26697 = state_26412__$1;
(statearr_26510_26697[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (111))){
var inst_26140 = (state_26412[(10)]);
var inst_26375 = (state_26412[(29)]);
var inst_26373 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_26140);
var inst_26374 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_26373);
var inst_26375__$1 = inst_26374 === true;
var state_26412__$1 = (function (){var statearr_26511 = state_26412;
(statearr_26511[(29)] = inst_26375__$1);

return statearr_26511;
})();
if(cljs.core.truth_(inst_26375__$1)){
var statearr_26512_26698 = state_26412__$1;
(statearr_26512_26698[(1)] = (114));

} else {
var statearr_26513_26699 = state_26412__$1;
(statearr_26513_26699[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (28))){
var inst_26183 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
var statearr_26514_26700 = state_26412__$1;
(statearr_26514_26700[(2)] = inst_26183);

(statearr_26514_26700[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (64))){
var inst_26260 = (state_26412[(11)]);
var state_26412__$1 = state_26412;
var statearr_26515_26701 = state_26412__$1;
(statearr_26515_26701[(2)] = inst_26260);

(statearr_26515_26701[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (103))){
var inst_26271 = (state_26412[(8)]);
var inst_26272 = (state_26412[(9)]);
var inst_26344 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_26345 = inst_26272.call(null,cljs.core.PersistentArrayMap,null,2,inst_26344,null);
var inst_26346 = inst_26272.call(null,cljs.core.PersistentHashSet,null,inst_26345,null);
var inst_26347 = inst_26346.call(null,inst_26271);
var state_26412__$1 = state_26412;
if(cljs.core.truth_(inst_26347)){
var statearr_26516_26702 = state_26412__$1;
(statearr_26516_26702[(1)] = (104));

} else {
var statearr_26517_26703 = state_26412__$1;
(statearr_26517_26703[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (51))){
var inst_26225 = (state_26412[(30)]);
var state_26412__$1 = state_26412;
var statearr_26518_26704 = state_26412__$1;
(statearr_26518_26704[(2)] = inst_26225);

(statearr_26518_26704[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (25))){
var inst_26186 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
var statearr_26519_26705 = state_26412__$1;
(statearr_26519_26705[(2)] = inst_26186);

(statearr_26519_26705[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (34))){
var inst_26140 = (state_26412[(10)]);
var inst_26203 = (state_26412[(18)]);
var inst_26202 = (state_26412[(2)]);
var inst_26203__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_26140);
var state_26412__$1 = (function (){var statearr_26520 = state_26412;
(statearr_26520[(28)] = inst_26202);

(statearr_26520[(18)] = inst_26203__$1);

return statearr_26520;
})();
if(cljs.core.truth_(inst_26203__$1)){
var statearr_26521_26706 = state_26412__$1;
(statearr_26521_26706[(1)] = (38));

} else {
var statearr_26522_26707 = state_26412__$1;
(statearr_26522_26707[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (17))){
var inst_26128 = (state_26412[(16)]);
var inst_26160 = fluree.db.query.schema.type_error.call(null,inst_26128,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_26412__$1 = state_26412;
var statearr_26523_26708 = state_26412__$1;
(statearr_26523_26708[(2)] = inst_26160);

(statearr_26523_26708[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (3))){
var inst_26410 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26412__$1,inst_26410);
} else {
if((state_val_26413 === (12))){
var inst_26144 = (state_26412[(31)]);
var state_26412__$1 = state_26412;
var statearr_26524_26709 = state_26412__$1;
(statearr_26524_26709[(2)] = inst_26144);

(statearr_26524_26709[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (2))){
var _ = (function (){var statearr_26525 = state_26412;
(statearr_26525[(4)] = cljs.core.cons.call(null,(5),(state_26412[(4)])));

return statearr_26525;
})();
var inst_26120 = pred_changes;
var inst_26121 = cljs.core.seq.call(null,inst_26120);
var inst_26122 = cljs.core.first.call(null,inst_26121);
var inst_26123 = cljs.core.next.call(null,inst_26121);
var inst_26124 = cljs.core.nth.call(null,inst_26122,(0),null);
var inst_26125 = cljs.core.nth.call(null,inst_26122,(1),null);
var inst_26126 = db;
var inst_26127 = inst_26120;
var inst_26128 = inst_26126;
var state_26412__$1 = (function (){var statearr_26526 = state_26412;
(statearr_26526[(21)] = inst_26127);

(statearr_26526[(32)] = inst_26123);

(statearr_26526[(33)] = inst_26124);

(statearr_26526[(34)] = inst_26125);

(statearr_26526[(16)] = inst_26128);

return statearr_26526;
})();
var statearr_26527_26710 = state_26412__$1;
(statearr_26527_26710[(2)] = null);

(statearr_26527_26710[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (66))){
var inst_26140 = (state_26412[(10)]);
var inst_26271 = (state_26412[(8)]);
var inst_26272 = (state_26412[(9)]);
var inst_26269 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_26140);
var inst_26270 = cljs.core.__destructure_map.call(null,inst_26269);
var inst_26271__$1 = cljs.core.get.call(null,inst_26270,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_26272__$1 = cljs.core.get.call(null,inst_26270,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_26273 = cljs.core._EQ_.call(null,inst_26272__$1,inst_26271__$1);
var state_26412__$1 = (function (){var statearr_26528 = state_26412;
(statearr_26528[(8)] = inst_26271__$1);

(statearr_26528[(9)] = inst_26272__$1);

return statearr_26528;
})();
if(inst_26273){
var statearr_26529_26711 = state_26412__$1;
(statearr_26529_26711[(1)] = (69));

} else {
var statearr_26530_26712 = state_26412__$1;
(statearr_26530_26712[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (107))){
var inst_26271 = (state_26412[(8)]);
var inst_26272 = (state_26412[(9)]);
var inst_26354 = fluree.db.query.schema.type_error.call(null,inst_26271,inst_26272,throw_QMARK_);
var state_26412__$1 = state_26412;
var statearr_26531_26713 = state_26412__$1;
(statearr_26531_26713[(2)] = inst_26354);

(statearr_26531_26713[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (23))){
var inst_26140 = (state_26412[(10)]);
var inst_26169 = (state_26412[(17)]);
var inst_26168 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_26140);
var inst_26169__$1 = inst_26168 === true;
var state_26412__$1 = (function (){var statearr_26532 = state_26412;
(statearr_26532[(17)] = inst_26169__$1);

return statearr_26532;
})();
if(cljs.core.truth_(inst_26169__$1)){
var statearr_26533_26714 = state_26412__$1;
(statearr_26533_26714[(1)] = (26));

} else {
var statearr_26534_26715 = state_26412__$1;
(statearr_26534_26715[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (47))){
var inst_26140 = (state_26412[(10)]);
var inst_26225 = (state_26412[(30)]);
var inst_26224 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_26140);
var inst_26225__$1 = cljs.core.not.call(null,inst_26224);
var state_26412__$1 = (function (){var statearr_26535 = state_26412;
(statearr_26535[(30)] = inst_26225__$1);

return statearr_26535;
})();
if(inst_26225__$1){
var statearr_26536_26716 = state_26412__$1;
(statearr_26536_26716[(1)] = (50));

} else {
var statearr_26537_26717 = state_26412__$1;
(statearr_26537_26717[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (35))){
var inst_26192 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26193 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_26194 = cljs.core.PersistentHashMap.fromArrays(inst_26192,inst_26193);
var inst_26195 = cljs.core.ex_info.call(null,"A boolean _predicate cannot be unique.",inst_26194);
var inst_26196 = (function(){throw inst_26195})();
var state_26412__$1 = state_26412;
var statearr_26538_26718 = state_26412__$1;
(statearr_26538_26718[(2)] = inst_26196);

(statearr_26538_26718[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (82))){
var inst_26292 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
var statearr_26539_26719 = state_26412__$1;
(statearr_26539_26719[(2)] = inst_26292);

(statearr_26539_26719[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (76))){
var state_26412__$1 = state_26412;
var statearr_26540_26720 = state_26412__$1;
(statearr_26540_26720[(2)] = null);

(statearr_26540_26720[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (97))){
var inst_26271 = (state_26412[(8)]);
var inst_26272 = (state_26412[(9)]);
var inst_26330 = fluree.db.query.schema.type_error.call(null,inst_26271,inst_26272,throw_QMARK_);
var state_26412__$1 = state_26412;
var statearr_26541_26721 = state_26412__$1;
(statearr_26541_26721[(2)] = inst_26330);

(statearr_26541_26721[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (19))){
var inst_26164 = (state_26412[(24)]);
var inst_26140 = (state_26412[(10)]);
var inst_26163 = (state_26412[(2)]);
var inst_26164__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_26140);
var state_26412__$1 = (function (){var statearr_26542 = state_26412;
(statearr_26542[(24)] = inst_26164__$1);

(statearr_26542[(26)] = inst_26163);

return statearr_26542;
})();
if(cljs.core.truth_(inst_26164__$1)){
var statearr_26543_26722 = state_26412__$1;
(statearr_26543_26722[(1)] = (20));

} else {
var statearr_26544_26723 = state_26412__$1;
(statearr_26544_26723[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (57))){
var state_26412__$1 = state_26412;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_26545_26724 = state_26412__$1;
(statearr_26545_26724[(1)] = (60));

} else {
var statearr_26546_26725 = state_26412__$1;
(statearr_26546_26725[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (68))){
var inst_26140 = (state_26412[(10)]);
var inst_26369 = (state_26412[(27)]);
var inst_26367 = (state_26412[(2)]);
var inst_26368 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_26140);
var inst_26369__$1 = inst_26368 === true;
var state_26412__$1 = (function (){var statearr_26547 = state_26412;
(statearr_26547[(7)] = inst_26367);

(statearr_26547[(27)] = inst_26369__$1);

return statearr_26547;
})();
if(cljs.core.truth_(inst_26369__$1)){
var statearr_26548_26726 = state_26412__$1;
(statearr_26548_26726[(1)] = (108));

} else {
var statearr_26549_26727 = state_26412__$1;
(statearr_26549_26727[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (11))){
var inst_26140 = (state_26412[(10)]);
var inst_26148 = (state_26412[(23)]);
var inst_26146 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_26140);
var inst_26147 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_26146);
var inst_26148__$1 = inst_26147 === false;
var state_26412__$1 = (function (){var statearr_26550 = state_26412;
(statearr_26550[(23)] = inst_26148__$1);

return statearr_26550;
})();
if(cljs.core.truth_(inst_26148__$1)){
var statearr_26551_26728 = state_26412__$1;
(statearr_26551_26728[(1)] = (14));

} else {
var statearr_26552_26729 = state_26412__$1;
(statearr_26552_26729[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (115))){
var inst_26375 = (state_26412[(29)]);
var state_26412__$1 = state_26412;
var statearr_26554_26730 = state_26412__$1;
(statearr_26554_26730[(2)] = inst_26375);

(statearr_26554_26730[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (9))){
var inst_26140 = (state_26412[(10)]);
var inst_26144 = (state_26412[(31)]);
var inst_26144__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_26140);
var state_26412__$1 = (function (){var statearr_26555 = state_26412;
(statearr_26555[(31)] = inst_26144__$1);

return statearr_26555;
})();
if(cljs.core.truth_(inst_26144__$1)){
var statearr_26556_26731 = state_26412__$1;
(statearr_26556_26731[(1)] = (11));

} else {
var statearr_26557_26732 = state_26412__$1;
(statearr_26557_26732[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (5))){
var _ = (function (){var statearr_26558 = state_26412;
(statearr_26558[(4)] = cljs.core.rest.call(null,(state_26412[(4)])));

return statearr_26558;
})();
var state_26412__$1 = state_26412;
var ex26553 = (state_26412__$1[(2)]);
var statearr_26559_26733 = state_26412__$1;
(statearr_26559_26733[(5)] = ex26553);


if((ex26553 instanceof Error)){
var statearr_26560_26734 = state_26412__$1;
(statearr_26560_26734[(1)] = (4));

(statearr_26560_26734[(5)] = null);

} else {
throw ex26553;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (112))){
var inst_26371 = (state_26412[(25)]);
var state_26412__$1 = state_26412;
var statearr_26561_26735 = state_26412__$1;
(statearr_26561_26735[(2)] = inst_26371);

(statearr_26561_26735[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (83))){
var inst_26271 = (state_26412[(8)]);
var inst_26272 = (state_26412[(9)]);
var inst_26294 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_26295 = inst_26272.call(null,cljs.core.PersistentArrayMap,null,3,inst_26294,null);
var inst_26296 = inst_26272.call(null,cljs.core.PersistentHashSet,null,inst_26295,null);
var inst_26297 = inst_26296.call(null,inst_26271);
var state_26412__$1 = state_26412;
if(cljs.core.truth_(inst_26297)){
var statearr_26562_26736 = state_26412__$1;
(statearr_26562_26736[(1)] = (84));

} else {
var statearr_26563_26737 = state_26412__$1;
(statearr_26563_26737[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (14))){
var inst_26140 = (state_26412[(10)]);
var inst_26150 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_26140);
var inst_26151 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_26150);
var inst_26152 = inst_26151 === true;
var state_26412__$1 = state_26412;
var statearr_26564_26738 = state_26412__$1;
(statearr_26564_26738[(2)] = inst_26152);

(statearr_26564_26738[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (45))){
var inst_26202 = (state_26412[(28)]);
var state_26412__$1 = state_26412;
var statearr_26565_26739 = state_26412__$1;
(statearr_26565_26739[(2)] = inst_26202);

(statearr_26565_26739[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (53))){
var inst_26139 = (state_26412[(15)]);
var inst_26128 = (state_26412[(16)]);
var inst_26231 = fluree.db.query.schema.pred_objects_unique_QMARK_.call(null,inst_26128,inst_26139);
var state_26412__$1 = state_26412;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26412__$1,(56),inst_26231);
} else {
if((state_val_26413 === (78))){
var inst_26357 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
var statearr_26566_26740 = state_26412__$1;
(statearr_26566_26740[(2)] = inst_26357);

(statearr_26566_26740[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (26))){
var inst_26140 = (state_26412[(10)]);
var inst_26173 = (state_26412[(35)]);
var inst_26171 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_26140);
var inst_26172 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_26171);
var inst_26173__$1 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_26172);
var state_26412__$1 = (function (){var statearr_26567 = state_26412;
(statearr_26567[(35)] = inst_26173__$1);

return statearr_26567;
})();
if(inst_26173__$1){
var statearr_26568_26741 = state_26412__$1;
(statearr_26568_26741[(1)] = (29));

} else {
var statearr_26569_26742 = state_26412__$1;
(statearr_26569_26742[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (16))){
var inst_26155 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
var statearr_26570_26743 = state_26412__$1;
(statearr_26570_26743[(2)] = inst_26155);

(statearr_26570_26743[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (81))){
var inst_26271 = (state_26412[(8)]);
var inst_26272 = (state_26412[(9)]);
var inst_26290 = fluree.db.query.schema.type_error.call(null,inst_26271,inst_26272,throw_QMARK_);
var state_26412__$1 = state_26412;
var statearr_26571_26744 = state_26412__$1;
(statearr_26571_26744[(2)] = inst_26290);

(statearr_26571_26744[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (120))){
var inst_26392 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26393 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_26394 = cljs.core.PersistentHashMap.fromArrays(inst_26392,inst_26393);
var inst_26395 = cljs.core.ex_info.call(null,"A component _predicate must be of type \"ref.\"",inst_26394);
var inst_26396 = (function(){throw inst_26395})();
var state_26412__$1 = state_26412;
var statearr_26572_26745 = state_26412__$1;
(statearr_26572_26745[(2)] = inst_26396);

(statearr_26572_26745[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (79))){
var inst_26271 = (state_26412[(8)]);
var inst_26272 = (state_26412[(9)]);
var inst_26284 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_26285 = inst_26272.call(null,cljs.core.PersistentArrayMap,null,2,inst_26284,null);
var inst_26286 = inst_26272.call(null,cljs.core.PersistentHashSet,null,inst_26285,null);
var inst_26287 = inst_26286.call(null,inst_26271);
var state_26412__$1 = state_26412;
if(cljs.core.truth_(inst_26287)){
var statearr_26573_26746 = state_26412__$1;
(statearr_26573_26746[(1)] = (80));

} else {
var statearr_26574_26747 = state_26412__$1;
(statearr_26574_26747[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (38))){
var inst_26140 = (state_26412[(10)]);
var inst_26206 = (state_26412[(36)]);
var inst_26205 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_26140);
var inst_26206__$1 = cljs.core.not.call(null,inst_26205);
var state_26412__$1 = (function (){var statearr_26575 = state_26412;
(statearr_26575[(36)] = inst_26206__$1);

return statearr_26575;
})();
if(inst_26206__$1){
var statearr_26576_26748 = state_26412__$1;
(statearr_26576_26748[(1)] = (41));

} else {
var statearr_26577_26749 = state_26412__$1;
(statearr_26577_26749[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (98))){
var inst_26332 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
var statearr_26578_26750 = state_26412__$1;
(statearr_26578_26750[(2)] = inst_26332);

(statearr_26578_26750[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (87))){
var inst_26271 = (state_26412[(8)]);
var inst_26272 = (state_26412[(9)]);
var inst_26304 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_26305 = inst_26272.call(null,cljs.core.PersistentArrayMap,null,3,inst_26304,null);
var inst_26306 = inst_26272.call(null,cljs.core.PersistentHashSet,null,inst_26305,null);
var inst_26307 = inst_26306.call(null,inst_26271);
var state_26412__$1 = state_26412;
if(cljs.core.truth_(inst_26307)){
var statearr_26579_26751 = state_26412__$1;
(statearr_26579_26751[(1)] = (88));

} else {
var statearr_26580_26752 = state_26412__$1;
(statearr_26580_26752[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (30))){
var inst_26173 = (state_26412[(35)]);
var state_26412__$1 = state_26412;
var statearr_26581_26753 = state_26412__$1;
(statearr_26581_26753[(2)] = inst_26173);

(statearr_26581_26753[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (73))){
var state_26412__$1 = state_26412;
var statearr_26582_26754 = state_26412__$1;
(statearr_26582_26754[(1)] = (75));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (96))){
var inst_26259 = (state_26412[(12)]);
var state_26412__$1 = state_26412;
var statearr_26584_26755 = state_26412__$1;
(statearr_26584_26755[(2)] = inst_26259);

(statearr_26584_26755[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (10))){
var inst_26405 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
var statearr_26585_26756 = state_26412__$1;
(statearr_26585_26756[(2)] = inst_26405);

(statearr_26585_26756[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (18))){
var inst_26128 = (state_26412[(16)]);
var state_26412__$1 = state_26412;
var statearr_26586_26757 = state_26412__$1;
(statearr_26586_26757[(2)] = inst_26128);

(statearr_26586_26757[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (105))){
var inst_26271 = (state_26412[(8)]);
var inst_26272 = (state_26412[(9)]);
var inst_26350 = fluree.db.query.schema.type_error.call(null,inst_26271,inst_26272,throw_QMARK_);
var state_26412__$1 = state_26412;
var statearr_26587_26758 = state_26412__$1;
(statearr_26587_26758[(2)] = inst_26350);

(statearr_26587_26758[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (52))){
var inst_26241 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
var statearr_26588_26759 = state_26412__$1;
(statearr_26588_26759[(2)] = inst_26241);

(statearr_26588_26759[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (114))){
var inst_26140 = (state_26412[(10)]);
var inst_26377 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_26140);
var inst_26378 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_26377);
var inst_26379 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"ref","ref",1289896967),inst_26378);
var inst_26380 = (!(inst_26379));
var state_26412__$1 = state_26412;
var statearr_26589_26760 = state_26412__$1;
(statearr_26589_26760[(2)] = inst_26380);

(statearr_26589_26760[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (67))){
var inst_26259 = (state_26412[(12)]);
var state_26412__$1 = state_26412;
var statearr_26590_26761 = state_26412__$1;
(statearr_26590_26761[(2)] = inst_26259);

(statearr_26590_26761[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (71))){
var inst_26364 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
var statearr_26591_26762 = state_26412__$1;
(statearr_26591_26762[(2)] = inst_26364);

(statearr_26591_26762[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (42))){
var inst_26206 = (state_26412[(36)]);
var state_26412__$1 = state_26412;
var statearr_26592_26763 = state_26412__$1;
(statearr_26592_26763[(2)] = inst_26206);

(statearr_26592_26763[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (80))){
var inst_26259 = (state_26412[(12)]);
var state_26412__$1 = state_26412;
var statearr_26593_26764 = state_26412__$1;
(statearr_26593_26764[(2)] = inst_26259);

(statearr_26593_26764[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (37))){
var inst_26199 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
var statearr_26594_26765 = state_26412__$1;
(statearr_26594_26765[(2)] = inst_26199);

(statearr_26594_26765[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (63))){
var inst_26140 = (state_26412[(10)]);
var inst_26262 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_26140);
var inst_26263 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_26262);
var state_26412__$1 = state_26412;
var statearr_26595_26766 = state_26412__$1;
(statearr_26595_26766[(2)] = inst_26263);

(statearr_26595_26766[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (94))){
var inst_26322 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
var statearr_26596_26767 = state_26412__$1;
(statearr_26596_26767[(2)] = inst_26322);

(statearr_26596_26767[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (8))){
var inst_26128 = (state_26412[(16)]);
var state_26412__$1 = state_26412;
var statearr_26597_26768 = state_26412__$1;
(statearr_26597_26768[(2)] = inst_26128);

(statearr_26597_26768[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (49))){
var inst_26244 = (state_26412[(2)]);
var state_26412__$1 = state_26412;
if(cljs.core.truth_(inst_26244)){
var statearr_26598_26769 = state_26412__$1;
(statearr_26598_26769[(1)] = (57));

} else {
var statearr_26599_26770 = state_26412__$1;
(statearr_26599_26770[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26413 === (84))){
var inst_26259 = (state_26412[(12)]);
var state_26412__$1 = state_26412;
var statearr_26600_26771 = state_26412__$1;
(statearr_26600_26771[(2)] = inst_26259);

(statearr_26600_26771[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__10903__auto__ = null;
var fluree$db$query$schema$state_machine__10903__auto____0 = (function (){
var statearr_26601 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26601[(0)] = fluree$db$query$schema$state_machine__10903__auto__);

(statearr_26601[(1)] = (1));

return statearr_26601;
});
var fluree$db$query$schema$state_machine__10903__auto____1 = (function (state_26412){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_26412);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e26602){var ex__10906__auto__ = e26602;
var statearr_26603_26772 = state_26412;
(statearr_26603_26772[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_26412[(4)]))){
var statearr_26604_26773 = state_26412;
(statearr_26604_26773[(1)] = cljs.core.first.call(null,(state_26412[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26774 = state_26412;
state_26412 = G__26774;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__10903__auto__ = function(state_26412){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__10903__auto____1.call(this,state_26412);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__10903__auto____0;
fluree$db$query$schema$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__10903__auto____1;
return fluree$db$query$schema$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_26605 = f__10977__auto__.call(null);
(statearr_26605[(6)] = c__10976__auto__);

return statearr_26605;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__26776 = arguments.length;
switch (G__26776) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.call(null,db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_26800){
var state_val_26801 = (state_26800[(1)]);
if((state_val_26801 === (7))){
var state_26800__$1 = state_26800;
var statearr_26802_26822 = state_26800__$1;
(statearr_26802_26822[(2)] = db);

(statearr_26802_26822[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26801 === (1))){
var state_26800__$1 = state_26800;
var statearr_26803_26823 = state_26800__$1;
(statearr_26803_26823[(2)] = null);

(statearr_26803_26823[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26801 === (4))){
var inst_26777 = (state_26800[(2)]);
var state_26800__$1 = state_26800;
var statearr_26804_26824 = state_26800__$1;
(statearr_26804_26824[(2)] = inst_26777);

(statearr_26804_26824[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26801 === (6))){
var inst_26786 = (state_26800[(7)]);
var inst_26785 = (state_26800[(2)]);
var inst_26786__$1 = fluree.db.util.async.throw_err.call(null,inst_26785);
var inst_26787 = cljs.core.empty_QMARK_.call(null,inst_26786__$1);
var state_26800__$1 = (function (){var statearr_26805 = state_26800;
(statearr_26805[(7)] = inst_26786__$1);

return statearr_26805;
})();
if(inst_26787){
var statearr_26806_26825 = state_26800__$1;
(statearr_26806_26825[(1)] = (7));

} else {
var statearr_26807_26826 = state_26800__$1;
(statearr_26807_26826[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26801 === (3))){
var inst_26798 = (state_26800[(2)]);
var state_26800__$1 = state_26800;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26800__$1,inst_26798);
} else {
if((state_val_26801 === (2))){
var _ = (function (){var statearr_26809 = state_26800;
(statearr_26809[(4)] = cljs.core.cons.call(null,(5),(state_26800[(4)])));

return statearr_26809;
})();
var inst_26783 = fluree.db.query.schema.new_pred_changes.call(null,db,tempids,flakes,filter_QMARK_);
var state_26800__$1 = state_26800;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26800__$1,(6),inst_26783);
} else {
if((state_val_26801 === (9))){
var inst_26795 = (state_26800[(2)]);
var _ = (function (){var statearr_26810 = state_26800;
(statearr_26810[(4)] = cljs.core.rest.call(null,(state_26800[(4)])));

return statearr_26810;
})();
var state_26800__$1 = state_26800;
var statearr_26811_26827 = state_26800__$1;
(statearr_26811_26827[(2)] = inst_26795);

(statearr_26811_26827[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26801 === (5))){
var _ = (function (){var statearr_26812 = state_26800;
(statearr_26812[(4)] = cljs.core.rest.call(null,(state_26800[(4)])));

return statearr_26812;
})();
var state_26800__$1 = state_26800;
var ex26808 = (state_26800__$1[(2)]);
var statearr_26813_26828 = state_26800__$1;
(statearr_26813_26828[(5)] = ex26808);


if((ex26808 instanceof Error)){
var statearr_26814_26829 = state_26800__$1;
(statearr_26814_26829[(1)] = (4));

(statearr_26814_26829[(5)] = null);

} else {
throw ex26808;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26801 === (10))){
var inst_26792 = (state_26800[(2)]);
var inst_26793 = fluree.db.util.async.throw_err.call(null,inst_26792);
var state_26800__$1 = state_26800;
var statearr_26815_26830 = state_26800__$1;
(statearr_26815_26830[(2)] = inst_26793);

(statearr_26815_26830[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26801 === (8))){
var inst_26786 = (state_26800[(7)]);
var inst_26790 = fluree.db.query.schema.predicate_change_error.call(null,inst_26786,db,true);
var state_26800__$1 = state_26800;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26800__$1,(10),inst_26790);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__10903__auto__ = null;
var fluree$db$query$schema$state_machine__10903__auto____0 = (function (){
var statearr_26816 = [null,null,null,null,null,null,null,null];
(statearr_26816[(0)] = fluree$db$query$schema$state_machine__10903__auto__);

(statearr_26816[(1)] = (1));

return statearr_26816;
});
var fluree$db$query$schema$state_machine__10903__auto____1 = (function (state_26800){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_26800);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e26817){var ex__10906__auto__ = e26817;
var statearr_26818_26831 = state_26800;
(statearr_26818_26831[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_26800[(4)]))){
var statearr_26819_26832 = state_26800;
(statearr_26819_26832[(1)] = cljs.core.first.call(null,(state_26800[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26833 = state_26800;
state_26800 = G__26833;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__10903__auto__ = function(state_26800){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__10903__auto____1.call(this,state_26800);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__10903__auto____0;
fluree$db$query$schema$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__10903__auto____1;
return fluree$db$query$schema$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_26820 = f__10977__auto__.call(null);
(statearr_26820[(6)] = c__10976__auto__);

return statearr_26820;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__26835 = arguments.length;
switch (G__26835) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.call(null,predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__26837 = cljs.core.re_matches.call(null,/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.call(null,vec__26837,(0),null);
var ns = cljs.core.nth.call(null,vec__26837,(1),null);
var name = cljs.core.nth.call(null,vec__26837,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.call(null,"_",cljs.core.nth.call(null,name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.call(null,name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(2)),fluree.db.flake.__GT_sid.call(null,(3),(9)),fluree.db.flake.__GT_sid.call(null,(3),(14)),fluree.db.flake.__GT_sid.call(null,(3),(16)),fluree.db.flake.__GT_sid.call(null,(3),(8)),fluree.db.flake.__GT_sid.call(null,(3),(4)),fluree.db.flake.__GT_sid.call(null,(3),(5)),fluree.db.flake.__GT_sid.call(null,(3),(15)),fluree.db.flake.__GT_sid.call(null,(3),(17)),fluree.db.flake.__GT_sid.call(null,(3),(11)),fluree.db.flake.__GT_sid.call(null,(3),(12)),fluree.db.flake.__GT_sid.call(null,(3),(1)),fluree.db.flake.__GT_sid.call(null,(3),(10)),fluree.db.flake.__GT_sid.call(null,(3),(6)),fluree.db.flake.__GT_sid.call(null,(3),(7)),fluree.db.flake.__GT_sid.call(null,(3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(62)),fluree.db.flake.__GT_sid.call(null,(3),(68)),fluree.db.flake.__GT_sid.call(null,(3),(67)),fluree.db.flake.__GT_sid.call(null,(3),(69)),fluree.db.flake.__GT_sid.call(null,(3),(63)),fluree.db.flake.__GT_sid.call(null,(3),(70)),fluree.db.flake.__GT_sid.call(null,(3),(65)),fluree.db.flake.__GT_sid.call(null,(3),(66)),fluree.db.flake.__GT_sid.call(null,(3),(64)),fluree.db.flake.__GT_sid.call(null,(3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.call(null,(function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.call(null,acc,p);
if(cljs.core.truth_((function (){var and__4251__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.vector_QMARK_.call(null,existing_QMARK_);
} else {
return and__4251__auto__;
}
})())){
return cljs.core.update.call(null,acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.call(null,acc,p,(function (p1__26840_SHARP_,p2__26841_SHARP_){
return cljs.core.vec.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__26840_SHARP_,p2__26841_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.call(null,acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec.call(null,cljs.core.keep.call(null,(function (p1__26842_SHARP_){
var f = p1__26842_SHARP_;
if(cljs.core._EQ_.call(null,spec_pid,f.p)){
return f.o;
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_26908){
var state_val_26909 = (state_26908[(1)]);
if((state_val_26909 === (1))){
var state_26908__$1 = state_26908;
var statearr_26910_26927 = state_26908__$1;
(statearr_26910_26927[(2)] = null);

(statearr_26910_26927[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (2))){
var _ = (function (){var statearr_26911 = state_26908;
(statearr_26911[(4)] = cljs.core.cons.call(null,(5),(state_26908[(4)])));

return statearr_26911;
})();
var inst_26860 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26861 = fluree.db.flake.max_subject_id.call(null,(1));
var inst_26862 = [inst_26861];
var inst_26863 = (new cljs.core.PersistentVector(null,1,(5),inst_26860,inst_26862,null));
var inst_26864 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26865 = [(0)];
var inst_26866 = (new cljs.core.PersistentVector(null,1,(5),inst_26864,inst_26865,null));
var inst_26867 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_26863,cljs.core._LT__EQ_,inst_26866);
var state_26908__$1 = state_26908;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26908__$1,(6),inst_26867);
} else {
if((state_val_26909 === (3))){
var inst_26906 = (state_26908[(2)]);
var state_26908__$1 = state_26908;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26908__$1,inst_26906);
} else {
if((state_val_26909 === (4))){
var inst_26848 = (state_26908[(2)]);
var state_26908__$1 = state_26908;
var statearr_26913_26928 = state_26908__$1;
(statearr_26913_26928[(2)] = inst_26848);

(statearr_26913_26928[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (5))){
var _ = (function (){var statearr_26914 = state_26908;
(statearr_26914[(4)] = cljs.core.rest.call(null,(state_26908[(4)])));

return statearr_26914;
})();
var state_26908__$1 = state_26908;
var ex26912 = (state_26908__$1[(2)]);
var statearr_26915_26929 = state_26908__$1;
(statearr_26915_26929[(5)] = ex26912);


if((ex26912 instanceof Error)){
var statearr_26916_26930 = state_26908__$1;
(statearr_26916_26930[(1)] = (4));

(statearr_26916_26930[(5)] = null);

} else {
throw ex26912;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (6))){
var inst_26869 = (state_26908[(2)]);
var inst_26870 = fluree.db.util.async.throw_err.call(null,inst_26869);
var inst_26871 = (function (){var schema_flakes = inst_26870;
return (function (p1__26843_SHARP_){
return (p1__26843_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_26872 = cljs.core.partition_by.call(null,inst_26871,inst_26870);
var inst_26873 = cljs.core.nth.call(null,inst_26872,(0),null);
var inst_26874 = cljs.core.nth.call(null,inst_26872,(1),null);
var inst_26875 = (function (){var schema_flakes = inst_26870;
var vec__26854 = inst_26872;
var collection_flakes = inst_26873;
var predicate_flakes = inst_26874;
return (function (acc,coll_flakes){
var first_flake = cljs.core.first.call(null,coll_flakes);
var sid = first_flake.s;
var p__GT_v = cljs.core.reduce.call(null,(function (p1__26846_SHARP_,p2__26845_SHARP_){
var f = p2__26845_SHARP_;
return cljs.core.assoc.call(null,p1__26846_SHARP_,f.p,f.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__4253__auto__ = cljs.core.get.call(null,p__GT_v,(47));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.flake.sid__GT_i.call(null,sid);
}
})();
var c_name = cljs.core.get.call(null,p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids.call(null,(43),coll_flakes):null);
var specDoc = cljs.core.get.call(null,p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),specs,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),partition,new cljs.core.Keyword(null,"partition","partition",1174740751),partition], null);
return cljs.core.assoc.call(null,acc,partition,c_props,c_name,c_props);
});
})();
var inst_26876 = [(-1),"_tx"];
var inst_26877 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_26878 = ["_tx",(-1),(-1),(-1),null,null];
var inst_26879 = cljs.core.PersistentHashMap.fromArrays(inst_26877,inst_26878);
var inst_26880 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_26881 = ["_tx",(-1),(-1),(-1),null,null];
var inst_26882 = cljs.core.PersistentHashMap.fromArrays(inst_26880,inst_26881);
var inst_26883 = [inst_26879,inst_26882];
var inst_26884 = cljs.core.PersistentHashMap.fromArrays(inst_26876,inst_26883);
var inst_26885 = (function (){var schema_flakes = inst_26870;
var vec__26854 = inst_26872;
var collection_flakes = inst_26873;
var predicate_flakes = inst_26874;
return (function (p1__26844_SHARP_){
return p1__26844_SHARP_.s;
});
})();
var inst_26886 = cljs.core.partition_by.call(null,inst_26885,inst_26873);
var inst_26887 = cljs.core.reduce.call(null,inst_26875,inst_26884,inst_26886);
var inst_26889 = (function (){var schema_flakes = inst_26870;
var vec__26854 = inst_26872;
var collection_flakes = inst_26873;
var predicate_flakes = inst_26874;
var coll = inst_26887;
return (function (p__26888,pred_flakes){
var vec__26917 = p__26888;
var pred = cljs.core.nth.call(null,vec__26917,(0),null);
var fullText = cljs.core.nth.call(null,vec__26917,(1),null);
var first_flake = cljs.core.first.call(null,pred_flakes);
var id = first_flake.s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map.call(null,pred_flakes);
var p_name = cljs.core.get.call(null,p__GT_v,(10));
var p_type = cljs.core.get.call(null,fluree.db.query.schema.type_sid__GT_type,cljs.core.get.call(null,p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null).call(null,p_type));
var idx_QMARK_ = cljs.core.boolean$.call(null,(function (){var or__4253__auto__ = ref_QMARK_;
if(or__4253__auto__){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = cljs.core.get.call(null,p__GT_v,(15));
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return cljs.core.get.call(null,p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.call(null,p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(13))),cljs.core.get.call(null,p__GT_v,(19)),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(15))),p_name,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids.call(null,(24),pred_flakes):null),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(17))),cljs.core.get.call(null,p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids.call(null,(20),pred_flakes):null),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(14))),id,cljs.core.get.call(null,p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(16))),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(29))),cljs.core.get.call(null,p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,pred,id,p_props,p_name,p_props),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.call(null,fullText,id):fullText)], null);
});
})();
var inst_26890 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26891 = cljs.core.PersistentHashMap.EMPTY;
var inst_26892 = cljs.core.PersistentHashSet.EMPTY;
var inst_26893 = [inst_26891,inst_26892];
var inst_26894 = (new cljs.core.PersistentVector(null,2,(5),inst_26890,inst_26893,null));
var inst_26895 = (function (){var schema_flakes = inst_26870;
var vec__26854 = inst_26872;
var collection_flakes = inst_26873;
var predicate_flakes = inst_26874;
var coll = inst_26887;
return (function (p1__26847_SHARP_){
return p1__26847_SHARP_.s;
});
})();
var inst_26896 = cljs.core.partition_by.call(null,inst_26895,inst_26874);
var inst_26897 = cljs.core.reduce.call(null,inst_26889,inst_26894,inst_26896);
var inst_26898 = cljs.core.nth.call(null,inst_26897,(0),null);
var inst_26899 = cljs.core.nth.call(null,inst_26897,(1),null);
var inst_26900 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_26901 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_26902 = [inst_26901,inst_26887,inst_26898,inst_26899];
var inst_26903 = cljs.core.PersistentHashMap.fromArrays(inst_26900,inst_26902);
var _ = (function (){var statearr_26920 = state_26908;
(statearr_26920[(4)] = cljs.core.rest.call(null,(state_26908[(4)])));

return statearr_26920;
})();
var state_26908__$1 = state_26908;
var statearr_26921_26931 = state_26908__$1;
(statearr_26921_26931[(2)] = inst_26903);

(statearr_26921_26931[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__10903__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__10903__auto____0 = (function (){
var statearr_26922 = [null,null,null,null,null,null,null];
(statearr_26922[(0)] = fluree$db$query$schema$schema_map_$_state_machine__10903__auto__);

(statearr_26922[(1)] = (1));

return statearr_26922;
});
var fluree$db$query$schema$schema_map_$_state_machine__10903__auto____1 = (function (state_26908){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_26908);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e26923){var ex__10906__auto__ = e26923;
var statearr_26924_26932 = state_26908;
(statearr_26924_26932[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_26908[(4)]))){
var statearr_26925_26933 = state_26908;
(statearr_26925_26933[(1)] = cljs.core.first.call(null,(state_26908[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26934 = state_26908;
state_26908 = G__26934;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__10903__auto__ = function(state_26908){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__10903__auto____1.call(this,state_26908);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__10903__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__10903__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_26926 = f__10977__auto__.call(null);
(statearr_26926[(6)] = c__10976__auto__);

return statearr_26926;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_26976){
var state_val_26977 = (state_26976[(1)]);
if((state_val_26977 === (7))){
var inst_26959 = (state_26976[(2)]);
var inst_26960 = fluree.db.query.schema.flake__GT_pred_map.call(null,inst_26959);
var inst_26961 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_26962 = cljs.core.get.call(null,inst_26960,(114));
var inst_26963 = cljs.core.boolean$.call(null,inst_26962);
var inst_26964 = cljs.core.get.call(null,inst_26960,(110));
var inst_26965 = cljs.core.get.call(null,inst_26960,(117));
var inst_26966 = cljs.core.get.call(null,fluree.db.query.schema.lang_sid__GT_lang,inst_26965);
var inst_26967 = cljs.core.get.call(null,inst_26960,(111));
var inst_26968 = cljs.core.get.call(null,inst_26960,(115));
var inst_26969 = cljs.core.get.call(null,inst_26960,(112));
var inst_26970 = [inst_26963,inst_26964,inst_26966,inst_26967,inst_26968,inst_26969];
var inst_26971 = cljs.core.PersistentHashMap.fromArrays(inst_26961,inst_26970);
var _ = (function (){var statearr_26978 = state_26976;
(statearr_26978[(4)] = cljs.core.rest.call(null,(state_26976[(4)])));

return statearr_26978;
})();
var state_26976__$1 = state_26976;
var statearr_26979_27002 = state_26976__$1;
(statearr_26979_27002[(2)] = inst_26971);

(statearr_26979_27002[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26977 === (1))){
var state_26976__$1 = state_26976;
var statearr_26980_27003 = state_26976__$1;
(statearr_26980_27003[(2)] = null);

(statearr_26980_27003[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26977 === (4))){
var inst_26935 = (state_26976[(2)]);
var state_26976__$1 = state_26976;
var statearr_26981_27004 = state_26976__$1;
(statearr_26981_27004[(2)] = inst_26935);

(statearr_26981_27004[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26977 === (6))){
var _ = (function (){var statearr_26982 = state_26976;
(statearr_26982[(4)] = cljs.core.cons.call(null,(9),(state_26976[(4)])));

return statearr_26982;
})();
var inst_26947 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26948 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26949 = ["_setting/id","root"];
var inst_26950 = (new cljs.core.PersistentVector(null,2,(5),inst_26948,inst_26949,null));
var inst_26951 = [inst_26950];
var inst_26952 = (new cljs.core.PersistentVector(null,1,(5),inst_26947,inst_26951,null));
var inst_26953 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_26952);
var state_26976__$1 = state_26976;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26976__$1,(10),inst_26953);
} else {
if((state_val_26977 === (3))){
var inst_26974 = (state_26976[(2)]);
var state_26976__$1 = state_26976;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26976__$1,inst_26974);
} else {
if((state_val_26977 === (2))){
var _ = (function (){var statearr_26985 = state_26976;
(statearr_26985[(4)] = cljs.core.cons.call(null,(5),(state_26976[(4)])));

return statearr_26985;
})();
var state_26976__$1 = state_26976;
var statearr_26986_27005 = state_26976__$1;
(statearr_26986_27005[(2)] = null);

(statearr_26986_27005[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26977 === (9))){
var _ = (function (){var statearr_26987 = state_26976;
(statearr_26987[(4)] = cljs.core.rest.call(null,(state_26976[(4)])));

return statearr_26987;
})();
var state_26976__$1 = state_26976;
var ex26983 = (state_26976__$1[(2)]);
var statearr_26988_27006 = state_26976__$1;
(statearr_26988_27006[(5)] = ex26983);


var statearr_26989_27007 = state_26976__$1;
(statearr_26989_27007[(1)] = (8));

(statearr_26989_27007[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26977 === (5))){
var _ = (function (){var statearr_26990 = state_26976;
(statearr_26990[(4)] = cljs.core.rest.call(null,(state_26976[(4)])));

return statearr_26990;
})();
var state_26976__$1 = state_26976;
var ex26984 = (state_26976__$1[(2)]);
var statearr_26991_27008 = state_26976__$1;
(statearr_26991_27008[(5)] = ex26984);


if((ex26984 instanceof Error)){
var statearr_26992_27009 = state_26976__$1;
(statearr_26992_27009[(1)] = (4));

(statearr_26992_27009[(5)] = null);

} else {
throw ex26984;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26977 === (10))){
var inst_26955 = (state_26976[(2)]);
var inst_26956 = fluree.db.util.async.throw_err.call(null,inst_26955);
var _ = (function (){var statearr_26993 = state_26976;
(statearr_26993[(4)] = cljs.core.rest.call(null,(state_26976[(4)])));

return statearr_26993;
})();
var state_26976__$1 = state_26976;
var statearr_26994_27010 = state_26976__$1;
(statearr_26994_27010[(2)] = inst_26956);

(statearr_26994_27010[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26977 === (8))){
var inst_26941 = (state_26976[(2)]);
var state_26976__$1 = (function (){var statearr_26995 = state_26976;
(statearr_26995[(7)] = inst_26941);

return statearr_26995;
})();
var statearr_26996_27011 = state_26976__$1;
(statearr_26996_27011[(2)] = null);

(statearr_26996_27011[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__10903__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__10903__auto____0 = (function (){
var statearr_26997 = [null,null,null,null,null,null,null,null];
(statearr_26997[(0)] = fluree$db$query$schema$setting_map_$_state_machine__10903__auto__);

(statearr_26997[(1)] = (1));

return statearr_26997;
});
var fluree$db$query$schema$setting_map_$_state_machine__10903__auto____1 = (function (state_26976){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_26976);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e26998){var ex__10906__auto__ = e26998;
var statearr_26999_27012 = state_26976;
(statearr_26999_27012[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_26976[(4)]))){
var statearr_27000_27013 = state_26976;
(statearr_27000_27013[(1)] = cljs.core.first.call(null,(state_26976[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27014 = state_26976;
state_26976 = G__27014;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__10903__auto__ = function(state_26976){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__10903__auto____1.call(this,state_26976);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__10903__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__10903__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_27001 = f__10977__auto__.call(null);
(statearr_27001[(6)] = c__10976__auto__);

return statearr_27001;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
