// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql.vswap_BANG_ = (function fluree$db$query$fql$vswap_BANG_(var_args){
var G__32157 = arguments.length;
switch (G__32157) {
case 2:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol)));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2,arg3));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__32160 = arguments.length;
switch (G__32160) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__32162 = null;
var G__32162__0 = (function (){
return xf.call(null);
});
var G__32162__1 = (function (result){
return xf.call(null,result);
});
var G__32162__2 = (function (result,flake){
fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return xf.call(null,result,flake);
});
G__32162 = function(result,flake){
switch(arguments.length){
case 0:
return G__32162__0.call(this);
case 1:
return G__32162__1.call(this,result);
case 2:
return G__32162__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__32162.cljs$core$IFn$_invoke$arity$0 = G__32162__0;
G__32162.cljs$core$IFn$_invoke$arity$1 = G__32162__1;
G__32162.cljs$core$IFn$_invoke$arity$2 = G__32162__2;
return G__32162;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__32163 = null;
var G__32163__0 = (function (){
return xf.call(null);
});
var G__32163__1 = (function (result){
return xf.call(null,result);
});
var G__32163__2 = (function (result,flakes){
fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,cljs.core.count.call(null,flakes));

return xf.call(null,result,flakes);
});
G__32163 = function(result,flakes){
switch(arguments.length){
case 0:
return G__32163__0.call(this);
case 1:
return G__32163__1.call(this,result);
case 2:
return G__32163__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__32163.cljs$core$IFn$_invoke$arity$0 = G__32163__0;
G__32163.cljs$core$IFn$_invoke$arity$1 = G__32163__1;
G__32163.cljs$core$IFn$_invoke$arity$2 = G__32163__2;
return G__32163;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,n);

if(cljs.core.truth_((function (){var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4253__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config.call(null,db,p,compact_QMARK_);
fluree.db.query.fql.vswap_BANG_.call(null,cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map);

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare.call(null,clojure.string.upper_case.call(null,a),clojure.string.upper_case.call(null,b));
if(cljs.core._EQ_.call(null,res,(0))){
return ((-1) * cljs.core.compare.call(null,a,b));
} else {
return res;
}
} else {
return cljs.core.compare.call(null,a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_.call(null,res)){
var G__32165 = res;
var G__32165__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.call(null,(function (p1__32164_SHARP_){
return cljs.core.get.call(null,p1__32164_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__32165):G__32165);
var G__32165__$2 = ((cljs.core._EQ_.call(null,"DESC",sortOrder))?cljs.core.reverse.call(null,G__32165__$1):G__32165__$1);
var G__32165__$3 = (cljs.core.truth_(offset)?cljs.core.drop.call(null,offset,G__32165__$2):G__32165__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.call(null,limit,G__32165__$3);
} else {
return G__32165__$3;
}
} else {
return res;
}
});
/**
 * Adds a predicate to a select spec graph crawl. flakes input is a list of flakes
 *   all with the same subject and predicate values.
 */
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__32169 = arguments.length;
switch (G__32169) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_32608){
var state_val_32609 = (state_32608[(1)]);
if((state_val_32609 === (121))){
var inst_32531 = (state_32608[(2)]);
var inst_32532 = fluree.db.util.async.throw_err.call(null,inst_32531);
var inst_32533 = cljs.core.seq.call(null,inst_32532);
var state_32608__$1 = state_32608;
if(inst_32533){
var statearr_32610_32824 = state_32608__$1;
(statearr_32610_32824[(1)] = (122));

} else {
var statearr_32611_32825 = state_32608__$1;
(statearr_32611_32825[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (65))){
var inst_32324 = (state_32608[(7)]);
var inst_32323 = (state_32608[(2)]);
var inst_32324__$1 = fluree.db.util.async.throw_err.call(null,inst_32323);
var inst_32325 = cljs.core.seq.call(null,inst_32324__$1);
var state_32608__$1 = (function (){var statearr_32612 = state_32608;
(statearr_32612[(7)] = inst_32324__$1);

return statearr_32612;
})();
if(inst_32325){
var statearr_32613_32826 = state_32608__$1;
(statearr_32613_32826[(1)] = (66));

} else {
var statearr_32614_32827 = state_32608__$1;
(statearr_32614_32827[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (70))){
var inst_32324 = (state_32608[(7)]);
var inst_32335 = cljs.core.count.call(null,inst_32324);
var inst_32336 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_32335);
var state_32608__$1 = state_32608;
var statearr_32615_32828 = state_32608__$1;
(statearr_32615_32828[(2)] = inst_32336);

(statearr_32615_32828[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (62))){
var inst_32314 = (state_32608[(8)]);
var inst_32317 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32318 = inst_32314.o;
var inst_32319 = [inst_32318];
var inst_32320 = (new cljs.core.PersistentVector(null,1,(5),inst_32317,inst_32319,null));
var inst_32321 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_32320);
var state_32608__$1 = state_32608;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32608__$1,(65),inst_32321);
} else {
if((state_val_32609 === (74))){
var inst_32308 = (state_32608[(9)]);
var state_32608__$1 = state_32608;
var statearr_32616_32829 = state_32608__$1;
(statearr_32616_32829[(2)] = inst_32308);

(statearr_32616_32829[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (110))){
var inst_32493 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_32494 = new cljs.core.Keyword(null,"root?","root?",-2045639518).cljs$core$IFn$_invoke$arity$1(inst_32493);
var inst_32495 = inst_32494 === true;
var state_32608__$1 = state_32608;
if(cljs.core.truth_(inst_32495)){
var statearr_32617_32830 = state_32608__$1;
(statearr_32617_32830[(1)] = (113));

} else {
var statearr_32618_32831 = state_32608__$1;
(statearr_32618_32831[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (130))){
var inst_32603 = (state_32608[(2)]);
var _ = (function (){var statearr_32619 = state_32608;
(statearr_32619[(4)] = cljs.core.rest.call(null,(state_32608[(4)])));

return statearr_32619;
})();
var state_32608__$1 = state_32608;
var statearr_32620_32832 = state_32608__$1;
(statearr_32620_32832[(2)] = inst_32603);

(statearr_32620_32832[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (128))){
var inst_32578 = (state_32608[(10)]);
var inst_32581 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32582 = [acc,inst_32578];
var inst_32583 = (new cljs.core.PersistentVector(null,2,(5),inst_32581,inst_32582,null));
var state_32608__$1 = state_32608;
var statearr_32621_32833 = state_32608__$1;
(statearr_32621_32833[(2)] = inst_32583);

(statearr_32621_32833[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (7))){
var inst_32181 = (state_32608[(11)]);
var state_32608__$1 = state_32608;
var statearr_32622_32834 = state_32608__$1;
(statearr_32622_32834[(2)] = inst_32181);

(statearr_32622_32834[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (59))){
var inst_32572 = (state_32608[(2)]);
var state_32608__$1 = state_32608;
var statearr_32623_32835 = state_32608__$1;
(statearr_32623_32835[(2)] = inst_32572);

(statearr_32623_32835[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (86))){
var inst_32402 = (state_32608[(12)]);
var inst_32402__$1 = (state_32608[(2)]);
var state_32608__$1 = (function (){var statearr_32624 = state_32608;
(statearr_32624[(12)] = inst_32402__$1);

return statearr_32624;
})();
if(cljs.core.truth_(inst_32402__$1)){
var statearr_32625_32836 = state_32608__$1;
(statearr_32625_32836[(1)] = (88));

} else {
var statearr_32626_32837 = state_32608__$1;
(statearr_32626_32837[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (20))){
var inst_32210 = (state_32608[(13)]);
var inst_32223 = (state_32608[(14)]);
var inst_32222 = (state_32608[(15)]);
var inst_32221 = (state_32608[(2)]);
var inst_32222__$1 = cljs.core.__destructure_map.call(null,inst_32210);
var inst_32223__$1 = cljs.core.get.call(null,inst_32222__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_32224 = cljs.core.get.call(null,inst_32222__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_32225 = cljs.core.get.call(null,inst_32222__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_32226 = cljs.core.get.call(null,inst_32222__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_32227 = cljs.core.get.call(null,inst_32222__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_32228 = cljs.core.get.call(null,inst_32222__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_32608__$1 = (function (){var statearr_32627 = state_32608;
(statearr_32627[(16)] = inst_32224);

(statearr_32627[(17)] = inst_32221);

(statearr_32627[(18)] = inst_32226);

(statearr_32627[(19)] = inst_32228);

(statearr_32627[(14)] = inst_32223__$1);

(statearr_32627[(20)] = inst_32227);

(statearr_32627[(15)] = inst_32222__$1);

(statearr_32627[(21)] = inst_32225);

return statearr_32627;
})();
if(cljs.core.truth_(inst_32223__$1)){
var statearr_32628_32838 = state_32608__$1;
(statearr_32628_32838[(1)] = (24));

} else {
var statearr_32629_32839 = state_32608__$1;
(statearr_32629_32839[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (72))){
var inst_32333 = (state_32608[(22)]);
var inst_32339 = (state_32608[(2)]);
var inst_32340 = cljs.core.seq.call(null,inst_32333);
var state_32608__$1 = (function (){var statearr_32630 = state_32608;
(statearr_32630[(23)] = inst_32339);

return statearr_32630;
})();
if(inst_32340){
var statearr_32631_32840 = state_32608__$1;
(statearr_32631_32840[(1)] = (73));

} else {
var statearr_32632_32841 = state_32608__$1;
(statearr_32632_32841[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (58))){
var inst_32210 = (state_32608[(13)]);
var inst_32355 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_32210);
var state_32608__$1 = state_32608;
if(cljs.core.truth_(inst_32355)){
var statearr_32633_32842 = state_32608__$1;
(statearr_32633_32842[(1)] = (76));

} else {
var statearr_32634_32843 = state_32608__$1;
(statearr_32634_32843[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (60))){
var inst_32307 = (state_32608[(24)]);
var inst_32314 = (state_32608[(8)]);
var inst_32313 = cljs.core.seq.call(null,inst_32307);
var inst_32314__$1 = cljs.core.first.call(null,inst_32313);
var inst_32315 = cljs.core.next.call(null,inst_32313);
var state_32608__$1 = (function (){var statearr_32635 = state_32608;
(statearr_32635[(25)] = inst_32315);

(statearr_32635[(8)] = inst_32314__$1);

return statearr_32635;
})();
if(cljs.core.truth_(inst_32314__$1)){
var statearr_32636_32844 = state_32608__$1;
(statearr_32636_32844[(1)] = (62));

} else {
var statearr_32637_32845 = state_32608__$1;
(statearr_32637_32845[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (27))){
var inst_32227 = (state_32608[(20)]);
var inst_32231 = (state_32608[(26)]);
var inst_32231__$1 = cljs.core.not_EQ_.call(null,(0),inst_32227);
var state_32608__$1 = (function (){var statearr_32638 = state_32608;
(statearr_32638[(26)] = inst_32231__$1);

return statearr_32638;
})();
if(inst_32231__$1){
var statearr_32639_32846 = state_32608__$1;
(statearr_32639_32846[(1)] = (30));

} else {
var statearr_32640_32847 = state_32608__$1;
(statearr_32640_32847[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (1))){
var state_32608__$1 = state_32608;
var statearr_32641_32848 = state_32608__$1;
(statearr_32641_32848[(2)] = null);

(statearr_32641_32848[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (69))){
var inst_32329 = (state_32608[(2)]);
var inst_32330 = fluree.db.util.async.throw_err.call(null,inst_32329);
var state_32608__$1 = state_32608;
var statearr_32642_32849 = state_32608__$1;
(statearr_32642_32849[(2)] = inst_32330);

(statearr_32642_32849[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (101))){
var inst_32486 = (state_32608[(2)]);
var state_32608__$1 = state_32608;
var statearr_32643_32850 = state_32608__$1;
(statearr_32643_32850[(2)] = inst_32486);

(statearr_32643_32850[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (24))){
var inst_32227 = (state_32608[(20)]);
var state_32608__$1 = state_32608;
if(cljs.core.truth_(inst_32227)){
var statearr_32644_32851 = state_32608__$1;
(statearr_32644_32851[(1)] = (27));

} else {
var statearr_32645_32852 = state_32608__$1;
(statearr_32645_32852[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (102))){
var inst_32458 = (state_32608[(27)]);
var inst_32457 = (state_32608[(2)]);
var inst_32458__$1 = fluree.db.util.async.throw_err.call(null,inst_32457);
var inst_32459 = cljs.core.empty_QMARK_.call(null,inst_32458__$1);
var state_32608__$1 = (function (){var statearr_32646 = state_32608;
(statearr_32646[(27)] = inst_32458__$1);

return statearr_32646;
})();
if(inst_32459){
var statearr_32647_32853 = state_32608__$1;
(statearr_32647_32853[(1)] = (103));

} else {
var statearr_32648_32854 = state_32608__$1;
(statearr_32648_32854[(1)] = (104));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (135))){
var state_32608__$1 = state_32608;
var statearr_32649_32855 = state_32608__$1;
(statearr_32649_32855[(2)] = null);

(statearr_32649_32855[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (55))){
var inst_32210 = (state_32608[(13)]);
var inst_32283 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_32210);
var state_32608__$1 = state_32608;
var statearr_32650_32856 = state_32608__$1;
(statearr_32650_32856[(2)] = inst_32283);

(statearr_32650_32856[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (85))){
var inst_32210 = (state_32608[(13)]);
var inst_32377 = (state_32608[(28)]);
var inst_32389 = inst_32377.o;
var inst_32390 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_32210);
var inst_32391 = fluree.db.dbproto._tag.call(null,db,inst_32389,inst_32390);
var state_32608__$1 = state_32608;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32608__$1,(87),inst_32391);
} else {
if((state_val_32609 === (39))){
var inst_32258 = (state_32608[(29)]);
var inst_32226 = (state_32608[(18)]);
var inst_32258__$1 = cljs.core.not.call(null,inst_32226);
var state_32608__$1 = (function (){var statearr_32651 = state_32608;
(statearr_32651[(29)] = inst_32258__$1);

return statearr_32651;
})();
if(inst_32258__$1){
var statearr_32652_32857 = state_32608__$1;
(statearr_32652_32857[(1)] = (42));

} else {
var statearr_32653_32858 = state_32608__$1;
(statearr_32653_32858[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (88))){
var inst_32402 = (state_32608[(12)]);
var inst_32371 = (state_32608[(30)]);
var inst_32404 = cljs.core.conj.call(null,inst_32371,inst_32402);
var state_32608__$1 = state_32608;
var statearr_32654_32859 = state_32608__$1;
(statearr_32654_32859[(2)] = inst_32404);

(statearr_32654_32859[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (46))){
var inst_32225 = (state_32608[(21)]);
var state_32608__$1 = state_32608;
var statearr_32655_32860 = state_32608__$1;
(statearr_32655_32860[(2)] = inst_32225);

(statearr_32655_32860[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (4))){
var inst_32170 = (state_32608[(2)]);
var state_32608__$1 = state_32608;
var statearr_32656_32861 = state_32608__$1;
(statearr_32656_32861[(2)] = inst_32170);

(statearr_32656_32861[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (77))){
var inst_32417 = (state_32608[(31)]);
var inst_32417__$1 = componentFollow_QMARK_;
var state_32608__$1 = (function (){var statearr_32657 = state_32608;
(statearr_32657[(31)] = inst_32417__$1);

return statearr_32657;
})();
if(cljs.core.truth_(inst_32417__$1)){
var statearr_32658_32862 = state_32608__$1;
(statearr_32658_32862[(1)] = (91));

} else {
var statearr_32659_32863 = state_32608__$1;
(statearr_32659_32863[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (106))){
var inst_32438 = (state_32608[(32)]);
var inst_32472 = (state_32608[(2)]);
var inst_32473 = fluree.db.util.async.throw_err.call(null,inst_32472);
var inst_32474 = cljs.core.conj.call(null,inst_32438,inst_32473);
var state_32608__$1 = state_32608;
var statearr_32660_32864 = state_32608__$1;
(statearr_32660_32864[(2)] = inst_32474);

(statearr_32660_32864[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (119))){
var inst_32516 = (state_32608[(33)]);
var inst_32546 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32547 = [inst_32516,offset_map];
var inst_32548 = (new cljs.core.PersistentVector(null,2,(5),inst_32546,inst_32547,null));
var state_32608__$1 = state_32608;
var statearr_32661_32865 = state_32608__$1;
(statearr_32661_32865[(2)] = inst_32548);

(statearr_32661_32865[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (95))){
var inst_32224 = (state_32608[(16)]);
var state_32608__$1 = state_32608;
if(cljs.core.truth_(inst_32224)){
var statearr_32662_32866 = state_32608__$1;
(statearr_32662_32866[(1)] = (110));

} else {
var statearr_32663_32867 = state_32608__$1;
(statearr_32663_32867[(1)] = (111));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (54))){
var inst_32280 = (state_32608[(34)]);
var state_32608__$1 = state_32608;
var statearr_32664_32868 = state_32608__$1;
(statearr_32664_32868[(2)] = inst_32280);

(statearr_32664_32868[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (92))){
var inst_32417 = (state_32608[(31)]);
var state_32608__$1 = state_32608;
var statearr_32665_32869 = state_32608__$1;
(statearr_32665_32869[(2)] = inst_32417);

(statearr_32665_32869[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (104))){
var inst_32458 = (state_32608[(27)]);
var inst_32180 = (state_32608[(35)]);
var inst_32467 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298)];
var inst_32468 = [true,inst_32180];
var inst_32469 = cljs.core.PersistentHashMap.fromArrays(inst_32467,inst_32468);
var inst_32470 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_32469,inst_32458);
var state_32608__$1 = state_32608;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32608__$1,(106),inst_32470);
} else {
if((state_val_32609 === (15))){
var inst_32180 = (state_32608[(35)]);
var inst_32203 = (state_32608[(36)]);
var inst_32207 = cljs.core.assoc.call(null,inst_32203,new cljs.core.Keyword(null,"compact?","compact?",1216893298),inst_32180);
var state_32608__$1 = state_32608;
var statearr_32666_32870 = state_32608__$1;
(statearr_32666_32870[(2)] = inst_32207);

(statearr_32666_32870[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (48))){
var inst_32274 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32275 = [null,offset_map];
var inst_32276 = (new cljs.core.PersistentVector(null,2,(5),inst_32274,inst_32275,null));
var state_32608__$1 = state_32608;
var statearr_32667_32871 = state_32608__$1;
(statearr_32667_32871[(2)] = inst_32276);

(statearr_32667_32871[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (50))){
var inst_32574 = (state_32608[(2)]);
var state_32608__$1 = state_32608;
var statearr_32668_32872 = state_32608__$1;
(statearr_32668_32872[(2)] = inst_32574);

(statearr_32668_32872[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (116))){
var inst_32515 = (state_32608[(37)]);
var inst_32522 = (state_32608[(38)]);
var inst_32521 = cljs.core.seq.call(null,inst_32515);
var inst_32522__$1 = cljs.core.first.call(null,inst_32521);
var inst_32523 = cljs.core.next.call(null,inst_32521);
var state_32608__$1 = (function (){var statearr_32669 = state_32608;
(statearr_32669[(38)] = inst_32522__$1);

(statearr_32669[(39)] = inst_32523);

return statearr_32669;
})();
if(cljs.core.truth_(inst_32522__$1)){
var statearr_32670_32873 = state_32608__$1;
(statearr_32670_32873[(1)] = (118));

} else {
var statearr_32671_32874 = state_32608__$1;
(statearr_32671_32874[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (75))){
var inst_32315 = (state_32608[(25)]);
var inst_32345 = (state_32608[(2)]);
var inst_32307 = inst_32315;
var inst_32308 = inst_32345;
var state_32608__$1 = (function (){var statearr_32672 = state_32608;
(statearr_32672[(9)] = inst_32308);

(statearr_32672[(24)] = inst_32307);

return statearr_32672;
})();
var statearr_32673_32875 = state_32608__$1;
(statearr_32673_32875[(2)] = null);

(statearr_32673_32875[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (99))){
var inst_32210 = (state_32608[(13)]);
var inst_32444 = (state_32608[(40)]);
var inst_32447 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32448 = inst_32444.o;
var inst_32449 = [inst_32448];
var inst_32450 = (new cljs.core.PersistentVector(null,1,(5),inst_32447,inst_32449,null));
var inst_32451 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_32452 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_32210);
var inst_32453 = [inst_32452];
var inst_32454 = cljs.core.PersistentHashMap.fromArrays(inst_32451,inst_32453);
var inst_32455 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_32450,inst_32454);
var state_32608__$1 = state_32608;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32608__$1,(102),inst_32455);
} else {
if((state_val_32609 === (21))){
var inst_32214 = (state_32608[(41)]);
var state_32608__$1 = state_32608;
var statearr_32674_32876 = state_32608__$1;
(statearr_32674_32876[(2)] = inst_32214);

(statearr_32674_32876[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (31))){
var inst_32231 = (state_32608[(26)]);
var state_32608__$1 = state_32608;
var statearr_32675_32877 = state_32608__$1;
(statearr_32675_32877[(2)] = inst_32231);

(statearr_32675_32877[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (113))){
var inst_32224 = (state_32608[(16)]);
var inst_32195 = (state_32608[(42)]);
var inst_32210 = (state_32608[(13)]);
var inst_32221 = (state_32608[(17)]);
var inst_32226 = (state_32608[(18)]);
var inst_32228 = (state_32608[(19)]);
var inst_32223 = (state_32608[(14)]);
var inst_32227 = (state_32608[(20)]);
var inst_32222 = (state_32608[(15)]);
var inst_32180 = (state_32608[(35)]);
var inst_32225 = (state_32608[(21)]);
var inst_32497 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32498 = (function (){var p = inst_32228;
var pred_spec__$1 = inst_32195;
var orderBy = inst_32226;
var multi_QMARK_ = inst_32223;
var limit = inst_32225;
var offset = inst_32227;
var k = inst_32221;
var map__32176 = inst_32222;
var compact_QMARK_ = inst_32180;
var pred_spec_SINGLEQUOTE_ = inst_32210;
var ref_QMARK_ = inst_32224;
return (function (p1__32166_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"_id","_id",-789960287)],[p1__32166_SHARP_.o]);
});
})();
var inst_32499 = cljs.core.mapv.call(null,inst_32498,flakes);
var inst_32500 = [inst_32499,offset_map];
var inst_32501 = (new cljs.core.PersistentVector(null,2,(5),inst_32497,inst_32500,null));
var state_32608__$1 = state_32608;
var statearr_32676_32878 = state_32608__$1;
(statearr_32676_32878[(2)] = inst_32501);

(statearr_32676_32878[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (32))){
var inst_32237 = (state_32608[(2)]);
var state_32608__$1 = state_32608;
var statearr_32677_32879 = state_32608__$1;
(statearr_32677_32879[(2)] = inst_32237);

(statearr_32677_32879[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (136))){
var inst_32599 = (state_32608[(2)]);
var state_32608__$1 = state_32608;
var statearr_32678_32880 = state_32608__$1;
(statearr_32678_32880[(2)] = inst_32599);

(statearr_32678_32880[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (40))){
var inst_32223 = (state_32608[(14)]);
var state_32608__$1 = state_32608;
var statearr_32679_32881 = state_32608__$1;
(statearr_32679_32881[(2)] = inst_32223);

(statearr_32679_32881[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (129))){
var inst_32223 = (state_32608[(14)]);
var state_32608__$1 = state_32608;
if(cljs.core.truth_(inst_32223)){
var statearr_32680_32882 = state_32608__$1;
(statearr_32680_32882[(1)] = (131));

} else {
var statearr_32681_32883 = state_32608__$1;
(statearr_32681_32883[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (91))){
var inst_32210 = (state_32608[(13)]);
var inst_32419 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_32210);
var state_32608__$1 = state_32608;
var statearr_32682_32884 = state_32608__$1;
(statearr_32682_32884[(2)] = inst_32419);

(statearr_32682_32884[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (117))){
var inst_32552 = (state_32608[(2)]);
var state_32608__$1 = state_32608;
var statearr_32683_32885 = state_32608__$1;
(statearr_32683_32885[(2)] = inst_32552);

(statearr_32683_32885[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (108))){
var state_32608__$1 = state_32608;
var statearr_32684_32886 = state_32608__$1;
(statearr_32684_32886[(2)] = null);

(statearr_32684_32886[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (56))){
var inst_32285 = (state_32608[(2)]);
var state_32608__$1 = state_32608;
var statearr_32685_32887 = state_32608__$1;
(statearr_32685_32887[(2)] = inst_32285);

(statearr_32685_32887[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (33))){
var inst_32228 = (state_32608[(19)]);
var inst_32245 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32246 = cljs.core.get.call(null,offset_map,inst_32228);
var state_32608__$1 = (function (){var statearr_32686 = state_32608;
(statearr_32686[(43)] = inst_32245);

return statearr_32686;
})();
if(cljs.core.truth_(inst_32246)){
var statearr_32687_32888 = state_32608__$1;
(statearr_32687_32888[(1)] = (36));

} else {
var statearr_32688_32889 = state_32608__$1;
(statearr_32688_32889[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (13))){
var inst_32195 = (state_32608[(42)]);
var state_32608__$1 = state_32608;
var statearr_32689_32890 = state_32608__$1;
(statearr_32689_32890[(2)] = inst_32195);

(statearr_32689_32890[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (22))){
var inst_32210 = (state_32608[(13)]);
var inst_32217 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_32210);
var state_32608__$1 = state_32608;
var statearr_32690_32891 = state_32608__$1;
(statearr_32690_32891[(2)] = inst_32217);

(statearr_32690_32891[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (90))){
var inst_32378 = (state_32608[(44)]);
var inst_32407 = (state_32608[(2)]);
var inst_32370 = inst_32378;
var inst_32371 = inst_32407;
var state_32608__$1 = (function (){var statearr_32691 = state_32608;
(statearr_32691[(45)] = inst_32370);

(statearr_32691[(30)] = inst_32371);

return statearr_32691;
})();
var statearr_32692_32892 = state_32608__$1;
(statearr_32692_32892[(2)] = null);

(statearr_32692_32892[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (109))){
var inst_32445 = (state_32608[(46)]);
var inst_32476 = (state_32608[(47)]);
var inst_32482 = (state_32608[(2)]);
var inst_32437 = inst_32445;
var inst_32438 = inst_32476;
var state_32608__$1 = (function (){var statearr_32693 = state_32608;
(statearr_32693[(48)] = inst_32437);

(statearr_32693[(49)] = inst_32482);

(statearr_32693[(32)] = inst_32438);

return statearr_32693;
})();
var statearr_32694_32893 = state_32608__$1;
(statearr_32694_32893[(2)] = null);

(statearr_32694_32893[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (36))){
var inst_32228 = (state_32608[(19)]);
var inst_32248 = cljs.core.update.call(null,offset_map,inst_32228,cljs.core.dec);
var state_32608__$1 = state_32608;
var statearr_32695_32894 = state_32608__$1;
(statearr_32695_32894[(2)] = inst_32248);

(statearr_32695_32894[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (41))){
var inst_32272 = (state_32608[(2)]);
var state_32608__$1 = state_32608;
if(cljs.core.truth_(inst_32272)){
var statearr_32696_32895 = state_32608__$1;
(statearr_32696_32895[(1)] = (48));

} else {
var statearr_32697_32896 = state_32608__$1;
(statearr_32697_32896[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (118))){
var inst_32522 = (state_32608[(38)]);
var inst_32525 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32526 = inst_32522.o;
var inst_32527 = [inst_32526];
var inst_32528 = (new cljs.core.PersistentVector(null,1,(5),inst_32525,inst_32527,null));
var inst_32529 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_32528);
var state_32608__$1 = state_32608;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32608__$1,(121),inst_32529);
} else {
if((state_val_32609 === (89))){
var inst_32371 = (state_32608[(30)]);
var state_32608__$1 = state_32608;
var statearr_32698_32897 = state_32608__$1;
(statearr_32698_32897[(2)] = inst_32371);

(statearr_32698_32897[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (100))){
var inst_32438 = (state_32608[(32)]);
var state_32608__$1 = state_32608;
var statearr_32699_32898 = state_32608__$1;
(statearr_32699_32898[(2)] = inst_32438);

(statearr_32699_32898[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (131))){
var inst_32221 = (state_32608[(17)]);
var inst_32578 = (state_32608[(10)]);
var inst_32577 = (state_32608[(50)]);
var inst_32586 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32587 = cljs.core.assoc.call(null,acc,inst_32221,inst_32577);
var inst_32588 = [inst_32587,inst_32578];
var inst_32589 = (new cljs.core.PersistentVector(null,2,(5),inst_32586,inst_32588,null));
var state_32608__$1 = state_32608;
var statearr_32700_32899 = state_32608__$1;
(statearr_32700_32899[(2)] = inst_32589);

(statearr_32700_32899[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (122))){
var inst_32522 = (state_32608[(38)]);
var inst_32523 = (state_32608[(39)]);
var inst_32516 = (state_32608[(33)]);
var inst_32535 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_32536 = inst_32522.o;
var inst_32537 = [inst_32536];
var inst_32538 = cljs.core.PersistentHashMap.fromArrays(inst_32535,inst_32537);
var inst_32539 = cljs.core.conj.call(null,inst_32516,inst_32538);
var inst_32515 = inst_32523;
var inst_32516__$1 = inst_32539;
var state_32608__$1 = (function (){var statearr_32701 = state_32608;
(statearr_32701[(37)] = inst_32515);

(statearr_32701[(33)] = inst_32516__$1);

return statearr_32701;
})();
var statearr_32702_32900 = state_32608__$1;
(statearr_32702_32900[(2)] = null);

(statearr_32702_32900[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (43))){
var inst_32258 = (state_32608[(29)]);
var state_32608__$1 = state_32608;
var statearr_32703_32901 = state_32608__$1;
(statearr_32703_32901[(2)] = inst_32258);

(statearr_32703_32901[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (61))){
var inst_32294 = (state_32608[(51)]);
var inst_32351 = (state_32608[(2)]);
var inst_32352 = [inst_32351,offset_map];
var inst_32353 = (new cljs.core.PersistentVector(null,2,(5),inst_32294,inst_32352,null));
var state_32608__$1 = state_32608;
var statearr_32704_32902 = state_32608__$1;
(statearr_32704_32902[(2)] = inst_32353);

(statearr_32704_32902[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (29))){
var inst_32240 = (state_32608[(2)]);
var state_32608__$1 = state_32608;
var statearr_32705_32903 = state_32608__$1;
(statearr_32705_32903[(2)] = inst_32240);

(statearr_32705_32903[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (44))){
var inst_32269 = (state_32608[(2)]);
var state_32608__$1 = state_32608;
var statearr_32706_32904 = state_32608__$1;
(statearr_32706_32904[(2)] = inst_32269);

(statearr_32706_32904[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (93))){
var inst_32422 = (state_32608[(2)]);
var state_32608__$1 = state_32608;
if(cljs.core.truth_(inst_32422)){
var statearr_32707_32905 = state_32608__$1;
(statearr_32707_32905[(1)] = (94));

} else {
var statearr_32708_32906 = state_32608__$1;
(statearr_32708_32906[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (6))){
var inst_32183 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_32184 = (inst_32183 == null);
var state_32608__$1 = state_32608;
var statearr_32709_32907 = state_32608__$1;
(statearr_32709_32907[(2)] = inst_32184);

(statearr_32709_32907[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (111))){
var state_32608__$1 = state_32608;
var statearr_32710_32908 = state_32608__$1;
(statearr_32710_32908[(1)] = (125));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (28))){
var inst_32227 = (state_32608[(20)]);
var state_32608__$1 = state_32608;
var statearr_32712_32909 = state_32608__$1;
(statearr_32712_32909[(2)] = inst_32227);

(statearr_32712_32909[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (134))){
var inst_32221 = (state_32608[(17)]);
var inst_32578 = (state_32608[(10)]);
var inst_32577 = (state_32608[(50)]);
var inst_32592 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32593 = cljs.core.first.call(null,inst_32577);
var inst_32594 = cljs.core.assoc.call(null,acc,inst_32221,inst_32593);
var inst_32595 = [inst_32594,inst_32578];
var inst_32596 = (new cljs.core.PersistentVector(null,2,(5),inst_32592,inst_32595,null));
var state_32608__$1 = state_32608;
var statearr_32713_32910 = state_32608__$1;
(statearr_32713_32910[(2)] = inst_32596);

(statearr_32713_32910[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (64))){
var inst_32349 = (state_32608[(2)]);
var state_32608__$1 = state_32608;
var statearr_32714_32911 = state_32608__$1;
(statearr_32714_32911[(2)] = inst_32349);

(statearr_32714_32911[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (103))){
var inst_32444 = (state_32608[(40)]);
var inst_32438 = (state_32608[(32)]);
var inst_32461 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_32462 = inst_32444.o;
var inst_32463 = [inst_32462];
var inst_32464 = cljs.core.PersistentHashMap.fromArrays(inst_32461,inst_32463);
var inst_32465 = cljs.core.conj.call(null,inst_32438,inst_32464);
var state_32608__$1 = state_32608;
var statearr_32715_32912 = state_32608__$1;
(statearr_32715_32912[(2)] = inst_32465);

(statearr_32715_32912[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (51))){
var inst_32210 = (state_32608[(13)]);
var inst_32280 = (state_32608[(34)]);
var inst_32280__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_32210);
var state_32608__$1 = (function (){var statearr_32716 = state_32608;
(statearr_32716[(34)] = inst_32280__$1);

return statearr_32716;
})();
if(cljs.core.truth_(inst_32280__$1)){
var statearr_32717_32913 = state_32608__$1;
(statearr_32717_32913[(1)] = (54));

} else {
var statearr_32718_32914 = state_32608__$1;
(statearr_32718_32914[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (25))){
var inst_32223 = (state_32608[(14)]);
var state_32608__$1 = state_32608;
var statearr_32719_32915 = state_32608__$1;
(statearr_32719_32915[(2)] = inst_32223);

(statearr_32719_32915[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (34))){
var inst_32223 = (state_32608[(14)]);
var state_32608__$1 = state_32608;
if(cljs.core.truth_(inst_32223)){
var statearr_32720_32916 = state_32608__$1;
(statearr_32720_32916[(1)] = (39));

} else {
var statearr_32721_32917 = state_32608__$1;
(statearr_32721_32917[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (125))){
var inst_32224 = (state_32608[(16)]);
var inst_32195 = (state_32608[(42)]);
var inst_32210 = (state_32608[(13)]);
var inst_32221 = (state_32608[(17)]);
var inst_32226 = (state_32608[(18)]);
var inst_32228 = (state_32608[(19)]);
var inst_32223 = (state_32608[(14)]);
var inst_32227 = (state_32608[(20)]);
var inst_32222 = (state_32608[(15)]);
var inst_32180 = (state_32608[(35)]);
var inst_32225 = (state_32608[(21)]);
var inst_32557 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32558 = (function (){var p = inst_32228;
var pred_spec__$1 = inst_32195;
var orderBy = inst_32226;
var multi_QMARK_ = inst_32223;
var limit = inst_32225;
var offset = inst_32227;
var k = inst_32221;
var map__32176 = inst_32222;
var compact_QMARK_ = inst_32180;
var pred_spec_SINGLEQUOTE_ = inst_32210;
var ref_QMARK_ = inst_32224;
return (function (p1__32167_SHARP_){
return p1__32167_SHARP_.o;
});
})();
var inst_32559 = cljs.core.mapv.call(null,inst_32558,flakes);
var inst_32560 = [inst_32559,offset_map];
var inst_32561 = (new cljs.core.PersistentVector(null,2,(5),inst_32557,inst_32560,null));
var state_32608__$1 = state_32608;
var statearr_32722_32918 = state_32608__$1;
(statearr_32722_32918[(2)] = inst_32561);

(statearr_32722_32918[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (17))){
var inst_32210 = (state_32608[(13)]);
var inst_32211 = (state_32608[(52)]);
var inst_32210__$1 = (state_32608[(2)]);
var inst_32211__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_32210__$1);
var state_32608__$1 = (function (){var statearr_32723 = state_32608;
(statearr_32723[(13)] = inst_32210__$1);

(statearr_32723[(52)] = inst_32211__$1);

return statearr_32723;
})();
if(cljs.core.truth_(inst_32211__$1)){
var statearr_32724_32919 = state_32608__$1;
(statearr_32724_32919[(1)] = (18));

} else {
var statearr_32725_32920 = state_32608__$1;
(statearr_32725_32920[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (3))){
var inst_32606 = (state_32608[(2)]);
var state_32608__$1 = state_32608;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32608__$1,inst_32606);
} else {
if((state_val_32609 === (12))){
var inst_32195 = (state_32608[(42)]);
var inst_32200 = cljs.core.assoc.call(null,inst_32195,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_32608__$1 = state_32608;
var statearr_32726_32921 = state_32608__$1;
(statearr_32726_32921[(2)] = inst_32200);

(statearr_32726_32921[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (2))){
var inst_32181 = (state_32608[(11)]);
var _ = (function (){var statearr_32727 = state_32608;
(statearr_32727[(4)] = cljs.core.cons.call(null,(5),(state_32608[(4)])));

return statearr_32727;
})();
var inst_32180 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_32181__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_32608__$1 = (function (){var statearr_32728 = state_32608;
(statearr_32728[(11)] = inst_32181__$1);

(statearr_32728[(35)] = inst_32180);

return statearr_32728;
})();
if(cljs.core.truth_(inst_32181__$1)){
var statearr_32729_32922 = state_32608__$1;
(statearr_32729_32922[(1)] = (6));

} else {
var statearr_32730_32923 = state_32608__$1;
(statearr_32730_32923[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (66))){
var inst_32324 = (state_32608[(7)]);
var inst_32293 = (state_32608[(53)]);
var inst_32327 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_32293,inst_32324);
var state_32608__$1 = state_32608;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32608__$1,(69),inst_32327);
} else {
if((state_val_32609 === (107))){
var inst_32458 = (state_32608[(27)]);
var inst_32478 = cljs.core.count.call(null,inst_32458);
var inst_32479 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_32478);
var state_32608__$1 = state_32608;
var statearr_32731_32924 = state_32608__$1;
(statearr_32731_32924[(2)] = inst_32479);

(statearr_32731_32924[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (23))){
var inst_32219 = (state_32608[(2)]);
var state_32608__$1 = state_32608;
var statearr_32732_32925 = state_32608__$1;
(statearr_32732_32925[(2)] = inst_32219);

(statearr_32732_32925[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (47))){
var inst_32266 = (state_32608[(2)]);
var state_32608__$1 = state_32608;
var statearr_32733_32926 = state_32608__$1;
(statearr_32733_32926[(2)] = inst_32266);

(statearr_32733_32926[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (35))){
var inst_32577 = (state_32608[(50)]);
var inst_32576 = (state_32608[(2)]);
var inst_32577__$1 = cljs.core.nth.call(null,inst_32576,(0),null);
var inst_32578 = cljs.core.nth.call(null,inst_32576,(1),null);
var inst_32579 = cljs.core.empty_QMARK_.call(null,inst_32577__$1);
var state_32608__$1 = (function (){var statearr_32734 = state_32608;
(statearr_32734[(10)] = inst_32578);

(statearr_32734[(50)] = inst_32577__$1);

return statearr_32734;
})();
if(inst_32579){
var statearr_32735_32927 = state_32608__$1;
(statearr_32735_32927[(1)] = (128));

} else {
var statearr_32736_32928 = state_32608__$1;
(statearr_32736_32928[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (127))){
var inst_32564 = (state_32608[(2)]);
var state_32608__$1 = state_32608;
var statearr_32737_32929 = state_32608__$1;
(statearr_32737_32929[(2)] = inst_32564);

(statearr_32737_32929[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (82))){
var inst_32371 = (state_32608[(30)]);
var state_32608__$1 = state_32608;
var statearr_32738_32930 = state_32608__$1;
(statearr_32738_32930[(2)] = inst_32371);

(statearr_32738_32930[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (76))){
var inst_32357 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32365 = flakes;
var inst_32366 = cljs.core.seq.call(null,inst_32365);
var inst_32367 = cljs.core.first.call(null,inst_32366);
var inst_32368 = cljs.core.next.call(null,inst_32366);
var inst_32369 = cljs.core.PersistentVector.EMPTY;
var inst_32370 = inst_32365;
var inst_32371 = inst_32369;
var state_32608__$1 = (function (){var statearr_32739 = state_32608;
(statearr_32739[(54)] = inst_32357);

(statearr_32739[(45)] = inst_32370);

(statearr_32739[(55)] = inst_32368);

(statearr_32739[(56)] = inst_32367);

(statearr_32739[(30)] = inst_32371);

return statearr_32739;
})();
var statearr_32740_32931 = state_32608__$1;
(statearr_32740_32931[(2)] = null);

(statearr_32740_32931[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (97))){
var inst_32444 = (state_32608[(40)]);
var inst_32437 = (state_32608[(48)]);
var inst_32443 = cljs.core.seq.call(null,inst_32437);
var inst_32444__$1 = cljs.core.first.call(null,inst_32443);
var inst_32445 = cljs.core.next.call(null,inst_32443);
var state_32608__$1 = (function (){var statearr_32741 = state_32608;
(statearr_32741[(40)] = inst_32444__$1);

(statearr_32741[(46)] = inst_32445);

return statearr_32741;
})();
if(cljs.core.truth_(inst_32444__$1)){
var statearr_32742_32932 = state_32608__$1;
(statearr_32742_32932[(1)] = (99));

} else {
var statearr_32743_32933 = state_32608__$1;
(statearr_32743_32933[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (19))){
var inst_32214 = (state_32608[(41)]);
var inst_32210 = (state_32608[(13)]);
var inst_32214__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_32210);
var state_32608__$1 = (function (){var statearr_32744 = state_32608;
(statearr_32744[(41)] = inst_32214__$1);

return statearr_32744;
})();
if(cljs.core.truth_(inst_32214__$1)){
var statearr_32745_32934 = state_32608__$1;
(statearr_32745_32934[(1)] = (21));

} else {
var statearr_32746_32935 = state_32608__$1;
(statearr_32746_32935[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (57))){
var inst_32210 = (state_32608[(13)]);
var inst_32290 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32291 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_32292 = (new cljs.core.PersistentVector(null,3,(5),inst_32290,inst_32291,null));
var inst_32293 = cljs.core.select_keys.call(null,inst_32210,inst_32292);
var inst_32294 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32302 = flakes;
var inst_32303 = cljs.core.seq.call(null,inst_32302);
var inst_32304 = cljs.core.first.call(null,inst_32303);
var inst_32305 = cljs.core.next.call(null,inst_32303);
var inst_32306 = cljs.core.PersistentVector.EMPTY;
var inst_32307 = inst_32302;
var inst_32308 = inst_32306;
var state_32608__$1 = (function (){var statearr_32747 = state_32608;
(statearr_32747[(51)] = inst_32294);

(statearr_32747[(9)] = inst_32308);

(statearr_32747[(24)] = inst_32307);

(statearr_32747[(53)] = inst_32293);

(statearr_32747[(57)] = inst_32304);

(statearr_32747[(58)] = inst_32305);

return statearr_32747;
})();
var statearr_32748_32936 = state_32608__$1;
(statearr_32748_32936[(2)] = null);

(statearr_32748_32936[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (68))){
var inst_32333 = (state_32608[(2)]);
var state_32608__$1 = (function (){var statearr_32749 = state_32608;
(statearr_32749[(22)] = inst_32333);

return statearr_32749;
})();
if(cljs.core.truth_(fuel)){
var statearr_32750_32937 = state_32608__$1;
(statearr_32750_32937[(1)] = (70));

} else {
var statearr_32751_32938 = state_32608__$1;
(statearr_32751_32938[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (11))){
var inst_32195 = (state_32608[(42)]);
var inst_32195__$1 = (state_32608[(2)]);
var inst_32197 = cljs.core.contains_QMARK_.call(null,inst_32195__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var inst_32198 = (!(inst_32197));
var state_32608__$1 = (function (){var statearr_32752 = state_32608;
(statearr_32752[(42)] = inst_32195__$1);

return statearr_32752;
})();
if(inst_32198){
var statearr_32753_32939 = state_32608__$1;
(statearr_32753_32939[(1)] = (12));

} else {
var statearr_32754_32940 = state_32608__$1;
(statearr_32754_32940[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (115))){
var inst_32554 = (state_32608[(2)]);
var state_32608__$1 = state_32608;
var statearr_32756_32941 = state_32608__$1;
(statearr_32756_32941[(2)] = inst_32554);

(statearr_32756_32941[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (9))){
var inst_32189 = cljs.core.first.call(null,flakes);
var inst_32190 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_32189);
var inst_32191 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_32192 = fluree.db.query.fql.wildcard_pred_spec.call(null,db,cache,inst_32190,inst_32191);
var state_32608__$1 = state_32608;
var statearr_32757_32942 = state_32608__$1;
(statearr_32757_32942[(2)] = inst_32192);

(statearr_32757_32942[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (5))){
var _ = (function (){var statearr_32758 = state_32608;
(statearr_32758[(4)] = cljs.core.rest.call(null,(state_32608[(4)])));

return statearr_32758;
})();
var state_32608__$1 = state_32608;
var ex32755 = (state_32608__$1[(2)]);
var statearr_32759_32943 = state_32608__$1;
(statearr_32759_32943[(5)] = ex32755);


if((ex32755 instanceof Error)){
var statearr_32760_32944 = state_32608__$1;
(statearr_32760_32944[(1)] = (4));

(statearr_32760_32944[(5)] = null);

} else {
throw ex32755;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (112))){
var inst_32566 = (state_32608[(2)]);
var state_32608__$1 = state_32608;
var statearr_32761_32945 = state_32608__$1;
(statearr_32761_32945[(2)] = inst_32566);

(statearr_32761_32945[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (83))){
var inst_32411 = (state_32608[(2)]);
var state_32608__$1 = state_32608;
var statearr_32762_32946 = state_32608__$1;
(statearr_32762_32946[(2)] = inst_32411);

(statearr_32762_32946[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (14))){
var inst_32195 = (state_32608[(42)]);
var inst_32203 = (state_32608[(2)]);
var inst_32204 = cljs.core.contains_QMARK_.call(null,inst_32195,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var inst_32205 = (!(inst_32204));
var state_32608__$1 = (function (){var statearr_32763 = state_32608;
(statearr_32763[(36)] = inst_32203);

return statearr_32763;
})();
if(inst_32205){
var statearr_32764_32947 = state_32608__$1;
(statearr_32764_32947[(1)] = (15));

} else {
var statearr_32765_32948 = state_32608__$1;
(statearr_32765_32948[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (45))){
var inst_32221 = (state_32608[(17)]);
var inst_32225 = (state_32608[(21)]);
var inst_32261 = cljs.core.get.call(null,acc,inst_32221);
var inst_32262 = cljs.core.count.call(null,inst_32261);
var inst_32263 = (inst_32262 >= inst_32225);
var state_32608__$1 = state_32608;
var statearr_32766_32949 = state_32608__$1;
(statearr_32766_32949[(2)] = inst_32263);

(statearr_32766_32949[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (53))){
var inst_32288 = (state_32608[(2)]);
var state_32608__$1 = state_32608;
if(cljs.core.truth_(inst_32288)){
var statearr_32767_32950 = state_32608__$1;
(statearr_32767_32950[(1)] = (57));

} else {
var statearr_32768_32951 = state_32608__$1;
(statearr_32768_32951[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (78))){
var inst_32570 = (state_32608[(2)]);
var state_32608__$1 = state_32608;
var statearr_32769_32952 = state_32608__$1;
(statearr_32769_32952[(2)] = inst_32570);

(statearr_32769_32952[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (132))){
var state_32608__$1 = state_32608;
var statearr_32771_32953 = state_32608__$1;
(statearr_32771_32953[(1)] = (134));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (26))){
var inst_32243 = (state_32608[(2)]);
var state_32608__$1 = state_32608;
if(cljs.core.truth_(inst_32243)){
var statearr_32773_32954 = state_32608__$1;
(statearr_32773_32954[(1)] = (33));

} else {
var statearr_32774_32955 = state_32608__$1;
(statearr_32774_32955[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (123))){
var inst_32523 = (state_32608[(39)]);
var inst_32516 = (state_32608[(33)]);
var tmp32770 = inst_32516;
var inst_32515 = inst_32523;
var inst_32516__$1 = tmp32770;
var state_32608__$1 = (function (){var statearr_32775 = state_32608;
(statearr_32775[(37)] = inst_32515);

(statearr_32775[(33)] = inst_32516__$1);

return statearr_32775;
})();
var statearr_32776_32956 = state_32608__$1;
(statearr_32776_32956[(2)] = null);

(statearr_32776_32956[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (16))){
var inst_32203 = (state_32608[(36)]);
var state_32608__$1 = state_32608;
var statearr_32777_32957 = state_32608__$1;
(statearr_32777_32957[(2)] = inst_32203);

(statearr_32777_32957[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (133))){
var inst_32601 = (state_32608[(2)]);
var state_32608__$1 = state_32608;
var statearr_32778_32958 = state_32608__$1;
(statearr_32778_32958[(2)] = inst_32601);

(statearr_32778_32958[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (81))){
var inst_32210 = (state_32608[(13)]);
var inst_32386 = (state_32608[(59)]);
var inst_32377 = (state_32608[(28)]);
var inst_32380 = cljs.core.deref.call(null,cache);
var inst_32381 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32382 = inst_32377.o;
var inst_32383 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_32210);
var inst_32384 = [inst_32382,inst_32383];
var inst_32385 = (new cljs.core.PersistentVector(null,2,(5),inst_32381,inst_32384,null));
var inst_32386__$1 = cljs.core.get.call(null,inst_32380,inst_32385);
var state_32608__$1 = (function (){var statearr_32779 = state_32608;
(statearr_32779[(59)] = inst_32386__$1);

return statearr_32779;
})();
if(cljs.core.truth_(inst_32386__$1)){
var statearr_32780_32959 = state_32608__$1;
(statearr_32780_32959[(1)] = (84));

} else {
var statearr_32781_32960 = state_32608__$1;
(statearr_32781_32960[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (120))){
var inst_32550 = (state_32608[(2)]);
var state_32608__$1 = state_32608;
var statearr_32782_32961 = state_32608__$1;
(statearr_32782_32961[(2)] = inst_32550);

(statearr_32782_32961[(1)] = (117));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (79))){
var inst_32370 = (state_32608[(45)]);
var inst_32377 = (state_32608[(28)]);
var inst_32376 = cljs.core.seq.call(null,inst_32370);
var inst_32377__$1 = cljs.core.first.call(null,inst_32376);
var inst_32378 = cljs.core.next.call(null,inst_32376);
var state_32608__$1 = (function (){var statearr_32783 = state_32608;
(statearr_32783[(44)] = inst_32378);

(statearr_32783[(28)] = inst_32377__$1);

return statearr_32783;
})();
if(cljs.core.truth_(inst_32377__$1)){
var statearr_32784_32962 = state_32608__$1;
(statearr_32784_32962[(1)] = (81));

} else {
var statearr_32785_32963 = state_32608__$1;
(statearr_32785_32963[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (38))){
var inst_32245 = (state_32608[(43)]);
var inst_32253 = (state_32608[(2)]);
var inst_32254 = [null,inst_32253];
var inst_32255 = (new cljs.core.PersistentVector(null,2,(5),inst_32245,inst_32254,null));
var state_32608__$1 = state_32608;
var statearr_32786_32964 = state_32608__$1;
(statearr_32786_32964[(2)] = inst_32255);

(statearr_32786_32964[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (126))){
var state_32608__$1 = state_32608;
var statearr_32787_32965 = state_32608__$1;
(statearr_32787_32965[(2)] = null);

(statearr_32787_32965[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (98))){
var inst_32424 = (state_32608[(60)]);
var inst_32488 = (state_32608[(2)]);
var inst_32489 = [inst_32488,offset_map];
var inst_32490 = (new cljs.core.PersistentVector(null,2,(5),inst_32424,inst_32489,null));
var state_32608__$1 = state_32608;
var statearr_32788_32966 = state_32608__$1;
(statearr_32788_32966[(2)] = inst_32490);

(statearr_32788_32966[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (124))){
var inst_32544 = (state_32608[(2)]);
var state_32608__$1 = state_32608;
var statearr_32789_32967 = state_32608__$1;
(statearr_32789_32967[(2)] = inst_32544);

(statearr_32789_32967[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (87))){
var inst_32210 = (state_32608[(13)]);
var inst_32377 = (state_32608[(28)]);
var inst_32393 = (state_32608[(2)]);
var inst_32394 = fluree.db.util.async.throw_err.call(null,inst_32393);
var inst_32395 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32396 = inst_32377.o;
var inst_32397 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_32210);
var inst_32398 = [inst_32396,inst_32397];
var inst_32399 = (new cljs.core.PersistentVector(null,2,(5),inst_32395,inst_32398,null));
var inst_32400 = fluree.db.query.fql.vswap_BANG_.call(null,cache,cljs.core.assoc,inst_32399,inst_32394);
var state_32608__$1 = (function (){var statearr_32790 = state_32608;
(statearr_32790[(61)] = inst_32400);

return statearr_32790;
})();
var statearr_32791_32968 = state_32608__$1;
(statearr_32791_32968[(2)] = inst_32394);

(statearr_32791_32968[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (30))){
var inst_32228 = (state_32608[(19)]);
var inst_32233 = cljs.core.get.call(null,offset_map,inst_32228);
var inst_32234 = cljs.core.not_EQ_.call(null,(0),inst_32233);
var state_32608__$1 = state_32608;
var statearr_32792_32969 = state_32608__$1;
(statearr_32792_32969[(2)] = inst_32234);

(statearr_32792_32969[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (73))){
var inst_32308 = (state_32608[(9)]);
var inst_32333 = (state_32608[(22)]);
var inst_32342 = cljs.core.conj.call(null,inst_32308,inst_32333);
var state_32608__$1 = state_32608;
var statearr_32793_32970 = state_32608__$1;
(statearr_32793_32970[(2)] = inst_32342);

(statearr_32793_32970[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (96))){
var inst_32568 = (state_32608[(2)]);
var state_32608__$1 = state_32608;
var statearr_32794_32971 = state_32608__$1;
(statearr_32794_32971[(2)] = inst_32568);

(statearr_32794_32971[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (10))){
var state_32608__$1 = state_32608;
var statearr_32795_32972 = state_32608__$1;
(statearr_32795_32972[(2)] = pred_spec);

(statearr_32795_32972[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (18))){
var inst_32211 = (state_32608[(52)]);
var state_32608__$1 = state_32608;
var statearr_32796_32973 = state_32608__$1;
(statearr_32796_32973[(2)] = inst_32211);

(statearr_32796_32973[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (105))){
var inst_32476 = (state_32608[(2)]);
var state_32608__$1 = (function (){var statearr_32797 = state_32608;
(statearr_32797[(47)] = inst_32476);

return statearr_32797;
})();
if(cljs.core.truth_(fuel)){
var statearr_32798_32974 = state_32608__$1;
(statearr_32798_32974[(1)] = (107));

} else {
var statearr_32799_32975 = state_32608__$1;
(statearr_32799_32975[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (52))){
var inst_32278 = (state_32608[(62)]);
var state_32608__$1 = state_32608;
var statearr_32800_32976 = state_32608__$1;
(statearr_32800_32976[(2)] = inst_32278);

(statearr_32800_32976[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (114))){
var inst_32510 = flakes;
var inst_32511 = cljs.core.seq.call(null,inst_32510);
var inst_32512 = cljs.core.first.call(null,inst_32511);
var inst_32513 = cljs.core.next.call(null,inst_32511);
var inst_32514 = cljs.core.PersistentVector.EMPTY;
var inst_32515 = inst_32510;
var inst_32516 = inst_32514;
var state_32608__$1 = (function (){var statearr_32801 = state_32608;
(statearr_32801[(37)] = inst_32515);

(statearr_32801[(33)] = inst_32516);

(statearr_32801[(63)] = inst_32512);

(statearr_32801[(64)] = inst_32513);

return statearr_32801;
})();
var statearr_32802_32977 = state_32608__$1;
(statearr_32802_32977[(2)] = null);

(statearr_32802_32977[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (67))){
var state_32608__$1 = state_32608;
var statearr_32803_32978 = state_32608__$1;
(statearr_32803_32978[(2)] = null);

(statearr_32803_32978[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (71))){
var state_32608__$1 = state_32608;
var statearr_32804_32979 = state_32608__$1;
(statearr_32804_32979[(2)] = null);

(statearr_32804_32979[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (42))){
var inst_32225 = (state_32608[(21)]);
var state_32608__$1 = state_32608;
if(cljs.core.truth_(inst_32225)){
var statearr_32805_32980 = state_32608__$1;
(statearr_32805_32980[(1)] = (45));

} else {
var statearr_32806_32981 = state_32608__$1;
(statearr_32806_32981[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (80))){
var inst_32357 = (state_32608[(54)]);
var inst_32413 = (state_32608[(2)]);
var inst_32414 = [inst_32413,offset_map];
var inst_32415 = (new cljs.core.PersistentVector(null,2,(5),inst_32357,inst_32414,null));
var state_32608__$1 = state_32608;
var statearr_32807_32982 = state_32608__$1;
(statearr_32807_32982[(2)] = inst_32415);

(statearr_32807_32982[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (37))){
var inst_32228 = (state_32608[(19)]);
var inst_32227 = (state_32608[(20)]);
var inst_32250 = (inst_32227 - (1));
var inst_32251 = cljs.core.assoc.call(null,offset_map,inst_32228,inst_32250);
var state_32608__$1 = state_32608;
var statearr_32808_32983 = state_32608__$1;
(statearr_32808_32983[(2)] = inst_32251);

(statearr_32808_32983[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (63))){
var inst_32308 = (state_32608[(9)]);
var state_32608__$1 = state_32608;
var statearr_32809_32984 = state_32608__$1;
(statearr_32809_32984[(2)] = inst_32308);

(statearr_32809_32984[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (94))){
var inst_32424 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32432 = flakes;
var inst_32433 = cljs.core.seq.call(null,inst_32432);
var inst_32434 = cljs.core.first.call(null,inst_32433);
var inst_32435 = cljs.core.next.call(null,inst_32433);
var inst_32436 = cljs.core.PersistentVector.EMPTY;
var inst_32437 = inst_32432;
var inst_32438 = inst_32436;
var state_32608__$1 = (function (){var statearr_32810 = state_32608;
(statearr_32810[(60)] = inst_32424);

(statearr_32810[(65)] = inst_32434);

(statearr_32810[(48)] = inst_32437);

(statearr_32810[(32)] = inst_32438);

(statearr_32810[(66)] = inst_32435);

return statearr_32810;
})();
var statearr_32811_32985 = state_32608__$1;
(statearr_32811_32985[(2)] = null);

(statearr_32811_32985[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (8))){
var inst_32187 = (state_32608[(2)]);
var state_32608__$1 = state_32608;
if(cljs.core.truth_(inst_32187)){
var statearr_32812_32986 = state_32608__$1;
(statearr_32812_32986[(1)] = (9));

} else {
var statearr_32813_32987 = state_32608__$1;
(statearr_32813_32987[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (49))){
var inst_32278 = (state_32608[(62)]);
var inst_32278__$1 = cljs.core.not.call(null,recur_QMARK_);
var state_32608__$1 = (function (){var statearr_32814 = state_32608;
(statearr_32814[(62)] = inst_32278__$1);

return statearr_32814;
})();
if(inst_32278__$1){
var statearr_32815_32988 = state_32608__$1;
(statearr_32815_32988[(1)] = (51));

} else {
var statearr_32816_32989 = state_32608__$1;
(statearr_32816_32989[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32609 === (84))){
var inst_32386 = (state_32608[(59)]);
var state_32608__$1 = state_32608;
var statearr_32817_32990 = state_32608__$1;
(statearr_32817_32990[(2)] = inst_32386);

(statearr_32817_32990[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__10903__auto__ = null;
var fluree$db$query$fql$state_machine__10903__auto____0 = (function (){
var statearr_32818 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32818[(0)] = fluree$db$query$fql$state_machine__10903__auto__);

(statearr_32818[(1)] = (1));

return statearr_32818;
});
var fluree$db$query$fql$state_machine__10903__auto____1 = (function (state_32608){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_32608);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e32819){var ex__10906__auto__ = e32819;
var statearr_32820_32991 = state_32608;
(statearr_32820_32991[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_32608[(4)]))){
var statearr_32821_32992 = state_32608;
(statearr_32821_32992[(1)] = cljs.core.first.call(null,(state_32608[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32993 = state_32608;
state_32608 = G__32993;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__10903__auto__ = function(state_32608){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__10903__auto____1.call(this,state_32608);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__10903__auto____0;
fluree$db$query$fql$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__10903__auto____1;
return fluree$db$query$fql$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_32822 = f__10977__auto__.call(null);
(statearr_32822[(6)] = c__10976__auto__);

return statearr_32822;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid.call(null,subject_id);
var or__4253__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec.call(null,db,coll_id,cljs.core.get_in.call(null,base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.call(null,base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.call(null,lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
fluree.db.query.fql.vswap_BANG_.call(null,cache,cljs.core.assoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec);

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_33153){
var state_val_33154 = (state_33153[(1)]);
if((state_val_33154 === (7))){
var inst_33148 = (state_33153[(2)]);
var _ = (function (){var statearr_33155 = state_33153;
(statearr_33155[(4)] = cljs.core.rest.call(null,(state_33153[(4)])));

return statearr_33155;
})();
var state_33153__$1 = state_33153;
var statearr_33156_33238 = state_33153__$1;
(statearr_33156_33238[(2)] = inst_33148);

(statearr_33156_33238[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (20))){
var inst_33075 = (state_33153[(7)]);
var state_33153__$1 = state_33153;
var statearr_33157_33239 = state_33153__$1;
(statearr_33157_33239[(2)] = inst_33075);

(statearr_33157_33239[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (27))){
var inst_33030 = (state_33153[(8)]);
var state_33153__$1 = state_33153;
if(cljs.core.truth_(inst_33030)){
var statearr_33158_33240 = state_33153__$1;
(statearr_33158_33240[(1)] = (29));

} else {
var statearr_33159_33241 = state_33153__$1;
(statearr_33159_33241[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (1))){
var state_33153__$1 = state_33153;
var statearr_33160_33242 = state_33153__$1;
(statearr_33160_33242[(2)] = null);

(statearr_33160_33242[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (24))){
var inst_33031 = (state_33153[(9)]);
var state_33153__$1 = state_33153;
var statearr_33161_33243 = state_33153__$1;
(statearr_33161_33243[(2)] = inst_33031);

(statearr_33161_33243[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (39))){
var inst_33067 = (state_33153[(10)]);
var state_33153__$1 = state_33153;
var statearr_33162_33244 = state_33153__$1;
(statearr_33162_33244[(2)] = inst_33067);

(statearr_33162_33244[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (46))){
var inst_33032 = (state_33153[(11)]);
var state_33153__$1 = state_33153;
var statearr_33163_33245 = state_33153__$1;
(statearr_33163_33245[(2)] = inst_33032);

(statearr_33163_33245[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (4))){
var inst_32994 = (state_33153[(2)]);
var state_33153__$1 = state_33153;
var statearr_33164_33246 = state_33153__$1;
(statearr_33164_33246[(2)] = inst_32994);

(statearr_33164_33246[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (15))){
var inst_33043 = (state_33153[(12)]);
var inst_33049 = cljs.core.count.call(null,inst_33043);
var inst_33050 = fluree.db.query.fql.add_fuel.call(null,fuel,inst_33049,max_fuel);
var state_33153__$1 = state_33153;
var statearr_33165_33247 = state_33153__$1;
(statearr_33165_33247[(2)] = inst_33050);

(statearr_33165_33247[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (48))){
var inst_33134 = (state_33153[(13)]);
var inst_33019 = (state_33153[(14)]);
var inst_33012 = (state_33153[(15)]);
var inst_33142 = (state_33153[(2)]);
var inst_33143 = cljs.core.assoc.call(null,inst_33012,inst_33142,inst_33134);
var inst_33011 = inst_33019;
var inst_33012__$1 = inst_33143;
var state_33153__$1 = (function (){var statearr_33166 = state_33153;
(statearr_33166[(15)] = inst_33012__$1);

(statearr_33166[(16)] = inst_33011);

return statearr_33166;
})();
var statearr_33167_33248 = state_33153__$1;
(statearr_33167_33248[(2)] = null);

(statearr_33167_33248[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (50))){
var inst_33034 = (state_33153[(17)]);
var state_33153__$1 = state_33153;
var statearr_33168_33249 = state_33153__$1;
(statearr_33168_33249[(2)] = inst_33034);

(statearr_33168_33249[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (21))){
var inst_33031 = (state_33153[(9)]);
var state_33153__$1 = state_33153;
if(cljs.core.truth_(inst_33031)){
var statearr_33170_33250 = state_33153__$1;
(statearr_33170_33250[(1)] = (23));

} else {
var statearr_33171_33251 = state_33153__$1;
(statearr_33171_33251[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (31))){
var inst_33091 = (state_33153[(2)]);
var state_33153__$1 = state_33153;
if(cljs.core.truth_(inst_33091)){
var statearr_33172_33252 = state_33153__$1;
(statearr_33172_33252[(1)] = (32));

} else {
var statearr_33173_33253 = state_33153__$1;
(statearr_33173_33253[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (32))){
var inst_33074 = (state_33153[(18)]);
var inst_33067 = (state_33153[(10)]);
var inst_33066 = (state_33153[(19)]);
var inst_33093 = (inst_33066 + (1));
var tmp33169 = inst_33067;
var inst_33065 = inst_33074;
var inst_33066__$1 = inst_33093;
var inst_33067__$1 = tmp33169;
var state_33153__$1 = (function (){var statearr_33174 = state_33153;
(statearr_33174[(20)] = inst_33065);

(statearr_33174[(10)] = inst_33067__$1);

(statearr_33174[(19)] = inst_33066__$1);

return statearr_33174;
})();
var statearr_33175_33254 = state_33153__$1;
(statearr_33175_33254[(2)] = null);

(statearr_33175_33254[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (40))){
var state_33153__$1 = state_33153;
if(cljs.core.truth_(fuel)){
var statearr_33176_33255 = state_33153__$1;
(statearr_33176_33255[(1)] = (42));

} else {
var statearr_33177_33256 = state_33153__$1;
(statearr_33177_33256[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (33))){
var state_33153__$1 = state_33153;
var statearr_33178_33257 = state_33153__$1;
(statearr_33178_33257[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (13))){
var inst_33043 = (state_33153[(12)]);
var state_33153__$1 = state_33153;
var statearr_33180_33258 = state_33153__$1;
(statearr_33180_33258[(2)] = inst_33043);

(statearr_33180_33258[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (22))){
var inst_33084 = (state_33153[(2)]);
var state_33153__$1 = state_33153;
if(cljs.core.truth_(inst_33084)){
var statearr_33181_33259 = state_33153__$1;
(statearr_33181_33259[(1)] = (26));

} else {
var statearr_33182_33260 = state_33153__$1;
(statearr_33182_33260[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (36))){
var state_33153__$1 = state_33153;
var statearr_33183_33261 = state_33153__$1;
(statearr_33183_33261[(2)] = null);

(statearr_33183_33261[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (41))){
var inst_33074 = (state_33153[(18)]);
var inst_33066 = (state_33153[(19)]);
var inst_33123 = (state_33153[(2)]);
var inst_33124 = (inst_33066 + (1));
var inst_33065 = inst_33074;
var inst_33066__$1 = inst_33124;
var inst_33067 = inst_33123;
var state_33153__$1 = (function (){var statearr_33184 = state_33153;
(statearr_33184[(20)] = inst_33065);

(statearr_33184[(10)] = inst_33067);

(statearr_33184[(19)] = inst_33066__$1);

return statearr_33184;
})();
var statearr_33185_33262 = state_33153__$1;
(statearr_33185_33262[(2)] = null);

(statearr_33185_33262[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (43))){
var state_33153__$1 = state_33153;
var statearr_33186_33263 = state_33153__$1;
(statearr_33186_33263[(2)] = null);

(statearr_33186_33263[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (29))){
var inst_33066 = (state_33153[(19)]);
var inst_33030 = (state_33153[(8)]);
var inst_33088 = (inst_33066 < inst_33030);
var state_33153__$1 = state_33153;
var statearr_33187_33264 = state_33153__$1;
(statearr_33187_33264[(2)] = inst_33088);

(statearr_33187_33264[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (44))){
var inst_33107 = (state_33153[(21)]);
var inst_33103 = (state_33153[(22)]);
var inst_33116 = (state_33153[(2)]);
var inst_33117 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_33107,inst_33103);
var state_33153__$1 = (function (){var statearr_33188 = state_33153;
(statearr_33188[(23)] = inst_33116);

return statearr_33188;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33153__$1,(45),inst_33117);
} else {
if((state_val_33154 === (6))){
var inst_33018 = (state_33153[(24)]);
var inst_33011 = (state_33153[(16)]);
var inst_33017 = cljs.core.seq.call(null,inst_33011);
var inst_33018__$1 = cljs.core.first.call(null,inst_33017);
var inst_33019 = cljs.core.next.call(null,inst_33017);
var inst_33020 = cljs.core.not.call(null,inst_33018__$1);
var state_33153__$1 = (function (){var statearr_33189 = state_33153;
(statearr_33189[(14)] = inst_33019);

(statearr_33189[(24)] = inst_33018__$1);

return statearr_33189;
})();
if(inst_33020){
var statearr_33190_33265 = state_33153__$1;
(statearr_33190_33265[(1)] = (8));

} else {
var statearr_33191_33266 = state_33153__$1;
(statearr_33191_33266[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (28))){
var inst_33132 = (state_33153[(2)]);
var state_33153__$1 = state_33153;
var statearr_33192_33267 = state_33153__$1;
(statearr_33192_33267[(2)] = inst_33132);

(statearr_33192_33267[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (51))){
var inst_33140 = (state_33153[(2)]);
var state_33153__$1 = state_33153;
var statearr_33193_33268 = state_33153__$1;
(statearr_33193_33268[(2)] = inst_33140);

(statearr_33193_33268[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (25))){
var inst_33082 = (state_33153[(2)]);
var state_33153__$1 = state_33153;
var statearr_33194_33269 = state_33153__$1;
(statearr_33194_33269[(2)] = inst_33082);

(statearr_33194_33269[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (34))){
var inst_33130 = (state_33153[(2)]);
var state_33153__$1 = state_33153;
var statearr_33195_33270 = state_33153__$1;
(statearr_33195_33270[(2)] = inst_33130);

(statearr_33195_33270[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (17))){
var inst_33043 = (state_33153[(12)]);
var inst_33053 = (state_33153[(2)]);
var inst_33061 = cljs.core.seq.call(null,inst_33043);
var inst_33062 = cljs.core.first.call(null,inst_33061);
var inst_33063 = cljs.core.next.call(null,inst_33061);
var inst_33064 = cljs.core.PersistentVector.EMPTY;
var inst_33065 = inst_33043;
var inst_33066 = (0);
var inst_33067 = inst_33064;
var state_33153__$1 = (function (){var statearr_33196 = state_33153;
(statearr_33196[(20)] = inst_33065);

(statearr_33196[(25)] = inst_33063);

(statearr_33196[(10)] = inst_33067);

(statearr_33196[(26)] = inst_33053);

(statearr_33196[(19)] = inst_33066);

(statearr_33196[(27)] = inst_33062);

return statearr_33196;
})();
var statearr_33197_33271 = state_33153__$1;
(statearr_33197_33271[(2)] = null);

(statearr_33197_33271[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (3))){
var inst_33151 = (state_33153[(2)]);
var state_33153__$1 = state_33153;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33153__$1,inst_33151);
} else {
if((state_val_33154 === (12))){
var state_33153__$1 = state_33153;
var statearr_33198_33272 = state_33153__$1;
(statearr_33198_33272[(2)] = fuel);

(statearr_33198_33272[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (2))){
var _ = (function (){var statearr_33199 = state_33153;
(statearr_33199[(4)] = cljs.core.cons.call(null,(5),(state_33153[(4)])));

return statearr_33199;
})();
var inst_33007 = reverse_refs_specs;
var inst_33008 = cljs.core.seq.call(null,inst_33007);
var inst_33009 = cljs.core.first.call(null,inst_33008);
var inst_33010 = cljs.core.next.call(null,inst_33008);
var inst_33011 = inst_33007;
var inst_33012 = null;
var state_33153__$1 = (function (){var statearr_33200 = state_33153;
(statearr_33200[(28)] = inst_33009);

(statearr_33200[(29)] = inst_33010);

(statearr_33200[(15)] = inst_33012);

(statearr_33200[(16)] = inst_33011);

return statearr_33200;
})();
var statearr_33201_33273 = state_33153__$1;
(statearr_33201_33273[(2)] = null);

(statearr_33201_33273[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (23))){
var inst_33031 = (state_33153[(9)]);
var inst_33066 = (state_33153[(19)]);
var inst_33079 = (inst_33066 >= inst_33031);
var state_33153__$1 = state_33153;
var statearr_33202_33274 = state_33153__$1;
(statearr_33202_33274[(2)] = inst_33079);

(statearr_33202_33274[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (47))){
var inst_33033 = (state_33153[(30)]);
var state_33153__$1 = state_33153;
if(cljs.core.truth_(inst_33033)){
var statearr_33203_33275 = state_33153__$1;
(statearr_33203_33275[(1)] = (49));

} else {
var statearr_33204_33276 = state_33153__$1;
(statearr_33204_33276[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (35))){
var inst_33073 = (state_33153[(31)]);
var inst_33097 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33098 = [inst_33073];
var inst_33099 = (new cljs.core.PersistentVector(null,1,(5),inst_33097,inst_33098,null));
var inst_33100 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_33099);
var state_33153__$1 = state_33153;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33153__$1,(38),inst_33100);
} else {
if((state_val_33154 === (19))){
var inst_33032 = (state_33153[(11)]);
var inst_33134 = (state_33153[(2)]);
var state_33153__$1 = (function (){var statearr_33205 = state_33153;
(statearr_33205[(13)] = inst_33134);

return statearr_33205;
})();
if(cljs.core.truth_(inst_33032)){
var statearr_33206_33277 = state_33153__$1;
(statearr_33206_33277[(1)] = (46));

} else {
var statearr_33207_33278 = state_33153__$1;
(statearr_33207_33278[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (11))){
var inst_33043 = (state_33153[(12)]);
var inst_33040 = (state_33153[(2)]);
var inst_33041 = fluree.db.util.async.throw_err.call(null,inst_33040);
var inst_33042 = cljs.core.map.call(null,fluree.db.query.fql.s,inst_33041);
var inst_33043__$1 = cljs.core.not_empty.call(null,inst_33042);
var state_33153__$1 = (function (){var statearr_33209 = state_33153;
(statearr_33209[(12)] = inst_33043__$1);

return statearr_33209;
})();
if(cljs.core.truth_(inst_33043__$1)){
var statearr_33210_33279 = state_33153__$1;
(statearr_33210_33279[(1)] = (12));

} else {
var statearr_33211_33280 = state_33153__$1;
(statearr_33211_33280[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (9))){
var inst_33028 = (state_33153[(32)]);
var inst_33018 = (state_33153[(24)]);
var inst_33027 = cljs.core.nth.call(null,inst_33018,(0),null);
var inst_33028__$1 = cljs.core.nth.call(null,inst_33018,(1),null);
var inst_33029 = cljs.core.__destructure_map.call(null,inst_33028__$1);
var inst_33030 = cljs.core.get.call(null,inst_33029,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_33031 = cljs.core.get.call(null,inst_33029,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_33032 = cljs.core.get.call(null,inst_33029,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_33033 = cljs.core.get.call(null,inst_33029,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_33034 = cljs.core.get.call(null,inst_33029,new cljs.core.Keyword(null,"p","p",151049309));
var inst_33035 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33036 = [subject_id,inst_33027];
var inst_33037 = (new cljs.core.PersistentVector(null,2,(5),inst_33035,inst_33036,null));
var inst_33038 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_33037);
var state_33153__$1 = (function (){var statearr_33212 = state_33153;
(statearr_33212[(11)] = inst_33032);

(statearr_33212[(9)] = inst_33031);

(statearr_33212[(30)] = inst_33033);

(statearr_33212[(32)] = inst_33028__$1);

(statearr_33212[(17)] = inst_33034);

(statearr_33212[(8)] = inst_33030);

return statearr_33212;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33153__$1,(11),inst_33038);
} else {
if((state_val_33154 === (5))){
var _ = (function (){var statearr_33213 = state_33153;
(statearr_33213[(4)] = cljs.core.rest.call(null,(state_33153[(4)])));

return statearr_33213;
})();
var state_33153__$1 = state_33153;
var ex33208 = (state_33153__$1[(2)]);
var statearr_33214_33281 = state_33153__$1;
(statearr_33214_33281[(5)] = ex33208);


if((ex33208 instanceof Error)){
var statearr_33215_33282 = state_33153__$1;
(statearr_33215_33282[(1)] = (4));

(statearr_33215_33282[(5)] = null);

} else {
throw ex33208;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (14))){
var inst_33047 = (state_33153[(2)]);
var state_33153__$1 = state_33153;
if(cljs.core.truth_(inst_33047)){
var statearr_33216_33283 = state_33153__$1;
(statearr_33216_33283[(1)] = (15));

} else {
var statearr_33217_33284 = state_33153__$1;
(statearr_33217_33284[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (45))){
var inst_33067 = (state_33153[(10)]);
var inst_33119 = (state_33153[(2)]);
var inst_33120 = fluree.db.util.async.throw_err.call(null,inst_33119);
var inst_33121 = cljs.core.conj.call(null,inst_33067,inst_33120);
var state_33153__$1 = state_33153;
var statearr_33218_33285 = state_33153__$1;
(statearr_33218_33285[(2)] = inst_33121);

(statearr_33218_33285[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (26))){
var inst_33067 = (state_33153[(10)]);
var state_33153__$1 = state_33153;
var statearr_33219_33286 = state_33153__$1;
(statearr_33219_33286[(2)] = inst_33067);

(statearr_33219_33286[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (16))){
var state_33153__$1 = state_33153;
var statearr_33220_33287 = state_33153__$1;
(statearr_33220_33287[(2)] = null);

(statearr_33220_33287[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (38))){
var inst_33028 = (state_33153[(32)]);
var inst_33103 = (state_33153[(22)]);
var inst_33102 = (state_33153[(2)]);
var inst_33103__$1 = fluree.db.util.async.throw_err.call(null,inst_33102);
var inst_33104 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33105 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_33106 = (new cljs.core.PersistentVector(null,4,(5),inst_33104,inst_33105,null));
var inst_33107 = cljs.core.select_keys.call(null,inst_33028,inst_33106);
var inst_33108 = cljs.core.empty_QMARK_.call(null,inst_33103__$1);
var state_33153__$1 = (function (){var statearr_33221 = state_33153;
(statearr_33221[(21)] = inst_33107);

(statearr_33221[(22)] = inst_33103__$1);

return statearr_33221;
})();
if(inst_33108){
var statearr_33222_33288 = state_33153__$1;
(statearr_33222_33288[(1)] = (39));

} else {
var statearr_33223_33289 = state_33153__$1;
(statearr_33223_33289[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (30))){
var inst_33030 = (state_33153[(8)]);
var state_33153__$1 = state_33153;
var statearr_33224_33290 = state_33153__$1;
(statearr_33224_33290[(2)] = inst_33030);

(statearr_33224_33290[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (10))){
var inst_33146 = (state_33153[(2)]);
var state_33153__$1 = state_33153;
var statearr_33225_33291 = state_33153__$1;
(statearr_33225_33291[(2)] = inst_33146);

(statearr_33225_33291[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (18))){
var inst_33065 = (state_33153[(20)]);
var inst_33073 = (state_33153[(31)]);
var inst_33075 = (state_33153[(7)]);
var inst_33072 = cljs.core.seq.call(null,inst_33065);
var inst_33073__$1 = cljs.core.first.call(null,inst_33072);
var inst_33074 = cljs.core.next.call(null,inst_33072);
var inst_33075__$1 = cljs.core.not.call(null,inst_33073__$1);
var state_33153__$1 = (function (){var statearr_33226 = state_33153;
(statearr_33226[(18)] = inst_33074);

(statearr_33226[(31)] = inst_33073__$1);

(statearr_33226[(7)] = inst_33075__$1);

return statearr_33226;
})();
if(inst_33075__$1){
var statearr_33227_33292 = state_33153__$1;
(statearr_33227_33292[(1)] = (20));

} else {
var statearr_33228_33293 = state_33153__$1;
(statearr_33228_33293[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (42))){
var inst_33103 = (state_33153[(22)]);
var inst_33112 = cljs.core.count.call(null,inst_33103);
var inst_33113 = fluree.db.query.fql.add_fuel.call(null,fuel,inst_33112,max_fuel);
var state_33153__$1 = state_33153;
var statearr_33229_33294 = state_33153__$1;
(statearr_33229_33294[(2)] = inst_33113);

(statearr_33229_33294[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (37))){
var inst_33128 = (state_33153[(2)]);
var state_33153__$1 = state_33153;
var statearr_33230_33295 = state_33153__$1;
(statearr_33230_33295[(2)] = inst_33128);

(statearr_33230_33295[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (8))){
var inst_33012 = (state_33153[(15)]);
var state_33153__$1 = state_33153;
var statearr_33231_33296 = state_33153__$1;
(statearr_33231_33296[(2)] = inst_33012);

(statearr_33231_33296[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33154 === (49))){
var inst_33033 = (state_33153[(30)]);
var state_33153__$1 = state_33153;
var statearr_33232_33297 = state_33153__$1;
(statearr_33232_33297[(2)] = inst_33033);

(statearr_33232_33297[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10903__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10903__auto____0 = (function (){
var statearr_33233 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33233[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10903__auto__);

(statearr_33233[(1)] = (1));

return statearr_33233;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10903__auto____1 = (function (state_33153){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_33153);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e33234){var ex__10906__auto__ = e33234;
var statearr_33235_33298 = state_33153;
(statearr_33235_33298[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_33153[(4)]))){
var statearr_33236_33299 = state_33153;
(statearr_33236_33299[(1)] = cljs.core.first.call(null,(state_33153[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33300 = state_33153;
state_33153 = G__33300;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10903__auto__ = function(state_33153){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10903__auto____1.call(this,state_33153);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10903__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10903__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_33237 = f__10977__auto__.call(null);
(statearr_33237[(6)] = c__10976__auto__);

return statearr_33237;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_.call(null,pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4253__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.call(null,(function (acc,spec){
var key_spec = cljs.core.key.call(null,spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,spec)) == null))?cljs.core.assoc.call(null,cljs.core.val.call(null,spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val.call(null,spec));
return cljs.core.assoc.call(null,acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.call(null,coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__33301 = select_spec;
var map__33301__$1 = cljs.core.__destructure_map.call(null,map__33301);
var recur_seen = cljs.core.get.call(null,map__33301__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var recur_depth = cljs.core.get.call(null,map__33301__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
return cljs.core.select_keys.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057)], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687)], null),cljs.core.conj.call(null,recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"compact?","compact?",1216893298)], null));
});
/**
 * Performs recursion on a select spec graph crawl when specified. flakes input is list
 *   of flakes all with the same subject and predicate values.
 */
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flakes,select_spec,results,fuel,max_fuel,cache){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_33415){
var state_val_33416 = (state_33415[(1)]);
if((state_val_33416 === (7))){
var inst_33327 = flakes;
var inst_33328 = cljs.core.seq.call(null,inst_33327);
var inst_33329 = cljs.core.first.call(null,inst_33328);
var inst_33330 = cljs.core.next.call(null,inst_33328);
var inst_33331 = cljs.core.PersistentVector.EMPTY;
var inst_33332 = inst_33327;
var inst_33333 = (0);
var inst_33334 = inst_33331;
var state_33415__$1 = (function (){var statearr_33417 = state_33415;
(statearr_33417[(7)] = inst_33334);

(statearr_33417[(8)] = inst_33332);

(statearr_33417[(9)] = inst_33330);

(statearr_33417[(10)] = inst_33329);

(statearr_33417[(11)] = inst_33333);

return statearr_33417;
})();
var statearr_33418_33484 = state_33415__$1;
(statearr_33418_33484[(2)] = null);

(statearr_33418_33484[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33416 === (20))){
var state_33415__$1 = state_33415;
var statearr_33419_33485 = state_33415__$1;
(statearr_33419_33485[(2)] = results);

(statearr_33419_33485[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33416 === (27))){
var state_33415__$1 = state_33415;
var statearr_33420_33486 = state_33415__$1;
(statearr_33420_33486[(2)] = null);

(statearr_33420_33486[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33416 === (1))){
var state_33415__$1 = state_33415;
var statearr_33421_33487 = state_33415__$1;
(statearr_33421_33487[(2)] = null);

(statearr_33421_33487[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33416 === (24))){
var state_33415__$1 = state_33415;
var statearr_33422_33488 = state_33415__$1;
(statearr_33422_33488[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33416 === (39))){
var inst_33334 = (state_33415[(7)]);
var inst_33396 = (state_33415[(12)]);
var inst_33341 = (state_33415[(13)]);
var inst_33399 = (state_33415[(2)]);
var inst_33400 = fluree.db.util.async.throw_err.call(null,inst_33399);
var inst_33401 = cljs.core.conj.call(null,inst_33334,inst_33400);
var inst_33332 = inst_33341;
var inst_33333 = inst_33396;
var inst_33334__$1 = inst_33401;
var state_33415__$1 = (function (){var statearr_33424 = state_33415;
(statearr_33424[(7)] = inst_33334__$1);

(statearr_33424[(8)] = inst_33332);

(statearr_33424[(11)] = inst_33333);

return statearr_33424;
})();
var statearr_33425_33489 = state_33415__$1;
(statearr_33425_33489[(2)] = null);

(statearr_33425_33489[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33416 === (4))){
var inst_33302 = (state_33415[(2)]);
var state_33415__$1 = state_33415;
var statearr_33426_33490 = state_33415__$1;
(statearr_33426_33490[(2)] = inst_33302);

(statearr_33426_33490[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33416 === (15))){
var inst_33315 = (state_33415[(14)]);
var state_33415__$1 = state_33415;
var statearr_33427_33491 = state_33415__$1;
(statearr_33427_33491[(2)] = inst_33315);

(statearr_33427_33491[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33416 === (21))){
var inst_33311 = (state_33415[(15)]);
var state_33415__$1 = state_33415;
if(cljs.core.truth_(inst_33311)){
var statearr_33428_33492 = state_33415__$1;
(statearr_33428_33492[(1)] = (23));

} else {
var statearr_33429_33493 = state_33415__$1;
(statearr_33429_33493[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33416 === (31))){
var inst_33379 = (state_33415[(16)]);
var state_33415__$1 = state_33415;
var statearr_33430_33494 = state_33415__$1;
(statearr_33430_33494[(2)] = inst_33379);

(statearr_33430_33494[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33416 === (32))){
var inst_33371 = (state_33415[(17)]);
var inst_33385 = (state_33415[(2)]);
var state_33415__$1 = (function (){var statearr_33431 = state_33415;
(statearr_33431[(18)] = inst_33385);

return statearr_33431;
})();
if(cljs.core.truth_(inst_33371)){
var statearr_33432_33495 = state_33415__$1;
(statearr_33432_33495[(1)] = (33));

} else {
var statearr_33433_33496 = state_33415__$1;
(statearr_33433_33496[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33416 === (33))){
var inst_33371 = (state_33415[(17)]);
var state_33415__$1 = state_33415;
var statearr_33434_33497 = state_33415__$1;
(statearr_33434_33497[(2)] = inst_33371);

(statearr_33434_33497[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33416 === (13))){
var inst_33351 = (state_33415[(2)]);
var state_33415__$1 = state_33415;
if(cljs.core.truth_(inst_33351)){
var statearr_33436_33498 = state_33415__$1;
(statearr_33436_33498[(1)] = (17));

} else {
var statearr_33437_33499 = state_33415__$1;
(statearr_33437_33499[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33416 === (22))){
var inst_33368 = (state_33415[(2)]);
var state_33415__$1 = state_33415;
var statearr_33438_33500 = state_33415__$1;
(statearr_33438_33500[(2)] = inst_33368);

(statearr_33438_33500[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33416 === (36))){
var inst_33334 = (state_33415[(7)]);
var inst_33341 = (state_33415[(13)]);
var inst_33333 = (state_33415[(11)]);
var inst_33393 = (inst_33333 + (1));
var tmp33435 = inst_33334;
var inst_33332 = inst_33341;
var inst_33333__$1 = inst_33393;
var inst_33334__$1 = tmp33435;
var state_33415__$1 = (function (){var statearr_33439 = state_33415;
(statearr_33439[(7)] = inst_33334__$1);

(statearr_33439[(8)] = inst_33332);

(statearr_33439[(11)] = inst_33333__$1);

return statearr_33439;
})();
var statearr_33440_33501 = state_33415__$1;
(statearr_33440_33501[(2)] = null);

(statearr_33440_33501[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33416 === (29))){
var inst_33378 = (state_33415[(2)]);
var inst_33379 = fluree.db.util.async.throw_err.call(null,inst_33378);
var state_33415__$1 = (function (){var statearr_33441 = state_33415;
(statearr_33441[(16)] = inst_33379);

return statearr_33441;
})();
if(cljs.core.truth_(fuel)){
var statearr_33442_33502 = state_33415__$1;
(statearr_33442_33502[(1)] = (30));

} else {
var statearr_33443_33503 = state_33415__$1;
(statearr_33443_33503[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33416 === (6))){
var state_33415__$1 = state_33415;
var statearr_33444_33504 = state_33415__$1;
(statearr_33444_33504[(2)] = results);

(statearr_33444_33504[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33416 === (28))){
var inst_33364 = (state_33415[(2)]);
var state_33415__$1 = state_33415;
var statearr_33445_33505 = state_33415__$1;
(statearr_33445_33505[(2)] = inst_33364);

(statearr_33445_33505[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33416 === (25))){
var inst_33366 = (state_33415[(2)]);
var state_33415__$1 = state_33415;
var statearr_33446_33506 = state_33415__$1;
(statearr_33446_33506[(2)] = inst_33366);

(statearr_33446_33506[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33416 === (34))){
var inst_33385 = (state_33415[(18)]);
var inst_33388 = cljs.core.empty_QMARK_.call(null,inst_33385);
var state_33415__$1 = state_33415;
var statearr_33447_33507 = state_33415__$1;
(statearr_33447_33507[(2)] = inst_33388);

(statearr_33447_33507[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33416 === (17))){
var inst_33334 = (state_33415[(7)]);
var inst_33353 = cljs.core.empty_QMARK_.call(null,inst_33334);
var state_33415__$1 = state_33415;
if(inst_33353){
var statearr_33448_33508 = state_33415__$1;
(statearr_33448_33508[(1)] = (20));

} else {
var statearr_33449_33509 = state_33415__$1;
(statearr_33449_33509[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33416 === (3))){
var inst_33413 = (state_33415[(2)]);
var state_33415__$1 = state_33415;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33415__$1,inst_33413);
} else {
if((state_val_33416 === (12))){
var inst_33315 = (state_33415[(14)]);
var state_33415__$1 = state_33415;
if(cljs.core.truth_(inst_33315)){
var statearr_33450_33510 = state_33415__$1;
(statearr_33450_33510[(1)] = (14));

} else {
var statearr_33451_33511 = state_33415__$1;
(statearr_33451_33511[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33416 === (2))){
var _ = (function (){var statearr_33452 = state_33415;
(statearr_33452[(4)] = cljs.core.cons.call(null,(5),(state_33415[(4)])));

return statearr_33452;
})();
var inst_33309 = select_spec;
var inst_33310 = cljs.core.__destructure_map.call(null,inst_33309);
var inst_33311 = cljs.core.get.call(null,inst_33310,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_33312 = cljs.core.get.call(null,inst_33310,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_33313 = cljs.core.get.call(null,inst_33310,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var inst_33314 = cljs.core.get.call(null,inst_33310,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
var inst_33315 = cljs.core.get.call(null,inst_33310,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_33316 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(select_spec);
var inst_33317 = (inst_33314 > inst_33316);
var state_33415__$1 = (function (){var statearr_33453 = state_33415;
(statearr_33453[(19)] = inst_33313);

(statearr_33453[(20)] = inst_33312);

(statearr_33453[(14)] = inst_33315);

(statearr_33453[(15)] = inst_33311);

return statearr_33453;
})();
if(cljs.core.truth_(inst_33317)){
var statearr_33454_33512 = state_33415__$1;
(statearr_33454_33512[(1)] = (6));

} else {
var statearr_33455_33513 = state_33415__$1;
(statearr_33455_33513[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33416 === (23))){
var inst_33334 = (state_33415[(7)]);
var inst_33312 = (state_33415[(20)]);
var inst_33357 = cljs.core.assoc.call(null,results,inst_33312,inst_33334);
var state_33415__$1 = state_33415;
var statearr_33456_33514 = state_33415__$1;
(statearr_33456_33514[(2)] = inst_33357);

(statearr_33456_33514[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33416 === (35))){
var inst_33340 = (state_33415[(21)]);
var inst_33390 = (state_33415[(2)]);
var inst_33391 = fluree.db.query.fql.recur_select_spec.call(null,select_spec,inst_33340);
var state_33415__$1 = (function (){var statearr_33457 = state_33415;
(statearr_33457[(22)] = inst_33391);

return statearr_33457;
})();
if(cljs.core.truth_(inst_33390)){
var statearr_33458_33515 = state_33415__$1;
(statearr_33458_33515[(1)] = (36));

} else {
var statearr_33459_33516 = state_33415__$1;
(statearr_33459_33516[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33416 === (19))){
var inst_33406 = (state_33415[(2)]);
var state_33415__$1 = state_33415;
var statearr_33460_33517 = state_33415__$1;
(statearr_33460_33517[(2)] = inst_33406);

(statearr_33460_33517[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33416 === (11))){
var inst_33342 = (state_33415[(23)]);
var state_33415__$1 = state_33415;
var statearr_33462_33518 = state_33415__$1;
(statearr_33462_33518[(2)] = inst_33342);

(statearr_33462_33518[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33416 === (9))){
var inst_33342 = (state_33415[(23)]);
var inst_33332 = (state_33415[(8)]);
var inst_33340 = (state_33415[(21)]);
var inst_33339 = cljs.core.seq.call(null,inst_33332);
var inst_33340__$1 = cljs.core.first.call(null,inst_33339);
var inst_33341 = cljs.core.next.call(null,inst_33339);
var inst_33342__$1 = cljs.core.not.call(null,inst_33340__$1);
var state_33415__$1 = (function (){var statearr_33463 = state_33415;
(statearr_33463[(23)] = inst_33342__$1);

(statearr_33463[(13)] = inst_33341);

(statearr_33463[(21)] = inst_33340__$1);

return statearr_33463;
})();
if(inst_33342__$1){
var statearr_33464_33519 = state_33415__$1;
(statearr_33464_33519[(1)] = (11));

} else {
var statearr_33465_33520 = state_33415__$1;
(statearr_33465_33520[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33416 === (5))){
var _ = (function (){var statearr_33466 = state_33415;
(statearr_33466[(4)] = cljs.core.rest.call(null,(state_33415[(4)])));

return statearr_33466;
})();
var state_33415__$1 = state_33415;
var ex33461 = (state_33415__$1[(2)]);
var statearr_33467_33521 = state_33415__$1;
(statearr_33467_33521[(5)] = ex33461);


if((ex33461 instanceof Error)){
var statearr_33468_33522 = state_33415__$1;
(statearr_33468_33522[(1)] = (4));

(statearr_33468_33522[(5)] = null);

} else {
throw ex33461;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33416 === (14))){
var inst_33315 = (state_33415[(14)]);
var inst_33333 = (state_33415[(11)]);
var inst_33346 = (inst_33333 < inst_33315);
var state_33415__$1 = state_33415;
var statearr_33469_33523 = state_33415__$1;
(statearr_33469_33523[(2)] = inst_33346);

(statearr_33469_33523[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33416 === (26))){
var inst_33334 = (state_33415[(7)]);
var inst_33312 = (state_33415[(20)]);
var inst_33360 = cljs.core.first.call(null,inst_33334);
var inst_33361 = cljs.core.assoc.call(null,results,inst_33312,inst_33360);
var state_33415__$1 = state_33415;
var statearr_33470_33524 = state_33415__$1;
(statearr_33470_33524[(2)] = inst_33361);

(statearr_33470_33524[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33416 === (16))){
var inst_33349 = (state_33415[(2)]);
var state_33415__$1 = state_33415;
var statearr_33471_33525 = state_33415__$1;
(statearr_33471_33525[(2)] = inst_33349);

(statearr_33471_33525[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33416 === (38))){
var inst_33404 = (state_33415[(2)]);
var state_33415__$1 = state_33415;
var statearr_33472_33526 = state_33415__$1;
(statearr_33472_33526[(2)] = inst_33404);

(statearr_33472_33526[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33416 === (30))){
var inst_33379 = (state_33415[(16)]);
var inst_33381 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_33382 = cljs.core.sequence.call(null,inst_33381,inst_33379);
var state_33415__$1 = state_33415;
var statearr_33473_33527 = state_33415__$1;
(statearr_33473_33527[(2)] = inst_33382);

(statearr_33473_33527[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33416 === (10))){
var inst_33408 = (state_33415[(2)]);
var state_33415__$1 = state_33415;
var statearr_33474_33528 = state_33415__$1;
(statearr_33474_33528[(2)] = inst_33408);

(statearr_33474_33528[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33416 === (18))){
var inst_33313 = (state_33415[(19)]);
var inst_33340 = (state_33415[(21)]);
var inst_33370 = inst_33340.o;
var inst_33371 = cljs.core.contains_QMARK_.call(null,inst_33313,inst_33370);
var inst_33373 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33374 = [inst_33370];
var inst_33375 = (new cljs.core.PersistentVector(null,1,(5),inst_33373,inst_33374,null));
var inst_33376 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_33375);
var state_33415__$1 = (function (){var statearr_33475 = state_33415;
(statearr_33475[(17)] = inst_33371);

return statearr_33475;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33415__$1,(29),inst_33376);
} else {
if((state_val_33416 === (37))){
var inst_33391 = (state_33415[(22)]);
var inst_33385 = (state_33415[(18)]);
var inst_33333 = (state_33415[(11)]);
var inst_33396 = (inst_33333 + (1));
var inst_33397 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_33391,inst_33385);
var state_33415__$1 = (function (){var statearr_33476 = state_33415;
(statearr_33476[(12)] = inst_33396);

return statearr_33476;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33415__$1,(39),inst_33397);
} else {
if((state_val_33416 === (8))){
var inst_33410 = (state_33415[(2)]);
var _ = (function (){var statearr_33477 = state_33415;
(statearr_33477[(4)] = cljs.core.rest.call(null,(state_33415[(4)])));

return statearr_33477;
})();
var state_33415__$1 = state_33415;
var statearr_33478_33529 = state_33415__$1;
(statearr_33478_33529[(2)] = inst_33410);

(statearr_33478_33529[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__10903__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__10903__auto____0 = (function (){
var statearr_33479 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33479[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__10903__auto__);

(statearr_33479[(1)] = (1));

return statearr_33479;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__10903__auto____1 = (function (state_33415){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_33415);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e33480){var ex__10906__auto__ = e33480;
var statearr_33481_33530 = state_33415;
(statearr_33481_33530[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_33415[(4)]))){
var statearr_33482_33531 = state_33415;
(statearr_33482_33531[(1)] = cljs.core.first.call(null,(state_33415[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33532 = state_33415;
state_33415 = G__33532;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__10903__auto__ = function(state_33415){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__10903__auto____1.call(this,state_33415);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__10903__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__10903__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_33483 = f__10977__auto__.call(null);
(statearr_33483[(6)] = c__10976__auto__);

return statearr_33483;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_33713){
var state_val_33714 = (state_33713[(1)]);
if((state_val_33714 === (7))){
var state_33713__$1 = state_33713;
var statearr_33715_33801 = state_33713__$1;
(statearr_33715_33801[(2)] = null);

(statearr_33715_33801[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (20))){
var inst_33571 = cljs.core.PersistentHashMap.EMPTY;
var state_33713__$1 = state_33713;
var statearr_33716_33802 = state_33713__$1;
(statearr_33716_33802[(2)] = inst_33571);

(statearr_33716_33802[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (27))){
var inst_33573 = (state_33713[(7)]);
var inst_33589 = (state_33713[(8)]);
var inst_33553 = (state_33713[(9)]);
var inst_33559 = (state_33713[(10)]);
var inst_33692 = (state_33713[(2)]);
var inst_33693 = (function (){var top_level_subject = inst_33553;
var select_spec = inst_33559;
var base_acc = inst_33573;
var acc_PLUS_refs = inst_33589;
var result = inst_33692;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4253__auto__ = (function (){var and__4251__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4251__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var and__4251__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4251__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4251__auto__;
}
}
})())){
return cljs.core.conj.call(null,acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_33694 = cljs.core.PersistentVector.EMPTY;
var inst_33695 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_33559);
var inst_33696 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_33695);
var inst_33697 = cljs.core.vals.call(null,inst_33696);
var inst_33698 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_33559);
var inst_33699 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_33698);
var inst_33700 = cljs.core.vals.call(null,inst_33699);
var inst_33701 = cljs.core.concat.call(null,inst_33697,inst_33700);
var inst_33702 = cljs.core.reduce.call(null,inst_33693,inst_33694,inst_33701);
var inst_33704 = (function (){var top_level_subject = inst_33553;
var select_spec = inst_33559;
var base_acc = inst_33573;
var acc_PLUS_refs = inst_33589;
var result = inst_33692;
var sort_preds = inst_33702;
return (function (acc,p__33703){
var vec__33717 = p__33703;
var selectPred = cljs.core.nth.call(null,vec__33717,(0),null);
var sortOrder = cljs.core.nth.call(null,vec__33717,(1),null);
var sortPred = cljs.core.nth.call(null,vec__33717,(2),null);
var limit = cljs.core.nth.call(null,vec__33717,(3),null);
return cljs.core.assoc.call(null,acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res.call(null,sortPred,sortOrder,(0),limit,cljs.core.get.call(null,acc,selectPred)));
});
})();
var inst_33705 = cljs.core.reduce.call(null,inst_33704,inst_33692,inst_33702);
var state_33713__$1 = state_33713;
var statearr_33720_33803 = state_33713__$1;
(statearr_33720_33803[(2)] = inst_33705);

(statearr_33720_33803[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (1))){
var state_33713__$1 = state_33713;
var statearr_33721_33804 = state_33713__$1;
(statearr_33721_33804[(2)] = null);

(statearr_33721_33804[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (24))){
var inst_33589 = (state_33713[(8)]);
var inst_33589__$1 = (state_33713[(2)]);
var inst_33590 = cljs.core.partition_by.call(null,new cljs.core.Keyword(null,"p","p",151049309),flakes);
var inst_33591 = cljs.core.PersistentHashMap.EMPTY;
var inst_33592 = inst_33590;
var inst_33593 = inst_33589__$1;
var inst_33594 = inst_33591;
var state_33713__$1 = (function (){var statearr_33722 = state_33713;
(statearr_33722[(8)] = inst_33589__$1);

(statearr_33722[(11)] = inst_33593);

(statearr_33722[(12)] = inst_33594);

(statearr_33722[(13)] = inst_33592);

return statearr_33722;
})();
var statearr_33723_33805 = state_33713__$1;
(statearr_33723_33805[(2)] = null);

(statearr_33723_33805[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (39))){
var inst_33593 = (state_33713[(11)]);
var inst_33609 = (state_33713[(14)]);
var inst_33559 = (state_33713[(10)]);
var inst_33602 = (state_33713[(15)]);
var inst_33638 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33639 = fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,inst_33593,inst_33559,inst_33602,inst_33609,false);
var state_33713__$1 = (function (){var statearr_33724 = state_33713;
(statearr_33724[(16)] = inst_33638);

return statearr_33724;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33713__$1,(42),inst_33639);
} else {
if((state_val_33714 === (46))){
var inst_33594 = (state_33713[(12)]);
var inst_33592 = (state_33713[(13)]);
var inst_33602 = (state_33713[(15)]);
var inst_33656 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33657 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_33658 = cljs.core.first.call(null,inst_33602);
var inst_33659 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_33658);
var inst_33660 = [inst_33659];
var inst_33661 = cljs.core.PersistentHashMap.fromArrays(inst_33657,inst_33660);
var inst_33662 = cljs.core.rest.call(null,inst_33592);
var inst_33663 = [inst_33661,inst_33662,inst_33594];
var inst_33664 = (new cljs.core.PersistentVector(null,3,(5),inst_33656,inst_33663,null));
var state_33713__$1 = state_33713;
var statearr_33725_33806 = state_33713__$1;
(statearr_33725_33806[(2)] = inst_33664);

(statearr_33725_33806[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (4))){
var inst_33533 = (state_33713[(2)]);
var state_33713__$1 = state_33713;
var statearr_33726_33807 = state_33713__$1;
(statearr_33726_33807[(2)] = inst_33533);

(statearr_33726_33807[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (15))){
var inst_33559 = (state_33713[(10)]);
var inst_33560 = (state_33713[(17)]);
var inst_33559__$1 = (state_33713[(2)]);
var inst_33560__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_33559__$1);
var state_33713__$1 = (function (){var statearr_33727 = state_33713;
(statearr_33727[(10)] = inst_33559__$1);

(statearr_33727[(17)] = inst_33560__$1);

return statearr_33727;
})();
if(cljs.core.truth_(inst_33560__$1)){
var statearr_33728_33808 = state_33713__$1;
(statearr_33728_33808[(1)] = (16));

} else {
var statearr_33729_33809 = state_33713__$1;
(statearr_33729_33809[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (48))){
var inst_33675 = (state_33713[(2)]);
var state_33713__$1 = state_33713;
var statearr_33730_33810 = state_33713__$1;
(statearr_33730_33810[(2)] = inst_33675);

(statearr_33730_33810[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (50))){
var state_33713__$1 = state_33713;
var statearr_33731_33811 = state_33713__$1;
(statearr_33731_33811[(2)] = null);

(statearr_33731_33811[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (21))){
var inst_33559 = (state_33713[(10)]);
var inst_33573 = (state_33713[(2)]);
var inst_33574 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33575 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_33576 = (new cljs.core.PersistentVector(null,2,(5),inst_33574,inst_33575,null));
var inst_33577 = cljs.core.get_in.call(null,inst_33559,inst_33576);
var state_33713__$1 = (function (){var statearr_33732 = state_33713;
(statearr_33732[(7)] = inst_33573);

return statearr_33732;
})();
if(cljs.core.truth_(inst_33577)){
var statearr_33733_33812 = state_33713__$1;
(statearr_33733_33812[(1)] = (22));

} else {
var statearr_33734_33813 = state_33713__$1;
(statearr_33734_33813[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (31))){
var inst_33593 = (state_33713[(11)]);
var inst_33608 = (state_33713[(18)]);
var inst_33602 = (state_33713[(15)]);
var inst_33612 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33613 = fluree.db.query.fql.flake__GT_recur.call(null,db,inst_33602,inst_33608,inst_33593,fuel,max_fuel,cache);
var state_33713__$1 = (function (){var statearr_33735 = state_33713;
(statearr_33735[(19)] = inst_33612);

return statearr_33735;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33713__$1,(34),inst_33613);
} else {
if((state_val_33714 === (32))){
var inst_33608 = (state_33713[(18)]);
var state_33713__$1 = state_33713;
if(cljs.core.truth_(inst_33608)){
var statearr_33736_33814 = state_33713__$1;
(statearr_33736_33814[(1)] = (35));

} else {
var statearr_33737_33815 = state_33713__$1;
(statearr_33737_33815[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (40))){
var inst_33649 = (state_33713[(20)]);
var inst_33559 = (state_33713[(10)]);
var inst_33648 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_33559);
var inst_33649__$1 = cljs.core.empty_QMARK_.call(null,inst_33648);
var state_33713__$1 = (function (){var statearr_33738 = state_33713;
(statearr_33738[(20)] = inst_33649__$1);

return statearr_33738;
})();
if(inst_33649__$1){
var statearr_33739_33816 = state_33713__$1;
(statearr_33739_33816[(1)] = (43));

} else {
var statearr_33740_33817 = state_33713__$1;
(statearr_33740_33817[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (33))){
var inst_33602 = (state_33713[(15)]);
var inst_33681 = (state_33713[(2)]);
var inst_33682 = cljs.core.nth.call(null,inst_33681,(0),null);
var inst_33683 = cljs.core.nth.call(null,inst_33681,(1),null);
var inst_33684 = cljs.core.nth.call(null,inst_33681,(2),null);
var inst_33685 = cljs.core.first.call(null,inst_33602);
var inst_33686 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_33685);
var inst_33687 = cljs.core.assoc.call(null,inst_33682,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_33686);
var inst_33592 = inst_33683;
var inst_33593 = inst_33687;
var inst_33594 = inst_33684;
var state_33713__$1 = (function (){var statearr_33741 = state_33713;
(statearr_33741[(11)] = inst_33593);

(statearr_33741[(12)] = inst_33594);

(statearr_33741[(13)] = inst_33592);

return statearr_33741;
})();
var statearr_33742_33818 = state_33713__$1;
(statearr_33742_33818[(2)] = null);

(statearr_33742_33818[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (13))){
var inst_33553 = (state_33713[(9)]);
var inst_33556 = fluree.db.query.fql.full_select_spec.call(null,db,cache,base_select_spec,inst_33553);
var state_33713__$1 = state_33713;
var statearr_33743_33819 = state_33713__$1;
(statearr_33743_33819[(2)] = inst_33556);

(statearr_33743_33819[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (22))){
var inst_33559 = (state_33713[(10)]);
var inst_33579 = cljs.core.first.call(null,flakes);
var inst_33580 = fluree.db.query.fql.s.call(null,inst_33579);
var inst_33581 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs.call(null,inst_33559);
var inst_33582 = fluree.db.query.fql.resolve_reverse_refs.call(null,db,cache,fuel,max_fuel,inst_33580,inst_33581);
var state_33713__$1 = state_33713;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33713__$1,(25),inst_33582);
} else {
if((state_val_33714 === (36))){
var inst_33559 = (state_33713[(10)]);
var inst_33636 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_33559);
var state_33713__$1 = state_33713;
if(cljs.core.truth_(inst_33636)){
var statearr_33744_33820 = state_33713__$1;
(statearr_33744_33820[(1)] = (39));

} else {
var statearr_33745_33821 = state_33713__$1;
(statearr_33745_33821[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (41))){
var inst_33677 = (state_33713[(2)]);
var state_33713__$1 = state_33713;
var statearr_33746_33822 = state_33713__$1;
(statearr_33746_33822[(2)] = inst_33677);

(statearr_33746_33822[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (43))){
var inst_33559 = (state_33713[(10)]);
var inst_33651 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_33559);
var state_33713__$1 = state_33713;
var statearr_33747_33823 = state_33713__$1;
(statearr_33747_33823[(2)] = inst_33651);

(statearr_33747_33823[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (29))){
var inst_33592 = (state_33713[(13)]);
var inst_33559 = (state_33713[(10)]);
var inst_33608 = (state_33713[(18)]);
var inst_33602 = (state_33713[(15)]);
var inst_33602__$1 = cljs.core.first.call(null,inst_33592);
var inst_33603 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33604 = cljs.core.first.call(null,inst_33602__$1);
var inst_33605 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_33604);
var inst_33606 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_33605];
var inst_33607 = (new cljs.core.PersistentVector(null,3,(5),inst_33603,inst_33606,null));
var inst_33608__$1 = cljs.core.get_in.call(null,inst_33559,inst_33607);
var inst_33609 = fluree.db.query.fql.component_follow_QMARK_.call(null,inst_33608__$1,inst_33559);
var inst_33610 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_33608__$1);
var state_33713__$1 = (function (){var statearr_33748 = state_33713;
(statearr_33748[(14)] = inst_33609);

(statearr_33748[(18)] = inst_33608__$1);

(statearr_33748[(15)] = inst_33602__$1);

return statearr_33748;
})();
if(cljs.core.truth_(inst_33610)){
var statearr_33749_33824 = state_33713__$1;
(statearr_33749_33824[(1)] = (31));

} else {
var statearr_33750_33825 = state_33713__$1;
(statearr_33750_33825[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (44))){
var inst_33649 = (state_33713[(20)]);
var state_33713__$1 = state_33713;
var statearr_33751_33826 = state_33713__$1;
(statearr_33751_33826[(2)] = inst_33649);

(statearr_33751_33826[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (6))){
var state_33713__$1 = state_33713;
var statearr_33752_33827 = state_33713__$1;
(statearr_33752_33827[(2)] = null);

(statearr_33752_33827[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (28))){
var inst_33593 = (state_33713[(11)]);
var state_33713__$1 = state_33713;
var statearr_33753_33828 = state_33713__$1;
(statearr_33753_33828[(2)] = inst_33593);

(statearr_33753_33828[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (51))){
var inst_33673 = (state_33713[(2)]);
var state_33713__$1 = state_33713;
var statearr_33754_33829 = state_33713__$1;
(statearr_33754_33829[(2)] = inst_33673);

(statearr_33754_33829[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (25))){
var inst_33573 = (state_33713[(7)]);
var inst_33584 = (state_33713[(2)]);
var inst_33585 = fluree.db.util.async.throw_err.call(null,inst_33584);
var inst_33586 = cljs.core.merge.call(null,inst_33573,inst_33585);
var state_33713__$1 = state_33713;
var statearr_33755_33830 = state_33713__$1;
(statearr_33755_33830[(2)] = inst_33586);

(statearr_33755_33830[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (34))){
var inst_33594 = (state_33713[(12)]);
var inst_33592 = (state_33713[(13)]);
var inst_33612 = (state_33713[(19)]);
var inst_33615 = (state_33713[(2)]);
var inst_33616 = fluree.db.util.async.throw_err.call(null,inst_33615);
var inst_33617 = cljs.core.rest.call(null,inst_33592);
var inst_33618 = [inst_33616,inst_33617,inst_33594];
var inst_33619 = (new cljs.core.PersistentVector(null,3,(5),inst_33612,inst_33618,null));
var state_33713__$1 = state_33713;
var statearr_33756_33831 = state_33713__$1;
(statearr_33756_33831[(2)] = inst_33619);

(statearr_33756_33831[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (17))){
var inst_33559 = (state_33713[(10)]);
var inst_33563 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_33559);
var state_33713__$1 = state_33713;
var statearr_33758_33832 = state_33713__$1;
(statearr_33758_33832[(2)] = inst_33563);

(statearr_33758_33832[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (3))){
var inst_33711 = (state_33713[(2)]);
var state_33713__$1 = state_33713;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33713__$1,inst_33711);
} else {
if((state_val_33714 === (12))){
var _ = (function (){var statearr_33759 = state_33713;
(statearr_33759[(4)] = cljs.core.rest.call(null,(state_33713[(4)])));

return statearr_33759;
})();
var state_33713__$1 = state_33713;
var ex33757 = (state_33713__$1[(2)]);
var statearr_33760_33833 = state_33713__$1;
(statearr_33760_33833[(5)] = ex33757);


var statearr_33761_33834 = state_33713__$1;
(statearr_33761_33834[(1)] = (11));

(statearr_33761_33834[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (2))){
var _ = (function (){var statearr_33762 = state_33713;
(statearr_33762[(4)] = cljs.core.cons.call(null,(5),(state_33713[(4)])));

return statearr_33762;
})();
var inst_33539 = cljs.core.not_empty.call(null,flakes);
var state_33713__$1 = state_33713;
if(cljs.core.truth_(inst_33539)){
var statearr_33763_33835 = state_33713__$1;
(statearr_33763_33835[(1)] = (6));

} else {
var statearr_33764_33836 = state_33713__$1;
(statearr_33764_33836[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (23))){
var inst_33573 = (state_33713[(7)]);
var state_33713__$1 = state_33713;
var statearr_33765_33837 = state_33713__$1;
(statearr_33765_33837[(2)] = inst_33573);

(statearr_33765_33837[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (47))){
var state_33713__$1 = state_33713;
var statearr_33766_33838 = state_33713__$1;
(statearr_33766_33838[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (35))){
var inst_33593 = (state_33713[(11)]);
var inst_33594 = (state_33713[(12)]);
var inst_33609 = (state_33713[(14)]);
var inst_33608 = (state_33713[(18)]);
var inst_33602 = (state_33713[(15)]);
var inst_33625 = fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,inst_33593,inst_33608,inst_33602,inst_33609,false,inst_33594);
var state_33713__$1 = state_33713;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33713__$1,(38),inst_33625);
} else {
if((state_val_33714 === (19))){
var inst_33553 = (state_33713[(9)]);
var inst_33567 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_33568 = [inst_33553];
var inst_33569 = cljs.core.PersistentHashMap.fromArrays(inst_33567,inst_33568);
var state_33713__$1 = state_33713;
var statearr_33768_33839 = state_33713__$1;
(statearr_33768_33839[(2)] = inst_33569);

(statearr_33768_33839[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (11))){
var inst_33541 = (state_33713[(2)]);
var inst_33542 = fluree.db.util.log.error.call(null,inst_33541);
var inst_33543 = (function(){throw inst_33541})();
var state_33713__$1 = (function (){var statearr_33770 = state_33713;
(statearr_33770[(21)] = inst_33542);

return statearr_33770;
})();
var statearr_33771_33840 = state_33713__$1;
(statearr_33771_33840[(2)] = inst_33543);

(statearr_33771_33840[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (9))){
var _ = (function (){var statearr_33772 = state_33713;
(statearr_33772[(4)] = cljs.core.cons.call(null,(12),(state_33713[(4)])));

return statearr_33772;
})();
var inst_33549 = cljs.core.first.call(null,flakes);
var inst_33550 = fluree.db.query.fql.s.call(null,inst_33549);
var ___$1 = (function (){var statearr_33773 = state_33713;
(statearr_33773[(4)] = cljs.core.rest.call(null,(state_33713[(4)])));

return statearr_33773;
})();
var state_33713__$1 = state_33713;
var statearr_33774_33841 = state_33713__$1;
(statearr_33774_33841[(2)] = inst_33550);

(statearr_33774_33841[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (5))){
var _ = (function (){var statearr_33775 = state_33713;
(statearr_33775[(4)] = cljs.core.rest.call(null,(state_33713[(4)])));

return statearr_33775;
})();
var state_33713__$1 = state_33713;
var ex33769 = (state_33713__$1[(2)]);
var statearr_33776_33842 = state_33713__$1;
(statearr_33776_33842[(5)] = ex33769);


if((ex33769 instanceof Error)){
var statearr_33777_33843 = state_33713__$1;
(statearr_33777_33843[(1)] = (4));

(statearr_33777_33843[(5)] = null);

} else {
throw ex33769;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (14))){
var state_33713__$1 = state_33713;
var statearr_33778_33844 = state_33713__$1;
(statearr_33778_33844[(2)] = base_select_spec);

(statearr_33778_33844[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (45))){
var inst_33654 = (state_33713[(2)]);
var state_33713__$1 = state_33713;
if(cljs.core.truth_(inst_33654)){
var statearr_33779_33845 = state_33713__$1;
(statearr_33779_33845[(1)] = (46));

} else {
var statearr_33780_33846 = state_33713__$1;
(statearr_33780_33846[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (26))){
var inst_33592 = (state_33713[(13)]);
var inst_33596 = cljs.core.empty_QMARK_.call(null,inst_33592);
var state_33713__$1 = state_33713;
if(inst_33596){
var statearr_33781_33847 = state_33713__$1;
(statearr_33781_33847[(1)] = (28));

} else {
var statearr_33782_33848 = state_33713__$1;
(statearr_33782_33848[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (16))){
var inst_33560 = (state_33713[(17)]);
var state_33713__$1 = state_33713;
var statearr_33783_33849 = state_33713__$1;
(statearr_33783_33849[(2)] = inst_33560);

(statearr_33783_33849[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (38))){
var inst_33592 = (state_33713[(13)]);
var inst_33627 = (state_33713[(2)]);
var inst_33628 = fluree.db.util.async.throw_err.call(null,inst_33627);
var inst_33629 = cljs.core.nth.call(null,inst_33628,(0),null);
var inst_33630 = cljs.core.nth.call(null,inst_33628,(1),null);
var inst_33631 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33632 = cljs.core.rest.call(null,inst_33592);
var inst_33633 = [inst_33629,inst_33632,inst_33630];
var inst_33634 = (new cljs.core.PersistentVector(null,3,(5),inst_33631,inst_33633,null));
var state_33713__$1 = state_33713;
var statearr_33784_33850 = state_33713__$1;
(statearr_33784_33850[(2)] = inst_33634);

(statearr_33784_33850[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (30))){
var inst_33690 = (state_33713[(2)]);
var state_33713__$1 = state_33713;
var statearr_33785_33851 = state_33713__$1;
(statearr_33785_33851[(2)] = inst_33690);

(statearr_33785_33851[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (10))){
var inst_33553 = (state_33713[(2)]);
var inst_33554 = fluree.db.query.fql.has_ns_lookups_QMARK_.call(null,base_select_spec);
var state_33713__$1 = (function (){var statearr_33786 = state_33713;
(statearr_33786[(9)] = inst_33553);

return statearr_33786;
})();
if(cljs.core.truth_(inst_33554)){
var statearr_33787_33852 = state_33713__$1;
(statearr_33787_33852[(1)] = (13));

} else {
var statearr_33788_33853 = state_33713__$1;
(statearr_33788_33853[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (18))){
var inst_33565 = (state_33713[(2)]);
var state_33713__$1 = state_33713;
if(cljs.core.truth_(inst_33565)){
var statearr_33789_33854 = state_33713__$1;
(statearr_33789_33854[(1)] = (19));

} else {
var statearr_33790_33855 = state_33713__$1;
(statearr_33790_33855[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (42))){
var inst_33638 = (state_33713[(16)]);
var inst_33594 = (state_33713[(12)]);
var inst_33592 = (state_33713[(13)]);
var inst_33641 = (state_33713[(2)]);
var inst_33642 = fluree.db.util.async.throw_err.call(null,inst_33641);
var inst_33643 = cljs.core.first.call(null,inst_33642);
var inst_33644 = cljs.core.rest.call(null,inst_33592);
var inst_33645 = [inst_33643,inst_33644,inst_33594];
var inst_33646 = (new cljs.core.PersistentVector(null,3,(5),inst_33638,inst_33645,null));
var state_33713__$1 = state_33713;
var statearr_33791_33856 = state_33713__$1;
(statearr_33791_33856[(2)] = inst_33646);

(statearr_33791_33856[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (37))){
var inst_33679 = (state_33713[(2)]);
var state_33713__$1 = state_33713;
var statearr_33792_33857 = state_33713__$1;
(statearr_33792_33857[(2)] = inst_33679);

(statearr_33792_33857[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (8))){
var inst_33708 = (state_33713[(2)]);
var _ = (function (){var statearr_33793 = state_33713;
(statearr_33793[(4)] = cljs.core.rest.call(null,(state_33713[(4)])));

return statearr_33793;
})();
var state_33713__$1 = state_33713;
var statearr_33794_33858 = state_33713__$1;
(statearr_33794_33858[(2)] = inst_33708);

(statearr_33794_33858[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33714 === (49))){
var inst_33593 = (state_33713[(11)]);
var inst_33594 = (state_33713[(12)]);
var inst_33592 = (state_33713[(13)]);
var inst_33667 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33668 = cljs.core.rest.call(null,inst_33592);
var inst_33669 = [inst_33593,inst_33668,inst_33594];
var inst_33670 = (new cljs.core.PersistentVector(null,3,(5),inst_33667,inst_33669,null));
var state_33713__$1 = state_33713;
var statearr_33795_33859 = state_33713__$1;
(statearr_33795_33859[(2)] = inst_33670);

(statearr_33795_33859[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__10903__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__10903__auto____0 = (function (){
var statearr_33796 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33796[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__10903__auto__);

(statearr_33796[(1)] = (1));

return statearr_33796;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__10903__auto____1 = (function (state_33713){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_33713);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e33797){var ex__10906__auto__ = e33797;
var statearr_33798_33860 = state_33713;
(statearr_33798_33860[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_33713[(4)]))){
var statearr_33799_33861 = state_33713;
(statearr_33799_33861[(1)] = cljs.core.first.call(null,(state_33713[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33862 = state_33713;
state_33713 = G__33862;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__10903__auto__ = function(state_33713){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__10903__auto____1.call(this,state_33713);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__10903__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__10903__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_33800 = f__10977__auto__.call(null);
(statearr_33800[(6)] = c__10976__auto__);

return statearr_33800;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__33865 = arguments.length;
switch (G__33865) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.call(null,db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.call(null,db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_33907){
var state_val_33908 = (state_33907[(1)]);
if((state_val_33908 === (7))){
var inst_33873 = (state_33907[(7)]);
var state_33907__$1 = state_33907;
var statearr_33909_33939 = state_33907__$1;
(statearr_33909_33939[(2)] = inst_33873);

(statearr_33909_33939[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33908 === (1))){
var state_33907__$1 = state_33907;
var statearr_33910_33940 = state_33907__$1;
(statearr_33910_33940[(2)] = null);

(statearr_33910_33940[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33908 === (4))){
var inst_33866 = (state_33907[(2)]);
var state_33907__$1 = state_33907;
var statearr_33911_33941 = state_33907__$1;
(statearr_33911_33941[(2)] = inst_33866);

(statearr_33911_33941[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33908 === (15))){
var inst_33901 = (state_33907[(2)]);
var inst_33902 = fluree.db.util.async.throw_err.call(null,inst_33901);
var _ = (function (){var statearr_33912 = state_33907;
(statearr_33912[(4)] = cljs.core.rest.call(null,(state_33907[(4)])));

return statearr_33912;
})();
var state_33907__$1 = state_33907;
var statearr_33913_33942 = state_33907__$1;
(statearr_33913_33942[(2)] = inst_33902);

(statearr_33913_33942[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33908 === (13))){
var inst_33885 = (state_33907[(8)]);
var state_33907__$1 = state_33907;
var statearr_33914_33943 = state_33907__$1;
(statearr_33914_33943[(2)] = inst_33885);

(statearr_33914_33943[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33908 === (6))){
var inst_33873 = (state_33907[(7)]);
var inst_33875 = fluree.db.query.fql.fuel_flakes_transducer.call(null,fuel,max_fuel);
var inst_33876 = cljs.core.comp.call(null,inst_33873,inst_33875);
var state_33907__$1 = state_33907;
var statearr_33915_33944 = state_33907__$1;
(statearr_33915_33944[(2)] = inst_33876);

(statearr_33915_33944[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33908 === (3))){
var inst_33905 = (state_33907[(2)]);
var state_33907__$1 = state_33907;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33907__$1,inst_33905);
} else {
if((state_val_33908 === (12))){
var inst_33885 = (state_33907[(8)]);
var inst_33887 = cljs.core.take.call(null,limit);
var inst_33888 = cljs.core.comp.call(null,inst_33885,inst_33887);
var state_33907__$1 = state_33907;
var statearr_33916_33945 = state_33907__$1;
(statearr_33916_33945[(2)] = inst_33888);

(statearr_33916_33945[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33908 === (2))){
var _ = (function (){var statearr_33917 = state_33907;
(statearr_33917[(4)] = cljs.core.cons.call(null,(5),(state_33907[(4)])));

return statearr_33917;
})();
var inst_33873 = cljs.core.partition_by.call(null,fluree.db.query.fql.s);
var state_33907__$1 = (function (){var statearr_33918 = state_33907;
(statearr_33918[(7)] = inst_33873);

return statearr_33918;
})();
if(cljs.core.truth_(fuel)){
var statearr_33919_33946 = state_33907__$1;
(statearr_33919_33946[(1)] = (6));

} else {
var statearr_33920_33947 = state_33907__$1;
(statearr_33920_33947[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33908 === (11))){
var inst_33885 = (state_33907[(2)]);
var state_33907__$1 = (function (){var statearr_33922 = state_33907;
(statearr_33922[(8)] = inst_33885);

return statearr_33922;
})();
if(cljs.core.truth_(limit)){
var statearr_33923_33948 = state_33907__$1;
(statearr_33923_33948[(1)] = (12));

} else {
var statearr_33924_33949 = state_33907__$1;
(statearr_33924_33949[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33908 === (9))){
var inst_33879 = (state_33907[(9)]);
var inst_33881 = cljs.core.drop.call(null,offset);
var inst_33882 = cljs.core.comp.call(null,inst_33879,inst_33881);
var state_33907__$1 = state_33907;
var statearr_33925_33950 = state_33907__$1;
(statearr_33925_33950[(2)] = inst_33882);

(statearr_33925_33950[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33908 === (5))){
var _ = (function (){var statearr_33926 = state_33907;
(statearr_33926[(4)] = cljs.core.rest.call(null,(state_33907[(4)])));

return statearr_33926;
})();
var state_33907__$1 = state_33907;
var ex33921 = (state_33907__$1[(2)]);
var statearr_33927_33951 = state_33907__$1;
(statearr_33927_33951[(5)] = ex33921);


if((ex33921 instanceof Error)){
var statearr_33928_33952 = state_33907__$1;
(statearr_33928_33952[(1)] = (4));

(statearr_33928_33952[(5)] = null);

} else {
throw ex33921;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33908 === (14))){
var inst_33891 = (state_33907[(2)]);
var inst_33892 = (function (){return (function (x){
var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (cljs.core.deref.call(null,fuel) >= max_fuel);
} else {
return and__4251__auto__;
}
});
})();
var inst_33893 = cljs.core.halt_when.call(null,inst_33892);
var inst_33894 = cljs.core.comp.call(null,inst_33891,inst_33893);
var inst_33895 = cljs.core.sequence.call(null,inst_33894,flakes);
var inst_33896 = cljs.core.PersistentVector.EMPTY;
var inst_33897 = (function (){var xf = inst_33894;
var flakes_by_sub = inst_33895;
return (function (p1__33863_SHARP_){
return fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,select_spec,p1__33863_SHARP_);
});
})();
var inst_33898 = cljs.core.map.call(null,inst_33897,inst_33895);
var inst_33899 = fluree.db.util.async.merge_into_QMARK_.call(null,inst_33896,inst_33898);
var state_33907__$1 = state_33907;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33907__$1,(15),inst_33899);
} else {
if((state_val_33908 === (10))){
var inst_33879 = (state_33907[(9)]);
var state_33907__$1 = state_33907;
var statearr_33929_33953 = state_33907__$1;
(statearr_33929_33953[(2)] = inst_33879);

(statearr_33929_33953[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33908 === (8))){
var inst_33879 = (state_33907[(2)]);
var state_33907__$1 = (function (){var statearr_33930 = state_33907;
(statearr_33930[(9)] = inst_33879);

return statearr_33930;
})();
if(cljs.core.truth_(offset)){
var statearr_33931_33954 = state_33907__$1;
(statearr_33931_33954[(1)] = (9));

} else {
var statearr_33932_33955 = state_33907__$1;
(statearr_33932_33955[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__10903__auto__ = null;
var fluree$db$query$fql$state_machine__10903__auto____0 = (function (){
var statearr_33933 = [null,null,null,null,null,null,null,null,null,null];
(statearr_33933[(0)] = fluree$db$query$fql$state_machine__10903__auto__);

(statearr_33933[(1)] = (1));

return statearr_33933;
});
var fluree$db$query$fql$state_machine__10903__auto____1 = (function (state_33907){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_33907);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e33934){var ex__10906__auto__ = e33934;
var statearr_33935_33956 = state_33907;
(statearr_33935_33956[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_33907[(4)]))){
var statearr_33936_33957 = state_33907;
(statearr_33936_33957[(1)] = cljs.core.first.call(null,(state_33907[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33958 = state_33907;
state_33907 = G__33958;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__10903__auto__ = function(state_33907){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__10903__auto____1.call(this,state_33907);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__10903__auto____0;
fluree$db$query$fql$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__10903__auto____1;
return fluree$db$query$fql$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_33937 = f__10977__auto__.call(null);
(statearr_33937[(6)] = c__10976__auto__);

return statearr_33937;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__33960 = arguments.length;
switch (G__33960) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.call(null,db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.call(null,db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_34046){
var state_val_34047 = (state_34046[(1)]);
if((state_val_34047 === (7))){
var inst_34041 = (state_34046[(2)]);
var _ = (function (){var statearr_34049 = state_34046;
(statearr_34049[(4)] = cljs.core.rest.call(null,(state_34046[(4)])));

return statearr_34049;
})();
var state_34046__$1 = state_34046;
var statearr_34050_34102 = state_34046__$1;
(statearr_34050_34102[(2)] = inst_34041);

(statearr_34050_34102[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34047 === (20))){
var inst_33988 = (state_34046[(7)]);
var inst_33981 = (state_34046[(8)]);
var inst_33980 = (state_34046[(9)]);
var inst_34009 = (inst_33980 + (1));
var tmp34048 = inst_33981;
var inst_33979 = inst_33988;
var inst_33980__$1 = inst_34009;
var inst_33981__$1 = tmp34048;
var state_34046__$1 = (function (){var statearr_34051 = state_34046;
(statearr_34051[(8)] = inst_33981__$1);

(statearr_34051[(9)] = inst_33980__$1);

(statearr_34051[(10)] = inst_33979);

return statearr_34051;
})();
var statearr_34052_34103 = state_34046__$1;
(statearr_34052_34103[(2)] = null);

(statearr_34052_34103[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34047 === (27))){
var inst_34019 = (state_34046[(11)]);
var inst_34021 = cljs.core.count.call(null,inst_34019);
var inst_34022 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_34021);
var state_34046__$1 = state_34046;
var statearr_34053_34104 = state_34046__$1;
(statearr_34053_34104[(2)] = inst_34022);

(statearr_34053_34104[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34047 === (1))){
var state_34046__$1 = state_34046;
var statearr_34054_34105 = state_34046__$1;
(statearr_34054_34105[(2)] = null);

(statearr_34054_34105[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34047 === (24))){
var state_34046__$1 = state_34046;
var statearr_34055_34106 = state_34046__$1;
(statearr_34055_34106[(2)] = null);

(statearr_34055_34106[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34047 === (4))){
var inst_33961 = (state_34046[(2)]);
var state_34046__$1 = state_34046;
var statearr_34056_34107 = state_34046__$1;
(statearr_34056_34107[(2)] = inst_33961);

(statearr_34056_34107[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34047 === (15))){
var inst_34002 = (state_34046[(12)]);
var inst_34002__$1 = offset;
var state_34046__$1 = (function (){var statearr_34057 = state_34046;
(statearr_34057[(12)] = inst_34002__$1);

return statearr_34057;
})();
if(cljs.core.truth_(inst_34002__$1)){
var statearr_34058_34108 = state_34046__$1;
(statearr_34058_34108[(1)] = (17));

} else {
var statearr_34059_34109 = state_34046__$1;
(statearr_34059_34109[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34047 === (21))){
var state_34046__$1 = state_34046;
var statearr_34060_34110 = state_34046__$1;
(statearr_34060_34110[(1)] = (23));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34047 === (13))){
var inst_33997 = (state_34046[(2)]);
var state_34046__$1 = state_34046;
var statearr_34062_34111 = state_34046__$1;
(statearr_34062_34111[(2)] = inst_33997);

(statearr_34062_34111[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34047 === (22))){
var inst_34037 = (state_34046[(2)]);
var state_34046__$1 = state_34046;
var statearr_34063_34112 = state_34046__$1;
(statearr_34063_34112[(2)] = inst_34037);

(statearr_34063_34112[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34047 === (29))){
var inst_33980 = (state_34046[(9)]);
var inst_34019 = (state_34046[(11)]);
var inst_34025 = (state_34046[(2)]);
var inst_34026 = (inst_33980 + (1));
var inst_34027 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,select_spec,inst_34019);
var state_34046__$1 = (function (){var statearr_34064 = state_34046;
(statearr_34064[(13)] = inst_34025);

(statearr_34064[(14)] = inst_34026);

return statearr_34064;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34046__$1,(30),inst_34027);
} else {
if((state_val_34047 === (6))){
var inst_33989 = (state_34046[(15)]);
var inst_33987 = (state_34046[(16)]);
var inst_33979 = (state_34046[(10)]);
var inst_33986 = cljs.core.seq.call(null,inst_33979);
var inst_33987__$1 = cljs.core.first.call(null,inst_33986);
var inst_33988 = cljs.core.next.call(null,inst_33986);
var inst_33989__$1 = (inst_33987__$1 == null);
var state_34046__$1 = (function (){var statearr_34065 = state_34046;
(statearr_34065[(15)] = inst_33989__$1);

(statearr_34065[(7)] = inst_33988);

(statearr_34065[(16)] = inst_33987__$1);

return statearr_34065;
})();
if(cljs.core.truth_(inst_33989__$1)){
var statearr_34066_34113 = state_34046__$1;
(statearr_34066_34113[(1)] = (8));

} else {
var statearr_34067_34114 = state_34046__$1;
(statearr_34067_34114[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34047 === (28))){
var state_34046__$1 = state_34046;
var statearr_34068_34115 = state_34046__$1;
(statearr_34068_34115[(2)] = null);

(statearr_34068_34115[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34047 === (25))){
var inst_34035 = (state_34046[(2)]);
var state_34046__$1 = state_34046;
var statearr_34069_34116 = state_34046__$1;
(statearr_34069_34116[(2)] = inst_34035);

(statearr_34069_34116[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34047 === (17))){
var inst_33980 = (state_34046[(9)]);
var inst_34004 = (inst_33980 < offset);
var state_34046__$1 = state_34046;
var statearr_34070_34117 = state_34046__$1;
(statearr_34070_34117[(2)] = inst_34004);

(statearr_34070_34117[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34047 === (3))){
var inst_34044 = (state_34046[(2)]);
var state_34046__$1 = state_34046;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34046__$1,inst_34044);
} else {
if((state_val_34047 === (12))){
var inst_33992 = (state_34046[(17)]);
var state_34046__$1 = state_34046;
var statearr_34071_34118 = state_34046__$1;
(statearr_34071_34118[(2)] = inst_33992);

(statearr_34071_34118[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34047 === (2))){
var _ = (function (){var statearr_34072 = state_34046;
(statearr_34072[(4)] = cljs.core.cons.call(null,(5),(state_34046[(4)])));

return statearr_34072;
})();
var inst_33974 = subjects;
var inst_33975 = cljs.core.seq.call(null,inst_33974);
var inst_33976 = cljs.core.first.call(null,inst_33975);
var inst_33977 = cljs.core.next.call(null,inst_33975);
var inst_33978 = cljs.core.PersistentVector.EMPTY;
var inst_33979 = inst_33974;
var inst_33980 = (0);
var inst_33981 = inst_33978;
var state_34046__$1 = (function (){var statearr_34073 = state_34046;
(statearr_34073[(8)] = inst_33981);

(statearr_34073[(9)] = inst_33980);

(statearr_34073[(18)] = inst_33976);

(statearr_34073[(19)] = inst_33977);

(statearr_34073[(10)] = inst_33979);

return statearr_34073;
})();
var statearr_34074_34119 = state_34046__$1;
(statearr_34074_34119[(2)] = null);

(statearr_34074_34119[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34047 === (23))){
var inst_33987 = (state_34046[(16)]);
var inst_34013 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34014 = [inst_33987];
var inst_34015 = (new cljs.core.PersistentVector(null,1,(5),inst_34013,inst_34014,null));
var inst_34016 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_34015);
var state_34046__$1 = state_34046;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34046__$1,(26),inst_34016);
} else {
if((state_val_34047 === (19))){
var inst_34007 = (state_34046[(2)]);
var state_34046__$1 = state_34046;
if(cljs.core.truth_(inst_34007)){
var statearr_34075_34120 = state_34046__$1;
(statearr_34075_34120[(1)] = (20));

} else {
var statearr_34076_34121 = state_34046__$1;
(statearr_34076_34121[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34047 === (11))){
var inst_33980 = (state_34046[(9)]);
var inst_33994 = (inst_33980 > limit);
var state_34046__$1 = state_34046;
var statearr_34078_34122 = state_34046__$1;
(statearr_34078_34122[(2)] = inst_33994);

(statearr_34078_34122[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34047 === (9))){
var inst_33992 = (state_34046[(17)]);
var inst_33992__$1 = limit;
var state_34046__$1 = (function (){var statearr_34079 = state_34046;
(statearr_34079[(17)] = inst_33992__$1);

return statearr_34079;
})();
if(cljs.core.truth_(inst_33992__$1)){
var statearr_34080_34123 = state_34046__$1;
(statearr_34080_34123[(1)] = (11));

} else {
var statearr_34081_34124 = state_34046__$1;
(statearr_34081_34124[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34047 === (5))){
var _ = (function (){var statearr_34082 = state_34046;
(statearr_34082[(4)] = cljs.core.rest.call(null,(state_34046[(4)])));

return statearr_34082;
})();
var state_34046__$1 = state_34046;
var ex34077 = (state_34046__$1[(2)]);
var statearr_34083_34125 = state_34046__$1;
(statearr_34083_34125[(5)] = ex34077);


if((ex34077 instanceof Error)){
var statearr_34084_34126 = state_34046__$1;
(statearr_34084_34126[(1)] = (4));

(statearr_34084_34126[(5)] = null);

} else {
throw ex34077;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34047 === (14))){
var inst_33981 = (state_34046[(8)]);
var state_34046__$1 = state_34046;
var statearr_34085_34127 = state_34046__$1;
(statearr_34085_34127[(2)] = inst_33981);

(statearr_34085_34127[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34047 === (26))){
var inst_34018 = (state_34046[(2)]);
var inst_34019 = fluree.db.util.async.throw_err.call(null,inst_34018);
var state_34046__$1 = (function (){var statearr_34086 = state_34046;
(statearr_34086[(11)] = inst_34019);

return statearr_34086;
})();
if(cljs.core.truth_(fuel)){
var statearr_34087_34128 = state_34046__$1;
(statearr_34087_34128[(1)] = (27));

} else {
var statearr_34088_34129 = state_34046__$1;
(statearr_34088_34129[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34047 === (16))){
var inst_34039 = (state_34046[(2)]);
var state_34046__$1 = state_34046;
var statearr_34089_34130 = state_34046__$1;
(statearr_34089_34130[(2)] = inst_34039);

(statearr_34089_34130[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34047 === (30))){
var inst_33988 = (state_34046[(7)]);
var inst_33981 = (state_34046[(8)]);
var inst_34026 = (state_34046[(14)]);
var inst_34029 = (state_34046[(2)]);
var inst_34030 = fluree.db.util.async.throw_err.call(null,inst_34029);
var inst_34031 = cljs.core.conj.call(null,inst_33981,inst_34030);
var inst_33979 = inst_33988;
var inst_33980 = inst_34026;
var inst_33981__$1 = inst_34031;
var state_34046__$1 = (function (){var statearr_34090 = state_34046;
(statearr_34090[(8)] = inst_33981__$1);

(statearr_34090[(9)] = inst_33980);

(statearr_34090[(10)] = inst_33979);

return statearr_34090;
})();
var statearr_34091_34131 = state_34046__$1;
(statearr_34091_34131[(2)] = null);

(statearr_34091_34131[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34047 === (10))){
var inst_33999 = (state_34046[(2)]);
var state_34046__$1 = state_34046;
if(cljs.core.truth_(inst_33999)){
var statearr_34092_34132 = state_34046__$1;
(statearr_34092_34132[(1)] = (14));

} else {
var statearr_34093_34133 = state_34046__$1;
(statearr_34093_34133[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34047 === (18))){
var inst_34002 = (state_34046[(12)]);
var state_34046__$1 = state_34046;
var statearr_34094_34134 = state_34046__$1;
(statearr_34094_34134[(2)] = inst_34002);

(statearr_34094_34134[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34047 === (8))){
var inst_33989 = (state_34046[(15)]);
var state_34046__$1 = state_34046;
var statearr_34095_34135 = state_34046__$1;
(statearr_34095_34135[(2)] = inst_33989);

(statearr_34095_34135[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__10903__auto__ = null;
var fluree$db$query$fql$state_machine__10903__auto____0 = (function (){
var statearr_34096 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34096[(0)] = fluree$db$query$fql$state_machine__10903__auto__);

(statearr_34096[(1)] = (1));

return statearr_34096;
});
var fluree$db$query$fql$state_machine__10903__auto____1 = (function (state_34046){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_34046);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e34097){var ex__10906__auto__ = e34097;
var statearr_34098_34136 = state_34046;
(statearr_34098_34136[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_34046[(4)]))){
var statearr_34099_34137 = state_34046;
(statearr_34099_34137[(1)] = cljs.core.first.call(null,(state_34046[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34138 = state_34046;
state_34046 = G__34138;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__10903__auto__ = function(state_34046){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__10903__auto____1.call(this,state_34046);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__10903__auto____0;
fluree$db$query$fql$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__10903__auto____1;
return fluree$db$query$fql$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_34100 = f__10977__auto__.call(null);
(statearr_34100[(6)] = c__10976__auto__);

return statearr_34100;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4253__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223),fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"type","type",1174270348),p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__34140 = arguments.length;
switch (G__34140) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.call(null,db,where_clause,null,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4 = (function (db,where_clause,default_collection,p__34141){
var map__34142 = p__34141;
var map__34142__$1 = cljs.core.__destructure_map.call(null,map__34142);
var limit = cljs.core.get.call(null,map__34142__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__34142__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_34406){
var state_val_34407 = (state_34406[(1)]);
if((state_val_34407 === (65))){
var inst_34369 = (state_34406[(7)]);
var inst_34369__$1 = (state_34406[(2)]);
var state_34406__$1 = (function (){var statearr_34408 = state_34406;
(statearr_34408[(7)] = inst_34369__$1);

return statearr_34408;
})();
if(cljs.core.truth_(inst_34369__$1)){
var statearr_34409_34527 = state_34406__$1;
(statearr_34409_34527[(1)] = (66));

} else {
var statearr_34410_34528 = state_34406__$1;
(statearr_34410_34528[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (70))){
var inst_34372 = (state_34406[(8)]);
var state_34406__$1 = state_34406;
var statearr_34411_34529 = state_34406__$1;
(statearr_34411_34529[(2)] = inst_34372);

(statearr_34411_34529[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (62))){
var inst_34360 = (state_34406[(2)]);
var state_34406__$1 = state_34406;
var statearr_34412_34530 = state_34406__$1;
(statearr_34412_34530[(2)] = inst_34360);

(statearr_34412_34530[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (74))){
var inst_34379 = (state_34406[(2)]);
var state_34406__$1 = state_34406;
var statearr_34413_34531 = state_34406__$1;
(statearr_34413_34531[(2)] = inst_34379);

(statearr_34413_34531[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (7))){
var inst_34155 = (state_34406[(9)]);
var state_34406__$1 = state_34406;
var statearr_34414_34532 = state_34406__$1;
(statearr_34414_34532[(2)] = inst_34155);

(statearr_34414_34532[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (59))){
var inst_34184 = (state_34406[(10)]);
var inst_34352 = cljs.core.empty_QMARK_.call(null,inst_34184);
var state_34406__$1 = state_34406;
if(inst_34352){
var statearr_34415_34533 = state_34406__$1;
(statearr_34415_34533[(1)] = (60));

} else {
var statearr_34416_34534 = state_34406__$1;
(statearr_34416_34534[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (20))){
var state_34406__$1 = state_34406;
if(cljs.core.truth_(offset)){
var statearr_34417_34535 = state_34406__$1;
(statearr_34417_34535[(1)] = (23));

} else {
var statearr_34418_34536 = state_34406__$1;
(statearr_34418_34536[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (72))){
var inst_34349 = (state_34406[(11)]);
var inst_34169 = (state_34406[(12)]);
var inst_34375 = cljs.core.count.call(null,inst_34349);
var inst_34376 = (inst_34375 > inst_34169);
var state_34406__$1 = state_34406;
var statearr_34419_34537 = state_34406__$1;
(statearr_34419_34537[(2)] = inst_34376);

(statearr_34419_34537[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (58))){
var inst_34349 = (state_34406[(11)]);
var inst_34184 = (state_34406[(10)]);
var inst_34350 = cljs.core.into.call(null,inst_34184,inst_34349);
var state_34406__$1 = state_34406;
var statearr_34420_34538 = state_34406__$1;
(statearr_34420_34538[(2)] = inst_34350);

(statearr_34420_34538[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (60))){
var inst_34349 = (state_34406[(11)]);
var inst_34184 = (state_34406[(10)]);
var inst_34354 = cljs.core.into.call(null,inst_34184,inst_34349);
var state_34406__$1 = state_34406;
var statearr_34421_34539 = state_34406__$1;
(statearr_34421_34539[(2)] = inst_34354);

(statearr_34421_34539[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (27))){
var inst_34199 = (state_34406[(13)]);
var state_34406__$1 = state_34406;
var statearr_34422_34540 = state_34406__$1;
(statearr_34422_34540[(2)] = inst_34199);

(statearr_34422_34540[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (1))){
var state_34406__$1 = state_34406;
var statearr_34423_34541 = state_34406__$1;
(statearr_34423_34541[(2)] = null);

(statearr_34423_34541[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (69))){
var inst_34169 = (state_34406[(12)]);
var state_34406__$1 = state_34406;
if(cljs.core.truth_(inst_34169)){
var statearr_34424_34542 = state_34406__$1;
(statearr_34424_34542[(1)] = (72));

} else {
var statearr_34425_34543 = state_34406__$1;
(statearr_34425_34543[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (24))){
var inst_34184 = (state_34406[(10)]);
var state_34406__$1 = state_34406;
var statearr_34426_34544 = state_34406__$1;
(statearr_34426_34544[(2)] = inst_34184);

(statearr_34426_34544[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (55))){
var inst_34338 = (state_34406[(2)]);
var state_34406__$1 = state_34406;
var statearr_34427_34545 = state_34406__$1;
(statearr_34427_34545[(2)] = inst_34338);

(statearr_34427_34545[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (39))){
var inst_34346 = (state_34406[(2)]);
var state_34406__$1 = state_34406;
var statearr_34428_34546 = state_34406__$1;
(statearr_34428_34546[(2)] = inst_34346);

(statearr_34428_34546[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (46))){
var inst_34210 = (state_34406[(14)]);
var inst_34228 = (state_34406[(15)]);
var inst_34304 = inst_34228.call(null,cljs.core._LT_,inst_34210);
var state_34406__$1 = state_34406;
if(cljs.core.truth_(inst_34304)){
var statearr_34429_34547 = state_34406__$1;
(statearr_34429_34547[(1)] = (49));

} else {
var statearr_34430_34548 = state_34406__$1;
(statearr_34430_34548[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (4))){
var inst_34143 = (state_34406[(2)]);
var state_34406__$1 = state_34406;
var statearr_34431_34549 = state_34406__$1;
(statearr_34431_34549[(2)] = inst_34143);

(statearr_34431_34549[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (77))){
var inst_34394 = (state_34406[(2)]);
var state_34406__$1 = state_34406;
var statearr_34432_34550 = state_34406__$1;
(statearr_34432_34550[(2)] = inst_34394);

(statearr_34432_34550[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (54))){
var inst_34336 = cljs.core.PersistentVector.EMPTY;
var state_34406__$1 = state_34406;
var statearr_34433_34551 = state_34406__$1;
(statearr_34433_34551[(2)] = inst_34336);

(statearr_34433_34551[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (15))){
var inst_34154 = (state_34406[(16)]);
var inst_34179 = cljs.core.seq.call(null,inst_34154);
var inst_34180 = cljs.core.first.call(null,inst_34179);
var inst_34181 = cljs.core.next.call(null,inst_34179);
var inst_34182 = cljs.core.PersistentHashSet.EMPTY;
var inst_34183 = inst_34154;
var inst_34184 = inst_34182;
var state_34406__$1 = (function (){var statearr_34434 = state_34406;
(statearr_34434[(17)] = inst_34183);

(statearr_34434[(18)] = inst_34180);

(statearr_34434[(19)] = inst_34181);

(statearr_34434[(10)] = inst_34184);

return statearr_34434;
})();
var statearr_34435_34552 = state_34406__$1;
(statearr_34435_34552[(2)] = null);

(statearr_34435_34552[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (48))){
var inst_34301 = (state_34406[(2)]);
var inst_34302 = fluree.db.util.async.throw_err.call(null,inst_34301);
var state_34406__$1 = state_34406;
var statearr_34436_34553 = state_34406__$1;
(statearr_34436_34553[(2)] = inst_34302);

(statearr_34436_34553[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (50))){
var inst_34210 = (state_34406[(14)]);
var inst_34228 = (state_34406[(15)]);
var inst_34320 = inst_34228.call(null,cljs.core._LT__EQ_,inst_34210);
var state_34406__$1 = state_34406;
if(cljs.core.truth_(inst_34320)){
var statearr_34437_34554 = state_34406__$1;
(statearr_34437_34554[(1)] = (53));

} else {
var statearr_34438_34555 = state_34406__$1;
(statearr_34438_34555[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (75))){
var state_34406__$1 = state_34406;
if(cljs.core.truth_(offset)){
var statearr_34439_34556 = state_34406__$1;
(statearr_34439_34556[(1)] = (78));

} else {
var statearr_34440_34557 = state_34406__$1;
(statearr_34440_34557[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (21))){
var inst_34190 = (state_34406[(20)]);
var inst_34209 = (state_34406[(21)]);
var inst_34209__$1 = cljs.core.nth.call(null,inst_34190,(0),null);
var inst_34210 = cljs.core.nth.call(null,inst_34190,(1),null);
var inst_34211 = cljs.core.nth.call(null,inst_34190,(2),null);
var inst_34212 = fluree.db.query.fql.valid_where_predicate_QMARK_.call(null,db,inst_34209__$1);
var inst_34213 = cljs.core.not.call(null,inst_34212);
var state_34406__$1 = (function (){var statearr_34441 = state_34406;
(statearr_34441[(14)] = inst_34210);

(statearr_34441[(22)] = inst_34211);

(statearr_34441[(21)] = inst_34209__$1);

return statearr_34441;
})();
if(inst_34213){
var statearr_34442_34558 = state_34406__$1;
(statearr_34442_34558[(1)] = (29));

} else {
var statearr_34443_34559 = state_34406__$1;
(statearr_34443_34559[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (31))){
var inst_34210 = (state_34406[(14)]);
var inst_34228 = (state_34406[(15)]);
var inst_34224 = (state_34406[(2)]);
var inst_34228__$1 = cljs.core.identical_QMARK_;
var inst_34229 = inst_34228__$1.call(null,cljs.core.not_EQ_,inst_34210);
var state_34406__$1 = (function (){var statearr_34444 = state_34406;
(statearr_34444[(23)] = inst_34224);

(statearr_34444[(15)] = inst_34228__$1);

return statearr_34444;
})();
if(cljs.core.truth_(inst_34229)){
var statearr_34445_34560 = state_34406__$1;
(statearr_34445_34560[(1)] = (32));

} else {
var statearr_34446_34561 = state_34406__$1;
(statearr_34446_34561[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (32))){
var inst_34211 = (state_34406[(22)]);
var inst_34169 = (state_34406[(12)]);
var inst_34209 = (state_34406[(21)]);
var inst_34231 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34232 = [inst_34209,inst_34211];
var inst_34233 = (new cljs.core.PersistentVector(null,2,(5),inst_34231,inst_34232,null));
var inst_34234 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34235 = [inst_34209];
var inst_34236 = (new cljs.core.PersistentVector(null,1,(5),inst_34234,inst_34235,null));
var inst_34237 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_34238 = [inst_34169];
var inst_34239 = cljs.core.PersistentHashMap.fromArrays(inst_34237,inst_34238);
var inst_34240 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_34233,cljs.core._LT__EQ_,inst_34236,inst_34239);
var state_34406__$1 = state_34406;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34406__$1,(35),inst_34240);
} else {
if((state_val_34407 === (40))){
var inst_34269 = (state_34406[(2)]);
var inst_34270 = fluree.db.util.async.throw_err.call(null,inst_34269);
var state_34406__$1 = state_34406;
var statearr_34447_34562 = state_34406__$1;
(statearr_34447_34562[(2)] = inst_34270);

(statearr_34447_34562[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (56))){
var inst_34333 = (state_34406[(2)]);
var inst_34334 = fluree.db.util.async.throw_err.call(null,inst_34333);
var state_34406__$1 = state_34406;
var statearr_34448_34563 = state_34406__$1;
(statearr_34448_34563[(2)] = inst_34334);

(statearr_34448_34563[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (33))){
var inst_34210 = (state_34406[(14)]);
var inst_34228 = (state_34406[(15)]);
var inst_34259 = inst_34228.call(null,cljs.core._EQ_,inst_34210);
var state_34406__$1 = state_34406;
if(cljs.core.truth_(inst_34259)){
var statearr_34449_34564 = state_34406__$1;
(statearr_34449_34564[(1)] = (37));

} else {
var statearr_34450_34565 = state_34406__$1;
(statearr_34450_34565[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (13))){
var state_34406__$1 = state_34406;
var statearr_34451_34566 = state_34406__$1;
(statearr_34451_34566[(2)] = limit);

(statearr_34451_34566[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (22))){
var inst_34396 = (state_34406[(2)]);
var state_34406__$1 = state_34406;
var statearr_34452_34567 = state_34406__$1;
(statearr_34452_34567[(2)] = inst_34396);

(statearr_34452_34567[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (36))){
var inst_34243 = (state_34406[(24)]);
var inst_34255 = (state_34406[(2)]);
var inst_34256 = fluree.db.util.async.throw_err.call(null,inst_34255);
var inst_34257 = cljs.core.concat.call(null,inst_34243,inst_34256);
var state_34406__$1 = state_34406;
var statearr_34453_34568 = state_34406__$1;
(statearr_34453_34568[(2)] = inst_34257);

(statearr_34453_34568[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (41))){
var inst_34211 = (state_34406[(22)]);
var inst_34169 = (state_34406[(12)]);
var inst_34209 = (state_34406[(21)]);
var inst_34274 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34275 = [inst_34209,inst_34211];
var inst_34276 = (new cljs.core.PersistentVector(null,2,(5),inst_34274,inst_34275,null));
var inst_34277 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34278 = [inst_34209];
var inst_34279 = (new cljs.core.PersistentVector(null,1,(5),inst_34277,inst_34278,null));
var inst_34280 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_34281 = [inst_34169];
var inst_34282 = cljs.core.PersistentHashMap.fromArrays(inst_34280,inst_34281);
var inst_34283 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_34276,cljs.core._LT__EQ_,inst_34279,inst_34282);
var state_34406__$1 = state_34406;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34406__$1,(44),inst_34283);
} else {
if((state_val_34407 === (43))){
var inst_34344 = (state_34406[(2)]);
var state_34406__$1 = state_34406;
var statearr_34454_34569 = state_34406__$1;
(statearr_34454_34569[(2)] = inst_34344);

(statearr_34454_34569[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (61))){
var inst_34349 = (state_34406[(11)]);
var inst_34184 = (state_34406[(10)]);
var inst_34356 = cljs.core.PersistentHashSet.EMPTY;
var inst_34357 = cljs.core.into.call(null,inst_34356,inst_34349);
var inst_34358 = clojure.set.intersection.call(null,inst_34184,inst_34357);
var state_34406__$1 = state_34406;
var statearr_34455_34570 = state_34406__$1;
(statearr_34455_34570[(2)] = inst_34358);

(statearr_34455_34570[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (29))){
var inst_34209 = (state_34406[(21)]);
var inst_34215 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_34209);
var inst_34216 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34215)].join('');
var inst_34217 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_34218 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_34219 = cljs.core.PersistentHashMap.fromArrays(inst_34217,inst_34218);
var inst_34220 = cljs.core.ex_info.call(null,inst_34216,inst_34219);
var inst_34221 = (function(){throw inst_34220})();
var state_34406__$1 = state_34406;
var statearr_34456_34571 = state_34406__$1;
(statearr_34456_34571[(2)] = inst_34221);

(statearr_34456_34571[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (44))){
var inst_34285 = (state_34406[(2)]);
var inst_34286 = fluree.db.util.async.throw_err.call(null,inst_34285);
var state_34406__$1 = state_34406;
var statearr_34457_34572 = state_34406__$1;
(statearr_34457_34572[(2)] = inst_34286);

(statearr_34457_34572[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (6))){
var inst_34153 = (state_34406[(25)]);
var inst_34157 = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"and","and",-971899817),inst_34153);
var state_34406__$1 = state_34406;
var statearr_34458_34573 = state_34406__$1;
(statearr_34458_34573[(2)] = inst_34157);

(statearr_34458_34573[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (28))){
var inst_34204 = (state_34406[(2)]);
var state_34406__$1 = state_34406;
var statearr_34459_34574 = state_34406__$1;
(statearr_34459_34574[(2)] = inst_34204);

(statearr_34459_34574[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (64))){
var inst_34364 = (state_34406[(26)]);
var state_34406__$1 = state_34406;
var statearr_34460_34575 = state_34406__$1;
(statearr_34460_34575[(2)] = inst_34364);

(statearr_34460_34575[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (51))){
var inst_34340 = (state_34406[(2)]);
var state_34406__$1 = state_34406;
var statearr_34461_34576 = state_34406__$1;
(statearr_34461_34576[(2)] = inst_34340);

(statearr_34461_34576[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (25))){
var inst_34199 = (state_34406[(2)]);
var state_34406__$1 = (function (){var statearr_34462 = state_34406;
(statearr_34462[(13)] = inst_34199);

return statearr_34462;
})();
if(cljs.core.truth_(limit)){
var statearr_34463_34577 = state_34406__$1;
(statearr_34463_34577[(1)] = (26));

} else {
var statearr_34464_34578 = state_34406__$1;
(statearr_34464_34578[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (34))){
var inst_34153 = (state_34406[(25)]);
var inst_34348 = (state_34406[(2)]);
var inst_34349 = cljs.core.map.call(null,fluree.db.query.fql.s,inst_34348);
var state_34406__$1 = (function (){var statearr_34465 = state_34406;
(statearr_34465[(11)] = inst_34349);

return statearr_34465;
})();
var G__34466_34579 = inst_34153;
var G__34466_34580__$1 = (((G__34466_34579 instanceof cljs.core.Keyword))?G__34466_34579.fqn:null);
switch (G__34466_34580__$1) {
case "or":
var statearr_34467_34582 = state_34406__$1;
(statearr_34467_34582[(1)] = (58));


break;
case "and":
var statearr_34468_34583 = state_34406__$1;
(statearr_34468_34583[(1)] = (59));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__34466_34580__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (17))){
var inst_34401 = (state_34406[(2)]);
var _ = (function (){var statearr_34469 = state_34406;
(statearr_34469[(4)] = cljs.core.rest.call(null,(state_34406[(4)])));

return statearr_34469;
})();
var state_34406__$1 = state_34406;
var statearr_34470_34584 = state_34406__$1;
(statearr_34470_34584[(2)] = inst_34401);

(statearr_34470_34584[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (3))){
var inst_34404 = (state_34406[(2)]);
var state_34406__$1 = state_34406;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34406__$1,inst_34404);
} else {
if((state_val_34407 === (12))){
var inst_34163 = (offset + limit);
var state_34406__$1 = state_34406;
var statearr_34471_34585 = state_34406__$1;
(statearr_34471_34585[(2)] = inst_34163);

(statearr_34471_34585[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (2))){
var inst_34155 = (state_34406[(9)]);
var _ = (function (){var statearr_34472 = state_34406;
(statearr_34472[(4)] = cljs.core.cons.call(null,(5),(state_34406[(4)])));

return statearr_34472;
})();
var inst_34152 = fluree.db.query.fql_parser.parse_where.call(null,db,where_clause,default_collection);
var inst_34153 = cljs.core.nth.call(null,inst_34152,(0),null);
var inst_34154 = cljs.core.nth.call(null,inst_34152,(1),null);
var inst_34155__$1 = limit;
var state_34406__$1 = (function (){var statearr_34473 = state_34406;
(statearr_34473[(9)] = inst_34155__$1);

(statearr_34473[(16)] = inst_34154);

(statearr_34473[(25)] = inst_34153);

return statearr_34473;
})();
if(cljs.core.truth_(inst_34155__$1)){
var statearr_34474_34586 = state_34406__$1;
(statearr_34474_34586[(1)] = (6));

} else {
var statearr_34475_34587 = state_34406__$1;
(statearr_34475_34587[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (66))){
var inst_34369 = (state_34406[(7)]);
var state_34406__$1 = state_34406;
var statearr_34476_34588 = state_34406__$1;
(statearr_34476_34588[(2)] = inst_34369);

(statearr_34476_34588[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (23))){
var inst_34184 = (state_34406[(10)]);
var inst_34196 = cljs.core.drop.call(null,offset,inst_34184);
var state_34406__$1 = state_34406;
var statearr_34477_34589 = state_34406__$1;
(statearr_34477_34589[(2)] = inst_34196);

(statearr_34477_34589[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (47))){
var inst_34342 = (state_34406[(2)]);
var state_34406__$1 = state_34406;
var statearr_34478_34590 = state_34406__$1;
(statearr_34478_34590[(2)] = inst_34342);

(statearr_34478_34590[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (35))){
var inst_34211 = (state_34406[(22)]);
var inst_34169 = (state_34406[(12)]);
var inst_34209 = (state_34406[(21)]);
var inst_34242 = (state_34406[(2)]);
var inst_34243 = fluree.db.util.async.throw_err.call(null,inst_34242);
var inst_34244 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34245 = [inst_34209];
var inst_34246 = (new cljs.core.PersistentVector(null,1,(5),inst_34244,inst_34245,null));
var inst_34247 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34248 = [inst_34209,inst_34211];
var inst_34249 = (new cljs.core.PersistentVector(null,2,(5),inst_34247,inst_34248,null));
var inst_34250 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_34251 = [inst_34169];
var inst_34252 = cljs.core.PersistentHashMap.fromArrays(inst_34250,inst_34251);
var inst_34253 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_34246,cljs.core._LT_,inst_34249,inst_34252);
var state_34406__$1 = (function (){var statearr_34479 = state_34406;
(statearr_34479[(24)] = inst_34243);

return statearr_34479;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34406__$1,(36),inst_34253);
} else {
if((state_val_34407 === (76))){
var inst_34191 = (state_34406[(27)]);
var inst_34363 = (state_34406[(28)]);
var inst_34183 = inst_34191;
var inst_34184 = inst_34363;
var state_34406__$1 = (function (){var statearr_34480 = state_34406;
(statearr_34480[(17)] = inst_34183);

(statearr_34480[(10)] = inst_34184);

return statearr_34480;
})();
var statearr_34481_34591 = state_34406__$1;
(statearr_34481_34591[(2)] = null);

(statearr_34481_34591[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (19))){
var inst_34398 = (state_34406[(2)]);
var state_34406__$1 = state_34406;
var statearr_34482_34592 = state_34406__$1;
(statearr_34482_34592[(2)] = inst_34398);

(statearr_34482_34592[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (57))){
var inst_34364 = (state_34406[(26)]);
var inst_34153 = (state_34406[(25)]);
var inst_34363 = (state_34406[(2)]);
var inst_34364__$1 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"and","and",-971899817),inst_34153);
var state_34406__$1 = (function (){var statearr_34483 = state_34406;
(statearr_34483[(26)] = inst_34364__$1);

(statearr_34483[(28)] = inst_34363);

return statearr_34483;
})();
if(inst_34364__$1){
var statearr_34484_34593 = state_34406__$1;
(statearr_34484_34593[(1)] = (63));

} else {
var statearr_34485_34594 = state_34406__$1;
(statearr_34485_34594[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (68))){
var inst_34384 = (state_34406[(2)]);
var state_34406__$1 = state_34406;
if(cljs.core.truth_(inst_34384)){
var statearr_34486_34595 = state_34406__$1;
(statearr_34486_34595[(1)] = (75));

} else {
var statearr_34487_34596 = state_34406__$1;
(statearr_34487_34596[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (11))){
var inst_34154 = (state_34406[(16)]);
var inst_34169 = (state_34406[(2)]);
var inst_34170 = cljs.core.not_empty.call(null,inst_34154);
var state_34406__$1 = (function (){var statearr_34489 = state_34406;
(statearr_34489[(12)] = inst_34169);

return statearr_34489;
})();
if(cljs.core.truth_(inst_34170)){
var statearr_34490_34597 = state_34406__$1;
(statearr_34490_34597[(1)] = (15));

} else {
var statearr_34491_34598 = state_34406__$1;
(statearr_34491_34598[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (9))){
var state_34406__$1 = state_34406;
if(cljs.core.truth_(offset)){
var statearr_34492_34599 = state_34406__$1;
(statearr_34492_34599[(1)] = (12));

} else {
var statearr_34493_34600 = state_34406__$1;
(statearr_34493_34600[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (5))){
var _ = (function (){var statearr_34494 = state_34406;
(statearr_34494[(4)] = cljs.core.rest.call(null,(state_34406[(4)])));

return statearr_34494;
})();
var state_34406__$1 = state_34406;
var ex34488 = (state_34406__$1[(2)]);
var statearr_34495_34601 = state_34406__$1;
(statearr_34495_34601[(5)] = ex34488);


if((ex34488 instanceof Error)){
var statearr_34496_34602 = state_34406__$1;
(statearr_34496_34602[(1)] = (4));

(statearr_34496_34602[(5)] = null);

} else {
throw ex34488;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (14))){
var inst_34166 = (state_34406[(2)]);
var state_34406__$1 = state_34406;
var statearr_34497_34603 = state_34406__$1;
(statearr_34497_34603[(2)] = inst_34166);

(statearr_34497_34603[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (45))){
var inst_34211 = (state_34406[(22)]);
var inst_34169 = (state_34406[(12)]);
var inst_34209 = (state_34406[(21)]);
var inst_34290 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34291 = [inst_34209,inst_34211];
var inst_34292 = (new cljs.core.PersistentVector(null,2,(5),inst_34290,inst_34291,null));
var inst_34293 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34294 = [inst_34209];
var inst_34295 = (new cljs.core.PersistentVector(null,1,(5),inst_34293,inst_34294,null));
var inst_34296 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_34297 = [inst_34169];
var inst_34298 = cljs.core.PersistentHashMap.fromArrays(inst_34296,inst_34297);
var inst_34299 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_34292,cljs.core._LT__EQ_,inst_34295,inst_34298);
var state_34406__$1 = state_34406;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34406__$1,(48),inst_34299);
} else {
if((state_val_34407 === (53))){
var inst_34211 = (state_34406[(22)]);
var inst_34169 = (state_34406[(12)]);
var inst_34209 = (state_34406[(21)]);
var inst_34322 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34323 = [inst_34209];
var inst_34324 = (new cljs.core.PersistentVector(null,1,(5),inst_34322,inst_34323,null));
var inst_34325 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34326 = [inst_34209,inst_34211];
var inst_34327 = (new cljs.core.PersistentVector(null,2,(5),inst_34325,inst_34326,null));
var inst_34328 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_34329 = [inst_34169];
var inst_34330 = cljs.core.PersistentHashMap.fromArrays(inst_34328,inst_34329);
var inst_34331 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_34324,cljs.core._LT__EQ_,inst_34327,inst_34330);
var state_34406__$1 = state_34406;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34406__$1,(56),inst_34331);
} else {
if((state_val_34407 === (78))){
var inst_34363 = (state_34406[(28)]);
var inst_34387 = cljs.core.drop.call(null,offset,inst_34363);
var state_34406__$1 = state_34406;
var statearr_34498_34604 = state_34406__$1;
(statearr_34498_34604[(2)] = inst_34387);

(statearr_34498_34604[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (26))){
var inst_34199 = (state_34406[(13)]);
var inst_34201 = cljs.core.take.call(null,limit,inst_34199);
var state_34406__$1 = state_34406;
var statearr_34499_34605 = state_34406__$1;
(statearr_34499_34605[(2)] = inst_34201);

(statearr_34499_34605[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (16))){
var state_34406__$1 = state_34406;
var statearr_34500_34606 = state_34406__$1;
(statearr_34500_34606[(2)] = null);

(statearr_34500_34606[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (79))){
var inst_34363 = (state_34406[(28)]);
var state_34406__$1 = state_34406;
var statearr_34501_34607 = state_34406__$1;
(statearr_34501_34607[(2)] = inst_34363);

(statearr_34501_34607[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (38))){
var inst_34210 = (state_34406[(14)]);
var inst_34228 = (state_34406[(15)]);
var inst_34272 = inst_34228.call(null,cljs.core._GT_,inst_34210);
var state_34406__$1 = state_34406;
if(cljs.core.truth_(inst_34272)){
var statearr_34502_34608 = state_34406__$1;
(statearr_34502_34608[(1)] = (41));

} else {
var statearr_34503_34609 = state_34406__$1;
(statearr_34503_34609[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (30))){
var state_34406__$1 = state_34406;
var statearr_34504_34610 = state_34406__$1;
(statearr_34504_34610[(2)] = null);

(statearr_34504_34610[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (73))){
var inst_34169 = (state_34406[(12)]);
var state_34406__$1 = state_34406;
var statearr_34505_34611 = state_34406__$1;
(statearr_34505_34611[(2)] = inst_34169);

(statearr_34505_34611[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (10))){
var state_34406__$1 = state_34406;
var statearr_34506_34612 = state_34406__$1;
(statearr_34506_34612[(2)] = null);

(statearr_34506_34612[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (18))){
var inst_34183 = (state_34406[(17)]);
var inst_34190 = (state_34406[(20)]);
var inst_34189 = cljs.core.seq.call(null,inst_34183);
var inst_34190__$1 = cljs.core.first.call(null,inst_34189);
var inst_34191 = cljs.core.next.call(null,inst_34189);
var inst_34192 = cljs.core.not.call(null,inst_34190__$1);
var state_34406__$1 = (function (){var statearr_34507 = state_34406;
(statearr_34507[(20)] = inst_34190__$1);

(statearr_34507[(27)] = inst_34191);

return statearr_34507;
})();
if(inst_34192){
var statearr_34508_34613 = state_34406__$1;
(statearr_34508_34613[(1)] = (20));

} else {
var statearr_34509_34614 = state_34406__$1;
(statearr_34509_34614[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (52))){
var inst_34317 = (state_34406[(2)]);
var inst_34318 = fluree.db.util.async.throw_err.call(null,inst_34317);
var state_34406__$1 = state_34406;
var statearr_34510_34615 = state_34406__$1;
(statearr_34510_34615[(2)] = inst_34318);

(statearr_34510_34615[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (67))){
var inst_34372 = (state_34406[(8)]);
var inst_34153 = (state_34406[(25)]);
var inst_34372__$1 = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"and","and",-971899817),inst_34153);
var state_34406__$1 = (function (){var statearr_34511 = state_34406;
(statearr_34511[(8)] = inst_34372__$1);

return statearr_34511;
})();
if(inst_34372__$1){
var statearr_34512_34616 = state_34406__$1;
(statearr_34512_34616[(1)] = (69));

} else {
var statearr_34513_34617 = state_34406__$1;
(statearr_34513_34617[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (71))){
var inst_34382 = (state_34406[(2)]);
var state_34406__$1 = state_34406;
var statearr_34514_34618 = state_34406__$1;
(statearr_34514_34618[(2)] = inst_34382);

(statearr_34514_34618[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (42))){
var inst_34210 = (state_34406[(14)]);
var inst_34228 = (state_34406[(15)]);
var inst_34288 = inst_34228.call(null,cljs.core._GT__EQ_,inst_34210);
var state_34406__$1 = state_34406;
if(cljs.core.truth_(inst_34288)){
var statearr_34515_34619 = state_34406__$1;
(statearr_34515_34619[(1)] = (45));

} else {
var statearr_34516_34620 = state_34406__$1;
(statearr_34516_34620[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (80))){
var inst_34390 = (state_34406[(2)]);
var state_34406__$1 = state_34406;
var statearr_34517_34621 = state_34406__$1;
(statearr_34517_34621[(2)] = inst_34390);

(statearr_34517_34621[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (37))){
var inst_34211 = (state_34406[(22)]);
var inst_34169 = (state_34406[(12)]);
var inst_34209 = (state_34406[(21)]);
var inst_34261 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34262 = [inst_34209,inst_34211];
var inst_34263 = (new cljs.core.PersistentVector(null,2,(5),inst_34261,inst_34262,null));
var inst_34264 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_34265 = [inst_34169];
var inst_34266 = cljs.core.PersistentHashMap.fromArrays(inst_34264,inst_34265);
var inst_34267 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_34263,inst_34266);
var state_34406__$1 = state_34406;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34406__$1,(40),inst_34267);
} else {
if((state_val_34407 === (63))){
var inst_34363 = (state_34406[(28)]);
var inst_34366 = cljs.core.empty_QMARK_.call(null,inst_34363);
var state_34406__$1 = state_34406;
var statearr_34518_34622 = state_34406__$1;
(statearr_34518_34622[(2)] = inst_34366);

(statearr_34518_34622[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (8))){
var inst_34160 = (state_34406[(2)]);
var state_34406__$1 = state_34406;
if(cljs.core.truth_(inst_34160)){
var statearr_34519_34623 = state_34406__$1;
(statearr_34519_34623[(1)] = (9));

} else {
var statearr_34520_34624 = state_34406__$1;
(statearr_34520_34624[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34407 === (49))){
var inst_34211 = (state_34406[(22)]);
var inst_34169 = (state_34406[(12)]);
var inst_34209 = (state_34406[(21)]);
var inst_34306 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34307 = [inst_34209];
var inst_34308 = (new cljs.core.PersistentVector(null,1,(5),inst_34306,inst_34307,null));
var inst_34309 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34310 = [inst_34209,inst_34211];
var inst_34311 = (new cljs.core.PersistentVector(null,2,(5),inst_34309,inst_34310,null));
var inst_34312 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_34313 = [inst_34169];
var inst_34314 = cljs.core.PersistentHashMap.fromArrays(inst_34312,inst_34313);
var inst_34315 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_34308,cljs.core._LT_,inst_34311,inst_34314);
var state_34406__$1 = state_34406;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34406__$1,(52),inst_34315);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__10903__auto__ = null;
var fluree$db$query$fql$state_machine__10903__auto____0 = (function (){
var statearr_34521 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34521[(0)] = fluree$db$query$fql$state_machine__10903__auto__);

(statearr_34521[(1)] = (1));

return statearr_34521;
});
var fluree$db$query$fql$state_machine__10903__auto____1 = (function (state_34406){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_34406);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e34522){var ex__10906__auto__ = e34522;
var statearr_34523_34625 = state_34406;
(statearr_34523_34625[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_34406[(4)]))){
var statearr_34524_34626 = state_34406;
(statearr_34524_34626[(1)] = cljs.core.first.call(null,(state_34406[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34627 = state_34406;
state_34406 = G__34627;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__10903__auto__ = function(state_34406){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__10903__auto____1.call(this,state_34406);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__10903__auto____0;
fluree$db$query$fql$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__10903__auto____1;
return fluree$db$query$fql$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_34525 = f__10977__auto__.call(null);
(statearr_34525[(6)] = c__10976__auto__);

return statearr_34525;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 4);

fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,cljs.core.keys.call(null,x))))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var var_as_symbol = cljs.core.symbol.call(null,cljs.core.first.call(null,cljs.core.keys.call(null,x)));
var ___$1 = (cljs.core.truth_(valid_var.call(null,var_as_symbol))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_as_symbol,new cljs.core.Keyword(null,"selection","selection",975998651),cljs.core.first.call(null,cljs.core.vals.call(null,x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4253__auto__ = cljs.core.every_QMARK_.call(null,(function (p1__34628_SHARP_){
return ((typeof p1__34628_SHARP_ === 'string') || (cljs.core.map_QMARK_.call(null,p1__34628_SHARP_)));
}),select_smt);
if(or__4253__auto__){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vars__$1 = cljs.core.set.call(null,vars);
var all_vars = cljs.core.set.call(null,cljs.core.concat.call(null,vars__$1,cljs.core.keys.call(null,interim_vars)));
return cljs.core.map.call(null,(function (select){
var var_symbol = ((cljs.core.map_QMARK_.call(null,select))?null:cljs.core.symbol.call(null,select));
if(cljs.core.truth_(vars__$1.call(null,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_.call(null,select))){
return fluree.db.query.analytical.parse_aggregate.call(null,select,vars__$1);
} else {
if(cljs.core.map_QMARK_.call(null,select)){
return fluree.db.query.fql.parse_map.call(null,select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.call(null,interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.get.call(null,interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.call(null,(function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies.call(null,vars);
if(cljs.core.every_QMARK_.call(null,(function (p1__34629_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__34629_SHARP_);
}),cljs.core.vals.call(null,freqs))){
return vars;
} else {
var G__34633 = vars;
var vec__34634 = G__34633;
var seq__34635 = cljs.core.seq.call(null,vec__34634);
var first__34636 = cljs.core.first.call(null,seq__34635);
var seq__34635__$1 = cljs.core.next.call(null,seq__34635);
var var$ = first__34636;
var r = seq__34635__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__34633__$1 = G__34633;
var all_vars__$1 = all_vars;
while(true){
var vec__34640 = G__34633__$1;
var seq__34641 = cljs.core.seq.call(null,vec__34640);
var first__34642 = cljs.core.first.call(null,seq__34641);
var seq__34641__$1 = cljs.core.next.call(null,seq__34641);
var var$__$1 = first__34642;
var r__$1 = seq__34641__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not.call(null,var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_(cljs.core.set.call(null,all_vars__$2).call(null,var$__$1))){
var G__34643 = r__$1;
var G__34644 = cljs.core.conj.call(null,all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,all_vars__$2))].join(''));
G__34633__$1 = G__34643;
all_vars__$1 = G__34644;
continue;
} else {
var G__34645 = r__$1;
var G__34646 = cljs.core.conj.call(null,all_vars__$2,var$__$1);
G__34633__$1 = G__34645;
all_vars__$1 = G__34646;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_34681){
var state_val_34682 = (state_34681[(1)]);
if((state_val_34682 === (1))){
var inst_34654 = functionArray;
var inst_34655 = cljs.core.seq.call(null,inst_34654);
var inst_34656 = cljs.core.first.call(null,inst_34655);
var inst_34657 = cljs.core.next.call(null,inst_34655);
var inst_34658 = cljs.core.PersistentVector.EMPTY;
var inst_34659 = inst_34654;
var inst_34660 = inst_34658;
var state_34681__$1 = (function (){var statearr_34683 = state_34681;
(statearr_34683[(7)] = inst_34659);

(statearr_34683[(8)] = inst_34657);

(statearr_34683[(9)] = inst_34660);

(statearr_34683[(10)] = inst_34656);

return statearr_34683;
})();
var statearr_34684_34697 = state_34681__$1;
(statearr_34684_34697[(2)] = null);

(statearr_34684_34697[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34682 === (2))){
var inst_34659 = (state_34681[(7)]);
var inst_34666 = (state_34681[(11)]);
var inst_34665 = cljs.core.seq.call(null,inst_34659);
var inst_34666__$1 = cljs.core.first.call(null,inst_34665);
var inst_34667 = cljs.core.next.call(null,inst_34665);
var state_34681__$1 = (function (){var statearr_34685 = state_34681;
(statearr_34685[(11)] = inst_34666__$1);

(statearr_34685[(12)] = inst_34667);

return statearr_34685;
})();
if(cljs.core.truth_(inst_34666__$1)){
var statearr_34686_34698 = state_34681__$1;
(statearr_34686_34698[(1)] = (4));

} else {
var statearr_34687_34699 = state_34681__$1;
(statearr_34687_34699[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34682 === (3))){
var inst_34679 = (state_34681[(2)]);
var state_34681__$1 = state_34681;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34681__$1,inst_34679);
} else {
if((state_val_34682 === (4))){
var inst_34666 = (state_34681[(11)]);
var inst_34669 = inst_34666.call(null,tuple);
var state_34681__$1 = state_34681;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34681__$1,(7),inst_34669);
} else {
if((state_val_34682 === (5))){
var inst_34660 = (state_34681[(9)]);
var state_34681__$1 = state_34681;
var statearr_34688_34700 = state_34681__$1;
(statearr_34688_34700[(2)] = inst_34660);

(statearr_34688_34700[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34682 === (6))){
var inst_34677 = (state_34681[(2)]);
var state_34681__$1 = state_34681;
var statearr_34689_34701 = state_34681__$1;
(statearr_34689_34701[(2)] = inst_34677);

(statearr_34689_34701[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34682 === (7))){
var inst_34660 = (state_34681[(9)]);
var inst_34667 = (state_34681[(12)]);
var inst_34671 = (state_34681[(2)]);
var inst_34672 = fluree.db.util.async.throw_err.call(null,inst_34671);
var inst_34673 = cljs.core.conj.call(null,inst_34660,inst_34672);
var inst_34659 = inst_34667;
var inst_34660__$1 = inst_34673;
var state_34681__$1 = (function (){var statearr_34690 = state_34681;
(statearr_34690[(7)] = inst_34659);

(statearr_34690[(9)] = inst_34660__$1);

return statearr_34690;
})();
var statearr_34691_34702 = state_34681__$1;
(statearr_34691_34702[(2)] = null);

(statearr_34691_34702[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__10903__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__10903__auto____0 = (function (){
var statearr_34692 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34692[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__10903__auto__);

(statearr_34692[(1)] = (1));

return statearr_34692;
});
var fluree$db$query$fql$format_tuple_$_state_machine__10903__auto____1 = (function (state_34681){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_34681);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e34693){var ex__10906__auto__ = e34693;
var statearr_34694_34703 = state_34681;
(statearr_34694_34703[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_34681[(4)]))){
var statearr_34695_34704 = state_34681;
(statearr_34695_34704[(1)] = cljs.core.first.call(null,(state_34681[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34705 = state_34681;
state_34681 = G__34705;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__10903__auto__ = function(state_34681){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__10903__auto____1.call(this,state_34681);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__10903__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__10903__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_34696 = f__10977__auto__.call(null);
(statearr_34696[(6)] = c__10976__auto__);

return statearr_34696;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,cljs.core.map.call(null,cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.call(null,(function (idx,select_item){
var temp__5753__auto__ = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5753__auto__)){
var query_map = temp__5753__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.call(null,pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__34706){
var vec__34707 = p__34706;
var tuple_index = cljs.core.nth.call(null,vec__34707,(0),null);
var query_map = cljs.core.nth.call(null,vec__34707,(1),null);
var temp__5753__auto__ = cljs.core.get.call(null,tuple_result,tuple_index);
if(cljs.core.truth_(temp__5753__auto__)){
var _id = temp__5753__auto__;
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_34721){
var state_val_34722 = (state_34721[(1)]);
if((state_val_34722 === (1))){
var inst_34710 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34711 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_34712 = [query_map,_id,query_opts];
var inst_34713 = cljs.core.PersistentHashMap.fromArrays(inst_34711,inst_34712);
var inst_34714 = fluree.db.query.fql.query.call(null,db,inst_34713);
var state_34721__$1 = (function (){var statearr_34723 = state_34721;
(statearr_34723[(7)] = inst_34710);

return statearr_34723;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34721__$1,(2),inst_34714);
} else {
if((state_val_34722 === (2))){
var inst_34710 = (state_34721[(7)]);
var inst_34716 = (state_34721[(2)]);
var inst_34717 = fluree.db.util.async.throw_err.call(null,inst_34716);
var inst_34718 = [tuple_index,inst_34717];
var inst_34719 = (new cljs.core.PersistentVector(null,2,(5),inst_34710,inst_34718,null));
var state_34721__$1 = state_34721;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34721__$1,inst_34719);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__10903__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__10903__auto____0 = (function (){
var statearr_34724 = [null,null,null,null,null,null,null,null];
(statearr_34724[(0)] = fluree$db$query$fql$expand_map_$_state_machine__10903__auto__);

(statearr_34724[(1)] = (1));

return statearr_34724;
});
var fluree$db$query$fql$expand_map_$_state_machine__10903__auto____1 = (function (state_34721){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_34721);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e34725){var ex__10906__auto__ = e34725;
var statearr_34726_34729 = state_34721;
(statearr_34726_34729[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_34721[(4)]))){
var statearr_34727_34730 = state_34721;
(statearr_34727_34730[(1)] = cljs.core.first.call(null,(state_34721[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34731 = state_34721;
state_34721 = G__34731;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__10903__auto__ = function(state_34721){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__10903__auto____1.call(this,state_34721);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__10903__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__10903__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_34728 = f__10977__auto__.call(null);
(statearr_34728[(6)] = c__10976__auto__);

return statearr_34728;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_.call(null,expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__34732 = expand_map_tuple;
var tuple_index = cljs.core.nth.call(null,vec__34732,(0),null);
var query_map_result = cljs.core.nth.call(null,vec__34732,(1),null);
return cljs.core.assoc.call(null,tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_34795){
var state_val_34796 = (state_34795[(1)]);
if((state_val_34796 === (7))){
var inst_34790 = (state_34795[(2)]);
var _ = (function (){var statearr_34797 = state_34795;
(statearr_34797[(4)] = cljs.core.rest.call(null,(state_34795[(4)])));

return statearr_34797;
})();
var state_34795__$1 = state_34795;
var statearr_34798_34889 = state_34795__$1;
(statearr_34798_34889[(2)] = inst_34790);

(statearr_34798_34889[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34796 === (20))){
var inst_34781 = (state_34795[(2)]);
var state_34795__$1 = state_34795;
var statearr_34799_34890 = state_34795__$1;
(statearr_34799_34890[(2)] = inst_34781);

(statearr_34799_34890[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34796 === (1))){
var state_34795__$1 = state_34795;
var statearr_34800_34891 = state_34795__$1;
(statearr_34800_34891[(2)] = null);

(statearr_34800_34891[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34796 === (4))){
var inst_34737 = (state_34795[(2)]);
var state_34795__$1 = state_34795;
var statearr_34801_34892 = state_34795__$1;
(statearr_34801_34892[(2)] = inst_34737);

(statearr_34801_34892[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34796 === (15))){
var inst_34757 = (state_34795[(7)]);
var inst_34766 = cljs.core.second.call(null,inst_34757);
var inst_34767 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_34766);
var inst_34768 = (inst_34767 > max_fuel);
var state_34795__$1 = state_34795;
if(cljs.core.truth_(inst_34768)){
var statearr_34802_34893 = state_34795__$1;
(statearr_34802_34893[(1)] = (18));

} else {
var statearr_34803_34894 = state_34795__$1;
(statearr_34803_34894[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34796 === (13))){
var state_34795__$1 = state_34795;
var statearr_34804_34895 = state_34795__$1;
(statearr_34804_34895[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34796 === (6))){
var inst_34745 = (state_34795[(8)]);
var state_34795__$1 = state_34795;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34795__$1,(8),inst_34745);
} else {
if((state_val_34796 === (17))){
var inst_34784 = (state_34795[(2)]);
var state_34795__$1 = state_34795;
var statearr_34806_34896 = state_34795__$1;
(statearr_34806_34896[(2)] = inst_34784);

(statearr_34806_34896[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34796 === (3))){
var inst_34793 = (state_34795[(2)]);
var state_34795__$1 = state_34795;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34795__$1,inst_34793);
} else {
if((state_val_34796 === (12))){
var inst_34757 = (state_34795[(7)]);
var inst_34746 = (state_34795[(9)]);
var inst_34763 = inst_34746.call(null);
var state_34795__$1 = (function (){var statearr_34807 = state_34795;
(statearr_34807[(10)] = inst_34763);

return statearr_34807;
})();
var statearr_34808_34897 = state_34795__$1;
(statearr_34808_34897[(2)] = inst_34757);

(statearr_34808_34897[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34796 === (2))){
var inst_34746 = (state_34795[(9)]);
var inst_34745 = (state_34795[(8)]);
var _ = (function (){var statearr_34809 = state_34795;
(statearr_34809[(4)] = cljs.core.cons.call(null,(5),(state_34795[(4)])));

return statearr_34809;
})();
var inst_34743 = fluree.db.query.fql.build_expand_map.call(null,select,pp_keys);
var inst_34744 = cljs.core.async.chan.call(null);
var inst_34745__$1 = cljs.core.async.chan.call(null);
var inst_34746__$1 = (function (){var expandMaps = inst_34743;
var queue_ch = inst_34744;
var res_ch = inst_34745__$1;
return (function (){
cljs.core.async.close_BANG_.call(null,queue_ch);

return cljs.core.async.close_BANG_.call(null,res_ch);
});
})();
var inst_34747 = cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var inst_34748 = cljs.core.volatile_BANG_.call(null,(0));
var inst_34749 = cljs.core.assoc.call(null,inst_34747,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_34748);
var inst_34750 = (function (){var expandMaps = inst_34743;
var queue_ch = inst_34744;
var res_ch = inst_34745__$1;
var stop_BANG_ = inst_34746__$1;
var opts_STAR_ = inst_34749;
return (function (tuple_res,port){
var c__10976__auto____$1 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_34842){
var state_val_34843 = (state_34842[(1)]);
if((state_val_34843 === (7))){
var state_34842__$1 = state_34842;
var statearr_34844_34898 = state_34842__$1;
(statearr_34844_34898[(2)] = tuple_res);

(statearr_34844_34898[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34843 === (1))){
var state_34842__$1 = state_34842;
var statearr_34845_34899 = state_34842__$1;
(statearr_34845_34899[(2)] = null);

(statearr_34845_34899[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34843 === (4))){
var inst_34810 = (state_34842[(2)]);
var inst_34811 = cljs.core.async.put_BANG_.call(null,port,inst_34810);
var inst_34812 = cljs.core.async.close_BANG_.call(null,port);
var state_34842__$1 = (function (){var statearr_34846 = state_34842;
(statearr_34846[(7)] = inst_34811);

return statearr_34846;
})();
var statearr_34847_34900 = state_34842__$1;
(statearr_34847_34900[(2)] = inst_34812);

(statearr_34847_34900[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34843 === (6))){
var inst_34819 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34820 = [tuple_res];
var inst_34821 = (new cljs.core.PersistentVector(null,1,(5),inst_34819,inst_34820,null));
var state_34842__$1 = state_34842;
var statearr_34848_34901 = state_34842__$1;
(statearr_34848_34901[(2)] = inst_34821);

(statearr_34848_34901[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34843 === (3))){
var inst_34840 = (state_34842[(2)]);
var state_34842__$1 = state_34842;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34842__$1,inst_34840);
} else {
if((state_val_34843 === (2))){
var ___$1 = (function (){var statearr_34850 = state_34842;
(statearr_34850[(4)] = cljs.core.cons.call(null,(5),(state_34842[(4)])));

return statearr_34850;
})();
var state_34842__$1 = state_34842;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_34851_34902 = state_34842__$1;
(statearr_34851_34902[(1)] = (6));

} else {
var statearr_34852_34903 = state_34842__$1;
(statearr_34852_34903[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34843 === (9))){
var inst_34826 = (state_34842[(8)]);
var inst_34824 = (state_34842[(9)]);
var inst_34833 = (state_34842[(2)]);
var inst_34834 = cljs.core.reduce.call(null,fluree.db.query.fql.replace_expand_maps,inst_34824,inst_34833);
var inst_34835 = inst_34826.call(null,inst_34834);
var inst_34836 = cljs.core.async.put_BANG_.call(null,port,inst_34835);
var inst_34837 = cljs.core.async.close_BANG_.call(null,port);
var ___$1 = (function (){var statearr_34853 = state_34842;
(statearr_34853[(4)] = cljs.core.rest.call(null,(state_34842[(4)])));

return statearr_34853;
})();
var state_34842__$1 = (function (){var statearr_34854 = state_34842;
(statearr_34854[(10)] = inst_34836);

return statearr_34854;
})();
var statearr_34855_34904 = state_34842__$1;
(statearr_34855_34904[(2)] = inst_34837);

(statearr_34855_34904[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34843 === (5))){
var ___$1 = (function (){var statearr_34856 = state_34842;
(statearr_34856[(4)] = cljs.core.rest.call(null,(state_34842[(4)])));

return statearr_34856;
})();
var state_34842__$1 = state_34842;
var ex34849 = (state_34842__$1[(2)]);
var statearr_34857_34905 = state_34842__$1;
(statearr_34857_34905[(5)] = ex34849);


var statearr_34858_34906 = state_34842__$1;
(statearr_34858_34906[(1)] = (4));

(statearr_34858_34906[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34843 === (8))){
var inst_34824 = (state_34842[(9)]);
var inst_34824__$1 = (state_34842[(2)]);
var inst_34825 = cljs.core.volatile_BANG_.call(null,(0));
var inst_34826 = (function (){var tuple_res_SINGLEQUOTE_ = inst_34824__$1;
var query_fuel = inst_34825;
return (function (p1__34736_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,p1__34736_SHARP_),cljs.core.deref.call(null,query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__34736_SHARP_,cljs.core.deref.call(null,query_fuel)], null);
}
});
})();
var inst_34827 = cljs.core.PersistentVector.EMPTY;
var inst_34828 = (function (){var tuple_res_SINGLEQUOTE_ = inst_34824__$1;
var query_fuel = inst_34825;
return (function (p1__34735_SHARP_){
return fluree.db.query.fql.expand_map.call(null,db,cljs.core.assoc.call(null,opts_STAR_,new cljs.core.Keyword(null,"fuel","fuel",10405485),fuel),tuple_res_SINGLEQUOTE_,p1__34735_SHARP_);
});
})();
var inst_34829 = cljs.core.keep.call(null,inst_34828,expandMaps);
var inst_34830 = cljs.core.async.merge.call(null,inst_34829);
var inst_34831 = cljs.core.async.into.call(null,inst_34827,inst_34830);
var state_34842__$1 = (function (){var statearr_34859 = state_34842;
(statearr_34859[(8)] = inst_34826);

(statearr_34859[(9)] = inst_34824__$1);

return statearr_34859;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34842__$1,(9),inst_34831);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10903__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10903__auto____0 = (function (){
var statearr_34860 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_34860[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10903__auto__);

(statearr_34860[(1)] = (1));

return statearr_34860;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10903__auto____1 = (function (state_34842){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_34842);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e34861){var ex__10906__auto__ = e34861;
var statearr_34862_34907 = state_34842;
(statearr_34862_34907[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_34842[(4)]))){
var statearr_34863_34908 = state_34842;
(statearr_34863_34908[(1)] = cljs.core.first.call(null,(state_34842[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34909 = state_34842;
state_34842 = G__34909;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10903__auto__ = function(state_34842){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10903__auto____1.call(this,state_34842);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10903__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10903__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_34864 = f__10977__auto__.call(null);
(statearr_34864[(6)] = c__10976__auto____$1);

return statearr_34864;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto____$1;
});
})();
var inst_34751 = cljs.core.async.onto_chan_BANG_.call(null,inst_34744,tuples_res);
var inst_34752 = cljs.core.async.pipeline_async.call(null,parallelism,inst_34745__$1,inst_34750,inst_34744);
var inst_34753 = cljs.core.PersistentVector.EMPTY;
var inst_34754 = inst_34753;
var state_34795__$1 = (function (){var statearr_34865 = state_34795;
(statearr_34865[(11)] = inst_34751);

(statearr_34865[(9)] = inst_34746__$1);

(statearr_34865[(12)] = inst_34752);

(statearr_34865[(8)] = inst_34745__$1);

(statearr_34865[(13)] = inst_34754);

return statearr_34865;
})();
var statearr_34866_34910 = state_34795__$1;
(statearr_34866_34910[(2)] = null);

(statearr_34866_34910[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34796 === (19))){
var inst_34757 = (state_34795[(7)]);
var inst_34754 = (state_34795[(13)]);
var inst_34777 = cljs.core.first.call(null,inst_34757);
var inst_34778 = cljs.core.conj.call(null,inst_34754,inst_34777);
var inst_34754__$1 = inst_34778;
var state_34795__$1 = (function (){var statearr_34867 = state_34795;
(statearr_34867[(13)] = inst_34754__$1);

return statearr_34867;
})();
var statearr_34868_34911 = state_34795__$1;
(statearr_34868_34911[(2)] = null);

(statearr_34868_34911[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34796 === (11))){
var inst_34788 = (state_34795[(2)]);
var state_34795__$1 = state_34795;
var statearr_34870_34912 = state_34795__$1;
(statearr_34870_34912[(2)] = inst_34788);

(statearr_34870_34912[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34796 === (9))){
var inst_34754 = (state_34795[(13)]);
var state_34795__$1 = state_34795;
var statearr_34871_34913 = state_34795__$1;
(statearr_34871_34913[(2)] = inst_34754);

(statearr_34871_34913[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34796 === (5))){
var _ = (function (){var statearr_34872 = state_34795;
(statearr_34872[(4)] = cljs.core.rest.call(null,(state_34795[(4)])));

return statearr_34872;
})();
var state_34795__$1 = state_34795;
var ex34869 = (state_34795__$1[(2)]);
var statearr_34873_34914 = state_34795__$1;
(statearr_34873_34914[(5)] = ex34869);


if((ex34869 instanceof Error)){
var statearr_34874_34915 = state_34795__$1;
(statearr_34874_34915[(1)] = (4));

(statearr_34874_34915[(5)] = null);

} else {
throw ex34869;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34796 === (14))){
var inst_34786 = (state_34795[(2)]);
var state_34795__$1 = state_34795;
var statearr_34875_34916 = state_34795__$1;
(statearr_34875_34916[(2)] = inst_34786);

(statearr_34875_34916[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34796 === (16))){
var state_34795__$1 = state_34795;
var statearr_34876_34917 = state_34795__$1;
(statearr_34876_34917[(2)] = null);

(statearr_34876_34917[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34796 === (10))){
var inst_34757 = (state_34795[(7)]);
var inst_34761 = fluree.db.util.core.exception_QMARK_.call(null,inst_34757);
var state_34795__$1 = state_34795;
if(inst_34761){
var statearr_34877_34918 = state_34795__$1;
(statearr_34877_34918[(1)] = (12));

} else {
var statearr_34878_34919 = state_34795__$1;
(statearr_34878_34919[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34796 === (18))){
var inst_34746 = (state_34795[(9)]);
var inst_34770 = inst_34746.call(null);
var inst_34771 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_34772 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_34773 = [new cljs.core.Keyword("db","insufficient-fuel","db/insufficient-fuel",344386102),(400)];
var inst_34774 = cljs.core.PersistentHashMap.fromArrays(inst_34772,inst_34773);
var inst_34775 = cljs.core.ex_info.call(null,inst_34771,inst_34774);
var state_34795__$1 = (function (){var statearr_34879 = state_34795;
(statearr_34879[(14)] = inst_34770);

return statearr_34879;
})();
var statearr_34880_34920 = state_34795__$1;
(statearr_34880_34920[(2)] = inst_34775);

(statearr_34880_34920[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34796 === (8))){
var inst_34757 = (state_34795[(7)]);
var inst_34757__$1 = (state_34795[(2)]);
var inst_34758 = (inst_34757__$1 == null);
var state_34795__$1 = (function (){var statearr_34881 = state_34795;
(statearr_34881[(7)] = inst_34757__$1);

return statearr_34881;
})();
if(cljs.core.truth_(inst_34758)){
var statearr_34882_34921 = state_34795__$1;
(statearr_34882_34921[(1)] = (9));

} else {
var statearr_34883_34922 = state_34795__$1;
(statearr_34883_34922[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10903__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10903__auto____0 = (function (){
var statearr_34884 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34884[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10903__auto__);

(statearr_34884[(1)] = (1));

return statearr_34884;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10903__auto____1 = (function (state_34795){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_34795);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e34885){var ex__10906__auto__ = e34885;
var statearr_34886_34923 = state_34795;
(statearr_34886_34923[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_34795[(4)]))){
var statearr_34887_34924 = state_34795;
(statearr_34887_34924[(1)] = cljs.core.first.call(null,(state_34795[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34925 = state_34795;
state_34795 = G__34925;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10903__auto__ = function(state_34795){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10903__auto____1.call(this,state_34795);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10903__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10903__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_34888 = f__10977__auto__.call(null);
(statearr_34888[(6)] = c__10976__auto__);

return statearr_34888;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__34926 = select;
var map__34926__$1 = cljs.core.__destructure_map.call(null,map__34926);
var as = cljs.core.get.call(null,map__34926__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var variable = cljs.core.get.call(null,map__34926__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var value = cljs.core.get.call(null,map__34926__$1,new cljs.core.Keyword(null,"value","value",305978217));
var select_val = (function (){var or__4253__auto__ = as;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx.call(null,headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly.call(null,value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.call(null,tuple,idx);
}):(cljs.core.truth_(cljs.core.get.call(null,vars,select_val))?cljs.core.constantly.call(null,cljs.core.get.call(null,vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.call(null,cljs.core.juxt,cljs.core.map.call(null,cljs.core.partial.call(null,fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__34929 = orderBy;
var order = cljs.core.nth.call(null,vec__34929,(0),null);
var var$ = cljs.core.nth.call(null,vec__34929,(1),null);
var option = cljs.core.nth.call(null,vec__34929,(2),null);
var comparator = ((cljs.core._EQ_.call(null,"DESC",order))?(function (a,b){
return cljs.core.compare.call(null,b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of.call(null,headers,cljs.core.symbol.call(null,var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.call(null,"NOCASE",clojure.string.upper_case.call(null,option))));
var keyfn = ((no_case_QMARK_)?(function (p1__34927_SHARP_){
return clojure.string.upper_case.call(null,cljs.core.nth.call(null,p1__34927_SHARP_,compare_idx));
}):(function (p1__34928_SHARP_){
return cljs.core.nth.call(null,p1__34928_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,(((no_case_QMARK_)?(4):(2)) * cljs.core.count.call(null,tuples)));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return cljs.core.sort_by.call(null,keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__34934 = arguments.length;
switch (G__34934) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__34935,p__34936,group_limit,opts){
var map__34937 = p__34935;
var map__34937__$1 = cljs.core.__destructure_map.call(null,map__34937);
var res = map__34937__$1;
var vars = cljs.core.get.call(null,map__34937__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__34938 = p__34936;
var map__34938__$1 = cljs.core.__destructure_map.call(null,map__34938);
var select_spec = map__34938__$1;
var inVector_QMARK_ = cljs.core.get.call(null,map__34938__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.call(null,map__34938__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.call(null,map__34938__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var expandMaps_QMARK_ = cljs.core.get.call(null,map__34938__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var limit = cljs.core.get.call(null,map__34938__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__34938__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.call(null,map__34938__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.call(null,map__34938__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__34938__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.call(null,map__34938__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_35075){
var state_val_35076 = (state_35075[(1)]);
if((state_val_35076 === (7))){
var inst_34945 = (state_35075[(7)]);
var state_35075__$1 = state_35075;
var statearr_35077_35179 = state_35075__$1;
(statearr_35077_35179[(2)] = inst_34945);

(statearr_35077_35179[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (59))){
var inst_35068 = (state_35075[(2)]);
var state_35075__$1 = state_35075;
var statearr_35078_35180 = state_35075__$1;
(statearr_35078_35180[(2)] = inst_35068);

(statearr_35078_35180[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (20))){
var inst_34981 = (state_35075[(8)]);
var inst_34984 = (state_35075[(9)]);
var inst_34980 = (state_35075[(2)]);
var inst_34981__$1 = cljs.core.__destructure_map.call(null,inst_34980);
var inst_34982 = cljs.core.get.call(null,inst_34981__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_34983 = cljs.core.get.call(null,inst_34981__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_34984__$1 = offset;
var state_35075__$1 = (function (){var statearr_35079 = state_35075;
(statearr_35079[(10)] = inst_34983);

(statearr_35079[(8)] = inst_34981__$1);

(statearr_35079[(11)] = inst_34982);

(statearr_35079[(9)] = inst_34984__$1);

return statearr_35079;
})();
if(cljs.core.truth_(inst_34984__$1)){
var statearr_35080_35181 = state_35075__$1;
(statearr_35080_35181[(1)] = (21));

} else {
var statearr_35081_35182 = state_35075__$1;
(statearr_35081_35182[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (58))){
var inst_35060 = (state_35075[(12)]);
var state_35075__$1 = state_35075;
var statearr_35082_35183 = state_35075__$1;
(statearr_35082_35183[(2)] = inst_35060);

(statearr_35082_35183[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (60))){
var inst_35064 = (state_35075[(2)]);
var inst_35065 = fluree.db.util.async.throw_err.call(null,inst_35064);
var state_35075__$1 = state_35075;
var statearr_35083_35184 = state_35075__$1;
(statearr_35083_35184[(2)] = inst_35065);

(statearr_35083_35184[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (27))){
var inst_34996 = cljs.core.not.call(null,inVector_QMARK_);
var state_35075__$1 = state_35075;
var statearr_35084_35185 = state_35075__$1;
(statearr_35084_35185[(2)] = inst_34996);

(statearr_35084_35185[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (1))){
var state_35075__$1 = state_35075;
var statearr_35085_35186 = state_35075__$1;
(statearr_35085_35186[(2)] = null);

(statearr_35085_35186[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (24))){
var state_35075__$1 = state_35075;
var statearr_35086_35187 = state_35075__$1;
(statearr_35086_35187[(2)] = offset);

(statearr_35086_35187[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (55))){
var inst_35054 = (state_35075[(13)]);
var state_35075__$1 = state_35075;
var statearr_35087_35188 = state_35075__$1;
(statearr_35087_35188[(2)] = inst_35054);

(statearr_35087_35188[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (39))){
var inst_35022 = (state_35075[(14)]);
var inst_35024 = cljs.core.distinct.call(null);
var inst_35025 = cljs.core.conj.call(null,inst_35022,inst_35024);
var state_35075__$1 = state_35075;
var statearr_35088_35189 = state_35075__$1;
(statearr_35088_35189[(2)] = inst_35025);

(statearr_35088_35189[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (46))){
var inst_35034 = (state_35075[(15)]);
var state_35075__$1 = state_35075;
var statearr_35089_35190 = state_35075__$1;
(statearr_35089_35190[(2)] = inst_35034);

(statearr_35089_35190[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (4))){
var inst_34939 = (state_35075[(2)]);
var state_35075__$1 = state_35075;
var statearr_35090_35191 = state_35075__$1;
(statearr_35090_35191[(2)] = inst_34939);

(statearr_35090_35191[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (54))){
var inst_35054 = (state_35075[(13)]);
var inst_35048 = (state_35075[(16)]);
var inst_35056 = cljs.core.PersistentVector.EMPTY;
var inst_35057 = cljs.core.into.call(null,inst_35056,inst_35048,inst_35054);
var state_35075__$1 = state_35075;
var statearr_35091_35192 = state_35075__$1;
(statearr_35091_35192[(2)] = inst_35057);

(statearr_35091_35192[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (15))){
var inst_34966 = (state_35075[(17)]);
var inst_34968 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34969 = [inst_34966];
var inst_34970 = (new cljs.core.PersistentVector(null,1,(5),inst_34968,inst_34969,null));
var state_35075__$1 = state_35075;
var statearr_35092_35193 = state_35075__$1;
(statearr_35092_35193[(2)] = inst_34970);

(statearr_35092_35193[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (48))){
var inst_35004 = (state_35075[(18)]);
var inst_34999 = (state_35075[(19)]);
var inst_34983 = (state_35075[(10)]);
var inst_34993 = (state_35075[(20)]);
var inst_35040 = (state_35075[(21)]);
var inst_34981 = (state_35075[(8)]);
var inst_34982 = (state_35075[(11)]);
var inst_35042 = (function (){var map__34975 = inst_34981;
var headers = inst_34982;
var tuples = inst_34983;
var offset_SINGLEQUOTE_ = inst_34993;
var single_result_QMARK_ = inst_34999;
var pp_keys = inst_35004;
var G__35005 = inst_35040;
return (function (p1__34932_SHARP_){
return cljs.core.zipmap.call(null,fluree.db.query.fql.get_pretty_print_keys.call(null,select),p1__34932_SHARP_);
});
})();
var inst_35043 = cljs.core.map.call(null,inst_35042);
var inst_35044 = cljs.core.conj.call(null,inst_35040,inst_35043);
var state_35075__$1 = state_35075;
var statearr_35093_35194 = state_35075__$1;
(statearr_35093_35194[(2)] = inst_35044);

(statearr_35093_35194[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (50))){
var inst_35047 = (state_35075[(2)]);
var inst_35048 = cljs.core.apply.call(null,cljs.core.comp,inst_35047);
var state_35075__$1 = (function (){var statearr_35094 = state_35075;
(statearr_35094[(16)] = inst_35048);

return statearr_35094;
})();
if(cljs.core.truth_(orderBy)){
var statearr_35095_35195 = state_35075__$1;
(statearr_35095_35195[(1)] = (51));

} else {
var statearr_35096_35196 = state_35075__$1;
(statearr_35096_35196[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (21))){
var inst_34986 = cljs.core.not.call(null,groupBy);
var state_35075__$1 = state_35075;
var statearr_35097_35197 = state_35075__$1;
(statearr_35097_35197[(2)] = inst_34986);

(statearr_35097_35197[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (31))){
var state_35075__$1 = state_35075;
var statearr_35098_35198 = state_35075__$1;
(statearr_35098_35198[(2)] = null);

(statearr_35098_35198[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (32))){
var inst_34999 = (state_35075[(19)]);
var inst_34982 = (state_35075[(11)]);
var inst_35004 = (state_35075[(2)]);
var inst_35006 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35007 = fluree.db.query.fql.select_tuples_fn.call(null,inst_34982,vars,select);
var inst_35008 = cljs.core.map.call(null,inst_35007);
var inst_35009 = [inst_35008];
var inst_35010 = (new cljs.core.PersistentVector(null,1,(5),inst_35006,inst_35009,null));
var state_35075__$1 = (function (){var statearr_35099 = state_35075;
(statearr_35099[(18)] = inst_35004);

(statearr_35099[(22)] = inst_35010);

return statearr_35099;
})();
if(cljs.core.truth_(inst_34999)){
var statearr_35100_35199 = state_35075__$1;
(statearr_35100_35199[(1)] = (33));

} else {
var statearr_35101_35200 = state_35075__$1;
(statearr_35101_35200[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (40))){
var inst_35022 = (state_35075[(14)]);
var state_35075__$1 = state_35075;
var statearr_35102_35201 = state_35075__$1;
(statearr_35102_35201[(2)] = inst_35022);

(statearr_35102_35201[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (56))){
var inst_35060 = (state_35075[(2)]);
var state_35075__$1 = (function (){var statearr_35103 = state_35075;
(statearr_35103[(12)] = inst_35060);

return statearr_35103;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_35104_35202 = state_35075__$1;
(statearr_35104_35202[(1)] = (57));

} else {
var statearr_35105_35203 = state_35075__$1;
(statearr_35105_35203[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (33))){
var inst_35010 = (state_35075[(22)]);
var inst_35012 = cljs.core.map.call(null,cljs.core.first);
var inst_35013 = cljs.core.conj.call(null,inst_35010,inst_35012);
var state_35075__$1 = state_35075;
var statearr_35106_35204 = state_35075__$1;
(statearr_35106_35204[(2)] = inst_35013);

(statearr_35106_35204[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (13))){
var inst_34955 = (state_35075[(23)]);
var state_35075__$1 = state_35075;
var statearr_35107_35205 = state_35075__$1;
(statearr_35107_35205[(2)] = inst_34955);

(statearr_35107_35205[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (22))){
var inst_34984 = (state_35075[(9)]);
var state_35075__$1 = state_35075;
var statearr_35108_35206 = state_35075__$1;
(statearr_35108_35206[(2)] = inst_34984);

(statearr_35108_35206[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (36))){
var inst_35016 = (state_35075[(24)]);
var inst_35018 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel,(5));
var inst_35019 = cljs.core.conj.call(null,inst_35016,inst_35018);
var state_35075__$1 = state_35075;
var statearr_35109_35207 = state_35075__$1;
(statearr_35109_35207[(2)] = inst_35019);

(statearr_35109_35207[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (41))){
var inst_34993 = (state_35075[(20)]);
var inst_35028 = (state_35075[(2)]);
var state_35075__$1 = (function (){var statearr_35110 = state_35075;
(statearr_35110[(25)] = inst_35028);

return statearr_35110;
})();
if(cljs.core.truth_(inst_34993)){
var statearr_35111_35208 = state_35075__$1;
(statearr_35111_35208[(1)] = (42));

} else {
var statearr_35112_35209 = state_35075__$1;
(statearr_35112_35209[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (43))){
var inst_35028 = (state_35075[(25)]);
var state_35075__$1 = state_35075;
var statearr_35113_35210 = state_35075__$1;
(statearr_35113_35210[(2)] = inst_35028);

(statearr_35113_35210[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (29))){
var inst_34999 = (state_35075[(2)]);
var state_35075__$1 = (function (){var statearr_35114 = state_35075;
(statearr_35114[(19)] = inst_34999);

return statearr_35114;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_35115_35211 = state_35075__$1;
(statearr_35115_35211[(1)] = (30));

} else {
var statearr_35116_35212 = state_35075__$1;
(statearr_35116_35212[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (44))){
var inst_35034 = (state_35075[(2)]);
var state_35075__$1 = (function (){var statearr_35117 = state_35075;
(statearr_35117[(15)] = inst_35034);

return statearr_35117;
})();
if(cljs.core.truth_(group_limit)){
var statearr_35118_35213 = state_35075__$1;
(statearr_35118_35213[(1)] = (45));

} else {
var statearr_35119_35214 = state_35075__$1;
(statearr_35119_35214[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (6))){
var inst_34947 = cljs.core.count.call(null,select);
var inst_34948 = cljs.core._EQ_.call(null,(1),inst_34947);
var state_35075__$1 = state_35075;
var statearr_35120_35215 = state_35075__$1;
(statearr_35120_35215[(2)] = inst_34948);

(statearr_35120_35215[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (28))){
var inst_34994 = (state_35075[(26)]);
var state_35075__$1 = state_35075;
var statearr_35121_35216 = state_35075__$1;
(statearr_35121_35216[(2)] = inst_34994);

(statearr_35121_35216[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (51))){
var inst_34983 = (state_35075[(10)]);
var inst_34982 = (state_35075[(11)]);
var inst_35051 = fluree.db.query.fql.order_result_tuples.call(null,fuel,max_fuel,inst_34982,orderBy,inst_34983);
var state_35075__$1 = state_35075;
var statearr_35122_35217 = state_35075__$1;
(statearr_35122_35217[(2)] = inst_35051);

(statearr_35122_35217[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (25))){
var state_35075__$1 = state_35075;
var statearr_35123_35218 = state_35075__$1;
(statearr_35123_35218[(2)] = null);

(statearr_35123_35218[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (34))){
var inst_35010 = (state_35075[(22)]);
var state_35075__$1 = state_35075;
var statearr_35124_35219 = state_35075__$1;
(statearr_35124_35219[(2)] = inst_35010);

(statearr_35124_35219[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (17))){
var inst_34973 = (state_35075[(2)]);
var state_35075__$1 = state_35075;
var statearr_35125_35220 = state_35075__$1;
(statearr_35125_35220[(2)] = inst_34973);

(statearr_35125_35220[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (3))){
var inst_35073 = (state_35075[(2)]);
var state_35075__$1 = state_35075;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35075__$1,inst_35073);
} else {
if((state_val_35076 === (12))){
var inst_34955 = (state_35075[(23)]);
var inst_34957 = cljs.core.first.call(null,select);
var inst_34958 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_34957);
var inst_34959 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34958);
var inst_34960 = cljs.core.subs.call(null,inst_34959,(1));
var inst_34961 = [inst_34960];
var inst_34962 = [inst_34955];
var inst_34963 = cljs.core.PersistentHashMap.fromArrays(inst_34961,inst_34962);
var state_35075__$1 = state_35075;
var statearr_35126_35221 = state_35075__$1;
(statearr_35126_35221[(2)] = inst_34963);

(statearr_35126_35221[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (2))){
var inst_34945 = (state_35075[(7)]);
var _ = (function (){var statearr_35127 = state_35075;
(statearr_35127[(4)] = cljs.core.cons.call(null,(5),(state_35075[(4)])));

return statearr_35127;
})();
var inst_34945__$1 = aggregates;
var state_35075__$1 = (function (){var statearr_35128 = state_35075;
(statearr_35128[(7)] = inst_34945__$1);

return statearr_35128;
})();
if(cljs.core.truth_(inst_34945__$1)){
var statearr_35129_35222 = state_35075__$1;
(statearr_35129_35222[(1)] = (6));

} else {
var statearr_35130_35223 = state_35075__$1;
(statearr_35130_35223[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (23))){
var inst_34989 = (state_35075[(2)]);
var state_35075__$1 = state_35075;
if(cljs.core.truth_(inst_34989)){
var statearr_35131_35224 = state_35075__$1;
(statearr_35131_35224[(1)] = (24));

} else {
var statearr_35132_35225 = state_35075__$1;
(statearr_35132_35225[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (47))){
var inst_35040 = (state_35075[(2)]);
var state_35075__$1 = (function (){var statearr_35133 = state_35075;
(statearr_35133[(21)] = inst_35040);

return statearr_35133;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_35134_35226 = state_35075__$1;
(statearr_35134_35226[(1)] = (48));

} else {
var statearr_35135_35227 = state_35075__$1;
(statearr_35135_35227[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (35))){
var inst_35016 = (state_35075[(2)]);
var state_35075__$1 = (function (){var statearr_35136 = state_35075;
(statearr_35136[(24)] = inst_35016);

return statearr_35136;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_35137_35228 = state_35075__$1;
(statearr_35137_35228[(1)] = (36));

} else {
var statearr_35138_35229 = state_35075__$1;
(statearr_35138_35229[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (19))){
var state_35075__$1 = state_35075;
var statearr_35139_35230 = state_35075__$1;
(statearr_35139_35230[(2)] = res);

(statearr_35139_35230[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (57))){
var inst_35004 = (state_35075[(18)]);
var inst_34999 = (state_35075[(19)]);
var inst_35060 = (state_35075[(12)]);
var inst_35062 = fluree.db.query.fql.pipeline_expandmaps_result.call(null,select,inst_35004,inst_34999,db,fuel,max_fuel,opts,(8),inst_35060);
var state_35075__$1 = state_35075;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35075__$1,(60),inst_35062);
} else {
if((state_val_35076 === (11))){
var inst_35070 = (state_35075[(2)]);
var _ = (function (){var statearr_35141 = state_35075;
(statearr_35141[(4)] = cljs.core.rest.call(null,(state_35075[(4)])));

return statearr_35141;
})();
var state_35075__$1 = state_35075;
var statearr_35142_35231 = state_35075__$1;
(statearr_35142_35231[(2)] = inst_35070);

(statearr_35142_35231[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (9))){
var inst_34953 = cljs.core.first.call(null,aggregates);
var inst_34954 = fluree.db.query.analytical.calculate_aggregate.call(null,res,inst_34953);
var inst_34955 = cljs.core.second.call(null,inst_34954);
var state_35075__$1 = (function (){var statearr_35143 = state_35075;
(statearr_35143[(23)] = inst_34955);

return statearr_35143;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_35144_35232 = state_35075__$1;
(statearr_35144_35232[(1)] = (12));

} else {
var statearr_35145_35233 = state_35075__$1;
(statearr_35145_35233[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (5))){
var _ = (function (){var statearr_35146 = state_35075;
(statearr_35146[(4)] = cljs.core.rest.call(null,(state_35075[(4)])));

return statearr_35146;
})();
var state_35075__$1 = state_35075;
var ex35140 = (state_35075__$1[(2)]);
var statearr_35147_35234 = state_35075__$1;
(statearr_35147_35234[(5)] = ex35140);


if((ex35140 instanceof Error)){
var statearr_35148_35235 = state_35075__$1;
(statearr_35148_35235[(1)] = (4));

(statearr_35148_35235[(5)] = null);

} else {
throw ex35140;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (14))){
var inst_34966 = (state_35075[(2)]);
var state_35075__$1 = (function (){var statearr_35149 = state_35075;
(statearr_35149[(17)] = inst_34966);

return statearr_35149;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_35150_35236 = state_35075__$1;
(statearr_35150_35236[(1)] = (15));

} else {
var statearr_35151_35237 = state_35075__$1;
(statearr_35151_35237[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (45))){
var inst_35034 = (state_35075[(15)]);
var inst_35036 = cljs.core.take.call(null,group_limit);
var inst_35037 = cljs.core.conj.call(null,inst_35034,inst_35036);
var state_35075__$1 = state_35075;
var statearr_35152_35238 = state_35075__$1;
(statearr_35152_35238[(2)] = inst_35037);

(statearr_35152_35238[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (53))){
var inst_35054 = (state_35075[(2)]);
var state_35075__$1 = (function (){var statearr_35153 = state_35075;
(statearr_35153[(13)] = inst_35054);

return statearr_35153;
})();
var statearr_35154_35239 = state_35075__$1;
(statearr_35154_35239[(1)] = (54));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (26))){
var inst_34994 = (state_35075[(26)]);
var inst_34993 = (state_35075[(2)]);
var inst_34994__$1 = cljs.core.not.call(null,prettyPrint);
var state_35075__$1 = (function (){var statearr_35156 = state_35075;
(statearr_35156[(20)] = inst_34993);

(statearr_35156[(26)] = inst_34994__$1);

return statearr_35156;
})();
if(inst_34994__$1){
var statearr_35157_35240 = state_35075__$1;
(statearr_35157_35240[(1)] = (27));

} else {
var statearr_35158_35241 = state_35075__$1;
(statearr_35158_35241[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (16))){
var inst_34966 = (state_35075[(17)]);
var state_35075__$1 = state_35075;
var statearr_35159_35242 = state_35075__$1;
(statearr_35159_35242[(2)] = inst_34966);

(statearr_35159_35242[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (38))){
var inst_35022 = (state_35075[(2)]);
var state_35075__$1 = (function (){var statearr_35160 = state_35075;
(statearr_35160[(14)] = inst_35022);

return statearr_35160;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_35161_35243 = state_35075__$1;
(statearr_35161_35243[(1)] = (39));

} else {
var statearr_35162_35244 = state_35075__$1;
(statearr_35162_35244[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (30))){
var inst_35001 = fluree.db.query.fql.get_pretty_print_keys.call(null,select);
var state_35075__$1 = state_35075;
var statearr_35163_35245 = state_35075__$1;
(statearr_35163_35245[(2)] = inst_35001);

(statearr_35163_35245[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (10))){
var state_35075__$1 = state_35075;
if(cljs.core.truth_(aggregates)){
var statearr_35164_35246 = state_35075__$1;
(statearr_35164_35246[(1)] = (18));

} else {
var statearr_35165_35247 = state_35075__$1;
(statearr_35165_35247[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (18))){
var inst_34977 = fluree.db.query.analytical.add_aggregate_cols.call(null,res,aggregates);
var state_35075__$1 = state_35075;
var statearr_35166_35248 = state_35075__$1;
(statearr_35166_35248[(2)] = inst_34977);

(statearr_35166_35248[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (52))){
var inst_34983 = (state_35075[(10)]);
var state_35075__$1 = state_35075;
var statearr_35167_35249 = state_35075__$1;
(statearr_35167_35249[(2)] = inst_34983);

(statearr_35167_35249[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (42))){
var inst_34993 = (state_35075[(20)]);
var inst_35028 = (state_35075[(25)]);
var inst_35030 = cljs.core.drop.call(null,inst_34993);
var inst_35031 = cljs.core.conj.call(null,inst_35028,inst_35030);
var state_35075__$1 = state_35075;
var statearr_35168_35250 = state_35075__$1;
(statearr_35168_35250[(2)] = inst_35031);

(statearr_35168_35250[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (37))){
var inst_35016 = (state_35075[(24)]);
var state_35075__$1 = state_35075;
var statearr_35169_35251 = state_35075__$1;
(statearr_35169_35251[(2)] = inst_35016);

(statearr_35169_35251[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (8))){
var inst_34951 = (state_35075[(2)]);
var state_35075__$1 = state_35075;
if(cljs.core.truth_(inst_34951)){
var statearr_35170_35252 = state_35075__$1;
(statearr_35170_35252[(1)] = (9));

} else {
var statearr_35171_35253 = state_35075__$1;
(statearr_35171_35253[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35076 === (49))){
var inst_35040 = (state_35075[(21)]);
var state_35075__$1 = state_35075;
var statearr_35172_35254 = state_35075__$1;
(statearr_35172_35254[(2)] = inst_35040);

(statearr_35172_35254[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__10903__auto__ = null;
var fluree$db$query$fql$state_machine__10903__auto____0 = (function (){
var statearr_35173 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35173[(0)] = fluree$db$query$fql$state_machine__10903__auto__);

(statearr_35173[(1)] = (1));

return statearr_35173;
});
var fluree$db$query$fql$state_machine__10903__auto____1 = (function (state_35075){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_35075);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e35174){var ex__10906__auto__ = e35174;
var statearr_35175_35255 = state_35075;
(statearr_35175_35255[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_35075[(4)]))){
var statearr_35176_35256 = state_35075;
(statearr_35176_35256[(1)] = cljs.core.first.call(null,(state_35075[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35257 = state_35075;
state_35075 = G__35257;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__10903__auto__ = function(state_35075){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__10903__auto____1.call(this,state_35075);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__10903__auto____0;
fluree$db$query$fql$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__10903__auto____1;
return fluree$db$query$fql$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_35177 = f__10977__auto__.call(null);
(statearr_35177[(6)] = c__10976__auto__);

return statearr_35177;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__35260,groupBy){
var map__35261 = p__35260;
var map__35261__$1 = cljs.core.__destructure_map.call(null,map__35261);
var res = map__35261__$1;
var headers = cljs.core.get.call(null,map__35261__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__35261__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__35262 = ((cljs.core.vector_QMARK_.call(null,groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.call(null,cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,groupBy)], null)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.call(null,vec__35262,(0),null);
var groupBy__$1 = cljs.core.nth.call(null,vec__35262,(1),null);
var group_idxs = cljs.core.map.call(null,(function (p1__35258_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__35258_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some.call(null,cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.call(null,(function (res__$1,tuple){
var k = cljs.core.map.call(null,(function (p1__35259_SHARP_){
return cljs.core.nth.call(null,tuple,p1__35259_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,k):cljs.core.first.call(null,k));
var v = tuple;
return cljs.core.assoc.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.conj.call(null,cljs.core.get.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__35265 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.call(null,vec__35265,(0),null);
var sortCriteria = cljs.core.nth.call(null,vec__35265,(1),null);
if(cljs.core._EQ_.call(null,sortCriteria,groupBy)){
if(cljs.core._EQ_.call(null,sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_.call(null,groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of.call(null,groupBy,sortCriteria);
if(cljs.core._EQ_.call(null,"DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__35268,p__35269,opts){
var map__35270 = p__35268;
var map__35270__$1 = cljs.core.__destructure_map.call(null,map__35270);
var res = map__35270__$1;
var headers = cljs.core.get.call(null,map__35270__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__35270__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__35271 = p__35269;
var map__35271__$1 = cljs.core.__destructure_map.call(null,map__35271);
var select_spec = map__35271__$1;
var groupBy = cljs.core.get.call(null,map__35271__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.call(null,map__35271__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.call(null,map__35271__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.call(null,map__35271__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__35271__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.call(null,map__35271__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.call(null,map__35271__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_35513){
var state_val_35514 = (state_35513[(1)]);
if((state_val_35514 === (65))){
var state_35513__$1 = state_35513;
var statearr_35515_35666 = state_35513__$1;
(statearr_35515_35666[(1)] = (67));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (70))){
var inst_35434 = (state_35513[(7)]);
var state_35513__$1 = state_35513;
var statearr_35517_35667 = state_35513__$1;
(statearr_35517_35667[(2)] = inst_35434);

(statearr_35517_35667[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (62))){
var state_35513__$1 = state_35513;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_35518_35668 = state_35513__$1;
(statearr_35518_35668[(1)] = (64));

} else {
var statearr_35519_35669 = state_35513__$1;
(statearr_35519_35669[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (74))){
var inst_35350 = (state_35513[(8)]);
var inst_35341 = (state_35513[(9)]);
var inst_35409 = (state_35513[(10)]);
var inst_35442 = cljs.core.assoc.call(null,inst_35341,inst_35350,inst_35409);
var state_35513__$1 = state_35513;
var statearr_35520_35670 = state_35513__$1;
(statearr_35520_35670[(2)] = inst_35442);

(statearr_35520_35670[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (7))){
var state_35513__$1 = state_35513;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_35521_35671 = state_35513__$1;
(statearr_35521_35671[(1)] = (82));

} else {
var statearr_35522_35672 = state_35513__$1;
(statearr_35522_35672[(1)] = (83));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (59))){
var inst_35409 = (state_35513[(10)]);
var inst_35339 = (state_35513[(11)]);
var inst_35413 = cljs.core.count.call(null,inst_35409);
var inst_35414 = (inst_35339 - inst_35413);
var state_35513__$1 = state_35513;
var statearr_35523_35673 = state_35513__$1;
(statearr_35523_35673[(2)] = inst_35414);

(statearr_35523_35673[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (86))){
var state_35513__$1 = state_35513;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_35524_35674 = state_35513__$1;
(statearr_35524_35674[(1)] = (89));

} else {
var statearr_35525_35675 = state_35513__$1;
(statearr_35525_35675[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (20))){
var state_35513__$1 = state_35513;
var statearr_35526_35676 = state_35513__$1;
(statearr_35526_35676[(2)] = (0));

(statearr_35526_35676[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (72))){
var inst_35439 = (state_35513[(2)]);
var state_35513__$1 = state_35513;
if(cljs.core.truth_(inst_35439)){
var statearr_35527_35677 = state_35513__$1;
(statearr_35527_35677[(1)] = (73));

} else {
var statearr_35528_35678 = state_35513__$1;
(statearr_35528_35678[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (58))){
var state_35513__$1 = state_35513;
var statearr_35529_35679 = state_35513__$1;
(statearr_35529_35679[(2)] = null);

(statearr_35529_35679[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (60))){
var inst_35340 = (state_35513[(12)]);
var inst_35416 = (state_35513[(2)]);
var inst_35417 = (inst_35340 <= (0));
var state_35513__$1 = (function (){var statearr_35530 = state_35513;
(statearr_35530[(13)] = inst_35416);

return statearr_35530;
})();
if(cljs.core.truth_(inst_35417)){
var statearr_35531_35680 = state_35513__$1;
(statearr_35531_35680[(1)] = (61));

} else {
var statearr_35532_35681 = state_35513__$1;
(statearr_35532_35681[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (27))){
var inst_35339 = (state_35513[(11)]);
var inst_35363 = (inst_35339 < (1));
var state_35513__$1 = state_35513;
var statearr_35533_35682 = state_35513__$1;
(statearr_35533_35682[(2)] = inst_35363);

(statearr_35533_35682[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (1))){
var state_35513__$1 = state_35513;
var statearr_35534_35683 = state_35513__$1;
(statearr_35534_35683[(2)] = null);

(statearr_35534_35683[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (69))){
var inst_35429 = (state_35513[(2)]);
var state_35513__$1 = state_35513;
var statearr_35535_35684 = state_35513__$1;
(statearr_35535_35684[(2)] = inst_35429);

(statearr_35535_35684[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (24))){
var inst_35341 = (state_35513[(9)]);
var state_35513__$1 = state_35513;
var statearr_35536_35685 = state_35513__$1;
(statearr_35536_35685[(2)] = inst_35341);

(statearr_35536_35685[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (55))){
var inst_35399 = (state_35513[(14)]);
var inst_35339 = (state_35513[(11)]);
var inst_35406 = cljs.core.take.call(null,inst_35339,inst_35399);
var state_35513__$1 = state_35513;
var statearr_35537_35686 = state_35513__$1;
(statearr_35537_35686[(2)] = inst_35406);

(statearr_35537_35686[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (85))){
var inst_35484 = (state_35513[(15)]);
var inst_35483 = (state_35513[(2)]);
var inst_35484__$1 = fluree.db.util.async.throw_err.call(null,inst_35483);
var inst_35485 = cljs.core.coll_QMARK_.call(null,inst_35484__$1);
var inst_35486 = (!(inst_35485));
var state_35513__$1 = (function (){var statearr_35538 = state_35513;
(statearr_35538[(15)] = inst_35484__$1);

return statearr_35538;
})();
if(inst_35486){
var statearr_35539_35687 = state_35513__$1;
(statearr_35539_35687[(1)] = (86));

} else {
var statearr_35540_35688 = state_35513__$1;
(statearr_35540_35688[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (39))){
var inst_35358 = (state_35513[(16)]);
var inst_35380 = cljs.core.assoc.call(null,select_spec,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),null,new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null);
var inst_35381 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null);
var inst_35382 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,inst_35358,inst_35380,inst_35381);
var state_35513__$1 = state_35513;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35513__$1,(42),inst_35382);
} else {
if((state_val_35514 === (88))){
var inst_35506 = (state_35513[(2)]);
var state_35513__$1 = state_35513;
var statearr_35541_35689 = state_35513__$1;
(statearr_35541_35689[(2)] = inst_35506);

(statearr_35541_35689[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (46))){
var inst_35340 = (state_35513[(12)]);
var inst_35394 = ((0) < inst_35340);
var state_35513__$1 = state_35513;
if(cljs.core.truth_(inst_35394)){
var statearr_35542_35690 = state_35513__$1;
(statearr_35542_35690[(1)] = (49));

} else {
var statearr_35543_35691 = state_35513__$1;
(statearr_35543_35691[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (4))){
var inst_35272 = (state_35513[(2)]);
var state_35513__$1 = state_35513;
var statearr_35544_35692 = state_35513__$1;
(statearr_35544_35692[(2)] = inst_35272);

(statearr_35544_35692[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (77))){
var inst_35339 = (state_35513[(11)]);
var inst_35450 = (inst_35339 - (1));
var state_35513__$1 = state_35513;
var statearr_35545_35693 = state_35513__$1;
(statearr_35545_35693[(2)] = inst_35450);

(statearr_35545_35693[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (95))){
var inst_35484 = (state_35513[(15)]);
var state_35513__$1 = state_35513;
var statearr_35546_35694 = state_35513__$1;
(statearr_35546_35694[(2)] = inst_35484);

(statearr_35546_35694[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (54))){
var inst_35404 = (state_35513[(2)]);
var state_35513__$1 = state_35513;
if(cljs.core.truth_(inst_35404)){
var statearr_35547_35695 = state_35513__$1;
(statearr_35547_35695[(1)] = (55));

} else {
var statearr_35548_35696 = state_35513__$1;
(statearr_35548_35696[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (92))){
var inst_35484 = (state_35513[(15)]);
var inst_35497 = cljs.core.first.call(null,inst_35484);
var state_35513__$1 = state_35513;
var statearr_35549_35697 = state_35513__$1;
(statearr_35549_35697[(2)] = inst_35497);

(statearr_35549_35697[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (15))){
var inst_35290 = (state_35513[(17)]);
var inst_35298 = (state_35513[(2)]);
var inst_35299 = fluree.db.util.async.throw_err.call(null,inst_35298);
var inst_35300 = [inst_35290];
var inst_35301 = [inst_35299];
var inst_35302 = cljs.core.PersistentHashMap.fromArrays(inst_35300,inst_35301);
var state_35513__$1 = state_35513;
var statearr_35550_35698 = state_35513__$1;
(statearr_35550_35698[(2)] = inst_35302);

(statearr_35550_35698[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (48))){
var inst_35462 = (state_35513[(2)]);
var state_35513__$1 = state_35513;
var statearr_35551_35699 = state_35513__$1;
(statearr_35551_35699[(2)] = inst_35462);

(statearr_35551_35699[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (50))){
var inst_35385 = (state_35513[(18)]);
var state_35513__$1 = state_35513;
var statearr_35552_35700 = state_35513__$1;
(statearr_35552_35700[(2)] = inst_35385);

(statearr_35552_35700[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (75))){
var inst_35354 = (state_35513[(19)]);
var inst_35416 = (state_35513[(13)]);
var inst_35351 = (state_35513[(20)]);
var inst_35433 = (state_35513[(21)]);
var inst_35444 = (state_35513[(2)]);
var inst_35337 = inst_35351;
var inst_35338 = inst_35354;
var inst_35339 = inst_35416;
var inst_35340 = inst_35433;
var inst_35341 = inst_35444;
var state_35513__$1 = (function (){var statearr_35553 = state_35513;
(statearr_35553[(9)] = inst_35341);

(statearr_35553[(12)] = inst_35340);

(statearr_35553[(22)] = inst_35337);

(statearr_35553[(11)] = inst_35339);

(statearr_35553[(23)] = inst_35338);

return statearr_35553;
})();
var statearr_35554_35701 = state_35513__$1;
(statearr_35554_35701[(2)] = null);

(statearr_35554_35701[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (21))){
var inst_35318 = (state_35513[(24)]);
var inst_35330 = (state_35513[(25)]);
var inst_35322 = (state_35513[(26)]);
var inst_35335 = (state_35513[(2)]);
var inst_35336 = cljs.core.PersistentHashMap.EMPTY;
var inst_35337 = inst_35318;
var inst_35338 = inst_35322;
var inst_35339 = inst_35330;
var inst_35340 = inst_35335;
var inst_35341 = inst_35336;
var state_35513__$1 = (function (){var statearr_35555 = state_35513;
(statearr_35555[(9)] = inst_35341);

(statearr_35555[(12)] = inst_35340);

(statearr_35555[(22)] = inst_35337);

(statearr_35555[(11)] = inst_35339);

(statearr_35555[(23)] = inst_35338);

return statearr_35555;
})();
var statearr_35556_35702 = state_35513__$1;
(statearr_35556_35702[(2)] = null);

(statearr_35556_35702[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (31))){
var inst_35355 = (state_35513[(27)]);
var inst_35340 = (state_35513[(12)]);
var inst_35369 = (inst_35340 >= inst_35355);
var state_35513__$1 = state_35513;
if(cljs.core.truth_(inst_35369)){
var statearr_35557_35703 = state_35513__$1;
(statearr_35557_35703[(1)] = (33));

} else {
var statearr_35558_35704 = state_35513__$1;
(statearr_35558_35704[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (32))){
var inst_35469 = (state_35513[(2)]);
var state_35513__$1 = state_35513;
var statearr_35559_35705 = state_35513__$1;
(statearr_35559_35705[(2)] = inst_35469);

(statearr_35559_35705[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (40))){
var state_35513__$1 = state_35513;
var statearr_35560_35706 = state_35513__$1;
(statearr_35560_35706[(2)] = null);

(statearr_35560_35706[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (91))){
var inst_35494 = (state_35513[(2)]);
var state_35513__$1 = state_35513;
var statearr_35561_35707 = state_35513__$1;
(statearr_35561_35707[(2)] = inst_35494);

(statearr_35561_35707[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (56))){
var inst_35399 = (state_35513[(14)]);
var state_35513__$1 = state_35513;
var statearr_35562_35708 = state_35513__$1;
(statearr_35562_35708[(2)] = inst_35399);

(statearr_35562_35708[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (33))){
var state_35513__$1 = state_35513;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_35563_35709 = state_35513__$1;
(statearr_35563_35709[(1)] = (36));

} else {
var statearr_35564_35710 = state_35513__$1;
(statearr_35564_35710[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (13))){
var inst_35318 = (state_35513[(24)]);
var inst_35287 = (state_35513[(28)]);
var inst_35322 = (state_35513[(26)]);
var inst_35318__$1 = cljs.core.keys.call(null,inst_35287);
var inst_35319 = cljs.core.seq.call(null,inst_35318__$1);
var inst_35320 = cljs.core.first.call(null,inst_35319);
var inst_35321 = cljs.core.next.call(null,inst_35319);
var inst_35322__$1 = cljs.core.vals.call(null,inst_35287);
var inst_35323 = cljs.core.seq.call(null,inst_35322__$1);
var inst_35324 = cljs.core.first.call(null,inst_35323);
var inst_35325 = cljs.core.next.call(null,inst_35323);
var inst_35326 = cljs.core._EQ_.call(null,(0),limit);
var state_35513__$1 = (function (){var statearr_35565 = state_35513;
(statearr_35565[(29)] = inst_35325);

(statearr_35565[(30)] = inst_35320);

(statearr_35565[(31)] = inst_35324);

(statearr_35565[(24)] = inst_35318__$1);

(statearr_35565[(32)] = inst_35321);

(statearr_35565[(26)] = inst_35322__$1);

return statearr_35565;
})();
if(inst_35326){
var statearr_35566_35711 = state_35513__$1;
(statearr_35566_35711[(1)] = (16));

} else {
var statearr_35567_35712 = state_35513__$1;
(statearr_35567_35712[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (22))){
var inst_35337 = (state_35513[(22)]);
var inst_35338 = (state_35513[(23)]);
var inst_35349 = cljs.core.seq.call(null,inst_35337);
var inst_35350 = cljs.core.first.call(null,inst_35349);
var inst_35351 = cljs.core.next.call(null,inst_35349);
var inst_35352 = cljs.core.seq.call(null,inst_35338);
var inst_35353 = cljs.core.first.call(null,inst_35352);
var inst_35354 = cljs.core.next.call(null,inst_35352);
var inst_35355 = cljs.core.count.call(null,inst_35353);
var inst_35356 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_35357 = [headers,vars,inst_35353];
var inst_35358 = cljs.core.PersistentHashMap.fromArrays(inst_35356,inst_35357);
var inst_35359 = (inst_35353 == null);
var state_35513__$1 = (function (){var statearr_35568 = state_35513;
(statearr_35568[(19)] = inst_35354);

(statearr_35568[(27)] = inst_35355);

(statearr_35568[(8)] = inst_35350);

(statearr_35568[(20)] = inst_35351);

(statearr_35568[(16)] = inst_35358);

return statearr_35568;
})();
if(cljs.core.truth_(inst_35359)){
var statearr_35569_35713 = state_35513__$1;
(statearr_35569_35713[(1)] = (24));

} else {
var statearr_35570_35714 = state_35513__$1;
(statearr_35570_35714[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (90))){
var inst_35484 = (state_35513[(15)]);
var state_35513__$1 = state_35513;
var statearr_35571_35715 = state_35513__$1;
(statearr_35571_35715[(2)] = inst_35484);

(statearr_35571_35715[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (36))){
var inst_35340 = (state_35513[(12)]);
var inst_35372 = (inst_35340 - (1));
var state_35513__$1 = state_35513;
var statearr_35572_35716 = state_35513__$1;
(statearr_35572_35716[(2)] = inst_35372);

(statearr_35572_35716[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (41))){
var inst_35465 = (state_35513[(2)]);
var state_35513__$1 = state_35513;
var statearr_35573_35717 = state_35513__$1;
(statearr_35573_35717[(2)] = inst_35465);

(statearr_35573_35717[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (89))){
var inst_35484 = (state_35513[(15)]);
var inst_35489 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35490 = [inst_35484];
var inst_35491 = (new cljs.core.PersistentVector(null,1,(5),inst_35489,inst_35490,null));
var state_35513__$1 = state_35513;
var statearr_35574_35718 = state_35513__$1;
(statearr_35574_35718[(2)] = inst_35491);

(statearr_35574_35718[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (43))){
var inst_35385 = (state_35513[(18)]);
var inst_35388 = cljs.core.seq.call(null,inst_35385);
var state_35513__$1 = state_35513;
var statearr_35575_35719 = state_35513__$1;
(statearr_35575_35719[(2)] = inst_35388);

(statearr_35575_35719[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (61))){
var state_35513__$1 = state_35513;
var statearr_35576_35720 = state_35513__$1;
(statearr_35576_35720[(2)] = (0));

(statearr_35576_35720[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (29))){
var inst_35366 = (state_35513[(2)]);
var state_35513__$1 = state_35513;
if(cljs.core.truth_(inst_35366)){
var statearr_35577_35721 = state_35513__$1;
(statearr_35577_35721[(1)] = (30));

} else {
var statearr_35578_35722 = state_35513__$1;
(statearr_35578_35722[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (44))){
var inst_35386 = (state_35513[(33)]);
var state_35513__$1 = state_35513;
var statearr_35579_35723 = state_35513__$1;
(statearr_35579_35723[(2)] = inst_35386);

(statearr_35579_35723[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (93))){
var state_35513__$1 = state_35513;
var statearr_35580_35724 = state_35513__$1;
(statearr_35580_35724[(1)] = (95));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (6))){
var inst_35279 = (state_35513[(34)]);
var inst_35279__$1 = fluree.db.query.fql.build_order_fn.call(null,orderBy,groupBy);
var inst_35281 = fluree.db.query.fql.ad_hoc_group_by.call(null,res,groupBy);
var state_35513__$1 = (function (){var statearr_35582 = state_35513;
(statearr_35582[(34)] = inst_35279__$1);

(statearr_35582[(35)] = inst_35281);

return statearr_35582;
})();
if(cljs.core.truth_(inst_35279__$1)){
var statearr_35583_35725 = state_35513__$1;
(statearr_35583_35725[(1)] = (9));

} else {
var statearr_35584_35726 = state_35513__$1;
(statearr_35584_35726[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (28))){
var inst_35339 = (state_35513[(11)]);
var state_35513__$1 = state_35513;
var statearr_35585_35727 = state_35513__$1;
(statearr_35585_35727[(2)] = inst_35339);

(statearr_35585_35727[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (64))){
var inst_35340 = (state_35513[(12)]);
var inst_35421 = (inst_35340 - (1));
var state_35513__$1 = state_35513;
var statearr_35586_35728 = state_35513__$1;
(statearr_35586_35728[(2)] = inst_35421);

(statearr_35586_35728[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (51))){
var inst_35339 = (state_35513[(11)]);
var inst_35399 = (state_35513[(2)]);
var state_35513__$1 = (function (){var statearr_35587 = state_35513;
(statearr_35587[(14)] = inst_35399);

return statearr_35587;
})();
if(cljs.core.truth_(inst_35339)){
var statearr_35588_35729 = state_35513__$1;
(statearr_35588_35729[(1)] = (52));

} else {
var statearr_35589_35730 = state_35513__$1;
(statearr_35589_35730[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (25))){
var inst_35339 = (state_35513[(11)]);
var state_35513__$1 = state_35513;
if(cljs.core.truth_(inst_35339)){
var statearr_35590_35731 = state_35513__$1;
(statearr_35590_35731[(1)] = (27));

} else {
var statearr_35591_35732 = state_35513__$1;
(statearr_35591_35732[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (34))){
var state_35513__$1 = state_35513;
var statearr_35592_35733 = state_35513__$1;
(statearr_35592_35733[(1)] = (39));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (17))){
var state_35513__$1 = state_35513;
var statearr_35594_35734 = state_35513__$1;
(statearr_35594_35734[(2)] = limit);

(statearr_35594_35734[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (3))){
var inst_35511 = (state_35513[(2)]);
var state_35513__$1 = state_35513;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35513__$1,inst_35511);
} else {
if((state_val_35514 === (12))){
var inst_35287 = (state_35513[(28)]);
var inst_35289 = cljs.core.keys.call(null,inst_35287);
var inst_35290 = cljs.core.first.call(null,inst_35289);
var inst_35291 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_35292 = cljs.core.vals.call(null,inst_35287);
var inst_35293 = cljs.core.first.call(null,inst_35292);
var inst_35294 = [headers,vars,inst_35293];
var inst_35295 = cljs.core.PersistentHashMap.fromArrays(inst_35291,inst_35294);
var inst_35296 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,inst_35295,select_spec,limit,opts);
var state_35513__$1 = (function (){var statearr_35595 = state_35513;
(statearr_35595[(17)] = inst_35290);

return statearr_35595;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35513__$1,(15),inst_35296);
} else {
if((state_val_35514 === (2))){
var _ = (function (){var statearr_35596 = state_35513;
(statearr_35596[(4)] = cljs.core.cons.call(null,(5),(state_35513[(4)])));

return statearr_35596;
})();
var state_35513__$1 = state_35513;
if(cljs.core.truth_(groupBy)){
var statearr_35597_35735 = state_35513__$1;
(statearr_35597_35735[(1)] = (6));

} else {
var statearr_35598_35736 = state_35513__$1;
(statearr_35598_35736[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (66))){
var inst_35431 = (state_35513[(2)]);
var state_35513__$1 = state_35513;
var statearr_35599_35737 = state_35513__$1;
(statearr_35599_35737[(2)] = inst_35431);

(statearr_35599_35737[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (23))){
var inst_35473 = (state_35513[(2)]);
var state_35513__$1 = state_35513;
var statearr_35600_35738 = state_35513__$1;
(statearr_35600_35738[(2)] = inst_35473);

(statearr_35600_35738[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (47))){
var inst_35339 = (state_35513[(11)]);
var inst_35447 = (inst_35339 == null);
var state_35513__$1 = state_35513;
if(cljs.core.truth_(inst_35447)){
var statearr_35601_35739 = state_35513__$1;
(statearr_35601_35739[(1)] = (76));

} else {
var statearr_35602_35740 = state_35513__$1;
(statearr_35602_35740[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (35))){
var inst_35467 = (state_35513[(2)]);
var state_35513__$1 = state_35513;
var statearr_35603_35741 = state_35513__$1;
(statearr_35603_35741[(2)] = inst_35467);

(statearr_35603_35741[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (82))){
var state_35513__$1 = state_35513;
var statearr_35604_35742 = state_35513__$1;
(statearr_35604_35742[(2)] = (1));

(statearr_35604_35742[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (76))){
var state_35513__$1 = state_35513;
var statearr_35605_35743 = state_35513__$1;
(statearr_35605_35743[(2)] = null);

(statearr_35605_35743[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (97))){
var inst_35502 = (state_35513[(2)]);
var state_35513__$1 = state_35513;
var statearr_35606_35744 = state_35513__$1;
(statearr_35606_35744[(2)] = inst_35502);

(statearr_35606_35744[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (19))){
var inst_35331 = (state_35513[(36)]);
var state_35513__$1 = state_35513;
var statearr_35607_35745 = state_35513__$1;
(statearr_35607_35745[(2)] = inst_35331);

(statearr_35607_35745[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (57))){
var inst_35339 = (state_35513[(11)]);
var inst_35409 = (state_35513[(2)]);
var inst_35410 = (inst_35339 == null);
var state_35513__$1 = (function (){var statearr_35608 = state_35513;
(statearr_35608[(10)] = inst_35409);

return statearr_35608;
})();
if(cljs.core.truth_(inst_35410)){
var statearr_35609_35746 = state_35513__$1;
(statearr_35609_35746[(1)] = (58));

} else {
var statearr_35610_35747 = state_35513__$1;
(statearr_35610_35747[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (68))){
var state_35513__$1 = state_35513;
var statearr_35611_35748 = state_35513__$1;
(statearr_35611_35748[(2)] = null);

(statearr_35611_35748[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (11))){
var inst_35287 = (state_35513[(2)]);
var state_35513__$1 = (function (){var statearr_35613 = state_35513;
(statearr_35613[(28)] = inst_35287);

return statearr_35613;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_35614_35749 = state_35513__$1;
(statearr_35614_35749[(1)] = (12));

} else {
var statearr_35615_35750 = state_35513__$1;
(statearr_35615_35750[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (9))){
var inst_35279 = (state_35513[(34)]);
var inst_35281 = (state_35513[(35)]);
var inst_35283 = cljs.core.sorted_map_by.call(null,inst_35279);
var inst_35284 = cljs.core.into.call(null,inst_35283,inst_35281);
var state_35513__$1 = state_35513;
var statearr_35616_35751 = state_35513__$1;
(statearr_35616_35751[(2)] = inst_35284);

(statearr_35616_35751[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (5))){
var _ = (function (){var statearr_35617 = state_35513;
(statearr_35617[(4)] = cljs.core.rest.call(null,(state_35513[(4)])));

return statearr_35617;
})();
var state_35513__$1 = state_35513;
var ex35612 = (state_35513__$1[(2)]);
var statearr_35618_35752 = state_35513__$1;
(statearr_35618_35752[(5)] = ex35612);


if((ex35612 instanceof Error)){
var statearr_35619_35753 = state_35513__$1;
(statearr_35619_35753[(1)] = (4));

(statearr_35619_35753[(5)] = null);

} else {
throw ex35612;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (83))){
var state_35513__$1 = state_35513;
var statearr_35620_35754 = state_35513__$1;
(statearr_35620_35754[(2)] = limit);

(statearr_35620_35754[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (14))){
var inst_35475 = (state_35513[(2)]);
var state_35513__$1 = state_35513;
var statearr_35621_35755 = state_35513__$1;
(statearr_35621_35755[(2)] = inst_35475);

(statearr_35621_35755[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (45))){
var inst_35391 = (state_35513[(2)]);
var state_35513__$1 = state_35513;
if(cljs.core.truth_(inst_35391)){
var statearr_35622_35756 = state_35513__$1;
(statearr_35622_35756[(1)] = (46));

} else {
var statearr_35623_35757 = state_35513__$1;
(statearr_35623_35757[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (53))){
var inst_35339 = (state_35513[(11)]);
var state_35513__$1 = state_35513;
var statearr_35624_35758 = state_35513__$1;
(statearr_35624_35758[(2)] = inst_35339);

(statearr_35624_35758[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (78))){
var inst_35340 = (state_35513[(12)]);
var inst_35452 = (state_35513[(2)]);
var inst_35453 = (inst_35340 <= (0));
var state_35513__$1 = (function (){var statearr_35625 = state_35513;
(statearr_35625[(37)] = inst_35452);

return statearr_35625;
})();
if(cljs.core.truth_(inst_35453)){
var statearr_35626_35759 = state_35513__$1;
(statearr_35626_35759[(1)] = (79));

} else {
var statearr_35627_35760 = state_35513__$1;
(statearr_35627_35760[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (26))){
var inst_35471 = (state_35513[(2)]);
var state_35513__$1 = state_35513;
var statearr_35628_35761 = state_35513__$1;
(statearr_35628_35761[(2)] = inst_35471);

(statearr_35628_35761[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (16))){
var state_35513__$1 = state_35513;
var statearr_35629_35762 = state_35513__$1;
(statearr_35629_35762[(2)] = null);

(statearr_35629_35762[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (81))){
var inst_35385 = (state_35513[(18)]);
var inst_35354 = (state_35513[(19)]);
var inst_35350 = (state_35513[(8)]);
var inst_35341 = (state_35513[(9)]);
var inst_35452 = (state_35513[(37)]);
var inst_35351 = (state_35513[(20)]);
var inst_35458 = (state_35513[(2)]);
var inst_35459 = cljs.core.assoc.call(null,inst_35341,inst_35350,inst_35385);
var inst_35337 = inst_35351;
var inst_35338 = inst_35354;
var inst_35339 = inst_35452;
var inst_35340 = inst_35458;
var inst_35341__$1 = inst_35459;
var state_35513__$1 = (function (){var statearr_35632 = state_35513;
(statearr_35632[(9)] = inst_35341__$1);

(statearr_35632[(12)] = inst_35340);

(statearr_35632[(22)] = inst_35337);

(statearr_35632[(11)] = inst_35339);

(statearr_35632[(23)] = inst_35338);

return statearr_35632;
})();
var statearr_35633_35763 = state_35513__$1;
(statearr_35633_35763[(2)] = null);

(statearr_35633_35763[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (79))){
var state_35513__$1 = state_35513;
var statearr_35634_35764 = state_35513__$1;
(statearr_35634_35764[(2)] = (0));

(statearr_35634_35764[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (38))){
var inst_35354 = (state_35513[(19)]);
var inst_35341 = (state_35513[(9)]);
var inst_35339 = (state_35513[(11)]);
var inst_35351 = (state_35513[(20)]);
var inst_35376 = (state_35513[(2)]);
var tmp35630 = inst_35341;
var tmp35631 = inst_35339;
var inst_35337 = inst_35351;
var inst_35338 = inst_35354;
var inst_35339__$1 = tmp35631;
var inst_35340 = inst_35376;
var inst_35341__$1 = tmp35630;
var state_35513__$1 = (function (){var statearr_35635 = state_35513;
(statearr_35635[(9)] = inst_35341__$1);

(statearr_35635[(12)] = inst_35340);

(statearr_35635[(22)] = inst_35337);

(statearr_35635[(11)] = inst_35339__$1);

(statearr_35635[(23)] = inst_35338);

return statearr_35635;
})();
var statearr_35636_35765 = state_35513__$1;
(statearr_35636_35765[(2)] = null);

(statearr_35636_35765[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (87))){
var state_35513__$1 = state_35513;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_35637_35766 = state_35513__$1;
(statearr_35637_35766[(1)] = (92));

} else {
var statearr_35638_35767 = state_35513__$1;
(statearr_35638_35767[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (30))){
var inst_35341 = (state_35513[(9)]);
var state_35513__$1 = state_35513;
var statearr_35639_35768 = state_35513__$1;
(statearr_35639_35768[(2)] = inst_35341);

(statearr_35639_35768[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (73))){
var inst_35341 = (state_35513[(9)]);
var state_35513__$1 = state_35513;
var statearr_35640_35769 = state_35513__$1;
(statearr_35640_35769[(2)] = inst_35341);

(statearr_35640_35769[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (96))){
var state_35513__$1 = state_35513;
var statearr_35641_35770 = state_35513__$1;
(statearr_35641_35770[(2)] = null);

(statearr_35641_35770[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (10))){
var inst_35281 = (state_35513[(35)]);
var state_35513__$1 = state_35513;
var statearr_35642_35771 = state_35513__$1;
(statearr_35642_35771[(2)] = inst_35281);

(statearr_35642_35771[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (18))){
var inst_35331 = (state_35513[(36)]);
var inst_35330 = (state_35513[(2)]);
var inst_35331__$1 = offset;
var state_35513__$1 = (function (){var statearr_35643 = state_35513;
(statearr_35643[(25)] = inst_35330);

(statearr_35643[(36)] = inst_35331__$1);

return statearr_35643;
})();
if(cljs.core.truth_(inst_35331__$1)){
var statearr_35644_35772 = state_35513__$1;
(statearr_35644_35772[(1)] = (19));

} else {
var statearr_35645_35773 = state_35513__$1;
(statearr_35645_35773[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (52))){
var inst_35339 = (state_35513[(11)]);
var inst_35401 = ((0) < inst_35339);
var state_35513__$1 = state_35513;
var statearr_35646_35774 = state_35513__$1;
(statearr_35646_35774[(2)] = inst_35401);

(statearr_35646_35774[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (67))){
var inst_35355 = (state_35513[(27)]);
var inst_35409 = (state_35513[(10)]);
var inst_35340 = (state_35513[(12)]);
var inst_35424 = cljs.core.count.call(null,inst_35409);
var inst_35425 = (inst_35355 - inst_35424);
var inst_35426 = (inst_35340 - inst_35425);
var state_35513__$1 = state_35513;
var statearr_35647_35775 = state_35513__$1;
(statearr_35647_35775[(2)] = inst_35426);

(statearr_35647_35775[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (71))){
var inst_35409 = (state_35513[(10)]);
var inst_35437 = cljs.core.empty_QMARK_.call(null,inst_35409);
var state_35513__$1 = state_35513;
var statearr_35648_35776 = state_35513__$1;
(statearr_35648_35776[(2)] = inst_35437);

(statearr_35648_35776[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (42))){
var inst_35385 = (state_35513[(18)]);
var inst_35386 = (state_35513[(33)]);
var inst_35384 = (state_35513[(2)]);
var inst_35385__$1 = fluree.db.util.async.throw_err.call(null,inst_35384);
var inst_35386__$1 = cljs.core.coll_QMARK_.call(null,inst_35385__$1);
var state_35513__$1 = (function (){var statearr_35649 = state_35513;
(statearr_35649[(18)] = inst_35385__$1);

(statearr_35649[(33)] = inst_35386__$1);

return statearr_35649;
})();
if(inst_35386__$1){
var statearr_35650_35777 = state_35513__$1;
(statearr_35650_35777[(1)] = (43));

} else {
var statearr_35651_35778 = state_35513__$1;
(statearr_35651_35778[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (80))){
var inst_35340 = (state_35513[(12)]);
var inst_35456 = (inst_35340 - (1));
var state_35513__$1 = state_35513;
var statearr_35652_35779 = state_35513__$1;
(statearr_35652_35779[(2)] = inst_35456);

(statearr_35652_35779[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (37))){
var inst_35355 = (state_35513[(27)]);
var inst_35340 = (state_35513[(12)]);
var inst_35374 = (inst_35340 - inst_35355);
var state_35513__$1 = state_35513;
var statearr_35653_35780 = state_35513__$1;
(statearr_35653_35780[(2)] = inst_35374);

(statearr_35653_35780[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (63))){
var inst_35434 = (state_35513[(7)]);
var inst_35409 = (state_35513[(10)]);
var inst_35433 = (state_35513[(2)]);
var inst_35434__$1 = (inst_35409 == null);
var state_35513__$1 = (function (){var statearr_35654 = state_35513;
(statearr_35654[(7)] = inst_35434__$1);

(statearr_35654[(21)] = inst_35433);

return statearr_35654;
})();
if(cljs.core.truth_(inst_35434__$1)){
var statearr_35655_35781 = state_35513__$1;
(statearr_35655_35781[(1)] = (70));

} else {
var statearr_35656_35782 = state_35513__$1;
(statearr_35656_35782[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (94))){
var inst_35504 = (state_35513[(2)]);
var state_35513__$1 = state_35513;
var statearr_35657_35783 = state_35513__$1;
(statearr_35657_35783[(2)] = inst_35504);

(statearr_35657_35783[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (8))){
var inst_35508 = (state_35513[(2)]);
var _ = (function (){var statearr_35658 = state_35513;
(statearr_35658[(4)] = cljs.core.rest.call(null,(state_35513[(4)])));

return statearr_35658;
})();
var state_35513__$1 = state_35513;
var statearr_35659_35784 = state_35513__$1;
(statearr_35659_35784[(2)] = inst_35508);

(statearr_35659_35784[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (49))){
var inst_35385 = (state_35513[(18)]);
var inst_35340 = (state_35513[(12)]);
var inst_35396 = cljs.core.drop.call(null,inst_35340,inst_35385);
var state_35513__$1 = state_35513;
var statearr_35660_35785 = state_35513__$1;
(statearr_35660_35785[(2)] = inst_35396);

(statearr_35660_35785[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35514 === (84))){
var inst_35480 = (state_35513[(2)]);
var inst_35481 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,res,select_spec,inst_35480,opts);
var state_35513__$1 = state_35513;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35513__$1,(85),inst_35481);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10903__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10903__auto____0 = (function (){
var statearr_35661 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35661[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10903__auto__);

(statearr_35661[(1)] = (1));

return statearr_35661;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10903__auto____1 = (function (state_35513){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_35513);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e35662){var ex__10906__auto__ = e35662;
var statearr_35663_35786 = state_35513;
(statearr_35663_35786[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_35513[(4)]))){
var statearr_35664_35787 = state_35513;
(statearr_35664_35787[(1)] = cljs.core.first.call(null,(state_35513[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35788 = state_35513;
state_35513 = G__35788;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10903__auto__ = function(state_35513){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10903__auto____1.call(this,state_35513);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10903__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10903__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_35665 = f__10977__auto__.call(null);
(statearr_35665[(6)] = c__10976__auto__);

return statearr_35665;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__35791,opts){
var map__35792 = p__35791;
var map__35792__$1 = cljs.core.__destructure_map.call(null,map__35792);
var selectOne = cljs.core.get.call(null,map__35792__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var select = cljs.core.get.call(null,map__35792__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var selectDistinct = cljs.core.get.call(null,map__35792__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var selectReduced = cljs.core.get.call(null,map__35792__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var select_smt = (function (){var or__4253__auto__ = selectOne;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = select;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
var or__4253__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4253__auto____$2)){
return or__4253__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_.call(null,select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select.call(null,headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.call(null,(function (p1__35789_SHARP_){
return cljs.core.contains_QMARK_.call(null,p1__35789_SHARP_,new cljs.core.Keyword(null,"code","code",1586293142));
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some.call(null,(function (p1__35790_SHARP_){
return cljs.core.contains_QMARK_.call(null,p1__35790_SHARP_,new cljs.core.Keyword(null,"selection","selection",975998651));
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_.call(null,aggregates))?null:aggregates);
var orderBy = (function (){var temp__5753__auto__ = new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5753__auto__)){
var orderBy = temp__5753__auto__;
if(cljs.core.truth_((function (){var or__4253__auto__ = typeof orderBy === 'string';
if(or__4253__auto__){
return or__4253__auto__;
} else {
var and__4251__auto__ = cljs.core.vector_QMARK_.call(null,orderBy);
if(and__4251__auto__){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null).call(null,cljs.core.first.call(null,orderBy));
} else {
return and__4251__auto__;
}
}
})())){
if(cljs.core.vector_QMARK_.call(null,orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.call(null,["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289),new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"inVector?","inVector?",1948069375)],[expandMap_QMARK_,(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (100);
}
})(),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"offset","offset",296498311).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$.call(null,selectOne),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return false;
}
})(),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667).cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$.call(null,(function (){var or__4253__auto__ = selectDistinct;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__35793,p__35794){
var map__35795 = p__35793;
var map__35795__$1 = cljs.core.__destructure_map.call(null,map__35795);
var query_map = map__35795__$1;
var construct = cljs.core.get.call(null,map__35795__$1,new cljs.core.Keyword(null,"construct","construct",692547932));
var map__35796 = p__35794;
var map__35796__$1 = cljs.core.__destructure_map.call(null,map__35796);
var where_result = map__35796__$1;
var headers = cljs.core.get.call(null,map__35796__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__35796__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__35797 = cljs.core.map.call(null,(function (construct_item){
var temp__5751__auto__ = fluree.db.util.core.index_of.call(null,headers,cljs.core.symbol.call(null,construct_item));
if(cljs.core.truth_(temp__5751__auto__)){
var index_of = temp__5751__auto__;
return (function (row){
return cljs.core.nth.call(null,row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.call(null,vec__35797,(0),null);
var fn2 = cljs.core.nth.call(null,vec__35797,(1),null);
var fn3 = cljs.core.nth.call(null,vec__35797,(2),null);
return cljs.core.map.call(null,(function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fn1.call(null,res),fn2.call(null,res),fn3.call(null,res)], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_35830){
var state_val_35831 = (state_35830[(1)]);
if((state_val_35831 === (7))){
var inst_35809 = (state_35830[(7)]);
var state_35830__$1 = state_35830;
var statearr_35832_35855 = state_35830__$1;
(statearr_35832_35855[(2)] = inst_35809);

(statearr_35832_35855[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35831 === (1))){
var state_35830__$1 = state_35830;
var statearr_35833_35856 = state_35830__$1;
(statearr_35833_35856[(2)] = null);

(statearr_35833_35856[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35831 === (4))){
var inst_35800 = (state_35830[(2)]);
var state_35830__$1 = state_35830;
var statearr_35834_35857 = state_35830__$1;
(statearr_35834_35857[(2)] = inst_35800);

(statearr_35834_35857[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35831 === (13))){
var inst_35819 = (state_35830[(2)]);
var inst_35820 = fluree.db.util.async.throw_err.call(null,inst_35819);
var state_35830__$1 = state_35830;
var statearr_35835_35858 = state_35830__$1;
(statearr_35835_35858[(2)] = inst_35820);

(statearr_35835_35858[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35831 === (6))){
var inst_35809 = (state_35830[(7)]);
var inst_35808 = (state_35830[(2)]);
var inst_35809__$1 = fluree.db.util.async.throw_err.call(null,inst_35808);
var inst_35810 = fluree.db.util.core.exception_QMARK_.call(null,inst_35809__$1);
var state_35830__$1 = (function (){var statearr_35836 = state_35830;
(statearr_35836[(7)] = inst_35809__$1);

return statearr_35836;
})();
if(inst_35810){
var statearr_35837_35859 = state_35830__$1;
(statearr_35837_35859[(1)] = (7));

} else {
var statearr_35838_35860 = state_35830__$1;
(statearr_35838_35860[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35831 === (3))){
var inst_35828 = (state_35830[(2)]);
var state_35830__$1 = state_35830;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35830__$1,inst_35828);
} else {
if((state_val_35831 === (12))){
var inst_35823 = (state_35830[(2)]);
var state_35830__$1 = state_35830;
var statearr_35839_35861 = state_35830__$1;
(statearr_35839_35861[(2)] = inst_35823);

(statearr_35839_35861[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35831 === (2))){
var _ = (function (){var statearr_35840 = state_35830;
(statearr_35840[(4)] = cljs.core.cons.call(null,(5),(state_35830[(4)])));

return statearr_35840;
})();
var inst_35806 = fluree.db.query.analytical.q.call(null,query_map,fuel,max_fuel,db,opts);
var state_35830__$1 = state_35830;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35830__$1,(6),inst_35806);
} else {
if((state_val_35831 === (11))){
var state_35830__$1 = state_35830;
var statearr_35842_35862 = state_35830__$1;
(statearr_35842_35862[(2)] = null);

(statearr_35842_35862[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35831 === (9))){
var inst_35825 = (state_35830[(2)]);
var _ = (function (){var statearr_35843 = state_35830;
(statearr_35843[(4)] = cljs.core.rest.call(null,(state_35830[(4)])));

return statearr_35843;
})();
var state_35830__$1 = state_35830;
var statearr_35844_35863 = state_35830__$1;
(statearr_35844_35863[(2)] = inst_35825);

(statearr_35844_35863[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35831 === (5))){
var _ = (function (){var statearr_35845 = state_35830;
(statearr_35845[(4)] = cljs.core.rest.call(null,(state_35830[(4)])));

return statearr_35845;
})();
var state_35830__$1 = state_35830;
var ex35841 = (state_35830__$1[(2)]);
var statearr_35846_35864 = state_35830__$1;
(statearr_35846_35864[(5)] = ex35841);


if((ex35841 instanceof Error)){
var statearr_35847_35865 = state_35830__$1;
(statearr_35847_35865[(1)] = (4));

(statearr_35847_35865[(5)] = null);

} else {
throw ex35841;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35831 === (10))){
var inst_35809 = (state_35830[(7)]);
var inst_35814 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_35809);
var inst_35815 = new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(inst_35809);
var inst_35816 = fluree.db.query.fql.get_ad_hoc_select_spec.call(null,inst_35814,inst_35815,query_map,opts);
var inst_35817 = fluree.db.query.fql.process_ad_hoc_res.call(null,db,fuel,max_fuel,inst_35809,inst_35816,opts);
var state_35830__$1 = state_35830;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35830__$1,(13),inst_35817);
} else {
if((state_val_35831 === (8))){
var state_35830__$1 = state_35830;
var statearr_35848_35866 = state_35830__$1;
(statearr_35848_35866[(1)] = (10));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__10903__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__10903__auto____0 = (function (){
var statearr_35850 = [null,null,null,null,null,null,null,null];
(statearr_35850[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__10903__auto__);

(statearr_35850[(1)] = (1));

return statearr_35850;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__10903__auto____1 = (function (state_35830){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_35830);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e35851){var ex__10906__auto__ = e35851;
var statearr_35852_35867 = state_35830;
(statearr_35852_35867[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_35830[(4)]))){
var statearr_35853_35868 = state_35830;
(statearr_35853_35868[(1)] = cljs.core.first.call(null,(state_35830[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35869 = state_35830;
state_35830 = G__35869;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__10903__auto__ = function(state_35830){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__10903__auto____1.call(this,state_35830);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__10903__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__10903__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_35854 = f__10977__auto__.call(null);
(statearr_35854[(6)] = c__10976__auto__);

return statearr_35854;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
fluree.db.util.log.debug.call(null,"Running query:",cljs.core.pr_str.call(null,query_map));

var map__35870 = query_map;
var map__35870__$1 = cljs.core.__destructure_map.call(null,map__35870);
var select = cljs.core.get.call(null,map__35870__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.call(null,map__35870__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var where = cljs.core.get.call(null,map__35870__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.call(null,map__35870__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__35870__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var component = cljs.core.get.call(null,map__35870__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var selectDistinct = cljs.core.get.call(null,map__35870__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var prettyPrint = cljs.core.get.call(null,map__35870__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectOne = cljs.core.get.call(null,map__35870__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var from = cljs.core.get.call(null,map__35870__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var opts = cljs.core.get.call(null,map__35870__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var groupBy = cljs.core.get.call(null,map__35870__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var opts_SINGLEQUOTE_ = (function (){var G__35871 = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"limit","limit",-1355822363),limit,new cljs.core.Keyword(null,"offset","offset",296498311),(function (){var or__4253__auto__ = offset;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
})(),new cljs.core.Keyword(null,"component","component",1555936782),component,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),orderBy,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),groupBy,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),prettyPrint], null),opts);
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.call(null,G__35871,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
} else {
return G__35871;
}
})();
var max_fuel = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
if(cljs.core.truth_((function (){var or__4253__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_.call(null,(0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_.call(null,where)){
return fluree.db.query.fql.ad_hoc_query.call(null,db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_36227){
var state_val_36228 = (state_36227[(1)]);
if((state_val_36228 === (121))){
var inst_36188 = (state_36227[(2)]);
var state_36227__$1 = state_36227;
var statearr_36229_36424 = state_36227__$1;
(statearr_36229_36424[(2)] = inst_36188);

(statearr_36229_36424[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (65))){
var inst_36065 = typeof from === 'string';
var state_36227__$1 = state_36227;
if(cljs.core.truth_(inst_36065)){
var statearr_36230_36425 = state_36227__$1;
(statearr_36230_36425[(1)] = (72));

} else {
var statearr_36231_36426 = state_36227__$1;
(statearr_36231_36426[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (70))){
var inst_35933 = (state_36227[(7)]);
var inst_35931 = (state_36227[(8)]);
var inst_36058 = (state_36227[(2)]);
var inst_36059 = fluree.db.util.async.throw_err.call(null,inst_36058);
var inst_36060 = fluree.db.query.fql.flake_select.call(null,db,inst_35933,fuel,max_fuel,inst_35931,inst_36059);
var state_36227__$1 = state_36227;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36227__$1,(71),inst_36060);
} else {
if((state_val_36228 === (62))){
var inst_36038 = (state_36227[(9)]);
var state_36227__$1 = state_36227;
var statearr_36232_36427 = state_36227__$1;
(statearr_36232_36427[(2)] = inst_36038);

(statearr_36232_36427[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (74))){
var inst_36194 = (state_36227[(2)]);
var state_36227__$1 = state_36227;
var statearr_36233_36428 = state_36227__$1;
(statearr_36233_36428[(2)] = inst_36194);

(statearr_36233_36428[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (110))){
var inst_36129 = (state_36227[(10)]);
var state_36227__$1 = state_36227;
var statearr_36234_36429 = state_36227__$1;
(statearr_36234_36429[(2)] = inst_36129);

(statearr_36234_36429[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (130))){
var inst_36214 = (state_36227[(2)]);
var state_36227__$1 = state_36227;
var statearr_36235_36430 = state_36227__$1;
(statearr_36235_36430[(2)] = inst_36214);

(statearr_36235_36430[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (128))){
var inst_36205 = (state_36227[(11)]);
var inst_36210 = fluree.db.util.core.exception_QMARK_.call(null,inst_36205);
var inst_36211 = (!(inst_36210));
var state_36227__$1 = state_36227;
var statearr_36236_36431 = state_36227__$1;
(statearr_36236_36431[(2)] = inst_36211);

(statearr_36236_36431[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (7))){
var inst_35901 = (state_36227[(12)]);
var inst_35901__$1 = selectOne;
var state_36227__$1 = (function (){var statearr_36237 = state_36227;
(statearr_36237[(12)] = inst_35901__$1);

return statearr_36237;
})();
if(cljs.core.truth_(inst_35901__$1)){
var statearr_36238_36432 = state_36227__$1;
(statearr_36238_36432[(1)] = (9));

} else {
var statearr_36239_36433 = state_36227__$1;
(statearr_36239_36433[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (59))){
var inst_35933 = (state_36227[(7)]);
var inst_35921 = (state_36227[(13)]);
var inst_36016 = (state_36227[(14)]);
var inst_35931 = (state_36227[(8)]);
var inst_36030 = (state_36227[(2)]);
var inst_36031 = fluree.db.util.async.throw_err.call(null,inst_36030);
var inst_36032 = cljs.core.sequence.call(null,inst_36016,inst_36031);
var inst_36033 = fluree.db.query.fql.subject_select.call(null,db,inst_35933,fuel,max_fuel,inst_35931,inst_36032,inst_35921);
var state_36227__$1 = state_36227;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36227__$1,(60),inst_36033);
} else {
if((state_val_36228 === (86))){
var inst_35933 = (state_36227[(7)]);
var inst_35921 = (state_36227[(13)]);
var inst_35931 = (state_36227[(8)]);
var inst_35923 = (state_36227[(15)]);
var inst_36098 = (state_36227[(2)]);
var inst_36099 = fluree.db.query.fql.subject_select.call(null,db,inst_35933,fuel,max_fuel,inst_35931,inst_36098,inst_35921,inst_35923);
var state_36227__$1 = state_36227;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36227__$1,(87),inst_36099);
} else {
if((state_val_36228 === (20))){
var inst_35965 = (state_36227[(2)]);
var inst_35966 = cljs.core.nth.call(null,inst_35965,(0),null);
var inst_35967 = cljs.core.nth.call(null,inst_35965,(1),null);
var inst_35968 = typeof where === 'string';
var state_36227__$1 = (function (){var statearr_36240 = state_36227;
(statearr_36240[(16)] = inst_35967);

(statearr_36240[(17)] = inst_35966);

return statearr_36240;
})();
if(cljs.core.truth_(inst_35968)){
var statearr_36241_36434 = state_36227__$1;
(statearr_36241_36434[(1)] = (30));

} else {
var statearr_36242_36435 = state_36227__$1;
(statearr_36242_36435[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (72))){
var inst_35920 = (state_36227[(18)]);
var state_36227__$1 = state_36227;
if(cljs.core.truth_(inst_35920)){
var statearr_36243_36436 = state_36227__$1;
(statearr_36243_36436[(1)] = (75));

} else {
var statearr_36244_36437 = state_36227__$1;
(statearr_36244_36437[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (58))){
var inst_36024 = (state_36227[(2)]);
var inst_36025 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36026 = [from];
var inst_36027 = (new cljs.core.PersistentVector(null,1,(5),inst_36025,inst_36026,null));
var inst_36028 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_36027,inst_36024);
var state_36227__$1 = state_36227;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36227__$1,(59),inst_36028);
} else {
if((state_val_36228 === (60))){
var inst_36035 = (state_36227[(2)]);
var inst_36036 = fluree.db.util.async.throw_err.call(null,inst_36035);
var state_36227__$1 = state_36227;
var statearr_36245_36438 = state_36227__$1;
(statearr_36245_36438[(2)] = inst_36036);

(statearr_36245_36438[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (27))){
var inst_35950 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35951 = [null,null];
var inst_35952 = (new cljs.core.PersistentVector(null,2,(5),inst_35950,inst_35951,null));
var state_36227__$1 = state_36227;
var statearr_36246_36439 = state_36227__$1;
(statearr_36246_36439[(2)] = inst_35952);

(statearr_36246_36439[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (1))){
var state_36227__$1 = state_36227;
var statearr_36247_36440 = state_36227__$1;
(statearr_36247_36440[(2)] = null);

(statearr_36247_36440[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (69))){
var inst_36055 = (state_36227[(2)]);
var inst_36056 = fluree.db.query.range._block_or_tx_collection.call(null,db,inst_36055);
var state_36227__$1 = state_36227;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36227__$1,(70),inst_36056);
} else {
if((state_val_36228 === (101))){
var inst_36161 = (state_36227[(2)]);
var state_36227__$1 = state_36227;
var statearr_36248_36441 = state_36227__$1;
(statearr_36248_36441[(2)] = inst_36161);

(statearr_36248_36441[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (24))){
var inst_35920 = (state_36227[(18)]);
var inst_35945 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35946 = [inst_35920,"ASC"];
var inst_35947 = (new cljs.core.PersistentVector(null,2,(5),inst_35945,inst_35946,null));
var state_36227__$1 = state_36227;
var statearr_36249_36442 = state_36227__$1;
(statearr_36249_36442[(2)] = inst_35947);

(statearr_36249_36442[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (102))){
var inst_36135 = (state_36227[(19)]);
var state_36227__$1 = state_36227;
var statearr_36250_36443 = state_36227__$1;
(statearr_36250_36443[(2)] = inst_36135);

(statearr_36250_36443[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (55))){
var inst_35920 = (state_36227[(18)]);
var inst_36016 = (state_36227[(2)]);
var state_36227__$1 = (function (){var statearr_36251 = state_36227;
(statearr_36251[(14)] = inst_36016);

return statearr_36251;
})();
if(cljs.core.truth_(inst_35920)){
var statearr_36252_36444 = state_36227__$1;
(statearr_36252_36444[(1)] = (56));

} else {
var statearr_36253_36445 = state_36227__$1;
(statearr_36253_36445[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (85))){
var inst_36090 = (state_36227[(20)]);
var inst_36094 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36095 = [inst_36090];
var inst_36096 = (new cljs.core.PersistentVector(null,1,(5),inst_36094,inst_36095,null));
var state_36227__$1 = state_36227;
var statearr_36254_36446 = state_36227__$1;
(statearr_36254_36446[(2)] = inst_36096);

(statearr_36254_36446[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (39))){
var inst_35921 = (state_36227[(13)]);
var state_36227__$1 = state_36227;
var statearr_36255_36447 = state_36227__$1;
(statearr_36255_36447[(2)] = inst_35921);

(statearr_36255_36447[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (88))){
var inst_36104 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core.inc);
var state_36227__$1 = state_36227;
var statearr_36256_36448 = state_36227__$1;
(statearr_36256_36448[(2)] = inst_36104);

(statearr_36256_36448[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (46))){
var inst_36001 = (state_36227[(2)]);
var state_36227__$1 = state_36227;
if(cljs.core.truth_(inst_36001)){
var statearr_36257_36449 = state_36227__$1;
(statearr_36257_36449[(1)] = (47));

} else {
var statearr_36258_36450 = state_36227__$1;
(statearr_36258_36450[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (4))){
var inst_35888 = (state_36227[(2)]);
var state_36227__$1 = state_36227;
var statearr_36259_36451 = state_36227__$1;
(statearr_36259_36451[(2)] = inst_35888);

(statearr_36259_36451[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (77))){
var inst_36074 = (state_36227[(2)]);
var inst_36075 = fluree.db.query.range.collection.call(null,db,from,inst_36074);
var state_36227__$1 = state_36227;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36227__$1,(78),inst_36075);
} else {
if((state_val_36228 === (106))){
var state_36227__$1 = state_36227;
var statearr_36260_36452 = state_36227__$1;
(statearr_36260_36452[(2)] = null);

(statearr_36260_36452[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (119))){
var inst_36180 = cljs.core.pr_str.call(null,query_map);
var inst_36181 = ["Invalid 'from' in query:",inst_36180].join('');
var inst_36182 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_36183 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_36184 = cljs.core.PersistentHashMap.fromArrays(inst_36182,inst_36183);
var inst_36185 = cljs.core.ex_info.call(null,inst_36181,inst_36184);
var state_36227__$1 = state_36227;
var statearr_36261_36453 = state_36227__$1;
(statearr_36261_36453[(2)] = inst_36185);

(statearr_36261_36453[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (95))){
var state_36227__$1 = state_36227;
var statearr_36262_36454 = state_36227__$1;
(statearr_36262_36454[(1)] = (119));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (54))){
var inst_36010 = (state_36227[(21)]);
var state_36227__$1 = state_36227;
var statearr_36264_36455 = state_36227__$1;
(statearr_36264_36455[(2)] = inst_36010);

(statearr_36264_36455[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (92))){
var inst_36109 = (state_36227[(22)]);
var state_36227__$1 = state_36227;
var statearr_36265_36456 = state_36227__$1;
(statearr_36265_36456[(2)] = inst_36109);

(statearr_36265_36456[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (104))){
var inst_36153 = (state_36227[(23)]);
var inst_36153__$1 = (state_36227[(2)]);
var state_36227__$1 = (function (){var statearr_36266 = state_36227;
(statearr_36266[(23)] = inst_36153__$1);

return statearr_36266;
})();
if(cljs.core.truth_(inst_36153__$1)){
var statearr_36267_36457 = state_36227__$1;
(statearr_36267_36457[(1)] = (109));

} else {
var statearr_36268_36458 = state_36227__$1;
(statearr_36268_36458[(1)] = (110));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (15))){
var inst_35922 = (state_36227[(24)]);
var inst_35924 = (state_36227[(25)]);
var inst_35928 = cljs.core.assoc.call(null,inst_35924,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),inst_35922);
var state_36227__$1 = state_36227;
var statearr_36269_36459 = state_36227__$1;
(statearr_36269_36459[(2)] = inst_35928);

(statearr_36269_36459[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (48))){
var inst_36038 = (state_36227[(9)]);
var inst_36038__$1 = typeof from === 'string';
var state_36227__$1 = (function (){var statearr_36270 = state_36227;
(statearr_36270[(9)] = inst_36038__$1);

return statearr_36270;
})();
if(cljs.core.truth_(inst_36038__$1)){
var statearr_36271_36460 = state_36227__$1;
(statearr_36271_36460[(1)] = (61));

} else {
var statearr_36272_36461 = state_36227__$1;
(statearr_36272_36461[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (50))){
var inst_36004 = (state_36227[(26)]);
var inst_36006 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_36007 = cljs.core.comp.call(null,inst_36004,inst_36006);
var state_36227__$1 = state_36227;
var statearr_36273_36462 = state_36227__$1;
(statearr_36273_36462[(2)] = inst_36007);

(statearr_36273_36462[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (116))){
var state_36227__$1 = state_36227;
var statearr_36274_36463 = state_36227__$1;
(statearr_36274_36463[(2)] = null);

(statearr_36274_36463[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (75))){
var inst_36068 = cljs.core.PersistentHashMap.EMPTY;
var state_36227__$1 = state_36227;
var statearr_36275_36464 = state_36227__$1;
(statearr_36275_36464[(2)] = inst_36068);

(statearr_36275_36464[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (99))){
var inst_36129 = (state_36227[(10)]);
var state_36227__$1 = state_36227;
var statearr_36276_36465 = state_36227__$1;
(statearr_36276_36465[(2)] = inst_36129);

(statearr_36276_36465[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (21))){
var inst_35920 = (state_36227[(18)]);
var inst_35937 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35938 = cljs.core.second.call(null,inst_35920);
var inst_35939 = cljs.core.first.call(null,inst_35920);
var inst_35940 = [inst_35938,inst_35939];
var inst_35941 = (new cljs.core.PersistentVector(null,2,(5),inst_35937,inst_35940,null));
var state_36227__$1 = state_36227;
var statearr_36277_36466 = state_36227__$1;
(statearr_36277_36466[(2)] = inst_35941);

(statearr_36277_36466[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (31))){
var inst_35995 = (state_36227[(27)]);
var inst_35995__$1 = typeof from === 'string';
var state_36227__$1 = (function (){var statearr_36278 = state_36227;
(statearr_36278[(27)] = inst_35995__$1);

return statearr_36278;
})();
if(cljs.core.truth_(inst_35995__$1)){
var statearr_36279_36467 = state_36227__$1;
(statearr_36279_36467[(1)] = (44));

} else {
var statearr_36280_36468 = state_36227__$1;
(statearr_36280_36468[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (113))){
var state_36227__$1 = state_36227;
var statearr_36281_36469 = state_36227__$1;
(statearr_36281_36469[(2)] = null);

(statearr_36281_36469[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (32))){
var inst_35966 = (state_36227[(17)]);
var inst_36200 = (state_36227[(2)]);
var state_36227__$1 = (function (){var statearr_36282 = state_36227;
(statearr_36282[(28)] = inst_36200);

return statearr_36282;
})();
if(cljs.core.truth_(inst_35966)){
var statearr_36283_36470 = state_36227__$1;
(statearr_36283_36470[(1)] = (122));

} else {
var statearr_36284_36471 = state_36227__$1;
(statearr_36284_36471[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (40))){
var inst_35920 = (state_36227[(18)]);
var inst_35985 = (state_36227[(2)]);
var state_36227__$1 = (function (){var statearr_36285 = state_36227;
(statearr_36285[(29)] = inst_35985);

return statearr_36285;
})();
if(cljs.core.truth_(inst_35920)){
var statearr_36286_36472 = state_36227__$1;
(statearr_36286_36472[(1)] = (41));

} else {
var statearr_36287_36473 = state_36227__$1;
(statearr_36287_36473[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (129))){
var inst_36208 = (state_36227[(30)]);
var state_36227__$1 = state_36227;
var statearr_36288_36474 = state_36227__$1;
(statearr_36288_36474[(2)] = inst_36208);

(statearr_36288_36474[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (91))){
var inst_36111 = cljs.core.every_QMARK_.call(null,fluree.db.util.core.subj_ident_QMARK_,from);
var state_36227__$1 = state_36227;
var statearr_36289_36475 = state_36227__$1;
(statearr_36289_36475[(2)] = inst_36111);

(statearr_36289_36475[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (117))){
var inst_35923 = (state_36227[(15)]);
var state_36227__$1 = state_36227;
var statearr_36290_36476 = state_36227__$1;
(statearr_36290_36476[(2)] = inst_35923);

(statearr_36290_36476[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (108))){
var inst_36150 = (state_36227[(2)]);
var inst_36151 = fluree.db.util.async.throw_err.call(null,inst_36150);
var state_36227__$1 = state_36227;
var statearr_36291_36477 = state_36227__$1;
(statearr_36291_36477[(2)] = inst_36151);

(statearr_36291_36477[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (56))){
var inst_36018 = cljs.core.PersistentHashMap.EMPTY;
var state_36227__$1 = state_36227;
var statearr_36292_36478 = state_36227__$1;
(statearr_36292_36478[(2)] = inst_36018);

(statearr_36292_36478[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (33))){
var state_36227__$1 = state_36227;
var statearr_36293_36479 = state_36227__$1;
(statearr_36293_36479[(2)] = from);

(statearr_36293_36479[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (13))){
var inst_35907 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_35908 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_35909 = cljs.core.PersistentHashMap.fromArrays(inst_35907,inst_35908);
var inst_35910 = cljs.core.ex_info.call(null,"Query missing :select or :selectOne.",inst_35909);
var inst_35911 = (function(){throw inst_35910})();
var state_36227__$1 = state_36227;
var statearr_36294_36480 = state_36227__$1;
(statearr_36294_36480[(2)] = inst_35911);

(statearr_36294_36480[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (22))){
var inst_35920 = (state_36227[(18)]);
var inst_35943 = typeof inst_35920 === 'string';
var state_36227__$1 = state_36227;
if(cljs.core.truth_(inst_35943)){
var statearr_36295_36481 = state_36227__$1;
(statearr_36295_36481[(1)] = (24));

} else {
var statearr_36296_36482 = state_36227__$1;
(statearr_36296_36482[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (90))){
var inst_36102 = (state_36227[(31)]);
var inst_36107 = (state_36227[(2)]);
var state_36227__$1 = (function (){var statearr_36297 = state_36227;
(statearr_36297[(32)] = inst_36107);

return statearr_36297;
})();
var statearr_36298_36483 = state_36227__$1;
(statearr_36298_36483[(2)] = inst_36102);

(statearr_36298_36483[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (109))){
var inst_36129 = (state_36227[(10)]);
var inst_36153 = (state_36227[(23)]);
var inst_36155 = cljs.core.conj.call(null,inst_36129,inst_36153);
var state_36227__$1 = state_36227;
var statearr_36299_36484 = state_36227__$1;
(statearr_36299_36484[(2)] = inst_36155);

(statearr_36299_36484[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (36))){
var inst_35920 = (state_36227[(18)]);
var inst_35980 = (state_36227[(2)]);
var inst_35981 = fluree.db.util.async.throw_err.call(null,inst_35980);
var state_36227__$1 = (function (){var statearr_36300 = state_36227;
(statearr_36300[(33)] = inst_35981);

return statearr_36300;
})();
if(cljs.core.truth_(inst_35920)){
var statearr_36301_36485 = state_36227__$1;
(statearr_36301_36485[(1)] = (38));

} else {
var statearr_36302_36486 = state_36227__$1;
(statearr_36302_36486[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (41))){
var state_36227__$1 = state_36227;
var statearr_36303_36487 = state_36227__$1;
(statearr_36303_36487[(2)] = null);

(statearr_36303_36487[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (118))){
var inst_35933 = (state_36227[(7)]);
var inst_36165 = (state_36227[(34)]);
var inst_35931 = (state_36227[(8)]);
var inst_36169 = (state_36227[(35)]);
var inst_36173 = (state_36227[(2)]);
var inst_36174 = fluree.db.query.fql.subject_select.call(null,db,inst_35933,fuel,max_fuel,inst_35931,inst_36165,inst_36169,inst_36173);
var state_36227__$1 = state_36227;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36227__$1,(112),inst_36174);
} else {
if((state_val_36228 === (89))){
var state_36227__$1 = state_36227;
var statearr_36304_36488 = state_36227__$1;
(statearr_36304_36488[(2)] = null);

(statearr_36304_36488[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (100))){
var inst_36135 = (state_36227[(19)]);
var inst_36140 = cljs.core.int_QMARK_.call(null,inst_36135);
var state_36227__$1 = state_36227;
if(inst_36140){
var statearr_36305_36489 = state_36227__$1;
(statearr_36305_36489[(1)] = (102));

} else {
var statearr_36306_36490 = state_36227__$1;
(statearr_36306_36490[(1)] = (103));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (131))){
var inst_36205 = (state_36227[(11)]);
var inst_36219 = cljs.core.first.call(null,inst_36205);
var state_36227__$1 = state_36227;
var statearr_36307_36491 = state_36227__$1;
(statearr_36307_36491[(2)] = inst_36219);

(statearr_36307_36491[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (122))){
var inst_35921 = (state_36227[(13)]);
var inst_35923 = (state_36227[(15)]);
var inst_35967 = (state_36227[(16)]);
var inst_35966 = (state_36227[(17)]);
var inst_36200 = (state_36227[(28)]);
var inst_36202 = fluree.db.query.fql.sort_offset_and_limit_res.call(null,inst_35966,inst_35967,inst_35923,inst_35921,inst_36200);
var state_36227__$1 = state_36227;
var statearr_36308_36492 = state_36227__$1;
(statearr_36308_36492[(2)] = inst_36202);

(statearr_36308_36492[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (43))){
var inst_35933 = (state_36227[(7)]);
var inst_35931 = (state_36227[(8)]);
var inst_35985 = (state_36227[(29)]);
var inst_35981 = (state_36227[(33)]);
var inst_35989 = (state_36227[(2)]);
var inst_35990 = fluree.db.query.fql.subject_select.call(null,db,inst_35933,fuel,max_fuel,inst_35931,inst_35981,inst_35985,inst_35989);
var state_36227__$1 = state_36227;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36227__$1,(37),inst_35990);
} else {
if((state_val_36228 === (61))){
var inst_36040 = ["_tx",null,"_block",null];
var inst_36041 = (new cljs.core.PersistentArrayMap(null,2,inst_36040,null));
var inst_36042 = (new cljs.core.PersistentHashSet(null,inst_36041,null));
var inst_36043 = inst_36042.call(null,from);
var state_36227__$1 = state_36227;
var statearr_36309_36493 = state_36227__$1;
(statearr_36309_36493[(2)] = inst_36043);

(statearr_36309_36493[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (29))){
var inst_35955 = (state_36227[(2)]);
var state_36227__$1 = state_36227;
var statearr_36310_36494 = state_36227__$1;
(statearr_36310_36494[(2)] = inst_35955);

(statearr_36310_36494[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (44))){
var inst_35997 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_35998 = clojure.string.includes_QMARK_.call(null,inst_35997,"/");
var state_36227__$1 = state_36227;
var statearr_36311_36495 = state_36227__$1;
(statearr_36311_36495[(2)] = inst_35998);

(statearr_36311_36495[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (93))){
var inst_36114 = (state_36227[(2)]);
var state_36227__$1 = state_36227;
if(cljs.core.truth_(inst_36114)){
var statearr_36312_36496 = state_36227__$1;
(statearr_36312_36496[(1)] = (94));

} else {
var statearr_36313_36497 = state_36227__$1;
(statearr_36313_36497[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (6))){
var inst_35898 = (state_36227[(36)]);
var state_36227__$1 = state_36227;
var statearr_36314_36498 = state_36227__$1;
(statearr_36314_36498[(2)] = inst_35898);

(statearr_36314_36498[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (111))){
var inst_36136 = (state_36227[(37)]);
var inst_36158 = (state_36227[(2)]);
var inst_36128 = inst_36136;
var inst_36129 = inst_36158;
var state_36227__$1 = (function (){var statearr_36315 = state_36227;
(statearr_36315[(10)] = inst_36129);

(statearr_36315[(38)] = inst_36128);

return statearr_36315;
})();
var statearr_36316_36499 = state_36227__$1;
(statearr_36316_36499[(2)] = null);

(statearr_36316_36499[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (28))){
var state_36227__$1 = state_36227;
var statearr_36317_36500 = state_36227__$1;
(statearr_36317_36500[(2)] = null);

(statearr_36317_36500[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (64))){
var inst_35920 = (state_36227[(18)]);
var state_36227__$1 = state_36227;
if(cljs.core.truth_(inst_35920)){
var statearr_36318_36501 = state_36227__$1;
(statearr_36318_36501[(1)] = (67));

} else {
var statearr_36319_36502 = state_36227__$1;
(statearr_36319_36502[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (103))){
var state_36227__$1 = state_36227;
if(cljs.core.truth_(fuel)){
var statearr_36320_36503 = state_36227__$1;
(statearr_36320_36503[(1)] = (105));

} else {
var statearr_36321_36504 = state_36227__$1;
(statearr_36321_36504[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (51))){
var inst_36004 = (state_36227[(26)]);
var state_36227__$1 = state_36227;
var statearr_36322_36505 = state_36227__$1;
(statearr_36322_36505[(2)] = inst_36004);

(statearr_36322_36505[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (25))){
var state_36227__$1 = state_36227;
var statearr_36323_36506 = state_36227__$1;
(statearr_36323_36506[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (34))){
var state_36227__$1 = state_36227;
var statearr_36325_36507 = state_36227__$1;
(statearr_36325_36507[(2)] = null);

(statearr_36325_36507[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (125))){
var inst_36208 = (state_36227[(30)]);
var inst_36205 = (state_36227[(11)]);
var inst_36208__$1 = cljs.core.coll_QMARK_.call(null,inst_36205);
var state_36227__$1 = (function (){var statearr_36326 = state_36227;
(statearr_36326[(30)] = inst_36208__$1);

return statearr_36326;
})();
if(inst_36208__$1){
var statearr_36327_36508 = state_36227__$1;
(statearr_36327_36508[(1)] = (128));

} else {
var statearr_36328_36509 = state_36227__$1;
(statearr_36328_36509[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (17))){
var inst_35920 = (state_36227[(18)]);
var inst_35931 = (state_36227[(2)]);
var inst_35932 = cljs.core.PersistentHashMap.EMPTY;
var inst_35933 = cljs.core.volatile_BANG_.call(null,inst_35932);
var state_36227__$1 = (function (){var statearr_36329 = state_36227;
(statearr_36329[(7)] = inst_35933);

(statearr_36329[(8)] = inst_35931);

return statearr_36329;
})();
if(cljs.core.truth_(inst_35920)){
var statearr_36330_36510 = state_36227__$1;
(statearr_36330_36510[(1)] = (18));

} else {
var statearr_36331_36511 = state_36227__$1;
(statearr_36331_36511[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (3))){
var inst_36225 = (state_36227[(2)]);
var state_36227__$1 = state_36227;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36227__$1,inst_36225);
} else {
if((state_val_36228 === (12))){
var inst_35904 = (state_36227[(39)]);
var state_36227__$1 = state_36227;
var statearr_36332_36512 = state_36227__$1;
(statearr_36332_36512[(2)] = inst_35904);

(statearr_36332_36512[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (2))){
var inst_35898 = (state_36227[(36)]);
var _ = (function (){var statearr_36333 = state_36227;
(statearr_36333[(4)] = cljs.core.cons.call(null,(5),(state_36227[(4)])));

return statearr_36333;
})();
var inst_35898__$1 = select;
var state_36227__$1 = (function (){var statearr_36334 = state_36227;
(statearr_36334[(36)] = inst_35898__$1);

return statearr_36334;
})();
if(cljs.core.truth_(inst_35898__$1)){
var statearr_36335_36513 = state_36227__$1;
(statearr_36335_36513[(1)] = (6));

} else {
var statearr_36336_36514 = state_36227__$1;
(statearr_36336_36514[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (66))){
var inst_36196 = (state_36227[(2)]);
var state_36227__$1 = state_36227;
var statearr_36337_36515 = state_36227__$1;
(statearr_36337_36515[(2)] = inst_36196);

(statearr_36337_36515[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (107))){
var inst_36135 = (state_36227[(19)]);
var inst_36147 = (state_36227[(2)]);
var inst_36148 = fluree.db.dbproto._subid.call(null,db,inst_36135,false);
var state_36227__$1 = (function (){var statearr_36338 = state_36227;
(statearr_36338[(40)] = inst_36147);

return statearr_36338;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36227__$1,(108),inst_36148);
} else {
if((state_val_36228 === (23))){
var inst_35959 = (state_36227[(2)]);
var state_36227__$1 = state_36227;
var statearr_36339_36516 = state_36227__$1;
(statearr_36339_36516[(2)] = inst_35959);

(statearr_36339_36516[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (47))){
var inst_36004 = cljs.core.map.call(null,fluree.db.query.fql.s);
var state_36227__$1 = (function (){var statearr_36340 = state_36227;
(statearr_36340[(26)] = inst_36004);

return statearr_36340;
})();
if(cljs.core.truth_(fuel)){
var statearr_36341_36517 = state_36227__$1;
(statearr_36341_36517[(1)] = (50));

} else {
var statearr_36342_36518 = state_36227__$1;
(statearr_36342_36518[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (35))){
var inst_35921 = (state_36227[(13)]);
var inst_35923 = (state_36227[(15)]);
var inst_35974 = (state_36227[(2)]);
var inst_35975 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_35976 = [inst_35921,inst_35923];
var inst_35977 = cljs.core.PersistentHashMap.fromArrays(inst_35975,inst_35976);
var inst_35978 = fluree.db.query.fql.where_filter.call(null,db,where,inst_35974,inst_35977);
var state_36227__$1 = state_36227;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36227__$1,(36),inst_35978);
} else {
if((state_val_36228 === (127))){
var inst_36217 = (state_36227[(2)]);
var state_36227__$1 = state_36227;
if(cljs.core.truth_(inst_36217)){
var statearr_36343_36519 = state_36227__$1;
(statearr_36343_36519[(1)] = (131));

} else {
var statearr_36344_36520 = state_36227__$1;
(statearr_36344_36520[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (82))){
var inst_36192 = (state_36227[(2)]);
var state_36227__$1 = state_36227;
var statearr_36345_36521 = state_36227__$1;
(statearr_36345_36521[(2)] = inst_36192);

(statearr_36345_36521[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (76))){
var inst_35921 = (state_36227[(13)]);
var inst_35923 = (state_36227[(15)]);
var inst_36070 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_36071 = [inst_35921,inst_35923];
var inst_36072 = cljs.core.PersistentHashMap.fromArrays(inst_36070,inst_36071);
var state_36227__$1 = state_36227;
var statearr_36346_36522 = state_36227__$1;
(statearr_36346_36522[(2)] = inst_36072);

(statearr_36346_36522[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (97))){
var inst_36135 = (state_36227[(19)]);
var inst_36128 = (state_36227[(38)]);
var inst_36134 = cljs.core.seq.call(null,inst_36128);
var inst_36135__$1 = cljs.core.first.call(null,inst_36134);
var inst_36136 = cljs.core.next.call(null,inst_36134);
var inst_36137 = cljs.core.not.call(null,inst_36135__$1);
var state_36227__$1 = (function (){var statearr_36347 = state_36227;
(statearr_36347[(37)] = inst_36136);

(statearr_36347[(19)] = inst_36135__$1);

return statearr_36347;
})();
if(inst_36137){
var statearr_36348_36523 = state_36227__$1;
(statearr_36348_36523[(1)] = (99));

} else {
var statearr_36349_36524 = state_36227__$1;
(statearr_36349_36524[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (19))){
var inst_35961 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35962 = [null,null];
var inst_35963 = (new cljs.core.PersistentVector(null,2,(5),inst_35961,inst_35962,null));
var state_36227__$1 = state_36227;
var statearr_36350_36525 = state_36227__$1;
(statearr_36350_36525[(2)] = inst_35963);

(statearr_36350_36525[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (57))){
var inst_35921 = (state_36227[(13)]);
var inst_35923 = (state_36227[(15)]);
var inst_36020 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_36021 = [inst_35921,inst_35923];
var inst_36022 = cljs.core.PersistentHashMap.fromArrays(inst_36020,inst_36021);
var state_36227__$1 = state_36227;
var statearr_36351_36526 = state_36227__$1;
(statearr_36351_36526[(2)] = inst_36022);

(statearr_36351_36526[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (68))){
var inst_35921 = (state_36227[(13)]);
var inst_35923 = (state_36227[(15)]);
var inst_36051 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_36052 = [inst_35921,inst_35923];
var inst_36053 = cljs.core.PersistentHashMap.fromArrays(inst_36051,inst_36052);
var state_36227__$1 = state_36227;
var statearr_36352_36527 = state_36227__$1;
(statearr_36352_36527[(2)] = inst_36053);

(statearr_36352_36527[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (11))){
var inst_35915 = (state_36227[(2)]);
var state_36227__$1 = state_36227;
var statearr_36353_36528 = state_36227__$1;
(statearr_36353_36528[(2)] = inst_35915);

(statearr_36353_36528[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (115))){
var inst_35920 = (state_36227[(18)]);
var inst_36169 = (state_36227[(2)]);
var state_36227__$1 = (function (){var statearr_36355 = state_36227;
(statearr_36355[(35)] = inst_36169);

return statearr_36355;
})();
if(cljs.core.truth_(inst_35920)){
var statearr_36356_36529 = state_36227__$1;
(statearr_36356_36529[(1)] = (116));

} else {
var statearr_36357_36530 = state_36227__$1;
(statearr_36357_36530[(1)] = (117));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (9))){
var inst_35901 = (state_36227[(12)]);
var state_36227__$1 = state_36227;
var statearr_36358_36531 = state_36227__$1;
(statearr_36358_36531[(2)] = inst_35901);

(statearr_36358_36531[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (5))){
var _ = (function (){var statearr_36359 = state_36227;
(statearr_36359[(4)] = cljs.core.rest.call(null,(state_36227[(4)])));

return statearr_36359;
})();
var state_36227__$1 = state_36227;
var ex36354 = (state_36227__$1[(2)]);
var statearr_36360_36532 = state_36227__$1;
(statearr_36360_36532[(5)] = ex36354);


if((ex36354 instanceof Error)){
var statearr_36361_36533 = state_36227__$1;
(statearr_36361_36533[(1)] = (4));

(statearr_36361_36533[(5)] = null);

} else {
throw ex36354;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (112))){
var inst_36176 = (state_36227[(2)]);
var inst_36177 = fluree.db.util.async.throw_err.call(null,inst_36176);
var state_36227__$1 = state_36227;
var statearr_36362_36534 = state_36227__$1;
(statearr_36362_36534[(2)] = inst_36177);

(statearr_36362_36534[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (83))){
var inst_36090 = (state_36227[(20)]);
var inst_36089 = (state_36227[(2)]);
var inst_36090__$1 = fluree.db.util.async.throw_err.call(null,inst_36089);
var inst_36091 = (inst_36090__$1 == null);
var state_36227__$1 = (function (){var statearr_36363 = state_36227;
(statearr_36363[(20)] = inst_36090__$1);

return statearr_36363;
})();
if(cljs.core.truth_(inst_36091)){
var statearr_36364_36535 = state_36227__$1;
(statearr_36364_36535[(1)] = (84));

} else {
var statearr_36365_36536 = state_36227__$1;
(statearr_36365_36536[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (14))){
var inst_35913 = (state_36227[(2)]);
var state_36227__$1 = state_36227;
var statearr_36366_36537 = state_36227__$1;
(statearr_36366_36537[(2)] = inst_35913);

(statearr_36366_36537[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (45))){
var inst_35995 = (state_36227[(27)]);
var state_36227__$1 = state_36227;
var statearr_36367_36538 = state_36227__$1;
(statearr_36367_36538[(2)] = inst_35995);

(statearr_36367_36538[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (53))){
var inst_36010 = (state_36227[(21)]);
var inst_36012 = cljs.core.distinct.call(null);
var inst_36013 = cljs.core.comp.call(null,inst_36010,inst_36012);
var state_36227__$1 = state_36227;
var statearr_36368_36539 = state_36227__$1;
(statearr_36368_36539[(2)] = inst_36013);

(statearr_36368_36539[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (78))){
var inst_35933 = (state_36227[(7)]);
var inst_35931 = (state_36227[(8)]);
var inst_36077 = (state_36227[(2)]);
var inst_36078 = fluree.db.util.async.throw_err.call(null,inst_36077);
var inst_36079 = fluree.db.query.fql.flake_select.call(null,db,inst_35933,fuel,max_fuel,inst_35931,inst_36078);
var state_36227__$1 = state_36227;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36227__$1,(79),inst_36079);
} else {
if((state_val_36228 === (132))){
var inst_36205 = (state_36227[(11)]);
var state_36227__$1 = state_36227;
var statearr_36369_36540 = state_36227__$1;
(statearr_36369_36540[(2)] = inst_36205);

(statearr_36369_36540[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (26))){
var inst_35957 = (state_36227[(2)]);
var state_36227__$1 = state_36227;
var statearr_36370_36541 = state_36227__$1;
(statearr_36370_36541[(2)] = inst_35957);

(statearr_36370_36541[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (123))){
var inst_36200 = (state_36227[(28)]);
var state_36227__$1 = state_36227;
var statearr_36371_36542 = state_36227__$1;
(statearr_36371_36542[(2)] = inst_36200);

(statearr_36371_36542[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (16))){
var inst_35924 = (state_36227[(25)]);
var state_36227__$1 = state_36227;
var statearr_36372_36543 = state_36227__$1;
(statearr_36372_36543[(2)] = inst_35924);

(statearr_36372_36543[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (133))){
var inst_36222 = (state_36227[(2)]);
var _ = (function (){var statearr_36373 = state_36227;
(statearr_36373[(4)] = cljs.core.rest.call(null,(state_36227[(4)])));

return statearr_36373;
})();
var state_36227__$1 = state_36227;
var statearr_36374_36544 = state_36227__$1;
(statearr_36374_36544[(2)] = inst_36222);

(statearr_36374_36544[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (81))){
var inst_36109 = (state_36227[(22)]);
var inst_36109__$1 = cljs.core.sequential_QMARK_.call(null,from);
var state_36227__$1 = (function (){var statearr_36375 = state_36227;
(statearr_36375[(22)] = inst_36109__$1);

return statearr_36375;
})();
if(inst_36109__$1){
var statearr_36376_36545 = state_36227__$1;
(statearr_36376_36545[(1)] = (91));

} else {
var statearr_36377_36546 = state_36227__$1;
(statearr_36377_36546[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (120))){
var state_36227__$1 = state_36227;
var statearr_36378_36547 = state_36227__$1;
(statearr_36378_36547[(2)] = null);

(statearr_36378_36547[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (79))){
var inst_36081 = (state_36227[(2)]);
var inst_36082 = fluree.db.util.async.throw_err.call(null,inst_36081);
var state_36227__$1 = state_36227;
var statearr_36379_36548 = state_36227__$1;
(statearr_36379_36548[(2)] = inst_36082);

(statearr_36379_36548[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (38))){
var state_36227__$1 = state_36227;
var statearr_36380_36549 = state_36227__$1;
(statearr_36380_36549[(2)] = null);

(statearr_36380_36549[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (126))){
var inst_36206 = (state_36227[(41)]);
var state_36227__$1 = state_36227;
var statearr_36381_36550 = state_36227__$1;
(statearr_36381_36550[(2)] = inst_36206);

(statearr_36381_36550[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (98))){
var inst_35920 = (state_36227[(18)]);
var inst_36163 = (state_36227[(2)]);
var inst_36164 = cljs.core.PersistentVector.EMPTY;
var inst_36165 = cljs.core.into.call(null,inst_36164,inst_36163);
var state_36227__$1 = (function (){var statearr_36382 = state_36227;
(statearr_36382[(34)] = inst_36165);

return statearr_36382;
})();
if(cljs.core.truth_(inst_35920)){
var statearr_36383_36551 = state_36227__$1;
(statearr_36383_36551[(1)] = (113));

} else {
var statearr_36384_36552 = state_36227__$1;
(statearr_36384_36552[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (124))){
var inst_36206 = (state_36227[(41)]);
var inst_36205 = (state_36227[(2)]);
var inst_36206__$1 = selectOne;
var state_36227__$1 = (function (){var statearr_36385 = state_36227;
(statearr_36385[(41)] = inst_36206__$1);

(statearr_36385[(11)] = inst_36205);

return statearr_36385;
})();
if(cljs.core.truth_(inst_36206__$1)){
var statearr_36386_36553 = state_36227__$1;
(statearr_36386_36553[(1)] = (125));

} else {
var statearr_36387_36554 = state_36227__$1;
(statearr_36387_36554[(1)] = (126));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (87))){
var inst_36101 = (state_36227[(2)]);
var inst_36102 = fluree.db.util.async.throw_err.call(null,inst_36101);
var state_36227__$1 = (function (){var statearr_36388 = state_36227;
(statearr_36388[(31)] = inst_36102);

return statearr_36388;
})();
if(cljs.core.truth_(fuel)){
var statearr_36389_36555 = state_36227__$1;
(statearr_36389_36555[(1)] = (88));

} else {
var statearr_36390_36556 = state_36227__$1;
(statearr_36390_36556[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (30))){
var inst_35970 = typeof from === 'string';
var state_36227__$1 = state_36227;
if(cljs.core.truth_(inst_35970)){
var statearr_36391_36557 = state_36227__$1;
(statearr_36391_36557[(1)] = (33));

} else {
var statearr_36392_36558 = state_36227__$1;
(statearr_36392_36558[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (73))){
var inst_36084 = fluree.db.util.core.subj_ident_QMARK_.call(null,from);
var state_36227__$1 = state_36227;
if(inst_36084){
var statearr_36393_36559 = state_36227__$1;
(statearr_36393_36559[(1)] = (80));

} else {
var statearr_36394_36560 = state_36227__$1;
(statearr_36394_36560[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (96))){
var inst_36190 = (state_36227[(2)]);
var state_36227__$1 = state_36227;
var statearr_36395_36561 = state_36227__$1;
(statearr_36395_36561[(2)] = inst_36190);

(statearr_36395_36561[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (10))){
var inst_35904 = (state_36227[(39)]);
var inst_35904__$1 = selectDistinct;
var state_36227__$1 = (function (){var statearr_36396 = state_36227;
(statearr_36396[(39)] = inst_35904__$1);

return statearr_36396;
})();
if(cljs.core.truth_(inst_35904__$1)){
var statearr_36397_36562 = state_36227__$1;
(statearr_36397_36562[(1)] = (12));

} else {
var statearr_36398_36563 = state_36227__$1;
(statearr_36398_36563[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (18))){
var inst_35920 = (state_36227[(18)]);
var inst_35935 = cljs.core.vector_QMARK_.call(null,inst_35920);
var state_36227__$1 = state_36227;
if(inst_35935){
var statearr_36399_36564 = state_36227__$1;
(statearr_36399_36564[(1)] = (21));

} else {
var statearr_36400_36565 = state_36227__$1;
(statearr_36400_36565[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (105))){
var inst_36144 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core.inc);
var state_36227__$1 = state_36227;
var statearr_36401_36566 = state_36227__$1;
(statearr_36401_36566[(2)] = inst_36144);

(statearr_36401_36566[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (52))){
var inst_36010 = (state_36227[(2)]);
var state_36227__$1 = (function (){var statearr_36402 = state_36227;
(statearr_36402[(21)] = inst_36010);

return statearr_36402;
})();
var statearr_36403_36567 = state_36227__$1;
(statearr_36403_36567[(1)] = (53));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (114))){
var inst_35921 = (state_36227[(13)]);
var state_36227__$1 = state_36227;
var statearr_36405_36568 = state_36227__$1;
(statearr_36405_36568[(2)] = inst_35921);

(statearr_36405_36568[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (67))){
var inst_36049 = cljs.core.PersistentHashMap.EMPTY;
var state_36227__$1 = state_36227;
var statearr_36406_36569 = state_36227__$1;
(statearr_36406_36569[(2)] = inst_36049);

(statearr_36406_36569[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (71))){
var inst_36062 = (state_36227[(2)]);
var inst_36063 = fluree.db.util.async.throw_err.call(null,inst_36062);
var state_36227__$1 = state_36227;
var statearr_36407_36570 = state_36227__$1;
(statearr_36407_36570[(2)] = inst_36063);

(statearr_36407_36570[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (42))){
var inst_35923 = (state_36227[(15)]);
var state_36227__$1 = state_36227;
var statearr_36408_36571 = state_36227__$1;
(statearr_36408_36571[(2)] = inst_35923);

(statearr_36408_36571[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (80))){
var inst_36087 = fluree.db.dbproto._subid.call(null,db,from,false);
var state_36227__$1 = state_36227;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36227__$1,(83),inst_36087);
} else {
if((state_val_36228 === (37))){
var inst_35992 = (state_36227[(2)]);
var inst_35993 = fluree.db.util.async.throw_err.call(null,inst_35992);
var state_36227__$1 = state_36227;
var statearr_36409_36572 = state_36227__$1;
(statearr_36409_36572[(2)] = inst_35993);

(statearr_36409_36572[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (63))){
var inst_36046 = (state_36227[(2)]);
var state_36227__$1 = state_36227;
if(cljs.core.truth_(inst_36046)){
var statearr_36410_36573 = state_36227__$1;
(statearr_36410_36573[(1)] = (64));

} else {
var statearr_36411_36574 = state_36227__$1;
(statearr_36411_36574[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (94))){
var inst_36123 = from;
var inst_36124 = cljs.core.seq.call(null,inst_36123);
var inst_36125 = cljs.core.first.call(null,inst_36124);
var inst_36126 = cljs.core.next.call(null,inst_36124);
var inst_36127 = cljs.core.PersistentVector.EMPTY;
var inst_36128 = inst_36123;
var inst_36129 = inst_36127;
var state_36227__$1 = (function (){var statearr_36412 = state_36227;
(statearr_36412[(42)] = inst_36126);

(statearr_36412[(10)] = inst_36129);

(statearr_36412[(43)] = inst_36125);

(statearr_36412[(38)] = inst_36128);

return statearr_36412;
})();
var statearr_36413_36575 = state_36227__$1;
(statearr_36413_36575[(2)] = null);

(statearr_36413_36575[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (8))){
var inst_35922 = (state_36227[(24)]);
var inst_35917 = (state_36227[(2)]);
var inst_35918 = opts_SINGLEQUOTE_;
var inst_35919 = cljs.core.__destructure_map.call(null,inst_35918);
var inst_35920 = cljs.core.get.call(null,inst_35919,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_35921 = cljs.core.get.call(null,inst_35919,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_35922__$1 = cljs.core.get.call(null,inst_35919,new cljs.core.Keyword(null,"component","component",1555936782));
var inst_35923 = cljs.core.get.call(null,inst_35919,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_35924 = fluree.db.query.fql_parser.parse_db.call(null,db,inst_35917,opts_SINGLEQUOTE_);
var inst_35925 = (inst_35922__$1 == null);
var inst_35926 = cljs.core.not.call(null,inst_35925);
var state_36227__$1 = (function (){var statearr_36414 = state_36227;
(statearr_36414[(13)] = inst_35921);

(statearr_36414[(18)] = inst_35920);

(statearr_36414[(15)] = inst_35923);

(statearr_36414[(24)] = inst_35922__$1);

(statearr_36414[(25)] = inst_35924);

return statearr_36414;
})();
if(inst_35926){
var statearr_36415_36576 = state_36227__$1;
(statearr_36415_36576[(1)] = (15));

} else {
var statearr_36416_36577 = state_36227__$1;
(statearr_36416_36577[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (49))){
var inst_36198 = (state_36227[(2)]);
var state_36227__$1 = state_36227;
var statearr_36417_36578 = state_36227__$1;
(statearr_36417_36578[(2)] = inst_36198);

(statearr_36417_36578[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36228 === (84))){
var state_36227__$1 = state_36227;
var statearr_36418_36579 = state_36227__$1;
(statearr_36418_36579[(2)] = null);

(statearr_36418_36579[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__10903__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__10903__auto____0 = (function (){
var statearr_36419 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36419[(0)] = fluree$db$query$fql$query_$_state_machine__10903__auto__);

(statearr_36419[(1)] = (1));

return statearr_36419;
});
var fluree$db$query$fql$query_$_state_machine__10903__auto____1 = (function (state_36227){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_36227);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e36420){var ex__10906__auto__ = e36420;
var statearr_36421_36580 = state_36227;
(statearr_36421_36580[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_36227[(4)]))){
var statearr_36422_36581 = state_36227;
(statearr_36422_36581[(1)] = cljs.core.first.call(null,(state_36227[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36582 = state_36227;
state_36227 = G__36582;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__10903__auto__ = function(state_36227){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__10903__auto____1.call(this,state_36227);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__10903__auto____0;
fluree$db$query$fql$query_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__10903__auto____1;
return fluree$db$query$fql$query_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_36423 = f__10977__auto__.call(null);
(statearr_36423[(6)] = c__10976__auto__);

return statearr_36423;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}

});
