// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.call(null,(function (value_group){
var stringified = cljs.core.map.call(null,(function (p1__29949_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__29949_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.call(null," ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.call(null," ",value_groups);
return ["VALUES ( ",clojure.string.join.call(null," ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__29953 = coll;
var vec__29954 = G__29953;
var seq__29955 = cljs.core.seq.call(null,vec__29954);
var first__29956 = cljs.core.first.call(null,seq__29955);
var seq__29955__$1 = cljs.core.next.call(null,seq__29955);
var clause = first__29956;
var r = seq__29955__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__29953__$1 = G__29953;
var res__$1 = res;
while(true){
var vec__29960 = G__29953__$1;
var seq__29961 = cljs.core.seq.call(null,vec__29960);
var first__29962 = cljs.core.first.call(null,seq__29961);
var seq__29961__$1 = cljs.core.next.call(null,seq__29961);
var clause__$1 = first__29962;
var r__$1 = seq__29961__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__29963 = r__$1;
var G__29964 = cljs.core.conj.call(null,res__$2,clause__$1);
G__29953__$1 = G__29963;
res__$1 = G__29964;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.call(null,(function (res,p__29965){
var map__29966 = p__29965;
var map__29966__$1 = cljs.core.__destructure_map.call(null,map__29966);
var optional = cljs.core.get.call(null,map__29966__$1,new cljs.core.Keyword(null,"optional","optional",2053951509));
if(cljs.core.truth_(optional)){
return cljs.core.into.call(null,res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__29970 = coll;
var vec__29971 = G__29970;
var seq__29972 = cljs.core.seq.call(null,vec__29971);
var first__29973 = cljs.core.first.call(null,seq__29972);
var seq__29972__$1 = cljs.core.next.call(null,seq__29972);
var clause = first__29973;
var r = seq__29972__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__29970__$1 = G__29970;
var res__$1 = res;
while(true){
var vec__29977 = G__29970__$1;
var seq__29978 = cljs.core.seq.call(null,vec__29977);
var first__29979 = cljs.core.first.call(null,seq__29978);
var seq__29978__$1 = cljs.core.next.call(null,seq__29978);
var clause__$1 = first__29979;
var r__$1 = seq__29978__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__29980 = r__$1;
var G__29981 = cljs.core.conj.call(null,res__$2,cljs.core.rest.call(null,clause__$1));
G__29970__$1 = G__29980;
res__$1 = G__29981;
continue;
} else {
var G__29982 = r__$1;
var G__29983 = res__$2;
G__29970__$1 = G__29982;
res__$1 = G__29983;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__29987 = coll;
var vec__29988 = G__29987;
var seq__29989 = cljs.core.seq.call(null,vec__29988);
var first__29990 = cljs.core.first.call(null,seq__29989);
var seq__29989__$1 = cljs.core.next.call(null,seq__29989);
var clause = first__29990;
var r = seq__29989__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__29987__$1 = G__29987;
var res__$1 = res;
while(true){
var vec__29994 = G__29987__$1;
var seq__29995 = cljs.core.seq.call(null,vec__29994);
var first__29996 = cljs.core.first.call(null,seq__29995);
var seq__29995__$1 = cljs.core.next.call(null,seq__29995);
var clause__$1 = first__29996;
var r__$1 = seq__29995__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__29997 = r__$1;
var G__29998 = res__$2;
G__29987__$1 = G__29997;
res__$1 = G__29998;
continue;
} else {
var G__29999 = r__$1;
var G__30000 = cljs.core.conj.call(null,res__$2,clause__$1);
G__29987__$1 = G__29999;
res__$1 = G__30000;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__30003 = clause;
var G__30003__$1 = ((cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause)))?cljs.core.drop.call(null,(1),G__30003):G__30003);
var G__30003__$2 = clojure.string.join.call(null," ",G__30003__$1)
;
var G__30003__$3 = (function (p1__30001_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__30001_SHARP_)," ."].join('');
}).call(null,G__30003__$2)
;
if(cljs.core.truth_(optional_QMARK_)){
return (function (p1__30002_SHARP_){
return ["OPTIONAL {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__30002_SHARP_),"}"].join('');
}).call(null,G__30003__$3);
} else {
return G__30003__$3;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.call(null,(function (acc_str,prefix){
var pfx = cljs.core.symbol.call(null,[fluree.db.util.core.keyword__GT_str.call(null,cljs.core.key.call(null,prefix)),":"].join(''));
var source = cljs.core.symbol.call(null,cljs.core.val.call(null,prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map));
var map__30007 = opts;
var map__30007__$1 = cljs.core.__destructure_map.call(null,map__30007);
var limit = cljs.core.get.call(null,map__30007__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__30007__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.call(null,map__30007__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.call(null,map__30007__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.call(null,map__30007__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes.call(null,prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.call(null," ",cljs.core.map.call(null,(function (p1__30004_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__30004_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.call(null," ",select_vars)].join('');
var where_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__30005_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__30005_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__30006_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__30006_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4253__auto__ = language;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_30021){
var state_val_30022 = (state_30021[(1)]);
if((state_val_30022 === (1))){
var inst_30008 = fluree.db.util.core.url_encode.call(null,query);
var inst_30009 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_30008)].join('');
var inst_30010 = ["User-Agent","Accept"];
var inst_30011 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_30012 = cljs.core.PersistentHashMap.fromArrays(inst_30010,inst_30011);
var inst_30013 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_30014 = [inst_30012,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_30015 = cljs.core.PersistentHashMap.fromArrays(inst_30013,inst_30014);
var inst_30016 = fluree.db.util.xhttp.get.call(null,inst_30009,inst_30015);
var state_30021__$1 = state_30021;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30021__$1,(2),inst_30016);
} else {
if((state_val_30022 === (2))){
var inst_30018 = (state_30021[(2)]);
var inst_30019 = fluree.db.util.async.throw_err.call(null,inst_30018);
var state_30021__$1 = state_30021;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30021__$1,inst_30019);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10903__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10903__auto____0 = (function (){
var statearr_30023 = [null,null,null,null,null,null,null];
(statearr_30023[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10903__auto__);

(statearr_30023[(1)] = (1));

return statearr_30023;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10903__auto____1 = (function (state_30021){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_30021);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e30024){var ex__10906__auto__ = e30024;
var statearr_30025_30028 = state_30021;
(statearr_30025_30028[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_30021[(4)]))){
var statearr_30026_30029 = state_30021;
(statearr_30026_30029[(1)] = cljs.core.first.call(null,(state_30021[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30030 = state_30021;
state_30021 = G__30030;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10903__auto__ = function(state_30021){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10903__auto____1.call(this,state_30021);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10903__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10903__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_30027 = f__10977__auto__.call(null);
(statearr_30027[(6)] = c__10976__auto__);

return statearr_30027;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_30048){
var state_val_30049 = (state_30048[(1)]);
if((state_val_30049 === (1))){
var inst_30031 = fluree.db.query.analytical_wikidata.submit_wikidata_query.call(null,query);
var state_30048__$1 = state_30048;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30048__$1,(2),inst_30031);
} else {
if((state_val_30049 === (2))){
var inst_30034 = (state_30048[(7)]);
var inst_30033 = (state_30048[(2)]);
var inst_30034__$1 = fluree.db.util.async.throw_err.call(null,inst_30033);
var inst_30035 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_30034__$1);
var inst_30036 = cljs.core.not_EQ_.call(null,(200),inst_30035);
var state_30048__$1 = (function (){var statearr_30050 = state_30048;
(statearr_30050[(7)] = inst_30034__$1);

return statearr_30050;
})();
if(inst_30036){
var statearr_30051_30060 = state_30048__$1;
(statearr_30051_30060[(1)] = (3));

} else {
var statearr_30052_30061 = state_30048__$1;
(statearr_30052_30061[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30049 === (3))){
var inst_30034 = (state_30048[(7)]);
var state_30048__$1 = state_30048;
var statearr_30053_30062 = state_30048__$1;
(statearr_30053_30062[(2)] = inst_30034);

(statearr_30053_30062[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30049 === (4))){
var inst_30034 = (state_30048[(7)]);
var inst_30039 = (function (){var body = inst_30034;
return (function (item){
return cljs.core.reduce.call(null,(function (acc,k_v){
return cljs.core.assoc.call(null,acc,cljs.core.key.call(null,k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_30040 = cljs.core.second.call(null,inst_30034);
var inst_30041 = cljs.core.second.call(null,inst_30040);
var inst_30042 = cljs.core.first.call(null,inst_30041);
var inst_30043 = cljs.core.second.call(null,inst_30042);
var inst_30044 = cljs.core.mapv.call(null,inst_30039,inst_30043);
var state_30048__$1 = state_30048;
var statearr_30054_30063 = state_30048__$1;
(statearr_30054_30063[(2)] = inst_30044);

(statearr_30054_30063[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30049 === (5))){
var inst_30046 = (state_30048[(2)]);
var state_30048__$1 = state_30048;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30048__$1,inst_30046);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10903__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10903__auto____0 = (function (){
var statearr_30055 = [null,null,null,null,null,null,null,null];
(statearr_30055[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10903__auto__);

(statearr_30055[(1)] = (1));

return statearr_30055;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10903__auto____1 = (function (state_30048){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_30048);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e30056){var ex__10906__auto__ = e30056;
var statearr_30057_30064 = state_30048;
(statearr_30057_30064[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_30048[(4)]))){
var statearr_30058_30065 = state_30048;
(statearr_30058_30065[(1)] = cljs.core.first.call(null,(state_30048[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30066 = state_30048;
state_30048 = G__30066;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10903__auto__ = function(state_30048){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10903__auto____1.call(this,state_30048);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10903__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10903__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_30059 = f__10977__auto__.call(null);
(statearr_30059[(6)] = c__10976__auto__);

return statearr_30059;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.call(null,(function (p1__30067_SHARP_){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__30067_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.call(null,cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.call(null,(function (p1__30068_SHARP_){
return fluree.db.util.core.str__GT_keyword.call(null,cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__30068_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.call(null,(function (res){
return cljs.core.map.call(null,(function (p1__30069_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(p1__30069_SHARP_.call(null,res));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_30115){
var state_val_30116 = (state_30115[(1)]);
if((state_val_30116 === (7))){
var inst_30080 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt.call(null,matching_vars,matching_vals);
var state_30115__$1 = state_30115;
var statearr_30117_30145 = state_30115__$1;
(statearr_30117_30145[(2)] = inst_30080);

(statearr_30117_30145[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30116 === (1))){
var state_30115__$1 = state_30115;
var statearr_30118_30146 = state_30115__$1;
(statearr_30118_30146[(2)] = null);

(statearr_30118_30146[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30116 === (4))){
var inst_30070 = (state_30115[(2)]);
var state_30115__$1 = state_30115;
var statearr_30119_30147 = state_30115__$1;
(statearr_30119_30147[(2)] = inst_30070);

(statearr_30119_30147[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30116 === (15))){
var inst_30089 = (state_30115[(7)]);
var inst_30088 = (state_30115[(8)]);
var inst_30094 = (state_30115[(9)]);
var inst_30099 = (state_30115[(2)]);
var inst_30100 = cljs.core.subs.call(null,inst_30094,(0),inst_30099);
var inst_30101 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30102 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_30088);
var inst_30103 = [inst_30089,inst_30102];
var inst_30104 = cljs.core.PersistentHashMap.fromArrays(inst_30101,inst_30103);
var inst_30105 = cljs.core.ex_info.call(null,inst_30100,inst_30104);
var inst_30106 = (function(){throw inst_30105})();
var state_30115__$1 = state_30115;
var statearr_30120_30148 = state_30115__$1;
(statearr_30120_30148[(2)] = inst_30106);

(statearr_30120_30148[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30116 === (13))){
var inst_30093 = (state_30115[(10)]);
var state_30115__$1 = state_30115;
var statearr_30121_30149 = state_30115__$1;
(statearr_30121_30149[(2)] = inst_30093);

(statearr_30121_30149[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30116 === (6))){
var state_30115__$1 = state_30115;
var statearr_30122_30150 = state_30115__$1;
(statearr_30122_30150[(2)] = null);

(statearr_30122_30150[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30116 === (3))){
var inst_30113 = (state_30115[(2)]);
var state_30115__$1 = state_30115;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30115__$1,inst_30113);
} else {
if((state_val_30116 === (12))){
var inst_30110 = (state_30115[(2)]);
var _ = (function (){var statearr_30123 = state_30115;
(statearr_30123[(4)] = cljs.core.rest.call(null,(state_30115[(4)])));

return statearr_30123;
})();
var state_30115__$1 = state_30115;
var statearr_30124_30151 = state_30115__$1;
(statearr_30124_30151[(2)] = inst_30110);

(statearr_30124_30151[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30116 === (2))){
var _ = (function (){var statearr_30125 = state_30115;
(statearr_30125[(4)] = cljs.core.cons.call(null,(5),(state_30115[(4)])));

return statearr_30125;
})();
var inst_30077 = cljs.core.empty_QMARK_.call(null,matching_vars);
var state_30115__$1 = state_30115;
if(inst_30077){
var statearr_30126_30152 = state_30115__$1;
(statearr_30126_30152[(1)] = (6));

} else {
var statearr_30127_30153 = state_30115__$1;
(statearr_30127_30153[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30116 === (11))){
var inst_30088 = (state_30115[(8)]);
var inst_30108 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples.call(null,inst_30088,all_vars);
var state_30115__$1 = state_30115;
var statearr_30129_30154 = state_30115__$1;
(statearr_30129_30154[(2)] = inst_30108);

(statearr_30129_30154[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30116 === (9))){
var inst_30089 = (state_30115[(7)]);
var inst_30088 = (state_30115[(8)]);
var inst_30086 = (state_30115[(2)]);
var inst_30087 = fluree.db.util.async.throw_err.call(null,inst_30086);
var inst_30088__$1 = cljs.core.__destructure_map.call(null,inst_30087);
var inst_30089__$1 = cljs.core.get.call(null,inst_30088__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_30090 = cljs.core.get.call(null,inst_30088__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_30091 = cljs.core._EQ_.call(null,(400),inst_30089__$1);
var state_30115__$1 = (function (){var statearr_30130 = state_30115;
(statearr_30130[(11)] = inst_30090);

(statearr_30130[(7)] = inst_30089__$1);

(statearr_30130[(8)] = inst_30088__$1);

return statearr_30130;
})();
if(inst_30091){
var statearr_30131_30155 = state_30115__$1;
(statearr_30131_30155[(1)] = (10));

} else {
var statearr_30132_30156 = state_30115__$1;
(statearr_30132_30156[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30116 === (5))){
var _ = (function (){var statearr_30133 = state_30115;
(statearr_30133[(4)] = cljs.core.rest.call(null,(state_30115[(4)])));

return statearr_30133;
})();
var state_30115__$1 = state_30115;
var ex30128 = (state_30115__$1[(2)]);
var statearr_30134_30157 = state_30115__$1;
(statearr_30134_30157[(5)] = ex30128);


if((ex30128 instanceof Error)){
var statearr_30135_30158 = state_30115__$1;
(statearr_30135_30158[(1)] = (4));

(statearr_30135_30158[(5)] = null);

} else {
throw ex30128;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30116 === (14))){
var state_30115__$1 = state_30115;
var statearr_30136_30159 = state_30115__$1;
(statearr_30136_30159[(2)] = (1000));

(statearr_30136_30159[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30116 === (10))){
var inst_30090 = (state_30115[(11)]);
var inst_30093 = (state_30115[(10)]);
var inst_30088 = (state_30115[(8)]);
var inst_30093__$1 = cljs.core.count.call(null,inst_30090);
var inst_30094 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_30088);
var inst_30095 = (inst_30093__$1 < (1000));
var state_30115__$1 = (function (){var statearr_30137 = state_30115;
(statearr_30137[(10)] = inst_30093__$1);

(statearr_30137[(9)] = inst_30094);

return statearr_30137;
})();
if(cljs.core.truth_(inst_30095)){
var statearr_30138_30160 = state_30115__$1;
(statearr_30138_30160[(1)] = (13));

} else {
var statearr_30139_30161 = state_30115__$1;
(statearr_30139_30161[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30116 === (8))){
var inst_30082 = (state_30115[(2)]);
var inst_30083 = fluree.db.query.analytical_wikidata.generateWikiDataQuery.call(null,q_map,clauses,all_vars,inst_30082,optional_clauses);
var inst_30084 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query.call(null,inst_30083);
var state_30115__$1 = state_30115;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30115__$1,(9),inst_30084);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10903__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10903__auto____0 = (function (){
var statearr_30140 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30140[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10903__auto__);

(statearr_30140[(1)] = (1));

return statearr_30140;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10903__auto____1 = (function (state_30115){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_30115);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e30141){var ex__10906__auto__ = e30141;
var statearr_30142_30162 = state_30115;
(statearr_30142_30162[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_30115[(4)]))){
var statearr_30143_30163 = state_30115;
(statearr_30143_30163[(1)] = cljs.core.first.call(null,(state_30115[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30164 = state_30115;
state_30115 = G__30164;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10903__auto__ = function(state_30115){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10903__auto____1.call(this,state_30115);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10903__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10903__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_30144 = f__10977__auto__.call(null);
(statearr_30144[(6)] = c__10976__auto__);

return statearr_30144;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
