// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__28791 = arguments.length;
switch (G__28791) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.call(null,operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid.call(null));
var header = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"op","op",-1882987955),operation,new cljs.core.Keyword(null,"req-id","req-id",-471642231),req_id,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),fluree.db.util.core.current_time_millis.call(null),new cljs.core.Keyword(null,"timeout","timeout",-318625318),timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__28794 = arguments.length;
switch (G__28794) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.call(null,conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__10976__auto___28847 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_28825){
var state_val_28826 = (state_28825[(1)]);
if((state_val_28826 === (1))){
var state_28825__$1 = state_28825;
var statearr_28827_28848 = state_28825__$1;
(statearr_28827_28848[(2)] = null);

(statearr_28827_28848[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28826 === (2))){
var _ = (function (){var statearr_28828 = state_28825;
(statearr_28828[(4)] = cljs.core.cons.call(null,(5),(state_28825[(4)])));

return statearr_28828;
})();
var inst_28802 = fluree.db.operations.conn_closed_QMARK_.call(null,conn);
var state_28825__$1 = state_28825;
if(cljs.core.truth_(inst_28802)){
var statearr_28829_28849 = state_28825__$1;
(statearr_28829_28849[(1)] = (6));

} else {
var statearr_28830_28850 = state_28825__$1;
(statearr_28830_28850[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28826 === (3))){
var inst_28823 = (state_28825[(2)]);
var state_28825__$1 = state_28825;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28825__$1,inst_28823);
} else {
if((state_val_28826 === (4))){
var inst_28795 = (state_28825[(2)]);
var inst_28796 = cljs.core.async.put_BANG_.call(null,pc,inst_28795);
var state_28825__$1 = state_28825;
var statearr_28832_28851 = state_28825__$1;
(statearr_28832_28851[(2)] = inst_28796);

(statearr_28832_28851[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28826 === (5))){
var _ = (function (){var statearr_28833 = state_28825;
(statearr_28833[(4)] = cljs.core.rest.call(null,(state_28825[(4)])));

return statearr_28833;
})();
var state_28825__$1 = state_28825;
var ex28831 = (state_28825__$1[(2)]);
var statearr_28834_28852 = state_28825__$1;
(statearr_28834_28852[(5)] = ex28831);


var statearr_28835_28853 = state_28825__$1;
(statearr_28835_28853[(1)] = (4));

(statearr_28835_28853[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28826 === (6))){
var inst_28804 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28805 = [(400),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)];
var inst_28806 = cljs.core.PersistentHashMap.fromArrays(inst_28804,inst_28805);
var inst_28807 = cljs.core.ex_info.call(null,"Connection was closed.",inst_28806);
var inst_28808 = (function(){throw inst_28807})();
var state_28825__$1 = state_28825;
var statearr_28836_28854 = state_28825__$1;
(statearr_28836_28854[(2)] = inst_28808);

(statearr_28836_28854[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28826 === (7))){
var inst_28810 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_28811 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28812 = [operation,data,pc,opts];
var inst_28813 = (new cljs.core.PersistentVector(null,4,(5),inst_28811,inst_28812,null));
var inst_28814 = cljs.core.async.put_BANG_.call(null,inst_28810,inst_28813);
var inst_28815 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28816 = [operation,data,pc,opts];
var inst_28817 = (new cljs.core.PersistentVector(null,4,(5),inst_28815,inst_28816,null));
var inst_28818 = fluree.db.util.log.trace.call(null,"Put operation on connection req-chan: ",inst_28817);
var state_28825__$1 = (function (){var statearr_28837 = state_28825;
(statearr_28837[(7)] = inst_28814);

return statearr_28837;
})();
var statearr_28838_28855 = state_28825__$1;
(statearr_28838_28855[(2)] = inst_28818);

(statearr_28838_28855[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28826 === (8))){
var inst_28820 = (state_28825[(2)]);
var _ = (function (){var statearr_28839 = state_28825;
(statearr_28839[(4)] = cljs.core.rest.call(null,(state_28825[(4)])));

return statearr_28839;
})();
var state_28825__$1 = state_28825;
var statearr_28840_28856 = state_28825__$1;
(statearr_28840_28856[(2)] = inst_28820);

(statearr_28840_28856[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__10903__auto__ = null;
var fluree$db$operations$state_machine__10903__auto____0 = (function (){
var statearr_28841 = [null,null,null,null,null,null,null,null];
(statearr_28841[(0)] = fluree$db$operations$state_machine__10903__auto__);

(statearr_28841[(1)] = (1));

return statearr_28841;
});
var fluree$db$operations$state_machine__10903__auto____1 = (function (state_28825){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_28825);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e28842){var ex__10906__auto__ = e28842;
var statearr_28843_28857 = state_28825;
(statearr_28843_28857[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_28825[(4)]))){
var statearr_28844_28858 = state_28825;
(statearr_28844_28858[(1)] = cljs.core.first.call(null,(state_28825[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28859 = state_28825;
state_28825 = G__28859;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$operations$state_machine__10903__auto__ = function(state_28825){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__10903__auto____1.call(this,state_28825);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__10903__auto____0;
fluree$db$operations$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__10903__auto____1;
return fluree$db$operations$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_28845 = f__10977__auto__.call(null);
(statearr_28845[(6)] = c__10976__auto___28847);

return statearr_28845;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__28861 = arguments.length;
switch (G__28861) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.call(null,session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__28862){
var map__28863 = p__28862;
var map__28863__$1 = cljs.core.__destructure_map.call(null,map__28863);
var opts = map__28863__$1;
var snapshot_QMARK_ = cljs.core.get.call(null,map__28863__$1,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670));
var map__28864 = session;
var map__28864__$1 = cljs.core.__destructure_map.call(null,map__28864);
var dbid = cljs.core.get.call(null,map__28864__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var network = cljs.core.get.call(null,map__28864__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.call(null,map__28864__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"delete-db","delete-db",1646085839),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670),snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28891 = arguments.length;
var i__4865__auto___28892 = (0);
while(true){
if((i__4865__auto___28892 < len__4864__auto___28891)){
args__4870__auto__.push((arguments[i__4865__auto___28892]));

var G__28893 = (i__4865__auto___28892 + (1));
i__4865__auto___28892 = G__28893;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__28868){
var vec__28869 = p__28868;
var map__28872 = cljs.core.nth.call(null,vec__28869,(0),null);
var map__28872__$1 = cljs.core.__destructure_map.call(null,map__28872);
var toBlock = cljs.core.get.call(null,map__28872__$1,new cljs.core.Keyword(null,"toBlock","toBlock",1609458185));
var toTime = cljs.core.get.call(null,map__28872__$1,new cljs.core.Keyword(null,"toTime","toTime",903224641));
var opts = vec__28869;
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_28884){
var state_val_28885 = (state_28884[(1)]);
if((state_val_28885 === (1))){
var inst_28874 = session;
var inst_28875 = cljs.core.__destructure_map.call(null,inst_28874);
var inst_28876 = cljs.core.get.call(null,inst_28875,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_28877 = cljs.core.get.call(null,inst_28875,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_28878 = cljs.core.get.call(null,inst_28875,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_28879 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"toBlock","toBlock",1609458185),new cljs.core.Keyword(null,"toTime","toTime",903224641)];
var inst_28880 = [inst_28876,inst_28877,toBlock,toTime];
var inst_28881 = cljs.core.PersistentHashMap.fromArrays(inst_28879,inst_28880);
var inst_28882 = fluree.db.operations.send_operation.call(null,inst_28878,new cljs.core.Keyword(null,"garbage","garbage",-2063107600),inst_28881);
var state_28884__$1 = state_28884;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28884__$1,inst_28882);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__10903__auto__ = null;
var fluree$db$operations$state_machine__10903__auto____0 = (function (){
var statearr_28886 = [null,null,null,null,null,null,null];
(statearr_28886[(0)] = fluree$db$operations$state_machine__10903__auto__);

(statearr_28886[(1)] = (1));

return statearr_28886;
});
var fluree$db$operations$state_machine__10903__auto____1 = (function (state_28884){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_28884);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e28887){var ex__10906__auto__ = e28887;
var statearr_28888_28894 = state_28884;
(statearr_28888_28894[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_28884[(4)]))){
var statearr_28889_28895 = state_28884;
(statearr_28889_28895[(1)] = cljs.core.first.call(null,(state_28884[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28896 = state_28884;
state_28884 = G__28896;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$operations$state_machine__10903__auto__ = function(state_28884){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__10903__auto____1.call(this,state_28884);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__10903__auto____0;
fluree$db$operations$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__10903__auto____1;
return fluree$db$operations$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_28890 = f__10977__auto__.call(null);
(statearr_28890[(6)] = c__10976__auto__);

return statearr_28890;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq28866){
var G__28867 = cljs.core.first.call(null,seq28866);
var seq28866__$1 = cljs.core.next.call(null,seq28866);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28867,seq28866__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__28897 = session;
var map__28897__$1 = cljs.core.__destructure_map.call(null,map__28897);
var network = cljs.core.get.call(null,map__28897__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__28897__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var conn = cljs.core.get.call(null,map__28897__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"snapshot-db","snapshot-db",199417128),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"unsigned-cmd","unsigned-cmd",1466012010),unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-stats","ledger-stats",765646297),ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"db-list","db-list",230589843),null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.call(null,"Sending transaction async: ",tx_map);

return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"tx","tx",466630418),tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__28899 = arguments.length;
switch (G__28899) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.call(null,session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__28900 = opts;
var map__28900__$1 = cljs.core.__destructure_map.call(null,map__28900);
var auth = cljs.core.get.call(null,map__28900__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.call(null,map__28900__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4253__auto__ = auth;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.call(null,"Subscribe to: ",new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt);
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"subscribe","subscribe",416253756),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"unsbuscribe","unsbuscribe",888593047),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null));
});
