// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.call(null,["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__36585 = cljs.core.re_find.call(null,/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str.call(null,ledger));
var _ = cljs.core.nth.call(null,vec__36585,(0),null);
var network = cljs.core.nth.call(null,vec__36585,(1),null);
var maybe_alias = cljs.core.nth.call(null,vec__36585,(2),null);
if(cljs.core.truth_((function (){var and__4251__auto__ = network;
if(cljs.core.truth_(and__4251__auto__)){
return maybe_alias;
} else {
return and__4251__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__36588){
var map__36589 = p__36588;
var map__36589__$1 = cljs.core.__destructure_map.call(null,map__36589);
var opts = map__36589__$1;
var reindex_QMARK_ = cljs.core.get.call(null,map__36589__$1,new cljs.core.Keyword(null,"reindex?","reindex?",683464852));
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_36649){
var state_val_36650 = (state_36649[(1)]);
if((state_val_36650 === (7))){
var inst_36620 = cljs.core.not.call(null,reindex_QMARK_);
var state_36649__$1 = state_36649;
var statearr_36651_36675 = state_36649__$1;
(statearr_36651_36675[(2)] = inst_36620);

(statearr_36651_36675[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36650 === (1))){
var state_36649__$1 = state_36649;
var statearr_36652_36676 = state_36649__$1;
(statearr_36652_36676[(2)] = null);

(statearr_36652_36676[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36650 === (4))){
var inst_36590 = (state_36649[(2)]);
var state_36649__$1 = state_36649;
var statearr_36653_36677 = state_36649__$1;
(statearr_36653_36677[(2)] = inst_36590);

(statearr_36653_36677[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36650 === (6))){
var inst_36610 = (state_36649[(7)]);
var inst_36604 = (state_36649[(8)]);
var inst_36618 = (state_36649[(9)]);
var inst_36603 = (state_36649[(2)]);
var inst_36604__$1 = fluree.db.util.async.throw_err.call(null,inst_36603);
var inst_36605 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_36606 = cljs.core.__destructure_map.call(null,inst_36605);
var inst_36607 = cljs.core.get.call(null,inst_36606,new cljs.core.Keyword(null,"post","post",269697687));
var inst_36608 = cljs.core.get.call(null,inst_36606,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_36609 = fluree.db.flake.size_bytes.call(null,inst_36604__$1);
var inst_36610__$1 = (inst_36608 + inst_36609);
var inst_36611 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36612 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_36613 = (new cljs.core.PersistentVector(null,2,(5),inst_36611,inst_36612,null));
var inst_36614 = cljs.core.get_in.call(null,db,inst_36613);
var inst_36615 = cljs.core.__destructure_map.call(null,inst_36614);
var inst_36616 = cljs.core.get.call(null,inst_36615,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_36617 = cljs.core.get.call(null,inst_36615,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_36618__$1 = (inst_36610__$1 > inst_36617);
var state_36649__$1 = (function (){var statearr_36654 = state_36649;
(statearr_36654[(7)] = inst_36610__$1);

(statearr_36654[(10)] = inst_36616);

(statearr_36654[(11)] = inst_36607);

(statearr_36654[(8)] = inst_36604__$1);

(statearr_36654[(9)] = inst_36618__$1);

return statearr_36654;
})();
if(cljs.core.truth_(inst_36618__$1)){
var statearr_36655_36678 = state_36649__$1;
(statearr_36655_36678[(1)] = (7));

} else {
var statearr_36656_36679 = state_36649__$1;
(statearr_36656_36679[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36650 === (3))){
var inst_36647 = (state_36649[(2)]);
var state_36649__$1 = state_36649;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36649__$1,inst_36647);
} else {
if((state_val_36650 === (12))){
var inst_36610 = (state_36649[(7)]);
var inst_36607 = (state_36649[(11)]);
var inst_36604 = (state_36649[(8)]);
var inst_36633 = (state_36649[(2)]);
var inst_36634 = cljs.core.into.call(null,inst_36607,inst_36604);
var inst_36635 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_36636 = cljs.core.swap_BANG_.call(null,inst_36635,cljs.core.empty);
var inst_36637 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36638 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_36639 = (new cljs.core.PersistentVector(null,2,(5),inst_36637,inst_36638,null));
var inst_36640 = cljs.core.assoc_in.call(null,db,inst_36639,inst_36634);
var inst_36641 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36642 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_36643 = (new cljs.core.PersistentVector(null,2,(5),inst_36641,inst_36642,null));
var inst_36644 = cljs.core.assoc_in.call(null,inst_36640,inst_36643,inst_36610);
var _ = (function (){var statearr_36657 = state_36649;
(statearr_36657[(4)] = cljs.core.rest.call(null,(state_36649[(4)])));

return statearr_36657;
})();
var state_36649__$1 = (function (){var statearr_36658 = state_36649;
(statearr_36658[(12)] = inst_36636);

(statearr_36658[(13)] = inst_36633);

return statearr_36658;
})();
var statearr_36659_36680 = state_36649__$1;
(statearr_36659_36680[(2)] = inst_36644);

(statearr_36659_36680[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36650 === (2))){
var _ = (function (){var statearr_36660 = state_36649;
(statearr_36660[(4)] = cljs.core.cons.call(null,(5),(state_36649[(4)])));

return statearr_36660;
})();
var inst_36598 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36599 = [pred_id];
var inst_36600 = (new cljs.core.PersistentVector(null,1,(5),inst_36598,inst_36599,null));
var inst_36601 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_36600);
var state_36649__$1 = state_36649;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36649__$1,(6),inst_36601);
} else {
if((state_val_36650 === (11))){
var state_36649__$1 = state_36649;
var statearr_36662_36681 = state_36649__$1;
(statearr_36662_36681[(2)] = null);

(statearr_36662_36681[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36650 === (9))){
var inst_36623 = (state_36649[(2)]);
var state_36649__$1 = state_36649;
if(cljs.core.truth_(inst_36623)){
var statearr_36663_36682 = state_36649__$1;
(statearr_36663_36682[(1)] = (10));

} else {
var statearr_36664_36683 = state_36649__$1;
(statearr_36664_36683[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36650 === (5))){
var _ = (function (){var statearr_36665 = state_36649;
(statearr_36665[(4)] = cljs.core.rest.call(null,(state_36649[(4)])));

return statearr_36665;
})();
var state_36649__$1 = state_36649;
var ex36661 = (state_36649__$1[(2)]);
var statearr_36666_36684 = state_36649__$1;
(statearr_36666_36684[(5)] = ex36661);


if((ex36661 instanceof Error)){
var statearr_36667_36685 = state_36649__$1;
(statearr_36667_36685[(1)] = (4));

(statearr_36667_36685[(5)] = null);

} else {
throw ex36661;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36650 === (10))){
var inst_36625 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_36626 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_36627 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_36628 = cljs.core.PersistentHashMap.fromArrays(inst_36626,inst_36627);
var inst_36629 = cljs.core.ex_info.call(null,inst_36625,inst_36628);
var inst_36630 = (function(){throw inst_36629})();
var state_36649__$1 = state_36649;
var statearr_36668_36686 = state_36649__$1;
(statearr_36668_36686[(2)] = inst_36630);

(statearr_36668_36686[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36650 === (8))){
var inst_36618 = (state_36649[(9)]);
var state_36649__$1 = state_36649;
var statearr_36669_36687 = state_36649__$1;
(statearr_36669_36687[(2)] = inst_36618);

(statearr_36669_36687[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10903__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10903__auto____0 = (function (){
var statearr_36670 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36670[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10903__auto__);

(statearr_36670[(1)] = (1));

return statearr_36670;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10903__auto____1 = (function (state_36649){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_36649);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e36671){var ex__10906__auto__ = e36671;
var statearr_36672_36688 = state_36649;
(statearr_36672_36688[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_36649[(4)]))){
var statearr_36673_36689 = state_36649;
(statearr_36673_36689[(1)] = cljs.core.first.call(null,(state_36649[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36690 = state_36649;
state_36649 = G__36690;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10903__auto__ = function(state_36649){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10903__auto____1.call(this,state_36649);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10903__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10903__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_36674 = f__10977__auto__.call(null);
(statearr_36674[(6)] = c__10976__auto__);

return statearr_36674;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__36695 = arguments.length;
switch (G__36695) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.call(null,db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_36891){
var state_val_36892 = (state_36891[(1)]);
if((state_val_36892 === (7))){
var state_36891__$1 = state_36891;
var statearr_36893_36960 = state_36891__$1;
(statearr_36893_36960[(2)] = null);

(statearr_36893_36960[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (20))){
var inst_36814 = (state_36891[(7)]);
var inst_36784 = (state_36891[(8)]);
var inst_36815 = (state_36891[(9)]);
var inst_36816 = (state_36891[(10)]);
var inst_36734 = (state_36891[(11)]);
var inst_36813 = (state_36891[(12)]);
var inst_36817 = (state_36891[(13)]);
var inst_36733 = (state_36891[(14)]);
var inst_36827 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_36828 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36829 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_36830 = (new cljs.core.PersistentVector(null,2,(5),inst_36828,inst_36829,null));
var inst_36831 = cljs.core.get_in.call(null,inst_36784,inst_36830);
var inst_36832 = (inst_36733 + inst_36831);
var inst_36833 = [inst_36813,inst_36814,inst_36815,inst_36816,inst_36832];
var inst_36834 = cljs.core.PersistentHashMap.fromArrays(inst_36827,inst_36833);
var inst_36835 = cljs.core.assoc.call(null,inst_36784,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_36817,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_36834);
var state_36891__$1 = (function (){var statearr_36894 = state_36891;
(statearr_36894[(15)] = inst_36835);

return statearr_36894;
})();
if(cljs.core.truth_(inst_36734)){
var statearr_36895_36961 = state_36891__$1;
(statearr_36895_36961[(1)] = (23));

} else {
var statearr_36896_36962 = state_36891__$1;
(statearr_36896_36962[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (27))){
var inst_36835 = (state_36891[(15)]);
var state_36891__$1 = state_36891;
var statearr_36897_36963 = state_36891__$1;
(statearr_36897_36963[(2)] = inst_36835);

(statearr_36897_36963[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (1))){
var state_36891__$1 = state_36891;
var statearr_36898_36964 = state_36891__$1;
(statearr_36898_36964[(2)] = null);

(statearr_36898_36964[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (24))){
var inst_36835 = (state_36891[(15)]);
var inst_36838 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_36835);
var inst_36839 = (inst_36838 == null);
var state_36891__$1 = state_36891;
var statearr_36899_36965 = state_36891__$1;
(statearr_36899_36965[(2)] = inst_36839);

(statearr_36899_36965[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (39))){
var inst_36867 = (state_36891[(16)]);
var inst_36866 = (state_36891[(17)]);
var inst_36824 = (state_36891[(18)]);
var inst_36874 = (state_36891[(19)]);
var inst_36865 = (state_36891[(20)]);
var inst_36881 = (state_36891[(2)]);
var inst_36812 = inst_36824;
var inst_36813 = inst_36866;
var inst_36814 = inst_36867;
var inst_36815 = inst_36874;
var inst_36816 = inst_36881;
var inst_36817 = inst_36865;
var state_36891__$1 = (function (){var statearr_36900 = state_36891;
(statearr_36900[(7)] = inst_36814);

(statearr_36900[(9)] = inst_36815);

(statearr_36900[(10)] = inst_36816);

(statearr_36900[(12)] = inst_36813);

(statearr_36900[(21)] = inst_36812);

(statearr_36900[(13)] = inst_36817);

return statearr_36900;
})();
var statearr_36901_36966 = state_36891__$1;
(statearr_36901_36966[(2)] = null);

(statearr_36901_36966[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (4))){
var inst_36696 = (state_36891[(2)]);
var state_36891__$1 = state_36891;
var statearr_36902_36967 = state_36891__$1;
(statearr_36902_36967[(2)] = inst_36696);

(statearr_36902_36967[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (15))){
var inst_36756 = (state_36891[(22)]);
var state_36891__$1 = state_36891;
var statearr_36903_36968 = state_36891__$1;
(statearr_36903_36968[(2)] = inst_36756);

(statearr_36903_36968[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (21))){
var inst_36720 = (state_36891[(23)]);
var inst_36737 = (state_36891[(24)]);
var inst_36814 = (state_36891[(7)]);
var inst_36703 = (state_36891[(25)]);
var inst_36794 = (state_36891[(26)]);
var inst_36784 = (state_36891[(8)]);
var inst_36824 = (state_36891[(18)]);
var inst_36815 = (state_36891[(9)]);
var inst_36816 = (state_36891[(10)]);
var inst_36734 = (state_36891[(11)]);
var inst_36743 = (state_36891[(27)]);
var inst_36813 = (state_36891[(12)]);
var inst_36718 = (state_36891[(28)]);
var inst_36732 = (state_36891[(29)]);
var inst_36823 = (state_36891[(30)]);
var inst_36735 = (state_36891[(31)]);
var inst_36728 = (state_36891[(32)]);
var inst_36812 = (state_36891[(21)]);
var inst_36793 = (state_36891[(33)]);
var inst_36817 = (state_36891[(13)]);
var inst_36724 = (state_36891[(34)]);
var inst_36733 = (state_36891[(14)]);
var inst_36862 = inst_36823.s;
var inst_36863 = fluree.db.flake.sid__GT_cid.call(null,inst_36862);
var inst_36864 = (function (){var flakes_bytes = inst_36733;
var t = inst_36703;
var spot = inst_36813;
var add_flakes = inst_36720;
var root_setting_change_QMARK_ = inst_36735;
var vec__36819 = inst_36812;
var ref_QMARK__map = inst_36732;
var r = inst_36824;
var vec__36789 = inst_36720;
var psot = inst_36814;
var add_pred_to_idx_QMARK_ = inst_36743;
var G__36788 = inst_36812;
var _ = inst_36718;
var seq__36820 = inst_36824;
var first__36791 = inst_36793;
var cid = inst_36863;
var seq__36790 = inst_36794;
var ecount = inst_36817;
var pred_ecount = inst_36737;
var first__36821 = inst_36823;
var db_STAR_ = inst_36784;
var schema_change_QMARK_ = inst_36734;
var add_preds = inst_36724;
var opst = inst_36816;
var idx_QMARK__map = inst_36728;
var post = inst_36815;
var f = inst_36823;
return (function (p1__36693_SHARP_){
if(cljs.core.truth_(p1__36693_SHARP_)){
var x__4336__auto__ = p1__36693_SHARP_;
var y__4337__auto__ = f.s;
return ((x__4336__auto__ > y__4337__auto__) ? x__4336__auto__ : y__4337__auto__);
} else {
return f.s;
}
});
})();
var inst_36865 = cljs.core.update.call(null,inst_36817,inst_36863,inst_36864);
var inst_36866 = cljs.core.conj.call(null,inst_36813,inst_36823);
var inst_36867 = cljs.core.conj.call(null,inst_36814,inst_36823);
var inst_36868 = inst_36823.p;
var inst_36869 = cljs.core.get.call(null,inst_36728,inst_36868);
var state_36891__$1 = (function (){var statearr_36904 = state_36891;
(statearr_36904[(16)] = inst_36867);

(statearr_36904[(17)] = inst_36866);

(statearr_36904[(20)] = inst_36865);

return statearr_36904;
})();
if(cljs.core.truth_(inst_36869)){
var statearr_36905_36969 = state_36891__$1;
(statearr_36905_36969[(1)] = (34));

} else {
var statearr_36906_36970 = state_36891__$1;
(statearr_36906_36970[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (31))){
var inst_36850 = (state_36891[(35)]);
var state_36891__$1 = state_36891;
var statearr_36907_36971 = state_36891__$1;
(statearr_36907_36971[(2)] = inst_36850);

(statearr_36907_36971[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (32))){
var inst_36860 = (state_36891[(2)]);
var state_36891__$1 = state_36891;
var statearr_36908_36972 = state_36891__$1;
(statearr_36908_36972[(2)] = inst_36860);

(statearr_36908_36972[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (33))){
var inst_36850 = (state_36891[(35)]);
var inst_36855 = (state_36891[(2)]);
var inst_36856 = fluree.db.util.async.throw_err.call(null,inst_36855);
var inst_36857 = cljs.core.assoc.call(null,inst_36850,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_36856);
var state_36891__$1 = state_36891;
var statearr_36909_36973 = state_36891__$1;
(statearr_36909_36973[(2)] = inst_36857);

(statearr_36909_36973[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (13))){
var inst_36720 = (state_36891[(23)]);
var inst_36703 = (state_36891[(25)]);
var inst_36784 = (state_36891[(8)]);
var inst_36733 = (state_36891[(14)]);
var inst_36774 = (state_36891[(2)]);
var inst_36775 = cljs.core.assoc.call(null,inst_36774,new cljs.core.Keyword(null,"t","t",-1397832519),inst_36703);
var inst_36776 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36777 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_36778 = (new cljs.core.PersistentVector(null,2,(5),inst_36776,inst_36777,null));
var inst_36779 = cljs.core.update_in.call(null,inst_36775,inst_36778,cljs.core._PLUS_,inst_36733);
var inst_36780 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36781 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_36782 = (new cljs.core.PersistentVector(null,2,(5),inst_36780,inst_36781,null));
var inst_36783 = cljs.core.count.call(null,inst_36720);
var inst_36784__$1 = cljs.core.update_in.call(null,inst_36779,inst_36782,cljs.core._PLUS_,inst_36783);
var inst_36792 = cljs.core.seq.call(null,inst_36720);
var inst_36793 = cljs.core.first.call(null,inst_36792);
var inst_36794 = cljs.core.next.call(null,inst_36792);
var inst_36795 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36796 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_36797 = (new cljs.core.PersistentVector(null,2,(5),inst_36795,inst_36796,null));
var inst_36798 = cljs.core.get_in.call(null,inst_36784__$1,inst_36797);
var inst_36799 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36800 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_36801 = (new cljs.core.PersistentVector(null,2,(5),inst_36799,inst_36800,null));
var inst_36802 = cljs.core.get_in.call(null,inst_36784__$1,inst_36801);
var inst_36803 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36804 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_36805 = (new cljs.core.PersistentVector(null,2,(5),inst_36803,inst_36804,null));
var inst_36806 = cljs.core.get_in.call(null,inst_36784__$1,inst_36805);
var inst_36807 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36808 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_36809 = (new cljs.core.PersistentVector(null,2,(5),inst_36807,inst_36808,null));
var inst_36810 = cljs.core.get_in.call(null,inst_36784__$1,inst_36809);
var inst_36811 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_36812 = inst_36720;
var inst_36813 = inst_36798;
var inst_36814 = inst_36802;
var inst_36815 = inst_36806;
var inst_36816 = inst_36810;
var inst_36817 = inst_36811;
var state_36891__$1 = (function (){var statearr_36910 = state_36891;
(statearr_36910[(7)] = inst_36814);

(statearr_36910[(26)] = inst_36794);

(statearr_36910[(8)] = inst_36784__$1);

(statearr_36910[(9)] = inst_36815);

(statearr_36910[(10)] = inst_36816);

(statearr_36910[(12)] = inst_36813);

(statearr_36910[(21)] = inst_36812);

(statearr_36910[(33)] = inst_36793);

(statearr_36910[(13)] = inst_36817);

return statearr_36910;
})();
var statearr_36911_36974 = state_36891__$1;
(statearr_36911_36974[(2)] = null);

(statearr_36911_36974[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (22))){
var inst_36884 = (state_36891[(2)]);
var state_36891__$1 = state_36891;
var statearr_36912_36975 = state_36891__$1;
(statearr_36912_36975[(2)] = inst_36884);

(statearr_36912_36975[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (36))){
var inst_36732 = (state_36891[(29)]);
var inst_36823 = (state_36891[(30)]);
var inst_36874 = (state_36891[(2)]);
var inst_36875 = inst_36823.p;
var inst_36876 = cljs.core.get.call(null,inst_36732,inst_36875);
var state_36891__$1 = (function (){var statearr_36913 = state_36891;
(statearr_36913[(19)] = inst_36874);

return statearr_36913;
})();
if(cljs.core.truth_(inst_36876)){
var statearr_36914_36976 = state_36891__$1;
(statearr_36914_36976[(1)] = (37));

} else {
var statearr_36915_36977 = state_36891__$1;
(statearr_36915_36977[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (29))){
var inst_36835 = (state_36891[(15)]);
var inst_36845 = (state_36891[(2)]);
var inst_36846 = fluree.db.util.async.throw_err.call(null,inst_36845);
var inst_36847 = cljs.core.assoc.call(null,inst_36835,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_36846);
var state_36891__$1 = state_36891;
var statearr_36916_36978 = state_36891__$1;
(statearr_36916_36978[(2)] = inst_36847);

(statearr_36916_36978[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (6))){
var inst_36703 = (state_36891[(25)]);
var inst_36708 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_36709 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_36710 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36708)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36709)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36703),"."].join('');
var inst_36711 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_36712 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_36713 = cljs.core.PersistentHashMap.fromArrays(inst_36711,inst_36712);
var inst_36714 = cljs.core.ex_info.call(null,inst_36710,inst_36713);
var inst_36715 = (function(){throw inst_36714})();
var state_36891__$1 = state_36891;
var statearr_36917_36979 = state_36891__$1;
(statearr_36917_36979[(2)] = inst_36715);

(statearr_36917_36979[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (28))){
var inst_36735 = (state_36891[(31)]);
var inst_36850 = (state_36891[(2)]);
var state_36891__$1 = (function (){var statearr_36918 = state_36891;
(statearr_36918[(35)] = inst_36850);

return statearr_36918;
})();
if(cljs.core.truth_(inst_36735)){
var statearr_36919_36980 = state_36891__$1;
(statearr_36919_36980[(1)] = (30));

} else {
var statearr_36920_36981 = state_36891__$1;
(statearr_36920_36981[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (25))){
var inst_36841 = (state_36891[(2)]);
var state_36891__$1 = state_36891;
if(cljs.core.truth_(inst_36841)){
var statearr_36921_36982 = state_36891__$1;
(statearr_36921_36982[(1)] = (26));

} else {
var statearr_36922_36983 = state_36891__$1;
(statearr_36922_36983[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (34))){
var inst_36815 = (state_36891[(9)]);
var inst_36823 = (state_36891[(30)]);
var inst_36871 = cljs.core.conj.call(null,inst_36815,inst_36823);
var state_36891__$1 = state_36891;
var statearr_36923_36984 = state_36891__$1;
(statearr_36923_36984[(2)] = inst_36871);

(statearr_36923_36984[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (17))){
var inst_36763 = (state_36891[(36)]);
var inst_36767 = (state_36891[(2)]);
var inst_36768 = fluree.db.util.async.throw_err.call(null,inst_36767);
var inst_36755 = inst_36763;
var inst_36756 = inst_36768;
var state_36891__$1 = (function (){var statearr_36924 = state_36891;
(statearr_36924[(22)] = inst_36756);

(statearr_36924[(37)] = inst_36755);

return statearr_36924;
})();
var statearr_36925_36985 = state_36891__$1;
(statearr_36925_36985[(2)] = null);

(statearr_36925_36985[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (3))){
var inst_36889 = (state_36891[(2)]);
var state_36891__$1 = state_36891;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36891__$1,inst_36889);
} else {
if((state_val_36892 === (12))){
var inst_36755 = (state_36891[(37)]);
var inst_36762 = (state_36891[(38)]);
var inst_36761 = cljs.core.seq.call(null,inst_36755);
var inst_36762__$1 = cljs.core.first.call(null,inst_36761);
var inst_36763 = cljs.core.next.call(null,inst_36761);
var state_36891__$1 = (function (){var statearr_36926 = state_36891;
(statearr_36926[(36)] = inst_36763);

(statearr_36926[(38)] = inst_36762__$1);

return statearr_36926;
})();
if(cljs.core.truth_(inst_36762__$1)){
var statearr_36927_36986 = state_36891__$1;
(statearr_36927_36986[(1)] = (14));

} else {
var statearr_36928_36987 = state_36891__$1;
(statearr_36928_36987[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (2))){
var inst_36703 = (state_36891[(25)]);
var _ = (function (){var statearr_36929 = state_36891;
(statearr_36929[(4)] = cljs.core.cons.call(null,(5),(state_36891[(4)])));

return statearr_36929;
})();
var inst_36702 = cljs.core.first.call(null,flakes);
var inst_36703__$1 = inst_36702.t;
var inst_36704 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_36705 = (inst_36704 - (1));
var inst_36706 = cljs.core.not_EQ_.call(null,inst_36703__$1,inst_36705);
var state_36891__$1 = (function (){var statearr_36930 = state_36891;
(statearr_36930[(25)] = inst_36703__$1);

return statearr_36930;
})();
if(inst_36706){
var statearr_36931_36988 = state_36891__$1;
(statearr_36931_36988[(1)] = (6));

} else {
var statearr_36932_36989 = state_36891__$1;
(statearr_36932_36989[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (23))){
var inst_36734 = (state_36891[(11)]);
var state_36891__$1 = state_36891;
var statearr_36933_36990 = state_36891__$1;
(statearr_36933_36990[(2)] = inst_36734);

(statearr_36933_36990[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (35))){
var inst_36815 = (state_36891[(9)]);
var state_36891__$1 = state_36891;
var statearr_36934_36991 = state_36891__$1;
(statearr_36934_36991[(2)] = inst_36815);

(statearr_36934_36991[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (19))){
var inst_36886 = (state_36891[(2)]);
var _ = (function (){var statearr_36935 = state_36891;
(statearr_36935[(4)] = cljs.core.rest.call(null,(state_36891[(4)])));

return statearr_36935;
})();
var state_36891__$1 = state_36891;
var statearr_36936_36992 = state_36891__$1;
(statearr_36936_36992[(2)] = inst_36886);

(statearr_36936_36992[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (11))){
var inst_36743 = (state_36891[(27)]);
var inst_36743__$1 = (state_36891[(2)]);
var inst_36751 = cljs.core.seq.call(null,inst_36743__$1);
var inst_36752 = cljs.core.first.call(null,inst_36751);
var inst_36753 = cljs.core.next.call(null,inst_36751);
var inst_36754 = db;
var inst_36755 = inst_36743__$1;
var inst_36756 = inst_36754;
var state_36891__$1 = (function (){var statearr_36938 = state_36891;
(statearr_36938[(39)] = inst_36753);

(statearr_36938[(22)] = inst_36756);

(statearr_36938[(37)] = inst_36755);

(statearr_36938[(27)] = inst_36743__$1);

(statearr_36938[(40)] = inst_36752);

return statearr_36938;
})();
var statearr_36939_36993 = state_36891__$1;
(statearr_36939_36993[(2)] = null);

(statearr_36939_36993[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (9))){
var inst_36720 = (state_36891[(23)]);
var inst_36737 = (state_36891[(24)]);
var inst_36739 = fluree.db.util.schema.add_to_post_preds_QMARK_.call(null,inst_36720,inst_36737);
var state_36891__$1 = state_36891;
var statearr_36940_36994 = state_36891__$1;
(statearr_36940_36994[(2)] = inst_36739);

(statearr_36940_36994[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (5))){
var _ = (function (){var statearr_36941 = state_36891;
(statearr_36941[(4)] = cljs.core.rest.call(null,(state_36891[(4)])));

return statearr_36941;
})();
var state_36891__$1 = state_36891;
var ex36937 = (state_36891__$1[(2)]);
var statearr_36942_36995 = state_36891__$1;
(statearr_36942_36995[(5)] = ex36937);


if((ex36937 instanceof Error)){
var statearr_36943_36996 = state_36891__$1;
(statearr_36943_36996[(1)] = (4));

(statearr_36943_36996[(5)] = null);

} else {
throw ex36937;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (14))){
var inst_36756 = (state_36891[(22)]);
var inst_36762 = (state_36891[(38)]);
var inst_36765 = fluree.db.graphdb.add_predicate_to_idx.call(null,inst_36756,inst_36762,opts);
var state_36891__$1 = state_36891;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36891__$1,(17),inst_36765);
} else {
if((state_val_36892 === (26))){
var inst_36835 = (state_36891[(15)]);
var inst_36843 = fluree.db.query.schema.schema_map.call(null,inst_36835);
var state_36891__$1 = state_36891;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36891__$1,(29),inst_36843);
} else {
if((state_val_36892 === (16))){
var inst_36772 = (state_36891[(2)]);
var state_36891__$1 = state_36891;
var statearr_36944_36997 = state_36891__$1;
(statearr_36944_36997[(2)] = inst_36772);

(statearr_36944_36997[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (38))){
var inst_36816 = (state_36891[(10)]);
var state_36891__$1 = state_36891;
var statearr_36945_36998 = state_36891__$1;
(statearr_36945_36998[(2)] = inst_36816);

(statearr_36945_36998[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (30))){
var inst_36850 = (state_36891[(35)]);
var inst_36853 = fluree.db.query.schema.setting_map.call(null,inst_36850);
var state_36891__$1 = state_36891;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36891__$1,(33),inst_36853);
} else {
if((state_val_36892 === (10))){
var inst_36741 = cljs.core.PersistentVector.EMPTY;
var state_36891__$1 = state_36891;
var statearr_36946_36999 = state_36891__$1;
(statearr_36946_36999[(2)] = inst_36741);

(statearr_36946_36999[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (18))){
var inst_36823 = (state_36891[(30)]);
var inst_36812 = (state_36891[(21)]);
var inst_36822 = cljs.core.seq.call(null,inst_36812);
var inst_36823__$1 = cljs.core.first.call(null,inst_36822);
var inst_36824 = cljs.core.next.call(null,inst_36822);
var inst_36825 = cljs.core.not.call(null,inst_36823__$1);
var state_36891__$1 = (function (){var statearr_36947 = state_36891;
(statearr_36947[(18)] = inst_36824);

(statearr_36947[(30)] = inst_36823__$1);

return statearr_36947;
})();
if(inst_36825){
var statearr_36948_37000 = state_36891__$1;
(statearr_36948_37000[(1)] = (20));

} else {
var statearr_36949_37001 = state_36891__$1;
(statearr_36949_37001[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (37))){
var inst_36816 = (state_36891[(10)]);
var inst_36823 = (state_36891[(30)]);
var inst_36878 = cljs.core.conj.call(null,inst_36816,inst_36823);
var state_36891__$1 = state_36891;
var statearr_36950_37002 = state_36891__$1;
(statearr_36950_37002[(2)] = inst_36878);

(statearr_36950_37002[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36892 === (8))){
var inst_36720 = (state_36891[(23)]);
var inst_36703 = (state_36891[(25)]);
var inst_36734 = (state_36891[(11)]);
var inst_36718 = (state_36891[(28)]);
var inst_36728 = (state_36891[(32)]);
var inst_36724 = (state_36891[(34)]);
var inst_36718__$1 = (state_36891[(2)]);
var inst_36719 = (function (){var t = inst_36703;
var _ = inst_36718__$1;
return (function (p1__36691_SHARP_){
return cljs.core.not.call(null,fluree.db.graphdb.exclude_predicates.call(null,p1__36691_SHARP_.p));
});
})();
var inst_36720__$1 = cljs.core.filter.call(null,inst_36719,flakes);
var inst_36721 = cljs.core.PersistentHashSet.EMPTY;
var inst_36722 = (function (){var t = inst_36703;
var _ = inst_36718__$1;
var add_flakes = inst_36720__$1;
return (function (p1__36692_SHARP_){
return p1__36692_SHARP_.p;
});
})();
var inst_36723 = cljs.core.map.call(null,inst_36722,inst_36720__$1);
var inst_36724__$1 = cljs.core.into.call(null,inst_36721,inst_36723);
var inst_36725 = cljs.core.PersistentHashMap.EMPTY;
var inst_36726 = (function (){var t = inst_36703;
var _ = inst_36718__$1;
var add_flakes = inst_36720__$1;
var add_preds = inst_36724__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_36727 = cljs.core.map.call(null,inst_36726,inst_36724__$1);
var inst_36728__$1 = cljs.core.into.call(null,inst_36725,inst_36727);
var inst_36729 = cljs.core.PersistentHashMap.EMPTY;
var inst_36730 = (function (){var t = inst_36703;
var _ = inst_36718__$1;
var add_flakes = inst_36720__$1;
var add_preds = inst_36724__$1;
var idx_QMARK__map = inst_36728__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_36731 = cljs.core.map.call(null,inst_36730,inst_36724__$1);
var inst_36732 = cljs.core.into.call(null,inst_36729,inst_36731);
var inst_36733 = fluree.db.flake.size_bytes.call(null,inst_36720__$1);
var inst_36734__$1 = fluree.db.util.schema.schema_change_QMARK_.call(null,inst_36720__$1);
var inst_36735 = fluree.db.util.schema.setting_change_QMARK_.call(null,inst_36720__$1);
var inst_36736 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_36737 = cljs.core.get.call(null,inst_36736,(0));
var state_36891__$1 = (function (){var statearr_36951 = state_36891;
(statearr_36951[(23)] = inst_36720__$1);

(statearr_36951[(24)] = inst_36737);

(statearr_36951[(11)] = inst_36734__$1);

(statearr_36951[(28)] = inst_36718__$1);

(statearr_36951[(29)] = inst_36732);

(statearr_36951[(31)] = inst_36735);

(statearr_36951[(32)] = inst_36728__$1);

(statearr_36951[(34)] = inst_36724__$1);

(statearr_36951[(14)] = inst_36733);

return statearr_36951;
})();
if(cljs.core.truth_(inst_36734__$1)){
var statearr_36952_37003 = state_36891__$1;
(statearr_36952_37003[(1)] = (9));

} else {
var statearr_36953_37004 = state_36891__$1;
(statearr_36953_37004[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__10903__auto__ = null;
var fluree$db$graphdb$state_machine__10903__auto____0 = (function (){
var statearr_36954 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36954[(0)] = fluree$db$graphdb$state_machine__10903__auto__);

(statearr_36954[(1)] = (1));

return statearr_36954;
});
var fluree$db$graphdb$state_machine__10903__auto____1 = (function (state_36891){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_36891);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e36955){var ex__10906__auto__ = e36955;
var statearr_36956_37005 = state_36891;
(statearr_36956_37005[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_36891[(4)]))){
var statearr_36957_37006 = state_36891;
(statearr_36957_37006[(1)] = cljs.core.first.call(null,(state_36891[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37007 = state_36891;
state_36891 = G__37007;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__10903__auto__ = function(state_36891){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__10903__auto____1.call(this,state_36891);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__10903__auto____0;
fluree$db$graphdb$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__10903__auto____1;
return fluree$db$graphdb$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_36958 = f__10977__auto__.call(null);
(statearr_36958[(6)] = c__10976__auto__);

return statearr_36958;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__37009 = arguments.length;
switch (G__37009) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.call(null,db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.call(null);
var c__10976__auto___37156 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_37105){
var state_val_37106 = (state_37105[(1)]);
if((state_val_37106 === (7))){
var state_37105__$1 = state_37105;
var statearr_37107_37157 = state_37105__$1;
(statearr_37107_37157[(2)] = null);

(statearr_37107_37157[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37106 === (20))){
var inst_37053 = (state_37105[(7)]);
var inst_37054 = (state_37105[(8)]);
var inst_37055 = (state_37105[(9)]);
var inst_37074 = (inst_37053 + (1));
var inst_37075 = cljs.core.assoc.call(null,inst_37055,new cljs.core.Keyword(null,"t","t",-1397832519),inst_37074);
var inst_37076 = fluree.db.graphdb.with_t.call(null,inst_37075,inst_37054,opts);
var state_37105__$1 = state_37105;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37105__$1,(23),inst_37076);
} else {
if((state_val_37106 === (1))){
var state_37105__$1 = state_37105;
var statearr_37108_37158 = state_37105__$1;
(statearr_37108_37158[(2)] = null);

(statearr_37108_37158[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37106 === (24))){
var inst_37079 = (state_37105[(10)]);
var inst_37082 = cljs.core.assoc.call(null,inst_37079,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_37105__$1 = state_37105;
var statearr_37109_37159 = state_37105__$1;
(statearr_37109_37159[(2)] = inst_37082);

(statearr_37109_37159[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37106 === (4))){
var inst_37010 = (state_37105[(2)]);
var inst_37011 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_37010);
var state_37105__$1 = state_37105;
var statearr_37110_37160 = state_37105__$1;
(statearr_37110_37160[(2)] = inst_37011);

(statearr_37110_37160[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37106 === (15))){
var inst_37061 = (state_37105[(11)]);
var state_37105__$1 = state_37105;
var statearr_37111_37161 = state_37105__$1;
(statearr_37111_37161[(2)] = inst_37061);

(statearr_37111_37161[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37106 === (21))){
var state_37105__$1 = state_37105;
var statearr_37112_37162 = state_37105__$1;
(statearr_37112_37162[(2)] = null);

(statearr_37112_37162[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37106 === (13))){
var inst_37097 = (state_37105[(2)]);
var inst_37098 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_37097);
var state_37105__$1 = state_37105;
var statearr_37113_37163 = state_37105__$1;
(statearr_37113_37163[(2)] = inst_37098);

(statearr_37113_37163[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37106 === (22))){
var inst_37093 = (state_37105[(2)]);
var state_37105__$1 = state_37105;
var statearr_37114_37164 = state_37105__$1;
(statearr_37114_37164[(2)] = inst_37093);

(statearr_37114_37164[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37106 === (6))){
var inst_37021 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_37022 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_37023 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_37021)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_37022)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_37024 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_37025 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_37026 = cljs.core.PersistentHashMap.fromArrays(inst_37024,inst_37025);
var inst_37027 = cljs.core.ex_info.call(null,inst_37023,inst_37026);
var inst_37028 = (function(){throw inst_37027})();
var state_37105__$1 = state_37105;
var statearr_37117_37165 = state_37105__$1;
(statearr_37117_37165[(2)] = inst_37028);

(statearr_37117_37165[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37106 === (25))){
var inst_37062 = (state_37105[(12)]);
var inst_37079 = (state_37105[(10)]);
var inst_37061 = (state_37105[(11)]);
var inst_37084 = inst_37061.t;
var inst_37085 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37086 = [inst_37061];
var inst_37087 = (new cljs.core.PersistentVector(null,1,(5),inst_37085,inst_37086,null));
var inst_37052 = inst_37062;
var inst_37053 = inst_37084;
var inst_37054 = inst_37087;
var inst_37055 = inst_37079;
var state_37105__$1 = (function (){var statearr_37118 = state_37105;
(statearr_37118[(13)] = inst_37052);

(statearr_37118[(7)] = inst_37053);

(statearr_37118[(8)] = inst_37054);

(statearr_37118[(9)] = inst_37055);

return statearr_37118;
})();
var statearr_37119_37166 = state_37105__$1;
(statearr_37119_37166[(2)] = null);

(statearr_37119_37166[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37106 === (17))){
var inst_37062 = (state_37105[(12)]);
var inst_37053 = (state_37105[(7)]);
var inst_37054 = (state_37105[(8)]);
var inst_37055 = (state_37105[(9)]);
var inst_37061 = (state_37105[(11)]);
var inst_37070 = cljs.core.conj.call(null,inst_37054,inst_37061);
var tmp37115 = inst_37053;
var tmp37116 = inst_37055;
var inst_37052 = inst_37062;
var inst_37053__$1 = tmp37115;
var inst_37054__$1 = inst_37070;
var inst_37055__$1 = tmp37116;
var state_37105__$1 = (function (){var statearr_37120 = state_37105;
(statearr_37120[(13)] = inst_37052);

(statearr_37120[(7)] = inst_37053__$1);

(statearr_37120[(8)] = inst_37054__$1);

(statearr_37120[(9)] = inst_37055__$1);

return statearr_37120;
})();
var statearr_37121_37167 = state_37105__$1;
(statearr_37121_37167[(2)] = null);

(statearr_37121_37167[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37106 === (3))){
var inst_37103 = (state_37105[(2)]);
var state_37105__$1 = state_37105;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37105__$1,inst_37103);
} else {
if((state_val_37106 === (12))){
var inst_37052 = (state_37105[(13)]);
var inst_37061 = (state_37105[(11)]);
var inst_37060 = cljs.core.seq.call(null,inst_37052);
var inst_37061__$1 = cljs.core.first.call(null,inst_37060);
var inst_37062 = cljs.core.next.call(null,inst_37060);
var state_37105__$1 = (function (){var statearr_37122 = state_37105;
(statearr_37122[(12)] = inst_37062);

(statearr_37122[(11)] = inst_37061__$1);

return statearr_37122;
})();
if(cljs.core.truth_(inst_37061__$1)){
var statearr_37123_37168 = state_37105__$1;
(statearr_37123_37168[(1)] = (14));

} else {
var statearr_37124_37169 = state_37105__$1;
(statearr_37124_37169[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37106 === (2))){
var _ = (function (){var statearr_37125 = state_37105;
(statearr_37125[(4)] = cljs.core.cons.call(null,(5),(state_37105[(4)])));

return statearr_37125;
})();
var inst_37017 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_37018 = (inst_37017 + (1));
var inst_37019 = cljs.core.not_EQ_.call(null,block,inst_37018);
var state_37105__$1 = state_37105;
if(inst_37019){
var statearr_37126_37170 = state_37105__$1;
(statearr_37126_37170[(1)] = (6));

} else {
var statearr_37127_37171 = state_37105__$1;
(statearr_37127_37171[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37106 === (23))){
var inst_37061 = (state_37105[(11)]);
var inst_37078 = (state_37105[(2)]);
var inst_37079 = fluree.db.util.async.throw_err.call(null,inst_37078);
var inst_37080 = (inst_37061 == null);
var state_37105__$1 = (function (){var statearr_37128 = state_37105;
(statearr_37128[(10)] = inst_37079);

return statearr_37128;
})();
if(cljs.core.truth_(inst_37080)){
var statearr_37129_37172 = state_37105__$1;
(statearr_37129_37172[(1)] = (24));

} else {
var statearr_37130_37173 = state_37105__$1;
(statearr_37130_37173[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37106 === (19))){
var inst_37095 = (state_37105[(2)]);
var state_37105__$1 = state_37105;
var statearr_37131_37174 = state_37105__$1;
(statearr_37131_37174[(2)] = inst_37095);

(statearr_37131_37174[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37106 === (11))){
var inst_37100 = (state_37105[(2)]);
var _ = (function (){var statearr_37133 = state_37105;
(statearr_37133[(4)] = cljs.core.rest.call(null,(state_37105[(4)])));

return statearr_37133;
})();
var state_37105__$1 = state_37105;
var statearr_37134_37175 = state_37105__$1;
(statearr_37134_37175[(2)] = inst_37100);

(statearr_37134_37175[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37106 === (9))){
var inst_37034 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_37035 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_37034);
var state_37105__$1 = state_37105;
var statearr_37135_37176 = state_37105__$1;
(statearr_37135_37176[(2)] = inst_37035);

(statearr_37135_37176[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37106 === (5))){
var _ = (function (){var statearr_37136 = state_37105;
(statearr_37136[(4)] = cljs.core.rest.call(null,(state_37105[(4)])));

return statearr_37136;
})();
var state_37105__$1 = state_37105;
var ex37132 = (state_37105__$1[(2)]);
var statearr_37137_37177 = state_37105__$1;
(statearr_37137_37177[(5)] = ex37132);


var statearr_37138_37178 = state_37105__$1;
(statearr_37138_37178[(1)] = (4));

(statearr_37138_37178[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37106 === (14))){
var inst_37053 = (state_37105[(7)]);
var inst_37061 = (state_37105[(11)]);
var inst_37064 = inst_37061.t;
var inst_37065 = cljs.core._EQ_.call(null,inst_37053,inst_37064);
var state_37105__$1 = state_37105;
var statearr_37139_37179 = state_37105__$1;
(statearr_37139_37179[(2)] = inst_37065);

(statearr_37139_37179[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37106 === (26))){
var inst_37090 = (state_37105[(2)]);
var state_37105__$1 = state_37105;
var statearr_37140_37180 = state_37105__$1;
(statearr_37140_37180[(2)] = inst_37090);

(statearr_37140_37180[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37106 === (16))){
var inst_37068 = (state_37105[(2)]);
var state_37105__$1 = state_37105;
if(cljs.core.truth_(inst_37068)){
var statearr_37141_37181 = state_37105__$1;
(statearr_37141_37181[(1)] = (17));

} else {
var statearr_37142_37182 = state_37105__$1;
(statearr_37142_37182[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37106 === (10))){
var inst_37037 = cljs.core.sort.call(null,fluree.db.flake.cmp_flakes_block,flakes);
var inst_37038 = cljs.core.first.call(null,inst_37037);
var inst_37046 = cljs.core.seq.call(null,inst_37037);
var inst_37047 = cljs.core.first.call(null,inst_37046);
var inst_37048 = cljs.core.next.call(null,inst_37046);
var inst_37049 = inst_37038.t;
var inst_37050 = cljs.core.PersistentVector.EMPTY;
var inst_37051 = db;
var inst_37052 = inst_37037;
var inst_37053 = inst_37049;
var inst_37054 = inst_37050;
var inst_37055 = inst_37051;
var state_37105__$1 = (function (){var statearr_37143 = state_37105;
(statearr_37143[(13)] = inst_37052);

(statearr_37143[(7)] = inst_37053);

(statearr_37143[(14)] = inst_37047);

(statearr_37143[(8)] = inst_37054);

(statearr_37143[(15)] = inst_37048);

(statearr_37143[(9)] = inst_37055);

return statearr_37143;
})();
var statearr_37144_37183 = state_37105__$1;
(statearr_37144_37183[(2)] = null);

(statearr_37144_37183[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37106 === (18))){
var state_37105__$1 = state_37105;
var statearr_37145_37184 = state_37105__$1;
(statearr_37145_37184[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37106 === (8))){
var inst_37031 = (state_37105[(2)]);
var inst_37032 = cljs.core.empty_QMARK_.call(null,flakes);
var state_37105__$1 = (function (){var statearr_37147 = state_37105;
(statearr_37147[(16)] = inst_37031);

return statearr_37147;
})();
if(inst_37032){
var statearr_37148_37185 = state_37105__$1;
(statearr_37148_37185[(1)] = (9));

} else {
var statearr_37149_37186 = state_37105__$1;
(statearr_37149_37186[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__10903__auto__ = null;
var fluree$db$graphdb$state_machine__10903__auto____0 = (function (){
var statearr_37150 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37150[(0)] = fluree$db$graphdb$state_machine__10903__auto__);

(statearr_37150[(1)] = (1));

return statearr_37150;
});
var fluree$db$graphdb$state_machine__10903__auto____1 = (function (state_37105){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_37105);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e37151){var ex__10906__auto__ = e37151;
var statearr_37152_37187 = state_37105;
(statearr_37152_37187[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_37105[(4)]))){
var statearr_37153_37188 = state_37105;
(statearr_37153_37188[(1)] = cljs.core.first.call(null,(state_37105[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37189 = state_37105;
state_37105 = G__37189;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__10903__auto__ = function(state_37105){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__10903__auto____1.call(this,state_37105);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__10903__auto____0;
fluree$db$graphdb$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__10903__auto____1;
return fluree$db$graphdb$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_37154 = f__10977__auto__.call(null);
(statearr_37154[(6)] = c__10976__auto___37156);

return statearr_37154;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_37245){
var state_val_37246 = (state_37245[(1)]);
if((state_val_37246 === (7))){
var state_37245__$1 = state_37245;
var statearr_37247_37274 = state_37245__$1;
(statearr_37247_37274[(2)] = tt_id);

(statearr_37247_37274[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37246 === (1))){
var state_37245__$1 = state_37245;
var statearr_37248_37275 = state_37245__$1;
(statearr_37248_37275[(2)] = null);

(statearr_37248_37275[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37246 === (4))){
var inst_37190 = (state_37245[(2)]);
var state_37245__$1 = state_37245;
var statearr_37249_37276 = state_37245__$1;
(statearr_37249_37276[(2)] = inst_37190);

(statearr_37249_37276[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37246 === (13))){
var inst_37238 = (state_37245[(2)]);
var state_37245__$1 = state_37245;
var statearr_37250_37277 = state_37245__$1;
(statearr_37250_37277[(2)] = inst_37238);

(statearr_37250_37277[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37246 === (6))){
var inst_37198 = fluree.db.util.core.random_uuid.call(null);
var state_37245__$1 = state_37245;
var statearr_37251_37278 = state_37245__$1;
(statearr_37251_37278[(2)] = inst_37198);

(statearr_37251_37278[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37246 === (3))){
var inst_37243 = (state_37245[(2)]);
var state_37245__$1 = state_37245;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37245__$1,inst_37243);
} else {
if((state_val_37246 === (12))){
var inst_37221 = (state_37245[(7)]);
var state_37245__$1 = state_37245;
var statearr_37252_37279 = state_37245__$1;
(statearr_37252_37279[(2)] = inst_37221);

(statearr_37252_37279[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37246 === (2))){
var _ = (function (){var statearr_37253 = state_37245;
(statearr_37253[(4)] = cljs.core.cons.call(null,(5),(state_37245[(4)])));

return statearr_37253;
})();
var inst_37196 = (tt_id == null);
var state_37245__$1 = state_37245;
if(cljs.core.truth_(inst_37196)){
var statearr_37254_37280 = state_37245__$1;
(statearr_37254_37280[(1)] = (6));

} else {
var statearr_37255_37281 = state_37245__$1;
(statearr_37255_37281[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37246 === (11))){
var inst_37228 = (state_37245[(8)]);
var inst_37221 = (state_37245[(7)]);
var inst_37231 = fluree.db.graphdb.with_t.call(null,inst_37221,inst_37228);
var state_37245__$1 = state_37245;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37245__$1,(14),inst_37231);
} else {
if((state_val_37246 === (9))){
var inst_37228 = (state_37245[(8)]);
var inst_37222 = (state_37245[(9)]);
var inst_37227 = cljs.core.seq.call(null,inst_37222);
var inst_37228__$1 = cljs.core.first.call(null,inst_37227);
var inst_37229 = cljs.core.next.call(null,inst_37227);
var state_37245__$1 = (function (){var statearr_37257 = state_37245;
(statearr_37257[(8)] = inst_37228__$1);

(statearr_37257[(10)] = inst_37229);

return statearr_37257;
})();
if(cljs.core.truth_(inst_37228__$1)){
var statearr_37258_37282 = state_37245__$1;
(statearr_37258_37282[(1)] = (11));

} else {
var statearr_37259_37283 = state_37245__$1;
(statearr_37259_37283[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37246 === (5))){
var _ = (function (){var statearr_37260 = state_37245;
(statearr_37260[(4)] = cljs.core.rest.call(null,(state_37245[(4)])));

return statearr_37260;
})();
var state_37245__$1 = state_37245;
var ex37256 = (state_37245__$1[(2)]);
var statearr_37261_37284 = state_37245__$1;
(statearr_37261_37284[(5)] = ex37256);


if((ex37256 instanceof Error)){
var statearr_37262_37285 = state_37245__$1;
(statearr_37262_37285[(1)] = (4));

(statearr_37262_37285[(5)] = null);

} else {
throw ex37256;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37246 === (14))){
var inst_37229 = (state_37245[(10)]);
var inst_37233 = (state_37245[(2)]);
var inst_37234 = fluree.db.util.async.throw_err.call(null,inst_37233);
var inst_37221 = inst_37234;
var inst_37222 = inst_37229;
var state_37245__$1 = (function (){var statearr_37263 = state_37245;
(statearr_37263[(9)] = inst_37222);

(statearr_37263[(7)] = inst_37221);

return statearr_37263;
})();
var statearr_37264_37286 = state_37245__$1;
(statearr_37264_37286[(2)] = null);

(statearr_37264_37286[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37246 === (10))){
var inst_37240 = (state_37245[(2)]);
var _ = (function (){var statearr_37265 = state_37245;
(statearr_37265[(4)] = cljs.core.rest.call(null,(state_37245[(4)])));

return statearr_37265;
})();
var state_37245__$1 = state_37245;
var statearr_37266_37287 = state_37245__$1;
(statearr_37266_37287[(2)] = inst_37240);

(statearr_37266_37287[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37246 === (8))){
var inst_37201 = (state_37245[(2)]);
var inst_37202 = (function (){var tt_id_SINGLEQUOTE_ = inst_37201;
return (function (db_STAR_,idx){
return cljs.core.assoc.call(null,db_STAR_,idx,cljs.core.assoc.call(null,cljs.core.get.call(null,db_STAR_,idx),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id_SINGLEQUOTE_));
});
})();
var inst_37203 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_37201);
var inst_37204 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37205 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_37206 = (new cljs.core.PersistentVector(null,4,(5),inst_37204,inst_37205,null));
var inst_37207 = cljs.core.reduce.call(null,inst_37202,inst_37203,inst_37206);
var inst_37208 = cljs.core.sort_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),flakes);
var inst_37209 = cljs.core.reverse.call(null,inst_37208);
var inst_37210 = cljs.core.partition_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),inst_37209);
var inst_37218 = cljs.core.seq.call(null,inst_37210);
var inst_37219 = cljs.core.first.call(null,inst_37218);
var inst_37220 = cljs.core.next.call(null,inst_37218);
var inst_37221 = inst_37207;
var inst_37222 = inst_37210;
var state_37245__$1 = (function (){var statearr_37267 = state_37245;
(statearr_37267[(11)] = inst_37219);

(statearr_37267[(9)] = inst_37222);

(statearr_37267[(7)] = inst_37221);

(statearr_37267[(12)] = inst_37220);

return statearr_37267;
})();
var statearr_37268_37288 = state_37245__$1;
(statearr_37268_37288[(2)] = null);

(statearr_37268_37288[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__10903__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__10903__auto____0 = (function (){
var statearr_37269 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37269[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__10903__auto__);

(statearr_37269[(1)] = (1));

return statearr_37269;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__10903__auto____1 = (function (state_37245){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_37245);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e37270){var ex__10906__auto__ = e37270;
var statearr_37271_37289 = state_37245;
(statearr_37271_37289[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_37245[(4)]))){
var statearr_37272_37290 = state_37245;
(statearr_37272_37290[(1)] = cljs.core.first.call(null,(state_37245[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37291 = state_37245;
state_37245 = G__37291;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__10903__auto__ = function(state_37245){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__10903__auto____1.call(this,state_37245);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__10903__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__10903__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_37273 = f__10977__auto__.call(null);
(statearr_37273[(6)] = c__10976__auto__);

return statearr_37273;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.call(null);
var c__10976__auto___37478 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_37409){
var state_val_37410 = (state_37409[(1)]);
if((state_val_37410 === (7))){
var inst_37319 = (state_37409[(7)]);
var inst_37319__$1 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var state_37409__$1 = (function (){var statearr_37411 = state_37409;
(statearr_37411[(7)] = inst_37319__$1);

return statearr_37411;
})();
if(inst_37319__$1){
var statearr_37412_37479 = state_37409__$1;
(statearr_37412_37479[(1)] = (13));

} else {
var statearr_37413_37480 = state_37409__$1;
(statearr_37413_37480[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (20))){
var state_37409__$1 = state_37409;
var statearr_37414_37481 = state_37409__$1;
(statearr_37414_37481[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (27))){
var inst_37355 = (state_37409[(8)]);
var inst_37359 = inst_37355.s;
var state_37409__$1 = state_37409;
var statearr_37416_37482 = state_37409__$1;
(statearr_37416_37482[(2)] = inst_37359);

(statearr_37416_37482[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (1))){
var state_37409__$1 = state_37409;
var statearr_37417_37483 = state_37409__$1;
(statearr_37417_37483[(2)] = null);

(statearr_37417_37483[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (24))){
var inst_37349 = (state_37409[(9)]);
var inst_37353 = cljs.core.first.call(null,inst_37349);
var state_37409__$1 = state_37409;
var statearr_37418_37484 = state_37409__$1;
(statearr_37418_37484[(2)] = inst_37353);

(statearr_37418_37484[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (39))){
var state_37409__$1 = state_37409;
var statearr_37419_37485 = state_37409__$1;
(statearr_37419_37485[(1)] = (41));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (4))){
var inst_37292 = (state_37409[(2)]);
var inst_37293 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_37294 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_37295 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_37296 = cljs.core.PersistentHashMap.fromArrays(inst_37294,inst_37295);
var inst_37297 = cljs.core.ex_info.call(null,inst_37293,inst_37296,inst_37292);
var inst_37298 = cljs.core.async.put_BANG_.call(null,return_chan,inst_37297);
var state_37409__$1 = state_37409;
var statearr_37421_37486 = state_37409__$1;
(statearr_37421_37486[(2)] = inst_37298);

(statearr_37421_37486[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (15))){
var inst_37326 = (state_37409[(2)]);
var state_37409__$1 = state_37409;
if(cljs.core.truth_(inst_37326)){
var statearr_37422_37487 = state_37409__$1;
(statearr_37422_37487[(1)] = (16));

} else {
var statearr_37423_37488 = state_37409__$1;
(statearr_37423_37488[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (21))){
var inst_37375 = (state_37409[(2)]);
var state_37409__$1 = state_37409;
var statearr_37424_37489 = state_37409__$1;
(statearr_37424_37489[(2)] = inst_37375);

(statearr_37424_37489[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (31))){
var inst_37373 = (state_37409[(2)]);
var state_37409__$1 = state_37409;
var statearr_37425_37490 = state_37409__$1;
(statearr_37425_37490[(2)] = inst_37373);

(statearr_37425_37490[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (32))){
var inst_37379 = (state_37409[(10)]);
var inst_37381 = cljs.core.async.put_BANG_.call(null,return_chan,inst_37379);
var state_37409__$1 = state_37409;
var statearr_37426_37491 = state_37409__$1;
(statearr_37426_37491[(2)] = inst_37381);

(statearr_37426_37491[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (40))){
var inst_37402 = (state_37409[(2)]);
var state_37409__$1 = state_37409;
var statearr_37427_37492 = state_37409__$1;
(statearr_37427_37492[(2)] = inst_37402);

(statearr_37427_37492[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (33))){
var inst_37383 = (state_37409[(11)]);
var inst_37379 = (state_37409[(10)]);
var inst_37383__$1 = (inst_37379 == null);
var state_37409__$1 = (function (){var statearr_37428 = state_37409;
(statearr_37428[(11)] = inst_37383__$1);

return statearr_37428;
})();
if(cljs.core.truth_(inst_37383__$1)){
var statearr_37429_37493 = state_37409__$1;
(statearr_37429_37493[(1)] = (35));

} else {
var statearr_37430_37494 = state_37409__$1;
(statearr_37430_37494[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (13))){
var inst_37321 = cljs.core.first.call(null,ident);
var inst_37322 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_37321);
var inst_37323 = (inst_37322 == null);
var state_37409__$1 = state_37409;
var statearr_37431_37495 = state_37409__$1;
(statearr_37431_37495[(2)] = inst_37323);

(statearr_37431_37495[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (22))){
var inst_37349 = (state_37409[(9)]);
var inst_37348 = (state_37409[(2)]);
var inst_37349__$1 = fluree.db.util.async.throw_err.call(null,inst_37348);
var inst_37350 = (inst_37349__$1 == null);
var state_37409__$1 = (function (){var statearr_37432 = state_37409;
(statearr_37432[(9)] = inst_37349__$1);

return statearr_37432;
})();
if(cljs.core.truth_(inst_37350)){
var statearr_37433_37496 = state_37409__$1;
(statearr_37433_37496[(1)] = (23));

} else {
var statearr_37434_37497 = state_37409__$1;
(statearr_37434_37497[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (36))){
var inst_37383 = (state_37409[(11)]);
var state_37409__$1 = state_37409;
var statearr_37435_37498 = state_37409__$1;
(statearr_37435_37498[(2)] = inst_37383);

(statearr_37435_37498[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (41))){
var inst_37397 = cljs.core.async.close_BANG_.call(null,return_chan);
var state_37409__$1 = state_37409;
var statearr_37436_37499 = state_37409__$1;
(statearr_37436_37499[(2)] = inst_37397);

(statearr_37436_37499[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (43))){
var inst_37400 = (state_37409[(2)]);
var state_37409__$1 = state_37409;
var statearr_37437_37500 = state_37409__$1;
(statearr_37437_37500[(2)] = inst_37400);

(statearr_37437_37500[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (29))){
var inst_37364 = cljs.core.pr_str.call(null,ident);
var inst_37365 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_37364].join('');
var inst_37366 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_37367 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_37368 = cljs.core.PersistentHashMap.fromArrays(inst_37366,inst_37367);
var inst_37369 = cljs.core.ex_info.call(null,inst_37365,inst_37368);
var inst_37370 = (function(){throw inst_37369})();
var state_37409__$1 = state_37409;
var statearr_37438_37501 = state_37409__$1;
(statearr_37438_37501[(2)] = inst_37370);

(statearr_37438_37501[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (6))){
var inst_37306 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37307 = [ident];
var inst_37308 = (new cljs.core.PersistentVector(null,1,(5),inst_37306,inst_37307,null));
var inst_37309 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_37308);
var state_37409__$1 = state_37409;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37409__$1,(9),inst_37309);
} else {
if((state_val_37410 === (28))){
var inst_37361 = (state_37409[(2)]);
var state_37409__$1 = state_37409;
var statearr_37439_37502 = state_37409__$1;
(statearr_37439_37502[(2)] = inst_37361);

(statearr_37439_37502[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (25))){
var inst_37355 = (state_37409[(8)]);
var inst_37355__$1 = (state_37409[(2)]);
var inst_37356 = (inst_37355__$1 == null);
var state_37409__$1 = (function (){var statearr_37440 = state_37409;
(statearr_37440[(8)] = inst_37355__$1);

return statearr_37440;
})();
if(cljs.core.truth_(inst_37356)){
var statearr_37441_37503 = state_37409__$1;
(statearr_37441_37503[(1)] = (26));

} else {
var statearr_37442_37504 = state_37409__$1;
(statearr_37442_37504[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (34))){
var inst_37404 = (state_37409[(2)]);
var _ = (function (){var statearr_37443 = state_37409;
(statearr_37443[(4)] = cljs.core.rest.call(null,(state_37409[(4)])));

return statearr_37443;
})();
var state_37409__$1 = state_37409;
var statearr_37444_37505 = state_37409__$1;
(statearr_37444_37505[(2)] = inst_37404);

(statearr_37444_37505[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (17))){
var inst_37337 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var state_37409__$1 = state_37409;
if(inst_37337){
var statearr_37445_37506 = state_37409__$1;
(statearr_37445_37506[(1)] = (19));

} else {
var statearr_37446_37507 = state_37409__$1;
(statearr_37446_37507[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (3))){
var inst_37407 = (state_37409[(2)]);
var state_37409__$1 = state_37409;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37409__$1,inst_37407);
} else {
if((state_val_37410 === (12))){
var inst_37317 = (state_37409[(2)]);
var state_37409__$1 = state_37409;
var statearr_37447_37508 = state_37409__$1;
(statearr_37447_37508[(2)] = inst_37317);

(statearr_37447_37508[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (2))){
var _ = (function (){var statearr_37448 = state_37409;
(statearr_37448[(4)] = cljs.core.cons.call(null,(5),(state_37409[(4)])));

return statearr_37448;
})();
var inst_37304 = typeof ident === 'number';
var state_37409__$1 = state_37409;
if(cljs.core.truth_(inst_37304)){
var statearr_37449_37509 = state_37409__$1;
(statearr_37449_37509[(1)] = (6));

} else {
var statearr_37450_37510 = state_37409__$1;
(statearr_37450_37510[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (23))){
var state_37409__$1 = state_37409;
var statearr_37451_37511 = state_37409__$1;
(statearr_37451_37511[(2)] = null);

(statearr_37451_37511[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (35))){
var state_37409__$1 = state_37409;
var statearr_37452_37512 = state_37409__$1;
(statearr_37452_37512[(2)] = strict_QMARK_);

(statearr_37452_37512[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (19))){
var inst_37340 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37341 = cljs.core.first.call(null,ident);
var inst_37342 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_37341);
var inst_37343 = cljs.core.second.call(null,ident);
var inst_37344 = [inst_37342,inst_37343];
var inst_37345 = (new cljs.core.PersistentVector(null,2,(5),inst_37340,inst_37344,null));
var inst_37346 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_37345);
var state_37409__$1 = state_37409;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37409__$1,(22),inst_37346);
} else {
if((state_val_37410 === (11))){
var state_37409__$1 = state_37409;
var statearr_37454_37513 = state_37409__$1;
(statearr_37454_37513[(2)] = null);

(statearr_37454_37513[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (9))){
var inst_37311 = (state_37409[(2)]);
var inst_37312 = fluree.db.util.async.throw_err.call(null,inst_37311);
var inst_37313 = cljs.core.not_empty.call(null,inst_37312);
var state_37409__$1 = state_37409;
if(cljs.core.truth_(inst_37313)){
var statearr_37455_37514 = state_37409__$1;
(statearr_37455_37514[(1)] = (10));

} else {
var statearr_37456_37515 = state_37409__$1;
(statearr_37456_37515[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (5))){
var _ = (function (){var statearr_37457 = state_37409;
(statearr_37457[(4)] = cljs.core.rest.call(null,(state_37409[(4)])));

return statearr_37457;
})();
var state_37409__$1 = state_37409;
var ex37453 = (state_37409__$1[(2)]);
var statearr_37458_37516 = state_37409__$1;
(statearr_37458_37516[(5)] = ex37453);


var statearr_37459_37517 = state_37409__$1;
(statearr_37459_37517[(1)] = (4));

(statearr_37459_37517[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (14))){
var inst_37319 = (state_37409[(7)]);
var state_37409__$1 = state_37409;
var statearr_37460_37518 = state_37409__$1;
(statearr_37460_37518[(2)] = inst_37319);

(statearr_37460_37518[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (26))){
var state_37409__$1 = state_37409;
var statearr_37461_37519 = state_37409__$1;
(statearr_37461_37519[(2)] = null);

(statearr_37461_37519[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (16))){
var inst_37328 = cljs.core.first.call(null,ident);
var inst_37329 = cljs.core.pr_str.call(null,inst_37328);
var inst_37330 = ["Subject ID lookup failed. The predicate ",inst_37329," does not exist."].join('');
var inst_37331 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_37332 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_37333 = cljs.core.PersistentHashMap.fromArrays(inst_37331,inst_37332);
var inst_37334 = cljs.core.ex_info.call(null,inst_37330,inst_37333);
var inst_37335 = (function(){throw inst_37334})();
var state_37409__$1 = state_37409;
var statearr_37462_37520 = state_37409__$1;
(statearr_37462_37520[(2)] = inst_37335);

(statearr_37462_37520[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (38))){
var inst_37389 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_37390 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_37391 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_37392 = cljs.core.PersistentHashMap.fromArrays(inst_37390,inst_37391);
var inst_37393 = cljs.core.ex_info.call(null,inst_37389,inst_37392);
var inst_37394 = cljs.core.async.put_BANG_.call(null,return_chan,inst_37393);
var state_37409__$1 = state_37409;
var statearr_37463_37521 = state_37409__$1;
(statearr_37463_37521[(2)] = inst_37394);

(statearr_37463_37521[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (30))){
var state_37409__$1 = state_37409;
var statearr_37464_37522 = state_37409__$1;
(statearr_37464_37522[(2)] = null);

(statearr_37464_37522[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (10))){
var state_37409__$1 = state_37409;
var statearr_37465_37523 = state_37409__$1;
(statearr_37465_37523[(2)] = ident);

(statearr_37465_37523[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (18))){
var inst_37377 = (state_37409[(2)]);
var state_37409__$1 = state_37409;
var statearr_37466_37524 = state_37409__$1;
(statearr_37466_37524[(2)] = inst_37377);

(statearr_37466_37524[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (42))){
var state_37409__$1 = state_37409;
var statearr_37467_37525 = state_37409__$1;
(statearr_37467_37525[(2)] = null);

(statearr_37467_37525[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (37))){
var inst_37387 = (state_37409[(2)]);
var state_37409__$1 = state_37409;
if(cljs.core.truth_(inst_37387)){
var statearr_37468_37526 = state_37409__$1;
(statearr_37468_37526[(1)] = (38));

} else {
var statearr_37469_37527 = state_37409__$1;
(statearr_37469_37527[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37410 === (8))){
var inst_37379 = (state_37409[(10)]);
var inst_37379__$1 = (state_37409[(2)]);
var state_37409__$1 = (function (){var statearr_37470 = state_37409;
(statearr_37470[(10)] = inst_37379__$1);

return statearr_37470;
})();
if(cljs.core.truth_(inst_37379__$1)){
var statearr_37471_37528 = state_37409__$1;
(statearr_37471_37528[(1)] = (32));

} else {
var statearr_37472_37529 = state_37409__$1;
(statearr_37472_37529[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__10903__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__10903__auto____0 = (function (){
var statearr_37473 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37473[(0)] = fluree$db$graphdb$subid_$_state_machine__10903__auto__);

(statearr_37473[(1)] = (1));

return statearr_37473;
});
var fluree$db$graphdb$subid_$_state_machine__10903__auto____1 = (function (state_37409){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_37409);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e37474){var ex__10906__auto__ = e37474;
var statearr_37475_37530 = state_37409;
(statearr_37475_37530[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_37409[(4)]))){
var statearr_37476_37531 = state_37409;
(statearr_37476_37531[(1)] = cljs.core.first.call(null,(state_37409[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37532 = state_37409;
state_37409 = G__37532;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__10903__auto__ = function(state_37409){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__10903__auto____1.call(this,state_37409);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__10903__auto____0;
fluree$db$graphdb$subid_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__10903__auto____1;
return fluree$db$graphdb$subid_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_37477 = f__10977__auto__.call(null);
(statearr_37477[(6)] = c__10976__auto___37478);

return statearr_37477;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));


return return_chan;
});
fluree.db.graphdb.graphdb_latest_db = (function fluree$db$graphdb$graphdb_latest_db(p__37533){
var map__37534 = p__37533;
var map__37534__$1 = cljs.core.__destructure_map.call(null,map__37534);
var current_db_fn = cljs.core.get.call(null,map__37534__$1,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
var permissions = cljs.core.get.call(null,map__37534__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_37550){
var state_val_37551 = (state_37550[(1)]);
if((state_val_37551 === (1))){
var state_37550__$1 = state_37550;
var statearr_37552_37566 = state_37550__$1;
(statearr_37552_37566[(2)] = null);

(statearr_37552_37566[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37551 === (2))){
var _ = (function (){var statearr_37553 = state_37550;
(statearr_37553[(4)] = cljs.core.cons.call(null,(5),(state_37550[(4)])));

return statearr_37553;
})();
var inst_37541 = current_db_fn.call(null);
var state_37550__$1 = state_37550;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37550__$1,(6),inst_37541);
} else {
if((state_val_37551 === (3))){
var inst_37548 = (state_37550[(2)]);
var state_37550__$1 = state_37550;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37550__$1,inst_37548);
} else {
if((state_val_37551 === (4))){
var inst_37535 = (state_37550[(2)]);
var state_37550__$1 = state_37550;
var statearr_37555_37567 = state_37550__$1;
(statearr_37555_37567[(2)] = inst_37535);

(statearr_37555_37567[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37551 === (5))){
var _ = (function (){var statearr_37556 = state_37550;
(statearr_37556[(4)] = cljs.core.rest.call(null,(state_37550[(4)])));

return statearr_37556;
})();
var state_37550__$1 = state_37550;
var ex37554 = (state_37550__$1[(2)]);
var statearr_37557_37568 = state_37550__$1;
(statearr_37557_37568[(5)] = ex37554);


if((ex37554 instanceof Error)){
var statearr_37558_37569 = state_37550__$1;
(statearr_37558_37569[(1)] = (4));

(statearr_37558_37569[(5)] = null);

} else {
throw ex37554;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37551 === (6))){
var inst_37543 = (state_37550[(2)]);
var inst_37544 = fluree.db.util.async.throw_err.call(null,inst_37543);
var inst_37545 = cljs.core.assoc.call(null,inst_37544,new cljs.core.Keyword(null,"permissions","permissions",67803075),permissions);
var _ = (function (){var statearr_37559 = state_37550;
(statearr_37559[(4)] = cljs.core.rest.call(null,(state_37550[(4)])));

return statearr_37559;
})();
var state_37550__$1 = state_37550;
var statearr_37560_37570 = state_37550__$1;
(statearr_37560_37570[(2)] = inst_37545);

(statearr_37560_37570[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__10903__auto__ = null;
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__10903__auto____0 = (function (){
var statearr_37561 = [null,null,null,null,null,null,null];
(statearr_37561[(0)] = fluree$db$graphdb$graphdb_latest_db_$_state_machine__10903__auto__);

(statearr_37561[(1)] = (1));

return statearr_37561;
});
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__10903__auto____1 = (function (state_37550){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_37550);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e37562){var ex__10906__auto__ = e37562;
var statearr_37563_37571 = state_37550;
(statearr_37563_37571[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_37550[(4)]))){
var statearr_37564_37572 = state_37550;
(statearr_37564_37572[(1)] = cljs.core.first.call(null,(state_37550[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37573 = state_37550;
state_37550 = G__37573;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$graphdb$graphdb_latest_db_$_state_machine__10903__auto__ = function(state_37550){
switch(arguments.length){
case 0:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__10903__auto____1.call(this,state_37550);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$graphdb_latest_db_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__10903__auto____0;
fluree$db$graphdb$graphdb_latest_db_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__10903__auto____1;
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_37565 = f__10977__auto__.call(null);
(statearr_37565[(6)] = c__10976__auto__);

return statearr_37565;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
fluree.db.graphdb.graphdb_root_db = (function fluree$db$graphdb$graphdb_root_db(this$){
return cljs.core.assoc.call(null,this$,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
});
fluree.db.graphdb.graphdb_c_prop = (function fluree$db$graphdb$graphdb_c_prop(p__37574,property,collection){
var map__37575 = p__37574;
var map__37575__$1 = cljs.core.__destructure_map.call(null,map__37575);
var schema = cljs.core.get.call(null,map__37575__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"partition","partition",1174740751),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_.call(null,collection)){
return cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
});
fluree.db.graphdb.graphdb_p_prop = (function fluree$db$graphdb$graphdb_p_prop(p__37576,property,predicate){
var map__37577 = p__37576;
var map__37577__$1 = cljs.core.__destructure_map.call(null,map__37577);
var this$ = map__37577__$1;
var schema = cljs.core.get.call(null,map__37577__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__37578 = cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return fluree.db.dbproto._c_prop.call(null,this$,new cljs.core.Keyword(null,"partition","partition",1174740751),G__37578);
} else {
return G__37578;
}
});
/**
 * Lookup the predicate name if needed; return ::no-pred if pred arg is nil so
 *   we can differentiate between that and (dbproto/-p-prop ...) returning nil
 */
fluree.db.graphdb.graphdb_pred_name = (function fluree$db$graphdb$graphdb_pred_name(this$,pred){
if((pred == null)){
return new cljs.core.Keyword("fluree.db.graphdb","no-pred","fluree.db.graphdb/no-pred",1182779470);
} else {
if(typeof pred === 'string'){
return pred;
} else {
return fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);

}
}
});
/**
 * resolves a tags's value given a tag subject id; optionally shortening the
 *   return value if it starts with the given predicate name
 */
fluree.db.graphdb.graphdb_tag = (function fluree$db$graphdb$graphdb_tag(var_args){
var G__37580 = arguments.length;
switch (G__37580) {
case 2:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_id){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_37612){
var state_val_37613 = (state_37612[(1)]);
if((state_val_37613 === (7))){
var state_37612__$1 = state_37612;
var statearr_37614_37708 = state_37612__$1;
(statearr_37614_37708[(2)] = null);

(statearr_37614_37708[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37613 === (1))){
var state_37612__$1 = state_37612;
var statearr_37615_37709 = state_37612__$1;
(statearr_37615_37709[(2)] = null);

(statearr_37615_37709[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37613 === (4))){
var inst_37581 = (state_37612[(2)]);
var state_37612__$1 = state_37612;
var statearr_37616_37710 = state_37612__$1;
(statearr_37616_37710[(2)] = inst_37581);

(statearr_37616_37710[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37613 === (6))){
var inst_37595 = (state_37612[(7)]);
var inst_37594 = (state_37612[(2)]);
var inst_37595__$1 = fluree.db.util.async.throw_err.call(null,inst_37594);
var inst_37596 = (inst_37595__$1 == null);
var state_37612__$1 = (function (){var statearr_37617 = state_37612;
(statearr_37617[(7)] = inst_37595__$1);

return statearr_37617;
})();
if(cljs.core.truth_(inst_37596)){
var statearr_37618_37711 = state_37612__$1;
(statearr_37618_37711[(1)] = (7));

} else {
var statearr_37619_37712 = state_37612__$1;
(statearr_37619_37712[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37613 === (3))){
var inst_37610 = (state_37612[(2)]);
var state_37612__$1 = state_37612;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37612__$1,inst_37610);
} else {
if((state_val_37613 === (12))){
var inst_37607 = (state_37612[(2)]);
var _ = (function (){var statearr_37620 = state_37612;
(statearr_37620[(4)] = cljs.core.rest.call(null,(state_37612[(4)])));

return statearr_37620;
})();
var state_37612__$1 = state_37612;
var statearr_37621_37713 = state_37612__$1;
(statearr_37621_37713[(2)] = inst_37607);

(statearr_37621_37713[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37613 === (2))){
var _ = (function (){var statearr_37622 = state_37612;
(statearr_37622[(4)] = cljs.core.cons.call(null,(5),(state_37612[(4)])));

return statearr_37622;
})();
var inst_37588 = fluree.db.dbproto._rootdb.call(null,this$);
var inst_37589 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37590 = [tag_id,(30)];
var inst_37591 = (new cljs.core.PersistentVector(null,2,(5),inst_37589,inst_37590,null));
var inst_37592 = fluree.db.query.range.index_range.call(null,inst_37588,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_37591);
var state_37612__$1 = state_37612;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37612__$1,(6),inst_37592);
} else {
if((state_val_37613 === (11))){
var inst_37601 = (state_37612[(8)]);
var inst_37605 = inst_37601.o;
var state_37612__$1 = state_37612;
var statearr_37624_37714 = state_37612__$1;
(statearr_37624_37714[(2)] = inst_37605);

(statearr_37624_37714[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37613 === (9))){
var inst_37601 = (state_37612[(8)]);
var inst_37601__$1 = (state_37612[(2)]);
var inst_37602 = (inst_37601__$1 == null);
var state_37612__$1 = (function (){var statearr_37625 = state_37612;
(statearr_37625[(8)] = inst_37601__$1);

return statearr_37625;
})();
if(cljs.core.truth_(inst_37602)){
var statearr_37626_37715 = state_37612__$1;
(statearr_37626_37715[(1)] = (10));

} else {
var statearr_37627_37716 = state_37612__$1;
(statearr_37627_37716[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37613 === (5))){
var _ = (function (){var statearr_37628 = state_37612;
(statearr_37628[(4)] = cljs.core.rest.call(null,(state_37612[(4)])));

return statearr_37628;
})();
var state_37612__$1 = state_37612;
var ex37623 = (state_37612__$1[(2)]);
var statearr_37629_37717 = state_37612__$1;
(statearr_37629_37717[(5)] = ex37623);


if((ex37623 instanceof Error)){
var statearr_37630_37718 = state_37612__$1;
(statearr_37630_37718[(1)] = (4));

(statearr_37630_37718[(5)] = null);

} else {
throw ex37623;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37613 === (10))){
var state_37612__$1 = state_37612;
var statearr_37631_37719 = state_37612__$1;
(statearr_37631_37719[(2)] = null);

(statearr_37631_37719[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37613 === (8))){
var inst_37595 = (state_37612[(7)]);
var inst_37599 = cljs.core.first.call(null,inst_37595);
var state_37612__$1 = state_37612;
var statearr_37632_37720 = state_37612__$1;
(statearr_37632_37720[(2)] = inst_37599);

(statearr_37632_37720[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__10903__auto__ = null;
var fluree$db$graphdb$state_machine__10903__auto____0 = (function (){
var statearr_37633 = [null,null,null,null,null,null,null,null,null];
(statearr_37633[(0)] = fluree$db$graphdb$state_machine__10903__auto__);

(statearr_37633[(1)] = (1));

return statearr_37633;
});
var fluree$db$graphdb$state_machine__10903__auto____1 = (function (state_37612){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_37612);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e37634){var ex__10906__auto__ = e37634;
var statearr_37635_37721 = state_37612;
(statearr_37635_37721[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_37612[(4)]))){
var statearr_37636_37722 = state_37612;
(statearr_37636_37722[(1)] = cljs.core.first.call(null,(state_37612[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37723 = state_37612;
state_37612 = G__37723;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__10903__auto__ = function(state_37612){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__10903__auto____1.call(this,state_37612);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__10903__auto____0;
fluree$db$graphdb$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__10903__auto____1;
return fluree$db$graphdb$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_37637 = f__10977__auto__.call(null);
(statearr_37637[(6)] = c__10976__auto__);

return statearr_37637;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_id,pred){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_37673){
var state_val_37674 = (state_37673[(1)]);
if((state_val_37674 === (7))){
var inst_37647 = fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_37673__$1 = state_37673;
var statearr_37675_37724 = state_37673__$1;
(statearr_37675_37724[(2)] = inst_37647);

(statearr_37675_37724[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37674 === (1))){
var state_37673__$1 = state_37673;
var statearr_37676_37725 = state_37673__$1;
(statearr_37676_37725[(2)] = null);

(statearr_37676_37725[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37674 === (4))){
var inst_37638 = (state_37673[(2)]);
var state_37673__$1 = state_37673;
var statearr_37677_37726 = state_37673__$1;
(statearr_37677_37726[(2)] = inst_37638);

(statearr_37677_37726[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37674 === (15))){
var inst_37668 = (state_37673[(2)]);
var _ = (function (){var statearr_37678 = state_37673;
(statearr_37678[(4)] = cljs.core.rest.call(null,(state_37673[(4)])));

return statearr_37678;
})();
var state_37673__$1 = state_37673;
var statearr_37679_37727 = state_37673__$1;
(statearr_37679_37727[(2)] = inst_37668);

(statearr_37679_37727[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37674 === (13))){
var inst_37653 = (state_37673[(7)]);
var inst_37659 = clojure.string.includes_QMARK_.call(null,inst_37653,":");
var state_37673__$1 = state_37673;
if(inst_37659){
var statearr_37680_37728 = state_37673__$1;
(statearr_37680_37728[(1)] = (16));

} else {
var statearr_37681_37729 = state_37673__$1;
(statearr_37681_37729[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37674 === (6))){
var state_37673__$1 = state_37673;
var statearr_37682_37730 = state_37673__$1;
(statearr_37682_37730[(2)] = pred);

(statearr_37682_37730[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37674 === (17))){
var inst_37653 = (state_37673[(7)]);
var state_37673__$1 = state_37673;
var statearr_37683_37731 = state_37673__$1;
(statearr_37683_37731[(2)] = inst_37653);

(statearr_37683_37731[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37674 === (3))){
var inst_37671 = (state_37673[(2)]);
var state_37673__$1 = state_37673;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37673__$1,inst_37671);
} else {
if((state_val_37674 === (12))){
var inst_37657 = (state_37673[(2)]);
var state_37673__$1 = state_37673;
if(cljs.core.truth_(inst_37657)){
var statearr_37684_37732 = state_37673__$1;
(statearr_37684_37732[(1)] = (13));

} else {
var statearr_37685_37733 = state_37673__$1;
(statearr_37685_37733[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37674 === (2))){
var _ = (function (){var statearr_37686 = state_37673;
(statearr_37686[(4)] = cljs.core.cons.call(null,(5),(state_37673[(4)])));

return statearr_37686;
})();
var inst_37644 = typeof pred === 'string';
var state_37673__$1 = state_37673;
if(cljs.core.truth_(inst_37644)){
var statearr_37687_37734 = state_37673__$1;
(statearr_37687_37734[(1)] = (6));

} else {
var statearr_37688_37735 = state_37673__$1;
(statearr_37688_37735[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37674 === (11))){
var inst_37649 = (state_37673[(8)]);
var state_37673__$1 = state_37673;
var statearr_37690_37736 = state_37673__$1;
(statearr_37690_37736[(2)] = inst_37649);

(statearr_37690_37736[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37674 === (9))){
var inst_37649 = (state_37673[(8)]);
var inst_37652 = (state_37673[(2)]);
var inst_37653 = fluree.db.util.async.throw_err.call(null,inst_37652);
var state_37673__$1 = (function (){var statearr_37691 = state_37673;
(statearr_37691[(7)] = inst_37653);

return statearr_37691;
})();
if(cljs.core.truth_(inst_37649)){
var statearr_37692_37737 = state_37673__$1;
(statearr_37692_37737[(1)] = (10));

} else {
var statearr_37693_37738 = state_37673__$1;
(statearr_37693_37738[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37674 === (5))){
var _ = (function (){var statearr_37694 = state_37673;
(statearr_37694[(4)] = cljs.core.rest.call(null,(state_37673[(4)])));

return statearr_37694;
})();
var state_37673__$1 = state_37673;
var ex37689 = (state_37673__$1[(2)]);
var statearr_37695_37739 = state_37673__$1;
(statearr_37695_37739[(5)] = ex37689);


if((ex37689 instanceof Error)){
var statearr_37696_37740 = state_37673__$1;
(statearr_37696_37740[(1)] = (4));

(statearr_37696_37740[(5)] = null);

} else {
throw ex37689;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37674 === (14))){
var state_37673__$1 = state_37673;
var statearr_37697_37741 = state_37673__$1;
(statearr_37697_37741[(2)] = null);

(statearr_37697_37741[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37674 === (16))){
var inst_37653 = (state_37673[(7)]);
var inst_37661 = clojure.string.split.call(null,inst_37653,/:/);
var inst_37662 = cljs.core.second.call(null,inst_37661);
var state_37673__$1 = state_37673;
var statearr_37698_37742 = state_37673__$1;
(statearr_37698_37742[(2)] = inst_37662);

(statearr_37698_37742[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37674 === (10))){
var inst_37653 = (state_37673[(7)]);
var state_37673__$1 = state_37673;
var statearr_37699_37743 = state_37673__$1;
(statearr_37699_37743[(2)] = inst_37653);

(statearr_37699_37743[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37674 === (18))){
var inst_37665 = (state_37673[(2)]);
var state_37673__$1 = state_37673;
var statearr_37700_37744 = state_37673__$1;
(statearr_37700_37744[(2)] = inst_37665);

(statearr_37700_37744[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37674 === (8))){
var inst_37649 = (state_37673[(2)]);
var inst_37650 = fluree.db.dbproto._tag.call(null,this$,tag_id);
var state_37673__$1 = (function (){var statearr_37701 = state_37673;
(statearr_37701[(8)] = inst_37649);

return statearr_37701;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37673__$1,(9),inst_37650);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__10903__auto__ = null;
var fluree$db$graphdb$state_machine__10903__auto____0 = (function (){
var statearr_37702 = [null,null,null,null,null,null,null,null,null];
(statearr_37702[(0)] = fluree$db$graphdb$state_machine__10903__auto__);

(statearr_37702[(1)] = (1));

return statearr_37702;
});
var fluree$db$graphdb$state_machine__10903__auto____1 = (function (state_37673){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_37673);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e37703){var ex__10906__auto__ = e37703;
var statearr_37704_37745 = state_37673;
(statearr_37704_37745[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_37673[(4)]))){
var statearr_37705_37746 = state_37673;
(statearr_37705_37746[(1)] = cljs.core.first.call(null,(state_37673[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37747 = state_37673;
state_37673 = G__37747;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__10903__auto__ = function(state_37673){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__10903__auto____1.call(this,state_37673);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__10903__auto____0;
fluree$db$graphdb$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__10903__auto____1;
return fluree$db$graphdb$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_37706 = f__10977__auto__.call(null);
(statearr_37706[(6)] = c__10976__auto__);

return statearr_37706;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$lang$maxFixedArity = 3);

fluree.db.graphdb.graphdb_tag_id = (function fluree$db$graphdb$graphdb_tag_id(var_args){
var G__37749 = arguments.length;
switch (G__37749) {
case 2:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_name){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_37782){
var state_val_37783 = (state_37782[(1)]);
if((state_val_37783 === (7))){
var state_37782__$1 = state_37782;
var statearr_37784_37872 = state_37782__$1;
(statearr_37784_37872[(2)] = null);

(statearr_37784_37872[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37783 === (1))){
var state_37782__$1 = state_37782;
var statearr_37785_37873 = state_37782__$1;
(statearr_37785_37873[(2)] = null);

(statearr_37785_37873[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37783 === (4))){
var inst_37750 = (state_37782[(2)]);
var state_37782__$1 = state_37782;
var statearr_37786_37874 = state_37782__$1;
(statearr_37786_37874[(2)] = inst_37750);

(statearr_37786_37874[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37783 === (6))){
var inst_37765 = (state_37782[(7)]);
var inst_37764 = (state_37782[(2)]);
var inst_37765__$1 = fluree.db.util.async.throw_err.call(null,inst_37764);
var inst_37766 = (inst_37765__$1 == null);
var state_37782__$1 = (function (){var statearr_37787 = state_37782;
(statearr_37787[(7)] = inst_37765__$1);

return statearr_37787;
})();
if(cljs.core.truth_(inst_37766)){
var statearr_37788_37875 = state_37782__$1;
(statearr_37788_37875[(1)] = (7));

} else {
var statearr_37789_37876 = state_37782__$1;
(statearr_37789_37876[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37783 === (3))){
var inst_37780 = (state_37782[(2)]);
var state_37782__$1 = state_37782;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37782__$1,inst_37780);
} else {
if((state_val_37783 === (12))){
var inst_37777 = (state_37782[(2)]);
var _ = (function (){var statearr_37790 = state_37782;
(statearr_37790[(4)] = cljs.core.rest.call(null,(state_37782[(4)])));

return statearr_37790;
})();
var state_37782__$1 = state_37782;
var statearr_37791_37877 = state_37782__$1;
(statearr_37791_37877[(2)] = inst_37777);

(statearr_37791_37877[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37783 === (2))){
var _ = (function (){var statearr_37792 = state_37782;
(statearr_37792[(4)] = cljs.core.cons.call(null,(5),(state_37782[(4)])));

return statearr_37792;
})();
var inst_37756 = (30);
var inst_37758 = fluree.db.dbproto._rootdb.call(null,this$);
var inst_37759 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37760 = [inst_37756,tag_name];
var inst_37761 = (new cljs.core.PersistentVector(null,2,(5),inst_37759,inst_37760,null));
var inst_37762 = fluree.db.query.range.index_range.call(null,inst_37758,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_37761);
var state_37782__$1 = state_37782;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37782__$1,(6),inst_37762);
} else {
if((state_val_37783 === (11))){
var inst_37771 = (state_37782[(8)]);
var inst_37775 = inst_37771.s;
var state_37782__$1 = state_37782;
var statearr_37794_37878 = state_37782__$1;
(statearr_37794_37878[(2)] = inst_37775);

(statearr_37794_37878[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37783 === (9))){
var inst_37771 = (state_37782[(8)]);
var inst_37771__$1 = (state_37782[(2)]);
var inst_37772 = (inst_37771__$1 == null);
var state_37782__$1 = (function (){var statearr_37795 = state_37782;
(statearr_37795[(8)] = inst_37771__$1);

return statearr_37795;
})();
if(cljs.core.truth_(inst_37772)){
var statearr_37796_37879 = state_37782__$1;
(statearr_37796_37879[(1)] = (10));

} else {
var statearr_37797_37880 = state_37782__$1;
(statearr_37797_37880[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37783 === (5))){
var _ = (function (){var statearr_37798 = state_37782;
(statearr_37798[(4)] = cljs.core.rest.call(null,(state_37782[(4)])));

return statearr_37798;
})();
var state_37782__$1 = state_37782;
var ex37793 = (state_37782__$1[(2)]);
var statearr_37799_37881 = state_37782__$1;
(statearr_37799_37881[(5)] = ex37793);


if((ex37793 instanceof Error)){
var statearr_37800_37882 = state_37782__$1;
(statearr_37800_37882[(1)] = (4));

(statearr_37800_37882[(5)] = null);

} else {
throw ex37793;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37783 === (10))){
var state_37782__$1 = state_37782;
var statearr_37801_37883 = state_37782__$1;
(statearr_37801_37883[(2)] = null);

(statearr_37801_37883[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37783 === (8))){
var inst_37765 = (state_37782[(7)]);
var inst_37769 = cljs.core.first.call(null,inst_37765);
var state_37782__$1 = state_37782;
var statearr_37802_37884 = state_37782__$1;
(statearr_37802_37884[(2)] = inst_37769);

(statearr_37802_37884[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__10903__auto__ = null;
var fluree$db$graphdb$state_machine__10903__auto____0 = (function (){
var statearr_37803 = [null,null,null,null,null,null,null,null,null];
(statearr_37803[(0)] = fluree$db$graphdb$state_machine__10903__auto__);

(statearr_37803[(1)] = (1));

return statearr_37803;
});
var fluree$db$graphdb$state_machine__10903__auto____1 = (function (state_37782){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_37782);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e37804){var ex__10906__auto__ = e37804;
var statearr_37805_37885 = state_37782;
(statearr_37805_37885[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_37782[(4)]))){
var statearr_37806_37886 = state_37782;
(statearr_37806_37886[(1)] = cljs.core.first.call(null,(state_37782[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37887 = state_37782;
state_37782 = G__37887;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__10903__auto__ = function(state_37782){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__10903__auto____1.call(this,state_37782);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__10903__auto____0;
fluree$db$graphdb$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__10903__auto____1;
return fluree$db$graphdb$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_37807 = f__10977__auto__.call(null);
(statearr_37807[(6)] = c__10976__auto__);

return statearr_37807;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_name,pred){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_37842){
var state_val_37843 = (state_37842[(1)]);
if((state_val_37843 === (7))){
var inst_37821 = typeof pred === 'string';
var state_37842__$1 = state_37842;
if(cljs.core.truth_(inst_37821)){
var statearr_37844_37888 = state_37842__$1;
(statearr_37844_37888[(1)] = (10));

} else {
var statearr_37845_37889 = state_37842__$1;
(statearr_37845_37889[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37843 === (1))){
var state_37842__$1 = state_37842;
var statearr_37846_37890 = state_37842__$1;
(statearr_37846_37890[(2)] = null);

(statearr_37846_37890[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37843 === (4))){
var inst_37808 = (state_37842[(2)]);
var state_37842__$1 = state_37842;
var statearr_37847_37891 = state_37842__$1;
(statearr_37847_37891[(2)] = inst_37808);

(statearr_37847_37891[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37843 === (15))){
var inst_37835 = (state_37842[(2)]);
var state_37842__$1 = state_37842;
var statearr_37848_37892 = state_37842__$1;
(statearr_37848_37892[(2)] = inst_37835);

(statearr_37848_37892[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37843 === (13))){
var inst_37826 = (state_37842[(7)]);
var inst_37828 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_37826),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_37829 = fluree.db.dbproto._tag_id.call(null,this$,inst_37828);
var state_37842__$1 = state_37842;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37842__$1,(16),inst_37829);
} else {
if((state_val_37843 === (6))){
var inst_37816 = fluree.db.dbproto._tag_id.call(null,this$,tag_name);
var state_37842__$1 = state_37842;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37842__$1,(9),inst_37816);
} else {
if((state_val_37843 === (3))){
var inst_37840 = (state_37842[(2)]);
var state_37842__$1 = state_37842;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37842__$1,inst_37840);
} else {
if((state_val_37843 === (12))){
var inst_37826 = (state_37842[(7)]);
var inst_37826__$1 = (state_37842[(2)]);
var state_37842__$1 = (function (){var statearr_37849 = state_37842;
(statearr_37849[(7)] = inst_37826__$1);

return statearr_37849;
})();
if(cljs.core.truth_(inst_37826__$1)){
var statearr_37850_37893 = state_37842__$1;
(statearr_37850_37893[(1)] = (13));

} else {
var statearr_37851_37894 = state_37842__$1;
(statearr_37851_37894[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37843 === (2))){
var _ = (function (){var statearr_37852 = state_37842;
(statearr_37852[(4)] = cljs.core.cons.call(null,(5),(state_37842[(4)])));

return statearr_37852;
})();
var inst_37814 = clojure.string.includes_QMARK_.call(null,tag_name,"/");
var state_37842__$1 = state_37842;
if(inst_37814){
var statearr_37853_37895 = state_37842__$1;
(statearr_37853_37895[(1)] = (6));

} else {
var statearr_37854_37896 = state_37842__$1;
(statearr_37854_37896[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37843 === (11))){
var inst_37824 = fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_37842__$1 = state_37842;
var statearr_37856_37897 = state_37842__$1;
(statearr_37856_37897[(2)] = inst_37824);

(statearr_37856_37897[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37843 === (9))){
var inst_37818 = (state_37842[(2)]);
var inst_37819 = fluree.db.util.async.throw_err.call(null,inst_37818);
var state_37842__$1 = state_37842;
var statearr_37857_37898 = state_37842__$1;
(statearr_37857_37898[(2)] = inst_37819);

(statearr_37857_37898[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37843 === (5))){
var _ = (function (){var statearr_37858 = state_37842;
(statearr_37858[(4)] = cljs.core.rest.call(null,(state_37842[(4)])));

return statearr_37858;
})();
var state_37842__$1 = state_37842;
var ex37855 = (state_37842__$1[(2)]);
var statearr_37859_37899 = state_37842__$1;
(statearr_37859_37899[(5)] = ex37855);


if((ex37855 instanceof Error)){
var statearr_37860_37900 = state_37842__$1;
(statearr_37860_37900[(1)] = (4));

(statearr_37860_37900[(5)] = null);

} else {
throw ex37855;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37843 === (14))){
var state_37842__$1 = state_37842;
var statearr_37861_37901 = state_37842__$1;
(statearr_37861_37901[(2)] = null);

(statearr_37861_37901[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37843 === (16))){
var inst_37831 = (state_37842[(2)]);
var inst_37832 = fluree.db.util.async.throw_err.call(null,inst_37831);
var state_37842__$1 = state_37842;
var statearr_37862_37902 = state_37842__$1;
(statearr_37862_37902[(2)] = inst_37832);

(statearr_37862_37902[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37843 === (10))){
var state_37842__$1 = state_37842;
var statearr_37863_37903 = state_37842__$1;
(statearr_37863_37903[(2)] = pred);

(statearr_37863_37903[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37843 === (8))){
var inst_37837 = (state_37842[(2)]);
var _ = (function (){var statearr_37864 = state_37842;
(statearr_37864[(4)] = cljs.core.rest.call(null,(state_37842[(4)])));

return statearr_37864;
})();
var state_37842__$1 = state_37842;
var statearr_37865_37904 = state_37842__$1;
(statearr_37865_37904[(2)] = inst_37837);

(statearr_37865_37904[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__10903__auto__ = null;
var fluree$db$graphdb$state_machine__10903__auto____0 = (function (){
var statearr_37866 = [null,null,null,null,null,null,null,null];
(statearr_37866[(0)] = fluree$db$graphdb$state_machine__10903__auto__);

(statearr_37866[(1)] = (1));

return statearr_37866;
});
var fluree$db$graphdb$state_machine__10903__auto____1 = (function (state_37842){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_37842);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e37867){var ex__10906__auto__ = e37867;
var statearr_37868_37905 = state_37842;
(statearr_37868_37905[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_37842[(4)]))){
var statearr_37869_37906 = state_37842;
(statearr_37869_37906[(1)] = cljs.core.first.call(null,(state_37842[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37907 = state_37842;
state_37842 = G__37907;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__10903__auto__ = function(state_37842){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__10903__auto____1.call(this,state_37842);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__10903__auto____0;
fluree$db$graphdb$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__10903__auto____1;
return fluree$db$graphdb$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_37870 = f__10977__auto__.call(null);
(statearr_37870[(6)] = c__10976__auto__);

return statearr_37870;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k37909,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__37913 = k37909;
var G__37913__$1 = (((G__37913 instanceof cljs.core.Keyword))?G__37913.fqn:null);
switch (G__37913__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k37909,else__4505__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4525__auto__,p__37914){
var vec__37915 = p__37914;
var k__4526__auto__ = cljs.core.nth.call(null,vec__37915,(0),null);
var v__4527__auto__ = cljs.core.nth.call(null,vec__37915,(1),null);
return f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__);
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4519__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__37908){
var self__ = this;
var G__37908__$1 = this;
return (new cljs.core.RecordIter((0),G__37908__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (20 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (coll__4499__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll.call(null,coll__4499__auto__));
}).call(null,this__4498__auto____$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this37910,other37911){
var self__ = this;
var this37910__$1 = this;
return (((!((other37911 == null)))) && ((((this37910__$1.constructor === other37911.constructor)) && (((cljs.core._EQ_.call(null,this37910__$1.conn,other37911.conn)) && (((cljs.core._EQ_.call(null,this37910__$1.network,other37911.network)) && (((cljs.core._EQ_.call(null,this37910__$1.dbid,other37911.dbid)) && (((cljs.core._EQ_.call(null,this37910__$1.block,other37911.block)) && (((cljs.core._EQ_.call(null,this37910__$1.t,other37911.t)) && (((cljs.core._EQ_.call(null,this37910__$1.tt_id,other37911.tt_id)) && (((cljs.core._EQ_.call(null,this37910__$1.stats,other37911.stats)) && (((cljs.core._EQ_.call(null,this37910__$1.spot,other37911.spot)) && (((cljs.core._EQ_.call(null,this37910__$1.psot,other37911.psot)) && (((cljs.core._EQ_.call(null,this37910__$1.post,other37911.post)) && (((cljs.core._EQ_.call(null,this37910__$1.opst,other37911.opst)) && (((cljs.core._EQ_.call(null,this37910__$1.schema,other37911.schema)) && (((cljs.core._EQ_.call(null,this37910__$1.settings,other37911.settings)) && (((cljs.core._EQ_.call(null,this37910__$1.index_configs,other37911.index_configs)) && (((cljs.core._EQ_.call(null,this37910__$1.schema_cache,other37911.schema_cache)) && (((cljs.core._EQ_.call(null,this37910__$1.novelty,other37911.novelty)) && (((cljs.core._EQ_.call(null,this37910__$1.permissions,other37911.permissions)) && (((cljs.core._EQ_.call(null,this37910__$1.fork,other37911.fork)) && (((cljs.core._EQ_.call(null,this37910__$1.fork_block,other37911.fork_block)) && (((cljs.core._EQ_.call(null,this37910__$1.current_db_fn,other37911.current_db_fn)) && (cljs.core._EQ_.call(null,this37910__$1.__extmap,other37911.__extmap)))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k37909){
var self__ = this;
var this__4509__auto____$1 = this;
var G__37918 = k37909;
var G__37918__$1 = (((G__37918 instanceof cljs.core.Keyword))?G__37918.fqn:null);
switch (G__37918__$1) {
case "conn":
case "network":
case "dbid":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "schema":
case "settings":
case "index-configs":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k37909);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__37908){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__37919 = cljs.core.keyword_identical_QMARK_;
var expr__37920 = k__4511__auto__;
if(cljs.core.truth_(pred__37919.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__37920))){
return (new fluree.db.graphdb.GraphDb(G__37908,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37919.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__37920))){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__37908,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37919.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__37920))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__37908,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37919.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__37920))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__37908,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37919.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__37920))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__37908,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37919.call(null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),expr__37920))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__37908,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37919.call(null,new cljs.core.Keyword(null,"stats","stats",-85643011),expr__37920))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__37908,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37919.call(null,new cljs.core.Keyword(null,"spot","spot",-1706962147),expr__37920))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__37908,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37919.call(null,new cljs.core.Keyword(null,"psot","psot",2111653059),expr__37920))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__37908,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37919.call(null,new cljs.core.Keyword(null,"post","post",269697687),expr__37920))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__37908,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37919.call(null,new cljs.core.Keyword(null,"opst","opst",1213963058),expr__37920))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__37908,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37919.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__37920))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__37908,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37919.call(null,new cljs.core.Keyword(null,"settings","settings",1556144875),expr__37920))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__37908,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37919.call(null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),expr__37920))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__37908,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37919.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__37920))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__37908,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37919.call(null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),expr__37920))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__37908,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37919.call(null,new cljs.core.Keyword(null,"permissions","permissions",67803075),expr__37920))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__37908,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37919.call(null,new cljs.core.Keyword(null,"fork","fork",1062974235),expr__37920))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__37908,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37919.call(null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),expr__37920))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__37908,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37919.call(null,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),expr__37920))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__37908,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4511__auto__,G__37908),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__37908){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__37908,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4508__auto__,(0)),cljs.core._nth.call(null,entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_latest_db.call(null,this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx.call(null,this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_c_prop.call(null,this$__$1,property,collection);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_p_prop.call(null,this$__$1,property,predicate);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.call(null,this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.call(null,this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.call(null,this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_root_db.call(null,this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query.call(null,this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.call(null,this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.call(null,this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.call(null,this$__$1,tag_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.call(null,this$__$1,tag_id,pred);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.call(null,this$__$1,tag_name);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.call(null,this$__$1,tag_name,pred);
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"index-configs","index-configs",-1600476489,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write.call(null,writer__4547__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__37912){
var extmap__4542__auto__ = (function (){var G__37922 = cljs.core.dissoc.call(null,G__37912,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
if(cljs.core.record_QMARK_.call(null,G__37912)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__37922);
} else {
return G__37922;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__37912),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__37912),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__37912),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__37912),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__37912),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__37912),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__37912),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__37912),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__37912),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__37912),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__37912),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__37912),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__37912),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280).cljs$core$IFn$_invoke$arity$1(G__37912),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__37912),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__37912),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__37912),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__37912),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__37912),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__37912),null,cljs.core.not_empty.call(null,extmap__4542__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write.call(null,w,"#FlureeGraphDB ");

return cljs.core._write.call(null,w,cljs.core.pr.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),db__$1.dbid,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.call(null,(function (m,idx){
var ss = clojure.data.avl.sorted_set_by.call(null,cljs.core.get_in.call(null,index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658)], null)));
return cljs.core.assoc.call(null,m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.call(null,index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658).cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake.call(null,fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"conn","conn",278309663)],[(0),dbid,index_config,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.call(null,comparator,first_flake,child_node);
var idx_node = fluree.db.index.__GT_IndexNode.call(null,(0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_spot_novelty], null)),new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_psot_novelty], null)),new cljs.core.Keyword(null,"post","post",269697687),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_post_novelty], null)),new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map.call(null,fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var spot = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"post","post",269697687));
var opst = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"opst","opst",1213963058));
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb.call(null,conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
