// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4913__auto___63170 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null)))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_63221){
var state_val_63222 = (state_63221[(1)]);
if((state_val_63222 === (7))){
var inst_63216 = (state_63221[(2)]);
var _ = (function (){var statearr_63223 = state_63221;
(statearr_63223[(4)] = cljs.core.rest.call(null,(state_63221[(4)])));

return statearr_63223;
})();
var state_63221__$1 = state_63221;
var statearr_63224_63251 = state_63221__$1;
(statearr_63224_63251[(2)] = inst_63216);

(statearr_63224_63251[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63222 === (1))){
var state_63221__$1 = state_63221;
var statearr_63225_63252 = state_63221__$1;
(statearr_63225_63252[(2)] = null);

(statearr_63225_63252[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63222 === (4))){
var inst_63171 = (state_63221[(2)]);
var state_63221__$1 = state_63221;
var statearr_63226_63253 = state_63221__$1;
(statearr_63226_63253[(2)] = inst_63171);

(statearr_63226_63253[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63222 === (13))){
var inst_63212 = (state_63221[(2)]);
var state_63221__$1 = state_63221;
var statearr_63227_63254 = state_63221__$1;
(statearr_63227_63254[(2)] = inst_63212);

(statearr_63227_63254[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63222 === (6))){
var inst_63189 = (state_63221[(7)]);
var inst_63196 = (state_63221[(8)]);
var inst_63195 = cljs.core.seq.call(null,inst_63189);
var inst_63196__$1 = cljs.core.first.call(null,inst_63195);
var inst_63197 = cljs.core.next.call(null,inst_63195);
var inst_63198 = cljs.core.not.call(null,inst_63196__$1);
var state_63221__$1 = (function (){var statearr_63228 = state_63221;
(statearr_63228[(9)] = inst_63197);

(statearr_63228[(8)] = inst_63196__$1);

return statearr_63228;
})();
if(inst_63198){
var statearr_63229_63255 = state_63221__$1;
(statearr_63229_63255[(1)] = (8));

} else {
var statearr_63230_63256 = state_63221__$1;
(statearr_63230_63256[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63222 === (3))){
var inst_63219 = (state_63221[(2)]);
var state_63221__$1 = state_63221;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63221__$1,inst_63219);
} else {
if((state_val_63222 === (12))){
var inst_63197 = (state_63221[(9)]);
var inst_63190 = (state_63221[(10)]);
var inst_63196 = (state_63221[(8)]);
var inst_63209 = cljs.core.conj.call(null,inst_63190,inst_63196);
var inst_63189 = inst_63197;
var inst_63190__$1 = inst_63209;
var state_63221__$1 = (function (){var statearr_63231 = state_63221;
(statearr_63231[(10)] = inst_63190__$1);

(statearr_63231[(7)] = inst_63189);

return statearr_63231;
})();
var statearr_63232_63257 = state_63221__$1;
(statearr_63232_63257[(2)] = null);

(statearr_63232_63257[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63222 === (2))){
var _ = (function (){var statearr_63233 = state_63221;
(statearr_63233[(4)] = cljs.core.cons.call(null,(5),(state_63221[(4)])));

return statearr_63233;
})();
var inst_63184 = args;
var inst_63185 = cljs.core.seq.call(null,inst_63184);
var inst_63186 = cljs.core.first.call(null,inst_63185);
var inst_63187 = cljs.core.next.call(null,inst_63185);
var inst_63188 = cljs.core.PersistentVector.EMPTY;
var inst_63189 = inst_63184;
var inst_63190 = inst_63188;
var state_63221__$1 = (function (){var statearr_63234 = state_63221;
(statearr_63234[(10)] = inst_63190);

(statearr_63234[(11)] = inst_63186);

(statearr_63234[(7)] = inst_63189);

(statearr_63234[(12)] = inst_63187);

return statearr_63234;
})();
var statearr_63235_63258 = state_63221__$1;
(statearr_63235_63258[(2)] = null);

(statearr_63235_63258[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63222 === (11))){
var inst_63196 = (state_63221[(8)]);
var state_63221__$1 = state_63221;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63221__$1,(14),inst_63196);
} else {
if((state_val_63222 === (9))){
var inst_63196 = (state_63221[(8)]);
var inst_63201 = fluree.db.util.async.channel_QMARK_.call(null,inst_63196);
var state_63221__$1 = state_63221;
if(inst_63201){
var statearr_63237_63259 = state_63221__$1;
(statearr_63237_63259[(1)] = (11));

} else {
var statearr_63238_63260 = state_63221__$1;
(statearr_63238_63260[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63222 === (5))){
var _ = (function (){var statearr_63239 = state_63221;
(statearr_63239[(4)] = cljs.core.rest.call(null,(state_63221[(4)])));

return statearr_63239;
})();
var state_63221__$1 = state_63221;
var ex63236 = (state_63221__$1[(2)]);
var statearr_63240_63261 = state_63221__$1;
(statearr_63240_63261[(5)] = ex63236);


if((ex63236 instanceof Error)){
var statearr_63241_63262 = state_63221__$1;
(statearr_63241_63262[(1)] = (4));

(statearr_63241_63262[(5)] = null);

} else {
throw ex63236;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63222 === (14))){
var inst_63197 = (state_63221[(9)]);
var inst_63190 = (state_63221[(10)]);
var inst_63204 = (state_63221[(2)]);
var inst_63205 = fluree.db.util.async.throw_err.call(null,inst_63204);
var inst_63206 = cljs.core.conj.call(null,inst_63190,inst_63205);
var inst_63189 = inst_63197;
var inst_63190__$1 = inst_63206;
var state_63221__$1 = (function (){var statearr_63242 = state_63221;
(statearr_63242[(10)] = inst_63190__$1);

(statearr_63242[(7)] = inst_63189);

return statearr_63242;
})();
var statearr_63243_63263 = state_63221__$1;
(statearr_63243_63263[(2)] = null);

(statearr_63243_63263[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63222 === (10))){
var inst_63214 = (state_63221[(2)]);
var state_63221__$1 = state_63221;
var statearr_63244_63264 = state_63221__$1;
(statearr_63244_63264[(2)] = inst_63214);

(statearr_63244_63264[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63222 === (8))){
var inst_63190 = (state_63221[(10)]);
var state_63221__$1 = state_63221;
var statearr_63245_63265 = state_63221__$1;
(statearr_63245_63265[(2)] = inst_63190);

(statearr_63245_63265[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10903__auto____0 = (function (){
var statearr_63246 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63246[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10903__auto__);

(statearr_63246[(1)] = (1));

return statearr_63246;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10903__auto____1 = (function (state_63221){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_63221);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e63247){var ex__10906__auto__ = e63247;
var statearr_63248_63266 = state_63221;
(statearr_63248_63266[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_63221[(4)]))){
var statearr_63249_63267 = state_63221;
(statearr_63249_63267[(1)] = cljs.core.first.call(null,(state_63221[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63268 = state_63221;
state_63221 = G__63268;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10903__auto__ = function(state_63221){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10903__auto____1.call(this,state_63221);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_63250 = f__10977__auto__.call(null);
(statearr_63250[(6)] = c__10976__auto__);

return statearr_63250;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__63269 = entry;
var res = cljs.core.nth.call(null,vec__63269,(0),null);
var cost = cljs.core.nth.call(null,vec__63269,(1),null);
fluree.db.util.log.debug.call(null,"Smart function stack: ",res);

return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj.call(null,new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(s),entry),new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._.call(null,new cljs.core.Keyword(null,"credits","credits",785860820).cljs$core$IFn$_invoke$arity$1(s),cost),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_.call(null,new cljs.core.Keyword(null,"spent","spent",-62769180).cljs$core$IFn$_invoke$arity$1(s),cost));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.call(null,msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack.call(null,_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_63317){
var state_val_63318 = (state_63317[(1)]);
if((state_val_63318 === (7))){
var state_63317__$1 = state_63317;
var statearr_63319_63348 = state_63317__$1;
(statearr_63319_63348[(2)] = coll);

(statearr_63319_63348[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63318 === (1))){
var state_63317__$1 = state_63317;
var statearr_63320_63349 = state_63317__$1;
(statearr_63320_63349[(2)] = null);

(statearr_63320_63349[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63318 === (4))){
var inst_63272 = (state_63317[(2)]);
var state_63317__$1 = state_63317;
var statearr_63321_63350 = state_63317__$1;
(statearr_63321_63350[(2)] = inst_63272);

(statearr_63321_63350[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63318 === (15))){
var inst_63291 = (state_63317[(7)]);
var inst_63299 = (state_63317[(2)]);
var inst_63300 = fluree.db.dbfunctions.internal.nth.call(null,inst_63291,inst_63299);
var inst_63301 = cljs.core.count.call(null,inst_63291);
var inst_63302 = ((9) + inst_63301);
var inst_63303 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63304 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63305 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63306 = [inst_63291,inst_63299];
var inst_63307 = (new cljs.core.PersistentVector(null,2,(5),inst_63305,inst_63306,null));
var inst_63308 = ["nth",inst_63307,inst_63300];
var inst_63309 = cljs.core.PersistentHashMap.fromArrays(inst_63304,inst_63308);
var inst_63310 = [inst_63309,inst_63302];
var inst_63311 = (new cljs.core.PersistentVector(null,2,(5),inst_63303,inst_63310,null));
var inst_63312 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_63311);
var _ = (function (){var statearr_63322 = state_63317;
(statearr_63322[(4)] = cljs.core.rest.call(null,(state_63317[(4)])));

return statearr_63322;
})();
var state_63317__$1 = (function (){var statearr_63323 = state_63317;
(statearr_63323[(8)] = inst_63312);

return statearr_63323;
})();
var statearr_63324_63351 = state_63317__$1;
(statearr_63324_63351[(2)] = inst_63300);

(statearr_63324_63351[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63318 === (13))){
var state_63317__$1 = state_63317;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63317__$1,(16),key);
} else {
if((state_val_63318 === (6))){
var state_63317__$1 = state_63317;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63317__$1,(9),coll);
} else {
if((state_val_63318 === (3))){
var inst_63315 = (state_63317[(2)]);
var state_63317__$1 = state_63317;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63317__$1,inst_63315);
} else {
if((state_val_63318 === (12))){
var inst_63291 = (state_63317[(2)]);
var inst_63292 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_63317__$1 = (function (){var statearr_63325 = state_63317;
(statearr_63325[(7)] = inst_63291);

return statearr_63325;
})();
if(inst_63292){
var statearr_63326_63352 = state_63317__$1;
(statearr_63326_63352[(1)] = (13));

} else {
var statearr_63327_63353 = state_63317__$1;
(statearr_63327_63353[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63318 === (2))){
var _ = (function (){var statearr_63328 = state_63317;
(statearr_63328[(4)] = cljs.core.cons.call(null,(5),(state_63317[(4)])));

return statearr_63328;
})();
var inst_63278 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_63317__$1 = state_63317;
if(inst_63278){
var statearr_63329_63354 = state_63317__$1;
(statearr_63329_63354[(1)] = (6));

} else {
var statearr_63330_63355 = state_63317__$1;
(statearr_63330_63355[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63318 === (11))){
var inst_63285 = (state_63317[(9)]);
var state_63317__$1 = state_63317;
var statearr_63332_63356 = state_63317__$1;
(statearr_63332_63356[(2)] = inst_63285);

(statearr_63332_63356[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63318 === (9))){
var inst_63281 = (state_63317[(2)]);
var inst_63282 = fluree.db.util.async.throw_err.call(null,inst_63281);
var state_63317__$1 = state_63317;
var statearr_63333_63357 = state_63317__$1;
(statearr_63333_63357[(2)] = inst_63282);

(statearr_63333_63357[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63318 === (5))){
var _ = (function (){var statearr_63334 = state_63317;
(statearr_63334[(4)] = cljs.core.rest.call(null,(state_63317[(4)])));

return statearr_63334;
})();
var state_63317__$1 = state_63317;
var ex63331 = (state_63317__$1[(2)]);
var statearr_63335_63358 = state_63317__$1;
(statearr_63335_63358[(5)] = ex63331);


if((ex63331 instanceof Error)){
var statearr_63336_63359 = state_63317__$1;
(statearr_63336_63359[(1)] = (4));

(statearr_63336_63359[(5)] = null);

} else {
throw ex63331;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63318 === (14))){
var state_63317__$1 = state_63317;
var statearr_63337_63360 = state_63317__$1;
(statearr_63337_63360[(2)] = key);

(statearr_63337_63360[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63318 === (16))){
var inst_63295 = (state_63317[(2)]);
var inst_63296 = fluree.db.util.async.throw_err.call(null,inst_63295);
var state_63317__$1 = state_63317;
var statearr_63338_63361 = state_63317__$1;
(statearr_63338_63361[(2)] = inst_63296);

(statearr_63338_63361[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63318 === (10))){
var inst_63285 = (state_63317[(9)]);
var inst_63288 = cljs.core.vec.call(null,inst_63285);
var state_63317__$1 = state_63317;
var statearr_63339_63362 = state_63317__$1;
(statearr_63339_63362[(2)] = inst_63288);

(statearr_63339_63362[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63318 === (8))){
var inst_63285 = (state_63317[(9)]);
var inst_63285__$1 = (state_63317[(2)]);
var inst_63286 = cljs.core.set_QMARK_.call(null,inst_63285__$1);
var state_63317__$1 = (function (){var statearr_63340 = state_63317;
(statearr_63340[(9)] = inst_63285__$1);

return statearr_63340;
})();
if(inst_63286){
var statearr_63341_63363 = state_63317__$1;
(statearr_63341_63363[(1)] = (10));

} else {
var statearr_63342_63364 = state_63317__$1;
(statearr_63342_63364[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__10903__auto____0 = (function (){
var statearr_63343 = [null,null,null,null,null,null,null,null,null,null];
(statearr_63343[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__10903__auto__);

(statearr_63343[(1)] = (1));

return statearr_63343;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__10903__auto____1 = (function (state_63317){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_63317);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e63344){var ex__10906__auto__ = e63344;
var statearr_63345_63365 = state_63317;
(statearr_63345_63365[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_63317[(4)]))){
var statearr_63346_63366 = state_63317;
(statearr_63346_63366[(1)] = cljs.core.first.call(null,(state_63317[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63367 = state_63317;
state_63317 = G__63367;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__10903__auto__ = function(state_63317){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__10903__auto____1.call(this,state_63317);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_63347 = f__10977__auto__.call(null);
(statearr_63347[(6)] = c__10976__auto__);

return statearr_63347;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_63428){
var state_val_63429 = (state_63428[(1)]);
if((state_val_63429 === (7))){
var state_63428__$1 = state_63428;
var statearr_63430_63464 = state_63428__$1;
(statearr_63430_63464[(2)] = test);

(statearr_63430_63464[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63429 === (20))){
var inst_63402 = (state_63428[(2)]);
var inst_63403 = fluree.db.util.async.throw_err.call(null,inst_63402);
var state_63428__$1 = state_63428;
var statearr_63431_63465 = state_63428__$1;
(statearr_63431_63465[(2)] = inst_63403);

(statearr_63431_63465[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63429 === (1))){
var state_63428__$1 = state_63428;
var statearr_63432_63466 = state_63428__$1;
(statearr_63432_63466[(2)] = null);

(statearr_63432_63466[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63429 === (4))){
var inst_63368 = (state_63428[(2)]);
var state_63428__$1 = state_63428;
var statearr_63433_63467 = state_63428__$1;
(statearr_63433_63467[(2)] = inst_63368);

(statearr_63433_63467[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63429 === (15))){
var inst_63386 = (state_63428[(7)]);
var inst_63394 = (state_63428[(2)]);
var inst_63395 = [inst_63394,f];
var inst_63396 = (new cljs.core.PersistentVector(null,2,(5),inst_63386,inst_63395,null));
var state_63428__$1 = state_63428;
var statearr_63434_63468 = state_63428__$1;
(statearr_63434_63468[(2)] = inst_63396);

(statearr_63434_63468[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63429 === (13))){
var state_63428__$1 = state_63428;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63428__$1,(16),t);
} else {
if((state_val_63429 === (6))){
var state_63428__$1 = state_63428;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63428__$1,(9),test);
} else {
if((state_val_63429 === (17))){
var state_63428__$1 = state_63428;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63428__$1,(20),f);
} else {
if((state_val_63429 === (3))){
var inst_63426 = (state_63428[(2)]);
var state_63428__$1 = state_63428;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63428__$1,inst_63426);
} else {
if((state_val_63429 === (12))){
var inst_63384 = (state_63428[(8)]);
var inst_63410 = (state_63428[(2)]);
var inst_63411 = cljs.core.nth.call(null,inst_63410,(0),null);
var inst_63412 = cljs.core.nth.call(null,inst_63410,(1),null);
var inst_63413 = fluree.db.dbfunctions.internal.if_else.call(null,inst_63384,inst_63411,inst_63412);
var inst_63414 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63415 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63416 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63417 = [inst_63384,inst_63411,inst_63412];
var inst_63418 = (new cljs.core.PersistentVector(null,3,(5),inst_63416,inst_63417,null));
var inst_63419 = ["if-else",inst_63418,inst_63413];
var inst_63420 = cljs.core.PersistentHashMap.fromArrays(inst_63415,inst_63419);
var inst_63421 = [inst_63420,(10)];
var inst_63422 = (new cljs.core.PersistentVector(null,2,(5),inst_63414,inst_63421,null));
var inst_63423 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_63422);
var _ = (function (){var statearr_63435 = state_63428;
(statearr_63435[(4)] = cljs.core.rest.call(null,(state_63428[(4)])));

return statearr_63435;
})();
var state_63428__$1 = (function (){var statearr_63436 = state_63428;
(statearr_63436[(9)] = inst_63423);

return statearr_63436;
})();
var statearr_63437_63469 = state_63428__$1;
(statearr_63437_63469[(2)] = inst_63413);

(statearr_63437_63469[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63429 === (2))){
var _ = (function (){var statearr_63438 = state_63428;
(statearr_63438[(4)] = cljs.core.cons.call(null,(5),(state_63428[(4)])));

return statearr_63438;
})();
var inst_63377 = fluree.db.util.async.channel_QMARK_.call(null,test);
var state_63428__$1 = state_63428;
if(inst_63377){
var statearr_63439_63470 = state_63428__$1;
(statearr_63439_63470[(1)] = (6));

} else {
var statearr_63440_63471 = state_63428__$1;
(statearr_63440_63471[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63429 === (19))){
var inst_63398 = (state_63428[(10)]);
var inst_63406 = (state_63428[(2)]);
var inst_63407 = [f,inst_63406];
var inst_63408 = (new cljs.core.PersistentVector(null,2,(5),inst_63398,inst_63407,null));
var state_63428__$1 = state_63428;
var statearr_63441_63472 = state_63428__$1;
(statearr_63441_63472[(2)] = inst_63408);

(statearr_63441_63472[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63429 === (11))){
var inst_63398 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63399 = fluree.db.util.async.channel_QMARK_.call(null,f);
var state_63428__$1 = (function (){var statearr_63443 = state_63428;
(statearr_63443[(10)] = inst_63398);

return statearr_63443;
})();
if(inst_63399){
var statearr_63444_63473 = state_63428__$1;
(statearr_63444_63473[(1)] = (17));

} else {
var statearr_63445_63474 = state_63428__$1;
(statearr_63445_63474[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63429 === (9))){
var inst_63380 = (state_63428[(2)]);
var inst_63381 = fluree.db.util.async.throw_err.call(null,inst_63380);
var state_63428__$1 = state_63428;
var statearr_63446_63475 = state_63428__$1;
(statearr_63446_63475[(2)] = inst_63381);

(statearr_63446_63475[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63429 === (5))){
var _ = (function (){var statearr_63447 = state_63428;
(statearr_63447[(4)] = cljs.core.rest.call(null,(state_63428[(4)])));

return statearr_63447;
})();
var state_63428__$1 = state_63428;
var ex63442 = (state_63428__$1[(2)]);
var statearr_63448_63476 = state_63428__$1;
(statearr_63448_63476[(5)] = ex63442);


if((ex63442 instanceof Error)){
var statearr_63449_63477 = state_63428__$1;
(statearr_63449_63477[(1)] = (4));

(statearr_63449_63477[(5)] = null);

} else {
throw ex63442;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63429 === (14))){
var state_63428__$1 = state_63428;
var statearr_63450_63478 = state_63428__$1;
(statearr_63450_63478[(2)] = t);

(statearr_63450_63478[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63429 === (16))){
var inst_63390 = (state_63428[(2)]);
var inst_63391 = fluree.db.util.async.throw_err.call(null,inst_63390);
var state_63428__$1 = state_63428;
var statearr_63451_63479 = state_63428__$1;
(statearr_63451_63479[(2)] = inst_63391);

(statearr_63451_63479[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63429 === (10))){
var inst_63386 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63387 = fluree.db.util.async.channel_QMARK_.call(null,t);
var state_63428__$1 = (function (){var statearr_63452 = state_63428;
(statearr_63452[(7)] = inst_63386);

return statearr_63452;
})();
if(inst_63387){
var statearr_63453_63480 = state_63428__$1;
(statearr_63453_63480[(1)] = (13));

} else {
var statearr_63454_63481 = state_63428__$1;
(statearr_63454_63481[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63429 === (18))){
var state_63428__$1 = state_63428;
var statearr_63455_63482 = state_63428__$1;
(statearr_63455_63482[(2)] = f);

(statearr_63455_63482[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63429 === (8))){
var inst_63384 = (state_63428[(8)]);
var inst_63384__$1 = (state_63428[(2)]);
var state_63428__$1 = (function (){var statearr_63456 = state_63428;
(statearr_63456[(8)] = inst_63384__$1);

return statearr_63456;
})();
if(cljs.core.truth_(inst_63384__$1)){
var statearr_63457_63483 = state_63428__$1;
(statearr_63457_63483[(1)] = (10));

} else {
var statearr_63458_63484 = state_63428__$1;
(statearr_63458_63484[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__10903__auto____0 = (function (){
var statearr_63459 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_63459[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__10903__auto__);

(statearr_63459[(1)] = (1));

return statearr_63459;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__10903__auto____1 = (function (state_63428){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_63428);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e63460){var ex__10906__auto__ = e63460;
var statearr_63461_63485 = state_63428;
(statearr_63461_63485[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_63428[(4)]))){
var statearr_63462_63486 = state_63428;
(statearr_63462_63486[(1)] = cljs.core.first.call(null,(state_63428[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63487 = state_63428;
state_63428 = G__63487;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__10903__auto__ = function(state_63428){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__10903__auto____1.call(this,state_63428);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_63463 = f__10977__auto__.call(null);
(statearr_63463[(6)] = c__10976__auto__);

return statearr_63463;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_63517){
var state_val_63518 = (state_63517[(1)]);
if((state_val_63518 === (7))){
var state_63517__$1 = state_63517;
var statearr_63519_63538 = state_63517__$1;
(statearr_63519_63538[(2)] = arg);

(statearr_63519_63538[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63518 === (1))){
var state_63517__$1 = state_63517;
var statearr_63520_63539 = state_63517__$1;
(statearr_63520_63539[(2)] = null);

(statearr_63520_63539[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63518 === (4))){
var inst_63488 = (state_63517[(2)]);
var state_63517__$1 = state_63517;
var statearr_63521_63540 = state_63517__$1;
(statearr_63521_63540[(2)] = inst_63488);

(statearr_63521_63540[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63518 === (6))){
var state_63517__$1 = state_63517;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63517__$1,(9),arg);
} else {
if((state_val_63518 === (3))){
var inst_63515 = (state_63517[(2)]);
var state_63517__$1 = state_63517;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63517__$1,inst_63515);
} else {
if((state_val_63518 === (2))){
var _ = (function (){var statearr_63523 = state_63517;
(statearr_63523[(4)] = cljs.core.cons.call(null,(5),(state_63517[(4)])));

return statearr_63523;
})();
var inst_63494 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_63517__$1 = state_63517;
if(inst_63494){
var statearr_63524_63541 = state_63517__$1;
(statearr_63524_63541[(1)] = (6));

} else {
var statearr_63525_63542 = state_63517__$1;
(statearr_63525_63542[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63518 === (9))){
var inst_63497 = (state_63517[(2)]);
var inst_63498 = fluree.db.util.async.throw_err.call(null,inst_63497);
var state_63517__$1 = state_63517;
var statearr_63526_63543 = state_63517__$1;
(statearr_63526_63543[(2)] = inst_63498);

(statearr_63526_63543[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63518 === (5))){
var _ = (function (){var statearr_63527 = state_63517;
(statearr_63527[(4)] = cljs.core.rest.call(null,(state_63517[(4)])));

return statearr_63527;
})();
var state_63517__$1 = state_63517;
var ex63522 = (state_63517__$1[(2)]);
var statearr_63528_63544 = state_63517__$1;
(statearr_63528_63544[(5)] = ex63522);


if((ex63522 instanceof Error)){
var statearr_63529_63545 = state_63517__$1;
(statearr_63529_63545[(1)] = (4));

(statearr_63529_63545[(5)] = null);

} else {
throw ex63522;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63518 === (8))){
var inst_63501 = (state_63517[(2)]);
var inst_63502 = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,inst_63501);
var inst_63503 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63504 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63505 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63506 = [inst_63501];
var inst_63507 = (new cljs.core.PersistentVector(null,1,(5),inst_63505,inst_63506,null));
var inst_63508 = ["nil?",inst_63507,inst_63502];
var inst_63509 = cljs.core.PersistentHashMap.fromArrays(inst_63504,inst_63508);
var inst_63510 = [inst_63509,(10)];
var inst_63511 = (new cljs.core.PersistentVector(null,2,(5),inst_63503,inst_63510,null));
var inst_63512 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_63511);
var _ = (function (){var statearr_63530 = state_63517;
(statearr_63530[(4)] = cljs.core.rest.call(null,(state_63517[(4)])));

return statearr_63530;
})();
var state_63517__$1 = (function (){var statearr_63531 = state_63517;
(statearr_63531[(7)] = inst_63512);

return statearr_63531;
})();
var statearr_63532_63546 = state_63517__$1;
(statearr_63532_63546[(2)] = inst_63502);

(statearr_63532_63546[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10903__auto____0 = (function (){
var statearr_63533 = [null,null,null,null,null,null,null,null];
(statearr_63533[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10903__auto__);

(statearr_63533[(1)] = (1));

return statearr_63533;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10903__auto____1 = (function (state_63517){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_63517);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e63534){var ex__10906__auto__ = e63534;
var statearr_63535_63547 = state_63517;
(statearr_63535_63547[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_63517[(4)]))){
var statearr_63536_63548 = state_63517;
(statearr_63536_63548[(1)] = cljs.core.first.call(null,(state_63517[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63549 = state_63517;
state_63517 = G__63549;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10903__auto__ = function(state_63517){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10903__auto____1.call(this,state_63517);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_63537 = f__10977__auto__.call(null);
(statearr_63537[(6)] = c__10976__auto__);

return statearr_63537;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_63579){
var state_val_63580 = (state_63579[(1)]);
if((state_val_63580 === (7))){
var state_63579__$1 = state_63579;
var statearr_63581_63600 = state_63579__$1;
(statearr_63581_63600[(2)] = arg);

(statearr_63581_63600[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63580 === (1))){
var state_63579__$1 = state_63579;
var statearr_63582_63601 = state_63579__$1;
(statearr_63582_63601[(2)] = null);

(statearr_63582_63601[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63580 === (4))){
var inst_63550 = (state_63579[(2)]);
var state_63579__$1 = state_63579;
var statearr_63583_63602 = state_63579__$1;
(statearr_63583_63602[(2)] = inst_63550);

(statearr_63583_63602[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63580 === (6))){
var state_63579__$1 = state_63579;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63579__$1,(9),arg);
} else {
if((state_val_63580 === (3))){
var inst_63577 = (state_63579[(2)]);
var state_63579__$1 = state_63579;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63579__$1,inst_63577);
} else {
if((state_val_63580 === (2))){
var _ = (function (){var statearr_63585 = state_63579;
(statearr_63585[(4)] = cljs.core.cons.call(null,(5),(state_63579[(4)])));

return statearr_63585;
})();
var inst_63556 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_63579__$1 = state_63579;
if(inst_63556){
var statearr_63586_63603 = state_63579__$1;
(statearr_63586_63603[(1)] = (6));

} else {
var statearr_63587_63604 = state_63579__$1;
(statearr_63587_63604[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63580 === (9))){
var inst_63559 = (state_63579[(2)]);
var inst_63560 = fluree.db.util.async.throw_err.call(null,inst_63559);
var state_63579__$1 = state_63579;
var statearr_63588_63605 = state_63579__$1;
(statearr_63588_63605[(2)] = inst_63560);

(statearr_63588_63605[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63580 === (5))){
var _ = (function (){var statearr_63589 = state_63579;
(statearr_63589[(4)] = cljs.core.rest.call(null,(state_63579[(4)])));

return statearr_63589;
})();
var state_63579__$1 = state_63579;
var ex63584 = (state_63579__$1[(2)]);
var statearr_63590_63606 = state_63579__$1;
(statearr_63590_63606[(5)] = ex63584);


if((ex63584 instanceof Error)){
var statearr_63591_63607 = state_63579__$1;
(statearr_63591_63607[(1)] = (4));

(statearr_63591_63607[(5)] = null);

} else {
throw ex63584;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63580 === (8))){
var inst_63563 = (state_63579[(2)]);
var inst_63564 = fluree.db.dbfunctions.internal.not.call(null,inst_63563);
var inst_63565 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63566 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63567 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63568 = [inst_63563];
var inst_63569 = (new cljs.core.PersistentVector(null,1,(5),inst_63567,inst_63568,null));
var inst_63570 = ["not?",inst_63569,inst_63564];
var inst_63571 = cljs.core.PersistentHashMap.fromArrays(inst_63566,inst_63570);
var inst_63572 = [inst_63571,(10)];
var inst_63573 = (new cljs.core.PersistentVector(null,2,(5),inst_63565,inst_63572,null));
var inst_63574 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_63573);
var _ = (function (){var statearr_63592 = state_63579;
(statearr_63592[(4)] = cljs.core.rest.call(null,(state_63579[(4)])));

return statearr_63592;
})();
var state_63579__$1 = (function (){var statearr_63593 = state_63579;
(statearr_63593[(7)] = inst_63574);

return statearr_63593;
})();
var statearr_63594_63608 = state_63579__$1;
(statearr_63594_63608[(2)] = inst_63564);

(statearr_63594_63608[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__10903__auto____0 = (function (){
var statearr_63595 = [null,null,null,null,null,null,null,null];
(statearr_63595[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__10903__auto__);

(statearr_63595[(1)] = (1));

return statearr_63595;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__10903__auto____1 = (function (state_63579){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_63579);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e63596){var ex__10906__auto__ = e63596;
var statearr_63597_63609 = state_63579;
(statearr_63597_63609[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_63579[(4)]))){
var statearr_63598_63610 = state_63579;
(statearr_63598_63610[(1)] = cljs.core.first.call(null,(state_63579[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63611 = state_63579;
state_63579 = G__63611;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__10903__auto__ = function(state_63579){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__10903__auto____1.call(this,state_63579);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_63599 = f__10977__auto__.call(null);
(statearr_63599[(6)] = c__10976__auto__);

return statearr_63599;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_63641){
var state_val_63642 = (state_63641[(1)]);
if((state_val_63642 === (7))){
var state_63641__$1 = state_63641;
var statearr_63643_63662 = state_63641__$1;
(statearr_63643_63662[(2)] = arg);

(statearr_63643_63662[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63642 === (1))){
var state_63641__$1 = state_63641;
var statearr_63644_63663 = state_63641__$1;
(statearr_63644_63663[(2)] = null);

(statearr_63644_63663[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63642 === (4))){
var inst_63612 = (state_63641[(2)]);
var state_63641__$1 = state_63641;
var statearr_63645_63664 = state_63641__$1;
(statearr_63645_63664[(2)] = inst_63612);

(statearr_63645_63664[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63642 === (6))){
var state_63641__$1 = state_63641;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63641__$1,(9),arg);
} else {
if((state_val_63642 === (3))){
var inst_63639 = (state_63641[(2)]);
var state_63641__$1 = state_63641;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63641__$1,inst_63639);
} else {
if((state_val_63642 === (2))){
var _ = (function (){var statearr_63647 = state_63641;
(statearr_63647[(4)] = cljs.core.cons.call(null,(5),(state_63641[(4)])));

return statearr_63647;
})();
var inst_63618 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_63641__$1 = state_63641;
if(inst_63618){
var statearr_63648_63665 = state_63641__$1;
(statearr_63648_63665[(1)] = (6));

} else {
var statearr_63649_63666 = state_63641__$1;
(statearr_63649_63666[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63642 === (9))){
var inst_63621 = (state_63641[(2)]);
var inst_63622 = fluree.db.util.async.throw_err.call(null,inst_63621);
var state_63641__$1 = state_63641;
var statearr_63650_63667 = state_63641__$1;
(statearr_63650_63667[(2)] = inst_63622);

(statearr_63650_63667[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63642 === (5))){
var _ = (function (){var statearr_63651 = state_63641;
(statearr_63651[(4)] = cljs.core.rest.call(null,(state_63641[(4)])));

return statearr_63651;
})();
var state_63641__$1 = state_63641;
var ex63646 = (state_63641__$1[(2)]);
var statearr_63652_63668 = state_63641__$1;
(statearr_63652_63668[(5)] = ex63646);


if((ex63646 instanceof Error)){
var statearr_63653_63669 = state_63641__$1;
(statearr_63653_63669[(1)] = (4));

(statearr_63653_63669[(5)] = null);

} else {
throw ex63646;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63642 === (8))){
var inst_63625 = (state_63641[(2)]);
var inst_63626 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_63625);
var inst_63627 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63628 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63629 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63630 = [inst_63625];
var inst_63631 = (new cljs.core.PersistentVector(null,1,(5),inst_63629,inst_63630,null));
var inst_63632 = ["empty?",inst_63631,inst_63626];
var inst_63633 = cljs.core.PersistentHashMap.fromArrays(inst_63628,inst_63632);
var inst_63634 = [inst_63633,(10)];
var inst_63635 = (new cljs.core.PersistentVector(null,2,(5),inst_63627,inst_63634,null));
var inst_63636 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_63635);
var _ = (function (){var statearr_63654 = state_63641;
(statearr_63654[(4)] = cljs.core.rest.call(null,(state_63641[(4)])));

return statearr_63654;
})();
var state_63641__$1 = (function (){var statearr_63655 = state_63641;
(statearr_63655[(7)] = inst_63636);

return statearr_63655;
})();
var statearr_63656_63670 = state_63641__$1;
(statearr_63656_63670[(2)] = inst_63626);

(statearr_63656_63670[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10903__auto____0 = (function (){
var statearr_63657 = [null,null,null,null,null,null,null,null];
(statearr_63657[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10903__auto__);

(statearr_63657[(1)] = (1));

return statearr_63657;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10903__auto____1 = (function (state_63641){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_63641);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e63658){var ex__10906__auto__ = e63658;
var statearr_63659_63671 = state_63641;
(statearr_63659_63671[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_63641[(4)]))){
var statearr_63660_63672 = state_63641;
(statearr_63660_63672[(1)] = cljs.core.first.call(null,(state_63641[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63673 = state_63641;
state_63641 = G__63673;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10903__auto__ = function(state_63641){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10903__auto____1.call(this,state_63641);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_63661 = f__10977__auto__.call(null);
(statearr_63661[(6)] = c__10976__auto__);

return statearr_63661;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4870__auto__ = [];
var len__4864__auto___63718 = arguments.length;
var i__4865__auto___63719 = (0);
while(true){
if((i__4865__auto___63719 < len__4864__auto___63718)){
args__4870__auto__.push((arguments[i__4865__auto___63719]));

var G__63720 = (i__4865__auto___63719 + (1));
i__4865__auto___63719 = G__63720;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_63701){
var state_val_63702 = (state_63701[(1)]);
if((state_val_63702 === (1))){
var state_63701__$1 = state_63701;
var statearr_63703_63721 = state_63701__$1;
(statearr_63703_63721[(2)] = null);

(statearr_63703_63721[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63702 === (2))){
var _ = (function (){var statearr_63704 = state_63701;
(statearr_63704[(4)] = cljs.core.cons.call(null,(5),(state_63701[(4)])));

return statearr_63704;
})();
var inst_63682 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_63701__$1 = state_63701;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63701__$1,(6),inst_63682);
} else {
if((state_val_63702 === (3))){
var inst_63699 = (state_63701[(2)]);
var state_63701__$1 = state_63701;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63701__$1,inst_63699);
} else {
if((state_val_63702 === (4))){
var inst_63676 = (state_63701[(2)]);
var state_63701__$1 = state_63701;
var statearr_63706_63722 = state_63701__$1;
(statearr_63706_63722[(2)] = inst_63676);

(statearr_63706_63722[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63702 === (5))){
var _ = (function (){var statearr_63707 = state_63701;
(statearr_63707[(4)] = cljs.core.rest.call(null,(state_63701[(4)])));

return statearr_63707;
})();
var state_63701__$1 = state_63701;
var ex63705 = (state_63701__$1[(2)]);
var statearr_63708_63723 = state_63701__$1;
(statearr_63708_63723[(5)] = ex63705);


if((ex63705 instanceof Error)){
var statearr_63709_63724 = state_63701__$1;
(statearr_63709_63724[(1)] = (4));

(statearr_63709_63724[(5)] = null);

} else {
throw ex63705;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63702 === (6))){
var inst_63684 = (state_63701[(2)]);
var inst_63685 = fluree.db.util.async.throw_err.call(null,inst_63684);
var inst_63686 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.str,inst_63685);
var inst_63687 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63688 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63689 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63690 = [inst_63685];
var inst_63691 = (new cljs.core.PersistentVector(null,1,(5),inst_63689,inst_63690,null));
var inst_63692 = ["str",inst_63691,inst_63686];
var inst_63693 = cljs.core.PersistentHashMap.fromArrays(inst_63688,inst_63692);
var inst_63694 = [inst_63693,(10)];
var inst_63695 = (new cljs.core.PersistentVector(null,2,(5),inst_63687,inst_63694,null));
var inst_63696 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_63695);
var _ = (function (){var statearr_63710 = state_63701;
(statearr_63710[(4)] = cljs.core.rest.call(null,(state_63701[(4)])));

return statearr_63710;
})();
var state_63701__$1 = (function (){var statearr_63711 = state_63701;
(statearr_63711[(7)] = inst_63696);

return statearr_63711;
})();
var statearr_63712_63725 = state_63701__$1;
(statearr_63712_63725[(2)] = inst_63686);

(statearr_63712_63725[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10903__auto____0 = (function (){
var statearr_63713 = [null,null,null,null,null,null,null,null];
(statearr_63713[(0)] = fluree$db$dbfunctions$fns$state_machine__10903__auto__);

(statearr_63713[(1)] = (1));

return statearr_63713;
});
var fluree$db$dbfunctions$fns$state_machine__10903__auto____1 = (function (state_63701){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_63701);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e63714){var ex__10906__auto__ = e63714;
var statearr_63715_63726 = state_63701;
(statearr_63715_63726[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_63701[(4)]))){
var statearr_63716_63727 = state_63701;
(statearr_63716_63727[(1)] = cljs.core.first.call(null,(state_63701[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63728 = state_63701;
state_63701 = G__63728;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10903__auto__ = function(state_63701){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____1.call(this,state_63701);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_63717 = f__10977__auto__.call(null);
(statearr_63717[(6)] = c__10976__auto__);

return statearr_63717;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq63674){
var G__63675 = cljs.core.first.call(null,seq63674);
var seq63674__$1 = cljs.core.next.call(null,seq63674);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__63675,seq63674__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_63754){
var state_val_63755 = (state_63754[(1)]);
if((state_val_63755 === (1))){
var state_63754__$1 = state_63754;
var statearr_63756_63771 = state_63754__$1;
(statearr_63756_63771[(2)] = null);

(statearr_63756_63771[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63755 === (2))){
var _ = (function (){var statearr_63757 = state_63754;
(statearr_63757[(4)] = cljs.core.cons.call(null,(5),(state_63754[(4)])));

return statearr_63757;
})();
var inst_63735 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_63754__$1 = state_63754;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63754__$1,(6),inst_63735);
} else {
if((state_val_63755 === (3))){
var inst_63752 = (state_63754[(2)]);
var state_63754__$1 = state_63754;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63754__$1,inst_63752);
} else {
if((state_val_63755 === (4))){
var inst_63729 = (state_63754[(2)]);
var state_63754__$1 = state_63754;
var statearr_63759_63772 = state_63754__$1;
(statearr_63759_63772[(2)] = inst_63729);

(statearr_63759_63772[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63755 === (5))){
var _ = (function (){var statearr_63760 = state_63754;
(statearr_63760[(4)] = cljs.core.rest.call(null,(state_63754[(4)])));

return statearr_63760;
})();
var state_63754__$1 = state_63754;
var ex63758 = (state_63754__$1[(2)]);
var statearr_63761_63773 = state_63754__$1;
(statearr_63761_63773[(5)] = ex63758);


if((ex63758 instanceof Error)){
var statearr_63762_63774 = state_63754__$1;
(statearr_63762_63774[(1)] = (4));

(statearr_63762_63774[(5)] = null);

} else {
throw ex63758;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63755 === (6))){
var inst_63737 = (state_63754[(2)]);
var inst_63738 = fluree.db.util.async.throw_err.call(null,inst_63737);
var inst_63739 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.subs,inst_63738);
var inst_63740 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63741 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63742 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63743 = [inst_63738];
var inst_63744 = (new cljs.core.PersistentVector(null,1,(5),inst_63742,inst_63743,null));
var inst_63745 = ["subs",inst_63744,inst_63739];
var inst_63746 = cljs.core.PersistentHashMap.fromArrays(inst_63741,inst_63745);
var inst_63747 = [inst_63746,(30)];
var inst_63748 = (new cljs.core.PersistentVector(null,2,(5),inst_63740,inst_63747,null));
var inst_63749 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_63748);
var _ = (function (){var statearr_63763 = state_63754;
(statearr_63763[(4)] = cljs.core.rest.call(null,(state_63754[(4)])));

return statearr_63763;
})();
var state_63754__$1 = (function (){var statearr_63764 = state_63754;
(statearr_63764[(7)] = inst_63749);

return statearr_63764;
})();
var statearr_63765_63775 = state_63754__$1;
(statearr_63765_63775[(2)] = inst_63739);

(statearr_63765_63775[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__10903__auto____0 = (function (){
var statearr_63766 = [null,null,null,null,null,null,null,null];
(statearr_63766[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__10903__auto__);

(statearr_63766[(1)] = (1));

return statearr_63766;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__10903__auto____1 = (function (state_63754){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_63754);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e63767){var ex__10906__auto__ = e63767;
var statearr_63768_63776 = state_63754;
(statearr_63768_63776[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_63754[(4)]))){
var statearr_63769_63777 = state_63754;
(statearr_63769_63777[(1)] = cljs.core.first.call(null,(state_63754[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63778 = state_63754;
state_63754 = G__63778;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__10903__auto__ = function(state_63754){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__10903__auto____1.call(this,state_63754);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_63770 = f__10977__auto__.call(null);
(statearr_63770[(6)] = c__10976__auto__);

return statearr_63770;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_63808){
var state_val_63809 = (state_63808[(1)]);
if((state_val_63809 === (7))){
var state_63808__$1 = state_63808;
var statearr_63810_63829 = state_63808__$1;
(statearr_63810_63829[(2)] = str);

(statearr_63810_63829[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63809 === (1))){
var state_63808__$1 = state_63808;
var statearr_63811_63830 = state_63808__$1;
(statearr_63811_63830[(2)] = null);

(statearr_63811_63830[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63809 === (4))){
var inst_63779 = (state_63808[(2)]);
var state_63808__$1 = state_63808;
var statearr_63812_63831 = state_63808__$1;
(statearr_63812_63831[(2)] = inst_63779);

(statearr_63812_63831[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63809 === (6))){
var state_63808__$1 = state_63808;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63808__$1,(9),str);
} else {
if((state_val_63809 === (3))){
var inst_63806 = (state_63808[(2)]);
var state_63808__$1 = state_63808;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63808__$1,inst_63806);
} else {
if((state_val_63809 === (2))){
var _ = (function (){var statearr_63814 = state_63808;
(statearr_63814[(4)] = cljs.core.cons.call(null,(5),(state_63808[(4)])));

return statearr_63814;
})();
var inst_63785 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_63808__$1 = state_63808;
if(inst_63785){
var statearr_63815_63832 = state_63808__$1;
(statearr_63815_63832[(1)] = (6));

} else {
var statearr_63816_63833 = state_63808__$1;
(statearr_63816_63833[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63809 === (9))){
var inst_63788 = (state_63808[(2)]);
var inst_63789 = fluree.db.util.async.throw_err.call(null,inst_63788);
var state_63808__$1 = state_63808;
var statearr_63817_63834 = state_63808__$1;
(statearr_63817_63834[(2)] = inst_63789);

(statearr_63817_63834[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63809 === (5))){
var _ = (function (){var statearr_63818 = state_63808;
(statearr_63818[(4)] = cljs.core.rest.call(null,(state_63808[(4)])));

return statearr_63818;
})();
var state_63808__$1 = state_63808;
var ex63813 = (state_63808__$1[(2)]);
var statearr_63819_63835 = state_63808__$1;
(statearr_63819_63835[(5)] = ex63813);


if((ex63813 instanceof Error)){
var statearr_63820_63836 = state_63808__$1;
(statearr_63820_63836[(1)] = (4));

(statearr_63820_63836[(5)] = null);

} else {
throw ex63813;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63809 === (8))){
var inst_63792 = (state_63808[(2)]);
var inst_63793 = fluree.db.dbfunctions.internal.lower_case.call(null,inst_63792);
var inst_63794 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63795 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63796 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63797 = [inst_63792];
var inst_63798 = (new cljs.core.PersistentVector(null,1,(5),inst_63796,inst_63797,null));
var inst_63799 = ["lower-case",inst_63798,inst_63793];
var inst_63800 = cljs.core.PersistentHashMap.fromArrays(inst_63795,inst_63799);
var inst_63801 = [inst_63800,(10)];
var inst_63802 = (new cljs.core.PersistentVector(null,2,(5),inst_63794,inst_63801,null));
var inst_63803 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_63802);
var _ = (function (){var statearr_63821 = state_63808;
(statearr_63821[(4)] = cljs.core.rest.call(null,(state_63808[(4)])));

return statearr_63821;
})();
var state_63808__$1 = (function (){var statearr_63822 = state_63808;
(statearr_63822[(7)] = inst_63803);

return statearr_63822;
})();
var statearr_63823_63837 = state_63808__$1;
(statearr_63823_63837[(2)] = inst_63793);

(statearr_63823_63837[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__10903__auto____0 = (function (){
var statearr_63824 = [null,null,null,null,null,null,null,null];
(statearr_63824[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__10903__auto__);

(statearr_63824[(1)] = (1));

return statearr_63824;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__10903__auto____1 = (function (state_63808){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_63808);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e63825){var ex__10906__auto__ = e63825;
var statearr_63826_63838 = state_63808;
(statearr_63826_63838[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_63808[(4)]))){
var statearr_63827_63839 = state_63808;
(statearr_63827_63839[(1)] = cljs.core.first.call(null,(state_63808[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63840 = state_63808;
state_63808 = G__63840;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__10903__auto__ = function(state_63808){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__10903__auto____1.call(this,state_63808);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_63828 = f__10977__auto__.call(null);
(statearr_63828[(6)] = c__10976__auto__);

return statearr_63828;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_63870){
var state_val_63871 = (state_63870[(1)]);
if((state_val_63871 === (7))){
var state_63870__$1 = state_63870;
var statearr_63872_63891 = state_63870__$1;
(statearr_63872_63891[(2)] = str);

(statearr_63872_63891[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (1))){
var state_63870__$1 = state_63870;
var statearr_63873_63892 = state_63870__$1;
(statearr_63873_63892[(2)] = null);

(statearr_63873_63892[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (4))){
var inst_63841 = (state_63870[(2)]);
var state_63870__$1 = state_63870;
var statearr_63874_63893 = state_63870__$1;
(statearr_63874_63893[(2)] = inst_63841);

(statearr_63874_63893[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (6))){
var state_63870__$1 = state_63870;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63870__$1,(9),str);
} else {
if((state_val_63871 === (3))){
var inst_63868 = (state_63870[(2)]);
var state_63870__$1 = state_63870;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63870__$1,inst_63868);
} else {
if((state_val_63871 === (2))){
var _ = (function (){var statearr_63876 = state_63870;
(statearr_63876[(4)] = cljs.core.cons.call(null,(5),(state_63870[(4)])));

return statearr_63876;
})();
var inst_63847 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_63870__$1 = state_63870;
if(inst_63847){
var statearr_63877_63894 = state_63870__$1;
(statearr_63877_63894[(1)] = (6));

} else {
var statearr_63878_63895 = state_63870__$1;
(statearr_63878_63895[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (9))){
var inst_63850 = (state_63870[(2)]);
var inst_63851 = fluree.db.util.async.throw_err.call(null,inst_63850);
var state_63870__$1 = state_63870;
var statearr_63879_63896 = state_63870__$1;
(statearr_63879_63896[(2)] = inst_63851);

(statearr_63879_63896[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (5))){
var _ = (function (){var statearr_63880 = state_63870;
(statearr_63880[(4)] = cljs.core.rest.call(null,(state_63870[(4)])));

return statearr_63880;
})();
var state_63870__$1 = state_63870;
var ex63875 = (state_63870__$1[(2)]);
var statearr_63881_63897 = state_63870__$1;
(statearr_63881_63897[(5)] = ex63875);


if((ex63875 instanceof Error)){
var statearr_63882_63898 = state_63870__$1;
(statearr_63882_63898[(1)] = (4));

(statearr_63882_63898[(5)] = null);

} else {
throw ex63875;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63871 === (8))){
var inst_63854 = (state_63870[(2)]);
var inst_63855 = fluree.db.dbfunctions.internal.upper_case.call(null,inst_63854);
var inst_63856 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63857 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63858 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63859 = [inst_63854];
var inst_63860 = (new cljs.core.PersistentVector(null,1,(5),inst_63858,inst_63859,null));
var inst_63861 = ["upper-case",inst_63860,inst_63855];
var inst_63862 = cljs.core.PersistentHashMap.fromArrays(inst_63857,inst_63861);
var inst_63863 = [inst_63862,(10)];
var inst_63864 = (new cljs.core.PersistentVector(null,2,(5),inst_63856,inst_63863,null));
var inst_63865 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_63864);
var _ = (function (){var statearr_63883 = state_63870;
(statearr_63883[(4)] = cljs.core.rest.call(null,(state_63870[(4)])));

return statearr_63883;
})();
var state_63870__$1 = (function (){var statearr_63884 = state_63870;
(statearr_63884[(7)] = inst_63865);

return statearr_63884;
})();
var statearr_63885_63899 = state_63870__$1;
(statearr_63885_63899[(2)] = inst_63855);

(statearr_63885_63899[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__10903__auto____0 = (function (){
var statearr_63886 = [null,null,null,null,null,null,null,null];
(statearr_63886[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__10903__auto__);

(statearr_63886[(1)] = (1));

return statearr_63886;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__10903__auto____1 = (function (state_63870){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_63870);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e63887){var ex__10906__auto__ = e63887;
var statearr_63888_63900 = state_63870;
(statearr_63888_63900[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_63870[(4)]))){
var statearr_63889_63901 = state_63870;
(statearr_63889_63901[(1)] = cljs.core.first.call(null,(state_63870[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63902 = state_63870;
state_63870 = G__63902;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__10903__auto__ = function(state_63870){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__10903__auto____1.call(this,state_63870);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_63890 = f__10977__auto__.call(null);
(statearr_63890[(6)] = c__10976__auto__);

return statearr_63890;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4251__auto__)){
return (!(typeof cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__4251__auto__;
}
})())){
var res = cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__63904 = arguments.length;
switch (G__63904) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_63932){
var state_val_63933 = (state_63932[(1)]);
if((state_val_63933 === (1))){
var state_63932__$1 = state_63932;
var statearr_63934_63950 = state_63932__$1;
(statearr_63934_63950[(2)] = null);

(statearr_63934_63950[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63933 === (2))){
var _ = (function (){var statearr_63935 = state_63932;
(statearr_63935[(4)] = cljs.core.cons.call(null,(5),(state_63932[(4)])));

return statearr_63935;
})();
var inst_63914 = fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,additional_select);
var state_63932__$1 = state_63932;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63932__$1,(6),inst_63914);
} else {
if((state_val_63933 === (3))){
var inst_63930 = (state_63932[(2)]);
var state_63932__$1 = state_63932;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63932__$1,inst_63930);
} else {
if((state_val_63933 === (4))){
var inst_63905 = (state_63932[(2)]);
var state_63932__$1 = state_63932;
var statearr_63937_63951 = state_63932__$1;
(statearr_63937_63951[(2)] = inst_63905);

(statearr_63937_63951[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63933 === (5))){
var _ = (function (){var statearr_63938 = state_63932;
(statearr_63938[(4)] = cljs.core.rest.call(null,(state_63932[(4)])));

return statearr_63938;
})();
var state_63932__$1 = state_63932;
var ex63936 = (state_63932__$1[(2)]);
var statearr_63939_63952 = state_63932__$1;
(statearr_63939_63952[(5)] = ex63936);


if((ex63936 instanceof Error)){
var statearr_63940_63953 = state_63932__$1;
(statearr_63940_63953[(1)] = (4));

(statearr_63940_63953[(5)] = null);

} else {
throw ex63936;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63933 === (6))){
var inst_63916 = (state_63932[(2)]);
var inst_63917 = fluree.db.util.async.throw_err.call(null,inst_63916);
var inst_63918 = cljs.core.nth.call(null,inst_63917,(0),null);
var inst_63919 = cljs.core.nth.call(null,inst_63917,(1),null);
var inst_63920 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63921 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63922 = ["?s","?ctx",inst_63918];
var inst_63923 = cljs.core.PersistentHashMap.fromArrays(inst_63921,inst_63922);
var inst_63924 = ((10) + inst_63919);
var inst_63925 = [inst_63923,inst_63924];
var inst_63926 = (new cljs.core.PersistentVector(null,2,(5),inst_63920,inst_63925,null));
var inst_63927 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_63926);
var _ = (function (){var statearr_63941 = state_63932;
(statearr_63941[(4)] = cljs.core.rest.call(null,(state_63932[(4)])));

return statearr_63941;
})();
var state_63932__$1 = (function (){var statearr_63942 = state_63932;
(statearr_63942[(7)] = inst_63927);

return statearr_63942;
})();
var statearr_63943_63954 = state_63932__$1;
(statearr_63943_63954[(2)] = inst_63918);

(statearr_63943_63954[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10903__auto____0 = (function (){
var statearr_63944 = [null,null,null,null,null,null,null,null];
(statearr_63944[(0)] = fluree$db$dbfunctions$fns$state_machine__10903__auto__);

(statearr_63944[(1)] = (1));

return statearr_63944;
});
var fluree$db$dbfunctions$fns$state_machine__10903__auto____1 = (function (state_63932){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_63932);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e63945){var ex__10906__auto__ = e63945;
var statearr_63946_63955 = state_63932;
(statearr_63946_63955[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_63932[(4)]))){
var statearr_63947_63956 = state_63932;
(statearr_63947_63956[(1)] = cljs.core.first.call(null,(state_63932[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63957 = state_63932;
state_63932 = G__63957;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10903__auto__ = function(state_63932){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____1.call(this,state_63932);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_63948 = f__10977__auto__.call(null);
(statearr_63948[(6)] = c__10976__auto__);

return statearr_63948;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__63959 = arguments.length;
switch (G__63959) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_63997){
var state_val_63998 = (state_63997[(1)]);
if((state_val_63998 === (7))){
var inst_63990 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?p from this function interface");
var state_63997__$1 = state_63997;
var statearr_63999_64019 = state_63997__$1;
(statearr_63999_64019[(2)] = inst_63990);

(statearr_63999_64019[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63998 === (1))){
var state_63997__$1 = state_63997;
var statearr_64000_64020 = state_63997__$1;
(statearr_64000_64020[(2)] = null);

(statearr_64000_64020[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63998 === (4))){
var inst_63960 = (state_63997[(2)]);
var state_63997__$1 = state_63997;
var statearr_64001_64021 = state_63997__$1;
(statearr_64001_64021[(2)] = inst_63960);

(statearr_64001_64021[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63998 === (6))){
var inst_63971 = fluree.db.dbfunctions.fns.coerce_args.call(null,additional_select);
var state_63997__$1 = state_63997;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63997__$1,(10),inst_63971);
} else {
if((state_val_63998 === (3))){
var inst_63995 = (state_63997[(2)]);
var state_63997__$1 = state_63997;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63997__$1,inst_63995);
} else {
if((state_val_63998 === (2))){
var _ = (function (){var statearr_64003 = state_63997;
(statearr_64003[(4)] = cljs.core.cons.call(null,(5),(state_63997[(4)])));

return statearr_64003;
})();
var inst_63966 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_63997__$1 = state_63997;
if(cljs.core.truth_(inst_63966)){
var statearr_64004_64022 = state_63997__$1;
(statearr_64004_64022[(1)] = (6));

} else {
var statearr_64005_64023 = state_63997__$1;
(statearr_64005_64023[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63998 === (9))){
var inst_63977 = (state_63997[(2)]);
var inst_63978 = fluree.db.util.async.throw_err.call(null,inst_63977);
var inst_63979 = cljs.core.nth.call(null,inst_63978,(0),null);
var inst_63980 = cljs.core.nth.call(null,inst_63978,(1),null);
var inst_63981 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63982 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_63983 = ["?p","?ctx",inst_63979];
var inst_63984 = cljs.core.PersistentHashMap.fromArrays(inst_63982,inst_63983);
var inst_63985 = ((10) + inst_63980);
var inst_63986 = [inst_63984,inst_63985];
var inst_63987 = (new cljs.core.PersistentVector(null,2,(5),inst_63981,inst_63986,null));
var inst_63988 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_63987);
var state_63997__$1 = (function (){var statearr_64006 = state_63997;
(statearr_64006[(7)] = inst_63988);

return statearr_64006;
})();
var statearr_64007_64024 = state_63997__$1;
(statearr_64007_64024[(2)] = inst_63979);

(statearr_64007_64024[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63998 === (5))){
var _ = (function (){var statearr_64008 = state_63997;
(statearr_64008[(4)] = cljs.core.rest.call(null,(state_63997[(4)])));

return statearr_64008;
})();
var state_63997__$1 = state_63997;
var ex64002 = (state_63997__$1[(2)]);
var statearr_64009_64025 = state_63997__$1;
(statearr_64009_64025[(5)] = ex64002);


if((ex64002 instanceof Error)){
var statearr_64010_64026 = state_63997__$1;
(statearr_64010_64026[(1)] = (4));

(statearr_64010_64026[(5)] = null);

} else {
throw ex64002;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63998 === (10))){
var inst_63973 = (state_63997[(2)]);
var inst_63974 = fluree.db.util.async.throw_err.call(null,inst_63973);
var inst_63975 = fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,inst_63974);
var state_63997__$1 = state_63997;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63997__$1,(9),inst_63975);
} else {
if((state_val_63998 === (8))){
var inst_63992 = (state_63997[(2)]);
var _ = (function (){var statearr_64011 = state_63997;
(statearr_64011[(4)] = cljs.core.rest.call(null,(state_63997[(4)])));

return statearr_64011;
})();
var state_63997__$1 = state_63997;
var statearr_64012_64027 = state_63997__$1;
(statearr_64012_64027[(2)] = inst_63992);

(statearr_64012_64027[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10903__auto____0 = (function (){
var statearr_64013 = [null,null,null,null,null,null,null,null];
(statearr_64013[(0)] = fluree$db$dbfunctions$fns$state_machine__10903__auto__);

(statearr_64013[(1)] = (1));

return statearr_64013;
});
var fluree$db$dbfunctions$fns$state_machine__10903__auto____1 = (function (state_63997){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_63997);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e64014){var ex__10906__auto__ = e64014;
var statearr_64015_64028 = state_63997;
(statearr_64015_64028[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_63997[(4)]))){
var statearr_64016_64029 = state_63997;
(statearr_64016_64029[(1)] = cljs.core.first.call(null,(state_63997[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64030 = state_63997;
state_63997 = G__64030;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10903__auto__ = function(state_63997){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____1.call(this,state_63997);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_64017 = f__10977__auto__.call(null);
(statearr_64017[(6)] = c__10976__auto__);

return statearr_64017;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4870__auto__ = [];
var len__4864__auto___64079 = arguments.length;
var i__4865__auto___64080 = (0);
while(true){
if((i__4865__auto___64080 < len__4864__auto___64079)){
args__4870__auto__.push((arguments[i__4865__auto___64080]));

var G__64081 = (i__4865__auto___64080 + (1));
i__4865__auto___64080 = G__64081;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_64062){
var state_val_64063 = (state_64062[(1)]);
if((state_val_64063 === (1))){
var state_64062__$1 = state_64062;
var statearr_64064_64082 = state_64062__$1;
(statearr_64064_64082[(2)] = null);

(statearr_64064_64082[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64063 === (2))){
var _ = (function (){var statearr_64065 = state_64062;
(statearr_64065[(4)] = cljs.core.cons.call(null,(5),(state_64062[(4)])));

return statearr_64065;
})();
var inst_64039 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_64062__$1 = state_64062;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64062__$1,(6),inst_64039);
} else {
if((state_val_64063 === (3))){
var inst_64060 = (state_64062[(2)]);
var state_64062__$1 = state_64062;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64062__$1,inst_64060);
} else {
if((state_val_64063 === (4))){
var inst_64033 = (state_64062[(2)]);
var state_64062__$1 = state_64062;
var statearr_64067_64083 = state_64062__$1;
(statearr_64067_64083[(2)] = inst_64033);

(statearr_64067_64083[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64063 === (5))){
var _ = (function (){var statearr_64068 = state_64062;
(statearr_64068[(4)] = cljs.core.rest.call(null,(state_64062[(4)])));

return statearr_64068;
})();
var state_64062__$1 = state_64062;
var ex64066 = (state_64062__$1[(2)]);
var statearr_64069_64084 = state_64062__$1;
(statearr_64069_64084[(5)] = ex64066);


if((ex64066 instanceof Error)){
var statearr_64070_64085 = state_64062__$1;
(statearr_64070_64085[(1)] = (4));

(statearr_64070_64085[(5)] = null);

} else {
throw ex64066;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64063 === (6))){
var inst_64041 = (state_64062[(2)]);
var inst_64042 = fluree.db.util.async.throw_err.call(null,inst_64041);
var inst_64043 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.and,inst_64042);
var inst_64044 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64045 = [inst_64042];
var inst_64046 = (new cljs.core.PersistentVector(null,1,(5),inst_64044,inst_64045,null));
var inst_64047 = cljs.core.count.call(null,inst_64046);
var inst_64048 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64049 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64050 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64051 = [inst_64042];
var inst_64052 = (new cljs.core.PersistentVector(null,1,(5),inst_64050,inst_64051,null));
var inst_64053 = ["and",inst_64052,inst_64043];
var inst_64054 = cljs.core.PersistentHashMap.fromArrays(inst_64049,inst_64053);
var inst_64055 = [inst_64054,inst_64047];
var inst_64056 = (new cljs.core.PersistentVector(null,2,(5),inst_64048,inst_64055,null));
var inst_64057 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64056);
var _ = (function (){var statearr_64071 = state_64062;
(statearr_64071[(4)] = cljs.core.rest.call(null,(state_64062[(4)])));

return statearr_64071;
})();
var state_64062__$1 = (function (){var statearr_64072 = state_64062;
(statearr_64072[(7)] = inst_64057);

return statearr_64072;
})();
var statearr_64073_64086 = state_64062__$1;
(statearr_64073_64086[(2)] = inst_64043);

(statearr_64073_64086[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10903__auto____0 = (function (){
var statearr_64074 = [null,null,null,null,null,null,null,null];
(statearr_64074[(0)] = fluree$db$dbfunctions$fns$state_machine__10903__auto__);

(statearr_64074[(1)] = (1));

return statearr_64074;
});
var fluree$db$dbfunctions$fns$state_machine__10903__auto____1 = (function (state_64062){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_64062);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e64075){var ex__10906__auto__ = e64075;
var statearr_64076_64087 = state_64062;
(statearr_64076_64087[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_64062[(4)]))){
var statearr_64077_64088 = state_64062;
(statearr_64077_64088[(1)] = cljs.core.first.call(null,(state_64062[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64089 = state_64062;
state_64062 = G__64089;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10903__auto__ = function(state_64062){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____1.call(this,state_64062);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_64078 = f__10977__auto__.call(null);
(statearr_64078[(6)] = c__10976__auto__);

return statearr_64078;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq64031){
var G__64032 = cljs.core.first.call(null,seq64031);
var seq64031__$1 = cljs.core.next.call(null,seq64031);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__64032,seq64031__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4870__auto__ = [];
var len__4864__auto___64138 = arguments.length;
var i__4865__auto___64139 = (0);
while(true){
if((i__4865__auto___64139 < len__4864__auto___64138)){
args__4870__auto__.push((arguments[i__4865__auto___64139]));

var G__64140 = (i__4865__auto___64139 + (1));
i__4865__auto___64139 = G__64140;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_64121){
var state_val_64122 = (state_64121[(1)]);
if((state_val_64122 === (1))){
var state_64121__$1 = state_64121;
var statearr_64123_64141 = state_64121__$1;
(statearr_64123_64141[(2)] = null);

(statearr_64123_64141[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64122 === (2))){
var _ = (function (){var statearr_64124 = state_64121;
(statearr_64124[(4)] = cljs.core.cons.call(null,(5),(state_64121[(4)])));

return statearr_64124;
})();
var inst_64098 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_64121__$1 = state_64121;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64121__$1,(6),inst_64098);
} else {
if((state_val_64122 === (3))){
var inst_64119 = (state_64121[(2)]);
var state_64121__$1 = state_64121;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64121__$1,inst_64119);
} else {
if((state_val_64122 === (4))){
var inst_64092 = (state_64121[(2)]);
var state_64121__$1 = state_64121;
var statearr_64126_64142 = state_64121__$1;
(statearr_64126_64142[(2)] = inst_64092);

(statearr_64126_64142[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64122 === (5))){
var _ = (function (){var statearr_64127 = state_64121;
(statearr_64127[(4)] = cljs.core.rest.call(null,(state_64121[(4)])));

return statearr_64127;
})();
var state_64121__$1 = state_64121;
var ex64125 = (state_64121__$1[(2)]);
var statearr_64128_64143 = state_64121__$1;
(statearr_64128_64143[(5)] = ex64125);


if((ex64125 instanceof Error)){
var statearr_64129_64144 = state_64121__$1;
(statearr_64129_64144[(1)] = (4));

(statearr_64129_64144[(5)] = null);

} else {
throw ex64125;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64122 === (6))){
var inst_64100 = (state_64121[(2)]);
var inst_64101 = fluree.db.util.async.throw_err.call(null,inst_64100);
var inst_64102 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.or,inst_64101);
var inst_64103 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64104 = [inst_64101];
var inst_64105 = (new cljs.core.PersistentVector(null,1,(5),inst_64103,inst_64104,null));
var inst_64106 = cljs.core.count.call(null,inst_64105);
var inst_64107 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64108 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64109 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64110 = [inst_64101];
var inst_64111 = (new cljs.core.PersistentVector(null,1,(5),inst_64109,inst_64110,null));
var inst_64112 = ["or",inst_64111,inst_64102];
var inst_64113 = cljs.core.PersistentHashMap.fromArrays(inst_64108,inst_64112);
var inst_64114 = [inst_64113,inst_64106];
var inst_64115 = (new cljs.core.PersistentVector(null,2,(5),inst_64107,inst_64114,null));
var inst_64116 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64115);
var _ = (function (){var statearr_64130 = state_64121;
(statearr_64130[(4)] = cljs.core.rest.call(null,(state_64121[(4)])));

return statearr_64130;
})();
var state_64121__$1 = (function (){var statearr_64131 = state_64121;
(statearr_64131[(7)] = inst_64116);

return statearr_64131;
})();
var statearr_64132_64145 = state_64121__$1;
(statearr_64132_64145[(2)] = inst_64102);

(statearr_64132_64145[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10903__auto____0 = (function (){
var statearr_64133 = [null,null,null,null,null,null,null,null];
(statearr_64133[(0)] = fluree$db$dbfunctions$fns$state_machine__10903__auto__);

(statearr_64133[(1)] = (1));

return statearr_64133;
});
var fluree$db$dbfunctions$fns$state_machine__10903__auto____1 = (function (state_64121){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_64121);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e64134){var ex__10906__auto__ = e64134;
var statearr_64135_64146 = state_64121;
(statearr_64135_64146[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_64121[(4)]))){
var statearr_64136_64147 = state_64121;
(statearr_64136_64147[(1)] = cljs.core.first.call(null,(state_64121[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64148 = state_64121;
state_64121 = G__64148;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10903__auto__ = function(state_64121){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____1.call(this,state_64121);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_64137 = f__10977__auto__.call(null);
(statearr_64137[(6)] = c__10976__auto__);

return statearr_64137;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq64090){
var G__64091 = cljs.core.first.call(null,seq64090);
var seq64090__$1 = cljs.core.next.call(null,seq64090);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__64091,seq64090__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_64186){
var state_val_64187 = (state_64186[(1)]);
if((state_val_64187 === (7))){
var inst_64162 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_64186__$1 = state_64186;
if(inst_64162){
var statearr_64188_64211 = state_64186__$1;
(statearr_64188_64211[(1)] = (10));

} else {
var statearr_64189_64212 = state_64186__$1;
(statearr_64189_64212[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64187 === (1))){
var state_64186__$1 = state_64186;
var statearr_64190_64213 = state_64186__$1;
(statearr_64190_64213[(2)] = null);

(statearr_64190_64213[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64187 === (4))){
var inst_64149 = (state_64186[(2)]);
var state_64186__$1 = state_64186;
var statearr_64191_64214 = state_64186__$1;
(statearr_64191_64214[(2)] = inst_64149);

(statearr_64191_64214[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64187 === (13))){
var inst_64165 = (state_64186[(2)]);
var inst_64166 = fluree.db.util.async.throw_err.call(null,inst_64165);
var state_64186__$1 = state_64186;
var statearr_64192_64215 = state_64186__$1;
(statearr_64192_64215[(2)] = inst_64166);

(statearr_64192_64215[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64187 === (6))){
var inst_64157 = fluree.db.dbfunctions.fns.coerce_args.call(null,coll);
var state_64186__$1 = state_64186;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64186__$1,(9),inst_64157);
} else {
if((state_val_64187 === (3))){
var inst_64184 = (state_64186[(2)]);
var state_64186__$1 = state_64186;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64186__$1,inst_64184);
} else {
if((state_val_64187 === (12))){
var inst_64169 = (state_64186[(2)]);
var state_64186__$1 = state_64186;
var statearr_64193_64216 = state_64186__$1;
(statearr_64193_64216[(2)] = inst_64169);

(statearr_64193_64216[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64187 === (2))){
var _ = (function (){var statearr_64194 = state_64186;
(statearr_64194[(4)] = cljs.core.cons.call(null,(5),(state_64186[(4)])));

return statearr_64194;
})();
var inst_64155 = cljs.core.vector_QMARK_.call(null,coll);
var state_64186__$1 = state_64186;
if(inst_64155){
var statearr_64195_64217 = state_64186__$1;
(statearr_64195_64217[(1)] = (6));

} else {
var statearr_64196_64218 = state_64186__$1;
(statearr_64196_64218[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64187 === (11))){
var state_64186__$1 = state_64186;
var statearr_64198_64219 = state_64186__$1;
(statearr_64198_64219[(2)] = coll);

(statearr_64198_64219[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64187 === (9))){
var inst_64159 = (state_64186[(2)]);
var inst_64160 = fluree.db.util.async.throw_err.call(null,inst_64159);
var state_64186__$1 = state_64186;
var statearr_64199_64220 = state_64186__$1;
(statearr_64199_64220[(2)] = inst_64160);

(statearr_64199_64220[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64187 === (5))){
var _ = (function (){var statearr_64200 = state_64186;
(statearr_64200[(4)] = cljs.core.rest.call(null,(state_64186[(4)])));

return statearr_64200;
})();
var state_64186__$1 = state_64186;
var ex64197 = (state_64186__$1[(2)]);
var statearr_64201_64221 = state_64186__$1;
(statearr_64201_64221[(5)] = ex64197);


if((ex64197 instanceof Error)){
var statearr_64202_64222 = state_64186__$1;
(statearr_64202_64222[(1)] = (4));

(statearr_64202_64222[(5)] = null);

} else {
throw ex64197;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64187 === (10))){
var state_64186__$1 = state_64186;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64186__$1,(13),coll);
} else {
if((state_val_64187 === (8))){
var inst_64171 = (state_64186[(2)]);
var inst_64172 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_64171);
var inst_64173 = cljs.core.count.call(null,inst_64172);
var inst_64174 = ((9) + inst_64173);
var inst_64175 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64176 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64177 = ["count",inst_64171,inst_64173];
var inst_64178 = cljs.core.PersistentHashMap.fromArrays(inst_64176,inst_64177);
var inst_64179 = [inst_64178,inst_64174];
var inst_64180 = (new cljs.core.PersistentVector(null,2,(5),inst_64175,inst_64179,null));
var inst_64181 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64180);
var _ = (function (){var statearr_64203 = state_64186;
(statearr_64203[(4)] = cljs.core.rest.call(null,(state_64186[(4)])));

return statearr_64203;
})();
var state_64186__$1 = (function (){var statearr_64204 = state_64186;
(statearr_64204[(7)] = inst_64181);

return statearr_64204;
})();
var statearr_64205_64223 = state_64186__$1;
(statearr_64205_64223[(2)] = inst_64173);

(statearr_64205_64223[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__10903__auto____0 = (function (){
var statearr_64206 = [null,null,null,null,null,null,null,null];
(statearr_64206[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__10903__auto__);

(statearr_64206[(1)] = (1));

return statearr_64206;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__10903__auto____1 = (function (state_64186){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_64186);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e64207){var ex__10906__auto__ = e64207;
var statearr_64208_64224 = state_64186;
(statearr_64208_64224[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_64186[(4)]))){
var statearr_64209_64225 = state_64186;
(statearr_64209_64225[(1)] = cljs.core.first.call(null,(state_64186[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64226 = state_64186;
state_64186 = G__64226;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__10903__auto__ = function(state_64186){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__10903__auto____1.call(this,state_64186);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_64210 = f__10977__auto__.call(null);
(statearr_64210[(6)] = c__10976__auto__);

return statearr_64210;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_64276){
var state_val_64277 = (state_64276[(1)]);
if((state_val_64277 === (7))){
var state_64276__$1 = state_64276;
var statearr_64278_64311 = state_64276__$1;
(statearr_64278_64311[(2)] = subject);

(statearr_64278_64311[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64277 === (1))){
var state_64276__$1 = state_64276;
var statearr_64279_64312 = state_64276__$1;
(statearr_64279_64312[(2)] = null);

(statearr_64279_64312[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64277 === (4))){
var inst_64227 = (state_64276[(2)]);
var state_64276__$1 = state_64276;
var statearr_64280_64313 = state_64276__$1;
(statearr_64280_64313[(2)] = inst_64227);

(statearr_64280_64313[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64277 === (15))){
var inst_64240 = (state_64276[(7)]);
var state_64276__$1 = state_64276;
var statearr_64281_64314 = state_64276__$1;
(statearr_64281_64314[(2)] = inst_64240);

(statearr_64281_64314[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64277 === (13))){
var inst_64244 = (state_64276[(2)]);
var inst_64245 = fluree.db.util.async.throw_err.call(null,inst_64244);
var state_64276__$1 = state_64276;
var statearr_64282_64315 = state_64276__$1;
(statearr_64282_64315[(2)] = inst_64245);

(statearr_64282_64315[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64277 === (6))){
var state_64276__$1 = state_64276;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64276__$1,(9),subject);
} else {
if((state_val_64277 === (17))){
var inst_64240 = (state_64276[(7)]);
var inst_64254 = cljs.core.first.call(null,inst_64240);
var state_64276__$1 = state_64276;
var statearr_64283_64316 = state_64276__$1;
(statearr_64283_64316[(2)] = inst_64254);

(statearr_64283_64316[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64277 === (3))){
var inst_64274 = (state_64276[(2)]);
var state_64276__$1 = state_64276;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64276__$1,inst_64274);
} else {
if((state_val_64277 === (12))){
var inst_64240 = (state_64276[(7)]);
var inst_64248 = (state_64276[(2)]);
var inst_64249 = cljs.core.vector_QMARK_.call(null,inst_64240);
var state_64276__$1 = (function (){var statearr_64284 = state_64276;
(statearr_64284[(8)] = inst_64248);

return statearr_64284;
})();
if(inst_64249){
var statearr_64285_64317 = state_64276__$1;
(statearr_64285_64317[(1)] = (14));

} else {
var statearr_64286_64318 = state_64276__$1;
(statearr_64286_64318[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64277 === (2))){
var _ = (function (){var statearr_64287 = state_64276;
(statearr_64287[(4)] = cljs.core.cons.call(null,(5),(state_64276[(4)])));

return statearr_64287;
})();
var inst_64233 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_64276__$1 = state_64276;
if(inst_64233){
var statearr_64288_64319 = state_64276__$1;
(statearr_64288_64319[(1)] = (6));

} else {
var statearr_64289_64320 = state_64276__$1;
(statearr_64289_64320[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64277 === (19))){
var inst_64257 = (state_64276[(2)]);
var state_64276__$1 = state_64276;
var statearr_64290_64321 = state_64276__$1;
(statearr_64290_64321[(2)] = inst_64257);

(statearr_64290_64321[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64277 === (11))){
var state_64276__$1 = state_64276;
var statearr_64292_64322 = state_64276__$1;
(statearr_64292_64322[(2)] = pred);

(statearr_64292_64322[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64277 === (9))){
var inst_64236 = (state_64276[(2)]);
var inst_64237 = fluree.db.util.async.throw_err.call(null,inst_64236);
var state_64276__$1 = state_64276;
var statearr_64293_64323 = state_64276__$1;
(statearr_64293_64323[(2)] = inst_64237);

(statearr_64293_64323[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64277 === (5))){
var _ = (function (){var statearr_64294 = state_64276;
(statearr_64294[(4)] = cljs.core.rest.call(null,(state_64276[(4)])));

return statearr_64294;
})();
var state_64276__$1 = state_64276;
var ex64291 = (state_64276__$1[(2)]);
var statearr_64295_64324 = state_64276__$1;
(statearr_64295_64324[(5)] = ex64291);


if((ex64291 instanceof Error)){
var statearr_64296_64325 = state_64276__$1;
(statearr_64296_64325[(1)] = (4));

(statearr_64296_64325[(5)] = null);

} else {
throw ex64291;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64277 === (14))){
var inst_64240 = (state_64276[(7)]);
var inst_64251 = cljs.core.count.call(null,inst_64240);
var inst_64252 = cljs.core._EQ_.call(null,(1),inst_64251);
var state_64276__$1 = state_64276;
if(inst_64252){
var statearr_64297_64326 = state_64276__$1;
(statearr_64297_64326[(1)] = (17));

} else {
var statearr_64298_64327 = state_64276__$1;
(statearr_64298_64327[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64277 === (16))){
var inst_64240 = (state_64276[(7)]);
var inst_64248 = (state_64276[(8)]);
var inst_64260 = (state_64276[(2)]);
var inst_64261 = fluree.db.dbfunctions.internal.get.call(null,inst_64260,inst_64248);
var inst_64262 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64263 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64264 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64265 = [inst_64240,inst_64248];
var inst_64266 = (new cljs.core.PersistentVector(null,2,(5),inst_64264,inst_64265,null));
var inst_64267 = ["get",inst_64266,inst_64261];
var inst_64268 = cljs.core.PersistentHashMap.fromArrays(inst_64263,inst_64267);
var inst_64269 = [inst_64268,(10)];
var inst_64270 = (new cljs.core.PersistentVector(null,2,(5),inst_64262,inst_64269,null));
var inst_64271 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64270);
var _ = (function (){var statearr_64299 = state_64276;
(statearr_64299[(4)] = cljs.core.rest.call(null,(state_64276[(4)])));

return statearr_64299;
})();
var state_64276__$1 = (function (){var statearr_64300 = state_64276;
(statearr_64300[(9)] = inst_64271);

return statearr_64300;
})();
var statearr_64301_64328 = state_64276__$1;
(statearr_64301_64328[(2)] = inst_64261);

(statearr_64301_64328[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64277 === (10))){
var state_64276__$1 = state_64276;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64276__$1,(13),pred);
} else {
if((state_val_64277 === (18))){
var inst_64240 = (state_64276[(7)]);
var state_64276__$1 = state_64276;
var statearr_64302_64329 = state_64276__$1;
(statearr_64302_64329[(2)] = inst_64240);

(statearr_64302_64329[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64277 === (8))){
var inst_64240 = (state_64276[(2)]);
var inst_64241 = fluree.db.util.async.channel_QMARK_.call(null,pred);
var state_64276__$1 = (function (){var statearr_64303 = state_64276;
(statearr_64303[(7)] = inst_64240);

return statearr_64303;
})();
if(inst_64241){
var statearr_64304_64330 = state_64276__$1;
(statearr_64304_64330[(1)] = (10));

} else {
var statearr_64305_64331 = state_64276__$1;
(statearr_64305_64331[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__10903__auto____0 = (function (){
var statearr_64306 = [null,null,null,null,null,null,null,null,null,null];
(statearr_64306[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__10903__auto__);

(statearr_64306[(1)] = (1));

return statearr_64306;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__10903__auto____1 = (function (state_64276){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_64276);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e64307){var ex__10906__auto__ = e64307;
var statearr_64308_64332 = state_64276;
(statearr_64308_64332[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_64276[(4)]))){
var statearr_64309_64333 = state_64276;
(statearr_64309_64333[(1)] = cljs.core.first.call(null,(state_64276[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64334 = state_64276;
state_64276 = G__64334;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__10903__auto__ = function(state_64276){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__10903__auto____1.call(this,state_64276);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_64310 = f__10977__auto__.call(null);
(statearr_64310[(6)] = c__10976__auto__);

return statearr_64310;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_64373){
var state_val_64374 = (state_64373[(1)]);
if((state_val_64374 === (7))){
var inst_64341 = (state_64373[(7)]);
var state_64373__$1 = state_64373;
var statearr_64375_64399 = state_64373__$1;
(statearr_64375_64399[(2)] = inst_64341);

(statearr_64375_64399[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64374 === (1))){
var state_64373__$1 = state_64373;
var statearr_64376_64400 = state_64373__$1;
(statearr_64376_64400[(2)] = null);

(statearr_64376_64400[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64374 === (4))){
var inst_64335 = (state_64373[(2)]);
var state_64373__$1 = state_64373;
var statearr_64377_64401 = state_64373__$1;
(statearr_64377_64401[(2)] = inst_64335);

(statearr_64377_64401[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64374 === (6))){
var inst_64343 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_64373__$1 = state_64373;
var statearr_64378_64402 = state_64373__$1;
(statearr_64378_64402[(2)] = inst_64343);

(statearr_64378_64402[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64374 === (3))){
var inst_64371 = (state_64373[(2)]);
var state_64373__$1 = state_64373;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64373__$1,inst_64371);
} else {
if((state_val_64374 === (12))){
var inst_64353 = (state_64373[(2)]);
var inst_64354 = fluree.db.util.async.throw_err.call(null,inst_64353);
var inst_64355 = cljs.core.nth.call(null,inst_64354,(0),null);
var inst_64356 = cljs.core.nth.call(null,inst_64354,(1),null);
var inst_64357 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64358 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64359 = ["?pO","?ctx",inst_64355];
var inst_64360 = cljs.core.PersistentHashMap.fromArrays(inst_64358,inst_64359);
var inst_64361 = ((10) + inst_64356);
var inst_64362 = [inst_64360,inst_64361];
var inst_64363 = (new cljs.core.PersistentVector(null,2,(5),inst_64357,inst_64362,null));
var inst_64364 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64363);
var state_64373__$1 = (function (){var statearr_64379 = state_64373;
(statearr_64379[(8)] = inst_64364);

return statearr_64379;
})();
var statearr_64380_64403 = state_64373__$1;
(statearr_64380_64403[(2)] = inst_64355);

(statearr_64380_64403[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64374 === (2))){
var inst_64341 = (state_64373[(7)]);
var _ = (function (){var statearr_64381 = state_64373;
(statearr_64381[(4)] = cljs.core.cons.call(null,(5),(state_64373[(4)])));

return statearr_64381;
})();
var inst_64341__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_64373__$1 = (function (){var statearr_64382 = state_64373;
(statearr_64382[(7)] = inst_64341__$1);

return statearr_64382;
})();
if(cljs.core.truth_(inst_64341__$1)){
var statearr_64383_64404 = state_64373__$1;
(statearr_64383_64404[(1)] = (6));

} else {
var statearr_64384_64405 = state_64373__$1;
(statearr_64384_64405[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64374 === (11))){
var inst_64368 = (state_64373[(2)]);
var _ = (function (){var statearr_64386 = state_64373;
(statearr_64386[(4)] = cljs.core.rest.call(null,(state_64373[(4)])));

return statearr_64386;
})();
var state_64373__$1 = state_64373;
var statearr_64387_64406 = state_64373__$1;
(statearr_64387_64406[(2)] = inst_64368);

(statearr_64387_64406[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64374 === (9))){
var inst_64351 = fluree.db.dbfunctions.internal._QMARK_pO.call(null,_QMARK_ctx);
var state_64373__$1 = state_64373;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64373__$1,(12),inst_64351);
} else {
if((state_val_64374 === (5))){
var _ = (function (){var statearr_64388 = state_64373;
(statearr_64388[(4)] = cljs.core.rest.call(null,(state_64373[(4)])));

return statearr_64388;
})();
var state_64373__$1 = state_64373;
var ex64385 = (state_64373__$1[(2)]);
var statearr_64389_64407 = state_64373__$1;
(statearr_64389_64407[(5)] = ex64385);


if((ex64385 instanceof Error)){
var statearr_64390_64408 = state_64373__$1;
(statearr_64390_64408[(1)] = (4));

(statearr_64390_64408[(5)] = null);

} else {
throw ex64385;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64374 === (10))){
var inst_64366 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_64373__$1 = state_64373;
var statearr_64391_64409 = state_64373__$1;
(statearr_64391_64409[(2)] = inst_64366);

(statearr_64391_64409[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64374 === (8))){
var inst_64346 = (state_64373[(2)]);
var state_64373__$1 = state_64373;
if(cljs.core.truth_(inst_64346)){
var statearr_64392_64410 = state_64373__$1;
(statearr_64392_64410[(1)] = (9));

} else {
var statearr_64393_64411 = state_64373__$1;
(statearr_64393_64411[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10903__auto____0 = (function (){
var statearr_64394 = [null,null,null,null,null,null,null,null,null];
(statearr_64394[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10903__auto__);

(statearr_64394[(1)] = (1));

return statearr_64394;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10903__auto____1 = (function (state_64373){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_64373);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e64395){var ex__10906__auto__ = e64395;
var statearr_64396_64412 = state_64373;
(statearr_64396_64412[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_64373[(4)]))){
var statearr_64397_64413 = state_64373;
(statearr_64397_64413[(1)] = cljs.core.first.call(null,(state_64373[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64414 = state_64373;
state_64373 = G__64414;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10903__auto__ = function(state_64373){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10903__auto____1.call(this,state_64373);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_64398 = f__10977__auto__.call(null);
(statearr_64398[(6)] = c__10976__auto__);

return statearr_64398;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_64466){
var state_val_64467 = (state_64466[(1)]);
if((state_val_64467 === (7))){
var state_64466__$1 = state_64466;
var statearr_64468_64501 = state_64466__$1;
(statearr_64468_64501[(2)] = subject);

(statearr_64468_64501[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (1))){
var state_64466__$1 = state_64466;
var statearr_64469_64502 = state_64466__$1;
(statearr_64469_64502[(2)] = null);

(statearr_64469_64502[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (4))){
var inst_64415 = (state_64466[(2)]);
var state_64466__$1 = state_64466;
var statearr_64470_64503 = state_64466__$1;
(statearr_64470_64503[(2)] = inst_64415);

(statearr_64470_64503[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (15))){
var inst_64428 = (state_64466[(7)]);
var state_64466__$1 = state_64466;
var statearr_64471_64504 = state_64466__$1;
(statearr_64471_64504[(2)] = inst_64428);

(statearr_64471_64504[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (13))){
var inst_64432 = (state_64466[(2)]);
var inst_64433 = fluree.db.util.async.throw_err.call(null,inst_64432);
var state_64466__$1 = state_64466;
var statearr_64472_64505 = state_64466__$1;
(statearr_64472_64505[(2)] = inst_64433);

(statearr_64472_64505[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (6))){
var state_64466__$1 = state_64466;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64466__$1,(9),subject);
} else {
if((state_val_64467 === (17))){
var inst_64428 = (state_64466[(7)]);
var inst_64442 = cljs.core.first.call(null,inst_64428);
var state_64466__$1 = state_64466;
var statearr_64473_64506 = state_64466__$1;
(statearr_64473_64506[(2)] = inst_64442);

(statearr_64473_64506[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (3))){
var inst_64464 = (state_64466[(2)]);
var state_64466__$1 = state_64466;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64466__$1,inst_64464);
} else {
if((state_val_64467 === (12))){
var inst_64428 = (state_64466[(7)]);
var inst_64436 = (state_64466[(2)]);
var inst_64437 = cljs.core.vector_QMARK_.call(null,inst_64428);
var state_64466__$1 = (function (){var statearr_64474 = state_64466;
(statearr_64474[(8)] = inst_64436);

return statearr_64474;
})();
if(inst_64437){
var statearr_64475_64507 = state_64466__$1;
(statearr_64475_64507[(1)] = (14));

} else {
var statearr_64476_64508 = state_64466__$1;
(statearr_64476_64508[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (2))){
var _ = (function (){var statearr_64477 = state_64466;
(statearr_64477[(4)] = cljs.core.cons.call(null,(5),(state_64466[(4)])));

return statearr_64477;
})();
var inst_64421 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_64466__$1 = state_64466;
if(inst_64421){
var statearr_64478_64509 = state_64466__$1;
(statearr_64478_64509[(1)] = (6));

} else {
var statearr_64479_64510 = state_64466__$1;
(statearr_64479_64510[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (19))){
var inst_64445 = (state_64466[(2)]);
var state_64466__$1 = state_64466;
var statearr_64480_64511 = state_64466__$1;
(statearr_64480_64511[(2)] = inst_64445);

(statearr_64480_64511[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (11))){
var state_64466__$1 = state_64466;
var statearr_64482_64512 = state_64466__$1;
(statearr_64482_64512[(2)] = path);

(statearr_64482_64512[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (9))){
var inst_64424 = (state_64466[(2)]);
var inst_64425 = fluree.db.util.async.throw_err.call(null,inst_64424);
var state_64466__$1 = state_64466;
var statearr_64483_64513 = state_64466__$1;
(statearr_64483_64513[(2)] = inst_64425);

(statearr_64483_64513[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (5))){
var _ = (function (){var statearr_64484 = state_64466;
(statearr_64484[(4)] = cljs.core.rest.call(null,(state_64466[(4)])));

return statearr_64484;
})();
var state_64466__$1 = state_64466;
var ex64481 = (state_64466__$1[(2)]);
var statearr_64485_64514 = state_64466__$1;
(statearr_64485_64514[(5)] = ex64481);


if((ex64481 instanceof Error)){
var statearr_64486_64515 = state_64466__$1;
(statearr_64486_64515[(1)] = (4));

(statearr_64486_64515[(5)] = null);

} else {
throw ex64481;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (14))){
var inst_64428 = (state_64466[(7)]);
var inst_64439 = cljs.core.count.call(null,inst_64428);
var inst_64440 = cljs.core._EQ_.call(null,(1),inst_64439);
var state_64466__$1 = state_64466;
if(inst_64440){
var statearr_64487_64516 = state_64466__$1;
(statearr_64487_64516[(1)] = (17));

} else {
var statearr_64488_64517 = state_64466__$1;
(statearr_64488_64517[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (16))){
var inst_64436 = (state_64466[(8)]);
var inst_64428 = (state_64466[(7)]);
var inst_64448 = (state_64466[(2)]);
var inst_64449 = fluree.db.dbfunctions.internal.get_all.call(null,inst_64448,inst_64436);
var inst_64450 = cljs.core.count.call(null,inst_64436);
var inst_64451 = ((9) + inst_64450);
var inst_64452 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64453 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64454 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64455 = [inst_64428,inst_64436];
var inst_64456 = (new cljs.core.PersistentVector(null,2,(5),inst_64454,inst_64455,null));
var inst_64457 = ["get-all",inst_64456,inst_64449];
var inst_64458 = cljs.core.PersistentHashMap.fromArrays(inst_64453,inst_64457);
var inst_64459 = [inst_64458,inst_64451];
var inst_64460 = (new cljs.core.PersistentVector(null,2,(5),inst_64452,inst_64459,null));
var inst_64461 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64460);
var _ = (function (){var statearr_64489 = state_64466;
(statearr_64489[(4)] = cljs.core.rest.call(null,(state_64466[(4)])));

return statearr_64489;
})();
var state_64466__$1 = (function (){var statearr_64490 = state_64466;
(statearr_64490[(9)] = inst_64461);

return statearr_64490;
})();
var statearr_64491_64518 = state_64466__$1;
(statearr_64491_64518[(2)] = inst_64449);

(statearr_64491_64518[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (10))){
var state_64466__$1 = state_64466;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64466__$1,(13),path);
} else {
if((state_val_64467 === (18))){
var inst_64428 = (state_64466[(7)]);
var state_64466__$1 = state_64466;
var statearr_64492_64519 = state_64466__$1;
(statearr_64492_64519[(2)] = inst_64428);

(statearr_64492_64519[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64467 === (8))){
var inst_64428 = (state_64466[(2)]);
var inst_64429 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_64466__$1 = (function (){var statearr_64493 = state_64466;
(statearr_64493[(7)] = inst_64428);

return statearr_64493;
})();
if(inst_64429){
var statearr_64494_64520 = state_64466__$1;
(statearr_64494_64520[(1)] = (10));

} else {
var statearr_64495_64521 = state_64466__$1;
(statearr_64495_64521[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__10903__auto____0 = (function (){
var statearr_64496 = [null,null,null,null,null,null,null,null,null,null];
(statearr_64496[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__10903__auto__);

(statearr_64496[(1)] = (1));

return statearr_64496;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__10903__auto____1 = (function (state_64466){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_64466);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e64497){var ex__10906__auto__ = e64497;
var statearr_64498_64522 = state_64466;
(statearr_64498_64522[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_64466[(4)]))){
var statearr_64499_64523 = state_64466;
(statearr_64499_64523[(1)] = cljs.core.first.call(null,(state_64466[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64524 = state_64466;
state_64466 = G__64524;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__10903__auto__ = function(state_64466){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__10903__auto____1.call(this,state_64466);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_64500 = f__10977__auto__.call(null);
(statearr_64500[(6)] = c__10976__auto__);

return statearr_64500;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Returns the value of a nested structure
 */
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_64563){
var state_val_64564 = (state_64563[(1)]);
if((state_val_64564 === (7))){
var state_64563__$1 = state_64563;
var statearr_64565_64589 = state_64563__$1;
(statearr_64565_64589[(2)] = subject);

(statearr_64565_64589[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64564 === (1))){
var state_64563__$1 = state_64563;
var statearr_64566_64590 = state_64563__$1;
(statearr_64566_64590[(2)] = null);

(statearr_64566_64590[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64564 === (4))){
var inst_64525 = (state_64563[(2)]);
var state_64563__$1 = state_64563;
var statearr_64567_64591 = state_64563__$1;
(statearr_64567_64591[(2)] = inst_64525);

(statearr_64567_64591[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64564 === (13))){
var inst_64542 = (state_64563[(2)]);
var inst_64543 = fluree.db.util.async.throw_err.call(null,inst_64542);
var state_64563__$1 = state_64563;
var statearr_64568_64592 = state_64563__$1;
(statearr_64568_64592[(2)] = inst_64543);

(statearr_64568_64592[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64564 === (6))){
var state_64563__$1 = state_64563;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64563__$1,(9),subject);
} else {
if((state_val_64564 === (3))){
var inst_64561 = (state_64563[(2)]);
var state_64563__$1 = state_64563;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64563__$1,inst_64561);
} else {
if((state_val_64564 === (12))){
var inst_64538 = (state_64563[(7)]);
var inst_64546 = (state_64563[(2)]);
var inst_64547 = fluree.db.dbfunctions.internal.get_in.call(null,inst_64538,inst_64546);
var inst_64548 = cljs.core.count.call(null,inst_64546);
var inst_64549 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64550 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64551 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64552 = [inst_64538,inst_64546];
var inst_64553 = (new cljs.core.PersistentVector(null,2,(5),inst_64551,inst_64552,null));
var inst_64554 = ["get-in",inst_64553,inst_64547];
var inst_64555 = cljs.core.PersistentHashMap.fromArrays(inst_64550,inst_64554);
var inst_64556 = [inst_64555,inst_64548];
var inst_64557 = (new cljs.core.PersistentVector(null,2,(5),inst_64549,inst_64556,null));
var inst_64558 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64557);
var _ = (function (){var statearr_64569 = state_64563;
(statearr_64569[(4)] = cljs.core.rest.call(null,(state_64563[(4)])));

return statearr_64569;
})();
var state_64563__$1 = (function (){var statearr_64570 = state_64563;
(statearr_64570[(8)] = inst_64558);

return statearr_64570;
})();
var statearr_64571_64593 = state_64563__$1;
(statearr_64571_64593[(2)] = inst_64547);

(statearr_64571_64593[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64564 === (2))){
var _ = (function (){var statearr_64572 = state_64563;
(statearr_64572[(4)] = cljs.core.cons.call(null,(5),(state_64563[(4)])));

return statearr_64572;
})();
var inst_64531 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_64563__$1 = state_64563;
if(inst_64531){
var statearr_64573_64594 = state_64563__$1;
(statearr_64573_64594[(1)] = (6));

} else {
var statearr_64574_64595 = state_64563__$1;
(statearr_64574_64595[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64564 === (11))){
var state_64563__$1 = state_64563;
var statearr_64576_64596 = state_64563__$1;
(statearr_64576_64596[(2)] = path);

(statearr_64576_64596[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64564 === (9))){
var inst_64534 = (state_64563[(2)]);
var inst_64535 = fluree.db.util.async.throw_err.call(null,inst_64534);
var state_64563__$1 = state_64563;
var statearr_64577_64597 = state_64563__$1;
(statearr_64577_64597[(2)] = inst_64535);

(statearr_64577_64597[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64564 === (5))){
var _ = (function (){var statearr_64578 = state_64563;
(statearr_64578[(4)] = cljs.core.rest.call(null,(state_64563[(4)])));

return statearr_64578;
})();
var state_64563__$1 = state_64563;
var ex64575 = (state_64563__$1[(2)]);
var statearr_64579_64598 = state_64563__$1;
(statearr_64579_64598[(5)] = ex64575);


if((ex64575 instanceof Error)){
var statearr_64580_64599 = state_64563__$1;
(statearr_64580_64599[(1)] = (4));

(statearr_64580_64599[(5)] = null);

} else {
throw ex64575;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64564 === (10))){
var state_64563__$1 = state_64563;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64563__$1,(13),path);
} else {
if((state_val_64564 === (8))){
var inst_64538 = (state_64563[(2)]);
var inst_64539 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_64563__$1 = (function (){var statearr_64581 = state_64563;
(statearr_64581[(7)] = inst_64538);

return statearr_64581;
})();
if(inst_64539){
var statearr_64582_64600 = state_64563__$1;
(statearr_64582_64600[(1)] = (10));

} else {
var statearr_64583_64601 = state_64563__$1;
(statearr_64583_64601[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__10903__auto____0 = (function (){
var statearr_64584 = [null,null,null,null,null,null,null,null,null];
(statearr_64584[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__10903__auto__);

(statearr_64584[(1)] = (1));

return statearr_64584;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__10903__auto____1 = (function (state_64563){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_64563);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e64585){var ex__10906__auto__ = e64585;
var statearr_64586_64602 = state_64563;
(statearr_64586_64602[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_64563[(4)]))){
var statearr_64587_64603 = state_64563;
(statearr_64587_64603[(1)] = cljs.core.first.call(null,(state_64563[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64604 = state_64563;
state_64563 = G__64604;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__10903__auto__ = function(state_64563){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__10903__auto____1.call(this,state_64563);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_64588 = f__10977__auto__.call(null);
(statearr_64588[(6)] = c__10976__auto__);

return statearr_64588;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_64649){
var state_val_64650 = (state_64649[(1)]);
if((state_val_64650 === (7))){
var state_64649__$1 = state_64649;
var statearr_64651_64680 = state_64649__$1;
(statearr_64651_64680[(2)] = coll);

(statearr_64651_64680[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64650 === (1))){
var state_64649__$1 = state_64649;
var statearr_64652_64681 = state_64649__$1;
(statearr_64652_64681[(2)] = null);

(statearr_64652_64681[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64650 === (4))){
var inst_64605 = (state_64649[(2)]);
var state_64649__$1 = state_64649;
var statearr_64653_64682 = state_64649__$1;
(statearr_64653_64682[(2)] = inst_64605);

(statearr_64653_64682[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64650 === (15))){
var inst_64625 = (state_64649[(7)]);
var inst_64633 = (state_64649[(2)]);
var inst_64634 = fluree.db.dbfunctions.internal.contains_QMARK_.call(null,inst_64625,inst_64633);
var inst_64635 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64636 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64637 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64638 = [inst_64625,inst_64633];
var inst_64639 = (new cljs.core.PersistentVector(null,2,(5),inst_64637,inst_64638,null));
var inst_64640 = ["contains?",inst_64639,inst_64634];
var inst_64641 = cljs.core.PersistentHashMap.fromArrays(inst_64636,inst_64640);
var inst_64642 = [inst_64641,(10)];
var inst_64643 = (new cljs.core.PersistentVector(null,2,(5),inst_64635,inst_64642,null));
var inst_64644 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64643);
var _ = (function (){var statearr_64654 = state_64649;
(statearr_64654[(4)] = cljs.core.rest.call(null,(state_64649[(4)])));

return statearr_64654;
})();
var state_64649__$1 = (function (){var statearr_64655 = state_64649;
(statearr_64655[(8)] = inst_64644);

return statearr_64655;
})();
var statearr_64656_64683 = state_64649__$1;
(statearr_64656_64683[(2)] = inst_64634);

(statearr_64656_64683[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64650 === (13))){
var state_64649__$1 = state_64649;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64649__$1,(16),key);
} else {
if((state_val_64650 === (6))){
var state_64649__$1 = state_64649;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64649__$1,(9),coll);
} else {
if((state_val_64650 === (3))){
var inst_64647 = (state_64649[(2)]);
var state_64649__$1 = state_64649;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64649__$1,inst_64647);
} else {
if((state_val_64650 === (12))){
var inst_64625 = (state_64649[(2)]);
var inst_64626 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_64649__$1 = (function (){var statearr_64657 = state_64649;
(statearr_64657[(7)] = inst_64625);

return statearr_64657;
})();
if(inst_64626){
var statearr_64658_64684 = state_64649__$1;
(statearr_64658_64684[(1)] = (13));

} else {
var statearr_64659_64685 = state_64649__$1;
(statearr_64659_64685[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64650 === (2))){
var _ = (function (){var statearr_64660 = state_64649;
(statearr_64660[(4)] = cljs.core.cons.call(null,(5),(state_64649[(4)])));

return statearr_64660;
})();
var inst_64611 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_64649__$1 = state_64649;
if(inst_64611){
var statearr_64661_64686 = state_64649__$1;
(statearr_64661_64686[(1)] = (6));

} else {
var statearr_64662_64687 = state_64649__$1;
(statearr_64662_64687[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64650 === (11))){
var inst_64618 = (state_64649[(9)]);
var inst_64622 = cljs.core.flatten.call(null,inst_64618);
var inst_64623 = cljs.core.set.call(null,inst_64622);
var state_64649__$1 = state_64649;
var statearr_64664_64688 = state_64649__$1;
(statearr_64664_64688[(2)] = inst_64623);

(statearr_64664_64688[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64650 === (9))){
var inst_64614 = (state_64649[(2)]);
var inst_64615 = fluree.db.util.async.throw_err.call(null,inst_64614);
var state_64649__$1 = state_64649;
var statearr_64665_64689 = state_64649__$1;
(statearr_64665_64689[(2)] = inst_64615);

(statearr_64665_64689[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64650 === (5))){
var _ = (function (){var statearr_64666 = state_64649;
(statearr_64666[(4)] = cljs.core.rest.call(null,(state_64649[(4)])));

return statearr_64666;
})();
var state_64649__$1 = state_64649;
var ex64663 = (state_64649__$1[(2)]);
var statearr_64667_64690 = state_64649__$1;
(statearr_64667_64690[(5)] = ex64663);


if((ex64663 instanceof Error)){
var statearr_64668_64691 = state_64649__$1;
(statearr_64668_64691[(1)] = (4));

(statearr_64668_64691[(5)] = null);

} else {
throw ex64663;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64650 === (14))){
var state_64649__$1 = state_64649;
var statearr_64669_64692 = state_64649__$1;
(statearr_64669_64692[(2)] = key);

(statearr_64669_64692[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64650 === (16))){
var inst_64629 = (state_64649[(2)]);
var inst_64630 = fluree.db.util.async.throw_err.call(null,inst_64629);
var state_64649__$1 = state_64649;
var statearr_64670_64693 = state_64649__$1;
(statearr_64670_64693[(2)] = inst_64630);

(statearr_64670_64693[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64650 === (10))){
var inst_64618 = (state_64649[(9)]);
var state_64649__$1 = state_64649;
var statearr_64671_64694 = state_64649__$1;
(statearr_64671_64694[(2)] = inst_64618);

(statearr_64671_64694[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64650 === (8))){
var inst_64618 = (state_64649[(9)]);
var inst_64618__$1 = (state_64649[(2)]);
var inst_64619 = cljs.core.set_QMARK_.call(null,inst_64618__$1);
var state_64649__$1 = (function (){var statearr_64672 = state_64649;
(statearr_64672[(9)] = inst_64618__$1);

return statearr_64672;
})();
if(inst_64619){
var statearr_64673_64695 = state_64649__$1;
(statearr_64673_64695[(1)] = (10));

} else {
var statearr_64674_64696 = state_64649__$1;
(statearr_64674_64696[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10903__auto____0 = (function (){
var statearr_64675 = [null,null,null,null,null,null,null,null,null,null];
(statearr_64675[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10903__auto__);

(statearr_64675[(1)] = (1));

return statearr_64675;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10903__auto____1 = (function (state_64649){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_64649);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e64676){var ex__10906__auto__ = e64676;
var statearr_64677_64697 = state_64649;
(statearr_64677_64697[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_64649[(4)]))){
var statearr_64678_64698 = state_64649;
(statearr_64678_64698[(1)] = cljs.core.first.call(null,(state_64649[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64699 = state_64649;
state_64649 = G__64699;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10903__auto__ = function(state_64649){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10903__auto____1.call(this,state_64649);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_64679 = f__10977__auto__.call(null);
(statearr_64679[(6)] = c__10976__auto__);

return statearr_64679;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Returns a hash-set of values
 */
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4870__auto__ = [];
var len__4864__auto___64771 = arguments.length;
var i__4865__auto___64772 = (0);
while(true){
if((i__4865__auto___64772 < len__4864__auto___64771)){
args__4870__auto__.push((arguments[i__4865__auto___64772]));

var G__64773 = (i__4865__auto___64772 + (1));
i__4865__auto___64772 = G__64773;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_64745){
var state_val_64746 = (state_64745[(1)]);
if((state_val_64746 === (7))){
var inst_64711 = (state_64745[(7)]);
var inst_64715 = cljs.core.first.call(null,inst_64711);
var inst_64716 = cljs.core.coll_QMARK_.call(null,inst_64715);
var state_64745__$1 = state_64745;
var statearr_64747_64774 = state_64745__$1;
(statearr_64747_64774[(2)] = inst_64716);

(statearr_64747_64774[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64746 === (1))){
var state_64745__$1 = state_64745;
var statearr_64748_64775 = state_64745__$1;
(statearr_64748_64775[(2)] = null);

(statearr_64748_64775[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64746 === (4))){
var inst_64702 = (state_64745[(2)]);
var state_64745__$1 = state_64745;
var statearr_64749_64776 = state_64745__$1;
(statearr_64749_64776[(2)] = inst_64702);

(statearr_64749_64776[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64746 === (6))){
var inst_64713 = (state_64745[(8)]);
var inst_64711 = (state_64745[(7)]);
var inst_64710 = (state_64745[(2)]);
var inst_64711__$1 = fluree.db.util.async.throw_err.call(null,inst_64710);
var inst_64712 = cljs.core.count.call(null,inst_64711__$1);
var inst_64713__$1 = cljs.core._EQ_.call(null,(1),inst_64712);
var state_64745__$1 = (function (){var statearr_64750 = state_64745;
(statearr_64750[(8)] = inst_64713__$1);

(statearr_64750[(7)] = inst_64711__$1);

return statearr_64750;
})();
if(inst_64713__$1){
var statearr_64751_64777 = state_64745__$1;
(statearr_64751_64777[(1)] = (7));

} else {
var statearr_64752_64778 = state_64745__$1;
(statearr_64752_64778[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64746 === (3))){
var inst_64743 = (state_64745[(2)]);
var state_64745__$1 = state_64745;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64745__$1,inst_64743);
} else {
if((state_val_64746 === (12))){
var inst_64724 = (state_64745[(2)]);
var inst_64725 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.hash_set,inst_64724);
var inst_64726 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64727 = [inst_64724];
var inst_64728 = (new cljs.core.PersistentVector(null,1,(5),inst_64726,inst_64727,null));
var inst_64729 = cljs.core.count.call(null,inst_64728);
var inst_64730 = ((9) + inst_64729);
var inst_64731 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64732 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64733 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64734 = [inst_64724];
var inst_64735 = (new cljs.core.PersistentVector(null,1,(5),inst_64733,inst_64734,null));
var inst_64736 = ["hash-set",inst_64735,inst_64725];
var inst_64737 = cljs.core.PersistentHashMap.fromArrays(inst_64732,inst_64736);
var inst_64738 = [inst_64737,inst_64730];
var inst_64739 = (new cljs.core.PersistentVector(null,2,(5),inst_64731,inst_64738,null));
var inst_64740 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64739);
var _ = (function (){var statearr_64753 = state_64745;
(statearr_64753[(4)] = cljs.core.rest.call(null,(state_64745[(4)])));

return statearr_64753;
})();
var state_64745__$1 = (function (){var statearr_64754 = state_64745;
(statearr_64754[(9)] = inst_64740);

return statearr_64754;
})();
var statearr_64755_64779 = state_64745__$1;
(statearr_64755_64779[(2)] = inst_64725);

(statearr_64755_64779[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64746 === (2))){
var _ = (function (){var statearr_64756 = state_64745;
(statearr_64756[(4)] = cljs.core.cons.call(null,(5),(state_64745[(4)])));

return statearr_64756;
})();
var inst_64708 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_64745__$1 = state_64745;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64745__$1,(6),inst_64708);
} else {
if((state_val_64746 === (11))){
var inst_64711 = (state_64745[(7)]);
var state_64745__$1 = state_64745;
var statearr_64758_64780 = state_64745__$1;
(statearr_64758_64780[(2)] = inst_64711);

(statearr_64758_64780[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64746 === (9))){
var inst_64719 = (state_64745[(2)]);
var state_64745__$1 = state_64745;
if(cljs.core.truth_(inst_64719)){
var statearr_64759_64781 = state_64745__$1;
(statearr_64759_64781[(1)] = (10));

} else {
var statearr_64760_64782 = state_64745__$1;
(statearr_64760_64782[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64746 === (5))){
var _ = (function (){var statearr_64761 = state_64745;
(statearr_64761[(4)] = cljs.core.rest.call(null,(state_64745[(4)])));

return statearr_64761;
})();
var state_64745__$1 = state_64745;
var ex64757 = (state_64745__$1[(2)]);
var statearr_64762_64783 = state_64745__$1;
(statearr_64762_64783[(5)] = ex64757);


if((ex64757 instanceof Error)){
var statearr_64763_64784 = state_64745__$1;
(statearr_64763_64784[(1)] = (4));

(statearr_64763_64784[(5)] = null);

} else {
throw ex64757;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64746 === (10))){
var inst_64711 = (state_64745[(7)]);
var inst_64721 = cljs.core.first.call(null,inst_64711);
var state_64745__$1 = state_64745;
var statearr_64764_64785 = state_64745__$1;
(statearr_64764_64785[(2)] = inst_64721);

(statearr_64764_64785[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64746 === (8))){
var inst_64713 = (state_64745[(8)]);
var state_64745__$1 = state_64745;
var statearr_64765_64786 = state_64745__$1;
(statearr_64765_64786[(2)] = inst_64713);

(statearr_64765_64786[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10903__auto____0 = (function (){
var statearr_64766 = [null,null,null,null,null,null,null,null,null,null];
(statearr_64766[(0)] = fluree$db$dbfunctions$fns$state_machine__10903__auto__);

(statearr_64766[(1)] = (1));

return statearr_64766;
});
var fluree$db$dbfunctions$fns$state_machine__10903__auto____1 = (function (state_64745){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_64745);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e64767){var ex__10906__auto__ = e64767;
var statearr_64768_64787 = state_64745;
(statearr_64768_64787[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_64745[(4)]))){
var statearr_64769_64788 = state_64745;
(statearr_64769_64788[(1)] = cljs.core.first.call(null,(state_64745[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64789 = state_64745;
state_64745 = G__64789;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10903__auto__ = function(state_64745){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____1.call(this,state_64745);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_64770 = f__10977__auto__.call(null);
(statearr_64770[(6)] = c__10976__auto__);

return statearr_64770;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq64700){
var G__64701 = cljs.core.first.call(null,seq64700);
var seq64700__$1 = cljs.core.next.call(null,seq64700);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__64701,seq64700__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___64839 = arguments.length;
var i__4865__auto___64840 = (0);
while(true){
if((i__4865__auto___64840 < len__4864__auto___64839)){
args__4870__auto__.push((arguments[i__4865__auto___64840]));

var G__64841 = (i__4865__auto___64840 + (1));
i__4865__auto___64840 = G__64841;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_64822){
var state_val_64823 = (state_64822[(1)]);
if((state_val_64823 === (1))){
var state_64822__$1 = state_64822;
var statearr_64824_64842 = state_64822__$1;
(statearr_64824_64842[(2)] = null);

(statearr_64824_64842[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64823 === (2))){
var _ = (function (){var statearr_64825 = state_64822;
(statearr_64825[(4)] = cljs.core.cons.call(null,(5),(state_64822[(4)])));

return statearr_64825;
})();
var inst_64798 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_64822__$1 = state_64822;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64822__$1,(6),inst_64798);
} else {
if((state_val_64823 === (3))){
var inst_64820 = (state_64822[(2)]);
var state_64822__$1 = state_64822;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64822__$1,inst_64820);
} else {
if((state_val_64823 === (4))){
var inst_64792 = (state_64822[(2)]);
var state_64822__$1 = state_64822;
var statearr_64827_64843 = state_64822__$1;
(statearr_64827_64843[(2)] = inst_64792);

(statearr_64827_64843[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64823 === (5))){
var _ = (function (){var statearr_64828 = state_64822;
(statearr_64828[(4)] = cljs.core.rest.call(null,(state_64822[(4)])));

return statearr_64828;
})();
var state_64822__$1 = state_64822;
var ex64826 = (state_64822__$1[(2)]);
var statearr_64829_64844 = state_64822__$1;
(statearr_64829_64844[(5)] = ex64826);


if((ex64826 instanceof Error)){
var statearr_64830_64845 = state_64822__$1;
(statearr_64830_64845[(1)] = (4));

(statearr_64830_64845[(5)] = null);

} else {
throw ex64826;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64823 === (6))){
var inst_64800 = (state_64822[(2)]);
var inst_64801 = fluree.db.util.async.throw_err.call(null,inst_64800);
var inst_64802 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._EQ__EQ_,inst_64801);
var inst_64803 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64804 = [inst_64801];
var inst_64805 = (new cljs.core.PersistentVector(null,1,(5),inst_64803,inst_64804,null));
var inst_64806 = cljs.core.count.call(null,inst_64805);
var inst_64807 = ((9) + inst_64806);
var inst_64808 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64809 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64810 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64811 = [inst_64801];
var inst_64812 = (new cljs.core.PersistentVector(null,1,(5),inst_64810,inst_64811,null));
var inst_64813 = ["==",inst_64812,inst_64802];
var inst_64814 = cljs.core.PersistentHashMap.fromArrays(inst_64809,inst_64813);
var inst_64815 = [inst_64814,inst_64807];
var inst_64816 = (new cljs.core.PersistentVector(null,2,(5),inst_64808,inst_64815,null));
var inst_64817 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64816);
var _ = (function (){var statearr_64831 = state_64822;
(statearr_64831[(4)] = cljs.core.rest.call(null,(state_64822[(4)])));

return statearr_64831;
})();
var state_64822__$1 = (function (){var statearr_64832 = state_64822;
(statearr_64832[(7)] = inst_64817);

return statearr_64832;
})();
var statearr_64833_64846 = state_64822__$1;
(statearr_64833_64846[(2)] = inst_64802);

(statearr_64833_64846[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10903__auto____0 = (function (){
var statearr_64834 = [null,null,null,null,null,null,null,null];
(statearr_64834[(0)] = fluree$db$dbfunctions$fns$state_machine__10903__auto__);

(statearr_64834[(1)] = (1));

return statearr_64834;
});
var fluree$db$dbfunctions$fns$state_machine__10903__auto____1 = (function (state_64822){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_64822);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e64835){var ex__10906__auto__ = e64835;
var statearr_64836_64847 = state_64822;
(statearr_64836_64847[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_64822[(4)]))){
var statearr_64837_64848 = state_64822;
(statearr_64837_64848[(1)] = cljs.core.first.call(null,(state_64822[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64849 = state_64822;
state_64822 = G__64849;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10903__auto__ = function(state_64822){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____1.call(this,state_64822);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_64838 = f__10977__auto__.call(null);
(statearr_64838[(6)] = c__10976__auto__);

return statearr_64838;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq64790){
var G__64791 = cljs.core.first.call(null,seq64790);
var seq64790__$1 = cljs.core.next.call(null,seq64790);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__64791,seq64790__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___64899 = arguments.length;
var i__4865__auto___64900 = (0);
while(true){
if((i__4865__auto___64900 < len__4864__auto___64899)){
args__4870__auto__.push((arguments[i__4865__auto___64900]));

var G__64901 = (i__4865__auto___64900 + (1));
i__4865__auto___64900 = G__64901;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_64882){
var state_val_64883 = (state_64882[(1)]);
if((state_val_64883 === (1))){
var state_64882__$1 = state_64882;
var statearr_64884_64902 = state_64882__$1;
(statearr_64884_64902[(2)] = null);

(statearr_64884_64902[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64883 === (2))){
var _ = (function (){var statearr_64885 = state_64882;
(statearr_64885[(4)] = cljs.core.cons.call(null,(5),(state_64882[(4)])));

return statearr_64885;
})();
var inst_64858 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_64882__$1 = state_64882;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64882__$1,(6),inst_64858);
} else {
if((state_val_64883 === (3))){
var inst_64880 = (state_64882[(2)]);
var state_64882__$1 = state_64882;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64882__$1,inst_64880);
} else {
if((state_val_64883 === (4))){
var inst_64852 = (state_64882[(2)]);
var state_64882__$1 = state_64882;
var statearr_64887_64903 = state_64882__$1;
(statearr_64887_64903[(2)] = inst_64852);

(statearr_64887_64903[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64883 === (5))){
var _ = (function (){var statearr_64888 = state_64882;
(statearr_64888[(4)] = cljs.core.rest.call(null,(state_64882[(4)])));

return statearr_64888;
})();
var state_64882__$1 = state_64882;
var ex64886 = (state_64882__$1[(2)]);
var statearr_64889_64904 = state_64882__$1;
(statearr_64889_64904[(5)] = ex64886);


if((ex64886 instanceof Error)){
var statearr_64890_64905 = state_64882__$1;
(statearr_64890_64905[(1)] = (4));

(statearr_64890_64905[(5)] = null);

} else {
throw ex64886;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64883 === (6))){
var inst_64860 = (state_64882[(2)]);
var inst_64861 = fluree.db.util.async.throw_err.call(null,inst_64860);
var inst_64862 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT_,inst_64861);
var inst_64863 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64864 = [inst_64861];
var inst_64865 = (new cljs.core.PersistentVector(null,1,(5),inst_64863,inst_64864,null));
var inst_64866 = cljs.core.count.call(null,inst_64865);
var inst_64867 = ((9) + inst_64866);
var inst_64868 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64869 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64870 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64871 = [inst_64861];
var inst_64872 = (new cljs.core.PersistentVector(null,1,(5),inst_64870,inst_64871,null));
var inst_64873 = [">",inst_64872,inst_64862];
var inst_64874 = cljs.core.PersistentHashMap.fromArrays(inst_64869,inst_64873);
var inst_64875 = [inst_64874,inst_64867];
var inst_64876 = (new cljs.core.PersistentVector(null,2,(5),inst_64868,inst_64875,null));
var inst_64877 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64876);
var _ = (function (){var statearr_64891 = state_64882;
(statearr_64891[(4)] = cljs.core.rest.call(null,(state_64882[(4)])));

return statearr_64891;
})();
var state_64882__$1 = (function (){var statearr_64892 = state_64882;
(statearr_64892[(7)] = inst_64877);

return statearr_64892;
})();
var statearr_64893_64906 = state_64882__$1;
(statearr_64893_64906[(2)] = inst_64862);

(statearr_64893_64906[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10903__auto____0 = (function (){
var statearr_64894 = [null,null,null,null,null,null,null,null];
(statearr_64894[(0)] = fluree$db$dbfunctions$fns$state_machine__10903__auto__);

(statearr_64894[(1)] = (1));

return statearr_64894;
});
var fluree$db$dbfunctions$fns$state_machine__10903__auto____1 = (function (state_64882){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_64882);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e64895){var ex__10906__auto__ = e64895;
var statearr_64896_64907 = state_64882;
(statearr_64896_64907[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_64882[(4)]))){
var statearr_64897_64908 = state_64882;
(statearr_64897_64908[(1)] = cljs.core.first.call(null,(state_64882[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64909 = state_64882;
state_64882 = G__64909;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10903__auto__ = function(state_64882){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____1.call(this,state_64882);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_64898 = f__10977__auto__.call(null);
(statearr_64898[(6)] = c__10976__auto__);

return statearr_64898;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq64850){
var G__64851 = cljs.core.first.call(null,seq64850);
var seq64850__$1 = cljs.core.next.call(null,seq64850);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__64851,seq64850__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___64959 = arguments.length;
var i__4865__auto___64960 = (0);
while(true){
if((i__4865__auto___64960 < len__4864__auto___64959)){
args__4870__auto__.push((arguments[i__4865__auto___64960]));

var G__64961 = (i__4865__auto___64960 + (1));
i__4865__auto___64960 = G__64961;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_64942){
var state_val_64943 = (state_64942[(1)]);
if((state_val_64943 === (1))){
var state_64942__$1 = state_64942;
var statearr_64944_64962 = state_64942__$1;
(statearr_64944_64962[(2)] = null);

(statearr_64944_64962[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64943 === (2))){
var _ = (function (){var statearr_64945 = state_64942;
(statearr_64945[(4)] = cljs.core.cons.call(null,(5),(state_64942[(4)])));

return statearr_64945;
})();
var inst_64918 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_64942__$1 = state_64942;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64942__$1,(6),inst_64918);
} else {
if((state_val_64943 === (3))){
var inst_64940 = (state_64942[(2)]);
var state_64942__$1 = state_64942;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64942__$1,inst_64940);
} else {
if((state_val_64943 === (4))){
var inst_64912 = (state_64942[(2)]);
var state_64942__$1 = state_64942;
var statearr_64947_64963 = state_64942__$1;
(statearr_64947_64963[(2)] = inst_64912);

(statearr_64947_64963[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64943 === (5))){
var _ = (function (){var statearr_64948 = state_64942;
(statearr_64948[(4)] = cljs.core.rest.call(null,(state_64942[(4)])));

return statearr_64948;
})();
var state_64942__$1 = state_64942;
var ex64946 = (state_64942__$1[(2)]);
var statearr_64949_64964 = state_64942__$1;
(statearr_64949_64964[(5)] = ex64946);


if((ex64946 instanceof Error)){
var statearr_64950_64965 = state_64942__$1;
(statearr_64950_64965[(1)] = (4));

(statearr_64950_64965[(5)] = null);

} else {
throw ex64946;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64943 === (6))){
var inst_64920 = (state_64942[(2)]);
var inst_64921 = fluree.db.util.async.throw_err.call(null,inst_64920);
var inst_64922 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT_,inst_64921);
var inst_64923 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64924 = [inst_64921];
var inst_64925 = (new cljs.core.PersistentVector(null,1,(5),inst_64923,inst_64924,null));
var inst_64926 = cljs.core.count.call(null,inst_64925);
var inst_64927 = ((9) + inst_64926);
var inst_64928 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64929 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64930 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64931 = [inst_64921];
var inst_64932 = (new cljs.core.PersistentVector(null,1,(5),inst_64930,inst_64931,null));
var inst_64933 = ["<",inst_64932,inst_64922];
var inst_64934 = cljs.core.PersistentHashMap.fromArrays(inst_64929,inst_64933);
var inst_64935 = [inst_64934,inst_64927];
var inst_64936 = (new cljs.core.PersistentVector(null,2,(5),inst_64928,inst_64935,null));
var inst_64937 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64936);
var _ = (function (){var statearr_64951 = state_64942;
(statearr_64951[(4)] = cljs.core.rest.call(null,(state_64942[(4)])));

return statearr_64951;
})();
var state_64942__$1 = (function (){var statearr_64952 = state_64942;
(statearr_64952[(7)] = inst_64937);

return statearr_64952;
})();
var statearr_64953_64966 = state_64942__$1;
(statearr_64953_64966[(2)] = inst_64922);

(statearr_64953_64966[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10903__auto____0 = (function (){
var statearr_64954 = [null,null,null,null,null,null,null,null];
(statearr_64954[(0)] = fluree$db$dbfunctions$fns$state_machine__10903__auto__);

(statearr_64954[(1)] = (1));

return statearr_64954;
});
var fluree$db$dbfunctions$fns$state_machine__10903__auto____1 = (function (state_64942){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_64942);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e64955){var ex__10906__auto__ = e64955;
var statearr_64956_64967 = state_64942;
(statearr_64956_64967[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_64942[(4)]))){
var statearr_64957_64968 = state_64942;
(statearr_64957_64968[(1)] = cljs.core.first.call(null,(state_64942[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64969 = state_64942;
state_64942 = G__64969;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10903__auto__ = function(state_64942){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____1.call(this,state_64942);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_64958 = f__10977__auto__.call(null);
(statearr_64958[(6)] = c__10976__auto__);

return statearr_64958;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq64910){
var G__64911 = cljs.core.first.call(null,seq64910);
var seq64910__$1 = cljs.core.next.call(null,seq64910);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__64911,seq64910__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___65019 = arguments.length;
var i__4865__auto___65020 = (0);
while(true){
if((i__4865__auto___65020 < len__4864__auto___65019)){
args__4870__auto__.push((arguments[i__4865__auto___65020]));

var G__65021 = (i__4865__auto___65020 + (1));
i__4865__auto___65020 = G__65021;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_65002){
var state_val_65003 = (state_65002[(1)]);
if((state_val_65003 === (1))){
var state_65002__$1 = state_65002;
var statearr_65004_65022 = state_65002__$1;
(statearr_65004_65022[(2)] = null);

(statearr_65004_65022[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65003 === (2))){
var _ = (function (){var statearr_65005 = state_65002;
(statearr_65005[(4)] = cljs.core.cons.call(null,(5),(state_65002[(4)])));

return statearr_65005;
})();
var inst_64978 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_65002__$1 = state_65002;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65002__$1,(6),inst_64978);
} else {
if((state_val_65003 === (3))){
var inst_65000 = (state_65002[(2)]);
var state_65002__$1 = state_65002;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65002__$1,inst_65000);
} else {
if((state_val_65003 === (4))){
var inst_64972 = (state_65002[(2)]);
var state_65002__$1 = state_65002;
var statearr_65007_65023 = state_65002__$1;
(statearr_65007_65023[(2)] = inst_64972);

(statearr_65007_65023[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65003 === (5))){
var _ = (function (){var statearr_65008 = state_65002;
(statearr_65008[(4)] = cljs.core.rest.call(null,(state_65002[(4)])));

return statearr_65008;
})();
var state_65002__$1 = state_65002;
var ex65006 = (state_65002__$1[(2)]);
var statearr_65009_65024 = state_65002__$1;
(statearr_65009_65024[(5)] = ex65006);


if((ex65006 instanceof Error)){
var statearr_65010_65025 = state_65002__$1;
(statearr_65010_65025[(1)] = (4));

(statearr_65010_65025[(5)] = null);

} else {
throw ex65006;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65003 === (6))){
var inst_64980 = (state_65002[(2)]);
var inst_64981 = fluree.db.util.async.throw_err.call(null,inst_64980);
var inst_64982 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT__EQ_,inst_64981);
var inst_64983 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64984 = [inst_64981];
var inst_64985 = (new cljs.core.PersistentVector(null,1,(5),inst_64983,inst_64984,null));
var inst_64986 = cljs.core.count.call(null,inst_64985);
var inst_64987 = ((9) + inst_64986);
var inst_64988 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64989 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64990 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64991 = [inst_64981];
var inst_64992 = (new cljs.core.PersistentVector(null,1,(5),inst_64990,inst_64991,null));
var inst_64993 = ["<=",inst_64992,inst_64982];
var inst_64994 = cljs.core.PersistentHashMap.fromArrays(inst_64989,inst_64993);
var inst_64995 = [inst_64994,inst_64987];
var inst_64996 = (new cljs.core.PersistentVector(null,2,(5),inst_64988,inst_64995,null));
var inst_64997 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_64996);
var _ = (function (){var statearr_65011 = state_65002;
(statearr_65011[(4)] = cljs.core.rest.call(null,(state_65002[(4)])));

return statearr_65011;
})();
var state_65002__$1 = (function (){var statearr_65012 = state_65002;
(statearr_65012[(7)] = inst_64997);

return statearr_65012;
})();
var statearr_65013_65026 = state_65002__$1;
(statearr_65013_65026[(2)] = inst_64982);

(statearr_65013_65026[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10903__auto____0 = (function (){
var statearr_65014 = [null,null,null,null,null,null,null,null];
(statearr_65014[(0)] = fluree$db$dbfunctions$fns$state_machine__10903__auto__);

(statearr_65014[(1)] = (1));

return statearr_65014;
});
var fluree$db$dbfunctions$fns$state_machine__10903__auto____1 = (function (state_65002){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_65002);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e65015){var ex__10906__auto__ = e65015;
var statearr_65016_65027 = state_65002;
(statearr_65016_65027[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_65002[(4)]))){
var statearr_65017_65028 = state_65002;
(statearr_65017_65028[(1)] = cljs.core.first.call(null,(state_65002[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65029 = state_65002;
state_65002 = G__65029;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10903__auto__ = function(state_65002){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____1.call(this,state_65002);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_65018 = f__10977__auto__.call(null);
(statearr_65018[(6)] = c__10976__auto__);

return statearr_65018;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq64970){
var G__64971 = cljs.core.first.call(null,seq64970);
var seq64970__$1 = cljs.core.next.call(null,seq64970);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__64971,seq64970__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___65079 = arguments.length;
var i__4865__auto___65080 = (0);
while(true){
if((i__4865__auto___65080 < len__4864__auto___65079)){
args__4870__auto__.push((arguments[i__4865__auto___65080]));

var G__65081 = (i__4865__auto___65080 + (1));
i__4865__auto___65080 = G__65081;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_65062){
var state_val_65063 = (state_65062[(1)]);
if((state_val_65063 === (1))){
var state_65062__$1 = state_65062;
var statearr_65064_65082 = state_65062__$1;
(statearr_65064_65082[(2)] = null);

(statearr_65064_65082[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65063 === (2))){
var _ = (function (){var statearr_65065 = state_65062;
(statearr_65065[(4)] = cljs.core.cons.call(null,(5),(state_65062[(4)])));

return statearr_65065;
})();
var inst_65038 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_65062__$1 = state_65062;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65062__$1,(6),inst_65038);
} else {
if((state_val_65063 === (3))){
var inst_65060 = (state_65062[(2)]);
var state_65062__$1 = state_65062;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65062__$1,inst_65060);
} else {
if((state_val_65063 === (4))){
var inst_65032 = (state_65062[(2)]);
var state_65062__$1 = state_65062;
var statearr_65067_65083 = state_65062__$1;
(statearr_65067_65083[(2)] = inst_65032);

(statearr_65067_65083[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65063 === (5))){
var _ = (function (){var statearr_65068 = state_65062;
(statearr_65068[(4)] = cljs.core.rest.call(null,(state_65062[(4)])));

return statearr_65068;
})();
var state_65062__$1 = state_65062;
var ex65066 = (state_65062__$1[(2)]);
var statearr_65069_65084 = state_65062__$1;
(statearr_65069_65084[(5)] = ex65066);


if((ex65066 instanceof Error)){
var statearr_65070_65085 = state_65062__$1;
(statearr_65070_65085[(1)] = (4));

(statearr_65070_65085[(5)] = null);

} else {
throw ex65066;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65063 === (6))){
var inst_65040 = (state_65062[(2)]);
var inst_65041 = fluree.db.util.async.throw_err.call(null,inst_65040);
var inst_65042 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT__EQ_,inst_65041);
var inst_65043 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65044 = [inst_65041];
var inst_65045 = (new cljs.core.PersistentVector(null,1,(5),inst_65043,inst_65044,null));
var inst_65046 = cljs.core.count.call(null,inst_65045);
var inst_65047 = ((9) + inst_65046);
var inst_65048 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65049 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65050 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65051 = [inst_65041];
var inst_65052 = (new cljs.core.PersistentVector(null,1,(5),inst_65050,inst_65051,null));
var inst_65053 = [">=",inst_65052,inst_65042];
var inst_65054 = cljs.core.PersistentHashMap.fromArrays(inst_65049,inst_65053);
var inst_65055 = [inst_65054,inst_65047];
var inst_65056 = (new cljs.core.PersistentVector(null,2,(5),inst_65048,inst_65055,null));
var inst_65057 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65056);
var _ = (function (){var statearr_65071 = state_65062;
(statearr_65071[(4)] = cljs.core.rest.call(null,(state_65062[(4)])));

return statearr_65071;
})();
var state_65062__$1 = (function (){var statearr_65072 = state_65062;
(statearr_65072[(7)] = inst_65057);

return statearr_65072;
})();
var statearr_65073_65086 = state_65062__$1;
(statearr_65073_65086[(2)] = inst_65042);

(statearr_65073_65086[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10903__auto____0 = (function (){
var statearr_65074 = [null,null,null,null,null,null,null,null];
(statearr_65074[(0)] = fluree$db$dbfunctions$fns$state_machine__10903__auto__);

(statearr_65074[(1)] = (1));

return statearr_65074;
});
var fluree$db$dbfunctions$fns$state_machine__10903__auto____1 = (function (state_65062){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_65062);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e65075){var ex__10906__auto__ = e65075;
var statearr_65076_65087 = state_65062;
(statearr_65076_65087[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_65062[(4)]))){
var statearr_65077_65088 = state_65062;
(statearr_65077_65088[(1)] = cljs.core.first.call(null,(state_65062[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65089 = state_65062;
state_65062 = G__65089;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10903__auto__ = function(state_65062){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____1.call(this,state_65062);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_65078 = f__10977__auto__.call(null);
(statearr_65078[(6)] = c__10976__auto__);

return statearr_65078;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq65030){
var G__65031 = cljs.core.first.call(null,seq65030);
var seq65030__$1 = cljs.core.next.call(null,seq65030);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65031,seq65030__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___65139 = arguments.length;
var i__4865__auto___65140 = (0);
while(true){
if((i__4865__auto___65140 < len__4864__auto___65139)){
args__4870__auto__.push((arguments[i__4865__auto___65140]));

var G__65141 = (i__4865__auto___65140 + (1));
i__4865__auto___65140 = G__65141;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_65122){
var state_val_65123 = (state_65122[(1)]);
if((state_val_65123 === (1))){
var state_65122__$1 = state_65122;
var statearr_65124_65142 = state_65122__$1;
(statearr_65124_65142[(2)] = null);

(statearr_65124_65142[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65123 === (2))){
var _ = (function (){var statearr_65125 = state_65122;
(statearr_65125[(4)] = cljs.core.cons.call(null,(5),(state_65122[(4)])));

return statearr_65125;
})();
var inst_65098 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_65122__$1 = state_65122;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65122__$1,(6),inst_65098);
} else {
if((state_val_65123 === (3))){
var inst_65120 = (state_65122[(2)]);
var state_65122__$1 = state_65122;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65122__$1,inst_65120);
} else {
if((state_val_65123 === (4))){
var inst_65092 = (state_65122[(2)]);
var state_65122__$1 = state_65122;
var statearr_65127_65143 = state_65122__$1;
(statearr_65127_65143[(2)] = inst_65092);

(statearr_65127_65143[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65123 === (5))){
var _ = (function (){var statearr_65128 = state_65122;
(statearr_65128[(4)] = cljs.core.rest.call(null,(state_65122[(4)])));

return statearr_65128;
})();
var state_65122__$1 = state_65122;
var ex65126 = (state_65122__$1[(2)]);
var statearr_65129_65144 = state_65122__$1;
(statearr_65129_65144[(5)] = ex65126);


if((ex65126 instanceof Error)){
var statearr_65130_65145 = state_65122__$1;
(statearr_65130_65145[(1)] = (4));

(statearr_65130_65145[(5)] = null);

} else {
throw ex65126;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65123 === (6))){
var inst_65100 = (state_65122[(2)]);
var inst_65101 = fluree.db.util.async.throw_err.call(null,inst_65100);
var inst_65102 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.not_EQ_,inst_65101);
var inst_65103 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65104 = [inst_65101];
var inst_65105 = (new cljs.core.PersistentVector(null,1,(5),inst_65103,inst_65104,null));
var inst_65106 = cljs.core.count.call(null,inst_65105);
var inst_65107 = ((9) + inst_65106);
var inst_65108 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65109 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65110 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65111 = [inst_65101];
var inst_65112 = (new cljs.core.PersistentVector(null,1,(5),inst_65110,inst_65111,null));
var inst_65113 = ["not=",inst_65112,inst_65102];
var inst_65114 = cljs.core.PersistentHashMap.fromArrays(inst_65109,inst_65113);
var inst_65115 = [inst_65114,inst_65107];
var inst_65116 = (new cljs.core.PersistentVector(null,2,(5),inst_65108,inst_65115,null));
var inst_65117 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65116);
var _ = (function (){var statearr_65131 = state_65122;
(statearr_65131[(4)] = cljs.core.rest.call(null,(state_65122[(4)])));

return statearr_65131;
})();
var state_65122__$1 = (function (){var statearr_65132 = state_65122;
(statearr_65132[(7)] = inst_65117);

return statearr_65132;
})();
var statearr_65133_65146 = state_65122__$1;
(statearr_65133_65146[(2)] = inst_65102);

(statearr_65133_65146[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10903__auto____0 = (function (){
var statearr_65134 = [null,null,null,null,null,null,null,null];
(statearr_65134[(0)] = fluree$db$dbfunctions$fns$state_machine__10903__auto__);

(statearr_65134[(1)] = (1));

return statearr_65134;
});
var fluree$db$dbfunctions$fns$state_machine__10903__auto____1 = (function (state_65122){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_65122);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e65135){var ex__10906__auto__ = e65135;
var statearr_65136_65147 = state_65122;
(statearr_65136_65147[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_65122[(4)]))){
var statearr_65137_65148 = state_65122;
(statearr_65137_65148[(1)] = cljs.core.first.call(null,(state_65122[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65149 = state_65122;
state_65122 = G__65149;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10903__auto__ = function(state_65122){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____1.call(this,state_65122);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_65138 = f__10977__auto__.call(null);
(statearr_65138[(6)] = c__10976__auto__);

return statearr_65138;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq65090){
var G__65091 = cljs.core.first.call(null,seq65090);
var seq65090__$1 = cljs.core.next.call(null,seq65090);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65091,seq65090__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4870__auto__ = [];
var len__4864__auto___65199 = arguments.length;
var i__4865__auto___65200 = (0);
while(true){
if((i__4865__auto___65200 < len__4864__auto___65199)){
args__4870__auto__.push((arguments[i__4865__auto___65200]));

var G__65201 = (i__4865__auto___65200 + (1));
i__4865__auto___65200 = G__65201;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_65182){
var state_val_65183 = (state_65182[(1)]);
if((state_val_65183 === (1))){
var state_65182__$1 = state_65182;
var statearr_65184_65202 = state_65182__$1;
(statearr_65184_65202[(2)] = null);

(statearr_65184_65202[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (2))){
var _ = (function (){var statearr_65185 = state_65182;
(statearr_65185[(4)] = cljs.core.cons.call(null,(5),(state_65182[(4)])));

return statearr_65185;
})();
var inst_65158 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_65182__$1 = state_65182;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65182__$1,(6),inst_65158);
} else {
if((state_val_65183 === (3))){
var inst_65180 = (state_65182[(2)]);
var state_65182__$1 = state_65182;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65182__$1,inst_65180);
} else {
if((state_val_65183 === (4))){
var inst_65152 = (state_65182[(2)]);
var state_65182__$1 = state_65182;
var statearr_65187_65203 = state_65182__$1;
(statearr_65187_65203[(2)] = inst_65152);

(statearr_65187_65203[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (5))){
var _ = (function (){var statearr_65188 = state_65182;
(statearr_65188[(4)] = cljs.core.rest.call(null,(state_65182[(4)])));

return statearr_65188;
})();
var state_65182__$1 = state_65182;
var ex65186 = (state_65182__$1[(2)]);
var statearr_65189_65204 = state_65182__$1;
(statearr_65189_65204[(5)] = ex65186);


if((ex65186 instanceof Error)){
var statearr_65190_65205 = state_65182__$1;
(statearr_65190_65205[(1)] = (4));

(statearr_65190_65205[(5)] = null);

} else {
throw ex65186;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65183 === (6))){
var inst_65160 = (state_65182[(2)]);
var inst_65161 = fluree.db.util.async.throw_err.call(null,inst_65160);
var inst_65162 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_65161);
var inst_65163 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65164 = [inst_65161];
var inst_65165 = (new cljs.core.PersistentVector(null,1,(5),inst_65163,inst_65164,null));
var inst_65166 = cljs.core.count.call(null,inst_65165);
var inst_65167 = ((9) + inst_65166);
var inst_65168 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65169 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65170 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65171 = [inst_65161];
var inst_65172 = (new cljs.core.PersistentVector(null,1,(5),inst_65170,inst_65171,null));
var inst_65173 = ["max",inst_65172,inst_65162];
var inst_65174 = cljs.core.PersistentHashMap.fromArrays(inst_65169,inst_65173);
var inst_65175 = [inst_65174,inst_65167];
var inst_65176 = (new cljs.core.PersistentVector(null,2,(5),inst_65168,inst_65175,null));
var inst_65177 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65176);
var _ = (function (){var statearr_65191 = state_65182;
(statearr_65191[(4)] = cljs.core.rest.call(null,(state_65182[(4)])));

return statearr_65191;
})();
var state_65182__$1 = (function (){var statearr_65192 = state_65182;
(statearr_65192[(7)] = inst_65177);

return statearr_65192;
})();
var statearr_65193_65206 = state_65182__$1;
(statearr_65193_65206[(2)] = inst_65162);

(statearr_65193_65206[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10903__auto____0 = (function (){
var statearr_65194 = [null,null,null,null,null,null,null,null];
(statearr_65194[(0)] = fluree$db$dbfunctions$fns$state_machine__10903__auto__);

(statearr_65194[(1)] = (1));

return statearr_65194;
});
var fluree$db$dbfunctions$fns$state_machine__10903__auto____1 = (function (state_65182){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_65182);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e65195){var ex__10906__auto__ = e65195;
var statearr_65196_65207 = state_65182;
(statearr_65196_65207[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_65182[(4)]))){
var statearr_65197_65208 = state_65182;
(statearr_65197_65208[(1)] = cljs.core.first.call(null,(state_65182[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65209 = state_65182;
state_65182 = G__65209;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10903__auto__ = function(state_65182){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____1.call(this,state_65182);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_65198 = f__10977__auto__.call(null);
(statearr_65198[(6)] = c__10976__auto__);

return statearr_65198;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq65150){
var G__65151 = cljs.core.first.call(null,seq65150);
var seq65150__$1 = cljs.core.next.call(null,seq65150);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65151,seq65150__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4870__auto__ = [];
var len__4864__auto___65259 = arguments.length;
var i__4865__auto___65260 = (0);
while(true){
if((i__4865__auto___65260 < len__4864__auto___65259)){
args__4870__auto__.push((arguments[i__4865__auto___65260]));

var G__65261 = (i__4865__auto___65260 + (1));
i__4865__auto___65260 = G__65261;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_65242){
var state_val_65243 = (state_65242[(1)]);
if((state_val_65243 === (1))){
var state_65242__$1 = state_65242;
var statearr_65244_65262 = state_65242__$1;
(statearr_65244_65262[(2)] = null);

(statearr_65244_65262[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65243 === (2))){
var _ = (function (){var statearr_65245 = state_65242;
(statearr_65245[(4)] = cljs.core.cons.call(null,(5),(state_65242[(4)])));

return statearr_65245;
})();
var inst_65218 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_65242__$1 = state_65242;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65242__$1,(6),inst_65218);
} else {
if((state_val_65243 === (3))){
var inst_65240 = (state_65242[(2)]);
var state_65242__$1 = state_65242;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65242__$1,inst_65240);
} else {
if((state_val_65243 === (4))){
var inst_65212 = (state_65242[(2)]);
var state_65242__$1 = state_65242;
var statearr_65247_65263 = state_65242__$1;
(statearr_65247_65263[(2)] = inst_65212);

(statearr_65247_65263[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65243 === (5))){
var _ = (function (){var statearr_65248 = state_65242;
(statearr_65248[(4)] = cljs.core.rest.call(null,(state_65242[(4)])));

return statearr_65248;
})();
var state_65242__$1 = state_65242;
var ex65246 = (state_65242__$1[(2)]);
var statearr_65249_65264 = state_65242__$1;
(statearr_65249_65264[(5)] = ex65246);


if((ex65246 instanceof Error)){
var statearr_65250_65265 = state_65242__$1;
(statearr_65250_65265[(1)] = (4));

(statearr_65250_65265[(5)] = null);

} else {
throw ex65246;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65243 === (6))){
var inst_65220 = (state_65242[(2)]);
var inst_65221 = fluree.db.util.async.throw_err.call(null,inst_65220);
var inst_65222 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.min,inst_65221);
var inst_65223 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65224 = [inst_65221];
var inst_65225 = (new cljs.core.PersistentVector(null,1,(5),inst_65223,inst_65224,null));
var inst_65226 = cljs.core.count.call(null,inst_65225);
var inst_65227 = ((9) + inst_65226);
var inst_65228 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65229 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65230 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65231 = [inst_65221];
var inst_65232 = (new cljs.core.PersistentVector(null,1,(5),inst_65230,inst_65231,null));
var inst_65233 = ["min",inst_65232,inst_65222];
var inst_65234 = cljs.core.PersistentHashMap.fromArrays(inst_65229,inst_65233);
var inst_65235 = [inst_65234,inst_65227];
var inst_65236 = (new cljs.core.PersistentVector(null,2,(5),inst_65228,inst_65235,null));
var inst_65237 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65236);
var _ = (function (){var statearr_65251 = state_65242;
(statearr_65251[(4)] = cljs.core.rest.call(null,(state_65242[(4)])));

return statearr_65251;
})();
var state_65242__$1 = (function (){var statearr_65252 = state_65242;
(statearr_65252[(7)] = inst_65237);

return statearr_65252;
})();
var statearr_65253_65266 = state_65242__$1;
(statearr_65253_65266[(2)] = inst_65222);

(statearr_65253_65266[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10903__auto____0 = (function (){
var statearr_65254 = [null,null,null,null,null,null,null,null];
(statearr_65254[(0)] = fluree$db$dbfunctions$fns$state_machine__10903__auto__);

(statearr_65254[(1)] = (1));

return statearr_65254;
});
var fluree$db$dbfunctions$fns$state_machine__10903__auto____1 = (function (state_65242){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_65242);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e65255){var ex__10906__auto__ = e65255;
var statearr_65256_65267 = state_65242;
(statearr_65256_65267[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_65242[(4)]))){
var statearr_65257_65268 = state_65242;
(statearr_65257_65268[(1)] = cljs.core.first.call(null,(state_65242[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65269 = state_65242;
state_65242 = G__65269;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10903__auto__ = function(state_65242){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____1.call(this,state_65242);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_65258 = f__10977__auto__.call(null);
(statearr_65258[(6)] = c__10976__auto__);

return statearr_65258;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq65210){
var G__65211 = cljs.core.first.call(null,seq65210);
var seq65210__$1 = cljs.core.next.call(null,seq65210);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65211,seq65210__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__65271 = arguments.length;
switch (G__65271) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_65316){
var state_val_65317 = (state_65316[(1)]);
if((state_val_65317 === (7))){
var state_65316__$1 = state_65316;
var statearr_65318_65455 = state_65316__$1;
(statearr_65318_65455[(2)] = query_map);

(statearr_65318_65455[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65317 === (1))){
var state_65316__$1 = state_65316;
var statearr_65319_65456 = state_65316__$1;
(statearr_65319_65456[(2)] = null);

(statearr_65319_65456[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65317 === (4))){
var inst_65272 = (state_65316[(2)]);
var state_65316__$1 = state_65316;
var statearr_65320_65457 = state_65316__$1;
(statearr_65320_65457[(2)] = inst_65272);

(statearr_65320_65457[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65317 === (13))){
var inst_65294 = (state_65316[(7)]);
var inst_65298 = (state_65316[(2)]);
var inst_65299 = fluree.db.util.async.throw_err.call(null,inst_65298);
var inst_65300 = cljs.core.nth.call(null,inst_65299,(0),null);
var inst_65301 = cljs.core.nth.call(null,inst_65299,(1),null);
var inst_65302 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65303 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65304 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65305 = [inst_65294];
var inst_65306 = (new cljs.core.PersistentVector(null,1,(5),inst_65304,inst_65305,null));
var inst_65307 = ["query",inst_65306,inst_65300];
var inst_65308 = cljs.core.PersistentHashMap.fromArrays(inst_65303,inst_65307);
var inst_65309 = [inst_65308,inst_65301];
var inst_65310 = (new cljs.core.PersistentVector(null,2,(5),inst_65302,inst_65309,null));
var inst_65311 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65310);
var _ = (function (){var statearr_65321 = state_65316;
(statearr_65321[(4)] = cljs.core.rest.call(null,(state_65316[(4)])));

return statearr_65321;
})();
var state_65316__$1 = (function (){var statearr_65322 = state_65316;
(statearr_65322[(8)] = inst_65311);

return statearr_65322;
})();
var statearr_65323_65458 = state_65316__$1;
(statearr_65323_65458[(2)] = inst_65300);

(statearr_65323_65458[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65317 === (6))){
var state_65316__$1 = state_65316;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65316__$1,(9),query_map);
} else {
if((state_val_65317 === (3))){
var inst_65314 = (state_65316[(2)]);
var state_65316__$1 = state_65316;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65316__$1,inst_65314);
} else {
if((state_val_65317 === (12))){
var inst_65294 = (state_65316[(7)]);
var inst_65294__$1 = (state_65316[(2)]);
var inst_65295 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_65296 = fluree.db.dbfunctions.internal.query.call(null,inst_65295,inst_65294__$1);
var state_65316__$1 = (function (){var statearr_65324 = state_65316;
(statearr_65324[(7)] = inst_65294__$1);

return statearr_65324;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65316__$1,(13),inst_65296);
} else {
if((state_val_65317 === (2))){
var _ = (function (){var statearr_65325 = state_65316;
(statearr_65325[(4)] = cljs.core.cons.call(null,(5),(state_65316[(4)])));

return statearr_65325;
})();
var inst_65281 = fluree.db.util.async.channel_QMARK_.call(null,query_map);
var state_65316__$1 = state_65316;
if(inst_65281){
var statearr_65326_65459 = state_65316__$1;
(statearr_65326_65459[(1)] = (6));

} else {
var statearr_65327_65460 = state_65316__$1;
(statearr_65327_65460[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65317 === (11))){
var inst_65288 = (state_65316[(9)]);
var state_65316__$1 = state_65316;
var statearr_65329_65461 = state_65316__$1;
(statearr_65329_65461[(2)] = inst_65288);

(statearr_65329_65461[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65317 === (9))){
var inst_65284 = (state_65316[(2)]);
var inst_65285 = fluree.db.util.async.throw_err.call(null,inst_65284);
var state_65316__$1 = state_65316;
var statearr_65330_65462 = state_65316__$1;
(statearr_65330_65462[(2)] = inst_65285);

(statearr_65330_65462[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65317 === (5))){
var _ = (function (){var statearr_65331 = state_65316;
(statearr_65331[(4)] = cljs.core.rest.call(null,(state_65316[(4)])));

return statearr_65331;
})();
var state_65316__$1 = state_65316;
var ex65328 = (state_65316__$1[(2)]);
var statearr_65332_65463 = state_65316__$1;
(statearr_65332_65463[(5)] = ex65328);


if((ex65328 instanceof Error)){
var statearr_65333_65464 = state_65316__$1;
(statearr_65333_65464[(1)] = (4));

(statearr_65333_65464[(5)] = null);

} else {
throw ex65328;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65317 === (10))){
var inst_65288 = (state_65316[(9)]);
var inst_65291 = fluree.db.util.json.parse.call(null,inst_65288);
var state_65316__$1 = state_65316;
var statearr_65334_65465 = state_65316__$1;
(statearr_65334_65465[(2)] = inst_65291);

(statearr_65334_65465[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65317 === (8))){
var inst_65288 = (state_65316[(9)]);
var inst_65288__$1 = (state_65316[(2)]);
var inst_65289 = typeof inst_65288__$1 === 'string';
var state_65316__$1 = (function (){var statearr_65335 = state_65316;
(statearr_65335[(9)] = inst_65288__$1);

return statearr_65335;
})();
if(cljs.core.truth_(inst_65289)){
var statearr_65336_65466 = state_65316__$1;
(statearr_65336_65466[(1)] = (10));

} else {
var statearr_65337_65467 = state_65316__$1;
(statearr_65337_65467[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10903__auto____0 = (function (){
var statearr_65338 = [null,null,null,null,null,null,null,null,null,null];
(statearr_65338[(0)] = fluree$db$dbfunctions$fns$state_machine__10903__auto__);

(statearr_65338[(1)] = (1));

return statearr_65338;
});
var fluree$db$dbfunctions$fns$state_machine__10903__auto____1 = (function (state_65316){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_65316);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e65339){var ex__10906__auto__ = e65339;
var statearr_65340_65468 = state_65316;
(statearr_65340_65468[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_65316[(4)]))){
var statearr_65341_65469 = state_65316;
(statearr_65341_65469[(1)] = cljs.core.first.call(null,(state_65316[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65470 = state_65316;
state_65316 = G__65470;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10903__auto__ = function(state_65316){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____1.call(this,state_65316);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_65342 = f__10977__auto__.call(null);
(statearr_65342[(6)] = c__10976__auto__);

return statearr_65342;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_65413){
var state_val_65414 = (state_65413[(1)]);
if((state_val_65414 === (7))){
var state_65413__$1 = state_65413;
var statearr_65415_65471 = state_65413__$1;
(statearr_65415_65471[(2)] = select);

(statearr_65415_65471[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65414 === (20))){
var inst_65383 = (state_65413[(2)]);
var inst_65384 = fluree.db.util.async.channel_QMARK_.call(null,limit);
var state_65413__$1 = (function (){var statearr_65416 = state_65413;
(statearr_65416[(7)] = inst_65383);

return statearr_65416;
})();
if(inst_65384){
var statearr_65417_65472 = state_65413__$1;
(statearr_65417_65472[(1)] = (22));

} else {
var statearr_65418_65473 = state_65413__$1;
(statearr_65418_65473[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65414 === (1))){
var state_65413__$1 = state_65413;
var statearr_65419_65474 = state_65413__$1;
(statearr_65419_65474[(2)] = null);

(statearr_65419_65474[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65414 === (24))){
var inst_65383 = (state_65413[(7)]);
var inst_65375 = (state_65413[(8)]);
var inst_65359 = (state_65413[(9)]);
var inst_65367 = (state_65413[(10)]);
var inst_65391 = (state_65413[(2)]);
var inst_65392 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_65393 = fluree.db.dbfunctions.internal.query.call(null,inst_65392,inst_65359,inst_65367,inst_65375,inst_65383,inst_65391);
var state_65413__$1 = state_65413;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65413__$1,(26),inst_65393);
} else {
if((state_val_65414 === (4))){
var inst_65343 = (state_65413[(2)]);
var state_65413__$1 = state_65413;
var statearr_65420_65475 = state_65413__$1;
(statearr_65420_65475[(2)] = inst_65343);

(statearr_65420_65475[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65414 === (15))){
var state_65413__$1 = state_65413;
var statearr_65421_65476 = state_65413__$1;
(statearr_65421_65476[(2)] = where);

(statearr_65421_65476[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65414 === (21))){
var inst_65379 = (state_65413[(2)]);
var inst_65380 = fluree.db.util.async.throw_err.call(null,inst_65379);
var state_65413__$1 = state_65413;
var statearr_65422_65477 = state_65413__$1;
(statearr_65422_65477[(2)] = inst_65380);

(statearr_65422_65477[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65414 === (13))){
var inst_65363 = (state_65413[(2)]);
var inst_65364 = fluree.db.util.async.throw_err.call(null,inst_65363);
var state_65413__$1 = state_65413;
var statearr_65423_65478 = state_65413__$1;
(statearr_65423_65478[(2)] = inst_65364);

(statearr_65423_65478[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65414 === (22))){
var state_65413__$1 = state_65413;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65413__$1,(25),limit);
} else {
if((state_val_65414 === (6))){
var state_65413__$1 = state_65413;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65413__$1,(9),select);
} else {
if((state_val_65414 === (25))){
var inst_65387 = (state_65413[(2)]);
var inst_65388 = fluree.db.util.async.throw_err.call(null,inst_65387);
var state_65413__$1 = state_65413;
var statearr_65424_65479 = state_65413__$1;
(statearr_65424_65479[(2)] = inst_65388);

(statearr_65424_65479[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65414 === (17))){
var inst_65371 = (state_65413[(2)]);
var inst_65372 = fluree.db.util.async.throw_err.call(null,inst_65371);
var state_65413__$1 = state_65413;
var statearr_65425_65480 = state_65413__$1;
(statearr_65425_65480[(2)] = inst_65372);

(statearr_65425_65480[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65414 === (3))){
var inst_65411 = (state_65413[(2)]);
var state_65413__$1 = state_65413;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65413__$1,inst_65411);
} else {
if((state_val_65414 === (12))){
var inst_65367 = (state_65413[(2)]);
var inst_65368 = fluree.db.util.async.channel_QMARK_.call(null,where);
var state_65413__$1 = (function (){var statearr_65426 = state_65413;
(statearr_65426[(10)] = inst_65367);

return statearr_65426;
})();
if(inst_65368){
var statearr_65427_65481 = state_65413__$1;
(statearr_65427_65481[(1)] = (14));

} else {
var statearr_65428_65482 = state_65413__$1;
(statearr_65428_65482[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65414 === (2))){
var _ = (function (){var statearr_65429 = state_65413;
(statearr_65429[(4)] = cljs.core.cons.call(null,(5),(state_65413[(4)])));

return statearr_65429;
})();
var inst_65352 = fluree.db.util.async.channel_QMARK_.call(null,select);
var state_65413__$1 = state_65413;
if(inst_65352){
var statearr_65430_65483 = state_65413__$1;
(statearr_65430_65483[(1)] = (6));

} else {
var statearr_65431_65484 = state_65413__$1;
(statearr_65431_65484[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65414 === (23))){
var state_65413__$1 = state_65413;
var statearr_65432_65485 = state_65413__$1;
(statearr_65432_65485[(2)] = limit);

(statearr_65432_65485[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65414 === (19))){
var state_65413__$1 = state_65413;
var statearr_65433_65486 = state_65413__$1;
(statearr_65433_65486[(2)] = block);

(statearr_65433_65486[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65414 === (11))){
var state_65413__$1 = state_65413;
var statearr_65435_65487 = state_65413__$1;
(statearr_65435_65487[(2)] = from);

(statearr_65435_65487[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65414 === (9))){
var inst_65355 = (state_65413[(2)]);
var inst_65356 = fluree.db.util.async.throw_err.call(null,inst_65355);
var state_65413__$1 = state_65413;
var statearr_65436_65488 = state_65413__$1;
(statearr_65436_65488[(2)] = inst_65356);

(statearr_65436_65488[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65414 === (5))){
var _ = (function (){var statearr_65437 = state_65413;
(statearr_65437[(4)] = cljs.core.rest.call(null,(state_65413[(4)])));

return statearr_65437;
})();
var state_65413__$1 = state_65413;
var ex65434 = (state_65413__$1[(2)]);
var statearr_65438_65489 = state_65413__$1;
(statearr_65438_65489[(5)] = ex65434);


if((ex65434 instanceof Error)){
var statearr_65439_65490 = state_65413__$1;
(statearr_65439_65490[(1)] = (4));

(statearr_65439_65490[(5)] = null);

} else {
throw ex65434;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65414 === (14))){
var state_65413__$1 = state_65413;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65413__$1,(17),where);
} else {
if((state_val_65414 === (26))){
var inst_65383 = (state_65413[(7)]);
var inst_65375 = (state_65413[(8)]);
var inst_65359 = (state_65413[(9)]);
var inst_65367 = (state_65413[(10)]);
var inst_65395 = (state_65413[(2)]);
var inst_65396 = fluree.db.util.async.throw_err.call(null,inst_65395);
var inst_65397 = cljs.core.nth.call(null,inst_65396,(0),null);
var inst_65398 = cljs.core.nth.call(null,inst_65396,(1),null);
var inst_65399 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65400 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65401 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65402 = [inst_65359,inst_65367,inst_65375,inst_65383];
var inst_65403 = (new cljs.core.PersistentVector(null,4,(5),inst_65401,inst_65402,null));
var inst_65404 = ["query",inst_65403,inst_65397];
var inst_65405 = cljs.core.PersistentHashMap.fromArrays(inst_65400,inst_65404);
var inst_65406 = [inst_65405,inst_65398];
var inst_65407 = (new cljs.core.PersistentVector(null,2,(5),inst_65399,inst_65406,null));
var inst_65408 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65407);
var _ = (function (){var statearr_65440 = state_65413;
(statearr_65440[(4)] = cljs.core.rest.call(null,(state_65413[(4)])));

return statearr_65440;
})();
var state_65413__$1 = (function (){var statearr_65441 = state_65413;
(statearr_65441[(11)] = inst_65408);

return statearr_65441;
})();
var statearr_65442_65491 = state_65413__$1;
(statearr_65442_65491[(2)] = inst_65397);

(statearr_65442_65491[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65414 === (16))){
var inst_65375 = (state_65413[(2)]);
var inst_65376 = fluree.db.util.async.channel_QMARK_.call(null,block);
var state_65413__$1 = (function (){var statearr_65443 = state_65413;
(statearr_65443[(8)] = inst_65375);

return statearr_65443;
})();
if(inst_65376){
var statearr_65444_65492 = state_65413__$1;
(statearr_65444_65492[(1)] = (18));

} else {
var statearr_65445_65493 = state_65413__$1;
(statearr_65445_65493[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65414 === (10))){
var state_65413__$1 = state_65413;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65413__$1,(13),from);
} else {
if((state_val_65414 === (18))){
var state_65413__$1 = state_65413;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65413__$1,(21),block);
} else {
if((state_val_65414 === (8))){
var inst_65359 = (state_65413[(2)]);
var inst_65360 = fluree.db.util.async.channel_QMARK_.call(null,from);
var state_65413__$1 = (function (){var statearr_65446 = state_65413;
(statearr_65446[(9)] = inst_65359);

return statearr_65446;
})();
if(inst_65360){
var statearr_65447_65494 = state_65413__$1;
(statearr_65447_65494[(1)] = (10));

} else {
var statearr_65448_65495 = state_65413__$1;
(statearr_65448_65495[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10903__auto____0 = (function (){
var statearr_65449 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65449[(0)] = fluree$db$dbfunctions$fns$state_machine__10903__auto__);

(statearr_65449[(1)] = (1));

return statearr_65449;
});
var fluree$db$dbfunctions$fns$state_machine__10903__auto____1 = (function (state_65413){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_65413);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e65450){var ex__10906__auto__ = e65450;
var statearr_65451_65496 = state_65413;
(statearr_65451_65496[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_65413[(4)]))){
var statearr_65452_65497 = state_65413;
(statearr_65452_65497[(1)] = cljs.core.first.call(null,(state_65413[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65498 = state_65413;
state_65413 = G__65498;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10903__auto__ = function(state_65413){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____1.call(this,state_65413);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_65453 = f__10977__auto__.call(null);
(statearr_65453[(6)] = c__10976__auto__);

return statearr_65453;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_65554){
var state_val_65555 = (state_65554[(1)]);
if((state_val_65555 === (7))){
var state_65554__$1 = state_65554;
var statearr_65556_65587 = state_65554__$1;
(statearr_65556_65587[(2)] = startSubject);

(statearr_65556_65587[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65555 === (1))){
var state_65554__$1 = state_65554;
var statearr_65557_65588 = state_65554__$1;
(statearr_65557_65588[(2)] = null);

(statearr_65557_65588[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65555 === (4))){
var inst_65499 = (state_65554[(2)]);
var state_65554__$1 = state_65554;
var statearr_65558_65589 = state_65554__$1;
(statearr_65558_65589[(2)] = inst_65499);

(statearr_65558_65589[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65555 === (15))){
var inst_65531 = (state_65554[(2)]);
var inst_65532 = fluree.db.util.async.throw_err.call(null,inst_65531);
var inst_65533 = cljs.core.nth.call(null,inst_65532,(0),null);
var inst_65534 = cljs.core.nth.call(null,inst_65532,(1),null);
var inst_65535 = cljs.core.empty_QMARK_.call(null,inst_65533);
var state_65554__$1 = (function (){var statearr_65559 = state_65554;
(statearr_65559[(7)] = inst_65534);

return statearr_65559;
})();
if(inst_65535){
var statearr_65560_65590 = state_65554__$1;
(statearr_65560_65590[(1)] = (16));

} else {
var statearr_65561_65591 = state_65554__$1;
(statearr_65561_65591[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65555 === (13))){
var inst_65519 = (state_65554[(8)]);
var inst_65527 = (state_65554[(9)]);
var inst_65515 = (state_65554[(10)]);
var inst_65527__$1 = (state_65554[(2)]);
var inst_65528 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_65529 = fluree.db.dbfunctions.internal.relationship_QMARK_.call(null,inst_65528,inst_65515,inst_65519,inst_65527__$1);
var state_65554__$1 = (function (){var statearr_65562 = state_65554;
(statearr_65562[(9)] = inst_65527__$1);

return statearr_65562;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65554__$1,(15),inst_65529);
} else {
if((state_val_65555 === (6))){
var state_65554__$1 = state_65554;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65554__$1,(9),startSubject);
} else {
if((state_val_65555 === (17))){
var state_65554__$1 = state_65554;
var statearr_65563_65592 = state_65554__$1;
(statearr_65563_65592[(2)] = true);

(statearr_65563_65592[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65555 === (3))){
var inst_65552 = (state_65554[(2)]);
var state_65554__$1 = state_65554;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65554__$1,inst_65552);
} else {
if((state_val_65555 === (12))){
var state_65554__$1 = state_65554;
var statearr_65564_65593 = state_65554__$1;
(statearr_65564_65593[(2)] = endSubject);

(statearr_65564_65593[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65555 === (2))){
var _ = (function (){var statearr_65565 = state_65554;
(statearr_65565[(4)] = cljs.core.cons.call(null,(5),(state_65554[(4)])));

return statearr_65565;
})();
var inst_65508 = fluree.db.util.async.channel_QMARK_.call(null,startSubject);
var state_65554__$1 = state_65554;
if(inst_65508){
var statearr_65566_65594 = state_65554__$1;
(statearr_65566_65594[(1)] = (6));

} else {
var statearr_65567_65595 = state_65554__$1;
(statearr_65567_65595[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65555 === (11))){
var state_65554__$1 = state_65554;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65554__$1,(14),endSubject);
} else {
if((state_val_65555 === (9))){
var inst_65511 = (state_65554[(2)]);
var inst_65512 = fluree.db.util.async.throw_err.call(null,inst_65511);
var state_65554__$1 = state_65554;
var statearr_65569_65596 = state_65554__$1;
(statearr_65569_65596[(2)] = inst_65512);

(statearr_65569_65596[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65555 === (5))){
var _ = (function (){var statearr_65570 = state_65554;
(statearr_65570[(4)] = cljs.core.rest.call(null,(state_65554[(4)])));

return statearr_65570;
})();
var state_65554__$1 = state_65554;
var ex65568 = (state_65554__$1[(2)]);
var statearr_65571_65597 = state_65554__$1;
(statearr_65571_65597[(5)] = ex65568);


if((ex65568 instanceof Error)){
var statearr_65572_65598 = state_65554__$1;
(statearr_65572_65598[(1)] = (4));

(statearr_65572_65598[(5)] = null);

} else {
throw ex65568;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65555 === (14))){
var inst_65523 = (state_65554[(2)]);
var inst_65524 = fluree.db.util.async.throw_err.call(null,inst_65523);
var state_65554__$1 = state_65554;
var statearr_65573_65599 = state_65554__$1;
(statearr_65573_65599[(2)] = inst_65524);

(statearr_65573_65599[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65555 === (16))){
var state_65554__$1 = state_65554;
var statearr_65574_65600 = state_65554__$1;
(statearr_65574_65600[(2)] = false);

(statearr_65574_65600[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65555 === (10))){
var inst_65518 = (state_65554[(2)]);
var inst_65519 = fluree.db.util.async.throw_err.call(null,inst_65518);
var inst_65520 = fluree.db.util.async.channel_QMARK_.call(null,endSubject);
var state_65554__$1 = (function (){var statearr_65575 = state_65554;
(statearr_65575[(8)] = inst_65519);

return statearr_65575;
})();
if(inst_65520){
var statearr_65576_65601 = state_65554__$1;
(statearr_65576_65601[(1)] = (11));

} else {
var statearr_65577_65602 = state_65554__$1;
(statearr_65577_65602[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65555 === (18))){
var inst_65519 = (state_65554[(8)]);
var inst_65527 = (state_65554[(9)]);
var inst_65534 = (state_65554[(7)]);
var inst_65515 = (state_65554[(10)]);
var inst_65539 = (state_65554[(2)]);
var inst_65540 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65541 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65542 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65543 = [inst_65515,inst_65519,inst_65527];
var inst_65544 = (new cljs.core.PersistentVector(null,3,(5),inst_65542,inst_65543,null));
var inst_65545 = ["relationship?",inst_65544,inst_65539];
var inst_65546 = cljs.core.PersistentHashMap.fromArrays(inst_65541,inst_65545);
var inst_65547 = [inst_65546,inst_65534];
var inst_65548 = (new cljs.core.PersistentVector(null,2,(5),inst_65540,inst_65547,null));
var inst_65549 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65548);
var _ = (function (){var statearr_65578 = state_65554;
(statearr_65578[(4)] = cljs.core.rest.call(null,(state_65554[(4)])));

return statearr_65578;
})();
var state_65554__$1 = (function (){var statearr_65579 = state_65554;
(statearr_65579[(11)] = inst_65549);

return statearr_65579;
})();
var statearr_65580_65603 = state_65554__$1;
(statearr_65580_65603[(2)] = inst_65539);

(statearr_65580_65603[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65555 === (8))){
var inst_65515 = (state_65554[(2)]);
var inst_65516 = fluree.db.dbfunctions.fns.coerce_args.call(null,path);
var state_65554__$1 = (function (){var statearr_65581 = state_65554;
(statearr_65581[(10)] = inst_65515);

return statearr_65581;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65554__$1,(10),inst_65516);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10903__auto____0 = (function (){
var statearr_65582 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65582[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10903__auto__);

(statearr_65582[(1)] = (1));

return statearr_65582;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10903__auto____1 = (function (state_65554){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_65554);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e65583){var ex__10906__auto__ = e65583;
var statearr_65584_65604 = state_65554;
(statearr_65584_65604[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_65554[(4)]))){
var statearr_65585_65605 = state_65554;
(statearr_65585_65605[(1)] = cljs.core.first.call(null,(state_65554[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65606 = state_65554;
state_65554 = G__65606;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10903__auto__ = function(state_65554){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10903__auto____1.call(this,state_65554);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_65586 = f__10977__auto__.call(null);
(statearr_65586[(6)] = c__10976__auto__);

return statearr_65586;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_65643){
var state_val_65644 = (state_65643[(1)]);
if((state_val_65644 === (7))){
var state_65643__$1 = state_65643;
var statearr_65645_65665 = state_65643__$1;
(statearr_65645_65665[(2)] = pred_name);

(statearr_65645_65665[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65644 === (1))){
var state_65643__$1 = state_65643;
var statearr_65646_65666 = state_65643__$1;
(statearr_65646_65666[(2)] = null);

(statearr_65646_65666[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65644 === (4))){
var inst_65607 = (state_65643[(2)]);
var state_65643__$1 = state_65643;
var statearr_65647_65667 = state_65643__$1;
(statearr_65647_65667[(2)] = inst_65607);

(statearr_65647_65667[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65644 === (6))){
var state_65643__$1 = state_65643;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65643__$1,(9),pred_name);
} else {
if((state_val_65644 === (3))){
var inst_65641 = (state_65643[(2)]);
var state_65643__$1 = state_65643;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65643__$1,inst_65641);
} else {
if((state_val_65644 === (2))){
var _ = (function (){var statearr_65649 = state_65643;
(statearr_65649[(4)] = cljs.core.cons.call(null,(5),(state_65643[(4)])));

return statearr_65649;
})();
var inst_65616 = fluree.db.util.async.channel_QMARK_.call(null,pred_name);
var state_65643__$1 = state_65643;
if(inst_65616){
var statearr_65650_65668 = state_65643__$1;
(statearr_65650_65668[(1)] = (6));

} else {
var statearr_65651_65669 = state_65643__$1;
(statearr_65651_65669[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65644 === (9))){
var inst_65619 = (state_65643[(2)]);
var inst_65620 = fluree.db.util.async.throw_err.call(null,inst_65619);
var state_65643__$1 = state_65643;
var statearr_65652_65670 = state_65643__$1;
(statearr_65652_65670[(2)] = inst_65620);

(statearr_65652_65670[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65644 === (5))){
var _ = (function (){var statearr_65653 = state_65643;
(statearr_65653[(4)] = cljs.core.rest.call(null,(state_65643[(4)])));

return statearr_65653;
})();
var state_65643__$1 = state_65643;
var ex65648 = (state_65643__$1[(2)]);
var statearr_65654_65671 = state_65643__$1;
(statearr_65654_65671[(5)] = ex65648);


if((ex65648 instanceof Error)){
var statearr_65655_65672 = state_65643__$1;
(statearr_65655_65672[(1)] = (4));

(statearr_65655_65672[(5)] = null);

} else {
throw ex65648;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65644 === (10))){
var inst_65623 = (state_65643[(7)]);
var inst_65627 = (state_65643[(2)]);
var inst_65628 = fluree.db.util.async.throw_err.call(null,inst_65627);
var inst_65629 = cljs.core.nth.call(null,inst_65628,(0),null);
var inst_65630 = cljs.core.nth.call(null,inst_65628,(1),null);
var inst_65631 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65632 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65633 = ["max-pred-val",inst_65623,inst_65629];
var inst_65634 = cljs.core.PersistentHashMap.fromArrays(inst_65632,inst_65633);
var inst_65635 = (inst_65630 + (10));
var inst_65636 = [inst_65634,inst_65635];
var inst_65637 = (new cljs.core.PersistentVector(null,2,(5),inst_65631,inst_65636,null));
var inst_65638 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65637);
var _ = (function (){var statearr_65656 = state_65643;
(statearr_65656[(4)] = cljs.core.rest.call(null,(state_65643[(4)])));

return statearr_65656;
})();
var state_65643__$1 = (function (){var statearr_65657 = state_65643;
(statearr_65657[(8)] = inst_65638);

return statearr_65657;
})();
var statearr_65658_65673 = state_65643__$1;
(statearr_65658_65673[(2)] = inst_65629);

(statearr_65658_65673[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65644 === (8))){
var inst_65623 = (state_65643[(7)]);
var inst_65623__$1 = (state_65643[(2)]);
var inst_65624 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_65625 = fluree.db.dbfunctions.internal.max_pred_val.call(null,inst_65624,inst_65623__$1,null);
var state_65643__$1 = (function (){var statearr_65659 = state_65643;
(statearr_65659[(7)] = inst_65623__$1);

return statearr_65659;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65643__$1,(10),inst_65625);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10903__auto____0 = (function (){
var statearr_65660 = [null,null,null,null,null,null,null,null,null];
(statearr_65660[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10903__auto__);

(statearr_65660[(1)] = (1));

return statearr_65660;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10903__auto____1 = (function (state_65643){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_65643);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e65661){var ex__10906__auto__ = e65661;
var statearr_65662_65674 = state_65643;
(statearr_65662_65674[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_65643[(4)]))){
var statearr_65663_65675 = state_65643;
(statearr_65663_65675[(1)] = cljs.core.first.call(null,(state_65643[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65676 = state_65643;
state_65643 = G__65676;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10903__auto__ = function(state_65643){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10903__auto____1.call(this,state_65643);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_65664 = f__10977__auto__.call(null);
(statearr_65664[(6)] = c__10976__auto__);

return statearr_65664;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_65703){
var state_val_65704 = (state_65703[(1)]);
if((state_val_65704 === (7))){
var state_65703__$1 = state_65703;
var statearr_65705_65724 = state_65703__$1;
(statearr_65705_65724[(2)] = n);

(statearr_65705_65724[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65704 === (1))){
var state_65703__$1 = state_65703;
var statearr_65706_65725 = state_65703__$1;
(statearr_65706_65725[(2)] = null);

(statearr_65706_65725[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65704 === (4))){
var inst_65677 = (state_65703[(2)]);
var state_65703__$1 = state_65703;
var statearr_65707_65726 = state_65703__$1;
(statearr_65707_65726[(2)] = inst_65677);

(statearr_65707_65726[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65704 === (6))){
var state_65703__$1 = state_65703;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65703__$1,(9),n);
} else {
if((state_val_65704 === (3))){
var inst_65701 = (state_65703[(2)]);
var state_65703__$1 = state_65703;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65703__$1,inst_65701);
} else {
if((state_val_65704 === (2))){
var _ = (function (){var statearr_65709 = state_65703;
(statearr_65709[(4)] = cljs.core.cons.call(null,(5),(state_65703[(4)])));

return statearr_65709;
})();
var inst_65683 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_65703__$1 = state_65703;
if(inst_65683){
var statearr_65710_65727 = state_65703__$1;
(statearr_65710_65727[(1)] = (6));

} else {
var statearr_65711_65728 = state_65703__$1;
(statearr_65711_65728[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65704 === (9))){
var inst_65686 = (state_65703[(2)]);
var inst_65687 = fluree.db.util.async.throw_err.call(null,inst_65686);
var state_65703__$1 = state_65703;
var statearr_65712_65729 = state_65703__$1;
(statearr_65712_65729[(2)] = inst_65687);

(statearr_65712_65729[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65704 === (5))){
var _ = (function (){var statearr_65713 = state_65703;
(statearr_65713[(4)] = cljs.core.rest.call(null,(state_65703[(4)])));

return statearr_65713;
})();
var state_65703__$1 = state_65703;
var ex65708 = (state_65703__$1[(2)]);
var statearr_65714_65730 = state_65703__$1;
(statearr_65714_65730[(5)] = ex65708);


if((ex65708 instanceof Error)){
var statearr_65715_65731 = state_65703__$1;
(statearr_65715_65731[(1)] = (4));

(statearr_65715_65731[(5)] = null);

} else {
throw ex65708;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65704 === (8))){
var inst_65690 = (state_65703[(2)]);
var inst_65691 = fluree.db.dbfunctions.internal.inc.call(null,inst_65690);
var inst_65692 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65693 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65694 = ["inc",inst_65690,inst_65691];
var inst_65695 = cljs.core.PersistentHashMap.fromArrays(inst_65693,inst_65694);
var inst_65696 = [inst_65695,(10)];
var inst_65697 = (new cljs.core.PersistentVector(null,2,(5),inst_65692,inst_65696,null));
var inst_65698 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65697);
var _ = (function (){var statearr_65716 = state_65703;
(statearr_65716[(4)] = cljs.core.rest.call(null,(state_65703[(4)])));

return statearr_65716;
})();
var state_65703__$1 = (function (){var statearr_65717 = state_65703;
(statearr_65717[(7)] = inst_65698);

return statearr_65717;
})();
var statearr_65718_65732 = state_65703__$1;
(statearr_65718_65732[(2)] = inst_65691);

(statearr_65718_65732[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__10903__auto____0 = (function (){
var statearr_65719 = [null,null,null,null,null,null,null,null];
(statearr_65719[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__10903__auto__);

(statearr_65719[(1)] = (1));

return statearr_65719;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__10903__auto____1 = (function (state_65703){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_65703);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e65720){var ex__10906__auto__ = e65720;
var statearr_65721_65733 = state_65703;
(statearr_65721_65733[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_65703[(4)]))){
var statearr_65722_65734 = state_65703;
(statearr_65722_65734[(1)] = cljs.core.first.call(null,(state_65703[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65735 = state_65703;
state_65703 = G__65735;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__10903__auto__ = function(state_65703){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__10903__auto____1.call(this,state_65703);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_65723 = f__10977__auto__.call(null);
(statearr_65723[(6)] = c__10976__auto__);

return statearr_65723;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_65762){
var state_val_65763 = (state_65762[(1)]);
if((state_val_65763 === (7))){
var state_65762__$1 = state_65762;
var statearr_65764_65783 = state_65762__$1;
(statearr_65764_65783[(2)] = n);

(statearr_65764_65783[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65763 === (1))){
var state_65762__$1 = state_65762;
var statearr_65765_65784 = state_65762__$1;
(statearr_65765_65784[(2)] = null);

(statearr_65765_65784[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65763 === (4))){
var inst_65736 = (state_65762[(2)]);
var state_65762__$1 = state_65762;
var statearr_65766_65785 = state_65762__$1;
(statearr_65766_65785[(2)] = inst_65736);

(statearr_65766_65785[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65763 === (6))){
var state_65762__$1 = state_65762;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65762__$1,(9),n);
} else {
if((state_val_65763 === (3))){
var inst_65760 = (state_65762[(2)]);
var state_65762__$1 = state_65762;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65762__$1,inst_65760);
} else {
if((state_val_65763 === (2))){
var _ = (function (){var statearr_65768 = state_65762;
(statearr_65768[(4)] = cljs.core.cons.call(null,(5),(state_65762[(4)])));

return statearr_65768;
})();
var inst_65742 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_65762__$1 = state_65762;
if(inst_65742){
var statearr_65769_65786 = state_65762__$1;
(statearr_65769_65786[(1)] = (6));

} else {
var statearr_65770_65787 = state_65762__$1;
(statearr_65770_65787[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65763 === (9))){
var inst_65745 = (state_65762[(2)]);
var inst_65746 = fluree.db.util.async.throw_err.call(null,inst_65745);
var state_65762__$1 = state_65762;
var statearr_65771_65788 = state_65762__$1;
(statearr_65771_65788[(2)] = inst_65746);

(statearr_65771_65788[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65763 === (5))){
var _ = (function (){var statearr_65772 = state_65762;
(statearr_65772[(4)] = cljs.core.rest.call(null,(state_65762[(4)])));

return statearr_65772;
})();
var state_65762__$1 = state_65762;
var ex65767 = (state_65762__$1[(2)]);
var statearr_65773_65789 = state_65762__$1;
(statearr_65773_65789[(5)] = ex65767);


if((ex65767 instanceof Error)){
var statearr_65774_65790 = state_65762__$1;
(statearr_65774_65790[(1)] = (4));

(statearr_65774_65790[(5)] = null);

} else {
throw ex65767;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65763 === (8))){
var inst_65749 = (state_65762[(2)]);
var inst_65750 = fluree.db.dbfunctions.internal.dec.call(null,inst_65749);
var inst_65751 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65752 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65753 = ["dec",inst_65749,inst_65750];
var inst_65754 = cljs.core.PersistentHashMap.fromArrays(inst_65752,inst_65753);
var inst_65755 = [inst_65754,(10)];
var inst_65756 = (new cljs.core.PersistentVector(null,2,(5),inst_65751,inst_65755,null));
var inst_65757 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65756);
var _ = (function (){var statearr_65775 = state_65762;
(statearr_65775[(4)] = cljs.core.rest.call(null,(state_65762[(4)])));

return statearr_65775;
})();
var state_65762__$1 = (function (){var statearr_65776 = state_65762;
(statearr_65776[(7)] = inst_65757);

return statearr_65776;
})();
var statearr_65777_65791 = state_65762__$1;
(statearr_65777_65791[(2)] = inst_65750);

(statearr_65777_65791[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__10903__auto____0 = (function (){
var statearr_65778 = [null,null,null,null,null,null,null,null];
(statearr_65778[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__10903__auto__);

(statearr_65778[(1)] = (1));

return statearr_65778;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__10903__auto____1 = (function (state_65762){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_65762);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e65779){var ex__10906__auto__ = e65779;
var statearr_65780_65792 = state_65762;
(statearr_65780_65792[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_65762[(4)]))){
var statearr_65781_65793 = state_65762;
(statearr_65781_65793[(1)] = cljs.core.first.call(null,(state_65762[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65794 = state_65762;
state_65762 = G__65794;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__10903__auto__ = function(state_65762){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__10903__auto____1.call(this,state_65762);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_65782 = f__10977__auto__.call(null);
(statearr_65782[(6)] = c__10976__auto__);

return statearr_65782;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___65844 = arguments.length;
var i__4865__auto___65845 = (0);
while(true){
if((i__4865__auto___65845 < len__4864__auto___65844)){
args__4870__auto__.push((arguments[i__4865__auto___65845]));

var G__65846 = (i__4865__auto___65845 + (1));
i__4865__auto___65845 = G__65846;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_65827){
var state_val_65828 = (state_65827[(1)]);
if((state_val_65828 === (1))){
var state_65827__$1 = state_65827;
var statearr_65829_65847 = state_65827__$1;
(statearr_65829_65847[(2)] = null);

(statearr_65829_65847[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65828 === (2))){
var _ = (function (){var statearr_65830 = state_65827;
(statearr_65830[(4)] = cljs.core.cons.call(null,(5),(state_65827[(4)])));

return statearr_65830;
})();
var inst_65803 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_65827__$1 = state_65827;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65827__$1,(6),inst_65803);
} else {
if((state_val_65828 === (3))){
var inst_65825 = (state_65827[(2)]);
var state_65827__$1 = state_65827;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65827__$1,inst_65825);
} else {
if((state_val_65828 === (4))){
var inst_65797 = (state_65827[(2)]);
var state_65827__$1 = state_65827;
var statearr_65832_65848 = state_65827__$1;
(statearr_65832_65848[(2)] = inst_65797);

(statearr_65832_65848[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65828 === (5))){
var _ = (function (){var statearr_65833 = state_65827;
(statearr_65833[(4)] = cljs.core.rest.call(null,(state_65827[(4)])));

return statearr_65833;
})();
var state_65827__$1 = state_65827;
var ex65831 = (state_65827__$1[(2)]);
var statearr_65834_65849 = state_65827__$1;
(statearr_65834_65849[(5)] = ex65831);


if((ex65831 instanceof Error)){
var statearr_65835_65850 = state_65827__$1;
(statearr_65835_65850[(1)] = (4));

(statearr_65835_65850[(5)] = null);

} else {
throw ex65831;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65828 === (6))){
var inst_65805 = (state_65827[(2)]);
var inst_65806 = fluree.db.util.async.throw_err.call(null,inst_65805);
var inst_65807 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._PLUS_,inst_65806);
var inst_65808 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65809 = [inst_65806];
var inst_65810 = (new cljs.core.PersistentVector(null,1,(5),inst_65808,inst_65809,null));
var inst_65811 = cljs.core.count.call(null,inst_65810);
var inst_65812 = ((9) + inst_65811);
var inst_65813 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65814 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65815 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65816 = [inst_65806];
var inst_65817 = (new cljs.core.PersistentVector(null,1,(5),inst_65815,inst_65816,null));
var inst_65818 = ["+",inst_65817,inst_65807];
var inst_65819 = cljs.core.PersistentHashMap.fromArrays(inst_65814,inst_65818);
var inst_65820 = [inst_65819,inst_65812];
var inst_65821 = (new cljs.core.PersistentVector(null,2,(5),inst_65813,inst_65820,null));
var inst_65822 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65821);
var _ = (function (){var statearr_65836 = state_65827;
(statearr_65836[(4)] = cljs.core.rest.call(null,(state_65827[(4)])));

return statearr_65836;
})();
var state_65827__$1 = (function (){var statearr_65837 = state_65827;
(statearr_65837[(7)] = inst_65822);

return statearr_65837;
})();
var statearr_65838_65851 = state_65827__$1;
(statearr_65838_65851[(2)] = inst_65807);

(statearr_65838_65851[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10903__auto____0 = (function (){
var statearr_65839 = [null,null,null,null,null,null,null,null];
(statearr_65839[(0)] = fluree$db$dbfunctions$fns$state_machine__10903__auto__);

(statearr_65839[(1)] = (1));

return statearr_65839;
});
var fluree$db$dbfunctions$fns$state_machine__10903__auto____1 = (function (state_65827){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_65827);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e65840){var ex__10906__auto__ = e65840;
var statearr_65841_65852 = state_65827;
(statearr_65841_65852[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_65827[(4)]))){
var statearr_65842_65853 = state_65827;
(statearr_65842_65853[(1)] = cljs.core.first.call(null,(state_65827[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65854 = state_65827;
state_65827 = G__65854;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10903__auto__ = function(state_65827){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____1.call(this,state_65827);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_65843 = f__10977__auto__.call(null);
(statearr_65843[(6)] = c__10976__auto__);

return statearr_65843;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq65795){
var G__65796 = cljs.core.first.call(null,seq65795);
var seq65795__$1 = cljs.core.next.call(null,seq65795);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65796,seq65795__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___65904 = arguments.length;
var i__4865__auto___65905 = (0);
while(true){
if((i__4865__auto___65905 < len__4864__auto___65904)){
args__4870__auto__.push((arguments[i__4865__auto___65905]));

var G__65906 = (i__4865__auto___65905 + (1));
i__4865__auto___65905 = G__65906;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_65887){
var state_val_65888 = (state_65887[(1)]);
if((state_val_65888 === (1))){
var state_65887__$1 = state_65887;
var statearr_65889_65907 = state_65887__$1;
(statearr_65889_65907[(2)] = null);

(statearr_65889_65907[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65888 === (2))){
var _ = (function (){var statearr_65890 = state_65887;
(statearr_65890[(4)] = cljs.core.cons.call(null,(5),(state_65887[(4)])));

return statearr_65890;
})();
var inst_65863 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_65887__$1 = state_65887;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65887__$1,(6),inst_65863);
} else {
if((state_val_65888 === (3))){
var inst_65885 = (state_65887[(2)]);
var state_65887__$1 = state_65887;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65887__$1,inst_65885);
} else {
if((state_val_65888 === (4))){
var inst_65857 = (state_65887[(2)]);
var state_65887__$1 = state_65887;
var statearr_65892_65908 = state_65887__$1;
(statearr_65892_65908[(2)] = inst_65857);

(statearr_65892_65908[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65888 === (5))){
var _ = (function (){var statearr_65893 = state_65887;
(statearr_65893[(4)] = cljs.core.rest.call(null,(state_65887[(4)])));

return statearr_65893;
})();
var state_65887__$1 = state_65887;
var ex65891 = (state_65887__$1[(2)]);
var statearr_65894_65909 = state_65887__$1;
(statearr_65894_65909[(5)] = ex65891);


if((ex65891 instanceof Error)){
var statearr_65895_65910 = state_65887__$1;
(statearr_65895_65910[(1)] = (4));

(statearr_65895_65910[(5)] = null);

} else {
throw ex65891;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65888 === (6))){
var inst_65865 = (state_65887[(2)]);
var inst_65866 = fluree.db.util.async.throw_err.call(null,inst_65865);
var inst_65867 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._,inst_65866);
var inst_65868 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65869 = [inst_65866];
var inst_65870 = (new cljs.core.PersistentVector(null,1,(5),inst_65868,inst_65869,null));
var inst_65871 = cljs.core.count.call(null,inst_65870);
var inst_65872 = ((9) + inst_65871);
var inst_65873 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65874 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65875 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65876 = [inst_65866];
var inst_65877 = (new cljs.core.PersistentVector(null,1,(5),inst_65875,inst_65876,null));
var inst_65878 = ["-",inst_65877,inst_65867];
var inst_65879 = cljs.core.PersistentHashMap.fromArrays(inst_65874,inst_65878);
var inst_65880 = [inst_65879,inst_65872];
var inst_65881 = (new cljs.core.PersistentVector(null,2,(5),inst_65873,inst_65880,null));
var inst_65882 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65881);
var _ = (function (){var statearr_65896 = state_65887;
(statearr_65896[(4)] = cljs.core.rest.call(null,(state_65887[(4)])));

return statearr_65896;
})();
var state_65887__$1 = (function (){var statearr_65897 = state_65887;
(statearr_65897[(7)] = inst_65882);

return statearr_65897;
})();
var statearr_65898_65911 = state_65887__$1;
(statearr_65898_65911[(2)] = inst_65867);

(statearr_65898_65911[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10903__auto____0 = (function (){
var statearr_65899 = [null,null,null,null,null,null,null,null];
(statearr_65899[(0)] = fluree$db$dbfunctions$fns$state_machine__10903__auto__);

(statearr_65899[(1)] = (1));

return statearr_65899;
});
var fluree$db$dbfunctions$fns$state_machine__10903__auto____1 = (function (state_65887){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_65887);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e65900){var ex__10906__auto__ = e65900;
var statearr_65901_65912 = state_65887;
(statearr_65901_65912[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_65887[(4)]))){
var statearr_65902_65913 = state_65887;
(statearr_65902_65913[(1)] = cljs.core.first.call(null,(state_65887[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65914 = state_65887;
state_65887 = G__65914;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10903__auto__ = function(state_65887){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____1.call(this,state_65887);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_65903 = f__10977__auto__.call(null);
(statearr_65903[(6)] = c__10976__auto__);

return statearr_65903;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq65855){
var G__65856 = cljs.core.first.call(null,seq65855);
var seq65855__$1 = cljs.core.next.call(null,seq65855);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65856,seq65855__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___65964 = arguments.length;
var i__4865__auto___65965 = (0);
while(true){
if((i__4865__auto___65965 < len__4864__auto___65964)){
args__4870__auto__.push((arguments[i__4865__auto___65965]));

var G__65966 = (i__4865__auto___65965 + (1));
i__4865__auto___65965 = G__65966;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_65947){
var state_val_65948 = (state_65947[(1)]);
if((state_val_65948 === (1))){
var state_65947__$1 = state_65947;
var statearr_65949_65967 = state_65947__$1;
(statearr_65949_65967[(2)] = null);

(statearr_65949_65967[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65948 === (2))){
var _ = (function (){var statearr_65950 = state_65947;
(statearr_65950[(4)] = cljs.core.cons.call(null,(5),(state_65947[(4)])));

return statearr_65950;
})();
var inst_65923 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_65947__$1 = state_65947;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65947__$1,(6),inst_65923);
} else {
if((state_val_65948 === (3))){
var inst_65945 = (state_65947[(2)]);
var state_65947__$1 = state_65947;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65947__$1,inst_65945);
} else {
if((state_val_65948 === (4))){
var inst_65917 = (state_65947[(2)]);
var state_65947__$1 = state_65947;
var statearr_65952_65968 = state_65947__$1;
(statearr_65952_65968[(2)] = inst_65917);

(statearr_65952_65968[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65948 === (5))){
var _ = (function (){var statearr_65953 = state_65947;
(statearr_65953[(4)] = cljs.core.rest.call(null,(state_65947[(4)])));

return statearr_65953;
})();
var state_65947__$1 = state_65947;
var ex65951 = (state_65947__$1[(2)]);
var statearr_65954_65969 = state_65947__$1;
(statearr_65954_65969[(5)] = ex65951);


if((ex65951 instanceof Error)){
var statearr_65955_65970 = state_65947__$1;
(statearr_65955_65970[(1)] = (4));

(statearr_65955_65970[(5)] = null);

} else {
throw ex65951;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65948 === (6))){
var inst_65925 = (state_65947[(2)]);
var inst_65926 = fluree.db.util.async.throw_err.call(null,inst_65925);
var inst_65927 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._STAR_,inst_65926);
var inst_65928 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65929 = [inst_65926];
var inst_65930 = (new cljs.core.PersistentVector(null,1,(5),inst_65928,inst_65929,null));
var inst_65931 = cljs.core.count.call(null,inst_65930);
var inst_65932 = ((9) + inst_65931);
var inst_65933 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65934 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65935 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65936 = [inst_65926];
var inst_65937 = (new cljs.core.PersistentVector(null,1,(5),inst_65935,inst_65936,null));
var inst_65938 = ["*",inst_65937,inst_65927];
var inst_65939 = cljs.core.PersistentHashMap.fromArrays(inst_65934,inst_65938);
var inst_65940 = [inst_65939,inst_65932];
var inst_65941 = (new cljs.core.PersistentVector(null,2,(5),inst_65933,inst_65940,null));
var inst_65942 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_65941);
var _ = (function (){var statearr_65956 = state_65947;
(statearr_65956[(4)] = cljs.core.rest.call(null,(state_65947[(4)])));

return statearr_65956;
})();
var state_65947__$1 = (function (){var statearr_65957 = state_65947;
(statearr_65957[(7)] = inst_65942);

return statearr_65957;
})();
var statearr_65958_65971 = state_65947__$1;
(statearr_65958_65971[(2)] = inst_65927);

(statearr_65958_65971[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10903__auto____0 = (function (){
var statearr_65959 = [null,null,null,null,null,null,null,null];
(statearr_65959[(0)] = fluree$db$dbfunctions$fns$state_machine__10903__auto__);

(statearr_65959[(1)] = (1));

return statearr_65959;
});
var fluree$db$dbfunctions$fns$state_machine__10903__auto____1 = (function (state_65947){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_65947);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e65960){var ex__10906__auto__ = e65960;
var statearr_65961_65972 = state_65947;
(statearr_65961_65972[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_65947[(4)]))){
var statearr_65962_65973 = state_65947;
(statearr_65962_65973[(1)] = cljs.core.first.call(null,(state_65947[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65974 = state_65947;
state_65947 = G__65974;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10903__auto__ = function(state_65947){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____1.call(this,state_65947);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_65963 = f__10977__auto__.call(null);
(statearr_65963[(6)] = c__10976__auto__);

return statearr_65963;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq65915){
var G__65916 = cljs.core.first.call(null,seq65915);
var seq65915__$1 = cljs.core.next.call(null,seq65915);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65916,seq65915__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___66024 = arguments.length;
var i__4865__auto___66025 = (0);
while(true){
if((i__4865__auto___66025 < len__4864__auto___66024)){
args__4870__auto__.push((arguments[i__4865__auto___66025]));

var G__66026 = (i__4865__auto___66025 + (1));
i__4865__auto___66025 = G__66026;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_66007){
var state_val_66008 = (state_66007[(1)]);
if((state_val_66008 === (1))){
var state_66007__$1 = state_66007;
var statearr_66009_66027 = state_66007__$1;
(statearr_66009_66027[(2)] = null);

(statearr_66009_66027[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66008 === (2))){
var _ = (function (){var statearr_66010 = state_66007;
(statearr_66010[(4)] = cljs.core.cons.call(null,(5),(state_66007[(4)])));

return statearr_66010;
})();
var inst_65983 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_66007__$1 = state_66007;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66007__$1,(6),inst_65983);
} else {
if((state_val_66008 === (3))){
var inst_66005 = (state_66007[(2)]);
var state_66007__$1 = state_66007;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66007__$1,inst_66005);
} else {
if((state_val_66008 === (4))){
var inst_65977 = (state_66007[(2)]);
var state_66007__$1 = state_66007;
var statearr_66012_66028 = state_66007__$1;
(statearr_66012_66028[(2)] = inst_65977);

(statearr_66012_66028[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66008 === (5))){
var _ = (function (){var statearr_66013 = state_66007;
(statearr_66013[(4)] = cljs.core.rest.call(null,(state_66007[(4)])));

return statearr_66013;
})();
var state_66007__$1 = state_66007;
var ex66011 = (state_66007__$1[(2)]);
var statearr_66014_66029 = state_66007__$1;
(statearr_66014_66029[(5)] = ex66011);


if((ex66011 instanceof Error)){
var statearr_66015_66030 = state_66007__$1;
(statearr_66015_66030[(1)] = (4));

(statearr_66015_66030[(5)] = null);

} else {
throw ex66011;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66008 === (6))){
var inst_65985 = (state_66007[(2)]);
var inst_65986 = fluree.db.util.async.throw_err.call(null,inst_65985);
var inst_65987 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._SLASH_,inst_65986);
var inst_65988 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65989 = [inst_65986];
var inst_65990 = (new cljs.core.PersistentVector(null,1,(5),inst_65988,inst_65989,null));
var inst_65991 = cljs.core.count.call(null,inst_65990);
var inst_65992 = ((9) + inst_65991);
var inst_65993 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65994 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65995 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65996 = [inst_65986];
var inst_65997 = (new cljs.core.PersistentVector(null,1,(5),inst_65995,inst_65996,null));
var inst_65998 = ["/",inst_65997,inst_65987];
var inst_65999 = cljs.core.PersistentHashMap.fromArrays(inst_65994,inst_65998);
var inst_66000 = [inst_65999,inst_65992];
var inst_66001 = (new cljs.core.PersistentVector(null,2,(5),inst_65993,inst_66000,null));
var inst_66002 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66001);
var _ = (function (){var statearr_66016 = state_66007;
(statearr_66016[(4)] = cljs.core.rest.call(null,(state_66007[(4)])));

return statearr_66016;
})();
var state_66007__$1 = (function (){var statearr_66017 = state_66007;
(statearr_66017[(7)] = inst_66002);

return statearr_66017;
})();
var statearr_66018_66031 = state_66007__$1;
(statearr_66018_66031[(2)] = inst_65987);

(statearr_66018_66031[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10903__auto____0 = (function (){
var statearr_66019 = [null,null,null,null,null,null,null,null];
(statearr_66019[(0)] = fluree$db$dbfunctions$fns$state_machine__10903__auto__);

(statearr_66019[(1)] = (1));

return statearr_66019;
});
var fluree$db$dbfunctions$fns$state_machine__10903__auto____1 = (function (state_66007){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_66007);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e66020){var ex__10906__auto__ = e66020;
var statearr_66021_66032 = state_66007;
(statearr_66021_66032[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_66007[(4)]))){
var statearr_66022_66033 = state_66007;
(statearr_66022_66033[(1)] = cljs.core.first.call(null,(state_66007[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66034 = state_66007;
state_66007 = G__66034;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10903__auto__ = function(state_66007){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____1.call(this,state_66007);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_66023 = f__10977__auto__.call(null);
(statearr_66023[(6)] = c__10976__auto__);

return statearr_66023;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq65975){
var G__65976 = cljs.core.first.call(null,seq65975);
var seq65975__$1 = cljs.core.next.call(null,seq65975);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65976,seq65975__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_66072){
var state_val_66073 = (state_66072[(1)]);
if((state_val_66073 === (7))){
var state_66072__$1 = state_66072;
var statearr_66074_66098 = state_66072__$1;
(statearr_66074_66098[(2)] = n);

(statearr_66074_66098[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66073 === (1))){
var state_66072__$1 = state_66072;
var statearr_66075_66099 = state_66072__$1;
(statearr_66075_66099[(2)] = null);

(statearr_66075_66099[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66073 === (4))){
var inst_66035 = (state_66072[(2)]);
var state_66072__$1 = state_66072;
var statearr_66076_66100 = state_66072__$1;
(statearr_66076_66100[(2)] = inst_66035);

(statearr_66076_66100[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66073 === (13))){
var inst_66052 = (state_66072[(2)]);
var inst_66053 = fluree.db.util.async.throw_err.call(null,inst_66052);
var state_66072__$1 = state_66072;
var statearr_66077_66101 = state_66072__$1;
(statearr_66077_66101[(2)] = inst_66053);

(statearr_66077_66101[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66073 === (6))){
var state_66072__$1 = state_66072;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66072__$1,(9),n);
} else {
if((state_val_66073 === (3))){
var inst_66070 = (state_66072[(2)]);
var state_66072__$1 = state_66072;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66072__$1,inst_66070);
} else {
if((state_val_66073 === (12))){
var inst_66048 = (state_66072[(7)]);
var inst_66056 = (state_66072[(2)]);
var inst_66057 = fluree.db.dbfunctions.internal.quot.call(null,inst_66048,inst_66056);
var inst_66058 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66059 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66060 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66061 = [inst_66048,inst_66056];
var inst_66062 = (new cljs.core.PersistentVector(null,2,(5),inst_66060,inst_66061,null));
var inst_66063 = ["quot",inst_66062,inst_66057];
var inst_66064 = cljs.core.PersistentHashMap.fromArrays(inst_66059,inst_66063);
var inst_66065 = [inst_66064,(2)];
var inst_66066 = (new cljs.core.PersistentVector(null,2,(5),inst_66058,inst_66065,null));
var inst_66067 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66066);
var _ = (function (){var statearr_66078 = state_66072;
(statearr_66078[(4)] = cljs.core.rest.call(null,(state_66072[(4)])));

return statearr_66078;
})();
var state_66072__$1 = (function (){var statearr_66079 = state_66072;
(statearr_66079[(8)] = inst_66067);

return statearr_66079;
})();
var statearr_66080_66102 = state_66072__$1;
(statearr_66080_66102[(2)] = inst_66057);

(statearr_66080_66102[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66073 === (2))){
var _ = (function (){var statearr_66081 = state_66072;
(statearr_66081[(4)] = cljs.core.cons.call(null,(5),(state_66072[(4)])));

return statearr_66081;
})();
var inst_66041 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_66072__$1 = state_66072;
if(inst_66041){
var statearr_66082_66103 = state_66072__$1;
(statearr_66082_66103[(1)] = (6));

} else {
var statearr_66083_66104 = state_66072__$1;
(statearr_66083_66104[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66073 === (11))){
var state_66072__$1 = state_66072;
var statearr_66085_66105 = state_66072__$1;
(statearr_66085_66105[(2)] = d);

(statearr_66085_66105[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66073 === (9))){
var inst_66044 = (state_66072[(2)]);
var inst_66045 = fluree.db.util.async.throw_err.call(null,inst_66044);
var state_66072__$1 = state_66072;
var statearr_66086_66106 = state_66072__$1;
(statearr_66086_66106[(2)] = inst_66045);

(statearr_66086_66106[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66073 === (5))){
var _ = (function (){var statearr_66087 = state_66072;
(statearr_66087[(4)] = cljs.core.rest.call(null,(state_66072[(4)])));

return statearr_66087;
})();
var state_66072__$1 = state_66072;
var ex66084 = (state_66072__$1[(2)]);
var statearr_66088_66107 = state_66072__$1;
(statearr_66088_66107[(5)] = ex66084);


if((ex66084 instanceof Error)){
var statearr_66089_66108 = state_66072__$1;
(statearr_66089_66108[(1)] = (4));

(statearr_66089_66108[(5)] = null);

} else {
throw ex66084;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66073 === (10))){
var state_66072__$1 = state_66072;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66072__$1,(13),d);
} else {
if((state_val_66073 === (8))){
var inst_66048 = (state_66072[(2)]);
var inst_66049 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_66072__$1 = (function (){var statearr_66090 = state_66072;
(statearr_66090[(7)] = inst_66048);

return statearr_66090;
})();
if(inst_66049){
var statearr_66091_66109 = state_66072__$1;
(statearr_66091_66109[(1)] = (10));

} else {
var statearr_66092_66110 = state_66072__$1;
(statearr_66092_66110[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__10903__auto____0 = (function (){
var statearr_66093 = [null,null,null,null,null,null,null,null,null];
(statearr_66093[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__10903__auto__);

(statearr_66093[(1)] = (1));

return statearr_66093;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__10903__auto____1 = (function (state_66072){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_66072);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e66094){var ex__10906__auto__ = e66094;
var statearr_66095_66111 = state_66072;
(statearr_66095_66111[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_66072[(4)]))){
var statearr_66096_66112 = state_66072;
(statearr_66096_66112[(1)] = cljs.core.first.call(null,(state_66072[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66113 = state_66072;
state_66072 = G__66113;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__10903__auto__ = function(state_66072){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__10903__auto____1.call(this,state_66072);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_66097 = f__10977__auto__.call(null);
(statearr_66097[(6)] = c__10976__auto__);

return statearr_66097;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_66151){
var state_val_66152 = (state_66151[(1)]);
if((state_val_66152 === (7))){
var state_66151__$1 = state_66151;
var statearr_66153_66177 = state_66151__$1;
(statearr_66153_66177[(2)] = n);

(statearr_66153_66177[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66152 === (1))){
var state_66151__$1 = state_66151;
var statearr_66154_66178 = state_66151__$1;
(statearr_66154_66178[(2)] = null);

(statearr_66154_66178[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66152 === (4))){
var inst_66114 = (state_66151[(2)]);
var state_66151__$1 = state_66151;
var statearr_66155_66179 = state_66151__$1;
(statearr_66155_66179[(2)] = inst_66114);

(statearr_66155_66179[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66152 === (13))){
var inst_66131 = (state_66151[(2)]);
var inst_66132 = fluree.db.util.async.throw_err.call(null,inst_66131);
var state_66151__$1 = state_66151;
var statearr_66156_66180 = state_66151__$1;
(statearr_66156_66180[(2)] = inst_66132);

(statearr_66156_66180[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66152 === (6))){
var state_66151__$1 = state_66151;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66151__$1,(9),n);
} else {
if((state_val_66152 === (3))){
var inst_66149 = (state_66151[(2)]);
var state_66151__$1 = state_66151;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66151__$1,inst_66149);
} else {
if((state_val_66152 === (12))){
var inst_66127 = (state_66151[(7)]);
var inst_66135 = (state_66151[(2)]);
var inst_66136 = fluree.db.dbfunctions.internal.mod.call(null,inst_66127,inst_66135);
var inst_66137 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66138 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66139 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66140 = [inst_66127,inst_66135];
var inst_66141 = (new cljs.core.PersistentVector(null,2,(5),inst_66139,inst_66140,null));
var inst_66142 = ["mod",inst_66141,inst_66136];
var inst_66143 = cljs.core.PersistentHashMap.fromArrays(inst_66138,inst_66142);
var inst_66144 = [inst_66143,(2)];
var inst_66145 = (new cljs.core.PersistentVector(null,2,(5),inst_66137,inst_66144,null));
var inst_66146 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66145);
var _ = (function (){var statearr_66157 = state_66151;
(statearr_66157[(4)] = cljs.core.rest.call(null,(state_66151[(4)])));

return statearr_66157;
})();
var state_66151__$1 = (function (){var statearr_66158 = state_66151;
(statearr_66158[(8)] = inst_66146);

return statearr_66158;
})();
var statearr_66159_66181 = state_66151__$1;
(statearr_66159_66181[(2)] = inst_66136);

(statearr_66159_66181[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66152 === (2))){
var _ = (function (){var statearr_66160 = state_66151;
(statearr_66160[(4)] = cljs.core.cons.call(null,(5),(state_66151[(4)])));

return statearr_66160;
})();
var inst_66120 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_66151__$1 = state_66151;
if(inst_66120){
var statearr_66161_66182 = state_66151__$1;
(statearr_66161_66182[(1)] = (6));

} else {
var statearr_66162_66183 = state_66151__$1;
(statearr_66162_66183[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66152 === (11))){
var state_66151__$1 = state_66151;
var statearr_66164_66184 = state_66151__$1;
(statearr_66164_66184[(2)] = d);

(statearr_66164_66184[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66152 === (9))){
var inst_66123 = (state_66151[(2)]);
var inst_66124 = fluree.db.util.async.throw_err.call(null,inst_66123);
var state_66151__$1 = state_66151;
var statearr_66165_66185 = state_66151__$1;
(statearr_66165_66185[(2)] = inst_66124);

(statearr_66165_66185[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66152 === (5))){
var _ = (function (){var statearr_66166 = state_66151;
(statearr_66166[(4)] = cljs.core.rest.call(null,(state_66151[(4)])));

return statearr_66166;
})();
var state_66151__$1 = state_66151;
var ex66163 = (state_66151__$1[(2)]);
var statearr_66167_66186 = state_66151__$1;
(statearr_66167_66186[(5)] = ex66163);


if((ex66163 instanceof Error)){
var statearr_66168_66187 = state_66151__$1;
(statearr_66168_66187[(1)] = (4));

(statearr_66168_66187[(5)] = null);

} else {
throw ex66163;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66152 === (10))){
var state_66151__$1 = state_66151;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66151__$1,(13),d);
} else {
if((state_val_66152 === (8))){
var inst_66127 = (state_66151[(2)]);
var inst_66128 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_66151__$1 = (function (){var statearr_66169 = state_66151;
(statearr_66169[(7)] = inst_66127);

return statearr_66169;
})();
if(inst_66128){
var statearr_66170_66188 = state_66151__$1;
(statearr_66170_66188[(1)] = (10));

} else {
var statearr_66171_66189 = state_66151__$1;
(statearr_66171_66189[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__10903__auto____0 = (function (){
var statearr_66172 = [null,null,null,null,null,null,null,null,null];
(statearr_66172[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__10903__auto__);

(statearr_66172[(1)] = (1));

return statearr_66172;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__10903__auto____1 = (function (state_66151){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_66151);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e66173){var ex__10906__auto__ = e66173;
var statearr_66174_66190 = state_66151;
(statearr_66174_66190[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_66151[(4)]))){
var statearr_66175_66191 = state_66151;
(statearr_66175_66191[(1)] = cljs.core.first.call(null,(state_66151[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66192 = state_66151;
state_66151 = G__66192;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__10903__auto__ = function(state_66151){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__10903__auto____1.call(this,state_66151);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_66176 = f__10977__auto__.call(null);
(statearr_66176[(6)] = c__10976__auto__);

return statearr_66176;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_66230){
var state_val_66231 = (state_66230[(1)]);
if((state_val_66231 === (7))){
var state_66230__$1 = state_66230;
var statearr_66232_66256 = state_66230__$1;
(statearr_66232_66256[(2)] = n);

(statearr_66232_66256[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66231 === (1))){
var state_66230__$1 = state_66230;
var statearr_66233_66257 = state_66230__$1;
(statearr_66233_66257[(2)] = null);

(statearr_66233_66257[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66231 === (4))){
var inst_66193 = (state_66230[(2)]);
var state_66230__$1 = state_66230;
var statearr_66234_66258 = state_66230__$1;
(statearr_66234_66258[(2)] = inst_66193);

(statearr_66234_66258[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66231 === (13))){
var inst_66210 = (state_66230[(2)]);
var inst_66211 = fluree.db.util.async.throw_err.call(null,inst_66210);
var state_66230__$1 = state_66230;
var statearr_66235_66259 = state_66230__$1;
(statearr_66235_66259[(2)] = inst_66211);

(statearr_66235_66259[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66231 === (6))){
var state_66230__$1 = state_66230;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66230__$1,(9),n);
} else {
if((state_val_66231 === (3))){
var inst_66228 = (state_66230[(2)]);
var state_66230__$1 = state_66230;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66230__$1,inst_66228);
} else {
if((state_val_66231 === (12))){
var inst_66206 = (state_66230[(7)]);
var inst_66214 = (state_66230[(2)]);
var inst_66215 = fluree.db.dbfunctions.internal.rem.call(null,inst_66206,inst_66214);
var inst_66216 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66217 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66218 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66219 = [inst_66206,inst_66214];
var inst_66220 = (new cljs.core.PersistentVector(null,2,(5),inst_66218,inst_66219,null));
var inst_66221 = ["rem",inst_66220,inst_66215];
var inst_66222 = cljs.core.PersistentHashMap.fromArrays(inst_66217,inst_66221);
var inst_66223 = [inst_66222,(2)];
var inst_66224 = (new cljs.core.PersistentVector(null,2,(5),inst_66216,inst_66223,null));
var inst_66225 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66224);
var _ = (function (){var statearr_66236 = state_66230;
(statearr_66236[(4)] = cljs.core.rest.call(null,(state_66230[(4)])));

return statearr_66236;
})();
var state_66230__$1 = (function (){var statearr_66237 = state_66230;
(statearr_66237[(8)] = inst_66225);

return statearr_66237;
})();
var statearr_66238_66260 = state_66230__$1;
(statearr_66238_66260[(2)] = inst_66215);

(statearr_66238_66260[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66231 === (2))){
var _ = (function (){var statearr_66239 = state_66230;
(statearr_66239[(4)] = cljs.core.cons.call(null,(5),(state_66230[(4)])));

return statearr_66239;
})();
var inst_66199 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_66230__$1 = state_66230;
if(inst_66199){
var statearr_66240_66261 = state_66230__$1;
(statearr_66240_66261[(1)] = (6));

} else {
var statearr_66241_66262 = state_66230__$1;
(statearr_66241_66262[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66231 === (11))){
var state_66230__$1 = state_66230;
var statearr_66243_66263 = state_66230__$1;
(statearr_66243_66263[(2)] = d);

(statearr_66243_66263[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66231 === (9))){
var inst_66202 = (state_66230[(2)]);
var inst_66203 = fluree.db.util.async.throw_err.call(null,inst_66202);
var state_66230__$1 = state_66230;
var statearr_66244_66264 = state_66230__$1;
(statearr_66244_66264[(2)] = inst_66203);

(statearr_66244_66264[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66231 === (5))){
var _ = (function (){var statearr_66245 = state_66230;
(statearr_66245[(4)] = cljs.core.rest.call(null,(state_66230[(4)])));

return statearr_66245;
})();
var state_66230__$1 = state_66230;
var ex66242 = (state_66230__$1[(2)]);
var statearr_66246_66265 = state_66230__$1;
(statearr_66246_66265[(5)] = ex66242);


if((ex66242 instanceof Error)){
var statearr_66247_66266 = state_66230__$1;
(statearr_66247_66266[(1)] = (4));

(statearr_66247_66266[(5)] = null);

} else {
throw ex66242;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66231 === (10))){
var state_66230__$1 = state_66230;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66230__$1,(13),d);
} else {
if((state_val_66231 === (8))){
var inst_66206 = (state_66230[(2)]);
var inst_66207 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_66230__$1 = (function (){var statearr_66248 = state_66230;
(statearr_66248[(7)] = inst_66206);

return statearr_66248;
})();
if(inst_66207){
var statearr_66249_66267 = state_66230__$1;
(statearr_66249_66267[(1)] = (10));

} else {
var statearr_66250_66268 = state_66230__$1;
(statearr_66250_66268[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__10903__auto____0 = (function (){
var statearr_66251 = [null,null,null,null,null,null,null,null,null];
(statearr_66251[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__10903__auto__);

(statearr_66251[(1)] = (1));

return statearr_66251;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__10903__auto____1 = (function (state_66230){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_66230);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e66252){var ex__10906__auto__ = e66252;
var statearr_66253_66269 = state_66230;
(statearr_66253_66269[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_66230[(4)]))){
var statearr_66254_66270 = state_66230;
(statearr_66254_66270[(1)] = cljs.core.first.call(null,(state_66230[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66271 = state_66230;
state_66230 = G__66271;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__10903__auto__ = function(state_66230){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__10903__auto____1.call(this,state_66230);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_66255 = f__10977__auto__.call(null);
(statearr_66255[(6)] = c__10976__auto__);

return statearr_66255;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_66298){
var state_val_66299 = (state_66298[(1)]);
if((state_val_66299 === (7))){
var state_66298__$1 = state_66298;
var statearr_66300_66319 = state_66298__$1;
(statearr_66300_66319[(2)] = x);

(statearr_66300_66319[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66299 === (1))){
var state_66298__$1 = state_66298;
var statearr_66301_66320 = state_66298__$1;
(statearr_66301_66320[(2)] = null);

(statearr_66301_66320[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66299 === (4))){
var inst_66272 = (state_66298[(2)]);
var state_66298__$1 = state_66298;
var statearr_66302_66321 = state_66298__$1;
(statearr_66302_66321[(2)] = inst_66272);

(statearr_66302_66321[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66299 === (6))){
var state_66298__$1 = state_66298;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66298__$1,(9),x);
} else {
if((state_val_66299 === (3))){
var inst_66296 = (state_66298[(2)]);
var state_66298__$1 = state_66298;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66298__$1,inst_66296);
} else {
if((state_val_66299 === (2))){
var _ = (function (){var statearr_66304 = state_66298;
(statearr_66304[(4)] = cljs.core.cons.call(null,(5),(state_66298[(4)])));

return statearr_66304;
})();
var inst_66278 = fluree.db.util.async.channel_QMARK_.call(null,x);
var state_66298__$1 = state_66298;
if(inst_66278){
var statearr_66305_66322 = state_66298__$1;
(statearr_66305_66322[(1)] = (6));

} else {
var statearr_66306_66323 = state_66298__$1;
(statearr_66306_66323[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66299 === (9))){
var inst_66281 = (state_66298[(2)]);
var inst_66282 = fluree.db.util.async.throw_err.call(null,inst_66281);
var state_66298__$1 = state_66298;
var statearr_66307_66324 = state_66298__$1;
(statearr_66307_66324[(2)] = inst_66282);

(statearr_66307_66324[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66299 === (5))){
var _ = (function (){var statearr_66308 = state_66298;
(statearr_66308[(4)] = cljs.core.rest.call(null,(state_66298[(4)])));

return statearr_66308;
})();
var state_66298__$1 = state_66298;
var ex66303 = (state_66298__$1[(2)]);
var statearr_66309_66325 = state_66298__$1;
(statearr_66309_66325[(5)] = ex66303);


if((ex66303 instanceof Error)){
var statearr_66310_66326 = state_66298__$1;
(statearr_66310_66326[(1)] = (4));

(statearr_66310_66326[(5)] = null);

} else {
throw ex66303;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66299 === (8))){
var inst_66285 = (state_66298[(2)]);
var inst_66286 = fluree.db.dbfunctions.internal.boolean$.call(null,inst_66285);
var inst_66287 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66288 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66289 = ["boolean",inst_66285,inst_66286];
var inst_66290 = cljs.core.PersistentHashMap.fromArrays(inst_66288,inst_66289);
var inst_66291 = [inst_66290,(10)];
var inst_66292 = (new cljs.core.PersistentVector(null,2,(5),inst_66287,inst_66291,null));
var inst_66293 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66292);
var _ = (function (){var statearr_66311 = state_66298;
(statearr_66311[(4)] = cljs.core.rest.call(null,(state_66298[(4)])));

return statearr_66311;
})();
var state_66298__$1 = (function (){var statearr_66312 = state_66298;
(statearr_66312[(7)] = inst_66293);

return statearr_66312;
})();
var statearr_66313_66327 = state_66298__$1;
(statearr_66313_66327[(2)] = inst_66286);

(statearr_66313_66327[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__10903__auto____0 = (function (){
var statearr_66314 = [null,null,null,null,null,null,null,null];
(statearr_66314[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__10903__auto__);

(statearr_66314[(1)] = (1));

return statearr_66314;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__10903__auto____1 = (function (state_66298){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_66298);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e66315){var ex__10906__auto__ = e66315;
var statearr_66316_66328 = state_66298;
(statearr_66316_66328[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_66298[(4)]))){
var statearr_66317_66329 = state_66298;
(statearr_66317_66329[(1)] = cljs.core.first.call(null,(state_66298[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66330 = state_66298;
state_66298 = G__66330;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__10903__auto__ = function(state_66298){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__10903__auto____1.call(this,state_66298);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_66318 = f__10977__auto__.call(null);
(statearr_66318[(6)] = c__10976__auto__);

return statearr_66318;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_66368){
var state_val_66369 = (state_66368[(1)]);
if((state_val_66369 === (7))){
var state_66368__$1 = state_66368;
var statearr_66370_66394 = state_66368__$1;
(statearr_66370_66394[(2)] = pattern);

(statearr_66370_66394[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66369 === (1))){
var state_66368__$1 = state_66368;
var statearr_66371_66395 = state_66368__$1;
(statearr_66371_66395[(2)] = null);

(statearr_66371_66395[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66369 === (4))){
var inst_66331 = (state_66368[(2)]);
var state_66368__$1 = state_66368;
var statearr_66372_66396 = state_66368__$1;
(statearr_66372_66396[(2)] = inst_66331);

(statearr_66372_66396[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66369 === (13))){
var inst_66348 = (state_66368[(2)]);
var inst_66349 = fluree.db.util.async.throw_err.call(null,inst_66348);
var state_66368__$1 = state_66368;
var statearr_66373_66397 = state_66368__$1;
(statearr_66373_66397[(2)] = inst_66349);

(statearr_66373_66397[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66369 === (6))){
var state_66368__$1 = state_66368;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66368__$1,(9),pattern);
} else {
if((state_val_66369 === (3))){
var inst_66366 = (state_66368[(2)]);
var state_66368__$1 = state_66368;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66368__$1,inst_66366);
} else {
if((state_val_66369 === (12))){
var inst_66344 = (state_66368[(7)]);
var inst_66352 = (state_66368[(2)]);
var inst_66353 = fluree.db.dbfunctions.internal.re_find.call(null,inst_66344,inst_66352);
var inst_66354 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66355 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66356 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66357 = [inst_66344,inst_66352];
var inst_66358 = (new cljs.core.PersistentVector(null,2,(5),inst_66356,inst_66357,null));
var inst_66359 = ["re-find",inst_66358,inst_66353];
var inst_66360 = cljs.core.PersistentHashMap.fromArrays(inst_66355,inst_66359);
var inst_66361 = [inst_66360,(10)];
var inst_66362 = (new cljs.core.PersistentVector(null,2,(5),inst_66354,inst_66361,null));
var inst_66363 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66362);
var _ = (function (){var statearr_66374 = state_66368;
(statearr_66374[(4)] = cljs.core.rest.call(null,(state_66368[(4)])));

return statearr_66374;
})();
var state_66368__$1 = (function (){var statearr_66375 = state_66368;
(statearr_66375[(8)] = inst_66363);

return statearr_66375;
})();
var statearr_66376_66398 = state_66368__$1;
(statearr_66376_66398[(2)] = inst_66353);

(statearr_66376_66398[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66369 === (2))){
var _ = (function (){var statearr_66377 = state_66368;
(statearr_66377[(4)] = cljs.core.cons.call(null,(5),(state_66368[(4)])));

return statearr_66377;
})();
var inst_66337 = fluree.db.util.async.channel_QMARK_.call(null,pattern);
var state_66368__$1 = state_66368;
if(inst_66337){
var statearr_66378_66399 = state_66368__$1;
(statearr_66378_66399[(1)] = (6));

} else {
var statearr_66379_66400 = state_66368__$1;
(statearr_66379_66400[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66369 === (11))){
var state_66368__$1 = state_66368;
var statearr_66381_66401 = state_66368__$1;
(statearr_66381_66401[(2)] = string);

(statearr_66381_66401[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66369 === (9))){
var inst_66340 = (state_66368[(2)]);
var inst_66341 = fluree.db.util.async.throw_err.call(null,inst_66340);
var state_66368__$1 = state_66368;
var statearr_66382_66402 = state_66368__$1;
(statearr_66382_66402[(2)] = inst_66341);

(statearr_66382_66402[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66369 === (5))){
var _ = (function (){var statearr_66383 = state_66368;
(statearr_66383[(4)] = cljs.core.rest.call(null,(state_66368[(4)])));

return statearr_66383;
})();
var state_66368__$1 = state_66368;
var ex66380 = (state_66368__$1[(2)]);
var statearr_66384_66403 = state_66368__$1;
(statearr_66384_66403[(5)] = ex66380);


if((ex66380 instanceof Error)){
var statearr_66385_66404 = state_66368__$1;
(statearr_66385_66404[(1)] = (4));

(statearr_66385_66404[(5)] = null);

} else {
throw ex66380;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66369 === (10))){
var state_66368__$1 = state_66368;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66368__$1,(13),string);
} else {
if((state_val_66369 === (8))){
var inst_66344 = (state_66368[(2)]);
var inst_66345 = fluree.db.util.async.channel_QMARK_.call(null,string);
var state_66368__$1 = (function (){var statearr_66386 = state_66368;
(statearr_66386[(7)] = inst_66344);

return statearr_66386;
})();
if(inst_66345){
var statearr_66387_66405 = state_66368__$1;
(statearr_66387_66405[(1)] = (10));

} else {
var statearr_66388_66406 = state_66368__$1;
(statearr_66388_66406[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__10903__auto____0 = (function (){
var statearr_66389 = [null,null,null,null,null,null,null,null,null];
(statearr_66389[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__10903__auto__);

(statearr_66389[(1)] = (1));

return statearr_66389;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__10903__auto____1 = (function (state_66368){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_66368);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e66390){var ex__10906__auto__ = e66390;
var statearr_66391_66407 = state_66368;
(statearr_66391_66407[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_66368[(4)]))){
var statearr_66392_66408 = state_66368;
(statearr_66392_66408[(1)] = cljs.core.first.call(null,(state_66368[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66409 = state_66368;
state_66368 = G__66409;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__10903__auto__ = function(state_66368){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__10903__auto____1.call(this,state_66368);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_66393 = f__10977__auto__.call(null);
(statearr_66393[(6)] = c__10976__auto__);

return statearr_66393;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_66436){
var state_val_66437 = (state_66436[(1)]);
if((state_val_66437 === (7))){
var state_66436__$1 = state_66436;
var statearr_66438_66457 = state_66436__$1;
(statearr_66438_66457[(2)] = email);

(statearr_66438_66457[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66437 === (1))){
var state_66436__$1 = state_66436;
var statearr_66439_66458 = state_66436__$1;
(statearr_66439_66458[(2)] = null);

(statearr_66439_66458[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66437 === (4))){
var inst_66410 = (state_66436[(2)]);
var state_66436__$1 = state_66436;
var statearr_66440_66459 = state_66436__$1;
(statearr_66440_66459[(2)] = inst_66410);

(statearr_66440_66459[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66437 === (6))){
var state_66436__$1 = state_66436;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66436__$1,(9),email);
} else {
if((state_val_66437 === (3))){
var inst_66434 = (state_66436[(2)]);
var state_66436__$1 = state_66436;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66436__$1,inst_66434);
} else {
if((state_val_66437 === (2))){
var _ = (function (){var statearr_66442 = state_66436;
(statearr_66442[(4)] = cljs.core.cons.call(null,(5),(state_66436[(4)])));

return statearr_66442;
})();
var inst_66416 = fluree.db.util.async.channel_QMARK_.call(null,email);
var state_66436__$1 = state_66436;
if(inst_66416){
var statearr_66443_66460 = state_66436__$1;
(statearr_66443_66460[(1)] = (6));

} else {
var statearr_66444_66461 = state_66436__$1;
(statearr_66444_66461[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66437 === (9))){
var inst_66419 = (state_66436[(2)]);
var inst_66420 = fluree.db.util.async.throw_err.call(null,inst_66419);
var state_66436__$1 = state_66436;
var statearr_66445_66462 = state_66436__$1;
(statearr_66445_66462[(2)] = inst_66420);

(statearr_66445_66462[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66437 === (5))){
var _ = (function (){var statearr_66446 = state_66436;
(statearr_66446[(4)] = cljs.core.rest.call(null,(state_66436[(4)])));

return statearr_66446;
})();
var state_66436__$1 = state_66436;
var ex66441 = (state_66436__$1[(2)]);
var statearr_66447_66463 = state_66436__$1;
(statearr_66447_66463[(5)] = ex66441);


if((ex66441 instanceof Error)){
var statearr_66448_66464 = state_66436__$1;
(statearr_66448_66464[(1)] = (4));

(statearr_66448_66464[(5)] = null);

} else {
throw ex66441;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66437 === (8))){
var inst_66423 = (state_66436[(2)]);
var inst_66424 = fluree.db.dbfunctions.internal.valid_email_QMARK_.call(null,inst_66423);
var inst_66425 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66426 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66427 = ["re-find",inst_66423,inst_66424];
var inst_66428 = cljs.core.PersistentHashMap.fromArrays(inst_66426,inst_66427);
var inst_66429 = [inst_66428,(10)];
var inst_66430 = (new cljs.core.PersistentVector(null,2,(5),inst_66425,inst_66429,null));
var inst_66431 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66430);
var _ = (function (){var statearr_66449 = state_66436;
(statearr_66449[(4)] = cljs.core.rest.call(null,(state_66436[(4)])));

return statearr_66449;
})();
var state_66436__$1 = (function (){var statearr_66450 = state_66436;
(statearr_66450[(7)] = inst_66431);

return statearr_66450;
})();
var statearr_66451_66465 = state_66436__$1;
(statearr_66451_66465[(2)] = inst_66424);

(statearr_66451_66465[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10903__auto____0 = (function (){
var statearr_66452 = [null,null,null,null,null,null,null,null];
(statearr_66452[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10903__auto__);

(statearr_66452[(1)] = (1));

return statearr_66452;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10903__auto____1 = (function (state_66436){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_66436);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e66453){var ex__10906__auto__ = e66453;
var statearr_66454_66466 = state_66436;
(statearr_66454_66466[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_66436[(4)]))){
var statearr_66455_66467 = state_66436;
(statearr_66455_66467[(1)] = cljs.core.first.call(null,(state_66436[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66468 = state_66436;
state_66436 = G__66468;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10903__auto__ = function(state_66436){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10903__auto____1.call(this,state_66436);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_66456 = f__10977__auto__.call(null);
(statearr_66456[(6)] = c__10976__auto__);

return statearr_66456;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_66515){
var state_val_66516 = (state_66515[(1)]);
if((state_val_66516 === (7))){
var inst_66485 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_66515__$1 = state_66515;
if(cljs.core.truth_(inst_66485)){
var statearr_66517_66544 = state_66515__$1;
(statearr_66517_66544[(1)] = (9));

} else {
var statearr_66518_66545 = state_66515__$1;
(statearr_66518_66545[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66516 === (1))){
var state_66515__$1 = state_66515;
var statearr_66519_66546 = state_66515__$1;
(statearr_66519_66546[(2)] = null);

(statearr_66519_66546[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66516 === (4))){
var inst_66469 = (state_66515[(2)]);
var state_66515__$1 = state_66515;
var statearr_66520_66547 = state_66515__$1;
(statearr_66520_66547[(2)] = inst_66469);

(statearr_66520_66547[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66516 === (15))){
var inst_66496 = (state_66515[(2)]);
var state_66515__$1 = state_66515;
var statearr_66521_66548 = state_66515__$1;
(statearr_66521_66548[(2)] = inst_66496);

(statearr_66521_66548[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66516 === (13))){
var inst_66493 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_66515__$1 = state_66515;
var statearr_66522_66549 = state_66515__$1;
(statearr_66522_66549[(2)] = inst_66493);

(statearr_66522_66549[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66516 === (6))){
var inst_66480 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66481 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_66482 = [inst_66481,(0)];
var inst_66483 = (new cljs.core.PersistentVector(null,2,(5),inst_66480,inst_66482,null));
var state_66515__$1 = state_66515;
var statearr_66523_66550 = state_66515__$1;
(statearr_66523_66550[(2)] = inst_66483);

(statearr_66523_66550[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66516 === (3))){
var inst_66513 = (state_66515[(2)]);
var state_66515__$1 = state_66515;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66515__$1,inst_66513);
} else {
if((state_val_66516 === (12))){
var inst_66489 = (state_66515[(2)]);
var inst_66490 = fluree.db.util.async.throw_err.call(null,inst_66489);
var state_66515__$1 = state_66515;
var statearr_66524_66551 = state_66515__$1;
(statearr_66524_66551[(2)] = inst_66490);

(statearr_66524_66551[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66516 === (2))){
var _ = (function (){var statearr_66525 = state_66515;
(statearr_66525[(4)] = cljs.core.cons.call(null,(5),(state_66515[(4)])));

return statearr_66525;
})();
var inst_66478 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_66515__$1 = state_66515;
if(cljs.core.truth_(inst_66478)){
var statearr_66526_66552 = state_66515__$1;
(statearr_66526_66552[(1)] = (6));

} else {
var statearr_66527_66553 = state_66515__$1;
(statearr_66527_66553[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66516 === (11))){
var inst_66498 = (state_66515[(2)]);
var state_66515__$1 = state_66515;
var statearr_66529_66554 = state_66515__$1;
(statearr_66529_66554[(2)] = inst_66498);

(statearr_66529_66554[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66516 === (9))){
var inst_66487 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth.call(null,_QMARK_ctx);
var state_66515__$1 = state_66515;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66515__$1,(12),inst_66487);
} else {
if((state_val_66516 === (5))){
var _ = (function (){var statearr_66530 = state_66515;
(statearr_66530[(4)] = cljs.core.rest.call(null,(state_66515[(4)])));

return statearr_66530;
})();
var state_66515__$1 = state_66515;
var ex66528 = (state_66515__$1[(2)]);
var statearr_66531_66555 = state_66515__$1;
(statearr_66531_66555[(5)] = ex66528);


if((ex66528 instanceof Error)){
var statearr_66532_66556 = state_66515__$1;
(statearr_66532_66556[(1)] = (4));

(statearr_66532_66556[(5)] = null);

} else {
throw ex66528;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66516 === (14))){
var state_66515__$1 = state_66515;
var statearr_66533_66557 = state_66515__$1;
(statearr_66533_66557[(2)] = null);

(statearr_66533_66557[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66516 === (10))){
var state_66515__$1 = state_66515;
var statearr_66534_66558 = state_66515__$1;
(statearr_66534_66558[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66516 === (8))){
var inst_66500 = (state_66515[(2)]);
var inst_66501 = cljs.core.nth.call(null,inst_66500,(0),null);
var inst_66502 = cljs.core.nth.call(null,inst_66500,(1),null);
var inst_66503 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66504 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66505 = ["?user_id","?ctx",inst_66501];
var inst_66506 = cljs.core.PersistentHashMap.fromArrays(inst_66504,inst_66505);
var inst_66507 = ((10) + inst_66502);
var inst_66508 = [inst_66506,inst_66507];
var inst_66509 = (new cljs.core.PersistentVector(null,2,(5),inst_66503,inst_66508,null));
var inst_66510 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66509);
var _ = (function (){var statearr_66536 = state_66515;
(statearr_66536[(4)] = cljs.core.rest.call(null,(state_66515[(4)])));

return statearr_66536;
})();
var state_66515__$1 = (function (){var statearr_66537 = state_66515;
(statearr_66537[(7)] = inst_66510);

return statearr_66537;
})();
var statearr_66538_66559 = state_66515__$1;
(statearr_66538_66559[(2)] = inst_66501);

(statearr_66538_66559[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10903__auto____0 = (function (){
var statearr_66539 = [null,null,null,null,null,null,null,null];
(statearr_66539[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10903__auto__);

(statearr_66539[(1)] = (1));

return statearr_66539;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10903__auto____1 = (function (state_66515){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_66515);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e66540){var ex__10906__auto__ = e66540;
var statearr_66541_66560 = state_66515;
(statearr_66541_66560[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_66515[(4)]))){
var statearr_66542_66561 = state_66515;
(statearr_66542_66561[(1)] = cljs.core.first.call(null,(state_66515[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66562 = state_66515;
state_66515 = G__66562;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10903__auto__ = function(state_66515){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10903__auto____1.call(this,state_66515);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_66543 = f__10977__auto__.call(null);
(statearr_66543[(6)] = c__10976__auto__);

return statearr_66543;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_66590){
var state_val_66591 = (state_66590[(1)]);
if((state_val_66591 === (7))){
var inst_66583 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_66590__$1 = state_66590;
var statearr_66592_66611 = state_66590__$1;
(statearr_66592_66611[(2)] = inst_66583);

(statearr_66592_66611[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66591 === (1))){
var state_66590__$1 = state_66590;
var statearr_66593_66612 = state_66590__$1;
(statearr_66593_66612[(2)] = null);

(statearr_66593_66612[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66591 === (4))){
var inst_66563 = (state_66590[(2)]);
var state_66590__$1 = state_66590;
var statearr_66594_66613 = state_66590__$1;
(statearr_66594_66613[(2)] = inst_66563);

(statearr_66594_66613[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66591 === (6))){
var inst_66571 = fluree.db.dbfunctions.internal._QMARK_auth_id.call(null,_QMARK_ctx);
var state_66590__$1 = state_66590;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66590__$1,(9),inst_66571);
} else {
if((state_val_66591 === (3))){
var inst_66588 = (state_66590[(2)]);
var state_66590__$1 = state_66590;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66590__$1,inst_66588);
} else {
if((state_val_66591 === (2))){
var _ = (function (){var statearr_66596 = state_66590;
(statearr_66596[(4)] = cljs.core.cons.call(null,(5),(state_66590[(4)])));

return statearr_66596;
})();
var inst_66569 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_66590__$1 = state_66590;
if(cljs.core.truth_(inst_66569)){
var statearr_66597_66614 = state_66590__$1;
(statearr_66597_66614[(1)] = (6));

} else {
var statearr_66598_66615 = state_66590__$1;
(statearr_66598_66615[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66591 === (9))){
var inst_66573 = (state_66590[(2)]);
var inst_66574 = fluree.db.util.async.throw_err.call(null,inst_66573);
var inst_66575 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66576 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66577 = ["?auth_id","?ctx",inst_66574];
var inst_66578 = cljs.core.PersistentHashMap.fromArrays(inst_66576,inst_66577);
var inst_66579 = [inst_66578,(10)];
var inst_66580 = (new cljs.core.PersistentVector(null,2,(5),inst_66575,inst_66579,null));
var inst_66581 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66580);
var state_66590__$1 = (function (){var statearr_66599 = state_66590;
(statearr_66599[(7)] = inst_66581);

return statearr_66599;
})();
var statearr_66600_66616 = state_66590__$1;
(statearr_66600_66616[(2)] = inst_66574);

(statearr_66600_66616[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66591 === (5))){
var _ = (function (){var statearr_66601 = state_66590;
(statearr_66601[(4)] = cljs.core.rest.call(null,(state_66590[(4)])));

return statearr_66601;
})();
var state_66590__$1 = state_66590;
var ex66595 = (state_66590__$1[(2)]);
var statearr_66602_66617 = state_66590__$1;
(statearr_66602_66617[(5)] = ex66595);


if((ex66595 instanceof Error)){
var statearr_66603_66618 = state_66590__$1;
(statearr_66603_66618[(1)] = (4));

(statearr_66603_66618[(5)] = null);

} else {
throw ex66595;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66591 === (8))){
var inst_66585 = (state_66590[(2)]);
var _ = (function (){var statearr_66604 = state_66590;
(statearr_66604[(4)] = cljs.core.rest.call(null,(state_66590[(4)])));

return statearr_66604;
})();
var state_66590__$1 = state_66590;
var statearr_66605_66619 = state_66590__$1;
(statearr_66605_66619[(2)] = inst_66585);

(statearr_66605_66619[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10903__auto____0 = (function (){
var statearr_66606 = [null,null,null,null,null,null,null,null];
(statearr_66606[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10903__auto__);

(statearr_66606[(1)] = (1));

return statearr_66606;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10903__auto____1 = (function (state_66590){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_66590);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e66607){var ex__10906__auto__ = e66607;
var statearr_66608_66620 = state_66590;
(statearr_66608_66620[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_66590[(4)]))){
var statearr_66609_66621 = state_66590;
(statearr_66609_66621[(1)] = cljs.core.first.call(null,(state_66590[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66622 = state_66590;
state_66590 = G__66622;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10903__auto__ = function(state_66590){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10903__auto____1.call(this,state_66590);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_66610 = f__10977__auto__.call(null);
(statearr_66610[(6)] = c__10976__auto__);

return statearr_66610;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__66624 = arguments.length;
switch (G__66624) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.call(null,_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_66666){
var state_val_66667 = (state_66666[(1)]);
if((state_val_66667 === (7))){
var state_66666__$1 = state_66666;
var statearr_66668_66698 = state_66666__$1;
(statearr_66668_66698[(2)] = seed);

(statearr_66668_66698[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66667 === (1))){
var state_66666__$1 = state_66666;
var statearr_66669_66699 = state_66666__$1;
(statearr_66669_66699[(2)] = null);

(statearr_66669_66699[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66667 === (4))){
var inst_66625 = (state_66666[(2)]);
var state_66666__$1 = state_66666;
var statearr_66670_66700 = state_66666__$1;
(statearr_66670_66700[(2)] = inst_66625);

(statearr_66670_66700[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66667 === (15))){
var state_66666__$1 = state_66666;
var statearr_66671_66701 = state_66666__$1;
(statearr_66671_66701[(2)] = (10));

(statearr_66671_66701[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66667 === (13))){
var inst_66642 = (state_66666[(2)]);
var inst_66643 = fluree.db.util.async.throw_err.call(null,inst_66642);
var state_66666__$1 = state_66666;
var statearr_66672_66702 = state_66666__$1;
(statearr_66672_66702[(2)] = inst_66643);

(statearr_66672_66702[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66667 === (6))){
var state_66666__$1 = state_66666;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66666__$1,(9),seed);
} else {
if((state_val_66667 === (3))){
var inst_66664 = (state_66666[(2)]);
var state_66666__$1 = state_66666;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66666__$1,inst_66664);
} else {
if((state_val_66667 === (12))){
var inst_66646 = (state_66666[(7)]);
var inst_66646__$1 = (state_66666[(2)]);
var state_66666__$1 = (function (){var statearr_66673 = state_66666;
(statearr_66673[(7)] = inst_66646__$1);

return statearr_66673;
})();
if(cljs.core.truth_(inst_66646__$1)){
var statearr_66674_66703 = state_66666__$1;
(statearr_66674_66703[(1)] = (14));

} else {
var statearr_66675_66704 = state_66666__$1;
(statearr_66675_66704[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66667 === (2))){
var _ = (function (){var statearr_66676 = state_66666;
(statearr_66676[(4)] = cljs.core.cons.call(null,(5),(state_66666[(4)])));

return statearr_66676;
})();
var inst_66631 = fluree.db.util.async.channel_QMARK_.call(null,seed);
var state_66666__$1 = state_66666;
if(inst_66631){
var statearr_66677_66705 = state_66666__$1;
(statearr_66677_66705[(1)] = (6));

} else {
var statearr_66678_66706 = state_66666__$1;
(statearr_66678_66706[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66667 === (11))){
var state_66666__$1 = state_66666;
var statearr_66680_66707 = state_66666__$1;
(statearr_66680_66707[(2)] = max);

(statearr_66680_66707[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66667 === (9))){
var inst_66634 = (state_66666[(2)]);
var inst_66635 = fluree.db.util.async.throw_err.call(null,inst_66634);
var state_66666__$1 = state_66666;
var statearr_66681_66708 = state_66666__$1;
(statearr_66681_66708[(2)] = inst_66635);

(statearr_66681_66708[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66667 === (5))){
var _ = (function (){var statearr_66682 = state_66666;
(statearr_66682[(4)] = cljs.core.rest.call(null,(state_66666[(4)])));

return statearr_66682;
})();
var state_66666__$1 = state_66666;
var ex66679 = (state_66666__$1[(2)]);
var statearr_66683_66709 = state_66666__$1;
(statearr_66683_66709[(5)] = ex66679);


if((ex66679 instanceof Error)){
var statearr_66684_66710 = state_66666__$1;
(statearr_66684_66710[(1)] = (4));

(statearr_66684_66710[(5)] = null);

} else {
throw ex66679;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66667 === (14))){
var inst_66646 = (state_66666[(7)]);
var state_66666__$1 = state_66666;
var statearr_66685_66711 = state_66666__$1;
(statearr_66685_66711[(2)] = inst_66646);

(statearr_66685_66711[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66667 === (16))){
var inst_66638 = (state_66666[(8)]);
var inst_66650 = (state_66666[(2)]);
var inst_66651 = fluree.db.dbfunctions.internal.rand.call(null,inst_66638,inst_66650);
var inst_66652 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66653 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66654 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66655 = [max,seed];
var inst_66656 = (new cljs.core.PersistentVector(null,2,(5),inst_66654,inst_66655,null));
var inst_66657 = ["rand",inst_66656,inst_66651];
var inst_66658 = cljs.core.PersistentHashMap.fromArrays(inst_66653,inst_66657);
var inst_66659 = [inst_66658,(10)];
var inst_66660 = (new cljs.core.PersistentVector(null,2,(5),inst_66652,inst_66659,null));
var inst_66661 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66660);
var _ = (function (){var statearr_66686 = state_66666;
(statearr_66686[(4)] = cljs.core.rest.call(null,(state_66666[(4)])));

return statearr_66686;
})();
var state_66666__$1 = (function (){var statearr_66687 = state_66666;
(statearr_66687[(9)] = inst_66661);

return statearr_66687;
})();
var statearr_66688_66712 = state_66666__$1;
(statearr_66688_66712[(2)] = inst_66651);

(statearr_66688_66712[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66667 === (10))){
var state_66666__$1 = state_66666;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66666__$1,(13),max);
} else {
if((state_val_66667 === (8))){
var inst_66638 = (state_66666[(2)]);
var inst_66639 = fluree.db.util.async.channel_QMARK_.call(null,max);
var state_66666__$1 = (function (){var statearr_66689 = state_66666;
(statearr_66689[(8)] = inst_66638);

return statearr_66689;
})();
if(inst_66639){
var statearr_66690_66713 = state_66666__$1;
(statearr_66690_66713[(1)] = (10));

} else {
var statearr_66691_66714 = state_66666__$1;
(statearr_66691_66714[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10903__auto____0 = (function (){
var statearr_66692 = [null,null,null,null,null,null,null,null,null,null];
(statearr_66692[(0)] = fluree$db$dbfunctions$fns$state_machine__10903__auto__);

(statearr_66692[(1)] = (1));

return statearr_66692;
});
var fluree$db$dbfunctions$fns$state_machine__10903__auto____1 = (function (state_66666){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_66666);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e66693){var ex__10906__auto__ = e66693;
var statearr_66694_66715 = state_66666;
(statearr_66694_66715[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_66666[(4)]))){
var statearr_66695_66716 = state_66666;
(statearr_66695_66716[(1)] = cljs.core.first.call(null,(state_66666[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66717 = state_66666;
state_66666 = G__66717;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10903__auto__ = function(state_66666){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10903__auto____1.call(this,state_66666);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_66696 = f__10977__auto__.call(null);
(statearr_66696[(6)] = c__10976__auto__);

return statearr_66696;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_66738){
var state_val_66739 = (state_66738[(1)]);
if((state_val_66739 === (1))){
var state_66738__$1 = state_66738;
var statearr_66740_66755 = state_66738__$1;
(statearr_66740_66755[(2)] = null);

(statearr_66740_66755[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66739 === (2))){
var _ = (function (){var statearr_66741 = state_66738;
(statearr_66741[(4)] = cljs.core.cons.call(null,(5),(state_66738[(4)])));

return statearr_66741;
})();
var inst_66724 = fluree.db.util.core.random_uuid.call(null);
var inst_66725 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_66724);
var inst_66726 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66727 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66728 = cljs.core.PersistentVector.EMPTY;
var inst_66729 = ["uuid",inst_66728,inst_66725];
var inst_66730 = cljs.core.PersistentHashMap.fromArrays(inst_66727,inst_66729);
var inst_66731 = [inst_66730,(10)];
var inst_66732 = (new cljs.core.PersistentVector(null,2,(5),inst_66726,inst_66731,null));
var inst_66733 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66732);
var ___$1 = (function (){var statearr_66742 = state_66738;
(statearr_66742[(4)] = cljs.core.rest.call(null,(state_66738[(4)])));

return statearr_66742;
})();
var state_66738__$1 = (function (){var statearr_66743 = state_66738;
(statearr_66743[(7)] = inst_66733);

return statearr_66743;
})();
var statearr_66744_66756 = state_66738__$1;
(statearr_66744_66756[(2)] = inst_66725);

(statearr_66744_66756[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66739 === (3))){
var inst_66736 = (state_66738[(2)]);
var state_66738__$1 = state_66738;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66738__$1,inst_66736);
} else {
if((state_val_66739 === (4))){
var inst_66718 = (state_66738[(2)]);
var state_66738__$1 = state_66738;
var statearr_66746_66757 = state_66738__$1;
(statearr_66746_66757[(2)] = inst_66718);

(statearr_66746_66757[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66739 === (5))){
var _ = (function (){var statearr_66747 = state_66738;
(statearr_66747[(4)] = cljs.core.rest.call(null,(state_66738[(4)])));

return statearr_66747;
})();
var state_66738__$1 = state_66738;
var ex66745 = (state_66738__$1[(2)]);
var statearr_66748_66758 = state_66738__$1;
(statearr_66748_66758[(5)] = ex66745);


if((ex66745 instanceof Error)){
var statearr_66749_66759 = state_66738__$1;
(statearr_66749_66759[(1)] = (4));

(statearr_66749_66759[(5)] = null);

} else {
throw ex66745;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__10903__auto____0 = (function (){
var statearr_66750 = [null,null,null,null,null,null,null,null];
(statearr_66750[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__10903__auto__);

(statearr_66750[(1)] = (1));

return statearr_66750;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__10903__auto____1 = (function (state_66738){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_66738);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e66751){var ex__10906__auto__ = e66751;
var statearr_66752_66760 = state_66738;
(statearr_66752_66760[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_66738[(4)]))){
var statearr_66753_66761 = state_66738;
(statearr_66753_66761[(1)] = cljs.core.first.call(null,(state_66738[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66762 = state_66738;
state_66738 = G__66762;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__10903__auto__ = function(state_66738){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__10903__auto____1.call(this,state_66738);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_66754 = f__10977__auto__.call(null);
(statearr_66754[(6)] = c__10976__auto__);

return statearr_66754;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_66792){
var state_val_66793 = (state_66792[(1)]);
if((state_val_66793 === (7))){
var state_66792__$1 = state_66792;
var statearr_66794_66813 = state_66792__$1;
(statearr_66794_66813[(2)] = num);

(statearr_66794_66813[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66793 === (1))){
var state_66792__$1 = state_66792;
var statearr_66795_66814 = state_66792__$1;
(statearr_66795_66814[(2)] = null);

(statearr_66795_66814[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66793 === (4))){
var inst_66763 = (state_66792[(2)]);
var state_66792__$1 = state_66792;
var statearr_66796_66815 = state_66792__$1;
(statearr_66796_66815[(2)] = inst_66763);

(statearr_66796_66815[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66793 === (6))){
var state_66792__$1 = state_66792;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66792__$1,(9),num);
} else {
if((state_val_66793 === (3))){
var inst_66790 = (state_66792[(2)]);
var state_66792__$1 = state_66792;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66792__$1,inst_66790);
} else {
if((state_val_66793 === (2))){
var _ = (function (){var statearr_66798 = state_66792;
(statearr_66798[(4)] = cljs.core.cons.call(null,(5),(state_66792[(4)])));

return statearr_66798;
})();
var inst_66769 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_66792__$1 = state_66792;
if(inst_66769){
var statearr_66799_66816 = state_66792__$1;
(statearr_66799_66816[(1)] = (6));

} else {
var statearr_66800_66817 = state_66792__$1;
(statearr_66800_66817[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66793 === (9))){
var inst_66772 = (state_66792[(2)]);
var inst_66773 = fluree.db.util.async.throw_err.call(null,inst_66772);
var state_66792__$1 = state_66792;
var statearr_66801_66818 = state_66792__$1;
(statearr_66801_66818[(2)] = inst_66773);

(statearr_66801_66818[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66793 === (5))){
var _ = (function (){var statearr_66802 = state_66792;
(statearr_66802[(4)] = cljs.core.rest.call(null,(state_66792[(4)])));

return statearr_66802;
})();
var state_66792__$1 = state_66792;
var ex66797 = (state_66792__$1[(2)]);
var statearr_66803_66819 = state_66792__$1;
(statearr_66803_66819[(5)] = ex66797);


if((ex66797 instanceof Error)){
var statearr_66804_66820 = state_66792__$1;
(statearr_66804_66820[(1)] = (4));

(statearr_66804_66820[(5)] = null);

} else {
throw ex66797;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66793 === (8))){
var inst_66776 = (state_66792[(2)]);
var inst_66777 = fluree.db.dbfunctions.internal.ceil.call(null,inst_66776);
var inst_66778 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66779 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66780 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66781 = [fluree.db.dbfunctions.fns.ceil];
var inst_66782 = (new cljs.core.PersistentVector(null,1,(5),inst_66780,inst_66781,null));
var inst_66783 = ["",inst_66782,inst_66777];
var inst_66784 = cljs.core.PersistentHashMap.fromArrays(inst_66779,inst_66783);
var inst_66785 = [inst_66784,(10)];
var inst_66786 = (new cljs.core.PersistentVector(null,2,(5),inst_66778,inst_66785,null));
var inst_66787 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66786);
var _ = (function (){var statearr_66805 = state_66792;
(statearr_66805[(4)] = cljs.core.rest.call(null,(state_66792[(4)])));

return statearr_66805;
})();
var state_66792__$1 = (function (){var statearr_66806 = state_66792;
(statearr_66806[(7)] = inst_66787);

return statearr_66806;
})();
var statearr_66807_66821 = state_66792__$1;
(statearr_66807_66821[(2)] = inst_66777);

(statearr_66807_66821[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__10903__auto____0 = (function (){
var statearr_66808 = [null,null,null,null,null,null,null,null];
(statearr_66808[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__10903__auto__);

(statearr_66808[(1)] = (1));

return statearr_66808;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__10903__auto____1 = (function (state_66792){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_66792);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e66809){var ex__10906__auto__ = e66809;
var statearr_66810_66822 = state_66792;
(statearr_66810_66822[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_66792[(4)]))){
var statearr_66811_66823 = state_66792;
(statearr_66811_66823[(1)] = cljs.core.first.call(null,(state_66792[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66824 = state_66792;
state_66792 = G__66824;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__10903__auto__ = function(state_66792){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__10903__auto____1.call(this,state_66792);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_66812 = f__10977__auto__.call(null);
(statearr_66812[(6)] = c__10976__auto__);

return statearr_66812;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_66854){
var state_val_66855 = (state_66854[(1)]);
if((state_val_66855 === (7))){
var state_66854__$1 = state_66854;
var statearr_66856_66875 = state_66854__$1;
(statearr_66856_66875[(2)] = num);

(statearr_66856_66875[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66855 === (1))){
var state_66854__$1 = state_66854;
var statearr_66857_66876 = state_66854__$1;
(statearr_66857_66876[(2)] = null);

(statearr_66857_66876[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66855 === (4))){
var inst_66825 = (state_66854[(2)]);
var state_66854__$1 = state_66854;
var statearr_66858_66877 = state_66854__$1;
(statearr_66858_66877[(2)] = inst_66825);

(statearr_66858_66877[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66855 === (6))){
var state_66854__$1 = state_66854;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66854__$1,(9),num);
} else {
if((state_val_66855 === (3))){
var inst_66852 = (state_66854[(2)]);
var state_66854__$1 = state_66854;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66854__$1,inst_66852);
} else {
if((state_val_66855 === (2))){
var _ = (function (){var statearr_66860 = state_66854;
(statearr_66860[(4)] = cljs.core.cons.call(null,(5),(state_66854[(4)])));

return statearr_66860;
})();
var inst_66831 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_66854__$1 = state_66854;
if(inst_66831){
var statearr_66861_66878 = state_66854__$1;
(statearr_66861_66878[(1)] = (6));

} else {
var statearr_66862_66879 = state_66854__$1;
(statearr_66862_66879[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66855 === (9))){
var inst_66834 = (state_66854[(2)]);
var inst_66835 = fluree.db.util.async.throw_err.call(null,inst_66834);
var state_66854__$1 = state_66854;
var statearr_66863_66880 = state_66854__$1;
(statearr_66863_66880[(2)] = inst_66835);

(statearr_66863_66880[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66855 === (5))){
var _ = (function (){var statearr_66864 = state_66854;
(statearr_66864[(4)] = cljs.core.rest.call(null,(state_66854[(4)])));

return statearr_66864;
})();
var state_66854__$1 = state_66854;
var ex66859 = (state_66854__$1[(2)]);
var statearr_66865_66881 = state_66854__$1;
(statearr_66865_66881[(5)] = ex66859);


if((ex66859 instanceof Error)){
var statearr_66866_66882 = state_66854__$1;
(statearr_66866_66882[(1)] = (4));

(statearr_66866_66882[(5)] = null);

} else {
throw ex66859;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66855 === (8))){
var inst_66838 = (state_66854[(2)]);
var inst_66839 = fluree.db.dbfunctions.internal.floor.call(null,inst_66838);
var inst_66840 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66841 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66842 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66843 = [fluree.db.dbfunctions.fns.floor];
var inst_66844 = (new cljs.core.PersistentVector(null,1,(5),inst_66842,inst_66843,null));
var inst_66845 = ["",inst_66844,inst_66839];
var inst_66846 = cljs.core.PersistentHashMap.fromArrays(inst_66841,inst_66845);
var inst_66847 = [inst_66846,(10)];
var inst_66848 = (new cljs.core.PersistentVector(null,2,(5),inst_66840,inst_66847,null));
var inst_66849 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66848);
var _ = (function (){var statearr_66867 = state_66854;
(statearr_66867[(4)] = cljs.core.rest.call(null,(state_66854[(4)])));

return statearr_66867;
})();
var state_66854__$1 = (function (){var statearr_66868 = state_66854;
(statearr_66868[(7)] = inst_66849);

return statearr_66868;
})();
var statearr_66869_66883 = state_66854__$1;
(statearr_66869_66883[(2)] = inst_66839);

(statearr_66869_66883[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__10903__auto____0 = (function (){
var statearr_66870 = [null,null,null,null,null,null,null,null];
(statearr_66870[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__10903__auto__);

(statearr_66870[(1)] = (1));

return statearr_66870;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__10903__auto____1 = (function (state_66854){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_66854);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e66871){var ex__10906__auto__ = e66871;
var statearr_66872_66884 = state_66854;
(statearr_66872_66884[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_66854[(4)]))){
var statearr_66873_66885 = state_66854;
(statearr_66873_66885[(1)] = cljs.core.first.call(null,(state_66854[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66886 = state_66854;
state_66854 = G__66886;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__10903__auto__ = function(state_66854){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__10903__auto____1.call(this,state_66854);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_66874 = f__10977__auto__.call(null);
(statearr_66874[(6)] = c__10976__auto__);

return statearr_66874;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_66911){
var state_val_66912 = (state_66911[(1)]);
if((state_val_66912 === (1))){
var state_66911__$1 = state_66911;
var statearr_66913_66928 = state_66911__$1;
(statearr_66913_66928[(2)] = null);

(statearr_66913_66928[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66912 === (2))){
var _ = (function (){var statearr_66914 = state_66911;
(statearr_66914[(4)] = cljs.core.cons.call(null,(5),(state_66911[(4)])));

return statearr_66914;
})();
var inst_66893 = fluree.db.dbfunctions.internal.cas.call(null,_QMARK_ctx,compare_val,new_val);
var state_66911__$1 = state_66911;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66911__$1,(6),inst_66893);
} else {
if((state_val_66912 === (3))){
var inst_66909 = (state_66911[(2)]);
var state_66911__$1 = state_66911;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66911__$1,inst_66909);
} else {
if((state_val_66912 === (4))){
var inst_66887 = (state_66911[(2)]);
var state_66911__$1 = state_66911;
var statearr_66916_66929 = state_66911__$1;
(statearr_66916_66929[(2)] = inst_66887);

(statearr_66916_66929[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66912 === (5))){
var _ = (function (){var statearr_66917 = state_66911;
(statearr_66917[(4)] = cljs.core.rest.call(null,(state_66911[(4)])));

return statearr_66917;
})();
var state_66911__$1 = state_66911;
var ex66915 = (state_66911__$1[(2)]);
var statearr_66918_66930 = state_66911__$1;
(statearr_66918_66930[(5)] = ex66915);


if((ex66915 instanceof Error)){
var statearr_66919_66931 = state_66911__$1;
(statearr_66919_66931[(1)] = (4));

(statearr_66919_66931[(5)] = null);

} else {
throw ex66915;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66912 === (6))){
var inst_66895 = (state_66911[(2)]);
var inst_66896 = fluree.db.util.async.throw_err.call(null,inst_66895);
var inst_66897 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66898 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66899 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66900 = [compare_val,new_val];
var inst_66901 = (new cljs.core.PersistentVector(null,2,(5),inst_66899,inst_66900,null));
var inst_66902 = ["",inst_66901,inst_66896];
var inst_66903 = cljs.core.PersistentHashMap.fromArrays(inst_66898,inst_66902);
var inst_66904 = [inst_66903,(10)];
var inst_66905 = (new cljs.core.PersistentVector(null,2,(5),inst_66897,inst_66904,null));
var inst_66906 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_66905);
var _ = (function (){var statearr_66920 = state_66911;
(statearr_66920[(4)] = cljs.core.rest.call(null,(state_66911[(4)])));

return statearr_66920;
})();
var state_66911__$1 = (function (){var statearr_66921 = state_66911;
(statearr_66921[(7)] = inst_66906);

return statearr_66921;
})();
var statearr_66922_66932 = state_66911__$1;
(statearr_66922_66932[(2)] = inst_66896);

(statearr_66922_66932[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__10903__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__10903__auto____0 = (function (){
var statearr_66923 = [null,null,null,null,null,null,null,null];
(statearr_66923[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__10903__auto__);

(statearr_66923[(1)] = (1));

return statearr_66923;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__10903__auto____1 = (function (state_66911){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_66911);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e66924){var ex__10906__auto__ = e66924;
var statearr_66925_66933 = state_66911;
(statearr_66925_66933[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_66911[(4)]))){
var statearr_66926_66934 = state_66911;
(statearr_66926_66934[(1)] = cljs.core.first.call(null,(state_66911[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66935 = state_66911;
state_66911 = G__66935;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__10903__auto__ = function(state_66911){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__10903__auto____1.call(this,state_66911);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__10903__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__10903__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_66927 = f__10977__auto__.call(null);
(statearr_66927[(6)] = c__10976__auto__);

return statearr_66927;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
