// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.call(null,new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt.call(null,secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__72634 = arguments.length;
switch (G__72634) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_72676){
var state_val_72677 = (state_72676[(1)]);
if((state_val_72677 === (7))){
var inst_72646 = typeof user === 'string';
var state_72676__$1 = state_72676;
if(cljs.core.truth_(inst_72646)){
var statearr_72678_72707 = state_72676__$1;
(statearr_72678_72707[(1)] = (9));

} else {
var statearr_72679_72708 = state_72676__$1;
(statearr_72679_72708[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72677 === (1))){
var state_72676__$1 = state_72676;
var statearr_72680_72709 = state_72676__$1;
(statearr_72680_72709[(2)] = null);

(statearr_72680_72709[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72677 === (4))){
var inst_72635 = (state_72676[(2)]);
var inst_72636 = fluree.db.util.log.error.call(null,inst_72635);
var inst_72637 = reject.call(null,inst_72635);
var state_72676__$1 = (function (){var statearr_72681 = state_72676;
(statearr_72681[(7)] = inst_72636);

return statearr_72681;
})();
var statearr_72682_72710 = state_72676__$1;
(statearr_72682_72710[(2)] = inst_72637);

(statearr_72682_72710[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72677 === (15))){
var inst_72665 = (state_72676[(2)]);
var inst_72666 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_72665);
var inst_72667 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72668 = cljs.core.constantly.call(null,inst_72666);
var inst_72669 = cljs.core.swap_BANG_.call(null,inst_72667,inst_72668);
var inst_72670 = fluree.db.connection.add_token.call(null,conn,inst_72666);
var inst_72671 = resolve.call(null,inst_72665);
var _ = (function (){var statearr_72683 = state_72676;
(statearr_72683[(4)] = cljs.core.rest.call(null,(state_72676[(4)])));

return statearr_72683;
})();
var state_72676__$1 = (function (){var statearr_72684 = state_72676;
(statearr_72684[(8)] = inst_72669);

(statearr_72684[(9)] = inst_72670);

return statearr_72684;
})();
var statearr_72685_72711 = state_72676__$1;
(statearr_72685_72711[(2)] = inst_72671);

(statearr_72685_72711[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72677 === (13))){
var state_72676__$1 = state_72676;
var statearr_72686_72712 = state_72676__$1;
(statearr_72686_72712[(2)] = null);

(statearr_72686_72712[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72677 === (6))){
var state_72676__$1 = state_72676;
var statearr_72687_72713 = state_72676__$1;
(statearr_72687_72713[(2)] = user);

(statearr_72687_72713[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72677 === (3))){
var inst_72674 = (state_72676[(2)]);
var state_72676__$1 = state_72676;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72676__$1,inst_72674);
} else {
if((state_val_72677 === (12))){
var state_72676__$1 = state_72676;
var statearr_72688_72714 = state_72676__$1;
(statearr_72688_72714[(2)] = user);

(statearr_72688_72714[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72677 === (2))){
var _ = (function (){var statearr_72689 = state_72676;
(statearr_72689[(4)] = cljs.core.cons.call(null,(5),(state_72676[(4)])));

return statearr_72689;
})();
var inst_72643 = typeof user === 'number';
var state_72676__$1 = state_72676;
if(cljs.core.truth_(inst_72643)){
var statearr_72690_72715 = state_72676__$1;
(statearr_72690_72715[(1)] = (6));

} else {
var statearr_72691_72716 = state_72676__$1;
(statearr_72691_72716[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72677 === (11))){
var inst_72657 = (state_72676[(2)]);
var state_72676__$1 = state_72676;
var statearr_72693_72717 = state_72676__$1;
(statearr_72693_72717[(2)] = inst_72657);

(statearr_72693_72717[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72677 === (9))){
var inst_72648 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72649 = ["_user/username",user];
var inst_72650 = (new cljs.core.PersistentVector(null,2,(5),inst_72648,inst_72649,null));
var state_72676__$1 = state_72676;
var statearr_72694_72718 = state_72676__$1;
(statearr_72694_72718[(2)] = inst_72650);

(statearr_72694_72718[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72677 === (5))){
var _ = (function (){var statearr_72695 = state_72676;
(statearr_72695[(4)] = cljs.core.rest.call(null,(state_72676[(4)])));

return statearr_72695;
})();
var state_72676__$1 = state_72676;
var ex72692 = (state_72676__$1[(2)]);
var statearr_72696_72719 = state_72676__$1;
(statearr_72696_72719[(5)] = ex72692);


var statearr_72697_72720 = state_72676__$1;
(statearr_72697_72720[(1)] = (4));

(statearr_72697_72720[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72677 === (14))){
var inst_72655 = (state_72676[(2)]);
var state_72676__$1 = state_72676;
var statearr_72698_72721 = state_72676__$1;
(statearr_72698_72721[(2)] = inst_72655);

(statearr_72698_72721[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72677 === (10))){
var state_72676__$1 = state_72676;
var statearr_72699_72722 = state_72676__$1;
(statearr_72699_72722[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72677 === (8))){
var inst_72659 = (state_72676[(2)]);
var inst_72660 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_72661 = [account,inst_72659,password,expireSeconds,syncTo];
var inst_72662 = cljs.core.PersistentHashMap.fromArrays(inst_72660,inst_72661);
var inst_72663 = fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_72662);
var state_72676__$1 = state_72676;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72676__$1,(15),inst_72663);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__10903__auto__ = null;
var fluree$db$connection_js$state_machine__10903__auto____0 = (function (){
var statearr_72701 = [null,null,null,null,null,null,null,null,null,null];
(statearr_72701[(0)] = fluree$db$connection_js$state_machine__10903__auto__);

(statearr_72701[(1)] = (1));

return statearr_72701;
});
var fluree$db$connection_js$state_machine__10903__auto____1 = (function (state_72676){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_72676);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e72702){var ex__10906__auto__ = e72702;
var statearr_72703_72723 = state_72676;
(statearr_72703_72723[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_72676[(4)]))){
var statearr_72704_72724 = state_72676;
(statearr_72704_72724[(1)] = cljs.core.first.call(null,(state_72676[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72725 = state_72676;
state_72676 = G__72725;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__10903__auto__ = function(state_72676){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__10903__auto____1.call(this,state_72676);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__10903__auto____0;
fluree$db$connection_js$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__10903__auto____1;
return fluree$db$connection_js$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_72705 = f__10977__auto__.call(null);
(statearr_72705[(6)] = c__10976__auto__);

return statearr_72705;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__72727 = arguments.length;
switch (G__72727) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,fluree.db.connection.connect.call(null,servers_string,opts),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.call(null);
var _ = (function (){var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_72736){
var state_val_72737 = (state_72736[(1)]);
if((state_val_72737 === (1))){
var inst_72728 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72729 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72730 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_72731 = (new cljs.core.PersistentVector(null,4,(5),inst_72729,inst_72730,null));
var inst_72732 = cljs.core.async.put_BANG_.call(null,inst_72728,inst_72731);
var inst_72733 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__72738 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__72739 = null;
var count__72740 = (0);
var i__72741 = (0);
while(true){
if((i__72741 < count__72740)){
var k = cljs.core._nth.call(null,chunk__72739,i__72741);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__72749 = seq__72738;
var G__72750 = chunk__72739;
var G__72751 = count__72740;
var G__72752 = (i__72741 + (1));
seq__72738 = G__72749;
chunk__72739 = G__72750;
count__72740 = G__72751;
i__72741 = G__72752;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__72738);
if(temp__5753__auto__){
var seq__72738__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__72738__$1)){
var c__4679__auto__ = cljs.core.chunk_first.call(null,seq__72738__$1);
var G__72753 = cljs.core.chunk_rest.call(null,seq__72738__$1);
var G__72754 = c__4679__auto__;
var G__72755 = cljs.core.count.call(null,c__4679__auto__);
var G__72756 = (0);
seq__72738 = G__72753;
chunk__72739 = G__72754;
count__72740 = G__72755;
i__72741 = G__72756;
continue;
} else {
var k = cljs.core.first.call(null,seq__72738__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__72757 = cljs.core.next.call(null,seq__72738__$1);
var G__72758 = null;
var G__72759 = (0);
var G__72760 = (0);
seq__72738 = G__72757;
chunk__72739 = G__72758;
count__72740 = G__72759;
i__72741 = G__72760;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_72734 = cljs.core.async.take_BANG_.call(null,pc,inst_72733);
var state_72736__$1 = (function (){var statearr_72742 = state_72736;
(statearr_72742[(7)] = inst_72732);

return statearr_72742;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72736__$1,inst_72734);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__10903__auto__ = null;
var fluree$db$connection_js$state_machine__10903__auto____0 = (function (){
var statearr_72743 = [null,null,null,null,null,null,null,null];
(statearr_72743[(0)] = fluree$db$connection_js$state_machine__10903__auto__);

(statearr_72743[(1)] = (1));

return statearr_72743;
});
var fluree$db$connection_js$state_machine__10903__auto____1 = (function (state_72736){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_72736);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e72744){var ex__10906__auto__ = e72744;
var statearr_72745_72761 = state_72736;
(statearr_72745_72761[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_72736[(4)]))){
var statearr_72746_72762 = state_72736;
(statearr_72746_72762[(1)] = cljs.core.first.call(null,(state_72736[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72763 = state_72736;
state_72736 = G__72763;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__10903__auto__ = function(state_72736){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__10903__auto____1.call(this,state_72736);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__10903__auto____0;
fluree$db$connection_js$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__10903__auto____1;
return fluree$db$connection_js$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_72747 = f__10977__auto__.call(null);
(statearr_72747[(6)] = c__10976__auto__);

return statearr_72747;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__72765 = arguments.length;
switch (G__72765) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_72799){
var state_val_72800 = (state_72799[(1)]);
if((state_val_72800 === (1))){
var state_72799__$1 = state_72799;
var statearr_72801_72822 = state_72799__$1;
(statearr_72801_72822[(2)] = null);

(statearr_72801_72822[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72800 === (2))){
var _ = (function (){var statearr_72802 = state_72799;
(statearr_72802[(4)] = cljs.core.cons.call(null,(5),(state_72799[(4)])));

return statearr_72802;
})();
var inst_72774 = fluree.db.connection.connect.call(null,servers_string,opts);
var inst_72775 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72776 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_72777 = (new cljs.core.PersistentVector(null,1,(5),inst_72775,inst_72776,null));
var inst_72778 = cljs.core.PersistentHashMap.EMPTY;
var inst_72779 = cljs.core.atom.call(null,inst_72778);
var inst_72780 = cljs.core.assoc_in.call(null,inst_72774,inst_72777,inst_72779);
var inst_72781 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72782 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_72783 = (new cljs.core.PersistentVector(null,1,(5),inst_72781,inst_72782,null));
var inst_72784 = cljs.core.PersistentHashMap.EMPTY;
var inst_72785 = cljs.core.atom.call(null,inst_72784);
var inst_72786 = cljs.core.assoc_in.call(null,inst_72780,inst_72783,inst_72785);
var inst_72787 = cljs.core.async.promise_chan.call(null);
var inst_72788 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_72786);
var inst_72789 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72790 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_72787,null];
var inst_72791 = (new cljs.core.PersistentVector(null,4,(5),inst_72789,inst_72790,null));
var inst_72792 = cljs.core.async.put_BANG_.call(null,inst_72788,inst_72791);
var inst_72793 = (function (){var conn = inst_72786;
var pc = inst_72787;
return (function (x){
if((x == null)){
} else {
var seq__72803_72823 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__72804_72824 = null;
var count__72805_72825 = (0);
var i__72806_72826 = (0);
while(true){
if((i__72806_72826 < count__72805_72825)){
var k_72827 = cljs.core._nth.call(null,chunk__72804_72824,i__72806_72826);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_72827], null),cljs.core.get.call(null,x,k_72827,null));


var G__72828 = seq__72803_72823;
var G__72829 = chunk__72804_72824;
var G__72830 = count__72805_72825;
var G__72831 = (i__72806_72826 + (1));
seq__72803_72823 = G__72828;
chunk__72804_72824 = G__72829;
count__72805_72825 = G__72830;
i__72806_72826 = G__72831;
continue;
} else {
var temp__5753__auto___72832 = cljs.core.seq.call(null,seq__72803_72823);
if(temp__5753__auto___72832){
var seq__72803_72833__$1 = temp__5753__auto___72832;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__72803_72833__$1)){
var c__4679__auto___72834 = cljs.core.chunk_first.call(null,seq__72803_72833__$1);
var G__72835 = cljs.core.chunk_rest.call(null,seq__72803_72833__$1);
var G__72836 = c__4679__auto___72834;
var G__72837 = cljs.core.count.call(null,c__4679__auto___72834);
var G__72838 = (0);
seq__72803_72823 = G__72835;
chunk__72804_72824 = G__72836;
count__72805_72825 = G__72837;
i__72806_72826 = G__72838;
continue;
} else {
var k_72839 = cljs.core.first.call(null,seq__72803_72833__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_72839], null),cljs.core.get.call(null,x,k_72839,null));


var G__72840 = cljs.core.next.call(null,seq__72803_72833__$1);
var G__72841 = null;
var G__72842 = (0);
var G__72843 = (0);
seq__72803_72823 = G__72840;
chunk__72804_72824 = G__72841;
count__72805_72825 = G__72842;
i__72806_72826 = G__72843;
continue;
}
} else {
}
}
break;
}
}

return resolve.call(null,conn);
});
})();
var inst_72794 = cljs.core.async.take_BANG_.call(null,inst_72787,inst_72793);
var ___$1 = (function (){var statearr_72807 = state_72799;
(statearr_72807[(4)] = cljs.core.rest.call(null,(state_72799[(4)])));

return statearr_72807;
})();
var state_72799__$1 = (function (){var statearr_72808 = state_72799;
(statearr_72808[(7)] = inst_72792);

return statearr_72808;
})();
var statearr_72809_72844 = state_72799__$1;
(statearr_72809_72844[(2)] = inst_72794);

(statearr_72809_72844[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72800 === (3))){
var inst_72797 = (state_72799[(2)]);
var state_72799__$1 = state_72799;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72799__$1,inst_72797);
} else {
if((state_val_72800 === (4))){
var inst_72766 = (state_72799[(2)]);
var inst_72767 = fluree.db.util.log.error.call(null,inst_72766);
var inst_72768 = reject.call(null,inst_72766);
var state_72799__$1 = (function (){var statearr_72811 = state_72799;
(statearr_72811[(8)] = inst_72767);

return statearr_72811;
})();
var statearr_72812_72845 = state_72799__$1;
(statearr_72812_72845[(2)] = inst_72768);

(statearr_72812_72845[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72800 === (5))){
var _ = (function (){var statearr_72813 = state_72799;
(statearr_72813[(4)] = cljs.core.rest.call(null,(state_72799[(4)])));

return statearr_72813;
})();
var state_72799__$1 = state_72799;
var ex72810 = (state_72799__$1[(2)]);
var statearr_72814_72846 = state_72799__$1;
(statearr_72814_72846[(5)] = ex72810);


var statearr_72815_72847 = state_72799__$1;
(statearr_72815_72847[(1)] = (4));

(statearr_72815_72847[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__10903__auto__ = null;
var fluree$db$connection_js$state_machine__10903__auto____0 = (function (){
var statearr_72816 = [null,null,null,null,null,null,null,null,null];
(statearr_72816[(0)] = fluree$db$connection_js$state_machine__10903__auto__);

(statearr_72816[(1)] = (1));

return statearr_72816;
});
var fluree$db$connection_js$state_machine__10903__auto____1 = (function (state_72799){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_72799);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e72817){var ex__10906__auto__ = e72817;
var statearr_72818_72848 = state_72799;
(statearr_72818_72848[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_72799[(4)]))){
var statearr_72819_72849 = state_72799;
(statearr_72819_72849[(1)] = cljs.core.first.call(null,(state_72799[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72850 = state_72799;
state_72799 = G__72850;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__10903__auto__ = function(state_72799){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__10903__auto____1.call(this,state_72799);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__10903__auto____0;
fluree$db$connection_js$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__10903__auto____1;
return fluree$db$connection_js$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_72820 = f__10977__auto__.call(null);
(statearr_72820[(6)] = c__10976__auto__);

return statearr_72820;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_.call(null,conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__72852 = arguments.length;
switch (G__72852) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.call(null,conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not.call(null,open_api_QMARK_)) && (cljs.core.not.call(null,has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.call(null,"To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token.call(null,conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__72854 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__72854,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__72854,(1),null);
var cb_STAR_ = (function (header,data){
return callback.call(null,cljs.core.clj__GT_js.call(null,header),cljs.core.clj__GT_js.call(null,data));
});
return fluree.db.connection.add_listener.call(null,conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__72857 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__72857,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__72857,(1),null);
return fluree.db.connection.remove_listener.call(null,conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js.call(null,fluree.db.connection.listeners.call(null,conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_72910){
var state_val_72911 = (state_72910[(1)]);
if((state_val_72911 === (7))){
var inst_72871 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72872 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_72873 = cljs.core.PersistentHashMap.fromArrays(inst_72871,inst_72872);
var inst_72874 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_72873);
var inst_72875 = (function(){throw inst_72874})();
var state_72910__$1 = state_72910;
var statearr_72912_72941 = state_72910__$1;
(statearr_72912_72941[(2)] = inst_72875);

(statearr_72912_72941[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72911 === (1))){
var state_72910__$1 = state_72910;
var statearr_72913_72942 = state_72910__$1;
(statearr_72913_72942[(2)] = null);

(statearr_72913_72942[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72911 === (4))){
var inst_72860 = (state_72910[(2)]);
var inst_72861 = cljs.core.clj__GT_js.call(null,inst_72860);
var inst_72862 = reject.call(null,inst_72861);
var state_72910__$1 = state_72910;
var statearr_72914_72943 = state_72910__$1;
(statearr_72914_72943[(2)] = inst_72862);

(statearr_72914_72943[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72911 === (13))){
var inst_72889 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72890 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_72891 = cljs.core.PersistentHashMap.fromArrays(inst_72889,inst_72890);
var inst_72892 = cljs.core.ex_info.call(null,"A password must be supplied.",inst_72891);
var inst_72893 = (function(){throw inst_72892})();
var state_72910__$1 = state_72910;
var statearr_72915_72944 = state_72910__$1;
(statearr_72915_72944[(2)] = inst_72893);

(statearr_72915_72944[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72911 === (6))){
var state_72910__$1 = state_72910;
var statearr_72916_72945 = state_72910__$1;
(statearr_72916_72945[(2)] = null);

(statearr_72916_72945[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72911 === (3))){
var inst_72908 = (state_72910[(2)]);
var state_72910__$1 = state_72910;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72910__$1,inst_72908);
} else {
if((state_val_72911 === (12))){
var state_72910__$1 = state_72910;
var statearr_72917_72946 = state_72910__$1;
(statearr_72917_72946[(2)] = null);

(statearr_72917_72946[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72911 === (2))){
var _ = (function (){var statearr_72918 = state_72910;
(statearr_72918[(4)] = cljs.core.cons.call(null,(5),(state_72910[(4)])));

return statearr_72918;
})();
var inst_72868 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_72910__$1 = state_72910;
if(cljs.core.truth_(inst_72868)){
var statearr_72919_72947 = state_72910__$1;
(statearr_72919_72947[(1)] = (6));

} else {
var statearr_72920_72948 = state_72910__$1;
(statearr_72920_72948[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72911 === (11))){
var inst_72886 = (state_72910[(2)]);
var state_72910__$1 = (function (){var statearr_72922 = state_72910;
(statearr_72922[(7)] = inst_72886);

return statearr_72922;
})();
if(cljs.core.truth_(password)){
var statearr_72923_72949 = state_72910__$1;
(statearr_72923_72949[(1)] = (12));

} else {
var statearr_72924_72950 = state_72910__$1;
(statearr_72924_72950[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72911 === (9))){
var state_72910__$1 = state_72910;
var statearr_72925_72951 = state_72910__$1;
(statearr_72925_72951[(2)] = null);

(statearr_72925_72951[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72911 === (5))){
var _ = (function (){var statearr_72926 = state_72910;
(statearr_72926[(4)] = cljs.core.rest.call(null,(state_72910[(4)])));

return statearr_72926;
})();
var state_72910__$1 = state_72910;
var ex72921 = (state_72910__$1[(2)]);
var statearr_72927_72952 = state_72910__$1;
(statearr_72927_72952[(5)] = ex72921);


var statearr_72928_72953 = state_72910__$1;
(statearr_72928_72953[(1)] = (4));

(statearr_72928_72953[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72911 === (14))){
var inst_72895 = (state_72910[(2)]);
var inst_72896 = cljs.core.assoc.call(null,map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,new cljs.core.Keyword(null,"password","password",417022471),password);
var inst_72897 = fluree.db.util.core.without_nils.call(null,inst_72896);
var inst_72898 = cljs.core.async.promise_chan.call(null);
var inst_72899 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72900 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72901 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_72897,inst_72898,null];
var inst_72902 = (new cljs.core.PersistentVector(null,4,(5),inst_72900,inst_72901,null));
var inst_72903 = cljs.core.async.put_BANG_.call(null,inst_72899,inst_72902);
var inst_72904 = (function (){var _ = inst_72895;
var data = inst_72897;
var pc = inst_72898;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_72905 = cljs.core.async.take_BANG_.call(null,inst_72898,inst_72904);
var _ = (function (){var statearr_72929 = state_72910;
(statearr_72929[(4)] = cljs.core.rest.call(null,(state_72910[(4)])));

return statearr_72929;
})();
var state_72910__$1 = (function (){var statearr_72930 = state_72910;
(statearr_72930[(8)] = inst_72903);

return statearr_72930;
})();
var statearr_72931_72954 = state_72910__$1;
(statearr_72931_72954[(2)] = inst_72905);

(statearr_72931_72954[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72911 === (10))){
var inst_72880 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72881 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_72882 = cljs.core.PersistentHashMap.fromArrays(inst_72880,inst_72881);
var inst_72883 = cljs.core.ex_info.call(null,"A ledger must be supplied.",inst_72882);
var inst_72884 = (function(){throw inst_72883})();
var state_72910__$1 = state_72910;
var statearr_72932_72955 = state_72910__$1;
(statearr_72932_72955[(2)] = inst_72884);

(statearr_72932_72955[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72911 === (8))){
var inst_72877 = (state_72910[(2)]);
var state_72910__$1 = (function (){var statearr_72933 = state_72910;
(statearr_72933[(9)] = inst_72877);

return statearr_72933;
})();
if(cljs.core.truth_(ledger)){
var statearr_72934_72956 = state_72910__$1;
(statearr_72934_72956[(1)] = (9));

} else {
var statearr_72935_72957 = state_72910__$1;
(statearr_72935_72957[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__10903__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__10903__auto____0 = (function (){
var statearr_72936 = [null,null,null,null,null,null,null,null,null,null];
(statearr_72936[(0)] = fluree$db$connection_js$password_generate_$_state_machine__10903__auto__);

(statearr_72936[(1)] = (1));

return statearr_72936;
});
var fluree$db$connection_js$password_generate_$_state_machine__10903__auto____1 = (function (state_72910){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_72910);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e72937){var ex__10906__auto__ = e72937;
var statearr_72938_72958 = state_72910;
(statearr_72938_72958[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_72910[(4)]))){
var statearr_72939_72959 = state_72910;
(statearr_72939_72959[(1)] = cljs.core.first.call(null,(state_72910[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72960 = state_72910;
state_72910 = G__72960;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__10903__auto__ = function(state_72910){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__10903__auto____1.call(this,state_72910);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__10903__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__10903__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_72940 = f__10977__auto__.call(null);
(statearr_72940[(6)] = c__10976__auto__);

return statearr_72940;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__72962 = arguments.length;
switch (G__72962) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_73029){
var state_val_73030 = (state_73029[(1)]);
if((state_val_73030 === (7))){
var inst_72974 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72975 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_72976 = cljs.core.PersistentHashMap.fromArrays(inst_72974,inst_72975);
var inst_72977 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_72976);
var inst_72978 = (function(){throw inst_72977})();
var state_73029__$1 = state_73029;
var statearr_73031_73070 = state_73029__$1;
(statearr_73031_73070[(2)] = inst_72978);

(statearr_73031_73070[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73030 === (20))){
var inst_73012 = (state_73029[(2)]);
var inst_73013 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_73014 = [ledger,password,user,auth,expire];
var inst_73015 = cljs.core.PersistentHashMap.fromArrays(inst_73013,inst_73014);
var inst_73016 = fluree.db.util.core.without_nils.call(null,inst_73015);
var inst_73017 = cljs.core.async.promise_chan.call(null);
var inst_73018 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73019 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73020 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_73016,inst_73017,null];
var inst_73021 = (new cljs.core.PersistentVector(null,4,(5),inst_73019,inst_73020,null));
var inst_73022 = cljs.core.async.put_BANG_.call(null,inst_73018,inst_73021);
var inst_73023 = (function (){var _ = inst_73012;
var data = inst_73016;
var pc = inst_73017;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
fluree.db.connection.add_token.call(null,conn,result);

return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_73024 = cljs.core.async.take_BANG_.call(null,inst_73017,inst_73023);
var _ = (function (){var statearr_73032 = state_73029;
(statearr_73032[(4)] = cljs.core.rest.call(null,(state_73029[(4)])));

return statearr_73032;
})();
var state_73029__$1 = (function (){var statearr_73033 = state_73029;
(statearr_73033[(7)] = inst_73022);

return statearr_73033;
})();
var statearr_73034_73071 = state_73029__$1;
(statearr_73034_73071[(2)] = inst_73024);

(statearr_73034_73071[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73030 === (1))){
var state_73029__$1 = state_73029;
var statearr_73035_73072 = state_73029__$1;
(statearr_73035_73072[(2)] = null);

(statearr_73035_73072[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73030 === (4))){
var inst_72963 = (state_73029[(2)]);
var inst_72964 = cljs.core.clj__GT_js.call(null,inst_72963);
var inst_72965 = reject.call(null,inst_72964);
var state_73029__$1 = state_73029;
var statearr_73036_73073 = state_73029__$1;
(statearr_73036_73073[(2)] = inst_72965);

(statearr_73036_73073[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73030 === (15))){
var inst_72999 = (state_73029[(8)]);
var state_73029__$1 = state_73029;
var statearr_73037_73074 = state_73029__$1;
(statearr_73037_73074[(2)] = inst_72999);

(statearr_73037_73074[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73030 === (13))){
var inst_72992 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72993 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_72994 = cljs.core.PersistentHashMap.fromArrays(inst_72992,inst_72993);
var inst_72995 = cljs.core.ex_info.call(null,"A password must be supplied in the provided JSON.",inst_72994);
var inst_72996 = (function(){throw inst_72995})();
var state_73029__$1 = state_73029;
var statearr_73038_73075 = state_73029__$1;
(statearr_73038_73075[(2)] = inst_72996);

(statearr_73038_73075[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73030 === (6))){
var state_73029__$1 = state_73029;
var statearr_73039_73076 = state_73029__$1;
(statearr_73039_73076[(2)] = null);

(statearr_73039_73076[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73030 === (17))){
var inst_73003 = (state_73029[(2)]);
var state_73029__$1 = state_73029;
if(cljs.core.truth_(inst_73003)){
var statearr_73040_73077 = state_73029__$1;
(statearr_73040_73077[(1)] = (18));

} else {
var statearr_73041_73078 = state_73029__$1;
(statearr_73041_73078[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73030 === (3))){
var inst_73027 = (state_73029[(2)]);
var state_73029__$1 = state_73029;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73029__$1,inst_73027);
} else {
if((state_val_73030 === (12))){
var state_73029__$1 = state_73029;
var statearr_73042_73079 = state_73029__$1;
(statearr_73042_73079[(2)] = null);

(statearr_73042_73079[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73030 === (2))){
var _ = (function (){var statearr_73043 = state_73029;
(statearr_73043[(4)] = cljs.core.cons.call(null,(5),(state_73029[(4)])));

return statearr_73043;
})();
var inst_72971 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_73029__$1 = state_73029;
if(cljs.core.truth_(inst_72971)){
var statearr_73044_73080 = state_73029__$1;
(statearr_73044_73080[(1)] = (6));

} else {
var statearr_73045_73081 = state_73029__$1;
(statearr_73045_73081[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73030 === (19))){
var inst_73006 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73007 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_73008 = cljs.core.PersistentHashMap.fromArrays(inst_73006,inst_73007);
var inst_73009 = cljs.core.ex_info.call(null,"A user identity or auth identity must be supplied.",inst_73008);
var inst_73010 = (function(){throw inst_73009})();
var state_73029__$1 = state_73029;
var statearr_73046_73082 = state_73029__$1;
(statearr_73046_73082[(2)] = inst_73010);

(statearr_73046_73082[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73030 === (11))){
var inst_72989 = (state_73029[(2)]);
var state_73029__$1 = (function (){var statearr_73048 = state_73029;
(statearr_73048[(9)] = inst_72989);

return statearr_73048;
})();
if(cljs.core.truth_(password)){
var statearr_73049_73083 = state_73029__$1;
(statearr_73049_73083[(1)] = (12));

} else {
var statearr_73050_73084 = state_73029__$1;
(statearr_73050_73084[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73030 === (9))){
var state_73029__$1 = state_73029;
var statearr_73051_73085 = state_73029__$1;
(statearr_73051_73085[(2)] = null);

(statearr_73051_73085[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73030 === (5))){
var _ = (function (){var statearr_73052 = state_73029;
(statearr_73052[(4)] = cljs.core.rest.call(null,(state_73029[(4)])));

return statearr_73052;
})();
var state_73029__$1 = state_73029;
var ex73047 = (state_73029__$1[(2)]);
var statearr_73053_73086 = state_73029__$1;
(statearr_73053_73086[(5)] = ex73047);


var statearr_73054_73087 = state_73029__$1;
(statearr_73054_73087[(1)] = (4));

(statearr_73054_73087[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73030 === (14))){
var inst_72999 = (state_73029[(8)]);
var inst_72998 = (state_73029[(2)]);
var inst_72999__$1 = user;
var state_73029__$1 = (function (){var statearr_73055 = state_73029;
(statearr_73055[(8)] = inst_72999__$1);

(statearr_73055[(10)] = inst_72998);

return statearr_73055;
})();
if(cljs.core.truth_(inst_72999__$1)){
var statearr_73056_73088 = state_73029__$1;
(statearr_73056_73088[(1)] = (15));

} else {
var statearr_73057_73089 = state_73029__$1;
(statearr_73057_73089[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73030 === (16))){
var state_73029__$1 = state_73029;
var statearr_73058_73090 = state_73029__$1;
(statearr_73058_73090[(2)] = auth);

(statearr_73058_73090[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73030 === (10))){
var inst_72983 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72984 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_72985 = cljs.core.PersistentHashMap.fromArrays(inst_72983,inst_72984);
var inst_72986 = cljs.core.ex_info.call(null,"A ledger must be supplied in the provided JSON.",inst_72985);
var inst_72987 = (function(){throw inst_72986})();
var state_73029__$1 = state_73029;
var statearr_73059_73091 = state_73029__$1;
(statearr_73059_73091[(2)] = inst_72987);

(statearr_73059_73091[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73030 === (18))){
var state_73029__$1 = state_73029;
var statearr_73060_73092 = state_73029__$1;
(statearr_73060_73092[(2)] = null);

(statearr_73060_73092[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73030 === (8))){
var inst_72980 = (state_73029[(2)]);
var state_73029__$1 = (function (){var statearr_73061 = state_73029;
(statearr_73061[(11)] = inst_72980);

return statearr_73061;
})();
if(cljs.core.truth_(ledger)){
var statearr_73062_73093 = state_73029__$1;
(statearr_73062_73093[(1)] = (9));

} else {
var statearr_73063_73094 = state_73029__$1;
(statearr_73063_73094[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__10903__auto__ = null;
var fluree$db$connection_js$state_machine__10903__auto____0 = (function (){
var statearr_73064 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73064[(0)] = fluree$db$connection_js$state_machine__10903__auto__);

(statearr_73064[(1)] = (1));

return statearr_73064;
});
var fluree$db$connection_js$state_machine__10903__auto____1 = (function (state_73029){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_73029);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e73065){var ex__10906__auto__ = e73065;
var statearr_73066_73095 = state_73029;
(statearr_73066_73095[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_73029[(4)]))){
var statearr_73067_73096 = state_73029;
(statearr_73067_73096[(1)] = cljs.core.first.call(null,(state_73029[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73097 = state_73029;
state_73029 = G__73097;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__10903__auto__ = function(state_73029){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__10903__auto____1.call(this,state_73029);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__10903__auto____0;
fluree$db$connection_js$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__10903__auto____1;
return fluree$db$connection_js$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_73068 = f__10977__auto__.call(null);
(statearr_73068[(6)] = c__10976__auto__);

return statearr_73068;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__73099 = arguments.length;
switch (G__73099) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_73134){
var state_val_73135 = (state_73134[(1)]);
if((state_val_73135 === (1))){
var state_73134__$1 = state_73134;
var statearr_73136_73156 = state_73134__$1;
(statearr_73136_73156[(2)] = null);

(statearr_73136_73156[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73135 === (2))){
var _ = (function (){var statearr_73137 = state_73134;
(statearr_73137[(4)] = cljs.core.cons.call(null,(5),(state_73134[(4)])));

return statearr_73137;
})();
var inst_73108 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_73134__$1 = state_73134;
if(cljs.core.truth_(inst_73108)){
var statearr_73138_73157 = state_73134__$1;
(statearr_73138_73157[(1)] = (6));

} else {
var statearr_73139_73158 = state_73134__$1;
(statearr_73139_73158[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73135 === (3))){
var inst_73132 = (state_73134[(2)]);
var state_73134__$1 = state_73134;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73134__$1,inst_73132);
} else {
if((state_val_73135 === (4))){
var inst_73100 = (state_73134[(2)]);
var inst_73101 = cljs.core.clj__GT_js.call(null,inst_73100);
var inst_73102 = reject.call(null,inst_73101);
var state_73134__$1 = state_73134;
var statearr_73141_73159 = state_73134__$1;
(statearr_73141_73159[(2)] = inst_73102);

(statearr_73141_73159[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73135 === (5))){
var _ = (function (){var statearr_73142 = state_73134;
(statearr_73142[(4)] = cljs.core.rest.call(null,(state_73134[(4)])));

return statearr_73142;
})();
var state_73134__$1 = state_73134;
var ex73140 = (state_73134__$1[(2)]);
var statearr_73143_73160 = state_73134__$1;
(statearr_73143_73160[(5)] = ex73140);


var statearr_73144_73161 = state_73134__$1;
(statearr_73144_73161[(1)] = (4));

(statearr_73144_73161[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73135 === (6))){
var state_73134__$1 = state_73134;
var statearr_73145_73162 = state_73134__$1;
(statearr_73145_73162[(2)] = null);

(statearr_73145_73162[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73135 === (7))){
var inst_73111 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73112 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_73113 = cljs.core.PersistentHashMap.fromArrays(inst_73111,inst_73112);
var inst_73114 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_73113);
var inst_73115 = (function(){throw inst_73114})();
var state_73134__$1 = state_73134;
var statearr_73146_73163 = state_73134__$1;
(statearr_73146_73163[(2)] = inst_73115);

(statearr_73146_73163[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73135 === (8))){
var inst_73117 = (state_73134[(2)]);
var inst_73118 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_73119 = [jwt,expire];
var inst_73120 = cljs.core.PersistentHashMap.fromArrays(inst_73118,inst_73119);
var inst_73121 = fluree.db.util.core.without_nils.call(null,inst_73120);
var inst_73122 = cljs.core.async.promise_chan.call(null);
var inst_73123 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73124 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73125 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_73121,inst_73122,null];
var inst_73126 = (new cljs.core.PersistentVector(null,4,(5),inst_73124,inst_73125,null));
var inst_73127 = cljs.core.async.put_BANG_.call(null,inst_73123,inst_73126);
var inst_73128 = (function (){var _ = inst_73117;
var data = inst_73121;
var pc = inst_73122;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
fluree.db.connection.add_token.call(null,conn,result);

return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
});
})();
var inst_73129 = cljs.core.async.take_BANG_.call(null,inst_73122,inst_73128);
var _ = (function (){var statearr_73147 = state_73134;
(statearr_73147[(4)] = cljs.core.rest.call(null,(state_73134[(4)])));

return statearr_73147;
})();
var state_73134__$1 = (function (){var statearr_73148 = state_73134;
(statearr_73148[(7)] = inst_73127);

return statearr_73148;
})();
var statearr_73149_73164 = state_73134__$1;
(statearr_73149_73164[(2)] = inst_73129);

(statearr_73149_73164[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__10903__auto__ = null;
var fluree$db$connection_js$state_machine__10903__auto____0 = (function (){
var statearr_73150 = [null,null,null,null,null,null,null,null];
(statearr_73150[(0)] = fluree$db$connection_js$state_machine__10903__auto__);

(statearr_73150[(1)] = (1));

return statearr_73150;
});
var fluree$db$connection_js$state_machine__10903__auto____1 = (function (state_73134){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_73134);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e73151){var ex__10906__auto__ = e73151;
var statearr_73152_73165 = state_73134;
(statearr_73152_73165[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_73134[(4)]))){
var statearr_73153_73166 = state_73134;
(statearr_73153_73166[(1)] = cljs.core.first.call(null,(state_73134[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73167 = state_73134;
state_73134 = G__73167;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__10903__auto__ = function(state_73134){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__10903__auto____1.call(this,state_73134);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__10903__auto____0;
fluree$db$connection_js$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__10903__auto____1;
return fluree$db$connection_js$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_73154 = f__10977__auto__.call(null);
(statearr_73154[(6)] = c__10976__auto__);

return statearr_73154;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

