// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__71618_71787 = cljs.core.seq.call(null,servers);
var chunk__71619_71788 = null;
var count__71620_71789 = (0);
var i__71621_71790 = (0);
while(true){
if((i__71621_71790 < count__71620_71789)){
var server_71791 = cljs.core._nth.call(null,chunk__71619_71788,i__71621_71790);
var healthcheck_uri_71792 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_71791),"/fdb/health"].join('');
var resp_chan_71793 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_71792,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__10976__auto___71794 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__71618_71787,chunk__71619_71788,count__71620_71789,i__71621_71790,c__10976__auto___71794,healthcheck_uri_71792,resp_chan_71793,server_71791){
return (function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = ((function (seq__71618_71787,chunk__71619_71788,count__71620_71789,i__71621_71790,c__10976__auto___71794,healthcheck_uri_71792,resp_chan_71793,server_71791){
return (function (state_71682){
var state_val_71683 = (state_71682[(1)]);
if((state_val_71683 === (1))){
var state_71682__$1 = state_71682;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71682__$1,(2),resp_chan_71793);
} else {
if((state_val_71683 === (2))){
var inst_71671 = (state_71682[(7)]);
var inst_71671__$1 = (state_71682[(2)]);
var inst_71672 = fluree.db.util.core.exception_QMARK_.call(null,inst_71671__$1);
var state_71682__$1 = (function (){var statearr_71684 = state_71682;
(statearr_71684[(7)] = inst_71671__$1);

return statearr_71684;
})();
if(inst_71672){
var statearr_71685_71795 = state_71682__$1;
(statearr_71685_71795[(1)] = (3));

} else {
var statearr_71686_71796 = state_71682__$1;
(statearr_71686_71796[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71683 === (3))){
var inst_71671 = (state_71682[(7)]);
var inst_71674 = cljs.core.ex_message.call(null,inst_71671);
var inst_71675 = cljs.core.ex_data.call(null,inst_71671);
var inst_71676 = fluree.db.util.log.warn.call(null,"Server contact error: ",inst_71674,inst_71675);
var state_71682__$1 = state_71682;
var statearr_71687_71797 = state_71682__$1;
(statearr_71687_71797[(2)] = inst_71676);

(statearr_71687_71797[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71683 === (4))){
var inst_71678 = cljs.core.async.put_BANG_.call(null,promise_chan,server_71791);
var state_71682__$1 = state_71682;
var statearr_71688_71798 = state_71682__$1;
(statearr_71688_71798[(2)] = inst_71678);

(statearr_71688_71798[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71683 === (5))){
var inst_71680 = (state_71682[(2)]);
var state_71682__$1 = state_71682;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71682__$1,inst_71680);
} else {
return null;
}
}
}
}
}
});})(seq__71618_71787,chunk__71619_71788,count__71620_71789,i__71621_71790,c__10976__auto___71794,healthcheck_uri_71792,resp_chan_71793,server_71791))
;
return ((function (seq__71618_71787,chunk__71619_71788,count__71620_71789,i__71621_71790,switch__10902__auto__,c__10976__auto___71794,healthcheck_uri_71792,resp_chan_71793,server_71791){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto____0 = (function (){
var statearr_71689 = [null,null,null,null,null,null,null,null];
(statearr_71689[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto__);

(statearr_71689[(1)] = (1));

return statearr_71689;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto____1 = (function (state_71682){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_71682);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e71690){var ex__10906__auto__ = e71690;
var statearr_71691_71799 = state_71682;
(statearr_71691_71799[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_71682[(4)]))){
var statearr_71692_71800 = state_71682;
(statearr_71692_71800[(1)] = cljs.core.first.call(null,(state_71682[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71801 = state_71682;
state_71682 = G__71801;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto__ = function(state_71682){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto____1.call(this,state_71682);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto__;
})()
;})(seq__71618_71787,chunk__71619_71788,count__71620_71789,i__71621_71790,switch__10902__auto__,c__10976__auto___71794,healthcheck_uri_71792,resp_chan_71793,server_71791))
})();
var state__10978__auto__ = (function (){var statearr_71693 = f__10977__auto__.call(null);
(statearr_71693[(6)] = c__10976__auto___71794);

return statearr_71693;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
});})(seq__71618_71787,chunk__71619_71788,count__71620_71789,i__71621_71790,c__10976__auto___71794,healthcheck_uri_71792,resp_chan_71793,server_71791))
);



var G__71802 = seq__71618_71787;
var G__71803 = chunk__71619_71788;
var G__71804 = count__71620_71789;
var G__71805 = (i__71621_71790 + (1));
seq__71618_71787 = G__71802;
chunk__71619_71788 = G__71803;
count__71620_71789 = G__71804;
i__71621_71790 = G__71805;
continue;
} else {
var temp__5753__auto___71806 = cljs.core.seq.call(null,seq__71618_71787);
if(temp__5753__auto___71806){
var seq__71618_71807__$1 = temp__5753__auto___71806;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__71618_71807__$1)){
var c__4679__auto___71808 = cljs.core.chunk_first.call(null,seq__71618_71807__$1);
var G__71809 = cljs.core.chunk_rest.call(null,seq__71618_71807__$1);
var G__71810 = c__4679__auto___71808;
var G__71811 = cljs.core.count.call(null,c__4679__auto___71808);
var G__71812 = (0);
seq__71618_71787 = G__71809;
chunk__71619_71788 = G__71810;
count__71620_71789 = G__71811;
i__71621_71790 = G__71812;
continue;
} else {
var server_71813 = cljs.core.first.call(null,seq__71618_71807__$1);
var healthcheck_uri_71814 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_71813),"/fdb/health"].join('');
var resp_chan_71815 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_71814,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__10976__auto___71816 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__71618_71787,chunk__71619_71788,count__71620_71789,i__71621_71790,c__10976__auto___71816,healthcheck_uri_71814,resp_chan_71815,server_71813,seq__71618_71807__$1,temp__5753__auto___71806){
return (function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = ((function (seq__71618_71787,chunk__71619_71788,count__71620_71789,i__71621_71790,c__10976__auto___71816,healthcheck_uri_71814,resp_chan_71815,server_71813,seq__71618_71807__$1,temp__5753__auto___71806){
return (function (state_71706){
var state_val_71707 = (state_71706[(1)]);
if((state_val_71707 === (1))){
var state_71706__$1 = state_71706;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71706__$1,(2),resp_chan_71815);
} else {
if((state_val_71707 === (2))){
var inst_71695 = (state_71706[(7)]);
var inst_71695__$1 = (state_71706[(2)]);
var inst_71696 = fluree.db.util.core.exception_QMARK_.call(null,inst_71695__$1);
var state_71706__$1 = (function (){var statearr_71708 = state_71706;
(statearr_71708[(7)] = inst_71695__$1);

return statearr_71708;
})();
if(inst_71696){
var statearr_71709_71817 = state_71706__$1;
(statearr_71709_71817[(1)] = (3));

} else {
var statearr_71710_71818 = state_71706__$1;
(statearr_71710_71818[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71707 === (3))){
var inst_71695 = (state_71706[(7)]);
var inst_71698 = cljs.core.ex_message.call(null,inst_71695);
var inst_71699 = cljs.core.ex_data.call(null,inst_71695);
var inst_71700 = fluree.db.util.log.warn.call(null,"Server contact error: ",inst_71698,inst_71699);
var state_71706__$1 = state_71706;
var statearr_71711_71819 = state_71706__$1;
(statearr_71711_71819[(2)] = inst_71700);

(statearr_71711_71819[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71707 === (4))){
var inst_71702 = cljs.core.async.put_BANG_.call(null,promise_chan,server_71813);
var state_71706__$1 = state_71706;
var statearr_71712_71820 = state_71706__$1;
(statearr_71712_71820[(2)] = inst_71702);

(statearr_71712_71820[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71707 === (5))){
var inst_71704 = (state_71706[(2)]);
var state_71706__$1 = state_71706;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71706__$1,inst_71704);
} else {
return null;
}
}
}
}
}
});})(seq__71618_71787,chunk__71619_71788,count__71620_71789,i__71621_71790,c__10976__auto___71816,healthcheck_uri_71814,resp_chan_71815,server_71813,seq__71618_71807__$1,temp__5753__auto___71806))
;
return ((function (seq__71618_71787,chunk__71619_71788,count__71620_71789,i__71621_71790,switch__10902__auto__,c__10976__auto___71816,healthcheck_uri_71814,resp_chan_71815,server_71813,seq__71618_71807__$1,temp__5753__auto___71806){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto____0 = (function (){
var statearr_71713 = [null,null,null,null,null,null,null,null];
(statearr_71713[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto__);

(statearr_71713[(1)] = (1));

return statearr_71713;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto____1 = (function (state_71706){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_71706);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e71714){var ex__10906__auto__ = e71714;
var statearr_71715_71821 = state_71706;
(statearr_71715_71821[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_71706[(4)]))){
var statearr_71716_71822 = state_71706;
(statearr_71716_71822[(1)] = cljs.core.first.call(null,(state_71706[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71823 = state_71706;
state_71706 = G__71823;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto__ = function(state_71706){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto____1.call(this,state_71706);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto__;
})()
;})(seq__71618_71787,chunk__71619_71788,count__71620_71789,i__71621_71790,switch__10902__auto__,c__10976__auto___71816,healthcheck_uri_71814,resp_chan_71815,server_71813,seq__71618_71807__$1,temp__5753__auto___71806))
})();
var state__10978__auto__ = (function (){var statearr_71717 = f__10977__auto__.call(null);
(statearr_71717[(6)] = c__10976__auto___71816);

return statearr_71717;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
});})(seq__71618_71787,chunk__71619_71788,count__71620_71789,i__71621_71790,c__10976__auto___71816,healthcheck_uri_71814,resp_chan_71815,server_71813,seq__71618_71807__$1,temp__5753__auto___71806))
);



var G__71824 = cljs.core.next.call(null,seq__71618_71807__$1);
var G__71825 = null;
var G__71826 = (0);
var G__71827 = (0);
seq__71618_71787 = G__71824;
chunk__71619_71788 = G__71825;
count__71620_71789 = G__71826;
i__71621_71790 = G__71827;
continue;
}
} else {
}
}
break;
}

var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_71761){
var state_val_71762 = (state_71761[(1)]);
if((state_val_71762 === (7))){
var inst_71733 = (state_71761[(7)]);
var inst_71740 = cljs.core._EQ_.call(null,inst_71733,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_71761__$1 = state_71761;
if(inst_71740){
var statearr_71763_71828 = state_71761__$1;
(statearr_71763_71828[(1)] = (9));

} else {
var statearr_71764_71829 = state_71761__$1;
(statearr_71764_71829[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71762 === (1))){
var inst_71726 = (state_71761[(8)]);
var inst_71725 = (state_71761[(9)]);
var inst_71725__$1 = promise_chan;
var inst_71726__$1 = cljs.core.async.timeout.call(null,(60000));
var inst_71727 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71728 = [inst_71725__$1,inst_71726__$1];
var inst_71729 = (new cljs.core.PersistentVector(null,2,(5),inst_71727,inst_71728,null));
var state_71761__$1 = (function (){var statearr_71765 = state_71761;
(statearr_71765[(8)] = inst_71726__$1);

(statearr_71765[(9)] = inst_71725__$1);

return statearr_71765;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_71761__$1,(2),inst_71729);
} else {
if((state_val_71762 === (4))){
var inst_71726 = (state_71761[(8)]);
var inst_71733 = (state_71761[(7)]);
var inst_71737 = cljs.core._EQ_.call(null,inst_71733,inst_71726);
var state_71761__$1 = state_71761;
if(inst_71737){
var statearr_71766_71830 = state_71761__$1;
(statearr_71766_71830[(1)] = (6));

} else {
var statearr_71767_71831 = state_71761__$1;
(statearr_71767_71831[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71762 === (13))){
var state_71761__$1 = state_71761;
var statearr_71768_71832 = state_71761__$1;
(statearr_71768_71832[(2)] = null);

(statearr_71768_71832[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71762 === (6))){
var state_71761__$1 = state_71761;
var statearr_71769_71833 = state_71761__$1;
(statearr_71769_71833[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_71769_71833[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71762 === (3))){
var state_71761__$1 = state_71761;
var statearr_71770_71834 = state_71761__$1;
(statearr_71770_71834[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_71770_71834[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71762 === (12))){
var inst_71751 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"server","server",1499190120));
var inst_71752 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71753 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_71754 = cljs.core.PersistentHashMap.fromArrays(inst_71752,inst_71753);
var inst_71755 = cljs.core.ex_info.call(null,"Unable to find healthy server before timeout.",inst_71754);
var inst_71756 = cljs.core.async.put_BANG_.call(null,promise_chan,inst_71755);
var state_71761__$1 = (function (){var statearr_71771 = state_71761;
(statearr_71771[(10)] = inst_71751);

return statearr_71771;
})();
var statearr_71772_71835 = state_71761__$1;
(statearr_71772_71835[(2)] = inst_71756);

(statearr_71772_71835[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71762 === (2))){
var inst_71733 = (state_71761[(7)]);
var inst_71725 = (state_71761[(9)]);
var inst_71731 = (state_71761[(2)]);
var inst_71732 = cljs.core.nth.call(null,inst_71731,(0),null);
var inst_71733__$1 = cljs.core.nth.call(null,inst_71731,(1),null);
var inst_71734 = cljs.core._EQ_.call(null,inst_71733__$1,inst_71725);
var state_71761__$1 = (function (){var statearr_71773 = state_71761;
(statearr_71773[(7)] = inst_71733__$1);

(statearr_71773[(11)] = inst_71732);

return statearr_71773;
})();
if(inst_71734){
var statearr_71774_71836 = state_71761__$1;
(statearr_71774_71836[(1)] = (3));

} else {
var statearr_71775_71837 = state_71761__$1;
(statearr_71775_71837[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71762 === (11))){
var inst_71744 = (state_71761[(2)]);
var state_71761__$1 = state_71761;
var statearr_71776_71838 = state_71761__$1;
(statearr_71776_71838[(2)] = inst_71744);

(statearr_71776_71838[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71762 === (9))){
var inst_71732 = (state_71761[(11)]);
var state_71761__$1 = state_71761;
var statearr_71777_71839 = state_71761__$1;
(statearr_71777_71839[(2)] = inst_71732);

(statearr_71777_71839[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71762 === (5))){
var inst_71748 = (state_71761[(2)]);
var inst_71749 = cljs.core._EQ_.call(null,new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_71748);
var state_71761__$1 = state_71761;
if(inst_71749){
var statearr_71778_71840 = state_71761__$1;
(statearr_71778_71840[(1)] = (12));

} else {
var statearr_71779_71841 = state_71761__$1;
(statearr_71779_71841[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71762 === (14))){
var inst_71759 = (state_71761[(2)]);
var state_71761__$1 = state_71761;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71761__$1,inst_71759);
} else {
if((state_val_71762 === (10))){
var state_71761__$1 = state_71761;
var statearr_71780_71842 = state_71761__$1;
(statearr_71780_71842[(2)] = null);

(statearr_71780_71842[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71762 === (8))){
var inst_71746 = (state_71761[(2)]);
var state_71761__$1 = state_71761;
var statearr_71781_71843 = state_71761__$1;
(statearr_71781_71843[(2)] = inst_71746);

(statearr_71781_71843[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto____0 = (function (){
var statearr_71782 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71782[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto__);

(statearr_71782[(1)] = (1));

return statearr_71782;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto____1 = (function (state_71761){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_71761);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e71783){var ex__10906__auto__ = e71783;
var statearr_71784_71844 = state_71761;
(statearr_71784_71844[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_71761[(4)]))){
var statearr_71785_71845 = state_71761;
(statearr_71785_71845[(1)] = cljs.core.first.call(null,(state_71761[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71846 = state_71761;
state_71761 = G__71846;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto__ = function(state_71761){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto____1.call(this,state_71761);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_71786 = f__10977__auto__.call(null);
(statearr_71786[(6)] = c__10976__auto__);

return statearr_71786;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid.call(null);
var new_state = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.call(null)], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.call(null,lock_id,cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server.call(null,conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_71890){
var state_val_71891 = (state_71890[(1)]);
if((state_val_71891 === (7))){
var state_71890__$1 = state_71890;
var statearr_71892_71918 = state_71890__$1;
(statearr_71892_71918[(2)] = null);

(statearr_71892_71918[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71891 === (1))){
var state_71890__$1 = state_71890;
var statearr_71893_71919 = state_71890__$1;
(statearr_71893_71919[(2)] = null);

(statearr_71893_71919[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71891 === (4))){
var inst_71847 = (state_71890[(2)]);
var state_71890__$1 = state_71890;
var statearr_71894_71920 = state_71890__$1;
(statearr_71894_71920[(2)] = inst_71847);

(statearr_71894_71920[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71891 === (6))){
var inst_71869 = fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
var state_71890__$1 = state_71890;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71890__$1,(9),inst_71869);
} else {
if((state_val_71891 === (3))){
var inst_71888 = (state_71890[(2)]);
var state_71890__$1 = state_71890;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71890__$1,inst_71888);
} else {
if((state_val_71891 === (12))){
var inst_71882 = (state_71890[(2)]);
var state_71890__$1 = state_71890;
var statearr_71895_71921 = state_71890__$1;
(statearr_71895_71921[(2)] = inst_71882);

(statearr_71895_71921[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71891 === (2))){
var inst_71853 = (state_71890[(7)]);
var inst_71858 = (state_71890[(8)]);
var inst_71863 = (state_71890[(9)]);
var _ = (function (){var statearr_71896 = state_71890;
(statearr_71896[(4)] = cljs.core.cons.call(null,(5),(state_71890[(4)])));

return statearr_71896;
})();
var inst_71853__$1 = fluree.db.util.core.random_uuid.call(null);
var inst_71854 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71855 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_71856 = (new cljs.core.PersistentVector(null,2,(5),inst_71854,inst_71855,null));
var inst_71857 = (function (){var lock_id = inst_71853__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.call(null)], null);
}
});
})();
var inst_71858__$1 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_71856,inst_71857);
var inst_71859 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71860 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_71861 = (new cljs.core.PersistentVector(null,3,(5),inst_71859,inst_71860,null));
var inst_71862 = cljs.core.get_in.call(null,inst_71858__$1,inst_71861);
var inst_71863__$1 = cljs.core._EQ_.call(null,inst_71853__$1,inst_71862);
var inst_71864 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71865 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_71866 = (new cljs.core.PersistentVector(null,3,(5),inst_71864,inst_71865,null));
var inst_71867 = cljs.core.get_in.call(null,inst_71858__$1,inst_71866);
var state_71890__$1 = (function (){var statearr_71897 = state_71890;
(statearr_71897[(10)] = inst_71867);

(statearr_71897[(7)] = inst_71853__$1);

(statearr_71897[(8)] = inst_71858__$1);

(statearr_71897[(9)] = inst_71863__$1);

return statearr_71897;
})();
if(inst_71863__$1){
var statearr_71898_71922 = state_71890__$1;
(statearr_71898_71922[(1)] = (6));

} else {
var statearr_71899_71923 = state_71890__$1;
(statearr_71899_71923[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71891 === (11))){
var inst_71874 = (state_71890[(11)]);
var inst_71867 = (state_71890[(10)]);
var inst_71873 = (state_71890[(12)]);
var inst_71880 = fluree.db.util.xhttp.try_socket.call(null,inst_71873,sub_chan,pub_chan,inst_71867,(60000),inst_71874);
var state_71890__$1 = state_71890;
var statearr_71901_71924 = state_71890__$1;
(statearr_71901_71924[(2)] = inst_71880);

(statearr_71901_71924[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71891 === (9))){
var inst_71867 = (state_71890[(10)]);
var inst_71871 = (state_71890[(13)]);
var inst_71853 = (state_71890[(7)]);
var inst_71858 = (state_71890[(8)]);
var inst_71863 = (state_71890[(9)]);
var inst_71873 = (state_71890[(12)]);
var inst_71871__$1 = (state_71890[(2)]);
var inst_71872 = clojure.string.replace.call(null,inst_71871__$1,"http","ws");
var inst_71873__$1 = [inst_71872,"/fdb/ws"].join('');
var inst_71874 = (function (){var lock_id = inst_71853;
var state = inst_71858;
var have_lock_QMARK_ = inst_71863;
var resp_chan = inst_71867;
var healthy_server = inst_71871__$1;
var ws_url = inst_71873__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.call(null,conn_id);
});
})();
var inst_71875 = fluree.db.util.core.exception_QMARK_.call(null,inst_71871__$1);
var state_71890__$1 = (function (){var statearr_71902 = state_71890;
(statearr_71902[(11)] = inst_71874);

(statearr_71902[(13)] = inst_71871__$1);

(statearr_71902[(12)] = inst_71873__$1);

return statearr_71902;
})();
if(inst_71875){
var statearr_71903_71925 = state_71890__$1;
(statearr_71903_71925[(1)] = (10));

} else {
var statearr_71904_71926 = state_71890__$1;
(statearr_71904_71926[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71891 === (5))){
var _ = (function (){var statearr_71905 = state_71890;
(statearr_71905[(4)] = cljs.core.rest.call(null,(state_71890[(4)])));

return statearr_71905;
})();
var state_71890__$1 = state_71890;
var ex71900 = (state_71890__$1[(2)]);
var statearr_71906_71927 = state_71890__$1;
(statearr_71906_71927[(5)] = ex71900);


if((ex71900 instanceof Error)){
var statearr_71907_71928 = state_71890__$1;
(statearr_71907_71928[(1)] = (4));

(statearr_71907_71928[(5)] = null);

} else {
throw ex71900;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71891 === (10))){
var inst_71867 = (state_71890[(10)]);
var inst_71871 = (state_71890[(13)]);
var inst_71877 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"ws","ws",86841443));
var inst_71878 = cljs.core.async.put_BANG_.call(null,inst_71867,inst_71871);
var state_71890__$1 = (function (){var statearr_71908 = state_71890;
(statearr_71908[(14)] = inst_71877);

return statearr_71908;
})();
var statearr_71909_71929 = state_71890__$1;
(statearr_71909_71929[(2)] = inst_71878);

(statearr_71909_71929[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71891 === (8))){
var inst_71867 = (state_71890[(10)]);
var inst_71885 = (state_71890[(2)]);
var _ = (function (){var statearr_71910 = state_71890;
(statearr_71910[(4)] = cljs.core.rest.call(null,(state_71890[(4)])));

return statearr_71910;
})();
var state_71890__$1 = (function (){var statearr_71911 = state_71890;
(statearr_71911[(15)] = inst_71885);

return statearr_71911;
})();
var statearr_71912_71930 = state_71890__$1;
(statearr_71912_71930[(2)] = inst_71867);

(statearr_71912_71930[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__10903__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__10903__auto____0 = (function (){
var statearr_71913 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71913[(0)] = fluree$db$connection$establish_socket_$_state_machine__10903__auto__);

(statearr_71913[(1)] = (1));

return statearr_71913;
});
var fluree$db$connection$establish_socket_$_state_machine__10903__auto____1 = (function (state_71890){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_71890);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e71914){var ex__10906__auto__ = e71914;
var statearr_71915_71931 = state_71890;
(statearr_71915_71931[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_71890[(4)]))){
var statearr_71916_71932 = state_71890;
(statearr_71916_71932[(1)] = cljs.core.first.call(null,(state_71890[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71933 = state_71890;
state_71890 = G__71933;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__10903__auto__ = function(state_71890){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__10903__auto____1.call(this,state_71890);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__10903__auto____0;
fluree$db$connection$establish_socket_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__10903__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_71917 = f__10977__auto__.call(null);
(statearr_71917[(6)] = c__10976__auto__);

return statearr_71917;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.group = group;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k71935,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__71939 = k71935;
var G__71939__$1 = (((G__71939 instanceof cljs.core.Keyword))?G__71939.fqn:null);
switch (G__71939__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "group":
return self__.group;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k71935,else__4505__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4525__auto__,p__71940){
var vec__71941 = p__71940;
var k__4526__auto__ = cljs.core.nth.call(null,vec__71941,(0),null);
var v__4527__auto__ = cljs.core.nth.call(null,vec__71941,(1),null);
return f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__);
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.connection.Connection{",", ","}",opts__4519__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"group","group",582596132),self__.group],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__71934){
var self__ = this;
var G__71934__$1 = this;
return (new cljs.core.RecordIter((0),G__71934__$1,22,new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (22 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (coll__4499__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll.call(null,coll__4499__auto__));
}).call(null,this__4498__auto____$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this71936,other71937){
var self__ = this;
var this71936__$1 = this;
return (((!((other71937 == null)))) && ((((this71936__$1.constructor === other71937.constructor)) && (((cljs.core._EQ_.call(null,this71936__$1.id,other71937.id)) && (((cljs.core._EQ_.call(null,this71936__$1.servers,other71937.servers)) && (((cljs.core._EQ_.call(null,this71936__$1.state,other71937.state)) && (((cljs.core._EQ_.call(null,this71936__$1.req_chan,other71937.req_chan)) && (((cljs.core._EQ_.call(null,this71936__$1.sub_chan,other71937.sub_chan)) && (((cljs.core._EQ_.call(null,this71936__$1.pub_chan,other71937.pub_chan)) && (((cljs.core._EQ_.call(null,this71936__$1.group,other71937.group)) && (((cljs.core._EQ_.call(null,this71936__$1.storage_read,other71937.storage_read)) && (((cljs.core._EQ_.call(null,this71936__$1.storage_write,other71937.storage_write)) && (((cljs.core._EQ_.call(null,this71936__$1.object_cache,other71937.object_cache)) && (((cljs.core._EQ_.call(null,this71936__$1.parallelism,other71937.parallelism)) && (((cljs.core._EQ_.call(null,this71936__$1.serializer,other71937.serializer)) && (((cljs.core._EQ_.call(null,this71936__$1.default_network,other71937.default_network)) && (((cljs.core._EQ_.call(null,this71936__$1.transactor_QMARK_,other71937.transactor_QMARK_)) && (((cljs.core._EQ_.call(null,this71936__$1.publish,other71937.publish)) && (((cljs.core._EQ_.call(null,this71936__$1.transact_handler,other71937.transact_handler)) && (((cljs.core._EQ_.call(null,this71936__$1.tx_private_key,other71937.tx_private_key)) && (((cljs.core._EQ_.call(null,this71936__$1.tx_key_id,other71937.tx_key_id)) && (((cljs.core._EQ_.call(null,this71936__$1.meta,other71937.meta)) && (((cljs.core._EQ_.call(null,this71936__$1.add_listener,other71937.add_listener)) && (((cljs.core._EQ_.call(null,this71936__$1.remove_listener,other71937.remove_listener)) && (((cljs.core._EQ_.call(null,this71936__$1.close,other71937.close)) && (cljs.core._EQ_.call(null,this71936__$1.__extmap,other71937.__extmap)))))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 22, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"group","group",582596132),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k71935){
var self__ = this;
var this__4509__auto____$1 = this;
var G__71944 = k71935;
var G__71944__$1 = (((G__71944 instanceof cljs.core.Keyword))?G__71944.fqn:null);
switch (G__71944__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "group":
case "storage-read":
case "storage-write":
case "object-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k71935);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__71934){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__71945 = cljs.core.keyword_identical_QMARK_;
var expr__71946 = k__4511__auto__;
if(cljs.core.truth_(pred__71945.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__71946))){
return (new fluree.db.connection.Connection(G__71934,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71945.call(null,new cljs.core.Keyword(null,"servers","servers",1881102005),expr__71946))){
return (new fluree.db.connection.Connection(self__.id,G__71934,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71945.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__71946))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__71934,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71945.call(null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),expr__71946))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__71934,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71945.call(null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),expr__71946))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__71934,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71945.call(null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),expr__71946))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__71934,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71945.call(null,new cljs.core.Keyword(null,"group","group",582596132),expr__71946))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__71934,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71945.call(null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),expr__71946))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,G__71934,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71945.call(null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),expr__71946))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,G__71934,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71945.call(null,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),expr__71946))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,G__71934,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71945.call(null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),expr__71946))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,G__71934,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71945.call(null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),expr__71946))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__71934,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71945.call(null,new cljs.core.Keyword(null,"default-network","default-network",586420705),expr__71946))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__71934,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71945.call(null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),expr__71946))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__71934,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71945.call(null,new cljs.core.Keyword(null,"publish","publish",-1178026850),expr__71946))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__71934,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71945.call(null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),expr__71946))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__71934,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71945.call(null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),expr__71946))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__71934,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71945.call(null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),expr__71946))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__71934,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71945.call(null,new cljs.core.Keyword(null,"meta","meta",1499536964),expr__71946))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__71934,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71945.call(null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),expr__71946))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__71934,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71945.call(null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),expr__71946))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__71934,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__71945.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__71946))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__71934,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4511__auto__,G__71934),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"group","group",582596132),self__.group,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__71934){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__71934,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4508__auto__,(0)),cljs.core._nth.call(null,entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"group","group",-2071839637,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write.call(null,writer__4547__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__71938){
var extmap__4542__auto__ = (function (){var G__71948 = cljs.core.dissoc.call(null,G__71938,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582));
if(cljs.core.record_QMARK_.call(null,G__71938)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__71948);
} else {
return G__71948;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__71938),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__71938),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__71938),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__71938),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__71938),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__71938),new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(G__71938),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__71938),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__71938),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__71938),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__71938),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__71938),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__71938),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__71938),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__71938),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__71938),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__71938),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__71938),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__71938),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__71938),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__71938),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__71938),null,cljs.core.not_empty.call(null,extmap__4542__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.call(null,servers,/,/):servers);
if(((cljs.core.empty_QMARK_.call(null,servers)) && (cljs.core.not.call(null,transactor_QMARK_)))){
throw cljs.core.ex_info.call(null,"At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty.call(null,servers_STAR_))){
var G__71954 = servers_STAR_;
var vec__71955 = G__71954;
var seq__71956 = cljs.core.seq.call(null,vec__71955);
var first__71957 = cljs.core.first.call(null,seq__71956);
var seq__71956__$1 = cljs.core.next.call(null,seq__71956);
var server = first__71957;
var r = seq__71956__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__71954__$1 = G__71954;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__71961 = G__71954__$1;
var seq__71962 = cljs.core.seq.call(null,vec__71961);
var first__71963 = cljs.core.first.call(null,seq__71962);
var seq__71962__$1 = cljs.core.next.call(null,seq__71962);
var server__$1 = first__71963;
var r__$1 = seq__71962__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.call(null,["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.call(null,server__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace.call(null,server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches.call(null,/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_.call(null,server__$2,"//"))?(function(){throw cljs.core.ex_info.call(null,["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches.call(null,/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_.call(null,server__$2,"https://");
var result_STAR_ = cljs.core.conj.call(null,result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches.call(null,fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.call(null,["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__4251__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not_EQ_.call(null,is_https_QMARK_,https_QMARK___$2);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_.call(null,r__$1)){
return cljs.core.shuffle.call(null,result_STAR_);
} else {
var G__71964 = r__$1;
var G__71965 = is_https_QMARK_;
var G__71966 = result_STAR_;
G__71954__$1 = G__71964;
https_QMARK___$1 = G__71965;
result__$1 = G__71966;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__71967 = cljs.core.get_in.call(null,fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__71967 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_.call(null,G__71967);
}
})();
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket.call(null,existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_71996){
var state_val_71997 = (state_71996[(1)]);
if((state_val_71997 === (7))){
var inst_71982 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71983 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71984 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71985 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71986 = fluree.db.connection.establish_socket.call(null,inst_71982,inst_71983,inst_71984,inst_71985);
var state_71996__$1 = state_71996;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71996__$1,(9),inst_71986);
} else {
if((state_val_71997 === (1))){
var state_71996__$1 = state_71996;
var statearr_71998_72017 = state_71996__$1;
(statearr_71998_72017[(2)] = null);

(statearr_71998_72017[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71997 === (4))){
var inst_71968 = (state_71996[(2)]);
var state_71996__$1 = state_71996;
var statearr_71999_72018 = state_71996__$1;
(statearr_71999_72018[(2)] = inst_71968);

(statearr_71999_72018[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71997 === (6))){
var inst_71979 = (state_71996[(7)]);
var state_71996__$1 = state_71996;
var statearr_72000_72019 = state_71996__$1;
(statearr_72000_72019[(2)] = inst_71979);

(statearr_72000_72019[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71997 === (3))){
var inst_71994 = (state_71996[(2)]);
var state_71996__$1 = state_71996;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71996__$1,inst_71994);
} else {
if((state_val_71997 === (2))){
var inst_71979 = (state_71996[(7)]);
var _ = (function (){var statearr_72002 = state_71996;
(statearr_72002[(4)] = cljs.core.cons.call(null,(5),(state_71996[(4)])));

return statearr_72002;
})();
var inst_71974 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_71975 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71976 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_71977 = [inst_71976,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_71978 = (new cljs.core.PersistentVector(null,3,(5),inst_71975,inst_71977,null));
var inst_71979__$1 = cljs.core.get_in.call(null,inst_71974,inst_71978);
var state_71996__$1 = (function (){var statearr_72003 = state_71996;
(statearr_72003[(7)] = inst_71979__$1);

return statearr_72003;
})();
if(cljs.core.truth_(inst_71979__$1)){
var statearr_72004_72020 = state_71996__$1;
(statearr_72004_72020[(1)] = (6));

} else {
var statearr_72005_72021 = state_71996__$1;
(statearr_72005_72021[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71997 === (9))){
var inst_71988 = (state_71996[(2)]);
var inst_71989 = fluree.db.util.async.throw_err.call(null,inst_71988);
var state_71996__$1 = state_71996;
var statearr_72006_72022 = state_71996__$1;
(statearr_72006_72022[(2)] = inst_71989);

(statearr_72006_72022[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71997 === (5))){
var _ = (function (){var statearr_72007 = state_71996;
(statearr_72007[(4)] = cljs.core.rest.call(null,(state_71996[(4)])));

return statearr_72007;
})();
var state_71996__$1 = state_71996;
var ex72001 = (state_71996__$1[(2)]);
var statearr_72008_72023 = state_71996__$1;
(statearr_72008_72023[(5)] = ex72001);


if((ex72001 instanceof Error)){
var statearr_72009_72024 = state_71996__$1;
(statearr_72009_72024[(1)] = (4));

(statearr_72009_72024[(5)] = null);

} else {
throw ex72001;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71997 === (8))){
var inst_71991 = (state_71996[(2)]);
var _ = (function (){var statearr_72010 = state_71996;
(statearr_72010[(4)] = cljs.core.rest.call(null,(state_71996[(4)])));

return statearr_72010;
})();
var state_71996__$1 = state_71996;
var statearr_72011_72025 = state_71996__$1;
(statearr_72011_72025[(2)] = inst_71991);

(statearr_72011_72025[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__10903__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__10903__auto____0 = (function (){
var statearr_72012 = [null,null,null,null,null,null,null,null];
(statearr_72012[(0)] = fluree$db$connection$get_socket_$_state_machine__10903__auto__);

(statearr_72012[(1)] = (1));

return statearr_72012;
});
var fluree$db$connection$get_socket_$_state_machine__10903__auto____1 = (function (state_71996){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_71996);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e72013){var ex__10906__auto__ = e72013;
var statearr_72014_72026 = state_71996;
(statearr_72014_72026[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_71996[(4)]))){
var statearr_72015_72027 = state_71996;
(statearr_72015_72027[(1)] = cljs.core.first.call(null,(state_71996[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72028 = state_71996;
state_71996 = G__72028;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__10903__auto__ = function(state_71996){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__10903__auto____1.call(this,state_71996);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__10903__auto____0;
fluree$db$connection$get_socket_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__10903__auto____1;
return fluree$db$connection$get_socket_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_72016 = f__10977__auto__.call(null);
(statearr_72016[(6)] = c__10976__auto__);

return statearr_72016;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__4253__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.call(null);
var msg = (function (){try{return fluree.db.util.json.stringify.call(null,message);
}catch (e72029){var e = e72029;
fluree.db.util.log.error.call(null,"Unable to publish message on websocket. Error encoding JSON message: ",message);

cljs.core.async.put_BANG_.call(null,resp_chan,cljs.core.ex_info.call(null,["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.call(null,pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_72156){
var state_val_72157 = (state_72156[(1)]);
if((state_val_72157 === (7))){
var inst_72152 = (state_72156[(2)]);
var state_72156__$1 = state_72156;
var statearr_72159_72229 = state_72156__$1;
(statearr_72159_72229[(2)] = inst_72152);

(statearr_72159_72229[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72157 === (20))){
var _ = (function (){var statearr_72160 = state_72156;
(statearr_72160[(4)] = cljs.core.rest.call(null,(state_72156[(4)])));

return statearr_72160;
})();
var state_72156__$1 = state_72156;
var ex72158 = (state_72156__$1[(2)]);
var statearr_72161_72230 = state_72156__$1;
(statearr_72161_72230[(5)] = ex72158);


var statearr_72162_72231 = state_72156__$1;
(statearr_72162_72231[(1)] = (10));

(statearr_72162_72231[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72157 === (27))){
var inst_72144 = (state_72156[(2)]);
var _ = (function (){var statearr_72163 = state_72156;
(statearr_72163[(4)] = cljs.core.rest.call(null,(state_72156[(4)])));

return statearr_72163;
})();
var state_72156__$1 = state_72156;
var statearr_72164_72232 = state_72156__$1;
(statearr_72164_72232[(2)] = inst_72144);

(statearr_72164_72232[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72157 === (1))){
var inst_72031 = (0);
var state_72156__$1 = (function (){var statearr_72165 = state_72156;
(statearr_72165[(7)] = inst_72031);

return statearr_72165;
})();
var statearr_72166_72233 = state_72156__$1;
(statearr_72166_72233[(2)] = null);

(statearr_72166_72233[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72157 === (24))){
var inst_72122 = (state_72156[(8)]);
var inst_72122__$1 = (state_72156[(2)]);
var inst_72123 = inst_72122__$1 === true;
var state_72156__$1 = (function (){var statearr_72167 = state_72156;
(statearr_72167[(8)] = inst_72122__$1);

return statearr_72167;
})();
if(cljs.core.truth_(inst_72123)){
var statearr_72168_72234 = state_72156__$1;
(statearr_72168_72234[(1)] = (25));

} else {
var statearr_72169_72235 = state_72156__$1;
(statearr_72169_72235[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72157 === (4))){
var inst_72034 = (state_72156[(9)]);
var inst_72034__$1 = (state_72156[(2)]);
var state_72156__$1 = (function (){var statearr_72170 = state_72156;
(statearr_72170[(9)] = inst_72034__$1);

return statearr_72170;
})();
if(cljs.core.truth_(inst_72034__$1)){
var statearr_72171_72236 = state_72156__$1;
(statearr_72171_72236[(1)] = (5));

} else {
var statearr_72172_72237 = state_72156__$1;
(statearr_72172_72237[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72157 === (15))){
var inst_72047 = (state_72156[(10)]);
var state_72156__$1 = state_72156;
var statearr_72173_72238 = state_72156__$1;
(statearr_72173_72238[(2)] = inst_72047);

(statearr_72173_72238[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72157 === (21))){
var inst_72031 = (state_72156[(7)]);
var inst_72070 = (state_72156[(11)]);
var inst_72074 = (state_72156[(12)]);
var inst_72075 = (state_72156[(13)]);
var inst_72072 = (state_72156[(14)]);
var inst_72078 = (state_72156[(15)]);
var inst_72034 = (state_72156[(9)]);
var inst_72073 = (state_72156[(16)]);
var inst_72071 = (state_72156[(17)]);
var inst_72079 = (state_72156[(18)]);
var inst_72081 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72082 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_72078];
var inst_72083 = (new cljs.core.PersistentVector(null,2,(5),inst_72081,inst_72082,null));
var inst_72084 = cljs.core.swap_BANG_.call(null,state,cljs.core.assoc_in,inst_72083,inst_72073);
var inst_72111 = cljs.core.async.chan.call(null,(1));
var inst_72112 = (function (){var resp_chan = inst_72073;
var timeout = inst_72079;
var i = inst_72031;
var data = inst_72072;
var _ = inst_72070;
var req_id = inst_72078;
var operation = inst_72071;
var vec__72066 = inst_72034;
var c__10976__auto____$1 = inst_72111;
var msg = inst_72034;
var map__72069 = inst_72075;
var opts = inst_72074;
return (function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_72109){
var state_val_72110 = (state_72109[(1)]);
if((state_val_72110 === (1))){
var inst_72088 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72089 = cljs.core.async.timeout.call(null,timeout);
var inst_72090 = [resp_chan,inst_72089];
var inst_72091 = (new cljs.core.PersistentVector(null,2,(5),inst_72088,inst_72090,null));
var state_72109__$1 = state_72109;
return cljs.core.async.ioc_alts_BANG_.call(null,state_72109__$1,(2),inst_72091);
} else {
if((state_val_72110 === (2))){
var inst_72094 = (state_72109[(7)]);
var inst_72093 = (state_72109[(2)]);
var inst_72094__$1 = cljs.core.nth.call(null,inst_72093,(0),null);
var inst_72095 = cljs.core.nth.call(null,inst_72093,(1),null);
var inst_72096 = (function (){var vec__72085 = inst_72093;
var resp = inst_72094__$1;
var c = inst_72095;
return (function (p1__72030_SHARP_){
return cljs.core.dissoc.call(null,p1__72030_SHARP_,req_id);
});
})();
var inst_72097 = cljs.core.swap_BANG_.call(null,state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_72096);
var inst_72098 = cljs.core._EQ_.call(null,inst_72095,resp_chan);
var state_72109__$1 = (function (){var statearr_72174 = state_72109;
(statearr_72174[(7)] = inst_72094__$1);

(statearr_72174[(8)] = inst_72097);

return statearr_72174;
})();
if(inst_72098){
var statearr_72175_72239 = state_72109__$1;
(statearr_72175_72239[(1)] = (3));

} else {
var statearr_72176_72240 = state_72109__$1;
(statearr_72176_72240[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72110 === (3))){
var inst_72094 = (state_72109[(7)]);
var state_72109__$1 = state_72109;
var statearr_72177_72241 = state_72109__$1;
(statearr_72177_72241[(2)] = inst_72094);

(statearr_72177_72241[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72110 === (4))){
var inst_72101 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_72102 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72103 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_72104 = cljs.core.PersistentHashMap.fromArrays(inst_72102,inst_72103);
var inst_72105 = cljs.core.ex_info.call(null,inst_72101,inst_72104);
var state_72109__$1 = state_72109;
var statearr_72178_72242 = state_72109__$1;
(statearr_72178_72242[(2)] = inst_72105);

(statearr_72178_72242[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72110 === (5))){
var inst_72107 = (state_72109[(2)]);
var state_72109__$1 = state_72109;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72109__$1,inst_72107);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__10903__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__10903__auto____0 = (function (){
var statearr_72179 = [null,null,null,null,null,null,null,null,null];
(statearr_72179[(0)] = fluree$db$connection$msg_producer_$_state_machine__10903__auto__);

(statearr_72179[(1)] = (1));

return statearr_72179;
});
var fluree$db$connection$msg_producer_$_state_machine__10903__auto____1 = (function (state_72109){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_72109);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e72180){var ex__10906__auto__ = e72180;
var statearr_72181_72243 = state_72109;
(statearr_72181_72243[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_72109[(4)]))){
var statearr_72182_72244 = state_72109;
(statearr_72182_72244[(1)] = cljs.core.first.call(null,(state_72109[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72245 = state_72109;
state_72109 = G__72245;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__10903__auto__ = function(state_72109){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__10903__auto____1.call(this,state_72109);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__10903__auto____0;
fluree$db$connection$msg_producer_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__10903__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_72183 = f__10977__auto__.call(null);
(statearr_72183[(6)] = c__10976__auto____$1);

return statearr_72183;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
});
})();
var inst_72113 = cljs.core.async.impl.dispatch.run.call(null,inst_72112);
var state_72156__$1 = (function (){var statearr_72184 = state_72156;
(statearr_72184[(19)] = inst_72113);

(statearr_72184[(20)] = inst_72084);

return statearr_72184;
})();
var statearr_72185_72246 = state_72156__$1;
(statearr_72185_72246[(2)] = inst_72111);

(statearr_72185_72246[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72157 === (31))){
var inst_72132 = fluree.db.util.log.error.call(null,"Error processing message in producer. Socket closed.");
var state_72156__$1 = state_72156;
var statearr_72186_72247 = state_72156__$1;
(statearr_72186_72247[(2)] = inst_72132);

(statearr_72186_72247[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72157 === (32))){
var state_72156__$1 = state_72156;
var statearr_72187_72248 = state_72156__$1;
(statearr_72187_72248[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72157 === (33))){
var inst_72140 = (state_72156[(2)]);
var state_72156__$1 = state_72156;
var statearr_72189_72249 = state_72156__$1;
(statearr_72189_72249[(2)] = inst_72140);

(statearr_72189_72249[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72157 === (13))){
var inst_72047 = (state_72156[(10)]);
var inst_72044 = (state_72156[(2)]);
var inst_72045 = cljs.core.nth.call(null,inst_72044,(0),null);
var inst_72046 = cljs.core.nth.call(null,inst_72044,(1),null);
var inst_72047__$1 = cljs.core.nth.call(null,inst_72044,(2),null);
var state_72156__$1 = (function (){var statearr_72190 = state_72156;
(statearr_72190[(10)] = inst_72047__$1);

(statearr_72190[(21)] = inst_72046);

(statearr_72190[(22)] = inst_72045);

return statearr_72190;
})();
if(cljs.core.truth_(inst_72047__$1)){
var statearr_72191_72250 = state_72156__$1;
(statearr_72191_72250[(1)] = (14));

} else {
var statearr_72192_72251 = state_72156__$1;
(statearr_72192_72251[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72157 === (22))){
var state_72156__$1 = state_72156;
var statearr_72193_72252 = state_72156__$1;
(statearr_72193_72252[(2)] = null);

(statearr_72193_72252[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72157 === (36))){
var inst_72138 = (state_72156[(2)]);
var state_72156__$1 = state_72156;
var statearr_72194_72253 = state_72156__$1;
(statearr_72194_72253[(2)] = inst_72138);

(statearr_72194_72253[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72157 === (29))){
var inst_72122 = (state_72156[(8)]);
var inst_72130 = (inst_72122 == null);
var state_72156__$1 = state_72156;
if(cljs.core.truth_(inst_72130)){
var statearr_72195_72254 = state_72156__$1;
(statearr_72195_72254[(1)] = (31));

} else {
var statearr_72196_72255 = state_72156__$1;
(statearr_72196_72255[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72157 === (6))){
var state_72156__$1 = state_72156;
var statearr_72197_72256 = state_72156__$1;
(statearr_72197_72256[(2)] = null);

(statearr_72197_72256[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72157 === (28))){
var inst_72122 = (state_72156[(8)]);
var inst_72128 = fluree.db.util.log.error.call(null,inst_72122,"Error processing message in producer.");
var state_72156__$1 = state_72156;
var statearr_72198_72257 = state_72156__$1;
(statearr_72198_72257[(2)] = inst_72128);

(statearr_72198_72257[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72157 === (25))){
var state_72156__$1 = state_72156;
var statearr_72199_72258 = state_72156__$1;
(statearr_72199_72258[(2)] = null);

(statearr_72199_72258[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72157 === (34))){
var inst_72122 = (state_72156[(8)]);
var inst_72135 = fluree.db.util.log.error.call(null,"Error processing message in producer. Socket closed. Published result",inst_72122);
var state_72156__$1 = state_72156;
var statearr_72200_72259 = state_72156__$1;
(statearr_72200_72259[(2)] = inst_72135);

(statearr_72200_72259[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72157 === (17))){
var inst_72036 = (state_72156[(23)]);
var inst_72047 = (state_72156[(10)]);
var inst_72054 = cljs.core.async.put_BANG_.call(null,inst_72047,inst_72036);
var state_72156__$1 = state_72156;
var statearr_72201_72260 = state_72156__$1;
(statearr_72201_72260[(2)] = inst_72054);

(statearr_72201_72260[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72157 === (3))){
var inst_72154 = (state_72156[(2)]);
var state_72156__$1 = state_72156;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72156__$1,inst_72154);
} else {
if((state_val_72157 === (12))){
var state_72156__$1 = state_72156;
var statearr_72202_72261 = state_72156__$1;
(statearr_72202_72261[(2)] = null);

(statearr_72202_72261[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72157 === (2))){
var state_72156__$1 = state_72156;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72156__$1,(4),req_chan);
} else {
if((state_val_72157 === (23))){
var inst_72072 = (state_72156[(14)]);
var inst_72078 = (state_72156[(15)]);
var inst_72071 = (state_72156[(17)]);
var inst_72116 = (state_72156[(2)]);
var inst_72117 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72118 = [inst_72071,inst_72078,inst_72072];
var inst_72119 = (new cljs.core.PersistentVector(null,3,(5),inst_72117,inst_72118,null));
var inst_72120 = publish_fn.call(null,conn,inst_72119);
var state_72156__$1 = (function (){var statearr_72203 = state_72156;
(statearr_72203[(24)] = inst_72116);

return statearr_72203;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72156__$1,(24),inst_72120);
} else {
if((state_val_72157 === (35))){
var state_72156__$1 = state_72156;
var statearr_72204_72262 = state_72156__$1;
(statearr_72204_72262[(2)] = null);

(statearr_72204_72262[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72157 === (19))){
var inst_72060 = (state_72156[(2)]);
var state_72156__$1 = state_72156;
var statearr_72205_72263 = state_72156__$1;
(statearr_72205_72263[(2)] = inst_72060);

(statearr_72205_72263[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72157 === (11))){
var inst_72034 = (state_72156[(9)]);
var state_72156__$1 = state_72156;
var statearr_72206_72264 = state_72156__$1;
(statearr_72206_72264[(2)] = inst_72034);

(statearr_72206_72264[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72157 === (9))){
var inst_72031 = (state_72156[(7)]);
var inst_72147 = (state_72156[(2)]);
var inst_72148 = (inst_72031 + (1));
var inst_72031__$1 = inst_72148;
var state_72156__$1 = (function (){var statearr_72207 = state_72156;
(statearr_72207[(7)] = inst_72031__$1);

(statearr_72207[(25)] = inst_72147);

return statearr_72207;
})();
var statearr_72208_72265 = state_72156__$1;
(statearr_72208_72265[(2)] = null);

(statearr_72208_72265[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72157 === (5))){
var state_72156__$1 = state_72156;
var statearr_72209_72266 = state_72156__$1;
(statearr_72209_72266[(2)] = null);

(statearr_72209_72266[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72157 === (14))){
var inst_72047 = (state_72156[(10)]);
var inst_72049 = fluree.db.util.async.channel_QMARK_.call(null,inst_72047);
var state_72156__$1 = state_72156;
var statearr_72210_72267 = state_72156__$1;
(statearr_72210_72267[(2)] = inst_72049);

(statearr_72210_72267[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72157 === (26))){
var inst_72122 = (state_72156[(8)]);
var inst_72126 = fluree.db.util.core.exception_QMARK_.call(null,inst_72122);
var state_72156__$1 = state_72156;
if(inst_72126){
var statearr_72211_72268 = state_72156__$1;
(statearr_72211_72268[(1)] = (28));

} else {
var statearr_72212_72269 = state_72156__$1;
(statearr_72212_72269[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72157 === (16))){
var inst_72052 = (state_72156[(2)]);
var state_72156__$1 = state_72156;
if(cljs.core.truth_(inst_72052)){
var statearr_72213_72270 = state_72156__$1;
(statearr_72213_72270[(1)] = (17));

} else {
var statearr_72214_72271 = state_72156__$1;
(statearr_72214_72271[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72157 === (30))){
var inst_72142 = (state_72156[(2)]);
var state_72156__$1 = state_72156;
var statearr_72215_72272 = state_72156__$1;
(statearr_72215_72272[(2)] = inst_72142);

(statearr_72215_72272[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72157 === (10))){
var inst_72034 = (state_72156[(9)]);
var inst_72036 = (state_72156[(2)]);
var inst_72040 = cljs.core.sequential_QMARK_.call(null,inst_72034);
var state_72156__$1 = (function (){var statearr_72216 = state_72156;
(statearr_72216[(23)] = inst_72036);

return statearr_72216;
})();
if(inst_72040){
var statearr_72217_72273 = state_72156__$1;
(statearr_72217_72273[(1)] = (11));

} else {
var statearr_72218_72274 = state_72156__$1;
(statearr_72218_72274[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72157 === (18))){
var inst_72036 = (state_72156[(23)]);
var inst_72034 = (state_72156[(9)]);
var inst_72056 = cljs.core.pr_str.call(null,inst_72034);
var inst_72057 = ["Error processing ledger request, no valid return channel: ",inst_72056].join('');
var inst_72058 = fluree.db.util.log.error.call(null,inst_72036,inst_72057);
var state_72156__$1 = state_72156;
var statearr_72219_72275 = state_72156__$1;
(statearr_72219_72275[(2)] = inst_72058);

(statearr_72219_72275[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72157 === (8))){
var inst_72074 = (state_72156[(12)]);
var inst_72075 = (state_72156[(13)]);
var inst_72034 = (state_72156[(9)]);
var inst_72073 = (state_72156[(16)]);
var _ = (function (){var statearr_72220 = state_72156;
(statearr_72220[(4)] = cljs.core.cons.call(null,(20),(state_72156[(4)])));

return statearr_72220;
})();
var inst_72070 = fluree.db.util.log.trace.call(null,"Outgoing message to websocket: ",inst_72034);
var inst_72071 = cljs.core.nth.call(null,inst_72034,(0),null);
var inst_72072 = cljs.core.nth.call(null,inst_72034,(1),null);
var inst_72073__$1 = cljs.core.nth.call(null,inst_72034,(2),null);
var inst_72074__$1 = cljs.core.nth.call(null,inst_72034,(3),null);
var inst_72075__$1 = cljs.core.__destructure_map.call(null,inst_72074__$1);
var inst_72076 = fluree.db.util.core.random_uuid.call(null);
var inst_72077 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_72076);
var inst_72078 = cljs.core.get.call(null,inst_72075__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_72077);
var inst_72079 = cljs.core.get.call(null,inst_72075__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_72156__$1 = (function (){var statearr_72221 = state_72156;
(statearr_72221[(11)] = inst_72070);

(statearr_72221[(12)] = inst_72074__$1);

(statearr_72221[(13)] = inst_72075__$1);

(statearr_72221[(14)] = inst_72072);

(statearr_72221[(15)] = inst_72078);

(statearr_72221[(16)] = inst_72073__$1);

(statearr_72221[(17)] = inst_72071);

(statearr_72221[(18)] = inst_72079);

return statearr_72221;
})();
if(cljs.core.truth_(inst_72073__$1)){
var statearr_72222_72276 = state_72156__$1;
(statearr_72222_72276[(1)] = (21));

} else {
var statearr_72223_72277 = state_72156__$1;
(statearr_72223_72277[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__10903__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__10903__auto____0 = (function (){
var statearr_72224 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72224[(0)] = fluree$db$connection$msg_producer_$_state_machine__10903__auto__);

(statearr_72224[(1)] = (1));

return statearr_72224;
});
var fluree$db$connection$msg_producer_$_state_machine__10903__auto____1 = (function (state_72156){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_72156);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e72225){var ex__10906__auto__ = e72225;
var statearr_72226_72278 = state_72156;
(statearr_72226_72278[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_72156[(4)]))){
var statearr_72227_72279 = state_72156;
(statearr_72227_72279[(1)] = cljs.core.first.call(null,(state_72156[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72280 = state_72156;
state_72156 = G__72280;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__10903__auto__ = function(state_72156){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__10903__auto____1.call(this,state_72156);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__10903__auto____0;
fluree$db$connection$msg_producer_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__10903__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_72228 = f__10977__auto__.call(null);
(statearr_72228[(6)] = c__10976__auto__);

return statearr_72228;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.call(null,req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__72281 = conn;
var map__72281__$1 = cljs.core.__destructure_map.call(null,map__72281);
var sub_chan = cljs.core.get.call(null,map__72281__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_72366){
var state_val_72367 = (state_72366[(1)]);
if((state_val_72367 === (7))){
var inst_72362 = (state_72366[(2)]);
var state_72366__$1 = state_72366;
var statearr_72368_72419 = state_72366__$1;
(statearr_72368_72419[(2)] = inst_72362);

(statearr_72368_72419[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72367 === (20))){
var inst_72300 = (state_72366[(7)]);
var inst_72314 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_72315 = [inst_72300];
var inst_72316 = cljs.core.PersistentHashMap.fromArrays(inst_72314,inst_72315);
var inst_72317 = fluree.db.util.log.warn.call(null,"Unsupported callback registered",inst_72316);
var state_72366__$1 = state_72366;
var statearr_72369_72420 = state_72366__$1;
(statearr_72369_72420[(2)] = inst_72317);

(statearr_72369_72420[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72367 === (27))){
var state_72366__$1 = state_72366;
var statearr_72370_72421 = state_72366__$1;
(statearr_72370_72421[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72367 === (1))){
var inst_72282 = (0);
var state_72366__$1 = (function (){var statearr_72372 = state_72366;
(statearr_72372[(8)] = inst_72282);

return statearr_72372;
})();
var statearr_72373_72422 = state_72366__$1;
(statearr_72373_72422[(2)] = null);

(statearr_72373_72422[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72367 === (24))){
var inst_72293 = (state_72366[(9)]);
var inst_72342 = fluree.db.util.core.exception_QMARK_.call(null,inst_72293);
var state_72366__$1 = state_72366;
if(inst_72342){
var statearr_72374_72423 = state_72366__$1;
(statearr_72374_72423[(1)] = (26));

} else {
var statearr_72375_72424 = state_72366__$1;
(statearr_72375_72424[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72367 === (4))){
var inst_72287 = (state_72366[(10)]);
var inst_72292 = (state_72366[(2)]);
var inst_72293 = cljs.core.nth.call(null,inst_72292,(0),null);
var inst_72294 = cljs.core.nth.call(null,inst_72292,(1),null);
var inst_72295 = cljs.core._EQ_.call(null,inst_72294,inst_72287);
var state_72366__$1 = (function (){var statearr_72376 = state_72366;
(statearr_72376[(9)] = inst_72293);

return statearr_72376;
})();
if(inst_72295){
var statearr_72377_72425 = state_72366__$1;
(statearr_72377_72425[(1)] = (5));

} else {
var statearr_72378_72426 = state_72366__$1;
(statearr_72378_72426[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72367 === (15))){
var inst_72300 = (state_72366[(7)]);
var inst_72309 = typeof inst_72300 === 'string';
var state_72366__$1 = state_72366;
if(cljs.core.truth_(inst_72309)){
var statearr_72379_72427 = state_72366__$1;
(statearr_72379_72427[(1)] = (17));

} else {
var statearr_72380_72428 = state_72366__$1;
(statearr_72380_72428[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72367 === (21))){
var state_72366__$1 = state_72366;
var statearr_72381_72429 = state_72366__$1;
(statearr_72381_72429[(2)] = null);

(statearr_72381_72429[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72367 === (31))){
var inst_72356 = (state_72366[(2)]);
var state_72366__$1 = state_72366;
var statearr_72382_72430 = state_72366__$1;
(statearr_72382_72430[(2)] = inst_72356);

(statearr_72382_72430[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72367 === (13))){
var inst_72326 = (state_72366[(2)]);
var inst_72327 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72328 = fluree.db.connection.close_websocket.call(null,inst_72327);
var inst_72329 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72330 = fluree.db.session.close_all_sessions.call(null,inst_72329);
var state_72366__$1 = (function (){var statearr_72383 = state_72366;
(statearr_72383[(11)] = inst_72328);

(statearr_72383[(12)] = inst_72326);

return statearr_72383;
})();
var statearr_72384_72431 = state_72366__$1;
(statearr_72384_72431[(2)] = inst_72330);

(statearr_72384_72431[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72367 === (22))){
var inst_72320 = (state_72366[(2)]);
var state_72366__$1 = state_72366;
var statearr_72385_72432 = state_72366__$1;
(statearr_72385_72432[(2)] = inst_72320);

(statearr_72385_72432[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72367 === (29))){
var inst_72293 = (state_72366[(9)]);
var inst_72348 = fluree.db.util.json.parse.call(null,inst_72293);
var inst_72349 = cljs.core.pr_str.call(null,inst_72348);
var inst_72350 = fluree.db.util.log.trace.call(null,"Received message:",inst_72349);
var inst_72351 = fluree.db.util.json.parse.call(null,inst_72293);
var inst_72352 = fluree.db.conn_events.process_events.call(null,conn,inst_72351);
var inst_72282 = (0);
var state_72366__$1 = (function (){var statearr_72386 = state_72366;
(statearr_72386[(13)] = inst_72350);

(statearr_72386[(14)] = inst_72352);

(statearr_72386[(8)] = inst_72282);

return statearr_72386;
})();
var statearr_72387_72433 = state_72366__$1;
(statearr_72387_72433[(2)] = null);

(statearr_72387_72433[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72367 === (6))){
var inst_72293 = (state_72366[(9)]);
var inst_72338 = (inst_72293 == null);
var state_72366__$1 = state_72366;
if(cljs.core.truth_(inst_72338)){
var statearr_72388_72434 = state_72366__$1;
(statearr_72388_72434[(1)] = (23));

} else {
var statearr_72389_72435 = state_72366__$1;
(statearr_72389_72435[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72367 === (28))){
var inst_72358 = (state_72366[(2)]);
var state_72366__$1 = state_72366;
var statearr_72390_72436 = state_72366__$1;
(statearr_72390_72436[(2)] = inst_72358);

(statearr_72390_72436[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72367 === (25))){
var inst_72360 = (state_72366[(2)]);
var state_72366__$1 = state_72366;
var statearr_72391_72437 = state_72366__$1;
(statearr_72391_72437[(2)] = inst_72360);

(statearr_72391_72437[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72367 === (17))){
var inst_72300 = (state_72366[(7)]);
var inst_72311 = cljs.core.eval.call(null,inst_72300);
var state_72366__$1 = state_72366;
var statearr_72392_72438 = state_72366__$1;
(statearr_72392_72438[(2)] = inst_72311);

(statearr_72392_72438[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72367 === (3))){
var inst_72364 = (state_72366[(2)]);
var state_72366__$1 = state_72366;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72366__$1,inst_72364);
} else {
if((state_val_72367 === (12))){
var inst_72300 = (state_72366[(7)]);
var inst_72305 = cljs.core.fn_QMARK_.call(null,inst_72300);
var state_72366__$1 = state_72366;
if(inst_72305){
var statearr_72393_72439 = state_72366__$1;
(statearr_72393_72439[(1)] = (14));

} else {
var statearr_72394_72440 = state_72366__$1;
(statearr_72394_72440[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72367 === (2))){
var inst_72287 = (state_72366[(10)]);
var inst_72287__$1 = cljs.core.async.timeout.call(null,ping_transactor_after);
var inst_72288 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72289 = [sub_chan,inst_72287__$1];
var inst_72290 = (new cljs.core.PersistentVector(null,2,(5),inst_72288,inst_72289,null));
var state_72366__$1 = (function (){var statearr_72395 = state_72366;
(statearr_72395[(10)] = inst_72287__$1);

return statearr_72395;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_72366__$1,(4),inst_72290);
} else {
if((state_val_72367 === (23))){
var inst_72340 = fluree.db.util.log.info.call(null,"Connection closed.");
var state_72366__$1 = state_72366;
var statearr_72396_72441 = state_72366__$1;
(statearr_72396_72441[(2)] = inst_72340);

(statearr_72396_72441[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72367 === (19))){
var inst_72322 = (state_72366[(2)]);
var state_72366__$1 = state_72366;
var statearr_72397_72442 = state_72366__$1;
(statearr_72397_72442[(2)] = inst_72322);

(statearr_72397_72442[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72367 === (11))){
var inst_72303 = fluree.db.util.log.trace.call(null,"No keep-alive callback is registered");
var state_72366__$1 = state_72366;
var statearr_72398_72443 = state_72366__$1;
(statearr_72398_72443[(2)] = inst_72303);

(statearr_72398_72443[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72367 === (9))){
var inst_72282 = (state_72366[(8)]);
var inst_72332 = fluree.db.connection.ping_transactor.call(null,conn);
var inst_72333 = (inst_72282 + (1));
var inst_72282__$1 = inst_72333;
var state_72366__$1 = (function (){var statearr_72399 = state_72366;
(statearr_72399[(15)] = inst_72332);

(statearr_72399[(8)] = inst_72282__$1);

return statearr_72399;
})();
var statearr_72400_72444 = state_72366__$1;
(statearr_72400_72444[(2)] = null);

(statearr_72400_72444[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72367 === (5))){
var inst_72282 = (state_72366[(8)]);
var inst_72297 = cljs.core._EQ_.call(null,(2),inst_72282);
var state_72366__$1 = state_72366;
if(inst_72297){
var statearr_72401_72445 = state_72366__$1;
(statearr_72401_72445[(1)] = (8));

} else {
var statearr_72402_72446 = state_72366__$1;
(statearr_72402_72446[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72367 === (14))){
var inst_72300 = (state_72366[(7)]);
var inst_72307 = inst_72300.call(null);
var state_72366__$1 = state_72366;
var statearr_72403_72447 = state_72366__$1;
(statearr_72403_72447[(2)] = inst_72307);

(statearr_72403_72447[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72367 === (26))){
var inst_72293 = (state_72366[(9)]);
var inst_72344 = fluree.db.util.log.error.call(null,inst_72293);
var inst_72282 = (0);
var state_72366__$1 = (function (){var statearr_72404 = state_72366;
(statearr_72404[(16)] = inst_72344);

(statearr_72404[(8)] = inst_72282);

return statearr_72404;
})();
var statearr_72405_72448 = state_72366__$1;
(statearr_72405_72448[(2)] = null);

(statearr_72405_72448[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72367 === (16))){
var inst_72324 = (state_72366[(2)]);
var state_72366__$1 = state_72366;
var statearr_72406_72449 = state_72366__$1;
(statearr_72406_72449[(2)] = inst_72324);

(statearr_72406_72449[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72367 === (30))){
var state_72366__$1 = state_72366;
var statearr_72407_72450 = state_72366__$1;
(statearr_72407_72450[(2)] = null);

(statearr_72407_72450[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72367 === (10))){
var inst_72336 = (state_72366[(2)]);
var state_72366__$1 = state_72366;
var statearr_72408_72451 = state_72366__$1;
(statearr_72408_72451[(2)] = inst_72336);

(statearr_72408_72451[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72367 === (18))){
var state_72366__$1 = state_72366;
var statearr_72409_72452 = state_72366__$1;
(statearr_72409_72452[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72367 === (8))){
var inst_72300 = (state_72366[(7)]);
var inst_72299 = fluree.db.util.log.warn.call(null,"Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket.");
var inst_72300__$1 = new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581).cljs$core$IFn$_invoke$arity$1(conn);
var inst_72301 = (inst_72300__$1 == null);
var state_72366__$1 = (function (){var statearr_72411 = state_72366;
(statearr_72411[(7)] = inst_72300__$1);

(statearr_72411[(17)] = inst_72299);

return statearr_72411;
})();
if(cljs.core.truth_(inst_72301)){
var statearr_72412_72453 = state_72366__$1;
(statearr_72412_72453[(1)] = (11));

} else {
var statearr_72413_72454 = state_72366__$1;
(statearr_72413_72454[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__10903__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__10903__auto____0 = (function (){
var statearr_72414 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72414[(0)] = fluree$db$connection$msg_consumer_$_state_machine__10903__auto__);

(statearr_72414[(1)] = (1));

return statearr_72414;
});
var fluree$db$connection$msg_consumer_$_state_machine__10903__auto____1 = (function (state_72366){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_72366);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e72415){var ex__10906__auto__ = e72415;
var statearr_72416_72455 = state_72366;
(statearr_72416_72455[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_72366[(4)]))){
var statearr_72417_72456 = state_72366;
(statearr_72417_72456[(1)] = cljs.core.first.call(null,(state_72366[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72457 = state_72366;
state_72366 = G__72457;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__10903__auto__ = function(state_72366){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__10903__auto____1.call(this,state_72366);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__10903__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__10903__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_72418 = f__10977__auto__.call(null);
(statearr_72418[(6)] = c__10976__auto__);

return statearr_72418;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__72459 = arguments.length;
switch (G__72459) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.call(null,conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__72460 = opts;
var map__72460__$1 = cljs.core.__destructure_map.call(null,map__72460);
var private$ = cljs.core.get.call(null,map__72460__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.call(null,map__72460__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_72512){
var state_val_72513 = (state_72512[(1)]);
if((state_val_72513 === (7))){
var inst_72470 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_72471 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72472 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_72473 = (new cljs.core.PersistentVector(null,2,(5),inst_72471,inst_72472,null));
var inst_72474 = cljs.core.get_in.call(null,inst_72470,inst_72473);
var state_72512__$1 = state_72512;
var statearr_72514_72545 = state_72512__$1;
(statearr_72514_72545[(2)] = inst_72474);

(statearr_72514_72545[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72513 === (1))){
var state_72512__$1 = state_72512;
var statearr_72515_72546 = state_72512__$1;
(statearr_72515_72546[(2)] = null);

(statearr_72515_72546[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72513 === (4))){
var inst_72461 = (state_72512[(2)]);
var state_72512__$1 = state_72512;
var statearr_72516_72547 = state_72512__$1;
(statearr_72516_72547[(2)] = inst_72461);

(statearr_72516_72547[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72513 === (15))){
var inst_72481 = (state_72512[(7)]);
var inst_72500 = (state_72512[(2)]);
var inst_72501 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_72502 = [(5000),inst_72500,new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_72503 = cljs.core.PersistentHashMap.fromArrays(inst_72501,inst_72502);
var inst_72504 = fluree.db.util.xhttp.get.call(null,inst_72481,inst_72503);
var state_72512__$1 = state_72512;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72512__$1,(16),inst_72504);
} else {
if((state_val_72513 === (13))){
var inst_72481 = (state_72512[(7)]);
var inst_72491 = (state_72512[(8)]);
var inst_72493 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_72494 = [inst_72491];
var inst_72495 = cljs.core.PersistentHashMap.fromArrays(inst_72493,inst_72494);
var inst_72496 = fluree.db.query.http_signatures.sign_request.call(null,"get",inst_72481,inst_72495,private$);
var inst_72497 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_72496);
var state_72512__$1 = state_72512;
var statearr_72517_72548 = state_72512__$1;
(statearr_72517_72548[(2)] = inst_72497);

(statearr_72517_72548[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72513 === (6))){
var inst_72467 = (state_72512[(9)]);
var state_72512__$1 = state_72512;
var statearr_72518_72549 = state_72512__$1;
(statearr_72518_72549[(2)] = inst_72467);

(statearr_72518_72549[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72513 === (3))){
var inst_72510 = (state_72512[(2)]);
var state_72512__$1 = state_72512;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72512__$1,inst_72510);
} else {
if((state_val_72513 === (12))){
var inst_72491 = (state_72512[(2)]);
var state_72512__$1 = (function (){var statearr_72519 = state_72512;
(statearr_72519[(8)] = inst_72491);

return statearr_72519;
})();
if(cljs.core.truth_(private$)){
var statearr_72520_72550 = state_72512__$1;
(statearr_72520_72550[(1)] = (13));

} else {
var statearr_72521_72551 = state_72512__$1;
(statearr_72521_72551[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72513 === (2))){
var inst_72467 = (state_72512[(9)]);
var _ = (function (){var statearr_72522 = state_72512;
(statearr_72522[(4)] = cljs.core.cons.call(null,(5),(state_72512[(4)])));

return statearr_72522;
})();
var inst_72467__$1 = jwt;
var state_72512__$1 = (function (){var statearr_72523 = state_72512;
(statearr_72523[(9)] = inst_72467__$1);

return statearr_72523;
})();
if(cljs.core.truth_(inst_72467__$1)){
var statearr_72524_72552 = state_72512__$1;
(statearr_72524_72552[(1)] = (6));

} else {
var statearr_72525_72553 = state_72512__$1;
(statearr_72525_72553[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72513 === (11))){
var inst_72485 = (state_72512[(10)]);
var state_72512__$1 = state_72512;
var statearr_72527_72554 = state_72512__$1;
(statearr_72527_72554[(2)] = inst_72485);

(statearr_72527_72554[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72513 === (9))){
var inst_72477 = (state_72512[(11)]);
var inst_72476 = (state_72512[(12)]);
var inst_72480 = (state_72512[(2)]);
var inst_72481 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_72480),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_72477)].join('');
var inst_72483 = ["Accept"];
var inst_72484 = ["application/json"];
var inst_72485 = cljs.core.PersistentHashMap.fromArrays(inst_72483,inst_72484);
var state_72512__$1 = (function (){var statearr_72528 = state_72512;
(statearr_72528[(10)] = inst_72485);

(statearr_72528[(7)] = inst_72481);

return statearr_72528;
})();
if(cljs.core.truth_(inst_72476)){
var statearr_72529_72555 = state_72512__$1;
(statearr_72529_72555[(1)] = (10));

} else {
var statearr_72530_72556 = state_72512__$1;
(statearr_72530_72556[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72513 === (5))){
var _ = (function (){var statearr_72531 = state_72512;
(statearr_72531[(4)] = cljs.core.rest.call(null,(state_72512[(4)])));

return statearr_72531;
})();
var state_72512__$1 = state_72512;
var ex72526 = (state_72512__$1[(2)]);
var statearr_72532_72557 = state_72512__$1;
(statearr_72532_72557[(5)] = ex72526);


if((ex72526 instanceof Error)){
var statearr_72533_72558 = state_72512__$1;
(statearr_72533_72558[(1)] = (4));

(statearr_72533_72558[(5)] = null);

} else {
throw ex72526;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72513 === (14))){
var inst_72491 = (state_72512[(8)]);
var state_72512__$1 = state_72512;
var statearr_72534_72559 = state_72512__$1;
(statearr_72534_72559[(2)] = inst_72491);

(statearr_72534_72559[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72513 === (16))){
var inst_72506 = (state_72512[(2)]);
var inst_72507 = fluree.db.util.async.throw_err.call(null,inst_72506);
var _ = (function (){var statearr_72535 = state_72512;
(statearr_72535[(4)] = cljs.core.rest.call(null,(state_72512[(4)])));

return statearr_72535;
})();
var state_72512__$1 = state_72512;
var statearr_72536_72560 = state_72512__$1;
(statearr_72536_72560[(2)] = inst_72507);

(statearr_72536_72560[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72513 === (10))){
var inst_72485 = (state_72512[(10)]);
var inst_72476 = (state_72512[(12)]);
var inst_72487 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_72476)].join('');
var inst_72488 = cljs.core.assoc.call(null,inst_72485,"Authorization",inst_72487);
var state_72512__$1 = state_72512;
var statearr_72537_72561 = state_72512__$1;
(statearr_72537_72561[(2)] = inst_72488);

(statearr_72537_72561[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72513 === (8))){
var inst_72476 = (state_72512[(2)]);
var inst_72477 = clojure.string.replace.call(null,k,"_","/");
var inst_72478 = fluree.db.connection.get_server.call(null,conn_id,servers);
var state_72512__$1 = (function (){var statearr_72538 = state_72512;
(statearr_72538[(11)] = inst_72477);

(statearr_72538[(12)] = inst_72476);

return statearr_72538;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72512__$1,(9),inst_72478);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__10903__auto__ = null;
var fluree$db$connection$state_machine__10903__auto____0 = (function (){
var statearr_72539 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72539[(0)] = fluree$db$connection$state_machine__10903__auto__);

(statearr_72539[(1)] = (1));

return statearr_72539;
});
var fluree$db$connection$state_machine__10903__auto____1 = (function (state_72512){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_72512);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e72540){var ex__10906__auto__ = e72540;
var statearr_72541_72562 = state_72512;
(statearr_72541_72562[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_72512[(4)]))){
var statearr_72542_72563 = state_72512;
(statearr_72542_72563[(1)] = cljs.core.first.call(null,(state_72512[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72564 = state_72512;
state_72512 = G__72564;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$connection$state_machine__10903__auto__ = function(state_72512){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__10903__auto____1.call(this,state_72512);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__10903__auto____0;
fluree$db$connection$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__10903__auto____1;
return fluree$db$connection$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_72543 = f__10977__auto__.call(null);
(statearr_72543[(6)] = c__10976__auto__);

return statearr_72543;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.evict,k);
} else {
var temp__5751__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache_atom),k);
if(cljs.core.truth_(temp__5751__auto__)){
var v = temp__5751__auto__;
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = value_fn.call(null,k);
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size);
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_.call(null,fn)){
} else {
throw cljs.core.ex_info.call(null,"add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.call(null,"add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__72565_SHARP_){
if(cljs.core.truth_(p1__72565_SHARP_)){
throw cljs.core.ex_info.call(null,["add-listener key already in use: ",cljs.core.pr_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,key);

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db.call(null,conn,ledger,null);
return fluree.db.connection.add_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__72566_SHARP_){
var or__4253__auto__ = p1__72566_SHARP_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return token;
}
}));

return true;
}catch (e72567){var e = e72567;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__72568 = opts;
var map__72568__$1 = cljs.core.__destructure_map.call(null,map__72568);
var sub_chan = cljs.core.get.call(null,map__72568__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.call(null));
var storage_rename = cljs.core.get.call(null,map__72568__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.call(null,map__72568__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var publish = cljs.core.get.call(null,map__72568__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.call(null,map__72568__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.call(null,map__72568__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.call(null,map__72568__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.call(null,map__72568__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.call(null,map__72568__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var group = cljs.core.get.call(null,map__72568__$1,new cljs.core.Keyword(null,"group","group",582596132));
var meta = cljs.core.get.call(null,map__72568__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.call(null,map__72568__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.call(null,map__72568__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.call(null,map__72568__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.call(null,map__72568__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.call(null,map__72568__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde.call(null));
var memory = cljs.core.get.call(null,map__72568__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.call(null,map__72568__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var storage_write = cljs.core.get.call(null,map__72568__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.call(null,["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.call(null,map__72568__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.call(null,map__72568__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.call(null));
var pub_chan = cljs.core.get.call(null,map__72568__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.call(null));
var private_key_file = cljs.core.get.call(null,map__72568__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.call(null,map__72568__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot.call(null,memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.call(null,["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.call(null,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));
var object_cache_fn = (function (){var or__4253__auto__ = object_cache;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.default_object_cache_fn.call(null,default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid.call(null));
var close = (function (){
cljs.core.async.close_BANG_.call(null,req_chan);

cljs.core.async.close_BANG_.call(null,sub_chan);

cljs.core.async.close_BANG_.call(null,pub_chan);

fluree.db.connection.close_websocket.call(null,conn_id);

cljs.core.swap_BANG_.call(null,state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

if(("nodejs" === cljs.core._STAR_target_STAR_)){
fluree.db.dbfunctions.core.clear_db_fn_cache.call(null);
} else {
}

fluree.db.session.close_all_sessions.call(null,conn_id);

cljs.core.reset_BANG_.call(null,default_cache_atom,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));

if(cljs.core.fn_QMARK_.call(null,close_fn)){
close_fn.call(null);
} else {
}

return fluree.db.util.log.info.call(null,new cljs.core.Keyword(null,"conn-closed","conn-closed",-541764356));
});
var servers_STAR_ = fluree.db.connection.normalize_servers.call(null,servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__4253__auto__ = storage_read;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__4253__auto__ = storage_exists;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = storage_read;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_.call(null,storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.call(null,storage_read)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_.call(null,storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.call(null,storage_exists)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__4251__auto__ = storage_write;
if(cljs.core.truth_(and__4251__auto__)){
return (!(cljs.core.fn_QMARK_.call(null,storage_write)));
} else {
return and__4251__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.call(null,storage_write)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.call(null,fluree.db.connection.add_listener_STAR_,state_atom),group,meta,tx_private_key,cljs.core.partial.call(null,fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_.call(null,keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection.call(null,settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_.call(null,conn))){
return false;
} else {
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn).call(null);

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__4870__auto__ = [];
var len__4864__auto___72609 = arguments.length;
var i__4865__auto___72610 = (0);
while(true){
if((i__4865__auto___72610 < len__4864__auto___72609)){
args__4870__auto__.push((arguments[i__4865__auto___72610]));

var G__72611 = (i__4865__auto___72610 + (1));
i__4865__auto___72610 = G__72611;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__72571){
var vec__72572 = p__72571;
var opts = cljs.core.nth.call(null,vec__72572,(0),null);
var conn = fluree.db.connection.generate_connection.call(null,servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__10976__auto___72612 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_72592){
var state_val_72593 = (state_72592[(1)]);
if((state_val_72593 === (1))){
var inst_72575 = fluree.db.connection.get_socket.call(null,conn);
var state_72592__$1 = state_72592;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72592__$1,(2),inst_72575);
} else {
if((state_val_72593 === (2))){
var inst_72578 = (state_72592[(7)]);
var inst_72577 = (state_72592[(8)]);
var inst_72577__$1 = (state_72592[(2)]);
var inst_72578__$1 = (inst_72577__$1 == null);
var state_72592__$1 = (function (){var statearr_72594 = state_72592;
(statearr_72594[(7)] = inst_72578__$1);

(statearr_72594[(8)] = inst_72577__$1);

return statearr_72594;
})();
if(cljs.core.truth_(inst_72578__$1)){
var statearr_72595_72613 = state_72592__$1;
(statearr_72595_72613[(1)] = (3));

} else {
var statearr_72596_72614 = state_72592__$1;
(statearr_72596_72614[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72593 === (3))){
var inst_72578 = (state_72592[(7)]);
var state_72592__$1 = state_72592;
var statearr_72597_72615 = state_72592__$1;
(statearr_72597_72615[(2)] = inst_72578);

(statearr_72597_72615[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72593 === (4))){
var inst_72577 = (state_72592[(8)]);
var inst_72581 = fluree.db.util.core.exception_QMARK_.call(null,inst_72577);
var state_72592__$1 = state_72592;
var statearr_72598_72616 = state_72592__$1;
(statearr_72598_72616[(2)] = inst_72581);

(statearr_72598_72616[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72593 === (5))){
var inst_72583 = (state_72592[(2)]);
var state_72592__$1 = state_72592;
if(cljs.core.truth_(inst_72583)){
var statearr_72599_72617 = state_72592__$1;
(statearr_72599_72617[(1)] = (6));

} else {
var statearr_72600_72618 = state_72592__$1;
(statearr_72600_72618[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72593 === (6))){
var inst_72577 = (state_72592[(8)]);
var inst_72585 = fluree.db.util.log.error.call(null,inst_72577,"Cannot establish connection to a healthy server, disconnecting.");
var inst_72586 = cljs.core.async.close_BANG_.call(null,conn);
var state_72592__$1 = (function (){var statearr_72601 = state_72592;
(statearr_72601[(9)] = inst_72585);

return statearr_72601;
})();
var statearr_72602_72619 = state_72592__$1;
(statearr_72602_72619[(2)] = inst_72586);

(statearr_72602_72619[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72593 === (7))){
var inst_72588 = fluree.db.connection.msg_consumer.call(null,conn);
var state_72592__$1 = state_72592;
var statearr_72603_72620 = state_72592__$1;
(statearr_72603_72620[(2)] = inst_72588);

(statearr_72603_72620[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72593 === (8))){
var inst_72590 = (state_72592[(2)]);
var state_72592__$1 = state_72592;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72592__$1,inst_72590);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__10903__auto__ = null;
var fluree$db$connection$state_machine__10903__auto____0 = (function (){
var statearr_72604 = [null,null,null,null,null,null,null,null,null,null];
(statearr_72604[(0)] = fluree$db$connection$state_machine__10903__auto__);

(statearr_72604[(1)] = (1));

return statearr_72604;
});
var fluree$db$connection$state_machine__10903__auto____1 = (function (state_72592){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_72592);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e72605){var ex__10906__auto__ = e72605;
var statearr_72606_72621 = state_72592;
(statearr_72606_72621[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_72592[(4)]))){
var statearr_72607_72622 = state_72592;
(statearr_72607_72622[(1)] = cljs.core.first.call(null,(state_72592[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72623 = state_72592;
state_72592 = G__72623;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$connection$state_machine__10903__auto__ = function(state_72592){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__10903__auto____1.call(this,state_72592);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__10903__auto____0;
fluree$db$connection$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__10903__auto____1;
return fluree$db$connection$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_72608 = f__10977__auto__.call(null);
(statearr_72608[(6)] = c__10976__auto___72612);

return statearr_72608;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

}

fluree.db.connection.msg_producer.call(null,conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq72569){
var G__72570 = cljs.core.first.call(null,seq72569);
var seq72569__$1 = cljs.core.next.call(null,seq72569);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72570,seq72569__$1);
}));

