// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(dbid){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__69321 = arguments.length;
switch (G__69321) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db.call(null,conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__10976__auto___69469 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_69408){
var state_val_69409 = (state_69408[(1)]);
if((state_val_69409 === (7))){
var inst_69339 = (state_69408[(7)]);
var inst_69342 = cljs.core.not_EQ_.call(null,(0),inst_69339);
var state_69408__$1 = state_69408;
var statearr_69410_69470 = state_69408__$1;
(statearr_69410_69470[(2)] = inst_69342);

(statearr_69410_69470[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69409 === (20))){
var inst_69334 = (state_69408[(8)]);
var inst_69363 = (state_69408[(9)]);
var inst_69367 = fluree.db.auth.roles.call(null,inst_69334,inst_69363);
var state_69408__$1 = state_69408;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69408__$1,(23),inst_69367);
} else {
if((state_val_69409 === (27))){
var inst_69334 = (state_69408[(8)]);
var inst_69382 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_69383 = fluree.db.time_travel.as_of_block.call(null,inst_69334,inst_69382);
var state_69408__$1 = state_69408;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69408__$1,(30),inst_69383);
} else {
if((state_val_69409 === (1))){
var state_69408__$1 = state_69408;
var statearr_69411_69471 = state_69408__$1;
(statearr_69411_69471[(2)] = null);

(statearr_69411_69471[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69409 === (24))){
var inst_69334 = (state_69408[(8)]);
var inst_69375 = (state_69408[(10)]);
var inst_69377 = fluree.db.permissions.permission_map.call(null,inst_69334,inst_69375,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_69408__$1 = state_69408;
var statearr_69412_69472 = state_69408__$1;
(statearr_69412_69472[(2)] = inst_69377);

(statearr_69412_69472[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69409 === (4))){
var inst_69322 = (state_69408[(2)]);
var inst_69323 = cljs.core.async.put_BANG_.call(null,pc,inst_69322);
var inst_69324 = cljs.core.async.close_BANG_.call(null,pc);
var state_69408__$1 = (function (){var statearr_69413 = state_69408;
(statearr_69413[(11)] = inst_69323);

return statearr_69413;
})();
var statearr_69414_69473 = state_69408__$1;
(statearr_69414_69473[(2)] = inst_69324);

(statearr_69414_69473[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69409 === (15))){
var inst_69339 = (state_69408[(7)]);
var inst_69353 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_69339)," unknown."].join('');
var inst_69354 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69355 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_69356 = cljs.core.PersistentHashMap.fromArrays(inst_69354,inst_69355);
var inst_69357 = cljs.core.ex_info.call(null,inst_69353,inst_69356);
var inst_69358 = (function(){throw inst_69357})();
var state_69408__$1 = state_69408;
var statearr_69415_69474 = state_69408__$1;
(statearr_69415_69474[(2)] = inst_69358);

(statearr_69415_69474[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69409 === (21))){
var state_69408__$1 = state_69408;
var statearr_69416_69475 = state_69408__$1;
(statearr_69416_69475[(2)] = null);

(statearr_69416_69475[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69409 === (31))){
var inst_69339 = (state_69408[(7)]);
var inst_69389 = (state_69408[(12)]);
var inst_69391 = cljs.core.assoc.call(null,inst_69389,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_69339);
var state_69408__$1 = state_69408;
var statearr_69417_69476 = state_69408__$1;
(statearr_69417_69476[(2)] = inst_69391);

(statearr_69417_69476[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69409 === (32))){
var inst_69389 = (state_69408[(12)]);
var state_69408__$1 = state_69408;
var statearr_69418_69477 = state_69408__$1;
(statearr_69418_69477[(2)] = inst_69389);

(statearr_69418_69477[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69409 === (33))){
var inst_69375 = (state_69408[(10)]);
var inst_69394 = (state_69408[(2)]);
var state_69408__$1 = (function (){var statearr_69419 = state_69408;
(statearr_69419[(13)] = inst_69394);

return statearr_69419;
})();
if(cljs.core.truth_(inst_69375)){
var statearr_69420_69478 = state_69408__$1;
(statearr_69420_69478[(1)] = (34));

} else {
var statearr_69421_69479 = state_69408__$1;
(statearr_69421_69479[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69409 === (13))){
var inst_69350 = (state_69408[(14)]);
var inst_69349 = (state_69408[(2)]);
var inst_69350__$1 = fluree.db.util.async.throw_err.call(null,inst_69349);
var state_69408__$1 = (function (){var statearr_69422 = state_69408;
(statearr_69422[(14)] = inst_69350__$1);

return statearr_69422;
})();
if(cljs.core.truth_(inst_69350__$1)){
var statearr_69423_69480 = state_69408__$1;
(statearr_69423_69480[(1)] = (14));

} else {
var statearr_69424_69481 = state_69408__$1;
(statearr_69424_69481[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69409 === (22))){
var inst_69373 = (state_69408[(2)]);
var state_69408__$1 = state_69408;
var statearr_69425_69482 = state_69408__$1;
(statearr_69425_69482[(2)] = inst_69373);

(statearr_69425_69482[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69409 === (36))){
var inst_69402 = (state_69408[(2)]);
var inst_69403 = cljs.core.async.put_BANG_.call(null,pc,inst_69402);
var _ = (function (){var statearr_69426 = state_69408;
(statearr_69426[(4)] = cljs.core.rest.call(null,(state_69408[(4)])));

return statearr_69426;
})();
var state_69408__$1 = state_69408;
var statearr_69427_69483 = state_69408__$1;
(statearr_69427_69483[(2)] = inst_69403);

(statearr_69427_69483[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69409 === (29))){
var inst_69339 = (state_69408[(7)]);
var inst_69389 = (state_69408[(2)]);
var state_69408__$1 = (function (){var statearr_69428 = state_69408;
(statearr_69428[(12)] = inst_69389);

return statearr_69428;
})();
if(cljs.core.truth_(inst_69339)){
var statearr_69429_69484 = state_69408__$1;
(statearr_69429_69484[(1)] = (31));

} else {
var statearr_69430_69485 = state_69408__$1;
(statearr_69430_69485[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69409 === (6))){
var inst_69339 = (state_69408[(7)]);
var inst_69333 = (state_69408[(2)]);
var inst_69334 = fluree.db.util.async.throw_err.call(null,inst_69333);
var inst_69335 = opts;
var inst_69336 = cljs.core.__destructure_map.call(null,inst_69335);
var inst_69337 = cljs.core.get.call(null,inst_69336,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_69338 = cljs.core.get.call(null,inst_69336,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_69339__$1 = cljs.core.get.call(null,inst_69336,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_69340 = cljs.core.get.call(null,inst_69336,new cljs.core.Keyword(null,"block","block",664686210));
var state_69408__$1 = (function (){var statearr_69431 = state_69408;
(statearr_69431[(15)] = inst_69337);

(statearr_69431[(16)] = inst_69340);

(statearr_69431[(7)] = inst_69339__$1);

(statearr_69431[(17)] = inst_69338);

(statearr_69431[(8)] = inst_69334);

return statearr_69431;
})();
if(cljs.core.truth_(inst_69339__$1)){
var statearr_69432_69486 = state_69408__$1;
(statearr_69432_69486[(1)] = (7));

} else {
var statearr_69433_69487 = state_69408__$1;
(statearr_69433_69487[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69409 === (28))){
var inst_69334 = (state_69408[(8)]);
var state_69408__$1 = state_69408;
var statearr_69434_69488 = state_69408__$1;
(statearr_69434_69488[(2)] = inst_69334);

(statearr_69434_69488[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69409 === (25))){
var state_69408__$1 = state_69408;
var statearr_69435_69489 = state_69408__$1;
(statearr_69435_69489[(2)] = null);

(statearr_69435_69489[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69409 === (34))){
var inst_69380 = (state_69408[(18)]);
var state_69408__$1 = state_69408;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69408__$1,(37),inst_69380);
} else {
if((state_val_69409 === (17))){
var inst_69337 = (state_69408[(15)]);
var state_69408__$1 = state_69408;
var statearr_69436_69490 = state_69408__$1;
(statearr_69436_69490[(2)] = inst_69337);

(statearr_69436_69490[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69409 === (3))){
var inst_69406 = (state_69408[(2)]);
var state_69408__$1 = state_69408;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69408__$1,inst_69406);
} else {
if((state_val_69409 === (12))){
var inst_69337 = (state_69408[(15)]);
var inst_69363 = (state_69408[(2)]);
var state_69408__$1 = (function (){var statearr_69437 = state_69408;
(statearr_69437[(9)] = inst_69363);

return statearr_69437;
})();
if(cljs.core.truth_(inst_69337)){
var statearr_69438_69491 = state_69408__$1;
(statearr_69438_69491[(1)] = (17));

} else {
var statearr_69439_69492 = state_69408__$1;
(statearr_69439_69492[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69409 === (2))){
var _ = (function (){var statearr_69440 = state_69408;
(statearr_69440[(4)] = cljs.core.cons.call(null,(5),(state_69408[(4)])));

return statearr_69440;
})();
var inst_69331 = fluree.db.session.db.call(null,conn,ledger,null);
var state_69408__$1 = state_69408;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69408__$1,(6),inst_69331);
} else {
if((state_val_69409 === (23))){
var inst_69369 = (state_69408[(2)]);
var inst_69370 = fluree.db.util.async.throw_err.call(null,inst_69369);
var state_69408__$1 = state_69408;
var statearr_69441_69493 = state_69408__$1;
(statearr_69441_69493[(2)] = inst_69370);

(statearr_69441_69493[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69409 === (35))){
var inst_69394 = (state_69408[(13)]);
var state_69408__$1 = state_69408;
var statearr_69442_69494 = state_69408__$1;
(statearr_69442_69494[(2)] = inst_69394);

(statearr_69442_69494[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69409 === (19))){
var inst_69375 = (state_69408[(10)]);
var inst_69375__$1 = (state_69408[(2)]);
var state_69408__$1 = (function (){var statearr_69443 = state_69408;
(statearr_69443[(10)] = inst_69375__$1);

return statearr_69443;
})();
if(cljs.core.truth_(inst_69375__$1)){
var statearr_69444_69495 = state_69408__$1;
(statearr_69444_69495[(1)] = (24));

} else {
var statearr_69445_69496 = state_69408__$1;
(statearr_69445_69496[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69409 === (11))){
var state_69408__$1 = state_69408;
var statearr_69447_69497 = state_69408__$1;
(statearr_69447_69497[(2)] = null);

(statearr_69447_69497[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69409 === (9))){
var inst_69345 = (state_69408[(2)]);
var state_69408__$1 = state_69408;
if(cljs.core.truth_(inst_69345)){
var statearr_69448_69498 = state_69408__$1;
(statearr_69448_69498[(1)] = (10));

} else {
var statearr_69449_69499 = state_69408__$1;
(statearr_69449_69499[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69409 === (5))){
var _ = (function (){var statearr_69450 = state_69408;
(statearr_69450[(4)] = cljs.core.rest.call(null,(state_69408[(4)])));

return statearr_69450;
})();
var state_69408__$1 = state_69408;
var ex69446 = (state_69408__$1[(2)]);
var statearr_69451_69500 = state_69408__$1;
(statearr_69451_69500[(5)] = ex69446);


var statearr_69452_69501 = state_69408__$1;
(statearr_69452_69501[(1)] = (4));

(statearr_69452_69501[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69409 === (14))){
var inst_69350 = (state_69408[(14)]);
var state_69408__$1 = state_69408;
var statearr_69453_69502 = state_69408__$1;
(statearr_69453_69502[(2)] = inst_69350);

(statearr_69453_69502[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69409 === (26))){
var inst_69340 = (state_69408[(16)]);
var inst_69380 = (state_69408[(2)]);
var state_69408__$1 = (function (){var statearr_69454 = state_69408;
(statearr_69454[(18)] = inst_69380);

return statearr_69454;
})();
if(cljs.core.truth_(inst_69340)){
var statearr_69455_69503 = state_69408__$1;
(statearr_69455_69503[(1)] = (27));

} else {
var statearr_69456_69504 = state_69408__$1;
(statearr_69456_69504[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69409 === (16))){
var inst_69360 = (state_69408[(2)]);
var state_69408__$1 = state_69408;
var statearr_69457_69505 = state_69408__$1;
(statearr_69457_69505[(2)] = inst_69360);

(statearr_69457_69505[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69409 === (30))){
var inst_69385 = (state_69408[(2)]);
var inst_69386 = fluree.db.util.async.throw_err.call(null,inst_69385);
var state_69408__$1 = state_69408;
var statearr_69458_69506 = state_69408__$1;
(statearr_69458_69506[(2)] = inst_69386);

(statearr_69458_69506[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69409 === (10))){
var inst_69339 = (state_69408[(7)]);
var inst_69334 = (state_69408[(8)]);
var inst_69347 = fluree.db.dbproto._subid.call(null,inst_69334,inst_69339);
var state_69408__$1 = state_69408;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69408__$1,(13),inst_69347);
} else {
if((state_val_69409 === (18))){
var inst_69363 = (state_69408[(9)]);
var state_69408__$1 = state_69408;
if(cljs.core.truth_(inst_69363)){
var statearr_69459_69507 = state_69408__$1;
(statearr_69459_69507[(1)] = (20));

} else {
var statearr_69460_69508 = state_69408__$1;
(statearr_69460_69508[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69409 === (37))){
var inst_69394 = (state_69408[(13)]);
var inst_69397 = (state_69408[(2)]);
var inst_69398 = fluree.db.util.async.throw_err.call(null,inst_69397);
var inst_69399 = cljs.core.assoc.call(null,inst_69394,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_69398);
var state_69408__$1 = state_69408;
var statearr_69461_69509 = state_69408__$1;
(statearr_69461_69509[(2)] = inst_69399);

(statearr_69461_69509[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69409 === (8))){
var inst_69339 = (state_69408[(7)]);
var state_69408__$1 = state_69408;
var statearr_69462_69510 = state_69408__$1;
(statearr_69462_69510[(2)] = inst_69339);

(statearr_69462_69510[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__10903__auto__ = null;
var fluree$db$api$query$state_machine__10903__auto____0 = (function (){
var statearr_69463 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69463[(0)] = fluree$db$api$query$state_machine__10903__auto__);

(statearr_69463[(1)] = (1));

return statearr_69463;
});
var fluree$db$api$query$state_machine__10903__auto____1 = (function (state_69408){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_69408);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e69464){var ex__10906__auto__ = e69464;
var statearr_69465_69511 = state_69408;
(statearr_69465_69511[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_69408[(4)]))){
var statearr_69466_69512 = state_69408;
(statearr_69466_69512[(1)] = cljs.core.first.call(null,(state_69408[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69513 = state_69408;
state_69408 = G__69513;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__10903__auto__ = function(state_69408){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__10903__auto____1.call(this,state_69408);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__10903__auto____0;
fluree$db$api$query$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__10903__auto____1;
return fluree$db$api$query$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_69467 = f__10977__auto__.call(null);
(statearr_69467[(6)] = c__10976__auto___69469);

return statearr_69467;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_.call(null,val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.call(null,conn,ledger,opts);
return cljs.core.assoc.call(null,acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_69654){
var state_val_69655 = (state_69654[(1)]);
if((state_val_69655 === (7))){
var inst_69534 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69535 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_69536 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_69537 = [inst_69535,inst_69536];
var inst_69538 = (new cljs.core.PersistentVector(null,2,(5),inst_69534,inst_69537,null));
var state_69654__$1 = state_69654;
var statearr_69656_69726 = state_69654__$1;
(statearr_69656_69726[(2)] = inst_69538);

(statearr_69656_69726[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (20))){
var inst_69564 = (state_69654[(7)]);
var state_69654__$1 = state_69654;
var statearr_69657_69727 = state_69654__$1;
(statearr_69657_69727[(2)] = inst_69564);

(statearr_69657_69727[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (27))){
var state_69654__$1 = state_69654;
var statearr_69658_69728 = state_69654__$1;
(statearr_69658_69728[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (1))){
var state_69654__$1 = state_69654;
var statearr_69660_69729 = state_69654__$1;
(statearr_69660_69729[(2)] = null);

(statearr_69660_69729[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (24))){
var inst_69563 = (state_69654[(8)]);
var state_69654__$1 = state_69654;
if(cljs.core.truth_(inst_69563)){
var statearr_69661_69730 = state_69654__$1;
(statearr_69661_69730[(1)] = (26));

} else {
var statearr_69662_69731 = state_69654__$1;
(statearr_69662_69731[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (39))){
var inst_69609 = (state_69654[(9)]);
var inst_69610 = (state_69654[(10)]);
var inst_69635 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69636 = [inst_69609,inst_69610];
var inst_69637 = (new cljs.core.PersistentVector(null,2,(5),inst_69635,inst_69636,null));
var state_69654__$1 = state_69654;
var statearr_69663_69732 = state_69654__$1;
(statearr_69663_69732[(2)] = inst_69637);

(statearr_69663_69732[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (4))){
var inst_69514 = (state_69654[(2)]);
var state_69654__$1 = state_69654;
var statearr_69664_69733 = state_69654__$1;
(statearr_69664_69733[(2)] = inst_69514);

(statearr_69664_69733[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (15))){
var inst_69543 = (state_69654[(11)]);
var inst_69548 = (state_69654[(12)]);
var inst_69557 = (state_69654[(2)]);
var inst_69558 = [inst_69548,inst_69557];
var inst_69559 = (new cljs.core.PersistentVector(null,2,(5),inst_69543,inst_69558,null));
var state_69654__$1 = state_69654;
var statearr_69665_69734 = state_69654__$1;
(statearr_69665_69734[(2)] = inst_69559);

(statearr_69665_69734[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (21))){
var inst_69563 = (state_69654[(8)]);
var state_69654__$1 = state_69654;
var statearr_69666_69735 = state_69654__$1;
(statearr_69666_69735[(2)] = inst_69563);

(statearr_69666_69735[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (31))){
var inst_69604 = (state_69654[(2)]);
var state_69654__$1 = state_69654;
var statearr_69667_69736 = state_69654__$1;
(statearr_69667_69736[(2)] = inst_69604);

(statearr_69667_69736[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (32))){
var inst_69610 = (state_69654[(10)]);
var inst_69613 = cljs.core.pos_int_QMARK_.call(null,inst_69610);
var state_69654__$1 = state_69654;
var statearr_69668_69737 = state_69654__$1;
(statearr_69668_69737[(2)] = inst_69613);

(statearr_69668_69737[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (40))){
var inst_69641 = (state_69654[(13)]);
var inst_69565 = (state_69654[(14)]);
var inst_69639 = (state_69654[(2)]);
var inst_69640 = cljs.core.nth.call(null,inst_69639,(0),null);
var inst_69641__$1 = cljs.core.nth.call(null,inst_69639,(1),null);
var inst_69642 = (inst_69641__$1 > inst_69565);
var state_69654__$1 = (function (){var statearr_69669 = state_69654;
(statearr_69669[(13)] = inst_69641__$1);

(statearr_69669[(15)] = inst_69640);

return statearr_69669;
})();
if(cljs.core.truth_(inst_69642)){
var statearr_69670_69738 = state_69654__$1;
(statearr_69670_69738[(1)] = (41));

} else {
var statearr_69671_69739 = state_69654__$1;
(statearr_69671_69739[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (33))){
var inst_69611 = (state_69654[(16)]);
var state_69654__$1 = state_69654;
var statearr_69672_69740 = state_69654__$1;
(statearr_69672_69740[(2)] = inst_69611);

(statearr_69672_69740[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (13))){
var inst_69549 = (state_69654[(17)]);
var inst_69551 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_69549);
var state_69654__$1 = state_69654;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69654__$1,(16),inst_69551);
} else {
if((state_val_69655 === (22))){
var inst_69582 = (state_69654[(2)]);
var state_69654__$1 = state_69654;
if(cljs.core.truth_(inst_69582)){
var statearr_69673_69741 = state_69654__$1;
(statearr_69673_69741[(1)] = (23));

} else {
var statearr_69674_69742 = state_69654__$1;
(statearr_69674_69742[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (36))){
var state_69654__$1 = state_69654;
var statearr_69675_69743 = state_69654__$1;
(statearr_69675_69743[(2)] = null);

(statearr_69675_69743[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (41))){
var inst_69565 = (state_69654[(14)]);
var state_69654__$1 = state_69654;
var statearr_69676_69744 = state_69654__$1;
(statearr_69676_69744[(2)] = inst_69565);

(statearr_69676_69744[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (43))){
var inst_69640 = (state_69654[(15)]);
var inst_69646 = (state_69654[(2)]);
var inst_69647 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69648 = [inst_69640,inst_69646];
var inst_69649 = (new cljs.core.PersistentVector(null,2,(5),inst_69647,inst_69648,null));
var _ = (function (){var statearr_69677 = state_69654;
(statearr_69677[(4)] = cljs.core.rest.call(null,(state_69654[(4)])));

return statearr_69677;
})();
var state_69654__$1 = state_69654;
var statearr_69678_69745 = state_69654__$1;
(statearr_69678_69745[(2)] = inst_69649);

(statearr_69678_69745[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (29))){
var inst_69540 = (state_69654[(18)]);
var inst_69595 = cljs.core.pr_str.call(null,inst_69540);
var inst_69596 = ["Invalid block range provided: ",inst_69595].join('');
var inst_69597 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69598 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_69599 = cljs.core.PersistentHashMap.fromArrays(inst_69597,inst_69598);
var inst_69600 = cljs.core.ex_info.call(null,inst_69596,inst_69599);
var inst_69601 = (function(){throw inst_69600})();
var state_69654__$1 = state_69654;
var statearr_69679_69746 = state_69654__$1;
(statearr_69679_69746[(2)] = inst_69601);

(statearr_69679_69746[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (6))){
var inst_69532 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_69654__$1 = state_69654;
var statearr_69680_69747 = state_69654__$1;
(statearr_69680_69747[(2)] = inst_69532);

(statearr_69680_69747[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (28))){
var inst_69606 = (state_69654[(2)]);
var state_69654__$1 = state_69654;
var statearr_69681_69748 = state_69654__$1;
(statearr_69681_69748[(2)] = inst_69606);

(statearr_69681_69748[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (25))){
var inst_69611 = (state_69654[(16)]);
var inst_69609 = (state_69654[(9)]);
var inst_69608 = (state_69654[(2)]);
var inst_69609__$1 = cljs.core.nth.call(null,inst_69608,(0),null);
var inst_69610 = cljs.core.nth.call(null,inst_69608,(1),null);
var inst_69611__$1 = cljs.core.pos_int_QMARK_.call(null,inst_69609__$1);
var state_69654__$1 = (function (){var statearr_69682 = state_69654;
(statearr_69682[(16)] = inst_69611__$1);

(statearr_69682[(9)] = inst_69609__$1);

(statearr_69682[(10)] = inst_69610);

return statearr_69682;
})();
if(inst_69611__$1){
var statearr_69683_69749 = state_69654__$1;
(statearr_69683_69749[(1)] = (32));

} else {
var statearr_69684_69750 = state_69654__$1;
(statearr_69684_69750[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (34))){
var inst_69616 = (state_69654[(2)]);
var inst_69617 = cljs.core.not.call(null,inst_69616);
var state_69654__$1 = state_69654;
if(inst_69617){
var statearr_69685_69751 = state_69654__$1;
(statearr_69685_69751[(1)] = (35));

} else {
var statearr_69686_69752 = state_69654__$1;
(statearr_69686_69752[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (17))){
var inst_69565 = (state_69654[(14)]);
var inst_69563 = (state_69654[(8)]);
var inst_69568 = cljs.core.pr_str.call(null,inst_69563);
var inst_69569 = cljs.core.pr_str.call(null,inst_69565);
var inst_69570 = ["Start block is out of range for this ledger. Start block provided: ",inst_69568,". Database block: ",inst_69569].join('');
var inst_69571 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69572 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_69573 = cljs.core.PersistentHashMap.fromArrays(inst_69571,inst_69572);
var inst_69574 = cljs.core.ex_info.call(null,inst_69570,inst_69573);
var inst_69575 = (function(){throw inst_69574})();
var state_69654__$1 = state_69654;
var statearr_69687_69753 = state_69654__$1;
(statearr_69687_69753[(2)] = inst_69575);

(statearr_69687_69753[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (3))){
var inst_69652 = (state_69654[(2)]);
var state_69654__$1 = state_69654;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69654__$1,inst_69652);
} else {
if((state_val_69655 === (12))){
var inst_69540 = (state_69654[(18)]);
var inst_69549 = (state_69654[(17)]);
var inst_69547 = (state_69654[(2)]);
var inst_69548 = fluree.db.util.async.throw_err.call(null,inst_69547);
var inst_69549__$1 = cljs.core.second.call(null,inst_69540);
var state_69654__$1 = (function (){var statearr_69688 = state_69654;
(statearr_69688[(12)] = inst_69548);

(statearr_69688[(17)] = inst_69549__$1);

return statearr_69688;
})();
if(cljs.core.truth_(inst_69549__$1)){
var statearr_69689_69754 = state_69654__$1;
(statearr_69689_69754[(1)] = (13));

} else {
var statearr_69690_69755 = state_69654__$1;
(statearr_69690_69755[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (2))){
var _ = (function (){var statearr_69691 = state_69654;
(statearr_69691[(4)] = cljs.core.cons.call(null,(5),(state_69654[(4)])));

return statearr_69691;
})();
var inst_69529 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_69530 = cljs.core.sequential_QMARK_.call(null,inst_69529);
var state_69654__$1 = state_69654;
if(inst_69530){
var statearr_69692_69756 = state_69654__$1;
(statearr_69692_69756[(1)] = (6));

} else {
var statearr_69693_69757 = state_69654__$1;
(statearr_69693_69757[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (23))){
var inst_69564 = (state_69654[(7)]);
var inst_69563 = (state_69654[(8)]);
var inst_69584 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69585 = [inst_69563,inst_69564];
var inst_69586 = (new cljs.core.PersistentVector(null,2,(5),inst_69584,inst_69585,null));
var state_69654__$1 = state_69654;
var statearr_69694_69758 = state_69654__$1;
(statearr_69694_69758[(2)] = inst_69586);

(statearr_69694_69758[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (35))){
var inst_69540 = (state_69654[(18)]);
var inst_69619 = cljs.core.pr_str.call(null,inst_69540);
var inst_69620 = ["Invalid block range provided: ",inst_69619].join('');
var inst_69621 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69622 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_69623 = cljs.core.PersistentHashMap.fromArrays(inst_69621,inst_69622);
var inst_69624 = cljs.core.ex_info.call(null,inst_69620,inst_69623);
var inst_69625 = (function(){throw inst_69624})();
var state_69654__$1 = state_69654;
var statearr_69695_69759 = state_69654__$1;
(statearr_69695_69759[(2)] = inst_69625);

(statearr_69695_69759[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (19))){
var inst_69563 = (state_69654[(8)]);
var inst_69578 = (state_69654[(2)]);
var state_69654__$1 = (function (){var statearr_69696 = state_69654;
(statearr_69696[(19)] = inst_69578);

return statearr_69696;
})();
if(cljs.core.truth_(inst_69563)){
var statearr_69697_69760 = state_69654__$1;
(statearr_69697_69760[(1)] = (20));

} else {
var statearr_69698_69761 = state_69654__$1;
(statearr_69698_69761[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (11))){
var inst_69565 = (state_69654[(14)]);
var inst_69563 = (state_69654[(8)]);
var inst_69562 = (state_69654[(2)]);
var inst_69563__$1 = cljs.core.nth.call(null,inst_69562,(0),null);
var inst_69564 = cljs.core.nth.call(null,inst_69562,(1),null);
var inst_69565__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_69566 = (inst_69563__$1 > inst_69565__$1);
var state_69654__$1 = (function (){var statearr_69700 = state_69654;
(statearr_69700[(7)] = inst_69564);

(statearr_69700[(14)] = inst_69565__$1);

(statearr_69700[(8)] = inst_69563__$1);

return statearr_69700;
})();
if(cljs.core.truth_(inst_69566)){
var statearr_69701_69762 = state_69654__$1;
(statearr_69701_69762[(1)] = (17));

} else {
var statearr_69702_69763 = state_69654__$1;
(statearr_69702_69763[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (9))){
var inst_69540 = (state_69654[(18)]);
var inst_69543 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69544 = cljs.core.first.call(null,inst_69540);
var inst_69545 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_69544);
var state_69654__$1 = (function (){var statearr_69703 = state_69654;
(statearr_69703[(11)] = inst_69543);

return statearr_69703;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69654__$1,(12),inst_69545);
} else {
if((state_val_69655 === (5))){
var _ = (function (){var statearr_69704 = state_69654;
(statearr_69704[(4)] = cljs.core.rest.call(null,(state_69654[(4)])));

return statearr_69704;
})();
var state_69654__$1 = state_69654;
var ex69699 = (state_69654__$1[(2)]);
var statearr_69705_69764 = state_69654__$1;
(statearr_69705_69764[(5)] = ex69699);


if((ex69699 instanceof Error)){
var statearr_69706_69765 = state_69654__$1;
(statearr_69706_69765[(1)] = (4));

(statearr_69706_69765[(5)] = null);

} else {
throw ex69699;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (14))){
var state_69654__$1 = state_69654;
var statearr_69707_69766 = state_69654__$1;
(statearr_69707_69766[(2)] = null);

(statearr_69707_69766[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (26))){
var inst_69563 = (state_69654[(8)]);
var inst_69589 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69590 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_69591 = [inst_69563,inst_69590];
var inst_69592 = (new cljs.core.PersistentVector(null,2,(5),inst_69589,inst_69591,null));
var state_69654__$1 = state_69654;
var statearr_69708_69767 = state_69654__$1;
(statearr_69708_69767[(2)] = inst_69592);

(statearr_69708_69767[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (16))){
var inst_69553 = (state_69654[(2)]);
var inst_69554 = fluree.db.util.async.throw_err.call(null,inst_69553);
var state_69654__$1 = state_69654;
var statearr_69709_69768 = state_69654__$1;
(statearr_69709_69768[(2)] = inst_69554);

(statearr_69709_69768[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (38))){
var inst_69609 = (state_69654[(9)]);
var inst_69610 = (state_69654[(10)]);
var inst_69631 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69632 = [inst_69610,inst_69609];
var inst_69633 = (new cljs.core.PersistentVector(null,2,(5),inst_69631,inst_69632,null));
var state_69654__$1 = state_69654;
var statearr_69710_69769 = state_69654__$1;
(statearr_69710_69769[(2)] = inst_69633);

(statearr_69710_69769[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (30))){
var state_69654__$1 = state_69654;
var statearr_69711_69770 = state_69654__$1;
(statearr_69711_69770[(2)] = null);

(statearr_69711_69770[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (10))){
var inst_69540 = (state_69654[(18)]);
var state_69654__$1 = state_69654;
var statearr_69712_69771 = state_69654__$1;
(statearr_69712_69771[(2)] = inst_69540);

(statearr_69712_69771[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (18))){
var state_69654__$1 = state_69654;
var statearr_69713_69772 = state_69654__$1;
(statearr_69713_69772[(2)] = null);

(statearr_69713_69772[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (42))){
var inst_69641 = (state_69654[(13)]);
var state_69654__$1 = state_69654;
var statearr_69714_69773 = state_69654__$1;
(statearr_69714_69773[(2)] = inst_69641);

(statearr_69714_69773[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (37))){
var inst_69609 = (state_69654[(9)]);
var inst_69610 = (state_69654[(10)]);
var inst_69628 = (state_69654[(2)]);
var inst_69629 = (inst_69610 < inst_69609);
var state_69654__$1 = (function (){var statearr_69715 = state_69654;
(statearr_69715[(20)] = inst_69628);

return statearr_69715;
})();
if(cljs.core.truth_(inst_69629)){
var statearr_69716_69774 = state_69654__$1;
(statearr_69716_69774[(1)] = (38));

} else {
var statearr_69717_69775 = state_69654__$1;
(statearr_69717_69775[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69655 === (8))){
var inst_69540 = (state_69654[(18)]);
var inst_69540__$1 = (state_69654[(2)]);
var inst_69541 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_69540__$1);
var state_69654__$1 = (function (){var statearr_69718 = state_69654;
(statearr_69718[(18)] = inst_69540__$1);

return statearr_69718;
})();
if(cljs.core.truth_(inst_69541)){
var statearr_69719_69776 = state_69654__$1;
(statearr_69719_69776[(1)] = (9));

} else {
var statearr_69720_69777 = state_69654__$1;
(statearr_69720_69777[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__10903__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__10903__auto____0 = (function (){
var statearr_69721 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69721[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__10903__auto__);

(statearr_69721[(1)] = (1));

return statearr_69721;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__10903__auto____1 = (function (state_69654){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_69654);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e69722){var ex__10906__auto__ = e69722;
var statearr_69723_69778 = state_69654;
(statearr_69723_69778[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_69654[(4)]))){
var statearr_69724_69779 = state_69654;
(statearr_69724_69779[(1)] = cljs.core.first.call(null,(state_69654[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69780 = state_69654;
state_69654 = G__69780;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__10903__auto__ = function(state_69654){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__10903__auto____1.call(this,state_69654);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__10903__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__10903__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_69725 = f__10977__auto__.call(null);
(statearr_69725[(6)] = c__10976__auto__);

return statearr_69725;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_69930){
var state_val_69931 = (state_69930[(1)]);
if((state_val_69931 === (7))){
var inst_69842 = (state_69930[(2)]);
var inst_69843 = cljs.core.nth.call(null,inst_69842,(0),null);
var inst_69844 = cljs.core.nth.call(null,inst_69842,(1),null);
var inst_69852 = cljs.core.vals.call(null,inst_69844);
var inst_69853 = cljs.core.seq.call(null,inst_69852);
var inst_69854 = cljs.core.first.call(null,inst_69853);
var inst_69855 = cljs.core.next.call(null,inst_69853);
var inst_69856 = cljs.core.PersistentVector.EMPTY;
var inst_69857 = inst_69852;
var inst_69858 = inst_69856;
var state_69930__$1 = (function (){var statearr_69932 = state_69930;
(statearr_69932[(7)] = inst_69858);

(statearr_69932[(8)] = inst_69854);

(statearr_69932[(9)] = inst_69857);

(statearr_69932[(10)] = inst_69855);

(statearr_69932[(11)] = inst_69843);

return statearr_69932;
})();
var statearr_69933_69986 = state_69930__$1;
(statearr_69933_69986[(2)] = null);

(statearr_69933_69986[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69931 === (20))){
var inst_69864 = (state_69930[(12)]);
var inst_69869 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_69870 = cljs.core.PersistentHashMap.EMPTY;
var inst_69871 = [true,inst_69870];
var inst_69872 = cljs.core.PersistentHashMap.fromArrays(inst_69869,inst_69871);
var inst_69873 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_69872,inst_69864);
var state_69930__$1 = state_69930;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69930__$1,(22),inst_69873);
} else {
if((state_val_69931 === (27))){
var inst_69918 = (state_69930[(2)]);
var state_69930__$1 = state_69930;
var statearr_69934_69987 = state_69930__$1;
(statearr_69934_69987[(2)] = inst_69918);

(statearr_69934_69987[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69931 === (1))){
var state_69930__$1 = state_69930;
var statearr_69935_69988 = state_69930__$1;
(statearr_69935_69988[(2)] = null);

(statearr_69935_69988[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69931 === (24))){
var inst_69882 = (state_69930[(13)]);
var inst_69920 = (state_69930[(2)]);
var inst_69921 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_69922 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_69923 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_69924 = [inst_69922,inst_69923,inst_69882,inst_69920];
var inst_69925 = cljs.core.PersistentHashMap.fromArrays(inst_69921,inst_69924);
var _ = (function (){var statearr_69937 = state_69930;
(statearr_69937[(4)] = cljs.core.rest.call(null,(state_69930[(4)])));

return statearr_69937;
})();
var state_69930__$1 = state_69930;
var statearr_69938_69989 = state_69930__$1;
(statearr_69938_69989[(2)] = inst_69925);

(statearr_69938_69989[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69931 === (4))){
var inst_69783 = (state_69930[(2)]);
var state_69930__$1 = state_69930;
var statearr_69939_69990 = state_69930__$1;
(statearr_69939_69990[(2)] = inst_69783);

(statearr_69939_69990[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69931 === (15))){
var inst_69814 = (state_69930[(14)]);
var inst_69806 = (state_69930[(15)]);
var inst_69805 = (state_69930[(16)]);
var inst_69813 = (state_69930[(17)]);
var inst_69823 = (state_69930[(18)]);
var inst_69828 = (state_69930[(19)]);
var inst_69821 = (state_69930[(20)]);
var inst_69807 = (state_69930[(21)]);
var inst_69799 = (state_69930[(22)]);
var inst_69801 = (state_69930[(23)]);
var inst_69802 = (state_69930[(24)]);
var inst_69834 = (function (){var first__69798 = inst_69801;
var subject = inst_69821;
var flake = inst_69813;
var r = inst_69814;
var vec__69796 = inst_69799;
var asserted_subjects = inst_69806;
var seq__69810 = inst_69814;
var first__69811 = inst_69813;
var flake_SINGLEQUOTE_ = inst_69828;
var retracted_subjects = inst_69807;
var seq__69797 = inst_69802;
var G__69795 = inst_69805;
var asserted_QMARK_ = inst_69823;
var vec__69809 = inst_69805;
return (function (p1__69782_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__69782_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_69835 = cljs.core.update.call(null,inst_69807,inst_69821,inst_69834);
var tmp69936 = inst_69806;
var inst_69805__$1 = inst_69814;
var inst_69806__$1 = tmp69936;
var inst_69807__$1 = inst_69835;
var state_69930__$1 = (function (){var statearr_69940 = state_69930;
(statearr_69940[(15)] = inst_69806__$1);

(statearr_69940[(16)] = inst_69805__$1);

(statearr_69940[(21)] = inst_69807__$1);

return statearr_69940;
})();
var statearr_69941_69991 = state_69930__$1;
(statearr_69941_69991[(2)] = null);

(statearr_69941_69991[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69931 === (21))){
var inst_69880 = (state_69930[(2)]);
var state_69930__$1 = state_69930;
var statearr_69942_69992 = state_69930__$1;
(statearr_69942_69992[(2)] = inst_69880);

(statearr_69942_69992[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69931 === (13))){
var inst_69823 = (state_69930[(18)]);
var inst_69828 = (state_69930[(2)]);
var state_69930__$1 = (function (){var statearr_69943 = state_69930;
(statearr_69943[(19)] = inst_69828);

return statearr_69943;
})();
if(cljs.core.truth_(inst_69823)){
var statearr_69944_69993 = state_69930__$1;
(statearr_69944_69993[(1)] = (14));

} else {
var statearr_69945_69994 = state_69930__$1;
(statearr_69945_69994[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69931 === (22))){
var inst_69858 = (state_69930[(7)]);
var inst_69865 = (state_69930[(25)]);
var inst_69875 = (state_69930[(2)]);
var inst_69876 = fluree.db.util.async.throw_err.call(null,inst_69875);
var inst_69877 = cljs.core.conj.call(null,inst_69858,inst_69876);
var inst_69857 = inst_69865;
var inst_69858__$1 = inst_69877;
var state_69930__$1 = (function (){var statearr_69946 = state_69930;
(statearr_69946[(7)] = inst_69858__$1);

(statearr_69946[(9)] = inst_69857);

return statearr_69946;
})();
var statearr_69947_69995 = state_69930__$1;
(statearr_69947_69995[(2)] = null);

(statearr_69947_69995[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69931 === (6))){
var inst_69805 = (state_69930[(16)]);
var inst_69813 = (state_69930[(17)]);
var inst_69812 = cljs.core.seq.call(null,inst_69805);
var inst_69813__$1 = cljs.core.first.call(null,inst_69812);
var inst_69814 = cljs.core.next.call(null,inst_69812);
var inst_69815 = cljs.core.not.call(null,inst_69813__$1);
var state_69930__$1 = (function (){var statearr_69948 = state_69930;
(statearr_69948[(14)] = inst_69814);

(statearr_69948[(17)] = inst_69813__$1);

return statearr_69948;
})();
if(inst_69815){
var statearr_69949_69996 = state_69930__$1;
(statearr_69949_69996[(1)] = (8));

} else {
var statearr_69950_69997 = state_69930__$1;
(statearr_69950_69997[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69931 === (28))){
var inst_69903 = (state_69930[(26)]);
var inst_69896 = (state_69930[(27)]);
var inst_69913 = (state_69930[(2)]);
var inst_69914 = fluree.db.util.async.throw_err.call(null,inst_69913);
var inst_69915 = cljs.core.conj.call(null,inst_69896,inst_69914);
var inst_69895 = inst_69903;
var inst_69896__$1 = inst_69915;
var state_69930__$1 = (function (){var statearr_69951 = state_69930;
(statearr_69951[(27)] = inst_69896__$1);

(statearr_69951[(28)] = inst_69895);

return statearr_69951;
})();
var statearr_69952_69998 = state_69930__$1;
(statearr_69952_69998[(2)] = null);

(statearr_69952_69998[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69931 === (25))){
var inst_69896 = (state_69930[(27)]);
var state_69930__$1 = state_69930;
var statearr_69953_69999 = state_69930__$1;
(statearr_69953_69999[(2)] = inst_69896);

(statearr_69953_69999[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69931 === (17))){
var inst_69857 = (state_69930[(9)]);
var inst_69864 = (state_69930[(12)]);
var inst_69863 = cljs.core.seq.call(null,inst_69857);
var inst_69864__$1 = cljs.core.first.call(null,inst_69863);
var inst_69865 = cljs.core.next.call(null,inst_69863);
var inst_69866 = cljs.core.not.call(null,inst_69864__$1);
var state_69930__$1 = (function (){var statearr_69954 = state_69930;
(statearr_69954[(25)] = inst_69865);

(statearr_69954[(12)] = inst_69864__$1);

return statearr_69954;
})();
if(inst_69866){
var statearr_69955_70000 = state_69930__$1;
(statearr_69955_70000[(1)] = (19));

} else {
var statearr_69956_70001 = state_69930__$1;
(statearr_69956_70001[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69931 === (3))){
var inst_69928 = (state_69930[(2)]);
var state_69930__$1 = state_69930;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69930__$1,inst_69928);
} else {
if((state_val_69931 === (12))){
var inst_69813 = (state_69930[(17)]);
var inst_69826 = fluree.db.flake.flip_flake.call(null,inst_69813);
var state_69930__$1 = state_69930;
var statearr_69957_70002 = state_69930__$1;
(statearr_69957_70002[(2)] = inst_69826);

(statearr_69957_70002[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69931 === (2))){
var inst_69799 = (state_69930[(22)]);
var _ = (function (){var statearr_69958 = state_69930;
(statearr_69958[(4)] = cljs.core.cons.call(null,(5),(state_69930[(4)])));

return statearr_69958;
})();
var inst_69799__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_69800 = cljs.core.seq.call(null,inst_69799__$1);
var inst_69801 = cljs.core.first.call(null,inst_69800);
var inst_69802 = cljs.core.next.call(null,inst_69800);
var inst_69803 = cljs.core.PersistentHashMap.EMPTY;
var inst_69804 = cljs.core.PersistentHashMap.EMPTY;
var inst_69805 = inst_69799__$1;
var inst_69806 = inst_69803;
var inst_69807 = inst_69804;
var state_69930__$1 = (function (){var statearr_69959 = state_69930;
(statearr_69959[(15)] = inst_69806);

(statearr_69959[(16)] = inst_69805);

(statearr_69959[(21)] = inst_69807);

(statearr_69959[(22)] = inst_69799__$1);

(statearr_69959[(23)] = inst_69801);

(statearr_69959[(24)] = inst_69802);

return statearr_69959;
})();
var statearr_69960_70003 = state_69930__$1;
(statearr_69960_70003[(2)] = null);

(statearr_69960_70003[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69931 === (23))){
var inst_69902 = (state_69930[(29)]);
var inst_69895 = (state_69930[(28)]);
var inst_69901 = cljs.core.seq.call(null,inst_69895);
var inst_69902__$1 = cljs.core.first.call(null,inst_69901);
var inst_69903 = cljs.core.next.call(null,inst_69901);
var inst_69904 = cljs.core.not.call(null,inst_69902__$1);
var state_69930__$1 = (function (){var statearr_69961 = state_69930;
(statearr_69961[(26)] = inst_69903);

(statearr_69961[(29)] = inst_69902__$1);

return statearr_69961;
})();
if(inst_69904){
var statearr_69962_70004 = state_69930__$1;
(statearr_69962_70004[(1)] = (25));

} else {
var statearr_69963_70005 = state_69930__$1;
(statearr_69963_70005[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69931 === (19))){
var inst_69858 = (state_69930[(7)]);
var state_69930__$1 = state_69930;
var statearr_69964_70006 = state_69930__$1;
(statearr_69964_70006[(2)] = inst_69858);

(statearr_69964_70006[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69931 === (11))){
var inst_69813 = (state_69930[(17)]);
var state_69930__$1 = state_69930;
var statearr_69966_70007 = state_69930__$1;
(statearr_69966_70007[(2)] = inst_69813);

(statearr_69966_70007[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69931 === (9))){
var inst_69813 = (state_69930[(17)]);
var inst_69823 = (state_69930[(18)]);
var inst_69821 = inst_69813.s;
var inst_69822 = inst_69813.op;
var inst_69823__$1 = inst_69822 === true;
var state_69930__$1 = (function (){var statearr_69968 = state_69930;
(statearr_69968[(18)] = inst_69823__$1);

(statearr_69968[(20)] = inst_69821);

return statearr_69968;
})();
if(cljs.core.truth_(inst_69823__$1)){
var statearr_69969_70008 = state_69930__$1;
(statearr_69969_70008[(1)] = (11));

} else {
var statearr_69970_70009 = state_69930__$1;
(statearr_69970_70009[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69931 === (5))){
var _ = (function (){var statearr_69971 = state_69930;
(statearr_69971[(4)] = cljs.core.rest.call(null,(state_69930[(4)])));

return statearr_69971;
})();
var state_69930__$1 = state_69930;
var ex69965 = (state_69930__$1[(2)]);
var statearr_69972_70010 = state_69930__$1;
(statearr_69972_70010[(5)] = ex69965);


if((ex69965 instanceof Error)){
var statearr_69973_70011 = state_69930__$1;
(statearr_69973_70011[(1)] = (4));

(statearr_69973_70011[(5)] = null);

} else {
throw ex69965;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69931 === (14))){
var inst_69814 = (state_69930[(14)]);
var inst_69806 = (state_69930[(15)]);
var inst_69805 = (state_69930[(16)]);
var inst_69813 = (state_69930[(17)]);
var inst_69823 = (state_69930[(18)]);
var inst_69828 = (state_69930[(19)]);
var inst_69821 = (state_69930[(20)]);
var inst_69807 = (state_69930[(21)]);
var inst_69799 = (state_69930[(22)]);
var inst_69801 = (state_69930[(23)]);
var inst_69802 = (state_69930[(24)]);
var inst_69830 = (function (){var first__69798 = inst_69801;
var subject = inst_69821;
var flake = inst_69813;
var r = inst_69814;
var vec__69796 = inst_69799;
var asserted_subjects = inst_69806;
var seq__69810 = inst_69814;
var first__69811 = inst_69813;
var flake_SINGLEQUOTE_ = inst_69828;
var retracted_subjects = inst_69807;
var seq__69797 = inst_69802;
var G__69795 = inst_69805;
var asserted_QMARK_ = inst_69823;
var vec__69809 = inst_69805;
return (function (p1__69781_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__69781_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_69831 = cljs.core.update.call(null,inst_69806,inst_69821,inst_69830);
var tmp69967 = inst_69807;
var inst_69805__$1 = inst_69814;
var inst_69806__$1 = inst_69831;
var inst_69807__$1 = tmp69967;
var state_69930__$1 = (function (){var statearr_69974 = state_69930;
(statearr_69974[(15)] = inst_69806__$1);

(statearr_69974[(16)] = inst_69805__$1);

(statearr_69974[(21)] = inst_69807__$1);

return statearr_69974;
})();
var statearr_69975_70012 = state_69930__$1;
(statearr_69975_70012[(2)] = null);

(statearr_69975_70012[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69931 === (26))){
var inst_69902 = (state_69930[(29)]);
var inst_69907 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_69908 = cljs.core.PersistentHashMap.EMPTY;
var inst_69909 = [true,inst_69908];
var inst_69910 = cljs.core.PersistentHashMap.fromArrays(inst_69907,inst_69909);
var inst_69911 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_69910,inst_69902);
var state_69930__$1 = state_69930;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69930__$1,(28),inst_69911);
} else {
if((state_val_69931 === (16))){
var inst_69838 = (state_69930[(2)]);
var state_69930__$1 = state_69930;
var statearr_69976_70013 = state_69930__$1;
(statearr_69976_70013[(2)] = inst_69838);

(statearr_69976_70013[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69931 === (10))){
var inst_69840 = (state_69930[(2)]);
var state_69930__$1 = state_69930;
var statearr_69977_70014 = state_69930__$1;
(statearr_69977_70014[(2)] = inst_69840);

(statearr_69977_70014[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69931 === (18))){
var inst_69843 = (state_69930[(11)]);
var inst_69882 = (state_69930[(2)]);
var inst_69890 = cljs.core.vals.call(null,inst_69843);
var inst_69891 = cljs.core.seq.call(null,inst_69890);
var inst_69892 = cljs.core.first.call(null,inst_69891);
var inst_69893 = cljs.core.next.call(null,inst_69891);
var inst_69894 = cljs.core.PersistentVector.EMPTY;
var inst_69895 = inst_69890;
var inst_69896 = inst_69894;
var state_69930__$1 = (function (){var statearr_69978 = state_69930;
(statearr_69978[(30)] = inst_69892);

(statearr_69978[(13)] = inst_69882);

(statearr_69978[(31)] = inst_69893);

(statearr_69978[(27)] = inst_69896);

(statearr_69978[(28)] = inst_69895);

return statearr_69978;
})();
var statearr_69979_70015 = state_69930__$1;
(statearr_69979_70015[(2)] = null);

(statearr_69979_70015[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69931 === (8))){
var inst_69806 = (state_69930[(15)]);
var inst_69807 = (state_69930[(21)]);
var inst_69817 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69818 = [inst_69806,inst_69807];
var inst_69819 = (new cljs.core.PersistentVector(null,2,(5),inst_69817,inst_69818,null));
var state_69930__$1 = state_69930;
var statearr_69980_70016 = state_69930__$1;
(statearr_69980_70016[(2)] = inst_69819);

(statearr_69980_70016[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__10903__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__10903__auto____0 = (function (){
var statearr_69981 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69981[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__10903__auto__);

(statearr_69981[(1)] = (1));

return statearr_69981;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__10903__auto____1 = (function (state_69930){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_69930);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e69982){var ex__10906__auto__ = e69982;
var statearr_69983_70017 = state_69930;
(statearr_69983_70017[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_69930[(4)]))){
var statearr_69984_70018 = state_69930;
(statearr_69984_70018[(1)] = cljs.core.first.call(null,(state_69930[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70019 = state_69930;
state_69930 = G__70019;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__10903__auto__ = function(state_69930){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__10903__auto____1.call(this,state_69930);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__10903__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__10903__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_69985 = f__10977__auto__.call(null);
(statearr_69985[(6)] = c__10976__auto__);

return statearr_69985;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_70051){
var state_val_70052 = (state_70051[(1)]);
if((state_val_70052 === (1))){
var inst_70020 = cljs.core.volatile_BANG_.call(null,(0));
var inst_70021 = cljs.core.PersistentHashMap.EMPTY;
var inst_70022 = cljs.core.volatile_BANG_.call(null,inst_70021);
var inst_70023 = cljs.core.first.call(null,resp);
var inst_70024 = cljs.core.rest.call(null,resp);
var inst_70025 = cljs.core.PersistentVector.EMPTY;
var inst_70026 = inst_70020;
var inst_70027 = inst_70022;
var inst_70028 = inst_70023;
var inst_70029 = inst_70024;
var inst_70030 = inst_70025;
var state_70051__$1 = (function (){var statearr_70053 = state_70051;
(statearr_70053[(7)] = inst_70029);

(statearr_70053[(8)] = inst_70030);

(statearr_70053[(9)] = inst_70028);

(statearr_70053[(10)] = inst_70026);

(statearr_70053[(11)] = inst_70027);

return statearr_70053;
})();
var statearr_70054_70069 = state_70051__$1;
(statearr_70054_70069[(2)] = null);

(statearr_70054_70069[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70052 === (2))){
var inst_70028 = (state_70051[(9)]);
var inst_70026 = (state_70051[(10)]);
var inst_70027 = (state_70051[(11)]);
var inst_70032 = fluree.db.api.query.format_block_resp_pretty.call(null,db,inst_70028,inst_70027,inst_70026);
var state_70051__$1 = state_70051;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70051__$1,(4),inst_70032);
} else {
if((state_val_70052 === (3))){
var inst_70049 = (state_70051[(2)]);
var state_70051__$1 = state_70051;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70051__$1,inst_70049);
} else {
if((state_val_70052 === (4))){
var inst_70029 = (state_70051[(7)]);
var inst_70030 = (state_70051[(8)]);
var inst_70034 = (state_70051[(2)]);
var inst_70035 = fluree.db.util.async.throw_err.call(null,inst_70034);
var inst_70036 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70037 = [inst_70035];
var inst_70038 = (new cljs.core.PersistentVector(null,1,(5),inst_70036,inst_70037,null));
var inst_70039 = cljs.core.concat.call(null,inst_70030,inst_70038);
var inst_70040 = cljs.core.first.call(null,inst_70029);
var state_70051__$1 = (function (){var statearr_70057 = state_70051;
(statearr_70057[(12)] = inst_70039);

return statearr_70057;
})();
if(cljs.core.truth_(inst_70040)){
var statearr_70058_70070 = state_70051__$1;
(statearr_70058_70070[(1)] = (5));

} else {
var statearr_70059_70071 = state_70051__$1;
(statearr_70059_70071[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70052 === (5))){
var inst_70029 = (state_70051[(7)]);
var inst_70026 = (state_70051[(10)]);
var inst_70027 = (state_70051[(11)]);
var inst_70039 = (state_70051[(12)]);
var inst_70042 = cljs.core.first.call(null,inst_70029);
var inst_70043 = cljs.core.rest.call(null,inst_70029);
var tmp70055 = inst_70026;
var tmp70056 = inst_70027;
var inst_70026__$1 = tmp70055;
var inst_70027__$1 = tmp70056;
var inst_70028 = inst_70042;
var inst_70029__$1 = inst_70043;
var inst_70030 = inst_70039;
var state_70051__$1 = (function (){var statearr_70060 = state_70051;
(statearr_70060[(7)] = inst_70029__$1);

(statearr_70060[(8)] = inst_70030);

(statearr_70060[(9)] = inst_70028);

(statearr_70060[(10)] = inst_70026__$1);

(statearr_70060[(11)] = inst_70027__$1);

return statearr_70060;
})();
var statearr_70061_70072 = state_70051__$1;
(statearr_70061_70072[(2)] = null);

(statearr_70061_70072[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70052 === (6))){
var inst_70039 = (state_70051[(12)]);
var state_70051__$1 = state_70051;
var statearr_70062_70073 = state_70051__$1;
(statearr_70062_70073[(2)] = inst_70039);

(statearr_70062_70073[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70052 === (7))){
var inst_70047 = (state_70051[(2)]);
var state_70051__$1 = state_70051;
var statearr_70063_70074 = state_70051__$1;
(statearr_70063_70074[(2)] = inst_70047);

(statearr_70063_70074[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__10903__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__10903__auto____0 = (function (){
var statearr_70064 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70064[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__10903__auto__);

(statearr_70064[(1)] = (1));

return statearr_70064;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__10903__auto____1 = (function (state_70051){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_70051);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e70065){var ex__10906__auto__ = e70065;
var statearr_70066_70075 = state_70051;
(statearr_70066_70075[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_70051[(4)]))){
var statearr_70067_70076 = state_70051;
(statearr_70067_70076[(1)] = cljs.core.first.call(null,(state_70051[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70077 = state_70051;
state_70051 = G__70077;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__10903__auto__ = function(state_70051){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__10903__auto____1.call(this,state_70051);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__10903__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__10903__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_70068 = f__10977__auto__.call(null);
(statearr_70068[(6)] = c__10976__auto__);

return statearr_70068;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__70079 = arguments.length;
switch (G__70079) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.call(null,db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.call(null,db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range.call(null,db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__70081){
var map__70082 = p__70081;
var map__70082__$1 = cljs.core.__destructure_map.call(null,map__70082);
var query = map__70082__$1;
var opts = cljs.core.get.call(null,map__70082__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_70167){
var state_val_70168 = (state_70167[(1)]);
if((state_val_70168 === (7))){
var inst_70093 = (state_70167[(7)]);
var inst_70097 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70098 = ["_auth/id",inst_70093];
var inst_70099 = (new cljs.core.PersistentVector(null,2,(5),inst_70097,inst_70098,null));
var state_70167__$1 = state_70167;
var statearr_70169_70213 = state_70167__$1;
(statearr_70169_70213[(2)] = inst_70099);

(statearr_70169_70213[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70168 === (20))){
var inst_70147 = (state_70167[(2)]);
var inst_70148 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_70167__$1 = (function (){var statearr_70170 = state_70167;
(statearr_70170[(8)] = inst_70147);

return statearr_70170;
})();
if(cljs.core.truth_(inst_70148)){
var statearr_70171_70214 = state_70167__$1;
(statearr_70171_70214[(1)] = (22));

} else {
var statearr_70172_70215 = state_70167__$1;
(statearr_70172_70215[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70168 === (27))){
var inst_70094 = (state_70167[(9)]);
var inst_70150 = (state_70167[(10)]);
var inst_70156 = (state_70167[(2)]);
var inst_70157 = fluree.db.util.core.response_time_formatted.call(null,inst_70094);
var inst_70158 = [(200),inst_70156,(100),inst_70157];
var inst_70159 = cljs.core.PersistentHashMap.fromArrays(inst_70150,inst_70158);
var state_70167__$1 = state_70167;
var statearr_70173_70216 = state_70167__$1;
(statearr_70173_70216[(2)] = inst_70159);

(statearr_70173_70216[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70168 === (1))){
var state_70167__$1 = state_70167;
var statearr_70174_70217 = state_70167__$1;
(statearr_70174_70217[(2)] = null);

(statearr_70174_70217[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70168 === (24))){
var inst_70162 = (state_70167[(2)]);
var _ = (function (){var statearr_70175 = state_70167;
(statearr_70175[(4)] = cljs.core.rest.call(null,(state_70167[(4)])));

return statearr_70175;
})();
var state_70167__$1 = state_70167;
var statearr_70176_70218 = state_70167__$1;
(statearr_70176_70218[(2)] = inst_70162);

(statearr_70176_70218[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70168 === (4))){
var inst_70083 = (state_70167[(2)]);
var state_70167__$1 = state_70167;
var statearr_70177_70219 = state_70167__$1;
(statearr_70177_70219[(2)] = inst_70083);

(statearr_70177_70219[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70168 === (15))){
var inst_70134 = (state_70167[(11)]);
var state_70167__$1 = state_70167;
var statearr_70178_70220 = state_70167__$1;
(statearr_70178_70220[(2)] = inst_70134);

(statearr_70178_70220[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70168 === (21))){
var inst_70143 = (state_70167[(2)]);
var inst_70144 = fluree.db.util.async.throw_err.call(null,inst_70143);
var state_70167__$1 = state_70167;
var statearr_70179_70221 = state_70167__$1;
(statearr_70179_70221[(2)] = inst_70144);

(statearr_70179_70221[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70168 === (13))){
var inst_70092 = (state_70167[(12)]);
var inst_70134 = (state_70167[(11)]);
var inst_70133 = (state_70167[(2)]);
var inst_70134__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_70092);
var state_70167__$1 = (function (){var statearr_70180 = state_70167;
(statearr_70180[(13)] = inst_70133);

(statearr_70180[(11)] = inst_70134__$1);

return statearr_70180;
})();
if(cljs.core.truth_(inst_70134__$1)){
var statearr_70181_70222 = state_70167__$1;
(statearr_70181_70222[(1)] = (15));

} else {
var statearr_70182_70223 = state_70167__$1;
(statearr_70182_70223[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70168 === (22))){
var inst_70147 = (state_70167[(8)]);
var inst_70150 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_70151 = cljs.core.sequential_QMARK_.call(null,inst_70147);
var state_70167__$1 = (function (){var statearr_70183 = state_70167;
(statearr_70183[(10)] = inst_70150);

return statearr_70183;
})();
if(inst_70151){
var statearr_70184_70224 = state_70167__$1;
(statearr_70184_70224[(1)] = (25));

} else {
var statearr_70185_70225 = state_70167__$1;
(statearr_70185_70225[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70168 === (6))){
var inst_70092 = (state_70167[(12)]);
var inst_70108 = (state_70167[(14)]);
var inst_70107 = (state_70167[(2)]);
var inst_70108__$1 = fluree.db.util.async.throw_err.call(null,inst_70107);
var inst_70109 = fluree.db.api.query.resolve_block_range.call(null,inst_70108__$1,inst_70092);
var state_70167__$1 = (function (){var statearr_70186 = state_70167;
(statearr_70186[(14)] = inst_70108__$1);

return statearr_70186;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70167__$1,(10),inst_70109);
} else {
if((state_val_70168 === (25))){
var inst_70147 = (state_70167[(8)]);
var inst_70153 = cljs.core.doall.call(null,inst_70147);
var state_70167__$1 = state_70167;
var statearr_70187_70226 = state_70167__$1;
(statearr_70187_70226[(2)] = inst_70153);

(statearr_70187_70226[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70168 === (17))){
var inst_70139 = (state_70167[(2)]);
var state_70167__$1 = state_70167;
if(cljs.core.truth_(inst_70139)){
var statearr_70188_70227 = state_70167__$1;
(statearr_70188_70227[(1)] = (18));

} else {
var statearr_70189_70228 = state_70167__$1;
(statearr_70189_70228[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70168 === (3))){
var inst_70165 = (state_70167[(2)]);
var state_70167__$1 = state_70167;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70167__$1,inst_70165);
} else {
if((state_val_70168 === (12))){
var inst_70092 = (state_70167[(12)]);
var inst_70125 = cljs.core.pr_str.call(null,inst_70092);
var inst_70126 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_70125].join('');
var inst_70127 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70128 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70129 = cljs.core.PersistentHashMap.fromArrays(inst_70127,inst_70128);
var inst_70130 = cljs.core.ex_info.call(null,inst_70126,inst_70129);
var inst_70131 = (function(){throw inst_70130})();
var state_70167__$1 = state_70167;
var statearr_70190_70229 = state_70167__$1;
(statearr_70190_70229[(2)] = inst_70131);

(statearr_70190_70229[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70168 === (2))){
var inst_70093 = (state_70167[(7)]);
var _ = (function (){var statearr_70191 = state_70167;
(statearr_70191[(4)] = cljs.core.cons.call(null,(5),(state_70167[(4)])));

return statearr_70191;
})();
var inst_70092 = cljs.core.dissoc.call(null,query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_70093__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_70094 = fluree.db.util.core.current_time_millis.call(null);
var inst_70095 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_70167__$1 = (function (){var statearr_70192 = state_70167;
(statearr_70192[(12)] = inst_70092);

(statearr_70192[(9)] = inst_70094);

(statearr_70192[(15)] = inst_70095);

(statearr_70192[(7)] = inst_70093__$1);

return statearr_70192;
})();
if(cljs.core.truth_(inst_70093__$1)){
var statearr_70193_70230 = state_70167__$1;
(statearr_70193_70230[(1)] = (7));

} else {
var statearr_70194_70231 = state_70167__$1;
(statearr_70194_70231[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70168 === (23))){
var inst_70147 = (state_70167[(8)]);
var state_70167__$1 = state_70167;
var statearr_70195_70232 = state_70167__$1;
(statearr_70195_70232[(2)] = inst_70147);

(statearr_70195_70232[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70168 === (19))){
var inst_70133 = (state_70167[(13)]);
var state_70167__$1 = state_70167;
var statearr_70196_70233 = state_70167__$1;
(statearr_70196_70233[(2)] = inst_70133);

(statearr_70196_70233[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70168 === (11))){
var inst_70108 = (state_70167[(14)]);
var inst_70114 = (state_70167[(16)]);
var inst_70113 = (state_70167[(17)]);
var inst_70120 = fluree.db.api.query.block_range.call(null,inst_70108,inst_70113,inst_70114,opts);
var state_70167__$1 = state_70167;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70167__$1,(14),inst_70120);
} else {
if((state_val_70168 === (9))){
var inst_70095 = (state_70167[(15)]);
var inst_70102 = (state_70167[(2)]);
var inst_70103 = [inst_70102];
var inst_70104 = cljs.core.PersistentHashMap.fromArrays(inst_70095,inst_70103);
var inst_70105 = fluree.db.api.query.db.call(null,conn,ledger,inst_70104);
var state_70167__$1 = state_70167;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70167__$1,(6),inst_70105);
} else {
if((state_val_70168 === (5))){
var _ = (function (){var statearr_70198 = state_70167;
(statearr_70198[(4)] = cljs.core.rest.call(null,(state_70167[(4)])));

return statearr_70198;
})();
var state_70167__$1 = state_70167;
var ex70197 = (state_70167__$1[(2)]);
var statearr_70199_70234 = state_70167__$1;
(statearr_70199_70234[(5)] = ex70197);


if((ex70197 instanceof Error)){
var statearr_70200_70235 = state_70167__$1;
(statearr_70200_70235[(1)] = (4));

(statearr_70200_70235[(5)] = null);

} else {
throw ex70197;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70168 === (14))){
var inst_70122 = (state_70167[(2)]);
var inst_70123 = fluree.db.util.async.throw_err.call(null,inst_70122);
var state_70167__$1 = state_70167;
var statearr_70201_70236 = state_70167__$1;
(statearr_70201_70236[(2)] = inst_70123);

(statearr_70201_70236[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70168 === (26))){
var inst_70147 = (state_70167[(8)]);
var state_70167__$1 = state_70167;
var statearr_70202_70237 = state_70167__$1;
(statearr_70202_70237[(2)] = inst_70147);

(statearr_70202_70237[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70168 === (16))){
var inst_70092 = (state_70167[(12)]);
var inst_70137 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_70092);
var state_70167__$1 = state_70167;
var statearr_70203_70238 = state_70167__$1;
(statearr_70203_70238[(2)] = inst_70137);

(statearr_70203_70238[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70168 === (10))){
var inst_70092 = (state_70167[(12)]);
var inst_70111 = (state_70167[(2)]);
var inst_70112 = fluree.db.util.async.throw_err.call(null,inst_70111);
var inst_70113 = cljs.core.nth.call(null,inst_70112,(0),null);
var inst_70114 = cljs.core.nth.call(null,inst_70112,(1),null);
var inst_70115 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_70116 = cljs.core.dissoc.call(null,inst_70092,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_70117 = cljs.core.keys.call(null,inst_70116);
var inst_70118 = cljs.core._EQ_.call(null,inst_70115,inst_70117);
var state_70167__$1 = (function (){var statearr_70204 = state_70167;
(statearr_70204[(16)] = inst_70114);

(statearr_70204[(17)] = inst_70113);

return statearr_70204;
})();
if(inst_70118){
var statearr_70205_70239 = state_70167__$1;
(statearr_70205_70239[(1)] = (11));

} else {
var statearr_70206_70240 = state_70167__$1;
(statearr_70206_70240[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70168 === (18))){
var inst_70108 = (state_70167[(14)]);
var inst_70133 = (state_70167[(13)]);
var inst_70141 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_70108,inst_70133);
var state_70167__$1 = state_70167;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70167__$1,(21),inst_70141);
} else {
if((state_val_70168 === (8))){
var state_70167__$1 = state_70167;
var statearr_70207_70241 = state_70167__$1;
(statearr_70207_70241[(2)] = null);

(statearr_70207_70241[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__10903__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__10903__auto____0 = (function (){
var statearr_70208 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70208[(0)] = fluree$db$api$query$block_query_async_$_state_machine__10903__auto__);

(statearr_70208[(1)] = (1));

return statearr_70208;
});
var fluree$db$api$query$block_query_async_$_state_machine__10903__auto____1 = (function (state_70167){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_70167);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e70209){var ex__10906__auto__ = e70209;
var statearr_70210_70242 = state_70167;
(statearr_70210_70242[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_70167[(4)]))){
var statearr_70211_70243 = state_70167;
(statearr_70211_70243[(1)] = cljs.core.first.call(null,(state_70167[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70244 = state_70167;
state_70167 = G__70244;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__10903__auto__ = function(state_70167){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__10903__auto____1.call(this,state_70167);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__10903__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__10903__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_70212 = f__10977__auto__.call(null);
(statearr_70212[(6)] = c__10976__auto__);

return statearr_70212;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_.call(null,history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_.call(null,history))?((cljs.core.empty_QMARK_.call(null,history))?(function(){throw cljs.core.ex_info.call(null,["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__70245 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.call(null,subject,(0)),cljs.core.get.call(null,subject,(1)),cljs.core.get.call(null,subject,(2)),cljs.core.get.call(null,subject,(3))], null);
var s = cljs.core.nth.call(null,vec__70245,(0),null);
var p = cljs.core.nth.call(null,vec__70245,(1),null);
var o = cljs.core.nth.call(null,vec__70245,(2),null);
var t = cljs.core.nth.call(null,vec__70245,(3),null);
var vec__70248 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((((!((p == null)))) && ((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((((!((p == null)))) && ((!((o == null))))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.call(null,vec__70248,(0),null);
var idx = cljs.core.nth.call(null,vec__70248,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__70251 = cljs.core.get_in.call(null,t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [flake.t,new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.call(null,vec__70251,(0),null);
var id = cljs.core.nth.call(null,vec__70251,(1),null);
var or__4253__auto__ = auth_set.call(null,auth);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return auth_set.call(null,id);
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70255 = arguments.length;
var i__4865__auto___70256 = (0);
while(true){
if((i__4865__auto___70256 < len__4864__auto___70255)){
args__4870__auto__.push((arguments[i__4865__auto___70256]));

var G__70257 = (i__4865__auto___70256 + (1));
i__4865__auto___70256 = G__70257;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq70254){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq70254));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_70453){
var state_val_70454 = (state_70453[(1)]);
if((state_val_70454 === (7))){
var inst_70380 = (state_70453[(7)]);
var inst_70373 = (state_70453[(8)]);
var inst_70379 = cljs.core.seq.call(null,inst_70373);
var inst_70380__$1 = cljs.core.first.call(null,inst_70379);
var inst_70381 = cljs.core.next.call(null,inst_70379);
var state_70453__$1 = (function (){var statearr_70455 = state_70453;
(statearr_70455[(7)] = inst_70380__$1);

(statearr_70455[(9)] = inst_70381);

return statearr_70455;
})();
if(cljs.core.truth_(inst_70380__$1)){
var statearr_70456_70556 = state_70453__$1;
(statearr_70456_70556[(1)] = (9));

} else {
var statearr_70457_70557 = state_70453__$1;
(statearr_70457_70557[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (20))){
var inst_70443 = (state_70453[(2)]);
var state_70453__$1 = state_70453;
var statearr_70458_70558 = state_70453__$1;
(statearr_70458_70558[(2)] = inst_70443);

(statearr_70458_70558[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (27))){
var inst_70401 = (state_70453[(10)]);
var inst_70419 = (state_70453[(11)]);
var inst_70398 = (state_70453[(12)]);
var inst_70421 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70422 = [inst_70401,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_70423 = (new cljs.core.PersistentVector(null,2,(5),inst_70421,inst_70422,null));
var inst_70424 = cljs.core.update_in.call(null,inst_70419,inst_70423,fluree.db.api.query.min_safe,inst_70398);
var state_70453__$1 = state_70453;
var statearr_70459_70559 = state_70453__$1;
(statearr_70459_70559[(2)] = inst_70424);

(statearr_70459_70559[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (1))){
var state_70453__$1 = state_70453;
var statearr_70460_70560 = state_70453__$1;
(statearr_70460_70560[(2)] = null);

(statearr_70460_70560[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (24))){
var inst_70411 = (state_70453[(13)]);
var inst_70380 = (state_70453[(7)]);
var inst_70401 = (state_70453[(10)]);
var inst_70413 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70414 = [inst_70401,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_70415 = (new cljs.core.PersistentVector(null,2,(5),inst_70413,inst_70414,null));
var inst_70416 = cljs.core.update_in.call(null,inst_70411,inst_70415,cljs.core.conj,inst_70380);
var state_70453__$1 = state_70453;
var statearr_70462_70561 = state_70453__$1;
(statearr_70462_70561[(2)] = inst_70416);

(statearr_70462_70561[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (4))){
var inst_70259 = (state_70453[(2)]);
var state_70453__$1 = state_70453;
var statearr_70463_70562 = state_70453__$1;
(statearr_70463_70562[(2)] = inst_70259);

(statearr_70463_70562[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (15))){
var inst_70374 = (state_70453[(14)]);
var inst_70381 = (state_70453[(9)]);
var tmp70461 = inst_70374;
var inst_70373 = inst_70381;
var inst_70374__$1 = tmp70461;
var state_70453__$1 = (function (){var statearr_70464 = state_70453;
(statearr_70464[(14)] = inst_70374__$1);

(statearr_70464[(8)] = inst_70373);

return statearr_70464;
})();
var statearr_70465_70563 = state_70453__$1;
(statearr_70465_70563[(2)] = null);

(statearr_70465_70563[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (21))){
var inst_70374 = (state_70453[(14)]);
var inst_70401 = (state_70453[(10)]);
var inst_70405 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70406 = [inst_70401,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_70407 = (new cljs.core.PersistentVector(null,2,(5),inst_70405,inst_70406,null));
var inst_70408 = cljs.core.assoc_in.call(null,inst_70374,inst_70407,inst_70401);
var state_70453__$1 = state_70453;
var statearr_70466_70564 = state_70453__$1;
(statearr_70466_70564[(2)] = inst_70408);

(statearr_70466_70564[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (31))){
var inst_70427 = (state_70453[(15)]);
var state_70453__$1 = state_70453;
var statearr_70467_70565 = state_70453__$1;
(statearr_70467_70565[(2)] = inst_70427);

(statearr_70467_70565[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (32))){
var inst_70381 = (state_70453[(9)]);
var inst_70435 = (state_70453[(2)]);
var inst_70373 = inst_70381;
var inst_70374 = inst_70435;
var state_70453__$1 = (function (){var statearr_70468 = state_70453;
(statearr_70468[(14)] = inst_70374);

(statearr_70468[(8)] = inst_70373);

return statearr_70468;
})();
var statearr_70469_70566 = state_70453__$1;
(statearr_70469_70566[(2)] = null);

(statearr_70469_70566[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (33))){
var inst_70374 = (state_70453[(14)]);
var state_70453__$1 = state_70453;
var statearr_70470_70567 = state_70453__$1;
(statearr_70470_70567[(2)] = inst_70374);

(statearr_70470_70567[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (13))){
var inst_70383 = (state_70453[(16)]);
var state_70453__$1 = state_70453;
var statearr_70471_70568 = state_70453__$1;
(statearr_70471_70568[(2)] = inst_70383);

(statearr_70471_70568[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (22))){
var inst_70374 = (state_70453[(14)]);
var state_70453__$1 = state_70453;
var statearr_70472_70569 = state_70453__$1;
(statearr_70472_70569[(2)] = inst_70374);

(statearr_70472_70569[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (29))){
var inst_70427 = (state_70453[(2)]);
var state_70453__$1 = (function (){var statearr_70473 = state_70453;
(statearr_70473[(15)] = inst_70427);

return statearr_70473;
})();
if(cljs.core.truth_(show_auth)){
var statearr_70474_70570 = state_70453__$1;
(statearr_70474_70570[(1)] = (30));

} else {
var statearr_70475_70571 = state_70453__$1;
(statearr_70475_70571[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (6))){
var inst_70359 = (state_70453[(2)]);
var inst_70360 = fluree.db.util.async.throw_err.call(null,inst_70359);
var inst_70368 = resp;
var inst_70369 = cljs.core.seq.call(null,inst_70368);
var inst_70370 = cljs.core.first.call(null,inst_70369);
var inst_70371 = cljs.core.next.call(null,inst_70369);
var inst_70372 = cljs.core.PersistentHashMap.EMPTY;
var inst_70373 = inst_70368;
var inst_70374 = inst_70372;
var state_70453__$1 = (function (){var statearr_70476 = state_70453;
(statearr_70476[(17)] = inst_70370);

(statearr_70476[(18)] = inst_70360);

(statearr_70476[(14)] = inst_70374);

(statearr_70476[(19)] = inst_70371);

(statearr_70476[(8)] = inst_70373);

return statearr_70476;
})();
var statearr_70477_70572 = state_70453__$1;
(statearr_70477_70572[(2)] = null);

(statearr_70477_70572[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (28))){
var inst_70419 = (state_70453[(11)]);
var state_70453__$1 = state_70453;
var statearr_70478_70573 = state_70453__$1;
(statearr_70478_70573[(2)] = inst_70419);

(statearr_70478_70573[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (25))){
var inst_70411 = (state_70453[(13)]);
var state_70453__$1 = state_70453;
var statearr_70479_70574 = state_70453__$1;
(statearr_70479_70574[(2)] = inst_70411);

(statearr_70479_70574[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (34))){
var state_70453__$1 = state_70453;
var statearr_70480_70575 = state_70453__$1;
(statearr_70480_70575[(2)] = null);

(statearr_70480_70575[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (17))){
var inst_70445 = (state_70453[(2)]);
var state_70453__$1 = state_70453;
var statearr_70481_70576 = state_70453__$1;
(statearr_70481_70576[(2)] = inst_70445);

(statearr_70481_70576[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (3))){
var inst_70451 = (state_70453[(2)]);
var state_70453__$1 = state_70453;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70453__$1,inst_70451);
} else {
if((state_val_70454 === (12))){
var inst_70360 = (state_70453[(18)]);
var inst_70380 = (state_70453[(7)]);
var inst_70385 = fluree.db.api.query.auth_match.call(null,auth,inst_70360,inst_70380);
var inst_70386 = cljs.core.not.call(null,inst_70385);
var state_70453__$1 = state_70453;
var statearr_70482_70577 = state_70453__$1;
(statearr_70482_70577[(2)] = inst_70386);

(statearr_70482_70577[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (2))){
var _ = (function (){var statearr_70483 = state_70453;
(statearr_70483[(4)] = cljs.core.cons.call(null,(5),(state_70453[(4)])));

return statearr_70483;
})();
var inst_70265 = (function (){return (function (p1__70258_SHARP_){
return p1__70258_SHARP_.t;
});
})();
var inst_70266 = cljs.core.map.call(null,inst_70265,resp);
var inst_70267 = cljs.core.set.call(null,inst_70266);
var inst_70355 = cljs.core.async.chan.call(null,(1));
var inst_70356 = (function (){var ts = inst_70267;
var c__10976__auto____$1 = inst_70355;
return (function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_70353){
var state_val_70354 = (state_70353[(1)]);
if((state_val_70354 === (7))){
var inst_70293 = (state_70353[(7)]);
var inst_70281 = (state_70353[(8)]);
var inst_70299 = (state_70353[(9)]);
var inst_70287 = (state_70353[(10)]);
var inst_70292 = (state_70353[(2)]);
var inst_70293__$1 = fluree.db.util.async.throw_err.call(null,inst_70292);
var inst_70295 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70296 = [inst_70287,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_70297 = (new cljs.core.PersistentVector(null,2,(5),inst_70295,inst_70296,null));
var inst_70298 = cljs.core.assoc_in.call(null,inst_70281,inst_70297,inst_70293__$1);
var inst_70299__$1 = auth;
var state_70353__$1 = (function (){var statearr_70484 = state_70353;
(statearr_70484[(11)] = inst_70298);

(statearr_70484[(7)] = inst_70293__$1);

(statearr_70484[(9)] = inst_70299__$1);

return statearr_70484;
})();
if(cljs.core.truth_(inst_70299__$1)){
var statearr_70485_70578 = state_70353__$1;
(statearr_70485_70578[(1)] = (8));

} else {
var statearr_70486_70579 = state_70353__$1;
(statearr_70486_70579[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70354 === (1))){
var inst_70275 = (state_70353[(12)]);
var inst_70275__$1 = ts;
var inst_70276 = cljs.core.seq.call(null,inst_70275__$1);
var inst_70277 = cljs.core.first.call(null,inst_70276);
var inst_70278 = cljs.core.next.call(null,inst_70276);
var inst_70279 = cljs.core.PersistentHashMap.EMPTY;
var inst_70280 = inst_70275__$1;
var inst_70281 = inst_70279;
var state_70353__$1 = (function (){var statearr_70487 = state_70353;
(statearr_70487[(13)] = inst_70280);

(statearr_70487[(14)] = inst_70278);

(statearr_70487[(15)] = inst_70277);

(statearr_70487[(8)] = inst_70281);

(statearr_70487[(12)] = inst_70275__$1);

return statearr_70487;
})();
var statearr_70488_70580 = state_70353__$1;
(statearr_70488_70580[(2)] = null);

(statearr_70488_70580[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70354 === (4))){
var inst_70287 = (state_70353[(10)]);
var inst_70290 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_70287);
var state_70353__$1 = state_70353;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70353__$1,(7),inst_70290);
} else {
if((state_val_70354 === (13))){
var inst_70288 = (state_70353[(16)]);
var inst_70345 = (state_70353[(2)]);
var inst_70280 = inst_70288;
var inst_70281 = inst_70345;
var state_70353__$1 = (function (){var statearr_70489 = state_70353;
(statearr_70489[(13)] = inst_70280);

(statearr_70489[(8)] = inst_70281);

return statearr_70489;
})();
var statearr_70490_70581 = state_70353__$1;
(statearr_70490_70581[(2)] = null);

(statearr_70490_70581[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70354 === (6))){
var inst_70349 = (state_70353[(2)]);
var state_70353__$1 = state_70353;
var statearr_70491_70582 = state_70353__$1;
(statearr_70491_70582[(2)] = inst_70349);

(statearr_70491_70582[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70354 === (3))){
var inst_70351 = (state_70353[(2)]);
var state_70353__$1 = state_70353;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70353__$1,inst_70351);
} else {
if((state_val_70354 === (12))){
var inst_70298 = (state_70353[(11)]);
var state_70353__$1 = state_70353;
var statearr_70492_70583 = state_70353__$1;
(statearr_70492_70583[(2)] = inst_70298);

(statearr_70492_70583[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70354 === (2))){
var inst_70280 = (state_70353[(13)]);
var inst_70287 = (state_70353[(10)]);
var inst_70286 = cljs.core.seq.call(null,inst_70280);
var inst_70287__$1 = cljs.core.first.call(null,inst_70286);
var inst_70288 = cljs.core.next.call(null,inst_70286);
var state_70353__$1 = (function (){var statearr_70493 = state_70353;
(statearr_70493[(16)] = inst_70288);

(statearr_70493[(10)] = inst_70287__$1);

return statearr_70493;
})();
if(cljs.core.truth_(inst_70287__$1)){
var statearr_70494_70584 = state_70353__$1;
(statearr_70494_70584[(1)] = (4));

} else {
var statearr_70495_70585 = state_70353__$1;
(statearr_70495_70585[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70354 === (11))){
var inst_70298 = (state_70353[(11)]);
var inst_70293 = (state_70353[(7)]);
var inst_70280 = (state_70353[(13)]);
var inst_70288 = (state_70353[(16)]);
var inst_70278 = (state_70353[(14)]);
var inst_70277 = (state_70353[(15)]);
var inst_70281 = (state_70353[(8)]);
var inst_70275 = (state_70353[(12)]);
var inst_70287 = (state_70353[(10)]);
var inst_70305 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70306 = [inst_70287,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_70307 = (new cljs.core.PersistentVector(null,2,(5),inst_70305,inst_70306,null));
var inst_70320 = cljs.core.async.chan.call(null,(1));
var inst_70321 = (function (){var t = inst_70287;
var G__70294 = inst_70298;
var vec__70283 = inst_70280;
var G__70271 = inst_70280;
var seq__70284 = inst_70288;
var block = inst_70293;
var r = inst_70288;
var seq__70273 = inst_70278;
var first__70274 = inst_70277;
var acc = inst_70281;
var c__10976__auto____$2 = inst_70320;
var vec__70272 = inst_70275;
var first__70285 = inst_70287;
return (function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_70318){
var state_val_70319 = (state_70318[(1)]);
if((state_val_70319 === (1))){
var state_70318__$1 = state_70318;
var statearr_70496_70586 = state_70318__$1;
(statearr_70496_70586[(2)] = null);

(statearr_70496_70586[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70319 === (2))){
var ___$1 = (function (){var statearr_70497 = state_70318;
(statearr_70497[(4)] = cljs.core.cons.call(null,(5),(state_70318[(4)])));

return statearr_70497;
})();
var ___$2 = (function (){var statearr_70498 = state_70318;
(statearr_70498[(4)] = cljs.core.rest.call(null,(state_70318[(4)])));

return statearr_70498;
})();
var state_70318__$1 = state_70318;
var statearr_70499_70587 = state_70318__$1;
(statearr_70499_70587[(2)] = db);

(statearr_70499_70587[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70319 === (3))){
var inst_70316 = (state_70318[(2)]);
var state_70318__$1 = state_70318;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70318__$1,inst_70316);
} else {
if((state_val_70319 === (4))){
var inst_70308 = (state_70318[(2)]);
var state_70318__$1 = state_70318;
var statearr_70501_70588 = state_70318__$1;
(statearr_70501_70588[(2)] = inst_70308);

(statearr_70501_70588[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70319 === (5))){
var ___$1 = (function (){var statearr_70502 = state_70318;
(statearr_70502[(4)] = cljs.core.rest.call(null,(state_70318[(4)])));

return statearr_70502;
})();
var state_70318__$1 = state_70318;
var ex70500 = (state_70318__$1[(2)]);
var statearr_70503_70589 = state_70318__$1;
(statearr_70503_70589[(5)] = ex70500);


if((ex70500 instanceof Error)){
var statearr_70504_70590 = state_70318__$1;
(statearr_70504_70590[(1)] = (4));

(statearr_70504_70590[(5)] = null);

} else {
throw ex70500;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__10903__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__10903__auto____0 = (function (){
var statearr_70505 = [null,null,null,null,null,null,null];
(statearr_70505[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__10903__auto__);

(statearr_70505[(1)] = (1));

return statearr_70505;
});
var fluree$db$api$query$format_history_resp_$_state_machine__10903__auto____1 = (function (state_70318){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_70318);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e70506){var ex__10906__auto__ = e70506;
var statearr_70507_70591 = state_70318;
(statearr_70507_70591[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_70318[(4)]))){
var statearr_70508_70592 = state_70318;
(statearr_70508_70592[(1)] = cljs.core.first.call(null,(state_70318[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70593 = state_70318;
state_70318 = G__70593;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__10903__auto__ = function(state_70318){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__10903__auto____1.call(this,state_70318);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__10903__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__10903__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_70509 = f__10977__auto__.call(null);
(statearr_70509[(6)] = c__10976__auto____$2);

return statearr_70509;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
});
})();
var inst_70322 = cljs.core.async.impl.dispatch.run.call(null,inst_70321);
var inst_70323 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_70324 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70325 = ["?auth","?id"];
var inst_70326 = (new cljs.core.PersistentVector(null,2,(5),inst_70324,inst_70325,null));
var inst_70327 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70328 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70329 = [inst_70287,"_tx/auth","?auth"];
var inst_70330 = (new cljs.core.PersistentVector(null,3,(5),inst_70328,inst_70329,null));
var inst_70331 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70332 = ["?auth","_auth/id","?id"];
var inst_70333 = (new cljs.core.PersistentVector(null,3,(5),inst_70331,inst_70332,null));
var inst_70334 = [inst_70330,inst_70333];
var inst_70335 = (new cljs.core.PersistentVector(null,2,(5),inst_70327,inst_70334,null));
var inst_70336 = [inst_70326,inst_70335];
var inst_70337 = cljs.core.PersistentHashMap.fromArrays(inst_70323,inst_70336);
var inst_70338 = fluree.db.api.query.query_async.call(null,inst_70320,inst_70337);
var state_70353__$1 = (function (){var statearr_70510 = state_70353;
(statearr_70510[(17)] = inst_70307);

(statearr_70510[(18)] = inst_70322);

return statearr_70510;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70353__$1,(14),inst_70338);
} else {
if((state_val_70354 === (9))){
var state_70353__$1 = state_70353;
var statearr_70511_70594 = state_70353__$1;
(statearr_70511_70594[(2)] = show_auth);

(statearr_70511_70594[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70354 === (5))){
var inst_70281 = (state_70353[(8)]);
var state_70353__$1 = state_70353;
var statearr_70512_70595 = state_70353__$1;
(statearr_70512_70595[(2)] = inst_70281);

(statearr_70512_70595[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70354 === (14))){
var inst_70298 = (state_70353[(11)]);
var inst_70307 = (state_70353[(17)]);
var inst_70340 = (state_70353[(2)]);
var inst_70341 = fluree.db.util.async.throw_err.call(null,inst_70340);
var inst_70342 = cljs.core.assoc_in.call(null,inst_70298,inst_70307,inst_70341);
var state_70353__$1 = state_70353;
var statearr_70513_70596 = state_70353__$1;
(statearr_70513_70596[(2)] = inst_70342);

(statearr_70513_70596[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70354 === (10))){
var inst_70303 = (state_70353[(2)]);
var state_70353__$1 = state_70353;
if(cljs.core.truth_(inst_70303)){
var statearr_70514_70597 = state_70353__$1;
(statearr_70514_70597[(1)] = (11));

} else {
var statearr_70515_70598 = state_70353__$1;
(statearr_70515_70598[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70354 === (8))){
var inst_70299 = (state_70353[(9)]);
var state_70353__$1 = state_70353;
var statearr_70516_70599 = state_70353__$1;
(statearr_70516_70599[(2)] = inst_70299);

(statearr_70516_70599[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__10903__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__10903__auto____0 = (function (){
var statearr_70517 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70517[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__10903__auto__);

(statearr_70517[(1)] = (1));

return statearr_70517;
});
var fluree$db$api$query$format_history_resp_$_state_machine__10903__auto____1 = (function (state_70353){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_70353);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e70518){var ex__10906__auto__ = e70518;
var statearr_70519_70600 = state_70353;
(statearr_70519_70600[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_70353[(4)]))){
var statearr_70520_70601 = state_70353;
(statearr_70520_70601[(1)] = cljs.core.first.call(null,(state_70353[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70602 = state_70353;
state_70353 = G__70602;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__10903__auto__ = function(state_70353){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__10903__auto____1.call(this,state_70353);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__10903__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__10903__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_70521 = f__10977__auto__.call(null);
(statearr_70521[(6)] = c__10976__auto____$1);

return statearr_70521;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
});
})();
var inst_70357 = cljs.core.async.impl.dispatch.run.call(null,inst_70356);
var state_70453__$1 = (function (){var statearr_70522 = state_70453;
(statearr_70522[(20)] = inst_70357);

return statearr_70522;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70453__$1,(6),inst_70355);
} else {
if((state_val_70454 === (23))){
var inst_70411 = (state_70453[(2)]);
var state_70453__$1 = (function (){var statearr_70523 = state_70453;
(statearr_70523[(13)] = inst_70411);

return statearr_70523;
})();
var statearr_70524_70603 = state_70453__$1;
(statearr_70524_70603[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (35))){
var inst_70441 = (state_70453[(2)]);
var state_70453__$1 = state_70453;
var statearr_70526_70604 = state_70453__$1;
(statearr_70526_70604[(2)] = inst_70441);

(statearr_70526_70604[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (19))){
var state_70453__$1 = state_70453;
var statearr_70527_70605 = state_70453__$1;
(statearr_70527_70605[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (11))){
var inst_70392 = (state_70453[(2)]);
var state_70453__$1 = state_70453;
if(cljs.core.truth_(inst_70392)){
var statearr_70530_70606 = state_70453__$1;
(statearr_70530_70606[(1)] = (15));

} else {
var statearr_70531_70607 = state_70453__$1;
(statearr_70531_70607[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (9))){
var inst_70383 = (state_70453[(16)]);
var inst_70383__$1 = auth;
var state_70453__$1 = (function (){var statearr_70532 = state_70453;
(statearr_70532[(16)] = inst_70383__$1);

return statearr_70532;
})();
if(cljs.core.truth_(inst_70383__$1)){
var statearr_70533_70608 = state_70453__$1;
(statearr_70533_70608[(1)] = (12));

} else {
var statearr_70534_70609 = state_70453__$1;
(statearr_70534_70609[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (5))){
var _ = (function (){var statearr_70535 = state_70453;
(statearr_70535[(4)] = cljs.core.rest.call(null,(state_70453[(4)])));

return statearr_70535;
})();
var state_70453__$1 = state_70453;
var ex70529 = (state_70453__$1[(2)]);
var statearr_70536_70610 = state_70453__$1;
(statearr_70536_70610[(5)] = ex70529);


if((ex70529 instanceof Error)){
var statearr_70537_70611 = state_70453__$1;
(statearr_70537_70611[(1)] = (4));

(statearr_70537_70611[(5)] = null);

} else {
throw ex70529;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (14))){
var inst_70389 = (state_70453[(2)]);
var state_70453__$1 = state_70453;
var statearr_70538_70612 = state_70453__$1;
(statearr_70538_70612[(2)] = inst_70389);

(statearr_70538_70612[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (26))){
var inst_70419 = (state_70453[(2)]);
var state_70453__$1 = (function (){var statearr_70539 = state_70453;
(statearr_70539[(11)] = inst_70419);

return statearr_70539;
})();
var statearr_70540_70613 = state_70453__$1;
(statearr_70540_70613[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (16))){
var inst_70380 = (state_70453[(7)]);
var state_70453__$1 = state_70453;
if(cljs.core.truth_(inst_70380)){
var statearr_70542_70614 = state_70453__$1;
(statearr_70542_70614[(1)] = (18));

} else {
var statearr_70543_70615 = state_70453__$1;
(statearr_70543_70615[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (30))){
var inst_70427 = (state_70453[(15)]);
var inst_70401 = (state_70453[(10)]);
var inst_70402 = (state_70453[(21)]);
var inst_70429 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70430 = [inst_70401,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_70431 = (new cljs.core.PersistentVector(null,2,(5),inst_70429,inst_70430,null));
var inst_70432 = cljs.core.assoc_in.call(null,inst_70427,inst_70431,inst_70402);
var state_70453__$1 = state_70453;
var statearr_70544_70616 = state_70453__$1;
(statearr_70544_70616[(2)] = inst_70432);

(statearr_70544_70616[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (10))){
var inst_70380 = (state_70453[(7)]);
var state_70453__$1 = state_70453;
var statearr_70545_70617 = state_70453__$1;
(statearr_70545_70617[(2)] = inst_70380);

(statearr_70545_70617[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (18))){
var inst_70360 = (state_70453[(18)]);
var inst_70380 = (state_70453[(7)]);
var inst_70398 = (state_70453[(12)]);
var inst_70398__$1 = inst_70380.t;
var inst_70399 = cljs.core.get.call(null,inst_70360,inst_70398__$1);
var inst_70400 = cljs.core.__destructure_map.call(null,inst_70399);
var inst_70401 = cljs.core.get.call(null,inst_70400,new cljs.core.Keyword(null,"block","block",664686210));
var inst_70402 = cljs.core.get.call(null,inst_70400,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_70453__$1 = (function (){var statearr_70546 = state_70453;
(statearr_70546[(10)] = inst_70401);

(statearr_70546[(21)] = inst_70402);

(statearr_70546[(12)] = inst_70398__$1);

return statearr_70546;
})();
var statearr_70547_70618 = state_70453__$1;
(statearr_70547_70618[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (8))){
var inst_70447 = (state_70453[(2)]);
var inst_70448 = cljs.core.vals.call(null,inst_70447);
var _ = (function (){var statearr_70549 = state_70453;
(statearr_70549[(4)] = cljs.core.rest.call(null,(state_70453[(4)])));

return statearr_70549;
})();
var state_70453__$1 = state_70453;
var statearr_70550_70619 = state_70453__$1;
(statearr_70550_70619[(2)] = inst_70448);

(statearr_70550_70619[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__10903__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__10903__auto____0 = (function (){
var statearr_70551 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70551[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__10903__auto__);

(statearr_70551[(1)] = (1));

return statearr_70551;
});
var fluree$db$api$query$format_history_resp_$_state_machine__10903__auto____1 = (function (state_70453){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_70453);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e70552){var ex__10906__auto__ = e70552;
var statearr_70553_70620 = state_70453;
(statearr_70553_70620[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_70453[(4)]))){
var statearr_70554_70621 = state_70453;
(statearr_70554_70621[(1)] = cljs.core.first.call(null,(state_70453[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70622 = state_70453;
state_70453 = G__70622;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__10903__auto__ = function(state_70453){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__10903__auto____1.call(this,state_70453);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__10903__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__10903__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_70555 = f__10977__auto__.call(null);
(statearr_70555[(6)] = c__10976__auto__);

return statearr_70555;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Convert flakes into vectors.
 *   Notes:
 *   Cannot use IPrintWithWriter override since calls to storage-handler
 *   download blocks using the #Flake format to support internal query
 *   handling.
 */
fluree.db.api.query.block_Flakes__GT_vector = (function fluree$db$api$query$block_Flakes__GT_vector(blocks){
return cljs.core.mapv.call(null,(function (block){
return cljs.core.assoc.call(null,block,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.mapv.call(null,cljs.core.vec,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block)));
}),blocks);
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_70749){
var state_val_70750 = (state_70749[(1)]);
if((state_val_70750 === (7))){
var inst_70645 = (state_70749[(7)]);
var inst_70647 = fluree.db.api.query.resolve_block_range.call(null,inst_70645,query_map);
var state_70749__$1 = state_70749;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70749__$1,(10),inst_70647);
} else {
if((state_val_70750 === (20))){
var inst_70674 = (state_70749[(2)]);
var inst_70675 = fluree.db.util.async.throw_err.call(null,inst_70674);
var inst_70676 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_70675);
var inst_70677 = (inst_70676 - (1));
var state_70749__$1 = state_70749;
var statearr_70751_70814 = state_70749__$1;
(statearr_70751_70814[(2)] = inst_70677);

(statearr_70751_70814[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70750 === (27))){
var state_70749__$1 = state_70749;
var statearr_70752_70815 = state_70749__$1;
(statearr_70752_70815[(2)] = null);

(statearr_70752_70815[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70750 === (1))){
var state_70749__$1 = state_70749;
var statearr_70753_70816 = state_70749__$1;
(statearr_70753_70816[(2)] = null);

(statearr_70753_70816[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70750 === (24))){
var inst_70684 = (state_70749[(2)]);
var inst_70685 = fluree.db.util.async.throw_err.call(null,inst_70684);
var inst_70686 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_70685);
var state_70749__$1 = state_70749;
var statearr_70754_70817 = state_70749__$1;
(statearr_70754_70817[(2)] = inst_70686);

(statearr_70754_70817[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70750 === (39))){
var inst_70721 = (state_70749[(2)]);
var inst_70722 = fluree.db.util.async.throw_err.call(null,inst_70721);
var state_70749__$1 = state_70749;
var statearr_70755_70818 = state_70749__$1;
(statearr_70755_70818[(2)] = inst_70722);

(statearr_70755_70818[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70750 === (4))){
var inst_70623 = (state_70749[(2)]);
var state_70749__$1 = state_70749;
var statearr_70756_70819 = state_70749__$1;
(statearr_70756_70819[(2)] = inst_70623);

(statearr_70756_70819[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70750 === (15))){
var inst_70654 = (state_70749[(8)]);
var state_70749__$1 = state_70749;
var statearr_70757_70820 = state_70749__$1;
(statearr_70757_70820[(2)] = inst_70654);

(statearr_70757_70820[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70750 === (21))){
var inst_70655 = (state_70749[(9)]);
var inst_70645 = (state_70749[(7)]);
var inst_70682 = fluree.db.time_travel.as_of_block.call(null,inst_70645,inst_70655);
var state_70749__$1 = state_70749;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70749__$1,(24),inst_70682);
} else {
if((state_val_70750 === (31))){
var inst_70639 = (state_70749[(10)]);
var state_70749__$1 = state_70749;
var statearr_70758_70821 = state_70749__$1;
(statearr_70758_70821[(2)] = inst_70639);

(statearr_70758_70821[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70750 === (32))){
var inst_70705 = (state_70749[(11)]);
var inst_70700 = (state_70749[(12)]);
var inst_70645 = (state_70749[(7)]);
var inst_70709 = (state_70749[(2)]);
var inst_70710 = fluree.db.api.query.format_history_resp.call(null,inst_70645,inst_70700,inst_70705,inst_70709);
var state_70749__$1 = state_70749;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70749__$1,(29),inst_70710);
} else {
if((state_val_70750 === (40))){
var inst_70726 = (state_70749[(13)]);
var inst_70700 = (state_70749[(12)]);
var inst_70728 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_70729 = cljs.core.count.call(null,inst_70700);
var inst_70730 = [inst_70726,inst_70729,(200)];
var inst_70731 = cljs.core.PersistentHashMap.fromArrays(inst_70728,inst_70730);
var state_70749__$1 = state_70749;
var statearr_70759_70822 = state_70749__$1;
(statearr_70759_70822[(2)] = inst_70731);

(statearr_70759_70822[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70750 === (33))){
var inst_70638 = (state_70749[(14)]);
var state_70749__$1 = state_70749;
var statearr_70760_70823 = state_70749__$1;
(statearr_70760_70823[(2)] = inst_70638);

(statearr_70760_70823[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70750 === (13))){
var inst_70744 = (state_70749[(2)]);
var _ = (function (){var statearr_70761 = state_70749;
(statearr_70761[(4)] = cljs.core.rest.call(null,(state_70749[(4)])));

return statearr_70761;
})();
var state_70749__$1 = state_70749;
var statearr_70762_70824 = state_70749__$1;
(statearr_70762_70824[(2)] = inst_70744);

(statearr_70762_70824[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70750 === (22))){
var inst_70645 = (state_70749[(7)]);
var inst_70688 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_70645);
var state_70749__$1 = state_70749;
var statearr_70763_70825 = state_70749__$1;
(statearr_70763_70825[(2)] = inst_70688);

(statearr_70763_70825[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70750 === (36))){
var inst_70713 = (state_70749[(15)]);
var inst_70645 = (state_70749[(7)]);
var inst_70719 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_70645,inst_70713);
var state_70749__$1 = state_70749;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70749__$1,(39),inst_70719);
} else {
if((state_val_70750 === (41))){
var inst_70726 = (state_70749[(13)]);
var state_70749__$1 = state_70749;
var statearr_70764_70826 = state_70749__$1;
(statearr_70764_70826[(2)] = inst_70726);

(statearr_70764_70826[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70750 === (29))){
var inst_70638 = (state_70749[(14)]);
var inst_70712 = (state_70749[(2)]);
var inst_70713 = fluree.db.util.async.throw_err.call(null,inst_70712);
var state_70749__$1 = (function (){var statearr_70765 = state_70749;
(statearr_70765[(15)] = inst_70713);

return statearr_70765;
})();
if(cljs.core.truth_(inst_70638)){
var statearr_70766_70827 = state_70749__$1;
(statearr_70766_70827[(1)] = (33));

} else {
var statearr_70767_70828 = state_70749__$1;
(statearr_70767_70828[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70750 === (6))){
var inst_70635 = (state_70749[(16)]);
var inst_70644 = (state_70749[(2)]);
var inst_70645 = fluree.db.util.async.throw_err.call(null,inst_70644);
var state_70749__$1 = (function (){var statearr_70768 = state_70749;
(statearr_70768[(7)] = inst_70645);

return statearr_70768;
})();
if(cljs.core.truth_(inst_70635)){
var statearr_70769_70829 = state_70749__$1;
(statearr_70769_70829[(1)] = (7));

} else {
var statearr_70770_70830 = state_70749__$1;
(statearr_70770_70830[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70750 === (28))){
var inst_70640 = (state_70749[(17)]);
var inst_70705 = (state_70749[(2)]);
var state_70749__$1 = (function (){var statearr_70771 = state_70749;
(statearr_70771[(11)] = inst_70705);

return statearr_70771;
})();
if(cljs.core.truth_(inst_70640)){
var statearr_70772_70831 = state_70749__$1;
(statearr_70772_70831[(1)] = (30));

} else {
var statearr_70773_70832 = state_70749__$1;
(statearr_70773_70832[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70750 === (25))){
var inst_70641 = (state_70749[(18)]);
var inst_70699 = (state_70749[(2)]);
var inst_70700 = fluree.db.util.async.throw_err.call(null,inst_70699);
var state_70749__$1 = (function (){var statearr_70774 = state_70749;
(statearr_70774[(12)] = inst_70700);

return statearr_70774;
})();
if(cljs.core.truth_(inst_70641)){
var statearr_70775_70833 = state_70749__$1;
(statearr_70775_70833[(1)] = (26));

} else {
var statearr_70776_70834 = state_70749__$1;
(statearr_70776_70834[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70750 === (34))){
var inst_70637 = (state_70749[(19)]);
var state_70749__$1 = state_70749;
var statearr_70777_70835 = state_70749__$1;
(statearr_70777_70835[(2)] = inst_70637);

(statearr_70777_70835[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70750 === (17))){
var inst_70654 = (state_70749[(8)]);
var inst_70645 = (state_70749[(7)]);
var inst_70671 = (inst_70654 - (1));
var inst_70672 = fluree.db.time_travel.as_of_block.call(null,inst_70645,inst_70671);
var state_70749__$1 = state_70749;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70749__$1,(20),inst_70672);
} else {
if((state_val_70750 === (3))){
var inst_70747 = (state_70749[(2)]);
var state_70749__$1 = state_70749;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70749__$1,inst_70747);
} else {
if((state_val_70750 === (12))){
var inst_70736 = cljs.core.pr_str.call(null,query_map);
var inst_70737 = ["History query not properly formatted. Provided ",inst_70736].join('');
var inst_70738 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70739 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70740 = cljs.core.PersistentHashMap.fromArrays(inst_70738,inst_70739);
var inst_70741 = cljs.core.ex_info.call(null,inst_70737,inst_70740);
var inst_70742 = (function(){throw inst_70741})();
var state_70749__$1 = state_70749;
var statearr_70778_70836 = state_70749__$1;
(statearr_70778_70836[(2)] = inst_70742);

(statearr_70778_70836[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70750 === (2))){
var _ = (function (){var statearr_70779 = state_70749;
(statearr_70779[(4)] = cljs.core.cons.call(null,(5),(state_70749[(4)])));

return statearr_70779;
})();
var inst_70633 = query_map;
var inst_70634 = cljs.core.__destructure_map.call(null,inst_70633);
var inst_70635 = cljs.core.get.call(null,inst_70634,new cljs.core.Keyword(null,"block","block",664686210));
var inst_70636 = cljs.core.get.call(null,inst_70634,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_70637 = cljs.core.get.call(null,inst_70634,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_70638 = cljs.core.get.call(null,inst_70634,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_70639 = cljs.core.get.call(null,inst_70634,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_70640 = cljs.core.get.call(null,inst_70634,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_70641 = cljs.core.get.call(null,inst_70634,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_70642 = cljs.core.get.call(null,inst_70634,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_70749__$1 = (function (){var statearr_70780 = state_70749;
(statearr_70780[(20)] = inst_70642);

(statearr_70780[(14)] = inst_70638);

(statearr_70780[(17)] = inst_70640);

(statearr_70780[(21)] = inst_70636);

(statearr_70780[(16)] = inst_70635);

(statearr_70780[(18)] = inst_70641);

(statearr_70780[(19)] = inst_70637);

(statearr_70780[(10)] = inst_70639);

return statearr_70780;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70749__$1,(6),sources);
} else {
if((state_val_70750 === (23))){
var inst_70636 = (state_70749[(21)]);
var inst_70680 = (state_70749[(22)]);
var inst_70645 = (state_70749[(7)]);
var inst_70690 = (state_70749[(2)]);
var inst_70691 = fluree.db.api.query.get_history_pattern.call(null,inst_70636);
var inst_70692 = cljs.core.nth.call(null,inst_70691,(0),null);
var inst_70693 = cljs.core.nth.call(null,inst_70691,(1),null);
var inst_70694 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_70695 = [inst_70680,inst_70690];
var inst_70696 = cljs.core.PersistentHashMap.fromArrays(inst_70694,inst_70695);
var inst_70697 = fluree.db.query.range.time_range.call(null,inst_70645,inst_70693,cljs.core._EQ_,inst_70692,inst_70696);
var state_70749__$1 = state_70749;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70749__$1,(25),inst_70697);
} else {
if((state_val_70750 === (35))){
var inst_70717 = (state_70749[(2)]);
var state_70749__$1 = state_70749;
if(cljs.core.truth_(inst_70717)){
var statearr_70781_70837 = state_70749__$1;
(statearr_70781_70837[(1)] = (36));

} else {
var statearr_70782_70838 = state_70749__$1;
(statearr_70782_70838[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70750 === (19))){
var inst_70655 = (state_70749[(9)]);
var inst_70680 = (state_70749[(2)]);
var state_70749__$1 = (function (){var statearr_70783 = state_70749;
(statearr_70783[(22)] = inst_70680);

return statearr_70783;
})();
if(cljs.core.truth_(inst_70655)){
var statearr_70784_70839 = state_70749__$1;
(statearr_70784_70839[(1)] = (21));

} else {
var statearr_70785_70840 = state_70749__$1;
(statearr_70785_70840[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70750 === (11))){
var inst_70642 = (state_70749[(20)]);
var inst_70654 = (state_70749[(8)]);
var inst_70664 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_70642);
var state_70749__$1 = (function (){var statearr_70787 = state_70749;
(statearr_70787[(23)] = inst_70664);

return statearr_70787;
})();
if(cljs.core.truth_(inst_70654)){
var statearr_70788_70841 = state_70749__$1;
(statearr_70788_70841[(1)] = (14));

} else {
var statearr_70789_70842 = state_70749__$1;
(statearr_70789_70842[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70750 === (9))){
var inst_70653 = (state_70749[(2)]);
var inst_70654 = cljs.core.nth.call(null,inst_70653,(0),null);
var inst_70655 = cljs.core.nth.call(null,inst_70653,(1),null);
var inst_70656 = cljs.core.list(new cljs.core.Keyword(null,"history","history",-247395220));
var inst_70657 = cljs.core.dissoc.call(null,query_map,new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"show-auth","show-auth",686103141),new cljs.core.Keyword(null,"showAuth","showAuth",-347871529),new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_70658 = cljs.core.keys.call(null,inst_70657);
var inst_70659 = cljs.core._EQ_.call(null,inst_70656,inst_70658);
var state_70749__$1 = (function (){var statearr_70790 = state_70749;
(statearr_70790[(8)] = inst_70654);

(statearr_70790[(9)] = inst_70655);

return statearr_70790;
})();
if(inst_70659){
var statearr_70791_70843 = state_70749__$1;
(statearr_70791_70843[(1)] = (11));

} else {
var statearr_70792_70844 = state_70749__$1;
(statearr_70792_70844[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70750 === (5))){
var _ = (function (){var statearr_70793 = state_70749;
(statearr_70793[(4)] = cljs.core.rest.call(null,(state_70749[(4)])));

return statearr_70793;
})();
var state_70749__$1 = state_70749;
var ex70786 = (state_70749__$1[(2)]);
var statearr_70794_70845 = state_70749__$1;
(statearr_70794_70845[(5)] = ex70786);


if((ex70786 instanceof Error)){
var statearr_70795_70846 = state_70749__$1;
(statearr_70795_70846[(1)] = (4));

(statearr_70795_70846[(5)] = null);

} else {
throw ex70786;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70750 === (14))){
var inst_70654 = (state_70749[(8)]);
var inst_70666 = cljs.core.not_EQ_.call(null,(1),inst_70654);
var state_70749__$1 = state_70749;
var statearr_70796_70847 = state_70749__$1;
(statearr_70796_70847[(2)] = inst_70666);

(statearr_70796_70847[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70750 === (26))){
var inst_70641 = (state_70749[(18)]);
var inst_70702 = cljs.core.set.call(null,inst_70641);
var state_70749__$1 = state_70749;
var statearr_70797_70848 = state_70749__$1;
(statearr_70797_70848[(2)] = inst_70702);

(statearr_70797_70848[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70750 === (16))){
var inst_70669 = (state_70749[(2)]);
var state_70749__$1 = state_70749;
if(cljs.core.truth_(inst_70669)){
var statearr_70798_70849 = state_70749__$1;
(statearr_70798_70849[(1)] = (17));

} else {
var statearr_70799_70850 = state_70749__$1;
(statearr_70799_70850[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70750 === (38))){
var inst_70664 = (state_70749[(23)]);
var inst_70726 = (state_70749[(2)]);
var state_70749__$1 = (function (){var statearr_70800 = state_70749;
(statearr_70800[(13)] = inst_70726);

return statearr_70800;
})();
if(cljs.core.truth_(inst_70664)){
var statearr_70801_70851 = state_70749__$1;
(statearr_70801_70851[(1)] = (40));

} else {
var statearr_70802_70852 = state_70749__$1;
(statearr_70802_70852[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70750 === (30))){
var inst_70640 = (state_70749[(17)]);
var state_70749__$1 = state_70749;
var statearr_70803_70853 = state_70749__$1;
(statearr_70803_70853[(2)] = inst_70640);

(statearr_70803_70853[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70750 === (10))){
var inst_70649 = (state_70749[(2)]);
var inst_70650 = fluree.db.util.async.throw_err.call(null,inst_70649);
var state_70749__$1 = state_70749;
var statearr_70804_70854 = state_70749__$1;
(statearr_70804_70854[(2)] = inst_70650);

(statearr_70804_70854[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70750 === (18))){
var state_70749__$1 = state_70749;
var statearr_70805_70855 = state_70749__$1;
(statearr_70805_70855[(2)] = (-1));

(statearr_70805_70855[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70750 === (42))){
var inst_70734 = (state_70749[(2)]);
var state_70749__$1 = state_70749;
var statearr_70806_70856 = state_70749__$1;
(statearr_70806_70856[(2)] = inst_70734);

(statearr_70806_70856[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70750 === (37))){
var inst_70713 = (state_70749[(15)]);
var inst_70724 = fluree.db.api.query.block_Flakes__GT_vector.call(null,inst_70713);
var state_70749__$1 = state_70749;
var statearr_70807_70857 = state_70749__$1;
(statearr_70807_70857[(2)] = inst_70724);

(statearr_70807_70857[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70750 === (8))){
var state_70749__$1 = state_70749;
var statearr_70808_70858 = state_70749__$1;
(statearr_70808_70858[(2)] = null);

(statearr_70808_70858[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__10903__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__10903__auto____0 = (function (){
var statearr_70809 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70809[(0)] = fluree$db$api$query$history_query_async_$_state_machine__10903__auto__);

(statearr_70809[(1)] = (1));

return statearr_70809;
});
var fluree$db$api$query$history_query_async_$_state_machine__10903__auto____1 = (function (state_70749){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_70749);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e70810){var ex__10906__auto__ = e70810;
var statearr_70811_70859 = state_70749;
(statearr_70811_70859[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_70749[(4)]))){
var statearr_70812_70860 = state_70749;
(statearr_70812_70860[(1)] = cljs.core.first.call(null,(state_70749[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70861 = state_70749;
state_70749 = G__70861;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__10903__auto__ = function(state_70749){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__10903__auto____1.call(this,state_70749);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__10903__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__10903__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_70813 = f__10977__auto__.call(null);
(statearr_70813[(6)] = c__10976__auto__);

return statearr_70813;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_70994){
var state_val_70995 = (state_70994[(1)]);
if((state_val_70995 === (7))){
var inst_70891 = cljs.core.pr_str.call(null,flureeQL);
var inst_70892 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_70891].join('');
var inst_70893 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70894 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70895 = cljs.core.PersistentHashMap.fromArrays(inst_70893,inst_70894);
var inst_70896 = cljs.core.ex_info.call(null,inst_70892,inst_70895);
var inst_70897 = (function(){throw inst_70896})();
var state_70994__$1 = state_70994;
var statearr_70996_71075 = state_70994__$1;
(statearr_70996_71075[(2)] = inst_70897);

(statearr_70996_71075[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (20))){
var inst_70929 = (state_70994[(2)]);
var state_70994__$1 = state_70994;
if(cljs.core.truth_(inst_70929)){
var statearr_70997_71076 = state_70994__$1;
(statearr_70997_71076[(1)] = (21));

} else {
var statearr_70998_71077 = state_70994__$1;
(statearr_70998_71077[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (27))){
var inst_70873 = (state_70994[(7)]);
var state_70994__$1 = state_70994;
var statearr_70999_71078 = state_70994__$1;
(statearr_70999_71078[(2)] = inst_70873);

(statearr_70999_71078[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (1))){
var state_70994__$1 = state_70994;
var statearr_71000_71079 = state_70994__$1;
(statearr_71000_71079[(2)] = null);

(statearr_71000_71079[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (24))){
var inst_70935 = (state_70994[(8)]);
var state_70994__$1 = state_70994;
var statearr_71001_71080 = state_70994__$1;
(statearr_71001_71080[(2)] = inst_70935);

(statearr_71001_71080[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (39))){
var inst_70879 = (state_70994[(9)]);
var state_70994__$1 = state_70994;
if(cljs.core.truth_(inst_70879)){
var statearr_71002_71081 = state_70994__$1;
(statearr_71002_71081[(1)] = (42));

} else {
var statearr_71003_71082 = state_70994__$1;
(statearr_71003_71082[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (46))){
var inst_70967 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70968 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70969 = cljs.core.PersistentHashMap.fromArrays(inst_70967,inst_70968);
var inst_70970 = cljs.core.ex_info.call(null,"Invalid query.",inst_70969);
var inst_70971 = (function(){throw inst_70970})();
var state_70994__$1 = state_70994;
var statearr_71004_71083 = state_70994__$1;
(statearr_71004_71083[(2)] = inst_70971);

(statearr_71004_71083[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (4))){
var inst_70863 = (state_70994[(2)]);
var state_70994__$1 = state_70994;
var statearr_71005_71084 = state_70994__$1;
(statearr_71005_71084[(2)] = inst_70863);

(statearr_71005_71084[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (15))){
var inst_70876 = (state_70994[(10)]);
var inst_70914 = (state_70994[(11)]);
var inst_70916 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_70914);
var inst_70917 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_70914);
var inst_70918 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_70914);
var inst_70919 = fluree.db.api.query.get_sources.call(null,inst_70916,inst_70917,inst_70918,inst_70876);
var state_70994__$1 = state_70994;
var statearr_71006_71085 = state_70994__$1;
(statearr_71006_71085[(2)] = inst_70919);

(statearr_71006_71085[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (48))){
var inst_70924 = (state_70994[(12)]);
var inst_70978 = (state_70994[(2)]);
var inst_70979 = fluree.db.util.async.throw_err.call(null,inst_70978);
var state_70994__$1 = (function (){var statearr_71007 = state_70994;
(statearr_71007[(13)] = inst_70979);

return statearr_71007;
})();
if(cljs.core.truth_(inst_70924)){
var statearr_71008_71086 = state_70994__$1;
(statearr_71008_71086[(1)] = (49));

} else {
var statearr_71009_71087 = state_70994__$1;
(statearr_71009_71087[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (50))){
var inst_70979 = (state_70994[(13)]);
var state_70994__$1 = state_70994;
var statearr_71010_71088 = state_70994__$1;
(statearr_71010_71088[(2)] = inst_70979);

(statearr_71010_71088[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (21))){
var inst_70931 = cljs.core.volatile_BANG_.call(null,(0));
var state_70994__$1 = state_70994;
var statearr_71011_71089 = state_70994__$1;
(statearr_71011_71089[(2)] = inst_70931);

(statearr_71011_71089[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (31))){
var inst_70877 = (state_70994[(14)]);
var state_70994__$1 = state_70994;
if(cljs.core.truth_(inst_70877)){
var statearr_71012_71090 = state_70994__$1;
(statearr_71012_71090[(1)] = (33));

} else {
var statearr_71013_71091 = state_70994__$1;
(statearr_71013_71091[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (32))){
var inst_70954 = (state_70994[(2)]);
var state_70994__$1 = state_70994;
var statearr_71014_71092 = state_70994__$1;
(statearr_71014_71092[(2)] = inst_70954);

(statearr_71014_71092[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (40))){
var inst_70956 = (state_70994[(15)]);
var state_70994__$1 = state_70994;
var statearr_71015_71093 = state_70994__$1;
(statearr_71015_71093[(2)] = inst_70956);

(statearr_71015_71093[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (33))){
var inst_70877 = (state_70994[(14)]);
var state_70994__$1 = state_70994;
var statearr_71016_71094 = state_70994__$1;
(statearr_71016_71094[(2)] = inst_70877);

(statearr_71016_71094[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (13))){
var inst_70874 = (state_70994[(16)]);
var inst_70903 = (state_70994[(2)]);
var inst_70904 = fluree.db.util.async.throw_err.call(null,inst_70903);
var inst_70905 = fluree.db.time_travel.as_of_block.call(null,inst_70904,inst_70874);
var state_70994__$1 = state_70994;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70994__$1,(12),inst_70905);
} else {
if((state_val_70995 === (22))){
var state_70994__$1 = state_70994;
var statearr_71017_71095 = state_70994__$1;
(statearr_71017_71095[(2)] = null);

(statearr_71017_71095[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (36))){
var inst_70881 = (state_70994[(17)]);
var state_70994__$1 = state_70994;
var statearr_71018_71096 = state_70994__$1;
(statearr_71018_71096[(2)] = inst_70881);

(statearr_71018_71096[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (41))){
var inst_70964 = (state_70994[(2)]);
var state_70994__$1 = state_70994;
if(cljs.core.truth_(inst_70964)){
var statearr_71019_71097 = state_70994__$1;
(statearr_71019_71097[(1)] = (45));

} else {
var statearr_71020_71098 = state_70994__$1;
(statearr_71020_71098[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (43))){
var inst_70875 = (state_70994[(18)]);
var state_70994__$1 = state_70994;
var statearr_71021_71099 = state_70994__$1;
(statearr_71021_71099[(2)] = inst_70875);

(statearr_71021_71099[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (29))){
var inst_70956 = (state_70994[(15)]);
var inst_70956__$1 = (state_70994[(2)]);
var state_70994__$1 = (function (){var statearr_71022 = state_70994;
(statearr_71022[(15)] = inst_70956__$1);

return statearr_71022;
})();
if(cljs.core.truth_(inst_70956__$1)){
var statearr_71023_71100 = state_70994__$1;
(statearr_71023_71100[(1)] = (39));

} else {
var statearr_71024_71101 = state_70994__$1;
(statearr_71024_71101[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (44))){
var inst_70961 = (state_70994[(2)]);
var state_70994__$1 = state_70994;
var statearr_71025_71102 = state_70994__$1;
(statearr_71025_71102[(2)] = inst_70961);

(statearr_71025_71102[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (6))){
var state_70994__$1 = state_70994;
var statearr_71026_71103 = state_70994__$1;
(statearr_71026_71103[(2)] = null);

(statearr_71026_71103[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (28))){
var inst_70878 = (state_70994[(19)]);
var state_70994__$1 = state_70994;
if(cljs.core.truth_(inst_70878)){
var statearr_71027_71104 = state_70994__$1;
(statearr_71027_71104[(1)] = (30));

} else {
var statearr_71028_71105 = state_70994__$1;
(statearr_71028_71105[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (51))){
var inst_70989 = (state_70994[(2)]);
var _ = (function (){var statearr_71029 = state_70994;
(statearr_71029[(4)] = cljs.core.rest.call(null,(state_70994[(4)])));

return statearr_71029;
})();
var state_70994__$1 = state_70994;
var statearr_71030_71106 = state_70994__$1;
(statearr_71030_71106[(2)] = inst_70989);

(statearr_71030_71106[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (25))){
var state_70994__$1 = state_70994;
var statearr_71031_71107 = state_70994__$1;
(statearr_71031_71107[(2)] = (1000000));

(statearr_71031_71107[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (34))){
var inst_70881 = (state_70994[(17)]);
var state_70994__$1 = state_70994;
if(cljs.core.truth_(inst_70881)){
var statearr_71032_71108 = state_70994__$1;
(statearr_71032_71108[(1)] = (36));

} else {
var statearr_71033_71109 = state_70994__$1;
(statearr_71033_71109[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (17))){
var inst_70925 = (state_70994[(20)]);
var inst_70880 = (state_70994[(21)]);
var inst_70923 = (state_70994[(2)]);
var inst_70924 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_70880);
var inst_70925__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_70880);
var state_70994__$1 = (function (){var statearr_71034 = state_70994;
(statearr_71034[(20)] = inst_70925__$1);

(statearr_71034[(12)] = inst_70924);

(statearr_71034[(22)] = inst_70923);

return statearr_71034;
})();
if(cljs.core.truth_(inst_70925__$1)){
var statearr_71035_71110 = state_70994__$1;
(statearr_71035_71110[(1)] = (18));

} else {
var statearr_71036_71111 = state_70994__$1;
(statearr_71036_71111[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (3))){
var inst_70992 = (state_70994[(2)]);
var state_70994__$1 = state_70994;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70994__$1,inst_70992);
} else {
if((state_val_70995 === (12))){
var inst_70907 = (state_70994[(2)]);
var inst_70908 = fluree.db.util.async.throw_err.call(null,inst_70907);
var state_70994__$1 = state_70994;
var statearr_71037_71112 = state_70994__$1;
(statearr_71037_71112[(2)] = inst_70908);

(statearr_71037_71112[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (2))){
var inst_70874 = (state_70994[(16)]);
var inst_70872 = (state_70994[(23)]);
var inst_70879 = (state_70994[(9)]);
var inst_70877 = (state_70994[(14)]);
var inst_70878 = (state_70994[(19)]);
var inst_70875 = (state_70994[(18)]);
var inst_70873 = (state_70994[(7)]);
var inst_70876 = (state_70994[(10)]);
var inst_70881 = (state_70994[(17)]);
var inst_70880 = (state_70994[(21)]);
var _ = (function (){var statearr_71038 = state_70994;
(statearr_71038[(4)] = cljs.core.cons.call(null,(5),(state_70994[(4)])));

return statearr_71038;
})();
var inst_70870 = flureeQL;
var inst_70871 = cljs.core.__destructure_map.call(null,inst_70870);
var inst_70872__$1 = cljs.core.get.call(null,inst_70871,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_70873__$1 = cljs.core.get.call(null,inst_70871,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_70874__$1 = cljs.core.get.call(null,inst_70871,new cljs.core.Keyword(null,"block","block",664686210));
var inst_70875__$1 = cljs.core.get.call(null,inst_70871,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_70876__$1 = cljs.core.get.call(null,inst_70871,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_70877__$1 = cljs.core.get.call(null,inst_70871,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_70878__$1 = cljs.core.get.call(null,inst_70871,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_70879__$1 = cljs.core.get.call(null,inst_70871,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_70880__$1 = cljs.core.get.call(null,inst_70871,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_70881__$1 = cljs.core.get.call(null,inst_70871,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_70882 = (function (){var map__70869 = inst_70871;
var construct = inst_70872__$1;
var select = inst_70873__$1;
var block = inst_70874__$1;
var where = inst_70875__$1;
var prefixes = inst_70876__$1;
var selectDistinct = inst_70877__$1;
var selectOne = inst_70878__$1;
var from = inst_70879__$1;
var opts = inst_70880__$1;
var selectReduced = inst_70881__$1;
return (function (p1__70862_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__70862_SHARP_);
});
})();
var inst_70883 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70884 = [inst_70873__$1,inst_70878__$1,inst_70877__$1,inst_70881__$1];
var inst_70885 = (new cljs.core.PersistentVector(null,4,(5),inst_70883,inst_70884,null));
var inst_70886 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_70885);
var inst_70887 = cljs.core.count.call(null,inst_70886);
var inst_70888 = inst_70882.call(null,inst_70887);
var state_70994__$1 = (function (){var statearr_71039 = state_70994;
(statearr_71039[(16)] = inst_70874__$1);

(statearr_71039[(23)] = inst_70872__$1);

(statearr_71039[(9)] = inst_70879__$1);

(statearr_71039[(14)] = inst_70877__$1);

(statearr_71039[(19)] = inst_70878__$1);

(statearr_71039[(18)] = inst_70875__$1);

(statearr_71039[(7)] = inst_70873__$1);

(statearr_71039[(10)] = inst_70876__$1);

(statearr_71039[(17)] = inst_70881__$1);

(statearr_71039[(21)] = inst_70880__$1);

return statearr_71039;
})();
if(cljs.core.truth_(inst_70888)){
var statearr_71040_71113 = state_70994__$1;
(statearr_71040_71113[(1)] = (6));

} else {
var statearr_71041_71114 = state_70994__$1;
(statearr_71041_71114[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (23))){
var inst_70935 = (state_70994[(8)]);
var inst_70880 = (state_70994[(21)]);
var inst_70934 = (state_70994[(2)]);
var inst_70935__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_70880);
var state_70994__$1 = (function (){var statearr_71042 = state_70994;
(statearr_71042[(24)] = inst_70934);

(statearr_71042[(8)] = inst_70935__$1);

return statearr_71042;
})();
if(cljs.core.truth_(inst_70935__$1)){
var statearr_71043_71115 = state_70994__$1;
(statearr_71043_71115[(1)] = (24));

} else {
var statearr_71044_71116 = state_70994__$1;
(statearr_71044_71116[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (47))){
var inst_70940 = (state_70994[(25)]);
var inst_70914 = (state_70994[(11)]);
var inst_70973 = (state_70994[(2)]);
var inst_70974 = fluree.db.util.core.current_time_millis.call(null);
var inst_70975 = cljs.core.assoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_70940);
var inst_70976 = fluree.db.query.fql.query.call(null,inst_70914,inst_70975);
var state_70994__$1 = (function (){var statearr_71045 = state_70994;
(statearr_71045[(26)] = inst_70974);

(statearr_71045[(27)] = inst_70973);

return statearr_71045;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70994__$1,(48),inst_70976);
} else {
if((state_val_70995 === (35))){
var inst_70952 = (state_70994[(2)]);
var state_70994__$1 = state_70994;
var statearr_71046_71117 = state_70994__$1;
(statearr_71046_71117[(2)] = inst_70952);

(statearr_71046_71117[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (19))){
var inst_70924 = (state_70994[(12)]);
var state_70994__$1 = state_70994;
var statearr_71047_71118 = state_70994__$1;
(statearr_71047_71118[(2)] = inst_70924);

(statearr_71047_71118[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (11))){
var inst_70876 = (state_70994[(10)]);
var inst_70914 = (state_70994[(2)]);
var state_70994__$1 = (function (){var statearr_71049 = state_70994;
(statearr_71049[(11)] = inst_70914);

return statearr_71049;
})();
if(cljs.core.truth_(inst_70876)){
var statearr_71050_71119 = state_70994__$1;
(statearr_71050_71119[(1)] = (15));

} else {
var statearr_71051_71120 = state_70994__$1;
(statearr_71051_71120[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (9))){
var inst_70900 = (state_70994[(28)]);
var state_70994__$1 = state_70994;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70994__$1,(13),inst_70900);
} else {
if((state_val_70995 === (5))){
var _ = (function (){var statearr_71052 = state_70994;
(statearr_71052[(4)] = cljs.core.rest.call(null,(state_70994[(4)])));

return statearr_71052;
})();
var state_70994__$1 = state_70994;
var ex71048 = (state_70994__$1[(2)]);
var statearr_71053_71121 = state_70994__$1;
(statearr_71053_71121[(5)] = ex71048);


if((ex71048 instanceof Error)){
var statearr_71054_71122 = state_70994__$1;
(statearr_71054_71122[(1)] = (4));

(statearr_71054_71122[(5)] = null);

} else {
throw ex71048;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (14))){
var inst_70911 = (state_70994[(2)]);
var inst_70912 = fluree.db.util.async.throw_err.call(null,inst_70911);
var state_70994__$1 = state_70994;
var statearr_71055_71123 = state_70994__$1;
(statearr_71055_71123[(2)] = inst_70912);

(statearr_71055_71123[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (45))){
var state_70994__$1 = state_70994;
var statearr_71056_71124 = state_70994__$1;
(statearr_71056_71124[(2)] = null);

(statearr_71056_71124[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (26))){
var inst_70934 = (state_70994[(24)]);
var inst_70873 = (state_70994[(7)]);
var inst_70880 = (state_70994[(21)]);
var inst_70923 = (state_70994[(22)]);
var inst_70939 = (state_70994[(2)]);
var inst_70940 = cljs.core.assoc.call(null,inst_70880,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_70923,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_70939,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_70934);
var state_70994__$1 = (function (){var statearr_71057 = state_70994;
(statearr_71057[(25)] = inst_70940);

return statearr_71057;
})();
if(cljs.core.truth_(inst_70873)){
var statearr_71058_71125 = state_70994__$1;
(statearr_71058_71125[(1)] = (27));

} else {
var statearr_71059_71126 = state_70994__$1;
(statearr_71059_71126[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (16))){
var inst_70921 = cljs.core.PersistentHashMap.EMPTY;
var state_70994__$1 = state_70994;
var statearr_71060_71127 = state_70994__$1;
(statearr_71060_71127[(2)] = inst_70921);

(statearr_71060_71127[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (38))){
var inst_70950 = (state_70994[(2)]);
var state_70994__$1 = state_70994;
var statearr_71061_71128 = state_70994__$1;
(statearr_71061_71128[(2)] = inst_70950);

(statearr_71061_71128[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (30))){
var inst_70878 = (state_70994[(19)]);
var state_70994__$1 = state_70994;
var statearr_71062_71129 = state_70994__$1;
(statearr_71062_71129[(2)] = inst_70878);

(statearr_71062_71129[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (10))){
var inst_70900 = (state_70994[(28)]);
var state_70994__$1 = state_70994;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70994__$1,(14),inst_70900);
} else {
if((state_val_70995 === (18))){
var inst_70925 = (state_70994[(20)]);
var state_70994__$1 = state_70994;
var statearr_71063_71130 = state_70994__$1;
(statearr_71063_71130[(2)] = inst_70925);

(statearr_71063_71130[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (42))){
var inst_70879 = (state_70994[(9)]);
var state_70994__$1 = state_70994;
var statearr_71064_71131 = state_70994__$1;
(statearr_71064_71131[(2)] = inst_70879);

(statearr_71064_71131[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (37))){
var inst_70872 = (state_70994[(23)]);
var state_70994__$1 = state_70994;
var statearr_71065_71132 = state_70994__$1;
(statearr_71065_71132[(2)] = inst_70872);

(statearr_71065_71132[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (8))){
var inst_70874 = (state_70994[(16)]);
var inst_70899 = (state_70994[(2)]);
var inst_70900 = sources;
var state_70994__$1 = (function (){var statearr_71066 = state_70994;
(statearr_71066[(28)] = inst_70900);

(statearr_71066[(29)] = inst_70899);

return statearr_71066;
})();
if(cljs.core.truth_(inst_70874)){
var statearr_71067_71133 = state_70994__$1;
(statearr_71067_71133[(1)] = (9));

} else {
var statearr_71068_71134 = state_70994__$1;
(statearr_71068_71134[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70995 === (49))){
var inst_70979 = (state_70994[(13)]);
var inst_70934 = (state_70994[(24)]);
var inst_70974 = (state_70994[(26)]);
var inst_70914 = (state_70994[(11)]);
var inst_70981 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_70982 = cljs.core.deref.call(null,inst_70934);
var inst_70983 = fluree.db.util.core.response_time_formatted.call(null,inst_70974);
var inst_70984 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_70914);
var inst_70985 = [(200),inst_70979,inst_70982,inst_70983,inst_70984];
var inst_70986 = cljs.core.PersistentHashMap.fromArrays(inst_70981,inst_70985);
var state_70994__$1 = state_70994;
var statearr_71069_71135 = state_70994__$1;
(statearr_71069_71135[(2)] = inst_70986);

(statearr_71069_71135[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__10903__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__10903__auto____0 = (function (){
var statearr_71070 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71070[(0)] = fluree$db$api$query$query_async_$_state_machine__10903__auto__);

(statearr_71070[(1)] = (1));

return statearr_71070;
});
var fluree$db$api$query$query_async_$_state_machine__10903__auto____1 = (function (state_70994){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_70994);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e71071){var ex__10906__auto__ = e71071;
var statearr_71072_71136 = state_70994;
(statearr_71072_71136[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_70994[(4)]))){
var statearr_71073_71137 = state_70994;
(statearr_71073_71137[(1)] = cljs.core.first.call(null,(state_70994[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71138 = state_70994;
state_70994 = G__71138;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__10903__auto__ = function(state_70994){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__10903__auto____1.call(this,state_70994);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__10903__auto____0;
fluree$db$api$query$query_async_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__10903__auto____1;
return fluree$db$api$query$query_async_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_71074 = f__10977__auto__.call(null);
(statearr_71074[(6)] = c__10976__auto__);

return statearr_71074;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_71279){
var state_val_71280 = (state_71279[(1)]);
if((state_val_71280 === (7))){
var inst_71274 = (state_71279[(2)]);
var _ = (function (){var statearr_71281 = state_71279;
(statearr_71281[(4)] = cljs.core.rest.call(null,(state_71279[(4)])));

return statearr_71281;
})();
var state_71279__$1 = state_71279;
var statearr_71282_71358 = state_71279__$1;
(statearr_71282_71358[(2)] = inst_71274);

(statearr_71282_71358[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (20))){
var inst_71246 = (state_71279[(2)]);
var state_71279__$1 = state_71279;
var statearr_71283_71359 = state_71279__$1;
(statearr_71283_71359[(2)] = inst_71246);

(statearr_71283_71359[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (27))){
var inst_71226 = (state_71279[(7)]);
var state_71279__$1 = state_71279;
var statearr_71284_71360 = state_71279__$1;
(statearr_71284_71360[(2)] = inst_71226);

(statearr_71284_71360[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (1))){
var state_71279__$1 = state_71279;
var statearr_71285_71361 = state_71279__$1;
(statearr_71285_71361[(2)] = null);

(statearr_71285_71361[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (24))){
var inst_71223 = (state_71279[(8)]);
var state_71279__$1 = state_71279;
var statearr_71286_71362 = state_71279__$1;
(statearr_71286_71362[(2)] = inst_71223);

(statearr_71286_71362[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (39))){
var inst_71191 = (state_71279[(9)]);
var inst_71213 = (state_71279[(10)]);
var inst_71180 = (state_71279[(11)]);
var inst_71257 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71258 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_71191];
var inst_71259 = (new cljs.core.PersistentVector(null,2,(5),inst_71257,inst_71258,null));
var inst_71260 = cljs.core.assoc_in.call(null,inst_71180,inst_71259,inst_71213);
var state_71279__$1 = state_71279;
var statearr_71287_71363 = state_71279__$1;
(statearr_71287_71363[(2)] = inst_71260);

(statearr_71287_71363[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (4))){
var inst_71139 = (state_71279[(2)]);
var state_71279__$1 = state_71279;
var statearr_71288_71364 = state_71279__$1;
(statearr_71288_71364[(2)] = inst_71139);

(statearr_71288_71364[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (15))){
var inst_71178 = (state_71279[(12)]);
var inst_71213 = (state_71279[(10)]);
var inst_71216 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_71213);
var inst_71217 = (inst_71178 == null);
var state_71279__$1 = (function (){var statearr_71289 = state_71279;
(statearr_71289[(13)] = inst_71216);

return statearr_71289;
})();
if(cljs.core.truth_(inst_71217)){
var statearr_71290_71365 = state_71279__$1;
(statearr_71290_71365[(1)] = (18));

} else {
var statearr_71291_71366 = state_71279__$1;
(statearr_71291_71366[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (21))){
var inst_71216 = (state_71279[(13)]);
var state_71279__$1 = state_71279;
var statearr_71292_71367 = state_71279__$1;
(statearr_71292_71367[(2)] = inst_71216);

(statearr_71292_71367[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (31))){
var state_71279__$1 = state_71279;
var statearr_71293_71368 = state_71279__$1;
(statearr_71293_71368[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (32))){
var inst_71242 = (state_71279[(2)]);
var state_71279__$1 = state_71279;
var statearr_71295_71369 = state_71279__$1;
(statearr_71295_71369[(2)] = inst_71242);

(statearr_71295_71369[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (40))){
var inst_71211 = (state_71279[(14)]);
var state_71279__$1 = state_71279;
if(cljs.core.truth_(inst_71211)){
var statearr_71296_71370 = state_71279__$1;
(statearr_71296_71370[(1)] = (42));

} else {
var statearr_71297_71371 = state_71279__$1;
(statearr_71297_71371[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (33))){
var inst_71178 = (state_71279[(12)]);
var inst_71216 = (state_71279[(13)]);
var inst_71237 = ((inst_71216 > inst_71178) ? inst_71216 : inst_71178);
var state_71279__$1 = state_71279;
var statearr_71298_71372 = state_71279__$1;
(statearr_71298_71372[(2)] = inst_71237);

(statearr_71298_71372[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (13))){
var inst_71202 = (state_71279[(2)]);
var state_71279__$1 = state_71279;
var statearr_71299_71373 = state_71279__$1;
(statearr_71299_71373[(2)] = inst_71202);

(statearr_71299_71373[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (22))){
var inst_71223 = (state_71279[(8)]);
var inst_71216 = (state_71279[(13)]);
var inst_71223__$1 = cljs.core._EQ_.call(null,(200),inst_71216);
var state_71279__$1 = (function (){var statearr_71300 = state_71279;
(statearr_71300[(8)] = inst_71223__$1);

return statearr_71300;
})();
if(inst_71223__$1){
var statearr_71301_71374 = state_71279__$1;
(statearr_71301_71374[(1)] = (24));

} else {
var statearr_71302_71375 = state_71279__$1;
(statearr_71302_71375[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (36))){
var inst_71213 = (state_71279[(10)]);
var inst_71179 = (state_71279[(15)]);
var inst_71251 = cljs.core.get.call(null,inst_71213,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_71252 = (inst_71179 + inst_71251);
var state_71279__$1 = state_71279;
var statearr_71303_71376 = state_71279__$1;
(statearr_71303_71376[(2)] = inst_71252);

(statearr_71303_71376[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (41))){
var inst_71255 = (state_71279[(16)]);
var inst_71249 = (state_71279[(17)]);
var inst_71190 = (state_71279[(18)]);
var inst_71269 = (state_71279[(2)]);
var inst_71177 = inst_71190;
var inst_71178 = inst_71249;
var inst_71179 = inst_71255;
var inst_71180 = inst_71269;
var state_71279__$1 = (function (){var statearr_71304 = state_71279;
(statearr_71304[(12)] = inst_71178);

(statearr_71304[(11)] = inst_71180);

(statearr_71304[(19)] = inst_71177);

(statearr_71304[(15)] = inst_71179);

return statearr_71304;
})();
var statearr_71305_71377 = state_71279__$1;
(statearr_71305_71377[(2)] = null);

(statearr_71305_71377[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (43))){
var inst_71213 = (state_71279[(10)]);
var state_71279__$1 = state_71279;
var statearr_71306_71378 = state_71279__$1;
(statearr_71306_71378[(2)] = inst_71213);

(statearr_71306_71378[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (29))){
var inst_71231 = (state_71279[(2)]);
var state_71279__$1 = state_71279;
var statearr_71307_71379 = state_71279__$1;
(statearr_71307_71379[(2)] = inst_71231);

(statearr_71307_71379[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (44))){
var inst_71191 = (state_71279[(9)]);
var inst_71180 = (state_71279[(11)]);
var inst_71266 = (state_71279[(2)]);
var inst_71267 = cljs.core.assoc.call(null,inst_71180,inst_71191,inst_71266);
var state_71279__$1 = state_71279;
var statearr_71308_71380 = state_71279__$1;
(statearr_71308_71380[(2)] = inst_71267);

(statearr_71308_71380[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (6))){
var inst_71192 = (state_71279[(20)]);
var inst_71177 = (state_71279[(19)]);
var inst_71188 = cljs.core.seq.call(null,inst_71177);
var inst_71189 = cljs.core.first.call(null,inst_71188);
var inst_71190 = cljs.core.next.call(null,inst_71188);
var inst_71191 = cljs.core.nth.call(null,inst_71189,(0),null);
var inst_71192__$1 = cljs.core.nth.call(null,inst_71189,(1),null);
var inst_71193 = (inst_71192__$1 == null);
var state_71279__$1 = (function (){var statearr_71309 = state_71279;
(statearr_71309[(9)] = inst_71191);

(statearr_71309[(20)] = inst_71192__$1);

(statearr_71309[(18)] = inst_71190);

return statearr_71309;
})();
if(cljs.core.truth_(inst_71193)){
var statearr_71310_71381 = state_71279__$1;
(statearr_71310_71381[(1)] = (8));

} else {
var statearr_71311_71382 = state_71279__$1;
(statearr_71311_71382[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (28))){
var inst_71178 = (state_71279[(12)]);
var inst_71229 = cljs.core._EQ_.call(null,(207),inst_71178);
var state_71279__$1 = state_71279;
var statearr_71312_71383 = state_71279__$1;
(statearr_71312_71383[(2)] = inst_71229);

(statearr_71312_71383[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (25))){
var inst_71178 = (state_71279[(12)]);
var inst_71226 = (state_71279[(7)]);
var inst_71226__$1 = cljs.core._EQ_.call(null,(200),inst_71178);
var state_71279__$1 = (function (){var statearr_71313 = state_71279;
(statearr_71313[(7)] = inst_71226__$1);

return statearr_71313;
})();
if(inst_71226__$1){
var statearr_71314_71384 = state_71279__$1;
(statearr_71314_71384[(1)] = (27));

} else {
var statearr_71315_71385 = state_71279__$1;
(statearr_71315_71385[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (34))){
var state_71279__$1 = state_71279;
var statearr_71316_71386 = state_71279__$1;
(statearr_71316_71386[(2)] = null);

(statearr_71316_71386[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (17))){
var inst_71210 = (state_71279[(21)]);
var inst_71249 = (state_71279[(2)]);
var state_71279__$1 = (function (){var statearr_71317 = state_71279;
(statearr_71317[(17)] = inst_71249);

return statearr_71317;
})();
if(cljs.core.truth_(inst_71210)){
var statearr_71318_71387 = state_71279__$1;
(statearr_71318_71387[(1)] = (36));

} else {
var statearr_71319_71388 = state_71279__$1;
(statearr_71319_71388[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (3))){
var inst_71277 = (state_71279[(2)]);
var state_71279__$1 = state_71279;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71279__$1,inst_71277);
} else {
if((state_val_71280 === (12))){
var inst_71180 = (state_71279[(11)]);
var state_71279__$1 = state_71279;
var statearr_71320_71389 = state_71279__$1;
(statearr_71320_71389[(2)] = inst_71180);

(statearr_71320_71389[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (2))){
var inst_71153 = (state_71279[(22)]);
var inst_71149 = (state_71279[(23)]);
var inst_71154 = (state_71279[(24)]);
var _ = (function (){var statearr_71321 = state_71279;
(statearr_71321[(4)] = cljs.core.cons.call(null,(5),(state_71279[(4)])));

return statearr_71321;
})();
var inst_71145 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_71146 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71147 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_71148 = (new cljs.core.PersistentVector(null,2,(5),inst_71146,inst_71147,null));
var inst_71149__$1 = cljs.core.get_in.call(null,flureeQL,inst_71148);
var inst_71150 = (function (){var global_block = inst_71145;
var global_meta_QMARK_ = inst_71149__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.call(null,query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__4253__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__4251__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not.call(null,query_meta_QMARK_);
} else {
return and__4251__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.call(null,new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_);
var query_STAR_ = cljs.core.assoc.call(null,query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return global_block;
}
})());
return cljs.core.assoc.call(null,acc,alias,query_STAR_);
});
})();
var inst_71151 = cljs.core.PersistentHashMap.EMPTY;
var inst_71152 = cljs.core.dissoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"block","block",664686210));
var inst_71153__$1 = cljs.core.reduce_kv.call(null,inst_71150,inst_71151,inst_71152);
var inst_71154__$1 = fluree.db.util.core.current_time_millis.call(null);
var inst_71156 = (function (){var global_block = inst_71145;
var global_meta_QMARK_ = inst_71149__$1;
var queries = inst_71153__$1;
var start_time = inst_71154__$1;
return (function (p__71155){
var vec__71322 = p__71155;
var alias = cljs.core.nth.call(null,vec__71322,(0),null);
var q = cljs.core.nth.call(null,vec__71322,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,fluree.db.api.query.query.call(null,source,q)], null);
});
})();
var inst_71157 = cljs.core.map.call(null,inst_71156,inst_71153__$1);
var inst_71171 = cljs.core.seq.call(null,inst_71157);
var inst_71172 = cljs.core.first.call(null,inst_71171);
var inst_71173 = cljs.core.next.call(null,inst_71171);
var inst_71174 = cljs.core.nth.call(null,inst_71172,(0),null);
var inst_71175 = cljs.core.nth.call(null,inst_71172,(1),null);
var inst_71176 = cljs.core.PersistentHashMap.EMPTY;
var inst_71177 = inst_71157;
var inst_71178 = null;
var inst_71179 = (0);
var inst_71180 = inst_71176;
var state_71279__$1 = (function (){var statearr_71325 = state_71279;
(statearr_71325[(12)] = inst_71178);

(statearr_71325[(25)] = inst_71174);

(statearr_71325[(22)] = inst_71153__$1);

(statearr_71325[(26)] = inst_71175);

(statearr_71325[(11)] = inst_71180);

(statearr_71325[(19)] = inst_71177);

(statearr_71325[(15)] = inst_71179);

(statearr_71325[(23)] = inst_71149__$1);

(statearr_71325[(27)] = inst_71173);

(statearr_71325[(24)] = inst_71154__$1);

return statearr_71325;
})();
var statearr_71326_71390 = state_71279__$1;
(statearr_71326_71390[(2)] = null);

(statearr_71326_71390[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (23))){
var inst_71244 = (state_71279[(2)]);
var state_71279__$1 = state_71279;
var statearr_71327_71391 = state_71279__$1;
(statearr_71327_71391[(2)] = inst_71244);

(statearr_71327_71391[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (35))){
var inst_71240 = (state_71279[(2)]);
var state_71279__$1 = state_71279;
var statearr_71328_71392 = state_71279__$1;
(statearr_71328_71392[(2)] = inst_71240);

(statearr_71328_71392[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (19))){
var inst_71178 = (state_71279[(12)]);
var inst_71216 = (state_71279[(13)]);
var inst_71220 = cljs.core._EQ_.call(null,inst_71178,inst_71216);
var state_71279__$1 = state_71279;
if(inst_71220){
var statearr_71329_71393 = state_71279__$1;
(statearr_71329_71393[(1)] = (21));

} else {
var statearr_71330_71394 = state_71279__$1;
(statearr_71330_71394[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (11))){
var inst_71178 = (state_71279[(12)]);
var inst_71180 = (state_71279[(11)]);
var inst_71179 = (state_71279[(15)]);
var inst_71154 = (state_71279[(24)]);
var inst_71196 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_71197 = fluree.db.util.core.response_time_formatted.call(null,inst_71154);
var inst_71198 = [inst_71180,inst_71179,inst_71178,inst_71197];
var inst_71199 = cljs.core.PersistentHashMap.fromArrays(inst_71196,inst_71198);
var state_71279__$1 = state_71279;
var statearr_71332_71395 = state_71279__$1;
(statearr_71332_71395[(2)] = inst_71199);

(statearr_71332_71395[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (9))){
var inst_71191 = (state_71279[(9)]);
var inst_71153 = (state_71279[(22)]);
var inst_71192 = (state_71279[(20)]);
var inst_71205 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71206 = [inst_71191,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_71207 = (new cljs.core.PersistentVector(null,2,(5),inst_71205,inst_71206,null));
var inst_71208 = cljs.core.get_in.call(null,inst_71153,inst_71207);
var inst_71209 = cljs.core.__destructure_map.call(null,inst_71208);
var inst_71210 = cljs.core.get.call(null,inst_71209,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_71211 = cljs.core.get.call(null,inst_71209,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_71279__$1 = (function (){var statearr_71333 = state_71279;
(statearr_71333[(21)] = inst_71210);

(statearr_71333[(14)] = inst_71211);

return statearr_71333;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71279__$1,(14),inst_71192);
} else {
if((state_val_71280 === (5))){
var _ = (function (){var statearr_71334 = state_71279;
(statearr_71334[(4)] = cljs.core.rest.call(null,(state_71279[(4)])));

return statearr_71334;
})();
var state_71279__$1 = state_71279;
var ex71331 = (state_71279__$1[(2)]);
var statearr_71335_71396 = state_71279__$1;
(statearr_71335_71396[(5)] = ex71331);


var statearr_71336_71397 = state_71279__$1;
(statearr_71336_71397[(1)] = (4));

(statearr_71336_71397[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (14))){
var inst_71213 = (state_71279[(10)]);
var inst_71210 = (state_71279[(21)]);
var inst_71213__$1 = (state_71279[(2)]);
var inst_71214 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_71213__$1);
var state_71279__$1 = (function (){var statearr_71337 = state_71279;
(statearr_71337[(10)] = inst_71213__$1);

(statearr_71337[(28)] = inst_71214);

return statearr_71337;
})();
if(cljs.core.truth_(inst_71210)){
var statearr_71338_71398 = state_71279__$1;
(statearr_71338_71398[(1)] = (15));

} else {
var statearr_71339_71399 = state_71279__$1;
(statearr_71339_71399[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (26))){
var inst_71233 = (state_71279[(2)]);
var state_71279__$1 = state_71279;
if(cljs.core.truth_(inst_71233)){
var statearr_71340_71400 = state_71279__$1;
(statearr_71340_71400[(1)] = (30));

} else {
var statearr_71341_71401 = state_71279__$1;
(statearr_71341_71401[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (16))){
var state_71279__$1 = state_71279;
var statearr_71342_71402 = state_71279__$1;
(statearr_71342_71402[(2)] = null);

(statearr_71342_71402[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (38))){
var inst_71214 = (state_71279[(28)]);
var inst_71255 = (state_71279[(2)]);
var state_71279__$1 = (function (){var statearr_71343 = state_71279;
(statearr_71343[(16)] = inst_71255);

return statearr_71343;
})();
if(cljs.core.truth_(inst_71214)){
var statearr_71344_71403 = state_71279__$1;
(statearr_71344_71403[(1)] = (39));

} else {
var statearr_71345_71404 = state_71279__$1;
(statearr_71345_71404[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (30))){
var state_71279__$1 = state_71279;
var statearr_71346_71405 = state_71279__$1;
(statearr_71346_71405[(2)] = (207));

(statearr_71346_71405[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (10))){
var inst_71272 = (state_71279[(2)]);
var state_71279__$1 = state_71279;
var statearr_71347_71406 = state_71279__$1;
(statearr_71347_71406[(2)] = inst_71272);

(statearr_71347_71406[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (18))){
var inst_71216 = (state_71279[(13)]);
var state_71279__$1 = state_71279;
var statearr_71348_71407 = state_71279__$1;
(statearr_71348_71407[(2)] = inst_71216);

(statearr_71348_71407[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (42))){
var inst_71213 = (state_71279[(10)]);
var inst_71263 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_71213);
var state_71279__$1 = state_71279;
var statearr_71349_71408 = state_71279__$1;
(statearr_71349_71408[(2)] = inst_71263);

(statearr_71349_71408[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (37))){
var state_71279__$1 = state_71279;
var statearr_71350_71409 = state_71279__$1;
(statearr_71350_71409[(2)] = null);

(statearr_71350_71409[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71280 === (8))){
var inst_71149 = (state_71279[(23)]);
var state_71279__$1 = state_71279;
if(cljs.core.truth_(inst_71149)){
var statearr_71351_71410 = state_71279__$1;
(statearr_71351_71410[(1)] = (11));

} else {
var statearr_71352_71411 = state_71279__$1;
(statearr_71352_71411[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__10903__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__10903__auto____0 = (function (){
var statearr_71353 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71353[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__10903__auto__);

(statearr_71353[(1)] = (1));

return statearr_71353;
});
var fluree$db$api$query$multi_query_async_$_state_machine__10903__auto____1 = (function (state_71279){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_71279);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e71354){var ex__10906__auto__ = e71354;
var statearr_71355_71412 = state_71279;
(statearr_71355_71412[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_71279[(4)]))){
var statearr_71356_71413 = state_71279;
(statearr_71356_71413[(1)] = cljs.core.first.call(null,(state_71279[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71414 = state_71279;
state_71279 = G__71414;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__10903__auto__ = function(state_71279){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__10903__auto____1.call(this,state_71279);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__10903__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__10903__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_71357 = f__10977__auto__.call(null);
(statearr_71357[(6)] = c__10976__auto__);

return statearr_71357;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type.call(null,flureeQL);
var G__71415 = query_type;
var G__71415__$1 = (((G__71415 instanceof cljs.core.Keyword))?G__71415.fqn:null);
switch (G__71415__$1) {
case "standard":
return fluree.db.api.query.query_async.call(null,source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async.call(null,source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.call(null,new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async.call(null,conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async.call(null,source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__71415__$1)].join('')));

}
});
