// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__79623 = arguments.length;
switch (G__79623) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db.call(null,conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5751__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5751__auto__)){
var block = temp__5751__auto__;
var pc = cljs.core.async.promise_chan.call(null);
var c__10976__auto___79662 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_79644){
var state_val_79645 = (state_79644[(1)]);
if((state_val_79645 === (1))){
var state_79644__$1 = state_79644;
var statearr_79646_79663 = state_79644__$1;
(statearr_79646_79663[(2)] = null);

(statearr_79646_79663[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79645 === (2))){
var _ = (function (){var statearr_79647 = state_79644;
(statearr_79647[(4)] = cljs.core.cons.call(null,(5),(state_79644[(4)])));

return statearr_79647;
})();
var inst_79630 = fluree.db.session.db.call(null,conn,ledger,null);
var state_79644__$1 = state_79644;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_79644__$1,(7),inst_79630);
} else {
if((state_val_79645 === (3))){
var inst_79640 = (state_79644[(2)]);
var inst_79641 = cljs.core.async.put_BANG_.call(null,pc,inst_79640);
var inst_79642 = cljs.core.async.close_BANG_.call(null,pc);
var state_79644__$1 = (function (){var statearr_79649 = state_79644;
(statearr_79649[(7)] = inst_79641);

return statearr_79649;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79644__$1,inst_79642);
} else {
if((state_val_79645 === (4))){
var inst_79624 = (state_79644[(2)]);
var state_79644__$1 = state_79644;
var statearr_79650_79664 = state_79644__$1;
(statearr_79650_79664[(2)] = inst_79624);

(statearr_79650_79664[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79645 === (5))){
var _ = (function (){var statearr_79651 = state_79644;
(statearr_79651[(4)] = cljs.core.rest.call(null,(state_79644[(4)])));

return statearr_79651;
})();
var state_79644__$1 = state_79644;
var ex79648 = (state_79644__$1[(2)]);
var statearr_79652_79665 = state_79644__$1;
(statearr_79652_79665[(5)] = ex79648);


var statearr_79653_79666 = state_79644__$1;
(statearr_79653_79666[(1)] = (4));

(statearr_79653_79666[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79645 === (6))){
var inst_79636 = (state_79644[(2)]);
var inst_79637 = fluree.db.util.async.throw_err.call(null,inst_79636);
var _ = (function (){var statearr_79654 = state_79644;
(statearr_79654[(4)] = cljs.core.rest.call(null,(state_79644[(4)])));

return statearr_79654;
})();
var state_79644__$1 = state_79644;
var statearr_79655_79667 = state_79644__$1;
(statearr_79655_79667[(2)] = inst_79637);

(statearr_79655_79667[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79645 === (7))){
var inst_79632 = (state_79644[(2)]);
var inst_79633 = fluree.db.util.async.throw_err.call(null,inst_79632);
var inst_79634 = fluree.db.time_travel.as_of_block.call(null,inst_79633,block);
var state_79644__$1 = state_79644;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_79644__$1,(6),inst_79634);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__10903__auto__ = null;
var fluree$db$api$ledger$state_machine__10903__auto____0 = (function (){
var statearr_79656 = [null,null,null,null,null,null,null,null];
(statearr_79656[(0)] = fluree$db$api$ledger$state_machine__10903__auto__);

(statearr_79656[(1)] = (1));

return statearr_79656;
});
var fluree$db$api$ledger$state_machine__10903__auto____1 = (function (state_79644){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_79644);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e79657){var ex__10906__auto__ = e79657;
var statearr_79658_79668 = state_79644;
(statearr_79658_79668[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_79644[(4)]))){
var statearr_79659_79669 = state_79644;
(statearr_79659_79669[(1)] = cljs.core.first.call(null,(state_79644[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79670 = state_79644;
state_79644 = G__79670;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__10903__auto__ = function(state_79644){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__10903__auto____1.call(this,state_79644);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__10903__auto____0;
fluree$db$api$ledger$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__10903__auto____1;
return fluree$db$api$ledger$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_79660 = f__10977__auto__.call(null);
(statearr_79660[(6)] = c__10976__auto___79662);

return statearr_79660;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));


return pc;
} else {
return fluree.db.session.db.call(null,conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t.call(null,db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_79711){
var state_val_79712 = (state_79711[(1)]);
if((state_val_79712 === (7))){
var inst_79680 = cljs.core._EQ_.call(null,(0),auth);
var state_79711__$1 = state_79711;
if(inst_79680){
var statearr_79713_79744 = state_79711__$1;
(statearr_79713_79744[(1)] = (9));

} else {
var statearr_79714_79745 = state_79711__$1;
(statearr_79714_79745[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79712 === (1))){
var state_79711__$1 = state_79711;
var statearr_79715_79746 = state_79711__$1;
(statearr_79715_79746[(2)] = null);

(statearr_79715_79746[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79712 === (4))){
var inst_79671 = (state_79711[(2)]);
var state_79711__$1 = state_79711;
var statearr_79716_79747 = state_79711__$1;
(statearr_79716_79747[(2)] = inst_79671);

(statearr_79716_79747[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79712 === (15))){
var inst_79688 = (state_79711[(7)]);
var inst_79687 = (state_79711[(2)]);
var inst_79688__$1 = fluree.db.util.async.throw_err.call(null,inst_79687);
var state_79711__$1 = (function (){var statearr_79717 = state_79711;
(statearr_79717[(7)] = inst_79688__$1);

return statearr_79717;
})();
if(cljs.core.truth_(inst_79688__$1)){
var statearr_79718_79748 = state_79711__$1;
(statearr_79718_79748[(1)] = (16));

} else {
var statearr_79719_79749 = state_79711__$1;
(statearr_79719_79749[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79712 === (13))){
var state_79711__$1 = state_79711;
var statearr_79720_79750 = state_79711__$1;
(statearr_79720_79750[(2)] = null);

(statearr_79720_79750[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79712 === (6))){
var state_79711__$1 = state_79711;
var statearr_79721_79751 = state_79711__$1;
(statearr_79721_79751[(2)] = db);

(statearr_79721_79751[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79712 === (17))){
var inst_79692 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_79693 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_79694 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_79695 = cljs.core.PersistentHashMap.fromArrays(inst_79693,inst_79694);
var inst_79696 = cljs.core.ex_info.call(null,inst_79692,inst_79695);
var inst_79697 = (function(){throw inst_79696})();
var state_79711__$1 = state_79711;
var statearr_79722_79752 = state_79711__$1;
(statearr_79722_79752[(2)] = inst_79697);

(statearr_79722_79752[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79712 === (3))){
var inst_79709 = (state_79711[(2)]);
var state_79711__$1 = state_79711;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79711__$1,inst_79709);
} else {
if((state_val_79712 === (12))){
var inst_79685 = fluree.db.dbproto._subid.call(null,db,auth);
var state_79711__$1 = state_79711;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_79711__$1,(15),inst_79685);
} else {
if((state_val_79712 === (2))){
var _ = (function (){var statearr_79723 = state_79711;
(statearr_79723[(4)] = cljs.core.cons.call(null,(5),(state_79711[(4)])));

return statearr_79723;
})();
var inst_79677 = cljs.core.not.call(null,auth);
var state_79711__$1 = state_79711;
if(inst_79677){
var statearr_79724_79753 = state_79711__$1;
(statearr_79724_79753[(1)] = (6));

} else {
var statearr_79725_79754 = state_79711__$1;
(statearr_79725_79754[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79712 === (11))){
var inst_79704 = (state_79711[(2)]);
var state_79711__$1 = state_79711;
var statearr_79727_79755 = state_79711__$1;
(statearr_79727_79755[(2)] = inst_79704);

(statearr_79727_79755[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79712 === (9))){
var inst_79682 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_79711__$1 = state_79711;
var statearr_79728_79756 = state_79711__$1;
(statearr_79728_79756[(2)] = inst_79682);

(statearr_79728_79756[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79712 === (5))){
var _ = (function (){var statearr_79729 = state_79711;
(statearr_79729[(4)] = cljs.core.rest.call(null,(state_79711[(4)])));

return statearr_79729;
})();
var state_79711__$1 = state_79711;
var ex79726 = (state_79711__$1[(2)]);
var statearr_79730_79757 = state_79711__$1;
(statearr_79730_79757[(5)] = ex79726);


if((ex79726 instanceof Error)){
var statearr_79731_79758 = state_79711__$1;
(statearr_79731_79758[(1)] = (4));

(statearr_79731_79758[(5)] = null);

} else {
throw ex79726;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79712 === (14))){
var inst_79702 = (state_79711[(2)]);
var state_79711__$1 = state_79711;
var statearr_79732_79759 = state_79711__$1;
(statearr_79732_79759[(2)] = inst_79702);

(statearr_79732_79759[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79712 === (16))){
var inst_79688 = (state_79711[(7)]);
var inst_79690 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_79688);
var state_79711__$1 = state_79711;
var statearr_79733_79760 = state_79711__$1;
(statearr_79733_79760[(2)] = inst_79690);

(statearr_79733_79760[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79712 === (10))){
var state_79711__$1 = state_79711;
var statearr_79734_79761 = state_79711__$1;
(statearr_79734_79761[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79712 === (18))){
var inst_79699 = (state_79711[(2)]);
var state_79711__$1 = state_79711;
var statearr_79736_79762 = state_79711__$1;
(statearr_79736_79762[(2)] = inst_79699);

(statearr_79736_79762[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79712 === (8))){
var inst_79706 = (state_79711[(2)]);
var _ = (function (){var statearr_79737 = state_79711;
(statearr_79737[(4)] = cljs.core.rest.call(null,(state_79711[(4)])));

return statearr_79737;
})();
var state_79711__$1 = state_79711;
var statearr_79738_79763 = state_79711__$1;
(statearr_79738_79763[(2)] = inst_79706);

(statearr_79738_79763[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__10903__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__10903__auto____0 = (function (){
var statearr_79739 = [null,null,null,null,null,null,null,null];
(statearr_79739[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__10903__auto__);

(statearr_79739[(1)] = (1));

return statearr_79739;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__10903__auto____1 = (function (state_79711){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_79711);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e79740){var ex__10906__auto__ = e79740;
var statearr_79741_79764 = state_79711;
(statearr_79741_79764[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_79711[(4)]))){
var statearr_79742_79765 = state_79711;
(statearr_79742_79765[(1)] = cljs.core.first.call(null,(state_79711[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79766 = state_79711;
state_79711 = G__79766;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__10903__auto__ = function(state_79711){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__10903__auto____1.call(this,state_79711);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__10903__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__10903__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_79743 = f__10977__auto__.call(null);
(statearr_79743[(6)] = c__10976__auto__);

return statearr_79743;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_79830){
var state_val_79831 = (state_79830[(1)]);
if((state_val_79831 === (7))){
var inst_79776 = cljs.core._EQ_.call(null,(0),auth);
var state_79830__$1 = state_79830;
if(inst_79776){
var statearr_79832_79881 = state_79830__$1;
(statearr_79832_79881[(1)] = (9));

} else {
var statearr_79833_79882 = state_79830__$1;
(statearr_79833_79882[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79831 === (20))){
var inst_79800 = (state_79830[(7)]);
var state_79830__$1 = state_79830;
if(cljs.core.truth_(inst_79800)){
var statearr_79834_79883 = state_79830__$1;
(statearr_79834_79883[(1)] = (22));

} else {
var statearr_79835_79884 = state_79830__$1;
(statearr_79835_79884[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79831 === (27))){
var state_79830__$1 = state_79830;
var statearr_79836_79885 = state_79830__$1;
(statearr_79836_79885[(2)] = null);

(statearr_79836_79885[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79831 === (1))){
var state_79830__$1 = state_79830;
var statearr_79837_79886 = state_79830__$1;
(statearr_79837_79886[(2)] = null);

(statearr_79837_79886[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79831 === (24))){
var inst_79814 = (state_79830[(2)]);
var state_79830__$1 = state_79830;
var statearr_79838_79887 = state_79830__$1;
(statearr_79838_79887[(2)] = inst_79814);

(statearr_79838_79887[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79831 === (4))){
var inst_79767 = (state_79830[(2)]);
var state_79830__$1 = state_79830;
var statearr_79839_79888 = state_79830__$1;
(statearr_79839_79888[(2)] = inst_79767);

(statearr_79839_79888[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79831 === (15))){
var inst_79783 = (state_79830[(8)]);
var inst_79782 = (state_79830[(2)]);
var inst_79783__$1 = fluree.db.util.async.throw_err.call(null,inst_79782);
var state_79830__$1 = (function (){var statearr_79840 = state_79830;
(statearr_79840[(8)] = inst_79783__$1);

return statearr_79840;
})();
if(cljs.core.truth_(inst_79783__$1)){
var statearr_79841_79889 = state_79830__$1;
(statearr_79841_79889[(1)] = (16));

} else {
var statearr_79842_79890 = state_79830__$1;
(statearr_79842_79890[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79831 === (21))){
var inst_79816 = (state_79830[(9)]);
var inst_79816__$1 = (state_79830[(2)]);
var state_79830__$1 = (function (){var statearr_79843 = state_79830;
(statearr_79843[(9)] = inst_79816__$1);

return statearr_79843;
})();
if(cljs.core.truth_(inst_79816__$1)){
var statearr_79844_79891 = state_79830__$1;
(statearr_79844_79891[(1)] = (29));

} else {
var statearr_79845_79892 = state_79830__$1;
(statearr_79845_79892[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79831 === (31))){
var inst_79800 = (state_79830[(7)]);
var inst_79816 = (state_79830[(9)]);
var inst_79824 = (state_79830[(2)]);
var inst_79825 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_79800,new cljs.core.Keyword(null,"roles","roles",143379530),inst_79816,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_79824);
var _ = (function (){var statearr_79846 = state_79830;
(statearr_79846[(4)] = cljs.core.rest.call(null,(state_79830[(4)])));

return statearr_79846;
})();
var state_79830__$1 = state_79830;
var statearr_79847_79893 = state_79830__$1;
(statearr_79847_79893[(2)] = inst_79825);

(statearr_79847_79893[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79831 === (32))){
var inst_79820 = (state_79830[(2)]);
var inst_79821 = fluree.db.util.async.throw_err.call(null,inst_79820);
var state_79830__$1 = state_79830;
var statearr_79848_79894 = state_79830__$1;
(statearr_79848_79894[(2)] = inst_79821);

(statearr_79848_79894[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79831 === (13))){
var state_79830__$1 = state_79830;
var statearr_79849_79895 = state_79830__$1;
(statearr_79849_79895[(2)] = null);

(statearr_79849_79895[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79831 === (22))){
var inst_79800 = (state_79830[(7)]);
var inst_79804 = fluree.db.auth.roles.call(null,db,inst_79800);
var state_79830__$1 = state_79830;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_79830__$1,(25),inst_79804);
} else {
if((state_val_79831 === (29))){
var inst_79816 = (state_79830[(9)]);
var inst_79818 = fluree.db.permissions.permission_map.call(null,db,inst_79816,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_79830__$1 = state_79830;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_79830__$1,(32),inst_79818);
} else {
if((state_val_79831 === (6))){
var state_79830__$1 = state_79830;
var statearr_79850_79896 = state_79830__$1;
(statearr_79850_79896[(2)] = null);

(statearr_79850_79896[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79831 === (28))){
var inst_79812 = (state_79830[(2)]);
var state_79830__$1 = state_79830;
var statearr_79851_79897 = state_79830__$1;
(statearr_79851_79897[(2)] = inst_79812);

(statearr_79851_79897[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79831 === (25))){
var inst_79806 = (state_79830[(2)]);
var inst_79807 = fluree.db.util.async.throw_err.call(null,inst_79806);
var state_79830__$1 = state_79830;
var statearr_79852_79898 = state_79830__$1;
(statearr_79852_79898[(2)] = inst_79807);

(statearr_79852_79898[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79831 === (17))){
var inst_79786 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_79787 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_79788 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_79789 = cljs.core.PersistentHashMap.fromArrays(inst_79787,inst_79788);
var inst_79790 = cljs.core.ex_info.call(null,inst_79786,inst_79789);
var inst_79791 = (function(){throw inst_79790})();
var state_79830__$1 = state_79830;
var statearr_79853_79899 = state_79830__$1;
(statearr_79853_79899[(2)] = inst_79791);

(statearr_79853_79899[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79831 === (3))){
var inst_79828 = (state_79830[(2)]);
var state_79830__$1 = state_79830;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79830__$1,inst_79828);
} else {
if((state_val_79831 === (12))){
var inst_79780 = fluree.db.dbproto._subid.call(null,db,auth);
var state_79830__$1 = state_79830;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_79830__$1,(15),inst_79780);
} else {
if((state_val_79831 === (2))){
var _ = (function (){var statearr_79854 = state_79830;
(statearr_79854[(4)] = cljs.core.cons.call(null,(5),(state_79830[(4)])));

return statearr_79854;
})();
var inst_79773 = (auth == null);
var state_79830__$1 = state_79830;
if(cljs.core.truth_(inst_79773)){
var statearr_79855_79900 = state_79830__$1;
(statearr_79855_79900[(1)] = (6));

} else {
var statearr_79856_79901 = state_79830__$1;
(statearr_79856_79901[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79831 === (23))){
var state_79830__$1 = state_79830;
var statearr_79857_79902 = state_79830__$1;
(statearr_79857_79902[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79831 === (19))){
var state_79830__$1 = state_79830;
var statearr_79859_79903 = state_79830__$1;
(statearr_79859_79903[(2)] = roles);

(statearr_79859_79903[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79831 === (11))){
var inst_79798 = (state_79830[(2)]);
var state_79830__$1 = state_79830;
var statearr_79861_79904 = state_79830__$1;
(statearr_79861_79904[(2)] = inst_79798);

(statearr_79861_79904[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79831 === (9))){
var state_79830__$1 = state_79830;
var statearr_79862_79905 = state_79830__$1;
(statearr_79862_79905[(2)] = (0));

(statearr_79862_79905[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79831 === (5))){
var _ = (function (){var statearr_79863 = state_79830;
(statearr_79863[(4)] = cljs.core.rest.call(null,(state_79830[(4)])));

return statearr_79863;
})();
var state_79830__$1 = state_79830;
var ex79860 = (state_79830__$1[(2)]);
var statearr_79864_79906 = state_79830__$1;
(statearr_79864_79906[(5)] = ex79860);


if((ex79860 instanceof Error)){
var statearr_79865_79907 = state_79830__$1;
(statearr_79865_79907[(1)] = (4));

(statearr_79865_79907[(5)] = null);

} else {
throw ex79860;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79831 === (14))){
var inst_79796 = (state_79830[(2)]);
var state_79830__$1 = state_79830;
var statearr_79866_79908 = state_79830__$1;
(statearr_79866_79908[(2)] = inst_79796);

(statearr_79866_79908[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79831 === (26))){
var state_79830__$1 = state_79830;
var statearr_79867_79909 = state_79830__$1;
(statearr_79867_79909[(2)] = null);

(statearr_79867_79909[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79831 === (16))){
var inst_79783 = (state_79830[(8)]);
var state_79830__$1 = state_79830;
var statearr_79868_79910 = state_79830__$1;
(statearr_79868_79910[(2)] = inst_79783);

(statearr_79868_79910[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79831 === (30))){
var state_79830__$1 = state_79830;
var statearr_79869_79911 = state_79830__$1;
(statearr_79869_79911[(2)] = null);

(statearr_79869_79911[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79831 === (10))){
var state_79830__$1 = state_79830;
if(cljs.core.truth_(auth)){
var statearr_79870_79912 = state_79830__$1;
(statearr_79870_79912[(1)] = (12));

} else {
var statearr_79871_79913 = state_79830__$1;
(statearr_79871_79913[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79831 === (18))){
var inst_79793 = (state_79830[(2)]);
var state_79830__$1 = state_79830;
var statearr_79872_79914 = state_79830__$1;
(statearr_79872_79914[(2)] = inst_79793);

(statearr_79872_79914[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79831 === (8))){
var inst_79800 = (state_79830[(2)]);
var state_79830__$1 = (function (){var statearr_79873 = state_79830;
(statearr_79873[(7)] = inst_79800);

return statearr_79873;
})();
if(cljs.core.truth_(roles)){
var statearr_79874_79915 = state_79830__$1;
(statearr_79874_79915[(1)] = (19));

} else {
var statearr_79875_79916 = state_79830__$1;
(statearr_79875_79916[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__10903__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__10903__auto____0 = (function (){
var statearr_79876 = [null,null,null,null,null,null,null,null,null,null];
(statearr_79876[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__10903__auto__);

(statearr_79876[(1)] = (1));

return statearr_79876;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__10903__auto____1 = (function (state_79830){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_79830);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e79877){var ex__10906__auto__ = e79877;
var statearr_79878_79917 = state_79830;
(statearr_79878_79917[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_79830[(4)]))){
var statearr_79879_79918 = state_79830;
(statearr_79879_79918[(1)] = cljs.core.first.call(null,(state_79830[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79919 = state_79830;
state_79830 = G__79919;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__10903__auto__ = function(state_79830){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__10903__auto____1.call(this,state_79830);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__10903__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__10903__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_79880 = f__10977__auto__.call(null);
(statearr_79880[(6)] = c__10976__auto__);

return statearr_79880;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__79920 = db;
var map__79920__$1 = cljs.core.__destructure_map.call(null,map__79920);
var conn = cljs.core.get.call(null,map__79920__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__79920__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__79920__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
fluree.db.util.log.warn.call(null,"NEW EVENT:",cljs.core.pr_str.call(null,evt),cljs.core.pr_str.call(null,data));

if(((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_.call(null,new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener.call(null,conn,network,dbid,listen_id);

var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_79927){
var state_val_79928 = (state_79927[(1)]);
if((state_val_79928 === (1))){
var inst_79921 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_79922 = fluree.db.session.db.call(null,conn,inst_79921,null);
var state_79927__$1 = state_79927;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_79927__$1,(2),inst_79922);
} else {
if((state_val_79928 === (2))){
var inst_79924 = (state_79927[(2)]);
var inst_79925 = cljs.core.async.put_BANG_.call(null,resp_port,inst_79924);
var state_79927__$1 = state_79927;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79927__$1,inst_79925);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__10903__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__10903__auto____0 = (function (){
var statearr_79929 = [null,null,null,null,null,null,null];
(statearr_79929[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__10903__auto__);

(statearr_79929[(1)] = (1));

return statearr_79929;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__10903__auto____1 = (function (state_79927){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_79927);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e79930){var ex__10906__auto__ = e79930;
var statearr_79931_79958 = state_79927;
(statearr_79931_79958[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_79927[(4)]))){
var statearr_79932_79959 = state_79927;
(statearr_79932_79959[(1)] = cljs.core.first.call(null,(state_79927[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79960 = state_79927;
state_79927 = G__79960;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__10903__auto__ = function(state_79927){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__10903__auto____1.call(this,state_79927);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__10903__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__10903__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_79933 = f__10977__auto__.call(null);
(statearr_79933[(6)] = c__10976__auto__);

return statearr_79933;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener.call(null,conn,network,dbid,listen_id,event_fn);

var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_79946){
var state_val_79947 = (state_79946[(1)]);
if((state_val_79947 === (1))){
var inst_79934 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_79935 = fluree.db.session.db.call(null,conn,inst_79934,null);
var state_79946__$1 = state_79946;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_79946__$1,(2),inst_79935);
} else {
if((state_val_79947 === (2))){
var inst_79937 = (state_79946[(7)]);
var inst_79937__$1 = (state_79946[(2)]);
var inst_79938 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_79937__$1);
var inst_79939 = newer_block_QMARK_.call(null,inst_79938);
var state_79946__$1 = (function (){var statearr_79948 = state_79946;
(statearr_79948[(7)] = inst_79937__$1);

return statearr_79948;
})();
if(inst_79939){
var statearr_79949_79961 = state_79946__$1;
(statearr_79949_79961[(1)] = (3));

} else {
var statearr_79950_79962 = state_79946__$1;
(statearr_79950_79962[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79947 === (3))){
var inst_79937 = (state_79946[(7)]);
var inst_79941 = cljs.core.async.put_BANG_.call(null,resp_port,inst_79937);
var state_79946__$1 = state_79946;
var statearr_79951_79963 = state_79946__$1;
(statearr_79951_79963[(2)] = inst_79941);

(statearr_79951_79963[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79947 === (4))){
var state_79946__$1 = state_79946;
var statearr_79952_79964 = state_79946__$1;
(statearr_79952_79964[(2)] = null);

(statearr_79952_79964[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79947 === (5))){
var inst_79944 = (state_79946[(2)]);
var state_79946__$1 = state_79946;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79946__$1,inst_79944);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__10903__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__10903__auto____0 = (function (){
var statearr_79953 = [null,null,null,null,null,null,null,null];
(statearr_79953[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__10903__auto__);

(statearr_79953[(1)] = (1));

return statearr_79953;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__10903__auto____1 = (function (state_79946){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_79946);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e79954){var ex__10906__auto__ = e79954;
var statearr_79955_79965 = state_79946;
(statearr_79955_79965[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_79946[(4)]))){
var statearr_79956_79966 = state_79946;
(statearr_79956_79966[(1)] = cljs.core.first.call(null,(state_79946[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79967 = state_79946;
state_79946 = G__79967;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__10903__auto__ = function(state_79946){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__10903__auto____1.call(this,state_79946);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__10903__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__10903__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_79957 = f__10977__auto__.call(null);
(statearr_79957[(6)] = c__10976__auto__);

return statearr_79957;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_.call(null,syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.call(null);
var map__79968 = db;
var map__79968__$1 = cljs.core.__destructure_map.call(null,map__79968);
var conn = cljs.core.get.call(null,map__79968__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__79968__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__79968__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var listen_id = fluree.db.util.core.random_uuid.call(null);
var timeout = ((cljs.core.pos_int_QMARK_.call(null,syncTimeout))?(function (){var x__4339__auto__ = syncTimeout;
var y__4340__auto__ = (120000);
return ((x__4339__auto__ < y__4340__auto__) ? x__4339__auto__ : y__4340__auto__);
})():(60000));
var res_port = cljs.core.async.chan.call(null);
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.call(null,pc,db);
} else {
fluree.db.api.ledger.syncTo_wait.call(null,db,syncTo,listen_id,res_port);

var c__10976__auto___80044 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_80018){
var state_val_80019 = (state_80018[(1)]);
if((state_val_80019 === (7))){
var inst_79984 = (state_80018[(7)]);
var inst_79995 = cljs.core._EQ_.call(null,inst_79984,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_80018__$1 = state_80018;
if(inst_79995){
var statearr_80020_80045 = state_80018__$1;
(statearr_80020_80045[(1)] = (9));

} else {
var statearr_80021_80046 = state_80018__$1;
(statearr_80021_80046[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80019 === (1))){
var inst_79977 = (state_80018[(8)]);
var inst_79969 = (state_80018[(9)]);
var inst_79969__$1 = cljs.core.async.timeout.call(null,timeout);
var inst_79977__$1 = res_port;
var inst_79978 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79979 = [inst_79969__$1,inst_79977__$1];
var inst_79980 = (new cljs.core.PersistentVector(null,2,(5),inst_79978,inst_79979,null));
var state_80018__$1 = (function (){var statearr_80022 = state_80018;
(statearr_80022[(8)] = inst_79977__$1);

(statearr_80022[(9)] = inst_79969__$1);

return statearr_80022;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_80018__$1,(2),inst_79980);
} else {
if((state_val_80019 === (4))){
var inst_79984 = (state_80018[(7)]);
var inst_79977 = (state_80018[(8)]);
var inst_79988 = cljs.core._EQ_.call(null,inst_79984,inst_79977);
var state_80018__$1 = state_80018;
if(inst_79988){
var statearr_80023_80047 = state_80018__$1;
(statearr_80023_80047[(1)] = (6));

} else {
var statearr_80024_80048 = state_80018__$1;
(statearr_80024_80048[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80019 === (13))){
var inst_80003 = (state_80018[(10)]);
var inst_80014 = cljs.core.async.put_BANG_.call(null,pc,inst_80003);
var state_80018__$1 = state_80018;
var statearr_80025_80049 = state_80018__$1;
(statearr_80025_80049[(2)] = inst_80014);

(statearr_80025_80049[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80019 === (6))){
var inst_79982 = (state_80018[(11)]);
var inst_79993 = cljs.core.nth.call(null,inst_79982,(0),null);
var state_80018__$1 = state_80018;
var statearr_80026_80050 = state_80018__$1;
(statearr_80026_80050[(2)] = inst_79993);

(statearr_80026_80050[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80019 === (3))){
var state_80018__$1 = state_80018;
var statearr_80027_80051 = state_80018__$1;
(statearr_80027_80051[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_80027_80051[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80019 === (12))){
var inst_80007 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_80008 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_80009 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_80010 = cljs.core.PersistentHashMap.fromArrays(inst_80008,inst_80009);
var inst_80011 = cljs.core.ex_info.call(null,inst_80007,inst_80010);
var inst_80012 = cljs.core.async.put_BANG_.call(null,pc,inst_80011);
var state_80018__$1 = state_80018;
var statearr_80028_80052 = state_80018__$1;
(statearr_80028_80052[(2)] = inst_80012);

(statearr_80028_80052[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80019 === (2))){
var inst_79984 = (state_80018[(7)]);
var inst_79982 = (state_80018[(11)]);
var inst_79969 = (state_80018[(9)]);
var inst_79982__$1 = (state_80018[(2)]);
var inst_79983 = cljs.core.nth.call(null,inst_79982__$1,(0),null);
var inst_79984__$1 = cljs.core.nth.call(null,inst_79982__$1,(1),null);
var inst_79985 = cljs.core._EQ_.call(null,inst_79984__$1,inst_79969);
var state_80018__$1 = (function (){var statearr_80029 = state_80018;
(statearr_80029[(7)] = inst_79984__$1);

(statearr_80029[(12)] = inst_79983);

(statearr_80029[(11)] = inst_79982__$1);

return statearr_80029;
})();
if(inst_79985){
var statearr_80030_80053 = state_80018__$1;
(statearr_80030_80053[(1)] = (3));

} else {
var statearr_80031_80054 = state_80018__$1;
(statearr_80031_80054[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80019 === (11))){
var inst_79999 = (state_80018[(2)]);
var state_80018__$1 = state_80018;
var statearr_80032_80055 = state_80018__$1;
(statearr_80032_80055[(2)] = inst_79999);

(statearr_80032_80055[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80019 === (9))){
var inst_79983 = (state_80018[(12)]);
var state_80018__$1 = state_80018;
var statearr_80033_80056 = state_80018__$1;
(statearr_80033_80056[(2)] = inst_79983);

(statearr_80033_80056[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80019 === (5))){
var inst_80003 = (state_80018[(10)]);
var inst_80003__$1 = (state_80018[(2)]);
var inst_80004 = fluree.db.connection.remove_listener.call(null,conn,network,dbid,listen_id);
var inst_80005 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_80003__$1);
var state_80018__$1 = (function (){var statearr_80034 = state_80018;
(statearr_80034[(13)] = inst_80004);

(statearr_80034[(10)] = inst_80003__$1);

return statearr_80034;
})();
if(inst_80005){
var statearr_80035_80057 = state_80018__$1;
(statearr_80035_80057[(1)] = (12));

} else {
var statearr_80036_80058 = state_80018__$1;
(statearr_80036_80058[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80019 === (14))){
var inst_80016 = (state_80018[(2)]);
var state_80018__$1 = state_80018;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80018__$1,inst_80016);
} else {
if((state_val_80019 === (10))){
var state_80018__$1 = state_80018;
var statearr_80037_80059 = state_80018__$1;
(statearr_80037_80059[(2)] = null);

(statearr_80037_80059[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80019 === (8))){
var inst_80001 = (state_80018[(2)]);
var state_80018__$1 = state_80018;
var statearr_80038_80060 = state_80018__$1;
(statearr_80038_80060[(2)] = inst_80001);

(statearr_80038_80060[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__10903__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__10903__auto____0 = (function (){
var statearr_80039 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_80039[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__10903__auto__);

(statearr_80039[(1)] = (1));

return statearr_80039;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__10903__auto____1 = (function (state_80018){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_80018);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e80040){var ex__10906__auto__ = e80040;
var statearr_80041_80061 = state_80018;
(statearr_80041_80061[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_80018[(4)]))){
var statearr_80042_80062 = state_80018;
(statearr_80042_80062[(1)] = cljs.core.first.call(null,(state_80018[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80063 = state_80018;
state_80018 = G__80063;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__10903__auto__ = function(state_80018){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__10903__auto____1.call(this,state_80018);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__10903__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__10903__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_80043 = f__10977__auto__.call(null);
(statearr_80043[(6)] = c__10976__auto___80044);

return statearr_80043;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__80065 = arguments.length;
switch (G__80065) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.call(null,conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__80066){
var map__80067 = p__80066;
var map__80067__$1 = cljs.core.__destructure_map.call(null,map__80067);
var opts = map__80067__$1;
var roles = cljs.core.get.call(null,map__80067__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.call(null,map__80067__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.call(null,map__80067__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.call(null,map__80067__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.call(null,map__80067__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.call(null);
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__10976__auto___80156 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_80118){
var state_val_80119 = (state_80118[(1)]);
if((state_val_80119 === (7))){
var inst_80080 = (state_80118[(7)]);
var inst_80082 = fluree.db.api.ledger.syncTo_db.call(null,inst_80080,syncTo,syncTimeout);
var state_80118__$1 = state_80118;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80118__$1,(10),inst_80082);
} else {
if((state_val_80119 === (20))){
var inst_80104 = (state_80118[(8)]);
var state_80118__$1 = state_80118;
var statearr_80120_80157 = state_80118__$1;
(statearr_80120_80157[(2)] = inst_80104);

(statearr_80120_80157[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80119 === (1))){
var state_80118__$1 = state_80118;
var statearr_80121_80158 = state_80118__$1;
(statearr_80121_80158[(2)] = null);

(statearr_80121_80158[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80119 === (4))){
var inst_80068 = (state_80118[(2)]);
var inst_80069 = cljs.core.async.put_BANG_.call(null,pc,inst_80068);
var inst_80070 = cljs.core.async.close_BANG_.call(null,pc);
var state_80118__$1 = (function (){var statearr_80122 = state_80118;
(statearr_80122[(9)] = inst_80069);

return statearr_80122;
})();
var statearr_80123_80159 = state_80118__$1;
(statearr_80123_80159[(2)] = inst_80070);

(statearr_80123_80159[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80119 === (15))){
var inst_80096 = (state_80118[(10)]);
var inst_80098 = fluree.db.api.ledger.add_db_permissions.call(null,inst_80096,auth,roles);
var state_80118__$1 = state_80118;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80118__$1,(18),inst_80098);
} else {
if((state_val_80119 === (21))){
var inst_80112 = (state_80118[(2)]);
var inst_80113 = cljs.core.async.put_BANG_.call(null,pc,inst_80112);
var _ = (function (){var statearr_80124 = state_80118;
(statearr_80124[(4)] = cljs.core.rest.call(null,(state_80118[(4)])));

return statearr_80124;
})();
var state_80118__$1 = state_80118;
var statearr_80125_80160 = state_80118__$1;
(statearr_80125_80160[(2)] = inst_80113);

(statearr_80125_80160[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80119 === (13))){
var inst_80096 = (state_80118[(2)]);
var state_80118__$1 = (function (){var statearr_80126 = state_80118;
(statearr_80126[(10)] = inst_80096);

return statearr_80126;
})();
if(cljs.core.truth_(roles)){
var statearr_80127_80161 = state_80118__$1;
(statearr_80127_80161[(1)] = (15));

} else {
var statearr_80128_80162 = state_80118__$1;
(statearr_80128_80162[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80119 === (22))){
var inst_80108 = (state_80118[(2)]);
var inst_80109 = fluree.db.util.async.throw_err.call(null,inst_80108);
var state_80118__$1 = state_80118;
var statearr_80129_80163 = state_80118__$1;
(statearr_80129_80163[(2)] = inst_80109);

(statearr_80129_80163[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80119 === (6))){
var inst_80079 = (state_80118[(2)]);
var inst_80080 = fluree.db.util.async.throw_err.call(null,inst_80079);
var state_80118__$1 = (function (){var statearr_80130 = state_80118;
(statearr_80130[(7)] = inst_80080);

return statearr_80130;
})();
if(cljs.core.truth_(syncTo)){
var statearr_80131_80164 = state_80118__$1;
(statearr_80131_80164[(1)] = (7));

} else {
var statearr_80132_80165 = state_80118__$1;
(statearr_80132_80165[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80119 === (17))){
var inst_80104 = (state_80118[(2)]);
var state_80118__$1 = (function (){var statearr_80133 = state_80118;
(statearr_80133[(8)] = inst_80104);

return statearr_80133;
})();
if(cljs.core.truth_(auth)){
var statearr_80134_80166 = state_80118__$1;
(statearr_80134_80166[(1)] = (19));

} else {
var statearr_80135_80167 = state_80118__$1;
(statearr_80135_80167[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80119 === (3))){
var inst_80116 = (state_80118[(2)]);
var state_80118__$1 = state_80118;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80118__$1,inst_80116);
} else {
if((state_val_80119 === (12))){
var inst_80088 = (state_80118[(11)]);
var state_80118__$1 = state_80118;
var statearr_80136_80168 = state_80118__$1;
(statearr_80136_80168[(2)] = inst_80088);

(statearr_80136_80168[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80119 === (2))){
var _ = (function (){var statearr_80137 = state_80118;
(statearr_80137[(4)] = cljs.core.cons.call(null,(5),(state_80118[(4)])));

return statearr_80137;
})();
var inst_80077 = fluree.db.session.db.call(null,conn,ledger,opts_SINGLEQUOTE_);
var state_80118__$1 = state_80118;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80118__$1,(6),inst_80077);
} else {
if((state_val_80119 === (19))){
var inst_80104 = (state_80118[(8)]);
var inst_80106 = fluree.db.api.ledger.add_db_permissions.call(null,inst_80104,auth,roles);
var state_80118__$1 = state_80118;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80118__$1,(22),inst_80106);
} else {
if((state_val_80119 === (11))){
var inst_80088 = (state_80118[(11)]);
var inst_80090 = fluree.db.time_travel.as_of_block.call(null,inst_80088,block);
var state_80118__$1 = state_80118;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80118__$1,(14),inst_80090);
} else {
if((state_val_80119 === (9))){
var inst_80088 = (state_80118[(2)]);
var state_80118__$1 = (function (){var statearr_80139 = state_80118;
(statearr_80139[(11)] = inst_80088);

return statearr_80139;
})();
if(cljs.core.truth_(block)){
var statearr_80140_80169 = state_80118__$1;
(statearr_80140_80169[(1)] = (11));

} else {
var statearr_80141_80170 = state_80118__$1;
(statearr_80141_80170[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80119 === (5))){
var _ = (function (){var statearr_80142 = state_80118;
(statearr_80142[(4)] = cljs.core.rest.call(null,(state_80118[(4)])));

return statearr_80142;
})();
var state_80118__$1 = state_80118;
var ex80138 = (state_80118__$1[(2)]);
var statearr_80143_80171 = state_80118__$1;
(statearr_80143_80171[(5)] = ex80138);


var statearr_80144_80172 = state_80118__$1;
(statearr_80144_80172[(1)] = (4));

(statearr_80144_80172[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80119 === (14))){
var inst_80092 = (state_80118[(2)]);
var inst_80093 = fluree.db.util.async.throw_err.call(null,inst_80092);
var state_80118__$1 = state_80118;
var statearr_80145_80173 = state_80118__$1;
(statearr_80145_80173[(2)] = inst_80093);

(statearr_80145_80173[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80119 === (16))){
var inst_80096 = (state_80118[(10)]);
var state_80118__$1 = state_80118;
var statearr_80146_80174 = state_80118__$1;
(statearr_80146_80174[(2)] = inst_80096);

(statearr_80146_80174[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80119 === (10))){
var inst_80084 = (state_80118[(2)]);
var inst_80085 = fluree.db.util.async.throw_err.call(null,inst_80084);
var state_80118__$1 = state_80118;
var statearr_80147_80175 = state_80118__$1;
(statearr_80147_80175[(2)] = inst_80085);

(statearr_80147_80175[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80119 === (18))){
var inst_80100 = (state_80118[(2)]);
var inst_80101 = fluree.db.util.async.throw_err.call(null,inst_80100);
var state_80118__$1 = state_80118;
var statearr_80148_80176 = state_80118__$1;
(statearr_80148_80176[(2)] = inst_80101);

(statearr_80148_80176[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80119 === (8))){
var inst_80080 = (state_80118[(7)]);
var state_80118__$1 = state_80118;
var statearr_80149_80177 = state_80118__$1;
(statearr_80149_80177[(2)] = inst_80080);

(statearr_80149_80177[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__10903__auto__ = null;
var fluree$db$api$ledger$state_machine__10903__auto____0 = (function (){
var statearr_80150 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_80150[(0)] = fluree$db$api$ledger$state_machine__10903__auto__);

(statearr_80150[(1)] = (1));

return statearr_80150;
});
var fluree$db$api$ledger$state_machine__10903__auto____1 = (function (state_80118){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_80118);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e80151){var ex__10906__auto__ = e80151;
var statearr_80152_80178 = state_80118;
(statearr_80152_80178[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_80118[(4)]))){
var statearr_80153_80179 = state_80118;
(statearr_80153_80179[(1)] = cljs.core.first.call(null,(state_80118[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80180 = state_80118;
state_80118 = G__80180;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__10903__auto__ = function(state_80118){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__10903__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__10903__auto____1.call(this,state_80118);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__10903__auto____0;
fluree$db$api$ledger$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__10903__auto____1;
return fluree$db$api$ledger$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_80154 = f__10977__auto__.call(null);
(statearr_80154[(6)] = c__10976__auto___80156);

return statearr_80154;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

