// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k38936,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__38940 = k38936;
var G__38940__$1 = (((G__38940 instanceof cljs.core.Keyword))?G__38940.fqn:null);
switch (G__38940__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k38936,else__4505__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4525__auto__,p__38941){
var vec__38942 = p__38941;
var k__4526__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38942,(0),null);
var v__4527__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38942,(1),null);
return (f__4523__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4523__auto__.cljs$core$IFn$_invoke$arity$3(ret__4525__auto__,k__4526__auto__,v__4527__auto__) : f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__));
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer(writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer(writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.session.DbSession{",", ","}",opts__4519__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__38935){
var self__ = this;
var G__38935__$1 = this;
return (new cljs.core.RecordIter((0),G__38935__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (){var fexpr__38945 = (function (coll__4499__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll(coll__4499__auto__));
});
return fexpr__38945(this__4498__auto____$1);
})();
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this38937,other38938){
var self__ = this;
var this38937__$1 = this;
return (((!((other38938 == null)))) && ((((this38937__$1.constructor === other38938.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38937__$1.conn,other38938.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38937__$1.network,other38938.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38937__$1.dbid,other38938.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38937__$1.db_name,other38938.db_name)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38937__$1.update_chan,other38938.update_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38937__$1.transact_chan,other38938.transact_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38937__$1.state,other38938.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38937__$1.schema_cache,other38938.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38937__$1.blank_db,other38938.blank_db)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38937__$1.close,other38938.close)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38937__$1.id,other38938.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38937__$1.__extmap,other38938.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k38936){
var self__ = this;
var this__4509__auto____$1 = this;
var G__38946 = k38936;
var G__38946__$1 = (((G__38946 instanceof cljs.core.Keyword))?G__38946.fqn:null);
switch (G__38946__$1) {
case "conn":
case "network":
case "dbid":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k38936);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__38935){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__38947 = cljs.core.keyword_identical_QMARK_;
var expr__38948 = k__4511__auto__;
if(cljs.core.truth_((function (){var G__38950 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__38951 = expr__38948;
return (pred__38947.cljs$core$IFn$_invoke$arity$2 ? pred__38947.cljs$core$IFn$_invoke$arity$2(G__38950,G__38951) : pred__38947.call(null,G__38950,G__38951));
})())){
return (new fluree.db.session.DbSession(G__38935,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38952 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__38953 = expr__38948;
return (pred__38947.cljs$core$IFn$_invoke$arity$2 ? pred__38947.cljs$core$IFn$_invoke$arity$2(G__38952,G__38953) : pred__38947.call(null,G__38952,G__38953));
})())){
return (new fluree.db.session.DbSession(self__.conn,G__38935,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38954 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__38955 = expr__38948;
return (pred__38947.cljs$core$IFn$_invoke$arity$2 ? pred__38947.cljs$core$IFn$_invoke$arity$2(G__38954,G__38955) : pred__38947.call(null,G__38954,G__38955));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__38935,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38956 = new cljs.core.Keyword(null,"db-name","db-name",1157928745);
var G__38957 = expr__38948;
return (pred__38947.cljs$core$IFn$_invoke$arity$2 ? pred__38947.cljs$core$IFn$_invoke$arity$2(G__38956,G__38957) : pred__38947.call(null,G__38956,G__38957));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__38935,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38958 = new cljs.core.Keyword(null,"update-chan","update-chan",-863760792);
var G__38959 = expr__38948;
return (pred__38947.cljs$core$IFn$_invoke$arity$2 ? pred__38947.cljs$core$IFn$_invoke$arity$2(G__38958,G__38959) : pred__38947.call(null,G__38958,G__38959));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__38935,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38960 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840);
var G__38961 = expr__38948;
return (pred__38947.cljs$core$IFn$_invoke$arity$2 ? pred__38947.cljs$core$IFn$_invoke$arity$2(G__38960,G__38961) : pred__38947.call(null,G__38960,G__38961));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__38935,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38962 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__38963 = expr__38948;
return (pred__38947.cljs$core$IFn$_invoke$arity$2 ? pred__38947.cljs$core$IFn$_invoke$arity$2(G__38962,G__38963) : pred__38947.call(null,G__38962,G__38963));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__38935,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38964 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__38965 = expr__38948;
return (pred__38947.cljs$core$IFn$_invoke$arity$2 ? pred__38947.cljs$core$IFn$_invoke$arity$2(G__38964,G__38965) : pred__38947.call(null,G__38964,G__38965));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__38935,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38966 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534);
var G__38967 = expr__38948;
return (pred__38947.cljs$core$IFn$_invoke$arity$2 ? pred__38947.cljs$core$IFn$_invoke$arity$2(G__38966,G__38967) : pred__38947.call(null,G__38966,G__38967));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__38935,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38968 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__38969 = expr__38948;
return (pred__38947.cljs$core$IFn$_invoke$arity$2 ? pred__38947.cljs$core$IFn$_invoke$arity$2(G__38968,G__38969) : pred__38947.call(null,G__38968,G__38969));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__38935,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38970 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__38971 = expr__38948;
return (pred__38947.cljs$core$IFn$_invoke$arity$2 ? pred__38947.cljs$core$IFn$_invoke$arity$2(G__38970,G__38971) : pred__38947.call(null,G__38970,G__38971));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__38935,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4511__auto__,G__38935),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__38935){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__38935,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write(writer__4547__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__38939){
var extmap__4542__auto__ = (function (){var G__38972 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__38939,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], 0));
if(cljs.core.record_QMARK_(G__38939)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__38972);
} else {
return G__38972;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__38939),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__38939),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__38939),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__38939),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__38939),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__38939),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__38939),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__38939),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__38939),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__38939),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__38939),null,cljs.core.not_empty(extmap__4542__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.session.cache_factory());
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__38975 = session;
var map__38975__$1 = cljs.core.__destructure_map(map__38975);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38975__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38975__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(c,cache_key))){
return c;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(c,cache_key,session);
}
}));

return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_(fluree.db.session.session_cache,fluree.db.session.cache_factory());
});
fluree.db.session.full_load_existing_db = (function fluree$db$session$full_load_existing_db(session){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__11484__auto___39126 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_39078){
var state_val_39079 = (state_39078[(1)]);
if((state_val_39079 === (7))){
var inst_38996 = (state_39078[(7)]);
var inst_39001 = cljs.core.empty_QMARK_(inst_38996);
var state_39078__$1 = state_39078;
if(inst_39001){
var statearr_39080_39127 = state_39078__$1;
(statearr_39080_39127[(1)] = (10));

} else {
var statearr_39081_39128 = state_39078__$1;
(statearr_39081_39128[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39079 === (20))){
var inst_38988 = (state_39078[(8)]);
var inst_39027 = (state_39078[(9)]);
var inst_38987 = (state_39078[(10)]);
var inst_38989 = (state_39078[(11)]);
var inst_39032 = fluree.db.storage.core.read_block(inst_38987,inst_38988,inst_38989,inst_39027);
var state_39078__$1 = state_39078;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39078__$1,(22),inst_39032);
} else {
if((state_val_39079 === (27))){
var inst_39065 = (state_39078[(12)]);
var inst_39067 = (state_39078[(2)]);
var inst_39068 = fluree.db.util.async.throw_err(inst_39067);
var state_39078__$1 = (function (){var statearr_39082 = state_39078;
(statearr_39082[(13)] = inst_39068);

return statearr_39082;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39078__$1,(28),inst_39065);
} else {
if((state_val_39079 === (1))){
var state_39078__$1 = state_39078;
var statearr_39083_39129 = state_39078__$1;
(statearr_39083_39129[(2)] = null);

(statearr_39083_39129[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39079 === (24))){
var inst_38988 = (state_39078[(8)]);
var inst_39027 = (state_39078[(9)]);
var inst_38989 = (state_39078[(11)]);
var inst_39049 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39027)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38988),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38989),"."].join('');
var inst_39050 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_39051 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_39052 = cljs.core.PersistentHashMap.fromArrays(inst_39050,inst_39051);
var inst_39053 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39049,inst_39052);
var inst_39054 = (function(){throw inst_39053})();
var state_39078__$1 = state_39078;
var statearr_39084_39130 = state_39078__$1;
(statearr_39084_39130[(2)] = inst_39054);

(statearr_39084_39130[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39079 === (4))){
var inst_38976 = (state_39078[(2)]);
var inst_38977 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_38976);
var state_39078__$1 = state_39078;
var statearr_39085_39131 = state_39078__$1;
(statearr_39085_39131[(2)] = inst_38977);

(statearr_39085_39131[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39079 === (15))){
var state_39078__$1 = state_39078;
var statearr_39086_39132 = state_39078__$1;
(statearr_39086_39132[(2)] = null);

(statearr_39086_39132[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39079 === (21))){
var inst_39058 = (state_39078[(2)]);
var state_39078__$1 = state_39078;
var statearr_39087_39133 = state_39078__$1;
(statearr_39087_39133[(2)] = inst_39058);

(statearr_39087_39133[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39079 === (13))){
var inst_39021 = (state_39078[(14)]);
var inst_38996 = (state_39078[(7)]);
var inst_39020 = (state_39078[(2)]);
var inst_39021__$1 = fluree.db.util.async.throw_err(inst_39020);
var inst_39022 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_38996);
var state_39078__$1 = (function (){var statearr_39088 = state_39078;
(statearr_39088[(15)] = inst_39022);

(statearr_39088[(14)] = inst_39021__$1);

return statearr_39088;
})();
if(cljs.core.truth_(inst_39021__$1)){
var statearr_39089_39134 = state_39078__$1;
(statearr_39089_39134[(1)] = (14));

} else {
var statearr_39090_39135 = state_39078__$1;
(statearr_39090_39135[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39079 === (22))){
var inst_39035 = (state_39078[(16)]);
var inst_39034 = (state_39078[(2)]);
var inst_39035__$1 = fluree.db.util.async.throw_err(inst_39034);
var state_39078__$1 = (function (){var statearr_39091 = state_39078;
(statearr_39091[(16)] = inst_39035__$1);

return statearr_39091;
})();
if(cljs.core.truth_(inst_39035__$1)){
var statearr_39092_39136 = state_39078__$1;
(statearr_39092_39136[(1)] = (23));

} else {
var statearr_39093_39137 = state_39078__$1;
(statearr_39093_39137[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39079 === (6))){
var inst_38996 = (state_39078[(7)]);
var inst_38995 = (state_39078[(2)]);
var inst_38996__$1 = fluree.db.util.async.throw_err(inst_38995);
var inst_38997 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_38996__$1);
var inst_38998 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_38997);
var inst_38999 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ready","ready",1086465795),inst_38998);
var state_39078__$1 = (function (){var statearr_39094 = state_39078;
(statearr_39094[(7)] = inst_38996__$1);

return statearr_39094;
})();
if(inst_38999){
var statearr_39095_39138 = state_39078__$1;
(statearr_39095_39138[(1)] = (7));

} else {
var statearr_39096_39139 = state_39078__$1;
(statearr_39096_39139[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39079 === (28))){
var inst_39063 = (state_39078[(17)]);
var inst_39068 = (state_39078[(13)]);
var inst_39070 = (state_39078[(2)]);
var inst_39071 = fluree.db.util.async.throw_err(inst_39070);
var inst_39072 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_39063,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_39068,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"settings","settings",1556144875),inst_39071], 0));
var inst_39073 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_39072);
var _ = (function (){var statearr_39097 = state_39078;
(statearr_39097[(4)] = cljs.core.rest((state_39078[(4)])));

return statearr_39097;
})();
var state_39078__$1 = state_39078;
var statearr_39098_39140 = state_39078__$1;
(statearr_39098_39140[(2)] = inst_39073);

(statearr_39098_39140[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39079 === (25))){
var inst_39056 = (state_39078[(2)]);
var state_39078__$1 = state_39078;
var statearr_39099_39141 = state_39078__$1;
(statearr_39099_39141[(2)] = inst_39056);

(statearr_39099_39141[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39079 === (17))){
var inst_39022 = (state_39078[(15)]);
var inst_39027 = (state_39078[(9)]);
var inst_39029 = (inst_39027 > inst_39022);
var state_39078__$1 = state_39078;
if(cljs.core.truth_(inst_39029)){
var statearr_39100_39142 = state_39078__$1;
(statearr_39100_39142[(1)] = (19));

} else {
var statearr_39101_39143 = state_39078__$1;
(statearr_39101_39143[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39079 === (3))){
var inst_39076 = (state_39078[(2)]);
var state_39078__$1 = state_39078;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39078__$1,inst_39076);
} else {
if((state_val_39079 === (12))){
var inst_39008 = (state_39078[(2)]);
var inst_39009 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_39010 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_39011 = cljs.core.PersistentHashMap.fromArrays(inst_39009,inst_39010);
var inst_39012 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39008,inst_39011);
var inst_39013 = (function(){throw inst_39012})();
var state_39078__$1 = state_39078;
var statearr_39102_39144 = state_39078__$1;
(statearr_39102_39144[(2)] = inst_39013);

(statearr_39102_39144[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39079 === (2))){
var inst_38988 = (state_39078[(8)]);
var inst_38987 = (state_39078[(10)]);
var inst_38989 = (state_39078[(11)]);
var _ = (function (){var statearr_39103 = state_39078;
(statearr_39103[(4)] = cljs.core.cons((5),(state_39078[(4)])));

return statearr_39103;
})();
var inst_38984 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
var inst_38985 = session;
var inst_38986 = cljs.core.__destructure_map(inst_38985);
var inst_38987__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38986,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_38988__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38986,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_38989__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38986,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_38990 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38991 = [inst_38988__$1,inst_38989__$1];
var inst_38992 = (new cljs.core.PersistentVector(null,2,(5),inst_38990,inst_38991,null));
var inst_38993 = fluree.db.operations.ledger_info_async(inst_38987__$1,inst_38992);
var state_39078__$1 = (function (){var statearr_39104 = state_39078;
(statearr_39104[(8)] = inst_38988__$1);

(statearr_39104[(18)] = inst_38984);

(statearr_39104[(10)] = inst_38987__$1);

(statearr_39104[(11)] = inst_38989__$1);

return statearr_39104;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39078__$1,(6),inst_38993);
} else {
if((state_val_39079 === (23))){
var inst_39026 = (state_39078[(19)]);
var inst_39035 = (state_39078[(16)]);
var inst_39038 = cljs.core.__destructure_map(inst_39035);
var inst_39039 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39038,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_39040 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39038,new cljs.core.Keyword(null,"block","block",664686210));
var inst_39041 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39038,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_39042 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_39026,inst_39040,inst_39039);
var state_39078__$1 = (function (){var statearr_39105 = state_39078;
(statearr_39105[(20)] = inst_39041);

return statearr_39105;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39078__$1,(26),inst_39042);
} else {
if((state_val_39079 === (19))){
var inst_39026 = (state_39078[(19)]);
var state_39078__$1 = state_39078;
var statearr_39106_39145 = state_39078__$1;
(statearr_39106_39145[(2)] = inst_39026);

(statearr_39106_39145[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39079 === (11))){
var inst_38988 = (state_39078[(8)]);
var inst_38996 = (state_39078[(7)]);
var inst_38989 = (state_39078[(11)]);
var inst_39005 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_38996);
var inst_39006 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38988),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38989)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39005),"."].join('');
var state_39078__$1 = state_39078;
var statearr_39108_39146 = state_39078__$1;
(statearr_39108_39146[(2)] = inst_39006);

(statearr_39108_39146[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39079 === (9))){
var inst_38988 = (state_39078[(8)]);
var inst_38996 = (state_39078[(7)]);
var inst_38984 = (state_39078[(18)]);
var inst_38987 = (state_39078[(10)]);
var inst_38989 = (state_39078[(11)]);
var inst_39016 = (state_39078[(2)]);
var inst_39017 = new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(inst_38996);
var inst_39018 = fluree.db.storage.core.reify_db(inst_38987,inst_38988,inst_38989,inst_38984,inst_39017);
var state_39078__$1 = (function (){var statearr_39109 = state_39078;
(statearr_39109[(21)] = inst_39016);

return statearr_39109;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39078__$1,(13),inst_39018);
} else {
if((state_val_39079 === (5))){
var _ = (function (){var statearr_39110 = state_39078;
(statearr_39110[(4)] = cljs.core.rest((state_39078[(4)])));

return statearr_39110;
})();
var state_39078__$1 = state_39078;
var ex39107 = (state_39078__$1[(2)]);
var statearr_39111_39147 = state_39078__$1;
(statearr_39111_39147[(5)] = ex39107);


var statearr_39112_39148 = state_39078__$1;
(statearr_39112_39148[(1)] = (4));

(statearr_39112_39148[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39079 === (14))){
var inst_39021 = (state_39078[(14)]);
var inst_39024 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_39021);
var inst_39025 = (inst_39024 + (1));
var inst_39026 = inst_39021;
var inst_39027 = inst_39025;
var state_39078__$1 = (function (){var statearr_39113 = state_39078;
(statearr_39113[(19)] = inst_39026);

(statearr_39113[(9)] = inst_39027);

return statearr_39113;
})();
var statearr_39114_39149 = state_39078__$1;
(statearr_39114_39149[(2)] = null);

(statearr_39114_39149[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39079 === (26))){
var inst_39027 = (state_39078[(9)]);
var inst_39044 = (state_39078[(2)]);
var inst_39045 = fluree.db.util.async.throw_err(inst_39044);
var inst_39046 = (inst_39027 + (1));
var inst_39026 = inst_39045;
var inst_39027__$1 = inst_39046;
var state_39078__$1 = (function (){var statearr_39115 = state_39078;
(statearr_39115[(19)] = inst_39026);

(statearr_39115[(9)] = inst_39027__$1);

return statearr_39115;
})();
var statearr_39116_39150 = state_39078__$1;
(statearr_39116_39150[(2)] = null);

(statearr_39116_39150[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39079 === (16))){
var inst_39063 = (state_39078[(17)]);
var inst_39063__$1 = (state_39078[(2)]);
var inst_39064 = fluree.db.query.schema.schema_map(inst_39063__$1);
var inst_39065 = fluree.db.query.schema.setting_map(inst_39063__$1);
var state_39078__$1 = (function (){var statearr_39117 = state_39078;
(statearr_39117[(17)] = inst_39063__$1);

(statearr_39117[(12)] = inst_39065);

return statearr_39117;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39078__$1,(27),inst_39064);
} else {
if((state_val_39079 === (10))){
var inst_38988 = (state_39078[(8)]);
var inst_38989 = (state_39078[(11)]);
var inst_39003 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38988),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38989)," is not found on this ledger group."].join('');
var state_39078__$1 = state_39078;
var statearr_39118_39151 = state_39078__$1;
(statearr_39118_39151[(2)] = inst_39003);

(statearr_39118_39151[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39079 === (18))){
var inst_39060 = (state_39078[(2)]);
var state_39078__$1 = state_39078;
var statearr_39119_39152 = state_39078__$1;
(statearr_39119_39152[(2)] = inst_39060);

(statearr_39119_39152[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39079 === (8))){
var state_39078__$1 = state_39078;
var statearr_39120_39153 = state_39078__$1;
(statearr_39120_39153[(2)] = null);

(statearr_39120_39153[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$full_load_existing_db_$_state_machine__11410__auto__ = null;
var fluree$db$session$full_load_existing_db_$_state_machine__11410__auto____0 = (function (){
var statearr_39121 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39121[(0)] = fluree$db$session$full_load_existing_db_$_state_machine__11410__auto__);

(statearr_39121[(1)] = (1));

return statearr_39121;
});
var fluree$db$session$full_load_existing_db_$_state_machine__11410__auto____1 = (function (state_39078){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_39078);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e39122){var ex__11413__auto__ = e39122;
var statearr_39123_39154 = state_39078;
(statearr_39123_39154[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_39078[(4)]))){
var statearr_39124_39155 = state_39078;
(statearr_39124_39155[(1)] = cljs.core.first((state_39078[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39156 = state_39078;
state_39078 = G__39156;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$session$full_load_existing_db_$_state_machine__11410__auto__ = function(state_39078){
switch(arguments.length){
case 0:
return fluree$db$session$full_load_existing_db_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$session$full_load_existing_db_$_state_machine__11410__auto____1.call(this,state_39078);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$full_load_existing_db_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$full_load_existing_db_$_state_machine__11410__auto____0;
fluree$db$session$full_load_existing_db_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$full_load_existing_db_$_state_machine__11410__auto____1;
return fluree$db$session$full_load_existing_db_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_39125 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_39125[(6)] = c__11484__auto___39126);

return statearr_39125;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));


return pc;
});
/**
 * Performs a compare and set! to update db, but only does so if
 *   existing db promise-chan is the same as old-db-ch.
 * 
 *   Returns true if successful, false if it did not replace.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(session,old_db_ch,new_db_ch){
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (state){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(old_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(state))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state,new cljs.core.Keyword("db","db","db/db",993247817),new_db_ch);
} else {
return state;
}
}));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(new_state));
});
/**
 * Clears db from cache, forcing a new full load next time db is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),null);
});
/**
 * Clears any current db that is cached and forces a db reload.
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db(session));
});
/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_promise_ch = (function fluree$db$session$indexing_promise_ch(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock. Returns two-tuple of [lock? promise-chan]
 *   where lock? indicates if the lock was successful, and promise-chan is whatever
 *   promise-chan is registered for indexing.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,pc){
var swap_res = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),pc);
} else {
return s;
}
}));
var res_pc = new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(swap_res);
var lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(pc,res_pc);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lock_QMARK_,res_pc], null);
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("db","indexed","db/indexed",390759770),block], 0));
}));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__4253__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_(ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ledger);
var network = cljs.core.namespace(ledger__$1);
var maybe_alias = cljs.core.name(ledger__$1);
var _ = (cljs.core.truth_((function (){var and__4251__auto__ = network;
if(cljs.core.truth_(and__4251__auto__)){
return maybe_alias;
} else {
return and__4251__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ledger__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
if(clojure.string.starts_with_QMARK_(maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id(network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__4747__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4748__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4749__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4750__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__39157 = cljs.core.get_global_hierarchy;
return (fexpr__39157.cljs$core$IFn$_invoke$arity$0 ? fexpr__39157.cljs$core$IFn$_invoke$arity$0() : fexpr__39157.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4751__auto__,method_table__4747__auto__,prefer_table__4748__auto__,method_cache__4749__auto__,cached_hierarchy__4750__auto__));
})();
}
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),(function (_,___$1,___$2){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_39159){
var state_val_39160 = (state_39159[(1)]);
if((state_val_39160 === (1))){
var state_39159__$1 = state_39159;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39159__$1,new cljs.core.Keyword("fluree.db.session","no-op","fluree.db.session/no-op",1159713170));
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__11410__auto__ = null;
var fluree$db$session$state_machine__11410__auto____0 = (function (){
var statearr_39161 = [null,null,null,null,null,null,null];
(statearr_39161[(0)] = fluree$db$session$state_machine__11410__auto__);

(statearr_39161[(1)] = (1));

return statearr_39161;
});
var fluree$db$session$state_machine__11410__auto____1 = (function (state_39159){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_39159);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e39162){var ex__11413__auto__ = e39162;
var statearr_39163_39166 = state_39159;
(statearr_39163_39166[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_39159[(4)]))){
var statearr_39164_39167 = state_39159;
(statearr_39164_39167[(1)] = cljs.core.first((state_39159[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39168 = state_39159;
state_39159 = G__39168;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$session$state_machine__11410__auto__ = function(state_39159){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__11410__auto____1.call(this,state_39159);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__11410__auto____0;
fluree$db$session$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__11410__auto____1;
return fluree$db$session$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_39165 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_39165[(6)] = c__11484__auto__);

return statearr_39165;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__39170){
var map__39171 = p__39170;
var map__39171__$1 = cljs.core.__destructure_map(map__39171);
var data = map__39171__$1;
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39171__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39171__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39171__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_39230){
var state_val_39231 = (state_39230[(1)]);
if((state_val_39231 === (7))){
var inst_39182 = (state_39230[(7)]);
var inst_39185 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_39186 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_39187 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39185),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39186),": Received block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current at block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39182),". No-op."].join('');
var inst_39188 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_39187], 0));
var state_39230__$1 = state_39230;
var statearr_39232_39270 = state_39230__$1;
(statearr_39232_39270[(2)] = inst_39188);

(statearr_39232_39270[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39231 === (1))){
var state_39230__$1 = state_39230;
var statearr_39233_39271 = state_39230__$1;
(statearr_39233_39271[(2)] = null);

(statearr_39233_39271[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39231 === (4))){
var inst_39172 = (state_39230[(2)]);
var state_39230__$1 = state_39230;
var statearr_39234_39272 = state_39230__$1;
(statearr_39234_39272[(2)] = inst_39172);

(statearr_39234_39272[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39231 === (15))){
var inst_39211 = (state_39230[(2)]);
var state_39230__$1 = state_39230;
var statearr_39235_39273 = state_39230__$1;
(statearr_39235_39273[(2)] = inst_39211);

(statearr_39235_39273[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39231 === (13))){
var inst_39202 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var inst_39203 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39204 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_39205 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_39206 = [inst_39204,inst_39205];
var inst_39207 = (new cljs.core.PersistentVector(null,2,(5),inst_39203,inst_39206,null));
var inst_39208 = (function (){var G__39236 = inst_39202;
var G__39237 = new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117);
var G__39238 = inst_39207;
var G__39239 = data;
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(G__39236,G__39237,G__39238,G__39239) : fluree.db.conn_events.process_event.call(null,G__39236,G__39237,G__39238,G__39239));
})();
var state_39230__$1 = state_39230;
var statearr_39240_39274 = state_39230__$1;
(statearr_39240_39274[(2)] = inst_39208);

(statearr_39240_39274[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39231 === (6))){
var inst_39182 = (state_39230[(7)]);
var inst_39181 = (state_39230[(8)]);
var inst_39180 = (state_39230[(2)]);
var inst_39181__$1 = fluree.db.util.async.throw_err(inst_39180);
var inst_39182__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_39181__$1);
var inst_39183 = (block <= inst_39182__$1);
var state_39230__$1 = (function (){var statearr_39241 = state_39230;
(statearr_39241[(7)] = inst_39182__$1);

(statearr_39241[(8)] = inst_39181__$1);

return statearr_39241;
})();
if(cljs.core.truth_(inst_39183)){
var statearr_39242_39275 = state_39230__$1;
(statearr_39242_39275[(1)] = (7));

} else {
var statearr_39243_39276 = state_39230__$1;
(statearr_39243_39276[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39231 === (17))){
var state_39230__$1 = state_39230;
var statearr_39244_39277 = state_39230__$1;
(statearr_39244_39277[(2)] = null);

(statearr_39244_39277[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39231 === (3))){
var inst_39228 = (state_39230[(2)]);
var state_39230__$1 = state_39230;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39230__$1,inst_39228);
} else {
if((state_val_39231 === (12))){
var inst_39223 = (state_39230[(2)]);
var state_39230__$1 = state_39230;
var statearr_39245_39278 = state_39230__$1;
(statearr_39245_39278[(2)] = inst_39223);

(statearr_39245_39278[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39231 === (2))){
var inst_39178 = (state_39230[(9)]);
var _ = (function (){var statearr_39246 = state_39230;
(statearr_39246[(4)] = cljs.core.cons((5),(state_39230[(4)])));

return statearr_39246;
})();
var inst_39178__$1 = (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
var state_39230__$1 = (function (){var statearr_39247 = state_39230;
(statearr_39247[(9)] = inst_39178__$1);

return statearr_39247;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39230__$1,(6),inst_39178__$1);
} else {
if((state_val_39231 === (11))){
var state_39230__$1 = state_39230;
var statearr_39249_39279 = state_39230__$1;
(statearr_39249_39279[(1)] = (16));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39231 === (9))){
var inst_39225 = (state_39230[(2)]);
var _ = (function (){var statearr_39251 = state_39230;
(statearr_39251[(4)] = cljs.core.rest((state_39230[(4)])));

return statearr_39251;
})();
var state_39230__$1 = state_39230;
var statearr_39252_39280 = state_39230__$1;
(statearr_39252_39280[(2)] = inst_39225);

(statearr_39252_39280[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39231 === (5))){
var _ = (function (){var statearr_39253 = state_39230;
(statearr_39253[(4)] = cljs.core.rest((state_39230[(4)])));

return statearr_39253;
})();
var state_39230__$1 = state_39230;
var ex39248 = (state_39230__$1[(2)]);
var statearr_39254_39281 = state_39230__$1;
(statearr_39254_39281[(5)] = ex39248);


if((ex39248 instanceof Error)){
var statearr_39255_39282 = state_39230__$1;
(statearr_39255_39282[(1)] = (4));

(statearr_39255_39282[(5)] = null);

} else {
throw ex39248;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39231 === (14))){
var state_39230__$1 = state_39230;
var statearr_39256_39283 = state_39230__$1;
(statearr_39256_39283[(2)] = null);

(statearr_39256_39283[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39231 === (16))){
var inst_39182 = (state_39230[(7)]);
var inst_39214 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_39215 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_39216 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39214),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39215),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39182),". Forcing a db reload."].join('');
var inst_39217 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_39216], 0));
var inst_39218 = fluree.db.session.reload_db_BANG_(session);
var state_39230__$1 = (function (){var statearr_39257 = state_39230;
(statearr_39257[(10)] = inst_39217);

return statearr_39257;
})();
var statearr_39258_39284 = state_39230__$1;
(statearr_39258_39284[(2)] = inst_39218);

(statearr_39258_39284[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39231 === (10))){
var inst_39182 = (state_39230[(7)]);
var inst_39178 = (state_39230[(9)]);
var inst_39181 = (state_39230[(8)]);
var inst_39193 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_39194 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_39195 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39193),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39194),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_39196 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_39195], 0));
var inst_39197 = (function (){var current_db_ch = inst_39178;
var current_db = inst_39181;
var current_block = inst_39182;
return (function (p1__39169_SHARP_){
if((p1__39169_SHARP_ instanceof fluree.db.flake.Flake)){
return p1__39169_SHARP_;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(p1__39169_SHARP_);
}
});
})();
var inst_39198 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_39197,flakes);
var inst_39199 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_39181,block,inst_39198);
var inst_39200 = fluree.db.session.cas_db_BANG_(session,inst_39178,inst_39199);
var state_39230__$1 = (function (){var statearr_39259 = state_39230;
(statearr_39259[(11)] = inst_39196);

return statearr_39259;
})();
if(inst_39200){
var statearr_39260_39285 = state_39230__$1;
(statearr_39260_39285[(1)] = (13));

} else {
var statearr_39261_39286 = state_39230__$1;
(statearr_39261_39286[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39231 === (18))){
var inst_39221 = (state_39230[(2)]);
var state_39230__$1 = state_39230;
var statearr_39262_39287 = state_39230__$1;
(statearr_39262_39287[(2)] = inst_39221);

(statearr_39262_39287[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39231 === (8))){
var inst_39182 = (state_39230[(7)]);
var inst_39190 = ((1) + inst_39182);
var inst_39191 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_39190);
var state_39230__$1 = state_39230;
if(inst_39191){
var statearr_39263_39288 = state_39230__$1;
(statearr_39263_39288[(1)] = (10));

} else {
var statearr_39264_39289 = state_39230__$1;
(statearr_39264_39289[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__11410__auto__ = null;
var fluree$db$session$state_machine__11410__auto____0 = (function (){
var statearr_39265 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39265[(0)] = fluree$db$session$state_machine__11410__auto__);

(statearr_39265[(1)] = (1));

return statearr_39265;
});
var fluree$db$session$state_machine__11410__auto____1 = (function (state_39230){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_39230);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e39266){var ex__11413__auto__ = e39266;
var statearr_39267_39290 = state_39230;
(statearr_39267_39290[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_39230[(4)]))){
var statearr_39268_39291 = state_39230;
(statearr_39268_39291[(1)] = cljs.core.first((state_39230[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39292 = state_39230;
state_39230 = G__39292;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$session$state_machine__11410__auto__ = function(state_39230){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__11410__auto____1.call(this,state_39230);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__11410__auto____0;
fluree$db$session$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__11410__auto____1;
return fluree$db$session$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_39269 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_39269[(6)] = c__11484__auto__);

return statearr_39269;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_39299){
var state_val_39300 = (state_39299[(1)]);
if((state_val_39300 === (1))){
var inst_39293 = fluree.db.session.clear_db_BANG_(session);
var inst_39294 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_39295 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_39296 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39294),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39295)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_39297 = fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_39296], 0));
var state_39299__$1 = (function (){var statearr_39301 = state_39299;
(statearr_39301[(7)] = inst_39293);

(statearr_39301[(8)] = inst_39297);

return statearr_39301;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_39299__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__11410__auto__ = null;
var fluree$db$session$state_machine__11410__auto____0 = (function (){
var statearr_39302 = [null,null,null,null,null,null,null,null,null];
(statearr_39302[(0)] = fluree$db$session$state_machine__11410__auto__);

(statearr_39302[(1)] = (1));

return statearr_39302;
});
var fluree$db$session$state_machine__11410__auto____1 = (function (state_39299){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_39299);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e39303){var ex__11413__auto__ = e39303;
var statearr_39304_39307 = state_39299;
(statearr_39304_39307[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_39299[(4)]))){
var statearr_39305_39308 = state_39299;
(statearr_39305_39308[(1)] = cljs.core.first((state_39299[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39309 = state_39299;
state_39299 = G__39309;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$session$state_machine__11410__auto__ = function(state_39299){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__11410__auto____1.call(this,state_39299);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__11410__auto____0;
fluree$db$session$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__11410__auto____1;
return fluree$db$session$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_39306 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_39306[(6)] = c__11484__auto__);

return statearr_39306;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__39311 = arguments.length;
switch (G__39311) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (session){
var map__39312 = session;
var map__39312__$1 = cljs.core.__destructure_map(map__39312);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39312__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39312__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39312__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39312__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39312__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39312__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39312__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var closed_QMARK_ = fluree.db.session.closed_QMARK_(session);
if(cljs.core.truth_(closed_QMARK_)){
fluree.db.session.remove_cache_BANG_(network,dbid);

return false;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

var fexpr__39313_39316 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__39313_39316.cljs$core$IFn$_invoke$arity$3 ? fexpr__39313_39316.cljs$core$IFn$_invoke$arity$3(network,dbid,id) : fexpr__39313_39316.call(null,network,dbid,id));

cljs.core.async.close_BANG_(update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_(transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_(network,dbid);

if(cljs.core.fn_QMARK_(new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
var fexpr__39314_39317 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session);
(fexpr__39314_39317.cljs$core$IFn$_invoke$arity$0 ? fexpr__39314_39317.cljs$core$IFn$_invoke$arity$0() : fexpr__39314_39317.call(null));
} else {
}

return true;
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5751__auto__ = fluree.db.session.from_cache(network,dbid);
if(cljs.core.truth_(temp__5751__auto__)){
var session = temp__5751__auto__;
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_39370){
var state_val_39371 = (state_39370[(1)]);
if((state_val_39371 === (7))){
var inst_39366 = (state_39370[(2)]);
var state_39370__$1 = state_39370;
var statearr_39372_39403 = state_39370__$1;
(statearr_39372_39403[(2)] = inst_39366);

(statearr_39372_39403[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39371 === (1))){
var state_39370__$1 = state_39370;
var statearr_39373_39404 = state_39370__$1;
(statearr_39373_39404[(2)] = null);

(statearr_39373_39404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39371 === (4))){
var inst_39321 = (state_39370[(7)]);
var inst_39320 = (state_39370[(2)]);
var inst_39321__$1 = fluree.db.util.async.throw_err(inst_39320);
var inst_39322 = fluree.db.session.from_cache(network,ledger_id);
var inst_39323 = (inst_39321__$1 == null);
var state_39370__$1 = (function (){var statearr_39374 = state_39370;
(statearr_39374[(7)] = inst_39321__$1);

(statearr_39374[(8)] = inst_39322);

return statearr_39374;
})();
if(cljs.core.truth_(inst_39323)){
var statearr_39375_39405 = state_39370__$1;
(statearr_39375_39405[(1)] = (5));

} else {
var statearr_39376_39406 = state_39370__$1;
(statearr_39376_39406[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39371 === (15))){
var inst_39358 = (state_39370[(2)]);
var state_39370__$1 = (function (){var statearr_39377 = state_39370;
(statearr_39377[(9)] = inst_39358);

return statearr_39377;
})();
var statearr_39378_39407 = state_39370__$1;
(statearr_39378_39407[(2)] = null);

(statearr_39378_39407[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39371 === (13))){
var inst_39362 = (state_39370[(2)]);
var state_39370__$1 = state_39370;
var statearr_39380_39408 = state_39370__$1;
(statearr_39380_39408[(2)] = inst_39362);

(statearr_39380_39408[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39371 === (6))){
var inst_39322 = (state_39370[(8)]);
var inst_39328 = (inst_39322 == null);
var state_39370__$1 = state_39370;
if(cljs.core.truth_(inst_39328)){
var statearr_39381_39409 = state_39370__$1;
(statearr_39381_39409[(1)] = (8));

} else {
var statearr_39382_39410 = state_39370__$1;
(statearr_39382_39410[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39371 === (17))){
var _ = (function (){var statearr_39383 = state_39370;
(statearr_39383[(4)] = cljs.core.rest((state_39370[(4)])));

return statearr_39383;
})();
var state_39370__$1 = state_39370;
var ex39379 = (state_39370__$1[(2)]);
var statearr_39384_39411 = state_39370__$1;
(statearr_39384_39411[(5)] = ex39379);


var statearr_39385_39412 = state_39370__$1;
(statearr_39385_39412[(1)] = (16));

(statearr_39385_39412[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39371 === (3))){
var inst_39368 = (state_39370[(2)]);
var state_39370__$1 = state_39370;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39370__$1,inst_39368);
} else {
if((state_val_39371 === (12))){
var state_39370__$1 = state_39370;
var statearr_39386_39413 = state_39370__$1;
(statearr_39386_39413[(2)] = null);

(statearr_39386_39413[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39371 === (2))){
var state_39370__$1 = state_39370;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39370__$1,(4),update_chan);
} else {
if((state_val_39371 === (11))){
var state_39370__$1 = state_39370;
var statearr_39387_39414 = state_39370__$1;
(statearr_39387_39414[(2)] = null);

(statearr_39387_39414[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39371 === (9))){
var state_39370__$1 = state_39370;
var statearr_39388_39415 = state_39370__$1;
(statearr_39388_39415[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39371 === (5))){
var inst_39325 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_39326 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_39325], 0));
var state_39370__$1 = state_39370;
var statearr_39390_39416 = state_39370__$1;
(statearr_39390_39416[(2)] = inst_39326);

(statearr_39390_39416[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39371 === (14))){
var inst_39321 = (state_39370[(7)]);
var inst_39322 = (state_39370[(8)]);
var _ = (function (){var statearr_39391 = state_39370;
(statearr_39391[(4)] = cljs.core.cons((17),(state_39370[(4)])));

return statearr_39391;
})();
var inst_39346 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39321,(0),null);
var inst_39347 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39321,(1),null);
var inst_39348 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_39349 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_39321], 0));
var inst_39350 = fluree.db.util.core.trunc(inst_39349,(200));
var inst_39351 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_39348,inst_39350], 0));
var inst_39352 = (fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3 ? fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3(inst_39322,inst_39346,inst_39347) : fluree.db.session.process_ledger_update.call(null,inst_39322,inst_39346,inst_39347));
var state_39370__$1 = (function (){var statearr_39392 = state_39370;
(statearr_39392[(10)] = inst_39351);

return statearr_39392;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39370__$1,(18),inst_39352);
} else {
if((state_val_39371 === (16))){
var inst_39321 = (state_39370[(7)]);
var inst_39336 = (state_39370[(2)]);
var inst_39337 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_39336,"Exception processing ledger updates for message: ",inst_39321], 0));
var state_39370__$1 = state_39370;
var statearr_39393_39417 = state_39370__$1;
(statearr_39393_39417[(2)] = inst_39337);

(statearr_39393_39417[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39371 === (10))){
var inst_39364 = (state_39370[(2)]);
var state_39370__$1 = state_39370;
var statearr_39394_39418 = state_39370__$1;
(statearr_39394_39418[(2)] = inst_39364);

(statearr_39394_39418[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39371 === (18))){
var inst_39354 = (state_39370[(2)]);
var inst_39355 = fluree.db.util.async.throw_err(inst_39354);
var _ = (function (){var statearr_39395 = state_39370;
(statearr_39395[(4)] = cljs.core.rest((state_39370[(4)])));

return statearr_39395;
})();
var state_39370__$1 = state_39370;
var statearr_39396_39419 = state_39370__$1;
(statearr_39396_39419[(2)] = inst_39355);

(statearr_39396_39419[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39371 === (8))){
var inst_39321 = (state_39370[(7)]);
var inst_39330 = cljs.core.first(inst_39321);
var inst_39331 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_39330], 0));
var inst_39332 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_39331].join('');
var inst_39333 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_39332], 0));
var state_39370__$1 = state_39370;
var statearr_39397_39420 = state_39370__$1;
(statearr_39397_39420[(2)] = inst_39333);

(statearr_39397_39420[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__11410__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__11410__auto____0 = (function (){
var statearr_39398 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_39398[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__11410__auto__);

(statearr_39398[(1)] = (1));

return statearr_39398;
});
var fluree$db$session$process_ledger_updates_$_state_machine__11410__auto____1 = (function (state_39370){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_39370);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e39399){var ex__11413__auto__ = e39399;
var statearr_39400_39421 = state_39370;
(statearr_39400_39421[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_39370[(4)]))){
var statearr_39401_39422 = state_39370;
(statearr_39401_39422[(1)] = cljs.core.first((state_39370[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39423 = state_39370;
state_39370 = G__39423;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__11410__auto__ = function(state_39370){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__11410__auto____1.call(this,state_39370);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__11410__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__11410__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_39402 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_39402[(6)] = c__11484__auto__);

return statearr_39402;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Creates a connection without first checking if db exists. Only useful if reloading
 *   and replacing an existing DB.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__39424){
var map__39425 = p__39424;
var map__39425__$1 = cljs.core.__destructure_map(map__39425);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39425__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39425__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39425__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39425__$1,new cljs.core.Keyword(null,"db","db",993250759));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39425__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39425__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39425__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39425__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39425__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var update_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var transact_chan = (cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0():null);
var state__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","db","db/db",993247817),(cljs.core.truth_(db)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null),new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)], 0)));
var session = fluree.db.session.map__GT_DbSession(cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[dbid,update_chan,db_name,state__$1,close,id,schema_cache,transact_chan,network,null,conn]));
var current_db_fn = (function (){
return (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
});
var blank_db = fluree.db.graphdb.blank_db(conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__39429 = block_result;
var map__39429__$1 = cljs.core.__destructure_map(map__39429);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39429__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39429__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39429__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39429__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39429__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(txid));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_result], 0))], null))})());
var map__39430 = tx_result;
var map__39430__$1 = cljs.core.__destructure_map(map__39430);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39430__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39430__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first(flakes) instanceof fluree.db.flake.Flake))?(function (p1__39426_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,p1__39426_SHARP_.t);
}):(function (p1__39427_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__39427_SHARP_,(3)));
}));
var response = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(t_filter,flakes)], 0));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some((function (p1__39428_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((109),cljs.core.second(p1__39428_SHARP_))){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__39428_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__39431 = (cljs.core.truth_(error_msg)?cljs.core.re_find(/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39431,(0),null);
var status__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39431,(1),null);
var error = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39431,(2),null);
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39431,(3),null);
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4253__auto__ = message;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Create and cache session. Opt keys: ",cljs.core.keys(opts)], 0));
var id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2("session",cljs.core.subs.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid()),(0),(7)));
var session = fluree.db.session.session_factory(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_(session);
var new_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__39435 = arguments.length;
switch (G__39435) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__39436){
var map__39437 = p__39436;
var map__39437__$1 = cljs.core.__destructure_map(map__39437);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39437__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39437__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39437__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39437__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__39438 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39438,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39438,(1),null);
var ledger_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39438,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__4253__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var session = fluree.db.session.create_and_cache_session(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__4253__auto____$1 = state;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,opts);

var G__39442_39562 = network;
var G__39443_39563 = ledger_id;
var G__39444_39564 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session);
var G__39445_39565 = (function (event_type,event_data){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5753__auto__ = cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5753__auto__)){
var tx_callbacks = temp__5753__auto__;
var tids = cljs.core.keys(new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__39446 = cljs.core.seq(tids);
var chunk__39447 = null;
var count__39448 = (0);
var i__39449 = (0);
while(true){
if((i__39449 < count__39448)){
var tid = chunk__39447.cljs$core$IIndexed$_nth$arity$2(null,i__39449);
var temp__5753__auto___39567__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___39567__$1)){
var keyed_callbacks_39568 = temp__5753__auto___39567__$1;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_39569 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__39490_39570 = cljs.core.seq(keyed_callbacks_39568);
var chunk__39491_39571 = null;
var count__39492_39572 = (0);
var i__39493_39573 = (0);
while(true){
if((i__39493_39573 < count__39492_39572)){
var vec__39502_39574 = chunk__39491_39571.cljs$core$IIndexed$_nth$arity$2(null,i__39493_39573);
var k_39575 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39502_39574,(0),null);
var f_39576 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39502_39574,(1),null);
try{(f_39576.cljs$core$IFn$_invoke$arity$1 ? f_39576.cljs$core$IFn$_invoke$arity$1(tx_response_39569) : f_39576.call(null,tx_response_39569));
}catch (e39505){var e_39577 = e39505;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_39577,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__39578 = seq__39490_39570;
var G__39579 = chunk__39491_39571;
var G__39580 = count__39492_39572;
var G__39581 = (i__39493_39573 + (1));
seq__39490_39570 = G__39578;
chunk__39491_39571 = G__39579;
count__39492_39572 = G__39580;
i__39493_39573 = G__39581;
continue;
} else {
var temp__5753__auto___39582__$2 = cljs.core.seq(seq__39490_39570);
if(temp__5753__auto___39582__$2){
var seq__39490_39583__$1 = temp__5753__auto___39582__$2;
if(cljs.core.chunked_seq_QMARK_(seq__39490_39583__$1)){
var c__4679__auto___39584 = cljs.core.chunk_first(seq__39490_39583__$1);
var G__39585 = cljs.core.chunk_rest(seq__39490_39583__$1);
var G__39586 = c__4679__auto___39584;
var G__39587 = cljs.core.count(c__4679__auto___39584);
var G__39588 = (0);
seq__39490_39570 = G__39585;
chunk__39491_39571 = G__39586;
count__39492_39572 = G__39587;
i__39493_39573 = G__39588;
continue;
} else {
var vec__39506_39589 = cljs.core.first(seq__39490_39583__$1);
var k_39590 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39506_39589,(0),null);
var f_39591 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39506_39589,(1),null);
try{(f_39591.cljs$core$IFn$_invoke$arity$1 ? f_39591.cljs$core$IFn$_invoke$arity$1(tx_response_39569) : f_39591.call(null,tx_response_39569));
}catch (e39509){var e_39592 = e39509;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_39592,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__39593 = cljs.core.next(seq__39490_39583__$1);
var G__39594 = null;
var G__39595 = (0);
var G__39596 = (0);
seq__39490_39570 = G__39593;
chunk__39491_39571 = G__39594;
count__39492_39572 = G__39595;
i__39493_39573 = G__39596;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__39597 = seq__39446;
var G__39598 = chunk__39447;
var G__39599 = count__39448;
var G__39600 = (i__39449 + (1));
seq__39446 = G__39597;
chunk__39447 = G__39598;
count__39448 = G__39599;
i__39449 = G__39600;
continue;
} else {
var temp__5753__auto____$1 = cljs.core.seq(seq__39446);
if(temp__5753__auto____$1){
var seq__39446__$1 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__39446__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__39446__$1);
var G__39601 = cljs.core.chunk_rest(seq__39446__$1);
var G__39602 = c__4679__auto__;
var G__39603 = cljs.core.count(c__4679__auto__);
var G__39604 = (0);
seq__39446 = G__39601;
chunk__39447 = G__39602;
count__39448 = G__39603;
i__39449 = G__39604;
continue;
} else {
var tid = cljs.core.first(seq__39446__$1);
var temp__5753__auto___39605__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___39605__$2)){
var keyed_callbacks_39606 = temp__5753__auto___39605__$2;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_39607 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__39510_39608 = cljs.core.seq(keyed_callbacks_39606);
var chunk__39511_39609 = null;
var count__39512_39610 = (0);
var i__39513_39611 = (0);
while(true){
if((i__39513_39611 < count__39512_39610)){
var vec__39522_39612 = chunk__39511_39609.cljs$core$IIndexed$_nth$arity$2(null,i__39513_39611);
var k_39613 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39522_39612,(0),null);
var f_39614 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39522_39612,(1),null);
try{(f_39614.cljs$core$IFn$_invoke$arity$1 ? f_39614.cljs$core$IFn$_invoke$arity$1(tx_response_39607) : f_39614.call(null,tx_response_39607));
}catch (e39525){var e_39615 = e39525;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_39615,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__39616 = seq__39510_39608;
var G__39617 = chunk__39511_39609;
var G__39618 = count__39512_39610;
var G__39619 = (i__39513_39611 + (1));
seq__39510_39608 = G__39616;
chunk__39511_39609 = G__39617;
count__39512_39610 = G__39618;
i__39513_39611 = G__39619;
continue;
} else {
var temp__5753__auto___39620__$3 = cljs.core.seq(seq__39510_39608);
if(temp__5753__auto___39620__$3){
var seq__39510_39621__$1 = temp__5753__auto___39620__$3;
if(cljs.core.chunked_seq_QMARK_(seq__39510_39621__$1)){
var c__4679__auto___39622 = cljs.core.chunk_first(seq__39510_39621__$1);
var G__39623 = cljs.core.chunk_rest(seq__39510_39621__$1);
var G__39624 = c__4679__auto___39622;
var G__39625 = cljs.core.count(c__4679__auto___39622);
var G__39626 = (0);
seq__39510_39608 = G__39623;
chunk__39511_39609 = G__39624;
count__39512_39610 = G__39625;
i__39513_39611 = G__39626;
continue;
} else {
var vec__39526_39627 = cljs.core.first(seq__39510_39621__$1);
var k_39628 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39526_39627,(0),null);
var f_39629 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39526_39627,(1),null);
try{(f_39629.cljs$core$IFn$_invoke$arity$1 ? f_39629.cljs$core$IFn$_invoke$arity$1(tx_response_39607) : f_39629.call(null,tx_response_39607));
}catch (e39529){var e_39630 = e39529;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_39630,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__39631 = cljs.core.next(seq__39510_39621__$1);
var G__39632 = null;
var G__39633 = (0);
var G__39634 = (0);
seq__39510_39608 = G__39631;
chunk__39511_39609 = G__39632;
count__39512_39610 = G__39633;
i__39513_39611 = G__39634;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__39635 = cljs.core.next(seq__39446__$1);
var G__39636 = null;
var G__39637 = (0);
var G__39638 = (0);
seq__39446 = G__39635;
chunk__39447 = G__39636;
count__39448 = G__39637;
i__39449 = G__39638;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
});
var fexpr__39441_39566 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__39441_39566.cljs$core$IFn$_invoke$arity$4 ? fexpr__39441_39566.cljs$core$IFn$_invoke$arity$4(G__39442_39562,G__39443_39563,G__39444_39564,G__39445_39565) : fexpr__39441_39566.call(null,G__39442_39562,G__39443_39563,G__39444_39564,G__39445_39565));

fluree.db.session.process_ledger_updates(conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_39639 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__11484__auto___39640 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_39546){
var state_val_39547 = (state_39546[(1)]);
if((state_val_39547 === (1))){
var state_39546__$1 = state_39546;
var statearr_39548_39641 = state_39546__$1;
(statearr_39548_39641[(2)] = null);

(statearr_39548_39641[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39547 === (2))){
var inst_39531 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_39546__$1 = state_39546;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39546__$1,(4),inst_39531);
} else {
if((state_val_39547 === (3))){
var inst_39544 = (state_39546[(2)]);
var state_39546__$1 = state_39546;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39546__$1,inst_39544);
} else {
if((state_val_39547 === (4))){
var inst_39533 = (state_39546[(7)]);
var inst_39533__$1 = (state_39546[(2)]);
var inst_39534 = (inst_39533__$1 == null);
var state_39546__$1 = (function (){var statearr_39549 = state_39546;
(statearr_39549[(7)] = inst_39533__$1);

return statearr_39549;
})();
if(cljs.core.truth_(inst_39534)){
var statearr_39550_39642 = state_39546__$1;
(statearr_39550_39642[(1)] = (5));

} else {
var statearr_39551_39643 = state_39546__$1;
(statearr_39551_39643[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39547 === (5))){
var inst_39536 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_39537 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_39536], 0));
var state_39546__$1 = state_39546;
var statearr_39552_39644 = state_39546__$1;
(statearr_39552_39644[(2)] = inst_39537);

(statearr_39552_39644[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39547 === (6))){
var inst_39533 = (state_39546[(7)]);
var inst_39539 = (transact_handler_39639.cljs$core$IFn$_invoke$arity$2 ? transact_handler_39639.cljs$core$IFn$_invoke$arity$2(conn,inst_39533) : transact_handler_39639.call(null,conn,inst_39533));
var state_39546__$1 = (function (){var statearr_39553 = state_39546;
(statearr_39553[(8)] = inst_39539);

return statearr_39553;
})();
var statearr_39554_39645 = state_39546__$1;
(statearr_39554_39645[(2)] = null);

(statearr_39554_39645[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39547 === (7))){
var inst_39542 = (state_39546[(2)]);
var state_39546__$1 = state_39546;
var statearr_39555_39646 = state_39546__$1;
(statearr_39555_39646[(2)] = inst_39542);

(statearr_39555_39646[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__11410__auto__ = null;
var fluree$db$session$state_machine__11410__auto____0 = (function (){
var statearr_39556 = [null,null,null,null,null,null,null,null,null];
(statearr_39556[(0)] = fluree$db$session$state_machine__11410__auto__);

(statearr_39556[(1)] = (1));

return statearr_39556;
});
var fluree$db$session$state_machine__11410__auto____1 = (function (state_39546){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_39546);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e39557){var ex__11413__auto__ = e39557;
var statearr_39558_39647 = state_39546;
(statearr_39558_39647[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_39546[(4)]))){
var statearr_39559_39648 = state_39546;
(statearr_39559_39648[(1)] = cljs.core.first((state_39546[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39649 = state_39546;
state_39546 = G__39649;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$session$state_machine__11410__auto__ = function(state_39546){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__11410__auto____1.call(this,state_39546);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__11410__auto____0;
fluree$db$session$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__11410__auto____1;
return fluree$db$session$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_39560 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_39560[(6)] = c__11484__auto___39640);

return statearr_39560;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Gets the latest db from the central DB atom if available, or loads it from scratch.
 *   DB is returned as a core async promise channel.
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(p__39651){
var map__39652 = p__39651;
var map__39652__$1 = cljs.core.__destructure_map(map__39652);
var session = map__39652__$1;
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39652__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (p1__39650_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(p1__39650_SHARP_,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("req","count","req/count",2145574363),(new cljs.core.Keyword("req","count","req/count",2145574363).cljs$core$IFn$_invoke$arity$1(p1__39650_SHARP_) + (1))], 0));
}));

var or__4253__auto__ = new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(state));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var _ = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(session),cljs.core.empty);
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (st){
if(cljs.core.truth_(new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(st))){
return st;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(st,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db(session));
}
}));
return new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(new_state);
}
});
/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return fluree.db.session.current_db(session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__39655 = arguments.length;
switch (G__39655) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__39656 = cljs.core.vals(cljs.core.deref(fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__39653_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(conn_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__39653_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__39656);
} else {
return G__39656;
}
})();
var seq__39657 = cljs.core.seq(sessions);
var chunk__39658 = null;
var count__39659 = (0);
var i__39660 = (0);
while(true){
if((i__39660 < count__39659)){
var session = chunk__39658.cljs$core$IIndexed$_nth$arity$2(null,i__39660);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__39662 = seq__39657;
var G__39663 = chunk__39658;
var G__39664 = count__39659;
var G__39665 = (i__39660 + (1));
seq__39657 = G__39662;
chunk__39658 = G__39663;
count__39659 = G__39664;
i__39660 = G__39665;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__39657);
if(temp__5753__auto__){
var seq__39657__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__39657__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__39657__$1);
var G__39666 = cljs.core.chunk_rest(seq__39657__$1);
var G__39667 = c__4679__auto__;
var G__39668 = cljs.core.count(c__4679__auto__);
var G__39669 = (0);
seq__39657 = G__39666;
chunk__39658 = G__39667;
count__39659 = G__39668;
i__39660 = G__39669;
continue;
} else {
var session = cljs.core.first(seq__39657__$1);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__39670 = cljs.core.next(seq__39657__$1);
var G__39671 = null;
var G__39672 = (0);
var G__39673 = (0);
seq__39657 = G__39670;
chunk__39658 = G__39671;
count__39659 = G__39672;
i__39660 = G__39673;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.cljs$core$IFn$_invoke$arity$4(pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(updated,tid))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
