// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql.vswap_BANG_ = (function fluree$db$query$fql$vswap_BANG_(var_args){
var G__32911 = arguments.length;
switch (G__32911) {
case 2:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_(vol,(function (){var G__32912 = cljs.core._deref(vol);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__32912) : f.call(null,G__32912));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_(vol,(function (){var G__32913 = cljs.core._deref(vol);
var G__32914 = arg1;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__32913,G__32914) : f.call(null,G__32913,G__32914));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_(vol,(function (){var G__32915 = cljs.core._deref(vol);
var G__32916 = arg1;
var G__32917 = arg2;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__32915,G__32916,G__32917) : f.call(null,G__32915,G__32916,G__32917));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_(vol,(function (){var G__32918 = cljs.core._deref(vol);
var G__32919 = arg1;
var G__32920 = arg2;
var G__32921 = arg3;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__32918,G__32919,G__32920,G__32921) : f.call(null,G__32918,G__32919,G__32920,G__32921));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__32924 = arguments.length;
switch (G__32924) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__32926 = null;
var G__32926__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__32926__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__32926__2 = (function (result,flake){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__32926 = function(result,flake){
switch(arguments.length){
case 0:
return G__32926__0.call(this);
case 1:
return G__32926__1.call(this,result);
case 2:
return G__32926__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__32926.cljs$core$IFn$_invoke$arity$0 = G__32926__0;
G__32926.cljs$core$IFn$_invoke$arity$1 = G__32926__1;
G__32926.cljs$core$IFn$_invoke$arity$2 = G__32926__2;
return G__32926;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__32927 = null;
var G__32927__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__32927__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__32927__2 = (function (result,flakes){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,cljs.core.count(flakes));

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flakes) : xf.call(null,result,flakes));
});
G__32927 = function(result,flakes){
switch(arguments.length){
case 0:
return G__32927__0.call(this);
case 1:
return G__32927__1.call(this,result);
case 2:
return G__32927__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__32927.cljs$core$IFn$_invoke$arity$0 = G__32927__0;
G__32927.cljs$core$IFn$_invoke$arity$1 = G__32927__1;
G__32927.cljs$core$IFn$_invoke$arity$2 = G__32927__2;
return G__32927;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,n);

if(cljs.core.truth_((function (){var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4253__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map);

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__32929 = res;
var G__32929__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__32928_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__32928_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__32929):G__32929);
var G__32929__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__32929__$1):G__32929__$1);
var G__32929__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__32929__$2):G__32929__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__32929__$3);
} else {
return G__32929__$3;
}
} else {
return res;
}
});
/**
 * Adds a predicate to a select spec graph crawl. flakes input is a list of flakes
 *   all with the same subject and predicate values.
 */
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__32933 = arguments.length;
switch (G__32933) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_33372){
var state_val_33373 = (state_33372[(1)]);
if((state_val_33373 === (121))){
var inst_33295 = (state_33372[(2)]);
var inst_33296 = fluree.db.util.async.throw_err(inst_33295);
var inst_33297 = cljs.core.seq(inst_33296);
var state_33372__$1 = state_33372;
if(inst_33297){
var statearr_33374_33588 = state_33372__$1;
(statearr_33374_33588[(1)] = (122));

} else {
var statearr_33375_33589 = state_33372__$1;
(statearr_33375_33589[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (65))){
var inst_33088 = (state_33372[(7)]);
var inst_33087 = (state_33372[(2)]);
var inst_33088__$1 = fluree.db.util.async.throw_err(inst_33087);
var inst_33089 = cljs.core.seq(inst_33088__$1);
var state_33372__$1 = (function (){var statearr_33376 = state_33372;
(statearr_33376[(7)] = inst_33088__$1);

return statearr_33376;
})();
if(inst_33089){
var statearr_33377_33590 = state_33372__$1;
(statearr_33377_33590[(1)] = (66));

} else {
var statearr_33378_33591 = state_33372__$1;
(statearr_33378_33591[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (70))){
var inst_33088 = (state_33372[(7)]);
var inst_33099 = cljs.core.count(inst_33088);
var inst_33100 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_33099);
var state_33372__$1 = state_33372;
var statearr_33379_33592 = state_33372__$1;
(statearr_33379_33592[(2)] = inst_33100);

(statearr_33379_33592[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (62))){
var inst_33078 = (state_33372[(8)]);
var inst_33081 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33082 = inst_33078.o;
var inst_33083 = [inst_33082];
var inst_33084 = (new cljs.core.PersistentVector(null,1,(5),inst_33081,inst_33083,null));
var inst_33085 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_33084);
var state_33372__$1 = state_33372;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33372__$1,(65),inst_33085);
} else {
if((state_val_33373 === (74))){
var inst_33072 = (state_33372[(9)]);
var state_33372__$1 = state_33372;
var statearr_33380_33593 = state_33372__$1;
(statearr_33380_33593[(2)] = inst_33072);

(statearr_33380_33593[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (110))){
var inst_33257 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_33258 = new cljs.core.Keyword(null,"root?","root?",-2045639518).cljs$core$IFn$_invoke$arity$1(inst_33257);
var inst_33259 = inst_33258 === true;
var state_33372__$1 = state_33372;
if(cljs.core.truth_(inst_33259)){
var statearr_33381_33594 = state_33372__$1;
(statearr_33381_33594[(1)] = (113));

} else {
var statearr_33382_33595 = state_33372__$1;
(statearr_33382_33595[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (130))){
var inst_33367 = (state_33372[(2)]);
var _ = (function (){var statearr_33383 = state_33372;
(statearr_33383[(4)] = cljs.core.rest((state_33372[(4)])));

return statearr_33383;
})();
var state_33372__$1 = state_33372;
var statearr_33384_33596 = state_33372__$1;
(statearr_33384_33596[(2)] = inst_33367);

(statearr_33384_33596[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (128))){
var inst_33342 = (state_33372[(10)]);
var inst_33345 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33346 = [acc,inst_33342];
var inst_33347 = (new cljs.core.PersistentVector(null,2,(5),inst_33345,inst_33346,null));
var state_33372__$1 = state_33372;
var statearr_33385_33597 = state_33372__$1;
(statearr_33385_33597[(2)] = inst_33347);

(statearr_33385_33597[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (7))){
var inst_32945 = (state_33372[(11)]);
var state_33372__$1 = state_33372;
var statearr_33386_33598 = state_33372__$1;
(statearr_33386_33598[(2)] = inst_32945);

(statearr_33386_33598[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (59))){
var inst_33336 = (state_33372[(2)]);
var state_33372__$1 = state_33372;
var statearr_33387_33599 = state_33372__$1;
(statearr_33387_33599[(2)] = inst_33336);

(statearr_33387_33599[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (86))){
var inst_33166 = (state_33372[(12)]);
var inst_33166__$1 = (state_33372[(2)]);
var state_33372__$1 = (function (){var statearr_33388 = state_33372;
(statearr_33388[(12)] = inst_33166__$1);

return statearr_33388;
})();
if(cljs.core.truth_(inst_33166__$1)){
var statearr_33389_33600 = state_33372__$1;
(statearr_33389_33600[(1)] = (88));

} else {
var statearr_33390_33601 = state_33372__$1;
(statearr_33390_33601[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (20))){
var inst_32986 = (state_33372[(13)]);
var inst_32987 = (state_33372[(14)]);
var inst_32974 = (state_33372[(15)]);
var inst_32985 = (state_33372[(2)]);
var inst_32986__$1 = cljs.core.__destructure_map(inst_32974);
var inst_32987__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32986__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_32988 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32986__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_32989 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32986__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_32990 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32986__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_32991 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32986__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_32992 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32986__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_33372__$1 = (function (){var statearr_33391 = state_33372;
(statearr_33391[(13)] = inst_32986__$1);

(statearr_33391[(16)] = inst_32989);

(statearr_33391[(14)] = inst_32987__$1);

(statearr_33391[(17)] = inst_32991);

(statearr_33391[(18)] = inst_32992);

(statearr_33391[(19)] = inst_32988);

(statearr_33391[(20)] = inst_32985);

(statearr_33391[(21)] = inst_32990);

return statearr_33391;
})();
if(cljs.core.truth_(inst_32987__$1)){
var statearr_33392_33602 = state_33372__$1;
(statearr_33392_33602[(1)] = (24));

} else {
var statearr_33393_33603 = state_33372__$1;
(statearr_33393_33603[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (72))){
var inst_33097 = (state_33372[(22)]);
var inst_33103 = (state_33372[(2)]);
var inst_33104 = cljs.core.seq(inst_33097);
var state_33372__$1 = (function (){var statearr_33394 = state_33372;
(statearr_33394[(23)] = inst_33103);

return statearr_33394;
})();
if(inst_33104){
var statearr_33395_33604 = state_33372__$1;
(statearr_33395_33604[(1)] = (73));

} else {
var statearr_33396_33605 = state_33372__$1;
(statearr_33396_33605[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (58))){
var inst_32974 = (state_33372[(15)]);
var inst_33119 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_32974);
var state_33372__$1 = state_33372;
if(cljs.core.truth_(inst_33119)){
var statearr_33397_33606 = state_33372__$1;
(statearr_33397_33606[(1)] = (76));

} else {
var statearr_33398_33607 = state_33372__$1;
(statearr_33398_33607[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (60))){
var inst_33071 = (state_33372[(24)]);
var inst_33078 = (state_33372[(8)]);
var inst_33077 = cljs.core.seq(inst_33071);
var inst_33078__$1 = cljs.core.first(inst_33077);
var inst_33079 = cljs.core.next(inst_33077);
var state_33372__$1 = (function (){var statearr_33399 = state_33372;
(statearr_33399[(8)] = inst_33078__$1);

(statearr_33399[(25)] = inst_33079);

return statearr_33399;
})();
if(cljs.core.truth_(inst_33078__$1)){
var statearr_33400_33608 = state_33372__$1;
(statearr_33400_33608[(1)] = (62));

} else {
var statearr_33401_33609 = state_33372__$1;
(statearr_33401_33609[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (27))){
var inst_32995 = (state_33372[(26)]);
var inst_32991 = (state_33372[(17)]);
var inst_32995__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_32991);
var state_33372__$1 = (function (){var statearr_33402 = state_33372;
(statearr_33402[(26)] = inst_32995__$1);

return statearr_33402;
})();
if(inst_32995__$1){
var statearr_33403_33610 = state_33372__$1;
(statearr_33403_33610[(1)] = (30));

} else {
var statearr_33404_33611 = state_33372__$1;
(statearr_33404_33611[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (1))){
var state_33372__$1 = state_33372;
var statearr_33405_33612 = state_33372__$1;
(statearr_33405_33612[(2)] = null);

(statearr_33405_33612[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (69))){
var inst_33093 = (state_33372[(2)]);
var inst_33094 = fluree.db.util.async.throw_err(inst_33093);
var state_33372__$1 = state_33372;
var statearr_33406_33613 = state_33372__$1;
(statearr_33406_33613[(2)] = inst_33094);

(statearr_33406_33613[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (101))){
var inst_33250 = (state_33372[(2)]);
var state_33372__$1 = state_33372;
var statearr_33407_33614 = state_33372__$1;
(statearr_33407_33614[(2)] = inst_33250);

(statearr_33407_33614[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (24))){
var inst_32991 = (state_33372[(17)]);
var state_33372__$1 = state_33372;
if(cljs.core.truth_(inst_32991)){
var statearr_33408_33615 = state_33372__$1;
(statearr_33408_33615[(1)] = (27));

} else {
var statearr_33409_33616 = state_33372__$1;
(statearr_33409_33616[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (102))){
var inst_33222 = (state_33372[(27)]);
var inst_33221 = (state_33372[(2)]);
var inst_33222__$1 = fluree.db.util.async.throw_err(inst_33221);
var inst_33223 = cljs.core.empty_QMARK_(inst_33222__$1);
var state_33372__$1 = (function (){var statearr_33410 = state_33372;
(statearr_33410[(27)] = inst_33222__$1);

return statearr_33410;
})();
if(inst_33223){
var statearr_33411_33617 = state_33372__$1;
(statearr_33411_33617[(1)] = (103));

} else {
var statearr_33412_33618 = state_33372__$1;
(statearr_33412_33618[(1)] = (104));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (135))){
var state_33372__$1 = state_33372;
var statearr_33413_33619 = state_33372__$1;
(statearr_33413_33619[(2)] = null);

(statearr_33413_33619[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (55))){
var inst_32974 = (state_33372[(15)]);
var inst_33047 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_32974);
var state_33372__$1 = state_33372;
var statearr_33414_33620 = state_33372__$1;
(statearr_33414_33620[(2)] = inst_33047);

(statearr_33414_33620[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (85))){
var inst_33141 = (state_33372[(28)]);
var inst_32974 = (state_33372[(15)]);
var inst_33153 = inst_33141.o;
var inst_33154 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_32974);
var inst_33155 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_33153,inst_33154);
var state_33372__$1 = state_33372;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33372__$1,(87),inst_33155);
} else {
if((state_val_33373 === (39))){
var inst_33022 = (state_33372[(29)]);
var inst_32990 = (state_33372[(21)]);
var inst_33022__$1 = cljs.core.not(inst_32990);
var state_33372__$1 = (function (){var statearr_33415 = state_33372;
(statearr_33415[(29)] = inst_33022__$1);

return statearr_33415;
})();
if(inst_33022__$1){
var statearr_33416_33621 = state_33372__$1;
(statearr_33416_33621[(1)] = (42));

} else {
var statearr_33417_33622 = state_33372__$1;
(statearr_33417_33622[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (88))){
var inst_33166 = (state_33372[(12)]);
var inst_33135 = (state_33372[(30)]);
var inst_33168 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_33135,inst_33166);
var state_33372__$1 = state_33372;
var statearr_33418_33623 = state_33372__$1;
(statearr_33418_33623[(2)] = inst_33168);

(statearr_33418_33623[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (46))){
var inst_32989 = (state_33372[(16)]);
var state_33372__$1 = state_33372;
var statearr_33419_33624 = state_33372__$1;
(statearr_33419_33624[(2)] = inst_32989);

(statearr_33419_33624[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (4))){
var inst_32934 = (state_33372[(2)]);
var state_33372__$1 = state_33372;
var statearr_33420_33625 = state_33372__$1;
(statearr_33420_33625[(2)] = inst_32934);

(statearr_33420_33625[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (77))){
var inst_33181 = (state_33372[(31)]);
var inst_33181__$1 = componentFollow_QMARK_;
var state_33372__$1 = (function (){var statearr_33421 = state_33372;
(statearr_33421[(31)] = inst_33181__$1);

return statearr_33421;
})();
if(cljs.core.truth_(inst_33181__$1)){
var statearr_33422_33626 = state_33372__$1;
(statearr_33422_33626[(1)] = (91));

} else {
var statearr_33423_33627 = state_33372__$1;
(statearr_33423_33627[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (106))){
var inst_33202 = (state_33372[(32)]);
var inst_33236 = (state_33372[(2)]);
var inst_33237 = fluree.db.util.async.throw_err(inst_33236);
var inst_33238 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_33202,inst_33237);
var state_33372__$1 = state_33372;
var statearr_33424_33628 = state_33372__$1;
(statearr_33424_33628[(2)] = inst_33238);

(statearr_33424_33628[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (119))){
var inst_33280 = (state_33372[(33)]);
var inst_33310 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33311 = [inst_33280,offset_map];
var inst_33312 = (new cljs.core.PersistentVector(null,2,(5),inst_33310,inst_33311,null));
var state_33372__$1 = state_33372;
var statearr_33425_33629 = state_33372__$1;
(statearr_33425_33629[(2)] = inst_33312);

(statearr_33425_33629[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (95))){
var inst_32988 = (state_33372[(19)]);
var state_33372__$1 = state_33372;
if(cljs.core.truth_(inst_32988)){
var statearr_33426_33630 = state_33372__$1;
(statearr_33426_33630[(1)] = (110));

} else {
var statearr_33427_33631 = state_33372__$1;
(statearr_33427_33631[(1)] = (111));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (54))){
var inst_33044 = (state_33372[(34)]);
var state_33372__$1 = state_33372;
var statearr_33428_33632 = state_33372__$1;
(statearr_33428_33632[(2)] = inst_33044);

(statearr_33428_33632[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (92))){
var inst_33181 = (state_33372[(31)]);
var state_33372__$1 = state_33372;
var statearr_33429_33633 = state_33372__$1;
(statearr_33429_33633[(2)] = inst_33181);

(statearr_33429_33633[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (104))){
var inst_32944 = (state_33372[(35)]);
var inst_33222 = (state_33372[(27)]);
var inst_33231 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298)];
var inst_33232 = [true,inst_32944];
var inst_33233 = cljs.core.PersistentHashMap.fromArrays(inst_33231,inst_33232);
var inst_33234 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_33233,inst_33222) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_33233,inst_33222));
var state_33372__$1 = state_33372;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33372__$1,(106),inst_33234);
} else {
if((state_val_33373 === (15))){
var inst_32967 = (state_33372[(36)]);
var inst_32944 = (state_33372[(35)]);
var inst_32971 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_32967,new cljs.core.Keyword(null,"compact?","compact?",1216893298),inst_32944);
var state_33372__$1 = state_33372;
var statearr_33430_33634 = state_33372__$1;
(statearr_33430_33634[(2)] = inst_32971);

(statearr_33430_33634[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (48))){
var inst_33038 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33039 = [null,offset_map];
var inst_33040 = (new cljs.core.PersistentVector(null,2,(5),inst_33038,inst_33039,null));
var state_33372__$1 = state_33372;
var statearr_33431_33635 = state_33372__$1;
(statearr_33431_33635[(2)] = inst_33040);

(statearr_33431_33635[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (50))){
var inst_33338 = (state_33372[(2)]);
var state_33372__$1 = state_33372;
var statearr_33432_33636 = state_33372__$1;
(statearr_33432_33636[(2)] = inst_33338);

(statearr_33432_33636[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (116))){
var inst_33286 = (state_33372[(37)]);
var inst_33279 = (state_33372[(38)]);
var inst_33285 = cljs.core.seq(inst_33279);
var inst_33286__$1 = cljs.core.first(inst_33285);
var inst_33287 = cljs.core.next(inst_33285);
var state_33372__$1 = (function (){var statearr_33433 = state_33372;
(statearr_33433[(39)] = inst_33287);

(statearr_33433[(37)] = inst_33286__$1);

return statearr_33433;
})();
if(cljs.core.truth_(inst_33286__$1)){
var statearr_33434_33637 = state_33372__$1;
(statearr_33434_33637[(1)] = (118));

} else {
var statearr_33435_33638 = state_33372__$1;
(statearr_33435_33638[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (75))){
var inst_33079 = (state_33372[(25)]);
var inst_33109 = (state_33372[(2)]);
var inst_33071 = inst_33079;
var inst_33072 = inst_33109;
var state_33372__$1 = (function (){var statearr_33436 = state_33372;
(statearr_33436[(24)] = inst_33071);

(statearr_33436[(9)] = inst_33072);

return statearr_33436;
})();
var statearr_33437_33639 = state_33372__$1;
(statearr_33437_33639[(2)] = null);

(statearr_33437_33639[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (99))){
var inst_33208 = (state_33372[(40)]);
var inst_32974 = (state_33372[(15)]);
var inst_33211 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33212 = inst_33208.o;
var inst_33213 = [inst_33212];
var inst_33214 = (new cljs.core.PersistentVector(null,1,(5),inst_33211,inst_33213,null));
var inst_33215 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_33216 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_32974);
var inst_33217 = [inst_33216];
var inst_33218 = cljs.core.PersistentHashMap.fromArrays(inst_33215,inst_33217);
var inst_33219 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_33214,inst_33218);
var state_33372__$1 = state_33372;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33372__$1,(102),inst_33219);
} else {
if((state_val_33373 === (21))){
var inst_32978 = (state_33372[(41)]);
var state_33372__$1 = state_33372;
var statearr_33438_33640 = state_33372__$1;
(statearr_33438_33640[(2)] = inst_32978);

(statearr_33438_33640[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (31))){
var inst_32995 = (state_33372[(26)]);
var state_33372__$1 = state_33372;
var statearr_33439_33641 = state_33372__$1;
(statearr_33439_33641[(2)] = inst_32995);

(statearr_33439_33641[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (113))){
var inst_32986 = (state_33372[(13)]);
var inst_32989 = (state_33372[(16)]);
var inst_32987 = (state_33372[(14)]);
var inst_32959 = (state_33372[(42)]);
var inst_32991 = (state_33372[(17)]);
var inst_32944 = (state_33372[(35)]);
var inst_32992 = (state_33372[(18)]);
var inst_32988 = (state_33372[(19)]);
var inst_32985 = (state_33372[(20)]);
var inst_32974 = (state_33372[(15)]);
var inst_32990 = (state_33372[(21)]);
var inst_33261 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33262 = (function (){var p = inst_32992;
var pred_spec__$1 = inst_32959;
var orderBy = inst_32990;
var map__32940 = inst_32986;
var multi_QMARK_ = inst_32987;
var limit = inst_32989;
var offset = inst_32991;
var k = inst_32985;
var compact_QMARK_ = inst_32944;
var pred_spec_SINGLEQUOTE_ = inst_32974;
var ref_QMARK_ = inst_32988;
return (function (p1__32930_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"_id","_id",-789960287)],[p1__32930_SHARP_.o]);
});
})();
var inst_33263 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_33262,flakes);
var inst_33264 = [inst_33263,offset_map];
var inst_33265 = (new cljs.core.PersistentVector(null,2,(5),inst_33261,inst_33264,null));
var state_33372__$1 = state_33372;
var statearr_33440_33642 = state_33372__$1;
(statearr_33440_33642[(2)] = inst_33265);

(statearr_33440_33642[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (32))){
var inst_33001 = (state_33372[(2)]);
var state_33372__$1 = state_33372;
var statearr_33441_33643 = state_33372__$1;
(statearr_33441_33643[(2)] = inst_33001);

(statearr_33441_33643[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (136))){
var inst_33363 = (state_33372[(2)]);
var state_33372__$1 = state_33372;
var statearr_33442_33644 = state_33372__$1;
(statearr_33442_33644[(2)] = inst_33363);

(statearr_33442_33644[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (40))){
var inst_32987 = (state_33372[(14)]);
var state_33372__$1 = state_33372;
var statearr_33443_33645 = state_33372__$1;
(statearr_33443_33645[(2)] = inst_32987);

(statearr_33443_33645[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (129))){
var inst_32987 = (state_33372[(14)]);
var state_33372__$1 = state_33372;
if(cljs.core.truth_(inst_32987)){
var statearr_33444_33646 = state_33372__$1;
(statearr_33444_33646[(1)] = (131));

} else {
var statearr_33445_33647 = state_33372__$1;
(statearr_33445_33647[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (91))){
var inst_32974 = (state_33372[(15)]);
var inst_33183 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_32974);
var state_33372__$1 = state_33372;
var statearr_33446_33648 = state_33372__$1;
(statearr_33446_33648[(2)] = inst_33183);

(statearr_33446_33648[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (117))){
var inst_33316 = (state_33372[(2)]);
var state_33372__$1 = state_33372;
var statearr_33447_33649 = state_33372__$1;
(statearr_33447_33649[(2)] = inst_33316);

(statearr_33447_33649[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (108))){
var state_33372__$1 = state_33372;
var statearr_33448_33650 = state_33372__$1;
(statearr_33448_33650[(2)] = null);

(statearr_33448_33650[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (56))){
var inst_33049 = (state_33372[(2)]);
var state_33372__$1 = state_33372;
var statearr_33449_33651 = state_33372__$1;
(statearr_33449_33651[(2)] = inst_33049);

(statearr_33449_33651[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (33))){
var inst_32992 = (state_33372[(18)]);
var inst_33009 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33010 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_32992);
var state_33372__$1 = (function (){var statearr_33450 = state_33372;
(statearr_33450[(43)] = inst_33009);

return statearr_33450;
})();
if(cljs.core.truth_(inst_33010)){
var statearr_33451_33652 = state_33372__$1;
(statearr_33451_33652[(1)] = (36));

} else {
var statearr_33452_33653 = state_33372__$1;
(statearr_33452_33653[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (13))){
var inst_32959 = (state_33372[(42)]);
var state_33372__$1 = state_33372;
var statearr_33453_33654 = state_33372__$1;
(statearr_33453_33654[(2)] = inst_32959);

(statearr_33453_33654[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (22))){
var inst_32974 = (state_33372[(15)]);
var inst_32981 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_32974);
var state_33372__$1 = state_33372;
var statearr_33454_33655 = state_33372__$1;
(statearr_33454_33655[(2)] = inst_32981);

(statearr_33454_33655[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (90))){
var inst_33142 = (state_33372[(44)]);
var inst_33171 = (state_33372[(2)]);
var inst_33134 = inst_33142;
var inst_33135 = inst_33171;
var state_33372__$1 = (function (){var statearr_33455 = state_33372;
(statearr_33455[(45)] = inst_33134);

(statearr_33455[(30)] = inst_33135);

return statearr_33455;
})();
var statearr_33456_33656 = state_33372__$1;
(statearr_33456_33656[(2)] = null);

(statearr_33456_33656[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (109))){
var inst_33240 = (state_33372[(46)]);
var inst_33209 = (state_33372[(47)]);
var inst_33246 = (state_33372[(2)]);
var inst_33201 = inst_33209;
var inst_33202 = inst_33240;
var state_33372__$1 = (function (){var statearr_33457 = state_33372;
(statearr_33457[(48)] = inst_33201);

(statearr_33457[(49)] = inst_33246);

(statearr_33457[(32)] = inst_33202);

return statearr_33457;
})();
var statearr_33458_33657 = state_33372__$1;
(statearr_33458_33657[(2)] = null);

(statearr_33458_33657[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (36))){
var inst_32992 = (state_33372[(18)]);
var inst_33012 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_32992,cljs.core.dec);
var state_33372__$1 = state_33372;
var statearr_33459_33658 = state_33372__$1;
(statearr_33459_33658[(2)] = inst_33012);

(statearr_33459_33658[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (41))){
var inst_33036 = (state_33372[(2)]);
var state_33372__$1 = state_33372;
if(cljs.core.truth_(inst_33036)){
var statearr_33460_33659 = state_33372__$1;
(statearr_33460_33659[(1)] = (48));

} else {
var statearr_33461_33660 = state_33372__$1;
(statearr_33461_33660[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (118))){
var inst_33286 = (state_33372[(37)]);
var inst_33289 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33290 = inst_33286.o;
var inst_33291 = [inst_33290];
var inst_33292 = (new cljs.core.PersistentVector(null,1,(5),inst_33289,inst_33291,null));
var inst_33293 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_33292);
var state_33372__$1 = state_33372;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33372__$1,(121),inst_33293);
} else {
if((state_val_33373 === (89))){
var inst_33135 = (state_33372[(30)]);
var state_33372__$1 = state_33372;
var statearr_33462_33661 = state_33372__$1;
(statearr_33462_33661[(2)] = inst_33135);

(statearr_33462_33661[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (100))){
var inst_33202 = (state_33372[(32)]);
var state_33372__$1 = state_33372;
var statearr_33463_33662 = state_33372__$1;
(statearr_33463_33662[(2)] = inst_33202);

(statearr_33463_33662[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (131))){
var inst_33342 = (state_33372[(10)]);
var inst_33341 = (state_33372[(50)]);
var inst_32985 = (state_33372[(20)]);
var inst_33350 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33351 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_32985,inst_33341);
var inst_33352 = [inst_33351,inst_33342];
var inst_33353 = (new cljs.core.PersistentVector(null,2,(5),inst_33350,inst_33352,null));
var state_33372__$1 = state_33372;
var statearr_33464_33663 = state_33372__$1;
(statearr_33464_33663[(2)] = inst_33353);

(statearr_33464_33663[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (122))){
var inst_33280 = (state_33372[(33)]);
var inst_33287 = (state_33372[(39)]);
var inst_33286 = (state_33372[(37)]);
var inst_33299 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_33300 = inst_33286.o;
var inst_33301 = [inst_33300];
var inst_33302 = cljs.core.PersistentHashMap.fromArrays(inst_33299,inst_33301);
var inst_33303 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_33280,inst_33302);
var inst_33279 = inst_33287;
var inst_33280__$1 = inst_33303;
var state_33372__$1 = (function (){var statearr_33465 = state_33372;
(statearr_33465[(33)] = inst_33280__$1);

(statearr_33465[(38)] = inst_33279);

return statearr_33465;
})();
var statearr_33466_33664 = state_33372__$1;
(statearr_33466_33664[(2)] = null);

(statearr_33466_33664[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (43))){
var inst_33022 = (state_33372[(29)]);
var state_33372__$1 = state_33372;
var statearr_33467_33665 = state_33372__$1;
(statearr_33467_33665[(2)] = inst_33022);

(statearr_33467_33665[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (61))){
var inst_33058 = (state_33372[(51)]);
var inst_33115 = (state_33372[(2)]);
var inst_33116 = [inst_33115,offset_map];
var inst_33117 = (new cljs.core.PersistentVector(null,2,(5),inst_33058,inst_33116,null));
var state_33372__$1 = state_33372;
var statearr_33468_33666 = state_33372__$1;
(statearr_33468_33666[(2)] = inst_33117);

(statearr_33468_33666[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (29))){
var inst_33004 = (state_33372[(2)]);
var state_33372__$1 = state_33372;
var statearr_33469_33667 = state_33372__$1;
(statearr_33469_33667[(2)] = inst_33004);

(statearr_33469_33667[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (44))){
var inst_33033 = (state_33372[(2)]);
var state_33372__$1 = state_33372;
var statearr_33470_33668 = state_33372__$1;
(statearr_33470_33668[(2)] = inst_33033);

(statearr_33470_33668[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (93))){
var inst_33186 = (state_33372[(2)]);
var state_33372__$1 = state_33372;
if(cljs.core.truth_(inst_33186)){
var statearr_33471_33669 = state_33372__$1;
(statearr_33471_33669[(1)] = (94));

} else {
var statearr_33472_33670 = state_33372__$1;
(statearr_33472_33670[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (6))){
var inst_32947 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_32948 = (inst_32947 == null);
var state_33372__$1 = state_33372;
var statearr_33473_33671 = state_33372__$1;
(statearr_33473_33671[(2)] = inst_32948);

(statearr_33473_33671[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (111))){
var state_33372__$1 = state_33372;
var statearr_33474_33672 = state_33372__$1;
(statearr_33474_33672[(1)] = (125));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (28))){
var inst_32991 = (state_33372[(17)]);
var state_33372__$1 = state_33372;
var statearr_33476_33673 = state_33372__$1;
(statearr_33476_33673[(2)] = inst_32991);

(statearr_33476_33673[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (134))){
var inst_33342 = (state_33372[(10)]);
var inst_33341 = (state_33372[(50)]);
var inst_32985 = (state_33372[(20)]);
var inst_33356 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33357 = cljs.core.first(inst_33341);
var inst_33358 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_32985,inst_33357);
var inst_33359 = [inst_33358,inst_33342];
var inst_33360 = (new cljs.core.PersistentVector(null,2,(5),inst_33356,inst_33359,null));
var state_33372__$1 = state_33372;
var statearr_33477_33674 = state_33372__$1;
(statearr_33477_33674[(2)] = inst_33360);

(statearr_33477_33674[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (64))){
var inst_33113 = (state_33372[(2)]);
var state_33372__$1 = state_33372;
var statearr_33478_33675 = state_33372__$1;
(statearr_33478_33675[(2)] = inst_33113);

(statearr_33478_33675[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (103))){
var inst_33202 = (state_33372[(32)]);
var inst_33208 = (state_33372[(40)]);
var inst_33225 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_33226 = inst_33208.o;
var inst_33227 = [inst_33226];
var inst_33228 = cljs.core.PersistentHashMap.fromArrays(inst_33225,inst_33227);
var inst_33229 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_33202,inst_33228);
var state_33372__$1 = state_33372;
var statearr_33479_33676 = state_33372__$1;
(statearr_33479_33676[(2)] = inst_33229);

(statearr_33479_33676[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (51))){
var inst_33044 = (state_33372[(34)]);
var inst_32974 = (state_33372[(15)]);
var inst_33044__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_32974);
var state_33372__$1 = (function (){var statearr_33480 = state_33372;
(statearr_33480[(34)] = inst_33044__$1);

return statearr_33480;
})();
if(cljs.core.truth_(inst_33044__$1)){
var statearr_33481_33677 = state_33372__$1;
(statearr_33481_33677[(1)] = (54));

} else {
var statearr_33482_33678 = state_33372__$1;
(statearr_33482_33678[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (25))){
var inst_32987 = (state_33372[(14)]);
var state_33372__$1 = state_33372;
var statearr_33483_33679 = state_33372__$1;
(statearr_33483_33679[(2)] = inst_32987);

(statearr_33483_33679[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (34))){
var inst_32987 = (state_33372[(14)]);
var state_33372__$1 = state_33372;
if(cljs.core.truth_(inst_32987)){
var statearr_33484_33680 = state_33372__$1;
(statearr_33484_33680[(1)] = (39));

} else {
var statearr_33485_33681 = state_33372__$1;
(statearr_33485_33681[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (125))){
var inst_32986 = (state_33372[(13)]);
var inst_32989 = (state_33372[(16)]);
var inst_32987 = (state_33372[(14)]);
var inst_32959 = (state_33372[(42)]);
var inst_32991 = (state_33372[(17)]);
var inst_32944 = (state_33372[(35)]);
var inst_32992 = (state_33372[(18)]);
var inst_32988 = (state_33372[(19)]);
var inst_32985 = (state_33372[(20)]);
var inst_32974 = (state_33372[(15)]);
var inst_32990 = (state_33372[(21)]);
var inst_33321 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33322 = (function (){var p = inst_32992;
var pred_spec__$1 = inst_32959;
var orderBy = inst_32990;
var map__32940 = inst_32986;
var multi_QMARK_ = inst_32987;
var limit = inst_32989;
var offset = inst_32991;
var k = inst_32985;
var compact_QMARK_ = inst_32944;
var pred_spec_SINGLEQUOTE_ = inst_32974;
var ref_QMARK_ = inst_32988;
return (function (p1__32931_SHARP_){
return p1__32931_SHARP_.o;
});
})();
var inst_33323 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_33322,flakes);
var inst_33324 = [inst_33323,offset_map];
var inst_33325 = (new cljs.core.PersistentVector(null,2,(5),inst_33321,inst_33324,null));
var state_33372__$1 = state_33372;
var statearr_33486_33682 = state_33372__$1;
(statearr_33486_33682[(2)] = inst_33325);

(statearr_33486_33682[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (17))){
var inst_32975 = (state_33372[(52)]);
var inst_32974 = (state_33372[(15)]);
var inst_32974__$1 = (state_33372[(2)]);
var inst_32975__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_32974__$1);
var state_33372__$1 = (function (){var statearr_33487 = state_33372;
(statearr_33487[(52)] = inst_32975__$1);

(statearr_33487[(15)] = inst_32974__$1);

return statearr_33487;
})();
if(cljs.core.truth_(inst_32975__$1)){
var statearr_33488_33683 = state_33372__$1;
(statearr_33488_33683[(1)] = (18));

} else {
var statearr_33489_33684 = state_33372__$1;
(statearr_33489_33684[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (3))){
var inst_33370 = (state_33372[(2)]);
var state_33372__$1 = state_33372;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33372__$1,inst_33370);
} else {
if((state_val_33373 === (12))){
var inst_32959 = (state_33372[(42)]);
var inst_32964 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_32959,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_33372__$1 = state_33372;
var statearr_33490_33685 = state_33372__$1;
(statearr_33490_33685[(2)] = inst_32964);

(statearr_33490_33685[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (2))){
var inst_32945 = (state_33372[(11)]);
var _ = (function (){var statearr_33491 = state_33372;
(statearr_33491[(4)] = cljs.core.cons((5),(state_33372[(4)])));

return statearr_33491;
})();
var inst_32944 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_32945__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_33372__$1 = (function (){var statearr_33492 = state_33372;
(statearr_33492[(35)] = inst_32944);

(statearr_33492[(11)] = inst_32945__$1);

return statearr_33492;
})();
if(cljs.core.truth_(inst_32945__$1)){
var statearr_33493_33686 = state_33372__$1;
(statearr_33493_33686[(1)] = (6));

} else {
var statearr_33494_33687 = state_33372__$1;
(statearr_33494_33687[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (66))){
var inst_33088 = (state_33372[(7)]);
var inst_33057 = (state_33372[(53)]);
var inst_33091 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_33057,inst_33088) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_33057,inst_33088));
var state_33372__$1 = state_33372;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33372__$1,(69),inst_33091);
} else {
if((state_val_33373 === (107))){
var inst_33222 = (state_33372[(27)]);
var inst_33242 = cljs.core.count(inst_33222);
var inst_33243 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_33242);
var state_33372__$1 = state_33372;
var statearr_33495_33688 = state_33372__$1;
(statearr_33495_33688[(2)] = inst_33243);

(statearr_33495_33688[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (23))){
var inst_32983 = (state_33372[(2)]);
var state_33372__$1 = state_33372;
var statearr_33496_33689 = state_33372__$1;
(statearr_33496_33689[(2)] = inst_32983);

(statearr_33496_33689[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (47))){
var inst_33030 = (state_33372[(2)]);
var state_33372__$1 = state_33372;
var statearr_33497_33690 = state_33372__$1;
(statearr_33497_33690[(2)] = inst_33030);

(statearr_33497_33690[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (35))){
var inst_33341 = (state_33372[(50)]);
var inst_33340 = (state_33372[(2)]);
var inst_33341__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33340,(0),null);
var inst_33342 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33340,(1),null);
var inst_33343 = cljs.core.empty_QMARK_(inst_33341__$1);
var state_33372__$1 = (function (){var statearr_33498 = state_33372;
(statearr_33498[(10)] = inst_33342);

(statearr_33498[(50)] = inst_33341__$1);

return statearr_33498;
})();
if(inst_33343){
var statearr_33499_33691 = state_33372__$1;
(statearr_33499_33691[(1)] = (128));

} else {
var statearr_33500_33692 = state_33372__$1;
(statearr_33500_33692[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (127))){
var inst_33328 = (state_33372[(2)]);
var state_33372__$1 = state_33372;
var statearr_33501_33693 = state_33372__$1;
(statearr_33501_33693[(2)] = inst_33328);

(statearr_33501_33693[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (82))){
var inst_33135 = (state_33372[(30)]);
var state_33372__$1 = state_33372;
var statearr_33502_33694 = state_33372__$1;
(statearr_33502_33694[(2)] = inst_33135);

(statearr_33502_33694[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (76))){
var inst_33121 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33129 = flakes;
var inst_33130 = cljs.core.seq(inst_33129);
var inst_33131 = cljs.core.first(inst_33130);
var inst_33132 = cljs.core.next(inst_33130);
var inst_33133 = cljs.core.PersistentVector.EMPTY;
var inst_33134 = inst_33129;
var inst_33135 = inst_33133;
var state_33372__$1 = (function (){var statearr_33503 = state_33372;
(statearr_33503[(45)] = inst_33134);

(statearr_33503[(54)] = inst_33131);

(statearr_33503[(55)] = inst_33121);

(statearr_33503[(56)] = inst_33132);

(statearr_33503[(30)] = inst_33135);

return statearr_33503;
})();
var statearr_33504_33695 = state_33372__$1;
(statearr_33504_33695[(2)] = null);

(statearr_33504_33695[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (97))){
var inst_33201 = (state_33372[(48)]);
var inst_33208 = (state_33372[(40)]);
var inst_33207 = cljs.core.seq(inst_33201);
var inst_33208__$1 = cljs.core.first(inst_33207);
var inst_33209 = cljs.core.next(inst_33207);
var state_33372__$1 = (function (){var statearr_33505 = state_33372;
(statearr_33505[(40)] = inst_33208__$1);

(statearr_33505[(47)] = inst_33209);

return statearr_33505;
})();
if(cljs.core.truth_(inst_33208__$1)){
var statearr_33506_33696 = state_33372__$1;
(statearr_33506_33696[(1)] = (99));

} else {
var statearr_33507_33697 = state_33372__$1;
(statearr_33507_33697[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (19))){
var inst_32978 = (state_33372[(41)]);
var inst_32974 = (state_33372[(15)]);
var inst_32978__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_32974);
var state_33372__$1 = (function (){var statearr_33508 = state_33372;
(statearr_33508[(41)] = inst_32978__$1);

return statearr_33508;
})();
if(cljs.core.truth_(inst_32978__$1)){
var statearr_33509_33698 = state_33372__$1;
(statearr_33509_33698[(1)] = (21));

} else {
var statearr_33510_33699 = state_33372__$1;
(statearr_33510_33699[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (57))){
var inst_32974 = (state_33372[(15)]);
var inst_33054 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33055 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_33056 = (new cljs.core.PersistentVector(null,3,(5),inst_33054,inst_33055,null));
var inst_33057 = cljs.core.select_keys(inst_32974,inst_33056);
var inst_33058 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33066 = flakes;
var inst_33067 = cljs.core.seq(inst_33066);
var inst_33068 = cljs.core.first(inst_33067);
var inst_33069 = cljs.core.next(inst_33067);
var inst_33070 = cljs.core.PersistentVector.EMPTY;
var inst_33071 = inst_33066;
var inst_33072 = inst_33070;
var state_33372__$1 = (function (){var statearr_33511 = state_33372;
(statearr_33511[(24)] = inst_33071);

(statearr_33511[(57)] = inst_33068);

(statearr_33511[(53)] = inst_33057);

(statearr_33511[(51)] = inst_33058);

(statearr_33511[(58)] = inst_33069);

(statearr_33511[(9)] = inst_33072);

return statearr_33511;
})();
var statearr_33512_33700 = state_33372__$1;
(statearr_33512_33700[(2)] = null);

(statearr_33512_33700[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (68))){
var inst_33097 = (state_33372[(2)]);
var state_33372__$1 = (function (){var statearr_33513 = state_33372;
(statearr_33513[(22)] = inst_33097);

return statearr_33513;
})();
if(cljs.core.truth_(fuel)){
var statearr_33514_33701 = state_33372__$1;
(statearr_33514_33701[(1)] = (70));

} else {
var statearr_33515_33702 = state_33372__$1;
(statearr_33515_33702[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (11))){
var inst_32959 = (state_33372[(42)]);
var inst_32959__$1 = (state_33372[(2)]);
var inst_32961 = cljs.core.contains_QMARK_(inst_32959__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var inst_32962 = (!(inst_32961));
var state_33372__$1 = (function (){var statearr_33516 = state_33372;
(statearr_33516[(42)] = inst_32959__$1);

return statearr_33516;
})();
if(inst_32962){
var statearr_33517_33703 = state_33372__$1;
(statearr_33517_33703[(1)] = (12));

} else {
var statearr_33518_33704 = state_33372__$1;
(statearr_33518_33704[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (115))){
var inst_33318 = (state_33372[(2)]);
var state_33372__$1 = state_33372;
var statearr_33520_33705 = state_33372__$1;
(statearr_33520_33705[(2)] = inst_33318);

(statearr_33520_33705[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (9))){
var inst_32953 = cljs.core.first(flakes);
var inst_32954 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_32953);
var inst_32955 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_32956 = fluree.db.query.fql.wildcard_pred_spec(db,cache,inst_32954,inst_32955);
var state_33372__$1 = state_33372;
var statearr_33521_33706 = state_33372__$1;
(statearr_33521_33706[(2)] = inst_32956);

(statearr_33521_33706[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (5))){
var _ = (function (){var statearr_33522 = state_33372;
(statearr_33522[(4)] = cljs.core.rest((state_33372[(4)])));

return statearr_33522;
})();
var state_33372__$1 = state_33372;
var ex33519 = (state_33372__$1[(2)]);
var statearr_33523_33707 = state_33372__$1;
(statearr_33523_33707[(5)] = ex33519);


if((ex33519 instanceof Error)){
var statearr_33524_33708 = state_33372__$1;
(statearr_33524_33708[(1)] = (4));

(statearr_33524_33708[(5)] = null);

} else {
throw ex33519;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (112))){
var inst_33330 = (state_33372[(2)]);
var state_33372__$1 = state_33372;
var statearr_33525_33709 = state_33372__$1;
(statearr_33525_33709[(2)] = inst_33330);

(statearr_33525_33709[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (83))){
var inst_33175 = (state_33372[(2)]);
var state_33372__$1 = state_33372;
var statearr_33526_33710 = state_33372__$1;
(statearr_33526_33710[(2)] = inst_33175);

(statearr_33526_33710[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (14))){
var inst_32959 = (state_33372[(42)]);
var inst_32967 = (state_33372[(2)]);
var inst_32968 = cljs.core.contains_QMARK_(inst_32959,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var inst_32969 = (!(inst_32968));
var state_33372__$1 = (function (){var statearr_33527 = state_33372;
(statearr_33527[(36)] = inst_32967);

return statearr_33527;
})();
if(inst_32969){
var statearr_33528_33711 = state_33372__$1;
(statearr_33528_33711[(1)] = (15));

} else {
var statearr_33529_33712 = state_33372__$1;
(statearr_33529_33712[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (45))){
var inst_32989 = (state_33372[(16)]);
var inst_32985 = (state_33372[(20)]);
var inst_33025 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_32985);
var inst_33026 = cljs.core.count(inst_33025);
var inst_33027 = (inst_33026 >= inst_32989);
var state_33372__$1 = state_33372;
var statearr_33530_33713 = state_33372__$1;
(statearr_33530_33713[(2)] = inst_33027);

(statearr_33530_33713[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (53))){
var inst_33052 = (state_33372[(2)]);
var state_33372__$1 = state_33372;
if(cljs.core.truth_(inst_33052)){
var statearr_33531_33714 = state_33372__$1;
(statearr_33531_33714[(1)] = (57));

} else {
var statearr_33532_33715 = state_33372__$1;
(statearr_33532_33715[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (78))){
var inst_33334 = (state_33372[(2)]);
var state_33372__$1 = state_33372;
var statearr_33533_33716 = state_33372__$1;
(statearr_33533_33716[(2)] = inst_33334);

(statearr_33533_33716[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (132))){
var state_33372__$1 = state_33372;
var statearr_33535_33717 = state_33372__$1;
(statearr_33535_33717[(1)] = (134));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (26))){
var inst_33007 = (state_33372[(2)]);
var state_33372__$1 = state_33372;
if(cljs.core.truth_(inst_33007)){
var statearr_33537_33718 = state_33372__$1;
(statearr_33537_33718[(1)] = (33));

} else {
var statearr_33538_33719 = state_33372__$1;
(statearr_33538_33719[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (123))){
var inst_33280 = (state_33372[(33)]);
var inst_33287 = (state_33372[(39)]);
var tmp33534 = inst_33280;
var inst_33279 = inst_33287;
var inst_33280__$1 = tmp33534;
var state_33372__$1 = (function (){var statearr_33539 = state_33372;
(statearr_33539[(33)] = inst_33280__$1);

(statearr_33539[(38)] = inst_33279);

return statearr_33539;
})();
var statearr_33540_33720 = state_33372__$1;
(statearr_33540_33720[(2)] = null);

(statearr_33540_33720[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (16))){
var inst_32967 = (state_33372[(36)]);
var state_33372__$1 = state_33372;
var statearr_33541_33721 = state_33372__$1;
(statearr_33541_33721[(2)] = inst_32967);

(statearr_33541_33721[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (133))){
var inst_33365 = (state_33372[(2)]);
var state_33372__$1 = state_33372;
var statearr_33542_33722 = state_33372__$1;
(statearr_33542_33722[(2)] = inst_33365);

(statearr_33542_33722[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (81))){
var inst_33141 = (state_33372[(28)]);
var inst_33150 = (state_33372[(59)]);
var inst_32974 = (state_33372[(15)]);
var inst_33144 = cljs.core.deref(cache);
var inst_33145 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33146 = inst_33141.o;
var inst_33147 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_32974);
var inst_33148 = [inst_33146,inst_33147];
var inst_33149 = (new cljs.core.PersistentVector(null,2,(5),inst_33145,inst_33148,null));
var inst_33150__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33144,inst_33149);
var state_33372__$1 = (function (){var statearr_33543 = state_33372;
(statearr_33543[(59)] = inst_33150__$1);

return statearr_33543;
})();
if(cljs.core.truth_(inst_33150__$1)){
var statearr_33544_33723 = state_33372__$1;
(statearr_33544_33723[(1)] = (84));

} else {
var statearr_33545_33724 = state_33372__$1;
(statearr_33545_33724[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (120))){
var inst_33314 = (state_33372[(2)]);
var state_33372__$1 = state_33372;
var statearr_33546_33725 = state_33372__$1;
(statearr_33546_33725[(2)] = inst_33314);

(statearr_33546_33725[(1)] = (117));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (79))){
var inst_33141 = (state_33372[(28)]);
var inst_33134 = (state_33372[(45)]);
var inst_33140 = cljs.core.seq(inst_33134);
var inst_33141__$1 = cljs.core.first(inst_33140);
var inst_33142 = cljs.core.next(inst_33140);
var state_33372__$1 = (function (){var statearr_33547 = state_33372;
(statearr_33547[(28)] = inst_33141__$1);

(statearr_33547[(44)] = inst_33142);

return statearr_33547;
})();
if(cljs.core.truth_(inst_33141__$1)){
var statearr_33548_33726 = state_33372__$1;
(statearr_33548_33726[(1)] = (81));

} else {
var statearr_33549_33727 = state_33372__$1;
(statearr_33549_33727[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (38))){
var inst_33009 = (state_33372[(43)]);
var inst_33017 = (state_33372[(2)]);
var inst_33018 = [null,inst_33017];
var inst_33019 = (new cljs.core.PersistentVector(null,2,(5),inst_33009,inst_33018,null));
var state_33372__$1 = state_33372;
var statearr_33550_33728 = state_33372__$1;
(statearr_33550_33728[(2)] = inst_33019);

(statearr_33550_33728[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (126))){
var state_33372__$1 = state_33372;
var statearr_33551_33729 = state_33372__$1;
(statearr_33551_33729[(2)] = null);

(statearr_33551_33729[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (98))){
var inst_33188 = (state_33372[(60)]);
var inst_33252 = (state_33372[(2)]);
var inst_33253 = [inst_33252,offset_map];
var inst_33254 = (new cljs.core.PersistentVector(null,2,(5),inst_33188,inst_33253,null));
var state_33372__$1 = state_33372;
var statearr_33552_33730 = state_33372__$1;
(statearr_33552_33730[(2)] = inst_33254);

(statearr_33552_33730[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (124))){
var inst_33308 = (state_33372[(2)]);
var state_33372__$1 = state_33372;
var statearr_33553_33731 = state_33372__$1;
(statearr_33553_33731[(2)] = inst_33308);

(statearr_33553_33731[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (87))){
var inst_33141 = (state_33372[(28)]);
var inst_32974 = (state_33372[(15)]);
var inst_33157 = (state_33372[(2)]);
var inst_33158 = fluree.db.util.async.throw_err(inst_33157);
var inst_33159 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33160 = inst_33141.o;
var inst_33161 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_32974);
var inst_33162 = [inst_33160,inst_33161];
var inst_33163 = (new cljs.core.PersistentVector(null,2,(5),inst_33159,inst_33162,null));
var inst_33164 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,inst_33163,inst_33158);
var state_33372__$1 = (function (){var statearr_33554 = state_33372;
(statearr_33554[(61)] = inst_33164);

return statearr_33554;
})();
var statearr_33555_33732 = state_33372__$1;
(statearr_33555_33732[(2)] = inst_33158);

(statearr_33555_33732[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (30))){
var inst_32992 = (state_33372[(18)]);
var inst_32997 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_32992);
var inst_32998 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_32997);
var state_33372__$1 = state_33372;
var statearr_33556_33733 = state_33372__$1;
(statearr_33556_33733[(2)] = inst_32998);

(statearr_33556_33733[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (73))){
var inst_33072 = (state_33372[(9)]);
var inst_33097 = (state_33372[(22)]);
var inst_33106 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_33072,inst_33097);
var state_33372__$1 = state_33372;
var statearr_33557_33734 = state_33372__$1;
(statearr_33557_33734[(2)] = inst_33106);

(statearr_33557_33734[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (96))){
var inst_33332 = (state_33372[(2)]);
var state_33372__$1 = state_33372;
var statearr_33558_33735 = state_33372__$1;
(statearr_33558_33735[(2)] = inst_33332);

(statearr_33558_33735[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (10))){
var state_33372__$1 = state_33372;
var statearr_33559_33736 = state_33372__$1;
(statearr_33559_33736[(2)] = pred_spec);

(statearr_33559_33736[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (18))){
var inst_32975 = (state_33372[(52)]);
var state_33372__$1 = state_33372;
var statearr_33560_33737 = state_33372__$1;
(statearr_33560_33737[(2)] = inst_32975);

(statearr_33560_33737[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (105))){
var inst_33240 = (state_33372[(2)]);
var state_33372__$1 = (function (){var statearr_33561 = state_33372;
(statearr_33561[(46)] = inst_33240);

return statearr_33561;
})();
if(cljs.core.truth_(fuel)){
var statearr_33562_33738 = state_33372__$1;
(statearr_33562_33738[(1)] = (107));

} else {
var statearr_33563_33739 = state_33372__$1;
(statearr_33563_33739[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (52))){
var inst_33042 = (state_33372[(62)]);
var state_33372__$1 = state_33372;
var statearr_33564_33740 = state_33372__$1;
(statearr_33564_33740[(2)] = inst_33042);

(statearr_33564_33740[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (114))){
var inst_33274 = flakes;
var inst_33275 = cljs.core.seq(inst_33274);
var inst_33276 = cljs.core.first(inst_33275);
var inst_33277 = cljs.core.next(inst_33275);
var inst_33278 = cljs.core.PersistentVector.EMPTY;
var inst_33279 = inst_33274;
var inst_33280 = inst_33278;
var state_33372__$1 = (function (){var statearr_33565 = state_33372;
(statearr_33565[(33)] = inst_33280);

(statearr_33565[(63)] = inst_33277);

(statearr_33565[(64)] = inst_33276);

(statearr_33565[(38)] = inst_33279);

return statearr_33565;
})();
var statearr_33566_33741 = state_33372__$1;
(statearr_33566_33741[(2)] = null);

(statearr_33566_33741[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (67))){
var state_33372__$1 = state_33372;
var statearr_33567_33742 = state_33372__$1;
(statearr_33567_33742[(2)] = null);

(statearr_33567_33742[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (71))){
var state_33372__$1 = state_33372;
var statearr_33568_33743 = state_33372__$1;
(statearr_33568_33743[(2)] = null);

(statearr_33568_33743[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (42))){
var inst_32989 = (state_33372[(16)]);
var state_33372__$1 = state_33372;
if(cljs.core.truth_(inst_32989)){
var statearr_33569_33744 = state_33372__$1;
(statearr_33569_33744[(1)] = (45));

} else {
var statearr_33570_33745 = state_33372__$1;
(statearr_33570_33745[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (80))){
var inst_33121 = (state_33372[(55)]);
var inst_33177 = (state_33372[(2)]);
var inst_33178 = [inst_33177,offset_map];
var inst_33179 = (new cljs.core.PersistentVector(null,2,(5),inst_33121,inst_33178,null));
var state_33372__$1 = state_33372;
var statearr_33571_33746 = state_33372__$1;
(statearr_33571_33746[(2)] = inst_33179);

(statearr_33571_33746[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (37))){
var inst_32991 = (state_33372[(17)]);
var inst_32992 = (state_33372[(18)]);
var inst_33014 = (inst_32991 - (1));
var inst_33015 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_32992,inst_33014);
var state_33372__$1 = state_33372;
var statearr_33572_33747 = state_33372__$1;
(statearr_33572_33747[(2)] = inst_33015);

(statearr_33572_33747[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (63))){
var inst_33072 = (state_33372[(9)]);
var state_33372__$1 = state_33372;
var statearr_33573_33748 = state_33372__$1;
(statearr_33573_33748[(2)] = inst_33072);

(statearr_33573_33748[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (94))){
var inst_33188 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33196 = flakes;
var inst_33197 = cljs.core.seq(inst_33196);
var inst_33198 = cljs.core.first(inst_33197);
var inst_33199 = cljs.core.next(inst_33197);
var inst_33200 = cljs.core.PersistentVector.EMPTY;
var inst_33201 = inst_33196;
var inst_33202 = inst_33200;
var state_33372__$1 = (function (){var statearr_33574 = state_33372;
(statearr_33574[(48)] = inst_33201);

(statearr_33574[(65)] = inst_33198);

(statearr_33574[(32)] = inst_33202);

(statearr_33574[(60)] = inst_33188);

(statearr_33574[(66)] = inst_33199);

return statearr_33574;
})();
var statearr_33575_33749 = state_33372__$1;
(statearr_33575_33749[(2)] = null);

(statearr_33575_33749[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (8))){
var inst_32951 = (state_33372[(2)]);
var state_33372__$1 = state_33372;
if(cljs.core.truth_(inst_32951)){
var statearr_33576_33750 = state_33372__$1;
(statearr_33576_33750[(1)] = (9));

} else {
var statearr_33577_33751 = state_33372__$1;
(statearr_33577_33751[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (49))){
var inst_33042 = (state_33372[(62)]);
var inst_33042__$1 = cljs.core.not(recur_QMARK_);
var state_33372__$1 = (function (){var statearr_33578 = state_33372;
(statearr_33578[(62)] = inst_33042__$1);

return statearr_33578;
})();
if(inst_33042__$1){
var statearr_33579_33752 = state_33372__$1;
(statearr_33579_33752[(1)] = (51));

} else {
var statearr_33580_33753 = state_33372__$1;
(statearr_33580_33753[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33373 === (84))){
var inst_33150 = (state_33372[(59)]);
var state_33372__$1 = state_33372;
var statearr_33581_33754 = state_33372__$1;
(statearr_33581_33754[(2)] = inst_33150);

(statearr_33581_33754[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__11410__auto__ = null;
var fluree$db$query$fql$state_machine__11410__auto____0 = (function (){
var statearr_33582 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33582[(0)] = fluree$db$query$fql$state_machine__11410__auto__);

(statearr_33582[(1)] = (1));

return statearr_33582;
});
var fluree$db$query$fql$state_machine__11410__auto____1 = (function (state_33372){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_33372);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e33583){var ex__11413__auto__ = e33583;
var statearr_33584_33755 = state_33372;
(statearr_33584_33755[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_33372[(4)]))){
var statearr_33585_33756 = state_33372;
(statearr_33585_33756[(1)] = cljs.core.first((state_33372[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33757 = state_33372;
state_33372 = G__33757;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__11410__auto__ = function(state_33372){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__11410__auto____1.call(this,state_33372);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__11410__auto____0;
fluree$db$query$fql$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__11410__auto____1;
return fluree$db$query$fql$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_33586 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_33586[(6)] = c__11484__auto__);

return statearr_33586;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel)], 0))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec);

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_33917){
var state_val_33918 = (state_33917[(1)]);
if((state_val_33918 === (7))){
var inst_33912 = (state_33917[(2)]);
var _ = (function (){var statearr_33919 = state_33917;
(statearr_33919[(4)] = cljs.core.rest((state_33917[(4)])));

return statearr_33919;
})();
var state_33917__$1 = state_33917;
var statearr_33920_34002 = state_33917__$1;
(statearr_33920_34002[(2)] = inst_33912);

(statearr_33920_34002[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (20))){
var inst_33839 = (state_33917[(7)]);
var state_33917__$1 = state_33917;
var statearr_33921_34003 = state_33917__$1;
(statearr_33921_34003[(2)] = inst_33839);

(statearr_33921_34003[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (27))){
var inst_33794 = (state_33917[(8)]);
var state_33917__$1 = state_33917;
if(cljs.core.truth_(inst_33794)){
var statearr_33922_34004 = state_33917__$1;
(statearr_33922_34004[(1)] = (29));

} else {
var statearr_33923_34005 = state_33917__$1;
(statearr_33923_34005[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (1))){
var state_33917__$1 = state_33917;
var statearr_33924_34006 = state_33917__$1;
(statearr_33924_34006[(2)] = null);

(statearr_33924_34006[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (24))){
var inst_33795 = (state_33917[(9)]);
var state_33917__$1 = state_33917;
var statearr_33925_34007 = state_33917__$1;
(statearr_33925_34007[(2)] = inst_33795);

(statearr_33925_34007[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (39))){
var inst_33831 = (state_33917[(10)]);
var state_33917__$1 = state_33917;
var statearr_33926_34008 = state_33917__$1;
(statearr_33926_34008[(2)] = inst_33831);

(statearr_33926_34008[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (46))){
var inst_33796 = (state_33917[(11)]);
var state_33917__$1 = state_33917;
var statearr_33927_34009 = state_33917__$1;
(statearr_33927_34009[(2)] = inst_33796);

(statearr_33927_34009[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (4))){
var inst_33758 = (state_33917[(2)]);
var state_33917__$1 = state_33917;
var statearr_33928_34010 = state_33917__$1;
(statearr_33928_34010[(2)] = inst_33758);

(statearr_33928_34010[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (15))){
var inst_33807 = (state_33917[(12)]);
var inst_33813 = cljs.core.count(inst_33807);
var inst_33814 = fluree.db.query.fql.add_fuel(fuel,inst_33813,max_fuel);
var state_33917__$1 = state_33917;
var statearr_33929_34011 = state_33917__$1;
(statearr_33929_34011[(2)] = inst_33814);

(statearr_33929_34011[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (48))){
var inst_33898 = (state_33917[(13)]);
var inst_33783 = (state_33917[(14)]);
var inst_33776 = (state_33917[(15)]);
var inst_33906 = (state_33917[(2)]);
var inst_33907 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_33776,inst_33906,inst_33898);
var inst_33775 = inst_33783;
var inst_33776__$1 = inst_33907;
var state_33917__$1 = (function (){var statearr_33930 = state_33917;
(statearr_33930[(16)] = inst_33775);

(statearr_33930[(15)] = inst_33776__$1);

return statearr_33930;
})();
var statearr_33931_34012 = state_33917__$1;
(statearr_33931_34012[(2)] = null);

(statearr_33931_34012[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (50))){
var inst_33798 = (state_33917[(17)]);
var state_33917__$1 = state_33917;
var statearr_33932_34013 = state_33917__$1;
(statearr_33932_34013[(2)] = inst_33798);

(statearr_33932_34013[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (21))){
var inst_33795 = (state_33917[(9)]);
var state_33917__$1 = state_33917;
if(cljs.core.truth_(inst_33795)){
var statearr_33934_34014 = state_33917__$1;
(statearr_33934_34014[(1)] = (23));

} else {
var statearr_33935_34015 = state_33917__$1;
(statearr_33935_34015[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (31))){
var inst_33855 = (state_33917[(2)]);
var state_33917__$1 = state_33917;
if(cljs.core.truth_(inst_33855)){
var statearr_33936_34016 = state_33917__$1;
(statearr_33936_34016[(1)] = (32));

} else {
var statearr_33937_34017 = state_33917__$1;
(statearr_33937_34017[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (32))){
var inst_33830 = (state_33917[(18)]);
var inst_33831 = (state_33917[(10)]);
var inst_33838 = (state_33917[(19)]);
var inst_33857 = (inst_33830 + (1));
var tmp33933 = inst_33831;
var inst_33829 = inst_33838;
var inst_33830__$1 = inst_33857;
var inst_33831__$1 = tmp33933;
var state_33917__$1 = (function (){var statearr_33938 = state_33917;
(statearr_33938[(20)] = inst_33829);

(statearr_33938[(18)] = inst_33830__$1);

(statearr_33938[(10)] = inst_33831__$1);

return statearr_33938;
})();
var statearr_33939_34018 = state_33917__$1;
(statearr_33939_34018[(2)] = null);

(statearr_33939_34018[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (40))){
var state_33917__$1 = state_33917;
if(cljs.core.truth_(fuel)){
var statearr_33940_34019 = state_33917__$1;
(statearr_33940_34019[(1)] = (42));

} else {
var statearr_33941_34020 = state_33917__$1;
(statearr_33941_34020[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (33))){
var state_33917__$1 = state_33917;
var statearr_33942_34021 = state_33917__$1;
(statearr_33942_34021[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (13))){
var inst_33807 = (state_33917[(12)]);
var state_33917__$1 = state_33917;
var statearr_33944_34022 = state_33917__$1;
(statearr_33944_34022[(2)] = inst_33807);

(statearr_33944_34022[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (22))){
var inst_33848 = (state_33917[(2)]);
var state_33917__$1 = state_33917;
if(cljs.core.truth_(inst_33848)){
var statearr_33945_34023 = state_33917__$1;
(statearr_33945_34023[(1)] = (26));

} else {
var statearr_33946_34024 = state_33917__$1;
(statearr_33946_34024[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (36))){
var state_33917__$1 = state_33917;
var statearr_33947_34025 = state_33917__$1;
(statearr_33947_34025[(2)] = null);

(statearr_33947_34025[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (41))){
var inst_33830 = (state_33917[(18)]);
var inst_33838 = (state_33917[(19)]);
var inst_33887 = (state_33917[(2)]);
var inst_33888 = (inst_33830 + (1));
var inst_33829 = inst_33838;
var inst_33830__$1 = inst_33888;
var inst_33831 = inst_33887;
var state_33917__$1 = (function (){var statearr_33948 = state_33917;
(statearr_33948[(20)] = inst_33829);

(statearr_33948[(18)] = inst_33830__$1);

(statearr_33948[(10)] = inst_33831);

return statearr_33948;
})();
var statearr_33949_34026 = state_33917__$1;
(statearr_33949_34026[(2)] = null);

(statearr_33949_34026[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (43))){
var state_33917__$1 = state_33917;
var statearr_33950_34027 = state_33917__$1;
(statearr_33950_34027[(2)] = null);

(statearr_33950_34027[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (29))){
var inst_33830 = (state_33917[(18)]);
var inst_33794 = (state_33917[(8)]);
var inst_33852 = (inst_33830 < inst_33794);
var state_33917__$1 = state_33917;
var statearr_33951_34028 = state_33917__$1;
(statearr_33951_34028[(2)] = inst_33852);

(statearr_33951_34028[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (44))){
var inst_33871 = (state_33917[(21)]);
var inst_33867 = (state_33917[(22)]);
var inst_33880 = (state_33917[(2)]);
var inst_33881 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_33871,inst_33867) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_33871,inst_33867));
var state_33917__$1 = (function (){var statearr_33952 = state_33917;
(statearr_33952[(23)] = inst_33880);

return statearr_33952;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33917__$1,(45),inst_33881);
} else {
if((state_val_33918 === (6))){
var inst_33775 = (state_33917[(16)]);
var inst_33782 = (state_33917[(24)]);
var inst_33781 = cljs.core.seq(inst_33775);
var inst_33782__$1 = cljs.core.first(inst_33781);
var inst_33783 = cljs.core.next(inst_33781);
var inst_33784 = cljs.core.not(inst_33782__$1);
var state_33917__$1 = (function (){var statearr_33953 = state_33917;
(statearr_33953[(24)] = inst_33782__$1);

(statearr_33953[(14)] = inst_33783);

return statearr_33953;
})();
if(inst_33784){
var statearr_33954_34029 = state_33917__$1;
(statearr_33954_34029[(1)] = (8));

} else {
var statearr_33955_34030 = state_33917__$1;
(statearr_33955_34030[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (28))){
var inst_33896 = (state_33917[(2)]);
var state_33917__$1 = state_33917;
var statearr_33956_34031 = state_33917__$1;
(statearr_33956_34031[(2)] = inst_33896);

(statearr_33956_34031[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (51))){
var inst_33904 = (state_33917[(2)]);
var state_33917__$1 = state_33917;
var statearr_33957_34032 = state_33917__$1;
(statearr_33957_34032[(2)] = inst_33904);

(statearr_33957_34032[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (25))){
var inst_33846 = (state_33917[(2)]);
var state_33917__$1 = state_33917;
var statearr_33958_34033 = state_33917__$1;
(statearr_33958_34033[(2)] = inst_33846);

(statearr_33958_34033[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (34))){
var inst_33894 = (state_33917[(2)]);
var state_33917__$1 = state_33917;
var statearr_33959_34034 = state_33917__$1;
(statearr_33959_34034[(2)] = inst_33894);

(statearr_33959_34034[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (17))){
var inst_33807 = (state_33917[(12)]);
var inst_33817 = (state_33917[(2)]);
var inst_33825 = cljs.core.seq(inst_33807);
var inst_33826 = cljs.core.first(inst_33825);
var inst_33827 = cljs.core.next(inst_33825);
var inst_33828 = cljs.core.PersistentVector.EMPTY;
var inst_33829 = inst_33807;
var inst_33830 = (0);
var inst_33831 = inst_33828;
var state_33917__$1 = (function (){var statearr_33960 = state_33917;
(statearr_33960[(25)] = inst_33826);

(statearr_33960[(26)] = inst_33827);

(statearr_33960[(20)] = inst_33829);

(statearr_33960[(18)] = inst_33830);

(statearr_33960[(27)] = inst_33817);

(statearr_33960[(10)] = inst_33831);

return statearr_33960;
})();
var statearr_33961_34035 = state_33917__$1;
(statearr_33961_34035[(2)] = null);

(statearr_33961_34035[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (3))){
var inst_33915 = (state_33917[(2)]);
var state_33917__$1 = state_33917;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33917__$1,inst_33915);
} else {
if((state_val_33918 === (12))){
var state_33917__$1 = state_33917;
var statearr_33962_34036 = state_33917__$1;
(statearr_33962_34036[(2)] = fuel);

(statearr_33962_34036[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (2))){
var _ = (function (){var statearr_33963 = state_33917;
(statearr_33963[(4)] = cljs.core.cons((5),(state_33917[(4)])));

return statearr_33963;
})();
var inst_33771 = reverse_refs_specs;
var inst_33772 = cljs.core.seq(inst_33771);
var inst_33773 = cljs.core.first(inst_33772);
var inst_33774 = cljs.core.next(inst_33772);
var inst_33775 = inst_33771;
var inst_33776 = null;
var state_33917__$1 = (function (){var statearr_33964 = state_33917;
(statearr_33964[(16)] = inst_33775);

(statearr_33964[(28)] = inst_33773);

(statearr_33964[(29)] = inst_33774);

(statearr_33964[(15)] = inst_33776);

return statearr_33964;
})();
var statearr_33965_34037 = state_33917__$1;
(statearr_33965_34037[(2)] = null);

(statearr_33965_34037[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (23))){
var inst_33830 = (state_33917[(18)]);
var inst_33795 = (state_33917[(9)]);
var inst_33843 = (inst_33830 >= inst_33795);
var state_33917__$1 = state_33917;
var statearr_33966_34038 = state_33917__$1;
(statearr_33966_34038[(2)] = inst_33843);

(statearr_33966_34038[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (47))){
var inst_33797 = (state_33917[(30)]);
var state_33917__$1 = state_33917;
if(cljs.core.truth_(inst_33797)){
var statearr_33967_34039 = state_33917__$1;
(statearr_33967_34039[(1)] = (49));

} else {
var statearr_33968_34040 = state_33917__$1;
(statearr_33968_34040[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (35))){
var inst_33837 = (state_33917[(31)]);
var inst_33861 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33862 = [inst_33837];
var inst_33863 = (new cljs.core.PersistentVector(null,1,(5),inst_33861,inst_33862,null));
var inst_33864 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_33863);
var state_33917__$1 = state_33917;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33917__$1,(38),inst_33864);
} else {
if((state_val_33918 === (19))){
var inst_33796 = (state_33917[(11)]);
var inst_33898 = (state_33917[(2)]);
var state_33917__$1 = (function (){var statearr_33969 = state_33917;
(statearr_33969[(13)] = inst_33898);

return statearr_33969;
})();
if(cljs.core.truth_(inst_33796)){
var statearr_33970_34041 = state_33917__$1;
(statearr_33970_34041[(1)] = (46));

} else {
var statearr_33971_34042 = state_33917__$1;
(statearr_33971_34042[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (11))){
var inst_33807 = (state_33917[(12)]);
var inst_33804 = (state_33917[(2)]);
var inst_33805 = fluree.db.util.async.throw_err(inst_33804);
var inst_33806 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_33805);
var inst_33807__$1 = cljs.core.not_empty(inst_33806);
var state_33917__$1 = (function (){var statearr_33973 = state_33917;
(statearr_33973[(12)] = inst_33807__$1);

return statearr_33973;
})();
if(cljs.core.truth_(inst_33807__$1)){
var statearr_33974_34043 = state_33917__$1;
(statearr_33974_34043[(1)] = (12));

} else {
var statearr_33975_34044 = state_33917__$1;
(statearr_33975_34044[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (9))){
var inst_33782 = (state_33917[(24)]);
var inst_33792 = (state_33917[(32)]);
var inst_33791 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33782,(0),null);
var inst_33792__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33782,(1),null);
var inst_33793 = cljs.core.__destructure_map(inst_33792__$1);
var inst_33794 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33793,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_33795 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33793,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_33796 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33793,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_33797 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33793,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_33798 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33793,new cljs.core.Keyword(null,"p","p",151049309));
var inst_33799 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33800 = [subject_id,inst_33791];
var inst_33801 = (new cljs.core.PersistentVector(null,2,(5),inst_33799,inst_33800,null));
var inst_33802 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_33801);
var state_33917__$1 = (function (){var statearr_33976 = state_33917;
(statearr_33976[(32)] = inst_33792__$1);

(statearr_33976[(11)] = inst_33796);

(statearr_33976[(17)] = inst_33798);

(statearr_33976[(30)] = inst_33797);

(statearr_33976[(8)] = inst_33794);

(statearr_33976[(9)] = inst_33795);

return statearr_33976;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33917__$1,(11),inst_33802);
} else {
if((state_val_33918 === (5))){
var _ = (function (){var statearr_33977 = state_33917;
(statearr_33977[(4)] = cljs.core.rest((state_33917[(4)])));

return statearr_33977;
})();
var state_33917__$1 = state_33917;
var ex33972 = (state_33917__$1[(2)]);
var statearr_33978_34045 = state_33917__$1;
(statearr_33978_34045[(5)] = ex33972);


if((ex33972 instanceof Error)){
var statearr_33979_34046 = state_33917__$1;
(statearr_33979_34046[(1)] = (4));

(statearr_33979_34046[(5)] = null);

} else {
throw ex33972;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (14))){
var inst_33811 = (state_33917[(2)]);
var state_33917__$1 = state_33917;
if(cljs.core.truth_(inst_33811)){
var statearr_33980_34047 = state_33917__$1;
(statearr_33980_34047[(1)] = (15));

} else {
var statearr_33981_34048 = state_33917__$1;
(statearr_33981_34048[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (45))){
var inst_33831 = (state_33917[(10)]);
var inst_33883 = (state_33917[(2)]);
var inst_33884 = fluree.db.util.async.throw_err(inst_33883);
var inst_33885 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_33831,inst_33884);
var state_33917__$1 = state_33917;
var statearr_33982_34049 = state_33917__$1;
(statearr_33982_34049[(2)] = inst_33885);

(statearr_33982_34049[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (26))){
var inst_33831 = (state_33917[(10)]);
var state_33917__$1 = state_33917;
var statearr_33983_34050 = state_33917__$1;
(statearr_33983_34050[(2)] = inst_33831);

(statearr_33983_34050[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (16))){
var state_33917__$1 = state_33917;
var statearr_33984_34051 = state_33917__$1;
(statearr_33984_34051[(2)] = null);

(statearr_33984_34051[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (38))){
var inst_33792 = (state_33917[(32)]);
var inst_33867 = (state_33917[(22)]);
var inst_33866 = (state_33917[(2)]);
var inst_33867__$1 = fluree.db.util.async.throw_err(inst_33866);
var inst_33868 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33869 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_33870 = (new cljs.core.PersistentVector(null,4,(5),inst_33868,inst_33869,null));
var inst_33871 = cljs.core.select_keys(inst_33792,inst_33870);
var inst_33872 = cljs.core.empty_QMARK_(inst_33867__$1);
var state_33917__$1 = (function (){var statearr_33985 = state_33917;
(statearr_33985[(21)] = inst_33871);

(statearr_33985[(22)] = inst_33867__$1);

return statearr_33985;
})();
if(inst_33872){
var statearr_33986_34052 = state_33917__$1;
(statearr_33986_34052[(1)] = (39));

} else {
var statearr_33987_34053 = state_33917__$1;
(statearr_33987_34053[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (30))){
var inst_33794 = (state_33917[(8)]);
var state_33917__$1 = state_33917;
var statearr_33988_34054 = state_33917__$1;
(statearr_33988_34054[(2)] = inst_33794);

(statearr_33988_34054[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (10))){
var inst_33910 = (state_33917[(2)]);
var state_33917__$1 = state_33917;
var statearr_33989_34055 = state_33917__$1;
(statearr_33989_34055[(2)] = inst_33910);

(statearr_33989_34055[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (18))){
var inst_33839 = (state_33917[(7)]);
var inst_33837 = (state_33917[(31)]);
var inst_33829 = (state_33917[(20)]);
var inst_33836 = cljs.core.seq(inst_33829);
var inst_33837__$1 = cljs.core.first(inst_33836);
var inst_33838 = cljs.core.next(inst_33836);
var inst_33839__$1 = cljs.core.not(inst_33837__$1);
var state_33917__$1 = (function (){var statearr_33990 = state_33917;
(statearr_33990[(7)] = inst_33839__$1);

(statearr_33990[(31)] = inst_33837__$1);

(statearr_33990[(19)] = inst_33838);

return statearr_33990;
})();
if(inst_33839__$1){
var statearr_33991_34056 = state_33917__$1;
(statearr_33991_34056[(1)] = (20));

} else {
var statearr_33992_34057 = state_33917__$1;
(statearr_33992_34057[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (42))){
var inst_33867 = (state_33917[(22)]);
var inst_33876 = cljs.core.count(inst_33867);
var inst_33877 = fluree.db.query.fql.add_fuel(fuel,inst_33876,max_fuel);
var state_33917__$1 = state_33917;
var statearr_33993_34058 = state_33917__$1;
(statearr_33993_34058[(2)] = inst_33877);

(statearr_33993_34058[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (37))){
var inst_33892 = (state_33917[(2)]);
var state_33917__$1 = state_33917;
var statearr_33994_34059 = state_33917__$1;
(statearr_33994_34059[(2)] = inst_33892);

(statearr_33994_34059[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (8))){
var inst_33776 = (state_33917[(15)]);
var state_33917__$1 = state_33917;
var statearr_33995_34060 = state_33917__$1;
(statearr_33995_34060[(2)] = inst_33776);

(statearr_33995_34060[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33918 === (49))){
var inst_33797 = (state_33917[(30)]);
var state_33917__$1 = state_33917;
var statearr_33996_34061 = state_33917__$1;
(statearr_33996_34061[(2)] = inst_33797);

(statearr_33996_34061[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11410__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11410__auto____0 = (function (){
var statearr_33997 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33997[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11410__auto__);

(statearr_33997[(1)] = (1));

return statearr_33997;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11410__auto____1 = (function (state_33917){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_33917);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e33998){var ex__11413__auto__ = e33998;
var statearr_33999_34062 = state_33917;
(statearr_33999_34062[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_33917[(4)]))){
var statearr_34000_34063 = state_33917;
(statearr_34000_34063[(1)] = cljs.core.first((state_33917[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34064 = state_33917;
state_33917 = G__34064;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11410__auto__ = function(state_33917){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11410__auto____1.call(this,state_33917);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11410__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11410__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_34001 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_34001[(6)] = c__11484__auto__);

return statearr_34001;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4253__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__34065 = select_spec;
var map__34065__$1 = cljs.core.__destructure_map(map__34065);
var recur_seen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34065__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var recur_depth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34065__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
return cljs.core.select_keys(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057)], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687)], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"compact?","compact?",1216893298)], null));
});
/**
 * Performs recursion on a select spec graph crawl when specified. flakes input is list
 *   of flakes all with the same subject and predicate values.
 */
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flakes,select_spec,results,fuel,max_fuel,cache){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_34179){
var state_val_34180 = (state_34179[(1)]);
if((state_val_34180 === (7))){
var inst_34091 = flakes;
var inst_34092 = cljs.core.seq(inst_34091);
var inst_34093 = cljs.core.first(inst_34092);
var inst_34094 = cljs.core.next(inst_34092);
var inst_34095 = cljs.core.PersistentVector.EMPTY;
var inst_34096 = inst_34091;
var inst_34097 = (0);
var inst_34098 = inst_34095;
var state_34179__$1 = (function (){var statearr_34181 = state_34179;
(statearr_34181[(7)] = inst_34094);

(statearr_34181[(8)] = inst_34098);

(statearr_34181[(9)] = inst_34097);

(statearr_34181[(10)] = inst_34093);

(statearr_34181[(11)] = inst_34096);

return statearr_34181;
})();
var statearr_34182_34248 = state_34179__$1;
(statearr_34182_34248[(2)] = null);

(statearr_34182_34248[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34180 === (20))){
var state_34179__$1 = state_34179;
var statearr_34183_34249 = state_34179__$1;
(statearr_34183_34249[(2)] = results);

(statearr_34183_34249[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34180 === (27))){
var state_34179__$1 = state_34179;
var statearr_34184_34250 = state_34179__$1;
(statearr_34184_34250[(2)] = null);

(statearr_34184_34250[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34180 === (1))){
var state_34179__$1 = state_34179;
var statearr_34185_34251 = state_34179__$1;
(statearr_34185_34251[(2)] = null);

(statearr_34185_34251[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34180 === (24))){
var state_34179__$1 = state_34179;
var statearr_34186_34252 = state_34179__$1;
(statearr_34186_34252[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34180 === (39))){
var inst_34160 = (state_34179[(12)]);
var inst_34098 = (state_34179[(8)]);
var inst_34105 = (state_34179[(13)]);
var inst_34163 = (state_34179[(2)]);
var inst_34164 = fluree.db.util.async.throw_err(inst_34163);
var inst_34165 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_34098,inst_34164);
var inst_34096 = inst_34105;
var inst_34097 = inst_34160;
var inst_34098__$1 = inst_34165;
var state_34179__$1 = (function (){var statearr_34188 = state_34179;
(statearr_34188[(8)] = inst_34098__$1);

(statearr_34188[(9)] = inst_34097);

(statearr_34188[(11)] = inst_34096);

return statearr_34188;
})();
var statearr_34189_34253 = state_34179__$1;
(statearr_34189_34253[(2)] = null);

(statearr_34189_34253[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34180 === (4))){
var inst_34066 = (state_34179[(2)]);
var state_34179__$1 = state_34179;
var statearr_34190_34254 = state_34179__$1;
(statearr_34190_34254[(2)] = inst_34066);

(statearr_34190_34254[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34180 === (15))){
var inst_34079 = (state_34179[(14)]);
var state_34179__$1 = state_34179;
var statearr_34191_34255 = state_34179__$1;
(statearr_34191_34255[(2)] = inst_34079);

(statearr_34191_34255[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34180 === (21))){
var inst_34075 = (state_34179[(15)]);
var state_34179__$1 = state_34179;
if(cljs.core.truth_(inst_34075)){
var statearr_34192_34256 = state_34179__$1;
(statearr_34192_34256[(1)] = (23));

} else {
var statearr_34193_34257 = state_34179__$1;
(statearr_34193_34257[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34180 === (31))){
var inst_34143 = (state_34179[(16)]);
var state_34179__$1 = state_34179;
var statearr_34194_34258 = state_34179__$1;
(statearr_34194_34258[(2)] = inst_34143);

(statearr_34194_34258[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34180 === (32))){
var inst_34135 = (state_34179[(17)]);
var inst_34149 = (state_34179[(2)]);
var state_34179__$1 = (function (){var statearr_34195 = state_34179;
(statearr_34195[(18)] = inst_34149);

return statearr_34195;
})();
if(cljs.core.truth_(inst_34135)){
var statearr_34196_34259 = state_34179__$1;
(statearr_34196_34259[(1)] = (33));

} else {
var statearr_34197_34260 = state_34179__$1;
(statearr_34197_34260[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34180 === (33))){
var inst_34135 = (state_34179[(17)]);
var state_34179__$1 = state_34179;
var statearr_34198_34261 = state_34179__$1;
(statearr_34198_34261[(2)] = inst_34135);

(statearr_34198_34261[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34180 === (13))){
var inst_34115 = (state_34179[(2)]);
var state_34179__$1 = state_34179;
if(cljs.core.truth_(inst_34115)){
var statearr_34200_34262 = state_34179__$1;
(statearr_34200_34262[(1)] = (17));

} else {
var statearr_34201_34263 = state_34179__$1;
(statearr_34201_34263[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34180 === (22))){
var inst_34132 = (state_34179[(2)]);
var state_34179__$1 = state_34179;
var statearr_34202_34264 = state_34179__$1;
(statearr_34202_34264[(2)] = inst_34132);

(statearr_34202_34264[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34180 === (36))){
var inst_34098 = (state_34179[(8)]);
var inst_34097 = (state_34179[(9)]);
var inst_34105 = (state_34179[(13)]);
var inst_34157 = (inst_34097 + (1));
var tmp34199 = inst_34098;
var inst_34096 = inst_34105;
var inst_34097__$1 = inst_34157;
var inst_34098__$1 = tmp34199;
var state_34179__$1 = (function (){var statearr_34203 = state_34179;
(statearr_34203[(8)] = inst_34098__$1);

(statearr_34203[(9)] = inst_34097__$1);

(statearr_34203[(11)] = inst_34096);

return statearr_34203;
})();
var statearr_34204_34265 = state_34179__$1;
(statearr_34204_34265[(2)] = null);

(statearr_34204_34265[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34180 === (29))){
var inst_34142 = (state_34179[(2)]);
var inst_34143 = fluree.db.util.async.throw_err(inst_34142);
var state_34179__$1 = (function (){var statearr_34205 = state_34179;
(statearr_34205[(16)] = inst_34143);

return statearr_34205;
})();
if(cljs.core.truth_(fuel)){
var statearr_34206_34266 = state_34179__$1;
(statearr_34206_34266[(1)] = (30));

} else {
var statearr_34207_34267 = state_34179__$1;
(statearr_34207_34267[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34180 === (6))){
var state_34179__$1 = state_34179;
var statearr_34208_34268 = state_34179__$1;
(statearr_34208_34268[(2)] = results);

(statearr_34208_34268[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34180 === (28))){
var inst_34128 = (state_34179[(2)]);
var state_34179__$1 = state_34179;
var statearr_34209_34269 = state_34179__$1;
(statearr_34209_34269[(2)] = inst_34128);

(statearr_34209_34269[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34180 === (25))){
var inst_34130 = (state_34179[(2)]);
var state_34179__$1 = state_34179;
var statearr_34210_34270 = state_34179__$1;
(statearr_34210_34270[(2)] = inst_34130);

(statearr_34210_34270[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34180 === (34))){
var inst_34149 = (state_34179[(18)]);
var inst_34152 = cljs.core.empty_QMARK_(inst_34149);
var state_34179__$1 = state_34179;
var statearr_34211_34271 = state_34179__$1;
(statearr_34211_34271[(2)] = inst_34152);

(statearr_34211_34271[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34180 === (17))){
var inst_34098 = (state_34179[(8)]);
var inst_34117 = cljs.core.empty_QMARK_(inst_34098);
var state_34179__$1 = state_34179;
if(inst_34117){
var statearr_34212_34272 = state_34179__$1;
(statearr_34212_34272[(1)] = (20));

} else {
var statearr_34213_34273 = state_34179__$1;
(statearr_34213_34273[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34180 === (3))){
var inst_34177 = (state_34179[(2)]);
var state_34179__$1 = state_34179;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34179__$1,inst_34177);
} else {
if((state_val_34180 === (12))){
var inst_34079 = (state_34179[(14)]);
var state_34179__$1 = state_34179;
if(cljs.core.truth_(inst_34079)){
var statearr_34214_34274 = state_34179__$1;
(statearr_34214_34274[(1)] = (14));

} else {
var statearr_34215_34275 = state_34179__$1;
(statearr_34215_34275[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34180 === (2))){
var _ = (function (){var statearr_34216 = state_34179;
(statearr_34216[(4)] = cljs.core.cons((5),(state_34179[(4)])));

return statearr_34216;
})();
var inst_34073 = select_spec;
var inst_34074 = cljs.core.__destructure_map(inst_34073);
var inst_34075 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34074,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_34076 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34074,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_34077 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34074,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var inst_34078 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34074,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
var inst_34079 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34074,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_34080 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(select_spec);
var inst_34081 = (inst_34078 > inst_34080);
var state_34179__$1 = (function (){var statearr_34217 = state_34179;
(statearr_34217[(19)] = inst_34077);

(statearr_34217[(14)] = inst_34079);

(statearr_34217[(20)] = inst_34076);

(statearr_34217[(15)] = inst_34075);

return statearr_34217;
})();
if(cljs.core.truth_(inst_34081)){
var statearr_34218_34276 = state_34179__$1;
(statearr_34218_34276[(1)] = (6));

} else {
var statearr_34219_34277 = state_34179__$1;
(statearr_34219_34277[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34180 === (23))){
var inst_34098 = (state_34179[(8)]);
var inst_34076 = (state_34179[(20)]);
var inst_34121 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_34076,inst_34098);
var state_34179__$1 = state_34179;
var statearr_34220_34278 = state_34179__$1;
(statearr_34220_34278[(2)] = inst_34121);

(statearr_34220_34278[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34180 === (35))){
var inst_34104 = (state_34179[(21)]);
var inst_34154 = (state_34179[(2)]);
var inst_34155 = fluree.db.query.fql.recur_select_spec(select_spec,inst_34104);
var state_34179__$1 = (function (){var statearr_34221 = state_34179;
(statearr_34221[(22)] = inst_34155);

return statearr_34221;
})();
if(cljs.core.truth_(inst_34154)){
var statearr_34222_34279 = state_34179__$1;
(statearr_34222_34279[(1)] = (36));

} else {
var statearr_34223_34280 = state_34179__$1;
(statearr_34223_34280[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34180 === (19))){
var inst_34170 = (state_34179[(2)]);
var state_34179__$1 = state_34179;
var statearr_34224_34281 = state_34179__$1;
(statearr_34224_34281[(2)] = inst_34170);

(statearr_34224_34281[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34180 === (11))){
var inst_34106 = (state_34179[(23)]);
var state_34179__$1 = state_34179;
var statearr_34226_34282 = state_34179__$1;
(statearr_34226_34282[(2)] = inst_34106);

(statearr_34226_34282[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34180 === (9))){
var inst_34104 = (state_34179[(21)]);
var inst_34106 = (state_34179[(23)]);
var inst_34096 = (state_34179[(11)]);
var inst_34103 = cljs.core.seq(inst_34096);
var inst_34104__$1 = cljs.core.first(inst_34103);
var inst_34105 = cljs.core.next(inst_34103);
var inst_34106__$1 = cljs.core.not(inst_34104__$1);
var state_34179__$1 = (function (){var statearr_34227 = state_34179;
(statearr_34227[(21)] = inst_34104__$1);

(statearr_34227[(23)] = inst_34106__$1);

(statearr_34227[(13)] = inst_34105);

return statearr_34227;
})();
if(inst_34106__$1){
var statearr_34228_34283 = state_34179__$1;
(statearr_34228_34283[(1)] = (11));

} else {
var statearr_34229_34284 = state_34179__$1;
(statearr_34229_34284[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34180 === (5))){
var _ = (function (){var statearr_34230 = state_34179;
(statearr_34230[(4)] = cljs.core.rest((state_34179[(4)])));

return statearr_34230;
})();
var state_34179__$1 = state_34179;
var ex34225 = (state_34179__$1[(2)]);
var statearr_34231_34285 = state_34179__$1;
(statearr_34231_34285[(5)] = ex34225);


if((ex34225 instanceof Error)){
var statearr_34232_34286 = state_34179__$1;
(statearr_34232_34286[(1)] = (4));

(statearr_34232_34286[(5)] = null);

} else {
throw ex34225;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34180 === (14))){
var inst_34079 = (state_34179[(14)]);
var inst_34097 = (state_34179[(9)]);
var inst_34110 = (inst_34097 < inst_34079);
var state_34179__$1 = state_34179;
var statearr_34233_34287 = state_34179__$1;
(statearr_34233_34287[(2)] = inst_34110);

(statearr_34233_34287[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34180 === (26))){
var inst_34098 = (state_34179[(8)]);
var inst_34076 = (state_34179[(20)]);
var inst_34124 = cljs.core.first(inst_34098);
var inst_34125 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_34076,inst_34124);
var state_34179__$1 = state_34179;
var statearr_34234_34288 = state_34179__$1;
(statearr_34234_34288[(2)] = inst_34125);

(statearr_34234_34288[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34180 === (16))){
var inst_34113 = (state_34179[(2)]);
var state_34179__$1 = state_34179;
var statearr_34235_34289 = state_34179__$1;
(statearr_34235_34289[(2)] = inst_34113);

(statearr_34235_34289[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34180 === (38))){
var inst_34168 = (state_34179[(2)]);
var state_34179__$1 = state_34179;
var statearr_34236_34290 = state_34179__$1;
(statearr_34236_34290[(2)] = inst_34168);

(statearr_34236_34290[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34180 === (30))){
var inst_34143 = (state_34179[(16)]);
var inst_34145 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_34146 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_34145,inst_34143);
var state_34179__$1 = state_34179;
var statearr_34237_34291 = state_34179__$1;
(statearr_34237_34291[(2)] = inst_34146);

(statearr_34237_34291[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34180 === (10))){
var inst_34172 = (state_34179[(2)]);
var state_34179__$1 = state_34179;
var statearr_34238_34292 = state_34179__$1;
(statearr_34238_34292[(2)] = inst_34172);

(statearr_34238_34292[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34180 === (18))){
var inst_34077 = (state_34179[(19)]);
var inst_34104 = (state_34179[(21)]);
var inst_34134 = inst_34104.o;
var inst_34135 = cljs.core.contains_QMARK_(inst_34077,inst_34134);
var inst_34137 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34138 = [inst_34134];
var inst_34139 = (new cljs.core.PersistentVector(null,1,(5),inst_34137,inst_34138,null));
var inst_34140 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_34139);
var state_34179__$1 = (function (){var statearr_34239 = state_34179;
(statearr_34239[(17)] = inst_34135);

return statearr_34239;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34179__$1,(29),inst_34140);
} else {
if((state_val_34180 === (37))){
var inst_34149 = (state_34179[(18)]);
var inst_34097 = (state_34179[(9)]);
var inst_34155 = (state_34179[(22)]);
var inst_34160 = (inst_34097 + (1));
var inst_34161 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_34155,inst_34149) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_34155,inst_34149));
var state_34179__$1 = (function (){var statearr_34240 = state_34179;
(statearr_34240[(12)] = inst_34160);

return statearr_34240;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34179__$1,(39),inst_34161);
} else {
if((state_val_34180 === (8))){
var inst_34174 = (state_34179[(2)]);
var _ = (function (){var statearr_34241 = state_34179;
(statearr_34241[(4)] = cljs.core.rest((state_34179[(4)])));

return statearr_34241;
})();
var state_34179__$1 = state_34179;
var statearr_34242_34293 = state_34179__$1;
(statearr_34242_34293[(2)] = inst_34174);

(statearr_34242_34293[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__11410__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__11410__auto____0 = (function (){
var statearr_34243 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34243[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__11410__auto__);

(statearr_34243[(1)] = (1));

return statearr_34243;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__11410__auto____1 = (function (state_34179){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_34179);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e34244){var ex__11413__auto__ = e34244;
var statearr_34245_34294 = state_34179;
(statearr_34245_34294[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_34179[(4)]))){
var statearr_34246_34295 = state_34179;
(statearr_34246_34295[(1)] = cljs.core.first((state_34179[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34296 = state_34179;
state_34179 = G__34296;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__11410__auto__ = function(state_34179){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__11410__auto____1.call(this,state_34179);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__11410__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__11410__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_34247 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_34247[(6)] = c__11484__auto__);

return statearr_34247;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_34477){
var state_val_34478 = (state_34477[(1)]);
if((state_val_34478 === (7))){
var state_34477__$1 = state_34477;
var statearr_34479_34565 = state_34477__$1;
(statearr_34479_34565[(2)] = null);

(statearr_34479_34565[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (20))){
var inst_34335 = cljs.core.PersistentHashMap.EMPTY;
var state_34477__$1 = state_34477;
var statearr_34480_34566 = state_34477__$1;
(statearr_34480_34566[(2)] = inst_34335);

(statearr_34480_34566[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (27))){
var inst_34317 = (state_34477[(7)]);
var inst_34337 = (state_34477[(8)]);
var inst_34353 = (state_34477[(9)]);
var inst_34323 = (state_34477[(10)]);
var inst_34456 = (state_34477[(2)]);
var inst_34457 = (function (){var top_level_subject = inst_34317;
var select_spec = inst_34323;
var base_acc = inst_34337;
var acc_PLUS_refs = inst_34353;
var result = inst_34456;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4253__auto__ = (function (){var and__4251__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4251__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var and__4251__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4251__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4251__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_34458 = cljs.core.PersistentVector.EMPTY;
var inst_34459 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_34323);
var inst_34460 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_34459);
var inst_34461 = cljs.core.vals(inst_34460);
var inst_34462 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_34323);
var inst_34463 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_34462);
var inst_34464 = cljs.core.vals(inst_34463);
var inst_34465 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_34461,inst_34464);
var inst_34466 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_34457,inst_34458,inst_34465);
var inst_34468 = (function (){var top_level_subject = inst_34317;
var select_spec = inst_34323;
var base_acc = inst_34337;
var acc_PLUS_refs = inst_34353;
var result = inst_34456;
var sort_preds = inst_34466;
return (function (acc,p__34467){
var vec__34481 = p__34467;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34481,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34481,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34481,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34481,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_34469 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_34468,inst_34456,inst_34466);
var state_34477__$1 = state_34477;
var statearr_34484_34567 = state_34477__$1;
(statearr_34484_34567[(2)] = inst_34469);

(statearr_34484_34567[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (1))){
var state_34477__$1 = state_34477;
var statearr_34485_34568 = state_34477__$1;
(statearr_34485_34568[(2)] = null);

(statearr_34485_34568[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (24))){
var inst_34353 = (state_34477[(9)]);
var inst_34353__$1 = (state_34477[(2)]);
var inst_34354 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"p","p",151049309),flakes);
var inst_34355 = cljs.core.PersistentHashMap.EMPTY;
var inst_34356 = inst_34354;
var inst_34357 = inst_34353__$1;
var inst_34358 = inst_34355;
var state_34477__$1 = (function (){var statearr_34486 = state_34477;
(statearr_34486[(11)] = inst_34356);

(statearr_34486[(9)] = inst_34353__$1);

(statearr_34486[(12)] = inst_34357);

(statearr_34486[(13)] = inst_34358);

return statearr_34486;
})();
var statearr_34487_34569 = state_34477__$1;
(statearr_34487_34569[(2)] = null);

(statearr_34487_34569[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (39))){
var inst_34373 = (state_34477[(14)]);
var inst_34357 = (state_34477[(12)]);
var inst_34323 = (state_34477[(10)]);
var inst_34366 = (state_34477[(15)]);
var inst_34402 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34403 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_34357,inst_34323,inst_34366,inst_34373,false);
var state_34477__$1 = (function (){var statearr_34488 = state_34477;
(statearr_34488[(16)] = inst_34402);

return statearr_34488;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34477__$1,(42),inst_34403);
} else {
if((state_val_34478 === (46))){
var inst_34356 = (state_34477[(11)]);
var inst_34366 = (state_34477[(15)]);
var inst_34358 = (state_34477[(13)]);
var inst_34420 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34421 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_34422 = cljs.core.first(inst_34366);
var inst_34423 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_34422);
var inst_34424 = [inst_34423];
var inst_34425 = cljs.core.PersistentHashMap.fromArrays(inst_34421,inst_34424);
var inst_34426 = cljs.core.rest(inst_34356);
var inst_34427 = [inst_34425,inst_34426,inst_34358];
var inst_34428 = (new cljs.core.PersistentVector(null,3,(5),inst_34420,inst_34427,null));
var state_34477__$1 = state_34477;
var statearr_34489_34570 = state_34477__$1;
(statearr_34489_34570[(2)] = inst_34428);

(statearr_34489_34570[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (4))){
var inst_34297 = (state_34477[(2)]);
var state_34477__$1 = state_34477;
var statearr_34490_34571 = state_34477__$1;
(statearr_34490_34571[(2)] = inst_34297);

(statearr_34490_34571[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (15))){
var inst_34324 = (state_34477[(17)]);
var inst_34323 = (state_34477[(10)]);
var inst_34323__$1 = (state_34477[(2)]);
var inst_34324__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_34323__$1);
var state_34477__$1 = (function (){var statearr_34491 = state_34477;
(statearr_34491[(17)] = inst_34324__$1);

(statearr_34491[(10)] = inst_34323__$1);

return statearr_34491;
})();
if(cljs.core.truth_(inst_34324__$1)){
var statearr_34492_34572 = state_34477__$1;
(statearr_34492_34572[(1)] = (16));

} else {
var statearr_34493_34573 = state_34477__$1;
(statearr_34493_34573[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (48))){
var inst_34439 = (state_34477[(2)]);
var state_34477__$1 = state_34477;
var statearr_34494_34574 = state_34477__$1;
(statearr_34494_34574[(2)] = inst_34439);

(statearr_34494_34574[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (50))){
var state_34477__$1 = state_34477;
var statearr_34495_34575 = state_34477__$1;
(statearr_34495_34575[(2)] = null);

(statearr_34495_34575[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (21))){
var inst_34323 = (state_34477[(10)]);
var inst_34337 = (state_34477[(2)]);
var inst_34338 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34339 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_34340 = (new cljs.core.PersistentVector(null,2,(5),inst_34338,inst_34339,null));
var inst_34341 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_34323,inst_34340);
var state_34477__$1 = (function (){var statearr_34496 = state_34477;
(statearr_34496[(8)] = inst_34337);

return statearr_34496;
})();
if(cljs.core.truth_(inst_34341)){
var statearr_34497_34576 = state_34477__$1;
(statearr_34497_34576[(1)] = (22));

} else {
var statearr_34498_34577 = state_34477__$1;
(statearr_34498_34577[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (31))){
var inst_34372 = (state_34477[(18)]);
var inst_34357 = (state_34477[(12)]);
var inst_34366 = (state_34477[(15)]);
var inst_34376 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34377 = fluree.db.query.fql.flake__GT_recur(db,inst_34366,inst_34372,inst_34357,fuel,max_fuel,cache);
var state_34477__$1 = (function (){var statearr_34499 = state_34477;
(statearr_34499[(19)] = inst_34376);

return statearr_34499;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34477__$1,(34),inst_34377);
} else {
if((state_val_34478 === (32))){
var inst_34372 = (state_34477[(18)]);
var state_34477__$1 = state_34477;
if(cljs.core.truth_(inst_34372)){
var statearr_34500_34578 = state_34477__$1;
(statearr_34500_34578[(1)] = (35));

} else {
var statearr_34501_34579 = state_34477__$1;
(statearr_34501_34579[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (40))){
var inst_34323 = (state_34477[(10)]);
var inst_34413 = (state_34477[(20)]);
var inst_34412 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_34323);
var inst_34413__$1 = cljs.core.empty_QMARK_(inst_34412);
var state_34477__$1 = (function (){var statearr_34502 = state_34477;
(statearr_34502[(20)] = inst_34413__$1);

return statearr_34502;
})();
if(inst_34413__$1){
var statearr_34503_34580 = state_34477__$1;
(statearr_34503_34580[(1)] = (43));

} else {
var statearr_34504_34581 = state_34477__$1;
(statearr_34504_34581[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (33))){
var inst_34366 = (state_34477[(15)]);
var inst_34445 = (state_34477[(2)]);
var inst_34446 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34445,(0),null);
var inst_34447 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34445,(1),null);
var inst_34448 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34445,(2),null);
var inst_34449 = cljs.core.first(inst_34366);
var inst_34450 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_34449);
var inst_34451 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_34446,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_34450);
var inst_34356 = inst_34447;
var inst_34357 = inst_34451;
var inst_34358 = inst_34448;
var state_34477__$1 = (function (){var statearr_34505 = state_34477;
(statearr_34505[(11)] = inst_34356);

(statearr_34505[(12)] = inst_34357);

(statearr_34505[(13)] = inst_34358);

return statearr_34505;
})();
var statearr_34506_34582 = state_34477__$1;
(statearr_34506_34582[(2)] = null);

(statearr_34506_34582[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (13))){
var inst_34317 = (state_34477[(7)]);
var inst_34320 = fluree.db.query.fql.full_select_spec(db,cache,base_select_spec,inst_34317);
var state_34477__$1 = state_34477;
var statearr_34507_34583 = state_34477__$1;
(statearr_34507_34583[(2)] = inst_34320);

(statearr_34507_34583[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (22))){
var inst_34323 = (state_34477[(10)]);
var inst_34343 = cljs.core.first(flakes);
var inst_34344 = fluree.db.query.fql.s(inst_34343);
var inst_34345 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_34323);
var inst_34346 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_34344,inst_34345);
var state_34477__$1 = state_34477;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34477__$1,(25),inst_34346);
} else {
if((state_val_34478 === (36))){
var inst_34323 = (state_34477[(10)]);
var inst_34400 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_34323);
var state_34477__$1 = state_34477;
if(cljs.core.truth_(inst_34400)){
var statearr_34508_34584 = state_34477__$1;
(statearr_34508_34584[(1)] = (39));

} else {
var statearr_34509_34585 = state_34477__$1;
(statearr_34509_34585[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (41))){
var inst_34441 = (state_34477[(2)]);
var state_34477__$1 = state_34477;
var statearr_34510_34586 = state_34477__$1;
(statearr_34510_34586[(2)] = inst_34441);

(statearr_34510_34586[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (43))){
var inst_34323 = (state_34477[(10)]);
var inst_34415 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_34323);
var state_34477__$1 = state_34477;
var statearr_34511_34587 = state_34477__$1;
(statearr_34511_34587[(2)] = inst_34415);

(statearr_34511_34587[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (29))){
var inst_34372 = (state_34477[(18)]);
var inst_34356 = (state_34477[(11)]);
var inst_34323 = (state_34477[(10)]);
var inst_34366 = (state_34477[(15)]);
var inst_34366__$1 = cljs.core.first(inst_34356);
var inst_34367 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34368 = cljs.core.first(inst_34366__$1);
var inst_34369 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_34368);
var inst_34370 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_34369];
var inst_34371 = (new cljs.core.PersistentVector(null,3,(5),inst_34367,inst_34370,null));
var inst_34372__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_34323,inst_34371);
var inst_34373 = fluree.db.query.fql.component_follow_QMARK_(inst_34372__$1,inst_34323);
var inst_34374 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_34372__$1);
var state_34477__$1 = (function (){var statearr_34512 = state_34477;
(statearr_34512[(18)] = inst_34372__$1);

(statearr_34512[(14)] = inst_34373);

(statearr_34512[(15)] = inst_34366__$1);

return statearr_34512;
})();
if(cljs.core.truth_(inst_34374)){
var statearr_34513_34588 = state_34477__$1;
(statearr_34513_34588[(1)] = (31));

} else {
var statearr_34514_34589 = state_34477__$1;
(statearr_34514_34589[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (44))){
var inst_34413 = (state_34477[(20)]);
var state_34477__$1 = state_34477;
var statearr_34515_34590 = state_34477__$1;
(statearr_34515_34590[(2)] = inst_34413);

(statearr_34515_34590[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (6))){
var state_34477__$1 = state_34477;
var statearr_34516_34591 = state_34477__$1;
(statearr_34516_34591[(2)] = null);

(statearr_34516_34591[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (28))){
var inst_34357 = (state_34477[(12)]);
var state_34477__$1 = state_34477;
var statearr_34517_34592 = state_34477__$1;
(statearr_34517_34592[(2)] = inst_34357);

(statearr_34517_34592[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (51))){
var inst_34437 = (state_34477[(2)]);
var state_34477__$1 = state_34477;
var statearr_34518_34593 = state_34477__$1;
(statearr_34518_34593[(2)] = inst_34437);

(statearr_34518_34593[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (25))){
var inst_34337 = (state_34477[(8)]);
var inst_34348 = (state_34477[(2)]);
var inst_34349 = fluree.db.util.async.throw_err(inst_34348);
var inst_34350 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_34337,inst_34349], 0));
var state_34477__$1 = state_34477;
var statearr_34519_34594 = state_34477__$1;
(statearr_34519_34594[(2)] = inst_34350);

(statearr_34519_34594[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (34))){
var inst_34356 = (state_34477[(11)]);
var inst_34376 = (state_34477[(19)]);
var inst_34358 = (state_34477[(13)]);
var inst_34379 = (state_34477[(2)]);
var inst_34380 = fluree.db.util.async.throw_err(inst_34379);
var inst_34381 = cljs.core.rest(inst_34356);
var inst_34382 = [inst_34380,inst_34381,inst_34358];
var inst_34383 = (new cljs.core.PersistentVector(null,3,(5),inst_34376,inst_34382,null));
var state_34477__$1 = state_34477;
var statearr_34520_34595 = state_34477__$1;
(statearr_34520_34595[(2)] = inst_34383);

(statearr_34520_34595[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (17))){
var inst_34323 = (state_34477[(10)]);
var inst_34327 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_34323);
var state_34477__$1 = state_34477;
var statearr_34522_34596 = state_34477__$1;
(statearr_34522_34596[(2)] = inst_34327);

(statearr_34522_34596[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (3))){
var inst_34475 = (state_34477[(2)]);
var state_34477__$1 = state_34477;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34477__$1,inst_34475);
} else {
if((state_val_34478 === (12))){
var _ = (function (){var statearr_34523 = state_34477;
(statearr_34523[(4)] = cljs.core.rest((state_34477[(4)])));

return statearr_34523;
})();
var state_34477__$1 = state_34477;
var ex34521 = (state_34477__$1[(2)]);
var statearr_34524_34597 = state_34477__$1;
(statearr_34524_34597[(5)] = ex34521);


var statearr_34525_34598 = state_34477__$1;
(statearr_34525_34598[(1)] = (11));

(statearr_34525_34598[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (2))){
var _ = (function (){var statearr_34526 = state_34477;
(statearr_34526[(4)] = cljs.core.cons((5),(state_34477[(4)])));

return statearr_34526;
})();
var inst_34303 = cljs.core.not_empty(flakes);
var state_34477__$1 = state_34477;
if(cljs.core.truth_(inst_34303)){
var statearr_34527_34599 = state_34477__$1;
(statearr_34527_34599[(1)] = (6));

} else {
var statearr_34528_34600 = state_34477__$1;
(statearr_34528_34600[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (23))){
var inst_34337 = (state_34477[(8)]);
var state_34477__$1 = state_34477;
var statearr_34529_34601 = state_34477__$1;
(statearr_34529_34601[(2)] = inst_34337);

(statearr_34529_34601[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (47))){
var state_34477__$1 = state_34477;
var statearr_34530_34602 = state_34477__$1;
(statearr_34530_34602[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (35))){
var inst_34372 = (state_34477[(18)]);
var inst_34373 = (state_34477[(14)]);
var inst_34357 = (state_34477[(12)]);
var inst_34366 = (state_34477[(15)]);
var inst_34358 = (state_34477[(13)]);
var inst_34389 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_34357,inst_34372,inst_34366,inst_34373,false,inst_34358);
var state_34477__$1 = state_34477;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34477__$1,(38),inst_34389);
} else {
if((state_val_34478 === (19))){
var inst_34317 = (state_34477[(7)]);
var inst_34331 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_34332 = [inst_34317];
var inst_34333 = cljs.core.PersistentHashMap.fromArrays(inst_34331,inst_34332);
var state_34477__$1 = state_34477;
var statearr_34532_34603 = state_34477__$1;
(statearr_34532_34603[(2)] = inst_34333);

(statearr_34532_34603[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (11))){
var inst_34305 = (state_34477[(2)]);
var inst_34306 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_34305], 0));
var inst_34307 = (function(){throw inst_34305})();
var state_34477__$1 = (function (){var statearr_34534 = state_34477;
(statearr_34534[(21)] = inst_34306);

return statearr_34534;
})();
var statearr_34535_34604 = state_34477__$1;
(statearr_34535_34604[(2)] = inst_34307);

(statearr_34535_34604[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (9))){
var _ = (function (){var statearr_34536 = state_34477;
(statearr_34536[(4)] = cljs.core.cons((12),(state_34477[(4)])));

return statearr_34536;
})();
var inst_34313 = cljs.core.first(flakes);
var inst_34314 = fluree.db.query.fql.s(inst_34313);
var ___$1 = (function (){var statearr_34537 = state_34477;
(statearr_34537[(4)] = cljs.core.rest((state_34477[(4)])));

return statearr_34537;
})();
var state_34477__$1 = state_34477;
var statearr_34538_34605 = state_34477__$1;
(statearr_34538_34605[(2)] = inst_34314);

(statearr_34538_34605[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (5))){
var _ = (function (){var statearr_34539 = state_34477;
(statearr_34539[(4)] = cljs.core.rest((state_34477[(4)])));

return statearr_34539;
})();
var state_34477__$1 = state_34477;
var ex34533 = (state_34477__$1[(2)]);
var statearr_34540_34606 = state_34477__$1;
(statearr_34540_34606[(5)] = ex34533);


if((ex34533 instanceof Error)){
var statearr_34541_34607 = state_34477__$1;
(statearr_34541_34607[(1)] = (4));

(statearr_34541_34607[(5)] = null);

} else {
throw ex34533;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (14))){
var state_34477__$1 = state_34477;
var statearr_34542_34608 = state_34477__$1;
(statearr_34542_34608[(2)] = base_select_spec);

(statearr_34542_34608[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (45))){
var inst_34418 = (state_34477[(2)]);
var state_34477__$1 = state_34477;
if(cljs.core.truth_(inst_34418)){
var statearr_34543_34609 = state_34477__$1;
(statearr_34543_34609[(1)] = (46));

} else {
var statearr_34544_34610 = state_34477__$1;
(statearr_34544_34610[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (26))){
var inst_34356 = (state_34477[(11)]);
var inst_34360 = cljs.core.empty_QMARK_(inst_34356);
var state_34477__$1 = state_34477;
if(inst_34360){
var statearr_34545_34611 = state_34477__$1;
(statearr_34545_34611[(1)] = (28));

} else {
var statearr_34546_34612 = state_34477__$1;
(statearr_34546_34612[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (16))){
var inst_34324 = (state_34477[(17)]);
var state_34477__$1 = state_34477;
var statearr_34547_34613 = state_34477__$1;
(statearr_34547_34613[(2)] = inst_34324);

(statearr_34547_34613[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (38))){
var inst_34356 = (state_34477[(11)]);
var inst_34391 = (state_34477[(2)]);
var inst_34392 = fluree.db.util.async.throw_err(inst_34391);
var inst_34393 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34392,(0),null);
var inst_34394 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34392,(1),null);
var inst_34395 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34396 = cljs.core.rest(inst_34356);
var inst_34397 = [inst_34393,inst_34396,inst_34394];
var inst_34398 = (new cljs.core.PersistentVector(null,3,(5),inst_34395,inst_34397,null));
var state_34477__$1 = state_34477;
var statearr_34548_34614 = state_34477__$1;
(statearr_34548_34614[(2)] = inst_34398);

(statearr_34548_34614[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (30))){
var inst_34454 = (state_34477[(2)]);
var state_34477__$1 = state_34477;
var statearr_34549_34615 = state_34477__$1;
(statearr_34549_34615[(2)] = inst_34454);

(statearr_34549_34615[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (10))){
var inst_34317 = (state_34477[(2)]);
var inst_34318 = fluree.db.query.fql.has_ns_lookups_QMARK_(base_select_spec);
var state_34477__$1 = (function (){var statearr_34550 = state_34477;
(statearr_34550[(7)] = inst_34317);

return statearr_34550;
})();
if(cljs.core.truth_(inst_34318)){
var statearr_34551_34616 = state_34477__$1;
(statearr_34551_34616[(1)] = (13));

} else {
var statearr_34552_34617 = state_34477__$1;
(statearr_34552_34617[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (18))){
var inst_34329 = (state_34477[(2)]);
var state_34477__$1 = state_34477;
if(cljs.core.truth_(inst_34329)){
var statearr_34553_34618 = state_34477__$1;
(statearr_34553_34618[(1)] = (19));

} else {
var statearr_34554_34619 = state_34477__$1;
(statearr_34554_34619[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (42))){
var inst_34356 = (state_34477[(11)]);
var inst_34402 = (state_34477[(16)]);
var inst_34358 = (state_34477[(13)]);
var inst_34405 = (state_34477[(2)]);
var inst_34406 = fluree.db.util.async.throw_err(inst_34405);
var inst_34407 = cljs.core.first(inst_34406);
var inst_34408 = cljs.core.rest(inst_34356);
var inst_34409 = [inst_34407,inst_34408,inst_34358];
var inst_34410 = (new cljs.core.PersistentVector(null,3,(5),inst_34402,inst_34409,null));
var state_34477__$1 = state_34477;
var statearr_34555_34620 = state_34477__$1;
(statearr_34555_34620[(2)] = inst_34410);

(statearr_34555_34620[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (37))){
var inst_34443 = (state_34477[(2)]);
var state_34477__$1 = state_34477;
var statearr_34556_34621 = state_34477__$1;
(statearr_34556_34621[(2)] = inst_34443);

(statearr_34556_34621[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (8))){
var inst_34472 = (state_34477[(2)]);
var _ = (function (){var statearr_34557 = state_34477;
(statearr_34557[(4)] = cljs.core.rest((state_34477[(4)])));

return statearr_34557;
})();
var state_34477__$1 = state_34477;
var statearr_34558_34622 = state_34477__$1;
(statearr_34558_34622[(2)] = inst_34472);

(statearr_34558_34622[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34478 === (49))){
var inst_34356 = (state_34477[(11)]);
var inst_34357 = (state_34477[(12)]);
var inst_34358 = (state_34477[(13)]);
var inst_34431 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34432 = cljs.core.rest(inst_34356);
var inst_34433 = [inst_34357,inst_34432,inst_34358];
var inst_34434 = (new cljs.core.PersistentVector(null,3,(5),inst_34431,inst_34433,null));
var state_34477__$1 = state_34477;
var statearr_34559_34623 = state_34477__$1;
(statearr_34559_34623[(2)] = inst_34434);

(statearr_34559_34623[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__11410__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__11410__auto____0 = (function (){
var statearr_34560 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34560[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__11410__auto__);

(statearr_34560[(1)] = (1));

return statearr_34560;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__11410__auto____1 = (function (state_34477){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_34477);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e34561){var ex__11413__auto__ = e34561;
var statearr_34562_34624 = state_34477;
(statearr_34562_34624[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_34477[(4)]))){
var statearr_34563_34625 = state_34477;
(statearr_34563_34625[(1)] = cljs.core.first((state_34477[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34626 = state_34477;
state_34477 = G__34626;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__11410__auto__ = function(state_34477){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__11410__auto____1.call(this,state_34477);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__11410__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__11410__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_34564 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_34564[(6)] = c__11484__auto__);

return statearr_34564;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__34629 = arguments.length;
switch (G__34629) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_34671){
var state_val_34672 = (state_34671[(1)]);
if((state_val_34672 === (7))){
var inst_34637 = (state_34671[(7)]);
var state_34671__$1 = state_34671;
var statearr_34673_34703 = state_34671__$1;
(statearr_34673_34703[(2)] = inst_34637);

(statearr_34673_34703[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34672 === (1))){
var state_34671__$1 = state_34671;
var statearr_34674_34704 = state_34671__$1;
(statearr_34674_34704[(2)] = null);

(statearr_34674_34704[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34672 === (4))){
var inst_34630 = (state_34671[(2)]);
var state_34671__$1 = state_34671;
var statearr_34675_34705 = state_34671__$1;
(statearr_34675_34705[(2)] = inst_34630);

(statearr_34675_34705[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34672 === (15))){
var inst_34665 = (state_34671[(2)]);
var inst_34666 = fluree.db.util.async.throw_err(inst_34665);
var _ = (function (){var statearr_34676 = state_34671;
(statearr_34676[(4)] = cljs.core.rest((state_34671[(4)])));

return statearr_34676;
})();
var state_34671__$1 = state_34671;
var statearr_34677_34706 = state_34671__$1;
(statearr_34677_34706[(2)] = inst_34666);

(statearr_34677_34706[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34672 === (13))){
var inst_34649 = (state_34671[(8)]);
var state_34671__$1 = state_34671;
var statearr_34678_34707 = state_34671__$1;
(statearr_34678_34707[(2)] = inst_34649);

(statearr_34678_34707[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34672 === (6))){
var inst_34637 = (state_34671[(7)]);
var inst_34639 = fluree.db.query.fql.fuel_flakes_transducer(fuel,max_fuel);
var inst_34640 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_34637,inst_34639);
var state_34671__$1 = state_34671;
var statearr_34679_34708 = state_34671__$1;
(statearr_34679_34708[(2)] = inst_34640);

(statearr_34679_34708[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34672 === (3))){
var inst_34669 = (state_34671[(2)]);
var state_34671__$1 = state_34671;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34671__$1,inst_34669);
} else {
if((state_val_34672 === (12))){
var inst_34649 = (state_34671[(8)]);
var inst_34651 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_34652 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_34649,inst_34651);
var state_34671__$1 = state_34671;
var statearr_34680_34709 = state_34671__$1;
(statearr_34680_34709[(2)] = inst_34652);

(statearr_34680_34709[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34672 === (2))){
var _ = (function (){var statearr_34681 = state_34671;
(statearr_34681[(4)] = cljs.core.cons((5),(state_34671[(4)])));

return statearr_34681;
})();
var inst_34637 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_34671__$1 = (function (){var statearr_34682 = state_34671;
(statearr_34682[(7)] = inst_34637);

return statearr_34682;
})();
if(cljs.core.truth_(fuel)){
var statearr_34683_34710 = state_34671__$1;
(statearr_34683_34710[(1)] = (6));

} else {
var statearr_34684_34711 = state_34671__$1;
(statearr_34684_34711[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34672 === (11))){
var inst_34649 = (state_34671[(2)]);
var state_34671__$1 = (function (){var statearr_34686 = state_34671;
(statearr_34686[(8)] = inst_34649);

return statearr_34686;
})();
if(cljs.core.truth_(limit)){
var statearr_34687_34712 = state_34671__$1;
(statearr_34687_34712[(1)] = (12));

} else {
var statearr_34688_34713 = state_34671__$1;
(statearr_34688_34713[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34672 === (9))){
var inst_34643 = (state_34671[(9)]);
var inst_34645 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_34646 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_34643,inst_34645);
var state_34671__$1 = state_34671;
var statearr_34689_34714 = state_34671__$1;
(statearr_34689_34714[(2)] = inst_34646);

(statearr_34689_34714[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34672 === (5))){
var _ = (function (){var statearr_34690 = state_34671;
(statearr_34690[(4)] = cljs.core.rest((state_34671[(4)])));

return statearr_34690;
})();
var state_34671__$1 = state_34671;
var ex34685 = (state_34671__$1[(2)]);
var statearr_34691_34715 = state_34671__$1;
(statearr_34691_34715[(5)] = ex34685);


if((ex34685 instanceof Error)){
var statearr_34692_34716 = state_34671__$1;
(statearr_34692_34716[(1)] = (4));

(statearr_34692_34716[(5)] = null);

} else {
throw ex34685;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34672 === (14))){
var inst_34655 = (state_34671[(2)]);
var inst_34656 = (function (){return (function (x){
var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (cljs.core.deref(fuel) >= max_fuel);
} else {
return and__4251__auto__;
}
});
})();
var inst_34657 = cljs.core.halt_when.cljs$core$IFn$_invoke$arity$1(inst_34656);
var inst_34658 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_34655,inst_34657);
var inst_34659 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_34658,flakes);
var inst_34660 = cljs.core.PersistentVector.EMPTY;
var inst_34661 = (function (){var xf = inst_34658;
var flakes_by_sub = inst_34659;
return (function (p1__34627_SHARP_){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,p1__34627_SHARP_);
});
})();
var inst_34662 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_34661,inst_34659);
var inst_34663 = fluree.db.util.async.merge_into_QMARK_(inst_34660,inst_34662);
var state_34671__$1 = state_34671;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34671__$1,(15),inst_34663);
} else {
if((state_val_34672 === (10))){
var inst_34643 = (state_34671[(9)]);
var state_34671__$1 = state_34671;
var statearr_34693_34717 = state_34671__$1;
(statearr_34693_34717[(2)] = inst_34643);

(statearr_34693_34717[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34672 === (8))){
var inst_34643 = (state_34671[(2)]);
var state_34671__$1 = (function (){var statearr_34694 = state_34671;
(statearr_34694[(9)] = inst_34643);

return statearr_34694;
})();
if(cljs.core.truth_(offset)){
var statearr_34695_34718 = state_34671__$1;
(statearr_34695_34718[(1)] = (9));

} else {
var statearr_34696_34719 = state_34671__$1;
(statearr_34696_34719[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__11410__auto__ = null;
var fluree$db$query$fql$state_machine__11410__auto____0 = (function (){
var statearr_34697 = [null,null,null,null,null,null,null,null,null,null];
(statearr_34697[(0)] = fluree$db$query$fql$state_machine__11410__auto__);

(statearr_34697[(1)] = (1));

return statearr_34697;
});
var fluree$db$query$fql$state_machine__11410__auto____1 = (function (state_34671){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_34671);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e34698){var ex__11413__auto__ = e34698;
var statearr_34699_34720 = state_34671;
(statearr_34699_34720[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_34671[(4)]))){
var statearr_34700_34721 = state_34671;
(statearr_34700_34721[(1)] = cljs.core.first((state_34671[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34722 = state_34671;
state_34671 = G__34722;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__11410__auto__ = function(state_34671){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__11410__auto____1.call(this,state_34671);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__11410__auto____0;
fluree$db$query$fql$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__11410__auto____1;
return fluree$db$query$fql$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_34701 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_34701[(6)] = c__11484__auto__);

return statearr_34701;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__34724 = arguments.length;
switch (G__34724) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_34810){
var state_val_34811 = (state_34810[(1)]);
if((state_val_34811 === (7))){
var inst_34805 = (state_34810[(2)]);
var _ = (function (){var statearr_34813 = state_34810;
(statearr_34813[(4)] = cljs.core.rest((state_34810[(4)])));

return statearr_34813;
})();
var state_34810__$1 = state_34810;
var statearr_34814_34866 = state_34810__$1;
(statearr_34814_34866[(2)] = inst_34805);

(statearr_34814_34866[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (20))){
var inst_34752 = (state_34810[(7)]);
var inst_34745 = (state_34810[(8)]);
var inst_34744 = (state_34810[(9)]);
var inst_34773 = (inst_34744 + (1));
var tmp34812 = inst_34745;
var inst_34743 = inst_34752;
var inst_34744__$1 = inst_34773;
var inst_34745__$1 = tmp34812;
var state_34810__$1 = (function (){var statearr_34815 = state_34810;
(statearr_34815[(10)] = inst_34743);

(statearr_34815[(8)] = inst_34745__$1);

(statearr_34815[(9)] = inst_34744__$1);

return statearr_34815;
})();
var statearr_34816_34867 = state_34810__$1;
(statearr_34816_34867[(2)] = null);

(statearr_34816_34867[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (27))){
var inst_34783 = (state_34810[(11)]);
var inst_34785 = cljs.core.count(inst_34783);
var inst_34786 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_34785);
var state_34810__$1 = state_34810;
var statearr_34817_34868 = state_34810__$1;
(statearr_34817_34868[(2)] = inst_34786);

(statearr_34817_34868[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (1))){
var state_34810__$1 = state_34810;
var statearr_34818_34869 = state_34810__$1;
(statearr_34818_34869[(2)] = null);

(statearr_34818_34869[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (24))){
var state_34810__$1 = state_34810;
var statearr_34819_34870 = state_34810__$1;
(statearr_34819_34870[(2)] = null);

(statearr_34819_34870[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (4))){
var inst_34725 = (state_34810[(2)]);
var state_34810__$1 = state_34810;
var statearr_34820_34871 = state_34810__$1;
(statearr_34820_34871[(2)] = inst_34725);

(statearr_34820_34871[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (15))){
var inst_34766 = (state_34810[(12)]);
var inst_34766__$1 = offset;
var state_34810__$1 = (function (){var statearr_34821 = state_34810;
(statearr_34821[(12)] = inst_34766__$1);

return statearr_34821;
})();
if(cljs.core.truth_(inst_34766__$1)){
var statearr_34822_34872 = state_34810__$1;
(statearr_34822_34872[(1)] = (17));

} else {
var statearr_34823_34873 = state_34810__$1;
(statearr_34823_34873[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (21))){
var state_34810__$1 = state_34810;
var statearr_34824_34874 = state_34810__$1;
(statearr_34824_34874[(1)] = (23));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (13))){
var inst_34761 = (state_34810[(2)]);
var state_34810__$1 = state_34810;
var statearr_34826_34875 = state_34810__$1;
(statearr_34826_34875[(2)] = inst_34761);

(statearr_34826_34875[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (22))){
var inst_34801 = (state_34810[(2)]);
var state_34810__$1 = state_34810;
var statearr_34827_34876 = state_34810__$1;
(statearr_34827_34876[(2)] = inst_34801);

(statearr_34827_34876[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (29))){
var inst_34744 = (state_34810[(9)]);
var inst_34783 = (state_34810[(11)]);
var inst_34789 = (state_34810[(2)]);
var inst_34790 = (inst_34744 + (1));
var inst_34791 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,inst_34783);
var state_34810__$1 = (function (){var statearr_34828 = state_34810;
(statearr_34828[(13)] = inst_34789);

(statearr_34828[(14)] = inst_34790);

return statearr_34828;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34810__$1,(30),inst_34791);
} else {
if((state_val_34811 === (6))){
var inst_34751 = (state_34810[(15)]);
var inst_34753 = (state_34810[(16)]);
var inst_34743 = (state_34810[(10)]);
var inst_34750 = cljs.core.seq(inst_34743);
var inst_34751__$1 = cljs.core.first(inst_34750);
var inst_34752 = cljs.core.next(inst_34750);
var inst_34753__$1 = (inst_34751__$1 == null);
var state_34810__$1 = (function (){var statearr_34829 = state_34810;
(statearr_34829[(15)] = inst_34751__$1);

(statearr_34829[(16)] = inst_34753__$1);

(statearr_34829[(7)] = inst_34752);

return statearr_34829;
})();
if(cljs.core.truth_(inst_34753__$1)){
var statearr_34830_34877 = state_34810__$1;
(statearr_34830_34877[(1)] = (8));

} else {
var statearr_34831_34878 = state_34810__$1;
(statearr_34831_34878[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (28))){
var state_34810__$1 = state_34810;
var statearr_34832_34879 = state_34810__$1;
(statearr_34832_34879[(2)] = null);

(statearr_34832_34879[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (25))){
var inst_34799 = (state_34810[(2)]);
var state_34810__$1 = state_34810;
var statearr_34833_34880 = state_34810__$1;
(statearr_34833_34880[(2)] = inst_34799);

(statearr_34833_34880[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (17))){
var inst_34744 = (state_34810[(9)]);
var inst_34768 = (inst_34744 < offset);
var state_34810__$1 = state_34810;
var statearr_34834_34881 = state_34810__$1;
(statearr_34834_34881[(2)] = inst_34768);

(statearr_34834_34881[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (3))){
var inst_34808 = (state_34810[(2)]);
var state_34810__$1 = state_34810;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34810__$1,inst_34808);
} else {
if((state_val_34811 === (12))){
var inst_34756 = (state_34810[(17)]);
var state_34810__$1 = state_34810;
var statearr_34835_34882 = state_34810__$1;
(statearr_34835_34882[(2)] = inst_34756);

(statearr_34835_34882[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (2))){
var _ = (function (){var statearr_34836 = state_34810;
(statearr_34836[(4)] = cljs.core.cons((5),(state_34810[(4)])));

return statearr_34836;
})();
var inst_34738 = subjects;
var inst_34739 = cljs.core.seq(inst_34738);
var inst_34740 = cljs.core.first(inst_34739);
var inst_34741 = cljs.core.next(inst_34739);
var inst_34742 = cljs.core.PersistentVector.EMPTY;
var inst_34743 = inst_34738;
var inst_34744 = (0);
var inst_34745 = inst_34742;
var state_34810__$1 = (function (){var statearr_34837 = state_34810;
(statearr_34837[(18)] = inst_34740);

(statearr_34837[(19)] = inst_34741);

(statearr_34837[(10)] = inst_34743);

(statearr_34837[(8)] = inst_34745);

(statearr_34837[(9)] = inst_34744);

return statearr_34837;
})();
var statearr_34838_34883 = state_34810__$1;
(statearr_34838_34883[(2)] = null);

(statearr_34838_34883[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (23))){
var inst_34751 = (state_34810[(15)]);
var inst_34777 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34778 = [inst_34751];
var inst_34779 = (new cljs.core.PersistentVector(null,1,(5),inst_34777,inst_34778,null));
var inst_34780 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_34779);
var state_34810__$1 = state_34810;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34810__$1,(26),inst_34780);
} else {
if((state_val_34811 === (19))){
var inst_34771 = (state_34810[(2)]);
var state_34810__$1 = state_34810;
if(cljs.core.truth_(inst_34771)){
var statearr_34839_34884 = state_34810__$1;
(statearr_34839_34884[(1)] = (20));

} else {
var statearr_34840_34885 = state_34810__$1;
(statearr_34840_34885[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (11))){
var inst_34744 = (state_34810[(9)]);
var inst_34758 = (inst_34744 > limit);
var state_34810__$1 = state_34810;
var statearr_34842_34886 = state_34810__$1;
(statearr_34842_34886[(2)] = inst_34758);

(statearr_34842_34886[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (9))){
var inst_34756 = (state_34810[(17)]);
var inst_34756__$1 = limit;
var state_34810__$1 = (function (){var statearr_34843 = state_34810;
(statearr_34843[(17)] = inst_34756__$1);

return statearr_34843;
})();
if(cljs.core.truth_(inst_34756__$1)){
var statearr_34844_34887 = state_34810__$1;
(statearr_34844_34887[(1)] = (11));

} else {
var statearr_34845_34888 = state_34810__$1;
(statearr_34845_34888[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (5))){
var _ = (function (){var statearr_34846 = state_34810;
(statearr_34846[(4)] = cljs.core.rest((state_34810[(4)])));

return statearr_34846;
})();
var state_34810__$1 = state_34810;
var ex34841 = (state_34810__$1[(2)]);
var statearr_34847_34889 = state_34810__$1;
(statearr_34847_34889[(5)] = ex34841);


if((ex34841 instanceof Error)){
var statearr_34848_34890 = state_34810__$1;
(statearr_34848_34890[(1)] = (4));

(statearr_34848_34890[(5)] = null);

} else {
throw ex34841;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (14))){
var inst_34745 = (state_34810[(8)]);
var state_34810__$1 = state_34810;
var statearr_34849_34891 = state_34810__$1;
(statearr_34849_34891[(2)] = inst_34745);

(statearr_34849_34891[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (26))){
var inst_34782 = (state_34810[(2)]);
var inst_34783 = fluree.db.util.async.throw_err(inst_34782);
var state_34810__$1 = (function (){var statearr_34850 = state_34810;
(statearr_34850[(11)] = inst_34783);

return statearr_34850;
})();
if(cljs.core.truth_(fuel)){
var statearr_34851_34892 = state_34810__$1;
(statearr_34851_34892[(1)] = (27));

} else {
var statearr_34852_34893 = state_34810__$1;
(statearr_34852_34893[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (16))){
var inst_34803 = (state_34810[(2)]);
var state_34810__$1 = state_34810;
var statearr_34853_34894 = state_34810__$1;
(statearr_34853_34894[(2)] = inst_34803);

(statearr_34853_34894[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (30))){
var inst_34790 = (state_34810[(14)]);
var inst_34752 = (state_34810[(7)]);
var inst_34745 = (state_34810[(8)]);
var inst_34793 = (state_34810[(2)]);
var inst_34794 = fluree.db.util.async.throw_err(inst_34793);
var inst_34795 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_34745,inst_34794);
var inst_34743 = inst_34752;
var inst_34744 = inst_34790;
var inst_34745__$1 = inst_34795;
var state_34810__$1 = (function (){var statearr_34854 = state_34810;
(statearr_34854[(10)] = inst_34743);

(statearr_34854[(8)] = inst_34745__$1);

(statearr_34854[(9)] = inst_34744);

return statearr_34854;
})();
var statearr_34855_34895 = state_34810__$1;
(statearr_34855_34895[(2)] = null);

(statearr_34855_34895[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (10))){
var inst_34763 = (state_34810[(2)]);
var state_34810__$1 = state_34810;
if(cljs.core.truth_(inst_34763)){
var statearr_34856_34896 = state_34810__$1;
(statearr_34856_34896[(1)] = (14));

} else {
var statearr_34857_34897 = state_34810__$1;
(statearr_34857_34897[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (18))){
var inst_34766 = (state_34810[(12)]);
var state_34810__$1 = state_34810;
var statearr_34858_34898 = state_34810__$1;
(statearr_34858_34898[(2)] = inst_34766);

(statearr_34858_34898[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (8))){
var inst_34753 = (state_34810[(16)]);
var state_34810__$1 = state_34810;
var statearr_34859_34899 = state_34810__$1;
(statearr_34859_34899[(2)] = inst_34753);

(statearr_34859_34899[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__11410__auto__ = null;
var fluree$db$query$fql$state_machine__11410__auto____0 = (function (){
var statearr_34860 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34860[(0)] = fluree$db$query$fql$state_machine__11410__auto__);

(statearr_34860[(1)] = (1));

return statearr_34860;
});
var fluree$db$query$fql$state_machine__11410__auto____1 = (function (state_34810){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_34810);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e34861){var ex__11413__auto__ = e34861;
var statearr_34862_34900 = state_34810;
(statearr_34862_34900[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_34810[(4)]))){
var statearr_34863_34901 = state_34810;
(statearr_34863_34901[(1)] = cljs.core.first((state_34810[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34902 = state_34810;
state_34810 = G__34902;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__11410__auto__ = function(state_34810){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__11410__auto____1.call(this,state_34810);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__11410__auto____0;
fluree$db$query$fql$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__11410__auto____1;
return fluree$db$query$fql$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_34864 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_34864[(6)] = c__11484__auto__);

return statearr_34864;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4253__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tag","tag",-1290361223),fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"type","type",1174270348),p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__34904 = arguments.length;
switch (G__34904) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4(db,where_clause,null,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4 = (function (db,where_clause,default_collection,p__34905){
var map__34906 = p__34905;
var map__34906__$1 = cljs.core.__destructure_map(map__34906);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34906__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34906__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_35170){
var state_val_35171 = (state_35170[(1)]);
if((state_val_35171 === (65))){
var inst_35133 = (state_35170[(7)]);
var inst_35133__$1 = (state_35170[(2)]);
var state_35170__$1 = (function (){var statearr_35172 = state_35170;
(statearr_35172[(7)] = inst_35133__$1);

return statearr_35172;
})();
if(cljs.core.truth_(inst_35133__$1)){
var statearr_35173_35291 = state_35170__$1;
(statearr_35173_35291[(1)] = (66));

} else {
var statearr_35174_35292 = state_35170__$1;
(statearr_35174_35292[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (70))){
var inst_35136 = (state_35170[(8)]);
var state_35170__$1 = state_35170;
var statearr_35175_35293 = state_35170__$1;
(statearr_35175_35293[(2)] = inst_35136);

(statearr_35175_35293[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (62))){
var inst_35124 = (state_35170[(2)]);
var state_35170__$1 = state_35170;
var statearr_35176_35294 = state_35170__$1;
(statearr_35176_35294[(2)] = inst_35124);

(statearr_35176_35294[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (74))){
var inst_35143 = (state_35170[(2)]);
var state_35170__$1 = state_35170;
var statearr_35177_35295 = state_35170__$1;
(statearr_35177_35295[(2)] = inst_35143);

(statearr_35177_35295[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (7))){
var inst_34919 = (state_35170[(9)]);
var state_35170__$1 = state_35170;
var statearr_35178_35296 = state_35170__$1;
(statearr_35178_35296[(2)] = inst_34919);

(statearr_35178_35296[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (59))){
var inst_34948 = (state_35170[(10)]);
var inst_35116 = cljs.core.empty_QMARK_(inst_34948);
var state_35170__$1 = state_35170;
if(inst_35116){
var statearr_35179_35297 = state_35170__$1;
(statearr_35179_35297[(1)] = (60));

} else {
var statearr_35180_35298 = state_35170__$1;
(statearr_35180_35298[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (20))){
var state_35170__$1 = state_35170;
if(cljs.core.truth_(offset)){
var statearr_35181_35299 = state_35170__$1;
(statearr_35181_35299[(1)] = (23));

} else {
var statearr_35182_35300 = state_35170__$1;
(statearr_35182_35300[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (72))){
var inst_35113 = (state_35170[(11)]);
var inst_34933 = (state_35170[(12)]);
var inst_35139 = cljs.core.count(inst_35113);
var inst_35140 = (inst_35139 > inst_34933);
var state_35170__$1 = state_35170;
var statearr_35183_35301 = state_35170__$1;
(statearr_35183_35301[(2)] = inst_35140);

(statearr_35183_35301[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (58))){
var inst_35113 = (state_35170[(11)]);
var inst_34948 = (state_35170[(10)]);
var inst_35114 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_34948,inst_35113);
var state_35170__$1 = state_35170;
var statearr_35184_35302 = state_35170__$1;
(statearr_35184_35302[(2)] = inst_35114);

(statearr_35184_35302[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (60))){
var inst_35113 = (state_35170[(11)]);
var inst_34948 = (state_35170[(10)]);
var inst_35118 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_34948,inst_35113);
var state_35170__$1 = state_35170;
var statearr_35185_35303 = state_35170__$1;
(statearr_35185_35303[(2)] = inst_35118);

(statearr_35185_35303[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (27))){
var inst_34963 = (state_35170[(13)]);
var state_35170__$1 = state_35170;
var statearr_35186_35304 = state_35170__$1;
(statearr_35186_35304[(2)] = inst_34963);

(statearr_35186_35304[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (1))){
var state_35170__$1 = state_35170;
var statearr_35187_35305 = state_35170__$1;
(statearr_35187_35305[(2)] = null);

(statearr_35187_35305[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (69))){
var inst_34933 = (state_35170[(12)]);
var state_35170__$1 = state_35170;
if(cljs.core.truth_(inst_34933)){
var statearr_35188_35306 = state_35170__$1;
(statearr_35188_35306[(1)] = (72));

} else {
var statearr_35189_35307 = state_35170__$1;
(statearr_35189_35307[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (24))){
var inst_34948 = (state_35170[(10)]);
var state_35170__$1 = state_35170;
var statearr_35190_35308 = state_35170__$1;
(statearr_35190_35308[(2)] = inst_34948);

(statearr_35190_35308[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (55))){
var inst_35102 = (state_35170[(2)]);
var state_35170__$1 = state_35170;
var statearr_35191_35309 = state_35170__$1;
(statearr_35191_35309[(2)] = inst_35102);

(statearr_35191_35309[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (39))){
var inst_35110 = (state_35170[(2)]);
var state_35170__$1 = state_35170;
var statearr_35192_35310 = state_35170__$1;
(statearr_35192_35310[(2)] = inst_35110);

(statearr_35192_35310[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (46))){
var inst_34992 = (state_35170[(14)]);
var inst_34974 = (state_35170[(15)]);
var inst_35068 = (inst_34992.cljs$core$IFn$_invoke$arity$2 ? inst_34992.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,inst_34974) : inst_34992.call(null,cljs.core._LT_,inst_34974));
var state_35170__$1 = state_35170;
if(cljs.core.truth_(inst_35068)){
var statearr_35193_35311 = state_35170__$1;
(statearr_35193_35311[(1)] = (49));

} else {
var statearr_35194_35312 = state_35170__$1;
(statearr_35194_35312[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (4))){
var inst_34907 = (state_35170[(2)]);
var state_35170__$1 = state_35170;
var statearr_35195_35313 = state_35170__$1;
(statearr_35195_35313[(2)] = inst_34907);

(statearr_35195_35313[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (77))){
var inst_35158 = (state_35170[(2)]);
var state_35170__$1 = state_35170;
var statearr_35196_35314 = state_35170__$1;
(statearr_35196_35314[(2)] = inst_35158);

(statearr_35196_35314[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (54))){
var inst_35100 = cljs.core.PersistentVector.EMPTY;
var state_35170__$1 = state_35170;
var statearr_35197_35315 = state_35170__$1;
(statearr_35197_35315[(2)] = inst_35100);

(statearr_35197_35315[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (15))){
var inst_34918 = (state_35170[(16)]);
var inst_34943 = cljs.core.seq(inst_34918);
var inst_34944 = cljs.core.first(inst_34943);
var inst_34945 = cljs.core.next(inst_34943);
var inst_34946 = cljs.core.PersistentHashSet.EMPTY;
var inst_34947 = inst_34918;
var inst_34948 = inst_34946;
var state_35170__$1 = (function (){var statearr_35198 = state_35170;
(statearr_35198[(17)] = inst_34947);

(statearr_35198[(18)] = inst_34944);

(statearr_35198[(19)] = inst_34945);

(statearr_35198[(10)] = inst_34948);

return statearr_35198;
})();
var statearr_35199_35316 = state_35170__$1;
(statearr_35199_35316[(2)] = null);

(statearr_35199_35316[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (48))){
var inst_35065 = (state_35170[(2)]);
var inst_35066 = fluree.db.util.async.throw_err(inst_35065);
var state_35170__$1 = state_35170;
var statearr_35200_35317 = state_35170__$1;
(statearr_35200_35317[(2)] = inst_35066);

(statearr_35200_35317[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (50))){
var inst_34992 = (state_35170[(14)]);
var inst_34974 = (state_35170[(15)]);
var inst_35084 = (inst_34992.cljs$core$IFn$_invoke$arity$2 ? inst_34992.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,inst_34974) : inst_34992.call(null,cljs.core._LT__EQ_,inst_34974));
var state_35170__$1 = state_35170;
if(cljs.core.truth_(inst_35084)){
var statearr_35201_35318 = state_35170__$1;
(statearr_35201_35318[(1)] = (53));

} else {
var statearr_35202_35319 = state_35170__$1;
(statearr_35202_35319[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (75))){
var state_35170__$1 = state_35170;
if(cljs.core.truth_(offset)){
var statearr_35203_35320 = state_35170__$1;
(statearr_35203_35320[(1)] = (78));

} else {
var statearr_35204_35321 = state_35170__$1;
(statearr_35204_35321[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (21))){
var inst_34954 = (state_35170[(20)]);
var inst_34973 = (state_35170[(21)]);
var inst_34973__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34954,(0),null);
var inst_34974 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34954,(1),null);
var inst_34975 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34954,(2),null);
var inst_34976 = fluree.db.query.fql.valid_where_predicate_QMARK_(db,inst_34973__$1);
var inst_34977 = cljs.core.not(inst_34976);
var state_35170__$1 = (function (){var statearr_35205 = state_35170;
(statearr_35205[(22)] = inst_34975);

(statearr_35205[(21)] = inst_34973__$1);

(statearr_35205[(15)] = inst_34974);

return statearr_35205;
})();
if(inst_34977){
var statearr_35206_35322 = state_35170__$1;
(statearr_35206_35322[(1)] = (29));

} else {
var statearr_35207_35323 = state_35170__$1;
(statearr_35207_35323[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (31))){
var inst_34992 = (state_35170[(14)]);
var inst_34974 = (state_35170[(15)]);
var inst_34988 = (state_35170[(2)]);
var inst_34992__$1 = cljs.core.identical_QMARK_;
var inst_34993 = (inst_34992__$1.cljs$core$IFn$_invoke$arity$2 ? inst_34992__$1.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,inst_34974) : inst_34992__$1.call(null,cljs.core.not_EQ_,inst_34974));
var state_35170__$1 = (function (){var statearr_35208 = state_35170;
(statearr_35208[(23)] = inst_34988);

(statearr_35208[(14)] = inst_34992__$1);

return statearr_35208;
})();
if(cljs.core.truth_(inst_34993)){
var statearr_35209_35324 = state_35170__$1;
(statearr_35209_35324[(1)] = (32));

} else {
var statearr_35210_35325 = state_35170__$1;
(statearr_35210_35325[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (32))){
var inst_34975 = (state_35170[(22)]);
var inst_34933 = (state_35170[(12)]);
var inst_34973 = (state_35170[(21)]);
var inst_34995 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34996 = [inst_34973,inst_34975];
var inst_34997 = (new cljs.core.PersistentVector(null,2,(5),inst_34995,inst_34996,null));
var inst_34998 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34999 = [inst_34973];
var inst_35000 = (new cljs.core.PersistentVector(null,1,(5),inst_34998,inst_34999,null));
var inst_35001 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_35002 = [inst_34933];
var inst_35003 = cljs.core.PersistentHashMap.fromArrays(inst_35001,inst_35002);
var inst_35004 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_34997,cljs.core._LT__EQ_,inst_35000,inst_35003);
var state_35170__$1 = state_35170;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35170__$1,(35),inst_35004);
} else {
if((state_val_35171 === (40))){
var inst_35033 = (state_35170[(2)]);
var inst_35034 = fluree.db.util.async.throw_err(inst_35033);
var state_35170__$1 = state_35170;
var statearr_35211_35326 = state_35170__$1;
(statearr_35211_35326[(2)] = inst_35034);

(statearr_35211_35326[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (56))){
var inst_35097 = (state_35170[(2)]);
var inst_35098 = fluree.db.util.async.throw_err(inst_35097);
var state_35170__$1 = state_35170;
var statearr_35212_35327 = state_35170__$1;
(statearr_35212_35327[(2)] = inst_35098);

(statearr_35212_35327[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (33))){
var inst_34992 = (state_35170[(14)]);
var inst_34974 = (state_35170[(15)]);
var inst_35023 = (inst_34992.cljs$core$IFn$_invoke$arity$2 ? inst_34992.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,inst_34974) : inst_34992.call(null,cljs.core._EQ_,inst_34974));
var state_35170__$1 = state_35170;
if(cljs.core.truth_(inst_35023)){
var statearr_35213_35328 = state_35170__$1;
(statearr_35213_35328[(1)] = (37));

} else {
var statearr_35214_35329 = state_35170__$1;
(statearr_35214_35329[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (13))){
var state_35170__$1 = state_35170;
var statearr_35215_35330 = state_35170__$1;
(statearr_35215_35330[(2)] = limit);

(statearr_35215_35330[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (22))){
var inst_35160 = (state_35170[(2)]);
var state_35170__$1 = state_35170;
var statearr_35216_35331 = state_35170__$1;
(statearr_35216_35331[(2)] = inst_35160);

(statearr_35216_35331[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (36))){
var inst_35007 = (state_35170[(24)]);
var inst_35019 = (state_35170[(2)]);
var inst_35020 = fluree.db.util.async.throw_err(inst_35019);
var inst_35021 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_35007,inst_35020);
var state_35170__$1 = state_35170;
var statearr_35217_35332 = state_35170__$1;
(statearr_35217_35332[(2)] = inst_35021);

(statearr_35217_35332[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (41))){
var inst_34975 = (state_35170[(22)]);
var inst_34933 = (state_35170[(12)]);
var inst_34973 = (state_35170[(21)]);
var inst_35038 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35039 = [inst_34973,inst_34975];
var inst_35040 = (new cljs.core.PersistentVector(null,2,(5),inst_35038,inst_35039,null));
var inst_35041 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35042 = [inst_34973];
var inst_35043 = (new cljs.core.PersistentVector(null,1,(5),inst_35041,inst_35042,null));
var inst_35044 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_35045 = [inst_34933];
var inst_35046 = cljs.core.PersistentHashMap.fromArrays(inst_35044,inst_35045);
var inst_35047 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_35040,cljs.core._LT__EQ_,inst_35043,inst_35046);
var state_35170__$1 = state_35170;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35170__$1,(44),inst_35047);
} else {
if((state_val_35171 === (43))){
var inst_35108 = (state_35170[(2)]);
var state_35170__$1 = state_35170;
var statearr_35218_35333 = state_35170__$1;
(statearr_35218_35333[(2)] = inst_35108);

(statearr_35218_35333[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (61))){
var inst_35113 = (state_35170[(11)]);
var inst_34948 = (state_35170[(10)]);
var inst_35120 = cljs.core.PersistentHashSet.EMPTY;
var inst_35121 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_35120,inst_35113);
var inst_35122 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(inst_34948,inst_35121);
var state_35170__$1 = state_35170;
var statearr_35219_35334 = state_35170__$1;
(statearr_35219_35334[(2)] = inst_35122);

(statearr_35219_35334[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (29))){
var inst_34973 = (state_35170[(21)]);
var inst_34979 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_34973);
var inst_34980 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34979)].join('');
var inst_34981 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_34982 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_34983 = cljs.core.PersistentHashMap.fromArrays(inst_34981,inst_34982);
var inst_34984 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_34980,inst_34983);
var inst_34985 = (function(){throw inst_34984})();
var state_35170__$1 = state_35170;
var statearr_35220_35335 = state_35170__$1;
(statearr_35220_35335[(2)] = inst_34985);

(statearr_35220_35335[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (44))){
var inst_35049 = (state_35170[(2)]);
var inst_35050 = fluree.db.util.async.throw_err(inst_35049);
var state_35170__$1 = state_35170;
var statearr_35221_35336 = state_35170__$1;
(statearr_35221_35336[(2)] = inst_35050);

(statearr_35221_35336[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (6))){
var inst_34917 = (state_35170[(25)]);
var inst_34921 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"and","and",-971899817),inst_34917);
var state_35170__$1 = state_35170;
var statearr_35222_35337 = state_35170__$1;
(statearr_35222_35337[(2)] = inst_34921);

(statearr_35222_35337[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (28))){
var inst_34968 = (state_35170[(2)]);
var state_35170__$1 = state_35170;
var statearr_35223_35338 = state_35170__$1;
(statearr_35223_35338[(2)] = inst_34968);

(statearr_35223_35338[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (64))){
var inst_35128 = (state_35170[(26)]);
var state_35170__$1 = state_35170;
var statearr_35224_35339 = state_35170__$1;
(statearr_35224_35339[(2)] = inst_35128);

(statearr_35224_35339[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (51))){
var inst_35104 = (state_35170[(2)]);
var state_35170__$1 = state_35170;
var statearr_35225_35340 = state_35170__$1;
(statearr_35225_35340[(2)] = inst_35104);

(statearr_35225_35340[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (25))){
var inst_34963 = (state_35170[(2)]);
var state_35170__$1 = (function (){var statearr_35226 = state_35170;
(statearr_35226[(13)] = inst_34963);

return statearr_35226;
})();
if(cljs.core.truth_(limit)){
var statearr_35227_35341 = state_35170__$1;
(statearr_35227_35341[(1)] = (26));

} else {
var statearr_35228_35342 = state_35170__$1;
(statearr_35228_35342[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (34))){
var inst_34917 = (state_35170[(25)]);
var inst_35112 = (state_35170[(2)]);
var inst_35113 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_35112);
var state_35170__$1 = (function (){var statearr_35229 = state_35170;
(statearr_35229[(11)] = inst_35113);

return statearr_35229;
})();
var G__35230_35343 = inst_34917;
var G__35230_35344__$1 = (((G__35230_35343 instanceof cljs.core.Keyword))?G__35230_35343.fqn:null);
switch (G__35230_35344__$1) {
case "or":
var statearr_35231_35346 = state_35170__$1;
(statearr_35231_35346[(1)] = (58));


break;
case "and":
var statearr_35232_35347 = state_35170__$1;
(statearr_35232_35347[(1)] = (59));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__35230_35344__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (17))){
var inst_35165 = (state_35170[(2)]);
var _ = (function (){var statearr_35233 = state_35170;
(statearr_35233[(4)] = cljs.core.rest((state_35170[(4)])));

return statearr_35233;
})();
var state_35170__$1 = state_35170;
var statearr_35234_35348 = state_35170__$1;
(statearr_35234_35348[(2)] = inst_35165);

(statearr_35234_35348[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (3))){
var inst_35168 = (state_35170[(2)]);
var state_35170__$1 = state_35170;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35170__$1,inst_35168);
} else {
if((state_val_35171 === (12))){
var inst_34927 = (offset + limit);
var state_35170__$1 = state_35170;
var statearr_35235_35349 = state_35170__$1;
(statearr_35235_35349[(2)] = inst_34927);

(statearr_35235_35349[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (2))){
var inst_34919 = (state_35170[(9)]);
var _ = (function (){var statearr_35236 = state_35170;
(statearr_35236[(4)] = cljs.core.cons((5),(state_35170[(4)])));

return statearr_35236;
})();
var inst_34916 = fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3(db,where_clause,default_collection);
var inst_34917 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34916,(0),null);
var inst_34918 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34916,(1),null);
var inst_34919__$1 = limit;
var state_35170__$1 = (function (){var statearr_35237 = state_35170;
(statearr_35237[(16)] = inst_34918);

(statearr_35237[(9)] = inst_34919__$1);

(statearr_35237[(25)] = inst_34917);

return statearr_35237;
})();
if(cljs.core.truth_(inst_34919__$1)){
var statearr_35238_35350 = state_35170__$1;
(statearr_35238_35350[(1)] = (6));

} else {
var statearr_35239_35351 = state_35170__$1;
(statearr_35239_35351[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (66))){
var inst_35133 = (state_35170[(7)]);
var state_35170__$1 = state_35170;
var statearr_35240_35352 = state_35170__$1;
(statearr_35240_35352[(2)] = inst_35133);

(statearr_35240_35352[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (23))){
var inst_34948 = (state_35170[(10)]);
var inst_34960 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,inst_34948);
var state_35170__$1 = state_35170;
var statearr_35241_35353 = state_35170__$1;
(statearr_35241_35353[(2)] = inst_34960);

(statearr_35241_35353[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (47))){
var inst_35106 = (state_35170[(2)]);
var state_35170__$1 = state_35170;
var statearr_35242_35354 = state_35170__$1;
(statearr_35242_35354[(2)] = inst_35106);

(statearr_35242_35354[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (35))){
var inst_34975 = (state_35170[(22)]);
var inst_34933 = (state_35170[(12)]);
var inst_34973 = (state_35170[(21)]);
var inst_35006 = (state_35170[(2)]);
var inst_35007 = fluree.db.util.async.throw_err(inst_35006);
var inst_35008 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35009 = [inst_34973];
var inst_35010 = (new cljs.core.PersistentVector(null,1,(5),inst_35008,inst_35009,null));
var inst_35011 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35012 = [inst_34973,inst_34975];
var inst_35013 = (new cljs.core.PersistentVector(null,2,(5),inst_35011,inst_35012,null));
var inst_35014 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_35015 = [inst_34933];
var inst_35016 = cljs.core.PersistentHashMap.fromArrays(inst_35014,inst_35015);
var inst_35017 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_35010,cljs.core._LT_,inst_35013,inst_35016);
var state_35170__$1 = (function (){var statearr_35243 = state_35170;
(statearr_35243[(24)] = inst_35007);

return statearr_35243;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35170__$1,(36),inst_35017);
} else {
if((state_val_35171 === (76))){
var inst_35127 = (state_35170[(27)]);
var inst_34955 = (state_35170[(28)]);
var inst_34947 = inst_34955;
var inst_34948 = inst_35127;
var state_35170__$1 = (function (){var statearr_35244 = state_35170;
(statearr_35244[(17)] = inst_34947);

(statearr_35244[(10)] = inst_34948);

return statearr_35244;
})();
var statearr_35245_35355 = state_35170__$1;
(statearr_35245_35355[(2)] = null);

(statearr_35245_35355[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (19))){
var inst_35162 = (state_35170[(2)]);
var state_35170__$1 = state_35170;
var statearr_35246_35356 = state_35170__$1;
(statearr_35246_35356[(2)] = inst_35162);

(statearr_35246_35356[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (57))){
var inst_34917 = (state_35170[(25)]);
var inst_35128 = (state_35170[(26)]);
var inst_35127 = (state_35170[(2)]);
var inst_35128__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"and","and",-971899817),inst_34917);
var state_35170__$1 = (function (){var statearr_35247 = state_35170;
(statearr_35247[(27)] = inst_35127);

(statearr_35247[(26)] = inst_35128__$1);

return statearr_35247;
})();
if(inst_35128__$1){
var statearr_35248_35357 = state_35170__$1;
(statearr_35248_35357[(1)] = (63));

} else {
var statearr_35249_35358 = state_35170__$1;
(statearr_35249_35358[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (68))){
var inst_35148 = (state_35170[(2)]);
var state_35170__$1 = state_35170;
if(cljs.core.truth_(inst_35148)){
var statearr_35250_35359 = state_35170__$1;
(statearr_35250_35359[(1)] = (75));

} else {
var statearr_35251_35360 = state_35170__$1;
(statearr_35251_35360[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (11))){
var inst_34918 = (state_35170[(16)]);
var inst_34933 = (state_35170[(2)]);
var inst_34934 = cljs.core.not_empty(inst_34918);
var state_35170__$1 = (function (){var statearr_35253 = state_35170;
(statearr_35253[(12)] = inst_34933);

return statearr_35253;
})();
if(cljs.core.truth_(inst_34934)){
var statearr_35254_35361 = state_35170__$1;
(statearr_35254_35361[(1)] = (15));

} else {
var statearr_35255_35362 = state_35170__$1;
(statearr_35255_35362[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (9))){
var state_35170__$1 = state_35170;
if(cljs.core.truth_(offset)){
var statearr_35256_35363 = state_35170__$1;
(statearr_35256_35363[(1)] = (12));

} else {
var statearr_35257_35364 = state_35170__$1;
(statearr_35257_35364[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (5))){
var _ = (function (){var statearr_35258 = state_35170;
(statearr_35258[(4)] = cljs.core.rest((state_35170[(4)])));

return statearr_35258;
})();
var state_35170__$1 = state_35170;
var ex35252 = (state_35170__$1[(2)]);
var statearr_35259_35365 = state_35170__$1;
(statearr_35259_35365[(5)] = ex35252);


if((ex35252 instanceof Error)){
var statearr_35260_35366 = state_35170__$1;
(statearr_35260_35366[(1)] = (4));

(statearr_35260_35366[(5)] = null);

} else {
throw ex35252;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (14))){
var inst_34930 = (state_35170[(2)]);
var state_35170__$1 = state_35170;
var statearr_35261_35367 = state_35170__$1;
(statearr_35261_35367[(2)] = inst_34930);

(statearr_35261_35367[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (45))){
var inst_34975 = (state_35170[(22)]);
var inst_34933 = (state_35170[(12)]);
var inst_34973 = (state_35170[(21)]);
var inst_35054 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35055 = [inst_34973,inst_34975];
var inst_35056 = (new cljs.core.PersistentVector(null,2,(5),inst_35054,inst_35055,null));
var inst_35057 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35058 = [inst_34973];
var inst_35059 = (new cljs.core.PersistentVector(null,1,(5),inst_35057,inst_35058,null));
var inst_35060 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_35061 = [inst_34933];
var inst_35062 = cljs.core.PersistentHashMap.fromArrays(inst_35060,inst_35061);
var inst_35063 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_35056,cljs.core._LT__EQ_,inst_35059,inst_35062);
var state_35170__$1 = state_35170;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35170__$1,(48),inst_35063);
} else {
if((state_val_35171 === (53))){
var inst_34975 = (state_35170[(22)]);
var inst_34933 = (state_35170[(12)]);
var inst_34973 = (state_35170[(21)]);
var inst_35086 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35087 = [inst_34973];
var inst_35088 = (new cljs.core.PersistentVector(null,1,(5),inst_35086,inst_35087,null));
var inst_35089 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35090 = [inst_34973,inst_34975];
var inst_35091 = (new cljs.core.PersistentVector(null,2,(5),inst_35089,inst_35090,null));
var inst_35092 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_35093 = [inst_34933];
var inst_35094 = cljs.core.PersistentHashMap.fromArrays(inst_35092,inst_35093);
var inst_35095 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_35088,cljs.core._LT__EQ_,inst_35091,inst_35094);
var state_35170__$1 = state_35170;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35170__$1,(56),inst_35095);
} else {
if((state_val_35171 === (78))){
var inst_35127 = (state_35170[(27)]);
var inst_35151 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,inst_35127);
var state_35170__$1 = state_35170;
var statearr_35262_35368 = state_35170__$1;
(statearr_35262_35368[(2)] = inst_35151);

(statearr_35262_35368[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (26))){
var inst_34963 = (state_35170[(13)]);
var inst_34965 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,inst_34963);
var state_35170__$1 = state_35170;
var statearr_35263_35369 = state_35170__$1;
(statearr_35263_35369[(2)] = inst_34965);

(statearr_35263_35369[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (16))){
var state_35170__$1 = state_35170;
var statearr_35264_35370 = state_35170__$1;
(statearr_35264_35370[(2)] = null);

(statearr_35264_35370[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (79))){
var inst_35127 = (state_35170[(27)]);
var state_35170__$1 = state_35170;
var statearr_35265_35371 = state_35170__$1;
(statearr_35265_35371[(2)] = inst_35127);

(statearr_35265_35371[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (38))){
var inst_34992 = (state_35170[(14)]);
var inst_34974 = (state_35170[(15)]);
var inst_35036 = (inst_34992.cljs$core$IFn$_invoke$arity$2 ? inst_34992.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,inst_34974) : inst_34992.call(null,cljs.core._GT_,inst_34974));
var state_35170__$1 = state_35170;
if(cljs.core.truth_(inst_35036)){
var statearr_35266_35372 = state_35170__$1;
(statearr_35266_35372[(1)] = (41));

} else {
var statearr_35267_35373 = state_35170__$1;
(statearr_35267_35373[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (30))){
var state_35170__$1 = state_35170;
var statearr_35268_35374 = state_35170__$1;
(statearr_35268_35374[(2)] = null);

(statearr_35268_35374[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (73))){
var inst_34933 = (state_35170[(12)]);
var state_35170__$1 = state_35170;
var statearr_35269_35375 = state_35170__$1;
(statearr_35269_35375[(2)] = inst_34933);

(statearr_35269_35375[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (10))){
var state_35170__$1 = state_35170;
var statearr_35270_35376 = state_35170__$1;
(statearr_35270_35376[(2)] = null);

(statearr_35270_35376[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (18))){
var inst_34947 = (state_35170[(17)]);
var inst_34954 = (state_35170[(20)]);
var inst_34953 = cljs.core.seq(inst_34947);
var inst_34954__$1 = cljs.core.first(inst_34953);
var inst_34955 = cljs.core.next(inst_34953);
var inst_34956 = cljs.core.not(inst_34954__$1);
var state_35170__$1 = (function (){var statearr_35271 = state_35170;
(statearr_35271[(28)] = inst_34955);

(statearr_35271[(20)] = inst_34954__$1);

return statearr_35271;
})();
if(inst_34956){
var statearr_35272_35377 = state_35170__$1;
(statearr_35272_35377[(1)] = (20));

} else {
var statearr_35273_35378 = state_35170__$1;
(statearr_35273_35378[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (52))){
var inst_35081 = (state_35170[(2)]);
var inst_35082 = fluree.db.util.async.throw_err(inst_35081);
var state_35170__$1 = state_35170;
var statearr_35274_35379 = state_35170__$1;
(statearr_35274_35379[(2)] = inst_35082);

(statearr_35274_35379[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (67))){
var inst_34917 = (state_35170[(25)]);
var inst_35136 = (state_35170[(8)]);
var inst_35136__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"and","and",-971899817),inst_34917);
var state_35170__$1 = (function (){var statearr_35275 = state_35170;
(statearr_35275[(8)] = inst_35136__$1);

return statearr_35275;
})();
if(inst_35136__$1){
var statearr_35276_35380 = state_35170__$1;
(statearr_35276_35380[(1)] = (69));

} else {
var statearr_35277_35381 = state_35170__$1;
(statearr_35277_35381[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (71))){
var inst_35146 = (state_35170[(2)]);
var state_35170__$1 = state_35170;
var statearr_35278_35382 = state_35170__$1;
(statearr_35278_35382[(2)] = inst_35146);

(statearr_35278_35382[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (42))){
var inst_34992 = (state_35170[(14)]);
var inst_34974 = (state_35170[(15)]);
var inst_35052 = (inst_34992.cljs$core$IFn$_invoke$arity$2 ? inst_34992.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,inst_34974) : inst_34992.call(null,cljs.core._GT__EQ_,inst_34974));
var state_35170__$1 = state_35170;
if(cljs.core.truth_(inst_35052)){
var statearr_35279_35383 = state_35170__$1;
(statearr_35279_35383[(1)] = (45));

} else {
var statearr_35280_35384 = state_35170__$1;
(statearr_35280_35384[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (80))){
var inst_35154 = (state_35170[(2)]);
var state_35170__$1 = state_35170;
var statearr_35281_35385 = state_35170__$1;
(statearr_35281_35385[(2)] = inst_35154);

(statearr_35281_35385[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (37))){
var inst_34975 = (state_35170[(22)]);
var inst_34933 = (state_35170[(12)]);
var inst_34973 = (state_35170[(21)]);
var inst_35025 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35026 = [inst_34973,inst_34975];
var inst_35027 = (new cljs.core.PersistentVector(null,2,(5),inst_35025,inst_35026,null));
var inst_35028 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_35029 = [inst_34933];
var inst_35030 = cljs.core.PersistentHashMap.fromArrays(inst_35028,inst_35029);
var inst_35031 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_35027,inst_35030);
var state_35170__$1 = state_35170;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35170__$1,(40),inst_35031);
} else {
if((state_val_35171 === (63))){
var inst_35127 = (state_35170[(27)]);
var inst_35130 = cljs.core.empty_QMARK_(inst_35127);
var state_35170__$1 = state_35170;
var statearr_35282_35386 = state_35170__$1;
(statearr_35282_35386[(2)] = inst_35130);

(statearr_35282_35386[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (8))){
var inst_34924 = (state_35170[(2)]);
var state_35170__$1 = state_35170;
if(cljs.core.truth_(inst_34924)){
var statearr_35283_35387 = state_35170__$1;
(statearr_35283_35387[(1)] = (9));

} else {
var statearr_35284_35388 = state_35170__$1;
(statearr_35284_35388[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35171 === (49))){
var inst_34975 = (state_35170[(22)]);
var inst_34933 = (state_35170[(12)]);
var inst_34973 = (state_35170[(21)]);
var inst_35070 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35071 = [inst_34973];
var inst_35072 = (new cljs.core.PersistentVector(null,1,(5),inst_35070,inst_35071,null));
var inst_35073 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35074 = [inst_34973,inst_34975];
var inst_35075 = (new cljs.core.PersistentVector(null,2,(5),inst_35073,inst_35074,null));
var inst_35076 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_35077 = [inst_34933];
var inst_35078 = cljs.core.PersistentHashMap.fromArrays(inst_35076,inst_35077);
var inst_35079 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_35072,cljs.core._LT_,inst_35075,inst_35078);
var state_35170__$1 = state_35170;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35170__$1,(52),inst_35079);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__11410__auto__ = null;
var fluree$db$query$fql$state_machine__11410__auto____0 = (function (){
var statearr_35285 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35285[(0)] = fluree$db$query$fql$state_machine__11410__auto__);

(statearr_35285[(1)] = (1));

return statearr_35285;
});
var fluree$db$query$fql$state_machine__11410__auto____1 = (function (state_35170){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_35170);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e35286){var ex__11413__auto__ = e35286;
var statearr_35287_35389 = state_35170;
(statearr_35287_35389[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_35170[(4)]))){
var statearr_35288_35390 = state_35170;
(statearr_35288_35390[(1)] = cljs.core.first((state_35170[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35391 = state_35170;
state_35170 = G__35391;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__11410__auto__ = function(state_35170){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__11410__auto____1.call(this,state_35170);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__11410__auto____0;
fluree$db$query$fql$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__11410__auto____1;
return fluree$db$query$fql$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_35289 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_35289[(6)] = c__11484__auto__);

return statearr_35289;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 4);

fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(cljs.core.keys(x))))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var var_as_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.keys(x)));
var ___$1 = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(var_as_symbol) : valid_var.call(null,var_as_symbol)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_as_symbol,new cljs.core.Keyword(null,"selection","selection",975998651),cljs.core.first(cljs.core.vals(x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4253__auto__ = cljs.core.every_QMARK_((function (p1__35392_SHARP_){
return ((typeof p1__35392_SHARP_ === 'string') || (cljs.core.map_QMARK_(p1__35392_SHARP_)));
}),select_smt);
if(or__4253__auto__){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vars__$1 = cljs.core.set(vars);
var all_vars = cljs.core.set(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(vars__$1,cljs.core.keys(interim_vars)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select){
var var_symbol = ((cljs.core.map_QMARK_(select))?null:cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(select));
if(cljs.core.truth_((vars__$1.cljs$core$IFn$_invoke$arity$1 ? vars__$1.cljs$core$IFn$_invoke$arity$1(var_symbol) : vars__$1.call(null,var_symbol)))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_(select))){
return fluree.db.query.analytical.parse_aggregate(select,vars__$1);
} else {
if(cljs.core.map_QMARK_(select)){
return fluree.db.query.fql.parse_map(select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__35393_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__35393_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__35397 = vars;
var vec__35398 = G__35397;
var seq__35399 = cljs.core.seq(vec__35398);
var first__35400 = cljs.core.first(seq__35399);
var seq__35399__$1 = cljs.core.next(seq__35399);
var var$ = first__35400;
var r = seq__35399__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__35397__$1 = G__35397;
var all_vars__$1 = all_vars;
while(true){
var vec__35405 = G__35397__$1;
var seq__35406 = cljs.core.seq(vec__35405);
var first__35407 = cljs.core.first(seq__35406);
var seq__35406__$1 = cljs.core.next(seq__35406);
var var$__$1 = first__35407;
var r__$1 = seq__35406__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__35408 = cljs.core.set(all_vars__$2);
return (fexpr__35408.cljs$core$IFn$_invoke$arity$1 ? fexpr__35408.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__35408.call(null,var$__$1));
})())){
var G__35409 = r__$1;
var G__35410 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__35397__$1 = G__35409;
all_vars__$1 = G__35410;
continue;
} else {
var G__35411 = r__$1;
var G__35412 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__35397__$1 = G__35411;
all_vars__$1 = G__35412;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_35447){
var state_val_35448 = (state_35447[(1)]);
if((state_val_35448 === (1))){
var inst_35420 = functionArray;
var inst_35421 = cljs.core.seq(inst_35420);
var inst_35422 = cljs.core.first(inst_35421);
var inst_35423 = cljs.core.next(inst_35421);
var inst_35424 = cljs.core.PersistentVector.EMPTY;
var inst_35425 = inst_35420;
var inst_35426 = inst_35424;
var state_35447__$1 = (function (){var statearr_35449 = state_35447;
(statearr_35449[(7)] = inst_35423);

(statearr_35449[(8)] = inst_35422);

(statearr_35449[(9)] = inst_35426);

(statearr_35449[(10)] = inst_35425);

return statearr_35449;
})();
var statearr_35450_35463 = state_35447__$1;
(statearr_35450_35463[(2)] = null);

(statearr_35450_35463[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35448 === (2))){
var inst_35432 = (state_35447[(11)]);
var inst_35425 = (state_35447[(10)]);
var inst_35431 = cljs.core.seq(inst_35425);
var inst_35432__$1 = cljs.core.first(inst_35431);
var inst_35433 = cljs.core.next(inst_35431);
var state_35447__$1 = (function (){var statearr_35451 = state_35447;
(statearr_35451[(11)] = inst_35432__$1);

(statearr_35451[(12)] = inst_35433);

return statearr_35451;
})();
if(cljs.core.truth_(inst_35432__$1)){
var statearr_35452_35464 = state_35447__$1;
(statearr_35452_35464[(1)] = (4));

} else {
var statearr_35453_35465 = state_35447__$1;
(statearr_35453_35465[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35448 === (3))){
var inst_35445 = (state_35447[(2)]);
var state_35447__$1 = state_35447;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35447__$1,inst_35445);
} else {
if((state_val_35448 === (4))){
var inst_35432 = (state_35447[(11)]);
var inst_35435 = (inst_35432.cljs$core$IFn$_invoke$arity$1 ? inst_35432.cljs$core$IFn$_invoke$arity$1(tuple) : inst_35432.call(null,tuple));
var state_35447__$1 = state_35447;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35447__$1,(7),inst_35435);
} else {
if((state_val_35448 === (5))){
var inst_35426 = (state_35447[(9)]);
var state_35447__$1 = state_35447;
var statearr_35454_35466 = state_35447__$1;
(statearr_35454_35466[(2)] = inst_35426);

(statearr_35454_35466[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35448 === (6))){
var inst_35443 = (state_35447[(2)]);
var state_35447__$1 = state_35447;
var statearr_35455_35467 = state_35447__$1;
(statearr_35455_35467[(2)] = inst_35443);

(statearr_35455_35467[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35448 === (7))){
var inst_35426 = (state_35447[(9)]);
var inst_35433 = (state_35447[(12)]);
var inst_35437 = (state_35447[(2)]);
var inst_35438 = fluree.db.util.async.throw_err(inst_35437);
var inst_35439 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_35426,inst_35438);
var inst_35425 = inst_35433;
var inst_35426__$1 = inst_35439;
var state_35447__$1 = (function (){var statearr_35456 = state_35447;
(statearr_35456[(9)] = inst_35426__$1);

(statearr_35456[(10)] = inst_35425);

return statearr_35456;
})();
var statearr_35457_35468 = state_35447__$1;
(statearr_35457_35468[(2)] = null);

(statearr_35457_35468[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__11410__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__11410__auto____0 = (function (){
var statearr_35458 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35458[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__11410__auto__);

(statearr_35458[(1)] = (1));

return statearr_35458;
});
var fluree$db$query$fql$format_tuple_$_state_machine__11410__auto____1 = (function (state_35447){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_35447);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e35459){var ex__11413__auto__ = e35459;
var statearr_35460_35469 = state_35447;
(statearr_35460_35469[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_35447[(4)]))){
var statearr_35461_35470 = state_35447;
(statearr_35461_35470[(1)] = cljs.core.first((state_35447[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35471 = state_35447;
state_35447 = G__35471;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__11410__auto__ = function(state_35447){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__11410__auto____1.call(this,state_35447);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__11410__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__11410__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_35462 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_35462[(6)] = c__11484__auto__);

return statearr_35462;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((function (idx,select_item){
var temp__5753__auto__ = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5753__auto__)){
var query_map = temp__5753__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__35472){
var vec__35473 = p__35472;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35473,(0),null);
var query_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35473,(1),null);
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tuple_result,tuple_index);
if(cljs.core.truth_(temp__5753__auto__)){
var _id = temp__5753__auto__;
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_35487){
var state_val_35488 = (state_35487[(1)]);
if((state_val_35488 === (1))){
var inst_35476 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35477 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_35478 = [query_map,_id,query_opts];
var inst_35479 = cljs.core.PersistentHashMap.fromArrays(inst_35477,inst_35478);
var inst_35480 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_35479) : fluree.db.query.fql.query.call(null,db,inst_35479));
var state_35487__$1 = (function (){var statearr_35489 = state_35487;
(statearr_35489[(7)] = inst_35476);

return statearr_35489;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35487__$1,(2),inst_35480);
} else {
if((state_val_35488 === (2))){
var inst_35476 = (state_35487[(7)]);
var inst_35482 = (state_35487[(2)]);
var inst_35483 = fluree.db.util.async.throw_err(inst_35482);
var inst_35484 = [tuple_index,inst_35483];
var inst_35485 = (new cljs.core.PersistentVector(null,2,(5),inst_35476,inst_35484,null));
var state_35487__$1 = state_35487;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35487__$1,inst_35485);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__11410__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__11410__auto____0 = (function (){
var statearr_35490 = [null,null,null,null,null,null,null,null];
(statearr_35490[(0)] = fluree$db$query$fql$expand_map_$_state_machine__11410__auto__);

(statearr_35490[(1)] = (1));

return statearr_35490;
});
var fluree$db$query$fql$expand_map_$_state_machine__11410__auto____1 = (function (state_35487){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_35487);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e35491){var ex__11413__auto__ = e35491;
var statearr_35492_35495 = state_35487;
(statearr_35492_35495[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_35487[(4)]))){
var statearr_35493_35496 = state_35487;
(statearr_35493_35496[(1)] = cljs.core.first((state_35487[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35497 = state_35487;
state_35487 = G__35497;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__11410__auto__ = function(state_35487){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__11410__auto____1.call(this,state_35487);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__11410__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__11410__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_35494 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_35494[(6)] = c__11484__auto__);

return statearr_35494;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_(expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__35498 = expand_map_tuple;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35498,(0),null);
var query_map_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35498,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_35561){
var state_val_35562 = (state_35561[(1)]);
if((state_val_35562 === (7))){
var inst_35556 = (state_35561[(2)]);
var _ = (function (){var statearr_35563 = state_35561;
(statearr_35563[(4)] = cljs.core.rest((state_35561[(4)])));

return statearr_35563;
})();
var state_35561__$1 = state_35561;
var statearr_35564_35655 = state_35561__$1;
(statearr_35564_35655[(2)] = inst_35556);

(statearr_35564_35655[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35562 === (20))){
var inst_35547 = (state_35561[(2)]);
var state_35561__$1 = state_35561;
var statearr_35565_35656 = state_35561__$1;
(statearr_35565_35656[(2)] = inst_35547);

(statearr_35565_35656[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35562 === (1))){
var state_35561__$1 = state_35561;
var statearr_35566_35657 = state_35561__$1;
(statearr_35566_35657[(2)] = null);

(statearr_35566_35657[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35562 === (4))){
var inst_35503 = (state_35561[(2)]);
var state_35561__$1 = state_35561;
var statearr_35567_35658 = state_35561__$1;
(statearr_35567_35658[(2)] = inst_35503);

(statearr_35567_35658[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35562 === (15))){
var inst_35523 = (state_35561[(7)]);
var inst_35532 = cljs.core.second(inst_35523);
var inst_35533 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_35532);
var inst_35534 = (inst_35533 > max_fuel);
var state_35561__$1 = state_35561;
if(cljs.core.truth_(inst_35534)){
var statearr_35568_35659 = state_35561__$1;
(statearr_35568_35659[(1)] = (18));

} else {
var statearr_35569_35660 = state_35561__$1;
(statearr_35569_35660[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35562 === (13))){
var state_35561__$1 = state_35561;
var statearr_35570_35661 = state_35561__$1;
(statearr_35570_35661[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35562 === (6))){
var inst_35511 = (state_35561[(8)]);
var state_35561__$1 = state_35561;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35561__$1,(8),inst_35511);
} else {
if((state_val_35562 === (17))){
var inst_35550 = (state_35561[(2)]);
var state_35561__$1 = state_35561;
var statearr_35572_35662 = state_35561__$1;
(statearr_35572_35662[(2)] = inst_35550);

(statearr_35572_35662[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35562 === (3))){
var inst_35559 = (state_35561[(2)]);
var state_35561__$1 = state_35561;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35561__$1,inst_35559);
} else {
if((state_val_35562 === (12))){
var inst_35512 = (state_35561[(9)]);
var inst_35523 = (state_35561[(7)]);
var inst_35529 = (inst_35512.cljs$core$IFn$_invoke$arity$0 ? inst_35512.cljs$core$IFn$_invoke$arity$0() : inst_35512.call(null));
var state_35561__$1 = (function (){var statearr_35573 = state_35561;
(statearr_35573[(10)] = inst_35529);

return statearr_35573;
})();
var statearr_35574_35663 = state_35561__$1;
(statearr_35574_35663[(2)] = inst_35523);

(statearr_35574_35663[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35562 === (2))){
var inst_35511 = (state_35561[(8)]);
var inst_35512 = (state_35561[(9)]);
var _ = (function (){var statearr_35575 = state_35561;
(statearr_35575[(4)] = cljs.core.cons((5),(state_35561[(4)])));

return statearr_35575;
})();
var inst_35509 = fluree.db.query.fql.build_expand_map(select,pp_keys);
var inst_35510 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_35511__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_35512__$1 = (function (){var expandMaps = inst_35509;
var queue_ch = inst_35510;
var res_ch = inst_35511__$1;
return (function (){
cljs.core.async.close_BANG_(queue_ch);

return cljs.core.async.close_BANG_(res_ch);
});
})();
var inst_35513 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667)], 0));
var inst_35514 = cljs.core.volatile_BANG_((0));
var inst_35515 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_35513,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_35514);
var inst_35516 = (function (){var expandMaps = inst_35509;
var queue_ch = inst_35510;
var res_ch = inst_35511__$1;
var stop_BANG_ = inst_35512__$1;
var opts_STAR_ = inst_35515;
return (function (tuple_res,port){
var c__11484__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_35608){
var state_val_35609 = (state_35608[(1)]);
if((state_val_35609 === (7))){
var state_35608__$1 = state_35608;
var statearr_35610_35664 = state_35608__$1;
(statearr_35610_35664[(2)] = tuple_res);

(statearr_35610_35664[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35609 === (1))){
var state_35608__$1 = state_35608;
var statearr_35611_35665 = state_35608__$1;
(statearr_35611_35665[(2)] = null);

(statearr_35611_35665[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35609 === (4))){
var inst_35576 = (state_35608[(2)]);
var inst_35577 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_35576);
var inst_35578 = cljs.core.async.close_BANG_(port);
var state_35608__$1 = (function (){var statearr_35612 = state_35608;
(statearr_35612[(7)] = inst_35577);

return statearr_35612;
})();
var statearr_35613_35666 = state_35608__$1;
(statearr_35613_35666[(2)] = inst_35578);

(statearr_35613_35666[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35609 === (6))){
var inst_35585 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35586 = [tuple_res];
var inst_35587 = (new cljs.core.PersistentVector(null,1,(5),inst_35585,inst_35586,null));
var state_35608__$1 = state_35608;
var statearr_35614_35667 = state_35608__$1;
(statearr_35614_35667[(2)] = inst_35587);

(statearr_35614_35667[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35609 === (3))){
var inst_35606 = (state_35608[(2)]);
var state_35608__$1 = state_35608;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35608__$1,inst_35606);
} else {
if((state_val_35609 === (2))){
var ___$1 = (function (){var statearr_35616 = state_35608;
(statearr_35616[(4)] = cljs.core.cons((5),(state_35608[(4)])));

return statearr_35616;
})();
var state_35608__$1 = state_35608;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_35617_35668 = state_35608__$1;
(statearr_35617_35668[(1)] = (6));

} else {
var statearr_35618_35669 = state_35608__$1;
(statearr_35618_35669[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35609 === (9))){
var inst_35592 = (state_35608[(8)]);
var inst_35590 = (state_35608[(9)]);
var inst_35599 = (state_35608[(2)]);
var inst_35600 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.replace_expand_maps,inst_35590,inst_35599);
var inst_35601 = (inst_35592.cljs$core$IFn$_invoke$arity$1 ? inst_35592.cljs$core$IFn$_invoke$arity$1(inst_35600) : inst_35592.call(null,inst_35600));
var inst_35602 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_35601);
var inst_35603 = cljs.core.async.close_BANG_(port);
var ___$1 = (function (){var statearr_35619 = state_35608;
(statearr_35619[(4)] = cljs.core.rest((state_35608[(4)])));

return statearr_35619;
})();
var state_35608__$1 = (function (){var statearr_35620 = state_35608;
(statearr_35620[(10)] = inst_35602);

return statearr_35620;
})();
var statearr_35621_35670 = state_35608__$1;
(statearr_35621_35670[(2)] = inst_35603);

(statearr_35621_35670[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35609 === (5))){
var ___$1 = (function (){var statearr_35622 = state_35608;
(statearr_35622[(4)] = cljs.core.rest((state_35608[(4)])));

return statearr_35622;
})();
var state_35608__$1 = state_35608;
var ex35615 = (state_35608__$1[(2)]);
var statearr_35623_35671 = state_35608__$1;
(statearr_35623_35671[(5)] = ex35615);


var statearr_35624_35672 = state_35608__$1;
(statearr_35624_35672[(1)] = (4));

(statearr_35624_35672[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35609 === (8))){
var inst_35590 = (state_35608[(9)]);
var inst_35590__$1 = (state_35608[(2)]);
var inst_35591 = cljs.core.volatile_BANG_((0));
var inst_35592 = (function (){var tuple_res_SINGLEQUOTE_ = inst_35590__$1;
var query_fuel = inst_35591;
return (function (p1__35502_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(p1__35502_SHARP_),cljs.core.deref(query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__35502_SHARP_,cljs.core.deref(query_fuel)], null);
}
});
})();
var inst_35593 = cljs.core.PersistentVector.EMPTY;
var inst_35594 = (function (){var tuple_res_SINGLEQUOTE_ = inst_35590__$1;
var query_fuel = inst_35591;
return (function (p1__35501_SHARP_){
return fluree.db.query.fql.expand_map(db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_STAR_,new cljs.core.Keyword(null,"fuel","fuel",10405485),fuel),tuple_res_SINGLEQUOTE_,p1__35501_SHARP_);
});
})();
var inst_35595 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(inst_35594,expandMaps);
var inst_35596 = cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1(inst_35595);
var inst_35597 = cljs.core.async.into(inst_35593,inst_35596);
var state_35608__$1 = (function (){var statearr_35625 = state_35608;
(statearr_35625[(8)] = inst_35592);

(statearr_35625[(9)] = inst_35590__$1);

return statearr_35625;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35608__$1,(9),inst_35597);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11410__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11410__auto____0 = (function (){
var statearr_35626 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_35626[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11410__auto__);

(statearr_35626[(1)] = (1));

return statearr_35626;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11410__auto____1 = (function (state_35608){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_35608);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e35627){var ex__11413__auto__ = e35627;
var statearr_35628_35673 = state_35608;
(statearr_35628_35673[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_35608[(4)]))){
var statearr_35629_35674 = state_35608;
(statearr_35629_35674[(1)] = cljs.core.first((state_35608[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35675 = state_35608;
state_35608 = G__35675;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11410__auto__ = function(state_35608){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11410__auto____1.call(this,state_35608);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11410__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11410__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_35630 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_35630[(6)] = c__11484__auto____$1);

return statearr_35630;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto____$1;
});
})();
var inst_35517 = cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(inst_35510,tuples_res);
var inst_35518 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_35511__$1,inst_35516,inst_35510);
var inst_35519 = cljs.core.PersistentVector.EMPTY;
var inst_35520 = inst_35519;
var state_35561__$1 = (function (){var statearr_35631 = state_35561;
(statearr_35631[(8)] = inst_35511__$1);

(statearr_35631[(11)] = inst_35517);

(statearr_35631[(12)] = inst_35520);

(statearr_35631[(13)] = inst_35518);

(statearr_35631[(9)] = inst_35512__$1);

return statearr_35631;
})();
var statearr_35632_35676 = state_35561__$1;
(statearr_35632_35676[(2)] = null);

(statearr_35632_35676[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35562 === (19))){
var inst_35520 = (state_35561[(12)]);
var inst_35523 = (state_35561[(7)]);
var inst_35543 = cljs.core.first(inst_35523);
var inst_35544 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_35520,inst_35543);
var inst_35520__$1 = inst_35544;
var state_35561__$1 = (function (){var statearr_35633 = state_35561;
(statearr_35633[(12)] = inst_35520__$1);

return statearr_35633;
})();
var statearr_35634_35677 = state_35561__$1;
(statearr_35634_35677[(2)] = null);

(statearr_35634_35677[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35562 === (11))){
var inst_35554 = (state_35561[(2)]);
var state_35561__$1 = state_35561;
var statearr_35636_35678 = state_35561__$1;
(statearr_35636_35678[(2)] = inst_35554);

(statearr_35636_35678[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35562 === (9))){
var inst_35520 = (state_35561[(12)]);
var state_35561__$1 = state_35561;
var statearr_35637_35679 = state_35561__$1;
(statearr_35637_35679[(2)] = inst_35520);

(statearr_35637_35679[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35562 === (5))){
var _ = (function (){var statearr_35638 = state_35561;
(statearr_35638[(4)] = cljs.core.rest((state_35561[(4)])));

return statearr_35638;
})();
var state_35561__$1 = state_35561;
var ex35635 = (state_35561__$1[(2)]);
var statearr_35639_35680 = state_35561__$1;
(statearr_35639_35680[(5)] = ex35635);


if((ex35635 instanceof Error)){
var statearr_35640_35681 = state_35561__$1;
(statearr_35640_35681[(1)] = (4));

(statearr_35640_35681[(5)] = null);

} else {
throw ex35635;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35562 === (14))){
var inst_35552 = (state_35561[(2)]);
var state_35561__$1 = state_35561;
var statearr_35641_35682 = state_35561__$1;
(statearr_35641_35682[(2)] = inst_35552);

(statearr_35641_35682[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35562 === (16))){
var state_35561__$1 = state_35561;
var statearr_35642_35683 = state_35561__$1;
(statearr_35642_35683[(2)] = null);

(statearr_35642_35683[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35562 === (10))){
var inst_35523 = (state_35561[(7)]);
var inst_35527 = fluree.db.util.core.exception_QMARK_(inst_35523);
var state_35561__$1 = state_35561;
if(inst_35527){
var statearr_35643_35684 = state_35561__$1;
(statearr_35643_35684[(1)] = (12));

} else {
var statearr_35644_35685 = state_35561__$1;
(statearr_35644_35685[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35562 === (18))){
var inst_35512 = (state_35561[(9)]);
var inst_35536 = (inst_35512.cljs$core$IFn$_invoke$arity$0 ? inst_35512.cljs$core$IFn$_invoke$arity$0() : inst_35512.call(null));
var inst_35537 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_35538 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_35539 = [new cljs.core.Keyword("db","insufficient-fuel","db/insufficient-fuel",344386102),(400)];
var inst_35540 = cljs.core.PersistentHashMap.fromArrays(inst_35538,inst_35539);
var inst_35541 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_35537,inst_35540);
var state_35561__$1 = (function (){var statearr_35645 = state_35561;
(statearr_35645[(14)] = inst_35536);

return statearr_35645;
})();
var statearr_35646_35686 = state_35561__$1;
(statearr_35646_35686[(2)] = inst_35541);

(statearr_35646_35686[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35562 === (8))){
var inst_35523 = (state_35561[(7)]);
var inst_35523__$1 = (state_35561[(2)]);
var inst_35524 = (inst_35523__$1 == null);
var state_35561__$1 = (function (){var statearr_35647 = state_35561;
(statearr_35647[(7)] = inst_35523__$1);

return statearr_35647;
})();
if(cljs.core.truth_(inst_35524)){
var statearr_35648_35687 = state_35561__$1;
(statearr_35648_35687[(1)] = (9));

} else {
var statearr_35649_35688 = state_35561__$1;
(statearr_35649_35688[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11410__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11410__auto____0 = (function (){
var statearr_35650 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35650[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11410__auto__);

(statearr_35650[(1)] = (1));

return statearr_35650;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11410__auto____1 = (function (state_35561){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_35561);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e35651){var ex__11413__auto__ = e35651;
var statearr_35652_35689 = state_35561;
(statearr_35652_35689[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_35561[(4)]))){
var statearr_35653_35690 = state_35561;
(statearr_35653_35690[(1)] = cljs.core.first((state_35561[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35691 = state_35561;
state_35561 = G__35691;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11410__auto__ = function(state_35561){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11410__auto____1.call(this,state_35561);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11410__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11410__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_35654 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_35654[(6)] = c__11484__auto__);

return statearr_35654;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__35692 = select;
var map__35692__$1 = cljs.core.__destructure_map(map__35692);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35692__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35692__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35692__$1,new cljs.core.Keyword(null,"value","value",305978217));
var select_val = (function (){var or__4253__auto__ = as;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx(headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly(value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?cljs.core.constantly(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__35695 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35695,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35695,(1),null);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35695,(2),null);
var comparator = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?(function (a,b){
return cljs.core.compare(b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("NOCASE",clojure.string.upper_case(option))));
var keyfn = ((no_case_QMARK_)?(function (p1__35693_SHARP_){
return clojure.string.upper_case(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__35693_SHARP_,compare_idx));
}):(function (p1__35694_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__35694_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,(((no_case_QMARK_)?(4):(2)) * cljs.core.count(tuples)));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__35700 = arguments.length;
switch (G__35700) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__35701,p__35702,group_limit,opts){
var map__35703 = p__35701;
var map__35703__$1 = cljs.core.__destructure_map(map__35703);
var res = map__35703__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35703__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__35704 = p__35702;
var map__35704__$1 = cljs.core.__destructure_map(map__35704);
var select_spec = map__35704__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35704__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35704__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35704__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35704__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35704__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35704__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35704__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35704__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35704__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35704__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_35841){
var state_val_35842 = (state_35841[(1)]);
if((state_val_35842 === (7))){
var inst_35711 = (state_35841[(7)]);
var state_35841__$1 = state_35841;
var statearr_35843_35945 = state_35841__$1;
(statearr_35843_35945[(2)] = inst_35711);

(statearr_35843_35945[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (59))){
var inst_35834 = (state_35841[(2)]);
var state_35841__$1 = state_35841;
var statearr_35844_35946 = state_35841__$1;
(statearr_35844_35946[(2)] = inst_35834);

(statearr_35844_35946[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (20))){
var inst_35750 = (state_35841[(8)]);
var inst_35747 = (state_35841[(9)]);
var inst_35746 = (state_35841[(2)]);
var inst_35747__$1 = cljs.core.__destructure_map(inst_35746);
var inst_35748 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35747__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_35749 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35747__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_35750__$1 = offset;
var state_35841__$1 = (function (){var statearr_35845 = state_35841;
(statearr_35845[(10)] = inst_35749);

(statearr_35845[(8)] = inst_35750__$1);

(statearr_35845[(9)] = inst_35747__$1);

(statearr_35845[(11)] = inst_35748);

return statearr_35845;
})();
if(cljs.core.truth_(inst_35750__$1)){
var statearr_35846_35947 = state_35841__$1;
(statearr_35846_35947[(1)] = (21));

} else {
var statearr_35847_35948 = state_35841__$1;
(statearr_35847_35948[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (58))){
var inst_35826 = (state_35841[(12)]);
var state_35841__$1 = state_35841;
var statearr_35848_35949 = state_35841__$1;
(statearr_35848_35949[(2)] = inst_35826);

(statearr_35848_35949[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (60))){
var inst_35830 = (state_35841[(2)]);
var inst_35831 = fluree.db.util.async.throw_err(inst_35830);
var state_35841__$1 = state_35841;
var statearr_35849_35950 = state_35841__$1;
(statearr_35849_35950[(2)] = inst_35831);

(statearr_35849_35950[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (27))){
var inst_35762 = cljs.core.not(inVector_QMARK_);
var state_35841__$1 = state_35841;
var statearr_35850_35951 = state_35841__$1;
(statearr_35850_35951[(2)] = inst_35762);

(statearr_35850_35951[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (1))){
var state_35841__$1 = state_35841;
var statearr_35851_35952 = state_35841__$1;
(statearr_35851_35952[(2)] = null);

(statearr_35851_35952[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (24))){
var state_35841__$1 = state_35841;
var statearr_35852_35953 = state_35841__$1;
(statearr_35852_35953[(2)] = offset);

(statearr_35852_35953[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (55))){
var inst_35820 = (state_35841[(13)]);
var state_35841__$1 = state_35841;
var statearr_35853_35954 = state_35841__$1;
(statearr_35853_35954[(2)] = inst_35820);

(statearr_35853_35954[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (39))){
var inst_35788 = (state_35841[(14)]);
var inst_35790 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_35791 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_35788,inst_35790);
var state_35841__$1 = state_35841;
var statearr_35854_35955 = state_35841__$1;
(statearr_35854_35955[(2)] = inst_35791);

(statearr_35854_35955[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (46))){
var inst_35800 = (state_35841[(15)]);
var state_35841__$1 = state_35841;
var statearr_35855_35956 = state_35841__$1;
(statearr_35855_35956[(2)] = inst_35800);

(statearr_35855_35956[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (4))){
var inst_35705 = (state_35841[(2)]);
var state_35841__$1 = state_35841;
var statearr_35856_35957 = state_35841__$1;
(statearr_35856_35957[(2)] = inst_35705);

(statearr_35856_35957[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (54))){
var inst_35814 = (state_35841[(16)]);
var inst_35820 = (state_35841[(13)]);
var inst_35822 = cljs.core.PersistentVector.EMPTY;
var inst_35823 = cljs.core.into.cljs$core$IFn$_invoke$arity$3(inst_35822,inst_35814,inst_35820);
var state_35841__$1 = state_35841;
var statearr_35857_35958 = state_35841__$1;
(statearr_35857_35958[(2)] = inst_35823);

(statearr_35857_35958[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (15))){
var inst_35732 = (state_35841[(17)]);
var inst_35734 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35735 = [inst_35732];
var inst_35736 = (new cljs.core.PersistentVector(null,1,(5),inst_35734,inst_35735,null));
var state_35841__$1 = state_35841;
var statearr_35858_35959 = state_35841__$1;
(statearr_35858_35959[(2)] = inst_35736);

(statearr_35858_35959[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (48))){
var inst_35759 = (state_35841[(18)]);
var inst_35749 = (state_35841[(10)]);
var inst_35765 = (state_35841[(19)]);
var inst_35770 = (state_35841[(20)]);
var inst_35747 = (state_35841[(9)]);
var inst_35748 = (state_35841[(11)]);
var inst_35806 = (state_35841[(21)]);
var inst_35808 = (function (){var map__35741 = inst_35747;
var headers = inst_35748;
var tuples = inst_35749;
var offset_SINGLEQUOTE_ = inst_35759;
var single_result_QMARK_ = inst_35765;
var pp_keys = inst_35770;
var G__35771 = inst_35806;
return (function (p1__35698_SHARP_){
return cljs.core.zipmap(fluree.db.query.fql.get_pretty_print_keys(select),p1__35698_SHARP_);
});
})();
var inst_35809 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_35808);
var inst_35810 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_35806,inst_35809);
var state_35841__$1 = state_35841;
var statearr_35859_35960 = state_35841__$1;
(statearr_35859_35960[(2)] = inst_35810);

(statearr_35859_35960[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (50))){
var inst_35813 = (state_35841[(2)]);
var inst_35814 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,inst_35813);
var state_35841__$1 = (function (){var statearr_35860 = state_35841;
(statearr_35860[(16)] = inst_35814);

return statearr_35860;
})();
if(cljs.core.truth_(orderBy)){
var statearr_35861_35961 = state_35841__$1;
(statearr_35861_35961[(1)] = (51));

} else {
var statearr_35862_35962 = state_35841__$1;
(statearr_35862_35962[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (21))){
var inst_35752 = cljs.core.not(groupBy);
var state_35841__$1 = state_35841;
var statearr_35863_35963 = state_35841__$1;
(statearr_35863_35963[(2)] = inst_35752);

(statearr_35863_35963[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (31))){
var state_35841__$1 = state_35841;
var statearr_35864_35964 = state_35841__$1;
(statearr_35864_35964[(2)] = null);

(statearr_35864_35964[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (32))){
var inst_35765 = (state_35841[(19)]);
var inst_35748 = (state_35841[(11)]);
var inst_35770 = (state_35841[(2)]);
var inst_35772 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35773 = fluree.db.query.fql.select_tuples_fn(inst_35748,vars,select);
var inst_35774 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_35773);
var inst_35775 = [inst_35774];
var inst_35776 = (new cljs.core.PersistentVector(null,1,(5),inst_35772,inst_35775,null));
var state_35841__$1 = (function (){var statearr_35865 = state_35841;
(statearr_35865[(22)] = inst_35776);

(statearr_35865[(20)] = inst_35770);

return statearr_35865;
})();
if(cljs.core.truth_(inst_35765)){
var statearr_35866_35965 = state_35841__$1;
(statearr_35866_35965[(1)] = (33));

} else {
var statearr_35867_35966 = state_35841__$1;
(statearr_35867_35966[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (40))){
var inst_35788 = (state_35841[(14)]);
var state_35841__$1 = state_35841;
var statearr_35868_35967 = state_35841__$1;
(statearr_35868_35967[(2)] = inst_35788);

(statearr_35868_35967[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (56))){
var inst_35826 = (state_35841[(2)]);
var state_35841__$1 = (function (){var statearr_35869 = state_35841;
(statearr_35869[(12)] = inst_35826);

return statearr_35869;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_35870_35968 = state_35841__$1;
(statearr_35870_35968[(1)] = (57));

} else {
var statearr_35871_35969 = state_35841__$1;
(statearr_35871_35969[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (33))){
var inst_35776 = (state_35841[(22)]);
var inst_35778 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(cljs.core.first);
var inst_35779 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_35776,inst_35778);
var state_35841__$1 = state_35841;
var statearr_35872_35970 = state_35841__$1;
(statearr_35872_35970[(2)] = inst_35779);

(statearr_35872_35970[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (13))){
var inst_35721 = (state_35841[(23)]);
var state_35841__$1 = state_35841;
var statearr_35873_35971 = state_35841__$1;
(statearr_35873_35971[(2)] = inst_35721);

(statearr_35873_35971[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (22))){
var inst_35750 = (state_35841[(8)]);
var state_35841__$1 = state_35841;
var statearr_35874_35972 = state_35841__$1;
(statearr_35874_35972[(2)] = inst_35750);

(statearr_35874_35972[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (36))){
var inst_35782 = (state_35841[(24)]);
var inst_35784 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(5));
var inst_35785 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_35782,inst_35784);
var state_35841__$1 = state_35841;
var statearr_35875_35973 = state_35841__$1;
(statearr_35875_35973[(2)] = inst_35785);

(statearr_35875_35973[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (41))){
var inst_35759 = (state_35841[(18)]);
var inst_35794 = (state_35841[(2)]);
var state_35841__$1 = (function (){var statearr_35876 = state_35841;
(statearr_35876[(25)] = inst_35794);

return statearr_35876;
})();
if(cljs.core.truth_(inst_35759)){
var statearr_35877_35974 = state_35841__$1;
(statearr_35877_35974[(1)] = (42));

} else {
var statearr_35878_35975 = state_35841__$1;
(statearr_35878_35975[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (43))){
var inst_35794 = (state_35841[(25)]);
var state_35841__$1 = state_35841;
var statearr_35879_35976 = state_35841__$1;
(statearr_35879_35976[(2)] = inst_35794);

(statearr_35879_35976[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (29))){
var inst_35765 = (state_35841[(2)]);
var state_35841__$1 = (function (){var statearr_35880 = state_35841;
(statearr_35880[(19)] = inst_35765);

return statearr_35880;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_35881_35977 = state_35841__$1;
(statearr_35881_35977[(1)] = (30));

} else {
var statearr_35882_35978 = state_35841__$1;
(statearr_35882_35978[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (44))){
var inst_35800 = (state_35841[(2)]);
var state_35841__$1 = (function (){var statearr_35883 = state_35841;
(statearr_35883[(15)] = inst_35800);

return statearr_35883;
})();
if(cljs.core.truth_(group_limit)){
var statearr_35884_35979 = state_35841__$1;
(statearr_35884_35979[(1)] = (45));

} else {
var statearr_35885_35980 = state_35841__$1;
(statearr_35885_35980[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (6))){
var inst_35713 = cljs.core.count(select);
var inst_35714 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_35713);
var state_35841__$1 = state_35841;
var statearr_35886_35981 = state_35841__$1;
(statearr_35886_35981[(2)] = inst_35714);

(statearr_35886_35981[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (28))){
var inst_35760 = (state_35841[(26)]);
var state_35841__$1 = state_35841;
var statearr_35887_35982 = state_35841__$1;
(statearr_35887_35982[(2)] = inst_35760);

(statearr_35887_35982[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (51))){
var inst_35749 = (state_35841[(10)]);
var inst_35748 = (state_35841[(11)]);
var inst_35817 = fluree.db.query.fql.order_result_tuples(fuel,max_fuel,inst_35748,orderBy,inst_35749);
var state_35841__$1 = state_35841;
var statearr_35888_35983 = state_35841__$1;
(statearr_35888_35983[(2)] = inst_35817);

(statearr_35888_35983[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (25))){
var state_35841__$1 = state_35841;
var statearr_35889_35984 = state_35841__$1;
(statearr_35889_35984[(2)] = null);

(statearr_35889_35984[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (34))){
var inst_35776 = (state_35841[(22)]);
var state_35841__$1 = state_35841;
var statearr_35890_35985 = state_35841__$1;
(statearr_35890_35985[(2)] = inst_35776);

(statearr_35890_35985[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (17))){
var inst_35739 = (state_35841[(2)]);
var state_35841__$1 = state_35841;
var statearr_35891_35986 = state_35841__$1;
(statearr_35891_35986[(2)] = inst_35739);

(statearr_35891_35986[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (3))){
var inst_35839 = (state_35841[(2)]);
var state_35841__$1 = state_35841;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35841__$1,inst_35839);
} else {
if((state_val_35842 === (12))){
var inst_35721 = (state_35841[(23)]);
var inst_35723 = cljs.core.first(select);
var inst_35724 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_35723);
var inst_35725 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35724);
var inst_35726 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_35725,(1));
var inst_35727 = [inst_35726];
var inst_35728 = [inst_35721];
var inst_35729 = cljs.core.PersistentHashMap.fromArrays(inst_35727,inst_35728);
var state_35841__$1 = state_35841;
var statearr_35892_35987 = state_35841__$1;
(statearr_35892_35987[(2)] = inst_35729);

(statearr_35892_35987[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (2))){
var inst_35711 = (state_35841[(7)]);
var _ = (function (){var statearr_35893 = state_35841;
(statearr_35893[(4)] = cljs.core.cons((5),(state_35841[(4)])));

return statearr_35893;
})();
var inst_35711__$1 = aggregates;
var state_35841__$1 = (function (){var statearr_35894 = state_35841;
(statearr_35894[(7)] = inst_35711__$1);

return statearr_35894;
})();
if(cljs.core.truth_(inst_35711__$1)){
var statearr_35895_35988 = state_35841__$1;
(statearr_35895_35988[(1)] = (6));

} else {
var statearr_35896_35989 = state_35841__$1;
(statearr_35896_35989[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (23))){
var inst_35755 = (state_35841[(2)]);
var state_35841__$1 = state_35841;
if(cljs.core.truth_(inst_35755)){
var statearr_35897_35990 = state_35841__$1;
(statearr_35897_35990[(1)] = (24));

} else {
var statearr_35898_35991 = state_35841__$1;
(statearr_35898_35991[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (47))){
var inst_35806 = (state_35841[(2)]);
var state_35841__$1 = (function (){var statearr_35899 = state_35841;
(statearr_35899[(21)] = inst_35806);

return statearr_35899;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_35900_35992 = state_35841__$1;
(statearr_35900_35992[(1)] = (48));

} else {
var statearr_35901_35993 = state_35841__$1;
(statearr_35901_35993[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (35))){
var inst_35782 = (state_35841[(2)]);
var state_35841__$1 = (function (){var statearr_35902 = state_35841;
(statearr_35902[(24)] = inst_35782);

return statearr_35902;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_35903_35994 = state_35841__$1;
(statearr_35903_35994[(1)] = (36));

} else {
var statearr_35904_35995 = state_35841__$1;
(statearr_35904_35995[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (19))){
var state_35841__$1 = state_35841;
var statearr_35905_35996 = state_35841__$1;
(statearr_35905_35996[(2)] = res);

(statearr_35905_35996[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (57))){
var inst_35765 = (state_35841[(19)]);
var inst_35826 = (state_35841[(12)]);
var inst_35770 = (state_35841[(20)]);
var inst_35828 = fluree.db.query.fql.pipeline_expandmaps_result(select,inst_35770,inst_35765,db,fuel,max_fuel,opts,(8),inst_35826);
var state_35841__$1 = state_35841;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35841__$1,(60),inst_35828);
} else {
if((state_val_35842 === (11))){
var inst_35836 = (state_35841[(2)]);
var _ = (function (){var statearr_35907 = state_35841;
(statearr_35907[(4)] = cljs.core.rest((state_35841[(4)])));

return statearr_35907;
})();
var state_35841__$1 = state_35841;
var statearr_35908_35997 = state_35841__$1;
(statearr_35908_35997[(2)] = inst_35836);

(statearr_35908_35997[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (9))){
var inst_35719 = cljs.core.first(aggregates);
var inst_35720 = fluree.db.query.analytical.calculate_aggregate(res,inst_35719);
var inst_35721 = cljs.core.second(inst_35720);
var state_35841__$1 = (function (){var statearr_35909 = state_35841;
(statearr_35909[(23)] = inst_35721);

return statearr_35909;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_35910_35998 = state_35841__$1;
(statearr_35910_35998[(1)] = (12));

} else {
var statearr_35911_35999 = state_35841__$1;
(statearr_35911_35999[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (5))){
var _ = (function (){var statearr_35912 = state_35841;
(statearr_35912[(4)] = cljs.core.rest((state_35841[(4)])));

return statearr_35912;
})();
var state_35841__$1 = state_35841;
var ex35906 = (state_35841__$1[(2)]);
var statearr_35913_36000 = state_35841__$1;
(statearr_35913_36000[(5)] = ex35906);


if((ex35906 instanceof Error)){
var statearr_35914_36001 = state_35841__$1;
(statearr_35914_36001[(1)] = (4));

(statearr_35914_36001[(5)] = null);

} else {
throw ex35906;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (14))){
var inst_35732 = (state_35841[(2)]);
var state_35841__$1 = (function (){var statearr_35915 = state_35841;
(statearr_35915[(17)] = inst_35732);

return statearr_35915;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_35916_36002 = state_35841__$1;
(statearr_35916_36002[(1)] = (15));

} else {
var statearr_35917_36003 = state_35841__$1;
(statearr_35917_36003[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (45))){
var inst_35800 = (state_35841[(15)]);
var inst_35802 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(group_limit);
var inst_35803 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_35800,inst_35802);
var state_35841__$1 = state_35841;
var statearr_35918_36004 = state_35841__$1;
(statearr_35918_36004[(2)] = inst_35803);

(statearr_35918_36004[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (53))){
var inst_35820 = (state_35841[(2)]);
var state_35841__$1 = (function (){var statearr_35919 = state_35841;
(statearr_35919[(13)] = inst_35820);

return statearr_35919;
})();
var statearr_35920_36005 = state_35841__$1;
(statearr_35920_36005[(1)] = (54));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (26))){
var inst_35760 = (state_35841[(26)]);
var inst_35759 = (state_35841[(2)]);
var inst_35760__$1 = cljs.core.not(prettyPrint);
var state_35841__$1 = (function (){var statearr_35922 = state_35841;
(statearr_35922[(26)] = inst_35760__$1);

(statearr_35922[(18)] = inst_35759);

return statearr_35922;
})();
if(inst_35760__$1){
var statearr_35923_36006 = state_35841__$1;
(statearr_35923_36006[(1)] = (27));

} else {
var statearr_35924_36007 = state_35841__$1;
(statearr_35924_36007[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (16))){
var inst_35732 = (state_35841[(17)]);
var state_35841__$1 = state_35841;
var statearr_35925_36008 = state_35841__$1;
(statearr_35925_36008[(2)] = inst_35732);

(statearr_35925_36008[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (38))){
var inst_35788 = (state_35841[(2)]);
var state_35841__$1 = (function (){var statearr_35926 = state_35841;
(statearr_35926[(14)] = inst_35788);

return statearr_35926;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_35927_36009 = state_35841__$1;
(statearr_35927_36009[(1)] = (39));

} else {
var statearr_35928_36010 = state_35841__$1;
(statearr_35928_36010[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (30))){
var inst_35767 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_35841__$1 = state_35841;
var statearr_35929_36011 = state_35841__$1;
(statearr_35929_36011[(2)] = inst_35767);

(statearr_35929_36011[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (10))){
var state_35841__$1 = state_35841;
if(cljs.core.truth_(aggregates)){
var statearr_35930_36012 = state_35841__$1;
(statearr_35930_36012[(1)] = (18));

} else {
var statearr_35931_36013 = state_35841__$1;
(statearr_35931_36013[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (18))){
var inst_35743 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_35841__$1 = state_35841;
var statearr_35932_36014 = state_35841__$1;
(statearr_35932_36014[(2)] = inst_35743);

(statearr_35932_36014[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (52))){
var inst_35749 = (state_35841[(10)]);
var state_35841__$1 = state_35841;
var statearr_35933_36015 = state_35841__$1;
(statearr_35933_36015[(2)] = inst_35749);

(statearr_35933_36015[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (42))){
var inst_35794 = (state_35841[(25)]);
var inst_35759 = (state_35841[(18)]);
var inst_35796 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(inst_35759);
var inst_35797 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_35794,inst_35796);
var state_35841__$1 = state_35841;
var statearr_35934_36016 = state_35841__$1;
(statearr_35934_36016[(2)] = inst_35797);

(statearr_35934_36016[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (37))){
var inst_35782 = (state_35841[(24)]);
var state_35841__$1 = state_35841;
var statearr_35935_36017 = state_35841__$1;
(statearr_35935_36017[(2)] = inst_35782);

(statearr_35935_36017[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (8))){
var inst_35717 = (state_35841[(2)]);
var state_35841__$1 = state_35841;
if(cljs.core.truth_(inst_35717)){
var statearr_35936_36018 = state_35841__$1;
(statearr_35936_36018[(1)] = (9));

} else {
var statearr_35937_36019 = state_35841__$1;
(statearr_35937_36019[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35842 === (49))){
var inst_35806 = (state_35841[(21)]);
var state_35841__$1 = state_35841;
var statearr_35938_36020 = state_35841__$1;
(statearr_35938_36020[(2)] = inst_35806);

(statearr_35938_36020[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__11410__auto__ = null;
var fluree$db$query$fql$state_machine__11410__auto____0 = (function (){
var statearr_35939 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35939[(0)] = fluree$db$query$fql$state_machine__11410__auto__);

(statearr_35939[(1)] = (1));

return statearr_35939;
});
var fluree$db$query$fql$state_machine__11410__auto____1 = (function (state_35841){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_35841);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e35940){var ex__11413__auto__ = e35940;
var statearr_35941_36021 = state_35841;
(statearr_35941_36021[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_35841[(4)]))){
var statearr_35942_36022 = state_35841;
(statearr_35942_36022[(1)] = cljs.core.first((state_35841[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36023 = state_35841;
state_35841 = G__36023;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__11410__auto__ = function(state_35841){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__11410__auto____1.call(this,state_35841);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__11410__auto____0;
fluree$db$query$fql$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__11410__auto____1;
return fluree$db$query$fql$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_35943 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_35943[(6)] = c__11484__auto__);

return statearr_35943;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__36026,groupBy){
var map__36027 = p__36026;
var map__36027__$1 = cljs.core.__destructure_map(map__36027);
var res = map__36027__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36027__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36027__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__36028 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36028,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36028,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36024_SHARP_){
return fluree.db.util.core.index_of(headers,p1__36024_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36025_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__36025_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__36031 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36031,(0),null);
var sortCriteria = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36031,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortCriteria,groupBy)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_(groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of(groupBy,sortCriteria);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__36034,p__36035,opts){
var map__36036 = p__36034;
var map__36036__$1 = cljs.core.__destructure_map(map__36036);
var res = map__36036__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36036__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36036__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__36037 = p__36035;
var map__36037__$1 = cljs.core.__destructure_map(map__36037);
var select_spec = map__36037__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36037__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36037__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36037__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36037__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36037__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36037__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36037__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_36279){
var state_val_36280 = (state_36279[(1)]);
if((state_val_36280 === (65))){
var state_36279__$1 = state_36279;
var statearr_36281_36432 = state_36279__$1;
(statearr_36281_36432[(1)] = (67));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (70))){
var inst_36200 = (state_36279[(7)]);
var state_36279__$1 = state_36279;
var statearr_36283_36433 = state_36279__$1;
(statearr_36283_36433[(2)] = inst_36200);

(statearr_36283_36433[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (62))){
var state_36279__$1 = state_36279;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_36284_36434 = state_36279__$1;
(statearr_36284_36434[(1)] = (64));

} else {
var statearr_36285_36435 = state_36279__$1;
(statearr_36285_36435[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (74))){
var inst_36175 = (state_36279[(8)]);
var inst_36107 = (state_36279[(9)]);
var inst_36116 = (state_36279[(10)]);
var inst_36208 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_36107,inst_36116,inst_36175);
var state_36279__$1 = state_36279;
var statearr_36286_36436 = state_36279__$1;
(statearr_36286_36436[(2)] = inst_36208);

(statearr_36286_36436[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (7))){
var state_36279__$1 = state_36279;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_36287_36437 = state_36279__$1;
(statearr_36287_36437[(1)] = (82));

} else {
var statearr_36288_36438 = state_36279__$1;
(statearr_36288_36438[(1)] = (83));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (59))){
var inst_36175 = (state_36279[(8)]);
var inst_36105 = (state_36279[(11)]);
var inst_36179 = cljs.core.count(inst_36175);
var inst_36180 = (inst_36105 - inst_36179);
var state_36279__$1 = state_36279;
var statearr_36289_36439 = state_36279__$1;
(statearr_36289_36439[(2)] = inst_36180);

(statearr_36289_36439[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (86))){
var state_36279__$1 = state_36279;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_36290_36440 = state_36279__$1;
(statearr_36290_36440[(1)] = (89));

} else {
var statearr_36291_36441 = state_36279__$1;
(statearr_36291_36441[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (20))){
var state_36279__$1 = state_36279;
var statearr_36292_36442 = state_36279__$1;
(statearr_36292_36442[(2)] = (0));

(statearr_36292_36442[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (72))){
var inst_36205 = (state_36279[(2)]);
var state_36279__$1 = state_36279;
if(cljs.core.truth_(inst_36205)){
var statearr_36293_36443 = state_36279__$1;
(statearr_36293_36443[(1)] = (73));

} else {
var statearr_36294_36444 = state_36279__$1;
(statearr_36294_36444[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (58))){
var state_36279__$1 = state_36279;
var statearr_36295_36445 = state_36279__$1;
(statearr_36295_36445[(2)] = null);

(statearr_36295_36445[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (60))){
var inst_36106 = (state_36279[(12)]);
var inst_36182 = (state_36279[(2)]);
var inst_36183 = (inst_36106 <= (0));
var state_36279__$1 = (function (){var statearr_36296 = state_36279;
(statearr_36296[(13)] = inst_36182);

return statearr_36296;
})();
if(cljs.core.truth_(inst_36183)){
var statearr_36297_36446 = state_36279__$1;
(statearr_36297_36446[(1)] = (61));

} else {
var statearr_36298_36447 = state_36279__$1;
(statearr_36298_36447[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (27))){
var inst_36105 = (state_36279[(11)]);
var inst_36129 = (inst_36105 < (1));
var state_36279__$1 = state_36279;
var statearr_36299_36448 = state_36279__$1;
(statearr_36299_36448[(2)] = inst_36129);

(statearr_36299_36448[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (1))){
var state_36279__$1 = state_36279;
var statearr_36300_36449 = state_36279__$1;
(statearr_36300_36449[(2)] = null);

(statearr_36300_36449[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (69))){
var inst_36195 = (state_36279[(2)]);
var state_36279__$1 = state_36279;
var statearr_36301_36450 = state_36279__$1;
(statearr_36301_36450[(2)] = inst_36195);

(statearr_36301_36450[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (24))){
var inst_36107 = (state_36279[(9)]);
var state_36279__$1 = state_36279;
var statearr_36302_36451 = state_36279__$1;
(statearr_36302_36451[(2)] = inst_36107);

(statearr_36302_36451[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (55))){
var inst_36165 = (state_36279[(14)]);
var inst_36105 = (state_36279[(11)]);
var inst_36172 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_36105,inst_36165);
var state_36279__$1 = state_36279;
var statearr_36303_36452 = state_36279__$1;
(statearr_36303_36452[(2)] = inst_36172);

(statearr_36303_36452[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (85))){
var inst_36250 = (state_36279[(15)]);
var inst_36249 = (state_36279[(2)]);
var inst_36250__$1 = fluree.db.util.async.throw_err(inst_36249);
var inst_36251 = cljs.core.coll_QMARK_(inst_36250__$1);
var inst_36252 = (!(inst_36251));
var state_36279__$1 = (function (){var statearr_36304 = state_36279;
(statearr_36304[(15)] = inst_36250__$1);

return statearr_36304;
})();
if(inst_36252){
var statearr_36305_36453 = state_36279__$1;
(statearr_36305_36453[(1)] = (86));

} else {
var statearr_36306_36454 = state_36279__$1;
(statearr_36306_36454[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (39))){
var inst_36124 = (state_36279[(16)]);
var inst_36146 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(select_spec,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null], 0));
var inst_36147 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"offset","offset",296498311),(0),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"limit","limit",-1355822363),null], 0));
var inst_36148 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6(db,fuel,max_fuel,inst_36124,inst_36146,inst_36147);
var state_36279__$1 = state_36279;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36279__$1,(42),inst_36148);
} else {
if((state_val_36280 === (88))){
var inst_36272 = (state_36279[(2)]);
var state_36279__$1 = state_36279;
var statearr_36307_36455 = state_36279__$1;
(statearr_36307_36455[(2)] = inst_36272);

(statearr_36307_36455[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (46))){
var inst_36106 = (state_36279[(12)]);
var inst_36160 = ((0) < inst_36106);
var state_36279__$1 = state_36279;
if(cljs.core.truth_(inst_36160)){
var statearr_36308_36456 = state_36279__$1;
(statearr_36308_36456[(1)] = (49));

} else {
var statearr_36309_36457 = state_36279__$1;
(statearr_36309_36457[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (4))){
var inst_36038 = (state_36279[(2)]);
var state_36279__$1 = state_36279;
var statearr_36310_36458 = state_36279__$1;
(statearr_36310_36458[(2)] = inst_36038);

(statearr_36310_36458[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (77))){
var inst_36105 = (state_36279[(11)]);
var inst_36216 = (inst_36105 - (1));
var state_36279__$1 = state_36279;
var statearr_36311_36459 = state_36279__$1;
(statearr_36311_36459[(2)] = inst_36216);

(statearr_36311_36459[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (95))){
var inst_36250 = (state_36279[(15)]);
var state_36279__$1 = state_36279;
var statearr_36312_36460 = state_36279__$1;
(statearr_36312_36460[(2)] = inst_36250);

(statearr_36312_36460[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (54))){
var inst_36170 = (state_36279[(2)]);
var state_36279__$1 = state_36279;
if(cljs.core.truth_(inst_36170)){
var statearr_36313_36461 = state_36279__$1;
(statearr_36313_36461[(1)] = (55));

} else {
var statearr_36314_36462 = state_36279__$1;
(statearr_36314_36462[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (92))){
var inst_36250 = (state_36279[(15)]);
var inst_36263 = cljs.core.first(inst_36250);
var state_36279__$1 = state_36279;
var statearr_36315_36463 = state_36279__$1;
(statearr_36315_36463[(2)] = inst_36263);

(statearr_36315_36463[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (15))){
var inst_36056 = (state_36279[(17)]);
var inst_36064 = (state_36279[(2)]);
var inst_36065 = fluree.db.util.async.throw_err(inst_36064);
var inst_36066 = [inst_36056];
var inst_36067 = [inst_36065];
var inst_36068 = cljs.core.PersistentHashMap.fromArrays(inst_36066,inst_36067);
var state_36279__$1 = state_36279;
var statearr_36316_36464 = state_36279__$1;
(statearr_36316_36464[(2)] = inst_36068);

(statearr_36316_36464[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (48))){
var inst_36228 = (state_36279[(2)]);
var state_36279__$1 = state_36279;
var statearr_36317_36465 = state_36279__$1;
(statearr_36317_36465[(2)] = inst_36228);

(statearr_36317_36465[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (50))){
var inst_36151 = (state_36279[(18)]);
var state_36279__$1 = state_36279;
var statearr_36318_36466 = state_36279__$1;
(statearr_36318_36466[(2)] = inst_36151);

(statearr_36318_36466[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (75))){
var inst_36182 = (state_36279[(13)]);
var inst_36199 = (state_36279[(19)]);
var inst_36120 = (state_36279[(20)]);
var inst_36117 = (state_36279[(21)]);
var inst_36210 = (state_36279[(2)]);
var inst_36103 = inst_36117;
var inst_36104 = inst_36120;
var inst_36105 = inst_36182;
var inst_36106 = inst_36199;
var inst_36107 = inst_36210;
var state_36279__$1 = (function (){var statearr_36319 = state_36279;
(statearr_36319[(22)] = inst_36103);

(statearr_36319[(12)] = inst_36106);

(statearr_36319[(9)] = inst_36107);

(statearr_36319[(11)] = inst_36105);

(statearr_36319[(23)] = inst_36104);

return statearr_36319;
})();
var statearr_36320_36467 = state_36279__$1;
(statearr_36320_36467[(2)] = null);

(statearr_36320_36467[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (21))){
var inst_36084 = (state_36279[(24)]);
var inst_36096 = (state_36279[(25)]);
var inst_36088 = (state_36279[(26)]);
var inst_36101 = (state_36279[(2)]);
var inst_36102 = cljs.core.PersistentHashMap.EMPTY;
var inst_36103 = inst_36084;
var inst_36104 = inst_36088;
var inst_36105 = inst_36096;
var inst_36106 = inst_36101;
var inst_36107 = inst_36102;
var state_36279__$1 = (function (){var statearr_36321 = state_36279;
(statearr_36321[(22)] = inst_36103);

(statearr_36321[(12)] = inst_36106);

(statearr_36321[(9)] = inst_36107);

(statearr_36321[(11)] = inst_36105);

(statearr_36321[(23)] = inst_36104);

return statearr_36321;
})();
var statearr_36322_36468 = state_36279__$1;
(statearr_36322_36468[(2)] = null);

(statearr_36322_36468[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (31))){
var inst_36106 = (state_36279[(12)]);
var inst_36121 = (state_36279[(27)]);
var inst_36135 = (inst_36106 >= inst_36121);
var state_36279__$1 = state_36279;
if(cljs.core.truth_(inst_36135)){
var statearr_36323_36469 = state_36279__$1;
(statearr_36323_36469[(1)] = (33));

} else {
var statearr_36324_36470 = state_36279__$1;
(statearr_36324_36470[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (32))){
var inst_36235 = (state_36279[(2)]);
var state_36279__$1 = state_36279;
var statearr_36325_36471 = state_36279__$1;
(statearr_36325_36471[(2)] = inst_36235);

(statearr_36325_36471[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (40))){
var state_36279__$1 = state_36279;
var statearr_36326_36472 = state_36279__$1;
(statearr_36326_36472[(2)] = null);

(statearr_36326_36472[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (91))){
var inst_36260 = (state_36279[(2)]);
var state_36279__$1 = state_36279;
var statearr_36327_36473 = state_36279__$1;
(statearr_36327_36473[(2)] = inst_36260);

(statearr_36327_36473[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (56))){
var inst_36165 = (state_36279[(14)]);
var state_36279__$1 = state_36279;
var statearr_36328_36474 = state_36279__$1;
(statearr_36328_36474[(2)] = inst_36165);

(statearr_36328_36474[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (33))){
var state_36279__$1 = state_36279;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_36329_36475 = state_36279__$1;
(statearr_36329_36475[(1)] = (36));

} else {
var statearr_36330_36476 = state_36279__$1;
(statearr_36330_36476[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (13))){
var inst_36084 = (state_36279[(24)]);
var inst_36053 = (state_36279[(28)]);
var inst_36088 = (state_36279[(26)]);
var inst_36084__$1 = cljs.core.keys(inst_36053);
var inst_36085 = cljs.core.seq(inst_36084__$1);
var inst_36086 = cljs.core.first(inst_36085);
var inst_36087 = cljs.core.next(inst_36085);
var inst_36088__$1 = cljs.core.vals(inst_36053);
var inst_36089 = cljs.core.seq(inst_36088__$1);
var inst_36090 = cljs.core.first(inst_36089);
var inst_36091 = cljs.core.next(inst_36089);
var inst_36092 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),limit);
var state_36279__$1 = (function (){var statearr_36331 = state_36279;
(statearr_36331[(29)] = inst_36091);

(statearr_36331[(24)] = inst_36084__$1);

(statearr_36331[(30)] = inst_36086);

(statearr_36331[(31)] = inst_36087);

(statearr_36331[(26)] = inst_36088__$1);

(statearr_36331[(32)] = inst_36090);

return statearr_36331;
})();
if(inst_36092){
var statearr_36332_36477 = state_36279__$1;
(statearr_36332_36477[(1)] = (16));

} else {
var statearr_36333_36478 = state_36279__$1;
(statearr_36333_36478[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (22))){
var inst_36103 = (state_36279[(22)]);
var inst_36104 = (state_36279[(23)]);
var inst_36115 = cljs.core.seq(inst_36103);
var inst_36116 = cljs.core.first(inst_36115);
var inst_36117 = cljs.core.next(inst_36115);
var inst_36118 = cljs.core.seq(inst_36104);
var inst_36119 = cljs.core.first(inst_36118);
var inst_36120 = cljs.core.next(inst_36118);
var inst_36121 = cljs.core.count(inst_36119);
var inst_36122 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_36123 = [headers,vars,inst_36119];
var inst_36124 = cljs.core.PersistentHashMap.fromArrays(inst_36122,inst_36123);
var inst_36125 = (inst_36119 == null);
var state_36279__$1 = (function (){var statearr_36334 = state_36279;
(statearr_36334[(16)] = inst_36124);

(statearr_36334[(20)] = inst_36120);

(statearr_36334[(21)] = inst_36117);

(statearr_36334[(27)] = inst_36121);

(statearr_36334[(10)] = inst_36116);

return statearr_36334;
})();
if(cljs.core.truth_(inst_36125)){
var statearr_36335_36479 = state_36279__$1;
(statearr_36335_36479[(1)] = (24));

} else {
var statearr_36336_36480 = state_36279__$1;
(statearr_36336_36480[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (90))){
var inst_36250 = (state_36279[(15)]);
var state_36279__$1 = state_36279;
var statearr_36337_36481 = state_36279__$1;
(statearr_36337_36481[(2)] = inst_36250);

(statearr_36337_36481[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (36))){
var inst_36106 = (state_36279[(12)]);
var inst_36138 = (inst_36106 - (1));
var state_36279__$1 = state_36279;
var statearr_36338_36482 = state_36279__$1;
(statearr_36338_36482[(2)] = inst_36138);

(statearr_36338_36482[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (41))){
var inst_36231 = (state_36279[(2)]);
var state_36279__$1 = state_36279;
var statearr_36339_36483 = state_36279__$1;
(statearr_36339_36483[(2)] = inst_36231);

(statearr_36339_36483[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (89))){
var inst_36250 = (state_36279[(15)]);
var inst_36255 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36256 = [inst_36250];
var inst_36257 = (new cljs.core.PersistentVector(null,1,(5),inst_36255,inst_36256,null));
var state_36279__$1 = state_36279;
var statearr_36340_36484 = state_36279__$1;
(statearr_36340_36484[(2)] = inst_36257);

(statearr_36340_36484[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (43))){
var inst_36151 = (state_36279[(18)]);
var inst_36154 = cljs.core.seq(inst_36151);
var state_36279__$1 = state_36279;
var statearr_36341_36485 = state_36279__$1;
(statearr_36341_36485[(2)] = inst_36154);

(statearr_36341_36485[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (61))){
var state_36279__$1 = state_36279;
var statearr_36342_36486 = state_36279__$1;
(statearr_36342_36486[(2)] = (0));

(statearr_36342_36486[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (29))){
var inst_36132 = (state_36279[(2)]);
var state_36279__$1 = state_36279;
if(cljs.core.truth_(inst_36132)){
var statearr_36343_36487 = state_36279__$1;
(statearr_36343_36487[(1)] = (30));

} else {
var statearr_36344_36488 = state_36279__$1;
(statearr_36344_36488[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (44))){
var inst_36152 = (state_36279[(33)]);
var state_36279__$1 = state_36279;
var statearr_36345_36489 = state_36279__$1;
(statearr_36345_36489[(2)] = inst_36152);

(statearr_36345_36489[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (93))){
var state_36279__$1 = state_36279;
var statearr_36346_36490 = state_36279__$1;
(statearr_36346_36490[(1)] = (95));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (6))){
var inst_36045 = (state_36279[(34)]);
var inst_36045__$1 = fluree.db.query.fql.build_order_fn(orderBy,groupBy);
var inst_36047 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var state_36279__$1 = (function (){var statearr_36348 = state_36279;
(statearr_36348[(35)] = inst_36047);

(statearr_36348[(34)] = inst_36045__$1);

return statearr_36348;
})();
if(cljs.core.truth_(inst_36045__$1)){
var statearr_36349_36491 = state_36279__$1;
(statearr_36349_36491[(1)] = (9));

} else {
var statearr_36350_36492 = state_36279__$1;
(statearr_36350_36492[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (28))){
var inst_36105 = (state_36279[(11)]);
var state_36279__$1 = state_36279;
var statearr_36351_36493 = state_36279__$1;
(statearr_36351_36493[(2)] = inst_36105);

(statearr_36351_36493[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (64))){
var inst_36106 = (state_36279[(12)]);
var inst_36187 = (inst_36106 - (1));
var state_36279__$1 = state_36279;
var statearr_36352_36494 = state_36279__$1;
(statearr_36352_36494[(2)] = inst_36187);

(statearr_36352_36494[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (51))){
var inst_36105 = (state_36279[(11)]);
var inst_36165 = (state_36279[(2)]);
var state_36279__$1 = (function (){var statearr_36353 = state_36279;
(statearr_36353[(14)] = inst_36165);

return statearr_36353;
})();
if(cljs.core.truth_(inst_36105)){
var statearr_36354_36495 = state_36279__$1;
(statearr_36354_36495[(1)] = (52));

} else {
var statearr_36355_36496 = state_36279__$1;
(statearr_36355_36496[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (25))){
var inst_36105 = (state_36279[(11)]);
var state_36279__$1 = state_36279;
if(cljs.core.truth_(inst_36105)){
var statearr_36356_36497 = state_36279__$1;
(statearr_36356_36497[(1)] = (27));

} else {
var statearr_36357_36498 = state_36279__$1;
(statearr_36357_36498[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (34))){
var state_36279__$1 = state_36279;
var statearr_36358_36499 = state_36279__$1;
(statearr_36358_36499[(1)] = (39));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (17))){
var state_36279__$1 = state_36279;
var statearr_36360_36500 = state_36279__$1;
(statearr_36360_36500[(2)] = limit);

(statearr_36360_36500[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (3))){
var inst_36277 = (state_36279[(2)]);
var state_36279__$1 = state_36279;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36279__$1,inst_36277);
} else {
if((state_val_36280 === (12))){
var inst_36053 = (state_36279[(28)]);
var inst_36055 = cljs.core.keys(inst_36053);
var inst_36056 = cljs.core.first(inst_36055);
var inst_36057 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_36058 = cljs.core.vals(inst_36053);
var inst_36059 = cljs.core.first(inst_36058);
var inst_36060 = [headers,vars,inst_36059];
var inst_36061 = cljs.core.PersistentHashMap.fromArrays(inst_36057,inst_36060);
var inst_36062 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,inst_36061,select_spec,limit,opts);
var state_36279__$1 = (function (){var statearr_36361 = state_36279;
(statearr_36361[(17)] = inst_36056);

return statearr_36361;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36279__$1,(15),inst_36062);
} else {
if((state_val_36280 === (2))){
var _ = (function (){var statearr_36362 = state_36279;
(statearr_36362[(4)] = cljs.core.cons((5),(state_36279[(4)])));

return statearr_36362;
})();
var state_36279__$1 = state_36279;
if(cljs.core.truth_(groupBy)){
var statearr_36363_36501 = state_36279__$1;
(statearr_36363_36501[(1)] = (6));

} else {
var statearr_36364_36502 = state_36279__$1;
(statearr_36364_36502[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (66))){
var inst_36197 = (state_36279[(2)]);
var state_36279__$1 = state_36279;
var statearr_36365_36503 = state_36279__$1;
(statearr_36365_36503[(2)] = inst_36197);

(statearr_36365_36503[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (23))){
var inst_36239 = (state_36279[(2)]);
var state_36279__$1 = state_36279;
var statearr_36366_36504 = state_36279__$1;
(statearr_36366_36504[(2)] = inst_36239);

(statearr_36366_36504[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (47))){
var inst_36105 = (state_36279[(11)]);
var inst_36213 = (inst_36105 == null);
var state_36279__$1 = state_36279;
if(cljs.core.truth_(inst_36213)){
var statearr_36367_36505 = state_36279__$1;
(statearr_36367_36505[(1)] = (76));

} else {
var statearr_36368_36506 = state_36279__$1;
(statearr_36368_36506[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (35))){
var inst_36233 = (state_36279[(2)]);
var state_36279__$1 = state_36279;
var statearr_36369_36507 = state_36279__$1;
(statearr_36369_36507[(2)] = inst_36233);

(statearr_36369_36507[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (82))){
var state_36279__$1 = state_36279;
var statearr_36370_36508 = state_36279__$1;
(statearr_36370_36508[(2)] = (1));

(statearr_36370_36508[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (76))){
var state_36279__$1 = state_36279;
var statearr_36371_36509 = state_36279__$1;
(statearr_36371_36509[(2)] = null);

(statearr_36371_36509[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (97))){
var inst_36268 = (state_36279[(2)]);
var state_36279__$1 = state_36279;
var statearr_36372_36510 = state_36279__$1;
(statearr_36372_36510[(2)] = inst_36268);

(statearr_36372_36510[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (19))){
var inst_36097 = (state_36279[(36)]);
var state_36279__$1 = state_36279;
var statearr_36373_36511 = state_36279__$1;
(statearr_36373_36511[(2)] = inst_36097);

(statearr_36373_36511[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (57))){
var inst_36105 = (state_36279[(11)]);
var inst_36175 = (state_36279[(2)]);
var inst_36176 = (inst_36105 == null);
var state_36279__$1 = (function (){var statearr_36374 = state_36279;
(statearr_36374[(8)] = inst_36175);

return statearr_36374;
})();
if(cljs.core.truth_(inst_36176)){
var statearr_36375_36512 = state_36279__$1;
(statearr_36375_36512[(1)] = (58));

} else {
var statearr_36376_36513 = state_36279__$1;
(statearr_36376_36513[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (68))){
var state_36279__$1 = state_36279;
var statearr_36377_36514 = state_36279__$1;
(statearr_36377_36514[(2)] = null);

(statearr_36377_36514[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (11))){
var inst_36053 = (state_36279[(2)]);
var state_36279__$1 = (function (){var statearr_36379 = state_36279;
(statearr_36379[(28)] = inst_36053);

return statearr_36379;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_36380_36515 = state_36279__$1;
(statearr_36380_36515[(1)] = (12));

} else {
var statearr_36381_36516 = state_36279__$1;
(statearr_36381_36516[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (9))){
var inst_36047 = (state_36279[(35)]);
var inst_36045 = (state_36279[(34)]);
var inst_36049 = cljs.core.sorted_map_by(inst_36045);
var inst_36050 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_36049,inst_36047);
var state_36279__$1 = state_36279;
var statearr_36382_36517 = state_36279__$1;
(statearr_36382_36517[(2)] = inst_36050);

(statearr_36382_36517[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (5))){
var _ = (function (){var statearr_36383 = state_36279;
(statearr_36383[(4)] = cljs.core.rest((state_36279[(4)])));

return statearr_36383;
})();
var state_36279__$1 = state_36279;
var ex36378 = (state_36279__$1[(2)]);
var statearr_36384_36518 = state_36279__$1;
(statearr_36384_36518[(5)] = ex36378);


if((ex36378 instanceof Error)){
var statearr_36385_36519 = state_36279__$1;
(statearr_36385_36519[(1)] = (4));

(statearr_36385_36519[(5)] = null);

} else {
throw ex36378;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (83))){
var state_36279__$1 = state_36279;
var statearr_36386_36520 = state_36279__$1;
(statearr_36386_36520[(2)] = limit);

(statearr_36386_36520[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (14))){
var inst_36241 = (state_36279[(2)]);
var state_36279__$1 = state_36279;
var statearr_36387_36521 = state_36279__$1;
(statearr_36387_36521[(2)] = inst_36241);

(statearr_36387_36521[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (45))){
var inst_36157 = (state_36279[(2)]);
var state_36279__$1 = state_36279;
if(cljs.core.truth_(inst_36157)){
var statearr_36388_36522 = state_36279__$1;
(statearr_36388_36522[(1)] = (46));

} else {
var statearr_36389_36523 = state_36279__$1;
(statearr_36389_36523[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (53))){
var inst_36105 = (state_36279[(11)]);
var state_36279__$1 = state_36279;
var statearr_36390_36524 = state_36279__$1;
(statearr_36390_36524[(2)] = inst_36105);

(statearr_36390_36524[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (78))){
var inst_36106 = (state_36279[(12)]);
var inst_36218 = (state_36279[(2)]);
var inst_36219 = (inst_36106 <= (0));
var state_36279__$1 = (function (){var statearr_36391 = state_36279;
(statearr_36391[(37)] = inst_36218);

return statearr_36391;
})();
if(cljs.core.truth_(inst_36219)){
var statearr_36392_36525 = state_36279__$1;
(statearr_36392_36525[(1)] = (79));

} else {
var statearr_36393_36526 = state_36279__$1;
(statearr_36393_36526[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (26))){
var inst_36237 = (state_36279[(2)]);
var state_36279__$1 = state_36279;
var statearr_36394_36527 = state_36279__$1;
(statearr_36394_36527[(2)] = inst_36237);

(statearr_36394_36527[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (16))){
var state_36279__$1 = state_36279;
var statearr_36395_36528 = state_36279__$1;
(statearr_36395_36528[(2)] = null);

(statearr_36395_36528[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (81))){
var inst_36218 = (state_36279[(37)]);
var inst_36120 = (state_36279[(20)]);
var inst_36107 = (state_36279[(9)]);
var inst_36117 = (state_36279[(21)]);
var inst_36151 = (state_36279[(18)]);
var inst_36116 = (state_36279[(10)]);
var inst_36224 = (state_36279[(2)]);
var inst_36225 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_36107,inst_36116,inst_36151);
var inst_36103 = inst_36117;
var inst_36104 = inst_36120;
var inst_36105 = inst_36218;
var inst_36106 = inst_36224;
var inst_36107__$1 = inst_36225;
var state_36279__$1 = (function (){var statearr_36398 = state_36279;
(statearr_36398[(22)] = inst_36103);

(statearr_36398[(12)] = inst_36106);

(statearr_36398[(9)] = inst_36107__$1);

(statearr_36398[(11)] = inst_36105);

(statearr_36398[(23)] = inst_36104);

return statearr_36398;
})();
var statearr_36399_36529 = state_36279__$1;
(statearr_36399_36529[(2)] = null);

(statearr_36399_36529[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (79))){
var state_36279__$1 = state_36279;
var statearr_36400_36530 = state_36279__$1;
(statearr_36400_36530[(2)] = (0));

(statearr_36400_36530[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (38))){
var inst_36120 = (state_36279[(20)]);
var inst_36107 = (state_36279[(9)]);
var inst_36117 = (state_36279[(21)]);
var inst_36105 = (state_36279[(11)]);
var inst_36142 = (state_36279[(2)]);
var tmp36396 = inst_36107;
var tmp36397 = inst_36105;
var inst_36103 = inst_36117;
var inst_36104 = inst_36120;
var inst_36105__$1 = tmp36397;
var inst_36106 = inst_36142;
var inst_36107__$1 = tmp36396;
var state_36279__$1 = (function (){var statearr_36401 = state_36279;
(statearr_36401[(22)] = inst_36103);

(statearr_36401[(12)] = inst_36106);

(statearr_36401[(9)] = inst_36107__$1);

(statearr_36401[(11)] = inst_36105__$1);

(statearr_36401[(23)] = inst_36104);

return statearr_36401;
})();
var statearr_36402_36531 = state_36279__$1;
(statearr_36402_36531[(2)] = null);

(statearr_36402_36531[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (87))){
var state_36279__$1 = state_36279;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_36403_36532 = state_36279__$1;
(statearr_36403_36532[(1)] = (92));

} else {
var statearr_36404_36533 = state_36279__$1;
(statearr_36404_36533[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (30))){
var inst_36107 = (state_36279[(9)]);
var state_36279__$1 = state_36279;
var statearr_36405_36534 = state_36279__$1;
(statearr_36405_36534[(2)] = inst_36107);

(statearr_36405_36534[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (73))){
var inst_36107 = (state_36279[(9)]);
var state_36279__$1 = state_36279;
var statearr_36406_36535 = state_36279__$1;
(statearr_36406_36535[(2)] = inst_36107);

(statearr_36406_36535[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (96))){
var state_36279__$1 = state_36279;
var statearr_36407_36536 = state_36279__$1;
(statearr_36407_36536[(2)] = null);

(statearr_36407_36536[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (10))){
var inst_36047 = (state_36279[(35)]);
var state_36279__$1 = state_36279;
var statearr_36408_36537 = state_36279__$1;
(statearr_36408_36537[(2)] = inst_36047);

(statearr_36408_36537[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (18))){
var inst_36097 = (state_36279[(36)]);
var inst_36096 = (state_36279[(2)]);
var inst_36097__$1 = offset;
var state_36279__$1 = (function (){var statearr_36409 = state_36279;
(statearr_36409[(36)] = inst_36097__$1);

(statearr_36409[(25)] = inst_36096);

return statearr_36409;
})();
if(cljs.core.truth_(inst_36097__$1)){
var statearr_36410_36538 = state_36279__$1;
(statearr_36410_36538[(1)] = (19));

} else {
var statearr_36411_36539 = state_36279__$1;
(statearr_36411_36539[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (52))){
var inst_36105 = (state_36279[(11)]);
var inst_36167 = ((0) < inst_36105);
var state_36279__$1 = state_36279;
var statearr_36412_36540 = state_36279__$1;
(statearr_36412_36540[(2)] = inst_36167);

(statearr_36412_36540[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (67))){
var inst_36175 = (state_36279[(8)]);
var inst_36106 = (state_36279[(12)]);
var inst_36121 = (state_36279[(27)]);
var inst_36190 = cljs.core.count(inst_36175);
var inst_36191 = (inst_36121 - inst_36190);
var inst_36192 = (inst_36106 - inst_36191);
var state_36279__$1 = state_36279;
var statearr_36413_36541 = state_36279__$1;
(statearr_36413_36541[(2)] = inst_36192);

(statearr_36413_36541[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (71))){
var inst_36175 = (state_36279[(8)]);
var inst_36203 = cljs.core.empty_QMARK_(inst_36175);
var state_36279__$1 = state_36279;
var statearr_36414_36542 = state_36279__$1;
(statearr_36414_36542[(2)] = inst_36203);

(statearr_36414_36542[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (42))){
var inst_36152 = (state_36279[(33)]);
var inst_36151 = (state_36279[(18)]);
var inst_36150 = (state_36279[(2)]);
var inst_36151__$1 = fluree.db.util.async.throw_err(inst_36150);
var inst_36152__$1 = cljs.core.coll_QMARK_(inst_36151__$1);
var state_36279__$1 = (function (){var statearr_36415 = state_36279;
(statearr_36415[(33)] = inst_36152__$1);

(statearr_36415[(18)] = inst_36151__$1);

return statearr_36415;
})();
if(inst_36152__$1){
var statearr_36416_36543 = state_36279__$1;
(statearr_36416_36543[(1)] = (43));

} else {
var statearr_36417_36544 = state_36279__$1;
(statearr_36417_36544[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (80))){
var inst_36106 = (state_36279[(12)]);
var inst_36222 = (inst_36106 - (1));
var state_36279__$1 = state_36279;
var statearr_36418_36545 = state_36279__$1;
(statearr_36418_36545[(2)] = inst_36222);

(statearr_36418_36545[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (37))){
var inst_36106 = (state_36279[(12)]);
var inst_36121 = (state_36279[(27)]);
var inst_36140 = (inst_36106 - inst_36121);
var state_36279__$1 = state_36279;
var statearr_36419_36546 = state_36279__$1;
(statearr_36419_36546[(2)] = inst_36140);

(statearr_36419_36546[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (63))){
var inst_36175 = (state_36279[(8)]);
var inst_36200 = (state_36279[(7)]);
var inst_36199 = (state_36279[(2)]);
var inst_36200__$1 = (inst_36175 == null);
var state_36279__$1 = (function (){var statearr_36420 = state_36279;
(statearr_36420[(19)] = inst_36199);

(statearr_36420[(7)] = inst_36200__$1);

return statearr_36420;
})();
if(cljs.core.truth_(inst_36200__$1)){
var statearr_36421_36547 = state_36279__$1;
(statearr_36421_36547[(1)] = (70));

} else {
var statearr_36422_36548 = state_36279__$1;
(statearr_36422_36548[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (94))){
var inst_36270 = (state_36279[(2)]);
var state_36279__$1 = state_36279;
var statearr_36423_36549 = state_36279__$1;
(statearr_36423_36549[(2)] = inst_36270);

(statearr_36423_36549[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (8))){
var inst_36274 = (state_36279[(2)]);
var _ = (function (){var statearr_36424 = state_36279;
(statearr_36424[(4)] = cljs.core.rest((state_36279[(4)])));

return statearr_36424;
})();
var state_36279__$1 = state_36279;
var statearr_36425_36550 = state_36279__$1;
(statearr_36425_36550[(2)] = inst_36274);

(statearr_36425_36550[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (49))){
var inst_36106 = (state_36279[(12)]);
var inst_36151 = (state_36279[(18)]);
var inst_36162 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_36106,inst_36151);
var state_36279__$1 = state_36279;
var statearr_36426_36551 = state_36279__$1;
(statearr_36426_36551[(2)] = inst_36162);

(statearr_36426_36551[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36280 === (84))){
var inst_36246 = (state_36279[(2)]);
var inst_36247 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,inst_36246,opts);
var state_36279__$1 = state_36279;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36279__$1,(85),inst_36247);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11410__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11410__auto____0 = (function (){
var statearr_36427 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36427[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11410__auto__);

(statearr_36427[(1)] = (1));

return statearr_36427;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11410__auto____1 = (function (state_36279){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_36279);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e36428){var ex__11413__auto__ = e36428;
var statearr_36429_36552 = state_36279;
(statearr_36429_36552[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_36279[(4)]))){
var statearr_36430_36553 = state_36279;
(statearr_36430_36553[(1)] = cljs.core.first((state_36279[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36554 = state_36279;
state_36279 = G__36554;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11410__auto__ = function(state_36279){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11410__auto____1.call(this,state_36279);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11410__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11410__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_36431 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_36431[(6)] = c__11484__auto__);

return statearr_36431;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__36557,opts){
var map__36558 = p__36557;
var map__36558__$1 = cljs.core.__destructure_map(map__36558);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36558__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36558__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36558__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var selectReduced = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36558__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var select_smt = (function (){var or__4253__auto__ = selectOne;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = select;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
var or__4253__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4253__auto____$2)){
return or__4253__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_(select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select(headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__36555_SHARP_){
return cljs.core.contains_QMARK_(p1__36555_SHARP_,new cljs.core.Keyword(null,"code","code",1586293142));
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some((function (p1__36556_SHARP_){
return cljs.core.contains_QMARK_(p1__36556_SHARP_,new cljs.core.Keyword(null,"selection","selection",975998651));
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_(aggregates))?null:aggregates);
var orderBy = (function (){var temp__5753__auto__ = new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5753__auto__)){
var orderBy = temp__5753__auto__;
if(cljs.core.truth_((function (){var or__4253__auto__ = typeof orderBy === 'string';
if(or__4253__auto__){
return or__4253__auto__;
} else {
var and__4251__auto__ = cljs.core.vector_QMARK_(orderBy);
if(and__4251__auto__){
var G__36560 = cljs.core.first(orderBy);
var fexpr__36559 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null);
return (fexpr__36559.cljs$core$IFn$_invoke$arity$1 ? fexpr__36559.cljs$core$IFn$_invoke$arity$1(G__36560) : fexpr__36559.call(null,G__36560));
} else {
return and__4251__auto__;
}
}
})())){
if(cljs.core.vector_QMARK_(orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289),new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"inVector?","inVector?",1948069375)],[expandMap_QMARK_,(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (100);
}
})(),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"offset","offset",296498311).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$(selectOne),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return false;
}
})(),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667).cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$((function (){var or__4253__auto__ = selectDistinct;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__36561,p__36562){
var map__36563 = p__36561;
var map__36563__$1 = cljs.core.__destructure_map(map__36563);
var query_map = map__36563__$1;
var construct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36563__$1,new cljs.core.Keyword(null,"construct","construct",692547932));
var map__36564 = p__36562;
var map__36564__$1 = cljs.core.__destructure_map(map__36564);
var where_result = map__36564__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36564__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36564__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__36565 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (construct_item){
var temp__5751__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(construct_item));
if(cljs.core.truth_(temp__5751__auto__)){
var index_of = temp__5751__auto__;
return (function (row){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36565,(0),null);
var fn2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36565,(1),null);
var fn3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36565,(2),null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(res) : fn1.call(null,res)),(fn2.cljs$core$IFn$_invoke$arity$1 ? fn2.cljs$core$IFn$_invoke$arity$1(res) : fn2.call(null,res)),(fn3.cljs$core$IFn$_invoke$arity$1 ? fn3.cljs$core$IFn$_invoke$arity$1(res) : fn3.call(null,res))], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_36598){
var state_val_36599 = (state_36598[(1)]);
if((state_val_36599 === (7))){
var inst_36577 = (state_36598[(7)]);
var state_36598__$1 = state_36598;
var statearr_36600_36623 = state_36598__$1;
(statearr_36600_36623[(2)] = inst_36577);

(statearr_36600_36623[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36599 === (1))){
var state_36598__$1 = state_36598;
var statearr_36601_36624 = state_36598__$1;
(statearr_36601_36624[(2)] = null);

(statearr_36601_36624[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36599 === (4))){
var inst_36568 = (state_36598[(2)]);
var state_36598__$1 = state_36598;
var statearr_36602_36625 = state_36598__$1;
(statearr_36602_36625[(2)] = inst_36568);

(statearr_36602_36625[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36599 === (13))){
var inst_36587 = (state_36598[(2)]);
var inst_36588 = fluree.db.util.async.throw_err(inst_36587);
var state_36598__$1 = state_36598;
var statearr_36603_36626 = state_36598__$1;
(statearr_36603_36626[(2)] = inst_36588);

(statearr_36603_36626[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36599 === (6))){
var inst_36577 = (state_36598[(7)]);
var inst_36576 = (state_36598[(2)]);
var inst_36577__$1 = fluree.db.util.async.throw_err(inst_36576);
var inst_36578 = fluree.db.util.core.exception_QMARK_(inst_36577__$1);
var state_36598__$1 = (function (){var statearr_36604 = state_36598;
(statearr_36604[(7)] = inst_36577__$1);

return statearr_36604;
})();
if(inst_36578){
var statearr_36605_36627 = state_36598__$1;
(statearr_36605_36627[(1)] = (7));

} else {
var statearr_36606_36628 = state_36598__$1;
(statearr_36606_36628[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36599 === (3))){
var inst_36596 = (state_36598[(2)]);
var state_36598__$1 = state_36598;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36598__$1,inst_36596);
} else {
if((state_val_36599 === (12))){
var inst_36591 = (state_36598[(2)]);
var state_36598__$1 = state_36598;
var statearr_36607_36629 = state_36598__$1;
(statearr_36607_36629[(2)] = inst_36591);

(statearr_36607_36629[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36599 === (2))){
var _ = (function (){var statearr_36608 = state_36598;
(statearr_36608[(4)] = cljs.core.cons((5),(state_36598[(4)])));

return statearr_36608;
})();
var inst_36574 = fluree.db.query.analytical.q(query_map,fuel,max_fuel,db,opts);
var state_36598__$1 = state_36598;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36598__$1,(6),inst_36574);
} else {
if((state_val_36599 === (11))){
var state_36598__$1 = state_36598;
var statearr_36610_36630 = state_36598__$1;
(statearr_36610_36630[(2)] = null);

(statearr_36610_36630[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36599 === (9))){
var inst_36593 = (state_36598[(2)]);
var _ = (function (){var statearr_36611 = state_36598;
(statearr_36611[(4)] = cljs.core.rest((state_36598[(4)])));

return statearr_36611;
})();
var state_36598__$1 = state_36598;
var statearr_36612_36631 = state_36598__$1;
(statearr_36612_36631[(2)] = inst_36593);

(statearr_36612_36631[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36599 === (5))){
var _ = (function (){var statearr_36613 = state_36598;
(statearr_36613[(4)] = cljs.core.rest((state_36598[(4)])));

return statearr_36613;
})();
var state_36598__$1 = state_36598;
var ex36609 = (state_36598__$1[(2)]);
var statearr_36614_36632 = state_36598__$1;
(statearr_36614_36632[(5)] = ex36609);


if((ex36609 instanceof Error)){
var statearr_36615_36633 = state_36598__$1;
(statearr_36615_36633[(1)] = (4));

(statearr_36615_36633[(5)] = null);

} else {
throw ex36609;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36599 === (10))){
var inst_36577 = (state_36598[(7)]);
var inst_36582 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_36577);
var inst_36583 = new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(inst_36577);
var inst_36584 = fluree.db.query.fql.get_ad_hoc_select_spec(inst_36582,inst_36583,query_map,opts);
var inst_36585 = fluree.db.query.fql.process_ad_hoc_res(db,fuel,max_fuel,inst_36577,inst_36584,opts);
var state_36598__$1 = state_36598;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36598__$1,(13),inst_36585);
} else {
if((state_val_36599 === (8))){
var state_36598__$1 = state_36598;
var statearr_36616_36634 = state_36598__$1;
(statearr_36616_36634[(1)] = (10));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__11410__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__11410__auto____0 = (function (){
var statearr_36618 = [null,null,null,null,null,null,null,null];
(statearr_36618[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__11410__auto__);

(statearr_36618[(1)] = (1));

return statearr_36618;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__11410__auto____1 = (function (state_36598){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_36598);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e36619){var ex__11413__auto__ = e36619;
var statearr_36620_36635 = state_36598;
(statearr_36620_36635[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_36598[(4)]))){
var statearr_36621_36636 = state_36598;
(statearr_36621_36636[(1)] = cljs.core.first((state_36598[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36637 = state_36598;
state_36598 = G__36637;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__11410__auto__ = function(state_36598){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__11410__auto____1.call(this,state_36598);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__11410__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__11410__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_36622 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_36622[(6)] = c__11484__auto__);

return statearr_36622;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Running query:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0))], 0));

var map__36638 = query_map;
var map__36638__$1 = cljs.core.__destructure_map(map__36638);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36638__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36638__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36638__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36638__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36638__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36638__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36638__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36638__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36638__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36638__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36638__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36638__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var opts_SINGLEQUOTE_ = (function (){var G__36639 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"limit","limit",-1355822363),limit,new cljs.core.Keyword(null,"offset","offset",296498311),(function (){var or__4253__auto__ = offset;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
})(),new cljs.core.Keyword(null,"component","component",1555936782),component,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),orderBy,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),groupBy,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),prettyPrint], null),opts], 0));
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__36639,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
} else {
return G__36639;
}
})();
var max_fuel = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
if(cljs.core.truth_((function (){var or__4253__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_((0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_(where)){
return fluree.db.query.fql.ad_hoc_query(db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_36997){
var state_val_36998 = (state_36997[(1)]);
if((state_val_36998 === (121))){
var inst_36958 = (state_36997[(2)]);
var state_36997__$1 = state_36997;
var statearr_36999_37194 = state_36997__$1;
(statearr_36999_37194[(2)] = inst_36958);

(statearr_36999_37194[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (65))){
var inst_36835 = typeof from === 'string';
var state_36997__$1 = state_36997;
if(cljs.core.truth_(inst_36835)){
var statearr_37000_37195 = state_36997__$1;
(statearr_37000_37195[(1)] = (72));

} else {
var statearr_37001_37196 = state_36997__$1;
(statearr_37001_37196[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (70))){
var inst_36703 = (state_36997[(7)]);
var inst_36701 = (state_36997[(8)]);
var inst_36828 = (state_36997[(2)]);
var inst_36829 = fluree.db.util.async.throw_err(inst_36828);
var inst_36830 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_36703,fuel,max_fuel,inst_36701,inst_36829);
var state_36997__$1 = state_36997;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36997__$1,(71),inst_36830);
} else {
if((state_val_36998 === (62))){
var inst_36808 = (state_36997[(9)]);
var state_36997__$1 = state_36997;
var statearr_37002_37197 = state_36997__$1;
(statearr_37002_37197[(2)] = inst_36808);

(statearr_37002_37197[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (74))){
var inst_36964 = (state_36997[(2)]);
var state_36997__$1 = state_36997;
var statearr_37003_37198 = state_36997__$1;
(statearr_37003_37198[(2)] = inst_36964);

(statearr_37003_37198[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (110))){
var inst_36899 = (state_36997[(10)]);
var state_36997__$1 = state_36997;
var statearr_37004_37199 = state_36997__$1;
(statearr_37004_37199[(2)] = inst_36899);

(statearr_37004_37199[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (130))){
var inst_36984 = (state_36997[(2)]);
var state_36997__$1 = state_36997;
var statearr_37005_37200 = state_36997__$1;
(statearr_37005_37200[(2)] = inst_36984);

(statearr_37005_37200[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (128))){
var inst_36975 = (state_36997[(11)]);
var inst_36980 = fluree.db.util.core.exception_QMARK_(inst_36975);
var inst_36981 = (!(inst_36980));
var state_36997__$1 = state_36997;
var statearr_37006_37201 = state_36997__$1;
(statearr_37006_37201[(2)] = inst_36981);

(statearr_37006_37201[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (7))){
var inst_36671 = (state_36997[(12)]);
var inst_36671__$1 = selectOne;
var state_36997__$1 = (function (){var statearr_37007 = state_36997;
(statearr_37007[(12)] = inst_36671__$1);

return statearr_37007;
})();
if(cljs.core.truth_(inst_36671__$1)){
var statearr_37008_37202 = state_36997__$1;
(statearr_37008_37202[(1)] = (9));

} else {
var statearr_37009_37203 = state_36997__$1;
(statearr_37009_37203[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (59))){
var inst_36691 = (state_36997[(13)]);
var inst_36703 = (state_36997[(7)]);
var inst_36786 = (state_36997[(14)]);
var inst_36701 = (state_36997[(8)]);
var inst_36800 = (state_36997[(2)]);
var inst_36801 = fluree.db.util.async.throw_err(inst_36800);
var inst_36802 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_36786,inst_36801);
var inst_36803 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7(db,inst_36703,fuel,max_fuel,inst_36701,inst_36802,inst_36691);
var state_36997__$1 = state_36997;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36997__$1,(60),inst_36803);
} else {
if((state_val_36998 === (86))){
var inst_36691 = (state_36997[(13)]);
var inst_36703 = (state_36997[(7)]);
var inst_36693 = (state_36997[(15)]);
var inst_36701 = (state_36997[(8)]);
var inst_36868 = (state_36997[(2)]);
var inst_36869 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_36703,fuel,max_fuel,inst_36701,inst_36868,inst_36691,inst_36693);
var state_36997__$1 = state_36997;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36997__$1,(87),inst_36869);
} else {
if((state_val_36998 === (20))){
var inst_36735 = (state_36997[(2)]);
var inst_36736 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36735,(0),null);
var inst_36737 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36735,(1),null);
var inst_36738 = typeof where === 'string';
var state_36997__$1 = (function (){var statearr_37010 = state_36997;
(statearr_37010[(16)] = inst_36737);

(statearr_37010[(17)] = inst_36736);

return statearr_37010;
})();
if(cljs.core.truth_(inst_36738)){
var statearr_37011_37204 = state_36997__$1;
(statearr_37011_37204[(1)] = (30));

} else {
var statearr_37012_37205 = state_36997__$1;
(statearr_37012_37205[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (72))){
var inst_36690 = (state_36997[(18)]);
var state_36997__$1 = state_36997;
if(cljs.core.truth_(inst_36690)){
var statearr_37013_37206 = state_36997__$1;
(statearr_37013_37206[(1)] = (75));

} else {
var statearr_37014_37207 = state_36997__$1;
(statearr_37014_37207[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (58))){
var inst_36794 = (state_36997[(2)]);
var inst_36795 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36796 = [from];
var inst_36797 = (new cljs.core.PersistentVector(null,1,(5),inst_36795,inst_36796,null));
var inst_36798 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_36797,inst_36794);
var state_36997__$1 = state_36997;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36997__$1,(59),inst_36798);
} else {
if((state_val_36998 === (60))){
var inst_36805 = (state_36997[(2)]);
var inst_36806 = fluree.db.util.async.throw_err(inst_36805);
var state_36997__$1 = state_36997;
var statearr_37015_37208 = state_36997__$1;
(statearr_37015_37208[(2)] = inst_36806);

(statearr_37015_37208[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (27))){
var inst_36720 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36721 = [null,null];
var inst_36722 = (new cljs.core.PersistentVector(null,2,(5),inst_36720,inst_36721,null));
var state_36997__$1 = state_36997;
var statearr_37016_37209 = state_36997__$1;
(statearr_37016_37209[(2)] = inst_36722);

(statearr_37016_37209[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (1))){
var state_36997__$1 = state_36997;
var statearr_37017_37210 = state_36997__$1;
(statearr_37017_37210[(2)] = null);

(statearr_37017_37210[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (69))){
var inst_36825 = (state_36997[(2)]);
var inst_36826 = fluree.db.query.range._block_or_tx_collection(db,inst_36825);
var state_36997__$1 = state_36997;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36997__$1,(70),inst_36826);
} else {
if((state_val_36998 === (101))){
var inst_36931 = (state_36997[(2)]);
var state_36997__$1 = state_36997;
var statearr_37018_37211 = state_36997__$1;
(statearr_37018_37211[(2)] = inst_36931);

(statearr_37018_37211[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (24))){
var inst_36690 = (state_36997[(18)]);
var inst_36715 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36716 = [inst_36690,"ASC"];
var inst_36717 = (new cljs.core.PersistentVector(null,2,(5),inst_36715,inst_36716,null));
var state_36997__$1 = state_36997;
var statearr_37019_37212 = state_36997__$1;
(statearr_37019_37212[(2)] = inst_36717);

(statearr_37019_37212[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (102))){
var inst_36905 = (state_36997[(19)]);
var state_36997__$1 = state_36997;
var statearr_37020_37213 = state_36997__$1;
(statearr_37020_37213[(2)] = inst_36905);

(statearr_37020_37213[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (55))){
var inst_36690 = (state_36997[(18)]);
var inst_36786 = (state_36997[(2)]);
var state_36997__$1 = (function (){var statearr_37021 = state_36997;
(statearr_37021[(14)] = inst_36786);

return statearr_37021;
})();
if(cljs.core.truth_(inst_36690)){
var statearr_37022_37214 = state_36997__$1;
(statearr_37022_37214[(1)] = (56));

} else {
var statearr_37023_37215 = state_36997__$1;
(statearr_37023_37215[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (85))){
var inst_36860 = (state_36997[(20)]);
var inst_36864 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36865 = [inst_36860];
var inst_36866 = (new cljs.core.PersistentVector(null,1,(5),inst_36864,inst_36865,null));
var state_36997__$1 = state_36997;
var statearr_37024_37216 = state_36997__$1;
(statearr_37024_37216[(2)] = inst_36866);

(statearr_37024_37216[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (39))){
var inst_36691 = (state_36997[(13)]);
var state_36997__$1 = state_36997;
var statearr_37025_37217 = state_36997__$1;
(statearr_37025_37217[(2)] = inst_36691);

(statearr_37025_37217[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (88))){
var inst_36874 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2(fuel,cljs.core.inc);
var state_36997__$1 = state_36997;
var statearr_37026_37218 = state_36997__$1;
(statearr_37026_37218[(2)] = inst_36874);

(statearr_37026_37218[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (46))){
var inst_36771 = (state_36997[(2)]);
var state_36997__$1 = state_36997;
if(cljs.core.truth_(inst_36771)){
var statearr_37027_37219 = state_36997__$1;
(statearr_37027_37219[(1)] = (47));

} else {
var statearr_37028_37220 = state_36997__$1;
(statearr_37028_37220[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (4))){
var inst_36658 = (state_36997[(2)]);
var state_36997__$1 = state_36997;
var statearr_37029_37221 = state_36997__$1;
(statearr_37029_37221[(2)] = inst_36658);

(statearr_37029_37221[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (77))){
var inst_36844 = (state_36997[(2)]);
var inst_36845 = fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,from,inst_36844);
var state_36997__$1 = state_36997;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36997__$1,(78),inst_36845);
} else {
if((state_val_36998 === (106))){
var state_36997__$1 = state_36997;
var statearr_37030_37222 = state_36997__$1;
(statearr_37030_37222[(2)] = null);

(statearr_37030_37222[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (119))){
var inst_36950 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_36951 = ["Invalid 'from' in query:",inst_36950].join('');
var inst_36952 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_36953 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_36954 = cljs.core.PersistentHashMap.fromArrays(inst_36952,inst_36953);
var inst_36955 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_36951,inst_36954);
var state_36997__$1 = state_36997;
var statearr_37031_37223 = state_36997__$1;
(statearr_37031_37223[(2)] = inst_36955);

(statearr_37031_37223[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (95))){
var state_36997__$1 = state_36997;
var statearr_37032_37224 = state_36997__$1;
(statearr_37032_37224[(1)] = (119));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (54))){
var inst_36780 = (state_36997[(21)]);
var state_36997__$1 = state_36997;
var statearr_37034_37225 = state_36997__$1;
(statearr_37034_37225[(2)] = inst_36780);

(statearr_37034_37225[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (92))){
var inst_36879 = (state_36997[(22)]);
var state_36997__$1 = state_36997;
var statearr_37035_37226 = state_36997__$1;
(statearr_37035_37226[(2)] = inst_36879);

(statearr_37035_37226[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (104))){
var inst_36923 = (state_36997[(23)]);
var inst_36923__$1 = (state_36997[(2)]);
var state_36997__$1 = (function (){var statearr_37036 = state_36997;
(statearr_37036[(23)] = inst_36923__$1);

return statearr_37036;
})();
if(cljs.core.truth_(inst_36923__$1)){
var statearr_37037_37227 = state_36997__$1;
(statearr_37037_37227[(1)] = (109));

} else {
var statearr_37038_37228 = state_36997__$1;
(statearr_37038_37228[(1)] = (110));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (15))){
var inst_36694 = (state_36997[(24)]);
var inst_36692 = (state_36997[(25)]);
var inst_36698 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_36694,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),inst_36692);
var state_36997__$1 = state_36997;
var statearr_37039_37229 = state_36997__$1;
(statearr_37039_37229[(2)] = inst_36698);

(statearr_37039_37229[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (48))){
var inst_36808 = (state_36997[(9)]);
var inst_36808__$1 = typeof from === 'string';
var state_36997__$1 = (function (){var statearr_37040 = state_36997;
(statearr_37040[(9)] = inst_36808__$1);

return statearr_37040;
})();
if(cljs.core.truth_(inst_36808__$1)){
var statearr_37041_37230 = state_36997__$1;
(statearr_37041_37230[(1)] = (61));

} else {
var statearr_37042_37231 = state_36997__$1;
(statearr_37042_37231[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (50))){
var inst_36774 = (state_36997[(26)]);
var inst_36776 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_36777 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_36774,inst_36776);
var state_36997__$1 = state_36997;
var statearr_37043_37232 = state_36997__$1;
(statearr_37043_37232[(2)] = inst_36777);

(statearr_37043_37232[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (116))){
var state_36997__$1 = state_36997;
var statearr_37044_37233 = state_36997__$1;
(statearr_37044_37233[(2)] = null);

(statearr_37044_37233[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (75))){
var inst_36838 = cljs.core.PersistentHashMap.EMPTY;
var state_36997__$1 = state_36997;
var statearr_37045_37234 = state_36997__$1;
(statearr_37045_37234[(2)] = inst_36838);

(statearr_37045_37234[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (99))){
var inst_36899 = (state_36997[(10)]);
var state_36997__$1 = state_36997;
var statearr_37046_37235 = state_36997__$1;
(statearr_37046_37235[(2)] = inst_36899);

(statearr_37046_37235[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (21))){
var inst_36690 = (state_36997[(18)]);
var inst_36707 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36708 = cljs.core.second(inst_36690);
var inst_36709 = cljs.core.first(inst_36690);
var inst_36710 = [inst_36708,inst_36709];
var inst_36711 = (new cljs.core.PersistentVector(null,2,(5),inst_36707,inst_36710,null));
var state_36997__$1 = state_36997;
var statearr_37047_37236 = state_36997__$1;
(statearr_37047_37236[(2)] = inst_36711);

(statearr_37047_37236[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (31))){
var inst_36765 = (state_36997[(27)]);
var inst_36765__$1 = typeof from === 'string';
var state_36997__$1 = (function (){var statearr_37048 = state_36997;
(statearr_37048[(27)] = inst_36765__$1);

return statearr_37048;
})();
if(cljs.core.truth_(inst_36765__$1)){
var statearr_37049_37237 = state_36997__$1;
(statearr_37049_37237[(1)] = (44));

} else {
var statearr_37050_37238 = state_36997__$1;
(statearr_37050_37238[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (113))){
var state_36997__$1 = state_36997;
var statearr_37051_37239 = state_36997__$1;
(statearr_37051_37239[(2)] = null);

(statearr_37051_37239[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (32))){
var inst_36736 = (state_36997[(17)]);
var inst_36970 = (state_36997[(2)]);
var state_36997__$1 = (function (){var statearr_37052 = state_36997;
(statearr_37052[(28)] = inst_36970);

return statearr_37052;
})();
if(cljs.core.truth_(inst_36736)){
var statearr_37053_37240 = state_36997__$1;
(statearr_37053_37240[(1)] = (122));

} else {
var statearr_37054_37241 = state_36997__$1;
(statearr_37054_37241[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (40))){
var inst_36690 = (state_36997[(18)]);
var inst_36755 = (state_36997[(2)]);
var state_36997__$1 = (function (){var statearr_37055 = state_36997;
(statearr_37055[(29)] = inst_36755);

return statearr_37055;
})();
if(cljs.core.truth_(inst_36690)){
var statearr_37056_37242 = state_36997__$1;
(statearr_37056_37242[(1)] = (41));

} else {
var statearr_37057_37243 = state_36997__$1;
(statearr_37057_37243[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (129))){
var inst_36978 = (state_36997[(30)]);
var state_36997__$1 = state_36997;
var statearr_37058_37244 = state_36997__$1;
(statearr_37058_37244[(2)] = inst_36978);

(statearr_37058_37244[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (91))){
var inst_36881 = cljs.core.every_QMARK_(fluree.db.util.core.subj_ident_QMARK_,from);
var state_36997__$1 = state_36997;
var statearr_37059_37245 = state_36997__$1;
(statearr_37059_37245[(2)] = inst_36881);

(statearr_37059_37245[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (117))){
var inst_36693 = (state_36997[(15)]);
var state_36997__$1 = state_36997;
var statearr_37060_37246 = state_36997__$1;
(statearr_37060_37246[(2)] = inst_36693);

(statearr_37060_37246[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (108))){
var inst_36920 = (state_36997[(2)]);
var inst_36921 = fluree.db.util.async.throw_err(inst_36920);
var state_36997__$1 = state_36997;
var statearr_37061_37247 = state_36997__$1;
(statearr_37061_37247[(2)] = inst_36921);

(statearr_37061_37247[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (56))){
var inst_36788 = cljs.core.PersistentHashMap.EMPTY;
var state_36997__$1 = state_36997;
var statearr_37062_37248 = state_36997__$1;
(statearr_37062_37248[(2)] = inst_36788);

(statearr_37062_37248[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (33))){
var state_36997__$1 = state_36997;
var statearr_37063_37249 = state_36997__$1;
(statearr_37063_37249[(2)] = from);

(statearr_37063_37249[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (13))){
var inst_36677 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_36678 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_36679 = cljs.core.PersistentHashMap.fromArrays(inst_36677,inst_36678);
var inst_36680 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Query missing :select or :selectOne.",inst_36679);
var inst_36681 = (function(){throw inst_36680})();
var state_36997__$1 = state_36997;
var statearr_37064_37250 = state_36997__$1;
(statearr_37064_37250[(2)] = inst_36681);

(statearr_37064_37250[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (22))){
var inst_36690 = (state_36997[(18)]);
var inst_36713 = typeof inst_36690 === 'string';
var state_36997__$1 = state_36997;
if(cljs.core.truth_(inst_36713)){
var statearr_37065_37251 = state_36997__$1;
(statearr_37065_37251[(1)] = (24));

} else {
var statearr_37066_37252 = state_36997__$1;
(statearr_37066_37252[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (90))){
var inst_36872 = (state_36997[(31)]);
var inst_36877 = (state_36997[(2)]);
var state_36997__$1 = (function (){var statearr_37067 = state_36997;
(statearr_37067[(32)] = inst_36877);

return statearr_37067;
})();
var statearr_37068_37253 = state_36997__$1;
(statearr_37068_37253[(2)] = inst_36872);

(statearr_37068_37253[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (109))){
var inst_36899 = (state_36997[(10)]);
var inst_36923 = (state_36997[(23)]);
var inst_36925 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_36899,inst_36923);
var state_36997__$1 = state_36997;
var statearr_37069_37254 = state_36997__$1;
(statearr_37069_37254[(2)] = inst_36925);

(statearr_37069_37254[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (36))){
var inst_36690 = (state_36997[(18)]);
var inst_36750 = (state_36997[(2)]);
var inst_36751 = fluree.db.util.async.throw_err(inst_36750);
var state_36997__$1 = (function (){var statearr_37070 = state_36997;
(statearr_37070[(33)] = inst_36751);

return statearr_37070;
})();
if(cljs.core.truth_(inst_36690)){
var statearr_37071_37255 = state_36997__$1;
(statearr_37071_37255[(1)] = (38));

} else {
var statearr_37072_37256 = state_36997__$1;
(statearr_37072_37256[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (41))){
var state_36997__$1 = state_36997;
var statearr_37073_37257 = state_36997__$1;
(statearr_37073_37257[(2)] = null);

(statearr_37073_37257[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (118))){
var inst_36703 = (state_36997[(7)]);
var inst_36701 = (state_36997[(8)]);
var inst_36939 = (state_36997[(34)]);
var inst_36935 = (state_36997[(35)]);
var inst_36943 = (state_36997[(2)]);
var inst_36944 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_36703,fuel,max_fuel,inst_36701,inst_36935,inst_36939,inst_36943);
var state_36997__$1 = state_36997;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36997__$1,(112),inst_36944);
} else {
if((state_val_36998 === (89))){
var state_36997__$1 = state_36997;
var statearr_37074_37258 = state_36997__$1;
(statearr_37074_37258[(2)] = null);

(statearr_37074_37258[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (100))){
var inst_36905 = (state_36997[(19)]);
var inst_36910 = cljs.core.int_QMARK_(inst_36905);
var state_36997__$1 = state_36997;
if(inst_36910){
var statearr_37075_37259 = state_36997__$1;
(statearr_37075_37259[(1)] = (102));

} else {
var statearr_37076_37260 = state_36997__$1;
(statearr_37076_37260[(1)] = (103));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (131))){
var inst_36975 = (state_36997[(11)]);
var inst_36989 = cljs.core.first(inst_36975);
var state_36997__$1 = state_36997;
var statearr_37077_37261 = state_36997__$1;
(statearr_37077_37261[(2)] = inst_36989);

(statearr_37077_37261[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (122))){
var inst_36691 = (state_36997[(13)]);
var inst_36737 = (state_36997[(16)]);
var inst_36736 = (state_36997[(17)]);
var inst_36693 = (state_36997[(15)]);
var inst_36970 = (state_36997[(28)]);
var inst_36972 = fluree.db.query.fql.sort_offset_and_limit_res(inst_36736,inst_36737,inst_36693,inst_36691,inst_36970);
var state_36997__$1 = state_36997;
var statearr_37078_37262 = state_36997__$1;
(statearr_37078_37262[(2)] = inst_36972);

(statearr_37078_37262[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (43))){
var inst_36703 = (state_36997[(7)]);
var inst_36751 = (state_36997[(33)]);
var inst_36755 = (state_36997[(29)]);
var inst_36701 = (state_36997[(8)]);
var inst_36759 = (state_36997[(2)]);
var inst_36760 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_36703,fuel,max_fuel,inst_36701,inst_36751,inst_36755,inst_36759);
var state_36997__$1 = state_36997;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36997__$1,(37),inst_36760);
} else {
if((state_val_36998 === (61))){
var inst_36810 = ["_tx",null,"_block",null];
var inst_36811 = (new cljs.core.PersistentArrayMap(null,2,inst_36810,null));
var inst_36812 = (new cljs.core.PersistentHashSet(null,inst_36811,null));
var inst_36813 = (inst_36812.cljs$core$IFn$_invoke$arity$1 ? inst_36812.cljs$core$IFn$_invoke$arity$1(from) : inst_36812.call(null,from));
var state_36997__$1 = state_36997;
var statearr_37079_37263 = state_36997__$1;
(statearr_37079_37263[(2)] = inst_36813);

(statearr_37079_37263[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (29))){
var inst_36725 = (state_36997[(2)]);
var state_36997__$1 = state_36997;
var statearr_37080_37264 = state_36997__$1;
(statearr_37080_37264[(2)] = inst_36725);

(statearr_37080_37264[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (44))){
var inst_36767 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_36768 = clojure.string.includes_QMARK_(inst_36767,"/");
var state_36997__$1 = state_36997;
var statearr_37081_37265 = state_36997__$1;
(statearr_37081_37265[(2)] = inst_36768);

(statearr_37081_37265[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (93))){
var inst_36884 = (state_36997[(2)]);
var state_36997__$1 = state_36997;
if(cljs.core.truth_(inst_36884)){
var statearr_37082_37266 = state_36997__$1;
(statearr_37082_37266[(1)] = (94));

} else {
var statearr_37083_37267 = state_36997__$1;
(statearr_37083_37267[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (6))){
var inst_36668 = (state_36997[(36)]);
var state_36997__$1 = state_36997;
var statearr_37084_37268 = state_36997__$1;
(statearr_37084_37268[(2)] = inst_36668);

(statearr_37084_37268[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (111))){
var inst_36906 = (state_36997[(37)]);
var inst_36928 = (state_36997[(2)]);
var inst_36898 = inst_36906;
var inst_36899 = inst_36928;
var state_36997__$1 = (function (){var statearr_37085 = state_36997;
(statearr_37085[(38)] = inst_36898);

(statearr_37085[(10)] = inst_36899);

return statearr_37085;
})();
var statearr_37086_37269 = state_36997__$1;
(statearr_37086_37269[(2)] = null);

(statearr_37086_37269[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (28))){
var state_36997__$1 = state_36997;
var statearr_37087_37270 = state_36997__$1;
(statearr_37087_37270[(2)] = null);

(statearr_37087_37270[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (64))){
var inst_36690 = (state_36997[(18)]);
var state_36997__$1 = state_36997;
if(cljs.core.truth_(inst_36690)){
var statearr_37088_37271 = state_36997__$1;
(statearr_37088_37271[(1)] = (67));

} else {
var statearr_37089_37272 = state_36997__$1;
(statearr_37089_37272[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (103))){
var state_36997__$1 = state_36997;
if(cljs.core.truth_(fuel)){
var statearr_37090_37273 = state_36997__$1;
(statearr_37090_37273[(1)] = (105));

} else {
var statearr_37091_37274 = state_36997__$1;
(statearr_37091_37274[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (51))){
var inst_36774 = (state_36997[(26)]);
var state_36997__$1 = state_36997;
var statearr_37092_37275 = state_36997__$1;
(statearr_37092_37275[(2)] = inst_36774);

(statearr_37092_37275[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (25))){
var state_36997__$1 = state_36997;
var statearr_37093_37276 = state_36997__$1;
(statearr_37093_37276[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (34))){
var state_36997__$1 = state_36997;
var statearr_37095_37277 = state_36997__$1;
(statearr_37095_37277[(2)] = null);

(statearr_37095_37277[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (125))){
var inst_36978 = (state_36997[(30)]);
var inst_36975 = (state_36997[(11)]);
var inst_36978__$1 = cljs.core.coll_QMARK_(inst_36975);
var state_36997__$1 = (function (){var statearr_37096 = state_36997;
(statearr_37096[(30)] = inst_36978__$1);

return statearr_37096;
})();
if(inst_36978__$1){
var statearr_37097_37278 = state_36997__$1;
(statearr_37097_37278[(1)] = (128));

} else {
var statearr_37098_37279 = state_36997__$1;
(statearr_37098_37279[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (17))){
var inst_36690 = (state_36997[(18)]);
var inst_36701 = (state_36997[(2)]);
var inst_36702 = cljs.core.PersistentHashMap.EMPTY;
var inst_36703 = cljs.core.volatile_BANG_(inst_36702);
var state_36997__$1 = (function (){var statearr_37099 = state_36997;
(statearr_37099[(7)] = inst_36703);

(statearr_37099[(8)] = inst_36701);

return statearr_37099;
})();
if(cljs.core.truth_(inst_36690)){
var statearr_37100_37280 = state_36997__$1;
(statearr_37100_37280[(1)] = (18));

} else {
var statearr_37101_37281 = state_36997__$1;
(statearr_37101_37281[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (3))){
var inst_36995 = (state_36997[(2)]);
var state_36997__$1 = state_36997;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36997__$1,inst_36995);
} else {
if((state_val_36998 === (12))){
var inst_36674 = (state_36997[(39)]);
var state_36997__$1 = state_36997;
var statearr_37102_37282 = state_36997__$1;
(statearr_37102_37282[(2)] = inst_36674);

(statearr_37102_37282[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (2))){
var inst_36668 = (state_36997[(36)]);
var _ = (function (){var statearr_37103 = state_36997;
(statearr_37103[(4)] = cljs.core.cons((5),(state_36997[(4)])));

return statearr_37103;
})();
var inst_36668__$1 = select;
var state_36997__$1 = (function (){var statearr_37104 = state_36997;
(statearr_37104[(36)] = inst_36668__$1);

return statearr_37104;
})();
if(cljs.core.truth_(inst_36668__$1)){
var statearr_37105_37283 = state_36997__$1;
(statearr_37105_37283[(1)] = (6));

} else {
var statearr_37106_37284 = state_36997__$1;
(statearr_37106_37284[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (66))){
var inst_36966 = (state_36997[(2)]);
var state_36997__$1 = state_36997;
var statearr_37107_37285 = state_36997__$1;
(statearr_37107_37285[(2)] = inst_36966);

(statearr_37107_37285[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (107))){
var inst_36905 = (state_36997[(19)]);
var inst_36917 = (state_36997[(2)]);
var inst_36918 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,inst_36905,false);
var state_36997__$1 = (function (){var statearr_37108 = state_36997;
(statearr_37108[(40)] = inst_36917);

return statearr_37108;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36997__$1,(108),inst_36918);
} else {
if((state_val_36998 === (23))){
var inst_36729 = (state_36997[(2)]);
var state_36997__$1 = state_36997;
var statearr_37109_37286 = state_36997__$1;
(statearr_37109_37286[(2)] = inst_36729);

(statearr_37109_37286[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (47))){
var inst_36774 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_36997__$1 = (function (){var statearr_37110 = state_36997;
(statearr_37110[(26)] = inst_36774);

return statearr_37110;
})();
if(cljs.core.truth_(fuel)){
var statearr_37111_37287 = state_36997__$1;
(statearr_37111_37287[(1)] = (50));

} else {
var statearr_37112_37288 = state_36997__$1;
(statearr_37112_37288[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (35))){
var inst_36691 = (state_36997[(13)]);
var inst_36693 = (state_36997[(15)]);
var inst_36744 = (state_36997[(2)]);
var inst_36745 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_36746 = [inst_36691,inst_36693];
var inst_36747 = cljs.core.PersistentHashMap.fromArrays(inst_36745,inst_36746);
var inst_36748 = fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4(db,where,inst_36744,inst_36747);
var state_36997__$1 = state_36997;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36997__$1,(36),inst_36748);
} else {
if((state_val_36998 === (127))){
var inst_36987 = (state_36997[(2)]);
var state_36997__$1 = state_36997;
if(cljs.core.truth_(inst_36987)){
var statearr_37113_37289 = state_36997__$1;
(statearr_37113_37289[(1)] = (131));

} else {
var statearr_37114_37290 = state_36997__$1;
(statearr_37114_37290[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (82))){
var inst_36962 = (state_36997[(2)]);
var state_36997__$1 = state_36997;
var statearr_37115_37291 = state_36997__$1;
(statearr_37115_37291[(2)] = inst_36962);

(statearr_37115_37291[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (76))){
var inst_36691 = (state_36997[(13)]);
var inst_36693 = (state_36997[(15)]);
var inst_36840 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_36841 = [inst_36691,inst_36693];
var inst_36842 = cljs.core.PersistentHashMap.fromArrays(inst_36840,inst_36841);
var state_36997__$1 = state_36997;
var statearr_37116_37292 = state_36997__$1;
(statearr_37116_37292[(2)] = inst_36842);

(statearr_37116_37292[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (97))){
var inst_36898 = (state_36997[(38)]);
var inst_36905 = (state_36997[(19)]);
var inst_36904 = cljs.core.seq(inst_36898);
var inst_36905__$1 = cljs.core.first(inst_36904);
var inst_36906 = cljs.core.next(inst_36904);
var inst_36907 = cljs.core.not(inst_36905__$1);
var state_36997__$1 = (function (){var statearr_37117 = state_36997;
(statearr_37117[(19)] = inst_36905__$1);

(statearr_37117[(37)] = inst_36906);

return statearr_37117;
})();
if(inst_36907){
var statearr_37118_37293 = state_36997__$1;
(statearr_37118_37293[(1)] = (99));

} else {
var statearr_37119_37294 = state_36997__$1;
(statearr_37119_37294[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (19))){
var inst_36731 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36732 = [null,null];
var inst_36733 = (new cljs.core.PersistentVector(null,2,(5),inst_36731,inst_36732,null));
var state_36997__$1 = state_36997;
var statearr_37120_37295 = state_36997__$1;
(statearr_37120_37295[(2)] = inst_36733);

(statearr_37120_37295[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (57))){
var inst_36691 = (state_36997[(13)]);
var inst_36693 = (state_36997[(15)]);
var inst_36790 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_36791 = [inst_36691,inst_36693];
var inst_36792 = cljs.core.PersistentHashMap.fromArrays(inst_36790,inst_36791);
var state_36997__$1 = state_36997;
var statearr_37121_37296 = state_36997__$1;
(statearr_37121_37296[(2)] = inst_36792);

(statearr_37121_37296[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (68))){
var inst_36691 = (state_36997[(13)]);
var inst_36693 = (state_36997[(15)]);
var inst_36821 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_36822 = [inst_36691,inst_36693];
var inst_36823 = cljs.core.PersistentHashMap.fromArrays(inst_36821,inst_36822);
var state_36997__$1 = state_36997;
var statearr_37122_37297 = state_36997__$1;
(statearr_37122_37297[(2)] = inst_36823);

(statearr_37122_37297[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (11))){
var inst_36685 = (state_36997[(2)]);
var state_36997__$1 = state_36997;
var statearr_37123_37298 = state_36997__$1;
(statearr_37123_37298[(2)] = inst_36685);

(statearr_37123_37298[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (115))){
var inst_36690 = (state_36997[(18)]);
var inst_36939 = (state_36997[(2)]);
var state_36997__$1 = (function (){var statearr_37125 = state_36997;
(statearr_37125[(34)] = inst_36939);

return statearr_37125;
})();
if(cljs.core.truth_(inst_36690)){
var statearr_37126_37299 = state_36997__$1;
(statearr_37126_37299[(1)] = (116));

} else {
var statearr_37127_37300 = state_36997__$1;
(statearr_37127_37300[(1)] = (117));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (9))){
var inst_36671 = (state_36997[(12)]);
var state_36997__$1 = state_36997;
var statearr_37128_37301 = state_36997__$1;
(statearr_37128_37301[(2)] = inst_36671);

(statearr_37128_37301[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (5))){
var _ = (function (){var statearr_37129 = state_36997;
(statearr_37129[(4)] = cljs.core.rest((state_36997[(4)])));

return statearr_37129;
})();
var state_36997__$1 = state_36997;
var ex37124 = (state_36997__$1[(2)]);
var statearr_37130_37302 = state_36997__$1;
(statearr_37130_37302[(5)] = ex37124);


if((ex37124 instanceof Error)){
var statearr_37131_37303 = state_36997__$1;
(statearr_37131_37303[(1)] = (4));

(statearr_37131_37303[(5)] = null);

} else {
throw ex37124;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (112))){
var inst_36946 = (state_36997[(2)]);
var inst_36947 = fluree.db.util.async.throw_err(inst_36946);
var state_36997__$1 = state_36997;
var statearr_37132_37304 = state_36997__$1;
(statearr_37132_37304[(2)] = inst_36947);

(statearr_37132_37304[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (83))){
var inst_36860 = (state_36997[(20)]);
var inst_36859 = (state_36997[(2)]);
var inst_36860__$1 = fluree.db.util.async.throw_err(inst_36859);
var inst_36861 = (inst_36860__$1 == null);
var state_36997__$1 = (function (){var statearr_37133 = state_36997;
(statearr_37133[(20)] = inst_36860__$1);

return statearr_37133;
})();
if(cljs.core.truth_(inst_36861)){
var statearr_37134_37305 = state_36997__$1;
(statearr_37134_37305[(1)] = (84));

} else {
var statearr_37135_37306 = state_36997__$1;
(statearr_37135_37306[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (14))){
var inst_36683 = (state_36997[(2)]);
var state_36997__$1 = state_36997;
var statearr_37136_37307 = state_36997__$1;
(statearr_37136_37307[(2)] = inst_36683);

(statearr_37136_37307[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (45))){
var inst_36765 = (state_36997[(27)]);
var state_36997__$1 = state_36997;
var statearr_37137_37308 = state_36997__$1;
(statearr_37137_37308[(2)] = inst_36765);

(statearr_37137_37308[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (53))){
var inst_36780 = (state_36997[(21)]);
var inst_36782 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_36783 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_36780,inst_36782);
var state_36997__$1 = state_36997;
var statearr_37138_37309 = state_36997__$1;
(statearr_37138_37309[(2)] = inst_36783);

(statearr_37138_37309[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (78))){
var inst_36703 = (state_36997[(7)]);
var inst_36701 = (state_36997[(8)]);
var inst_36847 = (state_36997[(2)]);
var inst_36848 = fluree.db.util.async.throw_err(inst_36847);
var inst_36849 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_36703,fuel,max_fuel,inst_36701,inst_36848);
var state_36997__$1 = state_36997;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36997__$1,(79),inst_36849);
} else {
if((state_val_36998 === (132))){
var inst_36975 = (state_36997[(11)]);
var state_36997__$1 = state_36997;
var statearr_37139_37310 = state_36997__$1;
(statearr_37139_37310[(2)] = inst_36975);

(statearr_37139_37310[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (26))){
var inst_36727 = (state_36997[(2)]);
var state_36997__$1 = state_36997;
var statearr_37140_37311 = state_36997__$1;
(statearr_37140_37311[(2)] = inst_36727);

(statearr_37140_37311[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (123))){
var inst_36970 = (state_36997[(28)]);
var state_36997__$1 = state_36997;
var statearr_37141_37312 = state_36997__$1;
(statearr_37141_37312[(2)] = inst_36970);

(statearr_37141_37312[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (16))){
var inst_36694 = (state_36997[(24)]);
var state_36997__$1 = state_36997;
var statearr_37142_37313 = state_36997__$1;
(statearr_37142_37313[(2)] = inst_36694);

(statearr_37142_37313[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (133))){
var inst_36992 = (state_36997[(2)]);
var _ = (function (){var statearr_37143 = state_36997;
(statearr_37143[(4)] = cljs.core.rest((state_36997[(4)])));

return statearr_37143;
})();
var state_36997__$1 = state_36997;
var statearr_37144_37314 = state_36997__$1;
(statearr_37144_37314[(2)] = inst_36992);

(statearr_37144_37314[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (81))){
var inst_36879 = (state_36997[(22)]);
var inst_36879__$1 = cljs.core.sequential_QMARK_(from);
var state_36997__$1 = (function (){var statearr_37145 = state_36997;
(statearr_37145[(22)] = inst_36879__$1);

return statearr_37145;
})();
if(inst_36879__$1){
var statearr_37146_37315 = state_36997__$1;
(statearr_37146_37315[(1)] = (91));

} else {
var statearr_37147_37316 = state_36997__$1;
(statearr_37147_37316[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (120))){
var state_36997__$1 = state_36997;
var statearr_37148_37317 = state_36997__$1;
(statearr_37148_37317[(2)] = null);

(statearr_37148_37317[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (79))){
var inst_36851 = (state_36997[(2)]);
var inst_36852 = fluree.db.util.async.throw_err(inst_36851);
var state_36997__$1 = state_36997;
var statearr_37149_37318 = state_36997__$1;
(statearr_37149_37318[(2)] = inst_36852);

(statearr_37149_37318[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (38))){
var state_36997__$1 = state_36997;
var statearr_37150_37319 = state_36997__$1;
(statearr_37150_37319[(2)] = null);

(statearr_37150_37319[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (126))){
var inst_36976 = (state_36997[(41)]);
var state_36997__$1 = state_36997;
var statearr_37151_37320 = state_36997__$1;
(statearr_37151_37320[(2)] = inst_36976);

(statearr_37151_37320[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (98))){
var inst_36690 = (state_36997[(18)]);
var inst_36933 = (state_36997[(2)]);
var inst_36934 = cljs.core.PersistentVector.EMPTY;
var inst_36935 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_36934,inst_36933);
var state_36997__$1 = (function (){var statearr_37152 = state_36997;
(statearr_37152[(35)] = inst_36935);

return statearr_37152;
})();
if(cljs.core.truth_(inst_36690)){
var statearr_37153_37321 = state_36997__$1;
(statearr_37153_37321[(1)] = (113));

} else {
var statearr_37154_37322 = state_36997__$1;
(statearr_37154_37322[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (124))){
var inst_36976 = (state_36997[(41)]);
var inst_36975 = (state_36997[(2)]);
var inst_36976__$1 = selectOne;
var state_36997__$1 = (function (){var statearr_37155 = state_36997;
(statearr_37155[(41)] = inst_36976__$1);

(statearr_37155[(11)] = inst_36975);

return statearr_37155;
})();
if(cljs.core.truth_(inst_36976__$1)){
var statearr_37156_37323 = state_36997__$1;
(statearr_37156_37323[(1)] = (125));

} else {
var statearr_37157_37324 = state_36997__$1;
(statearr_37157_37324[(1)] = (126));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (87))){
var inst_36871 = (state_36997[(2)]);
var inst_36872 = fluree.db.util.async.throw_err(inst_36871);
var state_36997__$1 = (function (){var statearr_37158 = state_36997;
(statearr_37158[(31)] = inst_36872);

return statearr_37158;
})();
if(cljs.core.truth_(fuel)){
var statearr_37159_37325 = state_36997__$1;
(statearr_37159_37325[(1)] = (88));

} else {
var statearr_37160_37326 = state_36997__$1;
(statearr_37160_37326[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (30))){
var inst_36740 = typeof from === 'string';
var state_36997__$1 = state_36997;
if(cljs.core.truth_(inst_36740)){
var statearr_37161_37327 = state_36997__$1;
(statearr_37161_37327[(1)] = (33));

} else {
var statearr_37162_37328 = state_36997__$1;
(statearr_37162_37328[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (73))){
var inst_36854 = fluree.db.util.core.subj_ident_QMARK_(from);
var state_36997__$1 = state_36997;
if(inst_36854){
var statearr_37163_37329 = state_36997__$1;
(statearr_37163_37329[(1)] = (80));

} else {
var statearr_37164_37330 = state_36997__$1;
(statearr_37164_37330[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (96))){
var inst_36960 = (state_36997[(2)]);
var state_36997__$1 = state_36997;
var statearr_37165_37331 = state_36997__$1;
(statearr_37165_37331[(2)] = inst_36960);

(statearr_37165_37331[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (10))){
var inst_36674 = (state_36997[(39)]);
var inst_36674__$1 = selectDistinct;
var state_36997__$1 = (function (){var statearr_37166 = state_36997;
(statearr_37166[(39)] = inst_36674__$1);

return statearr_37166;
})();
if(cljs.core.truth_(inst_36674__$1)){
var statearr_37167_37332 = state_36997__$1;
(statearr_37167_37332[(1)] = (12));

} else {
var statearr_37168_37333 = state_36997__$1;
(statearr_37168_37333[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (18))){
var inst_36690 = (state_36997[(18)]);
var inst_36705 = cljs.core.vector_QMARK_(inst_36690);
var state_36997__$1 = state_36997;
if(inst_36705){
var statearr_37169_37334 = state_36997__$1;
(statearr_37169_37334[(1)] = (21));

} else {
var statearr_37170_37335 = state_36997__$1;
(statearr_37170_37335[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (105))){
var inst_36914 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2(fuel,cljs.core.inc);
var state_36997__$1 = state_36997;
var statearr_37171_37336 = state_36997__$1;
(statearr_37171_37336[(2)] = inst_36914);

(statearr_37171_37336[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (52))){
var inst_36780 = (state_36997[(2)]);
var state_36997__$1 = (function (){var statearr_37172 = state_36997;
(statearr_37172[(21)] = inst_36780);

return statearr_37172;
})();
var statearr_37173_37337 = state_36997__$1;
(statearr_37173_37337[(1)] = (53));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (114))){
var inst_36691 = (state_36997[(13)]);
var state_36997__$1 = state_36997;
var statearr_37175_37338 = state_36997__$1;
(statearr_37175_37338[(2)] = inst_36691);

(statearr_37175_37338[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (67))){
var inst_36819 = cljs.core.PersistentHashMap.EMPTY;
var state_36997__$1 = state_36997;
var statearr_37176_37339 = state_36997__$1;
(statearr_37176_37339[(2)] = inst_36819);

(statearr_37176_37339[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (71))){
var inst_36832 = (state_36997[(2)]);
var inst_36833 = fluree.db.util.async.throw_err(inst_36832);
var state_36997__$1 = state_36997;
var statearr_37177_37340 = state_36997__$1;
(statearr_37177_37340[(2)] = inst_36833);

(statearr_37177_37340[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (42))){
var inst_36693 = (state_36997[(15)]);
var state_36997__$1 = state_36997;
var statearr_37178_37341 = state_36997__$1;
(statearr_37178_37341[(2)] = inst_36693);

(statearr_37178_37341[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (80))){
var inst_36857 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,from,false);
var state_36997__$1 = state_36997;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36997__$1,(83),inst_36857);
} else {
if((state_val_36998 === (37))){
var inst_36762 = (state_36997[(2)]);
var inst_36763 = fluree.db.util.async.throw_err(inst_36762);
var state_36997__$1 = state_36997;
var statearr_37179_37342 = state_36997__$1;
(statearr_37179_37342[(2)] = inst_36763);

(statearr_37179_37342[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (63))){
var inst_36816 = (state_36997[(2)]);
var state_36997__$1 = state_36997;
if(cljs.core.truth_(inst_36816)){
var statearr_37180_37343 = state_36997__$1;
(statearr_37180_37343[(1)] = (64));

} else {
var statearr_37181_37344 = state_36997__$1;
(statearr_37181_37344[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (94))){
var inst_36893 = from;
var inst_36894 = cljs.core.seq(inst_36893);
var inst_36895 = cljs.core.first(inst_36894);
var inst_36896 = cljs.core.next(inst_36894);
var inst_36897 = cljs.core.PersistentVector.EMPTY;
var inst_36898 = inst_36893;
var inst_36899 = inst_36897;
var state_36997__$1 = (function (){var statearr_37182 = state_36997;
(statearr_37182[(38)] = inst_36898);

(statearr_37182[(42)] = inst_36895);

(statearr_37182[(10)] = inst_36899);

(statearr_37182[(43)] = inst_36896);

return statearr_37182;
})();
var statearr_37183_37345 = state_36997__$1;
(statearr_37183_37345[(2)] = null);

(statearr_37183_37345[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (8))){
var inst_36692 = (state_36997[(25)]);
var inst_36687 = (state_36997[(2)]);
var inst_36688 = opts_SINGLEQUOTE_;
var inst_36689 = cljs.core.__destructure_map(inst_36688);
var inst_36690 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36689,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_36691 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36689,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_36692__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36689,new cljs.core.Keyword(null,"component","component",1555936782));
var inst_36693 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36689,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_36694 = fluree.db.query.fql_parser.parse_db(db,inst_36687,opts_SINGLEQUOTE_);
var inst_36695 = (inst_36692__$1 == null);
var inst_36696 = cljs.core.not(inst_36695);
var state_36997__$1 = (function (){var statearr_37184 = state_36997;
(statearr_37184[(13)] = inst_36691);

(statearr_37184[(24)] = inst_36694);

(statearr_37184[(15)] = inst_36693);

(statearr_37184[(25)] = inst_36692__$1);

(statearr_37184[(18)] = inst_36690);

return statearr_37184;
})();
if(inst_36696){
var statearr_37185_37346 = state_36997__$1;
(statearr_37185_37346[(1)] = (15));

} else {
var statearr_37186_37347 = state_36997__$1;
(statearr_37186_37347[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (49))){
var inst_36968 = (state_36997[(2)]);
var state_36997__$1 = state_36997;
var statearr_37187_37348 = state_36997__$1;
(statearr_37187_37348[(2)] = inst_36968);

(statearr_37187_37348[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36998 === (84))){
var state_36997__$1 = state_36997;
var statearr_37188_37349 = state_36997__$1;
(statearr_37188_37349[(2)] = null);

(statearr_37188_37349[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__11410__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__11410__auto____0 = (function (){
var statearr_37189 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37189[(0)] = fluree$db$query$fql$query_$_state_machine__11410__auto__);

(statearr_37189[(1)] = (1));

return statearr_37189;
});
var fluree$db$query$fql$query_$_state_machine__11410__auto____1 = (function (state_36997){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_36997);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e37190){var ex__11413__auto__ = e37190;
var statearr_37191_37350 = state_36997;
(statearr_37191_37350[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_36997[(4)]))){
var statearr_37192_37351 = state_36997;
(statearr_37192_37351[(1)] = cljs.core.first((state_36997[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37352 = state_36997;
state_36997 = G__37352;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__11410__auto__ = function(state_36997){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__11410__auto____1.call(this,state_36997);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__11410__auto____0;
fluree$db$query$fql$query_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__11410__auto____1;
return fluree$db$query$fql$query_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_37193 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_37193[(6)] = c__11484__auto__);

return statearr_37193;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}

});
