// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30671_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__30671_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__30675 = coll;
var vec__30676 = G__30675;
var seq__30677 = cljs.core.seq(vec__30676);
var first__30678 = cljs.core.first(seq__30677);
var seq__30677__$1 = cljs.core.next(seq__30677);
var clause = first__30678;
var r = seq__30677__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__30675__$1 = G__30675;
var res__$1 = res;
while(true){
var vec__30682 = G__30675__$1;
var seq__30683 = cljs.core.seq(vec__30682);
var first__30684 = cljs.core.first(seq__30683);
var seq__30683__$1 = cljs.core.next(seq__30683);
var clause__$1 = first__30684;
var r__$1 = seq__30683__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__30685 = r__$1;
var G__30686 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__30675__$1 = G__30685;
res__$1 = G__30686;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res,p__30687){
var map__30688 = p__30687;
var map__30688__$1 = cljs.core.__destructure_map(map__30688);
var optional = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30688__$1,new cljs.core.Keyword(null,"optional","optional",2053951509));
if(cljs.core.truth_(optional)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__30692 = coll;
var vec__30693 = G__30692;
var seq__30694 = cljs.core.seq(vec__30693);
var first__30695 = cljs.core.first(seq__30694);
var seq__30694__$1 = cljs.core.next(seq__30694);
var clause = first__30695;
var r = seq__30694__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__30692__$1 = G__30692;
var res__$1 = res;
while(true){
var vec__30699 = G__30692__$1;
var seq__30700 = cljs.core.seq(vec__30699);
var first__30701 = cljs.core.first(seq__30700);
var seq__30700__$1 = cljs.core.next(seq__30700);
var clause__$1 = first__30701;
var r__$1 = seq__30700__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__30702 = r__$1;
var G__30703 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__30692__$1 = G__30702;
res__$1 = G__30703;
continue;
} else {
var G__30704 = r__$1;
var G__30705 = res__$2;
G__30692__$1 = G__30704;
res__$1 = G__30705;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__30709 = coll;
var vec__30710 = G__30709;
var seq__30711 = cljs.core.seq(vec__30710);
var first__30712 = cljs.core.first(seq__30711);
var seq__30711__$1 = cljs.core.next(seq__30711);
var clause = first__30712;
var r = seq__30711__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__30709__$1 = G__30709;
var res__$1 = res;
while(true){
var vec__30716 = G__30709__$1;
var seq__30717 = cljs.core.seq(vec__30716);
var first__30718 = cljs.core.first(seq__30717);
var seq__30717__$1 = cljs.core.next(seq__30717);
var clause__$1 = first__30718;
var r__$1 = seq__30717__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__30719 = r__$1;
var G__30720 = res__$2;
G__30709__$1 = G__30719;
res__$1 = G__30720;
continue;
} else {
var G__30721 = r__$1;
var G__30722 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__30709__$1 = G__30721;
res__$1 = G__30722;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__30725 = clause;
var G__30725__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause)))?cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),G__30725):G__30725);
var G__30725__$2 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__30725__$1)
;
var G__30725__$3 = (function (){var fexpr__30726 = (function (p1__30723_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__30723_SHARP_)," ."].join('');
});
return fexpr__30726(G__30725__$2);
})()
;
if(cljs.core.truth_(optional_QMARK_)){
var fexpr__30727 = (function (p1__30724_SHARP_){
return ["OPTIONAL {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__30724_SHARP_),"}"].join('');
});
return fexpr__30727(G__30725__$3);
} else {
return G__30725__$3;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix)),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map)], 0));
var map__30731 = opts;
var map__30731__$1 = cljs.core.__destructure_map(map__30731);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30731__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30731__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30731__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30731__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30731__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30728_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__30728_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars)].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__30729_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__30729_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__30730_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__30730_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4253__auto__ = language;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_30745){
var state_val_30746 = (state_30745[(1)]);
if((state_val_30746 === (1))){
var inst_30732 = fluree.db.util.core.url_encode(query);
var inst_30733 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_30732)].join('');
var inst_30734 = ["User-Agent","Accept"];
var inst_30735 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_30736 = cljs.core.PersistentHashMap.fromArrays(inst_30734,inst_30735);
var inst_30737 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_30738 = [inst_30736,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_30739 = cljs.core.PersistentHashMap.fromArrays(inst_30737,inst_30738);
var inst_30740 = fluree.db.util.xhttp.get(inst_30733,inst_30739);
var state_30745__$1 = state_30745;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30745__$1,(2),inst_30740);
} else {
if((state_val_30746 === (2))){
var inst_30742 = (state_30745[(2)]);
var inst_30743 = fluree.db.util.async.throw_err(inst_30742);
var state_30745__$1 = state_30745;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30745__$1,inst_30743);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11410__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11410__auto____0 = (function (){
var statearr_30747 = [null,null,null,null,null,null,null];
(statearr_30747[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11410__auto__);

(statearr_30747[(1)] = (1));

return statearr_30747;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11410__auto____1 = (function (state_30745){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_30745);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e30748){var ex__11413__auto__ = e30748;
var statearr_30749_30752 = state_30745;
(statearr_30749_30752[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_30745[(4)]))){
var statearr_30750_30753 = state_30745;
(statearr_30750_30753[(1)] = cljs.core.first((state_30745[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30754 = state_30745;
state_30745 = G__30754;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11410__auto__ = function(state_30745){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11410__auto____1.call(this,state_30745);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11410__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11410__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_30751 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_30751[(6)] = c__11484__auto__);

return statearr_30751;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_30772){
var state_val_30773 = (state_30772[(1)]);
if((state_val_30773 === (1))){
var inst_30755 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_30772__$1 = state_30772;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30772__$1,(2),inst_30755);
} else {
if((state_val_30773 === (2))){
var inst_30758 = (state_30772[(7)]);
var inst_30757 = (state_30772[(2)]);
var inst_30758__$1 = fluree.db.util.async.throw_err(inst_30757);
var inst_30759 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_30758__$1);
var inst_30760 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_30759);
var state_30772__$1 = (function (){var statearr_30774 = state_30772;
(statearr_30774[(7)] = inst_30758__$1);

return statearr_30774;
})();
if(inst_30760){
var statearr_30775_30784 = state_30772__$1;
(statearr_30775_30784[(1)] = (3));

} else {
var statearr_30776_30785 = state_30772__$1;
(statearr_30776_30785[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30773 === (3))){
var inst_30758 = (state_30772[(7)]);
var state_30772__$1 = state_30772;
var statearr_30777_30786 = state_30772__$1;
(statearr_30777_30786[(2)] = inst_30758);

(statearr_30777_30786[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30773 === (4))){
var inst_30758 = (state_30772[(7)]);
var inst_30763 = (function (){var body = inst_30758;
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_30764 = cljs.core.second(inst_30758);
var inst_30765 = cljs.core.second(inst_30764);
var inst_30766 = cljs.core.first(inst_30765);
var inst_30767 = cljs.core.second(inst_30766);
var inst_30768 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_30763,inst_30767);
var state_30772__$1 = state_30772;
var statearr_30778_30787 = state_30772__$1;
(statearr_30778_30787[(2)] = inst_30768);

(statearr_30778_30787[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30773 === (5))){
var inst_30770 = (state_30772[(2)]);
var state_30772__$1 = state_30772;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30772__$1,inst_30770);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11410__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11410__auto____0 = (function (){
var statearr_30779 = [null,null,null,null,null,null,null,null];
(statearr_30779[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11410__auto__);

(statearr_30779[(1)] = (1));

return statearr_30779;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11410__auto____1 = (function (state_30772){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_30772);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e30780){var ex__11413__auto__ = e30780;
var statearr_30781_30788 = state_30772;
(statearr_30781_30788[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_30772[(4)]))){
var statearr_30782_30789 = state_30772;
(statearr_30782_30789[(1)] = cljs.core.first((state_30772[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30790 = state_30772;
state_30772 = G__30790;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11410__auto__ = function(state_30772){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11410__auto____1.call(this,state_30772);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11410__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11410__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_30783 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_30783[(6)] = c__11484__auto__);

return statearr_30783;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30791_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__30791_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30792_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__30792_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30793_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1((p1__30793_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__30793_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__30793_SHARP_.call(null,res)));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_30839){
var state_val_30840 = (state_30839[(1)]);
if((state_val_30840 === (7))){
var inst_30804 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_30839__$1 = state_30839;
var statearr_30841_30869 = state_30839__$1;
(statearr_30841_30869[(2)] = inst_30804);

(statearr_30841_30869[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30840 === (1))){
var state_30839__$1 = state_30839;
var statearr_30842_30870 = state_30839__$1;
(statearr_30842_30870[(2)] = null);

(statearr_30842_30870[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30840 === (4))){
var inst_30794 = (state_30839[(2)]);
var state_30839__$1 = state_30839;
var statearr_30843_30871 = state_30839__$1;
(statearr_30843_30871[(2)] = inst_30794);

(statearr_30843_30871[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30840 === (15))){
var inst_30812 = (state_30839[(7)]);
var inst_30813 = (state_30839[(8)]);
var inst_30818 = (state_30839[(9)]);
var inst_30823 = (state_30839[(2)]);
var inst_30824 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_30818,(0),inst_30823);
var inst_30825 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_30826 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_30812);
var inst_30827 = [inst_30813,inst_30826];
var inst_30828 = cljs.core.PersistentHashMap.fromArrays(inst_30825,inst_30827);
var inst_30829 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_30824,inst_30828);
var inst_30830 = (function(){throw inst_30829})();
var state_30839__$1 = state_30839;
var statearr_30844_30872 = state_30839__$1;
(statearr_30844_30872[(2)] = inst_30830);

(statearr_30844_30872[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30840 === (13))){
var inst_30817 = (state_30839[(10)]);
var state_30839__$1 = state_30839;
var statearr_30845_30873 = state_30839__$1;
(statearr_30845_30873[(2)] = inst_30817);

(statearr_30845_30873[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30840 === (6))){
var state_30839__$1 = state_30839;
var statearr_30846_30874 = state_30839__$1;
(statearr_30846_30874[(2)] = null);

(statearr_30846_30874[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30840 === (3))){
var inst_30837 = (state_30839[(2)]);
var state_30839__$1 = state_30839;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30839__$1,inst_30837);
} else {
if((state_val_30840 === (12))){
var inst_30834 = (state_30839[(2)]);
var _ = (function (){var statearr_30847 = state_30839;
(statearr_30847[(4)] = cljs.core.rest((state_30839[(4)])));

return statearr_30847;
})();
var state_30839__$1 = state_30839;
var statearr_30848_30875 = state_30839__$1;
(statearr_30848_30875[(2)] = inst_30834);

(statearr_30848_30875[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30840 === (2))){
var _ = (function (){var statearr_30849 = state_30839;
(statearr_30849[(4)] = cljs.core.cons((5),(state_30839[(4)])));

return statearr_30849;
})();
var inst_30801 = cljs.core.empty_QMARK_(matching_vars);
var state_30839__$1 = state_30839;
if(inst_30801){
var statearr_30850_30876 = state_30839__$1;
(statearr_30850_30876[(1)] = (6));

} else {
var statearr_30851_30877 = state_30839__$1;
(statearr_30851_30877[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30840 === (11))){
var inst_30812 = (state_30839[(7)]);
var inst_30832 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_30812,all_vars);
var state_30839__$1 = state_30839;
var statearr_30853_30878 = state_30839__$1;
(statearr_30853_30878[(2)] = inst_30832);

(statearr_30853_30878[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30840 === (9))){
var inst_30812 = (state_30839[(7)]);
var inst_30813 = (state_30839[(8)]);
var inst_30810 = (state_30839[(2)]);
var inst_30811 = fluree.db.util.async.throw_err(inst_30810);
var inst_30812__$1 = cljs.core.__destructure_map(inst_30811);
var inst_30813__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30812__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_30814 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30812__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_30815 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_30813__$1);
var state_30839__$1 = (function (){var statearr_30854 = state_30839;
(statearr_30854[(11)] = inst_30814);

(statearr_30854[(7)] = inst_30812__$1);

(statearr_30854[(8)] = inst_30813__$1);

return statearr_30854;
})();
if(inst_30815){
var statearr_30855_30879 = state_30839__$1;
(statearr_30855_30879[(1)] = (10));

} else {
var statearr_30856_30880 = state_30839__$1;
(statearr_30856_30880[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30840 === (5))){
var _ = (function (){var statearr_30857 = state_30839;
(statearr_30857[(4)] = cljs.core.rest((state_30839[(4)])));

return statearr_30857;
})();
var state_30839__$1 = state_30839;
var ex30852 = (state_30839__$1[(2)]);
var statearr_30858_30881 = state_30839__$1;
(statearr_30858_30881[(5)] = ex30852);


if((ex30852 instanceof Error)){
var statearr_30859_30882 = state_30839__$1;
(statearr_30859_30882[(1)] = (4));

(statearr_30859_30882[(5)] = null);

} else {
throw ex30852;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30840 === (14))){
var state_30839__$1 = state_30839;
var statearr_30860_30883 = state_30839__$1;
(statearr_30860_30883[(2)] = (1000));

(statearr_30860_30883[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30840 === (10))){
var inst_30814 = (state_30839[(11)]);
var inst_30812 = (state_30839[(7)]);
var inst_30817 = (state_30839[(10)]);
var inst_30817__$1 = cljs.core.count(inst_30814);
var inst_30818 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_30812);
var inst_30819 = (inst_30817__$1 < (1000));
var state_30839__$1 = (function (){var statearr_30861 = state_30839;
(statearr_30861[(10)] = inst_30817__$1);

(statearr_30861[(9)] = inst_30818);

return statearr_30861;
})();
if(cljs.core.truth_(inst_30819)){
var statearr_30862_30884 = state_30839__$1;
(statearr_30862_30884[(1)] = (13));

} else {
var statearr_30863_30885 = state_30839__$1;
(statearr_30863_30885[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30840 === (8))){
var inst_30806 = (state_30839[(2)]);
var inst_30807 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_30806,optional_clauses);
var inst_30808 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_30807);
var state_30839__$1 = state_30839;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30839__$1,(9),inst_30808);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11410__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11410__auto____0 = (function (){
var statearr_30864 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30864[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11410__auto__);

(statearr_30864[(1)] = (1));

return statearr_30864;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11410__auto____1 = (function (state_30839){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_30839);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e30865){var ex__11413__auto__ = e30865;
var statearr_30866_30886 = state_30839;
(statearr_30866_30886[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_30839[(4)]))){
var statearr_30867_30887 = state_30839;
(statearr_30867_30887[(1)] = cljs.core.first((state_30839[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30888 = state_30839;
state_30839 = G__30888;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11410__auto__ = function(state_30839){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11410__auto____1.call(this,state_30839);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11410__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11410__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_30868 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_30868[(6)] = c__11484__auto__);

return statearr_30868;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
