// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.flake');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4870__auto__ = [];
var len__4864__auto___39679 = arguments.length;
var i__4865__auto___39680 = (0);
while(true){
if((i__4865__auto___39680 < len__4864__auto___39679)){
args__4870__auto__.push((arguments[i__4865__auto___39680]));

var G__39681 = (i__4865__auto___39680 + (1));
i__4865__auto___39680 = G__39681;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0))], 0));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var e_SINGLEQUOTE_ = e;
var msg = e_SINGLEQUOTE_.getMessage();
var err_msg = (((msg == null))?e_SINGLEQUOTE_.getClass():msg);
var args_SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args);
return ["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(err_msg),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(args_SINGLEQUOTE_)].join('');
})(),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq39676){
var G__39677 = cljs.core.first(seq39676);
var seq39676__$1 = cljs.core.next(seq39676);
var G__39678 = cljs.core.first(seq39676__$1);
var seq39676__$2 = cljs.core.next(seq39676__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__39677,G__39678,seq39676__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e39682){var e = e39682;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e39683){var e = e39683;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e39684){var e = e39684;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e39685){var e = e39685;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e39686){var e = e39686;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4870__auto__ = [];
var len__4864__auto___39689 = arguments.length;
var i__4865__auto___39690 = (0);
while(true){
if((i__4865__auto___39690 < len__4864__auto___39689)){
args__4870__auto__.push((arguments[i__4865__auto___39690]));

var G__39691 = (i__4865__auto___39690 + (1));
i__4865__auto___39690 = G__39691;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e39688){var e = e39688;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq39687){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39687));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4870__auto__ = [];
var len__4864__auto___39694 = arguments.length;
var i__4865__auto___39695 = (0);
while(true){
if((i__4865__auto___39695 < len__4864__auto___39694)){
args__4870__auto__.push((arguments[i__4865__auto___39695]));

var G__39696 = (i__4865__auto___39695 + (1));
i__4865__auto___39695 = G__39696;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e39693){var e = e39693;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq39692){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39692));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e39697){var e = e39697;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4870__auto__ = [];
var len__4864__auto___39700 = arguments.length;
var i__4865__auto___39701 = (0);
while(true){
if((i__4865__auto___39701 < len__4864__auto___39700)){
args__4870__auto__.push((arguments[i__4865__auto___39701]));

var G__39702 = (i__4865__auto___39701 + (1));
i__4865__auto___39701 = G__39702;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e39699){var e = e39699;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq39698){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39698));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__4870__auto__ = [];
var len__4864__auto___39705 = arguments.length;
var i__4865__auto___39706 = (0);
while(true){
if((i__4865__auto___39706 < len__4864__auto___39705)){
args__4870__auto__.push((arguments[i__4865__auto___39706]));

var G__39707 = (i__4865__auto___39706 + (1));
i__4865__auto___39706 = G__39707;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e39704){var e = e39704;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq39703){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39703));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e39708){var e = e39708;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e39709){var e = e39709;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4870__auto__ = [];
var len__4864__auto___39712 = arguments.length;
var i__4865__auto___39713 = (0);
while(true){
if((i__4865__auto___39713 < len__4864__auto___39712)){
args__4870__auto__.push((arguments[i__4865__auto___39713]));

var G__39714 = (i__4865__auto___39713 + (1));
i__4865__auto___39713 = G__39714;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e39711){var e = e39711;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq39710){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39710));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4870__auto__ = [];
var len__4864__auto___39717 = arguments.length;
var i__4865__auto___39718 = (0);
while(true){
if((i__4865__auto___39718 < len__4864__auto___39717)){
args__4870__auto__.push((arguments[i__4865__auto___39718]));

var G__39719 = (i__4865__auto___39718 + (1));
i__4865__auto___39718 = G__39719;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e39716){var e = e39716;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq39715){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39715));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___39722 = arguments.length;
var i__4865__auto___39723 = (0);
while(true){
if((i__4865__auto___39723 < len__4864__auto___39722)){
args__4870__auto__.push((arguments[i__4865__auto___39723]));

var G__39724 = (i__4865__auto___39723 + (1));
i__4865__auto___39723 = G__39724;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e39721){var e = e39721;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq39720){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39720));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___39727 = arguments.length;
var i__4865__auto___39728 = (0);
while(true){
if((i__4865__auto___39728 < len__4864__auto___39727)){
args__4870__auto__.push((arguments[i__4865__auto___39728]));

var G__39729 = (i__4865__auto___39728 + (1));
i__4865__auto___39728 = G__39729;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e39726){var e = e39726;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq39725){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39725));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___39732 = arguments.length;
var i__4865__auto___39733 = (0);
while(true){
if((i__4865__auto___39733 < len__4864__auto___39732)){
args__4870__auto__.push((arguments[i__4865__auto___39733]));

var G__39734 = (i__4865__auto___39733 + (1));
i__4865__auto___39733 = G__39734;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e39731){var e = e39731;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq39730){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39730));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___39737 = arguments.length;
var i__4865__auto___39738 = (0);
while(true){
if((i__4865__auto___39738 < len__4864__auto___39737)){
args__4870__auto__.push((arguments[i__4865__auto___39738]));

var G__39739 = (i__4865__auto___39738 + (1));
i__4865__auto___39738 = G__39739;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e39736){var e = e39736;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq39735){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39735));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___39742 = arguments.length;
var i__4865__auto___39743 = (0);
while(true){
if((i__4865__auto___39743 < len__4864__auto___39742)){
args__4870__auto__.push((arguments[i__4865__auto___39743]));

var G__39744 = (i__4865__auto___39743 + (1));
i__4865__auto___39743 = G__39744;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e39741){var e = e39741;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq39740){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39740));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__39746 = arguments.length;
switch (G__39746) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_39774){
var state_val_39775 = (state_39774[(1)]);
if((state_val_39775 === (7))){
var inst_39759 = (state_39774[(7)]);
var inst_39762 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_39759,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_39774__$1 = state_39774;
var statearr_39776_39862 = state_39774__$1;
(statearr_39776_39862[(2)] = inst_39762);

(statearr_39776_39862[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39775 === (1))){
var state_39774__$1 = state_39774;
var statearr_39777_39863 = state_39774__$1;
(statearr_39777_39863[(2)] = null);

(statearr_39777_39863[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39775 === (4))){
var inst_39747 = (state_39774[(2)]);
var state_39774__$1 = state_39774;
var statearr_39778_39864 = state_39774__$1;
(statearr_39778_39864[(2)] = inst_39747);

(statearr_39778_39864[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39775 === (6))){
var inst_39759 = (state_39774[(7)]);
var inst_39759__$1 = (state_39774[(2)]);
var inst_39760 = fluree.db.util.core.exception_QMARK_(inst_39759__$1);
var state_39774__$1 = (function (){var statearr_39779 = state_39774;
(statearr_39779[(7)] = inst_39759__$1);

return statearr_39779;
})();
if(inst_39760){
var statearr_39780_39865 = state_39774__$1;
(statearr_39780_39865[(1)] = (7));

} else {
var statearr_39781_39866 = state_39774__$1;
(statearr_39781_39866[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39775 === (3))){
var inst_39772 = (state_39774[(2)]);
var state_39774__$1 = state_39774;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39774__$1,inst_39772);
} else {
if((state_val_39775 === (2))){
var inst_39753 = (state_39774[(8)]);
var _ = (function (){var statearr_39783 = state_39774;
(statearr_39783[(4)] = cljs.core.cons((5),(state_39774[(4)])));

return statearr_39783;
})();
var inst_39753__$1 = cljs.core.volatile_BANG_((0));
var inst_39754 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_39755 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_39754,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_39753__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000)], 0));
var inst_39756 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_39755);
var inst_39757 = fluree.db.query.fql.query(db,inst_39756);
var state_39774__$1 = (function (){var statearr_39784 = state_39774;
(statearr_39784[(8)] = inst_39753__$1);

return statearr_39784;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39774__$1,(6),inst_39757);
} else {
if((state_val_39775 === (9))){
var inst_39769 = (state_39774[(2)]);
var _ = (function (){var statearr_39785 = state_39774;
(statearr_39785[(4)] = cljs.core.rest((state_39774[(4)])));

return statearr_39785;
})();
var state_39774__$1 = state_39774;
var statearr_39786_39867 = state_39774__$1;
(statearr_39786_39867[(2)] = inst_39769);

(statearr_39786_39867[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39775 === (5))){
var _ = (function (){var statearr_39787 = state_39774;
(statearr_39787[(4)] = cljs.core.rest((state_39774[(4)])));

return statearr_39787;
})();
var state_39774__$1 = state_39774;
var ex39782 = (state_39774__$1[(2)]);
var statearr_39788_39868 = state_39774__$1;
(statearr_39788_39868[(5)] = ex39782);


if((ex39782 instanceof Error)){
var statearr_39789_39869 = state_39774__$1;
(statearr_39789_39869[(1)] = (4));

(statearr_39789_39869[(5)] = null);

} else {
throw ex39782;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39775 === (8))){
var inst_39753 = (state_39774[(8)]);
var inst_39759 = (state_39774[(7)]);
var inst_39764 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39765 = cljs.core.deref(inst_39753);
var inst_39766 = [inst_39759,inst_39765];
var inst_39767 = (new cljs.core.PersistentVector(null,2,(5),inst_39764,inst_39766,null));
var state_39774__$1 = state_39774;
var statearr_39790_39870 = state_39774__$1;
(statearr_39790_39870[(2)] = inst_39767);

(statearr_39790_39870[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__11410__auto____0 = (function (){
var statearr_39791 = [null,null,null,null,null,null,null,null,null];
(statearr_39791[(0)] = fluree$db$dbfunctions$internal$state_machine__11410__auto__);

(statearr_39791[(1)] = (1));

return statearr_39791;
});
var fluree$db$dbfunctions$internal$state_machine__11410__auto____1 = (function (state_39774){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_39774);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e39792){var ex__11413__auto__ = e39792;
var statearr_39793_39871 = state_39774;
(statearr_39793_39871[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_39774[(4)]))){
var statearr_39794_39872 = state_39774;
(statearr_39794_39872[(1)] = cljs.core.first((state_39774[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39873 = state_39774;
state_39774 = G__39873;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__11410__auto__ = function(state_39774){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__11410__auto____1.call(this,state_39774);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__11410__auto____0;
fluree$db$dbfunctions$internal$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__11410__auto____1;
return fluree$db$dbfunctions$internal$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_39795 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_39795[(6)] = c__11484__auto__);

return statearr_39795;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_39840){
var state_val_39841 = (state_39840[(1)]);
if((state_val_39841 === (7))){
var inst_39826 = (state_39840[(2)]);
var inst_39827 = fluree.db.query.fql.query(db,inst_39826);
var state_39840__$1 = state_39840;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39840__$1,(8),inst_39827);
} else {
if((state_val_39841 === (1))){
var inst_39796 = typeof select === 'string';
var state_39840__$1 = state_39840;
if(cljs.core.truth_(inst_39796)){
var statearr_39842_39874 = state_39840__$1;
(statearr_39842_39874[(1)] = (2));

} else {
var statearr_39843_39875 = state_39840__$1;
(statearr_39843_39875[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39841 === (4))){
var inst_39809 = (state_39840[(7)]);
var inst_39802 = (state_39840[(8)]);
var inst_39801 = (state_39840[(2)]);
var inst_39802__$1 = cljs.core.volatile_BANG_((0));
var inst_39803 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_39804 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_39805 = [inst_39802__$1,(100000)];
var inst_39806 = cljs.core.PersistentHashMap.fromArrays(inst_39804,inst_39805);
var inst_39807 = [inst_39801,from,where,block,limit,inst_39806];
var inst_39808 = cljs.core.PersistentHashMap.fromArrays(inst_39803,inst_39807);
var inst_39809__$1 = fluree.db.util.core.without_nils(inst_39808);
var inst_39810 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_39809__$1);
var inst_39811 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_39809__$1);
var inst_39812 = cljs.core.first(inst_39811);
var inst_39813 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_39812], 0));
var inst_39814 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_39813);
var inst_39815 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_39809__$1);
var inst_39816 = cljs.core.last(inst_39815);
var inst_39817 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_39816], 0));
var inst_39818 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_39817);
var inst_39819 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_39810,inst_39814,inst_39818], 0));
var state_39840__$1 = (function (){var statearr_39844 = state_39840;
(statearr_39844[(7)] = inst_39809__$1);

(statearr_39844[(8)] = inst_39802__$1);

return statearr_39844;
})();
if(cljs.core.truth_(inst_39819)){
var statearr_39845_39876 = state_39840__$1;
(statearr_39845_39876[(1)] = (5));

} else {
var statearr_39846_39877 = state_39840__$1;
(statearr_39846_39877[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39841 === (6))){
var inst_39809 = (state_39840[(7)]);
var state_39840__$1 = state_39840;
var statearr_39847_39878 = state_39840__$1;
(statearr_39847_39878[(2)] = inst_39809);

(statearr_39847_39878[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39841 === (3))){
var state_39840__$1 = state_39840;
var statearr_39848_39879 = state_39840__$1;
(statearr_39848_39879[(2)] = select);

(statearr_39848_39879[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39841 === (2))){
var inst_39798 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_39840__$1 = state_39840;
var statearr_39849_39880 = state_39840__$1;
(statearr_39849_39880[(2)] = inst_39798);

(statearr_39849_39880[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39841 === (11))){
var inst_39838 = (state_39840[(2)]);
var state_39840__$1 = state_39840;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39840__$1,inst_39838);
} else {
if((state_val_39841 === (9))){
var inst_39829 = (state_39840[(9)]);
var state_39840__$1 = state_39840;
var statearr_39850_39881 = state_39840__$1;
(statearr_39850_39881[(2)] = inst_39829);

(statearr_39850_39881[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39841 === (5))){
var inst_39809 = (state_39840[(7)]);
var inst_39821 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_39809);
var inst_39822 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_39821);
var inst_39823 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39809,new cljs.core.Keyword(null,"where","where",-2044795965),inst_39822);
var state_39840__$1 = state_39840;
var statearr_39851_39882 = state_39840__$1;
(statearr_39851_39882[(2)] = inst_39823);

(statearr_39851_39882[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39841 === (10))){
var inst_39802 = (state_39840[(8)]);
var inst_39829 = (state_39840[(9)]);
var inst_39833 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39834 = cljs.core.deref(inst_39802);
var inst_39835 = [inst_39829,inst_39834];
var inst_39836 = (new cljs.core.PersistentVector(null,2,(5),inst_39833,inst_39835,null));
var state_39840__$1 = state_39840;
var statearr_39852_39883 = state_39840__$1;
(statearr_39852_39883[(2)] = inst_39836);

(statearr_39852_39883[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39841 === (8))){
var inst_39829 = (state_39840[(9)]);
var inst_39829__$1 = (state_39840[(2)]);
var inst_39830 = fluree.db.util.core.exception_QMARK_(inst_39829__$1);
var state_39840__$1 = (function (){var statearr_39853 = state_39840;
(statearr_39853[(9)] = inst_39829__$1);

return statearr_39853;
})();
if(inst_39830){
var statearr_39854_39884 = state_39840__$1;
(statearr_39854_39884[(1)] = (9));

} else {
var statearr_39855_39885 = state_39840__$1;
(statearr_39855_39885[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__11410__auto____0 = (function (){
var statearr_39856 = [null,null,null,null,null,null,null,null,null,null];
(statearr_39856[(0)] = fluree$db$dbfunctions$internal$state_machine__11410__auto__);

(statearr_39856[(1)] = (1));

return statearr_39856;
});
var fluree$db$dbfunctions$internal$state_machine__11410__auto____1 = (function (state_39840){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_39840);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e39857){var ex__11413__auto__ = e39857;
var statearr_39858_39886 = state_39840;
(statearr_39858_39886[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_39840[(4)]))){
var statearr_39859_39887 = state_39840;
(statearr_39859_39887[(1)] = cljs.core.first((state_39840[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39888 = state_39840;
state_39840 = G__39888;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__11410__auto__ = function(state_39840){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__11410__auto____1.call(this,state_39840);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__11410__auto____0;
fluree$db$dbfunctions$internal$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__11410__auto____1;
return fluree$db$dbfunctions$internal$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_39860 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_39860[(6)] = c__11484__auto__);

return statearr_39860;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__39892 = path;
var vec__39893 = G__39892;
var seq__39894 = cljs.core.seq(vec__39893);
var first__39895 = cljs.core.first(seq__39894);
var seq__39894__$1 = cljs.core.next(seq__39894);
var var$ = first__39895;
var r = seq__39894__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__39892__$1 = G__39892;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__39899 = G__39892__$1;
var seq__39900 = cljs.core.seq(vec__39899);
var first__39901 = cljs.core.first(seq__39900);
var seq__39900__$1 = cljs.core.next(seq__39900);
var var$__$1 = first__39901;
var r__$1 = seq__39900__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__39902 = r__$1;
var G__39903 = n__$2;
var G__39904 = next_clauses;
G__39892__$1 = G__39902;
n__$1 = G__39903;
where_clauses__$1 = G__39904;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__39905 = r__$1;
var G__39906 = next_n;
var G__39907 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__39892__$1 = G__39905;
n__$1 = G__39906;
where_clauses__$1 = G__39907;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_39944){
var state_val_39945 = (state_39944[(1)]);
if((state_val_39945 === (7))){
var inst_39917 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39918 = [path];
var inst_39919 = (new cljs.core.PersistentVector(null,1,(5),inst_39917,inst_39918,null));
var state_39944__$1 = state_39944;
var statearr_39946_39974 = state_39944__$1;
(statearr_39946_39974[(2)] = inst_39919);

(statearr_39946_39974[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39945 === (1))){
var state_39944__$1 = state_39944;
var statearr_39947_39975 = state_39944__$1;
(statearr_39947_39975[(2)] = null);

(statearr_39947_39975[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39945 === (4))){
var inst_39908 = (state_39944[(2)]);
var state_39944__$1 = state_39944;
var statearr_39948_39976 = state_39944__$1;
(statearr_39948_39976[(2)] = inst_39908);

(statearr_39948_39976[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39945 === (13))){
var inst_39935 = (state_39944[(2)]);
var inst_39936 = fluree.db.util.async.throw_err(inst_39935);
var _ = (function (){var statearr_39949 = state_39944;
(statearr_39949[(4)] = cljs.core.rest((state_39944[(4)])));

return statearr_39949;
})();
var state_39944__$1 = state_39944;
var statearr_39950_39977 = state_39944__$1;
(statearr_39950_39977[(2)] = inst_39936);

(statearr_39950_39977[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39945 === (6))){
var state_39944__$1 = state_39944;
var statearr_39952_39978 = state_39944__$1;
(statearr_39952_39978[(2)] = path);

(statearr_39952_39978[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39945 === (3))){
var inst_39942 = (state_39944[(2)]);
var state_39944__$1 = state_39944;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39944__$1,inst_39942);
} else {
if((state_val_39945 === (12))){
var _ = (function (){var statearr_39953 = state_39944;
(statearr_39953[(4)] = cljs.core.rest((state_39944[(4)])));

return statearr_39953;
})();
var state_39944__$1 = state_39944;
var ex39951 = (state_39944__$1[(2)]);
var statearr_39954_39979 = state_39944__$1;
(statearr_39954_39979[(5)] = ex39951);


var statearr_39955_39980 = state_39944__$1;
(statearr_39955_39980[(1)] = (11));

(statearr_39955_39980[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39945 === (2))){
var _ = (function (){var statearr_39956 = state_39944;
(statearr_39956[(4)] = cljs.core.cons((5),(state_39944[(4)])));

return statearr_39956;
})();
var inst_39914 = cljs.core.vector_QMARK_(path);
var state_39944__$1 = state_39944;
if(inst_39914){
var statearr_39957_39981 = state_39944__$1;
(statearr_39957_39981[(1)] = (6));

} else {
var statearr_39958_39982 = state_39944__$1;
(statearr_39958_39982[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39945 === (11))){
var inst_39921 = (state_39944[(7)]);
var inst_39926 = (state_39944[(2)]);
var inst_39927 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_39926,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_39921,endSubject], 0));
var state_39944__$1 = state_39944;
var statearr_39960_39983 = state_39944__$1;
(statearr_39960_39983[(2)] = inst_39927);

(statearr_39960_39983[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39945 === (9))){
var inst_39925 = (state_39944[(8)]);
var _ = (function (){var statearr_39961 = state_39944;
(statearr_39961[(4)] = cljs.core.cons((12),(state_39944[(4)])));

return statearr_39961;
})();
var inst_39933 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_39925);
var state_39944__$1 = state_39944;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39944__$1,(13),inst_39933);
} else {
if((state_val_39945 === (5))){
var _ = (function (){var statearr_39962 = state_39944;
(statearr_39962[(4)] = cljs.core.rest((state_39944[(4)])));

return statearr_39962;
})();
var state_39944__$1 = state_39944;
var ex39959 = (state_39944__$1[(2)]);
var statearr_39963_39984 = state_39944__$1;
(statearr_39963_39984[(5)] = ex39959);


if((ex39959 instanceof Error)){
var statearr_39964_39985 = state_39944__$1;
(statearr_39964_39985[(1)] = (4));

(statearr_39964_39985[(5)] = null);

} else {
throw ex39959;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39945 === (10))){
var inst_39939 = (state_39944[(2)]);
var _ = (function (){var statearr_39965 = state_39944;
(statearr_39965[(4)] = cljs.core.rest((state_39944[(4)])));

return statearr_39965;
})();
var state_39944__$1 = state_39944;
var statearr_39966_39986 = state_39944__$1;
(statearr_39966_39986[(2)] = inst_39939);

(statearr_39966_39986[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39945 === (8))){
var inst_39921 = (state_39944[(7)]);
var inst_39921__$1 = (state_39944[(2)]);
var inst_39922 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_39921__$1,endSubject);
var inst_39923 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_39924 = ["?var1",inst_39922];
var inst_39925 = cljs.core.PersistentHashMap.fromArrays(inst_39923,inst_39924);
var state_39944__$1 = (function (){var statearr_39967 = state_39944;
(statearr_39967[(7)] = inst_39921__$1);

(statearr_39967[(8)] = inst_39925);

return statearr_39967;
})();
var statearr_39968_39987 = state_39944__$1;
(statearr_39968_39987[(2)] = null);

(statearr_39968_39987[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11410__auto____0 = (function (){
var statearr_39969 = [null,null,null,null,null,null,null,null,null];
(statearr_39969[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11410__auto__);

(statearr_39969[(1)] = (1));

return statearr_39969;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11410__auto____1 = (function (state_39944){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_39944);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e39970){var ex__11413__auto__ = e39970;
var statearr_39971_39988 = state_39944;
(statearr_39971_39988[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_39944[(4)]))){
var statearr_39972_39989 = state_39944;
(statearr_39972_39989[(1)] = cljs.core.first((state_39944[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39990 = state_39944;
state_39944 = G__39990;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11410__auto__ = function(state_39944){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11410__auto____1.call(this,state_39944);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11410__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_39973 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_39973[(6)] = c__11484__auto__);

return statearr_39973;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e39991){var e = e39991;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e39992){var e = e39992;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e39993){var e = e39993;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e39994){var e = e39994;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___39997 = arguments.length;
var i__4865__auto___39998 = (0);
while(true){
if((i__4865__auto___39998 < len__4864__auto___39997)){
args__4870__auto__.push((arguments[i__4865__auto___39998]));

var G__39999 = (i__4865__auto___39998 + (1));
i__4865__auto___39998 = G__39999;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e39996){var e = e39996;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq39995){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39995));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___40002 = arguments.length;
var i__4865__auto___40003 = (0);
while(true){
if((i__4865__auto___40003 < len__4864__auto___40002)){
args__4870__auto__.push((arguments[i__4865__auto___40003]));

var G__40004 = (i__4865__auto___40003 + (1));
i__4865__auto___40003 = G__40004;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e40001){var e = e40001;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq40000){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40000));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___40007 = arguments.length;
var i__4865__auto___40008 = (0);
while(true){
if((i__4865__auto___40008 < len__4864__auto___40007)){
args__4870__auto__.push((arguments[i__4865__auto___40008]));

var G__40009 = (i__4865__auto___40008 + (1));
i__4865__auto___40008 = G__40009;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4253__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e40006){var e = e40006;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq40005){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40005));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___40012 = arguments.length;
var i__4865__auto___40013 = (0);
while(true){
if((i__4865__auto___40013 < len__4864__auto___40012)){
args__4870__auto__.push((arguments[i__4865__auto___40013]));

var G__40014 = (i__4865__auto___40013 + (1));
i__4865__auto___40013 = G__40014;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e40011){var e = e40011;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq40010){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40010));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e40015){var e = e40015;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e40016){var e = e40016;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e40017){var e = e40017;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e40018){var e = e40018;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e40019){var e = e40019;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__40025 = path;
var vec__40026 = G__40025;
var seq__40027 = cljs.core.seq(vec__40026);
var first__40028 = cljs.core.first(seq__40027);
var seq__40027__$1 = cljs.core.next(seq__40027);
var pred = first__40028;
var r = seq__40027__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__40025__$1 = G__40025;
var subjects__$1 = subjects;
while(true){
var vec__40032 = G__40025__$1;
var seq__40033 = cljs.core.seq(vec__40032);
var first__40034 = cljs.core.first(seq__40033);
var seq__40033__$1 = cljs.core.next(seq__40033);
var pred__$1 = first__40034;
var r__$1 = seq__40033__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__40025__$1,subjects__$1,vec__40032,seq__40033,first__40034,seq__40033__$1,pred__$1,r__$1,subjects__$2,G__40025,vec__40026,seq__40027,first__40028,seq__40027__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__40025__$1,subjects__$1,vec__40032,seq__40033,first__40034,seq__40033__$1,pred__$1,r__$1,subjects__$2,G__40025,vec__40026,seq__40027,first__40028,seq__40027__$1,pred,r,subjects){
return (function (p1__40020_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__40020_SHARP_,pred__$1);
});})(G__40025__$1,subjects__$1,vec__40032,seq__40033,first__40034,seq__40033__$1,pred__$1,r__$1,subjects__$2,G__40025,vec__40026,seq__40027,first__40028,seq__40027__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__40025__$1,subjects__$1,vec__40032,seq__40033,first__40034,seq__40033__$1,pred__$1,r__$1,subjects__$2,G__40025,vec__40026,seq__40027,first__40028,seq__40027__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4251__auto__ = r__$1;
if(and__4251__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__4251__auto__;
}
})())){
var G__40035 = r__$1;
var G__40036 = next_subjects;
G__40025__$1 = G__40035;
subjects__$1 = G__40036;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e40021){var e = e40021;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e40037){var e = e40037;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_(coll,key);
}catch (e40038){var e = e40038;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4870__auto__ = [];
var len__4864__auto___40041 = arguments.length;
var i__4865__auto___40042 = (0);
while(true){
if((i__4865__auto___40042 < len__4864__auto___40041)){
args__4870__auto__.push((arguments[i__4865__auto___40042]));

var G__40043 = (i__4865__auto___40042 + (1));
i__4865__auto___40042 = G__40043;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e40040){var e = e40040;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq40039){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40039));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e40044){var e = e40044;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___40047 = arguments.length;
var i__4865__auto___40048 = (0);
while(true){
if((i__4865__auto___40048 < len__4864__auto___40047)){
args__4870__auto__.push((arguments[i__4865__auto___40048]));

var G__40049 = (i__4865__auto___40048 + (1));
i__4865__auto___40048 = G__40049;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e40046){var e = e40046;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq40045){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40045));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e40050){var e = e40050;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_40107){
var state_val_40108 = (state_40107[(1)]);
if((state_val_40108 === (7))){
var inst_40053 = (state_40107[(2)]);
var state_40107__$1 = state_40107;
var statearr_40109_40143 = state_40107__$1;
(statearr_40109_40143[(2)] = inst_40053);

(statearr_40109_40143[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40108 === (1))){
var state_40107__$1 = state_40107;
var statearr_40110_40144 = state_40107__$1;
(statearr_40110_40144[(2)] = null);

(statearr_40110_40144[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40108 === (4))){
var inst_40052 = (state_40107[(2)]);
var state_40107__$1 = (function (){var statearr_40111 = state_40107;
(statearr_40111[(7)] = inst_40052);

return statearr_40111;
})();
var statearr_40112_40145 = state_40107__$1;
(statearr_40112_40145[(2)] = null);

(statearr_40112_40145[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40108 === (15))){
var inst_40090 = (state_40107[(8)]);
var inst_40078 = (state_40107[(9)]);
var inst_40075 = (state_40107[(10)]);
var inst_40087 = (state_40107[(11)]);
var inst_40088 = (state_40107[(12)]);
var inst_40077 = (state_40107[(13)]);
var inst_40094 = (function (){var db = inst_40075;
var prevT = inst_40077;
var db_SINGLEQUOTE_ = inst_40078;
var prev_vals = inst_40087;
var fuel = inst_40088;
var G__40089 = inst_40090;
return (function (p1__40051_SHARP_){
var f = p1__40051_SHARP_;
return f.o;
});
})();
var inst_40095 = (inst_40094.cljs$core$IFn$_invoke$arity$1 ? inst_40094.cljs$core$IFn$_invoke$arity$1(inst_40090) : inst_40094.call(null,inst_40090));
var state_40107__$1 = state_40107;
var statearr_40113_40146 = state_40107__$1;
(statearr_40113_40146[(2)] = inst_40095);

(statearr_40113_40146[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40108 === (13))){
var inst_40090 = (state_40107[(8)]);
var inst_40087 = (state_40107[(11)]);
var inst_40086 = (state_40107[(2)]);
var inst_40087__$1 = fluree.db.util.async.throw_err(inst_40086);
var inst_40088 = fluree.db.dbfunctions.internal.count(inst_40087__$1);
var inst_40090__$1 = cljs.core.first(inst_40087__$1);
var inst_40091 = (inst_40090__$1 == null);
var state_40107__$1 = (function (){var statearr_40114 = state_40107;
(statearr_40114[(8)] = inst_40090__$1);

(statearr_40114[(11)] = inst_40087__$1);

(statearr_40114[(12)] = inst_40088);

return statearr_40114;
})();
if(cljs.core.truth_(inst_40091)){
var statearr_40115_40147 = state_40107__$1;
(statearr_40115_40147[(1)] = (14));

} else {
var statearr_40116_40148 = state_40107__$1;
(statearr_40116_40148[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40108 === (6))){
var inst_40062 = (state_40107[(2)]);
var state_40107__$1 = state_40107;
var statearr_40117_40149 = state_40107__$1;
(statearr_40117_40149[(2)] = inst_40062);

(statearr_40117_40149[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40108 === (3))){
var inst_40105 = (state_40107[(2)]);
var state_40107__$1 = state_40107;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40107__$1,inst_40105);
} else {
if((state_val_40108 === (12))){
var inst_40102 = (state_40107[(2)]);
var _ = (function (){var statearr_40118 = state_40107;
(statearr_40118[(4)] = cljs.core.rest((state_40107[(4)])));

return statearr_40118;
})();
var state_40107__$1 = state_40107;
var statearr_40119_40150 = state_40107__$1;
(statearr_40119_40150[(2)] = inst_40102);

(statearr_40119_40150[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40108 === (2))){
var _ = (function (){var statearr_40121 = state_40107;
(statearr_40121[(4)] = cljs.core.cons((9),(state_40107[(4)])));

return statearr_40121;
})();
var inst_40068 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40069 = typeof inst_40068 === 'string';
var state_40107__$1 = state_40107;
if(cljs.core.truth_(inst_40069)){
var statearr_40122_40151 = state_40107__$1;
(statearr_40122_40151[(1)] = (10));

} else {
var statearr_40123_40152 = state_40107__$1;
(statearr_40123_40152[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40108 === (11))){
var inst_40078 = (state_40107[(9)]);
var inst_40075 = (state_40107[(10)]);
var inst_40077 = (state_40107[(13)]);
var inst_40075__$1 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40076 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_40075__$1);
var inst_40077__$1 = fluree.db.dbfunctions.internal.inc(inst_40076);
var inst_40078__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_40075__$1,new cljs.core.Keyword(null,"t","t",-1397832519),inst_40077__$1);
var inst_40079 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40080 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40081 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40082 = [inst_40080,inst_40081];
var inst_40083 = (new cljs.core.PersistentVector(null,2,(5),inst_40079,inst_40082,null));
var inst_40084 = fluree.db.dbproto._search(inst_40078__$1,inst_40083);
var state_40107__$1 = (function (){var statearr_40124 = state_40107;
(statearr_40124[(9)] = inst_40078__$1);

(statearr_40124[(10)] = inst_40075__$1);

(statearr_40124[(13)] = inst_40077__$1);

return statearr_40124;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40107__$1,(13),inst_40084);
} else {
if((state_val_40108 === (9))){
var _ = (function (){var statearr_40125 = state_40107;
(statearr_40125[(4)] = cljs.core.rest((state_40107[(4)])));

return statearr_40125;
})();
var state_40107__$1 = state_40107;
var ex40120 = (state_40107__$1[(2)]);
var statearr_40126_40153 = state_40107__$1;
(statearr_40126_40153[(5)] = ex40120);


var statearr_40127_40154 = state_40107__$1;
(statearr_40127_40154[(1)] = (4));

(statearr_40127_40154[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40108 === (5))){
var inst_40052 = (state_40107[(7)]);
var _ = (function (){var statearr_40128 = state_40107;
(statearr_40128[(4)] = cljs.core.cons((8),(state_40107[(4)])));

return statearr_40128;
})();
var inst_40059 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_40052,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_40129 = state_40107;
(statearr_40129[(4)] = cljs.core.rest((state_40107[(4)])));

return statearr_40129;
})();
var state_40107__$1 = state_40107;
var statearr_40130_40155 = state_40107__$1;
(statearr_40130_40155[(2)] = inst_40059);

(statearr_40130_40155[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40108 === (14))){
var state_40107__$1 = state_40107;
var statearr_40131_40156 = state_40107__$1;
(statearr_40131_40156[(2)] = null);

(statearr_40131_40156[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40108 === (16))){
var inst_40088 = (state_40107[(12)]);
var inst_40097 = (state_40107[(2)]);
var inst_40098 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40099 = [inst_40097,inst_40088];
var inst_40100 = (new cljs.core.PersistentVector(null,2,(5),inst_40098,inst_40099,null));
var state_40107__$1 = state_40107;
var statearr_40133_40157 = state_40107__$1;
(statearr_40133_40157[(2)] = inst_40100);

(statearr_40133_40157[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40108 === (10))){
var inst_40071 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40072 = [null,(0)];
var inst_40073 = (new cljs.core.PersistentVector(null,2,(5),inst_40071,inst_40072,null));
var state_40107__$1 = state_40107;
var statearr_40134_40158 = state_40107__$1;
(statearr_40134_40158[(2)] = inst_40073);

(statearr_40134_40158[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40108 === (8))){
var _ = (function (){var statearr_40135 = state_40107;
(statearr_40135[(4)] = cljs.core.rest((state_40107[(4)])));

return statearr_40135;
})();
var state_40107__$1 = state_40107;
var ex40132 = (state_40107__$1[(2)]);
var statearr_40136_40159 = state_40107__$1;
(statearr_40136_40159[(5)] = ex40132);


var statearr_40137_40160 = state_40107__$1;
(statearr_40137_40160[(1)] = (7));

(statearr_40137_40160[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11410__auto____0 = (function (){
var statearr_40138 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40138[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11410__auto__);

(statearr_40138[(1)] = (1));

return statearr_40138;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11410__auto____1 = (function (state_40107){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_40107);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e40139){var ex__11413__auto__ = e40139;
var statearr_40140_40161 = state_40107;
(statearr_40140_40161[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_40107[(4)]))){
var statearr_40141_40162 = state_40107;
(statearr_40141_40162[(1)] = cljs.core.first((state_40107[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40163 = state_40107;
state_40107 = G__40163;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11410__auto__ = function(state_40107){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11410__auto____1.call(this,state_40107);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11410__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_40142 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_40142[(6)] = c__11484__auto__);

return statearr_40142;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_40215){
var state_val_40216 = (state_40215[(1)]);
if((state_val_40216 === (7))){
var inst_40165 = (state_40215[(2)]);
var state_40215__$1 = state_40215;
var statearr_40217_40246 = state_40215__$1;
(statearr_40217_40246[(2)] = inst_40165);

(statearr_40217_40246[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40216 === (1))){
var state_40215__$1 = state_40215;
var statearr_40218_40247 = state_40215__$1;
(statearr_40218_40247[(2)] = null);

(statearr_40218_40247[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40216 === (4))){
var inst_40164 = (state_40215[(2)]);
var state_40215__$1 = (function (){var statearr_40219 = state_40215;
(statearr_40219[(7)] = inst_40164);

return statearr_40219;
})();
var statearr_40220_40248 = state_40215__$1;
(statearr_40220_40248[(2)] = null);

(statearr_40220_40248[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40216 === (13))){
var inst_40210 = (state_40215[(2)]);
var _ = (function (){var statearr_40221 = state_40215;
(statearr_40221[(4)] = cljs.core.rest((state_40215[(4)])));

return statearr_40221;
})();
var state_40215__$1 = state_40215;
var statearr_40222_40249 = state_40215__$1;
(statearr_40222_40249[(2)] = inst_40210);

(statearr_40222_40249[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40216 === (6))){
var inst_40174 = (state_40215[(2)]);
var state_40215__$1 = state_40215;
var statearr_40223_40250 = state_40215__$1;
(statearr_40223_40250[(2)] = inst_40174);

(statearr_40223_40250[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40216 === (3))){
var inst_40213 = (state_40215[(2)]);
var state_40215__$1 = state_40215;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40215__$1,inst_40213);
} else {
if((state_val_40216 === (12))){
var inst_40197 = (state_40215[(8)]);
var inst_40206 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40207 = [null,inst_40197];
var inst_40208 = (new cljs.core.PersistentVector(null,2,(5),inst_40206,inst_40207,null));
var state_40215__$1 = state_40215;
var statearr_40224_40251 = state_40215__$1;
(statearr_40224_40251[(2)] = inst_40208);

(statearr_40224_40251[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40216 === (2))){
var _ = (function (){var statearr_40226 = state_40215;
(statearr_40226[(4)] = cljs.core.cons((9),(state_40215[(4)])));

return statearr_40226;
})();
var inst_40183 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_40184 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40185 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40186 = [null,pred_name,"?o"];
var inst_40187 = (new cljs.core.PersistentVector(null,3,(5),inst_40185,inst_40186,null));
var inst_40188 = [inst_40187];
var inst_40189 = (new cljs.core.PersistentVector(null,1,(5),inst_40184,inst_40188,null));
var inst_40190 = ["?o",inst_40189,opts];
var inst_40191 = cljs.core.PersistentHashMap.fromArrays(inst_40183,inst_40190);
var inst_40192 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_40191);
var state_40215__$1 = state_40215;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40215__$1,(10),inst_40192);
} else {
if((state_val_40216 === (11))){
var inst_40196 = (state_40215[(9)]);
var inst_40197 = (state_40215[(8)]);
var inst_40201 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40202 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_40196);
var inst_40203 = [inst_40202,inst_40197];
var inst_40204 = (new cljs.core.PersistentVector(null,2,(5),inst_40201,inst_40203,null));
var state_40215__$1 = state_40215;
var statearr_40227_40252 = state_40215__$1;
(statearr_40227_40252[(2)] = inst_40204);

(statearr_40227_40252[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40216 === (9))){
var _ = (function (){var statearr_40228 = state_40215;
(statearr_40228[(4)] = cljs.core.rest((state_40215[(4)])));

return statearr_40228;
})();
var state_40215__$1 = state_40215;
var ex40225 = (state_40215__$1[(2)]);
var statearr_40229_40253 = state_40215__$1;
(statearr_40229_40253[(5)] = ex40225);


var statearr_40230_40254 = state_40215__$1;
(statearr_40230_40254[(1)] = (4));

(statearr_40230_40254[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40216 === (5))){
var inst_40164 = (state_40215[(7)]);
var _ = (function (){var statearr_40232 = state_40215;
(statearr_40232[(4)] = cljs.core.cons((8),(state_40215[(4)])));

return statearr_40232;
})();
var inst_40171 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_40164,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_40233 = state_40215;
(statearr_40233[(4)] = cljs.core.rest((state_40215[(4)])));

return statearr_40233;
})();
var state_40215__$1 = state_40215;
var statearr_40234_40255 = state_40215__$1;
(statearr_40234_40255[(2)] = inst_40171);

(statearr_40234_40255[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40216 === (10))){
var inst_40196 = (state_40215[(9)]);
var inst_40194 = (state_40215[(2)]);
var inst_40195 = fluree.db.util.async.throw_err(inst_40194);
var inst_40196__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40195,(0),null);
var inst_40197 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40195,(1),null);
var inst_40198 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_40196__$1);
var inst_40199 = cljs.core.not(inst_40198);
var state_40215__$1 = (function (){var statearr_40235 = state_40215;
(statearr_40235[(9)] = inst_40196__$1);

(statearr_40235[(8)] = inst_40197);

return statearr_40235;
})();
if(inst_40199){
var statearr_40236_40256 = state_40215__$1;
(statearr_40236_40256[(1)] = (11));

} else {
var statearr_40237_40257 = state_40215__$1;
(statearr_40237_40257[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40216 === (8))){
var _ = (function (){var statearr_40238 = state_40215;
(statearr_40238[(4)] = cljs.core.rest((state_40215[(4)])));

return statearr_40238;
})();
var state_40215__$1 = state_40215;
var ex40231 = (state_40215__$1[(2)]);
var statearr_40239_40258 = state_40215__$1;
(statearr_40239_40258[(5)] = ex40231);


var statearr_40240_40259 = state_40215__$1;
(statearr_40240_40259[(1)] = (7));

(statearr_40240_40259[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11410__auto____0 = (function (){
var statearr_40241 = [null,null,null,null,null,null,null,null,null,null];
(statearr_40241[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11410__auto__);

(statearr_40241[(1)] = (1));

return statearr_40241;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11410__auto____1 = (function (state_40215){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_40215);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e40242){var ex__11413__auto__ = e40242;
var statearr_40243_40260 = state_40215;
(statearr_40243_40260[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_40215[(4)]))){
var statearr_40244_40261 = state_40215;
(statearr_40244_40261[(1)] = cljs.core.first((state_40215[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40262 = state_40215;
state_40215 = G__40262;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11410__auto__ = function(state_40215){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11410__auto____1.call(this,state_40215);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11410__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_40245 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_40245[(6)] = c__11484__auto__);

return statearr_40245;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$((function (){var and__4251__auto__ = typeof email === 'string';
if(and__4251__auto__){
return cljs.core.re_matches(pattern,email);
} else {
return and__4251__auto__;
}
})());
}catch (e40263){var e = e40263;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__40265 = arguments.length;
switch (G__40265) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_40335){
var state_val_40336 = (state_40335[(1)]);
if((state_val_40336 === (7))){
var inst_40267 = (state_40335[(2)]);
var state_40335__$1 = state_40335;
var statearr_40337_40381 = state_40335__$1;
(statearr_40337_40381[(2)] = inst_40267);

(statearr_40337_40381[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40336 === (20))){
var inst_40311 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40312 = ["*"];
var inst_40313 = (new cljs.core.PersistentVector(null,1,(5),inst_40311,inst_40312,null));
var state_40335__$1 = state_40335;
var statearr_40338_40382 = state_40335__$1;
(statearr_40338_40382[(2)] = inst_40313);

(statearr_40338_40382[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40336 === (1))){
var state_40335__$1 = state_40335;
var statearr_40339_40383 = state_40335__$1;
(statearr_40339_40383[(2)] = null);

(statearr_40339_40383[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40336 === (4))){
var inst_40266 = (state_40335[(2)]);
var state_40335__$1 = (function (){var statearr_40340 = state_40335;
(statearr_40340[(7)] = inst_40266);

return statearr_40340;
})();
var statearr_40341_40384 = state_40335__$1;
(statearr_40341_40384[(2)] = null);

(statearr_40341_40384[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40336 === (15))){
var inst_40330 = (state_40335[(2)]);
var _ = (function (){var statearr_40342 = state_40335;
(statearr_40342[(4)] = cljs.core.rest((state_40335[(4)])));

return statearr_40342;
})();
var state_40335__$1 = state_40335;
var statearr_40343_40385 = state_40335__$1;
(statearr_40343_40385[(2)] = inst_40330);

(statearr_40343_40385[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40336 === (21))){
var inst_40294 = (state_40335[(8)]);
var inst_40301 = (state_40335[(9)]);
var inst_40315 = (state_40335[(2)]);
var inst_40316 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_40317 = cljs.core.PersistentHashMap.EMPTY;
var inst_40318 = [inst_40315,inst_40301,inst_40317];
var inst_40319 = cljs.core.PersistentHashMap.fromArrays(inst_40316,inst_40318);
var inst_40320 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_40294,inst_40319);
var state_40335__$1 = state_40335;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40335__$1,(22),inst_40320);
} else {
if((state_val_40336 === (13))){
var inst_40289 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_40335__$1 = state_40335;
var statearr_40344_40386 = state_40335__$1;
(statearr_40344_40386[(2)] = inst_40289);

(statearr_40344_40386[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40336 === (22))){
var inst_40322 = (state_40335[(2)]);
var inst_40323 = fluree.db.util.async.throw_err(inst_40322);
var inst_40324 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40323,(0),null);
var inst_40325 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40323,(1),null);
var inst_40326 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40327 = [inst_40324,inst_40325];
var inst_40328 = (new cljs.core.PersistentVector(null,2,(5),inst_40326,inst_40327,null));
var state_40335__$1 = state_40335;
var statearr_40345_40387 = state_40335__$1;
(statearr_40345_40387[(2)] = inst_40328);

(statearr_40345_40387[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40336 === (6))){
var inst_40276 = (state_40335[(2)]);
var state_40335__$1 = state_40335;
var statearr_40346_40388 = state_40335__$1;
(statearr_40346_40388[(2)] = inst_40276);

(statearr_40346_40388[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40336 === (17))){
var inst_40298 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40299 = fluree.db.dbfunctions.internal.get(inst_40298,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_40335__$1 = state_40335;
var statearr_40347_40389 = state_40335__$1;
(statearr_40347_40389[(2)] = inst_40299);

(statearr_40347_40389[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40336 === (3))){
var inst_40333 = (state_40335[(2)]);
var state_40335__$1 = state_40335;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40335__$1,inst_40333);
} else {
if((state_val_40336 === (12))){
var inst_40287 = (state_40335[(2)]);
var state_40335__$1 = state_40335;
if(cljs.core.truth_(inst_40287)){
var statearr_40348_40390 = state_40335__$1;
(statearr_40348_40390[(1)] = (13));

} else {
var statearr_40349_40391 = state_40335__$1;
(statearr_40349_40391[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40336 === (2))){
var inst_40282 = (state_40335[(10)]);
var _ = (function (){var statearr_40350 = state_40335;
(statearr_40350[(4)] = cljs.core.cons((9),(state_40335[(4)])));

return statearr_40350;
})();
var inst_40282__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_40335__$1 = (function (){var statearr_40351 = state_40335;
(statearr_40351[(10)] = inst_40282__$1);

return statearr_40351;
})();
if(cljs.core.truth_(inst_40282__$1)){
var statearr_40352_40392 = state_40335__$1;
(statearr_40352_40392[(1)] = (10));

} else {
var statearr_40353_40393 = state_40335__$1;
(statearr_40353_40393[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40336 === (19))){
var inst_40303 = cljs.core.PersistentVector.EMPTY;
var inst_40304 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40305 = ["*"];
var inst_40306 = (new cljs.core.PersistentVector(null,1,(5),inst_40304,inst_40305,null));
var inst_40307 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_40308 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_40306,inst_40307);
var inst_40309 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_40303,inst_40308);
var state_40335__$1 = state_40335;
var statearr_40355_40394 = state_40335__$1;
(statearr_40355_40394[(2)] = inst_40309);

(statearr_40355_40394[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40336 === (11))){
var inst_40282 = (state_40335[(10)]);
var state_40335__$1 = state_40335;
var statearr_40356_40395 = state_40335__$1;
(statearr_40356_40395[(2)] = inst_40282);

(statearr_40356_40395[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40336 === (9))){
var _ = (function (){var statearr_40357 = state_40335;
(statearr_40357[(4)] = cljs.core.rest((state_40335[(4)])));

return statearr_40357;
})();
var state_40335__$1 = state_40335;
var ex40354 = (state_40335__$1[(2)]);
var statearr_40358_40396 = state_40335__$1;
(statearr_40358_40396[(5)] = ex40354);


var statearr_40359_40397 = state_40335__$1;
(statearr_40359_40397[(1)] = (4));

(statearr_40359_40397[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40336 === (5))){
var inst_40266 = (state_40335[(7)]);
var _ = (function (){var statearr_40360 = state_40335;
(statearr_40360[(4)] = cljs.core.cons((8),(state_40335[(4)])));

return statearr_40360;
})();
var inst_40273 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_40266,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_40361 = state_40335;
(statearr_40361[(4)] = cljs.core.rest((state_40335[(4)])));

return statearr_40361;
})();
var state_40335__$1 = state_40335;
var statearr_40362_40398 = state_40335__$1;
(statearr_40362_40398[(2)] = inst_40273);

(statearr_40362_40398[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40336 === (14))){
var inst_40295 = (state_40335[(11)]);
var inst_40294 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40295__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_40335__$1 = (function (){var statearr_40363 = state_40335;
(statearr_40363[(8)] = inst_40294);

(statearr_40363[(11)] = inst_40295__$1);

return statearr_40363;
})();
if(cljs.core.truth_(inst_40295__$1)){
var statearr_40364_40399 = state_40335__$1;
(statearr_40364_40399[(1)] = (16));

} else {
var statearr_40365_40400 = state_40335__$1;
(statearr_40365_40400[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40336 === (16))){
var inst_40295 = (state_40335[(11)]);
var state_40335__$1 = state_40335;
var statearr_40366_40401 = state_40335__$1;
(statearr_40366_40401[(2)] = inst_40295);

(statearr_40366_40401[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40336 === (10))){
var inst_40284 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_40335__$1 = state_40335;
var statearr_40368_40402 = state_40335__$1;
(statearr_40368_40402[(2)] = inst_40284);

(statearr_40368_40402[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40336 === (18))){
var inst_40301 = (state_40335[(2)]);
var state_40335__$1 = (function (){var statearr_40369 = state_40335;
(statearr_40369[(9)] = inst_40301);

return statearr_40369;
})();
if(cljs.core.truth_(additional_params)){
var statearr_40370_40403 = state_40335__$1;
(statearr_40370_40403[(1)] = (19));

} else {
var statearr_40371_40404 = state_40335__$1;
(statearr_40371_40404[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40336 === (8))){
var _ = (function (){var statearr_40372 = state_40335;
(statearr_40372[(4)] = cljs.core.rest((state_40335[(4)])));

return statearr_40372;
})();
var state_40335__$1 = state_40335;
var ex40367 = (state_40335__$1[(2)]);
var statearr_40373_40405 = state_40335__$1;
(statearr_40373_40405[(5)] = ex40367);


var statearr_40374_40406 = state_40335__$1;
(statearr_40374_40406[(1)] = (7));

(statearr_40374_40406[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__11410__auto____0 = (function (){
var statearr_40375 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40375[(0)] = fluree$db$dbfunctions$internal$state_machine__11410__auto__);

(statearr_40375[(1)] = (1));

return statearr_40375;
});
var fluree$db$dbfunctions$internal$state_machine__11410__auto____1 = (function (state_40335){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_40335);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e40376){var ex__11413__auto__ = e40376;
var statearr_40377_40407 = state_40335;
(statearr_40377_40407[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_40335[(4)]))){
var statearr_40378_40408 = state_40335;
(statearr_40378_40408[(1)] = cljs.core.first((state_40335[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40409 = state_40335;
state_40335 = G__40409;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__11410__auto__ = function(state_40335){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__11410__auto____1.call(this,state_40335);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__11410__auto____0;
fluree$db$dbfunctions$internal$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__11410__auto____1;
return fluree$db$dbfunctions$internal$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_40379 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_40379[(6)] = c__11484__auto__);

return statearr_40379;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__40411 = arguments.length;
switch (G__40411) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_40455){
var state_val_40456 = (state_40455[(1)]);
if((state_val_40456 === (7))){
var inst_40433 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40434 = ["*"];
var inst_40435 = (new cljs.core.PersistentVector(null,1,(5),inst_40433,inst_40434,null));
var state_40455__$1 = state_40455;
var statearr_40457_40477 = state_40455__$1;
(statearr_40457_40477[(2)] = inst_40435);

(statearr_40457_40477[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40456 === (1))){
var state_40455__$1 = state_40455;
var statearr_40458_40478 = state_40455__$1;
(statearr_40458_40478[(2)] = null);

(statearr_40458_40478[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40456 === (4))){
var inst_40412 = (state_40455[(2)]);
var inst_40413 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_40412,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_40455__$1 = state_40455;
var statearr_40459_40479 = state_40455__$1;
(statearr_40459_40479[(2)] = inst_40413);

(statearr_40459_40479[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40456 === (6))){
var inst_40425 = cljs.core.PersistentVector.EMPTY;
var inst_40426 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40427 = ["*"];
var inst_40428 = (new cljs.core.PersistentVector(null,1,(5),inst_40426,inst_40427,null));
var inst_40429 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_40430 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_40428,inst_40429);
var inst_40431 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_40425,inst_40430);
var state_40455__$1 = state_40455;
var statearr_40460_40480 = state_40455__$1;
(statearr_40460_40480[(2)] = inst_40431);

(statearr_40460_40480[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40456 === (3))){
var inst_40453 = (state_40455[(2)]);
var state_40455__$1 = state_40455;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40455__$1,inst_40453);
} else {
if((state_val_40456 === (2))){
var _ = (function (){var statearr_40462 = state_40455;
(statearr_40462[(4)] = cljs.core.cons((5),(state_40455[(4)])));

return statearr_40462;
})();
var inst_40422 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40423 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_40455__$1 = (function (){var statearr_40463 = state_40455;
(statearr_40463[(7)] = inst_40423);

(statearr_40463[(8)] = inst_40422);

return statearr_40463;
})();
if(cljs.core.truth_(additional_params)){
var statearr_40464_40481 = state_40455__$1;
(statearr_40464_40481[(1)] = (6));

} else {
var statearr_40465_40482 = state_40455__$1;
(statearr_40465_40482[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40456 === (9))){
var inst_40444 = (state_40455[(2)]);
var inst_40445 = fluree.db.util.async.throw_err(inst_40444);
var inst_40446 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40445,(0),null);
var inst_40447 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40445,(1),null);
var inst_40448 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40449 = [inst_40446,inst_40447];
var inst_40450 = (new cljs.core.PersistentVector(null,2,(5),inst_40448,inst_40449,null));
var _ = (function (){var statearr_40466 = state_40455;
(statearr_40466[(4)] = cljs.core.rest((state_40455[(4)])));

return statearr_40466;
})();
var state_40455__$1 = state_40455;
var statearr_40467_40483 = state_40455__$1;
(statearr_40467_40483[(2)] = inst_40450);

(statearr_40467_40483[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40456 === (5))){
var _ = (function (){var statearr_40468 = state_40455;
(statearr_40468[(4)] = cljs.core.rest((state_40455[(4)])));

return statearr_40468;
})();
var state_40455__$1 = state_40455;
var ex40461 = (state_40455__$1[(2)]);
var statearr_40469_40484 = state_40455__$1;
(statearr_40469_40484[(5)] = ex40461);


var statearr_40470_40485 = state_40455__$1;
(statearr_40470_40485[(1)] = (4));

(statearr_40470_40485[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40456 === (8))){
var inst_40423 = (state_40455[(7)]);
var inst_40422 = (state_40455[(8)]);
var inst_40437 = (state_40455[(2)]);
var inst_40438 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_40439 = cljs.core.PersistentHashMap.EMPTY;
var inst_40440 = [inst_40437,inst_40423,inst_40439];
var inst_40441 = cljs.core.PersistentHashMap.fromArrays(inst_40438,inst_40440);
var inst_40442 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_40422,inst_40441);
var state_40455__$1 = state_40455;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40455__$1,(9),inst_40442);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__11410__auto____0 = (function (){
var statearr_40471 = [null,null,null,null,null,null,null,null,null];
(statearr_40471[(0)] = fluree$db$dbfunctions$internal$state_machine__11410__auto__);

(statearr_40471[(1)] = (1));

return statearr_40471;
});
var fluree$db$dbfunctions$internal$state_machine__11410__auto____1 = (function (state_40455){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_40455);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e40472){var ex__11413__auto__ = e40472;
var statearr_40473_40486 = state_40455;
(statearr_40473_40486[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_40455[(4)]))){
var statearr_40474_40487 = state_40455;
(statearr_40474_40487[(1)] = cljs.core.first((state_40455[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40488 = state_40455;
state_40455 = G__40488;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__11410__auto__ = function(state_40455){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__11410__auto____1.call(this,state_40455);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__11410__auto____0;
fluree$db$dbfunctions$internal$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__11410__auto____1;
return fluree$db$dbfunctions$internal$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_40475 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_40475[(6)] = c__11484__auto__);

return statearr_40475;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_40532){
var state_val_40533 = (state_40532[(1)]);
if((state_val_40533 === (1))){
var state_40532__$1 = state_40532;
var statearr_40534_40548 = state_40532__$1;
(statearr_40534_40548[(2)] = null);

(statearr_40534_40548[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40533 === (2))){
var _ = (function (){var statearr_40535 = state_40532;
(statearr_40535[(4)] = cljs.core.cons((5),(state_40532[(4)])));

return statearr_40535;
})();
var inst_40499 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_40500 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40501 = ["_user/_auth"];
var inst_40502 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40503 = ["*"];
var inst_40504 = (new cljs.core.PersistentVector(null,1,(5),inst_40502,inst_40503,null));
var inst_40505 = [inst_40504];
var inst_40506 = cljs.core.PersistentHashMap.fromArrays(inst_40501,inst_40505);
var inst_40507 = [inst_40506];
var inst_40508 = (new cljs.core.PersistentVector(null,1,(5),inst_40500,inst_40507,null));
var inst_40509 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40510 = cljs.core.PersistentHashMap.EMPTY;
var inst_40511 = [inst_40508,inst_40509,inst_40510];
var inst_40512 = cljs.core.PersistentHashMap.fromArrays(inst_40499,inst_40511);
var inst_40513 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40514 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_40513,inst_40512);
var state_40532__$1 = state_40532;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40532__$1,(6),inst_40514);
} else {
if((state_val_40533 === (3))){
var inst_40530 = (state_40532[(2)]);
var state_40532__$1 = state_40532;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40532__$1,inst_40530);
} else {
if((state_val_40533 === (4))){
var inst_40489 = (state_40532[(2)]);
var inst_40490 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_40489,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_40532__$1 = state_40532;
var statearr_40537_40549 = state_40532__$1;
(statearr_40537_40549[(2)] = inst_40490);

(statearr_40537_40549[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40533 === (5))){
var _ = (function (){var statearr_40538 = state_40532;
(statearr_40538[(4)] = cljs.core.rest((state_40532[(4)])));

return statearr_40538;
})();
var state_40532__$1 = state_40532;
var ex40536 = (state_40532__$1[(2)]);
var statearr_40539_40550 = state_40532__$1;
(statearr_40539_40550[(5)] = ex40536);


var statearr_40540_40551 = state_40532__$1;
(statearr_40540_40551[(1)] = (4));

(statearr_40540_40551[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40533 === (6))){
var inst_40516 = (state_40532[(2)]);
var inst_40517 = fluree.db.util.async.throw_err(inst_40516);
var inst_40518 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40517,(0),null);
var inst_40519 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40517,(1),null);
var inst_40520 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40521 = ["_user/_auth","_id"];
var inst_40522 = (new cljs.core.PersistentVector(null,2,(5),inst_40520,inst_40521,null));
var inst_40523 = fluree.db.dbfunctions.internal.get_in(inst_40518,inst_40522);
var inst_40524 = cljs.core.first(inst_40523);
var inst_40525 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40526 = [inst_40524,inst_40519];
var inst_40527 = (new cljs.core.PersistentVector(null,2,(5),inst_40525,inst_40526,null));
var _ = (function (){var statearr_40541 = state_40532;
(statearr_40541[(4)] = cljs.core.rest((state_40532[(4)])));

return statearr_40541;
})();
var state_40532__$1 = state_40532;
var statearr_40542_40552 = state_40532__$1;
(statearr_40542_40552[(2)] = inst_40527);

(statearr_40542_40552[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11410__auto____0 = (function (){
var statearr_40543 = [null,null,null,null,null,null,null];
(statearr_40543[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11410__auto__);

(statearr_40543[(1)] = (1));

return statearr_40543;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11410__auto____1 = (function (state_40532){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_40532);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e40544){var ex__11413__auto__ = e40544;
var statearr_40545_40553 = state_40532;
(statearr_40545_40553[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_40532[(4)]))){
var statearr_40546_40554 = state_40532;
(statearr_40546_40554[(1)] = cljs.core.first((state_40532[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40555 = state_40532;
state_40532 = G__40555;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11410__auto__ = function(state_40532){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11410__auto____1.call(this,state_40532);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11410__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_40547 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_40547[(6)] = c__11484__auto__);

return statearr_40547;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_40572){
var state_val_40573 = (state_40572[(1)]);
if((state_val_40573 === (1))){
var state_40572__$1 = state_40572;
var statearr_40574_40588 = state_40572__$1;
(statearr_40574_40588[(2)] = null);

(statearr_40574_40588[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40573 === (2))){
var _ = (function (){var statearr_40575 = state_40572;
(statearr_40575[(4)] = cljs.core.cons((5),(state_40572[(4)])));

return statearr_40575;
})();
var inst_40562 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40563 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40564 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_40563,inst_40562);
var state_40572__$1 = state_40572;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40572__$1,(6),inst_40564);
} else {
if((state_val_40573 === (3))){
var inst_40570 = (state_40572[(2)]);
var state_40572__$1 = state_40572;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40572__$1,inst_40570);
} else {
if((state_val_40573 === (4))){
var inst_40556 = (state_40572[(2)]);
var state_40572__$1 = state_40572;
var statearr_40577_40589 = state_40572__$1;
(statearr_40577_40589[(2)] = inst_40556);

(statearr_40577_40589[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40573 === (5))){
var _ = (function (){var statearr_40578 = state_40572;
(statearr_40578[(4)] = cljs.core.rest((state_40572[(4)])));

return statearr_40578;
})();
var state_40572__$1 = state_40572;
var ex40576 = (state_40572__$1[(2)]);
var statearr_40579_40590 = state_40572__$1;
(statearr_40579_40590[(5)] = ex40576);


if((ex40576 instanceof Error)){
var statearr_40580_40591 = state_40572__$1;
(statearr_40580_40591[(1)] = (4));

(statearr_40580_40591[(5)] = null);

} else {
throw ex40576;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40573 === (6))){
var inst_40566 = (state_40572[(2)]);
var inst_40567 = fluree.db.util.async.throw_err(inst_40566);
var _ = (function (){var statearr_40581 = state_40572;
(statearr_40581[(4)] = cljs.core.rest((state_40572[(4)])));

return statearr_40581;
})();
var state_40572__$1 = state_40572;
var statearr_40582_40592 = state_40572__$1;
(statearr_40582_40592[(2)] = inst_40567);

(statearr_40582_40592[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11410__auto____0 = (function (){
var statearr_40583 = [null,null,null,null,null,null,null];
(statearr_40583[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11410__auto__);

(statearr_40583[(1)] = (1));

return statearr_40583;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11410__auto____1 = (function (state_40572){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_40572);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e40584){var ex__11413__auto__ = e40584;
var statearr_40585_40593 = state_40572;
(statearr_40585_40593[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_40572[(4)]))){
var statearr_40586_40594 = state_40572;
(statearr_40586_40594[(1)] = cljs.core.first((state_40572[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40595 = state_40572;
state_40572 = G__40595;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11410__auto__ = function(state_40572){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11410__auto____1.call(this,state_40572);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11410__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_40587 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_40587[(6)] = c__11484__auto__);

return statearr_40587;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__40596_SHARP_){
return p1__40596_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__40597_SHARP_){
return p1__40597_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e40598){var e = e40598;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__40599_SHARP_){
return p1__40599_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__40600_SHARP_){
return p1__40600_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e40601){var e = e40601;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__40603 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__40603);
})() | (0));
return num;
}catch (e40602){var e = e40602;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_40683){
var state_val_40684 = (state_40683[(1)]);
if((state_val_40684 === (7))){
var inst_40622 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_40623 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_40624 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_40625 = cljs.core.PersistentHashMap.fromArrays(inst_40623,inst_40624);
var inst_40626 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_40622,inst_40625);
var inst_40627 = (function(){throw inst_40626})();
var state_40683__$1 = state_40683;
var statearr_40685_40720 = state_40683__$1;
(statearr_40685_40720[(2)] = inst_40627);

(statearr_40685_40720[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40684 === (1))){
var state_40683__$1 = state_40683;
var statearr_40686_40721 = state_40683__$1;
(statearr_40686_40721[(2)] = null);

(statearr_40686_40721[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40684 === (4))){
var inst_40604 = (state_40683[(2)]);
var state_40683__$1 = state_40683;
var statearr_40687_40722 = state_40683__$1;
(statearr_40687_40722[(2)] = inst_40604);

(statearr_40687_40722[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40684 === (15))){
var inst_40667 = (state_40683[(7)]);
var inst_40663 = (state_40683[(2)]);
var inst_40664 = fluree.db.util.async.throw_err(inst_40663);
var inst_40665 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40664,(0),null);
var inst_40666 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40664,(1),null);
var inst_40667__$1 = cljs.core.first(inst_40665);
var inst_40668 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_40667__$1,compare_val);
var state_40683__$1 = (function (){var statearr_40688 = state_40683;
(statearr_40688[(8)] = inst_40666);

(statearr_40688[(7)] = inst_40667__$1);

return statearr_40688;
})();
if(inst_40668){
var statearr_40689_40723 = state_40683__$1;
(statearr_40689_40723[(1)] = (16));

} else {
var statearr_40690_40724 = state_40683__$1;
(statearr_40690_40724[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40684 === (13))){
var state_40683__$1 = state_40683;
var statearr_40691_40725 = state_40683__$1;
(statearr_40691_40725[(2)] = null);

(statearr_40691_40725[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40684 === (6))){
var state_40683__$1 = state_40683;
var statearr_40692_40726 = state_40683__$1;
(statearr_40692_40726[(2)] = null);

(statearr_40692_40726[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40684 === (17))){
var inst_40667 = (state_40683[(7)]);
var inst_40671 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40667)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_40672 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_40673 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_40674 = cljs.core.PersistentHashMap.fromArrays(inst_40672,inst_40673);
var inst_40675 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_40671,inst_40674);
var inst_40676 = (function(){throw inst_40675})();
var state_40683__$1 = state_40683;
var statearr_40693_40727 = state_40683__$1;
(statearr_40693_40727[(2)] = inst_40676);

(statearr_40693_40727[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40684 === (3))){
var inst_40681 = (state_40683[(2)]);
var state_40683__$1 = state_40683;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40683__$1,inst_40681);
} else {
if((state_val_40684 === (12))){
var inst_40619 = (state_40683[(9)]);
var inst_40642 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_40619], 0));
var inst_40643 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_40644 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_40645 = cljs.core.PersistentHashMap.fromArrays(inst_40643,inst_40644);
var inst_40646 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_40642,inst_40645);
var inst_40647 = (function(){throw inst_40646})();
var state_40683__$1 = state_40683;
var statearr_40694_40728 = state_40683__$1;
(statearr_40694_40728[(2)] = inst_40647);

(statearr_40694_40728[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40684 === (2))){
var inst_40616 = (state_40683[(10)]);
var inst_40617 = (state_40683[(11)]);
var inst_40618 = (state_40683[(12)]);
var _ = (function (){var statearr_40695 = state_40683;
(statearr_40695[(4)] = cljs.core.cons((5),(state_40683[(4)])));

return statearr_40695;
})();
var inst_40614 = _QMARK_ctx;
var inst_40615 = cljs.core.__destructure_map(inst_40614);
var inst_40616__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40615,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_40617__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40615,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_40618__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40615,new cljs.core.Keyword(null,"db","db",993250759));
var inst_40619 = fluree.db.dbproto._p_prop(inst_40618__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_40617__$1);
var state_40683__$1 = (function (){var statearr_40696 = state_40683;
(statearr_40696[(10)] = inst_40616__$1);

(statearr_40696[(9)] = inst_40619);

(statearr_40696[(11)] = inst_40617__$1);

(statearr_40696[(12)] = inst_40618__$1);

return statearr_40696;
})();
if(cljs.core.truth_(inst_40616__$1)){
var statearr_40697_40729 = state_40683__$1;
(statearr_40697_40729[(1)] = (6));

} else {
var statearr_40698_40730 = state_40683__$1;
(statearr_40698_40730[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40684 === (11))){
var inst_40617 = (state_40683[(11)]);
var inst_40618 = (state_40683[(12)]);
var inst_40639 = (state_40683[(2)]);
var inst_40640 = fluree.db.dbproto._p_prop(inst_40618,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_40617);
var state_40683__$1 = (function (){var statearr_40700 = state_40683;
(statearr_40700[(13)] = inst_40639);

return statearr_40700;
})();
if(cljs.core.truth_(inst_40640)){
var statearr_40701_40731 = state_40683__$1;
(statearr_40701_40731[(1)] = (12));

} else {
var statearr_40702_40732 = state_40683__$1;
(statearr_40702_40732[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40684 === (9))){
var state_40683__$1 = state_40683;
var statearr_40703_40733 = state_40683__$1;
(statearr_40703_40733[(2)] = null);

(statearr_40703_40733[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40684 === (5))){
var _ = (function (){var statearr_40704 = state_40683;
(statearr_40704[(4)] = cljs.core.rest((state_40683[(4)])));

return statearr_40704;
})();
var state_40683__$1 = state_40683;
var ex40699 = (state_40683__$1[(2)]);
var statearr_40705_40734 = state_40683__$1;
(statearr_40705_40734[(5)] = ex40699);


if((ex40699 instanceof Error)){
var statearr_40706_40735 = state_40683__$1;
(statearr_40706_40735[(1)] = (4));

(statearr_40706_40735[(5)] = null);

} else {
throw ex40699;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40684 === (14))){
var inst_40616 = (state_40683[(10)]);
var inst_40619 = (state_40683[(9)]);
var inst_40618 = (state_40683[(12)]);
var inst_40650 = (state_40683[(2)]);
var inst_40651 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_40652 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40653 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40654 = [inst_40616,inst_40619,"?current-val"];
var inst_40655 = (new cljs.core.PersistentVector(null,3,(5),inst_40653,inst_40654,null));
var inst_40656 = [inst_40655];
var inst_40657 = (new cljs.core.PersistentVector(null,1,(5),inst_40652,inst_40656,null));
var inst_40658 = cljs.core.PersistentHashMap.EMPTY;
var inst_40659 = ["?current-val",inst_40657,inst_40658];
var inst_40660 = cljs.core.PersistentHashMap.fromArrays(inst_40651,inst_40659);
var inst_40661 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_40618,inst_40660);
var state_40683__$1 = (function (){var statearr_40707 = state_40683;
(statearr_40707[(14)] = inst_40650);

return statearr_40707;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40683__$1,(15),inst_40661);
} else {
if((state_val_40684 === (16))){
var state_40683__$1 = state_40683;
var statearr_40708_40736 = state_40683__$1;
(statearr_40708_40736[(2)] = new_val);

(statearr_40708_40736[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40684 === (10))){
var inst_40632 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_40633 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_40634 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_40635 = cljs.core.PersistentHashMap.fromArrays(inst_40633,inst_40634);
var inst_40636 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_40632,inst_40635);
var inst_40637 = (function(){throw inst_40636})();
var state_40683__$1 = state_40683;
var statearr_40709_40737 = state_40683__$1;
(statearr_40709_40737[(2)] = inst_40637);

(statearr_40709_40737[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40684 === (18))){
var inst_40678 = (state_40683[(2)]);
var _ = (function (){var statearr_40710 = state_40683;
(statearr_40710[(4)] = cljs.core.rest((state_40683[(4)])));

return statearr_40710;
})();
var state_40683__$1 = state_40683;
var statearr_40711_40738 = state_40683__$1;
(statearr_40711_40738[(2)] = inst_40678);

(statearr_40711_40738[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40684 === (8))){
var inst_40619 = (state_40683[(9)]);
var inst_40629 = (state_40683[(2)]);
var state_40683__$1 = (function (){var statearr_40712 = state_40683;
(statearr_40712[(15)] = inst_40629);

return statearr_40712;
})();
if(cljs.core.truth_(inst_40619)){
var statearr_40713_40739 = state_40683__$1;
(statearr_40713_40739[(1)] = (9));

} else {
var statearr_40714_40740 = state_40683__$1;
(statearr_40714_40740[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__11410__auto____0 = (function (){
var statearr_40715 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40715[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__11410__auto__);

(statearr_40715[(1)] = (1));

return statearr_40715;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__11410__auto____1 = (function (state_40683){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_40683);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e40716){var ex__11413__auto__ = e40716;
var statearr_40717_40741 = state_40683;
(statearr_40717_40741[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_40683[(4)]))){
var statearr_40718_40742 = state_40683;
(statearr_40718_40742[(1)] = cljs.core.first((state_40683[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40743 = state_40683;
state_40683 = G__40743;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__11410__auto__ = function(state_40683){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__11410__auto____1.call(this,state_40683);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__11410__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_40719 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_40719[(6)] = c__11484__auto__);

return statearr_40719;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
