// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4913__auto___64061 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_64112){
var state_val_64113 = (state_64112[(1)]);
if((state_val_64113 === (7))){
var inst_64107 = (state_64112[(2)]);
var _ = (function (){var statearr_64114 = state_64112;
(statearr_64114[(4)] = cljs.core.rest((state_64112[(4)])));

return statearr_64114;
})();
var state_64112__$1 = state_64112;
var statearr_64115_64142 = state_64112__$1;
(statearr_64115_64142[(2)] = inst_64107);

(statearr_64115_64142[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64113 === (1))){
var state_64112__$1 = state_64112;
var statearr_64116_64143 = state_64112__$1;
(statearr_64116_64143[(2)] = null);

(statearr_64116_64143[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64113 === (4))){
var inst_64062 = (state_64112[(2)]);
var state_64112__$1 = state_64112;
var statearr_64117_64144 = state_64112__$1;
(statearr_64117_64144[(2)] = inst_64062);

(statearr_64117_64144[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64113 === (13))){
var inst_64103 = (state_64112[(2)]);
var state_64112__$1 = state_64112;
var statearr_64118_64145 = state_64112__$1;
(statearr_64118_64145[(2)] = inst_64103);

(statearr_64118_64145[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64113 === (6))){
var inst_64087 = (state_64112[(7)]);
var inst_64080 = (state_64112[(8)]);
var inst_64086 = cljs.core.seq(inst_64080);
var inst_64087__$1 = cljs.core.first(inst_64086);
var inst_64088 = cljs.core.next(inst_64086);
var inst_64089 = cljs.core.not(inst_64087__$1);
var state_64112__$1 = (function (){var statearr_64119 = state_64112;
(statearr_64119[(7)] = inst_64087__$1);

(statearr_64119[(9)] = inst_64088);

return statearr_64119;
})();
if(inst_64089){
var statearr_64120_64146 = state_64112__$1;
(statearr_64120_64146[(1)] = (8));

} else {
var statearr_64121_64147 = state_64112__$1;
(statearr_64121_64147[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64113 === (3))){
var inst_64110 = (state_64112[(2)]);
var state_64112__$1 = state_64112;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64112__$1,inst_64110);
} else {
if((state_val_64113 === (12))){
var inst_64081 = (state_64112[(10)]);
var inst_64087 = (state_64112[(7)]);
var inst_64088 = (state_64112[(9)]);
var inst_64100 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_64081,inst_64087);
var inst_64080 = inst_64088;
var inst_64081__$1 = inst_64100;
var state_64112__$1 = (function (){var statearr_64122 = state_64112;
(statearr_64122[(10)] = inst_64081__$1);

(statearr_64122[(8)] = inst_64080);

return statearr_64122;
})();
var statearr_64123_64148 = state_64112__$1;
(statearr_64123_64148[(2)] = null);

(statearr_64123_64148[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64113 === (2))){
var _ = (function (){var statearr_64124 = state_64112;
(statearr_64124[(4)] = cljs.core.cons((5),(state_64112[(4)])));

return statearr_64124;
})();
var inst_64075 = args;
var inst_64076 = cljs.core.seq(inst_64075);
var inst_64077 = cljs.core.first(inst_64076);
var inst_64078 = cljs.core.next(inst_64076);
var inst_64079 = cljs.core.PersistentVector.EMPTY;
var inst_64080 = inst_64075;
var inst_64081 = inst_64079;
var state_64112__$1 = (function (){var statearr_64125 = state_64112;
(statearr_64125[(10)] = inst_64081);

(statearr_64125[(8)] = inst_64080);

(statearr_64125[(11)] = inst_64078);

(statearr_64125[(12)] = inst_64077);

return statearr_64125;
})();
var statearr_64126_64149 = state_64112__$1;
(statearr_64126_64149[(2)] = null);

(statearr_64126_64149[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64113 === (11))){
var inst_64087 = (state_64112[(7)]);
var state_64112__$1 = state_64112;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64112__$1,(14),inst_64087);
} else {
if((state_val_64113 === (9))){
var inst_64087 = (state_64112[(7)]);
var inst_64092 = fluree.db.util.async.channel_QMARK_(inst_64087);
var state_64112__$1 = state_64112;
if(inst_64092){
var statearr_64128_64150 = state_64112__$1;
(statearr_64128_64150[(1)] = (11));

} else {
var statearr_64129_64151 = state_64112__$1;
(statearr_64129_64151[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64113 === (5))){
var _ = (function (){var statearr_64130 = state_64112;
(statearr_64130[(4)] = cljs.core.rest((state_64112[(4)])));

return statearr_64130;
})();
var state_64112__$1 = state_64112;
var ex64127 = (state_64112__$1[(2)]);
var statearr_64131_64152 = state_64112__$1;
(statearr_64131_64152[(5)] = ex64127);


if((ex64127 instanceof Error)){
var statearr_64132_64153 = state_64112__$1;
(statearr_64132_64153[(1)] = (4));

(statearr_64132_64153[(5)] = null);

} else {
throw ex64127;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64113 === (14))){
var inst_64081 = (state_64112[(10)]);
var inst_64088 = (state_64112[(9)]);
var inst_64095 = (state_64112[(2)]);
var inst_64096 = fluree.db.util.async.throw_err(inst_64095);
var inst_64097 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_64081,inst_64096);
var inst_64080 = inst_64088;
var inst_64081__$1 = inst_64097;
var state_64112__$1 = (function (){var statearr_64133 = state_64112;
(statearr_64133[(10)] = inst_64081__$1);

(statearr_64133[(8)] = inst_64080);

return statearr_64133;
})();
var statearr_64134_64154 = state_64112__$1;
(statearr_64134_64154[(2)] = null);

(statearr_64134_64154[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64113 === (10))){
var inst_64105 = (state_64112[(2)]);
var state_64112__$1 = state_64112;
var statearr_64135_64155 = state_64112__$1;
(statearr_64135_64155[(2)] = inst_64105);

(statearr_64135_64155[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64113 === (8))){
var inst_64081 = (state_64112[(10)]);
var state_64112__$1 = state_64112;
var statearr_64136_64156 = state_64112__$1;
(statearr_64136_64156[(2)] = inst_64081);

(statearr_64136_64156[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11410__auto____0 = (function (){
var statearr_64137 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64137[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11410__auto__);

(statearr_64137[(1)] = (1));

return statearr_64137;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11410__auto____1 = (function (state_64112){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_64112);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e64138){var ex__11413__auto__ = e64138;
var statearr_64139_64157 = state_64112;
(statearr_64139_64157[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_64112[(4)]))){
var statearr_64140_64158 = state_64112;
(statearr_64140_64158[(1)] = cljs.core.first((state_64112[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64159 = state_64112;
state_64112 = G__64159;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11410__auto__ = function(state_64112){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11410__auto____1.call(this,state_64112);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_64141 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_64141[(6)] = c__11484__auto__);

return statearr_64141;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__64160 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64160,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64160,(1),null);
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Smart function stack: ",res], 0));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(s),entry),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"credits","credits",785860820).cljs$core$IFn$_invoke$arity$1(s),cost], 0)),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"spent","spent",-62769180).cljs$core$IFn$_invoke$arity$1(s),cost], 0))], 0));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_64208){
var state_val_64209 = (state_64208[(1)]);
if((state_val_64209 === (7))){
var state_64208__$1 = state_64208;
var statearr_64210_64239 = state_64208__$1;
(statearr_64210_64239[(2)] = coll);

(statearr_64210_64239[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64209 === (1))){
var state_64208__$1 = state_64208;
var statearr_64211_64240 = state_64208__$1;
(statearr_64211_64240[(2)] = null);

(statearr_64211_64240[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64209 === (4))){
var inst_64163 = (state_64208[(2)]);
var state_64208__$1 = state_64208;
var statearr_64212_64241 = state_64208__$1;
(statearr_64212_64241[(2)] = inst_64163);

(statearr_64212_64241[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64209 === (15))){
var inst_64182 = (state_64208[(7)]);
var inst_64190 = (state_64208[(2)]);
var inst_64191 = fluree.db.dbfunctions.internal.nth(inst_64182,inst_64190);
var inst_64192 = cljs.core.count(inst_64182);
var inst_64193 = ((9) + inst_64192);
var inst_64194 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64195 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64196 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64197 = [inst_64182,inst_64190];
var inst_64198 = (new cljs.core.PersistentVector(null,2,(5),inst_64196,inst_64197,null));
var inst_64199 = ["nth",inst_64198,inst_64191];
var inst_64200 = cljs.core.PersistentHashMap.fromArrays(inst_64195,inst_64199);
var inst_64201 = [inst_64200,inst_64193];
var inst_64202 = (new cljs.core.PersistentVector(null,2,(5),inst_64194,inst_64201,null));
var inst_64203 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64202);
var _ = (function (){var statearr_64213 = state_64208;
(statearr_64213[(4)] = cljs.core.rest((state_64208[(4)])));

return statearr_64213;
})();
var state_64208__$1 = (function (){var statearr_64214 = state_64208;
(statearr_64214[(8)] = inst_64203);

return statearr_64214;
})();
var statearr_64215_64242 = state_64208__$1;
(statearr_64215_64242[(2)] = inst_64191);

(statearr_64215_64242[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64209 === (13))){
var state_64208__$1 = state_64208;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64208__$1,(16),key);
} else {
if((state_val_64209 === (6))){
var state_64208__$1 = state_64208;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64208__$1,(9),coll);
} else {
if((state_val_64209 === (3))){
var inst_64206 = (state_64208[(2)]);
var state_64208__$1 = state_64208;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64208__$1,inst_64206);
} else {
if((state_val_64209 === (12))){
var inst_64182 = (state_64208[(2)]);
var inst_64183 = fluree.db.util.async.channel_QMARK_(key);
var state_64208__$1 = (function (){var statearr_64216 = state_64208;
(statearr_64216[(7)] = inst_64182);

return statearr_64216;
})();
if(inst_64183){
var statearr_64217_64243 = state_64208__$1;
(statearr_64217_64243[(1)] = (13));

} else {
var statearr_64218_64244 = state_64208__$1;
(statearr_64218_64244[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64209 === (2))){
var _ = (function (){var statearr_64219 = state_64208;
(statearr_64219[(4)] = cljs.core.cons((5),(state_64208[(4)])));

return statearr_64219;
})();
var inst_64169 = fluree.db.util.async.channel_QMARK_(coll);
var state_64208__$1 = state_64208;
if(inst_64169){
var statearr_64220_64245 = state_64208__$1;
(statearr_64220_64245[(1)] = (6));

} else {
var statearr_64221_64246 = state_64208__$1;
(statearr_64221_64246[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64209 === (11))){
var inst_64176 = (state_64208[(9)]);
var state_64208__$1 = state_64208;
var statearr_64223_64247 = state_64208__$1;
(statearr_64223_64247[(2)] = inst_64176);

(statearr_64223_64247[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64209 === (9))){
var inst_64172 = (state_64208[(2)]);
var inst_64173 = fluree.db.util.async.throw_err(inst_64172);
var state_64208__$1 = state_64208;
var statearr_64224_64248 = state_64208__$1;
(statearr_64224_64248[(2)] = inst_64173);

(statearr_64224_64248[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64209 === (5))){
var _ = (function (){var statearr_64225 = state_64208;
(statearr_64225[(4)] = cljs.core.rest((state_64208[(4)])));

return statearr_64225;
})();
var state_64208__$1 = state_64208;
var ex64222 = (state_64208__$1[(2)]);
var statearr_64226_64249 = state_64208__$1;
(statearr_64226_64249[(5)] = ex64222);


if((ex64222 instanceof Error)){
var statearr_64227_64250 = state_64208__$1;
(statearr_64227_64250[(1)] = (4));

(statearr_64227_64250[(5)] = null);

} else {
throw ex64222;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64209 === (14))){
var state_64208__$1 = state_64208;
var statearr_64228_64251 = state_64208__$1;
(statearr_64228_64251[(2)] = key);

(statearr_64228_64251[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64209 === (16))){
var inst_64186 = (state_64208[(2)]);
var inst_64187 = fluree.db.util.async.throw_err(inst_64186);
var state_64208__$1 = state_64208;
var statearr_64229_64252 = state_64208__$1;
(statearr_64229_64252[(2)] = inst_64187);

(statearr_64229_64252[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64209 === (10))){
var inst_64176 = (state_64208[(9)]);
var inst_64179 = cljs.core.vec(inst_64176);
var state_64208__$1 = state_64208;
var statearr_64230_64253 = state_64208__$1;
(statearr_64230_64253[(2)] = inst_64179);

(statearr_64230_64253[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64209 === (8))){
var inst_64176 = (state_64208[(9)]);
var inst_64176__$1 = (state_64208[(2)]);
var inst_64177 = cljs.core.set_QMARK_(inst_64176__$1);
var state_64208__$1 = (function (){var statearr_64231 = state_64208;
(statearr_64231[(9)] = inst_64176__$1);

return statearr_64231;
})();
if(inst_64177){
var statearr_64232_64254 = state_64208__$1;
(statearr_64232_64254[(1)] = (10));

} else {
var statearr_64233_64255 = state_64208__$1;
(statearr_64233_64255[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__11410__auto____0 = (function (){
var statearr_64234 = [null,null,null,null,null,null,null,null,null,null];
(statearr_64234[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__11410__auto__);

(statearr_64234[(1)] = (1));

return statearr_64234;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__11410__auto____1 = (function (state_64208){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_64208);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e64235){var ex__11413__auto__ = e64235;
var statearr_64236_64256 = state_64208;
(statearr_64236_64256[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_64208[(4)]))){
var statearr_64237_64257 = state_64208;
(statearr_64237_64257[(1)] = cljs.core.first((state_64208[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64258 = state_64208;
state_64208 = G__64258;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__11410__auto__ = function(state_64208){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__11410__auto____1.call(this,state_64208);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_64238 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_64238[(6)] = c__11484__auto__);

return statearr_64238;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_64319){
var state_val_64320 = (state_64319[(1)]);
if((state_val_64320 === (7))){
var state_64319__$1 = state_64319;
var statearr_64321_64355 = state_64319__$1;
(statearr_64321_64355[(2)] = test);

(statearr_64321_64355[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64320 === (20))){
var inst_64293 = (state_64319[(2)]);
var inst_64294 = fluree.db.util.async.throw_err(inst_64293);
var state_64319__$1 = state_64319;
var statearr_64322_64356 = state_64319__$1;
(statearr_64322_64356[(2)] = inst_64294);

(statearr_64322_64356[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64320 === (1))){
var state_64319__$1 = state_64319;
var statearr_64323_64357 = state_64319__$1;
(statearr_64323_64357[(2)] = null);

(statearr_64323_64357[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64320 === (4))){
var inst_64259 = (state_64319[(2)]);
var state_64319__$1 = state_64319;
var statearr_64324_64358 = state_64319__$1;
(statearr_64324_64358[(2)] = inst_64259);

(statearr_64324_64358[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64320 === (15))){
var inst_64277 = (state_64319[(7)]);
var inst_64285 = (state_64319[(2)]);
var inst_64286 = [inst_64285,f];
var inst_64287 = (new cljs.core.PersistentVector(null,2,(5),inst_64277,inst_64286,null));
var state_64319__$1 = state_64319;
var statearr_64325_64359 = state_64319__$1;
(statearr_64325_64359[(2)] = inst_64287);

(statearr_64325_64359[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64320 === (13))){
var state_64319__$1 = state_64319;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64319__$1,(16),t);
} else {
if((state_val_64320 === (6))){
var state_64319__$1 = state_64319;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64319__$1,(9),test);
} else {
if((state_val_64320 === (17))){
var state_64319__$1 = state_64319;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64319__$1,(20),f);
} else {
if((state_val_64320 === (3))){
var inst_64317 = (state_64319[(2)]);
var state_64319__$1 = state_64319;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64319__$1,inst_64317);
} else {
if((state_val_64320 === (12))){
var inst_64275 = (state_64319[(8)]);
var inst_64301 = (state_64319[(2)]);
var inst_64302 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64301,(0),null);
var inst_64303 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64301,(1),null);
var inst_64304 = fluree.db.dbfunctions.internal.if_else(inst_64275,inst_64302,inst_64303);
var inst_64305 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64306 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64307 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64308 = [inst_64275,inst_64302,inst_64303];
var inst_64309 = (new cljs.core.PersistentVector(null,3,(5),inst_64307,inst_64308,null));
var inst_64310 = ["if-else",inst_64309,inst_64304];
var inst_64311 = cljs.core.PersistentHashMap.fromArrays(inst_64306,inst_64310);
var inst_64312 = [inst_64311,(10)];
var inst_64313 = (new cljs.core.PersistentVector(null,2,(5),inst_64305,inst_64312,null));
var inst_64314 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64313);
var _ = (function (){var statearr_64326 = state_64319;
(statearr_64326[(4)] = cljs.core.rest((state_64319[(4)])));

return statearr_64326;
})();
var state_64319__$1 = (function (){var statearr_64327 = state_64319;
(statearr_64327[(9)] = inst_64314);

return statearr_64327;
})();
var statearr_64328_64360 = state_64319__$1;
(statearr_64328_64360[(2)] = inst_64304);

(statearr_64328_64360[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64320 === (2))){
var _ = (function (){var statearr_64329 = state_64319;
(statearr_64329[(4)] = cljs.core.cons((5),(state_64319[(4)])));

return statearr_64329;
})();
var inst_64268 = fluree.db.util.async.channel_QMARK_(test);
var state_64319__$1 = state_64319;
if(inst_64268){
var statearr_64330_64361 = state_64319__$1;
(statearr_64330_64361[(1)] = (6));

} else {
var statearr_64331_64362 = state_64319__$1;
(statearr_64331_64362[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64320 === (19))){
var inst_64289 = (state_64319[(10)]);
var inst_64297 = (state_64319[(2)]);
var inst_64298 = [f,inst_64297];
var inst_64299 = (new cljs.core.PersistentVector(null,2,(5),inst_64289,inst_64298,null));
var state_64319__$1 = state_64319;
var statearr_64332_64363 = state_64319__$1;
(statearr_64332_64363[(2)] = inst_64299);

(statearr_64332_64363[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64320 === (11))){
var inst_64289 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64290 = fluree.db.util.async.channel_QMARK_(f);
var state_64319__$1 = (function (){var statearr_64334 = state_64319;
(statearr_64334[(10)] = inst_64289);

return statearr_64334;
})();
if(inst_64290){
var statearr_64335_64364 = state_64319__$1;
(statearr_64335_64364[(1)] = (17));

} else {
var statearr_64336_64365 = state_64319__$1;
(statearr_64336_64365[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64320 === (9))){
var inst_64271 = (state_64319[(2)]);
var inst_64272 = fluree.db.util.async.throw_err(inst_64271);
var state_64319__$1 = state_64319;
var statearr_64337_64366 = state_64319__$1;
(statearr_64337_64366[(2)] = inst_64272);

(statearr_64337_64366[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64320 === (5))){
var _ = (function (){var statearr_64338 = state_64319;
(statearr_64338[(4)] = cljs.core.rest((state_64319[(4)])));

return statearr_64338;
})();
var state_64319__$1 = state_64319;
var ex64333 = (state_64319__$1[(2)]);
var statearr_64339_64367 = state_64319__$1;
(statearr_64339_64367[(5)] = ex64333);


if((ex64333 instanceof Error)){
var statearr_64340_64368 = state_64319__$1;
(statearr_64340_64368[(1)] = (4));

(statearr_64340_64368[(5)] = null);

} else {
throw ex64333;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64320 === (14))){
var state_64319__$1 = state_64319;
var statearr_64341_64369 = state_64319__$1;
(statearr_64341_64369[(2)] = t);

(statearr_64341_64369[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64320 === (16))){
var inst_64281 = (state_64319[(2)]);
var inst_64282 = fluree.db.util.async.throw_err(inst_64281);
var state_64319__$1 = state_64319;
var statearr_64342_64370 = state_64319__$1;
(statearr_64342_64370[(2)] = inst_64282);

(statearr_64342_64370[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64320 === (10))){
var inst_64277 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64278 = fluree.db.util.async.channel_QMARK_(t);
var state_64319__$1 = (function (){var statearr_64343 = state_64319;
(statearr_64343[(7)] = inst_64277);

return statearr_64343;
})();
if(inst_64278){
var statearr_64344_64371 = state_64319__$1;
(statearr_64344_64371[(1)] = (13));

} else {
var statearr_64345_64372 = state_64319__$1;
(statearr_64345_64372[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64320 === (18))){
var state_64319__$1 = state_64319;
var statearr_64346_64373 = state_64319__$1;
(statearr_64346_64373[(2)] = f);

(statearr_64346_64373[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64320 === (8))){
var inst_64275 = (state_64319[(8)]);
var inst_64275__$1 = (state_64319[(2)]);
var state_64319__$1 = (function (){var statearr_64347 = state_64319;
(statearr_64347[(8)] = inst_64275__$1);

return statearr_64347;
})();
if(cljs.core.truth_(inst_64275__$1)){
var statearr_64348_64374 = state_64319__$1;
(statearr_64348_64374[(1)] = (10));

} else {
var statearr_64349_64375 = state_64319__$1;
(statearr_64349_64375[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__11410__auto____0 = (function (){
var statearr_64350 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_64350[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__11410__auto__);

(statearr_64350[(1)] = (1));

return statearr_64350;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__11410__auto____1 = (function (state_64319){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_64319);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e64351){var ex__11413__auto__ = e64351;
var statearr_64352_64376 = state_64319;
(statearr_64352_64376[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_64319[(4)]))){
var statearr_64353_64377 = state_64319;
(statearr_64353_64377[(1)] = cljs.core.first((state_64319[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64378 = state_64319;
state_64319 = G__64378;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__11410__auto__ = function(state_64319){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__11410__auto____1.call(this,state_64319);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_64354 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_64354[(6)] = c__11484__auto__);

return statearr_64354;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_64408){
var state_val_64409 = (state_64408[(1)]);
if((state_val_64409 === (7))){
var state_64408__$1 = state_64408;
var statearr_64410_64429 = state_64408__$1;
(statearr_64410_64429[(2)] = arg);

(statearr_64410_64429[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64409 === (1))){
var state_64408__$1 = state_64408;
var statearr_64411_64430 = state_64408__$1;
(statearr_64411_64430[(2)] = null);

(statearr_64411_64430[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64409 === (4))){
var inst_64379 = (state_64408[(2)]);
var state_64408__$1 = state_64408;
var statearr_64412_64431 = state_64408__$1;
(statearr_64412_64431[(2)] = inst_64379);

(statearr_64412_64431[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64409 === (6))){
var state_64408__$1 = state_64408;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64408__$1,(9),arg);
} else {
if((state_val_64409 === (3))){
var inst_64406 = (state_64408[(2)]);
var state_64408__$1 = state_64408;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64408__$1,inst_64406);
} else {
if((state_val_64409 === (2))){
var _ = (function (){var statearr_64414 = state_64408;
(statearr_64414[(4)] = cljs.core.cons((5),(state_64408[(4)])));

return statearr_64414;
})();
var inst_64385 = fluree.db.util.async.channel_QMARK_(arg);
var state_64408__$1 = state_64408;
if(inst_64385){
var statearr_64415_64432 = state_64408__$1;
(statearr_64415_64432[(1)] = (6));

} else {
var statearr_64416_64433 = state_64408__$1;
(statearr_64416_64433[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64409 === (9))){
var inst_64388 = (state_64408[(2)]);
var inst_64389 = fluree.db.util.async.throw_err(inst_64388);
var state_64408__$1 = state_64408;
var statearr_64417_64434 = state_64408__$1;
(statearr_64417_64434[(2)] = inst_64389);

(statearr_64417_64434[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64409 === (5))){
var _ = (function (){var statearr_64418 = state_64408;
(statearr_64418[(4)] = cljs.core.rest((state_64408[(4)])));

return statearr_64418;
})();
var state_64408__$1 = state_64408;
var ex64413 = (state_64408__$1[(2)]);
var statearr_64419_64435 = state_64408__$1;
(statearr_64419_64435[(5)] = ex64413);


if((ex64413 instanceof Error)){
var statearr_64420_64436 = state_64408__$1;
(statearr_64420_64436[(1)] = (4));

(statearr_64420_64436[(5)] = null);

} else {
throw ex64413;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64409 === (8))){
var inst_64392 = (state_64408[(2)]);
var inst_64393 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_64392);
var inst_64394 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64395 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64396 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64397 = [inst_64392];
var inst_64398 = (new cljs.core.PersistentVector(null,1,(5),inst_64396,inst_64397,null));
var inst_64399 = ["nil?",inst_64398,inst_64393];
var inst_64400 = cljs.core.PersistentHashMap.fromArrays(inst_64395,inst_64399);
var inst_64401 = [inst_64400,(10)];
var inst_64402 = (new cljs.core.PersistentVector(null,2,(5),inst_64394,inst_64401,null));
var inst_64403 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64402);
var _ = (function (){var statearr_64421 = state_64408;
(statearr_64421[(4)] = cljs.core.rest((state_64408[(4)])));

return statearr_64421;
})();
var state_64408__$1 = (function (){var statearr_64422 = state_64408;
(statearr_64422[(7)] = inst_64403);

return statearr_64422;
})();
var statearr_64423_64437 = state_64408__$1;
(statearr_64423_64437[(2)] = inst_64393);

(statearr_64423_64437[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11410__auto____0 = (function (){
var statearr_64424 = [null,null,null,null,null,null,null,null];
(statearr_64424[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11410__auto__);

(statearr_64424[(1)] = (1));

return statearr_64424;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11410__auto____1 = (function (state_64408){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_64408);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e64425){var ex__11413__auto__ = e64425;
var statearr_64426_64438 = state_64408;
(statearr_64426_64438[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_64408[(4)]))){
var statearr_64427_64439 = state_64408;
(statearr_64427_64439[(1)] = cljs.core.first((state_64408[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64440 = state_64408;
state_64408 = G__64440;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11410__auto__ = function(state_64408){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11410__auto____1.call(this,state_64408);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_64428 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_64428[(6)] = c__11484__auto__);

return statearr_64428;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_64470){
var state_val_64471 = (state_64470[(1)]);
if((state_val_64471 === (7))){
var state_64470__$1 = state_64470;
var statearr_64472_64491 = state_64470__$1;
(statearr_64472_64491[(2)] = arg);

(statearr_64472_64491[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64471 === (1))){
var state_64470__$1 = state_64470;
var statearr_64473_64492 = state_64470__$1;
(statearr_64473_64492[(2)] = null);

(statearr_64473_64492[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64471 === (4))){
var inst_64441 = (state_64470[(2)]);
var state_64470__$1 = state_64470;
var statearr_64474_64493 = state_64470__$1;
(statearr_64474_64493[(2)] = inst_64441);

(statearr_64474_64493[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64471 === (6))){
var state_64470__$1 = state_64470;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64470__$1,(9),arg);
} else {
if((state_val_64471 === (3))){
var inst_64468 = (state_64470[(2)]);
var state_64470__$1 = state_64470;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64470__$1,inst_64468);
} else {
if((state_val_64471 === (2))){
var _ = (function (){var statearr_64476 = state_64470;
(statearr_64476[(4)] = cljs.core.cons((5),(state_64470[(4)])));

return statearr_64476;
})();
var inst_64447 = fluree.db.util.async.channel_QMARK_(arg);
var state_64470__$1 = state_64470;
if(inst_64447){
var statearr_64477_64494 = state_64470__$1;
(statearr_64477_64494[(1)] = (6));

} else {
var statearr_64478_64495 = state_64470__$1;
(statearr_64478_64495[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64471 === (9))){
var inst_64450 = (state_64470[(2)]);
var inst_64451 = fluree.db.util.async.throw_err(inst_64450);
var state_64470__$1 = state_64470;
var statearr_64479_64496 = state_64470__$1;
(statearr_64479_64496[(2)] = inst_64451);

(statearr_64479_64496[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64471 === (5))){
var _ = (function (){var statearr_64480 = state_64470;
(statearr_64480[(4)] = cljs.core.rest((state_64470[(4)])));

return statearr_64480;
})();
var state_64470__$1 = state_64470;
var ex64475 = (state_64470__$1[(2)]);
var statearr_64481_64497 = state_64470__$1;
(statearr_64481_64497[(5)] = ex64475);


if((ex64475 instanceof Error)){
var statearr_64482_64498 = state_64470__$1;
(statearr_64482_64498[(1)] = (4));

(statearr_64482_64498[(5)] = null);

} else {
throw ex64475;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64471 === (8))){
var inst_64454 = (state_64470[(2)]);
var inst_64455 = fluree.db.dbfunctions.internal.not(inst_64454);
var inst_64456 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64457 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64458 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64459 = [inst_64454];
var inst_64460 = (new cljs.core.PersistentVector(null,1,(5),inst_64458,inst_64459,null));
var inst_64461 = ["not?",inst_64460,inst_64455];
var inst_64462 = cljs.core.PersistentHashMap.fromArrays(inst_64457,inst_64461);
var inst_64463 = [inst_64462,(10)];
var inst_64464 = (new cljs.core.PersistentVector(null,2,(5),inst_64456,inst_64463,null));
var inst_64465 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64464);
var _ = (function (){var statearr_64483 = state_64470;
(statearr_64483[(4)] = cljs.core.rest((state_64470[(4)])));

return statearr_64483;
})();
var state_64470__$1 = (function (){var statearr_64484 = state_64470;
(statearr_64484[(7)] = inst_64465);

return statearr_64484;
})();
var statearr_64485_64499 = state_64470__$1;
(statearr_64485_64499[(2)] = inst_64455);

(statearr_64485_64499[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__11410__auto____0 = (function (){
var statearr_64486 = [null,null,null,null,null,null,null,null];
(statearr_64486[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__11410__auto__);

(statearr_64486[(1)] = (1));

return statearr_64486;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__11410__auto____1 = (function (state_64470){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_64470);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e64487){var ex__11413__auto__ = e64487;
var statearr_64488_64500 = state_64470;
(statearr_64488_64500[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_64470[(4)]))){
var statearr_64489_64501 = state_64470;
(statearr_64489_64501[(1)] = cljs.core.first((state_64470[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64502 = state_64470;
state_64470 = G__64502;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__11410__auto__ = function(state_64470){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__11410__auto____1.call(this,state_64470);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_64490 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_64490[(6)] = c__11484__auto__);

return statearr_64490;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_64532){
var state_val_64533 = (state_64532[(1)]);
if((state_val_64533 === (7))){
var state_64532__$1 = state_64532;
var statearr_64534_64553 = state_64532__$1;
(statearr_64534_64553[(2)] = arg);

(statearr_64534_64553[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64533 === (1))){
var state_64532__$1 = state_64532;
var statearr_64535_64554 = state_64532__$1;
(statearr_64535_64554[(2)] = null);

(statearr_64535_64554[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64533 === (4))){
var inst_64503 = (state_64532[(2)]);
var state_64532__$1 = state_64532;
var statearr_64536_64555 = state_64532__$1;
(statearr_64536_64555[(2)] = inst_64503);

(statearr_64536_64555[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64533 === (6))){
var state_64532__$1 = state_64532;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64532__$1,(9),arg);
} else {
if((state_val_64533 === (3))){
var inst_64530 = (state_64532[(2)]);
var state_64532__$1 = state_64532;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64532__$1,inst_64530);
} else {
if((state_val_64533 === (2))){
var _ = (function (){var statearr_64538 = state_64532;
(statearr_64538[(4)] = cljs.core.cons((5),(state_64532[(4)])));

return statearr_64538;
})();
var inst_64509 = fluree.db.util.async.channel_QMARK_(arg);
var state_64532__$1 = state_64532;
if(inst_64509){
var statearr_64539_64556 = state_64532__$1;
(statearr_64539_64556[(1)] = (6));

} else {
var statearr_64540_64557 = state_64532__$1;
(statearr_64540_64557[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64533 === (9))){
var inst_64512 = (state_64532[(2)]);
var inst_64513 = fluree.db.util.async.throw_err(inst_64512);
var state_64532__$1 = state_64532;
var statearr_64541_64558 = state_64532__$1;
(statearr_64541_64558[(2)] = inst_64513);

(statearr_64541_64558[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64533 === (5))){
var _ = (function (){var statearr_64542 = state_64532;
(statearr_64542[(4)] = cljs.core.rest((state_64532[(4)])));

return statearr_64542;
})();
var state_64532__$1 = state_64532;
var ex64537 = (state_64532__$1[(2)]);
var statearr_64543_64559 = state_64532__$1;
(statearr_64543_64559[(5)] = ex64537);


if((ex64537 instanceof Error)){
var statearr_64544_64560 = state_64532__$1;
(statearr_64544_64560[(1)] = (4));

(statearr_64544_64560[(5)] = null);

} else {
throw ex64537;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64533 === (8))){
var inst_64516 = (state_64532[(2)]);
var inst_64517 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_64516);
var inst_64518 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64519 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64520 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64521 = [inst_64516];
var inst_64522 = (new cljs.core.PersistentVector(null,1,(5),inst_64520,inst_64521,null));
var inst_64523 = ["empty?",inst_64522,inst_64517];
var inst_64524 = cljs.core.PersistentHashMap.fromArrays(inst_64519,inst_64523);
var inst_64525 = [inst_64524,(10)];
var inst_64526 = (new cljs.core.PersistentVector(null,2,(5),inst_64518,inst_64525,null));
var inst_64527 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64526);
var _ = (function (){var statearr_64545 = state_64532;
(statearr_64545[(4)] = cljs.core.rest((state_64532[(4)])));

return statearr_64545;
})();
var state_64532__$1 = (function (){var statearr_64546 = state_64532;
(statearr_64546[(7)] = inst_64527);

return statearr_64546;
})();
var statearr_64547_64561 = state_64532__$1;
(statearr_64547_64561[(2)] = inst_64517);

(statearr_64547_64561[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11410__auto____0 = (function (){
var statearr_64548 = [null,null,null,null,null,null,null,null];
(statearr_64548[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11410__auto__);

(statearr_64548[(1)] = (1));

return statearr_64548;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11410__auto____1 = (function (state_64532){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_64532);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e64549){var ex__11413__auto__ = e64549;
var statearr_64550_64562 = state_64532;
(statearr_64550_64562[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_64532[(4)]))){
var statearr_64551_64563 = state_64532;
(statearr_64551_64563[(1)] = cljs.core.first((state_64532[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64564 = state_64532;
state_64532 = G__64564;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11410__auto__ = function(state_64532){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11410__auto____1.call(this,state_64532);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_64552 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_64552[(6)] = c__11484__auto__);

return statearr_64552;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4870__auto__ = [];
var len__4864__auto___64609 = arguments.length;
var i__4865__auto___64610 = (0);
while(true){
if((i__4865__auto___64610 < len__4864__auto___64609)){
args__4870__auto__.push((arguments[i__4865__auto___64610]));

var G__64611 = (i__4865__auto___64610 + (1));
i__4865__auto___64610 = G__64611;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_64592){
var state_val_64593 = (state_64592[(1)]);
if((state_val_64593 === (1))){
var state_64592__$1 = state_64592;
var statearr_64594_64612 = state_64592__$1;
(statearr_64594_64612[(2)] = null);

(statearr_64594_64612[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64593 === (2))){
var _ = (function (){var statearr_64595 = state_64592;
(statearr_64595[(4)] = cljs.core.cons((5),(state_64592[(4)])));

return statearr_64595;
})();
var inst_64573 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_64592__$1 = state_64592;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64592__$1,(6),inst_64573);
} else {
if((state_val_64593 === (3))){
var inst_64590 = (state_64592[(2)]);
var state_64592__$1 = state_64592;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64592__$1,inst_64590);
} else {
if((state_val_64593 === (4))){
var inst_64567 = (state_64592[(2)]);
var state_64592__$1 = state_64592;
var statearr_64597_64613 = state_64592__$1;
(statearr_64597_64613[(2)] = inst_64567);

(statearr_64597_64613[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64593 === (5))){
var _ = (function (){var statearr_64598 = state_64592;
(statearr_64598[(4)] = cljs.core.rest((state_64592[(4)])));

return statearr_64598;
})();
var state_64592__$1 = state_64592;
var ex64596 = (state_64592__$1[(2)]);
var statearr_64599_64614 = state_64592__$1;
(statearr_64599_64614[(5)] = ex64596);


if((ex64596 instanceof Error)){
var statearr_64600_64615 = state_64592__$1;
(statearr_64600_64615[(1)] = (4));

(statearr_64600_64615[(5)] = null);

} else {
throw ex64596;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64593 === (6))){
var inst_64575 = (state_64592[(2)]);
var inst_64576 = fluree.db.util.async.throw_err(inst_64575);
var inst_64577 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_64576);
var inst_64578 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64579 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64580 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64581 = [inst_64576];
var inst_64582 = (new cljs.core.PersistentVector(null,1,(5),inst_64580,inst_64581,null));
var inst_64583 = ["str",inst_64582,inst_64577];
var inst_64584 = cljs.core.PersistentHashMap.fromArrays(inst_64579,inst_64583);
var inst_64585 = [inst_64584,(10)];
var inst_64586 = (new cljs.core.PersistentVector(null,2,(5),inst_64578,inst_64585,null));
var inst_64587 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64586);
var _ = (function (){var statearr_64601 = state_64592;
(statearr_64601[(4)] = cljs.core.rest((state_64592[(4)])));

return statearr_64601;
})();
var state_64592__$1 = (function (){var statearr_64602 = state_64592;
(statearr_64602[(7)] = inst_64587);

return statearr_64602;
})();
var statearr_64603_64616 = state_64592__$1;
(statearr_64603_64616[(2)] = inst_64577);

(statearr_64603_64616[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11410__auto____0 = (function (){
var statearr_64604 = [null,null,null,null,null,null,null,null];
(statearr_64604[(0)] = fluree$db$dbfunctions$fns$state_machine__11410__auto__);

(statearr_64604[(1)] = (1));

return statearr_64604;
});
var fluree$db$dbfunctions$fns$state_machine__11410__auto____1 = (function (state_64592){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_64592);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e64605){var ex__11413__auto__ = e64605;
var statearr_64606_64617 = state_64592;
(statearr_64606_64617[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_64592[(4)]))){
var statearr_64607_64618 = state_64592;
(statearr_64607_64618[(1)] = cljs.core.first((state_64592[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64619 = state_64592;
state_64592 = G__64619;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11410__auto__ = function(state_64592){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____1.call(this,state_64592);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_64608 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_64608[(6)] = c__11484__auto__);

return statearr_64608;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq64565){
var G__64566 = cljs.core.first(seq64565);
var seq64565__$1 = cljs.core.next(seq64565);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__64566,seq64565__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_64645){
var state_val_64646 = (state_64645[(1)]);
if((state_val_64646 === (1))){
var state_64645__$1 = state_64645;
var statearr_64647_64662 = state_64645__$1;
(statearr_64647_64662[(2)] = null);

(statearr_64647_64662[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64646 === (2))){
var _ = (function (){var statearr_64648 = state_64645;
(statearr_64648[(4)] = cljs.core.cons((5),(state_64645[(4)])));

return statearr_64648;
})();
var inst_64626 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_64645__$1 = state_64645;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64645__$1,(6),inst_64626);
} else {
if((state_val_64646 === (3))){
var inst_64643 = (state_64645[(2)]);
var state_64645__$1 = state_64645;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64645__$1,inst_64643);
} else {
if((state_val_64646 === (4))){
var inst_64620 = (state_64645[(2)]);
var state_64645__$1 = state_64645;
var statearr_64650_64663 = state_64645__$1;
(statearr_64650_64663[(2)] = inst_64620);

(statearr_64650_64663[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64646 === (5))){
var _ = (function (){var statearr_64651 = state_64645;
(statearr_64651[(4)] = cljs.core.rest((state_64645[(4)])));

return statearr_64651;
})();
var state_64645__$1 = state_64645;
var ex64649 = (state_64645__$1[(2)]);
var statearr_64652_64664 = state_64645__$1;
(statearr_64652_64664[(5)] = ex64649);


if((ex64649 instanceof Error)){
var statearr_64653_64665 = state_64645__$1;
(statearr_64653_64665[(1)] = (4));

(statearr_64653_64665[(5)] = null);

} else {
throw ex64649;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64646 === (6))){
var inst_64628 = (state_64645[(2)]);
var inst_64629 = fluree.db.util.async.throw_err(inst_64628);
var inst_64630 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.subs,inst_64629);
var inst_64631 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64632 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64633 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64634 = [inst_64629];
var inst_64635 = (new cljs.core.PersistentVector(null,1,(5),inst_64633,inst_64634,null));
var inst_64636 = ["subs",inst_64635,inst_64630];
var inst_64637 = cljs.core.PersistentHashMap.fromArrays(inst_64632,inst_64636);
var inst_64638 = [inst_64637,(30)];
var inst_64639 = (new cljs.core.PersistentVector(null,2,(5),inst_64631,inst_64638,null));
var inst_64640 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64639);
var _ = (function (){var statearr_64654 = state_64645;
(statearr_64654[(4)] = cljs.core.rest((state_64645[(4)])));

return statearr_64654;
})();
var state_64645__$1 = (function (){var statearr_64655 = state_64645;
(statearr_64655[(7)] = inst_64640);

return statearr_64655;
})();
var statearr_64656_64666 = state_64645__$1;
(statearr_64656_64666[(2)] = inst_64630);

(statearr_64656_64666[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__11410__auto____0 = (function (){
var statearr_64657 = [null,null,null,null,null,null,null,null];
(statearr_64657[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__11410__auto__);

(statearr_64657[(1)] = (1));

return statearr_64657;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__11410__auto____1 = (function (state_64645){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_64645);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e64658){var ex__11413__auto__ = e64658;
var statearr_64659_64667 = state_64645;
(statearr_64659_64667[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_64645[(4)]))){
var statearr_64660_64668 = state_64645;
(statearr_64660_64668[(1)] = cljs.core.first((state_64645[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64669 = state_64645;
state_64645 = G__64669;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__11410__auto__ = function(state_64645){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__11410__auto____1.call(this,state_64645);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_64661 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_64661[(6)] = c__11484__auto__);

return statearr_64661;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_64699){
var state_val_64700 = (state_64699[(1)]);
if((state_val_64700 === (7))){
var state_64699__$1 = state_64699;
var statearr_64701_64720 = state_64699__$1;
(statearr_64701_64720[(2)] = str);

(statearr_64701_64720[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64700 === (1))){
var state_64699__$1 = state_64699;
var statearr_64702_64721 = state_64699__$1;
(statearr_64702_64721[(2)] = null);

(statearr_64702_64721[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64700 === (4))){
var inst_64670 = (state_64699[(2)]);
var state_64699__$1 = state_64699;
var statearr_64703_64722 = state_64699__$1;
(statearr_64703_64722[(2)] = inst_64670);

(statearr_64703_64722[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64700 === (6))){
var state_64699__$1 = state_64699;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64699__$1,(9),str);
} else {
if((state_val_64700 === (3))){
var inst_64697 = (state_64699[(2)]);
var state_64699__$1 = state_64699;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64699__$1,inst_64697);
} else {
if((state_val_64700 === (2))){
var _ = (function (){var statearr_64705 = state_64699;
(statearr_64705[(4)] = cljs.core.cons((5),(state_64699[(4)])));

return statearr_64705;
})();
var inst_64676 = fluree.db.util.async.channel_QMARK_(str);
var state_64699__$1 = state_64699;
if(inst_64676){
var statearr_64706_64723 = state_64699__$1;
(statearr_64706_64723[(1)] = (6));

} else {
var statearr_64707_64724 = state_64699__$1;
(statearr_64707_64724[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64700 === (9))){
var inst_64679 = (state_64699[(2)]);
var inst_64680 = fluree.db.util.async.throw_err(inst_64679);
var state_64699__$1 = state_64699;
var statearr_64708_64725 = state_64699__$1;
(statearr_64708_64725[(2)] = inst_64680);

(statearr_64708_64725[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64700 === (5))){
var _ = (function (){var statearr_64709 = state_64699;
(statearr_64709[(4)] = cljs.core.rest((state_64699[(4)])));

return statearr_64709;
})();
var state_64699__$1 = state_64699;
var ex64704 = (state_64699__$1[(2)]);
var statearr_64710_64726 = state_64699__$1;
(statearr_64710_64726[(5)] = ex64704);


if((ex64704 instanceof Error)){
var statearr_64711_64727 = state_64699__$1;
(statearr_64711_64727[(1)] = (4));

(statearr_64711_64727[(5)] = null);

} else {
throw ex64704;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64700 === (8))){
var inst_64683 = (state_64699[(2)]);
var inst_64684 = fluree.db.dbfunctions.internal.lower_case(inst_64683);
var inst_64685 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64686 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64687 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64688 = [inst_64683];
var inst_64689 = (new cljs.core.PersistentVector(null,1,(5),inst_64687,inst_64688,null));
var inst_64690 = ["lower-case",inst_64689,inst_64684];
var inst_64691 = cljs.core.PersistentHashMap.fromArrays(inst_64686,inst_64690);
var inst_64692 = [inst_64691,(10)];
var inst_64693 = (new cljs.core.PersistentVector(null,2,(5),inst_64685,inst_64692,null));
var inst_64694 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64693);
var _ = (function (){var statearr_64712 = state_64699;
(statearr_64712[(4)] = cljs.core.rest((state_64699[(4)])));

return statearr_64712;
})();
var state_64699__$1 = (function (){var statearr_64713 = state_64699;
(statearr_64713[(7)] = inst_64694);

return statearr_64713;
})();
var statearr_64714_64728 = state_64699__$1;
(statearr_64714_64728[(2)] = inst_64684);

(statearr_64714_64728[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__11410__auto____0 = (function (){
var statearr_64715 = [null,null,null,null,null,null,null,null];
(statearr_64715[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__11410__auto__);

(statearr_64715[(1)] = (1));

return statearr_64715;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__11410__auto____1 = (function (state_64699){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_64699);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e64716){var ex__11413__auto__ = e64716;
var statearr_64717_64729 = state_64699;
(statearr_64717_64729[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_64699[(4)]))){
var statearr_64718_64730 = state_64699;
(statearr_64718_64730[(1)] = cljs.core.first((state_64699[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64731 = state_64699;
state_64699 = G__64731;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__11410__auto__ = function(state_64699){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__11410__auto____1.call(this,state_64699);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_64719 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_64719[(6)] = c__11484__auto__);

return statearr_64719;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_64761){
var state_val_64762 = (state_64761[(1)]);
if((state_val_64762 === (7))){
var state_64761__$1 = state_64761;
var statearr_64763_64782 = state_64761__$1;
(statearr_64763_64782[(2)] = str);

(statearr_64763_64782[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64762 === (1))){
var state_64761__$1 = state_64761;
var statearr_64764_64783 = state_64761__$1;
(statearr_64764_64783[(2)] = null);

(statearr_64764_64783[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64762 === (4))){
var inst_64732 = (state_64761[(2)]);
var state_64761__$1 = state_64761;
var statearr_64765_64784 = state_64761__$1;
(statearr_64765_64784[(2)] = inst_64732);

(statearr_64765_64784[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64762 === (6))){
var state_64761__$1 = state_64761;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64761__$1,(9),str);
} else {
if((state_val_64762 === (3))){
var inst_64759 = (state_64761[(2)]);
var state_64761__$1 = state_64761;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64761__$1,inst_64759);
} else {
if((state_val_64762 === (2))){
var _ = (function (){var statearr_64767 = state_64761;
(statearr_64767[(4)] = cljs.core.cons((5),(state_64761[(4)])));

return statearr_64767;
})();
var inst_64738 = fluree.db.util.async.channel_QMARK_(str);
var state_64761__$1 = state_64761;
if(inst_64738){
var statearr_64768_64785 = state_64761__$1;
(statearr_64768_64785[(1)] = (6));

} else {
var statearr_64769_64786 = state_64761__$1;
(statearr_64769_64786[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64762 === (9))){
var inst_64741 = (state_64761[(2)]);
var inst_64742 = fluree.db.util.async.throw_err(inst_64741);
var state_64761__$1 = state_64761;
var statearr_64770_64787 = state_64761__$1;
(statearr_64770_64787[(2)] = inst_64742);

(statearr_64770_64787[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64762 === (5))){
var _ = (function (){var statearr_64771 = state_64761;
(statearr_64771[(4)] = cljs.core.rest((state_64761[(4)])));

return statearr_64771;
})();
var state_64761__$1 = state_64761;
var ex64766 = (state_64761__$1[(2)]);
var statearr_64772_64788 = state_64761__$1;
(statearr_64772_64788[(5)] = ex64766);


if((ex64766 instanceof Error)){
var statearr_64773_64789 = state_64761__$1;
(statearr_64773_64789[(1)] = (4));

(statearr_64773_64789[(5)] = null);

} else {
throw ex64766;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64762 === (8))){
var inst_64745 = (state_64761[(2)]);
var inst_64746 = fluree.db.dbfunctions.internal.upper_case(inst_64745);
var inst_64747 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64748 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64749 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64750 = [inst_64745];
var inst_64751 = (new cljs.core.PersistentVector(null,1,(5),inst_64749,inst_64750,null));
var inst_64752 = ["upper-case",inst_64751,inst_64746];
var inst_64753 = cljs.core.PersistentHashMap.fromArrays(inst_64748,inst_64752);
var inst_64754 = [inst_64753,(10)];
var inst_64755 = (new cljs.core.PersistentVector(null,2,(5),inst_64747,inst_64754,null));
var inst_64756 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64755);
var _ = (function (){var statearr_64774 = state_64761;
(statearr_64774[(4)] = cljs.core.rest((state_64761[(4)])));

return statearr_64774;
})();
var state_64761__$1 = (function (){var statearr_64775 = state_64761;
(statearr_64775[(7)] = inst_64756);

return statearr_64775;
})();
var statearr_64776_64790 = state_64761__$1;
(statearr_64776_64790[(2)] = inst_64746);

(statearr_64776_64790[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__11410__auto____0 = (function (){
var statearr_64777 = [null,null,null,null,null,null,null,null];
(statearr_64777[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__11410__auto__);

(statearr_64777[(1)] = (1));

return statearr_64777;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__11410__auto____1 = (function (state_64761){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_64761);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e64778){var ex__11413__auto__ = e64778;
var statearr_64779_64791 = state_64761;
(statearr_64779_64791[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_64761[(4)]))){
var statearr_64780_64792 = state_64761;
(statearr_64780_64792[(1)] = cljs.core.first((state_64761[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64793 = state_64761;
state_64761 = G__64793;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__11410__auto__ = function(state_64761){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__11410__auto____1.call(this,state_64761);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_64781 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_64781[(6)] = c__11484__auto__);

return statearr_64781;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4251__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__4251__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__64795 = arguments.length;
switch (G__64795) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_64823){
var state_val_64824 = (state_64823[(1)]);
if((state_val_64824 === (1))){
var state_64823__$1 = state_64823;
var statearr_64825_64841 = state_64823__$1;
(statearr_64825_64841[(2)] = null);

(statearr_64825_64841[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64824 === (2))){
var _ = (function (){var statearr_64826 = state_64823;
(statearr_64826[(4)] = cljs.core.cons((5),(state_64823[(4)])));

return statearr_64826;
})();
var inst_64805 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_64823__$1 = state_64823;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64823__$1,(6),inst_64805);
} else {
if((state_val_64824 === (3))){
var inst_64821 = (state_64823[(2)]);
var state_64823__$1 = state_64823;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64823__$1,inst_64821);
} else {
if((state_val_64824 === (4))){
var inst_64796 = (state_64823[(2)]);
var state_64823__$1 = state_64823;
var statearr_64828_64842 = state_64823__$1;
(statearr_64828_64842[(2)] = inst_64796);

(statearr_64828_64842[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64824 === (5))){
var _ = (function (){var statearr_64829 = state_64823;
(statearr_64829[(4)] = cljs.core.rest((state_64823[(4)])));

return statearr_64829;
})();
var state_64823__$1 = state_64823;
var ex64827 = (state_64823__$1[(2)]);
var statearr_64830_64843 = state_64823__$1;
(statearr_64830_64843[(5)] = ex64827);


if((ex64827 instanceof Error)){
var statearr_64831_64844 = state_64823__$1;
(statearr_64831_64844[(1)] = (4));

(statearr_64831_64844[(5)] = null);

} else {
throw ex64827;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64824 === (6))){
var inst_64807 = (state_64823[(2)]);
var inst_64808 = fluree.db.util.async.throw_err(inst_64807);
var inst_64809 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64808,(0),null);
var inst_64810 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64808,(1),null);
var inst_64811 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64812 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64813 = ["?s","?ctx",inst_64809];
var inst_64814 = cljs.core.PersistentHashMap.fromArrays(inst_64812,inst_64813);
var inst_64815 = ((10) + inst_64810);
var inst_64816 = [inst_64814,inst_64815];
var inst_64817 = (new cljs.core.PersistentVector(null,2,(5),inst_64811,inst_64816,null));
var inst_64818 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64817);
var _ = (function (){var statearr_64832 = state_64823;
(statearr_64832[(4)] = cljs.core.rest((state_64823[(4)])));

return statearr_64832;
})();
var state_64823__$1 = (function (){var statearr_64833 = state_64823;
(statearr_64833[(7)] = inst_64818);

return statearr_64833;
})();
var statearr_64834_64845 = state_64823__$1;
(statearr_64834_64845[(2)] = inst_64809);

(statearr_64834_64845[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11410__auto____0 = (function (){
var statearr_64835 = [null,null,null,null,null,null,null,null];
(statearr_64835[(0)] = fluree$db$dbfunctions$fns$state_machine__11410__auto__);

(statearr_64835[(1)] = (1));

return statearr_64835;
});
var fluree$db$dbfunctions$fns$state_machine__11410__auto____1 = (function (state_64823){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_64823);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e64836){var ex__11413__auto__ = e64836;
var statearr_64837_64846 = state_64823;
(statearr_64837_64846[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_64823[(4)]))){
var statearr_64838_64847 = state_64823;
(statearr_64838_64847[(1)] = cljs.core.first((state_64823[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64848 = state_64823;
state_64823 = G__64848;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11410__auto__ = function(state_64823){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____1.call(this,state_64823);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_64839 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_64839[(6)] = c__11484__auto__);

return statearr_64839;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__64850 = arguments.length;
switch (G__64850) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_64888){
var state_val_64889 = (state_64888[(1)]);
if((state_val_64889 === (7))){
var inst_64881 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_64888__$1 = state_64888;
var statearr_64890_64910 = state_64888__$1;
(statearr_64890_64910[(2)] = inst_64881);

(statearr_64890_64910[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64889 === (1))){
var state_64888__$1 = state_64888;
var statearr_64891_64911 = state_64888__$1;
(statearr_64891_64911[(2)] = null);

(statearr_64891_64911[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64889 === (4))){
var inst_64851 = (state_64888[(2)]);
var state_64888__$1 = state_64888;
var statearr_64892_64912 = state_64888__$1;
(statearr_64892_64912[(2)] = inst_64851);

(statearr_64892_64912[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64889 === (6))){
var inst_64862 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_64888__$1 = state_64888;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64888__$1,(10),inst_64862);
} else {
if((state_val_64889 === (3))){
var inst_64886 = (state_64888[(2)]);
var state_64888__$1 = state_64888;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64888__$1,inst_64886);
} else {
if((state_val_64889 === (2))){
var _ = (function (){var statearr_64894 = state_64888;
(statearr_64894[(4)] = cljs.core.cons((5),(state_64888[(4)])));

return statearr_64894;
})();
var inst_64857 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_64888__$1 = state_64888;
if(cljs.core.truth_(inst_64857)){
var statearr_64895_64913 = state_64888__$1;
(statearr_64895_64913[(1)] = (6));

} else {
var statearr_64896_64914 = state_64888__$1;
(statearr_64896_64914[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64889 === (9))){
var inst_64868 = (state_64888[(2)]);
var inst_64869 = fluree.db.util.async.throw_err(inst_64868);
var inst_64870 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64869,(0),null);
var inst_64871 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64869,(1),null);
var inst_64872 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64873 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64874 = ["?p","?ctx",inst_64870];
var inst_64875 = cljs.core.PersistentHashMap.fromArrays(inst_64873,inst_64874);
var inst_64876 = ((10) + inst_64871);
var inst_64877 = [inst_64875,inst_64876];
var inst_64878 = (new cljs.core.PersistentVector(null,2,(5),inst_64872,inst_64877,null));
var inst_64879 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64878);
var state_64888__$1 = (function (){var statearr_64897 = state_64888;
(statearr_64897[(7)] = inst_64879);

return statearr_64897;
})();
var statearr_64898_64915 = state_64888__$1;
(statearr_64898_64915[(2)] = inst_64870);

(statearr_64898_64915[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64889 === (5))){
var _ = (function (){var statearr_64899 = state_64888;
(statearr_64899[(4)] = cljs.core.rest((state_64888[(4)])));

return statearr_64899;
})();
var state_64888__$1 = state_64888;
var ex64893 = (state_64888__$1[(2)]);
var statearr_64900_64916 = state_64888__$1;
(statearr_64900_64916[(5)] = ex64893);


if((ex64893 instanceof Error)){
var statearr_64901_64917 = state_64888__$1;
(statearr_64901_64917[(1)] = (4));

(statearr_64901_64917[(5)] = null);

} else {
throw ex64893;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64889 === (10))){
var inst_64864 = (state_64888[(2)]);
var inst_64865 = fluree.db.util.async.throw_err(inst_64864);
var inst_64866 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_64865);
var state_64888__$1 = state_64888;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64888__$1,(9),inst_64866);
} else {
if((state_val_64889 === (8))){
var inst_64883 = (state_64888[(2)]);
var _ = (function (){var statearr_64902 = state_64888;
(statearr_64902[(4)] = cljs.core.rest((state_64888[(4)])));

return statearr_64902;
})();
var state_64888__$1 = state_64888;
var statearr_64903_64918 = state_64888__$1;
(statearr_64903_64918[(2)] = inst_64883);

(statearr_64903_64918[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11410__auto____0 = (function (){
var statearr_64904 = [null,null,null,null,null,null,null,null];
(statearr_64904[(0)] = fluree$db$dbfunctions$fns$state_machine__11410__auto__);

(statearr_64904[(1)] = (1));

return statearr_64904;
});
var fluree$db$dbfunctions$fns$state_machine__11410__auto____1 = (function (state_64888){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_64888);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e64905){var ex__11413__auto__ = e64905;
var statearr_64906_64919 = state_64888;
(statearr_64906_64919[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_64888[(4)]))){
var statearr_64907_64920 = state_64888;
(statearr_64907_64920[(1)] = cljs.core.first((state_64888[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64921 = state_64888;
state_64888 = G__64921;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11410__auto__ = function(state_64888){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____1.call(this,state_64888);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_64908 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_64908[(6)] = c__11484__auto__);

return statearr_64908;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4870__auto__ = [];
var len__4864__auto___64970 = arguments.length;
var i__4865__auto___64971 = (0);
while(true){
if((i__4865__auto___64971 < len__4864__auto___64970)){
args__4870__auto__.push((arguments[i__4865__auto___64971]));

var G__64972 = (i__4865__auto___64971 + (1));
i__4865__auto___64971 = G__64972;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_64953){
var state_val_64954 = (state_64953[(1)]);
if((state_val_64954 === (1))){
var state_64953__$1 = state_64953;
var statearr_64955_64973 = state_64953__$1;
(statearr_64955_64973[(2)] = null);

(statearr_64955_64973[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64954 === (2))){
var _ = (function (){var statearr_64956 = state_64953;
(statearr_64956[(4)] = cljs.core.cons((5),(state_64953[(4)])));

return statearr_64956;
})();
var inst_64930 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_64953__$1 = state_64953;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64953__$1,(6),inst_64930);
} else {
if((state_val_64954 === (3))){
var inst_64951 = (state_64953[(2)]);
var state_64953__$1 = state_64953;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64953__$1,inst_64951);
} else {
if((state_val_64954 === (4))){
var inst_64924 = (state_64953[(2)]);
var state_64953__$1 = state_64953;
var statearr_64958_64974 = state_64953__$1;
(statearr_64958_64974[(2)] = inst_64924);

(statearr_64958_64974[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64954 === (5))){
var _ = (function (){var statearr_64959 = state_64953;
(statearr_64959[(4)] = cljs.core.rest((state_64953[(4)])));

return statearr_64959;
})();
var state_64953__$1 = state_64953;
var ex64957 = (state_64953__$1[(2)]);
var statearr_64960_64975 = state_64953__$1;
(statearr_64960_64975[(5)] = ex64957);


if((ex64957 instanceof Error)){
var statearr_64961_64976 = state_64953__$1;
(statearr_64961_64976[(1)] = (4));

(statearr_64961_64976[(5)] = null);

} else {
throw ex64957;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64954 === (6))){
var inst_64932 = (state_64953[(2)]);
var inst_64933 = fluree.db.util.async.throw_err(inst_64932);
var inst_64934 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_64933);
var inst_64935 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64936 = [inst_64933];
var inst_64937 = (new cljs.core.PersistentVector(null,1,(5),inst_64935,inst_64936,null));
var inst_64938 = cljs.core.count(inst_64937);
var inst_64939 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64940 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_64941 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64942 = [inst_64933];
var inst_64943 = (new cljs.core.PersistentVector(null,1,(5),inst_64941,inst_64942,null));
var inst_64944 = ["and",inst_64943,inst_64934];
var inst_64945 = cljs.core.PersistentHashMap.fromArrays(inst_64940,inst_64944);
var inst_64946 = [inst_64945,inst_64938];
var inst_64947 = (new cljs.core.PersistentVector(null,2,(5),inst_64939,inst_64946,null));
var inst_64948 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64947);
var _ = (function (){var statearr_64962 = state_64953;
(statearr_64962[(4)] = cljs.core.rest((state_64953[(4)])));

return statearr_64962;
})();
var state_64953__$1 = (function (){var statearr_64963 = state_64953;
(statearr_64963[(7)] = inst_64948);

return statearr_64963;
})();
var statearr_64964_64977 = state_64953__$1;
(statearr_64964_64977[(2)] = inst_64934);

(statearr_64964_64977[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11410__auto____0 = (function (){
var statearr_64965 = [null,null,null,null,null,null,null,null];
(statearr_64965[(0)] = fluree$db$dbfunctions$fns$state_machine__11410__auto__);

(statearr_64965[(1)] = (1));

return statearr_64965;
});
var fluree$db$dbfunctions$fns$state_machine__11410__auto____1 = (function (state_64953){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_64953);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e64966){var ex__11413__auto__ = e64966;
var statearr_64967_64978 = state_64953;
(statearr_64967_64978[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_64953[(4)]))){
var statearr_64968_64979 = state_64953;
(statearr_64968_64979[(1)] = cljs.core.first((state_64953[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64980 = state_64953;
state_64953 = G__64980;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11410__auto__ = function(state_64953){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____1.call(this,state_64953);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_64969 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_64969[(6)] = c__11484__auto__);

return statearr_64969;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq64922){
var G__64923 = cljs.core.first(seq64922);
var seq64922__$1 = cljs.core.next(seq64922);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__64923,seq64922__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4870__auto__ = [];
var len__4864__auto___65029 = arguments.length;
var i__4865__auto___65030 = (0);
while(true){
if((i__4865__auto___65030 < len__4864__auto___65029)){
args__4870__auto__.push((arguments[i__4865__auto___65030]));

var G__65031 = (i__4865__auto___65030 + (1));
i__4865__auto___65030 = G__65031;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_65012){
var state_val_65013 = (state_65012[(1)]);
if((state_val_65013 === (1))){
var state_65012__$1 = state_65012;
var statearr_65014_65032 = state_65012__$1;
(statearr_65014_65032[(2)] = null);

(statearr_65014_65032[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65013 === (2))){
var _ = (function (){var statearr_65015 = state_65012;
(statearr_65015[(4)] = cljs.core.cons((5),(state_65012[(4)])));

return statearr_65015;
})();
var inst_64989 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65012__$1 = state_65012;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65012__$1,(6),inst_64989);
} else {
if((state_val_65013 === (3))){
var inst_65010 = (state_65012[(2)]);
var state_65012__$1 = state_65012;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65012__$1,inst_65010);
} else {
if((state_val_65013 === (4))){
var inst_64983 = (state_65012[(2)]);
var state_65012__$1 = state_65012;
var statearr_65017_65033 = state_65012__$1;
(statearr_65017_65033[(2)] = inst_64983);

(statearr_65017_65033[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65013 === (5))){
var _ = (function (){var statearr_65018 = state_65012;
(statearr_65018[(4)] = cljs.core.rest((state_65012[(4)])));

return statearr_65018;
})();
var state_65012__$1 = state_65012;
var ex65016 = (state_65012__$1[(2)]);
var statearr_65019_65034 = state_65012__$1;
(statearr_65019_65034[(5)] = ex65016);


if((ex65016 instanceof Error)){
var statearr_65020_65035 = state_65012__$1;
(statearr_65020_65035[(1)] = (4));

(statearr_65020_65035[(5)] = null);

} else {
throw ex65016;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65013 === (6))){
var inst_64991 = (state_65012[(2)]);
var inst_64992 = fluree.db.util.async.throw_err(inst_64991);
var inst_64993 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_64992);
var inst_64994 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64995 = [inst_64992];
var inst_64996 = (new cljs.core.PersistentVector(null,1,(5),inst_64994,inst_64995,null));
var inst_64997 = cljs.core.count(inst_64996);
var inst_64998 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64999 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65000 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65001 = [inst_64992];
var inst_65002 = (new cljs.core.PersistentVector(null,1,(5),inst_65000,inst_65001,null));
var inst_65003 = ["or",inst_65002,inst_64993];
var inst_65004 = cljs.core.PersistentHashMap.fromArrays(inst_64999,inst_65003);
var inst_65005 = [inst_65004,inst_64997];
var inst_65006 = (new cljs.core.PersistentVector(null,2,(5),inst_64998,inst_65005,null));
var inst_65007 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65006);
var _ = (function (){var statearr_65021 = state_65012;
(statearr_65021[(4)] = cljs.core.rest((state_65012[(4)])));

return statearr_65021;
})();
var state_65012__$1 = (function (){var statearr_65022 = state_65012;
(statearr_65022[(7)] = inst_65007);

return statearr_65022;
})();
var statearr_65023_65036 = state_65012__$1;
(statearr_65023_65036[(2)] = inst_64993);

(statearr_65023_65036[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11410__auto____0 = (function (){
var statearr_65024 = [null,null,null,null,null,null,null,null];
(statearr_65024[(0)] = fluree$db$dbfunctions$fns$state_machine__11410__auto__);

(statearr_65024[(1)] = (1));

return statearr_65024;
});
var fluree$db$dbfunctions$fns$state_machine__11410__auto____1 = (function (state_65012){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_65012);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e65025){var ex__11413__auto__ = e65025;
var statearr_65026_65037 = state_65012;
(statearr_65026_65037[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_65012[(4)]))){
var statearr_65027_65038 = state_65012;
(statearr_65027_65038[(1)] = cljs.core.first((state_65012[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65039 = state_65012;
state_65012 = G__65039;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11410__auto__ = function(state_65012){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____1.call(this,state_65012);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_65028 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_65028[(6)] = c__11484__auto__);

return statearr_65028;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq64981){
var G__64982 = cljs.core.first(seq64981);
var seq64981__$1 = cljs.core.next(seq64981);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__64982,seq64981__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_65077){
var state_val_65078 = (state_65077[(1)]);
if((state_val_65078 === (7))){
var inst_65053 = fluree.db.util.async.channel_QMARK_(coll);
var state_65077__$1 = state_65077;
if(inst_65053){
var statearr_65079_65102 = state_65077__$1;
(statearr_65079_65102[(1)] = (10));

} else {
var statearr_65080_65103 = state_65077__$1;
(statearr_65080_65103[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65078 === (1))){
var state_65077__$1 = state_65077;
var statearr_65081_65104 = state_65077__$1;
(statearr_65081_65104[(2)] = null);

(statearr_65081_65104[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65078 === (4))){
var inst_65040 = (state_65077[(2)]);
var state_65077__$1 = state_65077;
var statearr_65082_65105 = state_65077__$1;
(statearr_65082_65105[(2)] = inst_65040);

(statearr_65082_65105[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65078 === (13))){
var inst_65056 = (state_65077[(2)]);
var inst_65057 = fluree.db.util.async.throw_err(inst_65056);
var state_65077__$1 = state_65077;
var statearr_65083_65106 = state_65077__$1;
(statearr_65083_65106[(2)] = inst_65057);

(statearr_65083_65106[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65078 === (6))){
var inst_65048 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_65077__$1 = state_65077;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65077__$1,(9),inst_65048);
} else {
if((state_val_65078 === (3))){
var inst_65075 = (state_65077[(2)]);
var state_65077__$1 = state_65077;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65077__$1,inst_65075);
} else {
if((state_val_65078 === (12))){
var inst_65060 = (state_65077[(2)]);
var state_65077__$1 = state_65077;
var statearr_65084_65107 = state_65077__$1;
(statearr_65084_65107[(2)] = inst_65060);

(statearr_65084_65107[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65078 === (2))){
var _ = (function (){var statearr_65085 = state_65077;
(statearr_65085[(4)] = cljs.core.cons((5),(state_65077[(4)])));

return statearr_65085;
})();
var inst_65046 = cljs.core.vector_QMARK_(coll);
var state_65077__$1 = state_65077;
if(inst_65046){
var statearr_65086_65108 = state_65077__$1;
(statearr_65086_65108[(1)] = (6));

} else {
var statearr_65087_65109 = state_65077__$1;
(statearr_65087_65109[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65078 === (11))){
var state_65077__$1 = state_65077;
var statearr_65089_65110 = state_65077__$1;
(statearr_65089_65110[(2)] = coll);

(statearr_65089_65110[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65078 === (9))){
var inst_65050 = (state_65077[(2)]);
var inst_65051 = fluree.db.util.async.throw_err(inst_65050);
var state_65077__$1 = state_65077;
var statearr_65090_65111 = state_65077__$1;
(statearr_65090_65111[(2)] = inst_65051);

(statearr_65090_65111[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65078 === (5))){
var _ = (function (){var statearr_65091 = state_65077;
(statearr_65091[(4)] = cljs.core.rest((state_65077[(4)])));

return statearr_65091;
})();
var state_65077__$1 = state_65077;
var ex65088 = (state_65077__$1[(2)]);
var statearr_65092_65112 = state_65077__$1;
(statearr_65092_65112[(5)] = ex65088);


if((ex65088 instanceof Error)){
var statearr_65093_65113 = state_65077__$1;
(statearr_65093_65113[(1)] = (4));

(statearr_65093_65113[(5)] = null);

} else {
throw ex65088;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65078 === (10))){
var state_65077__$1 = state_65077;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65077__$1,(13),coll);
} else {
if((state_val_65078 === (8))){
var inst_65062 = (state_65077[(2)]);
var inst_65063 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_65062);
var inst_65064 = cljs.core.count(inst_65063);
var inst_65065 = ((9) + inst_65064);
var inst_65066 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65067 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65068 = ["count",inst_65062,inst_65064];
var inst_65069 = cljs.core.PersistentHashMap.fromArrays(inst_65067,inst_65068);
var inst_65070 = [inst_65069,inst_65065];
var inst_65071 = (new cljs.core.PersistentVector(null,2,(5),inst_65066,inst_65070,null));
var inst_65072 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65071);
var _ = (function (){var statearr_65094 = state_65077;
(statearr_65094[(4)] = cljs.core.rest((state_65077[(4)])));

return statearr_65094;
})();
var state_65077__$1 = (function (){var statearr_65095 = state_65077;
(statearr_65095[(7)] = inst_65072);

return statearr_65095;
})();
var statearr_65096_65114 = state_65077__$1;
(statearr_65096_65114[(2)] = inst_65064);

(statearr_65096_65114[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__11410__auto____0 = (function (){
var statearr_65097 = [null,null,null,null,null,null,null,null];
(statearr_65097[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__11410__auto__);

(statearr_65097[(1)] = (1));

return statearr_65097;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__11410__auto____1 = (function (state_65077){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_65077);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e65098){var ex__11413__auto__ = e65098;
var statearr_65099_65115 = state_65077;
(statearr_65099_65115[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_65077[(4)]))){
var statearr_65100_65116 = state_65077;
(statearr_65100_65116[(1)] = cljs.core.first((state_65077[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65117 = state_65077;
state_65077 = G__65117;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__11410__auto__ = function(state_65077){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__11410__auto____1.call(this,state_65077);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_65101 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_65101[(6)] = c__11484__auto__);

return statearr_65101;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_65167){
var state_val_65168 = (state_65167[(1)]);
if((state_val_65168 === (7))){
var state_65167__$1 = state_65167;
var statearr_65169_65202 = state_65167__$1;
(statearr_65169_65202[(2)] = subject);

(statearr_65169_65202[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65168 === (1))){
var state_65167__$1 = state_65167;
var statearr_65170_65203 = state_65167__$1;
(statearr_65170_65203[(2)] = null);

(statearr_65170_65203[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65168 === (4))){
var inst_65118 = (state_65167[(2)]);
var state_65167__$1 = state_65167;
var statearr_65171_65204 = state_65167__$1;
(statearr_65171_65204[(2)] = inst_65118);

(statearr_65171_65204[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65168 === (15))){
var inst_65131 = (state_65167[(7)]);
var state_65167__$1 = state_65167;
var statearr_65172_65205 = state_65167__$1;
(statearr_65172_65205[(2)] = inst_65131);

(statearr_65172_65205[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65168 === (13))){
var inst_65135 = (state_65167[(2)]);
var inst_65136 = fluree.db.util.async.throw_err(inst_65135);
var state_65167__$1 = state_65167;
var statearr_65173_65206 = state_65167__$1;
(statearr_65173_65206[(2)] = inst_65136);

(statearr_65173_65206[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65168 === (6))){
var state_65167__$1 = state_65167;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65167__$1,(9),subject);
} else {
if((state_val_65168 === (17))){
var inst_65131 = (state_65167[(7)]);
var inst_65145 = cljs.core.first(inst_65131);
var state_65167__$1 = state_65167;
var statearr_65174_65207 = state_65167__$1;
(statearr_65174_65207[(2)] = inst_65145);

(statearr_65174_65207[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65168 === (3))){
var inst_65165 = (state_65167[(2)]);
var state_65167__$1 = state_65167;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65167__$1,inst_65165);
} else {
if((state_val_65168 === (12))){
var inst_65131 = (state_65167[(7)]);
var inst_65139 = (state_65167[(2)]);
var inst_65140 = cljs.core.vector_QMARK_(inst_65131);
var state_65167__$1 = (function (){var statearr_65175 = state_65167;
(statearr_65175[(8)] = inst_65139);

return statearr_65175;
})();
if(inst_65140){
var statearr_65176_65208 = state_65167__$1;
(statearr_65176_65208[(1)] = (14));

} else {
var statearr_65177_65209 = state_65167__$1;
(statearr_65177_65209[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65168 === (2))){
var _ = (function (){var statearr_65178 = state_65167;
(statearr_65178[(4)] = cljs.core.cons((5),(state_65167[(4)])));

return statearr_65178;
})();
var inst_65124 = fluree.db.util.async.channel_QMARK_(subject);
var state_65167__$1 = state_65167;
if(inst_65124){
var statearr_65179_65210 = state_65167__$1;
(statearr_65179_65210[(1)] = (6));

} else {
var statearr_65180_65211 = state_65167__$1;
(statearr_65180_65211[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65168 === (19))){
var inst_65148 = (state_65167[(2)]);
var state_65167__$1 = state_65167;
var statearr_65181_65212 = state_65167__$1;
(statearr_65181_65212[(2)] = inst_65148);

(statearr_65181_65212[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65168 === (11))){
var state_65167__$1 = state_65167;
var statearr_65183_65213 = state_65167__$1;
(statearr_65183_65213[(2)] = pred);

(statearr_65183_65213[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65168 === (9))){
var inst_65127 = (state_65167[(2)]);
var inst_65128 = fluree.db.util.async.throw_err(inst_65127);
var state_65167__$1 = state_65167;
var statearr_65184_65214 = state_65167__$1;
(statearr_65184_65214[(2)] = inst_65128);

(statearr_65184_65214[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65168 === (5))){
var _ = (function (){var statearr_65185 = state_65167;
(statearr_65185[(4)] = cljs.core.rest((state_65167[(4)])));

return statearr_65185;
})();
var state_65167__$1 = state_65167;
var ex65182 = (state_65167__$1[(2)]);
var statearr_65186_65215 = state_65167__$1;
(statearr_65186_65215[(5)] = ex65182);


if((ex65182 instanceof Error)){
var statearr_65187_65216 = state_65167__$1;
(statearr_65187_65216[(1)] = (4));

(statearr_65187_65216[(5)] = null);

} else {
throw ex65182;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65168 === (14))){
var inst_65131 = (state_65167[(7)]);
var inst_65142 = cljs.core.count(inst_65131);
var inst_65143 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_65142);
var state_65167__$1 = state_65167;
if(inst_65143){
var statearr_65188_65217 = state_65167__$1;
(statearr_65188_65217[(1)] = (17));

} else {
var statearr_65189_65218 = state_65167__$1;
(statearr_65189_65218[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65168 === (16))){
var inst_65131 = (state_65167[(7)]);
var inst_65139 = (state_65167[(8)]);
var inst_65151 = (state_65167[(2)]);
var inst_65152 = fluree.db.dbfunctions.internal.get(inst_65151,inst_65139);
var inst_65153 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65154 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65155 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65156 = [inst_65131,inst_65139];
var inst_65157 = (new cljs.core.PersistentVector(null,2,(5),inst_65155,inst_65156,null));
var inst_65158 = ["get",inst_65157,inst_65152];
var inst_65159 = cljs.core.PersistentHashMap.fromArrays(inst_65154,inst_65158);
var inst_65160 = [inst_65159,(10)];
var inst_65161 = (new cljs.core.PersistentVector(null,2,(5),inst_65153,inst_65160,null));
var inst_65162 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65161);
var _ = (function (){var statearr_65190 = state_65167;
(statearr_65190[(4)] = cljs.core.rest((state_65167[(4)])));

return statearr_65190;
})();
var state_65167__$1 = (function (){var statearr_65191 = state_65167;
(statearr_65191[(9)] = inst_65162);

return statearr_65191;
})();
var statearr_65192_65219 = state_65167__$1;
(statearr_65192_65219[(2)] = inst_65152);

(statearr_65192_65219[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65168 === (10))){
var state_65167__$1 = state_65167;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65167__$1,(13),pred);
} else {
if((state_val_65168 === (18))){
var inst_65131 = (state_65167[(7)]);
var state_65167__$1 = state_65167;
var statearr_65193_65220 = state_65167__$1;
(statearr_65193_65220[(2)] = inst_65131);

(statearr_65193_65220[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65168 === (8))){
var inst_65131 = (state_65167[(2)]);
var inst_65132 = fluree.db.util.async.channel_QMARK_(pred);
var state_65167__$1 = (function (){var statearr_65194 = state_65167;
(statearr_65194[(7)] = inst_65131);

return statearr_65194;
})();
if(inst_65132){
var statearr_65195_65221 = state_65167__$1;
(statearr_65195_65221[(1)] = (10));

} else {
var statearr_65196_65222 = state_65167__$1;
(statearr_65196_65222[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__11410__auto____0 = (function (){
var statearr_65197 = [null,null,null,null,null,null,null,null,null,null];
(statearr_65197[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__11410__auto__);

(statearr_65197[(1)] = (1));

return statearr_65197;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__11410__auto____1 = (function (state_65167){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_65167);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e65198){var ex__11413__auto__ = e65198;
var statearr_65199_65223 = state_65167;
(statearr_65199_65223[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_65167[(4)]))){
var statearr_65200_65224 = state_65167;
(statearr_65200_65224[(1)] = cljs.core.first((state_65167[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65225 = state_65167;
state_65167 = G__65225;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__11410__auto__ = function(state_65167){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__11410__auto____1.call(this,state_65167);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_65201 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_65201[(6)] = c__11484__auto__);

return statearr_65201;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_65264){
var state_val_65265 = (state_65264[(1)]);
if((state_val_65265 === (7))){
var inst_65232 = (state_65264[(7)]);
var state_65264__$1 = state_65264;
var statearr_65266_65290 = state_65264__$1;
(statearr_65266_65290[(2)] = inst_65232);

(statearr_65266_65290[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65265 === (1))){
var state_65264__$1 = state_65264;
var statearr_65267_65291 = state_65264__$1;
(statearr_65267_65291[(2)] = null);

(statearr_65267_65291[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65265 === (4))){
var inst_65226 = (state_65264[(2)]);
var state_65264__$1 = state_65264;
var statearr_65268_65292 = state_65264__$1;
(statearr_65268_65292[(2)] = inst_65226);

(statearr_65268_65292[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65265 === (6))){
var inst_65234 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_65264__$1 = state_65264;
var statearr_65269_65293 = state_65264__$1;
(statearr_65269_65293[(2)] = inst_65234);

(statearr_65269_65293[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65265 === (3))){
var inst_65262 = (state_65264[(2)]);
var state_65264__$1 = state_65264;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65264__$1,inst_65262);
} else {
if((state_val_65265 === (12))){
var inst_65244 = (state_65264[(2)]);
var inst_65245 = fluree.db.util.async.throw_err(inst_65244);
var inst_65246 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65245,(0),null);
var inst_65247 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65245,(1),null);
var inst_65248 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65249 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65250 = ["?pO","?ctx",inst_65246];
var inst_65251 = cljs.core.PersistentHashMap.fromArrays(inst_65249,inst_65250);
var inst_65252 = ((10) + inst_65247);
var inst_65253 = [inst_65251,inst_65252];
var inst_65254 = (new cljs.core.PersistentVector(null,2,(5),inst_65248,inst_65253,null));
var inst_65255 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65254);
var state_65264__$1 = (function (){var statearr_65270 = state_65264;
(statearr_65270[(8)] = inst_65255);

return statearr_65270;
})();
var statearr_65271_65294 = state_65264__$1;
(statearr_65271_65294[(2)] = inst_65246);

(statearr_65271_65294[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65265 === (2))){
var inst_65232 = (state_65264[(7)]);
var _ = (function (){var statearr_65272 = state_65264;
(statearr_65272[(4)] = cljs.core.cons((5),(state_65264[(4)])));

return statearr_65272;
})();
var inst_65232__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_65264__$1 = (function (){var statearr_65273 = state_65264;
(statearr_65273[(7)] = inst_65232__$1);

return statearr_65273;
})();
if(cljs.core.truth_(inst_65232__$1)){
var statearr_65274_65295 = state_65264__$1;
(statearr_65274_65295[(1)] = (6));

} else {
var statearr_65275_65296 = state_65264__$1;
(statearr_65275_65296[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65265 === (11))){
var inst_65259 = (state_65264[(2)]);
var _ = (function (){var statearr_65277 = state_65264;
(statearr_65277[(4)] = cljs.core.rest((state_65264[(4)])));

return statearr_65277;
})();
var state_65264__$1 = state_65264;
var statearr_65278_65297 = state_65264__$1;
(statearr_65278_65297[(2)] = inst_65259);

(statearr_65278_65297[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65265 === (9))){
var inst_65242 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_65264__$1 = state_65264;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65264__$1,(12),inst_65242);
} else {
if((state_val_65265 === (5))){
var _ = (function (){var statearr_65279 = state_65264;
(statearr_65279[(4)] = cljs.core.rest((state_65264[(4)])));

return statearr_65279;
})();
var state_65264__$1 = state_65264;
var ex65276 = (state_65264__$1[(2)]);
var statearr_65280_65298 = state_65264__$1;
(statearr_65280_65298[(5)] = ex65276);


if((ex65276 instanceof Error)){
var statearr_65281_65299 = state_65264__$1;
(statearr_65281_65299[(1)] = (4));

(statearr_65281_65299[(5)] = null);

} else {
throw ex65276;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65265 === (10))){
var inst_65257 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_65264__$1 = state_65264;
var statearr_65282_65300 = state_65264__$1;
(statearr_65282_65300[(2)] = inst_65257);

(statearr_65282_65300[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65265 === (8))){
var inst_65237 = (state_65264[(2)]);
var state_65264__$1 = state_65264;
if(cljs.core.truth_(inst_65237)){
var statearr_65283_65301 = state_65264__$1;
(statearr_65283_65301[(1)] = (9));

} else {
var statearr_65284_65302 = state_65264__$1;
(statearr_65284_65302[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11410__auto____0 = (function (){
var statearr_65285 = [null,null,null,null,null,null,null,null,null];
(statearr_65285[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11410__auto__);

(statearr_65285[(1)] = (1));

return statearr_65285;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11410__auto____1 = (function (state_65264){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_65264);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e65286){var ex__11413__auto__ = e65286;
var statearr_65287_65303 = state_65264;
(statearr_65287_65303[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_65264[(4)]))){
var statearr_65288_65304 = state_65264;
(statearr_65288_65304[(1)] = cljs.core.first((state_65264[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65305 = state_65264;
state_65264 = G__65305;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11410__auto__ = function(state_65264){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11410__auto____1.call(this,state_65264);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_65289 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_65289[(6)] = c__11484__auto__);

return statearr_65289;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_65357){
var state_val_65358 = (state_65357[(1)]);
if((state_val_65358 === (7))){
var state_65357__$1 = state_65357;
var statearr_65359_65392 = state_65357__$1;
(statearr_65359_65392[(2)] = subject);

(statearr_65359_65392[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65358 === (1))){
var state_65357__$1 = state_65357;
var statearr_65360_65393 = state_65357__$1;
(statearr_65360_65393[(2)] = null);

(statearr_65360_65393[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65358 === (4))){
var inst_65306 = (state_65357[(2)]);
var state_65357__$1 = state_65357;
var statearr_65361_65394 = state_65357__$1;
(statearr_65361_65394[(2)] = inst_65306);

(statearr_65361_65394[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65358 === (15))){
var inst_65319 = (state_65357[(7)]);
var state_65357__$1 = state_65357;
var statearr_65362_65395 = state_65357__$1;
(statearr_65362_65395[(2)] = inst_65319);

(statearr_65362_65395[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65358 === (13))){
var inst_65323 = (state_65357[(2)]);
var inst_65324 = fluree.db.util.async.throw_err(inst_65323);
var state_65357__$1 = state_65357;
var statearr_65363_65396 = state_65357__$1;
(statearr_65363_65396[(2)] = inst_65324);

(statearr_65363_65396[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65358 === (6))){
var state_65357__$1 = state_65357;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65357__$1,(9),subject);
} else {
if((state_val_65358 === (17))){
var inst_65319 = (state_65357[(7)]);
var inst_65333 = cljs.core.first(inst_65319);
var state_65357__$1 = state_65357;
var statearr_65364_65397 = state_65357__$1;
(statearr_65364_65397[(2)] = inst_65333);

(statearr_65364_65397[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65358 === (3))){
var inst_65355 = (state_65357[(2)]);
var state_65357__$1 = state_65357;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65357__$1,inst_65355);
} else {
if((state_val_65358 === (12))){
var inst_65319 = (state_65357[(7)]);
var inst_65327 = (state_65357[(2)]);
var inst_65328 = cljs.core.vector_QMARK_(inst_65319);
var state_65357__$1 = (function (){var statearr_65365 = state_65357;
(statearr_65365[(8)] = inst_65327);

return statearr_65365;
})();
if(inst_65328){
var statearr_65366_65398 = state_65357__$1;
(statearr_65366_65398[(1)] = (14));

} else {
var statearr_65367_65399 = state_65357__$1;
(statearr_65367_65399[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65358 === (2))){
var _ = (function (){var statearr_65368 = state_65357;
(statearr_65368[(4)] = cljs.core.cons((5),(state_65357[(4)])));

return statearr_65368;
})();
var inst_65312 = fluree.db.util.async.channel_QMARK_(subject);
var state_65357__$1 = state_65357;
if(inst_65312){
var statearr_65369_65400 = state_65357__$1;
(statearr_65369_65400[(1)] = (6));

} else {
var statearr_65370_65401 = state_65357__$1;
(statearr_65370_65401[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65358 === (19))){
var inst_65336 = (state_65357[(2)]);
var state_65357__$1 = state_65357;
var statearr_65371_65402 = state_65357__$1;
(statearr_65371_65402[(2)] = inst_65336);

(statearr_65371_65402[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65358 === (11))){
var state_65357__$1 = state_65357;
var statearr_65373_65403 = state_65357__$1;
(statearr_65373_65403[(2)] = path);

(statearr_65373_65403[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65358 === (9))){
var inst_65315 = (state_65357[(2)]);
var inst_65316 = fluree.db.util.async.throw_err(inst_65315);
var state_65357__$1 = state_65357;
var statearr_65374_65404 = state_65357__$1;
(statearr_65374_65404[(2)] = inst_65316);

(statearr_65374_65404[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65358 === (5))){
var _ = (function (){var statearr_65375 = state_65357;
(statearr_65375[(4)] = cljs.core.rest((state_65357[(4)])));

return statearr_65375;
})();
var state_65357__$1 = state_65357;
var ex65372 = (state_65357__$1[(2)]);
var statearr_65376_65405 = state_65357__$1;
(statearr_65376_65405[(5)] = ex65372);


if((ex65372 instanceof Error)){
var statearr_65377_65406 = state_65357__$1;
(statearr_65377_65406[(1)] = (4));

(statearr_65377_65406[(5)] = null);

} else {
throw ex65372;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65358 === (14))){
var inst_65319 = (state_65357[(7)]);
var inst_65330 = cljs.core.count(inst_65319);
var inst_65331 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_65330);
var state_65357__$1 = state_65357;
if(inst_65331){
var statearr_65378_65407 = state_65357__$1;
(statearr_65378_65407[(1)] = (17));

} else {
var statearr_65379_65408 = state_65357__$1;
(statearr_65379_65408[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65358 === (16))){
var inst_65327 = (state_65357[(8)]);
var inst_65319 = (state_65357[(7)]);
var inst_65339 = (state_65357[(2)]);
var inst_65340 = fluree.db.dbfunctions.internal.get_all(inst_65339,inst_65327);
var inst_65341 = cljs.core.count(inst_65327);
var inst_65342 = ((9) + inst_65341);
var inst_65343 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65344 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65345 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65346 = [inst_65319,inst_65327];
var inst_65347 = (new cljs.core.PersistentVector(null,2,(5),inst_65345,inst_65346,null));
var inst_65348 = ["get-all",inst_65347,inst_65340];
var inst_65349 = cljs.core.PersistentHashMap.fromArrays(inst_65344,inst_65348);
var inst_65350 = [inst_65349,inst_65342];
var inst_65351 = (new cljs.core.PersistentVector(null,2,(5),inst_65343,inst_65350,null));
var inst_65352 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65351);
var _ = (function (){var statearr_65380 = state_65357;
(statearr_65380[(4)] = cljs.core.rest((state_65357[(4)])));

return statearr_65380;
})();
var state_65357__$1 = (function (){var statearr_65381 = state_65357;
(statearr_65381[(9)] = inst_65352);

return statearr_65381;
})();
var statearr_65382_65409 = state_65357__$1;
(statearr_65382_65409[(2)] = inst_65340);

(statearr_65382_65409[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65358 === (10))){
var state_65357__$1 = state_65357;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65357__$1,(13),path);
} else {
if((state_val_65358 === (18))){
var inst_65319 = (state_65357[(7)]);
var state_65357__$1 = state_65357;
var statearr_65383_65410 = state_65357__$1;
(statearr_65383_65410[(2)] = inst_65319);

(statearr_65383_65410[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65358 === (8))){
var inst_65319 = (state_65357[(2)]);
var inst_65320 = fluree.db.util.async.channel_QMARK_(path);
var state_65357__$1 = (function (){var statearr_65384 = state_65357;
(statearr_65384[(7)] = inst_65319);

return statearr_65384;
})();
if(inst_65320){
var statearr_65385_65411 = state_65357__$1;
(statearr_65385_65411[(1)] = (10));

} else {
var statearr_65386_65412 = state_65357__$1;
(statearr_65386_65412[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__11410__auto____0 = (function (){
var statearr_65387 = [null,null,null,null,null,null,null,null,null,null];
(statearr_65387[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__11410__auto__);

(statearr_65387[(1)] = (1));

return statearr_65387;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__11410__auto____1 = (function (state_65357){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_65357);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e65388){var ex__11413__auto__ = e65388;
var statearr_65389_65413 = state_65357;
(statearr_65389_65413[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_65357[(4)]))){
var statearr_65390_65414 = state_65357;
(statearr_65390_65414[(1)] = cljs.core.first((state_65357[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65415 = state_65357;
state_65357 = G__65415;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__11410__auto__ = function(state_65357){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__11410__auto____1.call(this,state_65357);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_65391 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_65391[(6)] = c__11484__auto__);

return statearr_65391;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Returns the value of a nested structure
 */
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_65454){
var state_val_65455 = (state_65454[(1)]);
if((state_val_65455 === (7))){
var state_65454__$1 = state_65454;
var statearr_65456_65480 = state_65454__$1;
(statearr_65456_65480[(2)] = subject);

(statearr_65456_65480[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65455 === (1))){
var state_65454__$1 = state_65454;
var statearr_65457_65481 = state_65454__$1;
(statearr_65457_65481[(2)] = null);

(statearr_65457_65481[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65455 === (4))){
var inst_65416 = (state_65454[(2)]);
var state_65454__$1 = state_65454;
var statearr_65458_65482 = state_65454__$1;
(statearr_65458_65482[(2)] = inst_65416);

(statearr_65458_65482[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65455 === (13))){
var inst_65433 = (state_65454[(2)]);
var inst_65434 = fluree.db.util.async.throw_err(inst_65433);
var state_65454__$1 = state_65454;
var statearr_65459_65483 = state_65454__$1;
(statearr_65459_65483[(2)] = inst_65434);

(statearr_65459_65483[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65455 === (6))){
var state_65454__$1 = state_65454;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65454__$1,(9),subject);
} else {
if((state_val_65455 === (3))){
var inst_65452 = (state_65454[(2)]);
var state_65454__$1 = state_65454;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65454__$1,inst_65452);
} else {
if((state_val_65455 === (12))){
var inst_65429 = (state_65454[(7)]);
var inst_65437 = (state_65454[(2)]);
var inst_65438 = fluree.db.dbfunctions.internal.get_in(inst_65429,inst_65437);
var inst_65439 = cljs.core.count(inst_65437);
var inst_65440 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65441 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65442 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65443 = [inst_65429,inst_65437];
var inst_65444 = (new cljs.core.PersistentVector(null,2,(5),inst_65442,inst_65443,null));
var inst_65445 = ["get-in",inst_65444,inst_65438];
var inst_65446 = cljs.core.PersistentHashMap.fromArrays(inst_65441,inst_65445);
var inst_65447 = [inst_65446,inst_65439];
var inst_65448 = (new cljs.core.PersistentVector(null,2,(5),inst_65440,inst_65447,null));
var inst_65449 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65448);
var _ = (function (){var statearr_65460 = state_65454;
(statearr_65460[(4)] = cljs.core.rest((state_65454[(4)])));

return statearr_65460;
})();
var state_65454__$1 = (function (){var statearr_65461 = state_65454;
(statearr_65461[(8)] = inst_65449);

return statearr_65461;
})();
var statearr_65462_65484 = state_65454__$1;
(statearr_65462_65484[(2)] = inst_65438);

(statearr_65462_65484[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65455 === (2))){
var _ = (function (){var statearr_65463 = state_65454;
(statearr_65463[(4)] = cljs.core.cons((5),(state_65454[(4)])));

return statearr_65463;
})();
var inst_65422 = fluree.db.util.async.channel_QMARK_(subject);
var state_65454__$1 = state_65454;
if(inst_65422){
var statearr_65464_65485 = state_65454__$1;
(statearr_65464_65485[(1)] = (6));

} else {
var statearr_65465_65486 = state_65454__$1;
(statearr_65465_65486[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65455 === (11))){
var state_65454__$1 = state_65454;
var statearr_65467_65487 = state_65454__$1;
(statearr_65467_65487[(2)] = path);

(statearr_65467_65487[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65455 === (9))){
var inst_65425 = (state_65454[(2)]);
var inst_65426 = fluree.db.util.async.throw_err(inst_65425);
var state_65454__$1 = state_65454;
var statearr_65468_65488 = state_65454__$1;
(statearr_65468_65488[(2)] = inst_65426);

(statearr_65468_65488[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65455 === (5))){
var _ = (function (){var statearr_65469 = state_65454;
(statearr_65469[(4)] = cljs.core.rest((state_65454[(4)])));

return statearr_65469;
})();
var state_65454__$1 = state_65454;
var ex65466 = (state_65454__$1[(2)]);
var statearr_65470_65489 = state_65454__$1;
(statearr_65470_65489[(5)] = ex65466);


if((ex65466 instanceof Error)){
var statearr_65471_65490 = state_65454__$1;
(statearr_65471_65490[(1)] = (4));

(statearr_65471_65490[(5)] = null);

} else {
throw ex65466;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65455 === (10))){
var state_65454__$1 = state_65454;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65454__$1,(13),path);
} else {
if((state_val_65455 === (8))){
var inst_65429 = (state_65454[(2)]);
var inst_65430 = fluree.db.util.async.channel_QMARK_(path);
var state_65454__$1 = (function (){var statearr_65472 = state_65454;
(statearr_65472[(7)] = inst_65429);

return statearr_65472;
})();
if(inst_65430){
var statearr_65473_65491 = state_65454__$1;
(statearr_65473_65491[(1)] = (10));

} else {
var statearr_65474_65492 = state_65454__$1;
(statearr_65474_65492[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__11410__auto____0 = (function (){
var statearr_65475 = [null,null,null,null,null,null,null,null,null];
(statearr_65475[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__11410__auto__);

(statearr_65475[(1)] = (1));

return statearr_65475;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__11410__auto____1 = (function (state_65454){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_65454);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e65476){var ex__11413__auto__ = e65476;
var statearr_65477_65493 = state_65454;
(statearr_65477_65493[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_65454[(4)]))){
var statearr_65478_65494 = state_65454;
(statearr_65478_65494[(1)] = cljs.core.first((state_65454[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65495 = state_65454;
state_65454 = G__65495;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__11410__auto__ = function(state_65454){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__11410__auto____1.call(this,state_65454);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_65479 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_65479[(6)] = c__11484__auto__);

return statearr_65479;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_65540){
var state_val_65541 = (state_65540[(1)]);
if((state_val_65541 === (7))){
var state_65540__$1 = state_65540;
var statearr_65542_65571 = state_65540__$1;
(statearr_65542_65571[(2)] = coll);

(statearr_65542_65571[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65541 === (1))){
var state_65540__$1 = state_65540;
var statearr_65543_65572 = state_65540__$1;
(statearr_65543_65572[(2)] = null);

(statearr_65543_65572[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65541 === (4))){
var inst_65496 = (state_65540[(2)]);
var state_65540__$1 = state_65540;
var statearr_65544_65573 = state_65540__$1;
(statearr_65544_65573[(2)] = inst_65496);

(statearr_65544_65573[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65541 === (15))){
var inst_65516 = (state_65540[(7)]);
var inst_65524 = (state_65540[(2)]);
var inst_65525 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_65516,inst_65524);
var inst_65526 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65527 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65528 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65529 = [inst_65516,inst_65524];
var inst_65530 = (new cljs.core.PersistentVector(null,2,(5),inst_65528,inst_65529,null));
var inst_65531 = ["contains?",inst_65530,inst_65525];
var inst_65532 = cljs.core.PersistentHashMap.fromArrays(inst_65527,inst_65531);
var inst_65533 = [inst_65532,(10)];
var inst_65534 = (new cljs.core.PersistentVector(null,2,(5),inst_65526,inst_65533,null));
var inst_65535 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65534);
var _ = (function (){var statearr_65545 = state_65540;
(statearr_65545[(4)] = cljs.core.rest((state_65540[(4)])));

return statearr_65545;
})();
var state_65540__$1 = (function (){var statearr_65546 = state_65540;
(statearr_65546[(8)] = inst_65535);

return statearr_65546;
})();
var statearr_65547_65574 = state_65540__$1;
(statearr_65547_65574[(2)] = inst_65525);

(statearr_65547_65574[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65541 === (13))){
var state_65540__$1 = state_65540;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65540__$1,(16),key);
} else {
if((state_val_65541 === (6))){
var state_65540__$1 = state_65540;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65540__$1,(9),coll);
} else {
if((state_val_65541 === (3))){
var inst_65538 = (state_65540[(2)]);
var state_65540__$1 = state_65540;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65540__$1,inst_65538);
} else {
if((state_val_65541 === (12))){
var inst_65516 = (state_65540[(2)]);
var inst_65517 = fluree.db.util.async.channel_QMARK_(key);
var state_65540__$1 = (function (){var statearr_65548 = state_65540;
(statearr_65548[(7)] = inst_65516);

return statearr_65548;
})();
if(inst_65517){
var statearr_65549_65575 = state_65540__$1;
(statearr_65549_65575[(1)] = (13));

} else {
var statearr_65550_65576 = state_65540__$1;
(statearr_65550_65576[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65541 === (2))){
var _ = (function (){var statearr_65551 = state_65540;
(statearr_65551[(4)] = cljs.core.cons((5),(state_65540[(4)])));

return statearr_65551;
})();
var inst_65502 = fluree.db.util.async.channel_QMARK_(coll);
var state_65540__$1 = state_65540;
if(inst_65502){
var statearr_65552_65577 = state_65540__$1;
(statearr_65552_65577[(1)] = (6));

} else {
var statearr_65553_65578 = state_65540__$1;
(statearr_65553_65578[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65541 === (11))){
var inst_65509 = (state_65540[(9)]);
var inst_65513 = cljs.core.flatten(inst_65509);
var inst_65514 = cljs.core.set(inst_65513);
var state_65540__$1 = state_65540;
var statearr_65555_65579 = state_65540__$1;
(statearr_65555_65579[(2)] = inst_65514);

(statearr_65555_65579[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65541 === (9))){
var inst_65505 = (state_65540[(2)]);
var inst_65506 = fluree.db.util.async.throw_err(inst_65505);
var state_65540__$1 = state_65540;
var statearr_65556_65580 = state_65540__$1;
(statearr_65556_65580[(2)] = inst_65506);

(statearr_65556_65580[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65541 === (5))){
var _ = (function (){var statearr_65557 = state_65540;
(statearr_65557[(4)] = cljs.core.rest((state_65540[(4)])));

return statearr_65557;
})();
var state_65540__$1 = state_65540;
var ex65554 = (state_65540__$1[(2)]);
var statearr_65558_65581 = state_65540__$1;
(statearr_65558_65581[(5)] = ex65554);


if((ex65554 instanceof Error)){
var statearr_65559_65582 = state_65540__$1;
(statearr_65559_65582[(1)] = (4));

(statearr_65559_65582[(5)] = null);

} else {
throw ex65554;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65541 === (14))){
var state_65540__$1 = state_65540;
var statearr_65560_65583 = state_65540__$1;
(statearr_65560_65583[(2)] = key);

(statearr_65560_65583[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65541 === (16))){
var inst_65520 = (state_65540[(2)]);
var inst_65521 = fluree.db.util.async.throw_err(inst_65520);
var state_65540__$1 = state_65540;
var statearr_65561_65584 = state_65540__$1;
(statearr_65561_65584[(2)] = inst_65521);

(statearr_65561_65584[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65541 === (10))){
var inst_65509 = (state_65540[(9)]);
var state_65540__$1 = state_65540;
var statearr_65562_65585 = state_65540__$1;
(statearr_65562_65585[(2)] = inst_65509);

(statearr_65562_65585[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65541 === (8))){
var inst_65509 = (state_65540[(9)]);
var inst_65509__$1 = (state_65540[(2)]);
var inst_65510 = cljs.core.set_QMARK_(inst_65509__$1);
var state_65540__$1 = (function (){var statearr_65563 = state_65540;
(statearr_65563[(9)] = inst_65509__$1);

return statearr_65563;
})();
if(inst_65510){
var statearr_65564_65586 = state_65540__$1;
(statearr_65564_65586[(1)] = (10));

} else {
var statearr_65565_65587 = state_65540__$1;
(statearr_65565_65587[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11410__auto____0 = (function (){
var statearr_65566 = [null,null,null,null,null,null,null,null,null,null];
(statearr_65566[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11410__auto__);

(statearr_65566[(1)] = (1));

return statearr_65566;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11410__auto____1 = (function (state_65540){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_65540);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e65567){var ex__11413__auto__ = e65567;
var statearr_65568_65588 = state_65540;
(statearr_65568_65588[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_65540[(4)]))){
var statearr_65569_65589 = state_65540;
(statearr_65569_65589[(1)] = cljs.core.first((state_65540[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65590 = state_65540;
state_65540 = G__65590;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11410__auto__ = function(state_65540){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11410__auto____1.call(this,state_65540);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_65570 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_65570[(6)] = c__11484__auto__);

return statearr_65570;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Returns a hash-set of values
 */
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4870__auto__ = [];
var len__4864__auto___65662 = arguments.length;
var i__4865__auto___65663 = (0);
while(true){
if((i__4865__auto___65663 < len__4864__auto___65662)){
args__4870__auto__.push((arguments[i__4865__auto___65663]));

var G__65664 = (i__4865__auto___65663 + (1));
i__4865__auto___65663 = G__65664;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_65636){
var state_val_65637 = (state_65636[(1)]);
if((state_val_65637 === (7))){
var inst_65602 = (state_65636[(7)]);
var inst_65606 = cljs.core.first(inst_65602);
var inst_65607 = cljs.core.coll_QMARK_(inst_65606);
var state_65636__$1 = state_65636;
var statearr_65638_65665 = state_65636__$1;
(statearr_65638_65665[(2)] = inst_65607);

(statearr_65638_65665[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65637 === (1))){
var state_65636__$1 = state_65636;
var statearr_65639_65666 = state_65636__$1;
(statearr_65639_65666[(2)] = null);

(statearr_65639_65666[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65637 === (4))){
var inst_65593 = (state_65636[(2)]);
var state_65636__$1 = state_65636;
var statearr_65640_65667 = state_65636__$1;
(statearr_65640_65667[(2)] = inst_65593);

(statearr_65640_65667[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65637 === (6))){
var inst_65604 = (state_65636[(8)]);
var inst_65602 = (state_65636[(7)]);
var inst_65601 = (state_65636[(2)]);
var inst_65602__$1 = fluree.db.util.async.throw_err(inst_65601);
var inst_65603 = cljs.core.count(inst_65602__$1);
var inst_65604__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_65603);
var state_65636__$1 = (function (){var statearr_65641 = state_65636;
(statearr_65641[(8)] = inst_65604__$1);

(statearr_65641[(7)] = inst_65602__$1);

return statearr_65641;
})();
if(inst_65604__$1){
var statearr_65642_65668 = state_65636__$1;
(statearr_65642_65668[(1)] = (7));

} else {
var statearr_65643_65669 = state_65636__$1;
(statearr_65643_65669[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65637 === (3))){
var inst_65634 = (state_65636[(2)]);
var state_65636__$1 = state_65636;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65636__$1,inst_65634);
} else {
if((state_val_65637 === (12))){
var inst_65615 = (state_65636[(2)]);
var inst_65616 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_65615);
var inst_65617 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65618 = [inst_65615];
var inst_65619 = (new cljs.core.PersistentVector(null,1,(5),inst_65617,inst_65618,null));
var inst_65620 = cljs.core.count(inst_65619);
var inst_65621 = ((9) + inst_65620);
var inst_65622 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65623 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65624 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65625 = [inst_65615];
var inst_65626 = (new cljs.core.PersistentVector(null,1,(5),inst_65624,inst_65625,null));
var inst_65627 = ["hash-set",inst_65626,inst_65616];
var inst_65628 = cljs.core.PersistentHashMap.fromArrays(inst_65623,inst_65627);
var inst_65629 = [inst_65628,inst_65621];
var inst_65630 = (new cljs.core.PersistentVector(null,2,(5),inst_65622,inst_65629,null));
var inst_65631 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65630);
var _ = (function (){var statearr_65644 = state_65636;
(statearr_65644[(4)] = cljs.core.rest((state_65636[(4)])));

return statearr_65644;
})();
var state_65636__$1 = (function (){var statearr_65645 = state_65636;
(statearr_65645[(9)] = inst_65631);

return statearr_65645;
})();
var statearr_65646_65670 = state_65636__$1;
(statearr_65646_65670[(2)] = inst_65616);

(statearr_65646_65670[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65637 === (2))){
var _ = (function (){var statearr_65647 = state_65636;
(statearr_65647[(4)] = cljs.core.cons((5),(state_65636[(4)])));

return statearr_65647;
})();
var inst_65599 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65636__$1 = state_65636;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65636__$1,(6),inst_65599);
} else {
if((state_val_65637 === (11))){
var inst_65602 = (state_65636[(7)]);
var state_65636__$1 = state_65636;
var statearr_65649_65671 = state_65636__$1;
(statearr_65649_65671[(2)] = inst_65602);

(statearr_65649_65671[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65637 === (9))){
var inst_65610 = (state_65636[(2)]);
var state_65636__$1 = state_65636;
if(cljs.core.truth_(inst_65610)){
var statearr_65650_65672 = state_65636__$1;
(statearr_65650_65672[(1)] = (10));

} else {
var statearr_65651_65673 = state_65636__$1;
(statearr_65651_65673[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65637 === (5))){
var _ = (function (){var statearr_65652 = state_65636;
(statearr_65652[(4)] = cljs.core.rest((state_65636[(4)])));

return statearr_65652;
})();
var state_65636__$1 = state_65636;
var ex65648 = (state_65636__$1[(2)]);
var statearr_65653_65674 = state_65636__$1;
(statearr_65653_65674[(5)] = ex65648);


if((ex65648 instanceof Error)){
var statearr_65654_65675 = state_65636__$1;
(statearr_65654_65675[(1)] = (4));

(statearr_65654_65675[(5)] = null);

} else {
throw ex65648;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65637 === (10))){
var inst_65602 = (state_65636[(7)]);
var inst_65612 = cljs.core.first(inst_65602);
var state_65636__$1 = state_65636;
var statearr_65655_65676 = state_65636__$1;
(statearr_65655_65676[(2)] = inst_65612);

(statearr_65655_65676[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65637 === (8))){
var inst_65604 = (state_65636[(8)]);
var state_65636__$1 = state_65636;
var statearr_65656_65677 = state_65636__$1;
(statearr_65656_65677[(2)] = inst_65604);

(statearr_65656_65677[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11410__auto____0 = (function (){
var statearr_65657 = [null,null,null,null,null,null,null,null,null,null];
(statearr_65657[(0)] = fluree$db$dbfunctions$fns$state_machine__11410__auto__);

(statearr_65657[(1)] = (1));

return statearr_65657;
});
var fluree$db$dbfunctions$fns$state_machine__11410__auto____1 = (function (state_65636){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_65636);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e65658){var ex__11413__auto__ = e65658;
var statearr_65659_65678 = state_65636;
(statearr_65659_65678[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_65636[(4)]))){
var statearr_65660_65679 = state_65636;
(statearr_65660_65679[(1)] = cljs.core.first((state_65636[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65680 = state_65636;
state_65636 = G__65680;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11410__auto__ = function(state_65636){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____1.call(this,state_65636);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_65661 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_65661[(6)] = c__11484__auto__);

return statearr_65661;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq65591){
var G__65592 = cljs.core.first(seq65591);
var seq65591__$1 = cljs.core.next(seq65591);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65592,seq65591__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___65730 = arguments.length;
var i__4865__auto___65731 = (0);
while(true){
if((i__4865__auto___65731 < len__4864__auto___65730)){
args__4870__auto__.push((arguments[i__4865__auto___65731]));

var G__65732 = (i__4865__auto___65731 + (1));
i__4865__auto___65731 = G__65732;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_65713){
var state_val_65714 = (state_65713[(1)]);
if((state_val_65714 === (1))){
var state_65713__$1 = state_65713;
var statearr_65715_65733 = state_65713__$1;
(statearr_65715_65733[(2)] = null);

(statearr_65715_65733[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65714 === (2))){
var _ = (function (){var statearr_65716 = state_65713;
(statearr_65716[(4)] = cljs.core.cons((5),(state_65713[(4)])));

return statearr_65716;
})();
var inst_65689 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65713__$1 = state_65713;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65713__$1,(6),inst_65689);
} else {
if((state_val_65714 === (3))){
var inst_65711 = (state_65713[(2)]);
var state_65713__$1 = state_65713;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65713__$1,inst_65711);
} else {
if((state_val_65714 === (4))){
var inst_65683 = (state_65713[(2)]);
var state_65713__$1 = state_65713;
var statearr_65718_65734 = state_65713__$1;
(statearr_65718_65734[(2)] = inst_65683);

(statearr_65718_65734[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65714 === (5))){
var _ = (function (){var statearr_65719 = state_65713;
(statearr_65719[(4)] = cljs.core.rest((state_65713[(4)])));

return statearr_65719;
})();
var state_65713__$1 = state_65713;
var ex65717 = (state_65713__$1[(2)]);
var statearr_65720_65735 = state_65713__$1;
(statearr_65720_65735[(5)] = ex65717);


if((ex65717 instanceof Error)){
var statearr_65721_65736 = state_65713__$1;
(statearr_65721_65736[(1)] = (4));

(statearr_65721_65736[(5)] = null);

} else {
throw ex65717;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65714 === (6))){
var inst_65691 = (state_65713[(2)]);
var inst_65692 = fluree.db.util.async.throw_err(inst_65691);
var inst_65693 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_65692);
var inst_65694 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65695 = [inst_65692];
var inst_65696 = (new cljs.core.PersistentVector(null,1,(5),inst_65694,inst_65695,null));
var inst_65697 = cljs.core.count(inst_65696);
var inst_65698 = ((9) + inst_65697);
var inst_65699 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65700 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65701 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65702 = [inst_65692];
var inst_65703 = (new cljs.core.PersistentVector(null,1,(5),inst_65701,inst_65702,null));
var inst_65704 = ["==",inst_65703,inst_65693];
var inst_65705 = cljs.core.PersistentHashMap.fromArrays(inst_65700,inst_65704);
var inst_65706 = [inst_65705,inst_65698];
var inst_65707 = (new cljs.core.PersistentVector(null,2,(5),inst_65699,inst_65706,null));
var inst_65708 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65707);
var _ = (function (){var statearr_65722 = state_65713;
(statearr_65722[(4)] = cljs.core.rest((state_65713[(4)])));

return statearr_65722;
})();
var state_65713__$1 = (function (){var statearr_65723 = state_65713;
(statearr_65723[(7)] = inst_65708);

return statearr_65723;
})();
var statearr_65724_65737 = state_65713__$1;
(statearr_65724_65737[(2)] = inst_65693);

(statearr_65724_65737[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11410__auto____0 = (function (){
var statearr_65725 = [null,null,null,null,null,null,null,null];
(statearr_65725[(0)] = fluree$db$dbfunctions$fns$state_machine__11410__auto__);

(statearr_65725[(1)] = (1));

return statearr_65725;
});
var fluree$db$dbfunctions$fns$state_machine__11410__auto____1 = (function (state_65713){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_65713);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e65726){var ex__11413__auto__ = e65726;
var statearr_65727_65738 = state_65713;
(statearr_65727_65738[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_65713[(4)]))){
var statearr_65728_65739 = state_65713;
(statearr_65728_65739[(1)] = cljs.core.first((state_65713[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65740 = state_65713;
state_65713 = G__65740;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11410__auto__ = function(state_65713){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____1.call(this,state_65713);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_65729 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_65729[(6)] = c__11484__auto__);

return statearr_65729;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq65681){
var G__65682 = cljs.core.first(seq65681);
var seq65681__$1 = cljs.core.next(seq65681);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65682,seq65681__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___65790 = arguments.length;
var i__4865__auto___65791 = (0);
while(true){
if((i__4865__auto___65791 < len__4864__auto___65790)){
args__4870__auto__.push((arguments[i__4865__auto___65791]));

var G__65792 = (i__4865__auto___65791 + (1));
i__4865__auto___65791 = G__65792;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_65773){
var state_val_65774 = (state_65773[(1)]);
if((state_val_65774 === (1))){
var state_65773__$1 = state_65773;
var statearr_65775_65793 = state_65773__$1;
(statearr_65775_65793[(2)] = null);

(statearr_65775_65793[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65774 === (2))){
var _ = (function (){var statearr_65776 = state_65773;
(statearr_65776[(4)] = cljs.core.cons((5),(state_65773[(4)])));

return statearr_65776;
})();
var inst_65749 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65773__$1 = state_65773;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65773__$1,(6),inst_65749);
} else {
if((state_val_65774 === (3))){
var inst_65771 = (state_65773[(2)]);
var state_65773__$1 = state_65773;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65773__$1,inst_65771);
} else {
if((state_val_65774 === (4))){
var inst_65743 = (state_65773[(2)]);
var state_65773__$1 = state_65773;
var statearr_65778_65794 = state_65773__$1;
(statearr_65778_65794[(2)] = inst_65743);

(statearr_65778_65794[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65774 === (5))){
var _ = (function (){var statearr_65779 = state_65773;
(statearr_65779[(4)] = cljs.core.rest((state_65773[(4)])));

return statearr_65779;
})();
var state_65773__$1 = state_65773;
var ex65777 = (state_65773__$1[(2)]);
var statearr_65780_65795 = state_65773__$1;
(statearr_65780_65795[(5)] = ex65777);


if((ex65777 instanceof Error)){
var statearr_65781_65796 = state_65773__$1;
(statearr_65781_65796[(1)] = (4));

(statearr_65781_65796[(5)] = null);

} else {
throw ex65777;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65774 === (6))){
var inst_65751 = (state_65773[(2)]);
var inst_65752 = fluree.db.util.async.throw_err(inst_65751);
var inst_65753 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_65752);
var inst_65754 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65755 = [inst_65752];
var inst_65756 = (new cljs.core.PersistentVector(null,1,(5),inst_65754,inst_65755,null));
var inst_65757 = cljs.core.count(inst_65756);
var inst_65758 = ((9) + inst_65757);
var inst_65759 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65760 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65761 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65762 = [inst_65752];
var inst_65763 = (new cljs.core.PersistentVector(null,1,(5),inst_65761,inst_65762,null));
var inst_65764 = [">",inst_65763,inst_65753];
var inst_65765 = cljs.core.PersistentHashMap.fromArrays(inst_65760,inst_65764);
var inst_65766 = [inst_65765,inst_65758];
var inst_65767 = (new cljs.core.PersistentVector(null,2,(5),inst_65759,inst_65766,null));
var inst_65768 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65767);
var _ = (function (){var statearr_65782 = state_65773;
(statearr_65782[(4)] = cljs.core.rest((state_65773[(4)])));

return statearr_65782;
})();
var state_65773__$1 = (function (){var statearr_65783 = state_65773;
(statearr_65783[(7)] = inst_65768);

return statearr_65783;
})();
var statearr_65784_65797 = state_65773__$1;
(statearr_65784_65797[(2)] = inst_65753);

(statearr_65784_65797[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11410__auto____0 = (function (){
var statearr_65785 = [null,null,null,null,null,null,null,null];
(statearr_65785[(0)] = fluree$db$dbfunctions$fns$state_machine__11410__auto__);

(statearr_65785[(1)] = (1));

return statearr_65785;
});
var fluree$db$dbfunctions$fns$state_machine__11410__auto____1 = (function (state_65773){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_65773);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e65786){var ex__11413__auto__ = e65786;
var statearr_65787_65798 = state_65773;
(statearr_65787_65798[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_65773[(4)]))){
var statearr_65788_65799 = state_65773;
(statearr_65788_65799[(1)] = cljs.core.first((state_65773[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65800 = state_65773;
state_65773 = G__65800;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11410__auto__ = function(state_65773){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____1.call(this,state_65773);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_65789 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_65789[(6)] = c__11484__auto__);

return statearr_65789;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq65741){
var G__65742 = cljs.core.first(seq65741);
var seq65741__$1 = cljs.core.next(seq65741);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65742,seq65741__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___65850 = arguments.length;
var i__4865__auto___65851 = (0);
while(true){
if((i__4865__auto___65851 < len__4864__auto___65850)){
args__4870__auto__.push((arguments[i__4865__auto___65851]));

var G__65852 = (i__4865__auto___65851 + (1));
i__4865__auto___65851 = G__65852;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_65833){
var state_val_65834 = (state_65833[(1)]);
if((state_val_65834 === (1))){
var state_65833__$1 = state_65833;
var statearr_65835_65853 = state_65833__$1;
(statearr_65835_65853[(2)] = null);

(statearr_65835_65853[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65834 === (2))){
var _ = (function (){var statearr_65836 = state_65833;
(statearr_65836[(4)] = cljs.core.cons((5),(state_65833[(4)])));

return statearr_65836;
})();
var inst_65809 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65833__$1 = state_65833;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65833__$1,(6),inst_65809);
} else {
if((state_val_65834 === (3))){
var inst_65831 = (state_65833[(2)]);
var state_65833__$1 = state_65833;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65833__$1,inst_65831);
} else {
if((state_val_65834 === (4))){
var inst_65803 = (state_65833[(2)]);
var state_65833__$1 = state_65833;
var statearr_65838_65854 = state_65833__$1;
(statearr_65838_65854[(2)] = inst_65803);

(statearr_65838_65854[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65834 === (5))){
var _ = (function (){var statearr_65839 = state_65833;
(statearr_65839[(4)] = cljs.core.rest((state_65833[(4)])));

return statearr_65839;
})();
var state_65833__$1 = state_65833;
var ex65837 = (state_65833__$1[(2)]);
var statearr_65840_65855 = state_65833__$1;
(statearr_65840_65855[(5)] = ex65837);


if((ex65837 instanceof Error)){
var statearr_65841_65856 = state_65833__$1;
(statearr_65841_65856[(1)] = (4));

(statearr_65841_65856[(5)] = null);

} else {
throw ex65837;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65834 === (6))){
var inst_65811 = (state_65833[(2)]);
var inst_65812 = fluree.db.util.async.throw_err(inst_65811);
var inst_65813 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_65812);
var inst_65814 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65815 = [inst_65812];
var inst_65816 = (new cljs.core.PersistentVector(null,1,(5),inst_65814,inst_65815,null));
var inst_65817 = cljs.core.count(inst_65816);
var inst_65818 = ((9) + inst_65817);
var inst_65819 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65820 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65821 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65822 = [inst_65812];
var inst_65823 = (new cljs.core.PersistentVector(null,1,(5),inst_65821,inst_65822,null));
var inst_65824 = ["<",inst_65823,inst_65813];
var inst_65825 = cljs.core.PersistentHashMap.fromArrays(inst_65820,inst_65824);
var inst_65826 = [inst_65825,inst_65818];
var inst_65827 = (new cljs.core.PersistentVector(null,2,(5),inst_65819,inst_65826,null));
var inst_65828 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65827);
var _ = (function (){var statearr_65842 = state_65833;
(statearr_65842[(4)] = cljs.core.rest((state_65833[(4)])));

return statearr_65842;
})();
var state_65833__$1 = (function (){var statearr_65843 = state_65833;
(statearr_65843[(7)] = inst_65828);

return statearr_65843;
})();
var statearr_65844_65857 = state_65833__$1;
(statearr_65844_65857[(2)] = inst_65813);

(statearr_65844_65857[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11410__auto____0 = (function (){
var statearr_65845 = [null,null,null,null,null,null,null,null];
(statearr_65845[(0)] = fluree$db$dbfunctions$fns$state_machine__11410__auto__);

(statearr_65845[(1)] = (1));

return statearr_65845;
});
var fluree$db$dbfunctions$fns$state_machine__11410__auto____1 = (function (state_65833){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_65833);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e65846){var ex__11413__auto__ = e65846;
var statearr_65847_65858 = state_65833;
(statearr_65847_65858[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_65833[(4)]))){
var statearr_65848_65859 = state_65833;
(statearr_65848_65859[(1)] = cljs.core.first((state_65833[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65860 = state_65833;
state_65833 = G__65860;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11410__auto__ = function(state_65833){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____1.call(this,state_65833);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_65849 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_65849[(6)] = c__11484__auto__);

return statearr_65849;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq65801){
var G__65802 = cljs.core.first(seq65801);
var seq65801__$1 = cljs.core.next(seq65801);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65802,seq65801__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___65910 = arguments.length;
var i__4865__auto___65911 = (0);
while(true){
if((i__4865__auto___65911 < len__4864__auto___65910)){
args__4870__auto__.push((arguments[i__4865__auto___65911]));

var G__65912 = (i__4865__auto___65911 + (1));
i__4865__auto___65911 = G__65912;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_65893){
var state_val_65894 = (state_65893[(1)]);
if((state_val_65894 === (1))){
var state_65893__$1 = state_65893;
var statearr_65895_65913 = state_65893__$1;
(statearr_65895_65913[(2)] = null);

(statearr_65895_65913[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65894 === (2))){
var _ = (function (){var statearr_65896 = state_65893;
(statearr_65896[(4)] = cljs.core.cons((5),(state_65893[(4)])));

return statearr_65896;
})();
var inst_65869 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65893__$1 = state_65893;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65893__$1,(6),inst_65869);
} else {
if((state_val_65894 === (3))){
var inst_65891 = (state_65893[(2)]);
var state_65893__$1 = state_65893;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65893__$1,inst_65891);
} else {
if((state_val_65894 === (4))){
var inst_65863 = (state_65893[(2)]);
var state_65893__$1 = state_65893;
var statearr_65898_65914 = state_65893__$1;
(statearr_65898_65914[(2)] = inst_65863);

(statearr_65898_65914[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65894 === (5))){
var _ = (function (){var statearr_65899 = state_65893;
(statearr_65899[(4)] = cljs.core.rest((state_65893[(4)])));

return statearr_65899;
})();
var state_65893__$1 = state_65893;
var ex65897 = (state_65893__$1[(2)]);
var statearr_65900_65915 = state_65893__$1;
(statearr_65900_65915[(5)] = ex65897);


if((ex65897 instanceof Error)){
var statearr_65901_65916 = state_65893__$1;
(statearr_65901_65916[(1)] = (4));

(statearr_65901_65916[(5)] = null);

} else {
throw ex65897;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65894 === (6))){
var inst_65871 = (state_65893[(2)]);
var inst_65872 = fluree.db.util.async.throw_err(inst_65871);
var inst_65873 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_65872);
var inst_65874 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65875 = [inst_65872];
var inst_65876 = (new cljs.core.PersistentVector(null,1,(5),inst_65874,inst_65875,null));
var inst_65877 = cljs.core.count(inst_65876);
var inst_65878 = ((9) + inst_65877);
var inst_65879 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65880 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65881 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65882 = [inst_65872];
var inst_65883 = (new cljs.core.PersistentVector(null,1,(5),inst_65881,inst_65882,null));
var inst_65884 = ["<=",inst_65883,inst_65873];
var inst_65885 = cljs.core.PersistentHashMap.fromArrays(inst_65880,inst_65884);
var inst_65886 = [inst_65885,inst_65878];
var inst_65887 = (new cljs.core.PersistentVector(null,2,(5),inst_65879,inst_65886,null));
var inst_65888 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65887);
var _ = (function (){var statearr_65902 = state_65893;
(statearr_65902[(4)] = cljs.core.rest((state_65893[(4)])));

return statearr_65902;
})();
var state_65893__$1 = (function (){var statearr_65903 = state_65893;
(statearr_65903[(7)] = inst_65888);

return statearr_65903;
})();
var statearr_65904_65917 = state_65893__$1;
(statearr_65904_65917[(2)] = inst_65873);

(statearr_65904_65917[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11410__auto____0 = (function (){
var statearr_65905 = [null,null,null,null,null,null,null,null];
(statearr_65905[(0)] = fluree$db$dbfunctions$fns$state_machine__11410__auto__);

(statearr_65905[(1)] = (1));

return statearr_65905;
});
var fluree$db$dbfunctions$fns$state_machine__11410__auto____1 = (function (state_65893){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_65893);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e65906){var ex__11413__auto__ = e65906;
var statearr_65907_65918 = state_65893;
(statearr_65907_65918[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_65893[(4)]))){
var statearr_65908_65919 = state_65893;
(statearr_65908_65919[(1)] = cljs.core.first((state_65893[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65920 = state_65893;
state_65893 = G__65920;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11410__auto__ = function(state_65893){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____1.call(this,state_65893);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_65909 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_65909[(6)] = c__11484__auto__);

return statearr_65909;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq65861){
var G__65862 = cljs.core.first(seq65861);
var seq65861__$1 = cljs.core.next(seq65861);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65862,seq65861__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___65970 = arguments.length;
var i__4865__auto___65971 = (0);
while(true){
if((i__4865__auto___65971 < len__4864__auto___65970)){
args__4870__auto__.push((arguments[i__4865__auto___65971]));

var G__65972 = (i__4865__auto___65971 + (1));
i__4865__auto___65971 = G__65972;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_65953){
var state_val_65954 = (state_65953[(1)]);
if((state_val_65954 === (1))){
var state_65953__$1 = state_65953;
var statearr_65955_65973 = state_65953__$1;
(statearr_65955_65973[(2)] = null);

(statearr_65955_65973[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65954 === (2))){
var _ = (function (){var statearr_65956 = state_65953;
(statearr_65956[(4)] = cljs.core.cons((5),(state_65953[(4)])));

return statearr_65956;
})();
var inst_65929 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65953__$1 = state_65953;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65953__$1,(6),inst_65929);
} else {
if((state_val_65954 === (3))){
var inst_65951 = (state_65953[(2)]);
var state_65953__$1 = state_65953;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65953__$1,inst_65951);
} else {
if((state_val_65954 === (4))){
var inst_65923 = (state_65953[(2)]);
var state_65953__$1 = state_65953;
var statearr_65958_65974 = state_65953__$1;
(statearr_65958_65974[(2)] = inst_65923);

(statearr_65958_65974[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65954 === (5))){
var _ = (function (){var statearr_65959 = state_65953;
(statearr_65959[(4)] = cljs.core.rest((state_65953[(4)])));

return statearr_65959;
})();
var state_65953__$1 = state_65953;
var ex65957 = (state_65953__$1[(2)]);
var statearr_65960_65975 = state_65953__$1;
(statearr_65960_65975[(5)] = ex65957);


if((ex65957 instanceof Error)){
var statearr_65961_65976 = state_65953__$1;
(statearr_65961_65976[(1)] = (4));

(statearr_65961_65976[(5)] = null);

} else {
throw ex65957;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65954 === (6))){
var inst_65931 = (state_65953[(2)]);
var inst_65932 = fluree.db.util.async.throw_err(inst_65931);
var inst_65933 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_65932);
var inst_65934 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65935 = [inst_65932];
var inst_65936 = (new cljs.core.PersistentVector(null,1,(5),inst_65934,inst_65935,null));
var inst_65937 = cljs.core.count(inst_65936);
var inst_65938 = ((9) + inst_65937);
var inst_65939 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65940 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65941 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65942 = [inst_65932];
var inst_65943 = (new cljs.core.PersistentVector(null,1,(5),inst_65941,inst_65942,null));
var inst_65944 = [">=",inst_65943,inst_65933];
var inst_65945 = cljs.core.PersistentHashMap.fromArrays(inst_65940,inst_65944);
var inst_65946 = [inst_65945,inst_65938];
var inst_65947 = (new cljs.core.PersistentVector(null,2,(5),inst_65939,inst_65946,null));
var inst_65948 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65947);
var _ = (function (){var statearr_65962 = state_65953;
(statearr_65962[(4)] = cljs.core.rest((state_65953[(4)])));

return statearr_65962;
})();
var state_65953__$1 = (function (){var statearr_65963 = state_65953;
(statearr_65963[(7)] = inst_65948);

return statearr_65963;
})();
var statearr_65964_65977 = state_65953__$1;
(statearr_65964_65977[(2)] = inst_65933);

(statearr_65964_65977[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11410__auto____0 = (function (){
var statearr_65965 = [null,null,null,null,null,null,null,null];
(statearr_65965[(0)] = fluree$db$dbfunctions$fns$state_machine__11410__auto__);

(statearr_65965[(1)] = (1));

return statearr_65965;
});
var fluree$db$dbfunctions$fns$state_machine__11410__auto____1 = (function (state_65953){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_65953);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e65966){var ex__11413__auto__ = e65966;
var statearr_65967_65978 = state_65953;
(statearr_65967_65978[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_65953[(4)]))){
var statearr_65968_65979 = state_65953;
(statearr_65968_65979[(1)] = cljs.core.first((state_65953[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65980 = state_65953;
state_65953 = G__65980;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11410__auto__ = function(state_65953){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____1.call(this,state_65953);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_65969 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_65969[(6)] = c__11484__auto__);

return statearr_65969;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq65921){
var G__65922 = cljs.core.first(seq65921);
var seq65921__$1 = cljs.core.next(seq65921);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65922,seq65921__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___66030 = arguments.length;
var i__4865__auto___66031 = (0);
while(true){
if((i__4865__auto___66031 < len__4864__auto___66030)){
args__4870__auto__.push((arguments[i__4865__auto___66031]));

var G__66032 = (i__4865__auto___66031 + (1));
i__4865__auto___66031 = G__66032;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_66013){
var state_val_66014 = (state_66013[(1)]);
if((state_val_66014 === (1))){
var state_66013__$1 = state_66013;
var statearr_66015_66033 = state_66013__$1;
(statearr_66015_66033[(2)] = null);

(statearr_66015_66033[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66014 === (2))){
var _ = (function (){var statearr_66016 = state_66013;
(statearr_66016[(4)] = cljs.core.cons((5),(state_66013[(4)])));

return statearr_66016;
})();
var inst_65989 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66013__$1 = state_66013;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66013__$1,(6),inst_65989);
} else {
if((state_val_66014 === (3))){
var inst_66011 = (state_66013[(2)]);
var state_66013__$1 = state_66013;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66013__$1,inst_66011);
} else {
if((state_val_66014 === (4))){
var inst_65983 = (state_66013[(2)]);
var state_66013__$1 = state_66013;
var statearr_66018_66034 = state_66013__$1;
(statearr_66018_66034[(2)] = inst_65983);

(statearr_66018_66034[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66014 === (5))){
var _ = (function (){var statearr_66019 = state_66013;
(statearr_66019[(4)] = cljs.core.rest((state_66013[(4)])));

return statearr_66019;
})();
var state_66013__$1 = state_66013;
var ex66017 = (state_66013__$1[(2)]);
var statearr_66020_66035 = state_66013__$1;
(statearr_66020_66035[(5)] = ex66017);


if((ex66017 instanceof Error)){
var statearr_66021_66036 = state_66013__$1;
(statearr_66021_66036[(1)] = (4));

(statearr_66021_66036[(5)] = null);

} else {
throw ex66017;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66014 === (6))){
var inst_65991 = (state_66013[(2)]);
var inst_65992 = fluree.db.util.async.throw_err(inst_65991);
var inst_65993 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.not_EQ_,inst_65992);
var inst_65994 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65995 = [inst_65992];
var inst_65996 = (new cljs.core.PersistentVector(null,1,(5),inst_65994,inst_65995,null));
var inst_65997 = cljs.core.count(inst_65996);
var inst_65998 = ((9) + inst_65997);
var inst_65999 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66000 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66001 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66002 = [inst_65992];
var inst_66003 = (new cljs.core.PersistentVector(null,1,(5),inst_66001,inst_66002,null));
var inst_66004 = ["not=",inst_66003,inst_65993];
var inst_66005 = cljs.core.PersistentHashMap.fromArrays(inst_66000,inst_66004);
var inst_66006 = [inst_66005,inst_65998];
var inst_66007 = (new cljs.core.PersistentVector(null,2,(5),inst_65999,inst_66006,null));
var inst_66008 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66007);
var _ = (function (){var statearr_66022 = state_66013;
(statearr_66022[(4)] = cljs.core.rest((state_66013[(4)])));

return statearr_66022;
})();
var state_66013__$1 = (function (){var statearr_66023 = state_66013;
(statearr_66023[(7)] = inst_66008);

return statearr_66023;
})();
var statearr_66024_66037 = state_66013__$1;
(statearr_66024_66037[(2)] = inst_65993);

(statearr_66024_66037[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11410__auto____0 = (function (){
var statearr_66025 = [null,null,null,null,null,null,null,null];
(statearr_66025[(0)] = fluree$db$dbfunctions$fns$state_machine__11410__auto__);

(statearr_66025[(1)] = (1));

return statearr_66025;
});
var fluree$db$dbfunctions$fns$state_machine__11410__auto____1 = (function (state_66013){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_66013);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e66026){var ex__11413__auto__ = e66026;
var statearr_66027_66038 = state_66013;
(statearr_66027_66038[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_66013[(4)]))){
var statearr_66028_66039 = state_66013;
(statearr_66028_66039[(1)] = cljs.core.first((state_66013[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66040 = state_66013;
state_66013 = G__66040;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11410__auto__ = function(state_66013){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____1.call(this,state_66013);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_66029 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_66029[(6)] = c__11484__auto__);

return statearr_66029;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq65981){
var G__65982 = cljs.core.first(seq65981);
var seq65981__$1 = cljs.core.next(seq65981);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65982,seq65981__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4870__auto__ = [];
var len__4864__auto___66090 = arguments.length;
var i__4865__auto___66091 = (0);
while(true){
if((i__4865__auto___66091 < len__4864__auto___66090)){
args__4870__auto__.push((arguments[i__4865__auto___66091]));

var G__66092 = (i__4865__auto___66091 + (1));
i__4865__auto___66091 = G__66092;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_66073){
var state_val_66074 = (state_66073[(1)]);
if((state_val_66074 === (1))){
var state_66073__$1 = state_66073;
var statearr_66075_66093 = state_66073__$1;
(statearr_66075_66093[(2)] = null);

(statearr_66075_66093[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66074 === (2))){
var _ = (function (){var statearr_66076 = state_66073;
(statearr_66076[(4)] = cljs.core.cons((5),(state_66073[(4)])));

return statearr_66076;
})();
var inst_66049 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66073__$1 = state_66073;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66073__$1,(6),inst_66049);
} else {
if((state_val_66074 === (3))){
var inst_66071 = (state_66073[(2)]);
var state_66073__$1 = state_66073;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66073__$1,inst_66071);
} else {
if((state_val_66074 === (4))){
var inst_66043 = (state_66073[(2)]);
var state_66073__$1 = state_66073;
var statearr_66078_66094 = state_66073__$1;
(statearr_66078_66094[(2)] = inst_66043);

(statearr_66078_66094[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66074 === (5))){
var _ = (function (){var statearr_66079 = state_66073;
(statearr_66079[(4)] = cljs.core.rest((state_66073[(4)])));

return statearr_66079;
})();
var state_66073__$1 = state_66073;
var ex66077 = (state_66073__$1[(2)]);
var statearr_66080_66095 = state_66073__$1;
(statearr_66080_66095[(5)] = ex66077);


if((ex66077 instanceof Error)){
var statearr_66081_66096 = state_66073__$1;
(statearr_66081_66096[(1)] = (4));

(statearr_66081_66096[(5)] = null);

} else {
throw ex66077;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66074 === (6))){
var inst_66051 = (state_66073[(2)]);
var inst_66052 = fluree.db.util.async.throw_err(inst_66051);
var inst_66053 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_66052);
var inst_66054 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66055 = [inst_66052];
var inst_66056 = (new cljs.core.PersistentVector(null,1,(5),inst_66054,inst_66055,null));
var inst_66057 = cljs.core.count(inst_66056);
var inst_66058 = ((9) + inst_66057);
var inst_66059 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66060 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66061 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66062 = [inst_66052];
var inst_66063 = (new cljs.core.PersistentVector(null,1,(5),inst_66061,inst_66062,null));
var inst_66064 = ["max",inst_66063,inst_66053];
var inst_66065 = cljs.core.PersistentHashMap.fromArrays(inst_66060,inst_66064);
var inst_66066 = [inst_66065,inst_66058];
var inst_66067 = (new cljs.core.PersistentVector(null,2,(5),inst_66059,inst_66066,null));
var inst_66068 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66067);
var _ = (function (){var statearr_66082 = state_66073;
(statearr_66082[(4)] = cljs.core.rest((state_66073[(4)])));

return statearr_66082;
})();
var state_66073__$1 = (function (){var statearr_66083 = state_66073;
(statearr_66083[(7)] = inst_66068);

return statearr_66083;
})();
var statearr_66084_66097 = state_66073__$1;
(statearr_66084_66097[(2)] = inst_66053);

(statearr_66084_66097[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11410__auto____0 = (function (){
var statearr_66085 = [null,null,null,null,null,null,null,null];
(statearr_66085[(0)] = fluree$db$dbfunctions$fns$state_machine__11410__auto__);

(statearr_66085[(1)] = (1));

return statearr_66085;
});
var fluree$db$dbfunctions$fns$state_machine__11410__auto____1 = (function (state_66073){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_66073);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e66086){var ex__11413__auto__ = e66086;
var statearr_66087_66098 = state_66073;
(statearr_66087_66098[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_66073[(4)]))){
var statearr_66088_66099 = state_66073;
(statearr_66088_66099[(1)] = cljs.core.first((state_66073[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66100 = state_66073;
state_66073 = G__66100;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11410__auto__ = function(state_66073){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____1.call(this,state_66073);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_66089 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_66089[(6)] = c__11484__auto__);

return statearr_66089;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq66041){
var G__66042 = cljs.core.first(seq66041);
var seq66041__$1 = cljs.core.next(seq66041);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66042,seq66041__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4870__auto__ = [];
var len__4864__auto___66150 = arguments.length;
var i__4865__auto___66151 = (0);
while(true){
if((i__4865__auto___66151 < len__4864__auto___66150)){
args__4870__auto__.push((arguments[i__4865__auto___66151]));

var G__66152 = (i__4865__auto___66151 + (1));
i__4865__auto___66151 = G__66152;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_66133){
var state_val_66134 = (state_66133[(1)]);
if((state_val_66134 === (1))){
var state_66133__$1 = state_66133;
var statearr_66135_66153 = state_66133__$1;
(statearr_66135_66153[(2)] = null);

(statearr_66135_66153[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66134 === (2))){
var _ = (function (){var statearr_66136 = state_66133;
(statearr_66136[(4)] = cljs.core.cons((5),(state_66133[(4)])));

return statearr_66136;
})();
var inst_66109 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66133__$1 = state_66133;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66133__$1,(6),inst_66109);
} else {
if((state_val_66134 === (3))){
var inst_66131 = (state_66133[(2)]);
var state_66133__$1 = state_66133;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66133__$1,inst_66131);
} else {
if((state_val_66134 === (4))){
var inst_66103 = (state_66133[(2)]);
var state_66133__$1 = state_66133;
var statearr_66138_66154 = state_66133__$1;
(statearr_66138_66154[(2)] = inst_66103);

(statearr_66138_66154[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66134 === (5))){
var _ = (function (){var statearr_66139 = state_66133;
(statearr_66139[(4)] = cljs.core.rest((state_66133[(4)])));

return statearr_66139;
})();
var state_66133__$1 = state_66133;
var ex66137 = (state_66133__$1[(2)]);
var statearr_66140_66155 = state_66133__$1;
(statearr_66140_66155[(5)] = ex66137);


if((ex66137 instanceof Error)){
var statearr_66141_66156 = state_66133__$1;
(statearr_66141_66156[(1)] = (4));

(statearr_66141_66156[(5)] = null);

} else {
throw ex66137;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66134 === (6))){
var inst_66111 = (state_66133[(2)]);
var inst_66112 = fluree.db.util.async.throw_err(inst_66111);
var inst_66113 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_66112);
var inst_66114 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66115 = [inst_66112];
var inst_66116 = (new cljs.core.PersistentVector(null,1,(5),inst_66114,inst_66115,null));
var inst_66117 = cljs.core.count(inst_66116);
var inst_66118 = ((9) + inst_66117);
var inst_66119 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66120 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66121 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66122 = [inst_66112];
var inst_66123 = (new cljs.core.PersistentVector(null,1,(5),inst_66121,inst_66122,null));
var inst_66124 = ["min",inst_66123,inst_66113];
var inst_66125 = cljs.core.PersistentHashMap.fromArrays(inst_66120,inst_66124);
var inst_66126 = [inst_66125,inst_66118];
var inst_66127 = (new cljs.core.PersistentVector(null,2,(5),inst_66119,inst_66126,null));
var inst_66128 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66127);
var _ = (function (){var statearr_66142 = state_66133;
(statearr_66142[(4)] = cljs.core.rest((state_66133[(4)])));

return statearr_66142;
})();
var state_66133__$1 = (function (){var statearr_66143 = state_66133;
(statearr_66143[(7)] = inst_66128);

return statearr_66143;
})();
var statearr_66144_66157 = state_66133__$1;
(statearr_66144_66157[(2)] = inst_66113);

(statearr_66144_66157[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11410__auto____0 = (function (){
var statearr_66145 = [null,null,null,null,null,null,null,null];
(statearr_66145[(0)] = fluree$db$dbfunctions$fns$state_machine__11410__auto__);

(statearr_66145[(1)] = (1));

return statearr_66145;
});
var fluree$db$dbfunctions$fns$state_machine__11410__auto____1 = (function (state_66133){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_66133);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e66146){var ex__11413__auto__ = e66146;
var statearr_66147_66158 = state_66133;
(statearr_66147_66158[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_66133[(4)]))){
var statearr_66148_66159 = state_66133;
(statearr_66148_66159[(1)] = cljs.core.first((state_66133[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66160 = state_66133;
state_66133 = G__66160;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11410__auto__ = function(state_66133){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____1.call(this,state_66133);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_66149 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_66149[(6)] = c__11484__auto__);

return statearr_66149;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq66101){
var G__66102 = cljs.core.first(seq66101);
var seq66101__$1 = cljs.core.next(seq66101);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66102,seq66101__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__66162 = arguments.length;
switch (G__66162) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_66207){
var state_val_66208 = (state_66207[(1)]);
if((state_val_66208 === (7))){
var state_66207__$1 = state_66207;
var statearr_66209_66346 = state_66207__$1;
(statearr_66209_66346[(2)] = query_map);

(statearr_66209_66346[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66208 === (1))){
var state_66207__$1 = state_66207;
var statearr_66210_66347 = state_66207__$1;
(statearr_66210_66347[(2)] = null);

(statearr_66210_66347[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66208 === (4))){
var inst_66163 = (state_66207[(2)]);
var state_66207__$1 = state_66207;
var statearr_66211_66348 = state_66207__$1;
(statearr_66211_66348[(2)] = inst_66163);

(statearr_66211_66348[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66208 === (13))){
var inst_66185 = (state_66207[(7)]);
var inst_66189 = (state_66207[(2)]);
var inst_66190 = fluree.db.util.async.throw_err(inst_66189);
var inst_66191 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66190,(0),null);
var inst_66192 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66190,(1),null);
var inst_66193 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66194 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66195 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66196 = [inst_66185];
var inst_66197 = (new cljs.core.PersistentVector(null,1,(5),inst_66195,inst_66196,null));
var inst_66198 = ["query",inst_66197,inst_66191];
var inst_66199 = cljs.core.PersistentHashMap.fromArrays(inst_66194,inst_66198);
var inst_66200 = [inst_66199,inst_66192];
var inst_66201 = (new cljs.core.PersistentVector(null,2,(5),inst_66193,inst_66200,null));
var inst_66202 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66201);
var _ = (function (){var statearr_66212 = state_66207;
(statearr_66212[(4)] = cljs.core.rest((state_66207[(4)])));

return statearr_66212;
})();
var state_66207__$1 = (function (){var statearr_66213 = state_66207;
(statearr_66213[(8)] = inst_66202);

return statearr_66213;
})();
var statearr_66214_66349 = state_66207__$1;
(statearr_66214_66349[(2)] = inst_66191);

(statearr_66214_66349[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66208 === (6))){
var state_66207__$1 = state_66207;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66207__$1,(9),query_map);
} else {
if((state_val_66208 === (3))){
var inst_66205 = (state_66207[(2)]);
var state_66207__$1 = state_66207;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66207__$1,inst_66205);
} else {
if((state_val_66208 === (12))){
var inst_66185 = (state_66207[(7)]);
var inst_66185__$1 = (state_66207[(2)]);
var inst_66186 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_66187 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_66186,inst_66185__$1);
var state_66207__$1 = (function (){var statearr_66215 = state_66207;
(statearr_66215[(7)] = inst_66185__$1);

return statearr_66215;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66207__$1,(13),inst_66187);
} else {
if((state_val_66208 === (2))){
var _ = (function (){var statearr_66216 = state_66207;
(statearr_66216[(4)] = cljs.core.cons((5),(state_66207[(4)])));

return statearr_66216;
})();
var inst_66172 = fluree.db.util.async.channel_QMARK_(query_map);
var state_66207__$1 = state_66207;
if(inst_66172){
var statearr_66217_66350 = state_66207__$1;
(statearr_66217_66350[(1)] = (6));

} else {
var statearr_66218_66351 = state_66207__$1;
(statearr_66218_66351[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66208 === (11))){
var inst_66179 = (state_66207[(9)]);
var state_66207__$1 = state_66207;
var statearr_66220_66352 = state_66207__$1;
(statearr_66220_66352[(2)] = inst_66179);

(statearr_66220_66352[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66208 === (9))){
var inst_66175 = (state_66207[(2)]);
var inst_66176 = fluree.db.util.async.throw_err(inst_66175);
var state_66207__$1 = state_66207;
var statearr_66221_66353 = state_66207__$1;
(statearr_66221_66353[(2)] = inst_66176);

(statearr_66221_66353[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66208 === (5))){
var _ = (function (){var statearr_66222 = state_66207;
(statearr_66222[(4)] = cljs.core.rest((state_66207[(4)])));

return statearr_66222;
})();
var state_66207__$1 = state_66207;
var ex66219 = (state_66207__$1[(2)]);
var statearr_66223_66354 = state_66207__$1;
(statearr_66223_66354[(5)] = ex66219);


if((ex66219 instanceof Error)){
var statearr_66224_66355 = state_66207__$1;
(statearr_66224_66355[(1)] = (4));

(statearr_66224_66355[(5)] = null);

} else {
throw ex66219;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66208 === (10))){
var inst_66179 = (state_66207[(9)]);
var inst_66182 = fluree.db.util.json.parse(inst_66179);
var state_66207__$1 = state_66207;
var statearr_66225_66356 = state_66207__$1;
(statearr_66225_66356[(2)] = inst_66182);

(statearr_66225_66356[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66208 === (8))){
var inst_66179 = (state_66207[(9)]);
var inst_66179__$1 = (state_66207[(2)]);
var inst_66180 = typeof inst_66179__$1 === 'string';
var state_66207__$1 = (function (){var statearr_66226 = state_66207;
(statearr_66226[(9)] = inst_66179__$1);

return statearr_66226;
})();
if(cljs.core.truth_(inst_66180)){
var statearr_66227_66357 = state_66207__$1;
(statearr_66227_66357[(1)] = (10));

} else {
var statearr_66228_66358 = state_66207__$1;
(statearr_66228_66358[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11410__auto____0 = (function (){
var statearr_66229 = [null,null,null,null,null,null,null,null,null,null];
(statearr_66229[(0)] = fluree$db$dbfunctions$fns$state_machine__11410__auto__);

(statearr_66229[(1)] = (1));

return statearr_66229;
});
var fluree$db$dbfunctions$fns$state_machine__11410__auto____1 = (function (state_66207){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_66207);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e66230){var ex__11413__auto__ = e66230;
var statearr_66231_66359 = state_66207;
(statearr_66231_66359[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_66207[(4)]))){
var statearr_66232_66360 = state_66207;
(statearr_66232_66360[(1)] = cljs.core.first((state_66207[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66361 = state_66207;
state_66207 = G__66361;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11410__auto__ = function(state_66207){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____1.call(this,state_66207);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_66233 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_66233[(6)] = c__11484__auto__);

return statearr_66233;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_66304){
var state_val_66305 = (state_66304[(1)]);
if((state_val_66305 === (7))){
var state_66304__$1 = state_66304;
var statearr_66306_66362 = state_66304__$1;
(statearr_66306_66362[(2)] = select);

(statearr_66306_66362[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66305 === (20))){
var inst_66274 = (state_66304[(2)]);
var inst_66275 = fluree.db.util.async.channel_QMARK_(limit);
var state_66304__$1 = (function (){var statearr_66307 = state_66304;
(statearr_66307[(7)] = inst_66274);

return statearr_66307;
})();
if(inst_66275){
var statearr_66308_66363 = state_66304__$1;
(statearr_66308_66363[(1)] = (22));

} else {
var statearr_66309_66364 = state_66304__$1;
(statearr_66309_66364[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66305 === (1))){
var state_66304__$1 = state_66304;
var statearr_66310_66365 = state_66304__$1;
(statearr_66310_66365[(2)] = null);

(statearr_66310_66365[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66305 === (24))){
var inst_66250 = (state_66304[(8)]);
var inst_66274 = (state_66304[(7)]);
var inst_66266 = (state_66304[(9)]);
var inst_66258 = (state_66304[(10)]);
var inst_66282 = (state_66304[(2)]);
var inst_66283 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_66284 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_66283,inst_66250,inst_66258,inst_66266,inst_66274,inst_66282);
var state_66304__$1 = state_66304;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66304__$1,(26),inst_66284);
} else {
if((state_val_66305 === (4))){
var inst_66234 = (state_66304[(2)]);
var state_66304__$1 = state_66304;
var statearr_66311_66366 = state_66304__$1;
(statearr_66311_66366[(2)] = inst_66234);

(statearr_66311_66366[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66305 === (15))){
var state_66304__$1 = state_66304;
var statearr_66312_66367 = state_66304__$1;
(statearr_66312_66367[(2)] = where);

(statearr_66312_66367[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66305 === (21))){
var inst_66270 = (state_66304[(2)]);
var inst_66271 = fluree.db.util.async.throw_err(inst_66270);
var state_66304__$1 = state_66304;
var statearr_66313_66368 = state_66304__$1;
(statearr_66313_66368[(2)] = inst_66271);

(statearr_66313_66368[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66305 === (13))){
var inst_66254 = (state_66304[(2)]);
var inst_66255 = fluree.db.util.async.throw_err(inst_66254);
var state_66304__$1 = state_66304;
var statearr_66314_66369 = state_66304__$1;
(statearr_66314_66369[(2)] = inst_66255);

(statearr_66314_66369[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66305 === (22))){
var state_66304__$1 = state_66304;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66304__$1,(25),limit);
} else {
if((state_val_66305 === (6))){
var state_66304__$1 = state_66304;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66304__$1,(9),select);
} else {
if((state_val_66305 === (25))){
var inst_66278 = (state_66304[(2)]);
var inst_66279 = fluree.db.util.async.throw_err(inst_66278);
var state_66304__$1 = state_66304;
var statearr_66315_66370 = state_66304__$1;
(statearr_66315_66370[(2)] = inst_66279);

(statearr_66315_66370[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66305 === (17))){
var inst_66262 = (state_66304[(2)]);
var inst_66263 = fluree.db.util.async.throw_err(inst_66262);
var state_66304__$1 = state_66304;
var statearr_66316_66371 = state_66304__$1;
(statearr_66316_66371[(2)] = inst_66263);

(statearr_66316_66371[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66305 === (3))){
var inst_66302 = (state_66304[(2)]);
var state_66304__$1 = state_66304;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66304__$1,inst_66302);
} else {
if((state_val_66305 === (12))){
var inst_66258 = (state_66304[(2)]);
var inst_66259 = fluree.db.util.async.channel_QMARK_(where);
var state_66304__$1 = (function (){var statearr_66317 = state_66304;
(statearr_66317[(10)] = inst_66258);

return statearr_66317;
})();
if(inst_66259){
var statearr_66318_66372 = state_66304__$1;
(statearr_66318_66372[(1)] = (14));

} else {
var statearr_66319_66373 = state_66304__$1;
(statearr_66319_66373[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66305 === (2))){
var _ = (function (){var statearr_66320 = state_66304;
(statearr_66320[(4)] = cljs.core.cons((5),(state_66304[(4)])));

return statearr_66320;
})();
var inst_66243 = fluree.db.util.async.channel_QMARK_(select);
var state_66304__$1 = state_66304;
if(inst_66243){
var statearr_66321_66374 = state_66304__$1;
(statearr_66321_66374[(1)] = (6));

} else {
var statearr_66322_66375 = state_66304__$1;
(statearr_66322_66375[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66305 === (23))){
var state_66304__$1 = state_66304;
var statearr_66323_66376 = state_66304__$1;
(statearr_66323_66376[(2)] = limit);

(statearr_66323_66376[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66305 === (19))){
var state_66304__$1 = state_66304;
var statearr_66324_66377 = state_66304__$1;
(statearr_66324_66377[(2)] = block);

(statearr_66324_66377[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66305 === (11))){
var state_66304__$1 = state_66304;
var statearr_66326_66378 = state_66304__$1;
(statearr_66326_66378[(2)] = from);

(statearr_66326_66378[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66305 === (9))){
var inst_66246 = (state_66304[(2)]);
var inst_66247 = fluree.db.util.async.throw_err(inst_66246);
var state_66304__$1 = state_66304;
var statearr_66327_66379 = state_66304__$1;
(statearr_66327_66379[(2)] = inst_66247);

(statearr_66327_66379[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66305 === (5))){
var _ = (function (){var statearr_66328 = state_66304;
(statearr_66328[(4)] = cljs.core.rest((state_66304[(4)])));

return statearr_66328;
})();
var state_66304__$1 = state_66304;
var ex66325 = (state_66304__$1[(2)]);
var statearr_66329_66380 = state_66304__$1;
(statearr_66329_66380[(5)] = ex66325);


if((ex66325 instanceof Error)){
var statearr_66330_66381 = state_66304__$1;
(statearr_66330_66381[(1)] = (4));

(statearr_66330_66381[(5)] = null);

} else {
throw ex66325;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66305 === (14))){
var state_66304__$1 = state_66304;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66304__$1,(17),where);
} else {
if((state_val_66305 === (26))){
var inst_66250 = (state_66304[(8)]);
var inst_66274 = (state_66304[(7)]);
var inst_66266 = (state_66304[(9)]);
var inst_66258 = (state_66304[(10)]);
var inst_66286 = (state_66304[(2)]);
var inst_66287 = fluree.db.util.async.throw_err(inst_66286);
var inst_66288 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66287,(0),null);
var inst_66289 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66287,(1),null);
var inst_66290 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66291 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66292 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66293 = [inst_66250,inst_66258,inst_66266,inst_66274];
var inst_66294 = (new cljs.core.PersistentVector(null,4,(5),inst_66292,inst_66293,null));
var inst_66295 = ["query",inst_66294,inst_66288];
var inst_66296 = cljs.core.PersistentHashMap.fromArrays(inst_66291,inst_66295);
var inst_66297 = [inst_66296,inst_66289];
var inst_66298 = (new cljs.core.PersistentVector(null,2,(5),inst_66290,inst_66297,null));
var inst_66299 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66298);
var _ = (function (){var statearr_66331 = state_66304;
(statearr_66331[(4)] = cljs.core.rest((state_66304[(4)])));

return statearr_66331;
})();
var state_66304__$1 = (function (){var statearr_66332 = state_66304;
(statearr_66332[(11)] = inst_66299);

return statearr_66332;
})();
var statearr_66333_66382 = state_66304__$1;
(statearr_66333_66382[(2)] = inst_66288);

(statearr_66333_66382[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66305 === (16))){
var inst_66266 = (state_66304[(2)]);
var inst_66267 = fluree.db.util.async.channel_QMARK_(block);
var state_66304__$1 = (function (){var statearr_66334 = state_66304;
(statearr_66334[(9)] = inst_66266);

return statearr_66334;
})();
if(inst_66267){
var statearr_66335_66383 = state_66304__$1;
(statearr_66335_66383[(1)] = (18));

} else {
var statearr_66336_66384 = state_66304__$1;
(statearr_66336_66384[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66305 === (10))){
var state_66304__$1 = state_66304;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66304__$1,(13),from);
} else {
if((state_val_66305 === (18))){
var state_66304__$1 = state_66304;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66304__$1,(21),block);
} else {
if((state_val_66305 === (8))){
var inst_66250 = (state_66304[(2)]);
var inst_66251 = fluree.db.util.async.channel_QMARK_(from);
var state_66304__$1 = (function (){var statearr_66337 = state_66304;
(statearr_66337[(8)] = inst_66250);

return statearr_66337;
})();
if(inst_66251){
var statearr_66338_66385 = state_66304__$1;
(statearr_66338_66385[(1)] = (10));

} else {
var statearr_66339_66386 = state_66304__$1;
(statearr_66339_66386[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11410__auto____0 = (function (){
var statearr_66340 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66340[(0)] = fluree$db$dbfunctions$fns$state_machine__11410__auto__);

(statearr_66340[(1)] = (1));

return statearr_66340;
});
var fluree$db$dbfunctions$fns$state_machine__11410__auto____1 = (function (state_66304){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_66304);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e66341){var ex__11413__auto__ = e66341;
var statearr_66342_66387 = state_66304;
(statearr_66342_66387[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_66304[(4)]))){
var statearr_66343_66388 = state_66304;
(statearr_66343_66388[(1)] = cljs.core.first((state_66304[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66389 = state_66304;
state_66304 = G__66389;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11410__auto__ = function(state_66304){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____1.call(this,state_66304);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_66344 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_66344[(6)] = c__11484__auto__);

return statearr_66344;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_66445){
var state_val_66446 = (state_66445[(1)]);
if((state_val_66446 === (7))){
var state_66445__$1 = state_66445;
var statearr_66447_66478 = state_66445__$1;
(statearr_66447_66478[(2)] = startSubject);

(statearr_66447_66478[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66446 === (1))){
var state_66445__$1 = state_66445;
var statearr_66448_66479 = state_66445__$1;
(statearr_66448_66479[(2)] = null);

(statearr_66448_66479[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66446 === (4))){
var inst_66390 = (state_66445[(2)]);
var state_66445__$1 = state_66445;
var statearr_66449_66480 = state_66445__$1;
(statearr_66449_66480[(2)] = inst_66390);

(statearr_66449_66480[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66446 === (15))){
var inst_66422 = (state_66445[(2)]);
var inst_66423 = fluree.db.util.async.throw_err(inst_66422);
var inst_66424 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66423,(0),null);
var inst_66425 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66423,(1),null);
var inst_66426 = cljs.core.empty_QMARK_(inst_66424);
var state_66445__$1 = (function (){var statearr_66450 = state_66445;
(statearr_66450[(7)] = inst_66425);

return statearr_66450;
})();
if(inst_66426){
var statearr_66451_66481 = state_66445__$1;
(statearr_66451_66481[(1)] = (16));

} else {
var statearr_66452_66482 = state_66445__$1;
(statearr_66452_66482[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66446 === (13))){
var inst_66418 = (state_66445[(8)]);
var inst_66406 = (state_66445[(9)]);
var inst_66410 = (state_66445[(10)]);
var inst_66418__$1 = (state_66445[(2)]);
var inst_66419 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_66420 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_66419,inst_66406,inst_66410,inst_66418__$1);
var state_66445__$1 = (function (){var statearr_66453 = state_66445;
(statearr_66453[(8)] = inst_66418__$1);

return statearr_66453;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66445__$1,(15),inst_66420);
} else {
if((state_val_66446 === (6))){
var state_66445__$1 = state_66445;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66445__$1,(9),startSubject);
} else {
if((state_val_66446 === (17))){
var state_66445__$1 = state_66445;
var statearr_66454_66483 = state_66445__$1;
(statearr_66454_66483[(2)] = true);

(statearr_66454_66483[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66446 === (3))){
var inst_66443 = (state_66445[(2)]);
var state_66445__$1 = state_66445;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66445__$1,inst_66443);
} else {
if((state_val_66446 === (12))){
var state_66445__$1 = state_66445;
var statearr_66455_66484 = state_66445__$1;
(statearr_66455_66484[(2)] = endSubject);

(statearr_66455_66484[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66446 === (2))){
var _ = (function (){var statearr_66456 = state_66445;
(statearr_66456[(4)] = cljs.core.cons((5),(state_66445[(4)])));

return statearr_66456;
})();
var inst_66399 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_66445__$1 = state_66445;
if(inst_66399){
var statearr_66457_66485 = state_66445__$1;
(statearr_66457_66485[(1)] = (6));

} else {
var statearr_66458_66486 = state_66445__$1;
(statearr_66458_66486[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66446 === (11))){
var state_66445__$1 = state_66445;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66445__$1,(14),endSubject);
} else {
if((state_val_66446 === (9))){
var inst_66402 = (state_66445[(2)]);
var inst_66403 = fluree.db.util.async.throw_err(inst_66402);
var state_66445__$1 = state_66445;
var statearr_66460_66487 = state_66445__$1;
(statearr_66460_66487[(2)] = inst_66403);

(statearr_66460_66487[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66446 === (5))){
var _ = (function (){var statearr_66461 = state_66445;
(statearr_66461[(4)] = cljs.core.rest((state_66445[(4)])));

return statearr_66461;
})();
var state_66445__$1 = state_66445;
var ex66459 = (state_66445__$1[(2)]);
var statearr_66462_66488 = state_66445__$1;
(statearr_66462_66488[(5)] = ex66459);


if((ex66459 instanceof Error)){
var statearr_66463_66489 = state_66445__$1;
(statearr_66463_66489[(1)] = (4));

(statearr_66463_66489[(5)] = null);

} else {
throw ex66459;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66446 === (14))){
var inst_66414 = (state_66445[(2)]);
var inst_66415 = fluree.db.util.async.throw_err(inst_66414);
var state_66445__$1 = state_66445;
var statearr_66464_66490 = state_66445__$1;
(statearr_66464_66490[(2)] = inst_66415);

(statearr_66464_66490[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66446 === (16))){
var state_66445__$1 = state_66445;
var statearr_66465_66491 = state_66445__$1;
(statearr_66465_66491[(2)] = false);

(statearr_66465_66491[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66446 === (10))){
var inst_66409 = (state_66445[(2)]);
var inst_66410 = fluree.db.util.async.throw_err(inst_66409);
var inst_66411 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_66445__$1 = (function (){var statearr_66466 = state_66445;
(statearr_66466[(10)] = inst_66410);

return statearr_66466;
})();
if(inst_66411){
var statearr_66467_66492 = state_66445__$1;
(statearr_66467_66492[(1)] = (11));

} else {
var statearr_66468_66493 = state_66445__$1;
(statearr_66468_66493[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66446 === (18))){
var inst_66418 = (state_66445[(8)]);
var inst_66425 = (state_66445[(7)]);
var inst_66406 = (state_66445[(9)]);
var inst_66410 = (state_66445[(10)]);
var inst_66430 = (state_66445[(2)]);
var inst_66431 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66432 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66433 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66434 = [inst_66406,inst_66410,inst_66418];
var inst_66435 = (new cljs.core.PersistentVector(null,3,(5),inst_66433,inst_66434,null));
var inst_66436 = ["relationship?",inst_66435,inst_66430];
var inst_66437 = cljs.core.PersistentHashMap.fromArrays(inst_66432,inst_66436);
var inst_66438 = [inst_66437,inst_66425];
var inst_66439 = (new cljs.core.PersistentVector(null,2,(5),inst_66431,inst_66438,null));
var inst_66440 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66439);
var _ = (function (){var statearr_66469 = state_66445;
(statearr_66469[(4)] = cljs.core.rest((state_66445[(4)])));

return statearr_66469;
})();
var state_66445__$1 = (function (){var statearr_66470 = state_66445;
(statearr_66470[(11)] = inst_66440);

return statearr_66470;
})();
var statearr_66471_66494 = state_66445__$1;
(statearr_66471_66494[(2)] = inst_66430);

(statearr_66471_66494[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66446 === (8))){
var inst_66406 = (state_66445[(2)]);
var inst_66407 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_66445__$1 = (function (){var statearr_66472 = state_66445;
(statearr_66472[(9)] = inst_66406);

return statearr_66472;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66445__$1,(10),inst_66407);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11410__auto____0 = (function (){
var statearr_66473 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66473[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11410__auto__);

(statearr_66473[(1)] = (1));

return statearr_66473;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11410__auto____1 = (function (state_66445){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_66445);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e66474){var ex__11413__auto__ = e66474;
var statearr_66475_66495 = state_66445;
(statearr_66475_66495[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_66445[(4)]))){
var statearr_66476_66496 = state_66445;
(statearr_66476_66496[(1)] = cljs.core.first((state_66445[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66497 = state_66445;
state_66445 = G__66497;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11410__auto__ = function(state_66445){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11410__auto____1.call(this,state_66445);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_66477 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_66477[(6)] = c__11484__auto__);

return statearr_66477;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_66534){
var state_val_66535 = (state_66534[(1)]);
if((state_val_66535 === (7))){
var state_66534__$1 = state_66534;
var statearr_66536_66556 = state_66534__$1;
(statearr_66536_66556[(2)] = pred_name);

(statearr_66536_66556[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66535 === (1))){
var state_66534__$1 = state_66534;
var statearr_66537_66557 = state_66534__$1;
(statearr_66537_66557[(2)] = null);

(statearr_66537_66557[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66535 === (4))){
var inst_66498 = (state_66534[(2)]);
var state_66534__$1 = state_66534;
var statearr_66538_66558 = state_66534__$1;
(statearr_66538_66558[(2)] = inst_66498);

(statearr_66538_66558[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66535 === (6))){
var state_66534__$1 = state_66534;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66534__$1,(9),pred_name);
} else {
if((state_val_66535 === (3))){
var inst_66532 = (state_66534[(2)]);
var state_66534__$1 = state_66534;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66534__$1,inst_66532);
} else {
if((state_val_66535 === (2))){
var _ = (function (){var statearr_66540 = state_66534;
(statearr_66540[(4)] = cljs.core.cons((5),(state_66534[(4)])));

return statearr_66540;
})();
var inst_66507 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_66534__$1 = state_66534;
if(inst_66507){
var statearr_66541_66559 = state_66534__$1;
(statearr_66541_66559[(1)] = (6));

} else {
var statearr_66542_66560 = state_66534__$1;
(statearr_66542_66560[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66535 === (9))){
var inst_66510 = (state_66534[(2)]);
var inst_66511 = fluree.db.util.async.throw_err(inst_66510);
var state_66534__$1 = state_66534;
var statearr_66543_66561 = state_66534__$1;
(statearr_66543_66561[(2)] = inst_66511);

(statearr_66543_66561[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66535 === (5))){
var _ = (function (){var statearr_66544 = state_66534;
(statearr_66544[(4)] = cljs.core.rest((state_66534[(4)])));

return statearr_66544;
})();
var state_66534__$1 = state_66534;
var ex66539 = (state_66534__$1[(2)]);
var statearr_66545_66562 = state_66534__$1;
(statearr_66545_66562[(5)] = ex66539);


if((ex66539 instanceof Error)){
var statearr_66546_66563 = state_66534__$1;
(statearr_66546_66563[(1)] = (4));

(statearr_66546_66563[(5)] = null);

} else {
throw ex66539;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66535 === (10))){
var inst_66514 = (state_66534[(7)]);
var inst_66518 = (state_66534[(2)]);
var inst_66519 = fluree.db.util.async.throw_err(inst_66518);
var inst_66520 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66519,(0),null);
var inst_66521 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66519,(1),null);
var inst_66522 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66523 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66524 = ["max-pred-val",inst_66514,inst_66520];
var inst_66525 = cljs.core.PersistentHashMap.fromArrays(inst_66523,inst_66524);
var inst_66526 = (inst_66521 + (10));
var inst_66527 = [inst_66525,inst_66526];
var inst_66528 = (new cljs.core.PersistentVector(null,2,(5),inst_66522,inst_66527,null));
var inst_66529 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66528);
var _ = (function (){var statearr_66547 = state_66534;
(statearr_66547[(4)] = cljs.core.rest((state_66534[(4)])));

return statearr_66547;
})();
var state_66534__$1 = (function (){var statearr_66548 = state_66534;
(statearr_66548[(8)] = inst_66529);

return statearr_66548;
})();
var statearr_66549_66564 = state_66534__$1;
(statearr_66549_66564[(2)] = inst_66520);

(statearr_66549_66564[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66535 === (8))){
var inst_66514 = (state_66534[(7)]);
var inst_66514__$1 = (state_66534[(2)]);
var inst_66515 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_66516 = fluree.db.dbfunctions.internal.max_pred_val(inst_66515,inst_66514__$1,null);
var state_66534__$1 = (function (){var statearr_66550 = state_66534;
(statearr_66550[(7)] = inst_66514__$1);

return statearr_66550;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66534__$1,(10),inst_66516);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11410__auto____0 = (function (){
var statearr_66551 = [null,null,null,null,null,null,null,null,null];
(statearr_66551[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11410__auto__);

(statearr_66551[(1)] = (1));

return statearr_66551;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11410__auto____1 = (function (state_66534){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_66534);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e66552){var ex__11413__auto__ = e66552;
var statearr_66553_66565 = state_66534;
(statearr_66553_66565[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_66534[(4)]))){
var statearr_66554_66566 = state_66534;
(statearr_66554_66566[(1)] = cljs.core.first((state_66534[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66567 = state_66534;
state_66534 = G__66567;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11410__auto__ = function(state_66534){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11410__auto____1.call(this,state_66534);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_66555 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_66555[(6)] = c__11484__auto__);

return statearr_66555;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_66594){
var state_val_66595 = (state_66594[(1)]);
if((state_val_66595 === (7))){
var state_66594__$1 = state_66594;
var statearr_66596_66615 = state_66594__$1;
(statearr_66596_66615[(2)] = n);

(statearr_66596_66615[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66595 === (1))){
var state_66594__$1 = state_66594;
var statearr_66597_66616 = state_66594__$1;
(statearr_66597_66616[(2)] = null);

(statearr_66597_66616[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66595 === (4))){
var inst_66568 = (state_66594[(2)]);
var state_66594__$1 = state_66594;
var statearr_66598_66617 = state_66594__$1;
(statearr_66598_66617[(2)] = inst_66568);

(statearr_66598_66617[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66595 === (6))){
var state_66594__$1 = state_66594;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66594__$1,(9),n);
} else {
if((state_val_66595 === (3))){
var inst_66592 = (state_66594[(2)]);
var state_66594__$1 = state_66594;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66594__$1,inst_66592);
} else {
if((state_val_66595 === (2))){
var _ = (function (){var statearr_66600 = state_66594;
(statearr_66600[(4)] = cljs.core.cons((5),(state_66594[(4)])));

return statearr_66600;
})();
var inst_66574 = fluree.db.util.async.channel_QMARK_(n);
var state_66594__$1 = state_66594;
if(inst_66574){
var statearr_66601_66618 = state_66594__$1;
(statearr_66601_66618[(1)] = (6));

} else {
var statearr_66602_66619 = state_66594__$1;
(statearr_66602_66619[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66595 === (9))){
var inst_66577 = (state_66594[(2)]);
var inst_66578 = fluree.db.util.async.throw_err(inst_66577);
var state_66594__$1 = state_66594;
var statearr_66603_66620 = state_66594__$1;
(statearr_66603_66620[(2)] = inst_66578);

(statearr_66603_66620[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66595 === (5))){
var _ = (function (){var statearr_66604 = state_66594;
(statearr_66604[(4)] = cljs.core.rest((state_66594[(4)])));

return statearr_66604;
})();
var state_66594__$1 = state_66594;
var ex66599 = (state_66594__$1[(2)]);
var statearr_66605_66621 = state_66594__$1;
(statearr_66605_66621[(5)] = ex66599);


if((ex66599 instanceof Error)){
var statearr_66606_66622 = state_66594__$1;
(statearr_66606_66622[(1)] = (4));

(statearr_66606_66622[(5)] = null);

} else {
throw ex66599;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66595 === (8))){
var inst_66581 = (state_66594[(2)]);
var inst_66582 = fluree.db.dbfunctions.internal.inc(inst_66581);
var inst_66583 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66584 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66585 = ["inc",inst_66581,inst_66582];
var inst_66586 = cljs.core.PersistentHashMap.fromArrays(inst_66584,inst_66585);
var inst_66587 = [inst_66586,(10)];
var inst_66588 = (new cljs.core.PersistentVector(null,2,(5),inst_66583,inst_66587,null));
var inst_66589 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66588);
var _ = (function (){var statearr_66607 = state_66594;
(statearr_66607[(4)] = cljs.core.rest((state_66594[(4)])));

return statearr_66607;
})();
var state_66594__$1 = (function (){var statearr_66608 = state_66594;
(statearr_66608[(7)] = inst_66589);

return statearr_66608;
})();
var statearr_66609_66623 = state_66594__$1;
(statearr_66609_66623[(2)] = inst_66582);

(statearr_66609_66623[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__11410__auto____0 = (function (){
var statearr_66610 = [null,null,null,null,null,null,null,null];
(statearr_66610[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__11410__auto__);

(statearr_66610[(1)] = (1));

return statearr_66610;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__11410__auto____1 = (function (state_66594){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_66594);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e66611){var ex__11413__auto__ = e66611;
var statearr_66612_66624 = state_66594;
(statearr_66612_66624[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_66594[(4)]))){
var statearr_66613_66625 = state_66594;
(statearr_66613_66625[(1)] = cljs.core.first((state_66594[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66626 = state_66594;
state_66594 = G__66626;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__11410__auto__ = function(state_66594){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__11410__auto____1.call(this,state_66594);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_66614 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_66614[(6)] = c__11484__auto__);

return statearr_66614;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_66653){
var state_val_66654 = (state_66653[(1)]);
if((state_val_66654 === (7))){
var state_66653__$1 = state_66653;
var statearr_66655_66674 = state_66653__$1;
(statearr_66655_66674[(2)] = n);

(statearr_66655_66674[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (1))){
var state_66653__$1 = state_66653;
var statearr_66656_66675 = state_66653__$1;
(statearr_66656_66675[(2)] = null);

(statearr_66656_66675[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (4))){
var inst_66627 = (state_66653[(2)]);
var state_66653__$1 = state_66653;
var statearr_66657_66676 = state_66653__$1;
(statearr_66657_66676[(2)] = inst_66627);

(statearr_66657_66676[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (6))){
var state_66653__$1 = state_66653;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66653__$1,(9),n);
} else {
if((state_val_66654 === (3))){
var inst_66651 = (state_66653[(2)]);
var state_66653__$1 = state_66653;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66653__$1,inst_66651);
} else {
if((state_val_66654 === (2))){
var _ = (function (){var statearr_66659 = state_66653;
(statearr_66659[(4)] = cljs.core.cons((5),(state_66653[(4)])));

return statearr_66659;
})();
var inst_66633 = fluree.db.util.async.channel_QMARK_(n);
var state_66653__$1 = state_66653;
if(inst_66633){
var statearr_66660_66677 = state_66653__$1;
(statearr_66660_66677[(1)] = (6));

} else {
var statearr_66661_66678 = state_66653__$1;
(statearr_66661_66678[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (9))){
var inst_66636 = (state_66653[(2)]);
var inst_66637 = fluree.db.util.async.throw_err(inst_66636);
var state_66653__$1 = state_66653;
var statearr_66662_66679 = state_66653__$1;
(statearr_66662_66679[(2)] = inst_66637);

(statearr_66662_66679[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (5))){
var _ = (function (){var statearr_66663 = state_66653;
(statearr_66663[(4)] = cljs.core.rest((state_66653[(4)])));

return statearr_66663;
})();
var state_66653__$1 = state_66653;
var ex66658 = (state_66653__$1[(2)]);
var statearr_66664_66680 = state_66653__$1;
(statearr_66664_66680[(5)] = ex66658);


if((ex66658 instanceof Error)){
var statearr_66665_66681 = state_66653__$1;
(statearr_66665_66681[(1)] = (4));

(statearr_66665_66681[(5)] = null);

} else {
throw ex66658;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (8))){
var inst_66640 = (state_66653[(2)]);
var inst_66641 = fluree.db.dbfunctions.internal.dec(inst_66640);
var inst_66642 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66643 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66644 = ["dec",inst_66640,inst_66641];
var inst_66645 = cljs.core.PersistentHashMap.fromArrays(inst_66643,inst_66644);
var inst_66646 = [inst_66645,(10)];
var inst_66647 = (new cljs.core.PersistentVector(null,2,(5),inst_66642,inst_66646,null));
var inst_66648 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66647);
var _ = (function (){var statearr_66666 = state_66653;
(statearr_66666[(4)] = cljs.core.rest((state_66653[(4)])));

return statearr_66666;
})();
var state_66653__$1 = (function (){var statearr_66667 = state_66653;
(statearr_66667[(7)] = inst_66648);

return statearr_66667;
})();
var statearr_66668_66682 = state_66653__$1;
(statearr_66668_66682[(2)] = inst_66641);

(statearr_66668_66682[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__11410__auto____0 = (function (){
var statearr_66669 = [null,null,null,null,null,null,null,null];
(statearr_66669[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__11410__auto__);

(statearr_66669[(1)] = (1));

return statearr_66669;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__11410__auto____1 = (function (state_66653){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_66653);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e66670){var ex__11413__auto__ = e66670;
var statearr_66671_66683 = state_66653;
(statearr_66671_66683[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_66653[(4)]))){
var statearr_66672_66684 = state_66653;
(statearr_66672_66684[(1)] = cljs.core.first((state_66653[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66685 = state_66653;
state_66653 = G__66685;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__11410__auto__ = function(state_66653){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__11410__auto____1.call(this,state_66653);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_66673 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_66673[(6)] = c__11484__auto__);

return statearr_66673;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___66735 = arguments.length;
var i__4865__auto___66736 = (0);
while(true){
if((i__4865__auto___66736 < len__4864__auto___66735)){
args__4870__auto__.push((arguments[i__4865__auto___66736]));

var G__66737 = (i__4865__auto___66736 + (1));
i__4865__auto___66736 = G__66737;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_66718){
var state_val_66719 = (state_66718[(1)]);
if((state_val_66719 === (1))){
var state_66718__$1 = state_66718;
var statearr_66720_66738 = state_66718__$1;
(statearr_66720_66738[(2)] = null);

(statearr_66720_66738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66719 === (2))){
var _ = (function (){var statearr_66721 = state_66718;
(statearr_66721[(4)] = cljs.core.cons((5),(state_66718[(4)])));

return statearr_66721;
})();
var inst_66694 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66718__$1 = state_66718;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66718__$1,(6),inst_66694);
} else {
if((state_val_66719 === (3))){
var inst_66716 = (state_66718[(2)]);
var state_66718__$1 = state_66718;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66718__$1,inst_66716);
} else {
if((state_val_66719 === (4))){
var inst_66688 = (state_66718[(2)]);
var state_66718__$1 = state_66718;
var statearr_66723_66739 = state_66718__$1;
(statearr_66723_66739[(2)] = inst_66688);

(statearr_66723_66739[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66719 === (5))){
var _ = (function (){var statearr_66724 = state_66718;
(statearr_66724[(4)] = cljs.core.rest((state_66718[(4)])));

return statearr_66724;
})();
var state_66718__$1 = state_66718;
var ex66722 = (state_66718__$1[(2)]);
var statearr_66725_66740 = state_66718__$1;
(statearr_66725_66740[(5)] = ex66722);


if((ex66722 instanceof Error)){
var statearr_66726_66741 = state_66718__$1;
(statearr_66726_66741[(1)] = (4));

(statearr_66726_66741[(5)] = null);

} else {
throw ex66722;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66719 === (6))){
var inst_66696 = (state_66718[(2)]);
var inst_66697 = fluree.db.util.async.throw_err(inst_66696);
var inst_66698 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_66697);
var inst_66699 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66700 = [inst_66697];
var inst_66701 = (new cljs.core.PersistentVector(null,1,(5),inst_66699,inst_66700,null));
var inst_66702 = cljs.core.count(inst_66701);
var inst_66703 = ((9) + inst_66702);
var inst_66704 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66705 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66706 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66707 = [inst_66697];
var inst_66708 = (new cljs.core.PersistentVector(null,1,(5),inst_66706,inst_66707,null));
var inst_66709 = ["+",inst_66708,inst_66698];
var inst_66710 = cljs.core.PersistentHashMap.fromArrays(inst_66705,inst_66709);
var inst_66711 = [inst_66710,inst_66703];
var inst_66712 = (new cljs.core.PersistentVector(null,2,(5),inst_66704,inst_66711,null));
var inst_66713 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66712);
var _ = (function (){var statearr_66727 = state_66718;
(statearr_66727[(4)] = cljs.core.rest((state_66718[(4)])));

return statearr_66727;
})();
var state_66718__$1 = (function (){var statearr_66728 = state_66718;
(statearr_66728[(7)] = inst_66713);

return statearr_66728;
})();
var statearr_66729_66742 = state_66718__$1;
(statearr_66729_66742[(2)] = inst_66698);

(statearr_66729_66742[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11410__auto____0 = (function (){
var statearr_66730 = [null,null,null,null,null,null,null,null];
(statearr_66730[(0)] = fluree$db$dbfunctions$fns$state_machine__11410__auto__);

(statearr_66730[(1)] = (1));

return statearr_66730;
});
var fluree$db$dbfunctions$fns$state_machine__11410__auto____1 = (function (state_66718){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_66718);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e66731){var ex__11413__auto__ = e66731;
var statearr_66732_66743 = state_66718;
(statearr_66732_66743[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_66718[(4)]))){
var statearr_66733_66744 = state_66718;
(statearr_66733_66744[(1)] = cljs.core.first((state_66718[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66745 = state_66718;
state_66718 = G__66745;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11410__auto__ = function(state_66718){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____1.call(this,state_66718);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_66734 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_66734[(6)] = c__11484__auto__);

return statearr_66734;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq66686){
var G__66687 = cljs.core.first(seq66686);
var seq66686__$1 = cljs.core.next(seq66686);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66687,seq66686__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___66795 = arguments.length;
var i__4865__auto___66796 = (0);
while(true){
if((i__4865__auto___66796 < len__4864__auto___66795)){
args__4870__auto__.push((arguments[i__4865__auto___66796]));

var G__66797 = (i__4865__auto___66796 + (1));
i__4865__auto___66796 = G__66797;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_66778){
var state_val_66779 = (state_66778[(1)]);
if((state_val_66779 === (1))){
var state_66778__$1 = state_66778;
var statearr_66780_66798 = state_66778__$1;
(statearr_66780_66798[(2)] = null);

(statearr_66780_66798[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66779 === (2))){
var _ = (function (){var statearr_66781 = state_66778;
(statearr_66781[(4)] = cljs.core.cons((5),(state_66778[(4)])));

return statearr_66781;
})();
var inst_66754 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66778__$1 = state_66778;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66778__$1,(6),inst_66754);
} else {
if((state_val_66779 === (3))){
var inst_66776 = (state_66778[(2)]);
var state_66778__$1 = state_66778;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66778__$1,inst_66776);
} else {
if((state_val_66779 === (4))){
var inst_66748 = (state_66778[(2)]);
var state_66778__$1 = state_66778;
var statearr_66783_66799 = state_66778__$1;
(statearr_66783_66799[(2)] = inst_66748);

(statearr_66783_66799[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66779 === (5))){
var _ = (function (){var statearr_66784 = state_66778;
(statearr_66784[(4)] = cljs.core.rest((state_66778[(4)])));

return statearr_66784;
})();
var state_66778__$1 = state_66778;
var ex66782 = (state_66778__$1[(2)]);
var statearr_66785_66800 = state_66778__$1;
(statearr_66785_66800[(5)] = ex66782);


if((ex66782 instanceof Error)){
var statearr_66786_66801 = state_66778__$1;
(statearr_66786_66801[(1)] = (4));

(statearr_66786_66801[(5)] = null);

} else {
throw ex66782;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66779 === (6))){
var inst_66756 = (state_66778[(2)]);
var inst_66757 = fluree.db.util.async.throw_err(inst_66756);
var inst_66758 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_66757);
var inst_66759 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66760 = [inst_66757];
var inst_66761 = (new cljs.core.PersistentVector(null,1,(5),inst_66759,inst_66760,null));
var inst_66762 = cljs.core.count(inst_66761);
var inst_66763 = ((9) + inst_66762);
var inst_66764 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66765 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66766 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66767 = [inst_66757];
var inst_66768 = (new cljs.core.PersistentVector(null,1,(5),inst_66766,inst_66767,null));
var inst_66769 = ["-",inst_66768,inst_66758];
var inst_66770 = cljs.core.PersistentHashMap.fromArrays(inst_66765,inst_66769);
var inst_66771 = [inst_66770,inst_66763];
var inst_66772 = (new cljs.core.PersistentVector(null,2,(5),inst_66764,inst_66771,null));
var inst_66773 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66772);
var _ = (function (){var statearr_66787 = state_66778;
(statearr_66787[(4)] = cljs.core.rest((state_66778[(4)])));

return statearr_66787;
})();
var state_66778__$1 = (function (){var statearr_66788 = state_66778;
(statearr_66788[(7)] = inst_66773);

return statearr_66788;
})();
var statearr_66789_66802 = state_66778__$1;
(statearr_66789_66802[(2)] = inst_66758);

(statearr_66789_66802[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11410__auto____0 = (function (){
var statearr_66790 = [null,null,null,null,null,null,null,null];
(statearr_66790[(0)] = fluree$db$dbfunctions$fns$state_machine__11410__auto__);

(statearr_66790[(1)] = (1));

return statearr_66790;
});
var fluree$db$dbfunctions$fns$state_machine__11410__auto____1 = (function (state_66778){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_66778);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e66791){var ex__11413__auto__ = e66791;
var statearr_66792_66803 = state_66778;
(statearr_66792_66803[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_66778[(4)]))){
var statearr_66793_66804 = state_66778;
(statearr_66793_66804[(1)] = cljs.core.first((state_66778[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66805 = state_66778;
state_66778 = G__66805;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11410__auto__ = function(state_66778){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____1.call(this,state_66778);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_66794 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_66794[(6)] = c__11484__auto__);

return statearr_66794;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq66746){
var G__66747 = cljs.core.first(seq66746);
var seq66746__$1 = cljs.core.next(seq66746);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66747,seq66746__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___66855 = arguments.length;
var i__4865__auto___66856 = (0);
while(true){
if((i__4865__auto___66856 < len__4864__auto___66855)){
args__4870__auto__.push((arguments[i__4865__auto___66856]));

var G__66857 = (i__4865__auto___66856 + (1));
i__4865__auto___66856 = G__66857;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_66838){
var state_val_66839 = (state_66838[(1)]);
if((state_val_66839 === (1))){
var state_66838__$1 = state_66838;
var statearr_66840_66858 = state_66838__$1;
(statearr_66840_66858[(2)] = null);

(statearr_66840_66858[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66839 === (2))){
var _ = (function (){var statearr_66841 = state_66838;
(statearr_66841[(4)] = cljs.core.cons((5),(state_66838[(4)])));

return statearr_66841;
})();
var inst_66814 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66838__$1 = state_66838;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66838__$1,(6),inst_66814);
} else {
if((state_val_66839 === (3))){
var inst_66836 = (state_66838[(2)]);
var state_66838__$1 = state_66838;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66838__$1,inst_66836);
} else {
if((state_val_66839 === (4))){
var inst_66808 = (state_66838[(2)]);
var state_66838__$1 = state_66838;
var statearr_66843_66859 = state_66838__$1;
(statearr_66843_66859[(2)] = inst_66808);

(statearr_66843_66859[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66839 === (5))){
var _ = (function (){var statearr_66844 = state_66838;
(statearr_66844[(4)] = cljs.core.rest((state_66838[(4)])));

return statearr_66844;
})();
var state_66838__$1 = state_66838;
var ex66842 = (state_66838__$1[(2)]);
var statearr_66845_66860 = state_66838__$1;
(statearr_66845_66860[(5)] = ex66842);


if((ex66842 instanceof Error)){
var statearr_66846_66861 = state_66838__$1;
(statearr_66846_66861[(1)] = (4));

(statearr_66846_66861[(5)] = null);

} else {
throw ex66842;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66839 === (6))){
var inst_66816 = (state_66838[(2)]);
var inst_66817 = fluree.db.util.async.throw_err(inst_66816);
var inst_66818 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_66817);
var inst_66819 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66820 = [inst_66817];
var inst_66821 = (new cljs.core.PersistentVector(null,1,(5),inst_66819,inst_66820,null));
var inst_66822 = cljs.core.count(inst_66821);
var inst_66823 = ((9) + inst_66822);
var inst_66824 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66825 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66826 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66827 = [inst_66817];
var inst_66828 = (new cljs.core.PersistentVector(null,1,(5),inst_66826,inst_66827,null));
var inst_66829 = ["*",inst_66828,inst_66818];
var inst_66830 = cljs.core.PersistentHashMap.fromArrays(inst_66825,inst_66829);
var inst_66831 = [inst_66830,inst_66823];
var inst_66832 = (new cljs.core.PersistentVector(null,2,(5),inst_66824,inst_66831,null));
var inst_66833 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66832);
var _ = (function (){var statearr_66847 = state_66838;
(statearr_66847[(4)] = cljs.core.rest((state_66838[(4)])));

return statearr_66847;
})();
var state_66838__$1 = (function (){var statearr_66848 = state_66838;
(statearr_66848[(7)] = inst_66833);

return statearr_66848;
})();
var statearr_66849_66862 = state_66838__$1;
(statearr_66849_66862[(2)] = inst_66818);

(statearr_66849_66862[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11410__auto____0 = (function (){
var statearr_66850 = [null,null,null,null,null,null,null,null];
(statearr_66850[(0)] = fluree$db$dbfunctions$fns$state_machine__11410__auto__);

(statearr_66850[(1)] = (1));

return statearr_66850;
});
var fluree$db$dbfunctions$fns$state_machine__11410__auto____1 = (function (state_66838){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_66838);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e66851){var ex__11413__auto__ = e66851;
var statearr_66852_66863 = state_66838;
(statearr_66852_66863[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_66838[(4)]))){
var statearr_66853_66864 = state_66838;
(statearr_66853_66864[(1)] = cljs.core.first((state_66838[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66865 = state_66838;
state_66838 = G__66865;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11410__auto__ = function(state_66838){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____1.call(this,state_66838);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_66854 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_66854[(6)] = c__11484__auto__);

return statearr_66854;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq66806){
var G__66807 = cljs.core.first(seq66806);
var seq66806__$1 = cljs.core.next(seq66806);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66807,seq66806__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___66915 = arguments.length;
var i__4865__auto___66916 = (0);
while(true){
if((i__4865__auto___66916 < len__4864__auto___66915)){
args__4870__auto__.push((arguments[i__4865__auto___66916]));

var G__66917 = (i__4865__auto___66916 + (1));
i__4865__auto___66916 = G__66917;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_66898){
var state_val_66899 = (state_66898[(1)]);
if((state_val_66899 === (1))){
var state_66898__$1 = state_66898;
var statearr_66900_66918 = state_66898__$1;
(statearr_66900_66918[(2)] = null);

(statearr_66900_66918[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66899 === (2))){
var _ = (function (){var statearr_66901 = state_66898;
(statearr_66901[(4)] = cljs.core.cons((5),(state_66898[(4)])));

return statearr_66901;
})();
var inst_66874 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66898__$1 = state_66898;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66898__$1,(6),inst_66874);
} else {
if((state_val_66899 === (3))){
var inst_66896 = (state_66898[(2)]);
var state_66898__$1 = state_66898;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66898__$1,inst_66896);
} else {
if((state_val_66899 === (4))){
var inst_66868 = (state_66898[(2)]);
var state_66898__$1 = state_66898;
var statearr_66903_66919 = state_66898__$1;
(statearr_66903_66919[(2)] = inst_66868);

(statearr_66903_66919[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66899 === (5))){
var _ = (function (){var statearr_66904 = state_66898;
(statearr_66904[(4)] = cljs.core.rest((state_66898[(4)])));

return statearr_66904;
})();
var state_66898__$1 = state_66898;
var ex66902 = (state_66898__$1[(2)]);
var statearr_66905_66920 = state_66898__$1;
(statearr_66905_66920[(5)] = ex66902);


if((ex66902 instanceof Error)){
var statearr_66906_66921 = state_66898__$1;
(statearr_66906_66921[(1)] = (4));

(statearr_66906_66921[(5)] = null);

} else {
throw ex66902;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66899 === (6))){
var inst_66876 = (state_66898[(2)]);
var inst_66877 = fluree.db.util.async.throw_err(inst_66876);
var inst_66878 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_66877);
var inst_66879 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66880 = [inst_66877];
var inst_66881 = (new cljs.core.PersistentVector(null,1,(5),inst_66879,inst_66880,null));
var inst_66882 = cljs.core.count(inst_66881);
var inst_66883 = ((9) + inst_66882);
var inst_66884 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66885 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66886 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66887 = [inst_66877];
var inst_66888 = (new cljs.core.PersistentVector(null,1,(5),inst_66886,inst_66887,null));
var inst_66889 = ["/",inst_66888,inst_66878];
var inst_66890 = cljs.core.PersistentHashMap.fromArrays(inst_66885,inst_66889);
var inst_66891 = [inst_66890,inst_66883];
var inst_66892 = (new cljs.core.PersistentVector(null,2,(5),inst_66884,inst_66891,null));
var inst_66893 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66892);
var _ = (function (){var statearr_66907 = state_66898;
(statearr_66907[(4)] = cljs.core.rest((state_66898[(4)])));

return statearr_66907;
})();
var state_66898__$1 = (function (){var statearr_66908 = state_66898;
(statearr_66908[(7)] = inst_66893);

return statearr_66908;
})();
var statearr_66909_66922 = state_66898__$1;
(statearr_66909_66922[(2)] = inst_66878);

(statearr_66909_66922[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11410__auto____0 = (function (){
var statearr_66910 = [null,null,null,null,null,null,null,null];
(statearr_66910[(0)] = fluree$db$dbfunctions$fns$state_machine__11410__auto__);

(statearr_66910[(1)] = (1));

return statearr_66910;
});
var fluree$db$dbfunctions$fns$state_machine__11410__auto____1 = (function (state_66898){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_66898);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e66911){var ex__11413__auto__ = e66911;
var statearr_66912_66923 = state_66898;
(statearr_66912_66923[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_66898[(4)]))){
var statearr_66913_66924 = state_66898;
(statearr_66913_66924[(1)] = cljs.core.first((state_66898[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66925 = state_66898;
state_66898 = G__66925;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11410__auto__ = function(state_66898){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____1.call(this,state_66898);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_66914 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_66914[(6)] = c__11484__auto__);

return statearr_66914;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq66866){
var G__66867 = cljs.core.first(seq66866);
var seq66866__$1 = cljs.core.next(seq66866);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66867,seq66866__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_66963){
var state_val_66964 = (state_66963[(1)]);
if((state_val_66964 === (7))){
var state_66963__$1 = state_66963;
var statearr_66965_66989 = state_66963__$1;
(statearr_66965_66989[(2)] = n);

(statearr_66965_66989[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66964 === (1))){
var state_66963__$1 = state_66963;
var statearr_66966_66990 = state_66963__$1;
(statearr_66966_66990[(2)] = null);

(statearr_66966_66990[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66964 === (4))){
var inst_66926 = (state_66963[(2)]);
var state_66963__$1 = state_66963;
var statearr_66967_66991 = state_66963__$1;
(statearr_66967_66991[(2)] = inst_66926);

(statearr_66967_66991[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66964 === (13))){
var inst_66943 = (state_66963[(2)]);
var inst_66944 = fluree.db.util.async.throw_err(inst_66943);
var state_66963__$1 = state_66963;
var statearr_66968_66992 = state_66963__$1;
(statearr_66968_66992[(2)] = inst_66944);

(statearr_66968_66992[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66964 === (6))){
var state_66963__$1 = state_66963;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66963__$1,(9),n);
} else {
if((state_val_66964 === (3))){
var inst_66961 = (state_66963[(2)]);
var state_66963__$1 = state_66963;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66963__$1,inst_66961);
} else {
if((state_val_66964 === (12))){
var inst_66939 = (state_66963[(7)]);
var inst_66947 = (state_66963[(2)]);
var inst_66948 = fluree.db.dbfunctions.internal.quot(inst_66939,inst_66947);
var inst_66949 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66950 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66951 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66952 = [inst_66939,inst_66947];
var inst_66953 = (new cljs.core.PersistentVector(null,2,(5),inst_66951,inst_66952,null));
var inst_66954 = ["quot",inst_66953,inst_66948];
var inst_66955 = cljs.core.PersistentHashMap.fromArrays(inst_66950,inst_66954);
var inst_66956 = [inst_66955,(2)];
var inst_66957 = (new cljs.core.PersistentVector(null,2,(5),inst_66949,inst_66956,null));
var inst_66958 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66957);
var _ = (function (){var statearr_66969 = state_66963;
(statearr_66969[(4)] = cljs.core.rest((state_66963[(4)])));

return statearr_66969;
})();
var state_66963__$1 = (function (){var statearr_66970 = state_66963;
(statearr_66970[(8)] = inst_66958);

return statearr_66970;
})();
var statearr_66971_66993 = state_66963__$1;
(statearr_66971_66993[(2)] = inst_66948);

(statearr_66971_66993[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66964 === (2))){
var _ = (function (){var statearr_66972 = state_66963;
(statearr_66972[(4)] = cljs.core.cons((5),(state_66963[(4)])));

return statearr_66972;
})();
var inst_66932 = fluree.db.util.async.channel_QMARK_(n);
var state_66963__$1 = state_66963;
if(inst_66932){
var statearr_66973_66994 = state_66963__$1;
(statearr_66973_66994[(1)] = (6));

} else {
var statearr_66974_66995 = state_66963__$1;
(statearr_66974_66995[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66964 === (11))){
var state_66963__$1 = state_66963;
var statearr_66976_66996 = state_66963__$1;
(statearr_66976_66996[(2)] = d);

(statearr_66976_66996[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66964 === (9))){
var inst_66935 = (state_66963[(2)]);
var inst_66936 = fluree.db.util.async.throw_err(inst_66935);
var state_66963__$1 = state_66963;
var statearr_66977_66997 = state_66963__$1;
(statearr_66977_66997[(2)] = inst_66936);

(statearr_66977_66997[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66964 === (5))){
var _ = (function (){var statearr_66978 = state_66963;
(statearr_66978[(4)] = cljs.core.rest((state_66963[(4)])));

return statearr_66978;
})();
var state_66963__$1 = state_66963;
var ex66975 = (state_66963__$1[(2)]);
var statearr_66979_66998 = state_66963__$1;
(statearr_66979_66998[(5)] = ex66975);


if((ex66975 instanceof Error)){
var statearr_66980_66999 = state_66963__$1;
(statearr_66980_66999[(1)] = (4));

(statearr_66980_66999[(5)] = null);

} else {
throw ex66975;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66964 === (10))){
var state_66963__$1 = state_66963;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66963__$1,(13),d);
} else {
if((state_val_66964 === (8))){
var inst_66939 = (state_66963[(2)]);
var inst_66940 = fluree.db.util.async.channel_QMARK_(d);
var state_66963__$1 = (function (){var statearr_66981 = state_66963;
(statearr_66981[(7)] = inst_66939);

return statearr_66981;
})();
if(inst_66940){
var statearr_66982_67000 = state_66963__$1;
(statearr_66982_67000[(1)] = (10));

} else {
var statearr_66983_67001 = state_66963__$1;
(statearr_66983_67001[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__11410__auto____0 = (function (){
var statearr_66984 = [null,null,null,null,null,null,null,null,null];
(statearr_66984[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__11410__auto__);

(statearr_66984[(1)] = (1));

return statearr_66984;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__11410__auto____1 = (function (state_66963){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_66963);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e66985){var ex__11413__auto__ = e66985;
var statearr_66986_67002 = state_66963;
(statearr_66986_67002[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_66963[(4)]))){
var statearr_66987_67003 = state_66963;
(statearr_66987_67003[(1)] = cljs.core.first((state_66963[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67004 = state_66963;
state_66963 = G__67004;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__11410__auto__ = function(state_66963){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__11410__auto____1.call(this,state_66963);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_66988 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_66988[(6)] = c__11484__auto__);

return statearr_66988;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_67042){
var state_val_67043 = (state_67042[(1)]);
if((state_val_67043 === (7))){
var state_67042__$1 = state_67042;
var statearr_67044_67068 = state_67042__$1;
(statearr_67044_67068[(2)] = n);

(statearr_67044_67068[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67043 === (1))){
var state_67042__$1 = state_67042;
var statearr_67045_67069 = state_67042__$1;
(statearr_67045_67069[(2)] = null);

(statearr_67045_67069[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67043 === (4))){
var inst_67005 = (state_67042[(2)]);
var state_67042__$1 = state_67042;
var statearr_67046_67070 = state_67042__$1;
(statearr_67046_67070[(2)] = inst_67005);

(statearr_67046_67070[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67043 === (13))){
var inst_67022 = (state_67042[(2)]);
var inst_67023 = fluree.db.util.async.throw_err(inst_67022);
var state_67042__$1 = state_67042;
var statearr_67047_67071 = state_67042__$1;
(statearr_67047_67071[(2)] = inst_67023);

(statearr_67047_67071[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67043 === (6))){
var state_67042__$1 = state_67042;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67042__$1,(9),n);
} else {
if((state_val_67043 === (3))){
var inst_67040 = (state_67042[(2)]);
var state_67042__$1 = state_67042;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67042__$1,inst_67040);
} else {
if((state_val_67043 === (12))){
var inst_67018 = (state_67042[(7)]);
var inst_67026 = (state_67042[(2)]);
var inst_67027 = fluree.db.dbfunctions.internal.mod(inst_67018,inst_67026);
var inst_67028 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67029 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67030 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67031 = [inst_67018,inst_67026];
var inst_67032 = (new cljs.core.PersistentVector(null,2,(5),inst_67030,inst_67031,null));
var inst_67033 = ["mod",inst_67032,inst_67027];
var inst_67034 = cljs.core.PersistentHashMap.fromArrays(inst_67029,inst_67033);
var inst_67035 = [inst_67034,(2)];
var inst_67036 = (new cljs.core.PersistentVector(null,2,(5),inst_67028,inst_67035,null));
var inst_67037 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67036);
var _ = (function (){var statearr_67048 = state_67042;
(statearr_67048[(4)] = cljs.core.rest((state_67042[(4)])));

return statearr_67048;
})();
var state_67042__$1 = (function (){var statearr_67049 = state_67042;
(statearr_67049[(8)] = inst_67037);

return statearr_67049;
})();
var statearr_67050_67072 = state_67042__$1;
(statearr_67050_67072[(2)] = inst_67027);

(statearr_67050_67072[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67043 === (2))){
var _ = (function (){var statearr_67051 = state_67042;
(statearr_67051[(4)] = cljs.core.cons((5),(state_67042[(4)])));

return statearr_67051;
})();
var inst_67011 = fluree.db.util.async.channel_QMARK_(n);
var state_67042__$1 = state_67042;
if(inst_67011){
var statearr_67052_67073 = state_67042__$1;
(statearr_67052_67073[(1)] = (6));

} else {
var statearr_67053_67074 = state_67042__$1;
(statearr_67053_67074[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67043 === (11))){
var state_67042__$1 = state_67042;
var statearr_67055_67075 = state_67042__$1;
(statearr_67055_67075[(2)] = d);

(statearr_67055_67075[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67043 === (9))){
var inst_67014 = (state_67042[(2)]);
var inst_67015 = fluree.db.util.async.throw_err(inst_67014);
var state_67042__$1 = state_67042;
var statearr_67056_67076 = state_67042__$1;
(statearr_67056_67076[(2)] = inst_67015);

(statearr_67056_67076[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67043 === (5))){
var _ = (function (){var statearr_67057 = state_67042;
(statearr_67057[(4)] = cljs.core.rest((state_67042[(4)])));

return statearr_67057;
})();
var state_67042__$1 = state_67042;
var ex67054 = (state_67042__$1[(2)]);
var statearr_67058_67077 = state_67042__$1;
(statearr_67058_67077[(5)] = ex67054);


if((ex67054 instanceof Error)){
var statearr_67059_67078 = state_67042__$1;
(statearr_67059_67078[(1)] = (4));

(statearr_67059_67078[(5)] = null);

} else {
throw ex67054;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67043 === (10))){
var state_67042__$1 = state_67042;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67042__$1,(13),d);
} else {
if((state_val_67043 === (8))){
var inst_67018 = (state_67042[(2)]);
var inst_67019 = fluree.db.util.async.channel_QMARK_(d);
var state_67042__$1 = (function (){var statearr_67060 = state_67042;
(statearr_67060[(7)] = inst_67018);

return statearr_67060;
})();
if(inst_67019){
var statearr_67061_67079 = state_67042__$1;
(statearr_67061_67079[(1)] = (10));

} else {
var statearr_67062_67080 = state_67042__$1;
(statearr_67062_67080[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__11410__auto____0 = (function (){
var statearr_67063 = [null,null,null,null,null,null,null,null,null];
(statearr_67063[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__11410__auto__);

(statearr_67063[(1)] = (1));

return statearr_67063;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__11410__auto____1 = (function (state_67042){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_67042);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e67064){var ex__11413__auto__ = e67064;
var statearr_67065_67081 = state_67042;
(statearr_67065_67081[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_67042[(4)]))){
var statearr_67066_67082 = state_67042;
(statearr_67066_67082[(1)] = cljs.core.first((state_67042[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67083 = state_67042;
state_67042 = G__67083;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__11410__auto__ = function(state_67042){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__11410__auto____1.call(this,state_67042);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_67067 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_67067[(6)] = c__11484__auto__);

return statearr_67067;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_67121){
var state_val_67122 = (state_67121[(1)]);
if((state_val_67122 === (7))){
var state_67121__$1 = state_67121;
var statearr_67123_67147 = state_67121__$1;
(statearr_67123_67147[(2)] = n);

(statearr_67123_67147[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67122 === (1))){
var state_67121__$1 = state_67121;
var statearr_67124_67148 = state_67121__$1;
(statearr_67124_67148[(2)] = null);

(statearr_67124_67148[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67122 === (4))){
var inst_67084 = (state_67121[(2)]);
var state_67121__$1 = state_67121;
var statearr_67125_67149 = state_67121__$1;
(statearr_67125_67149[(2)] = inst_67084);

(statearr_67125_67149[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67122 === (13))){
var inst_67101 = (state_67121[(2)]);
var inst_67102 = fluree.db.util.async.throw_err(inst_67101);
var state_67121__$1 = state_67121;
var statearr_67126_67150 = state_67121__$1;
(statearr_67126_67150[(2)] = inst_67102);

(statearr_67126_67150[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67122 === (6))){
var state_67121__$1 = state_67121;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67121__$1,(9),n);
} else {
if((state_val_67122 === (3))){
var inst_67119 = (state_67121[(2)]);
var state_67121__$1 = state_67121;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67121__$1,inst_67119);
} else {
if((state_val_67122 === (12))){
var inst_67097 = (state_67121[(7)]);
var inst_67105 = (state_67121[(2)]);
var inst_67106 = fluree.db.dbfunctions.internal.rem(inst_67097,inst_67105);
var inst_67107 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67108 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67109 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67110 = [inst_67097,inst_67105];
var inst_67111 = (new cljs.core.PersistentVector(null,2,(5),inst_67109,inst_67110,null));
var inst_67112 = ["rem",inst_67111,inst_67106];
var inst_67113 = cljs.core.PersistentHashMap.fromArrays(inst_67108,inst_67112);
var inst_67114 = [inst_67113,(2)];
var inst_67115 = (new cljs.core.PersistentVector(null,2,(5),inst_67107,inst_67114,null));
var inst_67116 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67115);
var _ = (function (){var statearr_67127 = state_67121;
(statearr_67127[(4)] = cljs.core.rest((state_67121[(4)])));

return statearr_67127;
})();
var state_67121__$1 = (function (){var statearr_67128 = state_67121;
(statearr_67128[(8)] = inst_67116);

return statearr_67128;
})();
var statearr_67129_67151 = state_67121__$1;
(statearr_67129_67151[(2)] = inst_67106);

(statearr_67129_67151[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67122 === (2))){
var _ = (function (){var statearr_67130 = state_67121;
(statearr_67130[(4)] = cljs.core.cons((5),(state_67121[(4)])));

return statearr_67130;
})();
var inst_67090 = fluree.db.util.async.channel_QMARK_(n);
var state_67121__$1 = state_67121;
if(inst_67090){
var statearr_67131_67152 = state_67121__$1;
(statearr_67131_67152[(1)] = (6));

} else {
var statearr_67132_67153 = state_67121__$1;
(statearr_67132_67153[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67122 === (11))){
var state_67121__$1 = state_67121;
var statearr_67134_67154 = state_67121__$1;
(statearr_67134_67154[(2)] = d);

(statearr_67134_67154[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67122 === (9))){
var inst_67093 = (state_67121[(2)]);
var inst_67094 = fluree.db.util.async.throw_err(inst_67093);
var state_67121__$1 = state_67121;
var statearr_67135_67155 = state_67121__$1;
(statearr_67135_67155[(2)] = inst_67094);

(statearr_67135_67155[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67122 === (5))){
var _ = (function (){var statearr_67136 = state_67121;
(statearr_67136[(4)] = cljs.core.rest((state_67121[(4)])));

return statearr_67136;
})();
var state_67121__$1 = state_67121;
var ex67133 = (state_67121__$1[(2)]);
var statearr_67137_67156 = state_67121__$1;
(statearr_67137_67156[(5)] = ex67133);


if((ex67133 instanceof Error)){
var statearr_67138_67157 = state_67121__$1;
(statearr_67138_67157[(1)] = (4));

(statearr_67138_67157[(5)] = null);

} else {
throw ex67133;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67122 === (10))){
var state_67121__$1 = state_67121;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67121__$1,(13),d);
} else {
if((state_val_67122 === (8))){
var inst_67097 = (state_67121[(2)]);
var inst_67098 = fluree.db.util.async.channel_QMARK_(d);
var state_67121__$1 = (function (){var statearr_67139 = state_67121;
(statearr_67139[(7)] = inst_67097);

return statearr_67139;
})();
if(inst_67098){
var statearr_67140_67158 = state_67121__$1;
(statearr_67140_67158[(1)] = (10));

} else {
var statearr_67141_67159 = state_67121__$1;
(statearr_67141_67159[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__11410__auto____0 = (function (){
var statearr_67142 = [null,null,null,null,null,null,null,null,null];
(statearr_67142[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__11410__auto__);

(statearr_67142[(1)] = (1));

return statearr_67142;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__11410__auto____1 = (function (state_67121){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_67121);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e67143){var ex__11413__auto__ = e67143;
var statearr_67144_67160 = state_67121;
(statearr_67144_67160[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_67121[(4)]))){
var statearr_67145_67161 = state_67121;
(statearr_67145_67161[(1)] = cljs.core.first((state_67121[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67162 = state_67121;
state_67121 = G__67162;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__11410__auto__ = function(state_67121){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__11410__auto____1.call(this,state_67121);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_67146 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_67146[(6)] = c__11484__auto__);

return statearr_67146;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_67189){
var state_val_67190 = (state_67189[(1)]);
if((state_val_67190 === (7))){
var state_67189__$1 = state_67189;
var statearr_67191_67210 = state_67189__$1;
(statearr_67191_67210[(2)] = x);

(statearr_67191_67210[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67190 === (1))){
var state_67189__$1 = state_67189;
var statearr_67192_67211 = state_67189__$1;
(statearr_67192_67211[(2)] = null);

(statearr_67192_67211[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67190 === (4))){
var inst_67163 = (state_67189[(2)]);
var state_67189__$1 = state_67189;
var statearr_67193_67212 = state_67189__$1;
(statearr_67193_67212[(2)] = inst_67163);

(statearr_67193_67212[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67190 === (6))){
var state_67189__$1 = state_67189;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67189__$1,(9),x);
} else {
if((state_val_67190 === (3))){
var inst_67187 = (state_67189[(2)]);
var state_67189__$1 = state_67189;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67189__$1,inst_67187);
} else {
if((state_val_67190 === (2))){
var _ = (function (){var statearr_67195 = state_67189;
(statearr_67195[(4)] = cljs.core.cons((5),(state_67189[(4)])));

return statearr_67195;
})();
var inst_67169 = fluree.db.util.async.channel_QMARK_(x);
var state_67189__$1 = state_67189;
if(inst_67169){
var statearr_67196_67213 = state_67189__$1;
(statearr_67196_67213[(1)] = (6));

} else {
var statearr_67197_67214 = state_67189__$1;
(statearr_67197_67214[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67190 === (9))){
var inst_67172 = (state_67189[(2)]);
var inst_67173 = fluree.db.util.async.throw_err(inst_67172);
var state_67189__$1 = state_67189;
var statearr_67198_67215 = state_67189__$1;
(statearr_67198_67215[(2)] = inst_67173);

(statearr_67198_67215[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67190 === (5))){
var _ = (function (){var statearr_67199 = state_67189;
(statearr_67199[(4)] = cljs.core.rest((state_67189[(4)])));

return statearr_67199;
})();
var state_67189__$1 = state_67189;
var ex67194 = (state_67189__$1[(2)]);
var statearr_67200_67216 = state_67189__$1;
(statearr_67200_67216[(5)] = ex67194);


if((ex67194 instanceof Error)){
var statearr_67201_67217 = state_67189__$1;
(statearr_67201_67217[(1)] = (4));

(statearr_67201_67217[(5)] = null);

} else {
throw ex67194;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67190 === (8))){
var inst_67176 = (state_67189[(2)]);
var inst_67177 = fluree.db.dbfunctions.internal.boolean$(inst_67176);
var inst_67178 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67179 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67180 = ["boolean",inst_67176,inst_67177];
var inst_67181 = cljs.core.PersistentHashMap.fromArrays(inst_67179,inst_67180);
var inst_67182 = [inst_67181,(10)];
var inst_67183 = (new cljs.core.PersistentVector(null,2,(5),inst_67178,inst_67182,null));
var inst_67184 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67183);
var _ = (function (){var statearr_67202 = state_67189;
(statearr_67202[(4)] = cljs.core.rest((state_67189[(4)])));

return statearr_67202;
})();
var state_67189__$1 = (function (){var statearr_67203 = state_67189;
(statearr_67203[(7)] = inst_67184);

return statearr_67203;
})();
var statearr_67204_67218 = state_67189__$1;
(statearr_67204_67218[(2)] = inst_67177);

(statearr_67204_67218[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__11410__auto____0 = (function (){
var statearr_67205 = [null,null,null,null,null,null,null,null];
(statearr_67205[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__11410__auto__);

(statearr_67205[(1)] = (1));

return statearr_67205;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__11410__auto____1 = (function (state_67189){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_67189);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e67206){var ex__11413__auto__ = e67206;
var statearr_67207_67219 = state_67189;
(statearr_67207_67219[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_67189[(4)]))){
var statearr_67208_67220 = state_67189;
(statearr_67208_67220[(1)] = cljs.core.first((state_67189[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67221 = state_67189;
state_67189 = G__67221;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__11410__auto__ = function(state_67189){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__11410__auto____1.call(this,state_67189);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_67209 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_67209[(6)] = c__11484__auto__);

return statearr_67209;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_67259){
var state_val_67260 = (state_67259[(1)]);
if((state_val_67260 === (7))){
var state_67259__$1 = state_67259;
var statearr_67261_67285 = state_67259__$1;
(statearr_67261_67285[(2)] = pattern);

(statearr_67261_67285[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67260 === (1))){
var state_67259__$1 = state_67259;
var statearr_67262_67286 = state_67259__$1;
(statearr_67262_67286[(2)] = null);

(statearr_67262_67286[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67260 === (4))){
var inst_67222 = (state_67259[(2)]);
var state_67259__$1 = state_67259;
var statearr_67263_67287 = state_67259__$1;
(statearr_67263_67287[(2)] = inst_67222);

(statearr_67263_67287[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67260 === (13))){
var inst_67239 = (state_67259[(2)]);
var inst_67240 = fluree.db.util.async.throw_err(inst_67239);
var state_67259__$1 = state_67259;
var statearr_67264_67288 = state_67259__$1;
(statearr_67264_67288[(2)] = inst_67240);

(statearr_67264_67288[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67260 === (6))){
var state_67259__$1 = state_67259;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67259__$1,(9),pattern);
} else {
if((state_val_67260 === (3))){
var inst_67257 = (state_67259[(2)]);
var state_67259__$1 = state_67259;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67259__$1,inst_67257);
} else {
if((state_val_67260 === (12))){
var inst_67235 = (state_67259[(7)]);
var inst_67243 = (state_67259[(2)]);
var inst_67244 = fluree.db.dbfunctions.internal.re_find(inst_67235,inst_67243);
var inst_67245 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67246 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67247 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67248 = [inst_67235,inst_67243];
var inst_67249 = (new cljs.core.PersistentVector(null,2,(5),inst_67247,inst_67248,null));
var inst_67250 = ["re-find",inst_67249,inst_67244];
var inst_67251 = cljs.core.PersistentHashMap.fromArrays(inst_67246,inst_67250);
var inst_67252 = [inst_67251,(10)];
var inst_67253 = (new cljs.core.PersistentVector(null,2,(5),inst_67245,inst_67252,null));
var inst_67254 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67253);
var _ = (function (){var statearr_67265 = state_67259;
(statearr_67265[(4)] = cljs.core.rest((state_67259[(4)])));

return statearr_67265;
})();
var state_67259__$1 = (function (){var statearr_67266 = state_67259;
(statearr_67266[(8)] = inst_67254);

return statearr_67266;
})();
var statearr_67267_67289 = state_67259__$1;
(statearr_67267_67289[(2)] = inst_67244);

(statearr_67267_67289[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67260 === (2))){
var _ = (function (){var statearr_67268 = state_67259;
(statearr_67268[(4)] = cljs.core.cons((5),(state_67259[(4)])));

return statearr_67268;
})();
var inst_67228 = fluree.db.util.async.channel_QMARK_(pattern);
var state_67259__$1 = state_67259;
if(inst_67228){
var statearr_67269_67290 = state_67259__$1;
(statearr_67269_67290[(1)] = (6));

} else {
var statearr_67270_67291 = state_67259__$1;
(statearr_67270_67291[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67260 === (11))){
var state_67259__$1 = state_67259;
var statearr_67272_67292 = state_67259__$1;
(statearr_67272_67292[(2)] = string);

(statearr_67272_67292[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67260 === (9))){
var inst_67231 = (state_67259[(2)]);
var inst_67232 = fluree.db.util.async.throw_err(inst_67231);
var state_67259__$1 = state_67259;
var statearr_67273_67293 = state_67259__$1;
(statearr_67273_67293[(2)] = inst_67232);

(statearr_67273_67293[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67260 === (5))){
var _ = (function (){var statearr_67274 = state_67259;
(statearr_67274[(4)] = cljs.core.rest((state_67259[(4)])));

return statearr_67274;
})();
var state_67259__$1 = state_67259;
var ex67271 = (state_67259__$1[(2)]);
var statearr_67275_67294 = state_67259__$1;
(statearr_67275_67294[(5)] = ex67271);


if((ex67271 instanceof Error)){
var statearr_67276_67295 = state_67259__$1;
(statearr_67276_67295[(1)] = (4));

(statearr_67276_67295[(5)] = null);

} else {
throw ex67271;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67260 === (10))){
var state_67259__$1 = state_67259;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67259__$1,(13),string);
} else {
if((state_val_67260 === (8))){
var inst_67235 = (state_67259[(2)]);
var inst_67236 = fluree.db.util.async.channel_QMARK_(string);
var state_67259__$1 = (function (){var statearr_67277 = state_67259;
(statearr_67277[(7)] = inst_67235);

return statearr_67277;
})();
if(inst_67236){
var statearr_67278_67296 = state_67259__$1;
(statearr_67278_67296[(1)] = (10));

} else {
var statearr_67279_67297 = state_67259__$1;
(statearr_67279_67297[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__11410__auto____0 = (function (){
var statearr_67280 = [null,null,null,null,null,null,null,null,null];
(statearr_67280[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__11410__auto__);

(statearr_67280[(1)] = (1));

return statearr_67280;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__11410__auto____1 = (function (state_67259){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_67259);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e67281){var ex__11413__auto__ = e67281;
var statearr_67282_67298 = state_67259;
(statearr_67282_67298[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_67259[(4)]))){
var statearr_67283_67299 = state_67259;
(statearr_67283_67299[(1)] = cljs.core.first((state_67259[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67300 = state_67259;
state_67259 = G__67300;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__11410__auto__ = function(state_67259){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__11410__auto____1.call(this,state_67259);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_67284 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_67284[(6)] = c__11484__auto__);

return statearr_67284;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_67327){
var state_val_67328 = (state_67327[(1)]);
if((state_val_67328 === (7))){
var state_67327__$1 = state_67327;
var statearr_67329_67348 = state_67327__$1;
(statearr_67329_67348[(2)] = email);

(statearr_67329_67348[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67328 === (1))){
var state_67327__$1 = state_67327;
var statearr_67330_67349 = state_67327__$1;
(statearr_67330_67349[(2)] = null);

(statearr_67330_67349[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67328 === (4))){
var inst_67301 = (state_67327[(2)]);
var state_67327__$1 = state_67327;
var statearr_67331_67350 = state_67327__$1;
(statearr_67331_67350[(2)] = inst_67301);

(statearr_67331_67350[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67328 === (6))){
var state_67327__$1 = state_67327;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67327__$1,(9),email);
} else {
if((state_val_67328 === (3))){
var inst_67325 = (state_67327[(2)]);
var state_67327__$1 = state_67327;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67327__$1,inst_67325);
} else {
if((state_val_67328 === (2))){
var _ = (function (){var statearr_67333 = state_67327;
(statearr_67333[(4)] = cljs.core.cons((5),(state_67327[(4)])));

return statearr_67333;
})();
var inst_67307 = fluree.db.util.async.channel_QMARK_(email);
var state_67327__$1 = state_67327;
if(inst_67307){
var statearr_67334_67351 = state_67327__$1;
(statearr_67334_67351[(1)] = (6));

} else {
var statearr_67335_67352 = state_67327__$1;
(statearr_67335_67352[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67328 === (9))){
var inst_67310 = (state_67327[(2)]);
var inst_67311 = fluree.db.util.async.throw_err(inst_67310);
var state_67327__$1 = state_67327;
var statearr_67336_67353 = state_67327__$1;
(statearr_67336_67353[(2)] = inst_67311);

(statearr_67336_67353[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67328 === (5))){
var _ = (function (){var statearr_67337 = state_67327;
(statearr_67337[(4)] = cljs.core.rest((state_67327[(4)])));

return statearr_67337;
})();
var state_67327__$1 = state_67327;
var ex67332 = (state_67327__$1[(2)]);
var statearr_67338_67354 = state_67327__$1;
(statearr_67338_67354[(5)] = ex67332);


if((ex67332 instanceof Error)){
var statearr_67339_67355 = state_67327__$1;
(statearr_67339_67355[(1)] = (4));

(statearr_67339_67355[(5)] = null);

} else {
throw ex67332;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67328 === (8))){
var inst_67314 = (state_67327[(2)]);
var inst_67315 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_67314);
var inst_67316 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67317 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67318 = ["re-find",inst_67314,inst_67315];
var inst_67319 = cljs.core.PersistentHashMap.fromArrays(inst_67317,inst_67318);
var inst_67320 = [inst_67319,(10)];
var inst_67321 = (new cljs.core.PersistentVector(null,2,(5),inst_67316,inst_67320,null));
var inst_67322 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67321);
var _ = (function (){var statearr_67340 = state_67327;
(statearr_67340[(4)] = cljs.core.rest((state_67327[(4)])));

return statearr_67340;
})();
var state_67327__$1 = (function (){var statearr_67341 = state_67327;
(statearr_67341[(7)] = inst_67322);

return statearr_67341;
})();
var statearr_67342_67356 = state_67327__$1;
(statearr_67342_67356[(2)] = inst_67315);

(statearr_67342_67356[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11410__auto____0 = (function (){
var statearr_67343 = [null,null,null,null,null,null,null,null];
(statearr_67343[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11410__auto__);

(statearr_67343[(1)] = (1));

return statearr_67343;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11410__auto____1 = (function (state_67327){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_67327);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e67344){var ex__11413__auto__ = e67344;
var statearr_67345_67357 = state_67327;
(statearr_67345_67357[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_67327[(4)]))){
var statearr_67346_67358 = state_67327;
(statearr_67346_67358[(1)] = cljs.core.first((state_67327[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67359 = state_67327;
state_67327 = G__67359;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11410__auto__ = function(state_67327){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11410__auto____1.call(this,state_67327);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_67347 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_67347[(6)] = c__11484__auto__);

return statearr_67347;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_67406){
var state_val_67407 = (state_67406[(1)]);
if((state_val_67407 === (7))){
var inst_67376 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_67406__$1 = state_67406;
if(cljs.core.truth_(inst_67376)){
var statearr_67408_67435 = state_67406__$1;
(statearr_67408_67435[(1)] = (9));

} else {
var statearr_67409_67436 = state_67406__$1;
(statearr_67409_67436[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67407 === (1))){
var state_67406__$1 = state_67406;
var statearr_67410_67437 = state_67406__$1;
(statearr_67410_67437[(2)] = null);

(statearr_67410_67437[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67407 === (4))){
var inst_67360 = (state_67406[(2)]);
var state_67406__$1 = state_67406;
var statearr_67411_67438 = state_67406__$1;
(statearr_67411_67438[(2)] = inst_67360);

(statearr_67411_67438[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67407 === (15))){
var inst_67387 = (state_67406[(2)]);
var state_67406__$1 = state_67406;
var statearr_67412_67439 = state_67406__$1;
(statearr_67412_67439[(2)] = inst_67387);

(statearr_67412_67439[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67407 === (13))){
var inst_67384 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_67406__$1 = state_67406;
var statearr_67413_67440 = state_67406__$1;
(statearr_67413_67440[(2)] = inst_67384);

(statearr_67413_67440[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67407 === (6))){
var inst_67371 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67372 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_67373 = [inst_67372,(0)];
var inst_67374 = (new cljs.core.PersistentVector(null,2,(5),inst_67371,inst_67373,null));
var state_67406__$1 = state_67406;
var statearr_67414_67441 = state_67406__$1;
(statearr_67414_67441[(2)] = inst_67374);

(statearr_67414_67441[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67407 === (3))){
var inst_67404 = (state_67406[(2)]);
var state_67406__$1 = state_67406;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67406__$1,inst_67404);
} else {
if((state_val_67407 === (12))){
var inst_67380 = (state_67406[(2)]);
var inst_67381 = fluree.db.util.async.throw_err(inst_67380);
var state_67406__$1 = state_67406;
var statearr_67415_67442 = state_67406__$1;
(statearr_67415_67442[(2)] = inst_67381);

(statearr_67415_67442[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67407 === (2))){
var _ = (function (){var statearr_67416 = state_67406;
(statearr_67416[(4)] = cljs.core.cons((5),(state_67406[(4)])));

return statearr_67416;
})();
var inst_67369 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_67406__$1 = state_67406;
if(cljs.core.truth_(inst_67369)){
var statearr_67417_67443 = state_67406__$1;
(statearr_67417_67443[(1)] = (6));

} else {
var statearr_67418_67444 = state_67406__$1;
(statearr_67418_67444[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67407 === (11))){
var inst_67389 = (state_67406[(2)]);
var state_67406__$1 = state_67406;
var statearr_67420_67445 = state_67406__$1;
(statearr_67420_67445[(2)] = inst_67389);

(statearr_67420_67445[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67407 === (9))){
var inst_67378 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_67406__$1 = state_67406;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67406__$1,(12),inst_67378);
} else {
if((state_val_67407 === (5))){
var _ = (function (){var statearr_67421 = state_67406;
(statearr_67421[(4)] = cljs.core.rest((state_67406[(4)])));

return statearr_67421;
})();
var state_67406__$1 = state_67406;
var ex67419 = (state_67406__$1[(2)]);
var statearr_67422_67446 = state_67406__$1;
(statearr_67422_67446[(5)] = ex67419);


if((ex67419 instanceof Error)){
var statearr_67423_67447 = state_67406__$1;
(statearr_67423_67447[(1)] = (4));

(statearr_67423_67447[(5)] = null);

} else {
throw ex67419;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67407 === (14))){
var state_67406__$1 = state_67406;
var statearr_67424_67448 = state_67406__$1;
(statearr_67424_67448[(2)] = null);

(statearr_67424_67448[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67407 === (10))){
var state_67406__$1 = state_67406;
var statearr_67425_67449 = state_67406__$1;
(statearr_67425_67449[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67407 === (8))){
var inst_67391 = (state_67406[(2)]);
var inst_67392 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67391,(0),null);
var inst_67393 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67391,(1),null);
var inst_67394 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67395 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67396 = ["?user_id","?ctx",inst_67392];
var inst_67397 = cljs.core.PersistentHashMap.fromArrays(inst_67395,inst_67396);
var inst_67398 = ((10) + inst_67393);
var inst_67399 = [inst_67397,inst_67398];
var inst_67400 = (new cljs.core.PersistentVector(null,2,(5),inst_67394,inst_67399,null));
var inst_67401 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67400);
var _ = (function (){var statearr_67427 = state_67406;
(statearr_67427[(4)] = cljs.core.rest((state_67406[(4)])));

return statearr_67427;
})();
var state_67406__$1 = (function (){var statearr_67428 = state_67406;
(statearr_67428[(7)] = inst_67401);

return statearr_67428;
})();
var statearr_67429_67450 = state_67406__$1;
(statearr_67429_67450[(2)] = inst_67392);

(statearr_67429_67450[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11410__auto____0 = (function (){
var statearr_67430 = [null,null,null,null,null,null,null,null];
(statearr_67430[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11410__auto__);

(statearr_67430[(1)] = (1));

return statearr_67430;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11410__auto____1 = (function (state_67406){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_67406);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e67431){var ex__11413__auto__ = e67431;
var statearr_67432_67451 = state_67406;
(statearr_67432_67451[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_67406[(4)]))){
var statearr_67433_67452 = state_67406;
(statearr_67433_67452[(1)] = cljs.core.first((state_67406[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67453 = state_67406;
state_67406 = G__67453;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11410__auto__ = function(state_67406){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11410__auto____1.call(this,state_67406);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_67434 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_67434[(6)] = c__11484__auto__);

return statearr_67434;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_67481){
var state_val_67482 = (state_67481[(1)]);
if((state_val_67482 === (7))){
var inst_67474 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_67481__$1 = state_67481;
var statearr_67483_67502 = state_67481__$1;
(statearr_67483_67502[(2)] = inst_67474);

(statearr_67483_67502[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67482 === (1))){
var state_67481__$1 = state_67481;
var statearr_67484_67503 = state_67481__$1;
(statearr_67484_67503[(2)] = null);

(statearr_67484_67503[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67482 === (4))){
var inst_67454 = (state_67481[(2)]);
var state_67481__$1 = state_67481;
var statearr_67485_67504 = state_67481__$1;
(statearr_67485_67504[(2)] = inst_67454);

(statearr_67485_67504[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67482 === (6))){
var inst_67462 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_67481__$1 = state_67481;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67481__$1,(9),inst_67462);
} else {
if((state_val_67482 === (3))){
var inst_67479 = (state_67481[(2)]);
var state_67481__$1 = state_67481;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67481__$1,inst_67479);
} else {
if((state_val_67482 === (2))){
var _ = (function (){var statearr_67487 = state_67481;
(statearr_67487[(4)] = cljs.core.cons((5),(state_67481[(4)])));

return statearr_67487;
})();
var inst_67460 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_67481__$1 = state_67481;
if(cljs.core.truth_(inst_67460)){
var statearr_67488_67505 = state_67481__$1;
(statearr_67488_67505[(1)] = (6));

} else {
var statearr_67489_67506 = state_67481__$1;
(statearr_67489_67506[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67482 === (9))){
var inst_67464 = (state_67481[(2)]);
var inst_67465 = fluree.db.util.async.throw_err(inst_67464);
var inst_67466 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67467 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67468 = ["?auth_id","?ctx",inst_67465];
var inst_67469 = cljs.core.PersistentHashMap.fromArrays(inst_67467,inst_67468);
var inst_67470 = [inst_67469,(10)];
var inst_67471 = (new cljs.core.PersistentVector(null,2,(5),inst_67466,inst_67470,null));
var inst_67472 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67471);
var state_67481__$1 = (function (){var statearr_67490 = state_67481;
(statearr_67490[(7)] = inst_67472);

return statearr_67490;
})();
var statearr_67491_67507 = state_67481__$1;
(statearr_67491_67507[(2)] = inst_67465);

(statearr_67491_67507[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67482 === (5))){
var _ = (function (){var statearr_67492 = state_67481;
(statearr_67492[(4)] = cljs.core.rest((state_67481[(4)])));

return statearr_67492;
})();
var state_67481__$1 = state_67481;
var ex67486 = (state_67481__$1[(2)]);
var statearr_67493_67508 = state_67481__$1;
(statearr_67493_67508[(5)] = ex67486);


if((ex67486 instanceof Error)){
var statearr_67494_67509 = state_67481__$1;
(statearr_67494_67509[(1)] = (4));

(statearr_67494_67509[(5)] = null);

} else {
throw ex67486;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67482 === (8))){
var inst_67476 = (state_67481[(2)]);
var _ = (function (){var statearr_67495 = state_67481;
(statearr_67495[(4)] = cljs.core.rest((state_67481[(4)])));

return statearr_67495;
})();
var state_67481__$1 = state_67481;
var statearr_67496_67510 = state_67481__$1;
(statearr_67496_67510[(2)] = inst_67476);

(statearr_67496_67510[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11410__auto____0 = (function (){
var statearr_67497 = [null,null,null,null,null,null,null,null];
(statearr_67497[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11410__auto__);

(statearr_67497[(1)] = (1));

return statearr_67497;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11410__auto____1 = (function (state_67481){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_67481);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e67498){var ex__11413__auto__ = e67498;
var statearr_67499_67511 = state_67481;
(statearr_67499_67511[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_67481[(4)]))){
var statearr_67500_67512 = state_67481;
(statearr_67500_67512[(1)] = cljs.core.first((state_67481[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67513 = state_67481;
state_67481 = G__67513;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11410__auto__ = function(state_67481){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11410__auto____1.call(this,state_67481);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_67501 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_67501[(6)] = c__11484__auto__);

return statearr_67501;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__67515 = arguments.length;
switch (G__67515) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_67557){
var state_val_67558 = (state_67557[(1)]);
if((state_val_67558 === (7))){
var state_67557__$1 = state_67557;
var statearr_67559_67589 = state_67557__$1;
(statearr_67559_67589[(2)] = seed);

(statearr_67559_67589[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67558 === (1))){
var state_67557__$1 = state_67557;
var statearr_67560_67590 = state_67557__$1;
(statearr_67560_67590[(2)] = null);

(statearr_67560_67590[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67558 === (4))){
var inst_67516 = (state_67557[(2)]);
var state_67557__$1 = state_67557;
var statearr_67561_67591 = state_67557__$1;
(statearr_67561_67591[(2)] = inst_67516);

(statearr_67561_67591[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67558 === (15))){
var state_67557__$1 = state_67557;
var statearr_67562_67592 = state_67557__$1;
(statearr_67562_67592[(2)] = (10));

(statearr_67562_67592[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67558 === (13))){
var inst_67533 = (state_67557[(2)]);
var inst_67534 = fluree.db.util.async.throw_err(inst_67533);
var state_67557__$1 = state_67557;
var statearr_67563_67593 = state_67557__$1;
(statearr_67563_67593[(2)] = inst_67534);

(statearr_67563_67593[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67558 === (6))){
var state_67557__$1 = state_67557;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67557__$1,(9),seed);
} else {
if((state_val_67558 === (3))){
var inst_67555 = (state_67557[(2)]);
var state_67557__$1 = state_67557;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67557__$1,inst_67555);
} else {
if((state_val_67558 === (12))){
var inst_67537 = (state_67557[(7)]);
var inst_67537__$1 = (state_67557[(2)]);
var state_67557__$1 = (function (){var statearr_67564 = state_67557;
(statearr_67564[(7)] = inst_67537__$1);

return statearr_67564;
})();
if(cljs.core.truth_(inst_67537__$1)){
var statearr_67565_67594 = state_67557__$1;
(statearr_67565_67594[(1)] = (14));

} else {
var statearr_67566_67595 = state_67557__$1;
(statearr_67566_67595[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67558 === (2))){
var _ = (function (){var statearr_67567 = state_67557;
(statearr_67567[(4)] = cljs.core.cons((5),(state_67557[(4)])));

return statearr_67567;
})();
var inst_67522 = fluree.db.util.async.channel_QMARK_(seed);
var state_67557__$1 = state_67557;
if(inst_67522){
var statearr_67568_67596 = state_67557__$1;
(statearr_67568_67596[(1)] = (6));

} else {
var statearr_67569_67597 = state_67557__$1;
(statearr_67569_67597[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67558 === (11))){
var state_67557__$1 = state_67557;
var statearr_67571_67598 = state_67557__$1;
(statearr_67571_67598[(2)] = max);

(statearr_67571_67598[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67558 === (9))){
var inst_67525 = (state_67557[(2)]);
var inst_67526 = fluree.db.util.async.throw_err(inst_67525);
var state_67557__$1 = state_67557;
var statearr_67572_67599 = state_67557__$1;
(statearr_67572_67599[(2)] = inst_67526);

(statearr_67572_67599[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67558 === (5))){
var _ = (function (){var statearr_67573 = state_67557;
(statearr_67573[(4)] = cljs.core.rest((state_67557[(4)])));

return statearr_67573;
})();
var state_67557__$1 = state_67557;
var ex67570 = (state_67557__$1[(2)]);
var statearr_67574_67600 = state_67557__$1;
(statearr_67574_67600[(5)] = ex67570);


if((ex67570 instanceof Error)){
var statearr_67575_67601 = state_67557__$1;
(statearr_67575_67601[(1)] = (4));

(statearr_67575_67601[(5)] = null);

} else {
throw ex67570;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67558 === (14))){
var inst_67537 = (state_67557[(7)]);
var state_67557__$1 = state_67557;
var statearr_67576_67602 = state_67557__$1;
(statearr_67576_67602[(2)] = inst_67537);

(statearr_67576_67602[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67558 === (16))){
var inst_67529 = (state_67557[(8)]);
var inst_67541 = (state_67557[(2)]);
var inst_67542 = fluree.db.dbfunctions.internal.rand(inst_67529,inst_67541);
var inst_67543 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67544 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67545 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67546 = [max,seed];
var inst_67547 = (new cljs.core.PersistentVector(null,2,(5),inst_67545,inst_67546,null));
var inst_67548 = ["rand",inst_67547,inst_67542];
var inst_67549 = cljs.core.PersistentHashMap.fromArrays(inst_67544,inst_67548);
var inst_67550 = [inst_67549,(10)];
var inst_67551 = (new cljs.core.PersistentVector(null,2,(5),inst_67543,inst_67550,null));
var inst_67552 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67551);
var _ = (function (){var statearr_67577 = state_67557;
(statearr_67577[(4)] = cljs.core.rest((state_67557[(4)])));

return statearr_67577;
})();
var state_67557__$1 = (function (){var statearr_67578 = state_67557;
(statearr_67578[(9)] = inst_67552);

return statearr_67578;
})();
var statearr_67579_67603 = state_67557__$1;
(statearr_67579_67603[(2)] = inst_67542);

(statearr_67579_67603[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67558 === (10))){
var state_67557__$1 = state_67557;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67557__$1,(13),max);
} else {
if((state_val_67558 === (8))){
var inst_67529 = (state_67557[(2)]);
var inst_67530 = fluree.db.util.async.channel_QMARK_(max);
var state_67557__$1 = (function (){var statearr_67580 = state_67557;
(statearr_67580[(8)] = inst_67529);

return statearr_67580;
})();
if(inst_67530){
var statearr_67581_67604 = state_67557__$1;
(statearr_67581_67604[(1)] = (10));

} else {
var statearr_67582_67605 = state_67557__$1;
(statearr_67582_67605[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__11410__auto____0 = (function (){
var statearr_67583 = [null,null,null,null,null,null,null,null,null,null];
(statearr_67583[(0)] = fluree$db$dbfunctions$fns$state_machine__11410__auto__);

(statearr_67583[(1)] = (1));

return statearr_67583;
});
var fluree$db$dbfunctions$fns$state_machine__11410__auto____1 = (function (state_67557){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_67557);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e67584){var ex__11413__auto__ = e67584;
var statearr_67585_67606 = state_67557;
(statearr_67585_67606[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_67557[(4)]))){
var statearr_67586_67607 = state_67557;
(statearr_67586_67607[(1)] = cljs.core.first((state_67557[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67608 = state_67557;
state_67557 = G__67608;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__11410__auto__ = function(state_67557){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__11410__auto____1.call(this,state_67557);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_67587 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_67587[(6)] = c__11484__auto__);

return statearr_67587;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_67629){
var state_val_67630 = (state_67629[(1)]);
if((state_val_67630 === (1))){
var state_67629__$1 = state_67629;
var statearr_67631_67646 = state_67629__$1;
(statearr_67631_67646[(2)] = null);

(statearr_67631_67646[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67630 === (2))){
var _ = (function (){var statearr_67632 = state_67629;
(statearr_67632[(4)] = cljs.core.cons((5),(state_67629[(4)])));

return statearr_67632;
})();
var inst_67615 = fluree.db.util.core.random_uuid();
var inst_67616 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_67615);
var inst_67617 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67618 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67619 = cljs.core.PersistentVector.EMPTY;
var inst_67620 = ["uuid",inst_67619,inst_67616];
var inst_67621 = cljs.core.PersistentHashMap.fromArrays(inst_67618,inst_67620);
var inst_67622 = [inst_67621,(10)];
var inst_67623 = (new cljs.core.PersistentVector(null,2,(5),inst_67617,inst_67622,null));
var inst_67624 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67623);
var ___$1 = (function (){var statearr_67633 = state_67629;
(statearr_67633[(4)] = cljs.core.rest((state_67629[(4)])));

return statearr_67633;
})();
var state_67629__$1 = (function (){var statearr_67634 = state_67629;
(statearr_67634[(7)] = inst_67624);

return statearr_67634;
})();
var statearr_67635_67647 = state_67629__$1;
(statearr_67635_67647[(2)] = inst_67616);

(statearr_67635_67647[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67630 === (3))){
var inst_67627 = (state_67629[(2)]);
var state_67629__$1 = state_67629;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67629__$1,inst_67627);
} else {
if((state_val_67630 === (4))){
var inst_67609 = (state_67629[(2)]);
var state_67629__$1 = state_67629;
var statearr_67637_67648 = state_67629__$1;
(statearr_67637_67648[(2)] = inst_67609);

(statearr_67637_67648[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67630 === (5))){
var _ = (function (){var statearr_67638 = state_67629;
(statearr_67638[(4)] = cljs.core.rest((state_67629[(4)])));

return statearr_67638;
})();
var state_67629__$1 = state_67629;
var ex67636 = (state_67629__$1[(2)]);
var statearr_67639_67649 = state_67629__$1;
(statearr_67639_67649[(5)] = ex67636);


if((ex67636 instanceof Error)){
var statearr_67640_67650 = state_67629__$1;
(statearr_67640_67650[(1)] = (4));

(statearr_67640_67650[(5)] = null);

} else {
throw ex67636;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__11410__auto____0 = (function (){
var statearr_67641 = [null,null,null,null,null,null,null,null];
(statearr_67641[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__11410__auto__);

(statearr_67641[(1)] = (1));

return statearr_67641;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__11410__auto____1 = (function (state_67629){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_67629);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e67642){var ex__11413__auto__ = e67642;
var statearr_67643_67651 = state_67629;
(statearr_67643_67651[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_67629[(4)]))){
var statearr_67644_67652 = state_67629;
(statearr_67644_67652[(1)] = cljs.core.first((state_67629[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67653 = state_67629;
state_67629 = G__67653;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__11410__auto__ = function(state_67629){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__11410__auto____1.call(this,state_67629);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_67645 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_67645[(6)] = c__11484__auto__);

return statearr_67645;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_67683){
var state_val_67684 = (state_67683[(1)]);
if((state_val_67684 === (7))){
var state_67683__$1 = state_67683;
var statearr_67685_67704 = state_67683__$1;
(statearr_67685_67704[(2)] = num);

(statearr_67685_67704[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67684 === (1))){
var state_67683__$1 = state_67683;
var statearr_67686_67705 = state_67683__$1;
(statearr_67686_67705[(2)] = null);

(statearr_67686_67705[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67684 === (4))){
var inst_67654 = (state_67683[(2)]);
var state_67683__$1 = state_67683;
var statearr_67687_67706 = state_67683__$1;
(statearr_67687_67706[(2)] = inst_67654);

(statearr_67687_67706[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67684 === (6))){
var state_67683__$1 = state_67683;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67683__$1,(9),num);
} else {
if((state_val_67684 === (3))){
var inst_67681 = (state_67683[(2)]);
var state_67683__$1 = state_67683;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67683__$1,inst_67681);
} else {
if((state_val_67684 === (2))){
var _ = (function (){var statearr_67689 = state_67683;
(statearr_67689[(4)] = cljs.core.cons((5),(state_67683[(4)])));

return statearr_67689;
})();
var inst_67660 = fluree.db.util.async.channel_QMARK_(num);
var state_67683__$1 = state_67683;
if(inst_67660){
var statearr_67690_67707 = state_67683__$1;
(statearr_67690_67707[(1)] = (6));

} else {
var statearr_67691_67708 = state_67683__$1;
(statearr_67691_67708[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67684 === (9))){
var inst_67663 = (state_67683[(2)]);
var inst_67664 = fluree.db.util.async.throw_err(inst_67663);
var state_67683__$1 = state_67683;
var statearr_67692_67709 = state_67683__$1;
(statearr_67692_67709[(2)] = inst_67664);

(statearr_67692_67709[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67684 === (5))){
var _ = (function (){var statearr_67693 = state_67683;
(statearr_67693[(4)] = cljs.core.rest((state_67683[(4)])));

return statearr_67693;
})();
var state_67683__$1 = state_67683;
var ex67688 = (state_67683__$1[(2)]);
var statearr_67694_67710 = state_67683__$1;
(statearr_67694_67710[(5)] = ex67688);


if((ex67688 instanceof Error)){
var statearr_67695_67711 = state_67683__$1;
(statearr_67695_67711[(1)] = (4));

(statearr_67695_67711[(5)] = null);

} else {
throw ex67688;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67684 === (8))){
var inst_67667 = (state_67683[(2)]);
var inst_67668 = fluree.db.dbfunctions.internal.ceil(inst_67667);
var inst_67669 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67670 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67671 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67672 = [fluree.db.dbfunctions.fns.ceil];
var inst_67673 = (new cljs.core.PersistentVector(null,1,(5),inst_67671,inst_67672,null));
var inst_67674 = ["",inst_67673,inst_67668];
var inst_67675 = cljs.core.PersistentHashMap.fromArrays(inst_67670,inst_67674);
var inst_67676 = [inst_67675,(10)];
var inst_67677 = (new cljs.core.PersistentVector(null,2,(5),inst_67669,inst_67676,null));
var inst_67678 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67677);
var _ = (function (){var statearr_67696 = state_67683;
(statearr_67696[(4)] = cljs.core.rest((state_67683[(4)])));

return statearr_67696;
})();
var state_67683__$1 = (function (){var statearr_67697 = state_67683;
(statearr_67697[(7)] = inst_67678);

return statearr_67697;
})();
var statearr_67698_67712 = state_67683__$1;
(statearr_67698_67712[(2)] = inst_67668);

(statearr_67698_67712[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__11410__auto____0 = (function (){
var statearr_67699 = [null,null,null,null,null,null,null,null];
(statearr_67699[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__11410__auto__);

(statearr_67699[(1)] = (1));

return statearr_67699;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__11410__auto____1 = (function (state_67683){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_67683);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e67700){var ex__11413__auto__ = e67700;
var statearr_67701_67713 = state_67683;
(statearr_67701_67713[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_67683[(4)]))){
var statearr_67702_67714 = state_67683;
(statearr_67702_67714[(1)] = cljs.core.first((state_67683[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67715 = state_67683;
state_67683 = G__67715;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__11410__auto__ = function(state_67683){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__11410__auto____1.call(this,state_67683);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_67703 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_67703[(6)] = c__11484__auto__);

return statearr_67703;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_67745){
var state_val_67746 = (state_67745[(1)]);
if((state_val_67746 === (7))){
var state_67745__$1 = state_67745;
var statearr_67747_67766 = state_67745__$1;
(statearr_67747_67766[(2)] = num);

(statearr_67747_67766[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67746 === (1))){
var state_67745__$1 = state_67745;
var statearr_67748_67767 = state_67745__$1;
(statearr_67748_67767[(2)] = null);

(statearr_67748_67767[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67746 === (4))){
var inst_67716 = (state_67745[(2)]);
var state_67745__$1 = state_67745;
var statearr_67749_67768 = state_67745__$1;
(statearr_67749_67768[(2)] = inst_67716);

(statearr_67749_67768[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67746 === (6))){
var state_67745__$1 = state_67745;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67745__$1,(9),num);
} else {
if((state_val_67746 === (3))){
var inst_67743 = (state_67745[(2)]);
var state_67745__$1 = state_67745;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67745__$1,inst_67743);
} else {
if((state_val_67746 === (2))){
var _ = (function (){var statearr_67751 = state_67745;
(statearr_67751[(4)] = cljs.core.cons((5),(state_67745[(4)])));

return statearr_67751;
})();
var inst_67722 = fluree.db.util.async.channel_QMARK_(num);
var state_67745__$1 = state_67745;
if(inst_67722){
var statearr_67752_67769 = state_67745__$1;
(statearr_67752_67769[(1)] = (6));

} else {
var statearr_67753_67770 = state_67745__$1;
(statearr_67753_67770[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67746 === (9))){
var inst_67725 = (state_67745[(2)]);
var inst_67726 = fluree.db.util.async.throw_err(inst_67725);
var state_67745__$1 = state_67745;
var statearr_67754_67771 = state_67745__$1;
(statearr_67754_67771[(2)] = inst_67726);

(statearr_67754_67771[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67746 === (5))){
var _ = (function (){var statearr_67755 = state_67745;
(statearr_67755[(4)] = cljs.core.rest((state_67745[(4)])));

return statearr_67755;
})();
var state_67745__$1 = state_67745;
var ex67750 = (state_67745__$1[(2)]);
var statearr_67756_67772 = state_67745__$1;
(statearr_67756_67772[(5)] = ex67750);


if((ex67750 instanceof Error)){
var statearr_67757_67773 = state_67745__$1;
(statearr_67757_67773[(1)] = (4));

(statearr_67757_67773[(5)] = null);

} else {
throw ex67750;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67746 === (8))){
var inst_67729 = (state_67745[(2)]);
var inst_67730 = fluree.db.dbfunctions.internal.floor(inst_67729);
var inst_67731 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67732 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67733 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67734 = [fluree.db.dbfunctions.fns.floor];
var inst_67735 = (new cljs.core.PersistentVector(null,1,(5),inst_67733,inst_67734,null));
var inst_67736 = ["",inst_67735,inst_67730];
var inst_67737 = cljs.core.PersistentHashMap.fromArrays(inst_67732,inst_67736);
var inst_67738 = [inst_67737,(10)];
var inst_67739 = (new cljs.core.PersistentVector(null,2,(5),inst_67731,inst_67738,null));
var inst_67740 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67739);
var _ = (function (){var statearr_67758 = state_67745;
(statearr_67758[(4)] = cljs.core.rest((state_67745[(4)])));

return statearr_67758;
})();
var state_67745__$1 = (function (){var statearr_67759 = state_67745;
(statearr_67759[(7)] = inst_67740);

return statearr_67759;
})();
var statearr_67760_67774 = state_67745__$1;
(statearr_67760_67774[(2)] = inst_67730);

(statearr_67760_67774[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__11410__auto____0 = (function (){
var statearr_67761 = [null,null,null,null,null,null,null,null];
(statearr_67761[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__11410__auto__);

(statearr_67761[(1)] = (1));

return statearr_67761;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__11410__auto____1 = (function (state_67745){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_67745);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e67762){var ex__11413__auto__ = e67762;
var statearr_67763_67775 = state_67745;
(statearr_67763_67775[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_67745[(4)]))){
var statearr_67764_67776 = state_67745;
(statearr_67764_67776[(1)] = cljs.core.first((state_67745[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67777 = state_67745;
state_67745 = G__67777;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__11410__auto__ = function(state_67745){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__11410__auto____1.call(this,state_67745);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_67765 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_67765[(6)] = c__11484__auto__);

return statearr_67765;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_67802){
var state_val_67803 = (state_67802[(1)]);
if((state_val_67803 === (1))){
var state_67802__$1 = state_67802;
var statearr_67804_67819 = state_67802__$1;
(statearr_67804_67819[(2)] = null);

(statearr_67804_67819[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67803 === (2))){
var _ = (function (){var statearr_67805 = state_67802;
(statearr_67805[(4)] = cljs.core.cons((5),(state_67802[(4)])));

return statearr_67805;
})();
var inst_67784 = fluree.db.dbfunctions.internal.cas(_QMARK_ctx,compare_val,new_val);
var state_67802__$1 = state_67802;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67802__$1,(6),inst_67784);
} else {
if((state_val_67803 === (3))){
var inst_67800 = (state_67802[(2)]);
var state_67802__$1 = state_67802;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67802__$1,inst_67800);
} else {
if((state_val_67803 === (4))){
var inst_67778 = (state_67802[(2)]);
var state_67802__$1 = state_67802;
var statearr_67807_67820 = state_67802__$1;
(statearr_67807_67820[(2)] = inst_67778);

(statearr_67807_67820[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67803 === (5))){
var _ = (function (){var statearr_67808 = state_67802;
(statearr_67808[(4)] = cljs.core.rest((state_67802[(4)])));

return statearr_67808;
})();
var state_67802__$1 = state_67802;
var ex67806 = (state_67802__$1[(2)]);
var statearr_67809_67821 = state_67802__$1;
(statearr_67809_67821[(5)] = ex67806);


if((ex67806 instanceof Error)){
var statearr_67810_67822 = state_67802__$1;
(statearr_67810_67822[(1)] = (4));

(statearr_67810_67822[(5)] = null);

} else {
throw ex67806;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67803 === (6))){
var inst_67786 = (state_67802[(2)]);
var inst_67787 = fluree.db.util.async.throw_err(inst_67786);
var inst_67788 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67789 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_67790 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67791 = [compare_val,new_val];
var inst_67792 = (new cljs.core.PersistentVector(null,2,(5),inst_67790,inst_67791,null));
var inst_67793 = ["",inst_67792,inst_67787];
var inst_67794 = cljs.core.PersistentHashMap.fromArrays(inst_67789,inst_67793);
var inst_67795 = [inst_67794,(10)];
var inst_67796 = (new cljs.core.PersistentVector(null,2,(5),inst_67788,inst_67795,null));
var inst_67797 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67796);
var _ = (function (){var statearr_67811 = state_67802;
(statearr_67811[(4)] = cljs.core.rest((state_67802[(4)])));

return statearr_67811;
})();
var state_67802__$1 = (function (){var statearr_67812 = state_67802;
(statearr_67812[(7)] = inst_67797);

return statearr_67812;
})();
var statearr_67813_67823 = state_67802__$1;
(statearr_67813_67823[(2)] = inst_67787);

(statearr_67813_67823[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__11410__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__11410__auto____0 = (function (){
var statearr_67814 = [null,null,null,null,null,null,null,null];
(statearr_67814[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__11410__auto__);

(statearr_67814[(1)] = (1));

return statearr_67814;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__11410__auto____1 = (function (state_67802){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_67802);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e67815){var ex__11413__auto__ = e67815;
var statearr_67816_67824 = state_67802;
(statearr_67816_67824[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_67802[(4)]))){
var statearr_67817_67825 = state_67802;
(statearr_67817_67825[(1)] = cljs.core.first((state_67802[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67826 = state_67802;
state_67802 = G__67826;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__11410__auto__ = function(state_67802){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__11410__auto____1.call(this,state_67802);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__11410__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__11410__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_67818 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_67818[(6)] = c__11484__auto__);

return statearr_67818;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
