// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt(secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__73609 = arguments.length;
switch (G__73609) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_73651){
var state_val_73652 = (state_73651[(1)]);
if((state_val_73652 === (7))){
var inst_73621 = typeof user === 'string';
var state_73651__$1 = state_73651;
if(cljs.core.truth_(inst_73621)){
var statearr_73653_73682 = state_73651__$1;
(statearr_73653_73682[(1)] = (9));

} else {
var statearr_73654_73683 = state_73651__$1;
(statearr_73654_73683[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73652 === (1))){
var state_73651__$1 = state_73651;
var statearr_73655_73684 = state_73651__$1;
(statearr_73655_73684[(2)] = null);

(statearr_73655_73684[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73652 === (4))){
var inst_73610 = (state_73651[(2)]);
var inst_73611 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_73610], 0));
var inst_73612 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_73610) : reject.call(null,inst_73610));
var state_73651__$1 = (function (){var statearr_73656 = state_73651;
(statearr_73656[(7)] = inst_73611);

return statearr_73656;
})();
var statearr_73657_73685 = state_73651__$1;
(statearr_73657_73685[(2)] = inst_73612);

(statearr_73657_73685[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73652 === (15))){
var inst_73640 = (state_73651[(2)]);
var inst_73641 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_73640);
var inst_73642 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73643 = cljs.core.constantly(inst_73641);
var inst_73644 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_73642,inst_73643);
var inst_73645 = fluree.db.connection.add_token(conn,inst_73641);
var inst_73646 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_73640) : resolve.call(null,inst_73640));
var _ = (function (){var statearr_73658 = state_73651;
(statearr_73658[(4)] = cljs.core.rest((state_73651[(4)])));

return statearr_73658;
})();
var state_73651__$1 = (function (){var statearr_73659 = state_73651;
(statearr_73659[(8)] = inst_73644);

(statearr_73659[(9)] = inst_73645);

return statearr_73659;
})();
var statearr_73660_73686 = state_73651__$1;
(statearr_73660_73686[(2)] = inst_73646);

(statearr_73660_73686[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73652 === (13))){
var state_73651__$1 = state_73651;
var statearr_73661_73687 = state_73651__$1;
(statearr_73661_73687[(2)] = null);

(statearr_73661_73687[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73652 === (6))){
var state_73651__$1 = state_73651;
var statearr_73662_73688 = state_73651__$1;
(statearr_73662_73688[(2)] = user);

(statearr_73662_73688[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73652 === (3))){
var inst_73649 = (state_73651[(2)]);
var state_73651__$1 = state_73651;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73651__$1,inst_73649);
} else {
if((state_val_73652 === (12))){
var state_73651__$1 = state_73651;
var statearr_73663_73689 = state_73651__$1;
(statearr_73663_73689[(2)] = user);

(statearr_73663_73689[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73652 === (2))){
var _ = (function (){var statearr_73664 = state_73651;
(statearr_73664[(4)] = cljs.core.cons((5),(state_73651[(4)])));

return statearr_73664;
})();
var inst_73618 = typeof user === 'number';
var state_73651__$1 = state_73651;
if(cljs.core.truth_(inst_73618)){
var statearr_73665_73690 = state_73651__$1;
(statearr_73665_73690[(1)] = (6));

} else {
var statearr_73666_73691 = state_73651__$1;
(statearr_73666_73691[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73652 === (11))){
var inst_73632 = (state_73651[(2)]);
var state_73651__$1 = state_73651;
var statearr_73668_73692 = state_73651__$1;
(statearr_73668_73692[(2)] = inst_73632);

(statearr_73668_73692[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73652 === (9))){
var inst_73623 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73624 = ["_user/username",user];
var inst_73625 = (new cljs.core.PersistentVector(null,2,(5),inst_73623,inst_73624,null));
var state_73651__$1 = state_73651;
var statearr_73669_73693 = state_73651__$1;
(statearr_73669_73693[(2)] = inst_73625);

(statearr_73669_73693[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73652 === (5))){
var _ = (function (){var statearr_73670 = state_73651;
(statearr_73670[(4)] = cljs.core.rest((state_73651[(4)])));

return statearr_73670;
})();
var state_73651__$1 = state_73651;
var ex73667 = (state_73651__$1[(2)]);
var statearr_73671_73694 = state_73651__$1;
(statearr_73671_73694[(5)] = ex73667);


var statearr_73672_73695 = state_73651__$1;
(statearr_73672_73695[(1)] = (4));

(statearr_73672_73695[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73652 === (14))){
var inst_73630 = (state_73651[(2)]);
var state_73651__$1 = state_73651;
var statearr_73673_73696 = state_73651__$1;
(statearr_73673_73696[(2)] = inst_73630);

(statearr_73673_73696[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73652 === (10))){
var state_73651__$1 = state_73651;
var statearr_73674_73697 = state_73651__$1;
(statearr_73674_73697[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73652 === (8))){
var inst_73634 = (state_73651[(2)]);
var inst_73635 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_73636 = [account,inst_73634,password,expireSeconds,syncTo];
var inst_73637 = cljs.core.PersistentHashMap.fromArrays(inst_73635,inst_73636);
var inst_73638 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_73637);
var state_73651__$1 = state_73651;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73651__$1,(15),inst_73638);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__11410__auto__ = null;
var fluree$db$connection_js$state_machine__11410__auto____0 = (function (){
var statearr_73676 = [null,null,null,null,null,null,null,null,null,null];
(statearr_73676[(0)] = fluree$db$connection_js$state_machine__11410__auto__);

(statearr_73676[(1)] = (1));

return statearr_73676;
});
var fluree$db$connection_js$state_machine__11410__auto____1 = (function (state_73651){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_73651);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e73677){var ex__11413__auto__ = e73677;
var statearr_73678_73698 = state_73651;
(statearr_73678_73698[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_73651[(4)]))){
var statearr_73679_73699 = state_73651;
(statearr_73679_73699[(1)] = cljs.core.first((state_73651[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73700 = state_73651;
state_73651 = G__73700;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__11410__auto__ = function(state_73651){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__11410__auto____1.call(this,state_73651);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__11410__auto____0;
fluree$db$connection_js$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__11410__auto____1;
return fluree$db$connection_js$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_73680 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_73680[(6)] = c__11484__auto__);

return statearr_73680;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__73702 = arguments.length;
switch (G__73702) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in(cljs.core.assoc_in(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var _ = (function (){var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_73711){
var state_val_73712 = (state_73711[(1)]);
if((state_val_73712 === (1))){
var inst_73703 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73704 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73705 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_73706 = (new cljs.core.PersistentVector(null,4,(5),inst_73704,inst_73705,null));
var inst_73707 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_73703,inst_73706);
var inst_73708 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__73713 = cljs.core.seq(cljs.core.keys(x));
var chunk__73714 = null;
var count__73715 = (0);
var i__73716 = (0);
while(true){
if((i__73716 < count__73715)){
var k = chunk__73714.cljs$core$IIndexed$_nth$arity$2(null,i__73716);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__73724 = seq__73713;
var G__73725 = chunk__73714;
var G__73726 = count__73715;
var G__73727 = (i__73716 + (1));
seq__73713 = G__73724;
chunk__73714 = G__73725;
count__73715 = G__73726;
i__73716 = G__73727;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__73713);
if(temp__5753__auto__){
var seq__73713__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__73713__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__73713__$1);
var G__73728 = cljs.core.chunk_rest(seq__73713__$1);
var G__73729 = c__4679__auto__;
var G__73730 = cljs.core.count(c__4679__auto__);
var G__73731 = (0);
seq__73713 = G__73728;
chunk__73714 = G__73729;
count__73715 = G__73730;
i__73716 = G__73731;
continue;
} else {
var k = cljs.core.first(seq__73713__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__73732 = cljs.core.next(seq__73713__$1);
var G__73733 = null;
var G__73734 = (0);
var G__73735 = (0);
seq__73713 = G__73732;
chunk__73714 = G__73733;
count__73715 = G__73734;
i__73716 = G__73735;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_73709 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_73708);
var state_73711__$1 = (function (){var statearr_73717 = state_73711;
(statearr_73717[(7)] = inst_73707);

return statearr_73717;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_73711__$1,inst_73709);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__11410__auto__ = null;
var fluree$db$connection_js$state_machine__11410__auto____0 = (function (){
var statearr_73718 = [null,null,null,null,null,null,null,null];
(statearr_73718[(0)] = fluree$db$connection_js$state_machine__11410__auto__);

(statearr_73718[(1)] = (1));

return statearr_73718;
});
var fluree$db$connection_js$state_machine__11410__auto____1 = (function (state_73711){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_73711);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e73719){var ex__11413__auto__ = e73719;
var statearr_73720_73736 = state_73711;
(statearr_73720_73736[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_73711[(4)]))){
var statearr_73721_73737 = state_73711;
(statearr_73721_73737[(1)] = cljs.core.first((state_73711[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73738 = state_73711;
state_73711 = G__73738;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__11410__auto__ = function(state_73711){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__11410__auto____1.call(this,state_73711);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__11410__auto____0;
fluree$db$connection_js$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__11410__auto____1;
return fluree$db$connection_js$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_73722 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_73722[(6)] = c__11484__auto__);

return statearr_73722;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__73740 = arguments.length;
switch (G__73740) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_73774){
var state_val_73775 = (state_73774[(1)]);
if((state_val_73775 === (1))){
var state_73774__$1 = state_73774;
var statearr_73776_73797 = state_73774__$1;
(statearr_73776_73797[(2)] = null);

(statearr_73776_73797[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73775 === (2))){
var _ = (function (){var statearr_73777 = state_73774;
(statearr_73777[(4)] = cljs.core.cons((5),(state_73774[(4)])));

return statearr_73777;
})();
var inst_73749 = fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0));
var inst_73750 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73751 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_73752 = (new cljs.core.PersistentVector(null,1,(5),inst_73750,inst_73751,null));
var inst_73753 = cljs.core.PersistentHashMap.EMPTY;
var inst_73754 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_73753);
var inst_73755 = cljs.core.assoc_in(inst_73749,inst_73752,inst_73754);
var inst_73756 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73757 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_73758 = (new cljs.core.PersistentVector(null,1,(5),inst_73756,inst_73757,null));
var inst_73759 = cljs.core.PersistentHashMap.EMPTY;
var inst_73760 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_73759);
var inst_73761 = cljs.core.assoc_in(inst_73755,inst_73758,inst_73760);
var inst_73762 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_73763 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_73761);
var inst_73764 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73765 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_73762,null];
var inst_73766 = (new cljs.core.PersistentVector(null,4,(5),inst_73764,inst_73765,null));
var inst_73767 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_73763,inst_73766);
var inst_73768 = (function (){var conn = inst_73761;
var pc = inst_73762;
return (function (x){
if((x == null)){
} else {
var seq__73778_73798 = cljs.core.seq(cljs.core.keys(x));
var chunk__73779_73799 = null;
var count__73780_73800 = (0);
var i__73781_73801 = (0);
while(true){
if((i__73781_73801 < count__73780_73800)){
var k_73802 = chunk__73779_73799.cljs$core$IIndexed$_nth$arity$2(null,i__73781_73801);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_73802], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_73802,null));


var G__73803 = seq__73778_73798;
var G__73804 = chunk__73779_73799;
var G__73805 = count__73780_73800;
var G__73806 = (i__73781_73801 + (1));
seq__73778_73798 = G__73803;
chunk__73779_73799 = G__73804;
count__73780_73800 = G__73805;
i__73781_73801 = G__73806;
continue;
} else {
var temp__5753__auto___73807 = cljs.core.seq(seq__73778_73798);
if(temp__5753__auto___73807){
var seq__73778_73808__$1 = temp__5753__auto___73807;
if(cljs.core.chunked_seq_QMARK_(seq__73778_73808__$1)){
var c__4679__auto___73809 = cljs.core.chunk_first(seq__73778_73808__$1);
var G__73810 = cljs.core.chunk_rest(seq__73778_73808__$1);
var G__73811 = c__4679__auto___73809;
var G__73812 = cljs.core.count(c__4679__auto___73809);
var G__73813 = (0);
seq__73778_73798 = G__73810;
chunk__73779_73799 = G__73811;
count__73780_73800 = G__73812;
i__73781_73801 = G__73813;
continue;
} else {
var k_73814 = cljs.core.first(seq__73778_73808__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_73814], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_73814,null));


var G__73815 = cljs.core.next(seq__73778_73808__$1);
var G__73816 = null;
var G__73817 = (0);
var G__73818 = (0);
seq__73778_73798 = G__73815;
chunk__73779_73799 = G__73816;
count__73780_73800 = G__73817;
i__73781_73801 = G__73818;
continue;
}
} else {
}
}
break;
}
}

return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(conn) : resolve.call(null,conn));
});
})();
var inst_73769 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_73762,inst_73768);
var ___$1 = (function (){var statearr_73782 = state_73774;
(statearr_73782[(4)] = cljs.core.rest((state_73774[(4)])));

return statearr_73782;
})();
var state_73774__$1 = (function (){var statearr_73783 = state_73774;
(statearr_73783[(7)] = inst_73767);

return statearr_73783;
})();
var statearr_73784_73819 = state_73774__$1;
(statearr_73784_73819[(2)] = inst_73769);

(statearr_73784_73819[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73775 === (3))){
var inst_73772 = (state_73774[(2)]);
var state_73774__$1 = state_73774;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73774__$1,inst_73772);
} else {
if((state_val_73775 === (4))){
var inst_73741 = (state_73774[(2)]);
var inst_73742 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_73741], 0));
var inst_73743 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_73741) : reject.call(null,inst_73741));
var state_73774__$1 = (function (){var statearr_73786 = state_73774;
(statearr_73786[(8)] = inst_73742);

return statearr_73786;
})();
var statearr_73787_73820 = state_73774__$1;
(statearr_73787_73820[(2)] = inst_73743);

(statearr_73787_73820[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73775 === (5))){
var _ = (function (){var statearr_73788 = state_73774;
(statearr_73788[(4)] = cljs.core.rest((state_73774[(4)])));

return statearr_73788;
})();
var state_73774__$1 = state_73774;
var ex73785 = (state_73774__$1[(2)]);
var statearr_73789_73821 = state_73774__$1;
(statearr_73789_73821[(5)] = ex73785);


var statearr_73790_73822 = state_73774__$1;
(statearr_73790_73822[(1)] = (4));

(statearr_73790_73822[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__11410__auto__ = null;
var fluree$db$connection_js$state_machine__11410__auto____0 = (function (){
var statearr_73791 = [null,null,null,null,null,null,null,null,null];
(statearr_73791[(0)] = fluree$db$connection_js$state_machine__11410__auto__);

(statearr_73791[(1)] = (1));

return statearr_73791;
});
var fluree$db$connection_js$state_machine__11410__auto____1 = (function (state_73774){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_73774);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e73792){var ex__11413__auto__ = e73792;
var statearr_73793_73823 = state_73774;
(statearr_73793_73823[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_73774[(4)]))){
var statearr_73794_73824 = state_73774;
(statearr_73794_73824[(1)] = cljs.core.first((state_73774[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73825 = state_73774;
state_73774 = G__73825;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__11410__auto__ = function(state_73774){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__11410__auto____1.call(this,state_73774);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__11410__auto____0;
fluree$db$connection_js$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__11410__auto____1;
return fluree$db$connection_js$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_73795 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_73795[(6)] = c__11484__auto__);

return statearr_73795;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_(conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__73827 = arguments.length;
switch (G__73827) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not(open_api_QMARK_)) && (cljs.core.not(has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token(conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__73829 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73829,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73829,(1),null);
var cb_STAR_ = (function (header,data){
var G__73832 = cljs.core.clj__GT_js(header);
var G__73833 = cljs.core.clj__GT_js(data);
return (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(G__73832,G__73833) : callback.call(null,G__73832,G__73833));
});
return fluree.db.connection.add_listener(conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__73834 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73834,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73834,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js(fluree.db.connection.listeners(conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_73887){
var state_val_73888 = (state_73887[(1)]);
if((state_val_73888 === (7))){
var inst_73848 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73849 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_73850 = cljs.core.PersistentHashMap.fromArrays(inst_73848,inst_73849);
var inst_73851 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_73850);
var inst_73852 = (function(){throw inst_73851})();
var state_73887__$1 = state_73887;
var statearr_73889_73921 = state_73887__$1;
(statearr_73889_73921[(2)] = inst_73852);

(statearr_73889_73921[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73888 === (1))){
var state_73887__$1 = state_73887;
var statearr_73890_73922 = state_73887__$1;
(statearr_73890_73922[(2)] = null);

(statearr_73890_73922[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73888 === (4))){
var inst_73837 = (state_73887[(2)]);
var inst_73838 = cljs.core.clj__GT_js(inst_73837);
var inst_73839 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_73838) : reject.call(null,inst_73838));
var state_73887__$1 = state_73887;
var statearr_73891_73923 = state_73887__$1;
(statearr_73891_73923[(2)] = inst_73839);

(statearr_73891_73923[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73888 === (13))){
var inst_73866 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73867 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_73868 = cljs.core.PersistentHashMap.fromArrays(inst_73866,inst_73867);
var inst_73869 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied.",inst_73868);
var inst_73870 = (function(){throw inst_73869})();
var state_73887__$1 = state_73887;
var statearr_73892_73924 = state_73887__$1;
(statearr_73892_73924[(2)] = inst_73870);

(statearr_73892_73924[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73888 === (6))){
var state_73887__$1 = state_73887;
var statearr_73893_73925 = state_73887__$1;
(statearr_73893_73925[(2)] = null);

(statearr_73893_73925[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73888 === (3))){
var inst_73885 = (state_73887[(2)]);
var state_73887__$1 = state_73887;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73887__$1,inst_73885);
} else {
if((state_val_73888 === (12))){
var state_73887__$1 = state_73887;
var statearr_73894_73926 = state_73887__$1;
(statearr_73894_73926[(2)] = null);

(statearr_73894_73926[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73888 === (2))){
var _ = (function (){var statearr_73895 = state_73887;
(statearr_73895[(4)] = cljs.core.cons((5),(state_73887[(4)])));

return statearr_73895;
})();
var inst_73845 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_73887__$1 = state_73887;
if(cljs.core.truth_(inst_73845)){
var statearr_73896_73927 = state_73887__$1;
(statearr_73896_73927[(1)] = (6));

} else {
var statearr_73897_73928 = state_73887__$1;
(statearr_73897_73928[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73888 === (11))){
var inst_73863 = (state_73887[(2)]);
var state_73887__$1 = (function (){var statearr_73899 = state_73887;
(statearr_73899[(7)] = inst_73863);

return statearr_73899;
})();
if(cljs.core.truth_(password)){
var statearr_73900_73929 = state_73887__$1;
(statearr_73900_73929[(1)] = (12));

} else {
var statearr_73901_73930 = state_73887__$1;
(statearr_73901_73930[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73888 === (9))){
var state_73887__$1 = state_73887;
var statearr_73902_73931 = state_73887__$1;
(statearr_73902_73931[(2)] = null);

(statearr_73902_73931[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73888 === (5))){
var _ = (function (){var statearr_73903 = state_73887;
(statearr_73903[(4)] = cljs.core.rest((state_73887[(4)])));

return statearr_73903;
})();
var state_73887__$1 = state_73887;
var ex73898 = (state_73887__$1[(2)]);
var statearr_73904_73932 = state_73887__$1;
(statearr_73904_73932[(5)] = ex73898);


var statearr_73905_73933 = state_73887__$1;
(statearr_73905_73933[(1)] = (4));

(statearr_73905_73933[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73888 === (14))){
var inst_73872 = (state_73887[(2)]);
var inst_73873 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"password","password",417022471),password], 0));
var inst_73874 = fluree.db.util.core.without_nils(inst_73873);
var inst_73875 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_73876 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73877 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73878 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_73874,inst_73875,null];
var inst_73879 = (new cljs.core.PersistentVector(null,4,(5),inst_73877,inst_73878,null));
var inst_73880 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_73876,inst_73879);
var inst_73881 = (function (){var _ = inst_73872;
var data = inst_73874;
var pc = inst_73875;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__73906 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__73906) : reject.call(null,G__73906));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__73907 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__73907) : reject.call(null,G__73907));
} else {
var G__73908 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__73908) : resolve.call(null,G__73908));

}
}
});
})();
var inst_73882 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_73875,inst_73881);
var _ = (function (){var statearr_73909 = state_73887;
(statearr_73909[(4)] = cljs.core.rest((state_73887[(4)])));

return statearr_73909;
})();
var state_73887__$1 = (function (){var statearr_73910 = state_73887;
(statearr_73910[(8)] = inst_73880);

return statearr_73910;
})();
var statearr_73911_73934 = state_73887__$1;
(statearr_73911_73934[(2)] = inst_73882);

(statearr_73911_73934[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73888 === (10))){
var inst_73857 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73858 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_73859 = cljs.core.PersistentHashMap.fromArrays(inst_73857,inst_73858);
var inst_73860 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied.",inst_73859);
var inst_73861 = (function(){throw inst_73860})();
var state_73887__$1 = state_73887;
var statearr_73912_73935 = state_73887__$1;
(statearr_73912_73935[(2)] = inst_73861);

(statearr_73912_73935[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73888 === (8))){
var inst_73854 = (state_73887[(2)]);
var state_73887__$1 = (function (){var statearr_73913 = state_73887;
(statearr_73913[(9)] = inst_73854);

return statearr_73913;
})();
if(cljs.core.truth_(ledger)){
var statearr_73914_73936 = state_73887__$1;
(statearr_73914_73936[(1)] = (9));

} else {
var statearr_73915_73937 = state_73887__$1;
(statearr_73915_73937[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__11410__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__11410__auto____0 = (function (){
var statearr_73916 = [null,null,null,null,null,null,null,null,null,null];
(statearr_73916[(0)] = fluree$db$connection_js$password_generate_$_state_machine__11410__auto__);

(statearr_73916[(1)] = (1));

return statearr_73916;
});
var fluree$db$connection_js$password_generate_$_state_machine__11410__auto____1 = (function (state_73887){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_73887);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e73917){var ex__11413__auto__ = e73917;
var statearr_73918_73938 = state_73887;
(statearr_73918_73938[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_73887[(4)]))){
var statearr_73919_73939 = state_73887;
(statearr_73919_73939[(1)] = cljs.core.first((state_73887[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73940 = state_73887;
state_73887 = G__73940;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__11410__auto__ = function(state_73887){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__11410__auto____1.call(this,state_73887);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__11410__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__11410__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_73920 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_73920[(6)] = c__11484__auto__);

return statearr_73920;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__73942 = arguments.length;
switch (G__73942) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_74009){
var state_val_74010 = (state_74009[(1)]);
if((state_val_74010 === (7))){
var inst_73954 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73955 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_73956 = cljs.core.PersistentHashMap.fromArrays(inst_73954,inst_73955);
var inst_73957 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_73956);
var inst_73958 = (function(){throw inst_73957})();
var state_74009__$1 = state_74009;
var statearr_74011_74053 = state_74009__$1;
(statearr_74011_74053[(2)] = inst_73958);

(statearr_74011_74053[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74010 === (20))){
var inst_73992 = (state_74009[(2)]);
var inst_73993 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_73994 = [ledger,password,user,auth,expire];
var inst_73995 = cljs.core.PersistentHashMap.fromArrays(inst_73993,inst_73994);
var inst_73996 = fluree.db.util.core.without_nils(inst_73995);
var inst_73997 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_73998 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73999 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74000 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_73996,inst_73997,null];
var inst_74001 = (new cljs.core.PersistentVector(null,4,(5),inst_73999,inst_74000,null));
var inst_74002 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_73998,inst_74001);
var inst_74003 = (function (){var _ = inst_73992;
var data = inst_73996;
var pc = inst_73997;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__74012 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__74012) : reject.call(null,G__74012));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__74013 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__74013) : reject.call(null,G__74013));
} else {
fluree.db.connection.add_token(conn,result);

var G__74014 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__74014) : resolve.call(null,G__74014));

}
}
});
})();
var inst_74004 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_73997,inst_74003);
var _ = (function (){var statearr_74015 = state_74009;
(statearr_74015[(4)] = cljs.core.rest((state_74009[(4)])));

return statearr_74015;
})();
var state_74009__$1 = (function (){var statearr_74016 = state_74009;
(statearr_74016[(7)] = inst_74002);

return statearr_74016;
})();
var statearr_74017_74054 = state_74009__$1;
(statearr_74017_74054[(2)] = inst_74004);

(statearr_74017_74054[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74010 === (1))){
var state_74009__$1 = state_74009;
var statearr_74018_74055 = state_74009__$1;
(statearr_74018_74055[(2)] = null);

(statearr_74018_74055[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74010 === (4))){
var inst_73943 = (state_74009[(2)]);
var inst_73944 = cljs.core.clj__GT_js(inst_73943);
var inst_73945 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_73944) : reject.call(null,inst_73944));
var state_74009__$1 = state_74009;
var statearr_74019_74056 = state_74009__$1;
(statearr_74019_74056[(2)] = inst_73945);

(statearr_74019_74056[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74010 === (15))){
var inst_73979 = (state_74009[(8)]);
var state_74009__$1 = state_74009;
var statearr_74020_74057 = state_74009__$1;
(statearr_74020_74057[(2)] = inst_73979);

(statearr_74020_74057[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74010 === (13))){
var inst_73972 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73973 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_73974 = cljs.core.PersistentHashMap.fromArrays(inst_73972,inst_73973);
var inst_73975 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied in the provided JSON.",inst_73974);
var inst_73976 = (function(){throw inst_73975})();
var state_74009__$1 = state_74009;
var statearr_74021_74058 = state_74009__$1;
(statearr_74021_74058[(2)] = inst_73976);

(statearr_74021_74058[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74010 === (6))){
var state_74009__$1 = state_74009;
var statearr_74022_74059 = state_74009__$1;
(statearr_74022_74059[(2)] = null);

(statearr_74022_74059[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74010 === (17))){
var inst_73983 = (state_74009[(2)]);
var state_74009__$1 = state_74009;
if(cljs.core.truth_(inst_73983)){
var statearr_74023_74060 = state_74009__$1;
(statearr_74023_74060[(1)] = (18));

} else {
var statearr_74024_74061 = state_74009__$1;
(statearr_74024_74061[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74010 === (3))){
var inst_74007 = (state_74009[(2)]);
var state_74009__$1 = state_74009;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74009__$1,inst_74007);
} else {
if((state_val_74010 === (12))){
var state_74009__$1 = state_74009;
var statearr_74025_74062 = state_74009__$1;
(statearr_74025_74062[(2)] = null);

(statearr_74025_74062[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74010 === (2))){
var _ = (function (){var statearr_74026 = state_74009;
(statearr_74026[(4)] = cljs.core.cons((5),(state_74009[(4)])));

return statearr_74026;
})();
var inst_73951 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_74009__$1 = state_74009;
if(cljs.core.truth_(inst_73951)){
var statearr_74027_74063 = state_74009__$1;
(statearr_74027_74063[(1)] = (6));

} else {
var statearr_74028_74064 = state_74009__$1;
(statearr_74028_74064[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74010 === (19))){
var inst_73986 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73987 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_73988 = cljs.core.PersistentHashMap.fromArrays(inst_73986,inst_73987);
var inst_73989 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A user identity or auth identity must be supplied.",inst_73988);
var inst_73990 = (function(){throw inst_73989})();
var state_74009__$1 = state_74009;
var statearr_74029_74065 = state_74009__$1;
(statearr_74029_74065[(2)] = inst_73990);

(statearr_74029_74065[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74010 === (11))){
var inst_73969 = (state_74009[(2)]);
var state_74009__$1 = (function (){var statearr_74031 = state_74009;
(statearr_74031[(9)] = inst_73969);

return statearr_74031;
})();
if(cljs.core.truth_(password)){
var statearr_74032_74066 = state_74009__$1;
(statearr_74032_74066[(1)] = (12));

} else {
var statearr_74033_74067 = state_74009__$1;
(statearr_74033_74067[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74010 === (9))){
var state_74009__$1 = state_74009;
var statearr_74034_74068 = state_74009__$1;
(statearr_74034_74068[(2)] = null);

(statearr_74034_74068[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74010 === (5))){
var _ = (function (){var statearr_74035 = state_74009;
(statearr_74035[(4)] = cljs.core.rest((state_74009[(4)])));

return statearr_74035;
})();
var state_74009__$1 = state_74009;
var ex74030 = (state_74009__$1[(2)]);
var statearr_74036_74069 = state_74009__$1;
(statearr_74036_74069[(5)] = ex74030);


var statearr_74037_74070 = state_74009__$1;
(statearr_74037_74070[(1)] = (4));

(statearr_74037_74070[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74010 === (14))){
var inst_73979 = (state_74009[(8)]);
var inst_73978 = (state_74009[(2)]);
var inst_73979__$1 = user;
var state_74009__$1 = (function (){var statearr_74038 = state_74009;
(statearr_74038[(10)] = inst_73978);

(statearr_74038[(8)] = inst_73979__$1);

return statearr_74038;
})();
if(cljs.core.truth_(inst_73979__$1)){
var statearr_74039_74071 = state_74009__$1;
(statearr_74039_74071[(1)] = (15));

} else {
var statearr_74040_74072 = state_74009__$1;
(statearr_74040_74072[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74010 === (16))){
var state_74009__$1 = state_74009;
var statearr_74041_74073 = state_74009__$1;
(statearr_74041_74073[(2)] = auth);

(statearr_74041_74073[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74010 === (10))){
var inst_73963 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73964 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_73965 = cljs.core.PersistentHashMap.fromArrays(inst_73963,inst_73964);
var inst_73966 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied in the provided JSON.",inst_73965);
var inst_73967 = (function(){throw inst_73966})();
var state_74009__$1 = state_74009;
var statearr_74042_74074 = state_74009__$1;
(statearr_74042_74074[(2)] = inst_73967);

(statearr_74042_74074[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74010 === (18))){
var state_74009__$1 = state_74009;
var statearr_74043_74075 = state_74009__$1;
(statearr_74043_74075[(2)] = null);

(statearr_74043_74075[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74010 === (8))){
var inst_73960 = (state_74009[(2)]);
var state_74009__$1 = (function (){var statearr_74044 = state_74009;
(statearr_74044[(11)] = inst_73960);

return statearr_74044;
})();
if(cljs.core.truth_(ledger)){
var statearr_74045_74076 = state_74009__$1;
(statearr_74045_74076[(1)] = (9));

} else {
var statearr_74046_74077 = state_74009__$1;
(statearr_74046_74077[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__11410__auto__ = null;
var fluree$db$connection_js$state_machine__11410__auto____0 = (function (){
var statearr_74047 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74047[(0)] = fluree$db$connection_js$state_machine__11410__auto__);

(statearr_74047[(1)] = (1));

return statearr_74047;
});
var fluree$db$connection_js$state_machine__11410__auto____1 = (function (state_74009){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_74009);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e74048){var ex__11413__auto__ = e74048;
var statearr_74049_74078 = state_74009;
(statearr_74049_74078[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_74009[(4)]))){
var statearr_74050_74079 = state_74009;
(statearr_74050_74079[(1)] = cljs.core.first((state_74009[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74080 = state_74009;
state_74009 = G__74080;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__11410__auto__ = function(state_74009){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__11410__auto____1.call(this,state_74009);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__11410__auto____0;
fluree$db$connection_js$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__11410__auto____1;
return fluree$db$connection_js$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_74051 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_74051[(6)] = c__11484__auto__);

return statearr_74051;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__74082 = arguments.length;
switch (G__74082) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_74117){
var state_val_74118 = (state_74117[(1)]);
if((state_val_74118 === (1))){
var state_74117__$1 = state_74117;
var statearr_74119_74141 = state_74117__$1;
(statearr_74119_74141[(2)] = null);

(statearr_74119_74141[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74118 === (2))){
var _ = (function (){var statearr_74120 = state_74117;
(statearr_74120[(4)] = cljs.core.cons((5),(state_74117[(4)])));

return statearr_74120;
})();
var inst_74091 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_74117__$1 = state_74117;
if(cljs.core.truth_(inst_74091)){
var statearr_74121_74142 = state_74117__$1;
(statearr_74121_74142[(1)] = (6));

} else {
var statearr_74122_74143 = state_74117__$1;
(statearr_74122_74143[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74118 === (3))){
var inst_74115 = (state_74117[(2)]);
var state_74117__$1 = state_74117;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74117__$1,inst_74115);
} else {
if((state_val_74118 === (4))){
var inst_74083 = (state_74117[(2)]);
var inst_74084 = cljs.core.clj__GT_js(inst_74083);
var inst_74085 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_74084) : reject.call(null,inst_74084));
var state_74117__$1 = state_74117;
var statearr_74124_74144 = state_74117__$1;
(statearr_74124_74144[(2)] = inst_74085);

(statearr_74124_74144[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74118 === (5))){
var _ = (function (){var statearr_74125 = state_74117;
(statearr_74125[(4)] = cljs.core.rest((state_74117[(4)])));

return statearr_74125;
})();
var state_74117__$1 = state_74117;
var ex74123 = (state_74117__$1[(2)]);
var statearr_74126_74145 = state_74117__$1;
(statearr_74126_74145[(5)] = ex74123);


var statearr_74127_74146 = state_74117__$1;
(statearr_74127_74146[(1)] = (4));

(statearr_74127_74146[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74118 === (6))){
var state_74117__$1 = state_74117;
var statearr_74128_74147 = state_74117__$1;
(statearr_74128_74147[(2)] = null);

(statearr_74128_74147[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74118 === (7))){
var inst_74094 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74095 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_74096 = cljs.core.PersistentHashMap.fromArrays(inst_74094,inst_74095);
var inst_74097 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_74096);
var inst_74098 = (function(){throw inst_74097})();
var state_74117__$1 = state_74117;
var statearr_74129_74148 = state_74117__$1;
(statearr_74129_74148[(2)] = inst_74098);

(statearr_74129_74148[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74118 === (8))){
var inst_74100 = (state_74117[(2)]);
var inst_74101 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_74102 = [jwt,expire];
var inst_74103 = cljs.core.PersistentHashMap.fromArrays(inst_74101,inst_74102);
var inst_74104 = fluree.db.util.core.without_nils(inst_74103);
var inst_74105 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_74106 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_74107 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74108 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_74104,inst_74105,null];
var inst_74109 = (new cljs.core.PersistentVector(null,4,(5),inst_74107,inst_74108,null));
var inst_74110 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_74106,inst_74109);
var inst_74111 = (function (){var _ = inst_74100;
var data = inst_74104;
var pc = inst_74105;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__74130 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__74130) : reject.call(null,G__74130));
} else {
return null;
}
} else {
fluree.db.connection.add_token(conn,result);

var G__74131 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__74131) : resolve.call(null,G__74131));

}
});
})();
var inst_74112 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_74105,inst_74111);
var _ = (function (){var statearr_74132 = state_74117;
(statearr_74132[(4)] = cljs.core.rest((state_74117[(4)])));

return statearr_74132;
})();
var state_74117__$1 = (function (){var statearr_74133 = state_74117;
(statearr_74133[(7)] = inst_74110);

return statearr_74133;
})();
var statearr_74134_74149 = state_74117__$1;
(statearr_74134_74149[(2)] = inst_74112);

(statearr_74134_74149[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__11410__auto__ = null;
var fluree$db$connection_js$state_machine__11410__auto____0 = (function (){
var statearr_74135 = [null,null,null,null,null,null,null,null];
(statearr_74135[(0)] = fluree$db$connection_js$state_machine__11410__auto__);

(statearr_74135[(1)] = (1));

return statearr_74135;
});
var fluree$db$connection_js$state_machine__11410__auto____1 = (function (state_74117){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_74117);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e74136){var ex__11413__auto__ = e74136;
var statearr_74137_74150 = state_74117;
(statearr_74137_74150[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_74117[(4)]))){
var statearr_74138_74151 = state_74117;
(statearr_74138_74151[(1)] = cljs.core.first((state_74117[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74152 = state_74117;
state_74117 = G__74152;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__11410__auto__ = function(state_74117){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__11410__auto____1.call(this,state_74117);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__11410__auto____0;
fluree$db$connection_js$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__11410__auto____1;
return fluree$db$connection_js$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_74139 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_74139[(6)] = c__11484__auto__);

return statearr_74139;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

