// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.connection_js');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__4870__auto__ = [];
var len__4864__auto___74226 = arguments.length;
var i__4865__auto___74227 = (0);
while(true){
if((i__4865__auto___74227 < len__4864__auto___74226)){
args__4870__auto__.push((arguments[i__4865__auto___74227]));

var G__74228 = (i__4865__auto___74227 + (1));
i__4865__auto___74227 = G__74228;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__74158){
var vec__74159 = p__74158;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74159,(0),null);
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__11484__auto___74229 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_74203){
var state_val_74204 = (state_74203[(1)]);
if((state_val_74204 === (7))){
var inst_74180 = (state_74203[(7)]);
var inst_74189 = (state_74203[(8)]);
var inst_74191 = fluree.db.time_travel.as_of_block(inst_74189,inst_74180);
var state_74203__$1 = state_74203;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74203__$1,(10),inst_74191);
} else {
if((state_val_74204 === (1))){
var state_74203__$1 = state_74203;
var statearr_74205_74230 = state_74203__$1;
(statearr_74205_74230[(2)] = null);

(statearr_74205_74230[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74204 === (4))){
var inst_74162 = (state_74203[(2)]);
var inst_74163 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74162], 0));
var inst_74164 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_74162);
var inst_74165 = cljs.core.async.close_BANG_(pc);
var state_74203__$1 = (function (){var statearr_74206 = state_74203;
(statearr_74206[(9)] = inst_74163);

(statearr_74206[(10)] = inst_74164);

return statearr_74206;
})();
var statearr_74207_74231 = state_74203__$1;
(statearr_74207_74231[(2)] = inst_74165);

(statearr_74207_74231[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74204 === (6))){
var inst_74180 = (state_74203[(7)]);
var inst_74183 = (state_74203[(11)]);
var inst_74184 = (state_74203[(12)]);
var inst_74187 = (state_74203[(2)]);
var inst_74188 = fluree.db.util.async.throw_err(inst_74187);
var inst_74189 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_74188,new cljs.core.Keyword(null,"conn","conn",278309663),conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),inst_74183,new cljs.core.Keyword(null,"dbid","dbid",-196647356),inst_74184], 0));
var state_74203__$1 = (function (){var statearr_74208 = state_74203;
(statearr_74208[(8)] = inst_74189);

return statearr_74208;
})();
if(cljs.core.truth_(inst_74180)){
var statearr_74209_74232 = state_74203__$1;
(statearr_74209_74232[(1)] = (7));

} else {
var statearr_74210_74233 = state_74203__$1;
(statearr_74210_74233[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74204 === (3))){
var inst_74201 = (state_74203[(2)]);
var state_74203__$1 = state_74203;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74203__$1,inst_74201);
} else {
if((state_val_74204 === (2))){
var _ = (function (){var statearr_74212 = state_74203;
(statearr_74212[(4)] = cljs.core.cons((5),(state_74203[(4)])));

return statearr_74212;
})();
var inst_74175 = opts;
var inst_74176 = cljs.core.__destructure_map(inst_74175);
var inst_74177 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74176,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_74178 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74176,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_74179 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74176,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_74180 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74176,new cljs.core.Keyword(null,"block","block",664686210));
var inst_74181 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,opts);
var inst_74182 = fluree.db.session.resolve_ledger(conn,ledger);
var inst_74183 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74182,(0),null);
var inst_74184 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74182,(1),null);
var inst_74185 = fluree.db.session.db(conn,ledger,opts);
var state_74203__$1 = (function (){var statearr_74213 = state_74203;
(statearr_74213[(7)] = inst_74180);

(statearr_74213[(11)] = inst_74183);

(statearr_74213[(13)] = inst_74178);

(statearr_74213[(14)] = inst_74179);

(statearr_74213[(15)] = inst_74177);

(statearr_74213[(16)] = inst_74181);

(statearr_74213[(12)] = inst_74184);

return statearr_74213;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74203__$1,(6),inst_74185);
} else {
if((state_val_74204 === (9))){
var inst_74197 = (state_74203[(2)]);
var inst_74198 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_74197);
var _ = (function (){var statearr_74214 = state_74203;
(statearr_74214[(4)] = cljs.core.rest((state_74203[(4)])));

return statearr_74214;
})();
var state_74203__$1 = state_74203;
var statearr_74215_74234 = state_74203__$1;
(statearr_74215_74234[(2)] = inst_74198);

(statearr_74215_74234[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74204 === (5))){
var _ = (function (){var statearr_74216 = state_74203;
(statearr_74216[(4)] = cljs.core.rest((state_74203[(4)])));

return statearr_74216;
})();
var state_74203__$1 = state_74203;
var ex74211 = (state_74203__$1[(2)]);
var statearr_74217_74235 = state_74203__$1;
(statearr_74217_74235[(5)] = ex74211);


var statearr_74218_74236 = state_74203__$1;
(statearr_74218_74236[(1)] = (4));

(statearr_74218_74236[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74204 === (10))){
var inst_74193 = (state_74203[(2)]);
var inst_74194 = fluree.db.util.async.throw_err(inst_74193);
var state_74203__$1 = state_74203;
var statearr_74219_74237 = state_74203__$1;
(statearr_74219_74237[(2)] = inst_74194);

(statearr_74219_74237[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74204 === (8))){
var inst_74189 = (state_74203[(8)]);
var state_74203__$1 = state_74203;
var statearr_74220_74238 = state_74203__$1;
(statearr_74220_74238[(2)] = inst_74189);

(statearr_74220_74238[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__11410__auto__ = null;
var fluree$db$api_js$state_machine__11410__auto____0 = (function (){
var statearr_74221 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74221[(0)] = fluree$db$api_js$state_machine__11410__auto__);

(statearr_74221[(1)] = (1));

return statearr_74221;
});
var fluree$db$api_js$state_machine__11410__auto____1 = (function (state_74203){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_74203);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e74222){var ex__11413__auto__ = e74222;
var statearr_74223_74239 = state_74203;
(statearr_74223_74239[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_74203[(4)]))){
var statearr_74224_74240 = state_74203;
(statearr_74224_74240[(1)] = cljs.core.first((state_74203[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74241 = state_74203;
state_74203 = G__74241;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__11410__auto__ = function(state_74203){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__11410__auto____1.call(this,state_74203);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__11410__auto____0;
fluree$db$api_js$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__11410__auto____1;
return fluree$db$api_js$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_74225 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_74225[(6)] = c__11484__auto___74229);

return statearr_74225;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq74155){
var G__74156 = cljs.core.first(seq74155);
var seq74155__$1 = cljs.core.next(seq74155);
var G__74157 = cljs.core.first(seq74155__$1);
var seq74155__$2 = cljs.core.next(seq74155__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__74156,G__74157,seq74155__$2);
}));

fluree.db.api_js.db_ident_QMARK_ = (function fluree$db$api_js$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(dbid){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__4251__auto__){
var and__4251__auto____$1 = open_api;
if(cljs.core.truth_(and__4251__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(network,cljs.core.first(clojure.string.split.cljs$core$IFn$_invoke$arity$2(val,/\//)));
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(db_fn,conn,db_id,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,ledger);
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__4251__auto__){
return open_api;
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__4251__auto__){
return auth;
} else {
return and__4251__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id(val);
var ledger = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(db_fn,conn,db_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__74243 = arguments.length;
switch (G__74243) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3(sources,query_map,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,db_fn){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_74369){
var state_val_74370 = (state_74369[(1)]);
if((state_val_74370 === (7))){
var inst_74269 = (state_74369[(7)]);
var inst_74259 = (state_74369[(8)]);
var inst_74271 = fluree.db.time_travel.as_of_block(inst_74269,inst_74259);
var state_74369__$1 = state_74369;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74369__$1,(10),inst_74271);
} else {
if((state_val_74370 === (20))){
var inst_74263 = (state_74369[(9)]);
var state_74369__$1 = state_74369;
var statearr_74371_74451 = state_74369__$1;
(statearr_74371_74451[(2)] = inst_74263);

(statearr_74371_74451[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (27))){
var inst_74257 = (state_74369[(10)]);
var state_74369__$1 = state_74369;
var statearr_74372_74452 = state_74369__$1;
(statearr_74372_74452[(2)] = inst_74257);

(statearr_74372_74452[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (1))){
var state_74369__$1 = state_74369;
var statearr_74373_74453 = state_74369__$1;
(statearr_74373_74453[(2)] = null);

(statearr_74373_74453[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (24))){
var inst_74266 = (state_74369[(11)]);
var state_74369__$1 = state_74369;
if(cljs.core.truth_(inst_74266)){
var statearr_74374_74454 = state_74369__$1;
(statearr_74374_74454[(1)] = (26));

} else {
var statearr_74375_74455 = state_74369__$1;
(statearr_74375_74455[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (39))){
var inst_74331 = (state_74369[(12)]);
var inst_74334 = cljs.core.ex_data(inst_74331);
var inst_74335 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74336 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_74334);
var inst_74337 = cljs.core.ex_message(inst_74331);
var inst_74338 = [inst_74336,inst_74337,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74339 = cljs.core.PersistentHashMap.fromArrays(inst_74335,inst_74338);
var state_74369__$1 = state_74369;
var statearr_74376_74456 = state_74369__$1;
(statearr_74376_74456[(2)] = inst_74339);

(statearr_74376_74456[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (46))){
var inst_74331 = (state_74369[(12)]);
var state_74369__$1 = state_74369;
var statearr_74377_74457 = state_74369__$1;
(statearr_74377_74457[(2)] = inst_74331);

(statearr_74377_74457[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (4))){
var inst_74244 = (state_74369[(2)]);
var inst_74245 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74244], 0));
var inst_74246 = cljs.core.ex_data(inst_74244);
var inst_74247 = cljs.core.ex_message(inst_74244);
var inst_74248 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_74246,new cljs.core.Keyword(null,"message","message",-406056002),inst_74247);
var state_74369__$1 = (function (){var statearr_74378 = state_74369;
(statearr_74378[(13)] = inst_74245);

return statearr_74378;
})();
var statearr_74379_74458 = state_74369__$1;
(statearr_74379_74458[(2)] = inst_74248);

(statearr_74379_74458[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (15))){
var state_74369__$1 = state_74369;
var statearr_74380_74459 = state_74369__$1;
(statearr_74380_74459[(2)] = (1000000));

(statearr_74380_74459[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (48))){
var inst_74331 = (state_74369[(12)]);
var state_74369__$1 = state_74369;
var statearr_74381_74460 = state_74369__$1;
(statearr_74381_74460[(2)] = inst_74331);

(statearr_74381_74460[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (50))){
var inst_74358 = (state_74369[(2)]);
var state_74369__$1 = state_74369;
var statearr_74382_74461 = state_74369__$1;
(statearr_74382_74461[(2)] = inst_74358);

(statearr_74382_74461[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (21))){
var inst_74262 = (state_74369[(14)]);
var state_74369__$1 = state_74369;
if(cljs.core.truth_(inst_74262)){
var statearr_74383_74462 = state_74369__$1;
(statearr_74383_74462[(1)] = (23));

} else {
var statearr_74384_74463 = state_74369__$1;
(statearr_74384_74463[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (31))){
var inst_74320 = (state_74369[(2)]);
var inst_74321 = cljs.core.not(inst_74320);
var state_74369__$1 = state_74369;
if(inst_74321){
var statearr_74385_74464 = state_74369__$1;
(statearr_74385_74464[(1)] = (35));

} else {
var statearr_74386_74465 = state_74369__$1;
(statearr_74386_74465[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (32))){
var inst_74264 = (state_74369[(15)]);
var state_74369__$1 = state_74369;
var statearr_74387_74466 = state_74369__$1;
(statearr_74387_74466[(2)] = inst_74264);

(statearr_74387_74466[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (40))){
var inst_74294 = (state_74369[(16)]);
var state_74369__$1 = state_74369;
if(cljs.core.truth_(inst_74294)){
var statearr_74388_74467 = state_74369__$1;
(statearr_74388_74467[(1)] = (42));

} else {
var statearr_74389_74468 = state_74369__$1;
(statearr_74389_74468[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (33))){
var inst_74260 = (state_74369[(17)]);
var state_74369__$1 = state_74369;
var statearr_74390_74469 = state_74369__$1;
(statearr_74390_74469[(2)] = inst_74260);

(statearr_74390_74469[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (13))){
var inst_74265 = (state_74369[(18)]);
var inst_74289 = (state_74369[(19)]);
var inst_74287 = (state_74369[(2)]);
var inst_74288 = cljs.core.volatile_BANG_((0));
var inst_74289__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_74265);
var state_74369__$1 = (function (){var statearr_74391 = state_74369;
(statearr_74391[(20)] = inst_74288);

(statearr_74391[(19)] = inst_74289__$1);

(statearr_74391[(21)] = inst_74287);

return statearr_74391;
})();
if(cljs.core.truth_(inst_74289__$1)){
var statearr_74392_74470 = state_74369__$1;
(statearr_74392_74470[(1)] = (14));

} else {
var statearr_74393_74471 = state_74369__$1;
(statearr_74393_74471[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (22))){
var inst_74310 = (state_74369[(2)]);
var state_74369__$1 = state_74369;
var statearr_74394_74472 = state_74369__$1;
(statearr_74394_74472[(2)] = inst_74310);

(statearr_74394_74472[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (36))){
var inst_74277 = (state_74369[(22)]);
var inst_74296 = (state_74369[(23)]);
var inst_74327 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_74296);
var inst_74328 = fluree.db.query.fql.query(inst_74277,inst_74327);
var state_74369__$1 = state_74369;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74369__$1,(38),inst_74328);
} else {
if((state_val_74370 === (41))){
var inst_74362 = (state_74369[(2)]);
var state_74369__$1 = state_74369;
var statearr_74395_74473 = state_74369__$1;
(statearr_74395_74473[(2)] = inst_74362);

(statearr_74395_74473[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (43))){
var state_74369__$1 = state_74369;
var statearr_74396_74474 = state_74369__$1;
(statearr_74396_74474[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (29))){
var inst_74264 = (state_74369[(15)]);
var state_74369__$1 = state_74369;
if(cljs.core.truth_(inst_74264)){
var statearr_74398_74475 = state_74369__$1;
(statearr_74398_74475[(1)] = (32));

} else {
var statearr_74399_74476 = state_74369__$1;
(statearr_74399_74476[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (44))){
var inst_74360 = (state_74369[(2)]);
var state_74369__$1 = state_74369;
var statearr_74400_74477 = state_74369__$1;
(statearr_74400_74477[(2)] = inst_74360);

(statearr_74400_74477[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (6))){
var inst_74259 = (state_74369[(8)]);
var inst_74268 = (state_74369[(2)]);
var inst_74269 = fluree.db.util.async.throw_err(inst_74268);
var state_74369__$1 = (function (){var statearr_74401 = state_74369;
(statearr_74401[(7)] = inst_74269);

return statearr_74401;
})();
if(cljs.core.truth_(inst_74259)){
var statearr_74402_74478 = state_74369__$1;
(statearr_74402_74478[(1)] = (7));

} else {
var statearr_74403_74479 = state_74369__$1;
(statearr_74403_74479[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (28))){
var inst_74306 = (state_74369[(2)]);
var state_74369__$1 = state_74369;
var statearr_74404_74480 = state_74369__$1;
(statearr_74404_74480[(2)] = inst_74306);

(statearr_74404_74480[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (25))){
var inst_74308 = (state_74369[(2)]);
var state_74369__$1 = state_74369;
var statearr_74405_74481 = state_74369__$1;
(statearr_74405_74481[(2)] = inst_74308);

(statearr_74405_74481[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (34))){
var inst_74317 = (state_74369[(2)]);
var state_74369__$1 = state_74369;
var statearr_74406_74482 = state_74369__$1;
(statearr_74406_74482[(2)] = inst_74317);

(statearr_74406_74482[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (17))){
var inst_74258 = (state_74369[(24)]);
var state_74369__$1 = state_74369;
var statearr_74407_74483 = state_74369__$1;
(statearr_74407_74483[(2)] = inst_74258);

(statearr_74407_74483[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (3))){
var inst_74367 = (state_74369[(2)]);
var state_74369__$1 = state_74369;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74369__$1,inst_74367);
} else {
if((state_val_74370 === (12))){
var inst_74285 = cljs.core.PersistentHashMap.EMPTY;
var state_74369__$1 = state_74369;
var statearr_74408_74484 = state_74369__$1;
(statearr_74408_74484[(2)] = inst_74285);

(statearr_74408_74484[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (2))){
var _ = (function (){var statearr_74409 = state_74369;
(statearr_74409[(4)] = cljs.core.cons((5),(state_74369[(4)])));

return statearr_74409;
})();
var inst_74255 = query_map;
var inst_74256 = cljs.core.__destructure_map(inst_74255);
var inst_74257 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74256,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_74258 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74256,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_74259 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74256,new cljs.core.Keyword(null,"block","block",664686210));
var inst_74260 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74256,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_74261 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74256,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_74262 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74256,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_74263 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74256,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_74264 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74256,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_74265 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74256,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_74266 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74256,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_74369__$1 = (function (){var statearr_74410 = state_74369;
(statearr_74410[(17)] = inst_74260);

(statearr_74410[(24)] = inst_74258);

(statearr_74410[(10)] = inst_74257);

(statearr_74410[(11)] = inst_74266);

(statearr_74410[(18)] = inst_74265);

(statearr_74410[(14)] = inst_74262);

(statearr_74410[(8)] = inst_74259);

(statearr_74410[(15)] = inst_74264);

(statearr_74410[(9)] = inst_74263);

(statearr_74410[(25)] = inst_74261);

return statearr_74410;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74369__$1,(6),sources);
} else {
if((state_val_74370 === (23))){
var inst_74262 = (state_74369[(14)]);
var state_74369__$1 = state_74369;
var statearr_74411_74485 = state_74369__$1;
(statearr_74411_74485[(2)] = inst_74262);

(statearr_74411_74485[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (47))){
var inst_74288 = (state_74369[(20)]);
var inst_74277 = (state_74369[(22)]);
var inst_74342 = (state_74369[(26)]);
var inst_74295 = (state_74369[(27)]);
var inst_74348 = (state_74369[(2)]);
var inst_74349 = cljs.core.deref(inst_74288);
var inst_74350 = fluree.db.util.core.response_time_formatted(inst_74295);
var inst_74351 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_74277);
var inst_74352 = [(200),inst_74348,inst_74349,inst_74350,inst_74351];
var inst_74353 = cljs.core.PersistentHashMap.fromArrays(inst_74342,inst_74352);
var state_74369__$1 = state_74369;
var statearr_74412_74486 = state_74369__$1;
(statearr_74412_74486[(2)] = inst_74353);

(statearr_74412_74486[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (35))){
var inst_74323 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74324 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74325 = cljs.core.PersistentHashMap.fromArrays(inst_74323,inst_74324);
var state_74369__$1 = state_74369;
var statearr_74413_74487 = state_74369__$1;
(statearr_74413_74487[(2)] = inst_74325);

(statearr_74413_74487[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (19))){
var inst_74312 = (state_74369[(28)]);
var inst_74312__$1 = (state_74369[(2)]);
var state_74369__$1 = (function (){var statearr_74414 = state_74369;
(statearr_74414[(28)] = inst_74312__$1);

return statearr_74414;
})();
if(cljs.core.truth_(inst_74312__$1)){
var statearr_74415_74488 = state_74369__$1;
(statearr_74415_74488[(1)] = (29));

} else {
var statearr_74416_74489 = state_74369__$1;
(statearr_74416_74489[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (11))){
var inst_74278 = (state_74369[(29)]);
var inst_74277 = (state_74369[(22)]);
var inst_74261 = (state_74369[(25)]);
var inst_74280 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_74277);
var inst_74281 = fluree.db.connection_js.open_api_QMARK_(inst_74278);
var inst_74282 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_74277);
var inst_74283 = fluree.db.api_js.get_sources(inst_74278,inst_74280,inst_74281,inst_74282,inst_74261,db_fn);
var state_74369__$1 = state_74369;
var statearr_74418_74490 = state_74369__$1;
(statearr_74418_74490[(2)] = inst_74283);

(statearr_74418_74490[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (9))){
var inst_74277 = (state_74369[(22)]);
var inst_74261 = (state_74369[(25)]);
var inst_74277__$1 = (state_74369[(2)]);
var inst_74278 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_74277__$1);
var state_74369__$1 = (function (){var statearr_74419 = state_74369;
(statearr_74419[(29)] = inst_74278);

(statearr_74419[(22)] = inst_74277__$1);

return statearr_74419;
})();
if(cljs.core.truth_(inst_74261)){
var statearr_74420_74491 = state_74369__$1;
(statearr_74420_74491[(1)] = (11));

} else {
var statearr_74421_74492 = state_74369__$1;
(statearr_74421_74492[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (5))){
var _ = (function (){var statearr_74422 = state_74369;
(statearr_74422[(4)] = cljs.core.rest((state_74369[(4)])));

return statearr_74422;
})();
var state_74369__$1 = state_74369;
var ex74417 = (state_74369__$1[(2)]);
var statearr_74423_74493 = state_74369__$1;
(statearr_74423_74493[(5)] = ex74417);


var statearr_74424_74494 = state_74369__$1;
(statearr_74424_74494[(1)] = (4));

(statearr_74424_74494[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (14))){
var inst_74289 = (state_74369[(19)]);
var state_74369__$1 = state_74369;
var statearr_74425_74495 = state_74369__$1;
(statearr_74425_74495[(2)] = inst_74289);

(statearr_74425_74495[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (45))){
var inst_74331 = (state_74369[(12)]);
var inst_74345 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_74331);
var state_74369__$1 = state_74369;
var statearr_74426_74496 = state_74369__$1;
(statearr_74426_74496[(2)] = inst_74345);

(statearr_74426_74496[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (26))){
var inst_74266 = (state_74369[(11)]);
var state_74369__$1 = state_74369;
var statearr_74427_74497 = state_74369__$1;
(statearr_74427_74497[(2)] = inst_74266);

(statearr_74427_74497[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (16))){
var inst_74288 = (state_74369[(20)]);
var inst_74258 = (state_74369[(24)]);
var inst_74265 = (state_74369[(18)]);
var inst_74287 = (state_74369[(21)]);
var inst_74293 = (state_74369[(2)]);
var inst_74294 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_74265);
var inst_74295 = fluree.db.util.core.current_time_millis();
var inst_74296 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_74265,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_74287,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_74293,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_74288], 0));
var state_74369__$1 = (function (){var statearr_74428 = state_74369;
(statearr_74428[(16)] = inst_74294);

(statearr_74428[(23)] = inst_74296);

(statearr_74428[(27)] = inst_74295);

return statearr_74428;
})();
if(cljs.core.truth_(inst_74258)){
var statearr_74429_74498 = state_74369__$1;
(statearr_74429_74498[(1)] = (17));

} else {
var statearr_74430_74499 = state_74369__$1;
(statearr_74430_74499[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (38))){
var inst_74331 = (state_74369[(12)]);
var inst_74330 = (state_74369[(2)]);
var inst_74331__$1 = fluree.db.util.async.throw_err(inst_74330);
var inst_74332 = (inst_74331__$1 instanceof cljs.core.ExceptionInfo);
var state_74369__$1 = (function (){var statearr_74431 = state_74369;
(statearr_74431[(12)] = inst_74331__$1);

return statearr_74431;
})();
if(cljs.core.truth_(inst_74332)){
var statearr_74432_74500 = state_74369__$1;
(statearr_74432_74500[(1)] = (39));

} else {
var statearr_74433_74501 = state_74369__$1;
(statearr_74433_74501[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (30))){
var inst_74312 = (state_74369[(28)]);
var state_74369__$1 = state_74369;
var statearr_74434_74502 = state_74369__$1;
(statearr_74434_74502[(2)] = inst_74312);

(statearr_74434_74502[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (10))){
var inst_74273 = (state_74369[(2)]);
var inst_74274 = fluree.db.util.async.throw_err(inst_74273);
var state_74369__$1 = state_74369;
var statearr_74435_74503 = state_74369__$1;
(statearr_74435_74503[(2)] = inst_74274);

(statearr_74435_74503[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (18))){
var inst_74263 = (state_74369[(9)]);
var state_74369__$1 = state_74369;
if(cljs.core.truth_(inst_74263)){
var statearr_74436_74504 = state_74369__$1;
(statearr_74436_74504[(1)] = (20));

} else {
var statearr_74437_74505 = state_74369__$1;
(statearr_74437_74505[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (42))){
var inst_74331 = (state_74369[(12)]);
var inst_74342 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_74343 = cljs.core.sequential_QMARK_(inst_74331);
var state_74369__$1 = (function (){var statearr_74438 = state_74369;
(statearr_74438[(26)] = inst_74342);

return statearr_74438;
})();
if(inst_74343){
var statearr_74439_74506 = state_74369__$1;
(statearr_74439_74506[(1)] = (45));

} else {
var statearr_74440_74507 = state_74369__$1;
(statearr_74440_74507[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (37))){
var inst_74364 = (state_74369[(2)]);
var _ = (function (){var statearr_74441 = state_74369;
(statearr_74441[(4)] = cljs.core.rest((state_74369[(4)])));

return statearr_74441;
})();
var state_74369__$1 = state_74369;
var statearr_74442_74508 = state_74369__$1;
(statearr_74442_74508[(2)] = inst_74364);

(statearr_74442_74508[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (8))){
var inst_74269 = (state_74369[(7)]);
var state_74369__$1 = state_74369;
var statearr_74443_74509 = state_74369__$1;
(statearr_74443_74509[(2)] = inst_74269);

(statearr_74443_74509[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74370 === (49))){
var state_74369__$1 = state_74369;
var statearr_74444_74510 = state_74369__$1;
(statearr_74444_74510[(2)] = null);

(statearr_74444_74510[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__11410__auto__ = null;
var fluree$db$api_js$state_machine__11410__auto____0 = (function (){
var statearr_74445 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74445[(0)] = fluree$db$api_js$state_machine__11410__auto__);

(statearr_74445[(1)] = (1));

return statearr_74445;
});
var fluree$db$api_js$state_machine__11410__auto____1 = (function (state_74369){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_74369);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e74446){var ex__11413__auto__ = e74446;
var statearr_74447_74511 = state_74369;
(statearr_74447_74511[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_74369[(4)]))){
var statearr_74448_74512 = state_74369;
(statearr_74448_74512[(1)] = cljs.core.first((state_74369[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74513 = state_74369;
state_74369 = G__74513;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__11410__auto__ = function(state_74369){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__11410__auto____1.call(this,state_74369);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__11410__auto____0;
fluree$db$api_js$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__11410__auto____1;
return fluree$db$api_js$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_74449 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_74449[(6)] = c__11484__auto__);

return statearr_74449;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_(timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$2(conn,ledger);
var key = cljs.core.random_uuid();
var resp_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout_ms);
fluree.db.session.monitor_tx(session,tid,key,(function (p1__74514_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,p1__74514_SHARP_);
}));

var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_74536){
var state_val_74537 = (state_74536[(1)]);
if((state_val_74537 === (1))){
var inst_74518 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74519 = [resp_chan,timeout_chan];
var inst_74520 = (new cljs.core.PersistentVector(null,2,(5),inst_74518,inst_74519,null));
var state_74536__$1 = state_74536;
return cljs.core.async.ioc_alts_BANG_(state_74536__$1,(2),inst_74520);
} else {
if((state_val_74537 === (2))){
var inst_74522 = (state_74536[(2)]);
var inst_74523 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74522,(0),null);
var inst_74524 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74522,(1),null);
var inst_74525 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(timeout_chan,inst_74524);
var state_74536__$1 = (function (){var statearr_74538 = state_74536;
(statearr_74538[(7)] = inst_74523);

return statearr_74538;
})();
if(inst_74525){
var statearr_74539_74549 = state_74536__$1;
(statearr_74539_74549[(1)] = (3));

} else {
var statearr_74540_74550 = state_74536__$1;
(statearr_74540_74550[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74537 === (3))){
var inst_74527 = fluree.db.session.monitor_tx_remove(session,tid,key);
var inst_74528 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_74529 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_74530 = [tid,(408),inst_74529];
var inst_74531 = cljs.core.PersistentHashMap.fromArrays(inst_74528,inst_74530);
var state_74536__$1 = (function (){var statearr_74541 = state_74536;
(statearr_74541[(8)] = inst_74527);

return statearr_74541;
})();
var statearr_74542_74551 = state_74536__$1;
(statearr_74542_74551[(2)] = inst_74531);

(statearr_74542_74551[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74537 === (4))){
var inst_74523 = (state_74536[(7)]);
var state_74536__$1 = state_74536;
var statearr_74543_74552 = state_74536__$1;
(statearr_74543_74552[(2)] = inst_74523);

(statearr_74543_74552[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74537 === (5))){
var inst_74534 = (state_74536[(2)]);
var state_74536__$1 = state_74536;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74536__$1,inst_74534);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__11410__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__11410__auto____0 = (function (){
var statearr_74544 = [null,null,null,null,null,null,null,null,null];
(statearr_74544[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__11410__auto__);

(statearr_74544[(1)] = (1));

return statearr_74544;
});
var fluree$db$api_js$monitor_tx_$_state_machine__11410__auto____1 = (function (state_74536){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_74536);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e74545){var ex__11413__auto__ = e74545;
var statearr_74546_74553 = state_74536;
(statearr_74546_74553[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_74536[(4)]))){
var statearr_74547_74554 = state_74536;
(statearr_74547_74554[(1)] = cljs.core.first((state_74536[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74555 = state_74536;
state_74536 = G__74555;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__11410__auto__ = function(state_74536){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__11410__auto____1.call(this,state_74536);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__11410__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__11410__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_74548 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_74548[(6)] = c__11484__auto__);

return statearr_74548;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__74557 = arguments.length;
switch (G__74557) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var db_name = ((cljs.core.sequential_QMARK_(ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second(ledger))].join(''):ledger);
var map__74558 = opts;
var map__74558__$1 = cljs.core.__destructure_map(map__74558);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74558__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74558__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74558__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74558__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_(deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = (fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1(private_key) : fluree.crypto.account_id_from_private.call(null,private_key));
var vec__74559 = (cljs.core.truth_((function (){var and__4251__auto__ = auth;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(auth,key_auth_id);
} else {
return and__4251__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74559,(0),null);
var authority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74559,(1),null);
var timestamp = fluree.db.util.core.current_time_millis();
var nonce__$1 = (function (){var or__4253__auto__ = nonce;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4253__auto__ = expire;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify(fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e74562){var e = e74562;

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.sign_message(cmd,private_key);
var id = fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1(cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__74565 = arguments.length;
switch (G__74565) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_74631){
var state_val_74632 = (state_74631[(1)]);
if((state_val_74632 === (7))){
var inst_74584 = (state_74631[(7)]);
var inst_74582 = (state_74631[(8)]);
var inst_74587 = (state_74631[(9)]);
var inst_74585 = (state_74631[(10)]);
var inst_74586 = (state_74631[(11)]);
var inst_74600 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_74601 = [ledger,txn,inst_74582,inst_74584,inst_74585,inst_74586,inst_74587];
var inst_74602 = cljs.core.PersistentHashMap.fromArrays(inst_74600,inst_74601);
var inst_74603 = fluree.db.util.core.without_nils(inst_74602);
var inst_74604 = fluree.db.operations.transact_async(conn,inst_74603);
var state_74631__$1 = state_74631;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74631__$1,(13),inst_74604);
} else {
if((state_val_74632 === (20))){
var inst_74622 = (state_74631[(2)]);
var state_74631__$1 = state_74631;
var statearr_74633_74669 = state_74631__$1;
(statearr_74633_74669[(2)] = inst_74622);

(statearr_74633_74669[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74632 === (1))){
var state_74631__$1 = state_74631;
var statearr_74634_74670 = state_74631__$1;
(statearr_74634_74670[(2)] = null);

(statearr_74634_74670[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74632 === (4))){
var inst_74566 = (state_74631[(2)]);
var inst_74567 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74566], 0));
var inst_74568 = cljs.core.ex_data(inst_74566);
var inst_74569 = cljs.core.ex_message(inst_74566);
var inst_74570 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_74568,new cljs.core.Keyword(null,"message","message",-406056002),inst_74569);
var state_74631__$1 = (function (){var statearr_74635 = state_74631;
(statearr_74635[(12)] = inst_74567);

return statearr_74635;
})();
var statearr_74636_74671 = state_74631__$1;
(statearr_74636_74671[(2)] = inst_74570);

(statearr_74636_74671[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74632 === (15))){
var inst_74606 = (state_74631[(13)]);
var inst_74581 = (state_74631[(14)]);
var inst_74609 = fluree.db.api_js.monitor_tx(conn,ledger,inst_74606,inst_74581);
var state_74631__$1 = state_74631;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74631__$1,(17),inst_74609);
} else {
if((state_val_74632 === (13))){
var inst_74580 = (state_74631[(15)]);
var inst_74606 = (state_74631[(2)]);
var state_74631__$1 = (function (){var statearr_74637 = state_74631;
(statearr_74637[(13)] = inst_74606);

return statearr_74637;
})();
if(cljs.core.truth_(inst_74580)){
var statearr_74638_74672 = state_74631__$1;
(statearr_74638_74672[(1)] = (14));

} else {
var statearr_74639_74673 = state_74631__$1;
(statearr_74639_74673[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74632 === (6))){
var inst_74580 = (state_74631[(15)]);
var inst_74579 = (state_74631[(16)]);
var inst_74589 = fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,txn,inst_74579,opts);
var inst_74590 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_74589);
var inst_74591 = fluree.db.operations.command_async(conn,inst_74589);
var state_74631__$1 = (function (){var statearr_74640 = state_74631;
(statearr_74640[(17)] = inst_74590);

(statearr_74640[(18)] = inst_74591);

return statearr_74640;
})();
if(cljs.core.truth_(inst_74580)){
var statearr_74641_74674 = state_74631__$1;
(statearr_74641_74674[(1)] = (9));

} else {
var statearr_74642_74675 = state_74631__$1;
(statearr_74642_74675[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74632 === (17))){
var inst_74611 = (state_74631[(19)]);
var inst_74611__$1 = (state_74631[(2)]);
var inst_74612 = (inst_74611__$1 instanceof cljs.core.ExceptionInfo);
var state_74631__$1 = (function (){var statearr_74643 = state_74631;
(statearr_74643[(19)] = inst_74611__$1);

return statearr_74643;
})();
if(cljs.core.truth_(inst_74612)){
var statearr_74644_74676 = state_74631__$1;
(statearr_74644_74676[(1)] = (18));

} else {
var statearr_74645_74677 = state_74631__$1;
(statearr_74645_74677[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74632 === (3))){
var inst_74629 = (state_74631[(2)]);
var state_74631__$1 = state_74631;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74631__$1,inst_74629);
} else {
if((state_val_74632 === (12))){
var inst_74596 = (state_74631[(2)]);
var state_74631__$1 = state_74631;
var statearr_74646_74678 = state_74631__$1;
(statearr_74646_74678[(2)] = inst_74596);

(statearr_74646_74678[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74632 === (2))){
var inst_74579 = (state_74631[(16)]);
var _ = (function (){var statearr_74647 = state_74631;
(statearr_74647[(4)] = cljs.core.cons((5),(state_74631[(4)])));

return statearr_74647;
})();
var inst_74577 = opts;
var inst_74578 = cljs.core.__destructure_map(inst_74577);
var inst_74579__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74578,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_74580 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74578,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_74581 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_74578,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_74582 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74578,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_74583 = fluree.db.util.core.current_time_millis();
var inst_74584 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_74578,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_74583);
var inst_74585 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74578,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_74586 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74578,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_74587 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74578,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_74631__$1 = (function (){var statearr_74648 = state_74631;
(statearr_74648[(15)] = inst_74580);

(statearr_74648[(14)] = inst_74581);

(statearr_74648[(7)] = inst_74584);

(statearr_74648[(16)] = inst_74579__$1);

(statearr_74648[(8)] = inst_74582);

(statearr_74648[(9)] = inst_74587);

(statearr_74648[(10)] = inst_74585);

(statearr_74648[(11)] = inst_74586);

return statearr_74648;
})();
if(cljs.core.truth_(inst_74579__$1)){
var statearr_74649_74679 = state_74631__$1;
(statearr_74649_74679[(1)] = (6));

} else {
var statearr_74650_74680 = state_74631__$1;
(statearr_74650_74680[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74632 === (19))){
var inst_74611 = (state_74631[(19)]);
var state_74631__$1 = state_74631;
var statearr_74651_74681 = state_74631__$1;
(statearr_74651_74681[(2)] = inst_74611);

(statearr_74651_74681[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74632 === (11))){
var inst_74598 = (state_74631[(2)]);
var state_74631__$1 = state_74631;
var statearr_74653_74682 = state_74631__$1;
(statearr_74653_74682[(2)] = inst_74598);

(statearr_74653_74682[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74632 === (9))){
var inst_74591 = (state_74631[(18)]);
var state_74631__$1 = state_74631;
var statearr_74654_74683 = state_74631__$1;
(statearr_74654_74683[(2)] = inst_74591);

(statearr_74654_74683[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74632 === (5))){
var _ = (function (){var statearr_74655 = state_74631;
(statearr_74655[(4)] = cljs.core.rest((state_74631[(4)])));

return statearr_74655;
})();
var state_74631__$1 = state_74631;
var ex74652 = (state_74631__$1[(2)]);
var statearr_74656_74684 = state_74631__$1;
(statearr_74656_74684[(5)] = ex74652);


var statearr_74657_74685 = state_74631__$1;
(statearr_74657_74685[(1)] = (4));

(statearr_74657_74685[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74632 === (14))){
var inst_74606 = (state_74631[(13)]);
var state_74631__$1 = state_74631;
var statearr_74658_74686 = state_74631__$1;
(statearr_74658_74686[(2)] = inst_74606);

(statearr_74658_74686[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74632 === (16))){
var inst_74624 = (state_74631[(2)]);
var state_74631__$1 = state_74631;
var statearr_74659_74687 = state_74631__$1;
(statearr_74659_74687[(2)] = inst_74624);

(statearr_74659_74687[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74632 === (10))){
var inst_74581 = (state_74631[(14)]);
var inst_74590 = (state_74631[(17)]);
var inst_74594 = fluree.db.api_js.monitor_tx(conn,ledger,inst_74590,inst_74581);
var state_74631__$1 = state_74631;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74631__$1,(12),inst_74594);
} else {
if((state_val_74632 === (18))){
var inst_74611 = (state_74631[(19)]);
var inst_74614 = cljs.core.ex_data(inst_74611);
var inst_74615 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74616 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_74614);
var inst_74617 = cljs.core.ex_message(inst_74611);
var inst_74618 = [inst_74616,inst_74617,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_74619 = cljs.core.PersistentHashMap.fromArrays(inst_74615,inst_74618);
var state_74631__$1 = state_74631;
var statearr_74660_74688 = state_74631__$1;
(statearr_74660_74688[(2)] = inst_74619);

(statearr_74660_74688[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74632 === (8))){
var inst_74626 = (state_74631[(2)]);
var _ = (function (){var statearr_74661 = state_74631;
(statearr_74661[(4)] = cljs.core.rest((state_74631[(4)])));

return statearr_74661;
})();
var state_74631__$1 = state_74631;
var statearr_74662_74689 = state_74631__$1;
(statearr_74662_74689[(2)] = inst_74626);

(statearr_74662_74689[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__11410__auto__ = null;
var fluree$db$api_js$state_machine__11410__auto____0 = (function (){
var statearr_74663 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74663[(0)] = fluree$db$api_js$state_machine__11410__auto__);

(statearr_74663[(1)] = (1));

return statearr_74663;
});
var fluree$db$api_js$state_machine__11410__auto____1 = (function (state_74631){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_74631);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e74664){var ex__11413__auto__ = e74664;
var statearr_74665_74690 = state_74631;
(statearr_74665_74690[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_74631[(4)]))){
var statearr_74666_74691 = state_74631;
(statearr_74666_74691[(1)] = cljs.core.first((state_74631[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74692 = state_74631;
state_74631 = G__74692;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__11410__auto__ = function(state_74631){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__11410__auto____1.call(this,state_74631);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__11410__auto____0;
fluree$db$api_js$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__11410__auto____1;
return fluree$db$api_js$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_74667 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_74667[(6)] = c__11484__auto__);

return statearr_74667;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__4870__auto__ = [];
var len__4864__auto___74694 = arguments.length;
var i__4865__auto___74695 = (0);
while(true){
if((i__4865__auto___74695 < len__4864__auto___74694)){
args__4870__auto__.push((arguments[i__4865__auto___74695]));

var G__74696 = (i__4865__auto___74695 + (1));
i__4865__auto___74695 = G__74696;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq74693){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq74693));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_74727){
var state_val_74728 = (state_74727[(1)]);
if((state_val_74728 === (1))){
var inst_74697 = cljs.core.first(flakes);
var inst_74698 = cljs.core.rest(flakes);
var inst_74699 = cljs.core.PersistentVector.EMPTY;
var inst_74700 = inst_74697;
var inst_74701 = inst_74698;
var inst_74702 = inst_74699;
var state_74727__$1 = (function (){var statearr_74729 = state_74727;
(statearr_74729[(7)] = inst_74702);

(statearr_74729[(8)] = inst_74700);

(statearr_74729[(9)] = inst_74701);

return statearr_74729;
})();
var statearr_74730_74743 = state_74727__$1;
(statearr_74730_74743[(2)] = null);

(statearr_74730_74743[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74728 === (2))){
var inst_74700 = (state_74727[(8)]);
var inst_74704 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_74705 = cljs.core.PersistentHashMap.EMPTY;
var inst_74706 = [true,inst_74705];
var inst_74707 = cljs.core.PersistentHashMap.fromArrays(inst_74704,inst_74706);
var inst_74708 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_74707,inst_74700);
var state_74727__$1 = state_74727;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74727__$1,(4),inst_74708);
} else {
if((state_val_74728 === (3))){
var inst_74725 = (state_74727[(2)]);
var state_74727__$1 = state_74727;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74727__$1,inst_74725);
} else {
if((state_val_74728 === (4))){
var inst_74702 = (state_74727[(7)]);
var inst_74701 = (state_74727[(9)]);
var inst_74710 = (state_74727[(2)]);
var inst_74711 = fluree.db.util.async.throw_err(inst_74710);
var inst_74712 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74713 = [inst_74711];
var inst_74714 = (new cljs.core.PersistentVector(null,1,(5),inst_74712,inst_74713,null));
var inst_74715 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_74702,inst_74714);
var inst_74716 = cljs.core.first(inst_74701);
var state_74727__$1 = (function (){var statearr_74731 = state_74727;
(statearr_74731[(10)] = inst_74715);

return statearr_74731;
})();
if(cljs.core.truth_(inst_74716)){
var statearr_74732_74744 = state_74727__$1;
(statearr_74732_74744[(1)] = (5));

} else {
var statearr_74733_74745 = state_74727__$1;
(statearr_74733_74745[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74728 === (5))){
var inst_74715 = (state_74727[(10)]);
var inst_74701 = (state_74727[(9)]);
var inst_74718 = cljs.core.first(inst_74701);
var inst_74719 = cljs.core.rest(inst_74701);
var inst_74700 = inst_74718;
var inst_74701__$1 = inst_74719;
var inst_74702 = inst_74715;
var state_74727__$1 = (function (){var statearr_74734 = state_74727;
(statearr_74734[(7)] = inst_74702);

(statearr_74734[(8)] = inst_74700);

(statearr_74734[(9)] = inst_74701__$1);

return statearr_74734;
})();
var statearr_74735_74746 = state_74727__$1;
(statearr_74735_74746[(2)] = null);

(statearr_74735_74746[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74728 === (6))){
var inst_74715 = (state_74727[(10)]);
var state_74727__$1 = state_74727;
var statearr_74736_74747 = state_74727__$1;
(statearr_74736_74747[(2)] = inst_74715);

(statearr_74736_74747[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74728 === (7))){
var inst_74723 = (state_74727[(2)]);
var state_74727__$1 = state_74727;
var statearr_74737_74748 = state_74727__$1;
(statearr_74737_74748[(2)] = inst_74723);

(statearr_74737_74748[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11410__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11410__auto____0 = (function (){
var statearr_74738 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_74738[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11410__auto__);

(statearr_74738[(1)] = (1));

return statearr_74738;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11410__auto____1 = (function (state_74727){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_74727);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e74739){var ex__11413__auto__ = e74739;
var statearr_74740_74749 = state_74727;
(statearr_74740_74749[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_74727[(4)]))){
var statearr_74741_74750 = state_74727;
(statearr_74741_74750[(1)] = cljs.core.first((state_74727[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74751 = state_74727;
state_74727 = G__74751;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11410__auto__ = function(state_74727){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11410__auto____1.call(this,state_74727);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11410__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11410__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_74742 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_74742[(6)] = c__11484__auto__);

return statearr_74742;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_74819){
var state_val_74820 = (state_74819[(1)]);
if((state_val_74820 === (7))){
var inst_74779 = (state_74819[(2)]);
var inst_74780 = fluree.db.util.async.throw_err(inst_74779);
var state_74819__$1 = state_74819;
var statearr_74821_74847 = state_74819__$1;
(statearr_74821_74847[(2)] = inst_74780);

(statearr_74821_74847[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74820 === (1))){
var inst_74756 = cljs.core.volatile_BANG_((0));
var inst_74757 = cljs.core.PersistentHashMap.EMPTY;
var inst_74758 = cljs.core.volatile_BANG_(inst_74757);
var inst_74759 = cljs.core.first(resp);
var inst_74760 = cljs.core.rest(resp);
var inst_74761 = cljs.core.PersistentVector.EMPTY;
var inst_74762 = inst_74756;
var inst_74763 = inst_74758;
var inst_74764 = inst_74759;
var inst_74765 = inst_74760;
var inst_74766 = inst_74761;
var state_74819__$1 = (function (){var statearr_74822 = state_74819;
(statearr_74822[(7)] = inst_74764);

(statearr_74822[(8)] = inst_74762);

(statearr_74822[(9)] = inst_74765);

(statearr_74822[(10)] = inst_74766);

(statearr_74822[(11)] = inst_74763);

return statearr_74822;
})();
var statearr_74823_74848 = state_74819__$1;
(statearr_74823_74848[(2)] = null);

(statearr_74823_74848[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74820 === (4))){
var inst_74764 = (state_74819[(7)]);
var inst_74762 = (state_74819[(8)]);
var inst_74765 = (state_74819[(9)]);
var inst_74766 = (state_74819[(10)]);
var inst_74770 = (state_74819[(12)]);
var inst_74763 = (state_74819[(11)]);
var inst_74768 = (state_74819[(13)]);
var inst_74774 = (function (){var fuel = inst_74762;
var cache = inst_74763;
var curr_block = inst_74764;
var rest_blocks = inst_74765;
var acc = inst_74766;
var flakes = inst_74768;
var asserted = inst_74770;
return (function (p1__74753_SHARP_){
return p1__74753_SHARP_.s;
});
})();
var inst_74775 = cljs.core.group_by(inst_74774,inst_74770);
var inst_74776 = cljs.core.vals(inst_74775);
var inst_74777 = fluree.db.api_js.format_flake_groups_pretty(db,inst_74763,inst_74762,inst_74776);
var state_74819__$1 = state_74819;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74819__$1,(7),inst_74777);
} else {
if((state_val_74820 === (13))){
var inst_74807 = (state_74819[(14)]);
var state_74819__$1 = state_74819;
var statearr_74824_74849 = state_74819__$1;
(statearr_74824_74849[(2)] = inst_74807);

(statearr_74824_74849[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74820 === (6))){
var inst_74764 = (state_74819[(7)]);
var inst_74762 = (state_74819[(8)]);
var inst_74765 = (state_74819[(9)]);
var inst_74766 = (state_74819[(10)]);
var inst_74785 = (state_74819[(15)]);
var inst_74783 = (state_74819[(16)]);
var inst_74770 = (state_74819[(12)]);
var inst_74763 = (state_74819[(11)]);
var inst_74768 = (state_74819[(13)]);
var inst_74783__$1 = (state_74819[(2)]);
var inst_74784 = (function (){var fuel = inst_74762;
var cache = inst_74763;
var curr_block = inst_74764;
var rest_blocks = inst_74765;
var acc = inst_74766;
var flakes = inst_74768;
var asserted = inst_74770;
var asserted_SINGLEQUOTE_ = inst_74783__$1;
return (function (p1__74754_SHARP_){
return p1__74754_SHARP_.op === false;
});
})();
var inst_74785__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_74784,inst_74768);
var inst_74786 = cljs.core.empty_QMARK_(inst_74785__$1);
var inst_74787 = (!(inst_74786));
var state_74819__$1 = (function (){var statearr_74827 = state_74819;
(statearr_74827[(15)] = inst_74785__$1);

(statearr_74827[(16)] = inst_74783__$1);

return statearr_74827;
})();
if(inst_74787){
var statearr_74828_74850 = state_74819__$1;
(statearr_74828_74850[(1)] = (8));

} else {
var statearr_74829_74851 = state_74819__$1;
(statearr_74829_74851[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74820 === (3))){
var inst_74817 = (state_74819[(2)]);
var state_74819__$1 = state_74819;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74819__$1,inst_74817);
} else {
if((state_val_74820 === (12))){
var inst_74807 = (state_74819[(14)]);
var inst_74762 = (state_74819[(8)]);
var inst_74765 = (state_74819[(9)]);
var inst_74763 = (state_74819[(11)]);
var inst_74810 = cljs.core.first(inst_74765);
var inst_74811 = cljs.core.rest(inst_74765);
var tmp74825 = inst_74762;
var tmp74826 = inst_74763;
var inst_74762__$1 = tmp74825;
var inst_74763__$1 = tmp74826;
var inst_74764 = inst_74810;
var inst_74765__$1 = inst_74811;
var inst_74766 = inst_74807;
var state_74819__$1 = (function (){var statearr_74830 = state_74819;
(statearr_74830[(7)] = inst_74764);

(statearr_74830[(8)] = inst_74762__$1);

(statearr_74830[(9)] = inst_74765__$1);

(statearr_74830[(10)] = inst_74766);

(statearr_74830[(11)] = inst_74763__$1);

return statearr_74830;
})();
var statearr_74831_74852 = state_74819__$1;
(statearr_74831_74852[(2)] = null);

(statearr_74831_74852[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74820 === (2))){
var inst_74764 = (state_74819[(7)]);
var inst_74762 = (state_74819[(8)]);
var inst_74765 = (state_74819[(9)]);
var inst_74766 = (state_74819[(10)]);
var inst_74770 = (state_74819[(12)]);
var inst_74763 = (state_74819[(11)]);
var inst_74768 = (state_74819[(13)]);
var inst_74768__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_74764);
var inst_74769 = (function (){var fuel = inst_74762;
var cache = inst_74763;
var curr_block = inst_74764;
var rest_blocks = inst_74765;
var acc = inst_74766;
var flakes = inst_74768__$1;
return (function (p1__74752_SHARP_){
return p1__74752_SHARP_.op;
});
})();
var inst_74770__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_74769,inst_74768__$1);
var inst_74771 = cljs.core.empty_QMARK_(inst_74770__$1);
var inst_74772 = (!(inst_74771));
var state_74819__$1 = (function (){var statearr_74832 = state_74819;
(statearr_74832[(12)] = inst_74770__$1);

(statearr_74832[(13)] = inst_74768__$1);

return statearr_74832;
})();
if(inst_74772){
var statearr_74833_74853 = state_74819__$1;
(statearr_74833_74853[(1)] = (4));

} else {
var statearr_74834_74854 = state_74819__$1;
(statearr_74834_74854[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74820 === (11))){
var inst_74795 = (state_74819[(2)]);
var inst_74796 = fluree.db.util.async.throw_err(inst_74795);
var state_74819__$1 = state_74819;
var statearr_74835_74855 = state_74819__$1;
(statearr_74835_74855[(2)] = inst_74796);

(statearr_74835_74855[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74820 === (9))){
var state_74819__$1 = state_74819;
var statearr_74836_74856 = state_74819__$1;
(statearr_74836_74856[(2)] = null);

(statearr_74836_74856[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74820 === (5))){
var state_74819__$1 = state_74819;
var statearr_74837_74857 = state_74819__$1;
(statearr_74837_74857[(2)] = null);

(statearr_74837_74857[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74820 === (14))){
var inst_74815 = (state_74819[(2)]);
var state_74819__$1 = state_74819;
var statearr_74838_74858 = state_74819__$1;
(statearr_74838_74858[(2)] = inst_74815);

(statearr_74838_74858[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74820 === (10))){
var inst_74764 = (state_74819[(7)]);
var inst_74765 = (state_74819[(9)]);
var inst_74766 = (state_74819[(10)]);
var inst_74783 = (state_74819[(16)]);
var inst_74799 = (state_74819[(2)]);
var inst_74800 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_74801 = [inst_74783,inst_74799];
var inst_74802 = cljs.core.PersistentHashMap.fromArrays(inst_74800,inst_74801);
var inst_74803 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_74764,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_74802);
var inst_74804 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74805 = [inst_74803];
var inst_74806 = (new cljs.core.PersistentVector(null,1,(5),inst_74804,inst_74805,null));
var inst_74807 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_74766,inst_74806);
var inst_74808 = cljs.core.first(inst_74765);
var state_74819__$1 = (function (){var statearr_74839 = state_74819;
(statearr_74839[(14)] = inst_74807);

return statearr_74839;
})();
if(cljs.core.truth_(inst_74808)){
var statearr_74840_74859 = state_74819__$1;
(statearr_74840_74859[(1)] = (12));

} else {
var statearr_74841_74860 = state_74819__$1;
(statearr_74841_74860[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74820 === (8))){
var inst_74764 = (state_74819[(7)]);
var inst_74762 = (state_74819[(8)]);
var inst_74765 = (state_74819[(9)]);
var inst_74766 = (state_74819[(10)]);
var inst_74785 = (state_74819[(15)]);
var inst_74783 = (state_74819[(16)]);
var inst_74770 = (state_74819[(12)]);
var inst_74763 = (state_74819[(11)]);
var inst_74768 = (state_74819[(13)]);
var inst_74789 = (function (){var flakes = inst_74768;
var rest_blocks = inst_74765;
var curr_block = inst_74764;
var asserted_SINGLEQUOTE_ = inst_74783;
var acc = inst_74766;
var fuel = inst_74762;
var cache = inst_74763;
var retracted = inst_74785;
var asserted = inst_74770;
return (function (p1__74755_SHARP_){
return p1__74755_SHARP_.s;
});
})();
var inst_74790 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.flip_flake,inst_74785);
var inst_74791 = cljs.core.group_by(inst_74789,inst_74790);
var inst_74792 = cljs.core.vals(inst_74791);
var inst_74793 = fluree.db.api_js.format_flake_groups_pretty(db,inst_74763,inst_74762,inst_74792);
var state_74819__$1 = state_74819;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74819__$1,(11),inst_74793);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__11410__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__11410__auto____0 = (function (){
var statearr_74842 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74842[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__11410__auto__);

(statearr_74842[(1)] = (1));

return statearr_74842;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__11410__auto____1 = (function (state_74819){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_74819);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e74843){var ex__11413__auto__ = e74843;
var statearr_74844_74861 = state_74819;
(statearr_74844_74861[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_74819[(4)]))){
var statearr_74845_74862 = state_74819;
(statearr_74845_74862[(1)] = cljs.core.first((state_74819[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74863 = state_74819;
state_74819 = G__74863;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__11410__auto__ = function(state_74819){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__11410__auto____1.call(this,state_74819);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__11410__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__11410__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_74846 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_74846[(6)] = c__11484__auto__);

return statearr_74846;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_74963){
var state_val_74964 = (state_74963[(1)]);
if((state_val_74964 === (7))){
var inst_74935 = (state_74963[(7)]);
var inst_74928 = (state_74963[(8)]);
var inst_74934 = cljs.core.seq(inst_74928);
var inst_74935__$1 = cljs.core.first(inst_74934);
var inst_74936 = cljs.core.next(inst_74934);
var state_74963__$1 = (function (){var statearr_74965 = state_74963;
(statearr_74965[(7)] = inst_74935__$1);

(statearr_74965[(9)] = inst_74936);

return statearr_74965;
})();
if(cljs.core.truth_(inst_74935__$1)){
var statearr_74966_75003 = state_74963__$1;
(statearr_74966_75003[(1)] = (9));

} else {
var statearr_74967_75004 = state_74963__$1;
(statearr_74967_75004[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74964 === (1))){
var state_74963__$1 = state_74963;
var statearr_74968_75005 = state_74963__$1;
(statearr_74968_75005[(2)] = null);

(statearr_74968_75005[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74964 === (4))){
var inst_74865 = (state_74963[(2)]);
var state_74963__$1 = state_74963;
var statearr_74969_75006 = state_74963__$1;
(statearr_74969_75006[(2)] = inst_74865);

(statearr_74969_75006[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74964 === (6))){
var inst_74914 = (state_74963[(2)]);
var inst_74915 = fluree.db.util.async.throw_err(inst_74914);
var inst_74923 = resp;
var inst_74924 = cljs.core.seq(inst_74923);
var inst_74925 = cljs.core.first(inst_74924);
var inst_74926 = cljs.core.next(inst_74924);
var inst_74927 = cljs.core.PersistentHashMap.EMPTY;
var inst_74928 = inst_74923;
var inst_74929 = inst_74927;
var state_74963__$1 = (function (){var statearr_74970 = state_74963;
(statearr_74970[(10)] = inst_74926);

(statearr_74970[(8)] = inst_74928);

(statearr_74970[(11)] = inst_74929);

(statearr_74970[(12)] = inst_74925);

(statearr_74970[(13)] = inst_74915);

return statearr_74970;
})();
var statearr_74971_75007 = state_74963__$1;
(statearr_74971_75007[(2)] = null);

(statearr_74971_75007[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74964 === (3))){
var inst_74961 = (state_74963[(2)]);
var state_74963__$1 = state_74963;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74963__$1,inst_74961);
} else {
if((state_val_74964 === (2))){
var _ = (function (){var statearr_74972 = state_74963;
(statearr_74972[(4)] = cljs.core.cons((5),(state_74963[(4)])));

return statearr_74972;
})();
var inst_74871 = (function (){return (function (p1__74864_SHARP_){
return p1__74864_SHARP_.t;
});
})();
var inst_74872 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_74871,resp);
var inst_74873 = cljs.core.set(inst_74872);
var inst_74910 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_74911 = (function (){var ts = inst_74873;
var c__11484__auto____$1 = inst_74910;
return (function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_74908){
var state_val_74909 = (state_74908[(1)]);
if((state_val_74909 === (1))){
var inst_74881 = ts;
var inst_74882 = cljs.core.seq(inst_74881);
var inst_74883 = cljs.core.first(inst_74882);
var inst_74884 = cljs.core.next(inst_74882);
var inst_74885 = cljs.core.PersistentHashMap.EMPTY;
var inst_74886 = inst_74881;
var inst_74887 = inst_74885;
var state_74908__$1 = (function (){var statearr_74973 = state_74908;
(statearr_74973[(7)] = inst_74883);

(statearr_74973[(8)] = inst_74887);

(statearr_74973[(9)] = inst_74884);

(statearr_74973[(10)] = inst_74886);

return statearr_74973;
})();
var statearr_74974_75008 = state_74908__$1;
(statearr_74974_75008[(2)] = null);

(statearr_74974_75008[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74909 === (2))){
var inst_74886 = (state_74908[(10)]);
var inst_74893 = (state_74908[(11)]);
var inst_74892 = cljs.core.seq(inst_74886);
var inst_74893__$1 = cljs.core.first(inst_74892);
var inst_74894 = cljs.core.next(inst_74892);
var state_74908__$1 = (function (){var statearr_74975 = state_74908;
(statearr_74975[(12)] = inst_74894);

(statearr_74975[(11)] = inst_74893__$1);

return statearr_74975;
})();
if(cljs.core.truth_(inst_74893__$1)){
var statearr_74976_75009 = state_74908__$1;
(statearr_74976_75009[(1)] = (4));

} else {
var statearr_74977_75010 = state_74908__$1;
(statearr_74977_75010[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74909 === (3))){
var inst_74906 = (state_74908[(2)]);
var state_74908__$1 = state_74908;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74908__$1,inst_74906);
} else {
if((state_val_74909 === (4))){
var inst_74893 = (state_74908[(11)]);
var inst_74896 = fluree.db.time_travel.non_border_t_to_block(db,inst_74893);
var state_74908__$1 = state_74908;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74908__$1,(7),inst_74896);
} else {
if((state_val_74909 === (5))){
var inst_74887 = (state_74908[(8)]);
var state_74908__$1 = state_74908;
var statearr_74978_75011 = state_74908__$1;
(statearr_74978_75011[(2)] = inst_74887);

(statearr_74978_75011[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74909 === (6))){
var inst_74904 = (state_74908[(2)]);
var state_74908__$1 = state_74908;
var statearr_74979_75012 = state_74908__$1;
(statearr_74979_75012[(2)] = inst_74904);

(statearr_74979_75012[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74909 === (7))){
var inst_74894 = (state_74908[(12)]);
var inst_74887 = (state_74908[(8)]);
var inst_74893 = (state_74908[(11)]);
var inst_74898 = (state_74908[(2)]);
var inst_74899 = fluree.db.util.async.throw_err(inst_74898);
var inst_74900 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_74887,inst_74893,inst_74899);
var inst_74886 = inst_74894;
var inst_74887__$1 = inst_74900;
var state_74908__$1 = (function (){var statearr_74980 = state_74908;
(statearr_74980[(8)] = inst_74887__$1);

(statearr_74980[(10)] = inst_74886);

return statearr_74980;
})();
var statearr_74981_75013 = state_74908__$1;
(statearr_74981_75013[(2)] = null);

(statearr_74981_75013[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__11410__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__11410__auto____0 = (function (){
var statearr_74982 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74982[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__11410__auto__);

(statearr_74982[(1)] = (1));

return statearr_74982;
});
var fluree$db$api_js$format_history_resp_$_state_machine__11410__auto____1 = (function (state_74908){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_74908);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e74983){var ex__11413__auto__ = e74983;
var statearr_74984_75014 = state_74908;
(statearr_74984_75014[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_74908[(4)]))){
var statearr_74985_75015 = state_74908;
(statearr_74985_75015[(1)] = cljs.core.first((state_74908[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75016 = state_74908;
state_74908 = G__75016;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__11410__auto__ = function(state_74908){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__11410__auto____1.call(this,state_74908);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__11410__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__11410__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_74986 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_74986[(6)] = c__11484__auto____$1);

return statearr_74986;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
});
})();
var inst_74912 = cljs.core.async.impl.dispatch.run(inst_74911);
var state_74963__$1 = (function (){var statearr_74987 = state_74963;
(statearr_74987[(14)] = inst_74912);

return statearr_74987;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74963__$1,(6),inst_74910);
} else {
if((state_val_74964 === (11))){
var inst_74955 = (state_74963[(2)]);
var state_74963__$1 = state_74963;
var statearr_74989_75017 = state_74963__$1;
(statearr_74989_75017[(2)] = inst_74955);

(statearr_74989_75017[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74964 === (9))){
var inst_74935 = (state_74963[(7)]);
var inst_74929 = (state_74963[(11)]);
var inst_74936 = (state_74963[(9)]);
var inst_74915 = (state_74963[(13)]);
var inst_74938 = inst_74935.t;
var inst_74939 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74915,inst_74938);
var inst_74940 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74941 = [inst_74939,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_74942 = (new cljs.core.PersistentVector(null,2,(5),inst_74940,inst_74941,null));
var inst_74943 = cljs.core.assoc_in(inst_74929,inst_74942,inst_74939);
var inst_74944 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74945 = [inst_74939,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_74946 = (new cljs.core.PersistentVector(null,2,(5),inst_74944,inst_74945,null));
var inst_74947 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_74943,inst_74946,cljs.core.conj,inst_74935);
var inst_74948 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74949 = [inst_74939,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_74950 = (new cljs.core.PersistentVector(null,2,(5),inst_74948,inst_74949,null));
var inst_74951 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_74947,inst_74950,fluree.db.api_js.min_safe,inst_74938);
var inst_74928 = inst_74936;
var inst_74929__$1 = inst_74951;
var state_74963__$1 = (function (){var statearr_74990 = state_74963;
(statearr_74990[(8)] = inst_74928);

(statearr_74990[(11)] = inst_74929__$1);

return statearr_74990;
})();
var statearr_74991_75018 = state_74963__$1;
(statearr_74991_75018[(2)] = null);

(statearr_74991_75018[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74964 === (5))){
var _ = (function (){var statearr_74992 = state_74963;
(statearr_74992[(4)] = cljs.core.rest((state_74963[(4)])));

return statearr_74992;
})();
var state_74963__$1 = state_74963;
var ex74988 = (state_74963__$1[(2)]);
var statearr_74993_75019 = state_74963__$1;
(statearr_74993_75019[(5)] = ex74988);


if((ex74988 instanceof Error)){
var statearr_74994_75020 = state_74963__$1;
(statearr_74994_75020[(1)] = (4));

(statearr_74994_75020[(5)] = null);

} else {
throw ex74988;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74964 === (10))){
var inst_74929 = (state_74963[(11)]);
var state_74963__$1 = state_74963;
var statearr_74995_75021 = state_74963__$1;
(statearr_74995_75021[(2)] = inst_74929);

(statearr_74995_75021[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74964 === (8))){
var inst_74957 = (state_74963[(2)]);
var inst_74958 = cljs.core.vals(inst_74957);
var _ = (function (){var statearr_74996 = state_74963;
(statearr_74996[(4)] = cljs.core.rest((state_74963[(4)])));

return statearr_74996;
})();
var state_74963__$1 = state_74963;
var statearr_74997_75022 = state_74963__$1;
(statearr_74997_75022[(2)] = inst_74958);

(statearr_74997_75022[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__11410__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__11410__auto____0 = (function (){
var statearr_74998 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74998[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__11410__auto__);

(statearr_74998[(1)] = (1));

return statearr_74998;
});
var fluree$db$api_js$format_history_resp_$_state_machine__11410__auto____1 = (function (state_74963){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_74963);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e74999){var ex__11413__auto__ = e74999;
var statearr_75000_75023 = state_74963;
(statearr_75000_75023[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_74963[(4)]))){
var statearr_75001_75024 = state_74963;
(statearr_75001_75024[(1)] = cljs.core.first((state_74963[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75025 = state_74963;
state_74963 = G__75025;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__11410__auto__ = function(state_74963){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__11410__auto____1.call(this,state_74963);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__11410__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__11410__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_75002 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_75002[(6)] = c__11484__auto__);

return statearr_75002;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_75170){
var state_val_75171 = (state_75170[(1)]);
if((state_val_75171 === (7))){
var inst_75050 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75051 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_75052 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_75053 = [inst_75051,inst_75052];
var inst_75054 = (new cljs.core.PersistentVector(null,2,(5),inst_75050,inst_75053,null));
var state_75170__$1 = state_75170;
var statearr_75172_75243 = state_75170__$1;
(statearr_75172_75243[(2)] = inst_75054);

(statearr_75172_75243[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (20))){
var inst_75080 = (state_75170[(7)]);
var state_75170__$1 = state_75170;
var statearr_75173_75244 = state_75170__$1;
(statearr_75173_75244[(2)] = inst_75080);

(statearr_75173_75244[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (27))){
var state_75170__$1 = state_75170;
var statearr_75174_75245 = state_75170__$1;
(statearr_75174_75245[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (1))){
var state_75170__$1 = state_75170;
var statearr_75176_75246 = state_75170__$1;
(statearr_75176_75246[(2)] = null);

(statearr_75176_75246[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (24))){
var inst_75079 = (state_75170[(8)]);
var state_75170__$1 = state_75170;
if(cljs.core.truth_(inst_75079)){
var statearr_75177_75247 = state_75170__$1;
(statearr_75177_75247[(1)] = (26));

} else {
var statearr_75178_75248 = state_75170__$1;
(statearr_75178_75248[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (39))){
var inst_75126 = (state_75170[(9)]);
var inst_75125 = (state_75170[(10)]);
var inst_75151 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75152 = [inst_75125,inst_75126];
var inst_75153 = (new cljs.core.PersistentVector(null,2,(5),inst_75151,inst_75152,null));
var state_75170__$1 = state_75170;
var statearr_75179_75249 = state_75170__$1;
(statearr_75179_75249[(2)] = inst_75153);

(statearr_75179_75249[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (4))){
var inst_75026 = (state_75170[(2)]);
var inst_75027 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_75026], 0));
var inst_75028 = cljs.core.ex_data(inst_75026);
var inst_75029 = cljs.core.ex_message(inst_75026);
var inst_75030 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_75028,new cljs.core.Keyword(null,"message","message",-406056002),inst_75029);
var state_75170__$1 = (function (){var statearr_75180 = state_75170;
(statearr_75180[(11)] = inst_75027);

return statearr_75180;
})();
var statearr_75181_75250 = state_75170__$1;
(statearr_75181_75250[(2)] = inst_75030);

(statearr_75181_75250[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (15))){
var inst_75064 = (state_75170[(12)]);
var inst_75059 = (state_75170[(13)]);
var inst_75073 = (state_75170[(2)]);
var inst_75074 = [inst_75064,inst_75073];
var inst_75075 = (new cljs.core.PersistentVector(null,2,(5),inst_75059,inst_75074,null));
var state_75170__$1 = state_75170;
var statearr_75182_75251 = state_75170__$1;
(statearr_75182_75251[(2)] = inst_75075);

(statearr_75182_75251[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (21))){
var inst_75079 = (state_75170[(8)]);
var state_75170__$1 = state_75170;
var statearr_75183_75252 = state_75170__$1;
(statearr_75183_75252[(2)] = inst_75079);

(statearr_75183_75252[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (31))){
var inst_75120 = (state_75170[(2)]);
var state_75170__$1 = state_75170;
var statearr_75184_75253 = state_75170__$1;
(statearr_75184_75253[(2)] = inst_75120);

(statearr_75184_75253[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (32))){
var inst_75126 = (state_75170[(9)]);
var inst_75129 = cljs.core.pos_int_QMARK_(inst_75126);
var state_75170__$1 = state_75170;
var statearr_75185_75254 = state_75170__$1;
(statearr_75185_75254[(2)] = inst_75129);

(statearr_75185_75254[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (40))){
var inst_75157 = (state_75170[(14)]);
var inst_75081 = (state_75170[(15)]);
var inst_75155 = (state_75170[(2)]);
var inst_75156 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75155,(0),null);
var inst_75157__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75155,(1),null);
var inst_75158 = (inst_75157__$1 > inst_75081);
var state_75170__$1 = (function (){var statearr_75186 = state_75170;
(statearr_75186[(16)] = inst_75156);

(statearr_75186[(14)] = inst_75157__$1);

return statearr_75186;
})();
if(cljs.core.truth_(inst_75158)){
var statearr_75187_75255 = state_75170__$1;
(statearr_75187_75255[(1)] = (41));

} else {
var statearr_75188_75256 = state_75170__$1;
(statearr_75188_75256[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (33))){
var inst_75127 = (state_75170[(17)]);
var state_75170__$1 = state_75170;
var statearr_75189_75257 = state_75170__$1;
(statearr_75189_75257[(2)] = inst_75127);

(statearr_75189_75257[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (13))){
var inst_75065 = (state_75170[(18)]);
var inst_75067 = fluree.db.time_travel.block_to_int_format(db,inst_75065);
var state_75170__$1 = state_75170;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75170__$1,(16),inst_75067);
} else {
if((state_val_75171 === (22))){
var inst_75098 = (state_75170[(2)]);
var state_75170__$1 = state_75170;
if(cljs.core.truth_(inst_75098)){
var statearr_75190_75258 = state_75170__$1;
(statearr_75190_75258[(1)] = (23));

} else {
var statearr_75191_75259 = state_75170__$1;
(statearr_75191_75259[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (36))){
var state_75170__$1 = state_75170;
var statearr_75192_75260 = state_75170__$1;
(statearr_75192_75260[(2)] = null);

(statearr_75192_75260[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (41))){
var inst_75081 = (state_75170[(15)]);
var state_75170__$1 = state_75170;
var statearr_75193_75261 = state_75170__$1;
(statearr_75193_75261[(2)] = inst_75081);

(statearr_75193_75261[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (43))){
var inst_75156 = (state_75170[(16)]);
var inst_75162 = (state_75170[(2)]);
var inst_75163 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75164 = [inst_75156,inst_75162];
var inst_75165 = (new cljs.core.PersistentVector(null,2,(5),inst_75163,inst_75164,null));
var _ = (function (){var statearr_75194 = state_75170;
(statearr_75194[(4)] = cljs.core.rest((state_75170[(4)])));

return statearr_75194;
})();
var state_75170__$1 = state_75170;
var statearr_75195_75262 = state_75170__$1;
(statearr_75195_75262[(2)] = inst_75165);

(statearr_75195_75262[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (29))){
var inst_75056 = (state_75170[(19)]);
var inst_75111 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_75056], 0));
var inst_75112 = ["Invalid block range provided: ",inst_75111].join('');
var inst_75113 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75114 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_75115 = cljs.core.PersistentHashMap.fromArrays(inst_75113,inst_75114);
var inst_75116 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75112,inst_75115);
var inst_75117 = (function(){throw inst_75116})();
var state_75170__$1 = state_75170;
var statearr_75196_75263 = state_75170__$1;
(statearr_75196_75263[(2)] = inst_75117);

(statearr_75196_75263[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (6))){
var inst_75048 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_75170__$1 = state_75170;
var statearr_75197_75264 = state_75170__$1;
(statearr_75197_75264[(2)] = inst_75048);

(statearr_75197_75264[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (28))){
var inst_75122 = (state_75170[(2)]);
var state_75170__$1 = state_75170;
var statearr_75198_75265 = state_75170__$1;
(statearr_75198_75265[(2)] = inst_75122);

(statearr_75198_75265[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (25))){
var inst_75125 = (state_75170[(10)]);
var inst_75127 = (state_75170[(17)]);
var inst_75124 = (state_75170[(2)]);
var inst_75125__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75124,(0),null);
var inst_75126 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75124,(1),null);
var inst_75127__$1 = cljs.core.pos_int_QMARK_(inst_75125__$1);
var state_75170__$1 = (function (){var statearr_75199 = state_75170;
(statearr_75199[(9)] = inst_75126);

(statearr_75199[(10)] = inst_75125__$1);

(statearr_75199[(17)] = inst_75127__$1);

return statearr_75199;
})();
if(inst_75127__$1){
var statearr_75200_75266 = state_75170__$1;
(statearr_75200_75266[(1)] = (32));

} else {
var statearr_75201_75267 = state_75170__$1;
(statearr_75201_75267[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (34))){
var inst_75132 = (state_75170[(2)]);
var inst_75133 = cljs.core.not(inst_75132);
var state_75170__$1 = state_75170;
if(inst_75133){
var statearr_75202_75268 = state_75170__$1;
(statearr_75202_75268[(1)] = (35));

} else {
var statearr_75203_75269 = state_75170__$1;
(statearr_75203_75269[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (17))){
var inst_75079 = (state_75170[(8)]);
var inst_75081 = (state_75170[(15)]);
var inst_75084 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_75079], 0));
var inst_75085 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_75081], 0));
var inst_75086 = ["Start block is out of range for this ledger. Start block provided: ",inst_75084,". Database block: ",inst_75085].join('');
var inst_75087 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75088 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_75089 = cljs.core.PersistentHashMap.fromArrays(inst_75087,inst_75088);
var inst_75090 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75086,inst_75089);
var inst_75091 = (function(){throw inst_75090})();
var state_75170__$1 = state_75170;
var statearr_75204_75270 = state_75170__$1;
(statearr_75204_75270[(2)] = inst_75091);

(statearr_75204_75270[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (3))){
var inst_75168 = (state_75170[(2)]);
var state_75170__$1 = state_75170;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75170__$1,inst_75168);
} else {
if((state_val_75171 === (12))){
var inst_75065 = (state_75170[(18)]);
var inst_75056 = (state_75170[(19)]);
var inst_75063 = (state_75170[(2)]);
var inst_75064 = fluree.db.util.async.throw_err(inst_75063);
var inst_75065__$1 = cljs.core.second(inst_75056);
var state_75170__$1 = (function (){var statearr_75205 = state_75170;
(statearr_75205[(18)] = inst_75065__$1);

(statearr_75205[(12)] = inst_75064);

return statearr_75205;
})();
if(cljs.core.truth_(inst_75065__$1)){
var statearr_75206_75271 = state_75170__$1;
(statearr_75206_75271[(1)] = (13));

} else {
var statearr_75207_75272 = state_75170__$1;
(statearr_75207_75272[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (2))){
var _ = (function (){var statearr_75208 = state_75170;
(statearr_75208[(4)] = cljs.core.cons((5),(state_75170[(4)])));

return statearr_75208;
})();
var inst_75045 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_75046 = cljs.core.sequential_QMARK_(inst_75045);
var state_75170__$1 = state_75170;
if(inst_75046){
var statearr_75209_75273 = state_75170__$1;
(statearr_75209_75273[(1)] = (6));

} else {
var statearr_75210_75274 = state_75170__$1;
(statearr_75210_75274[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (23))){
var inst_75079 = (state_75170[(8)]);
var inst_75080 = (state_75170[(7)]);
var inst_75100 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75101 = [inst_75079,inst_75080];
var inst_75102 = (new cljs.core.PersistentVector(null,2,(5),inst_75100,inst_75101,null));
var state_75170__$1 = state_75170;
var statearr_75211_75275 = state_75170__$1;
(statearr_75211_75275[(2)] = inst_75102);

(statearr_75211_75275[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (35))){
var inst_75056 = (state_75170[(19)]);
var inst_75135 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_75056], 0));
var inst_75136 = ["Invalid block range provided: ",inst_75135].join('');
var inst_75137 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75138 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_75139 = cljs.core.PersistentHashMap.fromArrays(inst_75137,inst_75138);
var inst_75140 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75136,inst_75139);
var inst_75141 = (function(){throw inst_75140})();
var state_75170__$1 = state_75170;
var statearr_75212_75276 = state_75170__$1;
(statearr_75212_75276[(2)] = inst_75141);

(statearr_75212_75276[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (19))){
var inst_75079 = (state_75170[(8)]);
var inst_75094 = (state_75170[(2)]);
var state_75170__$1 = (function (){var statearr_75213 = state_75170;
(statearr_75213[(20)] = inst_75094);

return statearr_75213;
})();
if(cljs.core.truth_(inst_75079)){
var statearr_75214_75277 = state_75170__$1;
(statearr_75214_75277[(1)] = (20));

} else {
var statearr_75215_75278 = state_75170__$1;
(statearr_75215_75278[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (11))){
var inst_75079 = (state_75170[(8)]);
var inst_75081 = (state_75170[(15)]);
var inst_75078 = (state_75170[(2)]);
var inst_75079__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75078,(0),null);
var inst_75080 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75078,(1),null);
var inst_75081__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_75082 = (inst_75079__$1 > inst_75081__$1);
var state_75170__$1 = (function (){var statearr_75217 = state_75170;
(statearr_75217[(8)] = inst_75079__$1);

(statearr_75217[(7)] = inst_75080);

(statearr_75217[(15)] = inst_75081__$1);

return statearr_75217;
})();
if(cljs.core.truth_(inst_75082)){
var statearr_75218_75279 = state_75170__$1;
(statearr_75218_75279[(1)] = (17));

} else {
var statearr_75219_75280 = state_75170__$1;
(statearr_75219_75280[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (9))){
var inst_75056 = (state_75170[(19)]);
var inst_75059 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75060 = cljs.core.first(inst_75056);
var inst_75061 = fluree.db.time_travel.block_to_int_format(db,inst_75060);
var state_75170__$1 = (function (){var statearr_75220 = state_75170;
(statearr_75220[(13)] = inst_75059);

return statearr_75220;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75170__$1,(12),inst_75061);
} else {
if((state_val_75171 === (5))){
var _ = (function (){var statearr_75221 = state_75170;
(statearr_75221[(4)] = cljs.core.rest((state_75170[(4)])));

return statearr_75221;
})();
var state_75170__$1 = state_75170;
var ex75216 = (state_75170__$1[(2)]);
var statearr_75222_75281 = state_75170__$1;
(statearr_75222_75281[(5)] = ex75216);


var statearr_75223_75282 = state_75170__$1;
(statearr_75223_75282[(1)] = (4));

(statearr_75223_75282[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (14))){
var state_75170__$1 = state_75170;
var statearr_75224_75283 = state_75170__$1;
(statearr_75224_75283[(2)] = null);

(statearr_75224_75283[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (26))){
var inst_75079 = (state_75170[(8)]);
var inst_75105 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75106 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_75107 = [inst_75079,inst_75106];
var inst_75108 = (new cljs.core.PersistentVector(null,2,(5),inst_75105,inst_75107,null));
var state_75170__$1 = state_75170;
var statearr_75225_75284 = state_75170__$1;
(statearr_75225_75284[(2)] = inst_75108);

(statearr_75225_75284[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (16))){
var inst_75069 = (state_75170[(2)]);
var inst_75070 = fluree.db.util.async.throw_err(inst_75069);
var state_75170__$1 = state_75170;
var statearr_75226_75285 = state_75170__$1;
(statearr_75226_75285[(2)] = inst_75070);

(statearr_75226_75285[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (38))){
var inst_75126 = (state_75170[(9)]);
var inst_75125 = (state_75170[(10)]);
var inst_75147 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75148 = [inst_75126,inst_75125];
var inst_75149 = (new cljs.core.PersistentVector(null,2,(5),inst_75147,inst_75148,null));
var state_75170__$1 = state_75170;
var statearr_75227_75286 = state_75170__$1;
(statearr_75227_75286[(2)] = inst_75149);

(statearr_75227_75286[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (30))){
var state_75170__$1 = state_75170;
var statearr_75228_75287 = state_75170__$1;
(statearr_75228_75287[(2)] = null);

(statearr_75228_75287[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (10))){
var inst_75056 = (state_75170[(19)]);
var state_75170__$1 = state_75170;
var statearr_75229_75288 = state_75170__$1;
(statearr_75229_75288[(2)] = inst_75056);

(statearr_75229_75288[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (18))){
var state_75170__$1 = state_75170;
var statearr_75230_75289 = state_75170__$1;
(statearr_75230_75289[(2)] = null);

(statearr_75230_75289[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (42))){
var inst_75157 = (state_75170[(14)]);
var state_75170__$1 = state_75170;
var statearr_75231_75290 = state_75170__$1;
(statearr_75231_75290[(2)] = inst_75157);

(statearr_75231_75290[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (37))){
var inst_75126 = (state_75170[(9)]);
var inst_75125 = (state_75170[(10)]);
var inst_75144 = (state_75170[(2)]);
var inst_75145 = (inst_75126 < inst_75125);
var state_75170__$1 = (function (){var statearr_75232 = state_75170;
(statearr_75232[(21)] = inst_75144);

return statearr_75232;
})();
if(cljs.core.truth_(inst_75145)){
var statearr_75233_75291 = state_75170__$1;
(statearr_75233_75291[(1)] = (38));

} else {
var statearr_75234_75292 = state_75170__$1;
(statearr_75234_75292[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75171 === (8))){
var inst_75056 = (state_75170[(19)]);
var inst_75056__$1 = (state_75170[(2)]);
var inst_75057 = cljs.core.some(cljs.core.string_QMARK_,inst_75056__$1);
var state_75170__$1 = (function (){var statearr_75235 = state_75170;
(statearr_75235[(19)] = inst_75056__$1);

return statearr_75235;
})();
if(cljs.core.truth_(inst_75057)){
var statearr_75236_75293 = state_75170__$1;
(statearr_75236_75293[(1)] = (9));

} else {
var statearr_75237_75294 = state_75170__$1;
(statearr_75237_75294[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__11410__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__11410__auto____0 = (function (){
var statearr_75238 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75238[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__11410__auto__);

(statearr_75238[(1)] = (1));

return statearr_75238;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__11410__auto____1 = (function (state_75170){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_75170);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e75239){var ex__11413__auto__ = e75239;
var statearr_75240_75295 = state_75170;
(statearr_75240_75295[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_75170[(4)]))){
var statearr_75241_75296 = state_75170;
(statearr_75241_75296[(1)] = cljs.core.first((state_75170[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75297 = state_75170;
state_75170 = G__75297;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__11410__auto__ = function(state_75170){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__11410__auto____1.call(this,state_75170);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__11410__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__11410__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_75242 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_75242[(6)] = c__11484__auto__);

return statearr_75242;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__75299 = arguments.length;
switch (G__75299) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3(db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_75390){
var state_val_75391 = (state_75390[(1)]);
if((state_val_75391 === (7))){
var inst_75322 = (state_75390[(7)]);
var inst_75325 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_75322);
var state_75390__$1 = state_75390;
var statearr_75392_75443 = state_75390__$1;
(statearr_75392_75443[(2)] = inst_75325);

(statearr_75392_75443[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75391 === (20))){
var inst_75361 = (state_75390[(8)]);
var inst_75364 = fluree.db.api_js.format_block_resp_pretty(db,inst_75361);
var state_75390__$1 = state_75390;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75390__$1,(23),inst_75364);
} else {
if((state_val_75391 === (27))){
var inst_75370 = (state_75390[(9)]);
var inst_75376 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_75370);
var state_75390__$1 = state_75390;
var statearr_75393_75444 = state_75390__$1;
(statearr_75393_75444[(2)] = inst_75376);

(statearr_75393_75444[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75391 === (1))){
var state_75390__$1 = state_75390;
var statearr_75394_75445 = state_75390__$1;
(statearr_75394_75445[(2)] = null);

(statearr_75394_75445[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75391 === (24))){
var inst_75370 = (state_75390[(9)]);
var inst_75373 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_75374 = cljs.core.sequential_QMARK_(inst_75370);
var state_75390__$1 = (function (){var statearr_75395 = state_75390;
(statearr_75395[(10)] = inst_75373);

return statearr_75395;
})();
if(inst_75374){
var statearr_75396_75446 = state_75390__$1;
(statearr_75396_75446[(1)] = (27));

} else {
var statearr_75397_75447 = state_75390__$1;
(statearr_75397_75447[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75391 === (4))){
var inst_75300 = (state_75390[(2)]);
var inst_75301 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_75300], 0));
var inst_75302 = cljs.core.ex_data(inst_75300);
var inst_75303 = cljs.core.ex_message(inst_75300);
var inst_75304 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_75302,new cljs.core.Keyword(null,"message","message",-406056002),inst_75303);
var state_75390__$1 = (function (){var statearr_75398 = state_75390;
(statearr_75398[(11)] = inst_75301);

return statearr_75398;
})();
var statearr_75399_75448 = state_75390__$1;
(statearr_75399_75448[(2)] = inst_75304);

(statearr_75399_75448[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75391 === (15))){
var inst_75322 = (state_75390[(7)]);
var inst_75335 = (state_75390[(2)]);
var inst_75336 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75335,inst_75322);
var inst_75337 = (function(){throw inst_75336})();
var state_75390__$1 = state_75390;
var statearr_75400_75449 = state_75390__$1;
(statearr_75400_75449[(2)] = inst_75337);

(statearr_75400_75449[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75391 === (21))){
var inst_75361 = (state_75390[(8)]);
var state_75390__$1 = state_75390;
var statearr_75401_75450 = state_75390__$1;
(statearr_75401_75450[(2)] = inst_75361);

(statearr_75401_75450[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75391 === (13))){
var inst_75330 = (state_75390[(12)]);
var state_75390__$1 = state_75390;
var statearr_75402_75451 = state_75390__$1;
(statearr_75402_75451[(2)] = inst_75330);

(statearr_75402_75451[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75391 === (22))){
var inst_75370 = (state_75390[(2)]);
var inst_75371 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_75390__$1 = (function (){var statearr_75403 = state_75390;
(statearr_75403[(9)] = inst_75370);

return statearr_75403;
})();
if(cljs.core.truth_(inst_75371)){
var statearr_75404_75452 = state_75390__$1;
(statearr_75404_75452[(1)] = (24));

} else {
var statearr_75405_75453 = state_75390__$1;
(statearr_75405_75453[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75391 === (29))){
var inst_75314 = (state_75390[(13)]);
var inst_75373 = (state_75390[(10)]);
var inst_75379 = (state_75390[(2)]);
var inst_75380 = fluree.db.util.core.response_time_formatted(inst_75314);
var inst_75381 = [(200),inst_75379,(100),inst_75380];
var inst_75382 = cljs.core.PersistentHashMap.fromArrays(inst_75373,inst_75381);
var state_75390__$1 = state_75390;
var statearr_75406_75454 = state_75390__$1;
(statearr_75406_75454[(2)] = inst_75382);

(statearr_75406_75454[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75391 === (6))){
var inst_75322 = (state_75390[(7)]);
var inst_75323 = (state_75390[(14)]);
var inst_75321 = (state_75390[(2)]);
var inst_75322__$1 = fluree.db.util.async.throw_err(inst_75321);
var inst_75323__$1 = cljs.core.map_QMARK_(inst_75322__$1);
var state_75390__$1 = (function (){var statearr_75407 = state_75390;
(statearr_75407[(7)] = inst_75322__$1);

(statearr_75407[(14)] = inst_75323__$1);

return statearr_75407;
})();
if(inst_75323__$1){
var statearr_75408_75455 = state_75390__$1;
(statearr_75408_75455[(1)] = (7));

} else {
var statearr_75409_75456 = state_75390__$1;
(statearr_75409_75456[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75391 === (28))){
var inst_75370 = (state_75390[(9)]);
var state_75390__$1 = state_75390;
var statearr_75410_75457 = state_75390__$1;
(statearr_75410_75457[(2)] = inst_75370);

(statearr_75410_75457[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75391 === (25))){
var inst_75370 = (state_75390[(9)]);
var state_75390__$1 = state_75390;
var statearr_75411_75458 = state_75390__$1;
(statearr_75411_75458[(2)] = inst_75370);

(statearr_75411_75458[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75391 === (17))){
var inst_75353 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_75354 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_75353].join('');
var inst_75355 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75356 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_75357 = cljs.core.PersistentHashMap.fromArrays(inst_75355,inst_75356);
var inst_75358 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75354,inst_75357);
var inst_75359 = (function(){throw inst_75358})();
var state_75390__$1 = state_75390;
var statearr_75412_75459 = state_75390__$1;
(statearr_75412_75459[(2)] = inst_75359);

(statearr_75412_75459[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75391 === (3))){
var inst_75388 = (state_75390[(2)]);
var state_75390__$1 = state_75390;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75390__$1,inst_75388);
} else {
if((state_val_75391 === (12))){
var inst_75322 = (state_75390[(7)]);
var inst_75340 = (state_75390[(2)]);
var inst_75341 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75322,(0),null);
var inst_75342 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75322,(1),null);
var inst_75343 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_75344 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_75345 = cljs.core.keys(inst_75344);
var inst_75346 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_75343,inst_75345);
var state_75390__$1 = (function (){var statearr_75413 = state_75390;
(statearr_75413[(15)] = inst_75340);

(statearr_75413[(16)] = inst_75342);

(statearr_75413[(17)] = inst_75341);

return statearr_75413;
})();
if(inst_75346){
var statearr_75414_75460 = state_75390__$1;
(statearr_75414_75460[(1)] = (16));

} else {
var statearr_75415_75461 = state_75390__$1;
(statearr_75415_75461[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75391 === (2))){
var _ = (function (){var statearr_75416 = state_75390;
(statearr_75416[(4)] = cljs.core.cons((5),(state_75390[(4)])));

return statearr_75416;
})();
var inst_75314 = fluree.db.util.core.current_time_millis();
var inst_75315 = db;
var inst_75316 = cljs.core.__destructure_map(inst_75315);
var inst_75317 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75316,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_75318 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75316,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_75319 = fluree.db.api_js.resolve_block_range(db,query_map);
var state_75390__$1 = (function (){var statearr_75417 = state_75390;
(statearr_75417[(13)] = inst_75314);

(statearr_75417[(18)] = inst_75318);

(statearr_75417[(19)] = inst_75317);

return statearr_75417;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75390__$1,(6),inst_75319);
} else {
if((state_val_75391 === (23))){
var inst_75366 = (state_75390[(2)]);
var inst_75367 = fluree.db.util.async.throw_err(inst_75366);
var state_75390__$1 = state_75390;
var statearr_75418_75462 = state_75390__$1;
(statearr_75418_75462[(2)] = inst_75367);

(statearr_75418_75462[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75391 === (19))){
var inst_75350 = (state_75390[(2)]);
var inst_75351 = fluree.db.util.async.throw_err(inst_75350);
var state_75390__$1 = state_75390;
var statearr_75419_75463 = state_75390__$1;
(statearr_75419_75463[(2)] = inst_75351);

(statearr_75419_75463[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75391 === (11))){
var state_75390__$1 = state_75390;
var statearr_75421_75464 = state_75390__$1;
(statearr_75421_75464[(2)] = null);

(statearr_75421_75464[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75391 === (9))){
var inst_75328 = (state_75390[(2)]);
var state_75390__$1 = state_75390;
if(cljs.core.truth_(inst_75328)){
var statearr_75422_75465 = state_75390__$1;
(statearr_75422_75465[(1)] = (10));

} else {
var statearr_75423_75466 = state_75390__$1;
(statearr_75423_75466[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75391 === (5))){
var _ = (function (){var statearr_75424 = state_75390;
(statearr_75424[(4)] = cljs.core.rest((state_75390[(4)])));

return statearr_75424;
})();
var state_75390__$1 = state_75390;
var ex75420 = (state_75390__$1[(2)]);
var statearr_75425_75467 = state_75390__$1;
(statearr_75425_75467[(5)] = ex75420);


var statearr_75426_75468 = state_75390__$1;
(statearr_75426_75468[(1)] = (4));

(statearr_75426_75468[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75391 === (14))){
var inst_75318 = (state_75390[(18)]);
var inst_75317 = (state_75390[(19)]);
var inst_75333 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75317),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75318)].join('');
var state_75390__$1 = state_75390;
var statearr_75427_75469 = state_75390__$1;
(statearr_75427_75469[(2)] = inst_75333);

(statearr_75427_75469[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75391 === (26))){
var inst_75385 = (state_75390[(2)]);
var _ = (function (){var statearr_75428 = state_75390;
(statearr_75428[(4)] = cljs.core.rest((state_75390[(4)])));

return statearr_75428;
})();
var state_75390__$1 = state_75390;
var statearr_75429_75470 = state_75390__$1;
(statearr_75429_75470[(2)] = inst_75385);

(statearr_75429_75470[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75391 === (16))){
var inst_75342 = (state_75390[(16)]);
var inst_75341 = (state_75390[(17)]);
var inst_75348 = fluree.db.query.block.block_range(db,inst_75341,inst_75342,opts);
var state_75390__$1 = state_75390;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75390__$1,(19),inst_75348);
} else {
if((state_val_75391 === (10))){
var inst_75322 = (state_75390[(7)]);
var inst_75330 = (state_75390[(12)]);
var inst_75330__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_75322);
var state_75390__$1 = (function (){var statearr_75430 = state_75390;
(statearr_75430[(12)] = inst_75330__$1);

return statearr_75430;
})();
if(cljs.core.truth_(inst_75330__$1)){
var statearr_75431_75471 = state_75390__$1;
(statearr_75431_75471[(1)] = (13));

} else {
var statearr_75432_75472 = state_75390__$1;
(statearr_75432_75472[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75391 === (18))){
var inst_75361 = (state_75390[(2)]);
var inst_75362 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_75390__$1 = (function (){var statearr_75433 = state_75390;
(statearr_75433[(8)] = inst_75361);

return statearr_75433;
})();
if(cljs.core.truth_(inst_75362)){
var statearr_75434_75473 = state_75390__$1;
(statearr_75434_75473[(1)] = (20));

} else {
var statearr_75435_75474 = state_75390__$1;
(statearr_75435_75474[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75391 === (8))){
var inst_75323 = (state_75390[(14)]);
var state_75390__$1 = state_75390;
var statearr_75436_75475 = state_75390__$1;
(statearr_75436_75475[(2)] = inst_75323);

(statearr_75436_75475[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__11410__auto__ = null;
var fluree$db$api_js$state_machine__11410__auto____0 = (function (){
var statearr_75437 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75437[(0)] = fluree$db$api_js$state_machine__11410__auto__);

(statearr_75437[(1)] = (1));

return statearr_75437;
});
var fluree$db$api_js$state_machine__11410__auto____1 = (function (state_75390){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_75390);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e75438){var ex__11413__auto__ = e75438;
var statearr_75439_75476 = state_75390;
(statearr_75439_75476[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_75390[(4)]))){
var statearr_75440_75477 = state_75390;
(statearr_75440_75477[(1)] = cljs.core.first((state_75390[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75478 = state_75390;
state_75390 = G__75478;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__11410__auto__ = function(state_75390){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__11410__auto____1.call(this,state_75390);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__11410__auto____0;
fluree$db$api_js$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__11410__auto____1;
return fluree$db$api_js$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_75441 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_75441[(6)] = c__11484__auto__);

return statearr_75441;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__75480 = arguments.length;
switch (G__75480) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3(sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_75675){
var state_val_75676 = (state_75675[(1)]);
if((state_val_75676 === (62))){
var inst_75673 = (state_75675[(2)]);
var state_75675__$1 = state_75675;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75675__$1,inst_75673);
} else {
if((state_val_75676 === (7))){
var inst_75501 = (state_75675[(7)]);
var inst_75511 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_75501);
var state_75675__$1 = state_75675;
var statearr_75677_75768 = state_75675__$1;
(statearr_75677_75768[(2)] = inst_75511);

(statearr_75677_75768[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (59))){
var inst_75661 = (state_75675[(2)]);
var inst_75662 = fluree.db.util.async.throw_err(inst_75661);
var state_75675__$1 = state_75675;
var statearr_75678_75769 = state_75675__$1;
(statearr_75678_75769[(2)] = inst_75662);

(statearr_75678_75769[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (20))){
var inst_75577 = (state_75675[(8)]);
var inst_75569 = (state_75675[(9)]);
var inst_75569__$1 = (state_75675[(2)]);
var inst_75570 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75571 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75569__$1,(0));
var inst_75572 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75569__$1,(1));
var inst_75573 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75569__$1,(2));
var inst_75574 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75569__$1,(3));
var inst_75575 = [inst_75571,inst_75572,inst_75573,inst_75574];
var inst_75576 = (new cljs.core.PersistentVector(null,4,(5),inst_75570,inst_75575,null));
var inst_75577__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75576,(0),null);
var inst_75578 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75576,(1),null);
var inst_75579 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75576,(2),null);
var inst_75580 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75576,(3),null);
var inst_75581 = (inst_75577__$1 == null);
var inst_75582 = cljs.core.not(inst_75581);
var state_75675__$1 = (function (){var statearr_75679 = state_75675;
(statearr_75679[(10)] = inst_75578);

(statearr_75679[(8)] = inst_75577__$1);

(statearr_75679[(9)] = inst_75569__$1);

(statearr_75679[(11)] = inst_75579);

(statearr_75679[(12)] = inst_75580);

return statearr_75679;
})();
if(inst_75582){
var statearr_75680_75770 = state_75675__$1;
(statearr_75680_75770[(1)] = (30));

} else {
var statearr_75681_75771 = state_75675__$1;
(statearr_75681_75771[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (58))){
var inst_75509 = (state_75675[(13)]);
var inst_75665 = (state_75675[(2)]);
var state_75675__$1 = (function (){var statearr_75682 = state_75675;
(statearr_75682[(14)] = inst_75665);

return statearr_75682;
})();
if(cljs.core.truth_(inst_75509)){
var statearr_75683_75772 = state_75675__$1;
(statearr_75683_75772[(1)] = (60));

} else {
var statearr_75684_75773 = state_75675__$1;
(statearr_75684_75773[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (60))){
var inst_75665 = (state_75675[(14)]);
var inst_75653 = (state_75675[(15)]);
var inst_75667 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_75668 = cljs.core.count(inst_75653);
var inst_75669 = [inst_75665,inst_75668,(200)];
var inst_75670 = cljs.core.PersistentHashMap.fromArrays(inst_75667,inst_75669);
var state_75675__$1 = state_75675;
var statearr_75685_75774 = state_75675__$1;
(statearr_75685_75774[(2)] = inst_75670);

(statearr_75685_75774[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (27))){
var inst_75488 = (state_75675[(16)]);
var inst_75557 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75488)].join('');
var inst_75558 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75559 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_75560 = cljs.core.PersistentHashMap.fromArrays(inst_75558,inst_75559);
var inst_75561 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75557,inst_75560);
var inst_75562 = (function(){throw inst_75561})();
var state_75675__$1 = state_75675;
var statearr_75686_75775 = state_75675__$1;
(statearr_75686_75775[(2)] = inst_75562);

(statearr_75686_75775[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (1))){
var inst_75485 = query_map;
var inst_75486 = cljs.core.__destructure_map(inst_75485);
var inst_75487 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75486,new cljs.core.Keyword(null,"block","block",664686210));
var inst_75488 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75486,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_75489 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75486,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_75675__$1 = (function (){var statearr_75687 = state_75675;
(statearr_75687[(16)] = inst_75488);

(statearr_75687[(17)] = inst_75487);

(statearr_75687[(18)] = inst_75489);

return statearr_75687;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75675__$1,(2),sources);
} else {
if((state_val_75676 === (24))){
var inst_75488 = (state_75675[(16)]);
var inst_75546 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75488)].join('');
var inst_75547 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75548 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_75549 = cljs.core.PersistentHashMap.fromArrays(inst_75547,inst_75548);
var inst_75550 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75546,inst_75549);
var inst_75551 = (function(){throw inst_75550})();
var state_75675__$1 = state_75675;
var statearr_75688_75776 = state_75675__$1;
(statearr_75688_75776[(2)] = inst_75551);

(statearr_75688_75776[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (55))){
var inst_75489 = (state_75675[(18)]);
var inst_75656 = (state_75675[(2)]);
var inst_75657 = fluree.db.util.async.throw_err(inst_75656);
var state_75675__$1 = (function (){var statearr_75689 = state_75675;
(statearr_75689[(19)] = inst_75657);

return statearr_75689;
})();
if(cljs.core.truth_(inst_75489)){
var statearr_75690_75777 = state_75675__$1;
(statearr_75690_75777[(1)] = (56));

} else {
var statearr_75691_75778 = state_75675__$1;
(statearr_75691_75778[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (39))){
var inst_75578 = (state_75675[(10)]);
var inst_75577 = (state_75675[(8)]);
var inst_75579 = (state_75675[(11)]);
var inst_75580 = (state_75675[(12)]);
var inst_75601 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75602 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75603 = [inst_75578,inst_75577,inst_75579,inst_75580];
var inst_75604 = (new cljs.core.PersistentVector(null,4,(5),inst_75602,inst_75603,null));
var inst_75605 = [inst_75604,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_75606 = (new cljs.core.PersistentVector(null,2,(5),inst_75601,inst_75605,null));
var state_75675__$1 = state_75675;
var statearr_75692_75779 = state_75675__$1;
(statearr_75692_75779[(2)] = inst_75606);

(statearr_75692_75779[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (46))){
var inst_75611 = (state_75675[(20)]);
var state_75675__$1 = state_75675;
var statearr_75693_75780 = state_75675__$1;
(statearr_75693_75780[(2)] = inst_75611);

(statearr_75693_75780[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (4))){
var state_75675__$1 = state_75675;
var statearr_75694_75781 = state_75675__$1;
(statearr_75694_75781[(2)] = null);

(statearr_75694_75781[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (54))){
var inst_75492 = (state_75675[(21)]);
var inst_75653 = (state_75675[(15)]);
var inst_75652 = (state_75675[(2)]);
var inst_75653__$1 = fluree.db.util.async.throw_err(inst_75652);
var inst_75654 = fluree.db.api_js.format_history_resp(inst_75492,inst_75653__$1);
var state_75675__$1 = (function (){var statearr_75695 = state_75675;
(statearr_75695[(15)] = inst_75653__$1);

return statearr_75695;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75675__$1,(55),inst_75654);
} else {
if((state_val_75676 === (15))){
var inst_75492 = (state_75675[(21)]);
var inst_75533 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_75492);
var state_75675__$1 = state_75675;
var statearr_75696_75782 = state_75675__$1;
(statearr_75696_75782[(2)] = inst_75533);

(statearr_75696_75782[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (48))){
var inst_75578 = (state_75675[(10)]);
var inst_75577 = (state_75675[(8)]);
var inst_75579 = (state_75675[(11)]);
var inst_75580 = (state_75675[(12)]);
var inst_75622 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75623 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75624 = [inst_75578,inst_75579,inst_75577,inst_75580];
var inst_75625 = (new cljs.core.PersistentVector(null,4,(5),inst_75623,inst_75624,null));
var inst_75626 = [inst_75625,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_75627 = (new cljs.core.PersistentVector(null,2,(5),inst_75622,inst_75626,null));
var state_75675__$1 = state_75675;
var statearr_75697_75783 = state_75675__$1;
(statearr_75697_75783[(2)] = inst_75627);

(statearr_75697_75783[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (50))){
var inst_75640 = (state_75675[(2)]);
var state_75675__$1 = state_75675;
var statearr_75698_75784 = state_75675__$1;
(statearr_75698_75784[(2)] = inst_75640);

(statearr_75698_75784[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (21))){
var inst_75488 = (state_75675[(16)]);
var inst_75544 = cljs.core.empty_QMARK_(inst_75488);
var state_75675__$1 = state_75675;
if(inst_75544){
var statearr_75699_75785 = state_75675__$1;
(statearr_75699_75785[(1)] = (24));

} else {
var statearr_75700_75786 = state_75675__$1;
(statearr_75700_75786[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (31))){
var inst_75577 = (state_75675[(8)]);
var inst_75588 = (state_75675[(22)]);
var inst_75588__$1 = (inst_75577 == null);
var state_75675__$1 = (function (){var statearr_75701 = state_75675;
(statearr_75701[(22)] = inst_75588__$1);

return statearr_75701;
})();
if(cljs.core.truth_(inst_75588__$1)){
var statearr_75702_75787 = state_75675__$1;
(statearr_75702_75787[(1)] = (33));

} else {
var statearr_75703_75788 = state_75675__$1;
(statearr_75703_75788[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (32))){
var inst_75535 = (state_75675[(23)]);
var inst_75525 = (state_75675[(24)]);
var inst_75492 = (state_75675[(21)]);
var inst_75644 = (state_75675[(2)]);
var inst_75645 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75644,(0),null);
var inst_75646 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75644,(1),null);
var inst_75647 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_75648 = [inst_75525,inst_75535];
var inst_75649 = cljs.core.PersistentHashMap.fromArrays(inst_75647,inst_75648);
var inst_75650 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_75492,inst_75646,cljs.core._EQ_,inst_75645,inst_75649);
var state_75675__$1 = state_75675;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75675__$1,(54),inst_75650);
} else {
if((state_val_75676 === (40))){
var inst_75577 = (state_75675[(8)]);
var inst_75608 = (state_75675[(25)]);
var inst_75608__$1 = (inst_75577 == null);
var state_75675__$1 = (function (){var statearr_75704 = state_75675;
(statearr_75704[(25)] = inst_75608__$1);

return statearr_75704;
})();
if(cljs.core.truth_(inst_75608__$1)){
var statearr_75705_75789 = state_75675__$1;
(statearr_75705_75789[(1)] = (42));

} else {
var statearr_75706_75790 = state_75675__$1;
(statearr_75706_75790[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (56))){
var inst_75657 = (state_75675[(19)]);
var inst_75492 = (state_75675[(21)]);
var inst_75659 = fluree.db.api_js.format_block_resp_pretty(inst_75492,inst_75657);
var state_75675__$1 = state_75675;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75675__$1,(59),inst_75659);
} else {
if((state_val_75676 === (33))){
var inst_75578 = (state_75675[(10)]);
var inst_75591 = (state_75675[(26)]);
var inst_75590 = (inst_75578 == null);
var inst_75591__$1 = cljs.core.not(inst_75590);
var state_75675__$1 = (function (){var statearr_75707 = state_75675;
(statearr_75707[(26)] = inst_75591__$1);

return statearr_75707;
})();
if(inst_75591__$1){
var statearr_75708_75791 = state_75675__$1;
(statearr_75708_75791[(1)] = (36));

} else {
var statearr_75709_75792 = state_75675__$1;
(statearr_75709_75792[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (13))){
var inst_75519 = (state_75675[(2)]);
var inst_75520 = fluree.db.util.async.throw_err(inst_75519);
var inst_75521 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_75520);
var inst_75522 = (inst_75521 - (1));
var state_75675__$1 = state_75675;
var statearr_75710_75793 = state_75675__$1;
(statearr_75710_75793[(2)] = inst_75522);

(statearr_75710_75793[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (22))){
var state_75675__$1 = state_75675;
var statearr_75711_75794 = state_75675__$1;
(statearr_75711_75794[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (36))){
var inst_75579 = (state_75675[(11)]);
var inst_75593 = (inst_75579 == null);
var state_75675__$1 = state_75675;
var statearr_75713_75795 = state_75675__$1;
(statearr_75713_75795[(2)] = inst_75593);

(statearr_75713_75795[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (41))){
var inst_75642 = (state_75675[(2)]);
var state_75675__$1 = state_75675;
var statearr_75714_75796 = state_75675__$1;
(statearr_75714_75796[(2)] = inst_75642);

(statearr_75714_75796[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (43))){
var inst_75608 = (state_75675[(25)]);
var state_75675__$1 = state_75675;
var statearr_75715_75797 = state_75675__$1;
(statearr_75715_75797[(2)] = inst_75608);

(statearr_75715_75797[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (61))){
var inst_75665 = (state_75675[(14)]);
var state_75675__$1 = state_75675;
var statearr_75716_75798 = state_75675__$1;
(statearr_75716_75798[(2)] = inst_75665);

(statearr_75716_75798[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (29))){
var inst_75565 = (state_75675[(2)]);
var state_75675__$1 = state_75675;
var statearr_75717_75799 = state_75675__$1;
(statearr_75717_75799[(2)] = inst_75565);

(statearr_75717_75799[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (44))){
var inst_75620 = (state_75675[(2)]);
var state_75675__$1 = state_75675;
if(cljs.core.truth_(inst_75620)){
var statearr_75718_75800 = state_75675__$1;
(statearr_75718_75800[(1)] = (48));

} else {
var statearr_75719_75801 = state_75675__$1;
(statearr_75719_75801[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (6))){
var inst_75496 = (state_75675[(2)]);
var inst_75497 = fluree.db.util.async.throw_err(inst_75496);
var state_75675__$1 = state_75675;
var statearr_75720_75802 = state_75675__$1;
(statearr_75720_75802[(2)] = inst_75497);

(statearr_75720_75802[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (28))){
var state_75675__$1 = state_75675;
var statearr_75721_75803 = state_75675__$1;
(statearr_75721_75803[(2)] = null);

(statearr_75721_75803[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (51))){
var inst_75488 = (state_75675[(16)]);
var inst_75630 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75488)].join('');
var inst_75631 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75632 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_75633 = cljs.core.PersistentHashMap.fromArrays(inst_75631,inst_75632);
var inst_75634 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75630,inst_75633);
var inst_75635 = (function(){throw inst_75634})();
var state_75675__$1 = state_75675;
var statearr_75722_75804 = state_75675__$1;
(statearr_75722_75804[(2)] = inst_75635);

(statearr_75722_75804[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (25))){
var inst_75488 = (state_75675[(16)]);
var state_75675__$1 = state_75675;
var statearr_75723_75805 = state_75675__$1;
(statearr_75723_75805[(2)] = inst_75488);

(statearr_75723_75805[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (34))){
var inst_75588 = (state_75675[(22)]);
var state_75675__$1 = state_75675;
var statearr_75724_75806 = state_75675__$1;
(statearr_75724_75806[(2)] = inst_75588);

(statearr_75724_75806[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (17))){
var inst_75529 = (state_75675[(2)]);
var inst_75530 = fluree.db.util.async.throw_err(inst_75529);
var inst_75531 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_75530);
var state_75675__$1 = state_75675;
var statearr_75725_75807 = state_75675__$1;
(statearr_75725_75807[(2)] = inst_75531);

(statearr_75725_75807[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (3))){
var inst_75492 = (state_75675[(21)]);
var inst_75494 = fluree.db.api_js.resolve_block_range(inst_75492,query_map);
var state_75675__$1 = state_75675;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75675__$1,(6),inst_75494);
} else {
if((state_val_75676 === (12))){
var inst_75502 = (state_75675[(27)]);
var inst_75525 = (state_75675[(2)]);
var state_75675__$1 = (function (){var statearr_75726 = state_75675;
(statearr_75726[(24)] = inst_75525);

return statearr_75726;
})();
if(cljs.core.truth_(inst_75502)){
var statearr_75727_75808 = state_75675__$1;
(statearr_75727_75808[(1)] = (14));

} else {
var statearr_75728_75809 = state_75675__$1;
(statearr_75728_75809[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (2))){
var inst_75487 = (state_75675[(17)]);
var inst_75491 = (state_75675[(2)]);
var inst_75492 = fluree.db.util.async.throw_err(inst_75491);
var state_75675__$1 = (function (){var statearr_75729 = state_75675;
(statearr_75729[(21)] = inst_75492);

return statearr_75729;
})();
if(cljs.core.truth_(inst_75487)){
var statearr_75730_75810 = state_75675__$1;
(statearr_75730_75810[(1)] = (3));

} else {
var statearr_75731_75811 = state_75675__$1;
(statearr_75731_75811[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (23))){
var inst_75567 = (state_75675[(2)]);
var state_75675__$1 = state_75675;
var statearr_75732_75812 = state_75675__$1;
(statearr_75732_75812[(2)] = inst_75567);

(statearr_75732_75812[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (47))){
var inst_75617 = (state_75675[(2)]);
var state_75675__$1 = state_75675;
var statearr_75733_75813 = state_75675__$1;
(statearr_75733_75813[(2)] = inst_75617);

(statearr_75733_75813[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (35))){
var inst_75599 = (state_75675[(2)]);
var state_75675__$1 = state_75675;
if(cljs.core.truth_(inst_75599)){
var statearr_75734_75814 = state_75675__$1;
(statearr_75734_75814[(1)] = (39));

} else {
var statearr_75735_75815 = state_75675__$1;
(statearr_75735_75815[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (19))){
var inst_75488 = (state_75675[(16)]);
var inst_75542 = cljs.core.sequential_QMARK_(inst_75488);
var state_75675__$1 = state_75675;
if(inst_75542){
var statearr_75736_75816 = state_75675__$1;
(statearr_75736_75816[(1)] = (21));

} else {
var statearr_75737_75817 = state_75675__$1;
(statearr_75737_75817[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (57))){
var inst_75657 = (state_75675[(19)]);
var state_75675__$1 = state_75675;
var statearr_75738_75818 = state_75675__$1;
(statearr_75738_75818[(2)] = inst_75657);

(statearr_75738_75818[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (11))){
var state_75675__$1 = state_75675;
var statearr_75739_75819 = state_75675__$1;
(statearr_75739_75819[(2)] = (-1));

(statearr_75739_75819[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (9))){
var inst_75514 = (state_75675[(2)]);
var state_75675__$1 = state_75675;
if(cljs.core.truth_(inst_75514)){
var statearr_75740_75820 = state_75675__$1;
(statearr_75740_75820[(1)] = (10));

} else {
var statearr_75741_75821 = state_75675__$1;
(statearr_75741_75821[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (5))){
var inst_75501 = (state_75675[(7)]);
var inst_75500 = (state_75675[(2)]);
var inst_75501__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75500,(0),null);
var inst_75502 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75500,(1),null);
var inst_75509 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_75675__$1 = (function (){var statearr_75742 = state_75675;
(statearr_75742[(7)] = inst_75501__$1);

(statearr_75742[(27)] = inst_75502);

(statearr_75742[(13)] = inst_75509);

return statearr_75742;
})();
if(cljs.core.truth_(inst_75501__$1)){
var statearr_75743_75822 = state_75675__$1;
(statearr_75743_75822[(1)] = (7));

} else {
var statearr_75744_75823 = state_75675__$1;
(statearr_75744_75823[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (14))){
var inst_75492 = (state_75675[(21)]);
var inst_75502 = (state_75675[(27)]);
var inst_75527 = fluree.db.time_travel.as_of_block(inst_75492,inst_75502);
var state_75675__$1 = state_75675;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75675__$1,(17),inst_75527);
} else {
if((state_val_75676 === (45))){
var inst_75579 = (state_75675[(11)]);
var inst_75613 = (inst_75579 == null);
var inst_75614 = cljs.core.not(inst_75613);
var state_75675__$1 = state_75675;
var statearr_75745_75824 = state_75675__$1;
(statearr_75745_75824[(2)] = inst_75614);

(statearr_75745_75824[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (53))){
var inst_75638 = (state_75675[(2)]);
var state_75675__$1 = state_75675;
var statearr_75746_75825 = state_75675__$1;
(statearr_75746_75825[(2)] = inst_75638);

(statearr_75746_75825[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (26))){
var inst_75554 = (state_75675[(2)]);
var state_75675__$1 = state_75675;
var statearr_75747_75826 = state_75675__$1;
(statearr_75747_75826[(2)] = inst_75554);

(statearr_75747_75826[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (16))){
var inst_75488 = (state_75675[(16)]);
var inst_75535 = (state_75675[(2)]);
var inst_75536 = fluree.db.util.core.subj_ident_QMARK_(inst_75488);
var state_75675__$1 = (function (){var statearr_75748 = state_75675;
(statearr_75748[(23)] = inst_75535);

return statearr_75748;
})();
if(inst_75536){
var statearr_75749_75827 = state_75675__$1;
(statearr_75749_75827[(1)] = (18));

} else {
var statearr_75750_75828 = state_75675__$1;
(statearr_75750_75828[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (38))){
var inst_75596 = (state_75675[(2)]);
var state_75675__$1 = state_75675;
var statearr_75751_75829 = state_75675__$1;
(statearr_75751_75829[(2)] = inst_75596);

(statearr_75751_75829[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (30))){
var inst_75569 = (state_75675[(9)]);
var inst_75584 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75585 = [inst_75569,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_75586 = (new cljs.core.PersistentVector(null,2,(5),inst_75584,inst_75585,null));
var state_75675__$1 = state_75675;
var statearr_75752_75830 = state_75675__$1;
(statearr_75752_75830[(2)] = inst_75586);

(statearr_75752_75830[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (10))){
var inst_75501 = (state_75675[(7)]);
var inst_75492 = (state_75675[(21)]);
var inst_75516 = (inst_75501 - (1));
var inst_75517 = fluree.db.time_travel.as_of_block(inst_75492,inst_75516);
var state_75675__$1 = state_75675;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75675__$1,(13),inst_75517);
} else {
if((state_val_75676 === (18))){
var inst_75488 = (state_75675[(16)]);
var inst_75538 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75539 = [inst_75488];
var inst_75540 = (new cljs.core.PersistentVector(null,1,(5),inst_75538,inst_75539,null));
var state_75675__$1 = state_75675;
var statearr_75753_75831 = state_75675__$1;
(statearr_75753_75831[(2)] = inst_75540);

(statearr_75753_75831[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (52))){
var state_75675__$1 = state_75675;
var statearr_75754_75832 = state_75675__$1;
(statearr_75754_75832[(2)] = null);

(statearr_75754_75832[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (42))){
var inst_75578 = (state_75675[(10)]);
var inst_75611 = (state_75675[(20)]);
var inst_75610 = (inst_75578 == null);
var inst_75611__$1 = cljs.core.not(inst_75610);
var state_75675__$1 = (function (){var statearr_75755 = state_75675;
(statearr_75755[(20)] = inst_75611__$1);

return statearr_75755;
})();
if(inst_75611__$1){
var statearr_75756_75833 = state_75675__$1;
(statearr_75756_75833[(1)] = (45));

} else {
var statearr_75757_75834 = state_75675__$1;
(statearr_75757_75834[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (37))){
var inst_75591 = (state_75675[(26)]);
var state_75675__$1 = state_75675;
var statearr_75758_75835 = state_75675__$1;
(statearr_75758_75835[(2)] = inst_75591);

(statearr_75758_75835[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (8))){
var inst_75501 = (state_75675[(7)]);
var state_75675__$1 = state_75675;
var statearr_75759_75836 = state_75675__$1;
(statearr_75759_75836[(2)] = inst_75501);

(statearr_75759_75836[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75676 === (49))){
var state_75675__$1 = state_75675;
var statearr_75760_75837 = state_75675__$1;
(statearr_75760_75837[(1)] = (51));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__11410__auto__ = null;
var fluree$db$api_js$state_machine__11410__auto____0 = (function (){
var statearr_75762 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75762[(0)] = fluree$db$api_js$state_machine__11410__auto__);

(statearr_75762[(1)] = (1));

return statearr_75762;
});
var fluree$db$api_js$state_machine__11410__auto____1 = (function (state_75675){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_75675);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e75763){var ex__11413__auto__ = e75763;
var statearr_75764_75838 = state_75675;
(statearr_75764_75838[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_75675[(4)]))){
var statearr_75765_75839 = state_75675;
(statearr_75765_75839[(1)] = cljs.core.first((state_75675[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75840 = state_75675;
state_75675 = G__75840;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__11410__auto__ = function(state_75675){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__11410__auto____1.call(this,state_75675);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__11410__auto____0;
fluree$db$api_js$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__11410__auto____1;
return fluree$db$api_js$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_75766 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_75766[(6)] = c__11484__auto__);

return statearr_75766;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__75848 = arguments.length;
switch (G__75848) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4(sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4(sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5753__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5753__auto__)){
var block = temp__5753__auto__;
return fluree.db.util.async.throw_err(cljs.core.async._LT__BANG_(fluree.db.time_travel.block_to_int_format(fluree.db.util.async.throw_err(cljs.core.async._LT__BANG_(db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__4251__auto__ = block;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.map_QMARK_(block);
} else {
return and__4251__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__4251__auto__ = block;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.coll_QMARK_(block);
} else {
return and__4251__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__75841_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__75841_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals(multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys(multi_query_map_SINGLEQUOTE_);
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_75937){
var state_val_75938 = (state_75937[(1)]);
if((state_val_75938 === (7))){
var inst_75898 = (state_75937[(7)]);
var inst_75888 = (state_75937[(8)]);
var inst_75891 = (state_75937[(9)]);
var inst_75894 = (state_75937[(10)]);
var inst_75904 = (function (){var responses = inst_75888;
var responses_STAR_ = inst_75891;
var statuses = inst_75894;
var fuel = inst_75898;
return (function (p1__75844_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),p1__75844_SHARP_);
});
})();
var inst_75905 = cljs.core.some(inst_75904,inst_75894);
var state_75937__$1 = state_75937;
if(cljs.core.truth_(inst_75905)){
var statearr_75939_75987 = state_75937__$1;
(statearr_75939_75987[(1)] = (9));

} else {
var statearr_75940_75988 = state_75937__$1;
(statearr_75940_75988[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75938 === (20))){
var inst_75932 = (state_75937[(2)]);
var state_75937__$1 = state_75937;
var statearr_75941_75989 = state_75937__$1;
(statearr_75941_75989[(2)] = inst_75932);

(statearr_75941_75989[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75938 === (1))){
var inst_75883 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_75884 = (function (){var c__11484__auto____$1 = inst_75883;
return (function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_75881){
var state_val_75882 = (state_75881[(1)]);
if((state_val_75882 === (1))){
var inst_75849 = cljs.core.first(keys_SINGLEQUOTE_);
var inst_75850 = cljs.core.first(vals_SINGLEQUOTE_);
var inst_75851 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_75850,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_75852 = cljs.core.rest(keys_SINGLEQUOTE_);
var inst_75853 = cljs.core.rest(vals_SINGLEQUOTE_);
var inst_75854 = cljs.core.PersistentHashMap.EMPTY;
var inst_75855 = inst_75849;
var inst_75856 = inst_75851;
var inst_75857 = inst_75852;
var inst_75858 = inst_75853;
var inst_75859 = inst_75854;
var state_75881__$1 = (function (){var statearr_75942 = state_75881;
(statearr_75942[(7)] = inst_75857);

(statearr_75942[(8)] = inst_75859);

(statearr_75942[(9)] = inst_75858);

(statearr_75942[(10)] = inst_75855);

(statearr_75942[(11)] = inst_75856);

return statearr_75942;
})();
var statearr_75943_75990 = state_75881__$1;
(statearr_75943_75990[(2)] = null);

(statearr_75943_75990[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75882 === (2))){
var inst_75856 = (state_75881[(11)]);
var inst_75861 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_75856);
var inst_75862 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts,inst_75861], 0));
var inst_75863 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_75856,new cljs.core.Keyword(null,"opts","opts",155075701),inst_75862);
var inst_75864 = fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3(db,inst_75863,db_fn);
var state_75881__$1 = state_75881;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75881__$1,(4),inst_75864);
} else {
if((state_val_75882 === (3))){
var inst_75879 = (state_75881[(2)]);
var state_75881__$1 = state_75881;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75881__$1,inst_75879);
} else {
if((state_val_75882 === (4))){
var inst_75857 = (state_75881[(7)]);
var inst_75859 = (state_75881[(8)]);
var inst_75855 = (state_75881[(10)]);
var inst_75866 = (state_75881[(2)]);
var inst_75867 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_75859,inst_75855,inst_75866);
var inst_75868 = cljs.core.first(inst_75857);
var state_75881__$1 = (function (){var statearr_75944 = state_75881;
(statearr_75944[(12)] = inst_75867);

return statearr_75944;
})();
if(cljs.core.truth_(inst_75868)){
var statearr_75945_75991 = state_75881__$1;
(statearr_75945_75991[(1)] = (5));

} else {
var statearr_75946_75992 = state_75881__$1;
(statearr_75946_75992[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75882 === (5))){
var inst_75857 = (state_75881[(7)]);
var inst_75858 = (state_75881[(9)]);
var inst_75867 = (state_75881[(12)]);
var inst_75870 = cljs.core.first(inst_75857);
var inst_75871 = cljs.core.first(inst_75858);
var inst_75872 = cljs.core.rest(inst_75857);
var inst_75873 = cljs.core.rest(inst_75858);
var inst_75855 = inst_75870;
var inst_75856 = inst_75871;
var inst_75857__$1 = inst_75872;
var inst_75858__$1 = inst_75873;
var inst_75859 = inst_75867;
var state_75881__$1 = (function (){var statearr_75947 = state_75881;
(statearr_75947[(7)] = inst_75857__$1);

(statearr_75947[(8)] = inst_75859);

(statearr_75947[(9)] = inst_75858__$1);

(statearr_75947[(10)] = inst_75855);

(statearr_75947[(11)] = inst_75856);

return statearr_75947;
})();
var statearr_75948_75993 = state_75881__$1;
(statearr_75948_75993[(2)] = null);

(statearr_75948_75993[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75882 === (6))){
var inst_75867 = (state_75881[(12)]);
var state_75881__$1 = state_75881;
var statearr_75949_75994 = state_75881__$1;
(statearr_75949_75994[(2)] = inst_75867);

(statearr_75949_75994[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75882 === (7))){
var inst_75877 = (state_75881[(2)]);
var state_75881__$1 = state_75881;
var statearr_75950_75995 = state_75881__$1;
(statearr_75950_75995[(2)] = inst_75877);

(statearr_75950_75995[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__11410__auto__ = null;
var fluree$db$api_js$state_machine__11410__auto____0 = (function (){
var statearr_75951 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75951[(0)] = fluree$db$api_js$state_machine__11410__auto__);

(statearr_75951[(1)] = (1));

return statearr_75951;
});
var fluree$db$api_js$state_machine__11410__auto____1 = (function (state_75881){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_75881);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e75952){var ex__11413__auto__ = e75952;
var statearr_75953_75996 = state_75881;
(statearr_75953_75996[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_75881[(4)]))){
var statearr_75954_75997 = state_75881;
(statearr_75954_75997[(1)] = cljs.core.first((state_75881[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75998 = state_75881;
state_75881 = G__75998;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__11410__auto__ = function(state_75881){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__11410__auto____1.call(this,state_75881);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__11410__auto____0;
fluree$db$api_js$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__11410__auto____1;
return fluree$db$api_js$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_75955 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_75955[(6)] = c__11484__auto____$1);

return statearr_75955;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
});
})();
var inst_75885 = cljs.core.async.impl.dispatch.run(inst_75884);
var state_75937__$1 = (function (){var statearr_75956 = state_75937;
(statearr_75956[(11)] = inst_75885);

return statearr_75956;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75937__$1,(2),inst_75883);
} else {
if((state_val_75938 === (4))){
var inst_75888 = (state_75937[(8)]);
var state_75937__$1 = state_75937;
var statearr_75957_75999 = state_75937__$1;
(statearr_75957_75999[(2)] = inst_75888);

(statearr_75957_75999[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75938 === (15))){
var state_75937__$1 = state_75937;
var statearr_75958_76000 = state_75937__$1;
(statearr_75958_76000[(2)] = (400));

(statearr_75958_76000[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75938 === (13))){
var state_75937__$1 = state_75937;
var statearr_75959_76001 = state_75937__$1;
(statearr_75959_76001[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75938 === (6))){
var inst_75894 = (state_75937[(10)]);
var inst_75902 = cljs.core.first(inst_75894);
var state_75937__$1 = state_75937;
var statearr_75961_76002 = state_75937__$1;
(statearr_75961_76002[(2)] = inst_75902);

(statearr_75961_76002[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75938 === (17))){
var inst_75915 = (state_75937[(2)]);
var state_75937__$1 = state_75937;
var statearr_75962_76003 = state_75937__$1;
(statearr_75962_76003[(2)] = inst_75915);

(statearr_75962_76003[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75938 === (3))){
var inst_75898 = (state_75937[(7)]);
var inst_75888 = (state_75937[(8)]);
var inst_75891 = (state_75937[(9)]);
var inst_75894 = (state_75937[(10)]);
var inst_75893 = cljs.core.vals(inst_75888);
var inst_75894__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"status","status",-1997798413),inst_75893);
var inst_75895 = (function (){var responses = inst_75888;
var responses_STAR_ = inst_75891;
var statuses = inst_75894__$1;
return (function (p1__75842_SHARP_){
var or__4253__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__75842_SHARP_);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
});
})();
var inst_75896 = cljs.core.vals(inst_75888);
var inst_75897 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_75895,inst_75896);
var inst_75898__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,inst_75897);
var inst_75899 = (function (){var responses = inst_75888;
var responses_STAR_ = inst_75891;
var statuses = inst_75894__$1;
var fuel = inst_75898__$1;
return (function (p1__75843_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(statuses),p1__75843_SHARP_);
});
})();
var inst_75900 = cljs.core.every_QMARK_(inst_75899,inst_75894__$1);
var state_75937__$1 = (function (){var statearr_75963 = state_75937;
(statearr_75963[(7)] = inst_75898__$1);

(statearr_75963[(10)] = inst_75894__$1);

return statearr_75963;
})();
if(inst_75900){
var statearr_75964_76004 = state_75937__$1;
(statearr_75964_76004[(1)] = (6));

} else {
var statearr_75965_76005 = state_75937__$1;
(statearr_75965_76005[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75938 === (12))){
var state_75937__$1 = state_75937;
var statearr_75966_76006 = state_75937__$1;
(statearr_75966_76006[(2)] = (500));

(statearr_75966_76006[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75938 === (2))){
var inst_75888 = (state_75937[(8)]);
var inst_75887 = (state_75937[(2)]);
var inst_75888__$1 = fluree.db.util.async.throw_err(inst_75887);
var inst_75889 = (function (){var responses = inst_75888__$1;
return (function (acc,index,response){
var resp = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,index,resp);
}
});
})();
var inst_75890 = cljs.core.PersistentHashMap.EMPTY;
var inst_75891 = cljs.core.reduce_kv(inst_75889,inst_75890,inst_75888__$1);
var state_75937__$1 = (function (){var statearr_75967 = state_75937;
(statearr_75967[(8)] = inst_75888__$1);

(statearr_75967[(9)] = inst_75891);

return statearr_75967;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_75968_76007 = state_75937__$1;
(statearr_75968_76007[(1)] = (3));

} else {
var statearr_75969_76008 = state_75937__$1;
(statearr_75969_76008[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75938 === (19))){
var inst_75898 = (state_75937[(7)]);
var inst_75891 = (state_75937[(9)]);
var inst_75921 = (state_75937[(12)]);
var inst_75930 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_75891,new cljs.core.Keyword(null,"status","status",-1997798413),inst_75921,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_75898], 0));
var state_75937__$1 = state_75937;
var statearr_75970_76009 = state_75937__$1;
(statearr_75970_76009[(2)] = inst_75930);

(statearr_75970_76009[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75938 === (11))){
var inst_75919 = (state_75937[(2)]);
var state_75937__$1 = state_75937;
var statearr_75971_76010 = state_75937__$1;
(statearr_75971_76010[(2)] = inst_75919);

(statearr_75971_76010[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75938 === (9))){
var state_75937__$1 = state_75937;
var statearr_75972_76011 = state_75937__$1;
(statearr_75972_76011[(2)] = (207));

(statearr_75972_76011[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75938 === (5))){
var inst_75935 = (state_75937[(2)]);
var state_75937__$1 = state_75937;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75937__$1,inst_75935);
} else {
if((state_val_75938 === (14))){
var inst_75917 = (state_75937[(2)]);
var state_75937__$1 = state_75937;
var statearr_75973_76012 = state_75937__$1;
(statearr_75973_76012[(2)] = inst_75917);

(statearr_75973_76012[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75938 === (16))){
var state_75937__$1 = state_75937;
var statearr_75974_76013 = state_75937__$1;
(statearr_75974_76013[(2)] = null);

(statearr_75974_76013[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75938 === (10))){
var inst_75898 = (state_75937[(7)]);
var inst_75888 = (state_75937[(8)]);
var inst_75891 = (state_75937[(9)]);
var inst_75894 = (state_75937[(10)]);
var inst_75908 = (function (){var responses = inst_75888;
var responses_STAR_ = inst_75891;
var statuses = inst_75894;
var fuel = inst_75898;
return (function (p1__75845_SHARP_){
return ((499) < p1__75845_SHARP_);
});
})();
var inst_75909 = cljs.core.some(inst_75908,inst_75894);
var state_75937__$1 = state_75937;
if(cljs.core.truth_(inst_75909)){
var statearr_75975_76014 = state_75937__$1;
(statearr_75975_76014[(1)] = (12));

} else {
var statearr_75976_76015 = state_75937__$1;
(statearr_75976_76015[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75938 === (18))){
var inst_75898 = (state_75937[(7)]);
var inst_75926 = (state_75937[(13)]);
var inst_75891 = (state_75937[(9)]);
var inst_75921 = (state_75937[(12)]);
var inst_75928 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_75891,new cljs.core.Keyword(null,"status","status",-1997798413),inst_75921,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_75898,new cljs.core.Keyword(null,"block","block",664686210),inst_75926], 0));
var state_75937__$1 = state_75937;
var statearr_75977_76016 = state_75937__$1;
(statearr_75977_76016[(2)] = inst_75928);

(statearr_75977_76016[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75938 === (8))){
var inst_75898 = (state_75937[(7)]);
var inst_75888 = (state_75937[(8)]);
var inst_75926 = (state_75937[(13)]);
var inst_75891 = (state_75937[(9)]);
var inst_75921 = (state_75937[(12)]);
var inst_75894 = (state_75937[(10)]);
var inst_75921__$1 = (state_75937[(2)]);
var inst_75922 = (function (){var responses = inst_75888;
var responses_STAR_ = inst_75891;
var statuses = inst_75894;
var fuel = inst_75898;
var status = inst_75921__$1;
return (function (p1__75846_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__75846_SHARP_));
});
})();
var inst_75923 = cljs.core.vals(inst_75888);
var inst_75924 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_75922,inst_75923);
var inst_75925 = cljs.core.first(inst_75924);
var inst_75926__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_75925);
var state_75937__$1 = (function (){var statearr_75978 = state_75937;
(statearr_75978[(13)] = inst_75926__$1);

(statearr_75978[(12)] = inst_75921__$1);

return statearr_75978;
})();
if(cljs.core.truth_(inst_75926__$1)){
var statearr_75979_76017 = state_75937__$1;
(statearr_75979_76017[(1)] = (18));

} else {
var statearr_75980_76018 = state_75937__$1;
(statearr_75980_76018[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__11410__auto__ = null;
var fluree$db$api_js$state_machine__11410__auto____0 = (function (){
var statearr_75981 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75981[(0)] = fluree$db$api_js$state_machine__11410__auto__);

(statearr_75981[(1)] = (1));

return statearr_75981;
});
var fluree$db$api_js$state_machine__11410__auto____1 = (function (state_75937){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_75937);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e75982){var ex__11413__auto__ = e75982;
var statearr_75983_76019 = state_75937;
(statearr_75983_76019[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_75937[(4)]))){
var statearr_75984_76020 = state_75937;
(statearr_75984_76020[(1)] = cljs.core.first((state_75937[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76021 = state_75937;
state_75937 = G__76021;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__11410__auto__ = function(state_75937){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__11410__auto____1.call(this,state_75937);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__11410__auto____0;
fluree$db$api_js$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__11410__auto____1;
return fluree$db$api_js$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_75985 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_75985[(6)] = c__11484__auto__);

return statearr_75985;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__76023 = arguments.length;
switch (G__76023) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var db_name = ((cljs.core.sequential_QMARK_(ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second(ledger))].join(''):ledger);
var map__76024 = opts;
var map__76024__$1 = cljs.core.__destructure_map(map__76024);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76024__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76024__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76024__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76024__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = (fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1(private_key) : fluree.crypto.account_id_from_private.call(null,private_key));
var vec__76025 = (cljs.core.truth_((function (){var and__4251__auto__ = auth;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(auth,key_auth_id);
} else {
return and__4251__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__76025,(0),null);
var authority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__76025,(1),null);
var action__$1 = (function (){var or__4253__auto__ = action;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis();
var nonce__$1 = (function (){var or__4253__auto__ = nonce;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4253__auto__ = expire;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace(fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e76028){var e = e76028;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.sign_message(cmd,private_key);
var id = fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1(cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__76031 = arguments.length;
switch (G__76031) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_76062){
var state_val_76063 = (state_76062[(1)]);
if((state_val_76063 === (7))){
var state_76062__$1 = state_76062;
var statearr_76064_76085 = state_76062__$1;
(statearr_76064_76085[(2)] = opts);

(statearr_76064_76085[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76063 === (1))){
var state_76062__$1 = state_76062;
var statearr_76065_76086 = state_76062__$1;
(statearr_76065_76086[(2)] = null);

(statearr_76065_76086[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76063 === (4))){
var inst_76032 = (state_76062[(2)]);
var inst_76033 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_76032], 0));
var inst_76034 = cljs.core.ex_data(inst_76032);
var inst_76035 = cljs.core.ex_message(inst_76032);
var inst_76036 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_76034,new cljs.core.Keyword(null,"message","message",-406056002),inst_76035);
var state_76062__$1 = (function (){var statearr_76066 = state_76062;
(statearr_76066[(7)] = inst_76033);

return statearr_76066;
})();
var statearr_76067_76087 = state_76062__$1;
(statearr_76067_76087[(2)] = inst_76036);

(statearr_76067_76087[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76063 === (6))){
var inst_76046 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76047 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_76048 = (new cljs.core.PersistentVector(null,1,(5),inst_76046,inst_76047,null));
var inst_76049 = cljs.core.assoc_in(opts,inst_76048,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_76062__$1 = state_76062;
var statearr_76068_76088 = state_76062__$1;
(statearr_76068_76088[(2)] = inst_76049);

(statearr_76068_76088[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76063 === (3))){
var inst_76060 = (state_76062[(2)]);
var state_76062__$1 = state_76062;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76062__$1,inst_76060);
} else {
if((state_val_76063 === (2))){
var _ = (function (){var statearr_76070 = state_76062;
(statearr_76070[(4)] = cljs.core.cons((5),(state_76062[(4)])));

return statearr_76070;
})();
var inst_76042 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_76043 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_76044 = (inst_76043 == null);
var state_76062__$1 = (function (){var statearr_76071 = state_76062;
(statearr_76071[(8)] = inst_76042);

return statearr_76071;
})();
if(cljs.core.truth_(inst_76044)){
var statearr_76072_76089 = state_76062__$1;
(statearr_76072_76089[(1)] = (6));

} else {
var statearr_76073_76090 = state_76062__$1;
(statearr_76073_76090[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76063 === (9))){
var inst_76056 = (state_76062[(2)]);
var inst_76057 = fluree.db.util.async.throw_err(inst_76056);
var _ = (function (){var statearr_76074 = state_76062;
(statearr_76074[(4)] = cljs.core.rest((state_76062[(4)])));

return statearr_76074;
})();
var state_76062__$1 = state_76062;
var statearr_76075_76091 = state_76062__$1;
(statearr_76075_76091[(2)] = inst_76057);

(statearr_76075_76091[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76063 === (5))){
var _ = (function (){var statearr_76076 = state_76062;
(statearr_76076[(4)] = cljs.core.rest((state_76062[(4)])));

return statearr_76076;
})();
var state_76062__$1 = state_76062;
var ex76069 = (state_76062__$1[(2)]);
var statearr_76077_76092 = state_76062__$1;
(statearr_76077_76092[(5)] = ex76069);


var statearr_76078_76093 = state_76062__$1;
(statearr_76078_76093[(1)] = (4));

(statearr_76078_76093[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76063 === (8))){
var inst_76042 = (state_76062[(8)]);
var inst_76052 = (state_76062[(2)]);
var inst_76053 = fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,query_map,inst_76042,inst_76052);
var inst_76054 = fluree.db.operations.command_async(conn,inst_76053);
var state_76062__$1 = state_76062;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76062__$1,(9),inst_76054);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__11410__auto__ = null;
var fluree$db$api_js$state_machine__11410__auto____0 = (function (){
var statearr_76079 = [null,null,null,null,null,null,null,null,null];
(statearr_76079[(0)] = fluree$db$api_js$state_machine__11410__auto__);

(statearr_76079[(1)] = (1));

return statearr_76079;
});
var fluree$db$api_js$state_machine__11410__auto____1 = (function (state_76062){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_76062);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e76080){var ex__11413__auto__ = e76080;
var statearr_76081_76094 = state_76062;
(statearr_76081_76094[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_76062[(4)]))){
var statearr_76082_76095 = state_76062;
(statearr_76082_76095[(1)] = cljs.core.first((state_76062[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76096 = state_76062;
state_76062 = G__76096;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__11410__auto__ = function(state_76062){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__11410__auto____1.call(this,state_76062);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__11410__auto____0;
fluree$db$api_js$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__11410__auto____1;
return fluree$db$api_js$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_76083 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_76083[(6)] = c__11484__auto__);

return statearr_76083;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

