// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(dbid){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__70216 = arguments.length;
switch (G__70216) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__11484__auto___70364 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_70303){
var state_val_70304 = (state_70303[(1)]);
if((state_val_70304 === (7))){
var inst_70234 = (state_70303[(7)]);
var inst_70237 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_70234);
var state_70303__$1 = state_70303;
var statearr_70305_70365 = state_70303__$1;
(statearr_70305_70365[(2)] = inst_70237);

(statearr_70305_70365[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70304 === (20))){
var inst_70258 = (state_70303[(8)]);
var inst_70229 = (state_70303[(9)]);
var inst_70262 = fluree.db.auth.roles(inst_70229,inst_70258);
var state_70303__$1 = state_70303;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70303__$1,(23),inst_70262);
} else {
if((state_val_70304 === (27))){
var inst_70229 = (state_70303[(9)]);
var inst_70277 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_70278 = fluree.db.time_travel.as_of_block(inst_70229,inst_70277);
var state_70303__$1 = state_70303;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70303__$1,(30),inst_70278);
} else {
if((state_val_70304 === (1))){
var state_70303__$1 = state_70303;
var statearr_70306_70366 = state_70303__$1;
(statearr_70306_70366[(2)] = null);

(statearr_70306_70366[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70304 === (24))){
var inst_70229 = (state_70303[(9)]);
var inst_70270 = (state_70303[(10)]);
var inst_70272 = fluree.db.permissions.permission_map(inst_70229,inst_70270,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_70303__$1 = state_70303;
var statearr_70307_70367 = state_70303__$1;
(statearr_70307_70367[(2)] = inst_70272);

(statearr_70307_70367[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70304 === (4))){
var inst_70217 = (state_70303[(2)]);
var inst_70218 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_70217);
var inst_70219 = cljs.core.async.close_BANG_(pc);
var state_70303__$1 = (function (){var statearr_70308 = state_70303;
(statearr_70308[(11)] = inst_70218);

return statearr_70308;
})();
var statearr_70309_70368 = state_70303__$1;
(statearr_70309_70368[(2)] = inst_70219);

(statearr_70309_70368[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70304 === (15))){
var inst_70234 = (state_70303[(7)]);
var inst_70248 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70234)," unknown."].join('');
var inst_70249 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70250 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_70251 = cljs.core.PersistentHashMap.fromArrays(inst_70249,inst_70250);
var inst_70252 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_70248,inst_70251);
var inst_70253 = (function(){throw inst_70252})();
var state_70303__$1 = state_70303;
var statearr_70310_70369 = state_70303__$1;
(statearr_70310_70369[(2)] = inst_70253);

(statearr_70310_70369[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70304 === (21))){
var state_70303__$1 = state_70303;
var statearr_70311_70370 = state_70303__$1;
(statearr_70311_70370[(2)] = null);

(statearr_70311_70370[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70304 === (31))){
var inst_70234 = (state_70303[(7)]);
var inst_70284 = (state_70303[(12)]);
var inst_70286 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_70284,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_70234);
var state_70303__$1 = state_70303;
var statearr_70312_70371 = state_70303__$1;
(statearr_70312_70371[(2)] = inst_70286);

(statearr_70312_70371[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70304 === (32))){
var inst_70284 = (state_70303[(12)]);
var state_70303__$1 = state_70303;
var statearr_70313_70372 = state_70303__$1;
(statearr_70313_70372[(2)] = inst_70284);

(statearr_70313_70372[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70304 === (33))){
var inst_70270 = (state_70303[(10)]);
var inst_70289 = (state_70303[(2)]);
var state_70303__$1 = (function (){var statearr_70314 = state_70303;
(statearr_70314[(13)] = inst_70289);

return statearr_70314;
})();
if(cljs.core.truth_(inst_70270)){
var statearr_70315_70373 = state_70303__$1;
(statearr_70315_70373[(1)] = (34));

} else {
var statearr_70316_70374 = state_70303__$1;
(statearr_70316_70374[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70304 === (13))){
var inst_70245 = (state_70303[(14)]);
var inst_70244 = (state_70303[(2)]);
var inst_70245__$1 = fluree.db.util.async.throw_err(inst_70244);
var state_70303__$1 = (function (){var statearr_70317 = state_70303;
(statearr_70317[(14)] = inst_70245__$1);

return statearr_70317;
})();
if(cljs.core.truth_(inst_70245__$1)){
var statearr_70318_70375 = state_70303__$1;
(statearr_70318_70375[(1)] = (14));

} else {
var statearr_70319_70376 = state_70303__$1;
(statearr_70319_70376[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70304 === (22))){
var inst_70268 = (state_70303[(2)]);
var state_70303__$1 = state_70303;
var statearr_70320_70377 = state_70303__$1;
(statearr_70320_70377[(2)] = inst_70268);

(statearr_70320_70377[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70304 === (36))){
var inst_70297 = (state_70303[(2)]);
var inst_70298 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_70297);
var _ = (function (){var statearr_70321 = state_70303;
(statearr_70321[(4)] = cljs.core.rest((state_70303[(4)])));

return statearr_70321;
})();
var state_70303__$1 = state_70303;
var statearr_70322_70378 = state_70303__$1;
(statearr_70322_70378[(2)] = inst_70298);

(statearr_70322_70378[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70304 === (29))){
var inst_70234 = (state_70303[(7)]);
var inst_70284 = (state_70303[(2)]);
var state_70303__$1 = (function (){var statearr_70323 = state_70303;
(statearr_70323[(12)] = inst_70284);

return statearr_70323;
})();
if(cljs.core.truth_(inst_70234)){
var statearr_70324_70379 = state_70303__$1;
(statearr_70324_70379[(1)] = (31));

} else {
var statearr_70325_70380 = state_70303__$1;
(statearr_70325_70380[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70304 === (6))){
var inst_70234 = (state_70303[(7)]);
var inst_70228 = (state_70303[(2)]);
var inst_70229 = fluree.db.util.async.throw_err(inst_70228);
var inst_70230 = opts;
var inst_70231 = cljs.core.__destructure_map(inst_70230);
var inst_70232 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70231,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_70233 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70231,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_70234__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70231,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_70235 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70231,new cljs.core.Keyword(null,"block","block",664686210));
var state_70303__$1 = (function (){var statearr_70326 = state_70303;
(statearr_70326[(15)] = inst_70232);

(statearr_70326[(16)] = inst_70233);

(statearr_70326[(17)] = inst_70235);

(statearr_70326[(9)] = inst_70229);

(statearr_70326[(7)] = inst_70234__$1);

return statearr_70326;
})();
if(cljs.core.truth_(inst_70234__$1)){
var statearr_70327_70381 = state_70303__$1;
(statearr_70327_70381[(1)] = (7));

} else {
var statearr_70328_70382 = state_70303__$1;
(statearr_70328_70382[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70304 === (28))){
var inst_70229 = (state_70303[(9)]);
var state_70303__$1 = state_70303;
var statearr_70329_70383 = state_70303__$1;
(statearr_70329_70383[(2)] = inst_70229);

(statearr_70329_70383[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70304 === (25))){
var state_70303__$1 = state_70303;
var statearr_70330_70384 = state_70303__$1;
(statearr_70330_70384[(2)] = null);

(statearr_70330_70384[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70304 === (34))){
var inst_70275 = (state_70303[(18)]);
var state_70303__$1 = state_70303;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70303__$1,(37),inst_70275);
} else {
if((state_val_70304 === (17))){
var inst_70232 = (state_70303[(15)]);
var state_70303__$1 = state_70303;
var statearr_70331_70385 = state_70303__$1;
(statearr_70331_70385[(2)] = inst_70232);

(statearr_70331_70385[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70304 === (3))){
var inst_70301 = (state_70303[(2)]);
var state_70303__$1 = state_70303;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70303__$1,inst_70301);
} else {
if((state_val_70304 === (12))){
var inst_70232 = (state_70303[(15)]);
var inst_70258 = (state_70303[(2)]);
var state_70303__$1 = (function (){var statearr_70332 = state_70303;
(statearr_70332[(8)] = inst_70258);

return statearr_70332;
})();
if(cljs.core.truth_(inst_70232)){
var statearr_70333_70386 = state_70303__$1;
(statearr_70333_70386[(1)] = (17));

} else {
var statearr_70334_70387 = state_70303__$1;
(statearr_70334_70387[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70304 === (2))){
var _ = (function (){var statearr_70335 = state_70303;
(statearr_70335[(4)] = cljs.core.cons((5),(state_70303[(4)])));

return statearr_70335;
})();
var inst_70226 = fluree.db.session.db(conn,ledger,null);
var state_70303__$1 = state_70303;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70303__$1,(6),inst_70226);
} else {
if((state_val_70304 === (23))){
var inst_70264 = (state_70303[(2)]);
var inst_70265 = fluree.db.util.async.throw_err(inst_70264);
var state_70303__$1 = state_70303;
var statearr_70336_70388 = state_70303__$1;
(statearr_70336_70388[(2)] = inst_70265);

(statearr_70336_70388[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70304 === (35))){
var inst_70289 = (state_70303[(13)]);
var state_70303__$1 = state_70303;
var statearr_70337_70389 = state_70303__$1;
(statearr_70337_70389[(2)] = inst_70289);

(statearr_70337_70389[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70304 === (19))){
var inst_70270 = (state_70303[(10)]);
var inst_70270__$1 = (state_70303[(2)]);
var state_70303__$1 = (function (){var statearr_70338 = state_70303;
(statearr_70338[(10)] = inst_70270__$1);

return statearr_70338;
})();
if(cljs.core.truth_(inst_70270__$1)){
var statearr_70339_70390 = state_70303__$1;
(statearr_70339_70390[(1)] = (24));

} else {
var statearr_70340_70391 = state_70303__$1;
(statearr_70340_70391[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70304 === (11))){
var state_70303__$1 = state_70303;
var statearr_70342_70392 = state_70303__$1;
(statearr_70342_70392[(2)] = null);

(statearr_70342_70392[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70304 === (9))){
var inst_70240 = (state_70303[(2)]);
var state_70303__$1 = state_70303;
if(cljs.core.truth_(inst_70240)){
var statearr_70343_70393 = state_70303__$1;
(statearr_70343_70393[(1)] = (10));

} else {
var statearr_70344_70394 = state_70303__$1;
(statearr_70344_70394[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70304 === (5))){
var _ = (function (){var statearr_70345 = state_70303;
(statearr_70345[(4)] = cljs.core.rest((state_70303[(4)])));

return statearr_70345;
})();
var state_70303__$1 = state_70303;
var ex70341 = (state_70303__$1[(2)]);
var statearr_70346_70395 = state_70303__$1;
(statearr_70346_70395[(5)] = ex70341);


var statearr_70347_70396 = state_70303__$1;
(statearr_70347_70396[(1)] = (4));

(statearr_70347_70396[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70304 === (14))){
var inst_70245 = (state_70303[(14)]);
var state_70303__$1 = state_70303;
var statearr_70348_70397 = state_70303__$1;
(statearr_70348_70397[(2)] = inst_70245);

(statearr_70348_70397[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70304 === (26))){
var inst_70235 = (state_70303[(17)]);
var inst_70275 = (state_70303[(2)]);
var state_70303__$1 = (function (){var statearr_70349 = state_70303;
(statearr_70349[(18)] = inst_70275);

return statearr_70349;
})();
if(cljs.core.truth_(inst_70235)){
var statearr_70350_70398 = state_70303__$1;
(statearr_70350_70398[(1)] = (27));

} else {
var statearr_70351_70399 = state_70303__$1;
(statearr_70351_70399[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70304 === (16))){
var inst_70255 = (state_70303[(2)]);
var state_70303__$1 = state_70303;
var statearr_70352_70400 = state_70303__$1;
(statearr_70352_70400[(2)] = inst_70255);

(statearr_70352_70400[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70304 === (30))){
var inst_70280 = (state_70303[(2)]);
var inst_70281 = fluree.db.util.async.throw_err(inst_70280);
var state_70303__$1 = state_70303;
var statearr_70353_70401 = state_70303__$1;
(statearr_70353_70401[(2)] = inst_70281);

(statearr_70353_70401[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70304 === (10))){
var inst_70229 = (state_70303[(9)]);
var inst_70234 = (state_70303[(7)]);
var inst_70242 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_70229,inst_70234);
var state_70303__$1 = state_70303;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70303__$1,(13),inst_70242);
} else {
if((state_val_70304 === (18))){
var inst_70258 = (state_70303[(8)]);
var state_70303__$1 = state_70303;
if(cljs.core.truth_(inst_70258)){
var statearr_70354_70402 = state_70303__$1;
(statearr_70354_70402[(1)] = (20));

} else {
var statearr_70355_70403 = state_70303__$1;
(statearr_70355_70403[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70304 === (37))){
var inst_70289 = (state_70303[(13)]);
var inst_70292 = (state_70303[(2)]);
var inst_70293 = fluree.db.util.async.throw_err(inst_70292);
var inst_70294 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_70289,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_70293);
var state_70303__$1 = state_70303;
var statearr_70356_70404 = state_70303__$1;
(statearr_70356_70404[(2)] = inst_70294);

(statearr_70356_70404[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70304 === (8))){
var inst_70234 = (state_70303[(7)]);
var state_70303__$1 = state_70303;
var statearr_70357_70405 = state_70303__$1;
(statearr_70357_70405[(2)] = inst_70234);

(statearr_70357_70405[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__11410__auto__ = null;
var fluree$db$api$query$state_machine__11410__auto____0 = (function (){
var statearr_70358 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70358[(0)] = fluree$db$api$query$state_machine__11410__auto__);

(statearr_70358[(1)] = (1));

return statearr_70358;
});
var fluree$db$api$query$state_machine__11410__auto____1 = (function (state_70303){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_70303);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e70359){var ex__11413__auto__ = e70359;
var statearr_70360_70406 = state_70303;
(statearr_70360_70406[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_70303[(4)]))){
var statearr_70361_70407 = state_70303;
(statearr_70361_70407[(1)] = cljs.core.first((state_70303[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70408 = state_70303;
state_70303 = G__70408;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__11410__auto__ = function(state_70303){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__11410__auto____1.call(this,state_70303);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__11410__auto____0;
fluree$db$api$query$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__11410__auto____1;
return fluree$db$api$query$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_70362 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_70362[(6)] = c__11484__auto___70364);

return statearr_70362;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_(val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_70549){
var state_val_70550 = (state_70549[(1)]);
if((state_val_70550 === (7))){
var inst_70429 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70430 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_70431 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_70432 = [inst_70430,inst_70431];
var inst_70433 = (new cljs.core.PersistentVector(null,2,(5),inst_70429,inst_70432,null));
var state_70549__$1 = state_70549;
var statearr_70551_70621 = state_70549__$1;
(statearr_70551_70621[(2)] = inst_70433);

(statearr_70551_70621[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (20))){
var inst_70459 = (state_70549[(7)]);
var state_70549__$1 = state_70549;
var statearr_70552_70622 = state_70549__$1;
(statearr_70552_70622[(2)] = inst_70459);

(statearr_70552_70622[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (27))){
var state_70549__$1 = state_70549;
var statearr_70553_70623 = state_70549__$1;
(statearr_70553_70623[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (1))){
var state_70549__$1 = state_70549;
var statearr_70555_70624 = state_70549__$1;
(statearr_70555_70624[(2)] = null);

(statearr_70555_70624[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (24))){
var inst_70458 = (state_70549[(8)]);
var state_70549__$1 = state_70549;
if(cljs.core.truth_(inst_70458)){
var statearr_70556_70625 = state_70549__$1;
(statearr_70556_70625[(1)] = (26));

} else {
var statearr_70557_70626 = state_70549__$1;
(statearr_70557_70626[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (39))){
var inst_70504 = (state_70549[(9)]);
var inst_70505 = (state_70549[(10)]);
var inst_70530 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70531 = [inst_70504,inst_70505];
var inst_70532 = (new cljs.core.PersistentVector(null,2,(5),inst_70530,inst_70531,null));
var state_70549__$1 = state_70549;
var statearr_70558_70627 = state_70549__$1;
(statearr_70558_70627[(2)] = inst_70532);

(statearr_70558_70627[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (4))){
var inst_70409 = (state_70549[(2)]);
var state_70549__$1 = state_70549;
var statearr_70559_70628 = state_70549__$1;
(statearr_70559_70628[(2)] = inst_70409);

(statearr_70559_70628[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (15))){
var inst_70438 = (state_70549[(11)]);
var inst_70443 = (state_70549[(12)]);
var inst_70452 = (state_70549[(2)]);
var inst_70453 = [inst_70443,inst_70452];
var inst_70454 = (new cljs.core.PersistentVector(null,2,(5),inst_70438,inst_70453,null));
var state_70549__$1 = state_70549;
var statearr_70560_70629 = state_70549__$1;
(statearr_70560_70629[(2)] = inst_70454);

(statearr_70560_70629[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (21))){
var inst_70458 = (state_70549[(8)]);
var state_70549__$1 = state_70549;
var statearr_70561_70630 = state_70549__$1;
(statearr_70561_70630[(2)] = inst_70458);

(statearr_70561_70630[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (31))){
var inst_70499 = (state_70549[(2)]);
var state_70549__$1 = state_70549;
var statearr_70562_70631 = state_70549__$1;
(statearr_70562_70631[(2)] = inst_70499);

(statearr_70562_70631[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (32))){
var inst_70505 = (state_70549[(10)]);
var inst_70508 = cljs.core.pos_int_QMARK_(inst_70505);
var state_70549__$1 = state_70549;
var statearr_70563_70632 = state_70549__$1;
(statearr_70563_70632[(2)] = inst_70508);

(statearr_70563_70632[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (40))){
var inst_70536 = (state_70549[(13)]);
var inst_70460 = (state_70549[(14)]);
var inst_70534 = (state_70549[(2)]);
var inst_70535 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70534,(0),null);
var inst_70536__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70534,(1),null);
var inst_70537 = (inst_70536__$1 > inst_70460);
var state_70549__$1 = (function (){var statearr_70564 = state_70549;
(statearr_70564[(13)] = inst_70536__$1);

(statearr_70564[(15)] = inst_70535);

return statearr_70564;
})();
if(cljs.core.truth_(inst_70537)){
var statearr_70565_70633 = state_70549__$1;
(statearr_70565_70633[(1)] = (41));

} else {
var statearr_70566_70634 = state_70549__$1;
(statearr_70566_70634[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (33))){
var inst_70506 = (state_70549[(16)]);
var state_70549__$1 = state_70549;
var statearr_70567_70635 = state_70549__$1;
(statearr_70567_70635[(2)] = inst_70506);

(statearr_70567_70635[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (13))){
var inst_70444 = (state_70549[(17)]);
var inst_70446 = fluree.db.time_travel.block_to_int_format(db,inst_70444);
var state_70549__$1 = state_70549;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70549__$1,(16),inst_70446);
} else {
if((state_val_70550 === (22))){
var inst_70477 = (state_70549[(2)]);
var state_70549__$1 = state_70549;
if(cljs.core.truth_(inst_70477)){
var statearr_70568_70636 = state_70549__$1;
(statearr_70568_70636[(1)] = (23));

} else {
var statearr_70569_70637 = state_70549__$1;
(statearr_70569_70637[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (36))){
var state_70549__$1 = state_70549;
var statearr_70570_70638 = state_70549__$1;
(statearr_70570_70638[(2)] = null);

(statearr_70570_70638[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (41))){
var inst_70460 = (state_70549[(14)]);
var state_70549__$1 = state_70549;
var statearr_70571_70639 = state_70549__$1;
(statearr_70571_70639[(2)] = inst_70460);

(statearr_70571_70639[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (43))){
var inst_70535 = (state_70549[(15)]);
var inst_70541 = (state_70549[(2)]);
var inst_70542 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70543 = [inst_70535,inst_70541];
var inst_70544 = (new cljs.core.PersistentVector(null,2,(5),inst_70542,inst_70543,null));
var _ = (function (){var statearr_70572 = state_70549;
(statearr_70572[(4)] = cljs.core.rest((state_70549[(4)])));

return statearr_70572;
})();
var state_70549__$1 = state_70549;
var statearr_70573_70640 = state_70549__$1;
(statearr_70573_70640[(2)] = inst_70544);

(statearr_70573_70640[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (29))){
var inst_70435 = (state_70549[(18)]);
var inst_70490 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_70435], 0));
var inst_70491 = ["Invalid block range provided: ",inst_70490].join('');
var inst_70492 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70493 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70494 = cljs.core.PersistentHashMap.fromArrays(inst_70492,inst_70493);
var inst_70495 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_70491,inst_70494);
var inst_70496 = (function(){throw inst_70495})();
var state_70549__$1 = state_70549;
var statearr_70574_70641 = state_70549__$1;
(statearr_70574_70641[(2)] = inst_70496);

(statearr_70574_70641[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (6))){
var inst_70427 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_70549__$1 = state_70549;
var statearr_70575_70642 = state_70549__$1;
(statearr_70575_70642[(2)] = inst_70427);

(statearr_70575_70642[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (28))){
var inst_70501 = (state_70549[(2)]);
var state_70549__$1 = state_70549;
var statearr_70576_70643 = state_70549__$1;
(statearr_70576_70643[(2)] = inst_70501);

(statearr_70576_70643[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (25))){
var inst_70504 = (state_70549[(9)]);
var inst_70506 = (state_70549[(16)]);
var inst_70503 = (state_70549[(2)]);
var inst_70504__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70503,(0),null);
var inst_70505 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70503,(1),null);
var inst_70506__$1 = cljs.core.pos_int_QMARK_(inst_70504__$1);
var state_70549__$1 = (function (){var statearr_70577 = state_70549;
(statearr_70577[(9)] = inst_70504__$1);

(statearr_70577[(16)] = inst_70506__$1);

(statearr_70577[(10)] = inst_70505);

return statearr_70577;
})();
if(inst_70506__$1){
var statearr_70578_70644 = state_70549__$1;
(statearr_70578_70644[(1)] = (32));

} else {
var statearr_70579_70645 = state_70549__$1;
(statearr_70579_70645[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (34))){
var inst_70511 = (state_70549[(2)]);
var inst_70512 = cljs.core.not(inst_70511);
var state_70549__$1 = state_70549;
if(inst_70512){
var statearr_70580_70646 = state_70549__$1;
(statearr_70580_70646[(1)] = (35));

} else {
var statearr_70581_70647 = state_70549__$1;
(statearr_70581_70647[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (17))){
var inst_70458 = (state_70549[(8)]);
var inst_70460 = (state_70549[(14)]);
var inst_70463 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_70458], 0));
var inst_70464 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_70460], 0));
var inst_70465 = ["Start block is out of range for this ledger. Start block provided: ",inst_70463,". Database block: ",inst_70464].join('');
var inst_70466 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70467 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70468 = cljs.core.PersistentHashMap.fromArrays(inst_70466,inst_70467);
var inst_70469 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_70465,inst_70468);
var inst_70470 = (function(){throw inst_70469})();
var state_70549__$1 = state_70549;
var statearr_70582_70648 = state_70549__$1;
(statearr_70582_70648[(2)] = inst_70470);

(statearr_70582_70648[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (3))){
var inst_70547 = (state_70549[(2)]);
var state_70549__$1 = state_70549;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70549__$1,inst_70547);
} else {
if((state_val_70550 === (12))){
var inst_70444 = (state_70549[(17)]);
var inst_70435 = (state_70549[(18)]);
var inst_70442 = (state_70549[(2)]);
var inst_70443 = fluree.db.util.async.throw_err(inst_70442);
var inst_70444__$1 = cljs.core.second(inst_70435);
var state_70549__$1 = (function (){var statearr_70583 = state_70549;
(statearr_70583[(17)] = inst_70444__$1);

(statearr_70583[(12)] = inst_70443);

return statearr_70583;
})();
if(cljs.core.truth_(inst_70444__$1)){
var statearr_70584_70649 = state_70549__$1;
(statearr_70584_70649[(1)] = (13));

} else {
var statearr_70585_70650 = state_70549__$1;
(statearr_70585_70650[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (2))){
var _ = (function (){var statearr_70586 = state_70549;
(statearr_70586[(4)] = cljs.core.cons((5),(state_70549[(4)])));

return statearr_70586;
})();
var inst_70424 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_70425 = cljs.core.sequential_QMARK_(inst_70424);
var state_70549__$1 = state_70549;
if(inst_70425){
var statearr_70587_70651 = state_70549__$1;
(statearr_70587_70651[(1)] = (6));

} else {
var statearr_70588_70652 = state_70549__$1;
(statearr_70588_70652[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (23))){
var inst_70458 = (state_70549[(8)]);
var inst_70459 = (state_70549[(7)]);
var inst_70479 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70480 = [inst_70458,inst_70459];
var inst_70481 = (new cljs.core.PersistentVector(null,2,(5),inst_70479,inst_70480,null));
var state_70549__$1 = state_70549;
var statearr_70589_70653 = state_70549__$1;
(statearr_70589_70653[(2)] = inst_70481);

(statearr_70589_70653[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (35))){
var inst_70435 = (state_70549[(18)]);
var inst_70514 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_70435], 0));
var inst_70515 = ["Invalid block range provided: ",inst_70514].join('');
var inst_70516 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70517 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70518 = cljs.core.PersistentHashMap.fromArrays(inst_70516,inst_70517);
var inst_70519 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_70515,inst_70518);
var inst_70520 = (function(){throw inst_70519})();
var state_70549__$1 = state_70549;
var statearr_70590_70654 = state_70549__$1;
(statearr_70590_70654[(2)] = inst_70520);

(statearr_70590_70654[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (19))){
var inst_70458 = (state_70549[(8)]);
var inst_70473 = (state_70549[(2)]);
var state_70549__$1 = (function (){var statearr_70591 = state_70549;
(statearr_70591[(19)] = inst_70473);

return statearr_70591;
})();
if(cljs.core.truth_(inst_70458)){
var statearr_70592_70655 = state_70549__$1;
(statearr_70592_70655[(1)] = (20));

} else {
var statearr_70593_70656 = state_70549__$1;
(statearr_70593_70656[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (11))){
var inst_70458 = (state_70549[(8)]);
var inst_70460 = (state_70549[(14)]);
var inst_70457 = (state_70549[(2)]);
var inst_70458__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70457,(0),null);
var inst_70459 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70457,(1),null);
var inst_70460__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_70461 = (inst_70458__$1 > inst_70460__$1);
var state_70549__$1 = (function (){var statearr_70595 = state_70549;
(statearr_70595[(8)] = inst_70458__$1);

(statearr_70595[(7)] = inst_70459);

(statearr_70595[(14)] = inst_70460__$1);

return statearr_70595;
})();
if(cljs.core.truth_(inst_70461)){
var statearr_70596_70657 = state_70549__$1;
(statearr_70596_70657[(1)] = (17));

} else {
var statearr_70597_70658 = state_70549__$1;
(statearr_70597_70658[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (9))){
var inst_70435 = (state_70549[(18)]);
var inst_70438 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70439 = cljs.core.first(inst_70435);
var inst_70440 = fluree.db.time_travel.block_to_int_format(db,inst_70439);
var state_70549__$1 = (function (){var statearr_70598 = state_70549;
(statearr_70598[(11)] = inst_70438);

return statearr_70598;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70549__$1,(12),inst_70440);
} else {
if((state_val_70550 === (5))){
var _ = (function (){var statearr_70599 = state_70549;
(statearr_70599[(4)] = cljs.core.rest((state_70549[(4)])));

return statearr_70599;
})();
var state_70549__$1 = state_70549;
var ex70594 = (state_70549__$1[(2)]);
var statearr_70600_70659 = state_70549__$1;
(statearr_70600_70659[(5)] = ex70594);


if((ex70594 instanceof Error)){
var statearr_70601_70660 = state_70549__$1;
(statearr_70601_70660[(1)] = (4));

(statearr_70601_70660[(5)] = null);

} else {
throw ex70594;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (14))){
var state_70549__$1 = state_70549;
var statearr_70602_70661 = state_70549__$1;
(statearr_70602_70661[(2)] = null);

(statearr_70602_70661[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (26))){
var inst_70458 = (state_70549[(8)]);
var inst_70484 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70485 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_70486 = [inst_70458,inst_70485];
var inst_70487 = (new cljs.core.PersistentVector(null,2,(5),inst_70484,inst_70486,null));
var state_70549__$1 = state_70549;
var statearr_70603_70662 = state_70549__$1;
(statearr_70603_70662[(2)] = inst_70487);

(statearr_70603_70662[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (16))){
var inst_70448 = (state_70549[(2)]);
var inst_70449 = fluree.db.util.async.throw_err(inst_70448);
var state_70549__$1 = state_70549;
var statearr_70604_70663 = state_70549__$1;
(statearr_70604_70663[(2)] = inst_70449);

(statearr_70604_70663[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (38))){
var inst_70504 = (state_70549[(9)]);
var inst_70505 = (state_70549[(10)]);
var inst_70526 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70527 = [inst_70505,inst_70504];
var inst_70528 = (new cljs.core.PersistentVector(null,2,(5),inst_70526,inst_70527,null));
var state_70549__$1 = state_70549;
var statearr_70605_70664 = state_70549__$1;
(statearr_70605_70664[(2)] = inst_70528);

(statearr_70605_70664[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (30))){
var state_70549__$1 = state_70549;
var statearr_70606_70665 = state_70549__$1;
(statearr_70606_70665[(2)] = null);

(statearr_70606_70665[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (10))){
var inst_70435 = (state_70549[(18)]);
var state_70549__$1 = state_70549;
var statearr_70607_70666 = state_70549__$1;
(statearr_70607_70666[(2)] = inst_70435);

(statearr_70607_70666[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (18))){
var state_70549__$1 = state_70549;
var statearr_70608_70667 = state_70549__$1;
(statearr_70608_70667[(2)] = null);

(statearr_70608_70667[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (42))){
var inst_70536 = (state_70549[(13)]);
var state_70549__$1 = state_70549;
var statearr_70609_70668 = state_70549__$1;
(statearr_70609_70668[(2)] = inst_70536);

(statearr_70609_70668[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (37))){
var inst_70504 = (state_70549[(9)]);
var inst_70505 = (state_70549[(10)]);
var inst_70523 = (state_70549[(2)]);
var inst_70524 = (inst_70505 < inst_70504);
var state_70549__$1 = (function (){var statearr_70610 = state_70549;
(statearr_70610[(20)] = inst_70523);

return statearr_70610;
})();
if(cljs.core.truth_(inst_70524)){
var statearr_70611_70669 = state_70549__$1;
(statearr_70611_70669[(1)] = (38));

} else {
var statearr_70612_70670 = state_70549__$1;
(statearr_70612_70670[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70550 === (8))){
var inst_70435 = (state_70549[(18)]);
var inst_70435__$1 = (state_70549[(2)]);
var inst_70436 = cljs.core.some(cljs.core.string_QMARK_,inst_70435__$1);
var state_70549__$1 = (function (){var statearr_70613 = state_70549;
(statearr_70613[(18)] = inst_70435__$1);

return statearr_70613;
})();
if(cljs.core.truth_(inst_70436)){
var statearr_70614_70671 = state_70549__$1;
(statearr_70614_70671[(1)] = (9));

} else {
var statearr_70615_70672 = state_70549__$1;
(statearr_70615_70672[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__11410__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__11410__auto____0 = (function (){
var statearr_70616 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70616[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__11410__auto__);

(statearr_70616[(1)] = (1));

return statearr_70616;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__11410__auto____1 = (function (state_70549){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_70549);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e70617){var ex__11413__auto__ = e70617;
var statearr_70618_70673 = state_70549;
(statearr_70618_70673[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_70549[(4)]))){
var statearr_70619_70674 = state_70549;
(statearr_70619_70674[(1)] = cljs.core.first((state_70549[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70675 = state_70549;
state_70549 = G__70675;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__11410__auto__ = function(state_70549){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__11410__auto____1.call(this,state_70549);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__11410__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__11410__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_70620 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_70620[(6)] = c__11484__auto__);

return statearr_70620;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_70825){
var state_val_70826 = (state_70825[(1)]);
if((state_val_70826 === (7))){
var inst_70737 = (state_70825[(2)]);
var inst_70738 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70737,(0),null);
var inst_70739 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70737,(1),null);
var inst_70747 = cljs.core.vals(inst_70739);
var inst_70748 = cljs.core.seq(inst_70747);
var inst_70749 = cljs.core.first(inst_70748);
var inst_70750 = cljs.core.next(inst_70748);
var inst_70751 = cljs.core.PersistentVector.EMPTY;
var inst_70752 = inst_70747;
var inst_70753 = inst_70751;
var state_70825__$1 = (function (){var statearr_70827 = state_70825;
(statearr_70827[(7)] = inst_70750);

(statearr_70827[(8)] = inst_70749);

(statearr_70827[(9)] = inst_70753);

(statearr_70827[(10)] = inst_70738);

(statearr_70827[(11)] = inst_70752);

return statearr_70827;
})();
var statearr_70828_70881 = state_70825__$1;
(statearr_70828_70881[(2)] = null);

(statearr_70828_70881[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70826 === (20))){
var inst_70759 = (state_70825[(12)]);
var inst_70764 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_70765 = cljs.core.PersistentHashMap.EMPTY;
var inst_70766 = [true,inst_70765];
var inst_70767 = cljs.core.PersistentHashMap.fromArrays(inst_70764,inst_70766);
var inst_70768 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_70767,inst_70759);
var state_70825__$1 = state_70825;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70825__$1,(22),inst_70768);
} else {
if((state_val_70826 === (27))){
var inst_70813 = (state_70825[(2)]);
var state_70825__$1 = state_70825;
var statearr_70829_70882 = state_70825__$1;
(statearr_70829_70882[(2)] = inst_70813);

(statearr_70829_70882[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70826 === (1))){
var state_70825__$1 = state_70825;
var statearr_70830_70883 = state_70825__$1;
(statearr_70830_70883[(2)] = null);

(statearr_70830_70883[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70826 === (24))){
var inst_70777 = (state_70825[(13)]);
var inst_70815 = (state_70825[(2)]);
var inst_70816 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_70817 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_70818 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_70819 = [inst_70817,inst_70818,inst_70777,inst_70815];
var inst_70820 = cljs.core.PersistentHashMap.fromArrays(inst_70816,inst_70819);
var _ = (function (){var statearr_70832 = state_70825;
(statearr_70832[(4)] = cljs.core.rest((state_70825[(4)])));

return statearr_70832;
})();
var state_70825__$1 = state_70825;
var statearr_70833_70884 = state_70825__$1;
(statearr_70833_70884[(2)] = inst_70820);

(statearr_70833_70884[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70826 === (4))){
var inst_70678 = (state_70825[(2)]);
var state_70825__$1 = state_70825;
var statearr_70834_70885 = state_70825__$1;
(statearr_70834_70885[(2)] = inst_70678);

(statearr_70834_70885[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70826 === (15))){
var inst_70696 = (state_70825[(14)]);
var inst_70709 = (state_70825[(15)]);
var inst_70718 = (state_70825[(16)]);
var inst_70702 = (state_70825[(17)]);
var inst_70700 = (state_70825[(18)]);
var inst_70697 = (state_70825[(19)]);
var inst_70701 = (state_70825[(20)]);
var inst_70708 = (state_70825[(21)]);
var inst_70716 = (state_70825[(22)]);
var inst_70694 = (state_70825[(23)]);
var inst_70723 = (state_70825[(24)]);
var inst_70729 = (function (){var vec__70691 = inst_70694;
var subject = inst_70716;
var flake = inst_70708;
var seq__70705 = inst_70709;
var G__70690 = inst_70700;
var seq__70692 = inst_70697;
var r = inst_70709;
var asserted_subjects = inst_70701;
var flake_SINGLEQUOTE_ = inst_70723;
var retracted_subjects = inst_70702;
var first__70706 = inst_70708;
var asserted_QMARK_ = inst_70718;
var first__70693 = inst_70696;
var vec__70704 = inst_70700;
return (function (p1__70677_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__70677_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_70730 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_70702,inst_70716,inst_70729);
var tmp70831 = inst_70701;
var inst_70700__$1 = inst_70709;
var inst_70701__$1 = tmp70831;
var inst_70702__$1 = inst_70730;
var state_70825__$1 = (function (){var statearr_70835 = state_70825;
(statearr_70835[(17)] = inst_70702__$1);

(statearr_70835[(18)] = inst_70700__$1);

(statearr_70835[(20)] = inst_70701__$1);

return statearr_70835;
})();
var statearr_70836_70886 = state_70825__$1;
(statearr_70836_70886[(2)] = null);

(statearr_70836_70886[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70826 === (21))){
var inst_70775 = (state_70825[(2)]);
var state_70825__$1 = state_70825;
var statearr_70837_70887 = state_70825__$1;
(statearr_70837_70887[(2)] = inst_70775);

(statearr_70837_70887[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70826 === (13))){
var inst_70718 = (state_70825[(16)]);
var inst_70723 = (state_70825[(2)]);
var state_70825__$1 = (function (){var statearr_70838 = state_70825;
(statearr_70838[(24)] = inst_70723);

return statearr_70838;
})();
if(cljs.core.truth_(inst_70718)){
var statearr_70839_70888 = state_70825__$1;
(statearr_70839_70888[(1)] = (14));

} else {
var statearr_70840_70889 = state_70825__$1;
(statearr_70840_70889[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70826 === (22))){
var inst_70753 = (state_70825[(9)]);
var inst_70760 = (state_70825[(25)]);
var inst_70770 = (state_70825[(2)]);
var inst_70771 = fluree.db.util.async.throw_err(inst_70770);
var inst_70772 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_70753,inst_70771);
var inst_70752 = inst_70760;
var inst_70753__$1 = inst_70772;
var state_70825__$1 = (function (){var statearr_70841 = state_70825;
(statearr_70841[(9)] = inst_70753__$1);

(statearr_70841[(11)] = inst_70752);

return statearr_70841;
})();
var statearr_70842_70890 = state_70825__$1;
(statearr_70842_70890[(2)] = null);

(statearr_70842_70890[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70826 === (6))){
var inst_70700 = (state_70825[(18)]);
var inst_70708 = (state_70825[(21)]);
var inst_70707 = cljs.core.seq(inst_70700);
var inst_70708__$1 = cljs.core.first(inst_70707);
var inst_70709 = cljs.core.next(inst_70707);
var inst_70710 = cljs.core.not(inst_70708__$1);
var state_70825__$1 = (function (){var statearr_70843 = state_70825;
(statearr_70843[(15)] = inst_70709);

(statearr_70843[(21)] = inst_70708__$1);

return statearr_70843;
})();
if(inst_70710){
var statearr_70844_70891 = state_70825__$1;
(statearr_70844_70891[(1)] = (8));

} else {
var statearr_70845_70892 = state_70825__$1;
(statearr_70845_70892[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70826 === (28))){
var inst_70791 = (state_70825[(26)]);
var inst_70798 = (state_70825[(27)]);
var inst_70808 = (state_70825[(2)]);
var inst_70809 = fluree.db.util.async.throw_err(inst_70808);
var inst_70810 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_70791,inst_70809);
var inst_70790 = inst_70798;
var inst_70791__$1 = inst_70810;
var state_70825__$1 = (function (){var statearr_70846 = state_70825;
(statearr_70846[(28)] = inst_70790);

(statearr_70846[(26)] = inst_70791__$1);

return statearr_70846;
})();
var statearr_70847_70893 = state_70825__$1;
(statearr_70847_70893[(2)] = null);

(statearr_70847_70893[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70826 === (25))){
var inst_70791 = (state_70825[(26)]);
var state_70825__$1 = state_70825;
var statearr_70848_70894 = state_70825__$1;
(statearr_70848_70894[(2)] = inst_70791);

(statearr_70848_70894[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70826 === (17))){
var inst_70759 = (state_70825[(12)]);
var inst_70752 = (state_70825[(11)]);
var inst_70758 = cljs.core.seq(inst_70752);
var inst_70759__$1 = cljs.core.first(inst_70758);
var inst_70760 = cljs.core.next(inst_70758);
var inst_70761 = cljs.core.not(inst_70759__$1);
var state_70825__$1 = (function (){var statearr_70849 = state_70825;
(statearr_70849[(12)] = inst_70759__$1);

(statearr_70849[(25)] = inst_70760);

return statearr_70849;
})();
if(inst_70761){
var statearr_70850_70895 = state_70825__$1;
(statearr_70850_70895[(1)] = (19));

} else {
var statearr_70851_70896 = state_70825__$1;
(statearr_70851_70896[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70826 === (3))){
var inst_70823 = (state_70825[(2)]);
var state_70825__$1 = state_70825;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70825__$1,inst_70823);
} else {
if((state_val_70826 === (12))){
var inst_70708 = (state_70825[(21)]);
var inst_70721 = fluree.db.flake.flip_flake.cljs$core$IFn$_invoke$arity$1(inst_70708);
var state_70825__$1 = state_70825;
var statearr_70852_70897 = state_70825__$1;
(statearr_70852_70897[(2)] = inst_70721);

(statearr_70852_70897[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70826 === (2))){
var inst_70694 = (state_70825[(23)]);
var _ = (function (){var statearr_70853 = state_70825;
(statearr_70853[(4)] = cljs.core.cons((5),(state_70825[(4)])));

return statearr_70853;
})();
var inst_70694__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_70695 = cljs.core.seq(inst_70694__$1);
var inst_70696 = cljs.core.first(inst_70695);
var inst_70697 = cljs.core.next(inst_70695);
var inst_70698 = cljs.core.PersistentHashMap.EMPTY;
var inst_70699 = cljs.core.PersistentHashMap.EMPTY;
var inst_70700 = inst_70694__$1;
var inst_70701 = inst_70698;
var inst_70702 = inst_70699;
var state_70825__$1 = (function (){var statearr_70854 = state_70825;
(statearr_70854[(14)] = inst_70696);

(statearr_70854[(17)] = inst_70702);

(statearr_70854[(18)] = inst_70700);

(statearr_70854[(19)] = inst_70697);

(statearr_70854[(20)] = inst_70701);

(statearr_70854[(23)] = inst_70694__$1);

return statearr_70854;
})();
var statearr_70855_70898 = state_70825__$1;
(statearr_70855_70898[(2)] = null);

(statearr_70855_70898[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70826 === (23))){
var inst_70790 = (state_70825[(28)]);
var inst_70797 = (state_70825[(29)]);
var inst_70796 = cljs.core.seq(inst_70790);
var inst_70797__$1 = cljs.core.first(inst_70796);
var inst_70798 = cljs.core.next(inst_70796);
var inst_70799 = cljs.core.not(inst_70797__$1);
var state_70825__$1 = (function (){var statearr_70856 = state_70825;
(statearr_70856[(29)] = inst_70797__$1);

(statearr_70856[(27)] = inst_70798);

return statearr_70856;
})();
if(inst_70799){
var statearr_70857_70899 = state_70825__$1;
(statearr_70857_70899[(1)] = (25));

} else {
var statearr_70858_70900 = state_70825__$1;
(statearr_70858_70900[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70826 === (19))){
var inst_70753 = (state_70825[(9)]);
var state_70825__$1 = state_70825;
var statearr_70859_70901 = state_70825__$1;
(statearr_70859_70901[(2)] = inst_70753);

(statearr_70859_70901[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70826 === (11))){
var inst_70708 = (state_70825[(21)]);
var state_70825__$1 = state_70825;
var statearr_70861_70902 = state_70825__$1;
(statearr_70861_70902[(2)] = inst_70708);

(statearr_70861_70902[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70826 === (9))){
var inst_70718 = (state_70825[(16)]);
var inst_70708 = (state_70825[(21)]);
var inst_70716 = inst_70708.s;
var inst_70717 = inst_70708.op;
var inst_70718__$1 = inst_70717 === true;
var state_70825__$1 = (function (){var statearr_70863 = state_70825;
(statearr_70863[(16)] = inst_70718__$1);

(statearr_70863[(22)] = inst_70716);

return statearr_70863;
})();
if(cljs.core.truth_(inst_70718__$1)){
var statearr_70864_70903 = state_70825__$1;
(statearr_70864_70903[(1)] = (11));

} else {
var statearr_70865_70904 = state_70825__$1;
(statearr_70865_70904[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70826 === (5))){
var _ = (function (){var statearr_70866 = state_70825;
(statearr_70866[(4)] = cljs.core.rest((state_70825[(4)])));

return statearr_70866;
})();
var state_70825__$1 = state_70825;
var ex70860 = (state_70825__$1[(2)]);
var statearr_70867_70905 = state_70825__$1;
(statearr_70867_70905[(5)] = ex70860);


if((ex70860 instanceof Error)){
var statearr_70868_70906 = state_70825__$1;
(statearr_70868_70906[(1)] = (4));

(statearr_70868_70906[(5)] = null);

} else {
throw ex70860;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70826 === (14))){
var inst_70696 = (state_70825[(14)]);
var inst_70709 = (state_70825[(15)]);
var inst_70718 = (state_70825[(16)]);
var inst_70702 = (state_70825[(17)]);
var inst_70700 = (state_70825[(18)]);
var inst_70697 = (state_70825[(19)]);
var inst_70701 = (state_70825[(20)]);
var inst_70708 = (state_70825[(21)]);
var inst_70716 = (state_70825[(22)]);
var inst_70694 = (state_70825[(23)]);
var inst_70723 = (state_70825[(24)]);
var inst_70725 = (function (){var vec__70691 = inst_70694;
var subject = inst_70716;
var flake = inst_70708;
var seq__70705 = inst_70709;
var G__70690 = inst_70700;
var seq__70692 = inst_70697;
var r = inst_70709;
var asserted_subjects = inst_70701;
var flake_SINGLEQUOTE_ = inst_70723;
var retracted_subjects = inst_70702;
var first__70706 = inst_70708;
var asserted_QMARK_ = inst_70718;
var first__70693 = inst_70696;
var vec__70704 = inst_70700;
return (function (p1__70676_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__70676_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_70726 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_70701,inst_70716,inst_70725);
var tmp70862 = inst_70702;
var inst_70700__$1 = inst_70709;
var inst_70701__$1 = inst_70726;
var inst_70702__$1 = tmp70862;
var state_70825__$1 = (function (){var statearr_70869 = state_70825;
(statearr_70869[(17)] = inst_70702__$1);

(statearr_70869[(18)] = inst_70700__$1);

(statearr_70869[(20)] = inst_70701__$1);

return statearr_70869;
})();
var statearr_70870_70907 = state_70825__$1;
(statearr_70870_70907[(2)] = null);

(statearr_70870_70907[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70826 === (26))){
var inst_70797 = (state_70825[(29)]);
var inst_70802 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_70803 = cljs.core.PersistentHashMap.EMPTY;
var inst_70804 = [true,inst_70803];
var inst_70805 = cljs.core.PersistentHashMap.fromArrays(inst_70802,inst_70804);
var inst_70806 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_70805,inst_70797);
var state_70825__$1 = state_70825;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70825__$1,(28),inst_70806);
} else {
if((state_val_70826 === (16))){
var inst_70733 = (state_70825[(2)]);
var state_70825__$1 = state_70825;
var statearr_70871_70908 = state_70825__$1;
(statearr_70871_70908[(2)] = inst_70733);

(statearr_70871_70908[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70826 === (10))){
var inst_70735 = (state_70825[(2)]);
var state_70825__$1 = state_70825;
var statearr_70872_70909 = state_70825__$1;
(statearr_70872_70909[(2)] = inst_70735);

(statearr_70872_70909[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70826 === (18))){
var inst_70738 = (state_70825[(10)]);
var inst_70777 = (state_70825[(2)]);
var inst_70785 = cljs.core.vals(inst_70738);
var inst_70786 = cljs.core.seq(inst_70785);
var inst_70787 = cljs.core.first(inst_70786);
var inst_70788 = cljs.core.next(inst_70786);
var inst_70789 = cljs.core.PersistentVector.EMPTY;
var inst_70790 = inst_70785;
var inst_70791 = inst_70789;
var state_70825__$1 = (function (){var statearr_70873 = state_70825;
(statearr_70873[(28)] = inst_70790);

(statearr_70873[(30)] = inst_70788);

(statearr_70873[(31)] = inst_70787);

(statearr_70873[(13)] = inst_70777);

(statearr_70873[(26)] = inst_70791);

return statearr_70873;
})();
var statearr_70874_70910 = state_70825__$1;
(statearr_70874_70910[(2)] = null);

(statearr_70874_70910[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70826 === (8))){
var inst_70702 = (state_70825[(17)]);
var inst_70701 = (state_70825[(20)]);
var inst_70712 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70713 = [inst_70701,inst_70702];
var inst_70714 = (new cljs.core.PersistentVector(null,2,(5),inst_70712,inst_70713,null));
var state_70825__$1 = state_70825;
var statearr_70875_70911 = state_70825__$1;
(statearr_70875_70911[(2)] = inst_70714);

(statearr_70875_70911[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__11410__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__11410__auto____0 = (function (){
var statearr_70876 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70876[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__11410__auto__);

(statearr_70876[(1)] = (1));

return statearr_70876;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__11410__auto____1 = (function (state_70825){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_70825);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e70877){var ex__11413__auto__ = e70877;
var statearr_70878_70912 = state_70825;
(statearr_70878_70912[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_70825[(4)]))){
var statearr_70879_70913 = state_70825;
(statearr_70879_70913[(1)] = cljs.core.first((state_70825[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70914 = state_70825;
state_70825 = G__70914;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__11410__auto__ = function(state_70825){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__11410__auto____1.call(this,state_70825);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__11410__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__11410__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_70880 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_70880[(6)] = c__11484__auto__);

return statearr_70880;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_70946){
var state_val_70947 = (state_70946[(1)]);
if((state_val_70947 === (1))){
var inst_70915 = cljs.core.volatile_BANG_((0));
var inst_70916 = cljs.core.PersistentHashMap.EMPTY;
var inst_70917 = cljs.core.volatile_BANG_(inst_70916);
var inst_70918 = cljs.core.first(resp);
var inst_70919 = cljs.core.rest(resp);
var inst_70920 = cljs.core.PersistentVector.EMPTY;
var inst_70921 = inst_70915;
var inst_70922 = inst_70917;
var inst_70923 = inst_70918;
var inst_70924 = inst_70919;
var inst_70925 = inst_70920;
var state_70946__$1 = (function (){var statearr_70948 = state_70946;
(statearr_70948[(7)] = inst_70925);

(statearr_70948[(8)] = inst_70924);

(statearr_70948[(9)] = inst_70921);

(statearr_70948[(10)] = inst_70922);

(statearr_70948[(11)] = inst_70923);

return statearr_70948;
})();
var statearr_70949_70964 = state_70946__$1;
(statearr_70949_70964[(2)] = null);

(statearr_70949_70964[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (2))){
var inst_70921 = (state_70946[(9)]);
var inst_70922 = (state_70946[(10)]);
var inst_70923 = (state_70946[(11)]);
var inst_70927 = fluree.db.api.query.format_block_resp_pretty(db,inst_70923,inst_70922,inst_70921);
var state_70946__$1 = state_70946;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70946__$1,(4),inst_70927);
} else {
if((state_val_70947 === (3))){
var inst_70944 = (state_70946[(2)]);
var state_70946__$1 = state_70946;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70946__$1,inst_70944);
} else {
if((state_val_70947 === (4))){
var inst_70925 = (state_70946[(7)]);
var inst_70924 = (state_70946[(8)]);
var inst_70929 = (state_70946[(2)]);
var inst_70930 = fluree.db.util.async.throw_err(inst_70929);
var inst_70931 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70932 = [inst_70930];
var inst_70933 = (new cljs.core.PersistentVector(null,1,(5),inst_70931,inst_70932,null));
var inst_70934 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_70925,inst_70933);
var inst_70935 = cljs.core.first(inst_70924);
var state_70946__$1 = (function (){var statearr_70952 = state_70946;
(statearr_70952[(12)] = inst_70934);

return statearr_70952;
})();
if(cljs.core.truth_(inst_70935)){
var statearr_70953_70965 = state_70946__$1;
(statearr_70953_70965[(1)] = (5));

} else {
var statearr_70954_70966 = state_70946__$1;
(statearr_70954_70966[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (5))){
var inst_70934 = (state_70946[(12)]);
var inst_70924 = (state_70946[(8)]);
var inst_70921 = (state_70946[(9)]);
var inst_70922 = (state_70946[(10)]);
var inst_70937 = cljs.core.first(inst_70924);
var inst_70938 = cljs.core.rest(inst_70924);
var tmp70950 = inst_70921;
var tmp70951 = inst_70922;
var inst_70921__$1 = tmp70950;
var inst_70922__$1 = tmp70951;
var inst_70923 = inst_70937;
var inst_70924__$1 = inst_70938;
var inst_70925 = inst_70934;
var state_70946__$1 = (function (){var statearr_70955 = state_70946;
(statearr_70955[(7)] = inst_70925);

(statearr_70955[(8)] = inst_70924__$1);

(statearr_70955[(9)] = inst_70921__$1);

(statearr_70955[(10)] = inst_70922__$1);

(statearr_70955[(11)] = inst_70923);

return statearr_70955;
})();
var statearr_70956_70967 = state_70946__$1;
(statearr_70956_70967[(2)] = null);

(statearr_70956_70967[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (6))){
var inst_70934 = (state_70946[(12)]);
var state_70946__$1 = state_70946;
var statearr_70957_70968 = state_70946__$1;
(statearr_70957_70968[(2)] = inst_70934);

(statearr_70957_70968[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70947 === (7))){
var inst_70942 = (state_70946[(2)]);
var state_70946__$1 = state_70946;
var statearr_70958_70969 = state_70946__$1;
(statearr_70958_70969[(2)] = inst_70942);

(statearr_70958_70969[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11410__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11410__auto____0 = (function (){
var statearr_70959 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70959[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11410__auto__);

(statearr_70959[(1)] = (1));

return statearr_70959;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11410__auto____1 = (function (state_70946){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_70946);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e70960){var ex__11413__auto__ = e70960;
var statearr_70961_70970 = state_70946;
(statearr_70961_70970[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_70946[(4)]))){
var statearr_70962_70971 = state_70946;
(statearr_70962_70971[(1)] = cljs.core.first((state_70946[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70972 = state_70946;
state_70946 = G__70972;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11410__auto__ = function(state_70946){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11410__auto____1.call(this,state_70946);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11410__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11410__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_70963 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_70963[(6)] = c__11484__auto__);

return statearr_70963;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__70974 = arguments.length;
switch (G__70974) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range(db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__70976){
var map__70977 = p__70976;
var map__70977__$1 = cljs.core.__destructure_map(map__70977);
var query = map__70977__$1;
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70977__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_71062){
var state_val_71063 = (state_71062[(1)]);
if((state_val_71063 === (7))){
var inst_70988 = (state_71062[(7)]);
var inst_70992 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70993 = ["_auth/id",inst_70988];
var inst_70994 = (new cljs.core.PersistentVector(null,2,(5),inst_70992,inst_70993,null));
var state_71062__$1 = state_71062;
var statearr_71064_71108 = state_71062__$1;
(statearr_71064_71108[(2)] = inst_70994);

(statearr_71064_71108[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71063 === (20))){
var inst_71042 = (state_71062[(2)]);
var inst_71043 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_71062__$1 = (function (){var statearr_71065 = state_71062;
(statearr_71065[(8)] = inst_71042);

return statearr_71065;
})();
if(cljs.core.truth_(inst_71043)){
var statearr_71066_71109 = state_71062__$1;
(statearr_71066_71109[(1)] = (22));

} else {
var statearr_71067_71110 = state_71062__$1;
(statearr_71067_71110[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71063 === (27))){
var inst_70989 = (state_71062[(9)]);
var inst_71045 = (state_71062[(10)]);
var inst_71051 = (state_71062[(2)]);
var inst_71052 = fluree.db.util.core.response_time_formatted(inst_70989);
var inst_71053 = [(200),inst_71051,(100),inst_71052];
var inst_71054 = cljs.core.PersistentHashMap.fromArrays(inst_71045,inst_71053);
var state_71062__$1 = state_71062;
var statearr_71068_71111 = state_71062__$1;
(statearr_71068_71111[(2)] = inst_71054);

(statearr_71068_71111[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71063 === (1))){
var state_71062__$1 = state_71062;
var statearr_71069_71112 = state_71062__$1;
(statearr_71069_71112[(2)] = null);

(statearr_71069_71112[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71063 === (24))){
var inst_71057 = (state_71062[(2)]);
var _ = (function (){var statearr_71070 = state_71062;
(statearr_71070[(4)] = cljs.core.rest((state_71062[(4)])));

return statearr_71070;
})();
var state_71062__$1 = state_71062;
var statearr_71071_71113 = state_71062__$1;
(statearr_71071_71113[(2)] = inst_71057);

(statearr_71071_71113[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71063 === (4))){
var inst_70978 = (state_71062[(2)]);
var state_71062__$1 = state_71062;
var statearr_71072_71114 = state_71062__$1;
(statearr_71072_71114[(2)] = inst_70978);

(statearr_71072_71114[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71063 === (15))){
var inst_71029 = (state_71062[(11)]);
var state_71062__$1 = state_71062;
var statearr_71073_71115 = state_71062__$1;
(statearr_71073_71115[(2)] = inst_71029);

(statearr_71073_71115[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71063 === (21))){
var inst_71038 = (state_71062[(2)]);
var inst_71039 = fluree.db.util.async.throw_err(inst_71038);
var state_71062__$1 = state_71062;
var statearr_71074_71116 = state_71062__$1;
(statearr_71074_71116[(2)] = inst_71039);

(statearr_71074_71116[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71063 === (13))){
var inst_70987 = (state_71062[(12)]);
var inst_71029 = (state_71062[(11)]);
var inst_71028 = (state_71062[(2)]);
var inst_71029__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_70987);
var state_71062__$1 = (function (){var statearr_71075 = state_71062;
(statearr_71075[(11)] = inst_71029__$1);

(statearr_71075[(13)] = inst_71028);

return statearr_71075;
})();
if(cljs.core.truth_(inst_71029__$1)){
var statearr_71076_71117 = state_71062__$1;
(statearr_71076_71117[(1)] = (15));

} else {
var statearr_71077_71118 = state_71062__$1;
(statearr_71077_71118[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71063 === (22))){
var inst_71042 = (state_71062[(8)]);
var inst_71045 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_71046 = cljs.core.sequential_QMARK_(inst_71042);
var state_71062__$1 = (function (){var statearr_71078 = state_71062;
(statearr_71078[(10)] = inst_71045);

return statearr_71078;
})();
if(inst_71046){
var statearr_71079_71119 = state_71062__$1;
(statearr_71079_71119[(1)] = (25));

} else {
var statearr_71080_71120 = state_71062__$1;
(statearr_71080_71120[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71063 === (6))){
var inst_70987 = (state_71062[(12)]);
var inst_71003 = (state_71062[(14)]);
var inst_71002 = (state_71062[(2)]);
var inst_71003__$1 = fluree.db.util.async.throw_err(inst_71002);
var inst_71004 = fluree.db.api.query.resolve_block_range(inst_71003__$1,inst_70987);
var state_71062__$1 = (function (){var statearr_71081 = state_71062;
(statearr_71081[(14)] = inst_71003__$1);

return statearr_71081;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71062__$1,(10),inst_71004);
} else {
if((state_val_71063 === (25))){
var inst_71042 = (state_71062[(8)]);
var inst_71048 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_71042);
var state_71062__$1 = state_71062;
var statearr_71082_71121 = state_71062__$1;
(statearr_71082_71121[(2)] = inst_71048);

(statearr_71082_71121[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71063 === (17))){
var inst_71034 = (state_71062[(2)]);
var state_71062__$1 = state_71062;
if(cljs.core.truth_(inst_71034)){
var statearr_71083_71122 = state_71062__$1;
(statearr_71083_71122[(1)] = (18));

} else {
var statearr_71084_71123 = state_71062__$1;
(statearr_71084_71123[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71063 === (3))){
var inst_71060 = (state_71062[(2)]);
var state_71062__$1 = state_71062;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71062__$1,inst_71060);
} else {
if((state_val_71063 === (12))){
var inst_70987 = (state_71062[(12)]);
var inst_71020 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_70987], 0));
var inst_71021 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_71020].join('');
var inst_71022 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71023 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_71024 = cljs.core.PersistentHashMap.fromArrays(inst_71022,inst_71023);
var inst_71025 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_71021,inst_71024);
var inst_71026 = (function(){throw inst_71025})();
var state_71062__$1 = state_71062;
var statearr_71085_71124 = state_71062__$1;
(statearr_71085_71124[(2)] = inst_71026);

(statearr_71085_71124[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71063 === (2))){
var inst_70988 = (state_71062[(7)]);
var _ = (function (){var statearr_71086 = state_71062;
(statearr_71086[(4)] = cljs.core.cons((5),(state_71062[(4)])));

return statearr_71086;
})();
var inst_70987 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_70988__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_70989 = fluree.db.util.core.current_time_millis();
var inst_70990 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_71062__$1 = (function (){var statearr_71087 = state_71062;
(statearr_71087[(7)] = inst_70988__$1);

(statearr_71087[(9)] = inst_70989);

(statearr_71087[(12)] = inst_70987);

(statearr_71087[(15)] = inst_70990);

return statearr_71087;
})();
if(cljs.core.truth_(inst_70988__$1)){
var statearr_71088_71125 = state_71062__$1;
(statearr_71088_71125[(1)] = (7));

} else {
var statearr_71089_71126 = state_71062__$1;
(statearr_71089_71126[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71063 === (23))){
var inst_71042 = (state_71062[(8)]);
var state_71062__$1 = state_71062;
var statearr_71090_71127 = state_71062__$1;
(statearr_71090_71127[(2)] = inst_71042);

(statearr_71090_71127[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71063 === (19))){
var inst_71028 = (state_71062[(13)]);
var state_71062__$1 = state_71062;
var statearr_71091_71128 = state_71062__$1;
(statearr_71091_71128[(2)] = inst_71028);

(statearr_71091_71128[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71063 === (11))){
var inst_71003 = (state_71062[(14)]);
var inst_71008 = (state_71062[(16)]);
var inst_71009 = (state_71062[(17)]);
var inst_71015 = fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(inst_71003,inst_71008,inst_71009,opts);
var state_71062__$1 = state_71062;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71062__$1,(14),inst_71015);
} else {
if((state_val_71063 === (9))){
var inst_70990 = (state_71062[(15)]);
var inst_70997 = (state_71062[(2)]);
var inst_70998 = [inst_70997];
var inst_70999 = cljs.core.PersistentHashMap.fromArrays(inst_70990,inst_70998);
var inst_71000 = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,inst_70999);
var state_71062__$1 = state_71062;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71062__$1,(6),inst_71000);
} else {
if((state_val_71063 === (5))){
var _ = (function (){var statearr_71093 = state_71062;
(statearr_71093[(4)] = cljs.core.rest((state_71062[(4)])));

return statearr_71093;
})();
var state_71062__$1 = state_71062;
var ex71092 = (state_71062__$1[(2)]);
var statearr_71094_71129 = state_71062__$1;
(statearr_71094_71129[(5)] = ex71092);


if((ex71092 instanceof Error)){
var statearr_71095_71130 = state_71062__$1;
(statearr_71095_71130[(1)] = (4));

(statearr_71095_71130[(5)] = null);

} else {
throw ex71092;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71063 === (14))){
var inst_71017 = (state_71062[(2)]);
var inst_71018 = fluree.db.util.async.throw_err(inst_71017);
var state_71062__$1 = state_71062;
var statearr_71096_71131 = state_71062__$1;
(statearr_71096_71131[(2)] = inst_71018);

(statearr_71096_71131[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71063 === (26))){
var inst_71042 = (state_71062[(8)]);
var state_71062__$1 = state_71062;
var statearr_71097_71132 = state_71062__$1;
(statearr_71097_71132[(2)] = inst_71042);

(statearr_71097_71132[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71063 === (16))){
var inst_70987 = (state_71062[(12)]);
var inst_71032 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_70987);
var state_71062__$1 = state_71062;
var statearr_71098_71133 = state_71062__$1;
(statearr_71098_71133[(2)] = inst_71032);

(statearr_71098_71133[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71063 === (10))){
var inst_70987 = (state_71062[(12)]);
var inst_71006 = (state_71062[(2)]);
var inst_71007 = fluree.db.util.async.throw_err(inst_71006);
var inst_71008 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71007,(0),null);
var inst_71009 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71007,(1),null);
var inst_71010 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_71011 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(inst_70987,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803)], 0));
var inst_71012 = cljs.core.keys(inst_71011);
var inst_71013 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_71010,inst_71012);
var state_71062__$1 = (function (){var statearr_71099 = state_71062;
(statearr_71099[(16)] = inst_71008);

(statearr_71099[(17)] = inst_71009);

return statearr_71099;
})();
if(inst_71013){
var statearr_71100_71134 = state_71062__$1;
(statearr_71100_71134[(1)] = (11));

} else {
var statearr_71101_71135 = state_71062__$1;
(statearr_71101_71135[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71063 === (18))){
var inst_71028 = (state_71062[(13)]);
var inst_71003 = (state_71062[(14)]);
var inst_71036 = fluree.db.api.query.format_blocks_resp_pretty(inst_71003,inst_71028);
var state_71062__$1 = state_71062;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71062__$1,(21),inst_71036);
} else {
if((state_val_71063 === (8))){
var state_71062__$1 = state_71062;
var statearr_71102_71136 = state_71062__$1;
(statearr_71102_71136[(2)] = null);

(statearr_71102_71136[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__11410__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__11410__auto____0 = (function (){
var statearr_71103 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71103[(0)] = fluree$db$api$query$block_query_async_$_state_machine__11410__auto__);

(statearr_71103[(1)] = (1));

return statearr_71103;
});
var fluree$db$api$query$block_query_async_$_state_machine__11410__auto____1 = (function (state_71062){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_71062);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e71104){var ex__11413__auto__ = e71104;
var statearr_71105_71137 = state_71062;
(statearr_71105_71137[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_71062[(4)]))){
var statearr_71106_71138 = state_71062;
(statearr_71106_71138[(1)] = cljs.core.first((state_71062[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71139 = state_71062;
state_71062 = G__71139;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__11410__auto__ = function(state_71062){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__11410__auto____1.call(this,state_71062);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__11410__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__11410__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_71107 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_71107[(6)] = c__11484__auto__);

return statearr_71107;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_(history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_(history))?((cljs.core.empty_QMARK_(history))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__71140 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(0)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(1)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(2)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(3))], null);
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71140,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71140,(1),null);
var o = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71140,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71140,(3),null);
var vec__71143 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((((!((p == null)))) && ((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((((!((p == null)))) && ((!((o == null))))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71143,(0),null);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71143,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__71146 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [flake.t,new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71146,(0),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71146,(1),null);
var or__4253__auto__ = (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(auth) : auth_set.call(null,auth));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(id) : auth_set.call(null,id));
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71150 = arguments.length;
var i__4865__auto___71151 = (0);
while(true){
if((i__4865__auto___71151 < len__4864__auto___71150)){
args__4870__auto__.push((arguments[i__4865__auto___71151]));

var G__71152 = (i__4865__auto___71151 + (1));
i__4865__auto___71151 = G__71152;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq71149){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq71149));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_71348){
var state_val_71349 = (state_71348[(1)]);
if((state_val_71349 === (7))){
var inst_71268 = (state_71348[(7)]);
var inst_71275 = (state_71348[(8)]);
var inst_71274 = cljs.core.seq(inst_71268);
var inst_71275__$1 = cljs.core.first(inst_71274);
var inst_71276 = cljs.core.next(inst_71274);
var state_71348__$1 = (function (){var statearr_71350 = state_71348;
(statearr_71350[(9)] = inst_71276);

(statearr_71350[(8)] = inst_71275__$1);

return statearr_71350;
})();
if(cljs.core.truth_(inst_71275__$1)){
var statearr_71351_71451 = state_71348__$1;
(statearr_71351_71451[(1)] = (9));

} else {
var statearr_71352_71452 = state_71348__$1;
(statearr_71352_71452[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71349 === (20))){
var inst_71338 = (state_71348[(2)]);
var state_71348__$1 = state_71348;
var statearr_71353_71453 = state_71348__$1;
(statearr_71353_71453[(2)] = inst_71338);

(statearr_71353_71453[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71349 === (27))){
var inst_71314 = (state_71348[(10)]);
var inst_71296 = (state_71348[(11)]);
var inst_71293 = (state_71348[(12)]);
var inst_71316 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71317 = [inst_71296,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_71318 = (new cljs.core.PersistentVector(null,2,(5),inst_71316,inst_71317,null));
var inst_71319 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_71314,inst_71318,fluree.db.api.query.min_safe,inst_71293);
var state_71348__$1 = state_71348;
var statearr_71354_71454 = state_71348__$1;
(statearr_71354_71454[(2)] = inst_71319);

(statearr_71354_71454[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71349 === (1))){
var state_71348__$1 = state_71348;
var statearr_71355_71455 = state_71348__$1;
(statearr_71355_71455[(2)] = null);

(statearr_71355_71455[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71349 === (24))){
var inst_71296 = (state_71348[(11)]);
var inst_71275 = (state_71348[(8)]);
var inst_71306 = (state_71348[(13)]);
var inst_71308 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71309 = [inst_71296,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_71310 = (new cljs.core.PersistentVector(null,2,(5),inst_71308,inst_71309,null));
var inst_71311 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_71306,inst_71310,cljs.core.conj,inst_71275);
var state_71348__$1 = state_71348;
var statearr_71357_71456 = state_71348__$1;
(statearr_71357_71456[(2)] = inst_71311);

(statearr_71357_71456[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71349 === (4))){
var inst_71154 = (state_71348[(2)]);
var state_71348__$1 = state_71348;
var statearr_71358_71457 = state_71348__$1;
(statearr_71358_71457[(2)] = inst_71154);

(statearr_71358_71457[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71349 === (15))){
var inst_71276 = (state_71348[(9)]);
var inst_71269 = (state_71348[(14)]);
var tmp71356 = inst_71269;
var inst_71268 = inst_71276;
var inst_71269__$1 = tmp71356;
var state_71348__$1 = (function (){var statearr_71359 = state_71348;
(statearr_71359[(7)] = inst_71268);

(statearr_71359[(14)] = inst_71269__$1);

return statearr_71359;
})();
var statearr_71360_71458 = state_71348__$1;
(statearr_71360_71458[(2)] = null);

(statearr_71360_71458[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71349 === (21))){
var inst_71296 = (state_71348[(11)]);
var inst_71269 = (state_71348[(14)]);
var inst_71300 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71301 = [inst_71296,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_71302 = (new cljs.core.PersistentVector(null,2,(5),inst_71300,inst_71301,null));
var inst_71303 = cljs.core.assoc_in(inst_71269,inst_71302,inst_71296);
var state_71348__$1 = state_71348;
var statearr_71361_71459 = state_71348__$1;
(statearr_71361_71459[(2)] = inst_71303);

(statearr_71361_71459[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71349 === (31))){
var inst_71322 = (state_71348[(15)]);
var state_71348__$1 = state_71348;
var statearr_71362_71460 = state_71348__$1;
(statearr_71362_71460[(2)] = inst_71322);

(statearr_71362_71460[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71349 === (32))){
var inst_71276 = (state_71348[(9)]);
var inst_71330 = (state_71348[(2)]);
var inst_71268 = inst_71276;
var inst_71269 = inst_71330;
var state_71348__$1 = (function (){var statearr_71363 = state_71348;
(statearr_71363[(7)] = inst_71268);

(statearr_71363[(14)] = inst_71269);

return statearr_71363;
})();
var statearr_71364_71461 = state_71348__$1;
(statearr_71364_71461[(2)] = null);

(statearr_71364_71461[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71349 === (33))){
var inst_71269 = (state_71348[(14)]);
var state_71348__$1 = state_71348;
var statearr_71365_71462 = state_71348__$1;
(statearr_71365_71462[(2)] = inst_71269);

(statearr_71365_71462[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71349 === (13))){
var inst_71278 = (state_71348[(16)]);
var state_71348__$1 = state_71348;
var statearr_71366_71463 = state_71348__$1;
(statearr_71366_71463[(2)] = inst_71278);

(statearr_71366_71463[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71349 === (22))){
var inst_71269 = (state_71348[(14)]);
var state_71348__$1 = state_71348;
var statearr_71367_71464 = state_71348__$1;
(statearr_71367_71464[(2)] = inst_71269);

(statearr_71367_71464[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71349 === (29))){
var inst_71322 = (state_71348[(2)]);
var state_71348__$1 = (function (){var statearr_71368 = state_71348;
(statearr_71368[(15)] = inst_71322);

return statearr_71368;
})();
if(cljs.core.truth_(show_auth)){
var statearr_71369_71465 = state_71348__$1;
(statearr_71369_71465[(1)] = (30));

} else {
var statearr_71370_71466 = state_71348__$1;
(statearr_71370_71466[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71349 === (6))){
var inst_71254 = (state_71348[(2)]);
var inst_71255 = fluree.db.util.async.throw_err(inst_71254);
var inst_71263 = resp;
var inst_71264 = cljs.core.seq(inst_71263);
var inst_71265 = cljs.core.first(inst_71264);
var inst_71266 = cljs.core.next(inst_71264);
var inst_71267 = cljs.core.PersistentHashMap.EMPTY;
var inst_71268 = inst_71263;
var inst_71269 = inst_71267;
var state_71348__$1 = (function (){var statearr_71371 = state_71348;
(statearr_71371[(7)] = inst_71268);

(statearr_71371[(17)] = inst_71255);

(statearr_71371[(14)] = inst_71269);

(statearr_71371[(18)] = inst_71265);

(statearr_71371[(19)] = inst_71266);

return statearr_71371;
})();
var statearr_71372_71467 = state_71348__$1;
(statearr_71372_71467[(2)] = null);

(statearr_71372_71467[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71349 === (28))){
var inst_71314 = (state_71348[(10)]);
var state_71348__$1 = state_71348;
var statearr_71373_71468 = state_71348__$1;
(statearr_71373_71468[(2)] = inst_71314);

(statearr_71373_71468[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71349 === (25))){
var inst_71306 = (state_71348[(13)]);
var state_71348__$1 = state_71348;
var statearr_71374_71469 = state_71348__$1;
(statearr_71374_71469[(2)] = inst_71306);

(statearr_71374_71469[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71349 === (34))){
var state_71348__$1 = state_71348;
var statearr_71375_71470 = state_71348__$1;
(statearr_71375_71470[(2)] = null);

(statearr_71375_71470[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71349 === (17))){
var inst_71340 = (state_71348[(2)]);
var state_71348__$1 = state_71348;
var statearr_71376_71471 = state_71348__$1;
(statearr_71376_71471[(2)] = inst_71340);

(statearr_71376_71471[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71349 === (3))){
var inst_71346 = (state_71348[(2)]);
var state_71348__$1 = state_71348;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71348__$1,inst_71346);
} else {
if((state_val_71349 === (12))){
var inst_71255 = (state_71348[(17)]);
var inst_71275 = (state_71348[(8)]);
var inst_71280 = fluree.db.api.query.auth_match(auth,inst_71255,inst_71275);
var inst_71281 = cljs.core.not(inst_71280);
var state_71348__$1 = state_71348;
var statearr_71377_71472 = state_71348__$1;
(statearr_71377_71472[(2)] = inst_71281);

(statearr_71377_71472[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71349 === (2))){
var _ = (function (){var statearr_71378 = state_71348;
(statearr_71378[(4)] = cljs.core.cons((5),(state_71348[(4)])));

return statearr_71378;
})();
var inst_71160 = (function (){return (function (p1__71153_SHARP_){
return p1__71153_SHARP_.t;
});
})();
var inst_71161 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_71160,resp);
var inst_71162 = cljs.core.set(inst_71161);
var inst_71250 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_71251 = (function (){var ts = inst_71162;
var c__11484__auto____$1 = inst_71250;
return (function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_71248){
var state_val_71249 = (state_71248[(1)]);
if((state_val_71249 === (7))){
var inst_71176 = (state_71248[(7)]);
var inst_71182 = (state_71248[(8)]);
var inst_71194 = (state_71248[(9)]);
var inst_71188 = (state_71248[(10)]);
var inst_71187 = (state_71248[(2)]);
var inst_71188__$1 = fluree.db.util.async.throw_err(inst_71187);
var inst_71190 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71191 = [inst_71182,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_71192 = (new cljs.core.PersistentVector(null,2,(5),inst_71190,inst_71191,null));
var inst_71193 = cljs.core.assoc_in(inst_71176,inst_71192,inst_71188__$1);
var inst_71194__$1 = auth;
var state_71248__$1 = (function (){var statearr_71379 = state_71248;
(statearr_71379[(11)] = inst_71193);

(statearr_71379[(9)] = inst_71194__$1);

(statearr_71379[(10)] = inst_71188__$1);

return statearr_71379;
})();
if(cljs.core.truth_(inst_71194__$1)){
var statearr_71380_71473 = state_71248__$1;
(statearr_71380_71473[(1)] = (8));

} else {
var statearr_71381_71474 = state_71248__$1;
(statearr_71381_71474[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71249 === (1))){
var inst_71170 = (state_71248[(12)]);
var inst_71170__$1 = ts;
var inst_71171 = cljs.core.seq(inst_71170__$1);
var inst_71172 = cljs.core.first(inst_71171);
var inst_71173 = cljs.core.next(inst_71171);
var inst_71174 = cljs.core.PersistentHashMap.EMPTY;
var inst_71175 = inst_71170__$1;
var inst_71176 = inst_71174;
var state_71248__$1 = (function (){var statearr_71382 = state_71248;
(statearr_71382[(7)] = inst_71176);

(statearr_71382[(13)] = inst_71175);

(statearr_71382[(14)] = inst_71172);

(statearr_71382[(12)] = inst_71170__$1);

(statearr_71382[(15)] = inst_71173);

return statearr_71382;
})();
var statearr_71383_71475 = state_71248__$1;
(statearr_71383_71475[(2)] = null);

(statearr_71383_71475[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71249 === (4))){
var inst_71182 = (state_71248[(8)]);
var inst_71185 = fluree.db.time_travel.non_border_t_to_block(db,inst_71182);
var state_71248__$1 = state_71248;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71248__$1,(7),inst_71185);
} else {
if((state_val_71249 === (13))){
var inst_71183 = (state_71248[(16)]);
var inst_71240 = (state_71248[(2)]);
var inst_71175 = inst_71183;
var inst_71176 = inst_71240;
var state_71248__$1 = (function (){var statearr_71384 = state_71248;
(statearr_71384[(7)] = inst_71176);

(statearr_71384[(13)] = inst_71175);

return statearr_71384;
})();
var statearr_71385_71476 = state_71248__$1;
(statearr_71385_71476[(2)] = null);

(statearr_71385_71476[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71249 === (6))){
var inst_71244 = (state_71248[(2)]);
var state_71248__$1 = state_71248;
var statearr_71386_71477 = state_71248__$1;
(statearr_71386_71477[(2)] = inst_71244);

(statearr_71386_71477[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71249 === (3))){
var inst_71246 = (state_71248[(2)]);
var state_71248__$1 = state_71248;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71248__$1,inst_71246);
} else {
if((state_val_71249 === (12))){
var inst_71193 = (state_71248[(11)]);
var state_71248__$1 = state_71248;
var statearr_71387_71478 = state_71248__$1;
(statearr_71387_71478[(2)] = inst_71193);

(statearr_71387_71478[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71249 === (2))){
var inst_71175 = (state_71248[(13)]);
var inst_71182 = (state_71248[(8)]);
var inst_71181 = cljs.core.seq(inst_71175);
var inst_71182__$1 = cljs.core.first(inst_71181);
var inst_71183 = cljs.core.next(inst_71181);
var state_71248__$1 = (function (){var statearr_71388 = state_71248;
(statearr_71388[(16)] = inst_71183);

(statearr_71388[(8)] = inst_71182__$1);

return statearr_71388;
})();
if(cljs.core.truth_(inst_71182__$1)){
var statearr_71389_71479 = state_71248__$1;
(statearr_71389_71479[(1)] = (4));

} else {
var statearr_71390_71480 = state_71248__$1;
(statearr_71390_71480[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71249 === (11))){
var inst_71193 = (state_71248[(11)]);
var inst_71183 = (state_71248[(16)]);
var inst_71176 = (state_71248[(7)]);
var inst_71175 = (state_71248[(13)]);
var inst_71182 = (state_71248[(8)]);
var inst_71172 = (state_71248[(14)]);
var inst_71188 = (state_71248[(10)]);
var inst_71170 = (state_71248[(12)]);
var inst_71173 = (state_71248[(15)]);
var inst_71200 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71201 = [inst_71182,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_71202 = (new cljs.core.PersistentVector(null,2,(5),inst_71200,inst_71201,null));
var inst_71215 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_71216 = (function (){var vec__71167 = inst_71170;
var t = inst_71182;
var block = inst_71188;
var r = inst_71183;
var c__11484__auto____$2 = inst_71215;
var first__71180 = inst_71182;
var G__71166 = inst_71175;
var acc = inst_71176;
var first__71169 = inst_71172;
var vec__71178 = inst_71175;
var seq__71168 = inst_71173;
var seq__71179 = inst_71183;
var G__71189 = inst_71193;
return (function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_71213){
var state_val_71214 = (state_71213[(1)]);
if((state_val_71214 === (1))){
var state_71213__$1 = state_71213;
var statearr_71391_71481 = state_71213__$1;
(statearr_71391_71481[(2)] = null);

(statearr_71391_71481[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71214 === (2))){
var ___$1 = (function (){var statearr_71392 = state_71213;
(statearr_71392[(4)] = cljs.core.cons((5),(state_71213[(4)])));

return statearr_71392;
})();
var ___$2 = (function (){var statearr_71393 = state_71213;
(statearr_71393[(4)] = cljs.core.rest((state_71213[(4)])));

return statearr_71393;
})();
var state_71213__$1 = state_71213;
var statearr_71394_71482 = state_71213__$1;
(statearr_71394_71482[(2)] = db);

(statearr_71394_71482[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71214 === (3))){
var inst_71211 = (state_71213[(2)]);
var state_71213__$1 = state_71213;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71213__$1,inst_71211);
} else {
if((state_val_71214 === (4))){
var inst_71203 = (state_71213[(2)]);
var state_71213__$1 = state_71213;
var statearr_71396_71483 = state_71213__$1;
(statearr_71396_71483[(2)] = inst_71203);

(statearr_71396_71483[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71214 === (5))){
var ___$1 = (function (){var statearr_71397 = state_71213;
(statearr_71397[(4)] = cljs.core.rest((state_71213[(4)])));

return statearr_71397;
})();
var state_71213__$1 = state_71213;
var ex71395 = (state_71213__$1[(2)]);
var statearr_71398_71484 = state_71213__$1;
(statearr_71398_71484[(5)] = ex71395);


if((ex71395 instanceof Error)){
var statearr_71399_71485 = state_71213__$1;
(statearr_71399_71485[(1)] = (4));

(statearr_71399_71485[(5)] = null);

} else {
throw ex71395;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__11410__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__11410__auto____0 = (function (){
var statearr_71400 = [null,null,null,null,null,null,null];
(statearr_71400[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__11410__auto__);

(statearr_71400[(1)] = (1));

return statearr_71400;
});
var fluree$db$api$query$format_history_resp_$_state_machine__11410__auto____1 = (function (state_71213){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_71213);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e71401){var ex__11413__auto__ = e71401;
var statearr_71402_71486 = state_71213;
(statearr_71402_71486[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_71213[(4)]))){
var statearr_71403_71487 = state_71213;
(statearr_71403_71487[(1)] = cljs.core.first((state_71213[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71488 = state_71213;
state_71213 = G__71488;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__11410__auto__ = function(state_71213){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__11410__auto____1.call(this,state_71213);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__11410__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__11410__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_71404 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_71404[(6)] = c__11484__auto____$2);

return statearr_71404;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
});
})();
var inst_71217 = cljs.core.async.impl.dispatch.run(inst_71216);
var inst_71218 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_71219 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71220 = ["?auth","?id"];
var inst_71221 = (new cljs.core.PersistentVector(null,2,(5),inst_71219,inst_71220,null));
var inst_71222 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71223 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71224 = [inst_71182,"_tx/auth","?auth"];
var inst_71225 = (new cljs.core.PersistentVector(null,3,(5),inst_71223,inst_71224,null));
var inst_71226 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71227 = ["?auth","_auth/id","?id"];
var inst_71228 = (new cljs.core.PersistentVector(null,3,(5),inst_71226,inst_71227,null));
var inst_71229 = [inst_71225,inst_71228];
var inst_71230 = (new cljs.core.PersistentVector(null,2,(5),inst_71222,inst_71229,null));
var inst_71231 = [inst_71221,inst_71230];
var inst_71232 = cljs.core.PersistentHashMap.fromArrays(inst_71218,inst_71231);
var inst_71233 = (fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2(inst_71215,inst_71232) : fluree.db.api.query.query_async.call(null,inst_71215,inst_71232));
var state_71248__$1 = (function (){var statearr_71405 = state_71248;
(statearr_71405[(17)] = inst_71202);

(statearr_71405[(18)] = inst_71217);

return statearr_71405;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71248__$1,(14),inst_71233);
} else {
if((state_val_71249 === (9))){
var state_71248__$1 = state_71248;
var statearr_71406_71489 = state_71248__$1;
(statearr_71406_71489[(2)] = show_auth);

(statearr_71406_71489[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71249 === (5))){
var inst_71176 = (state_71248[(7)]);
var state_71248__$1 = state_71248;
var statearr_71407_71490 = state_71248__$1;
(statearr_71407_71490[(2)] = inst_71176);

(statearr_71407_71490[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71249 === (14))){
var inst_71193 = (state_71248[(11)]);
var inst_71202 = (state_71248[(17)]);
var inst_71235 = (state_71248[(2)]);
var inst_71236 = fluree.db.util.async.throw_err(inst_71235);
var inst_71237 = cljs.core.assoc_in(inst_71193,inst_71202,inst_71236);
var state_71248__$1 = state_71248;
var statearr_71408_71491 = state_71248__$1;
(statearr_71408_71491[(2)] = inst_71237);

(statearr_71408_71491[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71249 === (10))){
var inst_71198 = (state_71248[(2)]);
var state_71248__$1 = state_71248;
if(cljs.core.truth_(inst_71198)){
var statearr_71409_71492 = state_71248__$1;
(statearr_71409_71492[(1)] = (11));

} else {
var statearr_71410_71493 = state_71248__$1;
(statearr_71410_71493[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71249 === (8))){
var inst_71194 = (state_71248[(9)]);
var state_71248__$1 = state_71248;
var statearr_71411_71494 = state_71248__$1;
(statearr_71411_71494[(2)] = inst_71194);

(statearr_71411_71494[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__11410__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__11410__auto____0 = (function (){
var statearr_71412 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71412[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__11410__auto__);

(statearr_71412[(1)] = (1));

return statearr_71412;
});
var fluree$db$api$query$format_history_resp_$_state_machine__11410__auto____1 = (function (state_71248){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_71248);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e71413){var ex__11413__auto__ = e71413;
var statearr_71414_71495 = state_71248;
(statearr_71414_71495[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_71248[(4)]))){
var statearr_71415_71496 = state_71248;
(statearr_71415_71496[(1)] = cljs.core.first((state_71248[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71497 = state_71248;
state_71248 = G__71497;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__11410__auto__ = function(state_71248){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__11410__auto____1.call(this,state_71248);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__11410__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__11410__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_71416 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_71416[(6)] = c__11484__auto____$1);

return statearr_71416;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
});
})();
var inst_71252 = cljs.core.async.impl.dispatch.run(inst_71251);
var state_71348__$1 = (function (){var statearr_71417 = state_71348;
(statearr_71417[(20)] = inst_71252);

return statearr_71417;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71348__$1,(6),inst_71250);
} else {
if((state_val_71349 === (23))){
var inst_71306 = (state_71348[(2)]);
var state_71348__$1 = (function (){var statearr_71418 = state_71348;
(statearr_71418[(13)] = inst_71306);

return statearr_71418;
})();
var statearr_71419_71498 = state_71348__$1;
(statearr_71419_71498[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71349 === (35))){
var inst_71336 = (state_71348[(2)]);
var state_71348__$1 = state_71348;
var statearr_71421_71499 = state_71348__$1;
(statearr_71421_71499[(2)] = inst_71336);

(statearr_71421_71499[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71349 === (19))){
var state_71348__$1 = state_71348;
var statearr_71422_71500 = state_71348__$1;
(statearr_71422_71500[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71349 === (11))){
var inst_71287 = (state_71348[(2)]);
var state_71348__$1 = state_71348;
if(cljs.core.truth_(inst_71287)){
var statearr_71425_71501 = state_71348__$1;
(statearr_71425_71501[(1)] = (15));

} else {
var statearr_71426_71502 = state_71348__$1;
(statearr_71426_71502[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71349 === (9))){
var inst_71278 = (state_71348[(16)]);
var inst_71278__$1 = auth;
var state_71348__$1 = (function (){var statearr_71427 = state_71348;
(statearr_71427[(16)] = inst_71278__$1);

return statearr_71427;
})();
if(cljs.core.truth_(inst_71278__$1)){
var statearr_71428_71503 = state_71348__$1;
(statearr_71428_71503[(1)] = (12));

} else {
var statearr_71429_71504 = state_71348__$1;
(statearr_71429_71504[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71349 === (5))){
var _ = (function (){var statearr_71430 = state_71348;
(statearr_71430[(4)] = cljs.core.rest((state_71348[(4)])));

return statearr_71430;
})();
var state_71348__$1 = state_71348;
var ex71424 = (state_71348__$1[(2)]);
var statearr_71431_71505 = state_71348__$1;
(statearr_71431_71505[(5)] = ex71424);


if((ex71424 instanceof Error)){
var statearr_71432_71506 = state_71348__$1;
(statearr_71432_71506[(1)] = (4));

(statearr_71432_71506[(5)] = null);

} else {
throw ex71424;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71349 === (14))){
var inst_71284 = (state_71348[(2)]);
var state_71348__$1 = state_71348;
var statearr_71433_71507 = state_71348__$1;
(statearr_71433_71507[(2)] = inst_71284);

(statearr_71433_71507[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71349 === (26))){
var inst_71314 = (state_71348[(2)]);
var state_71348__$1 = (function (){var statearr_71434 = state_71348;
(statearr_71434[(10)] = inst_71314);

return statearr_71434;
})();
var statearr_71435_71508 = state_71348__$1;
(statearr_71435_71508[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71349 === (16))){
var inst_71275 = (state_71348[(8)]);
var state_71348__$1 = state_71348;
if(cljs.core.truth_(inst_71275)){
var statearr_71437_71509 = state_71348__$1;
(statearr_71437_71509[(1)] = (18));

} else {
var statearr_71438_71510 = state_71348__$1;
(statearr_71438_71510[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71349 === (30))){
var inst_71296 = (state_71348[(11)]);
var inst_71297 = (state_71348[(21)]);
var inst_71322 = (state_71348[(15)]);
var inst_71324 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71325 = [inst_71296,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_71326 = (new cljs.core.PersistentVector(null,2,(5),inst_71324,inst_71325,null));
var inst_71327 = cljs.core.assoc_in(inst_71322,inst_71326,inst_71297);
var state_71348__$1 = state_71348;
var statearr_71439_71511 = state_71348__$1;
(statearr_71439_71511[(2)] = inst_71327);

(statearr_71439_71511[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71349 === (10))){
var inst_71275 = (state_71348[(8)]);
var state_71348__$1 = state_71348;
var statearr_71440_71512 = state_71348__$1;
(statearr_71440_71512[(2)] = inst_71275);

(statearr_71440_71512[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71349 === (18))){
var inst_71255 = (state_71348[(17)]);
var inst_71275 = (state_71348[(8)]);
var inst_71293 = (state_71348[(12)]);
var inst_71293__$1 = inst_71275.t;
var inst_71294 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71255,inst_71293__$1);
var inst_71295 = cljs.core.__destructure_map(inst_71294);
var inst_71296 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71295,new cljs.core.Keyword(null,"block","block",664686210));
var inst_71297 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71295,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_71348__$1 = (function (){var statearr_71441 = state_71348;
(statearr_71441[(11)] = inst_71296);

(statearr_71441[(21)] = inst_71297);

(statearr_71441[(12)] = inst_71293__$1);

return statearr_71441;
})();
var statearr_71442_71513 = state_71348__$1;
(statearr_71442_71513[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71349 === (8))){
var inst_71342 = (state_71348[(2)]);
var inst_71343 = cljs.core.vals(inst_71342);
var _ = (function (){var statearr_71444 = state_71348;
(statearr_71444[(4)] = cljs.core.rest((state_71348[(4)])));

return statearr_71444;
})();
var state_71348__$1 = state_71348;
var statearr_71445_71514 = state_71348__$1;
(statearr_71445_71514[(2)] = inst_71343);

(statearr_71445_71514[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__11410__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__11410__auto____0 = (function (){
var statearr_71446 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71446[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__11410__auto__);

(statearr_71446[(1)] = (1));

return statearr_71446;
});
var fluree$db$api$query$format_history_resp_$_state_machine__11410__auto____1 = (function (state_71348){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_71348);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e71447){var ex__11413__auto__ = e71447;
var statearr_71448_71515 = state_71348;
(statearr_71448_71515[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_71348[(4)]))){
var statearr_71449_71516 = state_71348;
(statearr_71449_71516[(1)] = cljs.core.first((state_71348[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71517 = state_71348;
state_71348 = G__71517;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__11410__auto__ = function(state_71348){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__11410__auto____1.call(this,state_71348);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__11410__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__11410__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_71450 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_71450[(6)] = c__11484__auto__);

return statearr_71450;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Convert flakes into vectors.
 *   Notes:
 *   Cannot use IPrintWithWriter override since calls to storage-handler
 *   download blocks using the #Flake format to support internal query
 *   handling.
 */
fluree.db.api.query.block_Flakes__GT_vector = (function fluree$db$api$query$block_Flakes__GT_vector(blocks){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (block){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(block,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.vec,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block)));
}),blocks);
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_71644){
var state_val_71645 = (state_71644[(1)]);
if((state_val_71645 === (7))){
var inst_71540 = (state_71644[(7)]);
var inst_71542 = fluree.db.api.query.resolve_block_range(inst_71540,query_map);
var state_71644__$1 = state_71644;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71644__$1,(10),inst_71542);
} else {
if((state_val_71645 === (20))){
var inst_71569 = (state_71644[(2)]);
var inst_71570 = fluree.db.util.async.throw_err(inst_71569);
var inst_71571 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_71570);
var inst_71572 = (inst_71571 - (1));
var state_71644__$1 = state_71644;
var statearr_71646_71709 = state_71644__$1;
(statearr_71646_71709[(2)] = inst_71572);

(statearr_71646_71709[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71645 === (27))){
var state_71644__$1 = state_71644;
var statearr_71647_71710 = state_71644__$1;
(statearr_71647_71710[(2)] = null);

(statearr_71647_71710[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71645 === (1))){
var state_71644__$1 = state_71644;
var statearr_71648_71711 = state_71644__$1;
(statearr_71648_71711[(2)] = null);

(statearr_71648_71711[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71645 === (24))){
var inst_71579 = (state_71644[(2)]);
var inst_71580 = fluree.db.util.async.throw_err(inst_71579);
var inst_71581 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_71580);
var state_71644__$1 = state_71644;
var statearr_71649_71712 = state_71644__$1;
(statearr_71649_71712[(2)] = inst_71581);

(statearr_71649_71712[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71645 === (39))){
var inst_71616 = (state_71644[(2)]);
var inst_71617 = fluree.db.util.async.throw_err(inst_71616);
var state_71644__$1 = state_71644;
var statearr_71650_71713 = state_71644__$1;
(statearr_71650_71713[(2)] = inst_71617);

(statearr_71650_71713[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71645 === (4))){
var inst_71518 = (state_71644[(2)]);
var state_71644__$1 = state_71644;
var statearr_71651_71714 = state_71644__$1;
(statearr_71651_71714[(2)] = inst_71518);

(statearr_71651_71714[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71645 === (15))){
var inst_71549 = (state_71644[(8)]);
var state_71644__$1 = state_71644;
var statearr_71652_71715 = state_71644__$1;
(statearr_71652_71715[(2)] = inst_71549);

(statearr_71652_71715[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71645 === (21))){
var inst_71540 = (state_71644[(7)]);
var inst_71550 = (state_71644[(9)]);
var inst_71577 = fluree.db.time_travel.as_of_block(inst_71540,inst_71550);
var state_71644__$1 = state_71644;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71644__$1,(24),inst_71577);
} else {
if((state_val_71645 === (31))){
var inst_71534 = (state_71644[(10)]);
var state_71644__$1 = state_71644;
var statearr_71653_71716 = state_71644__$1;
(statearr_71653_71716[(2)] = inst_71534);

(statearr_71653_71716[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71645 === (32))){
var inst_71540 = (state_71644[(7)]);
var inst_71595 = (state_71644[(11)]);
var inst_71600 = (state_71644[(12)]);
var inst_71604 = (state_71644[(2)]);
var inst_71605 = fluree.db.api.query.format_history_resp(inst_71540,inst_71595,inst_71600,inst_71604);
var state_71644__$1 = state_71644;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71644__$1,(29),inst_71605);
} else {
if((state_val_71645 === (40))){
var inst_71595 = (state_71644[(11)]);
var inst_71621 = (state_71644[(13)]);
var inst_71623 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_71624 = cljs.core.count(inst_71595);
var inst_71625 = [inst_71621,inst_71624,(200)];
var inst_71626 = cljs.core.PersistentHashMap.fromArrays(inst_71623,inst_71625);
var state_71644__$1 = state_71644;
var statearr_71654_71717 = state_71644__$1;
(statearr_71654_71717[(2)] = inst_71626);

(statearr_71654_71717[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71645 === (33))){
var inst_71533 = (state_71644[(14)]);
var state_71644__$1 = state_71644;
var statearr_71655_71718 = state_71644__$1;
(statearr_71655_71718[(2)] = inst_71533);

(statearr_71655_71718[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71645 === (13))){
var inst_71639 = (state_71644[(2)]);
var _ = (function (){var statearr_71656 = state_71644;
(statearr_71656[(4)] = cljs.core.rest((state_71644[(4)])));

return statearr_71656;
})();
var state_71644__$1 = state_71644;
var statearr_71657_71719 = state_71644__$1;
(statearr_71657_71719[(2)] = inst_71639);

(statearr_71657_71719[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71645 === (22))){
var inst_71540 = (state_71644[(7)]);
var inst_71583 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_71540);
var state_71644__$1 = state_71644;
var statearr_71658_71720 = state_71644__$1;
(statearr_71658_71720[(2)] = inst_71583);

(statearr_71658_71720[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71645 === (36))){
var inst_71540 = (state_71644[(7)]);
var inst_71608 = (state_71644[(15)]);
var inst_71614 = fluree.db.api.query.format_blocks_resp_pretty(inst_71540,inst_71608);
var state_71644__$1 = state_71644;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71644__$1,(39),inst_71614);
} else {
if((state_val_71645 === (41))){
var inst_71621 = (state_71644[(13)]);
var state_71644__$1 = state_71644;
var statearr_71659_71721 = state_71644__$1;
(statearr_71659_71721[(2)] = inst_71621);

(statearr_71659_71721[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71645 === (29))){
var inst_71533 = (state_71644[(14)]);
var inst_71607 = (state_71644[(2)]);
var inst_71608 = fluree.db.util.async.throw_err(inst_71607);
var state_71644__$1 = (function (){var statearr_71660 = state_71644;
(statearr_71660[(15)] = inst_71608);

return statearr_71660;
})();
if(cljs.core.truth_(inst_71533)){
var statearr_71661_71722 = state_71644__$1;
(statearr_71661_71722[(1)] = (33));

} else {
var statearr_71662_71723 = state_71644__$1;
(statearr_71662_71723[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71645 === (6))){
var inst_71530 = (state_71644[(16)]);
var inst_71539 = (state_71644[(2)]);
var inst_71540 = fluree.db.util.async.throw_err(inst_71539);
var state_71644__$1 = (function (){var statearr_71663 = state_71644;
(statearr_71663[(7)] = inst_71540);

return statearr_71663;
})();
if(cljs.core.truth_(inst_71530)){
var statearr_71664_71724 = state_71644__$1;
(statearr_71664_71724[(1)] = (7));

} else {
var statearr_71665_71725 = state_71644__$1;
(statearr_71665_71725[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71645 === (28))){
var inst_71535 = (state_71644[(17)]);
var inst_71600 = (state_71644[(2)]);
var state_71644__$1 = (function (){var statearr_71666 = state_71644;
(statearr_71666[(12)] = inst_71600);

return statearr_71666;
})();
if(cljs.core.truth_(inst_71535)){
var statearr_71667_71726 = state_71644__$1;
(statearr_71667_71726[(1)] = (30));

} else {
var statearr_71668_71727 = state_71644__$1;
(statearr_71668_71727[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71645 === (25))){
var inst_71536 = (state_71644[(18)]);
var inst_71594 = (state_71644[(2)]);
var inst_71595 = fluree.db.util.async.throw_err(inst_71594);
var state_71644__$1 = (function (){var statearr_71669 = state_71644;
(statearr_71669[(11)] = inst_71595);

return statearr_71669;
})();
if(cljs.core.truth_(inst_71536)){
var statearr_71670_71728 = state_71644__$1;
(statearr_71670_71728[(1)] = (26));

} else {
var statearr_71671_71729 = state_71644__$1;
(statearr_71671_71729[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71645 === (34))){
var inst_71532 = (state_71644[(19)]);
var state_71644__$1 = state_71644;
var statearr_71672_71730 = state_71644__$1;
(statearr_71672_71730[(2)] = inst_71532);

(statearr_71672_71730[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71645 === (17))){
var inst_71540 = (state_71644[(7)]);
var inst_71549 = (state_71644[(8)]);
var inst_71566 = (inst_71549 - (1));
var inst_71567 = fluree.db.time_travel.as_of_block(inst_71540,inst_71566);
var state_71644__$1 = state_71644;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71644__$1,(20),inst_71567);
} else {
if((state_val_71645 === (3))){
var inst_71642 = (state_71644[(2)]);
var state_71644__$1 = state_71644;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71644__$1,inst_71642);
} else {
if((state_val_71645 === (12))){
var inst_71631 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_71632 = ["History query not properly formatted. Provided ",inst_71631].join('');
var inst_71633 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71634 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_71635 = cljs.core.PersistentHashMap.fromArrays(inst_71633,inst_71634);
var inst_71636 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_71632,inst_71635);
var inst_71637 = (function(){throw inst_71636})();
var state_71644__$1 = state_71644;
var statearr_71673_71731 = state_71644__$1;
(statearr_71673_71731[(2)] = inst_71637);

(statearr_71673_71731[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71645 === (2))){
var _ = (function (){var statearr_71674 = state_71644;
(statearr_71674[(4)] = cljs.core.cons((5),(state_71644[(4)])));

return statearr_71674;
})();
var inst_71528 = query_map;
var inst_71529 = cljs.core.__destructure_map(inst_71528);
var inst_71530 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71529,new cljs.core.Keyword(null,"block","block",664686210));
var inst_71531 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71529,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_71532 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71529,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_71533 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71529,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_71534 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71529,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_71535 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71529,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_71536 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71529,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_71537 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71529,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_71644__$1 = (function (){var statearr_71675 = state_71644;
(statearr_71675[(10)] = inst_71534);

(statearr_71675[(16)] = inst_71530);

(statearr_71675[(19)] = inst_71532);

(statearr_71675[(18)] = inst_71536);

(statearr_71675[(20)] = inst_71537);

(statearr_71675[(21)] = inst_71531);

(statearr_71675[(17)] = inst_71535);

(statearr_71675[(14)] = inst_71533);

return statearr_71675;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71644__$1,(6),sources);
} else {
if((state_val_71645 === (23))){
var inst_71540 = (state_71644[(7)]);
var inst_71575 = (state_71644[(22)]);
var inst_71531 = (state_71644[(21)]);
var inst_71585 = (state_71644[(2)]);
var inst_71586 = fluree.db.api.query.get_history_pattern(inst_71531);
var inst_71587 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71586,(0),null);
var inst_71588 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71586,(1),null);
var inst_71589 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_71590 = [inst_71575,inst_71585];
var inst_71591 = cljs.core.PersistentHashMap.fromArrays(inst_71589,inst_71590);
var inst_71592 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_71540,inst_71588,cljs.core._EQ_,inst_71587,inst_71591);
var state_71644__$1 = state_71644;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71644__$1,(25),inst_71592);
} else {
if((state_val_71645 === (35))){
var inst_71612 = (state_71644[(2)]);
var state_71644__$1 = state_71644;
if(cljs.core.truth_(inst_71612)){
var statearr_71676_71732 = state_71644__$1;
(statearr_71676_71732[(1)] = (36));

} else {
var statearr_71677_71733 = state_71644__$1;
(statearr_71677_71733[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71645 === (19))){
var inst_71550 = (state_71644[(9)]);
var inst_71575 = (state_71644[(2)]);
var state_71644__$1 = (function (){var statearr_71678 = state_71644;
(statearr_71678[(22)] = inst_71575);

return statearr_71678;
})();
if(cljs.core.truth_(inst_71550)){
var statearr_71679_71734 = state_71644__$1;
(statearr_71679_71734[(1)] = (21));

} else {
var statearr_71680_71735 = state_71644__$1;
(statearr_71680_71735[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71645 === (11))){
var inst_71549 = (state_71644[(8)]);
var inst_71537 = (state_71644[(20)]);
var inst_71559 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_71537);
var state_71644__$1 = (function (){var statearr_71682 = state_71644;
(statearr_71682[(23)] = inst_71559);

return statearr_71682;
})();
if(cljs.core.truth_(inst_71549)){
var statearr_71683_71736 = state_71644__$1;
(statearr_71683_71736[(1)] = (14));

} else {
var statearr_71684_71737 = state_71644__$1;
(statearr_71684_71737[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71645 === (9))){
var inst_71548 = (state_71644[(2)]);
var inst_71549 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71548,(0),null);
var inst_71550 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71548,(1),null);
var inst_71551 = cljs.core.list(new cljs.core.Keyword(null,"history","history",-247395220));
var inst_71552 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(query_map,new cljs.core.Keyword(null,"block","block",664686210),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"show-auth","show-auth",686103141),new cljs.core.Keyword(null,"showAuth","showAuth",-347871529),new cljs.core.Keyword(null,"opts","opts",155075701)], 0));
var inst_71553 = cljs.core.keys(inst_71552);
var inst_71554 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_71551,inst_71553);
var state_71644__$1 = (function (){var statearr_71685 = state_71644;
(statearr_71685[(9)] = inst_71550);

(statearr_71685[(8)] = inst_71549);

return statearr_71685;
})();
if(inst_71554){
var statearr_71686_71738 = state_71644__$1;
(statearr_71686_71738[(1)] = (11));

} else {
var statearr_71687_71739 = state_71644__$1;
(statearr_71687_71739[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71645 === (5))){
var _ = (function (){var statearr_71688 = state_71644;
(statearr_71688[(4)] = cljs.core.rest((state_71644[(4)])));

return statearr_71688;
})();
var state_71644__$1 = state_71644;
var ex71681 = (state_71644__$1[(2)]);
var statearr_71689_71740 = state_71644__$1;
(statearr_71689_71740[(5)] = ex71681);


if((ex71681 instanceof Error)){
var statearr_71690_71741 = state_71644__$1;
(statearr_71690_71741[(1)] = (4));

(statearr_71690_71741[(5)] = null);

} else {
throw ex71681;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71645 === (14))){
var inst_71549 = (state_71644[(8)]);
var inst_71561 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_71549);
var state_71644__$1 = state_71644;
var statearr_71691_71742 = state_71644__$1;
(statearr_71691_71742[(2)] = inst_71561);

(statearr_71691_71742[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71645 === (26))){
var inst_71536 = (state_71644[(18)]);
var inst_71597 = cljs.core.set(inst_71536);
var state_71644__$1 = state_71644;
var statearr_71692_71743 = state_71644__$1;
(statearr_71692_71743[(2)] = inst_71597);

(statearr_71692_71743[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71645 === (16))){
var inst_71564 = (state_71644[(2)]);
var state_71644__$1 = state_71644;
if(cljs.core.truth_(inst_71564)){
var statearr_71693_71744 = state_71644__$1;
(statearr_71693_71744[(1)] = (17));

} else {
var statearr_71694_71745 = state_71644__$1;
(statearr_71694_71745[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71645 === (38))){
var inst_71559 = (state_71644[(23)]);
var inst_71621 = (state_71644[(2)]);
var state_71644__$1 = (function (){var statearr_71695 = state_71644;
(statearr_71695[(13)] = inst_71621);

return statearr_71695;
})();
if(cljs.core.truth_(inst_71559)){
var statearr_71696_71746 = state_71644__$1;
(statearr_71696_71746[(1)] = (40));

} else {
var statearr_71697_71747 = state_71644__$1;
(statearr_71697_71747[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71645 === (30))){
var inst_71535 = (state_71644[(17)]);
var state_71644__$1 = state_71644;
var statearr_71698_71748 = state_71644__$1;
(statearr_71698_71748[(2)] = inst_71535);

(statearr_71698_71748[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71645 === (10))){
var inst_71544 = (state_71644[(2)]);
var inst_71545 = fluree.db.util.async.throw_err(inst_71544);
var state_71644__$1 = state_71644;
var statearr_71699_71749 = state_71644__$1;
(statearr_71699_71749[(2)] = inst_71545);

(statearr_71699_71749[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71645 === (18))){
var state_71644__$1 = state_71644;
var statearr_71700_71750 = state_71644__$1;
(statearr_71700_71750[(2)] = (-1));

(statearr_71700_71750[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71645 === (42))){
var inst_71629 = (state_71644[(2)]);
var state_71644__$1 = state_71644;
var statearr_71701_71751 = state_71644__$1;
(statearr_71701_71751[(2)] = inst_71629);

(statearr_71701_71751[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71645 === (37))){
var inst_71608 = (state_71644[(15)]);
var inst_71619 = fluree.db.api.query.block_Flakes__GT_vector(inst_71608);
var state_71644__$1 = state_71644;
var statearr_71702_71752 = state_71644__$1;
(statearr_71702_71752[(2)] = inst_71619);

(statearr_71702_71752[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71645 === (8))){
var state_71644__$1 = state_71644;
var statearr_71703_71753 = state_71644__$1;
(statearr_71703_71753[(2)] = null);

(statearr_71703_71753[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__11410__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__11410__auto____0 = (function (){
var statearr_71704 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71704[(0)] = fluree$db$api$query$history_query_async_$_state_machine__11410__auto__);

(statearr_71704[(1)] = (1));

return statearr_71704;
});
var fluree$db$api$query$history_query_async_$_state_machine__11410__auto____1 = (function (state_71644){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_71644);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e71705){var ex__11413__auto__ = e71705;
var statearr_71706_71754 = state_71644;
(statearr_71706_71754[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_71644[(4)]))){
var statearr_71707_71755 = state_71644;
(statearr_71707_71755[(1)] = cljs.core.first((state_71644[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71756 = state_71644;
state_71644 = G__71756;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__11410__auto__ = function(state_71644){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__11410__auto____1.call(this,state_71644);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__11410__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__11410__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_71708 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_71708[(6)] = c__11484__auto__);

return statearr_71708;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_71889){
var state_val_71890 = (state_71889[(1)]);
if((state_val_71890 === (7))){
var inst_71786 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flureeQL], 0));
var inst_71787 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_71786].join('');
var inst_71788 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71789 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_71790 = cljs.core.PersistentHashMap.fromArrays(inst_71788,inst_71789);
var inst_71791 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_71787,inst_71790);
var inst_71792 = (function(){throw inst_71791})();
var state_71889__$1 = state_71889;
var statearr_71891_71970 = state_71889__$1;
(statearr_71891_71970[(2)] = inst_71792);

(statearr_71891_71970[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (20))){
var inst_71824 = (state_71889[(2)]);
var state_71889__$1 = state_71889;
if(cljs.core.truth_(inst_71824)){
var statearr_71892_71971 = state_71889__$1;
(statearr_71892_71971[(1)] = (21));

} else {
var statearr_71893_71972 = state_71889__$1;
(statearr_71893_71972[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (27))){
var inst_71768 = (state_71889[(7)]);
var state_71889__$1 = state_71889;
var statearr_71894_71973 = state_71889__$1;
(statearr_71894_71973[(2)] = inst_71768);

(statearr_71894_71973[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (1))){
var state_71889__$1 = state_71889;
var statearr_71895_71974 = state_71889__$1;
(statearr_71895_71974[(2)] = null);

(statearr_71895_71974[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (24))){
var inst_71830 = (state_71889[(8)]);
var state_71889__$1 = state_71889;
var statearr_71896_71975 = state_71889__$1;
(statearr_71896_71975[(2)] = inst_71830);

(statearr_71896_71975[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (39))){
var inst_71774 = (state_71889[(9)]);
var state_71889__$1 = state_71889;
if(cljs.core.truth_(inst_71774)){
var statearr_71897_71976 = state_71889__$1;
(statearr_71897_71976[(1)] = (42));

} else {
var statearr_71898_71977 = state_71889__$1;
(statearr_71898_71977[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (46))){
var inst_71862 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71863 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_71864 = cljs.core.PersistentHashMap.fromArrays(inst_71862,inst_71863);
var inst_71865 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid query.",inst_71864);
var inst_71866 = (function(){throw inst_71865})();
var state_71889__$1 = state_71889;
var statearr_71899_71978 = state_71889__$1;
(statearr_71899_71978[(2)] = inst_71866);

(statearr_71899_71978[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (4))){
var inst_71758 = (state_71889[(2)]);
var state_71889__$1 = state_71889;
var statearr_71900_71979 = state_71889__$1;
(statearr_71900_71979[(2)] = inst_71758);

(statearr_71900_71979[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (15))){
var inst_71809 = (state_71889[(10)]);
var inst_71771 = (state_71889[(11)]);
var inst_71811 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_71809);
var inst_71812 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_71809);
var inst_71813 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_71809);
var inst_71814 = fluree.db.api.query.get_sources(inst_71811,inst_71812,inst_71813,inst_71771);
var state_71889__$1 = state_71889;
var statearr_71901_71980 = state_71889__$1;
(statearr_71901_71980[(2)] = inst_71814);

(statearr_71901_71980[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (48))){
var inst_71819 = (state_71889[(12)]);
var inst_71873 = (state_71889[(2)]);
var inst_71874 = fluree.db.util.async.throw_err(inst_71873);
var state_71889__$1 = (function (){var statearr_71902 = state_71889;
(statearr_71902[(13)] = inst_71874);

return statearr_71902;
})();
if(cljs.core.truth_(inst_71819)){
var statearr_71903_71981 = state_71889__$1;
(statearr_71903_71981[(1)] = (49));

} else {
var statearr_71904_71982 = state_71889__$1;
(statearr_71904_71982[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (50))){
var inst_71874 = (state_71889[(13)]);
var state_71889__$1 = state_71889;
var statearr_71905_71983 = state_71889__$1;
(statearr_71905_71983[(2)] = inst_71874);

(statearr_71905_71983[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (21))){
var inst_71826 = cljs.core.volatile_BANG_((0));
var state_71889__$1 = state_71889;
var statearr_71906_71984 = state_71889__$1;
(statearr_71906_71984[(2)] = inst_71826);

(statearr_71906_71984[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (31))){
var inst_71772 = (state_71889[(14)]);
var state_71889__$1 = state_71889;
if(cljs.core.truth_(inst_71772)){
var statearr_71907_71985 = state_71889__$1;
(statearr_71907_71985[(1)] = (33));

} else {
var statearr_71908_71986 = state_71889__$1;
(statearr_71908_71986[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (32))){
var inst_71849 = (state_71889[(2)]);
var state_71889__$1 = state_71889;
var statearr_71909_71987 = state_71889__$1;
(statearr_71909_71987[(2)] = inst_71849);

(statearr_71909_71987[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (40))){
var inst_71851 = (state_71889[(15)]);
var state_71889__$1 = state_71889;
var statearr_71910_71988 = state_71889__$1;
(statearr_71910_71988[(2)] = inst_71851);

(statearr_71910_71988[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (33))){
var inst_71772 = (state_71889[(14)]);
var state_71889__$1 = state_71889;
var statearr_71911_71989 = state_71889__$1;
(statearr_71911_71989[(2)] = inst_71772);

(statearr_71911_71989[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (13))){
var inst_71769 = (state_71889[(16)]);
var inst_71798 = (state_71889[(2)]);
var inst_71799 = fluree.db.util.async.throw_err(inst_71798);
var inst_71800 = fluree.db.time_travel.as_of_block(inst_71799,inst_71769);
var state_71889__$1 = state_71889;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71889__$1,(12),inst_71800);
} else {
if((state_val_71890 === (22))){
var state_71889__$1 = state_71889;
var statearr_71912_71990 = state_71889__$1;
(statearr_71912_71990[(2)] = null);

(statearr_71912_71990[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (36))){
var inst_71776 = (state_71889[(17)]);
var state_71889__$1 = state_71889;
var statearr_71913_71991 = state_71889__$1;
(statearr_71913_71991[(2)] = inst_71776);

(statearr_71913_71991[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (41))){
var inst_71859 = (state_71889[(2)]);
var state_71889__$1 = state_71889;
if(cljs.core.truth_(inst_71859)){
var statearr_71914_71992 = state_71889__$1;
(statearr_71914_71992[(1)] = (45));

} else {
var statearr_71915_71993 = state_71889__$1;
(statearr_71915_71993[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (43))){
var inst_71770 = (state_71889[(18)]);
var state_71889__$1 = state_71889;
var statearr_71916_71994 = state_71889__$1;
(statearr_71916_71994[(2)] = inst_71770);

(statearr_71916_71994[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (29))){
var inst_71851 = (state_71889[(15)]);
var inst_71851__$1 = (state_71889[(2)]);
var state_71889__$1 = (function (){var statearr_71917 = state_71889;
(statearr_71917[(15)] = inst_71851__$1);

return statearr_71917;
})();
if(cljs.core.truth_(inst_71851__$1)){
var statearr_71918_71995 = state_71889__$1;
(statearr_71918_71995[(1)] = (39));

} else {
var statearr_71919_71996 = state_71889__$1;
(statearr_71919_71996[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (44))){
var inst_71856 = (state_71889[(2)]);
var state_71889__$1 = state_71889;
var statearr_71920_71997 = state_71889__$1;
(statearr_71920_71997[(2)] = inst_71856);

(statearr_71920_71997[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (6))){
var state_71889__$1 = state_71889;
var statearr_71921_71998 = state_71889__$1;
(statearr_71921_71998[(2)] = null);

(statearr_71921_71998[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (28))){
var inst_71773 = (state_71889[(19)]);
var state_71889__$1 = state_71889;
if(cljs.core.truth_(inst_71773)){
var statearr_71922_71999 = state_71889__$1;
(statearr_71922_71999[(1)] = (30));

} else {
var statearr_71923_72000 = state_71889__$1;
(statearr_71923_72000[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (51))){
var inst_71884 = (state_71889[(2)]);
var _ = (function (){var statearr_71924 = state_71889;
(statearr_71924[(4)] = cljs.core.rest((state_71889[(4)])));

return statearr_71924;
})();
var state_71889__$1 = state_71889;
var statearr_71925_72001 = state_71889__$1;
(statearr_71925_72001[(2)] = inst_71884);

(statearr_71925_72001[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (25))){
var state_71889__$1 = state_71889;
var statearr_71926_72002 = state_71889__$1;
(statearr_71926_72002[(2)] = (1000000));

(statearr_71926_72002[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (34))){
var inst_71776 = (state_71889[(17)]);
var state_71889__$1 = state_71889;
if(cljs.core.truth_(inst_71776)){
var statearr_71927_72003 = state_71889__$1;
(statearr_71927_72003[(1)] = (36));

} else {
var statearr_71928_72004 = state_71889__$1;
(statearr_71928_72004[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (17))){
var inst_71820 = (state_71889[(20)]);
var inst_71775 = (state_71889[(21)]);
var inst_71818 = (state_71889[(2)]);
var inst_71819 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_71775);
var inst_71820__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_71775);
var state_71889__$1 = (function (){var statearr_71929 = state_71889;
(statearr_71929[(12)] = inst_71819);

(statearr_71929[(20)] = inst_71820__$1);

(statearr_71929[(22)] = inst_71818);

return statearr_71929;
})();
if(cljs.core.truth_(inst_71820__$1)){
var statearr_71930_72005 = state_71889__$1;
(statearr_71930_72005[(1)] = (18));

} else {
var statearr_71931_72006 = state_71889__$1;
(statearr_71931_72006[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (3))){
var inst_71887 = (state_71889[(2)]);
var state_71889__$1 = state_71889;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71889__$1,inst_71887);
} else {
if((state_val_71890 === (12))){
var inst_71802 = (state_71889[(2)]);
var inst_71803 = fluree.db.util.async.throw_err(inst_71802);
var state_71889__$1 = state_71889;
var statearr_71932_72007 = state_71889__$1;
(statearr_71932_72007[(2)] = inst_71803);

(statearr_71932_72007[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (2))){
var inst_71774 = (state_71889[(9)]);
var inst_71776 = (state_71889[(17)]);
var inst_71773 = (state_71889[(19)]);
var inst_71772 = (state_71889[(14)]);
var inst_71769 = (state_71889[(16)]);
var inst_71768 = (state_71889[(7)]);
var inst_71767 = (state_71889[(23)]);
var inst_71771 = (state_71889[(11)]);
var inst_71775 = (state_71889[(21)]);
var inst_71770 = (state_71889[(18)]);
var _ = (function (){var statearr_71933 = state_71889;
(statearr_71933[(4)] = cljs.core.cons((5),(state_71889[(4)])));

return statearr_71933;
})();
var inst_71765 = flureeQL;
var inst_71766 = cljs.core.__destructure_map(inst_71765);
var inst_71767__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71766,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_71768__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71766,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_71769__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71766,new cljs.core.Keyword(null,"block","block",664686210));
var inst_71770__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71766,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_71771__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71766,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_71772__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71766,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_71773__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71766,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_71774__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71766,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_71775__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71766,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_71776__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71766,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_71777 = (function (){var construct = inst_71767__$1;
var select = inst_71768__$1;
var block = inst_71769__$1;
var where = inst_71770__$1;
var prefixes = inst_71771__$1;
var map__71764 = inst_71766;
var selectDistinct = inst_71772__$1;
var selectOne = inst_71773__$1;
var from = inst_71774__$1;
var opts = inst_71775__$1;
var selectReduced = inst_71776__$1;
return (function (p1__71757_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__71757_SHARP_);
});
})();
var inst_71778 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71779 = [inst_71768__$1,inst_71773__$1,inst_71772__$1,inst_71776__$1];
var inst_71780 = (new cljs.core.PersistentVector(null,4,(5),inst_71778,inst_71779,null));
var inst_71781 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_71780);
var inst_71782 = cljs.core.count(inst_71781);
var inst_71783 = (inst_71777.cljs$core$IFn$_invoke$arity$1 ? inst_71777.cljs$core$IFn$_invoke$arity$1(inst_71782) : inst_71777.call(null,inst_71782));
var state_71889__$1 = (function (){var statearr_71934 = state_71889;
(statearr_71934[(9)] = inst_71774__$1);

(statearr_71934[(17)] = inst_71776__$1);

(statearr_71934[(19)] = inst_71773__$1);

(statearr_71934[(14)] = inst_71772__$1);

(statearr_71934[(16)] = inst_71769__$1);

(statearr_71934[(7)] = inst_71768__$1);

(statearr_71934[(23)] = inst_71767__$1);

(statearr_71934[(11)] = inst_71771__$1);

(statearr_71934[(21)] = inst_71775__$1);

(statearr_71934[(18)] = inst_71770__$1);

return statearr_71934;
})();
if(cljs.core.truth_(inst_71783)){
var statearr_71935_72008 = state_71889__$1;
(statearr_71935_72008[(1)] = (6));

} else {
var statearr_71936_72009 = state_71889__$1;
(statearr_71936_72009[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (23))){
var inst_71830 = (state_71889[(8)]);
var inst_71775 = (state_71889[(21)]);
var inst_71829 = (state_71889[(2)]);
var inst_71830__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_71775);
var state_71889__$1 = (function (){var statearr_71937 = state_71889;
(statearr_71937[(24)] = inst_71829);

(statearr_71937[(8)] = inst_71830__$1);

return statearr_71937;
})();
if(cljs.core.truth_(inst_71830__$1)){
var statearr_71938_72010 = state_71889__$1;
(statearr_71938_72010[(1)] = (24));

} else {
var statearr_71939_72011 = state_71889__$1;
(statearr_71939_72011[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (47))){
var inst_71835 = (state_71889[(25)]);
var inst_71809 = (state_71889[(10)]);
var inst_71868 = (state_71889[(2)]);
var inst_71869 = fluree.db.util.core.current_time_millis();
var inst_71870 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_71835);
var inst_71871 = fluree.db.query.fql.query(inst_71809,inst_71870);
var state_71889__$1 = (function (){var statearr_71940 = state_71889;
(statearr_71940[(26)] = inst_71868);

(statearr_71940[(27)] = inst_71869);

return statearr_71940;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71889__$1,(48),inst_71871);
} else {
if((state_val_71890 === (35))){
var inst_71847 = (state_71889[(2)]);
var state_71889__$1 = state_71889;
var statearr_71941_72012 = state_71889__$1;
(statearr_71941_72012[(2)] = inst_71847);

(statearr_71941_72012[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (19))){
var inst_71819 = (state_71889[(12)]);
var state_71889__$1 = state_71889;
var statearr_71942_72013 = state_71889__$1;
(statearr_71942_72013[(2)] = inst_71819);

(statearr_71942_72013[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (11))){
var inst_71771 = (state_71889[(11)]);
var inst_71809 = (state_71889[(2)]);
var state_71889__$1 = (function (){var statearr_71944 = state_71889;
(statearr_71944[(10)] = inst_71809);

return statearr_71944;
})();
if(cljs.core.truth_(inst_71771)){
var statearr_71945_72014 = state_71889__$1;
(statearr_71945_72014[(1)] = (15));

} else {
var statearr_71946_72015 = state_71889__$1;
(statearr_71946_72015[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (9))){
var inst_71795 = (state_71889[(28)]);
var state_71889__$1 = state_71889;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71889__$1,(13),inst_71795);
} else {
if((state_val_71890 === (5))){
var _ = (function (){var statearr_71947 = state_71889;
(statearr_71947[(4)] = cljs.core.rest((state_71889[(4)])));

return statearr_71947;
})();
var state_71889__$1 = state_71889;
var ex71943 = (state_71889__$1[(2)]);
var statearr_71948_72016 = state_71889__$1;
(statearr_71948_72016[(5)] = ex71943);


if((ex71943 instanceof Error)){
var statearr_71949_72017 = state_71889__$1;
(statearr_71949_72017[(1)] = (4));

(statearr_71949_72017[(5)] = null);

} else {
throw ex71943;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (14))){
var inst_71806 = (state_71889[(2)]);
var inst_71807 = fluree.db.util.async.throw_err(inst_71806);
var state_71889__$1 = state_71889;
var statearr_71950_72018 = state_71889__$1;
(statearr_71950_72018[(2)] = inst_71807);

(statearr_71950_72018[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (45))){
var state_71889__$1 = state_71889;
var statearr_71951_72019 = state_71889__$1;
(statearr_71951_72019[(2)] = null);

(statearr_71951_72019[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (26))){
var inst_71829 = (state_71889[(24)]);
var inst_71768 = (state_71889[(7)]);
var inst_71775 = (state_71889[(21)]);
var inst_71818 = (state_71889[(22)]);
var inst_71834 = (state_71889[(2)]);
var inst_71835 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_71775,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_71818,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_71834,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_71829], 0));
var state_71889__$1 = (function (){var statearr_71952 = state_71889;
(statearr_71952[(25)] = inst_71835);

return statearr_71952;
})();
if(cljs.core.truth_(inst_71768)){
var statearr_71953_72020 = state_71889__$1;
(statearr_71953_72020[(1)] = (27));

} else {
var statearr_71954_72021 = state_71889__$1;
(statearr_71954_72021[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (16))){
var inst_71816 = cljs.core.PersistentHashMap.EMPTY;
var state_71889__$1 = state_71889;
var statearr_71955_72022 = state_71889__$1;
(statearr_71955_72022[(2)] = inst_71816);

(statearr_71955_72022[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (38))){
var inst_71845 = (state_71889[(2)]);
var state_71889__$1 = state_71889;
var statearr_71956_72023 = state_71889__$1;
(statearr_71956_72023[(2)] = inst_71845);

(statearr_71956_72023[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (30))){
var inst_71773 = (state_71889[(19)]);
var state_71889__$1 = state_71889;
var statearr_71957_72024 = state_71889__$1;
(statearr_71957_72024[(2)] = inst_71773);

(statearr_71957_72024[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (10))){
var inst_71795 = (state_71889[(28)]);
var state_71889__$1 = state_71889;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71889__$1,(14),inst_71795);
} else {
if((state_val_71890 === (18))){
var inst_71820 = (state_71889[(20)]);
var state_71889__$1 = state_71889;
var statearr_71958_72025 = state_71889__$1;
(statearr_71958_72025[(2)] = inst_71820);

(statearr_71958_72025[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (42))){
var inst_71774 = (state_71889[(9)]);
var state_71889__$1 = state_71889;
var statearr_71959_72026 = state_71889__$1;
(statearr_71959_72026[(2)] = inst_71774);

(statearr_71959_72026[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (37))){
var inst_71767 = (state_71889[(23)]);
var state_71889__$1 = state_71889;
var statearr_71960_72027 = state_71889__$1;
(statearr_71960_72027[(2)] = inst_71767);

(statearr_71960_72027[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (8))){
var inst_71769 = (state_71889[(16)]);
var inst_71794 = (state_71889[(2)]);
var inst_71795 = sources;
var state_71889__$1 = (function (){var statearr_71961 = state_71889;
(statearr_71961[(28)] = inst_71795);

(statearr_71961[(29)] = inst_71794);

return statearr_71961;
})();
if(cljs.core.truth_(inst_71769)){
var statearr_71962_72028 = state_71889__$1;
(statearr_71962_72028[(1)] = (9));

} else {
var statearr_71963_72029 = state_71889__$1;
(statearr_71963_72029[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (49))){
var inst_71874 = (state_71889[(13)]);
var inst_71829 = (state_71889[(24)]);
var inst_71809 = (state_71889[(10)]);
var inst_71869 = (state_71889[(27)]);
var inst_71876 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_71877 = cljs.core.deref(inst_71829);
var inst_71878 = fluree.db.util.core.response_time_formatted(inst_71869);
var inst_71879 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_71809);
var inst_71880 = [(200),inst_71874,inst_71877,inst_71878,inst_71879];
var inst_71881 = cljs.core.PersistentHashMap.fromArrays(inst_71876,inst_71880);
var state_71889__$1 = state_71889;
var statearr_71964_72030 = state_71889__$1;
(statearr_71964_72030[(2)] = inst_71881);

(statearr_71964_72030[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__11410__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__11410__auto____0 = (function (){
var statearr_71965 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71965[(0)] = fluree$db$api$query$query_async_$_state_machine__11410__auto__);

(statearr_71965[(1)] = (1));

return statearr_71965;
});
var fluree$db$api$query$query_async_$_state_machine__11410__auto____1 = (function (state_71889){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_71889);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e71966){var ex__11413__auto__ = e71966;
var statearr_71967_72031 = state_71889;
(statearr_71967_72031[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_71889[(4)]))){
var statearr_71968_72032 = state_71889;
(statearr_71968_72032[(1)] = cljs.core.first((state_71889[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72033 = state_71889;
state_71889 = G__72033;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__11410__auto__ = function(state_71889){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__11410__auto____1.call(this,state_71889);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__11410__auto____0;
fluree$db$api$query$query_async_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__11410__auto____1;
return fluree$db$api$query$query_async_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_71969 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_71969[(6)] = c__11484__auto__);

return statearr_71969;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_72174){
var state_val_72175 = (state_72174[(1)]);
if((state_val_72175 === (7))){
var inst_72169 = (state_72174[(2)]);
var _ = (function (){var statearr_72176 = state_72174;
(statearr_72176[(4)] = cljs.core.rest((state_72174[(4)])));

return statearr_72176;
})();
var state_72174__$1 = state_72174;
var statearr_72177_72253 = state_72174__$1;
(statearr_72177_72253[(2)] = inst_72169);

(statearr_72177_72253[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (20))){
var inst_72141 = (state_72174[(2)]);
var state_72174__$1 = state_72174;
var statearr_72178_72254 = state_72174__$1;
(statearr_72178_72254[(2)] = inst_72141);

(statearr_72178_72254[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (27))){
var inst_72121 = (state_72174[(7)]);
var state_72174__$1 = state_72174;
var statearr_72179_72255 = state_72174__$1;
(statearr_72179_72255[(2)] = inst_72121);

(statearr_72179_72255[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (1))){
var state_72174__$1 = state_72174;
var statearr_72180_72256 = state_72174__$1;
(statearr_72180_72256[(2)] = null);

(statearr_72180_72256[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (24))){
var inst_72118 = (state_72174[(8)]);
var state_72174__$1 = state_72174;
var statearr_72181_72257 = state_72174__$1;
(statearr_72181_72257[(2)] = inst_72118);

(statearr_72181_72257[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (39))){
var inst_72108 = (state_72174[(9)]);
var inst_72086 = (state_72174[(10)]);
var inst_72075 = (state_72174[(11)]);
var inst_72152 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72153 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_72086];
var inst_72154 = (new cljs.core.PersistentVector(null,2,(5),inst_72152,inst_72153,null));
var inst_72155 = cljs.core.assoc_in(inst_72075,inst_72154,inst_72108);
var state_72174__$1 = state_72174;
var statearr_72182_72258 = state_72174__$1;
(statearr_72182_72258[(2)] = inst_72155);

(statearr_72182_72258[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (4))){
var inst_72034 = (state_72174[(2)]);
var state_72174__$1 = state_72174;
var statearr_72183_72259 = state_72174__$1;
(statearr_72183_72259[(2)] = inst_72034);

(statearr_72183_72259[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (15))){
var inst_72108 = (state_72174[(9)]);
var inst_72073 = (state_72174[(12)]);
var inst_72111 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_72108);
var inst_72112 = (inst_72073 == null);
var state_72174__$1 = (function (){var statearr_72184 = state_72174;
(statearr_72184[(13)] = inst_72111);

return statearr_72184;
})();
if(cljs.core.truth_(inst_72112)){
var statearr_72185_72260 = state_72174__$1;
(statearr_72185_72260[(1)] = (18));

} else {
var statearr_72186_72261 = state_72174__$1;
(statearr_72186_72261[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (21))){
var inst_72111 = (state_72174[(13)]);
var state_72174__$1 = state_72174;
var statearr_72187_72262 = state_72174__$1;
(statearr_72187_72262[(2)] = inst_72111);

(statearr_72187_72262[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (31))){
var state_72174__$1 = state_72174;
var statearr_72188_72263 = state_72174__$1;
(statearr_72188_72263[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (32))){
var inst_72137 = (state_72174[(2)]);
var state_72174__$1 = state_72174;
var statearr_72190_72264 = state_72174__$1;
(statearr_72190_72264[(2)] = inst_72137);

(statearr_72190_72264[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (40))){
var inst_72106 = (state_72174[(14)]);
var state_72174__$1 = state_72174;
if(cljs.core.truth_(inst_72106)){
var statearr_72191_72265 = state_72174__$1;
(statearr_72191_72265[(1)] = (42));

} else {
var statearr_72192_72266 = state_72174__$1;
(statearr_72192_72266[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (33))){
var inst_72111 = (state_72174[(13)]);
var inst_72073 = (state_72174[(12)]);
var inst_72132 = ((inst_72111 > inst_72073) ? inst_72111 : inst_72073);
var state_72174__$1 = state_72174;
var statearr_72193_72267 = state_72174__$1;
(statearr_72193_72267[(2)] = inst_72132);

(statearr_72193_72267[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (13))){
var inst_72097 = (state_72174[(2)]);
var state_72174__$1 = state_72174;
var statearr_72194_72268 = state_72174__$1;
(statearr_72194_72268[(2)] = inst_72097);

(statearr_72194_72268[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (22))){
var inst_72111 = (state_72174[(13)]);
var inst_72118 = (state_72174[(8)]);
var inst_72118__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_72111);
var state_72174__$1 = (function (){var statearr_72195 = state_72174;
(statearr_72195[(8)] = inst_72118__$1);

return statearr_72195;
})();
if(inst_72118__$1){
var statearr_72196_72269 = state_72174__$1;
(statearr_72196_72269[(1)] = (24));

} else {
var statearr_72197_72270 = state_72174__$1;
(statearr_72197_72270[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (36))){
var inst_72108 = (state_72174[(9)]);
var inst_72074 = (state_72174[(15)]);
var inst_72146 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_72108,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_72147 = (inst_72074 + inst_72146);
var state_72174__$1 = state_72174;
var statearr_72198_72271 = state_72174__$1;
(statearr_72198_72271[(2)] = inst_72147);

(statearr_72198_72271[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (41))){
var inst_72144 = (state_72174[(16)]);
var inst_72150 = (state_72174[(17)]);
var inst_72085 = (state_72174[(18)]);
var inst_72164 = (state_72174[(2)]);
var inst_72072 = inst_72085;
var inst_72073 = inst_72144;
var inst_72074 = inst_72150;
var inst_72075 = inst_72164;
var state_72174__$1 = (function (){var statearr_72199 = state_72174;
(statearr_72199[(15)] = inst_72074);

(statearr_72199[(11)] = inst_72075);

(statearr_72199[(19)] = inst_72072);

(statearr_72199[(12)] = inst_72073);

return statearr_72199;
})();
var statearr_72200_72272 = state_72174__$1;
(statearr_72200_72272[(2)] = null);

(statearr_72200_72272[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (43))){
var inst_72108 = (state_72174[(9)]);
var state_72174__$1 = state_72174;
var statearr_72201_72273 = state_72174__$1;
(statearr_72201_72273[(2)] = inst_72108);

(statearr_72201_72273[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (29))){
var inst_72126 = (state_72174[(2)]);
var state_72174__$1 = state_72174;
var statearr_72202_72274 = state_72174__$1;
(statearr_72202_72274[(2)] = inst_72126);

(statearr_72202_72274[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (44))){
var inst_72086 = (state_72174[(10)]);
var inst_72075 = (state_72174[(11)]);
var inst_72161 = (state_72174[(2)]);
var inst_72162 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_72075,inst_72086,inst_72161);
var state_72174__$1 = state_72174;
var statearr_72203_72275 = state_72174__$1;
(statearr_72203_72275[(2)] = inst_72162);

(statearr_72203_72275[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (6))){
var inst_72087 = (state_72174[(20)]);
var inst_72072 = (state_72174[(19)]);
var inst_72083 = cljs.core.seq(inst_72072);
var inst_72084 = cljs.core.first(inst_72083);
var inst_72085 = cljs.core.next(inst_72083);
var inst_72086 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72084,(0),null);
var inst_72087__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72084,(1),null);
var inst_72088 = (inst_72087__$1 == null);
var state_72174__$1 = (function (){var statearr_72204 = state_72174;
(statearr_72204[(20)] = inst_72087__$1);

(statearr_72204[(10)] = inst_72086);

(statearr_72204[(18)] = inst_72085);

return statearr_72204;
})();
if(cljs.core.truth_(inst_72088)){
var statearr_72205_72276 = state_72174__$1;
(statearr_72205_72276[(1)] = (8));

} else {
var statearr_72206_72277 = state_72174__$1;
(statearr_72206_72277[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (28))){
var inst_72073 = (state_72174[(12)]);
var inst_72124 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((207),inst_72073);
var state_72174__$1 = state_72174;
var statearr_72207_72278 = state_72174__$1;
(statearr_72207_72278[(2)] = inst_72124);

(statearr_72207_72278[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (25))){
var inst_72121 = (state_72174[(7)]);
var inst_72073 = (state_72174[(12)]);
var inst_72121__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_72073);
var state_72174__$1 = (function (){var statearr_72208 = state_72174;
(statearr_72208[(7)] = inst_72121__$1);

return statearr_72208;
})();
if(inst_72121__$1){
var statearr_72209_72279 = state_72174__$1;
(statearr_72209_72279[(1)] = (27));

} else {
var statearr_72210_72280 = state_72174__$1;
(statearr_72210_72280[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (34))){
var state_72174__$1 = state_72174;
var statearr_72211_72281 = state_72174__$1;
(statearr_72211_72281[(2)] = null);

(statearr_72211_72281[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (17))){
var inst_72105 = (state_72174[(21)]);
var inst_72144 = (state_72174[(2)]);
var state_72174__$1 = (function (){var statearr_72212 = state_72174;
(statearr_72212[(16)] = inst_72144);

return statearr_72212;
})();
if(cljs.core.truth_(inst_72105)){
var statearr_72213_72282 = state_72174__$1;
(statearr_72213_72282[(1)] = (36));

} else {
var statearr_72214_72283 = state_72174__$1;
(statearr_72214_72283[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (3))){
var inst_72172 = (state_72174[(2)]);
var state_72174__$1 = state_72174;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72174__$1,inst_72172);
} else {
if((state_val_72175 === (12))){
var inst_72075 = (state_72174[(11)]);
var state_72174__$1 = state_72174;
var statearr_72215_72284 = state_72174__$1;
(statearr_72215_72284[(2)] = inst_72075);

(statearr_72215_72284[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (2))){
var inst_72044 = (state_72174[(22)]);
var inst_72048 = (state_72174[(23)]);
var inst_72049 = (state_72174[(24)]);
var _ = (function (){var statearr_72216 = state_72174;
(statearr_72216[(4)] = cljs.core.cons((5),(state_72174[(4)])));

return statearr_72216;
})();
var inst_72040 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_72041 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72042 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_72043 = (new cljs.core.PersistentVector(null,2,(5),inst_72041,inst_72042,null));
var inst_72044__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(flureeQL,inst_72043);
var inst_72045 = (function (){var global_block = inst_72040;
var global_meta_QMARK_ = inst_72044__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__4253__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__4251__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not(query_meta_QMARK_);
} else {
return and__4251__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_], 0));
var query_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return global_block;
}
})()], 0));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,alias,query_STAR_);
});
})();
var inst_72046 = cljs.core.PersistentHashMap.EMPTY;
var inst_72047 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210)], 0));
var inst_72048__$1 = cljs.core.reduce_kv(inst_72045,inst_72046,inst_72047);
var inst_72049__$1 = fluree.db.util.core.current_time_millis();
var inst_72051 = (function (){var global_block = inst_72040;
var global_meta_QMARK_ = inst_72044__$1;
var queries = inst_72048__$1;
var start_time = inst_72049__$1;
return (function (p__72050){
var vec__72217 = p__72050;
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__72217,(0),null);
var q = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__72217,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,(fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2(source,q) : fluree.db.api.query.query.call(null,source,q))], null);
});
})();
var inst_72052 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_72051,inst_72048__$1);
var inst_72066 = cljs.core.seq(inst_72052);
var inst_72067 = cljs.core.first(inst_72066);
var inst_72068 = cljs.core.next(inst_72066);
var inst_72069 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72067,(0),null);
var inst_72070 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72067,(1),null);
var inst_72071 = cljs.core.PersistentHashMap.EMPTY;
var inst_72072 = inst_72052;
var inst_72073 = null;
var inst_72074 = (0);
var inst_72075 = inst_72071;
var state_72174__$1 = (function (){var statearr_72220 = state_72174;
(statearr_72220[(22)] = inst_72044__$1);

(statearr_72220[(25)] = inst_72070);

(statearr_72220[(15)] = inst_72074);

(statearr_72220[(26)] = inst_72068);

(statearr_72220[(11)] = inst_72075);

(statearr_72220[(19)] = inst_72072);

(statearr_72220[(23)] = inst_72048__$1);

(statearr_72220[(12)] = inst_72073);

(statearr_72220[(24)] = inst_72049__$1);

(statearr_72220[(27)] = inst_72069);

return statearr_72220;
})();
var statearr_72221_72285 = state_72174__$1;
(statearr_72221_72285[(2)] = null);

(statearr_72221_72285[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (23))){
var inst_72139 = (state_72174[(2)]);
var state_72174__$1 = state_72174;
var statearr_72222_72286 = state_72174__$1;
(statearr_72222_72286[(2)] = inst_72139);

(statearr_72222_72286[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (35))){
var inst_72135 = (state_72174[(2)]);
var state_72174__$1 = state_72174;
var statearr_72223_72287 = state_72174__$1;
(statearr_72223_72287[(2)] = inst_72135);

(statearr_72223_72287[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (19))){
var inst_72111 = (state_72174[(13)]);
var inst_72073 = (state_72174[(12)]);
var inst_72115 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_72073,inst_72111);
var state_72174__$1 = state_72174;
if(inst_72115){
var statearr_72224_72288 = state_72174__$1;
(statearr_72224_72288[(1)] = (21));

} else {
var statearr_72225_72289 = state_72174__$1;
(statearr_72225_72289[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (11))){
var inst_72074 = (state_72174[(15)]);
var inst_72075 = (state_72174[(11)]);
var inst_72073 = (state_72174[(12)]);
var inst_72049 = (state_72174[(24)]);
var inst_72091 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_72092 = fluree.db.util.core.response_time_formatted(inst_72049);
var inst_72093 = [inst_72075,inst_72074,inst_72073,inst_72092];
var inst_72094 = cljs.core.PersistentHashMap.fromArrays(inst_72091,inst_72093);
var state_72174__$1 = state_72174;
var statearr_72227_72290 = state_72174__$1;
(statearr_72227_72290[(2)] = inst_72094);

(statearr_72227_72290[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (9))){
var inst_72087 = (state_72174[(20)]);
var inst_72086 = (state_72174[(10)]);
var inst_72048 = (state_72174[(23)]);
var inst_72100 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72101 = [inst_72086,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_72102 = (new cljs.core.PersistentVector(null,2,(5),inst_72100,inst_72101,null));
var inst_72103 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_72048,inst_72102);
var inst_72104 = cljs.core.__destructure_map(inst_72103);
var inst_72105 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72104,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_72106 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72104,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_72174__$1 = (function (){var statearr_72228 = state_72174;
(statearr_72228[(14)] = inst_72106);

(statearr_72228[(21)] = inst_72105);

return statearr_72228;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72174__$1,(14),inst_72087);
} else {
if((state_val_72175 === (5))){
var _ = (function (){var statearr_72229 = state_72174;
(statearr_72229[(4)] = cljs.core.rest((state_72174[(4)])));

return statearr_72229;
})();
var state_72174__$1 = state_72174;
var ex72226 = (state_72174__$1[(2)]);
var statearr_72230_72291 = state_72174__$1;
(statearr_72230_72291[(5)] = ex72226);


var statearr_72231_72292 = state_72174__$1;
(statearr_72231_72292[(1)] = (4));

(statearr_72231_72292[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (14))){
var inst_72108 = (state_72174[(9)]);
var inst_72105 = (state_72174[(21)]);
var inst_72108__$1 = (state_72174[(2)]);
var inst_72109 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_72108__$1);
var state_72174__$1 = (function (){var statearr_72232 = state_72174;
(statearr_72232[(9)] = inst_72108__$1);

(statearr_72232[(28)] = inst_72109);

return statearr_72232;
})();
if(cljs.core.truth_(inst_72105)){
var statearr_72233_72293 = state_72174__$1;
(statearr_72233_72293[(1)] = (15));

} else {
var statearr_72234_72294 = state_72174__$1;
(statearr_72234_72294[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (26))){
var inst_72128 = (state_72174[(2)]);
var state_72174__$1 = state_72174;
if(cljs.core.truth_(inst_72128)){
var statearr_72235_72295 = state_72174__$1;
(statearr_72235_72295[(1)] = (30));

} else {
var statearr_72236_72296 = state_72174__$1;
(statearr_72236_72296[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (16))){
var state_72174__$1 = state_72174;
var statearr_72237_72297 = state_72174__$1;
(statearr_72237_72297[(2)] = null);

(statearr_72237_72297[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (38))){
var inst_72109 = (state_72174[(28)]);
var inst_72150 = (state_72174[(2)]);
var state_72174__$1 = (function (){var statearr_72238 = state_72174;
(statearr_72238[(17)] = inst_72150);

return statearr_72238;
})();
if(cljs.core.truth_(inst_72109)){
var statearr_72239_72298 = state_72174__$1;
(statearr_72239_72298[(1)] = (39));

} else {
var statearr_72240_72299 = state_72174__$1;
(statearr_72240_72299[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (30))){
var state_72174__$1 = state_72174;
var statearr_72241_72300 = state_72174__$1;
(statearr_72241_72300[(2)] = (207));

(statearr_72241_72300[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (10))){
var inst_72167 = (state_72174[(2)]);
var state_72174__$1 = state_72174;
var statearr_72242_72301 = state_72174__$1;
(statearr_72242_72301[(2)] = inst_72167);

(statearr_72242_72301[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (18))){
var inst_72111 = (state_72174[(13)]);
var state_72174__$1 = state_72174;
var statearr_72243_72302 = state_72174__$1;
(statearr_72243_72302[(2)] = inst_72111);

(statearr_72243_72302[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (42))){
var inst_72108 = (state_72174[(9)]);
var inst_72158 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_72108);
var state_72174__$1 = state_72174;
var statearr_72244_72303 = state_72174__$1;
(statearr_72244_72303[(2)] = inst_72158);

(statearr_72244_72303[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (37))){
var state_72174__$1 = state_72174;
var statearr_72245_72304 = state_72174__$1;
(statearr_72245_72304[(2)] = null);

(statearr_72245_72304[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72175 === (8))){
var inst_72044 = (state_72174[(22)]);
var state_72174__$1 = state_72174;
if(cljs.core.truth_(inst_72044)){
var statearr_72246_72305 = state_72174__$1;
(statearr_72246_72305[(1)] = (11));

} else {
var statearr_72247_72306 = state_72174__$1;
(statearr_72247_72306[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__11410__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__11410__auto____0 = (function (){
var statearr_72248 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72248[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__11410__auto__);

(statearr_72248[(1)] = (1));

return statearr_72248;
});
var fluree$db$api$query$multi_query_async_$_state_machine__11410__auto____1 = (function (state_72174){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_72174);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e72249){var ex__11413__auto__ = e72249;
var statearr_72250_72307 = state_72174;
(statearr_72250_72307[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_72174[(4)]))){
var statearr_72251_72308 = state_72174;
(statearr_72251_72308[(1)] = cljs.core.first((state_72174[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72309 = state_72174;
state_72174 = G__72309;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__11410__auto__ = function(state_72174){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__11410__auto____1.call(this,state_72174);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__11410__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__11410__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_72252 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_72252[(6)] = c__11484__auto__);

return statearr_72252;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type(flureeQL);
var G__72310 = query_type;
var G__72310__$1 = (((G__72310 instanceof cljs.core.Keyword))?G__72310.fqn:null);
switch (G__72310__$1) {
case "standard":
return fluree.db.api.query.query_async(source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async(source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async(conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async(source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__72310__$1)].join('')));

}
});
