// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__77625 = arguments.length;
switch (G__77625) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5751__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5751__auto__)){
var block = temp__5751__auto__;
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__11484__auto___77664 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_77646){
var state_val_77647 = (state_77646[(1)]);
if((state_val_77647 === (1))){
var state_77646__$1 = state_77646;
var statearr_77648_77665 = state_77646__$1;
(statearr_77648_77665[(2)] = null);

(statearr_77648_77665[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77647 === (2))){
var _ = (function (){var statearr_77649 = state_77646;
(statearr_77649[(4)] = cljs.core.cons((5),(state_77646[(4)])));

return statearr_77649;
})();
var inst_77632 = fluree.db.session.db(conn,ledger,null);
var state_77646__$1 = state_77646;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77646__$1,(7),inst_77632);
} else {
if((state_val_77647 === (3))){
var inst_77642 = (state_77646[(2)]);
var inst_77643 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_77642);
var inst_77644 = cljs.core.async.close_BANG_(pc);
var state_77646__$1 = (function (){var statearr_77651 = state_77646;
(statearr_77651[(7)] = inst_77643);

return statearr_77651;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_77646__$1,inst_77644);
} else {
if((state_val_77647 === (4))){
var inst_77626 = (state_77646[(2)]);
var state_77646__$1 = state_77646;
var statearr_77652_77666 = state_77646__$1;
(statearr_77652_77666[(2)] = inst_77626);

(statearr_77652_77666[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77647 === (5))){
var _ = (function (){var statearr_77653 = state_77646;
(statearr_77653[(4)] = cljs.core.rest((state_77646[(4)])));

return statearr_77653;
})();
var state_77646__$1 = state_77646;
var ex77650 = (state_77646__$1[(2)]);
var statearr_77654_77667 = state_77646__$1;
(statearr_77654_77667[(5)] = ex77650);


var statearr_77655_77668 = state_77646__$1;
(statearr_77655_77668[(1)] = (4));

(statearr_77655_77668[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77647 === (6))){
var inst_77638 = (state_77646[(2)]);
var inst_77639 = fluree.db.util.async.throw_err(inst_77638);
var _ = (function (){var statearr_77656 = state_77646;
(statearr_77656[(4)] = cljs.core.rest((state_77646[(4)])));

return statearr_77656;
})();
var state_77646__$1 = state_77646;
var statearr_77657_77669 = state_77646__$1;
(statearr_77657_77669[(2)] = inst_77639);

(statearr_77657_77669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77647 === (7))){
var inst_77634 = (state_77646[(2)]);
var inst_77635 = fluree.db.util.async.throw_err(inst_77634);
var inst_77636 = fluree.db.time_travel.as_of_block(inst_77635,block);
var state_77646__$1 = state_77646;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77646__$1,(6),inst_77636);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__11410__auto__ = null;
var fluree$db$api$ledger$state_machine__11410__auto____0 = (function (){
var statearr_77658 = [null,null,null,null,null,null,null,null];
(statearr_77658[(0)] = fluree$db$api$ledger$state_machine__11410__auto__);

(statearr_77658[(1)] = (1));

return statearr_77658;
});
var fluree$db$api$ledger$state_machine__11410__auto____1 = (function (state_77646){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_77646);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e77659){var ex__11413__auto__ = e77659;
var statearr_77660_77670 = state_77646;
(statearr_77660_77670[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_77646[(4)]))){
var statearr_77661_77671 = state_77646;
(statearr_77661_77671[(1)] = cljs.core.first((state_77646[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77672 = state_77646;
state_77646 = G__77672;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__11410__auto__ = function(state_77646){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__11410__auto____1.call(this,state_77646);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__11410__auto____0;
fluree$db$api$ledger$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__11410__auto____1;
return fluree$db$api$ledger$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_77662 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_77662[(6)] = c__11484__auto___77664);

return statearr_77662;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));


return pc;
} else {
return fluree.db.session.db(conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t(db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_77713){
var state_val_77714 = (state_77713[(1)]);
if((state_val_77714 === (7))){
var inst_77682 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_77713__$1 = state_77713;
if(inst_77682){
var statearr_77715_77746 = state_77713__$1;
(statearr_77715_77746[(1)] = (9));

} else {
var statearr_77716_77747 = state_77713__$1;
(statearr_77716_77747[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77714 === (1))){
var state_77713__$1 = state_77713;
var statearr_77717_77748 = state_77713__$1;
(statearr_77717_77748[(2)] = null);

(statearr_77717_77748[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77714 === (4))){
var inst_77673 = (state_77713[(2)]);
var state_77713__$1 = state_77713;
var statearr_77718_77749 = state_77713__$1;
(statearr_77718_77749[(2)] = inst_77673);

(statearr_77718_77749[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77714 === (15))){
var inst_77690 = (state_77713[(7)]);
var inst_77689 = (state_77713[(2)]);
var inst_77690__$1 = fluree.db.util.async.throw_err(inst_77689);
var state_77713__$1 = (function (){var statearr_77719 = state_77713;
(statearr_77719[(7)] = inst_77690__$1);

return statearr_77719;
})();
if(cljs.core.truth_(inst_77690__$1)){
var statearr_77720_77750 = state_77713__$1;
(statearr_77720_77750[(1)] = (16));

} else {
var statearr_77721_77751 = state_77713__$1;
(statearr_77721_77751[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77714 === (13))){
var state_77713__$1 = state_77713;
var statearr_77722_77752 = state_77713__$1;
(statearr_77722_77752[(2)] = null);

(statearr_77722_77752[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77714 === (6))){
var state_77713__$1 = state_77713;
var statearr_77723_77753 = state_77713__$1;
(statearr_77723_77753[(2)] = db);

(statearr_77723_77753[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77714 === (17))){
var inst_77694 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_77695 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_77696 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_77697 = cljs.core.PersistentHashMap.fromArrays(inst_77695,inst_77696);
var inst_77698 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_77694,inst_77697);
var inst_77699 = (function(){throw inst_77698})();
var state_77713__$1 = state_77713;
var statearr_77724_77754 = state_77713__$1;
(statearr_77724_77754[(2)] = inst_77699);

(statearr_77724_77754[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77714 === (3))){
var inst_77711 = (state_77713[(2)]);
var state_77713__$1 = state_77713;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77713__$1,inst_77711);
} else {
if((state_val_77714 === (12))){
var inst_77687 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_77713__$1 = state_77713;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77713__$1,(15),inst_77687);
} else {
if((state_val_77714 === (2))){
var _ = (function (){var statearr_77725 = state_77713;
(statearr_77725[(4)] = cljs.core.cons((5),(state_77713[(4)])));

return statearr_77725;
})();
var inst_77679 = cljs.core.not(auth);
var state_77713__$1 = state_77713;
if(inst_77679){
var statearr_77726_77755 = state_77713__$1;
(statearr_77726_77755[(1)] = (6));

} else {
var statearr_77727_77756 = state_77713__$1;
(statearr_77727_77756[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77714 === (11))){
var inst_77706 = (state_77713[(2)]);
var state_77713__$1 = state_77713;
var statearr_77729_77757 = state_77713__$1;
(statearr_77729_77757[(2)] = inst_77706);

(statearr_77729_77757[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77714 === (9))){
var inst_77684 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_77713__$1 = state_77713;
var statearr_77730_77758 = state_77713__$1;
(statearr_77730_77758[(2)] = inst_77684);

(statearr_77730_77758[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77714 === (5))){
var _ = (function (){var statearr_77731 = state_77713;
(statearr_77731[(4)] = cljs.core.rest((state_77713[(4)])));

return statearr_77731;
})();
var state_77713__$1 = state_77713;
var ex77728 = (state_77713__$1[(2)]);
var statearr_77732_77759 = state_77713__$1;
(statearr_77732_77759[(5)] = ex77728);


if((ex77728 instanceof Error)){
var statearr_77733_77760 = state_77713__$1;
(statearr_77733_77760[(1)] = (4));

(statearr_77733_77760[(5)] = null);

} else {
throw ex77728;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77714 === (14))){
var inst_77704 = (state_77713[(2)]);
var state_77713__$1 = state_77713;
var statearr_77734_77761 = state_77713__$1;
(statearr_77734_77761[(2)] = inst_77704);

(statearr_77734_77761[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77714 === (16))){
var inst_77690 = (state_77713[(7)]);
var inst_77692 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_77690);
var state_77713__$1 = state_77713;
var statearr_77735_77762 = state_77713__$1;
(statearr_77735_77762[(2)] = inst_77692);

(statearr_77735_77762[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77714 === (10))){
var state_77713__$1 = state_77713;
var statearr_77736_77763 = state_77713__$1;
(statearr_77736_77763[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77714 === (18))){
var inst_77701 = (state_77713[(2)]);
var state_77713__$1 = state_77713;
var statearr_77738_77764 = state_77713__$1;
(statearr_77738_77764[(2)] = inst_77701);

(statearr_77738_77764[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77714 === (8))){
var inst_77708 = (state_77713[(2)]);
var _ = (function (){var statearr_77739 = state_77713;
(statearr_77739[(4)] = cljs.core.rest((state_77713[(4)])));

return statearr_77739;
})();
var state_77713__$1 = state_77713;
var statearr_77740_77765 = state_77713__$1;
(statearr_77740_77765[(2)] = inst_77708);

(statearr_77740_77765[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11410__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11410__auto____0 = (function (){
var statearr_77741 = [null,null,null,null,null,null,null,null];
(statearr_77741[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11410__auto__);

(statearr_77741[(1)] = (1));

return statearr_77741;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11410__auto____1 = (function (state_77713){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_77713);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e77742){var ex__11413__auto__ = e77742;
var statearr_77743_77766 = state_77713;
(statearr_77743_77766[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_77713[(4)]))){
var statearr_77744_77767 = state_77713;
(statearr_77744_77767[(1)] = cljs.core.first((state_77713[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77768 = state_77713;
state_77713 = G__77768;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11410__auto__ = function(state_77713){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11410__auto____1.call(this,state_77713);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11410__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11410__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_77745 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_77745[(6)] = c__11484__auto__);

return statearr_77745;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_77832){
var state_val_77833 = (state_77832[(1)]);
if((state_val_77833 === (7))){
var inst_77778 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_77832__$1 = state_77832;
if(inst_77778){
var statearr_77834_77883 = state_77832__$1;
(statearr_77834_77883[(1)] = (9));

} else {
var statearr_77835_77884 = state_77832__$1;
(statearr_77835_77884[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77833 === (20))){
var inst_77802 = (state_77832[(7)]);
var state_77832__$1 = state_77832;
if(cljs.core.truth_(inst_77802)){
var statearr_77836_77885 = state_77832__$1;
(statearr_77836_77885[(1)] = (22));

} else {
var statearr_77837_77886 = state_77832__$1;
(statearr_77837_77886[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77833 === (27))){
var state_77832__$1 = state_77832;
var statearr_77838_77887 = state_77832__$1;
(statearr_77838_77887[(2)] = null);

(statearr_77838_77887[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77833 === (1))){
var state_77832__$1 = state_77832;
var statearr_77839_77888 = state_77832__$1;
(statearr_77839_77888[(2)] = null);

(statearr_77839_77888[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77833 === (24))){
var inst_77816 = (state_77832[(2)]);
var state_77832__$1 = state_77832;
var statearr_77840_77889 = state_77832__$1;
(statearr_77840_77889[(2)] = inst_77816);

(statearr_77840_77889[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77833 === (4))){
var inst_77769 = (state_77832[(2)]);
var state_77832__$1 = state_77832;
var statearr_77841_77890 = state_77832__$1;
(statearr_77841_77890[(2)] = inst_77769);

(statearr_77841_77890[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77833 === (15))){
var inst_77785 = (state_77832[(8)]);
var inst_77784 = (state_77832[(2)]);
var inst_77785__$1 = fluree.db.util.async.throw_err(inst_77784);
var state_77832__$1 = (function (){var statearr_77842 = state_77832;
(statearr_77842[(8)] = inst_77785__$1);

return statearr_77842;
})();
if(cljs.core.truth_(inst_77785__$1)){
var statearr_77843_77891 = state_77832__$1;
(statearr_77843_77891[(1)] = (16));

} else {
var statearr_77844_77892 = state_77832__$1;
(statearr_77844_77892[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77833 === (21))){
var inst_77818 = (state_77832[(9)]);
var inst_77818__$1 = (state_77832[(2)]);
var state_77832__$1 = (function (){var statearr_77845 = state_77832;
(statearr_77845[(9)] = inst_77818__$1);

return statearr_77845;
})();
if(cljs.core.truth_(inst_77818__$1)){
var statearr_77846_77893 = state_77832__$1;
(statearr_77846_77893[(1)] = (29));

} else {
var statearr_77847_77894 = state_77832__$1;
(statearr_77847_77894[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77833 === (31))){
var inst_77802 = (state_77832[(7)]);
var inst_77818 = (state_77832[(9)]);
var inst_77826 = (state_77832[(2)]);
var inst_77827 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_77802,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"roles","roles",143379530),inst_77818,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_77826], 0));
var _ = (function (){var statearr_77848 = state_77832;
(statearr_77848[(4)] = cljs.core.rest((state_77832[(4)])));

return statearr_77848;
})();
var state_77832__$1 = state_77832;
var statearr_77849_77895 = state_77832__$1;
(statearr_77849_77895[(2)] = inst_77827);

(statearr_77849_77895[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77833 === (32))){
var inst_77822 = (state_77832[(2)]);
var inst_77823 = fluree.db.util.async.throw_err(inst_77822);
var state_77832__$1 = state_77832;
var statearr_77850_77896 = state_77832__$1;
(statearr_77850_77896[(2)] = inst_77823);

(statearr_77850_77896[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77833 === (13))){
var state_77832__$1 = state_77832;
var statearr_77851_77897 = state_77832__$1;
(statearr_77851_77897[(2)] = null);

(statearr_77851_77897[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77833 === (22))){
var inst_77802 = (state_77832[(7)]);
var inst_77806 = fluree.db.auth.roles(db,inst_77802);
var state_77832__$1 = state_77832;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77832__$1,(25),inst_77806);
} else {
if((state_val_77833 === (29))){
var inst_77818 = (state_77832[(9)]);
var inst_77820 = fluree.db.permissions.permission_map(db,inst_77818,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_77832__$1 = state_77832;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77832__$1,(32),inst_77820);
} else {
if((state_val_77833 === (6))){
var state_77832__$1 = state_77832;
var statearr_77852_77898 = state_77832__$1;
(statearr_77852_77898[(2)] = null);

(statearr_77852_77898[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77833 === (28))){
var inst_77814 = (state_77832[(2)]);
var state_77832__$1 = state_77832;
var statearr_77853_77899 = state_77832__$1;
(statearr_77853_77899[(2)] = inst_77814);

(statearr_77853_77899[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77833 === (25))){
var inst_77808 = (state_77832[(2)]);
var inst_77809 = fluree.db.util.async.throw_err(inst_77808);
var state_77832__$1 = state_77832;
var statearr_77854_77900 = state_77832__$1;
(statearr_77854_77900[(2)] = inst_77809);

(statearr_77854_77900[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77833 === (17))){
var inst_77788 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_77789 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_77790 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_77791 = cljs.core.PersistentHashMap.fromArrays(inst_77789,inst_77790);
var inst_77792 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_77788,inst_77791);
var inst_77793 = (function(){throw inst_77792})();
var state_77832__$1 = state_77832;
var statearr_77855_77901 = state_77832__$1;
(statearr_77855_77901[(2)] = inst_77793);

(statearr_77855_77901[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77833 === (3))){
var inst_77830 = (state_77832[(2)]);
var state_77832__$1 = state_77832;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77832__$1,inst_77830);
} else {
if((state_val_77833 === (12))){
var inst_77782 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_77832__$1 = state_77832;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77832__$1,(15),inst_77782);
} else {
if((state_val_77833 === (2))){
var _ = (function (){var statearr_77856 = state_77832;
(statearr_77856[(4)] = cljs.core.cons((5),(state_77832[(4)])));

return statearr_77856;
})();
var inst_77775 = (auth == null);
var state_77832__$1 = state_77832;
if(cljs.core.truth_(inst_77775)){
var statearr_77857_77902 = state_77832__$1;
(statearr_77857_77902[(1)] = (6));

} else {
var statearr_77858_77903 = state_77832__$1;
(statearr_77858_77903[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77833 === (23))){
var state_77832__$1 = state_77832;
var statearr_77859_77904 = state_77832__$1;
(statearr_77859_77904[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77833 === (19))){
var state_77832__$1 = state_77832;
var statearr_77861_77905 = state_77832__$1;
(statearr_77861_77905[(2)] = roles);

(statearr_77861_77905[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77833 === (11))){
var inst_77800 = (state_77832[(2)]);
var state_77832__$1 = state_77832;
var statearr_77863_77906 = state_77832__$1;
(statearr_77863_77906[(2)] = inst_77800);

(statearr_77863_77906[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77833 === (9))){
var state_77832__$1 = state_77832;
var statearr_77864_77907 = state_77832__$1;
(statearr_77864_77907[(2)] = (0));

(statearr_77864_77907[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77833 === (5))){
var _ = (function (){var statearr_77865 = state_77832;
(statearr_77865[(4)] = cljs.core.rest((state_77832[(4)])));

return statearr_77865;
})();
var state_77832__$1 = state_77832;
var ex77862 = (state_77832__$1[(2)]);
var statearr_77866_77908 = state_77832__$1;
(statearr_77866_77908[(5)] = ex77862);


if((ex77862 instanceof Error)){
var statearr_77867_77909 = state_77832__$1;
(statearr_77867_77909[(1)] = (4));

(statearr_77867_77909[(5)] = null);

} else {
throw ex77862;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77833 === (14))){
var inst_77798 = (state_77832[(2)]);
var state_77832__$1 = state_77832;
var statearr_77868_77910 = state_77832__$1;
(statearr_77868_77910[(2)] = inst_77798);

(statearr_77868_77910[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77833 === (26))){
var state_77832__$1 = state_77832;
var statearr_77869_77911 = state_77832__$1;
(statearr_77869_77911[(2)] = null);

(statearr_77869_77911[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77833 === (16))){
var inst_77785 = (state_77832[(8)]);
var state_77832__$1 = state_77832;
var statearr_77870_77912 = state_77832__$1;
(statearr_77870_77912[(2)] = inst_77785);

(statearr_77870_77912[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77833 === (30))){
var state_77832__$1 = state_77832;
var statearr_77871_77913 = state_77832__$1;
(statearr_77871_77913[(2)] = null);

(statearr_77871_77913[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77833 === (10))){
var state_77832__$1 = state_77832;
if(cljs.core.truth_(auth)){
var statearr_77872_77914 = state_77832__$1;
(statearr_77872_77914[(1)] = (12));

} else {
var statearr_77873_77915 = state_77832__$1;
(statearr_77873_77915[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77833 === (18))){
var inst_77795 = (state_77832[(2)]);
var state_77832__$1 = state_77832;
var statearr_77874_77916 = state_77832__$1;
(statearr_77874_77916[(2)] = inst_77795);

(statearr_77874_77916[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77833 === (8))){
var inst_77802 = (state_77832[(2)]);
var state_77832__$1 = (function (){var statearr_77875 = state_77832;
(statearr_77875[(7)] = inst_77802);

return statearr_77875;
})();
if(cljs.core.truth_(roles)){
var statearr_77876_77917 = state_77832__$1;
(statearr_77876_77917[(1)] = (19));

} else {
var statearr_77877_77918 = state_77832__$1;
(statearr_77877_77918[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__11410__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__11410__auto____0 = (function (){
var statearr_77878 = [null,null,null,null,null,null,null,null,null,null];
(statearr_77878[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__11410__auto__);

(statearr_77878[(1)] = (1));

return statearr_77878;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__11410__auto____1 = (function (state_77832){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_77832);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e77879){var ex__11413__auto__ = e77879;
var statearr_77880_77919 = state_77832;
(statearr_77880_77919[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_77832[(4)]))){
var statearr_77881_77920 = state_77832;
(statearr_77881_77920[(1)] = cljs.core.first((state_77832[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77921 = state_77832;
state_77832 = G__77921;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__11410__auto__ = function(state_77832){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__11410__auto____1.call(this,state_77832);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__11410__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__11410__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_77882 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_77882[(6)] = c__11484__auto__);

return statearr_77882;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__77922 = db;
var map__77922__$1 = cljs.core.__destructure_map(map__77922);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77922__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77922__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77922__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NEW EVENT:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([evt], 0)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([data], 0))], 0));

if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener(conn,network,dbid,listen_id);

var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_77929){
var state_val_77930 = (state_77929[(1)]);
if((state_val_77930 === (1))){
var inst_77923 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_77924 = fluree.db.session.db(conn,inst_77923,null);
var state_77929__$1 = state_77929;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77929__$1,(2),inst_77924);
} else {
if((state_val_77930 === (2))){
var inst_77926 = (state_77929[(2)]);
var inst_77927 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_77926);
var state_77929__$1 = state_77929;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77929__$1,inst_77927);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__11410__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__11410__auto____0 = (function (){
var statearr_77931 = [null,null,null,null,null,null,null];
(statearr_77931[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__11410__auto__);

(statearr_77931[(1)] = (1));

return statearr_77931;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__11410__auto____1 = (function (state_77929){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_77929);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e77932){var ex__11413__auto__ = e77932;
var statearr_77933_77960 = state_77929;
(statearr_77933_77960[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_77929[(4)]))){
var statearr_77934_77961 = state_77929;
(statearr_77934_77961[(1)] = cljs.core.first((state_77929[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77962 = state_77929;
state_77929 = G__77962;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__11410__auto__ = function(state_77929){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__11410__auto____1.call(this,state_77929);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__11410__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__11410__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_77935 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_77935[(6)] = c__11484__auto__);

return statearr_77935;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener(conn,network,dbid,listen_id,event_fn);

var c__11484__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_77948){
var state_val_77949 = (state_77948[(1)]);
if((state_val_77949 === (1))){
var inst_77936 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_77937 = fluree.db.session.db(conn,inst_77936,null);
var state_77948__$1 = state_77948;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77948__$1,(2),inst_77937);
} else {
if((state_val_77949 === (2))){
var inst_77939 = (state_77948[(7)]);
var inst_77939__$1 = (state_77948[(2)]);
var inst_77940 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_77939__$1);
var inst_77941 = newer_block_QMARK_(inst_77940);
var state_77948__$1 = (function (){var statearr_77950 = state_77948;
(statearr_77950[(7)] = inst_77939__$1);

return statearr_77950;
})();
if(inst_77941){
var statearr_77951_77963 = state_77948__$1;
(statearr_77951_77963[(1)] = (3));

} else {
var statearr_77952_77964 = state_77948__$1;
(statearr_77952_77964[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77949 === (3))){
var inst_77939 = (state_77948[(7)]);
var inst_77943 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_77939);
var state_77948__$1 = state_77948;
var statearr_77953_77965 = state_77948__$1;
(statearr_77953_77965[(2)] = inst_77943);

(statearr_77953_77965[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77949 === (4))){
var state_77948__$1 = state_77948;
var statearr_77954_77966 = state_77948__$1;
(statearr_77954_77966[(2)] = null);

(statearr_77954_77966[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77949 === (5))){
var inst_77946 = (state_77948[(2)]);
var state_77948__$1 = state_77948;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77948__$1,inst_77946);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__11410__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__11410__auto____0 = (function (){
var statearr_77955 = [null,null,null,null,null,null,null,null];
(statearr_77955[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__11410__auto__);

(statearr_77955[(1)] = (1));

return statearr_77955;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__11410__auto____1 = (function (state_77948){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_77948);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e77956){var ex__11413__auto__ = e77956;
var statearr_77957_77967 = state_77948;
(statearr_77957_77967[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_77948[(4)]))){
var statearr_77958_77968 = state_77948;
(statearr_77958_77968[(1)] = cljs.core.first((state_77948[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77969 = state_77948;
state_77948 = G__77969;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__11410__auto__ = function(state_77948){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__11410__auto____1.call(this,state_77948);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__11410__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__11410__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_77959 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_77959[(6)] = c__11484__auto__);

return statearr_77959;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

return c__11484__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_(syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var map__77970 = db;
var map__77970__$1 = cljs.core.__destructure_map(map__77970);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77970__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77970__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77970__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var listen_id = fluree.db.util.core.random_uuid();
var timeout = ((cljs.core.pos_int_QMARK_(syncTimeout))?(function (){var x__4339__auto__ = syncTimeout;
var y__4340__auto__ = (120000);
return ((x__4339__auto__ < y__4340__auto__) ? x__4339__auto__ : y__4340__auto__);
})():(60000));
var res_port = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,db);
} else {
fluree.db.api.ledger.syncTo_wait(db,syncTo,listen_id,res_port);

var c__11484__auto___78046 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_78020){
var state_val_78021 = (state_78020[(1)]);
if((state_val_78021 === (7))){
var inst_77986 = (state_78020[(7)]);
var inst_77997 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_77986,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_78020__$1 = state_78020;
if(inst_77997){
var statearr_78022_78047 = state_78020__$1;
(statearr_78022_78047[(1)] = (9));

} else {
var statearr_78023_78048 = state_78020__$1;
(statearr_78023_78048[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78021 === (1))){
var inst_77971 = (state_78020[(8)]);
var inst_77979 = (state_78020[(9)]);
var inst_77971__$1 = cljs.core.async.timeout(timeout);
var inst_77979__$1 = res_port;
var inst_77980 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77981 = [inst_77971__$1,inst_77979__$1];
var inst_77982 = (new cljs.core.PersistentVector(null,2,(5),inst_77980,inst_77981,null));
var state_78020__$1 = (function (){var statearr_78024 = state_78020;
(statearr_78024[(8)] = inst_77971__$1);

(statearr_78024[(9)] = inst_77979__$1);

return statearr_78024;
})();
return cljs.core.async.ioc_alts_BANG_(state_78020__$1,(2),inst_77982);
} else {
if((state_val_78021 === (4))){
var inst_77986 = (state_78020[(7)]);
var inst_77979 = (state_78020[(9)]);
var inst_77990 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_77986,inst_77979);
var state_78020__$1 = state_78020;
if(inst_77990){
var statearr_78025_78049 = state_78020__$1;
(statearr_78025_78049[(1)] = (6));

} else {
var statearr_78026_78050 = state_78020__$1;
(statearr_78026_78050[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78021 === (13))){
var inst_78005 = (state_78020[(10)]);
var inst_78016 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_78005);
var state_78020__$1 = state_78020;
var statearr_78027_78051 = state_78020__$1;
(statearr_78027_78051[(2)] = inst_78016);

(statearr_78027_78051[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78021 === (6))){
var inst_77984 = (state_78020[(11)]);
var inst_77995 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_77984,(0),null);
var state_78020__$1 = state_78020;
var statearr_78028_78052 = state_78020__$1;
(statearr_78028_78052[(2)] = inst_77995);

(statearr_78028_78052[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78021 === (3))){
var state_78020__$1 = state_78020;
var statearr_78029_78053 = state_78020__$1;
(statearr_78029_78053[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_78029_78053[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78021 === (12))){
var inst_78009 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_78010 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_78011 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_78012 = cljs.core.PersistentHashMap.fromArrays(inst_78010,inst_78011);
var inst_78013 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_78009,inst_78012);
var inst_78014 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_78013);
var state_78020__$1 = state_78020;
var statearr_78030_78054 = state_78020__$1;
(statearr_78030_78054[(2)] = inst_78014);

(statearr_78030_78054[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78021 === (2))){
var inst_77971 = (state_78020[(8)]);
var inst_77986 = (state_78020[(7)]);
var inst_77984 = (state_78020[(11)]);
var inst_77984__$1 = (state_78020[(2)]);
var inst_77985 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_77984__$1,(0),null);
var inst_77986__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_77984__$1,(1),null);
var inst_77987 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_77986__$1,inst_77971);
var state_78020__$1 = (function (){var statearr_78031 = state_78020;
(statearr_78031[(7)] = inst_77986__$1);

(statearr_78031[(12)] = inst_77985);

(statearr_78031[(11)] = inst_77984__$1);

return statearr_78031;
})();
if(inst_77987){
var statearr_78032_78055 = state_78020__$1;
(statearr_78032_78055[(1)] = (3));

} else {
var statearr_78033_78056 = state_78020__$1;
(statearr_78033_78056[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78021 === (11))){
var inst_78001 = (state_78020[(2)]);
var state_78020__$1 = state_78020;
var statearr_78034_78057 = state_78020__$1;
(statearr_78034_78057[(2)] = inst_78001);

(statearr_78034_78057[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78021 === (9))){
var inst_77985 = (state_78020[(12)]);
var state_78020__$1 = state_78020;
var statearr_78035_78058 = state_78020__$1;
(statearr_78035_78058[(2)] = inst_77985);

(statearr_78035_78058[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78021 === (5))){
var inst_78005 = (state_78020[(10)]);
var inst_78005__$1 = (state_78020[(2)]);
var inst_78006 = fluree.db.connection.remove_listener(conn,network,dbid,listen_id);
var inst_78007 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_78005__$1);
var state_78020__$1 = (function (){var statearr_78036 = state_78020;
(statearr_78036[(13)] = inst_78006);

(statearr_78036[(10)] = inst_78005__$1);

return statearr_78036;
})();
if(inst_78007){
var statearr_78037_78059 = state_78020__$1;
(statearr_78037_78059[(1)] = (12));

} else {
var statearr_78038_78060 = state_78020__$1;
(statearr_78038_78060[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78021 === (14))){
var inst_78018 = (state_78020[(2)]);
var state_78020__$1 = state_78020;
return cljs.core.async.impl.ioc_helpers.return_chan(state_78020__$1,inst_78018);
} else {
if((state_val_78021 === (10))){
var state_78020__$1 = state_78020;
var statearr_78039_78061 = state_78020__$1;
(statearr_78039_78061[(2)] = null);

(statearr_78039_78061[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78021 === (8))){
var inst_78003 = (state_78020[(2)]);
var state_78020__$1 = state_78020;
var statearr_78040_78062 = state_78020__$1;
(statearr_78040_78062[(2)] = inst_78003);

(statearr_78040_78062[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__11410__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__11410__auto____0 = (function (){
var statearr_78041 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78041[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__11410__auto__);

(statearr_78041[(1)] = (1));

return statearr_78041;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__11410__auto____1 = (function (state_78020){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_78020);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e78042){var ex__11413__auto__ = e78042;
var statearr_78043_78063 = state_78020;
(statearr_78043_78063[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_78020[(4)]))){
var statearr_78044_78064 = state_78020;
(statearr_78044_78064[(1)] = cljs.core.first((state_78020[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78065 = state_78020;
state_78020 = G__78065;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__11410__auto__ = function(state_78020){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__11410__auto____1.call(this,state_78020);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__11410__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__11410__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_78045 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_78045[(6)] = c__11484__auto___78046);

return statearr_78045;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__78067 = arguments.length;
switch (G__78067) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__78068){
var map__78069 = p__78068;
var map__78069__$1 = cljs.core.__destructure_map(map__78069);
var opts = map__78069__$1;
var roles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78069__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78069__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78069__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78069__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78069__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__11484__auto___78158 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11485__auto__ = (function (){var switch__11409__auto__ = (function (state_78120){
var state_val_78121 = (state_78120[(1)]);
if((state_val_78121 === (7))){
var inst_78082 = (state_78120[(7)]);
var inst_78084 = fluree.db.api.ledger.syncTo_db(inst_78082,syncTo,syncTimeout);
var state_78120__$1 = state_78120;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78120__$1,(10),inst_78084);
} else {
if((state_val_78121 === (20))){
var inst_78106 = (state_78120[(8)]);
var state_78120__$1 = state_78120;
var statearr_78122_78159 = state_78120__$1;
(statearr_78122_78159[(2)] = inst_78106);

(statearr_78122_78159[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78121 === (1))){
var state_78120__$1 = state_78120;
var statearr_78123_78160 = state_78120__$1;
(statearr_78123_78160[(2)] = null);

(statearr_78123_78160[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78121 === (4))){
var inst_78070 = (state_78120[(2)]);
var inst_78071 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_78070);
var inst_78072 = cljs.core.async.close_BANG_(pc);
var state_78120__$1 = (function (){var statearr_78124 = state_78120;
(statearr_78124[(9)] = inst_78071);

return statearr_78124;
})();
var statearr_78125_78161 = state_78120__$1;
(statearr_78125_78161[(2)] = inst_78072);

(statearr_78125_78161[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78121 === (15))){
var inst_78098 = (state_78120[(10)]);
var inst_78100 = fluree.db.api.ledger.add_db_permissions(inst_78098,auth,roles);
var state_78120__$1 = state_78120;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78120__$1,(18),inst_78100);
} else {
if((state_val_78121 === (21))){
var inst_78114 = (state_78120[(2)]);
var inst_78115 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_78114);
var _ = (function (){var statearr_78126 = state_78120;
(statearr_78126[(4)] = cljs.core.rest((state_78120[(4)])));

return statearr_78126;
})();
var state_78120__$1 = state_78120;
var statearr_78127_78162 = state_78120__$1;
(statearr_78127_78162[(2)] = inst_78115);

(statearr_78127_78162[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78121 === (13))){
var inst_78098 = (state_78120[(2)]);
var state_78120__$1 = (function (){var statearr_78128 = state_78120;
(statearr_78128[(10)] = inst_78098);

return statearr_78128;
})();
if(cljs.core.truth_(roles)){
var statearr_78129_78163 = state_78120__$1;
(statearr_78129_78163[(1)] = (15));

} else {
var statearr_78130_78164 = state_78120__$1;
(statearr_78130_78164[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78121 === (22))){
var inst_78110 = (state_78120[(2)]);
var inst_78111 = fluree.db.util.async.throw_err(inst_78110);
var state_78120__$1 = state_78120;
var statearr_78131_78165 = state_78120__$1;
(statearr_78131_78165[(2)] = inst_78111);

(statearr_78131_78165[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78121 === (6))){
var inst_78081 = (state_78120[(2)]);
var inst_78082 = fluree.db.util.async.throw_err(inst_78081);
var state_78120__$1 = (function (){var statearr_78132 = state_78120;
(statearr_78132[(7)] = inst_78082);

return statearr_78132;
})();
if(cljs.core.truth_(syncTo)){
var statearr_78133_78166 = state_78120__$1;
(statearr_78133_78166[(1)] = (7));

} else {
var statearr_78134_78167 = state_78120__$1;
(statearr_78134_78167[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78121 === (17))){
var inst_78106 = (state_78120[(2)]);
var state_78120__$1 = (function (){var statearr_78135 = state_78120;
(statearr_78135[(8)] = inst_78106);

return statearr_78135;
})();
if(cljs.core.truth_(auth)){
var statearr_78136_78168 = state_78120__$1;
(statearr_78136_78168[(1)] = (19));

} else {
var statearr_78137_78169 = state_78120__$1;
(statearr_78137_78169[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78121 === (3))){
var inst_78118 = (state_78120[(2)]);
var state_78120__$1 = state_78120;
return cljs.core.async.impl.ioc_helpers.return_chan(state_78120__$1,inst_78118);
} else {
if((state_val_78121 === (12))){
var inst_78090 = (state_78120[(11)]);
var state_78120__$1 = state_78120;
var statearr_78138_78170 = state_78120__$1;
(statearr_78138_78170[(2)] = inst_78090);

(statearr_78138_78170[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78121 === (2))){
var _ = (function (){var statearr_78139 = state_78120;
(statearr_78139[(4)] = cljs.core.cons((5),(state_78120[(4)])));

return statearr_78139;
})();
var inst_78079 = fluree.db.session.db(conn,ledger,opts_SINGLEQUOTE_);
var state_78120__$1 = state_78120;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78120__$1,(6),inst_78079);
} else {
if((state_val_78121 === (19))){
var inst_78106 = (state_78120[(8)]);
var inst_78108 = fluree.db.api.ledger.add_db_permissions(inst_78106,auth,roles);
var state_78120__$1 = state_78120;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78120__$1,(22),inst_78108);
} else {
if((state_val_78121 === (11))){
var inst_78090 = (state_78120[(11)]);
var inst_78092 = fluree.db.time_travel.as_of_block(inst_78090,block);
var state_78120__$1 = state_78120;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78120__$1,(14),inst_78092);
} else {
if((state_val_78121 === (9))){
var inst_78090 = (state_78120[(2)]);
var state_78120__$1 = (function (){var statearr_78141 = state_78120;
(statearr_78141[(11)] = inst_78090);

return statearr_78141;
})();
if(cljs.core.truth_(block)){
var statearr_78142_78171 = state_78120__$1;
(statearr_78142_78171[(1)] = (11));

} else {
var statearr_78143_78172 = state_78120__$1;
(statearr_78143_78172[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78121 === (5))){
var _ = (function (){var statearr_78144 = state_78120;
(statearr_78144[(4)] = cljs.core.rest((state_78120[(4)])));

return statearr_78144;
})();
var state_78120__$1 = state_78120;
var ex78140 = (state_78120__$1[(2)]);
var statearr_78145_78173 = state_78120__$1;
(statearr_78145_78173[(5)] = ex78140);


var statearr_78146_78174 = state_78120__$1;
(statearr_78146_78174[(1)] = (4));

(statearr_78146_78174[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78121 === (14))){
var inst_78094 = (state_78120[(2)]);
var inst_78095 = fluree.db.util.async.throw_err(inst_78094);
var state_78120__$1 = state_78120;
var statearr_78147_78175 = state_78120__$1;
(statearr_78147_78175[(2)] = inst_78095);

(statearr_78147_78175[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78121 === (16))){
var inst_78098 = (state_78120[(10)]);
var state_78120__$1 = state_78120;
var statearr_78148_78176 = state_78120__$1;
(statearr_78148_78176[(2)] = inst_78098);

(statearr_78148_78176[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78121 === (10))){
var inst_78086 = (state_78120[(2)]);
var inst_78087 = fluree.db.util.async.throw_err(inst_78086);
var state_78120__$1 = state_78120;
var statearr_78149_78177 = state_78120__$1;
(statearr_78149_78177[(2)] = inst_78087);

(statearr_78149_78177[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78121 === (18))){
var inst_78102 = (state_78120[(2)]);
var inst_78103 = fluree.db.util.async.throw_err(inst_78102);
var state_78120__$1 = state_78120;
var statearr_78150_78178 = state_78120__$1;
(statearr_78150_78178[(2)] = inst_78103);

(statearr_78150_78178[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78121 === (8))){
var inst_78082 = (state_78120[(7)]);
var state_78120__$1 = state_78120;
var statearr_78151_78179 = state_78120__$1;
(statearr_78151_78179[(2)] = inst_78082);

(statearr_78151_78179[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__11410__auto__ = null;
var fluree$db$api$ledger$state_machine__11410__auto____0 = (function (){
var statearr_78152 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78152[(0)] = fluree$db$api$ledger$state_machine__11410__auto__);

(statearr_78152[(1)] = (1));

return statearr_78152;
});
var fluree$db$api$ledger$state_machine__11410__auto____1 = (function (state_78120){
while(true){
var ret_value__11411__auto__ = (function (){try{while(true){
var result__11412__auto__ = switch__11409__auto__(state_78120);
if(cljs.core.keyword_identical_QMARK_(result__11412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11412__auto__;
}
break;
}
}catch (e78153){var ex__11413__auto__ = e78153;
var statearr_78154_78180 = state_78120;
(statearr_78154_78180[(2)] = ex__11413__auto__);


if(cljs.core.seq((state_78120[(4)]))){
var statearr_78155_78181 = state_78120;
(statearr_78155_78181[(1)] = cljs.core.first((state_78120[(4)])));

} else {
throw ex__11413__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11411__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78182 = state_78120;
state_78120 = G__78182;
continue;
} else {
return ret_value__11411__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__11410__auto__ = function(state_78120){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__11410__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__11410__auto____1.call(this,state_78120);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__11410__auto____0;
fluree$db$api$ledger$state_machine__11410__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__11410__auto____1;
return fluree$db$api$ledger$state_machine__11410__auto__;
})()
})();
var state__11486__auto__ = (function (){var statearr_78156 = (f__11485__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11485__auto__.cljs$core$IFn$_invoke$arity$0() : f__11485__auto__.call(null));
(statearr_78156[(6)] = c__11484__auto___78158);

return statearr_78156;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11486__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

