// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('flureeworker');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.session');
goog.require('fluree.db.connection');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('goog.object');
goog.require('fluree.db.connection_js');
flureeworker.conn_register = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
flureeworker.postMessage = (function flureeworker$postMessage(message){
return self.postMessage(cljs.core.clj__GT_js(message));
});
flureeworker.conn_id__GT_db = (function flureeworker$conn_id__GT_db(conn_id,time){
var map__63569 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__63569__$1 = cljs.core.__destructure_map(map__63569);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63569__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63569__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"block","block",664686210),time], null));
});
/**
 * Parses a (nested) JavaScript object into a Clojure map
 */
flureeworker.obj__GT_clj = (function flureeworker$obj__GT_clj(obj){
if(cljs.core.truth_(goog.isObject(obj))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (result,key){
var v = goog.object.get(obj,key);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("function",goog.typeOf(v))){
return result;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(key),(flureeworker.obj__GT_clj.cljs$core$IFn$_invoke$arity$1 ? flureeworker.obj__GT_clj.cljs$core$IFn$_invoke$arity$1(v) : flureeworker.obj__GT_clj.call(null,v)));
}
}),cljs.core.PersistentArrayMap.EMPTY,goog.object.getKeys(obj));
} else {
return obj;
}
});
if((typeof flureeworker !== 'undefined') && (typeof flureeworker.worker_action !== 'undefined')){
} else {
flureeworker.worker_action = (function (){var method_table__4701__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4702__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4703__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4704__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4705__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__63570 = cljs.core.get_global_hierarchy;
return (fexpr__63570.cljs$core$IFn$_invoke$arity$0 ? fexpr__63570.cljs$core$IFn$_invoke$arity$0() : fexpr__63570.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("flureeworker","worker-action"),(function() { 
var G__63571__delegate = function (conn_id,event,_){
return event;
};
var G__63571 = function (conn_id,event,var_args){
var _ = null;
if (arguments.length > 2) {
var G__63572__i = 0, G__63572__a = new Array(arguments.length -  2);
while (G__63572__i < G__63572__a.length) {G__63572__a[G__63572__i] = arguments[G__63572__i + 2]; ++G__63572__i;}
  _ = new cljs.core.IndexedSeq(G__63572__a,0,null);
} 
return G__63571__delegate.call(this,conn_id,event,_);};
G__63571.cljs$lang$maxFixedArity = 2;
G__63571.cljs$lang$applyTo = (function (arglist__63573){
var conn_id = cljs.core.first(arglist__63573);
arglist__63573 = cljs.core.next(arglist__63573);
var event = cljs.core.first(arglist__63573);
var _ = cljs.core.rest(arglist__63573);
return G__63571__delegate(conn_id,event,_);
});
G__63571.cljs$core$IFn$_invoke$arity$variadic = G__63571__delegate;
return G__63571;
})()
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4705__auto__,method_table__4701__auto__,prefer_table__4702__auto__,method_cache__4703__auto__,cached_hierarchy__4704__auto__));
})();
}
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"setState","setState",552299271),(function (conn_id,_,id,state_update){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"setState",new cljs.core.Keyword(null,"ref","ref",1289896967),id,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(state_update)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connStatus","connStatus",63327857),(function (conn_id,_,id,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connStatus",new cljs.core.Keyword(null,"ref","ref",1289896967),id,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"login","login",55217519),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"login",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"pwGenerate",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connClosed","connClosed",1810797125),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connClosed",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),response], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connReset","connReset",-1382938159),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connReset",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),response], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"setTransact","setTransact",1791803585),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"setTransact",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connInit","connInit",-148647574),(function (_,___$1){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"conn","conn",278309663),(0),new cljs.core.Keyword(null,"event","event",301435442),"connInit"], null));
}));
/**
 * Send an error map back to the worker invoker
 */
flureeworker.error_return_map = (function flureeworker$error_return_map(error){
var default_error = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"message","message",-406056002),(function (){var or__4212__auto__ = cljs.core.ex_message(error);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return "Unknown Error.";
}
})(),new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
var e_map = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([default_error,cljs.core.ex_data(error)], 0));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),e_map,new cljs.core.Keyword(null,"status","status",-1997798413),"error"], null);
});
/**
 * Process a query for a specific component id and return result with a :setState call.
 */
flureeworker.process_query = (function flureeworker$process_query(conn_id,id,conn_opts){
var flureeql = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995),id], null));
var jwt = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null));
var opts_SINGLEQUOTE_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([conn_opts,new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(flureeql)], 0)),new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt);
if(cljs.core.truth_(flureeql)){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_63591){
var state_val_63592 = (state_63591[(1)]);
if((state_val_63592 === (1))){
var inst_63574 = new cljs.core.Keyword(null,"forceTime","forceTime",827124337).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var inst_63575 = flureeworker.conn_id__GT_db(conn_id,inst_63574);
var inst_63576 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeql,new cljs.core.Keyword(null,"opts","opts",155075701),opts_SINGLEQUOTE_);
var inst_63577 = fluree.db.api.query.query(inst_63575,inst_63576);
var state_63591__$1 = state_63591;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63591__$1,(2),inst_63577);
} else {
if((state_val_63592 === (2))){
var inst_63579 = (state_63591[(7)]);
var inst_63579__$1 = (state_63591[(2)]);
var inst_63580 = fluree.db.util.core.exception_QMARK_(inst_63579__$1);
var state_63591__$1 = (function (){var statearr_63593 = state_63591;
(statearr_63593[(7)] = inst_63579__$1);

return statearr_63593;
})();
if(inst_63580){
var statearr_63594_63607 = state_63591__$1;
(statearr_63594_63607[(1)] = (3));

} else {
var statearr_63595_63608 = state_63591__$1;
(statearr_63595_63608[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63592 === (3))){
var inst_63579 = (state_63591[(7)]);
var inst_63582 = flureeworker.error_return_map(inst_63579);
var state_63591__$1 = state_63591;
var statearr_63596_63609 = state_63591__$1;
(statearr_63596_63609[(2)] = inst_63582);

(statearr_63596_63609[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63592 === (4))){
var inst_63579 = (state_63591[(7)]);
var inst_63584 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_63585 = [inst_63579,"loaded"];
var inst_63586 = cljs.core.PersistentHashMap.fromArrays(inst_63584,inst_63585);
var state_63591__$1 = state_63591;
var statearr_63597_63610 = state_63591__$1;
(statearr_63597_63610[(2)] = inst_63586);

(statearr_63597_63610[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63592 === (5))){
var inst_63588 = (state_63591[(2)]);
var inst_63589 = (function (){var G__63598 = conn_id;
var G__63599 = new cljs.core.Keyword(null,"setState","setState",552299271);
var G__63600 = id;
var G__63601 = inst_63588;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63598,G__63599,G__63600,G__63601) : flureeworker.worker_action.call(null,G__63598,G__63599,G__63600,G__63601));
})();
var state_63591__$1 = state_63591;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63591__$1,inst_63589);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$process_query_$_state_machine__2717__auto__ = null;
var flureeworker$process_query_$_state_machine__2717__auto____0 = (function (){
var statearr_63602 = [null,null,null,null,null,null,null,null];
(statearr_63602[(0)] = flureeworker$process_query_$_state_machine__2717__auto__);

(statearr_63602[(1)] = (1));

return statearr_63602;
});
var flureeworker$process_query_$_state_machine__2717__auto____1 = (function (state_63591){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_63591);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e63603){var ex__2720__auto__ = e63603;
var statearr_63604_63611 = state_63591;
(statearr_63604_63611[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_63591[(4)]))){
var statearr_63605_63612 = state_63591;
(statearr_63605_63612[(1)] = cljs.core.first((state_63591[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63613 = state_63591;
state_63591 = G__63613;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
flureeworker$process_query_$_state_machine__2717__auto__ = function(state_63591){
switch(arguments.length){
case 0:
return flureeworker$process_query_$_state_machine__2717__auto____0.call(this);
case 1:
return flureeworker$process_query_$_state_machine__2717__auto____1.call(this,state_63591);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$process_query_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$process_query_$_state_machine__2717__auto____0;
flureeworker$process_query_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$process_query_$_state_machine__2717__auto____1;
return flureeworker$process_query_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_63606 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_63606[(6)] = c__2739__auto__);

return statearr_63606;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
} else {
return null;
}
});
/**
 * Re-execute every registered query.
 */
flureeworker.process_all_queries = (function flureeworker$process_all_queries(conn_id){
var map__63614 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__63614__$1 = cljs.core.__destructure_map(map__63614);
var queries = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63614__$1,new cljs.core.Keyword(null,"queries","queries",1446291995));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63614__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var query_ids = cljs.core.keys(queries);
var seq__63615 = cljs.core.seq(query_ids);
var chunk__63616 = null;
var count__63617 = (0);
var i__63618 = (0);
while(true){
if((i__63618 < count__63617)){
var id = chunk__63616.cljs$core$IIndexed$_nth$arity$2(null,i__63618);
flureeworker.process_query(conn_id,id,opts);


var G__63619 = seq__63615;
var G__63620 = chunk__63616;
var G__63621 = count__63617;
var G__63622 = (i__63618 + (1));
seq__63615 = G__63619;
chunk__63616 = G__63620;
count__63617 = G__63621;
i__63618 = G__63622;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__63615);
if(temp__5753__auto__){
var seq__63615__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__63615__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__63615__$1);
var G__63623 = cljs.core.chunk_rest(seq__63615__$1);
var G__63624 = c__4638__auto__;
var G__63625 = cljs.core.count(c__4638__auto__);
var G__63626 = (0);
seq__63615 = G__63623;
chunk__63616 = G__63624;
count__63617 = G__63625;
i__63618 = G__63626;
continue;
} else {
var id = cljs.core.first(seq__63615__$1);
flureeworker.process_query(conn_id,id,opts);


var G__63627 = cljs.core.next(seq__63615__$1);
var G__63628 = null;
var G__63629 = (0);
var G__63630 = (0);
seq__63615 = G__63627;
chunk__63616 = G__63628;
count__63617 = G__63629;
i__63618 = G__63630;
continue;
}
} else {
return null;
}
}
break;
}
});
flureeworker.ledger_listener = (function flureeworker$ledger_listener(conn,ledger,conn_id){
var vec__63631 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63631,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63631,(1),null);
var cb = (function (header,data){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_63639){
var state_val_63640 = (state_63639[(1)]);
if((state_val_63640 === (1))){
var inst_63634 = cljs.core.async.timeout((100));
var state_63639__$1 = state_63639;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63639__$1,(2),inst_63634);
} else {
if((state_val_63640 === (2))){
var inst_63636 = (state_63639[(2)]);
var inst_63637 = flureeworker.process_all_queries(conn_id);
var state_63639__$1 = (function (){var statearr_63641 = state_63639;
(statearr_63641[(7)] = inst_63636);

return statearr_63641;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_63639__$1,inst_63637);
} else {
return null;
}
}
});
return (function() {
var flureeworker$ledger_listener_$_state_machine__2717__auto__ = null;
var flureeworker$ledger_listener_$_state_machine__2717__auto____0 = (function (){
var statearr_63642 = [null,null,null,null,null,null,null,null];
(statearr_63642[(0)] = flureeworker$ledger_listener_$_state_machine__2717__auto__);

(statearr_63642[(1)] = (1));

return statearr_63642;
});
var flureeworker$ledger_listener_$_state_machine__2717__auto____1 = (function (state_63639){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_63639);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e63643){var ex__2720__auto__ = e63643;
var statearr_63644_63647 = state_63639;
(statearr_63644_63647[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_63639[(4)]))){
var statearr_63645_63648 = state_63639;
(statearr_63645_63648[(1)] = cljs.core.first((state_63639[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63649 = state_63639;
state_63639 = G__63649;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
flureeworker$ledger_listener_$_state_machine__2717__auto__ = function(state_63639){
switch(arguments.length){
case 0:
return flureeworker$ledger_listener_$_state_machine__2717__auto____0.call(this);
case 1:
return flureeworker$ledger_listener_$_state_machine__2717__auto____1.call(this,state_63639);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$ledger_listener_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$ledger_listener_$_state_machine__2717__auto____0;
flureeworker$ledger_listener_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$ledger_listener_$_state_machine__2717__auto____1;
return flureeworker$ledger_listener_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_63646 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_63646[(6)] = c__2739__auto__);

return statearr_63646;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
return fluree.db.connection.add_listener(conn,network,ledger_id,conn_id,cb);
});
flureeworker.remove_conn_listener = (function flureeworker$remove_conn_listener(conn,conn_id,ledger){
var vec__63650 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63650,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63650,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,conn_id);
});
/**
 * Registers new connection with all of its items.
 */
flureeworker.register_connection = (function flureeworker$register_connection(conn,config,queries){
var map__63653 = config;
var map__63653__$1 = cljs.core.__destructure_map(map__63653);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63653__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63653__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63653__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var log = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63653__$1,new cljs.core.Keyword(null,"log","log",-1595516004));
var compact = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63653__$1,new cljs.core.Keyword(null,"compact","compact",-348732150));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63653__$1,new cljs.core.Keyword(null,"private","private",-558947994));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc,id,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"closed","closed",-919675359),new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"queries","queries",1446291995),new cljs.core.Keyword(null,"log","log",-1595516004),new cljs.core.Keyword(null,"conn","conn",278309663)],[false,ledger,private$,config,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"compact","compact",-348732150),compact], null),servers,(function (){var or__4212__auto__ = queries;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),log,conn]));
});
/**
 * Creates a new connection from existing configuration
 */
flureeworker.connect_STAR_ = (function flureeworker$connect_STAR_(conn_id,ref){
var conn_data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__63654 = conn_data;
var map__63654__$1 = cljs.core.__destructure_map(map__63654);
var config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63654__$1,new cljs.core.Keyword(null,"config","config",994861415));
var queries = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63654__$1,new cljs.core.Keyword(null,"queries","queries",1446291995));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63654__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var map__63655 = config;
var map__63655__$1 = cljs.core.__destructure_map(map__63655);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63655__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63655__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63655__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var keepAlive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63655__$1,new cljs.core.Keyword(null,"keepAlive","keepAlive",-12888007));
var cb = (cljs.core.truth_(keepAlive)?(function (){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_63661){
var state_val_63662 = (state_63661[(1)]);
if((state_val_63662 === (1))){
var inst_63656 = cljs.core.async.timeout((100));
var state_63661__$1 = state_63661;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63661__$1,(2),inst_63656);
} else {
if((state_val_63662 === (2))){
var inst_63658 = (state_63661[(2)]);
var inst_63659 = (flureeworker.connect_STAR_.cljs$core$IFn$_invoke$arity$2 ? flureeworker.connect_STAR_.cljs$core$IFn$_invoke$arity$2(id,ref) : flureeworker.connect_STAR_.call(null,id,ref));
var state_63661__$1 = (function (){var statearr_63663 = state_63661;
(statearr_63663[(7)] = inst_63658);

return statearr_63663;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_63661__$1,inst_63659);
} else {
return null;
}
}
});
return (function() {
var flureeworker$connect_STAR__$_state_machine__2717__auto__ = null;
var flureeworker$connect_STAR__$_state_machine__2717__auto____0 = (function (){
var statearr_63664 = [null,null,null,null,null,null,null,null];
(statearr_63664[(0)] = flureeworker$connect_STAR__$_state_machine__2717__auto__);

(statearr_63664[(1)] = (1));

return statearr_63664;
});
var flureeworker$connect_STAR__$_state_machine__2717__auto____1 = (function (state_63661){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_63661);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e63665){var ex__2720__auto__ = e63665;
var statearr_63666_63677 = state_63661;
(statearr_63666_63677[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_63661[(4)]))){
var statearr_63667_63678 = state_63661;
(statearr_63667_63678[(1)] = cljs.core.first((state_63661[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63679 = state_63661;
state_63661 = G__63679;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
flureeworker$connect_STAR__$_state_machine__2717__auto__ = function(state_63661){
switch(arguments.length){
case 0:
return flureeworker$connect_STAR__$_state_machine__2717__auto____0.call(this);
case 1:
return flureeworker$connect_STAR__$_state_machine__2717__auto____1.call(this,state_63661);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$connect_STAR__$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$connect_STAR__$_state_machine__2717__auto____0;
flureeworker$connect_STAR__$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$connect_STAR__$_state_machine__2717__auto____1;
return flureeworker$connect_STAR__$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_63668 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_63668[(6)] = c__2739__auto__);

return statearr_63668;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}):null);
var opts = cljs.core.assoc_in(config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)], null),cb);
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers,opts).then((function (conn){
if(cljs.core.truth_(jwt)){
fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
} else {
}

flureeworker.register_connection(conn,config,queries);

flureeworker.ledger_listener(conn,ledger,id);

var G__63669_63680 = conn_id;
var G__63670_63681 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__63671_63682 = ref;
var G__63672_63683 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection reset"], null);
(flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63669_63680,G__63670_63681,G__63671_63682,G__63672_63683) : flureeworker.worker_action.call(null,G__63669_63680,G__63670_63681,G__63671_63682,G__63672_63683));

return flureeworker.process_all_queries(conn_id);
})).catch((function (error){
var error_data = (function (){var temp__5751__auto__ = cljs.core.ex_data(error);
if(cljs.core.truth_(temp__5751__auto__)){
var ex_data = temp__5751__auto__;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4212__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(ex_data);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (500);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(error)], null),ex_data], 0));
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),["Unexpected error: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error], 0))].join('')], null);
}
})();
var G__63673 = conn_id;
var G__63674 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__63675 = ref;
var G__63676 = error_data;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63673,G__63674,G__63675,G__63676) : flureeworker.worker_action.call(null,G__63673,G__63674,G__63675,G__63676));
}));
});
flureeworker.close_connection_STAR_ = (function flureeworker$close_connection_STAR_(var_args){
var G__63685 = arguments.length;
switch (G__63685) {
case 1:
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2(conn_id,false);
}));

(flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,save_config_QMARK_){
var conn_data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__63686 = conn_data;
var map__63686__$1 = cljs.core.__destructure_map(map__63686);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63686__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63686__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63686__$1,new cljs.core.Keyword(null,"config","config",994861415));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63686__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var new_config = (cljs.core.truth_(save_config_QMARK_)?new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"closed","closed",-919675359),true,new cljs.core.Keyword(null,"config","config",994861415),config,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null):new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"closed","closed",-919675359),true], null));
if((((conn_data == null)) || (new cljs.core.Keyword(null,"closed","closed",-919675359).cljs$core$IFn$_invoke$arity$1(conn_data) === true))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection doesn't exist, or is already closed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
flureeworker.remove_conn_listener(conn,conn_id,ledger);

fluree.db.connection_js.close(conn);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc,conn_id,new_config);

return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection closed."], null);
}
}));

(flureeworker.close_connection_STAR_.cljs$lang$maxFixedArity = 2);

flureeworker.close_connection = (function flureeworker$close_connection(conn_id,ref){
try{var G__63693 = conn_id;
var G__63694 = new cljs.core.Keyword(null,"connClosed","connClosed",1810797125);
var G__63695 = ref;
var G__63696 = flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1(conn_id);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63693,G__63694,G__63695,G__63696) : flureeworker.worker_action.call(null,G__63693,G__63694,G__63695,G__63696));
}catch (e63688){var e = e63688;
var msg = (function (){var or__4212__auto__ = cljs.core.ex_message(e);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return "Unexpected error.";
}
})();
var data = (function (){var or__4212__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
}
})();
var G__63689 = conn_id;
var G__63690 = new cljs.core.Keyword(null,"connClosed","connClosed",1810797125);
var G__63691 = ref;
var G__63692 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,new cljs.core.Keyword(null,"message","message",-406056002),msg);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63689,G__63690,G__63691,G__63692) : flureeworker.worker_action.call(null,G__63689,G__63690,G__63691,G__63692));
}});
flureeworker.reset_connection = (function flureeworker$reset_connection(conn_id,ref){
try{var save_config_QMARK_ = true;
flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2(conn_id,save_config_QMARK_);

return flureeworker.connect_STAR_(conn_id,ref);
}catch (e63697){var e = e63697;
var msg = (function (){var or__4212__auto__ = cljs.core.ex_message(e);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return "Unexpected error.";
}
})();
var data = (function (){var or__4212__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
}
})();
var G__63698 = conn_id;
var G__63699 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__63700 = ref;
var G__63701 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,new cljs.core.Keyword(null,"message","message",-406056002),msg);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63698,G__63699,G__63700,G__63701) : flureeworker.worker_action.call(null,G__63698,G__63699,G__63700,G__63701));
}});
/**
 * Open new connection to a Fluree instance
 */
flureeworker.connect_p = (function flureeworker$connect_p(config,ref){
var config_STAR_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(config,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var map__63702 = config_STAR_;
var map__63702__$1 = cljs.core.__destructure_map(map__63702);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63702__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63702__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63702__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var keepAlive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63702__$1,new cljs.core.Keyword(null,"keepAlive","keepAlive",-12888007));
var _ = (cljs.core.truth_(new cljs.core.Keyword(null,"log","log",-1595516004).cljs$core$IFn$_invoke$arity$1(config_STAR_))?fluree.db.util.log.set_level_BANG_(new cljs.core.Keyword(null,"finest","finest",-1359568890)):null);
var cb = (cljs.core.truth_(keepAlive)?(function (){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_63708){
var state_val_63709 = (state_63708[(1)]);
if((state_val_63709 === (1))){
var inst_63703 = cljs.core.async.timeout((100));
var state_63708__$1 = state_63708;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63708__$1,(2),inst_63703);
} else {
if((state_val_63709 === (2))){
var inst_63705 = (state_63708[(2)]);
var inst_63706 = flureeworker.connect_STAR_(id,ref);
var state_63708__$1 = (function (){var statearr_63710 = state_63708;
(statearr_63710[(7)] = inst_63705);

return statearr_63710;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_63708__$1,inst_63706);
} else {
return null;
}
}
});
return (function() {
var flureeworker$connect_p_$_state_machine__2717__auto__ = null;
var flureeworker$connect_p_$_state_machine__2717__auto____0 = (function (){
var statearr_63711 = [null,null,null,null,null,null,null,null];
(statearr_63711[(0)] = flureeworker$connect_p_$_state_machine__2717__auto__);

(statearr_63711[(1)] = (1));

return statearr_63711;
});
var flureeworker$connect_p_$_state_machine__2717__auto____1 = (function (state_63708){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_63708);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e63712){var ex__2720__auto__ = e63712;
var statearr_63713_63724 = state_63708;
(statearr_63713_63724[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_63708[(4)]))){
var statearr_63714_63725 = state_63708;
(statearr_63714_63725[(1)] = cljs.core.first((state_63708[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63726 = state_63708;
state_63708 = G__63726;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
flureeworker$connect_p_$_state_machine__2717__auto__ = function(state_63708){
switch(arguments.length){
case 0:
return flureeworker$connect_p_$_state_machine__2717__auto____0.call(this);
case 1:
return flureeworker$connect_p_$_state_machine__2717__auto____1.call(this,state_63708);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$connect_p_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$connect_p_$_state_machine__2717__auto____0;
flureeworker$connect_p_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$connect_p_$_state_machine__2717__auto____1;
return flureeworker$connect_p_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_63715 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_63715[(6)] = c__2739__auto__);

return statearr_63715;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}):null);
var opts = cljs.core.assoc_in(config_STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)], null),cb);
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers,opts).then((function (conn){
flureeworker.register_connection(conn,config_STAR_,null);

flureeworker.ledger_listener(conn,ledger,id);

var G__63716 = id;
var G__63717 = new cljs.core.Keyword(null,"connStatus","connStatus",63327857);
var G__63718 = ref;
var G__63719 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection is ready."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63716,G__63717,G__63718,G__63719) : flureeworker.worker_action.call(null,G__63716,G__63717,G__63718,G__63719));
})).catch((function (error){
var G__63720 = id;
var G__63721 = new cljs.core.Keyword(null,"connStatus","connStatus",63327857);
var G__63722 = ref;
var G__63723 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.str.cljs$core$IFn$_invoke$arity$1(error)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63720,G__63721,G__63722,G__63723) : flureeworker.worker_action.call(null,G__63720,G__63721,G__63722,G__63723));
}));
});
/**
 * Returns true if connection has been closed.
 */
flureeworker.conn_closed_QMARK_ = (function flureeworker$conn_closed_QMARK_(conn_id){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"closed","closed",-919675359)], null));
});
/**
 * Authenticate with ledger via username and password.
 * 
 * If authentication is successful, a 200 status is returned with a JSON web token.
 * Otherwise, an error status is returned.
 */
flureeworker.login = (function flureeworker$login(var_args){
var args__4824__auto__ = [];
var len__4818__auto___63794 = arguments.length;
var i__4819__auto___63795 = (0);
while(true){
if((i__4819__auto___63795 < len__4818__auto___63794)){
args__4824__auto__.push((arguments[i__4819__auto___63795]));

var G__63796 = (i__4819__auto___63795 + (1));
i__4819__auto___63795 = G__63796;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((4) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((4)),(0),null)):null);
return flureeworker.login.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4825__auto__);
});

(flureeworker.login.cljs$core$IFn$_invoke$arity$variadic = (function (conn_id,ref,username,password,p__63732){
var vec__63733 = p__63732;
var expire = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63733,(0),null);
var map__63736 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__63736__$1 = cljs.core.__destructure_map(map__63736);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63736__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63736__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63736__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var _ = (cljs.core.truth_(ledger)?null:(function (){var G__63737 = conn_id;
var G__63738 = new cljs.core.Keyword(null,"login","login",55217519);
var G__63739 = ref;
var G__63740 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"message","message",-406056002),"Connection missing Ledger information. Password authentication is specific to a ledger."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63737,G__63738,G__63739,G__63740) : flureeworker.worker_action.call(null,G__63737,G__63738,G__63739,G__63740));
})());
var auth = null;
var c__2739__auto___63797 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_63761){
var state_val_63762 = (state_63761[(1)]);
if((state_val_63762 === (1))){
var state_63761__$1 = state_63761;
var statearr_63763_63798 = state_63761__$1;
(statearr_63763_63798[(2)] = null);

(statearr_63763_63798[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63762 === (2))){
var ___$1 = (function (){var statearr_63764 = state_63761;
(statearr_63764[(4)] = cljs.core.cons((5),(state_63761[(4)])));

return statearr_63764;
})();
var inst_63752 = fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,username,auth,expire);
var inst_63753 = (function (){return (function (token){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null),token);

var G__63765 = conn_id;
var G__63766 = new cljs.core.Keyword(null,"login","login",55217519);
var G__63767 = ref;
var G__63768 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"token","token",-1211463215),token], null)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63765,G__63766,G__63767,G__63768) : flureeworker.worker_action.call(null,G__63765,G__63766,G__63767,G__63768));
});
})();
var inst_63754 = inst_63752.then(inst_63753);
var inst_63755 = (function (){return (function (resp){
var err = (function (){try{return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
}catch (e63769){var ___$2 = e63769;
return null;
}})();
var status = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err);
if((!((status == null)))){
var message = (function (){var or__4212__auto__ = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return "Authentication failed: unknown authentication error";
}
})();
var error = (function (){var or__4212__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})();
var G__63770 = conn_id;
var G__63771 = new cljs.core.Keyword(null,"login","login",55217519);
var G__63772 = ref;
var G__63773 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"message","message",-406056002),message,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63770,G__63771,G__63772,G__63773) : flureeworker.worker_action.call(null,G__63770,G__63771,G__63772,G__63773));
} else {
var G__63774 = conn_id;
var G__63775 = new cljs.core.Keyword(null,"login","login",55217519);
var G__63776 = ref;
var G__63777 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"message","message",-406056002),["Authentication failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resp)].join('')], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63774,G__63775,G__63776,G__63777) : flureeworker.worker_action.call(null,G__63774,G__63775,G__63776,G__63777));

}
});
})();
var inst_63756 = inst_63754.catch(inst_63755);
var ___$2 = (function (){var statearr_63778 = state_63761;
(statearr_63778[(4)] = cljs.core.rest((state_63761[(4)])));

return statearr_63778;
})();
var state_63761__$1 = state_63761;
var statearr_63779_63799 = state_63761__$1;
(statearr_63779_63799[(2)] = inst_63756);

(statearr_63779_63799[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63762 === (3))){
var inst_63759 = (state_63761[(2)]);
var state_63761__$1 = state_63761;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63761__$1,inst_63759);
} else {
if((state_val_63762 === (4))){
var inst_63741 = (state_63761[(2)]);
var inst_63742 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_63743 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63741);
var inst_63744 = [(400),inst_63743];
var inst_63745 = cljs.core.PersistentHashMap.fromArrays(inst_63742,inst_63744);
var inst_63746 = (function (){var G__63781 = conn_id;
var G__63782 = new cljs.core.Keyword(null,"login","login",55217519);
var G__63783 = ref;
var G__63784 = inst_63745;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63781,G__63782,G__63783,G__63784) : flureeworker.worker_action.call(null,G__63781,G__63782,G__63783,G__63784));
})();
var state_63761__$1 = state_63761;
var statearr_63785_63800 = state_63761__$1;
(statearr_63785_63800[(2)] = inst_63746);

(statearr_63785_63800[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63762 === (5))){
var ___$1 = (function (){var statearr_63786 = state_63761;
(statearr_63786[(4)] = cljs.core.rest((state_63761[(4)])));

return statearr_63786;
})();
var state_63761__$1 = state_63761;
var ex63780 = (state_63761__$1[(2)]);
var statearr_63787_63801 = state_63761__$1;
(statearr_63787_63801[(5)] = ex63780);


var statearr_63788_63802 = state_63761__$1;
(statearr_63788_63802[(1)] = (4));

(statearr_63788_63802[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$state_machine__2717__auto__ = null;
var flureeworker$state_machine__2717__auto____0 = (function (){
var statearr_63789 = [null,null,null,null,null,null,null];
(statearr_63789[(0)] = flureeworker$state_machine__2717__auto__);

(statearr_63789[(1)] = (1));

return statearr_63789;
});
var flureeworker$state_machine__2717__auto____1 = (function (state_63761){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_63761);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e63790){var ex__2720__auto__ = e63790;
var statearr_63791_63803 = state_63761;
(statearr_63791_63803[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_63761[(4)]))){
var statearr_63792_63804 = state_63761;
(statearr_63792_63804[(1)] = cljs.core.first((state_63761[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63805 = state_63761;
state_63761 = G__63805;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
flureeworker$state_machine__2717__auto__ = function(state_63761){
switch(arguments.length){
case 0:
return flureeworker$state_machine__2717__auto____0.call(this);
case 1:
return flureeworker$state_machine__2717__auto____1.call(this,state_63761);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$state_machine__2717__auto____0;
flureeworker$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$state_machine__2717__auto____1;
return flureeworker$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_63793 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_63793[(6)] = c__2739__auto___63797);

return statearr_63793;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));


return true;
}));

(flureeworker.login.cljs$lang$maxFixedArity = (4));

/** @this {Function} */
(flureeworker.login.cljs$lang$applyTo = (function (seq63727){
var G__63728 = cljs.core.first(seq63727);
var seq63727__$1 = cljs.core.next(seq63727);
var G__63729 = cljs.core.first(seq63727__$1);
var seq63727__$2 = cljs.core.next(seq63727__$1);
var G__63730 = cljs.core.first(seq63727__$2);
var seq63727__$3 = cljs.core.next(seq63727__$2);
var G__63731 = cljs.core.first(seq63727__$3);
var seq63727__$4 = cljs.core.next(seq63727__$3);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__63728,G__63729,G__63730,G__63731,seq63727__$4);
}));

/**
 * Attempts to generate a new user auth record account.
 * 
 * If request is successful, a 200 status is returned with a JSON web token.
 * Otherwise, an error status is returned.
 */
flureeworker.pw_generate = (function flureeworker$pw_generate(conn_id,ref,map_data){
var map__63806 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__63806__$1 = cljs.core.__destructure_map(map__63806);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63806__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63806__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var _ = (cljs.core.truth_(ledger)?null:(function (){var G__63808 = conn_id;
var G__63809 = new cljs.core.Keyword(null,"login","login",55217519);
var G__63810 = ref;
var G__63811 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"message","message",-406056002),"Connection missing Ledger information. Password authentication is specific to a ledger."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63808,G__63809,G__63810,G__63811) : flureeworker.worker_action.call(null,G__63808,G__63809,G__63810,G__63811));
})());
var map__63807 = map_data;
var map__63807__$1 = cljs.core.__destructure_map(map__63807);
var username = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63807__$1,new cljs.core.Keyword(null,"username","username",1605666410));
var password = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63807__$1,new cljs.core.Keyword(null,"password","password",417022471));
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63807__$1,new cljs.core.Keyword(null,"options","options",99638489));
var opts = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.select_keys(options,cljs.core.keys(options)),new cljs.core.Keyword(null,"user","user",1532431356),username);
var c__2739__auto___63865 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_63832){
var state_val_63833 = (state_63832[(1)]);
if((state_val_63833 === (1))){
var state_63832__$1 = state_63832;
var statearr_63834_63866 = state_63832__$1;
(statearr_63834_63866[(2)] = null);

(statearr_63834_63866[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63833 === (2))){
var ___$1 = (function (){var statearr_63835 = state_63832;
(statearr_63835[(4)] = cljs.core.cons((5),(state_63832[(4)])));

return statearr_63835;
})();
var inst_63823 = fluree.db.connection_js.password_generate(conn,ledger,password,opts);
var inst_63824 = (function (){return (function (token){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null),token);

var G__63836 = conn_id;
var G__63837 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__63838 = ref;
var G__63839 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"token","token",-1211463215),token], null)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63836,G__63837,G__63838,G__63839) : flureeworker.worker_action.call(null,G__63836,G__63837,G__63838,G__63839));
});
})();
var inst_63825 = inst_63823.then(inst_63824);
var inst_63826 = (function (){return (function (resp){
var err = (function (){try{return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
}catch (e63840){var ___$2 = e63840;
return null;
}})();
var status = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err);
if((!((status == null)))){
var message = (function (){var or__4212__auto__ = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return "Password Generation failed: unknown error";
}
})();
var error = (function (){var or__4212__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})();
var G__63841 = conn_id;
var G__63842 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__63843 = ref;
var G__63844 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"message","message",-406056002),message,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63841,G__63842,G__63843,G__63844) : flureeworker.worker_action.call(null,G__63841,G__63842,G__63843,G__63844));
} else {
var G__63845 = conn_id;
var G__63846 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__63847 = ref;
var G__63848 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"message","message",-406056002),["Password Generation failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resp)].join('')], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63845,G__63846,G__63847,G__63848) : flureeworker.worker_action.call(null,G__63845,G__63846,G__63847,G__63848));

}
});
})();
var inst_63827 = inst_63825.catch(inst_63826);
var ___$2 = (function (){var statearr_63849 = state_63832;
(statearr_63849[(4)] = cljs.core.rest((state_63832[(4)])));

return statearr_63849;
})();
var state_63832__$1 = state_63832;
var statearr_63850_63867 = state_63832__$1;
(statearr_63850_63867[(2)] = inst_63827);

(statearr_63850_63867[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63833 === (3))){
var inst_63830 = (state_63832[(2)]);
var state_63832__$1 = state_63832;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63832__$1,inst_63830);
} else {
if((state_val_63833 === (4))){
var inst_63812 = (state_63832[(2)]);
var inst_63813 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_63814 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63812);
var inst_63815 = [(400),inst_63814];
var inst_63816 = cljs.core.PersistentHashMap.fromArrays(inst_63813,inst_63815);
var inst_63817 = (function (){var G__63852 = conn_id;
var G__63853 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__63854 = ref;
var G__63855 = inst_63816;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63852,G__63853,G__63854,G__63855) : flureeworker.worker_action.call(null,G__63852,G__63853,G__63854,G__63855));
})();
var state_63832__$1 = state_63832;
var statearr_63856_63868 = state_63832__$1;
(statearr_63856_63868[(2)] = inst_63817);

(statearr_63856_63868[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63833 === (5))){
var ___$1 = (function (){var statearr_63857 = state_63832;
(statearr_63857[(4)] = cljs.core.rest((state_63832[(4)])));

return statearr_63857;
})();
var state_63832__$1 = state_63832;
var ex63851 = (state_63832__$1[(2)]);
var statearr_63858_63869 = state_63832__$1;
(statearr_63858_63869[(5)] = ex63851);


var statearr_63859_63870 = state_63832__$1;
(statearr_63859_63870[(1)] = (4));

(statearr_63859_63870[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$pw_generate_$_state_machine__2717__auto__ = null;
var flureeworker$pw_generate_$_state_machine__2717__auto____0 = (function (){
var statearr_63860 = [null,null,null,null,null,null,null];
(statearr_63860[(0)] = flureeworker$pw_generate_$_state_machine__2717__auto__);

(statearr_63860[(1)] = (1));

return statearr_63860;
});
var flureeworker$pw_generate_$_state_machine__2717__auto____1 = (function (state_63832){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_63832);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e63861){var ex__2720__auto__ = e63861;
var statearr_63862_63871 = state_63832;
(statearr_63862_63871[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_63832[(4)]))){
var statearr_63863_63872 = state_63832;
(statearr_63863_63872[(1)] = cljs.core.first((state_63832[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63873 = state_63832;
state_63832 = G__63873;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
flureeworker$pw_generate_$_state_machine__2717__auto__ = function(state_63832){
switch(arguments.length){
case 0:
return flureeworker$pw_generate_$_state_machine__2717__auto____0.call(this);
case 1:
return flureeworker$pw_generate_$_state_machine__2717__auto____1.call(this,state_63832);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$pw_generate_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$pw_generate_$_state_machine__2717__auto____0;
flureeworker$pw_generate_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$pw_generate_$_state_machine__2717__auto____1;
return flureeworker$pw_generate_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_63864 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_63864[(6)] = c__2739__auto___63865);

return statearr_63864;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));


return true;
});
flureeworker.unregisterQuery = (function flureeworker$unregisterQuery(conn_id,ref){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(flureeworker.conn_register,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ref], 0));
});
/**
 * Registers a new flureeQL query. 'opts' gets merged in with the flureeQL.opts, and is there
 *   to ease adding options to a GraphQL (and later other string-based queries like SPARQL and SQL),
 *   which do not have the same ability to dynamically add options.
 */
flureeworker.registerQuery = (function flureeworker$registerQuery(conn_id,ref,js_flurql,force_update_QMARK_){
var flureeQL = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(js_flurql,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(flureeQL,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995),ref], null)))) || (force_update_QMARK_ === true))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(flureeworker.conn_register,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ref,flureeQL], 0));

flureeworker.process_query(conn_id,ref,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"opts","opts",155075701)], null)));
} else {
}

return true;
});
/**
 * Submits a transaction across a websocket to a fluree instance
 */
flureeworker.transact = (function flureeworker$transact(conn_id,ref,map_data){
return new cljs.core.Keyword(null,"TODO","TODO",-523795145);
});
/**
 * Takes javascript array and move it into a clojurescript list without
 *   converting individual elements.
 */
flureeworker.js_array__GT_clj_list = (function flureeworker$js_array__GT_clj_list(js_array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__63874_SHARP_){
return (js_array[p1__63874_SHARP_]);
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(js_array.length));
});
/**
 * Main handler function for worker events
 *   Even data is a javascript object with the following keys:
 *   - action - the action to perform
 *   - params - parameters for the action we are calling
 *   - conn - the connection ID
 *   - ref - the reference ID to include in the response
 *   
 */
flureeworker.decode_message = (function flureeworker$decode_message(event){
try{var data = (event["data"]);
var action_str = (data["action"]);
var conn_id = (data["conn"]);
var ref = (data["ref"]);
var params_js = (data["params"]);
var params = ((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"pwGenerate")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"transact"))))?flureeworker.obj__GT_clj(cljs.core.first(params_js)):flureeworker.js_array__GT_clj_list(params_js)
);
if(cljs.core.truth_(flureeworker.conn_closed_QMARK_(conn_id))){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"unregisterQuery")){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),action_str,new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),({"status": (400), "message": "Connection has been closed."})], null));
} else {
return null;
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"connect")){
return flureeworker.connect_p(cljs.core.first(params),ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"close")){
return flureeworker.close_connection(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"reset")){
return flureeworker.reset_connection(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"registerQuery")){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(flureeworker.registerQuery,conn_id,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"unregisterQuery")){
return flureeworker.unregisterQuery(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"login")){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(flureeworker.login,conn_id,ref,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"pwGenerate")){
return flureeworker.pw_generate(conn_id,ref,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"transact")){
return flureeworker.transact(conn_id,ref,params);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unknown action: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(action_str)].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"status","status",-1997798413),(400)], null));

}
}
}
}
}
}
}
}
}
}catch (e63875){var e = e63875;
var data = (event["data"]);
var error_data = (function (){var temp__5751__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(temp__5751__auto__)){
var ex_data = temp__5751__auto__;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4212__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(ex_data);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (500);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(e)], null),ex_data], 0));
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),["Unexpected error: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0))].join('')], null);
}
})();
console.error("Error executing message:",data);

console.error(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error_data], 0)));

return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),(data["conn"]),new cljs.core.Keyword(null,"event","event",301435442),(data["action"]),new cljs.core.Keyword(null,"ref","ref",1289896967),(data["ref"]),new cljs.core.Keyword(null,"data","data",-232669377),error_data], null));
}});
/**
 * Log errors in this web worker
 */
flureeworker.log_error = (function flureeworker$log_error(error){
return console.error(error);
});
var temp__5753__auto___63876 = cljs.core.not(self.document);
if(temp__5753__auto___63876){
var worker_QMARK__63877 = temp__5753__auto___63876;
(self.onerror = flureeworker.log_error);

(self.onmessage = flureeworker.decode_message);
} else {
}
var G__63878_63880 = null;
var G__63879_63881 = new cljs.core.Keyword(null,"connInit","connInit",-148647574);
(flureeworker.worker_action.cljs$core$IFn$_invoke$arity$2 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$2(G__63878_63880,G__63879_63881) : flureeworker.worker_action.call(null,G__63878_63880,G__63879_63881));
