// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
fluree.db.util.xhttp.node$module$axios = require('axios');
fluree.db.util.xhttp.node$module$ws = require('ws');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5753__auto__ = e.response;
if(cljs.core.truth_(temp__5753__auto__)){
var resp = temp__5753__auto__;
var temp__5753__auto____$1 = resp.status;
if(cljs.core.truth_(temp__5753__auto____$1)){
var st = temp__5753__auto____$1;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
})();
var error = ((clojure.string.starts_with_QMARK_(e.message,"timeout"))?new cljs.core.Keyword("xhttp","timeout","xhttp/timeout",357433562):(cljs.core.truth_((function (){var and__4210__auto__ = status;
if(cljs.core.truth_(and__4210__auto__)){
return ((((300) <= status)) && ((status <= (499))));
} else {
return and__4210__auto__;
}
})())?new cljs.core.Keyword("xhttp","http-error","xhttp/http-error",-960604305):(cljs.core.truth_((function (){var and__4210__auto__ = status;
if(cljs.core.truth_(and__4210__auto__)){
return (status >= (500));
} else {
return and__4210__auto__;
}
})())?new cljs.core.Keyword("xhttp","exception","xhttp/exception",1363682040):(function (){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["XHTTP Request Error:",e.request], 0));

return new cljs.core.Keyword("xhttp","unknown-error","xhttp/unknown-error",693274399);
})()

)));
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4210__auto__ = status;
if(cljs.core.truth_(and__4210__auto__)){
return (status > (0));
} else {
return and__4210__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,(function (){var G__19825 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__19825,new cljs.core.Keyword(null,"status","status",-1997798413),status);
} else {
return G__19825;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__19826 = opts;
var map__19826__$1 = cljs.core.__destructure_map(map__19826);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__19826__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19826__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19826__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__19827 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__19827__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__19827,headers], 0)):G__19827);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__19827__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__19827__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"post",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1,new cljs.core.Keyword(null,"data","data",-232669377),message], null))).then((function (resp){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0))));
})).catch((function (err){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,err));
}));

return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__19828 = opts;
var map__19828__$1 = cljs.core.__destructure_map(map__19828);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__19828__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19828__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19828__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19828__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__19828__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"text","text",-1790561697));
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__19829 = cljs.core.PersistentArrayMap.EMPTY;
var G__19829__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__19829,headers], 0)):G__19829);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__19829__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__19829__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"get",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1], null))).then((function (resp){
var data = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,(function (){var G__19830 = output_format;
var G__19830__$1 = (((G__19830 instanceof cljs.core.Keyword))?G__19830.fqn:null);
switch (G__19830__$1) {
case "text":
return data;

break;
case "json":
return fluree.db.util.json.stringify(data);

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("http get only supports output formats of json and text.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
})).catch((function (err){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,err));
}));

return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__19832 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Accept"], null),"application/json"),new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"json","json",1279968570));
if(cljs.core.truth_(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__19832,new cljs.core.Keyword(null,"body","body",-2049205669),fluree.db.util.json.stringify(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__19832;
}
})();
return fluree.db.util.xhttp.get(url,opts_STAR_);
});
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_19864){
var state_val_19865 = (state_19864[(1)]);
if((state_val_19865 === (7))){
var inst_19860 = (state_19864[(2)]);
var state_19864__$1 = state_19864;
var statearr_19866_19891 = state_19864__$1;
(statearr_19866_19891[(2)] = inst_19860);

(statearr_19866_19891[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19865 === (1))){
var state_19864__$1 = state_19864;
var statearr_19867_19892 = state_19864__$1;
(statearr_19867_19892[(2)] = null);

(statearr_19867_19892[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19865 === (4))){
var inst_19835 = (state_19864[(7)]);
var inst_19835__$1 = (state_19864[(2)]);
var inst_19836 = (inst_19835__$1 == null);
var state_19864__$1 = (function (){var statearr_19868 = state_19864;
(statearr_19868[(7)] = inst_19835__$1);

return statearr_19868;
})();
if(cljs.core.truth_(inst_19836)){
var statearr_19869_19893 = state_19864__$1;
(statearr_19869_19893[(1)] = (5));

} else {
var statearr_19870_19894 = state_19864__$1;
(statearr_19870_19894[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19865 === (6))){
var inst_19835 = (state_19864[(7)]);
var inst_19843 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19835,(0),null);
var inst_19844 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19835,(1),null);
var state_19864__$1 = (function (){var statearr_19871 = state_19864;
(statearr_19871[(8)] = inst_19843);

(statearr_19871[(9)] = inst_19844);

return statearr_19871;
})();
var statearr_19872_19895 = state_19864__$1;
(statearr_19872_19895[(2)] = null);

(statearr_19872_19895[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19865 === (3))){
var inst_19862 = (state_19864[(2)]);
var state_19864__$1 = state_19864;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19864__$1,inst_19862);
} else {
if((state_val_19865 === (2))){
var state_19864__$1 = state_19864;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19864__$1,(4),pub_chan);
} else {
if((state_val_19865 === (11))){
var _ = (function (){var statearr_19874 = state_19864;
(statearr_19874[(4)] = cljs.core.rest((state_19864[(4)])));

return statearr_19874;
})();
var state_19864__$1 = state_19864;
var ex19873 = (state_19864__$1[(2)]);
var statearr_19875_19896 = state_19864__$1;
(statearr_19875_19896[(5)] = ex19873);


var statearr_19876_19897 = state_19864__$1;
(statearr_19876_19897[(1)] = (10));

(statearr_19876_19897[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19865 === (9))){
var inst_19857 = (state_19864[(2)]);
var state_19864__$1 = (function (){var statearr_19877 = state_19864;
(statearr_19877[(10)] = inst_19857);

return statearr_19877;
})();
var statearr_19878_19898 = state_19864__$1;
(statearr_19878_19898[(2)] = null);

(statearr_19878_19898[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19865 === (5))){
var inst_19838 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Web socket pub/producer channel closed."], 0));
var state_19864__$1 = state_19864;
var statearr_19879_19899 = state_19864__$1;
(statearr_19879_19899[(2)] = inst_19838);

(statearr_19879_19899[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19865 === (10))){
var inst_19843 = (state_19864[(8)]);
var inst_19844 = (state_19864[(9)]);
var inst_19845 = (state_19864[(2)]);
var inst_19846 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_19845,"Error sending websocket message:",inst_19843], 0));
var inst_19847 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_19844,false);
var state_19864__$1 = (function (){var statearr_19880 = state_19864;
(statearr_19880[(11)] = inst_19846);

return statearr_19880;
})();
var statearr_19881_19900 = state_19864__$1;
(statearr_19881_19900[(2)] = inst_19847);

(statearr_19881_19900[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19865 === (8))){
var inst_19843 = (state_19864[(8)]);
var inst_19844 = (state_19864[(9)]);
var _ = (function (){var statearr_19882 = state_19864;
(statearr_19882[(4)] = cljs.core.cons((11),(state_19864[(4)])));

return statearr_19882;
})();
var inst_19853 = ws.send(inst_19843);
var inst_19854 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_19844,true);
var ___$1 = (function (){var statearr_19883 = state_19864;
(statearr_19883[(4)] = cljs.core.rest((state_19864[(4)])));

return statearr_19883;
})();
var state_19864__$1 = (function (){var statearr_19884 = state_19864;
(statearr_19884[(12)] = inst_19853);

return statearr_19884;
})();
var statearr_19885_19901 = state_19864__$1;
(statearr_19885_19901[(2)] = inst_19854);

(statearr_19885_19901[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2717__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2717__auto____0 = (function (){
var statearr_19886 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19886[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2717__auto__);

(statearr_19886[(1)] = (1));

return statearr_19886;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2717__auto____1 = (function (state_19864){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_19864);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e19887){var ex__2720__auto__ = e19887;
var statearr_19888_19902 = state_19864;
(statearr_19888_19902[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_19864[(4)]))){
var statearr_19889_19903 = state_19864;
(statearr_19889_19903[(1)] = cljs.core.first((state_19864[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19904 = state_19864;
state_19864 = G__19904;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2717__auto__ = function(state_19864){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2717__auto____1.call(this,state_19864);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2717__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2717__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_19890 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_19890[(6)] = c__2739__auto__);

return statearr_19890;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (((cljs.core._STAR_target_STAR_ === "nodejs"))?(new fluree.db.util.xhttp.node$module$ws(url)):(new WebSocket(url)));
var open_QMARK_ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Websocket closed: ",e.reason,"Code: ",e.code], 0));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
}));

var c__2739__auto___19942 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_19929){
var state_val_19930 = (state_19929[(1)]);
if((state_val_19930 === (1))){
var inst_19908 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19909 = [open_QMARK_,timeout_chan];
var inst_19910 = (new cljs.core.PersistentVector(null,2,(5),inst_19908,inst_19909,null));
var state_19929__$1 = state_19929;
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(state_19929__$1,(2),inst_19910,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"priority","priority",1431093715),true], 0));
} else {
if((state_val_19930 === (2))){
var inst_19912 = (state_19929[(2)]);
var inst_19913 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19912,(0),null);
var inst_19914 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19912,(1),null);
var inst_19915 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_19914,timeout_chan);
var state_19929__$1 = (function (){var statearr_19931 = state_19929;
(statearr_19931[(7)] = inst_19913);

return statearr_19931;
})();
if(inst_19915){
var statearr_19932_19943 = state_19929__$1;
(statearr_19932_19943[(1)] = (3));

} else {
var statearr_19933_19944 = state_19929__$1;
(statearr_19933_19944[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19930 === (3))){
var inst_19917 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_19918 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19919 = [(400),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_19920 = cljs.core.PersistentHashMap.fromArrays(inst_19918,inst_19919);
var inst_19921 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_19917,inst_19920);
var inst_19922 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,inst_19921);
var inst_19923 = fluree.db.util.xhttp.close_websocket(ws);
var state_19929__$1 = (function (){var statearr_19934 = state_19929;
(statearr_19934[(8)] = inst_19922);

return statearr_19934;
})();
var statearr_19935_19945 = state_19929__$1;
(statearr_19935_19945[(2)] = inst_19923);

(statearr_19935_19945[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19930 === (4))){
var inst_19925 = fluree.db.util.xhttp.socket_publish_loop(ws,pub_chan);
var state_19929__$1 = state_19929;
var statearr_19936_19946 = state_19929__$1;
(statearr_19936_19946[(2)] = inst_19925);

(statearr_19936_19946[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19930 === (5))){
var inst_19927 = (state_19929[(2)]);
var state_19929__$1 = state_19929;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19929__$1,inst_19927);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__2717__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__2717__auto____0 = (function (){
var statearr_19937 = [null,null,null,null,null,null,null,null,null];
(statearr_19937[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__2717__auto__);

(statearr_19937[(1)] = (1));

return statearr_19937;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__2717__auto____1 = (function (state_19929){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_19929);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e19938){var ex__2720__auto__ = e19938;
var statearr_19939_19947 = state_19929;
(statearr_19939_19947[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_19929[(4)]))){
var statearr_19940_19948 = state_19929;
(statearr_19940_19948[(1)] = cljs.core.first((state_19929[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19949 = state_19929;
state_19929 = G__19949;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__2717__auto__ = function(state_19929){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__2717__auto____1.call(this,state_19929);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__2717__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__2717__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_19941 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_19941[(6)] = c__2739__auto___19942);

return statearr_19941;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));


return new cljs.core.Keyword("fluree.db.util.xhttp","no-return","fluree.db.util.xhttp/no-return",1591333002);
});
