// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4212__auto__ = cljs.core.ex_data(x);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_11466){
var state_val_11467 = (state_11466[(1)]);
if((state_val_11467 === (7))){
var inst_11461 = (state_11466[(2)]);
var _ = (function (){var statearr_11468 = state_11466;
(statearr_11468[(4)] = cljs.core.rest((state_11466[(4)])));

return statearr_11468;
})();
var state_11466__$1 = state_11466;
var statearr_11469_11491 = state_11466__$1;
(statearr_11469_11491[(2)] = inst_11461);

(statearr_11469_11491[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11467 === (1))){
var state_11466__$1 = state_11466;
var statearr_11470_11492 = state_11466__$1;
(statearr_11470_11492[(2)] = null);

(statearr_11470_11492[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11467 === (4))){
var inst_11423 = (state_11466[(2)]);
var state_11466__$1 = state_11466;
var statearr_11471_11493 = state_11466__$1;
(statearr_11471_11493[(2)] = inst_11423);

(statearr_11471_11493[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11467 === (6))){
var inst_11441 = (state_11466[(7)]);
var inst_11448 = (state_11466[(8)]);
var inst_11447 = cljs.core.seq(inst_11441);
var inst_11448__$1 = cljs.core.first(inst_11447);
var inst_11449 = cljs.core.next(inst_11447);
var inst_11450 = cljs.core.not(inst_11448__$1);
var state_11466__$1 = (function (){var statearr_11472 = state_11466;
(statearr_11472[(9)] = inst_11449);

(statearr_11472[(8)] = inst_11448__$1);

return statearr_11472;
})();
if(inst_11450){
var statearr_11473_11494 = state_11466__$1;
(statearr_11473_11494[(1)] = (8));

} else {
var statearr_11474_11495 = state_11466__$1;
(statearr_11474_11495[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11467 === (3))){
var inst_11464 = (state_11466[(2)]);
var state_11466__$1 = state_11466;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11466__$1,inst_11464);
} else {
if((state_val_11467 === (2))){
var _ = (function (){var statearr_11475 = state_11466;
(statearr_11475[(4)] = cljs.core.cons((5),(state_11466[(4)])));

return statearr_11475;
})();
var inst_11436 = chs;
var inst_11437 = cljs.core.seq(inst_11436);
var inst_11438 = cljs.core.first(inst_11437);
var inst_11439 = cljs.core.next(inst_11437);
var inst_11440 = coll;
var inst_11441 = inst_11436;
var inst_11442 = inst_11440;
var state_11466__$1 = (function (){var statearr_11476 = state_11466;
(statearr_11476[(10)] = inst_11438);

(statearr_11476[(11)] = inst_11442);

(statearr_11476[(7)] = inst_11441);

(statearr_11476[(12)] = inst_11439);

return statearr_11476;
})();
var statearr_11477_11496 = state_11466__$1;
(statearr_11477_11496[(2)] = null);

(statearr_11477_11496[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11467 === (11))){
var inst_11449 = (state_11466[(9)]);
var inst_11442 = (state_11466[(11)]);
var inst_11454 = (state_11466[(2)]);
var inst_11455 = fluree.db.util.async.throw_err(inst_11454);
var inst_11456 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_11442,inst_11455);
var inst_11441 = inst_11449;
var inst_11442__$1 = inst_11456;
var state_11466__$1 = (function (){var statearr_11479 = state_11466;
(statearr_11479[(11)] = inst_11442__$1);

(statearr_11479[(7)] = inst_11441);

return statearr_11479;
})();
var statearr_11480_11497 = state_11466__$1;
(statearr_11480_11497[(2)] = null);

(statearr_11480_11497[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11467 === (9))){
var inst_11448 = (state_11466[(8)]);
var state_11466__$1 = state_11466;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11466__$1,(11),inst_11448);
} else {
if((state_val_11467 === (5))){
var _ = (function (){var statearr_11481 = state_11466;
(statearr_11481[(4)] = cljs.core.rest((state_11466[(4)])));

return statearr_11481;
})();
var state_11466__$1 = state_11466;
var ex11478 = (state_11466__$1[(2)]);
var statearr_11482_11498 = state_11466__$1;
(statearr_11482_11498[(5)] = ex11478);


var statearr_11483_11499 = state_11466__$1;
(statearr_11483_11499[(1)] = (4));

(statearr_11483_11499[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11467 === (10))){
var inst_11459 = (state_11466[(2)]);
var state_11466__$1 = state_11466;
var statearr_11484_11500 = state_11466__$1;
(statearr_11484_11500[(2)] = inst_11459);

(statearr_11484_11500[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11467 === (8))){
var inst_11442 = (state_11466[(11)]);
var state_11466__$1 = state_11466;
var statearr_11485_11501 = state_11466__$1;
(statearr_11485_11501[(2)] = inst_11442);

(statearr_11485_11501[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2717__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2717__auto____0 = (function (){
var statearr_11486 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11486[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__2717__auto__);

(statearr_11486[(1)] = (1));

return statearr_11486;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2717__auto____1 = (function (state_11466){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_11466);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e11487){var ex__2720__auto__ = e11487;
var statearr_11488_11502 = state_11466;
(statearr_11488_11502[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_11466[(4)]))){
var statearr_11489_11503 = state_11466;
(statearr_11489_11503[(1)] = cljs.core.first((state_11466[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11504 = state_11466;
state_11466 = G__11504;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__2717__auto__ = function(state_11466){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2717__auto____1.call(this,state_11466);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2717__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2717__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_11490 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_11490[(6)] = c__2739__auto__);

return statearr_11490;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel instead of results if there is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_11530){
var state_val_11531 = (state_11530[(1)]);
if((state_val_11531 === (7))){
var inst_11525 = (state_11530[(2)]);
var _ = (function (){var statearr_11532 = state_11530;
(statearr_11532[(4)] = cljs.core.rest((state_11530[(4)])));

return statearr_11532;
})();
var state_11530__$1 = state_11530;
var statearr_11533_11555 = state_11530__$1;
(statearr_11533_11555[(2)] = inst_11525);

(statearr_11533_11555[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11531 === (1))){
var state_11530__$1 = state_11530;
var statearr_11534_11556 = state_11530__$1;
(statearr_11534_11556[(2)] = null);

(statearr_11534_11556[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11531 === (4))){
var inst_11505 = (state_11530[(2)]);
var state_11530__$1 = state_11530;
var statearr_11535_11557 = state_11530__$1;
(statearr_11535_11557[(2)] = inst_11505);

(statearr_11535_11557[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11531 === (6))){
var state_11530__$1 = state_11530;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11530__$1,(8),chan);
} else {
if((state_val_11531 === (3))){
var inst_11528 = (state_11530[(2)]);
var state_11530__$1 = state_11530;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11530__$1,inst_11528);
} else {
if((state_val_11531 === (2))){
var _ = (function (){var statearr_11536 = state_11530;
(statearr_11536[(4)] = cljs.core.cons((5),(state_11530[(4)])));

return statearr_11536;
})();
var inst_11511 = coll;
var inst_11512 = inst_11511;
var state_11530__$1 = (function (){var statearr_11537 = state_11530;
(statearr_11537[(7)] = inst_11512);

return statearr_11537;
})();
var statearr_11538_11558 = state_11530__$1;
(statearr_11538_11558[(2)] = null);

(statearr_11538_11558[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11531 === (11))){
var inst_11523 = (state_11530[(2)]);
var state_11530__$1 = state_11530;
var statearr_11540_11559 = state_11530__$1;
(statearr_11540_11559[(2)] = inst_11523);

(statearr_11540_11559[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11531 === (9))){
var inst_11512 = (state_11530[(7)]);
var state_11530__$1 = state_11530;
var statearr_11541_11560 = state_11530__$1;
(statearr_11541_11560[(2)] = inst_11512);

(statearr_11541_11560[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11531 === (5))){
var _ = (function (){var statearr_11542 = state_11530;
(statearr_11542[(4)] = cljs.core.rest((state_11530[(4)])));

return statearr_11542;
})();
var state_11530__$1 = state_11530;
var ex11539 = (state_11530__$1[(2)]);
var statearr_11543_11561 = state_11530__$1;
(statearr_11543_11561[(5)] = ex11539);


var statearr_11544_11562 = state_11530__$1;
(statearr_11544_11562[(1)] = (4));

(statearr_11544_11562[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11531 === (10))){
var inst_11512 = (state_11530[(7)]);
var inst_11516 = (state_11530[(8)]);
var inst_11520 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_11512,inst_11516);
var inst_11512__$1 = inst_11520;
var state_11530__$1 = (function (){var statearr_11545 = state_11530;
(statearr_11545[(7)] = inst_11512__$1);

return statearr_11545;
})();
var statearr_11546_11563 = state_11530__$1;
(statearr_11546_11563[(2)] = null);

(statearr_11546_11563[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11531 === (8))){
var inst_11516 = (state_11530[(8)]);
var inst_11515 = (state_11530[(2)]);
var inst_11516__$1 = fluree.db.util.async.throw_err(inst_11515);
var inst_11517 = (inst_11516__$1 == null);
var state_11530__$1 = (function (){var statearr_11547 = state_11530;
(statearr_11547[(8)] = inst_11516__$1);

return statearr_11547;
})();
if(cljs.core.truth_(inst_11517)){
var statearr_11548_11564 = state_11530__$1;
(statearr_11548_11564[(1)] = (9));

} else {
var statearr_11549_11565 = state_11530__$1;
(statearr_11549_11565[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__2717__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__2717__auto____0 = (function (){
var statearr_11550 = [null,null,null,null,null,null,null,null,null];
(statearr_11550[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__2717__auto__);

(statearr_11550[(1)] = (1));

return statearr_11550;
});
var fluree$db$util$async$into_QMARK__$_state_machine__2717__auto____1 = (function (state_11530){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_11530);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e11551){var ex__2720__auto__ = e11551;
var statearr_11552_11566 = state_11530;
(statearr_11552_11566[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_11530[(4)]))){
var statearr_11553_11567 = state_11530;
(statearr_11553_11567[(1)] = cljs.core.first((state_11530[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11568 = state_11530;
state_11530 = G__11568;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__2717__auto__ = function(state_11530){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__2717__auto____1.call(this,state_11530);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__2717__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__2717__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_11554 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_11554[(6)] = c__2739__auto__);

return statearr_11554;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
}
});
