// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_exists_fn.cljs$core$IFn$_invoke$arity$1 ? storage_exists_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_exists_fn.call(null,key));
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_read_fn.cljs$core$IFn$_invoke$arity$1 ? storage_read_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_read_fn.call(null,key));
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(conn);
return (storage_write_fn.cljs$core$IFn$_invoke$arity$2 ? storage_write_fn.cljs$core$IFn$_invoke$arity$2(key,val) : storage_write_fn.call(null,key,val));
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name(idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad(block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_17256){
var state_val_17257 = (state_17256[(1)]);
if((state_val_17257 === (7))){
var inst_17245 = (state_17256[(7)]);
var inst_17247 = fluree.db.storage.core.serde(conn);
var inst_17248 = fluree.db.serde.protocol._deserialize_block(inst_17247,inst_17245);
var state_17256__$1 = state_17256;
var statearr_17258_17277 = state_17256__$1;
(statearr_17258_17277[(2)] = inst_17248);

(statearr_17258_17277[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17257 === (1))){
var state_17256__$1 = state_17256;
var statearr_17259_17278 = state_17256__$1;
(statearr_17259_17278[(2)] = null);

(statearr_17259_17278[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17257 === (4))){
var inst_17235 = (state_17256[(2)]);
var state_17256__$1 = state_17256;
var statearr_17260_17279 = state_17256__$1;
(statearr_17260_17279[(2)] = inst_17235);

(statearr_17260_17279[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17257 === (6))){
var inst_17245 = (state_17256[(7)]);
var inst_17244 = (state_17256[(2)]);
var inst_17245__$1 = fluree.db.util.async.throw_err(inst_17244);
var state_17256__$1 = (function (){var statearr_17261 = state_17256;
(statearr_17261[(7)] = inst_17245__$1);

return statearr_17261;
})();
if(cljs.core.truth_(inst_17245__$1)){
var statearr_17262_17280 = state_17256__$1;
(statearr_17262_17280[(1)] = (7));

} else {
var statearr_17263_17281 = state_17256__$1;
(statearr_17263_17281[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17257 === (3))){
var inst_17254 = (state_17256[(2)]);
var state_17256__$1 = state_17256;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17256__$1,inst_17254);
} else {
if((state_val_17257 === (2))){
var _ = (function (){var statearr_17265 = state_17256;
(statearr_17265[(4)] = cljs.core.cons((5),(state_17256[(4)])));

return statearr_17265;
})();
var inst_17241 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_17242 = fluree.db.storage.core.storage_read(conn,inst_17241);
var state_17256__$1 = state_17256;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17256__$1,(6),inst_17242);
} else {
if((state_val_17257 === (9))){
var inst_17251 = (state_17256[(2)]);
var _ = (function (){var statearr_17266 = state_17256;
(statearr_17266[(4)] = cljs.core.rest((state_17256[(4)])));

return statearr_17266;
})();
var state_17256__$1 = state_17256;
var statearr_17267_17282 = state_17256__$1;
(statearr_17267_17282[(2)] = inst_17251);

(statearr_17267_17282[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17257 === (5))){
var _ = (function (){var statearr_17268 = state_17256;
(statearr_17268[(4)] = cljs.core.rest((state_17256[(4)])));

return statearr_17268;
})();
var state_17256__$1 = state_17256;
var ex17264 = (state_17256__$1[(2)]);
var statearr_17269_17283 = state_17256__$1;
(statearr_17269_17283[(5)] = ex17264);


if((ex17264 instanceof Error)){
var statearr_17270_17284 = state_17256__$1;
(statearr_17270_17284[(1)] = (4));

(statearr_17270_17284[(5)] = null);

} else {
throw ex17264;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17257 === (8))){
var state_17256__$1 = state_17256;
var statearr_17271_17285 = state_17256__$1;
(statearr_17271_17285[(2)] = null);

(statearr_17271_17285[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__2717__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__2717__auto____0 = (function (){
var statearr_17272 = [null,null,null,null,null,null,null,null];
(statearr_17272[(0)] = fluree$db$storage$core$read_block_$_state_machine__2717__auto__);

(statearr_17272[(1)] = (1));

return statearr_17272;
});
var fluree$db$storage$core$read_block_$_state_machine__2717__auto____1 = (function (state_17256){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_17256);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e17273){var ex__2720__auto__ = e17273;
var statearr_17274_17286 = state_17256;
(statearr_17274_17286[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_17256[(4)]))){
var statearr_17275_17287 = state_17256;
(statearr_17275_17287[(1)] = cljs.core.first((state_17256[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17288 = state_17256;
state_17256 = G__17288;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__2717__auto__ = function(state_17256){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__2717__auto____1.call(this,state_17256);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__2717__auto____0;
fluree$db$storage$core$read_block_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__2717__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_17276 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_17276[(6)] = c__2739__auto__);

return statearr_17276;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_17311){
var state_val_17312 = (state_17311[(1)]);
if((state_val_17312 === (7))){
var inst_17300 = (state_17311[(7)]);
var inst_17302 = fluree.db.storage.core.serde(conn);
var inst_17303 = fluree.db.serde.protocol._deserialize_block(inst_17302,inst_17300);
var state_17311__$1 = state_17311;
var statearr_17313_17332 = state_17311__$1;
(statearr_17313_17332[(2)] = inst_17303);

(statearr_17313_17332[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17312 === (1))){
var state_17311__$1 = state_17311;
var statearr_17314_17333 = state_17311__$1;
(statearr_17314_17333[(2)] = null);

(statearr_17314_17333[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17312 === (4))){
var inst_17289 = (state_17311[(2)]);
var state_17311__$1 = state_17311;
var statearr_17315_17334 = state_17311__$1;
(statearr_17315_17334[(2)] = inst_17289);

(statearr_17315_17334[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17312 === (6))){
var inst_17300 = (state_17311[(7)]);
var inst_17299 = (state_17311[(2)]);
var inst_17300__$1 = fluree.db.util.async.throw_err(inst_17299);
var state_17311__$1 = (function (){var statearr_17316 = state_17311;
(statearr_17316[(7)] = inst_17300__$1);

return statearr_17316;
})();
if(cljs.core.truth_(inst_17300__$1)){
var statearr_17317_17335 = state_17311__$1;
(statearr_17317_17335[(1)] = (7));

} else {
var statearr_17318_17336 = state_17311__$1;
(statearr_17318_17336[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17312 === (3))){
var inst_17309 = (state_17311[(2)]);
var state_17311__$1 = state_17311;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17311__$1,inst_17309);
} else {
if((state_val_17312 === (2))){
var _ = (function (){var statearr_17320 = state_17311;
(statearr_17320[(4)] = cljs.core.cons((5),(state_17311[(4)])));

return statearr_17320;
})();
var inst_17295 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_17296 = [inst_17295,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_17297 = fluree.db.storage.core.storage_read(conn,inst_17296);
var state_17311__$1 = state_17311;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17311__$1,(6),inst_17297);
} else {
if((state_val_17312 === (9))){
var inst_17306 = (state_17311[(2)]);
var _ = (function (){var statearr_17321 = state_17311;
(statearr_17321[(4)] = cljs.core.rest((state_17311[(4)])));

return statearr_17321;
})();
var state_17311__$1 = state_17311;
var statearr_17322_17337 = state_17311__$1;
(statearr_17322_17337[(2)] = inst_17306);

(statearr_17322_17337[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17312 === (5))){
var _ = (function (){var statearr_17323 = state_17311;
(statearr_17323[(4)] = cljs.core.rest((state_17311[(4)])));

return statearr_17323;
})();
var state_17311__$1 = state_17311;
var ex17319 = (state_17311__$1[(2)]);
var statearr_17324_17338 = state_17311__$1;
(statearr_17324_17338[(5)] = ex17319);


if((ex17319 instanceof Error)){
var statearr_17325_17339 = state_17311__$1;
(statearr_17325_17339[(1)] = (4));

(statearr_17325_17339[(5)] = null);

} else {
throw ex17319;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17312 === (8))){
var state_17311__$1 = state_17311;
var statearr_17326_17340 = state_17311__$1;
(statearr_17326_17340[(2)] = null);

(statearr_17326_17340[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__2717__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__2717__auto____0 = (function (){
var statearr_17327 = [null,null,null,null,null,null,null,null];
(statearr_17327[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__2717__auto__);

(statearr_17327[(1)] = (1));

return statearr_17327;
});
var fluree$db$storage$core$read_block_version_$_state_machine__2717__auto____1 = (function (state_17311){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_17311);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e17328){var ex__2720__auto__ = e17328;
var statearr_17329_17341 = state_17311;
(statearr_17329_17341[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_17311[(4)]))){
var statearr_17330_17342 = state_17311;
(statearr_17330_17342[(1)] = cljs.core.first((state_17311[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17343 = state_17311;
state_17311 = G__17343;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__2717__auto__ = function(state_17311){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__2717__auto____1.call(this,state_17311);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__2717__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__2717__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_17331 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_17331[(6)] = c__2739__auto__);

return statearr_17331;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_17367){
var state_val_17368 = (state_17367[(1)]);
if((state_val_17368 === (1))){
var state_17367__$1 = state_17367;
var statearr_17369_17383 = state_17367__$1;
(statearr_17369_17383[(2)] = null);

(statearr_17369_17383[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17368 === (2))){
var _ = (function (){var statearr_17370 = state_17367;
(statearr_17370[(4)] = cljs.core.cons((5),(state_17367[(4)])));

return statearr_17370;
})();
var inst_17350 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17351 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_17352 = (new cljs.core.PersistentVector(null,3,(5),inst_17350,inst_17351,null));
var inst_17353 = cljs.core.select_keys(block_data,inst_17352);
var inst_17354 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_17353);
var inst_17355 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_17354);
var inst_17356 = [inst_17355,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_17357 = fluree.db.storage.core.serde(conn);
var inst_17358 = fluree.db.serde.protocol._serialize_block(inst_17357,inst_17353);
var inst_17359 = fluree.db.storage.core.storage_write(conn,inst_17356,inst_17358);
var state_17367__$1 = state_17367;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17367__$1,(6),inst_17359);
} else {
if((state_val_17368 === (3))){
var inst_17365 = (state_17367[(2)]);
var state_17367__$1 = state_17367;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17367__$1,inst_17365);
} else {
if((state_val_17368 === (4))){
var inst_17344 = (state_17367[(2)]);
var state_17367__$1 = state_17367;
var statearr_17372_17384 = state_17367__$1;
(statearr_17372_17384[(2)] = inst_17344);

(statearr_17372_17384[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17368 === (5))){
var _ = (function (){var statearr_17373 = state_17367;
(statearr_17373[(4)] = cljs.core.rest((state_17367[(4)])));

return statearr_17373;
})();
var state_17367__$1 = state_17367;
var ex17371 = (state_17367__$1[(2)]);
var statearr_17374_17385 = state_17367__$1;
(statearr_17374_17385[(5)] = ex17371);


if((ex17371 instanceof Error)){
var statearr_17375_17386 = state_17367__$1;
(statearr_17375_17386[(1)] = (4));

(statearr_17375_17386[(5)] = null);

} else {
throw ex17371;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17368 === (6))){
var inst_17361 = (state_17367[(2)]);
var inst_17362 = fluree.db.util.async.throw_err(inst_17361);
var _ = (function (){var statearr_17376 = state_17367;
(statearr_17376[(4)] = cljs.core.rest((state_17367[(4)])));

return statearr_17376;
})();
var state_17367__$1 = state_17367;
var statearr_17377_17387 = state_17367__$1;
(statearr_17377_17387[(2)] = inst_17362);

(statearr_17377_17387[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__2717__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__2717__auto____0 = (function (){
var statearr_17378 = [null,null,null,null,null,null,null];
(statearr_17378[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__2717__auto__);

(statearr_17378[(1)] = (1));

return statearr_17378;
});
var fluree$db$storage$core$write_block_version_$_state_machine__2717__auto____1 = (function (state_17367){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_17367);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e17379){var ex__2720__auto__ = e17379;
var statearr_17380_17388 = state_17367;
(statearr_17380_17388[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_17367[(4)]))){
var statearr_17381_17389 = state_17367;
(statearr_17381_17389[(1)] = cljs.core.first((state_17367[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17390 = state_17367;
state_17367 = G__17390;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__2717__auto__ = function(state_17367){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__2717__auto____1.call(this,state_17367);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__2717__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__2717__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_17382 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_17382[(6)] = c__2739__auto__);

return statearr_17382;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_17413){
var state_val_17414 = (state_17413[(1)]);
if((state_val_17414 === (1))){
var state_17413__$1 = state_17413;
var statearr_17415_17429 = state_17413__$1;
(statearr_17415_17429[(2)] = null);

(statearr_17415_17429[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17414 === (2))){
var _ = (function (){var statearr_17416 = state_17413;
(statearr_17416[(4)] = cljs.core.cons((5),(state_17413[(4)])));

return statearr_17416;
})();
var inst_17397 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17398 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_17399 = (new cljs.core.PersistentVector(null,3,(5),inst_17397,inst_17398,null));
var inst_17400 = cljs.core.select_keys(block_data,inst_17399);
var inst_17401 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_17400);
var inst_17402 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_17401);
var inst_17403 = fluree.db.storage.core.serde(conn);
var inst_17404 = fluree.db.serde.protocol._serialize_block(inst_17403,inst_17400);
var inst_17405 = fluree.db.storage.core.storage_write(conn,inst_17402,inst_17404);
var state_17413__$1 = state_17413;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17413__$1,(6),inst_17405);
} else {
if((state_val_17414 === (3))){
var inst_17411 = (state_17413[(2)]);
var state_17413__$1 = state_17413;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17413__$1,inst_17411);
} else {
if((state_val_17414 === (4))){
var inst_17391 = (state_17413[(2)]);
var state_17413__$1 = state_17413;
var statearr_17418_17430 = state_17413__$1;
(statearr_17418_17430[(2)] = inst_17391);

(statearr_17418_17430[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17414 === (5))){
var _ = (function (){var statearr_17419 = state_17413;
(statearr_17419[(4)] = cljs.core.rest((state_17413[(4)])));

return statearr_17419;
})();
var state_17413__$1 = state_17413;
var ex17417 = (state_17413__$1[(2)]);
var statearr_17420_17431 = state_17413__$1;
(statearr_17420_17431[(5)] = ex17417);


if((ex17417 instanceof Error)){
var statearr_17421_17432 = state_17413__$1;
(statearr_17421_17432[(1)] = (4));

(statearr_17421_17432[(5)] = null);

} else {
throw ex17417;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17414 === (6))){
var inst_17407 = (state_17413[(2)]);
var inst_17408 = fluree.db.util.async.throw_err(inst_17407);
var _ = (function (){var statearr_17422 = state_17413;
(statearr_17422[(4)] = cljs.core.rest((state_17413[(4)])));

return statearr_17422;
})();
var state_17413__$1 = state_17413;
var statearr_17423_17433 = state_17413__$1;
(statearr_17423_17433[(2)] = inst_17408);

(statearr_17423_17433[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__2717__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__2717__auto____0 = (function (){
var statearr_17424 = [null,null,null,null,null,null,null];
(statearr_17424[(0)] = fluree$db$storage$core$write_block_$_state_machine__2717__auto__);

(statearr_17424[(1)] = (1));

return statearr_17424;
});
var fluree$db$storage$core$write_block_$_state_machine__2717__auto____1 = (function (state_17413){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_17413);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e17425){var ex__2720__auto__ = e17425;
var statearr_17426_17434 = state_17413;
(statearr_17426_17434[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_17413[(4)]))){
var statearr_17427_17435 = state_17413;
(statearr_17427_17435[(1)] = cljs.core.first((state_17413[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17436 = state_17413;
state_17413 = G__17436;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__2717__auto__ = function(state_17413){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__2717__auto____1.call(this,state_17413);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__2717__auto____0;
fluree$db$storage$core$write_block_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__2717__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_17428 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_17428[(6)] = c__2739__auto__);

return statearr_17428;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys(child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_17456){
var state_val_17457 = (state_17456[(1)]);
if((state_val_17457 === (1))){
var state_17456__$1 = state_17456;
var statearr_17458_17472 = state_17456__$1;
(statearr_17458_17472[(2)] = null);

(statearr_17458_17472[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17457 === (2))){
var _ = (function (){var statearr_17459 = state_17456;
(statearr_17459[(4)] = cljs.core.cons((5),(state_17456[(4)])));

return statearr_17459;
})();
var inst_17443 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_17444 = [history,next_his_key];
var inst_17445 = cljs.core.PersistentHashMap.fromArrays(inst_17443,inst_17444);
var inst_17446 = fluree.db.storage.core.serde(conn);
var inst_17447 = fluree.db.serde.protocol._serialize_leaf(inst_17446,inst_17445);
var inst_17448 = fluree.db.storage.core.storage_write(conn,his_key,inst_17447);
var state_17456__$1 = state_17456;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17456__$1,(6),inst_17448);
} else {
if((state_val_17457 === (3))){
var inst_17454 = (state_17456[(2)]);
var state_17456__$1 = state_17456;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17456__$1,inst_17454);
} else {
if((state_val_17457 === (4))){
var inst_17437 = (state_17456[(2)]);
var state_17456__$1 = state_17456;
var statearr_17461_17473 = state_17456__$1;
(statearr_17461_17473[(2)] = inst_17437);

(statearr_17461_17473[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17457 === (5))){
var _ = (function (){var statearr_17462 = state_17456;
(statearr_17462[(4)] = cljs.core.rest((state_17456[(4)])));

return statearr_17462;
})();
var state_17456__$1 = state_17456;
var ex17460 = (state_17456__$1[(2)]);
var statearr_17463_17474 = state_17456__$1;
(statearr_17463_17474[(5)] = ex17460);


if((ex17460 instanceof Error)){
var statearr_17464_17475 = state_17456__$1;
(statearr_17464_17475[(1)] = (4));

(statearr_17464_17475[(5)] = null);

} else {
throw ex17460;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17457 === (6))){
var inst_17450 = (state_17456[(2)]);
var inst_17451 = fluree.db.util.async.throw_err(inst_17450);
var _ = (function (){var statearr_17465 = state_17456;
(statearr_17465[(4)] = cljs.core.rest((state_17456[(4)])));

return statearr_17465;
})();
var state_17456__$1 = state_17456;
var statearr_17466_17476 = state_17456__$1;
(statearr_17466_17476[(2)] = inst_17451);

(statearr_17466_17476[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__2717__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__2717__auto____0 = (function (){
var statearr_17467 = [null,null,null,null,null,null,null];
(statearr_17467[(0)] = fluree$db$storage$core$write_history_$_state_machine__2717__auto__);

(statearr_17467[(1)] = (1));

return statearr_17467;
});
var fluree$db$storage$core$write_history_$_state_machine__2717__auto____1 = (function (state_17456){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_17456);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e17468){var ex__2720__auto__ = e17468;
var statearr_17469_17477 = state_17456;
(statearr_17469_17477[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_17456[(4)]))){
var statearr_17470_17478 = state_17456;
(statearr_17470_17478[(1)] = cljs.core.first((state_17456[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17479 = state_17456;
state_17456 = G__17479;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__2717__auto__ = function(state_17456){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__2717__auto____1.call(this,state_17456);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__2717__auto____0;
fluree$db$storage$core$write_history_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__2717__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_17471 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_17471[(6)] = c__2739__auto__);

return statearr_17471;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_17505){
var state_val_17506 = (state_17505[(1)]);
if((state_val_17506 === (1))){
var state_17505__$1 = state_17505;
var statearr_17507_17524 = state_17505__$1;
(statearr_17507_17524[(2)] = null);

(statearr_17507_17524[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17506 === (2))){
var inst_17486 = (state_17505[(7)]);
var _ = (function (){var statearr_17508 = state_17505;
(statearr_17508[(4)] = cljs.core.cons((5),(state_17505[(4)])));

return statearr_17508;
})();
var inst_17486__$1 = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"l");
var inst_17487 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_17486__$1),"-his"].join('');
var inst_17488 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_17489 = [flakes,inst_17487];
var inst_17490 = cljs.core.PersistentHashMap.fromArrays(inst_17488,inst_17489);
var inst_17491 = fluree.db.storage.core.serde(conn);
var inst_17492 = fluree.db.serde.protocol._serialize_leaf(inst_17491,inst_17490);
var inst_17493 = fluree.db.storage.core.write_history(conn,history,inst_17487,null);
var inst_17494 = fluree.db.storage.core.storage_write(conn,inst_17486__$1,inst_17492);
var state_17505__$1 = (function (){var statearr_17509 = state_17505;
(statearr_17509[(7)] = inst_17486__$1);

(statearr_17509[(8)] = inst_17494);

return statearr_17509;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17505__$1,(6),inst_17493);
} else {
if((state_val_17506 === (3))){
var inst_17503 = (state_17505[(2)]);
var state_17505__$1 = state_17505;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17505__$1,inst_17503);
} else {
if((state_val_17506 === (4))){
var inst_17480 = (state_17505[(2)]);
var state_17505__$1 = state_17505;
var statearr_17511_17525 = state_17505__$1;
(statearr_17511_17525[(2)] = inst_17480);

(statearr_17511_17525[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17506 === (5))){
var _ = (function (){var statearr_17512 = state_17505;
(statearr_17512[(4)] = cljs.core.rest((state_17505[(4)])));

return statearr_17512;
})();
var state_17505__$1 = state_17505;
var ex17510 = (state_17505__$1[(2)]);
var statearr_17513_17526 = state_17505__$1;
(statearr_17513_17526[(5)] = ex17510);


if((ex17510 instanceof Error)){
var statearr_17514_17527 = state_17505__$1;
(statearr_17514_17527[(1)] = (4));

(statearr_17514_17527[(5)] = null);

} else {
throw ex17510;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17506 === (6))){
var inst_17494 = (state_17505[(8)]);
var inst_17496 = (state_17505[(2)]);
var inst_17497 = fluree.db.util.async.throw_err(inst_17496);
var state_17505__$1 = (function (){var statearr_17515 = state_17505;
(statearr_17515[(9)] = inst_17497);

return statearr_17515;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17505__$1,(7),inst_17494);
} else {
if((state_val_17506 === (7))){
var inst_17486 = (state_17505[(7)]);
var inst_17499 = (state_17505[(2)]);
var inst_17500 = fluree.db.util.async.throw_err(inst_17499);
var _ = (function (){var statearr_17516 = state_17505;
(statearr_17516[(4)] = cljs.core.rest((state_17505[(4)])));

return statearr_17516;
})();
var state_17505__$1 = (function (){var statearr_17517 = state_17505;
(statearr_17517[(10)] = inst_17500);

return statearr_17517;
})();
var statearr_17518_17528 = state_17505__$1;
(statearr_17518_17528[(2)] = inst_17486);

(statearr_17518_17528[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__2717__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__2717__auto____0 = (function (){
var statearr_17519 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17519[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__2717__auto__);

(statearr_17519[(1)] = (1));

return statearr_17519;
});
var fluree$db$storage$core$write_leaf_$_state_machine__2717__auto____1 = (function (state_17505){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_17505);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e17520){var ex__2720__auto__ = e17520;
var statearr_17521_17529 = state_17505;
(statearr_17521_17529[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_17505[(4)]))){
var statearr_17522_17530 = state_17505;
(statearr_17522_17530[(1)] = cljs.core.first((state_17505[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17531 = state_17505;
state_17505 = G__17531;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__2717__auto__ = function(state_17505){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__2717__auto____1.call(this,state_17505);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__2717__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__2717__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_17523 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_17523[(6)] = c__2739__auto__);

return statearr_17523;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_17548){
var state_val_17549 = (state_17548[(1)]);
if((state_val_17549 === (1))){
var state_17548__$1 = state_17548;
var statearr_17550_17565 = state_17548__$1;
(statearr_17550_17565[(2)] = null);

(statearr_17550_17565[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17549 === (2))){
var _ = (function (){var statearr_17551 = state_17548;
(statearr_17551[(4)] = cljs.core.cons((5),(state_17548[(4)])));

return statearr_17551;
})();
var inst_17538 = fluree.db.storage.core.serde(conn);
var inst_17539 = fluree.db.serde.protocol._serialize_branch(inst_17538,data);
var inst_17540 = fluree.db.storage.core.storage_write(conn,key,inst_17539);
var state_17548__$1 = state_17548;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17548__$1,(6),inst_17540);
} else {
if((state_val_17549 === (3))){
var inst_17546 = (state_17548[(2)]);
var state_17548__$1 = state_17548;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17548__$1,inst_17546);
} else {
if((state_val_17549 === (4))){
var inst_17532 = (state_17548[(2)]);
var state_17548__$1 = state_17548;
var statearr_17553_17566 = state_17548__$1;
(statearr_17553_17566[(2)] = inst_17532);

(statearr_17553_17566[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17549 === (5))){
var _ = (function (){var statearr_17554 = state_17548;
(statearr_17554[(4)] = cljs.core.rest((state_17548[(4)])));

return statearr_17554;
})();
var state_17548__$1 = state_17548;
var ex17552 = (state_17548__$1[(2)]);
var statearr_17555_17567 = state_17548__$1;
(statearr_17555_17567[(5)] = ex17552);


if((ex17552 instanceof Error)){
var statearr_17556_17568 = state_17548__$1;
(statearr_17556_17568[(1)] = (4));

(statearr_17556_17568[(5)] = null);

} else {
throw ex17552;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17549 === (6))){
var inst_17542 = (state_17548[(2)]);
var inst_17543 = fluree.db.util.async.throw_err(inst_17542);
var _ = (function (){var statearr_17557 = state_17548;
(statearr_17557[(4)] = cljs.core.rest((state_17548[(4)])));

return statearr_17557;
})();
var state_17548__$1 = (function (){var statearr_17558 = state_17548;
(statearr_17558[(7)] = inst_17543);

return statearr_17558;
})();
var statearr_17559_17569 = state_17548__$1;
(statearr_17559_17569[(2)] = key);

(statearr_17559_17569[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__2717__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__2717__auto____0 = (function (){
var statearr_17560 = [null,null,null,null,null,null,null,null];
(statearr_17560[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__2717__auto__);

(statearr_17560[(1)] = (1));

return statearr_17560;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__2717__auto____1 = (function (state_17548){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_17548);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e17561){var ex__2720__auto__ = e17561;
var statearr_17562_17570 = state_17548;
(statearr_17562_17570[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_17548[(4)]))){
var statearr_17563_17571 = state_17548;
(statearr_17563_17571[(1)] = cljs.core.first((state_17548[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17572 = state_17548;
state_17548 = G__17572;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__2717__auto__ = function(state_17548){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__2717__auto____1.call(this,state_17548);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__2717__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__2717__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_17564 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_17564[(6)] = c__2739__auto__);

return statearr_17564;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__17573_SHARP_){
return fluree.db.storage.core.child_data(cljs.core.val(p1__17573_SHARP_));
}),children);
var rhs = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(cljs.core.last(child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"children","children",-940561982),child_vals,new cljs.core.Keyword(null,"rhs","rhs",-229356739),rhs], null);
return fluree.db.storage.core.write_branch_data(conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__17574){
var map__17575 = p__17574;
var map__17575__$1 = cljs.core.__destructure_map(map__17575);
var progress = map__17575__$1;
var garbage = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17575__$1,new cljs.core.Keyword(null,"garbage","garbage",-2063107600));
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_17603){
var state_val_17604 = (state_17603[(1)]);
if((state_val_17604 === (1))){
var state_17603__$1 = state_17603;
var statearr_17605_17621 = state_17603__$1;
(statearr_17605_17621[(2)] = null);

(statearr_17605_17621[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17604 === (2))){
var inst_17589 = (state_17603[(7)]);
var _ = (function (){var statearr_17606 = state_17603;
(statearr_17606[(4)] = cljs.core.cons((5),(state_17603[(4)])));

return statearr_17606;
})();
var inst_17583 = db;
var inst_17584 = cljs.core.__destructure_map(inst_17583);
var inst_17585 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17584,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_17586 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17584,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_17587 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17584,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_17588 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17584,new cljs.core.Keyword(null,"block","block",664686210));
var inst_17589__$1 = fluree.db.storage.core.ledger_garbage_key(inst_17586,inst_17587,inst_17588);
var inst_17590 = [new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_17591 = [inst_17587,inst_17588,garbage];
var inst_17592 = cljs.core.PersistentHashMap.fromArrays(inst_17590,inst_17591);
var inst_17593 = fluree.db.storage.core.serde(inst_17585);
var inst_17594 = fluree.db.serde.protocol._serialize_garbage(inst_17593,inst_17592);
var inst_17595 = fluree.db.storage.core.storage_write(inst_17585,inst_17589__$1,inst_17594);
var state_17603__$1 = (function (){var statearr_17607 = state_17603;
(statearr_17607[(7)] = inst_17589__$1);

return statearr_17607;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17603__$1,(6),inst_17595);
} else {
if((state_val_17604 === (3))){
var inst_17601 = (state_17603[(2)]);
var state_17603__$1 = state_17603;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17603__$1,inst_17601);
} else {
if((state_val_17604 === (4))){
var inst_17576 = (state_17603[(2)]);
var state_17603__$1 = state_17603;
var statearr_17609_17622 = state_17603__$1;
(statearr_17609_17622[(2)] = inst_17576);

(statearr_17609_17622[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17604 === (5))){
var _ = (function (){var statearr_17610 = state_17603;
(statearr_17610[(4)] = cljs.core.rest((state_17603[(4)])));

return statearr_17610;
})();
var state_17603__$1 = state_17603;
var ex17608 = (state_17603__$1[(2)]);
var statearr_17611_17623 = state_17603__$1;
(statearr_17611_17623[(5)] = ex17608);


if((ex17608 instanceof Error)){
var statearr_17612_17624 = state_17603__$1;
(statearr_17612_17624[(1)] = (4));

(statearr_17612_17624[(5)] = null);

} else {
throw ex17608;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17604 === (6))){
var inst_17589 = (state_17603[(7)]);
var inst_17597 = (state_17603[(2)]);
var inst_17598 = fluree.db.util.async.throw_err(inst_17597);
var _ = (function (){var statearr_17613 = state_17603;
(statearr_17613[(4)] = cljs.core.rest((state_17603[(4)])));

return statearr_17613;
})();
var state_17603__$1 = (function (){var statearr_17614 = state_17603;
(statearr_17614[(8)] = inst_17598);

return statearr_17614;
})();
var statearr_17615_17625 = state_17603__$1;
(statearr_17615_17625[(2)] = inst_17589);

(statearr_17615_17625[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__2717__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__2717__auto____0 = (function (){
var statearr_17616 = [null,null,null,null,null,null,null,null,null];
(statearr_17616[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__2717__auto__);

(statearr_17616[(1)] = (1));

return statearr_17616;
});
var fluree$db$storage$core$write_garbage_$_state_machine__2717__auto____1 = (function (state_17603){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_17603);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e17617){var ex__2720__auto__ = e17617;
var statearr_17618_17626 = state_17603;
(statearr_17618_17626[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_17603[(4)]))){
var statearr_17619_17627 = state_17603;
(statearr_17619_17627[(1)] = cljs.core.first((state_17603[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17628 = state_17603;
state_17603 = G__17628;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__2717__auto__ = function(state_17603){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__2717__auto____1.call(this,state_17603);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__2717__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__2717__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_17620 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_17620[(6)] = c__2739__auto__);

return statearr_17620;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__17630 = arguments.length;
switch (G__17630) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2(db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_17686){
var state_val_17687 = (state_17686[(1)]);
if((state_val_17687 === (7))){
var state_17686__$1 = state_17686;
var statearr_17688_17714 = state_17686__$1;
(statearr_17688_17714[(2)] = (0));

(statearr_17688_17714[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17687 === (1))){
var state_17686__$1 = state_17686;
var statearr_17689_17715 = state_17686__$1;
(statearr_17689_17715[(2)] = null);

(statearr_17689_17715[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17687 === (4))){
var inst_17631 = (state_17686[(2)]);
var state_17686__$1 = state_17686;
var statearr_17690_17716 = state_17686__$1;
(statearr_17690_17716[(2)] = inst_17631);

(statearr_17690_17716[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17687 === (6))){
var inst_17656 = (state_17686[(7)]);
var state_17686__$1 = state_17686;
var statearr_17691_17717 = state_17686__$1;
(statearr_17691_17717[(2)] = inst_17656);

(statearr_17691_17717[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17687 === (3))){
var inst_17684 = (state_17686[(2)]);
var state_17686__$1 = state_17686;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17686__$1,inst_17684);
} else {
if((state_val_17687 === (12))){
var inst_17653 = (state_17686[(8)]);
var inst_17680 = (state_17686[(2)]);
var inst_17681 = fluree.db.util.async.throw_err(inst_17680);
var _ = (function (){var statearr_17692 = state_17686;
(statearr_17692[(4)] = cljs.core.rest((state_17686[(4)])));

return statearr_17692;
})();
var state_17686__$1 = (function (){var statearr_17693 = state_17686;
(statearr_17693[(9)] = inst_17681);

return statearr_17693;
})();
var statearr_17694_17718 = state_17686__$1;
(statearr_17694_17718[(2)] = inst_17653);

(statearr_17694_17718[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17687 === (2))){
var inst_17656 = (state_17686[(7)]);
var inst_17646 = (state_17686[(10)]);
var inst_17644 = (state_17686[(11)]);
var inst_17648 = (state_17686[(12)]);
var _ = (function (){var statearr_17695 = state_17686;
(statearr_17695[(4)] = cljs.core.cons((5),(state_17686[(4)])));

return statearr_17695;
})();
var inst_17638 = db;
var inst_17639 = cljs.core.__destructure_map(inst_17638);
var inst_17640 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17639,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_17641 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17639,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_17642 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17639,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_17643 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17639,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_17644__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17639,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_17645 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17639,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_17646__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17639,new cljs.core.Keyword(null,"block","block",664686210));
var inst_17647 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17639,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_17648__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17639,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_17649 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17639,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_17650 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17639,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_17651 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17639,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_17652 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17639,new cljs.core.Keyword(null,"post","post",269697687));
var inst_17653 = fluree.db.storage.core.ledger_root_key(inst_17640,inst_17648__$1,inst_17646__$1);
var inst_17654 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_17655 = fluree.db.storage.core.child_data(inst_17647);
var inst_17656__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_17644__$1);
var state_17686__$1 = (function (){var statearr_17696 = state_17686;
(statearr_17696[(8)] = inst_17653);

(statearr_17696[(13)] = inst_17643);

(statearr_17696[(14)] = inst_17642);

(statearr_17696[(15)] = inst_17651);

(statearr_17696[(7)] = inst_17656__$1);

(statearr_17696[(16)] = inst_17645);

(statearr_17696[(10)] = inst_17646__$1);

(statearr_17696[(17)] = inst_17650);

(statearr_17696[(18)] = inst_17654);

(statearr_17696[(11)] = inst_17644__$1);

(statearr_17696[(19)] = inst_17655);

(statearr_17696[(20)] = inst_17641);

(statearr_17696[(12)] = inst_17648__$1);

(statearr_17696[(21)] = inst_17649);

(statearr_17696[(22)] = inst_17652);

return statearr_17696;
})();
if(cljs.core.truth_(inst_17656__$1)){
var statearr_17697_17719 = state_17686__$1;
(statearr_17697_17719[(1)] = (6));

} else {
var statearr_17698_17720 = state_17686__$1;
(statearr_17698_17720[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17687 === (11))){
var inst_17653 = (state_17686[(8)]);
var inst_17643 = (state_17686[(13)]);
var inst_17642 = (state_17686[(14)]);
var inst_17651 = (state_17686[(15)]);
var inst_17645 = (state_17686[(16)]);
var inst_17646 = (state_17686[(10)]);
var inst_17650 = (state_17686[(17)]);
var inst_17654 = (state_17686[(18)]);
var inst_17644 = (state_17686[(11)]);
var inst_17660 = (state_17686[(23)]);
var inst_17655 = (state_17686[(19)]);
var inst_17641 = (state_17686[(20)]);
var inst_17648 = (state_17686[(12)]);
var inst_17652 = (state_17686[(22)]);
var inst_17665 = (state_17686[(2)]);
var inst_17666 = fluree.db.storage.core.child_data(inst_17650);
var inst_17667 = fluree.db.storage.core.child_data(inst_17652);
var inst_17668 = fluree.db.util.core.current_time_millis();
var inst_17669 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17670 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_17671 = (new cljs.core.PersistentVector(null,2,(5),inst_17669,inst_17670,null));
var inst_17672 = cljs.core.select_keys(inst_17644,inst_17671);
var inst_17673 = fluree.db.storage.core.child_data(inst_17643);
var inst_17674 = [inst_17646,inst_17655,inst_17648,inst_17660,inst_17665,inst_17666,inst_17667,inst_17641,inst_17668,inst_17642,inst_17651,inst_17672,inst_17673];
var inst_17675 = cljs.core.PersistentHashMap.fromArrays(inst_17654,inst_17674);
var inst_17676 = fluree.db.storage.core.serde(inst_17645);
var inst_17677 = fluree.db.serde.protocol._serialize_db_root(inst_17676,inst_17675);
var inst_17678 = fluree.db.storage.core.storage_write(inst_17645,inst_17653,inst_17677);
var state_17686__$1 = state_17686;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17686__$1,(12),inst_17678);
} else {
if((state_val_17687 === (9))){
var inst_17661 = (state_17686[(24)]);
var state_17686__$1 = state_17686;
var statearr_17700_17721 = state_17686__$1;
(statearr_17700_17721[(2)] = inst_17661);

(statearr_17700_17721[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17687 === (5))){
var _ = (function (){var statearr_17701 = state_17686;
(statearr_17701[(4)] = cljs.core.rest((state_17686[(4)])));

return statearr_17701;
})();
var state_17686__$1 = state_17686;
var ex17699 = (state_17686__$1[(2)]);
var statearr_17702_17722 = state_17686__$1;
(statearr_17702_17722[(5)] = ex17699);


if((ex17699 instanceof Error)){
var statearr_17703_17723 = state_17686__$1;
(statearr_17703_17723[(1)] = (4));

(statearr_17703_17723[(5)] = null);

} else {
throw ex17699;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17687 === (10))){
var inst_17649 = (state_17686[(21)]);
var state_17686__$1 = state_17686;
var statearr_17704_17724 = state_17686__$1;
(statearr_17704_17724[(2)] = inst_17649);

(statearr_17704_17724[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17687 === (8))){
var inst_17661 = (state_17686[(24)]);
var inst_17660 = (state_17686[(2)]);
var inst_17661__$1 = custom_ecount;
var state_17686__$1 = (function (){var statearr_17705 = state_17686;
(statearr_17705[(24)] = inst_17661__$1);

(statearr_17705[(23)] = inst_17660);

return statearr_17705;
})();
if(cljs.core.truth_(inst_17661__$1)){
var statearr_17706_17725 = state_17686__$1;
(statearr_17706_17725[(1)] = (9));

} else {
var statearr_17707_17726 = state_17686__$1;
(statearr_17707_17726[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2717__auto__ = null;
var fluree$db$storage$core$state_machine__2717__auto____0 = (function (){
var statearr_17708 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17708[(0)] = fluree$db$storage$core$state_machine__2717__auto__);

(statearr_17708[(1)] = (1));

return statearr_17708;
});
var fluree$db$storage$core$state_machine__2717__auto____1 = (function (state_17686){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_17686);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e17709){var ex__2720__auto__ = e17709;
var statearr_17710_17727 = state_17686;
(statearr_17710_17727[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_17686[(4)]))){
var statearr_17711_17728 = state_17686;
(statearr_17711_17728[(1)] = cljs.core.first((state_17686[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17729 = state_17686;
state_17686 = G__17729;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2717__auto__ = function(state_17686){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2717__auto____1.call(this,state_17686);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2717__auto____0;
fluree$db$storage$core$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2717__auto____1;
return fluree$db$storage$core$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_17712 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_17712[(6)] = c__2739__auto__);

return statearr_17712;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2739__auto___17788 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_17762){
var state_val_17763 = (state_17762[(1)]);
if((state_val_17763 === (7))){
var inst_17742 = (state_17762[(7)]);
var state_17762__$1 = state_17762;
var statearr_17764_17789 = state_17762__$1;
(statearr_17764_17789[(2)] = inst_17742);

(statearr_17764_17789[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17763 === (1))){
var state_17762__$1 = state_17762;
var statearr_17765_17790 = state_17762__$1;
(statearr_17765_17790[(2)] = null);

(statearr_17765_17790[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17763 === (4))){
var inst_17730 = (state_17762[(2)]);
var inst_17731 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_17732 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_17730);
var inst_17733 = cljs.core.async.close_BANG_(return_ch);
var state_17762__$1 = (function (){var statearr_17766 = state_17762;
(statearr_17766[(8)] = inst_17732);

(statearr_17766[(9)] = inst_17731);

return statearr_17766;
})();
var statearr_17767_17791 = state_17762__$1;
(statearr_17767_17791[(2)] = inst_17733);

(statearr_17767_17791[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17763 === (6))){
var inst_17741 = (state_17762[(10)]);
var inst_17742 = (state_17762[(7)]);
var inst_17741__$1 = (state_17762[(2)]);
var inst_17742__$1 = (inst_17741__$1 == null);
var state_17762__$1 = (function (){var statearr_17768 = state_17762;
(statearr_17768[(10)] = inst_17741__$1);

(statearr_17768[(7)] = inst_17742__$1);

return statearr_17768;
})();
if(cljs.core.truth_(inst_17742__$1)){
var statearr_17769_17792 = state_17762__$1;
(statearr_17769_17792[(1)] = (7));

} else {
var statearr_17770_17793 = state_17762__$1;
(statearr_17770_17793[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17763 === (3))){
var inst_17760 = (state_17762[(2)]);
var state_17762__$1 = state_17762;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17762__$1,inst_17760);
} else {
if((state_val_17763 === (12))){
var inst_17757 = (state_17762[(2)]);
var _ = (function (){var statearr_17771 = state_17762;
(statearr_17771[(4)] = cljs.core.rest((state_17762[(4)])));

return statearr_17771;
})();
var state_17762__$1 = state_17762;
var statearr_17772_17794 = state_17762__$1;
(statearr_17772_17794[(2)] = inst_17757);

(statearr_17772_17794[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17763 === (2))){
var _ = (function (){var statearr_17773 = state_17762;
(statearr_17773[(4)] = cljs.core.cons((5),(state_17762[(4)])));

return statearr_17773;
})();
var inst_17739 = fluree.db.storage.core.storage_read(conn,key);
var state_17762__$1 = state_17762;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17762__$1,(6),inst_17739);
} else {
if((state_val_17763 === (11))){
var inst_17741 = (state_17762[(10)]);
var inst_17751 = fluree.db.storage.core.serde(conn);
var inst_17752 = fluree.db.serde.protocol._deserialize_leaf(inst_17751,inst_17741);
var inst_17753 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_17752);
var inst_17754 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_history,inst_17753);
var inst_17755 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_17754);
var state_17762__$1 = state_17762;
var statearr_17775_17795 = state_17762__$1;
(statearr_17775_17795[(2)] = inst_17755);

(statearr_17775_17795[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17763 === (9))){
var inst_17747 = (state_17762[(2)]);
var state_17762__$1 = state_17762;
if(cljs.core.truth_(inst_17747)){
var statearr_17776_17796 = state_17762__$1;
(statearr_17776_17796[(1)] = (10));

} else {
var statearr_17777_17797 = state_17762__$1;
(statearr_17777_17797[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17763 === (5))){
var _ = (function (){var statearr_17778 = state_17762;
(statearr_17778[(4)] = cljs.core.rest((state_17762[(4)])));

return statearr_17778;
})();
var state_17762__$1 = state_17762;
var ex17774 = (state_17762__$1[(2)]);
var statearr_17779_17798 = state_17762__$1;
(statearr_17779_17798[(5)] = ex17774);


var statearr_17780_17799 = state_17762__$1;
(statearr_17780_17799[(1)] = (4));

(statearr_17780_17799[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17763 === (10))){
var inst_17749 = cljs.core.async.close_BANG_(return_ch);
var state_17762__$1 = state_17762;
var statearr_17781_17800 = state_17762__$1;
(statearr_17781_17800[(2)] = inst_17749);

(statearr_17781_17800[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17763 === (8))){
var inst_17741 = (state_17762[(10)]);
var inst_17745 = (inst_17741 instanceof Error);
var state_17762__$1 = state_17762;
var statearr_17782_17801 = state_17762__$1;
(statearr_17782_17801[(2)] = inst_17745);

(statearr_17782_17801[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__2717__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__2717__auto____0 = (function (){
var statearr_17783 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17783[(0)] = fluree$db$storage$core$reify_history_$_state_machine__2717__auto__);

(statearr_17783[(1)] = (1));

return statearr_17783;
});
var fluree$db$storage$core$reify_history_$_state_machine__2717__auto____1 = (function (state_17762){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_17762);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e17784){var ex__2720__auto__ = e17784;
var statearr_17785_17802 = state_17762;
(statearr_17785_17802[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_17762[(4)]))){
var statearr_17786_17803 = state_17762;
(statearr_17786_17803[(1)] = cljs.core.first((state_17762[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17804 = state_17762;
state_17762 = G__17804;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__2717__auto__ = function(state_17762){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__2717__auto____1.call(this,state_17762);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__2717__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__2717__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_17787 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_17787[(6)] = c__2739__auto___17788);

return statearr_17787;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__17806 = arguments.length;
switch (G__17806) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__4210__auto__ = rhs;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.not(leftmost_QMARK_);
} else {
return and__4210__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4210__auto__ = rhs;
if(cljs.core.truth_(and__4210__auto__)){
return leftmost_QMARK_;
} else {
return and__4210__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not(leftmost_QMARK_))))?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__4210__auto__ = (rhs == null);
if(and__4210__auto__){
return leftmost_QMARK_;
} else {
return and__4210__auto__;
}
})())?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2739__auto___17918 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_17869){
var state_val_17870 = (state_17869[(1)]);
if((state_val_17870 === (7))){
var state_17869__$1 = state_17869;
var statearr_17871_17919 = state_17869__$1;
(statearr_17871_17919[(2)] = new cljs.core.Keyword(null,"novelty","novelty",-1590246024));

(statearr_17871_17919[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17870 === (20))){
var inst_17848 = cljs.core.PersistentVector.EMPTY;
var state_17869__$1 = state_17869;
var statearr_17872_17920 = state_17869__$1;
(statearr_17872_17920[(2)] = inst_17848);

(statearr_17872_17920[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17870 === (1))){
var state_17869__$1 = state_17869;
var statearr_17873_17921 = state_17869__$1;
(statearr_17873_17921[(2)] = null);

(statearr_17873_17921[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17870 === (24))){
var state_17869__$1 = state_17869;
var statearr_17874_17922 = state_17869__$1;
(statearr_17874_17922[(2)] = null);

(statearr_17874_17922[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17870 === (4))){
var inst_17809 = (state_17869[(2)]);
var inst_17810 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_17811 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_17809);
var inst_17812 = cljs.core.async.close_BANG_(result_ch);
var state_17869__$1 = (function (){var statearr_17875 = state_17869;
(statearr_17875[(7)] = inst_17811);

(statearr_17875[(8)] = inst_17810);

return statearr_17875;
})();
var statearr_17876_17923 = state_17869__$1;
(statearr_17876_17923[(2)] = inst_17812);

(statearr_17876_17923[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17870 === (15))){
var inst_17834 = (state_17869[(2)]);
var state_17869__$1 = state_17869;
var statearr_17877_17924 = state_17869__$1;
(statearr_17877_17924[(2)] = inst_17834);

(statearr_17877_17924[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17870 === (21))){
var inst_17821 = (state_17869[(9)]);
var inst_17822 = (state_17869[(10)]);
var inst_17851 = (state_17869[(11)]);
var inst_17823 = (state_17869[(12)]);
var inst_17838 = (state_17869[(13)]);
var inst_17858 = (state_17869[(2)]);
var inst_17859 = (function (){var base_node = inst_17821;
var first_flake = inst_17822;
var node_t = inst_17823;
var source = inst_17838;
var coll = inst_17851;
var conj_QMARK_ = inst_17858;
return (function (acc,f){
if(cljs.core.truth_((function (){var G__17879 = f.p;
var fexpr__17878 = (function (){var or__4212__auto__ = remove_preds;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})();
return (fexpr__17878.cljs$core$IFn$_invoke$arity$1 ? fexpr__17878.cljs$core$IFn$_invoke$arity$1(G__17879) : fexpr__17878.call(null,G__17879));
})())){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
if(cljs.core.truth_((conj_QMARK_.cljs$core$IFn$_invoke$arity$1 ? conj_QMARK_.cljs$core$IFn$_invoke$arity$1(f) : conj_QMARK_.call(null,f)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);

}
}
});
})();
var inst_17860 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_17821);
var inst_17861 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_17859,inst_17860,inst_17851);
var inst_17862 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_17861);
var inst_17863 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_17821,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_17862);
var inst_17864 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_17863);
var _ = (function (){var statearr_17880 = state_17869;
(statearr_17880[(4)] = cljs.core.rest((state_17869[(4)])));

return statearr_17880;
})();
var state_17869__$1 = state_17869;
var statearr_17881_17925 = state_17869__$1;
(statearr_17881_17925[(2)] = inst_17864);

(statearr_17881_17925[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17870 === (13))){
var state_17869__$1 = state_17869;
var statearr_17882_17926 = state_17869__$1;
(statearr_17882_17926[(2)] = new cljs.core.Keyword(null,"none","none",1333468478));

(statearr_17882_17926[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17870 === (22))){
var inst_17821 = (state_17869[(9)]);
var inst_17822 = (state_17869[(10)]);
var inst_17851 = (state_17869[(11)]);
var inst_17823 = (state_17869[(12)]);
var inst_17838 = (state_17869[(13)]);
var inst_17852 = (function (){var base_node = inst_17821;
var first_flake = inst_17822;
var node_t = inst_17823;
var source = inst_17838;
var coll = inst_17851;
return (function (f){
return f.op === true;
});
})();
var state_17869__$1 = state_17869;
var statearr_17883_17927 = state_17869__$1;
(statearr_17883_17927[(2)] = inst_17852);

(statearr_17883_17927[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17870 === (6))){
var inst_17821 = (state_17869[(9)]);
var inst_17823 = (state_17869[(12)]);
var inst_17820 = (state_17869[(2)]);
var inst_17821__$1 = fluree.db.util.async.throw_err(inst_17820);
var inst_17822 = fluree.db.dbproto._first_flake(inst_17821__$1);
var inst_17823__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_17821__$1);
var inst_17824 = (inst_17823__$1 > t);
var state_17869__$1 = (function (){var statearr_17884 = state_17869;
(statearr_17884[(9)] = inst_17821__$1);

(statearr_17884[(10)] = inst_17822);

(statearr_17884[(12)] = inst_17823__$1);

return statearr_17884;
})();
if(cljs.core.truth_(inst_17824)){
var statearr_17885_17928 = state_17869__$1;
(statearr_17885_17928[(1)] = (7));

} else {
var statearr_17886_17929 = state_17869__$1;
(statearr_17886_17929[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17870 === (17))){
var inst_17822 = (state_17869[(10)]);
var inst_17839 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_17822,rhs,leftmost_QMARK_,t);
var state_17869__$1 = state_17869;
var statearr_17887_17930 = state_17869__$1;
(statearr_17887_17930[(2)] = inst_17839);

(statearr_17887_17930[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17870 === (3))){
var inst_17867 = (state_17869[(2)]);
var state_17869__$1 = state_17869;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17869__$1,inst_17867);
} else {
if((state_val_17870 === (12))){
var inst_17836 = (state_17869[(2)]);
var state_17869__$1 = state_17869;
var statearr_17888_17931 = state_17869__$1;
(statearr_17888_17931[(2)] = inst_17836);

(statearr_17888_17931[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17870 === (2))){
var _ = (function (){var statearr_17889 = state_17869;
(statearr_17889[(4)] = cljs.core.cons((5),(state_17869[(4)])));

return statearr_17889;
})();
var inst_17818 = fluree.db.dbproto._resolve(node);
var state_17869__$1 = state_17869;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17869__$1,(6),inst_17818);
} else {
if((state_val_17870 === (23))){
var inst_17821 = (state_17869[(9)]);
var inst_17822 = (state_17869[(10)]);
var inst_17851 = (state_17869[(11)]);
var inst_17823 = (state_17869[(12)]);
var inst_17838 = (state_17869[(13)]);
var inst_17854 = (function (){var base_node = inst_17821;
var first_flake = inst_17822;
var node_t = inst_17823;
var source = inst_17838;
var coll = inst_17851;
return (function (f){
return f.op === false;
});
})();
var state_17869__$1 = state_17869;
var statearr_17890_17932 = state_17869__$1;
(statearr_17890_17932[(2)] = inst_17854);

(statearr_17890_17932[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17870 === (19))){
var inst_17841 = (state_17869[(14)]);
var inst_17844 = (state_17869[(2)]);
var inst_17845 = fluree.db.util.async.throw_err(inst_17844);
var inst_17846 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_17841,inst_17845);
var state_17869__$1 = state_17869;
var statearr_17891_17933 = state_17869__$1;
(statearr_17891_17933[(2)] = inst_17846);

(statearr_17891_17933[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17870 === (11))){
var inst_17823 = (state_17869[(12)]);
var inst_17830 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_17823,t);
var state_17869__$1 = state_17869;
if(inst_17830){
var statearr_17893_17934 = state_17869__$1;
(statearr_17893_17934[(1)] = (13));

} else {
var statearr_17894_17935 = state_17869__$1;
(statearr_17894_17935[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17870 === (9))){
var inst_17838 = (state_17869[(13)]);
var inst_17838__$1 = (state_17869[(2)]);
var state_17869__$1 = (function (){var statearr_17895 = state_17869;
(statearr_17895[(13)] = inst_17838__$1);

return statearr_17895;
})();
var G__17896_17936 = inst_17838__$1;
var G__17896_17937__$1 = (((G__17896_17936 instanceof cljs.core.Keyword))?G__17896_17936.fqn:null);
switch (G__17896_17937__$1) {
case "novelty":
var statearr_17897_17939 = state_17869__$1;
(statearr_17897_17939[(1)] = (17));


break;
case "history":
var statearr_17898_17940 = state_17869__$1;
(statearr_17898_17940[(1)] = (18));


break;
case "none":
var statearr_17899_17941 = state_17869__$1;
(statearr_17899_17941[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__17896_17937__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17870 === (5))){
var _ = (function (){var statearr_17900 = state_17869;
(statearr_17900[(4)] = cljs.core.rest((state_17869[(4)])));

return statearr_17900;
})();
var state_17869__$1 = state_17869;
var ex17892 = (state_17869__$1[(2)]);
var statearr_17901_17942 = state_17869__$1;
(statearr_17901_17942[(5)] = ex17892);


var statearr_17902_17943 = state_17869__$1;
(statearr_17902_17943[(1)] = (4));

(statearr_17902_17943[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17870 === (14))){
var state_17869__$1 = state_17869;
var statearr_17903_17944 = state_17869__$1;
(statearr_17903_17944[(2)] = null);

(statearr_17903_17944[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17870 === (16))){
var inst_17838 = (state_17869[(13)]);
var inst_17851 = (state_17869[(2)]);
var state_17869__$1 = (function (){var statearr_17904 = state_17869;
(statearr_17904[(11)] = inst_17851);

return statearr_17904;
})();
var G__17905_17945 = inst_17838;
var G__17905_17946__$1 = (((G__17905_17945 instanceof cljs.core.Keyword))?G__17905_17945.fqn:null);
switch (G__17905_17946__$1) {
case "novelty":
var statearr_17906_17948 = state_17869__$1;
(statearr_17906_17948[(1)] = (22));


break;
case "history":
var statearr_17907_17949 = state_17869__$1;
(statearr_17907_17949[(1)] = (23));


break;
case "none":
var statearr_17908_17950 = state_17869__$1;
(statearr_17908_17950[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__17905_17946__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17870 === (10))){
var state_17869__$1 = state_17869;
var statearr_17909_17951 = state_17869__$1;
(statearr_17909_17951[(2)] = new cljs.core.Keyword(null,"history","history",-247395220));

(statearr_17909_17951[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17870 === (18))){
var inst_17821 = (state_17869[(9)]);
var inst_17822 = (state_17869[(10)]);
var inst_17823 = (state_17869[(12)]);
var inst_17838 = (state_17869[(13)]);
var inst_17841 = (function (){var base_node = inst_17821;
var first_flake = inst_17822;
var node_t = inst_17823;
var source = inst_17838;
return (function (p1__17808_SHARP_){
return (p1__17808_SHARP_.t <= t);
});
})();
var inst_17842 = fluree.db.dbproto._resolve_history(node);
var state_17869__$1 = (function (){var statearr_17910 = state_17869;
(statearr_17910[(14)] = inst_17841);

return statearr_17910;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17869__$1,(19),inst_17842);
} else {
if((state_val_17870 === (8))){
var inst_17823 = (state_17869[(12)]);
var inst_17827 = (inst_17823 < t);
var state_17869__$1 = state_17869;
if(cljs.core.truth_(inst_17827)){
var statearr_17911_17952 = state_17869__$1;
(statearr_17911_17952[(1)] = (10));

} else {
var statearr_17912_17953 = state_17869__$1;
(statearr_17912_17953[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__2717__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__2717__auto____0 = (function (){
var statearr_17913 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17913[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__2717__auto__);

(statearr_17913[(1)] = (1));

return statearr_17913;
});
var fluree$db$storage$core$resolve_t_$_state_machine__2717__auto____1 = (function (state_17869){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_17869);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e17914){var ex__2720__auto__ = e17914;
var statearr_17915_17954 = state_17869;
(statearr_17915_17954[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_17869[(4)]))){
var statearr_17916_17955 = state_17869;
(statearr_17916_17955[(1)] = cljs.core.first((state_17869[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17956 = state_17869;
state_17869 = G__17956;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__2717__auto__ = function(state_17869){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__2717__auto____1.call(this,state_17869);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__2717__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__2717__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_17917 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_17917[(6)] = c__2739__auto___17918);

return statearr_17917;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_18016){
var state_val_18017 = (state_18016[(1)]);
if((state_val_18017 === (7))){
var inst_17967 = (state_18016[(7)]);
var inst_17971 = (inst_17967 <= from_t);
var state_18016__$1 = state_18016;
var statearr_18018_18058 = state_18016__$1;
(statearr_18018_18058[(2)] = inst_17971);

(statearr_18018_18058[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18017 === (20))){
var inst_18001 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(node);
var inst_18002 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_18001)].join('');
var inst_18003 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18004 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_18005 = cljs.core.PersistentHashMap.fromArrays(inst_18003,inst_18004);
var inst_18006 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_18002,inst_18005);
var inst_18007 = (function(){throw inst_18006})();
var state_18016__$1 = state_18016;
var statearr_18019_18059 = state_18016__$1;
(statearr_18019_18059[(2)] = inst_18007);

(statearr_18019_18059[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18017 === (1))){
var state_18016__$1 = state_18016;
var statearr_18020_18060 = state_18016__$1;
(statearr_18020_18060[(2)] = null);

(statearr_18020_18060[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18017 === (4))){
var inst_17959 = (state_18016[(2)]);
var inst_17960 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_17959], 0));
var inst_17961 = (function(){throw inst_17959})();
var state_18016__$1 = (function (){var statearr_18021 = state_18016;
(statearr_18021[(8)] = inst_17960);

return statearr_18021;
})();
var statearr_18022_18061 = state_18016__$1;
(statearr_18022_18061[(2)] = inst_17961);

(statearr_18022_18061[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18017 === (15))){
var inst_17986 = (state_18016[(2)]);
var state_18016__$1 = (function (){var statearr_18023 = state_18016;
(statearr_18023[(9)] = inst_17986);

return statearr_18023;
})();
if(cljs.core.truth_(from_t)){
var statearr_18024_18062 = state_18016__$1;
(statearr_18024_18062[(1)] = (16));

} else {
var statearr_18025_18063 = state_18016__$1;
(statearr_18025_18063[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18017 === (21))){
var inst_17997 = (state_18016[(10)]);
var inst_17996 = (state_18016[(11)]);
var inst_17995 = (state_18016[(12)]);
var inst_18009 = (state_18016[(2)]);
var inst_18010 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_17996,inst_17997,leftmost_QMARK_,to_t);
var inst_18011 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_18010,inst_17995);
var _ = (function (){var statearr_18026 = state_18016;
(statearr_18026[(4)] = cljs.core.rest((state_18016[(4)])));

return statearr_18026;
})();
var state_18016__$1 = (function (){var statearr_18027 = state_18016;
(statearr_18027[(13)] = inst_18009);

return statearr_18027;
})();
var statearr_18028_18064 = state_18016__$1;
(statearr_18028_18064[(2)] = inst_18011);

(statearr_18028_18064[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18017 === (13))){
var inst_17979 = (state_18016[(14)]);
var inst_17967 = (state_18016[(7)]);
var inst_17982 = (function (){var node_t = inst_17967;
var G__17975 = inst_17979;
return (function (p1__17957_SHARP_){
return (p1__17957_SHARP_.t < to_t);
});
})();
var inst_17983 = cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(inst_17982,inst_17979);
var state_18016__$1 = state_18016;
var statearr_18029_18065 = state_18016__$1;
(statearr_18029_18065[(2)] = inst_17983);

(statearr_18029_18065[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18017 === (6))){
var inst_17968 = (state_18016[(15)]);
var state_18016__$1 = state_18016;
var statearr_18030_18066 = state_18016__$1;
(statearr_18030_18066[(2)] = inst_17968);

(statearr_18030_18066[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18017 === (17))){
var inst_17986 = (state_18016[(9)]);
var state_18016__$1 = state_18016;
var statearr_18031_18067 = state_18016__$1;
(statearr_18031_18067[(2)] = inst_17986);

(statearr_18031_18067[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18017 === (3))){
var inst_18014 = (state_18016[(2)]);
var state_18016__$1 = state_18016;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18016__$1,inst_18014);
} else {
if((state_val_18017 === (12))){
var inst_17967 = (state_18016[(7)]);
var inst_17978 = (state_18016[(2)]);
var inst_17979 = fluree.db.util.async.throw_err(inst_17978);
var inst_17980 = (to_t > inst_17967);
var state_18016__$1 = (function (){var statearr_18032 = state_18016;
(statearr_18032[(14)] = inst_17979);

return statearr_18032;
})();
if(cljs.core.truth_(inst_17980)){
var statearr_18033_18068 = state_18016__$1;
(statearr_18033_18068[(1)] = (13));

} else {
var statearr_18034_18069 = state_18016__$1;
(statearr_18034_18069[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18017 === (2))){
var inst_17968 = (state_18016[(15)]);
var _ = (function (){var statearr_18035 = state_18016;
(statearr_18035[(4)] = cljs.core.cons((5),(state_18016[(4)])));

return statearr_18035;
})();
var inst_17967 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(node);
var inst_17968__$1 = (from_t == null);
var state_18016__$1 = (function (){var statearr_18036 = state_18016;
(statearr_18036[(15)] = inst_17968__$1);

(statearr_18036[(7)] = inst_17967);

return statearr_18036;
})();
if(cljs.core.truth_(inst_17968__$1)){
var statearr_18037_18070 = state_18016__$1;
(statearr_18037_18070[(1)] = (6));

} else {
var statearr_18038_18071 = state_18016__$1;
(statearr_18038_18071[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18017 === (19))){
var state_18016__$1 = state_18016;
var statearr_18039_18072 = state_18016__$1;
(statearr_18039_18072[(2)] = null);

(statearr_18039_18072[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18017 === (11))){
var inst_17995 = (state_18016[(2)]);
var inst_17996 = fluree.db.dbproto._first_flake(node);
var inst_17997 = fluree.db.dbproto._rhs(node);
var inst_17998 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node);
var state_18016__$1 = (function (){var statearr_18041 = state_18016;
(statearr_18041[(10)] = inst_17997);

(statearr_18041[(11)] = inst_17996);

(statearr_18041[(12)] = inst_17995);

return statearr_18041;
})();
if(cljs.core.truth_(inst_17998)){
var statearr_18042_18073 = state_18016__$1;
(statearr_18042_18073[(1)] = (19));

} else {
var statearr_18043_18074 = state_18016__$1;
(statearr_18043_18074[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18017 === (9))){
var inst_17976 = fluree.db.dbproto._resolve_history(node);
var state_18016__$1 = state_18016;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18016__$1,(12),inst_17976);
} else {
if((state_val_18017 === (5))){
var _ = (function (){var statearr_18044 = state_18016;
(statearr_18044[(4)] = cljs.core.rest((state_18016[(4)])));

return statearr_18044;
})();
var state_18016__$1 = state_18016;
var ex18040 = (state_18016__$1[(2)]);
var statearr_18045_18075 = state_18016__$1;
(statearr_18045_18075[(5)] = ex18040);


var statearr_18046_18076 = state_18016__$1;
(statearr_18046_18076[(1)] = (4));

(statearr_18046_18076[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18017 === (14))){
var inst_17979 = (state_18016[(14)]);
var state_18016__$1 = state_18016;
var statearr_18047_18077 = state_18016__$1;
(statearr_18047_18077[(2)] = inst_17979);

(statearr_18047_18077[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18017 === (16))){
var inst_17986 = (state_18016[(9)]);
var inst_17967 = (state_18016[(7)]);
var inst_17988 = (function (){var node_t = inst_17967;
var G__17975 = inst_17986;
return (function (p1__17958_SHARP_){
return (p1__17958_SHARP_.t <= from_t);
});
})();
var inst_17989 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_17988,inst_17986);
var state_18016__$1 = state_18016;
var statearr_18048_18078 = state_18016__$1;
(statearr_18048_18078[(2)] = inst_17989);

(statearr_18048_18078[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18017 === (10))){
var state_18016__$1 = state_18016;
var statearr_18049_18079 = state_18016__$1;
(statearr_18049_18079[(2)] = null);

(statearr_18049_18079[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18017 === (18))){
var inst_17992 = (state_18016[(2)]);
var state_18016__$1 = state_18016;
var statearr_18050_18080 = state_18016__$1;
(statearr_18050_18080[(2)] = inst_17992);

(statearr_18050_18080[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18017 === (8))){
var inst_17973 = (state_18016[(2)]);
var state_18016__$1 = state_18016;
if(cljs.core.truth_(inst_17973)){
var statearr_18051_18081 = state_18016__$1;
(statearr_18051_18081[(1)] = (9));

} else {
var statearr_18052_18082 = state_18016__$1;
(statearr_18052_18082[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__2717__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__2717__auto____0 = (function (){
var statearr_18053 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18053[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__2717__auto__);

(statearr_18053[(1)] = (1));

return statearr_18053;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__2717__auto____1 = (function (state_18016){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_18016);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e18054){var ex__2720__auto__ = e18054;
var statearr_18055_18083 = state_18016;
(statearr_18055_18083[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_18016[(4)]))){
var statearr_18056_18084 = state_18016;
(statearr_18056_18084[(1)] = cljs.core.first((state_18016[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18085 = state_18016;
state_18016 = G__18085;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__2717__auto__ = function(state_18016){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2717__auto____1.call(this,state_18016);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__2717__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__2717__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_18057 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_18057[(6)] = c__2739__auto__);

return statearr_18057;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__4212__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"empty","empty",767870958),id);
}
})())){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_(remove_preds)))){
var G__18086_18096 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__18087_18097 = null;
(object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18086_18096,G__18087_18097) : object_cache.call(null,G__18086_18096,G__18087_18097));

var G__18088 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__18089 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__18090 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__18091 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18090,G__18091) : object_cache.call(null,G__18090,G__18091));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18088,G__18089) : object_cache.call(null,G__18088,G__18089));
} else {
var G__18092 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__18093 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__18094 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__18095 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18094,G__18095) : object_cache.call(null,G__18094,G__18095));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18092,G__18093) : object_cache.call(null,G__18092,G__18093));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_18118){
var state_val_18119 = (state_18118[(1)]);
if((state_val_18119 === (7))){
var inst_18107 = (state_18118[(7)]);
var inst_18109 = fluree.db.storage.core.serde(conn);
var inst_18110 = fluree.db.serde.protocol._deserialize_branch(inst_18109,inst_18107);
var state_18118__$1 = state_18118;
var statearr_18120_18139 = state_18118__$1;
(statearr_18120_18139[(2)] = inst_18110);

(statearr_18120_18139[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18119 === (1))){
var state_18118__$1 = state_18118;
var statearr_18121_18140 = state_18118__$1;
(statearr_18121_18140[(2)] = null);

(statearr_18121_18140[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18119 === (4))){
var inst_18098 = (state_18118[(2)]);
var state_18118__$1 = state_18118;
var statearr_18122_18141 = state_18118__$1;
(statearr_18122_18141[(2)] = inst_18098);

(statearr_18122_18141[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18119 === (6))){
var inst_18107 = (state_18118[(7)]);
var inst_18106 = (state_18118[(2)]);
var inst_18107__$1 = fluree.db.util.async.throw_err(inst_18106);
var state_18118__$1 = (function (){var statearr_18123 = state_18118;
(statearr_18123[(7)] = inst_18107__$1);

return statearr_18123;
})();
if(cljs.core.truth_(inst_18107__$1)){
var statearr_18124_18142 = state_18118__$1;
(statearr_18124_18142[(1)] = (7));

} else {
var statearr_18125_18143 = state_18118__$1;
(statearr_18125_18143[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18119 === (3))){
var inst_18116 = (state_18118[(2)]);
var state_18118__$1 = state_18118;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18118__$1,inst_18116);
} else {
if((state_val_18119 === (2))){
var _ = (function (){var statearr_18127 = state_18118;
(statearr_18127[(4)] = cljs.core.cons((5),(state_18118[(4)])));

return statearr_18127;
})();
var inst_18104 = fluree.db.storage.core.storage_read(conn,key);
var state_18118__$1 = state_18118;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18118__$1,(6),inst_18104);
} else {
if((state_val_18119 === (9))){
var inst_18113 = (state_18118[(2)]);
var _ = (function (){var statearr_18128 = state_18118;
(statearr_18128[(4)] = cljs.core.rest((state_18118[(4)])));

return statearr_18128;
})();
var state_18118__$1 = state_18118;
var statearr_18129_18144 = state_18118__$1;
(statearr_18129_18144[(2)] = inst_18113);

(statearr_18129_18144[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18119 === (5))){
var _ = (function (){var statearr_18130 = state_18118;
(statearr_18130[(4)] = cljs.core.rest((state_18118[(4)])));

return statearr_18130;
})();
var state_18118__$1 = state_18118;
var ex18126 = (state_18118__$1[(2)]);
var statearr_18131_18145 = state_18118__$1;
(statearr_18131_18145[(5)] = ex18126);


if((ex18126 instanceof Error)){
var statearr_18132_18146 = state_18118__$1;
(statearr_18132_18146[(1)] = (4));

(statearr_18132_18146[(5)] = null);

} else {
throw ex18126;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18119 === (8))){
var state_18118__$1 = state_18118;
var statearr_18133_18147 = state_18118__$1;
(statearr_18133_18147[(2)] = null);

(statearr_18133_18147[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__2717__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__2717__auto____0 = (function (){
var statearr_18134 = [null,null,null,null,null,null,null,null];
(statearr_18134[(0)] = fluree$db$storage$core$read_branch_$_state_machine__2717__auto__);

(statearr_18134[(1)] = (1));

return statearr_18134;
});
var fluree$db$storage$core$read_branch_$_state_machine__2717__auto____1 = (function (state_18118){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_18118);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e18135){var ex__2720__auto__ = e18135;
var statearr_18136_18148 = state_18118;
(statearr_18136_18148[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_18118[(4)]))){
var statearr_18137_18149 = state_18118;
(statearr_18137_18149[(1)] = cljs.core.first((state_18118[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18150 = state_18118;
state_18118 = G__18150;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__2717__auto__ = function(state_18118){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__2717__auto____1.call(this,state_18118);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__2717__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__2717__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_18138 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_18138[(6)] = c__2739__auto__);

return statearr_18138;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2739__auto___18229 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_18201){
var state_val_18202 = (state_18201[(1)]);
if((state_val_18202 === (7))){
var inst_18168 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_18169 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18170 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_18171 = cljs.core.PersistentHashMap.fromArrays(inst_18169,inst_18170);
var inst_18172 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_18168,inst_18171);
var inst_18173 = (function(){throw inst_18172})();
var state_18201__$1 = state_18201;
var statearr_18203_18230 = state_18201__$1;
(statearr_18203_18230[(2)] = inst_18173);

(statearr_18203_18230[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18202 === (1))){
var state_18201__$1 = state_18201;
var statearr_18204_18231 = state_18201__$1;
(statearr_18204_18231[(2)] = null);

(statearr_18204_18231[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18202 === (4))){
var inst_18151 = (state_18201[(2)]);
var inst_18152 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_18153 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_18151);
var inst_18154 = cljs.core.async.close_BANG_(return_ch);
var state_18201__$1 = (function (){var statearr_18205 = state_18201;
(statearr_18205[(7)] = inst_18152);

(statearr_18205[(8)] = inst_18153);

return statearr_18205;
})();
var statearr_18206_18232 = state_18201__$1;
(statearr_18206_18232[(2)] = inst_18154);

(statearr_18206_18232[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18202 === (6))){
var inst_18165 = (state_18201[(9)]);
var inst_18164 = (state_18201[(2)]);
var inst_18165__$1 = fluree.db.util.async.throw_err(inst_18164);
var inst_18166 = (inst_18165__$1 == null);
var state_18201__$1 = (function (){var statearr_18207 = state_18201;
(statearr_18207[(9)] = inst_18165__$1);

return statearr_18207;
})();
if(cljs.core.truth_(inst_18166)){
var statearr_18208_18233 = state_18201__$1;
(statearr_18208_18233[(1)] = (7));

} else {
var statearr_18209_18234 = state_18201__$1;
(statearr_18209_18234[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18202 === (3))){
var inst_18199 = (state_18201[(2)]);
var state_18201__$1 = state_18201;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18201__$1,inst_18199);
} else {
if((state_val_18202 === (12))){
var inst_18165 = (state_18201[(9)]);
var inst_18182 = (state_18201[(2)]);
var inst_18183 = cljs.core.__destructure_map(inst_18165);
var inst_18184 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18183,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_18185 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18183,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var inst_18186 = config;
var inst_18187 = cljs.core.__destructure_map(inst_18186);
var inst_18188 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18187,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_18190 = (function (){var data = inst_18165;
var _ = inst_18182;
var map__18160 = inst_18183;
var children = inst_18184;
var rhs = inst_18185;
var map__18161 = inst_18187;
var comparator = inst_18188;
return (function (idx,p__18189){
var map__18210 = p__18189;
var map__18210__$1 = cljs.core.__destructure_map(map__18210);
var child = map__18210__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18210__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18210__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18210__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18210__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18210__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var at_leftmost_QMARK_ = (function (){var and__4210__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4210__auto__)){
return (idx === (0));
} else {
return and__4210__auto__;
}
})();
return (fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14 ? fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14(conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid) : fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid));
});
})();
var inst_18191 = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(inst_18190,inst_18184);
var inst_18192 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"first","first",-644103046),inst_18191);
var inst_18193 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(inst_18192,inst_18191);
var inst_18194 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(clojure.data.avl.sorted_map_by,inst_18188,inst_18193);
var inst_18195 = fluree.db.index.__GT_IndexNode(block,t,inst_18185,inst_18194,config,leftmost_QMARK_);
var inst_18196 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_18195);
var _ = (function (){var statearr_18211 = state_18201;
(statearr_18211[(4)] = cljs.core.rest((state_18201[(4)])));

return statearr_18211;
})();
var state_18201__$1 = state_18201;
var statearr_18212_18235 = state_18201__$1;
(statearr_18212_18235[(2)] = inst_18196);

(statearr_18212_18235[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18202 === (2))){
var _ = (function (){var statearr_18213 = state_18201;
(statearr_18213[(4)] = cljs.core.cons((5),(state_18201[(4)])));

return statearr_18213;
})();
var inst_18162 = fluree.db.storage.core.read_branch(conn,key);
var state_18201__$1 = state_18201;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18201__$1,(6),inst_18162);
} else {
if((state_val_18202 === (11))){
var state_18201__$1 = state_18201;
var statearr_18215_18236 = state_18201__$1;
(statearr_18215_18236[(2)] = null);

(statearr_18215_18236[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18202 === (9))){
var inst_18165 = (state_18201[(9)]);
var inst_18176 = (state_18201[(2)]);
var inst_18177 = fluree.db.util.core.exception_QMARK_(inst_18165);
var state_18201__$1 = (function (){var statearr_18216 = state_18201;
(statearr_18216[(10)] = inst_18176);

return statearr_18216;
})();
if(inst_18177){
var statearr_18217_18237 = state_18201__$1;
(statearr_18217_18237[(1)] = (10));

} else {
var statearr_18218_18238 = state_18201__$1;
(statearr_18218_18238[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18202 === (5))){
var _ = (function (){var statearr_18219 = state_18201;
(statearr_18219[(4)] = cljs.core.rest((state_18201[(4)])));

return statearr_18219;
})();
var state_18201__$1 = state_18201;
var ex18214 = (state_18201__$1[(2)]);
var statearr_18220_18239 = state_18201__$1;
(statearr_18220_18239[(5)] = ex18214);


var statearr_18221_18240 = state_18201__$1;
(statearr_18221_18240[(1)] = (4));

(statearr_18221_18240[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18202 === (10))){
var inst_18165 = (state_18201[(9)]);
var inst_18179 = (function(){throw inst_18165})();
var state_18201__$1 = state_18201;
var statearr_18222_18241 = state_18201__$1;
(statearr_18222_18241[(2)] = inst_18179);

(statearr_18222_18241[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18202 === (8))){
var state_18201__$1 = state_18201;
var statearr_18223_18242 = state_18201__$1;
(statearr_18223_18242[(2)] = null);

(statearr_18223_18242[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__2717__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__2717__auto____0 = (function (){
var statearr_18224 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18224[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__2717__auto__);

(statearr_18224[(1)] = (1));

return statearr_18224;
});
var fluree$db$storage$core$reify_branch_$_state_machine__2717__auto____1 = (function (state_18201){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_18201);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e18225){var ex__2720__auto__ = e18225;
var statearr_18226_18243 = state_18201;
(statearr_18226_18243[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_18201[(4)]))){
var statearr_18227_18244 = state_18201;
(statearr_18227_18244[(1)] = cljs.core.first((state_18201[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18245 = state_18201;
state_18201 = G__18245;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__2717__auto__ = function(state_18201){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__2717__auto____1.call(this,state_18201);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__2717__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__2717__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_18228 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_18228[(6)] = c__2739__auto___18229);

return statearr_18228;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_18266){
var state_val_18267 = (state_18266[(1)]);
if((state_val_18267 === (7))){
var state_18266__$1 = state_18266;
var statearr_18268_18288 = state_18266__$1;
(statearr_18268_18288[(2)] = null);

(statearr_18268_18288[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18267 === (1))){
var state_18266__$1 = state_18266;
var statearr_18269_18289 = state_18266__$1;
(statearr_18269_18289[(2)] = null);

(statearr_18269_18289[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18267 === (4))){
var inst_18246 = (state_18266[(2)]);
var state_18266__$1 = state_18266;
var statearr_18270_18290 = state_18266__$1;
(statearr_18270_18290[(2)] = inst_18246);

(statearr_18270_18290[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18267 === (6))){
var inst_18252 = (state_18266[(7)]);
var inst_18254 = fluree.db.storage.core.serde(conn);
var state_18266__$1 = (function (){var statearr_18271 = state_18266;
(statearr_18271[(8)] = inst_18254);

return statearr_18271;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18266__$1,(9),inst_18252);
} else {
if((state_val_18267 === (3))){
var inst_18264 = (state_18266[(2)]);
var state_18266__$1 = state_18266;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18266__$1,inst_18264);
} else {
if((state_val_18267 === (2))){
var inst_18252 = (state_18266[(7)]);
var _ = (function (){var statearr_18273 = state_18266;
(statearr_18273[(4)] = cljs.core.cons((5),(state_18266[(4)])));

return statearr_18273;
})();
var inst_18252__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_18266__$1 = (function (){var statearr_18274 = state_18266;
(statearr_18274[(7)] = inst_18252__$1);

return statearr_18274;
})();
if(cljs.core.truth_(inst_18252__$1)){
var statearr_18275_18291 = state_18266__$1;
(statearr_18275_18291[(1)] = (6));

} else {
var statearr_18276_18292 = state_18266__$1;
(statearr_18276_18292[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18267 === (9))){
var inst_18254 = (state_18266[(8)]);
var inst_18256 = (state_18266[(2)]);
var inst_18257 = fluree.db.util.async.throw_err(inst_18256);
var inst_18258 = fluree.db.serde.protocol._deserialize_leaf(inst_18254,inst_18257);
var state_18266__$1 = state_18266;
var statearr_18277_18293 = state_18266__$1;
(statearr_18277_18293[(2)] = inst_18258);

(statearr_18277_18293[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18267 === (5))){
var _ = (function (){var statearr_18278 = state_18266;
(statearr_18278[(4)] = cljs.core.rest((state_18266[(4)])));

return statearr_18278;
})();
var state_18266__$1 = state_18266;
var ex18272 = (state_18266__$1[(2)]);
var statearr_18279_18294 = state_18266__$1;
(statearr_18279_18294[(5)] = ex18272);


if((ex18272 instanceof Error)){
var statearr_18280_18295 = state_18266__$1;
(statearr_18280_18295[(1)] = (4));

(statearr_18280_18295[(5)] = null);

} else {
throw ex18272;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18267 === (8))){
var inst_18261 = (state_18266[(2)]);
var _ = (function (){var statearr_18281 = state_18266;
(statearr_18281[(4)] = cljs.core.rest((state_18266[(4)])));

return statearr_18281;
})();
var state_18266__$1 = state_18266;
var statearr_18282_18296 = state_18266__$1;
(statearr_18282_18296[(2)] = inst_18261);

(statearr_18282_18296[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__2717__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__2717__auto____0 = (function (){
var statearr_18283 = [null,null,null,null,null,null,null,null,null];
(statearr_18283[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__2717__auto__);

(statearr_18283[(1)] = (1));

return statearr_18283;
});
var fluree$db$storage$core$read_leaf_$_state_machine__2717__auto____1 = (function (state_18266){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_18266);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e18284){var ex__2720__auto__ = e18284;
var statearr_18285_18297 = state_18266;
(statearr_18285_18297[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_18266[(4)]))){
var statearr_18286_18298 = state_18266;
(statearr_18286_18298[(1)] = cljs.core.first((state_18266[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18299 = state_18266;
state_18266 = G__18299;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__2717__auto__ = function(state_18266){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__2717__auto____1.call(this,state_18266);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__2717__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__2717__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_18287 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_18287[(6)] = c__2739__auto__);

return statearr_18287;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([config], 0))].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2739__auto___18372 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_18344){
var state_val_18345 = (state_18344[(1)]);
if((state_val_18345 === (7))){
var inst_18316 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_18317 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18318 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_18319 = cljs.core.PersistentHashMap.fromArrays(inst_18317,inst_18318);
var inst_18320 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_18316,inst_18319);
var inst_18321 = (function(){throw inst_18320})();
var state_18344__$1 = state_18344;
var statearr_18346_18373 = state_18344__$1;
(statearr_18346_18373[(2)] = inst_18321);

(statearr_18346_18373[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18345 === (1))){
var state_18344__$1 = state_18344;
var statearr_18347_18374 = state_18344__$1;
(statearr_18347_18374[(2)] = null);

(statearr_18347_18374[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18345 === (4))){
var inst_18300 = (state_18344[(2)]);
var inst_18301 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_18302 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_18300);
var inst_18303 = cljs.core.async.close_BANG_(return_ch);
var state_18344__$1 = (function (){var statearr_18348 = state_18344;
(statearr_18348[(7)] = inst_18301);

(statearr_18348[(8)] = inst_18302);

return statearr_18348;
})();
var statearr_18349_18375 = state_18344__$1;
(statearr_18349_18375[(2)] = inst_18303);

(statearr_18349_18375[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18345 === (6))){
var inst_18313 = (state_18344[(9)]);
var inst_18313__$1 = (state_18344[(2)]);
var inst_18314 = (inst_18313__$1 == null);
var state_18344__$1 = (function (){var statearr_18350 = state_18344;
(statearr_18350[(9)] = inst_18313__$1);

return statearr_18350;
})();
if(cljs.core.truth_(inst_18314)){
var statearr_18351_18376 = state_18344__$1;
(statearr_18351_18376[(1)] = (7));

} else {
var statearr_18352_18377 = state_18344__$1;
(statearr_18352_18377[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18345 === (3))){
var inst_18342 = (state_18344[(2)]);
var state_18344__$1 = state_18344;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18344__$1,inst_18342);
} else {
if((state_val_18345 === (12))){
var inst_18313 = (state_18344[(9)]);
var inst_18330 = (state_18344[(2)]);
var inst_18331 = cljs.core.__destructure_map(inst_18313);
var inst_18332 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18331,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_18333 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18331,new cljs.core.Keyword(null,"his","his",-1294347076));
var inst_18334 = config;
var inst_18335 = cljs.core.__destructure_map(inst_18334);
var inst_18336 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18335,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_18337 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,inst_18336,inst_18332);
var inst_18338 = fluree.db.index.data_node(block,t,inst_18337,rhs,config);
var inst_18339 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_18338);
var _ = (function (){var statearr_18353 = state_18344;
(statearr_18353[(4)] = cljs.core.rest((state_18344[(4)])));

return statearr_18353;
})();
var state_18344__$1 = (function (){var statearr_18354 = state_18344;
(statearr_18354[(10)] = inst_18333);

(statearr_18354[(11)] = inst_18330);

return statearr_18354;
})();
var statearr_18355_18378 = state_18344__$1;
(statearr_18355_18378[(2)] = inst_18339);

(statearr_18355_18378[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18345 === (2))){
var _ = (function (){var statearr_18356 = state_18344;
(statearr_18356[(4)] = cljs.core.cons((5),(state_18344[(4)])));

return statearr_18356;
})();
var inst_18311 = fluree.db.storage.core.read_leaf(conn,key);
var state_18344__$1 = state_18344;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18344__$1,(6),inst_18311);
} else {
if((state_val_18345 === (11))){
var state_18344__$1 = state_18344;
var statearr_18358_18379 = state_18344__$1;
(statearr_18358_18379[(2)] = null);

(statearr_18358_18379[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18345 === (9))){
var inst_18313 = (state_18344[(9)]);
var inst_18324 = (state_18344[(2)]);
var inst_18325 = fluree.db.util.core.exception_QMARK_(inst_18313);
var state_18344__$1 = (function (){var statearr_18359 = state_18344;
(statearr_18359[(12)] = inst_18324);

return statearr_18359;
})();
if(inst_18325){
var statearr_18360_18380 = state_18344__$1;
(statearr_18360_18380[(1)] = (10));

} else {
var statearr_18361_18381 = state_18344__$1;
(statearr_18361_18381[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18345 === (5))){
var _ = (function (){var statearr_18362 = state_18344;
(statearr_18362[(4)] = cljs.core.rest((state_18344[(4)])));

return statearr_18362;
})();
var state_18344__$1 = state_18344;
var ex18357 = (state_18344__$1[(2)]);
var statearr_18363_18382 = state_18344__$1;
(statearr_18363_18382[(5)] = ex18357);


var statearr_18364_18383 = state_18344__$1;
(statearr_18364_18383[(1)] = (4));

(statearr_18364_18383[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18345 === (10))){
var inst_18313 = (state_18344[(9)]);
var inst_18327 = (function(){throw inst_18313})();
var state_18344__$1 = state_18344;
var statearr_18365_18384 = state_18344__$1;
(statearr_18365_18384[(2)] = inst_18327);

(statearr_18365_18384[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18345 === (8))){
var state_18344__$1 = state_18344;
var statearr_18366_18385 = state_18344__$1;
(statearr_18366_18385[(2)] = null);

(statearr_18366_18385[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__2717__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__2717__auto____0 = (function (){
var statearr_18367 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18367[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__2717__auto__);

(statearr_18367[(1)] = (1));

return statearr_18367;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__2717__auto____1 = (function (state_18344){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_18344);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e18368){var ex__2720__auto__ = e18368;
var statearr_18369_18386 = state_18344;
(statearr_18369_18386[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_18344[(4)]))){
var statearr_18370_18387 = state_18344;
(statearr_18370_18387[(1)] = cljs.core.first((state_18344[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18388 = state_18344;
state_18344 = G__18388;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__2717__auto__ = function(state_18344){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__2717__auto____1.call(this,state_18344);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__2717__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__2717__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_18371 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_18371[(6)] = c__2739__auto___18372);

return statearr_18371;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k18390,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__18394 = k18390;
var G__18394__$1 = (((G__18394 instanceof cljs.core.Keyword))?G__18394.fqn:null);
switch (G__18394__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k18390,else__4464__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__18395){
var vec__18396 = p__18395;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18396,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18396,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"first","first",-644103046),self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"size","size",1098693007),self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__18389){
var self__ = this;
var G__18389__$1 = this;
return (new cljs.core.RecordIter((0),G__18389__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"empty","empty",767870958),self__.id)){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,fluree.db.index.data_node((0),(0),fluree.db.flake.sorted_set_by(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var G__18399 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__18400 = (function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf(self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
var G__18401 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__18402 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18401,G__18402) : object_cache.call(null,G__18401,G__18402));
}));
} else {
return fluree.db.storage.core.reify_branch(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
var G__18403 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__18404 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18403,G__18404) : object_cache.call(null,G__18403,G__18404));
}));
}
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18399,G__18400) : object_cache.call(null,G__18399,G__18400));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(history_id,null) : object_cache.call(null,history_id,null));
});
var G__18405 = history_id;
var G__18406 = (function (___$2){
return fluree.db.storage.core.reify_history(self__.conn,history_id,error_fn);
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__18405,G__18406) : object_cache.call(null,G__18405,G__18406));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (14 + cljs.core.count(self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__18407 = (function (coll__4458__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__18407(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this18391,other18392){
var self__ = this;
var this18391__$1 = this;
return (((!((other18392 == null)))) && ((((this18391__$1.constructor === other18392.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18391__$1.conn,other18392.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18391__$1.config,other18392.config)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18391__$1.network,other18392.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18391__$1.dbid,other18392.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18391__$1.id,other18392.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18391__$1.leaf,other18392.leaf)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18391__$1.first,other18392.first)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18391__$1.rhs,other18392.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18391__$1.size,other18392.size)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18391__$1.block,other18392.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18391__$1.t,other18392.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18391__$1.tt_id,other18392.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18391__$1.leftmost_QMARK_,other18392.leftmost_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18391__$1.tempid,other18392.tempid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18391__$1.__extmap,other18392.__extmap)))))))))))))))))))))))))))))))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"first","first",-644103046),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k18390){
var self__ = this;
var this__4468__auto____$1 = this;
var G__18408 = k18390;
var G__18408__$1 = (((G__18408 instanceof cljs.core.Keyword))?G__18408.fqn:null);
switch (G__18408__$1) {
case "conn":
case "config":
case "network":
case "dbid":
case "id":
case "leaf":
case "first":
case "rhs":
case "size":
case "block":
case "t":
case "tt-id":
case "leftmost?":
case "tempid":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k18390);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__18389){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__18409 = cljs.core.keyword_identical_QMARK_;
var expr__18410 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__18412 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__18413 = expr__18410;
return (pred__18409.cljs$core$IFn$_invoke$arity$2 ? pred__18409.cljs$core$IFn$_invoke$arity$2(G__18412,G__18413) : pred__18409.call(null,G__18412,G__18413));
})())){
return (new fluree.db.storage.core.UnresolvedNode(G__18389,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18414 = new cljs.core.Keyword(null,"config","config",994861415);
var G__18415 = expr__18410;
return (pred__18409.cljs$core$IFn$_invoke$arity$2 ? pred__18409.cljs$core$IFn$_invoke$arity$2(G__18414,G__18415) : pred__18409.call(null,G__18414,G__18415));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__18389,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18416 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__18417 = expr__18410;
return (pred__18409.cljs$core$IFn$_invoke$arity$2 ? pred__18409.cljs$core$IFn$_invoke$arity$2(G__18416,G__18417) : pred__18409.call(null,G__18416,G__18417));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__18389,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18418 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__18419 = expr__18410;
return (pred__18409.cljs$core$IFn$_invoke$arity$2 ? pred__18409.cljs$core$IFn$_invoke$arity$2(G__18418,G__18419) : pred__18409.call(null,G__18418,G__18419));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__18389,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18420 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__18421 = expr__18410;
return (pred__18409.cljs$core$IFn$_invoke$arity$2 ? pred__18409.cljs$core$IFn$_invoke$arity$2(G__18420,G__18421) : pred__18409.call(null,G__18420,G__18421));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__18389,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18422 = new cljs.core.Keyword(null,"leaf","leaf",1306118732);
var G__18423 = expr__18410;
return (pred__18409.cljs$core$IFn$_invoke$arity$2 ? pred__18409.cljs$core$IFn$_invoke$arity$2(G__18422,G__18423) : pred__18409.call(null,G__18422,G__18423));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__18389,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18424 = new cljs.core.Keyword(null,"first","first",-644103046);
var G__18425 = expr__18410;
return (pred__18409.cljs$core$IFn$_invoke$arity$2 ? pred__18409.cljs$core$IFn$_invoke$arity$2(G__18424,G__18425) : pred__18409.call(null,G__18424,G__18425));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__18389,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18426 = new cljs.core.Keyword(null,"rhs","rhs",-229356739);
var G__18427 = expr__18410;
return (pred__18409.cljs$core$IFn$_invoke$arity$2 ? pred__18409.cljs$core$IFn$_invoke$arity$2(G__18426,G__18427) : pred__18409.call(null,G__18426,G__18427));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__18389,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18428 = new cljs.core.Keyword(null,"size","size",1098693007);
var G__18429 = expr__18410;
return (pred__18409.cljs$core$IFn$_invoke$arity$2 ? pred__18409.cljs$core$IFn$_invoke$arity$2(G__18428,G__18429) : pred__18409.call(null,G__18428,G__18429));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__18389,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18430 = new cljs.core.Keyword(null,"block","block",664686210);
var G__18431 = expr__18410;
return (pred__18409.cljs$core$IFn$_invoke$arity$2 ? pred__18409.cljs$core$IFn$_invoke$arity$2(G__18430,G__18431) : pred__18409.call(null,G__18430,G__18431));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__18389,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18432 = new cljs.core.Keyword(null,"t","t",-1397832519);
var G__18433 = expr__18410;
return (pred__18409.cljs$core$IFn$_invoke$arity$2 ? pred__18409.cljs$core$IFn$_invoke$arity$2(G__18432,G__18433) : pred__18409.call(null,G__18432,G__18433));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__18389,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18434 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484);
var G__18435 = expr__18410;
return (pred__18409.cljs$core$IFn$_invoke$arity$2 ? pred__18409.cljs$core$IFn$_invoke$arity$2(G__18434,G__18435) : pred__18409.call(null,G__18434,G__18435));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__18389,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18436 = new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559);
var G__18437 = expr__18410;
return (pred__18409.cljs$core$IFn$_invoke$arity$2 ? pred__18409.cljs$core$IFn$_invoke$arity$2(G__18436,G__18437) : pred__18409.call(null,G__18436,G__18437));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__18389,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18438 = new cljs.core.Keyword(null,"tempid","tempid",1427663222);
var G__18439 = expr__18410;
return (pred__18409.cljs$core$IFn$_invoke$arity$2 ? pred__18409.cljs$core$IFn$_invoke$arity$2(G__18438,G__18439) : pred__18409.call(null,G__18438,G__18439));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__18389,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__18389),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"first","first",-644103046),self__.first,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"size","size",1098693007),self__.size,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__18389){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__18389,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"config","config",-1659574354,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"leaf","leaf",-1348317037,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"leftmost?","leftmost?",-31657032,null),new cljs.core.Symbol(null,"tempid","tempid",-1226772547,null)], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__18393){
var extmap__4501__auto__ = (function (){var G__18440 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__18393,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], 0));
if(cljs.core.record_QMARK_(G__18393)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__18440);
} else {
return G__18440;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__18393),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__18393),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__18393),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__18393),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__18393),new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(G__18393),new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(G__18393),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__18393),new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(G__18393),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__18393),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__18393),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__18393),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(G__18393),new cljs.core.Keyword(null,"tempid","tempid",1427663222).cljs$core$IFn$_invoke$arity$1(G__18393),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,index);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Internal error reifying db root index: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([index], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(index_data,new cljs.core.Keyword(null,"conn","conn",278309663),conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"config","config",994861415),cfg,new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true], 0)));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__18443 = blank_db;
var map__18443__$1 = cljs.core.__destructure_map(map__18443);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18443__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18443__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var index_configs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18443__$1,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280));
var map__18444 = root_data;
var map__18444__$1 = cljs.core.__destructure_map(map__18444);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18444__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18444__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18444__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18444__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block)], 0));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (db,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,idx,fluree.db.storage.core.reify_index_root(conn,index_configs,network,dbid,idx,cljs.core.get.cljs$core$IFn$_invoke$arity$2(root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_18466){
var state_val_18467 = (state_18466[(1)]);
if((state_val_18467 === (7))){
var state_18466__$1 = state_18466;
var statearr_18468_18488 = state_18466__$1;
(statearr_18468_18488[(2)] = null);

(statearr_18468_18488[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18467 === (1))){
var state_18466__$1 = state_18466;
var statearr_18469_18489 = state_18466__$1;
(statearr_18469_18489[(2)] = null);

(statearr_18469_18489[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18467 === (4))){
var inst_18445 = (state_18466[(2)]);
var state_18466__$1 = state_18466;
var statearr_18470_18490 = state_18466__$1;
(statearr_18470_18490[(2)] = inst_18445);

(statearr_18470_18490[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18467 === (6))){
var inst_18452 = (state_18466[(7)]);
var inst_18454 = fluree.db.storage.core.serde(conn);
var state_18466__$1 = (function (){var statearr_18471 = state_18466;
(statearr_18471[(8)] = inst_18454);

return statearr_18471;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18466__$1,(9),inst_18452);
} else {
if((state_val_18467 === (3))){
var inst_18464 = (state_18466[(2)]);
var state_18466__$1 = state_18466;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18466__$1,inst_18464);
} else {
if((state_val_18467 === (2))){
var inst_18452 = (state_18466[(7)]);
var _ = (function (){var statearr_18473 = state_18466;
(statearr_18473[(4)] = cljs.core.cons((5),(state_18466[(4)])));

return statearr_18473;
})();
var inst_18451 = fluree.db.storage.core.ledger_garbage_key(network,dbid,block);
var inst_18452__$1 = fluree.db.storage.core.storage_read(conn,inst_18451);
var state_18466__$1 = (function (){var statearr_18474 = state_18466;
(statearr_18474[(7)] = inst_18452__$1);

return statearr_18474;
})();
if(cljs.core.truth_(inst_18452__$1)){
var statearr_18475_18491 = state_18466__$1;
(statearr_18475_18491[(1)] = (6));

} else {
var statearr_18476_18492 = state_18466__$1;
(statearr_18476_18492[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18467 === (9))){
var inst_18454 = (state_18466[(8)]);
var inst_18456 = (state_18466[(2)]);
var inst_18457 = fluree.db.util.async.throw_err(inst_18456);
var inst_18458 = fluree.db.serde.protocol._deserialize_garbage(inst_18454,inst_18457);
var state_18466__$1 = state_18466;
var statearr_18477_18493 = state_18466__$1;
(statearr_18477_18493[(2)] = inst_18458);

(statearr_18477_18493[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18467 === (5))){
var _ = (function (){var statearr_18478 = state_18466;
(statearr_18478[(4)] = cljs.core.rest((state_18466[(4)])));

return statearr_18478;
})();
var state_18466__$1 = state_18466;
var ex18472 = (state_18466__$1[(2)]);
var statearr_18479_18494 = state_18466__$1;
(statearr_18479_18494[(5)] = ex18472);


if((ex18472 instanceof Error)){
var statearr_18480_18495 = state_18466__$1;
(statearr_18480_18495[(1)] = (4));

(statearr_18480_18495[(5)] = null);

} else {
throw ex18472;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18467 === (8))){
var inst_18461 = (state_18466[(2)]);
var _ = (function (){var statearr_18481 = state_18466;
(statearr_18481[(4)] = cljs.core.rest((state_18466[(4)])));

return statearr_18481;
})();
var state_18466__$1 = state_18466;
var statearr_18482_18496 = state_18466__$1;
(statearr_18482_18496[(2)] = inst_18461);

(statearr_18482_18496[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__2717__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__2717__auto____0 = (function (){
var statearr_18483 = [null,null,null,null,null,null,null,null,null];
(statearr_18483[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__2717__auto__);

(statearr_18483[(1)] = (1));

return statearr_18483;
});
var fluree$db$storage$core$read_garbage_$_state_machine__2717__auto____1 = (function (state_18466){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_18466);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e18484){var ex__2720__auto__ = e18484;
var statearr_18485_18497 = state_18466;
(statearr_18485_18497[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_18466[(4)]))){
var statearr_18486_18498 = state_18466;
(statearr_18486_18498[(1)] = cljs.core.first((state_18466[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18499 = state_18466;
state_18466 = G__18499;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__2717__auto__ = function(state_18466){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__2717__auto____1.call(this,state_18466);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__2717__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__2717__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_18487 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_18487[(6)] = c__2739__auto__);

return statearr_18487;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_18521){
var state_val_18522 = (state_18521[(1)]);
if((state_val_18522 === (7))){
var inst_18510 = (state_18521[(7)]);
var inst_18512 = fluree.db.storage.core.serde(conn);
var inst_18513 = fluree.db.serde.protocol._deserialize_db_root(inst_18512,inst_18510);
var state_18521__$1 = state_18521;
var statearr_18523_18542 = state_18521__$1;
(statearr_18523_18542[(2)] = inst_18513);

(statearr_18523_18542[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18522 === (1))){
var state_18521__$1 = state_18521;
var statearr_18524_18543 = state_18521__$1;
(statearr_18524_18543[(2)] = null);

(statearr_18524_18543[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18522 === (4))){
var inst_18500 = (state_18521[(2)]);
var state_18521__$1 = state_18521;
var statearr_18525_18544 = state_18521__$1;
(statearr_18525_18544[(2)] = inst_18500);

(statearr_18525_18544[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18522 === (6))){
var inst_18510 = (state_18521[(7)]);
var inst_18509 = (state_18521[(2)]);
var inst_18510__$1 = fluree.db.util.async.throw_err(inst_18509);
var state_18521__$1 = (function (){var statearr_18526 = state_18521;
(statearr_18526[(7)] = inst_18510__$1);

return statearr_18526;
})();
if(cljs.core.truth_(inst_18510__$1)){
var statearr_18527_18545 = state_18521__$1;
(statearr_18527_18545[(1)] = (7));

} else {
var statearr_18528_18546 = state_18521__$1;
(statearr_18528_18546[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18522 === (3))){
var inst_18519 = (state_18521[(2)]);
var state_18521__$1 = state_18521;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18521__$1,inst_18519);
} else {
if((state_val_18522 === (2))){
var _ = (function (){var statearr_18530 = state_18521;
(statearr_18530[(4)] = cljs.core.cons((5),(state_18521[(4)])));

return statearr_18530;
})();
var inst_18506 = fluree.db.storage.core.ledger_root_key(network,dbid,block);
var inst_18507 = fluree.db.storage.core.storage_read(conn,inst_18506);
var state_18521__$1 = state_18521;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18521__$1,(6),inst_18507);
} else {
if((state_val_18522 === (9))){
var inst_18516 = (state_18521[(2)]);
var _ = (function (){var statearr_18531 = state_18521;
(statearr_18531[(4)] = cljs.core.rest((state_18521[(4)])));

return statearr_18531;
})();
var state_18521__$1 = state_18521;
var statearr_18532_18547 = state_18521__$1;
(statearr_18532_18547[(2)] = inst_18516);

(statearr_18532_18547[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18522 === (5))){
var _ = (function (){var statearr_18533 = state_18521;
(statearr_18533[(4)] = cljs.core.rest((state_18521[(4)])));

return statearr_18533;
})();
var state_18521__$1 = state_18521;
var ex18529 = (state_18521__$1[(2)]);
var statearr_18534_18548 = state_18521__$1;
(statearr_18534_18548[(5)] = ex18529);


if((ex18529 instanceof Error)){
var statearr_18535_18549 = state_18521__$1;
(statearr_18535_18549[(1)] = (4));

(statearr_18535_18549[(5)] = null);

} else {
throw ex18529;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18522 === (8))){
var state_18521__$1 = state_18521;
var statearr_18536_18550 = state_18521__$1;
(statearr_18536_18550[(2)] = null);

(statearr_18536_18550[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__2717__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__2717__auto____0 = (function (){
var statearr_18537 = [null,null,null,null,null,null,null,null];
(statearr_18537[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__2717__auto__);

(statearr_18537[(1)] = (1));

return statearr_18537;
});
var fluree$db$storage$core$read_db_root_$_state_machine__2717__auto____1 = (function (state_18521){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_18521);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e18538){var ex__2720__auto__ = e18538;
var statearr_18539_18551 = state_18521;
(statearr_18539_18551[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_18521[(4)]))){
var statearr_18540_18552 = state_18521;
(statearr_18540_18552[(1)] = cljs.core.first((state_18521[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18553 = state_18521;
state_18521 = G__18553;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__2717__auto__ = function(state_18521){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__2717__auto____1.call(this,state_18521);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__2717__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__2717__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_18541 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_18541[(6)] = c__2739__auto__);

return statearr_18541;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_18589){
var state_val_18590 = (state_18589[(1)]);
if((state_val_18590 === (7))){
var inst_18563 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_18564 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18565 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_18566 = cljs.core.PersistentHashMap.fromArrays(inst_18564,inst_18565);
var inst_18567 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_18563,inst_18566);
var inst_18568 = (function(){throw inst_18567})();
var state_18589__$1 = state_18589;
var statearr_18591_18613 = state_18589__$1;
(statearr_18591_18613[(2)] = inst_18568);

(statearr_18591_18613[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18590 === (1))){
var state_18589__$1 = state_18589;
var statearr_18592_18614 = state_18589__$1;
(statearr_18592_18614[(2)] = null);

(statearr_18592_18614[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18590 === (4))){
var inst_18554 = (state_18589[(2)]);
var state_18589__$1 = state_18589;
var statearr_18593_18615 = state_18589__$1;
(statearr_18593_18615[(2)] = inst_18554);

(statearr_18593_18615[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18590 === (6))){
var state_18589__$1 = state_18589;
var statearr_18594_18616 = state_18589__$1;
(statearr_18594_18616[(2)] = null);

(statearr_18594_18616[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18590 === (3))){
var inst_18587 = (state_18589[(2)]);
var state_18589__$1 = state_18589;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18589__$1,inst_18587);
} else {
if((state_val_18590 === (2))){
var inst_18560 = (state_18589[(7)]);
var _ = (function (){var statearr_18595 = state_18589;
(statearr_18595[(4)] = cljs.core.cons((5),(state_18589[(4)])));

return statearr_18595;
})();
var inst_18560__$1 = fluree.db.storage.core.read_db_root(conn,network,dbid,index);
var state_18589__$1 = (function (){var statearr_18596 = state_18589;
(statearr_18596[(7)] = inst_18560__$1);

return statearr_18596;
})();
if(cljs.core.truth_(inst_18560__$1)){
var statearr_18597_18617 = state_18589__$1;
(statearr_18597_18617[(1)] = (6));

} else {
var statearr_18598_18618 = state_18589__$1;
(statearr_18598_18618[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18590 === (11))){
var inst_18579 = (state_18589[(8)]);
var inst_18582 = (state_18589[(2)]);
var inst_18583 = fluree.db.util.async.throw_err(inst_18582);
var inst_18584 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_18579,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_18583);
var _ = (function (){var statearr_18600 = state_18589;
(statearr_18600[(4)] = cljs.core.rest((state_18589[(4)])));

return statearr_18600;
})();
var state_18589__$1 = state_18589;
var statearr_18601_18619 = state_18589__$1;
(statearr_18601_18619[(2)] = inst_18584);

(statearr_18601_18619[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18590 === (9))){
var inst_18574 = (state_18589[(9)]);
var inst_18572 = (state_18589[(2)]);
var inst_18573 = fluree.db.util.async.throw_err(inst_18572);
var inst_18574__$1 = fluree.db.storage.core.reify_db_root(conn,blank_db,inst_18573);
var inst_18575 = fluree.db.query.schema.schema_map(inst_18574__$1);
var state_18589__$1 = (function (){var statearr_18602 = state_18589;
(statearr_18602[(9)] = inst_18574__$1);

return statearr_18602;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18589__$1,(10),inst_18575);
} else {
if((state_val_18590 === (5))){
var _ = (function (){var statearr_18603 = state_18589;
(statearr_18603[(4)] = cljs.core.rest((state_18589[(4)])));

return statearr_18603;
})();
var state_18589__$1 = state_18589;
var ex18599 = (state_18589__$1[(2)]);
var statearr_18604_18620 = state_18589__$1;
(statearr_18604_18620[(5)] = ex18599);


if((ex18599 instanceof Error)){
var statearr_18605_18621 = state_18589__$1;
(statearr_18605_18621[(1)] = (4));

(statearr_18605_18621[(5)] = null);

} else {
throw ex18599;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18590 === (10))){
var inst_18579 = (state_18589[(8)]);
var inst_18574 = (state_18589[(9)]);
var inst_18577 = (state_18589[(2)]);
var inst_18578 = fluree.db.util.async.throw_err(inst_18577);
var inst_18579__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_18574,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_18578);
var inst_18580 = fluree.db.query.schema.setting_map(inst_18579__$1);
var state_18589__$1 = (function (){var statearr_18606 = state_18589;
(statearr_18606[(8)] = inst_18579__$1);

return statearr_18606;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18589__$1,(11),inst_18580);
} else {
if((state_val_18590 === (8))){
var inst_18560 = (state_18589[(7)]);
var inst_18570 = (state_18589[(2)]);
var state_18589__$1 = (function (){var statearr_18607 = state_18589;
(statearr_18607[(10)] = inst_18570);

return statearr_18607;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18589__$1,(9),inst_18560);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__2717__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__2717__auto____0 = (function (){
var statearr_18608 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18608[(0)] = fluree$db$storage$core$reify_db_$_state_machine__2717__auto__);

(statearr_18608[(1)] = (1));

return statearr_18608;
});
var fluree$db$storage$core$reify_db_$_state_machine__2717__auto____1 = (function (state_18589){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_18589);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e18609){var ex__2720__auto__ = e18609;
var statearr_18610_18622 = state_18589;
(statearr_18610_18622[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_18589[(4)]))){
var statearr_18611_18623 = state_18589;
(statearr_18611_18623[(1)] = cljs.core.first((state_18589[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18624 = state_18589;
state_18589 = G__18624;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__2717__auto__ = function(state_18589){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__2717__auto____1.call(this,state_18589);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__2717__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__2717__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_18612 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_18612[(6)] = c__2739__auto__);

return statearr_18612;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__18626 = arguments.length;
switch (G__18626) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Block-range request: ",network,dbid,start,end], 0));

var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_18679){
var state_val_18680 = (state_18679[(1)]);
if((state_val_18680 === (7))){
var inst_18636 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_18637 = (new Error(inst_18636));
var inst_18638 = (function(){throw inst_18637})();
var state_18679__$1 = state_18679;
var statearr_18681_18721 = state_18679__$1;
(statearr_18681_18721[(2)] = inst_18638);

(statearr_18681_18721[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18680 === (20))){
var inst_18670 = (state_18679[(2)]);
var state_18679__$1 = state_18679;
var statearr_18682_18722 = state_18679__$1;
(statearr_18682_18722[(2)] = inst_18670);

(statearr_18682_18722[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18680 === (1))){
var state_18679__$1 = state_18679;
var statearr_18683_18723 = state_18679__$1;
(statearr_18683_18723[(2)] = null);

(statearr_18683_18723[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18680 === (4))){
var inst_18627 = (state_18679[(2)]);
var state_18679__$1 = state_18679;
var statearr_18684_18724 = state_18679__$1;
(statearr_18684_18724[(2)] = inst_18627);

(statearr_18684_18724[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18680 === (15))){
var inst_18645 = (state_18679[(7)]);
var state_18679__$1 = state_18679;
var statearr_18685_18725 = state_18679__$1;
(statearr_18685_18725[(2)] = inst_18645);

(statearr_18685_18725[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18680 === (21))){
var inst_18644 = (state_18679[(8)]);
var inst_18649 = (state_18679[(9)]);
var inst_18645 = (state_18679[(7)]);
var inst_18663 = (inst_18644 + (1));
var inst_18664 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_18645,inst_18649);
var inst_18644__$1 = inst_18663;
var inst_18645__$1 = inst_18664;
var state_18679__$1 = (function (){var statearr_18686 = state_18679;
(statearr_18686[(8)] = inst_18644__$1);

(statearr_18686[(7)] = inst_18645__$1);

return statearr_18686;
})();
var statearr_18687_18726 = state_18679__$1;
(statearr_18687_18726[(2)] = null);

(statearr_18687_18726[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18680 === (13))){
var inst_18649 = (state_18679[(9)]);
var inst_18653 = (inst_18649 instanceof Error);
var state_18679__$1 = state_18679;
var statearr_18688_18727 = state_18679__$1;
(statearr_18688_18727[(2)] = inst_18653);

(statearr_18688_18727[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18680 === (22))){
var state_18679__$1 = state_18679;
var statearr_18689_18728 = state_18679__$1;
(statearr_18689_18728[(2)] = null);

(statearr_18689_18728[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18680 === (6))){
var state_18679__$1 = state_18679;
var statearr_18690_18729 = state_18679__$1;
(statearr_18690_18729[(2)] = null);

(statearr_18690_18729[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18680 === (17))){
var inst_18672 = (state_18679[(2)]);
var state_18679__$1 = state_18679;
var statearr_18691_18730 = state_18679__$1;
(statearr_18691_18730[(2)] = inst_18672);

(statearr_18691_18730[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18680 === (3))){
var inst_18677 = (state_18679[(2)]);
var state_18679__$1 = state_18679;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18679__$1,inst_18677);
} else {
if((state_val_18680 === (12))){
var inst_18650 = (state_18679[(10)]);
var state_18679__$1 = state_18679;
var statearr_18692_18731 = state_18679__$1;
(statearr_18692_18731[(2)] = inst_18650);

(statearr_18692_18731[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18680 === (2))){
var _ = (function (){var statearr_18693 = state_18679;
(statearr_18693[(4)] = cljs.core.cons((5),(state_18679[(4)])));

return statearr_18693;
})();
var inst_18633 = (end >= start);
var state_18679__$1 = state_18679;
if(cljs.core.truth_(inst_18633)){
var statearr_18694_18732 = state_18679__$1;
(statearr_18694_18732[(1)] = (6));

} else {
var statearr_18695_18733 = state_18679__$1;
(statearr_18695_18733[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18680 === (23))){
var inst_18668 = (state_18679[(2)]);
var state_18679__$1 = state_18679;
var statearr_18696_18734 = state_18679__$1;
(statearr_18696_18734[(2)] = inst_18668);

(statearr_18696_18734[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18680 === (19))){
var state_18679__$1 = state_18679;
var statearr_18697_18735 = state_18679__$1;
(statearr_18697_18735[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18680 === (11))){
var inst_18649 = (state_18679[(9)]);
var inst_18650 = (state_18679[(10)]);
var inst_18649__$1 = (state_18679[(2)]);
var inst_18650__$1 = (inst_18649__$1 == null);
var state_18679__$1 = (function (){var statearr_18700 = state_18679;
(statearr_18700[(9)] = inst_18649__$1);

(statearr_18700[(10)] = inst_18650__$1);

return statearr_18700;
})();
if(cljs.core.truth_(inst_18650__$1)){
var statearr_18701_18736 = state_18679__$1;
(statearr_18701_18736[(1)] = (12));

} else {
var statearr_18702_18737 = state_18679__$1;
(statearr_18702_18737[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18680 === (9))){
var inst_18644 = (state_18679[(8)]);
var inst_18647 = fluree.db.storage.core.read_block(conn,network,dbid,inst_18644);
var state_18679__$1 = state_18679;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18679__$1,(11),inst_18647);
} else {
if((state_val_18680 === (5))){
var _ = (function (){var statearr_18703 = state_18679;
(statearr_18703[(4)] = cljs.core.rest((state_18679[(4)])));

return statearr_18703;
})();
var state_18679__$1 = state_18679;
var ex18699 = (state_18679__$1[(2)]);
var statearr_18704_18738 = state_18679__$1;
(statearr_18704_18738[(5)] = ex18699);


if((ex18699 instanceof Error)){
var statearr_18705_18739 = state_18679__$1;
(statearr_18705_18739[(1)] = (4));

(statearr_18705_18739[(5)] = null);

} else {
throw ex18699;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18680 === (14))){
var inst_18655 = (state_18679[(2)]);
var state_18679__$1 = state_18679;
if(cljs.core.truth_(inst_18655)){
var statearr_18706_18740 = state_18679__$1;
(statearr_18706_18740[(1)] = (15));

} else {
var statearr_18707_18741 = state_18679__$1;
(statearr_18707_18741[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18680 === (16))){
var inst_18644 = (state_18679[(8)]);
var inst_18658 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_18644,end);
var state_18679__$1 = state_18679;
if(inst_18658){
var statearr_18708_18742 = state_18679__$1;
(statearr_18708_18742[(1)] = (18));

} else {
var statearr_18709_18743 = state_18679__$1;
(statearr_18709_18743[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18680 === (10))){
var inst_18674 = (state_18679[(2)]);
var _ = (function (){var statearr_18710 = state_18679;
(statearr_18710[(4)] = cljs.core.rest((state_18679[(4)])));

return statearr_18710;
})();
var state_18679__$1 = state_18679;
var statearr_18711_18744 = state_18679__$1;
(statearr_18711_18744[(2)] = inst_18674);

(statearr_18711_18744[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18680 === (18))){
var inst_18649 = (state_18679[(9)]);
var inst_18645 = (state_18679[(7)]);
var inst_18660 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_18645,inst_18649);
var state_18679__$1 = state_18679;
var statearr_18712_18745 = state_18679__$1;
(statearr_18712_18745[(2)] = inst_18660);

(statearr_18712_18745[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18680 === (8))){
var inst_18640 = (state_18679[(2)]);
var inst_18641 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(conn);
var inst_18642 = start;
var inst_18643 = cljs.core.PersistentVector.EMPTY;
var inst_18644 = inst_18642;
var inst_18645 = inst_18643;
var state_18679__$1 = (function (){var statearr_18713 = state_18679;
(statearr_18713[(8)] = inst_18644);

(statearr_18713[(11)] = inst_18641);

(statearr_18713[(12)] = inst_18640);

(statearr_18713[(7)] = inst_18645);

return statearr_18713;
})();
var statearr_18714_18746 = state_18679__$1;
(statearr_18714_18746[(2)] = null);

(statearr_18714_18746[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2717__auto__ = null;
var fluree$db$storage$core$state_machine__2717__auto____0 = (function (){
var statearr_18715 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18715[(0)] = fluree$db$storage$core$state_machine__2717__auto__);

(statearr_18715[(1)] = (1));

return statearr_18715;
});
var fluree$db$storage$core$state_machine__2717__auto____1 = (function (state_18679){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_18679);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e18716){var ex__2720__auto__ = e18716;
var statearr_18717_18747 = state_18679;
(statearr_18717_18747[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_18679[(4)]))){
var statearr_18718_18748 = state_18679;
(statearr_18718_18748[(1)] = cljs.core.first((state_18679[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18749 = state_18679;
state_18679 = G__18749;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2717__auto__ = function(state_18679){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2717__auto____1.call(this,state_18679);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2717__auto____0;
fluree$db$storage$core$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2717__auto____1;
return fluree$db$storage$core$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_18719 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_18719[(6)] = c__2739__auto__);

return statearr_18719;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_18765){
var state_val_18766 = (state_18765[(1)]);
if((state_val_18766 === (1))){
var state_18765__$1 = state_18765;
var statearr_18767_18781 = state_18765__$1;
(statearr_18767_18781[(2)] = null);

(statearr_18767_18781[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18766 === (2))){
var _ = (function (){var statearr_18768 = state_18765;
(statearr_18768[(4)] = cljs.core.cons((5),(state_18765[(4)])));

return statearr_18768;
})();
var inst_18756 = fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,block,block);
var state_18765__$1 = state_18765;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18765__$1,(6),inst_18756);
} else {
if((state_val_18766 === (3))){
var inst_18763 = (state_18765[(2)]);
var state_18765__$1 = state_18765;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18765__$1,inst_18763);
} else {
if((state_val_18766 === (4))){
var inst_18750 = (state_18765[(2)]);
var state_18765__$1 = state_18765;
var statearr_18770_18782 = state_18765__$1;
(statearr_18770_18782[(2)] = inst_18750);

(statearr_18770_18782[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18766 === (5))){
var _ = (function (){var statearr_18771 = state_18765;
(statearr_18771[(4)] = cljs.core.rest((state_18765[(4)])));

return statearr_18771;
})();
var state_18765__$1 = state_18765;
var ex18769 = (state_18765__$1[(2)]);
var statearr_18772_18783 = state_18765__$1;
(statearr_18772_18783[(5)] = ex18769);


if((ex18769 instanceof Error)){
var statearr_18773_18784 = state_18765__$1;
(statearr_18773_18784[(1)] = (4));

(statearr_18773_18784[(5)] = null);

} else {
throw ex18769;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18766 === (6))){
var inst_18758 = (state_18765[(2)]);
var inst_18759 = fluree.db.util.async.throw_err(inst_18758);
var inst_18760 = cljs.core.first(inst_18759);
var _ = (function (){var statearr_18774 = state_18765;
(statearr_18774[(4)] = cljs.core.rest((state_18765[(4)])));

return statearr_18774;
})();
var state_18765__$1 = state_18765;
var statearr_18775_18785 = state_18765__$1;
(statearr_18775_18785[(2)] = inst_18760);

(statearr_18775_18785[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__2717__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__2717__auto____0 = (function (){
var statearr_18776 = [null,null,null,null,null,null,null];
(statearr_18776[(0)] = fluree$db$storage$core$block_$_state_machine__2717__auto__);

(statearr_18776[(1)] = (1));

return statearr_18776;
});
var fluree$db$storage$core$block_$_state_machine__2717__auto____1 = (function (state_18765){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_18765);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e18777){var ex__2720__auto__ = e18777;
var statearr_18778_18786 = state_18765;
(statearr_18778_18786[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_18765[(4)]))){
var statearr_18779_18787 = state_18765;
(statearr_18779_18787[(1)] = cljs.core.first((state_18765[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18788 = state_18765;
state_18765 = G__18788;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__2717__auto__ = function(state_18765){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__2717__auto____1.call(this,state_18765);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__2717__auto____0;
fluree$db$storage$core$block_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__2717__auto____1;
return fluree$db$storage$core$block_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_18780 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_18780[(6)] = c__2739__auto__);

return statearr_18780;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
