// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"spot","spot",-1706962147),idx)) && ((((!((start_flake.o == null)))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(start_flake.o,end_flake.o)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),start_flake.p)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)))))))));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4212__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__13755 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13755,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13755,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13755,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13755,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13755,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13755,(5),null);
var G__13758 = idx;
var G__13758__$1 = (((G__13758 instanceof cljs.core.Keyword))?G__13758.fqn:null);
switch (G__13758__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13758__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__13760 = idx;
var G__13760__$1 = (((G__13760 instanceof cljs.core.Keyword))?G__13760.fqn:null);
switch (G__13760__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13760__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__13762 = idx;
var G__13762__$1 = (((G__13762 instanceof cljs.core.Keyword))?G__13762.fqn:null);
switch (G__13762__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13762__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__13765 = arguments.length;
switch (G__13765) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__13766 = (function (){var pred__13769 = cljs.core.identical_QMARK_;
var expr__13770 = test;
if(cljs.core.truth_((pred__13769.cljs$core$IFn$_invoke$arity$2 ? pred__13769.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__13770) : pred__13769.call(null,cljs.core._EQ_,expr__13770)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__13769.cljs$core$IFn$_invoke$arity$2 ? pred__13769.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__13770) : pred__13769.call(null,cljs.core._LT_,expr__13770)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__13769.cljs$core$IFn$_invoke$arity$2 ? pred__13769.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__13770) : pred__13769.call(null,cljs.core._LT__EQ_,expr__13770)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__13769.cljs$core$IFn$_invoke$arity$2 ? pred__13769.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__13770) : pred__13769.call(null,cljs.core._GT_,expr__13770)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__13769.cljs$core$IFn$_invoke$arity$2 ? pred__13769.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__13770) : pred__13769.call(null,cljs.core._GT__EQ_,expr__13770)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__13770)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13766,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13766,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13766,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13766,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_14009){
var state_val_14010 = (state_14009[(1)]);
if((state_val_14010 === (65))){
var inst_13924 = (state_14009[(7)]);
var inst_13980 = (state_14009[(8)]);
var inst_13980__$1 = (state_14009[(2)]);
var inst_13981 = cljs.core.count(inst_13980__$1);
var state_14009__$1 = (function (){var statearr_14011 = state_14009;
(statearr_14011[(9)] = inst_13981);

(statearr_14011[(8)] = inst_13980__$1);

return statearr_14011;
})();
if(cljs.core.truth_(inst_13924)){
var statearr_14012_14149 = state_14009__$1;
(statearr_14012_14149[(1)] = (81));

} else {
var statearr_14013_14150 = state_14009__$1;
(statearr_14013_14150[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (70))){
var inst_13955 = (state_14009[(2)]);
var state_14009__$1 = state_14009;
if(cljs.core.truth_(inst_13955)){
var statearr_14014_14151 = state_14009__$1;
(statearr_14014_14151[(1)] = (71));

} else {
var statearr_14015_14152 = state_14009__$1;
(statearr_14015_14152[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (62))){
var inst_13908 = (state_14009[(10)]);
var inst_13894 = (state_14009[(11)]);
var inst_13923 = (state_14009[(2)]);
var inst_13924 = fluree.db.dbproto._rhs(inst_13908);
var state_14009__$1 = (function (){var statearr_14016 = state_14009;
(statearr_14016[(12)] = inst_13923);

(statearr_14016[(7)] = inst_13924);

return statearr_14016;
})();
if(cljs.core.truth_(inst_13894)){
var statearr_14017_14153 = state_14009__$1;
(statearr_14017_14153[(1)] = (63));

} else {
var statearr_14018_14154 = state_14009__$1;
(statearr_14018_14154[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (74))){
var inst_13948 = (state_14009[(13)]);
var inst_13962 = fluree.db.permissions_validate.allow_flake_QMARK_.cljs$core$IFn$_invoke$arity$2(db,inst_13948);
var state_14009__$1 = state_14009;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14009__$1,(77),inst_13962);
} else {
if((state_val_14010 === (7))){
var inst_13785 = (state_14009[(14)]);
var state_14009__$1 = state_14009;
var statearr_14019_14155 = state_14009__$1;
(statearr_14019_14155[(2)] = inst_13785);

(statearr_14019_14155[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (59))){
var inst_13915 = (state_14009[(15)]);
var inst_13870 = (state_14009[(16)]);
var inst_13871 = (state_14009[(17)]);
var inst_13914 = (state_14009[(2)]);
var inst_13915__$1 = fluree.db.util.async.throw_err(inst_13914);
var inst_13916 = fluree.db.flake.subrange(inst_13915__$1,start_test,inst_13870,end_test,inst_13871);
var inst_13917 = fluree.db.query.range.value_with_nil_pred(idx,inst_13870,inst_13871);
var state_14009__$1 = (function (){var statearr_14020 = state_14009;
(statearr_14020[(15)] = inst_13915__$1);

(statearr_14020[(18)] = inst_13916);

return statearr_14020;
})();
if(inst_13917){
var statearr_14021_14156 = state_14009__$1;
(statearr_14021_14156[(1)] = (60));

} else {
var statearr_14022_14157 = state_14009__$1;
(statearr_14022_14157[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (86))){
var inst_13989 = (state_14009[(2)]);
var state_14009__$1 = state_14009;
var statearr_14023_14158 = state_14009__$1;
(statearr_14023_14158[(2)] = inst_13989);

(statearr_14023_14158[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (20))){
var inst_13834 = (state_14009[(19)]);
var inst_13786 = (state_14009[(20)]);
var inst_13833 = (state_14009[(2)]);
var inst_13834__$1 = (inst_13786 == null);
var state_14009__$1 = (function (){var statearr_14024 = state_14009;
(statearr_14024[(21)] = inst_13833);

(statearr_14024[(19)] = inst_13834__$1);

return statearr_14024;
})();
if(cljs.core.truth_(inst_13834__$1)){
var statearr_14025_14159 = state_14009__$1;
(statearr_14025_14159[(1)] = (22));

} else {
var statearr_14026_14160 = state_14009__$1;
(statearr_14026_14160[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (72))){
var inst_13941 = (state_14009[(22)]);
var inst_13959 = (inst_13941 + (1));
var inst_13960 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_14009__$1 = (function (){var statearr_14027 = state_14009;
(statearr_14027[(23)] = inst_13959);

return statearr_14027;
})();
if(cljs.core.truth_(inst_13960)){
var statearr_14028_14161 = state_14009__$1;
(statearr_14028_14161[(1)] = (74));

} else {
var statearr_14029_14162 = state_14009__$1;
(statearr_14029_14162[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (58))){
var inst_14004 = (state_14009[(2)]);
var _ = (function (){var statearr_14030 = state_14009;
(statearr_14030[(4)] = cljs.core.rest((state_14009[(4)])));

return statearr_14030;
})();
var state_14009__$1 = state_14009;
var statearr_14031_14163 = state_14009__$1;
(statearr_14031_14163[(2)] = inst_14004);

(statearr_14031_14163[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (60))){
var inst_13888 = (state_14009[(24)]);
var inst_13833 = (state_14009[(21)]);
var inst_13795 = (state_14009[(25)]);
var inst_13903 = (state_14009[(26)]);
var inst_13815 = (state_14009[(27)]);
var inst_13887 = (state_14009[(28)]);
var inst_13789 = (state_14009[(29)]);
var inst_13824 = (state_14009[(30)]);
var inst_13881 = (state_14009[(31)]);
var inst_13915 = (state_14009[(15)]);
var inst_13869 = (state_14009[(32)]);
var inst_13851 = (state_14009[(33)]);
var inst_13860 = (state_14009[(34)]);
var inst_13910 = (state_14009[(35)]);
var inst_13877 = (state_14009[(36)]);
var inst_13784 = (state_14009[(37)]);
var inst_13788 = (state_14009[(38)]);
var inst_13908 = (state_14009[(10)]);
var inst_13796 = (state_14009[(39)]);
var inst_13916 = (state_14009[(18)]);
var inst_13909 = (state_14009[(40)]);
var inst_13876 = (state_14009[(41)]);
var inst_13870 = (state_14009[(16)]);
var inst_13898 = (state_14009[(42)]);
var inst_13791 = (state_14009[(43)]);
var inst_13806 = (state_14009[(44)]);
var inst_13871 = (state_14009[(17)]);
var inst_13894 = (state_14009[(11)]);
var inst_13842 = (state_14009[(45)]);
var inst_13919 = (function (){var no_filter_QMARK_ = inst_13894;
var next_node = inst_13908;
var flakes = inst_13915;
var s1 = inst_13806;
var o2 = inst_13833;
var t1 = inst_13788;
var i = inst_13909;
var m1 = inst_13860;
var root_node = inst_13903;
var to_t = inst_13888;
var s2 = inst_13815;
var p2 = inst_13851;
var permissions = inst_13877;
var limit = inst_13876;
var start_flake = inst_13870;
var vec__13778 = inst_13784;
var acc = inst_13910;
var t2 = inst_13795;
var op1 = inst_13789;
var o1 = inst_13824;
var end_flake = inst_13871;
var base_result = inst_13916;
var p1 = inst_13842;
var vec__13781 = inst_13791;
var idx_compare = inst_13881;
var op2 = inst_13796;
var from_t = inst_13887;
var m2 = inst_13869;
var novelty = inst_13898;
return (function (filtered_result,f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(filtered_result,f);
}
});
})();
var inst_13920 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_13919,inst_13916,inst_13916);
var state_14009__$1 = state_14009;
var statearr_14032_14164 = state_14009__$1;
(statearr_14032_14164[(2)] = inst_13920);

(statearr_14032_14164[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (27))){
var inst_13793 = (state_14009[(46)]);
var inst_13843 = (state_14009[(47)]);
var inst_13842 = (state_14009[(2)]);
var inst_13843__$1 = (inst_13793 == null);
var state_14009__$1 = (function (){var statearr_14033 = state_14009;
(statearr_14033[(47)] = inst_13843__$1);

(statearr_14033[(45)] = inst_13842);

return statearr_14033;
})();
if(cljs.core.truth_(inst_13843__$1)){
var statearr_14034_14165 = state_14009__$1;
(statearr_14034_14165[(1)] = (28));

} else {
var statearr_14035_14166 = state_14009__$1;
(statearr_14035_14166[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (1))){
var state_14009__$1 = state_14009;
var statearr_14036_14167 = state_14009__$1;
(statearr_14036_14167[(2)] = null);

(statearr_14036_14167[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (69))){
var inst_13941 = (state_14009[(22)]);
var inst_13876 = (state_14009[(41)]);
var inst_13953 = (inst_13941 > inst_13876);
var state_14009__$1 = state_14009;
var statearr_14037_14168 = state_14009__$1;
(statearr_14037_14168[(2)] = inst_13953);

(statearr_14037_14168[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (24))){
var inst_13838 = (state_14009[(2)]);
var state_14009__$1 = state_14009;
if(cljs.core.truth_(inst_13838)){
var statearr_14038_14169 = state_14009__$1;
(statearr_14038_14169[(1)] = (25));

} else {
var statearr_14039_14170 = state_14009__$1;
(statearr_14039_14170[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (55))){
var inst_13903 = (state_14009[(26)]);
var inst_13870 = (state_14009[(16)]);
var inst_13902 = (state_14009[(2)]);
var inst_13903__$1 = fluree.db.util.async.throw_err(inst_13902);
var inst_13904 = fluree.db.dbproto._lookup_leaf(inst_13903__$1,inst_13870);
var state_14009__$1 = (function (){var statearr_14040 = state_14009;
(statearr_14040[(26)] = inst_13903__$1);

return statearr_14040;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14009__$1,(56),inst_13904);
} else {
if((state_val_14010 === (85))){
var inst_13984 = (state_14009[(48)]);
var state_14009__$1 = state_14009;
var statearr_14041_14171 = state_14009__$1;
(statearr_14041_14171[(2)] = inst_13984);

(statearr_14041_14171[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (39))){
var inst_13858 = (state_14009[(2)]);
var state_14009__$1 = state_14009;
var statearr_14042_14172 = state_14009__$1;
(statearr_14042_14172[(2)] = inst_13858);

(statearr_14042_14172[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (88))){
var inst_13903 = (state_14009[(26)]);
var inst_13924 = (state_14009[(7)]);
var inst_13996 = fluree.db.dbproto._lookup_leaf(inst_13903,inst_13924);
var state_14009__$1 = state_14009;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14009__$1,(90),inst_13996);
} else {
if((state_val_14010 === (46))){
var inst_13872 = (state_14009[(49)]);
var state_14009__$1 = state_14009;
var statearr_14043_14173 = state_14009__$1;
(statearr_14043_14173[(2)] = inst_13872);

(statearr_14043_14173[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (4))){
var inst_13772 = (state_14009[(2)]);
var state_14009__$1 = state_14009;
var statearr_14044_14174 = state_14009__$1;
(statearr_14044_14174[(2)] = inst_13772);

(statearr_14044_14174[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (77))){
var inst_13964 = (state_14009[(2)]);
var inst_13965 = fluree.db.util.async.throw_err(inst_13964);
var state_14009__$1 = state_14009;
if(cljs.core.truth_(inst_13965)){
var statearr_14045_14175 = state_14009__$1;
(statearr_14045_14175[(1)] = (78));

} else {
var statearr_14046_14176 = state_14009__$1;
(statearr_14046_14176[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (54))){
var inst_13894 = (state_14009[(2)]);
var inst_13895 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13896 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_13897 = (new cljs.core.PersistentVector(null,2,(5),inst_13895,inst_13896,null));
var inst_13898 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_13897);
var inst_13899 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_13900 = fluree.db.dbproto._resolve(inst_13899);
var state_14009__$1 = (function (){var statearr_14047 = state_14009;
(statearr_14047[(42)] = inst_13898);

(statearr_14047[(11)] = inst_13894);

return statearr_14047;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14009__$1,(55),inst_13900);
} else {
if((state_val_14010 === (15))){
var inst_13787 = (state_14009[(50)]);
var state_14009__$1 = state_14009;
var statearr_14048_14177 = state_14009__$1;
(statearr_14048_14177[(2)] = inst_13787);

(statearr_14048_14177[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (48))){
var inst_13882 = (state_14009[(51)]);
var inst_13876 = (state_14009[(2)]);
var inst_13877 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_13878 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13879 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_13880 = (new cljs.core.PersistentVector(null,3,(5),inst_13878,inst_13879,null));
var inst_13881 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_13880);
var inst_13882__$1 = new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(opts);
var state_14009__$1 = (function (){var statearr_14049 = state_14009;
(statearr_14049[(51)] = inst_13882__$1);

(statearr_14049[(31)] = inst_13881);

(statearr_14049[(36)] = inst_13877);

(statearr_14049[(41)] = inst_13876);

return statearr_14049;
})();
if(cljs.core.truth_(inst_13882__$1)){
var statearr_14050_14178 = state_14009__$1;
(statearr_14050_14178[(1)] = (49));

} else {
var statearr_14051_14179 = state_14009__$1;
(statearr_14051_14179[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (50))){
var inst_13885 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var state_14009__$1 = state_14009;
var statearr_14052_14180 = state_14009__$1;
(statearr_14052_14180[(2)] = inst_13885);

(statearr_14052_14180[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (75))){
var inst_13942 = (state_14009[(52)]);
var state_14009__$1 = state_14009;
var statearr_14053_14181 = state_14009__$1;
(statearr_14053_14181[(2)] = inst_13942);

(statearr_14053_14181[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (21))){
var inst_13829 = (state_14009[(2)]);
var inst_13830 = fluree.db.util.async.throw_err(inst_13829);
var state_14009__$1 = state_14009;
var statearr_14054_14182 = state_14009__$1;
(statearr_14054_14182[(2)] = inst_13830);

(statearr_14054_14182[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (31))){
var state_14009__$1 = state_14009;
var statearr_14055_14183 = state_14009__$1;
(statearr_14055_14183[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_14055_14183[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (32))){
var inst_13793 = (state_14009[(46)]);
var state_14009__$1 = state_14009;
var statearr_14056_14184 = state_14009__$1;
(statearr_14056_14184[(2)] = inst_13793);

(statearr_14056_14184[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (40))){
var inst_13797 = (state_14009[(53)]);
var state_14009__$1 = state_14009;
var statearr_14057_14185 = state_14009__$1;
(statearr_14057_14185[(2)] = inst_13797);

(statearr_14057_14185[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (56))){
var inst_13906 = (state_14009[(2)]);
var inst_13907 = fluree.db.util.async.throw_err(inst_13906);
var inst_13908 = inst_13907;
var inst_13909 = (0);
var inst_13910 = null;
var state_14009__$1 = (function (){var statearr_14058 = state_14009;
(statearr_14058[(35)] = inst_13910);

(statearr_14058[(10)] = inst_13908);

(statearr_14058[(40)] = inst_13909);

return statearr_14058;
})();
var statearr_14059_14186 = state_14009__$1;
(statearr_14059_14186[(2)] = null);

(statearr_14059_14186[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (33))){
var inst_13790 = (state_14009[(54)]);
var inst_13851 = (state_14009[(2)]);
var state_14009__$1 = (function (){var statearr_14060 = state_14009;
(statearr_14060[(33)] = inst_13851);

return statearr_14060;
})();
if(cljs.core.truth_(inst_13790)){
var statearr_14061_14187 = state_14009__$1;
(statearr_14061_14187[(1)] = (34));

} else {
var statearr_14062_14188 = state_14009__$1;
(statearr_14062_14188[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (13))){
var inst_13811 = (state_14009[(2)]);
var inst_13812 = fluree.db.util.async.throw_err(inst_13811);
var state_14009__$1 = state_14009;
var statearr_14063_14189 = state_14009__$1;
(statearr_14063_14189[(2)] = inst_13812);

(statearr_14063_14189[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (22))){
var inst_13824 = (state_14009[(30)]);
var state_14009__$1 = state_14009;
var statearr_14064_14190 = state_14009__$1;
(statearr_14064_14190[(2)] = inst_13824);

(statearr_14064_14190[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (90))){
var inst_13981 = (state_14009[(9)]);
var inst_13980 = (state_14009[(8)]);
var inst_13998 = (state_14009[(2)]);
var inst_13999 = fluree.db.util.async.throw_err(inst_13998);
var inst_13908 = inst_13999;
var inst_13909 = inst_13981;
var inst_13910 = inst_13980;
var state_14009__$1 = (function (){var statearr_14065 = state_14009;
(statearr_14065[(35)] = inst_13910);

(statearr_14065[(10)] = inst_13908);

(statearr_14065[(40)] = inst_13909);

return statearr_14065;
})();
var statearr_14066_14191 = state_14009__$1;
(statearr_14066_14191[(2)] = null);

(statearr_14066_14191[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (36))){
var inst_13797 = (state_14009[(53)]);
var inst_13860 = (state_14009[(2)]);
var state_14009__$1 = (function (){var statearr_14067 = state_14009;
(statearr_14067[(34)] = inst_13860);

return statearr_14067;
})();
if(cljs.core.truth_(inst_13797)){
var statearr_14068_14192 = state_14009__$1;
(statearr_14068_14192[(1)] = (40));

} else {
var statearr_14069_14193 = state_14009__$1;
(statearr_14069_14193[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (41))){
var inst_13863 = (cljs.core._LT__EQ_ === end_test);
var state_14009__$1 = state_14009;
if(cljs.core.truth_(inst_13863)){
var statearr_14070_14194 = state_14009__$1;
(statearr_14070_14194[(1)] = (43));

} else {
var statearr_14071_14195 = state_14009__$1;
(statearr_14071_14195[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (89))){
var inst_14002 = (state_14009[(2)]);
var state_14009__$1 = state_14009;
var statearr_14072_14196 = state_14009__$1;
(statearr_14072_14196[(2)] = inst_14002);

(statearr_14072_14196[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (43))){
var state_14009__$1 = state_14009;
var statearr_14073_14197 = state_14009__$1;
(statearr_14073_14197[(2)] = (2147483647));

(statearr_14073_14197[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (61))){
var inst_13916 = (state_14009[(18)]);
var state_14009__$1 = state_14009;
var statearr_14074_14198 = state_14009__$1;
(statearr_14074_14198[(2)] = inst_13916);

(statearr_14074_14198[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (29))){
var inst_13843 = (state_14009[(47)]);
var state_14009__$1 = state_14009;
var statearr_14075_14199 = state_14009__$1;
(statearr_14075_14199[(2)] = inst_13843);

(statearr_14075_14199[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (44))){
var state_14009__$1 = state_14009;
var statearr_14076_14200 = state_14009__$1;
(statearr_14076_14200[(2)] = fluree.db.util.core.min_integer);

(statearr_14076_14200[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (6))){
var inst_13785 = (state_14009[(14)]);
var inst_13800 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_13785);
var state_14009__$1 = state_14009;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14009__$1,(9),inst_13800);
} else {
if((state_val_14010 === (28))){
var inst_13833 = (state_14009[(21)]);
var state_14009__$1 = state_14009;
var statearr_14077_14201 = state_14009__$1;
(statearr_14077_14201[(2)] = inst_13833);

(statearr_14077_14201[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (64))){
var inst_13923 = (state_14009[(12)]);
var inst_13909 = (state_14009[(40)]);
var inst_13937 = cljs.core.seq(inst_13923);
var inst_13938 = cljs.core.first(inst_13937);
var inst_13939 = cljs.core.next(inst_13937);
var inst_13940 = inst_13923;
var inst_13941 = inst_13909;
var inst_13942 = inst_13923;
var state_14009__$1 = (function (){var statearr_14078 = state_14009;
(statearr_14078[(55)] = inst_13940);

(statearr_14078[(22)] = inst_13941);

(statearr_14078[(52)] = inst_13942);

(statearr_14078[(56)] = inst_13938);

(statearr_14078[(57)] = inst_13939);

return statearr_14078;
})();
var statearr_14079_14202 = state_14009__$1;
(statearr_14079_14202[(2)] = null);

(statearr_14079_14202[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (51))){
var inst_13887 = (state_14009[(2)]);
var inst_13888 = new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(opts);
var inst_13889 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_14009__$1 = (function (){var statearr_14080 = state_14009;
(statearr_14080[(24)] = inst_13888);

(statearr_14080[(28)] = inst_13887);

return statearr_14080;
})();
if(cljs.core.truth_(inst_13889)){
var statearr_14081_14203 = state_14009__$1;
(statearr_14081_14203[(1)] = (52));

} else {
var statearr_14082_14204 = state_14009__$1;
(statearr_14082_14204[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (25))){
var state_14009__$1 = state_14009;
var statearr_14083_14205 = state_14009__$1;
(statearr_14083_14205[(2)] = (-1));

(statearr_14083_14205[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (34))){
var inst_13790 = (state_14009[(54)]);
var state_14009__$1 = state_14009;
var statearr_14084_14206 = state_14009__$1;
(statearr_14084_14206[(2)] = inst_13790);

(statearr_14084_14206[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (17))){
var inst_13820 = (state_14009[(2)]);
var inst_13821 = fluree.db.util.async.throw_err(inst_13820);
var state_14009__$1 = state_14009;
var statearr_14085_14207 = state_14009__$1;
(statearr_14085_14207[(2)] = inst_13821);

(statearr_14085_14207[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (3))){
var inst_14007 = (state_14009[(2)]);
var state_14009__$1 = state_14009;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14009__$1,inst_14007);
} else {
if((state_val_14010 === (12))){
var inst_13787 = (state_14009[(50)]);
var inst_13815 = (state_14009[(2)]);
var inst_13816 = fluree.db.util.core.pred_ident_QMARK_(inst_13787);
var state_14009__$1 = (function (){var statearr_14086 = state_14009;
(statearr_14086[(27)] = inst_13815);

return statearr_14086;
})();
if(inst_13816){
var statearr_14087_14208 = state_14009__$1;
(statearr_14087_14208[(1)] = (14));

} else {
var statearr_14088_14209 = state_14009__$1;
(statearr_14088_14209[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (2))){
var inst_13785 = (state_14009[(14)]);
var inst_13784 = (state_14009[(37)]);
var inst_13791 = (state_14009[(43)]);
var _ = (function (){var statearr_14089 = state_14009;
(statearr_14089[(4)] = cljs.core.cons((5),(state_14009[(4)])));

return statearr_14089;
})();
var inst_13784__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_13785__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13784__$1,(0),null);
var inst_13786 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13784__$1,(1),null);
var inst_13787 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13784__$1,(2),null);
var inst_13788 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13784__$1,(3),null);
var inst_13789 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13784__$1,(4),null);
var inst_13790 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13784__$1,(5),null);
var inst_13791__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_13792 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13791__$1,(0),null);
var inst_13793 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13791__$1,(1),null);
var inst_13794 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13791__$1,(2),null);
var inst_13795 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13791__$1,(3),null);
var inst_13796 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13791__$1,(4),null);
var inst_13797 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13791__$1,(5),null);
var inst_13798 = fluree.db.util.core.pred_ident_QMARK_(inst_13785__$1);
var state_14009__$1 = (function (){var statearr_14090 = state_14009;
(statearr_14090[(53)] = inst_13797);

(statearr_14090[(58)] = inst_13794);

(statearr_14090[(25)] = inst_13795);

(statearr_14090[(46)] = inst_13793);

(statearr_14090[(29)] = inst_13789);

(statearr_14090[(14)] = inst_13785__$1);

(statearr_14090[(20)] = inst_13786);

(statearr_14090[(37)] = inst_13784__$1);

(statearr_14090[(54)] = inst_13790);

(statearr_14090[(38)] = inst_13788);

(statearr_14090[(50)] = inst_13787);

(statearr_14090[(39)] = inst_13796);

(statearr_14090[(59)] = inst_13792);

(statearr_14090[(43)] = inst_13791__$1);

return statearr_14090;
})();
if(inst_13798){
var statearr_14091_14210 = state_14009__$1;
(statearr_14091_14210[(1)] = (6));

} else {
var statearr_14092_14211 = state_14009__$1;
(statearr_14092_14211[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (66))){
var inst_13940 = (state_14009[(55)]);
var inst_13948 = (state_14009[(13)]);
var inst_13950 = (state_14009[(60)]);
var inst_13947 = cljs.core.seq(inst_13940);
var inst_13948__$1 = cljs.core.first(inst_13947);
var inst_13949 = cljs.core.next(inst_13947);
var inst_13950__$1 = (inst_13948__$1 == null);
var state_14009__$1 = (function (){var statearr_14093 = state_14009;
(statearr_14093[(61)] = inst_13949);

(statearr_14093[(13)] = inst_13948__$1);

(statearr_14093[(60)] = inst_13950__$1);

return statearr_14093;
})();
if(cljs.core.truth_(inst_13950__$1)){
var statearr_14094_14212 = state_14009__$1;
(statearr_14094_14212[(1)] = (68));

} else {
var statearr_14095_14213 = state_14009__$1;
(statearr_14095_14213[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (23))){
var inst_13834 = (state_14009[(19)]);
var state_14009__$1 = state_14009;
var statearr_14096_14214 = state_14009__$1;
(statearr_14096_14214[(2)] = inst_13834);

(statearr_14096_14214[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (47))){
var state_14009__$1 = state_14009;
var statearr_14097_14215 = state_14009__$1;
(statearr_14097_14215[(2)] = fluree.db.util.core.max_long);

(statearr_14097_14215[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (35))){
var inst_13854 = (cljs.core._GT__EQ_ === start_test);
var state_14009__$1 = state_14009;
if(cljs.core.truth_(inst_13854)){
var statearr_14098_14216 = state_14009__$1;
(statearr_14098_14216[(1)] = (37));

} else {
var statearr_14099_14217 = state_14009__$1;
(statearr_14099_14217[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (82))){
var inst_13924 = (state_14009[(7)]);
var state_14009__$1 = state_14009;
var statearr_14100_14218 = state_14009__$1;
(statearr_14100_14218[(2)] = inst_13924);

(statearr_14100_14218[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (76))){
var inst_13949 = (state_14009[(61)]);
var inst_13959 = (state_14009[(23)]);
var inst_13973 = (state_14009[(2)]);
var inst_13940 = inst_13949;
var inst_13941 = inst_13959;
var inst_13942 = inst_13973;
var state_14009__$1 = (function (){var statearr_14101 = state_14009;
(statearr_14101[(55)] = inst_13940);

(statearr_14101[(22)] = inst_13941);

(statearr_14101[(52)] = inst_13942);

return statearr_14101;
})();
var statearr_14102_14219 = state_14009__$1;
(statearr_14102_14219[(2)] = null);

(statearr_14102_14219[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (19))){
var inst_13794 = (state_14009[(58)]);
var state_14009__$1 = state_14009;
var statearr_14103_14220 = state_14009__$1;
(statearr_14103_14220[(2)] = inst_13794);

(statearr_14103_14220[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (57))){
var inst_13888 = (state_14009[(24)]);
var inst_13887 = (state_14009[(28)]);
var inst_13908 = (state_14009[(10)]);
var inst_13898 = (state_14009[(42)]);
var inst_13912 = fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4(inst_13908,inst_13887,inst_13888,inst_13898);
var state_14009__$1 = state_14009;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14009__$1,(59),inst_13912);
} else {
if((state_val_14010 === (68))){
var inst_13950 = (state_14009[(60)]);
var state_14009__$1 = state_14009;
var statearr_14104_14221 = state_14009__$1;
(statearr_14104_14221[(2)] = inst_13950);

(statearr_14104_14221[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (11))){
var inst_13792 = (state_14009[(59)]);
var state_14009__$1 = state_14009;
var statearr_14106_14222 = state_14009__$1;
(statearr_14106_14222[(2)] = inst_13792);

(statearr_14106_14222[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (9))){
var inst_13802 = (state_14009[(2)]);
var inst_13803 = fluree.db.util.async.throw_err(inst_13802);
var state_14009__$1 = state_14009;
var statearr_14107_14223 = state_14009__$1;
(statearr_14107_14223[(2)] = inst_13803);

(statearr_14107_14223[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (5))){
var _ = (function (){var statearr_14108 = state_14009;
(statearr_14108[(4)] = cljs.core.rest((state_14009[(4)])));

return statearr_14108;
})();
var state_14009__$1 = state_14009;
var ex14105 = (state_14009__$1[(2)]);
var statearr_14109_14224 = state_14009__$1;
(statearr_14109_14224[(5)] = ex14105);


if((ex14105 instanceof Error)){
var statearr_14110_14225 = state_14009__$1;
(statearr_14110_14225[(1)] = (4));

(statearr_14110_14225[(5)] = null);

} else {
throw ex14105;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (83))){
var inst_13992 = (state_14009[(2)]);
var inst_13993 = cljs.core.not(inst_13992);
var state_14009__$1 = state_14009;
if(inst_13993){
var statearr_14111_14226 = state_14009__$1;
(statearr_14111_14226[(1)] = (87));

} else {
var statearr_14112_14227 = state_14009__$1;
(statearr_14112_14227[(1)] = (88));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (14))){
var inst_13787 = (state_14009[(50)]);
var inst_13818 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_13787);
var state_14009__$1 = state_14009;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14009__$1,(17),inst_13818);
} else {
if((state_val_14010 === (45))){
var inst_13867 = (state_14009[(2)]);
var state_14009__$1 = state_14009;
var statearr_14113_14228 = state_14009__$1;
(statearr_14113_14228[(2)] = inst_13867);

(statearr_14113_14228[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (53))){
var state_14009__$1 = state_14009;
var statearr_14114_14229 = state_14009__$1;
(statearr_14114_14229[(2)] = true);

(statearr_14114_14229[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (78))){
var inst_13942 = (state_14009[(52)]);
var state_14009__$1 = state_14009;
var statearr_14115_14230 = state_14009__$1;
(statearr_14115_14230[(2)] = inst_13942);

(statearr_14115_14230[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (26))){
var inst_13786 = (state_14009[(20)]);
var state_14009__$1 = state_14009;
var statearr_14116_14231 = state_14009__$1;
(statearr_14116_14231[(2)] = inst_13786);

(statearr_14116_14231[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (16))){
var inst_13794 = (state_14009[(58)]);
var inst_13824 = (state_14009[(2)]);
var inst_13825 = fluree.db.util.core.pred_ident_QMARK_(inst_13794);
var state_14009__$1 = (function (){var statearr_14117 = state_14009;
(statearr_14117[(30)] = inst_13824);

return statearr_14117;
})();
if(inst_13825){
var statearr_14118_14232 = state_14009__$1;
(statearr_14118_14232[(1)] = (18));

} else {
var statearr_14119_14233 = state_14009__$1;
(statearr_14119_14233[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (81))){
var inst_13924 = (state_14009[(7)]);
var inst_13881 = (state_14009[(31)]);
var inst_13984 = (state_14009[(48)]);
var inst_13871 = (state_14009[(17)]);
var inst_13983 = (inst_13881.cljs$core$IFn$_invoke$arity$2 ? inst_13881.cljs$core$IFn$_invoke$arity$2(inst_13924,inst_13871) : inst_13881.call(null,inst_13924,inst_13871));
var inst_13984__$1 = (inst_13983 < (0));
var state_14009__$1 = (function (){var statearr_14120 = state_14009;
(statearr_14120[(48)] = inst_13984__$1);

return statearr_14120;
})();
if(cljs.core.truth_(inst_13984__$1)){
var statearr_14121_14234 = state_14009__$1;
(statearr_14121_14234[(1)] = (84));

} else {
var statearr_14122_14235 = state_14009__$1;
(statearr_14122_14235[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (79))){
var inst_13948 = (state_14009[(13)]);
var inst_13942 = (state_14009[(52)]);
var inst_13968 = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(inst_13942,inst_13948);
var state_14009__$1 = state_14009;
var statearr_14123_14236 = state_14009__$1;
(statearr_14123_14236[(2)] = inst_13968);

(statearr_14123_14236[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (38))){
var state_14009__$1 = state_14009;
var statearr_14124_14237 = state_14009__$1;
(statearr_14124_14237[(2)] = (2147483647));

(statearr_14124_14237[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (87))){
var inst_13980 = (state_14009[(8)]);
var state_14009__$1 = state_14009;
var statearr_14125_14238 = state_14009__$1;
(statearr_14125_14238[(2)] = inst_13980);

(statearr_14125_14238[(1)] = (89));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (30))){
var inst_13847 = (state_14009[(2)]);
var state_14009__$1 = state_14009;
if(cljs.core.truth_(inst_13847)){
var statearr_14126_14239 = state_14009__$1;
(statearr_14126_14239[(1)] = (31));

} else {
var statearr_14127_14240 = state_14009__$1;
(statearr_14127_14240[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (73))){
var inst_13976 = (state_14009[(2)]);
var state_14009__$1 = state_14009;
var statearr_14128_14241 = state_14009__$1;
(statearr_14128_14241[(2)] = inst_13976);

(statearr_14128_14241[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (10))){
var inst_13792 = (state_14009[(59)]);
var inst_13809 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_13792);
var state_14009__$1 = state_14009;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14009__$1,(13),inst_13809);
} else {
if((state_val_14010 === (18))){
var inst_13794 = (state_14009[(58)]);
var inst_13827 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_13794);
var state_14009__$1 = state_14009;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14009__$1,(21),inst_13827);
} else {
if((state_val_14010 === (52))){
var inst_13815 = (state_14009[(27)]);
var inst_13851 = (state_14009[(33)]);
var inst_13877 = (state_14009[(36)]);
var inst_13806 = (state_14009[(44)]);
var inst_13842 = (state_14009[(45)]);
var inst_13891 = fluree.db.permissions_validate.no_filter_QMARK_(inst_13877,inst_13806,inst_13815,inst_13842,inst_13851);
var state_14009__$1 = state_14009;
var statearr_14129_14242 = state_14009__$1;
(statearr_14129_14242[(2)] = inst_13891);

(statearr_14129_14242[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (67))){
var inst_13978 = (state_14009[(2)]);
var state_14009__$1 = state_14009;
var statearr_14130_14243 = state_14009__$1;
(statearr_14130_14243[(2)] = inst_13978);

(statearr_14130_14243[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (71))){
var inst_13910 = (state_14009[(35)]);
var inst_13942 = (state_14009[(52)]);
var inst_13957 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_13942,inst_13910);
var state_14009__$1 = state_14009;
var statearr_14131_14244 = state_14009__$1;
(statearr_14131_14244[(2)] = inst_13957);

(statearr_14131_14244[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (42))){
var inst_13833 = (state_14009[(21)]);
var inst_13795 = (state_14009[(25)]);
var inst_13815 = (state_14009[(27)]);
var inst_13789 = (state_14009[(29)]);
var inst_13872 = (state_14009[(49)]);
var inst_13824 = (state_14009[(30)]);
var inst_13869 = (state_14009[(32)]);
var inst_13851 = (state_14009[(33)]);
var inst_13860 = (state_14009[(34)]);
var inst_13788 = (state_14009[(38)]);
var inst_13796 = (state_14009[(39)]);
var inst_13806 = (state_14009[(44)]);
var inst_13842 = (state_14009[(45)]);
var inst_13869__$1 = (state_14009[(2)]);
var inst_13870 = fluree.db.flake.__GT_Flake(inst_13806,inst_13842,inst_13824,inst_13788,inst_13789,inst_13860);
var inst_13871 = fluree.db.flake.__GT_Flake(inst_13815,inst_13851,inst_13833,inst_13795,inst_13796,inst_13869__$1);
var inst_13872__$1 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
var state_14009__$1 = (function (){var statearr_14132 = state_14009;
(statearr_14132[(49)] = inst_13872__$1);

(statearr_14132[(32)] = inst_13869__$1);

(statearr_14132[(16)] = inst_13870);

(statearr_14132[(17)] = inst_13871);

return statearr_14132;
})();
if(cljs.core.truth_(inst_13872__$1)){
var statearr_14133_14245 = state_14009__$1;
(statearr_14133_14245[(1)] = (46));

} else {
var statearr_14134_14246 = state_14009__$1;
(statearr_14134_14246[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (80))){
var inst_13970 = (state_14009[(2)]);
var state_14009__$1 = state_14009;
var statearr_14135_14247 = state_14009__$1;
(statearr_14135_14247[(2)] = inst_13970);

(statearr_14135_14247[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (37))){
var state_14009__$1 = state_14009;
var statearr_14136_14248 = state_14009__$1;
(statearr_14136_14248[(2)] = fluree.db.util.core.min_integer);

(statearr_14136_14248[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (63))){
var inst_13923 = (state_14009[(12)]);
var inst_13910 = (state_14009[(35)]);
var inst_13909 = (state_14009[(40)]);
var inst_13876 = (state_14009[(41)]);
var inst_13926 = (inst_13876 - inst_13909);
var inst_13927 = fluree.db.flake.take(inst_13926,inst_13923);
var inst_13928 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_13927,inst_13910);
var state_14009__$1 = state_14009;
var statearr_14137_14249 = state_14009__$1;
(statearr_14137_14249[(2)] = inst_13928);

(statearr_14137_14249[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (8))){
var inst_13792 = (state_14009[(59)]);
var inst_13806 = (state_14009[(2)]);
var inst_13807 = fluree.db.util.core.pred_ident_QMARK_(inst_13792);
var state_14009__$1 = (function (){var statearr_14138 = state_14009;
(statearr_14138[(44)] = inst_13806);

return statearr_14138;
})();
if(inst_13807){
var statearr_14139_14250 = state_14009__$1;
(statearr_14139_14250[(1)] = (10));

} else {
var statearr_14140_14251 = state_14009__$1;
(statearr_14140_14251[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (49))){
var inst_13882 = (state_14009[(51)]);
var state_14009__$1 = state_14009;
var statearr_14141_14252 = state_14009__$1;
(statearr_14141_14252[(2)] = inst_13882);

(statearr_14141_14252[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (84))){
var inst_13981 = (state_14009[(9)]);
var inst_13876 = (state_14009[(41)]);
var inst_13986 = (inst_13981 < inst_13876);
var state_14009__$1 = state_14009;
var statearr_14142_14253 = state_14009__$1;
(statearr_14142_14253[(2)] = inst_13986);

(statearr_14142_14253[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2717__auto__ = null;
var fluree$db$query$range$state_machine__2717__auto____0 = (function (){
var statearr_14143 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14143[(0)] = fluree$db$query$range$state_machine__2717__auto__);

(statearr_14143[(1)] = (1));

return statearr_14143;
});
var fluree$db$query$range$state_machine__2717__auto____1 = (function (state_14009){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_14009);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e14144){var ex__2720__auto__ = e14144;
var statearr_14145_14254 = state_14009;
(statearr_14145_14254[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_14009[(4)]))){
var statearr_14146_14255 = state_14009;
(statearr_14146_14255[(1)] = cljs.core.first((state_14009[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14256 = state_14009;
state_14009 = G__14256;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2717__auto__ = function(state_14009){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2717__auto____1.call(this,state_14009);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2717__auto____0;
fluree$db$query$range$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2717__auto____1;
return fluree$db$query$range$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_14147 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_14147[(6)] = c__2739__auto__);

return statearr_14147;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_14331){
var state_val_14332 = (state_14331[(1)]);
if((state_val_14332 === (7))){
var inst_14326 = (state_14331[(2)]);
var _ = (function (){var statearr_14333 = state_14331;
(statearr_14333[(4)] = cljs.core.rest((state_14331[(4)])));

return statearr_14333;
})();
var state_14331__$1 = state_14331;
var statearr_14334_14374 = state_14331__$1;
(statearr_14334_14374[(2)] = inst_14326);

(statearr_14334_14374[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14332 === (20))){
var inst_14308 = (state_14331[(2)]);
var inst_14309 = fluree.db.util.async.throw_err(inst_14308);
var state_14331__$1 = state_14331;
var statearr_14335_14375 = state_14331__$1;
(statearr_14335_14375[(2)] = inst_14309);

(statearr_14335_14375[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14332 === (1))){
var state_14331__$1 = state_14331;
var statearr_14336_14376 = state_14331__$1;
(statearr_14336_14376[(2)] = null);

(statearr_14336_14376[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14332 === (4))){
var inst_14257 = (state_14331[(2)]);
var state_14331__$1 = state_14331;
var statearr_14337_14377 = state_14331__$1;
(statearr_14337_14377[(2)] = inst_14257);

(statearr_14337_14377[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14332 === (15))){
var inst_14304 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_14331__$1 = state_14331;
if(cljs.core.truth_(inst_14304)){
var statearr_14338_14378 = state_14331__$1;
(statearr_14338_14378[(1)] = (17));

} else {
var statearr_14339_14379 = state_14331__$1;
(statearr_14339_14379[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14332 === (21))){
var state_14331__$1 = state_14331;
var statearr_14340_14380 = state_14331__$1;
(statearr_14340_14380[(2)] = (0));

(statearr_14340_14380[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14332 === (13))){
var inst_14296 = (state_14331[(2)]);
var state_14331__$1 = state_14331;
var statearr_14341_14381 = state_14331__$1;
(statearr_14341_14381[(2)] = inst_14296);

(statearr_14341_14381[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14332 === (22))){
var state_14331__$1 = state_14331;
var statearr_14342_14382 = state_14331__$1;
(statearr_14342_14382[(2)] = (1));

(statearr_14342_14382[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14332 === (6))){
var inst_14286 = (state_14331[(7)]);
var inst_14277 = (state_14331[(8)]);
var inst_14288 = (state_14331[(9)]);
var inst_14285 = cljs.core.seq(inst_14277);
var inst_14286__$1 = cljs.core.first(inst_14285);
var inst_14287 = cljs.core.next(inst_14285);
var inst_14288__$1 = (inst_14286__$1 == null);
var state_14331__$1 = (function (){var statearr_14343 = state_14331;
(statearr_14343[(10)] = inst_14287);

(statearr_14343[(7)] = inst_14286__$1);

(statearr_14343[(9)] = inst_14288__$1);

return statearr_14343;
})();
if(cljs.core.truth_(inst_14288__$1)){
var statearr_14344_14383 = state_14331__$1;
(statearr_14344_14383[(1)] = (8));

} else {
var statearr_14345_14384 = state_14331__$1;
(statearr_14345_14384[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14332 === (17))){
var inst_14286 = (state_14331[(7)]);
var inst_14306 = fluree.db.permissions_validate.allow_flakes_QMARK_(db,inst_14286);
var state_14331__$1 = state_14331;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14331__$1,(20),inst_14306);
} else {
if((state_val_14332 === (3))){
var inst_14329 = (state_14331[(2)]);
var state_14331__$1 = state_14331;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14331__$1,inst_14329);
} else {
if((state_val_14332 === (12))){
var inst_14279 = (state_14331[(11)]);
var inst_14294 = (inst_14279 >= subject_limit);
var state_14331__$1 = state_14331;
var statearr_14346_14385 = state_14331__$1;
(statearr_14346_14385[(2)] = inst_14294);

(statearr_14346_14385[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14332 === (2))){
var _ = (function (){var statearr_14347 = state_14331;
(statearr_14347[(4)] = cljs.core.cons((5),(state_14331[(4)])));

return statearr_14347;
})();
var inst_14270 = subject_groups;
var inst_14271 = cljs.core.seq(inst_14270);
var inst_14272 = cljs.core.first(inst_14271);
var inst_14273 = cljs.core.next(inst_14271);
var inst_14274 = flake_start;
var inst_14275 = subject_start;
var inst_14276 = cljs.core.PersistentVector.EMPTY;
var inst_14277 = inst_14270;
var inst_14278 = inst_14274;
var inst_14279 = inst_14275;
var inst_14280 = inst_14276;
var state_14331__$1 = (function (){var statearr_14348 = state_14331;
(statearr_14348[(12)] = inst_14273);

(statearr_14348[(13)] = inst_14272);

(statearr_14348[(14)] = inst_14278);

(statearr_14348[(11)] = inst_14279);

(statearr_14348[(15)] = inst_14280);

(statearr_14348[(8)] = inst_14277);

return statearr_14348;
})();
var statearr_14349_14386 = state_14331__$1;
(statearr_14349_14386[(2)] = null);

(statearr_14349_14386[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14332 === (23))){
var inst_14312 = (state_14331[(16)]);
var inst_14278 = (state_14331[(14)]);
var inst_14279 = (state_14331[(11)]);
var inst_14287 = (state_14331[(10)]);
var inst_14313 = (state_14331[(17)]);
var inst_14280 = (state_14331[(15)]);
var inst_14318 = (state_14331[(2)]);
var inst_14319 = (inst_14278 + inst_14313);
var inst_14320 = (inst_14279 + inst_14318);
var inst_14321 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_14280,inst_14312);
var inst_14277 = inst_14287;
var inst_14278__$1 = inst_14319;
var inst_14279__$1 = inst_14320;
var inst_14280__$1 = inst_14321;
var state_14331__$1 = (function (){var statearr_14350 = state_14331;
(statearr_14350[(14)] = inst_14278__$1);

(statearr_14350[(11)] = inst_14279__$1);

(statearr_14350[(15)] = inst_14280__$1);

(statearr_14350[(8)] = inst_14277);

return statearr_14350;
})();
var statearr_14351_14387 = state_14331__$1;
(statearr_14351_14387[(2)] = null);

(statearr_14351_14387[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14332 === (19))){
var inst_14312 = (state_14331[(16)]);
var inst_14313 = (state_14331[(17)]);
var inst_14312__$1 = (state_14331[(2)]);
var inst_14313__$1 = cljs.core.count(inst_14312__$1);
var inst_14314 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_14313__$1);
var state_14331__$1 = (function (){var statearr_14352 = state_14331;
(statearr_14352[(16)] = inst_14312__$1);

(statearr_14352[(17)] = inst_14313__$1);

return statearr_14352;
})();
if(inst_14314){
var statearr_14353_14388 = state_14331__$1;
(statearr_14353_14388[(1)] = (21));

} else {
var statearr_14354_14389 = state_14331__$1;
(statearr_14354_14389[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14332 === (11))){
var inst_14291 = (state_14331[(18)]);
var state_14331__$1 = state_14331;
var statearr_14356_14390 = state_14331__$1;
(statearr_14356_14390[(2)] = inst_14291);

(statearr_14356_14390[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14332 === (9))){
var inst_14278 = (state_14331[(14)]);
var inst_14291 = (state_14331[(18)]);
var inst_14291__$1 = (inst_14278 >= flake_limit);
var state_14331__$1 = (function (){var statearr_14357 = state_14331;
(statearr_14357[(18)] = inst_14291__$1);

return statearr_14357;
})();
if(cljs.core.truth_(inst_14291__$1)){
var statearr_14358_14391 = state_14331__$1;
(statearr_14358_14391[(1)] = (11));

} else {
var statearr_14359_14392 = state_14331__$1;
(statearr_14359_14392[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14332 === (5))){
var _ = (function (){var statearr_14360 = state_14331;
(statearr_14360[(4)] = cljs.core.rest((state_14331[(4)])));

return statearr_14360;
})();
var state_14331__$1 = state_14331;
var ex14355 = (state_14331__$1[(2)]);
var statearr_14361_14393 = state_14331__$1;
(statearr_14361_14393[(5)] = ex14355);


if((ex14355 instanceof Error)){
var statearr_14362_14394 = state_14331__$1;
(statearr_14362_14394[(1)] = (4));

(statearr_14362_14394[(5)] = null);

} else {
throw ex14355;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14332 === (14))){
var inst_14278 = (state_14331[(14)]);
var inst_14279 = (state_14331[(11)]);
var inst_14280 = (state_14331[(15)]);
var inst_14300 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14301 = [inst_14278,inst_14279,inst_14280];
var inst_14302 = (new cljs.core.PersistentVector(null,3,(5),inst_14300,inst_14301,null));
var state_14331__$1 = state_14331;
var statearr_14363_14395 = state_14331__$1;
(statearr_14363_14395[(2)] = inst_14302);

(statearr_14363_14395[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14332 === (16))){
var inst_14324 = (state_14331[(2)]);
var state_14331__$1 = state_14331;
var statearr_14364_14396 = state_14331__$1;
(statearr_14364_14396[(2)] = inst_14324);

(statearr_14364_14396[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14332 === (10))){
var inst_14298 = (state_14331[(2)]);
var state_14331__$1 = state_14331;
if(cljs.core.truth_(inst_14298)){
var statearr_14365_14397 = state_14331__$1;
(statearr_14365_14397[(1)] = (14));

} else {
var statearr_14366_14398 = state_14331__$1;
(statearr_14366_14398[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14332 === (18))){
var inst_14286 = (state_14331[(7)]);
var state_14331__$1 = state_14331;
var statearr_14367_14399 = state_14331__$1;
(statearr_14367_14399[(2)] = inst_14286);

(statearr_14367_14399[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14332 === (8))){
var inst_14288 = (state_14331[(9)]);
var state_14331__$1 = state_14331;
var statearr_14368_14400 = state_14331__$1;
(statearr_14368_14400[(2)] = inst_14288);

(statearr_14368_14400[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2717__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2717__auto____0 = (function (){
var statearr_14369 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14369[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2717__auto__);

(statearr_14369[(1)] = (1));

return statearr_14369;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2717__auto____1 = (function (state_14331){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_14331);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e14370){var ex__2720__auto__ = e14370;
var statearr_14371_14401 = state_14331;
(statearr_14371_14401[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_14331[(4)]))){
var statearr_14372_14402 = state_14331;
(statearr_14372_14402[(1)] = cljs.core.first((state_14331[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14403 = state_14331;
state_14331 = G__14403;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2717__auto__ = function(state_14331){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2717__auto____1.call(this,state_14331);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2717__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2717__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_14373 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_14373[(6)] = c__2739__auto__);

return statearr_14373;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_14449){
var state_val_14450 = (state_14449[(1)]);
if((state_val_14450 === (7))){
var state_14449__$1 = state_14449;
var statearr_14451_14489 = state_14449__$1;
(statearr_14451_14489[(2)] = null);

(statearr_14451_14489[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14450 === (20))){
var inst_14435 = (state_14449[(2)]);
var inst_14436 = fluree.db.util.async.throw_err(inst_14435);
var inst_14414 = inst_14436;
var state_14449__$1 = (function (){var statearr_14452 = state_14449;
(statearr_14452[(7)] = inst_14414);

return statearr_14452;
})();
var statearr_14453_14490 = state_14449__$1;
(statearr_14453_14490[(2)] = null);

(statearr_14453_14490[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14450 === (1))){
var state_14449__$1 = state_14449;
var statearr_14454_14491 = state_14449__$1;
(statearr_14454_14491[(2)] = null);

(statearr_14454_14491[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14450 === (4))){
var inst_14404 = (state_14449[(2)]);
var state_14449__$1 = state_14449;
var statearr_14455_14492 = state_14449__$1;
(statearr_14455_14492[(2)] = inst_14404);

(statearr_14455_14492[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14450 === (15))){
var inst_14414 = (state_14449[(7)]);
var inst_14431 = (state_14449[(8)]);
var inst_14431__$1 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_14414);
var state_14449__$1 = (function (){var statearr_14456 = state_14449;
(statearr_14456[(8)] = inst_14431__$1);

return statearr_14456;
})();
if(cljs.core.truth_(inst_14431__$1)){
var statearr_14457_14493 = state_14449__$1;
(statearr_14457_14493[(1)] = (17));

} else {
var statearr_14458_14494 = state_14449__$1;
(statearr_14458_14494[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14450 === (13))){
var inst_14424 = (state_14449[(2)]);
var inst_14425 = fluree.db.util.async.throw_err(inst_14424);
var _ = (function (){var statearr_14459 = state_14449;
(statearr_14459[(4)] = cljs.core.rest((state_14449[(4)])));

return statearr_14459;
})();
var state_14449__$1 = state_14449;
var statearr_14460_14495 = state_14449__$1;
(statearr_14460_14495[(2)] = inst_14425);

(statearr_14460_14495[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14450 === (6))){
var inst_14412 = (state_14449[(2)]);
var inst_14413 = fluree.db.util.async.throw_err(inst_14412);
var inst_14414 = inst_14413;
var state_14449__$1 = (function (){var statearr_14461 = state_14449;
(statearr_14461[(7)] = inst_14414);

return statearr_14461;
})();
var statearr_14462_14496 = state_14449__$1;
(statearr_14462_14496[(2)] = null);

(statearr_14462_14496[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14450 === (17))){
var inst_14431 = (state_14449[(8)]);
var inst_14433 = fluree.db.dbproto._lookup_leaf(root_node,inst_14431);
var state_14449__$1 = state_14449;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14449__$1,(20),inst_14433);
} else {
if((state_val_14450 === (3))){
var inst_14447 = (state_14449[(2)]);
var state_14449__$1 = state_14449;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14449__$1,inst_14447);
} else {
if((state_val_14450 === (12))){
var _ = (function (){var statearr_14464 = state_14449;
(statearr_14464[(4)] = cljs.core.rest((state_14449[(4)])));

return statearr_14464;
})();
var state_14449__$1 = state_14449;
var ex14463 = (state_14449__$1[(2)]);
var statearr_14465_14497 = state_14449__$1;
(statearr_14465_14497[(5)] = ex14463);


var statearr_14466_14498 = state_14449__$1;
(statearr_14466_14498[(1)] = (11));

(statearr_14466_14498[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14450 === (2))){
var _ = (function (){var statearr_14467 = state_14449;
(statearr_14467[(4)] = cljs.core.cons((5),(state_14449[(4)])));

return statearr_14467;
})();
var inst_14410 = fluree.db.dbproto._lookup_leaf(root_node,rhs);
var state_14449__$1 = state_14449;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14449__$1,(6),inst_14410);
} else {
if((state_val_14450 === (19))){
var inst_14440 = (state_14449[(2)]);
var state_14449__$1 = state_14449;
var statearr_14468_14499 = state_14449__$1;
(statearr_14468_14499[(2)] = inst_14440);

(statearr_14468_14499[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14450 === (11))){
var inst_14416 = (state_14449[(2)]);
var state_14449__$1 = (function (){var statearr_14470 = state_14449;
(statearr_14470[(9)] = inst_14416);

return statearr_14470;
})();
var statearr_14471_14500 = state_14449__$1;
(statearr_14471_14500[(2)] = null);

(statearr_14471_14500[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14450 === (9))){
var inst_14414 = (state_14449[(7)]);
var _ = (function (){var statearr_14472 = state_14449;
(statearr_14472[(4)] = cljs.core.cons((12),(state_14449[(4)])));

return statearr_14472;
})();
var inst_14422 = fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4(inst_14414,t,novelty,fast_forward_db_QMARK_);
var state_14449__$1 = state_14449;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14449__$1,(13),inst_14422);
} else {
if((state_val_14450 === (5))){
var _ = (function (){var statearr_14473 = state_14449;
(statearr_14473[(4)] = cljs.core.rest((state_14449[(4)])));

return statearr_14473;
})();
var state_14449__$1 = state_14449;
var ex14469 = (state_14449__$1[(2)]);
var statearr_14474_14501 = state_14449__$1;
(statearr_14474_14501[(5)] = ex14469);


if((ex14469 instanceof Error)){
var statearr_14475_14502 = state_14449__$1;
(statearr_14475_14502[(1)] = (4));

(statearr_14475_14502[(5)] = null);

} else {
throw ex14469;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14450 === (14))){
var inst_14428 = (state_14449[(10)]);
var state_14449__$1 = state_14449;
var statearr_14476_14503 = state_14449__$1;
(statearr_14476_14503[(2)] = inst_14428);

(statearr_14476_14503[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14450 === (16))){
var inst_14442 = (state_14449[(2)]);
var state_14449__$1 = state_14449;
var statearr_14477_14504 = state_14449__$1;
(statearr_14477_14504[(2)] = inst_14442);

(statearr_14477_14504[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14450 === (10))){
var inst_14428 = (state_14449[(10)]);
var inst_14428__$1 = (state_14449[(2)]);
var state_14449__$1 = (function (){var statearr_14478 = state_14449;
(statearr_14478[(10)] = inst_14428__$1);

return statearr_14478;
})();
if(cljs.core.truth_(inst_14428__$1)){
var statearr_14479_14505 = state_14449__$1;
(statearr_14479_14505[(1)] = (14));

} else {
var statearr_14480_14506 = state_14449__$1;
(statearr_14480_14506[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14450 === (18))){
var state_14449__$1 = state_14449;
var statearr_14481_14507 = state_14449__$1;
(statearr_14481_14507[(2)] = null);

(statearr_14481_14507[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14450 === (8))){
var inst_14444 = (state_14449[(2)]);
var _ = (function (){var statearr_14482 = state_14449;
(statearr_14482[(4)] = cljs.core.rest((state_14449[(4)])));

return statearr_14482;
})();
var state_14449__$1 = state_14449;
var statearr_14483_14508 = state_14449__$1;
(statearr_14483_14508[(2)] = inst_14444);

(statearr_14483_14508[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__2717__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__2717__auto____0 = (function (){
var statearr_14484 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14484[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__2717__auto__);

(statearr_14484[(1)] = (1));

return statearr_14484;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__2717__auto____1 = (function (state_14449){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_14449);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e14485){var ex__2720__auto__ = e14485;
var statearr_14486_14509 = state_14449;
(statearr_14486_14509[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_14449[(4)]))){
var statearr_14487_14510 = state_14449;
(statearr_14487_14510[(1)] = cljs.core.first((state_14449[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14511 = state_14449;
state_14449 = G__14511;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__2717__auto__ = function(state_14449){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__2717__auto____1.call(this,state_14449);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__2717__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__2717__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_14488 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_14488[(6)] = c__2739__auto__);

return statearr_14488;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__14518 = arguments.length;
switch (G__14518) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__14519 = (function (){var pred__14522 = cljs.core.identical_QMARK_;
var expr__14523 = test;
if(cljs.core.truth_((pred__14522.cljs$core$IFn$_invoke$arity$2 ? pred__14522.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__14523) : pred__14522.call(null,cljs.core._EQ_,expr__14523)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__14522.cljs$core$IFn$_invoke$arity$2 ? pred__14522.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__14523) : pred__14522.call(null,cljs.core._LT_,expr__14523)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__14522.cljs$core$IFn$_invoke$arity$2 ? pred__14522.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__14523) : pred__14522.call(null,cljs.core._LT__EQ_,expr__14523)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__14522.cljs$core$IFn$_invoke$arity$2 ? pred__14522.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__14523) : pred__14522.call(null,cljs.core._GT_,expr__14523)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__14522.cljs$core$IFn$_invoke$arity$2 ? pred__14522.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__14523) : pred__14522.call(null,cljs.core._GT__EQ_,expr__14523)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__14523)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14519,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14519,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14519,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14519,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_14895){
var state_val_14896 = (state_14895[(1)]);
if((state_val_14896 === (121))){
var inst_14851 = (state_14895[(7)]);
var state_14895__$1 = state_14895;
var statearr_14897_15093 = state_14895__$1;
(statearr_14897_15093[(2)] = inst_14851);

(statearr_14897_15093[(1)] = (123));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (65))){
var inst_14703 = (state_14895[(8)]);
var inst_14709 = (state_14895[(2)]);
var state_14895__$1 = (function (){var statearr_14898 = state_14895;
(statearr_14898[(9)] = inst_14709);

return statearr_14898;
})();
if(cljs.core.truth_(inst_14703)){
var statearr_14899_15094 = state_14895__$1;
(statearr_14899_15094[(1)] = (66));

} else {
var statearr_14900_15095 = state_14895__$1;
(statearr_14900_15095[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (70))){
var inst_14887 = (state_14895[(2)]);
var state_14895__$1 = state_14895;
var statearr_14901_15096 = state_14895__$1;
(statearr_14901_15096[(2)] = inst_14887);

(statearr_14901_15096[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (62))){
var inst_14702 = (state_14895[(2)]);
var inst_14703 = fluree.db.util.async.throw_err(inst_14702);
var inst_14704 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_14895__$1 = (function (){var statearr_14902 = state_14895;
(statearr_14902[(8)] = inst_14703);

return statearr_14902;
})();
if(cljs.core.truth_(inst_14704)){
var statearr_14903_15097 = state_14895__$1;
(statearr_14903_15097[(1)] = (63));

} else {
var statearr_14904_15098 = state_14895__$1;
(statearr_14904_15098[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (74))){
var inst_14644 = (state_14895[(10)]);
var inst_14662 = (state_14895[(11)]);
var inst_14614 = (state_14895[(12)]);
var inst_14562 = (state_14895[(13)]);
var inst_14545 = (state_14895[(14)]);
var inst_14699 = (state_14895[(15)]);
var inst_14688 = (state_14895[(16)]);
var inst_14653 = (state_14895[(17)]);
var inst_14560 = (state_14895[(18)]);
var inst_14626 = (state_14895[(19)]);
var inst_14730 = (state_14895[(20)]);
var inst_14617 = (state_14895[(21)]);
var inst_14709 = (state_14895[(9)]);
var inst_14722 = (state_14895[(22)]);
var inst_14703 = (state_14895[(8)]);
var inst_14683 = (state_14895[(23)]);
var inst_14675 = (state_14895[(24)]);
var inst_14561 = (state_14895[(25)]);
var inst_14715 = (state_14895[(26)]);
var inst_14557 = (state_14895[(27)]);
var inst_14635 = (state_14895[(28)]);
var inst_14684 = (state_14895[(29)]);
var inst_14672 = (state_14895[(30)]);
var inst_14552 = (state_14895[(31)]);
var inst_14549 = (state_14895[(32)]);
var inst_14581 = (state_14895[(33)]);
var inst_14693 = (state_14895[(34)]);
var inst_14676 = (state_14895[(35)]);
var inst_14714 = (state_14895[(36)]);
var inst_14713 = (state_14895[(37)]);
var inst_14689 = (state_14895[(38)]);
var inst_14556 = (state_14895[(39)]);
var inst_14682 = (state_14895[(40)]);
var inst_14572 = (state_14895[(41)]);
var inst_14550 = (state_14895[(42)]);
var inst_14712 = (state_14895[(43)]);
var inst_14613 = (state_14895[(44)]);
var inst_14673 = (state_14895[(45)]);
var inst_14671 = (state_14895[(46)]);
var inst_14694 = (state_14895[(47)]);
var inst_14716 = (state_14895[(48)]);
var inst_14732 = (function (){var no_filter_QMARK_ = inst_14709;
var t = inst_14689;
var max_limit_QMARK_ = inst_14683;
var next_node = inst_14712;
var fast_forward_db_QMARK_ = inst_14694;
var s1 = inst_14572;
var o2 = inst_14635;
var t1 = inst_14549;
var predicate_fn = inst_14562;
var i = inst_14714;
var m1 = inst_14662;
var root_node = inst_14699;
var s2 = inst_14581;
var vec__14534 = inst_14552;
var vec__14538 = inst_14613;
var p2 = inst_14653;
var permissions = inst_14684;
var limit = inst_14682;
var start_flake = inst_14672;
var flake_limit = inst_14676;
var offset = inst_14713;
var vec__14531 = inst_14545;
var acc = inst_14716;
var map__14537 = inst_14560;
var t2 = inst_14556;
var op1 = inst_14550;
var o1 = inst_14626;
var end_flake = inst_14673;
var base_result = inst_14722;
var s = inst_14715;
var node_start = inst_14703;
var p1 = inst_14644;
var subject_fn = inst_14561;
var object_fn = inst_14617;
var idx_compare = inst_14688;
var map__14544 = inst_14675;
var op2 = inst_14557;
var m2 = inst_14671;
var vec__14541 = inst_14614;
var G__14723 = inst_14730;
var novelty = inst_14693;
return (function (p1__14513_SHARP_){
var G__14905 = p1__14513_SHARP_.s;
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__14905) : subject_fn.call(null,G__14905));
});
})();
var inst_14733 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_14732,inst_14730);
var state_14895__$1 = state_14895;
var statearr_14906_15099 = state_14895__$1;
(statearr_14906_15099[(2)] = inst_14733);

(statearr_14906_15099[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (110))){
var inst_14864 = (state_14895[(2)]);
var state_14895__$1 = state_14895;
var statearr_14907_15100 = state_14895__$1;
(statearr_14907_15100[(2)] = inst_14864);

(statearr_14907_15100[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (7))){
var inst_14546 = (state_14895[(49)]);
var state_14895__$1 = state_14895;
var statearr_14908_15101 = state_14895__$1;
(statearr_14908_15101[(2)] = inst_14546);

(statearr_14908_15101[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (59))){
var state_14895__$1 = state_14895;
var statearr_14909_15102 = state_14895__$1;
(statearr_14909_15102[(2)] = fluree.db.util.core.max_long);

(statearr_14909_15102[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (86))){
var inst_14709 = (state_14895[(9)]);
var state_14895__$1 = state_14895;
var statearr_14910_15103 = state_14895__$1;
(statearr_14910_15103[(2)] = inst_14709);

(statearr_14910_15103[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (20))){
var state_14895__$1 = state_14895;
var statearr_14911_15104 = state_14895__$1;
(statearr_14911_15104[(2)] = null);

(statearr_14911_15104[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (72))){
var inst_14722 = (state_14895[(22)]);
var state_14895__$1 = state_14895;
var statearr_14912_15105 = state_14895__$1;
(statearr_14912_15105[(2)] = inst_14722);

(statearr_14912_15105[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (58))){
var inst_14677 = (state_14895[(50)]);
var state_14895__$1 = state_14895;
var statearr_14913_15106 = state_14895__$1;
(statearr_14913_15106[(2)] = inst_14677);

(statearr_14913_15106[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (60))){
var inst_14682 = (state_14895[(40)]);
var inst_14682__$1 = (state_14895[(2)]);
var inst_14683 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_14682__$1,fluree.db.util.core.max_long);
var inst_14684 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_14685 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14686 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_14687 = (new cljs.core.PersistentVector(null,3,(5),inst_14685,inst_14686,null));
var inst_14688 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_14687);
var inst_14689 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_14690 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14691 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_14692 = (new cljs.core.PersistentVector(null,2,(5),inst_14690,inst_14691,null));
var inst_14693 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_14692);
var inst_14694 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db);
var inst_14695 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_14696 = fluree.db.dbproto._resolve(inst_14695);
var state_14895__$1 = (function (){var statearr_14914 = state_14895;
(statearr_14914[(16)] = inst_14688);

(statearr_14914[(23)] = inst_14683);

(statearr_14914[(29)] = inst_14684);

(statearr_14914[(34)] = inst_14693);

(statearr_14914[(38)] = inst_14689);

(statearr_14914[(40)] = inst_14682__$1);

(statearr_14914[(47)] = inst_14694);

return statearr_14914;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14895__$1,(61),inst_14696);
} else {
if((state_val_14896 === (27))){
var inst_14615 = (state_14895[(51)]);
var state_14895__$1 = state_14895;
var statearr_14915_15107 = state_14895__$1;
(statearr_14915_15107[(2)] = inst_14615);

(statearr_14915_15107[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (1))){
var state_14895__$1 = state_14895;
var statearr_14916_15108 = state_14895__$1;
(statearr_14916_15108[(2)] = null);

(statearr_14916_15108[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (69))){
var inst_14672 = (state_14895[(30)]);
var inst_14712 = (state_14895[(43)]);
var inst_14673 = (state_14895[(45)]);
var inst_14721 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_14712);
var inst_14722 = fluree.db.flake.subrange(inst_14721,start_test,inst_14672,end_test,inst_14673);
var inst_14724 = fluree.db.query.range.value_with_nil_pred(idx,inst_14672,inst_14673);
var state_14895__$1 = (function (){var statearr_14917 = state_14895;
(statearr_14917[(22)] = inst_14722);

return statearr_14917;
})();
if(inst_14724){
var statearr_14918_15109 = state_14895__$1;
(statearr_14918_15109[(1)] = (71));

} else {
var statearr_14919_15110 = state_14895__$1;
(statearr_14919_15110[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (101))){
var inst_14809 = (state_14895[(52)]);
var inst_14808 = (state_14895[(53)]);
var inst_14810 = (state_14895[(54)]);
var inst_14676 = (state_14895[(35)]);
var inst_14813 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14814 = (inst_14810 - inst_14676);
var inst_14815 = (inst_14809 - inst_14814);
var inst_14816 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_14815,inst_14808);
var inst_14817 = [inst_14676,inst_14816];
var inst_14818 = (new cljs.core.PersistentVector(null,2,(5),inst_14813,inst_14817,null));
var state_14895__$1 = state_14895;
var statearr_14920_15111 = state_14895__$1;
(statearr_14920_15111[(2)] = inst_14818);

(statearr_14920_15111[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (24))){
var inst_14562 = (state_14895[(13)]);
var inst_14545 = (state_14895[(14)]);
var inst_14560 = (state_14895[(18)]);
var inst_14558 = (state_14895[(55)]);
var inst_14595 = (state_14895[(56)]);
var inst_14561 = (state_14895[(25)]);
var inst_14557 = (state_14895[(27)]);
var inst_14548 = (state_14895[(57)]);
var inst_14552 = (state_14895[(31)]);
var inst_14549 = (state_14895[(32)]);
var inst_14581 = (state_14895[(33)]);
var inst_14563 = (state_14895[(58)]);
var inst_14554 = (state_14895[(59)]);
var inst_14556 = (state_14895[(39)]);
var inst_14572 = (state_14895[(41)]);
var inst_14550 = (state_14895[(42)]);
var inst_14547 = (state_14895[(60)]);
var inst_14555 = (state_14895[(61)]);
var inst_14551 = (state_14895[(62)]);
var inst_14605 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14606 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14607 = [null,null];
var inst_14608 = (new cljs.core.PersistentVector(null,2,(5),inst_14606,inst_14607,null));
var inst_14609 = (function (){var bool = inst_14595;
var s1 = inst_14572;
var o2 = inst_14555;
var t1 = inst_14549;
var predicate_fn = inst_14562;
var m1 = inst_14551;
var s2 = inst_14581;
var vec__14534 = inst_14552;
var p2 = inst_14554;
var vec__14531 = inst_14545;
var map__14537 = inst_14560;
var t2 = inst_14556;
var op1 = inst_14550;
var o1 = inst_14548;
var p1 = inst_14547;
var subject_fn = inst_14561;
var object_fn = inst_14563;
var op2 = inst_14557;
var m2 = inst_14558;
var temp__5755__auto__ = inst_14595;
return (function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
});
})();
var inst_14610 = [inst_14608,inst_14609];
var inst_14611 = (new cljs.core.PersistentVector(null,2,(5),inst_14605,inst_14610,null));
var state_14895__$1 = state_14895;
var statearr_14921_15112 = state_14895__$1;
(statearr_14921_15112[(2)] = inst_14611);

(statearr_14921_15112[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (102))){
var inst_14808 = (state_14895[(53)]);
var inst_14810 = (state_14895[(54)]);
var inst_14820 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14821 = [inst_14810,inst_14808];
var inst_14822 = (new cljs.core.PersistentVector(null,2,(5),inst_14820,inst_14821,null));
var state_14895__$1 = state_14895;
var statearr_14922_15113 = state_14895__$1;
(statearr_14922_15113[(2)] = inst_14822);

(statearr_14922_15113[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (55))){
var state_14895__$1 = state_14895;
var statearr_14923_15114 = state_14895__$1;
(statearr_14923_15114[(2)] = (2147483647));

(statearr_14923_15114[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (85))){
var inst_14758 = (state_14895[(2)]);
var state_14895__$1 = state_14895;
if(cljs.core.truth_(inst_14758)){
var statearr_14924_15115 = state_14895__$1;
(statearr_14924_15115[(1)] = (89));

} else {
var statearr_14925_15116 = state_14895__$1;
(statearr_14925_15116[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (39))){
var inst_14645 = (state_14895[(63)]);
var inst_14554 = (state_14895[(59)]);
var inst_14644 = (state_14895[(2)]);
var inst_14645__$1 = (inst_14554 == null);
var state_14895__$1 = (function (){var statearr_14926 = state_14895;
(statearr_14926[(10)] = inst_14644);

(statearr_14926[(63)] = inst_14645__$1);

return statearr_14926;
})();
if(cljs.core.truth_(inst_14645__$1)){
var statearr_14927_15117 = state_14895__$1;
(statearr_14927_15117[(1)] = (40));

} else {
var statearr_14928_15118 = state_14895__$1;
(statearr_14928_15118[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (88))){
var inst_14755 = (state_14895[(2)]);
var state_14895__$1 = state_14895;
var statearr_14929_15119 = state_14895__$1;
(statearr_14929_15119[(2)] = inst_14755);

(statearr_14929_15119[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (46))){
var inst_14551 = (state_14895[(62)]);
var state_14895__$1 = state_14895;
var statearr_14930_15120 = state_14895__$1;
(statearr_14930_15120[(2)] = inst_14551);

(statearr_14930_15120[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (4))){
var inst_14525 = (state_14895[(2)]);
var state_14895__$1 = state_14895;
var statearr_14931_15121 = state_14895__$1;
(statearr_14931_15121[(2)] = inst_14525);

(statearr_14931_15121[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (77))){
var inst_14644 = (state_14895[(10)]);
var inst_14662 = (state_14895[(11)]);
var inst_14614 = (state_14895[(12)]);
var inst_14562 = (state_14895[(13)]);
var inst_14545 = (state_14895[(14)]);
var inst_14699 = (state_14895[(15)]);
var inst_14688 = (state_14895[(16)]);
var inst_14653 = (state_14895[(17)]);
var inst_14560 = (state_14895[(18)]);
var inst_14626 = (state_14895[(19)]);
var inst_14736 = (state_14895[(64)]);
var inst_14617 = (state_14895[(21)]);
var inst_14709 = (state_14895[(9)]);
var inst_14722 = (state_14895[(22)]);
var inst_14703 = (state_14895[(8)]);
var inst_14683 = (state_14895[(23)]);
var inst_14675 = (state_14895[(24)]);
var inst_14561 = (state_14895[(25)]);
var inst_14715 = (state_14895[(26)]);
var inst_14557 = (state_14895[(27)]);
var inst_14635 = (state_14895[(28)]);
var inst_14684 = (state_14895[(29)]);
var inst_14672 = (state_14895[(30)]);
var inst_14552 = (state_14895[(31)]);
var inst_14549 = (state_14895[(32)]);
var inst_14581 = (state_14895[(33)]);
var inst_14693 = (state_14895[(34)]);
var inst_14676 = (state_14895[(35)]);
var inst_14714 = (state_14895[(36)]);
var inst_14713 = (state_14895[(37)]);
var inst_14689 = (state_14895[(38)]);
var inst_14556 = (state_14895[(39)]);
var inst_14682 = (state_14895[(40)]);
var inst_14572 = (state_14895[(41)]);
var inst_14550 = (state_14895[(42)]);
var inst_14712 = (state_14895[(43)]);
var inst_14613 = (state_14895[(44)]);
var inst_14673 = (state_14895[(45)]);
var inst_14671 = (state_14895[(46)]);
var inst_14694 = (state_14895[(47)]);
var inst_14716 = (state_14895[(48)]);
var inst_14738 = (function (){var no_filter_QMARK_ = inst_14709;
var t = inst_14689;
var max_limit_QMARK_ = inst_14683;
var next_node = inst_14712;
var fast_forward_db_QMARK_ = inst_14694;
var s1 = inst_14572;
var o2 = inst_14635;
var t1 = inst_14549;
var predicate_fn = inst_14562;
var i = inst_14714;
var m1 = inst_14662;
var root_node = inst_14699;
var s2 = inst_14581;
var vec__14534 = inst_14552;
var vec__14538 = inst_14613;
var p2 = inst_14653;
var permissions = inst_14684;
var limit = inst_14682;
var start_flake = inst_14672;
var flake_limit = inst_14676;
var offset = inst_14713;
var vec__14531 = inst_14545;
var acc = inst_14716;
var map__14537 = inst_14560;
var t2 = inst_14556;
var op1 = inst_14550;
var o1 = inst_14626;
var end_flake = inst_14673;
var base_result = inst_14722;
var s = inst_14715;
var node_start = inst_14703;
var p1 = inst_14644;
var subject_fn = inst_14561;
var object_fn = inst_14617;
var idx_compare = inst_14688;
var map__14544 = inst_14675;
var op2 = inst_14557;
var m2 = inst_14671;
var vec__14541 = inst_14614;
var G__14723 = inst_14736;
var novelty = inst_14693;
return (function (p1__14514_SHARP_){
var G__14932 = p1__14514_SHARP_.p;
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__14932) : predicate_fn.call(null,G__14932));
});
})();
var inst_14739 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_14738,inst_14736);
var state_14895__$1 = state_14895;
var statearr_14933_15122 = state_14895__$1;
(statearr_14933_15122[(2)] = inst_14739);

(statearr_14933_15122[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (106))){
var inst_14749 = (state_14895[(65)]);
var state_14895__$1 = state_14895;
var statearr_14934_15123 = state_14895__$1;
(statearr_14934_15123[(2)] = inst_14749);

(statearr_14934_15123[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (119))){
var inst_14867 = (state_14895[(66)]);
var state_14895__$1 = state_14895;
var statearr_14935_15124 = state_14895__$1;
(statearr_14935_15124[(2)] = inst_14867);

(statearr_14935_15124[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (95))){
var inst_14792 = (state_14895[(67)]);
var inst_14715 = (state_14895[(26)]);
var inst_14791 = (state_14895[(68)]);
var inst_14790 = (state_14895[(69)]);
var inst_14682 = (state_14895[(40)]);
var inst_14782 = (state_14895[(70)]);
var inst_14790__$1 = cljs.core.count(inst_14782);
var inst_14791__$1 = (inst_14715 + inst_14790__$1);
var inst_14792__$1 = (inst_14791__$1 - inst_14682);
var inst_14793 = cljs.core.pos_int_QMARK_(inst_14792__$1);
var state_14895__$1 = (function (){var statearr_14936 = state_14895;
(statearr_14936[(67)] = inst_14792__$1);

(statearr_14936[(68)] = inst_14791__$1);

(statearr_14936[(69)] = inst_14790__$1);

return statearr_14936;
})();
if(inst_14793){
var statearr_14937_15125 = state_14895__$1;
(statearr_14937_15125[(1)] = (98));

} else {
var statearr_14938_15126 = state_14895__$1;
(statearr_14938_15126[(1)] = (99));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (54))){
var inst_14644 = (state_14895[(10)]);
var inst_14662 = (state_14895[(11)]);
var inst_14653 = (state_14895[(17)]);
var inst_14626 = (state_14895[(19)]);
var inst_14675 = (state_14895[(24)]);
var inst_14557 = (state_14895[(27)]);
var inst_14635 = (state_14895[(28)]);
var inst_14677 = (state_14895[(50)]);
var inst_14549 = (state_14895[(32)]);
var inst_14581 = (state_14895[(33)]);
var inst_14556 = (state_14895[(39)]);
var inst_14572 = (state_14895[(41)]);
var inst_14550 = (state_14895[(42)]);
var inst_14671 = (state_14895[(46)]);
var inst_14671__$1 = (state_14895[(2)]);
var inst_14672 = fluree.db.flake.__GT_Flake(inst_14572,inst_14644,inst_14626,inst_14549,inst_14550,inst_14662);
var inst_14673 = fluree.db.flake.__GT_Flake(inst_14581,inst_14653,inst_14635,inst_14556,inst_14557,inst_14671__$1);
var inst_14674 = opts;
var inst_14675__$1 = cljs.core.__destructure_map(inst_14674);
var inst_14676 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_14675__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961),fluree.db.util.core.max_long);
var inst_14677__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14675__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_14678 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_14675__$1,new cljs.core.Keyword(null,"offset","offset",296498311),(0));
var state_14895__$1 = (function (){var statearr_14939 = state_14895;
(statearr_14939[(24)] = inst_14675__$1);

(statearr_14939[(30)] = inst_14672);

(statearr_14939[(50)] = inst_14677__$1);

(statearr_14939[(71)] = inst_14678);

(statearr_14939[(35)] = inst_14676);

(statearr_14939[(45)] = inst_14673);

(statearr_14939[(46)] = inst_14671__$1);

return statearr_14939;
})();
if(cljs.core.truth_(inst_14677__$1)){
var statearr_14940_15127 = state_14895__$1;
(statearr_14940_15127[(1)] = (58));

} else {
var statearr_14941_15128 = state_14895__$1;
(statearr_14941_15128[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (92))){
var inst_14771 = (state_14895[(72)]);
var inst_14715 = (state_14895[(26)]);
var inst_14714 = (state_14895[(36)]);
var inst_14713 = (state_14895[(37)]);
var inst_14716 = (state_14895[(48)]);
var inst_14774 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14775 = (inst_14713 - inst_14771);
var inst_14776 = [inst_14775,inst_14714,inst_14715,inst_14716];
var inst_14777 = (new cljs.core.PersistentVector(null,4,(5),inst_14774,inst_14776,null));
var state_14895__$1 = state_14895;
var statearr_14942_15129 = state_14895__$1;
(statearr_14942_15129[(2)] = inst_14777);

(statearr_14942_15129[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (104))){
var inst_14833 = (state_14895[(2)]);
var inst_14834 = fluree.db.util.async.throw_err(inst_14833);
var state_14895__$1 = state_14895;
var statearr_14943_15130 = state_14895__$1;
(statearr_14943_15130[(2)] = inst_14834);

(statearr_14943_15130[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (15))){
var inst_14555 = (state_14895[(61)]);
var inst_14585 = cljs.core.boolean_QMARK_(inst_14555);
var state_14895__$1 = state_14895;
if(inst_14585){
var statearr_14944_15131 = state_14895__$1;
(statearr_14944_15131[(1)] = (17));

} else {
var statearr_14945_15132 = state_14895__$1;
(statearr_14945_15132[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (48))){
var inst_14558 = (state_14895[(55)]);
var inst_14662 = (state_14895[(2)]);
var state_14895__$1 = (function (){var statearr_14946 = state_14895;
(statearr_14946[(11)] = inst_14662);

return statearr_14946;
})();
if(cljs.core.truth_(inst_14558)){
var statearr_14947_15133 = state_14895__$1;
(statearr_14947_15133[(1)] = (52));

} else {
var statearr_14948_15134 = state_14895__$1;
(statearr_14948_15134[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (50))){
var state_14895__$1 = state_14895;
var statearr_14949_15135 = state_14895__$1;
(statearr_14949_15135[(2)] = (2147483647));

(statearr_14949_15135[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (116))){
var inst_14867 = (state_14895[(66)]);
var inst_14875 = (state_14895[(2)]);
var state_14895__$1 = (function (){var statearr_14950 = state_14895;
(statearr_14950[(73)] = inst_14875);

return statearr_14950;
})();
if(cljs.core.truth_(inst_14867)){
var statearr_14951_15136 = state_14895__$1;
(statearr_14951_15136[(1)] = (118));

} else {
var statearr_14952_15137 = state_14895__$1;
(statearr_14952_15137[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (75))){
var inst_14730 = (state_14895[(20)]);
var state_14895__$1 = state_14895;
var statearr_14953_15138 = state_14895__$1;
(statearr_14953_15138[(2)] = inst_14730);

(statearr_14953_15138[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (99))){
var inst_14791 = (state_14895[(68)]);
var inst_14800 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14801 = [inst_14791,inst_14791];
var inst_14802 = (new cljs.core.PersistentVector(null,2,(5),inst_14800,inst_14801,null));
var state_14895__$1 = state_14895;
var statearr_14954_15139 = state_14895__$1;
(statearr_14954_15139[(2)] = inst_14802);

(statearr_14954_15139[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (21))){
var state_14895__$1 = state_14895;
var statearr_14955_15140 = state_14895__$1;
(statearr_14955_15140[(2)] = null);

(statearr_14955_15140[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (31))){
var inst_14616 = (state_14895[(74)]);
var state_14895__$1 = state_14895;
var statearr_14956_15141 = state_14895__$1;
(statearr_14956_15141[(2)] = inst_14616);

(statearr_14956_15141[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (113))){
var inst_14861 = (state_14895[(2)]);
var state_14895__$1 = state_14895;
var statearr_14957_15142 = state_14895__$1;
(statearr_14957_15142[(2)] = inst_14861);

(statearr_14957_15142[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (32))){
var inst_14636 = (state_14895[(75)]);
var inst_14547 = (state_14895[(60)]);
var inst_14635 = (state_14895[(2)]);
var inst_14636__$1 = (inst_14547 == null);
var state_14895__$1 = (function (){var statearr_14958 = state_14895;
(statearr_14958[(75)] = inst_14636__$1);

(statearr_14958[(28)] = inst_14635);

return statearr_14958;
})();
if(cljs.core.truth_(inst_14636__$1)){
var statearr_14959_15143 = state_14895__$1;
(statearr_14959_15143[(1)] = (34));

} else {
var statearr_14960_15144 = state_14895__$1;
(statearr_14960_15144[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (40))){
var inst_14635 = (state_14895[(28)]);
var state_14895__$1 = state_14895;
var statearr_14961_15145 = state_14895__$1;
(statearr_14961_15145[(2)] = inst_14635);

(statearr_14961_15145[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (91))){
var inst_14749 = (state_14895[(65)]);
var inst_14847 = (state_14895[(2)]);
var inst_14848 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14847,(0),null);
var inst_14849 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14847,(1),null);
var inst_14850 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14847,(2),null);
var inst_14851 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14847,(3),null);
var state_14895__$1 = (function (){var statearr_14962 = state_14895;
(statearr_14962[(7)] = inst_14851);

(statearr_14962[(76)] = inst_14848);

(statearr_14962[(77)] = inst_14850);

(statearr_14962[(78)] = inst_14849);

return statearr_14962;
})();
if(cljs.core.truth_(inst_14749)){
var statearr_14963_15146 = state_14895__$1;
(statearr_14963_15146[(1)] = (105));

} else {
var statearr_14964_15147 = state_14895__$1;
(statearr_14964_15147[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (117))){
var inst_14871 = (state_14895[(2)]);
var inst_14872 = fluree.db.util.async.throw_err(inst_14871);
var state_14895__$1 = state_14895;
var statearr_14965_15148 = state_14895__$1;
(statearr_14965_15148[(2)] = inst_14872);

(statearr_14965_15148[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (108))){
var inst_14676 = (state_14895[(35)]);
var inst_14849 = (state_14895[(78)]);
var inst_14856 = (state_14895[(79)]);
var inst_14856__$1 = (inst_14849 < inst_14676);
var state_14895__$1 = (function (){var statearr_14966 = state_14895;
(statearr_14966[(79)] = inst_14856__$1);

return statearr_14966;
})();
if(cljs.core.truth_(inst_14856__$1)){
var statearr_14967_15149 = state_14895__$1;
(statearr_14967_15149[(1)] = (111));

} else {
var statearr_14968_15150 = state_14895__$1;
(statearr_14968_15150[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (56))){
var state_14895__$1 = state_14895;
var statearr_14969_15151 = state_14895__$1;
(statearr_14969_15151[(2)] = fluree.db.util.core.min_integer);

(statearr_14969_15151[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (33))){
var inst_14631 = (state_14895[(2)]);
var inst_14632 = fluree.db.util.async.throw_err(inst_14631);
var state_14895__$1 = state_14895;
var statearr_14970_15152 = state_14895__$1;
(statearr_14970_15152[(2)] = inst_14632);

(statearr_14970_15152[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (13))){
var inst_14577 = (state_14895[(2)]);
var inst_14578 = fluree.db.util.async.throw_err(inst_14577);
var state_14895__$1 = state_14895;
var statearr_14971_15153 = state_14895__$1;
(statearr_14971_15153[(2)] = inst_14578);

(statearr_14971_15153[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (22))){
var inst_14591 = (state_14895[(2)]);
var state_14895__$1 = state_14895;
var statearr_14972_15154 = state_14895__$1;
(statearr_14972_15154[(2)] = inst_14591);

(statearr_14972_15154[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (90))){
var inst_14771 = (state_14895[(72)]);
var inst_14644 = (state_14895[(10)]);
var inst_14662 = (state_14895[(11)]);
var inst_14614 = (state_14895[(12)]);
var inst_14562 = (state_14895[(13)]);
var inst_14545 = (state_14895[(14)]);
var inst_14699 = (state_14895[(15)]);
var inst_14688 = (state_14895[(16)]);
var inst_14653 = (state_14895[(17)]);
var inst_14560 = (state_14895[(18)]);
var inst_14626 = (state_14895[(19)]);
var inst_14617 = (state_14895[(21)]);
var inst_14709 = (state_14895[(9)]);
var inst_14722 = (state_14895[(22)]);
var inst_14703 = (state_14895[(8)]);
var inst_14683 = (state_14895[(23)]);
var inst_14675 = (state_14895[(24)]);
var inst_14561 = (state_14895[(25)]);
var inst_14715 = (state_14895[(26)]);
var inst_14770 = (state_14895[(80)]);
var inst_14557 = (state_14895[(27)]);
var inst_14635 = (state_14895[(28)]);
var inst_14749 = (state_14895[(65)]);
var inst_14684 = (state_14895[(29)]);
var inst_14672 = (state_14895[(30)]);
var inst_14552 = (state_14895[(31)]);
var inst_14549 = (state_14895[(32)]);
var inst_14581 = (state_14895[(33)]);
var inst_14693 = (state_14895[(34)]);
var inst_14676 = (state_14895[(35)]);
var inst_14714 = (state_14895[(36)]);
var inst_14713 = (state_14895[(37)]);
var inst_14689 = (state_14895[(38)]);
var inst_14556 = (state_14895[(39)]);
var inst_14682 = (state_14895[(40)]);
var inst_14572 = (state_14895[(41)]);
var inst_14550 = (state_14895[(42)]);
var inst_14712 = (state_14895[(43)]);
var inst_14613 = (state_14895[(44)]);
var inst_14673 = (state_14895[(45)]);
var inst_14671 = (state_14895[(46)]);
var inst_14748 = (state_14895[(81)]);
var inst_14694 = (state_14895[(47)]);
var inst_14716 = (state_14895[(48)]);
var inst_14769 = (function (){var no_filter_QMARK_ = inst_14709;
var base_result_SINGLEQUOTE_ = inst_14748;
var t = inst_14689;
var max_limit_QMARK_ = inst_14683;
var next_node = inst_14712;
var fast_forward_db_QMARK_ = inst_14694;
var s1 = inst_14572;
var o2 = inst_14635;
var t1 = inst_14549;
var predicate_fn = inst_14562;
var i = inst_14714;
var rhs = inst_14749;
var m1 = inst_14662;
var root_node = inst_14699;
var s2 = inst_14581;
var vec__14534 = inst_14552;
var vec__14538 = inst_14613;
var p2 = inst_14653;
var permissions = inst_14684;
var limit = inst_14682;
var start_flake = inst_14672;
var flake_limit = inst_14676;
var offset = inst_14713;
var vec__14531 = inst_14545;
var acc = inst_14716;
var map__14537 = inst_14560;
var t2 = inst_14556;
var op1 = inst_14550;
var o1 = inst_14626;
var end_flake = inst_14673;
var base_result = inst_14722;
var s = inst_14715;
var node_start = inst_14703;
var p1 = inst_14644;
var subject_fn = inst_14561;
var object_fn = inst_14617;
var idx_compare = inst_14688;
var map__14544 = inst_14675;
var op2 = inst_14557;
var m2 = inst_14671;
var vec__14541 = inst_14614;
var novelty = inst_14693;
return (function (p1__14516_SHARP_){
return p1__14516_SHARP_.s;
});
})();
var inst_14770__$1 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_14769,inst_14748);
var inst_14771__$1 = cljs.core.count(inst_14770__$1);
var inst_14772 = (inst_14713 > inst_14771__$1);
var state_14895__$1 = (function (){var statearr_14973 = state_14895;
(statearr_14973[(72)] = inst_14771__$1);

(statearr_14973[(80)] = inst_14770__$1);

return statearr_14973;
})();
if(cljs.core.truth_(inst_14772)){
var statearr_14974_15155 = state_14895__$1;
(statearr_14974_15155[(1)] = (92));

} else {
var statearr_14975_15156 = state_14895__$1;
(statearr_14975_15156[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (109))){
var inst_14854 = (state_14895[(82)]);
var state_14895__$1 = state_14895;
var statearr_14976_15157 = state_14895__$1;
(statearr_14976_15157[(2)] = inst_14854);

(statearr_14976_15157[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (36))){
var inst_14640 = (state_14895[(2)]);
var state_14895__$1 = state_14895;
if(cljs.core.truth_(inst_14640)){
var statearr_14977_15158 = state_14895__$1;
(statearr_14977_15158[(1)] = (37));

} else {
var statearr_14978_15159 = state_14895__$1;
(statearr_14978_15159[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (41))){
var inst_14645 = (state_14895[(63)]);
var state_14895__$1 = state_14895;
var statearr_14979_15160 = state_14895__$1;
(statearr_14979_15160[(2)] = inst_14645);

(statearr_14979_15160[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (118))){
var inst_14875 = (state_14895[(73)]);
var state_14895__$1 = state_14895;
var statearr_14980_15161 = state_14895__$1;
(statearr_14980_15161[(2)] = inst_14875);

(statearr_14980_15161[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (89))){
var inst_14715 = (state_14895[(26)]);
var inst_14676 = (state_14895[(35)]);
var inst_14714 = (state_14895[(36)]);
var inst_14748 = (state_14895[(81)]);
var inst_14716 = (state_14895[(48)]);
var inst_14760 = cljs.core.count(inst_14748);
var inst_14761 = (inst_14676 - inst_14714);
var inst_14762 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_14761,inst_14748);
var inst_14763 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_14716,inst_14762);
var inst_14764 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14765 = (inst_14714 + inst_14760);
var inst_14766 = [(0),inst_14765,inst_14715,inst_14763];
var inst_14767 = (new cljs.core.PersistentVector(null,4,(5),inst_14764,inst_14766,null));
var state_14895__$1 = state_14895;
var statearr_14981_15162 = state_14895__$1;
(statearr_14981_15162[(2)] = inst_14767);

(statearr_14981_15162[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (100))){
var inst_14809 = (state_14895[(52)]);
var inst_14808 = (state_14895[(53)]);
var inst_14810 = (state_14895[(54)]);
var inst_14676 = (state_14895[(35)]);
var inst_14714 = (state_14895[(36)]);
var inst_14782 = (state_14895[(70)]);
var inst_14804 = (state_14895[(2)]);
var inst_14805 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14804,(0),null);
var inst_14806 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14804,(1),null);
var inst_14807 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_14806,inst_14782);
var inst_14808__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_14807);
var inst_14809__$1 = cljs.core.count(inst_14808__$1);
var inst_14810__$1 = (inst_14714 + inst_14809__$1);
var inst_14811 = (inst_14810__$1 > inst_14676);
var state_14895__$1 = (function (){var statearr_14982 = state_14895;
(statearr_14982[(52)] = inst_14809__$1);

(statearr_14982[(83)] = inst_14805);

(statearr_14982[(53)] = inst_14808__$1);

(statearr_14982[(54)] = inst_14810__$1);

return statearr_14982;
})();
if(cljs.core.truth_(inst_14811)){
var statearr_14983_15163 = state_14895__$1;
(statearr_14983_15163[(1)] = (101));

} else {
var statearr_14984_15164 = state_14895__$1;
(statearr_14984_15164[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (122))){
var inst_14875 = (state_14895[(73)]);
var inst_14851 = (state_14895[(7)]);
var inst_14848 = (state_14895[(76)]);
var inst_14850 = (state_14895[(77)]);
var inst_14849 = (state_14895[(78)]);
var inst_14712 = inst_14875;
var inst_14713 = inst_14848;
var inst_14714 = inst_14849;
var inst_14715 = inst_14850;
var inst_14716 = inst_14851;
var state_14895__$1 = (function (){var statearr_14985 = state_14895;
(statearr_14985[(26)] = inst_14715);

(statearr_14985[(36)] = inst_14714);

(statearr_14985[(37)] = inst_14713);

(statearr_14985[(43)] = inst_14712);

(statearr_14985[(48)] = inst_14716);

return statearr_14985;
})();
var statearr_14986_15165 = state_14895__$1;
(statearr_14986_15165[(2)] = null);

(statearr_14986_15165[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (43))){
var state_14895__$1 = state_14895;
var statearr_14987_15166 = state_14895__$1;
(statearr_14987_15166[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_14987_15166[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (61))){
var inst_14699 = (state_14895[(15)]);
var inst_14672 = (state_14895[(30)]);
var inst_14693 = (state_14895[(34)]);
var inst_14689 = (state_14895[(38)]);
var inst_14694 = (state_14895[(47)]);
var inst_14698 = (state_14895[(2)]);
var inst_14699__$1 = fluree.db.util.async.throw_err(inst_14698);
var inst_14700 = fluree.db.query.range.find_next_valid_node(inst_14699__$1,inst_14672,inst_14689,inst_14693,inst_14694);
var state_14895__$1 = (function (){var statearr_14988 = state_14895;
(statearr_14988[(15)] = inst_14699__$1);

return statearr_14988;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14895__$1,(62),inst_14700);
} else {
if((state_val_14896 === (29))){
var inst_14622 = (state_14895[(2)]);
var inst_14623 = fluree.db.util.async.throw_err(inst_14622);
var state_14895__$1 = state_14895;
var statearr_14989_15167 = state_14895__$1;
(statearr_14989_15167[(2)] = inst_14623);

(statearr_14989_15167[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (44))){
var inst_14554 = (state_14895[(59)]);
var state_14895__$1 = state_14895;
var statearr_14990_15168 = state_14895__$1;
(statearr_14990_15168[(2)] = inst_14554);

(statearr_14990_15168[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (93))){
var inst_14709 = (state_14895[(9)]);
var inst_14770 = (state_14895[(80)]);
var inst_14713 = (state_14895[(37)]);
var inst_14782 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_14713,inst_14770);
var state_14895__$1 = (function (){var statearr_14991 = state_14895;
(statearr_14991[(70)] = inst_14782);

return statearr_14991;
})();
if(cljs.core.truth_(inst_14709)){
var statearr_14992_15169 = state_14895__$1;
(statearr_14992_15169[(1)] = (95));

} else {
var statearr_14993_15170 = state_14895__$1;
(statearr_14993_15170[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (6))){
var inst_14546 = (state_14895[(49)]);
var inst_14566 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_14546);
var state_14895__$1 = state_14895;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14895__$1,(9),inst_14566);
} else {
if((state_val_14896 === (111))){
var inst_14682 = (state_14895[(40)]);
var inst_14850 = (state_14895[(77)]);
var inst_14858 = (inst_14850 < inst_14682);
var state_14895__$1 = state_14895;
var statearr_14994_15171 = state_14895__$1;
(statearr_14994_15171[(2)] = inst_14858);

(statearr_14994_15171[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (28))){
var inst_14616 = (state_14895[(74)]);
var inst_14626 = (state_14895[(2)]);
var inst_14627 = fluree.db.util.core.pred_ident_QMARK_(inst_14616);
var state_14895__$1 = (function (){var statearr_14995 = state_14895;
(statearr_14995[(19)] = inst_14626);

return statearr_14995;
})();
if(inst_14627){
var statearr_14996_15172 = state_14895__$1;
(statearr_14996_15172[(1)] = (30));

} else {
var statearr_14997_15173 = state_14895__$1;
(statearr_14997_15173[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (64))){
var state_14895__$1 = state_14895;
var statearr_14998_15174 = state_14895__$1;
(statearr_14998_15174[(2)] = true);

(statearr_14998_15174[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (103))){
var inst_14805 = (state_14895[(83)]);
var inst_14824 = (state_14895[(2)]);
var inst_14825 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14824,(0),null);
var inst_14826 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14824,(1),null);
var inst_14827 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14828 = [inst_14825,inst_14805,inst_14826];
var inst_14829 = (new cljs.core.PersistentVector(null,3,(5),inst_14827,inst_14828,null));
var state_14895__$1 = state_14895;
var statearr_14999_15175 = state_14895__$1;
(statearr_14999_15175[(2)] = inst_14829);

(statearr_14999_15175[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (51))){
var inst_14660 = (state_14895[(2)]);
var state_14895__$1 = state_14895;
var statearr_15000_15176 = state_14895__$1;
(statearr_15000_15176[(2)] = inst_14660);

(statearr_15000_15176[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (25))){
var inst_14614 = (state_14895[(12)]);
var inst_14615 = (state_14895[(51)]);
var inst_14613 = (state_14895[(44)]);
var inst_14613__$1 = (state_14895[(2)]);
var inst_14614__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14613__$1,(0),null);
var inst_14615__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14614__$1,(0),null);
var inst_14616 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14614__$1,(1),null);
var inst_14617 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14613__$1,(1),null);
var inst_14618 = fluree.db.util.core.pred_ident_QMARK_(inst_14615__$1);
var state_14895__$1 = (function (){var statearr_15001 = state_14895;
(statearr_15001[(12)] = inst_14614__$1);

(statearr_15001[(21)] = inst_14617);

(statearr_15001[(51)] = inst_14615__$1);

(statearr_15001[(74)] = inst_14616);

(statearr_15001[(44)] = inst_14613__$1);

return statearr_15001;
})();
if(inst_14618){
var statearr_15002_15177 = state_14895__$1;
(statearr_15002_15177[(1)] = (26));

} else {
var statearr_15003_15178 = state_14895__$1;
(statearr_15003_15178[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (34))){
var inst_14626 = (state_14895[(19)]);
var state_14895__$1 = state_14895;
var statearr_15004_15179 = state_14895__$1;
(statearr_15004_15179[(2)] = inst_14626);

(statearr_15004_15179[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (17))){
var inst_14555 = (state_14895[(61)]);
var state_14895__$1 = state_14895;
var statearr_15005_15180 = state_14895__$1;
(statearr_15005_15180[(2)] = inst_14555);

(statearr_15005_15180[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (3))){
var inst_14893 = (state_14895[(2)]);
var state_14895__$1 = state_14895;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14895__$1,inst_14893);
} else {
if((state_val_14896 === (12))){
var inst_14548 = (state_14895[(57)]);
var inst_14581 = (state_14895[(2)]);
var inst_14582 = cljs.core.boolean_QMARK_(inst_14548);
var state_14895__$1 = (function (){var statearr_15006 = state_14895;
(statearr_15006[(33)] = inst_14581);

return statearr_15006;
})();
if(inst_14582){
var statearr_15007_15181 = state_14895__$1;
(statearr_15007_15181[(1)] = (14));

} else {
var statearr_15008_15182 = state_14895__$1;
(statearr_15008_15182[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (2))){
var inst_14545 = (state_14895[(14)]);
var inst_14560 = (state_14895[(18)]);
var inst_14552 = (state_14895[(31)]);
var inst_14546 = (state_14895[(49)]);
var _ = (function (){var statearr_15009 = state_14895;
(statearr_15009[(4)] = cljs.core.cons((5),(state_14895[(4)])));

return statearr_15009;
})();
var inst_14545__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_14546__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14545__$1,(0),null);
var inst_14547 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14545__$1,(1),null);
var inst_14548 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14545__$1,(2),null);
var inst_14549 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14545__$1,(3),null);
var inst_14550 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14545__$1,(4),null);
var inst_14551 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14545__$1,(5),null);
var inst_14552__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_14553 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14552__$1,(0),null);
var inst_14554 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14552__$1,(1),null);
var inst_14555 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14552__$1,(2),null);
var inst_14556 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14552__$1,(3),null);
var inst_14557 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14552__$1,(4),null);
var inst_14558 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14552__$1,(5),null);
var inst_14559 = opts;
var inst_14560__$1 = cljs.core.__destructure_map(inst_14559);
var inst_14561 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14560__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var inst_14562 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14560__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var inst_14563 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14560__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var inst_14564 = fluree.db.util.core.pred_ident_QMARK_(inst_14546__$1);
var state_14895__$1 = (function (){var statearr_15010 = state_14895;
(statearr_15010[(13)] = inst_14562);

(statearr_15010[(14)] = inst_14545__$1);

(statearr_15010[(18)] = inst_14560__$1);

(statearr_15010[(55)] = inst_14558);

(statearr_15010[(25)] = inst_14561);

(statearr_15010[(27)] = inst_14557);

(statearr_15010[(57)] = inst_14548);

(statearr_15010[(31)] = inst_14552__$1);

(statearr_15010[(32)] = inst_14549);

(statearr_15010[(58)] = inst_14563);

(statearr_15010[(84)] = inst_14553);

(statearr_15010[(59)] = inst_14554);

(statearr_15010[(39)] = inst_14556);

(statearr_15010[(42)] = inst_14550);

(statearr_15010[(60)] = inst_14547);

(statearr_15010[(61)] = inst_14555);

(statearr_15010[(49)] = inst_14546__$1);

(statearr_15010[(62)] = inst_14551);

return statearr_15010;
})();
if(inst_14564){
var statearr_15011_15183 = state_14895__$1;
(statearr_15011_15183[(1)] = (6));

} else {
var statearr_15012_15184 = state_14895__$1;
(statearr_15012_15184[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (66))){
var inst_14703 = (state_14895[(8)]);
var inst_14678 = (state_14895[(71)]);
var inst_14711 = cljs.core.PersistentVector.EMPTY;
var inst_14712 = inst_14703;
var inst_14713 = inst_14678;
var inst_14714 = (0);
var inst_14715 = (0);
var inst_14716 = inst_14711;
var state_14895__$1 = (function (){var statearr_15013 = state_14895;
(statearr_15013[(26)] = inst_14715);

(statearr_15013[(36)] = inst_14714);

(statearr_15013[(37)] = inst_14713);

(statearr_15013[(43)] = inst_14712);

(statearr_15013[(48)] = inst_14716);

return statearr_15013;
})();
var statearr_15014_15185 = state_14895__$1;
(statearr_15014_15185[(2)] = null);

(statearr_15014_15185[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (107))){
var inst_14867 = (state_14895[(66)]);
var inst_14867__$1 = (state_14895[(2)]);
var state_14895__$1 = (function (){var statearr_15015 = state_14895;
(statearr_15015[(66)] = inst_14867__$1);

return statearr_15015;
})();
if(cljs.core.truth_(inst_14867__$1)){
var statearr_15016_15186 = state_14895__$1;
(statearr_15016_15186[(1)] = (114));

} else {
var statearr_15017_15187 = state_14895__$1;
(statearr_15017_15187[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (23))){
var inst_14548 = (state_14895[(57)]);
var inst_14563 = (state_14895[(58)]);
var inst_14555 = (state_14895[(61)]);
var inst_14598 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14599 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14600 = [inst_14548,inst_14555];
var inst_14601 = (new cljs.core.PersistentVector(null,2,(5),inst_14599,inst_14600,null));
var inst_14602 = [inst_14601,inst_14563];
var inst_14603 = (new cljs.core.PersistentVector(null,2,(5),inst_14598,inst_14602,null));
var state_14895__$1 = state_14895;
var statearr_15018_15188 = state_14895__$1;
(statearr_15018_15188[(2)] = inst_14603);

(statearr_15018_15188[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (47))){
var inst_14656 = (cljs.core._GT__EQ_ === start_test);
var state_14895__$1 = state_14895;
if(cljs.core.truth_(inst_14656)){
var statearr_15019_15189 = state_14895__$1;
(statearr_15019_15189[(1)] = (49));

} else {
var statearr_15020_15190 = state_14895__$1;
(statearr_15020_15190[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (35))){
var inst_14636 = (state_14895[(75)]);
var state_14895__$1 = state_14895;
var statearr_15021_15191 = state_14895__$1;
(statearr_15021_15191[(2)] = inst_14636);

(statearr_15021_15191[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (82))){
var inst_14683 = (state_14895[(23)]);
var inst_14712 = (state_14895[(43)]);
var inst_14748 = (state_14895[(2)]);
var inst_14749 = fluree.db.dbproto._rhs(inst_14712);
var state_14895__$1 = (function (){var statearr_15022 = state_14895;
(statearr_15022[(65)] = inst_14749);

(statearr_15022[(81)] = inst_14748);

return statearr_15022;
})();
if(cljs.core.truth_(inst_14683)){
var statearr_15023_15192 = state_14895__$1;
(statearr_15023_15192[(1)] = (83));

} else {
var statearr_15024_15193 = state_14895__$1;
(statearr_15024_15193[(1)] = (84));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (76))){
var inst_14562 = (state_14895[(13)]);
var inst_14736 = (state_14895[(2)]);
var state_14895__$1 = (function (){var statearr_15025 = state_14895;
(statearr_15025[(64)] = inst_14736);

return statearr_15025;
})();
if(cljs.core.truth_(inst_14562)){
var statearr_15026_15194 = state_14895__$1;
(statearr_15026_15194[(1)] = (77));

} else {
var statearr_15027_15195 = state_14895__$1;
(statearr_15027_15195[(1)] = (78));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (97))){
var inst_14716 = (state_14895[(48)]);
var inst_14836 = (state_14895[(2)]);
var inst_14837 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14836,(0),null);
var inst_14838 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14836,(1),null);
var inst_14839 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14836,(2),null);
var inst_14840 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14841 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_14716,inst_14839);
var inst_14842 = [(0),inst_14837,inst_14838,inst_14841];
var inst_14843 = (new cljs.core.PersistentVector(null,4,(5),inst_14840,inst_14842,null));
var state_14895__$1 = state_14895;
var statearr_15028_15196 = state_14895__$1;
(statearr_15028_15196[(2)] = inst_14843);

(statearr_15028_15196[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (19))){
var inst_14593 = (state_14895[(2)]);
var state_14895__$1 = state_14895;
var statearr_15029_15197 = state_14895__$1;
(statearr_15029_15197[(2)] = inst_14593);

(statearr_15029_15197[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (57))){
var inst_14669 = (state_14895[(2)]);
var state_14895__$1 = state_14895;
var statearr_15030_15198 = state_14895__$1;
(statearr_15030_15198[(2)] = inst_14669);

(statearr_15030_15198[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (68))){
var inst_14890 = (state_14895[(2)]);
var _ = (function (){var statearr_15031 = state_14895;
(statearr_15031[(4)] = cljs.core.rest((state_14895[(4)])));

return statearr_15031;
})();
var state_14895__$1 = state_14895;
var statearr_15032_15199 = state_14895__$1;
(statearr_15032_15199[(2)] = inst_14890);

(statearr_15032_15199[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (11))){
var inst_14553 = (state_14895[(84)]);
var state_14895__$1 = state_14895;
var statearr_15033_15200 = state_14895__$1;
(statearr_15033_15200[(2)] = inst_14553);

(statearr_15033_15200[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (115))){
var state_14895__$1 = state_14895;
var statearr_15035_15201 = state_14895__$1;
(statearr_15035_15201[(2)] = null);

(statearr_15035_15201[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (9))){
var inst_14568 = (state_14895[(2)]);
var inst_14569 = fluree.db.util.async.throw_err(inst_14568);
var state_14895__$1 = state_14895;
var statearr_15036_15202 = state_14895__$1;
(statearr_15036_15202[(2)] = inst_14569);

(statearr_15036_15202[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (5))){
var _ = (function (){var statearr_15037 = state_14895;
(statearr_15037[(4)] = cljs.core.rest((state_14895[(4)])));

return statearr_15037;
})();
var state_14895__$1 = state_14895;
var ex15034 = (state_14895__$1[(2)]);
var statearr_15038_15203 = state_14895__$1;
(statearr_15038_15203[(5)] = ex15034);


if((ex15034 instanceof Error)){
var statearr_15039_15204 = state_14895__$1;
(statearr_15039_15204[(1)] = (4));

(statearr_15039_15204[(5)] = null);

} else {
throw ex15034;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (112))){
var inst_14856 = (state_14895[(79)]);
var state_14895__$1 = state_14895;
var statearr_15040_15205 = state_14895__$1;
(statearr_15040_15205[(2)] = inst_14856);

(statearr_15040_15205[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (83))){
var inst_14751 = (state_14895[(85)]);
var inst_14713 = (state_14895[(37)]);
var inst_14751__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_14713);
var state_14895__$1 = (function (){var statearr_15041 = state_14895;
(statearr_15041[(85)] = inst_14751__$1);

return statearr_15041;
})();
if(inst_14751__$1){
var statearr_15042_15206 = state_14895__$1;
(statearr_15042_15206[(1)] = (86));

} else {
var statearr_15043_15207 = state_14895__$1;
(statearr_15043_15207[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (14))){
var inst_14548 = (state_14895[(57)]);
var state_14895__$1 = state_14895;
var statearr_15044_15208 = state_14895__$1;
(statearr_15044_15208[(2)] = inst_14548);

(statearr_15044_15208[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (45))){
var inst_14551 = (state_14895[(62)]);
var inst_14653 = (state_14895[(2)]);
var state_14895__$1 = (function (){var statearr_15045 = state_14895;
(statearr_15045[(17)] = inst_14653);

return statearr_15045;
})();
if(cljs.core.truth_(inst_14551)){
var statearr_15046_15209 = state_14895__$1;
(statearr_15046_15209[(1)] = (46));

} else {
var statearr_15047_15210 = state_14895__$1;
(statearr_15047_15210[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (53))){
var inst_14665 = (cljs.core._LT__EQ_ === end_test);
var state_14895__$1 = state_14895;
if(cljs.core.truth_(inst_14665)){
var statearr_15048_15211 = state_14895__$1;
(statearr_15048_15211[(1)] = (55));

} else {
var statearr_15049_15212 = state_14895__$1;
(statearr_15049_15212[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (78))){
var inst_14736 = (state_14895[(64)]);
var state_14895__$1 = state_14895;
var statearr_15050_15213 = state_14895__$1;
(statearr_15050_15213[(2)] = inst_14736);

(statearr_15050_15213[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (26))){
var inst_14615 = (state_14895[(51)]);
var inst_14620 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_14615);
var state_14895__$1 = state_14895;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14895__$1,(29),inst_14620);
} else {
if((state_val_14896 === (123))){
var inst_14885 = (state_14895[(2)]);
var state_14895__$1 = state_14895;
var statearr_15051_15214 = state_14895__$1;
(statearr_15051_15214[(2)] = inst_14885);

(statearr_15051_15214[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (16))){
var inst_14595 = (state_14895[(56)]);
var inst_14595__$1 = (state_14895[(2)]);
var inst_14596 = (inst_14595__$1 == null);
var state_14895__$1 = (function (){var statearr_15052 = state_14895;
(statearr_15052[(56)] = inst_14595__$1);

return statearr_15052;
})();
if(cljs.core.truth_(inst_14596)){
var statearr_15053_15215 = state_14895__$1;
(statearr_15053_15215[(1)] = (23));

} else {
var statearr_15054_15216 = state_14895__$1;
(statearr_15054_15216[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (81))){
var inst_14742 = (state_14895[(86)]);
var state_14895__$1 = state_14895;
var statearr_15055_15217 = state_14895__$1;
(statearr_15055_15217[(2)] = inst_14742);

(statearr_15055_15217[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (120))){
var inst_14879 = (state_14895[(2)]);
var inst_14880 = cljs.core.not(inst_14879);
var state_14895__$1 = state_14895;
if(inst_14880){
var statearr_15056_15218 = state_14895__$1;
(statearr_15056_15218[(1)] = (121));

} else {
var statearr_15057_15219 = state_14895__$1;
(statearr_15057_15219[(1)] = (122));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (79))){
var inst_14617 = (state_14895[(21)]);
var inst_14742 = (state_14895[(2)]);
var state_14895__$1 = (function (){var statearr_15058 = state_14895;
(statearr_15058[(86)] = inst_14742);

return statearr_15058;
})();
if(cljs.core.truth_(inst_14617)){
var statearr_15059_15220 = state_14895__$1;
(statearr_15059_15220[(1)] = (80));

} else {
var statearr_15060_15221 = state_14895__$1;
(statearr_15060_15221[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (38))){
var inst_14547 = (state_14895[(60)]);
var state_14895__$1 = state_14895;
var statearr_15061_15222 = state_14895__$1;
(statearr_15061_15222[(2)] = inst_14547);

(statearr_15061_15222[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (98))){
var inst_14792 = (state_14895[(67)]);
var inst_14790 = (state_14895[(69)]);
var inst_14682 = (state_14895[(40)]);
var inst_14795 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14796 = (inst_14790 - inst_14792);
var inst_14797 = [inst_14682,inst_14796];
var inst_14798 = (new cljs.core.PersistentVector(null,2,(5),inst_14795,inst_14797,null));
var state_14895__$1 = state_14895;
var statearr_15062_15223 = state_14895__$1;
(statearr_15062_15223[(2)] = inst_14798);

(statearr_15062_15223[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (87))){
var inst_14751 = (state_14895[(85)]);
var state_14895__$1 = state_14895;
var statearr_15063_15224 = state_14895__$1;
(statearr_15063_15224[(2)] = inst_14751);

(statearr_15063_15224[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (30))){
var inst_14616 = (state_14895[(74)]);
var inst_14629 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_14616);
var state_14895__$1 = state_14895;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14895__$1,(33),inst_14629);
} else {
if((state_val_14896 === (73))){
var inst_14561 = (state_14895[(25)]);
var inst_14730 = (state_14895[(2)]);
var state_14895__$1 = (function (){var statearr_15064 = state_14895;
(statearr_15064[(20)] = inst_14730);

return statearr_15064;
})();
if(cljs.core.truth_(inst_14561)){
var statearr_15065_15225 = state_14895__$1;
(statearr_15065_15225[(1)] = (74));

} else {
var statearr_15066_15226 = state_14895__$1;
(statearr_15066_15226[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (96))){
var inst_14715 = (state_14895[(26)]);
var inst_14676 = (state_14895[(35)]);
var inst_14714 = (state_14895[(36)]);
var inst_14682 = (state_14895[(40)]);
var inst_14782 = (state_14895[(70)]);
var inst_14831 = fluree.db.query.range.subject_groups__GT_allow_flakes(db,inst_14782,inst_14714,inst_14715,inst_14676,inst_14682);
var state_14895__$1 = state_14895;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14895__$1,(104),inst_14831);
} else {
if((state_val_14896 === (10))){
var inst_14553 = (state_14895[(84)]);
var inst_14575 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_14553);
var state_14895__$1 = state_14895;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14895__$1,(13),inst_14575);
} else {
if((state_val_14896 === (18))){
var state_14895__$1 = state_14895;
var statearr_15067_15227 = state_14895__$1;
(statearr_15067_15227[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (105))){
var inst_14688 = (state_14895[(16)]);
var inst_14749 = (state_14895[(65)]);
var inst_14854 = (state_14895[(82)]);
var inst_14673 = (state_14895[(45)]);
var inst_14853 = (inst_14688.cljs$core$IFn$_invoke$arity$2 ? inst_14688.cljs$core$IFn$_invoke$arity$2(inst_14749,inst_14673) : inst_14688.call(null,inst_14749,inst_14673));
var inst_14854__$1 = (inst_14853 < (0));
var state_14895__$1 = (function (){var statearr_15069 = state_14895;
(statearr_15069[(82)] = inst_14854__$1);

return statearr_15069;
})();
if(cljs.core.truth_(inst_14854__$1)){
var statearr_15070_15228 = state_14895__$1;
(statearr_15070_15228[(1)] = (108));

} else {
var statearr_15071_15229 = state_14895__$1;
(statearr_15071_15229[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (52))){
var inst_14558 = (state_14895[(55)]);
var state_14895__$1 = state_14895;
var statearr_15072_15230 = state_14895__$1;
(statearr_15072_15230[(2)] = inst_14558);

(statearr_15072_15230[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (114))){
var inst_14699 = (state_14895[(15)]);
var inst_14749 = (state_14895[(65)]);
var inst_14693 = (state_14895[(34)]);
var inst_14689 = (state_14895[(38)]);
var inst_14694 = (state_14895[(47)]);
var inst_14869 = fluree.db.query.range.find_next_valid_node(inst_14699,inst_14749,inst_14689,inst_14693,inst_14694);
var state_14895__$1 = state_14895;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14895__$1,(117),inst_14869);
} else {
if((state_val_14896 === (67))){
var state_14895__$1 = state_14895;
var statearr_15073_15231 = state_14895__$1;
(statearr_15073_15231[(2)] = null);

(statearr_15073_15231[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (71))){
var inst_14644 = (state_14895[(10)]);
var inst_14662 = (state_14895[(11)]);
var inst_14614 = (state_14895[(12)]);
var inst_14562 = (state_14895[(13)]);
var inst_14545 = (state_14895[(14)]);
var inst_14699 = (state_14895[(15)]);
var inst_14688 = (state_14895[(16)]);
var inst_14653 = (state_14895[(17)]);
var inst_14560 = (state_14895[(18)]);
var inst_14626 = (state_14895[(19)]);
var inst_14617 = (state_14895[(21)]);
var inst_14709 = (state_14895[(9)]);
var inst_14722 = (state_14895[(22)]);
var inst_14703 = (state_14895[(8)]);
var inst_14683 = (state_14895[(23)]);
var inst_14675 = (state_14895[(24)]);
var inst_14561 = (state_14895[(25)]);
var inst_14715 = (state_14895[(26)]);
var inst_14557 = (state_14895[(27)]);
var inst_14635 = (state_14895[(28)]);
var inst_14684 = (state_14895[(29)]);
var inst_14672 = (state_14895[(30)]);
var inst_14552 = (state_14895[(31)]);
var inst_14549 = (state_14895[(32)]);
var inst_14581 = (state_14895[(33)]);
var inst_14693 = (state_14895[(34)]);
var inst_14676 = (state_14895[(35)]);
var inst_14714 = (state_14895[(36)]);
var inst_14713 = (state_14895[(37)]);
var inst_14689 = (state_14895[(38)]);
var inst_14556 = (state_14895[(39)]);
var inst_14682 = (state_14895[(40)]);
var inst_14572 = (state_14895[(41)]);
var inst_14550 = (state_14895[(42)]);
var inst_14712 = (state_14895[(43)]);
var inst_14613 = (state_14895[(44)]);
var inst_14673 = (state_14895[(45)]);
var inst_14671 = (state_14895[(46)]);
var inst_14694 = (state_14895[(47)]);
var inst_14716 = (state_14895[(48)]);
var inst_14726 = (function (){var no_filter_QMARK_ = inst_14709;
var t = inst_14689;
var max_limit_QMARK_ = inst_14683;
var next_node = inst_14712;
var fast_forward_db_QMARK_ = inst_14694;
var s1 = inst_14572;
var o2 = inst_14635;
var t1 = inst_14549;
var predicate_fn = inst_14562;
var i = inst_14714;
var m1 = inst_14662;
var root_node = inst_14699;
var s2 = inst_14581;
var vec__14534 = inst_14552;
var vec__14538 = inst_14613;
var p2 = inst_14653;
var permissions = inst_14684;
var limit = inst_14682;
var start_flake = inst_14672;
var flake_limit = inst_14676;
var offset = inst_14713;
var vec__14531 = inst_14545;
var acc = inst_14716;
var map__14537 = inst_14560;
var t2 = inst_14556;
var op1 = inst_14550;
var o1 = inst_14626;
var end_flake = inst_14673;
var base_result = inst_14722;
var s = inst_14715;
var node_start = inst_14703;
var p1 = inst_14644;
var subject_fn = inst_14561;
var object_fn = inst_14617;
var idx_compare = inst_14688;
var map__14544 = inst_14675;
var op2 = inst_14557;
var m2 = inst_14671;
var vec__14541 = inst_14614;
var G__14723 = inst_14722;
var novelty = inst_14693;
return (function (p1__14512_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__14512_SHARP_.o,start_flake.o);
});
})();
var inst_14727 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_14726,inst_14722);
var state_14895__$1 = state_14895;
var statearr_15074_15232 = state_14895__$1;
(statearr_15074_15232[(2)] = inst_14727);

(statearr_15074_15232[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (42))){
var inst_14649 = (state_14895[(2)]);
var state_14895__$1 = state_14895;
if(cljs.core.truth_(inst_14649)){
var statearr_15075_15233 = state_14895__$1;
(statearr_15075_15233[(1)] = (43));

} else {
var statearr_15076_15234 = state_14895__$1;
(statearr_15076_15234[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (80))){
var inst_14644 = (state_14895[(10)]);
var inst_14662 = (state_14895[(11)]);
var inst_14614 = (state_14895[(12)]);
var inst_14562 = (state_14895[(13)]);
var inst_14545 = (state_14895[(14)]);
var inst_14699 = (state_14895[(15)]);
var inst_14688 = (state_14895[(16)]);
var inst_14653 = (state_14895[(17)]);
var inst_14560 = (state_14895[(18)]);
var inst_14626 = (state_14895[(19)]);
var inst_14617 = (state_14895[(21)]);
var inst_14709 = (state_14895[(9)]);
var inst_14722 = (state_14895[(22)]);
var inst_14703 = (state_14895[(8)]);
var inst_14683 = (state_14895[(23)]);
var inst_14675 = (state_14895[(24)]);
var inst_14561 = (state_14895[(25)]);
var inst_14715 = (state_14895[(26)]);
var inst_14557 = (state_14895[(27)]);
var inst_14742 = (state_14895[(86)]);
var inst_14635 = (state_14895[(28)]);
var inst_14684 = (state_14895[(29)]);
var inst_14672 = (state_14895[(30)]);
var inst_14552 = (state_14895[(31)]);
var inst_14549 = (state_14895[(32)]);
var inst_14581 = (state_14895[(33)]);
var inst_14693 = (state_14895[(34)]);
var inst_14676 = (state_14895[(35)]);
var inst_14714 = (state_14895[(36)]);
var inst_14713 = (state_14895[(37)]);
var inst_14689 = (state_14895[(38)]);
var inst_14556 = (state_14895[(39)]);
var inst_14682 = (state_14895[(40)]);
var inst_14572 = (state_14895[(41)]);
var inst_14550 = (state_14895[(42)]);
var inst_14712 = (state_14895[(43)]);
var inst_14613 = (state_14895[(44)]);
var inst_14673 = (state_14895[(45)]);
var inst_14671 = (state_14895[(46)]);
var inst_14694 = (state_14895[(47)]);
var inst_14716 = (state_14895[(48)]);
var inst_14744 = (function (){var no_filter_QMARK_ = inst_14709;
var t = inst_14689;
var max_limit_QMARK_ = inst_14683;
var next_node = inst_14712;
var fast_forward_db_QMARK_ = inst_14694;
var s1 = inst_14572;
var o2 = inst_14635;
var t1 = inst_14549;
var predicate_fn = inst_14562;
var i = inst_14714;
var m1 = inst_14662;
var root_node = inst_14699;
var s2 = inst_14581;
var vec__14534 = inst_14552;
var vec__14538 = inst_14613;
var p2 = inst_14653;
var permissions = inst_14684;
var limit = inst_14682;
var start_flake = inst_14672;
var flake_limit = inst_14676;
var offset = inst_14713;
var vec__14531 = inst_14545;
var acc = inst_14716;
var map__14537 = inst_14560;
var t2 = inst_14556;
var op1 = inst_14550;
var o1 = inst_14626;
var end_flake = inst_14673;
var base_result = inst_14722;
var s = inst_14715;
var node_start = inst_14703;
var p1 = inst_14644;
var subject_fn = inst_14561;
var object_fn = inst_14617;
var idx_compare = inst_14688;
var map__14544 = inst_14675;
var op2 = inst_14557;
var m2 = inst_14671;
var vec__14541 = inst_14614;
var G__14723 = inst_14742;
var novelty = inst_14693;
return (function (p1__14515_SHARP_){
var G__15077 = p1__14515_SHARP_.o;
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__15077) : object_fn.call(null,G__15077));
});
})();
var inst_14745 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_14744,inst_14742);
var state_14895__$1 = state_14895;
var statearr_15078_15235 = state_14895__$1;
(statearr_15078_15235[(2)] = inst_14745);

(statearr_15078_15235[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (37))){
var state_14895__$1 = state_14895;
var statearr_15079_15236 = state_14895__$1;
(statearr_15079_15236[(2)] = (-1));

(statearr_15079_15236[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (63))){
var inst_14644 = (state_14895[(10)]);
var inst_14653 = (state_14895[(17)]);
var inst_14684 = (state_14895[(29)]);
var inst_14581 = (state_14895[(33)]);
var inst_14572 = (state_14895[(41)]);
var inst_14706 = fluree.db.permissions_validate.no_filter_QMARK_(inst_14684,inst_14572,inst_14581,inst_14644,inst_14653);
var state_14895__$1 = state_14895;
var statearr_15080_15237 = state_14895__$1;
(statearr_15080_15237[(2)] = inst_14706);

(statearr_15080_15237[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (94))){
var inst_14845 = (state_14895[(2)]);
var state_14895__$1 = state_14895;
var statearr_15081_15238 = state_14895__$1;
(statearr_15081_15238[(2)] = inst_14845);

(statearr_15081_15238[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (8))){
var inst_14553 = (state_14895[(84)]);
var inst_14572 = (state_14895[(2)]);
var inst_14573 = fluree.db.util.core.pred_ident_QMARK_(inst_14553);
var state_14895__$1 = (function (){var statearr_15082 = state_14895;
(statearr_15082[(41)] = inst_14572);

return statearr_15082;
})();
if(inst_14573){
var statearr_15083_15239 = state_14895__$1;
(statearr_15083_15239[(1)] = (10));

} else {
var statearr_15084_15240 = state_14895__$1;
(statearr_15084_15240[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (49))){
var state_14895__$1 = state_14895;
var statearr_15085_15241 = state_14895__$1;
(statearr_15085_15241[(2)] = fluree.db.util.core.min_integer);

(statearr_15085_15241[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14896 === (84))){
var inst_14683 = (state_14895[(23)]);
var state_14895__$1 = state_14895;
var statearr_15086_15242 = state_14895__$1;
(statearr_15086_15242[(2)] = inst_14683);

(statearr_15086_15242[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2717__auto__ = null;
var fluree$db$query$range$state_machine__2717__auto____0 = (function (){
var statearr_15087 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15087[(0)] = fluree$db$query$range$state_machine__2717__auto__);

(statearr_15087[(1)] = (1));

return statearr_15087;
});
var fluree$db$query$range$state_machine__2717__auto____1 = (function (state_14895){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_14895);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e15088){var ex__2720__auto__ = e15088;
var statearr_15089_15243 = state_14895;
(statearr_15089_15243[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_14895[(4)]))){
var statearr_15090_15244 = state_14895;
(statearr_15090_15244[(1)] = cljs.core.first((state_14895[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15245 = state_14895;
state_14895 = G__15245;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2717__auto__ = function(state_14895){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2717__auto____1.call(this,state_14895);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2717__auto____0;
fluree$db$query$range$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2717__auto____1;
return fluree$db$query$range$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_15091 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_15091[(6)] = c__2739__auto__);

return statearr_15091;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_15301){
var state_val_15302 = (state_15301[(1)]);
if((state_val_15302 === (7))){
var inst_15275 = (state_15301[(7)]);
var inst_15265 = (state_15301[(8)]);
var inst_15273 = fluree.db.flake.Flake__GT_parts(inst_15265);
var inst_15274 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15273,(0),null);
var inst_15275__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15273,(1),null);
var inst_15276 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15273,(2),null);
var inst_15277 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15273,(3),null);
var inst_15278 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15273,(4),null);
var inst_15279 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15273,(5),null);
var inst_15280 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_15276,inst_15275__$1);
var state_15301__$1 = (function (){var statearr_15303 = state_15301;
(statearr_15303[(9)] = inst_15277);

(statearr_15303[(7)] = inst_15275__$1);

(statearr_15303[(10)] = inst_15278);

(statearr_15303[(11)] = inst_15274);

(statearr_15303[(12)] = inst_15279);

return statearr_15303;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15301__$1,(10),inst_15280);
} else {
if((state_val_15302 === (1))){
var inst_15253 = flakes;
var inst_15254 = cljs.core.seq(inst_15253);
var inst_15255 = cljs.core.first(inst_15254);
var inst_15256 = cljs.core.next(inst_15254);
var inst_15257 = cljs.core.PersistentVector.EMPTY;
var inst_15258 = inst_15253;
var inst_15259 = inst_15257;
var state_15301__$1 = (function (){var statearr_15304 = state_15301;
(statearr_15304[(13)] = inst_15259);

(statearr_15304[(14)] = inst_15256);

(statearr_15304[(15)] = inst_15258);

(statearr_15304[(16)] = inst_15255);

return statearr_15304;
})();
var statearr_15305_15323 = state_15301__$1;
(statearr_15305_15323[(2)] = null);

(statearr_15305_15323[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15302 === (4))){
var inst_15265 = (state_15301[(8)]);
var inst_15268 = fluree.db.query.range.is_tag_flake_QMARK_(inst_15265);
var state_15301__$1 = state_15301;
if(inst_15268){
var statearr_15306_15324 = state_15301__$1;
(statearr_15306_15324[(1)] = (7));

} else {
var statearr_15307_15325 = state_15301__$1;
(statearr_15307_15325[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15302 === (6))){
var inst_15297 = (state_15301[(2)]);
var state_15301__$1 = state_15301;
var statearr_15308_15326 = state_15301__$1;
(statearr_15308_15326[(2)] = inst_15297);

(statearr_15308_15326[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15302 === (3))){
var inst_15299 = (state_15301[(2)]);
var state_15301__$1 = state_15301;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15301__$1,inst_15299);
} else {
if((state_val_15302 === (2))){
var inst_15258 = (state_15301[(15)]);
var inst_15265 = (state_15301[(8)]);
var inst_15264 = cljs.core.seq(inst_15258);
var inst_15265__$1 = cljs.core.first(inst_15264);
var inst_15266 = cljs.core.next(inst_15264);
var state_15301__$1 = (function (){var statearr_15309 = state_15301;
(statearr_15309[(8)] = inst_15265__$1);

(statearr_15309[(17)] = inst_15266);

return statearr_15309;
})();
if(cljs.core.truth_(inst_15265__$1)){
var statearr_15310_15327 = state_15301__$1;
(statearr_15310_15327[(1)] = (4));

} else {
var statearr_15311_15328 = state_15301__$1;
(statearr_15311_15328[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15302 === (9))){
var inst_15294 = (state_15301[(2)]);
var state_15301__$1 = state_15301;
var statearr_15312_15329 = state_15301__$1;
(statearr_15312_15329[(2)] = inst_15294);

(statearr_15312_15329[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15302 === (5))){
var inst_15259 = (state_15301[(13)]);
var state_15301__$1 = state_15301;
var statearr_15313_15330 = state_15301__$1;
(statearr_15313_15330[(2)] = inst_15259);

(statearr_15313_15330[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15302 === (10))){
var inst_15277 = (state_15301[(9)]);
var inst_15259 = (state_15301[(13)]);
var inst_15275 = (state_15301[(7)]);
var inst_15266 = (state_15301[(17)]);
var inst_15278 = (state_15301[(10)]);
var inst_15274 = (state_15301[(11)]);
var inst_15279 = (state_15301[(12)]);
var inst_15282 = (state_15301[(2)]);
var inst_15283 = fluree.db.util.async.throw_err(inst_15282);
var inst_15284 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15285 = [inst_15274,inst_15275,inst_15283,inst_15277,inst_15278,inst_15279];
var inst_15286 = (new cljs.core.PersistentVector(null,6,(5),inst_15284,inst_15285,null));
var inst_15287 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_15286);
var inst_15288 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_15259,inst_15287);
var inst_15258 = inst_15266;
var inst_15259__$1 = inst_15288;
var state_15301__$1 = (function (){var statearr_15314 = state_15301;
(statearr_15314[(13)] = inst_15259__$1);

(statearr_15314[(15)] = inst_15258);

return statearr_15314;
})();
var statearr_15315_15331 = state_15301__$1;
(statearr_15315_15331[(2)] = null);

(statearr_15315_15331[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15302 === (8))){
var inst_15259 = (state_15301[(13)]);
var inst_15265 = (state_15301[(8)]);
var inst_15266 = (state_15301[(17)]);
var inst_15291 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_15259,inst_15265);
var inst_15258 = inst_15266;
var inst_15259__$1 = inst_15291;
var state_15301__$1 = (function (){var statearr_15316 = state_15301;
(statearr_15316[(13)] = inst_15259__$1);

(statearr_15316[(15)] = inst_15258);

return statearr_15316;
})();
var statearr_15317_15332 = state_15301__$1;
(statearr_15317_15332[(2)] = null);

(statearr_15317_15332[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2717__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2717__auto____0 = (function (){
var statearr_15318 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15318[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2717__auto__);

(statearr_15318[(1)] = (1));

return statearr_15318;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2717__auto____1 = (function (state_15301){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_15301);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e15319){var ex__2720__auto__ = e15319;
var statearr_15320_15333 = state_15301;
(statearr_15320_15333[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_15301[(4)]))){
var statearr_15321_15334 = state_15301;
(statearr_15321_15334[(1)] = cljs.core.first((state_15301[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15335 = state_15301;
state_15301 = G__15335;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2717__auto__ = function(state_15301){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2717__auto____1.call(this,state_15301);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2717__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2717__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_15322 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_15322[(6)] = c__2739__auto__);

return statearr_15322;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__15337 = arguments.length;
switch (G__15337) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_15507){
var state_val_15508 = (state_15507[(1)]);
if((state_val_15508 === (65))){
var state_15507__$1 = state_15507;
var statearr_15509_15609 = state_15507__$1;
(statearr_15509_15609[(2)] = null);

(statearr_15509_15609[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (70))){
var inst_15502 = (state_15507[(2)]);
var _ = (function (){var statearr_15510 = state_15507;
(statearr_15510[(4)] = cljs.core.rest((state_15507[(4)])));

return statearr_15510;
})();
var state_15507__$1 = state_15507;
var statearr_15511_15610 = state_15507__$1;
(statearr_15511_15610[(2)] = inst_15502);

(statearr_15511_15610[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (62))){
var inst_15488 = (state_15507[(2)]);
var state_15507__$1 = state_15507;
var statearr_15512_15611 = state_15507__$1;
(statearr_15512_15611[(2)] = inst_15488);

(statearr_15512_15611[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (7))){
var state_15507__$1 = state_15507;
var statearr_15513_15612 = state_15507__$1;
(statearr_15513_15612[(2)] = false);

(statearr_15513_15612[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (59))){
var inst_15462 = (state_15507[(2)]);
var inst_15463 = fluree.db.util.async.throw_err(inst_15462);
var state_15507__$1 = state_15507;
var statearr_15514_15613 = state_15507__$1;
(statearr_15514_15613[(2)] = inst_15463);

(statearr_15514_15613[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (20))){
var state_15507__$1 = state_15507;
var statearr_15515_15614 = state_15507__$1;
(statearr_15515_15614[(2)] = null);

(statearr_15515_15614[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (58))){
var inst_15452 = (state_15507[(2)]);
var inst_15453 = fluree.db.util.async.throw_err(inst_15452);
var inst_15454 = cljs.core.take.cljs$core$IFn$_invoke$arity$2((1),inst_15453);
var state_15507__$1 = state_15507;
var statearr_15516_15615 = state_15507__$1;
(statearr_15516_15615[(2)] = inst_15454);

(statearr_15516_15615[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (60))){
var inst_15348 = (state_15507[(7)]);
var inst_15388 = (state_15507[(8)]);
var inst_15351 = (state_15507[(9)]);
var inst_15349 = (state_15507[(10)]);
var inst_15468 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15469 = [inst_15349,inst_15348,inst_15388,inst_15351];
var inst_15470 = (new cljs.core.PersistentVector(null,4,(5),inst_15468,inst_15469,null));
var inst_15471 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15470,opts);
var state_15507__$1 = state_15507;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15507__$1,(63),inst_15471);
} else {
if((state_val_15508 === (27))){
var inst_15388 = (state_15507[(8)]);
var inst_15399 = (state_15507[(11)]);
var inst_15399__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_15388);
var state_15507__$1 = (function (){var statearr_15517 = state_15507;
(statearr_15517[(11)] = inst_15399__$1);

return statearr_15517;
})();
if(inst_15399__$1){
var statearr_15518_15616 = state_15507__$1;
(statearr_15518_15616[(1)] = (30));

} else {
var statearr_15519_15617 = state_15507__$1;
(statearr_15519_15617[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (1))){
var state_15507__$1 = state_15507;
var statearr_15520_15618 = state_15507__$1;
(statearr_15520_15618[(2)] = null);

(statearr_15520_15618[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (69))){
var inst_15494 = (state_15507[(12)]);
var state_15507__$1 = state_15507;
var statearr_15521_15619 = state_15507__$1;
(statearr_15521_15619[(2)] = inst_15494);

(statearr_15521_15619[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (24))){
var inst_15349 = (state_15507[(10)]);
var state_15507__$1 = state_15507;
if(cljs.core.truth_(inst_15349)){
var statearr_15522_15620 = state_15507__$1;
(statearr_15522_15620[(1)] = (27));

} else {
var statearr_15523_15621 = state_15507__$1;
(statearr_15523_15621[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (55))){
var inst_15388 = (state_15507[(8)]);
var inst_15446 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15447 = [inst_15388];
var inst_15448 = (new cljs.core.PersistentVector(null,1,(5),inst_15446,inst_15447,null));
var inst_15449 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var inst_15450 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15448,inst_15449);
var state_15507__$1 = state_15507;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15507__$1,(58),inst_15450);
} else {
if((state_val_15508 === (39))){
var inst_15419 = (state_15507[(2)]);
var inst_15420 = fluree.db.util.async.throw_err(inst_15419);
var state_15507__$1 = state_15507;
var statearr_15524_15622 = state_15507__$1;
(statearr_15524_15622[(2)] = inst_15420);

(statearr_15524_15622[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (46))){
var inst_15432 = (state_15507[(13)]);
var inst_15432__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_15507__$1 = (function (){var statearr_15525 = state_15507;
(statearr_15525[(13)] = inst_15432__$1);

return statearr_15525;
})();
if(cljs.core.truth_(inst_15432__$1)){
var statearr_15526_15623 = state_15507__$1;
(statearr_15526_15623[(1)] = (49));

} else {
var statearr_15527_15624 = state_15507__$1;
(statearr_15527_15624[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (4))){
var inst_15338 = (state_15507[(2)]);
var state_15507__$1 = state_15507;
var statearr_15528_15625 = state_15507__$1;
(statearr_15528_15625[(2)] = inst_15338);

(statearr_15528_15625[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (54))){
var inst_15444 = (state_15507[(2)]);
var state_15507__$1 = state_15507;
if(cljs.core.truth_(inst_15444)){
var statearr_15529_15626 = state_15507__$1;
(statearr_15529_15626[(1)] = (55));

} else {
var statearr_15530_15627 = state_15507__$1;
(statearr_15530_15627[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (15))){
var inst_15350 = (state_15507[(14)]);
var inst_15369 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_15350);
var state_15507__$1 = state_15507;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15507__$1,(18),inst_15369);
} else {
if((state_val_15508 === (48))){
var inst_15490 = (state_15507[(2)]);
var state_15507__$1 = state_15507;
var statearr_15531_15628 = state_15507__$1;
(statearr_15531_15628[(2)] = inst_15490);

(statearr_15531_15628[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (50))){
var inst_15348 = (state_15507[(7)]);
var inst_15363 = (state_15507[(15)]);
var inst_15388 = (state_15507[(8)]);
var inst_15358 = (state_15507[(16)]);
var inst_15432 = (state_15507[(13)]);
var inst_15351 = (state_15507[(9)]);
var inst_15352 = (state_15507[(17)]);
var inst_15347 = (state_15507[(18)]);
var inst_15349 = (state_15507[(10)]);
var inst_15436 = (function (){var t = inst_15351;
var vec__15344 = inst_15347;
var p = inst_15349;
var idx_predicate_QMARK_ = inst_15352;
var o = inst_15388;
var tag_predicate_QMARK_ = inst_15358;
var temp__5751__auto__ = inst_15432;
var s = inst_15348;
var o_coerce_QMARK_ = inst_15363;
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
})();
var state_15507__$1 = state_15507;
var statearr_15532_15629 = state_15507__$1;
(statearr_15532_15629[(2)] = inst_15436);

(statearr_15532_15629[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (21))){
var inst_15384 = (state_15507[(2)]);
var state_15507__$1 = state_15507;
var statearr_15533_15630 = state_15507__$1;
(statearr_15533_15630[(2)] = inst_15384);

(statearr_15533_15630[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (31))){
var inst_15399 = (state_15507[(11)]);
var state_15507__$1 = state_15507;
var statearr_15534_15631 = state_15507__$1;
(statearr_15534_15631[(2)] = inst_15399);

(statearr_15534_15631[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (32))){
var inst_15409 = (state_15507[(2)]);
var state_15507__$1 = state_15507;
var statearr_15535_15632 = state_15507__$1;
(statearr_15535_15632[(2)] = inst_15409);

(statearr_15535_15632[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (40))){
var inst_15423 = (state_15507[(19)]);
var inst_15352 = (state_15507[(17)]);
var inst_15423__$1 = cljs.core.not(inst_15352);
var state_15507__$1 = (function (){var statearr_15536 = state_15507;
(statearr_15536[(19)] = inst_15423__$1);

return statearr_15536;
})();
if(inst_15423__$1){
var statearr_15537_15633 = state_15507__$1;
(statearr_15537_15633[(1)] = (43));

} else {
var statearr_15538_15634 = state_15507__$1;
(statearr_15538_15634[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (56))){
var inst_15348 = (state_15507[(7)]);
var inst_15438 = (state_15507[(20)]);
var inst_15351 = (state_15507[(9)]);
var inst_15349 = (state_15507[(10)]);
var inst_15456 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15457 = [inst_15349,inst_15348,null,inst_15351];
var inst_15458 = (new cljs.core.PersistentVector(null,4,(5),inst_15456,inst_15457,null));
var inst_15459 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_15438);
var inst_15460 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15458,inst_15459);
var state_15507__$1 = state_15507;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15507__$1,(59),inst_15460);
} else {
if((state_val_15508 === (33))){
var inst_15388 = (state_15507[(8)]);
var inst_15402 = cljs.core.fn_QMARK_(inst_15388);
var inst_15403 = (!(inst_15402));
var state_15507__$1 = state_15507;
var statearr_15539_15635 = state_15507__$1;
(statearr_15539_15635[(2)] = inst_15403);

(statearr_15539_15635[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (13))){
var inst_15350 = (state_15507[(14)]);
var inst_15367 = fluree.db.query.range.tag_string_QMARK_(inst_15350);
var state_15507__$1 = state_15507;
if(cljs.core.truth_(inst_15367)){
var statearr_15540_15636 = state_15507__$1;
(statearr_15540_15636[(1)] = (15));

} else {
var statearr_15541_15637 = state_15507__$1;
(statearr_15541_15637[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (22))){
var inst_15380 = (state_15507[(2)]);
var inst_15381 = fluree.db.util.async.throw_err(inst_15380);
var state_15507__$1 = state_15507;
var statearr_15542_15638 = state_15507__$1;
(statearr_15542_15638[(2)] = inst_15381);

(statearr_15542_15638[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (36))){
var inst_15348 = (state_15507[(7)]);
var inst_15388 = (state_15507[(8)]);
var inst_15351 = (state_15507[(9)]);
var inst_15349 = (state_15507[(10)]);
var inst_15414 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15415 = [inst_15349,inst_15388,inst_15348,inst_15351];
var inst_15416 = (new cljs.core.PersistentVector(null,4,(5),inst_15414,inst_15415,null));
var inst_15417 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_15416,opts);
var state_15507__$1 = state_15507;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15507__$1,(39),inst_15417);
} else {
if((state_val_15508 === (41))){
var inst_15349 = (state_15507[(10)]);
var state_15507__$1 = state_15507;
var statearr_15543_15639 = state_15507__$1;
(statearr_15543_15639[(2)] = inst_15349);

(statearr_15543_15639[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (43))){
var inst_15388 = (state_15507[(8)]);
var state_15507__$1 = state_15507;
var statearr_15544_15640 = state_15507__$1;
(statearr_15544_15640[(2)] = inst_15388);

(statearr_15544_15640[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (61))){
var inst_15388 = (state_15507[(8)]);
var state_15507__$1 = state_15507;
if(cljs.core.truth_(inst_15388)){
var statearr_15545_15641 = state_15507__$1;
(statearr_15545_15641[(1)] = (64));

} else {
var statearr_15546_15642 = state_15507__$1;
(statearr_15546_15642[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (29))){
var inst_15412 = (state_15507[(2)]);
var state_15507__$1 = state_15507;
if(cljs.core.truth_(inst_15412)){
var statearr_15547_15643 = state_15507__$1;
(statearr_15547_15643[(1)] = (36));

} else {
var statearr_15548_15644 = state_15507__$1;
(statearr_15548_15644[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (44))){
var inst_15423 = (state_15507[(19)]);
var state_15507__$1 = state_15507;
var statearr_15549_15645 = state_15507__$1;
(statearr_15549_15645[(2)] = inst_15423);

(statearr_15549_15645[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (6))){
var inst_15349 = (state_15507[(10)]);
var inst_15354 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"type","type",1174270348),inst_15349);
var inst_15355 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_15354);
var state_15507__$1 = state_15507;
var statearr_15550_15646 = state_15507__$1;
(statearr_15550_15646[(2)] = inst_15355);

(statearr_15550_15646[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (28))){
var inst_15349 = (state_15507[(10)]);
var state_15507__$1 = state_15507;
var statearr_15551_15647 = state_15507__$1;
(statearr_15551_15647[(2)] = inst_15349);

(statearr_15551_15647[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (64))){
var inst_15348 = (state_15507[(7)]);
var inst_15388 = (state_15507[(8)]);
var inst_15351 = (state_15507[(9)]);
var inst_15349 = (state_15507[(10)]);
var inst_15477 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15478 = [inst_15388,inst_15349,inst_15348,inst_15351];
var inst_15479 = (new cljs.core.PersistentVector(null,4,(5),inst_15477,inst_15478,null));
var inst_15480 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_15479,opts);
var state_15507__$1 = state_15507;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15507__$1,(67),inst_15480);
} else {
if((state_val_15508 === (51))){
var inst_15439 = (state_15507[(21)]);
var inst_15349 = (state_15507[(10)]);
var inst_15438 = (state_15507[(2)]);
var inst_15439__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_15349);
var state_15507__$1 = (function (){var statearr_15552 = state_15507;
(statearr_15552[(21)] = inst_15439__$1);

(statearr_15552[(20)] = inst_15438);

return statearr_15552;
})();
if(inst_15439__$1){
var statearr_15553_15648 = state_15507__$1;
(statearr_15553_15648[(1)] = (52));

} else {
var statearr_15554_15649 = state_15507__$1;
(statearr_15554_15649[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (25))){
var inst_15358 = (state_15507[(16)]);
var inst_15494 = (state_15507[(2)]);
var state_15507__$1 = (function (){var statearr_15555 = state_15507;
(statearr_15555[(12)] = inst_15494);

return statearr_15555;
})();
if(cljs.core.truth_(inst_15358)){
var statearr_15556_15650 = state_15507__$1;
(statearr_15556_15650[(1)] = (68));

} else {
var statearr_15557_15651 = state_15507__$1;
(statearr_15557_15651[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (34))){
var inst_15352 = (state_15507[(17)]);
var state_15507__$1 = state_15507;
var statearr_15558_15652 = state_15507__$1;
(statearr_15558_15652[(2)] = inst_15352);

(statearr_15558_15652[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (17))){
var inst_15386 = (state_15507[(2)]);
var state_15507__$1 = state_15507;
var statearr_15559_15653 = state_15507__$1;
(statearr_15559_15653[(2)] = inst_15386);

(statearr_15559_15653[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (3))){
var inst_15505 = (state_15507[(2)]);
var state_15507__$1 = state_15507;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15507__$1,inst_15505);
} else {
if((state_val_15508 === (12))){
var inst_15350 = (state_15507[(14)]);
var state_15507__$1 = state_15507;
var statearr_15560_15654 = state_15507__$1;
(statearr_15560_15654[(2)] = inst_15350);

(statearr_15560_15654[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (2))){
var inst_15347 = (state_15507[(18)]);
var inst_15349 = (state_15507[(10)]);
var _ = (function (){var statearr_15561 = state_15507;
(statearr_15561[(4)] = cljs.core.cons((5),(state_15507[(4)])));

return statearr_15561;
})();
var inst_15347__$1 = fparts;
var inst_15348 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15347__$1,(0),null);
var inst_15349__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15347__$1,(1),null);
var inst_15350 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15347__$1,(2),null);
var inst_15351 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15347__$1,(3),null);
var inst_15352 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_15349__$1);
var state_15507__$1 = (function (){var statearr_15562 = state_15507;
(statearr_15562[(7)] = inst_15348);

(statearr_15562[(14)] = inst_15350);

(statearr_15562[(9)] = inst_15351);

(statearr_15562[(17)] = inst_15352);

(statearr_15562[(18)] = inst_15347__$1);

(statearr_15562[(10)] = inst_15349__$1);

return statearr_15562;
})();
if(cljs.core.truth_(inst_15349__$1)){
var statearr_15563_15655 = state_15507__$1;
(statearr_15563_15655[(1)] = (6));

} else {
var statearr_15564_15656 = state_15507__$1;
(statearr_15564_15656[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (66))){
var inst_15486 = (state_15507[(2)]);
var state_15507__$1 = state_15507;
var statearr_15565_15657 = state_15507__$1;
(statearr_15565_15657[(2)] = inst_15486);

(statearr_15565_15657[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (23))){
var inst_15348 = (state_15507[(7)]);
var inst_15388 = (state_15507[(8)]);
var inst_15351 = (state_15507[(9)]);
var inst_15349 = (state_15507[(10)]);
var inst_15390 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15391 = [inst_15348,inst_15349,inst_15388,inst_15351];
var inst_15392 = (new cljs.core.PersistentVector(null,4,(5),inst_15390,inst_15391,null));
var inst_15393 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15392,opts);
var state_15507__$1 = state_15507;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15507__$1,(26),inst_15393);
} else {
if((state_val_15508 === (47))){
var inst_15349 = (state_15507[(10)]);
var state_15507__$1 = state_15507;
if(cljs.core.truth_(inst_15349)){
var statearr_15566_15658 = state_15507__$1;
(statearr_15566_15658[(1)] = (60));

} else {
var statearr_15567_15659 = state_15507__$1;
(statearr_15567_15659[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (35))){
var inst_15406 = (state_15507[(2)]);
var state_15507__$1 = state_15507;
var statearr_15568_15660 = state_15507__$1;
(statearr_15568_15660[(2)] = inst_15406);

(statearr_15568_15660[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (19))){
var inst_15350 = (state_15507[(14)]);
var inst_15349 = (state_15507[(10)]);
var inst_15376 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_15349);
var inst_15377 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15376),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15350)].join('');
var inst_15378 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_15377);
var state_15507__$1 = state_15507;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15507__$1,(22),inst_15378);
} else {
if((state_val_15508 === (57))){
var inst_15465 = (state_15507[(2)]);
var state_15507__$1 = state_15507;
var statearr_15569_15661 = state_15507__$1;
(statearr_15569_15661[(2)] = inst_15465);

(statearr_15569_15661[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (68))){
var inst_15494 = (state_15507[(12)]);
var inst_15496 = fluree.db.query.range.coerce_tag_flakes(db,inst_15494);
var state_15507__$1 = state_15507;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15507__$1,(71),inst_15496);
} else {
if((state_val_15508 === (11))){
var inst_15363 = (state_15507[(15)]);
var inst_15363__$1 = (state_15507[(2)]);
var inst_15364 = cljs.core.not(inst_15363__$1);
var state_15507__$1 = (function (){var statearr_15571 = state_15507;
(statearr_15571[(15)] = inst_15363__$1);

return statearr_15571;
})();
if(inst_15364){
var statearr_15572_15662 = state_15507__$1;
(statearr_15572_15662[(1)] = (12));

} else {
var statearr_15573_15663 = state_15507__$1;
(statearr_15573_15663[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (9))){
var inst_15350 = (state_15507[(14)]);
var inst_15360 = typeof inst_15350 === 'string';
var state_15507__$1 = state_15507;
var statearr_15574_15664 = state_15507__$1;
(statearr_15574_15664[(2)] = inst_15360);

(statearr_15574_15664[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (5))){
var _ = (function (){var statearr_15575 = state_15507;
(statearr_15575[(4)] = cljs.core.rest((state_15507[(4)])));

return statearr_15575;
})();
var state_15507__$1 = state_15507;
var ex15570 = (state_15507__$1[(2)]);
var statearr_15576_15665 = state_15507__$1;
(statearr_15576_15665[(5)] = ex15570);


if((ex15570 instanceof Error)){
var statearr_15577_15666 = state_15507__$1;
(statearr_15577_15666[(1)] = (4));

(statearr_15577_15666[(5)] = null);

} else {
throw ex15570;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (14))){
var inst_15348 = (state_15507[(7)]);
var inst_15388 = (state_15507[(2)]);
var state_15507__$1 = (function (){var statearr_15578 = state_15507;
(statearr_15578[(8)] = inst_15388);

return statearr_15578;
})();
if(cljs.core.truth_(inst_15348)){
var statearr_15579_15667 = state_15507__$1;
(statearr_15579_15667[(1)] = (23));

} else {
var statearr_15580_15668 = state_15507__$1;
(statearr_15580_15668[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (45))){
var inst_15427 = (state_15507[(2)]);
var state_15507__$1 = state_15507;
var statearr_15581_15669 = state_15507__$1;
(statearr_15581_15669[(2)] = inst_15427);

(statearr_15581_15669[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (53))){
var inst_15439 = (state_15507[(21)]);
var state_15507__$1 = state_15507;
var statearr_15582_15670 = state_15507__$1;
(statearr_15582_15670[(2)] = inst_15439);

(statearr_15582_15670[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (26))){
var inst_15395 = (state_15507[(2)]);
var inst_15396 = fluree.db.util.async.throw_err(inst_15395);
var state_15507__$1 = state_15507;
var statearr_15583_15671 = state_15507__$1;
(statearr_15583_15671[(2)] = inst_15396);

(statearr_15583_15671[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (16))){
var inst_15350 = (state_15507[(14)]);
var inst_15374 = typeof inst_15350 === 'string';
var state_15507__$1 = state_15507;
if(cljs.core.truth_(inst_15374)){
var statearr_15584_15672 = state_15507__$1;
(statearr_15584_15672[(1)] = (19));

} else {
var statearr_15585_15673 = state_15507__$1;
(statearr_15585_15673[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (38))){
var inst_15492 = (state_15507[(2)]);
var state_15507__$1 = state_15507;
var statearr_15586_15674 = state_15507__$1;
(statearr_15586_15674[(2)] = inst_15492);

(statearr_15586_15674[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (30))){
var inst_15352 = (state_15507[(17)]);
var state_15507__$1 = state_15507;
if(cljs.core.truth_(inst_15352)){
var statearr_15587_15675 = state_15507__$1;
(statearr_15587_15675[(1)] = (33));

} else {
var statearr_15588_15676 = state_15507__$1;
(statearr_15588_15676[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (10))){
var inst_15358 = (state_15507[(16)]);
var state_15507__$1 = state_15507;
var statearr_15589_15677 = state_15507__$1;
(statearr_15589_15677[(2)] = inst_15358);

(statearr_15589_15677[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (18))){
var inst_15371 = (state_15507[(2)]);
var inst_15372 = fluree.db.util.async.throw_err(inst_15371);
var state_15507__$1 = state_15507;
var statearr_15590_15678 = state_15507__$1;
(statearr_15590_15678[(2)] = inst_15372);

(statearr_15590_15678[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (52))){
var inst_15388 = (state_15507[(8)]);
var inst_15441 = cljs.core.int_QMARK_(inst_15388);
var state_15507__$1 = state_15507;
var statearr_15591_15679 = state_15507__$1;
(statearr_15591_15679[(2)] = inst_15441);

(statearr_15591_15679[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (67))){
var inst_15482 = (state_15507[(2)]);
var inst_15483 = fluree.db.util.async.throw_err(inst_15482);
var state_15507__$1 = state_15507;
var statearr_15592_15680 = state_15507__$1;
(statearr_15592_15680[(2)] = inst_15483);

(statearr_15592_15680[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (71))){
var inst_15498 = (state_15507[(2)]);
var inst_15499 = fluree.db.util.async.throw_err(inst_15498);
var state_15507__$1 = state_15507;
var statearr_15593_15681 = state_15507__$1;
(statearr_15593_15681[(2)] = inst_15499);

(statearr_15593_15681[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (42))){
var inst_15430 = (state_15507[(2)]);
var state_15507__$1 = state_15507;
if(cljs.core.truth_(inst_15430)){
var statearr_15594_15682 = state_15507__$1;
(statearr_15594_15682[(1)] = (46));

} else {
var statearr_15595_15683 = state_15507__$1;
(statearr_15595_15683[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (37))){
var inst_15349 = (state_15507[(10)]);
var state_15507__$1 = state_15507;
if(cljs.core.truth_(inst_15349)){
var statearr_15596_15684 = state_15507__$1;
(statearr_15596_15684[(1)] = (40));

} else {
var statearr_15597_15685 = state_15507__$1;
(statearr_15597_15685[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (63))){
var inst_15473 = (state_15507[(2)]);
var inst_15474 = fluree.db.util.async.throw_err(inst_15473);
var state_15507__$1 = state_15507;
var statearr_15598_15686 = state_15507__$1;
(statearr_15598_15686[(2)] = inst_15474);

(statearr_15598_15686[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (8))){
var inst_15358 = (state_15507[(16)]);
var inst_15358__$1 = (state_15507[(2)]);
var state_15507__$1 = (function (){var statearr_15599 = state_15507;
(statearr_15599[(16)] = inst_15358__$1);

return statearr_15599;
})();
if(cljs.core.truth_(inst_15358__$1)){
var statearr_15600_15687 = state_15507__$1;
(statearr_15600_15687[(1)] = (9));

} else {
var statearr_15601_15688 = state_15507__$1;
(statearr_15601_15688[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15508 === (49))){
var inst_15348 = (state_15507[(7)]);
var inst_15363 = (state_15507[(15)]);
var inst_15388 = (state_15507[(8)]);
var inst_15358 = (state_15507[(16)]);
var inst_15432 = (state_15507[(13)]);
var inst_15351 = (state_15507[(9)]);
var inst_15352 = (state_15507[(17)]);
var inst_15347 = (state_15507[(18)]);
var inst_15349 = (state_15507[(10)]);
var inst_15434 = (function (){var obj_fn = inst_15432;
var t = inst_15351;
var vec__15344 = inst_15347;
var p = inst_15349;
var idx_predicate_QMARK_ = inst_15352;
var o = inst_15388;
var tag_predicate_QMARK_ = inst_15358;
var temp__5751__auto__ = inst_15432;
var s = inst_15348;
var o_coerce_QMARK_ = inst_15363;
return (function (x){
var and__4210__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__4210__auto__;
}
});
})();
var state_15507__$1 = state_15507;
var statearr_15602_15689 = state_15507__$1;
(statearr_15602_15689[(2)] = inst_15434);

(statearr_15602_15689[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2717__auto__ = null;
var fluree$db$query$range$state_machine__2717__auto____0 = (function (){
var statearr_15603 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15603[(0)] = fluree$db$query$range$state_machine__2717__auto__);

(statearr_15603[(1)] = (1));

return statearr_15603;
});
var fluree$db$query$range$state_machine__2717__auto____1 = (function (state_15507){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_15507);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e15604){var ex__2720__auto__ = e15604;
var statearr_15605_15690 = state_15507;
(statearr_15605_15690[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_15507[(4)]))){
var statearr_15606_15691 = state_15507;
(statearr_15606_15691[(1)] = cljs.core.first((state_15507[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15692 = state_15507;
state_15507 = G__15692;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2717__auto__ = function(state_15507){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2717__auto____1.call(this,state_15507);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2717__auto____0;
fluree$db$query$range$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2717__auto____1;
return fluree$db$query$range$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_15607 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_15607[(6)] = c__2739__auto__);

return statearr_15607;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__15694 = arguments.length;
switch (G__15694) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_15729){
var state_val_15730 = (state_15729[(1)]);
if((state_val_15730 === (7))){
var inst_15716 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_15717 = ["Invalid collection name: ",inst_15716].join('');
var inst_15718 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15719 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_15720 = cljs.core.PersistentHashMap.fromArrays(inst_15718,inst_15719);
var inst_15721 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_15717,inst_15720);
var inst_15722 = (function(){throw inst_15721})();
var state_15729__$1 = state_15729;
var statearr_15731_15751 = state_15729__$1;
(statearr_15731_15751[(2)] = inst_15722);

(statearr_15731_15751[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15730 === (1))){
var state_15729__$1 = state_15729;
var statearr_15732_15752 = state_15729__$1;
(statearr_15732_15752[(2)] = null);

(statearr_15732_15752[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15730 === (4))){
var inst_15695 = (state_15729[(2)]);
var state_15729__$1 = state_15729;
var statearr_15733_15753 = state_15729__$1;
(statearr_15733_15753[(2)] = inst_15695);

(statearr_15733_15753[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15730 === (6))){
var inst_15701 = (state_15729[(7)]);
var inst_15703 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15704 = fluree.db.flake.max_subject_id(inst_15701);
var inst_15705 = [inst_15704];
var inst_15706 = (new cljs.core.PersistentVector(null,1,(5),inst_15703,inst_15705,null));
var inst_15707 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15708 = fluree.db.flake.min_subject_id(inst_15701);
var inst_15709 = [inst_15708];
var inst_15710 = (new cljs.core.PersistentVector(null,1,(5),inst_15707,inst_15709,null));
var inst_15711 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_15706,cljs.core._LT__EQ_,inst_15710,opts);
var state_15729__$1 = state_15729;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15729__$1,(9),inst_15711);
} else {
if((state_val_15730 === (3))){
var inst_15727 = (state_15729[(2)]);
var state_15729__$1 = state_15729;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15729__$1,inst_15727);
} else {
if((state_val_15730 === (2))){
var inst_15701 = (state_15729[(7)]);
var _ = (function (){var statearr_15735 = state_15729;
(statearr_15735[(4)] = cljs.core.cons((5),(state_15729[(4)])));

return statearr_15735;
})();
var inst_15701__$1 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"partition","partition",1174740751),name);
var state_15729__$1 = (function (){var statearr_15736 = state_15729;
(statearr_15736[(7)] = inst_15701__$1);

return statearr_15736;
})();
if(cljs.core.truth_(inst_15701__$1)){
var statearr_15737_15754 = state_15729__$1;
(statearr_15737_15754[(1)] = (6));

} else {
var statearr_15738_15755 = state_15729__$1;
(statearr_15738_15755[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15730 === (9))){
var inst_15713 = (state_15729[(2)]);
var inst_15714 = fluree.db.util.async.throw_err(inst_15713);
var state_15729__$1 = state_15729;
var statearr_15739_15756 = state_15729__$1;
(statearr_15739_15756[(2)] = inst_15714);

(statearr_15739_15756[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15730 === (5))){
var _ = (function (){var statearr_15740 = state_15729;
(statearr_15740[(4)] = cljs.core.rest((state_15729[(4)])));

return statearr_15740;
})();
var state_15729__$1 = state_15729;
var ex15734 = (state_15729__$1[(2)]);
var statearr_15741_15757 = state_15729__$1;
(statearr_15741_15757[(5)] = ex15734);


var statearr_15742_15758 = state_15729__$1;
(statearr_15742_15758[(1)] = (4));

(statearr_15742_15758[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15730 === (8))){
var inst_15724 = (state_15729[(2)]);
var _ = (function (){var statearr_15743 = state_15729;
(statearr_15743[(4)] = cljs.core.rest((state_15729[(4)])));

return statearr_15743;
})();
var state_15729__$1 = state_15729;
var statearr_15744_15759 = state_15729__$1;
(statearr_15744_15759[(2)] = inst_15724);

(statearr_15744_15759[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2717__auto__ = null;
var fluree$db$query$range$state_machine__2717__auto____0 = (function (){
var statearr_15745 = [null,null,null,null,null,null,null,null];
(statearr_15745[(0)] = fluree$db$query$range$state_machine__2717__auto__);

(statearr_15745[(1)] = (1));

return statearr_15745;
});
var fluree$db$query$range$state_machine__2717__auto____1 = (function (state_15729){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_15729);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e15746){var ex__2720__auto__ = e15746;
var statearr_15747_15760 = state_15729;
(statearr_15747_15760[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_15729[(4)]))){
var statearr_15748_15761 = state_15729;
(statearr_15748_15761[(1)] = cljs.core.first((state_15729[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15762 = state_15729;
state_15729 = G__15762;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2717__auto__ = function(state_15729){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2717__auto____1.call(this,state_15729);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2717__auto____0;
fluree$db$query$range$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2717__auto____1;
return fluree$db$query$range$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_15749 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_15749[(6)] = c__2739__auto__);

return statearr_15749;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__15766 = flakes;
var vec__15767 = G__15766;
var seq__15768 = cljs.core.seq(vec__15767);
var first__15769 = cljs.core.first(seq__15768);
var seq__15768__$1 = cljs.core.next(seq__15768);
var flake_SINGLEQUOTE_ = first__15769;
var r = seq__15768__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15766__$1 = G__15766;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15775 = G__15766__$1;
var seq__15776 = cljs.core.seq(vec__15775);
var first__15777 = cljs.core.first(seq__15776);
var seq__15776__$1 = cljs.core.next(seq__15776);
var flake_SINGLEQUOTE___$1 = first__15777;
var r__$1 = seq__15776__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e15779){var e = e15779;
return null;
}})();
var map__15778 = cmd_map;
var map__15778__$1 = cljs.core.__destructure_map(map__15778);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15778__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15778__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15778__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15778__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15778__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15778__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__15780 = r__$1;
var G__15781 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__15766__$1 = G__15780;
result_STAR___$1 = G__15781;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__15790 = blocks;
var vec__15791 = G__15790;
var seq__15792 = cljs.core.seq(vec__15791);
var first__15793 = cljs.core.first(seq__15792);
var seq__15792__$1 = cljs.core.next(seq__15792);
var block_SINGLEQUOTE_ = first__15793;
var r = seq__15792__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15790__$1 = G__15790;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15798 = G__15790__$1;
var seq__15799 = cljs.core.seq(vec__15798);
var first__15800 = cljs.core.first(seq__15799);
var seq__15799__$1 = cljs.core.next(seq__15799);
var block_SINGLEQUOTE___$1 = first__15800;
var r__$1 = seq__15799__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__15801 = block_SINGLEQUOTE___$1;
var map__15801__$1 = cljs.core.__destructure_map(map__15801);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15801__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15801__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15801__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some(((function (G__15790__$1,result_STAR___$1,map__15801,map__15801__$1,block,t,flakes,vec__15798,seq__15799,first__15800,seq__15799__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15790,vec__15791,seq__15792,first__15793,seq__15792__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15782_SHARP_){
var f = p1__15782_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(2))){
return f.o;
} else {
return null;
}
});})(G__15790__$1,result_STAR___$1,map__15801,map__15801__$1,block,t,flakes,vec__15798,seq__15799,first__15800,seq__15799__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15790,vec__15791,seq__15792,first__15793,seq__15792__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__15790__$1,result_STAR___$1,map__15801,map__15801__$1,block,t,flakes,prev_hash,vec__15798,seq__15799,first__15800,seq__15799__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15790,vec__15791,seq__15792,first__15793,seq__15792__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15783_SHARP_){
var f = p1__15783_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(1))){
return f.o;
} else {
return null;
}
});})(G__15790__$1,result_STAR___$1,map__15801,map__15801__$1,block,t,flakes,prev_hash,vec__15798,seq__15799,first__15800,seq__15799__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15790,vec__15791,seq__15792,first__15793,seq__15792__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__15790__$1,result_STAR___$1,map__15801,map__15801__$1,block,t,flakes,prev_hash,hash,vec__15798,seq__15799,first__15800,seq__15799__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15790,vec__15791,seq__15792,first__15793,seq__15792__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15784_SHARP_){
var f = p1__15784_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(5))){
return f.o;
} else {
return null;
}
});})(G__15790__$1,result_STAR___$1,map__15801,map__15801__$1,block,t,flakes,prev_hash,hash,vec__15798,seq__15799,first__15800,seq__15799__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15790,vec__15791,seq__15792,first__15793,seq__15792__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__15790__$1,result_STAR___$1,map__15801,map__15801__$1,block,t,flakes,prev_hash,hash,instant,vec__15798,seq__15799,first__15800,seq__15799__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15790,vec__15791,seq__15792,first__15793,seq__15792__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15785_SHARP_){
var f = p1__15785_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(7))){
return f.o;
} else {
return null;
}
});})(G__15790__$1,result_STAR___$1,map__15801,map__15801__$1,block,t,flakes,prev_hash,hash,instant,vec__15798,seq__15799,first__15800,seq__15799__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15790,vec__15791,seq__15792,first__15793,seq__15792__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__15790__$1,result_STAR___$1,map__15801,map__15801__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15798,seq__15799,first__15800,seq__15799__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15790,vec__15791,seq__15792,first__15793,seq__15792__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15786_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__15786_SHARP_.p,(106));
});})(G__15790__$1,result_STAR___$1,map__15801,map__15801__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15798,seq__15799,first__15800,seq__15799__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15790,vec__15791,seq__15792,first__15793,seq__15792__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__15802 = r__$1;
var G__15803 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__15790__$1 = G__15802;
result_STAR___$1 = G__15803;
continue;
}
break;
}
});
