// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql.vswap_BANG_ = (function fluree$db$query$fql$vswap_BANG_(var_args){
var G__22125 = arguments.length;
switch (G__22125) {
case 2:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_(vol,(function (){var G__22126 = cljs.core._deref(vol);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__22126) : f.call(null,G__22126));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_(vol,(function (){var G__22127 = cljs.core._deref(vol);
var G__22128 = arg1;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__22127,G__22128) : f.call(null,G__22127,G__22128));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_(vol,(function (){var G__22129 = cljs.core._deref(vol);
var G__22130 = arg1;
var G__22131 = arg2;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__22129,G__22130,G__22131) : f.call(null,G__22129,G__22130,G__22131));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_(vol,(function (){var G__22132 = cljs.core._deref(vol);
var G__22133 = arg1;
var G__22134 = arg2;
var G__22135 = arg3;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__22132,G__22133,G__22134,G__22135) : f.call(null,G__22132,G__22133,G__22134,G__22135));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__22138 = arguments.length;
switch (G__22138) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__22140 = null;
var G__22140__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__22140__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__22140__2 = (function (result,flake){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__4210__auto__ = max_fuel;
if(cljs.core.truth_(and__4210__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4210__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__22140 = function(result,flake){
switch(arguments.length){
case 0:
return G__22140__0.call(this);
case 1:
return G__22140__1.call(this,result);
case 2:
return G__22140__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22140.cljs$core$IFn$_invoke$arity$0 = G__22140__0;
G__22140.cljs$core$IFn$_invoke$arity$1 = G__22140__1;
G__22140.cljs$core$IFn$_invoke$arity$2 = G__22140__2;
return G__22140;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__22141 = null;
var G__22141__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__22141__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__22141__2 = (function (result,flakes){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,cljs.core.count(flakes));

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flakes) : xf.call(null,result,flakes));
});
G__22141 = function(result,flakes){
switch(arguments.length){
case 0:
return G__22141__0.call(this);
case 1:
return G__22141__1.call(this,result);
case 2:
return G__22141__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22141.cljs$core$IFn$_invoke$arity$0 = G__22141__0;
G__22141.cljs$core$IFn$_invoke$arity$1 = G__22141__1;
G__22141.cljs$core$IFn$_invoke$arity$2 = G__22141__2;
return G__22141;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,n);

if(cljs.core.truth_((function (){var and__4210__auto__ = max_fuel;
if(cljs.core.truth_(and__4210__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4210__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4212__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map);

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__22143 = res;
var G__22143__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__22142_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__22142_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__22143):G__22143);
var G__22143__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__22143__$1):G__22143__$1);
var G__22143__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__22143__$2):G__22143__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__22143__$3);
} else {
return G__22143__$3;
}
} else {
return res;
}
});
/**
 * Adds a predicate to a select spec graph crawl. flakes input is a list of flakes
 *   all with the same subject and predicate values.
 */
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__22147 = arguments.length;
switch (G__22147) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_22586){
var state_val_22587 = (state_22586[(1)]);
if((state_val_22587 === (121))){
var inst_22509 = (state_22586[(2)]);
var inst_22510 = fluree.db.util.async.throw_err(inst_22509);
var inst_22511 = cljs.core.seq(inst_22510);
var state_22586__$1 = state_22586;
if(inst_22511){
var statearr_22588_22802 = state_22586__$1;
(statearr_22588_22802[(1)] = (122));

} else {
var statearr_22589_22803 = state_22586__$1;
(statearr_22589_22803[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (65))){
var inst_22302 = (state_22586[(7)]);
var inst_22301 = (state_22586[(2)]);
var inst_22302__$1 = fluree.db.util.async.throw_err(inst_22301);
var inst_22303 = cljs.core.seq(inst_22302__$1);
var state_22586__$1 = (function (){var statearr_22590 = state_22586;
(statearr_22590[(7)] = inst_22302__$1);

return statearr_22590;
})();
if(inst_22303){
var statearr_22591_22804 = state_22586__$1;
(statearr_22591_22804[(1)] = (66));

} else {
var statearr_22592_22805 = state_22586__$1;
(statearr_22592_22805[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (70))){
var inst_22302 = (state_22586[(7)]);
var inst_22313 = cljs.core.count(inst_22302);
var inst_22314 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_22313);
var state_22586__$1 = state_22586;
var statearr_22593_22806 = state_22586__$1;
(statearr_22593_22806[(2)] = inst_22314);

(statearr_22593_22806[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (62))){
var inst_22292 = (state_22586[(8)]);
var inst_22295 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22296 = inst_22292.o;
var inst_22297 = [inst_22296];
var inst_22298 = (new cljs.core.PersistentVector(null,1,(5),inst_22295,inst_22297,null));
var inst_22299 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22298);
var state_22586__$1 = state_22586;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22586__$1,(65),inst_22299);
} else {
if((state_val_22587 === (74))){
var inst_22286 = (state_22586[(9)]);
var state_22586__$1 = state_22586;
var statearr_22594_22807 = state_22586__$1;
(statearr_22594_22807[(2)] = inst_22286);

(statearr_22594_22807[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (110))){
var inst_22471 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_22472 = new cljs.core.Keyword(null,"root?","root?",-2045639518).cljs$core$IFn$_invoke$arity$1(inst_22471);
var inst_22473 = inst_22472 === true;
var state_22586__$1 = state_22586;
if(cljs.core.truth_(inst_22473)){
var statearr_22595_22808 = state_22586__$1;
(statearr_22595_22808[(1)] = (113));

} else {
var statearr_22596_22809 = state_22586__$1;
(statearr_22596_22809[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (130))){
var inst_22581 = (state_22586[(2)]);
var _ = (function (){var statearr_22597 = state_22586;
(statearr_22597[(4)] = cljs.core.rest((state_22586[(4)])));

return statearr_22597;
})();
var state_22586__$1 = state_22586;
var statearr_22598_22810 = state_22586__$1;
(statearr_22598_22810[(2)] = inst_22581);

(statearr_22598_22810[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (128))){
var inst_22556 = (state_22586[(10)]);
var inst_22559 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22560 = [acc,inst_22556];
var inst_22561 = (new cljs.core.PersistentVector(null,2,(5),inst_22559,inst_22560,null));
var state_22586__$1 = state_22586;
var statearr_22599_22811 = state_22586__$1;
(statearr_22599_22811[(2)] = inst_22561);

(statearr_22599_22811[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (7))){
var inst_22159 = (state_22586[(11)]);
var state_22586__$1 = state_22586;
var statearr_22600_22812 = state_22586__$1;
(statearr_22600_22812[(2)] = inst_22159);

(statearr_22600_22812[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (59))){
var inst_22550 = (state_22586[(2)]);
var state_22586__$1 = state_22586;
var statearr_22601_22813 = state_22586__$1;
(statearr_22601_22813[(2)] = inst_22550);

(statearr_22601_22813[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (86))){
var inst_22380 = (state_22586[(12)]);
var inst_22380__$1 = (state_22586[(2)]);
var state_22586__$1 = (function (){var statearr_22602 = state_22586;
(statearr_22602[(12)] = inst_22380__$1);

return statearr_22602;
})();
if(cljs.core.truth_(inst_22380__$1)){
var statearr_22603_22814 = state_22586__$1;
(statearr_22603_22814[(1)] = (88));

} else {
var statearr_22604_22815 = state_22586__$1;
(statearr_22604_22815[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (20))){
var inst_22200 = (state_22586[(13)]);
var inst_22188 = (state_22586[(14)]);
var inst_22201 = (state_22586[(15)]);
var inst_22199 = (state_22586[(2)]);
var inst_22200__$1 = cljs.core.__destructure_map(inst_22188);
var inst_22201__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22200__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_22202 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22200__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_22203 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22200__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22204 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22200__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_22205 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22200__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_22206 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22200__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_22586__$1 = (function (){var statearr_22605 = state_22586;
(statearr_22605[(16)] = inst_22206);

(statearr_22605[(17)] = inst_22204);

(statearr_22605[(18)] = inst_22203);

(statearr_22605[(19)] = inst_22202);

(statearr_22605[(20)] = inst_22205);

(statearr_22605[(13)] = inst_22200__$1);

(statearr_22605[(21)] = inst_22199);

(statearr_22605[(15)] = inst_22201__$1);

return statearr_22605;
})();
if(cljs.core.truth_(inst_22201__$1)){
var statearr_22606_22816 = state_22586__$1;
(statearr_22606_22816[(1)] = (24));

} else {
var statearr_22607_22817 = state_22586__$1;
(statearr_22607_22817[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (72))){
var inst_22311 = (state_22586[(22)]);
var inst_22317 = (state_22586[(2)]);
var inst_22318 = cljs.core.seq(inst_22311);
var state_22586__$1 = (function (){var statearr_22608 = state_22586;
(statearr_22608[(23)] = inst_22317);

return statearr_22608;
})();
if(inst_22318){
var statearr_22609_22818 = state_22586__$1;
(statearr_22609_22818[(1)] = (73));

} else {
var statearr_22610_22819 = state_22586__$1;
(statearr_22610_22819[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (58))){
var inst_22188 = (state_22586[(14)]);
var inst_22333 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_22188);
var state_22586__$1 = state_22586;
if(cljs.core.truth_(inst_22333)){
var statearr_22611_22820 = state_22586__$1;
(statearr_22611_22820[(1)] = (76));

} else {
var statearr_22612_22821 = state_22586__$1;
(statearr_22612_22821[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (60))){
var inst_22285 = (state_22586[(24)]);
var inst_22292 = (state_22586[(8)]);
var inst_22291 = cljs.core.seq(inst_22285);
var inst_22292__$1 = cljs.core.first(inst_22291);
var inst_22293 = cljs.core.next(inst_22291);
var state_22586__$1 = (function (){var statearr_22613 = state_22586;
(statearr_22613[(25)] = inst_22293);

(statearr_22613[(8)] = inst_22292__$1);

return statearr_22613;
})();
if(cljs.core.truth_(inst_22292__$1)){
var statearr_22614_22822 = state_22586__$1;
(statearr_22614_22822[(1)] = (62));

} else {
var statearr_22615_22823 = state_22586__$1;
(statearr_22615_22823[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (27))){
var inst_22209 = (state_22586[(26)]);
var inst_22205 = (state_22586[(20)]);
var inst_22209__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_22205);
var state_22586__$1 = (function (){var statearr_22616 = state_22586;
(statearr_22616[(26)] = inst_22209__$1);

return statearr_22616;
})();
if(inst_22209__$1){
var statearr_22617_22824 = state_22586__$1;
(statearr_22617_22824[(1)] = (30));

} else {
var statearr_22618_22825 = state_22586__$1;
(statearr_22618_22825[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (1))){
var state_22586__$1 = state_22586;
var statearr_22619_22826 = state_22586__$1;
(statearr_22619_22826[(2)] = null);

(statearr_22619_22826[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (69))){
var inst_22307 = (state_22586[(2)]);
var inst_22308 = fluree.db.util.async.throw_err(inst_22307);
var state_22586__$1 = state_22586;
var statearr_22620_22827 = state_22586__$1;
(statearr_22620_22827[(2)] = inst_22308);

(statearr_22620_22827[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (101))){
var inst_22464 = (state_22586[(2)]);
var state_22586__$1 = state_22586;
var statearr_22621_22828 = state_22586__$1;
(statearr_22621_22828[(2)] = inst_22464);

(statearr_22621_22828[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (24))){
var inst_22205 = (state_22586[(20)]);
var state_22586__$1 = state_22586;
if(cljs.core.truth_(inst_22205)){
var statearr_22622_22829 = state_22586__$1;
(statearr_22622_22829[(1)] = (27));

} else {
var statearr_22623_22830 = state_22586__$1;
(statearr_22623_22830[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (102))){
var inst_22436 = (state_22586[(27)]);
var inst_22435 = (state_22586[(2)]);
var inst_22436__$1 = fluree.db.util.async.throw_err(inst_22435);
var inst_22437 = cljs.core.empty_QMARK_(inst_22436__$1);
var state_22586__$1 = (function (){var statearr_22624 = state_22586;
(statearr_22624[(27)] = inst_22436__$1);

return statearr_22624;
})();
if(inst_22437){
var statearr_22625_22831 = state_22586__$1;
(statearr_22625_22831[(1)] = (103));

} else {
var statearr_22626_22832 = state_22586__$1;
(statearr_22626_22832[(1)] = (104));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (135))){
var state_22586__$1 = state_22586;
var statearr_22627_22833 = state_22586__$1;
(statearr_22627_22833[(2)] = null);

(statearr_22627_22833[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (55))){
var inst_22188 = (state_22586[(14)]);
var inst_22261 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_22188);
var state_22586__$1 = state_22586;
var statearr_22628_22834 = state_22586__$1;
(statearr_22628_22834[(2)] = inst_22261);

(statearr_22628_22834[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (85))){
var inst_22355 = (state_22586[(28)]);
var inst_22188 = (state_22586[(14)]);
var inst_22367 = inst_22355.o;
var inst_22368 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22188);
var inst_22369 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_22367,inst_22368);
var state_22586__$1 = state_22586;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22586__$1,(87),inst_22369);
} else {
if((state_val_22587 === (39))){
var inst_22204 = (state_22586[(17)]);
var inst_22236 = (state_22586[(29)]);
var inst_22236__$1 = cljs.core.not(inst_22204);
var state_22586__$1 = (function (){var statearr_22629 = state_22586;
(statearr_22629[(29)] = inst_22236__$1);

return statearr_22629;
})();
if(inst_22236__$1){
var statearr_22630_22835 = state_22586__$1;
(statearr_22630_22835[(1)] = (42));

} else {
var statearr_22631_22836 = state_22586__$1;
(statearr_22631_22836[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (88))){
var inst_22380 = (state_22586[(12)]);
var inst_22349 = (state_22586[(30)]);
var inst_22382 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22349,inst_22380);
var state_22586__$1 = state_22586;
var statearr_22632_22837 = state_22586__$1;
(statearr_22632_22837[(2)] = inst_22382);

(statearr_22632_22837[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (46))){
var inst_22203 = (state_22586[(18)]);
var state_22586__$1 = state_22586;
var statearr_22633_22838 = state_22586__$1;
(statearr_22633_22838[(2)] = inst_22203);

(statearr_22633_22838[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (4))){
var inst_22148 = (state_22586[(2)]);
var state_22586__$1 = state_22586;
var statearr_22634_22839 = state_22586__$1;
(statearr_22634_22839[(2)] = inst_22148);

(statearr_22634_22839[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (77))){
var inst_22395 = (state_22586[(31)]);
var inst_22395__$1 = componentFollow_QMARK_;
var state_22586__$1 = (function (){var statearr_22635 = state_22586;
(statearr_22635[(31)] = inst_22395__$1);

return statearr_22635;
})();
if(cljs.core.truth_(inst_22395__$1)){
var statearr_22636_22840 = state_22586__$1;
(statearr_22636_22840[(1)] = (91));

} else {
var statearr_22637_22841 = state_22586__$1;
(statearr_22637_22841[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (106))){
var inst_22416 = (state_22586[(32)]);
var inst_22450 = (state_22586[(2)]);
var inst_22451 = fluree.db.util.async.throw_err(inst_22450);
var inst_22452 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22416,inst_22451);
var state_22586__$1 = state_22586;
var statearr_22638_22842 = state_22586__$1;
(statearr_22638_22842[(2)] = inst_22452);

(statearr_22638_22842[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (119))){
var inst_22494 = (state_22586[(33)]);
var inst_22524 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22525 = [inst_22494,offset_map];
var inst_22526 = (new cljs.core.PersistentVector(null,2,(5),inst_22524,inst_22525,null));
var state_22586__$1 = state_22586;
var statearr_22639_22843 = state_22586__$1;
(statearr_22639_22843[(2)] = inst_22526);

(statearr_22639_22843[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (95))){
var inst_22202 = (state_22586[(19)]);
var state_22586__$1 = state_22586;
if(cljs.core.truth_(inst_22202)){
var statearr_22640_22844 = state_22586__$1;
(statearr_22640_22844[(1)] = (110));

} else {
var statearr_22641_22845 = state_22586__$1;
(statearr_22641_22845[(1)] = (111));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (54))){
var inst_22258 = (state_22586[(34)]);
var state_22586__$1 = state_22586;
var statearr_22642_22846 = state_22586__$1;
(statearr_22642_22846[(2)] = inst_22258);

(statearr_22642_22846[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (92))){
var inst_22395 = (state_22586[(31)]);
var state_22586__$1 = state_22586;
var statearr_22643_22847 = state_22586__$1;
(statearr_22643_22847[(2)] = inst_22395);

(statearr_22643_22847[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (104))){
var inst_22158 = (state_22586[(35)]);
var inst_22436 = (state_22586[(27)]);
var inst_22445 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298)];
var inst_22446 = [true,inst_22158];
var inst_22447 = cljs.core.PersistentHashMap.fromArrays(inst_22445,inst_22446);
var inst_22448 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_22447,inst_22436) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22447,inst_22436));
var state_22586__$1 = state_22586;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22586__$1,(106),inst_22448);
} else {
if((state_val_22587 === (15))){
var inst_22181 = (state_22586[(36)]);
var inst_22158 = (state_22586[(35)]);
var inst_22185 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_22181,new cljs.core.Keyword(null,"compact?","compact?",1216893298),inst_22158);
var state_22586__$1 = state_22586;
var statearr_22644_22848 = state_22586__$1;
(statearr_22644_22848[(2)] = inst_22185);

(statearr_22644_22848[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (48))){
var inst_22252 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22253 = [null,offset_map];
var inst_22254 = (new cljs.core.PersistentVector(null,2,(5),inst_22252,inst_22253,null));
var state_22586__$1 = state_22586;
var statearr_22645_22849 = state_22586__$1;
(statearr_22645_22849[(2)] = inst_22254);

(statearr_22645_22849[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (50))){
var inst_22552 = (state_22586[(2)]);
var state_22586__$1 = state_22586;
var statearr_22646_22850 = state_22586__$1;
(statearr_22646_22850[(2)] = inst_22552);

(statearr_22646_22850[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (116))){
var inst_22500 = (state_22586[(37)]);
var inst_22493 = (state_22586[(38)]);
var inst_22499 = cljs.core.seq(inst_22493);
var inst_22500__$1 = cljs.core.first(inst_22499);
var inst_22501 = cljs.core.next(inst_22499);
var state_22586__$1 = (function (){var statearr_22647 = state_22586;
(statearr_22647[(37)] = inst_22500__$1);

(statearr_22647[(39)] = inst_22501);

return statearr_22647;
})();
if(cljs.core.truth_(inst_22500__$1)){
var statearr_22648_22851 = state_22586__$1;
(statearr_22648_22851[(1)] = (118));

} else {
var statearr_22649_22852 = state_22586__$1;
(statearr_22649_22852[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (75))){
var inst_22293 = (state_22586[(25)]);
var inst_22323 = (state_22586[(2)]);
var inst_22285 = inst_22293;
var inst_22286 = inst_22323;
var state_22586__$1 = (function (){var statearr_22650 = state_22586;
(statearr_22650[(9)] = inst_22286);

(statearr_22650[(24)] = inst_22285);

return statearr_22650;
})();
var statearr_22651_22853 = state_22586__$1;
(statearr_22651_22853[(2)] = null);

(statearr_22651_22853[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (99))){
var inst_22422 = (state_22586[(40)]);
var inst_22188 = (state_22586[(14)]);
var inst_22425 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22426 = inst_22422.o;
var inst_22427 = [inst_22426];
var inst_22428 = (new cljs.core.PersistentVector(null,1,(5),inst_22425,inst_22427,null));
var inst_22429 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_22430 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_22188);
var inst_22431 = [inst_22430];
var inst_22432 = cljs.core.PersistentHashMap.fromArrays(inst_22429,inst_22431);
var inst_22433 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22428,inst_22432);
var state_22586__$1 = state_22586;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22586__$1,(102),inst_22433);
} else {
if((state_val_22587 === (21))){
var inst_22192 = (state_22586[(41)]);
var state_22586__$1 = state_22586;
var statearr_22652_22854 = state_22586__$1;
(statearr_22652_22854[(2)] = inst_22192);

(statearr_22652_22854[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (31))){
var inst_22209 = (state_22586[(26)]);
var state_22586__$1 = state_22586;
var statearr_22653_22855 = state_22586__$1;
(statearr_22653_22855[(2)] = inst_22209);

(statearr_22653_22855[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (113))){
var inst_22206 = (state_22586[(16)]);
var inst_22204 = (state_22586[(17)]);
var inst_22158 = (state_22586[(35)]);
var inst_22203 = (state_22586[(18)]);
var inst_22173 = (state_22586[(42)]);
var inst_22202 = (state_22586[(19)]);
var inst_22205 = (state_22586[(20)]);
var inst_22200 = (state_22586[(13)]);
var inst_22199 = (state_22586[(21)]);
var inst_22188 = (state_22586[(14)]);
var inst_22201 = (state_22586[(15)]);
var inst_22475 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22476 = (function (){var p = inst_22206;
var pred_spec__$1 = inst_22173;
var orderBy = inst_22204;
var map__22154 = inst_22200;
var multi_QMARK_ = inst_22201;
var limit = inst_22203;
var offset = inst_22205;
var k = inst_22199;
var compact_QMARK_ = inst_22158;
var pred_spec_SINGLEQUOTE_ = inst_22188;
var ref_QMARK_ = inst_22202;
return (function (p1__22144_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"_id","_id",-789960287)],[p1__22144_SHARP_.o]);
});
})();
var inst_22477 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_22476,flakes);
var inst_22478 = [inst_22477,offset_map];
var inst_22479 = (new cljs.core.PersistentVector(null,2,(5),inst_22475,inst_22478,null));
var state_22586__$1 = state_22586;
var statearr_22654_22856 = state_22586__$1;
(statearr_22654_22856[(2)] = inst_22479);

(statearr_22654_22856[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (32))){
var inst_22215 = (state_22586[(2)]);
var state_22586__$1 = state_22586;
var statearr_22655_22857 = state_22586__$1;
(statearr_22655_22857[(2)] = inst_22215);

(statearr_22655_22857[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (136))){
var inst_22577 = (state_22586[(2)]);
var state_22586__$1 = state_22586;
var statearr_22656_22858 = state_22586__$1;
(statearr_22656_22858[(2)] = inst_22577);

(statearr_22656_22858[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (40))){
var inst_22201 = (state_22586[(15)]);
var state_22586__$1 = state_22586;
var statearr_22657_22859 = state_22586__$1;
(statearr_22657_22859[(2)] = inst_22201);

(statearr_22657_22859[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (129))){
var inst_22201 = (state_22586[(15)]);
var state_22586__$1 = state_22586;
if(cljs.core.truth_(inst_22201)){
var statearr_22658_22860 = state_22586__$1;
(statearr_22658_22860[(1)] = (131));

} else {
var statearr_22659_22861 = state_22586__$1;
(statearr_22659_22861[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (91))){
var inst_22188 = (state_22586[(14)]);
var inst_22397 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_22188);
var state_22586__$1 = state_22586;
var statearr_22660_22862 = state_22586__$1;
(statearr_22660_22862[(2)] = inst_22397);

(statearr_22660_22862[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (117))){
var inst_22530 = (state_22586[(2)]);
var state_22586__$1 = state_22586;
var statearr_22661_22863 = state_22586__$1;
(statearr_22661_22863[(2)] = inst_22530);

(statearr_22661_22863[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (108))){
var state_22586__$1 = state_22586;
var statearr_22662_22864 = state_22586__$1;
(statearr_22662_22864[(2)] = null);

(statearr_22662_22864[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (56))){
var inst_22263 = (state_22586[(2)]);
var state_22586__$1 = state_22586;
var statearr_22663_22865 = state_22586__$1;
(statearr_22663_22865[(2)] = inst_22263);

(statearr_22663_22865[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (33))){
var inst_22206 = (state_22586[(16)]);
var inst_22223 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22224 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_22206);
var state_22586__$1 = (function (){var statearr_22664 = state_22586;
(statearr_22664[(43)] = inst_22223);

return statearr_22664;
})();
if(cljs.core.truth_(inst_22224)){
var statearr_22665_22866 = state_22586__$1;
(statearr_22665_22866[(1)] = (36));

} else {
var statearr_22666_22867 = state_22586__$1;
(statearr_22666_22867[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (13))){
var inst_22173 = (state_22586[(42)]);
var state_22586__$1 = state_22586;
var statearr_22667_22868 = state_22586__$1;
(statearr_22667_22868[(2)] = inst_22173);

(statearr_22667_22868[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (22))){
var inst_22188 = (state_22586[(14)]);
var inst_22195 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22188);
var state_22586__$1 = state_22586;
var statearr_22668_22869 = state_22586__$1;
(statearr_22668_22869[(2)] = inst_22195);

(statearr_22668_22869[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (90))){
var inst_22356 = (state_22586[(44)]);
var inst_22385 = (state_22586[(2)]);
var inst_22348 = inst_22356;
var inst_22349 = inst_22385;
var state_22586__$1 = (function (){var statearr_22669 = state_22586;
(statearr_22669[(45)] = inst_22348);

(statearr_22669[(30)] = inst_22349);

return statearr_22669;
})();
var statearr_22670_22870 = state_22586__$1;
(statearr_22670_22870[(2)] = null);

(statearr_22670_22870[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (109))){
var inst_22423 = (state_22586[(46)]);
var inst_22454 = (state_22586[(47)]);
var inst_22460 = (state_22586[(2)]);
var inst_22415 = inst_22423;
var inst_22416 = inst_22454;
var state_22586__$1 = (function (){var statearr_22671 = state_22586;
(statearr_22671[(32)] = inst_22416);

(statearr_22671[(48)] = inst_22460);

(statearr_22671[(49)] = inst_22415);

return statearr_22671;
})();
var statearr_22672_22871 = state_22586__$1;
(statearr_22672_22871[(2)] = null);

(statearr_22672_22871[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (36))){
var inst_22206 = (state_22586[(16)]);
var inst_22226 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_22206,cljs.core.dec);
var state_22586__$1 = state_22586;
var statearr_22673_22872 = state_22586__$1;
(statearr_22673_22872[(2)] = inst_22226);

(statearr_22673_22872[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (41))){
var inst_22250 = (state_22586[(2)]);
var state_22586__$1 = state_22586;
if(cljs.core.truth_(inst_22250)){
var statearr_22674_22873 = state_22586__$1;
(statearr_22674_22873[(1)] = (48));

} else {
var statearr_22675_22874 = state_22586__$1;
(statearr_22675_22874[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (118))){
var inst_22500 = (state_22586[(37)]);
var inst_22503 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22504 = inst_22500.o;
var inst_22505 = [inst_22504];
var inst_22506 = (new cljs.core.PersistentVector(null,1,(5),inst_22503,inst_22505,null));
var inst_22507 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22506);
var state_22586__$1 = state_22586;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22586__$1,(121),inst_22507);
} else {
if((state_val_22587 === (89))){
var inst_22349 = (state_22586[(30)]);
var state_22586__$1 = state_22586;
var statearr_22676_22875 = state_22586__$1;
(statearr_22676_22875[(2)] = inst_22349);

(statearr_22676_22875[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (100))){
var inst_22416 = (state_22586[(32)]);
var state_22586__$1 = state_22586;
var statearr_22677_22876 = state_22586__$1;
(statearr_22677_22876[(2)] = inst_22416);

(statearr_22677_22876[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (131))){
var inst_22556 = (state_22586[(10)]);
var inst_22199 = (state_22586[(21)]);
var inst_22555 = (state_22586[(50)]);
var inst_22564 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22565 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_22199,inst_22555);
var inst_22566 = [inst_22565,inst_22556];
var inst_22567 = (new cljs.core.PersistentVector(null,2,(5),inst_22564,inst_22566,null));
var state_22586__$1 = state_22586;
var statearr_22678_22877 = state_22586__$1;
(statearr_22678_22877[(2)] = inst_22567);

(statearr_22678_22877[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (122))){
var inst_22500 = (state_22586[(37)]);
var inst_22501 = (state_22586[(39)]);
var inst_22494 = (state_22586[(33)]);
var inst_22513 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22514 = inst_22500.o;
var inst_22515 = [inst_22514];
var inst_22516 = cljs.core.PersistentHashMap.fromArrays(inst_22513,inst_22515);
var inst_22517 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22494,inst_22516);
var inst_22493 = inst_22501;
var inst_22494__$1 = inst_22517;
var state_22586__$1 = (function (){var statearr_22679 = state_22586;
(statearr_22679[(38)] = inst_22493);

(statearr_22679[(33)] = inst_22494__$1);

return statearr_22679;
})();
var statearr_22680_22878 = state_22586__$1;
(statearr_22680_22878[(2)] = null);

(statearr_22680_22878[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (43))){
var inst_22236 = (state_22586[(29)]);
var state_22586__$1 = state_22586;
var statearr_22681_22879 = state_22586__$1;
(statearr_22681_22879[(2)] = inst_22236);

(statearr_22681_22879[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (61))){
var inst_22272 = (state_22586[(51)]);
var inst_22329 = (state_22586[(2)]);
var inst_22330 = [inst_22329,offset_map];
var inst_22331 = (new cljs.core.PersistentVector(null,2,(5),inst_22272,inst_22330,null));
var state_22586__$1 = state_22586;
var statearr_22682_22880 = state_22586__$1;
(statearr_22682_22880[(2)] = inst_22331);

(statearr_22682_22880[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (29))){
var inst_22218 = (state_22586[(2)]);
var state_22586__$1 = state_22586;
var statearr_22683_22881 = state_22586__$1;
(statearr_22683_22881[(2)] = inst_22218);

(statearr_22683_22881[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (44))){
var inst_22247 = (state_22586[(2)]);
var state_22586__$1 = state_22586;
var statearr_22684_22882 = state_22586__$1;
(statearr_22684_22882[(2)] = inst_22247);

(statearr_22684_22882[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (93))){
var inst_22400 = (state_22586[(2)]);
var state_22586__$1 = state_22586;
if(cljs.core.truth_(inst_22400)){
var statearr_22685_22883 = state_22586__$1;
(statearr_22685_22883[(1)] = (94));

} else {
var statearr_22686_22884 = state_22586__$1;
(statearr_22686_22884[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (6))){
var inst_22161 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22162 = (inst_22161 == null);
var state_22586__$1 = state_22586;
var statearr_22687_22885 = state_22586__$1;
(statearr_22687_22885[(2)] = inst_22162);

(statearr_22687_22885[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (111))){
var state_22586__$1 = state_22586;
var statearr_22688_22886 = state_22586__$1;
(statearr_22688_22886[(1)] = (125));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (28))){
var inst_22205 = (state_22586[(20)]);
var state_22586__$1 = state_22586;
var statearr_22690_22887 = state_22586__$1;
(statearr_22690_22887[(2)] = inst_22205);

(statearr_22690_22887[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (134))){
var inst_22556 = (state_22586[(10)]);
var inst_22199 = (state_22586[(21)]);
var inst_22555 = (state_22586[(50)]);
var inst_22570 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22571 = cljs.core.first(inst_22555);
var inst_22572 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_22199,inst_22571);
var inst_22573 = [inst_22572,inst_22556];
var inst_22574 = (new cljs.core.PersistentVector(null,2,(5),inst_22570,inst_22573,null));
var state_22586__$1 = state_22586;
var statearr_22691_22888 = state_22586__$1;
(statearr_22691_22888[(2)] = inst_22574);

(statearr_22691_22888[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (64))){
var inst_22327 = (state_22586[(2)]);
var state_22586__$1 = state_22586;
var statearr_22692_22889 = state_22586__$1;
(statearr_22692_22889[(2)] = inst_22327);

(statearr_22692_22889[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (103))){
var inst_22416 = (state_22586[(32)]);
var inst_22422 = (state_22586[(40)]);
var inst_22439 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22440 = inst_22422.o;
var inst_22441 = [inst_22440];
var inst_22442 = cljs.core.PersistentHashMap.fromArrays(inst_22439,inst_22441);
var inst_22443 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22416,inst_22442);
var state_22586__$1 = state_22586;
var statearr_22693_22890 = state_22586__$1;
(statearr_22693_22890[(2)] = inst_22443);

(statearr_22693_22890[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (51))){
var inst_22258 = (state_22586[(34)]);
var inst_22188 = (state_22586[(14)]);
var inst_22258__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_22188);
var state_22586__$1 = (function (){var statearr_22694 = state_22586;
(statearr_22694[(34)] = inst_22258__$1);

return statearr_22694;
})();
if(cljs.core.truth_(inst_22258__$1)){
var statearr_22695_22891 = state_22586__$1;
(statearr_22695_22891[(1)] = (54));

} else {
var statearr_22696_22892 = state_22586__$1;
(statearr_22696_22892[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (25))){
var inst_22201 = (state_22586[(15)]);
var state_22586__$1 = state_22586;
var statearr_22697_22893 = state_22586__$1;
(statearr_22697_22893[(2)] = inst_22201);

(statearr_22697_22893[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (34))){
var inst_22201 = (state_22586[(15)]);
var state_22586__$1 = state_22586;
if(cljs.core.truth_(inst_22201)){
var statearr_22698_22894 = state_22586__$1;
(statearr_22698_22894[(1)] = (39));

} else {
var statearr_22699_22895 = state_22586__$1;
(statearr_22699_22895[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (125))){
var inst_22206 = (state_22586[(16)]);
var inst_22204 = (state_22586[(17)]);
var inst_22158 = (state_22586[(35)]);
var inst_22203 = (state_22586[(18)]);
var inst_22173 = (state_22586[(42)]);
var inst_22202 = (state_22586[(19)]);
var inst_22205 = (state_22586[(20)]);
var inst_22200 = (state_22586[(13)]);
var inst_22199 = (state_22586[(21)]);
var inst_22188 = (state_22586[(14)]);
var inst_22201 = (state_22586[(15)]);
var inst_22535 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22536 = (function (){var p = inst_22206;
var pred_spec__$1 = inst_22173;
var orderBy = inst_22204;
var map__22154 = inst_22200;
var multi_QMARK_ = inst_22201;
var limit = inst_22203;
var offset = inst_22205;
var k = inst_22199;
var compact_QMARK_ = inst_22158;
var pred_spec_SINGLEQUOTE_ = inst_22188;
var ref_QMARK_ = inst_22202;
return (function (p1__22145_SHARP_){
return p1__22145_SHARP_.o;
});
})();
var inst_22537 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_22536,flakes);
var inst_22538 = [inst_22537,offset_map];
var inst_22539 = (new cljs.core.PersistentVector(null,2,(5),inst_22535,inst_22538,null));
var state_22586__$1 = state_22586;
var statearr_22700_22896 = state_22586__$1;
(statearr_22700_22896[(2)] = inst_22539);

(statearr_22700_22896[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (17))){
var inst_22189 = (state_22586[(52)]);
var inst_22188 = (state_22586[(14)]);
var inst_22188__$1 = (state_22586[(2)]);
var inst_22189__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_22188__$1);
var state_22586__$1 = (function (){var statearr_22701 = state_22586;
(statearr_22701[(52)] = inst_22189__$1);

(statearr_22701[(14)] = inst_22188__$1);

return statearr_22701;
})();
if(cljs.core.truth_(inst_22189__$1)){
var statearr_22702_22897 = state_22586__$1;
(statearr_22702_22897[(1)] = (18));

} else {
var statearr_22703_22898 = state_22586__$1;
(statearr_22703_22898[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (3))){
var inst_22584 = (state_22586[(2)]);
var state_22586__$1 = state_22586;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22586__$1,inst_22584);
} else {
if((state_val_22587 === (12))){
var inst_22173 = (state_22586[(42)]);
var inst_22178 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_22173,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_22586__$1 = state_22586;
var statearr_22704_22899 = state_22586__$1;
(statearr_22704_22899[(2)] = inst_22178);

(statearr_22704_22899[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (2))){
var inst_22159 = (state_22586[(11)]);
var _ = (function (){var statearr_22705 = state_22586;
(statearr_22705[(4)] = cljs.core.cons((5),(state_22586[(4)])));

return statearr_22705;
})();
var inst_22158 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22159__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_22586__$1 = (function (){var statearr_22706 = state_22586;
(statearr_22706[(35)] = inst_22158);

(statearr_22706[(11)] = inst_22159__$1);

return statearr_22706;
})();
if(cljs.core.truth_(inst_22159__$1)){
var statearr_22707_22900 = state_22586__$1;
(statearr_22707_22900[(1)] = (6));

} else {
var statearr_22708_22901 = state_22586__$1;
(statearr_22708_22901[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (66))){
var inst_22302 = (state_22586[(7)]);
var inst_22271 = (state_22586[(53)]);
var inst_22305 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_22271,inst_22302) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22271,inst_22302));
var state_22586__$1 = state_22586;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22586__$1,(69),inst_22305);
} else {
if((state_val_22587 === (107))){
var inst_22436 = (state_22586[(27)]);
var inst_22456 = cljs.core.count(inst_22436);
var inst_22457 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_22456);
var state_22586__$1 = state_22586;
var statearr_22709_22902 = state_22586__$1;
(statearr_22709_22902[(2)] = inst_22457);

(statearr_22709_22902[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (23))){
var inst_22197 = (state_22586[(2)]);
var state_22586__$1 = state_22586;
var statearr_22710_22903 = state_22586__$1;
(statearr_22710_22903[(2)] = inst_22197);

(statearr_22710_22903[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (47))){
var inst_22244 = (state_22586[(2)]);
var state_22586__$1 = state_22586;
var statearr_22711_22904 = state_22586__$1;
(statearr_22711_22904[(2)] = inst_22244);

(statearr_22711_22904[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (35))){
var inst_22555 = (state_22586[(50)]);
var inst_22554 = (state_22586[(2)]);
var inst_22555__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22554,(0),null);
var inst_22556 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22554,(1),null);
var inst_22557 = cljs.core.empty_QMARK_(inst_22555__$1);
var state_22586__$1 = (function (){var statearr_22712 = state_22586;
(statearr_22712[(10)] = inst_22556);

(statearr_22712[(50)] = inst_22555__$1);

return statearr_22712;
})();
if(inst_22557){
var statearr_22713_22905 = state_22586__$1;
(statearr_22713_22905[(1)] = (128));

} else {
var statearr_22714_22906 = state_22586__$1;
(statearr_22714_22906[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (127))){
var inst_22542 = (state_22586[(2)]);
var state_22586__$1 = state_22586;
var statearr_22715_22907 = state_22586__$1;
(statearr_22715_22907[(2)] = inst_22542);

(statearr_22715_22907[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (82))){
var inst_22349 = (state_22586[(30)]);
var state_22586__$1 = state_22586;
var statearr_22716_22908 = state_22586__$1;
(statearr_22716_22908[(2)] = inst_22349);

(statearr_22716_22908[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (76))){
var inst_22335 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22343 = flakes;
var inst_22344 = cljs.core.seq(inst_22343);
var inst_22345 = cljs.core.first(inst_22344);
var inst_22346 = cljs.core.next(inst_22344);
var inst_22347 = cljs.core.PersistentVector.EMPTY;
var inst_22348 = inst_22343;
var inst_22349 = inst_22347;
var state_22586__$1 = (function (){var statearr_22717 = state_22586;
(statearr_22717[(54)] = inst_22335);

(statearr_22717[(45)] = inst_22348);

(statearr_22717[(55)] = inst_22345);

(statearr_22717[(30)] = inst_22349);

(statearr_22717[(56)] = inst_22346);

return statearr_22717;
})();
var statearr_22718_22909 = state_22586__$1;
(statearr_22718_22909[(2)] = null);

(statearr_22718_22909[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (97))){
var inst_22422 = (state_22586[(40)]);
var inst_22415 = (state_22586[(49)]);
var inst_22421 = cljs.core.seq(inst_22415);
var inst_22422__$1 = cljs.core.first(inst_22421);
var inst_22423 = cljs.core.next(inst_22421);
var state_22586__$1 = (function (){var statearr_22719 = state_22586;
(statearr_22719[(40)] = inst_22422__$1);

(statearr_22719[(46)] = inst_22423);

return statearr_22719;
})();
if(cljs.core.truth_(inst_22422__$1)){
var statearr_22720_22910 = state_22586__$1;
(statearr_22720_22910[(1)] = (99));

} else {
var statearr_22721_22911 = state_22586__$1;
(statearr_22721_22911[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (19))){
var inst_22192 = (state_22586[(41)]);
var inst_22188 = (state_22586[(14)]);
var inst_22192__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22188);
var state_22586__$1 = (function (){var statearr_22722 = state_22586;
(statearr_22722[(41)] = inst_22192__$1);

return statearr_22722;
})();
if(cljs.core.truth_(inst_22192__$1)){
var statearr_22723_22912 = state_22586__$1;
(statearr_22723_22912[(1)] = (21));

} else {
var statearr_22724_22913 = state_22586__$1;
(statearr_22724_22913[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (57))){
var inst_22188 = (state_22586[(14)]);
var inst_22268 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22269 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_22270 = (new cljs.core.PersistentVector(null,3,(5),inst_22268,inst_22269,null));
var inst_22271 = cljs.core.select_keys(inst_22188,inst_22270);
var inst_22272 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22280 = flakes;
var inst_22281 = cljs.core.seq(inst_22280);
var inst_22282 = cljs.core.first(inst_22281);
var inst_22283 = cljs.core.next(inst_22281);
var inst_22284 = cljs.core.PersistentVector.EMPTY;
var inst_22285 = inst_22280;
var inst_22286 = inst_22284;
var state_22586__$1 = (function (){var statearr_22725 = state_22586;
(statearr_22725[(9)] = inst_22286);

(statearr_22725[(57)] = inst_22283);

(statearr_22725[(53)] = inst_22271);

(statearr_22725[(24)] = inst_22285);

(statearr_22725[(58)] = inst_22282);

(statearr_22725[(51)] = inst_22272);

return statearr_22725;
})();
var statearr_22726_22914 = state_22586__$1;
(statearr_22726_22914[(2)] = null);

(statearr_22726_22914[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (68))){
var inst_22311 = (state_22586[(2)]);
var state_22586__$1 = (function (){var statearr_22727 = state_22586;
(statearr_22727[(22)] = inst_22311);

return statearr_22727;
})();
if(cljs.core.truth_(fuel)){
var statearr_22728_22915 = state_22586__$1;
(statearr_22728_22915[(1)] = (70));

} else {
var statearr_22729_22916 = state_22586__$1;
(statearr_22729_22916[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (11))){
var inst_22173 = (state_22586[(42)]);
var inst_22173__$1 = (state_22586[(2)]);
var inst_22175 = cljs.core.contains_QMARK_(inst_22173__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var inst_22176 = (!(inst_22175));
var state_22586__$1 = (function (){var statearr_22730 = state_22586;
(statearr_22730[(42)] = inst_22173__$1);

return statearr_22730;
})();
if(inst_22176){
var statearr_22731_22917 = state_22586__$1;
(statearr_22731_22917[(1)] = (12));

} else {
var statearr_22732_22918 = state_22586__$1;
(statearr_22732_22918[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (115))){
var inst_22532 = (state_22586[(2)]);
var state_22586__$1 = state_22586;
var statearr_22734_22919 = state_22586__$1;
(statearr_22734_22919[(2)] = inst_22532);

(statearr_22734_22919[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (9))){
var inst_22167 = cljs.core.first(flakes);
var inst_22168 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22167);
var inst_22169 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22170 = fluree.db.query.fql.wildcard_pred_spec(db,cache,inst_22168,inst_22169);
var state_22586__$1 = state_22586;
var statearr_22735_22920 = state_22586__$1;
(statearr_22735_22920[(2)] = inst_22170);

(statearr_22735_22920[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (5))){
var _ = (function (){var statearr_22736 = state_22586;
(statearr_22736[(4)] = cljs.core.rest((state_22586[(4)])));

return statearr_22736;
})();
var state_22586__$1 = state_22586;
var ex22733 = (state_22586__$1[(2)]);
var statearr_22737_22921 = state_22586__$1;
(statearr_22737_22921[(5)] = ex22733);


if((ex22733 instanceof Error)){
var statearr_22738_22922 = state_22586__$1;
(statearr_22738_22922[(1)] = (4));

(statearr_22738_22922[(5)] = null);

} else {
throw ex22733;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (112))){
var inst_22544 = (state_22586[(2)]);
var state_22586__$1 = state_22586;
var statearr_22739_22923 = state_22586__$1;
(statearr_22739_22923[(2)] = inst_22544);

(statearr_22739_22923[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (83))){
var inst_22389 = (state_22586[(2)]);
var state_22586__$1 = state_22586;
var statearr_22740_22924 = state_22586__$1;
(statearr_22740_22924[(2)] = inst_22389);

(statearr_22740_22924[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (14))){
var inst_22173 = (state_22586[(42)]);
var inst_22181 = (state_22586[(2)]);
var inst_22182 = cljs.core.contains_QMARK_(inst_22173,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var inst_22183 = (!(inst_22182));
var state_22586__$1 = (function (){var statearr_22741 = state_22586;
(statearr_22741[(36)] = inst_22181);

return statearr_22741;
})();
if(inst_22183){
var statearr_22742_22925 = state_22586__$1;
(statearr_22742_22925[(1)] = (15));

} else {
var statearr_22743_22926 = state_22586__$1;
(statearr_22743_22926[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (45))){
var inst_22203 = (state_22586[(18)]);
var inst_22199 = (state_22586[(21)]);
var inst_22239 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_22199);
var inst_22240 = cljs.core.count(inst_22239);
var inst_22241 = (inst_22240 >= inst_22203);
var state_22586__$1 = state_22586;
var statearr_22744_22927 = state_22586__$1;
(statearr_22744_22927[(2)] = inst_22241);

(statearr_22744_22927[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (53))){
var inst_22266 = (state_22586[(2)]);
var state_22586__$1 = state_22586;
if(cljs.core.truth_(inst_22266)){
var statearr_22745_22928 = state_22586__$1;
(statearr_22745_22928[(1)] = (57));

} else {
var statearr_22746_22929 = state_22586__$1;
(statearr_22746_22929[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (78))){
var inst_22548 = (state_22586[(2)]);
var state_22586__$1 = state_22586;
var statearr_22747_22930 = state_22586__$1;
(statearr_22747_22930[(2)] = inst_22548);

(statearr_22747_22930[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (132))){
var state_22586__$1 = state_22586;
var statearr_22749_22931 = state_22586__$1;
(statearr_22749_22931[(1)] = (134));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (26))){
var inst_22221 = (state_22586[(2)]);
var state_22586__$1 = state_22586;
if(cljs.core.truth_(inst_22221)){
var statearr_22751_22932 = state_22586__$1;
(statearr_22751_22932[(1)] = (33));

} else {
var statearr_22752_22933 = state_22586__$1;
(statearr_22752_22933[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (123))){
var inst_22501 = (state_22586[(39)]);
var inst_22494 = (state_22586[(33)]);
var tmp22748 = inst_22494;
var inst_22493 = inst_22501;
var inst_22494__$1 = tmp22748;
var state_22586__$1 = (function (){var statearr_22753 = state_22586;
(statearr_22753[(38)] = inst_22493);

(statearr_22753[(33)] = inst_22494__$1);

return statearr_22753;
})();
var statearr_22754_22934 = state_22586__$1;
(statearr_22754_22934[(2)] = null);

(statearr_22754_22934[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (16))){
var inst_22181 = (state_22586[(36)]);
var state_22586__$1 = state_22586;
var statearr_22755_22935 = state_22586__$1;
(statearr_22755_22935[(2)] = inst_22181);

(statearr_22755_22935[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (133))){
var inst_22579 = (state_22586[(2)]);
var state_22586__$1 = state_22586;
var statearr_22756_22936 = state_22586__$1;
(statearr_22756_22936[(2)] = inst_22579);

(statearr_22756_22936[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (81))){
var inst_22355 = (state_22586[(28)]);
var inst_22188 = (state_22586[(14)]);
var inst_22364 = (state_22586[(59)]);
var inst_22358 = cljs.core.deref(cache);
var inst_22359 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22360 = inst_22355.o;
var inst_22361 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22188);
var inst_22362 = [inst_22360,inst_22361];
var inst_22363 = (new cljs.core.PersistentVector(null,2,(5),inst_22359,inst_22362,null));
var inst_22364__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22358,inst_22363);
var state_22586__$1 = (function (){var statearr_22757 = state_22586;
(statearr_22757[(59)] = inst_22364__$1);

return statearr_22757;
})();
if(cljs.core.truth_(inst_22364__$1)){
var statearr_22758_22937 = state_22586__$1;
(statearr_22758_22937[(1)] = (84));

} else {
var statearr_22759_22938 = state_22586__$1;
(statearr_22759_22938[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (120))){
var inst_22528 = (state_22586[(2)]);
var state_22586__$1 = state_22586;
var statearr_22760_22939 = state_22586__$1;
(statearr_22760_22939[(2)] = inst_22528);

(statearr_22760_22939[(1)] = (117));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (79))){
var inst_22348 = (state_22586[(45)]);
var inst_22355 = (state_22586[(28)]);
var inst_22354 = cljs.core.seq(inst_22348);
var inst_22355__$1 = cljs.core.first(inst_22354);
var inst_22356 = cljs.core.next(inst_22354);
var state_22586__$1 = (function (){var statearr_22761 = state_22586;
(statearr_22761[(28)] = inst_22355__$1);

(statearr_22761[(44)] = inst_22356);

return statearr_22761;
})();
if(cljs.core.truth_(inst_22355__$1)){
var statearr_22762_22940 = state_22586__$1;
(statearr_22762_22940[(1)] = (81));

} else {
var statearr_22763_22941 = state_22586__$1;
(statearr_22763_22941[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (38))){
var inst_22223 = (state_22586[(43)]);
var inst_22231 = (state_22586[(2)]);
var inst_22232 = [null,inst_22231];
var inst_22233 = (new cljs.core.PersistentVector(null,2,(5),inst_22223,inst_22232,null));
var state_22586__$1 = state_22586;
var statearr_22764_22942 = state_22586__$1;
(statearr_22764_22942[(2)] = inst_22233);

(statearr_22764_22942[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (126))){
var state_22586__$1 = state_22586;
var statearr_22765_22943 = state_22586__$1;
(statearr_22765_22943[(2)] = null);

(statearr_22765_22943[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (98))){
var inst_22402 = (state_22586[(60)]);
var inst_22466 = (state_22586[(2)]);
var inst_22467 = [inst_22466,offset_map];
var inst_22468 = (new cljs.core.PersistentVector(null,2,(5),inst_22402,inst_22467,null));
var state_22586__$1 = state_22586;
var statearr_22766_22944 = state_22586__$1;
(statearr_22766_22944[(2)] = inst_22468);

(statearr_22766_22944[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (124))){
var inst_22522 = (state_22586[(2)]);
var state_22586__$1 = state_22586;
var statearr_22767_22945 = state_22586__$1;
(statearr_22767_22945[(2)] = inst_22522);

(statearr_22767_22945[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (87))){
var inst_22355 = (state_22586[(28)]);
var inst_22188 = (state_22586[(14)]);
var inst_22371 = (state_22586[(2)]);
var inst_22372 = fluree.db.util.async.throw_err(inst_22371);
var inst_22373 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22374 = inst_22355.o;
var inst_22375 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22188);
var inst_22376 = [inst_22374,inst_22375];
var inst_22377 = (new cljs.core.PersistentVector(null,2,(5),inst_22373,inst_22376,null));
var inst_22378 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,inst_22377,inst_22372);
var state_22586__$1 = (function (){var statearr_22768 = state_22586;
(statearr_22768[(61)] = inst_22378);

return statearr_22768;
})();
var statearr_22769_22946 = state_22586__$1;
(statearr_22769_22946[(2)] = inst_22372);

(statearr_22769_22946[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (30))){
var inst_22206 = (state_22586[(16)]);
var inst_22211 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_22206);
var inst_22212 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_22211);
var state_22586__$1 = state_22586;
var statearr_22770_22947 = state_22586__$1;
(statearr_22770_22947[(2)] = inst_22212);

(statearr_22770_22947[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (73))){
var inst_22286 = (state_22586[(9)]);
var inst_22311 = (state_22586[(22)]);
var inst_22320 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22286,inst_22311);
var state_22586__$1 = state_22586;
var statearr_22771_22948 = state_22586__$1;
(statearr_22771_22948[(2)] = inst_22320);

(statearr_22771_22948[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (96))){
var inst_22546 = (state_22586[(2)]);
var state_22586__$1 = state_22586;
var statearr_22772_22949 = state_22586__$1;
(statearr_22772_22949[(2)] = inst_22546);

(statearr_22772_22949[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (10))){
var state_22586__$1 = state_22586;
var statearr_22773_22950 = state_22586__$1;
(statearr_22773_22950[(2)] = pred_spec);

(statearr_22773_22950[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (18))){
var inst_22189 = (state_22586[(52)]);
var state_22586__$1 = state_22586;
var statearr_22774_22951 = state_22586__$1;
(statearr_22774_22951[(2)] = inst_22189);

(statearr_22774_22951[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (105))){
var inst_22454 = (state_22586[(2)]);
var state_22586__$1 = (function (){var statearr_22775 = state_22586;
(statearr_22775[(47)] = inst_22454);

return statearr_22775;
})();
if(cljs.core.truth_(fuel)){
var statearr_22776_22952 = state_22586__$1;
(statearr_22776_22952[(1)] = (107));

} else {
var statearr_22777_22953 = state_22586__$1;
(statearr_22777_22953[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (52))){
var inst_22256 = (state_22586[(62)]);
var state_22586__$1 = state_22586;
var statearr_22778_22954 = state_22586__$1;
(statearr_22778_22954[(2)] = inst_22256);

(statearr_22778_22954[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (114))){
var inst_22488 = flakes;
var inst_22489 = cljs.core.seq(inst_22488);
var inst_22490 = cljs.core.first(inst_22489);
var inst_22491 = cljs.core.next(inst_22489);
var inst_22492 = cljs.core.PersistentVector.EMPTY;
var inst_22493 = inst_22488;
var inst_22494 = inst_22492;
var state_22586__$1 = (function (){var statearr_22779 = state_22586;
(statearr_22779[(38)] = inst_22493);

(statearr_22779[(63)] = inst_22490);

(statearr_22779[(64)] = inst_22491);

(statearr_22779[(33)] = inst_22494);

return statearr_22779;
})();
var statearr_22780_22955 = state_22586__$1;
(statearr_22780_22955[(2)] = null);

(statearr_22780_22955[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (67))){
var state_22586__$1 = state_22586;
var statearr_22781_22956 = state_22586__$1;
(statearr_22781_22956[(2)] = null);

(statearr_22781_22956[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (71))){
var state_22586__$1 = state_22586;
var statearr_22782_22957 = state_22586__$1;
(statearr_22782_22957[(2)] = null);

(statearr_22782_22957[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (42))){
var inst_22203 = (state_22586[(18)]);
var state_22586__$1 = state_22586;
if(cljs.core.truth_(inst_22203)){
var statearr_22783_22958 = state_22586__$1;
(statearr_22783_22958[(1)] = (45));

} else {
var statearr_22784_22959 = state_22586__$1;
(statearr_22784_22959[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (80))){
var inst_22335 = (state_22586[(54)]);
var inst_22391 = (state_22586[(2)]);
var inst_22392 = [inst_22391,offset_map];
var inst_22393 = (new cljs.core.PersistentVector(null,2,(5),inst_22335,inst_22392,null));
var state_22586__$1 = state_22586;
var statearr_22785_22960 = state_22586__$1;
(statearr_22785_22960[(2)] = inst_22393);

(statearr_22785_22960[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (37))){
var inst_22206 = (state_22586[(16)]);
var inst_22205 = (state_22586[(20)]);
var inst_22228 = (inst_22205 - (1));
var inst_22229 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_22206,inst_22228);
var state_22586__$1 = state_22586;
var statearr_22786_22961 = state_22586__$1;
(statearr_22786_22961[(2)] = inst_22229);

(statearr_22786_22961[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (63))){
var inst_22286 = (state_22586[(9)]);
var state_22586__$1 = state_22586;
var statearr_22787_22962 = state_22586__$1;
(statearr_22787_22962[(2)] = inst_22286);

(statearr_22787_22962[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (94))){
var inst_22402 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22410 = flakes;
var inst_22411 = cljs.core.seq(inst_22410);
var inst_22412 = cljs.core.first(inst_22411);
var inst_22413 = cljs.core.next(inst_22411);
var inst_22414 = cljs.core.PersistentVector.EMPTY;
var inst_22415 = inst_22410;
var inst_22416 = inst_22414;
var state_22586__$1 = (function (){var statearr_22788 = state_22586;
(statearr_22788[(65)] = inst_22412);

(statearr_22788[(32)] = inst_22416);

(statearr_22788[(66)] = inst_22413);

(statearr_22788[(49)] = inst_22415);

(statearr_22788[(60)] = inst_22402);

return statearr_22788;
})();
var statearr_22789_22963 = state_22586__$1;
(statearr_22789_22963[(2)] = null);

(statearr_22789_22963[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (8))){
var inst_22165 = (state_22586[(2)]);
var state_22586__$1 = state_22586;
if(cljs.core.truth_(inst_22165)){
var statearr_22790_22964 = state_22586__$1;
(statearr_22790_22964[(1)] = (9));

} else {
var statearr_22791_22965 = state_22586__$1;
(statearr_22791_22965[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (49))){
var inst_22256 = (state_22586[(62)]);
var inst_22256__$1 = cljs.core.not(recur_QMARK_);
var state_22586__$1 = (function (){var statearr_22792 = state_22586;
(statearr_22792[(62)] = inst_22256__$1);

return statearr_22792;
})();
if(inst_22256__$1){
var statearr_22793_22966 = state_22586__$1;
(statearr_22793_22966[(1)] = (51));

} else {
var statearr_22794_22967 = state_22586__$1;
(statearr_22794_22967[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22587 === (84))){
var inst_22364 = (state_22586[(59)]);
var state_22586__$1 = state_22586;
var statearr_22795_22968 = state_22586__$1;
(statearr_22795_22968[(2)] = inst_22364);

(statearr_22795_22968[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2717__auto__ = null;
var fluree$db$query$fql$state_machine__2717__auto____0 = (function (){
var statearr_22796 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22796[(0)] = fluree$db$query$fql$state_machine__2717__auto__);

(statearr_22796[(1)] = (1));

return statearr_22796;
});
var fluree$db$query$fql$state_machine__2717__auto____1 = (function (state_22586){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_22586);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e22797){var ex__2720__auto__ = e22797;
var statearr_22798_22969 = state_22586;
(statearr_22798_22969[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_22586[(4)]))){
var statearr_22799_22970 = state_22586;
(statearr_22799_22970[(1)] = cljs.core.first((state_22586[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22971 = state_22586;
state_22586 = G__22971;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2717__auto__ = function(state_22586){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2717__auto____1.call(this,state_22586);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2717__auto____0;
fluree$db$query$fql$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2717__auto____1;
return fluree$db$query$fql$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_22800 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_22800[(6)] = c__2739__auto__);

return statearr_22800;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel)], 0))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec);

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_23131){
var state_val_23132 = (state_23131[(1)]);
if((state_val_23132 === (7))){
var inst_23126 = (state_23131[(2)]);
var _ = (function (){var statearr_23133 = state_23131;
(statearr_23133[(4)] = cljs.core.rest((state_23131[(4)])));

return statearr_23133;
})();
var state_23131__$1 = state_23131;
var statearr_23134_23216 = state_23131__$1;
(statearr_23134_23216[(2)] = inst_23126);

(statearr_23134_23216[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (20))){
var inst_23053 = (state_23131[(7)]);
var state_23131__$1 = state_23131;
var statearr_23135_23217 = state_23131__$1;
(statearr_23135_23217[(2)] = inst_23053);

(statearr_23135_23217[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (27))){
var inst_23008 = (state_23131[(8)]);
var state_23131__$1 = state_23131;
if(cljs.core.truth_(inst_23008)){
var statearr_23136_23218 = state_23131__$1;
(statearr_23136_23218[(1)] = (29));

} else {
var statearr_23137_23219 = state_23131__$1;
(statearr_23137_23219[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (1))){
var state_23131__$1 = state_23131;
var statearr_23138_23220 = state_23131__$1;
(statearr_23138_23220[(2)] = null);

(statearr_23138_23220[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (24))){
var inst_23009 = (state_23131[(9)]);
var state_23131__$1 = state_23131;
var statearr_23139_23221 = state_23131__$1;
(statearr_23139_23221[(2)] = inst_23009);

(statearr_23139_23221[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (39))){
var inst_23045 = (state_23131[(10)]);
var state_23131__$1 = state_23131;
var statearr_23140_23222 = state_23131__$1;
(statearr_23140_23222[(2)] = inst_23045);

(statearr_23140_23222[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (46))){
var inst_23010 = (state_23131[(11)]);
var state_23131__$1 = state_23131;
var statearr_23141_23223 = state_23131__$1;
(statearr_23141_23223[(2)] = inst_23010);

(statearr_23141_23223[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (4))){
var inst_22972 = (state_23131[(2)]);
var state_23131__$1 = state_23131;
var statearr_23142_23224 = state_23131__$1;
(statearr_23142_23224[(2)] = inst_22972);

(statearr_23142_23224[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (15))){
var inst_23021 = (state_23131[(12)]);
var inst_23027 = cljs.core.count(inst_23021);
var inst_23028 = fluree.db.query.fql.add_fuel(fuel,inst_23027,max_fuel);
var state_23131__$1 = state_23131;
var statearr_23143_23225 = state_23131__$1;
(statearr_23143_23225[(2)] = inst_23028);

(statearr_23143_23225[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (48))){
var inst_22997 = (state_23131[(13)]);
var inst_23112 = (state_23131[(14)]);
var inst_22990 = (state_23131[(15)]);
var inst_23120 = (state_23131[(2)]);
var inst_23121 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_22990,inst_23120,inst_23112);
var inst_22989 = inst_22997;
var inst_22990__$1 = inst_23121;
var state_23131__$1 = (function (){var statearr_23144 = state_23131;
(statearr_23144[(15)] = inst_22990__$1);

(statearr_23144[(16)] = inst_22989);

return statearr_23144;
})();
var statearr_23145_23226 = state_23131__$1;
(statearr_23145_23226[(2)] = null);

(statearr_23145_23226[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (50))){
var inst_23012 = (state_23131[(17)]);
var state_23131__$1 = state_23131;
var statearr_23146_23227 = state_23131__$1;
(statearr_23146_23227[(2)] = inst_23012);

(statearr_23146_23227[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (21))){
var inst_23009 = (state_23131[(9)]);
var state_23131__$1 = state_23131;
if(cljs.core.truth_(inst_23009)){
var statearr_23148_23228 = state_23131__$1;
(statearr_23148_23228[(1)] = (23));

} else {
var statearr_23149_23229 = state_23131__$1;
(statearr_23149_23229[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (31))){
var inst_23069 = (state_23131[(2)]);
var state_23131__$1 = state_23131;
if(cljs.core.truth_(inst_23069)){
var statearr_23150_23230 = state_23131__$1;
(statearr_23150_23230[(1)] = (32));

} else {
var statearr_23151_23231 = state_23131__$1;
(statearr_23151_23231[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (32))){
var inst_23045 = (state_23131[(10)]);
var inst_23044 = (state_23131[(18)]);
var inst_23052 = (state_23131[(19)]);
var inst_23071 = (inst_23044 + (1));
var tmp23147 = inst_23045;
var inst_23043 = inst_23052;
var inst_23044__$1 = inst_23071;
var inst_23045__$1 = tmp23147;
var state_23131__$1 = (function (){var statearr_23152 = state_23131;
(statearr_23152[(10)] = inst_23045__$1);

(statearr_23152[(18)] = inst_23044__$1);

(statearr_23152[(20)] = inst_23043);

return statearr_23152;
})();
var statearr_23153_23232 = state_23131__$1;
(statearr_23153_23232[(2)] = null);

(statearr_23153_23232[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (40))){
var state_23131__$1 = state_23131;
if(cljs.core.truth_(fuel)){
var statearr_23154_23233 = state_23131__$1;
(statearr_23154_23233[(1)] = (42));

} else {
var statearr_23155_23234 = state_23131__$1;
(statearr_23155_23234[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (33))){
var state_23131__$1 = state_23131;
var statearr_23156_23235 = state_23131__$1;
(statearr_23156_23235[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (13))){
var inst_23021 = (state_23131[(12)]);
var state_23131__$1 = state_23131;
var statearr_23158_23236 = state_23131__$1;
(statearr_23158_23236[(2)] = inst_23021);

(statearr_23158_23236[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (22))){
var inst_23062 = (state_23131[(2)]);
var state_23131__$1 = state_23131;
if(cljs.core.truth_(inst_23062)){
var statearr_23159_23237 = state_23131__$1;
(statearr_23159_23237[(1)] = (26));

} else {
var statearr_23160_23238 = state_23131__$1;
(statearr_23160_23238[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (36))){
var state_23131__$1 = state_23131;
var statearr_23161_23239 = state_23131__$1;
(statearr_23161_23239[(2)] = null);

(statearr_23161_23239[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (41))){
var inst_23044 = (state_23131[(18)]);
var inst_23052 = (state_23131[(19)]);
var inst_23101 = (state_23131[(2)]);
var inst_23102 = (inst_23044 + (1));
var inst_23043 = inst_23052;
var inst_23044__$1 = inst_23102;
var inst_23045 = inst_23101;
var state_23131__$1 = (function (){var statearr_23162 = state_23131;
(statearr_23162[(10)] = inst_23045);

(statearr_23162[(18)] = inst_23044__$1);

(statearr_23162[(20)] = inst_23043);

return statearr_23162;
})();
var statearr_23163_23240 = state_23131__$1;
(statearr_23163_23240[(2)] = null);

(statearr_23163_23240[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (43))){
var state_23131__$1 = state_23131;
var statearr_23164_23241 = state_23131__$1;
(statearr_23164_23241[(2)] = null);

(statearr_23164_23241[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (29))){
var inst_23008 = (state_23131[(8)]);
var inst_23044 = (state_23131[(18)]);
var inst_23066 = (inst_23044 < inst_23008);
var state_23131__$1 = state_23131;
var statearr_23165_23242 = state_23131__$1;
(statearr_23165_23242[(2)] = inst_23066);

(statearr_23165_23242[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (44))){
var inst_23081 = (state_23131[(21)]);
var inst_23085 = (state_23131[(22)]);
var inst_23094 = (state_23131[(2)]);
var inst_23095 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_23085,inst_23081) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_23085,inst_23081));
var state_23131__$1 = (function (){var statearr_23166 = state_23131;
(statearr_23166[(23)] = inst_23094);

return statearr_23166;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23131__$1,(45),inst_23095);
} else {
if((state_val_23132 === (6))){
var inst_22996 = (state_23131[(24)]);
var inst_22989 = (state_23131[(16)]);
var inst_22995 = cljs.core.seq(inst_22989);
var inst_22996__$1 = cljs.core.first(inst_22995);
var inst_22997 = cljs.core.next(inst_22995);
var inst_22998 = cljs.core.not(inst_22996__$1);
var state_23131__$1 = (function (){var statearr_23167 = state_23131;
(statearr_23167[(24)] = inst_22996__$1);

(statearr_23167[(13)] = inst_22997);

return statearr_23167;
})();
if(inst_22998){
var statearr_23168_23243 = state_23131__$1;
(statearr_23168_23243[(1)] = (8));

} else {
var statearr_23169_23244 = state_23131__$1;
(statearr_23169_23244[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (28))){
var inst_23110 = (state_23131[(2)]);
var state_23131__$1 = state_23131;
var statearr_23170_23245 = state_23131__$1;
(statearr_23170_23245[(2)] = inst_23110);

(statearr_23170_23245[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (51))){
var inst_23118 = (state_23131[(2)]);
var state_23131__$1 = state_23131;
var statearr_23171_23246 = state_23131__$1;
(statearr_23171_23246[(2)] = inst_23118);

(statearr_23171_23246[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (25))){
var inst_23060 = (state_23131[(2)]);
var state_23131__$1 = state_23131;
var statearr_23172_23247 = state_23131__$1;
(statearr_23172_23247[(2)] = inst_23060);

(statearr_23172_23247[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (34))){
var inst_23108 = (state_23131[(2)]);
var state_23131__$1 = state_23131;
var statearr_23173_23248 = state_23131__$1;
(statearr_23173_23248[(2)] = inst_23108);

(statearr_23173_23248[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (17))){
var inst_23021 = (state_23131[(12)]);
var inst_23031 = (state_23131[(2)]);
var inst_23039 = cljs.core.seq(inst_23021);
var inst_23040 = cljs.core.first(inst_23039);
var inst_23041 = cljs.core.next(inst_23039);
var inst_23042 = cljs.core.PersistentVector.EMPTY;
var inst_23043 = inst_23021;
var inst_23044 = (0);
var inst_23045 = inst_23042;
var state_23131__$1 = (function (){var statearr_23174 = state_23131;
(statearr_23174[(25)] = inst_23040);

(statearr_23174[(26)] = inst_23041);

(statearr_23174[(10)] = inst_23045);

(statearr_23174[(18)] = inst_23044);

(statearr_23174[(20)] = inst_23043);

(statearr_23174[(27)] = inst_23031);

return statearr_23174;
})();
var statearr_23175_23249 = state_23131__$1;
(statearr_23175_23249[(2)] = null);

(statearr_23175_23249[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (3))){
var inst_23129 = (state_23131[(2)]);
var state_23131__$1 = state_23131;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23131__$1,inst_23129);
} else {
if((state_val_23132 === (12))){
var state_23131__$1 = state_23131;
var statearr_23176_23250 = state_23131__$1;
(statearr_23176_23250[(2)] = fuel);

(statearr_23176_23250[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (2))){
var _ = (function (){var statearr_23177 = state_23131;
(statearr_23177[(4)] = cljs.core.cons((5),(state_23131[(4)])));

return statearr_23177;
})();
var inst_22985 = reverse_refs_specs;
var inst_22986 = cljs.core.seq(inst_22985);
var inst_22987 = cljs.core.first(inst_22986);
var inst_22988 = cljs.core.next(inst_22986);
var inst_22989 = inst_22985;
var inst_22990 = null;
var state_23131__$1 = (function (){var statearr_23178 = state_23131;
(statearr_23178[(28)] = inst_22987);

(statearr_23178[(29)] = inst_22988);

(statearr_23178[(15)] = inst_22990);

(statearr_23178[(16)] = inst_22989);

return statearr_23178;
})();
var statearr_23179_23251 = state_23131__$1;
(statearr_23179_23251[(2)] = null);

(statearr_23179_23251[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (23))){
var inst_23044 = (state_23131[(18)]);
var inst_23009 = (state_23131[(9)]);
var inst_23057 = (inst_23044 >= inst_23009);
var state_23131__$1 = state_23131;
var statearr_23180_23252 = state_23131__$1;
(statearr_23180_23252[(2)] = inst_23057);

(statearr_23180_23252[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (47))){
var inst_23011 = (state_23131[(30)]);
var state_23131__$1 = state_23131;
if(cljs.core.truth_(inst_23011)){
var statearr_23181_23253 = state_23131__$1;
(statearr_23181_23253[(1)] = (49));

} else {
var statearr_23182_23254 = state_23131__$1;
(statearr_23182_23254[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (35))){
var inst_23051 = (state_23131[(31)]);
var inst_23075 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23076 = [inst_23051];
var inst_23077 = (new cljs.core.PersistentVector(null,1,(5),inst_23075,inst_23076,null));
var inst_23078 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23077);
var state_23131__$1 = state_23131;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23131__$1,(38),inst_23078);
} else {
if((state_val_23132 === (19))){
var inst_23010 = (state_23131[(11)]);
var inst_23112 = (state_23131[(2)]);
var state_23131__$1 = (function (){var statearr_23183 = state_23131;
(statearr_23183[(14)] = inst_23112);

return statearr_23183;
})();
if(cljs.core.truth_(inst_23010)){
var statearr_23184_23255 = state_23131__$1;
(statearr_23184_23255[(1)] = (46));

} else {
var statearr_23185_23256 = state_23131__$1;
(statearr_23185_23256[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (11))){
var inst_23021 = (state_23131[(12)]);
var inst_23018 = (state_23131[(2)]);
var inst_23019 = fluree.db.util.async.throw_err(inst_23018);
var inst_23020 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_23019);
var inst_23021__$1 = cljs.core.not_empty(inst_23020);
var state_23131__$1 = (function (){var statearr_23187 = state_23131;
(statearr_23187[(12)] = inst_23021__$1);

return statearr_23187;
})();
if(cljs.core.truth_(inst_23021__$1)){
var statearr_23188_23257 = state_23131__$1;
(statearr_23188_23257[(1)] = (12));

} else {
var statearr_23189_23258 = state_23131__$1;
(statearr_23189_23258[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (9))){
var inst_22996 = (state_23131[(24)]);
var inst_23006 = (state_23131[(32)]);
var inst_23005 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22996,(0),null);
var inst_23006__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22996,(1),null);
var inst_23007 = cljs.core.__destructure_map(inst_23006__$1);
var inst_23008 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23007,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_23009 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23007,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_23010 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23007,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_23011 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23007,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_23012 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23007,new cljs.core.Keyword(null,"p","p",151049309));
var inst_23013 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23014 = [subject_id,inst_23005];
var inst_23015 = (new cljs.core.PersistentVector(null,2,(5),inst_23013,inst_23014,null));
var inst_23016 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_23015);
var state_23131__$1 = (function (){var statearr_23190 = state_23131;
(statearr_23190[(30)] = inst_23011);

(statearr_23190[(8)] = inst_23008);

(statearr_23190[(17)] = inst_23012);

(statearr_23190[(32)] = inst_23006__$1);

(statearr_23190[(9)] = inst_23009);

(statearr_23190[(11)] = inst_23010);

return statearr_23190;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23131__$1,(11),inst_23016);
} else {
if((state_val_23132 === (5))){
var _ = (function (){var statearr_23191 = state_23131;
(statearr_23191[(4)] = cljs.core.rest((state_23131[(4)])));

return statearr_23191;
})();
var state_23131__$1 = state_23131;
var ex23186 = (state_23131__$1[(2)]);
var statearr_23192_23259 = state_23131__$1;
(statearr_23192_23259[(5)] = ex23186);


if((ex23186 instanceof Error)){
var statearr_23193_23260 = state_23131__$1;
(statearr_23193_23260[(1)] = (4));

(statearr_23193_23260[(5)] = null);

} else {
throw ex23186;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (14))){
var inst_23025 = (state_23131[(2)]);
var state_23131__$1 = state_23131;
if(cljs.core.truth_(inst_23025)){
var statearr_23194_23261 = state_23131__$1;
(statearr_23194_23261[(1)] = (15));

} else {
var statearr_23195_23262 = state_23131__$1;
(statearr_23195_23262[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (45))){
var inst_23045 = (state_23131[(10)]);
var inst_23097 = (state_23131[(2)]);
var inst_23098 = fluree.db.util.async.throw_err(inst_23097);
var inst_23099 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23045,inst_23098);
var state_23131__$1 = state_23131;
var statearr_23196_23263 = state_23131__$1;
(statearr_23196_23263[(2)] = inst_23099);

(statearr_23196_23263[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (26))){
var inst_23045 = (state_23131[(10)]);
var state_23131__$1 = state_23131;
var statearr_23197_23264 = state_23131__$1;
(statearr_23197_23264[(2)] = inst_23045);

(statearr_23197_23264[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (16))){
var state_23131__$1 = state_23131;
var statearr_23198_23265 = state_23131__$1;
(statearr_23198_23265[(2)] = null);

(statearr_23198_23265[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (38))){
var inst_23081 = (state_23131[(21)]);
var inst_23006 = (state_23131[(32)]);
var inst_23080 = (state_23131[(2)]);
var inst_23081__$1 = fluree.db.util.async.throw_err(inst_23080);
var inst_23082 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23083 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_23084 = (new cljs.core.PersistentVector(null,4,(5),inst_23082,inst_23083,null));
var inst_23085 = cljs.core.select_keys(inst_23006,inst_23084);
var inst_23086 = cljs.core.empty_QMARK_(inst_23081__$1);
var state_23131__$1 = (function (){var statearr_23199 = state_23131;
(statearr_23199[(21)] = inst_23081__$1);

(statearr_23199[(22)] = inst_23085);

return statearr_23199;
})();
if(inst_23086){
var statearr_23200_23266 = state_23131__$1;
(statearr_23200_23266[(1)] = (39));

} else {
var statearr_23201_23267 = state_23131__$1;
(statearr_23201_23267[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (30))){
var inst_23008 = (state_23131[(8)]);
var state_23131__$1 = state_23131;
var statearr_23202_23268 = state_23131__$1;
(statearr_23202_23268[(2)] = inst_23008);

(statearr_23202_23268[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (10))){
var inst_23124 = (state_23131[(2)]);
var state_23131__$1 = state_23131;
var statearr_23203_23269 = state_23131__$1;
(statearr_23203_23269[(2)] = inst_23124);

(statearr_23203_23269[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (18))){
var inst_23053 = (state_23131[(7)]);
var inst_23051 = (state_23131[(31)]);
var inst_23043 = (state_23131[(20)]);
var inst_23050 = cljs.core.seq(inst_23043);
var inst_23051__$1 = cljs.core.first(inst_23050);
var inst_23052 = cljs.core.next(inst_23050);
var inst_23053__$1 = cljs.core.not(inst_23051__$1);
var state_23131__$1 = (function (){var statearr_23204 = state_23131;
(statearr_23204[(7)] = inst_23053__$1);

(statearr_23204[(31)] = inst_23051__$1);

(statearr_23204[(19)] = inst_23052);

return statearr_23204;
})();
if(inst_23053__$1){
var statearr_23205_23270 = state_23131__$1;
(statearr_23205_23270[(1)] = (20));

} else {
var statearr_23206_23271 = state_23131__$1;
(statearr_23206_23271[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (42))){
var inst_23081 = (state_23131[(21)]);
var inst_23090 = cljs.core.count(inst_23081);
var inst_23091 = fluree.db.query.fql.add_fuel(fuel,inst_23090,max_fuel);
var state_23131__$1 = state_23131;
var statearr_23207_23272 = state_23131__$1;
(statearr_23207_23272[(2)] = inst_23091);

(statearr_23207_23272[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (37))){
var inst_23106 = (state_23131[(2)]);
var state_23131__$1 = state_23131;
var statearr_23208_23273 = state_23131__$1;
(statearr_23208_23273[(2)] = inst_23106);

(statearr_23208_23273[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (8))){
var inst_22990 = (state_23131[(15)]);
var state_23131__$1 = state_23131;
var statearr_23209_23274 = state_23131__$1;
(statearr_23209_23274[(2)] = inst_22990);

(statearr_23209_23274[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23132 === (49))){
var inst_23011 = (state_23131[(30)]);
var state_23131__$1 = state_23131;
var statearr_23210_23275 = state_23131__$1;
(statearr_23210_23275[(2)] = inst_23011);

(statearr_23210_23275[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2717__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2717__auto____0 = (function (){
var statearr_23211 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23211[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2717__auto__);

(statearr_23211[(1)] = (1));

return statearr_23211;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2717__auto____1 = (function (state_23131){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_23131);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e23212){var ex__2720__auto__ = e23212;
var statearr_23213_23276 = state_23131;
(statearr_23213_23276[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_23131[(4)]))){
var statearr_23214_23277 = state_23131;
(statearr_23214_23277[(1)] = cljs.core.first((state_23131[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23278 = state_23131;
state_23131 = G__23278;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2717__auto__ = function(state_23131){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2717__auto____1.call(this,state_23131);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2717__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2717__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_23215 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_23215[(6)] = c__2739__auto__);

return statearr_23215;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4212__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__23279 = select_spec;
var map__23279__$1 = cljs.core.__destructure_map(map__23279);
var recur_seen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23279__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var recur_depth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23279__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
return cljs.core.select_keys(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057)], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687)], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"compact?","compact?",1216893298)], null));
});
/**
 * Performs recursion on a select spec graph crawl when specified. flakes input is list
 *   of flakes all with the same subject and predicate values.
 */
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flakes,select_spec,results,fuel,max_fuel,cache){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_23393){
var state_val_23394 = (state_23393[(1)]);
if((state_val_23394 === (7))){
var inst_23305 = flakes;
var inst_23306 = cljs.core.seq(inst_23305);
var inst_23307 = cljs.core.first(inst_23306);
var inst_23308 = cljs.core.next(inst_23306);
var inst_23309 = cljs.core.PersistentVector.EMPTY;
var inst_23310 = inst_23305;
var inst_23311 = (0);
var inst_23312 = inst_23309;
var state_23393__$1 = (function (){var statearr_23395 = state_23393;
(statearr_23395[(7)] = inst_23307);

(statearr_23395[(8)] = inst_23310);

(statearr_23395[(9)] = inst_23311);

(statearr_23395[(10)] = inst_23308);

(statearr_23395[(11)] = inst_23312);

return statearr_23395;
})();
var statearr_23396_23462 = state_23393__$1;
(statearr_23396_23462[(2)] = null);

(statearr_23396_23462[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23394 === (20))){
var state_23393__$1 = state_23393;
var statearr_23397_23463 = state_23393__$1;
(statearr_23397_23463[(2)] = results);

(statearr_23397_23463[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23394 === (27))){
var state_23393__$1 = state_23393;
var statearr_23398_23464 = state_23393__$1;
(statearr_23398_23464[(2)] = null);

(statearr_23398_23464[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23394 === (1))){
var state_23393__$1 = state_23393;
var statearr_23399_23465 = state_23393__$1;
(statearr_23399_23465[(2)] = null);

(statearr_23399_23465[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23394 === (24))){
var state_23393__$1 = state_23393;
var statearr_23400_23466 = state_23393__$1;
(statearr_23400_23466[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23394 === (39))){
var inst_23312 = (state_23393[(11)]);
var inst_23374 = (state_23393[(12)]);
var inst_23319 = (state_23393[(13)]);
var inst_23377 = (state_23393[(2)]);
var inst_23378 = fluree.db.util.async.throw_err(inst_23377);
var inst_23379 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23312,inst_23378);
var inst_23310 = inst_23319;
var inst_23311 = inst_23374;
var inst_23312__$1 = inst_23379;
var state_23393__$1 = (function (){var statearr_23402 = state_23393;
(statearr_23402[(8)] = inst_23310);

(statearr_23402[(9)] = inst_23311);

(statearr_23402[(11)] = inst_23312__$1);

return statearr_23402;
})();
var statearr_23403_23467 = state_23393__$1;
(statearr_23403_23467[(2)] = null);

(statearr_23403_23467[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23394 === (4))){
var inst_23280 = (state_23393[(2)]);
var state_23393__$1 = state_23393;
var statearr_23404_23468 = state_23393__$1;
(statearr_23404_23468[(2)] = inst_23280);

(statearr_23404_23468[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23394 === (15))){
var inst_23293 = (state_23393[(14)]);
var state_23393__$1 = state_23393;
var statearr_23405_23469 = state_23393__$1;
(statearr_23405_23469[(2)] = inst_23293);

(statearr_23405_23469[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23394 === (21))){
var inst_23289 = (state_23393[(15)]);
var state_23393__$1 = state_23393;
if(cljs.core.truth_(inst_23289)){
var statearr_23406_23470 = state_23393__$1;
(statearr_23406_23470[(1)] = (23));

} else {
var statearr_23407_23471 = state_23393__$1;
(statearr_23407_23471[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23394 === (31))){
var inst_23357 = (state_23393[(16)]);
var state_23393__$1 = state_23393;
var statearr_23408_23472 = state_23393__$1;
(statearr_23408_23472[(2)] = inst_23357);

(statearr_23408_23472[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23394 === (32))){
var inst_23349 = (state_23393[(17)]);
var inst_23363 = (state_23393[(2)]);
var state_23393__$1 = (function (){var statearr_23409 = state_23393;
(statearr_23409[(18)] = inst_23363);

return statearr_23409;
})();
if(cljs.core.truth_(inst_23349)){
var statearr_23410_23473 = state_23393__$1;
(statearr_23410_23473[(1)] = (33));

} else {
var statearr_23411_23474 = state_23393__$1;
(statearr_23411_23474[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23394 === (33))){
var inst_23349 = (state_23393[(17)]);
var state_23393__$1 = state_23393;
var statearr_23412_23475 = state_23393__$1;
(statearr_23412_23475[(2)] = inst_23349);

(statearr_23412_23475[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23394 === (13))){
var inst_23329 = (state_23393[(2)]);
var state_23393__$1 = state_23393;
if(cljs.core.truth_(inst_23329)){
var statearr_23414_23476 = state_23393__$1;
(statearr_23414_23476[(1)] = (17));

} else {
var statearr_23415_23477 = state_23393__$1;
(statearr_23415_23477[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23394 === (22))){
var inst_23346 = (state_23393[(2)]);
var state_23393__$1 = state_23393;
var statearr_23416_23478 = state_23393__$1;
(statearr_23416_23478[(2)] = inst_23346);

(statearr_23416_23478[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23394 === (36))){
var inst_23311 = (state_23393[(9)]);
var inst_23312 = (state_23393[(11)]);
var inst_23319 = (state_23393[(13)]);
var inst_23371 = (inst_23311 + (1));
var tmp23413 = inst_23312;
var inst_23310 = inst_23319;
var inst_23311__$1 = inst_23371;
var inst_23312__$1 = tmp23413;
var state_23393__$1 = (function (){var statearr_23417 = state_23393;
(statearr_23417[(8)] = inst_23310);

(statearr_23417[(9)] = inst_23311__$1);

(statearr_23417[(11)] = inst_23312__$1);

return statearr_23417;
})();
var statearr_23418_23479 = state_23393__$1;
(statearr_23418_23479[(2)] = null);

(statearr_23418_23479[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23394 === (29))){
var inst_23356 = (state_23393[(2)]);
var inst_23357 = fluree.db.util.async.throw_err(inst_23356);
var state_23393__$1 = (function (){var statearr_23419 = state_23393;
(statearr_23419[(16)] = inst_23357);

return statearr_23419;
})();
if(cljs.core.truth_(fuel)){
var statearr_23420_23480 = state_23393__$1;
(statearr_23420_23480[(1)] = (30));

} else {
var statearr_23421_23481 = state_23393__$1;
(statearr_23421_23481[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23394 === (6))){
var state_23393__$1 = state_23393;
var statearr_23422_23482 = state_23393__$1;
(statearr_23422_23482[(2)] = results);

(statearr_23422_23482[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23394 === (28))){
var inst_23342 = (state_23393[(2)]);
var state_23393__$1 = state_23393;
var statearr_23423_23483 = state_23393__$1;
(statearr_23423_23483[(2)] = inst_23342);

(statearr_23423_23483[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23394 === (25))){
var inst_23344 = (state_23393[(2)]);
var state_23393__$1 = state_23393;
var statearr_23424_23484 = state_23393__$1;
(statearr_23424_23484[(2)] = inst_23344);

(statearr_23424_23484[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23394 === (34))){
var inst_23363 = (state_23393[(18)]);
var inst_23366 = cljs.core.empty_QMARK_(inst_23363);
var state_23393__$1 = state_23393;
var statearr_23425_23485 = state_23393__$1;
(statearr_23425_23485[(2)] = inst_23366);

(statearr_23425_23485[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23394 === (17))){
var inst_23312 = (state_23393[(11)]);
var inst_23331 = cljs.core.empty_QMARK_(inst_23312);
var state_23393__$1 = state_23393;
if(inst_23331){
var statearr_23426_23486 = state_23393__$1;
(statearr_23426_23486[(1)] = (20));

} else {
var statearr_23427_23487 = state_23393__$1;
(statearr_23427_23487[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23394 === (3))){
var inst_23391 = (state_23393[(2)]);
var state_23393__$1 = state_23393;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23393__$1,inst_23391);
} else {
if((state_val_23394 === (12))){
var inst_23293 = (state_23393[(14)]);
var state_23393__$1 = state_23393;
if(cljs.core.truth_(inst_23293)){
var statearr_23428_23488 = state_23393__$1;
(statearr_23428_23488[(1)] = (14));

} else {
var statearr_23429_23489 = state_23393__$1;
(statearr_23429_23489[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23394 === (2))){
var _ = (function (){var statearr_23430 = state_23393;
(statearr_23430[(4)] = cljs.core.cons((5),(state_23393[(4)])));

return statearr_23430;
})();
var inst_23287 = select_spec;
var inst_23288 = cljs.core.__destructure_map(inst_23287);
var inst_23289 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23288,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_23290 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23288,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_23291 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23288,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var inst_23292 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23288,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
var inst_23293 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23288,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_23294 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(select_spec);
var inst_23295 = (inst_23292 > inst_23294);
var state_23393__$1 = (function (){var statearr_23431 = state_23393;
(statearr_23431[(15)] = inst_23289);

(statearr_23431[(19)] = inst_23291);

(statearr_23431[(20)] = inst_23290);

(statearr_23431[(14)] = inst_23293);

return statearr_23431;
})();
if(cljs.core.truth_(inst_23295)){
var statearr_23432_23490 = state_23393__$1;
(statearr_23432_23490[(1)] = (6));

} else {
var statearr_23433_23491 = state_23393__$1;
(statearr_23433_23491[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23394 === (23))){
var inst_23312 = (state_23393[(11)]);
var inst_23290 = (state_23393[(20)]);
var inst_23335 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_23290,inst_23312);
var state_23393__$1 = state_23393;
var statearr_23434_23492 = state_23393__$1;
(statearr_23434_23492[(2)] = inst_23335);

(statearr_23434_23492[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23394 === (35))){
var inst_23318 = (state_23393[(21)]);
var inst_23368 = (state_23393[(2)]);
var inst_23369 = fluree.db.query.fql.recur_select_spec(select_spec,inst_23318);
var state_23393__$1 = (function (){var statearr_23435 = state_23393;
(statearr_23435[(22)] = inst_23369);

return statearr_23435;
})();
if(cljs.core.truth_(inst_23368)){
var statearr_23436_23493 = state_23393__$1;
(statearr_23436_23493[(1)] = (36));

} else {
var statearr_23437_23494 = state_23393__$1;
(statearr_23437_23494[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23394 === (19))){
var inst_23384 = (state_23393[(2)]);
var state_23393__$1 = state_23393;
var statearr_23438_23495 = state_23393__$1;
(statearr_23438_23495[(2)] = inst_23384);

(statearr_23438_23495[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23394 === (11))){
var inst_23320 = (state_23393[(23)]);
var state_23393__$1 = state_23393;
var statearr_23440_23496 = state_23393__$1;
(statearr_23440_23496[(2)] = inst_23320);

(statearr_23440_23496[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23394 === (9))){
var inst_23320 = (state_23393[(23)]);
var inst_23310 = (state_23393[(8)]);
var inst_23318 = (state_23393[(21)]);
var inst_23317 = cljs.core.seq(inst_23310);
var inst_23318__$1 = cljs.core.first(inst_23317);
var inst_23319 = cljs.core.next(inst_23317);
var inst_23320__$1 = cljs.core.not(inst_23318__$1);
var state_23393__$1 = (function (){var statearr_23441 = state_23393;
(statearr_23441[(23)] = inst_23320__$1);

(statearr_23441[(21)] = inst_23318__$1);

(statearr_23441[(13)] = inst_23319);

return statearr_23441;
})();
if(inst_23320__$1){
var statearr_23442_23497 = state_23393__$1;
(statearr_23442_23497[(1)] = (11));

} else {
var statearr_23443_23498 = state_23393__$1;
(statearr_23443_23498[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23394 === (5))){
var _ = (function (){var statearr_23444 = state_23393;
(statearr_23444[(4)] = cljs.core.rest((state_23393[(4)])));

return statearr_23444;
})();
var state_23393__$1 = state_23393;
var ex23439 = (state_23393__$1[(2)]);
var statearr_23445_23499 = state_23393__$1;
(statearr_23445_23499[(5)] = ex23439);


if((ex23439 instanceof Error)){
var statearr_23446_23500 = state_23393__$1;
(statearr_23446_23500[(1)] = (4));

(statearr_23446_23500[(5)] = null);

} else {
throw ex23439;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23394 === (14))){
var inst_23311 = (state_23393[(9)]);
var inst_23293 = (state_23393[(14)]);
var inst_23324 = (inst_23311 < inst_23293);
var state_23393__$1 = state_23393;
var statearr_23447_23501 = state_23393__$1;
(statearr_23447_23501[(2)] = inst_23324);

(statearr_23447_23501[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23394 === (26))){
var inst_23312 = (state_23393[(11)]);
var inst_23290 = (state_23393[(20)]);
var inst_23338 = cljs.core.first(inst_23312);
var inst_23339 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_23290,inst_23338);
var state_23393__$1 = state_23393;
var statearr_23448_23502 = state_23393__$1;
(statearr_23448_23502[(2)] = inst_23339);

(statearr_23448_23502[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23394 === (16))){
var inst_23327 = (state_23393[(2)]);
var state_23393__$1 = state_23393;
var statearr_23449_23503 = state_23393__$1;
(statearr_23449_23503[(2)] = inst_23327);

(statearr_23449_23503[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23394 === (38))){
var inst_23382 = (state_23393[(2)]);
var state_23393__$1 = state_23393;
var statearr_23450_23504 = state_23393__$1;
(statearr_23450_23504[(2)] = inst_23382);

(statearr_23450_23504[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23394 === (30))){
var inst_23357 = (state_23393[(16)]);
var inst_23359 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_23360 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_23359,inst_23357);
var state_23393__$1 = state_23393;
var statearr_23451_23505 = state_23393__$1;
(statearr_23451_23505[(2)] = inst_23360);

(statearr_23451_23505[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23394 === (10))){
var inst_23386 = (state_23393[(2)]);
var state_23393__$1 = state_23393;
var statearr_23452_23506 = state_23393__$1;
(statearr_23452_23506[(2)] = inst_23386);

(statearr_23452_23506[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23394 === (18))){
var inst_23318 = (state_23393[(21)]);
var inst_23291 = (state_23393[(19)]);
var inst_23348 = inst_23318.o;
var inst_23349 = cljs.core.contains_QMARK_(inst_23291,inst_23348);
var inst_23351 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23352 = [inst_23348];
var inst_23353 = (new cljs.core.PersistentVector(null,1,(5),inst_23351,inst_23352,null));
var inst_23354 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23353);
var state_23393__$1 = (function (){var statearr_23453 = state_23393;
(statearr_23453[(17)] = inst_23349);

return statearr_23453;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23393__$1,(29),inst_23354);
} else {
if((state_val_23394 === (37))){
var inst_23311 = (state_23393[(9)]);
var inst_23363 = (state_23393[(18)]);
var inst_23369 = (state_23393[(22)]);
var inst_23374 = (inst_23311 + (1));
var inst_23375 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_23369,inst_23363) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_23369,inst_23363));
var state_23393__$1 = (function (){var statearr_23454 = state_23393;
(statearr_23454[(12)] = inst_23374);

return statearr_23454;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23393__$1,(39),inst_23375);
} else {
if((state_val_23394 === (8))){
var inst_23388 = (state_23393[(2)]);
var _ = (function (){var statearr_23455 = state_23393;
(statearr_23455[(4)] = cljs.core.rest((state_23393[(4)])));

return statearr_23455;
})();
var state_23393__$1 = state_23393;
var statearr_23456_23507 = state_23393__$1;
(statearr_23456_23507[(2)] = inst_23388);

(statearr_23456_23507[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2717__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2717__auto____0 = (function (){
var statearr_23457 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23457[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__2717__auto__);

(statearr_23457[(1)] = (1));

return statearr_23457;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2717__auto____1 = (function (state_23393){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_23393);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e23458){var ex__2720__auto__ = e23458;
var statearr_23459_23508 = state_23393;
(statearr_23459_23508[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_23393[(4)]))){
var statearr_23460_23509 = state_23393;
(statearr_23460_23509[(1)] = cljs.core.first((state_23393[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23510 = state_23393;
state_23393 = G__23510;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__2717__auto__ = function(state_23393){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2717__auto____1.call(this,state_23393);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2717__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2717__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_23461 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_23461[(6)] = c__2739__auto__);

return statearr_23461;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_23691){
var state_val_23692 = (state_23691[(1)]);
if((state_val_23692 === (7))){
var state_23691__$1 = state_23691;
var statearr_23693_23779 = state_23691__$1;
(statearr_23693_23779[(2)] = null);

(statearr_23693_23779[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (20))){
var inst_23549 = cljs.core.PersistentHashMap.EMPTY;
var state_23691__$1 = state_23691;
var statearr_23694_23780 = state_23691__$1;
(statearr_23694_23780[(2)] = inst_23549);

(statearr_23694_23780[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (27))){
var inst_23567 = (state_23691[(7)]);
var inst_23537 = (state_23691[(8)]);
var inst_23551 = (state_23691[(9)]);
var inst_23531 = (state_23691[(10)]);
var inst_23670 = (state_23691[(2)]);
var inst_23671 = (function (){var top_level_subject = inst_23531;
var select_spec = inst_23537;
var base_acc = inst_23551;
var acc_PLUS_refs = inst_23567;
var result = inst_23670;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4212__auto__ = (function (){var and__4210__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4210__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4210__auto__;
}
})();
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var and__4210__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4210__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4210__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_23672 = cljs.core.PersistentVector.EMPTY;
var inst_23673 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23537);
var inst_23674 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_23673);
var inst_23675 = cljs.core.vals(inst_23674);
var inst_23676 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23537);
var inst_23677 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_23676);
var inst_23678 = cljs.core.vals(inst_23677);
var inst_23679 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_23675,inst_23678);
var inst_23680 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_23671,inst_23672,inst_23679);
var inst_23682 = (function (){var top_level_subject = inst_23531;
var select_spec = inst_23537;
var base_acc = inst_23551;
var acc_PLUS_refs = inst_23567;
var result = inst_23670;
var sort_preds = inst_23680;
return (function (acc,p__23681){
var vec__23695 = p__23681;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23695,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23695,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23695,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23695,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_23683 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_23682,inst_23670,inst_23680);
var state_23691__$1 = state_23691;
var statearr_23698_23781 = state_23691__$1;
(statearr_23698_23781[(2)] = inst_23683);

(statearr_23698_23781[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (1))){
var state_23691__$1 = state_23691;
var statearr_23699_23782 = state_23691__$1;
(statearr_23699_23782[(2)] = null);

(statearr_23699_23782[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (24))){
var inst_23567 = (state_23691[(7)]);
var inst_23567__$1 = (state_23691[(2)]);
var inst_23568 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"p","p",151049309),flakes);
var inst_23569 = cljs.core.PersistentHashMap.EMPTY;
var inst_23570 = inst_23568;
var inst_23571 = inst_23567__$1;
var inst_23572 = inst_23569;
var state_23691__$1 = (function (){var statearr_23700 = state_23691;
(statearr_23700[(7)] = inst_23567__$1);

(statearr_23700[(11)] = inst_23571);

(statearr_23700[(12)] = inst_23570);

(statearr_23700[(13)] = inst_23572);

return statearr_23700;
})();
var statearr_23701_23783 = state_23691__$1;
(statearr_23701_23783[(2)] = null);

(statearr_23701_23783[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (39))){
var inst_23571 = (state_23691[(11)]);
var inst_23537 = (state_23691[(8)]);
var inst_23580 = (state_23691[(14)]);
var inst_23587 = (state_23691[(15)]);
var inst_23616 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23617 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_23571,inst_23537,inst_23580,inst_23587,false);
var state_23691__$1 = (function (){var statearr_23702 = state_23691;
(statearr_23702[(16)] = inst_23616);

return statearr_23702;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23691__$1,(42),inst_23617);
} else {
if((state_val_23692 === (46))){
var inst_23580 = (state_23691[(14)]);
var inst_23570 = (state_23691[(12)]);
var inst_23572 = (state_23691[(13)]);
var inst_23634 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23635 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23636 = cljs.core.first(inst_23580);
var inst_23637 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_23636);
var inst_23638 = [inst_23637];
var inst_23639 = cljs.core.PersistentHashMap.fromArrays(inst_23635,inst_23638);
var inst_23640 = cljs.core.rest(inst_23570);
var inst_23641 = [inst_23639,inst_23640,inst_23572];
var inst_23642 = (new cljs.core.PersistentVector(null,3,(5),inst_23634,inst_23641,null));
var state_23691__$1 = state_23691;
var statearr_23703_23784 = state_23691__$1;
(statearr_23703_23784[(2)] = inst_23642);

(statearr_23703_23784[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (4))){
var inst_23511 = (state_23691[(2)]);
var state_23691__$1 = state_23691;
var statearr_23704_23785 = state_23691__$1;
(statearr_23704_23785[(2)] = inst_23511);

(statearr_23704_23785[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (15))){
var inst_23537 = (state_23691[(8)]);
var inst_23538 = (state_23691[(17)]);
var inst_23537__$1 = (state_23691[(2)]);
var inst_23538__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23537__$1);
var state_23691__$1 = (function (){var statearr_23705 = state_23691;
(statearr_23705[(8)] = inst_23537__$1);

(statearr_23705[(17)] = inst_23538__$1);

return statearr_23705;
})();
if(cljs.core.truth_(inst_23538__$1)){
var statearr_23706_23786 = state_23691__$1;
(statearr_23706_23786[(1)] = (16));

} else {
var statearr_23707_23787 = state_23691__$1;
(statearr_23707_23787[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (48))){
var inst_23653 = (state_23691[(2)]);
var state_23691__$1 = state_23691;
var statearr_23708_23788 = state_23691__$1;
(statearr_23708_23788[(2)] = inst_23653);

(statearr_23708_23788[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (50))){
var state_23691__$1 = state_23691;
var statearr_23709_23789 = state_23691__$1;
(statearr_23709_23789[(2)] = null);

(statearr_23709_23789[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (21))){
var inst_23537 = (state_23691[(8)]);
var inst_23551 = (state_23691[(2)]);
var inst_23552 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23553 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_23554 = (new cljs.core.PersistentVector(null,2,(5),inst_23552,inst_23553,null));
var inst_23555 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_23537,inst_23554);
var state_23691__$1 = (function (){var statearr_23710 = state_23691;
(statearr_23710[(9)] = inst_23551);

return statearr_23710;
})();
if(cljs.core.truth_(inst_23555)){
var statearr_23711_23790 = state_23691__$1;
(statearr_23711_23790[(1)] = (22));

} else {
var statearr_23712_23791 = state_23691__$1;
(statearr_23712_23791[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (31))){
var inst_23571 = (state_23691[(11)]);
var inst_23580 = (state_23691[(14)]);
var inst_23586 = (state_23691[(18)]);
var inst_23590 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23591 = fluree.db.query.fql.flake__GT_recur(db,inst_23580,inst_23586,inst_23571,fuel,max_fuel,cache);
var state_23691__$1 = (function (){var statearr_23713 = state_23691;
(statearr_23713[(19)] = inst_23590);

return statearr_23713;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23691__$1,(34),inst_23591);
} else {
if((state_val_23692 === (32))){
var inst_23586 = (state_23691[(18)]);
var state_23691__$1 = state_23691;
if(cljs.core.truth_(inst_23586)){
var statearr_23714_23792 = state_23691__$1;
(statearr_23714_23792[(1)] = (35));

} else {
var statearr_23715_23793 = state_23691__$1;
(statearr_23715_23793[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (40))){
var inst_23537 = (state_23691[(8)]);
var inst_23627 = (state_23691[(20)]);
var inst_23626 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23537);
var inst_23627__$1 = cljs.core.empty_QMARK_(inst_23626);
var state_23691__$1 = (function (){var statearr_23716 = state_23691;
(statearr_23716[(20)] = inst_23627__$1);

return statearr_23716;
})();
if(inst_23627__$1){
var statearr_23717_23794 = state_23691__$1;
(statearr_23717_23794[(1)] = (43));

} else {
var statearr_23718_23795 = state_23691__$1;
(statearr_23718_23795[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (33))){
var inst_23580 = (state_23691[(14)]);
var inst_23659 = (state_23691[(2)]);
var inst_23660 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23659,(0),null);
var inst_23661 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23659,(1),null);
var inst_23662 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23659,(2),null);
var inst_23663 = cljs.core.first(inst_23580);
var inst_23664 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_23663);
var inst_23665 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_23660,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_23664);
var inst_23570 = inst_23661;
var inst_23571 = inst_23665;
var inst_23572 = inst_23662;
var state_23691__$1 = (function (){var statearr_23719 = state_23691;
(statearr_23719[(11)] = inst_23571);

(statearr_23719[(12)] = inst_23570);

(statearr_23719[(13)] = inst_23572);

return statearr_23719;
})();
var statearr_23720_23796 = state_23691__$1;
(statearr_23720_23796[(2)] = null);

(statearr_23720_23796[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (13))){
var inst_23531 = (state_23691[(10)]);
var inst_23534 = fluree.db.query.fql.full_select_spec(db,cache,base_select_spec,inst_23531);
var state_23691__$1 = state_23691;
var statearr_23721_23797 = state_23691__$1;
(statearr_23721_23797[(2)] = inst_23534);

(statearr_23721_23797[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (22))){
var inst_23537 = (state_23691[(8)]);
var inst_23557 = cljs.core.first(flakes);
var inst_23558 = fluree.db.query.fql.s(inst_23557);
var inst_23559 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_23537);
var inst_23560 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_23558,inst_23559);
var state_23691__$1 = state_23691;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23691__$1,(25),inst_23560);
} else {
if((state_val_23692 === (36))){
var inst_23537 = (state_23691[(8)]);
var inst_23614 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23537);
var state_23691__$1 = state_23691;
if(cljs.core.truth_(inst_23614)){
var statearr_23722_23798 = state_23691__$1;
(statearr_23722_23798[(1)] = (39));

} else {
var statearr_23723_23799 = state_23691__$1;
(statearr_23723_23799[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (41))){
var inst_23655 = (state_23691[(2)]);
var state_23691__$1 = state_23691;
var statearr_23724_23800 = state_23691__$1;
(statearr_23724_23800[(2)] = inst_23655);

(statearr_23724_23800[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (43))){
var inst_23537 = (state_23691[(8)]);
var inst_23629 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23537);
var state_23691__$1 = state_23691;
var statearr_23725_23801 = state_23691__$1;
(statearr_23725_23801[(2)] = inst_23629);

(statearr_23725_23801[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (29))){
var inst_23537 = (state_23691[(8)]);
var inst_23580 = (state_23691[(14)]);
var inst_23586 = (state_23691[(18)]);
var inst_23570 = (state_23691[(12)]);
var inst_23580__$1 = cljs.core.first(inst_23570);
var inst_23581 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23582 = cljs.core.first(inst_23580__$1);
var inst_23583 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_23582);
var inst_23584 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_23583];
var inst_23585 = (new cljs.core.PersistentVector(null,3,(5),inst_23581,inst_23584,null));
var inst_23586__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_23537,inst_23585);
var inst_23587 = fluree.db.query.fql.component_follow_QMARK_(inst_23586__$1,inst_23537);
var inst_23588 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_23586__$1);
var state_23691__$1 = (function (){var statearr_23726 = state_23691;
(statearr_23726[(14)] = inst_23580__$1);

(statearr_23726[(18)] = inst_23586__$1);

(statearr_23726[(15)] = inst_23587);

return statearr_23726;
})();
if(cljs.core.truth_(inst_23588)){
var statearr_23727_23802 = state_23691__$1;
(statearr_23727_23802[(1)] = (31));

} else {
var statearr_23728_23803 = state_23691__$1;
(statearr_23728_23803[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (44))){
var inst_23627 = (state_23691[(20)]);
var state_23691__$1 = state_23691;
var statearr_23729_23804 = state_23691__$1;
(statearr_23729_23804[(2)] = inst_23627);

(statearr_23729_23804[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (6))){
var state_23691__$1 = state_23691;
var statearr_23730_23805 = state_23691__$1;
(statearr_23730_23805[(2)] = null);

(statearr_23730_23805[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (28))){
var inst_23571 = (state_23691[(11)]);
var state_23691__$1 = state_23691;
var statearr_23731_23806 = state_23691__$1;
(statearr_23731_23806[(2)] = inst_23571);

(statearr_23731_23806[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (51))){
var inst_23651 = (state_23691[(2)]);
var state_23691__$1 = state_23691;
var statearr_23732_23807 = state_23691__$1;
(statearr_23732_23807[(2)] = inst_23651);

(statearr_23732_23807[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (25))){
var inst_23551 = (state_23691[(9)]);
var inst_23562 = (state_23691[(2)]);
var inst_23563 = fluree.db.util.async.throw_err(inst_23562);
var inst_23564 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_23551,inst_23563], 0));
var state_23691__$1 = state_23691;
var statearr_23733_23808 = state_23691__$1;
(statearr_23733_23808[(2)] = inst_23564);

(statearr_23733_23808[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (34))){
var inst_23590 = (state_23691[(19)]);
var inst_23570 = (state_23691[(12)]);
var inst_23572 = (state_23691[(13)]);
var inst_23593 = (state_23691[(2)]);
var inst_23594 = fluree.db.util.async.throw_err(inst_23593);
var inst_23595 = cljs.core.rest(inst_23570);
var inst_23596 = [inst_23594,inst_23595,inst_23572];
var inst_23597 = (new cljs.core.PersistentVector(null,3,(5),inst_23590,inst_23596,null));
var state_23691__$1 = state_23691;
var statearr_23734_23809 = state_23691__$1;
(statearr_23734_23809[(2)] = inst_23597);

(statearr_23734_23809[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (17))){
var inst_23537 = (state_23691[(8)]);
var inst_23541 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23537);
var state_23691__$1 = state_23691;
var statearr_23736_23810 = state_23691__$1;
(statearr_23736_23810[(2)] = inst_23541);

(statearr_23736_23810[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (3))){
var inst_23689 = (state_23691[(2)]);
var state_23691__$1 = state_23691;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23691__$1,inst_23689);
} else {
if((state_val_23692 === (12))){
var _ = (function (){var statearr_23737 = state_23691;
(statearr_23737[(4)] = cljs.core.rest((state_23691[(4)])));

return statearr_23737;
})();
var state_23691__$1 = state_23691;
var ex23735 = (state_23691__$1[(2)]);
var statearr_23738_23811 = state_23691__$1;
(statearr_23738_23811[(5)] = ex23735);


var statearr_23739_23812 = state_23691__$1;
(statearr_23739_23812[(1)] = (11));

(statearr_23739_23812[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (2))){
var _ = (function (){var statearr_23740 = state_23691;
(statearr_23740[(4)] = cljs.core.cons((5),(state_23691[(4)])));

return statearr_23740;
})();
var inst_23517 = cljs.core.not_empty(flakes);
var state_23691__$1 = state_23691;
if(cljs.core.truth_(inst_23517)){
var statearr_23741_23813 = state_23691__$1;
(statearr_23741_23813[(1)] = (6));

} else {
var statearr_23742_23814 = state_23691__$1;
(statearr_23742_23814[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (23))){
var inst_23551 = (state_23691[(9)]);
var state_23691__$1 = state_23691;
var statearr_23743_23815 = state_23691__$1;
(statearr_23743_23815[(2)] = inst_23551);

(statearr_23743_23815[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (47))){
var state_23691__$1 = state_23691;
var statearr_23744_23816 = state_23691__$1;
(statearr_23744_23816[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (35))){
var inst_23571 = (state_23691[(11)]);
var inst_23580 = (state_23691[(14)]);
var inst_23586 = (state_23691[(18)]);
var inst_23587 = (state_23691[(15)]);
var inst_23572 = (state_23691[(13)]);
var inst_23603 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_23571,inst_23586,inst_23580,inst_23587,false,inst_23572);
var state_23691__$1 = state_23691;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23691__$1,(38),inst_23603);
} else {
if((state_val_23692 === (19))){
var inst_23531 = (state_23691[(10)]);
var inst_23545 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23546 = [inst_23531];
var inst_23547 = cljs.core.PersistentHashMap.fromArrays(inst_23545,inst_23546);
var state_23691__$1 = state_23691;
var statearr_23746_23817 = state_23691__$1;
(statearr_23746_23817[(2)] = inst_23547);

(statearr_23746_23817[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (11))){
var inst_23519 = (state_23691[(2)]);
var inst_23520 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_23519], 0));
var inst_23521 = (function(){throw inst_23519})();
var state_23691__$1 = (function (){var statearr_23748 = state_23691;
(statearr_23748[(21)] = inst_23520);

return statearr_23748;
})();
var statearr_23749_23818 = state_23691__$1;
(statearr_23749_23818[(2)] = inst_23521);

(statearr_23749_23818[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (9))){
var _ = (function (){var statearr_23750 = state_23691;
(statearr_23750[(4)] = cljs.core.cons((12),(state_23691[(4)])));

return statearr_23750;
})();
var inst_23527 = cljs.core.first(flakes);
var inst_23528 = fluree.db.query.fql.s(inst_23527);
var ___$1 = (function (){var statearr_23751 = state_23691;
(statearr_23751[(4)] = cljs.core.rest((state_23691[(4)])));

return statearr_23751;
})();
var state_23691__$1 = state_23691;
var statearr_23752_23819 = state_23691__$1;
(statearr_23752_23819[(2)] = inst_23528);

(statearr_23752_23819[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (5))){
var _ = (function (){var statearr_23753 = state_23691;
(statearr_23753[(4)] = cljs.core.rest((state_23691[(4)])));

return statearr_23753;
})();
var state_23691__$1 = state_23691;
var ex23747 = (state_23691__$1[(2)]);
var statearr_23754_23820 = state_23691__$1;
(statearr_23754_23820[(5)] = ex23747);


if((ex23747 instanceof Error)){
var statearr_23755_23821 = state_23691__$1;
(statearr_23755_23821[(1)] = (4));

(statearr_23755_23821[(5)] = null);

} else {
throw ex23747;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (14))){
var state_23691__$1 = state_23691;
var statearr_23756_23822 = state_23691__$1;
(statearr_23756_23822[(2)] = base_select_spec);

(statearr_23756_23822[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (45))){
var inst_23632 = (state_23691[(2)]);
var state_23691__$1 = state_23691;
if(cljs.core.truth_(inst_23632)){
var statearr_23757_23823 = state_23691__$1;
(statearr_23757_23823[(1)] = (46));

} else {
var statearr_23758_23824 = state_23691__$1;
(statearr_23758_23824[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (26))){
var inst_23570 = (state_23691[(12)]);
var inst_23574 = cljs.core.empty_QMARK_(inst_23570);
var state_23691__$1 = state_23691;
if(inst_23574){
var statearr_23759_23825 = state_23691__$1;
(statearr_23759_23825[(1)] = (28));

} else {
var statearr_23760_23826 = state_23691__$1;
(statearr_23760_23826[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (16))){
var inst_23538 = (state_23691[(17)]);
var state_23691__$1 = state_23691;
var statearr_23761_23827 = state_23691__$1;
(statearr_23761_23827[(2)] = inst_23538);

(statearr_23761_23827[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (38))){
var inst_23570 = (state_23691[(12)]);
var inst_23605 = (state_23691[(2)]);
var inst_23606 = fluree.db.util.async.throw_err(inst_23605);
var inst_23607 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23606,(0),null);
var inst_23608 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23606,(1),null);
var inst_23609 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23610 = cljs.core.rest(inst_23570);
var inst_23611 = [inst_23607,inst_23610,inst_23608];
var inst_23612 = (new cljs.core.PersistentVector(null,3,(5),inst_23609,inst_23611,null));
var state_23691__$1 = state_23691;
var statearr_23762_23828 = state_23691__$1;
(statearr_23762_23828[(2)] = inst_23612);

(statearr_23762_23828[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (30))){
var inst_23668 = (state_23691[(2)]);
var state_23691__$1 = state_23691;
var statearr_23763_23829 = state_23691__$1;
(statearr_23763_23829[(2)] = inst_23668);

(statearr_23763_23829[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (10))){
var inst_23531 = (state_23691[(2)]);
var inst_23532 = fluree.db.query.fql.has_ns_lookups_QMARK_(base_select_spec);
var state_23691__$1 = (function (){var statearr_23764 = state_23691;
(statearr_23764[(10)] = inst_23531);

return statearr_23764;
})();
if(cljs.core.truth_(inst_23532)){
var statearr_23765_23830 = state_23691__$1;
(statearr_23765_23830[(1)] = (13));

} else {
var statearr_23766_23831 = state_23691__$1;
(statearr_23766_23831[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (18))){
var inst_23543 = (state_23691[(2)]);
var state_23691__$1 = state_23691;
if(cljs.core.truth_(inst_23543)){
var statearr_23767_23832 = state_23691__$1;
(statearr_23767_23832[(1)] = (19));

} else {
var statearr_23768_23833 = state_23691__$1;
(statearr_23768_23833[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (42))){
var inst_23616 = (state_23691[(16)]);
var inst_23570 = (state_23691[(12)]);
var inst_23572 = (state_23691[(13)]);
var inst_23619 = (state_23691[(2)]);
var inst_23620 = fluree.db.util.async.throw_err(inst_23619);
var inst_23621 = cljs.core.first(inst_23620);
var inst_23622 = cljs.core.rest(inst_23570);
var inst_23623 = [inst_23621,inst_23622,inst_23572];
var inst_23624 = (new cljs.core.PersistentVector(null,3,(5),inst_23616,inst_23623,null));
var state_23691__$1 = state_23691;
var statearr_23769_23834 = state_23691__$1;
(statearr_23769_23834[(2)] = inst_23624);

(statearr_23769_23834[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (37))){
var inst_23657 = (state_23691[(2)]);
var state_23691__$1 = state_23691;
var statearr_23770_23835 = state_23691__$1;
(statearr_23770_23835[(2)] = inst_23657);

(statearr_23770_23835[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (8))){
var inst_23686 = (state_23691[(2)]);
var _ = (function (){var statearr_23771 = state_23691;
(statearr_23771[(4)] = cljs.core.rest((state_23691[(4)])));

return statearr_23771;
})();
var state_23691__$1 = state_23691;
var statearr_23772_23836 = state_23691__$1;
(statearr_23772_23836[(2)] = inst_23686);

(statearr_23772_23836[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23692 === (49))){
var inst_23571 = (state_23691[(11)]);
var inst_23570 = (state_23691[(12)]);
var inst_23572 = (state_23691[(13)]);
var inst_23645 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23646 = cljs.core.rest(inst_23570);
var inst_23647 = [inst_23571,inst_23646,inst_23572];
var inst_23648 = (new cljs.core.PersistentVector(null,3,(5),inst_23645,inst_23647,null));
var state_23691__$1 = state_23691;
var statearr_23773_23837 = state_23691__$1;
(statearr_23773_23837[(2)] = inst_23648);

(statearr_23773_23837[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2717__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2717__auto____0 = (function (){
var statearr_23774 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23774[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__2717__auto__);

(statearr_23774[(1)] = (1));

return statearr_23774;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2717__auto____1 = (function (state_23691){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_23691);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e23775){var ex__2720__auto__ = e23775;
var statearr_23776_23838 = state_23691;
(statearr_23776_23838[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_23691[(4)]))){
var statearr_23777_23839 = state_23691;
(statearr_23777_23839[(1)] = cljs.core.first((state_23691[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23840 = state_23691;
state_23691 = G__23840;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__2717__auto__ = function(state_23691){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2717__auto____1.call(this,state_23691);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2717__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2717__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_23778 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_23778[(6)] = c__2739__auto__);

return statearr_23778;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__23843 = arguments.length;
switch (G__23843) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_23885){
var state_val_23886 = (state_23885[(1)]);
if((state_val_23886 === (7))){
var inst_23851 = (state_23885[(7)]);
var state_23885__$1 = state_23885;
var statearr_23887_23917 = state_23885__$1;
(statearr_23887_23917[(2)] = inst_23851);

(statearr_23887_23917[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23886 === (1))){
var state_23885__$1 = state_23885;
var statearr_23888_23918 = state_23885__$1;
(statearr_23888_23918[(2)] = null);

(statearr_23888_23918[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23886 === (4))){
var inst_23844 = (state_23885[(2)]);
var state_23885__$1 = state_23885;
var statearr_23889_23919 = state_23885__$1;
(statearr_23889_23919[(2)] = inst_23844);

(statearr_23889_23919[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23886 === (15))){
var inst_23879 = (state_23885[(2)]);
var inst_23880 = fluree.db.util.async.throw_err(inst_23879);
var _ = (function (){var statearr_23890 = state_23885;
(statearr_23890[(4)] = cljs.core.rest((state_23885[(4)])));

return statearr_23890;
})();
var state_23885__$1 = state_23885;
var statearr_23891_23920 = state_23885__$1;
(statearr_23891_23920[(2)] = inst_23880);

(statearr_23891_23920[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23886 === (13))){
var inst_23863 = (state_23885[(8)]);
var state_23885__$1 = state_23885;
var statearr_23892_23921 = state_23885__$1;
(statearr_23892_23921[(2)] = inst_23863);

(statearr_23892_23921[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23886 === (6))){
var inst_23851 = (state_23885[(7)]);
var inst_23853 = fluree.db.query.fql.fuel_flakes_transducer(fuel,max_fuel);
var inst_23854 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_23851,inst_23853);
var state_23885__$1 = state_23885;
var statearr_23893_23922 = state_23885__$1;
(statearr_23893_23922[(2)] = inst_23854);

(statearr_23893_23922[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23886 === (3))){
var inst_23883 = (state_23885[(2)]);
var state_23885__$1 = state_23885;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23885__$1,inst_23883);
} else {
if((state_val_23886 === (12))){
var inst_23863 = (state_23885[(8)]);
var inst_23865 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_23866 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_23863,inst_23865);
var state_23885__$1 = state_23885;
var statearr_23894_23923 = state_23885__$1;
(statearr_23894_23923[(2)] = inst_23866);

(statearr_23894_23923[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23886 === (2))){
var _ = (function (){var statearr_23895 = state_23885;
(statearr_23895[(4)] = cljs.core.cons((5),(state_23885[(4)])));

return statearr_23895;
})();
var inst_23851 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_23885__$1 = (function (){var statearr_23896 = state_23885;
(statearr_23896[(7)] = inst_23851);

return statearr_23896;
})();
if(cljs.core.truth_(fuel)){
var statearr_23897_23924 = state_23885__$1;
(statearr_23897_23924[(1)] = (6));

} else {
var statearr_23898_23925 = state_23885__$1;
(statearr_23898_23925[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23886 === (11))){
var inst_23863 = (state_23885[(2)]);
var state_23885__$1 = (function (){var statearr_23900 = state_23885;
(statearr_23900[(8)] = inst_23863);

return statearr_23900;
})();
if(cljs.core.truth_(limit)){
var statearr_23901_23926 = state_23885__$1;
(statearr_23901_23926[(1)] = (12));

} else {
var statearr_23902_23927 = state_23885__$1;
(statearr_23902_23927[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23886 === (9))){
var inst_23857 = (state_23885[(9)]);
var inst_23859 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_23860 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_23857,inst_23859);
var state_23885__$1 = state_23885;
var statearr_23903_23928 = state_23885__$1;
(statearr_23903_23928[(2)] = inst_23860);

(statearr_23903_23928[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23886 === (5))){
var _ = (function (){var statearr_23904 = state_23885;
(statearr_23904[(4)] = cljs.core.rest((state_23885[(4)])));

return statearr_23904;
})();
var state_23885__$1 = state_23885;
var ex23899 = (state_23885__$1[(2)]);
var statearr_23905_23929 = state_23885__$1;
(statearr_23905_23929[(5)] = ex23899);


if((ex23899 instanceof Error)){
var statearr_23906_23930 = state_23885__$1;
(statearr_23906_23930[(1)] = (4));

(statearr_23906_23930[(5)] = null);

} else {
throw ex23899;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23886 === (14))){
var inst_23869 = (state_23885[(2)]);
var inst_23870 = (function (){return (function (x){
var and__4210__auto__ = max_fuel;
if(cljs.core.truth_(and__4210__auto__)){
return (cljs.core.deref(fuel) >= max_fuel);
} else {
return and__4210__auto__;
}
});
})();
var inst_23871 = cljs.core.halt_when.cljs$core$IFn$_invoke$arity$1(inst_23870);
var inst_23872 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_23869,inst_23871);
var inst_23873 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_23872,flakes);
var inst_23874 = cljs.core.PersistentVector.EMPTY;
var inst_23875 = (function (){var xf = inst_23872;
var flakes_by_sub = inst_23873;
return (function (p1__23841_SHARP_){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,p1__23841_SHARP_);
});
})();
var inst_23876 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_23875,inst_23873);
var inst_23877 = fluree.db.util.async.merge_into_QMARK_(inst_23874,inst_23876);
var state_23885__$1 = state_23885;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23885__$1,(15),inst_23877);
} else {
if((state_val_23886 === (10))){
var inst_23857 = (state_23885[(9)]);
var state_23885__$1 = state_23885;
var statearr_23907_23931 = state_23885__$1;
(statearr_23907_23931[(2)] = inst_23857);

(statearr_23907_23931[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23886 === (8))){
var inst_23857 = (state_23885[(2)]);
var state_23885__$1 = (function (){var statearr_23908 = state_23885;
(statearr_23908[(9)] = inst_23857);

return statearr_23908;
})();
if(cljs.core.truth_(offset)){
var statearr_23909_23932 = state_23885__$1;
(statearr_23909_23932[(1)] = (9));

} else {
var statearr_23910_23933 = state_23885__$1;
(statearr_23910_23933[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2717__auto__ = null;
var fluree$db$query$fql$state_machine__2717__auto____0 = (function (){
var statearr_23911 = [null,null,null,null,null,null,null,null,null,null];
(statearr_23911[(0)] = fluree$db$query$fql$state_machine__2717__auto__);

(statearr_23911[(1)] = (1));

return statearr_23911;
});
var fluree$db$query$fql$state_machine__2717__auto____1 = (function (state_23885){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_23885);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e23912){var ex__2720__auto__ = e23912;
var statearr_23913_23934 = state_23885;
(statearr_23913_23934[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_23885[(4)]))){
var statearr_23914_23935 = state_23885;
(statearr_23914_23935[(1)] = cljs.core.first((state_23885[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23936 = state_23885;
state_23885 = G__23936;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2717__auto__ = function(state_23885){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2717__auto____1.call(this,state_23885);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2717__auto____0;
fluree$db$query$fql$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2717__auto____1;
return fluree$db$query$fql$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_23915 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_23915[(6)] = c__2739__auto__);

return statearr_23915;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__23938 = arguments.length;
switch (G__23938) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_24024){
var state_val_24025 = (state_24024[(1)]);
if((state_val_24025 === (7))){
var inst_24019 = (state_24024[(2)]);
var _ = (function (){var statearr_24027 = state_24024;
(statearr_24027[(4)] = cljs.core.rest((state_24024[(4)])));

return statearr_24027;
})();
var state_24024__$1 = state_24024;
var statearr_24028_24080 = state_24024__$1;
(statearr_24028_24080[(2)] = inst_24019);

(statearr_24028_24080[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (20))){
var inst_23959 = (state_24024[(7)]);
var inst_23958 = (state_24024[(8)]);
var inst_23966 = (state_24024[(9)]);
var inst_23987 = (inst_23958 + (1));
var tmp24026 = inst_23959;
var inst_23957 = inst_23966;
var inst_23958__$1 = inst_23987;
var inst_23959__$1 = tmp24026;
var state_24024__$1 = (function (){var statearr_24029 = state_24024;
(statearr_24029[(7)] = inst_23959__$1);

(statearr_24029[(10)] = inst_23957);

(statearr_24029[(8)] = inst_23958__$1);

return statearr_24029;
})();
var statearr_24030_24081 = state_24024__$1;
(statearr_24030_24081[(2)] = null);

(statearr_24030_24081[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (27))){
var inst_23997 = (state_24024[(11)]);
var inst_23999 = cljs.core.count(inst_23997);
var inst_24000 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_23999);
var state_24024__$1 = state_24024;
var statearr_24031_24082 = state_24024__$1;
(statearr_24031_24082[(2)] = inst_24000);

(statearr_24031_24082[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (1))){
var state_24024__$1 = state_24024;
var statearr_24032_24083 = state_24024__$1;
(statearr_24032_24083[(2)] = null);

(statearr_24032_24083[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (24))){
var state_24024__$1 = state_24024;
var statearr_24033_24084 = state_24024__$1;
(statearr_24033_24084[(2)] = null);

(statearr_24033_24084[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (4))){
var inst_23939 = (state_24024[(2)]);
var state_24024__$1 = state_24024;
var statearr_24034_24085 = state_24024__$1;
(statearr_24034_24085[(2)] = inst_23939);

(statearr_24034_24085[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (15))){
var inst_23980 = (state_24024[(12)]);
var inst_23980__$1 = offset;
var state_24024__$1 = (function (){var statearr_24035 = state_24024;
(statearr_24035[(12)] = inst_23980__$1);

return statearr_24035;
})();
if(cljs.core.truth_(inst_23980__$1)){
var statearr_24036_24086 = state_24024__$1;
(statearr_24036_24086[(1)] = (17));

} else {
var statearr_24037_24087 = state_24024__$1;
(statearr_24037_24087[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (21))){
var state_24024__$1 = state_24024;
var statearr_24038_24088 = state_24024__$1;
(statearr_24038_24088[(1)] = (23));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (13))){
var inst_23975 = (state_24024[(2)]);
var state_24024__$1 = state_24024;
var statearr_24040_24089 = state_24024__$1;
(statearr_24040_24089[(2)] = inst_23975);

(statearr_24040_24089[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (22))){
var inst_24015 = (state_24024[(2)]);
var state_24024__$1 = state_24024;
var statearr_24041_24090 = state_24024__$1;
(statearr_24041_24090[(2)] = inst_24015);

(statearr_24041_24090[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (29))){
var inst_23997 = (state_24024[(11)]);
var inst_23958 = (state_24024[(8)]);
var inst_24003 = (state_24024[(2)]);
var inst_24004 = (inst_23958 + (1));
var inst_24005 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,inst_23997);
var state_24024__$1 = (function (){var statearr_24042 = state_24024;
(statearr_24042[(13)] = inst_24003);

(statearr_24042[(14)] = inst_24004);

return statearr_24042;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24024__$1,(30),inst_24005);
} else {
if((state_val_24025 === (6))){
var inst_23965 = (state_24024[(15)]);
var inst_23957 = (state_24024[(10)]);
var inst_23967 = (state_24024[(16)]);
var inst_23964 = cljs.core.seq(inst_23957);
var inst_23965__$1 = cljs.core.first(inst_23964);
var inst_23966 = cljs.core.next(inst_23964);
var inst_23967__$1 = (inst_23965__$1 == null);
var state_24024__$1 = (function (){var statearr_24043 = state_24024;
(statearr_24043[(15)] = inst_23965__$1);

(statearr_24043[(9)] = inst_23966);

(statearr_24043[(16)] = inst_23967__$1);

return statearr_24043;
})();
if(cljs.core.truth_(inst_23967__$1)){
var statearr_24044_24091 = state_24024__$1;
(statearr_24044_24091[(1)] = (8));

} else {
var statearr_24045_24092 = state_24024__$1;
(statearr_24045_24092[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (28))){
var state_24024__$1 = state_24024;
var statearr_24046_24093 = state_24024__$1;
(statearr_24046_24093[(2)] = null);

(statearr_24046_24093[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (25))){
var inst_24013 = (state_24024[(2)]);
var state_24024__$1 = state_24024;
var statearr_24047_24094 = state_24024__$1;
(statearr_24047_24094[(2)] = inst_24013);

(statearr_24047_24094[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (17))){
var inst_23958 = (state_24024[(8)]);
var inst_23982 = (inst_23958 < offset);
var state_24024__$1 = state_24024;
var statearr_24048_24095 = state_24024__$1;
(statearr_24048_24095[(2)] = inst_23982);

(statearr_24048_24095[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (3))){
var inst_24022 = (state_24024[(2)]);
var state_24024__$1 = state_24024;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24024__$1,inst_24022);
} else {
if((state_val_24025 === (12))){
var inst_23970 = (state_24024[(17)]);
var state_24024__$1 = state_24024;
var statearr_24049_24096 = state_24024__$1;
(statearr_24049_24096[(2)] = inst_23970);

(statearr_24049_24096[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (2))){
var _ = (function (){var statearr_24050 = state_24024;
(statearr_24050[(4)] = cljs.core.cons((5),(state_24024[(4)])));

return statearr_24050;
})();
var inst_23952 = subjects;
var inst_23953 = cljs.core.seq(inst_23952);
var inst_23954 = cljs.core.first(inst_23953);
var inst_23955 = cljs.core.next(inst_23953);
var inst_23956 = cljs.core.PersistentVector.EMPTY;
var inst_23957 = inst_23952;
var inst_23958 = (0);
var inst_23959 = inst_23956;
var state_24024__$1 = (function (){var statearr_24051 = state_24024;
(statearr_24051[(7)] = inst_23959);

(statearr_24051[(10)] = inst_23957);

(statearr_24051[(18)] = inst_23954);

(statearr_24051[(8)] = inst_23958);

(statearr_24051[(19)] = inst_23955);

return statearr_24051;
})();
var statearr_24052_24097 = state_24024__$1;
(statearr_24052_24097[(2)] = null);

(statearr_24052_24097[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (23))){
var inst_23965 = (state_24024[(15)]);
var inst_23991 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23992 = [inst_23965];
var inst_23993 = (new cljs.core.PersistentVector(null,1,(5),inst_23991,inst_23992,null));
var inst_23994 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23993);
var state_24024__$1 = state_24024;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24024__$1,(26),inst_23994);
} else {
if((state_val_24025 === (19))){
var inst_23985 = (state_24024[(2)]);
var state_24024__$1 = state_24024;
if(cljs.core.truth_(inst_23985)){
var statearr_24053_24098 = state_24024__$1;
(statearr_24053_24098[(1)] = (20));

} else {
var statearr_24054_24099 = state_24024__$1;
(statearr_24054_24099[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (11))){
var inst_23958 = (state_24024[(8)]);
var inst_23972 = (inst_23958 > limit);
var state_24024__$1 = state_24024;
var statearr_24056_24100 = state_24024__$1;
(statearr_24056_24100[(2)] = inst_23972);

(statearr_24056_24100[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (9))){
var inst_23970 = (state_24024[(17)]);
var inst_23970__$1 = limit;
var state_24024__$1 = (function (){var statearr_24057 = state_24024;
(statearr_24057[(17)] = inst_23970__$1);

return statearr_24057;
})();
if(cljs.core.truth_(inst_23970__$1)){
var statearr_24058_24101 = state_24024__$1;
(statearr_24058_24101[(1)] = (11));

} else {
var statearr_24059_24102 = state_24024__$1;
(statearr_24059_24102[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (5))){
var _ = (function (){var statearr_24060 = state_24024;
(statearr_24060[(4)] = cljs.core.rest((state_24024[(4)])));

return statearr_24060;
})();
var state_24024__$1 = state_24024;
var ex24055 = (state_24024__$1[(2)]);
var statearr_24061_24103 = state_24024__$1;
(statearr_24061_24103[(5)] = ex24055);


if((ex24055 instanceof Error)){
var statearr_24062_24104 = state_24024__$1;
(statearr_24062_24104[(1)] = (4));

(statearr_24062_24104[(5)] = null);

} else {
throw ex24055;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (14))){
var inst_23959 = (state_24024[(7)]);
var state_24024__$1 = state_24024;
var statearr_24063_24105 = state_24024__$1;
(statearr_24063_24105[(2)] = inst_23959);

(statearr_24063_24105[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (26))){
var inst_23996 = (state_24024[(2)]);
var inst_23997 = fluree.db.util.async.throw_err(inst_23996);
var state_24024__$1 = (function (){var statearr_24064 = state_24024;
(statearr_24064[(11)] = inst_23997);

return statearr_24064;
})();
if(cljs.core.truth_(fuel)){
var statearr_24065_24106 = state_24024__$1;
(statearr_24065_24106[(1)] = (27));

} else {
var statearr_24066_24107 = state_24024__$1;
(statearr_24066_24107[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (16))){
var inst_24017 = (state_24024[(2)]);
var state_24024__$1 = state_24024;
var statearr_24067_24108 = state_24024__$1;
(statearr_24067_24108[(2)] = inst_24017);

(statearr_24067_24108[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (30))){
var inst_23959 = (state_24024[(7)]);
var inst_23966 = (state_24024[(9)]);
var inst_24004 = (state_24024[(14)]);
var inst_24007 = (state_24024[(2)]);
var inst_24008 = fluree.db.util.async.throw_err(inst_24007);
var inst_24009 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23959,inst_24008);
var inst_23957 = inst_23966;
var inst_23958 = inst_24004;
var inst_23959__$1 = inst_24009;
var state_24024__$1 = (function (){var statearr_24068 = state_24024;
(statearr_24068[(7)] = inst_23959__$1);

(statearr_24068[(10)] = inst_23957);

(statearr_24068[(8)] = inst_23958);

return statearr_24068;
})();
var statearr_24069_24109 = state_24024__$1;
(statearr_24069_24109[(2)] = null);

(statearr_24069_24109[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (10))){
var inst_23977 = (state_24024[(2)]);
var state_24024__$1 = state_24024;
if(cljs.core.truth_(inst_23977)){
var statearr_24070_24110 = state_24024__$1;
(statearr_24070_24110[(1)] = (14));

} else {
var statearr_24071_24111 = state_24024__$1;
(statearr_24071_24111[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (18))){
var inst_23980 = (state_24024[(12)]);
var state_24024__$1 = state_24024;
var statearr_24072_24112 = state_24024__$1;
(statearr_24072_24112[(2)] = inst_23980);

(statearr_24072_24112[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24025 === (8))){
var inst_23967 = (state_24024[(16)]);
var state_24024__$1 = state_24024;
var statearr_24073_24113 = state_24024__$1;
(statearr_24073_24113[(2)] = inst_23967);

(statearr_24073_24113[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2717__auto__ = null;
var fluree$db$query$fql$state_machine__2717__auto____0 = (function (){
var statearr_24074 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24074[(0)] = fluree$db$query$fql$state_machine__2717__auto__);

(statearr_24074[(1)] = (1));

return statearr_24074;
});
var fluree$db$query$fql$state_machine__2717__auto____1 = (function (state_24024){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_24024);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e24075){var ex__2720__auto__ = e24075;
var statearr_24076_24114 = state_24024;
(statearr_24076_24114[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_24024[(4)]))){
var statearr_24077_24115 = state_24024;
(statearr_24077_24115[(1)] = cljs.core.first((state_24024[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24116 = state_24024;
state_24024 = G__24116;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2717__auto__ = function(state_24024){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2717__auto____1.call(this,state_24024);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2717__auto____0;
fluree$db$query$fql$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2717__auto____1;
return fluree$db$query$fql$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_24078 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_24078[(6)] = c__2739__auto__);

return statearr_24078;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4212__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p);
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tag","tag",-1290361223),fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"type","type",1174270348),p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__24118 = arguments.length;
switch (G__24118) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4(db,where_clause,null,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4 = (function (db,where_clause,default_collection,p__24119){
var map__24120 = p__24119;
var map__24120__$1 = cljs.core.__destructure_map(map__24120);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24120__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24120__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_24384){
var state_val_24385 = (state_24384[(1)]);
if((state_val_24385 === (65))){
var inst_24347 = (state_24384[(7)]);
var inst_24347__$1 = (state_24384[(2)]);
var state_24384__$1 = (function (){var statearr_24386 = state_24384;
(statearr_24386[(7)] = inst_24347__$1);

return statearr_24386;
})();
if(cljs.core.truth_(inst_24347__$1)){
var statearr_24387_24505 = state_24384__$1;
(statearr_24387_24505[(1)] = (66));

} else {
var statearr_24388_24506 = state_24384__$1;
(statearr_24388_24506[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (70))){
var inst_24350 = (state_24384[(8)]);
var state_24384__$1 = state_24384;
var statearr_24389_24507 = state_24384__$1;
(statearr_24389_24507[(2)] = inst_24350);

(statearr_24389_24507[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (62))){
var inst_24338 = (state_24384[(2)]);
var state_24384__$1 = state_24384;
var statearr_24390_24508 = state_24384__$1;
(statearr_24390_24508[(2)] = inst_24338);

(statearr_24390_24508[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (74))){
var inst_24357 = (state_24384[(2)]);
var state_24384__$1 = state_24384;
var statearr_24391_24509 = state_24384__$1;
(statearr_24391_24509[(2)] = inst_24357);

(statearr_24391_24509[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (7))){
var inst_24133 = (state_24384[(9)]);
var state_24384__$1 = state_24384;
var statearr_24392_24510 = state_24384__$1;
(statearr_24392_24510[(2)] = inst_24133);

(statearr_24392_24510[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (59))){
var inst_24162 = (state_24384[(10)]);
var inst_24330 = cljs.core.empty_QMARK_(inst_24162);
var state_24384__$1 = state_24384;
if(inst_24330){
var statearr_24393_24511 = state_24384__$1;
(statearr_24393_24511[(1)] = (60));

} else {
var statearr_24394_24512 = state_24384__$1;
(statearr_24394_24512[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (20))){
var state_24384__$1 = state_24384;
if(cljs.core.truth_(offset)){
var statearr_24395_24513 = state_24384__$1;
(statearr_24395_24513[(1)] = (23));

} else {
var statearr_24396_24514 = state_24384__$1;
(statearr_24396_24514[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (72))){
var inst_24327 = (state_24384[(11)]);
var inst_24147 = (state_24384[(12)]);
var inst_24353 = cljs.core.count(inst_24327);
var inst_24354 = (inst_24353 > inst_24147);
var state_24384__$1 = state_24384;
var statearr_24397_24515 = state_24384__$1;
(statearr_24397_24515[(2)] = inst_24354);

(statearr_24397_24515[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (58))){
var inst_24327 = (state_24384[(11)]);
var inst_24162 = (state_24384[(10)]);
var inst_24328 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24162,inst_24327);
var state_24384__$1 = state_24384;
var statearr_24398_24516 = state_24384__$1;
(statearr_24398_24516[(2)] = inst_24328);

(statearr_24398_24516[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (60))){
var inst_24327 = (state_24384[(11)]);
var inst_24162 = (state_24384[(10)]);
var inst_24332 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24162,inst_24327);
var state_24384__$1 = state_24384;
var statearr_24399_24517 = state_24384__$1;
(statearr_24399_24517[(2)] = inst_24332);

(statearr_24399_24517[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (27))){
var inst_24177 = (state_24384[(13)]);
var state_24384__$1 = state_24384;
var statearr_24400_24518 = state_24384__$1;
(statearr_24400_24518[(2)] = inst_24177);

(statearr_24400_24518[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (1))){
var state_24384__$1 = state_24384;
var statearr_24401_24519 = state_24384__$1;
(statearr_24401_24519[(2)] = null);

(statearr_24401_24519[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (69))){
var inst_24147 = (state_24384[(12)]);
var state_24384__$1 = state_24384;
if(cljs.core.truth_(inst_24147)){
var statearr_24402_24520 = state_24384__$1;
(statearr_24402_24520[(1)] = (72));

} else {
var statearr_24403_24521 = state_24384__$1;
(statearr_24403_24521[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (24))){
var inst_24162 = (state_24384[(10)]);
var state_24384__$1 = state_24384;
var statearr_24404_24522 = state_24384__$1;
(statearr_24404_24522[(2)] = inst_24162);

(statearr_24404_24522[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (55))){
var inst_24316 = (state_24384[(2)]);
var state_24384__$1 = state_24384;
var statearr_24405_24523 = state_24384__$1;
(statearr_24405_24523[(2)] = inst_24316);

(statearr_24405_24523[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (39))){
var inst_24324 = (state_24384[(2)]);
var state_24384__$1 = state_24384;
var statearr_24406_24524 = state_24384__$1;
(statearr_24406_24524[(2)] = inst_24324);

(statearr_24406_24524[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (46))){
var inst_24206 = (state_24384[(14)]);
var inst_24188 = (state_24384[(15)]);
var inst_24282 = (inst_24206.cljs$core$IFn$_invoke$arity$2 ? inst_24206.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,inst_24188) : inst_24206.call(null,cljs.core._LT_,inst_24188));
var state_24384__$1 = state_24384;
if(cljs.core.truth_(inst_24282)){
var statearr_24407_24525 = state_24384__$1;
(statearr_24407_24525[(1)] = (49));

} else {
var statearr_24408_24526 = state_24384__$1;
(statearr_24408_24526[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (4))){
var inst_24121 = (state_24384[(2)]);
var state_24384__$1 = state_24384;
var statearr_24409_24527 = state_24384__$1;
(statearr_24409_24527[(2)] = inst_24121);

(statearr_24409_24527[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (77))){
var inst_24372 = (state_24384[(2)]);
var state_24384__$1 = state_24384;
var statearr_24410_24528 = state_24384__$1;
(statearr_24410_24528[(2)] = inst_24372);

(statearr_24410_24528[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (54))){
var inst_24314 = cljs.core.PersistentVector.EMPTY;
var state_24384__$1 = state_24384;
var statearr_24411_24529 = state_24384__$1;
(statearr_24411_24529[(2)] = inst_24314);

(statearr_24411_24529[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (15))){
var inst_24132 = (state_24384[(16)]);
var inst_24157 = cljs.core.seq(inst_24132);
var inst_24158 = cljs.core.first(inst_24157);
var inst_24159 = cljs.core.next(inst_24157);
var inst_24160 = cljs.core.PersistentHashSet.EMPTY;
var inst_24161 = inst_24132;
var inst_24162 = inst_24160;
var state_24384__$1 = (function (){var statearr_24412 = state_24384;
(statearr_24412[(10)] = inst_24162);

(statearr_24412[(17)] = inst_24159);

(statearr_24412[(18)] = inst_24161);

(statearr_24412[(19)] = inst_24158);

return statearr_24412;
})();
var statearr_24413_24530 = state_24384__$1;
(statearr_24413_24530[(2)] = null);

(statearr_24413_24530[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (48))){
var inst_24279 = (state_24384[(2)]);
var inst_24280 = fluree.db.util.async.throw_err(inst_24279);
var state_24384__$1 = state_24384;
var statearr_24414_24531 = state_24384__$1;
(statearr_24414_24531[(2)] = inst_24280);

(statearr_24414_24531[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (50))){
var inst_24206 = (state_24384[(14)]);
var inst_24188 = (state_24384[(15)]);
var inst_24298 = (inst_24206.cljs$core$IFn$_invoke$arity$2 ? inst_24206.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,inst_24188) : inst_24206.call(null,cljs.core._LT__EQ_,inst_24188));
var state_24384__$1 = state_24384;
if(cljs.core.truth_(inst_24298)){
var statearr_24415_24532 = state_24384__$1;
(statearr_24415_24532[(1)] = (53));

} else {
var statearr_24416_24533 = state_24384__$1;
(statearr_24416_24533[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (75))){
var state_24384__$1 = state_24384;
if(cljs.core.truth_(offset)){
var statearr_24417_24534 = state_24384__$1;
(statearr_24417_24534[(1)] = (78));

} else {
var statearr_24418_24535 = state_24384__$1;
(statearr_24418_24535[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (21))){
var inst_24168 = (state_24384[(20)]);
var inst_24187 = (state_24384[(21)]);
var inst_24187__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24168,(0),null);
var inst_24188 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24168,(1),null);
var inst_24189 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24168,(2),null);
var inst_24190 = fluree.db.query.fql.valid_where_predicate_QMARK_(db,inst_24187__$1);
var inst_24191 = cljs.core.not(inst_24190);
var state_24384__$1 = (function (){var statearr_24419 = state_24384;
(statearr_24419[(22)] = inst_24189);

(statearr_24419[(15)] = inst_24188);

(statearr_24419[(21)] = inst_24187__$1);

return statearr_24419;
})();
if(inst_24191){
var statearr_24420_24536 = state_24384__$1;
(statearr_24420_24536[(1)] = (29));

} else {
var statearr_24421_24537 = state_24384__$1;
(statearr_24421_24537[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (31))){
var inst_24206 = (state_24384[(14)]);
var inst_24188 = (state_24384[(15)]);
var inst_24202 = (state_24384[(2)]);
var inst_24206__$1 = cljs.core.identical_QMARK_;
var inst_24207 = (inst_24206__$1.cljs$core$IFn$_invoke$arity$2 ? inst_24206__$1.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,inst_24188) : inst_24206__$1.call(null,cljs.core.not_EQ_,inst_24188));
var state_24384__$1 = (function (){var statearr_24422 = state_24384;
(statearr_24422[(14)] = inst_24206__$1);

(statearr_24422[(23)] = inst_24202);

return statearr_24422;
})();
if(cljs.core.truth_(inst_24207)){
var statearr_24423_24538 = state_24384__$1;
(statearr_24423_24538[(1)] = (32));

} else {
var statearr_24424_24539 = state_24384__$1;
(statearr_24424_24539[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (32))){
var inst_24189 = (state_24384[(22)]);
var inst_24147 = (state_24384[(12)]);
var inst_24187 = (state_24384[(21)]);
var inst_24209 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24210 = [inst_24187,inst_24189];
var inst_24211 = (new cljs.core.PersistentVector(null,2,(5),inst_24209,inst_24210,null));
var inst_24212 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24213 = [inst_24187];
var inst_24214 = (new cljs.core.PersistentVector(null,1,(5),inst_24212,inst_24213,null));
var inst_24215 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24216 = [inst_24147];
var inst_24217 = cljs.core.PersistentHashMap.fromArrays(inst_24215,inst_24216);
var inst_24218 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_24211,cljs.core._LT__EQ_,inst_24214,inst_24217);
var state_24384__$1 = state_24384;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24384__$1,(35),inst_24218);
} else {
if((state_val_24385 === (40))){
var inst_24247 = (state_24384[(2)]);
var inst_24248 = fluree.db.util.async.throw_err(inst_24247);
var state_24384__$1 = state_24384;
var statearr_24425_24540 = state_24384__$1;
(statearr_24425_24540[(2)] = inst_24248);

(statearr_24425_24540[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (56))){
var inst_24311 = (state_24384[(2)]);
var inst_24312 = fluree.db.util.async.throw_err(inst_24311);
var state_24384__$1 = state_24384;
var statearr_24426_24541 = state_24384__$1;
(statearr_24426_24541[(2)] = inst_24312);

(statearr_24426_24541[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (33))){
var inst_24206 = (state_24384[(14)]);
var inst_24188 = (state_24384[(15)]);
var inst_24237 = (inst_24206.cljs$core$IFn$_invoke$arity$2 ? inst_24206.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,inst_24188) : inst_24206.call(null,cljs.core._EQ_,inst_24188));
var state_24384__$1 = state_24384;
if(cljs.core.truth_(inst_24237)){
var statearr_24427_24542 = state_24384__$1;
(statearr_24427_24542[(1)] = (37));

} else {
var statearr_24428_24543 = state_24384__$1;
(statearr_24428_24543[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (13))){
var state_24384__$1 = state_24384;
var statearr_24429_24544 = state_24384__$1;
(statearr_24429_24544[(2)] = limit);

(statearr_24429_24544[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (22))){
var inst_24374 = (state_24384[(2)]);
var state_24384__$1 = state_24384;
var statearr_24430_24545 = state_24384__$1;
(statearr_24430_24545[(2)] = inst_24374);

(statearr_24430_24545[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (36))){
var inst_24221 = (state_24384[(24)]);
var inst_24233 = (state_24384[(2)]);
var inst_24234 = fluree.db.util.async.throw_err(inst_24233);
var inst_24235 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_24221,inst_24234);
var state_24384__$1 = state_24384;
var statearr_24431_24546 = state_24384__$1;
(statearr_24431_24546[(2)] = inst_24235);

(statearr_24431_24546[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (41))){
var inst_24189 = (state_24384[(22)]);
var inst_24147 = (state_24384[(12)]);
var inst_24187 = (state_24384[(21)]);
var inst_24252 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24253 = [inst_24187,inst_24189];
var inst_24254 = (new cljs.core.PersistentVector(null,2,(5),inst_24252,inst_24253,null));
var inst_24255 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24256 = [inst_24187];
var inst_24257 = (new cljs.core.PersistentVector(null,1,(5),inst_24255,inst_24256,null));
var inst_24258 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24259 = [inst_24147];
var inst_24260 = cljs.core.PersistentHashMap.fromArrays(inst_24258,inst_24259);
var inst_24261 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_24254,cljs.core._LT__EQ_,inst_24257,inst_24260);
var state_24384__$1 = state_24384;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24384__$1,(44),inst_24261);
} else {
if((state_val_24385 === (43))){
var inst_24322 = (state_24384[(2)]);
var state_24384__$1 = state_24384;
var statearr_24432_24547 = state_24384__$1;
(statearr_24432_24547[(2)] = inst_24322);

(statearr_24432_24547[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (61))){
var inst_24327 = (state_24384[(11)]);
var inst_24162 = (state_24384[(10)]);
var inst_24334 = cljs.core.PersistentHashSet.EMPTY;
var inst_24335 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24334,inst_24327);
var inst_24336 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(inst_24162,inst_24335);
var state_24384__$1 = state_24384;
var statearr_24433_24548 = state_24384__$1;
(statearr_24433_24548[(2)] = inst_24336);

(statearr_24433_24548[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (29))){
var inst_24187 = (state_24384[(21)]);
var inst_24193 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_24187);
var inst_24194 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24193)].join('');
var inst_24195 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_24196 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_24197 = cljs.core.PersistentHashMap.fromArrays(inst_24195,inst_24196);
var inst_24198 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_24194,inst_24197);
var inst_24199 = (function(){throw inst_24198})();
var state_24384__$1 = state_24384;
var statearr_24434_24549 = state_24384__$1;
(statearr_24434_24549[(2)] = inst_24199);

(statearr_24434_24549[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (44))){
var inst_24263 = (state_24384[(2)]);
var inst_24264 = fluree.db.util.async.throw_err(inst_24263);
var state_24384__$1 = state_24384;
var statearr_24435_24550 = state_24384__$1;
(statearr_24435_24550[(2)] = inst_24264);

(statearr_24435_24550[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (6))){
var inst_24131 = (state_24384[(25)]);
var inst_24135 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"and","and",-971899817),inst_24131);
var state_24384__$1 = state_24384;
var statearr_24436_24551 = state_24384__$1;
(statearr_24436_24551[(2)] = inst_24135);

(statearr_24436_24551[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (28))){
var inst_24182 = (state_24384[(2)]);
var state_24384__$1 = state_24384;
var statearr_24437_24552 = state_24384__$1;
(statearr_24437_24552[(2)] = inst_24182);

(statearr_24437_24552[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (64))){
var inst_24342 = (state_24384[(26)]);
var state_24384__$1 = state_24384;
var statearr_24438_24553 = state_24384__$1;
(statearr_24438_24553[(2)] = inst_24342);

(statearr_24438_24553[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (51))){
var inst_24318 = (state_24384[(2)]);
var state_24384__$1 = state_24384;
var statearr_24439_24554 = state_24384__$1;
(statearr_24439_24554[(2)] = inst_24318);

(statearr_24439_24554[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (25))){
var inst_24177 = (state_24384[(2)]);
var state_24384__$1 = (function (){var statearr_24440 = state_24384;
(statearr_24440[(13)] = inst_24177);

return statearr_24440;
})();
if(cljs.core.truth_(limit)){
var statearr_24441_24555 = state_24384__$1;
(statearr_24441_24555[(1)] = (26));

} else {
var statearr_24442_24556 = state_24384__$1;
(statearr_24442_24556[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (34))){
var inst_24131 = (state_24384[(25)]);
var inst_24326 = (state_24384[(2)]);
var inst_24327 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_24326);
var state_24384__$1 = (function (){var statearr_24443 = state_24384;
(statearr_24443[(11)] = inst_24327);

return statearr_24443;
})();
var G__24444_24557 = inst_24131;
var G__24444_24558__$1 = (((G__24444_24557 instanceof cljs.core.Keyword))?G__24444_24557.fqn:null);
switch (G__24444_24558__$1) {
case "or":
var statearr_24445_24560 = state_24384__$1;
(statearr_24445_24560[(1)] = (58));


break;
case "and":
var statearr_24446_24561 = state_24384__$1;
(statearr_24446_24561[(1)] = (59));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__24444_24558__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (17))){
var inst_24379 = (state_24384[(2)]);
var _ = (function (){var statearr_24447 = state_24384;
(statearr_24447[(4)] = cljs.core.rest((state_24384[(4)])));

return statearr_24447;
})();
var state_24384__$1 = state_24384;
var statearr_24448_24562 = state_24384__$1;
(statearr_24448_24562[(2)] = inst_24379);

(statearr_24448_24562[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (3))){
var inst_24382 = (state_24384[(2)]);
var state_24384__$1 = state_24384;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24384__$1,inst_24382);
} else {
if((state_val_24385 === (12))){
var inst_24141 = (offset + limit);
var state_24384__$1 = state_24384;
var statearr_24449_24563 = state_24384__$1;
(statearr_24449_24563[(2)] = inst_24141);

(statearr_24449_24563[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (2))){
var inst_24133 = (state_24384[(9)]);
var _ = (function (){var statearr_24450 = state_24384;
(statearr_24450[(4)] = cljs.core.cons((5),(state_24384[(4)])));

return statearr_24450;
})();
var inst_24130 = fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3(db,where_clause,default_collection);
var inst_24131 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24130,(0),null);
var inst_24132 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24130,(1),null);
var inst_24133__$1 = limit;
var state_24384__$1 = (function (){var statearr_24451 = state_24384;
(statearr_24451[(9)] = inst_24133__$1);

(statearr_24451[(25)] = inst_24131);

(statearr_24451[(16)] = inst_24132);

return statearr_24451;
})();
if(cljs.core.truth_(inst_24133__$1)){
var statearr_24452_24564 = state_24384__$1;
(statearr_24452_24564[(1)] = (6));

} else {
var statearr_24453_24565 = state_24384__$1;
(statearr_24453_24565[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (66))){
var inst_24347 = (state_24384[(7)]);
var state_24384__$1 = state_24384;
var statearr_24454_24566 = state_24384__$1;
(statearr_24454_24566[(2)] = inst_24347);

(statearr_24454_24566[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (23))){
var inst_24162 = (state_24384[(10)]);
var inst_24174 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,inst_24162);
var state_24384__$1 = state_24384;
var statearr_24455_24567 = state_24384__$1;
(statearr_24455_24567[(2)] = inst_24174);

(statearr_24455_24567[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (47))){
var inst_24320 = (state_24384[(2)]);
var state_24384__$1 = state_24384;
var statearr_24456_24568 = state_24384__$1;
(statearr_24456_24568[(2)] = inst_24320);

(statearr_24456_24568[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (35))){
var inst_24189 = (state_24384[(22)]);
var inst_24147 = (state_24384[(12)]);
var inst_24187 = (state_24384[(21)]);
var inst_24220 = (state_24384[(2)]);
var inst_24221 = fluree.db.util.async.throw_err(inst_24220);
var inst_24222 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24223 = [inst_24187];
var inst_24224 = (new cljs.core.PersistentVector(null,1,(5),inst_24222,inst_24223,null));
var inst_24225 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24226 = [inst_24187,inst_24189];
var inst_24227 = (new cljs.core.PersistentVector(null,2,(5),inst_24225,inst_24226,null));
var inst_24228 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24229 = [inst_24147];
var inst_24230 = cljs.core.PersistentHashMap.fromArrays(inst_24228,inst_24229);
var inst_24231 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24224,cljs.core._LT_,inst_24227,inst_24230);
var state_24384__$1 = (function (){var statearr_24457 = state_24384;
(statearr_24457[(24)] = inst_24221);

return statearr_24457;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24384__$1,(36),inst_24231);
} else {
if((state_val_24385 === (76))){
var inst_24341 = (state_24384[(27)]);
var inst_24169 = (state_24384[(28)]);
var inst_24161 = inst_24169;
var inst_24162 = inst_24341;
var state_24384__$1 = (function (){var statearr_24458 = state_24384;
(statearr_24458[(10)] = inst_24162);

(statearr_24458[(18)] = inst_24161);

return statearr_24458;
})();
var statearr_24459_24569 = state_24384__$1;
(statearr_24459_24569[(2)] = null);

(statearr_24459_24569[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (19))){
var inst_24376 = (state_24384[(2)]);
var state_24384__$1 = state_24384;
var statearr_24460_24570 = state_24384__$1;
(statearr_24460_24570[(2)] = inst_24376);

(statearr_24460_24570[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (57))){
var inst_24131 = (state_24384[(25)]);
var inst_24342 = (state_24384[(26)]);
var inst_24341 = (state_24384[(2)]);
var inst_24342__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"and","and",-971899817),inst_24131);
var state_24384__$1 = (function (){var statearr_24461 = state_24384;
(statearr_24461[(27)] = inst_24341);

(statearr_24461[(26)] = inst_24342__$1);

return statearr_24461;
})();
if(inst_24342__$1){
var statearr_24462_24571 = state_24384__$1;
(statearr_24462_24571[(1)] = (63));

} else {
var statearr_24463_24572 = state_24384__$1;
(statearr_24463_24572[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (68))){
var inst_24362 = (state_24384[(2)]);
var state_24384__$1 = state_24384;
if(cljs.core.truth_(inst_24362)){
var statearr_24464_24573 = state_24384__$1;
(statearr_24464_24573[(1)] = (75));

} else {
var statearr_24465_24574 = state_24384__$1;
(statearr_24465_24574[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (11))){
var inst_24132 = (state_24384[(16)]);
var inst_24147 = (state_24384[(2)]);
var inst_24148 = cljs.core.not_empty(inst_24132);
var state_24384__$1 = (function (){var statearr_24467 = state_24384;
(statearr_24467[(12)] = inst_24147);

return statearr_24467;
})();
if(cljs.core.truth_(inst_24148)){
var statearr_24468_24575 = state_24384__$1;
(statearr_24468_24575[(1)] = (15));

} else {
var statearr_24469_24576 = state_24384__$1;
(statearr_24469_24576[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (9))){
var state_24384__$1 = state_24384;
if(cljs.core.truth_(offset)){
var statearr_24470_24577 = state_24384__$1;
(statearr_24470_24577[(1)] = (12));

} else {
var statearr_24471_24578 = state_24384__$1;
(statearr_24471_24578[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (5))){
var _ = (function (){var statearr_24472 = state_24384;
(statearr_24472[(4)] = cljs.core.rest((state_24384[(4)])));

return statearr_24472;
})();
var state_24384__$1 = state_24384;
var ex24466 = (state_24384__$1[(2)]);
var statearr_24473_24579 = state_24384__$1;
(statearr_24473_24579[(5)] = ex24466);


if((ex24466 instanceof Error)){
var statearr_24474_24580 = state_24384__$1;
(statearr_24474_24580[(1)] = (4));

(statearr_24474_24580[(5)] = null);

} else {
throw ex24466;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (14))){
var inst_24144 = (state_24384[(2)]);
var state_24384__$1 = state_24384;
var statearr_24475_24581 = state_24384__$1;
(statearr_24475_24581[(2)] = inst_24144);

(statearr_24475_24581[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (45))){
var inst_24189 = (state_24384[(22)]);
var inst_24147 = (state_24384[(12)]);
var inst_24187 = (state_24384[(21)]);
var inst_24268 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24269 = [inst_24187,inst_24189];
var inst_24270 = (new cljs.core.PersistentVector(null,2,(5),inst_24268,inst_24269,null));
var inst_24271 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24272 = [inst_24187];
var inst_24273 = (new cljs.core.PersistentVector(null,1,(5),inst_24271,inst_24272,null));
var inst_24274 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24275 = [inst_24147];
var inst_24276 = cljs.core.PersistentHashMap.fromArrays(inst_24274,inst_24275);
var inst_24277 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24270,cljs.core._LT__EQ_,inst_24273,inst_24276);
var state_24384__$1 = state_24384;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24384__$1,(48),inst_24277);
} else {
if((state_val_24385 === (53))){
var inst_24189 = (state_24384[(22)]);
var inst_24147 = (state_24384[(12)]);
var inst_24187 = (state_24384[(21)]);
var inst_24300 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24301 = [inst_24187];
var inst_24302 = (new cljs.core.PersistentVector(null,1,(5),inst_24300,inst_24301,null));
var inst_24303 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24304 = [inst_24187,inst_24189];
var inst_24305 = (new cljs.core.PersistentVector(null,2,(5),inst_24303,inst_24304,null));
var inst_24306 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24307 = [inst_24147];
var inst_24308 = cljs.core.PersistentHashMap.fromArrays(inst_24306,inst_24307);
var inst_24309 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24302,cljs.core._LT__EQ_,inst_24305,inst_24308);
var state_24384__$1 = state_24384;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24384__$1,(56),inst_24309);
} else {
if((state_val_24385 === (78))){
var inst_24341 = (state_24384[(27)]);
var inst_24365 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,inst_24341);
var state_24384__$1 = state_24384;
var statearr_24476_24582 = state_24384__$1;
(statearr_24476_24582[(2)] = inst_24365);

(statearr_24476_24582[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (26))){
var inst_24177 = (state_24384[(13)]);
var inst_24179 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,inst_24177);
var state_24384__$1 = state_24384;
var statearr_24477_24583 = state_24384__$1;
(statearr_24477_24583[(2)] = inst_24179);

(statearr_24477_24583[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (16))){
var state_24384__$1 = state_24384;
var statearr_24478_24584 = state_24384__$1;
(statearr_24478_24584[(2)] = null);

(statearr_24478_24584[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (79))){
var inst_24341 = (state_24384[(27)]);
var state_24384__$1 = state_24384;
var statearr_24479_24585 = state_24384__$1;
(statearr_24479_24585[(2)] = inst_24341);

(statearr_24479_24585[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (38))){
var inst_24206 = (state_24384[(14)]);
var inst_24188 = (state_24384[(15)]);
var inst_24250 = (inst_24206.cljs$core$IFn$_invoke$arity$2 ? inst_24206.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,inst_24188) : inst_24206.call(null,cljs.core._GT_,inst_24188));
var state_24384__$1 = state_24384;
if(cljs.core.truth_(inst_24250)){
var statearr_24480_24586 = state_24384__$1;
(statearr_24480_24586[(1)] = (41));

} else {
var statearr_24481_24587 = state_24384__$1;
(statearr_24481_24587[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (30))){
var state_24384__$1 = state_24384;
var statearr_24482_24588 = state_24384__$1;
(statearr_24482_24588[(2)] = null);

(statearr_24482_24588[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (73))){
var inst_24147 = (state_24384[(12)]);
var state_24384__$1 = state_24384;
var statearr_24483_24589 = state_24384__$1;
(statearr_24483_24589[(2)] = inst_24147);

(statearr_24483_24589[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (10))){
var state_24384__$1 = state_24384;
var statearr_24484_24590 = state_24384__$1;
(statearr_24484_24590[(2)] = null);

(statearr_24484_24590[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (18))){
var inst_24168 = (state_24384[(20)]);
var inst_24161 = (state_24384[(18)]);
var inst_24167 = cljs.core.seq(inst_24161);
var inst_24168__$1 = cljs.core.first(inst_24167);
var inst_24169 = cljs.core.next(inst_24167);
var inst_24170 = cljs.core.not(inst_24168__$1);
var state_24384__$1 = (function (){var statearr_24485 = state_24384;
(statearr_24485[(20)] = inst_24168__$1);

(statearr_24485[(28)] = inst_24169);

return statearr_24485;
})();
if(inst_24170){
var statearr_24486_24591 = state_24384__$1;
(statearr_24486_24591[(1)] = (20));

} else {
var statearr_24487_24592 = state_24384__$1;
(statearr_24487_24592[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (52))){
var inst_24295 = (state_24384[(2)]);
var inst_24296 = fluree.db.util.async.throw_err(inst_24295);
var state_24384__$1 = state_24384;
var statearr_24488_24593 = state_24384__$1;
(statearr_24488_24593[(2)] = inst_24296);

(statearr_24488_24593[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (67))){
var inst_24131 = (state_24384[(25)]);
var inst_24350 = (state_24384[(8)]);
var inst_24350__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"and","and",-971899817),inst_24131);
var state_24384__$1 = (function (){var statearr_24489 = state_24384;
(statearr_24489[(8)] = inst_24350__$1);

return statearr_24489;
})();
if(inst_24350__$1){
var statearr_24490_24594 = state_24384__$1;
(statearr_24490_24594[(1)] = (69));

} else {
var statearr_24491_24595 = state_24384__$1;
(statearr_24491_24595[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (71))){
var inst_24360 = (state_24384[(2)]);
var state_24384__$1 = state_24384;
var statearr_24492_24596 = state_24384__$1;
(statearr_24492_24596[(2)] = inst_24360);

(statearr_24492_24596[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (42))){
var inst_24206 = (state_24384[(14)]);
var inst_24188 = (state_24384[(15)]);
var inst_24266 = (inst_24206.cljs$core$IFn$_invoke$arity$2 ? inst_24206.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,inst_24188) : inst_24206.call(null,cljs.core._GT__EQ_,inst_24188));
var state_24384__$1 = state_24384;
if(cljs.core.truth_(inst_24266)){
var statearr_24493_24597 = state_24384__$1;
(statearr_24493_24597[(1)] = (45));

} else {
var statearr_24494_24598 = state_24384__$1;
(statearr_24494_24598[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (80))){
var inst_24368 = (state_24384[(2)]);
var state_24384__$1 = state_24384;
var statearr_24495_24599 = state_24384__$1;
(statearr_24495_24599[(2)] = inst_24368);

(statearr_24495_24599[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (37))){
var inst_24189 = (state_24384[(22)]);
var inst_24147 = (state_24384[(12)]);
var inst_24187 = (state_24384[(21)]);
var inst_24239 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24240 = [inst_24187,inst_24189];
var inst_24241 = (new cljs.core.PersistentVector(null,2,(5),inst_24239,inst_24240,null));
var inst_24242 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24243 = [inst_24147];
var inst_24244 = cljs.core.PersistentHashMap.fromArrays(inst_24242,inst_24243);
var inst_24245 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_24241,inst_24244);
var state_24384__$1 = state_24384;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24384__$1,(40),inst_24245);
} else {
if((state_val_24385 === (63))){
var inst_24341 = (state_24384[(27)]);
var inst_24344 = cljs.core.empty_QMARK_(inst_24341);
var state_24384__$1 = state_24384;
var statearr_24496_24600 = state_24384__$1;
(statearr_24496_24600[(2)] = inst_24344);

(statearr_24496_24600[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (8))){
var inst_24138 = (state_24384[(2)]);
var state_24384__$1 = state_24384;
if(cljs.core.truth_(inst_24138)){
var statearr_24497_24601 = state_24384__$1;
(statearr_24497_24601[(1)] = (9));

} else {
var statearr_24498_24602 = state_24384__$1;
(statearr_24498_24602[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24385 === (49))){
var inst_24189 = (state_24384[(22)]);
var inst_24147 = (state_24384[(12)]);
var inst_24187 = (state_24384[(21)]);
var inst_24284 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24285 = [inst_24187];
var inst_24286 = (new cljs.core.PersistentVector(null,1,(5),inst_24284,inst_24285,null));
var inst_24287 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24288 = [inst_24187,inst_24189];
var inst_24289 = (new cljs.core.PersistentVector(null,2,(5),inst_24287,inst_24288,null));
var inst_24290 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24291 = [inst_24147];
var inst_24292 = cljs.core.PersistentHashMap.fromArrays(inst_24290,inst_24291);
var inst_24293 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24286,cljs.core._LT_,inst_24289,inst_24292);
var state_24384__$1 = state_24384;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24384__$1,(52),inst_24293);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2717__auto__ = null;
var fluree$db$query$fql$state_machine__2717__auto____0 = (function (){
var statearr_24499 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24499[(0)] = fluree$db$query$fql$state_machine__2717__auto__);

(statearr_24499[(1)] = (1));

return statearr_24499;
});
var fluree$db$query$fql$state_machine__2717__auto____1 = (function (state_24384){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_24384);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e24500){var ex__2720__auto__ = e24500;
var statearr_24501_24603 = state_24384;
(statearr_24501_24603[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_24384[(4)]))){
var statearr_24502_24604 = state_24384;
(statearr_24502_24604[(1)] = cljs.core.first((state_24384[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24605 = state_24384;
state_24384 = G__24605;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2717__auto__ = function(state_24384){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2717__auto____1.call(this,state_24384);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2717__auto____0;
fluree$db$query$fql$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2717__auto____1;
return fluree$db$query$fql$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_24503 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_24503[(6)] = c__2739__auto__);

return statearr_24503;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 4);

fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(cljs.core.keys(x))))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var var_as_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.keys(x)));
var ___$1 = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(var_as_symbol) : valid_var.call(null,var_as_symbol)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_as_symbol,new cljs.core.Keyword(null,"selection","selection",975998651),cljs.core.first(cljs.core.vals(x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4212__auto__ = cljs.core.every_QMARK_((function (p1__24606_SHARP_){
return ((typeof p1__24606_SHARP_ === 'string') || (cljs.core.map_QMARK_(p1__24606_SHARP_)));
}),select_smt);
if(or__4212__auto__){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vars__$1 = cljs.core.set(vars);
var all_vars = cljs.core.set(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(vars__$1,cljs.core.keys(interim_vars)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select){
var var_symbol = ((cljs.core.map_QMARK_(select))?null:cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(select));
if(cljs.core.truth_((vars__$1.cljs$core$IFn$_invoke$arity$1 ? vars__$1.cljs$core$IFn$_invoke$arity$1(var_symbol) : vars__$1.call(null,var_symbol)))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_(select))){
return fluree.db.query.analytical.parse_aggregate(select,vars__$1);
} else {
if(cljs.core.map_QMARK_(select)){
return fluree.db.query.fql.parse_map(select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__24607_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__24607_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__24611 = vars;
var vec__24612 = G__24611;
var seq__24613 = cljs.core.seq(vec__24612);
var first__24614 = cljs.core.first(seq__24613);
var seq__24613__$1 = cljs.core.next(seq__24613);
var var$ = first__24614;
var r = seq__24613__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__24611__$1 = G__24611;
var all_vars__$1 = all_vars;
while(true){
var vec__24619 = G__24611__$1;
var seq__24620 = cljs.core.seq(vec__24619);
var first__24621 = cljs.core.first(seq__24620);
var seq__24620__$1 = cljs.core.next(seq__24620);
var var$__$1 = first__24621;
var r__$1 = seq__24620__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__24622 = cljs.core.set(all_vars__$2);
return (fexpr__24622.cljs$core$IFn$_invoke$arity$1 ? fexpr__24622.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__24622.call(null,var$__$1));
})())){
var G__24623 = r__$1;
var G__24624 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__24611__$1 = G__24623;
all_vars__$1 = G__24624;
continue;
} else {
var G__24625 = r__$1;
var G__24626 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__24611__$1 = G__24625;
all_vars__$1 = G__24626;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_24661){
var state_val_24662 = (state_24661[(1)]);
if((state_val_24662 === (1))){
var inst_24634 = functionArray;
var inst_24635 = cljs.core.seq(inst_24634);
var inst_24636 = cljs.core.first(inst_24635);
var inst_24637 = cljs.core.next(inst_24635);
var inst_24638 = cljs.core.PersistentVector.EMPTY;
var inst_24639 = inst_24634;
var inst_24640 = inst_24638;
var state_24661__$1 = (function (){var statearr_24663 = state_24661;
(statearr_24663[(7)] = inst_24640);

(statearr_24663[(8)] = inst_24636);

(statearr_24663[(9)] = inst_24637);

(statearr_24663[(10)] = inst_24639);

return statearr_24663;
})();
var statearr_24664_24677 = state_24661__$1;
(statearr_24664_24677[(2)] = null);

(statearr_24664_24677[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24662 === (2))){
var inst_24646 = (state_24661[(11)]);
var inst_24639 = (state_24661[(10)]);
var inst_24645 = cljs.core.seq(inst_24639);
var inst_24646__$1 = cljs.core.first(inst_24645);
var inst_24647 = cljs.core.next(inst_24645);
var state_24661__$1 = (function (){var statearr_24665 = state_24661;
(statearr_24665[(12)] = inst_24647);

(statearr_24665[(11)] = inst_24646__$1);

return statearr_24665;
})();
if(cljs.core.truth_(inst_24646__$1)){
var statearr_24666_24678 = state_24661__$1;
(statearr_24666_24678[(1)] = (4));

} else {
var statearr_24667_24679 = state_24661__$1;
(statearr_24667_24679[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24662 === (3))){
var inst_24659 = (state_24661[(2)]);
var state_24661__$1 = state_24661;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24661__$1,inst_24659);
} else {
if((state_val_24662 === (4))){
var inst_24646 = (state_24661[(11)]);
var inst_24649 = (inst_24646.cljs$core$IFn$_invoke$arity$1 ? inst_24646.cljs$core$IFn$_invoke$arity$1(tuple) : inst_24646.call(null,tuple));
var state_24661__$1 = state_24661;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24661__$1,(7),inst_24649);
} else {
if((state_val_24662 === (5))){
var inst_24640 = (state_24661[(7)]);
var state_24661__$1 = state_24661;
var statearr_24668_24680 = state_24661__$1;
(statearr_24668_24680[(2)] = inst_24640);

(statearr_24668_24680[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24662 === (6))){
var inst_24657 = (state_24661[(2)]);
var state_24661__$1 = state_24661;
var statearr_24669_24681 = state_24661__$1;
(statearr_24669_24681[(2)] = inst_24657);

(statearr_24669_24681[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24662 === (7))){
var inst_24647 = (state_24661[(12)]);
var inst_24640 = (state_24661[(7)]);
var inst_24651 = (state_24661[(2)]);
var inst_24652 = fluree.db.util.async.throw_err(inst_24651);
var inst_24653 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24640,inst_24652);
var inst_24639 = inst_24647;
var inst_24640__$1 = inst_24653;
var state_24661__$1 = (function (){var statearr_24670 = state_24661;
(statearr_24670[(7)] = inst_24640__$1);

(statearr_24670[(10)] = inst_24639);

return statearr_24670;
})();
var statearr_24671_24682 = state_24661__$1;
(statearr_24671_24682[(2)] = null);

(statearr_24671_24682[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__2717__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__2717__auto____0 = (function (){
var statearr_24672 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24672[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__2717__auto__);

(statearr_24672[(1)] = (1));

return statearr_24672;
});
var fluree$db$query$fql$format_tuple_$_state_machine__2717__auto____1 = (function (state_24661){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_24661);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e24673){var ex__2720__auto__ = e24673;
var statearr_24674_24683 = state_24661;
(statearr_24674_24683[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_24661[(4)]))){
var statearr_24675_24684 = state_24661;
(statearr_24675_24684[(1)] = cljs.core.first((state_24661[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24685 = state_24661;
state_24661 = G__24685;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__2717__auto__ = function(state_24661){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__2717__auto____1.call(this,state_24661);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__2717__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__2717__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_24676 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_24676[(6)] = c__2739__auto__);

return statearr_24676;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((function (idx,select_item){
var temp__5753__auto__ = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5753__auto__)){
var query_map = temp__5753__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__24686){
var vec__24687 = p__24686;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24687,(0),null);
var query_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24687,(1),null);
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tuple_result,tuple_index);
if(cljs.core.truth_(temp__5753__auto__)){
var _id = temp__5753__auto__;
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_24701){
var state_val_24702 = (state_24701[(1)]);
if((state_val_24702 === (1))){
var inst_24690 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24691 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_24692 = [query_map,_id,query_opts];
var inst_24693 = cljs.core.PersistentHashMap.fromArrays(inst_24691,inst_24692);
var inst_24694 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_24693) : fluree.db.query.fql.query.call(null,db,inst_24693));
var state_24701__$1 = (function (){var statearr_24703 = state_24701;
(statearr_24703[(7)] = inst_24690);

return statearr_24703;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24701__$1,(2),inst_24694);
} else {
if((state_val_24702 === (2))){
var inst_24690 = (state_24701[(7)]);
var inst_24696 = (state_24701[(2)]);
var inst_24697 = fluree.db.util.async.throw_err(inst_24696);
var inst_24698 = [tuple_index,inst_24697];
var inst_24699 = (new cljs.core.PersistentVector(null,2,(5),inst_24690,inst_24698,null));
var state_24701__$1 = state_24701;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24701__$1,inst_24699);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__2717__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__2717__auto____0 = (function (){
var statearr_24704 = [null,null,null,null,null,null,null,null];
(statearr_24704[(0)] = fluree$db$query$fql$expand_map_$_state_machine__2717__auto__);

(statearr_24704[(1)] = (1));

return statearr_24704;
});
var fluree$db$query$fql$expand_map_$_state_machine__2717__auto____1 = (function (state_24701){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_24701);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e24705){var ex__2720__auto__ = e24705;
var statearr_24706_24709 = state_24701;
(statearr_24706_24709[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_24701[(4)]))){
var statearr_24707_24710 = state_24701;
(statearr_24707_24710[(1)] = cljs.core.first((state_24701[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24711 = state_24701;
state_24701 = G__24711;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__2717__auto__ = function(state_24701){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__2717__auto____1.call(this,state_24701);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__2717__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__2717__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_24708 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_24708[(6)] = c__2739__auto__);

return statearr_24708;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_(expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__24712 = expand_map_tuple;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24712,(0),null);
var query_map_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24712,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_24775){
var state_val_24776 = (state_24775[(1)]);
if((state_val_24776 === (7))){
var inst_24770 = (state_24775[(2)]);
var _ = (function (){var statearr_24777 = state_24775;
(statearr_24777[(4)] = cljs.core.rest((state_24775[(4)])));

return statearr_24777;
})();
var state_24775__$1 = state_24775;
var statearr_24778_24869 = state_24775__$1;
(statearr_24778_24869[(2)] = inst_24770);

(statearr_24778_24869[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24776 === (20))){
var inst_24761 = (state_24775[(2)]);
var state_24775__$1 = state_24775;
var statearr_24779_24870 = state_24775__$1;
(statearr_24779_24870[(2)] = inst_24761);

(statearr_24779_24870[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24776 === (1))){
var state_24775__$1 = state_24775;
var statearr_24780_24871 = state_24775__$1;
(statearr_24780_24871[(2)] = null);

(statearr_24780_24871[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24776 === (4))){
var inst_24717 = (state_24775[(2)]);
var state_24775__$1 = state_24775;
var statearr_24781_24872 = state_24775__$1;
(statearr_24781_24872[(2)] = inst_24717);

(statearr_24781_24872[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24776 === (15))){
var inst_24737 = (state_24775[(7)]);
var inst_24746 = cljs.core.second(inst_24737);
var inst_24747 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_24746);
var inst_24748 = (inst_24747 > max_fuel);
var state_24775__$1 = state_24775;
if(cljs.core.truth_(inst_24748)){
var statearr_24782_24873 = state_24775__$1;
(statearr_24782_24873[(1)] = (18));

} else {
var statearr_24783_24874 = state_24775__$1;
(statearr_24783_24874[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24776 === (13))){
var state_24775__$1 = state_24775;
var statearr_24784_24875 = state_24775__$1;
(statearr_24784_24875[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24776 === (6))){
var inst_24725 = (state_24775[(8)]);
var state_24775__$1 = state_24775;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24775__$1,(8),inst_24725);
} else {
if((state_val_24776 === (17))){
var inst_24764 = (state_24775[(2)]);
var state_24775__$1 = state_24775;
var statearr_24786_24876 = state_24775__$1;
(statearr_24786_24876[(2)] = inst_24764);

(statearr_24786_24876[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24776 === (3))){
var inst_24773 = (state_24775[(2)]);
var state_24775__$1 = state_24775;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24775__$1,inst_24773);
} else {
if((state_val_24776 === (12))){
var inst_24726 = (state_24775[(9)]);
var inst_24737 = (state_24775[(7)]);
var inst_24743 = (inst_24726.cljs$core$IFn$_invoke$arity$0 ? inst_24726.cljs$core$IFn$_invoke$arity$0() : inst_24726.call(null));
var state_24775__$1 = (function (){var statearr_24787 = state_24775;
(statearr_24787[(10)] = inst_24743);

return statearr_24787;
})();
var statearr_24788_24877 = state_24775__$1;
(statearr_24788_24877[(2)] = inst_24737);

(statearr_24788_24877[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24776 === (2))){
var inst_24726 = (state_24775[(9)]);
var inst_24725 = (state_24775[(8)]);
var _ = (function (){var statearr_24789 = state_24775;
(statearr_24789[(4)] = cljs.core.cons((5),(state_24775[(4)])));

return statearr_24789;
})();
var inst_24723 = fluree.db.query.fql.build_expand_map(select,pp_keys);
var inst_24724 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_24725__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_24726__$1 = (function (){var expandMaps = inst_24723;
var queue_ch = inst_24724;
var res_ch = inst_24725__$1;
return (function (){
cljs.core.async.close_BANG_(queue_ch);

return cljs.core.async.close_BANG_(res_ch);
});
})();
var inst_24727 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667)], 0));
var inst_24728 = cljs.core.volatile_BANG_((0));
var inst_24729 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_24727,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_24728);
var inst_24730 = (function (){var expandMaps = inst_24723;
var queue_ch = inst_24724;
var res_ch = inst_24725__$1;
var stop_BANG_ = inst_24726__$1;
var opts_STAR_ = inst_24729;
return (function (tuple_res,port){
var c__2739__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_24822){
var state_val_24823 = (state_24822[(1)]);
if((state_val_24823 === (7))){
var state_24822__$1 = state_24822;
var statearr_24824_24878 = state_24822__$1;
(statearr_24824_24878[(2)] = tuple_res);

(statearr_24824_24878[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24823 === (1))){
var state_24822__$1 = state_24822;
var statearr_24825_24879 = state_24822__$1;
(statearr_24825_24879[(2)] = null);

(statearr_24825_24879[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24823 === (4))){
var inst_24790 = (state_24822[(2)]);
var inst_24791 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_24790);
var inst_24792 = cljs.core.async.close_BANG_(port);
var state_24822__$1 = (function (){var statearr_24826 = state_24822;
(statearr_24826[(7)] = inst_24791);

return statearr_24826;
})();
var statearr_24827_24880 = state_24822__$1;
(statearr_24827_24880[(2)] = inst_24792);

(statearr_24827_24880[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24823 === (6))){
var inst_24799 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24800 = [tuple_res];
var inst_24801 = (new cljs.core.PersistentVector(null,1,(5),inst_24799,inst_24800,null));
var state_24822__$1 = state_24822;
var statearr_24828_24881 = state_24822__$1;
(statearr_24828_24881[(2)] = inst_24801);

(statearr_24828_24881[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24823 === (3))){
var inst_24820 = (state_24822[(2)]);
var state_24822__$1 = state_24822;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24822__$1,inst_24820);
} else {
if((state_val_24823 === (2))){
var ___$1 = (function (){var statearr_24830 = state_24822;
(statearr_24830[(4)] = cljs.core.cons((5),(state_24822[(4)])));

return statearr_24830;
})();
var state_24822__$1 = state_24822;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_24831_24882 = state_24822__$1;
(statearr_24831_24882[(1)] = (6));

} else {
var statearr_24832_24883 = state_24822__$1;
(statearr_24832_24883[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24823 === (9))){
var inst_24804 = (state_24822[(8)]);
var inst_24806 = (state_24822[(9)]);
var inst_24813 = (state_24822[(2)]);
var inst_24814 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.replace_expand_maps,inst_24804,inst_24813);
var inst_24815 = (inst_24806.cljs$core$IFn$_invoke$arity$1 ? inst_24806.cljs$core$IFn$_invoke$arity$1(inst_24814) : inst_24806.call(null,inst_24814));
var inst_24816 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_24815);
var inst_24817 = cljs.core.async.close_BANG_(port);
var ___$1 = (function (){var statearr_24833 = state_24822;
(statearr_24833[(4)] = cljs.core.rest((state_24822[(4)])));

return statearr_24833;
})();
var state_24822__$1 = (function (){var statearr_24834 = state_24822;
(statearr_24834[(10)] = inst_24816);

return statearr_24834;
})();
var statearr_24835_24884 = state_24822__$1;
(statearr_24835_24884[(2)] = inst_24817);

(statearr_24835_24884[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24823 === (5))){
var ___$1 = (function (){var statearr_24836 = state_24822;
(statearr_24836[(4)] = cljs.core.rest((state_24822[(4)])));

return statearr_24836;
})();
var state_24822__$1 = state_24822;
var ex24829 = (state_24822__$1[(2)]);
var statearr_24837_24885 = state_24822__$1;
(statearr_24837_24885[(5)] = ex24829);


var statearr_24838_24886 = state_24822__$1;
(statearr_24838_24886[(1)] = (4));

(statearr_24838_24886[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24823 === (8))){
var inst_24804 = (state_24822[(8)]);
var inst_24804__$1 = (state_24822[(2)]);
var inst_24805 = cljs.core.volatile_BANG_((0));
var inst_24806 = (function (){var tuple_res_SINGLEQUOTE_ = inst_24804__$1;
var query_fuel = inst_24805;
return (function (p1__24716_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(p1__24716_SHARP_),cljs.core.deref(query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__24716_SHARP_,cljs.core.deref(query_fuel)], null);
}
});
})();
var inst_24807 = cljs.core.PersistentVector.EMPTY;
var inst_24808 = (function (){var tuple_res_SINGLEQUOTE_ = inst_24804__$1;
var query_fuel = inst_24805;
return (function (p1__24715_SHARP_){
return fluree.db.query.fql.expand_map(db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_STAR_,new cljs.core.Keyword(null,"fuel","fuel",10405485),fuel),tuple_res_SINGLEQUOTE_,p1__24715_SHARP_);
});
})();
var inst_24809 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(inst_24808,expandMaps);
var inst_24810 = cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1(inst_24809);
var inst_24811 = cljs.core.async.into(inst_24807,inst_24810);
var state_24822__$1 = (function (){var statearr_24839 = state_24822;
(statearr_24839[(8)] = inst_24804__$1);

(statearr_24839[(9)] = inst_24806);

return statearr_24839;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24822__$1,(9),inst_24811);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2717__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2717__auto____0 = (function (){
var statearr_24840 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24840[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2717__auto__);

(statearr_24840[(1)] = (1));

return statearr_24840;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2717__auto____1 = (function (state_24822){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_24822);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e24841){var ex__2720__auto__ = e24841;
var statearr_24842_24887 = state_24822;
(statearr_24842_24887[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_24822[(4)]))){
var statearr_24843_24888 = state_24822;
(statearr_24843_24888[(1)] = cljs.core.first((state_24822[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24889 = state_24822;
state_24822 = G__24889;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2717__auto__ = function(state_24822){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2717__auto____1.call(this,state_24822);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2717__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2717__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_24844 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_24844[(6)] = c__2739__auto____$1);

return statearr_24844;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto____$1;
});
})();
var inst_24731 = cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(inst_24724,tuples_res);
var inst_24732 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_24725__$1,inst_24730,inst_24724);
var inst_24733 = cljs.core.PersistentVector.EMPTY;
var inst_24734 = inst_24733;
var state_24775__$1 = (function (){var statearr_24845 = state_24775;
(statearr_24845[(11)] = inst_24731);

(statearr_24845[(12)] = inst_24732);

(statearr_24845[(9)] = inst_24726__$1);

(statearr_24845[(13)] = inst_24734);

(statearr_24845[(8)] = inst_24725__$1);

return statearr_24845;
})();
var statearr_24846_24890 = state_24775__$1;
(statearr_24846_24890[(2)] = null);

(statearr_24846_24890[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24776 === (19))){
var inst_24734 = (state_24775[(13)]);
var inst_24737 = (state_24775[(7)]);
var inst_24757 = cljs.core.first(inst_24737);
var inst_24758 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24734,inst_24757);
var inst_24734__$1 = inst_24758;
var state_24775__$1 = (function (){var statearr_24847 = state_24775;
(statearr_24847[(13)] = inst_24734__$1);

return statearr_24847;
})();
var statearr_24848_24891 = state_24775__$1;
(statearr_24848_24891[(2)] = null);

(statearr_24848_24891[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24776 === (11))){
var inst_24768 = (state_24775[(2)]);
var state_24775__$1 = state_24775;
var statearr_24850_24892 = state_24775__$1;
(statearr_24850_24892[(2)] = inst_24768);

(statearr_24850_24892[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24776 === (9))){
var inst_24734 = (state_24775[(13)]);
var state_24775__$1 = state_24775;
var statearr_24851_24893 = state_24775__$1;
(statearr_24851_24893[(2)] = inst_24734);

(statearr_24851_24893[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24776 === (5))){
var _ = (function (){var statearr_24852 = state_24775;
(statearr_24852[(4)] = cljs.core.rest((state_24775[(4)])));

return statearr_24852;
})();
var state_24775__$1 = state_24775;
var ex24849 = (state_24775__$1[(2)]);
var statearr_24853_24894 = state_24775__$1;
(statearr_24853_24894[(5)] = ex24849);


if((ex24849 instanceof Error)){
var statearr_24854_24895 = state_24775__$1;
(statearr_24854_24895[(1)] = (4));

(statearr_24854_24895[(5)] = null);

} else {
throw ex24849;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24776 === (14))){
var inst_24766 = (state_24775[(2)]);
var state_24775__$1 = state_24775;
var statearr_24855_24896 = state_24775__$1;
(statearr_24855_24896[(2)] = inst_24766);

(statearr_24855_24896[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24776 === (16))){
var state_24775__$1 = state_24775;
var statearr_24856_24897 = state_24775__$1;
(statearr_24856_24897[(2)] = null);

(statearr_24856_24897[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24776 === (10))){
var inst_24737 = (state_24775[(7)]);
var inst_24741 = fluree.db.util.core.exception_QMARK_(inst_24737);
var state_24775__$1 = state_24775;
if(inst_24741){
var statearr_24857_24898 = state_24775__$1;
(statearr_24857_24898[(1)] = (12));

} else {
var statearr_24858_24899 = state_24775__$1;
(statearr_24858_24899[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24776 === (18))){
var inst_24726 = (state_24775[(9)]);
var inst_24750 = (inst_24726.cljs$core$IFn$_invoke$arity$0 ? inst_24726.cljs$core$IFn$_invoke$arity$0() : inst_24726.call(null));
var inst_24751 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_24752 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_24753 = [new cljs.core.Keyword("db","insufficient-fuel","db/insufficient-fuel",344386102),(400)];
var inst_24754 = cljs.core.PersistentHashMap.fromArrays(inst_24752,inst_24753);
var inst_24755 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_24751,inst_24754);
var state_24775__$1 = (function (){var statearr_24859 = state_24775;
(statearr_24859[(14)] = inst_24750);

return statearr_24859;
})();
var statearr_24860_24900 = state_24775__$1;
(statearr_24860_24900[(2)] = inst_24755);

(statearr_24860_24900[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24776 === (8))){
var inst_24737 = (state_24775[(7)]);
var inst_24737__$1 = (state_24775[(2)]);
var inst_24738 = (inst_24737__$1 == null);
var state_24775__$1 = (function (){var statearr_24861 = state_24775;
(statearr_24861[(7)] = inst_24737__$1);

return statearr_24861;
})();
if(cljs.core.truth_(inst_24738)){
var statearr_24862_24901 = state_24775__$1;
(statearr_24862_24901[(1)] = (9));

} else {
var statearr_24863_24902 = state_24775__$1;
(statearr_24863_24902[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2717__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2717__auto____0 = (function (){
var statearr_24864 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24864[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2717__auto__);

(statearr_24864[(1)] = (1));

return statearr_24864;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2717__auto____1 = (function (state_24775){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_24775);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e24865){var ex__2720__auto__ = e24865;
var statearr_24866_24903 = state_24775;
(statearr_24866_24903[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_24775[(4)]))){
var statearr_24867_24904 = state_24775;
(statearr_24867_24904[(1)] = cljs.core.first((state_24775[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24905 = state_24775;
state_24775 = G__24905;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2717__auto__ = function(state_24775){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2717__auto____1.call(this,state_24775);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2717__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2717__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_24868 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_24868[(6)] = c__2739__auto__);

return statearr_24868;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__24906 = select;
var map__24906__$1 = cljs.core.__destructure_map(map__24906);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24906__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24906__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24906__$1,new cljs.core.Keyword(null,"value","value",305978217));
var select_val = (function (){var or__4212__auto__ = as;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx(headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly(value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?cljs.core.constantly(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__24909 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24909,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24909,(1),null);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24909,(2),null);
var comparator = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?(function (a,b){
return cljs.core.compare(b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("NOCASE",clojure.string.upper_case(option))));
var keyfn = ((no_case_QMARK_)?(function (p1__24907_SHARP_){
return clojure.string.upper_case(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__24907_SHARP_,compare_idx));
}):(function (p1__24908_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__24908_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,(((no_case_QMARK_)?(4):(2)) * cljs.core.count(tuples)));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__24914 = arguments.length;
switch (G__24914) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__24915,p__24916,group_limit,opts){
var map__24917 = p__24915;
var map__24917__$1 = cljs.core.__destructure_map(map__24917);
var res = map__24917__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24917__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__24918 = p__24916;
var map__24918__$1 = cljs.core.__destructure_map(map__24918);
var select_spec = map__24918__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24918__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24918__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24918__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24918__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24918__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24918__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24918__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24918__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24918__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24918__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_25055){
var state_val_25056 = (state_25055[(1)]);
if((state_val_25056 === (7))){
var inst_24925 = (state_25055[(7)]);
var state_25055__$1 = state_25055;
var statearr_25057_25159 = state_25055__$1;
(statearr_25057_25159[(2)] = inst_24925);

(statearr_25057_25159[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (59))){
var inst_25048 = (state_25055[(2)]);
var state_25055__$1 = state_25055;
var statearr_25058_25160 = state_25055__$1;
(statearr_25058_25160[(2)] = inst_25048);

(statearr_25058_25160[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (20))){
var inst_24961 = (state_25055[(8)]);
var inst_24964 = (state_25055[(9)]);
var inst_24960 = (state_25055[(2)]);
var inst_24961__$1 = cljs.core.__destructure_map(inst_24960);
var inst_24962 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24961__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_24963 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24961__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_24964__$1 = offset;
var state_25055__$1 = (function (){var statearr_25059 = state_25055;
(statearr_25059[(10)] = inst_24963);

(statearr_25059[(11)] = inst_24962);

(statearr_25059[(8)] = inst_24961__$1);

(statearr_25059[(9)] = inst_24964__$1);

return statearr_25059;
})();
if(cljs.core.truth_(inst_24964__$1)){
var statearr_25060_25161 = state_25055__$1;
(statearr_25060_25161[(1)] = (21));

} else {
var statearr_25061_25162 = state_25055__$1;
(statearr_25061_25162[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (58))){
var inst_25040 = (state_25055[(12)]);
var state_25055__$1 = state_25055;
var statearr_25062_25163 = state_25055__$1;
(statearr_25062_25163[(2)] = inst_25040);

(statearr_25062_25163[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (60))){
var inst_25044 = (state_25055[(2)]);
var inst_25045 = fluree.db.util.async.throw_err(inst_25044);
var state_25055__$1 = state_25055;
var statearr_25063_25164 = state_25055__$1;
(statearr_25063_25164[(2)] = inst_25045);

(statearr_25063_25164[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (27))){
var inst_24976 = cljs.core.not(inVector_QMARK_);
var state_25055__$1 = state_25055;
var statearr_25064_25165 = state_25055__$1;
(statearr_25064_25165[(2)] = inst_24976);

(statearr_25064_25165[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (1))){
var state_25055__$1 = state_25055;
var statearr_25065_25166 = state_25055__$1;
(statearr_25065_25166[(2)] = null);

(statearr_25065_25166[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (24))){
var state_25055__$1 = state_25055;
var statearr_25066_25167 = state_25055__$1;
(statearr_25066_25167[(2)] = offset);

(statearr_25066_25167[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (55))){
var inst_25034 = (state_25055[(13)]);
var state_25055__$1 = state_25055;
var statearr_25067_25168 = state_25055__$1;
(statearr_25067_25168[(2)] = inst_25034);

(statearr_25067_25168[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (39))){
var inst_25002 = (state_25055[(14)]);
var inst_25004 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_25005 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25002,inst_25004);
var state_25055__$1 = state_25055;
var statearr_25068_25169 = state_25055__$1;
(statearr_25068_25169[(2)] = inst_25005);

(statearr_25068_25169[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (46))){
var inst_25014 = (state_25055[(15)]);
var state_25055__$1 = state_25055;
var statearr_25069_25170 = state_25055__$1;
(statearr_25069_25170[(2)] = inst_25014);

(statearr_25069_25170[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (4))){
var inst_24919 = (state_25055[(2)]);
var state_25055__$1 = state_25055;
var statearr_25070_25171 = state_25055__$1;
(statearr_25070_25171[(2)] = inst_24919);

(statearr_25070_25171[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (54))){
var inst_25028 = (state_25055[(16)]);
var inst_25034 = (state_25055[(13)]);
var inst_25036 = cljs.core.PersistentVector.EMPTY;
var inst_25037 = cljs.core.into.cljs$core$IFn$_invoke$arity$3(inst_25036,inst_25028,inst_25034);
var state_25055__$1 = state_25055;
var statearr_25071_25172 = state_25055__$1;
(statearr_25071_25172[(2)] = inst_25037);

(statearr_25071_25172[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (15))){
var inst_24946 = (state_25055[(17)]);
var inst_24948 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24949 = [inst_24946];
var inst_24950 = (new cljs.core.PersistentVector(null,1,(5),inst_24948,inst_24949,null));
var state_25055__$1 = state_25055;
var statearr_25072_25173 = state_25055__$1;
(statearr_25072_25173[(2)] = inst_24950);

(statearr_25072_25173[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (48))){
var inst_24979 = (state_25055[(18)]);
var inst_24963 = (state_25055[(10)]);
var inst_25020 = (state_25055[(19)]);
var inst_24962 = (state_25055[(11)]);
var inst_24984 = (state_25055[(20)]);
var inst_24961 = (state_25055[(8)]);
var inst_24973 = (state_25055[(21)]);
var inst_25022 = (function (){var map__24955 = inst_24961;
var headers = inst_24962;
var tuples = inst_24963;
var offset_SINGLEQUOTE_ = inst_24973;
var single_result_QMARK_ = inst_24979;
var pp_keys = inst_24984;
var G__24985 = inst_25020;
return (function (p1__24912_SHARP_){
return cljs.core.zipmap(fluree.db.query.fql.get_pretty_print_keys(select),p1__24912_SHARP_);
});
})();
var inst_25023 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_25022);
var inst_25024 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25020,inst_25023);
var state_25055__$1 = state_25055;
var statearr_25073_25174 = state_25055__$1;
(statearr_25073_25174[(2)] = inst_25024);

(statearr_25073_25174[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (50))){
var inst_25027 = (state_25055[(2)]);
var inst_25028 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,inst_25027);
var state_25055__$1 = (function (){var statearr_25074 = state_25055;
(statearr_25074[(16)] = inst_25028);

return statearr_25074;
})();
if(cljs.core.truth_(orderBy)){
var statearr_25075_25175 = state_25055__$1;
(statearr_25075_25175[(1)] = (51));

} else {
var statearr_25076_25176 = state_25055__$1;
(statearr_25076_25176[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (21))){
var inst_24966 = cljs.core.not(groupBy);
var state_25055__$1 = state_25055;
var statearr_25077_25177 = state_25055__$1;
(statearr_25077_25177[(2)] = inst_24966);

(statearr_25077_25177[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (31))){
var state_25055__$1 = state_25055;
var statearr_25078_25178 = state_25055__$1;
(statearr_25078_25178[(2)] = null);

(statearr_25078_25178[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (32))){
var inst_24979 = (state_25055[(18)]);
var inst_24962 = (state_25055[(11)]);
var inst_24984 = (state_25055[(2)]);
var inst_24986 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24987 = fluree.db.query.fql.select_tuples_fn(inst_24962,vars,select);
var inst_24988 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_24987);
var inst_24989 = [inst_24988];
var inst_24990 = (new cljs.core.PersistentVector(null,1,(5),inst_24986,inst_24989,null));
var state_25055__$1 = (function (){var statearr_25079 = state_25055;
(statearr_25079[(22)] = inst_24990);

(statearr_25079[(20)] = inst_24984);

return statearr_25079;
})();
if(cljs.core.truth_(inst_24979)){
var statearr_25080_25179 = state_25055__$1;
(statearr_25080_25179[(1)] = (33));

} else {
var statearr_25081_25180 = state_25055__$1;
(statearr_25081_25180[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (40))){
var inst_25002 = (state_25055[(14)]);
var state_25055__$1 = state_25055;
var statearr_25082_25181 = state_25055__$1;
(statearr_25082_25181[(2)] = inst_25002);

(statearr_25082_25181[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (56))){
var inst_25040 = (state_25055[(2)]);
var state_25055__$1 = (function (){var statearr_25083 = state_25055;
(statearr_25083[(12)] = inst_25040);

return statearr_25083;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_25084_25182 = state_25055__$1;
(statearr_25084_25182[(1)] = (57));

} else {
var statearr_25085_25183 = state_25055__$1;
(statearr_25085_25183[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (33))){
var inst_24990 = (state_25055[(22)]);
var inst_24992 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(cljs.core.first);
var inst_24993 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24990,inst_24992);
var state_25055__$1 = state_25055;
var statearr_25086_25184 = state_25055__$1;
(statearr_25086_25184[(2)] = inst_24993);

(statearr_25086_25184[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (13))){
var inst_24935 = (state_25055[(23)]);
var state_25055__$1 = state_25055;
var statearr_25087_25185 = state_25055__$1;
(statearr_25087_25185[(2)] = inst_24935);

(statearr_25087_25185[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (22))){
var inst_24964 = (state_25055[(9)]);
var state_25055__$1 = state_25055;
var statearr_25088_25186 = state_25055__$1;
(statearr_25088_25186[(2)] = inst_24964);

(statearr_25088_25186[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (36))){
var inst_24996 = (state_25055[(24)]);
var inst_24998 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(5));
var inst_24999 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24996,inst_24998);
var state_25055__$1 = state_25055;
var statearr_25089_25187 = state_25055__$1;
(statearr_25089_25187[(2)] = inst_24999);

(statearr_25089_25187[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (41))){
var inst_24973 = (state_25055[(21)]);
var inst_25008 = (state_25055[(2)]);
var state_25055__$1 = (function (){var statearr_25090 = state_25055;
(statearr_25090[(25)] = inst_25008);

return statearr_25090;
})();
if(cljs.core.truth_(inst_24973)){
var statearr_25091_25188 = state_25055__$1;
(statearr_25091_25188[(1)] = (42));

} else {
var statearr_25092_25189 = state_25055__$1;
(statearr_25092_25189[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (43))){
var inst_25008 = (state_25055[(25)]);
var state_25055__$1 = state_25055;
var statearr_25093_25190 = state_25055__$1;
(statearr_25093_25190[(2)] = inst_25008);

(statearr_25093_25190[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (29))){
var inst_24979 = (state_25055[(2)]);
var state_25055__$1 = (function (){var statearr_25094 = state_25055;
(statearr_25094[(18)] = inst_24979);

return statearr_25094;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25095_25191 = state_25055__$1;
(statearr_25095_25191[(1)] = (30));

} else {
var statearr_25096_25192 = state_25055__$1;
(statearr_25096_25192[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (44))){
var inst_25014 = (state_25055[(2)]);
var state_25055__$1 = (function (){var statearr_25097 = state_25055;
(statearr_25097[(15)] = inst_25014);

return statearr_25097;
})();
if(cljs.core.truth_(group_limit)){
var statearr_25098_25193 = state_25055__$1;
(statearr_25098_25193[(1)] = (45));

} else {
var statearr_25099_25194 = state_25055__$1;
(statearr_25099_25194[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (6))){
var inst_24927 = cljs.core.count(select);
var inst_24928 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_24927);
var state_25055__$1 = state_25055;
var statearr_25100_25195 = state_25055__$1;
(statearr_25100_25195[(2)] = inst_24928);

(statearr_25100_25195[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (28))){
var inst_24974 = (state_25055[(26)]);
var state_25055__$1 = state_25055;
var statearr_25101_25196 = state_25055__$1;
(statearr_25101_25196[(2)] = inst_24974);

(statearr_25101_25196[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (51))){
var inst_24963 = (state_25055[(10)]);
var inst_24962 = (state_25055[(11)]);
var inst_25031 = fluree.db.query.fql.order_result_tuples(fuel,max_fuel,inst_24962,orderBy,inst_24963);
var state_25055__$1 = state_25055;
var statearr_25102_25197 = state_25055__$1;
(statearr_25102_25197[(2)] = inst_25031);

(statearr_25102_25197[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (25))){
var state_25055__$1 = state_25055;
var statearr_25103_25198 = state_25055__$1;
(statearr_25103_25198[(2)] = null);

(statearr_25103_25198[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (34))){
var inst_24990 = (state_25055[(22)]);
var state_25055__$1 = state_25055;
var statearr_25104_25199 = state_25055__$1;
(statearr_25104_25199[(2)] = inst_24990);

(statearr_25104_25199[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (17))){
var inst_24953 = (state_25055[(2)]);
var state_25055__$1 = state_25055;
var statearr_25105_25200 = state_25055__$1;
(statearr_25105_25200[(2)] = inst_24953);

(statearr_25105_25200[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (3))){
var inst_25053 = (state_25055[(2)]);
var state_25055__$1 = state_25055;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25055__$1,inst_25053);
} else {
if((state_val_25056 === (12))){
var inst_24935 = (state_25055[(23)]);
var inst_24937 = cljs.core.first(select);
var inst_24938 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_24937);
var inst_24939 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24938);
var inst_24940 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_24939,(1));
var inst_24941 = [inst_24940];
var inst_24942 = [inst_24935];
var inst_24943 = cljs.core.PersistentHashMap.fromArrays(inst_24941,inst_24942);
var state_25055__$1 = state_25055;
var statearr_25106_25201 = state_25055__$1;
(statearr_25106_25201[(2)] = inst_24943);

(statearr_25106_25201[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (2))){
var inst_24925 = (state_25055[(7)]);
var _ = (function (){var statearr_25107 = state_25055;
(statearr_25107[(4)] = cljs.core.cons((5),(state_25055[(4)])));

return statearr_25107;
})();
var inst_24925__$1 = aggregates;
var state_25055__$1 = (function (){var statearr_25108 = state_25055;
(statearr_25108[(7)] = inst_24925__$1);

return statearr_25108;
})();
if(cljs.core.truth_(inst_24925__$1)){
var statearr_25109_25202 = state_25055__$1;
(statearr_25109_25202[(1)] = (6));

} else {
var statearr_25110_25203 = state_25055__$1;
(statearr_25110_25203[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (23))){
var inst_24969 = (state_25055[(2)]);
var state_25055__$1 = state_25055;
if(cljs.core.truth_(inst_24969)){
var statearr_25111_25204 = state_25055__$1;
(statearr_25111_25204[(1)] = (24));

} else {
var statearr_25112_25205 = state_25055__$1;
(statearr_25112_25205[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (47))){
var inst_25020 = (state_25055[(2)]);
var state_25055__$1 = (function (){var statearr_25113 = state_25055;
(statearr_25113[(19)] = inst_25020);

return statearr_25113;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25114_25206 = state_25055__$1;
(statearr_25114_25206[(1)] = (48));

} else {
var statearr_25115_25207 = state_25055__$1;
(statearr_25115_25207[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (35))){
var inst_24996 = (state_25055[(2)]);
var state_25055__$1 = (function (){var statearr_25116 = state_25055;
(statearr_25116[(24)] = inst_24996);

return statearr_25116;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25117_25208 = state_25055__$1;
(statearr_25117_25208[(1)] = (36));

} else {
var statearr_25118_25209 = state_25055__$1;
(statearr_25118_25209[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (19))){
var state_25055__$1 = state_25055;
var statearr_25119_25210 = state_25055__$1;
(statearr_25119_25210[(2)] = res);

(statearr_25119_25210[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (57))){
var inst_24979 = (state_25055[(18)]);
var inst_24984 = (state_25055[(20)]);
var inst_25040 = (state_25055[(12)]);
var inst_25042 = fluree.db.query.fql.pipeline_expandmaps_result(select,inst_24984,inst_24979,db,fuel,max_fuel,opts,(8),inst_25040);
var state_25055__$1 = state_25055;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25055__$1,(60),inst_25042);
} else {
if((state_val_25056 === (11))){
var inst_25050 = (state_25055[(2)]);
var _ = (function (){var statearr_25121 = state_25055;
(statearr_25121[(4)] = cljs.core.rest((state_25055[(4)])));

return statearr_25121;
})();
var state_25055__$1 = state_25055;
var statearr_25122_25211 = state_25055__$1;
(statearr_25122_25211[(2)] = inst_25050);

(statearr_25122_25211[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (9))){
var inst_24933 = cljs.core.first(aggregates);
var inst_24934 = fluree.db.query.analytical.calculate_aggregate(res,inst_24933);
var inst_24935 = cljs.core.second(inst_24934);
var state_25055__$1 = (function (){var statearr_25123 = state_25055;
(statearr_25123[(23)] = inst_24935);

return statearr_25123;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25124_25212 = state_25055__$1;
(statearr_25124_25212[(1)] = (12));

} else {
var statearr_25125_25213 = state_25055__$1;
(statearr_25125_25213[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (5))){
var _ = (function (){var statearr_25126 = state_25055;
(statearr_25126[(4)] = cljs.core.rest((state_25055[(4)])));

return statearr_25126;
})();
var state_25055__$1 = state_25055;
var ex25120 = (state_25055__$1[(2)]);
var statearr_25127_25214 = state_25055__$1;
(statearr_25127_25214[(5)] = ex25120);


if((ex25120 instanceof Error)){
var statearr_25128_25215 = state_25055__$1;
(statearr_25128_25215[(1)] = (4));

(statearr_25128_25215[(5)] = null);

} else {
throw ex25120;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (14))){
var inst_24946 = (state_25055[(2)]);
var state_25055__$1 = (function (){var statearr_25129 = state_25055;
(statearr_25129[(17)] = inst_24946);

return statearr_25129;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25130_25216 = state_25055__$1;
(statearr_25130_25216[(1)] = (15));

} else {
var statearr_25131_25217 = state_25055__$1;
(statearr_25131_25217[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (45))){
var inst_25014 = (state_25055[(15)]);
var inst_25016 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(group_limit);
var inst_25017 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25014,inst_25016);
var state_25055__$1 = state_25055;
var statearr_25132_25218 = state_25055__$1;
(statearr_25132_25218[(2)] = inst_25017);

(statearr_25132_25218[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (53))){
var inst_25034 = (state_25055[(2)]);
var state_25055__$1 = (function (){var statearr_25133 = state_25055;
(statearr_25133[(13)] = inst_25034);

return statearr_25133;
})();
var statearr_25134_25219 = state_25055__$1;
(statearr_25134_25219[(1)] = (54));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (26))){
var inst_24974 = (state_25055[(26)]);
var inst_24973 = (state_25055[(2)]);
var inst_24974__$1 = cljs.core.not(prettyPrint);
var state_25055__$1 = (function (){var statearr_25136 = state_25055;
(statearr_25136[(21)] = inst_24973);

(statearr_25136[(26)] = inst_24974__$1);

return statearr_25136;
})();
if(inst_24974__$1){
var statearr_25137_25220 = state_25055__$1;
(statearr_25137_25220[(1)] = (27));

} else {
var statearr_25138_25221 = state_25055__$1;
(statearr_25138_25221[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (16))){
var inst_24946 = (state_25055[(17)]);
var state_25055__$1 = state_25055;
var statearr_25139_25222 = state_25055__$1;
(statearr_25139_25222[(2)] = inst_24946);

(statearr_25139_25222[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (38))){
var inst_25002 = (state_25055[(2)]);
var state_25055__$1 = (function (){var statearr_25140 = state_25055;
(statearr_25140[(14)] = inst_25002);

return statearr_25140;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25141_25223 = state_25055__$1;
(statearr_25141_25223[(1)] = (39));

} else {
var statearr_25142_25224 = state_25055__$1;
(statearr_25142_25224[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (30))){
var inst_24981 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_25055__$1 = state_25055;
var statearr_25143_25225 = state_25055__$1;
(statearr_25143_25225[(2)] = inst_24981);

(statearr_25143_25225[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (10))){
var state_25055__$1 = state_25055;
if(cljs.core.truth_(aggregates)){
var statearr_25144_25226 = state_25055__$1;
(statearr_25144_25226[(1)] = (18));

} else {
var statearr_25145_25227 = state_25055__$1;
(statearr_25145_25227[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (18))){
var inst_24957 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_25055__$1 = state_25055;
var statearr_25146_25228 = state_25055__$1;
(statearr_25146_25228[(2)] = inst_24957);

(statearr_25146_25228[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (52))){
var inst_24963 = (state_25055[(10)]);
var state_25055__$1 = state_25055;
var statearr_25147_25229 = state_25055__$1;
(statearr_25147_25229[(2)] = inst_24963);

(statearr_25147_25229[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (42))){
var inst_25008 = (state_25055[(25)]);
var inst_24973 = (state_25055[(21)]);
var inst_25010 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(inst_24973);
var inst_25011 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25008,inst_25010);
var state_25055__$1 = state_25055;
var statearr_25148_25230 = state_25055__$1;
(statearr_25148_25230[(2)] = inst_25011);

(statearr_25148_25230[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (37))){
var inst_24996 = (state_25055[(24)]);
var state_25055__$1 = state_25055;
var statearr_25149_25231 = state_25055__$1;
(statearr_25149_25231[(2)] = inst_24996);

(statearr_25149_25231[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (8))){
var inst_24931 = (state_25055[(2)]);
var state_25055__$1 = state_25055;
if(cljs.core.truth_(inst_24931)){
var statearr_25150_25232 = state_25055__$1;
(statearr_25150_25232[(1)] = (9));

} else {
var statearr_25151_25233 = state_25055__$1;
(statearr_25151_25233[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25056 === (49))){
var inst_25020 = (state_25055[(19)]);
var state_25055__$1 = state_25055;
var statearr_25152_25234 = state_25055__$1;
(statearr_25152_25234[(2)] = inst_25020);

(statearr_25152_25234[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2717__auto__ = null;
var fluree$db$query$fql$state_machine__2717__auto____0 = (function (){
var statearr_25153 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25153[(0)] = fluree$db$query$fql$state_machine__2717__auto__);

(statearr_25153[(1)] = (1));

return statearr_25153;
});
var fluree$db$query$fql$state_machine__2717__auto____1 = (function (state_25055){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_25055);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e25154){var ex__2720__auto__ = e25154;
var statearr_25155_25235 = state_25055;
(statearr_25155_25235[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_25055[(4)]))){
var statearr_25156_25236 = state_25055;
(statearr_25156_25236[(1)] = cljs.core.first((state_25055[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25237 = state_25055;
state_25055 = G__25237;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2717__auto__ = function(state_25055){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2717__auto____1.call(this,state_25055);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2717__auto____0;
fluree$db$query$fql$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2717__auto____1;
return fluree$db$query$fql$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_25157 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_25157[(6)] = c__2739__auto__);

return statearr_25157;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__25240,groupBy){
var map__25241 = p__25240;
var map__25241__$1 = cljs.core.__destructure_map(map__25241);
var res = map__25241__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25241__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25241__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__25242 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25242,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25242,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__25238_SHARP_){
return fluree.db.util.core.index_of(headers,p1__25238_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__25239_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__25239_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__25245 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25245,(0),null);
var sortCriteria = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25245,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortCriteria,groupBy)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_(groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of(groupBy,sortCriteria);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__25248,p__25249,opts){
var map__25250 = p__25248;
var map__25250__$1 = cljs.core.__destructure_map(map__25250);
var res = map__25250__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25250__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25250__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__25251 = p__25249;
var map__25251__$1 = cljs.core.__destructure_map(map__25251);
var select_spec = map__25251__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25251__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25251__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25251__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25251__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25251__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25251__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25251__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_25493){
var state_val_25494 = (state_25493[(1)]);
if((state_val_25494 === (65))){
var state_25493__$1 = state_25493;
var statearr_25495_25646 = state_25493__$1;
(statearr_25495_25646[(1)] = (67));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (70))){
var inst_25414 = (state_25493[(7)]);
var state_25493__$1 = state_25493;
var statearr_25497_25647 = state_25493__$1;
(statearr_25497_25647[(2)] = inst_25414);

(statearr_25497_25647[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (62))){
var state_25493__$1 = state_25493;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25498_25648 = state_25493__$1;
(statearr_25498_25648[(1)] = (64));

} else {
var statearr_25499_25649 = state_25493__$1;
(statearr_25499_25649[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (74))){
var inst_25389 = (state_25493[(8)]);
var inst_25330 = (state_25493[(9)]);
var inst_25321 = (state_25493[(10)]);
var inst_25422 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25321,inst_25330,inst_25389);
var state_25493__$1 = state_25493;
var statearr_25500_25650 = state_25493__$1;
(statearr_25500_25650[(2)] = inst_25422);

(statearr_25500_25650[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (7))){
var state_25493__$1 = state_25493;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25501_25651 = state_25493__$1;
(statearr_25501_25651[(1)] = (82));

} else {
var statearr_25502_25652 = state_25493__$1;
(statearr_25502_25652[(1)] = (83));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (59))){
var inst_25319 = (state_25493[(11)]);
var inst_25389 = (state_25493[(8)]);
var inst_25393 = cljs.core.count(inst_25389);
var inst_25394 = (inst_25319 - inst_25393);
var state_25493__$1 = state_25493;
var statearr_25503_25653 = state_25493__$1;
(statearr_25503_25653[(2)] = inst_25394);

(statearr_25503_25653[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (86))){
var state_25493__$1 = state_25493;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25504_25654 = state_25493__$1;
(statearr_25504_25654[(1)] = (89));

} else {
var statearr_25505_25655 = state_25493__$1;
(statearr_25505_25655[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (20))){
var state_25493__$1 = state_25493;
var statearr_25506_25656 = state_25493__$1;
(statearr_25506_25656[(2)] = (0));

(statearr_25506_25656[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (72))){
var inst_25419 = (state_25493[(2)]);
var state_25493__$1 = state_25493;
if(cljs.core.truth_(inst_25419)){
var statearr_25507_25657 = state_25493__$1;
(statearr_25507_25657[(1)] = (73));

} else {
var statearr_25508_25658 = state_25493__$1;
(statearr_25508_25658[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (58))){
var state_25493__$1 = state_25493;
var statearr_25509_25659 = state_25493__$1;
(statearr_25509_25659[(2)] = null);

(statearr_25509_25659[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (60))){
var inst_25320 = (state_25493[(12)]);
var inst_25396 = (state_25493[(2)]);
var inst_25397 = (inst_25320 <= (0));
var state_25493__$1 = (function (){var statearr_25510 = state_25493;
(statearr_25510[(13)] = inst_25396);

return statearr_25510;
})();
if(cljs.core.truth_(inst_25397)){
var statearr_25511_25660 = state_25493__$1;
(statearr_25511_25660[(1)] = (61));

} else {
var statearr_25512_25661 = state_25493__$1;
(statearr_25512_25661[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (27))){
var inst_25319 = (state_25493[(11)]);
var inst_25343 = (inst_25319 < (1));
var state_25493__$1 = state_25493;
var statearr_25513_25662 = state_25493__$1;
(statearr_25513_25662[(2)] = inst_25343);

(statearr_25513_25662[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (1))){
var state_25493__$1 = state_25493;
var statearr_25514_25663 = state_25493__$1;
(statearr_25514_25663[(2)] = null);

(statearr_25514_25663[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (69))){
var inst_25409 = (state_25493[(2)]);
var state_25493__$1 = state_25493;
var statearr_25515_25664 = state_25493__$1;
(statearr_25515_25664[(2)] = inst_25409);

(statearr_25515_25664[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (24))){
var inst_25321 = (state_25493[(10)]);
var state_25493__$1 = state_25493;
var statearr_25516_25665 = state_25493__$1;
(statearr_25516_25665[(2)] = inst_25321);

(statearr_25516_25665[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (55))){
var inst_25379 = (state_25493[(14)]);
var inst_25319 = (state_25493[(11)]);
var inst_25386 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_25319,inst_25379);
var state_25493__$1 = state_25493;
var statearr_25517_25666 = state_25493__$1;
(statearr_25517_25666[(2)] = inst_25386);

(statearr_25517_25666[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (85))){
var inst_25464 = (state_25493[(15)]);
var inst_25463 = (state_25493[(2)]);
var inst_25464__$1 = fluree.db.util.async.throw_err(inst_25463);
var inst_25465 = cljs.core.coll_QMARK_(inst_25464__$1);
var inst_25466 = (!(inst_25465));
var state_25493__$1 = (function (){var statearr_25518 = state_25493;
(statearr_25518[(15)] = inst_25464__$1);

return statearr_25518;
})();
if(inst_25466){
var statearr_25519_25667 = state_25493__$1;
(statearr_25519_25667[(1)] = (86));

} else {
var statearr_25520_25668 = state_25493__$1;
(statearr_25520_25668[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (39))){
var inst_25338 = (state_25493[(16)]);
var inst_25360 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(select_spec,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null], 0));
var inst_25361 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"offset","offset",296498311),(0),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"limit","limit",-1355822363),null], 0));
var inst_25362 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6(db,fuel,max_fuel,inst_25338,inst_25360,inst_25361);
var state_25493__$1 = state_25493;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25493__$1,(42),inst_25362);
} else {
if((state_val_25494 === (88))){
var inst_25486 = (state_25493[(2)]);
var state_25493__$1 = state_25493;
var statearr_25521_25669 = state_25493__$1;
(statearr_25521_25669[(2)] = inst_25486);

(statearr_25521_25669[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (46))){
var inst_25320 = (state_25493[(12)]);
var inst_25374 = ((0) < inst_25320);
var state_25493__$1 = state_25493;
if(cljs.core.truth_(inst_25374)){
var statearr_25522_25670 = state_25493__$1;
(statearr_25522_25670[(1)] = (49));

} else {
var statearr_25523_25671 = state_25493__$1;
(statearr_25523_25671[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (4))){
var inst_25252 = (state_25493[(2)]);
var state_25493__$1 = state_25493;
var statearr_25524_25672 = state_25493__$1;
(statearr_25524_25672[(2)] = inst_25252);

(statearr_25524_25672[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (77))){
var inst_25319 = (state_25493[(11)]);
var inst_25430 = (inst_25319 - (1));
var state_25493__$1 = state_25493;
var statearr_25525_25673 = state_25493__$1;
(statearr_25525_25673[(2)] = inst_25430);

(statearr_25525_25673[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (95))){
var inst_25464 = (state_25493[(15)]);
var state_25493__$1 = state_25493;
var statearr_25526_25674 = state_25493__$1;
(statearr_25526_25674[(2)] = inst_25464);

(statearr_25526_25674[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (54))){
var inst_25384 = (state_25493[(2)]);
var state_25493__$1 = state_25493;
if(cljs.core.truth_(inst_25384)){
var statearr_25527_25675 = state_25493__$1;
(statearr_25527_25675[(1)] = (55));

} else {
var statearr_25528_25676 = state_25493__$1;
(statearr_25528_25676[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (92))){
var inst_25464 = (state_25493[(15)]);
var inst_25477 = cljs.core.first(inst_25464);
var state_25493__$1 = state_25493;
var statearr_25529_25677 = state_25493__$1;
(statearr_25529_25677[(2)] = inst_25477);

(statearr_25529_25677[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (15))){
var inst_25270 = (state_25493[(17)]);
var inst_25278 = (state_25493[(2)]);
var inst_25279 = fluree.db.util.async.throw_err(inst_25278);
var inst_25280 = [inst_25270];
var inst_25281 = [inst_25279];
var inst_25282 = cljs.core.PersistentHashMap.fromArrays(inst_25280,inst_25281);
var state_25493__$1 = state_25493;
var statearr_25530_25678 = state_25493__$1;
(statearr_25530_25678[(2)] = inst_25282);

(statearr_25530_25678[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (48))){
var inst_25442 = (state_25493[(2)]);
var state_25493__$1 = state_25493;
var statearr_25531_25679 = state_25493__$1;
(statearr_25531_25679[(2)] = inst_25442);

(statearr_25531_25679[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (50))){
var inst_25365 = (state_25493[(18)]);
var state_25493__$1 = state_25493;
var statearr_25532_25680 = state_25493__$1;
(statearr_25532_25680[(2)] = inst_25365);

(statearr_25532_25680[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (75))){
var inst_25396 = (state_25493[(13)]);
var inst_25331 = (state_25493[(19)]);
var inst_25413 = (state_25493[(20)]);
var inst_25334 = (state_25493[(21)]);
var inst_25424 = (state_25493[(2)]);
var inst_25317 = inst_25331;
var inst_25318 = inst_25334;
var inst_25319 = inst_25396;
var inst_25320 = inst_25413;
var inst_25321 = inst_25424;
var state_25493__$1 = (function (){var statearr_25533 = state_25493;
(statearr_25533[(12)] = inst_25320);

(statearr_25533[(22)] = inst_25318);

(statearr_25533[(11)] = inst_25319);

(statearr_25533[(23)] = inst_25317);

(statearr_25533[(10)] = inst_25321);

return statearr_25533;
})();
var statearr_25534_25681 = state_25493__$1;
(statearr_25534_25681[(2)] = null);

(statearr_25534_25681[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (21))){
var inst_25302 = (state_25493[(24)]);
var inst_25298 = (state_25493[(25)]);
var inst_25310 = (state_25493[(26)]);
var inst_25315 = (state_25493[(2)]);
var inst_25316 = cljs.core.PersistentHashMap.EMPTY;
var inst_25317 = inst_25298;
var inst_25318 = inst_25302;
var inst_25319 = inst_25310;
var inst_25320 = inst_25315;
var inst_25321 = inst_25316;
var state_25493__$1 = (function (){var statearr_25535 = state_25493;
(statearr_25535[(12)] = inst_25320);

(statearr_25535[(22)] = inst_25318);

(statearr_25535[(11)] = inst_25319);

(statearr_25535[(23)] = inst_25317);

(statearr_25535[(10)] = inst_25321);

return statearr_25535;
})();
var statearr_25536_25682 = state_25493__$1;
(statearr_25536_25682[(2)] = null);

(statearr_25536_25682[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (31))){
var inst_25320 = (state_25493[(12)]);
var inst_25335 = (state_25493[(27)]);
var inst_25349 = (inst_25320 >= inst_25335);
var state_25493__$1 = state_25493;
if(cljs.core.truth_(inst_25349)){
var statearr_25537_25683 = state_25493__$1;
(statearr_25537_25683[(1)] = (33));

} else {
var statearr_25538_25684 = state_25493__$1;
(statearr_25538_25684[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (32))){
var inst_25449 = (state_25493[(2)]);
var state_25493__$1 = state_25493;
var statearr_25539_25685 = state_25493__$1;
(statearr_25539_25685[(2)] = inst_25449);

(statearr_25539_25685[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (40))){
var state_25493__$1 = state_25493;
var statearr_25540_25686 = state_25493__$1;
(statearr_25540_25686[(2)] = null);

(statearr_25540_25686[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (91))){
var inst_25474 = (state_25493[(2)]);
var state_25493__$1 = state_25493;
var statearr_25541_25687 = state_25493__$1;
(statearr_25541_25687[(2)] = inst_25474);

(statearr_25541_25687[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (56))){
var inst_25379 = (state_25493[(14)]);
var state_25493__$1 = state_25493;
var statearr_25542_25688 = state_25493__$1;
(statearr_25542_25688[(2)] = inst_25379);

(statearr_25542_25688[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (33))){
var state_25493__$1 = state_25493;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25543_25689 = state_25493__$1;
(statearr_25543_25689[(1)] = (36));

} else {
var statearr_25544_25690 = state_25493__$1;
(statearr_25544_25690[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (13))){
var inst_25302 = (state_25493[(24)]);
var inst_25298 = (state_25493[(25)]);
var inst_25267 = (state_25493[(28)]);
var inst_25298__$1 = cljs.core.keys(inst_25267);
var inst_25299 = cljs.core.seq(inst_25298__$1);
var inst_25300 = cljs.core.first(inst_25299);
var inst_25301 = cljs.core.next(inst_25299);
var inst_25302__$1 = cljs.core.vals(inst_25267);
var inst_25303 = cljs.core.seq(inst_25302__$1);
var inst_25304 = cljs.core.first(inst_25303);
var inst_25305 = cljs.core.next(inst_25303);
var inst_25306 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),limit);
var state_25493__$1 = (function (){var statearr_25545 = state_25493;
(statearr_25545[(29)] = inst_25301);

(statearr_25545[(30)] = inst_25300);

(statearr_25545[(24)] = inst_25302__$1);

(statearr_25545[(25)] = inst_25298__$1);

(statearr_25545[(31)] = inst_25305);

(statearr_25545[(32)] = inst_25304);

return statearr_25545;
})();
if(inst_25306){
var statearr_25546_25691 = state_25493__$1;
(statearr_25546_25691[(1)] = (16));

} else {
var statearr_25547_25692 = state_25493__$1;
(statearr_25547_25692[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (22))){
var inst_25318 = (state_25493[(22)]);
var inst_25317 = (state_25493[(23)]);
var inst_25329 = cljs.core.seq(inst_25317);
var inst_25330 = cljs.core.first(inst_25329);
var inst_25331 = cljs.core.next(inst_25329);
var inst_25332 = cljs.core.seq(inst_25318);
var inst_25333 = cljs.core.first(inst_25332);
var inst_25334 = cljs.core.next(inst_25332);
var inst_25335 = cljs.core.count(inst_25333);
var inst_25336 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_25337 = [headers,vars,inst_25333];
var inst_25338 = cljs.core.PersistentHashMap.fromArrays(inst_25336,inst_25337);
var inst_25339 = (inst_25333 == null);
var state_25493__$1 = (function (){var statearr_25548 = state_25493;
(statearr_25548[(16)] = inst_25338);

(statearr_25548[(19)] = inst_25331);

(statearr_25548[(21)] = inst_25334);

(statearr_25548[(9)] = inst_25330);

(statearr_25548[(27)] = inst_25335);

return statearr_25548;
})();
if(cljs.core.truth_(inst_25339)){
var statearr_25549_25693 = state_25493__$1;
(statearr_25549_25693[(1)] = (24));

} else {
var statearr_25550_25694 = state_25493__$1;
(statearr_25550_25694[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (90))){
var inst_25464 = (state_25493[(15)]);
var state_25493__$1 = state_25493;
var statearr_25551_25695 = state_25493__$1;
(statearr_25551_25695[(2)] = inst_25464);

(statearr_25551_25695[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (36))){
var inst_25320 = (state_25493[(12)]);
var inst_25352 = (inst_25320 - (1));
var state_25493__$1 = state_25493;
var statearr_25552_25696 = state_25493__$1;
(statearr_25552_25696[(2)] = inst_25352);

(statearr_25552_25696[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (41))){
var inst_25445 = (state_25493[(2)]);
var state_25493__$1 = state_25493;
var statearr_25553_25697 = state_25493__$1;
(statearr_25553_25697[(2)] = inst_25445);

(statearr_25553_25697[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (89))){
var inst_25464 = (state_25493[(15)]);
var inst_25469 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25470 = [inst_25464];
var inst_25471 = (new cljs.core.PersistentVector(null,1,(5),inst_25469,inst_25470,null));
var state_25493__$1 = state_25493;
var statearr_25554_25698 = state_25493__$1;
(statearr_25554_25698[(2)] = inst_25471);

(statearr_25554_25698[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (43))){
var inst_25365 = (state_25493[(18)]);
var inst_25368 = cljs.core.seq(inst_25365);
var state_25493__$1 = state_25493;
var statearr_25555_25699 = state_25493__$1;
(statearr_25555_25699[(2)] = inst_25368);

(statearr_25555_25699[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (61))){
var state_25493__$1 = state_25493;
var statearr_25556_25700 = state_25493__$1;
(statearr_25556_25700[(2)] = (0));

(statearr_25556_25700[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (29))){
var inst_25346 = (state_25493[(2)]);
var state_25493__$1 = state_25493;
if(cljs.core.truth_(inst_25346)){
var statearr_25557_25701 = state_25493__$1;
(statearr_25557_25701[(1)] = (30));

} else {
var statearr_25558_25702 = state_25493__$1;
(statearr_25558_25702[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (44))){
var inst_25366 = (state_25493[(33)]);
var state_25493__$1 = state_25493;
var statearr_25559_25703 = state_25493__$1;
(statearr_25559_25703[(2)] = inst_25366);

(statearr_25559_25703[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (93))){
var state_25493__$1 = state_25493;
var statearr_25560_25704 = state_25493__$1;
(statearr_25560_25704[(1)] = (95));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (6))){
var inst_25259 = (state_25493[(34)]);
var inst_25259__$1 = fluree.db.query.fql.build_order_fn(orderBy,groupBy);
var inst_25261 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var state_25493__$1 = (function (){var statearr_25562 = state_25493;
(statearr_25562[(34)] = inst_25259__$1);

(statearr_25562[(35)] = inst_25261);

return statearr_25562;
})();
if(cljs.core.truth_(inst_25259__$1)){
var statearr_25563_25705 = state_25493__$1;
(statearr_25563_25705[(1)] = (9));

} else {
var statearr_25564_25706 = state_25493__$1;
(statearr_25564_25706[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (28))){
var inst_25319 = (state_25493[(11)]);
var state_25493__$1 = state_25493;
var statearr_25565_25707 = state_25493__$1;
(statearr_25565_25707[(2)] = inst_25319);

(statearr_25565_25707[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (64))){
var inst_25320 = (state_25493[(12)]);
var inst_25401 = (inst_25320 - (1));
var state_25493__$1 = state_25493;
var statearr_25566_25708 = state_25493__$1;
(statearr_25566_25708[(2)] = inst_25401);

(statearr_25566_25708[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (51))){
var inst_25319 = (state_25493[(11)]);
var inst_25379 = (state_25493[(2)]);
var state_25493__$1 = (function (){var statearr_25567 = state_25493;
(statearr_25567[(14)] = inst_25379);

return statearr_25567;
})();
if(cljs.core.truth_(inst_25319)){
var statearr_25568_25709 = state_25493__$1;
(statearr_25568_25709[(1)] = (52));

} else {
var statearr_25569_25710 = state_25493__$1;
(statearr_25569_25710[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (25))){
var inst_25319 = (state_25493[(11)]);
var state_25493__$1 = state_25493;
if(cljs.core.truth_(inst_25319)){
var statearr_25570_25711 = state_25493__$1;
(statearr_25570_25711[(1)] = (27));

} else {
var statearr_25571_25712 = state_25493__$1;
(statearr_25571_25712[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (34))){
var state_25493__$1 = state_25493;
var statearr_25572_25713 = state_25493__$1;
(statearr_25572_25713[(1)] = (39));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (17))){
var state_25493__$1 = state_25493;
var statearr_25574_25714 = state_25493__$1;
(statearr_25574_25714[(2)] = limit);

(statearr_25574_25714[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (3))){
var inst_25491 = (state_25493[(2)]);
var state_25493__$1 = state_25493;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25493__$1,inst_25491);
} else {
if((state_val_25494 === (12))){
var inst_25267 = (state_25493[(28)]);
var inst_25269 = cljs.core.keys(inst_25267);
var inst_25270 = cljs.core.first(inst_25269);
var inst_25271 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_25272 = cljs.core.vals(inst_25267);
var inst_25273 = cljs.core.first(inst_25272);
var inst_25274 = [headers,vars,inst_25273];
var inst_25275 = cljs.core.PersistentHashMap.fromArrays(inst_25271,inst_25274);
var inst_25276 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,inst_25275,select_spec,limit,opts);
var state_25493__$1 = (function (){var statearr_25575 = state_25493;
(statearr_25575[(17)] = inst_25270);

return statearr_25575;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25493__$1,(15),inst_25276);
} else {
if((state_val_25494 === (2))){
var _ = (function (){var statearr_25576 = state_25493;
(statearr_25576[(4)] = cljs.core.cons((5),(state_25493[(4)])));

return statearr_25576;
})();
var state_25493__$1 = state_25493;
if(cljs.core.truth_(groupBy)){
var statearr_25577_25715 = state_25493__$1;
(statearr_25577_25715[(1)] = (6));

} else {
var statearr_25578_25716 = state_25493__$1;
(statearr_25578_25716[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (66))){
var inst_25411 = (state_25493[(2)]);
var state_25493__$1 = state_25493;
var statearr_25579_25717 = state_25493__$1;
(statearr_25579_25717[(2)] = inst_25411);

(statearr_25579_25717[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (23))){
var inst_25453 = (state_25493[(2)]);
var state_25493__$1 = state_25493;
var statearr_25580_25718 = state_25493__$1;
(statearr_25580_25718[(2)] = inst_25453);

(statearr_25580_25718[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (47))){
var inst_25319 = (state_25493[(11)]);
var inst_25427 = (inst_25319 == null);
var state_25493__$1 = state_25493;
if(cljs.core.truth_(inst_25427)){
var statearr_25581_25719 = state_25493__$1;
(statearr_25581_25719[(1)] = (76));

} else {
var statearr_25582_25720 = state_25493__$1;
(statearr_25582_25720[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (35))){
var inst_25447 = (state_25493[(2)]);
var state_25493__$1 = state_25493;
var statearr_25583_25721 = state_25493__$1;
(statearr_25583_25721[(2)] = inst_25447);

(statearr_25583_25721[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (82))){
var state_25493__$1 = state_25493;
var statearr_25584_25722 = state_25493__$1;
(statearr_25584_25722[(2)] = (1));

(statearr_25584_25722[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (76))){
var state_25493__$1 = state_25493;
var statearr_25585_25723 = state_25493__$1;
(statearr_25585_25723[(2)] = null);

(statearr_25585_25723[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (97))){
var inst_25482 = (state_25493[(2)]);
var state_25493__$1 = state_25493;
var statearr_25586_25724 = state_25493__$1;
(statearr_25586_25724[(2)] = inst_25482);

(statearr_25586_25724[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (19))){
var inst_25311 = (state_25493[(36)]);
var state_25493__$1 = state_25493;
var statearr_25587_25725 = state_25493__$1;
(statearr_25587_25725[(2)] = inst_25311);

(statearr_25587_25725[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (57))){
var inst_25319 = (state_25493[(11)]);
var inst_25389 = (state_25493[(2)]);
var inst_25390 = (inst_25319 == null);
var state_25493__$1 = (function (){var statearr_25588 = state_25493;
(statearr_25588[(8)] = inst_25389);

return statearr_25588;
})();
if(cljs.core.truth_(inst_25390)){
var statearr_25589_25726 = state_25493__$1;
(statearr_25589_25726[(1)] = (58));

} else {
var statearr_25590_25727 = state_25493__$1;
(statearr_25590_25727[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (68))){
var state_25493__$1 = state_25493;
var statearr_25591_25728 = state_25493__$1;
(statearr_25591_25728[(2)] = null);

(statearr_25591_25728[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (11))){
var inst_25267 = (state_25493[(2)]);
var state_25493__$1 = (function (){var statearr_25593 = state_25493;
(statearr_25593[(28)] = inst_25267);

return statearr_25593;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25594_25729 = state_25493__$1;
(statearr_25594_25729[(1)] = (12));

} else {
var statearr_25595_25730 = state_25493__$1;
(statearr_25595_25730[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (9))){
var inst_25259 = (state_25493[(34)]);
var inst_25261 = (state_25493[(35)]);
var inst_25263 = cljs.core.sorted_map_by(inst_25259);
var inst_25264 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25263,inst_25261);
var state_25493__$1 = state_25493;
var statearr_25596_25731 = state_25493__$1;
(statearr_25596_25731[(2)] = inst_25264);

(statearr_25596_25731[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (5))){
var _ = (function (){var statearr_25597 = state_25493;
(statearr_25597[(4)] = cljs.core.rest((state_25493[(4)])));

return statearr_25597;
})();
var state_25493__$1 = state_25493;
var ex25592 = (state_25493__$1[(2)]);
var statearr_25598_25732 = state_25493__$1;
(statearr_25598_25732[(5)] = ex25592);


if((ex25592 instanceof Error)){
var statearr_25599_25733 = state_25493__$1;
(statearr_25599_25733[(1)] = (4));

(statearr_25599_25733[(5)] = null);

} else {
throw ex25592;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (83))){
var state_25493__$1 = state_25493;
var statearr_25600_25734 = state_25493__$1;
(statearr_25600_25734[(2)] = limit);

(statearr_25600_25734[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (14))){
var inst_25455 = (state_25493[(2)]);
var state_25493__$1 = state_25493;
var statearr_25601_25735 = state_25493__$1;
(statearr_25601_25735[(2)] = inst_25455);

(statearr_25601_25735[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (45))){
var inst_25371 = (state_25493[(2)]);
var state_25493__$1 = state_25493;
if(cljs.core.truth_(inst_25371)){
var statearr_25602_25736 = state_25493__$1;
(statearr_25602_25736[(1)] = (46));

} else {
var statearr_25603_25737 = state_25493__$1;
(statearr_25603_25737[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (53))){
var inst_25319 = (state_25493[(11)]);
var state_25493__$1 = state_25493;
var statearr_25604_25738 = state_25493__$1;
(statearr_25604_25738[(2)] = inst_25319);

(statearr_25604_25738[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (78))){
var inst_25320 = (state_25493[(12)]);
var inst_25432 = (state_25493[(2)]);
var inst_25433 = (inst_25320 <= (0));
var state_25493__$1 = (function (){var statearr_25605 = state_25493;
(statearr_25605[(37)] = inst_25432);

return statearr_25605;
})();
if(cljs.core.truth_(inst_25433)){
var statearr_25606_25739 = state_25493__$1;
(statearr_25606_25739[(1)] = (79));

} else {
var statearr_25607_25740 = state_25493__$1;
(statearr_25607_25740[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (26))){
var inst_25451 = (state_25493[(2)]);
var state_25493__$1 = state_25493;
var statearr_25608_25741 = state_25493__$1;
(statearr_25608_25741[(2)] = inst_25451);

(statearr_25608_25741[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (16))){
var state_25493__$1 = state_25493;
var statearr_25609_25742 = state_25493__$1;
(statearr_25609_25742[(2)] = null);

(statearr_25609_25742[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (81))){
var inst_25432 = (state_25493[(37)]);
var inst_25331 = (state_25493[(19)]);
var inst_25334 = (state_25493[(21)]);
var inst_25365 = (state_25493[(18)]);
var inst_25330 = (state_25493[(9)]);
var inst_25321 = (state_25493[(10)]);
var inst_25438 = (state_25493[(2)]);
var inst_25439 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25321,inst_25330,inst_25365);
var inst_25317 = inst_25331;
var inst_25318 = inst_25334;
var inst_25319 = inst_25432;
var inst_25320 = inst_25438;
var inst_25321__$1 = inst_25439;
var state_25493__$1 = (function (){var statearr_25612 = state_25493;
(statearr_25612[(12)] = inst_25320);

(statearr_25612[(22)] = inst_25318);

(statearr_25612[(11)] = inst_25319);

(statearr_25612[(23)] = inst_25317);

(statearr_25612[(10)] = inst_25321__$1);

return statearr_25612;
})();
var statearr_25613_25743 = state_25493__$1;
(statearr_25613_25743[(2)] = null);

(statearr_25613_25743[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (79))){
var state_25493__$1 = state_25493;
var statearr_25614_25744 = state_25493__$1;
(statearr_25614_25744[(2)] = (0));

(statearr_25614_25744[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (38))){
var inst_25319 = (state_25493[(11)]);
var inst_25331 = (state_25493[(19)]);
var inst_25334 = (state_25493[(21)]);
var inst_25321 = (state_25493[(10)]);
var inst_25356 = (state_25493[(2)]);
var tmp25610 = inst_25319;
var tmp25611 = inst_25321;
var inst_25317 = inst_25331;
var inst_25318 = inst_25334;
var inst_25319__$1 = tmp25610;
var inst_25320 = inst_25356;
var inst_25321__$1 = tmp25611;
var state_25493__$1 = (function (){var statearr_25615 = state_25493;
(statearr_25615[(12)] = inst_25320);

(statearr_25615[(22)] = inst_25318);

(statearr_25615[(11)] = inst_25319__$1);

(statearr_25615[(23)] = inst_25317);

(statearr_25615[(10)] = inst_25321__$1);

return statearr_25615;
})();
var statearr_25616_25745 = state_25493__$1;
(statearr_25616_25745[(2)] = null);

(statearr_25616_25745[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (87))){
var state_25493__$1 = state_25493;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25617_25746 = state_25493__$1;
(statearr_25617_25746[(1)] = (92));

} else {
var statearr_25618_25747 = state_25493__$1;
(statearr_25618_25747[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (30))){
var inst_25321 = (state_25493[(10)]);
var state_25493__$1 = state_25493;
var statearr_25619_25748 = state_25493__$1;
(statearr_25619_25748[(2)] = inst_25321);

(statearr_25619_25748[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (73))){
var inst_25321 = (state_25493[(10)]);
var state_25493__$1 = state_25493;
var statearr_25620_25749 = state_25493__$1;
(statearr_25620_25749[(2)] = inst_25321);

(statearr_25620_25749[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (96))){
var state_25493__$1 = state_25493;
var statearr_25621_25750 = state_25493__$1;
(statearr_25621_25750[(2)] = null);

(statearr_25621_25750[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (10))){
var inst_25261 = (state_25493[(35)]);
var state_25493__$1 = state_25493;
var statearr_25622_25751 = state_25493__$1;
(statearr_25622_25751[(2)] = inst_25261);

(statearr_25622_25751[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (18))){
var inst_25311 = (state_25493[(36)]);
var inst_25310 = (state_25493[(2)]);
var inst_25311__$1 = offset;
var state_25493__$1 = (function (){var statearr_25623 = state_25493;
(statearr_25623[(26)] = inst_25310);

(statearr_25623[(36)] = inst_25311__$1);

return statearr_25623;
})();
if(cljs.core.truth_(inst_25311__$1)){
var statearr_25624_25752 = state_25493__$1;
(statearr_25624_25752[(1)] = (19));

} else {
var statearr_25625_25753 = state_25493__$1;
(statearr_25625_25753[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (52))){
var inst_25319 = (state_25493[(11)]);
var inst_25381 = ((0) < inst_25319);
var state_25493__$1 = state_25493;
var statearr_25626_25754 = state_25493__$1;
(statearr_25626_25754[(2)] = inst_25381);

(statearr_25626_25754[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (67))){
var inst_25320 = (state_25493[(12)]);
var inst_25389 = (state_25493[(8)]);
var inst_25335 = (state_25493[(27)]);
var inst_25404 = cljs.core.count(inst_25389);
var inst_25405 = (inst_25335 - inst_25404);
var inst_25406 = (inst_25320 - inst_25405);
var state_25493__$1 = state_25493;
var statearr_25627_25755 = state_25493__$1;
(statearr_25627_25755[(2)] = inst_25406);

(statearr_25627_25755[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (71))){
var inst_25389 = (state_25493[(8)]);
var inst_25417 = cljs.core.empty_QMARK_(inst_25389);
var state_25493__$1 = state_25493;
var statearr_25628_25756 = state_25493__$1;
(statearr_25628_25756[(2)] = inst_25417);

(statearr_25628_25756[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (42))){
var inst_25366 = (state_25493[(33)]);
var inst_25365 = (state_25493[(18)]);
var inst_25364 = (state_25493[(2)]);
var inst_25365__$1 = fluree.db.util.async.throw_err(inst_25364);
var inst_25366__$1 = cljs.core.coll_QMARK_(inst_25365__$1);
var state_25493__$1 = (function (){var statearr_25629 = state_25493;
(statearr_25629[(33)] = inst_25366__$1);

(statearr_25629[(18)] = inst_25365__$1);

return statearr_25629;
})();
if(inst_25366__$1){
var statearr_25630_25757 = state_25493__$1;
(statearr_25630_25757[(1)] = (43));

} else {
var statearr_25631_25758 = state_25493__$1;
(statearr_25631_25758[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (80))){
var inst_25320 = (state_25493[(12)]);
var inst_25436 = (inst_25320 - (1));
var state_25493__$1 = state_25493;
var statearr_25632_25759 = state_25493__$1;
(statearr_25632_25759[(2)] = inst_25436);

(statearr_25632_25759[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (37))){
var inst_25320 = (state_25493[(12)]);
var inst_25335 = (state_25493[(27)]);
var inst_25354 = (inst_25320 - inst_25335);
var state_25493__$1 = state_25493;
var statearr_25633_25760 = state_25493__$1;
(statearr_25633_25760[(2)] = inst_25354);

(statearr_25633_25760[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (63))){
var inst_25414 = (state_25493[(7)]);
var inst_25389 = (state_25493[(8)]);
var inst_25413 = (state_25493[(2)]);
var inst_25414__$1 = (inst_25389 == null);
var state_25493__$1 = (function (){var statearr_25634 = state_25493;
(statearr_25634[(20)] = inst_25413);

(statearr_25634[(7)] = inst_25414__$1);

return statearr_25634;
})();
if(cljs.core.truth_(inst_25414__$1)){
var statearr_25635_25761 = state_25493__$1;
(statearr_25635_25761[(1)] = (70));

} else {
var statearr_25636_25762 = state_25493__$1;
(statearr_25636_25762[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (94))){
var inst_25484 = (state_25493[(2)]);
var state_25493__$1 = state_25493;
var statearr_25637_25763 = state_25493__$1;
(statearr_25637_25763[(2)] = inst_25484);

(statearr_25637_25763[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (8))){
var inst_25488 = (state_25493[(2)]);
var _ = (function (){var statearr_25638 = state_25493;
(statearr_25638[(4)] = cljs.core.rest((state_25493[(4)])));

return statearr_25638;
})();
var state_25493__$1 = state_25493;
var statearr_25639_25764 = state_25493__$1;
(statearr_25639_25764[(2)] = inst_25488);

(statearr_25639_25764[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (49))){
var inst_25320 = (state_25493[(12)]);
var inst_25365 = (state_25493[(18)]);
var inst_25376 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_25320,inst_25365);
var state_25493__$1 = state_25493;
var statearr_25640_25765 = state_25493__$1;
(statearr_25640_25765[(2)] = inst_25376);

(statearr_25640_25765[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25494 === (84))){
var inst_25460 = (state_25493[(2)]);
var inst_25461 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,inst_25460,opts);
var state_25493__$1 = state_25493;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25493__$1,(85),inst_25461);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2717__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2717__auto____0 = (function (){
var statearr_25641 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25641[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2717__auto__);

(statearr_25641[(1)] = (1));

return statearr_25641;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2717__auto____1 = (function (state_25493){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_25493);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e25642){var ex__2720__auto__ = e25642;
var statearr_25643_25766 = state_25493;
(statearr_25643_25766[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_25493[(4)]))){
var statearr_25644_25767 = state_25493;
(statearr_25644_25767[(1)] = cljs.core.first((state_25493[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25768 = state_25493;
state_25493 = G__25768;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2717__auto__ = function(state_25493){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2717__auto____1.call(this,state_25493);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2717__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2717__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_25645 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_25645[(6)] = c__2739__auto__);

return statearr_25645;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__25771,opts){
var map__25772 = p__25771;
var map__25772__$1 = cljs.core.__destructure_map(map__25772);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25772__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25772__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25772__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var selectReduced = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25772__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var select_smt = (function (){var or__4212__auto__ = selectOne;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = select;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
var or__4212__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4212__auto____$2)){
return or__4212__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_(select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select(headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__25769_SHARP_){
return cljs.core.contains_QMARK_(p1__25769_SHARP_,new cljs.core.Keyword(null,"code","code",1586293142));
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some((function (p1__25770_SHARP_){
return cljs.core.contains_QMARK_(p1__25770_SHARP_,new cljs.core.Keyword(null,"selection","selection",975998651));
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_(aggregates))?null:aggregates);
var orderBy = (function (){var temp__5753__auto__ = new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5753__auto__)){
var orderBy = temp__5753__auto__;
if(cljs.core.truth_((function (){var or__4212__auto__ = typeof orderBy === 'string';
if(or__4212__auto__){
return or__4212__auto__;
} else {
var and__4210__auto__ = cljs.core.vector_QMARK_(orderBy);
if(and__4210__auto__){
var G__25774 = cljs.core.first(orderBy);
var fexpr__25773 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null);
return (fexpr__25773.cljs$core$IFn$_invoke$arity$1 ? fexpr__25773.cljs$core$IFn$_invoke$arity$1(G__25774) : fexpr__25773.call(null,G__25774));
} else {
return and__4210__auto__;
}
}
})())){
if(cljs.core.vector_QMARK_(orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289),new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"inVector?","inVector?",1948069375)],[expandMap_QMARK_,(function (){var or__4212__auto__ = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (100);
}
})(),(function (){var or__4212__auto__ = new cljs.core.Keyword(null,"offset","offset",296498311).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$(selectOne),(function (){var or__4212__auto__ = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return false;
}
})(),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667).cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$((function (){var or__4212__auto__ = selectDistinct;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__25775,p__25776){
var map__25777 = p__25775;
var map__25777__$1 = cljs.core.__destructure_map(map__25777);
var query_map = map__25777__$1;
var construct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25777__$1,new cljs.core.Keyword(null,"construct","construct",692547932));
var map__25778 = p__25776;
var map__25778__$1 = cljs.core.__destructure_map(map__25778);
var where_result = map__25778__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25778__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25778__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__25779 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (construct_item){
var temp__5751__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(construct_item));
if(cljs.core.truth_(temp__5751__auto__)){
var index_of = temp__5751__auto__;
return (function (row){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25779,(0),null);
var fn2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25779,(1),null);
var fn3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25779,(2),null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(res) : fn1.call(null,res)),(fn2.cljs$core$IFn$_invoke$arity$1 ? fn2.cljs$core$IFn$_invoke$arity$1(res) : fn2.call(null,res)),(fn3.cljs$core$IFn$_invoke$arity$1 ? fn3.cljs$core$IFn$_invoke$arity$1(res) : fn3.call(null,res))], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_25812){
var state_val_25813 = (state_25812[(1)]);
if((state_val_25813 === (7))){
var inst_25791 = (state_25812[(7)]);
var state_25812__$1 = state_25812;
var statearr_25814_25837 = state_25812__$1;
(statearr_25814_25837[(2)] = inst_25791);

(statearr_25814_25837[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (1))){
var state_25812__$1 = state_25812;
var statearr_25815_25838 = state_25812__$1;
(statearr_25815_25838[(2)] = null);

(statearr_25815_25838[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (4))){
var inst_25782 = (state_25812[(2)]);
var state_25812__$1 = state_25812;
var statearr_25816_25839 = state_25812__$1;
(statearr_25816_25839[(2)] = inst_25782);

(statearr_25816_25839[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (13))){
var inst_25801 = (state_25812[(2)]);
var inst_25802 = fluree.db.util.async.throw_err(inst_25801);
var state_25812__$1 = state_25812;
var statearr_25817_25840 = state_25812__$1;
(statearr_25817_25840[(2)] = inst_25802);

(statearr_25817_25840[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (6))){
var inst_25791 = (state_25812[(7)]);
var inst_25790 = (state_25812[(2)]);
var inst_25791__$1 = fluree.db.util.async.throw_err(inst_25790);
var inst_25792 = fluree.db.util.core.exception_QMARK_(inst_25791__$1);
var state_25812__$1 = (function (){var statearr_25818 = state_25812;
(statearr_25818[(7)] = inst_25791__$1);

return statearr_25818;
})();
if(inst_25792){
var statearr_25819_25841 = state_25812__$1;
(statearr_25819_25841[(1)] = (7));

} else {
var statearr_25820_25842 = state_25812__$1;
(statearr_25820_25842[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (3))){
var inst_25810 = (state_25812[(2)]);
var state_25812__$1 = state_25812;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25812__$1,inst_25810);
} else {
if((state_val_25813 === (12))){
var inst_25805 = (state_25812[(2)]);
var state_25812__$1 = state_25812;
var statearr_25821_25843 = state_25812__$1;
(statearr_25821_25843[(2)] = inst_25805);

(statearr_25821_25843[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (2))){
var _ = (function (){var statearr_25822 = state_25812;
(statearr_25822[(4)] = cljs.core.cons((5),(state_25812[(4)])));

return statearr_25822;
})();
var inst_25788 = fluree.db.query.analytical.q(query_map,fuel,max_fuel,db,opts);
var state_25812__$1 = state_25812;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25812__$1,(6),inst_25788);
} else {
if((state_val_25813 === (11))){
var state_25812__$1 = state_25812;
var statearr_25824_25844 = state_25812__$1;
(statearr_25824_25844[(2)] = null);

(statearr_25824_25844[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (9))){
var inst_25807 = (state_25812[(2)]);
var _ = (function (){var statearr_25825 = state_25812;
(statearr_25825[(4)] = cljs.core.rest((state_25812[(4)])));

return statearr_25825;
})();
var state_25812__$1 = state_25812;
var statearr_25826_25845 = state_25812__$1;
(statearr_25826_25845[(2)] = inst_25807);

(statearr_25826_25845[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (5))){
var _ = (function (){var statearr_25827 = state_25812;
(statearr_25827[(4)] = cljs.core.rest((state_25812[(4)])));

return statearr_25827;
})();
var state_25812__$1 = state_25812;
var ex25823 = (state_25812__$1[(2)]);
var statearr_25828_25846 = state_25812__$1;
(statearr_25828_25846[(5)] = ex25823);


if((ex25823 instanceof Error)){
var statearr_25829_25847 = state_25812__$1;
(statearr_25829_25847[(1)] = (4));

(statearr_25829_25847[(5)] = null);

} else {
throw ex25823;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25813 === (10))){
var inst_25791 = (state_25812[(7)]);
var inst_25796 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_25791);
var inst_25797 = new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(inst_25791);
var inst_25798 = fluree.db.query.fql.get_ad_hoc_select_spec(inst_25796,inst_25797,query_map,opts);
var inst_25799 = fluree.db.query.fql.process_ad_hoc_res(db,fuel,max_fuel,inst_25791,inst_25798,opts);
var state_25812__$1 = state_25812;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25812__$1,(13),inst_25799);
} else {
if((state_val_25813 === (8))){
var state_25812__$1 = state_25812;
var statearr_25830_25848 = state_25812__$1;
(statearr_25830_25848[(1)] = (10));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2717__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2717__auto____0 = (function (){
var statearr_25832 = [null,null,null,null,null,null,null,null];
(statearr_25832[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__2717__auto__);

(statearr_25832[(1)] = (1));

return statearr_25832;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2717__auto____1 = (function (state_25812){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_25812);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e25833){var ex__2720__auto__ = e25833;
var statearr_25834_25849 = state_25812;
(statearr_25834_25849[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_25812[(4)]))){
var statearr_25835_25850 = state_25812;
(statearr_25835_25850[(1)] = cljs.core.first((state_25812[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25851 = state_25812;
state_25812 = G__25851;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__2717__auto__ = function(state_25812){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2717__auto____1.call(this,state_25812);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2717__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2717__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_25836 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_25836[(6)] = c__2739__auto__);

return statearr_25836;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Running query:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0))], 0));

var map__25852 = query_map;
var map__25852__$1 = cljs.core.__destructure_map(map__25852);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25852__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25852__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25852__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25852__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25852__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25852__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25852__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25852__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25852__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25852__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25852__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25852__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var opts_SINGLEQUOTE_ = (function (){var G__25853 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"limit","limit",-1355822363),limit,new cljs.core.Keyword(null,"offset","offset",296498311),(function (){var or__4212__auto__ = offset;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})(),new cljs.core.Keyword(null,"component","component",1555936782),component,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),orderBy,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),groupBy,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),prettyPrint], null),opts], 0));
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__25853,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
} else {
return G__25853;
}
})();
var max_fuel = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__4212__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
if(cljs.core.truth_((function (){var or__4212__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_((0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_(where)){
return fluree.db.query.fql.ad_hoc_query(db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_26211){
var state_val_26212 = (state_26211[(1)]);
if((state_val_26212 === (121))){
var inst_26172 = (state_26211[(2)]);
var state_26211__$1 = state_26211;
var statearr_26213_26408 = state_26211__$1;
(statearr_26213_26408[(2)] = inst_26172);

(statearr_26213_26408[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (65))){
var inst_26049 = typeof from === 'string';
var state_26211__$1 = state_26211;
if(cljs.core.truth_(inst_26049)){
var statearr_26214_26409 = state_26211__$1;
(statearr_26214_26409[(1)] = (72));

} else {
var statearr_26215_26410 = state_26211__$1;
(statearr_26215_26410[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (70))){
var inst_25917 = (state_26211[(7)]);
var inst_25915 = (state_26211[(8)]);
var inst_26042 = (state_26211[(2)]);
var inst_26043 = fluree.db.util.async.throw_err(inst_26042);
var inst_26044 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_25917,fuel,max_fuel,inst_25915,inst_26043);
var state_26211__$1 = state_26211;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26211__$1,(71),inst_26044);
} else {
if((state_val_26212 === (62))){
var inst_26022 = (state_26211[(9)]);
var state_26211__$1 = state_26211;
var statearr_26216_26411 = state_26211__$1;
(statearr_26216_26411[(2)] = inst_26022);

(statearr_26216_26411[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (74))){
var inst_26178 = (state_26211[(2)]);
var state_26211__$1 = state_26211;
var statearr_26217_26412 = state_26211__$1;
(statearr_26217_26412[(2)] = inst_26178);

(statearr_26217_26412[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (110))){
var inst_26113 = (state_26211[(10)]);
var state_26211__$1 = state_26211;
var statearr_26218_26413 = state_26211__$1;
(statearr_26218_26413[(2)] = inst_26113);

(statearr_26218_26413[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (130))){
var inst_26198 = (state_26211[(2)]);
var state_26211__$1 = state_26211;
var statearr_26219_26414 = state_26211__$1;
(statearr_26219_26414[(2)] = inst_26198);

(statearr_26219_26414[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (128))){
var inst_26189 = (state_26211[(11)]);
var inst_26194 = fluree.db.util.core.exception_QMARK_(inst_26189);
var inst_26195 = (!(inst_26194));
var state_26211__$1 = state_26211;
var statearr_26220_26415 = state_26211__$1;
(statearr_26220_26415[(2)] = inst_26195);

(statearr_26220_26415[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (7))){
var inst_25885 = (state_26211[(12)]);
var inst_25885__$1 = selectOne;
var state_26211__$1 = (function (){var statearr_26221 = state_26211;
(statearr_26221[(12)] = inst_25885__$1);

return statearr_26221;
})();
if(cljs.core.truth_(inst_25885__$1)){
var statearr_26222_26416 = state_26211__$1;
(statearr_26222_26416[(1)] = (9));

} else {
var statearr_26223_26417 = state_26211__$1;
(statearr_26223_26417[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (59))){
var inst_25917 = (state_26211[(7)]);
var inst_26000 = (state_26211[(13)]);
var inst_25905 = (state_26211[(14)]);
var inst_25915 = (state_26211[(8)]);
var inst_26014 = (state_26211[(2)]);
var inst_26015 = fluree.db.util.async.throw_err(inst_26014);
var inst_26016 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_26000,inst_26015);
var inst_26017 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7(db,inst_25917,fuel,max_fuel,inst_25915,inst_26016,inst_25905);
var state_26211__$1 = state_26211;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26211__$1,(60),inst_26017);
} else {
if((state_val_26212 === (86))){
var inst_25917 = (state_26211[(7)]);
var inst_25907 = (state_26211[(15)]);
var inst_25905 = (state_26211[(14)]);
var inst_25915 = (state_26211[(8)]);
var inst_26082 = (state_26211[(2)]);
var inst_26083 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_25917,fuel,max_fuel,inst_25915,inst_26082,inst_25905,inst_25907);
var state_26211__$1 = state_26211;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26211__$1,(87),inst_26083);
} else {
if((state_val_26212 === (20))){
var inst_25949 = (state_26211[(2)]);
var inst_25950 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25949,(0),null);
var inst_25951 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25949,(1),null);
var inst_25952 = typeof where === 'string';
var state_26211__$1 = (function (){var statearr_26224 = state_26211;
(statearr_26224[(16)] = inst_25951);

(statearr_26224[(17)] = inst_25950);

return statearr_26224;
})();
if(cljs.core.truth_(inst_25952)){
var statearr_26225_26418 = state_26211__$1;
(statearr_26225_26418[(1)] = (30));

} else {
var statearr_26226_26419 = state_26211__$1;
(statearr_26226_26419[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (72))){
var inst_25904 = (state_26211[(18)]);
var state_26211__$1 = state_26211;
if(cljs.core.truth_(inst_25904)){
var statearr_26227_26420 = state_26211__$1;
(statearr_26227_26420[(1)] = (75));

} else {
var statearr_26228_26421 = state_26211__$1;
(statearr_26228_26421[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (58))){
var inst_26008 = (state_26211[(2)]);
var inst_26009 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26010 = [from];
var inst_26011 = (new cljs.core.PersistentVector(null,1,(5),inst_26009,inst_26010,null));
var inst_26012 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_26011,inst_26008);
var state_26211__$1 = state_26211;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26211__$1,(59),inst_26012);
} else {
if((state_val_26212 === (60))){
var inst_26019 = (state_26211[(2)]);
var inst_26020 = fluree.db.util.async.throw_err(inst_26019);
var state_26211__$1 = state_26211;
var statearr_26229_26422 = state_26211__$1;
(statearr_26229_26422[(2)] = inst_26020);

(statearr_26229_26422[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (27))){
var inst_25934 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25935 = [null,null];
var inst_25936 = (new cljs.core.PersistentVector(null,2,(5),inst_25934,inst_25935,null));
var state_26211__$1 = state_26211;
var statearr_26230_26423 = state_26211__$1;
(statearr_26230_26423[(2)] = inst_25936);

(statearr_26230_26423[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (1))){
var state_26211__$1 = state_26211;
var statearr_26231_26424 = state_26211__$1;
(statearr_26231_26424[(2)] = null);

(statearr_26231_26424[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (69))){
var inst_26039 = (state_26211[(2)]);
var inst_26040 = fluree.db.query.range._block_or_tx_collection(db,inst_26039);
var state_26211__$1 = state_26211;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26211__$1,(70),inst_26040);
} else {
if((state_val_26212 === (101))){
var inst_26145 = (state_26211[(2)]);
var state_26211__$1 = state_26211;
var statearr_26232_26425 = state_26211__$1;
(statearr_26232_26425[(2)] = inst_26145);

(statearr_26232_26425[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (24))){
var inst_25904 = (state_26211[(18)]);
var inst_25929 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25930 = [inst_25904,"ASC"];
var inst_25931 = (new cljs.core.PersistentVector(null,2,(5),inst_25929,inst_25930,null));
var state_26211__$1 = state_26211;
var statearr_26233_26426 = state_26211__$1;
(statearr_26233_26426[(2)] = inst_25931);

(statearr_26233_26426[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (102))){
var inst_26119 = (state_26211[(19)]);
var state_26211__$1 = state_26211;
var statearr_26234_26427 = state_26211__$1;
(statearr_26234_26427[(2)] = inst_26119);

(statearr_26234_26427[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (55))){
var inst_25904 = (state_26211[(18)]);
var inst_26000 = (state_26211[(2)]);
var state_26211__$1 = (function (){var statearr_26235 = state_26211;
(statearr_26235[(13)] = inst_26000);

return statearr_26235;
})();
if(cljs.core.truth_(inst_25904)){
var statearr_26236_26428 = state_26211__$1;
(statearr_26236_26428[(1)] = (56));

} else {
var statearr_26237_26429 = state_26211__$1;
(statearr_26237_26429[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (85))){
var inst_26074 = (state_26211[(20)]);
var inst_26078 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26079 = [inst_26074];
var inst_26080 = (new cljs.core.PersistentVector(null,1,(5),inst_26078,inst_26079,null));
var state_26211__$1 = state_26211;
var statearr_26238_26430 = state_26211__$1;
(statearr_26238_26430[(2)] = inst_26080);

(statearr_26238_26430[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (39))){
var inst_25905 = (state_26211[(14)]);
var state_26211__$1 = state_26211;
var statearr_26239_26431 = state_26211__$1;
(statearr_26239_26431[(2)] = inst_25905);

(statearr_26239_26431[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (88))){
var inst_26088 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2(fuel,cljs.core.inc);
var state_26211__$1 = state_26211;
var statearr_26240_26432 = state_26211__$1;
(statearr_26240_26432[(2)] = inst_26088);

(statearr_26240_26432[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (46))){
var inst_25985 = (state_26211[(2)]);
var state_26211__$1 = state_26211;
if(cljs.core.truth_(inst_25985)){
var statearr_26241_26433 = state_26211__$1;
(statearr_26241_26433[(1)] = (47));

} else {
var statearr_26242_26434 = state_26211__$1;
(statearr_26242_26434[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (4))){
var inst_25872 = (state_26211[(2)]);
var state_26211__$1 = state_26211;
var statearr_26243_26435 = state_26211__$1;
(statearr_26243_26435[(2)] = inst_25872);

(statearr_26243_26435[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (77))){
var inst_26058 = (state_26211[(2)]);
var inst_26059 = fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,from,inst_26058);
var state_26211__$1 = state_26211;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26211__$1,(78),inst_26059);
} else {
if((state_val_26212 === (106))){
var state_26211__$1 = state_26211;
var statearr_26244_26436 = state_26211__$1;
(statearr_26244_26436[(2)] = null);

(statearr_26244_26436[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (119))){
var inst_26164 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_26165 = ["Invalid 'from' in query:",inst_26164].join('');
var inst_26166 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26167 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_26168 = cljs.core.PersistentHashMap.fromArrays(inst_26166,inst_26167);
var inst_26169 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26165,inst_26168);
var state_26211__$1 = state_26211;
var statearr_26245_26437 = state_26211__$1;
(statearr_26245_26437[(2)] = inst_26169);

(statearr_26245_26437[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (95))){
var state_26211__$1 = state_26211;
var statearr_26246_26438 = state_26211__$1;
(statearr_26246_26438[(1)] = (119));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (54))){
var inst_25994 = (state_26211[(21)]);
var state_26211__$1 = state_26211;
var statearr_26248_26439 = state_26211__$1;
(statearr_26248_26439[(2)] = inst_25994);

(statearr_26248_26439[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (92))){
var inst_26093 = (state_26211[(22)]);
var state_26211__$1 = state_26211;
var statearr_26249_26440 = state_26211__$1;
(statearr_26249_26440[(2)] = inst_26093);

(statearr_26249_26440[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (104))){
var inst_26137 = (state_26211[(23)]);
var inst_26137__$1 = (state_26211[(2)]);
var state_26211__$1 = (function (){var statearr_26250 = state_26211;
(statearr_26250[(23)] = inst_26137__$1);

return statearr_26250;
})();
if(cljs.core.truth_(inst_26137__$1)){
var statearr_26251_26441 = state_26211__$1;
(statearr_26251_26441[(1)] = (109));

} else {
var statearr_26252_26442 = state_26211__$1;
(statearr_26252_26442[(1)] = (110));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (15))){
var inst_25908 = (state_26211[(24)]);
var inst_25906 = (state_26211[(25)]);
var inst_25912 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25908,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),inst_25906);
var state_26211__$1 = state_26211;
var statearr_26253_26443 = state_26211__$1;
(statearr_26253_26443[(2)] = inst_25912);

(statearr_26253_26443[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (48))){
var inst_26022 = (state_26211[(9)]);
var inst_26022__$1 = typeof from === 'string';
var state_26211__$1 = (function (){var statearr_26254 = state_26211;
(statearr_26254[(9)] = inst_26022__$1);

return statearr_26254;
})();
if(cljs.core.truth_(inst_26022__$1)){
var statearr_26255_26444 = state_26211__$1;
(statearr_26255_26444[(1)] = (61));

} else {
var statearr_26256_26445 = state_26211__$1;
(statearr_26256_26445[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (50))){
var inst_25988 = (state_26211[(26)]);
var inst_25990 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_25991 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_25988,inst_25990);
var state_26211__$1 = state_26211;
var statearr_26257_26446 = state_26211__$1;
(statearr_26257_26446[(2)] = inst_25991);

(statearr_26257_26446[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (116))){
var state_26211__$1 = state_26211;
var statearr_26258_26447 = state_26211__$1;
(statearr_26258_26447[(2)] = null);

(statearr_26258_26447[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (75))){
var inst_26052 = cljs.core.PersistentHashMap.EMPTY;
var state_26211__$1 = state_26211;
var statearr_26259_26448 = state_26211__$1;
(statearr_26259_26448[(2)] = inst_26052);

(statearr_26259_26448[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (99))){
var inst_26113 = (state_26211[(10)]);
var state_26211__$1 = state_26211;
var statearr_26260_26449 = state_26211__$1;
(statearr_26260_26449[(2)] = inst_26113);

(statearr_26260_26449[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (21))){
var inst_25904 = (state_26211[(18)]);
var inst_25921 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25922 = cljs.core.second(inst_25904);
var inst_25923 = cljs.core.first(inst_25904);
var inst_25924 = [inst_25922,inst_25923];
var inst_25925 = (new cljs.core.PersistentVector(null,2,(5),inst_25921,inst_25924,null));
var state_26211__$1 = state_26211;
var statearr_26261_26450 = state_26211__$1;
(statearr_26261_26450[(2)] = inst_25925);

(statearr_26261_26450[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (31))){
var inst_25979 = (state_26211[(27)]);
var inst_25979__$1 = typeof from === 'string';
var state_26211__$1 = (function (){var statearr_26262 = state_26211;
(statearr_26262[(27)] = inst_25979__$1);

return statearr_26262;
})();
if(cljs.core.truth_(inst_25979__$1)){
var statearr_26263_26451 = state_26211__$1;
(statearr_26263_26451[(1)] = (44));

} else {
var statearr_26264_26452 = state_26211__$1;
(statearr_26264_26452[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (113))){
var state_26211__$1 = state_26211;
var statearr_26265_26453 = state_26211__$1;
(statearr_26265_26453[(2)] = null);

(statearr_26265_26453[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (32))){
var inst_25950 = (state_26211[(17)]);
var inst_26184 = (state_26211[(2)]);
var state_26211__$1 = (function (){var statearr_26266 = state_26211;
(statearr_26266[(28)] = inst_26184);

return statearr_26266;
})();
if(cljs.core.truth_(inst_25950)){
var statearr_26267_26454 = state_26211__$1;
(statearr_26267_26454[(1)] = (122));

} else {
var statearr_26268_26455 = state_26211__$1;
(statearr_26268_26455[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (40))){
var inst_25904 = (state_26211[(18)]);
var inst_25969 = (state_26211[(2)]);
var state_26211__$1 = (function (){var statearr_26269 = state_26211;
(statearr_26269[(29)] = inst_25969);

return statearr_26269;
})();
if(cljs.core.truth_(inst_25904)){
var statearr_26270_26456 = state_26211__$1;
(statearr_26270_26456[(1)] = (41));

} else {
var statearr_26271_26457 = state_26211__$1;
(statearr_26271_26457[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (129))){
var inst_26192 = (state_26211[(30)]);
var state_26211__$1 = state_26211;
var statearr_26272_26458 = state_26211__$1;
(statearr_26272_26458[(2)] = inst_26192);

(statearr_26272_26458[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (91))){
var inst_26095 = cljs.core.every_QMARK_(fluree.db.util.core.subj_ident_QMARK_,from);
var state_26211__$1 = state_26211;
var statearr_26273_26459 = state_26211__$1;
(statearr_26273_26459[(2)] = inst_26095);

(statearr_26273_26459[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (117))){
var inst_25907 = (state_26211[(15)]);
var state_26211__$1 = state_26211;
var statearr_26274_26460 = state_26211__$1;
(statearr_26274_26460[(2)] = inst_25907);

(statearr_26274_26460[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (108))){
var inst_26134 = (state_26211[(2)]);
var inst_26135 = fluree.db.util.async.throw_err(inst_26134);
var state_26211__$1 = state_26211;
var statearr_26275_26461 = state_26211__$1;
(statearr_26275_26461[(2)] = inst_26135);

(statearr_26275_26461[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (56))){
var inst_26002 = cljs.core.PersistentHashMap.EMPTY;
var state_26211__$1 = state_26211;
var statearr_26276_26462 = state_26211__$1;
(statearr_26276_26462[(2)] = inst_26002);

(statearr_26276_26462[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (33))){
var state_26211__$1 = state_26211;
var statearr_26277_26463 = state_26211__$1;
(statearr_26277_26463[(2)] = from);

(statearr_26277_26463[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (13))){
var inst_25891 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25892 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_25893 = cljs.core.PersistentHashMap.fromArrays(inst_25891,inst_25892);
var inst_25894 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Query missing :select or :selectOne.",inst_25893);
var inst_25895 = (function(){throw inst_25894})();
var state_26211__$1 = state_26211;
var statearr_26278_26464 = state_26211__$1;
(statearr_26278_26464[(2)] = inst_25895);

(statearr_26278_26464[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (22))){
var inst_25904 = (state_26211[(18)]);
var inst_25927 = typeof inst_25904 === 'string';
var state_26211__$1 = state_26211;
if(cljs.core.truth_(inst_25927)){
var statearr_26279_26465 = state_26211__$1;
(statearr_26279_26465[(1)] = (24));

} else {
var statearr_26280_26466 = state_26211__$1;
(statearr_26280_26466[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (90))){
var inst_26086 = (state_26211[(31)]);
var inst_26091 = (state_26211[(2)]);
var state_26211__$1 = (function (){var statearr_26281 = state_26211;
(statearr_26281[(32)] = inst_26091);

return statearr_26281;
})();
var statearr_26282_26467 = state_26211__$1;
(statearr_26282_26467[(2)] = inst_26086);

(statearr_26282_26467[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (109))){
var inst_26113 = (state_26211[(10)]);
var inst_26137 = (state_26211[(23)]);
var inst_26139 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26113,inst_26137);
var state_26211__$1 = state_26211;
var statearr_26283_26468 = state_26211__$1;
(statearr_26283_26468[(2)] = inst_26139);

(statearr_26283_26468[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (36))){
var inst_25904 = (state_26211[(18)]);
var inst_25964 = (state_26211[(2)]);
var inst_25965 = fluree.db.util.async.throw_err(inst_25964);
var state_26211__$1 = (function (){var statearr_26284 = state_26211;
(statearr_26284[(33)] = inst_25965);

return statearr_26284;
})();
if(cljs.core.truth_(inst_25904)){
var statearr_26285_26469 = state_26211__$1;
(statearr_26285_26469[(1)] = (38));

} else {
var statearr_26286_26470 = state_26211__$1;
(statearr_26286_26470[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (41))){
var state_26211__$1 = state_26211;
var statearr_26287_26471 = state_26211__$1;
(statearr_26287_26471[(2)] = null);

(statearr_26287_26471[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (118))){
var inst_25917 = (state_26211[(7)]);
var inst_26149 = (state_26211[(34)]);
var inst_26153 = (state_26211[(35)]);
var inst_25915 = (state_26211[(8)]);
var inst_26157 = (state_26211[(2)]);
var inst_26158 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_25917,fuel,max_fuel,inst_25915,inst_26149,inst_26153,inst_26157);
var state_26211__$1 = state_26211;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26211__$1,(112),inst_26158);
} else {
if((state_val_26212 === (89))){
var state_26211__$1 = state_26211;
var statearr_26288_26472 = state_26211__$1;
(statearr_26288_26472[(2)] = null);

(statearr_26288_26472[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (100))){
var inst_26119 = (state_26211[(19)]);
var inst_26124 = cljs.core.int_QMARK_(inst_26119);
var state_26211__$1 = state_26211;
if(inst_26124){
var statearr_26289_26473 = state_26211__$1;
(statearr_26289_26473[(1)] = (102));

} else {
var statearr_26290_26474 = state_26211__$1;
(statearr_26290_26474[(1)] = (103));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (131))){
var inst_26189 = (state_26211[(11)]);
var inst_26203 = cljs.core.first(inst_26189);
var state_26211__$1 = state_26211;
var statearr_26291_26475 = state_26211__$1;
(statearr_26291_26475[(2)] = inst_26203);

(statearr_26291_26475[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (122))){
var inst_26184 = (state_26211[(28)]);
var inst_25907 = (state_26211[(15)]);
var inst_25951 = (state_26211[(16)]);
var inst_25905 = (state_26211[(14)]);
var inst_25950 = (state_26211[(17)]);
var inst_26186 = fluree.db.query.fql.sort_offset_and_limit_res(inst_25950,inst_25951,inst_25907,inst_25905,inst_26184);
var state_26211__$1 = state_26211;
var statearr_26292_26476 = state_26211__$1;
(statearr_26292_26476[(2)] = inst_26186);

(statearr_26292_26476[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (43))){
var inst_25969 = (state_26211[(29)]);
var inst_25917 = (state_26211[(7)]);
var inst_25965 = (state_26211[(33)]);
var inst_25915 = (state_26211[(8)]);
var inst_25973 = (state_26211[(2)]);
var inst_25974 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_25917,fuel,max_fuel,inst_25915,inst_25965,inst_25969,inst_25973);
var state_26211__$1 = state_26211;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26211__$1,(37),inst_25974);
} else {
if((state_val_26212 === (61))){
var inst_26024 = ["_tx",null,"_block",null];
var inst_26025 = (new cljs.core.PersistentArrayMap(null,2,inst_26024,null));
var inst_26026 = (new cljs.core.PersistentHashSet(null,inst_26025,null));
var inst_26027 = (inst_26026.cljs$core$IFn$_invoke$arity$1 ? inst_26026.cljs$core$IFn$_invoke$arity$1(from) : inst_26026.call(null,from));
var state_26211__$1 = state_26211;
var statearr_26293_26477 = state_26211__$1;
(statearr_26293_26477[(2)] = inst_26027);

(statearr_26293_26477[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (29))){
var inst_25939 = (state_26211[(2)]);
var state_26211__$1 = state_26211;
var statearr_26294_26478 = state_26211__$1;
(statearr_26294_26478[(2)] = inst_25939);

(statearr_26294_26478[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (44))){
var inst_25981 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_25982 = clojure.string.includes_QMARK_(inst_25981,"/");
var state_26211__$1 = state_26211;
var statearr_26295_26479 = state_26211__$1;
(statearr_26295_26479[(2)] = inst_25982);

(statearr_26295_26479[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (93))){
var inst_26098 = (state_26211[(2)]);
var state_26211__$1 = state_26211;
if(cljs.core.truth_(inst_26098)){
var statearr_26296_26480 = state_26211__$1;
(statearr_26296_26480[(1)] = (94));

} else {
var statearr_26297_26481 = state_26211__$1;
(statearr_26297_26481[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (6))){
var inst_25882 = (state_26211[(36)]);
var state_26211__$1 = state_26211;
var statearr_26298_26482 = state_26211__$1;
(statearr_26298_26482[(2)] = inst_25882);

(statearr_26298_26482[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (111))){
var inst_26120 = (state_26211[(37)]);
var inst_26142 = (state_26211[(2)]);
var inst_26112 = inst_26120;
var inst_26113 = inst_26142;
var state_26211__$1 = (function (){var statearr_26299 = state_26211;
(statearr_26299[(38)] = inst_26112);

(statearr_26299[(10)] = inst_26113);

return statearr_26299;
})();
var statearr_26300_26483 = state_26211__$1;
(statearr_26300_26483[(2)] = null);

(statearr_26300_26483[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (28))){
var state_26211__$1 = state_26211;
var statearr_26301_26484 = state_26211__$1;
(statearr_26301_26484[(2)] = null);

(statearr_26301_26484[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (64))){
var inst_25904 = (state_26211[(18)]);
var state_26211__$1 = state_26211;
if(cljs.core.truth_(inst_25904)){
var statearr_26302_26485 = state_26211__$1;
(statearr_26302_26485[(1)] = (67));

} else {
var statearr_26303_26486 = state_26211__$1;
(statearr_26303_26486[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (103))){
var state_26211__$1 = state_26211;
if(cljs.core.truth_(fuel)){
var statearr_26304_26487 = state_26211__$1;
(statearr_26304_26487[(1)] = (105));

} else {
var statearr_26305_26488 = state_26211__$1;
(statearr_26305_26488[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (51))){
var inst_25988 = (state_26211[(26)]);
var state_26211__$1 = state_26211;
var statearr_26306_26489 = state_26211__$1;
(statearr_26306_26489[(2)] = inst_25988);

(statearr_26306_26489[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (25))){
var state_26211__$1 = state_26211;
var statearr_26307_26490 = state_26211__$1;
(statearr_26307_26490[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (34))){
var state_26211__$1 = state_26211;
var statearr_26309_26491 = state_26211__$1;
(statearr_26309_26491[(2)] = null);

(statearr_26309_26491[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (125))){
var inst_26189 = (state_26211[(11)]);
var inst_26192 = (state_26211[(30)]);
var inst_26192__$1 = cljs.core.coll_QMARK_(inst_26189);
var state_26211__$1 = (function (){var statearr_26310 = state_26211;
(statearr_26310[(30)] = inst_26192__$1);

return statearr_26310;
})();
if(inst_26192__$1){
var statearr_26311_26492 = state_26211__$1;
(statearr_26311_26492[(1)] = (128));

} else {
var statearr_26312_26493 = state_26211__$1;
(statearr_26312_26493[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (17))){
var inst_25904 = (state_26211[(18)]);
var inst_25915 = (state_26211[(2)]);
var inst_25916 = cljs.core.PersistentHashMap.EMPTY;
var inst_25917 = cljs.core.volatile_BANG_(inst_25916);
var state_26211__$1 = (function (){var statearr_26313 = state_26211;
(statearr_26313[(7)] = inst_25917);

(statearr_26313[(8)] = inst_25915);

return statearr_26313;
})();
if(cljs.core.truth_(inst_25904)){
var statearr_26314_26494 = state_26211__$1;
(statearr_26314_26494[(1)] = (18));

} else {
var statearr_26315_26495 = state_26211__$1;
(statearr_26315_26495[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (3))){
var inst_26209 = (state_26211[(2)]);
var state_26211__$1 = state_26211;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26211__$1,inst_26209);
} else {
if((state_val_26212 === (12))){
var inst_25888 = (state_26211[(39)]);
var state_26211__$1 = state_26211;
var statearr_26316_26496 = state_26211__$1;
(statearr_26316_26496[(2)] = inst_25888);

(statearr_26316_26496[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (2))){
var inst_25882 = (state_26211[(36)]);
var _ = (function (){var statearr_26317 = state_26211;
(statearr_26317[(4)] = cljs.core.cons((5),(state_26211[(4)])));

return statearr_26317;
})();
var inst_25882__$1 = select;
var state_26211__$1 = (function (){var statearr_26318 = state_26211;
(statearr_26318[(36)] = inst_25882__$1);

return statearr_26318;
})();
if(cljs.core.truth_(inst_25882__$1)){
var statearr_26319_26497 = state_26211__$1;
(statearr_26319_26497[(1)] = (6));

} else {
var statearr_26320_26498 = state_26211__$1;
(statearr_26320_26498[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (66))){
var inst_26180 = (state_26211[(2)]);
var state_26211__$1 = state_26211;
var statearr_26321_26499 = state_26211__$1;
(statearr_26321_26499[(2)] = inst_26180);

(statearr_26321_26499[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (107))){
var inst_26119 = (state_26211[(19)]);
var inst_26131 = (state_26211[(2)]);
var inst_26132 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,inst_26119,false);
var state_26211__$1 = (function (){var statearr_26322 = state_26211;
(statearr_26322[(40)] = inst_26131);

return statearr_26322;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26211__$1,(108),inst_26132);
} else {
if((state_val_26212 === (23))){
var inst_25943 = (state_26211[(2)]);
var state_26211__$1 = state_26211;
var statearr_26323_26500 = state_26211__$1;
(statearr_26323_26500[(2)] = inst_25943);

(statearr_26323_26500[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (47))){
var inst_25988 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_26211__$1 = (function (){var statearr_26324 = state_26211;
(statearr_26324[(26)] = inst_25988);

return statearr_26324;
})();
if(cljs.core.truth_(fuel)){
var statearr_26325_26501 = state_26211__$1;
(statearr_26325_26501[(1)] = (50));

} else {
var statearr_26326_26502 = state_26211__$1;
(statearr_26326_26502[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (35))){
var inst_25907 = (state_26211[(15)]);
var inst_25905 = (state_26211[(14)]);
var inst_25958 = (state_26211[(2)]);
var inst_25959 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25960 = [inst_25905,inst_25907];
var inst_25961 = cljs.core.PersistentHashMap.fromArrays(inst_25959,inst_25960);
var inst_25962 = fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4(db,where,inst_25958,inst_25961);
var state_26211__$1 = state_26211;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26211__$1,(36),inst_25962);
} else {
if((state_val_26212 === (127))){
var inst_26201 = (state_26211[(2)]);
var state_26211__$1 = state_26211;
if(cljs.core.truth_(inst_26201)){
var statearr_26327_26503 = state_26211__$1;
(statearr_26327_26503[(1)] = (131));

} else {
var statearr_26328_26504 = state_26211__$1;
(statearr_26328_26504[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (82))){
var inst_26176 = (state_26211[(2)]);
var state_26211__$1 = state_26211;
var statearr_26329_26505 = state_26211__$1;
(statearr_26329_26505[(2)] = inst_26176);

(statearr_26329_26505[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (76))){
var inst_25907 = (state_26211[(15)]);
var inst_25905 = (state_26211[(14)]);
var inst_26054 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_26055 = [inst_25905,inst_25907];
var inst_26056 = cljs.core.PersistentHashMap.fromArrays(inst_26054,inst_26055);
var state_26211__$1 = state_26211;
var statearr_26330_26506 = state_26211__$1;
(statearr_26330_26506[(2)] = inst_26056);

(statearr_26330_26506[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (97))){
var inst_26112 = (state_26211[(38)]);
var inst_26119 = (state_26211[(19)]);
var inst_26118 = cljs.core.seq(inst_26112);
var inst_26119__$1 = cljs.core.first(inst_26118);
var inst_26120 = cljs.core.next(inst_26118);
var inst_26121 = cljs.core.not(inst_26119__$1);
var state_26211__$1 = (function (){var statearr_26331 = state_26211;
(statearr_26331[(37)] = inst_26120);

(statearr_26331[(19)] = inst_26119__$1);

return statearr_26331;
})();
if(inst_26121){
var statearr_26332_26507 = state_26211__$1;
(statearr_26332_26507[(1)] = (99));

} else {
var statearr_26333_26508 = state_26211__$1;
(statearr_26333_26508[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (19))){
var inst_25945 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25946 = [null,null];
var inst_25947 = (new cljs.core.PersistentVector(null,2,(5),inst_25945,inst_25946,null));
var state_26211__$1 = state_26211;
var statearr_26334_26509 = state_26211__$1;
(statearr_26334_26509[(2)] = inst_25947);

(statearr_26334_26509[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (57))){
var inst_25907 = (state_26211[(15)]);
var inst_25905 = (state_26211[(14)]);
var inst_26004 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_26005 = [inst_25905,inst_25907];
var inst_26006 = cljs.core.PersistentHashMap.fromArrays(inst_26004,inst_26005);
var state_26211__$1 = state_26211;
var statearr_26335_26510 = state_26211__$1;
(statearr_26335_26510[(2)] = inst_26006);

(statearr_26335_26510[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (68))){
var inst_25907 = (state_26211[(15)]);
var inst_25905 = (state_26211[(14)]);
var inst_26035 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_26036 = [inst_25905,inst_25907];
var inst_26037 = cljs.core.PersistentHashMap.fromArrays(inst_26035,inst_26036);
var state_26211__$1 = state_26211;
var statearr_26336_26511 = state_26211__$1;
(statearr_26336_26511[(2)] = inst_26037);

(statearr_26336_26511[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (11))){
var inst_25899 = (state_26211[(2)]);
var state_26211__$1 = state_26211;
var statearr_26337_26512 = state_26211__$1;
(statearr_26337_26512[(2)] = inst_25899);

(statearr_26337_26512[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (115))){
var inst_25904 = (state_26211[(18)]);
var inst_26153 = (state_26211[(2)]);
var state_26211__$1 = (function (){var statearr_26339 = state_26211;
(statearr_26339[(35)] = inst_26153);

return statearr_26339;
})();
if(cljs.core.truth_(inst_25904)){
var statearr_26340_26513 = state_26211__$1;
(statearr_26340_26513[(1)] = (116));

} else {
var statearr_26341_26514 = state_26211__$1;
(statearr_26341_26514[(1)] = (117));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (9))){
var inst_25885 = (state_26211[(12)]);
var state_26211__$1 = state_26211;
var statearr_26342_26515 = state_26211__$1;
(statearr_26342_26515[(2)] = inst_25885);

(statearr_26342_26515[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (5))){
var _ = (function (){var statearr_26343 = state_26211;
(statearr_26343[(4)] = cljs.core.rest((state_26211[(4)])));

return statearr_26343;
})();
var state_26211__$1 = state_26211;
var ex26338 = (state_26211__$1[(2)]);
var statearr_26344_26516 = state_26211__$1;
(statearr_26344_26516[(5)] = ex26338);


if((ex26338 instanceof Error)){
var statearr_26345_26517 = state_26211__$1;
(statearr_26345_26517[(1)] = (4));

(statearr_26345_26517[(5)] = null);

} else {
throw ex26338;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (112))){
var inst_26160 = (state_26211[(2)]);
var inst_26161 = fluree.db.util.async.throw_err(inst_26160);
var state_26211__$1 = state_26211;
var statearr_26346_26518 = state_26211__$1;
(statearr_26346_26518[(2)] = inst_26161);

(statearr_26346_26518[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (83))){
var inst_26074 = (state_26211[(20)]);
var inst_26073 = (state_26211[(2)]);
var inst_26074__$1 = fluree.db.util.async.throw_err(inst_26073);
var inst_26075 = (inst_26074__$1 == null);
var state_26211__$1 = (function (){var statearr_26347 = state_26211;
(statearr_26347[(20)] = inst_26074__$1);

return statearr_26347;
})();
if(cljs.core.truth_(inst_26075)){
var statearr_26348_26519 = state_26211__$1;
(statearr_26348_26519[(1)] = (84));

} else {
var statearr_26349_26520 = state_26211__$1;
(statearr_26349_26520[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (14))){
var inst_25897 = (state_26211[(2)]);
var state_26211__$1 = state_26211;
var statearr_26350_26521 = state_26211__$1;
(statearr_26350_26521[(2)] = inst_25897);

(statearr_26350_26521[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (45))){
var inst_25979 = (state_26211[(27)]);
var state_26211__$1 = state_26211;
var statearr_26351_26522 = state_26211__$1;
(statearr_26351_26522[(2)] = inst_25979);

(statearr_26351_26522[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (53))){
var inst_25994 = (state_26211[(21)]);
var inst_25996 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_25997 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_25994,inst_25996);
var state_26211__$1 = state_26211;
var statearr_26352_26523 = state_26211__$1;
(statearr_26352_26523[(2)] = inst_25997);

(statearr_26352_26523[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (78))){
var inst_25917 = (state_26211[(7)]);
var inst_25915 = (state_26211[(8)]);
var inst_26061 = (state_26211[(2)]);
var inst_26062 = fluree.db.util.async.throw_err(inst_26061);
var inst_26063 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_25917,fuel,max_fuel,inst_25915,inst_26062);
var state_26211__$1 = state_26211;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26211__$1,(79),inst_26063);
} else {
if((state_val_26212 === (132))){
var inst_26189 = (state_26211[(11)]);
var state_26211__$1 = state_26211;
var statearr_26353_26524 = state_26211__$1;
(statearr_26353_26524[(2)] = inst_26189);

(statearr_26353_26524[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (26))){
var inst_25941 = (state_26211[(2)]);
var state_26211__$1 = state_26211;
var statearr_26354_26525 = state_26211__$1;
(statearr_26354_26525[(2)] = inst_25941);

(statearr_26354_26525[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (123))){
var inst_26184 = (state_26211[(28)]);
var state_26211__$1 = state_26211;
var statearr_26355_26526 = state_26211__$1;
(statearr_26355_26526[(2)] = inst_26184);

(statearr_26355_26526[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (16))){
var inst_25908 = (state_26211[(24)]);
var state_26211__$1 = state_26211;
var statearr_26356_26527 = state_26211__$1;
(statearr_26356_26527[(2)] = inst_25908);

(statearr_26356_26527[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (133))){
var inst_26206 = (state_26211[(2)]);
var _ = (function (){var statearr_26357 = state_26211;
(statearr_26357[(4)] = cljs.core.rest((state_26211[(4)])));

return statearr_26357;
})();
var state_26211__$1 = state_26211;
var statearr_26358_26528 = state_26211__$1;
(statearr_26358_26528[(2)] = inst_26206);

(statearr_26358_26528[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (81))){
var inst_26093 = (state_26211[(22)]);
var inst_26093__$1 = cljs.core.sequential_QMARK_(from);
var state_26211__$1 = (function (){var statearr_26359 = state_26211;
(statearr_26359[(22)] = inst_26093__$1);

return statearr_26359;
})();
if(inst_26093__$1){
var statearr_26360_26529 = state_26211__$1;
(statearr_26360_26529[(1)] = (91));

} else {
var statearr_26361_26530 = state_26211__$1;
(statearr_26361_26530[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (120))){
var state_26211__$1 = state_26211;
var statearr_26362_26531 = state_26211__$1;
(statearr_26362_26531[(2)] = null);

(statearr_26362_26531[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (79))){
var inst_26065 = (state_26211[(2)]);
var inst_26066 = fluree.db.util.async.throw_err(inst_26065);
var state_26211__$1 = state_26211;
var statearr_26363_26532 = state_26211__$1;
(statearr_26363_26532[(2)] = inst_26066);

(statearr_26363_26532[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (38))){
var state_26211__$1 = state_26211;
var statearr_26364_26533 = state_26211__$1;
(statearr_26364_26533[(2)] = null);

(statearr_26364_26533[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (126))){
var inst_26190 = (state_26211[(41)]);
var state_26211__$1 = state_26211;
var statearr_26365_26534 = state_26211__$1;
(statearr_26365_26534[(2)] = inst_26190);

(statearr_26365_26534[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (98))){
var inst_25904 = (state_26211[(18)]);
var inst_26147 = (state_26211[(2)]);
var inst_26148 = cljs.core.PersistentVector.EMPTY;
var inst_26149 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26148,inst_26147);
var state_26211__$1 = (function (){var statearr_26366 = state_26211;
(statearr_26366[(34)] = inst_26149);

return statearr_26366;
})();
if(cljs.core.truth_(inst_25904)){
var statearr_26367_26535 = state_26211__$1;
(statearr_26367_26535[(1)] = (113));

} else {
var statearr_26368_26536 = state_26211__$1;
(statearr_26368_26536[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (124))){
var inst_26190 = (state_26211[(41)]);
var inst_26189 = (state_26211[(2)]);
var inst_26190__$1 = selectOne;
var state_26211__$1 = (function (){var statearr_26369 = state_26211;
(statearr_26369[(41)] = inst_26190__$1);

(statearr_26369[(11)] = inst_26189);

return statearr_26369;
})();
if(cljs.core.truth_(inst_26190__$1)){
var statearr_26370_26537 = state_26211__$1;
(statearr_26370_26537[(1)] = (125));

} else {
var statearr_26371_26538 = state_26211__$1;
(statearr_26371_26538[(1)] = (126));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (87))){
var inst_26085 = (state_26211[(2)]);
var inst_26086 = fluree.db.util.async.throw_err(inst_26085);
var state_26211__$1 = (function (){var statearr_26372 = state_26211;
(statearr_26372[(31)] = inst_26086);

return statearr_26372;
})();
if(cljs.core.truth_(fuel)){
var statearr_26373_26539 = state_26211__$1;
(statearr_26373_26539[(1)] = (88));

} else {
var statearr_26374_26540 = state_26211__$1;
(statearr_26374_26540[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (30))){
var inst_25954 = typeof from === 'string';
var state_26211__$1 = state_26211;
if(cljs.core.truth_(inst_25954)){
var statearr_26375_26541 = state_26211__$1;
(statearr_26375_26541[(1)] = (33));

} else {
var statearr_26376_26542 = state_26211__$1;
(statearr_26376_26542[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (73))){
var inst_26068 = fluree.db.util.core.subj_ident_QMARK_(from);
var state_26211__$1 = state_26211;
if(inst_26068){
var statearr_26377_26543 = state_26211__$1;
(statearr_26377_26543[(1)] = (80));

} else {
var statearr_26378_26544 = state_26211__$1;
(statearr_26378_26544[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (96))){
var inst_26174 = (state_26211[(2)]);
var state_26211__$1 = state_26211;
var statearr_26379_26545 = state_26211__$1;
(statearr_26379_26545[(2)] = inst_26174);

(statearr_26379_26545[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (10))){
var inst_25888 = (state_26211[(39)]);
var inst_25888__$1 = selectDistinct;
var state_26211__$1 = (function (){var statearr_26380 = state_26211;
(statearr_26380[(39)] = inst_25888__$1);

return statearr_26380;
})();
if(cljs.core.truth_(inst_25888__$1)){
var statearr_26381_26546 = state_26211__$1;
(statearr_26381_26546[(1)] = (12));

} else {
var statearr_26382_26547 = state_26211__$1;
(statearr_26382_26547[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (18))){
var inst_25904 = (state_26211[(18)]);
var inst_25919 = cljs.core.vector_QMARK_(inst_25904);
var state_26211__$1 = state_26211;
if(inst_25919){
var statearr_26383_26548 = state_26211__$1;
(statearr_26383_26548[(1)] = (21));

} else {
var statearr_26384_26549 = state_26211__$1;
(statearr_26384_26549[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (105))){
var inst_26128 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2(fuel,cljs.core.inc);
var state_26211__$1 = state_26211;
var statearr_26385_26550 = state_26211__$1;
(statearr_26385_26550[(2)] = inst_26128);

(statearr_26385_26550[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (52))){
var inst_25994 = (state_26211[(2)]);
var state_26211__$1 = (function (){var statearr_26386 = state_26211;
(statearr_26386[(21)] = inst_25994);

return statearr_26386;
})();
var statearr_26387_26551 = state_26211__$1;
(statearr_26387_26551[(1)] = (53));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (114))){
var inst_25905 = (state_26211[(14)]);
var state_26211__$1 = state_26211;
var statearr_26389_26552 = state_26211__$1;
(statearr_26389_26552[(2)] = inst_25905);

(statearr_26389_26552[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (67))){
var inst_26033 = cljs.core.PersistentHashMap.EMPTY;
var state_26211__$1 = state_26211;
var statearr_26390_26553 = state_26211__$1;
(statearr_26390_26553[(2)] = inst_26033);

(statearr_26390_26553[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (71))){
var inst_26046 = (state_26211[(2)]);
var inst_26047 = fluree.db.util.async.throw_err(inst_26046);
var state_26211__$1 = state_26211;
var statearr_26391_26554 = state_26211__$1;
(statearr_26391_26554[(2)] = inst_26047);

(statearr_26391_26554[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (42))){
var inst_25907 = (state_26211[(15)]);
var state_26211__$1 = state_26211;
var statearr_26392_26555 = state_26211__$1;
(statearr_26392_26555[(2)] = inst_25907);

(statearr_26392_26555[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (80))){
var inst_26071 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,from,false);
var state_26211__$1 = state_26211;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26211__$1,(83),inst_26071);
} else {
if((state_val_26212 === (37))){
var inst_25976 = (state_26211[(2)]);
var inst_25977 = fluree.db.util.async.throw_err(inst_25976);
var state_26211__$1 = state_26211;
var statearr_26393_26556 = state_26211__$1;
(statearr_26393_26556[(2)] = inst_25977);

(statearr_26393_26556[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (63))){
var inst_26030 = (state_26211[(2)]);
var state_26211__$1 = state_26211;
if(cljs.core.truth_(inst_26030)){
var statearr_26394_26557 = state_26211__$1;
(statearr_26394_26557[(1)] = (64));

} else {
var statearr_26395_26558 = state_26211__$1;
(statearr_26395_26558[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (94))){
var inst_26107 = from;
var inst_26108 = cljs.core.seq(inst_26107);
var inst_26109 = cljs.core.first(inst_26108);
var inst_26110 = cljs.core.next(inst_26108);
var inst_26111 = cljs.core.PersistentVector.EMPTY;
var inst_26112 = inst_26107;
var inst_26113 = inst_26111;
var state_26211__$1 = (function (){var statearr_26396 = state_26211;
(statearr_26396[(42)] = inst_26110);

(statearr_26396[(38)] = inst_26112);

(statearr_26396[(10)] = inst_26113);

(statearr_26396[(43)] = inst_26109);

return statearr_26396;
})();
var statearr_26397_26559 = state_26211__$1;
(statearr_26397_26559[(2)] = null);

(statearr_26397_26559[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (8))){
var inst_25906 = (state_26211[(25)]);
var inst_25901 = (state_26211[(2)]);
var inst_25902 = opts_SINGLEQUOTE_;
var inst_25903 = cljs.core.__destructure_map(inst_25902);
var inst_25904 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25903,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_25905 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25903,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_25906__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25903,new cljs.core.Keyword(null,"component","component",1555936782));
var inst_25907 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25903,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_25908 = fluree.db.query.fql_parser.parse_db(db,inst_25901,opts_SINGLEQUOTE_);
var inst_25909 = (inst_25906__$1 == null);
var inst_25910 = cljs.core.not(inst_25909);
var state_26211__$1 = (function (){var statearr_26398 = state_26211;
(statearr_26398[(24)] = inst_25908);

(statearr_26398[(25)] = inst_25906__$1);

(statearr_26398[(15)] = inst_25907);

(statearr_26398[(14)] = inst_25905);

(statearr_26398[(18)] = inst_25904);

return statearr_26398;
})();
if(inst_25910){
var statearr_26399_26560 = state_26211__$1;
(statearr_26399_26560[(1)] = (15));

} else {
var statearr_26400_26561 = state_26211__$1;
(statearr_26400_26561[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (49))){
var inst_26182 = (state_26211[(2)]);
var state_26211__$1 = state_26211;
var statearr_26401_26562 = state_26211__$1;
(statearr_26401_26562[(2)] = inst_26182);

(statearr_26401_26562[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26212 === (84))){
var state_26211__$1 = state_26211;
var statearr_26402_26563 = state_26211__$1;
(statearr_26402_26563[(2)] = null);

(statearr_26402_26563[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__2717__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__2717__auto____0 = (function (){
var statearr_26403 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26403[(0)] = fluree$db$query$fql$query_$_state_machine__2717__auto__);

(statearr_26403[(1)] = (1));

return statearr_26403;
});
var fluree$db$query$fql$query_$_state_machine__2717__auto____1 = (function (state_26211){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_26211);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e26404){var ex__2720__auto__ = e26404;
var statearr_26405_26564 = state_26211;
(statearr_26405_26564[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_26211[(4)]))){
var statearr_26406_26565 = state_26211;
(statearr_26406_26565[(1)] = cljs.core.first((state_26211[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26566 = state_26211;
state_26211 = G__26566;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__2717__auto__ = function(state_26211){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__2717__auto____1.call(this,state_26211);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__2717__auto____0;
fluree$db$query$fql$query_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__2717__auto____1;
return fluree$db$query$fql$query_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_26407 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_26407[(6)] = c__2739__auto__);

return statearr_26407;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}

});
