// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__18792 = arguments.length;
switch (G__18792) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3(operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var header = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"op","op",-1882987955),operation,new cljs.core.Keyword(null,"req-id","req-id",-471642231),req_id,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),fluree.db.util.core.current_time_millis(),new cljs.core.Keyword(null,"timeout","timeout",-318625318),timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__18795 = arguments.length;
switch (G__18795) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4(conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2739__auto___18848 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_18826){
var state_val_18827 = (state_18826[(1)]);
if((state_val_18827 === (1))){
var state_18826__$1 = state_18826;
var statearr_18828_18849 = state_18826__$1;
(statearr_18828_18849[(2)] = null);

(statearr_18828_18849[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18827 === (2))){
var _ = (function (){var statearr_18829 = state_18826;
(statearr_18829[(4)] = cljs.core.cons((5),(state_18826[(4)])));

return statearr_18829;
})();
var inst_18803 = fluree.db.operations.conn_closed_QMARK_(conn);
var state_18826__$1 = state_18826;
if(cljs.core.truth_(inst_18803)){
var statearr_18830_18850 = state_18826__$1;
(statearr_18830_18850[(1)] = (6));

} else {
var statearr_18831_18851 = state_18826__$1;
(statearr_18831_18851[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18827 === (3))){
var inst_18824 = (state_18826[(2)]);
var state_18826__$1 = state_18826;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18826__$1,inst_18824);
} else {
if((state_val_18827 === (4))){
var inst_18796 = (state_18826[(2)]);
var inst_18797 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_18796);
var state_18826__$1 = state_18826;
var statearr_18833_18852 = state_18826__$1;
(statearr_18833_18852[(2)] = inst_18797);

(statearr_18833_18852[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18827 === (5))){
var _ = (function (){var statearr_18834 = state_18826;
(statearr_18834[(4)] = cljs.core.rest((state_18826[(4)])));

return statearr_18834;
})();
var state_18826__$1 = state_18826;
var ex18832 = (state_18826__$1[(2)]);
var statearr_18835_18853 = state_18826__$1;
(statearr_18835_18853[(5)] = ex18832);


var statearr_18836_18854 = state_18826__$1;
(statearr_18836_18854[(1)] = (4));

(statearr_18836_18854[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18827 === (6))){
var inst_18805 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18806 = [(400),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)];
var inst_18807 = cljs.core.PersistentHashMap.fromArrays(inst_18805,inst_18806);
var inst_18808 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection was closed.",inst_18807);
var inst_18809 = (function(){throw inst_18808})();
var state_18826__$1 = state_18826;
var statearr_18837_18855 = state_18826__$1;
(statearr_18837_18855[(2)] = inst_18809);

(statearr_18837_18855[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18827 === (7))){
var inst_18811 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_18812 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18813 = [operation,data,pc,opts];
var inst_18814 = (new cljs.core.PersistentVector(null,4,(5),inst_18812,inst_18813,null));
var inst_18815 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_18811,inst_18814);
var inst_18816 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18817 = [operation,data,pc,opts];
var inst_18818 = (new cljs.core.PersistentVector(null,4,(5),inst_18816,inst_18817,null));
var inst_18819 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Put operation on connection req-chan: ",inst_18818], 0));
var state_18826__$1 = (function (){var statearr_18838 = state_18826;
(statearr_18838[(7)] = inst_18815);

return statearr_18838;
})();
var statearr_18839_18856 = state_18826__$1;
(statearr_18839_18856[(2)] = inst_18819);

(statearr_18839_18856[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18827 === (8))){
var inst_18821 = (state_18826[(2)]);
var _ = (function (){var statearr_18840 = state_18826;
(statearr_18840[(4)] = cljs.core.rest((state_18826[(4)])));

return statearr_18840;
})();
var state_18826__$1 = state_18826;
var statearr_18841_18857 = state_18826__$1;
(statearr_18841_18857[(2)] = inst_18821);

(statearr_18841_18857[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__2717__auto__ = null;
var fluree$db$operations$state_machine__2717__auto____0 = (function (){
var statearr_18842 = [null,null,null,null,null,null,null,null];
(statearr_18842[(0)] = fluree$db$operations$state_machine__2717__auto__);

(statearr_18842[(1)] = (1));

return statearr_18842;
});
var fluree$db$operations$state_machine__2717__auto____1 = (function (state_18826){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_18826);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e18843){var ex__2720__auto__ = e18843;
var statearr_18844_18858 = state_18826;
(statearr_18844_18858[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_18826[(4)]))){
var statearr_18845_18859 = state_18826;
(statearr_18845_18859[(1)] = cljs.core.first((state_18826[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18860 = state_18826;
state_18826 = G__18860;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2717__auto__ = function(state_18826){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2717__auto____1.call(this,state_18826);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2717__auto____0;
fluree$db$operations$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2717__auto____1;
return fluree$db$operations$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_18846 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_18846[(6)] = c__2739__auto___18848);

return statearr_18846;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__18862 = arguments.length;
switch (G__18862) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__18863){
var map__18864 = p__18863;
var map__18864__$1 = cljs.core.__destructure_map(map__18864);
var opts = map__18864__$1;
var snapshot_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18864__$1,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670));
var map__18865 = session;
var map__18865__$1 = cljs.core.__destructure_map(map__18865);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18865__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18865__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18865__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"delete-db","delete-db",1646085839),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670),snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4824__auto__ = [];
var len__4818__auto___18892 = arguments.length;
var i__4819__auto___18893 = (0);
while(true){
if((i__4819__auto___18893 < len__4818__auto___18892)){
args__4824__auto__.push((arguments[i__4819__auto___18893]));

var G__18894 = (i__4819__auto___18893 + (1));
i__4819__auto___18893 = G__18894;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__18869){
var vec__18870 = p__18869;
var map__18873 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18870,(0),null);
var map__18873__$1 = cljs.core.__destructure_map(map__18873);
var toBlock = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18873__$1,new cljs.core.Keyword(null,"toBlock","toBlock",1609458185));
var toTime = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18873__$1,new cljs.core.Keyword(null,"toTime","toTime",903224641));
var opts = vec__18870;
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_18885){
var state_val_18886 = (state_18885[(1)]);
if((state_val_18886 === (1))){
var inst_18875 = session;
var inst_18876 = cljs.core.__destructure_map(inst_18875);
var inst_18877 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18876,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_18878 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18876,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_18879 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18876,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_18880 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"toBlock","toBlock",1609458185),new cljs.core.Keyword(null,"toTime","toTime",903224641)];
var inst_18881 = [inst_18877,inst_18878,toBlock,toTime];
var inst_18882 = cljs.core.PersistentHashMap.fromArrays(inst_18880,inst_18881);
var inst_18883 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(inst_18879,new cljs.core.Keyword(null,"garbage","garbage",-2063107600),inst_18882);
var state_18885__$1 = state_18885;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18885__$1,inst_18883);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__2717__auto__ = null;
var fluree$db$operations$state_machine__2717__auto____0 = (function (){
var statearr_18887 = [null,null,null,null,null,null,null];
(statearr_18887[(0)] = fluree$db$operations$state_machine__2717__auto__);

(statearr_18887[(1)] = (1));

return statearr_18887;
});
var fluree$db$operations$state_machine__2717__auto____1 = (function (state_18885){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_18885);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e18888){var ex__2720__auto__ = e18888;
var statearr_18889_18895 = state_18885;
(statearr_18889_18895[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_18885[(4)]))){
var statearr_18890_18896 = state_18885;
(statearr_18890_18896[(1)] = cljs.core.first((state_18885[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18897 = state_18885;
state_18885 = G__18897;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2717__auto__ = function(state_18885){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2717__auto____1.call(this,state_18885);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2717__auto____0;
fluree$db$operations$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2717__auto____1;
return fluree$db$operations$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_18891 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_18891[(6)] = c__2739__auto__);

return statearr_18891;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq18867){
var G__18868 = cljs.core.first(seq18867);
var seq18867__$1 = cljs.core.next(seq18867);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18868,seq18867__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__18898 = session;
var map__18898__$1 = cljs.core.__destructure_map(map__18898);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18898__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18898__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18898__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"snapshot-db","snapshot-db",199417128),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"unsigned-cmd","unsigned-cmd",1466012010),unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-stats","ledger-stats",765646297),ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"db-list","db-list",230589843),null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Sending transaction async: ",tx_map], 0));

return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"tx","tx",466630418),tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__18900 = arguments.length;
switch (G__18900) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__18901 = opts;
var map__18901__$1 = cljs.core.__destructure_map(map__18901);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18901__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18901__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4212__auto__ = auth;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Subscribe to: ",new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt], 0));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"subscribe","subscribe",416253756),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"unsbuscribe","unsbuscribe",888593047),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null));
});
