// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches(/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__26569 = cljs.core.re_find(/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str(ledger));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26569,(0),null);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26569,(1),null);
var maybe_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26569,(2),null);
if(cljs.core.truth_((function (){var and__4210__auto__ = network;
if(cljs.core.truth_(and__4210__auto__)){
return maybe_alias;
} else {
return and__4210__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__26572){
var map__26573 = p__26572;
var map__26573__$1 = cljs.core.__destructure_map(map__26573);
var opts = map__26573__$1;
var reindex_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26573__$1,new cljs.core.Keyword(null,"reindex?","reindex?",683464852));
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_26633){
var state_val_26634 = (state_26633[(1)]);
if((state_val_26634 === (7))){
var inst_26604 = cljs.core.not(reindex_QMARK_);
var state_26633__$1 = state_26633;
var statearr_26635_26659 = state_26633__$1;
(statearr_26635_26659[(2)] = inst_26604);

(statearr_26635_26659[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26634 === (1))){
var state_26633__$1 = state_26633;
var statearr_26636_26660 = state_26633__$1;
(statearr_26636_26660[(2)] = null);

(statearr_26636_26660[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26634 === (4))){
var inst_26574 = (state_26633[(2)]);
var state_26633__$1 = state_26633;
var statearr_26637_26661 = state_26633__$1;
(statearr_26637_26661[(2)] = inst_26574);

(statearr_26637_26661[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26634 === (6))){
var inst_26588 = (state_26633[(7)]);
var inst_26602 = (state_26633[(8)]);
var inst_26594 = (state_26633[(9)]);
var inst_26587 = (state_26633[(2)]);
var inst_26588__$1 = fluree.db.util.async.throw_err(inst_26587);
var inst_26589 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_26590 = cljs.core.__destructure_map(inst_26589);
var inst_26591 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26590,new cljs.core.Keyword(null,"post","post",269697687));
var inst_26592 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26590,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_26593 = fluree.db.flake.size_bytes(inst_26588__$1);
var inst_26594__$1 = (inst_26592 + inst_26593);
var inst_26595 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26596 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_26597 = (new cljs.core.PersistentVector(null,2,(5),inst_26595,inst_26596,null));
var inst_26598 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_26597);
var inst_26599 = cljs.core.__destructure_map(inst_26598);
var inst_26600 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26599,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_26601 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26599,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_26602__$1 = (inst_26594__$1 > inst_26601);
var state_26633__$1 = (function (){var statearr_26638 = state_26633;
(statearr_26638[(7)] = inst_26588__$1);

(statearr_26638[(8)] = inst_26602__$1);

(statearr_26638[(10)] = inst_26600);

(statearr_26638[(9)] = inst_26594__$1);

(statearr_26638[(11)] = inst_26591);

return statearr_26638;
})();
if(cljs.core.truth_(inst_26602__$1)){
var statearr_26639_26662 = state_26633__$1;
(statearr_26639_26662[(1)] = (7));

} else {
var statearr_26640_26663 = state_26633__$1;
(statearr_26640_26663[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26634 === (3))){
var inst_26631 = (state_26633[(2)]);
var state_26633__$1 = state_26633;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26633__$1,inst_26631);
} else {
if((state_val_26634 === (12))){
var inst_26588 = (state_26633[(7)]);
var inst_26594 = (state_26633[(9)]);
var inst_26591 = (state_26633[(11)]);
var inst_26617 = (state_26633[(2)]);
var inst_26618 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26591,inst_26588);
var inst_26619 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_26620 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_26619,cljs.core.empty);
var inst_26621 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26622 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_26623 = (new cljs.core.PersistentVector(null,2,(5),inst_26621,inst_26622,null));
var inst_26624 = cljs.core.assoc_in(db,inst_26623,inst_26618);
var inst_26625 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26626 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26627 = (new cljs.core.PersistentVector(null,2,(5),inst_26625,inst_26626,null));
var inst_26628 = cljs.core.assoc_in(inst_26624,inst_26627,inst_26594);
var _ = (function (){var statearr_26641 = state_26633;
(statearr_26641[(4)] = cljs.core.rest((state_26633[(4)])));

return statearr_26641;
})();
var state_26633__$1 = (function (){var statearr_26642 = state_26633;
(statearr_26642[(12)] = inst_26620);

(statearr_26642[(13)] = inst_26617);

return statearr_26642;
})();
var statearr_26643_26664 = state_26633__$1;
(statearr_26643_26664[(2)] = inst_26628);

(statearr_26643_26664[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26634 === (2))){
var _ = (function (){var statearr_26644 = state_26633;
(statearr_26644[(4)] = cljs.core.cons((5),(state_26633[(4)])));

return statearr_26644;
})();
var inst_26582 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26583 = [pred_id];
var inst_26584 = (new cljs.core.PersistentVector(null,1,(5),inst_26582,inst_26583,null));
var inst_26585 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_26584);
var state_26633__$1 = state_26633;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26633__$1,(6),inst_26585);
} else {
if((state_val_26634 === (11))){
var state_26633__$1 = state_26633;
var statearr_26646_26665 = state_26633__$1;
(statearr_26646_26665[(2)] = null);

(statearr_26646_26665[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26634 === (9))){
var inst_26607 = (state_26633[(2)]);
var state_26633__$1 = state_26633;
if(cljs.core.truth_(inst_26607)){
var statearr_26647_26666 = state_26633__$1;
(statearr_26647_26666[(1)] = (10));

} else {
var statearr_26648_26667 = state_26633__$1;
(statearr_26648_26667[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26634 === (5))){
var _ = (function (){var statearr_26649 = state_26633;
(statearr_26649[(4)] = cljs.core.rest((state_26633[(4)])));

return statearr_26649;
})();
var state_26633__$1 = state_26633;
var ex26645 = (state_26633__$1[(2)]);
var statearr_26650_26668 = state_26633__$1;
(statearr_26650_26668[(5)] = ex26645);


if((ex26645 instanceof Error)){
var statearr_26651_26669 = state_26633__$1;
(statearr_26651_26669[(1)] = (4));

(statearr_26651_26669[(5)] = null);

} else {
throw ex26645;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26634 === (10))){
var inst_26609 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_26610 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_26611 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_26612 = cljs.core.PersistentHashMap.fromArrays(inst_26610,inst_26611);
var inst_26613 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26609,inst_26612);
var inst_26614 = (function(){throw inst_26613})();
var state_26633__$1 = state_26633;
var statearr_26652_26670 = state_26633__$1;
(statearr_26652_26670[(2)] = inst_26614);

(statearr_26652_26670[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26634 === (8))){
var inst_26602 = (state_26633[(8)]);
var state_26633__$1 = state_26633;
var statearr_26653_26671 = state_26633__$1;
(statearr_26653_26671[(2)] = inst_26602);

(statearr_26653_26671[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2717__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2717__auto____0 = (function (){
var statearr_26654 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26654[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2717__auto__);

(statearr_26654[(1)] = (1));

return statearr_26654;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2717__auto____1 = (function (state_26633){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_26633);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e26655){var ex__2720__auto__ = e26655;
var statearr_26656_26672 = state_26633;
(statearr_26656_26672[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_26633[(4)]))){
var statearr_26657_26673 = state_26633;
(statearr_26657_26673[(1)] = cljs.core.first((state_26633[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26674 = state_26633;
state_26633 = G__26674;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2717__auto__ = function(state_26633){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2717__auto____1.call(this,state_26633);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2717__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2717__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_26658 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_26658[(6)] = c__2739__auto__);

return statearr_26658;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__26679 = arguments.length;
switch (G__26679) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_26875){
var state_val_26876 = (state_26875[(1)]);
if((state_val_26876 === (7))){
var state_26875__$1 = state_26875;
var statearr_26877_26945 = state_26875__$1;
(statearr_26877_26945[(2)] = null);

(statearr_26877_26945[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26876 === (20))){
var inst_26717 = (state_26875[(7)]);
var inst_26797 = (state_26875[(8)]);
var inst_26800 = (state_26875[(9)]);
var inst_26768 = (state_26875[(10)]);
var inst_26799 = (state_26875[(11)]);
var inst_26798 = (state_26875[(12)]);
var inst_26801 = (state_26875[(13)]);
var inst_26718 = (state_26875[(14)]);
var inst_26811 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26812 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26813 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26814 = (new cljs.core.PersistentVector(null,2,(5),inst_26812,inst_26813,null));
var inst_26815 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26768,inst_26814);
var inst_26816 = (inst_26717 + inst_26815);
var inst_26817 = [inst_26797,inst_26798,inst_26799,inst_26800,inst_26816];
var inst_26818 = cljs.core.PersistentHashMap.fromArrays(inst_26811,inst_26817);
var inst_26819 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_26768,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_26801,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_26818], 0));
var state_26875__$1 = (function (){var statearr_26878 = state_26875;
(statearr_26878[(15)] = inst_26819);

return statearr_26878;
})();
if(cljs.core.truth_(inst_26718)){
var statearr_26879_26946 = state_26875__$1;
(statearr_26879_26946[(1)] = (23));

} else {
var statearr_26880_26947 = state_26875__$1;
(statearr_26880_26947[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26876 === (27))){
var inst_26819 = (state_26875[(15)]);
var state_26875__$1 = state_26875;
var statearr_26881_26948 = state_26875__$1;
(statearr_26881_26948[(2)] = inst_26819);

(statearr_26881_26948[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26876 === (1))){
var state_26875__$1 = state_26875;
var statearr_26882_26949 = state_26875__$1;
(statearr_26882_26949[(2)] = null);

(statearr_26882_26949[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26876 === (24))){
var inst_26819 = (state_26875[(15)]);
var inst_26822 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_26819);
var inst_26823 = (inst_26822 == null);
var state_26875__$1 = state_26875;
var statearr_26883_26950 = state_26875__$1;
(statearr_26883_26950[(2)] = inst_26823);

(statearr_26883_26950[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26876 === (39))){
var inst_26849 = (state_26875[(16)]);
var inst_26850 = (state_26875[(17)]);
var inst_26858 = (state_26875[(18)]);
var inst_26851 = (state_26875[(19)]);
var inst_26808 = (state_26875[(20)]);
var inst_26865 = (state_26875[(2)]);
var inst_26796 = inst_26808;
var inst_26797 = inst_26850;
var inst_26798 = inst_26851;
var inst_26799 = inst_26858;
var inst_26800 = inst_26865;
var inst_26801 = inst_26849;
var state_26875__$1 = (function (){var statearr_26884 = state_26875;
(statearr_26884[(8)] = inst_26797);

(statearr_26884[(9)] = inst_26800);

(statearr_26884[(21)] = inst_26796);

(statearr_26884[(11)] = inst_26799);

(statearr_26884[(12)] = inst_26798);

(statearr_26884[(13)] = inst_26801);

return statearr_26884;
})();
var statearr_26885_26951 = state_26875__$1;
(statearr_26885_26951[(2)] = null);

(statearr_26885_26951[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26876 === (4))){
var inst_26680 = (state_26875[(2)]);
var state_26875__$1 = state_26875;
var statearr_26886_26952 = state_26875__$1;
(statearr_26886_26952[(2)] = inst_26680);

(statearr_26886_26952[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26876 === (15))){
var inst_26740 = (state_26875[(22)]);
var state_26875__$1 = state_26875;
var statearr_26887_26953 = state_26875__$1;
(statearr_26887_26953[(2)] = inst_26740);

(statearr_26887_26953[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26876 === (21))){
var inst_26717 = (state_26875[(7)]);
var inst_26712 = (state_26875[(23)]);
var inst_26797 = (state_26875[(8)]);
var inst_26800 = (state_26875[(9)]);
var inst_26807 = (state_26875[(24)]);
var inst_26768 = (state_26875[(10)]);
var inst_26708 = (state_26875[(25)]);
var inst_26796 = (state_26875[(21)]);
var inst_26702 = (state_26875[(26)]);
var inst_26727 = (state_26875[(27)]);
var inst_26799 = (state_26875[(11)]);
var inst_26716 = (state_26875[(28)]);
var inst_26719 = (state_26875[(29)]);
var inst_26721 = (state_26875[(30)]);
var inst_26798 = (state_26875[(12)]);
var inst_26687 = (state_26875[(31)]);
var inst_26778 = (state_26875[(32)]);
var inst_26777 = (state_26875[(33)]);
var inst_26808 = (state_26875[(20)]);
var inst_26801 = (state_26875[(13)]);
var inst_26718 = (state_26875[(14)]);
var inst_26704 = (state_26875[(34)]);
var inst_26846 = inst_26807.s;
var inst_26847 = fluree.db.flake.sid__GT_cid(inst_26846);
var inst_26848 = (function (){var flakes_bytes = inst_26717;
var t = inst_26687;
var spot = inst_26797;
var add_flakes = inst_26704;
var root_setting_change_QMARK_ = inst_26719;
var vec__26803 = inst_26796;
var ref_QMARK__map = inst_26716;
var seq__26774 = inst_26778;
var r = inst_26808;
var psot = inst_26798;
var add_pred_to_idx_QMARK_ = inst_26727;
var _ = inst_26702;
var vec__26773 = inst_26704;
var cid = inst_26847;
var ecount = inst_26801;
var first__26805 = inst_26807;
var pred_ecount = inst_26721;
var seq__26804 = inst_26808;
var G__26772 = inst_26796;
var db_STAR_ = inst_26768;
var schema_change_QMARK_ = inst_26718;
var add_preds = inst_26708;
var opst = inst_26800;
var first__26775 = inst_26777;
var idx_QMARK__map = inst_26712;
var post = inst_26799;
var f = inst_26807;
return (function (p1__26677_SHARP_){
if(cljs.core.truth_(p1__26677_SHARP_)){
var x__4295__auto__ = p1__26677_SHARP_;
var y__4296__auto__ = f.s;
return ((x__4295__auto__ > y__4296__auto__) ? x__4295__auto__ : y__4296__auto__);
} else {
return f.s;
}
});
})();
var inst_26849 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_26801,inst_26847,inst_26848);
var inst_26850 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26797,inst_26807);
var inst_26851 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26798,inst_26807);
var inst_26852 = inst_26807.p;
var inst_26853 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26712,inst_26852);
var state_26875__$1 = (function (){var statearr_26888 = state_26875;
(statearr_26888[(16)] = inst_26849);

(statearr_26888[(17)] = inst_26850);

(statearr_26888[(19)] = inst_26851);

return statearr_26888;
})();
if(cljs.core.truth_(inst_26853)){
var statearr_26889_26954 = state_26875__$1;
(statearr_26889_26954[(1)] = (34));

} else {
var statearr_26890_26955 = state_26875__$1;
(statearr_26890_26955[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26876 === (31))){
var inst_26834 = (state_26875[(35)]);
var state_26875__$1 = state_26875;
var statearr_26891_26956 = state_26875__$1;
(statearr_26891_26956[(2)] = inst_26834);

(statearr_26891_26956[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26876 === (32))){
var inst_26844 = (state_26875[(2)]);
var state_26875__$1 = state_26875;
var statearr_26892_26957 = state_26875__$1;
(statearr_26892_26957[(2)] = inst_26844);

(statearr_26892_26957[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26876 === (33))){
var inst_26834 = (state_26875[(35)]);
var inst_26839 = (state_26875[(2)]);
var inst_26840 = fluree.db.util.async.throw_err(inst_26839);
var inst_26841 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26834,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_26840);
var state_26875__$1 = state_26875;
var statearr_26893_26958 = state_26875__$1;
(statearr_26893_26958[(2)] = inst_26841);

(statearr_26893_26958[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26876 === (13))){
var inst_26717 = (state_26875[(7)]);
var inst_26768 = (state_26875[(10)]);
var inst_26687 = (state_26875[(31)]);
var inst_26704 = (state_26875[(34)]);
var inst_26758 = (state_26875[(2)]);
var inst_26759 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26758,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26687);
var inst_26760 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26761 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26762 = (new cljs.core.PersistentVector(null,2,(5),inst_26760,inst_26761,null));
var inst_26763 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_26759,inst_26762,cljs.core._PLUS_,inst_26717);
var inst_26764 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26765 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_26766 = (new cljs.core.PersistentVector(null,2,(5),inst_26764,inst_26765,null));
var inst_26767 = cljs.core.count(inst_26704);
var inst_26768__$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_26763,inst_26766,cljs.core._PLUS_,inst_26767);
var inst_26776 = cljs.core.seq(inst_26704);
var inst_26777 = cljs.core.first(inst_26776);
var inst_26778 = cljs.core.next(inst_26776);
var inst_26779 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26780 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_26781 = (new cljs.core.PersistentVector(null,2,(5),inst_26779,inst_26780,null));
var inst_26782 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26768__$1,inst_26781);
var inst_26783 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26784 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_26785 = (new cljs.core.PersistentVector(null,2,(5),inst_26783,inst_26784,null));
var inst_26786 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26768__$1,inst_26785);
var inst_26787 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26788 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_26789 = (new cljs.core.PersistentVector(null,2,(5),inst_26787,inst_26788,null));
var inst_26790 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26768__$1,inst_26789);
var inst_26791 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26792 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_26793 = (new cljs.core.PersistentVector(null,2,(5),inst_26791,inst_26792,null));
var inst_26794 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26768__$1,inst_26793);
var inst_26795 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_26796 = inst_26704;
var inst_26797 = inst_26782;
var inst_26798 = inst_26786;
var inst_26799 = inst_26790;
var inst_26800 = inst_26794;
var inst_26801 = inst_26795;
var state_26875__$1 = (function (){var statearr_26894 = state_26875;
(statearr_26894[(8)] = inst_26797);

(statearr_26894[(9)] = inst_26800);

(statearr_26894[(10)] = inst_26768__$1);

(statearr_26894[(21)] = inst_26796);

(statearr_26894[(11)] = inst_26799);

(statearr_26894[(12)] = inst_26798);

(statearr_26894[(32)] = inst_26778);

(statearr_26894[(33)] = inst_26777);

(statearr_26894[(13)] = inst_26801);

return statearr_26894;
})();
var statearr_26895_26959 = state_26875__$1;
(statearr_26895_26959[(2)] = null);

(statearr_26895_26959[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26876 === (22))){
var inst_26868 = (state_26875[(2)]);
var state_26875__$1 = state_26875;
var statearr_26896_26960 = state_26875__$1;
(statearr_26896_26960[(2)] = inst_26868);

(statearr_26896_26960[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26876 === (36))){
var inst_26807 = (state_26875[(24)]);
var inst_26716 = (state_26875[(28)]);
var inst_26858 = (state_26875[(2)]);
var inst_26859 = inst_26807.p;
var inst_26860 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26716,inst_26859);
var state_26875__$1 = (function (){var statearr_26897 = state_26875;
(statearr_26897[(18)] = inst_26858);

return statearr_26897;
})();
if(cljs.core.truth_(inst_26860)){
var statearr_26898_26961 = state_26875__$1;
(statearr_26898_26961[(1)] = (37));

} else {
var statearr_26899_26962 = state_26875__$1;
(statearr_26899_26962[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26876 === (29))){
var inst_26819 = (state_26875[(15)]);
var inst_26829 = (state_26875[(2)]);
var inst_26830 = fluree.db.util.async.throw_err(inst_26829);
var inst_26831 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26819,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_26830);
var state_26875__$1 = state_26875;
var statearr_26900_26963 = state_26875__$1;
(statearr_26900_26963[(2)] = inst_26831);

(statearr_26900_26963[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26876 === (6))){
var inst_26687 = (state_26875[(31)]);
var inst_26692 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_26693 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_26694 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26692)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26693)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26687),"."].join('');
var inst_26695 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26696 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_26697 = cljs.core.PersistentHashMap.fromArrays(inst_26695,inst_26696);
var inst_26698 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26694,inst_26697);
var inst_26699 = (function(){throw inst_26698})();
var state_26875__$1 = state_26875;
var statearr_26901_26964 = state_26875__$1;
(statearr_26901_26964[(2)] = inst_26699);

(statearr_26901_26964[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26876 === (28))){
var inst_26719 = (state_26875[(29)]);
var inst_26834 = (state_26875[(2)]);
var state_26875__$1 = (function (){var statearr_26902 = state_26875;
(statearr_26902[(35)] = inst_26834);

return statearr_26902;
})();
if(cljs.core.truth_(inst_26719)){
var statearr_26903_26965 = state_26875__$1;
(statearr_26903_26965[(1)] = (30));

} else {
var statearr_26904_26966 = state_26875__$1;
(statearr_26904_26966[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26876 === (25))){
var inst_26825 = (state_26875[(2)]);
var state_26875__$1 = state_26875;
if(cljs.core.truth_(inst_26825)){
var statearr_26905_26967 = state_26875__$1;
(statearr_26905_26967[(1)] = (26));

} else {
var statearr_26906_26968 = state_26875__$1;
(statearr_26906_26968[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26876 === (34))){
var inst_26807 = (state_26875[(24)]);
var inst_26799 = (state_26875[(11)]);
var inst_26855 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26799,inst_26807);
var state_26875__$1 = state_26875;
var statearr_26907_26969 = state_26875__$1;
(statearr_26907_26969[(2)] = inst_26855);

(statearr_26907_26969[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26876 === (17))){
var inst_26747 = (state_26875[(36)]);
var inst_26751 = (state_26875[(2)]);
var inst_26752 = fluree.db.util.async.throw_err(inst_26751);
var inst_26739 = inst_26747;
var inst_26740 = inst_26752;
var state_26875__$1 = (function (){var statearr_26908 = state_26875;
(statearr_26908[(22)] = inst_26740);

(statearr_26908[(37)] = inst_26739);

return statearr_26908;
})();
var statearr_26909_26970 = state_26875__$1;
(statearr_26909_26970[(2)] = null);

(statearr_26909_26970[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26876 === (3))){
var inst_26873 = (state_26875[(2)]);
var state_26875__$1 = state_26875;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26875__$1,inst_26873);
} else {
if((state_val_26876 === (12))){
var inst_26739 = (state_26875[(37)]);
var inst_26746 = (state_26875[(38)]);
var inst_26745 = cljs.core.seq(inst_26739);
var inst_26746__$1 = cljs.core.first(inst_26745);
var inst_26747 = cljs.core.next(inst_26745);
var state_26875__$1 = (function (){var statearr_26910 = state_26875;
(statearr_26910[(36)] = inst_26747);

(statearr_26910[(38)] = inst_26746__$1);

return statearr_26910;
})();
if(cljs.core.truth_(inst_26746__$1)){
var statearr_26911_26971 = state_26875__$1;
(statearr_26911_26971[(1)] = (14));

} else {
var statearr_26912_26972 = state_26875__$1;
(statearr_26912_26972[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26876 === (2))){
var inst_26687 = (state_26875[(31)]);
var _ = (function (){var statearr_26913 = state_26875;
(statearr_26913[(4)] = cljs.core.cons((5),(state_26875[(4)])));

return statearr_26913;
})();
var inst_26686 = cljs.core.first(flakes);
var inst_26687__$1 = inst_26686.t;
var inst_26688 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_26689 = (inst_26688 - (1));
var inst_26690 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_26687__$1,inst_26689);
var state_26875__$1 = (function (){var statearr_26914 = state_26875;
(statearr_26914[(31)] = inst_26687__$1);

return statearr_26914;
})();
if(inst_26690){
var statearr_26915_26973 = state_26875__$1;
(statearr_26915_26973[(1)] = (6));

} else {
var statearr_26916_26974 = state_26875__$1;
(statearr_26916_26974[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26876 === (23))){
var inst_26718 = (state_26875[(14)]);
var state_26875__$1 = state_26875;
var statearr_26917_26975 = state_26875__$1;
(statearr_26917_26975[(2)] = inst_26718);

(statearr_26917_26975[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26876 === (35))){
var inst_26799 = (state_26875[(11)]);
var state_26875__$1 = state_26875;
var statearr_26918_26976 = state_26875__$1;
(statearr_26918_26976[(2)] = inst_26799);

(statearr_26918_26976[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26876 === (19))){
var inst_26870 = (state_26875[(2)]);
var _ = (function (){var statearr_26919 = state_26875;
(statearr_26919[(4)] = cljs.core.rest((state_26875[(4)])));

return statearr_26919;
})();
var state_26875__$1 = state_26875;
var statearr_26920_26977 = state_26875__$1;
(statearr_26920_26977[(2)] = inst_26870);

(statearr_26920_26977[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26876 === (11))){
var inst_26727 = (state_26875[(27)]);
var inst_26727__$1 = (state_26875[(2)]);
var inst_26735 = cljs.core.seq(inst_26727__$1);
var inst_26736 = cljs.core.first(inst_26735);
var inst_26737 = cljs.core.next(inst_26735);
var inst_26738 = db;
var inst_26739 = inst_26727__$1;
var inst_26740 = inst_26738;
var state_26875__$1 = (function (){var statearr_26922 = state_26875;
(statearr_26922[(39)] = inst_26737);

(statearr_26922[(27)] = inst_26727__$1);

(statearr_26922[(22)] = inst_26740);

(statearr_26922[(37)] = inst_26739);

(statearr_26922[(40)] = inst_26736);

return statearr_26922;
})();
var statearr_26923_26978 = state_26875__$1;
(statearr_26923_26978[(2)] = null);

(statearr_26923_26978[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26876 === (9))){
var inst_26721 = (state_26875[(30)]);
var inst_26704 = (state_26875[(34)]);
var inst_26723 = fluree.db.util.schema.add_to_post_preds_QMARK_(inst_26704,inst_26721);
var state_26875__$1 = state_26875;
var statearr_26924_26979 = state_26875__$1;
(statearr_26924_26979[(2)] = inst_26723);

(statearr_26924_26979[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26876 === (5))){
var _ = (function (){var statearr_26925 = state_26875;
(statearr_26925[(4)] = cljs.core.rest((state_26875[(4)])));

return statearr_26925;
})();
var state_26875__$1 = state_26875;
var ex26921 = (state_26875__$1[(2)]);
var statearr_26926_26980 = state_26875__$1;
(statearr_26926_26980[(5)] = ex26921);


if((ex26921 instanceof Error)){
var statearr_26927_26981 = state_26875__$1;
(statearr_26927_26981[(1)] = (4));

(statearr_26927_26981[(5)] = null);

} else {
throw ex26921;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26876 === (14))){
var inst_26740 = (state_26875[(22)]);
var inst_26746 = (state_26875[(38)]);
var inst_26749 = fluree.db.graphdb.add_predicate_to_idx(inst_26740,inst_26746,opts);
var state_26875__$1 = state_26875;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26875__$1,(17),inst_26749);
} else {
if((state_val_26876 === (26))){
var inst_26819 = (state_26875[(15)]);
var inst_26827 = fluree.db.query.schema.schema_map(inst_26819);
var state_26875__$1 = state_26875;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26875__$1,(29),inst_26827);
} else {
if((state_val_26876 === (16))){
var inst_26756 = (state_26875[(2)]);
var state_26875__$1 = state_26875;
var statearr_26928_26982 = state_26875__$1;
(statearr_26928_26982[(2)] = inst_26756);

(statearr_26928_26982[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26876 === (38))){
var inst_26800 = (state_26875[(9)]);
var state_26875__$1 = state_26875;
var statearr_26929_26983 = state_26875__$1;
(statearr_26929_26983[(2)] = inst_26800);

(statearr_26929_26983[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26876 === (30))){
var inst_26834 = (state_26875[(35)]);
var inst_26837 = fluree.db.query.schema.setting_map(inst_26834);
var state_26875__$1 = state_26875;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26875__$1,(33),inst_26837);
} else {
if((state_val_26876 === (10))){
var inst_26725 = cljs.core.PersistentVector.EMPTY;
var state_26875__$1 = state_26875;
var statearr_26930_26984 = state_26875__$1;
(statearr_26930_26984[(2)] = inst_26725);

(statearr_26930_26984[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26876 === (18))){
var inst_26807 = (state_26875[(24)]);
var inst_26796 = (state_26875[(21)]);
var inst_26806 = cljs.core.seq(inst_26796);
var inst_26807__$1 = cljs.core.first(inst_26806);
var inst_26808 = cljs.core.next(inst_26806);
var inst_26809 = cljs.core.not(inst_26807__$1);
var state_26875__$1 = (function (){var statearr_26931 = state_26875;
(statearr_26931[(24)] = inst_26807__$1);

(statearr_26931[(20)] = inst_26808);

return statearr_26931;
})();
if(inst_26809){
var statearr_26932_26985 = state_26875__$1;
(statearr_26932_26985[(1)] = (20));

} else {
var statearr_26933_26986 = state_26875__$1;
(statearr_26933_26986[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26876 === (37))){
var inst_26800 = (state_26875[(9)]);
var inst_26807 = (state_26875[(24)]);
var inst_26862 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26800,inst_26807);
var state_26875__$1 = state_26875;
var statearr_26934_26987 = state_26875__$1;
(statearr_26934_26987[(2)] = inst_26862);

(statearr_26934_26987[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26876 === (8))){
var inst_26712 = (state_26875[(23)]);
var inst_26708 = (state_26875[(25)]);
var inst_26702 = (state_26875[(26)]);
var inst_26687 = (state_26875[(31)]);
var inst_26718 = (state_26875[(14)]);
var inst_26704 = (state_26875[(34)]);
var inst_26702__$1 = (state_26875[(2)]);
var inst_26703 = (function (){var t = inst_26687;
var _ = inst_26702__$1;
return (function (p1__26675_SHARP_){
return cljs.core.not((function (){var G__26935 = p1__26675_SHARP_.p;
return (fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1(G__26935) : fluree.db.graphdb.exclude_predicates.call(null,G__26935));
})());
});
})();
var inst_26704__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_26703,flakes);
var inst_26705 = cljs.core.PersistentHashSet.EMPTY;
var inst_26706 = (function (){var t = inst_26687;
var _ = inst_26702__$1;
var add_flakes = inst_26704__$1;
return (function (p1__26676_SHARP_){
return p1__26676_SHARP_.p;
});
})();
var inst_26707 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_26706,inst_26704__$1);
var inst_26708__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26705,inst_26707);
var inst_26709 = cljs.core.PersistentHashMap.EMPTY;
var inst_26710 = (function (){var t = inst_26687;
var _ = inst_26702__$1;
var add_flakes = inst_26704__$1;
var add_preds = inst_26708__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_26711 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_26710,inst_26708__$1);
var inst_26712__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26709,inst_26711);
var inst_26713 = cljs.core.PersistentHashMap.EMPTY;
var inst_26714 = (function (){var t = inst_26687;
var _ = inst_26702__$1;
var add_flakes = inst_26704__$1;
var add_preds = inst_26708__$1;
var idx_QMARK__map = inst_26712__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_26715 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_26714,inst_26708__$1);
var inst_26716 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26713,inst_26715);
var inst_26717 = fluree.db.flake.size_bytes(inst_26704__$1);
var inst_26718__$1 = fluree.db.util.schema.schema_change_QMARK_(inst_26704__$1);
var inst_26719 = fluree.db.util.schema.setting_change_QMARK_(inst_26704__$1);
var inst_26720 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_26721 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26720,(0));
var state_26875__$1 = (function (){var statearr_26936 = state_26875;
(statearr_26936[(7)] = inst_26717);

(statearr_26936[(23)] = inst_26712__$1);

(statearr_26936[(25)] = inst_26708__$1);

(statearr_26936[(26)] = inst_26702__$1);

(statearr_26936[(28)] = inst_26716);

(statearr_26936[(29)] = inst_26719);

(statearr_26936[(30)] = inst_26721);

(statearr_26936[(14)] = inst_26718__$1);

(statearr_26936[(34)] = inst_26704__$1);

return statearr_26936;
})();
if(cljs.core.truth_(inst_26718__$1)){
var statearr_26937_26988 = state_26875__$1;
(statearr_26937_26988[(1)] = (9));

} else {
var statearr_26938_26989 = state_26875__$1;
(statearr_26938_26989[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2717__auto__ = null;
var fluree$db$graphdb$state_machine__2717__auto____0 = (function (){
var statearr_26939 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26939[(0)] = fluree$db$graphdb$state_machine__2717__auto__);

(statearr_26939[(1)] = (1));

return statearr_26939;
});
var fluree$db$graphdb$state_machine__2717__auto____1 = (function (state_26875){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_26875);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e26940){var ex__2720__auto__ = e26940;
var statearr_26941_26990 = state_26875;
(statearr_26941_26990[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_26875[(4)]))){
var statearr_26942_26991 = state_26875;
(statearr_26942_26991[(1)] = cljs.core.first((state_26875[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26992 = state_26875;
state_26875 = G__26992;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2717__auto__ = function(state_26875){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2717__auto____1.call(this,state_26875);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2717__auto____0;
fluree$db$graphdb$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2717__auto____1;
return fluree$db$graphdb$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_26943 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_26943[(6)] = c__2739__auto__);

return statearr_26943;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__26994 = arguments.length;
switch (G__26994) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2739__auto___27141 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_27090){
var state_val_27091 = (state_27090[(1)]);
if((state_val_27091 === (7))){
var state_27090__$1 = state_27090;
var statearr_27092_27142 = state_27090__$1;
(statearr_27092_27142[(2)] = null);

(statearr_27092_27142[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27091 === (20))){
var inst_27039 = (state_27090[(7)]);
var inst_27038 = (state_27090[(8)]);
var inst_27040 = (state_27090[(9)]);
var inst_27059 = (inst_27038 + (1));
var inst_27060 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27040,new cljs.core.Keyword(null,"t","t",-1397832519),inst_27059);
var inst_27061 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(inst_27060,inst_27039,opts);
var state_27090__$1 = state_27090;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27090__$1,(23),inst_27061);
} else {
if((state_val_27091 === (1))){
var state_27090__$1 = state_27090;
var statearr_27093_27143 = state_27090__$1;
(statearr_27093_27143[(2)] = null);

(statearr_27093_27143[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27091 === (24))){
var inst_27064 = (state_27090[(10)]);
var inst_27067 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27064,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_27090__$1 = state_27090;
var statearr_27094_27144 = state_27090__$1;
(statearr_27094_27144[(2)] = inst_27067);

(statearr_27094_27144[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27091 === (4))){
var inst_26995 = (state_27090[(2)]);
var inst_26996 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_26995);
var state_27090__$1 = state_27090;
var statearr_27095_27145 = state_27090__$1;
(statearr_27095_27145[(2)] = inst_26996);

(statearr_27095_27145[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27091 === (15))){
var inst_27046 = (state_27090[(11)]);
var state_27090__$1 = state_27090;
var statearr_27096_27146 = state_27090__$1;
(statearr_27096_27146[(2)] = inst_27046);

(statearr_27096_27146[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27091 === (21))){
var state_27090__$1 = state_27090;
var statearr_27097_27147 = state_27090__$1;
(statearr_27097_27147[(2)] = null);

(statearr_27097_27147[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27091 === (13))){
var inst_27082 = (state_27090[(2)]);
var inst_27083 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_27082);
var state_27090__$1 = state_27090;
var statearr_27098_27148 = state_27090__$1;
(statearr_27098_27148[(2)] = inst_27083);

(statearr_27098_27148[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27091 === (22))){
var inst_27078 = (state_27090[(2)]);
var state_27090__$1 = state_27090;
var statearr_27099_27149 = state_27090__$1;
(statearr_27099_27149[(2)] = inst_27078);

(statearr_27099_27149[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27091 === (6))){
var inst_27006 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_27007 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_27008 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27006)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27007)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_27009 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27010 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_27011 = cljs.core.PersistentHashMap.fromArrays(inst_27009,inst_27010);
var inst_27012 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27008,inst_27011);
var inst_27013 = (function(){throw inst_27012})();
var state_27090__$1 = state_27090;
var statearr_27102_27150 = state_27090__$1;
(statearr_27102_27150[(2)] = inst_27013);

(statearr_27102_27150[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27091 === (25))){
var inst_27064 = (state_27090[(10)]);
var inst_27046 = (state_27090[(11)]);
var inst_27047 = (state_27090[(12)]);
var inst_27069 = inst_27046.t;
var inst_27070 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27071 = [inst_27046];
var inst_27072 = (new cljs.core.PersistentVector(null,1,(5),inst_27070,inst_27071,null));
var inst_27037 = inst_27047;
var inst_27038 = inst_27069;
var inst_27039 = inst_27072;
var inst_27040 = inst_27064;
var state_27090__$1 = (function (){var statearr_27103 = state_27090;
(statearr_27103[(13)] = inst_27037);

(statearr_27103[(7)] = inst_27039);

(statearr_27103[(8)] = inst_27038);

(statearr_27103[(9)] = inst_27040);

return statearr_27103;
})();
var statearr_27104_27151 = state_27090__$1;
(statearr_27104_27151[(2)] = null);

(statearr_27104_27151[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27091 === (17))){
var inst_27039 = (state_27090[(7)]);
var inst_27038 = (state_27090[(8)]);
var inst_27046 = (state_27090[(11)]);
var inst_27047 = (state_27090[(12)]);
var inst_27040 = (state_27090[(9)]);
var inst_27055 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_27039,inst_27046);
var tmp27100 = inst_27038;
var tmp27101 = inst_27040;
var inst_27037 = inst_27047;
var inst_27038__$1 = tmp27100;
var inst_27039__$1 = inst_27055;
var inst_27040__$1 = tmp27101;
var state_27090__$1 = (function (){var statearr_27105 = state_27090;
(statearr_27105[(13)] = inst_27037);

(statearr_27105[(7)] = inst_27039__$1);

(statearr_27105[(8)] = inst_27038__$1);

(statearr_27105[(9)] = inst_27040__$1);

return statearr_27105;
})();
var statearr_27106_27152 = state_27090__$1;
(statearr_27106_27152[(2)] = null);

(statearr_27106_27152[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27091 === (3))){
var inst_27088 = (state_27090[(2)]);
var state_27090__$1 = state_27090;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27090__$1,inst_27088);
} else {
if((state_val_27091 === (12))){
var inst_27037 = (state_27090[(13)]);
var inst_27046 = (state_27090[(11)]);
var inst_27045 = cljs.core.seq(inst_27037);
var inst_27046__$1 = cljs.core.first(inst_27045);
var inst_27047 = cljs.core.next(inst_27045);
var state_27090__$1 = (function (){var statearr_27107 = state_27090;
(statearr_27107[(11)] = inst_27046__$1);

(statearr_27107[(12)] = inst_27047);

return statearr_27107;
})();
if(cljs.core.truth_(inst_27046__$1)){
var statearr_27108_27153 = state_27090__$1;
(statearr_27108_27153[(1)] = (14));

} else {
var statearr_27109_27154 = state_27090__$1;
(statearr_27109_27154[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27091 === (2))){
var _ = (function (){var statearr_27110 = state_27090;
(statearr_27110[(4)] = cljs.core.cons((5),(state_27090[(4)])));

return statearr_27110;
})();
var inst_27002 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_27003 = (inst_27002 + (1));
var inst_27004 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_27003);
var state_27090__$1 = state_27090;
if(inst_27004){
var statearr_27111_27155 = state_27090__$1;
(statearr_27111_27155[(1)] = (6));

} else {
var statearr_27112_27156 = state_27090__$1;
(statearr_27112_27156[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27091 === (23))){
var inst_27046 = (state_27090[(11)]);
var inst_27063 = (state_27090[(2)]);
var inst_27064 = fluree.db.util.async.throw_err(inst_27063);
var inst_27065 = (inst_27046 == null);
var state_27090__$1 = (function (){var statearr_27113 = state_27090;
(statearr_27113[(10)] = inst_27064);

return statearr_27113;
})();
if(cljs.core.truth_(inst_27065)){
var statearr_27114_27157 = state_27090__$1;
(statearr_27114_27157[(1)] = (24));

} else {
var statearr_27115_27158 = state_27090__$1;
(statearr_27115_27158[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27091 === (19))){
var inst_27080 = (state_27090[(2)]);
var state_27090__$1 = state_27090;
var statearr_27116_27159 = state_27090__$1;
(statearr_27116_27159[(2)] = inst_27080);

(statearr_27116_27159[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27091 === (11))){
var inst_27085 = (state_27090[(2)]);
var _ = (function (){var statearr_27118 = state_27090;
(statearr_27118[(4)] = cljs.core.rest((state_27090[(4)])));

return statearr_27118;
})();
var state_27090__$1 = state_27090;
var statearr_27119_27160 = state_27090__$1;
(statearr_27119_27160[(2)] = inst_27085);

(statearr_27119_27160[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27091 === (9))){
var inst_27019 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_27020 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_27019);
var state_27090__$1 = state_27090;
var statearr_27120_27161 = state_27090__$1;
(statearr_27120_27161[(2)] = inst_27020);

(statearr_27120_27161[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27091 === (5))){
var _ = (function (){var statearr_27121 = state_27090;
(statearr_27121[(4)] = cljs.core.rest((state_27090[(4)])));

return statearr_27121;
})();
var state_27090__$1 = state_27090;
var ex27117 = (state_27090__$1[(2)]);
var statearr_27122_27162 = state_27090__$1;
(statearr_27122_27162[(5)] = ex27117);


var statearr_27123_27163 = state_27090__$1;
(statearr_27123_27163[(1)] = (4));

(statearr_27123_27163[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27091 === (14))){
var inst_27038 = (state_27090[(8)]);
var inst_27046 = (state_27090[(11)]);
var inst_27049 = inst_27046.t;
var inst_27050 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_27038,inst_27049);
var state_27090__$1 = state_27090;
var statearr_27124_27164 = state_27090__$1;
(statearr_27124_27164[(2)] = inst_27050);

(statearr_27124_27164[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27091 === (26))){
var inst_27075 = (state_27090[(2)]);
var state_27090__$1 = state_27090;
var statearr_27125_27165 = state_27090__$1;
(statearr_27125_27165[(2)] = inst_27075);

(statearr_27125_27165[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27091 === (16))){
var inst_27053 = (state_27090[(2)]);
var state_27090__$1 = state_27090;
if(cljs.core.truth_(inst_27053)){
var statearr_27126_27166 = state_27090__$1;
(statearr_27126_27166[(1)] = (17));

} else {
var statearr_27127_27167 = state_27090__$1;
(statearr_27127_27167[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27091 === (10))){
var inst_27022 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_block,flakes);
var inst_27023 = cljs.core.first(inst_27022);
var inst_27031 = cljs.core.seq(inst_27022);
var inst_27032 = cljs.core.first(inst_27031);
var inst_27033 = cljs.core.next(inst_27031);
var inst_27034 = inst_27023.t;
var inst_27035 = cljs.core.PersistentVector.EMPTY;
var inst_27036 = db;
var inst_27037 = inst_27022;
var inst_27038 = inst_27034;
var inst_27039 = inst_27035;
var inst_27040 = inst_27036;
var state_27090__$1 = (function (){var statearr_27128 = state_27090;
(statearr_27128[(14)] = inst_27032);

(statearr_27128[(13)] = inst_27037);

(statearr_27128[(7)] = inst_27039);

(statearr_27128[(8)] = inst_27038);

(statearr_27128[(9)] = inst_27040);

(statearr_27128[(15)] = inst_27033);

return statearr_27128;
})();
var statearr_27129_27168 = state_27090__$1;
(statearr_27129_27168[(2)] = null);

(statearr_27129_27168[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27091 === (18))){
var state_27090__$1 = state_27090;
var statearr_27130_27169 = state_27090__$1;
(statearr_27130_27169[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27091 === (8))){
var inst_27016 = (state_27090[(2)]);
var inst_27017 = cljs.core.empty_QMARK_(flakes);
var state_27090__$1 = (function (){var statearr_27132 = state_27090;
(statearr_27132[(16)] = inst_27016);

return statearr_27132;
})();
if(inst_27017){
var statearr_27133_27170 = state_27090__$1;
(statearr_27133_27170[(1)] = (9));

} else {
var statearr_27134_27171 = state_27090__$1;
(statearr_27134_27171[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2717__auto__ = null;
var fluree$db$graphdb$state_machine__2717__auto____0 = (function (){
var statearr_27135 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27135[(0)] = fluree$db$graphdb$state_machine__2717__auto__);

(statearr_27135[(1)] = (1));

return statearr_27135;
});
var fluree$db$graphdb$state_machine__2717__auto____1 = (function (state_27090){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_27090);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e27136){var ex__2720__auto__ = e27136;
var statearr_27137_27172 = state_27090;
(statearr_27137_27172[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_27090[(4)]))){
var statearr_27138_27173 = state_27090;
(statearr_27138_27173[(1)] = cljs.core.first((state_27090[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27174 = state_27090;
state_27090 = G__27174;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2717__auto__ = function(state_27090){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2717__auto____1.call(this,state_27090);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2717__auto____0;
fluree$db$graphdb$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2717__auto____1;
return fluree$db$graphdb$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_27139 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_27139[(6)] = c__2739__auto___27141);

return statearr_27139;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_27230){
var state_val_27231 = (state_27230[(1)]);
if((state_val_27231 === (7))){
var state_27230__$1 = state_27230;
var statearr_27232_27259 = state_27230__$1;
(statearr_27232_27259[(2)] = tt_id);

(statearr_27232_27259[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27231 === (1))){
var state_27230__$1 = state_27230;
var statearr_27233_27260 = state_27230__$1;
(statearr_27233_27260[(2)] = null);

(statearr_27233_27260[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27231 === (4))){
var inst_27175 = (state_27230[(2)]);
var state_27230__$1 = state_27230;
var statearr_27234_27261 = state_27230__$1;
(statearr_27234_27261[(2)] = inst_27175);

(statearr_27234_27261[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27231 === (13))){
var inst_27223 = (state_27230[(2)]);
var state_27230__$1 = state_27230;
var statearr_27235_27262 = state_27230__$1;
(statearr_27235_27262[(2)] = inst_27223);

(statearr_27235_27262[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27231 === (6))){
var inst_27183 = fluree.db.util.core.random_uuid();
var state_27230__$1 = state_27230;
var statearr_27236_27263 = state_27230__$1;
(statearr_27236_27263[(2)] = inst_27183);

(statearr_27236_27263[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27231 === (3))){
var inst_27228 = (state_27230[(2)]);
var state_27230__$1 = state_27230;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27230__$1,inst_27228);
} else {
if((state_val_27231 === (12))){
var inst_27206 = (state_27230[(7)]);
var state_27230__$1 = state_27230;
var statearr_27237_27264 = state_27230__$1;
(statearr_27237_27264[(2)] = inst_27206);

(statearr_27237_27264[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27231 === (2))){
var _ = (function (){var statearr_27238 = state_27230;
(statearr_27238[(4)] = cljs.core.cons((5),(state_27230[(4)])));

return statearr_27238;
})();
var inst_27181 = (tt_id == null);
var state_27230__$1 = state_27230;
if(cljs.core.truth_(inst_27181)){
var statearr_27239_27265 = state_27230__$1;
(statearr_27239_27265[(1)] = (6));

} else {
var statearr_27240_27266 = state_27230__$1;
(statearr_27240_27266[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27231 === (11))){
var inst_27213 = (state_27230[(8)]);
var inst_27206 = (state_27230[(7)]);
var inst_27216 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2(inst_27206,inst_27213);
var state_27230__$1 = state_27230;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27230__$1,(14),inst_27216);
} else {
if((state_val_27231 === (9))){
var inst_27213 = (state_27230[(8)]);
var inst_27207 = (state_27230[(9)]);
var inst_27212 = cljs.core.seq(inst_27207);
var inst_27213__$1 = cljs.core.first(inst_27212);
var inst_27214 = cljs.core.next(inst_27212);
var state_27230__$1 = (function (){var statearr_27242 = state_27230;
(statearr_27242[(8)] = inst_27213__$1);

(statearr_27242[(10)] = inst_27214);

return statearr_27242;
})();
if(cljs.core.truth_(inst_27213__$1)){
var statearr_27243_27267 = state_27230__$1;
(statearr_27243_27267[(1)] = (11));

} else {
var statearr_27244_27268 = state_27230__$1;
(statearr_27244_27268[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27231 === (5))){
var _ = (function (){var statearr_27245 = state_27230;
(statearr_27245[(4)] = cljs.core.rest((state_27230[(4)])));

return statearr_27245;
})();
var state_27230__$1 = state_27230;
var ex27241 = (state_27230__$1[(2)]);
var statearr_27246_27269 = state_27230__$1;
(statearr_27246_27269[(5)] = ex27241);


if((ex27241 instanceof Error)){
var statearr_27247_27270 = state_27230__$1;
(statearr_27247_27270[(1)] = (4));

(statearr_27247_27270[(5)] = null);

} else {
throw ex27241;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27231 === (14))){
var inst_27214 = (state_27230[(10)]);
var inst_27218 = (state_27230[(2)]);
var inst_27219 = fluree.db.util.async.throw_err(inst_27218);
var inst_27206 = inst_27219;
var inst_27207 = inst_27214;
var state_27230__$1 = (function (){var statearr_27248 = state_27230;
(statearr_27248[(9)] = inst_27207);

(statearr_27248[(7)] = inst_27206);

return statearr_27248;
})();
var statearr_27249_27271 = state_27230__$1;
(statearr_27249_27271[(2)] = null);

(statearr_27249_27271[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27231 === (10))){
var inst_27225 = (state_27230[(2)]);
var _ = (function (){var statearr_27250 = state_27230;
(statearr_27250[(4)] = cljs.core.rest((state_27230[(4)])));

return statearr_27250;
})();
var state_27230__$1 = state_27230;
var statearr_27251_27272 = state_27230__$1;
(statearr_27251_27272[(2)] = inst_27225);

(statearr_27251_27272[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27231 === (8))){
var inst_27186 = (state_27230[(2)]);
var inst_27187 = (function (){var tt_id_SINGLEQUOTE_ = inst_27186;
return (function (db_STAR_,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db_STAR_,idx,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(db_STAR_,idx),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id_SINGLEQUOTE_));
});
})();
var inst_27188 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_27186);
var inst_27189 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27190 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_27191 = (new cljs.core.PersistentVector(null,4,(5),inst_27189,inst_27190,null));
var inst_27192 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_27187,inst_27188,inst_27191);
var inst_27193 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"t","t",-1397832519),flakes);
var inst_27194 = cljs.core.reverse(inst_27193);
var inst_27195 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"t","t",-1397832519),inst_27194);
var inst_27203 = cljs.core.seq(inst_27195);
var inst_27204 = cljs.core.first(inst_27203);
var inst_27205 = cljs.core.next(inst_27203);
var inst_27206 = inst_27192;
var inst_27207 = inst_27195;
var state_27230__$1 = (function (){var statearr_27252 = state_27230;
(statearr_27252[(9)] = inst_27207);

(statearr_27252[(11)] = inst_27204);

(statearr_27252[(7)] = inst_27206);

(statearr_27252[(12)] = inst_27205);

return statearr_27252;
})();
var statearr_27253_27273 = state_27230__$1;
(statearr_27253_27273[(2)] = null);

(statearr_27253_27273[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__2717__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__2717__auto____0 = (function (){
var statearr_27254 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27254[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__2717__auto__);

(statearr_27254[(1)] = (1));

return statearr_27254;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__2717__auto____1 = (function (state_27230){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_27230);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e27255){var ex__2720__auto__ = e27255;
var statearr_27256_27274 = state_27230;
(statearr_27256_27274[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_27230[(4)]))){
var statearr_27257_27275 = state_27230;
(statearr_27257_27275[(1)] = cljs.core.first((state_27230[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27276 = state_27230;
state_27230 = G__27276;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__2717__auto__ = function(state_27230){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2717__auto____1.call(this,state_27230);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__2717__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__2717__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_27258 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_27258[(6)] = c__2739__auto__);

return statearr_27258;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2739__auto___27463 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_27394){
var state_val_27395 = (state_27394[(1)]);
if((state_val_27395 === (7))){
var inst_27304 = (state_27394[(7)]);
var inst_27304__$1 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_27394__$1 = (function (){var statearr_27396 = state_27394;
(statearr_27396[(7)] = inst_27304__$1);

return statearr_27396;
})();
if(inst_27304__$1){
var statearr_27397_27464 = state_27394__$1;
(statearr_27397_27464[(1)] = (13));

} else {
var statearr_27398_27465 = state_27394__$1;
(statearr_27398_27465[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (20))){
var state_27394__$1 = state_27394;
var statearr_27399_27466 = state_27394__$1;
(statearr_27399_27466[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (27))){
var inst_27340 = (state_27394[(8)]);
var inst_27344 = inst_27340.s;
var state_27394__$1 = state_27394;
var statearr_27401_27467 = state_27394__$1;
(statearr_27401_27467[(2)] = inst_27344);

(statearr_27401_27467[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (1))){
var state_27394__$1 = state_27394;
var statearr_27402_27468 = state_27394__$1;
(statearr_27402_27468[(2)] = null);

(statearr_27402_27468[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (24))){
var inst_27334 = (state_27394[(9)]);
var inst_27338 = cljs.core.first(inst_27334);
var state_27394__$1 = state_27394;
var statearr_27403_27469 = state_27394__$1;
(statearr_27403_27469[(2)] = inst_27338);

(statearr_27403_27469[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (39))){
var state_27394__$1 = state_27394;
var statearr_27404_27470 = state_27394__$1;
(statearr_27404_27470[(1)] = (41));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (4))){
var inst_27277 = (state_27394[(2)]);
var inst_27278 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_27279 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27280 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_27281 = cljs.core.PersistentHashMap.fromArrays(inst_27279,inst_27280);
var inst_27282 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(inst_27278,inst_27281,inst_27277);
var inst_27283 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_27282);
var state_27394__$1 = state_27394;
var statearr_27406_27471 = state_27394__$1;
(statearr_27406_27471[(2)] = inst_27283);

(statearr_27406_27471[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (15))){
var inst_27311 = (state_27394[(2)]);
var state_27394__$1 = state_27394;
if(cljs.core.truth_(inst_27311)){
var statearr_27407_27472 = state_27394__$1;
(statearr_27407_27472[(1)] = (16));

} else {
var statearr_27408_27473 = state_27394__$1;
(statearr_27408_27473[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (21))){
var inst_27360 = (state_27394[(2)]);
var state_27394__$1 = state_27394;
var statearr_27409_27474 = state_27394__$1;
(statearr_27409_27474[(2)] = inst_27360);

(statearr_27409_27474[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (31))){
var inst_27358 = (state_27394[(2)]);
var state_27394__$1 = state_27394;
var statearr_27410_27475 = state_27394__$1;
(statearr_27410_27475[(2)] = inst_27358);

(statearr_27410_27475[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (32))){
var inst_27364 = (state_27394[(10)]);
var inst_27366 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_27364);
var state_27394__$1 = state_27394;
var statearr_27411_27476 = state_27394__$1;
(statearr_27411_27476[(2)] = inst_27366);

(statearr_27411_27476[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (40))){
var inst_27387 = (state_27394[(2)]);
var state_27394__$1 = state_27394;
var statearr_27412_27477 = state_27394__$1;
(statearr_27412_27477[(2)] = inst_27387);

(statearr_27412_27477[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (33))){
var inst_27368 = (state_27394[(11)]);
var inst_27364 = (state_27394[(10)]);
var inst_27368__$1 = (inst_27364 == null);
var state_27394__$1 = (function (){var statearr_27413 = state_27394;
(statearr_27413[(11)] = inst_27368__$1);

return statearr_27413;
})();
if(cljs.core.truth_(inst_27368__$1)){
var statearr_27414_27478 = state_27394__$1;
(statearr_27414_27478[(1)] = (35));

} else {
var statearr_27415_27479 = state_27394__$1;
(statearr_27415_27479[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (13))){
var inst_27306 = cljs.core.first(ident);
var inst_27307 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_27306);
var inst_27308 = (inst_27307 == null);
var state_27394__$1 = state_27394;
var statearr_27416_27480 = state_27394__$1;
(statearr_27416_27480[(2)] = inst_27308);

(statearr_27416_27480[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (22))){
var inst_27334 = (state_27394[(9)]);
var inst_27333 = (state_27394[(2)]);
var inst_27334__$1 = fluree.db.util.async.throw_err(inst_27333);
var inst_27335 = (inst_27334__$1 == null);
var state_27394__$1 = (function (){var statearr_27417 = state_27394;
(statearr_27417[(9)] = inst_27334__$1);

return statearr_27417;
})();
if(cljs.core.truth_(inst_27335)){
var statearr_27418_27481 = state_27394__$1;
(statearr_27418_27481[(1)] = (23));

} else {
var statearr_27419_27482 = state_27394__$1;
(statearr_27419_27482[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (36))){
var inst_27368 = (state_27394[(11)]);
var state_27394__$1 = state_27394;
var statearr_27420_27483 = state_27394__$1;
(statearr_27420_27483[(2)] = inst_27368);

(statearr_27420_27483[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (41))){
var inst_27382 = cljs.core.async.close_BANG_(return_chan);
var state_27394__$1 = state_27394;
var statearr_27421_27484 = state_27394__$1;
(statearr_27421_27484[(2)] = inst_27382);

(statearr_27421_27484[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (43))){
var inst_27385 = (state_27394[(2)]);
var state_27394__$1 = state_27394;
var statearr_27422_27485 = state_27394__$1;
(statearr_27422_27485[(2)] = inst_27385);

(statearr_27422_27485[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (29))){
var inst_27349 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ident], 0));
var inst_27350 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_27349].join('');
var inst_27351 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27352 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_27353 = cljs.core.PersistentHashMap.fromArrays(inst_27351,inst_27352);
var inst_27354 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27350,inst_27353);
var inst_27355 = (function(){throw inst_27354})();
var state_27394__$1 = state_27394;
var statearr_27423_27486 = state_27394__$1;
(statearr_27423_27486[(2)] = inst_27355);

(statearr_27423_27486[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (6))){
var inst_27291 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27292 = [ident];
var inst_27293 = (new cljs.core.PersistentVector(null,1,(5),inst_27291,inst_27292,null));
var inst_27294 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_27293);
var state_27394__$1 = state_27394;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27394__$1,(9),inst_27294);
} else {
if((state_val_27395 === (28))){
var inst_27346 = (state_27394[(2)]);
var state_27394__$1 = state_27394;
var statearr_27424_27487 = state_27394__$1;
(statearr_27424_27487[(2)] = inst_27346);

(statearr_27424_27487[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (25))){
var inst_27340 = (state_27394[(8)]);
var inst_27340__$1 = (state_27394[(2)]);
var inst_27341 = (inst_27340__$1 == null);
var state_27394__$1 = (function (){var statearr_27425 = state_27394;
(statearr_27425[(8)] = inst_27340__$1);

return statearr_27425;
})();
if(cljs.core.truth_(inst_27341)){
var statearr_27426_27488 = state_27394__$1;
(statearr_27426_27488[(1)] = (26));

} else {
var statearr_27427_27489 = state_27394__$1;
(statearr_27427_27489[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (34))){
var inst_27389 = (state_27394[(2)]);
var _ = (function (){var statearr_27428 = state_27394;
(statearr_27428[(4)] = cljs.core.rest((state_27394[(4)])));

return statearr_27428;
})();
var state_27394__$1 = state_27394;
var statearr_27429_27490 = state_27394__$1;
(statearr_27429_27490[(2)] = inst_27389);

(statearr_27429_27490[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (17))){
var inst_27322 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_27394__$1 = state_27394;
if(inst_27322){
var statearr_27430_27491 = state_27394__$1;
(statearr_27430_27491[(1)] = (19));

} else {
var statearr_27431_27492 = state_27394__$1;
(statearr_27431_27492[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (3))){
var inst_27392 = (state_27394[(2)]);
var state_27394__$1 = state_27394;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27394__$1,inst_27392);
} else {
if((state_val_27395 === (12))){
var inst_27302 = (state_27394[(2)]);
var state_27394__$1 = state_27394;
var statearr_27432_27493 = state_27394__$1;
(statearr_27432_27493[(2)] = inst_27302);

(statearr_27432_27493[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (2))){
var _ = (function (){var statearr_27433 = state_27394;
(statearr_27433[(4)] = cljs.core.cons((5),(state_27394[(4)])));

return statearr_27433;
})();
var inst_27289 = typeof ident === 'number';
var state_27394__$1 = state_27394;
if(cljs.core.truth_(inst_27289)){
var statearr_27434_27494 = state_27394__$1;
(statearr_27434_27494[(1)] = (6));

} else {
var statearr_27435_27495 = state_27394__$1;
(statearr_27435_27495[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (23))){
var state_27394__$1 = state_27394;
var statearr_27436_27496 = state_27394__$1;
(statearr_27436_27496[(2)] = null);

(statearr_27436_27496[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (35))){
var state_27394__$1 = state_27394;
var statearr_27437_27497 = state_27394__$1;
(statearr_27437_27497[(2)] = strict_QMARK_);

(statearr_27437_27497[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (19))){
var inst_27325 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27326 = cljs.core.first(ident);
var inst_27327 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_27326);
var inst_27328 = cljs.core.second(ident);
var inst_27329 = [inst_27327,inst_27328];
var inst_27330 = (new cljs.core.PersistentVector(null,2,(5),inst_27325,inst_27329,null));
var inst_27331 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_27330);
var state_27394__$1 = state_27394;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27394__$1,(22),inst_27331);
} else {
if((state_val_27395 === (11))){
var state_27394__$1 = state_27394;
var statearr_27439_27498 = state_27394__$1;
(statearr_27439_27498[(2)] = null);

(statearr_27439_27498[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (9))){
var inst_27296 = (state_27394[(2)]);
var inst_27297 = fluree.db.util.async.throw_err(inst_27296);
var inst_27298 = cljs.core.not_empty(inst_27297);
var state_27394__$1 = state_27394;
if(cljs.core.truth_(inst_27298)){
var statearr_27440_27499 = state_27394__$1;
(statearr_27440_27499[(1)] = (10));

} else {
var statearr_27441_27500 = state_27394__$1;
(statearr_27441_27500[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (5))){
var _ = (function (){var statearr_27442 = state_27394;
(statearr_27442[(4)] = cljs.core.rest((state_27394[(4)])));

return statearr_27442;
})();
var state_27394__$1 = state_27394;
var ex27438 = (state_27394__$1[(2)]);
var statearr_27443_27501 = state_27394__$1;
(statearr_27443_27501[(5)] = ex27438);


var statearr_27444_27502 = state_27394__$1;
(statearr_27444_27502[(1)] = (4));

(statearr_27444_27502[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (14))){
var inst_27304 = (state_27394[(7)]);
var state_27394__$1 = state_27394;
var statearr_27445_27503 = state_27394__$1;
(statearr_27445_27503[(2)] = inst_27304);

(statearr_27445_27503[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (26))){
var state_27394__$1 = state_27394;
var statearr_27446_27504 = state_27394__$1;
(statearr_27446_27504[(2)] = null);

(statearr_27446_27504[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (16))){
var inst_27313 = cljs.core.first(ident);
var inst_27314 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_27313], 0));
var inst_27315 = ["Subject ID lookup failed. The predicate ",inst_27314," does not exist."].join('');
var inst_27316 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27317 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_27318 = cljs.core.PersistentHashMap.fromArrays(inst_27316,inst_27317);
var inst_27319 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27315,inst_27318);
var inst_27320 = (function(){throw inst_27319})();
var state_27394__$1 = state_27394;
var statearr_27447_27505 = state_27394__$1;
(statearr_27447_27505[(2)] = inst_27320);

(statearr_27447_27505[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (38))){
var inst_27374 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_27375 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27376 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_27377 = cljs.core.PersistentHashMap.fromArrays(inst_27375,inst_27376);
var inst_27378 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27374,inst_27377);
var inst_27379 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_27378);
var state_27394__$1 = state_27394;
var statearr_27448_27506 = state_27394__$1;
(statearr_27448_27506[(2)] = inst_27379);

(statearr_27448_27506[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (30))){
var state_27394__$1 = state_27394;
var statearr_27449_27507 = state_27394__$1;
(statearr_27449_27507[(2)] = null);

(statearr_27449_27507[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (10))){
var state_27394__$1 = state_27394;
var statearr_27450_27508 = state_27394__$1;
(statearr_27450_27508[(2)] = ident);

(statearr_27450_27508[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (18))){
var inst_27362 = (state_27394[(2)]);
var state_27394__$1 = state_27394;
var statearr_27451_27509 = state_27394__$1;
(statearr_27451_27509[(2)] = inst_27362);

(statearr_27451_27509[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (42))){
var state_27394__$1 = state_27394;
var statearr_27452_27510 = state_27394__$1;
(statearr_27452_27510[(2)] = null);

(statearr_27452_27510[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (37))){
var inst_27372 = (state_27394[(2)]);
var state_27394__$1 = state_27394;
if(cljs.core.truth_(inst_27372)){
var statearr_27453_27511 = state_27394__$1;
(statearr_27453_27511[(1)] = (38));

} else {
var statearr_27454_27512 = state_27394__$1;
(statearr_27454_27512[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27395 === (8))){
var inst_27364 = (state_27394[(10)]);
var inst_27364__$1 = (state_27394[(2)]);
var state_27394__$1 = (function (){var statearr_27455 = state_27394;
(statearr_27455[(10)] = inst_27364__$1);

return statearr_27455;
})();
if(cljs.core.truth_(inst_27364__$1)){
var statearr_27456_27513 = state_27394__$1;
(statearr_27456_27513[(1)] = (32));

} else {
var statearr_27457_27514 = state_27394__$1;
(statearr_27457_27514[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__2717__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__2717__auto____0 = (function (){
var statearr_27458 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27458[(0)] = fluree$db$graphdb$subid_$_state_machine__2717__auto__);

(statearr_27458[(1)] = (1));

return statearr_27458;
});
var fluree$db$graphdb$subid_$_state_machine__2717__auto____1 = (function (state_27394){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_27394);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e27459){var ex__2720__auto__ = e27459;
var statearr_27460_27515 = state_27394;
(statearr_27460_27515[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_27394[(4)]))){
var statearr_27461_27516 = state_27394;
(statearr_27461_27516[(1)] = cljs.core.first((state_27394[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27517 = state_27394;
state_27394 = G__27517;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__2717__auto__ = function(state_27394){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__2717__auto____1.call(this,state_27394);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__2717__auto____0;
fluree$db$graphdb$subid_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__2717__auto____1;
return fluree$db$graphdb$subid_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_27462 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_27462[(6)] = c__2739__auto___27463);

return statearr_27462;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));


return return_chan;
});
fluree.db.graphdb.graphdb_latest_db = (function fluree$db$graphdb$graphdb_latest_db(p__27518){
var map__27519 = p__27518;
var map__27519__$1 = cljs.core.__destructure_map(map__27519);
var current_db_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27519__$1,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27519__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_27535){
var state_val_27536 = (state_27535[(1)]);
if((state_val_27536 === (1))){
var state_27535__$1 = state_27535;
var statearr_27537_27551 = state_27535__$1;
(statearr_27537_27551[(2)] = null);

(statearr_27537_27551[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27536 === (2))){
var _ = (function (){var statearr_27538 = state_27535;
(statearr_27538[(4)] = cljs.core.cons((5),(state_27535[(4)])));

return statearr_27538;
})();
var inst_27526 = (current_db_fn.cljs$core$IFn$_invoke$arity$0 ? current_db_fn.cljs$core$IFn$_invoke$arity$0() : current_db_fn.call(null));
var state_27535__$1 = state_27535;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27535__$1,(6),inst_27526);
} else {
if((state_val_27536 === (3))){
var inst_27533 = (state_27535[(2)]);
var state_27535__$1 = state_27535;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27535__$1,inst_27533);
} else {
if((state_val_27536 === (4))){
var inst_27520 = (state_27535[(2)]);
var state_27535__$1 = state_27535;
var statearr_27540_27552 = state_27535__$1;
(statearr_27540_27552[(2)] = inst_27520);

(statearr_27540_27552[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27536 === (5))){
var _ = (function (){var statearr_27541 = state_27535;
(statearr_27541[(4)] = cljs.core.rest((state_27535[(4)])));

return statearr_27541;
})();
var state_27535__$1 = state_27535;
var ex27539 = (state_27535__$1[(2)]);
var statearr_27542_27553 = state_27535__$1;
(statearr_27542_27553[(5)] = ex27539);


if((ex27539 instanceof Error)){
var statearr_27543_27554 = state_27535__$1;
(statearr_27543_27554[(1)] = (4));

(statearr_27543_27554[(5)] = null);

} else {
throw ex27539;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27536 === (6))){
var inst_27528 = (state_27535[(2)]);
var inst_27529 = fluree.db.util.async.throw_err(inst_27528);
var inst_27530 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27529,new cljs.core.Keyword(null,"permissions","permissions",67803075),permissions);
var _ = (function (){var statearr_27544 = state_27535;
(statearr_27544[(4)] = cljs.core.rest((state_27535[(4)])));

return statearr_27544;
})();
var state_27535__$1 = state_27535;
var statearr_27545_27555 = state_27535__$1;
(statearr_27545_27555[(2)] = inst_27530);

(statearr_27545_27555[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2717__auto__ = null;
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2717__auto____0 = (function (){
var statearr_27546 = [null,null,null,null,null,null,null];
(statearr_27546[(0)] = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2717__auto__);

(statearr_27546[(1)] = (1));

return statearr_27546;
});
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2717__auto____1 = (function (state_27535){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_27535);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e27547){var ex__2720__auto__ = e27547;
var statearr_27548_27556 = state_27535;
(statearr_27548_27556[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_27535[(4)]))){
var statearr_27549_27557 = state_27535;
(statearr_27549_27557[(1)] = cljs.core.first((state_27535[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27558 = state_27535;
state_27535 = G__27558;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2717__auto__ = function(state_27535){
switch(arguments.length){
case 0:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2717__auto____1.call(this,state_27535);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2717__auto____0;
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2717__auto____1;
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_27550 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_27550[(6)] = c__2739__auto__);

return statearr_27550;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
fluree.db.graphdb.graphdb_root_db = (function fluree$db$graphdb$graphdb_root_db(this$){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
});
fluree.db.graphdb.graphdb_c_prop = (function fluree$db$graphdb$graphdb_c_prop(p__27559,property,collection){
var map__27560 = p__27559;
var map__27560__$1 = cljs.core.__destructure_map(map__27560);
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27560__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_((function (){var fexpr__27561 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"partition","partition",1174740751),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null);
return (fexpr__27561.cljs$core$IFn$_invoke$arity$1 ? fexpr__27561.cljs$core$IFn$_invoke$arity$1(property) : fexpr__27561.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_(collection)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
});
fluree.db.graphdb.graphdb_p_prop = (function fluree$db$graphdb$graphdb_p_prop(p__27562,property,predicate){
var map__27563 = p__27562;
var map__27563__$1 = cljs.core.__destructure_map(map__27563);
var this$ = map__27563__$1;
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27563__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_((function (){var fexpr__27564 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null);
return (fexpr__27564.cljs$core$IFn$_invoke$arity$1 ? fexpr__27564.cljs$core$IFn$_invoke$arity$1(property) : fexpr__27564.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__27565 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return fluree.db.dbproto._c_prop(this$,new cljs.core.Keyword(null,"partition","partition",1174740751),G__27565);
} else {
return G__27565;
}
});
/**
 * Lookup the predicate name if needed; return ::no-pred if pred arg is nil so
 *   we can differentiate between that and (dbproto/-p-prop ...) returning nil
 */
fluree.db.graphdb.graphdb_pred_name = (function fluree$db$graphdb$graphdb_pred_name(this$,pred){
if((pred == null)){
return new cljs.core.Keyword("fluree.db.graphdb","no-pred","fluree.db.graphdb/no-pred",1182779470);
} else {
if(typeof pred === 'string'){
return pred;
} else {
return fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);

}
}
});
/**
 * resolves a tags's value given a tag subject id; optionally shortening the
 *   return value if it starts with the given predicate name
 */
fluree.db.graphdb.graphdb_tag = (function fluree$db$graphdb$graphdb_tag(var_args){
var G__27567 = arguments.length;
switch (G__27567) {
case 2:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_id){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_27599){
var state_val_27600 = (state_27599[(1)]);
if((state_val_27600 === (7))){
var state_27599__$1 = state_27599;
var statearr_27601_27695 = state_27599__$1;
(statearr_27601_27695[(2)] = null);

(statearr_27601_27695[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27600 === (1))){
var state_27599__$1 = state_27599;
var statearr_27602_27696 = state_27599__$1;
(statearr_27602_27696[(2)] = null);

(statearr_27602_27696[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27600 === (4))){
var inst_27568 = (state_27599[(2)]);
var state_27599__$1 = state_27599;
var statearr_27603_27697 = state_27599__$1;
(statearr_27603_27697[(2)] = inst_27568);

(statearr_27603_27697[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27600 === (6))){
var inst_27582 = (state_27599[(7)]);
var inst_27581 = (state_27599[(2)]);
var inst_27582__$1 = fluree.db.util.async.throw_err(inst_27581);
var inst_27583 = (inst_27582__$1 == null);
var state_27599__$1 = (function (){var statearr_27604 = state_27599;
(statearr_27604[(7)] = inst_27582__$1);

return statearr_27604;
})();
if(cljs.core.truth_(inst_27583)){
var statearr_27605_27698 = state_27599__$1;
(statearr_27605_27698[(1)] = (7));

} else {
var statearr_27606_27699 = state_27599__$1;
(statearr_27606_27699[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27600 === (3))){
var inst_27597 = (state_27599[(2)]);
var state_27599__$1 = state_27599;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27599__$1,inst_27597);
} else {
if((state_val_27600 === (12))){
var inst_27594 = (state_27599[(2)]);
var _ = (function (){var statearr_27607 = state_27599;
(statearr_27607[(4)] = cljs.core.rest((state_27599[(4)])));

return statearr_27607;
})();
var state_27599__$1 = state_27599;
var statearr_27608_27700 = state_27599__$1;
(statearr_27608_27700[(2)] = inst_27594);

(statearr_27608_27700[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27600 === (2))){
var _ = (function (){var statearr_27609 = state_27599;
(statearr_27609[(4)] = cljs.core.cons((5),(state_27599[(4)])));

return statearr_27609;
})();
var inst_27575 = fluree.db.dbproto._rootdb(this$);
var inst_27576 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27577 = [tag_id,(30)];
var inst_27578 = (new cljs.core.PersistentVector(null,2,(5),inst_27576,inst_27577,null));
var inst_27579 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_27575,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_27578);
var state_27599__$1 = state_27599;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27599__$1,(6),inst_27579);
} else {
if((state_val_27600 === (11))){
var inst_27588 = (state_27599[(8)]);
var inst_27592 = inst_27588.o;
var state_27599__$1 = state_27599;
var statearr_27611_27701 = state_27599__$1;
(statearr_27611_27701[(2)] = inst_27592);

(statearr_27611_27701[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27600 === (9))){
var inst_27588 = (state_27599[(8)]);
var inst_27588__$1 = (state_27599[(2)]);
var inst_27589 = (inst_27588__$1 == null);
var state_27599__$1 = (function (){var statearr_27612 = state_27599;
(statearr_27612[(8)] = inst_27588__$1);

return statearr_27612;
})();
if(cljs.core.truth_(inst_27589)){
var statearr_27613_27702 = state_27599__$1;
(statearr_27613_27702[(1)] = (10));

} else {
var statearr_27614_27703 = state_27599__$1;
(statearr_27614_27703[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27600 === (5))){
var _ = (function (){var statearr_27615 = state_27599;
(statearr_27615[(4)] = cljs.core.rest((state_27599[(4)])));

return statearr_27615;
})();
var state_27599__$1 = state_27599;
var ex27610 = (state_27599__$1[(2)]);
var statearr_27616_27704 = state_27599__$1;
(statearr_27616_27704[(5)] = ex27610);


if((ex27610 instanceof Error)){
var statearr_27617_27705 = state_27599__$1;
(statearr_27617_27705[(1)] = (4));

(statearr_27617_27705[(5)] = null);

} else {
throw ex27610;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27600 === (10))){
var state_27599__$1 = state_27599;
var statearr_27618_27706 = state_27599__$1;
(statearr_27618_27706[(2)] = null);

(statearr_27618_27706[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27600 === (8))){
var inst_27582 = (state_27599[(7)]);
var inst_27586 = cljs.core.first(inst_27582);
var state_27599__$1 = state_27599;
var statearr_27619_27707 = state_27599__$1;
(statearr_27619_27707[(2)] = inst_27586);

(statearr_27619_27707[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2717__auto__ = null;
var fluree$db$graphdb$state_machine__2717__auto____0 = (function (){
var statearr_27620 = [null,null,null,null,null,null,null,null,null];
(statearr_27620[(0)] = fluree$db$graphdb$state_machine__2717__auto__);

(statearr_27620[(1)] = (1));

return statearr_27620;
});
var fluree$db$graphdb$state_machine__2717__auto____1 = (function (state_27599){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_27599);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e27621){var ex__2720__auto__ = e27621;
var statearr_27622_27708 = state_27599;
(statearr_27622_27708[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_27599[(4)]))){
var statearr_27623_27709 = state_27599;
(statearr_27623_27709[(1)] = cljs.core.first((state_27599[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27710 = state_27599;
state_27599 = G__27710;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2717__auto__ = function(state_27599){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2717__auto____1.call(this,state_27599);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2717__auto____0;
fluree$db$graphdb$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2717__auto____1;
return fluree$db$graphdb$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_27624 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_27624[(6)] = c__2739__auto__);

return statearr_27624;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_id,pred){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_27660){
var state_val_27661 = (state_27660[(1)]);
if((state_val_27661 === (7))){
var inst_27634 = fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_27660__$1 = state_27660;
var statearr_27662_27711 = state_27660__$1;
(statearr_27662_27711[(2)] = inst_27634);

(statearr_27662_27711[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27661 === (1))){
var state_27660__$1 = state_27660;
var statearr_27663_27712 = state_27660__$1;
(statearr_27663_27712[(2)] = null);

(statearr_27663_27712[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27661 === (4))){
var inst_27625 = (state_27660[(2)]);
var state_27660__$1 = state_27660;
var statearr_27664_27713 = state_27660__$1;
(statearr_27664_27713[(2)] = inst_27625);

(statearr_27664_27713[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27661 === (15))){
var inst_27655 = (state_27660[(2)]);
var _ = (function (){var statearr_27665 = state_27660;
(statearr_27665[(4)] = cljs.core.rest((state_27660[(4)])));

return statearr_27665;
})();
var state_27660__$1 = state_27660;
var statearr_27666_27714 = state_27660__$1;
(statearr_27666_27714[(2)] = inst_27655);

(statearr_27666_27714[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27661 === (13))){
var inst_27640 = (state_27660[(7)]);
var inst_27646 = clojure.string.includes_QMARK_(inst_27640,":");
var state_27660__$1 = state_27660;
if(inst_27646){
var statearr_27667_27715 = state_27660__$1;
(statearr_27667_27715[(1)] = (16));

} else {
var statearr_27668_27716 = state_27660__$1;
(statearr_27668_27716[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27661 === (6))){
var state_27660__$1 = state_27660;
var statearr_27669_27717 = state_27660__$1;
(statearr_27669_27717[(2)] = pred);

(statearr_27669_27717[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27661 === (17))){
var inst_27640 = (state_27660[(7)]);
var state_27660__$1 = state_27660;
var statearr_27670_27718 = state_27660__$1;
(statearr_27670_27718[(2)] = inst_27640);

(statearr_27670_27718[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27661 === (3))){
var inst_27658 = (state_27660[(2)]);
var state_27660__$1 = state_27660;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27660__$1,inst_27658);
} else {
if((state_val_27661 === (12))){
var inst_27644 = (state_27660[(2)]);
var state_27660__$1 = state_27660;
if(cljs.core.truth_(inst_27644)){
var statearr_27671_27719 = state_27660__$1;
(statearr_27671_27719[(1)] = (13));

} else {
var statearr_27672_27720 = state_27660__$1;
(statearr_27672_27720[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27661 === (2))){
var _ = (function (){var statearr_27673 = state_27660;
(statearr_27673[(4)] = cljs.core.cons((5),(state_27660[(4)])));

return statearr_27673;
})();
var inst_27631 = typeof pred === 'string';
var state_27660__$1 = state_27660;
if(cljs.core.truth_(inst_27631)){
var statearr_27674_27721 = state_27660__$1;
(statearr_27674_27721[(1)] = (6));

} else {
var statearr_27675_27722 = state_27660__$1;
(statearr_27675_27722[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27661 === (11))){
var inst_27636 = (state_27660[(8)]);
var state_27660__$1 = state_27660;
var statearr_27677_27723 = state_27660__$1;
(statearr_27677_27723[(2)] = inst_27636);

(statearr_27677_27723[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27661 === (9))){
var inst_27636 = (state_27660[(8)]);
var inst_27639 = (state_27660[(2)]);
var inst_27640 = fluree.db.util.async.throw_err(inst_27639);
var state_27660__$1 = (function (){var statearr_27678 = state_27660;
(statearr_27678[(7)] = inst_27640);

return statearr_27678;
})();
if(cljs.core.truth_(inst_27636)){
var statearr_27679_27724 = state_27660__$1;
(statearr_27679_27724[(1)] = (10));

} else {
var statearr_27680_27725 = state_27660__$1;
(statearr_27680_27725[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27661 === (5))){
var _ = (function (){var statearr_27681 = state_27660;
(statearr_27681[(4)] = cljs.core.rest((state_27660[(4)])));

return statearr_27681;
})();
var state_27660__$1 = state_27660;
var ex27676 = (state_27660__$1[(2)]);
var statearr_27682_27726 = state_27660__$1;
(statearr_27682_27726[(5)] = ex27676);


if((ex27676 instanceof Error)){
var statearr_27683_27727 = state_27660__$1;
(statearr_27683_27727[(1)] = (4));

(statearr_27683_27727[(5)] = null);

} else {
throw ex27676;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27661 === (14))){
var state_27660__$1 = state_27660;
var statearr_27684_27728 = state_27660__$1;
(statearr_27684_27728[(2)] = null);

(statearr_27684_27728[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27661 === (16))){
var inst_27640 = (state_27660[(7)]);
var inst_27648 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(inst_27640,/:/);
var inst_27649 = cljs.core.second(inst_27648);
var state_27660__$1 = state_27660;
var statearr_27685_27729 = state_27660__$1;
(statearr_27685_27729[(2)] = inst_27649);

(statearr_27685_27729[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27661 === (10))){
var inst_27640 = (state_27660[(7)]);
var state_27660__$1 = state_27660;
var statearr_27686_27730 = state_27660__$1;
(statearr_27686_27730[(2)] = inst_27640);

(statearr_27686_27730[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27661 === (18))){
var inst_27652 = (state_27660[(2)]);
var state_27660__$1 = state_27660;
var statearr_27687_27731 = state_27660__$1;
(statearr_27687_27731[(2)] = inst_27652);

(statearr_27687_27731[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27661 === (8))){
var inst_27636 = (state_27660[(2)]);
var inst_27637 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$2(this$,tag_id);
var state_27660__$1 = (function (){var statearr_27688 = state_27660;
(statearr_27688[(8)] = inst_27636);

return statearr_27688;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27660__$1,(9),inst_27637);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2717__auto__ = null;
var fluree$db$graphdb$state_machine__2717__auto____0 = (function (){
var statearr_27689 = [null,null,null,null,null,null,null,null,null];
(statearr_27689[(0)] = fluree$db$graphdb$state_machine__2717__auto__);

(statearr_27689[(1)] = (1));

return statearr_27689;
});
var fluree$db$graphdb$state_machine__2717__auto____1 = (function (state_27660){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_27660);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e27690){var ex__2720__auto__ = e27690;
var statearr_27691_27732 = state_27660;
(statearr_27691_27732[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_27660[(4)]))){
var statearr_27692_27733 = state_27660;
(statearr_27692_27733[(1)] = cljs.core.first((state_27660[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27734 = state_27660;
state_27660 = G__27734;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2717__auto__ = function(state_27660){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2717__auto____1.call(this,state_27660);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2717__auto____0;
fluree$db$graphdb$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2717__auto____1;
return fluree$db$graphdb$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_27693 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_27693[(6)] = c__2739__auto__);

return statearr_27693;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$lang$maxFixedArity = 3);

fluree.db.graphdb.graphdb_tag_id = (function fluree$db$graphdb$graphdb_tag_id(var_args){
var G__27736 = arguments.length;
switch (G__27736) {
case 2:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_name){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_27769){
var state_val_27770 = (state_27769[(1)]);
if((state_val_27770 === (7))){
var state_27769__$1 = state_27769;
var statearr_27771_27859 = state_27769__$1;
(statearr_27771_27859[(2)] = null);

(statearr_27771_27859[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27770 === (1))){
var state_27769__$1 = state_27769;
var statearr_27772_27860 = state_27769__$1;
(statearr_27772_27860[(2)] = null);

(statearr_27772_27860[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27770 === (4))){
var inst_27737 = (state_27769[(2)]);
var state_27769__$1 = state_27769;
var statearr_27773_27861 = state_27769__$1;
(statearr_27773_27861[(2)] = inst_27737);

(statearr_27773_27861[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27770 === (6))){
var inst_27752 = (state_27769[(7)]);
var inst_27751 = (state_27769[(2)]);
var inst_27752__$1 = fluree.db.util.async.throw_err(inst_27751);
var inst_27753 = (inst_27752__$1 == null);
var state_27769__$1 = (function (){var statearr_27774 = state_27769;
(statearr_27774[(7)] = inst_27752__$1);

return statearr_27774;
})();
if(cljs.core.truth_(inst_27753)){
var statearr_27775_27862 = state_27769__$1;
(statearr_27775_27862[(1)] = (7));

} else {
var statearr_27776_27863 = state_27769__$1;
(statearr_27776_27863[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27770 === (3))){
var inst_27767 = (state_27769[(2)]);
var state_27769__$1 = state_27769;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27769__$1,inst_27767);
} else {
if((state_val_27770 === (12))){
var inst_27764 = (state_27769[(2)]);
var _ = (function (){var statearr_27777 = state_27769;
(statearr_27777[(4)] = cljs.core.rest((state_27769[(4)])));

return statearr_27777;
})();
var state_27769__$1 = state_27769;
var statearr_27778_27864 = state_27769__$1;
(statearr_27778_27864[(2)] = inst_27764);

(statearr_27778_27864[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27770 === (2))){
var _ = (function (){var statearr_27779 = state_27769;
(statearr_27779[(4)] = cljs.core.cons((5),(state_27769[(4)])));

return statearr_27779;
})();
var inst_27743 = (30);
var inst_27745 = fluree.db.dbproto._rootdb(this$);
var inst_27746 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27747 = [inst_27743,tag_name];
var inst_27748 = (new cljs.core.PersistentVector(null,2,(5),inst_27746,inst_27747,null));
var inst_27749 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_27745,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_27748);
var state_27769__$1 = state_27769;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27769__$1,(6),inst_27749);
} else {
if((state_val_27770 === (11))){
var inst_27758 = (state_27769[(8)]);
var inst_27762 = inst_27758.s;
var state_27769__$1 = state_27769;
var statearr_27781_27865 = state_27769__$1;
(statearr_27781_27865[(2)] = inst_27762);

(statearr_27781_27865[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27770 === (9))){
var inst_27758 = (state_27769[(8)]);
var inst_27758__$1 = (state_27769[(2)]);
var inst_27759 = (inst_27758__$1 == null);
var state_27769__$1 = (function (){var statearr_27782 = state_27769;
(statearr_27782[(8)] = inst_27758__$1);

return statearr_27782;
})();
if(cljs.core.truth_(inst_27759)){
var statearr_27783_27866 = state_27769__$1;
(statearr_27783_27866[(1)] = (10));

} else {
var statearr_27784_27867 = state_27769__$1;
(statearr_27784_27867[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27770 === (5))){
var _ = (function (){var statearr_27785 = state_27769;
(statearr_27785[(4)] = cljs.core.rest((state_27769[(4)])));

return statearr_27785;
})();
var state_27769__$1 = state_27769;
var ex27780 = (state_27769__$1[(2)]);
var statearr_27786_27868 = state_27769__$1;
(statearr_27786_27868[(5)] = ex27780);


if((ex27780 instanceof Error)){
var statearr_27787_27869 = state_27769__$1;
(statearr_27787_27869[(1)] = (4));

(statearr_27787_27869[(5)] = null);

} else {
throw ex27780;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27770 === (10))){
var state_27769__$1 = state_27769;
var statearr_27788_27870 = state_27769__$1;
(statearr_27788_27870[(2)] = null);

(statearr_27788_27870[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27770 === (8))){
var inst_27752 = (state_27769[(7)]);
var inst_27756 = cljs.core.first(inst_27752);
var state_27769__$1 = state_27769;
var statearr_27789_27871 = state_27769__$1;
(statearr_27789_27871[(2)] = inst_27756);

(statearr_27789_27871[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2717__auto__ = null;
var fluree$db$graphdb$state_machine__2717__auto____0 = (function (){
var statearr_27790 = [null,null,null,null,null,null,null,null,null];
(statearr_27790[(0)] = fluree$db$graphdb$state_machine__2717__auto__);

(statearr_27790[(1)] = (1));

return statearr_27790;
});
var fluree$db$graphdb$state_machine__2717__auto____1 = (function (state_27769){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_27769);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e27791){var ex__2720__auto__ = e27791;
var statearr_27792_27872 = state_27769;
(statearr_27792_27872[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_27769[(4)]))){
var statearr_27793_27873 = state_27769;
(statearr_27793_27873[(1)] = cljs.core.first((state_27769[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27874 = state_27769;
state_27769 = G__27874;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2717__auto__ = function(state_27769){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2717__auto____1.call(this,state_27769);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2717__auto____0;
fluree$db$graphdb$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2717__auto____1;
return fluree$db$graphdb$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_27794 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_27794[(6)] = c__2739__auto__);

return statearr_27794;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_name,pred){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_27829){
var state_val_27830 = (state_27829[(1)]);
if((state_val_27830 === (7))){
var inst_27808 = typeof pred === 'string';
var state_27829__$1 = state_27829;
if(cljs.core.truth_(inst_27808)){
var statearr_27831_27875 = state_27829__$1;
(statearr_27831_27875[(1)] = (10));

} else {
var statearr_27832_27876 = state_27829__$1;
(statearr_27832_27876[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27830 === (1))){
var state_27829__$1 = state_27829;
var statearr_27833_27877 = state_27829__$1;
(statearr_27833_27877[(2)] = null);

(statearr_27833_27877[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27830 === (4))){
var inst_27795 = (state_27829[(2)]);
var state_27829__$1 = state_27829;
var statearr_27834_27878 = state_27829__$1;
(statearr_27834_27878[(2)] = inst_27795);

(statearr_27834_27878[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27830 === (15))){
var inst_27822 = (state_27829[(2)]);
var state_27829__$1 = state_27829;
var statearr_27835_27879 = state_27829__$1;
(statearr_27835_27879[(2)] = inst_27822);

(statearr_27835_27879[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27830 === (13))){
var inst_27813 = (state_27829[(7)]);
var inst_27815 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27813),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_27816 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,inst_27815);
var state_27829__$1 = state_27829;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27829__$1,(16),inst_27816);
} else {
if((state_val_27830 === (6))){
var inst_27803 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,tag_name);
var state_27829__$1 = state_27829;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27829__$1,(9),inst_27803);
} else {
if((state_val_27830 === (3))){
var inst_27827 = (state_27829[(2)]);
var state_27829__$1 = state_27829;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27829__$1,inst_27827);
} else {
if((state_val_27830 === (12))){
var inst_27813 = (state_27829[(7)]);
var inst_27813__$1 = (state_27829[(2)]);
var state_27829__$1 = (function (){var statearr_27836 = state_27829;
(statearr_27836[(7)] = inst_27813__$1);

return statearr_27836;
})();
if(cljs.core.truth_(inst_27813__$1)){
var statearr_27837_27880 = state_27829__$1;
(statearr_27837_27880[(1)] = (13));

} else {
var statearr_27838_27881 = state_27829__$1;
(statearr_27838_27881[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27830 === (2))){
var _ = (function (){var statearr_27839 = state_27829;
(statearr_27839[(4)] = cljs.core.cons((5),(state_27829[(4)])));

return statearr_27839;
})();
var inst_27801 = clojure.string.includes_QMARK_(tag_name,"/");
var state_27829__$1 = state_27829;
if(inst_27801){
var statearr_27840_27882 = state_27829__$1;
(statearr_27840_27882[(1)] = (6));

} else {
var statearr_27841_27883 = state_27829__$1;
(statearr_27841_27883[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27830 === (11))){
var inst_27811 = fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_27829__$1 = state_27829;
var statearr_27843_27884 = state_27829__$1;
(statearr_27843_27884[(2)] = inst_27811);

(statearr_27843_27884[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27830 === (9))){
var inst_27805 = (state_27829[(2)]);
var inst_27806 = fluree.db.util.async.throw_err(inst_27805);
var state_27829__$1 = state_27829;
var statearr_27844_27885 = state_27829__$1;
(statearr_27844_27885[(2)] = inst_27806);

(statearr_27844_27885[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27830 === (5))){
var _ = (function (){var statearr_27845 = state_27829;
(statearr_27845[(4)] = cljs.core.rest((state_27829[(4)])));

return statearr_27845;
})();
var state_27829__$1 = state_27829;
var ex27842 = (state_27829__$1[(2)]);
var statearr_27846_27886 = state_27829__$1;
(statearr_27846_27886[(5)] = ex27842);


if((ex27842 instanceof Error)){
var statearr_27847_27887 = state_27829__$1;
(statearr_27847_27887[(1)] = (4));

(statearr_27847_27887[(5)] = null);

} else {
throw ex27842;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27830 === (14))){
var state_27829__$1 = state_27829;
var statearr_27848_27888 = state_27829__$1;
(statearr_27848_27888[(2)] = null);

(statearr_27848_27888[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27830 === (16))){
var inst_27818 = (state_27829[(2)]);
var inst_27819 = fluree.db.util.async.throw_err(inst_27818);
var state_27829__$1 = state_27829;
var statearr_27849_27889 = state_27829__$1;
(statearr_27849_27889[(2)] = inst_27819);

(statearr_27849_27889[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27830 === (10))){
var state_27829__$1 = state_27829;
var statearr_27850_27890 = state_27829__$1;
(statearr_27850_27890[(2)] = pred);

(statearr_27850_27890[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27830 === (8))){
var inst_27824 = (state_27829[(2)]);
var _ = (function (){var statearr_27851 = state_27829;
(statearr_27851[(4)] = cljs.core.rest((state_27829[(4)])));

return statearr_27851;
})();
var state_27829__$1 = state_27829;
var statearr_27852_27891 = state_27829__$1;
(statearr_27852_27891[(2)] = inst_27824);

(statearr_27852_27891[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2717__auto__ = null;
var fluree$db$graphdb$state_machine__2717__auto____0 = (function (){
var statearr_27853 = [null,null,null,null,null,null,null,null];
(statearr_27853[(0)] = fluree$db$graphdb$state_machine__2717__auto__);

(statearr_27853[(1)] = (1));

return statearr_27853;
});
var fluree$db$graphdb$state_machine__2717__auto____1 = (function (state_27829){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_27829);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e27854){var ex__2720__auto__ = e27854;
var statearr_27855_27892 = state_27829;
(statearr_27855_27892[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_27829[(4)]))){
var statearr_27856_27893 = state_27829;
(statearr_27856_27893[(1)] = cljs.core.first((state_27829[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27894 = state_27829;
state_27829 = G__27894;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2717__auto__ = function(state_27829){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2717__auto____1.call(this,state_27829);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2717__auto____0;
fluree$db$graphdb$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2717__auto____1;
return fluree$db$graphdb$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_27857 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_27857[(6)] = c__2739__auto__);

return statearr_27857;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k27896,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__27900 = k27896;
var G__27900__$1 = (((G__27900 instanceof cljs.core.Keyword))?G__27900.fqn:null);
switch (G__27900__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k27896,else__4464__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__27901){
var vec__27902 = p__27901;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27902,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27902,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27895){
var self__ = this;
var G__27895__$1 = this;
return (new cljs.core.RecordIter((0),G__27895__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (20 + cljs.core.count(self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__27905 = (function (coll__4458__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__27905(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27897,other27898){
var self__ = this;
var this27897__$1 = this;
return (((!((other27898 == null)))) && ((((this27897__$1.constructor === other27898.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27897__$1.conn,other27898.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27897__$1.network,other27898.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27897__$1.dbid,other27898.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27897__$1.block,other27898.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27897__$1.t,other27898.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27897__$1.tt_id,other27898.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27897__$1.stats,other27898.stats)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27897__$1.spot,other27898.spot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27897__$1.psot,other27898.psot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27897__$1.post,other27898.post)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27897__$1.opst,other27898.opst)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27897__$1.schema,other27898.schema)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27897__$1.settings,other27898.settings)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27897__$1.index_configs,other27898.index_configs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27897__$1.schema_cache,other27898.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27897__$1.novelty,other27898.novelty)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27897__$1.permissions,other27898.permissions)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27897__$1.fork,other27898.fork)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27897__$1.fork_block,other27898.fork_block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27897__$1.current_db_fn,other27898.current_db_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27897__$1.__extmap,other27898.__extmap)))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k27896){
var self__ = this;
var this__4468__auto____$1 = this;
var G__27906 = k27896;
var G__27906__$1 = (((G__27906 instanceof cljs.core.Keyword))?G__27906.fqn:null);
switch (G__27906__$1) {
case "conn":
case "network":
case "dbid":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "schema":
case "settings":
case "index-configs":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k27896);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__27895){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__27907 = cljs.core.keyword_identical_QMARK_;
var expr__27908 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__27910 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__27911 = expr__27908;
return (pred__27907.cljs$core$IFn$_invoke$arity$2 ? pred__27907.cljs$core$IFn$_invoke$arity$2(G__27910,G__27911) : pred__27907.call(null,G__27910,G__27911));
})())){
return (new fluree.db.graphdb.GraphDb(G__27895,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27912 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__27913 = expr__27908;
return (pred__27907.cljs$core$IFn$_invoke$arity$2 ? pred__27907.cljs$core$IFn$_invoke$arity$2(G__27912,G__27913) : pred__27907.call(null,G__27912,G__27913));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__27895,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27914 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__27915 = expr__27908;
return (pred__27907.cljs$core$IFn$_invoke$arity$2 ? pred__27907.cljs$core$IFn$_invoke$arity$2(G__27914,G__27915) : pred__27907.call(null,G__27914,G__27915));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__27895,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27916 = new cljs.core.Keyword(null,"block","block",664686210);
var G__27917 = expr__27908;
return (pred__27907.cljs$core$IFn$_invoke$arity$2 ? pred__27907.cljs$core$IFn$_invoke$arity$2(G__27916,G__27917) : pred__27907.call(null,G__27916,G__27917));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__27895,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27918 = new cljs.core.Keyword(null,"t","t",-1397832519);
var G__27919 = expr__27908;
return (pred__27907.cljs$core$IFn$_invoke$arity$2 ? pred__27907.cljs$core$IFn$_invoke$arity$2(G__27918,G__27919) : pred__27907.call(null,G__27918,G__27919));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__27895,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27920 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484);
var G__27921 = expr__27908;
return (pred__27907.cljs$core$IFn$_invoke$arity$2 ? pred__27907.cljs$core$IFn$_invoke$arity$2(G__27920,G__27921) : pred__27907.call(null,G__27920,G__27921));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__27895,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27922 = new cljs.core.Keyword(null,"stats","stats",-85643011);
var G__27923 = expr__27908;
return (pred__27907.cljs$core$IFn$_invoke$arity$2 ? pred__27907.cljs$core$IFn$_invoke$arity$2(G__27922,G__27923) : pred__27907.call(null,G__27922,G__27923));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__27895,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27924 = new cljs.core.Keyword(null,"spot","spot",-1706962147);
var G__27925 = expr__27908;
return (pred__27907.cljs$core$IFn$_invoke$arity$2 ? pred__27907.cljs$core$IFn$_invoke$arity$2(G__27924,G__27925) : pred__27907.call(null,G__27924,G__27925));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__27895,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27926 = new cljs.core.Keyword(null,"psot","psot",2111653059);
var G__27927 = expr__27908;
return (pred__27907.cljs$core$IFn$_invoke$arity$2 ? pred__27907.cljs$core$IFn$_invoke$arity$2(G__27926,G__27927) : pred__27907.call(null,G__27926,G__27927));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__27895,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27928 = new cljs.core.Keyword(null,"post","post",269697687);
var G__27929 = expr__27908;
return (pred__27907.cljs$core$IFn$_invoke$arity$2 ? pred__27907.cljs$core$IFn$_invoke$arity$2(G__27928,G__27929) : pred__27907.call(null,G__27928,G__27929));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__27895,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27930 = new cljs.core.Keyword(null,"opst","opst",1213963058);
var G__27931 = expr__27908;
return (pred__27907.cljs$core$IFn$_invoke$arity$2 ? pred__27907.cljs$core$IFn$_invoke$arity$2(G__27930,G__27931) : pred__27907.call(null,G__27930,G__27931));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__27895,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27932 = new cljs.core.Keyword(null,"schema","schema",-1582001791);
var G__27933 = expr__27908;
return (pred__27907.cljs$core$IFn$_invoke$arity$2 ? pred__27907.cljs$core$IFn$_invoke$arity$2(G__27932,G__27933) : pred__27907.call(null,G__27932,G__27933));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__27895,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27934 = new cljs.core.Keyword(null,"settings","settings",1556144875);
var G__27935 = expr__27908;
return (pred__27907.cljs$core$IFn$_invoke$arity$2 ? pred__27907.cljs$core$IFn$_invoke$arity$2(G__27934,G__27935) : pred__27907.call(null,G__27934,G__27935));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__27895,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27936 = new cljs.core.Keyword(null,"index-configs","index-configs",1053959280);
var G__27937 = expr__27908;
return (pred__27907.cljs$core$IFn$_invoke$arity$2 ? pred__27907.cljs$core$IFn$_invoke$arity$2(G__27936,G__27937) : pred__27907.call(null,G__27936,G__27937));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__27895,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27938 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__27939 = expr__27908;
return (pred__27907.cljs$core$IFn$_invoke$arity$2 ? pred__27907.cljs$core$IFn$_invoke$arity$2(G__27938,G__27939) : pred__27907.call(null,G__27938,G__27939));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__27895,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27940 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024);
var G__27941 = expr__27908;
return (pred__27907.cljs$core$IFn$_invoke$arity$2 ? pred__27907.cljs$core$IFn$_invoke$arity$2(G__27940,G__27941) : pred__27907.call(null,G__27940,G__27941));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__27895,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27942 = new cljs.core.Keyword(null,"permissions","permissions",67803075);
var G__27943 = expr__27908;
return (pred__27907.cljs$core$IFn$_invoke$arity$2 ? pred__27907.cljs$core$IFn$_invoke$arity$2(G__27942,G__27943) : pred__27907.call(null,G__27942,G__27943));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__27895,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27944 = new cljs.core.Keyword(null,"fork","fork",1062974235);
var G__27945 = expr__27908;
return (pred__27907.cljs$core$IFn$_invoke$arity$2 ? pred__27907.cljs$core$IFn$_invoke$arity$2(G__27944,G__27945) : pred__27907.call(null,G__27944,G__27945));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__27895,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27946 = new cljs.core.Keyword(null,"fork-block","fork-block",178387923);
var G__27947 = expr__27908;
return (pred__27907.cljs$core$IFn$_invoke$arity$2 ? pred__27907.cljs$core$IFn$_invoke$arity$2(G__27946,G__27947) : pred__27907.call(null,G__27946,G__27947));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__27895,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27948 = new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336);
var G__27949 = expr__27908;
return (pred__27907.cljs$core$IFn$_invoke$arity$2 ? pred__27907.cljs$core$IFn$_invoke$arity$2(G__27948,G__27949) : pred__27907.call(null,G__27948,G__27949));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__27895,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__27895),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__27895){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__27895,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_latest_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx(this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_c_prop(this$__$1,property,collection);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_p_prop(this$__$1,property,predicate);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2(this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_root_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query(this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_id,pred);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_name);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_name,pred);
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"index-configs","index-configs",-1600476489,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__27899){
var extmap__4501__auto__ = (function (){var G__27950 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__27899,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], 0));
if(cljs.core.record_QMARK_(G__27899)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__27950);
} else {
return G__27950;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__27899),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__27899),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__27899),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__27899),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__27899),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__27899),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__27899),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__27899),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__27899),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__27899),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__27899),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__27899),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__27899),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280).cljs$core$IFn$_invoke$arity$1(G__27899),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__27899),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__27899),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__27899),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__27899),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__27899),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__27899),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write(w,"#FlureeGraphDB ");

return cljs.core._write(w,cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),db__$1.dbid,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)], 0)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,idx){
var ss = clojure.data.avl.sorted_set_by(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658)], null)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658).cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake(fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"conn","conn",278309663)],[(0),dbid,index_config,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(comparator,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([first_flake,child_node], 0));
var idx_node = fluree.db.index.__GT_IndexNode((0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_spot_novelty], null)),new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_psot_novelty], null)),new cljs.core.Keyword(null,"post","post",269697687),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_post_novelty], null)),new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map(fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var spot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"post","post",269697687));
var opst = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"opst","opst",1213963058));
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb(conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
