// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4867__auto___53103 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_53154){
var state_val_53155 = (state_53154[(1)]);
if((state_val_53155 === (7))){
var inst_53149 = (state_53154[(2)]);
var _ = (function (){var statearr_53156 = state_53154;
(statearr_53156[(4)] = cljs.core.rest((state_53154[(4)])));

return statearr_53156;
})();
var state_53154__$1 = state_53154;
var statearr_53157_53184 = state_53154__$1;
(statearr_53157_53184[(2)] = inst_53149);

(statearr_53157_53184[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53155 === (1))){
var state_53154__$1 = state_53154;
var statearr_53158_53185 = state_53154__$1;
(statearr_53158_53185[(2)] = null);

(statearr_53158_53185[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53155 === (4))){
var inst_53104 = (state_53154[(2)]);
var state_53154__$1 = state_53154;
var statearr_53159_53186 = state_53154__$1;
(statearr_53159_53186[(2)] = inst_53104);

(statearr_53159_53186[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53155 === (13))){
var inst_53145 = (state_53154[(2)]);
var state_53154__$1 = state_53154;
var statearr_53160_53187 = state_53154__$1;
(statearr_53160_53187[(2)] = inst_53145);

(statearr_53160_53187[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53155 === (6))){
var inst_53129 = (state_53154[(7)]);
var inst_53122 = (state_53154[(8)]);
var inst_53128 = cljs.core.seq(inst_53122);
var inst_53129__$1 = cljs.core.first(inst_53128);
var inst_53130 = cljs.core.next(inst_53128);
var inst_53131 = cljs.core.not(inst_53129__$1);
var state_53154__$1 = (function (){var statearr_53161 = state_53154;
(statearr_53161[(7)] = inst_53129__$1);

(statearr_53161[(9)] = inst_53130);

return statearr_53161;
})();
if(inst_53131){
var statearr_53162_53188 = state_53154__$1;
(statearr_53162_53188[(1)] = (8));

} else {
var statearr_53163_53189 = state_53154__$1;
(statearr_53163_53189[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53155 === (3))){
var inst_53152 = (state_53154[(2)]);
var state_53154__$1 = state_53154;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53154__$1,inst_53152);
} else {
if((state_val_53155 === (12))){
var inst_53129 = (state_53154[(7)]);
var inst_53130 = (state_53154[(9)]);
var inst_53123 = (state_53154[(10)]);
var inst_53142 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_53123,inst_53129);
var inst_53122 = inst_53130;
var inst_53123__$1 = inst_53142;
var state_53154__$1 = (function (){var statearr_53164 = state_53154;
(statearr_53164[(8)] = inst_53122);

(statearr_53164[(10)] = inst_53123__$1);

return statearr_53164;
})();
var statearr_53165_53190 = state_53154__$1;
(statearr_53165_53190[(2)] = null);

(statearr_53165_53190[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53155 === (2))){
var _ = (function (){var statearr_53166 = state_53154;
(statearr_53166[(4)] = cljs.core.cons((5),(state_53154[(4)])));

return statearr_53166;
})();
var inst_53117 = args;
var inst_53118 = cljs.core.seq(inst_53117);
var inst_53119 = cljs.core.first(inst_53118);
var inst_53120 = cljs.core.next(inst_53118);
var inst_53121 = cljs.core.PersistentVector.EMPTY;
var inst_53122 = inst_53117;
var inst_53123 = inst_53121;
var state_53154__$1 = (function (){var statearr_53167 = state_53154;
(statearr_53167[(11)] = inst_53119);

(statearr_53167[(8)] = inst_53122);

(statearr_53167[(10)] = inst_53123);

(statearr_53167[(12)] = inst_53120);

return statearr_53167;
})();
var statearr_53168_53191 = state_53154__$1;
(statearr_53168_53191[(2)] = null);

(statearr_53168_53191[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53155 === (11))){
var inst_53129 = (state_53154[(7)]);
var state_53154__$1 = state_53154;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53154__$1,(14),inst_53129);
} else {
if((state_val_53155 === (9))){
var inst_53129 = (state_53154[(7)]);
var inst_53134 = fluree.db.util.async.channel_QMARK_(inst_53129);
var state_53154__$1 = state_53154;
if(inst_53134){
var statearr_53170_53192 = state_53154__$1;
(statearr_53170_53192[(1)] = (11));

} else {
var statearr_53171_53193 = state_53154__$1;
(statearr_53171_53193[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53155 === (5))){
var _ = (function (){var statearr_53172 = state_53154;
(statearr_53172[(4)] = cljs.core.rest((state_53154[(4)])));

return statearr_53172;
})();
var state_53154__$1 = state_53154;
var ex53169 = (state_53154__$1[(2)]);
var statearr_53173_53194 = state_53154__$1;
(statearr_53173_53194[(5)] = ex53169);


if((ex53169 instanceof Error)){
var statearr_53174_53195 = state_53154__$1;
(statearr_53174_53195[(1)] = (4));

(statearr_53174_53195[(5)] = null);

} else {
throw ex53169;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53155 === (14))){
var inst_53130 = (state_53154[(9)]);
var inst_53123 = (state_53154[(10)]);
var inst_53137 = (state_53154[(2)]);
var inst_53138 = fluree.db.util.async.throw_err(inst_53137);
var inst_53139 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_53123,inst_53138);
var inst_53122 = inst_53130;
var inst_53123__$1 = inst_53139;
var state_53154__$1 = (function (){var statearr_53175 = state_53154;
(statearr_53175[(8)] = inst_53122);

(statearr_53175[(10)] = inst_53123__$1);

return statearr_53175;
})();
var statearr_53176_53196 = state_53154__$1;
(statearr_53176_53196[(2)] = null);

(statearr_53176_53196[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53155 === (10))){
var inst_53147 = (state_53154[(2)]);
var state_53154__$1 = state_53154;
var statearr_53177_53197 = state_53154__$1;
(statearr_53177_53197[(2)] = inst_53147);

(statearr_53177_53197[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53155 === (8))){
var inst_53123 = (state_53154[(10)]);
var state_53154__$1 = state_53154;
var statearr_53178_53198 = state_53154__$1;
(statearr_53178_53198[(2)] = inst_53123);

(statearr_53178_53198[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2717__auto____0 = (function (){
var statearr_53179 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_53179[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2717__auto__);

(statearr_53179[(1)] = (1));

return statearr_53179;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2717__auto____1 = (function (state_53154){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_53154);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e53180){var ex__2720__auto__ = e53180;
var statearr_53181_53199 = state_53154;
(statearr_53181_53199[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_53154[(4)]))){
var statearr_53182_53200 = state_53154;
(statearr_53182_53200[(1)] = cljs.core.first((state_53154[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53201 = state_53154;
state_53154 = G__53201;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2717__auto__ = function(state_53154){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2717__auto____1.call(this,state_53154);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_53183 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_53183[(6)] = c__2739__auto__);

return statearr_53183;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__53202 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53202,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53202,(1),null);
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Smart function stack: ",res], 0));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(s),entry),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"credits","credits",785860820).cljs$core$IFn$_invoke$arity$1(s),cost], 0)),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"spent","spent",-62769180).cljs$core$IFn$_invoke$arity$1(s),cost], 0))], 0));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_53250){
var state_val_53251 = (state_53250[(1)]);
if((state_val_53251 === (7))){
var state_53250__$1 = state_53250;
var statearr_53252_53281 = state_53250__$1;
(statearr_53252_53281[(2)] = coll);

(statearr_53252_53281[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (1))){
var state_53250__$1 = state_53250;
var statearr_53253_53282 = state_53250__$1;
(statearr_53253_53282[(2)] = null);

(statearr_53253_53282[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (4))){
var inst_53205 = (state_53250[(2)]);
var state_53250__$1 = state_53250;
var statearr_53254_53283 = state_53250__$1;
(statearr_53254_53283[(2)] = inst_53205);

(statearr_53254_53283[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (15))){
var inst_53224 = (state_53250[(7)]);
var inst_53232 = (state_53250[(2)]);
var inst_53233 = fluree.db.dbfunctions.internal.nth(inst_53224,inst_53232);
var inst_53234 = cljs.core.count(inst_53224);
var inst_53235 = ((9) + inst_53234);
var inst_53236 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53237 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53238 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53239 = [inst_53224,inst_53232];
var inst_53240 = (new cljs.core.PersistentVector(null,2,(5),inst_53238,inst_53239,null));
var inst_53241 = ["nth",inst_53240,inst_53233];
var inst_53242 = cljs.core.PersistentHashMap.fromArrays(inst_53237,inst_53241);
var inst_53243 = [inst_53242,inst_53235];
var inst_53244 = (new cljs.core.PersistentVector(null,2,(5),inst_53236,inst_53243,null));
var inst_53245 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53244);
var _ = (function (){var statearr_53255 = state_53250;
(statearr_53255[(4)] = cljs.core.rest((state_53250[(4)])));

return statearr_53255;
})();
var state_53250__$1 = (function (){var statearr_53256 = state_53250;
(statearr_53256[(8)] = inst_53245);

return statearr_53256;
})();
var statearr_53257_53284 = state_53250__$1;
(statearr_53257_53284[(2)] = inst_53233);

(statearr_53257_53284[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (13))){
var state_53250__$1 = state_53250;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53250__$1,(16),key);
} else {
if((state_val_53251 === (6))){
var state_53250__$1 = state_53250;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53250__$1,(9),coll);
} else {
if((state_val_53251 === (3))){
var inst_53248 = (state_53250[(2)]);
var state_53250__$1 = state_53250;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53250__$1,inst_53248);
} else {
if((state_val_53251 === (12))){
var inst_53224 = (state_53250[(2)]);
var inst_53225 = fluree.db.util.async.channel_QMARK_(key);
var state_53250__$1 = (function (){var statearr_53258 = state_53250;
(statearr_53258[(7)] = inst_53224);

return statearr_53258;
})();
if(inst_53225){
var statearr_53259_53285 = state_53250__$1;
(statearr_53259_53285[(1)] = (13));

} else {
var statearr_53260_53286 = state_53250__$1;
(statearr_53260_53286[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (2))){
var _ = (function (){var statearr_53261 = state_53250;
(statearr_53261[(4)] = cljs.core.cons((5),(state_53250[(4)])));

return statearr_53261;
})();
var inst_53211 = fluree.db.util.async.channel_QMARK_(coll);
var state_53250__$1 = state_53250;
if(inst_53211){
var statearr_53262_53287 = state_53250__$1;
(statearr_53262_53287[(1)] = (6));

} else {
var statearr_53263_53288 = state_53250__$1;
(statearr_53263_53288[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (11))){
var inst_53218 = (state_53250[(9)]);
var state_53250__$1 = state_53250;
var statearr_53265_53289 = state_53250__$1;
(statearr_53265_53289[(2)] = inst_53218);

(statearr_53265_53289[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (9))){
var inst_53214 = (state_53250[(2)]);
var inst_53215 = fluree.db.util.async.throw_err(inst_53214);
var state_53250__$1 = state_53250;
var statearr_53266_53290 = state_53250__$1;
(statearr_53266_53290[(2)] = inst_53215);

(statearr_53266_53290[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (5))){
var _ = (function (){var statearr_53267 = state_53250;
(statearr_53267[(4)] = cljs.core.rest((state_53250[(4)])));

return statearr_53267;
})();
var state_53250__$1 = state_53250;
var ex53264 = (state_53250__$1[(2)]);
var statearr_53268_53291 = state_53250__$1;
(statearr_53268_53291[(5)] = ex53264);


if((ex53264 instanceof Error)){
var statearr_53269_53292 = state_53250__$1;
(statearr_53269_53292[(1)] = (4));

(statearr_53269_53292[(5)] = null);

} else {
throw ex53264;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (14))){
var state_53250__$1 = state_53250;
var statearr_53270_53293 = state_53250__$1;
(statearr_53270_53293[(2)] = key);

(statearr_53270_53293[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (16))){
var inst_53228 = (state_53250[(2)]);
var inst_53229 = fluree.db.util.async.throw_err(inst_53228);
var state_53250__$1 = state_53250;
var statearr_53271_53294 = state_53250__$1;
(statearr_53271_53294[(2)] = inst_53229);

(statearr_53271_53294[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (10))){
var inst_53218 = (state_53250[(9)]);
var inst_53221 = cljs.core.vec(inst_53218);
var state_53250__$1 = state_53250;
var statearr_53272_53295 = state_53250__$1;
(statearr_53272_53295[(2)] = inst_53221);

(statearr_53272_53295[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53251 === (8))){
var inst_53218 = (state_53250[(9)]);
var inst_53218__$1 = (state_53250[(2)]);
var inst_53219 = cljs.core.set_QMARK_(inst_53218__$1);
var state_53250__$1 = (function (){var statearr_53273 = state_53250;
(statearr_53273[(9)] = inst_53218__$1);

return statearr_53273;
})();
if(inst_53219){
var statearr_53274_53296 = state_53250__$1;
(statearr_53274_53296[(1)] = (10));

} else {
var statearr_53275_53297 = state_53250__$1;
(statearr_53275_53297[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__2717__auto____0 = (function (){
var statearr_53276 = [null,null,null,null,null,null,null,null,null,null];
(statearr_53276[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__2717__auto__);

(statearr_53276[(1)] = (1));

return statearr_53276;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__2717__auto____1 = (function (state_53250){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_53250);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e53277){var ex__2720__auto__ = e53277;
var statearr_53278_53298 = state_53250;
(statearr_53278_53298[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_53250[(4)]))){
var statearr_53279_53299 = state_53250;
(statearr_53279_53299[(1)] = cljs.core.first((state_53250[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53300 = state_53250;
state_53250 = G__53300;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__2717__auto__ = function(state_53250){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2717__auto____1.call(this,state_53250);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_53280 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_53280[(6)] = c__2739__auto__);

return statearr_53280;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_53361){
var state_val_53362 = (state_53361[(1)]);
if((state_val_53362 === (7))){
var state_53361__$1 = state_53361;
var statearr_53363_53397 = state_53361__$1;
(statearr_53363_53397[(2)] = test);

(statearr_53363_53397[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53362 === (20))){
var inst_53335 = (state_53361[(2)]);
var inst_53336 = fluree.db.util.async.throw_err(inst_53335);
var state_53361__$1 = state_53361;
var statearr_53364_53398 = state_53361__$1;
(statearr_53364_53398[(2)] = inst_53336);

(statearr_53364_53398[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53362 === (1))){
var state_53361__$1 = state_53361;
var statearr_53365_53399 = state_53361__$1;
(statearr_53365_53399[(2)] = null);

(statearr_53365_53399[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53362 === (4))){
var inst_53301 = (state_53361[(2)]);
var state_53361__$1 = state_53361;
var statearr_53366_53400 = state_53361__$1;
(statearr_53366_53400[(2)] = inst_53301);

(statearr_53366_53400[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53362 === (15))){
var inst_53319 = (state_53361[(7)]);
var inst_53327 = (state_53361[(2)]);
var inst_53328 = [inst_53327,f];
var inst_53329 = (new cljs.core.PersistentVector(null,2,(5),inst_53319,inst_53328,null));
var state_53361__$1 = state_53361;
var statearr_53367_53401 = state_53361__$1;
(statearr_53367_53401[(2)] = inst_53329);

(statearr_53367_53401[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53362 === (13))){
var state_53361__$1 = state_53361;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53361__$1,(16),t);
} else {
if((state_val_53362 === (6))){
var state_53361__$1 = state_53361;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53361__$1,(9),test);
} else {
if((state_val_53362 === (17))){
var state_53361__$1 = state_53361;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53361__$1,(20),f);
} else {
if((state_val_53362 === (3))){
var inst_53359 = (state_53361[(2)]);
var state_53361__$1 = state_53361;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53361__$1,inst_53359);
} else {
if((state_val_53362 === (12))){
var inst_53317 = (state_53361[(8)]);
var inst_53343 = (state_53361[(2)]);
var inst_53344 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53343,(0),null);
var inst_53345 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53343,(1),null);
var inst_53346 = fluree.db.dbfunctions.internal.if_else(inst_53317,inst_53344,inst_53345);
var inst_53347 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53348 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53349 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53350 = [inst_53317,inst_53344,inst_53345];
var inst_53351 = (new cljs.core.PersistentVector(null,3,(5),inst_53349,inst_53350,null));
var inst_53352 = ["if-else",inst_53351,inst_53346];
var inst_53353 = cljs.core.PersistentHashMap.fromArrays(inst_53348,inst_53352);
var inst_53354 = [inst_53353,(10)];
var inst_53355 = (new cljs.core.PersistentVector(null,2,(5),inst_53347,inst_53354,null));
var inst_53356 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53355);
var _ = (function (){var statearr_53368 = state_53361;
(statearr_53368[(4)] = cljs.core.rest((state_53361[(4)])));

return statearr_53368;
})();
var state_53361__$1 = (function (){var statearr_53369 = state_53361;
(statearr_53369[(9)] = inst_53356);

return statearr_53369;
})();
var statearr_53370_53402 = state_53361__$1;
(statearr_53370_53402[(2)] = inst_53346);

(statearr_53370_53402[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53362 === (2))){
var _ = (function (){var statearr_53371 = state_53361;
(statearr_53371[(4)] = cljs.core.cons((5),(state_53361[(4)])));

return statearr_53371;
})();
var inst_53310 = fluree.db.util.async.channel_QMARK_(test);
var state_53361__$1 = state_53361;
if(inst_53310){
var statearr_53372_53403 = state_53361__$1;
(statearr_53372_53403[(1)] = (6));

} else {
var statearr_53373_53404 = state_53361__$1;
(statearr_53373_53404[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53362 === (19))){
var inst_53331 = (state_53361[(10)]);
var inst_53339 = (state_53361[(2)]);
var inst_53340 = [f,inst_53339];
var inst_53341 = (new cljs.core.PersistentVector(null,2,(5),inst_53331,inst_53340,null));
var state_53361__$1 = state_53361;
var statearr_53374_53405 = state_53361__$1;
(statearr_53374_53405[(2)] = inst_53341);

(statearr_53374_53405[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53362 === (11))){
var inst_53331 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53332 = fluree.db.util.async.channel_QMARK_(f);
var state_53361__$1 = (function (){var statearr_53376 = state_53361;
(statearr_53376[(10)] = inst_53331);

return statearr_53376;
})();
if(inst_53332){
var statearr_53377_53406 = state_53361__$1;
(statearr_53377_53406[(1)] = (17));

} else {
var statearr_53378_53407 = state_53361__$1;
(statearr_53378_53407[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53362 === (9))){
var inst_53313 = (state_53361[(2)]);
var inst_53314 = fluree.db.util.async.throw_err(inst_53313);
var state_53361__$1 = state_53361;
var statearr_53379_53408 = state_53361__$1;
(statearr_53379_53408[(2)] = inst_53314);

(statearr_53379_53408[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53362 === (5))){
var _ = (function (){var statearr_53380 = state_53361;
(statearr_53380[(4)] = cljs.core.rest((state_53361[(4)])));

return statearr_53380;
})();
var state_53361__$1 = state_53361;
var ex53375 = (state_53361__$1[(2)]);
var statearr_53381_53409 = state_53361__$1;
(statearr_53381_53409[(5)] = ex53375);


if((ex53375 instanceof Error)){
var statearr_53382_53410 = state_53361__$1;
(statearr_53382_53410[(1)] = (4));

(statearr_53382_53410[(5)] = null);

} else {
throw ex53375;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53362 === (14))){
var state_53361__$1 = state_53361;
var statearr_53383_53411 = state_53361__$1;
(statearr_53383_53411[(2)] = t);

(statearr_53383_53411[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53362 === (16))){
var inst_53323 = (state_53361[(2)]);
var inst_53324 = fluree.db.util.async.throw_err(inst_53323);
var state_53361__$1 = state_53361;
var statearr_53384_53412 = state_53361__$1;
(statearr_53384_53412[(2)] = inst_53324);

(statearr_53384_53412[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53362 === (10))){
var inst_53319 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53320 = fluree.db.util.async.channel_QMARK_(t);
var state_53361__$1 = (function (){var statearr_53385 = state_53361;
(statearr_53385[(7)] = inst_53319);

return statearr_53385;
})();
if(inst_53320){
var statearr_53386_53413 = state_53361__$1;
(statearr_53386_53413[(1)] = (13));

} else {
var statearr_53387_53414 = state_53361__$1;
(statearr_53387_53414[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53362 === (18))){
var state_53361__$1 = state_53361;
var statearr_53388_53415 = state_53361__$1;
(statearr_53388_53415[(2)] = f);

(statearr_53388_53415[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53362 === (8))){
var inst_53317 = (state_53361[(8)]);
var inst_53317__$1 = (state_53361[(2)]);
var state_53361__$1 = (function (){var statearr_53389 = state_53361;
(statearr_53389[(8)] = inst_53317__$1);

return statearr_53389;
})();
if(cljs.core.truth_(inst_53317__$1)){
var statearr_53390_53416 = state_53361__$1;
(statearr_53390_53416[(1)] = (10));

} else {
var statearr_53391_53417 = state_53361__$1;
(statearr_53391_53417[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2717__auto____0 = (function (){
var statearr_53392 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_53392[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__2717__auto__);

(statearr_53392[(1)] = (1));

return statearr_53392;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2717__auto____1 = (function (state_53361){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_53361);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e53393){var ex__2720__auto__ = e53393;
var statearr_53394_53418 = state_53361;
(statearr_53394_53418[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_53361[(4)]))){
var statearr_53395_53419 = state_53361;
(statearr_53395_53419[(1)] = cljs.core.first((state_53361[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53420 = state_53361;
state_53361 = G__53420;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__2717__auto__ = function(state_53361){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2717__auto____1.call(this,state_53361);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_53396 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_53396[(6)] = c__2739__auto__);

return statearr_53396;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_53450){
var state_val_53451 = (state_53450[(1)]);
if((state_val_53451 === (7))){
var state_53450__$1 = state_53450;
var statearr_53452_53471 = state_53450__$1;
(statearr_53452_53471[(2)] = arg);

(statearr_53452_53471[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53451 === (1))){
var state_53450__$1 = state_53450;
var statearr_53453_53472 = state_53450__$1;
(statearr_53453_53472[(2)] = null);

(statearr_53453_53472[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53451 === (4))){
var inst_53421 = (state_53450[(2)]);
var state_53450__$1 = state_53450;
var statearr_53454_53473 = state_53450__$1;
(statearr_53454_53473[(2)] = inst_53421);

(statearr_53454_53473[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53451 === (6))){
var state_53450__$1 = state_53450;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53450__$1,(9),arg);
} else {
if((state_val_53451 === (3))){
var inst_53448 = (state_53450[(2)]);
var state_53450__$1 = state_53450;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53450__$1,inst_53448);
} else {
if((state_val_53451 === (2))){
var _ = (function (){var statearr_53456 = state_53450;
(statearr_53456[(4)] = cljs.core.cons((5),(state_53450[(4)])));

return statearr_53456;
})();
var inst_53427 = fluree.db.util.async.channel_QMARK_(arg);
var state_53450__$1 = state_53450;
if(inst_53427){
var statearr_53457_53474 = state_53450__$1;
(statearr_53457_53474[(1)] = (6));

} else {
var statearr_53458_53475 = state_53450__$1;
(statearr_53458_53475[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53451 === (9))){
var inst_53430 = (state_53450[(2)]);
var inst_53431 = fluree.db.util.async.throw_err(inst_53430);
var state_53450__$1 = state_53450;
var statearr_53459_53476 = state_53450__$1;
(statearr_53459_53476[(2)] = inst_53431);

(statearr_53459_53476[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53451 === (5))){
var _ = (function (){var statearr_53460 = state_53450;
(statearr_53460[(4)] = cljs.core.rest((state_53450[(4)])));

return statearr_53460;
})();
var state_53450__$1 = state_53450;
var ex53455 = (state_53450__$1[(2)]);
var statearr_53461_53477 = state_53450__$1;
(statearr_53461_53477[(5)] = ex53455);


if((ex53455 instanceof Error)){
var statearr_53462_53478 = state_53450__$1;
(statearr_53462_53478[(1)] = (4));

(statearr_53462_53478[(5)] = null);

} else {
throw ex53455;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53451 === (8))){
var inst_53434 = (state_53450[(2)]);
var inst_53435 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_53434);
var inst_53436 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53437 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53438 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53439 = [inst_53434];
var inst_53440 = (new cljs.core.PersistentVector(null,1,(5),inst_53438,inst_53439,null));
var inst_53441 = ["nil?",inst_53440,inst_53435];
var inst_53442 = cljs.core.PersistentHashMap.fromArrays(inst_53437,inst_53441);
var inst_53443 = [inst_53442,(10)];
var inst_53444 = (new cljs.core.PersistentVector(null,2,(5),inst_53436,inst_53443,null));
var inst_53445 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53444);
var _ = (function (){var statearr_53463 = state_53450;
(statearr_53463[(4)] = cljs.core.rest((state_53450[(4)])));

return statearr_53463;
})();
var state_53450__$1 = (function (){var statearr_53464 = state_53450;
(statearr_53464[(7)] = inst_53445);

return statearr_53464;
})();
var statearr_53465_53479 = state_53450__$1;
(statearr_53465_53479[(2)] = inst_53435);

(statearr_53465_53479[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2717__auto____0 = (function (){
var statearr_53466 = [null,null,null,null,null,null,null,null];
(statearr_53466[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2717__auto__);

(statearr_53466[(1)] = (1));

return statearr_53466;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2717__auto____1 = (function (state_53450){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_53450);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e53467){var ex__2720__auto__ = e53467;
var statearr_53468_53480 = state_53450;
(statearr_53468_53480[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_53450[(4)]))){
var statearr_53469_53481 = state_53450;
(statearr_53469_53481[(1)] = cljs.core.first((state_53450[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53482 = state_53450;
state_53450 = G__53482;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2717__auto__ = function(state_53450){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2717__auto____1.call(this,state_53450);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_53470 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_53470[(6)] = c__2739__auto__);

return statearr_53470;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_53512){
var state_val_53513 = (state_53512[(1)]);
if((state_val_53513 === (7))){
var state_53512__$1 = state_53512;
var statearr_53514_53533 = state_53512__$1;
(statearr_53514_53533[(2)] = arg);

(statearr_53514_53533[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53513 === (1))){
var state_53512__$1 = state_53512;
var statearr_53515_53534 = state_53512__$1;
(statearr_53515_53534[(2)] = null);

(statearr_53515_53534[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53513 === (4))){
var inst_53483 = (state_53512[(2)]);
var state_53512__$1 = state_53512;
var statearr_53516_53535 = state_53512__$1;
(statearr_53516_53535[(2)] = inst_53483);

(statearr_53516_53535[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53513 === (6))){
var state_53512__$1 = state_53512;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53512__$1,(9),arg);
} else {
if((state_val_53513 === (3))){
var inst_53510 = (state_53512[(2)]);
var state_53512__$1 = state_53512;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53512__$1,inst_53510);
} else {
if((state_val_53513 === (2))){
var _ = (function (){var statearr_53518 = state_53512;
(statearr_53518[(4)] = cljs.core.cons((5),(state_53512[(4)])));

return statearr_53518;
})();
var inst_53489 = fluree.db.util.async.channel_QMARK_(arg);
var state_53512__$1 = state_53512;
if(inst_53489){
var statearr_53519_53536 = state_53512__$1;
(statearr_53519_53536[(1)] = (6));

} else {
var statearr_53520_53537 = state_53512__$1;
(statearr_53520_53537[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53513 === (9))){
var inst_53492 = (state_53512[(2)]);
var inst_53493 = fluree.db.util.async.throw_err(inst_53492);
var state_53512__$1 = state_53512;
var statearr_53521_53538 = state_53512__$1;
(statearr_53521_53538[(2)] = inst_53493);

(statearr_53521_53538[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53513 === (5))){
var _ = (function (){var statearr_53522 = state_53512;
(statearr_53522[(4)] = cljs.core.rest((state_53512[(4)])));

return statearr_53522;
})();
var state_53512__$1 = state_53512;
var ex53517 = (state_53512__$1[(2)]);
var statearr_53523_53539 = state_53512__$1;
(statearr_53523_53539[(5)] = ex53517);


if((ex53517 instanceof Error)){
var statearr_53524_53540 = state_53512__$1;
(statearr_53524_53540[(1)] = (4));

(statearr_53524_53540[(5)] = null);

} else {
throw ex53517;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53513 === (8))){
var inst_53496 = (state_53512[(2)]);
var inst_53497 = fluree.db.dbfunctions.internal.not(inst_53496);
var inst_53498 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53499 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53500 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53501 = [inst_53496];
var inst_53502 = (new cljs.core.PersistentVector(null,1,(5),inst_53500,inst_53501,null));
var inst_53503 = ["not?",inst_53502,inst_53497];
var inst_53504 = cljs.core.PersistentHashMap.fromArrays(inst_53499,inst_53503);
var inst_53505 = [inst_53504,(10)];
var inst_53506 = (new cljs.core.PersistentVector(null,2,(5),inst_53498,inst_53505,null));
var inst_53507 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53506);
var _ = (function (){var statearr_53525 = state_53512;
(statearr_53525[(4)] = cljs.core.rest((state_53512[(4)])));

return statearr_53525;
})();
var state_53512__$1 = (function (){var statearr_53526 = state_53512;
(statearr_53526[(7)] = inst_53507);

return statearr_53526;
})();
var statearr_53527_53541 = state_53512__$1;
(statearr_53527_53541[(2)] = inst_53497);

(statearr_53527_53541[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__2717__auto____0 = (function (){
var statearr_53528 = [null,null,null,null,null,null,null,null];
(statearr_53528[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__2717__auto__);

(statearr_53528[(1)] = (1));

return statearr_53528;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__2717__auto____1 = (function (state_53512){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_53512);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e53529){var ex__2720__auto__ = e53529;
var statearr_53530_53542 = state_53512;
(statearr_53530_53542[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_53512[(4)]))){
var statearr_53531_53543 = state_53512;
(statearr_53531_53543[(1)] = cljs.core.first((state_53512[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53544 = state_53512;
state_53512 = G__53544;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__2717__auto__ = function(state_53512){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__2717__auto____1.call(this,state_53512);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_53532 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_53532[(6)] = c__2739__auto__);

return statearr_53532;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_53574){
var state_val_53575 = (state_53574[(1)]);
if((state_val_53575 === (7))){
var state_53574__$1 = state_53574;
var statearr_53576_53595 = state_53574__$1;
(statearr_53576_53595[(2)] = arg);

(statearr_53576_53595[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53575 === (1))){
var state_53574__$1 = state_53574;
var statearr_53577_53596 = state_53574__$1;
(statearr_53577_53596[(2)] = null);

(statearr_53577_53596[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53575 === (4))){
var inst_53545 = (state_53574[(2)]);
var state_53574__$1 = state_53574;
var statearr_53578_53597 = state_53574__$1;
(statearr_53578_53597[(2)] = inst_53545);

(statearr_53578_53597[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53575 === (6))){
var state_53574__$1 = state_53574;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53574__$1,(9),arg);
} else {
if((state_val_53575 === (3))){
var inst_53572 = (state_53574[(2)]);
var state_53574__$1 = state_53574;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53574__$1,inst_53572);
} else {
if((state_val_53575 === (2))){
var _ = (function (){var statearr_53580 = state_53574;
(statearr_53580[(4)] = cljs.core.cons((5),(state_53574[(4)])));

return statearr_53580;
})();
var inst_53551 = fluree.db.util.async.channel_QMARK_(arg);
var state_53574__$1 = state_53574;
if(inst_53551){
var statearr_53581_53598 = state_53574__$1;
(statearr_53581_53598[(1)] = (6));

} else {
var statearr_53582_53599 = state_53574__$1;
(statearr_53582_53599[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53575 === (9))){
var inst_53554 = (state_53574[(2)]);
var inst_53555 = fluree.db.util.async.throw_err(inst_53554);
var state_53574__$1 = state_53574;
var statearr_53583_53600 = state_53574__$1;
(statearr_53583_53600[(2)] = inst_53555);

(statearr_53583_53600[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53575 === (5))){
var _ = (function (){var statearr_53584 = state_53574;
(statearr_53584[(4)] = cljs.core.rest((state_53574[(4)])));

return statearr_53584;
})();
var state_53574__$1 = state_53574;
var ex53579 = (state_53574__$1[(2)]);
var statearr_53585_53601 = state_53574__$1;
(statearr_53585_53601[(5)] = ex53579);


if((ex53579 instanceof Error)){
var statearr_53586_53602 = state_53574__$1;
(statearr_53586_53602[(1)] = (4));

(statearr_53586_53602[(5)] = null);

} else {
throw ex53579;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53575 === (8))){
var inst_53558 = (state_53574[(2)]);
var inst_53559 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_53558);
var inst_53560 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53561 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53562 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53563 = [inst_53558];
var inst_53564 = (new cljs.core.PersistentVector(null,1,(5),inst_53562,inst_53563,null));
var inst_53565 = ["empty?",inst_53564,inst_53559];
var inst_53566 = cljs.core.PersistentHashMap.fromArrays(inst_53561,inst_53565);
var inst_53567 = [inst_53566,(10)];
var inst_53568 = (new cljs.core.PersistentVector(null,2,(5),inst_53560,inst_53567,null));
var inst_53569 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53568);
var _ = (function (){var statearr_53587 = state_53574;
(statearr_53587[(4)] = cljs.core.rest((state_53574[(4)])));

return statearr_53587;
})();
var state_53574__$1 = (function (){var statearr_53588 = state_53574;
(statearr_53588[(7)] = inst_53569);

return statearr_53588;
})();
var statearr_53589_53603 = state_53574__$1;
(statearr_53589_53603[(2)] = inst_53559);

(statearr_53589_53603[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2717__auto____0 = (function (){
var statearr_53590 = [null,null,null,null,null,null,null,null];
(statearr_53590[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2717__auto__);

(statearr_53590[(1)] = (1));

return statearr_53590;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2717__auto____1 = (function (state_53574){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_53574);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e53591){var ex__2720__auto__ = e53591;
var statearr_53592_53604 = state_53574;
(statearr_53592_53604[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_53574[(4)]))){
var statearr_53593_53605 = state_53574;
(statearr_53593_53605[(1)] = cljs.core.first((state_53574[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53606 = state_53574;
state_53574 = G__53606;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2717__auto__ = function(state_53574){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2717__auto____1.call(this,state_53574);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_53594 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_53594[(6)] = c__2739__auto__);

return statearr_53594;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4824__auto__ = [];
var len__4818__auto___53651 = arguments.length;
var i__4819__auto___53652 = (0);
while(true){
if((i__4819__auto___53652 < len__4818__auto___53651)){
args__4824__auto__.push((arguments[i__4819__auto___53652]));

var G__53653 = (i__4819__auto___53652 + (1));
i__4819__auto___53652 = G__53653;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_53634){
var state_val_53635 = (state_53634[(1)]);
if((state_val_53635 === (1))){
var state_53634__$1 = state_53634;
var statearr_53636_53654 = state_53634__$1;
(statearr_53636_53654[(2)] = null);

(statearr_53636_53654[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53635 === (2))){
var _ = (function (){var statearr_53637 = state_53634;
(statearr_53637[(4)] = cljs.core.cons((5),(state_53634[(4)])));

return statearr_53637;
})();
var inst_53615 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_53634__$1 = state_53634;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53634__$1,(6),inst_53615);
} else {
if((state_val_53635 === (3))){
var inst_53632 = (state_53634[(2)]);
var state_53634__$1 = state_53634;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53634__$1,inst_53632);
} else {
if((state_val_53635 === (4))){
var inst_53609 = (state_53634[(2)]);
var state_53634__$1 = state_53634;
var statearr_53639_53655 = state_53634__$1;
(statearr_53639_53655[(2)] = inst_53609);

(statearr_53639_53655[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53635 === (5))){
var _ = (function (){var statearr_53640 = state_53634;
(statearr_53640[(4)] = cljs.core.rest((state_53634[(4)])));

return statearr_53640;
})();
var state_53634__$1 = state_53634;
var ex53638 = (state_53634__$1[(2)]);
var statearr_53641_53656 = state_53634__$1;
(statearr_53641_53656[(5)] = ex53638);


if((ex53638 instanceof Error)){
var statearr_53642_53657 = state_53634__$1;
(statearr_53642_53657[(1)] = (4));

(statearr_53642_53657[(5)] = null);

} else {
throw ex53638;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53635 === (6))){
var inst_53617 = (state_53634[(2)]);
var inst_53618 = fluree.db.util.async.throw_err(inst_53617);
var inst_53619 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_53618);
var inst_53620 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53621 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53622 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53623 = [inst_53618];
var inst_53624 = (new cljs.core.PersistentVector(null,1,(5),inst_53622,inst_53623,null));
var inst_53625 = ["str",inst_53624,inst_53619];
var inst_53626 = cljs.core.PersistentHashMap.fromArrays(inst_53621,inst_53625);
var inst_53627 = [inst_53626,(10)];
var inst_53628 = (new cljs.core.PersistentVector(null,2,(5),inst_53620,inst_53627,null));
var inst_53629 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53628);
var _ = (function (){var statearr_53643 = state_53634;
(statearr_53643[(4)] = cljs.core.rest((state_53634[(4)])));

return statearr_53643;
})();
var state_53634__$1 = (function (){var statearr_53644 = state_53634;
(statearr_53644[(7)] = inst_53629);

return statearr_53644;
})();
var statearr_53645_53658 = state_53634__$1;
(statearr_53645_53658[(2)] = inst_53619);

(statearr_53645_53658[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2717__auto____0 = (function (){
var statearr_53646 = [null,null,null,null,null,null,null,null];
(statearr_53646[(0)] = fluree$db$dbfunctions$fns$state_machine__2717__auto__);

(statearr_53646[(1)] = (1));

return statearr_53646;
});
var fluree$db$dbfunctions$fns$state_machine__2717__auto____1 = (function (state_53634){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_53634);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e53647){var ex__2720__auto__ = e53647;
var statearr_53648_53659 = state_53634;
(statearr_53648_53659[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_53634[(4)]))){
var statearr_53649_53660 = state_53634;
(statearr_53649_53660[(1)] = cljs.core.first((state_53634[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53661 = state_53634;
state_53634 = G__53661;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2717__auto__ = function(state_53634){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____1.call(this,state_53634);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_53650 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_53650[(6)] = c__2739__auto__);

return statearr_53650;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq53607){
var G__53608 = cljs.core.first(seq53607);
var seq53607__$1 = cljs.core.next(seq53607);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53608,seq53607__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_53687){
var state_val_53688 = (state_53687[(1)]);
if((state_val_53688 === (1))){
var state_53687__$1 = state_53687;
var statearr_53689_53704 = state_53687__$1;
(statearr_53689_53704[(2)] = null);

(statearr_53689_53704[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53688 === (2))){
var _ = (function (){var statearr_53690 = state_53687;
(statearr_53690[(4)] = cljs.core.cons((5),(state_53687[(4)])));

return statearr_53690;
})();
var inst_53668 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_53687__$1 = state_53687;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53687__$1,(6),inst_53668);
} else {
if((state_val_53688 === (3))){
var inst_53685 = (state_53687[(2)]);
var state_53687__$1 = state_53687;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53687__$1,inst_53685);
} else {
if((state_val_53688 === (4))){
var inst_53662 = (state_53687[(2)]);
var state_53687__$1 = state_53687;
var statearr_53692_53705 = state_53687__$1;
(statearr_53692_53705[(2)] = inst_53662);

(statearr_53692_53705[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53688 === (5))){
var _ = (function (){var statearr_53693 = state_53687;
(statearr_53693[(4)] = cljs.core.rest((state_53687[(4)])));

return statearr_53693;
})();
var state_53687__$1 = state_53687;
var ex53691 = (state_53687__$1[(2)]);
var statearr_53694_53706 = state_53687__$1;
(statearr_53694_53706[(5)] = ex53691);


if((ex53691 instanceof Error)){
var statearr_53695_53707 = state_53687__$1;
(statearr_53695_53707[(1)] = (4));

(statearr_53695_53707[(5)] = null);

} else {
throw ex53691;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53688 === (6))){
var inst_53670 = (state_53687[(2)]);
var inst_53671 = fluree.db.util.async.throw_err(inst_53670);
var inst_53672 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.subs,inst_53671);
var inst_53673 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53674 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53675 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53676 = [inst_53671];
var inst_53677 = (new cljs.core.PersistentVector(null,1,(5),inst_53675,inst_53676,null));
var inst_53678 = ["subs",inst_53677,inst_53672];
var inst_53679 = cljs.core.PersistentHashMap.fromArrays(inst_53674,inst_53678);
var inst_53680 = [inst_53679,(30)];
var inst_53681 = (new cljs.core.PersistentVector(null,2,(5),inst_53673,inst_53680,null));
var inst_53682 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53681);
var _ = (function (){var statearr_53696 = state_53687;
(statearr_53696[(4)] = cljs.core.rest((state_53687[(4)])));

return statearr_53696;
})();
var state_53687__$1 = (function (){var statearr_53697 = state_53687;
(statearr_53697[(7)] = inst_53682);

return statearr_53697;
})();
var statearr_53698_53708 = state_53687__$1;
(statearr_53698_53708[(2)] = inst_53672);

(statearr_53698_53708[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__2717__auto____0 = (function (){
var statearr_53699 = [null,null,null,null,null,null,null,null];
(statearr_53699[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__2717__auto__);

(statearr_53699[(1)] = (1));

return statearr_53699;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__2717__auto____1 = (function (state_53687){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_53687);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e53700){var ex__2720__auto__ = e53700;
var statearr_53701_53709 = state_53687;
(statearr_53701_53709[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_53687[(4)]))){
var statearr_53702_53710 = state_53687;
(statearr_53702_53710[(1)] = cljs.core.first((state_53687[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53711 = state_53687;
state_53687 = G__53711;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__2717__auto__ = function(state_53687){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2717__auto____1.call(this,state_53687);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_53703 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_53703[(6)] = c__2739__auto__);

return statearr_53703;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_53741){
var state_val_53742 = (state_53741[(1)]);
if((state_val_53742 === (7))){
var state_53741__$1 = state_53741;
var statearr_53743_53762 = state_53741__$1;
(statearr_53743_53762[(2)] = str);

(statearr_53743_53762[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53742 === (1))){
var state_53741__$1 = state_53741;
var statearr_53744_53763 = state_53741__$1;
(statearr_53744_53763[(2)] = null);

(statearr_53744_53763[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53742 === (4))){
var inst_53712 = (state_53741[(2)]);
var state_53741__$1 = state_53741;
var statearr_53745_53764 = state_53741__$1;
(statearr_53745_53764[(2)] = inst_53712);

(statearr_53745_53764[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53742 === (6))){
var state_53741__$1 = state_53741;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53741__$1,(9),str);
} else {
if((state_val_53742 === (3))){
var inst_53739 = (state_53741[(2)]);
var state_53741__$1 = state_53741;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53741__$1,inst_53739);
} else {
if((state_val_53742 === (2))){
var _ = (function (){var statearr_53747 = state_53741;
(statearr_53747[(4)] = cljs.core.cons((5),(state_53741[(4)])));

return statearr_53747;
})();
var inst_53718 = fluree.db.util.async.channel_QMARK_(str);
var state_53741__$1 = state_53741;
if(inst_53718){
var statearr_53748_53765 = state_53741__$1;
(statearr_53748_53765[(1)] = (6));

} else {
var statearr_53749_53766 = state_53741__$1;
(statearr_53749_53766[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53742 === (9))){
var inst_53721 = (state_53741[(2)]);
var inst_53722 = fluree.db.util.async.throw_err(inst_53721);
var state_53741__$1 = state_53741;
var statearr_53750_53767 = state_53741__$1;
(statearr_53750_53767[(2)] = inst_53722);

(statearr_53750_53767[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53742 === (5))){
var _ = (function (){var statearr_53751 = state_53741;
(statearr_53751[(4)] = cljs.core.rest((state_53741[(4)])));

return statearr_53751;
})();
var state_53741__$1 = state_53741;
var ex53746 = (state_53741__$1[(2)]);
var statearr_53752_53768 = state_53741__$1;
(statearr_53752_53768[(5)] = ex53746);


if((ex53746 instanceof Error)){
var statearr_53753_53769 = state_53741__$1;
(statearr_53753_53769[(1)] = (4));

(statearr_53753_53769[(5)] = null);

} else {
throw ex53746;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53742 === (8))){
var inst_53725 = (state_53741[(2)]);
var inst_53726 = fluree.db.dbfunctions.internal.lower_case(inst_53725);
var inst_53727 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53728 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53729 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53730 = [inst_53725];
var inst_53731 = (new cljs.core.PersistentVector(null,1,(5),inst_53729,inst_53730,null));
var inst_53732 = ["lower-case",inst_53731,inst_53726];
var inst_53733 = cljs.core.PersistentHashMap.fromArrays(inst_53728,inst_53732);
var inst_53734 = [inst_53733,(10)];
var inst_53735 = (new cljs.core.PersistentVector(null,2,(5),inst_53727,inst_53734,null));
var inst_53736 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53735);
var _ = (function (){var statearr_53754 = state_53741;
(statearr_53754[(4)] = cljs.core.rest((state_53741[(4)])));

return statearr_53754;
})();
var state_53741__$1 = (function (){var statearr_53755 = state_53741;
(statearr_53755[(7)] = inst_53736);

return statearr_53755;
})();
var statearr_53756_53770 = state_53741__$1;
(statearr_53756_53770[(2)] = inst_53726);

(statearr_53756_53770[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2717__auto____0 = (function (){
var statearr_53757 = [null,null,null,null,null,null,null,null];
(statearr_53757[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2717__auto__);

(statearr_53757[(1)] = (1));

return statearr_53757;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2717__auto____1 = (function (state_53741){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_53741);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e53758){var ex__2720__auto__ = e53758;
var statearr_53759_53771 = state_53741;
(statearr_53759_53771[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_53741[(4)]))){
var statearr_53760_53772 = state_53741;
(statearr_53760_53772[(1)] = cljs.core.first((state_53741[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53773 = state_53741;
state_53741 = G__53773;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2717__auto__ = function(state_53741){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2717__auto____1.call(this,state_53741);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_53761 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_53761[(6)] = c__2739__auto__);

return statearr_53761;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_53803){
var state_val_53804 = (state_53803[(1)]);
if((state_val_53804 === (7))){
var state_53803__$1 = state_53803;
var statearr_53805_53824 = state_53803__$1;
(statearr_53805_53824[(2)] = str);

(statearr_53805_53824[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53804 === (1))){
var state_53803__$1 = state_53803;
var statearr_53806_53825 = state_53803__$1;
(statearr_53806_53825[(2)] = null);

(statearr_53806_53825[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53804 === (4))){
var inst_53774 = (state_53803[(2)]);
var state_53803__$1 = state_53803;
var statearr_53807_53826 = state_53803__$1;
(statearr_53807_53826[(2)] = inst_53774);

(statearr_53807_53826[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53804 === (6))){
var state_53803__$1 = state_53803;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53803__$1,(9),str);
} else {
if((state_val_53804 === (3))){
var inst_53801 = (state_53803[(2)]);
var state_53803__$1 = state_53803;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53803__$1,inst_53801);
} else {
if((state_val_53804 === (2))){
var _ = (function (){var statearr_53809 = state_53803;
(statearr_53809[(4)] = cljs.core.cons((5),(state_53803[(4)])));

return statearr_53809;
})();
var inst_53780 = fluree.db.util.async.channel_QMARK_(str);
var state_53803__$1 = state_53803;
if(inst_53780){
var statearr_53810_53827 = state_53803__$1;
(statearr_53810_53827[(1)] = (6));

} else {
var statearr_53811_53828 = state_53803__$1;
(statearr_53811_53828[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53804 === (9))){
var inst_53783 = (state_53803[(2)]);
var inst_53784 = fluree.db.util.async.throw_err(inst_53783);
var state_53803__$1 = state_53803;
var statearr_53812_53829 = state_53803__$1;
(statearr_53812_53829[(2)] = inst_53784);

(statearr_53812_53829[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53804 === (5))){
var _ = (function (){var statearr_53813 = state_53803;
(statearr_53813[(4)] = cljs.core.rest((state_53803[(4)])));

return statearr_53813;
})();
var state_53803__$1 = state_53803;
var ex53808 = (state_53803__$1[(2)]);
var statearr_53814_53830 = state_53803__$1;
(statearr_53814_53830[(5)] = ex53808);


if((ex53808 instanceof Error)){
var statearr_53815_53831 = state_53803__$1;
(statearr_53815_53831[(1)] = (4));

(statearr_53815_53831[(5)] = null);

} else {
throw ex53808;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53804 === (8))){
var inst_53787 = (state_53803[(2)]);
var inst_53788 = fluree.db.dbfunctions.internal.upper_case(inst_53787);
var inst_53789 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53790 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53791 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53792 = [inst_53787];
var inst_53793 = (new cljs.core.PersistentVector(null,1,(5),inst_53791,inst_53792,null));
var inst_53794 = ["upper-case",inst_53793,inst_53788];
var inst_53795 = cljs.core.PersistentHashMap.fromArrays(inst_53790,inst_53794);
var inst_53796 = [inst_53795,(10)];
var inst_53797 = (new cljs.core.PersistentVector(null,2,(5),inst_53789,inst_53796,null));
var inst_53798 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53797);
var _ = (function (){var statearr_53816 = state_53803;
(statearr_53816[(4)] = cljs.core.rest((state_53803[(4)])));

return statearr_53816;
})();
var state_53803__$1 = (function (){var statearr_53817 = state_53803;
(statearr_53817[(7)] = inst_53798);

return statearr_53817;
})();
var statearr_53818_53832 = state_53803__$1;
(statearr_53818_53832[(2)] = inst_53788);

(statearr_53818_53832[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2717__auto____0 = (function (){
var statearr_53819 = [null,null,null,null,null,null,null,null];
(statearr_53819[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2717__auto__);

(statearr_53819[(1)] = (1));

return statearr_53819;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2717__auto____1 = (function (state_53803){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_53803);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e53820){var ex__2720__auto__ = e53820;
var statearr_53821_53833 = state_53803;
(statearr_53821_53833[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_53803[(4)]))){
var statearr_53822_53834 = state_53803;
(statearr_53822_53834[(1)] = cljs.core.first((state_53803[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53835 = state_53803;
state_53803 = G__53835;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2717__auto__ = function(state_53803){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2717__auto____1.call(this,state_53803);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_53823 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_53823[(6)] = c__2739__auto__);

return statearr_53823;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4210__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__4210__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__53837 = arguments.length;
switch (G__53837) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_53865){
var state_val_53866 = (state_53865[(1)]);
if((state_val_53866 === (1))){
var state_53865__$1 = state_53865;
var statearr_53867_53883 = state_53865__$1;
(statearr_53867_53883[(2)] = null);

(statearr_53867_53883[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53866 === (2))){
var _ = (function (){var statearr_53868 = state_53865;
(statearr_53868[(4)] = cljs.core.cons((5),(state_53865[(4)])));

return statearr_53868;
})();
var inst_53847 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_53865__$1 = state_53865;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53865__$1,(6),inst_53847);
} else {
if((state_val_53866 === (3))){
var inst_53863 = (state_53865[(2)]);
var state_53865__$1 = state_53865;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53865__$1,inst_53863);
} else {
if((state_val_53866 === (4))){
var inst_53838 = (state_53865[(2)]);
var state_53865__$1 = state_53865;
var statearr_53870_53884 = state_53865__$1;
(statearr_53870_53884[(2)] = inst_53838);

(statearr_53870_53884[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53866 === (5))){
var _ = (function (){var statearr_53871 = state_53865;
(statearr_53871[(4)] = cljs.core.rest((state_53865[(4)])));

return statearr_53871;
})();
var state_53865__$1 = state_53865;
var ex53869 = (state_53865__$1[(2)]);
var statearr_53872_53885 = state_53865__$1;
(statearr_53872_53885[(5)] = ex53869);


if((ex53869 instanceof Error)){
var statearr_53873_53886 = state_53865__$1;
(statearr_53873_53886[(1)] = (4));

(statearr_53873_53886[(5)] = null);

} else {
throw ex53869;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53866 === (6))){
var inst_53849 = (state_53865[(2)]);
var inst_53850 = fluree.db.util.async.throw_err(inst_53849);
var inst_53851 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53850,(0),null);
var inst_53852 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53850,(1),null);
var inst_53853 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53854 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53855 = ["?s","?ctx",inst_53851];
var inst_53856 = cljs.core.PersistentHashMap.fromArrays(inst_53854,inst_53855);
var inst_53857 = ((10) + inst_53852);
var inst_53858 = [inst_53856,inst_53857];
var inst_53859 = (new cljs.core.PersistentVector(null,2,(5),inst_53853,inst_53858,null));
var inst_53860 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53859);
var _ = (function (){var statearr_53874 = state_53865;
(statearr_53874[(4)] = cljs.core.rest((state_53865[(4)])));

return statearr_53874;
})();
var state_53865__$1 = (function (){var statearr_53875 = state_53865;
(statearr_53875[(7)] = inst_53860);

return statearr_53875;
})();
var statearr_53876_53887 = state_53865__$1;
(statearr_53876_53887[(2)] = inst_53851);

(statearr_53876_53887[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2717__auto____0 = (function (){
var statearr_53877 = [null,null,null,null,null,null,null,null];
(statearr_53877[(0)] = fluree$db$dbfunctions$fns$state_machine__2717__auto__);

(statearr_53877[(1)] = (1));

return statearr_53877;
});
var fluree$db$dbfunctions$fns$state_machine__2717__auto____1 = (function (state_53865){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_53865);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e53878){var ex__2720__auto__ = e53878;
var statearr_53879_53888 = state_53865;
(statearr_53879_53888[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_53865[(4)]))){
var statearr_53880_53889 = state_53865;
(statearr_53880_53889[(1)] = cljs.core.first((state_53865[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53890 = state_53865;
state_53865 = G__53890;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2717__auto__ = function(state_53865){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____1.call(this,state_53865);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_53881 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_53881[(6)] = c__2739__auto__);

return statearr_53881;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__53892 = arguments.length;
switch (G__53892) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_53930){
var state_val_53931 = (state_53930[(1)]);
if((state_val_53931 === (7))){
var inst_53923 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_53930__$1 = state_53930;
var statearr_53932_53952 = state_53930__$1;
(statearr_53932_53952[(2)] = inst_53923);

(statearr_53932_53952[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53931 === (1))){
var state_53930__$1 = state_53930;
var statearr_53933_53953 = state_53930__$1;
(statearr_53933_53953[(2)] = null);

(statearr_53933_53953[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53931 === (4))){
var inst_53893 = (state_53930[(2)]);
var state_53930__$1 = state_53930;
var statearr_53934_53954 = state_53930__$1;
(statearr_53934_53954[(2)] = inst_53893);

(statearr_53934_53954[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53931 === (6))){
var inst_53904 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_53930__$1 = state_53930;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53930__$1,(10),inst_53904);
} else {
if((state_val_53931 === (3))){
var inst_53928 = (state_53930[(2)]);
var state_53930__$1 = state_53930;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53930__$1,inst_53928);
} else {
if((state_val_53931 === (2))){
var _ = (function (){var statearr_53936 = state_53930;
(statearr_53936[(4)] = cljs.core.cons((5),(state_53930[(4)])));

return statearr_53936;
})();
var inst_53899 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_53930__$1 = state_53930;
if(cljs.core.truth_(inst_53899)){
var statearr_53937_53955 = state_53930__$1;
(statearr_53937_53955[(1)] = (6));

} else {
var statearr_53938_53956 = state_53930__$1;
(statearr_53938_53956[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53931 === (9))){
var inst_53910 = (state_53930[(2)]);
var inst_53911 = fluree.db.util.async.throw_err(inst_53910);
var inst_53912 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53911,(0),null);
var inst_53913 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53911,(1),null);
var inst_53914 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53915 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53916 = ["?p","?ctx",inst_53912];
var inst_53917 = cljs.core.PersistentHashMap.fromArrays(inst_53915,inst_53916);
var inst_53918 = ((10) + inst_53913);
var inst_53919 = [inst_53917,inst_53918];
var inst_53920 = (new cljs.core.PersistentVector(null,2,(5),inst_53914,inst_53919,null));
var inst_53921 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53920);
var state_53930__$1 = (function (){var statearr_53939 = state_53930;
(statearr_53939[(7)] = inst_53921);

return statearr_53939;
})();
var statearr_53940_53957 = state_53930__$1;
(statearr_53940_53957[(2)] = inst_53912);

(statearr_53940_53957[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53931 === (5))){
var _ = (function (){var statearr_53941 = state_53930;
(statearr_53941[(4)] = cljs.core.rest((state_53930[(4)])));

return statearr_53941;
})();
var state_53930__$1 = state_53930;
var ex53935 = (state_53930__$1[(2)]);
var statearr_53942_53958 = state_53930__$1;
(statearr_53942_53958[(5)] = ex53935);


if((ex53935 instanceof Error)){
var statearr_53943_53959 = state_53930__$1;
(statearr_53943_53959[(1)] = (4));

(statearr_53943_53959[(5)] = null);

} else {
throw ex53935;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53931 === (10))){
var inst_53906 = (state_53930[(2)]);
var inst_53907 = fluree.db.util.async.throw_err(inst_53906);
var inst_53908 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_53907);
var state_53930__$1 = state_53930;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53930__$1,(9),inst_53908);
} else {
if((state_val_53931 === (8))){
var inst_53925 = (state_53930[(2)]);
var _ = (function (){var statearr_53944 = state_53930;
(statearr_53944[(4)] = cljs.core.rest((state_53930[(4)])));

return statearr_53944;
})();
var state_53930__$1 = state_53930;
var statearr_53945_53960 = state_53930__$1;
(statearr_53945_53960[(2)] = inst_53925);

(statearr_53945_53960[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2717__auto____0 = (function (){
var statearr_53946 = [null,null,null,null,null,null,null,null];
(statearr_53946[(0)] = fluree$db$dbfunctions$fns$state_machine__2717__auto__);

(statearr_53946[(1)] = (1));

return statearr_53946;
});
var fluree$db$dbfunctions$fns$state_machine__2717__auto____1 = (function (state_53930){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_53930);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e53947){var ex__2720__auto__ = e53947;
var statearr_53948_53961 = state_53930;
(statearr_53948_53961[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_53930[(4)]))){
var statearr_53949_53962 = state_53930;
(statearr_53949_53962[(1)] = cljs.core.first((state_53930[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53963 = state_53930;
state_53930 = G__53963;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2717__auto__ = function(state_53930){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____1.call(this,state_53930);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_53950 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_53950[(6)] = c__2739__auto__);

return statearr_53950;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4824__auto__ = [];
var len__4818__auto___54012 = arguments.length;
var i__4819__auto___54013 = (0);
while(true){
if((i__4819__auto___54013 < len__4818__auto___54012)){
args__4824__auto__.push((arguments[i__4819__auto___54013]));

var G__54014 = (i__4819__auto___54013 + (1));
i__4819__auto___54013 = G__54014;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_53995){
var state_val_53996 = (state_53995[(1)]);
if((state_val_53996 === (1))){
var state_53995__$1 = state_53995;
var statearr_53997_54015 = state_53995__$1;
(statearr_53997_54015[(2)] = null);

(statearr_53997_54015[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53996 === (2))){
var _ = (function (){var statearr_53998 = state_53995;
(statearr_53998[(4)] = cljs.core.cons((5),(state_53995[(4)])));

return statearr_53998;
})();
var inst_53972 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_53995__$1 = state_53995;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53995__$1,(6),inst_53972);
} else {
if((state_val_53996 === (3))){
var inst_53993 = (state_53995[(2)]);
var state_53995__$1 = state_53995;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53995__$1,inst_53993);
} else {
if((state_val_53996 === (4))){
var inst_53966 = (state_53995[(2)]);
var state_53995__$1 = state_53995;
var statearr_54000_54016 = state_53995__$1;
(statearr_54000_54016[(2)] = inst_53966);

(statearr_54000_54016[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53996 === (5))){
var _ = (function (){var statearr_54001 = state_53995;
(statearr_54001[(4)] = cljs.core.rest((state_53995[(4)])));

return statearr_54001;
})();
var state_53995__$1 = state_53995;
var ex53999 = (state_53995__$1[(2)]);
var statearr_54002_54017 = state_53995__$1;
(statearr_54002_54017[(5)] = ex53999);


if((ex53999 instanceof Error)){
var statearr_54003_54018 = state_53995__$1;
(statearr_54003_54018[(1)] = (4));

(statearr_54003_54018[(5)] = null);

} else {
throw ex53999;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53996 === (6))){
var inst_53974 = (state_53995[(2)]);
var inst_53975 = fluree.db.util.async.throw_err(inst_53974);
var inst_53976 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_53975);
var inst_53977 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53978 = [inst_53975];
var inst_53979 = (new cljs.core.PersistentVector(null,1,(5),inst_53977,inst_53978,null));
var inst_53980 = cljs.core.count(inst_53979);
var inst_53981 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53982 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53983 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53984 = [inst_53975];
var inst_53985 = (new cljs.core.PersistentVector(null,1,(5),inst_53983,inst_53984,null));
var inst_53986 = ["and",inst_53985,inst_53976];
var inst_53987 = cljs.core.PersistentHashMap.fromArrays(inst_53982,inst_53986);
var inst_53988 = [inst_53987,inst_53980];
var inst_53989 = (new cljs.core.PersistentVector(null,2,(5),inst_53981,inst_53988,null));
var inst_53990 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53989);
var _ = (function (){var statearr_54004 = state_53995;
(statearr_54004[(4)] = cljs.core.rest((state_53995[(4)])));

return statearr_54004;
})();
var state_53995__$1 = (function (){var statearr_54005 = state_53995;
(statearr_54005[(7)] = inst_53990);

return statearr_54005;
})();
var statearr_54006_54019 = state_53995__$1;
(statearr_54006_54019[(2)] = inst_53976);

(statearr_54006_54019[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2717__auto____0 = (function (){
var statearr_54007 = [null,null,null,null,null,null,null,null];
(statearr_54007[(0)] = fluree$db$dbfunctions$fns$state_machine__2717__auto__);

(statearr_54007[(1)] = (1));

return statearr_54007;
});
var fluree$db$dbfunctions$fns$state_machine__2717__auto____1 = (function (state_53995){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_53995);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e54008){var ex__2720__auto__ = e54008;
var statearr_54009_54020 = state_53995;
(statearr_54009_54020[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_53995[(4)]))){
var statearr_54010_54021 = state_53995;
(statearr_54010_54021[(1)] = cljs.core.first((state_53995[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54022 = state_53995;
state_53995 = G__54022;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2717__auto__ = function(state_53995){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____1.call(this,state_53995);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_54011 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_54011[(6)] = c__2739__auto__);

return statearr_54011;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq53964){
var G__53965 = cljs.core.first(seq53964);
var seq53964__$1 = cljs.core.next(seq53964);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53965,seq53964__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4824__auto__ = [];
var len__4818__auto___54071 = arguments.length;
var i__4819__auto___54072 = (0);
while(true){
if((i__4819__auto___54072 < len__4818__auto___54071)){
args__4824__auto__.push((arguments[i__4819__auto___54072]));

var G__54073 = (i__4819__auto___54072 + (1));
i__4819__auto___54072 = G__54073;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_54054){
var state_val_54055 = (state_54054[(1)]);
if((state_val_54055 === (1))){
var state_54054__$1 = state_54054;
var statearr_54056_54074 = state_54054__$1;
(statearr_54056_54074[(2)] = null);

(statearr_54056_54074[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54055 === (2))){
var _ = (function (){var statearr_54057 = state_54054;
(statearr_54057[(4)] = cljs.core.cons((5),(state_54054[(4)])));

return statearr_54057;
})();
var inst_54031 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54054__$1 = state_54054;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54054__$1,(6),inst_54031);
} else {
if((state_val_54055 === (3))){
var inst_54052 = (state_54054[(2)]);
var state_54054__$1 = state_54054;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54054__$1,inst_54052);
} else {
if((state_val_54055 === (4))){
var inst_54025 = (state_54054[(2)]);
var state_54054__$1 = state_54054;
var statearr_54059_54075 = state_54054__$1;
(statearr_54059_54075[(2)] = inst_54025);

(statearr_54059_54075[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54055 === (5))){
var _ = (function (){var statearr_54060 = state_54054;
(statearr_54060[(4)] = cljs.core.rest((state_54054[(4)])));

return statearr_54060;
})();
var state_54054__$1 = state_54054;
var ex54058 = (state_54054__$1[(2)]);
var statearr_54061_54076 = state_54054__$1;
(statearr_54061_54076[(5)] = ex54058);


if((ex54058 instanceof Error)){
var statearr_54062_54077 = state_54054__$1;
(statearr_54062_54077[(1)] = (4));

(statearr_54062_54077[(5)] = null);

} else {
throw ex54058;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54055 === (6))){
var inst_54033 = (state_54054[(2)]);
var inst_54034 = fluree.db.util.async.throw_err(inst_54033);
var inst_54035 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_54034);
var inst_54036 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54037 = [inst_54034];
var inst_54038 = (new cljs.core.PersistentVector(null,1,(5),inst_54036,inst_54037,null));
var inst_54039 = cljs.core.count(inst_54038);
var inst_54040 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54041 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54042 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54043 = [inst_54034];
var inst_54044 = (new cljs.core.PersistentVector(null,1,(5),inst_54042,inst_54043,null));
var inst_54045 = ["or",inst_54044,inst_54035];
var inst_54046 = cljs.core.PersistentHashMap.fromArrays(inst_54041,inst_54045);
var inst_54047 = [inst_54046,inst_54039];
var inst_54048 = (new cljs.core.PersistentVector(null,2,(5),inst_54040,inst_54047,null));
var inst_54049 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54048);
var _ = (function (){var statearr_54063 = state_54054;
(statearr_54063[(4)] = cljs.core.rest((state_54054[(4)])));

return statearr_54063;
})();
var state_54054__$1 = (function (){var statearr_54064 = state_54054;
(statearr_54064[(7)] = inst_54049);

return statearr_54064;
})();
var statearr_54065_54078 = state_54054__$1;
(statearr_54065_54078[(2)] = inst_54035);

(statearr_54065_54078[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2717__auto____0 = (function (){
var statearr_54066 = [null,null,null,null,null,null,null,null];
(statearr_54066[(0)] = fluree$db$dbfunctions$fns$state_machine__2717__auto__);

(statearr_54066[(1)] = (1));

return statearr_54066;
});
var fluree$db$dbfunctions$fns$state_machine__2717__auto____1 = (function (state_54054){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_54054);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e54067){var ex__2720__auto__ = e54067;
var statearr_54068_54079 = state_54054;
(statearr_54068_54079[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_54054[(4)]))){
var statearr_54069_54080 = state_54054;
(statearr_54069_54080[(1)] = cljs.core.first((state_54054[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54081 = state_54054;
state_54054 = G__54081;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2717__auto__ = function(state_54054){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____1.call(this,state_54054);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_54070 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_54070[(6)] = c__2739__auto__);

return statearr_54070;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq54023){
var G__54024 = cljs.core.first(seq54023);
var seq54023__$1 = cljs.core.next(seq54023);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54024,seq54023__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_54119){
var state_val_54120 = (state_54119[(1)]);
if((state_val_54120 === (7))){
var inst_54095 = fluree.db.util.async.channel_QMARK_(coll);
var state_54119__$1 = state_54119;
if(inst_54095){
var statearr_54121_54144 = state_54119__$1;
(statearr_54121_54144[(1)] = (10));

} else {
var statearr_54122_54145 = state_54119__$1;
(statearr_54122_54145[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54120 === (1))){
var state_54119__$1 = state_54119;
var statearr_54123_54146 = state_54119__$1;
(statearr_54123_54146[(2)] = null);

(statearr_54123_54146[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54120 === (4))){
var inst_54082 = (state_54119[(2)]);
var state_54119__$1 = state_54119;
var statearr_54124_54147 = state_54119__$1;
(statearr_54124_54147[(2)] = inst_54082);

(statearr_54124_54147[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54120 === (13))){
var inst_54098 = (state_54119[(2)]);
var inst_54099 = fluree.db.util.async.throw_err(inst_54098);
var state_54119__$1 = state_54119;
var statearr_54125_54148 = state_54119__$1;
(statearr_54125_54148[(2)] = inst_54099);

(statearr_54125_54148[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54120 === (6))){
var inst_54090 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_54119__$1 = state_54119;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54119__$1,(9),inst_54090);
} else {
if((state_val_54120 === (3))){
var inst_54117 = (state_54119[(2)]);
var state_54119__$1 = state_54119;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54119__$1,inst_54117);
} else {
if((state_val_54120 === (12))){
var inst_54102 = (state_54119[(2)]);
var state_54119__$1 = state_54119;
var statearr_54126_54149 = state_54119__$1;
(statearr_54126_54149[(2)] = inst_54102);

(statearr_54126_54149[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54120 === (2))){
var _ = (function (){var statearr_54127 = state_54119;
(statearr_54127[(4)] = cljs.core.cons((5),(state_54119[(4)])));

return statearr_54127;
})();
var inst_54088 = cljs.core.vector_QMARK_(coll);
var state_54119__$1 = state_54119;
if(inst_54088){
var statearr_54128_54150 = state_54119__$1;
(statearr_54128_54150[(1)] = (6));

} else {
var statearr_54129_54151 = state_54119__$1;
(statearr_54129_54151[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54120 === (11))){
var state_54119__$1 = state_54119;
var statearr_54131_54152 = state_54119__$1;
(statearr_54131_54152[(2)] = coll);

(statearr_54131_54152[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54120 === (9))){
var inst_54092 = (state_54119[(2)]);
var inst_54093 = fluree.db.util.async.throw_err(inst_54092);
var state_54119__$1 = state_54119;
var statearr_54132_54153 = state_54119__$1;
(statearr_54132_54153[(2)] = inst_54093);

(statearr_54132_54153[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54120 === (5))){
var _ = (function (){var statearr_54133 = state_54119;
(statearr_54133[(4)] = cljs.core.rest((state_54119[(4)])));

return statearr_54133;
})();
var state_54119__$1 = state_54119;
var ex54130 = (state_54119__$1[(2)]);
var statearr_54134_54154 = state_54119__$1;
(statearr_54134_54154[(5)] = ex54130);


if((ex54130 instanceof Error)){
var statearr_54135_54155 = state_54119__$1;
(statearr_54135_54155[(1)] = (4));

(statearr_54135_54155[(5)] = null);

} else {
throw ex54130;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54120 === (10))){
var state_54119__$1 = state_54119;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54119__$1,(13),coll);
} else {
if((state_val_54120 === (8))){
var inst_54104 = (state_54119[(2)]);
var inst_54105 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_54104);
var inst_54106 = cljs.core.count(inst_54105);
var inst_54107 = ((9) + inst_54106);
var inst_54108 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54109 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54110 = ["count",inst_54104,inst_54106];
var inst_54111 = cljs.core.PersistentHashMap.fromArrays(inst_54109,inst_54110);
var inst_54112 = [inst_54111,inst_54107];
var inst_54113 = (new cljs.core.PersistentVector(null,2,(5),inst_54108,inst_54112,null));
var inst_54114 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54113);
var _ = (function (){var statearr_54136 = state_54119;
(statearr_54136[(4)] = cljs.core.rest((state_54119[(4)])));

return statearr_54136;
})();
var state_54119__$1 = (function (){var statearr_54137 = state_54119;
(statearr_54137[(7)] = inst_54114);

return statearr_54137;
})();
var statearr_54138_54156 = state_54119__$1;
(statearr_54138_54156[(2)] = inst_54106);

(statearr_54138_54156[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__2717__auto____0 = (function (){
var statearr_54139 = [null,null,null,null,null,null,null,null];
(statearr_54139[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__2717__auto__);

(statearr_54139[(1)] = (1));

return statearr_54139;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__2717__auto____1 = (function (state_54119){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_54119);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e54140){var ex__2720__auto__ = e54140;
var statearr_54141_54157 = state_54119;
(statearr_54141_54157[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_54119[(4)]))){
var statearr_54142_54158 = state_54119;
(statearr_54142_54158[(1)] = cljs.core.first((state_54119[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54159 = state_54119;
state_54119 = G__54159;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__2717__auto__ = function(state_54119){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__2717__auto____1.call(this,state_54119);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_54143 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_54143[(6)] = c__2739__auto__);

return statearr_54143;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_54209){
var state_val_54210 = (state_54209[(1)]);
if((state_val_54210 === (7))){
var state_54209__$1 = state_54209;
var statearr_54211_54244 = state_54209__$1;
(statearr_54211_54244[(2)] = subject);

(statearr_54211_54244[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54210 === (1))){
var state_54209__$1 = state_54209;
var statearr_54212_54245 = state_54209__$1;
(statearr_54212_54245[(2)] = null);

(statearr_54212_54245[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54210 === (4))){
var inst_54160 = (state_54209[(2)]);
var state_54209__$1 = state_54209;
var statearr_54213_54246 = state_54209__$1;
(statearr_54213_54246[(2)] = inst_54160);

(statearr_54213_54246[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54210 === (15))){
var inst_54173 = (state_54209[(7)]);
var state_54209__$1 = state_54209;
var statearr_54214_54247 = state_54209__$1;
(statearr_54214_54247[(2)] = inst_54173);

(statearr_54214_54247[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54210 === (13))){
var inst_54177 = (state_54209[(2)]);
var inst_54178 = fluree.db.util.async.throw_err(inst_54177);
var state_54209__$1 = state_54209;
var statearr_54215_54248 = state_54209__$1;
(statearr_54215_54248[(2)] = inst_54178);

(statearr_54215_54248[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54210 === (6))){
var state_54209__$1 = state_54209;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54209__$1,(9),subject);
} else {
if((state_val_54210 === (17))){
var inst_54173 = (state_54209[(7)]);
var inst_54187 = cljs.core.first(inst_54173);
var state_54209__$1 = state_54209;
var statearr_54216_54249 = state_54209__$1;
(statearr_54216_54249[(2)] = inst_54187);

(statearr_54216_54249[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54210 === (3))){
var inst_54207 = (state_54209[(2)]);
var state_54209__$1 = state_54209;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54209__$1,inst_54207);
} else {
if((state_val_54210 === (12))){
var inst_54173 = (state_54209[(7)]);
var inst_54181 = (state_54209[(2)]);
var inst_54182 = cljs.core.vector_QMARK_(inst_54173);
var state_54209__$1 = (function (){var statearr_54217 = state_54209;
(statearr_54217[(8)] = inst_54181);

return statearr_54217;
})();
if(inst_54182){
var statearr_54218_54250 = state_54209__$1;
(statearr_54218_54250[(1)] = (14));

} else {
var statearr_54219_54251 = state_54209__$1;
(statearr_54219_54251[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54210 === (2))){
var _ = (function (){var statearr_54220 = state_54209;
(statearr_54220[(4)] = cljs.core.cons((5),(state_54209[(4)])));

return statearr_54220;
})();
var inst_54166 = fluree.db.util.async.channel_QMARK_(subject);
var state_54209__$1 = state_54209;
if(inst_54166){
var statearr_54221_54252 = state_54209__$1;
(statearr_54221_54252[(1)] = (6));

} else {
var statearr_54222_54253 = state_54209__$1;
(statearr_54222_54253[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54210 === (19))){
var inst_54190 = (state_54209[(2)]);
var state_54209__$1 = state_54209;
var statearr_54223_54254 = state_54209__$1;
(statearr_54223_54254[(2)] = inst_54190);

(statearr_54223_54254[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54210 === (11))){
var state_54209__$1 = state_54209;
var statearr_54225_54255 = state_54209__$1;
(statearr_54225_54255[(2)] = pred);

(statearr_54225_54255[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54210 === (9))){
var inst_54169 = (state_54209[(2)]);
var inst_54170 = fluree.db.util.async.throw_err(inst_54169);
var state_54209__$1 = state_54209;
var statearr_54226_54256 = state_54209__$1;
(statearr_54226_54256[(2)] = inst_54170);

(statearr_54226_54256[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54210 === (5))){
var _ = (function (){var statearr_54227 = state_54209;
(statearr_54227[(4)] = cljs.core.rest((state_54209[(4)])));

return statearr_54227;
})();
var state_54209__$1 = state_54209;
var ex54224 = (state_54209__$1[(2)]);
var statearr_54228_54257 = state_54209__$1;
(statearr_54228_54257[(5)] = ex54224);


if((ex54224 instanceof Error)){
var statearr_54229_54258 = state_54209__$1;
(statearr_54229_54258[(1)] = (4));

(statearr_54229_54258[(5)] = null);

} else {
throw ex54224;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54210 === (14))){
var inst_54173 = (state_54209[(7)]);
var inst_54184 = cljs.core.count(inst_54173);
var inst_54185 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_54184);
var state_54209__$1 = state_54209;
if(inst_54185){
var statearr_54230_54259 = state_54209__$1;
(statearr_54230_54259[(1)] = (17));

} else {
var statearr_54231_54260 = state_54209__$1;
(statearr_54231_54260[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54210 === (16))){
var inst_54181 = (state_54209[(8)]);
var inst_54173 = (state_54209[(7)]);
var inst_54193 = (state_54209[(2)]);
var inst_54194 = fluree.db.dbfunctions.internal.get(inst_54193,inst_54181);
var inst_54195 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54196 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54197 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54198 = [inst_54173,inst_54181];
var inst_54199 = (new cljs.core.PersistentVector(null,2,(5),inst_54197,inst_54198,null));
var inst_54200 = ["get",inst_54199,inst_54194];
var inst_54201 = cljs.core.PersistentHashMap.fromArrays(inst_54196,inst_54200);
var inst_54202 = [inst_54201,(10)];
var inst_54203 = (new cljs.core.PersistentVector(null,2,(5),inst_54195,inst_54202,null));
var inst_54204 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54203);
var _ = (function (){var statearr_54232 = state_54209;
(statearr_54232[(4)] = cljs.core.rest((state_54209[(4)])));

return statearr_54232;
})();
var state_54209__$1 = (function (){var statearr_54233 = state_54209;
(statearr_54233[(9)] = inst_54204);

return statearr_54233;
})();
var statearr_54234_54261 = state_54209__$1;
(statearr_54234_54261[(2)] = inst_54194);

(statearr_54234_54261[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54210 === (10))){
var state_54209__$1 = state_54209;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54209__$1,(13),pred);
} else {
if((state_val_54210 === (18))){
var inst_54173 = (state_54209[(7)]);
var state_54209__$1 = state_54209;
var statearr_54235_54262 = state_54209__$1;
(statearr_54235_54262[(2)] = inst_54173);

(statearr_54235_54262[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54210 === (8))){
var inst_54173 = (state_54209[(2)]);
var inst_54174 = fluree.db.util.async.channel_QMARK_(pred);
var state_54209__$1 = (function (){var statearr_54236 = state_54209;
(statearr_54236[(7)] = inst_54173);

return statearr_54236;
})();
if(inst_54174){
var statearr_54237_54263 = state_54209__$1;
(statearr_54237_54263[(1)] = (10));

} else {
var statearr_54238_54264 = state_54209__$1;
(statearr_54238_54264[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__2717__auto____0 = (function (){
var statearr_54239 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54239[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__2717__auto__);

(statearr_54239[(1)] = (1));

return statearr_54239;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__2717__auto____1 = (function (state_54209){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_54209);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e54240){var ex__2720__auto__ = e54240;
var statearr_54241_54265 = state_54209;
(statearr_54241_54265[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_54209[(4)]))){
var statearr_54242_54266 = state_54209;
(statearr_54242_54266[(1)] = cljs.core.first((state_54209[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54267 = state_54209;
state_54209 = G__54267;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__2717__auto__ = function(state_54209){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__2717__auto____1.call(this,state_54209);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_54243 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_54243[(6)] = c__2739__auto__);

return statearr_54243;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_54306){
var state_val_54307 = (state_54306[(1)]);
if((state_val_54307 === (7))){
var inst_54274 = (state_54306[(7)]);
var state_54306__$1 = state_54306;
var statearr_54308_54332 = state_54306__$1;
(statearr_54308_54332[(2)] = inst_54274);

(statearr_54308_54332[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54307 === (1))){
var state_54306__$1 = state_54306;
var statearr_54309_54333 = state_54306__$1;
(statearr_54309_54333[(2)] = null);

(statearr_54309_54333[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54307 === (4))){
var inst_54268 = (state_54306[(2)]);
var state_54306__$1 = state_54306;
var statearr_54310_54334 = state_54306__$1;
(statearr_54310_54334[(2)] = inst_54268);

(statearr_54310_54334[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54307 === (6))){
var inst_54276 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54306__$1 = state_54306;
var statearr_54311_54335 = state_54306__$1;
(statearr_54311_54335[(2)] = inst_54276);

(statearr_54311_54335[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54307 === (3))){
var inst_54304 = (state_54306[(2)]);
var state_54306__$1 = state_54306;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54306__$1,inst_54304);
} else {
if((state_val_54307 === (12))){
var inst_54286 = (state_54306[(2)]);
var inst_54287 = fluree.db.util.async.throw_err(inst_54286);
var inst_54288 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54287,(0),null);
var inst_54289 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54287,(1),null);
var inst_54290 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54291 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54292 = ["?pO","?ctx",inst_54288];
var inst_54293 = cljs.core.PersistentHashMap.fromArrays(inst_54291,inst_54292);
var inst_54294 = ((10) + inst_54289);
var inst_54295 = [inst_54293,inst_54294];
var inst_54296 = (new cljs.core.PersistentVector(null,2,(5),inst_54290,inst_54295,null));
var inst_54297 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54296);
var state_54306__$1 = (function (){var statearr_54312 = state_54306;
(statearr_54312[(8)] = inst_54297);

return statearr_54312;
})();
var statearr_54313_54336 = state_54306__$1;
(statearr_54313_54336[(2)] = inst_54288);

(statearr_54313_54336[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54307 === (2))){
var inst_54274 = (state_54306[(7)]);
var _ = (function (){var statearr_54314 = state_54306;
(statearr_54314[(4)] = cljs.core.cons((5),(state_54306[(4)])));

return statearr_54314;
})();
var inst_54274__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54306__$1 = (function (){var statearr_54315 = state_54306;
(statearr_54315[(7)] = inst_54274__$1);

return statearr_54315;
})();
if(cljs.core.truth_(inst_54274__$1)){
var statearr_54316_54337 = state_54306__$1;
(statearr_54316_54337[(1)] = (6));

} else {
var statearr_54317_54338 = state_54306__$1;
(statearr_54317_54338[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54307 === (11))){
var inst_54301 = (state_54306[(2)]);
var _ = (function (){var statearr_54319 = state_54306;
(statearr_54319[(4)] = cljs.core.rest((state_54306[(4)])));

return statearr_54319;
})();
var state_54306__$1 = state_54306;
var statearr_54320_54339 = state_54306__$1;
(statearr_54320_54339[(2)] = inst_54301);

(statearr_54320_54339[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54307 === (9))){
var inst_54284 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_54306__$1 = state_54306;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54306__$1,(12),inst_54284);
} else {
if((state_val_54307 === (5))){
var _ = (function (){var statearr_54321 = state_54306;
(statearr_54321[(4)] = cljs.core.rest((state_54306[(4)])));

return statearr_54321;
})();
var state_54306__$1 = state_54306;
var ex54318 = (state_54306__$1[(2)]);
var statearr_54322_54340 = state_54306__$1;
(statearr_54322_54340[(5)] = ex54318);


if((ex54318 instanceof Error)){
var statearr_54323_54341 = state_54306__$1;
(statearr_54323_54341[(1)] = (4));

(statearr_54323_54341[(5)] = null);

} else {
throw ex54318;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54307 === (10))){
var inst_54299 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_54306__$1 = state_54306;
var statearr_54324_54342 = state_54306__$1;
(statearr_54324_54342[(2)] = inst_54299);

(statearr_54324_54342[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54307 === (8))){
var inst_54279 = (state_54306[(2)]);
var state_54306__$1 = state_54306;
if(cljs.core.truth_(inst_54279)){
var statearr_54325_54343 = state_54306__$1;
(statearr_54325_54343[(1)] = (9));

} else {
var statearr_54326_54344 = state_54306__$1;
(statearr_54326_54344[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2717__auto____0 = (function (){
var statearr_54327 = [null,null,null,null,null,null,null,null,null];
(statearr_54327[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2717__auto__);

(statearr_54327[(1)] = (1));

return statearr_54327;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2717__auto____1 = (function (state_54306){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_54306);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e54328){var ex__2720__auto__ = e54328;
var statearr_54329_54345 = state_54306;
(statearr_54329_54345[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_54306[(4)]))){
var statearr_54330_54346 = state_54306;
(statearr_54330_54346[(1)] = cljs.core.first((state_54306[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54347 = state_54306;
state_54306 = G__54347;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2717__auto__ = function(state_54306){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2717__auto____1.call(this,state_54306);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_54331 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_54331[(6)] = c__2739__auto__);

return statearr_54331;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_54399){
var state_val_54400 = (state_54399[(1)]);
if((state_val_54400 === (7))){
var state_54399__$1 = state_54399;
var statearr_54401_54434 = state_54399__$1;
(statearr_54401_54434[(2)] = subject);

(statearr_54401_54434[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54400 === (1))){
var state_54399__$1 = state_54399;
var statearr_54402_54435 = state_54399__$1;
(statearr_54402_54435[(2)] = null);

(statearr_54402_54435[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54400 === (4))){
var inst_54348 = (state_54399[(2)]);
var state_54399__$1 = state_54399;
var statearr_54403_54436 = state_54399__$1;
(statearr_54403_54436[(2)] = inst_54348);

(statearr_54403_54436[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54400 === (15))){
var inst_54361 = (state_54399[(7)]);
var state_54399__$1 = state_54399;
var statearr_54404_54437 = state_54399__$1;
(statearr_54404_54437[(2)] = inst_54361);

(statearr_54404_54437[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54400 === (13))){
var inst_54365 = (state_54399[(2)]);
var inst_54366 = fluree.db.util.async.throw_err(inst_54365);
var state_54399__$1 = state_54399;
var statearr_54405_54438 = state_54399__$1;
(statearr_54405_54438[(2)] = inst_54366);

(statearr_54405_54438[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54400 === (6))){
var state_54399__$1 = state_54399;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54399__$1,(9),subject);
} else {
if((state_val_54400 === (17))){
var inst_54361 = (state_54399[(7)]);
var inst_54375 = cljs.core.first(inst_54361);
var state_54399__$1 = state_54399;
var statearr_54406_54439 = state_54399__$1;
(statearr_54406_54439[(2)] = inst_54375);

(statearr_54406_54439[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54400 === (3))){
var inst_54397 = (state_54399[(2)]);
var state_54399__$1 = state_54399;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54399__$1,inst_54397);
} else {
if((state_val_54400 === (12))){
var inst_54361 = (state_54399[(7)]);
var inst_54369 = (state_54399[(2)]);
var inst_54370 = cljs.core.vector_QMARK_(inst_54361);
var state_54399__$1 = (function (){var statearr_54407 = state_54399;
(statearr_54407[(8)] = inst_54369);

return statearr_54407;
})();
if(inst_54370){
var statearr_54408_54440 = state_54399__$1;
(statearr_54408_54440[(1)] = (14));

} else {
var statearr_54409_54441 = state_54399__$1;
(statearr_54409_54441[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54400 === (2))){
var _ = (function (){var statearr_54410 = state_54399;
(statearr_54410[(4)] = cljs.core.cons((5),(state_54399[(4)])));

return statearr_54410;
})();
var inst_54354 = fluree.db.util.async.channel_QMARK_(subject);
var state_54399__$1 = state_54399;
if(inst_54354){
var statearr_54411_54442 = state_54399__$1;
(statearr_54411_54442[(1)] = (6));

} else {
var statearr_54412_54443 = state_54399__$1;
(statearr_54412_54443[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54400 === (19))){
var inst_54378 = (state_54399[(2)]);
var state_54399__$1 = state_54399;
var statearr_54413_54444 = state_54399__$1;
(statearr_54413_54444[(2)] = inst_54378);

(statearr_54413_54444[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54400 === (11))){
var state_54399__$1 = state_54399;
var statearr_54415_54445 = state_54399__$1;
(statearr_54415_54445[(2)] = path);

(statearr_54415_54445[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54400 === (9))){
var inst_54357 = (state_54399[(2)]);
var inst_54358 = fluree.db.util.async.throw_err(inst_54357);
var state_54399__$1 = state_54399;
var statearr_54416_54446 = state_54399__$1;
(statearr_54416_54446[(2)] = inst_54358);

(statearr_54416_54446[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54400 === (5))){
var _ = (function (){var statearr_54417 = state_54399;
(statearr_54417[(4)] = cljs.core.rest((state_54399[(4)])));

return statearr_54417;
})();
var state_54399__$1 = state_54399;
var ex54414 = (state_54399__$1[(2)]);
var statearr_54418_54447 = state_54399__$1;
(statearr_54418_54447[(5)] = ex54414);


if((ex54414 instanceof Error)){
var statearr_54419_54448 = state_54399__$1;
(statearr_54419_54448[(1)] = (4));

(statearr_54419_54448[(5)] = null);

} else {
throw ex54414;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54400 === (14))){
var inst_54361 = (state_54399[(7)]);
var inst_54372 = cljs.core.count(inst_54361);
var inst_54373 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_54372);
var state_54399__$1 = state_54399;
if(inst_54373){
var statearr_54420_54449 = state_54399__$1;
(statearr_54420_54449[(1)] = (17));

} else {
var statearr_54421_54450 = state_54399__$1;
(statearr_54421_54450[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54400 === (16))){
var inst_54369 = (state_54399[(8)]);
var inst_54361 = (state_54399[(7)]);
var inst_54381 = (state_54399[(2)]);
var inst_54382 = fluree.db.dbfunctions.internal.get_all(inst_54381,inst_54369);
var inst_54383 = cljs.core.count(inst_54369);
var inst_54384 = ((9) + inst_54383);
var inst_54385 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54386 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54387 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54388 = [inst_54361,inst_54369];
var inst_54389 = (new cljs.core.PersistentVector(null,2,(5),inst_54387,inst_54388,null));
var inst_54390 = ["get-all",inst_54389,inst_54382];
var inst_54391 = cljs.core.PersistentHashMap.fromArrays(inst_54386,inst_54390);
var inst_54392 = [inst_54391,inst_54384];
var inst_54393 = (new cljs.core.PersistentVector(null,2,(5),inst_54385,inst_54392,null));
var inst_54394 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54393);
var _ = (function (){var statearr_54422 = state_54399;
(statearr_54422[(4)] = cljs.core.rest((state_54399[(4)])));

return statearr_54422;
})();
var state_54399__$1 = (function (){var statearr_54423 = state_54399;
(statearr_54423[(9)] = inst_54394);

return statearr_54423;
})();
var statearr_54424_54451 = state_54399__$1;
(statearr_54424_54451[(2)] = inst_54382);

(statearr_54424_54451[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54400 === (10))){
var state_54399__$1 = state_54399;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54399__$1,(13),path);
} else {
if((state_val_54400 === (18))){
var inst_54361 = (state_54399[(7)]);
var state_54399__$1 = state_54399;
var statearr_54425_54452 = state_54399__$1;
(statearr_54425_54452[(2)] = inst_54361);

(statearr_54425_54452[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54400 === (8))){
var inst_54361 = (state_54399[(2)]);
var inst_54362 = fluree.db.util.async.channel_QMARK_(path);
var state_54399__$1 = (function (){var statearr_54426 = state_54399;
(statearr_54426[(7)] = inst_54361);

return statearr_54426;
})();
if(inst_54362){
var statearr_54427_54453 = state_54399__$1;
(statearr_54427_54453[(1)] = (10));

} else {
var statearr_54428_54454 = state_54399__$1;
(statearr_54428_54454[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2717__auto____0 = (function (){
var statearr_54429 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54429[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__2717__auto__);

(statearr_54429[(1)] = (1));

return statearr_54429;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2717__auto____1 = (function (state_54399){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_54399);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e54430){var ex__2720__auto__ = e54430;
var statearr_54431_54455 = state_54399;
(statearr_54431_54455[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_54399[(4)]))){
var statearr_54432_54456 = state_54399;
(statearr_54432_54456[(1)] = cljs.core.first((state_54399[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54457 = state_54399;
state_54399 = G__54457;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__2717__auto__ = function(state_54399){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2717__auto____1.call(this,state_54399);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_54433 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_54433[(6)] = c__2739__auto__);

return statearr_54433;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Returns the value of a nested structure
 */
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_54496){
var state_val_54497 = (state_54496[(1)]);
if((state_val_54497 === (7))){
var state_54496__$1 = state_54496;
var statearr_54498_54522 = state_54496__$1;
(statearr_54498_54522[(2)] = subject);

(statearr_54498_54522[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54497 === (1))){
var state_54496__$1 = state_54496;
var statearr_54499_54523 = state_54496__$1;
(statearr_54499_54523[(2)] = null);

(statearr_54499_54523[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54497 === (4))){
var inst_54458 = (state_54496[(2)]);
var state_54496__$1 = state_54496;
var statearr_54500_54524 = state_54496__$1;
(statearr_54500_54524[(2)] = inst_54458);

(statearr_54500_54524[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54497 === (13))){
var inst_54475 = (state_54496[(2)]);
var inst_54476 = fluree.db.util.async.throw_err(inst_54475);
var state_54496__$1 = state_54496;
var statearr_54501_54525 = state_54496__$1;
(statearr_54501_54525[(2)] = inst_54476);

(statearr_54501_54525[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54497 === (6))){
var state_54496__$1 = state_54496;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54496__$1,(9),subject);
} else {
if((state_val_54497 === (3))){
var inst_54494 = (state_54496[(2)]);
var state_54496__$1 = state_54496;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54496__$1,inst_54494);
} else {
if((state_val_54497 === (12))){
var inst_54471 = (state_54496[(7)]);
var inst_54479 = (state_54496[(2)]);
var inst_54480 = fluree.db.dbfunctions.internal.get_in(inst_54471,inst_54479);
var inst_54481 = cljs.core.count(inst_54479);
var inst_54482 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54483 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54484 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54485 = [inst_54471,inst_54479];
var inst_54486 = (new cljs.core.PersistentVector(null,2,(5),inst_54484,inst_54485,null));
var inst_54487 = ["get-in",inst_54486,inst_54480];
var inst_54488 = cljs.core.PersistentHashMap.fromArrays(inst_54483,inst_54487);
var inst_54489 = [inst_54488,inst_54481];
var inst_54490 = (new cljs.core.PersistentVector(null,2,(5),inst_54482,inst_54489,null));
var inst_54491 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54490);
var _ = (function (){var statearr_54502 = state_54496;
(statearr_54502[(4)] = cljs.core.rest((state_54496[(4)])));

return statearr_54502;
})();
var state_54496__$1 = (function (){var statearr_54503 = state_54496;
(statearr_54503[(8)] = inst_54491);

return statearr_54503;
})();
var statearr_54504_54526 = state_54496__$1;
(statearr_54504_54526[(2)] = inst_54480);

(statearr_54504_54526[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54497 === (2))){
var _ = (function (){var statearr_54505 = state_54496;
(statearr_54505[(4)] = cljs.core.cons((5),(state_54496[(4)])));

return statearr_54505;
})();
var inst_54464 = fluree.db.util.async.channel_QMARK_(subject);
var state_54496__$1 = state_54496;
if(inst_54464){
var statearr_54506_54527 = state_54496__$1;
(statearr_54506_54527[(1)] = (6));

} else {
var statearr_54507_54528 = state_54496__$1;
(statearr_54507_54528[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54497 === (11))){
var state_54496__$1 = state_54496;
var statearr_54509_54529 = state_54496__$1;
(statearr_54509_54529[(2)] = path);

(statearr_54509_54529[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54497 === (9))){
var inst_54467 = (state_54496[(2)]);
var inst_54468 = fluree.db.util.async.throw_err(inst_54467);
var state_54496__$1 = state_54496;
var statearr_54510_54530 = state_54496__$1;
(statearr_54510_54530[(2)] = inst_54468);

(statearr_54510_54530[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54497 === (5))){
var _ = (function (){var statearr_54511 = state_54496;
(statearr_54511[(4)] = cljs.core.rest((state_54496[(4)])));

return statearr_54511;
})();
var state_54496__$1 = state_54496;
var ex54508 = (state_54496__$1[(2)]);
var statearr_54512_54531 = state_54496__$1;
(statearr_54512_54531[(5)] = ex54508);


if((ex54508 instanceof Error)){
var statearr_54513_54532 = state_54496__$1;
(statearr_54513_54532[(1)] = (4));

(statearr_54513_54532[(5)] = null);

} else {
throw ex54508;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54497 === (10))){
var state_54496__$1 = state_54496;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54496__$1,(13),path);
} else {
if((state_val_54497 === (8))){
var inst_54471 = (state_54496[(2)]);
var inst_54472 = fluree.db.util.async.channel_QMARK_(path);
var state_54496__$1 = (function (){var statearr_54514 = state_54496;
(statearr_54514[(7)] = inst_54471);

return statearr_54514;
})();
if(inst_54472){
var statearr_54515_54533 = state_54496__$1;
(statearr_54515_54533[(1)] = (10));

} else {
var statearr_54516_54534 = state_54496__$1;
(statearr_54516_54534[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2717__auto____0 = (function (){
var statearr_54517 = [null,null,null,null,null,null,null,null,null];
(statearr_54517[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__2717__auto__);

(statearr_54517[(1)] = (1));

return statearr_54517;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2717__auto____1 = (function (state_54496){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_54496);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e54518){var ex__2720__auto__ = e54518;
var statearr_54519_54535 = state_54496;
(statearr_54519_54535[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_54496[(4)]))){
var statearr_54520_54536 = state_54496;
(statearr_54520_54536[(1)] = cljs.core.first((state_54496[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54537 = state_54496;
state_54496 = G__54537;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__2717__auto__ = function(state_54496){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2717__auto____1.call(this,state_54496);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_54521 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_54521[(6)] = c__2739__auto__);

return statearr_54521;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_54582){
var state_val_54583 = (state_54582[(1)]);
if((state_val_54583 === (7))){
var state_54582__$1 = state_54582;
var statearr_54584_54613 = state_54582__$1;
(statearr_54584_54613[(2)] = coll);

(statearr_54584_54613[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54583 === (1))){
var state_54582__$1 = state_54582;
var statearr_54585_54614 = state_54582__$1;
(statearr_54585_54614[(2)] = null);

(statearr_54585_54614[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54583 === (4))){
var inst_54538 = (state_54582[(2)]);
var state_54582__$1 = state_54582;
var statearr_54586_54615 = state_54582__$1;
(statearr_54586_54615[(2)] = inst_54538);

(statearr_54586_54615[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54583 === (15))){
var inst_54558 = (state_54582[(7)]);
var inst_54566 = (state_54582[(2)]);
var inst_54567 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_54558,inst_54566);
var inst_54568 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54569 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54570 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54571 = [inst_54558,inst_54566];
var inst_54572 = (new cljs.core.PersistentVector(null,2,(5),inst_54570,inst_54571,null));
var inst_54573 = ["contains?",inst_54572,inst_54567];
var inst_54574 = cljs.core.PersistentHashMap.fromArrays(inst_54569,inst_54573);
var inst_54575 = [inst_54574,(10)];
var inst_54576 = (new cljs.core.PersistentVector(null,2,(5),inst_54568,inst_54575,null));
var inst_54577 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54576);
var _ = (function (){var statearr_54587 = state_54582;
(statearr_54587[(4)] = cljs.core.rest((state_54582[(4)])));

return statearr_54587;
})();
var state_54582__$1 = (function (){var statearr_54588 = state_54582;
(statearr_54588[(8)] = inst_54577);

return statearr_54588;
})();
var statearr_54589_54616 = state_54582__$1;
(statearr_54589_54616[(2)] = inst_54567);

(statearr_54589_54616[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54583 === (13))){
var state_54582__$1 = state_54582;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54582__$1,(16),key);
} else {
if((state_val_54583 === (6))){
var state_54582__$1 = state_54582;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54582__$1,(9),coll);
} else {
if((state_val_54583 === (3))){
var inst_54580 = (state_54582[(2)]);
var state_54582__$1 = state_54582;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54582__$1,inst_54580);
} else {
if((state_val_54583 === (12))){
var inst_54558 = (state_54582[(2)]);
var inst_54559 = fluree.db.util.async.channel_QMARK_(key);
var state_54582__$1 = (function (){var statearr_54590 = state_54582;
(statearr_54590[(7)] = inst_54558);

return statearr_54590;
})();
if(inst_54559){
var statearr_54591_54617 = state_54582__$1;
(statearr_54591_54617[(1)] = (13));

} else {
var statearr_54592_54618 = state_54582__$1;
(statearr_54592_54618[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54583 === (2))){
var _ = (function (){var statearr_54593 = state_54582;
(statearr_54593[(4)] = cljs.core.cons((5),(state_54582[(4)])));

return statearr_54593;
})();
var inst_54544 = fluree.db.util.async.channel_QMARK_(coll);
var state_54582__$1 = state_54582;
if(inst_54544){
var statearr_54594_54619 = state_54582__$1;
(statearr_54594_54619[(1)] = (6));

} else {
var statearr_54595_54620 = state_54582__$1;
(statearr_54595_54620[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54583 === (11))){
var inst_54551 = (state_54582[(9)]);
var inst_54555 = cljs.core.flatten(inst_54551);
var inst_54556 = cljs.core.set(inst_54555);
var state_54582__$1 = state_54582;
var statearr_54597_54621 = state_54582__$1;
(statearr_54597_54621[(2)] = inst_54556);

(statearr_54597_54621[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54583 === (9))){
var inst_54547 = (state_54582[(2)]);
var inst_54548 = fluree.db.util.async.throw_err(inst_54547);
var state_54582__$1 = state_54582;
var statearr_54598_54622 = state_54582__$1;
(statearr_54598_54622[(2)] = inst_54548);

(statearr_54598_54622[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54583 === (5))){
var _ = (function (){var statearr_54599 = state_54582;
(statearr_54599[(4)] = cljs.core.rest((state_54582[(4)])));

return statearr_54599;
})();
var state_54582__$1 = state_54582;
var ex54596 = (state_54582__$1[(2)]);
var statearr_54600_54623 = state_54582__$1;
(statearr_54600_54623[(5)] = ex54596);


if((ex54596 instanceof Error)){
var statearr_54601_54624 = state_54582__$1;
(statearr_54601_54624[(1)] = (4));

(statearr_54601_54624[(5)] = null);

} else {
throw ex54596;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54583 === (14))){
var state_54582__$1 = state_54582;
var statearr_54602_54625 = state_54582__$1;
(statearr_54602_54625[(2)] = key);

(statearr_54602_54625[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54583 === (16))){
var inst_54562 = (state_54582[(2)]);
var inst_54563 = fluree.db.util.async.throw_err(inst_54562);
var state_54582__$1 = state_54582;
var statearr_54603_54626 = state_54582__$1;
(statearr_54603_54626[(2)] = inst_54563);

(statearr_54603_54626[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54583 === (10))){
var inst_54551 = (state_54582[(9)]);
var state_54582__$1 = state_54582;
var statearr_54604_54627 = state_54582__$1;
(statearr_54604_54627[(2)] = inst_54551);

(statearr_54604_54627[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54583 === (8))){
var inst_54551 = (state_54582[(9)]);
var inst_54551__$1 = (state_54582[(2)]);
var inst_54552 = cljs.core.set_QMARK_(inst_54551__$1);
var state_54582__$1 = (function (){var statearr_54605 = state_54582;
(statearr_54605[(9)] = inst_54551__$1);

return statearr_54605;
})();
if(inst_54552){
var statearr_54606_54628 = state_54582__$1;
(statearr_54606_54628[(1)] = (10));

} else {
var statearr_54607_54629 = state_54582__$1;
(statearr_54607_54629[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2717__auto____0 = (function (){
var statearr_54608 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54608[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2717__auto__);

(statearr_54608[(1)] = (1));

return statearr_54608;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2717__auto____1 = (function (state_54582){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_54582);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e54609){var ex__2720__auto__ = e54609;
var statearr_54610_54630 = state_54582;
(statearr_54610_54630[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_54582[(4)]))){
var statearr_54611_54631 = state_54582;
(statearr_54611_54631[(1)] = cljs.core.first((state_54582[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54632 = state_54582;
state_54582 = G__54632;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2717__auto__ = function(state_54582){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2717__auto____1.call(this,state_54582);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_54612 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_54612[(6)] = c__2739__auto__);

return statearr_54612;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Returns a hash-set of values
 */
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4824__auto__ = [];
var len__4818__auto___54704 = arguments.length;
var i__4819__auto___54705 = (0);
while(true){
if((i__4819__auto___54705 < len__4818__auto___54704)){
args__4824__auto__.push((arguments[i__4819__auto___54705]));

var G__54706 = (i__4819__auto___54705 + (1));
i__4819__auto___54705 = G__54706;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_54678){
var state_val_54679 = (state_54678[(1)]);
if((state_val_54679 === (7))){
var inst_54644 = (state_54678[(7)]);
var inst_54648 = cljs.core.first(inst_54644);
var inst_54649 = cljs.core.coll_QMARK_(inst_54648);
var state_54678__$1 = state_54678;
var statearr_54680_54707 = state_54678__$1;
(statearr_54680_54707[(2)] = inst_54649);

(statearr_54680_54707[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54679 === (1))){
var state_54678__$1 = state_54678;
var statearr_54681_54708 = state_54678__$1;
(statearr_54681_54708[(2)] = null);

(statearr_54681_54708[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54679 === (4))){
var inst_54635 = (state_54678[(2)]);
var state_54678__$1 = state_54678;
var statearr_54682_54709 = state_54678__$1;
(statearr_54682_54709[(2)] = inst_54635);

(statearr_54682_54709[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54679 === (6))){
var inst_54644 = (state_54678[(7)]);
var inst_54646 = (state_54678[(8)]);
var inst_54643 = (state_54678[(2)]);
var inst_54644__$1 = fluree.db.util.async.throw_err(inst_54643);
var inst_54645 = cljs.core.count(inst_54644__$1);
var inst_54646__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_54645);
var state_54678__$1 = (function (){var statearr_54683 = state_54678;
(statearr_54683[(7)] = inst_54644__$1);

(statearr_54683[(8)] = inst_54646__$1);

return statearr_54683;
})();
if(inst_54646__$1){
var statearr_54684_54710 = state_54678__$1;
(statearr_54684_54710[(1)] = (7));

} else {
var statearr_54685_54711 = state_54678__$1;
(statearr_54685_54711[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54679 === (3))){
var inst_54676 = (state_54678[(2)]);
var state_54678__$1 = state_54678;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54678__$1,inst_54676);
} else {
if((state_val_54679 === (12))){
var inst_54657 = (state_54678[(2)]);
var inst_54658 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_54657);
var inst_54659 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54660 = [inst_54657];
var inst_54661 = (new cljs.core.PersistentVector(null,1,(5),inst_54659,inst_54660,null));
var inst_54662 = cljs.core.count(inst_54661);
var inst_54663 = ((9) + inst_54662);
var inst_54664 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54665 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54666 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54667 = [inst_54657];
var inst_54668 = (new cljs.core.PersistentVector(null,1,(5),inst_54666,inst_54667,null));
var inst_54669 = ["hash-set",inst_54668,inst_54658];
var inst_54670 = cljs.core.PersistentHashMap.fromArrays(inst_54665,inst_54669);
var inst_54671 = [inst_54670,inst_54663];
var inst_54672 = (new cljs.core.PersistentVector(null,2,(5),inst_54664,inst_54671,null));
var inst_54673 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54672);
var _ = (function (){var statearr_54686 = state_54678;
(statearr_54686[(4)] = cljs.core.rest((state_54678[(4)])));

return statearr_54686;
})();
var state_54678__$1 = (function (){var statearr_54687 = state_54678;
(statearr_54687[(9)] = inst_54673);

return statearr_54687;
})();
var statearr_54688_54712 = state_54678__$1;
(statearr_54688_54712[(2)] = inst_54658);

(statearr_54688_54712[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54679 === (2))){
var _ = (function (){var statearr_54689 = state_54678;
(statearr_54689[(4)] = cljs.core.cons((5),(state_54678[(4)])));

return statearr_54689;
})();
var inst_54641 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54678__$1 = state_54678;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54678__$1,(6),inst_54641);
} else {
if((state_val_54679 === (11))){
var inst_54644 = (state_54678[(7)]);
var state_54678__$1 = state_54678;
var statearr_54691_54713 = state_54678__$1;
(statearr_54691_54713[(2)] = inst_54644);

(statearr_54691_54713[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54679 === (9))){
var inst_54652 = (state_54678[(2)]);
var state_54678__$1 = state_54678;
if(cljs.core.truth_(inst_54652)){
var statearr_54692_54714 = state_54678__$1;
(statearr_54692_54714[(1)] = (10));

} else {
var statearr_54693_54715 = state_54678__$1;
(statearr_54693_54715[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54679 === (5))){
var _ = (function (){var statearr_54694 = state_54678;
(statearr_54694[(4)] = cljs.core.rest((state_54678[(4)])));

return statearr_54694;
})();
var state_54678__$1 = state_54678;
var ex54690 = (state_54678__$1[(2)]);
var statearr_54695_54716 = state_54678__$1;
(statearr_54695_54716[(5)] = ex54690);


if((ex54690 instanceof Error)){
var statearr_54696_54717 = state_54678__$1;
(statearr_54696_54717[(1)] = (4));

(statearr_54696_54717[(5)] = null);

} else {
throw ex54690;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54679 === (10))){
var inst_54644 = (state_54678[(7)]);
var inst_54654 = cljs.core.first(inst_54644);
var state_54678__$1 = state_54678;
var statearr_54697_54718 = state_54678__$1;
(statearr_54697_54718[(2)] = inst_54654);

(statearr_54697_54718[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54679 === (8))){
var inst_54646 = (state_54678[(8)]);
var state_54678__$1 = state_54678;
var statearr_54698_54719 = state_54678__$1;
(statearr_54698_54719[(2)] = inst_54646);

(statearr_54698_54719[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2717__auto____0 = (function (){
var statearr_54699 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54699[(0)] = fluree$db$dbfunctions$fns$state_machine__2717__auto__);

(statearr_54699[(1)] = (1));

return statearr_54699;
});
var fluree$db$dbfunctions$fns$state_machine__2717__auto____1 = (function (state_54678){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_54678);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e54700){var ex__2720__auto__ = e54700;
var statearr_54701_54720 = state_54678;
(statearr_54701_54720[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_54678[(4)]))){
var statearr_54702_54721 = state_54678;
(statearr_54702_54721[(1)] = cljs.core.first((state_54678[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54722 = state_54678;
state_54678 = G__54722;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2717__auto__ = function(state_54678){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____1.call(this,state_54678);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_54703 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_54703[(6)] = c__2739__auto__);

return statearr_54703;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq54633){
var G__54634 = cljs.core.first(seq54633);
var seq54633__$1 = cljs.core.next(seq54633);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54634,seq54633__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___54772 = arguments.length;
var i__4819__auto___54773 = (0);
while(true){
if((i__4819__auto___54773 < len__4818__auto___54772)){
args__4824__auto__.push((arguments[i__4819__auto___54773]));

var G__54774 = (i__4819__auto___54773 + (1));
i__4819__auto___54773 = G__54774;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_54755){
var state_val_54756 = (state_54755[(1)]);
if((state_val_54756 === (1))){
var state_54755__$1 = state_54755;
var statearr_54757_54775 = state_54755__$1;
(statearr_54757_54775[(2)] = null);

(statearr_54757_54775[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54756 === (2))){
var _ = (function (){var statearr_54758 = state_54755;
(statearr_54758[(4)] = cljs.core.cons((5),(state_54755[(4)])));

return statearr_54758;
})();
var inst_54731 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54755__$1 = state_54755;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54755__$1,(6),inst_54731);
} else {
if((state_val_54756 === (3))){
var inst_54753 = (state_54755[(2)]);
var state_54755__$1 = state_54755;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54755__$1,inst_54753);
} else {
if((state_val_54756 === (4))){
var inst_54725 = (state_54755[(2)]);
var state_54755__$1 = state_54755;
var statearr_54760_54776 = state_54755__$1;
(statearr_54760_54776[(2)] = inst_54725);

(statearr_54760_54776[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54756 === (5))){
var _ = (function (){var statearr_54761 = state_54755;
(statearr_54761[(4)] = cljs.core.rest((state_54755[(4)])));

return statearr_54761;
})();
var state_54755__$1 = state_54755;
var ex54759 = (state_54755__$1[(2)]);
var statearr_54762_54777 = state_54755__$1;
(statearr_54762_54777[(5)] = ex54759);


if((ex54759 instanceof Error)){
var statearr_54763_54778 = state_54755__$1;
(statearr_54763_54778[(1)] = (4));

(statearr_54763_54778[(5)] = null);

} else {
throw ex54759;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54756 === (6))){
var inst_54733 = (state_54755[(2)]);
var inst_54734 = fluree.db.util.async.throw_err(inst_54733);
var inst_54735 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_54734);
var inst_54736 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54737 = [inst_54734];
var inst_54738 = (new cljs.core.PersistentVector(null,1,(5),inst_54736,inst_54737,null));
var inst_54739 = cljs.core.count(inst_54738);
var inst_54740 = ((9) + inst_54739);
var inst_54741 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54742 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54743 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54744 = [inst_54734];
var inst_54745 = (new cljs.core.PersistentVector(null,1,(5),inst_54743,inst_54744,null));
var inst_54746 = ["==",inst_54745,inst_54735];
var inst_54747 = cljs.core.PersistentHashMap.fromArrays(inst_54742,inst_54746);
var inst_54748 = [inst_54747,inst_54740];
var inst_54749 = (new cljs.core.PersistentVector(null,2,(5),inst_54741,inst_54748,null));
var inst_54750 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54749);
var _ = (function (){var statearr_54764 = state_54755;
(statearr_54764[(4)] = cljs.core.rest((state_54755[(4)])));

return statearr_54764;
})();
var state_54755__$1 = (function (){var statearr_54765 = state_54755;
(statearr_54765[(7)] = inst_54750);

return statearr_54765;
})();
var statearr_54766_54779 = state_54755__$1;
(statearr_54766_54779[(2)] = inst_54735);

(statearr_54766_54779[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2717__auto____0 = (function (){
var statearr_54767 = [null,null,null,null,null,null,null,null];
(statearr_54767[(0)] = fluree$db$dbfunctions$fns$state_machine__2717__auto__);

(statearr_54767[(1)] = (1));

return statearr_54767;
});
var fluree$db$dbfunctions$fns$state_machine__2717__auto____1 = (function (state_54755){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_54755);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e54768){var ex__2720__auto__ = e54768;
var statearr_54769_54780 = state_54755;
(statearr_54769_54780[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_54755[(4)]))){
var statearr_54770_54781 = state_54755;
(statearr_54770_54781[(1)] = cljs.core.first((state_54755[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54782 = state_54755;
state_54755 = G__54782;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2717__auto__ = function(state_54755){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____1.call(this,state_54755);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_54771 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_54771[(6)] = c__2739__auto__);

return statearr_54771;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq54723){
var G__54724 = cljs.core.first(seq54723);
var seq54723__$1 = cljs.core.next(seq54723);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54724,seq54723__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___54832 = arguments.length;
var i__4819__auto___54833 = (0);
while(true){
if((i__4819__auto___54833 < len__4818__auto___54832)){
args__4824__auto__.push((arguments[i__4819__auto___54833]));

var G__54834 = (i__4819__auto___54833 + (1));
i__4819__auto___54833 = G__54834;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_54815){
var state_val_54816 = (state_54815[(1)]);
if((state_val_54816 === (1))){
var state_54815__$1 = state_54815;
var statearr_54817_54835 = state_54815__$1;
(statearr_54817_54835[(2)] = null);

(statearr_54817_54835[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54816 === (2))){
var _ = (function (){var statearr_54818 = state_54815;
(statearr_54818[(4)] = cljs.core.cons((5),(state_54815[(4)])));

return statearr_54818;
})();
var inst_54791 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54815__$1 = state_54815;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54815__$1,(6),inst_54791);
} else {
if((state_val_54816 === (3))){
var inst_54813 = (state_54815[(2)]);
var state_54815__$1 = state_54815;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54815__$1,inst_54813);
} else {
if((state_val_54816 === (4))){
var inst_54785 = (state_54815[(2)]);
var state_54815__$1 = state_54815;
var statearr_54820_54836 = state_54815__$1;
(statearr_54820_54836[(2)] = inst_54785);

(statearr_54820_54836[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54816 === (5))){
var _ = (function (){var statearr_54821 = state_54815;
(statearr_54821[(4)] = cljs.core.rest((state_54815[(4)])));

return statearr_54821;
})();
var state_54815__$1 = state_54815;
var ex54819 = (state_54815__$1[(2)]);
var statearr_54822_54837 = state_54815__$1;
(statearr_54822_54837[(5)] = ex54819);


if((ex54819 instanceof Error)){
var statearr_54823_54838 = state_54815__$1;
(statearr_54823_54838[(1)] = (4));

(statearr_54823_54838[(5)] = null);

} else {
throw ex54819;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54816 === (6))){
var inst_54793 = (state_54815[(2)]);
var inst_54794 = fluree.db.util.async.throw_err(inst_54793);
var inst_54795 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_54794);
var inst_54796 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54797 = [inst_54794];
var inst_54798 = (new cljs.core.PersistentVector(null,1,(5),inst_54796,inst_54797,null));
var inst_54799 = cljs.core.count(inst_54798);
var inst_54800 = ((9) + inst_54799);
var inst_54801 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54802 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54803 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54804 = [inst_54794];
var inst_54805 = (new cljs.core.PersistentVector(null,1,(5),inst_54803,inst_54804,null));
var inst_54806 = [">",inst_54805,inst_54795];
var inst_54807 = cljs.core.PersistentHashMap.fromArrays(inst_54802,inst_54806);
var inst_54808 = [inst_54807,inst_54800];
var inst_54809 = (new cljs.core.PersistentVector(null,2,(5),inst_54801,inst_54808,null));
var inst_54810 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54809);
var _ = (function (){var statearr_54824 = state_54815;
(statearr_54824[(4)] = cljs.core.rest((state_54815[(4)])));

return statearr_54824;
})();
var state_54815__$1 = (function (){var statearr_54825 = state_54815;
(statearr_54825[(7)] = inst_54810);

return statearr_54825;
})();
var statearr_54826_54839 = state_54815__$1;
(statearr_54826_54839[(2)] = inst_54795);

(statearr_54826_54839[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2717__auto____0 = (function (){
var statearr_54827 = [null,null,null,null,null,null,null,null];
(statearr_54827[(0)] = fluree$db$dbfunctions$fns$state_machine__2717__auto__);

(statearr_54827[(1)] = (1));

return statearr_54827;
});
var fluree$db$dbfunctions$fns$state_machine__2717__auto____1 = (function (state_54815){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_54815);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e54828){var ex__2720__auto__ = e54828;
var statearr_54829_54840 = state_54815;
(statearr_54829_54840[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_54815[(4)]))){
var statearr_54830_54841 = state_54815;
(statearr_54830_54841[(1)] = cljs.core.first((state_54815[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54842 = state_54815;
state_54815 = G__54842;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2717__auto__ = function(state_54815){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____1.call(this,state_54815);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_54831 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_54831[(6)] = c__2739__auto__);

return statearr_54831;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq54783){
var G__54784 = cljs.core.first(seq54783);
var seq54783__$1 = cljs.core.next(seq54783);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54784,seq54783__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___54892 = arguments.length;
var i__4819__auto___54893 = (0);
while(true){
if((i__4819__auto___54893 < len__4818__auto___54892)){
args__4824__auto__.push((arguments[i__4819__auto___54893]));

var G__54894 = (i__4819__auto___54893 + (1));
i__4819__auto___54893 = G__54894;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_54875){
var state_val_54876 = (state_54875[(1)]);
if((state_val_54876 === (1))){
var state_54875__$1 = state_54875;
var statearr_54877_54895 = state_54875__$1;
(statearr_54877_54895[(2)] = null);

(statearr_54877_54895[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54876 === (2))){
var _ = (function (){var statearr_54878 = state_54875;
(statearr_54878[(4)] = cljs.core.cons((5),(state_54875[(4)])));

return statearr_54878;
})();
var inst_54851 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54875__$1 = state_54875;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54875__$1,(6),inst_54851);
} else {
if((state_val_54876 === (3))){
var inst_54873 = (state_54875[(2)]);
var state_54875__$1 = state_54875;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54875__$1,inst_54873);
} else {
if((state_val_54876 === (4))){
var inst_54845 = (state_54875[(2)]);
var state_54875__$1 = state_54875;
var statearr_54880_54896 = state_54875__$1;
(statearr_54880_54896[(2)] = inst_54845);

(statearr_54880_54896[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54876 === (5))){
var _ = (function (){var statearr_54881 = state_54875;
(statearr_54881[(4)] = cljs.core.rest((state_54875[(4)])));

return statearr_54881;
})();
var state_54875__$1 = state_54875;
var ex54879 = (state_54875__$1[(2)]);
var statearr_54882_54897 = state_54875__$1;
(statearr_54882_54897[(5)] = ex54879);


if((ex54879 instanceof Error)){
var statearr_54883_54898 = state_54875__$1;
(statearr_54883_54898[(1)] = (4));

(statearr_54883_54898[(5)] = null);

} else {
throw ex54879;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54876 === (6))){
var inst_54853 = (state_54875[(2)]);
var inst_54854 = fluree.db.util.async.throw_err(inst_54853);
var inst_54855 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_54854);
var inst_54856 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54857 = [inst_54854];
var inst_54858 = (new cljs.core.PersistentVector(null,1,(5),inst_54856,inst_54857,null));
var inst_54859 = cljs.core.count(inst_54858);
var inst_54860 = ((9) + inst_54859);
var inst_54861 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54862 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54863 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54864 = [inst_54854];
var inst_54865 = (new cljs.core.PersistentVector(null,1,(5),inst_54863,inst_54864,null));
var inst_54866 = ["<",inst_54865,inst_54855];
var inst_54867 = cljs.core.PersistentHashMap.fromArrays(inst_54862,inst_54866);
var inst_54868 = [inst_54867,inst_54860];
var inst_54869 = (new cljs.core.PersistentVector(null,2,(5),inst_54861,inst_54868,null));
var inst_54870 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54869);
var _ = (function (){var statearr_54884 = state_54875;
(statearr_54884[(4)] = cljs.core.rest((state_54875[(4)])));

return statearr_54884;
})();
var state_54875__$1 = (function (){var statearr_54885 = state_54875;
(statearr_54885[(7)] = inst_54870);

return statearr_54885;
})();
var statearr_54886_54899 = state_54875__$1;
(statearr_54886_54899[(2)] = inst_54855);

(statearr_54886_54899[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2717__auto____0 = (function (){
var statearr_54887 = [null,null,null,null,null,null,null,null];
(statearr_54887[(0)] = fluree$db$dbfunctions$fns$state_machine__2717__auto__);

(statearr_54887[(1)] = (1));

return statearr_54887;
});
var fluree$db$dbfunctions$fns$state_machine__2717__auto____1 = (function (state_54875){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_54875);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e54888){var ex__2720__auto__ = e54888;
var statearr_54889_54900 = state_54875;
(statearr_54889_54900[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_54875[(4)]))){
var statearr_54890_54901 = state_54875;
(statearr_54890_54901[(1)] = cljs.core.first((state_54875[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54902 = state_54875;
state_54875 = G__54902;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2717__auto__ = function(state_54875){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____1.call(this,state_54875);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_54891 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_54891[(6)] = c__2739__auto__);

return statearr_54891;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq54843){
var G__54844 = cljs.core.first(seq54843);
var seq54843__$1 = cljs.core.next(seq54843);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54844,seq54843__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___54952 = arguments.length;
var i__4819__auto___54953 = (0);
while(true){
if((i__4819__auto___54953 < len__4818__auto___54952)){
args__4824__auto__.push((arguments[i__4819__auto___54953]));

var G__54954 = (i__4819__auto___54953 + (1));
i__4819__auto___54953 = G__54954;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_54935){
var state_val_54936 = (state_54935[(1)]);
if((state_val_54936 === (1))){
var state_54935__$1 = state_54935;
var statearr_54937_54955 = state_54935__$1;
(statearr_54937_54955[(2)] = null);

(statearr_54937_54955[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54936 === (2))){
var _ = (function (){var statearr_54938 = state_54935;
(statearr_54938[(4)] = cljs.core.cons((5),(state_54935[(4)])));

return statearr_54938;
})();
var inst_54911 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54935__$1 = state_54935;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54935__$1,(6),inst_54911);
} else {
if((state_val_54936 === (3))){
var inst_54933 = (state_54935[(2)]);
var state_54935__$1 = state_54935;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54935__$1,inst_54933);
} else {
if((state_val_54936 === (4))){
var inst_54905 = (state_54935[(2)]);
var state_54935__$1 = state_54935;
var statearr_54940_54956 = state_54935__$1;
(statearr_54940_54956[(2)] = inst_54905);

(statearr_54940_54956[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54936 === (5))){
var _ = (function (){var statearr_54941 = state_54935;
(statearr_54941[(4)] = cljs.core.rest((state_54935[(4)])));

return statearr_54941;
})();
var state_54935__$1 = state_54935;
var ex54939 = (state_54935__$1[(2)]);
var statearr_54942_54957 = state_54935__$1;
(statearr_54942_54957[(5)] = ex54939);


if((ex54939 instanceof Error)){
var statearr_54943_54958 = state_54935__$1;
(statearr_54943_54958[(1)] = (4));

(statearr_54943_54958[(5)] = null);

} else {
throw ex54939;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54936 === (6))){
var inst_54913 = (state_54935[(2)]);
var inst_54914 = fluree.db.util.async.throw_err(inst_54913);
var inst_54915 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_54914);
var inst_54916 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54917 = [inst_54914];
var inst_54918 = (new cljs.core.PersistentVector(null,1,(5),inst_54916,inst_54917,null));
var inst_54919 = cljs.core.count(inst_54918);
var inst_54920 = ((9) + inst_54919);
var inst_54921 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54922 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54923 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54924 = [inst_54914];
var inst_54925 = (new cljs.core.PersistentVector(null,1,(5),inst_54923,inst_54924,null));
var inst_54926 = ["<=",inst_54925,inst_54915];
var inst_54927 = cljs.core.PersistentHashMap.fromArrays(inst_54922,inst_54926);
var inst_54928 = [inst_54927,inst_54920];
var inst_54929 = (new cljs.core.PersistentVector(null,2,(5),inst_54921,inst_54928,null));
var inst_54930 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54929);
var _ = (function (){var statearr_54944 = state_54935;
(statearr_54944[(4)] = cljs.core.rest((state_54935[(4)])));

return statearr_54944;
})();
var state_54935__$1 = (function (){var statearr_54945 = state_54935;
(statearr_54945[(7)] = inst_54930);

return statearr_54945;
})();
var statearr_54946_54959 = state_54935__$1;
(statearr_54946_54959[(2)] = inst_54915);

(statearr_54946_54959[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2717__auto____0 = (function (){
var statearr_54947 = [null,null,null,null,null,null,null,null];
(statearr_54947[(0)] = fluree$db$dbfunctions$fns$state_machine__2717__auto__);

(statearr_54947[(1)] = (1));

return statearr_54947;
});
var fluree$db$dbfunctions$fns$state_machine__2717__auto____1 = (function (state_54935){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_54935);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e54948){var ex__2720__auto__ = e54948;
var statearr_54949_54960 = state_54935;
(statearr_54949_54960[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_54935[(4)]))){
var statearr_54950_54961 = state_54935;
(statearr_54950_54961[(1)] = cljs.core.first((state_54935[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54962 = state_54935;
state_54935 = G__54962;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2717__auto__ = function(state_54935){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____1.call(this,state_54935);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_54951 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_54951[(6)] = c__2739__auto__);

return statearr_54951;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq54903){
var G__54904 = cljs.core.first(seq54903);
var seq54903__$1 = cljs.core.next(seq54903);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54904,seq54903__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___55012 = arguments.length;
var i__4819__auto___55013 = (0);
while(true){
if((i__4819__auto___55013 < len__4818__auto___55012)){
args__4824__auto__.push((arguments[i__4819__auto___55013]));

var G__55014 = (i__4819__auto___55013 + (1));
i__4819__auto___55013 = G__55014;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_54995){
var state_val_54996 = (state_54995[(1)]);
if((state_val_54996 === (1))){
var state_54995__$1 = state_54995;
var statearr_54997_55015 = state_54995__$1;
(statearr_54997_55015[(2)] = null);

(statearr_54997_55015[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54996 === (2))){
var _ = (function (){var statearr_54998 = state_54995;
(statearr_54998[(4)] = cljs.core.cons((5),(state_54995[(4)])));

return statearr_54998;
})();
var inst_54971 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54995__$1 = state_54995;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54995__$1,(6),inst_54971);
} else {
if((state_val_54996 === (3))){
var inst_54993 = (state_54995[(2)]);
var state_54995__$1 = state_54995;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54995__$1,inst_54993);
} else {
if((state_val_54996 === (4))){
var inst_54965 = (state_54995[(2)]);
var state_54995__$1 = state_54995;
var statearr_55000_55016 = state_54995__$1;
(statearr_55000_55016[(2)] = inst_54965);

(statearr_55000_55016[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54996 === (5))){
var _ = (function (){var statearr_55001 = state_54995;
(statearr_55001[(4)] = cljs.core.rest((state_54995[(4)])));

return statearr_55001;
})();
var state_54995__$1 = state_54995;
var ex54999 = (state_54995__$1[(2)]);
var statearr_55002_55017 = state_54995__$1;
(statearr_55002_55017[(5)] = ex54999);


if((ex54999 instanceof Error)){
var statearr_55003_55018 = state_54995__$1;
(statearr_55003_55018[(1)] = (4));

(statearr_55003_55018[(5)] = null);

} else {
throw ex54999;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54996 === (6))){
var inst_54973 = (state_54995[(2)]);
var inst_54974 = fluree.db.util.async.throw_err(inst_54973);
var inst_54975 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_54974);
var inst_54976 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54977 = [inst_54974];
var inst_54978 = (new cljs.core.PersistentVector(null,1,(5),inst_54976,inst_54977,null));
var inst_54979 = cljs.core.count(inst_54978);
var inst_54980 = ((9) + inst_54979);
var inst_54981 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54982 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54983 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54984 = [inst_54974];
var inst_54985 = (new cljs.core.PersistentVector(null,1,(5),inst_54983,inst_54984,null));
var inst_54986 = [">=",inst_54985,inst_54975];
var inst_54987 = cljs.core.PersistentHashMap.fromArrays(inst_54982,inst_54986);
var inst_54988 = [inst_54987,inst_54980];
var inst_54989 = (new cljs.core.PersistentVector(null,2,(5),inst_54981,inst_54988,null));
var inst_54990 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54989);
var _ = (function (){var statearr_55004 = state_54995;
(statearr_55004[(4)] = cljs.core.rest((state_54995[(4)])));

return statearr_55004;
})();
var state_54995__$1 = (function (){var statearr_55005 = state_54995;
(statearr_55005[(7)] = inst_54990);

return statearr_55005;
})();
var statearr_55006_55019 = state_54995__$1;
(statearr_55006_55019[(2)] = inst_54975);

(statearr_55006_55019[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2717__auto____0 = (function (){
var statearr_55007 = [null,null,null,null,null,null,null,null];
(statearr_55007[(0)] = fluree$db$dbfunctions$fns$state_machine__2717__auto__);

(statearr_55007[(1)] = (1));

return statearr_55007;
});
var fluree$db$dbfunctions$fns$state_machine__2717__auto____1 = (function (state_54995){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_54995);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e55008){var ex__2720__auto__ = e55008;
var statearr_55009_55020 = state_54995;
(statearr_55009_55020[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_54995[(4)]))){
var statearr_55010_55021 = state_54995;
(statearr_55010_55021[(1)] = cljs.core.first((state_54995[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55022 = state_54995;
state_54995 = G__55022;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2717__auto__ = function(state_54995){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____1.call(this,state_54995);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_55011 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_55011[(6)] = c__2739__auto__);

return statearr_55011;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq54963){
var G__54964 = cljs.core.first(seq54963);
var seq54963__$1 = cljs.core.next(seq54963);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54964,seq54963__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___55072 = arguments.length;
var i__4819__auto___55073 = (0);
while(true){
if((i__4819__auto___55073 < len__4818__auto___55072)){
args__4824__auto__.push((arguments[i__4819__auto___55073]));

var G__55074 = (i__4819__auto___55073 + (1));
i__4819__auto___55073 = G__55074;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_55055){
var state_val_55056 = (state_55055[(1)]);
if((state_val_55056 === (1))){
var state_55055__$1 = state_55055;
var statearr_55057_55075 = state_55055__$1;
(statearr_55057_55075[(2)] = null);

(statearr_55057_55075[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55056 === (2))){
var _ = (function (){var statearr_55058 = state_55055;
(statearr_55058[(4)] = cljs.core.cons((5),(state_55055[(4)])));

return statearr_55058;
})();
var inst_55031 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55055__$1 = state_55055;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55055__$1,(6),inst_55031);
} else {
if((state_val_55056 === (3))){
var inst_55053 = (state_55055[(2)]);
var state_55055__$1 = state_55055;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55055__$1,inst_55053);
} else {
if((state_val_55056 === (4))){
var inst_55025 = (state_55055[(2)]);
var state_55055__$1 = state_55055;
var statearr_55060_55076 = state_55055__$1;
(statearr_55060_55076[(2)] = inst_55025);

(statearr_55060_55076[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55056 === (5))){
var _ = (function (){var statearr_55061 = state_55055;
(statearr_55061[(4)] = cljs.core.rest((state_55055[(4)])));

return statearr_55061;
})();
var state_55055__$1 = state_55055;
var ex55059 = (state_55055__$1[(2)]);
var statearr_55062_55077 = state_55055__$1;
(statearr_55062_55077[(5)] = ex55059);


if((ex55059 instanceof Error)){
var statearr_55063_55078 = state_55055__$1;
(statearr_55063_55078[(1)] = (4));

(statearr_55063_55078[(5)] = null);

} else {
throw ex55059;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55056 === (6))){
var inst_55033 = (state_55055[(2)]);
var inst_55034 = fluree.db.util.async.throw_err(inst_55033);
var inst_55035 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.not_EQ_,inst_55034);
var inst_55036 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55037 = [inst_55034];
var inst_55038 = (new cljs.core.PersistentVector(null,1,(5),inst_55036,inst_55037,null));
var inst_55039 = cljs.core.count(inst_55038);
var inst_55040 = ((9) + inst_55039);
var inst_55041 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55042 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55043 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55044 = [inst_55034];
var inst_55045 = (new cljs.core.PersistentVector(null,1,(5),inst_55043,inst_55044,null));
var inst_55046 = ["not=",inst_55045,inst_55035];
var inst_55047 = cljs.core.PersistentHashMap.fromArrays(inst_55042,inst_55046);
var inst_55048 = [inst_55047,inst_55040];
var inst_55049 = (new cljs.core.PersistentVector(null,2,(5),inst_55041,inst_55048,null));
var inst_55050 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55049);
var _ = (function (){var statearr_55064 = state_55055;
(statearr_55064[(4)] = cljs.core.rest((state_55055[(4)])));

return statearr_55064;
})();
var state_55055__$1 = (function (){var statearr_55065 = state_55055;
(statearr_55065[(7)] = inst_55050);

return statearr_55065;
})();
var statearr_55066_55079 = state_55055__$1;
(statearr_55066_55079[(2)] = inst_55035);

(statearr_55066_55079[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2717__auto____0 = (function (){
var statearr_55067 = [null,null,null,null,null,null,null,null];
(statearr_55067[(0)] = fluree$db$dbfunctions$fns$state_machine__2717__auto__);

(statearr_55067[(1)] = (1));

return statearr_55067;
});
var fluree$db$dbfunctions$fns$state_machine__2717__auto____1 = (function (state_55055){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_55055);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e55068){var ex__2720__auto__ = e55068;
var statearr_55069_55080 = state_55055;
(statearr_55069_55080[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_55055[(4)]))){
var statearr_55070_55081 = state_55055;
(statearr_55070_55081[(1)] = cljs.core.first((state_55055[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55082 = state_55055;
state_55055 = G__55082;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2717__auto__ = function(state_55055){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____1.call(this,state_55055);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_55071 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_55071[(6)] = c__2739__auto__);

return statearr_55071;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq55023){
var G__55024 = cljs.core.first(seq55023);
var seq55023__$1 = cljs.core.next(seq55023);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55024,seq55023__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4824__auto__ = [];
var len__4818__auto___55132 = arguments.length;
var i__4819__auto___55133 = (0);
while(true){
if((i__4819__auto___55133 < len__4818__auto___55132)){
args__4824__auto__.push((arguments[i__4819__auto___55133]));

var G__55134 = (i__4819__auto___55133 + (1));
i__4819__auto___55133 = G__55134;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_55115){
var state_val_55116 = (state_55115[(1)]);
if((state_val_55116 === (1))){
var state_55115__$1 = state_55115;
var statearr_55117_55135 = state_55115__$1;
(statearr_55117_55135[(2)] = null);

(statearr_55117_55135[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55116 === (2))){
var _ = (function (){var statearr_55118 = state_55115;
(statearr_55118[(4)] = cljs.core.cons((5),(state_55115[(4)])));

return statearr_55118;
})();
var inst_55091 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55115__$1 = state_55115;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55115__$1,(6),inst_55091);
} else {
if((state_val_55116 === (3))){
var inst_55113 = (state_55115[(2)]);
var state_55115__$1 = state_55115;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55115__$1,inst_55113);
} else {
if((state_val_55116 === (4))){
var inst_55085 = (state_55115[(2)]);
var state_55115__$1 = state_55115;
var statearr_55120_55136 = state_55115__$1;
(statearr_55120_55136[(2)] = inst_55085);

(statearr_55120_55136[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55116 === (5))){
var _ = (function (){var statearr_55121 = state_55115;
(statearr_55121[(4)] = cljs.core.rest((state_55115[(4)])));

return statearr_55121;
})();
var state_55115__$1 = state_55115;
var ex55119 = (state_55115__$1[(2)]);
var statearr_55122_55137 = state_55115__$1;
(statearr_55122_55137[(5)] = ex55119);


if((ex55119 instanceof Error)){
var statearr_55123_55138 = state_55115__$1;
(statearr_55123_55138[(1)] = (4));

(statearr_55123_55138[(5)] = null);

} else {
throw ex55119;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55116 === (6))){
var inst_55093 = (state_55115[(2)]);
var inst_55094 = fluree.db.util.async.throw_err(inst_55093);
var inst_55095 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_55094);
var inst_55096 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55097 = [inst_55094];
var inst_55098 = (new cljs.core.PersistentVector(null,1,(5),inst_55096,inst_55097,null));
var inst_55099 = cljs.core.count(inst_55098);
var inst_55100 = ((9) + inst_55099);
var inst_55101 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55102 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55103 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55104 = [inst_55094];
var inst_55105 = (new cljs.core.PersistentVector(null,1,(5),inst_55103,inst_55104,null));
var inst_55106 = ["max",inst_55105,inst_55095];
var inst_55107 = cljs.core.PersistentHashMap.fromArrays(inst_55102,inst_55106);
var inst_55108 = [inst_55107,inst_55100];
var inst_55109 = (new cljs.core.PersistentVector(null,2,(5),inst_55101,inst_55108,null));
var inst_55110 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55109);
var _ = (function (){var statearr_55124 = state_55115;
(statearr_55124[(4)] = cljs.core.rest((state_55115[(4)])));

return statearr_55124;
})();
var state_55115__$1 = (function (){var statearr_55125 = state_55115;
(statearr_55125[(7)] = inst_55110);

return statearr_55125;
})();
var statearr_55126_55139 = state_55115__$1;
(statearr_55126_55139[(2)] = inst_55095);

(statearr_55126_55139[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2717__auto____0 = (function (){
var statearr_55127 = [null,null,null,null,null,null,null,null];
(statearr_55127[(0)] = fluree$db$dbfunctions$fns$state_machine__2717__auto__);

(statearr_55127[(1)] = (1));

return statearr_55127;
});
var fluree$db$dbfunctions$fns$state_machine__2717__auto____1 = (function (state_55115){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_55115);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e55128){var ex__2720__auto__ = e55128;
var statearr_55129_55140 = state_55115;
(statearr_55129_55140[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_55115[(4)]))){
var statearr_55130_55141 = state_55115;
(statearr_55130_55141[(1)] = cljs.core.first((state_55115[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55142 = state_55115;
state_55115 = G__55142;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2717__auto__ = function(state_55115){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____1.call(this,state_55115);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_55131 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_55131[(6)] = c__2739__auto__);

return statearr_55131;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq55083){
var G__55084 = cljs.core.first(seq55083);
var seq55083__$1 = cljs.core.next(seq55083);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55084,seq55083__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4824__auto__ = [];
var len__4818__auto___55192 = arguments.length;
var i__4819__auto___55193 = (0);
while(true){
if((i__4819__auto___55193 < len__4818__auto___55192)){
args__4824__auto__.push((arguments[i__4819__auto___55193]));

var G__55194 = (i__4819__auto___55193 + (1));
i__4819__auto___55193 = G__55194;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_55175){
var state_val_55176 = (state_55175[(1)]);
if((state_val_55176 === (1))){
var state_55175__$1 = state_55175;
var statearr_55177_55195 = state_55175__$1;
(statearr_55177_55195[(2)] = null);

(statearr_55177_55195[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55176 === (2))){
var _ = (function (){var statearr_55178 = state_55175;
(statearr_55178[(4)] = cljs.core.cons((5),(state_55175[(4)])));

return statearr_55178;
})();
var inst_55151 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55175__$1 = state_55175;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55175__$1,(6),inst_55151);
} else {
if((state_val_55176 === (3))){
var inst_55173 = (state_55175[(2)]);
var state_55175__$1 = state_55175;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55175__$1,inst_55173);
} else {
if((state_val_55176 === (4))){
var inst_55145 = (state_55175[(2)]);
var state_55175__$1 = state_55175;
var statearr_55180_55196 = state_55175__$1;
(statearr_55180_55196[(2)] = inst_55145);

(statearr_55180_55196[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55176 === (5))){
var _ = (function (){var statearr_55181 = state_55175;
(statearr_55181[(4)] = cljs.core.rest((state_55175[(4)])));

return statearr_55181;
})();
var state_55175__$1 = state_55175;
var ex55179 = (state_55175__$1[(2)]);
var statearr_55182_55197 = state_55175__$1;
(statearr_55182_55197[(5)] = ex55179);


if((ex55179 instanceof Error)){
var statearr_55183_55198 = state_55175__$1;
(statearr_55183_55198[(1)] = (4));

(statearr_55183_55198[(5)] = null);

} else {
throw ex55179;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55176 === (6))){
var inst_55153 = (state_55175[(2)]);
var inst_55154 = fluree.db.util.async.throw_err(inst_55153);
var inst_55155 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_55154);
var inst_55156 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55157 = [inst_55154];
var inst_55158 = (new cljs.core.PersistentVector(null,1,(5),inst_55156,inst_55157,null));
var inst_55159 = cljs.core.count(inst_55158);
var inst_55160 = ((9) + inst_55159);
var inst_55161 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55162 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55163 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55164 = [inst_55154];
var inst_55165 = (new cljs.core.PersistentVector(null,1,(5),inst_55163,inst_55164,null));
var inst_55166 = ["min",inst_55165,inst_55155];
var inst_55167 = cljs.core.PersistentHashMap.fromArrays(inst_55162,inst_55166);
var inst_55168 = [inst_55167,inst_55160];
var inst_55169 = (new cljs.core.PersistentVector(null,2,(5),inst_55161,inst_55168,null));
var inst_55170 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55169);
var _ = (function (){var statearr_55184 = state_55175;
(statearr_55184[(4)] = cljs.core.rest((state_55175[(4)])));

return statearr_55184;
})();
var state_55175__$1 = (function (){var statearr_55185 = state_55175;
(statearr_55185[(7)] = inst_55170);

return statearr_55185;
})();
var statearr_55186_55199 = state_55175__$1;
(statearr_55186_55199[(2)] = inst_55155);

(statearr_55186_55199[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2717__auto____0 = (function (){
var statearr_55187 = [null,null,null,null,null,null,null,null];
(statearr_55187[(0)] = fluree$db$dbfunctions$fns$state_machine__2717__auto__);

(statearr_55187[(1)] = (1));

return statearr_55187;
});
var fluree$db$dbfunctions$fns$state_machine__2717__auto____1 = (function (state_55175){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_55175);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e55188){var ex__2720__auto__ = e55188;
var statearr_55189_55200 = state_55175;
(statearr_55189_55200[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_55175[(4)]))){
var statearr_55190_55201 = state_55175;
(statearr_55190_55201[(1)] = cljs.core.first((state_55175[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55202 = state_55175;
state_55175 = G__55202;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2717__auto__ = function(state_55175){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____1.call(this,state_55175);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_55191 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_55191[(6)] = c__2739__auto__);

return statearr_55191;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq55143){
var G__55144 = cljs.core.first(seq55143);
var seq55143__$1 = cljs.core.next(seq55143);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55144,seq55143__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__55204 = arguments.length;
switch (G__55204) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_55249){
var state_val_55250 = (state_55249[(1)]);
if((state_val_55250 === (7))){
var state_55249__$1 = state_55249;
var statearr_55251_55388 = state_55249__$1;
(statearr_55251_55388[(2)] = query_map);

(statearr_55251_55388[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55250 === (1))){
var state_55249__$1 = state_55249;
var statearr_55252_55389 = state_55249__$1;
(statearr_55252_55389[(2)] = null);

(statearr_55252_55389[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55250 === (4))){
var inst_55205 = (state_55249[(2)]);
var state_55249__$1 = state_55249;
var statearr_55253_55390 = state_55249__$1;
(statearr_55253_55390[(2)] = inst_55205);

(statearr_55253_55390[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55250 === (13))){
var inst_55227 = (state_55249[(7)]);
var inst_55231 = (state_55249[(2)]);
var inst_55232 = fluree.db.util.async.throw_err(inst_55231);
var inst_55233 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55232,(0),null);
var inst_55234 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55232,(1),null);
var inst_55235 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55236 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55237 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55238 = [inst_55227];
var inst_55239 = (new cljs.core.PersistentVector(null,1,(5),inst_55237,inst_55238,null));
var inst_55240 = ["query",inst_55239,inst_55233];
var inst_55241 = cljs.core.PersistentHashMap.fromArrays(inst_55236,inst_55240);
var inst_55242 = [inst_55241,inst_55234];
var inst_55243 = (new cljs.core.PersistentVector(null,2,(5),inst_55235,inst_55242,null));
var inst_55244 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55243);
var _ = (function (){var statearr_55254 = state_55249;
(statearr_55254[(4)] = cljs.core.rest((state_55249[(4)])));

return statearr_55254;
})();
var state_55249__$1 = (function (){var statearr_55255 = state_55249;
(statearr_55255[(8)] = inst_55244);

return statearr_55255;
})();
var statearr_55256_55391 = state_55249__$1;
(statearr_55256_55391[(2)] = inst_55233);

(statearr_55256_55391[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55250 === (6))){
var state_55249__$1 = state_55249;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55249__$1,(9),query_map);
} else {
if((state_val_55250 === (3))){
var inst_55247 = (state_55249[(2)]);
var state_55249__$1 = state_55249;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55249__$1,inst_55247);
} else {
if((state_val_55250 === (12))){
var inst_55227 = (state_55249[(7)]);
var inst_55227__$1 = (state_55249[(2)]);
var inst_55228 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55229 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_55228,inst_55227__$1);
var state_55249__$1 = (function (){var statearr_55257 = state_55249;
(statearr_55257[(7)] = inst_55227__$1);

return statearr_55257;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55249__$1,(13),inst_55229);
} else {
if((state_val_55250 === (2))){
var _ = (function (){var statearr_55258 = state_55249;
(statearr_55258[(4)] = cljs.core.cons((5),(state_55249[(4)])));

return statearr_55258;
})();
var inst_55214 = fluree.db.util.async.channel_QMARK_(query_map);
var state_55249__$1 = state_55249;
if(inst_55214){
var statearr_55259_55392 = state_55249__$1;
(statearr_55259_55392[(1)] = (6));

} else {
var statearr_55260_55393 = state_55249__$1;
(statearr_55260_55393[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55250 === (11))){
var inst_55221 = (state_55249[(9)]);
var state_55249__$1 = state_55249;
var statearr_55262_55394 = state_55249__$1;
(statearr_55262_55394[(2)] = inst_55221);

(statearr_55262_55394[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55250 === (9))){
var inst_55217 = (state_55249[(2)]);
var inst_55218 = fluree.db.util.async.throw_err(inst_55217);
var state_55249__$1 = state_55249;
var statearr_55263_55395 = state_55249__$1;
(statearr_55263_55395[(2)] = inst_55218);

(statearr_55263_55395[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55250 === (5))){
var _ = (function (){var statearr_55264 = state_55249;
(statearr_55264[(4)] = cljs.core.rest((state_55249[(4)])));

return statearr_55264;
})();
var state_55249__$1 = state_55249;
var ex55261 = (state_55249__$1[(2)]);
var statearr_55265_55396 = state_55249__$1;
(statearr_55265_55396[(5)] = ex55261);


if((ex55261 instanceof Error)){
var statearr_55266_55397 = state_55249__$1;
(statearr_55266_55397[(1)] = (4));

(statearr_55266_55397[(5)] = null);

} else {
throw ex55261;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55250 === (10))){
var inst_55221 = (state_55249[(9)]);
var inst_55224 = fluree.db.util.json.parse(inst_55221);
var state_55249__$1 = state_55249;
var statearr_55267_55398 = state_55249__$1;
(statearr_55267_55398[(2)] = inst_55224);

(statearr_55267_55398[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55250 === (8))){
var inst_55221 = (state_55249[(9)]);
var inst_55221__$1 = (state_55249[(2)]);
var inst_55222 = typeof inst_55221__$1 === 'string';
var state_55249__$1 = (function (){var statearr_55268 = state_55249;
(statearr_55268[(9)] = inst_55221__$1);

return statearr_55268;
})();
if(cljs.core.truth_(inst_55222)){
var statearr_55269_55399 = state_55249__$1;
(statearr_55269_55399[(1)] = (10));

} else {
var statearr_55270_55400 = state_55249__$1;
(statearr_55270_55400[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2717__auto____0 = (function (){
var statearr_55271 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55271[(0)] = fluree$db$dbfunctions$fns$state_machine__2717__auto__);

(statearr_55271[(1)] = (1));

return statearr_55271;
});
var fluree$db$dbfunctions$fns$state_machine__2717__auto____1 = (function (state_55249){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_55249);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e55272){var ex__2720__auto__ = e55272;
var statearr_55273_55401 = state_55249;
(statearr_55273_55401[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_55249[(4)]))){
var statearr_55274_55402 = state_55249;
(statearr_55274_55402[(1)] = cljs.core.first((state_55249[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55403 = state_55249;
state_55249 = G__55403;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2717__auto__ = function(state_55249){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____1.call(this,state_55249);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_55275 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_55275[(6)] = c__2739__auto__);

return statearr_55275;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_55346){
var state_val_55347 = (state_55346[(1)]);
if((state_val_55347 === (7))){
var state_55346__$1 = state_55346;
var statearr_55348_55404 = state_55346__$1;
(statearr_55348_55404[(2)] = select);

(statearr_55348_55404[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55347 === (20))){
var inst_55316 = (state_55346[(2)]);
var inst_55317 = fluree.db.util.async.channel_QMARK_(limit);
var state_55346__$1 = (function (){var statearr_55349 = state_55346;
(statearr_55349[(7)] = inst_55316);

return statearr_55349;
})();
if(inst_55317){
var statearr_55350_55405 = state_55346__$1;
(statearr_55350_55405[(1)] = (22));

} else {
var statearr_55351_55406 = state_55346__$1;
(statearr_55351_55406[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55347 === (1))){
var state_55346__$1 = state_55346;
var statearr_55352_55407 = state_55346__$1;
(statearr_55352_55407[(2)] = null);

(statearr_55352_55407[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55347 === (24))){
var inst_55292 = (state_55346[(8)]);
var inst_55300 = (state_55346[(9)]);
var inst_55316 = (state_55346[(7)]);
var inst_55308 = (state_55346[(10)]);
var inst_55324 = (state_55346[(2)]);
var inst_55325 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55326 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_55325,inst_55292,inst_55300,inst_55308,inst_55316,inst_55324);
var state_55346__$1 = state_55346;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55346__$1,(26),inst_55326);
} else {
if((state_val_55347 === (4))){
var inst_55276 = (state_55346[(2)]);
var state_55346__$1 = state_55346;
var statearr_55353_55408 = state_55346__$1;
(statearr_55353_55408[(2)] = inst_55276);

(statearr_55353_55408[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55347 === (15))){
var state_55346__$1 = state_55346;
var statearr_55354_55409 = state_55346__$1;
(statearr_55354_55409[(2)] = where);

(statearr_55354_55409[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55347 === (21))){
var inst_55312 = (state_55346[(2)]);
var inst_55313 = fluree.db.util.async.throw_err(inst_55312);
var state_55346__$1 = state_55346;
var statearr_55355_55410 = state_55346__$1;
(statearr_55355_55410[(2)] = inst_55313);

(statearr_55355_55410[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55347 === (13))){
var inst_55296 = (state_55346[(2)]);
var inst_55297 = fluree.db.util.async.throw_err(inst_55296);
var state_55346__$1 = state_55346;
var statearr_55356_55411 = state_55346__$1;
(statearr_55356_55411[(2)] = inst_55297);

(statearr_55356_55411[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55347 === (22))){
var state_55346__$1 = state_55346;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55346__$1,(25),limit);
} else {
if((state_val_55347 === (6))){
var state_55346__$1 = state_55346;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55346__$1,(9),select);
} else {
if((state_val_55347 === (25))){
var inst_55320 = (state_55346[(2)]);
var inst_55321 = fluree.db.util.async.throw_err(inst_55320);
var state_55346__$1 = state_55346;
var statearr_55357_55412 = state_55346__$1;
(statearr_55357_55412[(2)] = inst_55321);

(statearr_55357_55412[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55347 === (17))){
var inst_55304 = (state_55346[(2)]);
var inst_55305 = fluree.db.util.async.throw_err(inst_55304);
var state_55346__$1 = state_55346;
var statearr_55358_55413 = state_55346__$1;
(statearr_55358_55413[(2)] = inst_55305);

(statearr_55358_55413[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55347 === (3))){
var inst_55344 = (state_55346[(2)]);
var state_55346__$1 = state_55346;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55346__$1,inst_55344);
} else {
if((state_val_55347 === (12))){
var inst_55300 = (state_55346[(2)]);
var inst_55301 = fluree.db.util.async.channel_QMARK_(where);
var state_55346__$1 = (function (){var statearr_55359 = state_55346;
(statearr_55359[(9)] = inst_55300);

return statearr_55359;
})();
if(inst_55301){
var statearr_55360_55414 = state_55346__$1;
(statearr_55360_55414[(1)] = (14));

} else {
var statearr_55361_55415 = state_55346__$1;
(statearr_55361_55415[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55347 === (2))){
var _ = (function (){var statearr_55362 = state_55346;
(statearr_55362[(4)] = cljs.core.cons((5),(state_55346[(4)])));

return statearr_55362;
})();
var inst_55285 = fluree.db.util.async.channel_QMARK_(select);
var state_55346__$1 = state_55346;
if(inst_55285){
var statearr_55363_55416 = state_55346__$1;
(statearr_55363_55416[(1)] = (6));

} else {
var statearr_55364_55417 = state_55346__$1;
(statearr_55364_55417[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55347 === (23))){
var state_55346__$1 = state_55346;
var statearr_55365_55418 = state_55346__$1;
(statearr_55365_55418[(2)] = limit);

(statearr_55365_55418[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55347 === (19))){
var state_55346__$1 = state_55346;
var statearr_55366_55419 = state_55346__$1;
(statearr_55366_55419[(2)] = block);

(statearr_55366_55419[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55347 === (11))){
var state_55346__$1 = state_55346;
var statearr_55368_55420 = state_55346__$1;
(statearr_55368_55420[(2)] = from);

(statearr_55368_55420[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55347 === (9))){
var inst_55288 = (state_55346[(2)]);
var inst_55289 = fluree.db.util.async.throw_err(inst_55288);
var state_55346__$1 = state_55346;
var statearr_55369_55421 = state_55346__$1;
(statearr_55369_55421[(2)] = inst_55289);

(statearr_55369_55421[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55347 === (5))){
var _ = (function (){var statearr_55370 = state_55346;
(statearr_55370[(4)] = cljs.core.rest((state_55346[(4)])));

return statearr_55370;
})();
var state_55346__$1 = state_55346;
var ex55367 = (state_55346__$1[(2)]);
var statearr_55371_55422 = state_55346__$1;
(statearr_55371_55422[(5)] = ex55367);


if((ex55367 instanceof Error)){
var statearr_55372_55423 = state_55346__$1;
(statearr_55372_55423[(1)] = (4));

(statearr_55372_55423[(5)] = null);

} else {
throw ex55367;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55347 === (14))){
var state_55346__$1 = state_55346;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55346__$1,(17),where);
} else {
if((state_val_55347 === (26))){
var inst_55292 = (state_55346[(8)]);
var inst_55300 = (state_55346[(9)]);
var inst_55316 = (state_55346[(7)]);
var inst_55308 = (state_55346[(10)]);
var inst_55328 = (state_55346[(2)]);
var inst_55329 = fluree.db.util.async.throw_err(inst_55328);
var inst_55330 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55329,(0),null);
var inst_55331 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55329,(1),null);
var inst_55332 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55333 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55334 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55335 = [inst_55292,inst_55300,inst_55308,inst_55316];
var inst_55336 = (new cljs.core.PersistentVector(null,4,(5),inst_55334,inst_55335,null));
var inst_55337 = ["query",inst_55336,inst_55330];
var inst_55338 = cljs.core.PersistentHashMap.fromArrays(inst_55333,inst_55337);
var inst_55339 = [inst_55338,inst_55331];
var inst_55340 = (new cljs.core.PersistentVector(null,2,(5),inst_55332,inst_55339,null));
var inst_55341 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55340);
var _ = (function (){var statearr_55373 = state_55346;
(statearr_55373[(4)] = cljs.core.rest((state_55346[(4)])));

return statearr_55373;
})();
var state_55346__$1 = (function (){var statearr_55374 = state_55346;
(statearr_55374[(11)] = inst_55341);

return statearr_55374;
})();
var statearr_55375_55424 = state_55346__$1;
(statearr_55375_55424[(2)] = inst_55330);

(statearr_55375_55424[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55347 === (16))){
var inst_55308 = (state_55346[(2)]);
var inst_55309 = fluree.db.util.async.channel_QMARK_(block);
var state_55346__$1 = (function (){var statearr_55376 = state_55346;
(statearr_55376[(10)] = inst_55308);

return statearr_55376;
})();
if(inst_55309){
var statearr_55377_55425 = state_55346__$1;
(statearr_55377_55425[(1)] = (18));

} else {
var statearr_55378_55426 = state_55346__$1;
(statearr_55378_55426[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55347 === (10))){
var state_55346__$1 = state_55346;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55346__$1,(13),from);
} else {
if((state_val_55347 === (18))){
var state_55346__$1 = state_55346;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55346__$1,(21),block);
} else {
if((state_val_55347 === (8))){
var inst_55292 = (state_55346[(2)]);
var inst_55293 = fluree.db.util.async.channel_QMARK_(from);
var state_55346__$1 = (function (){var statearr_55379 = state_55346;
(statearr_55379[(8)] = inst_55292);

return statearr_55379;
})();
if(inst_55293){
var statearr_55380_55427 = state_55346__$1;
(statearr_55380_55427[(1)] = (10));

} else {
var statearr_55381_55428 = state_55346__$1;
(statearr_55381_55428[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2717__auto____0 = (function (){
var statearr_55382 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55382[(0)] = fluree$db$dbfunctions$fns$state_machine__2717__auto__);

(statearr_55382[(1)] = (1));

return statearr_55382;
});
var fluree$db$dbfunctions$fns$state_machine__2717__auto____1 = (function (state_55346){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_55346);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e55383){var ex__2720__auto__ = e55383;
var statearr_55384_55429 = state_55346;
(statearr_55384_55429[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_55346[(4)]))){
var statearr_55385_55430 = state_55346;
(statearr_55385_55430[(1)] = cljs.core.first((state_55346[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55431 = state_55346;
state_55346 = G__55431;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2717__auto__ = function(state_55346){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____1.call(this,state_55346);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_55386 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_55386[(6)] = c__2739__auto__);

return statearr_55386;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_55487){
var state_val_55488 = (state_55487[(1)]);
if((state_val_55488 === (7))){
var state_55487__$1 = state_55487;
var statearr_55489_55520 = state_55487__$1;
(statearr_55489_55520[(2)] = startSubject);

(statearr_55489_55520[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55488 === (1))){
var state_55487__$1 = state_55487;
var statearr_55490_55521 = state_55487__$1;
(statearr_55490_55521[(2)] = null);

(statearr_55490_55521[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55488 === (4))){
var inst_55432 = (state_55487[(2)]);
var state_55487__$1 = state_55487;
var statearr_55491_55522 = state_55487__$1;
(statearr_55491_55522[(2)] = inst_55432);

(statearr_55491_55522[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55488 === (15))){
var inst_55464 = (state_55487[(2)]);
var inst_55465 = fluree.db.util.async.throw_err(inst_55464);
var inst_55466 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55465,(0),null);
var inst_55467 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55465,(1),null);
var inst_55468 = cljs.core.empty_QMARK_(inst_55466);
var state_55487__$1 = (function (){var statearr_55492 = state_55487;
(statearr_55492[(7)] = inst_55467);

return statearr_55492;
})();
if(inst_55468){
var statearr_55493_55523 = state_55487__$1;
(statearr_55493_55523[(1)] = (16));

} else {
var statearr_55494_55524 = state_55487__$1;
(statearr_55494_55524[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55488 === (13))){
var inst_55460 = (state_55487[(8)]);
var inst_55452 = (state_55487[(9)]);
var inst_55448 = (state_55487[(10)]);
var inst_55460__$1 = (state_55487[(2)]);
var inst_55461 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55462 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_55461,inst_55448,inst_55452,inst_55460__$1);
var state_55487__$1 = (function (){var statearr_55495 = state_55487;
(statearr_55495[(8)] = inst_55460__$1);

return statearr_55495;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55487__$1,(15),inst_55462);
} else {
if((state_val_55488 === (6))){
var state_55487__$1 = state_55487;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55487__$1,(9),startSubject);
} else {
if((state_val_55488 === (17))){
var state_55487__$1 = state_55487;
var statearr_55496_55525 = state_55487__$1;
(statearr_55496_55525[(2)] = true);

(statearr_55496_55525[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55488 === (3))){
var inst_55485 = (state_55487[(2)]);
var state_55487__$1 = state_55487;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55487__$1,inst_55485);
} else {
if((state_val_55488 === (12))){
var state_55487__$1 = state_55487;
var statearr_55497_55526 = state_55487__$1;
(statearr_55497_55526[(2)] = endSubject);

(statearr_55497_55526[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55488 === (2))){
var _ = (function (){var statearr_55498 = state_55487;
(statearr_55498[(4)] = cljs.core.cons((5),(state_55487[(4)])));

return statearr_55498;
})();
var inst_55441 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_55487__$1 = state_55487;
if(inst_55441){
var statearr_55499_55527 = state_55487__$1;
(statearr_55499_55527[(1)] = (6));

} else {
var statearr_55500_55528 = state_55487__$1;
(statearr_55500_55528[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55488 === (11))){
var state_55487__$1 = state_55487;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55487__$1,(14),endSubject);
} else {
if((state_val_55488 === (9))){
var inst_55444 = (state_55487[(2)]);
var inst_55445 = fluree.db.util.async.throw_err(inst_55444);
var state_55487__$1 = state_55487;
var statearr_55502_55529 = state_55487__$1;
(statearr_55502_55529[(2)] = inst_55445);

(statearr_55502_55529[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55488 === (5))){
var _ = (function (){var statearr_55503 = state_55487;
(statearr_55503[(4)] = cljs.core.rest((state_55487[(4)])));

return statearr_55503;
})();
var state_55487__$1 = state_55487;
var ex55501 = (state_55487__$1[(2)]);
var statearr_55504_55530 = state_55487__$1;
(statearr_55504_55530[(5)] = ex55501);


if((ex55501 instanceof Error)){
var statearr_55505_55531 = state_55487__$1;
(statearr_55505_55531[(1)] = (4));

(statearr_55505_55531[(5)] = null);

} else {
throw ex55501;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55488 === (14))){
var inst_55456 = (state_55487[(2)]);
var inst_55457 = fluree.db.util.async.throw_err(inst_55456);
var state_55487__$1 = state_55487;
var statearr_55506_55532 = state_55487__$1;
(statearr_55506_55532[(2)] = inst_55457);

(statearr_55506_55532[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55488 === (16))){
var state_55487__$1 = state_55487;
var statearr_55507_55533 = state_55487__$1;
(statearr_55507_55533[(2)] = false);

(statearr_55507_55533[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55488 === (10))){
var inst_55451 = (state_55487[(2)]);
var inst_55452 = fluree.db.util.async.throw_err(inst_55451);
var inst_55453 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_55487__$1 = (function (){var statearr_55508 = state_55487;
(statearr_55508[(9)] = inst_55452);

return statearr_55508;
})();
if(inst_55453){
var statearr_55509_55534 = state_55487__$1;
(statearr_55509_55534[(1)] = (11));

} else {
var statearr_55510_55535 = state_55487__$1;
(statearr_55510_55535[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55488 === (18))){
var inst_55460 = (state_55487[(8)]);
var inst_55467 = (state_55487[(7)]);
var inst_55452 = (state_55487[(9)]);
var inst_55448 = (state_55487[(10)]);
var inst_55472 = (state_55487[(2)]);
var inst_55473 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55474 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55475 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55476 = [inst_55448,inst_55452,inst_55460];
var inst_55477 = (new cljs.core.PersistentVector(null,3,(5),inst_55475,inst_55476,null));
var inst_55478 = ["relationship?",inst_55477,inst_55472];
var inst_55479 = cljs.core.PersistentHashMap.fromArrays(inst_55474,inst_55478);
var inst_55480 = [inst_55479,inst_55467];
var inst_55481 = (new cljs.core.PersistentVector(null,2,(5),inst_55473,inst_55480,null));
var inst_55482 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55481);
var _ = (function (){var statearr_55511 = state_55487;
(statearr_55511[(4)] = cljs.core.rest((state_55487[(4)])));

return statearr_55511;
})();
var state_55487__$1 = (function (){var statearr_55512 = state_55487;
(statearr_55512[(11)] = inst_55482);

return statearr_55512;
})();
var statearr_55513_55536 = state_55487__$1;
(statearr_55513_55536[(2)] = inst_55472);

(statearr_55513_55536[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55488 === (8))){
var inst_55448 = (state_55487[(2)]);
var inst_55449 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_55487__$1 = (function (){var statearr_55514 = state_55487;
(statearr_55514[(10)] = inst_55448);

return statearr_55514;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55487__$1,(10),inst_55449);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2717__auto____0 = (function (){
var statearr_55515 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55515[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2717__auto__);

(statearr_55515[(1)] = (1));

return statearr_55515;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2717__auto____1 = (function (state_55487){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_55487);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e55516){var ex__2720__auto__ = e55516;
var statearr_55517_55537 = state_55487;
(statearr_55517_55537[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_55487[(4)]))){
var statearr_55518_55538 = state_55487;
(statearr_55518_55538[(1)] = cljs.core.first((state_55487[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55539 = state_55487;
state_55487 = G__55539;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2717__auto__ = function(state_55487){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2717__auto____1.call(this,state_55487);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_55519 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_55519[(6)] = c__2739__auto__);

return statearr_55519;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_55576){
var state_val_55577 = (state_55576[(1)]);
if((state_val_55577 === (7))){
var state_55576__$1 = state_55576;
var statearr_55578_55598 = state_55576__$1;
(statearr_55578_55598[(2)] = pred_name);

(statearr_55578_55598[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55577 === (1))){
var state_55576__$1 = state_55576;
var statearr_55579_55599 = state_55576__$1;
(statearr_55579_55599[(2)] = null);

(statearr_55579_55599[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55577 === (4))){
var inst_55540 = (state_55576[(2)]);
var state_55576__$1 = state_55576;
var statearr_55580_55600 = state_55576__$1;
(statearr_55580_55600[(2)] = inst_55540);

(statearr_55580_55600[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55577 === (6))){
var state_55576__$1 = state_55576;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55576__$1,(9),pred_name);
} else {
if((state_val_55577 === (3))){
var inst_55574 = (state_55576[(2)]);
var state_55576__$1 = state_55576;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55576__$1,inst_55574);
} else {
if((state_val_55577 === (2))){
var _ = (function (){var statearr_55582 = state_55576;
(statearr_55582[(4)] = cljs.core.cons((5),(state_55576[(4)])));

return statearr_55582;
})();
var inst_55549 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_55576__$1 = state_55576;
if(inst_55549){
var statearr_55583_55601 = state_55576__$1;
(statearr_55583_55601[(1)] = (6));

} else {
var statearr_55584_55602 = state_55576__$1;
(statearr_55584_55602[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55577 === (9))){
var inst_55552 = (state_55576[(2)]);
var inst_55553 = fluree.db.util.async.throw_err(inst_55552);
var state_55576__$1 = state_55576;
var statearr_55585_55603 = state_55576__$1;
(statearr_55585_55603[(2)] = inst_55553);

(statearr_55585_55603[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55577 === (5))){
var _ = (function (){var statearr_55586 = state_55576;
(statearr_55586[(4)] = cljs.core.rest((state_55576[(4)])));

return statearr_55586;
})();
var state_55576__$1 = state_55576;
var ex55581 = (state_55576__$1[(2)]);
var statearr_55587_55604 = state_55576__$1;
(statearr_55587_55604[(5)] = ex55581);


if((ex55581 instanceof Error)){
var statearr_55588_55605 = state_55576__$1;
(statearr_55588_55605[(1)] = (4));

(statearr_55588_55605[(5)] = null);

} else {
throw ex55581;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55577 === (10))){
var inst_55556 = (state_55576[(7)]);
var inst_55560 = (state_55576[(2)]);
var inst_55561 = fluree.db.util.async.throw_err(inst_55560);
var inst_55562 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55561,(0),null);
var inst_55563 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55561,(1),null);
var inst_55564 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55565 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55566 = ["max-pred-val",inst_55556,inst_55562];
var inst_55567 = cljs.core.PersistentHashMap.fromArrays(inst_55565,inst_55566);
var inst_55568 = (inst_55563 + (10));
var inst_55569 = [inst_55567,inst_55568];
var inst_55570 = (new cljs.core.PersistentVector(null,2,(5),inst_55564,inst_55569,null));
var inst_55571 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55570);
var _ = (function (){var statearr_55589 = state_55576;
(statearr_55589[(4)] = cljs.core.rest((state_55576[(4)])));

return statearr_55589;
})();
var state_55576__$1 = (function (){var statearr_55590 = state_55576;
(statearr_55590[(8)] = inst_55571);

return statearr_55590;
})();
var statearr_55591_55606 = state_55576__$1;
(statearr_55591_55606[(2)] = inst_55562);

(statearr_55591_55606[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55577 === (8))){
var inst_55556 = (state_55576[(7)]);
var inst_55556__$1 = (state_55576[(2)]);
var inst_55557 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55558 = fluree.db.dbfunctions.internal.max_pred_val(inst_55557,inst_55556__$1,null);
var state_55576__$1 = (function (){var statearr_55592 = state_55576;
(statearr_55592[(7)] = inst_55556__$1);

return statearr_55592;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55576__$1,(10),inst_55558);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2717__auto____0 = (function (){
var statearr_55593 = [null,null,null,null,null,null,null,null,null];
(statearr_55593[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2717__auto__);

(statearr_55593[(1)] = (1));

return statearr_55593;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2717__auto____1 = (function (state_55576){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_55576);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e55594){var ex__2720__auto__ = e55594;
var statearr_55595_55607 = state_55576;
(statearr_55595_55607[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_55576[(4)]))){
var statearr_55596_55608 = state_55576;
(statearr_55596_55608[(1)] = cljs.core.first((state_55576[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55609 = state_55576;
state_55576 = G__55609;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2717__auto__ = function(state_55576){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2717__auto____1.call(this,state_55576);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_55597 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_55597[(6)] = c__2739__auto__);

return statearr_55597;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_55636){
var state_val_55637 = (state_55636[(1)]);
if((state_val_55637 === (7))){
var state_55636__$1 = state_55636;
var statearr_55638_55657 = state_55636__$1;
(statearr_55638_55657[(2)] = n);

(statearr_55638_55657[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55637 === (1))){
var state_55636__$1 = state_55636;
var statearr_55639_55658 = state_55636__$1;
(statearr_55639_55658[(2)] = null);

(statearr_55639_55658[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55637 === (4))){
var inst_55610 = (state_55636[(2)]);
var state_55636__$1 = state_55636;
var statearr_55640_55659 = state_55636__$1;
(statearr_55640_55659[(2)] = inst_55610);

(statearr_55640_55659[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55637 === (6))){
var state_55636__$1 = state_55636;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55636__$1,(9),n);
} else {
if((state_val_55637 === (3))){
var inst_55634 = (state_55636[(2)]);
var state_55636__$1 = state_55636;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55636__$1,inst_55634);
} else {
if((state_val_55637 === (2))){
var _ = (function (){var statearr_55642 = state_55636;
(statearr_55642[(4)] = cljs.core.cons((5),(state_55636[(4)])));

return statearr_55642;
})();
var inst_55616 = fluree.db.util.async.channel_QMARK_(n);
var state_55636__$1 = state_55636;
if(inst_55616){
var statearr_55643_55660 = state_55636__$1;
(statearr_55643_55660[(1)] = (6));

} else {
var statearr_55644_55661 = state_55636__$1;
(statearr_55644_55661[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55637 === (9))){
var inst_55619 = (state_55636[(2)]);
var inst_55620 = fluree.db.util.async.throw_err(inst_55619);
var state_55636__$1 = state_55636;
var statearr_55645_55662 = state_55636__$1;
(statearr_55645_55662[(2)] = inst_55620);

(statearr_55645_55662[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55637 === (5))){
var _ = (function (){var statearr_55646 = state_55636;
(statearr_55646[(4)] = cljs.core.rest((state_55636[(4)])));

return statearr_55646;
})();
var state_55636__$1 = state_55636;
var ex55641 = (state_55636__$1[(2)]);
var statearr_55647_55663 = state_55636__$1;
(statearr_55647_55663[(5)] = ex55641);


if((ex55641 instanceof Error)){
var statearr_55648_55664 = state_55636__$1;
(statearr_55648_55664[(1)] = (4));

(statearr_55648_55664[(5)] = null);

} else {
throw ex55641;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55637 === (8))){
var inst_55623 = (state_55636[(2)]);
var inst_55624 = fluree.db.dbfunctions.internal.inc(inst_55623);
var inst_55625 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55626 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55627 = ["inc",inst_55623,inst_55624];
var inst_55628 = cljs.core.PersistentHashMap.fromArrays(inst_55626,inst_55627);
var inst_55629 = [inst_55628,(10)];
var inst_55630 = (new cljs.core.PersistentVector(null,2,(5),inst_55625,inst_55629,null));
var inst_55631 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55630);
var _ = (function (){var statearr_55649 = state_55636;
(statearr_55649[(4)] = cljs.core.rest((state_55636[(4)])));

return statearr_55649;
})();
var state_55636__$1 = (function (){var statearr_55650 = state_55636;
(statearr_55650[(7)] = inst_55631);

return statearr_55650;
})();
var statearr_55651_55665 = state_55636__$1;
(statearr_55651_55665[(2)] = inst_55624);

(statearr_55651_55665[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__2717__auto____0 = (function (){
var statearr_55652 = [null,null,null,null,null,null,null,null];
(statearr_55652[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__2717__auto__);

(statearr_55652[(1)] = (1));

return statearr_55652;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__2717__auto____1 = (function (state_55636){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_55636);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e55653){var ex__2720__auto__ = e55653;
var statearr_55654_55666 = state_55636;
(statearr_55654_55666[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_55636[(4)]))){
var statearr_55655_55667 = state_55636;
(statearr_55655_55667[(1)] = cljs.core.first((state_55636[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55668 = state_55636;
state_55636 = G__55668;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__2717__auto__ = function(state_55636){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2717__auto____1.call(this,state_55636);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_55656 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_55656[(6)] = c__2739__auto__);

return statearr_55656;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_55695){
var state_val_55696 = (state_55695[(1)]);
if((state_val_55696 === (7))){
var state_55695__$1 = state_55695;
var statearr_55697_55716 = state_55695__$1;
(statearr_55697_55716[(2)] = n);

(statearr_55697_55716[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55696 === (1))){
var state_55695__$1 = state_55695;
var statearr_55698_55717 = state_55695__$1;
(statearr_55698_55717[(2)] = null);

(statearr_55698_55717[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55696 === (4))){
var inst_55669 = (state_55695[(2)]);
var state_55695__$1 = state_55695;
var statearr_55699_55718 = state_55695__$1;
(statearr_55699_55718[(2)] = inst_55669);

(statearr_55699_55718[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55696 === (6))){
var state_55695__$1 = state_55695;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55695__$1,(9),n);
} else {
if((state_val_55696 === (3))){
var inst_55693 = (state_55695[(2)]);
var state_55695__$1 = state_55695;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55695__$1,inst_55693);
} else {
if((state_val_55696 === (2))){
var _ = (function (){var statearr_55701 = state_55695;
(statearr_55701[(4)] = cljs.core.cons((5),(state_55695[(4)])));

return statearr_55701;
})();
var inst_55675 = fluree.db.util.async.channel_QMARK_(n);
var state_55695__$1 = state_55695;
if(inst_55675){
var statearr_55702_55719 = state_55695__$1;
(statearr_55702_55719[(1)] = (6));

} else {
var statearr_55703_55720 = state_55695__$1;
(statearr_55703_55720[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55696 === (9))){
var inst_55678 = (state_55695[(2)]);
var inst_55679 = fluree.db.util.async.throw_err(inst_55678);
var state_55695__$1 = state_55695;
var statearr_55704_55721 = state_55695__$1;
(statearr_55704_55721[(2)] = inst_55679);

(statearr_55704_55721[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55696 === (5))){
var _ = (function (){var statearr_55705 = state_55695;
(statearr_55705[(4)] = cljs.core.rest((state_55695[(4)])));

return statearr_55705;
})();
var state_55695__$1 = state_55695;
var ex55700 = (state_55695__$1[(2)]);
var statearr_55706_55722 = state_55695__$1;
(statearr_55706_55722[(5)] = ex55700);


if((ex55700 instanceof Error)){
var statearr_55707_55723 = state_55695__$1;
(statearr_55707_55723[(1)] = (4));

(statearr_55707_55723[(5)] = null);

} else {
throw ex55700;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55696 === (8))){
var inst_55682 = (state_55695[(2)]);
var inst_55683 = fluree.db.dbfunctions.internal.dec(inst_55682);
var inst_55684 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55685 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55686 = ["dec",inst_55682,inst_55683];
var inst_55687 = cljs.core.PersistentHashMap.fromArrays(inst_55685,inst_55686);
var inst_55688 = [inst_55687,(10)];
var inst_55689 = (new cljs.core.PersistentVector(null,2,(5),inst_55684,inst_55688,null));
var inst_55690 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55689);
var _ = (function (){var statearr_55708 = state_55695;
(statearr_55708[(4)] = cljs.core.rest((state_55695[(4)])));

return statearr_55708;
})();
var state_55695__$1 = (function (){var statearr_55709 = state_55695;
(statearr_55709[(7)] = inst_55690);

return statearr_55709;
})();
var statearr_55710_55724 = state_55695__$1;
(statearr_55710_55724[(2)] = inst_55683);

(statearr_55710_55724[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__2717__auto____0 = (function (){
var statearr_55711 = [null,null,null,null,null,null,null,null];
(statearr_55711[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__2717__auto__);

(statearr_55711[(1)] = (1));

return statearr_55711;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__2717__auto____1 = (function (state_55695){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_55695);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e55712){var ex__2720__auto__ = e55712;
var statearr_55713_55725 = state_55695;
(statearr_55713_55725[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_55695[(4)]))){
var statearr_55714_55726 = state_55695;
(statearr_55714_55726[(1)] = cljs.core.first((state_55695[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55727 = state_55695;
state_55695 = G__55727;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__2717__auto__ = function(state_55695){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2717__auto____1.call(this,state_55695);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_55715 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_55715[(6)] = c__2739__auto__);

return statearr_55715;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___55777 = arguments.length;
var i__4819__auto___55778 = (0);
while(true){
if((i__4819__auto___55778 < len__4818__auto___55777)){
args__4824__auto__.push((arguments[i__4819__auto___55778]));

var G__55779 = (i__4819__auto___55778 + (1));
i__4819__auto___55778 = G__55779;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_55760){
var state_val_55761 = (state_55760[(1)]);
if((state_val_55761 === (1))){
var state_55760__$1 = state_55760;
var statearr_55762_55780 = state_55760__$1;
(statearr_55762_55780[(2)] = null);

(statearr_55762_55780[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55761 === (2))){
var _ = (function (){var statearr_55763 = state_55760;
(statearr_55763[(4)] = cljs.core.cons((5),(state_55760[(4)])));

return statearr_55763;
})();
var inst_55736 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55760__$1 = state_55760;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55760__$1,(6),inst_55736);
} else {
if((state_val_55761 === (3))){
var inst_55758 = (state_55760[(2)]);
var state_55760__$1 = state_55760;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55760__$1,inst_55758);
} else {
if((state_val_55761 === (4))){
var inst_55730 = (state_55760[(2)]);
var state_55760__$1 = state_55760;
var statearr_55765_55781 = state_55760__$1;
(statearr_55765_55781[(2)] = inst_55730);

(statearr_55765_55781[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55761 === (5))){
var _ = (function (){var statearr_55766 = state_55760;
(statearr_55766[(4)] = cljs.core.rest((state_55760[(4)])));

return statearr_55766;
})();
var state_55760__$1 = state_55760;
var ex55764 = (state_55760__$1[(2)]);
var statearr_55767_55782 = state_55760__$1;
(statearr_55767_55782[(5)] = ex55764);


if((ex55764 instanceof Error)){
var statearr_55768_55783 = state_55760__$1;
(statearr_55768_55783[(1)] = (4));

(statearr_55768_55783[(5)] = null);

} else {
throw ex55764;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55761 === (6))){
var inst_55738 = (state_55760[(2)]);
var inst_55739 = fluree.db.util.async.throw_err(inst_55738);
var inst_55740 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_55739);
var inst_55741 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55742 = [inst_55739];
var inst_55743 = (new cljs.core.PersistentVector(null,1,(5),inst_55741,inst_55742,null));
var inst_55744 = cljs.core.count(inst_55743);
var inst_55745 = ((9) + inst_55744);
var inst_55746 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55747 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55748 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55749 = [inst_55739];
var inst_55750 = (new cljs.core.PersistentVector(null,1,(5),inst_55748,inst_55749,null));
var inst_55751 = ["+",inst_55750,inst_55740];
var inst_55752 = cljs.core.PersistentHashMap.fromArrays(inst_55747,inst_55751);
var inst_55753 = [inst_55752,inst_55745];
var inst_55754 = (new cljs.core.PersistentVector(null,2,(5),inst_55746,inst_55753,null));
var inst_55755 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55754);
var _ = (function (){var statearr_55769 = state_55760;
(statearr_55769[(4)] = cljs.core.rest((state_55760[(4)])));

return statearr_55769;
})();
var state_55760__$1 = (function (){var statearr_55770 = state_55760;
(statearr_55770[(7)] = inst_55755);

return statearr_55770;
})();
var statearr_55771_55784 = state_55760__$1;
(statearr_55771_55784[(2)] = inst_55740);

(statearr_55771_55784[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2717__auto____0 = (function (){
var statearr_55772 = [null,null,null,null,null,null,null,null];
(statearr_55772[(0)] = fluree$db$dbfunctions$fns$state_machine__2717__auto__);

(statearr_55772[(1)] = (1));

return statearr_55772;
});
var fluree$db$dbfunctions$fns$state_machine__2717__auto____1 = (function (state_55760){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_55760);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e55773){var ex__2720__auto__ = e55773;
var statearr_55774_55785 = state_55760;
(statearr_55774_55785[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_55760[(4)]))){
var statearr_55775_55786 = state_55760;
(statearr_55775_55786[(1)] = cljs.core.first((state_55760[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55787 = state_55760;
state_55760 = G__55787;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2717__auto__ = function(state_55760){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____1.call(this,state_55760);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_55776 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_55776[(6)] = c__2739__auto__);

return statearr_55776;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq55728){
var G__55729 = cljs.core.first(seq55728);
var seq55728__$1 = cljs.core.next(seq55728);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55729,seq55728__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___55837 = arguments.length;
var i__4819__auto___55838 = (0);
while(true){
if((i__4819__auto___55838 < len__4818__auto___55837)){
args__4824__auto__.push((arguments[i__4819__auto___55838]));

var G__55839 = (i__4819__auto___55838 + (1));
i__4819__auto___55838 = G__55839;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_55820){
var state_val_55821 = (state_55820[(1)]);
if((state_val_55821 === (1))){
var state_55820__$1 = state_55820;
var statearr_55822_55840 = state_55820__$1;
(statearr_55822_55840[(2)] = null);

(statearr_55822_55840[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55821 === (2))){
var _ = (function (){var statearr_55823 = state_55820;
(statearr_55823[(4)] = cljs.core.cons((5),(state_55820[(4)])));

return statearr_55823;
})();
var inst_55796 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55820__$1 = state_55820;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55820__$1,(6),inst_55796);
} else {
if((state_val_55821 === (3))){
var inst_55818 = (state_55820[(2)]);
var state_55820__$1 = state_55820;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55820__$1,inst_55818);
} else {
if((state_val_55821 === (4))){
var inst_55790 = (state_55820[(2)]);
var state_55820__$1 = state_55820;
var statearr_55825_55841 = state_55820__$1;
(statearr_55825_55841[(2)] = inst_55790);

(statearr_55825_55841[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55821 === (5))){
var _ = (function (){var statearr_55826 = state_55820;
(statearr_55826[(4)] = cljs.core.rest((state_55820[(4)])));

return statearr_55826;
})();
var state_55820__$1 = state_55820;
var ex55824 = (state_55820__$1[(2)]);
var statearr_55827_55842 = state_55820__$1;
(statearr_55827_55842[(5)] = ex55824);


if((ex55824 instanceof Error)){
var statearr_55828_55843 = state_55820__$1;
(statearr_55828_55843[(1)] = (4));

(statearr_55828_55843[(5)] = null);

} else {
throw ex55824;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55821 === (6))){
var inst_55798 = (state_55820[(2)]);
var inst_55799 = fluree.db.util.async.throw_err(inst_55798);
var inst_55800 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_55799);
var inst_55801 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55802 = [inst_55799];
var inst_55803 = (new cljs.core.PersistentVector(null,1,(5),inst_55801,inst_55802,null));
var inst_55804 = cljs.core.count(inst_55803);
var inst_55805 = ((9) + inst_55804);
var inst_55806 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55807 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55808 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55809 = [inst_55799];
var inst_55810 = (new cljs.core.PersistentVector(null,1,(5),inst_55808,inst_55809,null));
var inst_55811 = ["-",inst_55810,inst_55800];
var inst_55812 = cljs.core.PersistentHashMap.fromArrays(inst_55807,inst_55811);
var inst_55813 = [inst_55812,inst_55805];
var inst_55814 = (new cljs.core.PersistentVector(null,2,(5),inst_55806,inst_55813,null));
var inst_55815 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55814);
var _ = (function (){var statearr_55829 = state_55820;
(statearr_55829[(4)] = cljs.core.rest((state_55820[(4)])));

return statearr_55829;
})();
var state_55820__$1 = (function (){var statearr_55830 = state_55820;
(statearr_55830[(7)] = inst_55815);

return statearr_55830;
})();
var statearr_55831_55844 = state_55820__$1;
(statearr_55831_55844[(2)] = inst_55800);

(statearr_55831_55844[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2717__auto____0 = (function (){
var statearr_55832 = [null,null,null,null,null,null,null,null];
(statearr_55832[(0)] = fluree$db$dbfunctions$fns$state_machine__2717__auto__);

(statearr_55832[(1)] = (1));

return statearr_55832;
});
var fluree$db$dbfunctions$fns$state_machine__2717__auto____1 = (function (state_55820){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_55820);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e55833){var ex__2720__auto__ = e55833;
var statearr_55834_55845 = state_55820;
(statearr_55834_55845[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_55820[(4)]))){
var statearr_55835_55846 = state_55820;
(statearr_55835_55846[(1)] = cljs.core.first((state_55820[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55847 = state_55820;
state_55820 = G__55847;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2717__auto__ = function(state_55820){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____1.call(this,state_55820);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_55836 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_55836[(6)] = c__2739__auto__);

return statearr_55836;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq55788){
var G__55789 = cljs.core.first(seq55788);
var seq55788__$1 = cljs.core.next(seq55788);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55789,seq55788__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___55897 = arguments.length;
var i__4819__auto___55898 = (0);
while(true){
if((i__4819__auto___55898 < len__4818__auto___55897)){
args__4824__auto__.push((arguments[i__4819__auto___55898]));

var G__55899 = (i__4819__auto___55898 + (1));
i__4819__auto___55898 = G__55899;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_55880){
var state_val_55881 = (state_55880[(1)]);
if((state_val_55881 === (1))){
var state_55880__$1 = state_55880;
var statearr_55882_55900 = state_55880__$1;
(statearr_55882_55900[(2)] = null);

(statearr_55882_55900[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55881 === (2))){
var _ = (function (){var statearr_55883 = state_55880;
(statearr_55883[(4)] = cljs.core.cons((5),(state_55880[(4)])));

return statearr_55883;
})();
var inst_55856 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55880__$1 = state_55880;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55880__$1,(6),inst_55856);
} else {
if((state_val_55881 === (3))){
var inst_55878 = (state_55880[(2)]);
var state_55880__$1 = state_55880;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55880__$1,inst_55878);
} else {
if((state_val_55881 === (4))){
var inst_55850 = (state_55880[(2)]);
var state_55880__$1 = state_55880;
var statearr_55885_55901 = state_55880__$1;
(statearr_55885_55901[(2)] = inst_55850);

(statearr_55885_55901[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55881 === (5))){
var _ = (function (){var statearr_55886 = state_55880;
(statearr_55886[(4)] = cljs.core.rest((state_55880[(4)])));

return statearr_55886;
})();
var state_55880__$1 = state_55880;
var ex55884 = (state_55880__$1[(2)]);
var statearr_55887_55902 = state_55880__$1;
(statearr_55887_55902[(5)] = ex55884);


if((ex55884 instanceof Error)){
var statearr_55888_55903 = state_55880__$1;
(statearr_55888_55903[(1)] = (4));

(statearr_55888_55903[(5)] = null);

} else {
throw ex55884;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55881 === (6))){
var inst_55858 = (state_55880[(2)]);
var inst_55859 = fluree.db.util.async.throw_err(inst_55858);
var inst_55860 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_55859);
var inst_55861 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55862 = [inst_55859];
var inst_55863 = (new cljs.core.PersistentVector(null,1,(5),inst_55861,inst_55862,null));
var inst_55864 = cljs.core.count(inst_55863);
var inst_55865 = ((9) + inst_55864);
var inst_55866 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55867 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55868 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55869 = [inst_55859];
var inst_55870 = (new cljs.core.PersistentVector(null,1,(5),inst_55868,inst_55869,null));
var inst_55871 = ["*",inst_55870,inst_55860];
var inst_55872 = cljs.core.PersistentHashMap.fromArrays(inst_55867,inst_55871);
var inst_55873 = [inst_55872,inst_55865];
var inst_55874 = (new cljs.core.PersistentVector(null,2,(5),inst_55866,inst_55873,null));
var inst_55875 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55874);
var _ = (function (){var statearr_55889 = state_55880;
(statearr_55889[(4)] = cljs.core.rest((state_55880[(4)])));

return statearr_55889;
})();
var state_55880__$1 = (function (){var statearr_55890 = state_55880;
(statearr_55890[(7)] = inst_55875);

return statearr_55890;
})();
var statearr_55891_55904 = state_55880__$1;
(statearr_55891_55904[(2)] = inst_55860);

(statearr_55891_55904[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2717__auto____0 = (function (){
var statearr_55892 = [null,null,null,null,null,null,null,null];
(statearr_55892[(0)] = fluree$db$dbfunctions$fns$state_machine__2717__auto__);

(statearr_55892[(1)] = (1));

return statearr_55892;
});
var fluree$db$dbfunctions$fns$state_machine__2717__auto____1 = (function (state_55880){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_55880);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e55893){var ex__2720__auto__ = e55893;
var statearr_55894_55905 = state_55880;
(statearr_55894_55905[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_55880[(4)]))){
var statearr_55895_55906 = state_55880;
(statearr_55895_55906[(1)] = cljs.core.first((state_55880[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55907 = state_55880;
state_55880 = G__55907;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2717__auto__ = function(state_55880){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____1.call(this,state_55880);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_55896 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_55896[(6)] = c__2739__auto__);

return statearr_55896;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq55848){
var G__55849 = cljs.core.first(seq55848);
var seq55848__$1 = cljs.core.next(seq55848);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55849,seq55848__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___55957 = arguments.length;
var i__4819__auto___55958 = (0);
while(true){
if((i__4819__auto___55958 < len__4818__auto___55957)){
args__4824__auto__.push((arguments[i__4819__auto___55958]));

var G__55959 = (i__4819__auto___55958 + (1));
i__4819__auto___55958 = G__55959;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_55940){
var state_val_55941 = (state_55940[(1)]);
if((state_val_55941 === (1))){
var state_55940__$1 = state_55940;
var statearr_55942_55960 = state_55940__$1;
(statearr_55942_55960[(2)] = null);

(statearr_55942_55960[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55941 === (2))){
var _ = (function (){var statearr_55943 = state_55940;
(statearr_55943[(4)] = cljs.core.cons((5),(state_55940[(4)])));

return statearr_55943;
})();
var inst_55916 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55940__$1 = state_55940;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55940__$1,(6),inst_55916);
} else {
if((state_val_55941 === (3))){
var inst_55938 = (state_55940[(2)]);
var state_55940__$1 = state_55940;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55940__$1,inst_55938);
} else {
if((state_val_55941 === (4))){
var inst_55910 = (state_55940[(2)]);
var state_55940__$1 = state_55940;
var statearr_55945_55961 = state_55940__$1;
(statearr_55945_55961[(2)] = inst_55910);

(statearr_55945_55961[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55941 === (5))){
var _ = (function (){var statearr_55946 = state_55940;
(statearr_55946[(4)] = cljs.core.rest((state_55940[(4)])));

return statearr_55946;
})();
var state_55940__$1 = state_55940;
var ex55944 = (state_55940__$1[(2)]);
var statearr_55947_55962 = state_55940__$1;
(statearr_55947_55962[(5)] = ex55944);


if((ex55944 instanceof Error)){
var statearr_55948_55963 = state_55940__$1;
(statearr_55948_55963[(1)] = (4));

(statearr_55948_55963[(5)] = null);

} else {
throw ex55944;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55941 === (6))){
var inst_55918 = (state_55940[(2)]);
var inst_55919 = fluree.db.util.async.throw_err(inst_55918);
var inst_55920 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_55919);
var inst_55921 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55922 = [inst_55919];
var inst_55923 = (new cljs.core.PersistentVector(null,1,(5),inst_55921,inst_55922,null));
var inst_55924 = cljs.core.count(inst_55923);
var inst_55925 = ((9) + inst_55924);
var inst_55926 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55927 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55928 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55929 = [inst_55919];
var inst_55930 = (new cljs.core.PersistentVector(null,1,(5),inst_55928,inst_55929,null));
var inst_55931 = ["/",inst_55930,inst_55920];
var inst_55932 = cljs.core.PersistentHashMap.fromArrays(inst_55927,inst_55931);
var inst_55933 = [inst_55932,inst_55925];
var inst_55934 = (new cljs.core.PersistentVector(null,2,(5),inst_55926,inst_55933,null));
var inst_55935 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55934);
var _ = (function (){var statearr_55949 = state_55940;
(statearr_55949[(4)] = cljs.core.rest((state_55940[(4)])));

return statearr_55949;
})();
var state_55940__$1 = (function (){var statearr_55950 = state_55940;
(statearr_55950[(7)] = inst_55935);

return statearr_55950;
})();
var statearr_55951_55964 = state_55940__$1;
(statearr_55951_55964[(2)] = inst_55920);

(statearr_55951_55964[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2717__auto____0 = (function (){
var statearr_55952 = [null,null,null,null,null,null,null,null];
(statearr_55952[(0)] = fluree$db$dbfunctions$fns$state_machine__2717__auto__);

(statearr_55952[(1)] = (1));

return statearr_55952;
});
var fluree$db$dbfunctions$fns$state_machine__2717__auto____1 = (function (state_55940){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_55940);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e55953){var ex__2720__auto__ = e55953;
var statearr_55954_55965 = state_55940;
(statearr_55954_55965[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_55940[(4)]))){
var statearr_55955_55966 = state_55940;
(statearr_55955_55966[(1)] = cljs.core.first((state_55940[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55967 = state_55940;
state_55940 = G__55967;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2717__auto__ = function(state_55940){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____1.call(this,state_55940);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_55956 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_55956[(6)] = c__2739__auto__);

return statearr_55956;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq55908){
var G__55909 = cljs.core.first(seq55908);
var seq55908__$1 = cljs.core.next(seq55908);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55909,seq55908__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_56005){
var state_val_56006 = (state_56005[(1)]);
if((state_val_56006 === (7))){
var state_56005__$1 = state_56005;
var statearr_56007_56031 = state_56005__$1;
(statearr_56007_56031[(2)] = n);

(statearr_56007_56031[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56006 === (1))){
var state_56005__$1 = state_56005;
var statearr_56008_56032 = state_56005__$1;
(statearr_56008_56032[(2)] = null);

(statearr_56008_56032[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56006 === (4))){
var inst_55968 = (state_56005[(2)]);
var state_56005__$1 = state_56005;
var statearr_56009_56033 = state_56005__$1;
(statearr_56009_56033[(2)] = inst_55968);

(statearr_56009_56033[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56006 === (13))){
var inst_55985 = (state_56005[(2)]);
var inst_55986 = fluree.db.util.async.throw_err(inst_55985);
var state_56005__$1 = state_56005;
var statearr_56010_56034 = state_56005__$1;
(statearr_56010_56034[(2)] = inst_55986);

(statearr_56010_56034[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56006 === (6))){
var state_56005__$1 = state_56005;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56005__$1,(9),n);
} else {
if((state_val_56006 === (3))){
var inst_56003 = (state_56005[(2)]);
var state_56005__$1 = state_56005;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56005__$1,inst_56003);
} else {
if((state_val_56006 === (12))){
var inst_55981 = (state_56005[(7)]);
var inst_55989 = (state_56005[(2)]);
var inst_55990 = fluree.db.dbfunctions.internal.quot(inst_55981,inst_55989);
var inst_55991 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55992 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55993 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55994 = [inst_55981,inst_55989];
var inst_55995 = (new cljs.core.PersistentVector(null,2,(5),inst_55993,inst_55994,null));
var inst_55996 = ["quot",inst_55995,inst_55990];
var inst_55997 = cljs.core.PersistentHashMap.fromArrays(inst_55992,inst_55996);
var inst_55998 = [inst_55997,(2)];
var inst_55999 = (new cljs.core.PersistentVector(null,2,(5),inst_55991,inst_55998,null));
var inst_56000 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55999);
var _ = (function (){var statearr_56011 = state_56005;
(statearr_56011[(4)] = cljs.core.rest((state_56005[(4)])));

return statearr_56011;
})();
var state_56005__$1 = (function (){var statearr_56012 = state_56005;
(statearr_56012[(8)] = inst_56000);

return statearr_56012;
})();
var statearr_56013_56035 = state_56005__$1;
(statearr_56013_56035[(2)] = inst_55990);

(statearr_56013_56035[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56006 === (2))){
var _ = (function (){var statearr_56014 = state_56005;
(statearr_56014[(4)] = cljs.core.cons((5),(state_56005[(4)])));

return statearr_56014;
})();
var inst_55974 = fluree.db.util.async.channel_QMARK_(n);
var state_56005__$1 = state_56005;
if(inst_55974){
var statearr_56015_56036 = state_56005__$1;
(statearr_56015_56036[(1)] = (6));

} else {
var statearr_56016_56037 = state_56005__$1;
(statearr_56016_56037[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56006 === (11))){
var state_56005__$1 = state_56005;
var statearr_56018_56038 = state_56005__$1;
(statearr_56018_56038[(2)] = d);

(statearr_56018_56038[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56006 === (9))){
var inst_55977 = (state_56005[(2)]);
var inst_55978 = fluree.db.util.async.throw_err(inst_55977);
var state_56005__$1 = state_56005;
var statearr_56019_56039 = state_56005__$1;
(statearr_56019_56039[(2)] = inst_55978);

(statearr_56019_56039[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56006 === (5))){
var _ = (function (){var statearr_56020 = state_56005;
(statearr_56020[(4)] = cljs.core.rest((state_56005[(4)])));

return statearr_56020;
})();
var state_56005__$1 = state_56005;
var ex56017 = (state_56005__$1[(2)]);
var statearr_56021_56040 = state_56005__$1;
(statearr_56021_56040[(5)] = ex56017);


if((ex56017 instanceof Error)){
var statearr_56022_56041 = state_56005__$1;
(statearr_56022_56041[(1)] = (4));

(statearr_56022_56041[(5)] = null);

} else {
throw ex56017;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56006 === (10))){
var state_56005__$1 = state_56005;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56005__$1,(13),d);
} else {
if((state_val_56006 === (8))){
var inst_55981 = (state_56005[(2)]);
var inst_55982 = fluree.db.util.async.channel_QMARK_(d);
var state_56005__$1 = (function (){var statearr_56023 = state_56005;
(statearr_56023[(7)] = inst_55981);

return statearr_56023;
})();
if(inst_55982){
var statearr_56024_56042 = state_56005__$1;
(statearr_56024_56042[(1)] = (10));

} else {
var statearr_56025_56043 = state_56005__$1;
(statearr_56025_56043[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__2717__auto____0 = (function (){
var statearr_56026 = [null,null,null,null,null,null,null,null,null];
(statearr_56026[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__2717__auto__);

(statearr_56026[(1)] = (1));

return statearr_56026;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__2717__auto____1 = (function (state_56005){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_56005);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e56027){var ex__2720__auto__ = e56027;
var statearr_56028_56044 = state_56005;
(statearr_56028_56044[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_56005[(4)]))){
var statearr_56029_56045 = state_56005;
(statearr_56029_56045[(1)] = cljs.core.first((state_56005[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56046 = state_56005;
state_56005 = G__56046;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__2717__auto__ = function(state_56005){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2717__auto____1.call(this,state_56005);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_56030 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_56030[(6)] = c__2739__auto__);

return statearr_56030;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_56084){
var state_val_56085 = (state_56084[(1)]);
if((state_val_56085 === (7))){
var state_56084__$1 = state_56084;
var statearr_56086_56110 = state_56084__$1;
(statearr_56086_56110[(2)] = n);

(statearr_56086_56110[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56085 === (1))){
var state_56084__$1 = state_56084;
var statearr_56087_56111 = state_56084__$1;
(statearr_56087_56111[(2)] = null);

(statearr_56087_56111[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56085 === (4))){
var inst_56047 = (state_56084[(2)]);
var state_56084__$1 = state_56084;
var statearr_56088_56112 = state_56084__$1;
(statearr_56088_56112[(2)] = inst_56047);

(statearr_56088_56112[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56085 === (13))){
var inst_56064 = (state_56084[(2)]);
var inst_56065 = fluree.db.util.async.throw_err(inst_56064);
var state_56084__$1 = state_56084;
var statearr_56089_56113 = state_56084__$1;
(statearr_56089_56113[(2)] = inst_56065);

(statearr_56089_56113[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56085 === (6))){
var state_56084__$1 = state_56084;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56084__$1,(9),n);
} else {
if((state_val_56085 === (3))){
var inst_56082 = (state_56084[(2)]);
var state_56084__$1 = state_56084;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56084__$1,inst_56082);
} else {
if((state_val_56085 === (12))){
var inst_56060 = (state_56084[(7)]);
var inst_56068 = (state_56084[(2)]);
var inst_56069 = fluree.db.dbfunctions.internal.mod(inst_56060,inst_56068);
var inst_56070 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56071 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56072 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56073 = [inst_56060,inst_56068];
var inst_56074 = (new cljs.core.PersistentVector(null,2,(5),inst_56072,inst_56073,null));
var inst_56075 = ["mod",inst_56074,inst_56069];
var inst_56076 = cljs.core.PersistentHashMap.fromArrays(inst_56071,inst_56075);
var inst_56077 = [inst_56076,(2)];
var inst_56078 = (new cljs.core.PersistentVector(null,2,(5),inst_56070,inst_56077,null));
var inst_56079 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56078);
var _ = (function (){var statearr_56090 = state_56084;
(statearr_56090[(4)] = cljs.core.rest((state_56084[(4)])));

return statearr_56090;
})();
var state_56084__$1 = (function (){var statearr_56091 = state_56084;
(statearr_56091[(8)] = inst_56079);

return statearr_56091;
})();
var statearr_56092_56114 = state_56084__$1;
(statearr_56092_56114[(2)] = inst_56069);

(statearr_56092_56114[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56085 === (2))){
var _ = (function (){var statearr_56093 = state_56084;
(statearr_56093[(4)] = cljs.core.cons((5),(state_56084[(4)])));

return statearr_56093;
})();
var inst_56053 = fluree.db.util.async.channel_QMARK_(n);
var state_56084__$1 = state_56084;
if(inst_56053){
var statearr_56094_56115 = state_56084__$1;
(statearr_56094_56115[(1)] = (6));

} else {
var statearr_56095_56116 = state_56084__$1;
(statearr_56095_56116[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56085 === (11))){
var state_56084__$1 = state_56084;
var statearr_56097_56117 = state_56084__$1;
(statearr_56097_56117[(2)] = d);

(statearr_56097_56117[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56085 === (9))){
var inst_56056 = (state_56084[(2)]);
var inst_56057 = fluree.db.util.async.throw_err(inst_56056);
var state_56084__$1 = state_56084;
var statearr_56098_56118 = state_56084__$1;
(statearr_56098_56118[(2)] = inst_56057);

(statearr_56098_56118[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56085 === (5))){
var _ = (function (){var statearr_56099 = state_56084;
(statearr_56099[(4)] = cljs.core.rest((state_56084[(4)])));

return statearr_56099;
})();
var state_56084__$1 = state_56084;
var ex56096 = (state_56084__$1[(2)]);
var statearr_56100_56119 = state_56084__$1;
(statearr_56100_56119[(5)] = ex56096);


if((ex56096 instanceof Error)){
var statearr_56101_56120 = state_56084__$1;
(statearr_56101_56120[(1)] = (4));

(statearr_56101_56120[(5)] = null);

} else {
throw ex56096;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56085 === (10))){
var state_56084__$1 = state_56084;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56084__$1,(13),d);
} else {
if((state_val_56085 === (8))){
var inst_56060 = (state_56084[(2)]);
var inst_56061 = fluree.db.util.async.channel_QMARK_(d);
var state_56084__$1 = (function (){var statearr_56102 = state_56084;
(statearr_56102[(7)] = inst_56060);

return statearr_56102;
})();
if(inst_56061){
var statearr_56103_56121 = state_56084__$1;
(statearr_56103_56121[(1)] = (10));

} else {
var statearr_56104_56122 = state_56084__$1;
(statearr_56104_56122[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__2717__auto____0 = (function (){
var statearr_56105 = [null,null,null,null,null,null,null,null,null];
(statearr_56105[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__2717__auto__);

(statearr_56105[(1)] = (1));

return statearr_56105;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__2717__auto____1 = (function (state_56084){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_56084);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e56106){var ex__2720__auto__ = e56106;
var statearr_56107_56123 = state_56084;
(statearr_56107_56123[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_56084[(4)]))){
var statearr_56108_56124 = state_56084;
(statearr_56108_56124[(1)] = cljs.core.first((state_56084[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56125 = state_56084;
state_56084 = G__56125;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__2717__auto__ = function(state_56084){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2717__auto____1.call(this,state_56084);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_56109 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_56109[(6)] = c__2739__auto__);

return statearr_56109;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_56163){
var state_val_56164 = (state_56163[(1)]);
if((state_val_56164 === (7))){
var state_56163__$1 = state_56163;
var statearr_56165_56189 = state_56163__$1;
(statearr_56165_56189[(2)] = n);

(statearr_56165_56189[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56164 === (1))){
var state_56163__$1 = state_56163;
var statearr_56166_56190 = state_56163__$1;
(statearr_56166_56190[(2)] = null);

(statearr_56166_56190[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56164 === (4))){
var inst_56126 = (state_56163[(2)]);
var state_56163__$1 = state_56163;
var statearr_56167_56191 = state_56163__$1;
(statearr_56167_56191[(2)] = inst_56126);

(statearr_56167_56191[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56164 === (13))){
var inst_56143 = (state_56163[(2)]);
var inst_56144 = fluree.db.util.async.throw_err(inst_56143);
var state_56163__$1 = state_56163;
var statearr_56168_56192 = state_56163__$1;
(statearr_56168_56192[(2)] = inst_56144);

(statearr_56168_56192[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56164 === (6))){
var state_56163__$1 = state_56163;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56163__$1,(9),n);
} else {
if((state_val_56164 === (3))){
var inst_56161 = (state_56163[(2)]);
var state_56163__$1 = state_56163;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56163__$1,inst_56161);
} else {
if((state_val_56164 === (12))){
var inst_56139 = (state_56163[(7)]);
var inst_56147 = (state_56163[(2)]);
var inst_56148 = fluree.db.dbfunctions.internal.rem(inst_56139,inst_56147);
var inst_56149 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56150 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56151 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56152 = [inst_56139,inst_56147];
var inst_56153 = (new cljs.core.PersistentVector(null,2,(5),inst_56151,inst_56152,null));
var inst_56154 = ["rem",inst_56153,inst_56148];
var inst_56155 = cljs.core.PersistentHashMap.fromArrays(inst_56150,inst_56154);
var inst_56156 = [inst_56155,(2)];
var inst_56157 = (new cljs.core.PersistentVector(null,2,(5),inst_56149,inst_56156,null));
var inst_56158 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56157);
var _ = (function (){var statearr_56169 = state_56163;
(statearr_56169[(4)] = cljs.core.rest((state_56163[(4)])));

return statearr_56169;
})();
var state_56163__$1 = (function (){var statearr_56170 = state_56163;
(statearr_56170[(8)] = inst_56158);

return statearr_56170;
})();
var statearr_56171_56193 = state_56163__$1;
(statearr_56171_56193[(2)] = inst_56148);

(statearr_56171_56193[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56164 === (2))){
var _ = (function (){var statearr_56172 = state_56163;
(statearr_56172[(4)] = cljs.core.cons((5),(state_56163[(4)])));

return statearr_56172;
})();
var inst_56132 = fluree.db.util.async.channel_QMARK_(n);
var state_56163__$1 = state_56163;
if(inst_56132){
var statearr_56173_56194 = state_56163__$1;
(statearr_56173_56194[(1)] = (6));

} else {
var statearr_56174_56195 = state_56163__$1;
(statearr_56174_56195[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56164 === (11))){
var state_56163__$1 = state_56163;
var statearr_56176_56196 = state_56163__$1;
(statearr_56176_56196[(2)] = d);

(statearr_56176_56196[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56164 === (9))){
var inst_56135 = (state_56163[(2)]);
var inst_56136 = fluree.db.util.async.throw_err(inst_56135);
var state_56163__$1 = state_56163;
var statearr_56177_56197 = state_56163__$1;
(statearr_56177_56197[(2)] = inst_56136);

(statearr_56177_56197[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56164 === (5))){
var _ = (function (){var statearr_56178 = state_56163;
(statearr_56178[(4)] = cljs.core.rest((state_56163[(4)])));

return statearr_56178;
})();
var state_56163__$1 = state_56163;
var ex56175 = (state_56163__$1[(2)]);
var statearr_56179_56198 = state_56163__$1;
(statearr_56179_56198[(5)] = ex56175);


if((ex56175 instanceof Error)){
var statearr_56180_56199 = state_56163__$1;
(statearr_56180_56199[(1)] = (4));

(statearr_56180_56199[(5)] = null);

} else {
throw ex56175;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56164 === (10))){
var state_56163__$1 = state_56163;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56163__$1,(13),d);
} else {
if((state_val_56164 === (8))){
var inst_56139 = (state_56163[(2)]);
var inst_56140 = fluree.db.util.async.channel_QMARK_(d);
var state_56163__$1 = (function (){var statearr_56181 = state_56163;
(statearr_56181[(7)] = inst_56139);

return statearr_56181;
})();
if(inst_56140){
var statearr_56182_56200 = state_56163__$1;
(statearr_56182_56200[(1)] = (10));

} else {
var statearr_56183_56201 = state_56163__$1;
(statearr_56183_56201[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__2717__auto____0 = (function (){
var statearr_56184 = [null,null,null,null,null,null,null,null,null];
(statearr_56184[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__2717__auto__);

(statearr_56184[(1)] = (1));

return statearr_56184;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__2717__auto____1 = (function (state_56163){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_56163);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e56185){var ex__2720__auto__ = e56185;
var statearr_56186_56202 = state_56163;
(statearr_56186_56202[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_56163[(4)]))){
var statearr_56187_56203 = state_56163;
(statearr_56187_56203[(1)] = cljs.core.first((state_56163[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56204 = state_56163;
state_56163 = G__56204;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__2717__auto__ = function(state_56163){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2717__auto____1.call(this,state_56163);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_56188 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_56188[(6)] = c__2739__auto__);

return statearr_56188;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_56231){
var state_val_56232 = (state_56231[(1)]);
if((state_val_56232 === (7))){
var state_56231__$1 = state_56231;
var statearr_56233_56252 = state_56231__$1;
(statearr_56233_56252[(2)] = x);

(statearr_56233_56252[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56232 === (1))){
var state_56231__$1 = state_56231;
var statearr_56234_56253 = state_56231__$1;
(statearr_56234_56253[(2)] = null);

(statearr_56234_56253[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56232 === (4))){
var inst_56205 = (state_56231[(2)]);
var state_56231__$1 = state_56231;
var statearr_56235_56254 = state_56231__$1;
(statearr_56235_56254[(2)] = inst_56205);

(statearr_56235_56254[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56232 === (6))){
var state_56231__$1 = state_56231;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56231__$1,(9),x);
} else {
if((state_val_56232 === (3))){
var inst_56229 = (state_56231[(2)]);
var state_56231__$1 = state_56231;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56231__$1,inst_56229);
} else {
if((state_val_56232 === (2))){
var _ = (function (){var statearr_56237 = state_56231;
(statearr_56237[(4)] = cljs.core.cons((5),(state_56231[(4)])));

return statearr_56237;
})();
var inst_56211 = fluree.db.util.async.channel_QMARK_(x);
var state_56231__$1 = state_56231;
if(inst_56211){
var statearr_56238_56255 = state_56231__$1;
(statearr_56238_56255[(1)] = (6));

} else {
var statearr_56239_56256 = state_56231__$1;
(statearr_56239_56256[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56232 === (9))){
var inst_56214 = (state_56231[(2)]);
var inst_56215 = fluree.db.util.async.throw_err(inst_56214);
var state_56231__$1 = state_56231;
var statearr_56240_56257 = state_56231__$1;
(statearr_56240_56257[(2)] = inst_56215);

(statearr_56240_56257[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56232 === (5))){
var _ = (function (){var statearr_56241 = state_56231;
(statearr_56241[(4)] = cljs.core.rest((state_56231[(4)])));

return statearr_56241;
})();
var state_56231__$1 = state_56231;
var ex56236 = (state_56231__$1[(2)]);
var statearr_56242_56258 = state_56231__$1;
(statearr_56242_56258[(5)] = ex56236);


if((ex56236 instanceof Error)){
var statearr_56243_56259 = state_56231__$1;
(statearr_56243_56259[(1)] = (4));

(statearr_56243_56259[(5)] = null);

} else {
throw ex56236;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56232 === (8))){
var inst_56218 = (state_56231[(2)]);
var inst_56219 = fluree.db.dbfunctions.internal.boolean$(inst_56218);
var inst_56220 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56221 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56222 = ["boolean",inst_56218,inst_56219];
var inst_56223 = cljs.core.PersistentHashMap.fromArrays(inst_56221,inst_56222);
var inst_56224 = [inst_56223,(10)];
var inst_56225 = (new cljs.core.PersistentVector(null,2,(5),inst_56220,inst_56224,null));
var inst_56226 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56225);
var _ = (function (){var statearr_56244 = state_56231;
(statearr_56244[(4)] = cljs.core.rest((state_56231[(4)])));

return statearr_56244;
})();
var state_56231__$1 = (function (){var statearr_56245 = state_56231;
(statearr_56245[(7)] = inst_56226);

return statearr_56245;
})();
var statearr_56246_56260 = state_56231__$1;
(statearr_56246_56260[(2)] = inst_56219);

(statearr_56246_56260[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2717__auto____0 = (function (){
var statearr_56247 = [null,null,null,null,null,null,null,null];
(statearr_56247[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__2717__auto__);

(statearr_56247[(1)] = (1));

return statearr_56247;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2717__auto____1 = (function (state_56231){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_56231);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e56248){var ex__2720__auto__ = e56248;
var statearr_56249_56261 = state_56231;
(statearr_56249_56261[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_56231[(4)]))){
var statearr_56250_56262 = state_56231;
(statearr_56250_56262[(1)] = cljs.core.first((state_56231[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56263 = state_56231;
state_56231 = G__56263;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__2717__auto__ = function(state_56231){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2717__auto____1.call(this,state_56231);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_56251 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_56251[(6)] = c__2739__auto__);

return statearr_56251;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_56301){
var state_val_56302 = (state_56301[(1)]);
if((state_val_56302 === (7))){
var state_56301__$1 = state_56301;
var statearr_56303_56327 = state_56301__$1;
(statearr_56303_56327[(2)] = pattern);

(statearr_56303_56327[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56302 === (1))){
var state_56301__$1 = state_56301;
var statearr_56304_56328 = state_56301__$1;
(statearr_56304_56328[(2)] = null);

(statearr_56304_56328[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56302 === (4))){
var inst_56264 = (state_56301[(2)]);
var state_56301__$1 = state_56301;
var statearr_56305_56329 = state_56301__$1;
(statearr_56305_56329[(2)] = inst_56264);

(statearr_56305_56329[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56302 === (13))){
var inst_56281 = (state_56301[(2)]);
var inst_56282 = fluree.db.util.async.throw_err(inst_56281);
var state_56301__$1 = state_56301;
var statearr_56306_56330 = state_56301__$1;
(statearr_56306_56330[(2)] = inst_56282);

(statearr_56306_56330[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56302 === (6))){
var state_56301__$1 = state_56301;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56301__$1,(9),pattern);
} else {
if((state_val_56302 === (3))){
var inst_56299 = (state_56301[(2)]);
var state_56301__$1 = state_56301;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56301__$1,inst_56299);
} else {
if((state_val_56302 === (12))){
var inst_56277 = (state_56301[(7)]);
var inst_56285 = (state_56301[(2)]);
var inst_56286 = fluree.db.dbfunctions.internal.re_find(inst_56277,inst_56285);
var inst_56287 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56288 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56289 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56290 = [inst_56277,inst_56285];
var inst_56291 = (new cljs.core.PersistentVector(null,2,(5),inst_56289,inst_56290,null));
var inst_56292 = ["re-find",inst_56291,inst_56286];
var inst_56293 = cljs.core.PersistentHashMap.fromArrays(inst_56288,inst_56292);
var inst_56294 = [inst_56293,(10)];
var inst_56295 = (new cljs.core.PersistentVector(null,2,(5),inst_56287,inst_56294,null));
var inst_56296 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56295);
var _ = (function (){var statearr_56307 = state_56301;
(statearr_56307[(4)] = cljs.core.rest((state_56301[(4)])));

return statearr_56307;
})();
var state_56301__$1 = (function (){var statearr_56308 = state_56301;
(statearr_56308[(8)] = inst_56296);

return statearr_56308;
})();
var statearr_56309_56331 = state_56301__$1;
(statearr_56309_56331[(2)] = inst_56286);

(statearr_56309_56331[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56302 === (2))){
var _ = (function (){var statearr_56310 = state_56301;
(statearr_56310[(4)] = cljs.core.cons((5),(state_56301[(4)])));

return statearr_56310;
})();
var inst_56270 = fluree.db.util.async.channel_QMARK_(pattern);
var state_56301__$1 = state_56301;
if(inst_56270){
var statearr_56311_56332 = state_56301__$1;
(statearr_56311_56332[(1)] = (6));

} else {
var statearr_56312_56333 = state_56301__$1;
(statearr_56312_56333[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56302 === (11))){
var state_56301__$1 = state_56301;
var statearr_56314_56334 = state_56301__$1;
(statearr_56314_56334[(2)] = string);

(statearr_56314_56334[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56302 === (9))){
var inst_56273 = (state_56301[(2)]);
var inst_56274 = fluree.db.util.async.throw_err(inst_56273);
var state_56301__$1 = state_56301;
var statearr_56315_56335 = state_56301__$1;
(statearr_56315_56335[(2)] = inst_56274);

(statearr_56315_56335[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56302 === (5))){
var _ = (function (){var statearr_56316 = state_56301;
(statearr_56316[(4)] = cljs.core.rest((state_56301[(4)])));

return statearr_56316;
})();
var state_56301__$1 = state_56301;
var ex56313 = (state_56301__$1[(2)]);
var statearr_56317_56336 = state_56301__$1;
(statearr_56317_56336[(5)] = ex56313);


if((ex56313 instanceof Error)){
var statearr_56318_56337 = state_56301__$1;
(statearr_56318_56337[(1)] = (4));

(statearr_56318_56337[(5)] = null);

} else {
throw ex56313;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56302 === (10))){
var state_56301__$1 = state_56301;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56301__$1,(13),string);
} else {
if((state_val_56302 === (8))){
var inst_56277 = (state_56301[(2)]);
var inst_56278 = fluree.db.util.async.channel_QMARK_(string);
var state_56301__$1 = (function (){var statearr_56319 = state_56301;
(statearr_56319[(7)] = inst_56277);

return statearr_56319;
})();
if(inst_56278){
var statearr_56320_56338 = state_56301__$1;
(statearr_56320_56338[(1)] = (10));

} else {
var statearr_56321_56339 = state_56301__$1;
(statearr_56321_56339[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2717__auto____0 = (function (){
var statearr_56322 = [null,null,null,null,null,null,null,null,null];
(statearr_56322[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__2717__auto__);

(statearr_56322[(1)] = (1));

return statearr_56322;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2717__auto____1 = (function (state_56301){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_56301);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e56323){var ex__2720__auto__ = e56323;
var statearr_56324_56340 = state_56301;
(statearr_56324_56340[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_56301[(4)]))){
var statearr_56325_56341 = state_56301;
(statearr_56325_56341[(1)] = cljs.core.first((state_56301[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56342 = state_56301;
state_56301 = G__56342;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__2717__auto__ = function(state_56301){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2717__auto____1.call(this,state_56301);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_56326 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_56326[(6)] = c__2739__auto__);

return statearr_56326;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_56369){
var state_val_56370 = (state_56369[(1)]);
if((state_val_56370 === (7))){
var state_56369__$1 = state_56369;
var statearr_56371_56390 = state_56369__$1;
(statearr_56371_56390[(2)] = email);

(statearr_56371_56390[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56370 === (1))){
var state_56369__$1 = state_56369;
var statearr_56372_56391 = state_56369__$1;
(statearr_56372_56391[(2)] = null);

(statearr_56372_56391[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56370 === (4))){
var inst_56343 = (state_56369[(2)]);
var state_56369__$1 = state_56369;
var statearr_56373_56392 = state_56369__$1;
(statearr_56373_56392[(2)] = inst_56343);

(statearr_56373_56392[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56370 === (6))){
var state_56369__$1 = state_56369;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56369__$1,(9),email);
} else {
if((state_val_56370 === (3))){
var inst_56367 = (state_56369[(2)]);
var state_56369__$1 = state_56369;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56369__$1,inst_56367);
} else {
if((state_val_56370 === (2))){
var _ = (function (){var statearr_56375 = state_56369;
(statearr_56375[(4)] = cljs.core.cons((5),(state_56369[(4)])));

return statearr_56375;
})();
var inst_56349 = fluree.db.util.async.channel_QMARK_(email);
var state_56369__$1 = state_56369;
if(inst_56349){
var statearr_56376_56393 = state_56369__$1;
(statearr_56376_56393[(1)] = (6));

} else {
var statearr_56377_56394 = state_56369__$1;
(statearr_56377_56394[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56370 === (9))){
var inst_56352 = (state_56369[(2)]);
var inst_56353 = fluree.db.util.async.throw_err(inst_56352);
var state_56369__$1 = state_56369;
var statearr_56378_56395 = state_56369__$1;
(statearr_56378_56395[(2)] = inst_56353);

(statearr_56378_56395[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56370 === (5))){
var _ = (function (){var statearr_56379 = state_56369;
(statearr_56379[(4)] = cljs.core.rest((state_56369[(4)])));

return statearr_56379;
})();
var state_56369__$1 = state_56369;
var ex56374 = (state_56369__$1[(2)]);
var statearr_56380_56396 = state_56369__$1;
(statearr_56380_56396[(5)] = ex56374);


if((ex56374 instanceof Error)){
var statearr_56381_56397 = state_56369__$1;
(statearr_56381_56397[(1)] = (4));

(statearr_56381_56397[(5)] = null);

} else {
throw ex56374;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56370 === (8))){
var inst_56356 = (state_56369[(2)]);
var inst_56357 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_56356);
var inst_56358 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56359 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56360 = ["re-find",inst_56356,inst_56357];
var inst_56361 = cljs.core.PersistentHashMap.fromArrays(inst_56359,inst_56360);
var inst_56362 = [inst_56361,(10)];
var inst_56363 = (new cljs.core.PersistentVector(null,2,(5),inst_56358,inst_56362,null));
var inst_56364 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56363);
var _ = (function (){var statearr_56382 = state_56369;
(statearr_56382[(4)] = cljs.core.rest((state_56369[(4)])));

return statearr_56382;
})();
var state_56369__$1 = (function (){var statearr_56383 = state_56369;
(statearr_56383[(7)] = inst_56364);

return statearr_56383;
})();
var statearr_56384_56398 = state_56369__$1;
(statearr_56384_56398[(2)] = inst_56357);

(statearr_56384_56398[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2717__auto____0 = (function (){
var statearr_56385 = [null,null,null,null,null,null,null,null];
(statearr_56385[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2717__auto__);

(statearr_56385[(1)] = (1));

return statearr_56385;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2717__auto____1 = (function (state_56369){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_56369);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e56386){var ex__2720__auto__ = e56386;
var statearr_56387_56399 = state_56369;
(statearr_56387_56399[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_56369[(4)]))){
var statearr_56388_56400 = state_56369;
(statearr_56388_56400[(1)] = cljs.core.first((state_56369[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56401 = state_56369;
state_56369 = G__56401;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2717__auto__ = function(state_56369){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2717__auto____1.call(this,state_56369);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_56389 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_56389[(6)] = c__2739__auto__);

return statearr_56389;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_56448){
var state_val_56449 = (state_56448[(1)]);
if((state_val_56449 === (7))){
var inst_56418 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56448__$1 = state_56448;
if(cljs.core.truth_(inst_56418)){
var statearr_56450_56477 = state_56448__$1;
(statearr_56450_56477[(1)] = (9));

} else {
var statearr_56451_56478 = state_56448__$1;
(statearr_56451_56478[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56449 === (1))){
var state_56448__$1 = state_56448;
var statearr_56452_56479 = state_56448__$1;
(statearr_56452_56479[(2)] = null);

(statearr_56452_56479[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56449 === (4))){
var inst_56402 = (state_56448[(2)]);
var state_56448__$1 = state_56448;
var statearr_56453_56480 = state_56448__$1;
(statearr_56453_56480[(2)] = inst_56402);

(statearr_56453_56480[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56449 === (15))){
var inst_56429 = (state_56448[(2)]);
var state_56448__$1 = state_56448;
var statearr_56454_56481 = state_56448__$1;
(statearr_56454_56481[(2)] = inst_56429);

(statearr_56454_56481[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56449 === (13))){
var inst_56426 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_56448__$1 = state_56448;
var statearr_56455_56482 = state_56448__$1;
(statearr_56455_56482[(2)] = inst_56426);

(statearr_56455_56482[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56449 === (6))){
var inst_56413 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56414 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56415 = [inst_56414,(0)];
var inst_56416 = (new cljs.core.PersistentVector(null,2,(5),inst_56413,inst_56415,null));
var state_56448__$1 = state_56448;
var statearr_56456_56483 = state_56448__$1;
(statearr_56456_56483[(2)] = inst_56416);

(statearr_56456_56483[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56449 === (3))){
var inst_56446 = (state_56448[(2)]);
var state_56448__$1 = state_56448;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56448__$1,inst_56446);
} else {
if((state_val_56449 === (12))){
var inst_56422 = (state_56448[(2)]);
var inst_56423 = fluree.db.util.async.throw_err(inst_56422);
var state_56448__$1 = state_56448;
var statearr_56457_56484 = state_56448__$1;
(statearr_56457_56484[(2)] = inst_56423);

(statearr_56457_56484[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56449 === (2))){
var _ = (function (){var statearr_56458 = state_56448;
(statearr_56458[(4)] = cljs.core.cons((5),(state_56448[(4)])));

return statearr_56458;
})();
var inst_56411 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56448__$1 = state_56448;
if(cljs.core.truth_(inst_56411)){
var statearr_56459_56485 = state_56448__$1;
(statearr_56459_56485[(1)] = (6));

} else {
var statearr_56460_56486 = state_56448__$1;
(statearr_56460_56486[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56449 === (11))){
var inst_56431 = (state_56448[(2)]);
var state_56448__$1 = state_56448;
var statearr_56462_56487 = state_56448__$1;
(statearr_56462_56487[(2)] = inst_56431);

(statearr_56462_56487[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56449 === (9))){
var inst_56420 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_56448__$1 = state_56448;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56448__$1,(12),inst_56420);
} else {
if((state_val_56449 === (5))){
var _ = (function (){var statearr_56463 = state_56448;
(statearr_56463[(4)] = cljs.core.rest((state_56448[(4)])));

return statearr_56463;
})();
var state_56448__$1 = state_56448;
var ex56461 = (state_56448__$1[(2)]);
var statearr_56464_56488 = state_56448__$1;
(statearr_56464_56488[(5)] = ex56461);


if((ex56461 instanceof Error)){
var statearr_56465_56489 = state_56448__$1;
(statearr_56465_56489[(1)] = (4));

(statearr_56465_56489[(5)] = null);

} else {
throw ex56461;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56449 === (14))){
var state_56448__$1 = state_56448;
var statearr_56466_56490 = state_56448__$1;
(statearr_56466_56490[(2)] = null);

(statearr_56466_56490[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56449 === (10))){
var state_56448__$1 = state_56448;
var statearr_56467_56491 = state_56448__$1;
(statearr_56467_56491[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56449 === (8))){
var inst_56433 = (state_56448[(2)]);
var inst_56434 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56433,(0),null);
var inst_56435 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56433,(1),null);
var inst_56436 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56437 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56438 = ["?user_id","?ctx",inst_56434];
var inst_56439 = cljs.core.PersistentHashMap.fromArrays(inst_56437,inst_56438);
var inst_56440 = ((10) + inst_56435);
var inst_56441 = [inst_56439,inst_56440];
var inst_56442 = (new cljs.core.PersistentVector(null,2,(5),inst_56436,inst_56441,null));
var inst_56443 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56442);
var _ = (function (){var statearr_56469 = state_56448;
(statearr_56469[(4)] = cljs.core.rest((state_56448[(4)])));

return statearr_56469;
})();
var state_56448__$1 = (function (){var statearr_56470 = state_56448;
(statearr_56470[(7)] = inst_56443);

return statearr_56470;
})();
var statearr_56471_56492 = state_56448__$1;
(statearr_56471_56492[(2)] = inst_56434);

(statearr_56471_56492[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2717__auto____0 = (function (){
var statearr_56472 = [null,null,null,null,null,null,null,null];
(statearr_56472[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2717__auto__);

(statearr_56472[(1)] = (1));

return statearr_56472;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2717__auto____1 = (function (state_56448){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_56448);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e56473){var ex__2720__auto__ = e56473;
var statearr_56474_56493 = state_56448;
(statearr_56474_56493[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_56448[(4)]))){
var statearr_56475_56494 = state_56448;
(statearr_56475_56494[(1)] = cljs.core.first((state_56448[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56495 = state_56448;
state_56448 = G__56495;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2717__auto__ = function(state_56448){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2717__auto____1.call(this,state_56448);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_56476 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_56476[(6)] = c__2739__auto__);

return statearr_56476;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_56523){
var state_val_56524 = (state_56523[(1)]);
if((state_val_56524 === (7))){
var inst_56516 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_56523__$1 = state_56523;
var statearr_56525_56544 = state_56523__$1;
(statearr_56525_56544[(2)] = inst_56516);

(statearr_56525_56544[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56524 === (1))){
var state_56523__$1 = state_56523;
var statearr_56526_56545 = state_56523__$1;
(statearr_56526_56545[(2)] = null);

(statearr_56526_56545[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56524 === (4))){
var inst_56496 = (state_56523[(2)]);
var state_56523__$1 = state_56523;
var statearr_56527_56546 = state_56523__$1;
(statearr_56527_56546[(2)] = inst_56496);

(statearr_56527_56546[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56524 === (6))){
var inst_56504 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_56523__$1 = state_56523;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56523__$1,(9),inst_56504);
} else {
if((state_val_56524 === (3))){
var inst_56521 = (state_56523[(2)]);
var state_56523__$1 = state_56523;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56523__$1,inst_56521);
} else {
if((state_val_56524 === (2))){
var _ = (function (){var statearr_56529 = state_56523;
(statearr_56529[(4)] = cljs.core.cons((5),(state_56523[(4)])));

return statearr_56529;
})();
var inst_56502 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56523__$1 = state_56523;
if(cljs.core.truth_(inst_56502)){
var statearr_56530_56547 = state_56523__$1;
(statearr_56530_56547[(1)] = (6));

} else {
var statearr_56531_56548 = state_56523__$1;
(statearr_56531_56548[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56524 === (9))){
var inst_56506 = (state_56523[(2)]);
var inst_56507 = fluree.db.util.async.throw_err(inst_56506);
var inst_56508 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56509 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56510 = ["?auth_id","?ctx",inst_56507];
var inst_56511 = cljs.core.PersistentHashMap.fromArrays(inst_56509,inst_56510);
var inst_56512 = [inst_56511,(10)];
var inst_56513 = (new cljs.core.PersistentVector(null,2,(5),inst_56508,inst_56512,null));
var inst_56514 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56513);
var state_56523__$1 = (function (){var statearr_56532 = state_56523;
(statearr_56532[(7)] = inst_56514);

return statearr_56532;
})();
var statearr_56533_56549 = state_56523__$1;
(statearr_56533_56549[(2)] = inst_56507);

(statearr_56533_56549[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56524 === (5))){
var _ = (function (){var statearr_56534 = state_56523;
(statearr_56534[(4)] = cljs.core.rest((state_56523[(4)])));

return statearr_56534;
})();
var state_56523__$1 = state_56523;
var ex56528 = (state_56523__$1[(2)]);
var statearr_56535_56550 = state_56523__$1;
(statearr_56535_56550[(5)] = ex56528);


if((ex56528 instanceof Error)){
var statearr_56536_56551 = state_56523__$1;
(statearr_56536_56551[(1)] = (4));

(statearr_56536_56551[(5)] = null);

} else {
throw ex56528;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56524 === (8))){
var inst_56518 = (state_56523[(2)]);
var _ = (function (){var statearr_56537 = state_56523;
(statearr_56537[(4)] = cljs.core.rest((state_56523[(4)])));

return statearr_56537;
})();
var state_56523__$1 = state_56523;
var statearr_56538_56552 = state_56523__$1;
(statearr_56538_56552[(2)] = inst_56518);

(statearr_56538_56552[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2717__auto____0 = (function (){
var statearr_56539 = [null,null,null,null,null,null,null,null];
(statearr_56539[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2717__auto__);

(statearr_56539[(1)] = (1));

return statearr_56539;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2717__auto____1 = (function (state_56523){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_56523);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e56540){var ex__2720__auto__ = e56540;
var statearr_56541_56553 = state_56523;
(statearr_56541_56553[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_56523[(4)]))){
var statearr_56542_56554 = state_56523;
(statearr_56542_56554[(1)] = cljs.core.first((state_56523[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56555 = state_56523;
state_56523 = G__56555;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2717__auto__ = function(state_56523){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2717__auto____1.call(this,state_56523);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_56543 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_56543[(6)] = c__2739__auto__);

return statearr_56543;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__56557 = arguments.length;
switch (G__56557) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_56599){
var state_val_56600 = (state_56599[(1)]);
if((state_val_56600 === (7))){
var state_56599__$1 = state_56599;
var statearr_56601_56631 = state_56599__$1;
(statearr_56601_56631[(2)] = seed);

(statearr_56601_56631[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56600 === (1))){
var state_56599__$1 = state_56599;
var statearr_56602_56632 = state_56599__$1;
(statearr_56602_56632[(2)] = null);

(statearr_56602_56632[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56600 === (4))){
var inst_56558 = (state_56599[(2)]);
var state_56599__$1 = state_56599;
var statearr_56603_56633 = state_56599__$1;
(statearr_56603_56633[(2)] = inst_56558);

(statearr_56603_56633[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56600 === (15))){
var state_56599__$1 = state_56599;
var statearr_56604_56634 = state_56599__$1;
(statearr_56604_56634[(2)] = (10));

(statearr_56604_56634[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56600 === (13))){
var inst_56575 = (state_56599[(2)]);
var inst_56576 = fluree.db.util.async.throw_err(inst_56575);
var state_56599__$1 = state_56599;
var statearr_56605_56635 = state_56599__$1;
(statearr_56605_56635[(2)] = inst_56576);

(statearr_56605_56635[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56600 === (6))){
var state_56599__$1 = state_56599;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56599__$1,(9),seed);
} else {
if((state_val_56600 === (3))){
var inst_56597 = (state_56599[(2)]);
var state_56599__$1 = state_56599;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56599__$1,inst_56597);
} else {
if((state_val_56600 === (12))){
var inst_56579 = (state_56599[(7)]);
var inst_56579__$1 = (state_56599[(2)]);
var state_56599__$1 = (function (){var statearr_56606 = state_56599;
(statearr_56606[(7)] = inst_56579__$1);

return statearr_56606;
})();
if(cljs.core.truth_(inst_56579__$1)){
var statearr_56607_56636 = state_56599__$1;
(statearr_56607_56636[(1)] = (14));

} else {
var statearr_56608_56637 = state_56599__$1;
(statearr_56608_56637[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56600 === (2))){
var _ = (function (){var statearr_56609 = state_56599;
(statearr_56609[(4)] = cljs.core.cons((5),(state_56599[(4)])));

return statearr_56609;
})();
var inst_56564 = fluree.db.util.async.channel_QMARK_(seed);
var state_56599__$1 = state_56599;
if(inst_56564){
var statearr_56610_56638 = state_56599__$1;
(statearr_56610_56638[(1)] = (6));

} else {
var statearr_56611_56639 = state_56599__$1;
(statearr_56611_56639[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56600 === (11))){
var state_56599__$1 = state_56599;
var statearr_56613_56640 = state_56599__$1;
(statearr_56613_56640[(2)] = max);

(statearr_56613_56640[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56600 === (9))){
var inst_56567 = (state_56599[(2)]);
var inst_56568 = fluree.db.util.async.throw_err(inst_56567);
var state_56599__$1 = state_56599;
var statearr_56614_56641 = state_56599__$1;
(statearr_56614_56641[(2)] = inst_56568);

(statearr_56614_56641[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56600 === (5))){
var _ = (function (){var statearr_56615 = state_56599;
(statearr_56615[(4)] = cljs.core.rest((state_56599[(4)])));

return statearr_56615;
})();
var state_56599__$1 = state_56599;
var ex56612 = (state_56599__$1[(2)]);
var statearr_56616_56642 = state_56599__$1;
(statearr_56616_56642[(5)] = ex56612);


if((ex56612 instanceof Error)){
var statearr_56617_56643 = state_56599__$1;
(statearr_56617_56643[(1)] = (4));

(statearr_56617_56643[(5)] = null);

} else {
throw ex56612;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56600 === (14))){
var inst_56579 = (state_56599[(7)]);
var state_56599__$1 = state_56599;
var statearr_56618_56644 = state_56599__$1;
(statearr_56618_56644[(2)] = inst_56579);

(statearr_56618_56644[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56600 === (16))){
var inst_56571 = (state_56599[(8)]);
var inst_56583 = (state_56599[(2)]);
var inst_56584 = fluree.db.dbfunctions.internal.rand(inst_56571,inst_56583);
var inst_56585 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56586 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56587 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56588 = [max,seed];
var inst_56589 = (new cljs.core.PersistentVector(null,2,(5),inst_56587,inst_56588,null));
var inst_56590 = ["rand",inst_56589,inst_56584];
var inst_56591 = cljs.core.PersistentHashMap.fromArrays(inst_56586,inst_56590);
var inst_56592 = [inst_56591,(10)];
var inst_56593 = (new cljs.core.PersistentVector(null,2,(5),inst_56585,inst_56592,null));
var inst_56594 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56593);
var _ = (function (){var statearr_56619 = state_56599;
(statearr_56619[(4)] = cljs.core.rest((state_56599[(4)])));

return statearr_56619;
})();
var state_56599__$1 = (function (){var statearr_56620 = state_56599;
(statearr_56620[(9)] = inst_56594);

return statearr_56620;
})();
var statearr_56621_56645 = state_56599__$1;
(statearr_56621_56645[(2)] = inst_56584);

(statearr_56621_56645[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56600 === (10))){
var state_56599__$1 = state_56599;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56599__$1,(13),max);
} else {
if((state_val_56600 === (8))){
var inst_56571 = (state_56599[(2)]);
var inst_56572 = fluree.db.util.async.channel_QMARK_(max);
var state_56599__$1 = (function (){var statearr_56622 = state_56599;
(statearr_56622[(8)] = inst_56571);

return statearr_56622;
})();
if(inst_56572){
var statearr_56623_56646 = state_56599__$1;
(statearr_56623_56646[(1)] = (10));

} else {
var statearr_56624_56647 = state_56599__$1;
(statearr_56624_56647[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2717__auto____0 = (function (){
var statearr_56625 = [null,null,null,null,null,null,null,null,null,null];
(statearr_56625[(0)] = fluree$db$dbfunctions$fns$state_machine__2717__auto__);

(statearr_56625[(1)] = (1));

return statearr_56625;
});
var fluree$db$dbfunctions$fns$state_machine__2717__auto____1 = (function (state_56599){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_56599);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e56626){var ex__2720__auto__ = e56626;
var statearr_56627_56648 = state_56599;
(statearr_56627_56648[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_56599[(4)]))){
var statearr_56628_56649 = state_56599;
(statearr_56628_56649[(1)] = cljs.core.first((state_56599[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56650 = state_56599;
state_56599 = G__56650;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2717__auto__ = function(state_56599){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2717__auto____1.call(this,state_56599);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_56629 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_56629[(6)] = c__2739__auto__);

return statearr_56629;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_56671){
var state_val_56672 = (state_56671[(1)]);
if((state_val_56672 === (1))){
var state_56671__$1 = state_56671;
var statearr_56673_56688 = state_56671__$1;
(statearr_56673_56688[(2)] = null);

(statearr_56673_56688[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56672 === (2))){
var _ = (function (){var statearr_56674 = state_56671;
(statearr_56674[(4)] = cljs.core.cons((5),(state_56671[(4)])));

return statearr_56674;
})();
var inst_56657 = fluree.db.util.core.random_uuid();
var inst_56658 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_56657);
var inst_56659 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56660 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56661 = cljs.core.PersistentVector.EMPTY;
var inst_56662 = ["uuid",inst_56661,inst_56658];
var inst_56663 = cljs.core.PersistentHashMap.fromArrays(inst_56660,inst_56662);
var inst_56664 = [inst_56663,(10)];
var inst_56665 = (new cljs.core.PersistentVector(null,2,(5),inst_56659,inst_56664,null));
var inst_56666 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56665);
var ___$1 = (function (){var statearr_56675 = state_56671;
(statearr_56675[(4)] = cljs.core.rest((state_56671[(4)])));

return statearr_56675;
})();
var state_56671__$1 = (function (){var statearr_56676 = state_56671;
(statearr_56676[(7)] = inst_56666);

return statearr_56676;
})();
var statearr_56677_56689 = state_56671__$1;
(statearr_56677_56689[(2)] = inst_56658);

(statearr_56677_56689[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56672 === (3))){
var inst_56669 = (state_56671[(2)]);
var state_56671__$1 = state_56671;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56671__$1,inst_56669);
} else {
if((state_val_56672 === (4))){
var inst_56651 = (state_56671[(2)]);
var state_56671__$1 = state_56671;
var statearr_56679_56690 = state_56671__$1;
(statearr_56679_56690[(2)] = inst_56651);

(statearr_56679_56690[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56672 === (5))){
var _ = (function (){var statearr_56680 = state_56671;
(statearr_56680[(4)] = cljs.core.rest((state_56671[(4)])));

return statearr_56680;
})();
var state_56671__$1 = state_56671;
var ex56678 = (state_56671__$1[(2)]);
var statearr_56681_56691 = state_56671__$1;
(statearr_56681_56691[(5)] = ex56678);


if((ex56678 instanceof Error)){
var statearr_56682_56692 = state_56671__$1;
(statearr_56682_56692[(1)] = (4));

(statearr_56682_56692[(5)] = null);

} else {
throw ex56678;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2717__auto____0 = (function (){
var statearr_56683 = [null,null,null,null,null,null,null,null];
(statearr_56683[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__2717__auto__);

(statearr_56683[(1)] = (1));

return statearr_56683;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2717__auto____1 = (function (state_56671){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_56671);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e56684){var ex__2720__auto__ = e56684;
var statearr_56685_56693 = state_56671;
(statearr_56685_56693[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_56671[(4)]))){
var statearr_56686_56694 = state_56671;
(statearr_56686_56694[(1)] = cljs.core.first((state_56671[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56695 = state_56671;
state_56671 = G__56695;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__2717__auto__ = function(state_56671){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2717__auto____1.call(this,state_56671);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_56687 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_56687[(6)] = c__2739__auto__);

return statearr_56687;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_56725){
var state_val_56726 = (state_56725[(1)]);
if((state_val_56726 === (7))){
var state_56725__$1 = state_56725;
var statearr_56727_56746 = state_56725__$1;
(statearr_56727_56746[(2)] = num);

(statearr_56727_56746[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56726 === (1))){
var state_56725__$1 = state_56725;
var statearr_56728_56747 = state_56725__$1;
(statearr_56728_56747[(2)] = null);

(statearr_56728_56747[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56726 === (4))){
var inst_56696 = (state_56725[(2)]);
var state_56725__$1 = state_56725;
var statearr_56729_56748 = state_56725__$1;
(statearr_56729_56748[(2)] = inst_56696);

(statearr_56729_56748[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56726 === (6))){
var state_56725__$1 = state_56725;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56725__$1,(9),num);
} else {
if((state_val_56726 === (3))){
var inst_56723 = (state_56725[(2)]);
var state_56725__$1 = state_56725;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56725__$1,inst_56723);
} else {
if((state_val_56726 === (2))){
var _ = (function (){var statearr_56731 = state_56725;
(statearr_56731[(4)] = cljs.core.cons((5),(state_56725[(4)])));

return statearr_56731;
})();
var inst_56702 = fluree.db.util.async.channel_QMARK_(num);
var state_56725__$1 = state_56725;
if(inst_56702){
var statearr_56732_56749 = state_56725__$1;
(statearr_56732_56749[(1)] = (6));

} else {
var statearr_56733_56750 = state_56725__$1;
(statearr_56733_56750[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56726 === (9))){
var inst_56705 = (state_56725[(2)]);
var inst_56706 = fluree.db.util.async.throw_err(inst_56705);
var state_56725__$1 = state_56725;
var statearr_56734_56751 = state_56725__$1;
(statearr_56734_56751[(2)] = inst_56706);

(statearr_56734_56751[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56726 === (5))){
var _ = (function (){var statearr_56735 = state_56725;
(statearr_56735[(4)] = cljs.core.rest((state_56725[(4)])));

return statearr_56735;
})();
var state_56725__$1 = state_56725;
var ex56730 = (state_56725__$1[(2)]);
var statearr_56736_56752 = state_56725__$1;
(statearr_56736_56752[(5)] = ex56730);


if((ex56730 instanceof Error)){
var statearr_56737_56753 = state_56725__$1;
(statearr_56737_56753[(1)] = (4));

(statearr_56737_56753[(5)] = null);

} else {
throw ex56730;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56726 === (8))){
var inst_56709 = (state_56725[(2)]);
var inst_56710 = fluree.db.dbfunctions.internal.ceil(inst_56709);
var inst_56711 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56712 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56713 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56714 = [fluree.db.dbfunctions.fns.ceil];
var inst_56715 = (new cljs.core.PersistentVector(null,1,(5),inst_56713,inst_56714,null));
var inst_56716 = ["",inst_56715,inst_56710];
var inst_56717 = cljs.core.PersistentHashMap.fromArrays(inst_56712,inst_56716);
var inst_56718 = [inst_56717,(10)];
var inst_56719 = (new cljs.core.PersistentVector(null,2,(5),inst_56711,inst_56718,null));
var inst_56720 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56719);
var _ = (function (){var statearr_56738 = state_56725;
(statearr_56738[(4)] = cljs.core.rest((state_56725[(4)])));

return statearr_56738;
})();
var state_56725__$1 = (function (){var statearr_56739 = state_56725;
(statearr_56739[(7)] = inst_56720);

return statearr_56739;
})();
var statearr_56740_56754 = state_56725__$1;
(statearr_56740_56754[(2)] = inst_56710);

(statearr_56740_56754[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2717__auto____0 = (function (){
var statearr_56741 = [null,null,null,null,null,null,null,null];
(statearr_56741[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__2717__auto__);

(statearr_56741[(1)] = (1));

return statearr_56741;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2717__auto____1 = (function (state_56725){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_56725);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e56742){var ex__2720__auto__ = e56742;
var statearr_56743_56755 = state_56725;
(statearr_56743_56755[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_56725[(4)]))){
var statearr_56744_56756 = state_56725;
(statearr_56744_56756[(1)] = cljs.core.first((state_56725[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56757 = state_56725;
state_56725 = G__56757;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__2717__auto__ = function(state_56725){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2717__auto____1.call(this,state_56725);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_56745 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_56745[(6)] = c__2739__auto__);

return statearr_56745;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_56787){
var state_val_56788 = (state_56787[(1)]);
if((state_val_56788 === (7))){
var state_56787__$1 = state_56787;
var statearr_56789_56808 = state_56787__$1;
(statearr_56789_56808[(2)] = num);

(statearr_56789_56808[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56788 === (1))){
var state_56787__$1 = state_56787;
var statearr_56790_56809 = state_56787__$1;
(statearr_56790_56809[(2)] = null);

(statearr_56790_56809[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56788 === (4))){
var inst_56758 = (state_56787[(2)]);
var state_56787__$1 = state_56787;
var statearr_56791_56810 = state_56787__$1;
(statearr_56791_56810[(2)] = inst_56758);

(statearr_56791_56810[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56788 === (6))){
var state_56787__$1 = state_56787;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56787__$1,(9),num);
} else {
if((state_val_56788 === (3))){
var inst_56785 = (state_56787[(2)]);
var state_56787__$1 = state_56787;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56787__$1,inst_56785);
} else {
if((state_val_56788 === (2))){
var _ = (function (){var statearr_56793 = state_56787;
(statearr_56793[(4)] = cljs.core.cons((5),(state_56787[(4)])));

return statearr_56793;
})();
var inst_56764 = fluree.db.util.async.channel_QMARK_(num);
var state_56787__$1 = state_56787;
if(inst_56764){
var statearr_56794_56811 = state_56787__$1;
(statearr_56794_56811[(1)] = (6));

} else {
var statearr_56795_56812 = state_56787__$1;
(statearr_56795_56812[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56788 === (9))){
var inst_56767 = (state_56787[(2)]);
var inst_56768 = fluree.db.util.async.throw_err(inst_56767);
var state_56787__$1 = state_56787;
var statearr_56796_56813 = state_56787__$1;
(statearr_56796_56813[(2)] = inst_56768);

(statearr_56796_56813[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56788 === (5))){
var _ = (function (){var statearr_56797 = state_56787;
(statearr_56797[(4)] = cljs.core.rest((state_56787[(4)])));

return statearr_56797;
})();
var state_56787__$1 = state_56787;
var ex56792 = (state_56787__$1[(2)]);
var statearr_56798_56814 = state_56787__$1;
(statearr_56798_56814[(5)] = ex56792);


if((ex56792 instanceof Error)){
var statearr_56799_56815 = state_56787__$1;
(statearr_56799_56815[(1)] = (4));

(statearr_56799_56815[(5)] = null);

} else {
throw ex56792;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56788 === (8))){
var inst_56771 = (state_56787[(2)]);
var inst_56772 = fluree.db.dbfunctions.internal.floor(inst_56771);
var inst_56773 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56774 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56775 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56776 = [fluree.db.dbfunctions.fns.floor];
var inst_56777 = (new cljs.core.PersistentVector(null,1,(5),inst_56775,inst_56776,null));
var inst_56778 = ["",inst_56777,inst_56772];
var inst_56779 = cljs.core.PersistentHashMap.fromArrays(inst_56774,inst_56778);
var inst_56780 = [inst_56779,(10)];
var inst_56781 = (new cljs.core.PersistentVector(null,2,(5),inst_56773,inst_56780,null));
var inst_56782 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56781);
var _ = (function (){var statearr_56800 = state_56787;
(statearr_56800[(4)] = cljs.core.rest((state_56787[(4)])));

return statearr_56800;
})();
var state_56787__$1 = (function (){var statearr_56801 = state_56787;
(statearr_56801[(7)] = inst_56782);

return statearr_56801;
})();
var statearr_56802_56816 = state_56787__$1;
(statearr_56802_56816[(2)] = inst_56772);

(statearr_56802_56816[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__2717__auto____0 = (function (){
var statearr_56803 = [null,null,null,null,null,null,null,null];
(statearr_56803[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__2717__auto__);

(statearr_56803[(1)] = (1));

return statearr_56803;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__2717__auto____1 = (function (state_56787){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_56787);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e56804){var ex__2720__auto__ = e56804;
var statearr_56805_56817 = state_56787;
(statearr_56805_56817[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_56787[(4)]))){
var statearr_56806_56818 = state_56787;
(statearr_56806_56818[(1)] = cljs.core.first((state_56787[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56819 = state_56787;
state_56787 = G__56819;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__2717__auto__ = function(state_56787){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2717__auto____1.call(this,state_56787);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_56807 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_56807[(6)] = c__2739__auto__);

return statearr_56807;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_56844){
var state_val_56845 = (state_56844[(1)]);
if((state_val_56845 === (1))){
var state_56844__$1 = state_56844;
var statearr_56846_56861 = state_56844__$1;
(statearr_56846_56861[(2)] = null);

(statearr_56846_56861[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56845 === (2))){
var _ = (function (){var statearr_56847 = state_56844;
(statearr_56847[(4)] = cljs.core.cons((5),(state_56844[(4)])));

return statearr_56847;
})();
var inst_56826 = fluree.db.dbfunctions.internal.cas(_QMARK_ctx,compare_val,new_val);
var state_56844__$1 = state_56844;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56844__$1,(6),inst_56826);
} else {
if((state_val_56845 === (3))){
var inst_56842 = (state_56844[(2)]);
var state_56844__$1 = state_56844;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56844__$1,inst_56842);
} else {
if((state_val_56845 === (4))){
var inst_56820 = (state_56844[(2)]);
var state_56844__$1 = state_56844;
var statearr_56849_56862 = state_56844__$1;
(statearr_56849_56862[(2)] = inst_56820);

(statearr_56849_56862[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56845 === (5))){
var _ = (function (){var statearr_56850 = state_56844;
(statearr_56850[(4)] = cljs.core.rest((state_56844[(4)])));

return statearr_56850;
})();
var state_56844__$1 = state_56844;
var ex56848 = (state_56844__$1[(2)]);
var statearr_56851_56863 = state_56844__$1;
(statearr_56851_56863[(5)] = ex56848);


if((ex56848 instanceof Error)){
var statearr_56852_56864 = state_56844__$1;
(statearr_56852_56864[(1)] = (4));

(statearr_56852_56864[(5)] = null);

} else {
throw ex56848;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56845 === (6))){
var inst_56828 = (state_56844[(2)]);
var inst_56829 = fluree.db.util.async.throw_err(inst_56828);
var inst_56830 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56831 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56832 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56833 = [compare_val,new_val];
var inst_56834 = (new cljs.core.PersistentVector(null,2,(5),inst_56832,inst_56833,null));
var inst_56835 = ["",inst_56834,inst_56829];
var inst_56836 = cljs.core.PersistentHashMap.fromArrays(inst_56831,inst_56835);
var inst_56837 = [inst_56836,(10)];
var inst_56838 = (new cljs.core.PersistentVector(null,2,(5),inst_56830,inst_56837,null));
var inst_56839 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56838);
var _ = (function (){var statearr_56853 = state_56844;
(statearr_56853[(4)] = cljs.core.rest((state_56844[(4)])));

return statearr_56853;
})();
var state_56844__$1 = (function (){var statearr_56854 = state_56844;
(statearr_56854[(7)] = inst_56839);

return statearr_56854;
})();
var statearr_56855_56865 = state_56844__$1;
(statearr_56855_56865[(2)] = inst_56829);

(statearr_56855_56865[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__2717__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__2717__auto____0 = (function (){
var statearr_56856 = [null,null,null,null,null,null,null,null];
(statearr_56856[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__2717__auto__);

(statearr_56856[(1)] = (1));

return statearr_56856;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__2717__auto____1 = (function (state_56844){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_56844);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e56857){var ex__2720__auto__ = e56857;
var statearr_56858_56866 = state_56844;
(statearr_56858_56866[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_56844[(4)]))){
var statearr_56859_56867 = state_56844;
(statearr_56859_56867[(1)] = cljs.core.first((state_56844[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56868 = state_56844;
state_56844 = G__56868;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__2717__auto__ = function(state_56844){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2717__auto____1.call(this,state_56844);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__2717__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__2717__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_56860 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_56860[(6)] = c__2739__auto__);

return statearr_56860;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
