// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt(secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__62462 = arguments.length;
switch (G__62462) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_62504){
var state_val_62505 = (state_62504[(1)]);
if((state_val_62505 === (7))){
var inst_62474 = typeof user === 'string';
var state_62504__$1 = state_62504;
if(cljs.core.truth_(inst_62474)){
var statearr_62506_62535 = state_62504__$1;
(statearr_62506_62535[(1)] = (9));

} else {
var statearr_62507_62536 = state_62504__$1;
(statearr_62507_62536[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62505 === (1))){
var state_62504__$1 = state_62504;
var statearr_62508_62537 = state_62504__$1;
(statearr_62508_62537[(2)] = null);

(statearr_62508_62537[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62505 === (4))){
var inst_62463 = (state_62504[(2)]);
var inst_62464 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62463], 0));
var inst_62465 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_62463) : reject.call(null,inst_62463));
var state_62504__$1 = (function (){var statearr_62509 = state_62504;
(statearr_62509[(7)] = inst_62464);

return statearr_62509;
})();
var statearr_62510_62538 = state_62504__$1;
(statearr_62510_62538[(2)] = inst_62465);

(statearr_62510_62538[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62505 === (15))){
var inst_62493 = (state_62504[(2)]);
var inst_62494 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_62493);
var inst_62495 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62496 = cljs.core.constantly(inst_62494);
var inst_62497 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62495,inst_62496);
var inst_62498 = fluree.db.connection.add_token(conn,inst_62494);
var inst_62499 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_62493) : resolve.call(null,inst_62493));
var _ = (function (){var statearr_62511 = state_62504;
(statearr_62511[(4)] = cljs.core.rest((state_62504[(4)])));

return statearr_62511;
})();
var state_62504__$1 = (function (){var statearr_62512 = state_62504;
(statearr_62512[(8)] = inst_62497);

(statearr_62512[(9)] = inst_62498);

return statearr_62512;
})();
var statearr_62513_62539 = state_62504__$1;
(statearr_62513_62539[(2)] = inst_62499);

(statearr_62513_62539[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62505 === (13))){
var state_62504__$1 = state_62504;
var statearr_62514_62540 = state_62504__$1;
(statearr_62514_62540[(2)] = null);

(statearr_62514_62540[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62505 === (6))){
var state_62504__$1 = state_62504;
var statearr_62515_62541 = state_62504__$1;
(statearr_62515_62541[(2)] = user);

(statearr_62515_62541[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62505 === (3))){
var inst_62502 = (state_62504[(2)]);
var state_62504__$1 = state_62504;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62504__$1,inst_62502);
} else {
if((state_val_62505 === (12))){
var state_62504__$1 = state_62504;
var statearr_62516_62542 = state_62504__$1;
(statearr_62516_62542[(2)] = user);

(statearr_62516_62542[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62505 === (2))){
var _ = (function (){var statearr_62517 = state_62504;
(statearr_62517[(4)] = cljs.core.cons((5),(state_62504[(4)])));

return statearr_62517;
})();
var inst_62471 = typeof user === 'number';
var state_62504__$1 = state_62504;
if(cljs.core.truth_(inst_62471)){
var statearr_62518_62543 = state_62504__$1;
(statearr_62518_62543[(1)] = (6));

} else {
var statearr_62519_62544 = state_62504__$1;
(statearr_62519_62544[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62505 === (11))){
var inst_62485 = (state_62504[(2)]);
var state_62504__$1 = state_62504;
var statearr_62521_62545 = state_62504__$1;
(statearr_62521_62545[(2)] = inst_62485);

(statearr_62521_62545[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62505 === (9))){
var inst_62476 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62477 = ["_user/username",user];
var inst_62478 = (new cljs.core.PersistentVector(null,2,(5),inst_62476,inst_62477,null));
var state_62504__$1 = state_62504;
var statearr_62522_62546 = state_62504__$1;
(statearr_62522_62546[(2)] = inst_62478);

(statearr_62522_62546[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62505 === (5))){
var _ = (function (){var statearr_62523 = state_62504;
(statearr_62523[(4)] = cljs.core.rest((state_62504[(4)])));

return statearr_62523;
})();
var state_62504__$1 = state_62504;
var ex62520 = (state_62504__$1[(2)]);
var statearr_62524_62547 = state_62504__$1;
(statearr_62524_62547[(5)] = ex62520);


var statearr_62525_62548 = state_62504__$1;
(statearr_62525_62548[(1)] = (4));

(statearr_62525_62548[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62505 === (14))){
var inst_62483 = (state_62504[(2)]);
var state_62504__$1 = state_62504;
var statearr_62526_62549 = state_62504__$1;
(statearr_62526_62549[(2)] = inst_62483);

(statearr_62526_62549[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62505 === (10))){
var state_62504__$1 = state_62504;
var statearr_62527_62550 = state_62504__$1;
(statearr_62527_62550[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62505 === (8))){
var inst_62487 = (state_62504[(2)]);
var inst_62488 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_62489 = [account,inst_62487,password,expireSeconds,syncTo];
var inst_62490 = cljs.core.PersistentHashMap.fromArrays(inst_62488,inst_62489);
var inst_62491 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_62490);
var state_62504__$1 = state_62504;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62504__$1,(15),inst_62491);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2717__auto__ = null;
var fluree$db$connection_js$state_machine__2717__auto____0 = (function (){
var statearr_62529 = [null,null,null,null,null,null,null,null,null,null];
(statearr_62529[(0)] = fluree$db$connection_js$state_machine__2717__auto__);

(statearr_62529[(1)] = (1));

return statearr_62529;
});
var fluree$db$connection_js$state_machine__2717__auto____1 = (function (state_62504){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_62504);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e62530){var ex__2720__auto__ = e62530;
var statearr_62531_62551 = state_62504;
(statearr_62531_62551[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_62504[(4)]))){
var statearr_62532_62552 = state_62504;
(statearr_62532_62552[(1)] = cljs.core.first((state_62504[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62553 = state_62504;
state_62504 = G__62553;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2717__auto__ = function(state_62504){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2717__auto____1.call(this,state_62504);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2717__auto____0;
fluree$db$connection_js$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2717__auto____1;
return fluree$db$connection_js$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_62533 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_62533[(6)] = c__2739__auto__);

return statearr_62533;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__62555 = arguments.length;
switch (G__62555) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in(cljs.core.assoc_in(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var _ = (function (){var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_62564){
var state_val_62565 = (state_62564[(1)]);
if((state_val_62565 === (1))){
var inst_62556 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62557 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62558 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_62559 = (new cljs.core.PersistentVector(null,4,(5),inst_62557,inst_62558,null));
var inst_62560 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62556,inst_62559);
var inst_62561 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__62566 = cljs.core.seq(cljs.core.keys(x));
var chunk__62567 = null;
var count__62568 = (0);
var i__62569 = (0);
while(true){
if((i__62569 < count__62568)){
var k = chunk__62567.cljs$core$IIndexed$_nth$arity$2(null,i__62569);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__62577 = seq__62566;
var G__62578 = chunk__62567;
var G__62579 = count__62568;
var G__62580 = (i__62569 + (1));
seq__62566 = G__62577;
chunk__62567 = G__62578;
count__62568 = G__62579;
i__62569 = G__62580;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__62566);
if(temp__5753__auto__){
var seq__62566__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__62566__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__62566__$1);
var G__62581 = cljs.core.chunk_rest(seq__62566__$1);
var G__62582 = c__4638__auto__;
var G__62583 = cljs.core.count(c__4638__auto__);
var G__62584 = (0);
seq__62566 = G__62581;
chunk__62567 = G__62582;
count__62568 = G__62583;
i__62569 = G__62584;
continue;
} else {
var k = cljs.core.first(seq__62566__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__62585 = cljs.core.next(seq__62566__$1);
var G__62586 = null;
var G__62587 = (0);
var G__62588 = (0);
seq__62566 = G__62585;
chunk__62567 = G__62586;
count__62568 = G__62587;
i__62569 = G__62588;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_62562 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_62561);
var state_62564__$1 = (function (){var statearr_62570 = state_62564;
(statearr_62570[(7)] = inst_62560);

return statearr_62570;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_62564__$1,inst_62562);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2717__auto__ = null;
var fluree$db$connection_js$state_machine__2717__auto____0 = (function (){
var statearr_62571 = [null,null,null,null,null,null,null,null];
(statearr_62571[(0)] = fluree$db$connection_js$state_machine__2717__auto__);

(statearr_62571[(1)] = (1));

return statearr_62571;
});
var fluree$db$connection_js$state_machine__2717__auto____1 = (function (state_62564){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_62564);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e62572){var ex__2720__auto__ = e62572;
var statearr_62573_62589 = state_62564;
(statearr_62573_62589[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_62564[(4)]))){
var statearr_62574_62590 = state_62564;
(statearr_62574_62590[(1)] = cljs.core.first((state_62564[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62591 = state_62564;
state_62564 = G__62591;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2717__auto__ = function(state_62564){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2717__auto____1.call(this,state_62564);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2717__auto____0;
fluree$db$connection_js$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2717__auto____1;
return fluree$db$connection_js$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_62575 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_62575[(6)] = c__2739__auto__);

return statearr_62575;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__62593 = arguments.length;
switch (G__62593) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_62627){
var state_val_62628 = (state_62627[(1)]);
if((state_val_62628 === (1))){
var state_62627__$1 = state_62627;
var statearr_62629_62650 = state_62627__$1;
(statearr_62629_62650[(2)] = null);

(statearr_62629_62650[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62628 === (2))){
var _ = (function (){var statearr_62630 = state_62627;
(statearr_62630[(4)] = cljs.core.cons((5),(state_62627[(4)])));

return statearr_62630;
})();
var inst_62602 = fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0));
var inst_62603 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62604 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_62605 = (new cljs.core.PersistentVector(null,1,(5),inst_62603,inst_62604,null));
var inst_62606 = cljs.core.PersistentHashMap.EMPTY;
var inst_62607 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_62606);
var inst_62608 = cljs.core.assoc_in(inst_62602,inst_62605,inst_62607);
var inst_62609 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62610 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_62611 = (new cljs.core.PersistentVector(null,1,(5),inst_62609,inst_62610,null));
var inst_62612 = cljs.core.PersistentHashMap.EMPTY;
var inst_62613 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_62612);
var inst_62614 = cljs.core.assoc_in(inst_62608,inst_62611,inst_62613);
var inst_62615 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_62616 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_62614);
var inst_62617 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62618 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_62615,null];
var inst_62619 = (new cljs.core.PersistentVector(null,4,(5),inst_62617,inst_62618,null));
var inst_62620 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62616,inst_62619);
var inst_62621 = (function (){var conn = inst_62614;
var pc = inst_62615;
return (function (x){
if((x == null)){
} else {
var seq__62631_62651 = cljs.core.seq(cljs.core.keys(x));
var chunk__62632_62652 = null;
var count__62633_62653 = (0);
var i__62634_62654 = (0);
while(true){
if((i__62634_62654 < count__62633_62653)){
var k_62655 = chunk__62632_62652.cljs$core$IIndexed$_nth$arity$2(null,i__62634_62654);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_62655], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_62655,null));


var G__62656 = seq__62631_62651;
var G__62657 = chunk__62632_62652;
var G__62658 = count__62633_62653;
var G__62659 = (i__62634_62654 + (1));
seq__62631_62651 = G__62656;
chunk__62632_62652 = G__62657;
count__62633_62653 = G__62658;
i__62634_62654 = G__62659;
continue;
} else {
var temp__5753__auto___62660 = cljs.core.seq(seq__62631_62651);
if(temp__5753__auto___62660){
var seq__62631_62661__$1 = temp__5753__auto___62660;
if(cljs.core.chunked_seq_QMARK_(seq__62631_62661__$1)){
var c__4638__auto___62662 = cljs.core.chunk_first(seq__62631_62661__$1);
var G__62663 = cljs.core.chunk_rest(seq__62631_62661__$1);
var G__62664 = c__4638__auto___62662;
var G__62665 = cljs.core.count(c__4638__auto___62662);
var G__62666 = (0);
seq__62631_62651 = G__62663;
chunk__62632_62652 = G__62664;
count__62633_62653 = G__62665;
i__62634_62654 = G__62666;
continue;
} else {
var k_62667 = cljs.core.first(seq__62631_62661__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_62667], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_62667,null));


var G__62668 = cljs.core.next(seq__62631_62661__$1);
var G__62669 = null;
var G__62670 = (0);
var G__62671 = (0);
seq__62631_62651 = G__62668;
chunk__62632_62652 = G__62669;
count__62633_62653 = G__62670;
i__62634_62654 = G__62671;
continue;
}
} else {
}
}
break;
}
}

return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(conn) : resolve.call(null,conn));
});
})();
var inst_62622 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62615,inst_62621);
var ___$1 = (function (){var statearr_62635 = state_62627;
(statearr_62635[(4)] = cljs.core.rest((state_62627[(4)])));

return statearr_62635;
})();
var state_62627__$1 = (function (){var statearr_62636 = state_62627;
(statearr_62636[(7)] = inst_62620);

return statearr_62636;
})();
var statearr_62637_62672 = state_62627__$1;
(statearr_62637_62672[(2)] = inst_62622);

(statearr_62637_62672[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62628 === (3))){
var inst_62625 = (state_62627[(2)]);
var state_62627__$1 = state_62627;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62627__$1,inst_62625);
} else {
if((state_val_62628 === (4))){
var inst_62594 = (state_62627[(2)]);
var inst_62595 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62594], 0));
var inst_62596 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_62594) : reject.call(null,inst_62594));
var state_62627__$1 = (function (){var statearr_62639 = state_62627;
(statearr_62639[(8)] = inst_62595);

return statearr_62639;
})();
var statearr_62640_62673 = state_62627__$1;
(statearr_62640_62673[(2)] = inst_62596);

(statearr_62640_62673[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62628 === (5))){
var _ = (function (){var statearr_62641 = state_62627;
(statearr_62641[(4)] = cljs.core.rest((state_62627[(4)])));

return statearr_62641;
})();
var state_62627__$1 = state_62627;
var ex62638 = (state_62627__$1[(2)]);
var statearr_62642_62674 = state_62627__$1;
(statearr_62642_62674[(5)] = ex62638);


var statearr_62643_62675 = state_62627__$1;
(statearr_62643_62675[(1)] = (4));

(statearr_62643_62675[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2717__auto__ = null;
var fluree$db$connection_js$state_machine__2717__auto____0 = (function (){
var statearr_62644 = [null,null,null,null,null,null,null,null,null];
(statearr_62644[(0)] = fluree$db$connection_js$state_machine__2717__auto__);

(statearr_62644[(1)] = (1));

return statearr_62644;
});
var fluree$db$connection_js$state_machine__2717__auto____1 = (function (state_62627){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_62627);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e62645){var ex__2720__auto__ = e62645;
var statearr_62646_62676 = state_62627;
(statearr_62646_62676[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_62627[(4)]))){
var statearr_62647_62677 = state_62627;
(statearr_62647_62677[(1)] = cljs.core.first((state_62627[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62678 = state_62627;
state_62627 = G__62678;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2717__auto__ = function(state_62627){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2717__auto____1.call(this,state_62627);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2717__auto____0;
fluree$db$connection_js$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2717__auto____1;
return fluree$db$connection_js$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_62648 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_62648[(6)] = c__2739__auto__);

return statearr_62648;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_(conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__62680 = arguments.length;
switch (G__62680) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__4212__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not(open_api_QMARK_)) && (cljs.core.not(has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token(conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__62682 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62682,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62682,(1),null);
var cb_STAR_ = (function (header,data){
var G__62685 = cljs.core.clj__GT_js(header);
var G__62686 = cljs.core.clj__GT_js(data);
return (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(G__62685,G__62686) : callback.call(null,G__62685,G__62686));
});
return fluree.db.connection.add_listener(conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__62687 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62687,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62687,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js(fluree.db.connection.listeners(conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_62740){
var state_val_62741 = (state_62740[(1)]);
if((state_val_62741 === (7))){
var inst_62701 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62702 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_62703 = cljs.core.PersistentHashMap.fromArrays(inst_62701,inst_62702);
var inst_62704 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_62703);
var inst_62705 = (function(){throw inst_62704})();
var state_62740__$1 = state_62740;
var statearr_62742_62774 = state_62740__$1;
(statearr_62742_62774[(2)] = inst_62705);

(statearr_62742_62774[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62741 === (1))){
var state_62740__$1 = state_62740;
var statearr_62743_62775 = state_62740__$1;
(statearr_62743_62775[(2)] = null);

(statearr_62743_62775[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62741 === (4))){
var inst_62690 = (state_62740[(2)]);
var inst_62691 = cljs.core.clj__GT_js(inst_62690);
var inst_62692 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_62691) : reject.call(null,inst_62691));
var state_62740__$1 = state_62740;
var statearr_62744_62776 = state_62740__$1;
(statearr_62744_62776[(2)] = inst_62692);

(statearr_62744_62776[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62741 === (13))){
var inst_62719 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62720 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_62721 = cljs.core.PersistentHashMap.fromArrays(inst_62719,inst_62720);
var inst_62722 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied.",inst_62721);
var inst_62723 = (function(){throw inst_62722})();
var state_62740__$1 = state_62740;
var statearr_62745_62777 = state_62740__$1;
(statearr_62745_62777[(2)] = inst_62723);

(statearr_62745_62777[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62741 === (6))){
var state_62740__$1 = state_62740;
var statearr_62746_62778 = state_62740__$1;
(statearr_62746_62778[(2)] = null);

(statearr_62746_62778[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62741 === (3))){
var inst_62738 = (state_62740[(2)]);
var state_62740__$1 = state_62740;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62740__$1,inst_62738);
} else {
if((state_val_62741 === (12))){
var state_62740__$1 = state_62740;
var statearr_62747_62779 = state_62740__$1;
(statearr_62747_62779[(2)] = null);

(statearr_62747_62779[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62741 === (2))){
var _ = (function (){var statearr_62748 = state_62740;
(statearr_62748[(4)] = cljs.core.cons((5),(state_62740[(4)])));

return statearr_62748;
})();
var inst_62698 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_62740__$1 = state_62740;
if(cljs.core.truth_(inst_62698)){
var statearr_62749_62780 = state_62740__$1;
(statearr_62749_62780[(1)] = (6));

} else {
var statearr_62750_62781 = state_62740__$1;
(statearr_62750_62781[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62741 === (11))){
var inst_62716 = (state_62740[(2)]);
var state_62740__$1 = (function (){var statearr_62752 = state_62740;
(statearr_62752[(7)] = inst_62716);

return statearr_62752;
})();
if(cljs.core.truth_(password)){
var statearr_62753_62782 = state_62740__$1;
(statearr_62753_62782[(1)] = (12));

} else {
var statearr_62754_62783 = state_62740__$1;
(statearr_62754_62783[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62741 === (9))){
var state_62740__$1 = state_62740;
var statearr_62755_62784 = state_62740__$1;
(statearr_62755_62784[(2)] = null);

(statearr_62755_62784[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62741 === (5))){
var _ = (function (){var statearr_62756 = state_62740;
(statearr_62756[(4)] = cljs.core.rest((state_62740[(4)])));

return statearr_62756;
})();
var state_62740__$1 = state_62740;
var ex62751 = (state_62740__$1[(2)]);
var statearr_62757_62785 = state_62740__$1;
(statearr_62757_62785[(5)] = ex62751);


var statearr_62758_62786 = state_62740__$1;
(statearr_62758_62786[(1)] = (4));

(statearr_62758_62786[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62741 === (14))){
var inst_62725 = (state_62740[(2)]);
var inst_62726 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"password","password",417022471),password], 0));
var inst_62727 = fluree.db.util.core.without_nils(inst_62726);
var inst_62728 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_62729 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62730 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62731 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_62727,inst_62728,null];
var inst_62732 = (new cljs.core.PersistentVector(null,4,(5),inst_62730,inst_62731,null));
var inst_62733 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62729,inst_62732);
var inst_62734 = (function (){var _ = inst_62725;
var data = inst_62727;
var pc = inst_62728;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__62759 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__62759) : reject.call(null,G__62759));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4212__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4212__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__62760 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__62760) : reject.call(null,G__62760));
} else {
var G__62761 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__62761) : resolve.call(null,G__62761));

}
}
});
})();
var inst_62735 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62728,inst_62734);
var _ = (function (){var statearr_62762 = state_62740;
(statearr_62762[(4)] = cljs.core.rest((state_62740[(4)])));

return statearr_62762;
})();
var state_62740__$1 = (function (){var statearr_62763 = state_62740;
(statearr_62763[(8)] = inst_62733);

return statearr_62763;
})();
var statearr_62764_62787 = state_62740__$1;
(statearr_62764_62787[(2)] = inst_62735);

(statearr_62764_62787[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62741 === (10))){
var inst_62710 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62711 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_62712 = cljs.core.PersistentHashMap.fromArrays(inst_62710,inst_62711);
var inst_62713 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied.",inst_62712);
var inst_62714 = (function(){throw inst_62713})();
var state_62740__$1 = state_62740;
var statearr_62765_62788 = state_62740__$1;
(statearr_62765_62788[(2)] = inst_62714);

(statearr_62765_62788[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62741 === (8))){
var inst_62707 = (state_62740[(2)]);
var state_62740__$1 = (function (){var statearr_62766 = state_62740;
(statearr_62766[(9)] = inst_62707);

return statearr_62766;
})();
if(cljs.core.truth_(ledger)){
var statearr_62767_62789 = state_62740__$1;
(statearr_62767_62789[(1)] = (9));

} else {
var statearr_62768_62790 = state_62740__$1;
(statearr_62768_62790[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2717__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2717__auto____0 = (function (){
var statearr_62769 = [null,null,null,null,null,null,null,null,null,null];
(statearr_62769[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2717__auto__);

(statearr_62769[(1)] = (1));

return statearr_62769;
});
var fluree$db$connection_js$password_generate_$_state_machine__2717__auto____1 = (function (state_62740){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_62740);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e62770){var ex__2720__auto__ = e62770;
var statearr_62771_62791 = state_62740;
(statearr_62771_62791[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_62740[(4)]))){
var statearr_62772_62792 = state_62740;
(statearr_62772_62792[(1)] = cljs.core.first((state_62740[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62793 = state_62740;
state_62740 = G__62793;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2717__auto__ = function(state_62740){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2717__auto____1.call(this,state_62740);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2717__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2717__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_62773 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_62773[(6)] = c__2739__auto__);

return statearr_62773;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__62795 = arguments.length;
switch (G__62795) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_62862){
var state_val_62863 = (state_62862[(1)]);
if((state_val_62863 === (7))){
var inst_62807 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62808 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_62809 = cljs.core.PersistentHashMap.fromArrays(inst_62807,inst_62808);
var inst_62810 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_62809);
var inst_62811 = (function(){throw inst_62810})();
var state_62862__$1 = state_62862;
var statearr_62864_62906 = state_62862__$1;
(statearr_62864_62906[(2)] = inst_62811);

(statearr_62864_62906[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62863 === (20))){
var inst_62845 = (state_62862[(2)]);
var inst_62846 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_62847 = [ledger,password,user,auth,expire];
var inst_62848 = cljs.core.PersistentHashMap.fromArrays(inst_62846,inst_62847);
var inst_62849 = fluree.db.util.core.without_nils(inst_62848);
var inst_62850 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_62851 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62852 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62853 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_62849,inst_62850,null];
var inst_62854 = (new cljs.core.PersistentVector(null,4,(5),inst_62852,inst_62853,null));
var inst_62855 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62851,inst_62854);
var inst_62856 = (function (){var _ = inst_62845;
var data = inst_62849;
var pc = inst_62850;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__62865 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__62865) : reject.call(null,G__62865));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4212__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4212__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__62866 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__62866) : reject.call(null,G__62866));
} else {
fluree.db.connection.add_token(conn,result);

var G__62867 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__62867) : resolve.call(null,G__62867));

}
}
});
})();
var inst_62857 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62850,inst_62856);
var _ = (function (){var statearr_62868 = state_62862;
(statearr_62868[(4)] = cljs.core.rest((state_62862[(4)])));

return statearr_62868;
})();
var state_62862__$1 = (function (){var statearr_62869 = state_62862;
(statearr_62869[(7)] = inst_62855);

return statearr_62869;
})();
var statearr_62870_62907 = state_62862__$1;
(statearr_62870_62907[(2)] = inst_62857);

(statearr_62870_62907[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62863 === (1))){
var state_62862__$1 = state_62862;
var statearr_62871_62908 = state_62862__$1;
(statearr_62871_62908[(2)] = null);

(statearr_62871_62908[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62863 === (4))){
var inst_62796 = (state_62862[(2)]);
var inst_62797 = cljs.core.clj__GT_js(inst_62796);
var inst_62798 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_62797) : reject.call(null,inst_62797));
var state_62862__$1 = state_62862;
var statearr_62872_62909 = state_62862__$1;
(statearr_62872_62909[(2)] = inst_62798);

(statearr_62872_62909[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62863 === (15))){
var inst_62832 = (state_62862[(8)]);
var state_62862__$1 = state_62862;
var statearr_62873_62910 = state_62862__$1;
(statearr_62873_62910[(2)] = inst_62832);

(statearr_62873_62910[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62863 === (13))){
var inst_62825 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62826 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_62827 = cljs.core.PersistentHashMap.fromArrays(inst_62825,inst_62826);
var inst_62828 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied in the provided JSON.",inst_62827);
var inst_62829 = (function(){throw inst_62828})();
var state_62862__$1 = state_62862;
var statearr_62874_62911 = state_62862__$1;
(statearr_62874_62911[(2)] = inst_62829);

(statearr_62874_62911[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62863 === (6))){
var state_62862__$1 = state_62862;
var statearr_62875_62912 = state_62862__$1;
(statearr_62875_62912[(2)] = null);

(statearr_62875_62912[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62863 === (17))){
var inst_62836 = (state_62862[(2)]);
var state_62862__$1 = state_62862;
if(cljs.core.truth_(inst_62836)){
var statearr_62876_62913 = state_62862__$1;
(statearr_62876_62913[(1)] = (18));

} else {
var statearr_62877_62914 = state_62862__$1;
(statearr_62877_62914[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62863 === (3))){
var inst_62860 = (state_62862[(2)]);
var state_62862__$1 = state_62862;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62862__$1,inst_62860);
} else {
if((state_val_62863 === (12))){
var state_62862__$1 = state_62862;
var statearr_62878_62915 = state_62862__$1;
(statearr_62878_62915[(2)] = null);

(statearr_62878_62915[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62863 === (2))){
var _ = (function (){var statearr_62879 = state_62862;
(statearr_62879[(4)] = cljs.core.cons((5),(state_62862[(4)])));

return statearr_62879;
})();
var inst_62804 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_62862__$1 = state_62862;
if(cljs.core.truth_(inst_62804)){
var statearr_62880_62916 = state_62862__$1;
(statearr_62880_62916[(1)] = (6));

} else {
var statearr_62881_62917 = state_62862__$1;
(statearr_62881_62917[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62863 === (19))){
var inst_62839 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62840 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_62841 = cljs.core.PersistentHashMap.fromArrays(inst_62839,inst_62840);
var inst_62842 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A user identity or auth identity must be supplied.",inst_62841);
var inst_62843 = (function(){throw inst_62842})();
var state_62862__$1 = state_62862;
var statearr_62882_62918 = state_62862__$1;
(statearr_62882_62918[(2)] = inst_62843);

(statearr_62882_62918[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62863 === (11))){
var inst_62822 = (state_62862[(2)]);
var state_62862__$1 = (function (){var statearr_62884 = state_62862;
(statearr_62884[(9)] = inst_62822);

return statearr_62884;
})();
if(cljs.core.truth_(password)){
var statearr_62885_62919 = state_62862__$1;
(statearr_62885_62919[(1)] = (12));

} else {
var statearr_62886_62920 = state_62862__$1;
(statearr_62886_62920[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62863 === (9))){
var state_62862__$1 = state_62862;
var statearr_62887_62921 = state_62862__$1;
(statearr_62887_62921[(2)] = null);

(statearr_62887_62921[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62863 === (5))){
var _ = (function (){var statearr_62888 = state_62862;
(statearr_62888[(4)] = cljs.core.rest((state_62862[(4)])));

return statearr_62888;
})();
var state_62862__$1 = state_62862;
var ex62883 = (state_62862__$1[(2)]);
var statearr_62889_62922 = state_62862__$1;
(statearr_62889_62922[(5)] = ex62883);


var statearr_62890_62923 = state_62862__$1;
(statearr_62890_62923[(1)] = (4));

(statearr_62890_62923[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62863 === (14))){
var inst_62832 = (state_62862[(8)]);
var inst_62831 = (state_62862[(2)]);
var inst_62832__$1 = user;
var state_62862__$1 = (function (){var statearr_62891 = state_62862;
(statearr_62891[(10)] = inst_62831);

(statearr_62891[(8)] = inst_62832__$1);

return statearr_62891;
})();
if(cljs.core.truth_(inst_62832__$1)){
var statearr_62892_62924 = state_62862__$1;
(statearr_62892_62924[(1)] = (15));

} else {
var statearr_62893_62925 = state_62862__$1;
(statearr_62893_62925[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62863 === (16))){
var state_62862__$1 = state_62862;
var statearr_62894_62926 = state_62862__$1;
(statearr_62894_62926[(2)] = auth);

(statearr_62894_62926[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62863 === (10))){
var inst_62816 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62817 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_62818 = cljs.core.PersistentHashMap.fromArrays(inst_62816,inst_62817);
var inst_62819 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied in the provided JSON.",inst_62818);
var inst_62820 = (function(){throw inst_62819})();
var state_62862__$1 = state_62862;
var statearr_62895_62927 = state_62862__$1;
(statearr_62895_62927[(2)] = inst_62820);

(statearr_62895_62927[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62863 === (18))){
var state_62862__$1 = state_62862;
var statearr_62896_62928 = state_62862__$1;
(statearr_62896_62928[(2)] = null);

(statearr_62896_62928[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62863 === (8))){
var inst_62813 = (state_62862[(2)]);
var state_62862__$1 = (function (){var statearr_62897 = state_62862;
(statearr_62897[(11)] = inst_62813);

return statearr_62897;
})();
if(cljs.core.truth_(ledger)){
var statearr_62898_62929 = state_62862__$1;
(statearr_62898_62929[(1)] = (9));

} else {
var statearr_62899_62930 = state_62862__$1;
(statearr_62899_62930[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2717__auto__ = null;
var fluree$db$connection_js$state_machine__2717__auto____0 = (function (){
var statearr_62900 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62900[(0)] = fluree$db$connection_js$state_machine__2717__auto__);

(statearr_62900[(1)] = (1));

return statearr_62900;
});
var fluree$db$connection_js$state_machine__2717__auto____1 = (function (state_62862){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_62862);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e62901){var ex__2720__auto__ = e62901;
var statearr_62902_62931 = state_62862;
(statearr_62902_62931[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_62862[(4)]))){
var statearr_62903_62932 = state_62862;
(statearr_62903_62932[(1)] = cljs.core.first((state_62862[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62933 = state_62862;
state_62862 = G__62933;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2717__auto__ = function(state_62862){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2717__auto____1.call(this,state_62862);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2717__auto____0;
fluree$db$connection_js$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2717__auto____1;
return fluree$db$connection_js$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_62904 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_62904[(6)] = c__2739__auto__);

return statearr_62904;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__62935 = arguments.length;
switch (G__62935) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_62970){
var state_val_62971 = (state_62970[(1)]);
if((state_val_62971 === (1))){
var state_62970__$1 = state_62970;
var statearr_62972_62994 = state_62970__$1;
(statearr_62972_62994[(2)] = null);

(statearr_62972_62994[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (2))){
var _ = (function (){var statearr_62973 = state_62970;
(statearr_62973[(4)] = cljs.core.cons((5),(state_62970[(4)])));

return statearr_62973;
})();
var inst_62944 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_62970__$1 = state_62970;
if(cljs.core.truth_(inst_62944)){
var statearr_62974_62995 = state_62970__$1;
(statearr_62974_62995[(1)] = (6));

} else {
var statearr_62975_62996 = state_62970__$1;
(statearr_62975_62996[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (3))){
var inst_62968 = (state_62970[(2)]);
var state_62970__$1 = state_62970;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62970__$1,inst_62968);
} else {
if((state_val_62971 === (4))){
var inst_62936 = (state_62970[(2)]);
var inst_62937 = cljs.core.clj__GT_js(inst_62936);
var inst_62938 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_62937) : reject.call(null,inst_62937));
var state_62970__$1 = state_62970;
var statearr_62977_62997 = state_62970__$1;
(statearr_62977_62997[(2)] = inst_62938);

(statearr_62977_62997[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (5))){
var _ = (function (){var statearr_62978 = state_62970;
(statearr_62978[(4)] = cljs.core.rest((state_62970[(4)])));

return statearr_62978;
})();
var state_62970__$1 = state_62970;
var ex62976 = (state_62970__$1[(2)]);
var statearr_62979_62998 = state_62970__$1;
(statearr_62979_62998[(5)] = ex62976);


var statearr_62980_62999 = state_62970__$1;
(statearr_62980_62999[(1)] = (4));

(statearr_62980_62999[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (6))){
var state_62970__$1 = state_62970;
var statearr_62981_63000 = state_62970__$1;
(statearr_62981_63000[(2)] = null);

(statearr_62981_63000[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (7))){
var inst_62947 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62948 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_62949 = cljs.core.PersistentHashMap.fromArrays(inst_62947,inst_62948);
var inst_62950 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_62949);
var inst_62951 = (function(){throw inst_62950})();
var state_62970__$1 = state_62970;
var statearr_62982_63001 = state_62970__$1;
(statearr_62982_63001[(2)] = inst_62951);

(statearr_62982_63001[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62971 === (8))){
var inst_62953 = (state_62970[(2)]);
var inst_62954 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_62955 = [jwt,expire];
var inst_62956 = cljs.core.PersistentHashMap.fromArrays(inst_62954,inst_62955);
var inst_62957 = fluree.db.util.core.without_nils(inst_62956);
var inst_62958 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_62959 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62960 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62961 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_62957,inst_62958,null];
var inst_62962 = (new cljs.core.PersistentVector(null,4,(5),inst_62960,inst_62961,null));
var inst_62963 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62959,inst_62962);
var inst_62964 = (function (){var _ = inst_62953;
var data = inst_62957;
var pc = inst_62958;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__62983 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__62983) : reject.call(null,G__62983));
} else {
return null;
}
} else {
fluree.db.connection.add_token(conn,result);

var G__62984 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__62984) : resolve.call(null,G__62984));

}
});
})();
var inst_62965 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62958,inst_62964);
var _ = (function (){var statearr_62985 = state_62970;
(statearr_62985[(4)] = cljs.core.rest((state_62970[(4)])));

return statearr_62985;
})();
var state_62970__$1 = (function (){var statearr_62986 = state_62970;
(statearr_62986[(7)] = inst_62963);

return statearr_62986;
})();
var statearr_62987_63002 = state_62970__$1;
(statearr_62987_63002[(2)] = inst_62965);

(statearr_62987_63002[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2717__auto__ = null;
var fluree$db$connection_js$state_machine__2717__auto____0 = (function (){
var statearr_62988 = [null,null,null,null,null,null,null,null];
(statearr_62988[(0)] = fluree$db$connection_js$state_machine__2717__auto__);

(statearr_62988[(1)] = (1));

return statearr_62988;
});
var fluree$db$connection_js$state_machine__2717__auto____1 = (function (state_62970){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_62970);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e62989){var ex__2720__auto__ = e62989;
var statearr_62990_63003 = state_62970;
(statearr_62990_63003[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_62970[(4)]))){
var statearr_62991_63004 = state_62970;
(statearr_62991_63004[(1)] = cljs.core.first((state_62970[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63005 = state_62970;
state_62970 = G__63005;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2717__auto__ = function(state_62970){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2717__auto____1.call(this,state_62970);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2717__auto____0;
fluree$db$connection_js$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2717__auto____1;
return fluree$db$connection_js$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_62992 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_62992[(6)] = c__2739__auto__);

return statearr_62992;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

