// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(dbid){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__59258 = arguments.length;
switch (G__59258) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2739__auto___59406 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_59345){
var state_val_59346 = (state_59345[(1)]);
if((state_val_59346 === (7))){
var inst_59276 = (state_59345[(7)]);
var inst_59279 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_59276);
var state_59345__$1 = state_59345;
var statearr_59347_59407 = state_59345__$1;
(statearr_59347_59407[(2)] = inst_59279);

(statearr_59347_59407[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59346 === (20))){
var inst_59271 = (state_59345[(8)]);
var inst_59300 = (state_59345[(9)]);
var inst_59304 = fluree.db.auth.roles(inst_59271,inst_59300);
var state_59345__$1 = state_59345;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59345__$1,(23),inst_59304);
} else {
if((state_val_59346 === (27))){
var inst_59271 = (state_59345[(8)]);
var inst_59319 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_59320 = fluree.db.time_travel.as_of_block(inst_59271,inst_59319);
var state_59345__$1 = state_59345;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59345__$1,(30),inst_59320);
} else {
if((state_val_59346 === (1))){
var state_59345__$1 = state_59345;
var statearr_59348_59408 = state_59345__$1;
(statearr_59348_59408[(2)] = null);

(statearr_59348_59408[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59346 === (24))){
var inst_59312 = (state_59345[(10)]);
var inst_59271 = (state_59345[(8)]);
var inst_59314 = fluree.db.permissions.permission_map(inst_59271,inst_59312,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_59345__$1 = state_59345;
var statearr_59349_59409 = state_59345__$1;
(statearr_59349_59409[(2)] = inst_59314);

(statearr_59349_59409[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59346 === (4))){
var inst_59259 = (state_59345[(2)]);
var inst_59260 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_59259);
var inst_59261 = cljs.core.async.close_BANG_(pc);
var state_59345__$1 = (function (){var statearr_59350 = state_59345;
(statearr_59350[(11)] = inst_59260);

return statearr_59350;
})();
var statearr_59351_59410 = state_59345__$1;
(statearr_59351_59410[(2)] = inst_59261);

(statearr_59351_59410[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59346 === (15))){
var inst_59276 = (state_59345[(7)]);
var inst_59290 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_59276)," unknown."].join('');
var inst_59291 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59292 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_59293 = cljs.core.PersistentHashMap.fromArrays(inst_59291,inst_59292);
var inst_59294 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_59290,inst_59293);
var inst_59295 = (function(){throw inst_59294})();
var state_59345__$1 = state_59345;
var statearr_59352_59411 = state_59345__$1;
(statearr_59352_59411[(2)] = inst_59295);

(statearr_59352_59411[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59346 === (21))){
var state_59345__$1 = state_59345;
var statearr_59353_59412 = state_59345__$1;
(statearr_59353_59412[(2)] = null);

(statearr_59353_59412[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59346 === (31))){
var inst_59326 = (state_59345[(12)]);
var inst_59276 = (state_59345[(7)]);
var inst_59328 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_59326,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_59276);
var state_59345__$1 = state_59345;
var statearr_59354_59413 = state_59345__$1;
(statearr_59354_59413[(2)] = inst_59328);

(statearr_59354_59413[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59346 === (32))){
var inst_59326 = (state_59345[(12)]);
var state_59345__$1 = state_59345;
var statearr_59355_59414 = state_59345__$1;
(statearr_59355_59414[(2)] = inst_59326);

(statearr_59355_59414[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59346 === (33))){
var inst_59312 = (state_59345[(10)]);
var inst_59331 = (state_59345[(2)]);
var state_59345__$1 = (function (){var statearr_59356 = state_59345;
(statearr_59356[(13)] = inst_59331);

return statearr_59356;
})();
if(cljs.core.truth_(inst_59312)){
var statearr_59357_59415 = state_59345__$1;
(statearr_59357_59415[(1)] = (34));

} else {
var statearr_59358_59416 = state_59345__$1;
(statearr_59358_59416[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59346 === (13))){
var inst_59287 = (state_59345[(14)]);
var inst_59286 = (state_59345[(2)]);
var inst_59287__$1 = fluree.db.util.async.throw_err(inst_59286);
var state_59345__$1 = (function (){var statearr_59359 = state_59345;
(statearr_59359[(14)] = inst_59287__$1);

return statearr_59359;
})();
if(cljs.core.truth_(inst_59287__$1)){
var statearr_59360_59417 = state_59345__$1;
(statearr_59360_59417[(1)] = (14));

} else {
var statearr_59361_59418 = state_59345__$1;
(statearr_59361_59418[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59346 === (22))){
var inst_59310 = (state_59345[(2)]);
var state_59345__$1 = state_59345;
var statearr_59362_59419 = state_59345__$1;
(statearr_59362_59419[(2)] = inst_59310);

(statearr_59362_59419[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59346 === (36))){
var inst_59339 = (state_59345[(2)]);
var inst_59340 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_59339);
var _ = (function (){var statearr_59363 = state_59345;
(statearr_59363[(4)] = cljs.core.rest((state_59345[(4)])));

return statearr_59363;
})();
var state_59345__$1 = state_59345;
var statearr_59364_59420 = state_59345__$1;
(statearr_59364_59420[(2)] = inst_59340);

(statearr_59364_59420[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59346 === (29))){
var inst_59276 = (state_59345[(7)]);
var inst_59326 = (state_59345[(2)]);
var state_59345__$1 = (function (){var statearr_59365 = state_59345;
(statearr_59365[(12)] = inst_59326);

return statearr_59365;
})();
if(cljs.core.truth_(inst_59276)){
var statearr_59366_59421 = state_59345__$1;
(statearr_59366_59421[(1)] = (31));

} else {
var statearr_59367_59422 = state_59345__$1;
(statearr_59367_59422[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59346 === (6))){
var inst_59276 = (state_59345[(7)]);
var inst_59270 = (state_59345[(2)]);
var inst_59271 = fluree.db.util.async.throw_err(inst_59270);
var inst_59272 = opts;
var inst_59273 = cljs.core.__destructure_map(inst_59272);
var inst_59274 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_59273,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_59275 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_59273,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_59276__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_59273,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_59277 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_59273,new cljs.core.Keyword(null,"block","block",664686210));
var state_59345__$1 = (function (){var statearr_59368 = state_59345;
(statearr_59368[(15)] = inst_59274);

(statearr_59368[(16)] = inst_59277);

(statearr_59368[(7)] = inst_59276__$1);

(statearr_59368[(8)] = inst_59271);

(statearr_59368[(17)] = inst_59275);

return statearr_59368;
})();
if(cljs.core.truth_(inst_59276__$1)){
var statearr_59369_59423 = state_59345__$1;
(statearr_59369_59423[(1)] = (7));

} else {
var statearr_59370_59424 = state_59345__$1;
(statearr_59370_59424[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59346 === (28))){
var inst_59271 = (state_59345[(8)]);
var state_59345__$1 = state_59345;
var statearr_59371_59425 = state_59345__$1;
(statearr_59371_59425[(2)] = inst_59271);

(statearr_59371_59425[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59346 === (25))){
var state_59345__$1 = state_59345;
var statearr_59372_59426 = state_59345__$1;
(statearr_59372_59426[(2)] = null);

(statearr_59372_59426[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59346 === (34))){
var inst_59317 = (state_59345[(18)]);
var state_59345__$1 = state_59345;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59345__$1,(37),inst_59317);
} else {
if((state_val_59346 === (17))){
var inst_59274 = (state_59345[(15)]);
var state_59345__$1 = state_59345;
var statearr_59373_59427 = state_59345__$1;
(statearr_59373_59427[(2)] = inst_59274);

(statearr_59373_59427[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59346 === (3))){
var inst_59343 = (state_59345[(2)]);
var state_59345__$1 = state_59345;
return cljs.core.async.impl.ioc_helpers.return_chan(state_59345__$1,inst_59343);
} else {
if((state_val_59346 === (12))){
var inst_59274 = (state_59345[(15)]);
var inst_59300 = (state_59345[(2)]);
var state_59345__$1 = (function (){var statearr_59374 = state_59345;
(statearr_59374[(9)] = inst_59300);

return statearr_59374;
})();
if(cljs.core.truth_(inst_59274)){
var statearr_59375_59428 = state_59345__$1;
(statearr_59375_59428[(1)] = (17));

} else {
var statearr_59376_59429 = state_59345__$1;
(statearr_59376_59429[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59346 === (2))){
var _ = (function (){var statearr_59377 = state_59345;
(statearr_59377[(4)] = cljs.core.cons((5),(state_59345[(4)])));

return statearr_59377;
})();
var inst_59268 = fluree.db.session.db(conn,ledger,null);
var state_59345__$1 = state_59345;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59345__$1,(6),inst_59268);
} else {
if((state_val_59346 === (23))){
var inst_59306 = (state_59345[(2)]);
var inst_59307 = fluree.db.util.async.throw_err(inst_59306);
var state_59345__$1 = state_59345;
var statearr_59378_59430 = state_59345__$1;
(statearr_59378_59430[(2)] = inst_59307);

(statearr_59378_59430[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59346 === (35))){
var inst_59331 = (state_59345[(13)]);
var state_59345__$1 = state_59345;
var statearr_59379_59431 = state_59345__$1;
(statearr_59379_59431[(2)] = inst_59331);

(statearr_59379_59431[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59346 === (19))){
var inst_59312 = (state_59345[(10)]);
var inst_59312__$1 = (state_59345[(2)]);
var state_59345__$1 = (function (){var statearr_59380 = state_59345;
(statearr_59380[(10)] = inst_59312__$1);

return statearr_59380;
})();
if(cljs.core.truth_(inst_59312__$1)){
var statearr_59381_59432 = state_59345__$1;
(statearr_59381_59432[(1)] = (24));

} else {
var statearr_59382_59433 = state_59345__$1;
(statearr_59382_59433[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59346 === (11))){
var state_59345__$1 = state_59345;
var statearr_59384_59434 = state_59345__$1;
(statearr_59384_59434[(2)] = null);

(statearr_59384_59434[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59346 === (9))){
var inst_59282 = (state_59345[(2)]);
var state_59345__$1 = state_59345;
if(cljs.core.truth_(inst_59282)){
var statearr_59385_59435 = state_59345__$1;
(statearr_59385_59435[(1)] = (10));

} else {
var statearr_59386_59436 = state_59345__$1;
(statearr_59386_59436[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59346 === (5))){
var _ = (function (){var statearr_59387 = state_59345;
(statearr_59387[(4)] = cljs.core.rest((state_59345[(4)])));

return statearr_59387;
})();
var state_59345__$1 = state_59345;
var ex59383 = (state_59345__$1[(2)]);
var statearr_59388_59437 = state_59345__$1;
(statearr_59388_59437[(5)] = ex59383);


var statearr_59389_59438 = state_59345__$1;
(statearr_59389_59438[(1)] = (4));

(statearr_59389_59438[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59346 === (14))){
var inst_59287 = (state_59345[(14)]);
var state_59345__$1 = state_59345;
var statearr_59390_59439 = state_59345__$1;
(statearr_59390_59439[(2)] = inst_59287);

(statearr_59390_59439[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59346 === (26))){
var inst_59277 = (state_59345[(16)]);
var inst_59317 = (state_59345[(2)]);
var state_59345__$1 = (function (){var statearr_59391 = state_59345;
(statearr_59391[(18)] = inst_59317);

return statearr_59391;
})();
if(cljs.core.truth_(inst_59277)){
var statearr_59392_59440 = state_59345__$1;
(statearr_59392_59440[(1)] = (27));

} else {
var statearr_59393_59441 = state_59345__$1;
(statearr_59393_59441[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59346 === (16))){
var inst_59297 = (state_59345[(2)]);
var state_59345__$1 = state_59345;
var statearr_59394_59442 = state_59345__$1;
(statearr_59394_59442[(2)] = inst_59297);

(statearr_59394_59442[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59346 === (30))){
var inst_59322 = (state_59345[(2)]);
var inst_59323 = fluree.db.util.async.throw_err(inst_59322);
var state_59345__$1 = state_59345;
var statearr_59395_59443 = state_59345__$1;
(statearr_59395_59443[(2)] = inst_59323);

(statearr_59395_59443[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59346 === (10))){
var inst_59276 = (state_59345[(7)]);
var inst_59271 = (state_59345[(8)]);
var inst_59284 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_59271,inst_59276);
var state_59345__$1 = state_59345;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59345__$1,(13),inst_59284);
} else {
if((state_val_59346 === (18))){
var inst_59300 = (state_59345[(9)]);
var state_59345__$1 = state_59345;
if(cljs.core.truth_(inst_59300)){
var statearr_59396_59444 = state_59345__$1;
(statearr_59396_59444[(1)] = (20));

} else {
var statearr_59397_59445 = state_59345__$1;
(statearr_59397_59445[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59346 === (37))){
var inst_59331 = (state_59345[(13)]);
var inst_59334 = (state_59345[(2)]);
var inst_59335 = fluree.db.util.async.throw_err(inst_59334);
var inst_59336 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_59331,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_59335);
var state_59345__$1 = state_59345;
var statearr_59398_59446 = state_59345__$1;
(statearr_59398_59446[(2)] = inst_59336);

(statearr_59398_59446[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59346 === (8))){
var inst_59276 = (state_59345[(7)]);
var state_59345__$1 = state_59345;
var statearr_59399_59447 = state_59345__$1;
(statearr_59399_59447[(2)] = inst_59276);

(statearr_59399_59447[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__2717__auto__ = null;
var fluree$db$api$query$state_machine__2717__auto____0 = (function (){
var statearr_59400 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59400[(0)] = fluree$db$api$query$state_machine__2717__auto__);

(statearr_59400[(1)] = (1));

return statearr_59400;
});
var fluree$db$api$query$state_machine__2717__auto____1 = (function (state_59345){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_59345);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e59401){var ex__2720__auto__ = e59401;
var statearr_59402_59448 = state_59345;
(statearr_59402_59448[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_59345[(4)]))){
var statearr_59403_59449 = state_59345;
(statearr_59403_59449[(1)] = cljs.core.first((state_59345[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59450 = state_59345;
state_59345 = G__59450;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__2717__auto__ = function(state_59345){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__2717__auto____1.call(this,state_59345);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__2717__auto____0;
fluree$db$api$query$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__2717__auto____1;
return fluree$db$api$query$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_59404 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_59404[(6)] = c__2739__auto___59406);

return statearr_59404;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_(val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_59591){
var state_val_59592 = (state_59591[(1)]);
if((state_val_59592 === (7))){
var inst_59471 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59472 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_59473 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_59474 = [inst_59472,inst_59473];
var inst_59475 = (new cljs.core.PersistentVector(null,2,(5),inst_59471,inst_59474,null));
var state_59591__$1 = state_59591;
var statearr_59593_59663 = state_59591__$1;
(statearr_59593_59663[(2)] = inst_59475);

(statearr_59593_59663[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (20))){
var inst_59501 = (state_59591[(7)]);
var state_59591__$1 = state_59591;
var statearr_59594_59664 = state_59591__$1;
(statearr_59594_59664[(2)] = inst_59501);

(statearr_59594_59664[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (27))){
var state_59591__$1 = state_59591;
var statearr_59595_59665 = state_59591__$1;
(statearr_59595_59665[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (1))){
var state_59591__$1 = state_59591;
var statearr_59597_59666 = state_59591__$1;
(statearr_59597_59666[(2)] = null);

(statearr_59597_59666[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (24))){
var inst_59500 = (state_59591[(8)]);
var state_59591__$1 = state_59591;
if(cljs.core.truth_(inst_59500)){
var statearr_59598_59667 = state_59591__$1;
(statearr_59598_59667[(1)] = (26));

} else {
var statearr_59599_59668 = state_59591__$1;
(statearr_59599_59668[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (39))){
var inst_59546 = (state_59591[(9)]);
var inst_59547 = (state_59591[(10)]);
var inst_59572 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59573 = [inst_59546,inst_59547];
var inst_59574 = (new cljs.core.PersistentVector(null,2,(5),inst_59572,inst_59573,null));
var state_59591__$1 = state_59591;
var statearr_59600_59669 = state_59591__$1;
(statearr_59600_59669[(2)] = inst_59574);

(statearr_59600_59669[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (4))){
var inst_59451 = (state_59591[(2)]);
var state_59591__$1 = state_59591;
var statearr_59601_59670 = state_59591__$1;
(statearr_59601_59670[(2)] = inst_59451);

(statearr_59601_59670[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (15))){
var inst_59480 = (state_59591[(11)]);
var inst_59485 = (state_59591[(12)]);
var inst_59494 = (state_59591[(2)]);
var inst_59495 = [inst_59485,inst_59494];
var inst_59496 = (new cljs.core.PersistentVector(null,2,(5),inst_59480,inst_59495,null));
var state_59591__$1 = state_59591;
var statearr_59602_59671 = state_59591__$1;
(statearr_59602_59671[(2)] = inst_59496);

(statearr_59602_59671[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (21))){
var inst_59500 = (state_59591[(8)]);
var state_59591__$1 = state_59591;
var statearr_59603_59672 = state_59591__$1;
(statearr_59603_59672[(2)] = inst_59500);

(statearr_59603_59672[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (31))){
var inst_59541 = (state_59591[(2)]);
var state_59591__$1 = state_59591;
var statearr_59604_59673 = state_59591__$1;
(statearr_59604_59673[(2)] = inst_59541);

(statearr_59604_59673[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (32))){
var inst_59547 = (state_59591[(10)]);
var inst_59550 = cljs.core.pos_int_QMARK_(inst_59547);
var state_59591__$1 = state_59591;
var statearr_59605_59674 = state_59591__$1;
(statearr_59605_59674[(2)] = inst_59550);

(statearr_59605_59674[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (40))){
var inst_59502 = (state_59591[(13)]);
var inst_59578 = (state_59591[(14)]);
var inst_59576 = (state_59591[(2)]);
var inst_59577 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59576,(0),null);
var inst_59578__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59576,(1),null);
var inst_59579 = (inst_59578__$1 > inst_59502);
var state_59591__$1 = (function (){var statearr_59606 = state_59591;
(statearr_59606[(14)] = inst_59578__$1);

(statearr_59606[(15)] = inst_59577);

return statearr_59606;
})();
if(cljs.core.truth_(inst_59579)){
var statearr_59607_59675 = state_59591__$1;
(statearr_59607_59675[(1)] = (41));

} else {
var statearr_59608_59676 = state_59591__$1;
(statearr_59608_59676[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (33))){
var inst_59548 = (state_59591[(16)]);
var state_59591__$1 = state_59591;
var statearr_59609_59677 = state_59591__$1;
(statearr_59609_59677[(2)] = inst_59548);

(statearr_59609_59677[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (13))){
var inst_59486 = (state_59591[(17)]);
var inst_59488 = fluree.db.time_travel.block_to_int_format(db,inst_59486);
var state_59591__$1 = state_59591;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59591__$1,(16),inst_59488);
} else {
if((state_val_59592 === (22))){
var inst_59519 = (state_59591[(2)]);
var state_59591__$1 = state_59591;
if(cljs.core.truth_(inst_59519)){
var statearr_59610_59678 = state_59591__$1;
(statearr_59610_59678[(1)] = (23));

} else {
var statearr_59611_59679 = state_59591__$1;
(statearr_59611_59679[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (36))){
var state_59591__$1 = state_59591;
var statearr_59612_59680 = state_59591__$1;
(statearr_59612_59680[(2)] = null);

(statearr_59612_59680[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (41))){
var inst_59502 = (state_59591[(13)]);
var state_59591__$1 = state_59591;
var statearr_59613_59681 = state_59591__$1;
(statearr_59613_59681[(2)] = inst_59502);

(statearr_59613_59681[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (43))){
var inst_59577 = (state_59591[(15)]);
var inst_59583 = (state_59591[(2)]);
var inst_59584 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59585 = [inst_59577,inst_59583];
var inst_59586 = (new cljs.core.PersistentVector(null,2,(5),inst_59584,inst_59585,null));
var _ = (function (){var statearr_59614 = state_59591;
(statearr_59614[(4)] = cljs.core.rest((state_59591[(4)])));

return statearr_59614;
})();
var state_59591__$1 = state_59591;
var statearr_59615_59682 = state_59591__$1;
(statearr_59615_59682[(2)] = inst_59586);

(statearr_59615_59682[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (29))){
var inst_59477 = (state_59591[(18)]);
var inst_59532 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_59477], 0));
var inst_59533 = ["Invalid block range provided: ",inst_59532].join('');
var inst_59534 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59535 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_59536 = cljs.core.PersistentHashMap.fromArrays(inst_59534,inst_59535);
var inst_59537 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_59533,inst_59536);
var inst_59538 = (function(){throw inst_59537})();
var state_59591__$1 = state_59591;
var statearr_59616_59683 = state_59591__$1;
(statearr_59616_59683[(2)] = inst_59538);

(statearr_59616_59683[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (6))){
var inst_59469 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_59591__$1 = state_59591;
var statearr_59617_59684 = state_59591__$1;
(statearr_59617_59684[(2)] = inst_59469);

(statearr_59617_59684[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (28))){
var inst_59543 = (state_59591[(2)]);
var state_59591__$1 = state_59591;
var statearr_59618_59685 = state_59591__$1;
(statearr_59618_59685[(2)] = inst_59543);

(statearr_59618_59685[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (25))){
var inst_59548 = (state_59591[(16)]);
var inst_59546 = (state_59591[(9)]);
var inst_59545 = (state_59591[(2)]);
var inst_59546__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59545,(0),null);
var inst_59547 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59545,(1),null);
var inst_59548__$1 = cljs.core.pos_int_QMARK_(inst_59546__$1);
var state_59591__$1 = (function (){var statearr_59619 = state_59591;
(statearr_59619[(16)] = inst_59548__$1);

(statearr_59619[(9)] = inst_59546__$1);

(statearr_59619[(10)] = inst_59547);

return statearr_59619;
})();
if(inst_59548__$1){
var statearr_59620_59686 = state_59591__$1;
(statearr_59620_59686[(1)] = (32));

} else {
var statearr_59621_59687 = state_59591__$1;
(statearr_59621_59687[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (34))){
var inst_59553 = (state_59591[(2)]);
var inst_59554 = cljs.core.not(inst_59553);
var state_59591__$1 = state_59591;
if(inst_59554){
var statearr_59622_59688 = state_59591__$1;
(statearr_59622_59688[(1)] = (35));

} else {
var statearr_59623_59689 = state_59591__$1;
(statearr_59623_59689[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (17))){
var inst_59502 = (state_59591[(13)]);
var inst_59500 = (state_59591[(8)]);
var inst_59505 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_59500], 0));
var inst_59506 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_59502], 0));
var inst_59507 = ["Start block is out of range for this ledger. Start block provided: ",inst_59505,". Database block: ",inst_59506].join('');
var inst_59508 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59509 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_59510 = cljs.core.PersistentHashMap.fromArrays(inst_59508,inst_59509);
var inst_59511 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_59507,inst_59510);
var inst_59512 = (function(){throw inst_59511})();
var state_59591__$1 = state_59591;
var statearr_59624_59690 = state_59591__$1;
(statearr_59624_59690[(2)] = inst_59512);

(statearr_59624_59690[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (3))){
var inst_59589 = (state_59591[(2)]);
var state_59591__$1 = state_59591;
return cljs.core.async.impl.ioc_helpers.return_chan(state_59591__$1,inst_59589);
} else {
if((state_val_59592 === (12))){
var inst_59477 = (state_59591[(18)]);
var inst_59486 = (state_59591[(17)]);
var inst_59484 = (state_59591[(2)]);
var inst_59485 = fluree.db.util.async.throw_err(inst_59484);
var inst_59486__$1 = cljs.core.second(inst_59477);
var state_59591__$1 = (function (){var statearr_59625 = state_59591;
(statearr_59625[(17)] = inst_59486__$1);

(statearr_59625[(12)] = inst_59485);

return statearr_59625;
})();
if(cljs.core.truth_(inst_59486__$1)){
var statearr_59626_59691 = state_59591__$1;
(statearr_59626_59691[(1)] = (13));

} else {
var statearr_59627_59692 = state_59591__$1;
(statearr_59627_59692[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (2))){
var _ = (function (){var statearr_59628 = state_59591;
(statearr_59628[(4)] = cljs.core.cons((5),(state_59591[(4)])));

return statearr_59628;
})();
var inst_59466 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_59467 = cljs.core.sequential_QMARK_(inst_59466);
var state_59591__$1 = state_59591;
if(inst_59467){
var statearr_59629_59693 = state_59591__$1;
(statearr_59629_59693[(1)] = (6));

} else {
var statearr_59630_59694 = state_59591__$1;
(statearr_59630_59694[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (23))){
var inst_59501 = (state_59591[(7)]);
var inst_59500 = (state_59591[(8)]);
var inst_59521 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59522 = [inst_59500,inst_59501];
var inst_59523 = (new cljs.core.PersistentVector(null,2,(5),inst_59521,inst_59522,null));
var state_59591__$1 = state_59591;
var statearr_59631_59695 = state_59591__$1;
(statearr_59631_59695[(2)] = inst_59523);

(statearr_59631_59695[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (35))){
var inst_59477 = (state_59591[(18)]);
var inst_59556 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_59477], 0));
var inst_59557 = ["Invalid block range provided: ",inst_59556].join('');
var inst_59558 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59559 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_59560 = cljs.core.PersistentHashMap.fromArrays(inst_59558,inst_59559);
var inst_59561 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_59557,inst_59560);
var inst_59562 = (function(){throw inst_59561})();
var state_59591__$1 = state_59591;
var statearr_59632_59696 = state_59591__$1;
(statearr_59632_59696[(2)] = inst_59562);

(statearr_59632_59696[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (19))){
var inst_59500 = (state_59591[(8)]);
var inst_59515 = (state_59591[(2)]);
var state_59591__$1 = (function (){var statearr_59633 = state_59591;
(statearr_59633[(19)] = inst_59515);

return statearr_59633;
})();
if(cljs.core.truth_(inst_59500)){
var statearr_59634_59697 = state_59591__$1;
(statearr_59634_59697[(1)] = (20));

} else {
var statearr_59635_59698 = state_59591__$1;
(statearr_59635_59698[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (11))){
var inst_59502 = (state_59591[(13)]);
var inst_59500 = (state_59591[(8)]);
var inst_59499 = (state_59591[(2)]);
var inst_59500__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59499,(0),null);
var inst_59501 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59499,(1),null);
var inst_59502__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_59503 = (inst_59500__$1 > inst_59502__$1);
var state_59591__$1 = (function (){var statearr_59637 = state_59591;
(statearr_59637[(13)] = inst_59502__$1);

(statearr_59637[(7)] = inst_59501);

(statearr_59637[(8)] = inst_59500__$1);

return statearr_59637;
})();
if(cljs.core.truth_(inst_59503)){
var statearr_59638_59699 = state_59591__$1;
(statearr_59638_59699[(1)] = (17));

} else {
var statearr_59639_59700 = state_59591__$1;
(statearr_59639_59700[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (9))){
var inst_59477 = (state_59591[(18)]);
var inst_59480 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59481 = cljs.core.first(inst_59477);
var inst_59482 = fluree.db.time_travel.block_to_int_format(db,inst_59481);
var state_59591__$1 = (function (){var statearr_59640 = state_59591;
(statearr_59640[(11)] = inst_59480);

return statearr_59640;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59591__$1,(12),inst_59482);
} else {
if((state_val_59592 === (5))){
var _ = (function (){var statearr_59641 = state_59591;
(statearr_59641[(4)] = cljs.core.rest((state_59591[(4)])));

return statearr_59641;
})();
var state_59591__$1 = state_59591;
var ex59636 = (state_59591__$1[(2)]);
var statearr_59642_59701 = state_59591__$1;
(statearr_59642_59701[(5)] = ex59636);


if((ex59636 instanceof Error)){
var statearr_59643_59702 = state_59591__$1;
(statearr_59643_59702[(1)] = (4));

(statearr_59643_59702[(5)] = null);

} else {
throw ex59636;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (14))){
var state_59591__$1 = state_59591;
var statearr_59644_59703 = state_59591__$1;
(statearr_59644_59703[(2)] = null);

(statearr_59644_59703[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (26))){
var inst_59500 = (state_59591[(8)]);
var inst_59526 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59527 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_59528 = [inst_59500,inst_59527];
var inst_59529 = (new cljs.core.PersistentVector(null,2,(5),inst_59526,inst_59528,null));
var state_59591__$1 = state_59591;
var statearr_59645_59704 = state_59591__$1;
(statearr_59645_59704[(2)] = inst_59529);

(statearr_59645_59704[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (16))){
var inst_59490 = (state_59591[(2)]);
var inst_59491 = fluree.db.util.async.throw_err(inst_59490);
var state_59591__$1 = state_59591;
var statearr_59646_59705 = state_59591__$1;
(statearr_59646_59705[(2)] = inst_59491);

(statearr_59646_59705[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (38))){
var inst_59546 = (state_59591[(9)]);
var inst_59547 = (state_59591[(10)]);
var inst_59568 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59569 = [inst_59547,inst_59546];
var inst_59570 = (new cljs.core.PersistentVector(null,2,(5),inst_59568,inst_59569,null));
var state_59591__$1 = state_59591;
var statearr_59647_59706 = state_59591__$1;
(statearr_59647_59706[(2)] = inst_59570);

(statearr_59647_59706[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (30))){
var state_59591__$1 = state_59591;
var statearr_59648_59707 = state_59591__$1;
(statearr_59648_59707[(2)] = null);

(statearr_59648_59707[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (10))){
var inst_59477 = (state_59591[(18)]);
var state_59591__$1 = state_59591;
var statearr_59649_59708 = state_59591__$1;
(statearr_59649_59708[(2)] = inst_59477);

(statearr_59649_59708[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (18))){
var state_59591__$1 = state_59591;
var statearr_59650_59709 = state_59591__$1;
(statearr_59650_59709[(2)] = null);

(statearr_59650_59709[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (42))){
var inst_59578 = (state_59591[(14)]);
var state_59591__$1 = state_59591;
var statearr_59651_59710 = state_59591__$1;
(statearr_59651_59710[(2)] = inst_59578);

(statearr_59651_59710[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (37))){
var inst_59546 = (state_59591[(9)]);
var inst_59547 = (state_59591[(10)]);
var inst_59565 = (state_59591[(2)]);
var inst_59566 = (inst_59547 < inst_59546);
var state_59591__$1 = (function (){var statearr_59652 = state_59591;
(statearr_59652[(20)] = inst_59565);

return statearr_59652;
})();
if(cljs.core.truth_(inst_59566)){
var statearr_59653_59711 = state_59591__$1;
(statearr_59653_59711[(1)] = (38));

} else {
var statearr_59654_59712 = state_59591__$1;
(statearr_59654_59712[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59592 === (8))){
var inst_59477 = (state_59591[(18)]);
var inst_59477__$1 = (state_59591[(2)]);
var inst_59478 = cljs.core.some(cljs.core.string_QMARK_,inst_59477__$1);
var state_59591__$1 = (function (){var statearr_59655 = state_59591;
(statearr_59655[(18)] = inst_59477__$1);

return statearr_59655;
})();
if(cljs.core.truth_(inst_59478)){
var statearr_59656_59713 = state_59591__$1;
(statearr_59656_59713[(1)] = (9));

} else {
var statearr_59657_59714 = state_59591__$1;
(statearr_59657_59714[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__2717__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__2717__auto____0 = (function (){
var statearr_59658 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59658[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__2717__auto__);

(statearr_59658[(1)] = (1));

return statearr_59658;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__2717__auto____1 = (function (state_59591){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_59591);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e59659){var ex__2720__auto__ = e59659;
var statearr_59660_59715 = state_59591;
(statearr_59660_59715[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_59591[(4)]))){
var statearr_59661_59716 = state_59591;
(statearr_59661_59716[(1)] = cljs.core.first((state_59591[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59717 = state_59591;
state_59591 = G__59717;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__2717__auto__ = function(state_59591){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__2717__auto____1.call(this,state_59591);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__2717__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__2717__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_59662 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_59662[(6)] = c__2739__auto__);

return statearr_59662;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_59867){
var state_val_59868 = (state_59867[(1)]);
if((state_val_59868 === (7))){
var inst_59779 = (state_59867[(2)]);
var inst_59780 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59779,(0),null);
var inst_59781 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59779,(1),null);
var inst_59789 = cljs.core.vals(inst_59781);
var inst_59790 = cljs.core.seq(inst_59789);
var inst_59791 = cljs.core.first(inst_59790);
var inst_59792 = cljs.core.next(inst_59790);
var inst_59793 = cljs.core.PersistentVector.EMPTY;
var inst_59794 = inst_59789;
var inst_59795 = inst_59793;
var state_59867__$1 = (function (){var statearr_59869 = state_59867;
(statearr_59869[(7)] = inst_59780);

(statearr_59869[(8)] = inst_59794);

(statearr_59869[(9)] = inst_59795);

(statearr_59869[(10)] = inst_59791);

(statearr_59869[(11)] = inst_59792);

return statearr_59869;
})();
var statearr_59870_59923 = state_59867__$1;
(statearr_59870_59923[(2)] = null);

(statearr_59870_59923[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59868 === (20))){
var inst_59801 = (state_59867[(12)]);
var inst_59806 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_59807 = cljs.core.PersistentHashMap.EMPTY;
var inst_59808 = [true,inst_59807];
var inst_59809 = cljs.core.PersistentHashMap.fromArrays(inst_59806,inst_59808);
var inst_59810 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_59809,inst_59801);
var state_59867__$1 = state_59867;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59867__$1,(22),inst_59810);
} else {
if((state_val_59868 === (27))){
var inst_59855 = (state_59867[(2)]);
var state_59867__$1 = state_59867;
var statearr_59871_59924 = state_59867__$1;
(statearr_59871_59924[(2)] = inst_59855);

(statearr_59871_59924[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59868 === (1))){
var state_59867__$1 = state_59867;
var statearr_59872_59925 = state_59867__$1;
(statearr_59872_59925[(2)] = null);

(statearr_59872_59925[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59868 === (24))){
var inst_59819 = (state_59867[(13)]);
var inst_59857 = (state_59867[(2)]);
var inst_59858 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_59859 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_59860 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_59861 = [inst_59859,inst_59860,inst_59819,inst_59857];
var inst_59862 = cljs.core.PersistentHashMap.fromArrays(inst_59858,inst_59861);
var _ = (function (){var statearr_59874 = state_59867;
(statearr_59874[(4)] = cljs.core.rest((state_59867[(4)])));

return statearr_59874;
})();
var state_59867__$1 = state_59867;
var statearr_59875_59926 = state_59867__$1;
(statearr_59875_59926[(2)] = inst_59862);

(statearr_59875_59926[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59868 === (4))){
var inst_59720 = (state_59867[(2)]);
var state_59867__$1 = state_59867;
var statearr_59876_59927 = state_59867__$1;
(statearr_59876_59927[(2)] = inst_59720);

(statearr_59876_59927[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59868 === (15))){
var inst_59744 = (state_59867[(14)]);
var inst_59739 = (state_59867[(15)]);
var inst_59736 = (state_59867[(16)]);
var inst_59742 = (state_59867[(17)]);
var inst_59738 = (state_59867[(18)]);
var inst_59751 = (state_59867[(19)]);
var inst_59758 = (state_59867[(20)]);
var inst_59765 = (state_59867[(21)]);
var inst_59743 = (state_59867[(22)]);
var inst_59760 = (state_59867[(23)]);
var inst_59750 = (state_59867[(24)]);
var inst_59771 = (function (){var seq__59734 = inst_59739;
var vec__59733 = inst_59736;
var subject = inst_59758;
var flake = inst_59750;
var r = inst_59751;
var asserted_subjects = inst_59743;
var first__59748 = inst_59750;
var seq__59747 = inst_59751;
var flake_SINGLEQUOTE_ = inst_59765;
var retracted_subjects = inst_59744;
var first__59735 = inst_59738;
var asserted_QMARK_ = inst_59760;
var vec__59746 = inst_59742;
var G__59732 = inst_59742;
return (function (p1__59719_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__59719_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_59772 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_59744,inst_59758,inst_59771);
var tmp59873 = inst_59743;
var inst_59742__$1 = inst_59751;
var inst_59743__$1 = tmp59873;
var inst_59744__$1 = inst_59772;
var state_59867__$1 = (function (){var statearr_59877 = state_59867;
(statearr_59877[(14)] = inst_59744__$1);

(statearr_59877[(17)] = inst_59742__$1);

(statearr_59877[(22)] = inst_59743__$1);

return statearr_59877;
})();
var statearr_59878_59928 = state_59867__$1;
(statearr_59878_59928[(2)] = null);

(statearr_59878_59928[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59868 === (21))){
var inst_59817 = (state_59867[(2)]);
var state_59867__$1 = state_59867;
var statearr_59879_59929 = state_59867__$1;
(statearr_59879_59929[(2)] = inst_59817);

(statearr_59879_59929[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59868 === (13))){
var inst_59760 = (state_59867[(23)]);
var inst_59765 = (state_59867[(2)]);
var state_59867__$1 = (function (){var statearr_59880 = state_59867;
(statearr_59880[(21)] = inst_59765);

return statearr_59880;
})();
if(cljs.core.truth_(inst_59760)){
var statearr_59881_59930 = state_59867__$1;
(statearr_59881_59930[(1)] = (14));

} else {
var statearr_59882_59931 = state_59867__$1;
(statearr_59882_59931[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59868 === (22))){
var inst_59795 = (state_59867[(9)]);
var inst_59802 = (state_59867[(25)]);
var inst_59812 = (state_59867[(2)]);
var inst_59813 = fluree.db.util.async.throw_err(inst_59812);
var inst_59814 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_59795,inst_59813);
var inst_59794 = inst_59802;
var inst_59795__$1 = inst_59814;
var state_59867__$1 = (function (){var statearr_59883 = state_59867;
(statearr_59883[(8)] = inst_59794);

(statearr_59883[(9)] = inst_59795__$1);

return statearr_59883;
})();
var statearr_59884_59932 = state_59867__$1;
(statearr_59884_59932[(2)] = null);

(statearr_59884_59932[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59868 === (6))){
var inst_59742 = (state_59867[(17)]);
var inst_59750 = (state_59867[(24)]);
var inst_59749 = cljs.core.seq(inst_59742);
var inst_59750__$1 = cljs.core.first(inst_59749);
var inst_59751 = cljs.core.next(inst_59749);
var inst_59752 = cljs.core.not(inst_59750__$1);
var state_59867__$1 = (function (){var statearr_59885 = state_59867;
(statearr_59885[(19)] = inst_59751);

(statearr_59885[(24)] = inst_59750__$1);

return statearr_59885;
})();
if(inst_59752){
var statearr_59886_59933 = state_59867__$1;
(statearr_59886_59933[(1)] = (8));

} else {
var statearr_59887_59934 = state_59867__$1;
(statearr_59887_59934[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59868 === (28))){
var inst_59833 = (state_59867[(26)]);
var inst_59840 = (state_59867[(27)]);
var inst_59850 = (state_59867[(2)]);
var inst_59851 = fluree.db.util.async.throw_err(inst_59850);
var inst_59852 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_59833,inst_59851);
var inst_59832 = inst_59840;
var inst_59833__$1 = inst_59852;
var state_59867__$1 = (function (){var statearr_59888 = state_59867;
(statearr_59888[(28)] = inst_59832);

(statearr_59888[(26)] = inst_59833__$1);

return statearr_59888;
})();
var statearr_59889_59935 = state_59867__$1;
(statearr_59889_59935[(2)] = null);

(statearr_59889_59935[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59868 === (25))){
var inst_59833 = (state_59867[(26)]);
var state_59867__$1 = state_59867;
var statearr_59890_59936 = state_59867__$1;
(statearr_59890_59936[(2)] = inst_59833);

(statearr_59890_59936[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59868 === (17))){
var inst_59801 = (state_59867[(12)]);
var inst_59794 = (state_59867[(8)]);
var inst_59800 = cljs.core.seq(inst_59794);
var inst_59801__$1 = cljs.core.first(inst_59800);
var inst_59802 = cljs.core.next(inst_59800);
var inst_59803 = cljs.core.not(inst_59801__$1);
var state_59867__$1 = (function (){var statearr_59891 = state_59867;
(statearr_59891[(12)] = inst_59801__$1);

(statearr_59891[(25)] = inst_59802);

return statearr_59891;
})();
if(inst_59803){
var statearr_59892_59937 = state_59867__$1;
(statearr_59892_59937[(1)] = (19));

} else {
var statearr_59893_59938 = state_59867__$1;
(statearr_59893_59938[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59868 === (3))){
var inst_59865 = (state_59867[(2)]);
var state_59867__$1 = state_59867;
return cljs.core.async.impl.ioc_helpers.return_chan(state_59867__$1,inst_59865);
} else {
if((state_val_59868 === (12))){
var inst_59750 = (state_59867[(24)]);
var inst_59763 = fluree.db.flake.flip_flake.cljs$core$IFn$_invoke$arity$1(inst_59750);
var state_59867__$1 = state_59867;
var statearr_59894_59939 = state_59867__$1;
(statearr_59894_59939[(2)] = inst_59763);

(statearr_59894_59939[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59868 === (2))){
var inst_59736 = (state_59867[(16)]);
var _ = (function (){var statearr_59895 = state_59867;
(statearr_59895[(4)] = cljs.core.cons((5),(state_59867[(4)])));

return statearr_59895;
})();
var inst_59736__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_59737 = cljs.core.seq(inst_59736__$1);
var inst_59738 = cljs.core.first(inst_59737);
var inst_59739 = cljs.core.next(inst_59737);
var inst_59740 = cljs.core.PersistentHashMap.EMPTY;
var inst_59741 = cljs.core.PersistentHashMap.EMPTY;
var inst_59742 = inst_59736__$1;
var inst_59743 = inst_59740;
var inst_59744 = inst_59741;
var state_59867__$1 = (function (){var statearr_59896 = state_59867;
(statearr_59896[(14)] = inst_59744);

(statearr_59896[(15)] = inst_59739);

(statearr_59896[(16)] = inst_59736__$1);

(statearr_59896[(17)] = inst_59742);

(statearr_59896[(18)] = inst_59738);

(statearr_59896[(22)] = inst_59743);

return statearr_59896;
})();
var statearr_59897_59940 = state_59867__$1;
(statearr_59897_59940[(2)] = null);

(statearr_59897_59940[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59868 === (23))){
var inst_59832 = (state_59867[(28)]);
var inst_59839 = (state_59867[(29)]);
var inst_59838 = cljs.core.seq(inst_59832);
var inst_59839__$1 = cljs.core.first(inst_59838);
var inst_59840 = cljs.core.next(inst_59838);
var inst_59841 = cljs.core.not(inst_59839__$1);
var state_59867__$1 = (function (){var statearr_59898 = state_59867;
(statearr_59898[(27)] = inst_59840);

(statearr_59898[(29)] = inst_59839__$1);

return statearr_59898;
})();
if(inst_59841){
var statearr_59899_59941 = state_59867__$1;
(statearr_59899_59941[(1)] = (25));

} else {
var statearr_59900_59942 = state_59867__$1;
(statearr_59900_59942[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59868 === (19))){
var inst_59795 = (state_59867[(9)]);
var state_59867__$1 = state_59867;
var statearr_59901_59943 = state_59867__$1;
(statearr_59901_59943[(2)] = inst_59795);

(statearr_59901_59943[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59868 === (11))){
var inst_59750 = (state_59867[(24)]);
var state_59867__$1 = state_59867;
var statearr_59903_59944 = state_59867__$1;
(statearr_59903_59944[(2)] = inst_59750);

(statearr_59903_59944[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59868 === (9))){
var inst_59760 = (state_59867[(23)]);
var inst_59750 = (state_59867[(24)]);
var inst_59758 = inst_59750.s;
var inst_59759 = inst_59750.op;
var inst_59760__$1 = inst_59759 === true;
var state_59867__$1 = (function (){var statearr_59905 = state_59867;
(statearr_59905[(20)] = inst_59758);

(statearr_59905[(23)] = inst_59760__$1);

return statearr_59905;
})();
if(cljs.core.truth_(inst_59760__$1)){
var statearr_59906_59945 = state_59867__$1;
(statearr_59906_59945[(1)] = (11));

} else {
var statearr_59907_59946 = state_59867__$1;
(statearr_59907_59946[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59868 === (5))){
var _ = (function (){var statearr_59908 = state_59867;
(statearr_59908[(4)] = cljs.core.rest((state_59867[(4)])));

return statearr_59908;
})();
var state_59867__$1 = state_59867;
var ex59902 = (state_59867__$1[(2)]);
var statearr_59909_59947 = state_59867__$1;
(statearr_59909_59947[(5)] = ex59902);


if((ex59902 instanceof Error)){
var statearr_59910_59948 = state_59867__$1;
(statearr_59910_59948[(1)] = (4));

(statearr_59910_59948[(5)] = null);

} else {
throw ex59902;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59868 === (14))){
var inst_59744 = (state_59867[(14)]);
var inst_59739 = (state_59867[(15)]);
var inst_59736 = (state_59867[(16)]);
var inst_59742 = (state_59867[(17)]);
var inst_59738 = (state_59867[(18)]);
var inst_59751 = (state_59867[(19)]);
var inst_59758 = (state_59867[(20)]);
var inst_59765 = (state_59867[(21)]);
var inst_59743 = (state_59867[(22)]);
var inst_59760 = (state_59867[(23)]);
var inst_59750 = (state_59867[(24)]);
var inst_59767 = (function (){var seq__59734 = inst_59739;
var vec__59733 = inst_59736;
var subject = inst_59758;
var flake = inst_59750;
var r = inst_59751;
var asserted_subjects = inst_59743;
var first__59748 = inst_59750;
var seq__59747 = inst_59751;
var flake_SINGLEQUOTE_ = inst_59765;
var retracted_subjects = inst_59744;
var first__59735 = inst_59738;
var asserted_QMARK_ = inst_59760;
var vec__59746 = inst_59742;
var G__59732 = inst_59742;
return (function (p1__59718_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__59718_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_59768 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_59743,inst_59758,inst_59767);
var tmp59904 = inst_59744;
var inst_59742__$1 = inst_59751;
var inst_59743__$1 = inst_59768;
var inst_59744__$1 = tmp59904;
var state_59867__$1 = (function (){var statearr_59911 = state_59867;
(statearr_59911[(14)] = inst_59744__$1);

(statearr_59911[(17)] = inst_59742__$1);

(statearr_59911[(22)] = inst_59743__$1);

return statearr_59911;
})();
var statearr_59912_59949 = state_59867__$1;
(statearr_59912_59949[(2)] = null);

(statearr_59912_59949[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59868 === (26))){
var inst_59839 = (state_59867[(29)]);
var inst_59844 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_59845 = cljs.core.PersistentHashMap.EMPTY;
var inst_59846 = [true,inst_59845];
var inst_59847 = cljs.core.PersistentHashMap.fromArrays(inst_59844,inst_59846);
var inst_59848 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_59847,inst_59839);
var state_59867__$1 = state_59867;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59867__$1,(28),inst_59848);
} else {
if((state_val_59868 === (16))){
var inst_59775 = (state_59867[(2)]);
var state_59867__$1 = state_59867;
var statearr_59913_59950 = state_59867__$1;
(statearr_59913_59950[(2)] = inst_59775);

(statearr_59913_59950[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59868 === (10))){
var inst_59777 = (state_59867[(2)]);
var state_59867__$1 = state_59867;
var statearr_59914_59951 = state_59867__$1;
(statearr_59914_59951[(2)] = inst_59777);

(statearr_59914_59951[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59868 === (18))){
var inst_59780 = (state_59867[(7)]);
var inst_59819 = (state_59867[(2)]);
var inst_59827 = cljs.core.vals(inst_59780);
var inst_59828 = cljs.core.seq(inst_59827);
var inst_59829 = cljs.core.first(inst_59828);
var inst_59830 = cljs.core.next(inst_59828);
var inst_59831 = cljs.core.PersistentVector.EMPTY;
var inst_59832 = inst_59827;
var inst_59833 = inst_59831;
var state_59867__$1 = (function (){var statearr_59915 = state_59867;
(statearr_59915[(30)] = inst_59829);

(statearr_59915[(28)] = inst_59832);

(statearr_59915[(26)] = inst_59833);

(statearr_59915[(31)] = inst_59830);

(statearr_59915[(13)] = inst_59819);

return statearr_59915;
})();
var statearr_59916_59952 = state_59867__$1;
(statearr_59916_59952[(2)] = null);

(statearr_59916_59952[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59868 === (8))){
var inst_59744 = (state_59867[(14)]);
var inst_59743 = (state_59867[(22)]);
var inst_59754 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59755 = [inst_59743,inst_59744];
var inst_59756 = (new cljs.core.PersistentVector(null,2,(5),inst_59754,inst_59755,null));
var state_59867__$1 = state_59867;
var statearr_59917_59953 = state_59867__$1;
(statearr_59917_59953[(2)] = inst_59756);

(statearr_59917_59953[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2717__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2717__auto____0 = (function (){
var statearr_59918 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59918[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2717__auto__);

(statearr_59918[(1)] = (1));

return statearr_59918;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2717__auto____1 = (function (state_59867){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_59867);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e59919){var ex__2720__auto__ = e59919;
var statearr_59920_59954 = state_59867;
(statearr_59920_59954[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_59867[(4)]))){
var statearr_59921_59955 = state_59867;
(statearr_59921_59955[(1)] = cljs.core.first((state_59867[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59956 = state_59867;
state_59867 = G__59956;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2717__auto__ = function(state_59867){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2717__auto____1.call(this,state_59867);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2717__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2717__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_59922 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_59922[(6)] = c__2739__auto__);

return statearr_59922;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_59988){
var state_val_59989 = (state_59988[(1)]);
if((state_val_59989 === (1))){
var inst_59957 = cljs.core.volatile_BANG_((0));
var inst_59958 = cljs.core.PersistentHashMap.EMPTY;
var inst_59959 = cljs.core.volatile_BANG_(inst_59958);
var inst_59960 = cljs.core.first(resp);
var inst_59961 = cljs.core.rest(resp);
var inst_59962 = cljs.core.PersistentVector.EMPTY;
var inst_59963 = inst_59957;
var inst_59964 = inst_59959;
var inst_59965 = inst_59960;
var inst_59966 = inst_59961;
var inst_59967 = inst_59962;
var state_59988__$1 = (function (){var statearr_59990 = state_59988;
(statearr_59990[(7)] = inst_59966);

(statearr_59990[(8)] = inst_59964);

(statearr_59990[(9)] = inst_59967);

(statearr_59990[(10)] = inst_59963);

(statearr_59990[(11)] = inst_59965);

return statearr_59990;
})();
var statearr_59991_60006 = state_59988__$1;
(statearr_59991_60006[(2)] = null);

(statearr_59991_60006[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59989 === (2))){
var inst_59964 = (state_59988[(8)]);
var inst_59963 = (state_59988[(10)]);
var inst_59965 = (state_59988[(11)]);
var inst_59969 = fluree.db.api.query.format_block_resp_pretty(db,inst_59965,inst_59964,inst_59963);
var state_59988__$1 = state_59988;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59988__$1,(4),inst_59969);
} else {
if((state_val_59989 === (3))){
var inst_59986 = (state_59988[(2)]);
var state_59988__$1 = state_59988;
return cljs.core.async.impl.ioc_helpers.return_chan(state_59988__$1,inst_59986);
} else {
if((state_val_59989 === (4))){
var inst_59966 = (state_59988[(7)]);
var inst_59967 = (state_59988[(9)]);
var inst_59971 = (state_59988[(2)]);
var inst_59972 = fluree.db.util.async.throw_err(inst_59971);
var inst_59973 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59974 = [inst_59972];
var inst_59975 = (new cljs.core.PersistentVector(null,1,(5),inst_59973,inst_59974,null));
var inst_59976 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_59967,inst_59975);
var inst_59977 = cljs.core.first(inst_59966);
var state_59988__$1 = (function (){var statearr_59994 = state_59988;
(statearr_59994[(12)] = inst_59976);

return statearr_59994;
})();
if(cljs.core.truth_(inst_59977)){
var statearr_59995_60007 = state_59988__$1;
(statearr_59995_60007[(1)] = (5));

} else {
var statearr_59996_60008 = state_59988__$1;
(statearr_59996_60008[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59989 === (5))){
var inst_59966 = (state_59988[(7)]);
var inst_59964 = (state_59988[(8)]);
var inst_59963 = (state_59988[(10)]);
var inst_59976 = (state_59988[(12)]);
var inst_59979 = cljs.core.first(inst_59966);
var inst_59980 = cljs.core.rest(inst_59966);
var tmp59992 = inst_59964;
var tmp59993 = inst_59963;
var inst_59963__$1 = tmp59993;
var inst_59964__$1 = tmp59992;
var inst_59965 = inst_59979;
var inst_59966__$1 = inst_59980;
var inst_59967 = inst_59976;
var state_59988__$1 = (function (){var statearr_59997 = state_59988;
(statearr_59997[(7)] = inst_59966__$1);

(statearr_59997[(8)] = inst_59964__$1);

(statearr_59997[(9)] = inst_59967);

(statearr_59997[(10)] = inst_59963__$1);

(statearr_59997[(11)] = inst_59965);

return statearr_59997;
})();
var statearr_59998_60009 = state_59988__$1;
(statearr_59998_60009[(2)] = null);

(statearr_59998_60009[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59989 === (6))){
var inst_59976 = (state_59988[(12)]);
var state_59988__$1 = state_59988;
var statearr_59999_60010 = state_59988__$1;
(statearr_59999_60010[(2)] = inst_59976);

(statearr_59999_60010[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59989 === (7))){
var inst_59984 = (state_59988[(2)]);
var state_59988__$1 = state_59988;
var statearr_60000_60011 = state_59988__$1;
(statearr_60000_60011[(2)] = inst_59984);

(statearr_60000_60011[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2717__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2717__auto____0 = (function (){
var statearr_60001 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60001[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2717__auto__);

(statearr_60001[(1)] = (1));

return statearr_60001;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2717__auto____1 = (function (state_59988){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_59988);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e60002){var ex__2720__auto__ = e60002;
var statearr_60003_60012 = state_59988;
(statearr_60003_60012[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_59988[(4)]))){
var statearr_60004_60013 = state_59988;
(statearr_60004_60013[(1)] = cljs.core.first((state_59988[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60014 = state_59988;
state_59988 = G__60014;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2717__auto__ = function(state_59988){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2717__auto____1.call(this,state_59988);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2717__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2717__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_60005 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_60005[(6)] = c__2739__auto__);

return statearr_60005;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__60016 = arguments.length;
switch (G__60016) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range(db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__60018){
var map__60019 = p__60018;
var map__60019__$1 = cljs.core.__destructure_map(map__60019);
var query = map__60019__$1;
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60019__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_60104){
var state_val_60105 = (state_60104[(1)]);
if((state_val_60105 === (7))){
var inst_60030 = (state_60104[(7)]);
var inst_60034 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60035 = ["_auth/id",inst_60030];
var inst_60036 = (new cljs.core.PersistentVector(null,2,(5),inst_60034,inst_60035,null));
var state_60104__$1 = state_60104;
var statearr_60106_60150 = state_60104__$1;
(statearr_60106_60150[(2)] = inst_60036);

(statearr_60106_60150[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60105 === (20))){
var inst_60084 = (state_60104[(2)]);
var inst_60085 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_60104__$1 = (function (){var statearr_60107 = state_60104;
(statearr_60107[(8)] = inst_60084);

return statearr_60107;
})();
if(cljs.core.truth_(inst_60085)){
var statearr_60108_60151 = state_60104__$1;
(statearr_60108_60151[(1)] = (22));

} else {
var statearr_60109_60152 = state_60104__$1;
(statearr_60109_60152[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60105 === (27))){
var inst_60087 = (state_60104[(9)]);
var inst_60031 = (state_60104[(10)]);
var inst_60093 = (state_60104[(2)]);
var inst_60094 = fluree.db.util.core.response_time_formatted(inst_60031);
var inst_60095 = [(200),inst_60093,(100),inst_60094];
var inst_60096 = cljs.core.PersistentHashMap.fromArrays(inst_60087,inst_60095);
var state_60104__$1 = state_60104;
var statearr_60110_60153 = state_60104__$1;
(statearr_60110_60153[(2)] = inst_60096);

(statearr_60110_60153[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60105 === (1))){
var state_60104__$1 = state_60104;
var statearr_60111_60154 = state_60104__$1;
(statearr_60111_60154[(2)] = null);

(statearr_60111_60154[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60105 === (24))){
var inst_60099 = (state_60104[(2)]);
var _ = (function (){var statearr_60112 = state_60104;
(statearr_60112[(4)] = cljs.core.rest((state_60104[(4)])));

return statearr_60112;
})();
var state_60104__$1 = state_60104;
var statearr_60113_60155 = state_60104__$1;
(statearr_60113_60155[(2)] = inst_60099);

(statearr_60113_60155[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60105 === (4))){
var inst_60020 = (state_60104[(2)]);
var state_60104__$1 = state_60104;
var statearr_60114_60156 = state_60104__$1;
(statearr_60114_60156[(2)] = inst_60020);

(statearr_60114_60156[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60105 === (15))){
var inst_60071 = (state_60104[(11)]);
var state_60104__$1 = state_60104;
var statearr_60115_60157 = state_60104__$1;
(statearr_60115_60157[(2)] = inst_60071);

(statearr_60115_60157[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60105 === (21))){
var inst_60080 = (state_60104[(2)]);
var inst_60081 = fluree.db.util.async.throw_err(inst_60080);
var state_60104__$1 = state_60104;
var statearr_60116_60158 = state_60104__$1;
(statearr_60116_60158[(2)] = inst_60081);

(statearr_60116_60158[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60105 === (13))){
var inst_60029 = (state_60104[(12)]);
var inst_60071 = (state_60104[(11)]);
var inst_60070 = (state_60104[(2)]);
var inst_60071__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_60029);
var state_60104__$1 = (function (){var statearr_60117 = state_60104;
(statearr_60117[(11)] = inst_60071__$1);

(statearr_60117[(13)] = inst_60070);

return statearr_60117;
})();
if(cljs.core.truth_(inst_60071__$1)){
var statearr_60118_60159 = state_60104__$1;
(statearr_60118_60159[(1)] = (15));

} else {
var statearr_60119_60160 = state_60104__$1;
(statearr_60119_60160[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60105 === (22))){
var inst_60084 = (state_60104[(8)]);
var inst_60087 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_60088 = cljs.core.sequential_QMARK_(inst_60084);
var state_60104__$1 = (function (){var statearr_60120 = state_60104;
(statearr_60120[(9)] = inst_60087);

return statearr_60120;
})();
if(inst_60088){
var statearr_60121_60161 = state_60104__$1;
(statearr_60121_60161[(1)] = (25));

} else {
var statearr_60122_60162 = state_60104__$1;
(statearr_60122_60162[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60105 === (6))){
var inst_60029 = (state_60104[(12)]);
var inst_60045 = (state_60104[(14)]);
var inst_60044 = (state_60104[(2)]);
var inst_60045__$1 = fluree.db.util.async.throw_err(inst_60044);
var inst_60046 = fluree.db.api.query.resolve_block_range(inst_60045__$1,inst_60029);
var state_60104__$1 = (function (){var statearr_60123 = state_60104;
(statearr_60123[(14)] = inst_60045__$1);

return statearr_60123;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60104__$1,(10),inst_60046);
} else {
if((state_val_60105 === (25))){
var inst_60084 = (state_60104[(8)]);
var inst_60090 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_60084);
var state_60104__$1 = state_60104;
var statearr_60124_60163 = state_60104__$1;
(statearr_60124_60163[(2)] = inst_60090);

(statearr_60124_60163[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60105 === (17))){
var inst_60076 = (state_60104[(2)]);
var state_60104__$1 = state_60104;
if(cljs.core.truth_(inst_60076)){
var statearr_60125_60164 = state_60104__$1;
(statearr_60125_60164[(1)] = (18));

} else {
var statearr_60126_60165 = state_60104__$1;
(statearr_60126_60165[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60105 === (3))){
var inst_60102 = (state_60104[(2)]);
var state_60104__$1 = state_60104;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60104__$1,inst_60102);
} else {
if((state_val_60105 === (12))){
var inst_60029 = (state_60104[(12)]);
var inst_60062 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_60029], 0));
var inst_60063 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_60062].join('');
var inst_60064 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60065 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60066 = cljs.core.PersistentHashMap.fromArrays(inst_60064,inst_60065);
var inst_60067 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60063,inst_60066);
var inst_60068 = (function(){throw inst_60067})();
var state_60104__$1 = state_60104;
var statearr_60127_60166 = state_60104__$1;
(statearr_60127_60166[(2)] = inst_60068);

(statearr_60127_60166[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60105 === (2))){
var inst_60030 = (state_60104[(7)]);
var _ = (function (){var statearr_60128 = state_60104;
(statearr_60128[(4)] = cljs.core.cons((5),(state_60104[(4)])));

return statearr_60128;
})();
var inst_60029 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_60030__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_60031 = fluree.db.util.core.current_time_millis();
var inst_60032 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_60104__$1 = (function (){var statearr_60129 = state_60104;
(statearr_60129[(15)] = inst_60032);

(statearr_60129[(12)] = inst_60029);

(statearr_60129[(10)] = inst_60031);

(statearr_60129[(7)] = inst_60030__$1);

return statearr_60129;
})();
if(cljs.core.truth_(inst_60030__$1)){
var statearr_60130_60167 = state_60104__$1;
(statearr_60130_60167[(1)] = (7));

} else {
var statearr_60131_60168 = state_60104__$1;
(statearr_60131_60168[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60105 === (23))){
var inst_60084 = (state_60104[(8)]);
var state_60104__$1 = state_60104;
var statearr_60132_60169 = state_60104__$1;
(statearr_60132_60169[(2)] = inst_60084);

(statearr_60132_60169[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60105 === (19))){
var inst_60070 = (state_60104[(13)]);
var state_60104__$1 = state_60104;
var statearr_60133_60170 = state_60104__$1;
(statearr_60133_60170[(2)] = inst_60070);

(statearr_60133_60170[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60105 === (11))){
var inst_60051 = (state_60104[(16)]);
var inst_60050 = (state_60104[(17)]);
var inst_60045 = (state_60104[(14)]);
var inst_60057 = fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(inst_60045,inst_60050,inst_60051,opts);
var state_60104__$1 = state_60104;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60104__$1,(14),inst_60057);
} else {
if((state_val_60105 === (9))){
var inst_60032 = (state_60104[(15)]);
var inst_60039 = (state_60104[(2)]);
var inst_60040 = [inst_60039];
var inst_60041 = cljs.core.PersistentHashMap.fromArrays(inst_60032,inst_60040);
var inst_60042 = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,inst_60041);
var state_60104__$1 = state_60104;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60104__$1,(6),inst_60042);
} else {
if((state_val_60105 === (5))){
var _ = (function (){var statearr_60135 = state_60104;
(statearr_60135[(4)] = cljs.core.rest((state_60104[(4)])));

return statearr_60135;
})();
var state_60104__$1 = state_60104;
var ex60134 = (state_60104__$1[(2)]);
var statearr_60136_60171 = state_60104__$1;
(statearr_60136_60171[(5)] = ex60134);


if((ex60134 instanceof Error)){
var statearr_60137_60172 = state_60104__$1;
(statearr_60137_60172[(1)] = (4));

(statearr_60137_60172[(5)] = null);

} else {
throw ex60134;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60105 === (14))){
var inst_60059 = (state_60104[(2)]);
var inst_60060 = fluree.db.util.async.throw_err(inst_60059);
var state_60104__$1 = state_60104;
var statearr_60138_60173 = state_60104__$1;
(statearr_60138_60173[(2)] = inst_60060);

(statearr_60138_60173[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60105 === (26))){
var inst_60084 = (state_60104[(8)]);
var state_60104__$1 = state_60104;
var statearr_60139_60174 = state_60104__$1;
(statearr_60139_60174[(2)] = inst_60084);

(statearr_60139_60174[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60105 === (16))){
var inst_60029 = (state_60104[(12)]);
var inst_60074 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_60029);
var state_60104__$1 = state_60104;
var statearr_60140_60175 = state_60104__$1;
(statearr_60140_60175[(2)] = inst_60074);

(statearr_60140_60175[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60105 === (10))){
var inst_60029 = (state_60104[(12)]);
var inst_60048 = (state_60104[(2)]);
var inst_60049 = fluree.db.util.async.throw_err(inst_60048);
var inst_60050 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60049,(0),null);
var inst_60051 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60049,(1),null);
var inst_60052 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_60053 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(inst_60029,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803)], 0));
var inst_60054 = cljs.core.keys(inst_60053);
var inst_60055 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_60052,inst_60054);
var state_60104__$1 = (function (){var statearr_60141 = state_60104;
(statearr_60141[(16)] = inst_60051);

(statearr_60141[(17)] = inst_60050);

return statearr_60141;
})();
if(inst_60055){
var statearr_60142_60176 = state_60104__$1;
(statearr_60142_60176[(1)] = (11));

} else {
var statearr_60143_60177 = state_60104__$1;
(statearr_60143_60177[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60105 === (18))){
var inst_60045 = (state_60104[(14)]);
var inst_60070 = (state_60104[(13)]);
var inst_60078 = fluree.db.api.query.format_blocks_resp_pretty(inst_60045,inst_60070);
var state_60104__$1 = state_60104;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60104__$1,(21),inst_60078);
} else {
if((state_val_60105 === (8))){
var state_60104__$1 = state_60104;
var statearr_60144_60178 = state_60104__$1;
(statearr_60144_60178[(2)] = null);

(statearr_60144_60178[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__2717__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__2717__auto____0 = (function (){
var statearr_60145 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60145[(0)] = fluree$db$api$query$block_query_async_$_state_machine__2717__auto__);

(statearr_60145[(1)] = (1));

return statearr_60145;
});
var fluree$db$api$query$block_query_async_$_state_machine__2717__auto____1 = (function (state_60104){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_60104);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e60146){var ex__2720__auto__ = e60146;
var statearr_60147_60179 = state_60104;
(statearr_60147_60179[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_60104[(4)]))){
var statearr_60148_60180 = state_60104;
(statearr_60148_60180[(1)] = cljs.core.first((state_60104[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60181 = state_60104;
state_60104 = G__60181;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__2717__auto__ = function(state_60104){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__2717__auto____1.call(this,state_60104);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__2717__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__2717__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_60149 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_60149[(6)] = c__2739__auto__);

return statearr_60149;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_(history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_(history))?((cljs.core.empty_QMARK_(history))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__60182 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(0)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(1)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(2)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(3))], null);
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60182,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60182,(1),null);
var o = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60182,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60182,(3),null);
var vec__60185 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((((!((p == null)))) && ((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((((!((p == null)))) && ((!((o == null))))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60185,(0),null);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60185,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__60188 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [flake.t,new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60188,(0),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60188,(1),null);
var or__4212__auto__ = (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(auth) : auth_set.call(null,auth));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(id) : auth_set.call(null,id));
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__4824__auto__ = [];
var len__4818__auto___60192 = arguments.length;
var i__4819__auto___60193 = (0);
while(true){
if((i__4819__auto___60193 < len__4818__auto___60192)){
args__4824__auto__.push((arguments[i__4819__auto___60193]));

var G__60194 = (i__4819__auto___60193 + (1));
i__4819__auto___60193 = G__60194;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq60191){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq60191));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_60390){
var state_val_60391 = (state_60390[(1)]);
if((state_val_60391 === (7))){
var inst_60310 = (state_60390[(7)]);
var inst_60317 = (state_60390[(8)]);
var inst_60316 = cljs.core.seq(inst_60310);
var inst_60317__$1 = cljs.core.first(inst_60316);
var inst_60318 = cljs.core.next(inst_60316);
var state_60390__$1 = (function (){var statearr_60392 = state_60390;
(statearr_60392[(9)] = inst_60318);

(statearr_60392[(8)] = inst_60317__$1);

return statearr_60392;
})();
if(cljs.core.truth_(inst_60317__$1)){
var statearr_60393_60493 = state_60390__$1;
(statearr_60393_60493[(1)] = (9));

} else {
var statearr_60394_60494 = state_60390__$1;
(statearr_60394_60494[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60391 === (20))){
var inst_60380 = (state_60390[(2)]);
var state_60390__$1 = state_60390;
var statearr_60395_60495 = state_60390__$1;
(statearr_60395_60495[(2)] = inst_60380);

(statearr_60395_60495[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60391 === (27))){
var inst_60338 = (state_60390[(10)]);
var inst_60335 = (state_60390[(11)]);
var inst_60356 = (state_60390[(12)]);
var inst_60358 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60359 = [inst_60338,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_60360 = (new cljs.core.PersistentVector(null,2,(5),inst_60358,inst_60359,null));
var inst_60361 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_60356,inst_60360,fluree.db.api.query.min_safe,inst_60335);
var state_60390__$1 = state_60390;
var statearr_60396_60496 = state_60390__$1;
(statearr_60396_60496[(2)] = inst_60361);

(statearr_60396_60496[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60391 === (1))){
var state_60390__$1 = state_60390;
var statearr_60397_60497 = state_60390__$1;
(statearr_60397_60497[(2)] = null);

(statearr_60397_60497[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60391 === (24))){
var inst_60338 = (state_60390[(10)]);
var inst_60348 = (state_60390[(13)]);
var inst_60317 = (state_60390[(8)]);
var inst_60350 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60351 = [inst_60338,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_60352 = (new cljs.core.PersistentVector(null,2,(5),inst_60350,inst_60351,null));
var inst_60353 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_60348,inst_60352,cljs.core.conj,inst_60317);
var state_60390__$1 = state_60390;
var statearr_60399_60498 = state_60390__$1;
(statearr_60399_60498[(2)] = inst_60353);

(statearr_60399_60498[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60391 === (4))){
var inst_60196 = (state_60390[(2)]);
var state_60390__$1 = state_60390;
var statearr_60400_60499 = state_60390__$1;
(statearr_60400_60499[(2)] = inst_60196);

(statearr_60400_60499[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60391 === (15))){
var inst_60311 = (state_60390[(14)]);
var inst_60318 = (state_60390[(9)]);
var tmp60398 = inst_60311;
var inst_60310 = inst_60318;
var inst_60311__$1 = tmp60398;
var state_60390__$1 = (function (){var statearr_60401 = state_60390;
(statearr_60401[(7)] = inst_60310);

(statearr_60401[(14)] = inst_60311__$1);

return statearr_60401;
})();
var statearr_60402_60500 = state_60390__$1;
(statearr_60402_60500[(2)] = null);

(statearr_60402_60500[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60391 === (21))){
var inst_60338 = (state_60390[(10)]);
var inst_60311 = (state_60390[(14)]);
var inst_60342 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60343 = [inst_60338,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_60344 = (new cljs.core.PersistentVector(null,2,(5),inst_60342,inst_60343,null));
var inst_60345 = cljs.core.assoc_in(inst_60311,inst_60344,inst_60338);
var state_60390__$1 = state_60390;
var statearr_60403_60501 = state_60390__$1;
(statearr_60403_60501[(2)] = inst_60345);

(statearr_60403_60501[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60391 === (31))){
var inst_60364 = (state_60390[(15)]);
var state_60390__$1 = state_60390;
var statearr_60404_60502 = state_60390__$1;
(statearr_60404_60502[(2)] = inst_60364);

(statearr_60404_60502[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60391 === (32))){
var inst_60318 = (state_60390[(9)]);
var inst_60372 = (state_60390[(2)]);
var inst_60310 = inst_60318;
var inst_60311 = inst_60372;
var state_60390__$1 = (function (){var statearr_60405 = state_60390;
(statearr_60405[(7)] = inst_60310);

(statearr_60405[(14)] = inst_60311);

return statearr_60405;
})();
var statearr_60406_60503 = state_60390__$1;
(statearr_60406_60503[(2)] = null);

(statearr_60406_60503[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60391 === (33))){
var inst_60311 = (state_60390[(14)]);
var state_60390__$1 = state_60390;
var statearr_60407_60504 = state_60390__$1;
(statearr_60407_60504[(2)] = inst_60311);

(statearr_60407_60504[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60391 === (13))){
var inst_60320 = (state_60390[(16)]);
var state_60390__$1 = state_60390;
var statearr_60408_60505 = state_60390__$1;
(statearr_60408_60505[(2)] = inst_60320);

(statearr_60408_60505[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60391 === (22))){
var inst_60311 = (state_60390[(14)]);
var state_60390__$1 = state_60390;
var statearr_60409_60506 = state_60390__$1;
(statearr_60409_60506[(2)] = inst_60311);

(statearr_60409_60506[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60391 === (29))){
var inst_60364 = (state_60390[(2)]);
var state_60390__$1 = (function (){var statearr_60410 = state_60390;
(statearr_60410[(15)] = inst_60364);

return statearr_60410;
})();
if(cljs.core.truth_(show_auth)){
var statearr_60411_60507 = state_60390__$1;
(statearr_60411_60507[(1)] = (30));

} else {
var statearr_60412_60508 = state_60390__$1;
(statearr_60412_60508[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60391 === (6))){
var inst_60296 = (state_60390[(2)]);
var inst_60297 = fluree.db.util.async.throw_err(inst_60296);
var inst_60305 = resp;
var inst_60306 = cljs.core.seq(inst_60305);
var inst_60307 = cljs.core.first(inst_60306);
var inst_60308 = cljs.core.next(inst_60306);
var inst_60309 = cljs.core.PersistentHashMap.EMPTY;
var inst_60310 = inst_60305;
var inst_60311 = inst_60309;
var state_60390__$1 = (function (){var statearr_60413 = state_60390;
(statearr_60413[(7)] = inst_60310);

(statearr_60413[(17)] = inst_60297);

(statearr_60413[(18)] = inst_60307);

(statearr_60413[(14)] = inst_60311);

(statearr_60413[(19)] = inst_60308);

return statearr_60413;
})();
var statearr_60414_60509 = state_60390__$1;
(statearr_60414_60509[(2)] = null);

(statearr_60414_60509[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60391 === (28))){
var inst_60356 = (state_60390[(12)]);
var state_60390__$1 = state_60390;
var statearr_60415_60510 = state_60390__$1;
(statearr_60415_60510[(2)] = inst_60356);

(statearr_60415_60510[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60391 === (25))){
var inst_60348 = (state_60390[(13)]);
var state_60390__$1 = state_60390;
var statearr_60416_60511 = state_60390__$1;
(statearr_60416_60511[(2)] = inst_60348);

(statearr_60416_60511[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60391 === (34))){
var state_60390__$1 = state_60390;
var statearr_60417_60512 = state_60390__$1;
(statearr_60417_60512[(2)] = null);

(statearr_60417_60512[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60391 === (17))){
var inst_60382 = (state_60390[(2)]);
var state_60390__$1 = state_60390;
var statearr_60418_60513 = state_60390__$1;
(statearr_60418_60513[(2)] = inst_60382);

(statearr_60418_60513[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60391 === (3))){
var inst_60388 = (state_60390[(2)]);
var state_60390__$1 = state_60390;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60390__$1,inst_60388);
} else {
if((state_val_60391 === (12))){
var inst_60297 = (state_60390[(17)]);
var inst_60317 = (state_60390[(8)]);
var inst_60322 = fluree.db.api.query.auth_match(auth,inst_60297,inst_60317);
var inst_60323 = cljs.core.not(inst_60322);
var state_60390__$1 = state_60390;
var statearr_60419_60514 = state_60390__$1;
(statearr_60419_60514[(2)] = inst_60323);

(statearr_60419_60514[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60391 === (2))){
var _ = (function (){var statearr_60420 = state_60390;
(statearr_60420[(4)] = cljs.core.cons((5),(state_60390[(4)])));

return statearr_60420;
})();
var inst_60202 = (function (){return (function (p1__60195_SHARP_){
return p1__60195_SHARP_.t;
});
})();
var inst_60203 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_60202,resp);
var inst_60204 = cljs.core.set(inst_60203);
var inst_60292 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_60293 = (function (){var ts = inst_60204;
var c__2739__auto____$1 = inst_60292;
return (function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_60290){
var state_val_60291 = (state_60290[(1)]);
if((state_val_60291 === (7))){
var inst_60236 = (state_60290[(7)]);
var inst_60218 = (state_60290[(8)]);
var inst_60224 = (state_60290[(9)]);
var inst_60230 = (state_60290[(10)]);
var inst_60229 = (state_60290[(2)]);
var inst_60230__$1 = fluree.db.util.async.throw_err(inst_60229);
var inst_60232 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60233 = [inst_60224,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_60234 = (new cljs.core.PersistentVector(null,2,(5),inst_60232,inst_60233,null));
var inst_60235 = cljs.core.assoc_in(inst_60218,inst_60234,inst_60230__$1);
var inst_60236__$1 = auth;
var state_60290__$1 = (function (){var statearr_60421 = state_60290;
(statearr_60421[(11)] = inst_60235);

(statearr_60421[(7)] = inst_60236__$1);

(statearr_60421[(10)] = inst_60230__$1);

return statearr_60421;
})();
if(cljs.core.truth_(inst_60236__$1)){
var statearr_60422_60515 = state_60290__$1;
(statearr_60422_60515[(1)] = (8));

} else {
var statearr_60423_60516 = state_60290__$1;
(statearr_60423_60516[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60291 === (1))){
var inst_60212 = (state_60290[(12)]);
var inst_60212__$1 = ts;
var inst_60213 = cljs.core.seq(inst_60212__$1);
var inst_60214 = cljs.core.first(inst_60213);
var inst_60215 = cljs.core.next(inst_60213);
var inst_60216 = cljs.core.PersistentHashMap.EMPTY;
var inst_60217 = inst_60212__$1;
var inst_60218 = inst_60216;
var state_60290__$1 = (function (){var statearr_60424 = state_60290;
(statearr_60424[(13)] = inst_60215);

(statearr_60424[(14)] = inst_60217);

(statearr_60424[(8)] = inst_60218);

(statearr_60424[(15)] = inst_60214);

(statearr_60424[(12)] = inst_60212__$1);

return statearr_60424;
})();
var statearr_60425_60517 = state_60290__$1;
(statearr_60425_60517[(2)] = null);

(statearr_60425_60517[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60291 === (4))){
var inst_60224 = (state_60290[(9)]);
var inst_60227 = fluree.db.time_travel.non_border_t_to_block(db,inst_60224);
var state_60290__$1 = state_60290;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60290__$1,(7),inst_60227);
} else {
if((state_val_60291 === (13))){
var inst_60225 = (state_60290[(16)]);
var inst_60282 = (state_60290[(2)]);
var inst_60217 = inst_60225;
var inst_60218 = inst_60282;
var state_60290__$1 = (function (){var statearr_60426 = state_60290;
(statearr_60426[(14)] = inst_60217);

(statearr_60426[(8)] = inst_60218);

return statearr_60426;
})();
var statearr_60427_60518 = state_60290__$1;
(statearr_60427_60518[(2)] = null);

(statearr_60427_60518[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60291 === (6))){
var inst_60286 = (state_60290[(2)]);
var state_60290__$1 = state_60290;
var statearr_60428_60519 = state_60290__$1;
(statearr_60428_60519[(2)] = inst_60286);

(statearr_60428_60519[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60291 === (3))){
var inst_60288 = (state_60290[(2)]);
var state_60290__$1 = state_60290;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60290__$1,inst_60288);
} else {
if((state_val_60291 === (12))){
var inst_60235 = (state_60290[(11)]);
var state_60290__$1 = state_60290;
var statearr_60429_60520 = state_60290__$1;
(statearr_60429_60520[(2)] = inst_60235);

(statearr_60429_60520[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60291 === (2))){
var inst_60217 = (state_60290[(14)]);
var inst_60224 = (state_60290[(9)]);
var inst_60223 = cljs.core.seq(inst_60217);
var inst_60224__$1 = cljs.core.first(inst_60223);
var inst_60225 = cljs.core.next(inst_60223);
var state_60290__$1 = (function (){var statearr_60430 = state_60290;
(statearr_60430[(16)] = inst_60225);

(statearr_60430[(9)] = inst_60224__$1);

return statearr_60430;
})();
if(cljs.core.truth_(inst_60224__$1)){
var statearr_60431_60521 = state_60290__$1;
(statearr_60431_60521[(1)] = (4));

} else {
var statearr_60432_60522 = state_60290__$1;
(statearr_60432_60522[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60291 === (11))){
var inst_60235 = (state_60290[(11)]);
var inst_60215 = (state_60290[(13)]);
var inst_60217 = (state_60290[(14)]);
var inst_60218 = (state_60290[(8)]);
var inst_60225 = (state_60290[(16)]);
var inst_60214 = (state_60290[(15)]);
var inst_60224 = (state_60290[(9)]);
var inst_60230 = (state_60290[(10)]);
var inst_60212 = (state_60290[(12)]);
var inst_60242 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60243 = [inst_60224,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_60244 = (new cljs.core.PersistentVector(null,2,(5),inst_60242,inst_60243,null));
var inst_60257 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_60258 = (function (){var t = inst_60224;
var first__60222 = inst_60224;
var seq__60210 = inst_60215;
var vec__60209 = inst_60212;
var block = inst_60230;
var r = inst_60225;
var vec__60220 = inst_60217;
var acc = inst_60218;
var G__60231 = inst_60235;
var c__2739__auto____$2 = inst_60257;
var G__60208 = inst_60217;
var seq__60221 = inst_60225;
var first__60211 = inst_60214;
return (function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_60255){
var state_val_60256 = (state_60255[(1)]);
if((state_val_60256 === (1))){
var state_60255__$1 = state_60255;
var statearr_60433_60523 = state_60255__$1;
(statearr_60433_60523[(2)] = null);

(statearr_60433_60523[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60256 === (2))){
var ___$1 = (function (){var statearr_60434 = state_60255;
(statearr_60434[(4)] = cljs.core.cons((5),(state_60255[(4)])));

return statearr_60434;
})();
var ___$2 = (function (){var statearr_60435 = state_60255;
(statearr_60435[(4)] = cljs.core.rest((state_60255[(4)])));

return statearr_60435;
})();
var state_60255__$1 = state_60255;
var statearr_60436_60524 = state_60255__$1;
(statearr_60436_60524[(2)] = db);

(statearr_60436_60524[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60256 === (3))){
var inst_60253 = (state_60255[(2)]);
var state_60255__$1 = state_60255;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60255__$1,inst_60253);
} else {
if((state_val_60256 === (4))){
var inst_60245 = (state_60255[(2)]);
var state_60255__$1 = state_60255;
var statearr_60438_60525 = state_60255__$1;
(statearr_60438_60525[(2)] = inst_60245);

(statearr_60438_60525[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60256 === (5))){
var ___$1 = (function (){var statearr_60439 = state_60255;
(statearr_60439[(4)] = cljs.core.rest((state_60255[(4)])));

return statearr_60439;
})();
var state_60255__$1 = state_60255;
var ex60437 = (state_60255__$1[(2)]);
var statearr_60440_60526 = state_60255__$1;
(statearr_60440_60526[(5)] = ex60437);


if((ex60437 instanceof Error)){
var statearr_60441_60527 = state_60255__$1;
(statearr_60441_60527[(1)] = (4));

(statearr_60441_60527[(5)] = null);

} else {
throw ex60437;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2717__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2717__auto____0 = (function (){
var statearr_60442 = [null,null,null,null,null,null,null];
(statearr_60442[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2717__auto__);

(statearr_60442[(1)] = (1));

return statearr_60442;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2717__auto____1 = (function (state_60255){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_60255);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e60443){var ex__2720__auto__ = e60443;
var statearr_60444_60528 = state_60255;
(statearr_60444_60528[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_60255[(4)]))){
var statearr_60445_60529 = state_60255;
(statearr_60445_60529[(1)] = cljs.core.first((state_60255[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60530 = state_60255;
state_60255 = G__60530;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2717__auto__ = function(state_60255){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2717__auto____1.call(this,state_60255);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2717__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2717__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_60446 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_60446[(6)] = c__2739__auto____$2);

return statearr_60446;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
});
})();
var inst_60259 = cljs.core.async.impl.dispatch.run(inst_60258);
var inst_60260 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_60261 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60262 = ["?auth","?id"];
var inst_60263 = (new cljs.core.PersistentVector(null,2,(5),inst_60261,inst_60262,null));
var inst_60264 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60265 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60266 = [inst_60224,"_tx/auth","?auth"];
var inst_60267 = (new cljs.core.PersistentVector(null,3,(5),inst_60265,inst_60266,null));
var inst_60268 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60269 = ["?auth","_auth/id","?id"];
var inst_60270 = (new cljs.core.PersistentVector(null,3,(5),inst_60268,inst_60269,null));
var inst_60271 = [inst_60267,inst_60270];
var inst_60272 = (new cljs.core.PersistentVector(null,2,(5),inst_60264,inst_60271,null));
var inst_60273 = [inst_60263,inst_60272];
var inst_60274 = cljs.core.PersistentHashMap.fromArrays(inst_60260,inst_60273);
var inst_60275 = (fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2(inst_60257,inst_60274) : fluree.db.api.query.query_async.call(null,inst_60257,inst_60274));
var state_60290__$1 = (function (){var statearr_60447 = state_60290;
(statearr_60447[(17)] = inst_60244);

(statearr_60447[(18)] = inst_60259);

return statearr_60447;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60290__$1,(14),inst_60275);
} else {
if((state_val_60291 === (9))){
var state_60290__$1 = state_60290;
var statearr_60448_60531 = state_60290__$1;
(statearr_60448_60531[(2)] = show_auth);

(statearr_60448_60531[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60291 === (5))){
var inst_60218 = (state_60290[(8)]);
var state_60290__$1 = state_60290;
var statearr_60449_60532 = state_60290__$1;
(statearr_60449_60532[(2)] = inst_60218);

(statearr_60449_60532[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60291 === (14))){
var inst_60244 = (state_60290[(17)]);
var inst_60235 = (state_60290[(11)]);
var inst_60277 = (state_60290[(2)]);
var inst_60278 = fluree.db.util.async.throw_err(inst_60277);
var inst_60279 = cljs.core.assoc_in(inst_60235,inst_60244,inst_60278);
var state_60290__$1 = state_60290;
var statearr_60450_60533 = state_60290__$1;
(statearr_60450_60533[(2)] = inst_60279);

(statearr_60450_60533[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60291 === (10))){
var inst_60240 = (state_60290[(2)]);
var state_60290__$1 = state_60290;
if(cljs.core.truth_(inst_60240)){
var statearr_60451_60534 = state_60290__$1;
(statearr_60451_60534[(1)] = (11));

} else {
var statearr_60452_60535 = state_60290__$1;
(statearr_60452_60535[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60291 === (8))){
var inst_60236 = (state_60290[(7)]);
var state_60290__$1 = state_60290;
var statearr_60453_60536 = state_60290__$1;
(statearr_60453_60536[(2)] = inst_60236);

(statearr_60453_60536[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2717__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2717__auto____0 = (function (){
var statearr_60454 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60454[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2717__auto__);

(statearr_60454[(1)] = (1));

return statearr_60454;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2717__auto____1 = (function (state_60290){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_60290);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e60455){var ex__2720__auto__ = e60455;
var statearr_60456_60537 = state_60290;
(statearr_60456_60537[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_60290[(4)]))){
var statearr_60457_60538 = state_60290;
(statearr_60457_60538[(1)] = cljs.core.first((state_60290[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60539 = state_60290;
state_60290 = G__60539;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2717__auto__ = function(state_60290){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2717__auto____1.call(this,state_60290);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2717__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2717__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_60458 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_60458[(6)] = c__2739__auto____$1);

return statearr_60458;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
});
})();
var inst_60294 = cljs.core.async.impl.dispatch.run(inst_60293);
var state_60390__$1 = (function (){var statearr_60459 = state_60390;
(statearr_60459[(20)] = inst_60294);

return statearr_60459;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60390__$1,(6),inst_60292);
} else {
if((state_val_60391 === (23))){
var inst_60348 = (state_60390[(2)]);
var state_60390__$1 = (function (){var statearr_60460 = state_60390;
(statearr_60460[(13)] = inst_60348);

return statearr_60460;
})();
var statearr_60461_60540 = state_60390__$1;
(statearr_60461_60540[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60391 === (35))){
var inst_60378 = (state_60390[(2)]);
var state_60390__$1 = state_60390;
var statearr_60463_60541 = state_60390__$1;
(statearr_60463_60541[(2)] = inst_60378);

(statearr_60463_60541[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60391 === (19))){
var state_60390__$1 = state_60390;
var statearr_60464_60542 = state_60390__$1;
(statearr_60464_60542[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60391 === (11))){
var inst_60329 = (state_60390[(2)]);
var state_60390__$1 = state_60390;
if(cljs.core.truth_(inst_60329)){
var statearr_60467_60543 = state_60390__$1;
(statearr_60467_60543[(1)] = (15));

} else {
var statearr_60468_60544 = state_60390__$1;
(statearr_60468_60544[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60391 === (9))){
var inst_60320 = (state_60390[(16)]);
var inst_60320__$1 = auth;
var state_60390__$1 = (function (){var statearr_60469 = state_60390;
(statearr_60469[(16)] = inst_60320__$1);

return statearr_60469;
})();
if(cljs.core.truth_(inst_60320__$1)){
var statearr_60470_60545 = state_60390__$1;
(statearr_60470_60545[(1)] = (12));

} else {
var statearr_60471_60546 = state_60390__$1;
(statearr_60471_60546[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60391 === (5))){
var _ = (function (){var statearr_60472 = state_60390;
(statearr_60472[(4)] = cljs.core.rest((state_60390[(4)])));

return statearr_60472;
})();
var state_60390__$1 = state_60390;
var ex60466 = (state_60390__$1[(2)]);
var statearr_60473_60547 = state_60390__$1;
(statearr_60473_60547[(5)] = ex60466);


if((ex60466 instanceof Error)){
var statearr_60474_60548 = state_60390__$1;
(statearr_60474_60548[(1)] = (4));

(statearr_60474_60548[(5)] = null);

} else {
throw ex60466;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60391 === (14))){
var inst_60326 = (state_60390[(2)]);
var state_60390__$1 = state_60390;
var statearr_60475_60549 = state_60390__$1;
(statearr_60475_60549[(2)] = inst_60326);

(statearr_60475_60549[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60391 === (26))){
var inst_60356 = (state_60390[(2)]);
var state_60390__$1 = (function (){var statearr_60476 = state_60390;
(statearr_60476[(12)] = inst_60356);

return statearr_60476;
})();
var statearr_60477_60550 = state_60390__$1;
(statearr_60477_60550[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60391 === (16))){
var inst_60317 = (state_60390[(8)]);
var state_60390__$1 = state_60390;
if(cljs.core.truth_(inst_60317)){
var statearr_60479_60551 = state_60390__$1;
(statearr_60479_60551[(1)] = (18));

} else {
var statearr_60480_60552 = state_60390__$1;
(statearr_60480_60552[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60391 === (30))){
var inst_60339 = (state_60390[(21)]);
var inst_60338 = (state_60390[(10)]);
var inst_60364 = (state_60390[(15)]);
var inst_60366 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60367 = [inst_60338,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_60368 = (new cljs.core.PersistentVector(null,2,(5),inst_60366,inst_60367,null));
var inst_60369 = cljs.core.assoc_in(inst_60364,inst_60368,inst_60339);
var state_60390__$1 = state_60390;
var statearr_60481_60553 = state_60390__$1;
(statearr_60481_60553[(2)] = inst_60369);

(statearr_60481_60553[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60391 === (10))){
var inst_60317 = (state_60390[(8)]);
var state_60390__$1 = state_60390;
var statearr_60482_60554 = state_60390__$1;
(statearr_60482_60554[(2)] = inst_60317);

(statearr_60482_60554[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60391 === (18))){
var inst_60297 = (state_60390[(17)]);
var inst_60335 = (state_60390[(11)]);
var inst_60317 = (state_60390[(8)]);
var inst_60335__$1 = inst_60317.t;
var inst_60336 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60297,inst_60335__$1);
var inst_60337 = cljs.core.__destructure_map(inst_60336);
var inst_60338 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60337,new cljs.core.Keyword(null,"block","block",664686210));
var inst_60339 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60337,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_60390__$1 = (function (){var statearr_60483 = state_60390;
(statearr_60483[(21)] = inst_60339);

(statearr_60483[(10)] = inst_60338);

(statearr_60483[(11)] = inst_60335__$1);

return statearr_60483;
})();
var statearr_60484_60555 = state_60390__$1;
(statearr_60484_60555[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60391 === (8))){
var inst_60384 = (state_60390[(2)]);
var inst_60385 = cljs.core.vals(inst_60384);
var _ = (function (){var statearr_60486 = state_60390;
(statearr_60486[(4)] = cljs.core.rest((state_60390[(4)])));

return statearr_60486;
})();
var state_60390__$1 = state_60390;
var statearr_60487_60556 = state_60390__$1;
(statearr_60487_60556[(2)] = inst_60385);

(statearr_60487_60556[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2717__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2717__auto____0 = (function (){
var statearr_60488 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60488[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2717__auto__);

(statearr_60488[(1)] = (1));

return statearr_60488;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2717__auto____1 = (function (state_60390){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_60390);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e60489){var ex__2720__auto__ = e60489;
var statearr_60490_60557 = state_60390;
(statearr_60490_60557[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_60390[(4)]))){
var statearr_60491_60558 = state_60390;
(statearr_60491_60558[(1)] = cljs.core.first((state_60390[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60559 = state_60390;
state_60390 = G__60559;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2717__auto__ = function(state_60390){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2717__auto____1.call(this,state_60390);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2717__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2717__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_60492 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_60492[(6)] = c__2739__auto__);

return statearr_60492;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Convert flakes into vectors.
 *   Notes:
 *   Cannot use IPrintWithWriter override since calls to storage-handler
 *   download blocks using the #Flake format to support internal query
 *   handling.
 */
fluree.db.api.query.block_Flakes__GT_vector = (function fluree$db$api$query$block_Flakes__GT_vector(blocks){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (block){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(block,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.vec,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block)));
}),blocks);
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_60686){
var state_val_60687 = (state_60686[(1)]);
if((state_val_60687 === (7))){
var inst_60582 = (state_60686[(7)]);
var inst_60584 = fluree.db.api.query.resolve_block_range(inst_60582,query_map);
var state_60686__$1 = state_60686;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60686__$1,(10),inst_60584);
} else {
if((state_val_60687 === (20))){
var inst_60611 = (state_60686[(2)]);
var inst_60612 = fluree.db.util.async.throw_err(inst_60611);
var inst_60613 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_60612);
var inst_60614 = (inst_60613 - (1));
var state_60686__$1 = state_60686;
var statearr_60688_60751 = state_60686__$1;
(statearr_60688_60751[(2)] = inst_60614);

(statearr_60688_60751[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60687 === (27))){
var state_60686__$1 = state_60686;
var statearr_60689_60752 = state_60686__$1;
(statearr_60689_60752[(2)] = null);

(statearr_60689_60752[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60687 === (1))){
var state_60686__$1 = state_60686;
var statearr_60690_60753 = state_60686__$1;
(statearr_60690_60753[(2)] = null);

(statearr_60690_60753[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60687 === (24))){
var inst_60621 = (state_60686[(2)]);
var inst_60622 = fluree.db.util.async.throw_err(inst_60621);
var inst_60623 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_60622);
var state_60686__$1 = state_60686;
var statearr_60691_60754 = state_60686__$1;
(statearr_60691_60754[(2)] = inst_60623);

(statearr_60691_60754[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60687 === (39))){
var inst_60658 = (state_60686[(2)]);
var inst_60659 = fluree.db.util.async.throw_err(inst_60658);
var state_60686__$1 = state_60686;
var statearr_60692_60755 = state_60686__$1;
(statearr_60692_60755[(2)] = inst_60659);

(statearr_60692_60755[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60687 === (4))){
var inst_60560 = (state_60686[(2)]);
var state_60686__$1 = state_60686;
var statearr_60693_60756 = state_60686__$1;
(statearr_60693_60756[(2)] = inst_60560);

(statearr_60693_60756[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60687 === (15))){
var inst_60591 = (state_60686[(8)]);
var state_60686__$1 = state_60686;
var statearr_60694_60757 = state_60686__$1;
(statearr_60694_60757[(2)] = inst_60591);

(statearr_60694_60757[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60687 === (21))){
var inst_60592 = (state_60686[(9)]);
var inst_60582 = (state_60686[(7)]);
var inst_60619 = fluree.db.time_travel.as_of_block(inst_60582,inst_60592);
var state_60686__$1 = state_60686;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60686__$1,(24),inst_60619);
} else {
if((state_val_60687 === (31))){
var inst_60576 = (state_60686[(10)]);
var state_60686__$1 = state_60686;
var statearr_60695_60758 = state_60686__$1;
(statearr_60695_60758[(2)] = inst_60576);

(statearr_60695_60758[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60687 === (32))){
var inst_60637 = (state_60686[(11)]);
var inst_60642 = (state_60686[(12)]);
var inst_60582 = (state_60686[(7)]);
var inst_60646 = (state_60686[(2)]);
var inst_60647 = fluree.db.api.query.format_history_resp(inst_60582,inst_60637,inst_60642,inst_60646);
var state_60686__$1 = state_60686;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60686__$1,(29),inst_60647);
} else {
if((state_val_60687 === (40))){
var inst_60637 = (state_60686[(11)]);
var inst_60663 = (state_60686[(13)]);
var inst_60665 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_60666 = cljs.core.count(inst_60637);
var inst_60667 = [inst_60663,inst_60666,(200)];
var inst_60668 = cljs.core.PersistentHashMap.fromArrays(inst_60665,inst_60667);
var state_60686__$1 = state_60686;
var statearr_60696_60759 = state_60686__$1;
(statearr_60696_60759[(2)] = inst_60668);

(statearr_60696_60759[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60687 === (33))){
var inst_60575 = (state_60686[(14)]);
var state_60686__$1 = state_60686;
var statearr_60697_60760 = state_60686__$1;
(statearr_60697_60760[(2)] = inst_60575);

(statearr_60697_60760[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60687 === (13))){
var inst_60681 = (state_60686[(2)]);
var _ = (function (){var statearr_60698 = state_60686;
(statearr_60698[(4)] = cljs.core.rest((state_60686[(4)])));

return statearr_60698;
})();
var state_60686__$1 = state_60686;
var statearr_60699_60761 = state_60686__$1;
(statearr_60699_60761[(2)] = inst_60681);

(statearr_60699_60761[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60687 === (22))){
var inst_60582 = (state_60686[(7)]);
var inst_60625 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_60582);
var state_60686__$1 = state_60686;
var statearr_60700_60762 = state_60686__$1;
(statearr_60700_60762[(2)] = inst_60625);

(statearr_60700_60762[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60687 === (36))){
var inst_60650 = (state_60686[(15)]);
var inst_60582 = (state_60686[(7)]);
var inst_60656 = fluree.db.api.query.format_blocks_resp_pretty(inst_60582,inst_60650);
var state_60686__$1 = state_60686;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60686__$1,(39),inst_60656);
} else {
if((state_val_60687 === (41))){
var inst_60663 = (state_60686[(13)]);
var state_60686__$1 = state_60686;
var statearr_60701_60763 = state_60686__$1;
(statearr_60701_60763[(2)] = inst_60663);

(statearr_60701_60763[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60687 === (29))){
var inst_60575 = (state_60686[(14)]);
var inst_60649 = (state_60686[(2)]);
var inst_60650 = fluree.db.util.async.throw_err(inst_60649);
var state_60686__$1 = (function (){var statearr_60702 = state_60686;
(statearr_60702[(15)] = inst_60650);

return statearr_60702;
})();
if(cljs.core.truth_(inst_60575)){
var statearr_60703_60764 = state_60686__$1;
(statearr_60703_60764[(1)] = (33));

} else {
var statearr_60704_60765 = state_60686__$1;
(statearr_60704_60765[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60687 === (6))){
var inst_60572 = (state_60686[(16)]);
var inst_60581 = (state_60686[(2)]);
var inst_60582 = fluree.db.util.async.throw_err(inst_60581);
var state_60686__$1 = (function (){var statearr_60705 = state_60686;
(statearr_60705[(7)] = inst_60582);

return statearr_60705;
})();
if(cljs.core.truth_(inst_60572)){
var statearr_60706_60766 = state_60686__$1;
(statearr_60706_60766[(1)] = (7));

} else {
var statearr_60707_60767 = state_60686__$1;
(statearr_60707_60767[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60687 === (28))){
var inst_60577 = (state_60686[(17)]);
var inst_60642 = (state_60686[(2)]);
var state_60686__$1 = (function (){var statearr_60708 = state_60686;
(statearr_60708[(12)] = inst_60642);

return statearr_60708;
})();
if(cljs.core.truth_(inst_60577)){
var statearr_60709_60768 = state_60686__$1;
(statearr_60709_60768[(1)] = (30));

} else {
var statearr_60710_60769 = state_60686__$1;
(statearr_60710_60769[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60687 === (25))){
var inst_60578 = (state_60686[(18)]);
var inst_60636 = (state_60686[(2)]);
var inst_60637 = fluree.db.util.async.throw_err(inst_60636);
var state_60686__$1 = (function (){var statearr_60711 = state_60686;
(statearr_60711[(11)] = inst_60637);

return statearr_60711;
})();
if(cljs.core.truth_(inst_60578)){
var statearr_60712_60770 = state_60686__$1;
(statearr_60712_60770[(1)] = (26));

} else {
var statearr_60713_60771 = state_60686__$1;
(statearr_60713_60771[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60687 === (34))){
var inst_60574 = (state_60686[(19)]);
var state_60686__$1 = state_60686;
var statearr_60714_60772 = state_60686__$1;
(statearr_60714_60772[(2)] = inst_60574);

(statearr_60714_60772[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60687 === (17))){
var inst_60591 = (state_60686[(8)]);
var inst_60582 = (state_60686[(7)]);
var inst_60608 = (inst_60591 - (1));
var inst_60609 = fluree.db.time_travel.as_of_block(inst_60582,inst_60608);
var state_60686__$1 = state_60686;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60686__$1,(20),inst_60609);
} else {
if((state_val_60687 === (3))){
var inst_60684 = (state_60686[(2)]);
var state_60686__$1 = state_60686;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60686__$1,inst_60684);
} else {
if((state_val_60687 === (12))){
var inst_60673 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_60674 = ["History query not properly formatted. Provided ",inst_60673].join('');
var inst_60675 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60676 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60677 = cljs.core.PersistentHashMap.fromArrays(inst_60675,inst_60676);
var inst_60678 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60674,inst_60677);
var inst_60679 = (function(){throw inst_60678})();
var state_60686__$1 = state_60686;
var statearr_60715_60773 = state_60686__$1;
(statearr_60715_60773[(2)] = inst_60679);

(statearr_60715_60773[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60687 === (2))){
var _ = (function (){var statearr_60716 = state_60686;
(statearr_60716[(4)] = cljs.core.cons((5),(state_60686[(4)])));

return statearr_60716;
})();
var inst_60570 = query_map;
var inst_60571 = cljs.core.__destructure_map(inst_60570);
var inst_60572 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60571,new cljs.core.Keyword(null,"block","block",664686210));
var inst_60573 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60571,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_60574 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60571,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_60575 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60571,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_60576 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60571,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_60577 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60571,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_60578 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60571,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_60579 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60571,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_60686__$1 = (function (){var statearr_60717 = state_60686;
(statearr_60717[(17)] = inst_60577);

(statearr_60717[(14)] = inst_60575);

(statearr_60717[(20)] = inst_60579);

(statearr_60717[(18)] = inst_60578);

(statearr_60717[(10)] = inst_60576);

(statearr_60717[(16)] = inst_60572);

(statearr_60717[(19)] = inst_60574);

(statearr_60717[(21)] = inst_60573);

return statearr_60717;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60686__$1,(6),sources);
} else {
if((state_val_60687 === (23))){
var inst_60617 = (state_60686[(22)]);
var inst_60573 = (state_60686[(21)]);
var inst_60582 = (state_60686[(7)]);
var inst_60627 = (state_60686[(2)]);
var inst_60628 = fluree.db.api.query.get_history_pattern(inst_60573);
var inst_60629 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60628,(0),null);
var inst_60630 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60628,(1),null);
var inst_60631 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_60632 = [inst_60617,inst_60627];
var inst_60633 = cljs.core.PersistentHashMap.fromArrays(inst_60631,inst_60632);
var inst_60634 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_60582,inst_60630,cljs.core._EQ_,inst_60629,inst_60633);
var state_60686__$1 = state_60686;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60686__$1,(25),inst_60634);
} else {
if((state_val_60687 === (35))){
var inst_60654 = (state_60686[(2)]);
var state_60686__$1 = state_60686;
if(cljs.core.truth_(inst_60654)){
var statearr_60718_60774 = state_60686__$1;
(statearr_60718_60774[(1)] = (36));

} else {
var statearr_60719_60775 = state_60686__$1;
(statearr_60719_60775[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60687 === (19))){
var inst_60592 = (state_60686[(9)]);
var inst_60617 = (state_60686[(2)]);
var state_60686__$1 = (function (){var statearr_60720 = state_60686;
(statearr_60720[(22)] = inst_60617);

return statearr_60720;
})();
if(cljs.core.truth_(inst_60592)){
var statearr_60721_60776 = state_60686__$1;
(statearr_60721_60776[(1)] = (21));

} else {
var statearr_60722_60777 = state_60686__$1;
(statearr_60722_60777[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60687 === (11))){
var inst_60579 = (state_60686[(20)]);
var inst_60591 = (state_60686[(8)]);
var inst_60601 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_60579);
var state_60686__$1 = (function (){var statearr_60724 = state_60686;
(statearr_60724[(23)] = inst_60601);

return statearr_60724;
})();
if(cljs.core.truth_(inst_60591)){
var statearr_60725_60778 = state_60686__$1;
(statearr_60725_60778[(1)] = (14));

} else {
var statearr_60726_60779 = state_60686__$1;
(statearr_60726_60779[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60687 === (9))){
var inst_60590 = (state_60686[(2)]);
var inst_60591 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60590,(0),null);
var inst_60592 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60590,(1),null);
var inst_60593 = cljs.core.list(new cljs.core.Keyword(null,"history","history",-247395220));
var inst_60594 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(query_map,new cljs.core.Keyword(null,"block","block",664686210),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"show-auth","show-auth",686103141),new cljs.core.Keyword(null,"showAuth","showAuth",-347871529),new cljs.core.Keyword(null,"opts","opts",155075701)], 0));
var inst_60595 = cljs.core.keys(inst_60594);
var inst_60596 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_60593,inst_60595);
var state_60686__$1 = (function (){var statearr_60727 = state_60686;
(statearr_60727[(8)] = inst_60591);

(statearr_60727[(9)] = inst_60592);

return statearr_60727;
})();
if(inst_60596){
var statearr_60728_60780 = state_60686__$1;
(statearr_60728_60780[(1)] = (11));

} else {
var statearr_60729_60781 = state_60686__$1;
(statearr_60729_60781[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60687 === (5))){
var _ = (function (){var statearr_60730 = state_60686;
(statearr_60730[(4)] = cljs.core.rest((state_60686[(4)])));

return statearr_60730;
})();
var state_60686__$1 = state_60686;
var ex60723 = (state_60686__$1[(2)]);
var statearr_60731_60782 = state_60686__$1;
(statearr_60731_60782[(5)] = ex60723);


if((ex60723 instanceof Error)){
var statearr_60732_60783 = state_60686__$1;
(statearr_60732_60783[(1)] = (4));

(statearr_60732_60783[(5)] = null);

} else {
throw ex60723;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60687 === (14))){
var inst_60591 = (state_60686[(8)]);
var inst_60603 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_60591);
var state_60686__$1 = state_60686;
var statearr_60733_60784 = state_60686__$1;
(statearr_60733_60784[(2)] = inst_60603);

(statearr_60733_60784[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60687 === (26))){
var inst_60578 = (state_60686[(18)]);
var inst_60639 = cljs.core.set(inst_60578);
var state_60686__$1 = state_60686;
var statearr_60734_60785 = state_60686__$1;
(statearr_60734_60785[(2)] = inst_60639);

(statearr_60734_60785[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60687 === (16))){
var inst_60606 = (state_60686[(2)]);
var state_60686__$1 = state_60686;
if(cljs.core.truth_(inst_60606)){
var statearr_60735_60786 = state_60686__$1;
(statearr_60735_60786[(1)] = (17));

} else {
var statearr_60736_60787 = state_60686__$1;
(statearr_60736_60787[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60687 === (38))){
var inst_60601 = (state_60686[(23)]);
var inst_60663 = (state_60686[(2)]);
var state_60686__$1 = (function (){var statearr_60737 = state_60686;
(statearr_60737[(13)] = inst_60663);

return statearr_60737;
})();
if(cljs.core.truth_(inst_60601)){
var statearr_60738_60788 = state_60686__$1;
(statearr_60738_60788[(1)] = (40));

} else {
var statearr_60739_60789 = state_60686__$1;
(statearr_60739_60789[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60687 === (30))){
var inst_60577 = (state_60686[(17)]);
var state_60686__$1 = state_60686;
var statearr_60740_60790 = state_60686__$1;
(statearr_60740_60790[(2)] = inst_60577);

(statearr_60740_60790[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60687 === (10))){
var inst_60586 = (state_60686[(2)]);
var inst_60587 = fluree.db.util.async.throw_err(inst_60586);
var state_60686__$1 = state_60686;
var statearr_60741_60791 = state_60686__$1;
(statearr_60741_60791[(2)] = inst_60587);

(statearr_60741_60791[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60687 === (18))){
var state_60686__$1 = state_60686;
var statearr_60742_60792 = state_60686__$1;
(statearr_60742_60792[(2)] = (-1));

(statearr_60742_60792[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60687 === (42))){
var inst_60671 = (state_60686[(2)]);
var state_60686__$1 = state_60686;
var statearr_60743_60793 = state_60686__$1;
(statearr_60743_60793[(2)] = inst_60671);

(statearr_60743_60793[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60687 === (37))){
var inst_60650 = (state_60686[(15)]);
var inst_60661 = fluree.db.api.query.block_Flakes__GT_vector(inst_60650);
var state_60686__$1 = state_60686;
var statearr_60744_60794 = state_60686__$1;
(statearr_60744_60794[(2)] = inst_60661);

(statearr_60744_60794[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60687 === (8))){
var state_60686__$1 = state_60686;
var statearr_60745_60795 = state_60686__$1;
(statearr_60745_60795[(2)] = null);

(statearr_60745_60795[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__2717__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__2717__auto____0 = (function (){
var statearr_60746 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60746[(0)] = fluree$db$api$query$history_query_async_$_state_machine__2717__auto__);

(statearr_60746[(1)] = (1));

return statearr_60746;
});
var fluree$db$api$query$history_query_async_$_state_machine__2717__auto____1 = (function (state_60686){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_60686);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e60747){var ex__2720__auto__ = e60747;
var statearr_60748_60796 = state_60686;
(statearr_60748_60796[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_60686[(4)]))){
var statearr_60749_60797 = state_60686;
(statearr_60749_60797[(1)] = cljs.core.first((state_60686[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60798 = state_60686;
state_60686 = G__60798;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__2717__auto__ = function(state_60686){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__2717__auto____1.call(this,state_60686);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__2717__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__2717__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_60750 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_60750[(6)] = c__2739__auto__);

return statearr_60750;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_60931){
var state_val_60932 = (state_60931[(1)]);
if((state_val_60932 === (7))){
var inst_60828 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flureeQL], 0));
var inst_60829 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_60828].join('');
var inst_60830 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60831 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60832 = cljs.core.PersistentHashMap.fromArrays(inst_60830,inst_60831);
var inst_60833 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60829,inst_60832);
var inst_60834 = (function(){throw inst_60833})();
var state_60931__$1 = state_60931;
var statearr_60933_61012 = state_60931__$1;
(statearr_60933_61012[(2)] = inst_60834);

(statearr_60933_61012[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (20))){
var inst_60866 = (state_60931[(2)]);
var state_60931__$1 = state_60931;
if(cljs.core.truth_(inst_60866)){
var statearr_60934_61013 = state_60931__$1;
(statearr_60934_61013[(1)] = (21));

} else {
var statearr_60935_61014 = state_60931__$1;
(statearr_60935_61014[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (27))){
var inst_60810 = (state_60931[(7)]);
var state_60931__$1 = state_60931;
var statearr_60936_61015 = state_60931__$1;
(statearr_60936_61015[(2)] = inst_60810);

(statearr_60936_61015[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (1))){
var state_60931__$1 = state_60931;
var statearr_60937_61016 = state_60931__$1;
(statearr_60937_61016[(2)] = null);

(statearr_60937_61016[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (24))){
var inst_60872 = (state_60931[(8)]);
var state_60931__$1 = state_60931;
var statearr_60938_61017 = state_60931__$1;
(statearr_60938_61017[(2)] = inst_60872);

(statearr_60938_61017[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (39))){
var inst_60816 = (state_60931[(9)]);
var state_60931__$1 = state_60931;
if(cljs.core.truth_(inst_60816)){
var statearr_60939_61018 = state_60931__$1;
(statearr_60939_61018[(1)] = (42));

} else {
var statearr_60940_61019 = state_60931__$1;
(statearr_60940_61019[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (46))){
var inst_60904 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60905 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60906 = cljs.core.PersistentHashMap.fromArrays(inst_60904,inst_60905);
var inst_60907 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid query.",inst_60906);
var inst_60908 = (function(){throw inst_60907})();
var state_60931__$1 = state_60931;
var statearr_60941_61020 = state_60931__$1;
(statearr_60941_61020[(2)] = inst_60908);

(statearr_60941_61020[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (4))){
var inst_60800 = (state_60931[(2)]);
var state_60931__$1 = state_60931;
var statearr_60942_61021 = state_60931__$1;
(statearr_60942_61021[(2)] = inst_60800);

(statearr_60942_61021[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (15))){
var inst_60813 = (state_60931[(10)]);
var inst_60851 = (state_60931[(11)]);
var inst_60853 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_60851);
var inst_60854 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_60851);
var inst_60855 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_60851);
var inst_60856 = fluree.db.api.query.get_sources(inst_60853,inst_60854,inst_60855,inst_60813);
var state_60931__$1 = state_60931;
var statearr_60943_61022 = state_60931__$1;
(statearr_60943_61022[(2)] = inst_60856);

(statearr_60943_61022[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (48))){
var inst_60861 = (state_60931[(12)]);
var inst_60915 = (state_60931[(2)]);
var inst_60916 = fluree.db.util.async.throw_err(inst_60915);
var state_60931__$1 = (function (){var statearr_60944 = state_60931;
(statearr_60944[(13)] = inst_60916);

return statearr_60944;
})();
if(cljs.core.truth_(inst_60861)){
var statearr_60945_61023 = state_60931__$1;
(statearr_60945_61023[(1)] = (49));

} else {
var statearr_60946_61024 = state_60931__$1;
(statearr_60946_61024[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (50))){
var inst_60916 = (state_60931[(13)]);
var state_60931__$1 = state_60931;
var statearr_60947_61025 = state_60931__$1;
(statearr_60947_61025[(2)] = inst_60916);

(statearr_60947_61025[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (21))){
var inst_60868 = cljs.core.volatile_BANG_((0));
var state_60931__$1 = state_60931;
var statearr_60948_61026 = state_60931__$1;
(statearr_60948_61026[(2)] = inst_60868);

(statearr_60948_61026[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (31))){
var inst_60814 = (state_60931[(14)]);
var state_60931__$1 = state_60931;
if(cljs.core.truth_(inst_60814)){
var statearr_60949_61027 = state_60931__$1;
(statearr_60949_61027[(1)] = (33));

} else {
var statearr_60950_61028 = state_60931__$1;
(statearr_60950_61028[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (32))){
var inst_60891 = (state_60931[(2)]);
var state_60931__$1 = state_60931;
var statearr_60951_61029 = state_60931__$1;
(statearr_60951_61029[(2)] = inst_60891);

(statearr_60951_61029[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (40))){
var inst_60893 = (state_60931[(15)]);
var state_60931__$1 = state_60931;
var statearr_60952_61030 = state_60931__$1;
(statearr_60952_61030[(2)] = inst_60893);

(statearr_60952_61030[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (33))){
var inst_60814 = (state_60931[(14)]);
var state_60931__$1 = state_60931;
var statearr_60953_61031 = state_60931__$1;
(statearr_60953_61031[(2)] = inst_60814);

(statearr_60953_61031[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (13))){
var inst_60811 = (state_60931[(16)]);
var inst_60840 = (state_60931[(2)]);
var inst_60841 = fluree.db.util.async.throw_err(inst_60840);
var inst_60842 = fluree.db.time_travel.as_of_block(inst_60841,inst_60811);
var state_60931__$1 = state_60931;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60931__$1,(12),inst_60842);
} else {
if((state_val_60932 === (22))){
var state_60931__$1 = state_60931;
var statearr_60954_61032 = state_60931__$1;
(statearr_60954_61032[(2)] = null);

(statearr_60954_61032[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (36))){
var inst_60818 = (state_60931[(17)]);
var state_60931__$1 = state_60931;
var statearr_60955_61033 = state_60931__$1;
(statearr_60955_61033[(2)] = inst_60818);

(statearr_60955_61033[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (41))){
var inst_60901 = (state_60931[(2)]);
var state_60931__$1 = state_60931;
if(cljs.core.truth_(inst_60901)){
var statearr_60956_61034 = state_60931__$1;
(statearr_60956_61034[(1)] = (45));

} else {
var statearr_60957_61035 = state_60931__$1;
(statearr_60957_61035[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (43))){
var inst_60812 = (state_60931[(18)]);
var state_60931__$1 = state_60931;
var statearr_60958_61036 = state_60931__$1;
(statearr_60958_61036[(2)] = inst_60812);

(statearr_60958_61036[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (29))){
var inst_60893 = (state_60931[(15)]);
var inst_60893__$1 = (state_60931[(2)]);
var state_60931__$1 = (function (){var statearr_60959 = state_60931;
(statearr_60959[(15)] = inst_60893__$1);

return statearr_60959;
})();
if(cljs.core.truth_(inst_60893__$1)){
var statearr_60960_61037 = state_60931__$1;
(statearr_60960_61037[(1)] = (39));

} else {
var statearr_60961_61038 = state_60931__$1;
(statearr_60961_61038[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (44))){
var inst_60898 = (state_60931[(2)]);
var state_60931__$1 = state_60931;
var statearr_60962_61039 = state_60931__$1;
(statearr_60962_61039[(2)] = inst_60898);

(statearr_60962_61039[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (6))){
var state_60931__$1 = state_60931;
var statearr_60963_61040 = state_60931__$1;
(statearr_60963_61040[(2)] = null);

(statearr_60963_61040[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (28))){
var inst_60815 = (state_60931[(19)]);
var state_60931__$1 = state_60931;
if(cljs.core.truth_(inst_60815)){
var statearr_60964_61041 = state_60931__$1;
(statearr_60964_61041[(1)] = (30));

} else {
var statearr_60965_61042 = state_60931__$1;
(statearr_60965_61042[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (51))){
var inst_60926 = (state_60931[(2)]);
var _ = (function (){var statearr_60966 = state_60931;
(statearr_60966[(4)] = cljs.core.rest((state_60931[(4)])));

return statearr_60966;
})();
var state_60931__$1 = state_60931;
var statearr_60967_61043 = state_60931__$1;
(statearr_60967_61043[(2)] = inst_60926);

(statearr_60967_61043[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (25))){
var state_60931__$1 = state_60931;
var statearr_60968_61044 = state_60931__$1;
(statearr_60968_61044[(2)] = (1000000));

(statearr_60968_61044[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (34))){
var inst_60818 = (state_60931[(17)]);
var state_60931__$1 = state_60931;
if(cljs.core.truth_(inst_60818)){
var statearr_60969_61045 = state_60931__$1;
(statearr_60969_61045[(1)] = (36));

} else {
var statearr_60970_61046 = state_60931__$1;
(statearr_60970_61046[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (17))){
var inst_60817 = (state_60931[(20)]);
var inst_60862 = (state_60931[(21)]);
var inst_60860 = (state_60931[(2)]);
var inst_60861 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_60817);
var inst_60862__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_60817);
var state_60931__$1 = (function (){var statearr_60971 = state_60931;
(statearr_60971[(21)] = inst_60862__$1);

(statearr_60971[(12)] = inst_60861);

(statearr_60971[(22)] = inst_60860);

return statearr_60971;
})();
if(cljs.core.truth_(inst_60862__$1)){
var statearr_60972_61047 = state_60931__$1;
(statearr_60972_61047[(1)] = (18));

} else {
var statearr_60973_61048 = state_60931__$1;
(statearr_60973_61048[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (3))){
var inst_60929 = (state_60931[(2)]);
var state_60931__$1 = state_60931;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60931__$1,inst_60929);
} else {
if((state_val_60932 === (12))){
var inst_60844 = (state_60931[(2)]);
var inst_60845 = fluree.db.util.async.throw_err(inst_60844);
var state_60931__$1 = state_60931;
var statearr_60974_61049 = state_60931__$1;
(statearr_60974_61049[(2)] = inst_60845);

(statearr_60974_61049[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (2))){
var inst_60812 = (state_60931[(18)]);
var inst_60817 = (state_60931[(20)]);
var inst_60816 = (state_60931[(9)]);
var inst_60815 = (state_60931[(19)]);
var inst_60813 = (state_60931[(10)]);
var inst_60809 = (state_60931[(23)]);
var inst_60811 = (state_60931[(16)]);
var inst_60810 = (state_60931[(7)]);
var inst_60818 = (state_60931[(17)]);
var inst_60814 = (state_60931[(14)]);
var _ = (function (){var statearr_60975 = state_60931;
(statearr_60975[(4)] = cljs.core.cons((5),(state_60931[(4)])));

return statearr_60975;
})();
var inst_60807 = flureeQL;
var inst_60808 = cljs.core.__destructure_map(inst_60807);
var inst_60809__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60808,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_60810__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60808,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_60811__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60808,new cljs.core.Keyword(null,"block","block",664686210));
var inst_60812__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60808,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_60813__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60808,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_60814__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60808,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_60815__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60808,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_60816__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60808,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_60817__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60808,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_60818__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60808,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_60819 = (function (){var construct = inst_60809__$1;
var select = inst_60810__$1;
var block = inst_60811__$1;
var where = inst_60812__$1;
var prefixes = inst_60813__$1;
var selectDistinct = inst_60814__$1;
var map__60806 = inst_60808;
var selectOne = inst_60815__$1;
var from = inst_60816__$1;
var opts = inst_60817__$1;
var selectReduced = inst_60818__$1;
return (function (p1__60799_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__60799_SHARP_);
});
})();
var inst_60820 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60821 = [inst_60810__$1,inst_60815__$1,inst_60814__$1,inst_60818__$1];
var inst_60822 = (new cljs.core.PersistentVector(null,4,(5),inst_60820,inst_60821,null));
var inst_60823 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_60822);
var inst_60824 = cljs.core.count(inst_60823);
var inst_60825 = (inst_60819.cljs$core$IFn$_invoke$arity$1 ? inst_60819.cljs$core$IFn$_invoke$arity$1(inst_60824) : inst_60819.call(null,inst_60824));
var state_60931__$1 = (function (){var statearr_60976 = state_60931;
(statearr_60976[(18)] = inst_60812__$1);

(statearr_60976[(20)] = inst_60817__$1);

(statearr_60976[(9)] = inst_60816__$1);

(statearr_60976[(19)] = inst_60815__$1);

(statearr_60976[(10)] = inst_60813__$1);

(statearr_60976[(23)] = inst_60809__$1);

(statearr_60976[(16)] = inst_60811__$1);

(statearr_60976[(7)] = inst_60810__$1);

(statearr_60976[(17)] = inst_60818__$1);

(statearr_60976[(14)] = inst_60814__$1);

return statearr_60976;
})();
if(cljs.core.truth_(inst_60825)){
var statearr_60977_61050 = state_60931__$1;
(statearr_60977_61050[(1)] = (6));

} else {
var statearr_60978_61051 = state_60931__$1;
(statearr_60978_61051[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (23))){
var inst_60872 = (state_60931[(8)]);
var inst_60817 = (state_60931[(20)]);
var inst_60871 = (state_60931[(2)]);
var inst_60872__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_60817);
var state_60931__$1 = (function (){var statearr_60979 = state_60931;
(statearr_60979[(8)] = inst_60872__$1);

(statearr_60979[(24)] = inst_60871);

return statearr_60979;
})();
if(cljs.core.truth_(inst_60872__$1)){
var statearr_60980_61052 = state_60931__$1;
(statearr_60980_61052[(1)] = (24));

} else {
var statearr_60981_61053 = state_60931__$1;
(statearr_60981_61053[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (47))){
var inst_60877 = (state_60931[(25)]);
var inst_60851 = (state_60931[(11)]);
var inst_60910 = (state_60931[(2)]);
var inst_60911 = fluree.db.util.core.current_time_millis();
var inst_60912 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_60877);
var inst_60913 = fluree.db.query.fql.query(inst_60851,inst_60912);
var state_60931__$1 = (function (){var statearr_60982 = state_60931;
(statearr_60982[(26)] = inst_60911);

(statearr_60982[(27)] = inst_60910);

return statearr_60982;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60931__$1,(48),inst_60913);
} else {
if((state_val_60932 === (35))){
var inst_60889 = (state_60931[(2)]);
var state_60931__$1 = state_60931;
var statearr_60983_61054 = state_60931__$1;
(statearr_60983_61054[(2)] = inst_60889);

(statearr_60983_61054[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (19))){
var inst_60861 = (state_60931[(12)]);
var state_60931__$1 = state_60931;
var statearr_60984_61055 = state_60931__$1;
(statearr_60984_61055[(2)] = inst_60861);

(statearr_60984_61055[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (11))){
var inst_60813 = (state_60931[(10)]);
var inst_60851 = (state_60931[(2)]);
var state_60931__$1 = (function (){var statearr_60986 = state_60931;
(statearr_60986[(11)] = inst_60851);

return statearr_60986;
})();
if(cljs.core.truth_(inst_60813)){
var statearr_60987_61056 = state_60931__$1;
(statearr_60987_61056[(1)] = (15));

} else {
var statearr_60988_61057 = state_60931__$1;
(statearr_60988_61057[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (9))){
var inst_60837 = (state_60931[(28)]);
var state_60931__$1 = state_60931;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60931__$1,(13),inst_60837);
} else {
if((state_val_60932 === (5))){
var _ = (function (){var statearr_60989 = state_60931;
(statearr_60989[(4)] = cljs.core.rest((state_60931[(4)])));

return statearr_60989;
})();
var state_60931__$1 = state_60931;
var ex60985 = (state_60931__$1[(2)]);
var statearr_60990_61058 = state_60931__$1;
(statearr_60990_61058[(5)] = ex60985);


if((ex60985 instanceof Error)){
var statearr_60991_61059 = state_60931__$1;
(statearr_60991_61059[(1)] = (4));

(statearr_60991_61059[(5)] = null);

} else {
throw ex60985;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (14))){
var inst_60848 = (state_60931[(2)]);
var inst_60849 = fluree.db.util.async.throw_err(inst_60848);
var state_60931__$1 = state_60931;
var statearr_60992_61060 = state_60931__$1;
(statearr_60992_61060[(2)] = inst_60849);

(statearr_60992_61060[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (45))){
var state_60931__$1 = state_60931;
var statearr_60993_61061 = state_60931__$1;
(statearr_60993_61061[(2)] = null);

(statearr_60993_61061[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (26))){
var inst_60817 = (state_60931[(20)]);
var inst_60810 = (state_60931[(7)]);
var inst_60860 = (state_60931[(22)]);
var inst_60871 = (state_60931[(24)]);
var inst_60876 = (state_60931[(2)]);
var inst_60877 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_60817,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_60860,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_60876,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_60871], 0));
var state_60931__$1 = (function (){var statearr_60994 = state_60931;
(statearr_60994[(25)] = inst_60877);

return statearr_60994;
})();
if(cljs.core.truth_(inst_60810)){
var statearr_60995_61062 = state_60931__$1;
(statearr_60995_61062[(1)] = (27));

} else {
var statearr_60996_61063 = state_60931__$1;
(statearr_60996_61063[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (16))){
var inst_60858 = cljs.core.PersistentHashMap.EMPTY;
var state_60931__$1 = state_60931;
var statearr_60997_61064 = state_60931__$1;
(statearr_60997_61064[(2)] = inst_60858);

(statearr_60997_61064[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (38))){
var inst_60887 = (state_60931[(2)]);
var state_60931__$1 = state_60931;
var statearr_60998_61065 = state_60931__$1;
(statearr_60998_61065[(2)] = inst_60887);

(statearr_60998_61065[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (30))){
var inst_60815 = (state_60931[(19)]);
var state_60931__$1 = state_60931;
var statearr_60999_61066 = state_60931__$1;
(statearr_60999_61066[(2)] = inst_60815);

(statearr_60999_61066[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (10))){
var inst_60837 = (state_60931[(28)]);
var state_60931__$1 = state_60931;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60931__$1,(14),inst_60837);
} else {
if((state_val_60932 === (18))){
var inst_60862 = (state_60931[(21)]);
var state_60931__$1 = state_60931;
var statearr_61000_61067 = state_60931__$1;
(statearr_61000_61067[(2)] = inst_60862);

(statearr_61000_61067[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (42))){
var inst_60816 = (state_60931[(9)]);
var state_60931__$1 = state_60931;
var statearr_61001_61068 = state_60931__$1;
(statearr_61001_61068[(2)] = inst_60816);

(statearr_61001_61068[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (37))){
var inst_60809 = (state_60931[(23)]);
var state_60931__$1 = state_60931;
var statearr_61002_61069 = state_60931__$1;
(statearr_61002_61069[(2)] = inst_60809);

(statearr_61002_61069[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (8))){
var inst_60811 = (state_60931[(16)]);
var inst_60836 = (state_60931[(2)]);
var inst_60837 = sources;
var state_60931__$1 = (function (){var statearr_61003 = state_60931;
(statearr_61003[(29)] = inst_60836);

(statearr_61003[(28)] = inst_60837);

return statearr_61003;
})();
if(cljs.core.truth_(inst_60811)){
var statearr_61004_61070 = state_60931__$1;
(statearr_61004_61070[(1)] = (9));

} else {
var statearr_61005_61071 = state_60931__$1;
(statearr_61005_61071[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60932 === (49))){
var inst_60911 = (state_60931[(26)]);
var inst_60916 = (state_60931[(13)]);
var inst_60871 = (state_60931[(24)]);
var inst_60851 = (state_60931[(11)]);
var inst_60918 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_60919 = cljs.core.deref(inst_60871);
var inst_60920 = fluree.db.util.core.response_time_formatted(inst_60911);
var inst_60921 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_60851);
var inst_60922 = [(200),inst_60916,inst_60919,inst_60920,inst_60921];
var inst_60923 = cljs.core.PersistentHashMap.fromArrays(inst_60918,inst_60922);
var state_60931__$1 = state_60931;
var statearr_61006_61072 = state_60931__$1;
(statearr_61006_61072[(2)] = inst_60923);

(statearr_61006_61072[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__2717__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__2717__auto____0 = (function (){
var statearr_61007 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61007[(0)] = fluree$db$api$query$query_async_$_state_machine__2717__auto__);

(statearr_61007[(1)] = (1));

return statearr_61007;
});
var fluree$db$api$query$query_async_$_state_machine__2717__auto____1 = (function (state_60931){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_60931);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e61008){var ex__2720__auto__ = e61008;
var statearr_61009_61073 = state_60931;
(statearr_61009_61073[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_60931[(4)]))){
var statearr_61010_61074 = state_60931;
(statearr_61010_61074[(1)] = cljs.core.first((state_60931[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61075 = state_60931;
state_60931 = G__61075;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__2717__auto__ = function(state_60931){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__2717__auto____1.call(this,state_60931);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__2717__auto____0;
fluree$db$api$query$query_async_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__2717__auto____1;
return fluree$db$api$query$query_async_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_61011 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_61011[(6)] = c__2739__auto__);

return statearr_61011;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_61216){
var state_val_61217 = (state_61216[(1)]);
if((state_val_61217 === (7))){
var inst_61211 = (state_61216[(2)]);
var _ = (function (){var statearr_61218 = state_61216;
(statearr_61218[(4)] = cljs.core.rest((state_61216[(4)])));

return statearr_61218;
})();
var state_61216__$1 = state_61216;
var statearr_61219_61295 = state_61216__$1;
(statearr_61219_61295[(2)] = inst_61211);

(statearr_61219_61295[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (20))){
var inst_61183 = (state_61216[(2)]);
var state_61216__$1 = state_61216;
var statearr_61220_61296 = state_61216__$1;
(statearr_61220_61296[(2)] = inst_61183);

(statearr_61220_61296[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (27))){
var inst_61163 = (state_61216[(7)]);
var state_61216__$1 = state_61216;
var statearr_61221_61297 = state_61216__$1;
(statearr_61221_61297[(2)] = inst_61163);

(statearr_61221_61297[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (1))){
var state_61216__$1 = state_61216;
var statearr_61222_61298 = state_61216__$1;
(statearr_61222_61298[(2)] = null);

(statearr_61222_61298[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (24))){
var inst_61160 = (state_61216[(8)]);
var state_61216__$1 = state_61216;
var statearr_61223_61299 = state_61216__$1;
(statearr_61223_61299[(2)] = inst_61160);

(statearr_61223_61299[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (39))){
var inst_61128 = (state_61216[(9)]);
var inst_61150 = (state_61216[(10)]);
var inst_61117 = (state_61216[(11)]);
var inst_61194 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61195 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_61128];
var inst_61196 = (new cljs.core.PersistentVector(null,2,(5),inst_61194,inst_61195,null));
var inst_61197 = cljs.core.assoc_in(inst_61117,inst_61196,inst_61150);
var state_61216__$1 = state_61216;
var statearr_61224_61300 = state_61216__$1;
(statearr_61224_61300[(2)] = inst_61197);

(statearr_61224_61300[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (4))){
var inst_61076 = (state_61216[(2)]);
var state_61216__$1 = state_61216;
var statearr_61225_61301 = state_61216__$1;
(statearr_61225_61301[(2)] = inst_61076);

(statearr_61225_61301[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (15))){
var inst_61150 = (state_61216[(10)]);
var inst_61115 = (state_61216[(12)]);
var inst_61153 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_61150);
var inst_61154 = (inst_61115 == null);
var state_61216__$1 = (function (){var statearr_61226 = state_61216;
(statearr_61226[(13)] = inst_61153);

return statearr_61226;
})();
if(cljs.core.truth_(inst_61154)){
var statearr_61227_61302 = state_61216__$1;
(statearr_61227_61302[(1)] = (18));

} else {
var statearr_61228_61303 = state_61216__$1;
(statearr_61228_61303[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (21))){
var inst_61153 = (state_61216[(13)]);
var state_61216__$1 = state_61216;
var statearr_61229_61304 = state_61216__$1;
(statearr_61229_61304[(2)] = inst_61153);

(statearr_61229_61304[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (31))){
var state_61216__$1 = state_61216;
var statearr_61230_61305 = state_61216__$1;
(statearr_61230_61305[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (32))){
var inst_61179 = (state_61216[(2)]);
var state_61216__$1 = state_61216;
var statearr_61232_61306 = state_61216__$1;
(statearr_61232_61306[(2)] = inst_61179);

(statearr_61232_61306[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (40))){
var inst_61148 = (state_61216[(14)]);
var state_61216__$1 = state_61216;
if(cljs.core.truth_(inst_61148)){
var statearr_61233_61307 = state_61216__$1;
(statearr_61233_61307[(1)] = (42));

} else {
var statearr_61234_61308 = state_61216__$1;
(statearr_61234_61308[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (33))){
var inst_61115 = (state_61216[(12)]);
var inst_61153 = (state_61216[(13)]);
var inst_61174 = ((inst_61153 > inst_61115) ? inst_61153 : inst_61115);
var state_61216__$1 = state_61216;
var statearr_61235_61309 = state_61216__$1;
(statearr_61235_61309[(2)] = inst_61174);

(statearr_61235_61309[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (13))){
var inst_61139 = (state_61216[(2)]);
var state_61216__$1 = state_61216;
var statearr_61236_61310 = state_61216__$1;
(statearr_61236_61310[(2)] = inst_61139);

(statearr_61236_61310[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (22))){
var inst_61153 = (state_61216[(13)]);
var inst_61160 = (state_61216[(8)]);
var inst_61160__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_61153);
var state_61216__$1 = (function (){var statearr_61237 = state_61216;
(statearr_61237[(8)] = inst_61160__$1);

return statearr_61237;
})();
if(inst_61160__$1){
var statearr_61238_61311 = state_61216__$1;
(statearr_61238_61311[(1)] = (24));

} else {
var statearr_61239_61312 = state_61216__$1;
(statearr_61239_61312[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (36))){
var inst_61150 = (state_61216[(10)]);
var inst_61116 = (state_61216[(15)]);
var inst_61188 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_61150,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_61189 = (inst_61116 + inst_61188);
var state_61216__$1 = state_61216;
var statearr_61240_61313 = state_61216__$1;
(statearr_61240_61313[(2)] = inst_61189);

(statearr_61240_61313[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (41))){
var inst_61192 = (state_61216[(16)]);
var inst_61127 = (state_61216[(17)]);
var inst_61186 = (state_61216[(18)]);
var inst_61206 = (state_61216[(2)]);
var inst_61114 = inst_61127;
var inst_61115 = inst_61186;
var inst_61116 = inst_61192;
var inst_61117 = inst_61206;
var state_61216__$1 = (function (){var statearr_61241 = state_61216;
(statearr_61241[(12)] = inst_61115);

(statearr_61241[(11)] = inst_61117);

(statearr_61241[(19)] = inst_61114);

(statearr_61241[(15)] = inst_61116);

return statearr_61241;
})();
var statearr_61242_61314 = state_61216__$1;
(statearr_61242_61314[(2)] = null);

(statearr_61242_61314[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (43))){
var inst_61150 = (state_61216[(10)]);
var state_61216__$1 = state_61216;
var statearr_61243_61315 = state_61216__$1;
(statearr_61243_61315[(2)] = inst_61150);

(statearr_61243_61315[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (29))){
var inst_61168 = (state_61216[(2)]);
var state_61216__$1 = state_61216;
var statearr_61244_61316 = state_61216__$1;
(statearr_61244_61316[(2)] = inst_61168);

(statearr_61244_61316[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (44))){
var inst_61128 = (state_61216[(9)]);
var inst_61117 = (state_61216[(11)]);
var inst_61203 = (state_61216[(2)]);
var inst_61204 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_61117,inst_61128,inst_61203);
var state_61216__$1 = state_61216;
var statearr_61245_61317 = state_61216__$1;
(statearr_61245_61317[(2)] = inst_61204);

(statearr_61245_61317[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (6))){
var inst_61129 = (state_61216[(20)]);
var inst_61114 = (state_61216[(19)]);
var inst_61125 = cljs.core.seq(inst_61114);
var inst_61126 = cljs.core.first(inst_61125);
var inst_61127 = cljs.core.next(inst_61125);
var inst_61128 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61126,(0),null);
var inst_61129__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61126,(1),null);
var inst_61130 = (inst_61129__$1 == null);
var state_61216__$1 = (function (){var statearr_61246 = state_61216;
(statearr_61246[(20)] = inst_61129__$1);

(statearr_61246[(9)] = inst_61128);

(statearr_61246[(17)] = inst_61127);

return statearr_61246;
})();
if(cljs.core.truth_(inst_61130)){
var statearr_61247_61318 = state_61216__$1;
(statearr_61247_61318[(1)] = (8));

} else {
var statearr_61248_61319 = state_61216__$1;
(statearr_61248_61319[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (28))){
var inst_61115 = (state_61216[(12)]);
var inst_61166 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((207),inst_61115);
var state_61216__$1 = state_61216;
var statearr_61249_61320 = state_61216__$1;
(statearr_61249_61320[(2)] = inst_61166);

(statearr_61249_61320[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (25))){
var inst_61163 = (state_61216[(7)]);
var inst_61115 = (state_61216[(12)]);
var inst_61163__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_61115);
var state_61216__$1 = (function (){var statearr_61250 = state_61216;
(statearr_61250[(7)] = inst_61163__$1);

return statearr_61250;
})();
if(inst_61163__$1){
var statearr_61251_61321 = state_61216__$1;
(statearr_61251_61321[(1)] = (27));

} else {
var statearr_61252_61322 = state_61216__$1;
(statearr_61252_61322[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (34))){
var state_61216__$1 = state_61216;
var statearr_61253_61323 = state_61216__$1;
(statearr_61253_61323[(2)] = null);

(statearr_61253_61323[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (17))){
var inst_61147 = (state_61216[(21)]);
var inst_61186 = (state_61216[(2)]);
var state_61216__$1 = (function (){var statearr_61254 = state_61216;
(statearr_61254[(18)] = inst_61186);

return statearr_61254;
})();
if(cljs.core.truth_(inst_61147)){
var statearr_61255_61324 = state_61216__$1;
(statearr_61255_61324[(1)] = (36));

} else {
var statearr_61256_61325 = state_61216__$1;
(statearr_61256_61325[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (3))){
var inst_61214 = (state_61216[(2)]);
var state_61216__$1 = state_61216;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61216__$1,inst_61214);
} else {
if((state_val_61217 === (12))){
var inst_61117 = (state_61216[(11)]);
var state_61216__$1 = state_61216;
var statearr_61257_61326 = state_61216__$1;
(statearr_61257_61326[(2)] = inst_61117);

(statearr_61257_61326[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (2))){
var inst_61091 = (state_61216[(22)]);
var inst_61090 = (state_61216[(23)]);
var inst_61086 = (state_61216[(24)]);
var _ = (function (){var statearr_61258 = state_61216;
(statearr_61258[(4)] = cljs.core.cons((5),(state_61216[(4)])));

return statearr_61258;
})();
var inst_61082 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_61083 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61084 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_61085 = (new cljs.core.PersistentVector(null,2,(5),inst_61083,inst_61084,null));
var inst_61086__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(flureeQL,inst_61085);
var inst_61087 = (function (){var global_block = inst_61082;
var global_meta_QMARK_ = inst_61086__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__4212__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__4210__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.not(query_meta_QMARK_);
} else {
return and__4210__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_], 0));
var query_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__4212__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return global_block;
}
})()], 0));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,alias,query_STAR_);
});
})();
var inst_61088 = cljs.core.PersistentHashMap.EMPTY;
var inst_61089 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210)], 0));
var inst_61090__$1 = cljs.core.reduce_kv(inst_61087,inst_61088,inst_61089);
var inst_61091__$1 = fluree.db.util.core.current_time_millis();
var inst_61093 = (function (){var global_block = inst_61082;
var global_meta_QMARK_ = inst_61086__$1;
var queries = inst_61090__$1;
var start_time = inst_61091__$1;
return (function (p__61092){
var vec__61259 = p__61092;
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61259,(0),null);
var q = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61259,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,(fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2(source,q) : fluree.db.api.query.query.call(null,source,q))], null);
});
})();
var inst_61094 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_61093,inst_61090__$1);
var inst_61108 = cljs.core.seq(inst_61094);
var inst_61109 = cljs.core.first(inst_61108);
var inst_61110 = cljs.core.next(inst_61108);
var inst_61111 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61109,(0),null);
var inst_61112 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61109,(1),null);
var inst_61113 = cljs.core.PersistentHashMap.EMPTY;
var inst_61114 = inst_61094;
var inst_61115 = null;
var inst_61116 = (0);
var inst_61117 = inst_61113;
var state_61216__$1 = (function (){var statearr_61262 = state_61216;
(statearr_61262[(22)] = inst_61091__$1);

(statearr_61262[(23)] = inst_61090__$1);

(statearr_61262[(12)] = inst_61115);

(statearr_61262[(25)] = inst_61110);

(statearr_61262[(24)] = inst_61086__$1);

(statearr_61262[(11)] = inst_61117);

(statearr_61262[(26)] = inst_61112);

(statearr_61262[(27)] = inst_61111);

(statearr_61262[(19)] = inst_61114);

(statearr_61262[(15)] = inst_61116);

return statearr_61262;
})();
var statearr_61263_61327 = state_61216__$1;
(statearr_61263_61327[(2)] = null);

(statearr_61263_61327[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (23))){
var inst_61181 = (state_61216[(2)]);
var state_61216__$1 = state_61216;
var statearr_61264_61328 = state_61216__$1;
(statearr_61264_61328[(2)] = inst_61181);

(statearr_61264_61328[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (35))){
var inst_61177 = (state_61216[(2)]);
var state_61216__$1 = state_61216;
var statearr_61265_61329 = state_61216__$1;
(statearr_61265_61329[(2)] = inst_61177);

(statearr_61265_61329[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (19))){
var inst_61115 = (state_61216[(12)]);
var inst_61153 = (state_61216[(13)]);
var inst_61157 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61115,inst_61153);
var state_61216__$1 = state_61216;
if(inst_61157){
var statearr_61266_61330 = state_61216__$1;
(statearr_61266_61330[(1)] = (21));

} else {
var statearr_61267_61331 = state_61216__$1;
(statearr_61267_61331[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (11))){
var inst_61091 = (state_61216[(22)]);
var inst_61115 = (state_61216[(12)]);
var inst_61117 = (state_61216[(11)]);
var inst_61116 = (state_61216[(15)]);
var inst_61133 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_61134 = fluree.db.util.core.response_time_formatted(inst_61091);
var inst_61135 = [inst_61117,inst_61116,inst_61115,inst_61134];
var inst_61136 = cljs.core.PersistentHashMap.fromArrays(inst_61133,inst_61135);
var state_61216__$1 = state_61216;
var statearr_61269_61332 = state_61216__$1;
(statearr_61269_61332[(2)] = inst_61136);

(statearr_61269_61332[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (9))){
var inst_61129 = (state_61216[(20)]);
var inst_61128 = (state_61216[(9)]);
var inst_61090 = (state_61216[(23)]);
var inst_61142 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61143 = [inst_61128,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_61144 = (new cljs.core.PersistentVector(null,2,(5),inst_61142,inst_61143,null));
var inst_61145 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_61090,inst_61144);
var inst_61146 = cljs.core.__destructure_map(inst_61145);
var inst_61147 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61146,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_61148 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61146,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_61216__$1 = (function (){var statearr_61270 = state_61216;
(statearr_61270[(21)] = inst_61147);

(statearr_61270[(14)] = inst_61148);

return statearr_61270;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61216__$1,(14),inst_61129);
} else {
if((state_val_61217 === (5))){
var _ = (function (){var statearr_61271 = state_61216;
(statearr_61271[(4)] = cljs.core.rest((state_61216[(4)])));

return statearr_61271;
})();
var state_61216__$1 = state_61216;
var ex61268 = (state_61216__$1[(2)]);
var statearr_61272_61333 = state_61216__$1;
(statearr_61272_61333[(5)] = ex61268);


var statearr_61273_61334 = state_61216__$1;
(statearr_61273_61334[(1)] = (4));

(statearr_61273_61334[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (14))){
var inst_61150 = (state_61216[(10)]);
var inst_61147 = (state_61216[(21)]);
var inst_61150__$1 = (state_61216[(2)]);
var inst_61151 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_61150__$1);
var state_61216__$1 = (function (){var statearr_61274 = state_61216;
(statearr_61274[(28)] = inst_61151);

(statearr_61274[(10)] = inst_61150__$1);

return statearr_61274;
})();
if(cljs.core.truth_(inst_61147)){
var statearr_61275_61335 = state_61216__$1;
(statearr_61275_61335[(1)] = (15));

} else {
var statearr_61276_61336 = state_61216__$1;
(statearr_61276_61336[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (26))){
var inst_61170 = (state_61216[(2)]);
var state_61216__$1 = state_61216;
if(cljs.core.truth_(inst_61170)){
var statearr_61277_61337 = state_61216__$1;
(statearr_61277_61337[(1)] = (30));

} else {
var statearr_61278_61338 = state_61216__$1;
(statearr_61278_61338[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (16))){
var state_61216__$1 = state_61216;
var statearr_61279_61339 = state_61216__$1;
(statearr_61279_61339[(2)] = null);

(statearr_61279_61339[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (38))){
var inst_61151 = (state_61216[(28)]);
var inst_61192 = (state_61216[(2)]);
var state_61216__$1 = (function (){var statearr_61280 = state_61216;
(statearr_61280[(16)] = inst_61192);

return statearr_61280;
})();
if(cljs.core.truth_(inst_61151)){
var statearr_61281_61340 = state_61216__$1;
(statearr_61281_61340[(1)] = (39));

} else {
var statearr_61282_61341 = state_61216__$1;
(statearr_61282_61341[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (30))){
var state_61216__$1 = state_61216;
var statearr_61283_61342 = state_61216__$1;
(statearr_61283_61342[(2)] = (207));

(statearr_61283_61342[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (10))){
var inst_61209 = (state_61216[(2)]);
var state_61216__$1 = state_61216;
var statearr_61284_61343 = state_61216__$1;
(statearr_61284_61343[(2)] = inst_61209);

(statearr_61284_61343[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (18))){
var inst_61153 = (state_61216[(13)]);
var state_61216__$1 = state_61216;
var statearr_61285_61344 = state_61216__$1;
(statearr_61285_61344[(2)] = inst_61153);

(statearr_61285_61344[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (42))){
var inst_61150 = (state_61216[(10)]);
var inst_61200 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_61150);
var state_61216__$1 = state_61216;
var statearr_61286_61345 = state_61216__$1;
(statearr_61286_61345[(2)] = inst_61200);

(statearr_61286_61345[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (37))){
var state_61216__$1 = state_61216;
var statearr_61287_61346 = state_61216__$1;
(statearr_61287_61346[(2)] = null);

(statearr_61287_61346[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61217 === (8))){
var inst_61086 = (state_61216[(24)]);
var state_61216__$1 = state_61216;
if(cljs.core.truth_(inst_61086)){
var statearr_61288_61347 = state_61216__$1;
(statearr_61288_61347[(1)] = (11));

} else {
var statearr_61289_61348 = state_61216__$1;
(statearr_61289_61348[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__2717__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__2717__auto____0 = (function (){
var statearr_61290 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61290[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__2717__auto__);

(statearr_61290[(1)] = (1));

return statearr_61290;
});
var fluree$db$api$query$multi_query_async_$_state_machine__2717__auto____1 = (function (state_61216){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_61216);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e61291){var ex__2720__auto__ = e61291;
var statearr_61292_61349 = state_61216;
(statearr_61292_61349[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_61216[(4)]))){
var statearr_61293_61350 = state_61216;
(statearr_61293_61350[(1)] = cljs.core.first((state_61216[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61351 = state_61216;
state_61216 = G__61351;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__2717__auto__ = function(state_61216){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__2717__auto____1.call(this,state_61216);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__2717__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__2717__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_61294 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_61294[(6)] = c__2739__auto__);

return statearr_61294;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type(flureeQL);
var G__61352 = query_type;
var G__61352__$1 = (((G__61352 instanceof cljs.core.Keyword))?G__61352.fqn:null);
switch (G__61352__$1) {
case "standard":
return fluree.db.api.query.query_async(source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async(source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async(conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async(source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__61352__$1)].join('')));

}
});
