// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__63009 = arguments.length;
switch (G__63009) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5751__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5751__auto__)){
var block = temp__5751__auto__;
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2739__auto___63048 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_63030){
var state_val_63031 = (state_63030[(1)]);
if((state_val_63031 === (1))){
var state_63030__$1 = state_63030;
var statearr_63032_63049 = state_63030__$1;
(statearr_63032_63049[(2)] = null);

(statearr_63032_63049[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63031 === (2))){
var _ = (function (){var statearr_63033 = state_63030;
(statearr_63033[(4)] = cljs.core.cons((5),(state_63030[(4)])));

return statearr_63033;
})();
var inst_63016 = fluree.db.session.db(conn,ledger,null);
var state_63030__$1 = state_63030;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63030__$1,(7),inst_63016);
} else {
if((state_val_63031 === (3))){
var inst_63026 = (state_63030[(2)]);
var inst_63027 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_63026);
var inst_63028 = cljs.core.async.close_BANG_(pc);
var state_63030__$1 = (function (){var statearr_63035 = state_63030;
(statearr_63035[(7)] = inst_63027);

return statearr_63035;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_63030__$1,inst_63028);
} else {
if((state_val_63031 === (4))){
var inst_63010 = (state_63030[(2)]);
var state_63030__$1 = state_63030;
var statearr_63036_63050 = state_63030__$1;
(statearr_63036_63050[(2)] = inst_63010);

(statearr_63036_63050[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63031 === (5))){
var _ = (function (){var statearr_63037 = state_63030;
(statearr_63037[(4)] = cljs.core.rest((state_63030[(4)])));

return statearr_63037;
})();
var state_63030__$1 = state_63030;
var ex63034 = (state_63030__$1[(2)]);
var statearr_63038_63051 = state_63030__$1;
(statearr_63038_63051[(5)] = ex63034);


var statearr_63039_63052 = state_63030__$1;
(statearr_63039_63052[(1)] = (4));

(statearr_63039_63052[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63031 === (6))){
var inst_63022 = (state_63030[(2)]);
var inst_63023 = fluree.db.util.async.throw_err(inst_63022);
var _ = (function (){var statearr_63040 = state_63030;
(statearr_63040[(4)] = cljs.core.rest((state_63030[(4)])));

return statearr_63040;
})();
var state_63030__$1 = state_63030;
var statearr_63041_63053 = state_63030__$1;
(statearr_63041_63053[(2)] = inst_63023);

(statearr_63041_63053[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63031 === (7))){
var inst_63018 = (state_63030[(2)]);
var inst_63019 = fluree.db.util.async.throw_err(inst_63018);
var inst_63020 = fluree.db.time_travel.as_of_block(inst_63019,block);
var state_63030__$1 = state_63030;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63030__$1,(6),inst_63020);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2717__auto__ = null;
var fluree$db$api$ledger$state_machine__2717__auto____0 = (function (){
var statearr_63042 = [null,null,null,null,null,null,null,null];
(statearr_63042[(0)] = fluree$db$api$ledger$state_machine__2717__auto__);

(statearr_63042[(1)] = (1));

return statearr_63042;
});
var fluree$db$api$ledger$state_machine__2717__auto____1 = (function (state_63030){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_63030);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e63043){var ex__2720__auto__ = e63043;
var statearr_63044_63054 = state_63030;
(statearr_63044_63054[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_63030[(4)]))){
var statearr_63045_63055 = state_63030;
(statearr_63045_63055[(1)] = cljs.core.first((state_63030[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63056 = state_63030;
state_63030 = G__63056;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2717__auto__ = function(state_63030){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2717__auto____1.call(this,state_63030);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2717__auto____0;
fluree$db$api$ledger$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2717__auto____1;
return fluree$db$api$ledger$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_63046 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_63046[(6)] = c__2739__auto___63048);

return statearr_63046;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));


return pc;
} else {
return fluree.db.session.db(conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t(db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_63097){
var state_val_63098 = (state_63097[(1)]);
if((state_val_63098 === (7))){
var inst_63066 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_63097__$1 = state_63097;
if(inst_63066){
var statearr_63099_63130 = state_63097__$1;
(statearr_63099_63130[(1)] = (9));

} else {
var statearr_63100_63131 = state_63097__$1;
(statearr_63100_63131[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63098 === (1))){
var state_63097__$1 = state_63097;
var statearr_63101_63132 = state_63097__$1;
(statearr_63101_63132[(2)] = null);

(statearr_63101_63132[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63098 === (4))){
var inst_63057 = (state_63097[(2)]);
var state_63097__$1 = state_63097;
var statearr_63102_63133 = state_63097__$1;
(statearr_63102_63133[(2)] = inst_63057);

(statearr_63102_63133[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63098 === (15))){
var inst_63074 = (state_63097[(7)]);
var inst_63073 = (state_63097[(2)]);
var inst_63074__$1 = fluree.db.util.async.throw_err(inst_63073);
var state_63097__$1 = (function (){var statearr_63103 = state_63097;
(statearr_63103[(7)] = inst_63074__$1);

return statearr_63103;
})();
if(cljs.core.truth_(inst_63074__$1)){
var statearr_63104_63134 = state_63097__$1;
(statearr_63104_63134[(1)] = (16));

} else {
var statearr_63105_63135 = state_63097__$1;
(statearr_63105_63135[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63098 === (13))){
var state_63097__$1 = state_63097;
var statearr_63106_63136 = state_63097__$1;
(statearr_63106_63136[(2)] = null);

(statearr_63106_63136[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63098 === (6))){
var state_63097__$1 = state_63097;
var statearr_63107_63137 = state_63097__$1;
(statearr_63107_63137[(2)] = db);

(statearr_63107_63137[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63098 === (17))){
var inst_63078 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_63079 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63080 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_63081 = cljs.core.PersistentHashMap.fromArrays(inst_63079,inst_63080);
var inst_63082 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_63078,inst_63081);
var inst_63083 = (function(){throw inst_63082})();
var state_63097__$1 = state_63097;
var statearr_63108_63138 = state_63097__$1;
(statearr_63108_63138[(2)] = inst_63083);

(statearr_63108_63138[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63098 === (3))){
var inst_63095 = (state_63097[(2)]);
var state_63097__$1 = state_63097;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63097__$1,inst_63095);
} else {
if((state_val_63098 === (12))){
var inst_63071 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_63097__$1 = state_63097;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63097__$1,(15),inst_63071);
} else {
if((state_val_63098 === (2))){
var _ = (function (){var statearr_63109 = state_63097;
(statearr_63109[(4)] = cljs.core.cons((5),(state_63097[(4)])));

return statearr_63109;
})();
var inst_63063 = cljs.core.not(auth);
var state_63097__$1 = state_63097;
if(inst_63063){
var statearr_63110_63139 = state_63097__$1;
(statearr_63110_63139[(1)] = (6));

} else {
var statearr_63111_63140 = state_63097__$1;
(statearr_63111_63140[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63098 === (11))){
var inst_63090 = (state_63097[(2)]);
var state_63097__$1 = state_63097;
var statearr_63113_63141 = state_63097__$1;
(statearr_63113_63141[(2)] = inst_63090);

(statearr_63113_63141[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63098 === (9))){
var inst_63068 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_63097__$1 = state_63097;
var statearr_63114_63142 = state_63097__$1;
(statearr_63114_63142[(2)] = inst_63068);

(statearr_63114_63142[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63098 === (5))){
var _ = (function (){var statearr_63115 = state_63097;
(statearr_63115[(4)] = cljs.core.rest((state_63097[(4)])));

return statearr_63115;
})();
var state_63097__$1 = state_63097;
var ex63112 = (state_63097__$1[(2)]);
var statearr_63116_63143 = state_63097__$1;
(statearr_63116_63143[(5)] = ex63112);


if((ex63112 instanceof Error)){
var statearr_63117_63144 = state_63097__$1;
(statearr_63117_63144[(1)] = (4));

(statearr_63117_63144[(5)] = null);

} else {
throw ex63112;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63098 === (14))){
var inst_63088 = (state_63097[(2)]);
var state_63097__$1 = state_63097;
var statearr_63118_63145 = state_63097__$1;
(statearr_63118_63145[(2)] = inst_63088);

(statearr_63118_63145[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63098 === (16))){
var inst_63074 = (state_63097[(7)]);
var inst_63076 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_63074);
var state_63097__$1 = state_63097;
var statearr_63119_63146 = state_63097__$1;
(statearr_63119_63146[(2)] = inst_63076);

(statearr_63119_63146[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63098 === (10))){
var state_63097__$1 = state_63097;
var statearr_63120_63147 = state_63097__$1;
(statearr_63120_63147[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63098 === (18))){
var inst_63085 = (state_63097[(2)]);
var state_63097__$1 = state_63097;
var statearr_63122_63148 = state_63097__$1;
(statearr_63122_63148[(2)] = inst_63085);

(statearr_63122_63148[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63098 === (8))){
var inst_63092 = (state_63097[(2)]);
var _ = (function (){var statearr_63123 = state_63097;
(statearr_63123[(4)] = cljs.core.rest((state_63097[(4)])));

return statearr_63123;
})();
var state_63097__$1 = state_63097;
var statearr_63124_63149 = state_63097__$1;
(statearr_63124_63149[(2)] = inst_63092);

(statearr_63124_63149[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2717__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2717__auto____0 = (function (){
var statearr_63125 = [null,null,null,null,null,null,null,null];
(statearr_63125[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2717__auto__);

(statearr_63125[(1)] = (1));

return statearr_63125;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2717__auto____1 = (function (state_63097){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_63097);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e63126){var ex__2720__auto__ = e63126;
var statearr_63127_63150 = state_63097;
(statearr_63127_63150[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_63097[(4)]))){
var statearr_63128_63151 = state_63097;
(statearr_63128_63151[(1)] = cljs.core.first((state_63097[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63152 = state_63097;
state_63097 = G__63152;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2717__auto__ = function(state_63097){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2717__auto____1.call(this,state_63097);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2717__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2717__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_63129 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_63129[(6)] = c__2739__auto__);

return statearr_63129;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_63216){
var state_val_63217 = (state_63216[(1)]);
if((state_val_63217 === (7))){
var inst_63162 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_63216__$1 = state_63216;
if(inst_63162){
var statearr_63218_63267 = state_63216__$1;
(statearr_63218_63267[(1)] = (9));

} else {
var statearr_63219_63268 = state_63216__$1;
(statearr_63219_63268[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63217 === (20))){
var inst_63186 = (state_63216[(7)]);
var state_63216__$1 = state_63216;
if(cljs.core.truth_(inst_63186)){
var statearr_63220_63269 = state_63216__$1;
(statearr_63220_63269[(1)] = (22));

} else {
var statearr_63221_63270 = state_63216__$1;
(statearr_63221_63270[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63217 === (27))){
var state_63216__$1 = state_63216;
var statearr_63222_63271 = state_63216__$1;
(statearr_63222_63271[(2)] = null);

(statearr_63222_63271[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63217 === (1))){
var state_63216__$1 = state_63216;
var statearr_63223_63272 = state_63216__$1;
(statearr_63223_63272[(2)] = null);

(statearr_63223_63272[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63217 === (24))){
var inst_63200 = (state_63216[(2)]);
var state_63216__$1 = state_63216;
var statearr_63224_63273 = state_63216__$1;
(statearr_63224_63273[(2)] = inst_63200);

(statearr_63224_63273[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63217 === (4))){
var inst_63153 = (state_63216[(2)]);
var state_63216__$1 = state_63216;
var statearr_63225_63274 = state_63216__$1;
(statearr_63225_63274[(2)] = inst_63153);

(statearr_63225_63274[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63217 === (15))){
var inst_63169 = (state_63216[(8)]);
var inst_63168 = (state_63216[(2)]);
var inst_63169__$1 = fluree.db.util.async.throw_err(inst_63168);
var state_63216__$1 = (function (){var statearr_63226 = state_63216;
(statearr_63226[(8)] = inst_63169__$1);

return statearr_63226;
})();
if(cljs.core.truth_(inst_63169__$1)){
var statearr_63227_63275 = state_63216__$1;
(statearr_63227_63275[(1)] = (16));

} else {
var statearr_63228_63276 = state_63216__$1;
(statearr_63228_63276[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63217 === (21))){
var inst_63202 = (state_63216[(9)]);
var inst_63202__$1 = (state_63216[(2)]);
var state_63216__$1 = (function (){var statearr_63229 = state_63216;
(statearr_63229[(9)] = inst_63202__$1);

return statearr_63229;
})();
if(cljs.core.truth_(inst_63202__$1)){
var statearr_63230_63277 = state_63216__$1;
(statearr_63230_63277[(1)] = (29));

} else {
var statearr_63231_63278 = state_63216__$1;
(statearr_63231_63278[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63217 === (31))){
var inst_63186 = (state_63216[(7)]);
var inst_63202 = (state_63216[(9)]);
var inst_63210 = (state_63216[(2)]);
var inst_63211 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_63186,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"roles","roles",143379530),inst_63202,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_63210], 0));
var _ = (function (){var statearr_63232 = state_63216;
(statearr_63232[(4)] = cljs.core.rest((state_63216[(4)])));

return statearr_63232;
})();
var state_63216__$1 = state_63216;
var statearr_63233_63279 = state_63216__$1;
(statearr_63233_63279[(2)] = inst_63211);

(statearr_63233_63279[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63217 === (32))){
var inst_63206 = (state_63216[(2)]);
var inst_63207 = fluree.db.util.async.throw_err(inst_63206);
var state_63216__$1 = state_63216;
var statearr_63234_63280 = state_63216__$1;
(statearr_63234_63280[(2)] = inst_63207);

(statearr_63234_63280[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63217 === (13))){
var state_63216__$1 = state_63216;
var statearr_63235_63281 = state_63216__$1;
(statearr_63235_63281[(2)] = null);

(statearr_63235_63281[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63217 === (22))){
var inst_63186 = (state_63216[(7)]);
var inst_63190 = fluree.db.auth.roles(db,inst_63186);
var state_63216__$1 = state_63216;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63216__$1,(25),inst_63190);
} else {
if((state_val_63217 === (29))){
var inst_63202 = (state_63216[(9)]);
var inst_63204 = fluree.db.permissions.permission_map(db,inst_63202,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_63216__$1 = state_63216;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63216__$1,(32),inst_63204);
} else {
if((state_val_63217 === (6))){
var state_63216__$1 = state_63216;
var statearr_63236_63282 = state_63216__$1;
(statearr_63236_63282[(2)] = null);

(statearr_63236_63282[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63217 === (28))){
var inst_63198 = (state_63216[(2)]);
var state_63216__$1 = state_63216;
var statearr_63237_63283 = state_63216__$1;
(statearr_63237_63283[(2)] = inst_63198);

(statearr_63237_63283[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63217 === (25))){
var inst_63192 = (state_63216[(2)]);
var inst_63193 = fluree.db.util.async.throw_err(inst_63192);
var state_63216__$1 = state_63216;
var statearr_63238_63284 = state_63216__$1;
(statearr_63238_63284[(2)] = inst_63193);

(statearr_63238_63284[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63217 === (17))){
var inst_63172 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_63173 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63174 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_63175 = cljs.core.PersistentHashMap.fromArrays(inst_63173,inst_63174);
var inst_63176 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_63172,inst_63175);
var inst_63177 = (function(){throw inst_63176})();
var state_63216__$1 = state_63216;
var statearr_63239_63285 = state_63216__$1;
(statearr_63239_63285[(2)] = inst_63177);

(statearr_63239_63285[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63217 === (3))){
var inst_63214 = (state_63216[(2)]);
var state_63216__$1 = state_63216;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63216__$1,inst_63214);
} else {
if((state_val_63217 === (12))){
var inst_63166 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_63216__$1 = state_63216;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63216__$1,(15),inst_63166);
} else {
if((state_val_63217 === (2))){
var _ = (function (){var statearr_63240 = state_63216;
(statearr_63240[(4)] = cljs.core.cons((5),(state_63216[(4)])));

return statearr_63240;
})();
var inst_63159 = (auth == null);
var state_63216__$1 = state_63216;
if(cljs.core.truth_(inst_63159)){
var statearr_63241_63286 = state_63216__$1;
(statearr_63241_63286[(1)] = (6));

} else {
var statearr_63242_63287 = state_63216__$1;
(statearr_63242_63287[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63217 === (23))){
var state_63216__$1 = state_63216;
var statearr_63243_63288 = state_63216__$1;
(statearr_63243_63288[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63217 === (19))){
var state_63216__$1 = state_63216;
var statearr_63245_63289 = state_63216__$1;
(statearr_63245_63289[(2)] = roles);

(statearr_63245_63289[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63217 === (11))){
var inst_63184 = (state_63216[(2)]);
var state_63216__$1 = state_63216;
var statearr_63247_63290 = state_63216__$1;
(statearr_63247_63290[(2)] = inst_63184);

(statearr_63247_63290[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63217 === (9))){
var state_63216__$1 = state_63216;
var statearr_63248_63291 = state_63216__$1;
(statearr_63248_63291[(2)] = (0));

(statearr_63248_63291[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63217 === (5))){
var _ = (function (){var statearr_63249 = state_63216;
(statearr_63249[(4)] = cljs.core.rest((state_63216[(4)])));

return statearr_63249;
})();
var state_63216__$1 = state_63216;
var ex63246 = (state_63216__$1[(2)]);
var statearr_63250_63292 = state_63216__$1;
(statearr_63250_63292[(5)] = ex63246);


if((ex63246 instanceof Error)){
var statearr_63251_63293 = state_63216__$1;
(statearr_63251_63293[(1)] = (4));

(statearr_63251_63293[(5)] = null);

} else {
throw ex63246;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63217 === (14))){
var inst_63182 = (state_63216[(2)]);
var state_63216__$1 = state_63216;
var statearr_63252_63294 = state_63216__$1;
(statearr_63252_63294[(2)] = inst_63182);

(statearr_63252_63294[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63217 === (26))){
var state_63216__$1 = state_63216;
var statearr_63253_63295 = state_63216__$1;
(statearr_63253_63295[(2)] = null);

(statearr_63253_63295[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63217 === (16))){
var inst_63169 = (state_63216[(8)]);
var state_63216__$1 = state_63216;
var statearr_63254_63296 = state_63216__$1;
(statearr_63254_63296[(2)] = inst_63169);

(statearr_63254_63296[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63217 === (30))){
var state_63216__$1 = state_63216;
var statearr_63255_63297 = state_63216__$1;
(statearr_63255_63297[(2)] = null);

(statearr_63255_63297[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63217 === (10))){
var state_63216__$1 = state_63216;
if(cljs.core.truth_(auth)){
var statearr_63256_63298 = state_63216__$1;
(statearr_63256_63298[(1)] = (12));

} else {
var statearr_63257_63299 = state_63216__$1;
(statearr_63257_63299[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63217 === (18))){
var inst_63179 = (state_63216[(2)]);
var state_63216__$1 = state_63216;
var statearr_63258_63300 = state_63216__$1;
(statearr_63258_63300[(2)] = inst_63179);

(statearr_63258_63300[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63217 === (8))){
var inst_63186 = (state_63216[(2)]);
var state_63216__$1 = (function (){var statearr_63259 = state_63216;
(statearr_63259[(7)] = inst_63186);

return statearr_63259;
})();
if(cljs.core.truth_(roles)){
var statearr_63260_63301 = state_63216__$1;
(statearr_63260_63301[(1)] = (19));

} else {
var statearr_63261_63302 = state_63216__$1;
(statearr_63261_63302[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2717__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2717__auto____0 = (function (){
var statearr_63262 = [null,null,null,null,null,null,null,null,null,null];
(statearr_63262[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2717__auto__);

(statearr_63262[(1)] = (1));

return statearr_63262;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2717__auto____1 = (function (state_63216){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_63216);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e63263){var ex__2720__auto__ = e63263;
var statearr_63264_63303 = state_63216;
(statearr_63264_63303[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_63216[(4)]))){
var statearr_63265_63304 = state_63216;
(statearr_63265_63304[(1)] = cljs.core.first((state_63216[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63305 = state_63216;
state_63216 = G__63305;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2717__auto__ = function(state_63216){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2717__auto____1.call(this,state_63216);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2717__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2717__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_63266 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_63266[(6)] = c__2739__auto__);

return statearr_63266;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__63306 = db;
var map__63306__$1 = cljs.core.__destructure_map(map__63306);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63306__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63306__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63306__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NEW EVENT:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([evt], 0)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([data], 0))], 0));

if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener(conn,network,dbid,listen_id);

var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_63313){
var state_val_63314 = (state_63313[(1)]);
if((state_val_63314 === (1))){
var inst_63307 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_63308 = fluree.db.session.db(conn,inst_63307,null);
var state_63313__$1 = state_63313;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63313__$1,(2),inst_63308);
} else {
if((state_val_63314 === (2))){
var inst_63310 = (state_63313[(2)]);
var inst_63311 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_63310);
var state_63313__$1 = state_63313;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63313__$1,inst_63311);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2717__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2717__auto____0 = (function (){
var statearr_63315 = [null,null,null,null,null,null,null];
(statearr_63315[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2717__auto__);

(statearr_63315[(1)] = (1));

return statearr_63315;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2717__auto____1 = (function (state_63313){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_63313);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e63316){var ex__2720__auto__ = e63316;
var statearr_63317_63344 = state_63313;
(statearr_63317_63344[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_63313[(4)]))){
var statearr_63318_63345 = state_63313;
(statearr_63318_63345[(1)] = cljs.core.first((state_63313[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63346 = state_63313;
state_63313 = G__63346;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2717__auto__ = function(state_63313){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2717__auto____1.call(this,state_63313);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2717__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2717__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_63319 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_63319[(6)] = c__2739__auto__);

return statearr_63319;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener(conn,network,dbid,listen_id,event_fn);

var c__2739__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_63332){
var state_val_63333 = (state_63332[(1)]);
if((state_val_63333 === (1))){
var inst_63320 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_63321 = fluree.db.session.db(conn,inst_63320,null);
var state_63332__$1 = state_63332;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63332__$1,(2),inst_63321);
} else {
if((state_val_63333 === (2))){
var inst_63323 = (state_63332[(7)]);
var inst_63323__$1 = (state_63332[(2)]);
var inst_63324 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_63323__$1);
var inst_63325 = newer_block_QMARK_(inst_63324);
var state_63332__$1 = (function (){var statearr_63334 = state_63332;
(statearr_63334[(7)] = inst_63323__$1);

return statearr_63334;
})();
if(inst_63325){
var statearr_63335_63347 = state_63332__$1;
(statearr_63335_63347[(1)] = (3));

} else {
var statearr_63336_63348 = state_63332__$1;
(statearr_63336_63348[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63333 === (3))){
var inst_63323 = (state_63332[(7)]);
var inst_63327 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_63323);
var state_63332__$1 = state_63332;
var statearr_63337_63349 = state_63332__$1;
(statearr_63337_63349[(2)] = inst_63327);

(statearr_63337_63349[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63333 === (4))){
var state_63332__$1 = state_63332;
var statearr_63338_63350 = state_63332__$1;
(statearr_63338_63350[(2)] = null);

(statearr_63338_63350[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63333 === (5))){
var inst_63330 = (state_63332[(2)]);
var state_63332__$1 = state_63332;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63332__$1,inst_63330);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2717__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2717__auto____0 = (function (){
var statearr_63339 = [null,null,null,null,null,null,null,null];
(statearr_63339[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2717__auto__);

(statearr_63339[(1)] = (1));

return statearr_63339;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2717__auto____1 = (function (state_63332){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_63332);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e63340){var ex__2720__auto__ = e63340;
var statearr_63341_63351 = state_63332;
(statearr_63341_63351[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_63332[(4)]))){
var statearr_63342_63352 = state_63332;
(statearr_63342_63352[(1)] = cljs.core.first((state_63332[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63353 = state_63332;
state_63332 = G__63353;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2717__auto__ = function(state_63332){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2717__auto____1.call(this,state_63332);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2717__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2717__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_63343 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_63343[(6)] = c__2739__auto__);

return statearr_63343;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

return c__2739__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_(syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var map__63354 = db;
var map__63354__$1 = cljs.core.__destructure_map(map__63354);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63354__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63354__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63354__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var listen_id = fluree.db.util.core.random_uuid();
var timeout = ((cljs.core.pos_int_QMARK_(syncTimeout))?(function (){var x__4298__auto__ = syncTimeout;
var y__4299__auto__ = (120000);
return ((x__4298__auto__ < y__4299__auto__) ? x__4298__auto__ : y__4299__auto__);
})():(60000));
var res_port = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,db);
} else {
fluree.db.api.ledger.syncTo_wait(db,syncTo,listen_id,res_port);

var c__2739__auto___63430 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_63404){
var state_val_63405 = (state_63404[(1)]);
if((state_val_63405 === (7))){
var inst_63370 = (state_63404[(7)]);
var inst_63381 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_63370,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_63404__$1 = state_63404;
if(inst_63381){
var statearr_63406_63431 = state_63404__$1;
(statearr_63406_63431[(1)] = (9));

} else {
var statearr_63407_63432 = state_63404__$1;
(statearr_63407_63432[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63405 === (1))){
var inst_63355 = (state_63404[(8)]);
var inst_63363 = (state_63404[(9)]);
var inst_63355__$1 = cljs.core.async.timeout(timeout);
var inst_63363__$1 = res_port;
var inst_63364 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63365 = [inst_63355__$1,inst_63363__$1];
var inst_63366 = (new cljs.core.PersistentVector(null,2,(5),inst_63364,inst_63365,null));
var state_63404__$1 = (function (){var statearr_63408 = state_63404;
(statearr_63408[(8)] = inst_63355__$1);

(statearr_63408[(9)] = inst_63363__$1);

return statearr_63408;
})();
return cljs.core.async.ioc_alts_BANG_(state_63404__$1,(2),inst_63366);
} else {
if((state_val_63405 === (4))){
var inst_63363 = (state_63404[(9)]);
var inst_63370 = (state_63404[(7)]);
var inst_63374 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_63370,inst_63363);
var state_63404__$1 = state_63404;
if(inst_63374){
var statearr_63409_63433 = state_63404__$1;
(statearr_63409_63433[(1)] = (6));

} else {
var statearr_63410_63434 = state_63404__$1;
(statearr_63410_63434[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63405 === (13))){
var inst_63389 = (state_63404[(10)]);
var inst_63400 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_63389);
var state_63404__$1 = state_63404;
var statearr_63411_63435 = state_63404__$1;
(statearr_63411_63435[(2)] = inst_63400);

(statearr_63411_63435[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63405 === (6))){
var inst_63368 = (state_63404[(11)]);
var inst_63379 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63368,(0),null);
var state_63404__$1 = state_63404;
var statearr_63412_63436 = state_63404__$1;
(statearr_63412_63436[(2)] = inst_63379);

(statearr_63412_63436[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63405 === (3))){
var state_63404__$1 = state_63404;
var statearr_63413_63437 = state_63404__$1;
(statearr_63413_63437[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_63413_63437[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63405 === (12))){
var inst_63393 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_63394 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63395 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_63396 = cljs.core.PersistentHashMap.fromArrays(inst_63394,inst_63395);
var inst_63397 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_63393,inst_63396);
var inst_63398 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_63397);
var state_63404__$1 = state_63404;
var statearr_63414_63438 = state_63404__$1;
(statearr_63414_63438[(2)] = inst_63398);

(statearr_63414_63438[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63405 === (2))){
var inst_63355 = (state_63404[(8)]);
var inst_63370 = (state_63404[(7)]);
var inst_63368 = (state_63404[(11)]);
var inst_63368__$1 = (state_63404[(2)]);
var inst_63369 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63368__$1,(0),null);
var inst_63370__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63368__$1,(1),null);
var inst_63371 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_63370__$1,inst_63355);
var state_63404__$1 = (function (){var statearr_63415 = state_63404;
(statearr_63415[(12)] = inst_63369);

(statearr_63415[(7)] = inst_63370__$1);

(statearr_63415[(11)] = inst_63368__$1);

return statearr_63415;
})();
if(inst_63371){
var statearr_63416_63439 = state_63404__$1;
(statearr_63416_63439[(1)] = (3));

} else {
var statearr_63417_63440 = state_63404__$1;
(statearr_63417_63440[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63405 === (11))){
var inst_63385 = (state_63404[(2)]);
var state_63404__$1 = state_63404;
var statearr_63418_63441 = state_63404__$1;
(statearr_63418_63441[(2)] = inst_63385);

(statearr_63418_63441[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63405 === (9))){
var inst_63369 = (state_63404[(12)]);
var state_63404__$1 = state_63404;
var statearr_63419_63442 = state_63404__$1;
(statearr_63419_63442[(2)] = inst_63369);

(statearr_63419_63442[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63405 === (5))){
var inst_63389 = (state_63404[(10)]);
var inst_63389__$1 = (state_63404[(2)]);
var inst_63390 = fluree.db.connection.remove_listener(conn,network,dbid,listen_id);
var inst_63391 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_63389__$1);
var state_63404__$1 = (function (){var statearr_63420 = state_63404;
(statearr_63420[(10)] = inst_63389__$1);

(statearr_63420[(13)] = inst_63390);

return statearr_63420;
})();
if(inst_63391){
var statearr_63421_63443 = state_63404__$1;
(statearr_63421_63443[(1)] = (12));

} else {
var statearr_63422_63444 = state_63404__$1;
(statearr_63422_63444[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63405 === (14))){
var inst_63402 = (state_63404[(2)]);
var state_63404__$1 = state_63404;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63404__$1,inst_63402);
} else {
if((state_val_63405 === (10))){
var state_63404__$1 = state_63404;
var statearr_63423_63445 = state_63404__$1;
(statearr_63423_63445[(2)] = null);

(statearr_63423_63445[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63405 === (8))){
var inst_63387 = (state_63404[(2)]);
var state_63404__$1 = state_63404;
var statearr_63424_63446 = state_63404__$1;
(statearr_63424_63446[(2)] = inst_63387);

(statearr_63424_63446[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2717__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2717__auto____0 = (function (){
var statearr_63425 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63425[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2717__auto__);

(statearr_63425[(1)] = (1));

return statearr_63425;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2717__auto____1 = (function (state_63404){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_63404);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e63426){var ex__2720__auto__ = e63426;
var statearr_63427_63447 = state_63404;
(statearr_63427_63447[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_63404[(4)]))){
var statearr_63428_63448 = state_63404;
(statearr_63428_63448[(1)] = cljs.core.first((state_63404[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63449 = state_63404;
state_63404 = G__63449;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2717__auto__ = function(state_63404){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2717__auto____1.call(this,state_63404);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2717__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2717__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_63429 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_63429[(6)] = c__2739__auto___63430);

return statearr_63429;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__63451 = arguments.length;
switch (G__63451) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__63452){
var map__63453 = p__63452;
var map__63453__$1 = cljs.core.__destructure_map(map__63453);
var opts = map__63453__$1;
var roles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63453__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63453__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63453__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63453__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63453__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2739__auto___63542 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2740__auto__ = (function (){var switch__2716__auto__ = (function (state_63504){
var state_val_63505 = (state_63504[(1)]);
if((state_val_63505 === (7))){
var inst_63466 = (state_63504[(7)]);
var inst_63468 = fluree.db.api.ledger.syncTo_db(inst_63466,syncTo,syncTimeout);
var state_63504__$1 = state_63504;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63504__$1,(10),inst_63468);
} else {
if((state_val_63505 === (20))){
var inst_63490 = (state_63504[(8)]);
var state_63504__$1 = state_63504;
var statearr_63506_63543 = state_63504__$1;
(statearr_63506_63543[(2)] = inst_63490);

(statearr_63506_63543[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63505 === (1))){
var state_63504__$1 = state_63504;
var statearr_63507_63544 = state_63504__$1;
(statearr_63507_63544[(2)] = null);

(statearr_63507_63544[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63505 === (4))){
var inst_63454 = (state_63504[(2)]);
var inst_63455 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_63454);
var inst_63456 = cljs.core.async.close_BANG_(pc);
var state_63504__$1 = (function (){var statearr_63508 = state_63504;
(statearr_63508[(9)] = inst_63455);

return statearr_63508;
})();
var statearr_63509_63545 = state_63504__$1;
(statearr_63509_63545[(2)] = inst_63456);

(statearr_63509_63545[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63505 === (15))){
var inst_63482 = (state_63504[(10)]);
var inst_63484 = fluree.db.api.ledger.add_db_permissions(inst_63482,auth,roles);
var state_63504__$1 = state_63504;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63504__$1,(18),inst_63484);
} else {
if((state_val_63505 === (21))){
var inst_63498 = (state_63504[(2)]);
var inst_63499 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_63498);
var _ = (function (){var statearr_63510 = state_63504;
(statearr_63510[(4)] = cljs.core.rest((state_63504[(4)])));

return statearr_63510;
})();
var state_63504__$1 = state_63504;
var statearr_63511_63546 = state_63504__$1;
(statearr_63511_63546[(2)] = inst_63499);

(statearr_63511_63546[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63505 === (13))){
var inst_63482 = (state_63504[(2)]);
var state_63504__$1 = (function (){var statearr_63512 = state_63504;
(statearr_63512[(10)] = inst_63482);

return statearr_63512;
})();
if(cljs.core.truth_(roles)){
var statearr_63513_63547 = state_63504__$1;
(statearr_63513_63547[(1)] = (15));

} else {
var statearr_63514_63548 = state_63504__$1;
(statearr_63514_63548[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63505 === (22))){
var inst_63494 = (state_63504[(2)]);
var inst_63495 = fluree.db.util.async.throw_err(inst_63494);
var state_63504__$1 = state_63504;
var statearr_63515_63549 = state_63504__$1;
(statearr_63515_63549[(2)] = inst_63495);

(statearr_63515_63549[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63505 === (6))){
var inst_63465 = (state_63504[(2)]);
var inst_63466 = fluree.db.util.async.throw_err(inst_63465);
var state_63504__$1 = (function (){var statearr_63516 = state_63504;
(statearr_63516[(7)] = inst_63466);

return statearr_63516;
})();
if(cljs.core.truth_(syncTo)){
var statearr_63517_63550 = state_63504__$1;
(statearr_63517_63550[(1)] = (7));

} else {
var statearr_63518_63551 = state_63504__$1;
(statearr_63518_63551[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63505 === (17))){
var inst_63490 = (state_63504[(2)]);
var state_63504__$1 = (function (){var statearr_63519 = state_63504;
(statearr_63519[(8)] = inst_63490);

return statearr_63519;
})();
if(cljs.core.truth_(auth)){
var statearr_63520_63552 = state_63504__$1;
(statearr_63520_63552[(1)] = (19));

} else {
var statearr_63521_63553 = state_63504__$1;
(statearr_63521_63553[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63505 === (3))){
var inst_63502 = (state_63504[(2)]);
var state_63504__$1 = state_63504;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63504__$1,inst_63502);
} else {
if((state_val_63505 === (12))){
var inst_63474 = (state_63504[(11)]);
var state_63504__$1 = state_63504;
var statearr_63522_63554 = state_63504__$1;
(statearr_63522_63554[(2)] = inst_63474);

(statearr_63522_63554[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63505 === (2))){
var _ = (function (){var statearr_63523 = state_63504;
(statearr_63523[(4)] = cljs.core.cons((5),(state_63504[(4)])));

return statearr_63523;
})();
var inst_63463 = fluree.db.session.db(conn,ledger,opts_SINGLEQUOTE_);
var state_63504__$1 = state_63504;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63504__$1,(6),inst_63463);
} else {
if((state_val_63505 === (19))){
var inst_63490 = (state_63504[(8)]);
var inst_63492 = fluree.db.api.ledger.add_db_permissions(inst_63490,auth,roles);
var state_63504__$1 = state_63504;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63504__$1,(22),inst_63492);
} else {
if((state_val_63505 === (11))){
var inst_63474 = (state_63504[(11)]);
var inst_63476 = fluree.db.time_travel.as_of_block(inst_63474,block);
var state_63504__$1 = state_63504;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63504__$1,(14),inst_63476);
} else {
if((state_val_63505 === (9))){
var inst_63474 = (state_63504[(2)]);
var state_63504__$1 = (function (){var statearr_63525 = state_63504;
(statearr_63525[(11)] = inst_63474);

return statearr_63525;
})();
if(cljs.core.truth_(block)){
var statearr_63526_63555 = state_63504__$1;
(statearr_63526_63555[(1)] = (11));

} else {
var statearr_63527_63556 = state_63504__$1;
(statearr_63527_63556[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63505 === (5))){
var _ = (function (){var statearr_63528 = state_63504;
(statearr_63528[(4)] = cljs.core.rest((state_63504[(4)])));

return statearr_63528;
})();
var state_63504__$1 = state_63504;
var ex63524 = (state_63504__$1[(2)]);
var statearr_63529_63557 = state_63504__$1;
(statearr_63529_63557[(5)] = ex63524);


var statearr_63530_63558 = state_63504__$1;
(statearr_63530_63558[(1)] = (4));

(statearr_63530_63558[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63505 === (14))){
var inst_63478 = (state_63504[(2)]);
var inst_63479 = fluree.db.util.async.throw_err(inst_63478);
var state_63504__$1 = state_63504;
var statearr_63531_63559 = state_63504__$1;
(statearr_63531_63559[(2)] = inst_63479);

(statearr_63531_63559[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63505 === (16))){
var inst_63482 = (state_63504[(10)]);
var state_63504__$1 = state_63504;
var statearr_63532_63560 = state_63504__$1;
(statearr_63532_63560[(2)] = inst_63482);

(statearr_63532_63560[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63505 === (10))){
var inst_63470 = (state_63504[(2)]);
var inst_63471 = fluree.db.util.async.throw_err(inst_63470);
var state_63504__$1 = state_63504;
var statearr_63533_63561 = state_63504__$1;
(statearr_63533_63561[(2)] = inst_63471);

(statearr_63533_63561[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63505 === (18))){
var inst_63486 = (state_63504[(2)]);
var inst_63487 = fluree.db.util.async.throw_err(inst_63486);
var state_63504__$1 = state_63504;
var statearr_63534_63562 = state_63504__$1;
(statearr_63534_63562[(2)] = inst_63487);

(statearr_63534_63562[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63505 === (8))){
var inst_63466 = (state_63504[(7)]);
var state_63504__$1 = state_63504;
var statearr_63535_63563 = state_63504__$1;
(statearr_63535_63563[(2)] = inst_63466);

(statearr_63535_63563[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2717__auto__ = null;
var fluree$db$api$ledger$state_machine__2717__auto____0 = (function (){
var statearr_63536 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63536[(0)] = fluree$db$api$ledger$state_machine__2717__auto__);

(statearr_63536[(1)] = (1));

return statearr_63536;
});
var fluree$db$api$ledger$state_machine__2717__auto____1 = (function (state_63504){
while(true){
var ret_value__2718__auto__ = (function (){try{while(true){
var result__2719__auto__ = switch__2716__auto__(state_63504);
if(cljs.core.keyword_identical_QMARK_(result__2719__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2719__auto__;
}
break;
}
}catch (e63537){var ex__2720__auto__ = e63537;
var statearr_63538_63564 = state_63504;
(statearr_63538_63564[(2)] = ex__2720__auto__);


if(cljs.core.seq((state_63504[(4)]))){
var statearr_63539_63565 = state_63504;
(statearr_63539_63565[(1)] = cljs.core.first((state_63504[(4)])));

} else {
throw ex__2720__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2718__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63566 = state_63504;
state_63504 = G__63566;
continue;
} else {
return ret_value__2718__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2717__auto__ = function(state_63504){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2717__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2717__auto____1.call(this,state_63504);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2717__auto____0;
fluree$db$api$ledger$state_machine__2717__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2717__auto____1;
return fluree$db$api$ledger$state_machine__2717__auto__;
})()
})();
var state__2741__auto__ = (function (){var statearr_63540 = (f__2740__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2740__auto__.cljs$core$IFn$_invoke$arity$0() : f__2740__auto__.call(null));
(statearr_63540[(6)] = c__2739__auto___63542);

return statearr_63540;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2741__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

