// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__7714){
var vec__7715 = p__7714;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7715,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7715,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__7718 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7718,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7718,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7718,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7718,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7718,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5753__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5753__auto__)){
var name__$1 = temp__5753__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__7721 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7721,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7721,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7721,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7721,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7721,(4),null);
var vec__7724 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7724,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7724,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7724,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7724,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7724,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4212__auto__ = source;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4212__auto__ = line;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4212__auto__ = col;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4212__auto__ = name;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__7727 = segmap;
var map__7727__$1 = cljs.core.__destructure_map(map__7727);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7727__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7727__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7727__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7727__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7727__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__7729 = arguments.length;
switch (G__7729) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__7733 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__7737 = cljs.core.next(segs__$1);
var G__7738 = nrelseg;
var G__7739 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__7737;
relseg__$1 = G__7738;
result__$1 = G__7739;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7733,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7733,(1),null);
var G__7740 = (gline + (1));
var G__7741 = cljs.core.next(lines__$1);
var G__7742 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__7743 = result__$1;
gline = G__7740;
lines__$1 = G__7741;
relseg = G__7742;
result = G__7743;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__7745 = segmap;
var map__7745__$1 = cljs.core.__destructure_map(map__7745);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7745__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7745__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7745__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7745__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7745__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__7744_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__7744_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__7747 = arguments.length;
switch (G__7747) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__7751 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__7755 = cljs.core.next(segs__$1);
var G__7756 = nrelseg;
var G__7757 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__7755;
relseg__$1 = G__7756;
result__$1 = G__7757;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7751,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7751,(1),null);
var G__7758 = (gline + (1));
var G__7759 = cljs.core.next(lines__$1);
var G__7760 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__7761 = result__$1;
gline = G__7758;
lines__$1 = G__7759;
relseg = G__7760;
result = G__7761;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__7762){
var vec__7763 = p__7762;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7763,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7763,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7763,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7763,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7763,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__7766){
var vec__7767 = p__7766;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7767,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7767,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7767,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7767,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7767,(4),null);
var seg = vec__7767;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__7770){
var vec__7771 = p__7770;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7771,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7771,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7771,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7771,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7771,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4212__auto__ = name;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4212__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5751__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5751__auto__)){
var name = temp__5751__auto__;
var idx = (function (){var temp__5751__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5751__auto____$1)){
var idx = temp__5751__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__7777 = cljs.core.seq(infos);
var chunk__7778 = null;
var count__7779 = (0);
var i__7780 = (0);
while(true){
if((i__7780 < count__7779)){
var info = chunk__7778.cljs$core$IIndexed$_nth$arity$2(null,i__7780);
var segv_8131 = info__GT_segv(info,source_idx,line,col);
var gline_8132 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_8133 = cljs.core.count(cljs.core.deref(lines));
if((gline_8132 > (lc_8133 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__7777,chunk__7778,count__7779,i__7780,segv_8131,gline_8132,lc_8133,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_8132 - (lc_8133 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_8131], null));
});})(seq__7777,chunk__7778,count__7779,i__7780,segv_8131,gline_8132,lc_8133,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__7777,chunk__7778,count__7779,i__7780,segv_8131,gline_8132,lc_8133,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_8132], null),cljs.core.conj,segv_8131);
});})(seq__7777,chunk__7778,count__7779,i__7780,segv_8131,gline_8132,lc_8133,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__8134 = seq__7777;
var G__8135 = chunk__7778;
var G__8136 = count__7779;
var G__8137 = (i__7780 + (1));
seq__7777 = G__8134;
chunk__7778 = G__8135;
count__7779 = G__8136;
i__7780 = G__8137;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__7777);
if(temp__5753__auto__){
var seq__7777__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__7777__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__7777__$1);
var G__8138 = cljs.core.chunk_rest(seq__7777__$1);
var G__8139 = c__4638__auto__;
var G__8140 = cljs.core.count(c__4638__auto__);
var G__8141 = (0);
seq__7777 = G__8138;
chunk__7778 = G__8139;
count__7779 = G__8140;
i__7780 = G__8141;
continue;
} else {
var info = cljs.core.first(seq__7777__$1);
var segv_8142 = info__GT_segv(info,source_idx,line,col);
var gline_8143 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_8144 = cljs.core.count(cljs.core.deref(lines));
if((gline_8143 > (lc_8144 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__7777,chunk__7778,count__7779,i__7780,segv_8142,gline_8143,lc_8144,info,seq__7777__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_8143 - (lc_8144 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_8142], null));
});})(seq__7777,chunk__7778,count__7779,i__7780,segv_8142,gline_8143,lc_8144,info,seq__7777__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__7777,chunk__7778,count__7779,i__7780,segv_8142,gline_8143,lc_8144,info,seq__7777__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_8143], null),cljs.core.conj,segv_8142);
});})(seq__7777,chunk__7778,count__7779,i__7780,segv_8142,gline_8143,lc_8144,info,seq__7777__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__8145 = cljs.core.next(seq__7777__$1);
var G__8146 = null;
var G__8147 = (0);
var G__8148 = (0);
seq__7777 = G__8145;
chunk__7778 = G__8146;
count__7779 = G__8147;
i__7780 = G__8148;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__7781_8149 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__7782_8150 = null;
var count__7783_8151 = (0);
var i__7784_8152 = (0);
while(true){
if((i__7784_8152 < count__7783_8151)){
var vec__7957_8153 = chunk__7782_8150.cljs$core$IIndexed$_nth$arity$2(null,i__7784_8152);
var source_idx_8154 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7957_8153,(0),null);
var vec__7960_8155 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7957_8153,(1),null);
var __8156 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7960_8155,(0),null);
var lines_8157__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7960_8155,(1),null);
var seq__7963_8158 = cljs.core.seq(lines_8157__$1);
var chunk__7964_8159 = null;
var count__7965_8160 = (0);
var i__7966_8161 = (0);
while(true){
if((i__7966_8161 < count__7965_8160)){
var vec__8005_8162 = chunk__7964_8159.cljs$core$IIndexed$_nth$arity$2(null,i__7966_8161);
var line_8163 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8005_8162,(0),null);
var cols_8164 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8005_8162,(1),null);
var seq__8008_8165 = cljs.core.seq(cols_8164);
var chunk__8009_8166 = null;
var count__8010_8167 = (0);
var i__8011_8168 = (0);
while(true){
if((i__8011_8168 < count__8010_8167)){
var vec__8018_8169 = chunk__8009_8166.cljs$core$IIndexed$_nth$arity$2(null,i__8011_8168);
var col_8170 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8018_8169,(0),null);
var infos_8171 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8018_8169,(1),null);
encode_cols(infos_8171,source_idx_8154,line_8163,col_8170);


var G__8172 = seq__8008_8165;
var G__8173 = chunk__8009_8166;
var G__8174 = count__8010_8167;
var G__8175 = (i__8011_8168 + (1));
seq__8008_8165 = G__8172;
chunk__8009_8166 = G__8173;
count__8010_8167 = G__8174;
i__8011_8168 = G__8175;
continue;
} else {
var temp__5753__auto___8176 = cljs.core.seq(seq__8008_8165);
if(temp__5753__auto___8176){
var seq__8008_8177__$1 = temp__5753__auto___8176;
if(cljs.core.chunked_seq_QMARK_(seq__8008_8177__$1)){
var c__4638__auto___8178 = cljs.core.chunk_first(seq__8008_8177__$1);
var G__8179 = cljs.core.chunk_rest(seq__8008_8177__$1);
var G__8180 = c__4638__auto___8178;
var G__8181 = cljs.core.count(c__4638__auto___8178);
var G__8182 = (0);
seq__8008_8165 = G__8179;
chunk__8009_8166 = G__8180;
count__8010_8167 = G__8181;
i__8011_8168 = G__8182;
continue;
} else {
var vec__8021_8183 = cljs.core.first(seq__8008_8177__$1);
var col_8184 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8021_8183,(0),null);
var infos_8185 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8021_8183,(1),null);
encode_cols(infos_8185,source_idx_8154,line_8163,col_8184);


var G__8186 = cljs.core.next(seq__8008_8177__$1);
var G__8187 = null;
var G__8188 = (0);
var G__8189 = (0);
seq__8008_8165 = G__8186;
chunk__8009_8166 = G__8187;
count__8010_8167 = G__8188;
i__8011_8168 = G__8189;
continue;
}
} else {
}
}
break;
}


var G__8190 = seq__7963_8158;
var G__8191 = chunk__7964_8159;
var G__8192 = count__7965_8160;
var G__8193 = (i__7966_8161 + (1));
seq__7963_8158 = G__8190;
chunk__7964_8159 = G__8191;
count__7965_8160 = G__8192;
i__7966_8161 = G__8193;
continue;
} else {
var temp__5753__auto___8194 = cljs.core.seq(seq__7963_8158);
if(temp__5753__auto___8194){
var seq__7963_8195__$1 = temp__5753__auto___8194;
if(cljs.core.chunked_seq_QMARK_(seq__7963_8195__$1)){
var c__4638__auto___8196 = cljs.core.chunk_first(seq__7963_8195__$1);
var G__8197 = cljs.core.chunk_rest(seq__7963_8195__$1);
var G__8198 = c__4638__auto___8196;
var G__8199 = cljs.core.count(c__4638__auto___8196);
var G__8200 = (0);
seq__7963_8158 = G__8197;
chunk__7964_8159 = G__8198;
count__7965_8160 = G__8199;
i__7966_8161 = G__8200;
continue;
} else {
var vec__8024_8201 = cljs.core.first(seq__7963_8195__$1);
var line_8202 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8024_8201,(0),null);
var cols_8203 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8024_8201,(1),null);
var seq__8027_8204 = cljs.core.seq(cols_8203);
var chunk__8028_8205 = null;
var count__8029_8206 = (0);
var i__8030_8207 = (0);
while(true){
if((i__8030_8207 < count__8029_8206)){
var vec__8037_8208 = chunk__8028_8205.cljs$core$IIndexed$_nth$arity$2(null,i__8030_8207);
var col_8209 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8037_8208,(0),null);
var infos_8210 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8037_8208,(1),null);
encode_cols(infos_8210,source_idx_8154,line_8202,col_8209);


var G__8211 = seq__8027_8204;
var G__8212 = chunk__8028_8205;
var G__8213 = count__8029_8206;
var G__8214 = (i__8030_8207 + (1));
seq__8027_8204 = G__8211;
chunk__8028_8205 = G__8212;
count__8029_8206 = G__8213;
i__8030_8207 = G__8214;
continue;
} else {
var temp__5753__auto___8215__$1 = cljs.core.seq(seq__8027_8204);
if(temp__5753__auto___8215__$1){
var seq__8027_8216__$1 = temp__5753__auto___8215__$1;
if(cljs.core.chunked_seq_QMARK_(seq__8027_8216__$1)){
var c__4638__auto___8217 = cljs.core.chunk_first(seq__8027_8216__$1);
var G__8218 = cljs.core.chunk_rest(seq__8027_8216__$1);
var G__8219 = c__4638__auto___8217;
var G__8220 = cljs.core.count(c__4638__auto___8217);
var G__8221 = (0);
seq__8027_8204 = G__8218;
chunk__8028_8205 = G__8219;
count__8029_8206 = G__8220;
i__8030_8207 = G__8221;
continue;
} else {
var vec__8040_8222 = cljs.core.first(seq__8027_8216__$1);
var col_8223 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8040_8222,(0),null);
var infos_8224 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8040_8222,(1),null);
encode_cols(infos_8224,source_idx_8154,line_8202,col_8223);


var G__8225 = cljs.core.next(seq__8027_8216__$1);
var G__8226 = null;
var G__8227 = (0);
var G__8228 = (0);
seq__8027_8204 = G__8225;
chunk__8028_8205 = G__8226;
count__8029_8206 = G__8227;
i__8030_8207 = G__8228;
continue;
}
} else {
}
}
break;
}


var G__8229 = cljs.core.next(seq__7963_8195__$1);
var G__8230 = null;
var G__8231 = (0);
var G__8232 = (0);
seq__7963_8158 = G__8229;
chunk__7964_8159 = G__8230;
count__7965_8160 = G__8231;
i__7966_8161 = G__8232;
continue;
}
} else {
}
}
break;
}


var G__8233 = seq__7781_8149;
var G__8234 = chunk__7782_8150;
var G__8235 = count__7783_8151;
var G__8236 = (i__7784_8152 + (1));
seq__7781_8149 = G__8233;
chunk__7782_8150 = G__8234;
count__7783_8151 = G__8235;
i__7784_8152 = G__8236;
continue;
} else {
var temp__5753__auto___8237 = cljs.core.seq(seq__7781_8149);
if(temp__5753__auto___8237){
var seq__7781_8238__$1 = temp__5753__auto___8237;
if(cljs.core.chunked_seq_QMARK_(seq__7781_8238__$1)){
var c__4638__auto___8239 = cljs.core.chunk_first(seq__7781_8238__$1);
var G__8240 = cljs.core.chunk_rest(seq__7781_8238__$1);
var G__8241 = c__4638__auto___8239;
var G__8242 = cljs.core.count(c__4638__auto___8239);
var G__8243 = (0);
seq__7781_8149 = G__8240;
chunk__7782_8150 = G__8241;
count__7783_8151 = G__8242;
i__7784_8152 = G__8243;
continue;
} else {
var vec__8043_8244 = cljs.core.first(seq__7781_8238__$1);
var source_idx_8245 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8043_8244,(0),null);
var vec__8046_8246 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8043_8244,(1),null);
var __8247 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8046_8246,(0),null);
var lines_8248__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8046_8246,(1),null);
var seq__8049_8249 = cljs.core.seq(lines_8248__$1);
var chunk__8050_8250 = null;
var count__8051_8251 = (0);
var i__8052_8252 = (0);
while(true){
if((i__8052_8252 < count__8051_8251)){
var vec__8091_8253 = chunk__8050_8250.cljs$core$IIndexed$_nth$arity$2(null,i__8052_8252);
var line_8254 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8091_8253,(0),null);
var cols_8255 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8091_8253,(1),null);
var seq__8094_8256 = cljs.core.seq(cols_8255);
var chunk__8095_8257 = null;
var count__8096_8258 = (0);
var i__8097_8259 = (0);
while(true){
if((i__8097_8259 < count__8096_8258)){
var vec__8104_8260 = chunk__8095_8257.cljs$core$IIndexed$_nth$arity$2(null,i__8097_8259);
var col_8261 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8104_8260,(0),null);
var infos_8262 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8104_8260,(1),null);
encode_cols(infos_8262,source_idx_8245,line_8254,col_8261);


var G__8263 = seq__8094_8256;
var G__8264 = chunk__8095_8257;
var G__8265 = count__8096_8258;
var G__8266 = (i__8097_8259 + (1));
seq__8094_8256 = G__8263;
chunk__8095_8257 = G__8264;
count__8096_8258 = G__8265;
i__8097_8259 = G__8266;
continue;
} else {
var temp__5753__auto___8267__$1 = cljs.core.seq(seq__8094_8256);
if(temp__5753__auto___8267__$1){
var seq__8094_8268__$1 = temp__5753__auto___8267__$1;
if(cljs.core.chunked_seq_QMARK_(seq__8094_8268__$1)){
var c__4638__auto___8269 = cljs.core.chunk_first(seq__8094_8268__$1);
var G__8270 = cljs.core.chunk_rest(seq__8094_8268__$1);
var G__8271 = c__4638__auto___8269;
var G__8272 = cljs.core.count(c__4638__auto___8269);
var G__8273 = (0);
seq__8094_8256 = G__8270;
chunk__8095_8257 = G__8271;
count__8096_8258 = G__8272;
i__8097_8259 = G__8273;
continue;
} else {
var vec__8107_8274 = cljs.core.first(seq__8094_8268__$1);
var col_8275 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8107_8274,(0),null);
var infos_8276 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8107_8274,(1),null);
encode_cols(infos_8276,source_idx_8245,line_8254,col_8275);


var G__8277 = cljs.core.next(seq__8094_8268__$1);
var G__8278 = null;
var G__8279 = (0);
var G__8280 = (0);
seq__8094_8256 = G__8277;
chunk__8095_8257 = G__8278;
count__8096_8258 = G__8279;
i__8097_8259 = G__8280;
continue;
}
} else {
}
}
break;
}


var G__8281 = seq__8049_8249;
var G__8282 = chunk__8050_8250;
var G__8283 = count__8051_8251;
var G__8284 = (i__8052_8252 + (1));
seq__8049_8249 = G__8281;
chunk__8050_8250 = G__8282;
count__8051_8251 = G__8283;
i__8052_8252 = G__8284;
continue;
} else {
var temp__5753__auto___8285__$1 = cljs.core.seq(seq__8049_8249);
if(temp__5753__auto___8285__$1){
var seq__8049_8286__$1 = temp__5753__auto___8285__$1;
if(cljs.core.chunked_seq_QMARK_(seq__8049_8286__$1)){
var c__4638__auto___8287 = cljs.core.chunk_first(seq__8049_8286__$1);
var G__8288 = cljs.core.chunk_rest(seq__8049_8286__$1);
var G__8289 = c__4638__auto___8287;
var G__8290 = cljs.core.count(c__4638__auto___8287);
var G__8291 = (0);
seq__8049_8249 = G__8288;
chunk__8050_8250 = G__8289;
count__8051_8251 = G__8290;
i__8052_8252 = G__8291;
continue;
} else {
var vec__8110_8292 = cljs.core.first(seq__8049_8286__$1);
var line_8293 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8110_8292,(0),null);
var cols_8294 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8110_8292,(1),null);
var seq__8113_8295 = cljs.core.seq(cols_8294);
var chunk__8114_8296 = null;
var count__8115_8297 = (0);
var i__8116_8298 = (0);
while(true){
if((i__8116_8298 < count__8115_8297)){
var vec__8123_8299 = chunk__8114_8296.cljs$core$IIndexed$_nth$arity$2(null,i__8116_8298);
var col_8300 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8123_8299,(0),null);
var infos_8301 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8123_8299,(1),null);
encode_cols(infos_8301,source_idx_8245,line_8293,col_8300);


var G__8302 = seq__8113_8295;
var G__8303 = chunk__8114_8296;
var G__8304 = count__8115_8297;
var G__8305 = (i__8116_8298 + (1));
seq__8113_8295 = G__8302;
chunk__8114_8296 = G__8303;
count__8115_8297 = G__8304;
i__8116_8298 = G__8305;
continue;
} else {
var temp__5753__auto___8306__$2 = cljs.core.seq(seq__8113_8295);
if(temp__5753__auto___8306__$2){
var seq__8113_8307__$1 = temp__5753__auto___8306__$2;
if(cljs.core.chunked_seq_QMARK_(seq__8113_8307__$1)){
var c__4638__auto___8308 = cljs.core.chunk_first(seq__8113_8307__$1);
var G__8309 = cljs.core.chunk_rest(seq__8113_8307__$1);
var G__8310 = c__4638__auto___8308;
var G__8311 = cljs.core.count(c__4638__auto___8308);
var G__8312 = (0);
seq__8113_8295 = G__8309;
chunk__8114_8296 = G__8310;
count__8115_8297 = G__8311;
i__8116_8298 = G__8312;
continue;
} else {
var vec__8126_8313 = cljs.core.first(seq__8113_8307__$1);
var col_8314 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8126_8313,(0),null);
var infos_8315 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8126_8313,(1),null);
encode_cols(infos_8315,source_idx_8245,line_8293,col_8314);


var G__8316 = cljs.core.next(seq__8113_8307__$1);
var G__8317 = null;
var G__8318 = (0);
var G__8319 = (0);
seq__8113_8295 = G__8316;
chunk__8114_8296 = G__8317;
count__8115_8297 = G__8318;
i__8116_8298 = G__8319;
continue;
}
} else {
}
}
break;
}


var G__8320 = cljs.core.next(seq__8049_8286__$1);
var G__8321 = null;
var G__8322 = (0);
var G__8323 = (0);
seq__8049_8249 = G__8320;
chunk__8050_8250 = G__8321;
count__8051_8251 = G__8322;
i__8052_8252 = G__8323;
continue;
}
} else {
}
}
break;
}


var G__8324 = cljs.core.next(seq__7781_8238__$1);
var G__8325 = null;
var G__8326 = (0);
var G__8327 = (0);
seq__7781_8149 = G__8324;
chunk__7782_8150 = G__8325;
count__7783_8151 = G__8326;
i__7784_8152 = G__8327;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__8129 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__7774_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__7774_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__7775_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__7775_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__7776_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__7776_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__8130 = G__8129;
goog.object.set(G__8130,"sourcesContent",cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts)));

return G__8130;
} else {
return G__8129;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__8328 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8328,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8328,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__8331 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8331,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8331,(1),null);
var G__8336 = cljs.core.next(col_map_seq);
var G__8337 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__8331,col,infos,vec__8328,line,col_map){
return (function (v,p__8334){
var map__8335 = p__8334;
var map__8335__$1 = cljs.core.__destructure_map(map__8335);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8335__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8335__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__8331,col,infos,vec__8328,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__8336;
new_cols = G__8337;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__8338 = cljs.core.next(line_map_seq);
var G__8339 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__8338;
new_lines = G__8339;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__8340_8548 = cljs.core.seq(reverse_map);
var chunk__8341_8549 = null;
var count__8342_8550 = (0);
var i__8343_8551 = (0);
while(true){
if((i__8343_8551 < count__8342_8550)){
var vec__8446_8552 = chunk__8341_8549.cljs$core$IIndexed$_nth$arity$2(null,i__8343_8551);
var line_8553 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8446_8552,(0),null);
var columns_8554 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8446_8552,(1),null);
var seq__8449_8555 = cljs.core.seq(columns_8554);
var chunk__8450_8556 = null;
var count__8451_8557 = (0);
var i__8452_8558 = (0);
while(true){
if((i__8452_8558 < count__8451_8557)){
var vec__8475_8559 = chunk__8450_8556.cljs$core$IIndexed$_nth$arity$2(null,i__8452_8558);
var column_8560 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8475_8559,(0),null);
var column_info_8561 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8475_8559,(1),null);
var seq__8478_8562 = cljs.core.seq(column_info_8561);
var chunk__8479_8563 = null;
var count__8480_8564 = (0);
var i__8481_8565 = (0);
while(true){
if((i__8481_8565 < count__8480_8564)){
var map__8484_8566 = chunk__8479_8563.cljs$core$IIndexed$_nth$arity$2(null,i__8481_8565);
var map__8484_8567__$1 = cljs.core.__destructure_map(map__8484_8566);
var gline_8568 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8484_8567__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_8569 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8484_8567__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_8570 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8484_8567__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_8568], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__8478_8562,chunk__8479_8563,count__8480_8564,i__8481_8565,seq__8449_8555,chunk__8450_8556,count__8451_8557,i__8452_8558,seq__8340_8548,chunk__8341_8549,count__8342_8550,i__8343_8551,map__8484_8566,map__8484_8567__$1,gline_8568,gcol_8569,name_8570,vec__8475_8559,column_8560,column_info_8561,vec__8446_8552,line_8553,columns_8554,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_8569], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_8553,new cljs.core.Keyword(null,"col","col",-1959363084),column_8560,new cljs.core.Keyword(null,"name","name",1843675177),name_8570], null));
});})(seq__8478_8562,chunk__8479_8563,count__8480_8564,i__8481_8565,seq__8449_8555,chunk__8450_8556,count__8451_8557,i__8452_8558,seq__8340_8548,chunk__8341_8549,count__8342_8550,i__8343_8551,map__8484_8566,map__8484_8567__$1,gline_8568,gcol_8569,name_8570,vec__8475_8559,column_8560,column_info_8561,vec__8446_8552,line_8553,columns_8554,inverted))
,cljs.core.sorted_map()));


var G__8571 = seq__8478_8562;
var G__8572 = chunk__8479_8563;
var G__8573 = count__8480_8564;
var G__8574 = (i__8481_8565 + (1));
seq__8478_8562 = G__8571;
chunk__8479_8563 = G__8572;
count__8480_8564 = G__8573;
i__8481_8565 = G__8574;
continue;
} else {
var temp__5753__auto___8575 = cljs.core.seq(seq__8478_8562);
if(temp__5753__auto___8575){
var seq__8478_8576__$1 = temp__5753__auto___8575;
if(cljs.core.chunked_seq_QMARK_(seq__8478_8576__$1)){
var c__4638__auto___8577 = cljs.core.chunk_first(seq__8478_8576__$1);
var G__8578 = cljs.core.chunk_rest(seq__8478_8576__$1);
var G__8579 = c__4638__auto___8577;
var G__8580 = cljs.core.count(c__4638__auto___8577);
var G__8581 = (0);
seq__8478_8562 = G__8578;
chunk__8479_8563 = G__8579;
count__8480_8564 = G__8580;
i__8481_8565 = G__8581;
continue;
} else {
var map__8485_8582 = cljs.core.first(seq__8478_8576__$1);
var map__8485_8583__$1 = cljs.core.__destructure_map(map__8485_8582);
var gline_8584 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8485_8583__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_8585 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8485_8583__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_8586 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8485_8583__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_8584], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__8478_8562,chunk__8479_8563,count__8480_8564,i__8481_8565,seq__8449_8555,chunk__8450_8556,count__8451_8557,i__8452_8558,seq__8340_8548,chunk__8341_8549,count__8342_8550,i__8343_8551,map__8485_8582,map__8485_8583__$1,gline_8584,gcol_8585,name_8586,seq__8478_8576__$1,temp__5753__auto___8575,vec__8475_8559,column_8560,column_info_8561,vec__8446_8552,line_8553,columns_8554,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_8585], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_8553,new cljs.core.Keyword(null,"col","col",-1959363084),column_8560,new cljs.core.Keyword(null,"name","name",1843675177),name_8586], null));
});})(seq__8478_8562,chunk__8479_8563,count__8480_8564,i__8481_8565,seq__8449_8555,chunk__8450_8556,count__8451_8557,i__8452_8558,seq__8340_8548,chunk__8341_8549,count__8342_8550,i__8343_8551,map__8485_8582,map__8485_8583__$1,gline_8584,gcol_8585,name_8586,seq__8478_8576__$1,temp__5753__auto___8575,vec__8475_8559,column_8560,column_info_8561,vec__8446_8552,line_8553,columns_8554,inverted))
,cljs.core.sorted_map()));


var G__8587 = cljs.core.next(seq__8478_8576__$1);
var G__8588 = null;
var G__8589 = (0);
var G__8590 = (0);
seq__8478_8562 = G__8587;
chunk__8479_8563 = G__8588;
count__8480_8564 = G__8589;
i__8481_8565 = G__8590;
continue;
}
} else {
}
}
break;
}


var G__8591 = seq__8449_8555;
var G__8592 = chunk__8450_8556;
var G__8593 = count__8451_8557;
var G__8594 = (i__8452_8558 + (1));
seq__8449_8555 = G__8591;
chunk__8450_8556 = G__8592;
count__8451_8557 = G__8593;
i__8452_8558 = G__8594;
continue;
} else {
var temp__5753__auto___8595 = cljs.core.seq(seq__8449_8555);
if(temp__5753__auto___8595){
var seq__8449_8596__$1 = temp__5753__auto___8595;
if(cljs.core.chunked_seq_QMARK_(seq__8449_8596__$1)){
var c__4638__auto___8597 = cljs.core.chunk_first(seq__8449_8596__$1);
var G__8598 = cljs.core.chunk_rest(seq__8449_8596__$1);
var G__8599 = c__4638__auto___8597;
var G__8600 = cljs.core.count(c__4638__auto___8597);
var G__8601 = (0);
seq__8449_8555 = G__8598;
chunk__8450_8556 = G__8599;
count__8451_8557 = G__8600;
i__8452_8558 = G__8601;
continue;
} else {
var vec__8486_8602 = cljs.core.first(seq__8449_8596__$1);
var column_8603 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8486_8602,(0),null);
var column_info_8604 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8486_8602,(1),null);
var seq__8489_8605 = cljs.core.seq(column_info_8604);
var chunk__8490_8606 = null;
var count__8491_8607 = (0);
var i__8492_8608 = (0);
while(true){
if((i__8492_8608 < count__8491_8607)){
var map__8495_8609 = chunk__8490_8606.cljs$core$IIndexed$_nth$arity$2(null,i__8492_8608);
var map__8495_8610__$1 = cljs.core.__destructure_map(map__8495_8609);
var gline_8611 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8495_8610__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_8612 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8495_8610__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_8613 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8495_8610__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_8611], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__8489_8605,chunk__8490_8606,count__8491_8607,i__8492_8608,seq__8449_8555,chunk__8450_8556,count__8451_8557,i__8452_8558,seq__8340_8548,chunk__8341_8549,count__8342_8550,i__8343_8551,map__8495_8609,map__8495_8610__$1,gline_8611,gcol_8612,name_8613,vec__8486_8602,column_8603,column_info_8604,seq__8449_8596__$1,temp__5753__auto___8595,vec__8446_8552,line_8553,columns_8554,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_8612], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_8553,new cljs.core.Keyword(null,"col","col",-1959363084),column_8603,new cljs.core.Keyword(null,"name","name",1843675177),name_8613], null));
});})(seq__8489_8605,chunk__8490_8606,count__8491_8607,i__8492_8608,seq__8449_8555,chunk__8450_8556,count__8451_8557,i__8452_8558,seq__8340_8548,chunk__8341_8549,count__8342_8550,i__8343_8551,map__8495_8609,map__8495_8610__$1,gline_8611,gcol_8612,name_8613,vec__8486_8602,column_8603,column_info_8604,seq__8449_8596__$1,temp__5753__auto___8595,vec__8446_8552,line_8553,columns_8554,inverted))
,cljs.core.sorted_map()));


var G__8614 = seq__8489_8605;
var G__8615 = chunk__8490_8606;
var G__8616 = count__8491_8607;
var G__8617 = (i__8492_8608 + (1));
seq__8489_8605 = G__8614;
chunk__8490_8606 = G__8615;
count__8491_8607 = G__8616;
i__8492_8608 = G__8617;
continue;
} else {
var temp__5753__auto___8618__$1 = cljs.core.seq(seq__8489_8605);
if(temp__5753__auto___8618__$1){
var seq__8489_8619__$1 = temp__5753__auto___8618__$1;
if(cljs.core.chunked_seq_QMARK_(seq__8489_8619__$1)){
var c__4638__auto___8620 = cljs.core.chunk_first(seq__8489_8619__$1);
var G__8621 = cljs.core.chunk_rest(seq__8489_8619__$1);
var G__8622 = c__4638__auto___8620;
var G__8623 = cljs.core.count(c__4638__auto___8620);
var G__8624 = (0);
seq__8489_8605 = G__8621;
chunk__8490_8606 = G__8622;
count__8491_8607 = G__8623;
i__8492_8608 = G__8624;
continue;
} else {
var map__8496_8625 = cljs.core.first(seq__8489_8619__$1);
var map__8496_8626__$1 = cljs.core.__destructure_map(map__8496_8625);
var gline_8627 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8496_8626__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_8628 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8496_8626__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_8629 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8496_8626__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_8627], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__8489_8605,chunk__8490_8606,count__8491_8607,i__8492_8608,seq__8449_8555,chunk__8450_8556,count__8451_8557,i__8452_8558,seq__8340_8548,chunk__8341_8549,count__8342_8550,i__8343_8551,map__8496_8625,map__8496_8626__$1,gline_8627,gcol_8628,name_8629,seq__8489_8619__$1,temp__5753__auto___8618__$1,vec__8486_8602,column_8603,column_info_8604,seq__8449_8596__$1,temp__5753__auto___8595,vec__8446_8552,line_8553,columns_8554,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_8628], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_8553,new cljs.core.Keyword(null,"col","col",-1959363084),column_8603,new cljs.core.Keyword(null,"name","name",1843675177),name_8629], null));
});})(seq__8489_8605,chunk__8490_8606,count__8491_8607,i__8492_8608,seq__8449_8555,chunk__8450_8556,count__8451_8557,i__8452_8558,seq__8340_8548,chunk__8341_8549,count__8342_8550,i__8343_8551,map__8496_8625,map__8496_8626__$1,gline_8627,gcol_8628,name_8629,seq__8489_8619__$1,temp__5753__auto___8618__$1,vec__8486_8602,column_8603,column_info_8604,seq__8449_8596__$1,temp__5753__auto___8595,vec__8446_8552,line_8553,columns_8554,inverted))
,cljs.core.sorted_map()));


var G__8630 = cljs.core.next(seq__8489_8619__$1);
var G__8631 = null;
var G__8632 = (0);
var G__8633 = (0);
seq__8489_8605 = G__8630;
chunk__8490_8606 = G__8631;
count__8491_8607 = G__8632;
i__8492_8608 = G__8633;
continue;
}
} else {
}
}
break;
}


var G__8634 = cljs.core.next(seq__8449_8596__$1);
var G__8635 = null;
var G__8636 = (0);
var G__8637 = (0);
seq__8449_8555 = G__8634;
chunk__8450_8556 = G__8635;
count__8451_8557 = G__8636;
i__8452_8558 = G__8637;
continue;
}
} else {
}
}
break;
}


var G__8638 = seq__8340_8548;
var G__8639 = chunk__8341_8549;
var G__8640 = count__8342_8550;
var G__8641 = (i__8343_8551 + (1));
seq__8340_8548 = G__8638;
chunk__8341_8549 = G__8639;
count__8342_8550 = G__8640;
i__8343_8551 = G__8641;
continue;
} else {
var temp__5753__auto___8642 = cljs.core.seq(seq__8340_8548);
if(temp__5753__auto___8642){
var seq__8340_8643__$1 = temp__5753__auto___8642;
if(cljs.core.chunked_seq_QMARK_(seq__8340_8643__$1)){
var c__4638__auto___8644 = cljs.core.chunk_first(seq__8340_8643__$1);
var G__8645 = cljs.core.chunk_rest(seq__8340_8643__$1);
var G__8646 = c__4638__auto___8644;
var G__8647 = cljs.core.count(c__4638__auto___8644);
var G__8648 = (0);
seq__8340_8548 = G__8645;
chunk__8341_8549 = G__8646;
count__8342_8550 = G__8647;
i__8343_8551 = G__8648;
continue;
} else {
var vec__8497_8649 = cljs.core.first(seq__8340_8643__$1);
var line_8650 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8497_8649,(0),null);
var columns_8651 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8497_8649,(1),null);
var seq__8500_8652 = cljs.core.seq(columns_8651);
var chunk__8501_8653 = null;
var count__8502_8654 = (0);
var i__8503_8655 = (0);
while(true){
if((i__8503_8655 < count__8502_8654)){
var vec__8526_8656 = chunk__8501_8653.cljs$core$IIndexed$_nth$arity$2(null,i__8503_8655);
var column_8657 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8526_8656,(0),null);
var column_info_8658 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8526_8656,(1),null);
var seq__8529_8659 = cljs.core.seq(column_info_8658);
var chunk__8530_8660 = null;
var count__8531_8661 = (0);
var i__8532_8662 = (0);
while(true){
if((i__8532_8662 < count__8531_8661)){
var map__8535_8663 = chunk__8530_8660.cljs$core$IIndexed$_nth$arity$2(null,i__8532_8662);
var map__8535_8664__$1 = cljs.core.__destructure_map(map__8535_8663);
var gline_8665 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8535_8664__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_8666 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8535_8664__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_8667 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8535_8664__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_8665], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__8529_8659,chunk__8530_8660,count__8531_8661,i__8532_8662,seq__8500_8652,chunk__8501_8653,count__8502_8654,i__8503_8655,seq__8340_8548,chunk__8341_8549,count__8342_8550,i__8343_8551,map__8535_8663,map__8535_8664__$1,gline_8665,gcol_8666,name_8667,vec__8526_8656,column_8657,column_info_8658,vec__8497_8649,line_8650,columns_8651,seq__8340_8643__$1,temp__5753__auto___8642,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_8666], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_8650,new cljs.core.Keyword(null,"col","col",-1959363084),column_8657,new cljs.core.Keyword(null,"name","name",1843675177),name_8667], null));
});})(seq__8529_8659,chunk__8530_8660,count__8531_8661,i__8532_8662,seq__8500_8652,chunk__8501_8653,count__8502_8654,i__8503_8655,seq__8340_8548,chunk__8341_8549,count__8342_8550,i__8343_8551,map__8535_8663,map__8535_8664__$1,gline_8665,gcol_8666,name_8667,vec__8526_8656,column_8657,column_info_8658,vec__8497_8649,line_8650,columns_8651,seq__8340_8643__$1,temp__5753__auto___8642,inverted))
,cljs.core.sorted_map()));


var G__8668 = seq__8529_8659;
var G__8669 = chunk__8530_8660;
var G__8670 = count__8531_8661;
var G__8671 = (i__8532_8662 + (1));
seq__8529_8659 = G__8668;
chunk__8530_8660 = G__8669;
count__8531_8661 = G__8670;
i__8532_8662 = G__8671;
continue;
} else {
var temp__5753__auto___8672__$1 = cljs.core.seq(seq__8529_8659);
if(temp__5753__auto___8672__$1){
var seq__8529_8673__$1 = temp__5753__auto___8672__$1;
if(cljs.core.chunked_seq_QMARK_(seq__8529_8673__$1)){
var c__4638__auto___8674 = cljs.core.chunk_first(seq__8529_8673__$1);
var G__8675 = cljs.core.chunk_rest(seq__8529_8673__$1);
var G__8676 = c__4638__auto___8674;
var G__8677 = cljs.core.count(c__4638__auto___8674);
var G__8678 = (0);
seq__8529_8659 = G__8675;
chunk__8530_8660 = G__8676;
count__8531_8661 = G__8677;
i__8532_8662 = G__8678;
continue;
} else {
var map__8536_8679 = cljs.core.first(seq__8529_8673__$1);
var map__8536_8680__$1 = cljs.core.__destructure_map(map__8536_8679);
var gline_8681 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8536_8680__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_8682 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8536_8680__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_8683 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8536_8680__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_8681], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__8529_8659,chunk__8530_8660,count__8531_8661,i__8532_8662,seq__8500_8652,chunk__8501_8653,count__8502_8654,i__8503_8655,seq__8340_8548,chunk__8341_8549,count__8342_8550,i__8343_8551,map__8536_8679,map__8536_8680__$1,gline_8681,gcol_8682,name_8683,seq__8529_8673__$1,temp__5753__auto___8672__$1,vec__8526_8656,column_8657,column_info_8658,vec__8497_8649,line_8650,columns_8651,seq__8340_8643__$1,temp__5753__auto___8642,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_8682], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_8650,new cljs.core.Keyword(null,"col","col",-1959363084),column_8657,new cljs.core.Keyword(null,"name","name",1843675177),name_8683], null));
});})(seq__8529_8659,chunk__8530_8660,count__8531_8661,i__8532_8662,seq__8500_8652,chunk__8501_8653,count__8502_8654,i__8503_8655,seq__8340_8548,chunk__8341_8549,count__8342_8550,i__8343_8551,map__8536_8679,map__8536_8680__$1,gline_8681,gcol_8682,name_8683,seq__8529_8673__$1,temp__5753__auto___8672__$1,vec__8526_8656,column_8657,column_info_8658,vec__8497_8649,line_8650,columns_8651,seq__8340_8643__$1,temp__5753__auto___8642,inverted))
,cljs.core.sorted_map()));


var G__8684 = cljs.core.next(seq__8529_8673__$1);
var G__8685 = null;
var G__8686 = (0);
var G__8687 = (0);
seq__8529_8659 = G__8684;
chunk__8530_8660 = G__8685;
count__8531_8661 = G__8686;
i__8532_8662 = G__8687;
continue;
}
} else {
}
}
break;
}


var G__8688 = seq__8500_8652;
var G__8689 = chunk__8501_8653;
var G__8690 = count__8502_8654;
var G__8691 = (i__8503_8655 + (1));
seq__8500_8652 = G__8688;
chunk__8501_8653 = G__8689;
count__8502_8654 = G__8690;
i__8503_8655 = G__8691;
continue;
} else {
var temp__5753__auto___8692__$1 = cljs.core.seq(seq__8500_8652);
if(temp__5753__auto___8692__$1){
var seq__8500_8693__$1 = temp__5753__auto___8692__$1;
if(cljs.core.chunked_seq_QMARK_(seq__8500_8693__$1)){
var c__4638__auto___8694 = cljs.core.chunk_first(seq__8500_8693__$1);
var G__8695 = cljs.core.chunk_rest(seq__8500_8693__$1);
var G__8696 = c__4638__auto___8694;
var G__8697 = cljs.core.count(c__4638__auto___8694);
var G__8698 = (0);
seq__8500_8652 = G__8695;
chunk__8501_8653 = G__8696;
count__8502_8654 = G__8697;
i__8503_8655 = G__8698;
continue;
} else {
var vec__8537_8699 = cljs.core.first(seq__8500_8693__$1);
var column_8700 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8537_8699,(0),null);
var column_info_8701 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8537_8699,(1),null);
var seq__8540_8702 = cljs.core.seq(column_info_8701);
var chunk__8541_8703 = null;
var count__8542_8704 = (0);
var i__8543_8705 = (0);
while(true){
if((i__8543_8705 < count__8542_8704)){
var map__8546_8706 = chunk__8541_8703.cljs$core$IIndexed$_nth$arity$2(null,i__8543_8705);
var map__8546_8707__$1 = cljs.core.__destructure_map(map__8546_8706);
var gline_8708 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8546_8707__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_8709 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8546_8707__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_8710 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8546_8707__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_8708], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__8540_8702,chunk__8541_8703,count__8542_8704,i__8543_8705,seq__8500_8652,chunk__8501_8653,count__8502_8654,i__8503_8655,seq__8340_8548,chunk__8341_8549,count__8342_8550,i__8343_8551,map__8546_8706,map__8546_8707__$1,gline_8708,gcol_8709,name_8710,vec__8537_8699,column_8700,column_info_8701,seq__8500_8693__$1,temp__5753__auto___8692__$1,vec__8497_8649,line_8650,columns_8651,seq__8340_8643__$1,temp__5753__auto___8642,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_8709], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_8650,new cljs.core.Keyword(null,"col","col",-1959363084),column_8700,new cljs.core.Keyword(null,"name","name",1843675177),name_8710], null));
});})(seq__8540_8702,chunk__8541_8703,count__8542_8704,i__8543_8705,seq__8500_8652,chunk__8501_8653,count__8502_8654,i__8503_8655,seq__8340_8548,chunk__8341_8549,count__8342_8550,i__8343_8551,map__8546_8706,map__8546_8707__$1,gline_8708,gcol_8709,name_8710,vec__8537_8699,column_8700,column_info_8701,seq__8500_8693__$1,temp__5753__auto___8692__$1,vec__8497_8649,line_8650,columns_8651,seq__8340_8643__$1,temp__5753__auto___8642,inverted))
,cljs.core.sorted_map()));


var G__8711 = seq__8540_8702;
var G__8712 = chunk__8541_8703;
var G__8713 = count__8542_8704;
var G__8714 = (i__8543_8705 + (1));
seq__8540_8702 = G__8711;
chunk__8541_8703 = G__8712;
count__8542_8704 = G__8713;
i__8543_8705 = G__8714;
continue;
} else {
var temp__5753__auto___8715__$2 = cljs.core.seq(seq__8540_8702);
if(temp__5753__auto___8715__$2){
var seq__8540_8716__$1 = temp__5753__auto___8715__$2;
if(cljs.core.chunked_seq_QMARK_(seq__8540_8716__$1)){
var c__4638__auto___8717 = cljs.core.chunk_first(seq__8540_8716__$1);
var G__8718 = cljs.core.chunk_rest(seq__8540_8716__$1);
var G__8719 = c__4638__auto___8717;
var G__8720 = cljs.core.count(c__4638__auto___8717);
var G__8721 = (0);
seq__8540_8702 = G__8718;
chunk__8541_8703 = G__8719;
count__8542_8704 = G__8720;
i__8543_8705 = G__8721;
continue;
} else {
var map__8547_8722 = cljs.core.first(seq__8540_8716__$1);
var map__8547_8723__$1 = cljs.core.__destructure_map(map__8547_8722);
var gline_8724 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8547_8723__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_8725 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8547_8723__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_8726 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8547_8723__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_8724], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__8540_8702,chunk__8541_8703,count__8542_8704,i__8543_8705,seq__8500_8652,chunk__8501_8653,count__8502_8654,i__8503_8655,seq__8340_8548,chunk__8341_8549,count__8342_8550,i__8343_8551,map__8547_8722,map__8547_8723__$1,gline_8724,gcol_8725,name_8726,seq__8540_8716__$1,temp__5753__auto___8715__$2,vec__8537_8699,column_8700,column_info_8701,seq__8500_8693__$1,temp__5753__auto___8692__$1,vec__8497_8649,line_8650,columns_8651,seq__8340_8643__$1,temp__5753__auto___8642,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_8725], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_8650,new cljs.core.Keyword(null,"col","col",-1959363084),column_8700,new cljs.core.Keyword(null,"name","name",1843675177),name_8726], null));
});})(seq__8540_8702,chunk__8541_8703,count__8542_8704,i__8543_8705,seq__8500_8652,chunk__8501_8653,count__8502_8654,i__8503_8655,seq__8340_8548,chunk__8341_8549,count__8342_8550,i__8343_8551,map__8547_8722,map__8547_8723__$1,gline_8724,gcol_8725,name_8726,seq__8540_8716__$1,temp__5753__auto___8715__$2,vec__8537_8699,column_8700,column_info_8701,seq__8500_8693__$1,temp__5753__auto___8692__$1,vec__8497_8649,line_8650,columns_8651,seq__8340_8643__$1,temp__5753__auto___8642,inverted))
,cljs.core.sorted_map()));


var G__8727 = cljs.core.next(seq__8540_8716__$1);
var G__8728 = null;
var G__8729 = (0);
var G__8730 = (0);
seq__8540_8702 = G__8727;
chunk__8541_8703 = G__8728;
count__8542_8704 = G__8729;
i__8543_8705 = G__8730;
continue;
}
} else {
}
}
break;
}


var G__8731 = cljs.core.next(seq__8500_8693__$1);
var G__8732 = null;
var G__8733 = (0);
var G__8734 = (0);
seq__8500_8652 = G__8731;
chunk__8501_8653 = G__8732;
count__8502_8654 = G__8733;
i__8503_8655 = G__8734;
continue;
}
} else {
}
}
break;
}


var G__8735 = cljs.core.next(seq__8340_8643__$1);
var G__8736 = null;
var G__8737 = (0);
var G__8738 = (0);
seq__8340_8548 = G__8735;
chunk__8341_8549 = G__8736;
count__8342_8550 = G__8737;
i__8343_8551 = G__8738;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});
