// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__17364 = arguments.length;
switch (G__17364) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17365 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17365 = (function (f,blockable,meta17366){
this.f = f;
this.blockable = blockable;
this.meta17366 = meta17366;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async17365.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17367,meta17366__$1){
var self__ = this;
var _17367__$1 = this;
return (new cljs.core.async.t_cljs$core$async17365(self__.f,self__.blockable,meta17366__$1));
}));

(cljs.core.async.t_cljs$core$async17365.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17367){
var self__ = this;
var _17367__$1 = this;
return self__.meta17366;
}));

(cljs.core.async.t_cljs$core$async17365.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17365.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async17365.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async17365.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async17365.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta17366","meta17366",1620479721,null)], null);
}));

(cljs.core.async.t_cljs$core$async17365.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async17365.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17365");

(cljs.core.async.t_cljs$core$async17365.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async17365");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17365.
 */
cljs.core.async.__GT_t_cljs$core$async17365 = (function cljs$core$async$__GT_t_cljs$core$async17365(f__$1,blockable__$1,meta17366){
return (new cljs.core.async.t_cljs$core$async17365(f__$1,blockable__$1,meta17366));
});

}

return (new cljs.core.async.t_cljs$core$async17365(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__17371 = arguments.length;
switch (G__17371) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__17374 = arguments.length;
switch (G__17374) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__17377 = arguments.length;
switch (G__17377) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_17379 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_17379) : fn1.call(null,val_17379));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_17379) : fn1.call(null,val_17379));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__17381 = arguments.length;
switch (G__17381) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5751__auto__)){
var ret = temp__5751__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5751__auto__)){
var retb = temp__5751__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4695__auto___17383 = n;
var x_17384 = (0);
while(true){
if((x_17384 < n__4695__auto___17383)){
(a[x_17384] = x_17384);

var G__17385 = (x_17384 + (1));
x_17384 = G__17385;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17386 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17386 = (function (flag,meta17387){
this.flag = flag;
this.meta17387 = meta17387;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async17386.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17388,meta17387__$1){
var self__ = this;
var _17388__$1 = this;
return (new cljs.core.async.t_cljs$core$async17386(self__.flag,meta17387__$1));
}));

(cljs.core.async.t_cljs$core$async17386.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17388){
var self__ = this;
var _17388__$1 = this;
return self__.meta17387;
}));

(cljs.core.async.t_cljs$core$async17386.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17386.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async17386.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async17386.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async17386.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta17387","meta17387",-1340022937,null)], null);
}));

(cljs.core.async.t_cljs$core$async17386.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async17386.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17386");

(cljs.core.async.t_cljs$core$async17386.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async17386");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17386.
 */
cljs.core.async.__GT_t_cljs$core$async17386 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async17386(flag__$1,meta17387){
return (new cljs.core.async.t_cljs$core$async17386(flag__$1,meta17387));
});

}

return (new cljs.core.async.t_cljs$core$async17386(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17389 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17389 = (function (flag,cb,meta17390){
this.flag = flag;
this.cb = cb;
this.meta17390 = meta17390;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async17389.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17391,meta17390__$1){
var self__ = this;
var _17391__$1 = this;
return (new cljs.core.async.t_cljs$core$async17389(self__.flag,self__.cb,meta17390__$1));
}));

(cljs.core.async.t_cljs$core$async17389.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17391){
var self__ = this;
var _17391__$1 = this;
return self__.meta17390;
}));

(cljs.core.async.t_cljs$core$async17389.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17389.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async17389.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async17389.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async17389.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta17390","meta17390",222724006,null)], null);
}));

(cljs.core.async.t_cljs$core$async17389.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async17389.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17389");

(cljs.core.async.t_cljs$core$async17389.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async17389");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17389.
 */
cljs.core.async.__GT_t_cljs$core$async17389 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async17389(flag__$1,cb__$1,meta17390){
return (new cljs.core.async.t_cljs$core$async17389(flag__$1,cb__$1,meta17390));
});

}

return (new cljs.core.async.t_cljs$core$async17389(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17392_SHARP_){
var G__17394 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17392_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__17394) : fret.call(null,G__17394));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17393_SHARP_){
var G__17395 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17393_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__17395) : fret.call(null,G__17395));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4212__auto__ = wport;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return port;
}
})()], null));
} else {
var G__17396 = (i + (1));
i = G__17396;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4212__auto__ = ret;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5753__auto__ = (function (){var and__4210__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4210__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4210__auto__;
}
})();
if(cljs.core.truth_(temp__5753__auto__)){
var got = temp__5753__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___17401 = arguments.length;
var i__4819__auto___17402 = (0);
while(true){
if((i__4819__auto___17402 < len__4818__auto___17401)){
args__4824__auto__.push((arguments[i__4819__auto___17402]));

var G__17403 = (i__4819__auto___17402 + (1));
i__4819__auto___17402 = G__17403;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__17399){
var map__17400 = p__17399;
var map__17400__$1 = cljs.core.__destructure_map(map__17400);
var opts = map__17400__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq17397){
var G__17398 = cljs.core.first(seq17397);
var seq17397__$1 = cljs.core.next(seq17397);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__17398,seq17397__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__17405 = arguments.length;
switch (G__17405) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__17304__auto___17452 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_17429){
var state_val_17430 = (state_17429[(1)]);
if((state_val_17430 === (7))){
var inst_17425 = (state_17429[(2)]);
var state_17429__$1 = state_17429;
var statearr_17431_17453 = state_17429__$1;
(statearr_17431_17453[(2)] = inst_17425);

(statearr_17431_17453[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17430 === (1))){
var state_17429__$1 = state_17429;
var statearr_17432_17454 = state_17429__$1;
(statearr_17432_17454[(2)] = null);

(statearr_17432_17454[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17430 === (4))){
var inst_17408 = (state_17429[(7)]);
var inst_17408__$1 = (state_17429[(2)]);
var inst_17409 = (inst_17408__$1 == null);
var state_17429__$1 = (function (){var statearr_17433 = state_17429;
(statearr_17433[(7)] = inst_17408__$1);

return statearr_17433;
})();
if(cljs.core.truth_(inst_17409)){
var statearr_17434_17455 = state_17429__$1;
(statearr_17434_17455[(1)] = (5));

} else {
var statearr_17435_17456 = state_17429__$1;
(statearr_17435_17456[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17430 === (13))){
var state_17429__$1 = state_17429;
var statearr_17436_17457 = state_17429__$1;
(statearr_17436_17457[(2)] = null);

(statearr_17436_17457[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17430 === (6))){
var inst_17408 = (state_17429[(7)]);
var state_17429__$1 = state_17429;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17429__$1,(11),to,inst_17408);
} else {
if((state_val_17430 === (3))){
var inst_17427 = (state_17429[(2)]);
var state_17429__$1 = state_17429;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17429__$1,inst_17427);
} else {
if((state_val_17430 === (12))){
var state_17429__$1 = state_17429;
var statearr_17437_17458 = state_17429__$1;
(statearr_17437_17458[(2)] = null);

(statearr_17437_17458[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17430 === (2))){
var state_17429__$1 = state_17429;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17429__$1,(4),from);
} else {
if((state_val_17430 === (11))){
var inst_17418 = (state_17429[(2)]);
var state_17429__$1 = state_17429;
if(cljs.core.truth_(inst_17418)){
var statearr_17438_17459 = state_17429__$1;
(statearr_17438_17459[(1)] = (12));

} else {
var statearr_17439_17460 = state_17429__$1;
(statearr_17439_17460[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17430 === (9))){
var state_17429__$1 = state_17429;
var statearr_17440_17461 = state_17429__$1;
(statearr_17440_17461[(2)] = null);

(statearr_17440_17461[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17430 === (5))){
var state_17429__$1 = state_17429;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17441_17462 = state_17429__$1;
(statearr_17441_17462[(1)] = (8));

} else {
var statearr_17442_17463 = state_17429__$1;
(statearr_17442_17463[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17430 === (14))){
var inst_17423 = (state_17429[(2)]);
var state_17429__$1 = state_17429;
var statearr_17443_17464 = state_17429__$1;
(statearr_17443_17464[(2)] = inst_17423);

(statearr_17443_17464[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17430 === (10))){
var inst_17415 = (state_17429[(2)]);
var state_17429__$1 = state_17429;
var statearr_17444_17465 = state_17429__$1;
(statearr_17444_17465[(2)] = inst_17415);

(statearr_17444_17465[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17430 === (8))){
var inst_17412 = cljs.core.async.close_BANG_(to);
var state_17429__$1 = state_17429;
var statearr_17445_17466 = state_17429__$1;
(statearr_17445_17466[(2)] = inst_17412);

(statearr_17445_17466[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__17178__auto__ = null;
var cljs$core$async$state_machine__17178__auto____0 = (function (){
var statearr_17446 = [null,null,null,null,null,null,null,null];
(statearr_17446[(0)] = cljs$core$async$state_machine__17178__auto__);

(statearr_17446[(1)] = (1));

return statearr_17446;
});
var cljs$core$async$state_machine__17178__auto____1 = (function (state_17429){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_17429);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e17447){var ex__17181__auto__ = e17447;
var statearr_17448_17467 = state_17429;
(statearr_17448_17467[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_17429[(4)]))){
var statearr_17449_17468 = state_17429;
(statearr_17449_17468[(1)] = cljs.core.first((state_17429[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17469 = state_17429;
state_17429 = G__17469;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$state_machine__17178__auto__ = function(state_17429){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17178__auto____1.call(this,state_17429);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17178__auto____0;
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17178__auto____1;
return cljs$core$async$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_17450 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_17450[(6)] = c__17304__auto___17452);

return statearr_17450;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__17470){
var vec__17471 = p__17470;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17471,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17471,(1),null);
var job = vec__17471;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__17304__auto___17647 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_17478){
var state_val_17479 = (state_17478[(1)]);
if((state_val_17479 === (1))){
var state_17478__$1 = state_17478;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17478__$1,(2),res,v);
} else {
if((state_val_17479 === (2))){
var inst_17475 = (state_17478[(2)]);
var inst_17476 = cljs.core.async.close_BANG_(res);
var state_17478__$1 = (function (){var statearr_17480 = state_17478;
(statearr_17480[(7)] = inst_17475);

return statearr_17480;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_17478__$1,inst_17476);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____0 = (function (){
var statearr_17481 = [null,null,null,null,null,null,null,null];
(statearr_17481[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__);

(statearr_17481[(1)] = (1));

return statearr_17481;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____1 = (function (state_17478){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_17478);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e17482){var ex__17181__auto__ = e17482;
var statearr_17483_17648 = state_17478;
(statearr_17483_17648[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_17478[(4)]))){
var statearr_17484_17649 = state_17478;
(statearr_17484_17649[(1)] = cljs.core.first((state_17478[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17650 = state_17478;
state_17478 = G__17650;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__ = function(state_17478){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____1.call(this,state_17478);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_17485 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_17485[(6)] = c__17304__auto___17647);

return statearr_17485;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__17486){
var vec__17487 = p__17486;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17487,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17487,(1),null);
var job = vec__17487;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4695__auto___17651 = n;
var __17652 = (0);
while(true){
if((__17652 < n__4695__auto___17651)){
var G__17490_17653 = type;
var G__17490_17654__$1 = (((G__17490_17653 instanceof cljs.core.Keyword))?G__17490_17653.fqn:null);
switch (G__17490_17654__$1) {
case "compute":
var c__17304__auto___17656 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__17652,c__17304__auto___17656,G__17490_17653,G__17490_17654__$1,n__4695__auto___17651,jobs,results,process,async){
return (function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = ((function (__17652,c__17304__auto___17656,G__17490_17653,G__17490_17654__$1,n__4695__auto___17651,jobs,results,process,async){
return (function (state_17503){
var state_val_17504 = (state_17503[(1)]);
if((state_val_17504 === (1))){
var state_17503__$1 = state_17503;
var statearr_17505_17657 = state_17503__$1;
(statearr_17505_17657[(2)] = null);

(statearr_17505_17657[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17504 === (2))){
var state_17503__$1 = state_17503;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17503__$1,(4),jobs);
} else {
if((state_val_17504 === (3))){
var inst_17501 = (state_17503[(2)]);
var state_17503__$1 = state_17503;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17503__$1,inst_17501);
} else {
if((state_val_17504 === (4))){
var inst_17493 = (state_17503[(2)]);
var inst_17494 = process(inst_17493);
var state_17503__$1 = state_17503;
if(cljs.core.truth_(inst_17494)){
var statearr_17506_17658 = state_17503__$1;
(statearr_17506_17658[(1)] = (5));

} else {
var statearr_17507_17659 = state_17503__$1;
(statearr_17507_17659[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17504 === (5))){
var state_17503__$1 = state_17503;
var statearr_17508_17660 = state_17503__$1;
(statearr_17508_17660[(2)] = null);

(statearr_17508_17660[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17504 === (6))){
var state_17503__$1 = state_17503;
var statearr_17509_17661 = state_17503__$1;
(statearr_17509_17661[(2)] = null);

(statearr_17509_17661[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17504 === (7))){
var inst_17499 = (state_17503[(2)]);
var state_17503__$1 = state_17503;
var statearr_17510_17662 = state_17503__$1;
(statearr_17510_17662[(2)] = inst_17499);

(statearr_17510_17662[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17652,c__17304__auto___17656,G__17490_17653,G__17490_17654__$1,n__4695__auto___17651,jobs,results,process,async))
;
return ((function (__17652,switch__17177__auto__,c__17304__auto___17656,G__17490_17653,G__17490_17654__$1,n__4695__auto___17651,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____0 = (function (){
var statearr_17511 = [null,null,null,null,null,null,null];
(statearr_17511[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__);

(statearr_17511[(1)] = (1));

return statearr_17511;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____1 = (function (state_17503){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_17503);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e17512){var ex__17181__auto__ = e17512;
var statearr_17513_17663 = state_17503;
(statearr_17513_17663[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_17503[(4)]))){
var statearr_17514_17664 = state_17503;
(statearr_17514_17664[(1)] = cljs.core.first((state_17503[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17665 = state_17503;
state_17503 = G__17665;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__ = function(state_17503){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____1.call(this,state_17503);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__;
})()
;})(__17652,switch__17177__auto__,c__17304__auto___17656,G__17490_17653,G__17490_17654__$1,n__4695__auto___17651,jobs,results,process,async))
})();
var state__17306__auto__ = (function (){var statearr_17515 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_17515[(6)] = c__17304__auto___17656);

return statearr_17515;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
});})(__17652,c__17304__auto___17656,G__17490_17653,G__17490_17654__$1,n__4695__auto___17651,jobs,results,process,async))
);


break;
case "async":
var c__17304__auto___17666 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__17652,c__17304__auto___17666,G__17490_17653,G__17490_17654__$1,n__4695__auto___17651,jobs,results,process,async){
return (function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = ((function (__17652,c__17304__auto___17666,G__17490_17653,G__17490_17654__$1,n__4695__auto___17651,jobs,results,process,async){
return (function (state_17528){
var state_val_17529 = (state_17528[(1)]);
if((state_val_17529 === (1))){
var state_17528__$1 = state_17528;
var statearr_17530_17667 = state_17528__$1;
(statearr_17530_17667[(2)] = null);

(statearr_17530_17667[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17529 === (2))){
var state_17528__$1 = state_17528;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17528__$1,(4),jobs);
} else {
if((state_val_17529 === (3))){
var inst_17526 = (state_17528[(2)]);
var state_17528__$1 = state_17528;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17528__$1,inst_17526);
} else {
if((state_val_17529 === (4))){
var inst_17518 = (state_17528[(2)]);
var inst_17519 = async(inst_17518);
var state_17528__$1 = state_17528;
if(cljs.core.truth_(inst_17519)){
var statearr_17531_17668 = state_17528__$1;
(statearr_17531_17668[(1)] = (5));

} else {
var statearr_17532_17669 = state_17528__$1;
(statearr_17532_17669[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17529 === (5))){
var state_17528__$1 = state_17528;
var statearr_17533_17670 = state_17528__$1;
(statearr_17533_17670[(2)] = null);

(statearr_17533_17670[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17529 === (6))){
var state_17528__$1 = state_17528;
var statearr_17534_17671 = state_17528__$1;
(statearr_17534_17671[(2)] = null);

(statearr_17534_17671[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17529 === (7))){
var inst_17524 = (state_17528[(2)]);
var state_17528__$1 = state_17528;
var statearr_17535_17672 = state_17528__$1;
(statearr_17535_17672[(2)] = inst_17524);

(statearr_17535_17672[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17652,c__17304__auto___17666,G__17490_17653,G__17490_17654__$1,n__4695__auto___17651,jobs,results,process,async))
;
return ((function (__17652,switch__17177__auto__,c__17304__auto___17666,G__17490_17653,G__17490_17654__$1,n__4695__auto___17651,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____0 = (function (){
var statearr_17536 = [null,null,null,null,null,null,null];
(statearr_17536[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__);

(statearr_17536[(1)] = (1));

return statearr_17536;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____1 = (function (state_17528){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_17528);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e17537){var ex__17181__auto__ = e17537;
var statearr_17538_17673 = state_17528;
(statearr_17538_17673[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_17528[(4)]))){
var statearr_17539_17674 = state_17528;
(statearr_17539_17674[(1)] = cljs.core.first((state_17528[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17675 = state_17528;
state_17528 = G__17675;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__ = function(state_17528){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____1.call(this,state_17528);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__;
})()
;})(__17652,switch__17177__auto__,c__17304__auto___17666,G__17490_17653,G__17490_17654__$1,n__4695__auto___17651,jobs,results,process,async))
})();
var state__17306__auto__ = (function (){var statearr_17540 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_17540[(6)] = c__17304__auto___17666);

return statearr_17540;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
});})(__17652,c__17304__auto___17666,G__17490_17653,G__17490_17654__$1,n__4695__auto___17651,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__17490_17654__$1)].join('')));

}

var G__17676 = (__17652 + (1));
__17652 = G__17676;
continue;
} else {
}
break;
}

var c__17304__auto___17677 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_17562){
var state_val_17563 = (state_17562[(1)]);
if((state_val_17563 === (7))){
var inst_17558 = (state_17562[(2)]);
var state_17562__$1 = state_17562;
var statearr_17564_17678 = state_17562__$1;
(statearr_17564_17678[(2)] = inst_17558);

(statearr_17564_17678[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17563 === (1))){
var state_17562__$1 = state_17562;
var statearr_17565_17679 = state_17562__$1;
(statearr_17565_17679[(2)] = null);

(statearr_17565_17679[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17563 === (4))){
var inst_17543 = (state_17562[(7)]);
var inst_17543__$1 = (state_17562[(2)]);
var inst_17544 = (inst_17543__$1 == null);
var state_17562__$1 = (function (){var statearr_17566 = state_17562;
(statearr_17566[(7)] = inst_17543__$1);

return statearr_17566;
})();
if(cljs.core.truth_(inst_17544)){
var statearr_17567_17680 = state_17562__$1;
(statearr_17567_17680[(1)] = (5));

} else {
var statearr_17568_17681 = state_17562__$1;
(statearr_17568_17681[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17563 === (6))){
var inst_17543 = (state_17562[(7)]);
var inst_17548 = (state_17562[(8)]);
var inst_17548__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_17549 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17550 = [inst_17543,inst_17548__$1];
var inst_17551 = (new cljs.core.PersistentVector(null,2,(5),inst_17549,inst_17550,null));
var state_17562__$1 = (function (){var statearr_17569 = state_17562;
(statearr_17569[(8)] = inst_17548__$1);

return statearr_17569;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17562__$1,(8),jobs,inst_17551);
} else {
if((state_val_17563 === (3))){
var inst_17560 = (state_17562[(2)]);
var state_17562__$1 = state_17562;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17562__$1,inst_17560);
} else {
if((state_val_17563 === (2))){
var state_17562__$1 = state_17562;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17562__$1,(4),from);
} else {
if((state_val_17563 === (9))){
var inst_17555 = (state_17562[(2)]);
var state_17562__$1 = (function (){var statearr_17570 = state_17562;
(statearr_17570[(9)] = inst_17555);

return statearr_17570;
})();
var statearr_17571_17682 = state_17562__$1;
(statearr_17571_17682[(2)] = null);

(statearr_17571_17682[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17563 === (5))){
var inst_17546 = cljs.core.async.close_BANG_(jobs);
var state_17562__$1 = state_17562;
var statearr_17572_17683 = state_17562__$1;
(statearr_17572_17683[(2)] = inst_17546);

(statearr_17572_17683[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17563 === (8))){
var inst_17548 = (state_17562[(8)]);
var inst_17553 = (state_17562[(2)]);
var state_17562__$1 = (function (){var statearr_17573 = state_17562;
(statearr_17573[(10)] = inst_17553);

return statearr_17573;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17562__$1,(9),results,inst_17548);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____0 = (function (){
var statearr_17574 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17574[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__);

(statearr_17574[(1)] = (1));

return statearr_17574;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____1 = (function (state_17562){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_17562);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e17575){var ex__17181__auto__ = e17575;
var statearr_17576_17684 = state_17562;
(statearr_17576_17684[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_17562[(4)]))){
var statearr_17577_17685 = state_17562;
(statearr_17577_17685[(1)] = cljs.core.first((state_17562[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17686 = state_17562;
state_17562 = G__17686;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__ = function(state_17562){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____1.call(this,state_17562);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_17578 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_17578[(6)] = c__17304__auto___17677);

return statearr_17578;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_17616){
var state_val_17617 = (state_17616[(1)]);
if((state_val_17617 === (7))){
var inst_17612 = (state_17616[(2)]);
var state_17616__$1 = state_17616;
var statearr_17618_17687 = state_17616__$1;
(statearr_17618_17687[(2)] = inst_17612);

(statearr_17618_17687[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17617 === (20))){
var state_17616__$1 = state_17616;
var statearr_17619_17688 = state_17616__$1;
(statearr_17619_17688[(2)] = null);

(statearr_17619_17688[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17617 === (1))){
var state_17616__$1 = state_17616;
var statearr_17620_17689 = state_17616__$1;
(statearr_17620_17689[(2)] = null);

(statearr_17620_17689[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17617 === (4))){
var inst_17581 = (state_17616[(7)]);
var inst_17581__$1 = (state_17616[(2)]);
var inst_17582 = (inst_17581__$1 == null);
var state_17616__$1 = (function (){var statearr_17621 = state_17616;
(statearr_17621[(7)] = inst_17581__$1);

return statearr_17621;
})();
if(cljs.core.truth_(inst_17582)){
var statearr_17622_17690 = state_17616__$1;
(statearr_17622_17690[(1)] = (5));

} else {
var statearr_17623_17691 = state_17616__$1;
(statearr_17623_17691[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17617 === (15))){
var inst_17594 = (state_17616[(8)]);
var state_17616__$1 = state_17616;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17616__$1,(18),to,inst_17594);
} else {
if((state_val_17617 === (21))){
var inst_17607 = (state_17616[(2)]);
var state_17616__$1 = state_17616;
var statearr_17624_17692 = state_17616__$1;
(statearr_17624_17692[(2)] = inst_17607);

(statearr_17624_17692[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17617 === (13))){
var inst_17609 = (state_17616[(2)]);
var state_17616__$1 = (function (){var statearr_17625 = state_17616;
(statearr_17625[(9)] = inst_17609);

return statearr_17625;
})();
var statearr_17626_17693 = state_17616__$1;
(statearr_17626_17693[(2)] = null);

(statearr_17626_17693[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17617 === (6))){
var inst_17581 = (state_17616[(7)]);
var state_17616__$1 = state_17616;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17616__$1,(11),inst_17581);
} else {
if((state_val_17617 === (17))){
var inst_17602 = (state_17616[(2)]);
var state_17616__$1 = state_17616;
if(cljs.core.truth_(inst_17602)){
var statearr_17627_17694 = state_17616__$1;
(statearr_17627_17694[(1)] = (19));

} else {
var statearr_17628_17695 = state_17616__$1;
(statearr_17628_17695[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17617 === (3))){
var inst_17614 = (state_17616[(2)]);
var state_17616__$1 = state_17616;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17616__$1,inst_17614);
} else {
if((state_val_17617 === (12))){
var inst_17591 = (state_17616[(10)]);
var state_17616__$1 = state_17616;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17616__$1,(14),inst_17591);
} else {
if((state_val_17617 === (2))){
var state_17616__$1 = state_17616;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17616__$1,(4),results);
} else {
if((state_val_17617 === (19))){
var state_17616__$1 = state_17616;
var statearr_17629_17696 = state_17616__$1;
(statearr_17629_17696[(2)] = null);

(statearr_17629_17696[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17617 === (11))){
var inst_17591 = (state_17616[(2)]);
var state_17616__$1 = (function (){var statearr_17630 = state_17616;
(statearr_17630[(10)] = inst_17591);

return statearr_17630;
})();
var statearr_17631_17697 = state_17616__$1;
(statearr_17631_17697[(2)] = null);

(statearr_17631_17697[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17617 === (9))){
var state_17616__$1 = state_17616;
var statearr_17632_17698 = state_17616__$1;
(statearr_17632_17698[(2)] = null);

(statearr_17632_17698[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17617 === (5))){
var state_17616__$1 = state_17616;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17633_17699 = state_17616__$1;
(statearr_17633_17699[(1)] = (8));

} else {
var statearr_17634_17700 = state_17616__$1;
(statearr_17634_17700[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17617 === (14))){
var inst_17596 = (state_17616[(11)]);
var inst_17594 = (state_17616[(8)]);
var inst_17594__$1 = (state_17616[(2)]);
var inst_17595 = (inst_17594__$1 == null);
var inst_17596__$1 = cljs.core.not(inst_17595);
var state_17616__$1 = (function (){var statearr_17635 = state_17616;
(statearr_17635[(11)] = inst_17596__$1);

(statearr_17635[(8)] = inst_17594__$1);

return statearr_17635;
})();
if(inst_17596__$1){
var statearr_17636_17701 = state_17616__$1;
(statearr_17636_17701[(1)] = (15));

} else {
var statearr_17637_17702 = state_17616__$1;
(statearr_17637_17702[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17617 === (16))){
var inst_17596 = (state_17616[(11)]);
var state_17616__$1 = state_17616;
var statearr_17638_17703 = state_17616__$1;
(statearr_17638_17703[(2)] = inst_17596);

(statearr_17638_17703[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17617 === (10))){
var inst_17588 = (state_17616[(2)]);
var state_17616__$1 = state_17616;
var statearr_17639_17704 = state_17616__$1;
(statearr_17639_17704[(2)] = inst_17588);

(statearr_17639_17704[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17617 === (18))){
var inst_17599 = (state_17616[(2)]);
var state_17616__$1 = state_17616;
var statearr_17640_17705 = state_17616__$1;
(statearr_17640_17705[(2)] = inst_17599);

(statearr_17640_17705[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17617 === (8))){
var inst_17585 = cljs.core.async.close_BANG_(to);
var state_17616__$1 = state_17616;
var statearr_17641_17706 = state_17616__$1;
(statearr_17641_17706[(2)] = inst_17585);

(statearr_17641_17706[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____0 = (function (){
var statearr_17642 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17642[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__);

(statearr_17642[(1)] = (1));

return statearr_17642;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____1 = (function (state_17616){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_17616);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e17643){var ex__17181__auto__ = e17643;
var statearr_17644_17707 = state_17616;
(statearr_17644_17707[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_17616[(4)]))){
var statearr_17645_17708 = state_17616;
(statearr_17645_17708[(1)] = cljs.core.first((state_17616[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17709 = state_17616;
state_17616 = G__17709;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__ = function(state_17616){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____1.call(this,state_17616);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17178__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_17646 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_17646[(6)] = c__17304__auto__);

return statearr_17646;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__17711 = arguments.length;
switch (G__17711) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__17714 = arguments.length;
switch (G__17714) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__17717 = arguments.length;
switch (G__17717) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__17304__auto___17767 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_17743){
var state_val_17744 = (state_17743[(1)]);
if((state_val_17744 === (7))){
var inst_17739 = (state_17743[(2)]);
var state_17743__$1 = state_17743;
var statearr_17745_17768 = state_17743__$1;
(statearr_17745_17768[(2)] = inst_17739);

(statearr_17745_17768[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17744 === (1))){
var state_17743__$1 = state_17743;
var statearr_17746_17769 = state_17743__$1;
(statearr_17746_17769[(2)] = null);

(statearr_17746_17769[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17744 === (4))){
var inst_17720 = (state_17743[(7)]);
var inst_17720__$1 = (state_17743[(2)]);
var inst_17721 = (inst_17720__$1 == null);
var state_17743__$1 = (function (){var statearr_17747 = state_17743;
(statearr_17747[(7)] = inst_17720__$1);

return statearr_17747;
})();
if(cljs.core.truth_(inst_17721)){
var statearr_17748_17770 = state_17743__$1;
(statearr_17748_17770[(1)] = (5));

} else {
var statearr_17749_17771 = state_17743__$1;
(statearr_17749_17771[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17744 === (13))){
var state_17743__$1 = state_17743;
var statearr_17750_17772 = state_17743__$1;
(statearr_17750_17772[(2)] = null);

(statearr_17750_17772[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17744 === (6))){
var inst_17720 = (state_17743[(7)]);
var inst_17726 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_17720) : p.call(null,inst_17720));
var state_17743__$1 = state_17743;
if(cljs.core.truth_(inst_17726)){
var statearr_17751_17773 = state_17743__$1;
(statearr_17751_17773[(1)] = (9));

} else {
var statearr_17752_17774 = state_17743__$1;
(statearr_17752_17774[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17744 === (3))){
var inst_17741 = (state_17743[(2)]);
var state_17743__$1 = state_17743;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17743__$1,inst_17741);
} else {
if((state_val_17744 === (12))){
var state_17743__$1 = state_17743;
var statearr_17753_17775 = state_17743__$1;
(statearr_17753_17775[(2)] = null);

(statearr_17753_17775[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17744 === (2))){
var state_17743__$1 = state_17743;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17743__$1,(4),ch);
} else {
if((state_val_17744 === (11))){
var inst_17720 = (state_17743[(7)]);
var inst_17730 = (state_17743[(2)]);
var state_17743__$1 = state_17743;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17743__$1,(8),inst_17730,inst_17720);
} else {
if((state_val_17744 === (9))){
var state_17743__$1 = state_17743;
var statearr_17754_17776 = state_17743__$1;
(statearr_17754_17776[(2)] = tc);

(statearr_17754_17776[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17744 === (5))){
var inst_17723 = cljs.core.async.close_BANG_(tc);
var inst_17724 = cljs.core.async.close_BANG_(fc);
var state_17743__$1 = (function (){var statearr_17755 = state_17743;
(statearr_17755[(8)] = inst_17723);

return statearr_17755;
})();
var statearr_17756_17777 = state_17743__$1;
(statearr_17756_17777[(2)] = inst_17724);

(statearr_17756_17777[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17744 === (14))){
var inst_17737 = (state_17743[(2)]);
var state_17743__$1 = state_17743;
var statearr_17757_17778 = state_17743__$1;
(statearr_17757_17778[(2)] = inst_17737);

(statearr_17757_17778[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17744 === (10))){
var state_17743__$1 = state_17743;
var statearr_17758_17779 = state_17743__$1;
(statearr_17758_17779[(2)] = fc);

(statearr_17758_17779[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17744 === (8))){
var inst_17732 = (state_17743[(2)]);
var state_17743__$1 = state_17743;
if(cljs.core.truth_(inst_17732)){
var statearr_17759_17780 = state_17743__$1;
(statearr_17759_17780[(1)] = (12));

} else {
var statearr_17760_17781 = state_17743__$1;
(statearr_17760_17781[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__17178__auto__ = null;
var cljs$core$async$state_machine__17178__auto____0 = (function (){
var statearr_17761 = [null,null,null,null,null,null,null,null,null];
(statearr_17761[(0)] = cljs$core$async$state_machine__17178__auto__);

(statearr_17761[(1)] = (1));

return statearr_17761;
});
var cljs$core$async$state_machine__17178__auto____1 = (function (state_17743){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_17743);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e17762){var ex__17181__auto__ = e17762;
var statearr_17763_17782 = state_17743;
(statearr_17763_17782[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_17743[(4)]))){
var statearr_17764_17783 = state_17743;
(statearr_17764_17783[(1)] = cljs.core.first((state_17743[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17784 = state_17743;
state_17743 = G__17784;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$state_machine__17178__auto__ = function(state_17743){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17178__auto____1.call(this,state_17743);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17178__auto____0;
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17178__auto____1;
return cljs$core$async$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_17765 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_17765[(6)] = c__17304__auto___17767);

return statearr_17765;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_17806){
var state_val_17807 = (state_17806[(1)]);
if((state_val_17807 === (7))){
var inst_17802 = (state_17806[(2)]);
var state_17806__$1 = state_17806;
var statearr_17808_17827 = state_17806__$1;
(statearr_17808_17827[(2)] = inst_17802);

(statearr_17808_17827[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17807 === (1))){
var inst_17785 = init;
var inst_17786 = inst_17785;
var state_17806__$1 = (function (){var statearr_17809 = state_17806;
(statearr_17809[(7)] = inst_17786);

return statearr_17809;
})();
var statearr_17810_17828 = state_17806__$1;
(statearr_17810_17828[(2)] = null);

(statearr_17810_17828[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17807 === (4))){
var inst_17789 = (state_17806[(8)]);
var inst_17789__$1 = (state_17806[(2)]);
var inst_17790 = (inst_17789__$1 == null);
var state_17806__$1 = (function (){var statearr_17811 = state_17806;
(statearr_17811[(8)] = inst_17789__$1);

return statearr_17811;
})();
if(cljs.core.truth_(inst_17790)){
var statearr_17812_17829 = state_17806__$1;
(statearr_17812_17829[(1)] = (5));

} else {
var statearr_17813_17830 = state_17806__$1;
(statearr_17813_17830[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17807 === (6))){
var inst_17786 = (state_17806[(7)]);
var inst_17789 = (state_17806[(8)]);
var inst_17793 = (state_17806[(9)]);
var inst_17793__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_17786,inst_17789) : f.call(null,inst_17786,inst_17789));
var inst_17794 = cljs.core.reduced_QMARK_(inst_17793__$1);
var state_17806__$1 = (function (){var statearr_17814 = state_17806;
(statearr_17814[(9)] = inst_17793__$1);

return statearr_17814;
})();
if(inst_17794){
var statearr_17815_17831 = state_17806__$1;
(statearr_17815_17831[(1)] = (8));

} else {
var statearr_17816_17832 = state_17806__$1;
(statearr_17816_17832[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17807 === (3))){
var inst_17804 = (state_17806[(2)]);
var state_17806__$1 = state_17806;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17806__$1,inst_17804);
} else {
if((state_val_17807 === (2))){
var state_17806__$1 = state_17806;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17806__$1,(4),ch);
} else {
if((state_val_17807 === (9))){
var inst_17793 = (state_17806[(9)]);
var inst_17786 = inst_17793;
var state_17806__$1 = (function (){var statearr_17817 = state_17806;
(statearr_17817[(7)] = inst_17786);

return statearr_17817;
})();
var statearr_17818_17833 = state_17806__$1;
(statearr_17818_17833[(2)] = null);

(statearr_17818_17833[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17807 === (5))){
var inst_17786 = (state_17806[(7)]);
var state_17806__$1 = state_17806;
var statearr_17819_17834 = state_17806__$1;
(statearr_17819_17834[(2)] = inst_17786);

(statearr_17819_17834[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17807 === (10))){
var inst_17800 = (state_17806[(2)]);
var state_17806__$1 = state_17806;
var statearr_17820_17835 = state_17806__$1;
(statearr_17820_17835[(2)] = inst_17800);

(statearr_17820_17835[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17807 === (8))){
var inst_17793 = (state_17806[(9)]);
var inst_17796 = cljs.core.deref(inst_17793);
var state_17806__$1 = state_17806;
var statearr_17821_17836 = state_17806__$1;
(statearr_17821_17836[(2)] = inst_17796);

(statearr_17821_17836[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__17178__auto__ = null;
var cljs$core$async$reduce_$_state_machine__17178__auto____0 = (function (){
var statearr_17822 = [null,null,null,null,null,null,null,null,null,null];
(statearr_17822[(0)] = cljs$core$async$reduce_$_state_machine__17178__auto__);

(statearr_17822[(1)] = (1));

return statearr_17822;
});
var cljs$core$async$reduce_$_state_machine__17178__auto____1 = (function (state_17806){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_17806);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e17823){var ex__17181__auto__ = e17823;
var statearr_17824_17837 = state_17806;
(statearr_17824_17837[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_17806[(4)]))){
var statearr_17825_17838 = state_17806;
(statearr_17825_17838[(1)] = cljs.core.first((state_17806[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17839 = state_17806;
state_17806 = G__17839;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__17178__auto__ = function(state_17806){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__17178__auto____1.call(this,state_17806);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__17178__auto____0;
cljs$core$async$reduce_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__17178__auto____1;
return cljs$core$async$reduce_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_17826 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_17826[(6)] = c__17304__auto__);

return statearr_17826;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_17845){
var state_val_17846 = (state_17845[(1)]);
if((state_val_17846 === (1))){
var inst_17840 = cljs.core.async.reduce(f__$1,init,ch);
var state_17845__$1 = state_17845;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17845__$1,(2),inst_17840);
} else {
if((state_val_17846 === (2))){
var inst_17842 = (state_17845[(2)]);
var inst_17843 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_17842) : f__$1.call(null,inst_17842));
var state_17845__$1 = state_17845;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17845__$1,inst_17843);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__17178__auto__ = null;
var cljs$core$async$transduce_$_state_machine__17178__auto____0 = (function (){
var statearr_17847 = [null,null,null,null,null,null,null];
(statearr_17847[(0)] = cljs$core$async$transduce_$_state_machine__17178__auto__);

(statearr_17847[(1)] = (1));

return statearr_17847;
});
var cljs$core$async$transduce_$_state_machine__17178__auto____1 = (function (state_17845){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_17845);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e17848){var ex__17181__auto__ = e17848;
var statearr_17849_17852 = state_17845;
(statearr_17849_17852[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_17845[(4)]))){
var statearr_17850_17853 = state_17845;
(statearr_17850_17853[(1)] = cljs.core.first((state_17845[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17854 = state_17845;
state_17845 = G__17854;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__17178__auto__ = function(state_17845){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__17178__auto____1.call(this,state_17845);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__17178__auto____0;
cljs$core$async$transduce_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__17178__auto____1;
return cljs$core$async$transduce_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_17851 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_17851[(6)] = c__17304__auto__);

return statearr_17851;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__17856 = arguments.length;
switch (G__17856) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_17881){
var state_val_17882 = (state_17881[(1)]);
if((state_val_17882 === (7))){
var inst_17863 = (state_17881[(2)]);
var state_17881__$1 = state_17881;
var statearr_17883_17905 = state_17881__$1;
(statearr_17883_17905[(2)] = inst_17863);

(statearr_17883_17905[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17882 === (1))){
var inst_17857 = cljs.core.seq(coll);
var inst_17858 = inst_17857;
var state_17881__$1 = (function (){var statearr_17884 = state_17881;
(statearr_17884[(7)] = inst_17858);

return statearr_17884;
})();
var statearr_17885_17906 = state_17881__$1;
(statearr_17885_17906[(2)] = null);

(statearr_17885_17906[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17882 === (4))){
var inst_17858 = (state_17881[(7)]);
var inst_17861 = cljs.core.first(inst_17858);
var state_17881__$1 = state_17881;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17881__$1,(7),ch,inst_17861);
} else {
if((state_val_17882 === (13))){
var inst_17875 = (state_17881[(2)]);
var state_17881__$1 = state_17881;
var statearr_17886_17907 = state_17881__$1;
(statearr_17886_17907[(2)] = inst_17875);

(statearr_17886_17907[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17882 === (6))){
var inst_17866 = (state_17881[(2)]);
var state_17881__$1 = state_17881;
if(cljs.core.truth_(inst_17866)){
var statearr_17887_17908 = state_17881__$1;
(statearr_17887_17908[(1)] = (8));

} else {
var statearr_17888_17909 = state_17881__$1;
(statearr_17888_17909[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17882 === (3))){
var inst_17879 = (state_17881[(2)]);
var state_17881__$1 = state_17881;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17881__$1,inst_17879);
} else {
if((state_val_17882 === (12))){
var state_17881__$1 = state_17881;
var statearr_17889_17910 = state_17881__$1;
(statearr_17889_17910[(2)] = null);

(statearr_17889_17910[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17882 === (2))){
var inst_17858 = (state_17881[(7)]);
var state_17881__$1 = state_17881;
if(cljs.core.truth_(inst_17858)){
var statearr_17890_17911 = state_17881__$1;
(statearr_17890_17911[(1)] = (4));

} else {
var statearr_17891_17912 = state_17881__$1;
(statearr_17891_17912[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17882 === (11))){
var inst_17872 = cljs.core.async.close_BANG_(ch);
var state_17881__$1 = state_17881;
var statearr_17892_17913 = state_17881__$1;
(statearr_17892_17913[(2)] = inst_17872);

(statearr_17892_17913[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17882 === (9))){
var state_17881__$1 = state_17881;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17893_17914 = state_17881__$1;
(statearr_17893_17914[(1)] = (11));

} else {
var statearr_17894_17915 = state_17881__$1;
(statearr_17894_17915[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17882 === (5))){
var inst_17858 = (state_17881[(7)]);
var state_17881__$1 = state_17881;
var statearr_17895_17916 = state_17881__$1;
(statearr_17895_17916[(2)] = inst_17858);

(statearr_17895_17916[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17882 === (10))){
var inst_17877 = (state_17881[(2)]);
var state_17881__$1 = state_17881;
var statearr_17896_17917 = state_17881__$1;
(statearr_17896_17917[(2)] = inst_17877);

(statearr_17896_17917[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17882 === (8))){
var inst_17858 = (state_17881[(7)]);
var inst_17868 = cljs.core.next(inst_17858);
var inst_17858__$1 = inst_17868;
var state_17881__$1 = (function (){var statearr_17897 = state_17881;
(statearr_17897[(7)] = inst_17858__$1);

return statearr_17897;
})();
var statearr_17898_17918 = state_17881__$1;
(statearr_17898_17918[(2)] = null);

(statearr_17898_17918[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__17178__auto__ = null;
var cljs$core$async$state_machine__17178__auto____0 = (function (){
var statearr_17899 = [null,null,null,null,null,null,null,null];
(statearr_17899[(0)] = cljs$core$async$state_machine__17178__auto__);

(statearr_17899[(1)] = (1));

return statearr_17899;
});
var cljs$core$async$state_machine__17178__auto____1 = (function (state_17881){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_17881);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e17900){var ex__17181__auto__ = e17900;
var statearr_17901_17919 = state_17881;
(statearr_17901_17919[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_17881[(4)]))){
var statearr_17902_17920 = state_17881;
(statearr_17902_17920[(1)] = cljs.core.first((state_17881[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17921 = state_17881;
state_17881 = G__17921;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$state_machine__17178__auto__ = function(state_17881){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17178__auto____1.call(this,state_17881);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17178__auto____0;
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17178__auto____1;
return cljs$core$async$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_17903 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_17903[(6)] = c__17304__auto__);

return statearr_17903;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__17923 = arguments.length;
switch (G__17923) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_17925 = (function (_){
var x__4509__auto__ = (((_ == null))?null:_);
var m__4510__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4510__auto__.call(null,_));
} else {
var m__4508__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4508__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_17925(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_17926 = (function (m,ch,close_QMARK_){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4510__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4508__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4508__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_17926(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_17927 = (function (m,ch){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4510__auto__.call(null,m,ch));
} else {
var m__4508__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4508__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_17927(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_17928 = (function (m){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4510__auto__.call(null,m));
} else {
var m__4508__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4508__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_17928(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17929 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17929 = (function (ch,cs,meta17930){
this.ch = ch;
this.cs = cs;
this.meta17930 = meta17930;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async17929.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17931,meta17930__$1){
var self__ = this;
var _17931__$1 = this;
return (new cljs.core.async.t_cljs$core$async17929(self__.ch,self__.cs,meta17930__$1));
}));

(cljs.core.async.t_cljs$core$async17929.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17931){
var self__ = this;
var _17931__$1 = this;
return self__.meta17930;
}));

(cljs.core.async.t_cljs$core$async17929.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17929.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async17929.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async17929.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async17929.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async17929.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async17929.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta17930","meta17930",-8708681,null)], null);
}));

(cljs.core.async.t_cljs$core$async17929.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async17929.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17929");

(cljs.core.async.t_cljs$core$async17929.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async17929");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17929.
 */
cljs.core.async.__GT_t_cljs$core$async17929 = (function cljs$core$async$mult_$___GT_t_cljs$core$async17929(ch__$1,cs__$1,meta17930){
return (new cljs.core.async.t_cljs$core$async17929(ch__$1,cs__$1,meta17930));
});

}

return (new cljs.core.async.t_cljs$core$async17929(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__17304__auto___18148 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_18064){
var state_val_18065 = (state_18064[(1)]);
if((state_val_18065 === (7))){
var inst_18060 = (state_18064[(2)]);
var state_18064__$1 = state_18064;
var statearr_18066_18149 = state_18064__$1;
(statearr_18066_18149[(2)] = inst_18060);

(statearr_18066_18149[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (20))){
var inst_17965 = (state_18064[(7)]);
var inst_17977 = cljs.core.first(inst_17965);
var inst_17978 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17977,(0),null);
var inst_17979 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17977,(1),null);
var state_18064__$1 = (function (){var statearr_18067 = state_18064;
(statearr_18067[(8)] = inst_17978);

return statearr_18067;
})();
if(cljs.core.truth_(inst_17979)){
var statearr_18068_18150 = state_18064__$1;
(statearr_18068_18150[(1)] = (22));

} else {
var statearr_18069_18151 = state_18064__$1;
(statearr_18069_18151[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (27))){
var inst_18009 = (state_18064[(9)]);
var inst_18014 = (state_18064[(10)]);
var inst_18007 = (state_18064[(11)]);
var inst_17934 = (state_18064[(12)]);
var inst_18014__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_18007,inst_18009);
var inst_18015 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_18014__$1,inst_17934,done);
var state_18064__$1 = (function (){var statearr_18070 = state_18064;
(statearr_18070[(10)] = inst_18014__$1);

return statearr_18070;
})();
if(cljs.core.truth_(inst_18015)){
var statearr_18071_18152 = state_18064__$1;
(statearr_18071_18152[(1)] = (30));

} else {
var statearr_18072_18153 = state_18064__$1;
(statearr_18072_18153[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (1))){
var state_18064__$1 = state_18064;
var statearr_18073_18154 = state_18064__$1;
(statearr_18073_18154[(2)] = null);

(statearr_18073_18154[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (24))){
var inst_17965 = (state_18064[(7)]);
var inst_17984 = (state_18064[(2)]);
var inst_17985 = cljs.core.next(inst_17965);
var inst_17943 = inst_17985;
var inst_17944 = null;
var inst_17945 = (0);
var inst_17946 = (0);
var state_18064__$1 = (function (){var statearr_18074 = state_18064;
(statearr_18074[(13)] = inst_17984);

(statearr_18074[(14)] = inst_17945);

(statearr_18074[(15)] = inst_17946);

(statearr_18074[(16)] = inst_17943);

(statearr_18074[(17)] = inst_17944);

return statearr_18074;
})();
var statearr_18075_18155 = state_18064__$1;
(statearr_18075_18155[(2)] = null);

(statearr_18075_18155[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (39))){
var state_18064__$1 = state_18064;
var statearr_18079_18156 = state_18064__$1;
(statearr_18079_18156[(2)] = null);

(statearr_18079_18156[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (4))){
var inst_17934 = (state_18064[(12)]);
var inst_17934__$1 = (state_18064[(2)]);
var inst_17935 = (inst_17934__$1 == null);
var state_18064__$1 = (function (){var statearr_18080 = state_18064;
(statearr_18080[(12)] = inst_17934__$1);

return statearr_18080;
})();
if(cljs.core.truth_(inst_17935)){
var statearr_18081_18157 = state_18064__$1;
(statearr_18081_18157[(1)] = (5));

} else {
var statearr_18082_18158 = state_18064__$1;
(statearr_18082_18158[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (15))){
var inst_17945 = (state_18064[(14)]);
var inst_17946 = (state_18064[(15)]);
var inst_17943 = (state_18064[(16)]);
var inst_17944 = (state_18064[(17)]);
var inst_17961 = (state_18064[(2)]);
var inst_17962 = (inst_17946 + (1));
var tmp18076 = inst_17945;
var tmp18077 = inst_17943;
var tmp18078 = inst_17944;
var inst_17943__$1 = tmp18077;
var inst_17944__$1 = tmp18078;
var inst_17945__$1 = tmp18076;
var inst_17946__$1 = inst_17962;
var state_18064__$1 = (function (){var statearr_18083 = state_18064;
(statearr_18083[(14)] = inst_17945__$1);

(statearr_18083[(18)] = inst_17961);

(statearr_18083[(15)] = inst_17946__$1);

(statearr_18083[(16)] = inst_17943__$1);

(statearr_18083[(17)] = inst_17944__$1);

return statearr_18083;
})();
var statearr_18084_18159 = state_18064__$1;
(statearr_18084_18159[(2)] = null);

(statearr_18084_18159[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (21))){
var inst_17988 = (state_18064[(2)]);
var state_18064__$1 = state_18064;
var statearr_18088_18160 = state_18064__$1;
(statearr_18088_18160[(2)] = inst_17988);

(statearr_18088_18160[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (31))){
var inst_18014 = (state_18064[(10)]);
var inst_18018 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_18014);
var state_18064__$1 = state_18064;
var statearr_18089_18161 = state_18064__$1;
(statearr_18089_18161[(2)] = inst_18018);

(statearr_18089_18161[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (32))){
var inst_18008 = (state_18064[(19)]);
var inst_18009 = (state_18064[(9)]);
var inst_18007 = (state_18064[(11)]);
var inst_18006 = (state_18064[(20)]);
var inst_18020 = (state_18064[(2)]);
var inst_18021 = (inst_18009 + (1));
var tmp18085 = inst_18008;
var tmp18086 = inst_18007;
var tmp18087 = inst_18006;
var inst_18006__$1 = tmp18087;
var inst_18007__$1 = tmp18086;
var inst_18008__$1 = tmp18085;
var inst_18009__$1 = inst_18021;
var state_18064__$1 = (function (){var statearr_18090 = state_18064;
(statearr_18090[(19)] = inst_18008__$1);

(statearr_18090[(9)] = inst_18009__$1);

(statearr_18090[(11)] = inst_18007__$1);

(statearr_18090[(21)] = inst_18020);

(statearr_18090[(20)] = inst_18006__$1);

return statearr_18090;
})();
var statearr_18091_18162 = state_18064__$1;
(statearr_18091_18162[(2)] = null);

(statearr_18091_18162[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (40))){
var inst_18033 = (state_18064[(22)]);
var inst_18037 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_18033);
var state_18064__$1 = state_18064;
var statearr_18092_18163 = state_18064__$1;
(statearr_18092_18163[(2)] = inst_18037);

(statearr_18092_18163[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (33))){
var inst_18024 = (state_18064[(23)]);
var inst_18026 = cljs.core.chunked_seq_QMARK_(inst_18024);
var state_18064__$1 = state_18064;
if(inst_18026){
var statearr_18093_18164 = state_18064__$1;
(statearr_18093_18164[(1)] = (36));

} else {
var statearr_18094_18165 = state_18064__$1;
(statearr_18094_18165[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (13))){
var inst_17955 = (state_18064[(24)]);
var inst_17958 = cljs.core.async.close_BANG_(inst_17955);
var state_18064__$1 = state_18064;
var statearr_18095_18166 = state_18064__$1;
(statearr_18095_18166[(2)] = inst_17958);

(statearr_18095_18166[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (22))){
var inst_17978 = (state_18064[(8)]);
var inst_17981 = cljs.core.async.close_BANG_(inst_17978);
var state_18064__$1 = state_18064;
var statearr_18096_18167 = state_18064__$1;
(statearr_18096_18167[(2)] = inst_17981);

(statearr_18096_18167[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (36))){
var inst_18024 = (state_18064[(23)]);
var inst_18028 = cljs.core.chunk_first(inst_18024);
var inst_18029 = cljs.core.chunk_rest(inst_18024);
var inst_18030 = cljs.core.count(inst_18028);
var inst_18006 = inst_18029;
var inst_18007 = inst_18028;
var inst_18008 = inst_18030;
var inst_18009 = (0);
var state_18064__$1 = (function (){var statearr_18097 = state_18064;
(statearr_18097[(19)] = inst_18008);

(statearr_18097[(9)] = inst_18009);

(statearr_18097[(11)] = inst_18007);

(statearr_18097[(20)] = inst_18006);

return statearr_18097;
})();
var statearr_18098_18168 = state_18064__$1;
(statearr_18098_18168[(2)] = null);

(statearr_18098_18168[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (41))){
var inst_18024 = (state_18064[(23)]);
var inst_18039 = (state_18064[(2)]);
var inst_18040 = cljs.core.next(inst_18024);
var inst_18006 = inst_18040;
var inst_18007 = null;
var inst_18008 = (0);
var inst_18009 = (0);
var state_18064__$1 = (function (){var statearr_18099 = state_18064;
(statearr_18099[(19)] = inst_18008);

(statearr_18099[(9)] = inst_18009);

(statearr_18099[(11)] = inst_18007);

(statearr_18099[(25)] = inst_18039);

(statearr_18099[(20)] = inst_18006);

return statearr_18099;
})();
var statearr_18100_18169 = state_18064__$1;
(statearr_18100_18169[(2)] = null);

(statearr_18100_18169[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (43))){
var state_18064__$1 = state_18064;
var statearr_18101_18170 = state_18064__$1;
(statearr_18101_18170[(2)] = null);

(statearr_18101_18170[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (29))){
var inst_18048 = (state_18064[(2)]);
var state_18064__$1 = state_18064;
var statearr_18102_18171 = state_18064__$1;
(statearr_18102_18171[(2)] = inst_18048);

(statearr_18102_18171[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (44))){
var inst_18057 = (state_18064[(2)]);
var state_18064__$1 = (function (){var statearr_18103 = state_18064;
(statearr_18103[(26)] = inst_18057);

return statearr_18103;
})();
var statearr_18104_18172 = state_18064__$1;
(statearr_18104_18172[(2)] = null);

(statearr_18104_18172[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (6))){
var inst_17998 = (state_18064[(27)]);
var inst_17997 = cljs.core.deref(cs);
var inst_17998__$1 = cljs.core.keys(inst_17997);
var inst_17999 = cljs.core.count(inst_17998__$1);
var inst_18000 = cljs.core.reset_BANG_(dctr,inst_17999);
var inst_18005 = cljs.core.seq(inst_17998__$1);
var inst_18006 = inst_18005;
var inst_18007 = null;
var inst_18008 = (0);
var inst_18009 = (0);
var state_18064__$1 = (function (){var statearr_18105 = state_18064;
(statearr_18105[(19)] = inst_18008);

(statearr_18105[(9)] = inst_18009);

(statearr_18105[(27)] = inst_17998__$1);

(statearr_18105[(28)] = inst_18000);

(statearr_18105[(11)] = inst_18007);

(statearr_18105[(20)] = inst_18006);

return statearr_18105;
})();
var statearr_18106_18173 = state_18064__$1;
(statearr_18106_18173[(2)] = null);

(statearr_18106_18173[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (28))){
var inst_18024 = (state_18064[(23)]);
var inst_18006 = (state_18064[(20)]);
var inst_18024__$1 = cljs.core.seq(inst_18006);
var state_18064__$1 = (function (){var statearr_18107 = state_18064;
(statearr_18107[(23)] = inst_18024__$1);

return statearr_18107;
})();
if(inst_18024__$1){
var statearr_18108_18174 = state_18064__$1;
(statearr_18108_18174[(1)] = (33));

} else {
var statearr_18109_18175 = state_18064__$1;
(statearr_18109_18175[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (25))){
var inst_18008 = (state_18064[(19)]);
var inst_18009 = (state_18064[(9)]);
var inst_18011 = (inst_18009 < inst_18008);
var inst_18012 = inst_18011;
var state_18064__$1 = state_18064;
if(cljs.core.truth_(inst_18012)){
var statearr_18110_18176 = state_18064__$1;
(statearr_18110_18176[(1)] = (27));

} else {
var statearr_18111_18177 = state_18064__$1;
(statearr_18111_18177[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (34))){
var state_18064__$1 = state_18064;
var statearr_18112_18178 = state_18064__$1;
(statearr_18112_18178[(2)] = null);

(statearr_18112_18178[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (17))){
var state_18064__$1 = state_18064;
var statearr_18113_18179 = state_18064__$1;
(statearr_18113_18179[(2)] = null);

(statearr_18113_18179[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (3))){
var inst_18062 = (state_18064[(2)]);
var state_18064__$1 = state_18064;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18064__$1,inst_18062);
} else {
if((state_val_18065 === (12))){
var inst_17993 = (state_18064[(2)]);
var state_18064__$1 = state_18064;
var statearr_18114_18180 = state_18064__$1;
(statearr_18114_18180[(2)] = inst_17993);

(statearr_18114_18180[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (2))){
var state_18064__$1 = state_18064;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18064__$1,(4),ch);
} else {
if((state_val_18065 === (23))){
var state_18064__$1 = state_18064;
var statearr_18115_18181 = state_18064__$1;
(statearr_18115_18181[(2)] = null);

(statearr_18115_18181[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (35))){
var inst_18046 = (state_18064[(2)]);
var state_18064__$1 = state_18064;
var statearr_18116_18182 = state_18064__$1;
(statearr_18116_18182[(2)] = inst_18046);

(statearr_18116_18182[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (19))){
var inst_17965 = (state_18064[(7)]);
var inst_17969 = cljs.core.chunk_first(inst_17965);
var inst_17970 = cljs.core.chunk_rest(inst_17965);
var inst_17971 = cljs.core.count(inst_17969);
var inst_17943 = inst_17970;
var inst_17944 = inst_17969;
var inst_17945 = inst_17971;
var inst_17946 = (0);
var state_18064__$1 = (function (){var statearr_18117 = state_18064;
(statearr_18117[(14)] = inst_17945);

(statearr_18117[(15)] = inst_17946);

(statearr_18117[(16)] = inst_17943);

(statearr_18117[(17)] = inst_17944);

return statearr_18117;
})();
var statearr_18118_18183 = state_18064__$1;
(statearr_18118_18183[(2)] = null);

(statearr_18118_18183[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (11))){
var inst_17943 = (state_18064[(16)]);
var inst_17965 = (state_18064[(7)]);
var inst_17965__$1 = cljs.core.seq(inst_17943);
var state_18064__$1 = (function (){var statearr_18119 = state_18064;
(statearr_18119[(7)] = inst_17965__$1);

return statearr_18119;
})();
if(inst_17965__$1){
var statearr_18120_18184 = state_18064__$1;
(statearr_18120_18184[(1)] = (16));

} else {
var statearr_18121_18185 = state_18064__$1;
(statearr_18121_18185[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (9))){
var inst_17995 = (state_18064[(2)]);
var state_18064__$1 = state_18064;
var statearr_18122_18186 = state_18064__$1;
(statearr_18122_18186[(2)] = inst_17995);

(statearr_18122_18186[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (5))){
var inst_17941 = cljs.core.deref(cs);
var inst_17942 = cljs.core.seq(inst_17941);
var inst_17943 = inst_17942;
var inst_17944 = null;
var inst_17945 = (0);
var inst_17946 = (0);
var state_18064__$1 = (function (){var statearr_18123 = state_18064;
(statearr_18123[(14)] = inst_17945);

(statearr_18123[(15)] = inst_17946);

(statearr_18123[(16)] = inst_17943);

(statearr_18123[(17)] = inst_17944);

return statearr_18123;
})();
var statearr_18124_18187 = state_18064__$1;
(statearr_18124_18187[(2)] = null);

(statearr_18124_18187[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (14))){
var state_18064__$1 = state_18064;
var statearr_18125_18188 = state_18064__$1;
(statearr_18125_18188[(2)] = null);

(statearr_18125_18188[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (45))){
var inst_18054 = (state_18064[(2)]);
var state_18064__$1 = state_18064;
var statearr_18126_18189 = state_18064__$1;
(statearr_18126_18189[(2)] = inst_18054);

(statearr_18126_18189[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (26))){
var inst_17998 = (state_18064[(27)]);
var inst_18050 = (state_18064[(2)]);
var inst_18051 = cljs.core.seq(inst_17998);
var state_18064__$1 = (function (){var statearr_18127 = state_18064;
(statearr_18127[(29)] = inst_18050);

return statearr_18127;
})();
if(inst_18051){
var statearr_18128_18190 = state_18064__$1;
(statearr_18128_18190[(1)] = (42));

} else {
var statearr_18129_18191 = state_18064__$1;
(statearr_18129_18191[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (16))){
var inst_17965 = (state_18064[(7)]);
var inst_17967 = cljs.core.chunked_seq_QMARK_(inst_17965);
var state_18064__$1 = state_18064;
if(inst_17967){
var statearr_18130_18192 = state_18064__$1;
(statearr_18130_18192[(1)] = (19));

} else {
var statearr_18131_18193 = state_18064__$1;
(statearr_18131_18193[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (38))){
var inst_18043 = (state_18064[(2)]);
var state_18064__$1 = state_18064;
var statearr_18132_18194 = state_18064__$1;
(statearr_18132_18194[(2)] = inst_18043);

(statearr_18132_18194[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (30))){
var state_18064__$1 = state_18064;
var statearr_18133_18195 = state_18064__$1;
(statearr_18133_18195[(2)] = null);

(statearr_18133_18195[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (10))){
var inst_17946 = (state_18064[(15)]);
var inst_17944 = (state_18064[(17)]);
var inst_17954 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_17944,inst_17946);
var inst_17955 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17954,(0),null);
var inst_17956 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17954,(1),null);
var state_18064__$1 = (function (){var statearr_18134 = state_18064;
(statearr_18134[(24)] = inst_17955);

return statearr_18134;
})();
if(cljs.core.truth_(inst_17956)){
var statearr_18135_18196 = state_18064__$1;
(statearr_18135_18196[(1)] = (13));

} else {
var statearr_18136_18197 = state_18064__$1;
(statearr_18136_18197[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (18))){
var inst_17991 = (state_18064[(2)]);
var state_18064__$1 = state_18064;
var statearr_18137_18198 = state_18064__$1;
(statearr_18137_18198[(2)] = inst_17991);

(statearr_18137_18198[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (42))){
var state_18064__$1 = state_18064;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18064__$1,(45),dchan);
} else {
if((state_val_18065 === (37))){
var inst_18024 = (state_18064[(23)]);
var inst_18033 = (state_18064[(22)]);
var inst_17934 = (state_18064[(12)]);
var inst_18033__$1 = cljs.core.first(inst_18024);
var inst_18034 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_18033__$1,inst_17934,done);
var state_18064__$1 = (function (){var statearr_18138 = state_18064;
(statearr_18138[(22)] = inst_18033__$1);

return statearr_18138;
})();
if(cljs.core.truth_(inst_18034)){
var statearr_18139_18199 = state_18064__$1;
(statearr_18139_18199[(1)] = (39));

} else {
var statearr_18140_18200 = state_18064__$1;
(statearr_18140_18200[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18065 === (8))){
var inst_17945 = (state_18064[(14)]);
var inst_17946 = (state_18064[(15)]);
var inst_17948 = (inst_17946 < inst_17945);
var inst_17949 = inst_17948;
var state_18064__$1 = state_18064;
if(cljs.core.truth_(inst_17949)){
var statearr_18141_18201 = state_18064__$1;
(statearr_18141_18201[(1)] = (10));

} else {
var statearr_18142_18202 = state_18064__$1;
(statearr_18142_18202[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__17178__auto__ = null;
var cljs$core$async$mult_$_state_machine__17178__auto____0 = (function (){
var statearr_18143 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18143[(0)] = cljs$core$async$mult_$_state_machine__17178__auto__);

(statearr_18143[(1)] = (1));

return statearr_18143;
});
var cljs$core$async$mult_$_state_machine__17178__auto____1 = (function (state_18064){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_18064);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e18144){var ex__17181__auto__ = e18144;
var statearr_18145_18203 = state_18064;
(statearr_18145_18203[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_18064[(4)]))){
var statearr_18146_18204 = state_18064;
(statearr_18146_18204[(1)] = cljs.core.first((state_18064[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18205 = state_18064;
state_18064 = G__18205;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__17178__auto__ = function(state_18064){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__17178__auto____1.call(this,state_18064);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__17178__auto____0;
cljs$core$async$mult_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__17178__auto____1;
return cljs$core$async$mult_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_18147 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_18147[(6)] = c__17304__auto___18148);

return statearr_18147;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__18207 = arguments.length;
switch (G__18207) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_18209 = (function (m,ch){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4510__auto__.call(null,m,ch));
} else {
var m__4508__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4508__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_18209(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_18210 = (function (m,ch){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4510__auto__.call(null,m,ch));
} else {
var m__4508__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4508__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_18210(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_18211 = (function (m){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4510__auto__.call(null,m));
} else {
var m__4508__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4508__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_18211(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_18212 = (function (m,state_map){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4510__auto__.call(null,m,state_map));
} else {
var m__4508__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4508__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_18212(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_18213 = (function (m,mode){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4510__auto__.call(null,m,mode));
} else {
var m__4508__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4508__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_18213(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___18223 = arguments.length;
var i__4819__auto___18224 = (0);
while(true){
if((i__4819__auto___18224 < len__4818__auto___18223)){
args__4824__auto__.push((arguments[i__4819__auto___18224]));

var G__18225 = (i__4819__auto___18224 + (1));
i__4819__auto___18224 = G__18225;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((3) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4825__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__18218){
var map__18219 = p__18218;
var map__18219__$1 = cljs.core.__destructure_map(map__18219);
var opts = map__18219__$1;
var statearr_18220_18226 = state;
(statearr_18220_18226[(1)] = cont_block);


var temp__5753__auto__ = cljs.core.async.do_alts((function (val){
var statearr_18221_18227 = state;
(statearr_18221_18227[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5753__auto__)){
var cb = temp__5753__auto__;
var statearr_18222_18228 = state;
(statearr_18222_18228[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq18214){
var G__18215 = cljs.core.first(seq18214);
var seq18214__$1 = cljs.core.next(seq18214);
var G__18216 = cljs.core.first(seq18214__$1);
var seq18214__$2 = cljs.core.next(seq18214__$1);
var G__18217 = cljs.core.first(seq18214__$2);
var seq18214__$3 = cljs.core.next(seq18214__$2);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18215,G__18216,G__18217,seq18214__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async18229 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18229 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta18230){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta18230 = meta18230;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async18229.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18231,meta18230__$1){
var self__ = this;
var _18231__$1 = this;
return (new cljs.core.async.t_cljs$core$async18229(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta18230__$1));
}));

(cljs.core.async.t_cljs$core$async18229.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18231){
var self__ = this;
var _18231__$1 = this;
return self__.meta18230;
}));

(cljs.core.async.t_cljs$core$async18229.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async18229.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async18229.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async18229.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async18229.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async18229.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async18229.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async18229.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async18229.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta18230","meta18230",-1624689064,null)], null);
}));

(cljs.core.async.t_cljs$core$async18229.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async18229.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18229");

(cljs.core.async.t_cljs$core$async18229.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async18229");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async18229.
 */
cljs.core.async.__GT_t_cljs$core$async18229 = (function cljs$core$async$mix_$___GT_t_cljs$core$async18229(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18230){
return (new cljs.core.async.t_cljs$core$async18229(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18230));
});

}

return (new cljs.core.async.t_cljs$core$async18229(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__17304__auto___18344 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_18299){
var state_val_18300 = (state_18299[(1)]);
if((state_val_18300 === (7))){
var inst_18259 = (state_18299[(2)]);
var state_18299__$1 = state_18299;
if(cljs.core.truth_(inst_18259)){
var statearr_18301_18345 = state_18299__$1;
(statearr_18301_18345[(1)] = (8));

} else {
var statearr_18302_18346 = state_18299__$1;
(statearr_18302_18346[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18300 === (20))){
var inst_18252 = (state_18299[(7)]);
var state_18299__$1 = state_18299;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18299__$1,(23),out,inst_18252);
} else {
if((state_val_18300 === (1))){
var inst_18235 = calc_state();
var inst_18236 = cljs.core.__destructure_map(inst_18235);
var inst_18237 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18236,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_18238 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18236,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_18239 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18236,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_18240 = inst_18235;
var state_18299__$1 = (function (){var statearr_18303 = state_18299;
(statearr_18303[(8)] = inst_18240);

(statearr_18303[(9)] = inst_18238);

(statearr_18303[(10)] = inst_18239);

(statearr_18303[(11)] = inst_18237);

return statearr_18303;
})();
var statearr_18304_18347 = state_18299__$1;
(statearr_18304_18347[(2)] = null);

(statearr_18304_18347[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18300 === (24))){
var inst_18243 = (state_18299[(12)]);
var inst_18240 = inst_18243;
var state_18299__$1 = (function (){var statearr_18305 = state_18299;
(statearr_18305[(8)] = inst_18240);

return statearr_18305;
})();
var statearr_18306_18348 = state_18299__$1;
(statearr_18306_18348[(2)] = null);

(statearr_18306_18348[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18300 === (4))){
var inst_18252 = (state_18299[(7)]);
var inst_18254 = (state_18299[(13)]);
var inst_18251 = (state_18299[(2)]);
var inst_18252__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18251,(0),null);
var inst_18253 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18251,(1),null);
var inst_18254__$1 = (inst_18252__$1 == null);
var state_18299__$1 = (function (){var statearr_18307 = state_18299;
(statearr_18307[(7)] = inst_18252__$1);

(statearr_18307[(14)] = inst_18253);

(statearr_18307[(13)] = inst_18254__$1);

return statearr_18307;
})();
if(cljs.core.truth_(inst_18254__$1)){
var statearr_18308_18349 = state_18299__$1;
(statearr_18308_18349[(1)] = (5));

} else {
var statearr_18309_18350 = state_18299__$1;
(statearr_18309_18350[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18300 === (15))){
var inst_18244 = (state_18299[(15)]);
var inst_18273 = (state_18299[(16)]);
var inst_18273__$1 = cljs.core.empty_QMARK_(inst_18244);
var state_18299__$1 = (function (){var statearr_18310 = state_18299;
(statearr_18310[(16)] = inst_18273__$1);

return statearr_18310;
})();
if(inst_18273__$1){
var statearr_18311_18351 = state_18299__$1;
(statearr_18311_18351[(1)] = (17));

} else {
var statearr_18312_18352 = state_18299__$1;
(statearr_18312_18352[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18300 === (21))){
var inst_18243 = (state_18299[(12)]);
var inst_18240 = inst_18243;
var state_18299__$1 = (function (){var statearr_18313 = state_18299;
(statearr_18313[(8)] = inst_18240);

return statearr_18313;
})();
var statearr_18314_18353 = state_18299__$1;
(statearr_18314_18353[(2)] = null);

(statearr_18314_18353[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18300 === (13))){
var inst_18266 = (state_18299[(2)]);
var inst_18267 = calc_state();
var inst_18240 = inst_18267;
var state_18299__$1 = (function (){var statearr_18315 = state_18299;
(statearr_18315[(8)] = inst_18240);

(statearr_18315[(17)] = inst_18266);

return statearr_18315;
})();
var statearr_18316_18354 = state_18299__$1;
(statearr_18316_18354[(2)] = null);

(statearr_18316_18354[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18300 === (22))){
var inst_18293 = (state_18299[(2)]);
var state_18299__$1 = state_18299;
var statearr_18317_18355 = state_18299__$1;
(statearr_18317_18355[(2)] = inst_18293);

(statearr_18317_18355[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18300 === (6))){
var inst_18253 = (state_18299[(14)]);
var inst_18257 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_18253,change);
var state_18299__$1 = state_18299;
var statearr_18318_18356 = state_18299__$1;
(statearr_18318_18356[(2)] = inst_18257);

(statearr_18318_18356[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18300 === (25))){
var state_18299__$1 = state_18299;
var statearr_18319_18357 = state_18299__$1;
(statearr_18319_18357[(2)] = null);

(statearr_18319_18357[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18300 === (17))){
var inst_18253 = (state_18299[(14)]);
var inst_18245 = (state_18299[(18)]);
var inst_18275 = (inst_18245.cljs$core$IFn$_invoke$arity$1 ? inst_18245.cljs$core$IFn$_invoke$arity$1(inst_18253) : inst_18245.call(null,inst_18253));
var inst_18276 = cljs.core.not(inst_18275);
var state_18299__$1 = state_18299;
var statearr_18320_18358 = state_18299__$1;
(statearr_18320_18358[(2)] = inst_18276);

(statearr_18320_18358[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18300 === (3))){
var inst_18297 = (state_18299[(2)]);
var state_18299__$1 = state_18299;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18299__$1,inst_18297);
} else {
if((state_val_18300 === (12))){
var state_18299__$1 = state_18299;
var statearr_18321_18359 = state_18299__$1;
(statearr_18321_18359[(2)] = null);

(statearr_18321_18359[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18300 === (2))){
var inst_18240 = (state_18299[(8)]);
var inst_18243 = (state_18299[(12)]);
var inst_18243__$1 = cljs.core.__destructure_map(inst_18240);
var inst_18244 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18243__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_18245 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18243__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_18246 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18243__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_18299__$1 = (function (){var statearr_18322 = state_18299;
(statearr_18322[(12)] = inst_18243__$1);

(statearr_18322[(15)] = inst_18244);

(statearr_18322[(18)] = inst_18245);

return statearr_18322;
})();
return cljs.core.async.ioc_alts_BANG_(state_18299__$1,(4),inst_18246);
} else {
if((state_val_18300 === (23))){
var inst_18284 = (state_18299[(2)]);
var state_18299__$1 = state_18299;
if(cljs.core.truth_(inst_18284)){
var statearr_18323_18360 = state_18299__$1;
(statearr_18323_18360[(1)] = (24));

} else {
var statearr_18324_18361 = state_18299__$1;
(statearr_18324_18361[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18300 === (19))){
var inst_18279 = (state_18299[(2)]);
var state_18299__$1 = state_18299;
var statearr_18325_18362 = state_18299__$1;
(statearr_18325_18362[(2)] = inst_18279);

(statearr_18325_18362[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18300 === (11))){
var inst_18253 = (state_18299[(14)]);
var inst_18263 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_18253);
var state_18299__$1 = state_18299;
var statearr_18326_18363 = state_18299__$1;
(statearr_18326_18363[(2)] = inst_18263);

(statearr_18326_18363[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18300 === (9))){
var inst_18253 = (state_18299[(14)]);
var inst_18244 = (state_18299[(15)]);
var inst_18270 = (state_18299[(19)]);
var inst_18270__$1 = (inst_18244.cljs$core$IFn$_invoke$arity$1 ? inst_18244.cljs$core$IFn$_invoke$arity$1(inst_18253) : inst_18244.call(null,inst_18253));
var state_18299__$1 = (function (){var statearr_18327 = state_18299;
(statearr_18327[(19)] = inst_18270__$1);

return statearr_18327;
})();
if(cljs.core.truth_(inst_18270__$1)){
var statearr_18328_18364 = state_18299__$1;
(statearr_18328_18364[(1)] = (14));

} else {
var statearr_18329_18365 = state_18299__$1;
(statearr_18329_18365[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18300 === (5))){
var inst_18254 = (state_18299[(13)]);
var state_18299__$1 = state_18299;
var statearr_18330_18366 = state_18299__$1;
(statearr_18330_18366[(2)] = inst_18254);

(statearr_18330_18366[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18300 === (14))){
var inst_18270 = (state_18299[(19)]);
var state_18299__$1 = state_18299;
var statearr_18331_18367 = state_18299__$1;
(statearr_18331_18367[(2)] = inst_18270);

(statearr_18331_18367[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18300 === (26))){
var inst_18289 = (state_18299[(2)]);
var state_18299__$1 = state_18299;
var statearr_18332_18368 = state_18299__$1;
(statearr_18332_18368[(2)] = inst_18289);

(statearr_18332_18368[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18300 === (16))){
var inst_18281 = (state_18299[(2)]);
var state_18299__$1 = state_18299;
if(cljs.core.truth_(inst_18281)){
var statearr_18333_18369 = state_18299__$1;
(statearr_18333_18369[(1)] = (20));

} else {
var statearr_18334_18370 = state_18299__$1;
(statearr_18334_18370[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18300 === (10))){
var inst_18295 = (state_18299[(2)]);
var state_18299__$1 = state_18299;
var statearr_18335_18371 = state_18299__$1;
(statearr_18335_18371[(2)] = inst_18295);

(statearr_18335_18371[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18300 === (18))){
var inst_18273 = (state_18299[(16)]);
var state_18299__$1 = state_18299;
var statearr_18336_18372 = state_18299__$1;
(statearr_18336_18372[(2)] = inst_18273);

(statearr_18336_18372[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18300 === (8))){
var inst_18252 = (state_18299[(7)]);
var inst_18261 = (inst_18252 == null);
var state_18299__$1 = state_18299;
if(cljs.core.truth_(inst_18261)){
var statearr_18337_18373 = state_18299__$1;
(statearr_18337_18373[(1)] = (11));

} else {
var statearr_18338_18374 = state_18299__$1;
(statearr_18338_18374[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__17178__auto__ = null;
var cljs$core$async$mix_$_state_machine__17178__auto____0 = (function (){
var statearr_18339 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18339[(0)] = cljs$core$async$mix_$_state_machine__17178__auto__);

(statearr_18339[(1)] = (1));

return statearr_18339;
});
var cljs$core$async$mix_$_state_machine__17178__auto____1 = (function (state_18299){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_18299);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e18340){var ex__17181__auto__ = e18340;
var statearr_18341_18375 = state_18299;
(statearr_18341_18375[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_18299[(4)]))){
var statearr_18342_18376 = state_18299;
(statearr_18342_18376[(1)] = cljs.core.first((state_18299[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18377 = state_18299;
state_18299 = G__18377;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__17178__auto__ = function(state_18299){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__17178__auto____1.call(this,state_18299);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__17178__auto____0;
cljs$core$async$mix_$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__17178__auto____1;
return cljs$core$async$mix_$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_18343 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_18343[(6)] = c__17304__auto___18344);

return statearr_18343;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_18380 = (function (p,v,ch,close_QMARK_){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4510__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4508__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4508__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_18380(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_18381 = (function (p,v,ch){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4510__auto__.call(null,p,v,ch));
} else {
var m__4508__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4508__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_18381(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_18382 = (function() {
var G__18383 = null;
var G__18383__1 = (function (p){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4510__auto__.call(null,p));
} else {
var m__4508__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4508__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__18383__2 = (function (p,v){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4510__auto__.call(null,p,v));
} else {
var m__4508__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4508__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__18383 = function(p,v){
switch(arguments.length){
case 1:
return G__18383__1.call(this,p);
case 2:
return G__18383__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18383.cljs$core$IFn$_invoke$arity$1 = G__18383__1;
G__18383.cljs$core$IFn$_invoke$arity$2 = G__18383__2;
return G__18383;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__18379 = arguments.length;
switch (G__18379) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_18382.cljs$core$IFn$_invoke$arity$1(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_18382.cljs$core$IFn$_invoke$arity$2(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__18387 = arguments.length;
switch (G__18387) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__18385_SHARP_){
if(cljs.core.truth_((p1__18385_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__18385_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__18385_SHARP_.call(null,topic)))){
return p1__18385_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__18385_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async18388 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18388 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta18389){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta18389 = meta18389;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async18388.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18390,meta18389__$1){
var self__ = this;
var _18390__$1 = this;
return (new cljs.core.async.t_cljs$core$async18388(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta18389__$1));
}));

(cljs.core.async.t_cljs$core$async18388.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18390){
var self__ = this;
var _18390__$1 = this;
return self__.meta18389;
}));

(cljs.core.async.t_cljs$core$async18388.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async18388.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async18388.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async18388.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async18388.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5753__auto__)){
var m = temp__5753__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async18388.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async18388.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async18388.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta18389","meta18389",-2090582509,null)], null);
}));

(cljs.core.async.t_cljs$core$async18388.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async18388.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18388");

(cljs.core.async.t_cljs$core$async18388.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async18388");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async18388.
 */
cljs.core.async.__GT_t_cljs$core$async18388 = (function cljs$core$async$__GT_t_cljs$core$async18388(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta18389){
return (new cljs.core.async.t_cljs$core$async18388(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta18389));
});

}

return (new cljs.core.async.t_cljs$core$async18388(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__17304__auto___18509 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_18462){
var state_val_18463 = (state_18462[(1)]);
if((state_val_18463 === (7))){
var inst_18458 = (state_18462[(2)]);
var state_18462__$1 = state_18462;
var statearr_18464_18510 = state_18462__$1;
(statearr_18464_18510[(2)] = inst_18458);

(statearr_18464_18510[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18463 === (20))){
var state_18462__$1 = state_18462;
var statearr_18465_18511 = state_18462__$1;
(statearr_18465_18511[(2)] = null);

(statearr_18465_18511[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18463 === (1))){
var state_18462__$1 = state_18462;
var statearr_18466_18512 = state_18462__$1;
(statearr_18466_18512[(2)] = null);

(statearr_18466_18512[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18463 === (24))){
var inst_18441 = (state_18462[(7)]);
var inst_18450 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_18441);
var state_18462__$1 = state_18462;
var statearr_18467_18513 = state_18462__$1;
(statearr_18467_18513[(2)] = inst_18450);

(statearr_18467_18513[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18463 === (4))){
var inst_18393 = (state_18462[(8)]);
var inst_18393__$1 = (state_18462[(2)]);
var inst_18394 = (inst_18393__$1 == null);
var state_18462__$1 = (function (){var statearr_18468 = state_18462;
(statearr_18468[(8)] = inst_18393__$1);

return statearr_18468;
})();
if(cljs.core.truth_(inst_18394)){
var statearr_18469_18514 = state_18462__$1;
(statearr_18469_18514[(1)] = (5));

} else {
var statearr_18470_18515 = state_18462__$1;
(statearr_18470_18515[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18463 === (15))){
var inst_18435 = (state_18462[(2)]);
var state_18462__$1 = state_18462;
var statearr_18471_18516 = state_18462__$1;
(statearr_18471_18516[(2)] = inst_18435);

(statearr_18471_18516[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18463 === (21))){
var inst_18455 = (state_18462[(2)]);
var state_18462__$1 = (function (){var statearr_18472 = state_18462;
(statearr_18472[(9)] = inst_18455);

return statearr_18472;
})();
var statearr_18473_18517 = state_18462__$1;
(statearr_18473_18517[(2)] = null);

(statearr_18473_18517[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18463 === (13))){
var inst_18417 = (state_18462[(10)]);
var inst_18419 = cljs.core.chunked_seq_QMARK_(inst_18417);
var state_18462__$1 = state_18462;
if(inst_18419){
var statearr_18474_18518 = state_18462__$1;
(statearr_18474_18518[(1)] = (16));

} else {
var statearr_18475_18519 = state_18462__$1;
(statearr_18475_18519[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18463 === (22))){
var inst_18447 = (state_18462[(2)]);
var state_18462__$1 = state_18462;
if(cljs.core.truth_(inst_18447)){
var statearr_18476_18520 = state_18462__$1;
(statearr_18476_18520[(1)] = (23));

} else {
var statearr_18477_18521 = state_18462__$1;
(statearr_18477_18521[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18463 === (6))){
var inst_18393 = (state_18462[(8)]);
var inst_18443 = (state_18462[(11)]);
var inst_18441 = (state_18462[(7)]);
var inst_18441__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_18393) : topic_fn.call(null,inst_18393));
var inst_18442 = cljs.core.deref(mults);
var inst_18443__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18442,inst_18441__$1);
var state_18462__$1 = (function (){var statearr_18478 = state_18462;
(statearr_18478[(11)] = inst_18443__$1);

(statearr_18478[(7)] = inst_18441__$1);

return statearr_18478;
})();
if(cljs.core.truth_(inst_18443__$1)){
var statearr_18479_18522 = state_18462__$1;
(statearr_18479_18522[(1)] = (19));

} else {
var statearr_18480_18523 = state_18462__$1;
(statearr_18480_18523[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18463 === (25))){
var inst_18452 = (state_18462[(2)]);
var state_18462__$1 = state_18462;
var statearr_18481_18524 = state_18462__$1;
(statearr_18481_18524[(2)] = inst_18452);

(statearr_18481_18524[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18463 === (17))){
var inst_18417 = (state_18462[(10)]);
var inst_18426 = cljs.core.first(inst_18417);
var inst_18427 = cljs.core.async.muxch_STAR_(inst_18426);
var inst_18428 = cljs.core.async.close_BANG_(inst_18427);
var inst_18429 = cljs.core.next(inst_18417);
var inst_18403 = inst_18429;
var inst_18404 = null;
var inst_18405 = (0);
var inst_18406 = (0);
var state_18462__$1 = (function (){var statearr_18482 = state_18462;
(statearr_18482[(12)] = inst_18404);

(statearr_18482[(13)] = inst_18403);

(statearr_18482[(14)] = inst_18406);

(statearr_18482[(15)] = inst_18405);

(statearr_18482[(16)] = inst_18428);

return statearr_18482;
})();
var statearr_18483_18525 = state_18462__$1;
(statearr_18483_18525[(2)] = null);

(statearr_18483_18525[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18463 === (3))){
var inst_18460 = (state_18462[(2)]);
var state_18462__$1 = state_18462;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18462__$1,inst_18460);
} else {
if((state_val_18463 === (12))){
var inst_18437 = (state_18462[(2)]);
var state_18462__$1 = state_18462;
var statearr_18484_18526 = state_18462__$1;
(statearr_18484_18526[(2)] = inst_18437);

(statearr_18484_18526[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18463 === (2))){
var state_18462__$1 = state_18462;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18462__$1,(4),ch);
} else {
if((state_val_18463 === (23))){
var state_18462__$1 = state_18462;
var statearr_18485_18527 = state_18462__$1;
(statearr_18485_18527[(2)] = null);

(statearr_18485_18527[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18463 === (19))){
var inst_18393 = (state_18462[(8)]);
var inst_18443 = (state_18462[(11)]);
var inst_18445 = cljs.core.async.muxch_STAR_(inst_18443);
var state_18462__$1 = state_18462;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18462__$1,(22),inst_18445,inst_18393);
} else {
if((state_val_18463 === (11))){
var inst_18403 = (state_18462[(13)]);
var inst_18417 = (state_18462[(10)]);
var inst_18417__$1 = cljs.core.seq(inst_18403);
var state_18462__$1 = (function (){var statearr_18486 = state_18462;
(statearr_18486[(10)] = inst_18417__$1);

return statearr_18486;
})();
if(inst_18417__$1){
var statearr_18487_18528 = state_18462__$1;
(statearr_18487_18528[(1)] = (13));

} else {
var statearr_18488_18529 = state_18462__$1;
(statearr_18488_18529[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18463 === (9))){
var inst_18439 = (state_18462[(2)]);
var state_18462__$1 = state_18462;
var statearr_18489_18530 = state_18462__$1;
(statearr_18489_18530[(2)] = inst_18439);

(statearr_18489_18530[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18463 === (5))){
var inst_18400 = cljs.core.deref(mults);
var inst_18401 = cljs.core.vals(inst_18400);
var inst_18402 = cljs.core.seq(inst_18401);
var inst_18403 = inst_18402;
var inst_18404 = null;
var inst_18405 = (0);
var inst_18406 = (0);
var state_18462__$1 = (function (){var statearr_18490 = state_18462;
(statearr_18490[(12)] = inst_18404);

(statearr_18490[(13)] = inst_18403);

(statearr_18490[(14)] = inst_18406);

(statearr_18490[(15)] = inst_18405);

return statearr_18490;
})();
var statearr_18491_18531 = state_18462__$1;
(statearr_18491_18531[(2)] = null);

(statearr_18491_18531[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18463 === (14))){
var state_18462__$1 = state_18462;
var statearr_18495_18532 = state_18462__$1;
(statearr_18495_18532[(2)] = null);

(statearr_18495_18532[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18463 === (16))){
var inst_18417 = (state_18462[(10)]);
var inst_18421 = cljs.core.chunk_first(inst_18417);
var inst_18422 = cljs.core.chunk_rest(inst_18417);
var inst_18423 = cljs.core.count(inst_18421);
var inst_18403 = inst_18422;
var inst_18404 = inst_18421;
var inst_18405 = inst_18423;
var inst_18406 = (0);
var state_18462__$1 = (function (){var statearr_18496 = state_18462;
(statearr_18496[(12)] = inst_18404);

(statearr_18496[(13)] = inst_18403);

(statearr_18496[(14)] = inst_18406);

(statearr_18496[(15)] = inst_18405);

return statearr_18496;
})();
var statearr_18497_18533 = state_18462__$1;
(statearr_18497_18533[(2)] = null);

(statearr_18497_18533[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18463 === (10))){
var inst_18404 = (state_18462[(12)]);
var inst_18403 = (state_18462[(13)]);
var inst_18406 = (state_18462[(14)]);
var inst_18405 = (state_18462[(15)]);
var inst_18411 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_18404,inst_18406);
var inst_18412 = cljs.core.async.muxch_STAR_(inst_18411);
var inst_18413 = cljs.core.async.close_BANG_(inst_18412);
var inst_18414 = (inst_18406 + (1));
var tmp18492 = inst_18404;
var tmp18493 = inst_18403;
var tmp18494 = inst_18405;
var inst_18403__$1 = tmp18493;
var inst_18404__$1 = tmp18492;
var inst_18405__$1 = tmp18494;
var inst_18406__$1 = inst_18414;
var state_18462__$1 = (function (){var statearr_18498 = state_18462;
(statearr_18498[(12)] = inst_18404__$1);

(statearr_18498[(13)] = inst_18403__$1);

(statearr_18498[(14)] = inst_18406__$1);

(statearr_18498[(15)] = inst_18405__$1);

(statearr_18498[(17)] = inst_18413);

return statearr_18498;
})();
var statearr_18499_18534 = state_18462__$1;
(statearr_18499_18534[(2)] = null);

(statearr_18499_18534[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18463 === (18))){
var inst_18432 = (state_18462[(2)]);
var state_18462__$1 = state_18462;
var statearr_18500_18535 = state_18462__$1;
(statearr_18500_18535[(2)] = inst_18432);

(statearr_18500_18535[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18463 === (8))){
var inst_18406 = (state_18462[(14)]);
var inst_18405 = (state_18462[(15)]);
var inst_18408 = (inst_18406 < inst_18405);
var inst_18409 = inst_18408;
var state_18462__$1 = state_18462;
if(cljs.core.truth_(inst_18409)){
var statearr_18501_18536 = state_18462__$1;
(statearr_18501_18536[(1)] = (10));

} else {
var statearr_18502_18537 = state_18462__$1;
(statearr_18502_18537[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__17178__auto__ = null;
var cljs$core$async$state_machine__17178__auto____0 = (function (){
var statearr_18503 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18503[(0)] = cljs$core$async$state_machine__17178__auto__);

(statearr_18503[(1)] = (1));

return statearr_18503;
});
var cljs$core$async$state_machine__17178__auto____1 = (function (state_18462){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_18462);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e18504){var ex__17181__auto__ = e18504;
var statearr_18505_18538 = state_18462;
(statearr_18505_18538[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_18462[(4)]))){
var statearr_18506_18539 = state_18462;
(statearr_18506_18539[(1)] = cljs.core.first((state_18462[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18540 = state_18462;
state_18462 = G__18540;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$state_machine__17178__auto__ = function(state_18462){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17178__auto____1.call(this,state_18462);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17178__auto____0;
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17178__auto____1;
return cljs$core$async$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_18507 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_18507[(6)] = c__17304__auto___18509);

return statearr_18507;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__18542 = arguments.length;
switch (G__18542) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__18545 = arguments.length;
switch (G__18545) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__18548 = arguments.length;
switch (G__18548) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__17304__auto___18626 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_18591){
var state_val_18592 = (state_18591[(1)]);
if((state_val_18592 === (7))){
var state_18591__$1 = state_18591;
var statearr_18593_18627 = state_18591__$1;
(statearr_18593_18627[(2)] = null);

(statearr_18593_18627[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18592 === (1))){
var state_18591__$1 = state_18591;
var statearr_18594_18628 = state_18591__$1;
(statearr_18594_18628[(2)] = null);

(statearr_18594_18628[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18592 === (4))){
var inst_18551 = (state_18591[(7)]);
var inst_18552 = (state_18591[(8)]);
var inst_18554 = (inst_18552 < inst_18551);
var state_18591__$1 = state_18591;
if(cljs.core.truth_(inst_18554)){
var statearr_18595_18629 = state_18591__$1;
(statearr_18595_18629[(1)] = (6));

} else {
var statearr_18596_18630 = state_18591__$1;
(statearr_18596_18630[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18592 === (15))){
var inst_18577 = (state_18591[(9)]);
var inst_18582 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_18577);
var state_18591__$1 = state_18591;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18591__$1,(17),out,inst_18582);
} else {
if((state_val_18592 === (13))){
var inst_18577 = (state_18591[(9)]);
var inst_18577__$1 = (state_18591[(2)]);
var inst_18578 = cljs.core.some(cljs.core.nil_QMARK_,inst_18577__$1);
var state_18591__$1 = (function (){var statearr_18597 = state_18591;
(statearr_18597[(9)] = inst_18577__$1);

return statearr_18597;
})();
if(cljs.core.truth_(inst_18578)){
var statearr_18598_18631 = state_18591__$1;
(statearr_18598_18631[(1)] = (14));

} else {
var statearr_18599_18632 = state_18591__$1;
(statearr_18599_18632[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18592 === (6))){
var state_18591__$1 = state_18591;
var statearr_18600_18633 = state_18591__$1;
(statearr_18600_18633[(2)] = null);

(statearr_18600_18633[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18592 === (17))){
var inst_18584 = (state_18591[(2)]);
var state_18591__$1 = (function (){var statearr_18602 = state_18591;
(statearr_18602[(10)] = inst_18584);

return statearr_18602;
})();
var statearr_18603_18634 = state_18591__$1;
(statearr_18603_18634[(2)] = null);

(statearr_18603_18634[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18592 === (3))){
var inst_18589 = (state_18591[(2)]);
var state_18591__$1 = state_18591;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18591__$1,inst_18589);
} else {
if((state_val_18592 === (12))){
var _ = (function (){var statearr_18604 = state_18591;
(statearr_18604[(4)] = cljs.core.rest((state_18591[(4)])));

return statearr_18604;
})();
var state_18591__$1 = state_18591;
var ex18601 = (state_18591__$1[(2)]);
var statearr_18605_18635 = state_18591__$1;
(statearr_18605_18635[(5)] = ex18601);


if((ex18601 instanceof Object)){
var statearr_18606_18636 = state_18591__$1;
(statearr_18606_18636[(1)] = (11));

(statearr_18606_18636[(5)] = null);

} else {
throw ex18601;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18592 === (2))){
var inst_18550 = cljs.core.reset_BANG_(dctr,cnt);
var inst_18551 = cnt;
var inst_18552 = (0);
var state_18591__$1 = (function (){var statearr_18607 = state_18591;
(statearr_18607[(7)] = inst_18551);

(statearr_18607[(11)] = inst_18550);

(statearr_18607[(8)] = inst_18552);

return statearr_18607;
})();
var statearr_18608_18637 = state_18591__$1;
(statearr_18608_18637[(2)] = null);

(statearr_18608_18637[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18592 === (11))){
var inst_18556 = (state_18591[(2)]);
var inst_18557 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_18591__$1 = (function (){var statearr_18609 = state_18591;
(statearr_18609[(12)] = inst_18556);

return statearr_18609;
})();
var statearr_18610_18638 = state_18591__$1;
(statearr_18610_18638[(2)] = inst_18557);

(statearr_18610_18638[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18592 === (9))){
var inst_18552 = (state_18591[(8)]);
var _ = (function (){var statearr_18611 = state_18591;
(statearr_18611[(4)] = cljs.core.cons((12),(state_18591[(4)])));

return statearr_18611;
})();
var inst_18563 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_18552) : chs__$1.call(null,inst_18552));
var inst_18564 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_18552) : done.call(null,inst_18552));
var inst_18565 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_18563,inst_18564);
var ___$1 = (function (){var statearr_18612 = state_18591;
(statearr_18612[(4)] = cljs.core.rest((state_18591[(4)])));

return statearr_18612;
})();
var state_18591__$1 = state_18591;
var statearr_18613_18639 = state_18591__$1;
(statearr_18613_18639[(2)] = inst_18565);

(statearr_18613_18639[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18592 === (5))){
var inst_18575 = (state_18591[(2)]);
var state_18591__$1 = (function (){var statearr_18614 = state_18591;
(statearr_18614[(13)] = inst_18575);

return statearr_18614;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18591__$1,(13),dchan);
} else {
if((state_val_18592 === (14))){
var inst_18580 = cljs.core.async.close_BANG_(out);
var state_18591__$1 = state_18591;
var statearr_18615_18640 = state_18591__$1;
(statearr_18615_18640[(2)] = inst_18580);

(statearr_18615_18640[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18592 === (16))){
var inst_18587 = (state_18591[(2)]);
var state_18591__$1 = state_18591;
var statearr_18616_18641 = state_18591__$1;
(statearr_18616_18641[(2)] = inst_18587);

(statearr_18616_18641[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18592 === (10))){
var inst_18552 = (state_18591[(8)]);
var inst_18568 = (state_18591[(2)]);
var inst_18569 = (inst_18552 + (1));
var inst_18552__$1 = inst_18569;
var state_18591__$1 = (function (){var statearr_18617 = state_18591;
(statearr_18617[(8)] = inst_18552__$1);

(statearr_18617[(14)] = inst_18568);

return statearr_18617;
})();
var statearr_18618_18642 = state_18591__$1;
(statearr_18618_18642[(2)] = null);

(statearr_18618_18642[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18592 === (8))){
var inst_18573 = (state_18591[(2)]);
var state_18591__$1 = state_18591;
var statearr_18619_18643 = state_18591__$1;
(statearr_18619_18643[(2)] = inst_18573);

(statearr_18619_18643[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__17178__auto__ = null;
var cljs$core$async$state_machine__17178__auto____0 = (function (){
var statearr_18620 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18620[(0)] = cljs$core$async$state_machine__17178__auto__);

(statearr_18620[(1)] = (1));

return statearr_18620;
});
var cljs$core$async$state_machine__17178__auto____1 = (function (state_18591){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_18591);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e18621){var ex__17181__auto__ = e18621;
var statearr_18622_18644 = state_18591;
(statearr_18622_18644[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_18591[(4)]))){
var statearr_18623_18645 = state_18591;
(statearr_18623_18645[(1)] = cljs.core.first((state_18591[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18646 = state_18591;
state_18591 = G__18646;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$state_machine__17178__auto__ = function(state_18591){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17178__auto____1.call(this,state_18591);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17178__auto____0;
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17178__auto____1;
return cljs$core$async$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_18624 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_18624[(6)] = c__17304__auto___18626);

return statearr_18624;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__18649 = arguments.length;
switch (G__18649) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17304__auto___18704 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_18681){
var state_val_18682 = (state_18681[(1)]);
if((state_val_18682 === (7))){
var inst_18660 = (state_18681[(7)]);
var inst_18661 = (state_18681[(8)]);
var inst_18660__$1 = (state_18681[(2)]);
var inst_18661__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18660__$1,(0),null);
var inst_18662 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18660__$1,(1),null);
var inst_18663 = (inst_18661__$1 == null);
var state_18681__$1 = (function (){var statearr_18683 = state_18681;
(statearr_18683[(9)] = inst_18662);

(statearr_18683[(7)] = inst_18660__$1);

(statearr_18683[(8)] = inst_18661__$1);

return statearr_18683;
})();
if(cljs.core.truth_(inst_18663)){
var statearr_18684_18705 = state_18681__$1;
(statearr_18684_18705[(1)] = (8));

} else {
var statearr_18685_18706 = state_18681__$1;
(statearr_18685_18706[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18682 === (1))){
var inst_18650 = cljs.core.vec(chs);
var inst_18651 = inst_18650;
var state_18681__$1 = (function (){var statearr_18686 = state_18681;
(statearr_18686[(10)] = inst_18651);

return statearr_18686;
})();
var statearr_18687_18707 = state_18681__$1;
(statearr_18687_18707[(2)] = null);

(statearr_18687_18707[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18682 === (4))){
var inst_18651 = (state_18681[(10)]);
var state_18681__$1 = state_18681;
return cljs.core.async.ioc_alts_BANG_(state_18681__$1,(7),inst_18651);
} else {
if((state_val_18682 === (6))){
var inst_18677 = (state_18681[(2)]);
var state_18681__$1 = state_18681;
var statearr_18688_18708 = state_18681__$1;
(statearr_18688_18708[(2)] = inst_18677);

(statearr_18688_18708[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18682 === (3))){
var inst_18679 = (state_18681[(2)]);
var state_18681__$1 = state_18681;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18681__$1,inst_18679);
} else {
if((state_val_18682 === (2))){
var inst_18651 = (state_18681[(10)]);
var inst_18653 = cljs.core.count(inst_18651);
var inst_18654 = (inst_18653 > (0));
var state_18681__$1 = state_18681;
if(cljs.core.truth_(inst_18654)){
var statearr_18690_18709 = state_18681__$1;
(statearr_18690_18709[(1)] = (4));

} else {
var statearr_18691_18710 = state_18681__$1;
(statearr_18691_18710[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18682 === (11))){
var inst_18651 = (state_18681[(10)]);
var inst_18670 = (state_18681[(2)]);
var tmp18689 = inst_18651;
var inst_18651__$1 = tmp18689;
var state_18681__$1 = (function (){var statearr_18692 = state_18681;
(statearr_18692[(11)] = inst_18670);

(statearr_18692[(10)] = inst_18651__$1);

return statearr_18692;
})();
var statearr_18693_18711 = state_18681__$1;
(statearr_18693_18711[(2)] = null);

(statearr_18693_18711[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18682 === (9))){
var inst_18661 = (state_18681[(8)]);
var state_18681__$1 = state_18681;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18681__$1,(11),out,inst_18661);
} else {
if((state_val_18682 === (5))){
var inst_18675 = cljs.core.async.close_BANG_(out);
var state_18681__$1 = state_18681;
var statearr_18694_18712 = state_18681__$1;
(statearr_18694_18712[(2)] = inst_18675);

(statearr_18694_18712[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18682 === (10))){
var inst_18673 = (state_18681[(2)]);
var state_18681__$1 = state_18681;
var statearr_18695_18713 = state_18681__$1;
(statearr_18695_18713[(2)] = inst_18673);

(statearr_18695_18713[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18682 === (8))){
var inst_18662 = (state_18681[(9)]);
var inst_18660 = (state_18681[(7)]);
var inst_18661 = (state_18681[(8)]);
var inst_18651 = (state_18681[(10)]);
var inst_18665 = (function (){var cs = inst_18651;
var vec__18656 = inst_18660;
var v = inst_18661;
var c = inst_18662;
return (function (p1__18647_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__18647_SHARP_);
});
})();
var inst_18666 = cljs.core.filterv(inst_18665,inst_18651);
var inst_18651__$1 = inst_18666;
var state_18681__$1 = (function (){var statearr_18696 = state_18681;
(statearr_18696[(10)] = inst_18651__$1);

return statearr_18696;
})();
var statearr_18697_18714 = state_18681__$1;
(statearr_18697_18714[(2)] = null);

(statearr_18697_18714[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__17178__auto__ = null;
var cljs$core$async$state_machine__17178__auto____0 = (function (){
var statearr_18698 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18698[(0)] = cljs$core$async$state_machine__17178__auto__);

(statearr_18698[(1)] = (1));

return statearr_18698;
});
var cljs$core$async$state_machine__17178__auto____1 = (function (state_18681){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_18681);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e18699){var ex__17181__auto__ = e18699;
var statearr_18700_18715 = state_18681;
(statearr_18700_18715[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_18681[(4)]))){
var statearr_18701_18716 = state_18681;
(statearr_18701_18716[(1)] = cljs.core.first((state_18681[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18717 = state_18681;
state_18681 = G__18717;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$state_machine__17178__auto__ = function(state_18681){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17178__auto____1.call(this,state_18681);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17178__auto____0;
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17178__auto____1;
return cljs$core$async$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_18702 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_18702[(6)] = c__17304__auto___18704);

return statearr_18702;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__18719 = arguments.length;
switch (G__18719) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17304__auto___18765 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_18743){
var state_val_18744 = (state_18743[(1)]);
if((state_val_18744 === (7))){
var inst_18725 = (state_18743[(7)]);
var inst_18725__$1 = (state_18743[(2)]);
var inst_18726 = (inst_18725__$1 == null);
var inst_18727 = cljs.core.not(inst_18726);
var state_18743__$1 = (function (){var statearr_18745 = state_18743;
(statearr_18745[(7)] = inst_18725__$1);

return statearr_18745;
})();
if(inst_18727){
var statearr_18746_18766 = state_18743__$1;
(statearr_18746_18766[(1)] = (8));

} else {
var statearr_18747_18767 = state_18743__$1;
(statearr_18747_18767[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18744 === (1))){
var inst_18720 = (0);
var state_18743__$1 = (function (){var statearr_18748 = state_18743;
(statearr_18748[(8)] = inst_18720);

return statearr_18748;
})();
var statearr_18749_18768 = state_18743__$1;
(statearr_18749_18768[(2)] = null);

(statearr_18749_18768[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18744 === (4))){
var state_18743__$1 = state_18743;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18743__$1,(7),ch);
} else {
if((state_val_18744 === (6))){
var inst_18738 = (state_18743[(2)]);
var state_18743__$1 = state_18743;
var statearr_18750_18769 = state_18743__$1;
(statearr_18750_18769[(2)] = inst_18738);

(statearr_18750_18769[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18744 === (3))){
var inst_18740 = (state_18743[(2)]);
var inst_18741 = cljs.core.async.close_BANG_(out);
var state_18743__$1 = (function (){var statearr_18751 = state_18743;
(statearr_18751[(9)] = inst_18740);

return statearr_18751;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_18743__$1,inst_18741);
} else {
if((state_val_18744 === (2))){
var inst_18720 = (state_18743[(8)]);
var inst_18722 = (inst_18720 < n);
var state_18743__$1 = state_18743;
if(cljs.core.truth_(inst_18722)){
var statearr_18752_18770 = state_18743__$1;
(statearr_18752_18770[(1)] = (4));

} else {
var statearr_18753_18771 = state_18743__$1;
(statearr_18753_18771[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18744 === (11))){
var inst_18720 = (state_18743[(8)]);
var inst_18730 = (state_18743[(2)]);
var inst_18731 = (inst_18720 + (1));
var inst_18720__$1 = inst_18731;
var state_18743__$1 = (function (){var statearr_18754 = state_18743;
(statearr_18754[(10)] = inst_18730);

(statearr_18754[(8)] = inst_18720__$1);

return statearr_18754;
})();
var statearr_18755_18772 = state_18743__$1;
(statearr_18755_18772[(2)] = null);

(statearr_18755_18772[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18744 === (9))){
var state_18743__$1 = state_18743;
var statearr_18756_18773 = state_18743__$1;
(statearr_18756_18773[(2)] = null);

(statearr_18756_18773[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18744 === (5))){
var state_18743__$1 = state_18743;
var statearr_18757_18774 = state_18743__$1;
(statearr_18757_18774[(2)] = null);

(statearr_18757_18774[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18744 === (10))){
var inst_18735 = (state_18743[(2)]);
var state_18743__$1 = state_18743;
var statearr_18758_18775 = state_18743__$1;
(statearr_18758_18775[(2)] = inst_18735);

(statearr_18758_18775[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18744 === (8))){
var inst_18725 = (state_18743[(7)]);
var state_18743__$1 = state_18743;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18743__$1,(11),out,inst_18725);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__17178__auto__ = null;
var cljs$core$async$state_machine__17178__auto____0 = (function (){
var statearr_18759 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18759[(0)] = cljs$core$async$state_machine__17178__auto__);

(statearr_18759[(1)] = (1));

return statearr_18759;
});
var cljs$core$async$state_machine__17178__auto____1 = (function (state_18743){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_18743);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e18760){var ex__17181__auto__ = e18760;
var statearr_18761_18776 = state_18743;
(statearr_18761_18776[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_18743[(4)]))){
var statearr_18762_18777 = state_18743;
(statearr_18762_18777[(1)] = cljs.core.first((state_18743[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18778 = state_18743;
state_18743 = G__18778;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$state_machine__17178__auto__ = function(state_18743){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17178__auto____1.call(this,state_18743);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17178__auto____0;
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17178__auto____1;
return cljs$core$async$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_18763 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_18763[(6)] = c__17304__auto___18765);

return statearr_18763;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async18780 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18780 = (function (f,ch,meta18781){
this.f = f;
this.ch = ch;
this.meta18781 = meta18781;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async18780.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18782,meta18781__$1){
var self__ = this;
var _18782__$1 = this;
return (new cljs.core.async.t_cljs$core$async18780(self__.f,self__.ch,meta18781__$1));
}));

(cljs.core.async.t_cljs$core$async18780.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18782){
var self__ = this;
var _18782__$1 = this;
return self__.meta18781;
}));

(cljs.core.async.t_cljs$core$async18780.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async18780.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async18780.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async18780.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async18780.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async18783 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18783 = (function (f,ch,meta18781,_,fn1,meta18784){
this.f = f;
this.ch = ch;
this.meta18781 = meta18781;
this._ = _;
this.fn1 = fn1;
this.meta18784 = meta18784;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async18783.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18785,meta18784__$1){
var self__ = this;
var _18785__$1 = this;
return (new cljs.core.async.t_cljs$core$async18783(self__.f,self__.ch,self__.meta18781,self__._,self__.fn1,meta18784__$1));
}));

(cljs.core.async.t_cljs$core$async18783.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18785){
var self__ = this;
var _18785__$1 = this;
return self__.meta18784;
}));

(cljs.core.async.t_cljs$core$async18783.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async18783.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async18783.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async18783.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__18779_SHARP_){
var G__18786 = (((p1__18779_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__18779_SHARP_) : self__.f.call(null,p1__18779_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__18786) : f1.call(null,G__18786));
});
}));

(cljs.core.async.t_cljs$core$async18783.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta18781","meta18781",-499836375,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async18780","cljs.core.async/t_cljs$core$async18780",-364059119,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta18784","meta18784",55143656,null)], null);
}));

(cljs.core.async.t_cljs$core$async18783.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async18783.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18783");

(cljs.core.async.t_cljs$core$async18783.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async18783");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async18783.
 */
cljs.core.async.__GT_t_cljs$core$async18783 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async18783(f__$1,ch__$1,meta18781__$1,___$2,fn1__$1,meta18784){
return (new cljs.core.async.t_cljs$core$async18783(f__$1,ch__$1,meta18781__$1,___$2,fn1__$1,meta18784));
});

}

return (new cljs.core.async.t_cljs$core$async18783(self__.f,self__.ch,self__.meta18781,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4210__auto__ = ret;
if(cljs.core.truth_(and__4210__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4210__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__18787 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__18787) : self__.f.call(null,G__18787));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async18780.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async18780.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async18780.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta18781","meta18781",-499836375,null)], null);
}));

(cljs.core.async.t_cljs$core$async18780.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async18780.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18780");

(cljs.core.async.t_cljs$core$async18780.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async18780");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async18780.
 */
cljs.core.async.__GT_t_cljs$core$async18780 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async18780(f__$1,ch__$1,meta18781){
return (new cljs.core.async.t_cljs$core$async18780(f__$1,ch__$1,meta18781));
});

}

return (new cljs.core.async.t_cljs$core$async18780(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async18788 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18788 = (function (f,ch,meta18789){
this.f = f;
this.ch = ch;
this.meta18789 = meta18789;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async18788.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18790,meta18789__$1){
var self__ = this;
var _18790__$1 = this;
return (new cljs.core.async.t_cljs$core$async18788(self__.f,self__.ch,meta18789__$1));
}));

(cljs.core.async.t_cljs$core$async18788.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18790){
var self__ = this;
var _18790__$1 = this;
return self__.meta18789;
}));

(cljs.core.async.t_cljs$core$async18788.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async18788.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async18788.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async18788.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async18788.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async18788.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async18788.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta18789","meta18789",251004400,null)], null);
}));

(cljs.core.async.t_cljs$core$async18788.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async18788.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18788");

(cljs.core.async.t_cljs$core$async18788.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async18788");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async18788.
 */
cljs.core.async.__GT_t_cljs$core$async18788 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async18788(f__$1,ch__$1,meta18789){
return (new cljs.core.async.t_cljs$core$async18788(f__$1,ch__$1,meta18789));
});

}

return (new cljs.core.async.t_cljs$core$async18788(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async18791 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18791 = (function (p,ch,meta18792){
this.p = p;
this.ch = ch;
this.meta18792 = meta18792;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async18791.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18793,meta18792__$1){
var self__ = this;
var _18793__$1 = this;
return (new cljs.core.async.t_cljs$core$async18791(self__.p,self__.ch,meta18792__$1));
}));

(cljs.core.async.t_cljs$core$async18791.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18793){
var self__ = this;
var _18793__$1 = this;
return self__.meta18792;
}));

(cljs.core.async.t_cljs$core$async18791.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async18791.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async18791.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async18791.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async18791.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async18791.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async18791.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async18791.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta18792","meta18792",1634092204,null)], null);
}));

(cljs.core.async.t_cljs$core$async18791.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async18791.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18791");

(cljs.core.async.t_cljs$core$async18791.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async18791");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async18791.
 */
cljs.core.async.__GT_t_cljs$core$async18791 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async18791(p__$1,ch__$1,meta18792){
return (new cljs.core.async.t_cljs$core$async18791(p__$1,ch__$1,meta18792));
});

}

return (new cljs.core.async.t_cljs$core$async18791(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__18795 = arguments.length;
switch (G__18795) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17304__auto___18836 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_18816){
var state_val_18817 = (state_18816[(1)]);
if((state_val_18817 === (7))){
var inst_18812 = (state_18816[(2)]);
var state_18816__$1 = state_18816;
var statearr_18818_18837 = state_18816__$1;
(statearr_18818_18837[(2)] = inst_18812);

(statearr_18818_18837[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18817 === (1))){
var state_18816__$1 = state_18816;
var statearr_18819_18838 = state_18816__$1;
(statearr_18819_18838[(2)] = null);

(statearr_18819_18838[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18817 === (4))){
var inst_18798 = (state_18816[(7)]);
var inst_18798__$1 = (state_18816[(2)]);
var inst_18799 = (inst_18798__$1 == null);
var state_18816__$1 = (function (){var statearr_18820 = state_18816;
(statearr_18820[(7)] = inst_18798__$1);

return statearr_18820;
})();
if(cljs.core.truth_(inst_18799)){
var statearr_18821_18839 = state_18816__$1;
(statearr_18821_18839[(1)] = (5));

} else {
var statearr_18822_18840 = state_18816__$1;
(statearr_18822_18840[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18817 === (6))){
var inst_18798 = (state_18816[(7)]);
var inst_18803 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_18798) : p.call(null,inst_18798));
var state_18816__$1 = state_18816;
if(cljs.core.truth_(inst_18803)){
var statearr_18823_18841 = state_18816__$1;
(statearr_18823_18841[(1)] = (8));

} else {
var statearr_18824_18842 = state_18816__$1;
(statearr_18824_18842[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18817 === (3))){
var inst_18814 = (state_18816[(2)]);
var state_18816__$1 = state_18816;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18816__$1,inst_18814);
} else {
if((state_val_18817 === (2))){
var state_18816__$1 = state_18816;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18816__$1,(4),ch);
} else {
if((state_val_18817 === (11))){
var inst_18806 = (state_18816[(2)]);
var state_18816__$1 = state_18816;
var statearr_18825_18843 = state_18816__$1;
(statearr_18825_18843[(2)] = inst_18806);

(statearr_18825_18843[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18817 === (9))){
var state_18816__$1 = state_18816;
var statearr_18826_18844 = state_18816__$1;
(statearr_18826_18844[(2)] = null);

(statearr_18826_18844[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18817 === (5))){
var inst_18801 = cljs.core.async.close_BANG_(out);
var state_18816__$1 = state_18816;
var statearr_18827_18845 = state_18816__$1;
(statearr_18827_18845[(2)] = inst_18801);

(statearr_18827_18845[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18817 === (10))){
var inst_18809 = (state_18816[(2)]);
var state_18816__$1 = (function (){var statearr_18828 = state_18816;
(statearr_18828[(8)] = inst_18809);

return statearr_18828;
})();
var statearr_18829_18846 = state_18816__$1;
(statearr_18829_18846[(2)] = null);

(statearr_18829_18846[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18817 === (8))){
var inst_18798 = (state_18816[(7)]);
var state_18816__$1 = state_18816;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18816__$1,(11),out,inst_18798);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__17178__auto__ = null;
var cljs$core$async$state_machine__17178__auto____0 = (function (){
var statearr_18830 = [null,null,null,null,null,null,null,null,null];
(statearr_18830[(0)] = cljs$core$async$state_machine__17178__auto__);

(statearr_18830[(1)] = (1));

return statearr_18830;
});
var cljs$core$async$state_machine__17178__auto____1 = (function (state_18816){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_18816);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e18831){var ex__17181__auto__ = e18831;
var statearr_18832_18847 = state_18816;
(statearr_18832_18847[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_18816[(4)]))){
var statearr_18833_18848 = state_18816;
(statearr_18833_18848[(1)] = cljs.core.first((state_18816[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18849 = state_18816;
state_18816 = G__18849;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$state_machine__17178__auto__ = function(state_18816){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17178__auto____1.call(this,state_18816);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17178__auto____0;
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17178__auto____1;
return cljs$core$async$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_18834 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_18834[(6)] = c__17304__auto___18836);

return statearr_18834;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__18851 = arguments.length;
switch (G__18851) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__17304__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_18914){
var state_val_18915 = (state_18914[(1)]);
if((state_val_18915 === (7))){
var inst_18910 = (state_18914[(2)]);
var state_18914__$1 = state_18914;
var statearr_18916_18955 = state_18914__$1;
(statearr_18916_18955[(2)] = inst_18910);

(statearr_18916_18955[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18915 === (20))){
var inst_18880 = (state_18914[(7)]);
var inst_18891 = (state_18914[(2)]);
var inst_18892 = cljs.core.next(inst_18880);
var inst_18866 = inst_18892;
var inst_18867 = null;
var inst_18868 = (0);
var inst_18869 = (0);
var state_18914__$1 = (function (){var statearr_18917 = state_18914;
(statearr_18917[(8)] = inst_18867);

(statearr_18917[(9)] = inst_18868);

(statearr_18917[(10)] = inst_18869);

(statearr_18917[(11)] = inst_18891);

(statearr_18917[(12)] = inst_18866);

return statearr_18917;
})();
var statearr_18918_18956 = state_18914__$1;
(statearr_18918_18956[(2)] = null);

(statearr_18918_18956[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18915 === (1))){
var state_18914__$1 = state_18914;
var statearr_18919_18957 = state_18914__$1;
(statearr_18919_18957[(2)] = null);

(statearr_18919_18957[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18915 === (4))){
var inst_18855 = (state_18914[(13)]);
var inst_18855__$1 = (state_18914[(2)]);
var inst_18856 = (inst_18855__$1 == null);
var state_18914__$1 = (function (){var statearr_18920 = state_18914;
(statearr_18920[(13)] = inst_18855__$1);

return statearr_18920;
})();
if(cljs.core.truth_(inst_18856)){
var statearr_18921_18958 = state_18914__$1;
(statearr_18921_18958[(1)] = (5));

} else {
var statearr_18922_18959 = state_18914__$1;
(statearr_18922_18959[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18915 === (15))){
var state_18914__$1 = state_18914;
var statearr_18926_18960 = state_18914__$1;
(statearr_18926_18960[(2)] = null);

(statearr_18926_18960[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18915 === (21))){
var state_18914__$1 = state_18914;
var statearr_18927_18961 = state_18914__$1;
(statearr_18927_18961[(2)] = null);

(statearr_18927_18961[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18915 === (13))){
var inst_18867 = (state_18914[(8)]);
var inst_18868 = (state_18914[(9)]);
var inst_18869 = (state_18914[(10)]);
var inst_18866 = (state_18914[(12)]);
var inst_18876 = (state_18914[(2)]);
var inst_18877 = (inst_18869 + (1));
var tmp18923 = inst_18867;
var tmp18924 = inst_18868;
var tmp18925 = inst_18866;
var inst_18866__$1 = tmp18925;
var inst_18867__$1 = tmp18923;
var inst_18868__$1 = tmp18924;
var inst_18869__$1 = inst_18877;
var state_18914__$1 = (function (){var statearr_18928 = state_18914;
(statearr_18928[(8)] = inst_18867__$1);

(statearr_18928[(14)] = inst_18876);

(statearr_18928[(9)] = inst_18868__$1);

(statearr_18928[(10)] = inst_18869__$1);

(statearr_18928[(12)] = inst_18866__$1);

return statearr_18928;
})();
var statearr_18929_18962 = state_18914__$1;
(statearr_18929_18962[(2)] = null);

(statearr_18929_18962[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18915 === (22))){
var state_18914__$1 = state_18914;
var statearr_18930_18963 = state_18914__$1;
(statearr_18930_18963[(2)] = null);

(statearr_18930_18963[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18915 === (6))){
var inst_18855 = (state_18914[(13)]);
var inst_18864 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_18855) : f.call(null,inst_18855));
var inst_18865 = cljs.core.seq(inst_18864);
var inst_18866 = inst_18865;
var inst_18867 = null;
var inst_18868 = (0);
var inst_18869 = (0);
var state_18914__$1 = (function (){var statearr_18931 = state_18914;
(statearr_18931[(8)] = inst_18867);

(statearr_18931[(9)] = inst_18868);

(statearr_18931[(10)] = inst_18869);

(statearr_18931[(12)] = inst_18866);

return statearr_18931;
})();
var statearr_18932_18964 = state_18914__$1;
(statearr_18932_18964[(2)] = null);

(statearr_18932_18964[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18915 === (17))){
var inst_18880 = (state_18914[(7)]);
var inst_18884 = cljs.core.chunk_first(inst_18880);
var inst_18885 = cljs.core.chunk_rest(inst_18880);
var inst_18886 = cljs.core.count(inst_18884);
var inst_18866 = inst_18885;
var inst_18867 = inst_18884;
var inst_18868 = inst_18886;
var inst_18869 = (0);
var state_18914__$1 = (function (){var statearr_18933 = state_18914;
(statearr_18933[(8)] = inst_18867);

(statearr_18933[(9)] = inst_18868);

(statearr_18933[(10)] = inst_18869);

(statearr_18933[(12)] = inst_18866);

return statearr_18933;
})();
var statearr_18934_18965 = state_18914__$1;
(statearr_18934_18965[(2)] = null);

(statearr_18934_18965[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18915 === (3))){
var inst_18912 = (state_18914[(2)]);
var state_18914__$1 = state_18914;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18914__$1,inst_18912);
} else {
if((state_val_18915 === (12))){
var inst_18900 = (state_18914[(2)]);
var state_18914__$1 = state_18914;
var statearr_18935_18966 = state_18914__$1;
(statearr_18935_18966[(2)] = inst_18900);

(statearr_18935_18966[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18915 === (2))){
var state_18914__$1 = state_18914;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18914__$1,(4),in$);
} else {
if((state_val_18915 === (23))){
var inst_18908 = (state_18914[(2)]);
var state_18914__$1 = state_18914;
var statearr_18936_18967 = state_18914__$1;
(statearr_18936_18967[(2)] = inst_18908);

(statearr_18936_18967[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18915 === (19))){
var inst_18895 = (state_18914[(2)]);
var state_18914__$1 = state_18914;
var statearr_18937_18968 = state_18914__$1;
(statearr_18937_18968[(2)] = inst_18895);

(statearr_18937_18968[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18915 === (11))){
var inst_18880 = (state_18914[(7)]);
var inst_18866 = (state_18914[(12)]);
var inst_18880__$1 = cljs.core.seq(inst_18866);
var state_18914__$1 = (function (){var statearr_18938 = state_18914;
(statearr_18938[(7)] = inst_18880__$1);

return statearr_18938;
})();
if(inst_18880__$1){
var statearr_18939_18969 = state_18914__$1;
(statearr_18939_18969[(1)] = (14));

} else {
var statearr_18940_18970 = state_18914__$1;
(statearr_18940_18970[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18915 === (9))){
var inst_18902 = (state_18914[(2)]);
var inst_18903 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_18914__$1 = (function (){var statearr_18941 = state_18914;
(statearr_18941[(15)] = inst_18902);

return statearr_18941;
})();
if(cljs.core.truth_(inst_18903)){
var statearr_18942_18971 = state_18914__$1;
(statearr_18942_18971[(1)] = (21));

} else {
var statearr_18943_18972 = state_18914__$1;
(statearr_18943_18972[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18915 === (5))){
var inst_18858 = cljs.core.async.close_BANG_(out);
var state_18914__$1 = state_18914;
var statearr_18944_18973 = state_18914__$1;
(statearr_18944_18973[(2)] = inst_18858);

(statearr_18944_18973[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18915 === (14))){
var inst_18880 = (state_18914[(7)]);
var inst_18882 = cljs.core.chunked_seq_QMARK_(inst_18880);
var state_18914__$1 = state_18914;
if(inst_18882){
var statearr_18945_18974 = state_18914__$1;
(statearr_18945_18974[(1)] = (17));

} else {
var statearr_18946_18975 = state_18914__$1;
(statearr_18946_18975[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18915 === (16))){
var inst_18898 = (state_18914[(2)]);
var state_18914__$1 = state_18914;
var statearr_18947_18976 = state_18914__$1;
(statearr_18947_18976[(2)] = inst_18898);

(statearr_18947_18976[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18915 === (10))){
var inst_18867 = (state_18914[(8)]);
var inst_18869 = (state_18914[(10)]);
var inst_18874 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_18867,inst_18869);
var state_18914__$1 = state_18914;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18914__$1,(13),out,inst_18874);
} else {
if((state_val_18915 === (18))){
var inst_18880 = (state_18914[(7)]);
var inst_18889 = cljs.core.first(inst_18880);
var state_18914__$1 = state_18914;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18914__$1,(20),out,inst_18889);
} else {
if((state_val_18915 === (8))){
var inst_18868 = (state_18914[(9)]);
var inst_18869 = (state_18914[(10)]);
var inst_18871 = (inst_18869 < inst_18868);
var inst_18872 = inst_18871;
var state_18914__$1 = state_18914;
if(cljs.core.truth_(inst_18872)){
var statearr_18948_18977 = state_18914__$1;
(statearr_18948_18977[(1)] = (10));

} else {
var statearr_18949_18978 = state_18914__$1;
(statearr_18949_18978[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__17178__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__17178__auto____0 = (function (){
var statearr_18950 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18950[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__17178__auto__);

(statearr_18950[(1)] = (1));

return statearr_18950;
});
var cljs$core$async$mapcat_STAR__$_state_machine__17178__auto____1 = (function (state_18914){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_18914);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e18951){var ex__17181__auto__ = e18951;
var statearr_18952_18979 = state_18914;
(statearr_18952_18979[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_18914[(4)]))){
var statearr_18953_18980 = state_18914;
(statearr_18953_18980[(1)] = cljs.core.first((state_18914[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18981 = state_18914;
state_18914 = G__18981;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__17178__auto__ = function(state_18914){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__17178__auto____1.call(this,state_18914);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__17178__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__17178__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_18954 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_18954[(6)] = c__17304__auto__);

return statearr_18954;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));

return c__17304__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__18983 = arguments.length;
switch (G__18983) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__18986 = arguments.length;
switch (G__18986) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__18989 = arguments.length;
switch (G__18989) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17304__auto___19037 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_19013){
var state_val_19014 = (state_19013[(1)]);
if((state_val_19014 === (7))){
var inst_19008 = (state_19013[(2)]);
var state_19013__$1 = state_19013;
var statearr_19015_19038 = state_19013__$1;
(statearr_19015_19038[(2)] = inst_19008);

(statearr_19015_19038[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19014 === (1))){
var inst_18990 = null;
var state_19013__$1 = (function (){var statearr_19016 = state_19013;
(statearr_19016[(7)] = inst_18990);

return statearr_19016;
})();
var statearr_19017_19039 = state_19013__$1;
(statearr_19017_19039[(2)] = null);

(statearr_19017_19039[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19014 === (4))){
var inst_18993 = (state_19013[(8)]);
var inst_18993__$1 = (state_19013[(2)]);
var inst_18994 = (inst_18993__$1 == null);
var inst_18995 = cljs.core.not(inst_18994);
var state_19013__$1 = (function (){var statearr_19018 = state_19013;
(statearr_19018[(8)] = inst_18993__$1);

return statearr_19018;
})();
if(inst_18995){
var statearr_19019_19040 = state_19013__$1;
(statearr_19019_19040[(1)] = (5));

} else {
var statearr_19020_19041 = state_19013__$1;
(statearr_19020_19041[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19014 === (6))){
var state_19013__$1 = state_19013;
var statearr_19021_19042 = state_19013__$1;
(statearr_19021_19042[(2)] = null);

(statearr_19021_19042[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19014 === (3))){
var inst_19010 = (state_19013[(2)]);
var inst_19011 = cljs.core.async.close_BANG_(out);
var state_19013__$1 = (function (){var statearr_19022 = state_19013;
(statearr_19022[(9)] = inst_19010);

return statearr_19022;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_19013__$1,inst_19011);
} else {
if((state_val_19014 === (2))){
var state_19013__$1 = state_19013;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19013__$1,(4),ch);
} else {
if((state_val_19014 === (11))){
var inst_18993 = (state_19013[(8)]);
var inst_19002 = (state_19013[(2)]);
var inst_18990 = inst_18993;
var state_19013__$1 = (function (){var statearr_19023 = state_19013;
(statearr_19023[(7)] = inst_18990);

(statearr_19023[(10)] = inst_19002);

return statearr_19023;
})();
var statearr_19024_19043 = state_19013__$1;
(statearr_19024_19043[(2)] = null);

(statearr_19024_19043[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19014 === (9))){
var inst_18993 = (state_19013[(8)]);
var state_19013__$1 = state_19013;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19013__$1,(11),out,inst_18993);
} else {
if((state_val_19014 === (5))){
var inst_18990 = (state_19013[(7)]);
var inst_18993 = (state_19013[(8)]);
var inst_18997 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_18993,inst_18990);
var state_19013__$1 = state_19013;
if(inst_18997){
var statearr_19026_19044 = state_19013__$1;
(statearr_19026_19044[(1)] = (8));

} else {
var statearr_19027_19045 = state_19013__$1;
(statearr_19027_19045[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19014 === (10))){
var inst_19005 = (state_19013[(2)]);
var state_19013__$1 = state_19013;
var statearr_19028_19046 = state_19013__$1;
(statearr_19028_19046[(2)] = inst_19005);

(statearr_19028_19046[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19014 === (8))){
var inst_18990 = (state_19013[(7)]);
var tmp19025 = inst_18990;
var inst_18990__$1 = tmp19025;
var state_19013__$1 = (function (){var statearr_19029 = state_19013;
(statearr_19029[(7)] = inst_18990__$1);

return statearr_19029;
})();
var statearr_19030_19047 = state_19013__$1;
(statearr_19030_19047[(2)] = null);

(statearr_19030_19047[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__17178__auto__ = null;
var cljs$core$async$state_machine__17178__auto____0 = (function (){
var statearr_19031 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19031[(0)] = cljs$core$async$state_machine__17178__auto__);

(statearr_19031[(1)] = (1));

return statearr_19031;
});
var cljs$core$async$state_machine__17178__auto____1 = (function (state_19013){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_19013);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e19032){var ex__17181__auto__ = e19032;
var statearr_19033_19048 = state_19013;
(statearr_19033_19048[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_19013[(4)]))){
var statearr_19034_19049 = state_19013;
(statearr_19034_19049[(1)] = cljs.core.first((state_19013[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19050 = state_19013;
state_19013 = G__19050;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$state_machine__17178__auto__ = function(state_19013){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17178__auto____1.call(this,state_19013);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17178__auto____0;
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17178__auto____1;
return cljs$core$async$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_19035 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_19035[(6)] = c__17304__auto___19037);

return statearr_19035;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__19052 = arguments.length;
switch (G__19052) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17304__auto___19119 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_19090){
var state_val_19091 = (state_19090[(1)]);
if((state_val_19091 === (7))){
var inst_19086 = (state_19090[(2)]);
var state_19090__$1 = state_19090;
var statearr_19092_19120 = state_19090__$1;
(statearr_19092_19120[(2)] = inst_19086);

(statearr_19092_19120[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19091 === (1))){
var inst_19053 = (new Array(n));
var inst_19054 = inst_19053;
var inst_19055 = (0);
var state_19090__$1 = (function (){var statearr_19093 = state_19090;
(statearr_19093[(7)] = inst_19054);

(statearr_19093[(8)] = inst_19055);

return statearr_19093;
})();
var statearr_19094_19121 = state_19090__$1;
(statearr_19094_19121[(2)] = null);

(statearr_19094_19121[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19091 === (4))){
var inst_19058 = (state_19090[(9)]);
var inst_19058__$1 = (state_19090[(2)]);
var inst_19059 = (inst_19058__$1 == null);
var inst_19060 = cljs.core.not(inst_19059);
var state_19090__$1 = (function (){var statearr_19095 = state_19090;
(statearr_19095[(9)] = inst_19058__$1);

return statearr_19095;
})();
if(inst_19060){
var statearr_19096_19122 = state_19090__$1;
(statearr_19096_19122[(1)] = (5));

} else {
var statearr_19097_19123 = state_19090__$1;
(statearr_19097_19123[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19091 === (15))){
var inst_19080 = (state_19090[(2)]);
var state_19090__$1 = state_19090;
var statearr_19098_19124 = state_19090__$1;
(statearr_19098_19124[(2)] = inst_19080);

(statearr_19098_19124[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19091 === (13))){
var state_19090__$1 = state_19090;
var statearr_19099_19125 = state_19090__$1;
(statearr_19099_19125[(2)] = null);

(statearr_19099_19125[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19091 === (6))){
var inst_19055 = (state_19090[(8)]);
var inst_19076 = (inst_19055 > (0));
var state_19090__$1 = state_19090;
if(cljs.core.truth_(inst_19076)){
var statearr_19100_19126 = state_19090__$1;
(statearr_19100_19126[(1)] = (12));

} else {
var statearr_19101_19127 = state_19090__$1;
(statearr_19101_19127[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19091 === (3))){
var inst_19088 = (state_19090[(2)]);
var state_19090__$1 = state_19090;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19090__$1,inst_19088);
} else {
if((state_val_19091 === (12))){
var inst_19054 = (state_19090[(7)]);
var inst_19078 = cljs.core.vec(inst_19054);
var state_19090__$1 = state_19090;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19090__$1,(15),out,inst_19078);
} else {
if((state_val_19091 === (2))){
var state_19090__$1 = state_19090;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19090__$1,(4),ch);
} else {
if((state_val_19091 === (11))){
var inst_19070 = (state_19090[(2)]);
var inst_19071 = (new Array(n));
var inst_19054 = inst_19071;
var inst_19055 = (0);
var state_19090__$1 = (function (){var statearr_19102 = state_19090;
(statearr_19102[(7)] = inst_19054);

(statearr_19102[(10)] = inst_19070);

(statearr_19102[(8)] = inst_19055);

return statearr_19102;
})();
var statearr_19103_19128 = state_19090__$1;
(statearr_19103_19128[(2)] = null);

(statearr_19103_19128[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19091 === (9))){
var inst_19054 = (state_19090[(7)]);
var inst_19068 = cljs.core.vec(inst_19054);
var state_19090__$1 = state_19090;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19090__$1,(11),out,inst_19068);
} else {
if((state_val_19091 === (5))){
var inst_19054 = (state_19090[(7)]);
var inst_19058 = (state_19090[(9)]);
var inst_19063 = (state_19090[(11)]);
var inst_19055 = (state_19090[(8)]);
var inst_19062 = (inst_19054[inst_19055] = inst_19058);
var inst_19063__$1 = (inst_19055 + (1));
var inst_19064 = (inst_19063__$1 < n);
var state_19090__$1 = (function (){var statearr_19104 = state_19090;
(statearr_19104[(11)] = inst_19063__$1);

(statearr_19104[(12)] = inst_19062);

return statearr_19104;
})();
if(cljs.core.truth_(inst_19064)){
var statearr_19105_19129 = state_19090__$1;
(statearr_19105_19129[(1)] = (8));

} else {
var statearr_19106_19130 = state_19090__$1;
(statearr_19106_19130[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19091 === (14))){
var inst_19083 = (state_19090[(2)]);
var inst_19084 = cljs.core.async.close_BANG_(out);
var state_19090__$1 = (function (){var statearr_19108 = state_19090;
(statearr_19108[(13)] = inst_19083);

return statearr_19108;
})();
var statearr_19109_19131 = state_19090__$1;
(statearr_19109_19131[(2)] = inst_19084);

(statearr_19109_19131[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19091 === (10))){
var inst_19074 = (state_19090[(2)]);
var state_19090__$1 = state_19090;
var statearr_19110_19132 = state_19090__$1;
(statearr_19110_19132[(2)] = inst_19074);

(statearr_19110_19132[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19091 === (8))){
var inst_19054 = (state_19090[(7)]);
var inst_19063 = (state_19090[(11)]);
var tmp19107 = inst_19054;
var inst_19054__$1 = tmp19107;
var inst_19055 = inst_19063;
var state_19090__$1 = (function (){var statearr_19111 = state_19090;
(statearr_19111[(7)] = inst_19054__$1);

(statearr_19111[(8)] = inst_19055);

return statearr_19111;
})();
var statearr_19112_19133 = state_19090__$1;
(statearr_19112_19133[(2)] = null);

(statearr_19112_19133[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__17178__auto__ = null;
var cljs$core$async$state_machine__17178__auto____0 = (function (){
var statearr_19113 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19113[(0)] = cljs$core$async$state_machine__17178__auto__);

(statearr_19113[(1)] = (1));

return statearr_19113;
});
var cljs$core$async$state_machine__17178__auto____1 = (function (state_19090){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_19090);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e19114){var ex__17181__auto__ = e19114;
var statearr_19115_19134 = state_19090;
(statearr_19115_19134[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_19090[(4)]))){
var statearr_19116_19135 = state_19090;
(statearr_19116_19135[(1)] = cljs.core.first((state_19090[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19136 = state_19090;
state_19090 = G__19136;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$state_machine__17178__auto__ = function(state_19090){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17178__auto____1.call(this,state_19090);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17178__auto____0;
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17178__auto____1;
return cljs$core$async$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_19117 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_19117[(6)] = c__17304__auto___19119);

return statearr_19117;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__19138 = arguments.length;
switch (G__19138) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17304__auto___19216 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__17305__auto__ = (function (){var switch__17177__auto__ = (function (state_19183){
var state_val_19184 = (state_19183[(1)]);
if((state_val_19184 === (7))){
var inst_19179 = (state_19183[(2)]);
var state_19183__$1 = state_19183;
var statearr_19185_19217 = state_19183__$1;
(statearr_19185_19217[(2)] = inst_19179);

(statearr_19185_19217[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19184 === (1))){
var inst_19139 = [];
var inst_19140 = inst_19139;
var inst_19141 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_19183__$1 = (function (){var statearr_19186 = state_19183;
(statearr_19186[(7)] = inst_19141);

(statearr_19186[(8)] = inst_19140);

return statearr_19186;
})();
var statearr_19187_19218 = state_19183__$1;
(statearr_19187_19218[(2)] = null);

(statearr_19187_19218[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19184 === (4))){
var inst_19144 = (state_19183[(9)]);
var inst_19144__$1 = (state_19183[(2)]);
var inst_19145 = (inst_19144__$1 == null);
var inst_19146 = cljs.core.not(inst_19145);
var state_19183__$1 = (function (){var statearr_19188 = state_19183;
(statearr_19188[(9)] = inst_19144__$1);

return statearr_19188;
})();
if(inst_19146){
var statearr_19189_19219 = state_19183__$1;
(statearr_19189_19219[(1)] = (5));

} else {
var statearr_19190_19220 = state_19183__$1;
(statearr_19190_19220[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19184 === (15))){
var inst_19140 = (state_19183[(8)]);
var inst_19171 = cljs.core.vec(inst_19140);
var state_19183__$1 = state_19183;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19183__$1,(18),out,inst_19171);
} else {
if((state_val_19184 === (13))){
var inst_19166 = (state_19183[(2)]);
var state_19183__$1 = state_19183;
var statearr_19191_19221 = state_19183__$1;
(statearr_19191_19221[(2)] = inst_19166);

(statearr_19191_19221[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19184 === (6))){
var inst_19140 = (state_19183[(8)]);
var inst_19168 = inst_19140.length;
var inst_19169 = (inst_19168 > (0));
var state_19183__$1 = state_19183;
if(cljs.core.truth_(inst_19169)){
var statearr_19192_19222 = state_19183__$1;
(statearr_19192_19222[(1)] = (15));

} else {
var statearr_19193_19223 = state_19183__$1;
(statearr_19193_19223[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19184 === (17))){
var inst_19176 = (state_19183[(2)]);
var inst_19177 = cljs.core.async.close_BANG_(out);
var state_19183__$1 = (function (){var statearr_19194 = state_19183;
(statearr_19194[(10)] = inst_19176);

return statearr_19194;
})();
var statearr_19195_19224 = state_19183__$1;
(statearr_19195_19224[(2)] = inst_19177);

(statearr_19195_19224[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19184 === (3))){
var inst_19181 = (state_19183[(2)]);
var state_19183__$1 = state_19183;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19183__$1,inst_19181);
} else {
if((state_val_19184 === (12))){
var inst_19140 = (state_19183[(8)]);
var inst_19159 = cljs.core.vec(inst_19140);
var state_19183__$1 = state_19183;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19183__$1,(14),out,inst_19159);
} else {
if((state_val_19184 === (2))){
var state_19183__$1 = state_19183;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19183__$1,(4),ch);
} else {
if((state_val_19184 === (11))){
var inst_19144 = (state_19183[(9)]);
var inst_19148 = (state_19183[(11)]);
var inst_19140 = (state_19183[(8)]);
var inst_19156 = inst_19140.push(inst_19144);
var tmp19196 = inst_19140;
var inst_19140__$1 = tmp19196;
var inst_19141 = inst_19148;
var state_19183__$1 = (function (){var statearr_19197 = state_19183;
(statearr_19197[(7)] = inst_19141);

(statearr_19197[(12)] = inst_19156);

(statearr_19197[(8)] = inst_19140__$1);

return statearr_19197;
})();
var statearr_19198_19225 = state_19183__$1;
(statearr_19198_19225[(2)] = null);

(statearr_19198_19225[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19184 === (9))){
var inst_19141 = (state_19183[(7)]);
var inst_19152 = cljs.core.keyword_identical_QMARK_(inst_19141,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_19183__$1 = state_19183;
var statearr_19199_19226 = state_19183__$1;
(statearr_19199_19226[(2)] = inst_19152);

(statearr_19199_19226[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19184 === (5))){
var inst_19141 = (state_19183[(7)]);
var inst_19144 = (state_19183[(9)]);
var inst_19148 = (state_19183[(11)]);
var inst_19149 = (state_19183[(13)]);
var inst_19148__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_19144) : f.call(null,inst_19144));
var inst_19149__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_19148__$1,inst_19141);
var state_19183__$1 = (function (){var statearr_19200 = state_19183;
(statearr_19200[(11)] = inst_19148__$1);

(statearr_19200[(13)] = inst_19149__$1);

return statearr_19200;
})();
if(inst_19149__$1){
var statearr_19201_19227 = state_19183__$1;
(statearr_19201_19227[(1)] = (8));

} else {
var statearr_19202_19228 = state_19183__$1;
(statearr_19202_19228[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19184 === (14))){
var inst_19144 = (state_19183[(9)]);
var inst_19148 = (state_19183[(11)]);
var inst_19161 = (state_19183[(2)]);
var inst_19162 = [];
var inst_19163 = inst_19162.push(inst_19144);
var inst_19140 = inst_19162;
var inst_19141 = inst_19148;
var state_19183__$1 = (function (){var statearr_19203 = state_19183;
(statearr_19203[(7)] = inst_19141);

(statearr_19203[(14)] = inst_19163);

(statearr_19203[(8)] = inst_19140);

(statearr_19203[(15)] = inst_19161);

return statearr_19203;
})();
var statearr_19204_19229 = state_19183__$1;
(statearr_19204_19229[(2)] = null);

(statearr_19204_19229[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19184 === (16))){
var state_19183__$1 = state_19183;
var statearr_19205_19230 = state_19183__$1;
(statearr_19205_19230[(2)] = null);

(statearr_19205_19230[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19184 === (10))){
var inst_19154 = (state_19183[(2)]);
var state_19183__$1 = state_19183;
if(cljs.core.truth_(inst_19154)){
var statearr_19206_19231 = state_19183__$1;
(statearr_19206_19231[(1)] = (11));

} else {
var statearr_19207_19232 = state_19183__$1;
(statearr_19207_19232[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19184 === (18))){
var inst_19173 = (state_19183[(2)]);
var state_19183__$1 = state_19183;
var statearr_19208_19233 = state_19183__$1;
(statearr_19208_19233[(2)] = inst_19173);

(statearr_19208_19233[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19184 === (8))){
var inst_19149 = (state_19183[(13)]);
var state_19183__$1 = state_19183;
var statearr_19209_19234 = state_19183__$1;
(statearr_19209_19234[(2)] = inst_19149);

(statearr_19209_19234[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__17178__auto__ = null;
var cljs$core$async$state_machine__17178__auto____0 = (function (){
var statearr_19210 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19210[(0)] = cljs$core$async$state_machine__17178__auto__);

(statearr_19210[(1)] = (1));

return statearr_19210;
});
var cljs$core$async$state_machine__17178__auto____1 = (function (state_19183){
while(true){
var ret_value__17179__auto__ = (function (){try{while(true){
var result__17180__auto__ = switch__17177__auto__(state_19183);
if(cljs.core.keyword_identical_QMARK_(result__17180__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__17180__auto__;
}
break;
}
}catch (e19211){var ex__17181__auto__ = e19211;
var statearr_19212_19235 = state_19183;
(statearr_19212_19235[(2)] = ex__17181__auto__);


if(cljs.core.seq((state_19183[(4)]))){
var statearr_19213_19236 = state_19183;
(statearr_19213_19236[(1)] = cljs.core.first((state_19183[(4)])));

} else {
throw ex__17181__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17179__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19237 = state_19183;
state_19183 = G__19237;
continue;
} else {
return ret_value__17179__auto__;
}
break;
}
});
cljs$core$async$state_machine__17178__auto__ = function(state_19183){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17178__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17178__auto____1.call(this,state_19183);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17178__auto____0;
cljs$core$async$state_machine__17178__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17178__auto____1;
return cljs$core$async$state_machine__17178__auto__;
})()
})();
var state__17306__auto__ = (function (){var statearr_19214 = (f__17305__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17305__auto__.cljs$core$IFn$_invoke$arity$0() : f__17305__auto__.call(null));
(statearr_19214[(6)] = c__17304__auto___19216);

return statearr_19214;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17306__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);

