// Compiled by ClojureScript 1.10.879 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('instaparse.failure');
goog.require('cljs.core');
goog.require('instaparse.print');
/**
 * Takes an index into text, and determines the line and column info
 */
instaparse.failure.index__GT_line_column = (function instaparse$failure$index__GT_line_column(index,text){
var line = (1);
var col = (1);
var counter = (0);
while(true){
if(cljs.core._EQ_.call(null,index,counter)){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"column","column",2078222095),col], null);
} else {
if(cljs.core._EQ_.call(null,"\n",cljs.core.get.call(null,text,counter))){
var G__86667 = (line + (1));
var G__86668 = (1);
var G__86669 = (counter + (1));
line = G__86667;
col = G__86668;
counter = G__86669;
continue;
} else {
var G__86670 = line;
var G__86671 = (col + (1));
var G__86672 = (counter + (1));
line = G__86670;
col = G__86671;
counter = G__86672;
continue;

}
}
break;
}
});
instaparse.failure.get_line = (function instaparse$failure$get_line(n,text){
var chars = cljs.core.seq.call(null,clojure.string.replace.call(null,text,"\r\n","\n"));
var n__$1 = n;
while(true){
if(cljs.core.empty_QMARK_.call(null,chars)){
return "";
} else {
if(cljs.core._EQ_.call(null,n__$1,(1))){
return cljs.core.apply.call(null,cljs.core.str,cljs.core.take_while.call(null,cljs.core.complement.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["\n",null], null), null)),chars));
} else {
if(cljs.core._EQ_.call(null,"\n",cljs.core.first.call(null,chars))){
var G__86673 = cljs.core.next.call(null,chars);
var G__86674 = (n__$1 - (1));
chars = G__86673;
n__$1 = G__86674;
continue;
} else {
var G__86675 = cljs.core.next.call(null,chars);
var G__86676 = n__$1;
chars = G__86675;
n__$1 = G__86676;
continue;

}
}
}
break;
}
});
/**
 * Creates string with caret at nth position, 1-based
 */
instaparse.failure.marker = (function instaparse$failure$marker(n){
if(cljs.core.integer_QMARK_.call(null,n)){
if((n <= (1))){
return "^";
} else {
return cljs.core.apply.call(null,cljs.core.str,cljs.core.concat.call(null,cljs.core.repeat.call(null,(n - (1))," "),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["^"], null)));
}
} else {
return null;
}
});
/**
 * Adds text, line, and column info to failure object.
 */
instaparse.failure.augment_failure = (function instaparse$failure$augment_failure(failure,text){
var lc = instaparse.failure.index__GT_line_column.call(null,new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(failure),text);
return cljs.core.merge.call(null,failure,lc,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"text","text",-1790561697),instaparse.failure.get_line.call(null,new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(lc),text)], null));
});
/**
 * Provides special case for printing negative lookahead reasons
 */
instaparse.failure.print_reason = (function instaparse$failure$print_reason(r){
if(cljs.core.truth_(new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r))){
cljs.core.print.call(null,"NOT ");

return cljs.core.print.call(null,new cljs.core.Keyword(null,"NOT","NOT",-1689245341).cljs$core$IFn$_invoke$arity$1(r));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"char-range","char-range",1443391389).cljs$core$IFn$_invoke$arity$1(r))){
return cljs.core.print.call(null,instaparse.print.char_range__GT_str.call(null,r));
} else {
if((r instanceof RegExp)){
return cljs.core.print.call(null,instaparse.print.regexp__GT_str.call(null,r));
} else {
return cljs.core.pr.call(null,r);

}
}
}
});
/**
 * Takes an augmented failure object and prints the error message
 */
instaparse.failure.pprint_failure = (function instaparse$failure$pprint_failure(p__86677){
var map__86678 = p__86677;
var map__86678__$1 = cljs.core.__destructure_map.call(null,map__86678);
var line = cljs.core.get.call(null,map__86678__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__86678__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var text = cljs.core.get.call(null,map__86678__$1,new cljs.core.Keyword(null,"text","text",-1790561697));
var reason = cljs.core.get.call(null,map__86678__$1,new cljs.core.Keyword(null,"reason","reason",-2070751759));
cljs.core.println.call(null,["Parse error at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column),":"].join(''));

cljs.core.println.call(null,text);

cljs.core.println.call(null,instaparse.failure.marker.call(null,column));

var full_reasons = cljs.core.distinct.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.call(null,new cljs.core.Keyword(null,"full","full",436801220),reason)));
var partial_reasons = cljs.core.distinct.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"expecting","expecting",-57706705),cljs.core.filter.call(null,cljs.core.complement.call(null,new cljs.core.Keyword(null,"full","full",436801220)),reason)));
var total = (cljs.core.count.call(null,full_reasons) + cljs.core.count.call(null,partial_reasons));
if((total === (0))){
} else {
if(cljs.core._EQ_.call(null,(1),total)){
cljs.core.println.call(null,"Expected:");
} else {
cljs.core.println.call(null,"Expected one of:");

}
}

var seq__86679_86687 = cljs.core.seq.call(null,full_reasons);
var chunk__86680_86688 = null;
var count__86681_86689 = (0);
var i__86682_86690 = (0);
while(true){
if((i__86682_86690 < count__86681_86689)){
var r_86691 = cljs.core._nth.call(null,chunk__86680_86688,i__86682_86690);
instaparse.failure.print_reason.call(null,r_86691);

cljs.core.println.call(null," (followed by end-of-string)");


var G__86692 = seq__86679_86687;
var G__86693 = chunk__86680_86688;
var G__86694 = count__86681_86689;
var G__86695 = (i__86682_86690 + (1));
seq__86679_86687 = G__86692;
chunk__86680_86688 = G__86693;
count__86681_86689 = G__86694;
i__86682_86690 = G__86695;
continue;
} else {
var temp__5753__auto___86696 = cljs.core.seq.call(null,seq__86679_86687);
if(temp__5753__auto___86696){
var seq__86679_86697__$1 = temp__5753__auto___86696;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__86679_86697__$1)){
var c__4638__auto___86698 = cljs.core.chunk_first.call(null,seq__86679_86697__$1);
var G__86699 = cljs.core.chunk_rest.call(null,seq__86679_86697__$1);
var G__86700 = c__4638__auto___86698;
var G__86701 = cljs.core.count.call(null,c__4638__auto___86698);
var G__86702 = (0);
seq__86679_86687 = G__86699;
chunk__86680_86688 = G__86700;
count__86681_86689 = G__86701;
i__86682_86690 = G__86702;
continue;
} else {
var r_86703 = cljs.core.first.call(null,seq__86679_86697__$1);
instaparse.failure.print_reason.call(null,r_86703);

cljs.core.println.call(null," (followed by end-of-string)");


var G__86704 = cljs.core.next.call(null,seq__86679_86697__$1);
var G__86705 = null;
var G__86706 = (0);
var G__86707 = (0);
seq__86679_86687 = G__86704;
chunk__86680_86688 = G__86705;
count__86681_86689 = G__86706;
i__86682_86690 = G__86707;
continue;
}
} else {
}
}
break;
}

var seq__86683 = cljs.core.seq.call(null,partial_reasons);
var chunk__86684 = null;
var count__86685 = (0);
var i__86686 = (0);
while(true){
if((i__86686 < count__86685)){
var r = cljs.core._nth.call(null,chunk__86684,i__86686);
instaparse.failure.print_reason.call(null,r);

cljs.core.println.call(null);


var G__86708 = seq__86683;
var G__86709 = chunk__86684;
var G__86710 = count__86685;
var G__86711 = (i__86686 + (1));
seq__86683 = G__86708;
chunk__86684 = G__86709;
count__86685 = G__86710;
i__86686 = G__86711;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__86683);
if(temp__5753__auto__){
var seq__86683__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__86683__$1)){
var c__4638__auto__ = cljs.core.chunk_first.call(null,seq__86683__$1);
var G__86712 = cljs.core.chunk_rest.call(null,seq__86683__$1);
var G__86713 = c__4638__auto__;
var G__86714 = cljs.core.count.call(null,c__4638__auto__);
var G__86715 = (0);
seq__86683 = G__86712;
chunk__86684 = G__86713;
count__86685 = G__86714;
i__86686 = G__86715;
continue;
} else {
var r = cljs.core.first.call(null,seq__86683__$1);
instaparse.failure.print_reason.call(null,r);

cljs.core.println.call(null);


var G__86716 = cljs.core.next.call(null,seq__86683__$1);
var G__86717 = null;
var G__86718 = (0);
var G__86719 = (0);
seq__86683 = G__86716;
chunk__86684 = G__86717;
count__86685 = G__86718;
i__86686 = G__86719;
continue;
}
} else {
return null;
}
}
break;
}
});
