// Compiled by ClojureScript 1.10.879 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.util.json');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('fluree.db.util.bytes');
goog.require('fluree.db.util.core');
fluree.db.util.json.clj__GT_js_SINGLEQUOTE_ = (function fluree$db$util$json$clj__GT_js_SINGLEQUOTE_(var_args){
var G__31097 = arguments.length;
switch (G__31097) {
case 1:
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.call(null,x,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keyword-fn","keyword-fn",-64566675),fluree.db.util.core.keyword__GT_str], null));
}));

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2 = (function (x,options){
var map__31098 = options;
var map__31098__$1 = cljs.core.__destructure_map.call(null,map__31098);
var keyword_fn = cljs.core.get.call(null,map__31098__$1,new cljs.core.Keyword(null,"keyword-fn","keyword-fn",-64566675));
var keyfn = (function fluree$db$util$json$keyfn(k){
return cljs.core.key__GT_js.call(null,k,thisfn);
});
var thisfn = (function fluree$db$util$json$thisfn(x__$1){
if((x__$1 == null)){
return null;
} else {
if((((!((x__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === x__$1.cljs$core$IEncodeJS$))))?true:(((!x__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IEncodeJS,x__$1):false)):cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IEncodeJS,x__$1))){
return cljs.core._clj__GT_js.call(null,x__$1);
} else {
if((x__$1 instanceof cljs.core.Keyword)){
return keyword_fn.call(null,x__$1);
} else {
if((x__$1 instanceof cljs.core.Symbol)){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(x__$1);
} else {
if(cljs.core.map_QMARK_.call(null,x__$1)){
var m = ({});
var seq__31125_31146 = cljs.core.seq.call(null,x__$1);
var chunk__31126_31147 = null;
var count__31127_31148 = (0);
var i__31128_31149 = (0);
while(true){
if((i__31128_31149 < count__31127_31148)){
var vec__31135_31150 = cljs.core._nth.call(null,chunk__31126_31147,i__31128_31149);
var k_31151 = cljs.core.nth.call(null,vec__31135_31150,(0),null);
var v_31152 = cljs.core.nth.call(null,vec__31135_31150,(1),null);
goog.object.set(m,keyfn.call(null,k_31151),fluree$db$util$json$thisfn.call(null,v_31152));


var G__31153 = seq__31125_31146;
var G__31154 = chunk__31126_31147;
var G__31155 = count__31127_31148;
var G__31156 = (i__31128_31149 + (1));
seq__31125_31146 = G__31153;
chunk__31126_31147 = G__31154;
count__31127_31148 = G__31155;
i__31128_31149 = G__31156;
continue;
} else {
var temp__5753__auto___31157 = cljs.core.seq.call(null,seq__31125_31146);
if(temp__5753__auto___31157){
var seq__31125_31158__$1 = temp__5753__auto___31157;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31125_31158__$1)){
var c__4638__auto___31159 = cljs.core.chunk_first.call(null,seq__31125_31158__$1);
var G__31160 = cljs.core.chunk_rest.call(null,seq__31125_31158__$1);
var G__31161 = c__4638__auto___31159;
var G__31162 = cljs.core.count.call(null,c__4638__auto___31159);
var G__31163 = (0);
seq__31125_31146 = G__31160;
chunk__31126_31147 = G__31161;
count__31127_31148 = G__31162;
i__31128_31149 = G__31163;
continue;
} else {
var vec__31138_31164 = cljs.core.first.call(null,seq__31125_31158__$1);
var k_31165 = cljs.core.nth.call(null,vec__31138_31164,(0),null);
var v_31166 = cljs.core.nth.call(null,vec__31138_31164,(1),null);
goog.object.set(m,keyfn.call(null,k_31165),fluree$db$util$json$thisfn.call(null,v_31166));


var G__31167 = cljs.core.next.call(null,seq__31125_31158__$1);
var G__31168 = null;
var G__31169 = (0);
var G__31170 = (0);
seq__31125_31146 = G__31167;
chunk__31126_31147 = G__31168;
count__31127_31148 = G__31169;
i__31128_31149 = G__31170;
continue;
}
} else {
}
}
break;
}

return m;
} else {
if(cljs.core.coll_QMARK_.call(null,x__$1)){
var arr = [];
var seq__31141_31171 = cljs.core.seq.call(null,cljs.core.map.call(null,fluree$db$util$json$thisfn,x__$1));
var chunk__31142_31172 = null;
var count__31143_31173 = (0);
var i__31144_31174 = (0);
while(true){
if((i__31144_31174 < count__31143_31173)){
var x_31175__$2 = cljs.core._nth.call(null,chunk__31142_31172,i__31144_31174);
arr.push(x_31175__$2);


var G__31176 = seq__31141_31171;
var G__31177 = chunk__31142_31172;
var G__31178 = count__31143_31173;
var G__31179 = (i__31144_31174 + (1));
seq__31141_31171 = G__31176;
chunk__31142_31172 = G__31177;
count__31143_31173 = G__31178;
i__31144_31174 = G__31179;
continue;
} else {
var temp__5753__auto___31180 = cljs.core.seq.call(null,seq__31141_31171);
if(temp__5753__auto___31180){
var seq__31141_31181__$1 = temp__5753__auto___31180;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31141_31181__$1)){
var c__4638__auto___31182 = cljs.core.chunk_first.call(null,seq__31141_31181__$1);
var G__31183 = cljs.core.chunk_rest.call(null,seq__31141_31181__$1);
var G__31184 = c__4638__auto___31182;
var G__31185 = cljs.core.count.call(null,c__4638__auto___31182);
var G__31186 = (0);
seq__31141_31171 = G__31183;
chunk__31142_31172 = G__31184;
count__31143_31173 = G__31185;
i__31144_31174 = G__31186;
continue;
} else {
var x_31187__$2 = cljs.core.first.call(null,seq__31141_31181__$1);
arr.push(x_31187__$2);


var G__31188 = cljs.core.next.call(null,seq__31141_31181__$1);
var G__31189 = null;
var G__31190 = (0);
var G__31191 = (0);
seq__31141_31171 = G__31188;
chunk__31142_31172 = G__31189;
count__31143_31173 = G__31190;
i__31144_31174 = G__31191;
continue;
}
} else {
}
}
break;
}

return arr;
} else {
return x__$1;

}
}
}
}
}
}
});
return thisfn.call(null,x);
}));

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$lang$maxFixedArity = 2);

fluree.db.util.json.parse = (function fluree$db$util$json$parse(x){
return cljs.core.js__GT_clj.call(null,JSON.parse(((typeof x === 'string')?x:fluree.db.util.bytes.UTF8__GT_string.call(null,x))),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
});
fluree.db.util.json.stringify_preserve_namespace = (function fluree$db$util$json$stringify_preserve_namespace(x){
return JSON.stringify(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.call(null,x));
});
fluree.db.util.json.stringify = (function fluree$db$util$json$stringify(x){
return JSON.stringify(cljs.core.clj__GT_js.call(null,x));
});
fluree.db.util.json.stringify_UTF8 = (function fluree$db$util$json$stringify_UTF8(x){
return fluree.db.util.bytes.string__GT_UTF8.call(null,fluree.db.util.json.stringify.call(null,x));
});
/**
 * Given a sequence of coordinates, ensure that, for the given depth:
 * 1) they contain only sequences until
 * 2) they contain only numbers at depth 1
 */
fluree.db.util.json.valid_coordinates_QMARK_ = (function fluree$db$util$json$valid_coordinates_QMARK_(depth,coordinates){
if((depth > (0))){
} else {
throw (new Error("Assert failed: (pos? depth)"));
}

if(cljs.core._EQ_.call(null,(1),depth)){
return ((cljs.core.every_QMARK_.call(null,cljs.core.number_QMARK_,coordinates)) && (((2) <= cljs.core.count.call(null,coordinates))));
} else {
return (((!((coordinates == null)))) && (((cljs.core.every_QMARK_.call(null,cljs.core.sequential_QMARK_,coordinates)) && (cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,(function (p1__31192_SHARP_){
return fluree.db.util.json.valid_coordinates_QMARK_.call(null,(depth - (1)),p1__31192_SHARP_);
}),coordinates))))));
}
});
/**
 * Checks to make sure that the given coordinates are valid linear rings, which
 * is a requirement for Polygon types.
 */
fluree.db.util.json.linear_ring_QMARK_ = (function fluree$db$util$json$linear_ring_QMARK_(coordinates){
return ((cljs.core.sequential_QMARK_.call(null,coordinates)) && (((((4) <= cljs.core.count.call(null,coordinates))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,coordinates),cljs.core.last.call(null,coordinates))))));
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.util !== 'undefined') && (typeof fluree.db.util.json !== 'undefined') && (typeof fluree.db.util.json.valid_geojson_QMARK_ !== 'undefined')){
} else {
fluree.db.util.json.valid_geojson_QMARK_ = (function (){var method_table__4701__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4702__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4703__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4704__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4705__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fluree.db.util.json","valid-geojson?"),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4705__auto__,method_table__4701__auto__,prefer_table__4702__auto__,method_cache__4703__auto__,cached_hierarchy__4704__auto__));
})();
}
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"Feature",(function (geometry){
var and__4210__auto__ = (function (){var or__4212__auto__ = fluree.db.util.json.valid_geojson_QMARK_.call(null,new cljs.core.Keyword(null,"geometry","geometry",-405034994).cljs$core$IFn$_invoke$arity$1(geometry));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (new cljs.core.Keyword(null,"geometry","geometry",-405034994).cljs$core$IFn$_invoke$arity$1(geometry) == null);
}
})();
if(cljs.core.truth_(and__4210__auto__)){
return ((cljs.core.map_QMARK_.call(null,new cljs.core.Keyword(null,"properties","properties",685819552).cljs$core$IFn$_invoke$arity$1(geometry))) || ((new cljs.core.Keyword(null,"properties","properties",685819552).cljs$core$IFn$_invoke$arity$1(geometry) == null)));
} else {
return and__4210__auto__;
}
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"FeatureCollection",(function (geometry){
return ((cljs.core.sequential_QMARK_.call(null,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,fluree.db.util.json.valid_geojson_QMARK_,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geometry)))));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"GeometryCollection",(function (geometry){
return ((cljs.core.sequential_QMARK_.call(null,new cljs.core.Keyword(null,"geometries","geometries",-1679297218).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,fluree.db.util.json.valid_geojson_QMARK_,new cljs.core.Keyword(null,"geometries","geometries",-1679297218).cljs$core$IFn$_invoke$arity$1(geometry)))));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"Point",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_.call(null,(1),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"LineString",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_.call(null,(2),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"Polygon",(function (geometry){
return ((fluree.db.util.json.valid_coordinates_QMARK_.call(null,(3),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_.call(null,fluree.db.util.json.linear_ring_QMARK_,new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"MultiPoint",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_.call(null,(2),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"MultiLineString",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_.call(null,(3),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"MultiPolygon",(function (geometry){
return ((fluree.db.util.json.valid_coordinates_QMARK_.call(null,(4),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_.call(null,(function (p1__31193_SHARP_){
return cljs.core.every_QMARK_.call(null,fluree.db.util.json.linear_ring_QMARK_,p1__31193_SHARP_);
}),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,new cljs.core.Keyword(null,"default","default",-1987822328),(function (geometry){
return false;
}));
