// Compiled by ClojureScript 1.10.879 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4212__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_28671){
var state_val_28672 = (state_28671[(1)]);
if((state_val_28672 === (7))){
var inst_28666 = (state_28671[(2)]);
var _ = (function (){var statearr_28673 = state_28671;
(statearr_28673[(4)] = cljs.core.rest.call(null,(state_28671[(4)])));

return statearr_28673;
})();
var state_28671__$1 = state_28671;
var statearr_28674_28696 = state_28671__$1;
(statearr_28674_28696[(2)] = inst_28666);

(statearr_28674_28696[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28672 === (1))){
var state_28671__$1 = state_28671;
var statearr_28675_28697 = state_28671__$1;
(statearr_28675_28697[(2)] = null);

(statearr_28675_28697[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28672 === (4))){
var inst_28628 = (state_28671[(2)]);
var state_28671__$1 = state_28671;
var statearr_28676_28698 = state_28671__$1;
(statearr_28676_28698[(2)] = inst_28628);

(statearr_28676_28698[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28672 === (6))){
var inst_28653 = (state_28671[(7)]);
var inst_28646 = (state_28671[(8)]);
var inst_28652 = cljs.core.seq.call(null,inst_28646);
var inst_28653__$1 = cljs.core.first.call(null,inst_28652);
var inst_28654 = cljs.core.next.call(null,inst_28652);
var inst_28655 = cljs.core.not.call(null,inst_28653__$1);
var state_28671__$1 = (function (){var statearr_28677 = state_28671;
(statearr_28677[(7)] = inst_28653__$1);

(statearr_28677[(9)] = inst_28654);

return statearr_28677;
})();
if(inst_28655){
var statearr_28678_28699 = state_28671__$1;
(statearr_28678_28699[(1)] = (8));

} else {
var statearr_28679_28700 = state_28671__$1;
(statearr_28679_28700[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28672 === (3))){
var inst_28669 = (state_28671[(2)]);
var state_28671__$1 = state_28671;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28671__$1,inst_28669);
} else {
if((state_val_28672 === (2))){
var _ = (function (){var statearr_28680 = state_28671;
(statearr_28680[(4)] = cljs.core.cons.call(null,(5),(state_28671[(4)])));

return statearr_28680;
})();
var inst_28641 = chs;
var inst_28642 = cljs.core.seq.call(null,inst_28641);
var inst_28643 = cljs.core.first.call(null,inst_28642);
var inst_28644 = cljs.core.next.call(null,inst_28642);
var inst_28645 = coll;
var inst_28646 = inst_28641;
var inst_28647 = inst_28645;
var state_28671__$1 = (function (){var statearr_28681 = state_28671;
(statearr_28681[(8)] = inst_28646);

(statearr_28681[(10)] = inst_28643);

(statearr_28681[(11)] = inst_28647);

(statearr_28681[(12)] = inst_28644);

return statearr_28681;
})();
var statearr_28682_28701 = state_28671__$1;
(statearr_28682_28701[(2)] = null);

(statearr_28682_28701[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28672 === (11))){
var inst_28654 = (state_28671[(9)]);
var inst_28647 = (state_28671[(11)]);
var inst_28659 = (state_28671[(2)]);
var inst_28660 = fluree.db.util.async.throw_err.call(null,inst_28659);
var inst_28661 = cljs.core.conj.call(null,inst_28647,inst_28660);
var inst_28646 = inst_28654;
var inst_28647__$1 = inst_28661;
var state_28671__$1 = (function (){var statearr_28684 = state_28671;
(statearr_28684[(8)] = inst_28646);

(statearr_28684[(11)] = inst_28647__$1);

return statearr_28684;
})();
var statearr_28685_28702 = state_28671__$1;
(statearr_28685_28702[(2)] = null);

(statearr_28685_28702[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28672 === (9))){
var inst_28653 = (state_28671[(7)]);
var state_28671__$1 = state_28671;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28671__$1,(11),inst_28653);
} else {
if((state_val_28672 === (5))){
var _ = (function (){var statearr_28686 = state_28671;
(statearr_28686[(4)] = cljs.core.rest.call(null,(state_28671[(4)])));

return statearr_28686;
})();
var state_28671__$1 = state_28671;
var ex28683 = (state_28671__$1[(2)]);
var statearr_28687_28703 = state_28671__$1;
(statearr_28687_28703[(5)] = ex28683);


var statearr_28688_28704 = state_28671__$1;
(statearr_28688_28704[(1)] = (4));

(statearr_28688_28704[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28672 === (10))){
var inst_28664 = (state_28671[(2)]);
var state_28671__$1 = state_28671;
var statearr_28689_28705 = state_28671__$1;
(statearr_28689_28705[(2)] = inst_28664);

(statearr_28689_28705[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28672 === (8))){
var inst_28647 = (state_28671[(11)]);
var state_28671__$1 = state_28671;
var statearr_28690_28706 = state_28671__$1;
(statearr_28690_28706[(2)] = inst_28647);

(statearr_28690_28706[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__16221__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__16221__auto____0 = (function (){
var statearr_28691 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28691[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__16221__auto__);

(statearr_28691[(1)] = (1));

return statearr_28691;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__16221__auto____1 = (function (state_28671){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_28671);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e28692){var ex__16224__auto__ = e28692;
var statearr_28693_28707 = state_28671;
(statearr_28693_28707[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_28671[(4)]))){
var statearr_28694_28708 = state_28671;
(statearr_28694_28708[(1)] = cljs.core.first.call(null,(state_28671[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28709 = state_28671;
state_28671 = G__28709;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__16221__auto__ = function(state_28671){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__16221__auto____1.call(this,state_28671);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__16221__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__16221__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_28695 = f__16346__auto__.call(null);
(statearr_28695[(6)] = c__16345__auto__);

return statearr_28695;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel instead of results if there is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_28735){
var state_val_28736 = (state_28735[(1)]);
if((state_val_28736 === (7))){
var inst_28730 = (state_28735[(2)]);
var _ = (function (){var statearr_28737 = state_28735;
(statearr_28737[(4)] = cljs.core.rest.call(null,(state_28735[(4)])));

return statearr_28737;
})();
var state_28735__$1 = state_28735;
var statearr_28738_28760 = state_28735__$1;
(statearr_28738_28760[(2)] = inst_28730);

(statearr_28738_28760[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28736 === (1))){
var state_28735__$1 = state_28735;
var statearr_28739_28761 = state_28735__$1;
(statearr_28739_28761[(2)] = null);

(statearr_28739_28761[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28736 === (4))){
var inst_28710 = (state_28735[(2)]);
var state_28735__$1 = state_28735;
var statearr_28740_28762 = state_28735__$1;
(statearr_28740_28762[(2)] = inst_28710);

(statearr_28740_28762[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28736 === (6))){
var state_28735__$1 = state_28735;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28735__$1,(8),chan);
} else {
if((state_val_28736 === (3))){
var inst_28733 = (state_28735[(2)]);
var state_28735__$1 = state_28735;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28735__$1,inst_28733);
} else {
if((state_val_28736 === (2))){
var _ = (function (){var statearr_28741 = state_28735;
(statearr_28741[(4)] = cljs.core.cons.call(null,(5),(state_28735[(4)])));

return statearr_28741;
})();
var inst_28716 = coll;
var inst_28717 = inst_28716;
var state_28735__$1 = (function (){var statearr_28742 = state_28735;
(statearr_28742[(7)] = inst_28717);

return statearr_28742;
})();
var statearr_28743_28763 = state_28735__$1;
(statearr_28743_28763[(2)] = null);

(statearr_28743_28763[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28736 === (11))){
var inst_28728 = (state_28735[(2)]);
var state_28735__$1 = state_28735;
var statearr_28745_28764 = state_28735__$1;
(statearr_28745_28764[(2)] = inst_28728);

(statearr_28745_28764[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28736 === (9))){
var inst_28717 = (state_28735[(7)]);
var state_28735__$1 = state_28735;
var statearr_28746_28765 = state_28735__$1;
(statearr_28746_28765[(2)] = inst_28717);

(statearr_28746_28765[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28736 === (5))){
var _ = (function (){var statearr_28747 = state_28735;
(statearr_28747[(4)] = cljs.core.rest.call(null,(state_28735[(4)])));

return statearr_28747;
})();
var state_28735__$1 = state_28735;
var ex28744 = (state_28735__$1[(2)]);
var statearr_28748_28766 = state_28735__$1;
(statearr_28748_28766[(5)] = ex28744);


var statearr_28749_28767 = state_28735__$1;
(statearr_28749_28767[(1)] = (4));

(statearr_28749_28767[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28736 === (10))){
var inst_28721 = (state_28735[(8)]);
var inst_28717 = (state_28735[(7)]);
var inst_28725 = cljs.core.conj.call(null,inst_28717,inst_28721);
var inst_28717__$1 = inst_28725;
var state_28735__$1 = (function (){var statearr_28750 = state_28735;
(statearr_28750[(7)] = inst_28717__$1);

return statearr_28750;
})();
var statearr_28751_28768 = state_28735__$1;
(statearr_28751_28768[(2)] = null);

(statearr_28751_28768[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28736 === (8))){
var inst_28721 = (state_28735[(8)]);
var inst_28720 = (state_28735[(2)]);
var inst_28721__$1 = fluree.db.util.async.throw_err.call(null,inst_28720);
var inst_28722 = (inst_28721__$1 == null);
var state_28735__$1 = (function (){var statearr_28752 = state_28735;
(statearr_28752[(8)] = inst_28721__$1);

return statearr_28752;
})();
if(cljs.core.truth_(inst_28722)){
var statearr_28753_28769 = state_28735__$1;
(statearr_28753_28769[(1)] = (9));

} else {
var statearr_28754_28770 = state_28735__$1;
(statearr_28754_28770[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__16221__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__16221__auto____0 = (function (){
var statearr_28755 = [null,null,null,null,null,null,null,null,null];
(statearr_28755[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__16221__auto__);

(statearr_28755[(1)] = (1));

return statearr_28755;
});
var fluree$db$util$async$into_QMARK__$_state_machine__16221__auto____1 = (function (state_28735){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_28735);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e28756){var ex__16224__auto__ = e28756;
var statearr_28757_28771 = state_28735;
(statearr_28757_28771[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_28735[(4)]))){
var statearr_28758_28772 = state_28735;
(statearr_28758_28772[(1)] = cljs.core.first.call(null,(state_28735[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28773 = state_28735;
state_28735 = G__28773;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__16221__auto__ = function(state_28735){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__16221__auto____1.call(this,state_28735);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__16221__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__16221__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_28759 = f__16346__auto__.call(null);
(statearr_28759[(6)] = c__16345__auto__);

return statearr_28759;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
}
});
