// Compiled by ClojureScript 1.10.879 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.call(null,cljs.core.re_find.call(null,/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_33259){
var state_val_33260 = (state_33259[(1)]);
if((state_val_33260 === (1))){
var state_33259__$1 = state_33259;
var statearr_33261_33275 = state_33259__$1;
(statearr_33261_33275[(2)] = null);

(statearr_33261_33275[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33260 === (2))){
var _ = (function (){var statearr_33262 = state_33259;
(statearr_33262[(4)] = cljs.core.cons.call(null,(5),(state_33259[(4)])));

return statearr_33262;
})();
var inst_33250 = fluree.db.dbproto._tag.call(null,db,type_tag_sid,"_predicate/type");
var state_33259__$1 = state_33259;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33259__$1,(6),inst_33250);
} else {
if((state_val_33260 === (3))){
var inst_33257 = (state_33259[(2)]);
var state_33259__$1 = state_33259;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33259__$1,inst_33257);
} else {
if((state_val_33260 === (4))){
var inst_33244 = (state_33259[(2)]);
var state_33259__$1 = state_33259;
var statearr_33264_33276 = state_33259__$1;
(statearr_33264_33276[(2)] = inst_33244);

(statearr_33264_33276[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33260 === (5))){
var _ = (function (){var statearr_33265 = state_33259;
(statearr_33265[(4)] = cljs.core.rest.call(null,(state_33259[(4)])));

return statearr_33265;
})();
var state_33259__$1 = state_33259;
var ex33263 = (state_33259__$1[(2)]);
var statearr_33266_33277 = state_33259__$1;
(statearr_33266_33277[(5)] = ex33263);


if((ex33263 instanceof Error)){
var statearr_33267_33278 = state_33259__$1;
(statearr_33267_33278[(1)] = (4));

(statearr_33267_33278[(5)] = null);

} else {
throw ex33263;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33260 === (6))){
var inst_33252 = (state_33259[(2)]);
var inst_33253 = fluree.db.util.async.throw_err.call(null,inst_33252);
var inst_33254 = cljs.core.keyword.call(null,inst_33253);
var _ = (function (){var statearr_33268 = state_33259;
(statearr_33268[(4)] = cljs.core.rest.call(null,(state_33259[(4)])));

return statearr_33268;
})();
var state_33259__$1 = state_33259;
var statearr_33269_33279 = state_33259__$1;
(statearr_33269_33279[(2)] = inst_33254);

(statearr_33269_33279[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__16221__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__16221__auto____0 = (function (){
var statearr_33270 = [null,null,null,null,null,null,null];
(statearr_33270[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__16221__auto__);

(statearr_33270[(1)] = (1));

return statearr_33270;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__16221__auto____1 = (function (state_33259){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_33259);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e33271){var ex__16224__auto__ = e33271;
var statearr_33272_33280 = state_33259;
(statearr_33272_33280[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_33259[(4)]))){
var statearr_33273_33281 = state_33259;
(statearr_33273_33281[(1)] = cljs.core.first.call(null,(state_33259[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33282 = state_33259;
state_33259 = G__33282;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__16221__auto__ = function(state_33259){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__16221__auto____1.call(this,state_33259);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__16221__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__16221__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_33274 = f__16346__auto__.call(null);
(statearr_33274[(6)] = c__16345__auto__);

return statearr_33274;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_33314){
var state_val_33315 = (state_33314[(1)]);
if((state_val_33315 === (7))){
var inst_33298 = (state_33314[(7)]);
var inst_33300 = cljs.core.empty_QMARK_.call(null,inst_33298);
var inst_33301 = (!(inst_33300));
var state_33314__$1 = state_33314;
var statearr_33316_33340 = state_33314__$1;
(statearr_33316_33340[(2)] = inst_33301);

(statearr_33316_33340[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33315 === (1))){
var state_33314__$1 = state_33314;
var statearr_33317_33341 = state_33314__$1;
(statearr_33317_33341[(2)] = null);

(statearr_33317_33341[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33315 === (4))){
var inst_33284 = (state_33314[(2)]);
var state_33314__$1 = state_33314;
var statearr_33318_33342 = state_33314__$1;
(statearr_33318_33342[(2)] = inst_33284);

(statearr_33318_33342[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33315 === (6))){
var inst_33298 = (state_33314[(7)]);
var inst_33290 = (state_33314[(8)]);
var inst_33296 = (state_33314[(2)]);
var inst_33297 = fluree.db.util.async.throw_err.call(null,inst_33296);
var inst_33298__$1 = cljs.core.map.call(null,inst_33290,inst_33297);
var state_33314__$1 = (function (){var statearr_33319 = state_33314;
(statearr_33319[(7)] = inst_33298__$1);

return statearr_33319;
})();
if(cljs.core.truth_(inst_33298__$1)){
var statearr_33320_33343 = state_33314__$1;
(statearr_33320_33343[(1)] = (7));

} else {
var statearr_33321_33344 = state_33314__$1;
(statearr_33321_33344[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33315 === (3))){
var inst_33312 = (state_33314[(2)]);
var state_33314__$1 = state_33314;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33314__$1,inst_33312);
} else {
if((state_val_33315 === (12))){
var inst_33309 = (state_33314[(2)]);
var _ = (function (){var statearr_33322 = state_33314;
(statearr_33322[(4)] = cljs.core.rest.call(null,(state_33314[(4)])));

return statearr_33322;
})();
var state_33314__$1 = state_33314;
var statearr_33323_33345 = state_33314__$1;
(statearr_33323_33345[(2)] = inst_33309);

(statearr_33323_33345[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33315 === (2))){
var _ = (function (){var statearr_33324 = state_33314;
(statearr_33324[(4)] = cljs.core.cons.call(null,(5),(state_33314[(4)])));

return statearr_33324;
})();
var inst_33290 = (function (){return (function (p1__33283_SHARP_){
return p1__33283_SHARP_.o;
});
})();
var inst_33291 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33292 = [pred_id];
var inst_33293 = (new cljs.core.PersistentVector(null,1,(5),inst_33291,inst_33292,null));
var inst_33294 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_33293);
var state_33314__$1 = (function (){var statearr_33325 = state_33314;
(statearr_33325[(8)] = inst_33290);

return statearr_33325;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33314__$1,(6),inst_33294);
} else {
if((state_val_33315 === (11))){
var state_33314__$1 = state_33314;
var statearr_33327_33346 = state_33314__$1;
(statearr_33327_33346[(2)] = true);

(statearr_33327_33346[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33315 === (9))){
var inst_33304 = (state_33314[(2)]);
var state_33314__$1 = state_33314;
if(cljs.core.truth_(inst_33304)){
var statearr_33328_33347 = state_33314__$1;
(statearr_33328_33347[(1)] = (10));

} else {
var statearr_33329_33348 = state_33314__$1;
(statearr_33329_33348[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33315 === (5))){
var _ = (function (){var statearr_33330 = state_33314;
(statearr_33330[(4)] = cljs.core.rest.call(null,(state_33314[(4)])));

return statearr_33330;
})();
var state_33314__$1 = state_33314;
var ex33326 = (state_33314__$1[(2)]);
var statearr_33331_33349 = state_33314__$1;
(statearr_33331_33349[(5)] = ex33326);


if((ex33326 instanceof Error)){
var statearr_33332_33350 = state_33314__$1;
(statearr_33332_33350[(1)] = (4));

(statearr_33332_33350[(5)] = null);

} else {
throw ex33326;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33315 === (10))){
var inst_33298 = (state_33314[(7)]);
var inst_33306 = cljs.core.apply.call(null,cljs.core.distinct_QMARK_,inst_33298);
var state_33314__$1 = state_33314;
var statearr_33333_33351 = state_33314__$1;
(statearr_33333_33351[(2)] = inst_33306);

(statearr_33333_33351[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33315 === (8))){
var inst_33298 = (state_33314[(7)]);
var state_33314__$1 = state_33314;
var statearr_33334_33352 = state_33314__$1;
(statearr_33334_33352[(2)] = inst_33298);

(statearr_33334_33352[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16221__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16221__auto____0 = (function (){
var statearr_33335 = [null,null,null,null,null,null,null,null,null];
(statearr_33335[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16221__auto__);

(statearr_33335[(1)] = (1));

return statearr_33335;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16221__auto____1 = (function (state_33314){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_33314);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e33336){var ex__16224__auto__ = e33336;
var statearr_33337_33353 = state_33314;
(statearr_33337_33353[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_33314[(4)]))){
var statearr_33338_33354 = state_33314;
(statearr_33338_33354[(1)] = cljs.core.first.call(null,(state_33314[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33355 = state_33314;
state_33314 = G__33355;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16221__auto__ = function(state_33314){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16221__auto____1.call(this,state_33314);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16221__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16221__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_33339 = f__16346__auto__.call(null);
(statearr_33339[(6)] = c__16345__auto__);

return statearr_33339;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_33436){
var state_val_33437 = (state_33436[(1)]);
if((state_val_33437 === (7))){
var state_33436__$1 = state_33436;
var statearr_33438_33475 = state_33436__$1;
(statearr_33438_33475[(2)] = flakes);

(statearr_33438_33475[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33437 === (20))){
var inst_33393 = (state_33436[(7)]);
var inst_33426 = (state_33436[(2)]);
var inst_33385 = inst_33393;
var inst_33386 = inst_33426;
var state_33436__$1 = (function (){var statearr_33439 = state_33436;
(statearr_33439[(8)] = inst_33386);

(statearr_33439[(9)] = inst_33385);

return statearr_33439;
})();
var statearr_33440_33476 = state_33436__$1;
(statearr_33440_33476[(2)] = null);

(statearr_33440_33476[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33437 === (1))){
var state_33436__$1 = state_33436;
var statearr_33441_33477 = state_33436__$1;
(statearr_33441_33477[(2)] = null);

(statearr_33441_33477[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33437 === (4))){
var inst_33358 = (state_33436[(2)]);
var state_33436__$1 = state_33436;
var statearr_33442_33478 = state_33436__$1;
(statearr_33442_33478[(2)] = inst_33358);

(statearr_33442_33478[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33437 === (15))){
var inst_33392 = (state_33436[(10)]);
var inst_33410 = inst_33392.o;
var state_33436__$1 = state_33436;
var statearr_33443_33479 = state_33436__$1;
(statearr_33443_33479[(2)] = inst_33410);

(statearr_33443_33479[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33437 === (13))){
var inst_33429 = (state_33436[(2)]);
var state_33436__$1 = state_33436;
var statearr_33444_33480 = state_33436__$1;
(statearr_33444_33480[(2)] = inst_33429);

(statearr_33444_33480[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33437 === (6))){
var inst_33365 = cljs.core.filter.call(null,fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_33436__$1 = state_33436;
var statearr_33445_33481 = state_33436__$1;
(statearr_33445_33481[(2)] = inst_33365);

(statearr_33445_33481[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33437 === (17))){
var inst_33407 = (state_33436[(2)]);
var inst_33408 = fluree.db.util.async.throw_err.call(null,inst_33407);
var state_33436__$1 = state_33436;
var statearr_33446_33482 = state_33436__$1;
(statearr_33446_33482[(2)] = inst_33408);

(statearr_33446_33482[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33437 === (3))){
var inst_33434 = (state_33436[(2)]);
var state_33436__$1 = state_33436;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33436__$1,inst_33434);
} else {
if((state_val_33437 === (12))){
var inst_33392 = (state_33436[(10)]);
var inst_33399 = (state_33436[(11)]);
var inst_33397 = inst_33392.p;
var inst_33398 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_33397);
var inst_33399__$1 = fluree.db.query.schema.pred_name__GT_keyword.call(null,inst_33398);
var inst_33400 = inst_33392.op;
var inst_33401 = inst_33400 === false;
var inst_33402 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348),inst_33399__$1);
var state_33436__$1 = (function (){var statearr_33447 = state_33436;
(statearr_33447[(12)] = inst_33401);

(statearr_33447[(11)] = inst_33399__$1);

return statearr_33447;
})();
if(inst_33402){
var statearr_33448_33483 = state_33436__$1;
(statearr_33448_33483[(1)] = (14));

} else {
var statearr_33449_33484 = state_33436__$1;
(statearr_33449_33484[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33437 === (2))){
var _ = (function (){var statearr_33450 = state_33436;
(statearr_33450[(4)] = cljs.core.cons.call(null,(5),(state_33436[(4)])));

return statearr_33450;
})();
var state_33436__$1 = state_33436;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_33451_33485 = state_33436__$1;
(statearr_33451_33485[(1)] = (6));

} else {
var statearr_33452_33486 = state_33436__$1;
(statearr_33452_33486[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33437 === (19))){
var inst_33386 = (state_33436[(8)]);
var inst_33392 = (state_33436[(10)]);
var inst_33399 = (state_33436[(11)]);
var inst_33412 = (state_33436[(13)]);
var inst_33420 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33421 = inst_33392.s;
var inst_33422 = [inst_33421,inst_33399,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_33423 = (new cljs.core.PersistentVector(null,3,(5),inst_33420,inst_33422,null));
var inst_33424 = cljs.core.assoc_in.call(null,inst_33386,inst_33423,inst_33412);
var state_33436__$1 = state_33436;
var statearr_33453_33487 = state_33436__$1;
(statearr_33453_33487[(2)] = inst_33424);

(statearr_33453_33487[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33437 === (11))){
var inst_33386 = (state_33436[(8)]);
var state_33436__$1 = state_33436;
var statearr_33455_33488 = state_33436__$1;
(statearr_33455_33488[(2)] = inst_33386);

(statearr_33455_33488[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33437 === (9))){
var inst_33392 = (state_33436[(10)]);
var inst_33385 = (state_33436[(9)]);
var inst_33391 = cljs.core.seq.call(null,inst_33385);
var inst_33392__$1 = cljs.core.first.call(null,inst_33391);
var inst_33393 = cljs.core.next.call(null,inst_33391);
var inst_33394 = cljs.core.not.call(null,inst_33392__$1);
var state_33436__$1 = (function (){var statearr_33456 = state_33436;
(statearr_33456[(10)] = inst_33392__$1);

(statearr_33456[(7)] = inst_33393);

return statearr_33456;
})();
if(inst_33394){
var statearr_33457_33489 = state_33436__$1;
(statearr_33457_33489[(1)] = (11));

} else {
var statearr_33458_33490 = state_33436__$1;
(statearr_33458_33490[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33437 === (5))){
var _ = (function (){var statearr_33459 = state_33436;
(statearr_33459[(4)] = cljs.core.rest.call(null,(state_33436[(4)])));

return statearr_33459;
})();
var state_33436__$1 = state_33436;
var ex33454 = (state_33436__$1[(2)]);
var statearr_33460_33491 = state_33436__$1;
(statearr_33460_33491[(5)] = ex33454);


if((ex33454 instanceof Error)){
var statearr_33461_33492 = state_33436__$1;
(statearr_33461_33492[(1)] = (4));

(statearr_33461_33492[(5)] = null);

} else {
throw ex33454;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33437 === (14))){
var inst_33392 = (state_33436[(10)]);
var inst_33404 = inst_33392.o;
var inst_33405 = fluree.db.query.schema.convert_type_to_kw.call(null,inst_33404,db);
var state_33436__$1 = state_33436;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33436__$1,(17),inst_33405);
} else {
if((state_val_33437 === (16))){
var inst_33401 = (state_33436[(12)]);
var inst_33412 = (state_33436[(2)]);
var state_33436__$1 = (function (){var statearr_33462 = state_33436;
(statearr_33462[(13)] = inst_33412);

return statearr_33462;
})();
if(cljs.core.truth_(inst_33401)){
var statearr_33463_33493 = state_33436__$1;
(statearr_33463_33493[(1)] = (18));

} else {
var statearr_33464_33494 = state_33436__$1;
(statearr_33464_33494[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33437 === (10))){
var inst_33431 = (state_33436[(2)]);
var _ = (function (){var statearr_33465 = state_33436;
(statearr_33465[(4)] = cljs.core.rest.call(null,(state_33436[(4)])));

return statearr_33465;
})();
var state_33436__$1 = state_33436;
var statearr_33466_33495 = state_33436__$1;
(statearr_33466_33495[(2)] = inst_33431);

(statearr_33466_33495[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33437 === (18))){
var inst_33386 = (state_33436[(8)]);
var inst_33392 = (state_33436[(10)]);
var inst_33399 = (state_33436[(11)]);
var inst_33412 = (state_33436[(13)]);
var inst_33414 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33415 = inst_33392.s;
var inst_33416 = [inst_33415,inst_33399,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_33417 = (new cljs.core.PersistentVector(null,3,(5),inst_33414,inst_33416,null));
var inst_33418 = cljs.core.assoc_in.call(null,inst_33386,inst_33417,inst_33412);
var state_33436__$1 = state_33436;
var statearr_33467_33496 = state_33436__$1;
(statearr_33467_33496[(2)] = inst_33418);

(statearr_33467_33496[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33437 === (8))){
var inst_33368 = (state_33436[(2)]);
var inst_33369 = cljs.core.PersistentHashSet.EMPTY;
var inst_33370 = cljs.core.vals.call(null,tempids);
var inst_33371 = cljs.core.into.call(null,inst_33369,inst_33370);
var inst_33372 = (function (){var pred_flakes = inst_33368;
var is_new_QMARK_ = inst_33371;
return (function (p1__33357_SHARP_,p2__33356_SHARP_){
var f = p2__33356_SHARP_;
return cljs.core.assoc_in.call(null,p1__33357_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s,new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$.call(null,is_new_QMARK_.call(null,f.s)));
});
})();
var inst_33373 = cljs.core.PersistentHashMap.EMPTY;
var inst_33374 = cljs.core.reduce.call(null,inst_33372,inst_33373,inst_33368);
var inst_33382 = cljs.core.seq.call(null,inst_33368);
var inst_33383 = cljs.core.first.call(null,inst_33382);
var inst_33384 = cljs.core.next.call(null,inst_33382);
var inst_33385 = inst_33368;
var inst_33386 = inst_33374;
var state_33436__$1 = (function (){var statearr_33468 = state_33436;
(statearr_33468[(8)] = inst_33386);

(statearr_33468[(14)] = inst_33383);

(statearr_33468[(15)] = inst_33384);

(statearr_33468[(9)] = inst_33385);

return statearr_33468;
})();
var statearr_33469_33497 = state_33436__$1;
(statearr_33469_33497[(2)] = null);

(statearr_33469_33497[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__16221__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__16221__auto____0 = (function (){
var statearr_33470 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33470[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__16221__auto__);

(statearr_33470[(1)] = (1));

return statearr_33470;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__16221__auto____1 = (function (state_33436){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_33436);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e33471){var ex__16224__auto__ = e33471;
var statearr_33472_33498 = state_33436;
(statearr_33472_33498[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_33436[(4)]))){
var statearr_33473_33499 = state_33436;
(statearr_33473_33499[(1)] = cljs.core.first.call(null,(state_33436[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33500 = state_33436;
state_33436 = G__33500;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__16221__auto__ = function(state_33436){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__16221__auto____1.call(this,state_33436);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__16221__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__16221__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_33474 = f__16346__auto__.call(null);
(statearr_33474[(6)] = c__16345__auto__);

return statearr_33474;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__33502 = arguments.length;
switch (G__33502) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.call(null,null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name.call(null,current_type)," to ",cljs.core.name.call(null,new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__33505 = arguments.length;
switch (G__33505) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.call(null,pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_33817){
var state_val_33818 = (state_33817[(1)]);
if((state_val_33818 === (121))){
var inst_33772 = (state_33817[(7)]);
var state_33817__$1 = state_33817;
var statearr_33819_34012 = state_33817__$1;
(statearr_33819_34012[(2)] = inst_33772);

(statearr_33819_34012[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (65))){
var inst_33671 = (state_33817[(2)]);
var state_33817__$1 = state_33817;
if(cljs.core.truth_(inst_33671)){
var statearr_33820_34013 = state_33817__$1;
(statearr_33820_34013[(1)] = (66));

} else {
var statearr_33821_34014 = state_33817__$1;
(statearr_33821_34014[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (70))){
var inst_33676 = (state_33817[(8)]);
var inst_33677 = (state_33817[(9)]);
var inst_33681 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_33682 = inst_33677.call(null,cljs.core.PersistentArrayMap,null,3,inst_33681,null);
var inst_33683 = inst_33677.call(null,cljs.core.PersistentHashSet,null,inst_33682,null);
var inst_33684 = inst_33683.call(null,inst_33676);
var state_33817__$1 = state_33817;
if(cljs.core.truth_(inst_33684)){
var statearr_33822_34015 = state_33817__$1;
(statearr_33822_34015[(1)] = (72));

} else {
var statearr_33823_34016 = state_33817__$1;
(statearr_33823_34016[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (62))){
var inst_33661 = (state_33817[(2)]);
var state_33817__$1 = state_33817;
var statearr_33824_34017 = state_33817__$1;
(statearr_33824_34017[(2)] = inst_33661);

(statearr_33824_34017[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (74))){
var inst_33767 = (state_33817[(2)]);
var state_33817__$1 = state_33817;
var statearr_33825_34018 = state_33817__$1;
(statearr_33825_34018[(2)] = inst_33767);

(statearr_33825_34018[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (110))){
var inst_33794 = (state_33817[(2)]);
var state_33817__$1 = state_33817;
if(cljs.core.truth_(inst_33794)){
var statearr_33826_34019 = state_33817__$1;
(statearr_33826_34019[(1)] = (117));

} else {
var statearr_33827_34020 = state_33817__$1;
(statearr_33827_34020[(1)] = (118));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (7))){
var inst_33812 = (state_33817[(2)]);
var _ = (function (){var statearr_33828 = state_33817;
(statearr_33828[(4)] = cljs.core.rest.call(null,(state_33817[(4)])));

return statearr_33828;
})();
var state_33817__$1 = state_33817;
var statearr_33829_34021 = state_33817__$1;
(statearr_33829_34021[(2)] = inst_33812);

(statearr_33829_34021[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (59))){
var inst_33545 = (state_33817[(10)]);
var inst_33665 = (state_33817[(11)]);
var inst_33664 = (state_33817[(2)]);
var inst_33665__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_33545);
var state_33817__$1 = (function (){var statearr_33830 = state_33817;
(statearr_33830[(12)] = inst_33664);

(statearr_33830[(11)] = inst_33665__$1);

return statearr_33830;
})();
if(cljs.core.truth_(inst_33665__$1)){
var statearr_33831_34022 = state_33817__$1;
(statearr_33831_34022[(1)] = (63));

} else {
var statearr_33832_34023 = state_33817__$1;
(statearr_33832_34023[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (86))){
var inst_33707 = (state_33817[(2)]);
var state_33817__$1 = state_33817;
var statearr_33833_34024 = state_33817__$1;
(statearr_33833_34024[(2)] = inst_33707);

(statearr_33833_34024[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (20))){
var inst_33545 = (state_33817[(10)]);
var inst_33571 = (state_33817[(13)]);
var inst_33571__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_33545);
var state_33817__$1 = (function (){var statearr_33834 = state_33817;
(statearr_33834[(13)] = inst_33571__$1);

return statearr_33834;
})();
if(cljs.core.truth_(inst_33571__$1)){
var statearr_33835_34025 = state_33817__$1;
(statearr_33835_34025[(1)] = (23));

} else {
var statearr_33836_34026 = state_33817__$1;
(statearr_33836_34026[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (72))){
var inst_33676 = (state_33817[(8)]);
var inst_33677 = (state_33817[(9)]);
var inst_33686 = fluree.db.query.schema.type_error.call(null,inst_33676,inst_33677,throw_QMARK_);
var state_33817__$1 = state_33817;
var statearr_33837_34027 = state_33817__$1;
(statearr_33837_34027[(2)] = inst_33686);

(statearr_33837_34027[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (58))){
var inst_33626 = (state_33817[(14)]);
var state_33817__$1 = state_33817;
var statearr_33838_34028 = state_33817__$1;
(statearr_33838_34028[(2)] = inst_33626);

(statearr_33838_34028[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (60))){
var inst_33533 = (state_33817[(15)]);
var inst_33544 = (state_33817[(16)]);
var inst_33652 = fluree.db.dbproto._p_prop.call(null,inst_33533,new cljs.core.Keyword(null,"name","name",1843675177),inst_33544);
var inst_33653 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_33652)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_33654 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_33655 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_33656 = cljs.core.PersistentHashMap.fromArrays(inst_33654,inst_33655);
var inst_33657 = cljs.core.ex_info.call(null,inst_33653,inst_33656);
var inst_33658 = (function(){throw inst_33657})();
var state_33817__$1 = state_33817;
var statearr_33839_34029 = state_33817__$1;
(statearr_33839_34029[(2)] = inst_33658);

(statearr_33839_34029[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (27))){
var inst_33574 = (state_33817[(17)]);
var state_33817__$1 = state_33817;
var statearr_33840_34030 = state_33817__$1;
(statearr_33840_34030[(2)] = inst_33574);

(statearr_33840_34030[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (1))){
var state_33817__$1 = state_33817;
var statearr_33841_34031 = state_33817__$1;
(statearr_33841_34031[(2)] = null);

(statearr_33841_34031[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (69))){
var inst_33664 = (state_33817[(12)]);
var state_33817__$1 = state_33817;
var statearr_33842_34032 = state_33817__$1;
(statearr_33842_34032[(2)] = inst_33664);

(statearr_33842_34032[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (101))){
var inst_33676 = (state_33817[(8)]);
var inst_33677 = (state_33817[(9)]);
var inst_33745 = fluree.db.query.schema.type_error.call(null,inst_33676,inst_33677,throw_QMARK_);
var state_33817__$1 = state_33817;
var statearr_33843_34033 = state_33817__$1;
(statearr_33843_34033[(2)] = inst_33745);

(statearr_33843_34033[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (24))){
var inst_33571 = (state_33817[(13)]);
var state_33817__$1 = state_33817;
var statearr_33844_34034 = state_33817__$1;
(statearr_33844_34034[(2)] = inst_33571);

(statearr_33844_34034[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (102))){
var inst_33747 = (state_33817[(2)]);
var state_33817__$1 = state_33817;
var statearr_33845_34035 = state_33817__$1;
(statearr_33845_34035[(2)] = inst_33747);

(statearr_33845_34035[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (55))){
var inst_33643 = (state_33817[(2)]);
var state_33817__$1 = state_33817;
var statearr_33846_34036 = state_33817__$1;
(statearr_33846_34036[(2)] = inst_33643);

(statearr_33846_34036[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (85))){
var inst_33676 = (state_33817[(8)]);
var inst_33677 = (state_33817[(9)]);
var inst_33705 = fluree.db.query.schema.type_error.call(null,inst_33676,inst_33677,throw_QMARK_);
var state_33817__$1 = state_33817;
var statearr_33847_34037 = state_33817__$1;
(statearr_33847_34037[(2)] = inst_33705);

(statearr_33847_34037[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (39))){
var inst_33608 = (state_33817[(18)]);
var state_33817__$1 = state_33817;
var statearr_33848_34038 = state_33817__$1;
(statearr_33848_34038[(2)] = inst_33608);

(statearr_33848_34038[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (88))){
var inst_33664 = (state_33817[(12)]);
var state_33817__$1 = state_33817;
var statearr_33849_34039 = state_33817__$1;
(statearr_33849_34039[(2)] = inst_33664);

(statearr_33849_34039[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (46))){
var inst_33545 = (state_33817[(10)]);
var inst_33627 = (state_33817[(19)]);
var inst_33626 = (state_33817[(2)]);
var inst_33627__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_33545);
var state_33817__$1 = (function (){var statearr_33850 = state_33817;
(statearr_33850[(19)] = inst_33627__$1);

(statearr_33850[(14)] = inst_33626);

return statearr_33850;
})();
if(cljs.core.truth_(inst_33627__$1)){
var statearr_33851_34040 = state_33817__$1;
(statearr_33851_34040[(1)] = (47));

} else {
var statearr_33852_34041 = state_33817__$1;
(statearr_33852_34041[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (4))){
var inst_33506 = (state_33817[(2)]);
var state_33817__$1 = state_33817;
var statearr_33853_34042 = state_33817__$1;
(statearr_33853_34042[(2)] = inst_33506);

(statearr_33853_34042[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (77))){
var inst_33765 = (state_33817[(2)]);
var state_33817__$1 = state_33817;
var statearr_33854_34043 = state_33817__$1;
(statearr_33854_34043[(2)] = inst_33765);

(statearr_33854_34043[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (106))){
var inst_33757 = (state_33817[(2)]);
var state_33817__$1 = state_33817;
var statearr_33855_34044 = state_33817__$1;
(statearr_33855_34044[(2)] = inst_33757);

(statearr_33855_34044[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (119))){
var inst_33543 = (state_33817[(20)]);
var inst_33807 = (state_33817[(2)]);
var inst_33532 = inst_33543;
var inst_33533 = inst_33807;
var state_33817__$1 = (function (){var statearr_33856 = state_33817;
(statearr_33856[(15)] = inst_33533);

(statearr_33856[(21)] = inst_33532);

return statearr_33856;
})();
var statearr_33857_34045 = state_33817__$1;
(statearr_33857_34045[(2)] = null);

(statearr_33857_34045[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (95))){
var inst_33676 = (state_33817[(8)]);
var inst_33677 = (state_33817[(9)]);
var inst_33729 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_33730 = inst_33677.call(null,cljs.core.PersistentArrayMap,null,5,inst_33729,null);
var inst_33731 = inst_33677.call(null,cljs.core.PersistentHashSet,null,inst_33730,null);
var inst_33732 = inst_33731.call(null,inst_33676);
var state_33817__$1 = state_33817;
if(cljs.core.truth_(inst_33732)){
var statearr_33858_34046 = state_33817__$1;
(statearr_33858_34046[(1)] = (96));

} else {
var statearr_33859_34047 = state_33817__$1;
(statearr_33859_34047[(1)] = (97));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (54))){
var inst_33634 = (state_33817[(22)]);
var state_33817__$1 = state_33817;
var statearr_33860_34048 = state_33817__$1;
(statearr_33860_34048[(2)] = inst_33634);

(statearr_33860_34048[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (92))){
var inst_33664 = (state_33817[(12)]);
var state_33817__$1 = state_33817;
var statearr_33861_34049 = state_33817__$1;
(statearr_33861_34049[(2)] = inst_33664);

(statearr_33861_34049[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (104))){
var inst_33664 = (state_33817[(12)]);
var state_33817__$1 = state_33817;
var statearr_33862_34050 = state_33817__$1;
(statearr_33862_34050[(2)] = inst_33664);

(statearr_33862_34050[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (15))){
var inst_33553 = (state_33817[(23)]);
var state_33817__$1 = state_33817;
var statearr_33863_34051 = state_33817__$1;
(statearr_33863_34051[(2)] = inst_33553);

(statearr_33863_34051[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (48))){
var inst_33627 = (state_33817[(19)]);
var state_33817__$1 = state_33817;
var statearr_33864_34052 = state_33817__$1;
(statearr_33864_34052[(2)] = inst_33627);

(statearr_33864_34052[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (50))){
var inst_33545 = (state_33817[(10)]);
var inst_33634 = (state_33817[(22)]);
var inst_33632 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_33545);
var inst_33633 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_33632);
var inst_33634__$1 = inst_33633 === true;
var state_33817__$1 = (function (){var statearr_33865 = state_33817;
(statearr_33865[(22)] = inst_33634__$1);

return statearr_33865;
})();
if(cljs.core.truth_(inst_33634__$1)){
var statearr_33866_34053 = state_33817__$1;
(statearr_33866_34053[(1)] = (53));

} else {
var statearr_33867_34054 = state_33817__$1;
(statearr_33867_34054[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (116))){
var inst_33788 = (state_33817[(2)]);
var state_33817__$1 = state_33817;
var statearr_33868_34055 = state_33817__$1;
(statearr_33868_34055[(2)] = inst_33788);

(statearr_33868_34055[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (75))){
var inst_33677 = (state_33817[(9)]);
var state_33817__$1 = state_33817;
var G__33869_34056 = inst_33677;
var G__33869_34057__$1 = (((G__33869_34056 instanceof cljs.core.Keyword))?G__33869_34056.fqn:null);
switch (G__33869_34057__$1) {
case "long":
var statearr_33870_34059 = state_33817__$1;
(statearr_33870_34059[(1)] = (79));


break;
case "bigint":
var statearr_33871_34060 = state_33817__$1;
(statearr_33871_34060[(1)] = (83));


break;
case "double":
var statearr_33872_34061 = state_33817__$1;
(statearr_33872_34061[(1)] = (87));


break;
case "float":
var statearr_33873_34062 = state_33817__$1;
(statearr_33873_34062[(1)] = (91));


break;
case "bigdec":
var statearr_33874_34063 = state_33817__$1;
(statearr_33874_34063[(1)] = (95));


break;
case "string":
var statearr_33875_34064 = state_33817__$1;
(statearr_33875_34064[(1)] = (99));


break;
case "instant":
var statearr_33876_34065 = state_33817__$1;
(statearr_33876_34065[(1)] = (103));


break;
default:
var statearr_33877_34066 = state_33817__$1;
(statearr_33877_34066[(1)] = (107));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (99))){
var inst_33676 = (state_33817[(8)]);
var inst_33677 = (state_33817[(9)]);
var inst_33739 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_33740 = inst_33677.call(null,cljs.core.PersistentArrayMap,null,5,inst_33739,null);
var inst_33741 = inst_33677.call(null,cljs.core.PersistentHashSet,null,inst_33740,null);
var inst_33742 = inst_33741.call(null,inst_33676);
var state_33817__$1 = state_33817;
if(cljs.core.truth_(inst_33742)){
var statearr_33878_34067 = state_33817__$1;
(statearr_33878_34067[(1)] = (100));

} else {
var statearr_33879_34068 = state_33817__$1;
(statearr_33879_34068[(1)] = (101));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (21))){
var inst_33569 = (state_33817[(24)]);
var state_33817__$1 = state_33817;
var statearr_33880_34069 = state_33817__$1;
(statearr_33880_34069[(2)] = inst_33569);

(statearr_33880_34069[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (31))){
var inst_33585 = (state_33817[(2)]);
var state_33817__$1 = state_33817;
var statearr_33881_34070 = state_33817__$1;
(statearr_33881_34070[(2)] = inst_33585);

(statearr_33881_34070[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (113))){
var inst_33791 = (state_33817[(2)]);
var state_33817__$1 = state_33817;
var statearr_33882_34071 = state_33817__$1;
(statearr_33882_34071[(2)] = inst_33791);

(statearr_33882_34071[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (32))){
var state_33817__$1 = state_33817;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_33883_34072 = state_33817__$1;
(statearr_33883_34072[(1)] = (35));

} else {
var statearr_33884_34073 = state_33817__$1;
(statearr_33884_34073[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (40))){
var inst_33621 = (state_33817[(2)]);
var state_33817__$1 = state_33817;
if(cljs.core.truth_(inst_33621)){
var statearr_33885_34074 = state_33817__$1;
(statearr_33885_34074[(1)] = (44));

} else {
var statearr_33886_34075 = state_33817__$1;
(statearr_33886_34075[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (91))){
var inst_33676 = (state_33817[(8)]);
var inst_33677 = (state_33817[(9)]);
var inst_33719 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_33720 = inst_33677.call(null,cljs.core.PersistentArrayMap,null,3,inst_33719,null);
var inst_33721 = inst_33677.call(null,cljs.core.PersistentHashSet,null,inst_33720,null);
var inst_33722 = inst_33721.call(null,inst_33676);
var state_33817__$1 = state_33817;
if(cljs.core.truth_(inst_33722)){
var statearr_33887_34076 = state_33817__$1;
(statearr_33887_34076[(1)] = (92));

} else {
var statearr_33888_34077 = state_33817__$1;
(statearr_33888_34077[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (117))){
var state_33817__$1 = state_33817;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_33889_34078 = state_33817__$1;
(statearr_33889_34078[(1)] = (120));

} else {
var statearr_33890_34079 = state_33817__$1;
(statearr_33890_34079[(1)] = (121));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (108))){
var inst_33545 = (state_33817[(10)]);
var inst_33776 = (state_33817[(25)]);
var inst_33776__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_33545);
var state_33817__$1 = (function (){var statearr_33891 = state_33817;
(statearr_33891[(25)] = inst_33776__$1);

return statearr_33891;
})();
if(cljs.core.truth_(inst_33776__$1)){
var statearr_33892_34080 = state_33817__$1;
(statearr_33892_34080[(1)] = (111));

} else {
var statearr_33893_34081 = state_33817__$1;
(statearr_33893_34081[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (56))){
var inst_33638 = (state_33817[(2)]);
var inst_33639 = fluree.db.util.async.throw_err.call(null,inst_33638);
var inst_33640 = cljs.core.not.call(null,inst_33639);
var state_33817__$1 = state_33817;
var statearr_33894_34082 = state_33817__$1;
(statearr_33894_34082[(2)] = inst_33640);

(statearr_33894_34082[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (33))){
var inst_33568 = (state_33817[(26)]);
var state_33817__$1 = state_33817;
var statearr_33895_34083 = state_33817__$1;
(statearr_33895_34083[(2)] = inst_33568);

(statearr_33895_34083[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (13))){
var inst_33563 = (state_33817[(2)]);
var state_33817__$1 = state_33817;
if(cljs.core.truth_(inst_33563)){
var statearr_33896_34084 = state_33817__$1;
(statearr_33896_34084[(1)] = (17));

} else {
var statearr_33897_34085 = state_33817__$1;
(statearr_33897_34085[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (22))){
var inst_33594 = (state_33817[(2)]);
var state_33817__$1 = state_33817;
if(cljs.core.truth_(inst_33594)){
var statearr_33898_34086 = state_33817__$1;
(statearr_33898_34086[(1)] = (32));

} else {
var statearr_33899_34087 = state_33817__$1;
(statearr_33899_34087[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (90))){
var inst_33717 = (state_33817[(2)]);
var state_33817__$1 = state_33817;
var statearr_33900_34088 = state_33817__$1;
(statearr_33900_34088[(2)] = inst_33717);

(statearr_33900_34088[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (109))){
var inst_33774 = (state_33817[(27)]);
var state_33817__$1 = state_33817;
var statearr_33901_34089 = state_33817__$1;
(statearr_33901_34089[(2)] = inst_33774);

(statearr_33901_34089[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (36))){
var inst_33568 = (state_33817[(26)]);
var state_33817__$1 = state_33817;
var statearr_33902_34090 = state_33817__$1;
(statearr_33902_34090[(2)] = inst_33568);

(statearr_33902_34090[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (41))){
var inst_33545 = (state_33817[(10)]);
var inst_33613 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_33545);
var inst_33614 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_33613);
var inst_33615 = inst_33614 === true;
var state_33817__$1 = state_33817;
var statearr_33903_34091 = state_33817__$1;
(statearr_33903_34091[(2)] = inst_33615);

(statearr_33903_34091[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (118))){
var inst_33772 = (state_33817[(7)]);
var state_33817__$1 = state_33817;
var statearr_33904_34092 = state_33817__$1;
(statearr_33904_34092[(2)] = inst_33772);

(statearr_33904_34092[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (89))){
var inst_33676 = (state_33817[(8)]);
var inst_33677 = (state_33817[(9)]);
var inst_33715 = fluree.db.query.schema.type_error.call(null,inst_33676,inst_33677,throw_QMARK_);
var state_33817__$1 = state_33817;
var statearr_33905_34093 = state_33817__$1;
(statearr_33905_34093[(2)] = inst_33715);

(statearr_33905_34093[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (100))){
var inst_33664 = (state_33817[(12)]);
var state_33817__$1 = state_33817;
var statearr_33906_34094 = state_33817__$1;
(statearr_33906_34094[(2)] = inst_33664);

(statearr_33906_34094[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (122))){
var inst_33804 = (state_33817[(2)]);
var state_33817__$1 = state_33817;
var statearr_33907_34095 = state_33817__$1;
(statearr_33907_34095[(2)] = inst_33804);

(statearr_33907_34095[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (43))){
var inst_33618 = (state_33817[(2)]);
var state_33817__$1 = state_33817;
var statearr_33908_34096 = state_33817__$1;
(statearr_33908_34096[(2)] = inst_33618);

(statearr_33908_34096[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (61))){
var inst_33626 = (state_33817[(14)]);
var state_33817__$1 = state_33817;
var statearr_33909_34097 = state_33817__$1;
(statearr_33909_34097[(2)] = inst_33626);

(statearr_33909_34097[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (29))){
var inst_33545 = (state_33817[(10)]);
var inst_33580 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_33545);
var inst_33581 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_33580);
var inst_33582 = inst_33581 === true;
var state_33817__$1 = state_33817;
var statearr_33910_34098 = state_33817__$1;
(statearr_33910_34098[(2)] = inst_33582);

(statearr_33910_34098[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (44))){
var inst_33607 = (state_33817[(28)]);
var inst_33623 = fluree.db.query.schema.type_error.call(null,inst_33607,"a component","a non-component",throw_QMARK_);
var state_33817__$1 = state_33817;
var statearr_33911_34099 = state_33817__$1;
(statearr_33911_34099[(2)] = inst_33623);

(statearr_33911_34099[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (93))){
var inst_33676 = (state_33817[(8)]);
var inst_33677 = (state_33817[(9)]);
var inst_33725 = fluree.db.query.schema.type_error.call(null,inst_33676,inst_33677,throw_QMARK_);
var state_33817__$1 = state_33817;
var statearr_33912_34100 = state_33817__$1;
(statearr_33912_34100[(2)] = inst_33725);

(statearr_33912_34100[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (6))){
var inst_33544 = (state_33817[(16)]);
var inst_33532 = (state_33817[(21)]);
var inst_33541 = cljs.core.seq.call(null,inst_33532);
var inst_33542 = cljs.core.first.call(null,inst_33541);
var inst_33543 = cljs.core.next.call(null,inst_33541);
var inst_33544__$1 = cljs.core.nth.call(null,inst_33542,(0),null);
var inst_33545 = cljs.core.nth.call(null,inst_33542,(1),null);
var inst_33546 = cljs.core.not.call(null,inst_33544__$1);
var state_33817__$1 = (function (){var statearr_33913 = state_33817;
(statearr_33913[(10)] = inst_33545);

(statearr_33913[(20)] = inst_33543);

(statearr_33913[(16)] = inst_33544__$1);

return statearr_33913;
})();
if(inst_33546){
var statearr_33914_34101 = state_33817__$1;
(statearr_33914_34101[(1)] = (8));

} else {
var statearr_33915_34102 = state_33817__$1;
(statearr_33915_34102[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (111))){
var inst_33545 = (state_33817[(10)]);
var inst_33780 = (state_33817[(29)]);
var inst_33778 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_33545);
var inst_33779 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_33778);
var inst_33780__$1 = inst_33779 === true;
var state_33817__$1 = (function (){var statearr_33916 = state_33817;
(statearr_33916[(29)] = inst_33780__$1);

return statearr_33916;
})();
if(cljs.core.truth_(inst_33780__$1)){
var statearr_33917_34103 = state_33817__$1;
(statearr_33917_34103[(1)] = (114));

} else {
var statearr_33918_34104 = state_33817__$1;
(statearr_33918_34104[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (28))){
var inst_33588 = (state_33817[(2)]);
var state_33817__$1 = state_33817;
var statearr_33919_34105 = state_33817__$1;
(statearr_33919_34105[(2)] = inst_33588);

(statearr_33919_34105[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (64))){
var inst_33665 = (state_33817[(11)]);
var state_33817__$1 = state_33817;
var statearr_33920_34106 = state_33817__$1;
(statearr_33920_34106[(2)] = inst_33665);

(statearr_33920_34106[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (103))){
var inst_33676 = (state_33817[(8)]);
var inst_33677 = (state_33817[(9)]);
var inst_33749 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_33750 = inst_33677.call(null,cljs.core.PersistentArrayMap,null,2,inst_33749,null);
var inst_33751 = inst_33677.call(null,cljs.core.PersistentHashSet,null,inst_33750,null);
var inst_33752 = inst_33751.call(null,inst_33676);
var state_33817__$1 = state_33817;
if(cljs.core.truth_(inst_33752)){
var statearr_33921_34107 = state_33817__$1;
(statearr_33921_34107[(1)] = (104));

} else {
var statearr_33922_34108 = state_33817__$1;
(statearr_33922_34108[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (51))){
var inst_33630 = (state_33817[(30)]);
var state_33817__$1 = state_33817;
var statearr_33923_34109 = state_33817__$1;
(statearr_33923_34109[(2)] = inst_33630);

(statearr_33923_34109[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (25))){
var inst_33591 = (state_33817[(2)]);
var state_33817__$1 = state_33817;
var statearr_33924_34110 = state_33817__$1;
(statearr_33924_34110[(2)] = inst_33591);

(statearr_33924_34110[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (34))){
var inst_33545 = (state_33817[(10)]);
var inst_33608 = (state_33817[(18)]);
var inst_33607 = (state_33817[(2)]);
var inst_33608__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_33545);
var state_33817__$1 = (function (){var statearr_33925 = state_33817;
(statearr_33925[(18)] = inst_33608__$1);

(statearr_33925[(28)] = inst_33607);

return statearr_33925;
})();
if(cljs.core.truth_(inst_33608__$1)){
var statearr_33926_34111 = state_33817__$1;
(statearr_33926_34111[(1)] = (38));

} else {
var statearr_33927_34112 = state_33817__$1;
(statearr_33927_34112[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (17))){
var inst_33533 = (state_33817[(15)]);
var inst_33565 = fluree.db.query.schema.type_error.call(null,inst_33533,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_33817__$1 = state_33817;
var statearr_33928_34113 = state_33817__$1;
(statearr_33928_34113[(2)] = inst_33565);

(statearr_33928_34113[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (3))){
var inst_33815 = (state_33817[(2)]);
var state_33817__$1 = state_33817;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33817__$1,inst_33815);
} else {
if((state_val_33818 === (12))){
var inst_33549 = (state_33817[(31)]);
var state_33817__$1 = state_33817;
var statearr_33929_34114 = state_33817__$1;
(statearr_33929_34114[(2)] = inst_33549);

(statearr_33929_34114[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (2))){
var _ = (function (){var statearr_33930 = state_33817;
(statearr_33930[(4)] = cljs.core.cons.call(null,(5),(state_33817[(4)])));

return statearr_33930;
})();
var inst_33525 = pred_changes;
var inst_33526 = cljs.core.seq.call(null,inst_33525);
var inst_33527 = cljs.core.first.call(null,inst_33526);
var inst_33528 = cljs.core.next.call(null,inst_33526);
var inst_33529 = cljs.core.nth.call(null,inst_33527,(0),null);
var inst_33530 = cljs.core.nth.call(null,inst_33527,(1),null);
var inst_33531 = db;
var inst_33532 = inst_33525;
var inst_33533 = inst_33531;
var state_33817__$1 = (function (){var statearr_33931 = state_33817;
(statearr_33931[(15)] = inst_33533);

(statearr_33931[(32)] = inst_33528);

(statearr_33931[(33)] = inst_33529);

(statearr_33931[(21)] = inst_33532);

(statearr_33931[(34)] = inst_33530);

return statearr_33931;
})();
var statearr_33932_34115 = state_33817__$1;
(statearr_33932_34115[(2)] = null);

(statearr_33932_34115[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (66))){
var inst_33545 = (state_33817[(10)]);
var inst_33676 = (state_33817[(8)]);
var inst_33677 = (state_33817[(9)]);
var inst_33674 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_33545);
var inst_33675 = cljs.core.__destructure_map.call(null,inst_33674);
var inst_33676__$1 = cljs.core.get.call(null,inst_33675,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_33677__$1 = cljs.core.get.call(null,inst_33675,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_33678 = cljs.core._EQ_.call(null,inst_33677__$1,inst_33676__$1);
var state_33817__$1 = (function (){var statearr_33933 = state_33817;
(statearr_33933[(8)] = inst_33676__$1);

(statearr_33933[(9)] = inst_33677__$1);

return statearr_33933;
})();
if(inst_33678){
var statearr_33934_34116 = state_33817__$1;
(statearr_33934_34116[(1)] = (69));

} else {
var statearr_33935_34117 = state_33817__$1;
(statearr_33935_34117[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (107))){
var inst_33676 = (state_33817[(8)]);
var inst_33677 = (state_33817[(9)]);
var inst_33759 = fluree.db.query.schema.type_error.call(null,inst_33676,inst_33677,throw_QMARK_);
var state_33817__$1 = state_33817;
var statearr_33936_34118 = state_33817__$1;
(statearr_33936_34118[(2)] = inst_33759);

(statearr_33936_34118[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (23))){
var inst_33545 = (state_33817[(10)]);
var inst_33574 = (state_33817[(17)]);
var inst_33573 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_33545);
var inst_33574__$1 = inst_33573 === true;
var state_33817__$1 = (function (){var statearr_33937 = state_33817;
(statearr_33937[(17)] = inst_33574__$1);

return statearr_33937;
})();
if(cljs.core.truth_(inst_33574__$1)){
var statearr_33938_34119 = state_33817__$1;
(statearr_33938_34119[(1)] = (26));

} else {
var statearr_33939_34120 = state_33817__$1;
(statearr_33939_34120[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (47))){
var inst_33545 = (state_33817[(10)]);
var inst_33630 = (state_33817[(30)]);
var inst_33629 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_33545);
var inst_33630__$1 = cljs.core.not.call(null,inst_33629);
var state_33817__$1 = (function (){var statearr_33940 = state_33817;
(statearr_33940[(30)] = inst_33630__$1);

return statearr_33940;
})();
if(inst_33630__$1){
var statearr_33941_34121 = state_33817__$1;
(statearr_33941_34121[(1)] = (50));

} else {
var statearr_33942_34122 = state_33817__$1;
(statearr_33942_34122[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (35))){
var inst_33597 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_33598 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_33599 = cljs.core.PersistentHashMap.fromArrays(inst_33597,inst_33598);
var inst_33600 = cljs.core.ex_info.call(null,"A boolean _predicate cannot be unique.",inst_33599);
var inst_33601 = (function(){throw inst_33600})();
var state_33817__$1 = state_33817;
var statearr_33943_34123 = state_33817__$1;
(statearr_33943_34123[(2)] = inst_33601);

(statearr_33943_34123[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (82))){
var inst_33697 = (state_33817[(2)]);
var state_33817__$1 = state_33817;
var statearr_33944_34124 = state_33817__$1;
(statearr_33944_34124[(2)] = inst_33697);

(statearr_33944_34124[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (76))){
var state_33817__$1 = state_33817;
var statearr_33945_34125 = state_33817__$1;
(statearr_33945_34125[(2)] = null);

(statearr_33945_34125[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (97))){
var inst_33676 = (state_33817[(8)]);
var inst_33677 = (state_33817[(9)]);
var inst_33735 = fluree.db.query.schema.type_error.call(null,inst_33676,inst_33677,throw_QMARK_);
var state_33817__$1 = state_33817;
var statearr_33946_34126 = state_33817__$1;
(statearr_33946_34126[(2)] = inst_33735);

(statearr_33946_34126[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (19))){
var inst_33545 = (state_33817[(10)]);
var inst_33569 = (state_33817[(24)]);
var inst_33568 = (state_33817[(2)]);
var inst_33569__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_33545);
var state_33817__$1 = (function (){var statearr_33947 = state_33817;
(statearr_33947[(24)] = inst_33569__$1);

(statearr_33947[(26)] = inst_33568);

return statearr_33947;
})();
if(cljs.core.truth_(inst_33569__$1)){
var statearr_33948_34127 = state_33817__$1;
(statearr_33948_34127[(1)] = (20));

} else {
var statearr_33949_34128 = state_33817__$1;
(statearr_33949_34128[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (57))){
var state_33817__$1 = state_33817;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_33950_34129 = state_33817__$1;
(statearr_33950_34129[(1)] = (60));

} else {
var statearr_33951_34130 = state_33817__$1;
(statearr_33951_34130[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (68))){
var inst_33545 = (state_33817[(10)]);
var inst_33774 = (state_33817[(27)]);
var inst_33772 = (state_33817[(2)]);
var inst_33773 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_33545);
var inst_33774__$1 = inst_33773 === true;
var state_33817__$1 = (function (){var statearr_33952 = state_33817;
(statearr_33952[(7)] = inst_33772);

(statearr_33952[(27)] = inst_33774__$1);

return statearr_33952;
})();
if(cljs.core.truth_(inst_33774__$1)){
var statearr_33953_34131 = state_33817__$1;
(statearr_33953_34131[(1)] = (108));

} else {
var statearr_33954_34132 = state_33817__$1;
(statearr_33954_34132[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (11))){
var inst_33545 = (state_33817[(10)]);
var inst_33553 = (state_33817[(23)]);
var inst_33551 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_33545);
var inst_33552 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_33551);
var inst_33553__$1 = inst_33552 === false;
var state_33817__$1 = (function (){var statearr_33955 = state_33817;
(statearr_33955[(23)] = inst_33553__$1);

return statearr_33955;
})();
if(cljs.core.truth_(inst_33553__$1)){
var statearr_33956_34133 = state_33817__$1;
(statearr_33956_34133[(1)] = (14));

} else {
var statearr_33957_34134 = state_33817__$1;
(statearr_33957_34134[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (115))){
var inst_33780 = (state_33817[(29)]);
var state_33817__$1 = state_33817;
var statearr_33959_34135 = state_33817__$1;
(statearr_33959_34135[(2)] = inst_33780);

(statearr_33959_34135[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (9))){
var inst_33545 = (state_33817[(10)]);
var inst_33549 = (state_33817[(31)]);
var inst_33549__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_33545);
var state_33817__$1 = (function (){var statearr_33960 = state_33817;
(statearr_33960[(31)] = inst_33549__$1);

return statearr_33960;
})();
if(cljs.core.truth_(inst_33549__$1)){
var statearr_33961_34136 = state_33817__$1;
(statearr_33961_34136[(1)] = (11));

} else {
var statearr_33962_34137 = state_33817__$1;
(statearr_33962_34137[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (5))){
var _ = (function (){var statearr_33963 = state_33817;
(statearr_33963[(4)] = cljs.core.rest.call(null,(state_33817[(4)])));

return statearr_33963;
})();
var state_33817__$1 = state_33817;
var ex33958 = (state_33817__$1[(2)]);
var statearr_33964_34138 = state_33817__$1;
(statearr_33964_34138[(5)] = ex33958);


if((ex33958 instanceof Error)){
var statearr_33965_34139 = state_33817__$1;
(statearr_33965_34139[(1)] = (4));

(statearr_33965_34139[(5)] = null);

} else {
throw ex33958;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (112))){
var inst_33776 = (state_33817[(25)]);
var state_33817__$1 = state_33817;
var statearr_33966_34140 = state_33817__$1;
(statearr_33966_34140[(2)] = inst_33776);

(statearr_33966_34140[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (83))){
var inst_33676 = (state_33817[(8)]);
var inst_33677 = (state_33817[(9)]);
var inst_33699 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_33700 = inst_33677.call(null,cljs.core.PersistentArrayMap,null,3,inst_33699,null);
var inst_33701 = inst_33677.call(null,cljs.core.PersistentHashSet,null,inst_33700,null);
var inst_33702 = inst_33701.call(null,inst_33676);
var state_33817__$1 = state_33817;
if(cljs.core.truth_(inst_33702)){
var statearr_33967_34141 = state_33817__$1;
(statearr_33967_34141[(1)] = (84));

} else {
var statearr_33968_34142 = state_33817__$1;
(statearr_33968_34142[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (14))){
var inst_33545 = (state_33817[(10)]);
var inst_33555 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_33545);
var inst_33556 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_33555);
var inst_33557 = inst_33556 === true;
var state_33817__$1 = state_33817;
var statearr_33969_34143 = state_33817__$1;
(statearr_33969_34143[(2)] = inst_33557);

(statearr_33969_34143[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (45))){
var inst_33607 = (state_33817[(28)]);
var state_33817__$1 = state_33817;
var statearr_33970_34144 = state_33817__$1;
(statearr_33970_34144[(2)] = inst_33607);

(statearr_33970_34144[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (53))){
var inst_33533 = (state_33817[(15)]);
var inst_33544 = (state_33817[(16)]);
var inst_33636 = fluree.db.query.schema.pred_objects_unique_QMARK_.call(null,inst_33533,inst_33544);
var state_33817__$1 = state_33817;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33817__$1,(56),inst_33636);
} else {
if((state_val_33818 === (78))){
var inst_33762 = (state_33817[(2)]);
var state_33817__$1 = state_33817;
var statearr_33971_34145 = state_33817__$1;
(statearr_33971_34145[(2)] = inst_33762);

(statearr_33971_34145[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (26))){
var inst_33545 = (state_33817[(10)]);
var inst_33578 = (state_33817[(35)]);
var inst_33576 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_33545);
var inst_33577 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_33576);
var inst_33578__$1 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_33577);
var state_33817__$1 = (function (){var statearr_33972 = state_33817;
(statearr_33972[(35)] = inst_33578__$1);

return statearr_33972;
})();
if(inst_33578__$1){
var statearr_33973_34146 = state_33817__$1;
(statearr_33973_34146[(1)] = (29));

} else {
var statearr_33974_34147 = state_33817__$1;
(statearr_33974_34147[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (16))){
var inst_33560 = (state_33817[(2)]);
var state_33817__$1 = state_33817;
var statearr_33975_34148 = state_33817__$1;
(statearr_33975_34148[(2)] = inst_33560);

(statearr_33975_34148[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (81))){
var inst_33676 = (state_33817[(8)]);
var inst_33677 = (state_33817[(9)]);
var inst_33695 = fluree.db.query.schema.type_error.call(null,inst_33676,inst_33677,throw_QMARK_);
var state_33817__$1 = state_33817;
var statearr_33976_34149 = state_33817__$1;
(statearr_33976_34149[(2)] = inst_33695);

(statearr_33976_34149[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (120))){
var inst_33797 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_33798 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_33799 = cljs.core.PersistentHashMap.fromArrays(inst_33797,inst_33798);
var inst_33800 = cljs.core.ex_info.call(null,"A component _predicate must be of type \"ref.\"",inst_33799);
var inst_33801 = (function(){throw inst_33800})();
var state_33817__$1 = state_33817;
var statearr_33977_34150 = state_33817__$1;
(statearr_33977_34150[(2)] = inst_33801);

(statearr_33977_34150[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (79))){
var inst_33676 = (state_33817[(8)]);
var inst_33677 = (state_33817[(9)]);
var inst_33689 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_33690 = inst_33677.call(null,cljs.core.PersistentArrayMap,null,2,inst_33689,null);
var inst_33691 = inst_33677.call(null,cljs.core.PersistentHashSet,null,inst_33690,null);
var inst_33692 = inst_33691.call(null,inst_33676);
var state_33817__$1 = state_33817;
if(cljs.core.truth_(inst_33692)){
var statearr_33978_34151 = state_33817__$1;
(statearr_33978_34151[(1)] = (80));

} else {
var statearr_33979_34152 = state_33817__$1;
(statearr_33979_34152[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (38))){
var inst_33545 = (state_33817[(10)]);
var inst_33611 = (state_33817[(36)]);
var inst_33610 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_33545);
var inst_33611__$1 = cljs.core.not.call(null,inst_33610);
var state_33817__$1 = (function (){var statearr_33980 = state_33817;
(statearr_33980[(36)] = inst_33611__$1);

return statearr_33980;
})();
if(inst_33611__$1){
var statearr_33981_34153 = state_33817__$1;
(statearr_33981_34153[(1)] = (41));

} else {
var statearr_33982_34154 = state_33817__$1;
(statearr_33982_34154[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (98))){
var inst_33737 = (state_33817[(2)]);
var state_33817__$1 = state_33817;
var statearr_33983_34155 = state_33817__$1;
(statearr_33983_34155[(2)] = inst_33737);

(statearr_33983_34155[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (87))){
var inst_33676 = (state_33817[(8)]);
var inst_33677 = (state_33817[(9)]);
var inst_33709 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_33710 = inst_33677.call(null,cljs.core.PersistentArrayMap,null,3,inst_33709,null);
var inst_33711 = inst_33677.call(null,cljs.core.PersistentHashSet,null,inst_33710,null);
var inst_33712 = inst_33711.call(null,inst_33676);
var state_33817__$1 = state_33817;
if(cljs.core.truth_(inst_33712)){
var statearr_33984_34156 = state_33817__$1;
(statearr_33984_34156[(1)] = (88));

} else {
var statearr_33985_34157 = state_33817__$1;
(statearr_33985_34157[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (30))){
var inst_33578 = (state_33817[(35)]);
var state_33817__$1 = state_33817;
var statearr_33986_34158 = state_33817__$1;
(statearr_33986_34158[(2)] = inst_33578);

(statearr_33986_34158[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (73))){
var state_33817__$1 = state_33817;
var statearr_33987_34159 = state_33817__$1;
(statearr_33987_34159[(1)] = (75));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (96))){
var inst_33664 = (state_33817[(12)]);
var state_33817__$1 = state_33817;
var statearr_33989_34160 = state_33817__$1;
(statearr_33989_34160[(2)] = inst_33664);

(statearr_33989_34160[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (10))){
var inst_33810 = (state_33817[(2)]);
var state_33817__$1 = state_33817;
var statearr_33990_34161 = state_33817__$1;
(statearr_33990_34161[(2)] = inst_33810);

(statearr_33990_34161[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (18))){
var inst_33533 = (state_33817[(15)]);
var state_33817__$1 = state_33817;
var statearr_33991_34162 = state_33817__$1;
(statearr_33991_34162[(2)] = inst_33533);

(statearr_33991_34162[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (105))){
var inst_33676 = (state_33817[(8)]);
var inst_33677 = (state_33817[(9)]);
var inst_33755 = fluree.db.query.schema.type_error.call(null,inst_33676,inst_33677,throw_QMARK_);
var state_33817__$1 = state_33817;
var statearr_33992_34163 = state_33817__$1;
(statearr_33992_34163[(2)] = inst_33755);

(statearr_33992_34163[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (52))){
var inst_33646 = (state_33817[(2)]);
var state_33817__$1 = state_33817;
var statearr_33993_34164 = state_33817__$1;
(statearr_33993_34164[(2)] = inst_33646);

(statearr_33993_34164[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (114))){
var inst_33545 = (state_33817[(10)]);
var inst_33782 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_33545);
var inst_33783 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_33782);
var inst_33784 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"ref","ref",1289896967),inst_33783);
var inst_33785 = (!(inst_33784));
var state_33817__$1 = state_33817;
var statearr_33994_34165 = state_33817__$1;
(statearr_33994_34165[(2)] = inst_33785);

(statearr_33994_34165[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (67))){
var inst_33664 = (state_33817[(12)]);
var state_33817__$1 = state_33817;
var statearr_33995_34166 = state_33817__$1;
(statearr_33995_34166[(2)] = inst_33664);

(statearr_33995_34166[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (71))){
var inst_33769 = (state_33817[(2)]);
var state_33817__$1 = state_33817;
var statearr_33996_34167 = state_33817__$1;
(statearr_33996_34167[(2)] = inst_33769);

(statearr_33996_34167[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (42))){
var inst_33611 = (state_33817[(36)]);
var state_33817__$1 = state_33817;
var statearr_33997_34168 = state_33817__$1;
(statearr_33997_34168[(2)] = inst_33611);

(statearr_33997_34168[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (80))){
var inst_33664 = (state_33817[(12)]);
var state_33817__$1 = state_33817;
var statearr_33998_34169 = state_33817__$1;
(statearr_33998_34169[(2)] = inst_33664);

(statearr_33998_34169[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (37))){
var inst_33604 = (state_33817[(2)]);
var state_33817__$1 = state_33817;
var statearr_33999_34170 = state_33817__$1;
(statearr_33999_34170[(2)] = inst_33604);

(statearr_33999_34170[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (63))){
var inst_33545 = (state_33817[(10)]);
var inst_33667 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_33545);
var inst_33668 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_33667);
var state_33817__$1 = state_33817;
var statearr_34000_34171 = state_33817__$1;
(statearr_34000_34171[(2)] = inst_33668);

(statearr_34000_34171[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (94))){
var inst_33727 = (state_33817[(2)]);
var state_33817__$1 = state_33817;
var statearr_34001_34172 = state_33817__$1;
(statearr_34001_34172[(2)] = inst_33727);

(statearr_34001_34172[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (8))){
var inst_33533 = (state_33817[(15)]);
var state_33817__$1 = state_33817;
var statearr_34002_34173 = state_33817__$1;
(statearr_34002_34173[(2)] = inst_33533);

(statearr_34002_34173[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (49))){
var inst_33649 = (state_33817[(2)]);
var state_33817__$1 = state_33817;
if(cljs.core.truth_(inst_33649)){
var statearr_34003_34174 = state_33817__$1;
(statearr_34003_34174[(1)] = (57));

} else {
var statearr_34004_34175 = state_33817__$1;
(statearr_34004_34175[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33818 === (84))){
var inst_33664 = (state_33817[(12)]);
var state_33817__$1 = state_33817;
var statearr_34005_34176 = state_33817__$1;
(statearr_34005_34176[(2)] = inst_33664);

(statearr_34005_34176[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__16221__auto__ = null;
var fluree$db$query$schema$state_machine__16221__auto____0 = (function (){
var statearr_34006 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34006[(0)] = fluree$db$query$schema$state_machine__16221__auto__);

(statearr_34006[(1)] = (1));

return statearr_34006;
});
var fluree$db$query$schema$state_machine__16221__auto____1 = (function (state_33817){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_33817);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e34007){var ex__16224__auto__ = e34007;
var statearr_34008_34177 = state_33817;
(statearr_34008_34177[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_33817[(4)]))){
var statearr_34009_34178 = state_33817;
(statearr_34009_34178[(1)] = cljs.core.first.call(null,(state_33817[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34179 = state_33817;
state_33817 = G__34179;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__16221__auto__ = function(state_33817){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__16221__auto____1.call(this,state_33817);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__16221__auto____0;
fluree$db$query$schema$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__16221__auto____1;
return fluree$db$query$schema$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_34010 = f__16346__auto__.call(null);
(statearr_34010[(6)] = c__16345__auto__);

return statearr_34010;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__34181 = arguments.length;
switch (G__34181) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.call(null,db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_34205){
var state_val_34206 = (state_34205[(1)]);
if((state_val_34206 === (7))){
var state_34205__$1 = state_34205;
var statearr_34207_34227 = state_34205__$1;
(statearr_34207_34227[(2)] = db);

(statearr_34207_34227[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34206 === (1))){
var state_34205__$1 = state_34205;
var statearr_34208_34228 = state_34205__$1;
(statearr_34208_34228[(2)] = null);

(statearr_34208_34228[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34206 === (4))){
var inst_34182 = (state_34205[(2)]);
var state_34205__$1 = state_34205;
var statearr_34209_34229 = state_34205__$1;
(statearr_34209_34229[(2)] = inst_34182);

(statearr_34209_34229[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34206 === (6))){
var inst_34191 = (state_34205[(7)]);
var inst_34190 = (state_34205[(2)]);
var inst_34191__$1 = fluree.db.util.async.throw_err.call(null,inst_34190);
var inst_34192 = cljs.core.empty_QMARK_.call(null,inst_34191__$1);
var state_34205__$1 = (function (){var statearr_34210 = state_34205;
(statearr_34210[(7)] = inst_34191__$1);

return statearr_34210;
})();
if(inst_34192){
var statearr_34211_34230 = state_34205__$1;
(statearr_34211_34230[(1)] = (7));

} else {
var statearr_34212_34231 = state_34205__$1;
(statearr_34212_34231[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34206 === (3))){
var inst_34203 = (state_34205[(2)]);
var state_34205__$1 = state_34205;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34205__$1,inst_34203);
} else {
if((state_val_34206 === (2))){
var _ = (function (){var statearr_34214 = state_34205;
(statearr_34214[(4)] = cljs.core.cons.call(null,(5),(state_34205[(4)])));

return statearr_34214;
})();
var inst_34188 = fluree.db.query.schema.new_pred_changes.call(null,db,tempids,flakes,filter_QMARK_);
var state_34205__$1 = state_34205;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34205__$1,(6),inst_34188);
} else {
if((state_val_34206 === (9))){
var inst_34200 = (state_34205[(2)]);
var _ = (function (){var statearr_34215 = state_34205;
(statearr_34215[(4)] = cljs.core.rest.call(null,(state_34205[(4)])));

return statearr_34215;
})();
var state_34205__$1 = state_34205;
var statearr_34216_34232 = state_34205__$1;
(statearr_34216_34232[(2)] = inst_34200);

(statearr_34216_34232[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34206 === (5))){
var _ = (function (){var statearr_34217 = state_34205;
(statearr_34217[(4)] = cljs.core.rest.call(null,(state_34205[(4)])));

return statearr_34217;
})();
var state_34205__$1 = state_34205;
var ex34213 = (state_34205__$1[(2)]);
var statearr_34218_34233 = state_34205__$1;
(statearr_34218_34233[(5)] = ex34213);


if((ex34213 instanceof Error)){
var statearr_34219_34234 = state_34205__$1;
(statearr_34219_34234[(1)] = (4));

(statearr_34219_34234[(5)] = null);

} else {
throw ex34213;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34206 === (10))){
var inst_34197 = (state_34205[(2)]);
var inst_34198 = fluree.db.util.async.throw_err.call(null,inst_34197);
var state_34205__$1 = state_34205;
var statearr_34220_34235 = state_34205__$1;
(statearr_34220_34235[(2)] = inst_34198);

(statearr_34220_34235[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34206 === (8))){
var inst_34191 = (state_34205[(7)]);
var inst_34195 = fluree.db.query.schema.predicate_change_error.call(null,inst_34191,db,true);
var state_34205__$1 = state_34205;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34205__$1,(10),inst_34195);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__16221__auto__ = null;
var fluree$db$query$schema$state_machine__16221__auto____0 = (function (){
var statearr_34221 = [null,null,null,null,null,null,null,null];
(statearr_34221[(0)] = fluree$db$query$schema$state_machine__16221__auto__);

(statearr_34221[(1)] = (1));

return statearr_34221;
});
var fluree$db$query$schema$state_machine__16221__auto____1 = (function (state_34205){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_34205);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e34222){var ex__16224__auto__ = e34222;
var statearr_34223_34236 = state_34205;
(statearr_34223_34236[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_34205[(4)]))){
var statearr_34224_34237 = state_34205;
(statearr_34224_34237[(1)] = cljs.core.first.call(null,(state_34205[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34238 = state_34205;
state_34205 = G__34238;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__16221__auto__ = function(state_34205){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__16221__auto____1.call(this,state_34205);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__16221__auto____0;
fluree$db$query$schema$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__16221__auto____1;
return fluree$db$query$schema$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_34225 = f__16346__auto__.call(null);
(statearr_34225[(6)] = c__16345__auto__);

return statearr_34225;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__34240 = arguments.length;
switch (G__34240) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.call(null,predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__34242 = cljs.core.re_matches.call(null,/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.call(null,vec__34242,(0),null);
var ns = cljs.core.nth.call(null,vec__34242,(1),null);
var name = cljs.core.nth.call(null,vec__34242,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.call(null,"_",cljs.core.nth.call(null,name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.call(null,name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(2)),fluree.db.flake.__GT_sid.call(null,(3),(9)),fluree.db.flake.__GT_sid.call(null,(3),(14)),fluree.db.flake.__GT_sid.call(null,(3),(16)),fluree.db.flake.__GT_sid.call(null,(3),(8)),fluree.db.flake.__GT_sid.call(null,(3),(4)),fluree.db.flake.__GT_sid.call(null,(3),(5)),fluree.db.flake.__GT_sid.call(null,(3),(15)),fluree.db.flake.__GT_sid.call(null,(3),(17)),fluree.db.flake.__GT_sid.call(null,(3),(11)),fluree.db.flake.__GT_sid.call(null,(3),(12)),fluree.db.flake.__GT_sid.call(null,(3),(1)),fluree.db.flake.__GT_sid.call(null,(3),(10)),fluree.db.flake.__GT_sid.call(null,(3),(6)),fluree.db.flake.__GT_sid.call(null,(3),(7)),fluree.db.flake.__GT_sid.call(null,(3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(62)),fluree.db.flake.__GT_sid.call(null,(3),(68)),fluree.db.flake.__GT_sid.call(null,(3),(67)),fluree.db.flake.__GT_sid.call(null,(3),(69)),fluree.db.flake.__GT_sid.call(null,(3),(63)),fluree.db.flake.__GT_sid.call(null,(3),(70)),fluree.db.flake.__GT_sid.call(null,(3),(65)),fluree.db.flake.__GT_sid.call(null,(3),(66)),fluree.db.flake.__GT_sid.call(null,(3),(64)),fluree.db.flake.__GT_sid.call(null,(3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.call(null,(function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.call(null,acc,p);
if(cljs.core.truth_((function (){var and__4210__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.vector_QMARK_.call(null,existing_QMARK_);
} else {
return and__4210__auto__;
}
})())){
return cljs.core.update.call(null,acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.call(null,acc,p,(function (p1__34245_SHARP_,p2__34246_SHARP_){
return cljs.core.vec.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__34245_SHARP_,p2__34246_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.call(null,acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec.call(null,cljs.core.keep.call(null,(function (p1__34247_SHARP_){
var f = p1__34247_SHARP_;
if(cljs.core._EQ_.call(null,spec_pid,f.p)){
return f.o;
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_34313){
var state_val_34314 = (state_34313[(1)]);
if((state_val_34314 === (1))){
var state_34313__$1 = state_34313;
var statearr_34315_34332 = state_34313__$1;
(statearr_34315_34332[(2)] = null);

(statearr_34315_34332[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34314 === (2))){
var _ = (function (){var statearr_34316 = state_34313;
(statearr_34316[(4)] = cljs.core.cons.call(null,(5),(state_34313[(4)])));

return statearr_34316;
})();
var inst_34265 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34266 = fluree.db.flake.max_subject_id.call(null,(1));
var inst_34267 = [inst_34266];
var inst_34268 = (new cljs.core.PersistentVector(null,1,(5),inst_34265,inst_34267,null));
var inst_34269 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34270 = [(0)];
var inst_34271 = (new cljs.core.PersistentVector(null,1,(5),inst_34269,inst_34270,null));
var inst_34272 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_34268,cljs.core._LT__EQ_,inst_34271);
var state_34313__$1 = state_34313;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34313__$1,(6),inst_34272);
} else {
if((state_val_34314 === (3))){
var inst_34311 = (state_34313[(2)]);
var state_34313__$1 = state_34313;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34313__$1,inst_34311);
} else {
if((state_val_34314 === (4))){
var inst_34253 = (state_34313[(2)]);
var state_34313__$1 = state_34313;
var statearr_34318_34333 = state_34313__$1;
(statearr_34318_34333[(2)] = inst_34253);

(statearr_34318_34333[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34314 === (5))){
var _ = (function (){var statearr_34319 = state_34313;
(statearr_34319[(4)] = cljs.core.rest.call(null,(state_34313[(4)])));

return statearr_34319;
})();
var state_34313__$1 = state_34313;
var ex34317 = (state_34313__$1[(2)]);
var statearr_34320_34334 = state_34313__$1;
(statearr_34320_34334[(5)] = ex34317);


if((ex34317 instanceof Error)){
var statearr_34321_34335 = state_34313__$1;
(statearr_34321_34335[(1)] = (4));

(statearr_34321_34335[(5)] = null);

} else {
throw ex34317;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34314 === (6))){
var inst_34274 = (state_34313[(2)]);
var inst_34275 = fluree.db.util.async.throw_err.call(null,inst_34274);
var inst_34276 = (function (){var schema_flakes = inst_34275;
return (function (p1__34248_SHARP_){
return (p1__34248_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_34277 = cljs.core.partition_by.call(null,inst_34276,inst_34275);
var inst_34278 = cljs.core.nth.call(null,inst_34277,(0),null);
var inst_34279 = cljs.core.nth.call(null,inst_34277,(1),null);
var inst_34280 = (function (){var schema_flakes = inst_34275;
var vec__34259 = inst_34277;
var collection_flakes = inst_34278;
var predicate_flakes = inst_34279;
return (function (acc,coll_flakes){
var first_flake = cljs.core.first.call(null,coll_flakes);
var sid = first_flake.s;
var p__GT_v = cljs.core.reduce.call(null,(function (p1__34251_SHARP_,p2__34250_SHARP_){
var f = p2__34250_SHARP_;
return cljs.core.assoc.call(null,p1__34251_SHARP_,f.p,f.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__4212__auto__ = cljs.core.get.call(null,p__GT_v,(47));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.flake.sid__GT_i.call(null,sid);
}
})();
var c_name = cljs.core.get.call(null,p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids.call(null,(43),coll_flakes):null);
var specDoc = cljs.core.get.call(null,p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),specs,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),partition,new cljs.core.Keyword(null,"partition","partition",1174740751),partition], null);
return cljs.core.assoc.call(null,acc,partition,c_props,c_name,c_props);
});
})();
var inst_34281 = [(-1),"_tx"];
var inst_34282 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_34283 = ["_tx",(-1),(-1),(-1),null,null];
var inst_34284 = cljs.core.PersistentHashMap.fromArrays(inst_34282,inst_34283);
var inst_34285 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_34286 = ["_tx",(-1),(-1),(-1),null,null];
var inst_34287 = cljs.core.PersistentHashMap.fromArrays(inst_34285,inst_34286);
var inst_34288 = [inst_34284,inst_34287];
var inst_34289 = cljs.core.PersistentHashMap.fromArrays(inst_34281,inst_34288);
var inst_34290 = (function (){var schema_flakes = inst_34275;
var vec__34259 = inst_34277;
var collection_flakes = inst_34278;
var predicate_flakes = inst_34279;
return (function (p1__34249_SHARP_){
return p1__34249_SHARP_.s;
});
})();
var inst_34291 = cljs.core.partition_by.call(null,inst_34290,inst_34278);
var inst_34292 = cljs.core.reduce.call(null,inst_34280,inst_34289,inst_34291);
var inst_34294 = (function (){var schema_flakes = inst_34275;
var vec__34259 = inst_34277;
var collection_flakes = inst_34278;
var predicate_flakes = inst_34279;
var coll = inst_34292;
return (function (p__34293,pred_flakes){
var vec__34322 = p__34293;
var pred = cljs.core.nth.call(null,vec__34322,(0),null);
var fullText = cljs.core.nth.call(null,vec__34322,(1),null);
var first_flake = cljs.core.first.call(null,pred_flakes);
var id = first_flake.s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map.call(null,pred_flakes);
var p_name = cljs.core.get.call(null,p__GT_v,(10));
var p_type = cljs.core.get.call(null,fluree.db.query.schema.type_sid__GT_type,cljs.core.get.call(null,p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null).call(null,p_type));
var idx_QMARK_ = cljs.core.boolean$.call(null,(function (){var or__4212__auto__ = ref_QMARK_;
if(or__4212__auto__){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = cljs.core.get.call(null,p__GT_v,(15));
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return cljs.core.get.call(null,p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.call(null,p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(13))),cljs.core.get.call(null,p__GT_v,(19)),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(15))),p_name,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids.call(null,(24),pred_flakes):null),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(17))),cljs.core.get.call(null,p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids.call(null,(20),pred_flakes):null),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(14))),id,cljs.core.get.call(null,p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(16))),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(29))),cljs.core.get.call(null,p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,pred,id,p_props,p_name,p_props),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.call(null,fullText,id):fullText)], null);
});
})();
var inst_34295 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34296 = cljs.core.PersistentHashMap.EMPTY;
var inst_34297 = cljs.core.PersistentHashSet.EMPTY;
var inst_34298 = [inst_34296,inst_34297];
var inst_34299 = (new cljs.core.PersistentVector(null,2,(5),inst_34295,inst_34298,null));
var inst_34300 = (function (){var schema_flakes = inst_34275;
var vec__34259 = inst_34277;
var collection_flakes = inst_34278;
var predicate_flakes = inst_34279;
var coll = inst_34292;
return (function (p1__34252_SHARP_){
return p1__34252_SHARP_.s;
});
})();
var inst_34301 = cljs.core.partition_by.call(null,inst_34300,inst_34279);
var inst_34302 = cljs.core.reduce.call(null,inst_34294,inst_34299,inst_34301);
var inst_34303 = cljs.core.nth.call(null,inst_34302,(0),null);
var inst_34304 = cljs.core.nth.call(null,inst_34302,(1),null);
var inst_34305 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_34306 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_34307 = [inst_34306,inst_34292,inst_34303,inst_34304];
var inst_34308 = cljs.core.PersistentHashMap.fromArrays(inst_34305,inst_34307);
var _ = (function (){var statearr_34325 = state_34313;
(statearr_34325[(4)] = cljs.core.rest.call(null,(state_34313[(4)])));

return statearr_34325;
})();
var state_34313__$1 = state_34313;
var statearr_34326_34336 = state_34313__$1;
(statearr_34326_34336[(2)] = inst_34308);

(statearr_34326_34336[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__16221__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__16221__auto____0 = (function (){
var statearr_34327 = [null,null,null,null,null,null,null];
(statearr_34327[(0)] = fluree$db$query$schema$schema_map_$_state_machine__16221__auto__);

(statearr_34327[(1)] = (1));

return statearr_34327;
});
var fluree$db$query$schema$schema_map_$_state_machine__16221__auto____1 = (function (state_34313){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_34313);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e34328){var ex__16224__auto__ = e34328;
var statearr_34329_34337 = state_34313;
(statearr_34329_34337[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_34313[(4)]))){
var statearr_34330_34338 = state_34313;
(statearr_34330_34338[(1)] = cljs.core.first.call(null,(state_34313[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34339 = state_34313;
state_34313 = G__34339;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__16221__auto__ = function(state_34313){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__16221__auto____1.call(this,state_34313);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__16221__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__16221__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_34331 = f__16346__auto__.call(null);
(statearr_34331[(6)] = c__16345__auto__);

return statearr_34331;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_34381){
var state_val_34382 = (state_34381[(1)]);
if((state_val_34382 === (7))){
var inst_34364 = (state_34381[(2)]);
var inst_34365 = fluree.db.query.schema.flake__GT_pred_map.call(null,inst_34364);
var inst_34366 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_34367 = cljs.core.get.call(null,inst_34365,(114));
var inst_34368 = cljs.core.boolean$.call(null,inst_34367);
var inst_34369 = cljs.core.get.call(null,inst_34365,(110));
var inst_34370 = cljs.core.get.call(null,inst_34365,(117));
var inst_34371 = cljs.core.get.call(null,fluree.db.query.schema.lang_sid__GT_lang,inst_34370);
var inst_34372 = cljs.core.get.call(null,inst_34365,(111));
var inst_34373 = cljs.core.get.call(null,inst_34365,(115));
var inst_34374 = cljs.core.get.call(null,inst_34365,(112));
var inst_34375 = [inst_34368,inst_34369,inst_34371,inst_34372,inst_34373,inst_34374];
var inst_34376 = cljs.core.PersistentHashMap.fromArrays(inst_34366,inst_34375);
var _ = (function (){var statearr_34383 = state_34381;
(statearr_34383[(4)] = cljs.core.rest.call(null,(state_34381[(4)])));

return statearr_34383;
})();
var state_34381__$1 = state_34381;
var statearr_34384_34407 = state_34381__$1;
(statearr_34384_34407[(2)] = inst_34376);

(statearr_34384_34407[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34382 === (1))){
var state_34381__$1 = state_34381;
var statearr_34385_34408 = state_34381__$1;
(statearr_34385_34408[(2)] = null);

(statearr_34385_34408[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34382 === (4))){
var inst_34340 = (state_34381[(2)]);
var state_34381__$1 = state_34381;
var statearr_34386_34409 = state_34381__$1;
(statearr_34386_34409[(2)] = inst_34340);

(statearr_34386_34409[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34382 === (6))){
var _ = (function (){var statearr_34387 = state_34381;
(statearr_34387[(4)] = cljs.core.cons.call(null,(9),(state_34381[(4)])));

return statearr_34387;
})();
var inst_34352 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34353 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34354 = ["_setting/id","root"];
var inst_34355 = (new cljs.core.PersistentVector(null,2,(5),inst_34353,inst_34354,null));
var inst_34356 = [inst_34355];
var inst_34357 = (new cljs.core.PersistentVector(null,1,(5),inst_34352,inst_34356,null));
var inst_34358 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_34357);
var state_34381__$1 = state_34381;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34381__$1,(10),inst_34358);
} else {
if((state_val_34382 === (3))){
var inst_34379 = (state_34381[(2)]);
var state_34381__$1 = state_34381;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34381__$1,inst_34379);
} else {
if((state_val_34382 === (2))){
var _ = (function (){var statearr_34390 = state_34381;
(statearr_34390[(4)] = cljs.core.cons.call(null,(5),(state_34381[(4)])));

return statearr_34390;
})();
var state_34381__$1 = state_34381;
var statearr_34391_34410 = state_34381__$1;
(statearr_34391_34410[(2)] = null);

(statearr_34391_34410[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34382 === (9))){
var _ = (function (){var statearr_34392 = state_34381;
(statearr_34392[(4)] = cljs.core.rest.call(null,(state_34381[(4)])));

return statearr_34392;
})();
var state_34381__$1 = state_34381;
var ex34388 = (state_34381__$1[(2)]);
var statearr_34393_34411 = state_34381__$1;
(statearr_34393_34411[(5)] = ex34388);


var statearr_34394_34412 = state_34381__$1;
(statearr_34394_34412[(1)] = (8));

(statearr_34394_34412[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34382 === (5))){
var _ = (function (){var statearr_34395 = state_34381;
(statearr_34395[(4)] = cljs.core.rest.call(null,(state_34381[(4)])));

return statearr_34395;
})();
var state_34381__$1 = state_34381;
var ex34389 = (state_34381__$1[(2)]);
var statearr_34396_34413 = state_34381__$1;
(statearr_34396_34413[(5)] = ex34389);


if((ex34389 instanceof Error)){
var statearr_34397_34414 = state_34381__$1;
(statearr_34397_34414[(1)] = (4));

(statearr_34397_34414[(5)] = null);

} else {
throw ex34389;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34382 === (10))){
var inst_34360 = (state_34381[(2)]);
var inst_34361 = fluree.db.util.async.throw_err.call(null,inst_34360);
var _ = (function (){var statearr_34398 = state_34381;
(statearr_34398[(4)] = cljs.core.rest.call(null,(state_34381[(4)])));

return statearr_34398;
})();
var state_34381__$1 = state_34381;
var statearr_34399_34415 = state_34381__$1;
(statearr_34399_34415[(2)] = inst_34361);

(statearr_34399_34415[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34382 === (8))){
var inst_34346 = (state_34381[(2)]);
var state_34381__$1 = (function (){var statearr_34400 = state_34381;
(statearr_34400[(7)] = inst_34346);

return statearr_34400;
})();
var statearr_34401_34416 = state_34381__$1;
(statearr_34401_34416[(2)] = null);

(statearr_34401_34416[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__16221__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__16221__auto____0 = (function (){
var statearr_34402 = [null,null,null,null,null,null,null,null];
(statearr_34402[(0)] = fluree$db$query$schema$setting_map_$_state_machine__16221__auto__);

(statearr_34402[(1)] = (1));

return statearr_34402;
});
var fluree$db$query$schema$setting_map_$_state_machine__16221__auto____1 = (function (state_34381){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_34381);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e34403){var ex__16224__auto__ = e34403;
var statearr_34404_34417 = state_34381;
(statearr_34404_34417[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_34381[(4)]))){
var statearr_34405_34418 = state_34381;
(statearr_34405_34418[(1)] = cljs.core.first.call(null,(state_34381[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34419 = state_34381;
state_34381 = G__34419;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__16221__auto__ = function(state_34381){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__16221__auto____1.call(this,state_34381);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__16221__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__16221__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_34406 = f__16346__auto__.call(null);
(statearr_34406[(6)] = c__16345__auto__);

return statearr_34406;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
