// Compiled by ClojureScript 1.10.879 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql.vswap_BANG_ = (function fluree$db$query$fql$vswap_BANG_(var_args){
var G__39445 = arguments.length;
switch (G__39445) {
case 2:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol)));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2,arg3));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__39448 = arguments.length;
switch (G__39448) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__39450 = null;
var G__39450__0 = (function (){
return xf.call(null);
});
var G__39450__1 = (function (result){
return xf.call(null,result);
});
var G__39450__2 = (function (result,flake){
fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__4210__auto__ = max_fuel;
if(cljs.core.truth_(and__4210__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__4210__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return xf.call(null,result,flake);
});
G__39450 = function(result,flake){
switch(arguments.length){
case 0:
return G__39450__0.call(this);
case 1:
return G__39450__1.call(this,result);
case 2:
return G__39450__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__39450.cljs$core$IFn$_invoke$arity$0 = G__39450__0;
G__39450.cljs$core$IFn$_invoke$arity$1 = G__39450__1;
G__39450.cljs$core$IFn$_invoke$arity$2 = G__39450__2;
return G__39450;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__39451 = null;
var G__39451__0 = (function (){
return xf.call(null);
});
var G__39451__1 = (function (result){
return xf.call(null,result);
});
var G__39451__2 = (function (result,flakes){
fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,cljs.core.count.call(null,flakes));

return xf.call(null,result,flakes);
});
G__39451 = function(result,flakes){
switch(arguments.length){
case 0:
return G__39451__0.call(this);
case 1:
return G__39451__1.call(this,result);
case 2:
return G__39451__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__39451.cljs$core$IFn$_invoke$arity$0 = G__39451__0;
G__39451.cljs$core$IFn$_invoke$arity$1 = G__39451__1;
G__39451.cljs$core$IFn$_invoke$arity$2 = G__39451__2;
return G__39451;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,n);

if(cljs.core.truth_((function (){var and__4210__auto__ = max_fuel;
if(cljs.core.truth_(and__4210__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__4210__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4212__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config.call(null,db,p,compact_QMARK_);
fluree.db.query.fql.vswap_BANG_.call(null,cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map);

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare.call(null,clojure.string.upper_case.call(null,a),clojure.string.upper_case.call(null,b));
if(cljs.core._EQ_.call(null,res,(0))){
return ((-1) * cljs.core.compare.call(null,a,b));
} else {
return res;
}
} else {
return cljs.core.compare.call(null,a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_.call(null,res)){
var G__39453 = res;
var G__39453__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.call(null,(function (p1__39452_SHARP_){
return cljs.core.get.call(null,p1__39452_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__39453):G__39453);
var G__39453__$2 = ((cljs.core._EQ_.call(null,"DESC",sortOrder))?cljs.core.reverse.call(null,G__39453__$1):G__39453__$1);
var G__39453__$3 = (cljs.core.truth_(offset)?cljs.core.drop.call(null,offset,G__39453__$2):G__39453__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.call(null,limit,G__39453__$3);
} else {
return G__39453__$3;
}
} else {
return res;
}
});
/**
 * Adds a predicate to a select spec graph crawl. flakes input is a list of flakes
 *   all with the same subject and predicate values.
 */
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__39457 = arguments.length;
switch (G__39457) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_39896){
var state_val_39897 = (state_39896[(1)]);
if((state_val_39897 === (121))){
var inst_39819 = (state_39896[(2)]);
var inst_39820 = fluree.db.util.async.throw_err.call(null,inst_39819);
var inst_39821 = cljs.core.seq.call(null,inst_39820);
var state_39896__$1 = state_39896;
if(inst_39821){
var statearr_39898_40112 = state_39896__$1;
(statearr_39898_40112[(1)] = (122));

} else {
var statearr_39899_40113 = state_39896__$1;
(statearr_39899_40113[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (65))){
var inst_39612 = (state_39896[(7)]);
var inst_39611 = (state_39896[(2)]);
var inst_39612__$1 = fluree.db.util.async.throw_err.call(null,inst_39611);
var inst_39613 = cljs.core.seq.call(null,inst_39612__$1);
var state_39896__$1 = (function (){var statearr_39900 = state_39896;
(statearr_39900[(7)] = inst_39612__$1);

return statearr_39900;
})();
if(inst_39613){
var statearr_39901_40114 = state_39896__$1;
(statearr_39901_40114[(1)] = (66));

} else {
var statearr_39902_40115 = state_39896__$1;
(statearr_39902_40115[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (70))){
var inst_39612 = (state_39896[(7)]);
var inst_39623 = cljs.core.count.call(null,inst_39612);
var inst_39624 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_39623);
var state_39896__$1 = state_39896;
var statearr_39903_40116 = state_39896__$1;
(statearr_39903_40116[(2)] = inst_39624);

(statearr_39903_40116[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (62))){
var inst_39602 = (state_39896[(8)]);
var inst_39605 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39606 = inst_39602.o;
var inst_39607 = [inst_39606];
var inst_39608 = (new cljs.core.PersistentVector(null,1,(5),inst_39605,inst_39607,null));
var inst_39609 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_39608);
var state_39896__$1 = state_39896;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39896__$1,(65),inst_39609);
} else {
if((state_val_39897 === (74))){
var inst_39596 = (state_39896[(9)]);
var state_39896__$1 = state_39896;
var statearr_39904_40117 = state_39896__$1;
(statearr_39904_40117[(2)] = inst_39596);

(statearr_39904_40117[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (110))){
var inst_39781 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_39782 = new cljs.core.Keyword(null,"root?","root?",-2045639518).cljs$core$IFn$_invoke$arity$1(inst_39781);
var inst_39783 = inst_39782 === true;
var state_39896__$1 = state_39896;
if(cljs.core.truth_(inst_39783)){
var statearr_39905_40118 = state_39896__$1;
(statearr_39905_40118[(1)] = (113));

} else {
var statearr_39906_40119 = state_39896__$1;
(statearr_39906_40119[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (130))){
var inst_39891 = (state_39896[(2)]);
var _ = (function (){var statearr_39907 = state_39896;
(statearr_39907[(4)] = cljs.core.rest.call(null,(state_39896[(4)])));

return statearr_39907;
})();
var state_39896__$1 = state_39896;
var statearr_39908_40120 = state_39896__$1;
(statearr_39908_40120[(2)] = inst_39891);

(statearr_39908_40120[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (128))){
var inst_39866 = (state_39896[(10)]);
var inst_39869 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39870 = [acc,inst_39866];
var inst_39871 = (new cljs.core.PersistentVector(null,2,(5),inst_39869,inst_39870,null));
var state_39896__$1 = state_39896;
var statearr_39909_40121 = state_39896__$1;
(statearr_39909_40121[(2)] = inst_39871);

(statearr_39909_40121[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (7))){
var inst_39469 = (state_39896[(11)]);
var state_39896__$1 = state_39896;
var statearr_39910_40122 = state_39896__$1;
(statearr_39910_40122[(2)] = inst_39469);

(statearr_39910_40122[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (59))){
var inst_39860 = (state_39896[(2)]);
var state_39896__$1 = state_39896;
var statearr_39911_40123 = state_39896__$1;
(statearr_39911_40123[(2)] = inst_39860);

(statearr_39911_40123[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (86))){
var inst_39690 = (state_39896[(12)]);
var inst_39690__$1 = (state_39896[(2)]);
var state_39896__$1 = (function (){var statearr_39912 = state_39896;
(statearr_39912[(12)] = inst_39690__$1);

return statearr_39912;
})();
if(cljs.core.truth_(inst_39690__$1)){
var statearr_39913_40124 = state_39896__$1;
(statearr_39913_40124[(1)] = (88));

} else {
var statearr_39914_40125 = state_39896__$1;
(statearr_39914_40125[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (20))){
var inst_39510 = (state_39896[(13)]);
var inst_39498 = (state_39896[(14)]);
var inst_39511 = (state_39896[(15)]);
var inst_39509 = (state_39896[(2)]);
var inst_39510__$1 = cljs.core.__destructure_map.call(null,inst_39498);
var inst_39511__$1 = cljs.core.get.call(null,inst_39510__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_39512 = cljs.core.get.call(null,inst_39510__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_39513 = cljs.core.get.call(null,inst_39510__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_39514 = cljs.core.get.call(null,inst_39510__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_39515 = cljs.core.get.call(null,inst_39510__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_39516 = cljs.core.get.call(null,inst_39510__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_39896__$1 = (function (){var statearr_39915 = state_39896;
(statearr_39915[(16)] = inst_39509);

(statearr_39915[(13)] = inst_39510__$1);

(statearr_39915[(17)] = inst_39514);

(statearr_39915[(18)] = inst_39515);

(statearr_39915[(19)] = inst_39512);

(statearr_39915[(20)] = inst_39513);

(statearr_39915[(15)] = inst_39511__$1);

(statearr_39915[(21)] = inst_39516);

return statearr_39915;
})();
if(cljs.core.truth_(inst_39511__$1)){
var statearr_39916_40126 = state_39896__$1;
(statearr_39916_40126[(1)] = (24));

} else {
var statearr_39917_40127 = state_39896__$1;
(statearr_39917_40127[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (72))){
var inst_39621 = (state_39896[(22)]);
var inst_39627 = (state_39896[(2)]);
var inst_39628 = cljs.core.seq.call(null,inst_39621);
var state_39896__$1 = (function (){var statearr_39918 = state_39896;
(statearr_39918[(23)] = inst_39627);

return statearr_39918;
})();
if(inst_39628){
var statearr_39919_40128 = state_39896__$1;
(statearr_39919_40128[(1)] = (73));

} else {
var statearr_39920_40129 = state_39896__$1;
(statearr_39920_40129[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (58))){
var inst_39498 = (state_39896[(14)]);
var inst_39643 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_39498);
var state_39896__$1 = state_39896;
if(cljs.core.truth_(inst_39643)){
var statearr_39921_40130 = state_39896__$1;
(statearr_39921_40130[(1)] = (76));

} else {
var statearr_39922_40131 = state_39896__$1;
(statearr_39922_40131[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (60))){
var inst_39602 = (state_39896[(8)]);
var inst_39595 = (state_39896[(24)]);
var inst_39601 = cljs.core.seq.call(null,inst_39595);
var inst_39602__$1 = cljs.core.first.call(null,inst_39601);
var inst_39603 = cljs.core.next.call(null,inst_39601);
var state_39896__$1 = (function (){var statearr_39923 = state_39896;
(statearr_39923[(8)] = inst_39602__$1);

(statearr_39923[(25)] = inst_39603);

return statearr_39923;
})();
if(cljs.core.truth_(inst_39602__$1)){
var statearr_39924_40132 = state_39896__$1;
(statearr_39924_40132[(1)] = (62));

} else {
var statearr_39925_40133 = state_39896__$1;
(statearr_39925_40133[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (27))){
var inst_39515 = (state_39896[(18)]);
var inst_39519 = (state_39896[(26)]);
var inst_39519__$1 = cljs.core.not_EQ_.call(null,(0),inst_39515);
var state_39896__$1 = (function (){var statearr_39926 = state_39896;
(statearr_39926[(26)] = inst_39519__$1);

return statearr_39926;
})();
if(inst_39519__$1){
var statearr_39927_40134 = state_39896__$1;
(statearr_39927_40134[(1)] = (30));

} else {
var statearr_39928_40135 = state_39896__$1;
(statearr_39928_40135[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (1))){
var state_39896__$1 = state_39896;
var statearr_39929_40136 = state_39896__$1;
(statearr_39929_40136[(2)] = null);

(statearr_39929_40136[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (69))){
var inst_39617 = (state_39896[(2)]);
var inst_39618 = fluree.db.util.async.throw_err.call(null,inst_39617);
var state_39896__$1 = state_39896;
var statearr_39930_40137 = state_39896__$1;
(statearr_39930_40137[(2)] = inst_39618);

(statearr_39930_40137[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (101))){
var inst_39774 = (state_39896[(2)]);
var state_39896__$1 = state_39896;
var statearr_39931_40138 = state_39896__$1;
(statearr_39931_40138[(2)] = inst_39774);

(statearr_39931_40138[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (24))){
var inst_39515 = (state_39896[(18)]);
var state_39896__$1 = state_39896;
if(cljs.core.truth_(inst_39515)){
var statearr_39932_40139 = state_39896__$1;
(statearr_39932_40139[(1)] = (27));

} else {
var statearr_39933_40140 = state_39896__$1;
(statearr_39933_40140[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (102))){
var inst_39746 = (state_39896[(27)]);
var inst_39745 = (state_39896[(2)]);
var inst_39746__$1 = fluree.db.util.async.throw_err.call(null,inst_39745);
var inst_39747 = cljs.core.empty_QMARK_.call(null,inst_39746__$1);
var state_39896__$1 = (function (){var statearr_39934 = state_39896;
(statearr_39934[(27)] = inst_39746__$1);

return statearr_39934;
})();
if(inst_39747){
var statearr_39935_40141 = state_39896__$1;
(statearr_39935_40141[(1)] = (103));

} else {
var statearr_39936_40142 = state_39896__$1;
(statearr_39936_40142[(1)] = (104));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (135))){
var state_39896__$1 = state_39896;
var statearr_39937_40143 = state_39896__$1;
(statearr_39937_40143[(2)] = null);

(statearr_39937_40143[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (55))){
var inst_39498 = (state_39896[(14)]);
var inst_39571 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_39498);
var state_39896__$1 = state_39896;
var statearr_39938_40144 = state_39896__$1;
(statearr_39938_40144[(2)] = inst_39571);

(statearr_39938_40144[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (85))){
var inst_39665 = (state_39896[(28)]);
var inst_39498 = (state_39896[(14)]);
var inst_39677 = inst_39665.o;
var inst_39678 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_39498);
var inst_39679 = fluree.db.dbproto._tag.call(null,db,inst_39677,inst_39678);
var state_39896__$1 = state_39896;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39896__$1,(87),inst_39679);
} else {
if((state_val_39897 === (39))){
var inst_39514 = (state_39896[(17)]);
var inst_39546 = (state_39896[(29)]);
var inst_39546__$1 = cljs.core.not.call(null,inst_39514);
var state_39896__$1 = (function (){var statearr_39939 = state_39896;
(statearr_39939[(29)] = inst_39546__$1);

return statearr_39939;
})();
if(inst_39546__$1){
var statearr_39940_40145 = state_39896__$1;
(statearr_39940_40145[(1)] = (42));

} else {
var statearr_39941_40146 = state_39896__$1;
(statearr_39941_40146[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (88))){
var inst_39690 = (state_39896[(12)]);
var inst_39659 = (state_39896[(30)]);
var inst_39692 = cljs.core.conj.call(null,inst_39659,inst_39690);
var state_39896__$1 = state_39896;
var statearr_39942_40147 = state_39896__$1;
(statearr_39942_40147[(2)] = inst_39692);

(statearr_39942_40147[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (46))){
var inst_39513 = (state_39896[(20)]);
var state_39896__$1 = state_39896;
var statearr_39943_40148 = state_39896__$1;
(statearr_39943_40148[(2)] = inst_39513);

(statearr_39943_40148[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (4))){
var inst_39458 = (state_39896[(2)]);
var state_39896__$1 = state_39896;
var statearr_39944_40149 = state_39896__$1;
(statearr_39944_40149[(2)] = inst_39458);

(statearr_39944_40149[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (77))){
var inst_39705 = (state_39896[(31)]);
var inst_39705__$1 = componentFollow_QMARK_;
var state_39896__$1 = (function (){var statearr_39945 = state_39896;
(statearr_39945[(31)] = inst_39705__$1);

return statearr_39945;
})();
if(cljs.core.truth_(inst_39705__$1)){
var statearr_39946_40150 = state_39896__$1;
(statearr_39946_40150[(1)] = (91));

} else {
var statearr_39947_40151 = state_39896__$1;
(statearr_39947_40151[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (106))){
var inst_39726 = (state_39896[(32)]);
var inst_39760 = (state_39896[(2)]);
var inst_39761 = fluree.db.util.async.throw_err.call(null,inst_39760);
var inst_39762 = cljs.core.conj.call(null,inst_39726,inst_39761);
var state_39896__$1 = state_39896;
var statearr_39948_40152 = state_39896__$1;
(statearr_39948_40152[(2)] = inst_39762);

(statearr_39948_40152[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (119))){
var inst_39804 = (state_39896[(33)]);
var inst_39834 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39835 = [inst_39804,offset_map];
var inst_39836 = (new cljs.core.PersistentVector(null,2,(5),inst_39834,inst_39835,null));
var state_39896__$1 = state_39896;
var statearr_39949_40153 = state_39896__$1;
(statearr_39949_40153[(2)] = inst_39836);

(statearr_39949_40153[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (95))){
var inst_39512 = (state_39896[(19)]);
var state_39896__$1 = state_39896;
if(cljs.core.truth_(inst_39512)){
var statearr_39950_40154 = state_39896__$1;
(statearr_39950_40154[(1)] = (110));

} else {
var statearr_39951_40155 = state_39896__$1;
(statearr_39951_40155[(1)] = (111));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (54))){
var inst_39568 = (state_39896[(34)]);
var state_39896__$1 = state_39896;
var statearr_39952_40156 = state_39896__$1;
(statearr_39952_40156[(2)] = inst_39568);

(statearr_39952_40156[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (92))){
var inst_39705 = (state_39896[(31)]);
var state_39896__$1 = state_39896;
var statearr_39953_40157 = state_39896__$1;
(statearr_39953_40157[(2)] = inst_39705);

(statearr_39953_40157[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (104))){
var inst_39468 = (state_39896[(35)]);
var inst_39746 = (state_39896[(27)]);
var inst_39755 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298)];
var inst_39756 = [true,inst_39468];
var inst_39757 = cljs.core.PersistentHashMap.fromArrays(inst_39755,inst_39756);
var inst_39758 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_39757,inst_39746);
var state_39896__$1 = state_39896;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39896__$1,(106),inst_39758);
} else {
if((state_val_39897 === (15))){
var inst_39491 = (state_39896[(36)]);
var inst_39468 = (state_39896[(35)]);
var inst_39495 = cljs.core.assoc.call(null,inst_39491,new cljs.core.Keyword(null,"compact?","compact?",1216893298),inst_39468);
var state_39896__$1 = state_39896;
var statearr_39954_40158 = state_39896__$1;
(statearr_39954_40158[(2)] = inst_39495);

(statearr_39954_40158[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (48))){
var inst_39562 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39563 = [null,offset_map];
var inst_39564 = (new cljs.core.PersistentVector(null,2,(5),inst_39562,inst_39563,null));
var state_39896__$1 = state_39896;
var statearr_39955_40159 = state_39896__$1;
(statearr_39955_40159[(2)] = inst_39564);

(statearr_39955_40159[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (50))){
var inst_39862 = (state_39896[(2)]);
var state_39896__$1 = state_39896;
var statearr_39956_40160 = state_39896__$1;
(statearr_39956_40160[(2)] = inst_39862);

(statearr_39956_40160[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (116))){
var inst_39803 = (state_39896[(37)]);
var inst_39810 = (state_39896[(38)]);
var inst_39809 = cljs.core.seq.call(null,inst_39803);
var inst_39810__$1 = cljs.core.first.call(null,inst_39809);
var inst_39811 = cljs.core.next.call(null,inst_39809);
var state_39896__$1 = (function (){var statearr_39957 = state_39896;
(statearr_39957[(39)] = inst_39811);

(statearr_39957[(38)] = inst_39810__$1);

return statearr_39957;
})();
if(cljs.core.truth_(inst_39810__$1)){
var statearr_39958_40161 = state_39896__$1;
(statearr_39958_40161[(1)] = (118));

} else {
var statearr_39959_40162 = state_39896__$1;
(statearr_39959_40162[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (75))){
var inst_39603 = (state_39896[(25)]);
var inst_39633 = (state_39896[(2)]);
var inst_39595 = inst_39603;
var inst_39596 = inst_39633;
var state_39896__$1 = (function (){var statearr_39960 = state_39896;
(statearr_39960[(24)] = inst_39595);

(statearr_39960[(9)] = inst_39596);

return statearr_39960;
})();
var statearr_39961_40163 = state_39896__$1;
(statearr_39961_40163[(2)] = null);

(statearr_39961_40163[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (99))){
var inst_39732 = (state_39896[(40)]);
var inst_39498 = (state_39896[(14)]);
var inst_39735 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39736 = inst_39732.o;
var inst_39737 = [inst_39736];
var inst_39738 = (new cljs.core.PersistentVector(null,1,(5),inst_39735,inst_39737,null));
var inst_39739 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_39740 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_39498);
var inst_39741 = [inst_39740];
var inst_39742 = cljs.core.PersistentHashMap.fromArrays(inst_39739,inst_39741);
var inst_39743 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_39738,inst_39742);
var state_39896__$1 = state_39896;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39896__$1,(102),inst_39743);
} else {
if((state_val_39897 === (21))){
var inst_39502 = (state_39896[(41)]);
var state_39896__$1 = state_39896;
var statearr_39962_40164 = state_39896__$1;
(statearr_39962_40164[(2)] = inst_39502);

(statearr_39962_40164[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (31))){
var inst_39519 = (state_39896[(26)]);
var state_39896__$1 = state_39896;
var statearr_39963_40165 = state_39896__$1;
(statearr_39963_40165[(2)] = inst_39519);

(statearr_39963_40165[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (113))){
var inst_39509 = (state_39896[(16)]);
var inst_39510 = (state_39896[(13)]);
var inst_39514 = (state_39896[(17)]);
var inst_39515 = (state_39896[(18)]);
var inst_39498 = (state_39896[(14)]);
var inst_39512 = (state_39896[(19)]);
var inst_39513 = (state_39896[(20)]);
var inst_39511 = (state_39896[(15)]);
var inst_39468 = (state_39896[(35)]);
var inst_39516 = (state_39896[(21)]);
var inst_39483 = (state_39896[(42)]);
var inst_39785 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39786 = (function (){var p = inst_39516;
var pred_spec__$1 = inst_39483;
var orderBy = inst_39514;
var multi_QMARK_ = inst_39511;
var limit = inst_39513;
var offset = inst_39515;
var map__39464 = inst_39510;
var k = inst_39509;
var compact_QMARK_ = inst_39468;
var pred_spec_SINGLEQUOTE_ = inst_39498;
var ref_QMARK_ = inst_39512;
return (function (p1__39454_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"_id","_id",-789960287)],[p1__39454_SHARP_.o]);
});
})();
var inst_39787 = cljs.core.mapv.call(null,inst_39786,flakes);
var inst_39788 = [inst_39787,offset_map];
var inst_39789 = (new cljs.core.PersistentVector(null,2,(5),inst_39785,inst_39788,null));
var state_39896__$1 = state_39896;
var statearr_39964_40166 = state_39896__$1;
(statearr_39964_40166[(2)] = inst_39789);

(statearr_39964_40166[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (32))){
var inst_39525 = (state_39896[(2)]);
var state_39896__$1 = state_39896;
var statearr_39965_40167 = state_39896__$1;
(statearr_39965_40167[(2)] = inst_39525);

(statearr_39965_40167[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (136))){
var inst_39887 = (state_39896[(2)]);
var state_39896__$1 = state_39896;
var statearr_39966_40168 = state_39896__$1;
(statearr_39966_40168[(2)] = inst_39887);

(statearr_39966_40168[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (40))){
var inst_39511 = (state_39896[(15)]);
var state_39896__$1 = state_39896;
var statearr_39967_40169 = state_39896__$1;
(statearr_39967_40169[(2)] = inst_39511);

(statearr_39967_40169[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (129))){
var inst_39511 = (state_39896[(15)]);
var state_39896__$1 = state_39896;
if(cljs.core.truth_(inst_39511)){
var statearr_39968_40170 = state_39896__$1;
(statearr_39968_40170[(1)] = (131));

} else {
var statearr_39969_40171 = state_39896__$1;
(statearr_39969_40171[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (91))){
var inst_39498 = (state_39896[(14)]);
var inst_39707 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_39498);
var state_39896__$1 = state_39896;
var statearr_39970_40172 = state_39896__$1;
(statearr_39970_40172[(2)] = inst_39707);

(statearr_39970_40172[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (117))){
var inst_39840 = (state_39896[(2)]);
var state_39896__$1 = state_39896;
var statearr_39971_40173 = state_39896__$1;
(statearr_39971_40173[(2)] = inst_39840);

(statearr_39971_40173[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (108))){
var state_39896__$1 = state_39896;
var statearr_39972_40174 = state_39896__$1;
(statearr_39972_40174[(2)] = null);

(statearr_39972_40174[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (56))){
var inst_39573 = (state_39896[(2)]);
var state_39896__$1 = state_39896;
var statearr_39973_40175 = state_39896__$1;
(statearr_39973_40175[(2)] = inst_39573);

(statearr_39973_40175[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (33))){
var inst_39516 = (state_39896[(21)]);
var inst_39533 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39534 = cljs.core.get.call(null,offset_map,inst_39516);
var state_39896__$1 = (function (){var statearr_39974 = state_39896;
(statearr_39974[(43)] = inst_39533);

return statearr_39974;
})();
if(cljs.core.truth_(inst_39534)){
var statearr_39975_40176 = state_39896__$1;
(statearr_39975_40176[(1)] = (36));

} else {
var statearr_39976_40177 = state_39896__$1;
(statearr_39976_40177[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (13))){
var inst_39483 = (state_39896[(42)]);
var state_39896__$1 = state_39896;
var statearr_39977_40178 = state_39896__$1;
(statearr_39977_40178[(2)] = inst_39483);

(statearr_39977_40178[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (22))){
var inst_39498 = (state_39896[(14)]);
var inst_39505 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_39498);
var state_39896__$1 = state_39896;
var statearr_39978_40179 = state_39896__$1;
(statearr_39978_40179[(2)] = inst_39505);

(statearr_39978_40179[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (90))){
var inst_39666 = (state_39896[(44)]);
var inst_39695 = (state_39896[(2)]);
var inst_39658 = inst_39666;
var inst_39659 = inst_39695;
var state_39896__$1 = (function (){var statearr_39979 = state_39896;
(statearr_39979[(45)] = inst_39658);

(statearr_39979[(30)] = inst_39659);

return statearr_39979;
})();
var statearr_39980_40180 = state_39896__$1;
(statearr_39980_40180[(2)] = null);

(statearr_39980_40180[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (109))){
var inst_39733 = (state_39896[(46)]);
var inst_39764 = (state_39896[(47)]);
var inst_39770 = (state_39896[(2)]);
var inst_39725 = inst_39733;
var inst_39726 = inst_39764;
var state_39896__$1 = (function (){var statearr_39981 = state_39896;
(statearr_39981[(48)] = inst_39725);

(statearr_39981[(49)] = inst_39770);

(statearr_39981[(32)] = inst_39726);

return statearr_39981;
})();
var statearr_39982_40181 = state_39896__$1;
(statearr_39982_40181[(2)] = null);

(statearr_39982_40181[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (36))){
var inst_39516 = (state_39896[(21)]);
var inst_39536 = cljs.core.update.call(null,offset_map,inst_39516,cljs.core.dec);
var state_39896__$1 = state_39896;
var statearr_39983_40182 = state_39896__$1;
(statearr_39983_40182[(2)] = inst_39536);

(statearr_39983_40182[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (41))){
var inst_39560 = (state_39896[(2)]);
var state_39896__$1 = state_39896;
if(cljs.core.truth_(inst_39560)){
var statearr_39984_40183 = state_39896__$1;
(statearr_39984_40183[(1)] = (48));

} else {
var statearr_39985_40184 = state_39896__$1;
(statearr_39985_40184[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (118))){
var inst_39810 = (state_39896[(38)]);
var inst_39813 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39814 = inst_39810.o;
var inst_39815 = [inst_39814];
var inst_39816 = (new cljs.core.PersistentVector(null,1,(5),inst_39813,inst_39815,null));
var inst_39817 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_39816);
var state_39896__$1 = state_39896;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39896__$1,(121),inst_39817);
} else {
if((state_val_39897 === (89))){
var inst_39659 = (state_39896[(30)]);
var state_39896__$1 = state_39896;
var statearr_39986_40185 = state_39896__$1;
(statearr_39986_40185[(2)] = inst_39659);

(statearr_39986_40185[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (100))){
var inst_39726 = (state_39896[(32)]);
var state_39896__$1 = state_39896;
var statearr_39987_40186 = state_39896__$1;
(statearr_39987_40186[(2)] = inst_39726);

(statearr_39987_40186[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (131))){
var inst_39509 = (state_39896[(16)]);
var inst_39865 = (state_39896[(50)]);
var inst_39866 = (state_39896[(10)]);
var inst_39874 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39875 = cljs.core.assoc.call(null,acc,inst_39509,inst_39865);
var inst_39876 = [inst_39875,inst_39866];
var inst_39877 = (new cljs.core.PersistentVector(null,2,(5),inst_39874,inst_39876,null));
var state_39896__$1 = state_39896;
var statearr_39988_40187 = state_39896__$1;
(statearr_39988_40187[(2)] = inst_39877);

(statearr_39988_40187[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (122))){
var inst_39811 = (state_39896[(39)]);
var inst_39804 = (state_39896[(33)]);
var inst_39810 = (state_39896[(38)]);
var inst_39823 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_39824 = inst_39810.o;
var inst_39825 = [inst_39824];
var inst_39826 = cljs.core.PersistentHashMap.fromArrays(inst_39823,inst_39825);
var inst_39827 = cljs.core.conj.call(null,inst_39804,inst_39826);
var inst_39803 = inst_39811;
var inst_39804__$1 = inst_39827;
var state_39896__$1 = (function (){var statearr_39989 = state_39896;
(statearr_39989[(37)] = inst_39803);

(statearr_39989[(33)] = inst_39804__$1);

return statearr_39989;
})();
var statearr_39990_40188 = state_39896__$1;
(statearr_39990_40188[(2)] = null);

(statearr_39990_40188[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (43))){
var inst_39546 = (state_39896[(29)]);
var state_39896__$1 = state_39896;
var statearr_39991_40189 = state_39896__$1;
(statearr_39991_40189[(2)] = inst_39546);

(statearr_39991_40189[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (61))){
var inst_39582 = (state_39896[(51)]);
var inst_39639 = (state_39896[(2)]);
var inst_39640 = [inst_39639,offset_map];
var inst_39641 = (new cljs.core.PersistentVector(null,2,(5),inst_39582,inst_39640,null));
var state_39896__$1 = state_39896;
var statearr_39992_40190 = state_39896__$1;
(statearr_39992_40190[(2)] = inst_39641);

(statearr_39992_40190[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (29))){
var inst_39528 = (state_39896[(2)]);
var state_39896__$1 = state_39896;
var statearr_39993_40191 = state_39896__$1;
(statearr_39993_40191[(2)] = inst_39528);

(statearr_39993_40191[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (44))){
var inst_39557 = (state_39896[(2)]);
var state_39896__$1 = state_39896;
var statearr_39994_40192 = state_39896__$1;
(statearr_39994_40192[(2)] = inst_39557);

(statearr_39994_40192[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (93))){
var inst_39710 = (state_39896[(2)]);
var state_39896__$1 = state_39896;
if(cljs.core.truth_(inst_39710)){
var statearr_39995_40193 = state_39896__$1;
(statearr_39995_40193[(1)] = (94));

} else {
var statearr_39996_40194 = state_39896__$1;
(statearr_39996_40194[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (6))){
var inst_39471 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_39472 = (inst_39471 == null);
var state_39896__$1 = state_39896;
var statearr_39997_40195 = state_39896__$1;
(statearr_39997_40195[(2)] = inst_39472);

(statearr_39997_40195[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (111))){
var state_39896__$1 = state_39896;
var statearr_39998_40196 = state_39896__$1;
(statearr_39998_40196[(1)] = (125));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (28))){
var inst_39515 = (state_39896[(18)]);
var state_39896__$1 = state_39896;
var statearr_40000_40197 = state_39896__$1;
(statearr_40000_40197[(2)] = inst_39515);

(statearr_40000_40197[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (134))){
var inst_39509 = (state_39896[(16)]);
var inst_39865 = (state_39896[(50)]);
var inst_39866 = (state_39896[(10)]);
var inst_39880 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39881 = cljs.core.first.call(null,inst_39865);
var inst_39882 = cljs.core.assoc.call(null,acc,inst_39509,inst_39881);
var inst_39883 = [inst_39882,inst_39866];
var inst_39884 = (new cljs.core.PersistentVector(null,2,(5),inst_39880,inst_39883,null));
var state_39896__$1 = state_39896;
var statearr_40001_40198 = state_39896__$1;
(statearr_40001_40198[(2)] = inst_39884);

(statearr_40001_40198[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (64))){
var inst_39637 = (state_39896[(2)]);
var state_39896__$1 = state_39896;
var statearr_40002_40199 = state_39896__$1;
(statearr_40002_40199[(2)] = inst_39637);

(statearr_40002_40199[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (103))){
var inst_39732 = (state_39896[(40)]);
var inst_39726 = (state_39896[(32)]);
var inst_39749 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_39750 = inst_39732.o;
var inst_39751 = [inst_39750];
var inst_39752 = cljs.core.PersistentHashMap.fromArrays(inst_39749,inst_39751);
var inst_39753 = cljs.core.conj.call(null,inst_39726,inst_39752);
var state_39896__$1 = state_39896;
var statearr_40003_40200 = state_39896__$1;
(statearr_40003_40200[(2)] = inst_39753);

(statearr_40003_40200[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (51))){
var inst_39498 = (state_39896[(14)]);
var inst_39568 = (state_39896[(34)]);
var inst_39568__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_39498);
var state_39896__$1 = (function (){var statearr_40004 = state_39896;
(statearr_40004[(34)] = inst_39568__$1);

return statearr_40004;
})();
if(cljs.core.truth_(inst_39568__$1)){
var statearr_40005_40201 = state_39896__$1;
(statearr_40005_40201[(1)] = (54));

} else {
var statearr_40006_40202 = state_39896__$1;
(statearr_40006_40202[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (25))){
var inst_39511 = (state_39896[(15)]);
var state_39896__$1 = state_39896;
var statearr_40007_40203 = state_39896__$1;
(statearr_40007_40203[(2)] = inst_39511);

(statearr_40007_40203[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (34))){
var inst_39511 = (state_39896[(15)]);
var state_39896__$1 = state_39896;
if(cljs.core.truth_(inst_39511)){
var statearr_40008_40204 = state_39896__$1;
(statearr_40008_40204[(1)] = (39));

} else {
var statearr_40009_40205 = state_39896__$1;
(statearr_40009_40205[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (125))){
var inst_39509 = (state_39896[(16)]);
var inst_39510 = (state_39896[(13)]);
var inst_39514 = (state_39896[(17)]);
var inst_39515 = (state_39896[(18)]);
var inst_39498 = (state_39896[(14)]);
var inst_39512 = (state_39896[(19)]);
var inst_39513 = (state_39896[(20)]);
var inst_39511 = (state_39896[(15)]);
var inst_39468 = (state_39896[(35)]);
var inst_39516 = (state_39896[(21)]);
var inst_39483 = (state_39896[(42)]);
var inst_39845 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39846 = (function (){var p = inst_39516;
var pred_spec__$1 = inst_39483;
var orderBy = inst_39514;
var multi_QMARK_ = inst_39511;
var limit = inst_39513;
var offset = inst_39515;
var map__39464 = inst_39510;
var k = inst_39509;
var compact_QMARK_ = inst_39468;
var pred_spec_SINGLEQUOTE_ = inst_39498;
var ref_QMARK_ = inst_39512;
return (function (p1__39455_SHARP_){
return p1__39455_SHARP_.o;
});
})();
var inst_39847 = cljs.core.mapv.call(null,inst_39846,flakes);
var inst_39848 = [inst_39847,offset_map];
var inst_39849 = (new cljs.core.PersistentVector(null,2,(5),inst_39845,inst_39848,null));
var state_39896__$1 = state_39896;
var statearr_40010_40206 = state_39896__$1;
(statearr_40010_40206[(2)] = inst_39849);

(statearr_40010_40206[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (17))){
var inst_39499 = (state_39896[(52)]);
var inst_39498 = (state_39896[(14)]);
var inst_39498__$1 = (state_39896[(2)]);
var inst_39499__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_39498__$1);
var state_39896__$1 = (function (){var statearr_40011 = state_39896;
(statearr_40011[(52)] = inst_39499__$1);

(statearr_40011[(14)] = inst_39498__$1);

return statearr_40011;
})();
if(cljs.core.truth_(inst_39499__$1)){
var statearr_40012_40207 = state_39896__$1;
(statearr_40012_40207[(1)] = (18));

} else {
var statearr_40013_40208 = state_39896__$1;
(statearr_40013_40208[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (3))){
var inst_39894 = (state_39896[(2)]);
var state_39896__$1 = state_39896;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39896__$1,inst_39894);
} else {
if((state_val_39897 === (12))){
var inst_39483 = (state_39896[(42)]);
var inst_39488 = cljs.core.assoc.call(null,inst_39483,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_39896__$1 = state_39896;
var statearr_40014_40209 = state_39896__$1;
(statearr_40014_40209[(2)] = inst_39488);

(statearr_40014_40209[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (2))){
var inst_39469 = (state_39896[(11)]);
var _ = (function (){var statearr_40015 = state_39896;
(statearr_40015[(4)] = cljs.core.cons.call(null,(5),(state_39896[(4)])));

return statearr_40015;
})();
var inst_39468 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_39469__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_39896__$1 = (function (){var statearr_40016 = state_39896;
(statearr_40016[(11)] = inst_39469__$1);

(statearr_40016[(35)] = inst_39468);

return statearr_40016;
})();
if(cljs.core.truth_(inst_39469__$1)){
var statearr_40017_40210 = state_39896__$1;
(statearr_40017_40210[(1)] = (6));

} else {
var statearr_40018_40211 = state_39896__$1;
(statearr_40018_40211[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (66))){
var inst_39581 = (state_39896[(53)]);
var inst_39612 = (state_39896[(7)]);
var inst_39615 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_39581,inst_39612);
var state_39896__$1 = state_39896;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39896__$1,(69),inst_39615);
} else {
if((state_val_39897 === (107))){
var inst_39746 = (state_39896[(27)]);
var inst_39766 = cljs.core.count.call(null,inst_39746);
var inst_39767 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_39766);
var state_39896__$1 = state_39896;
var statearr_40019_40212 = state_39896__$1;
(statearr_40019_40212[(2)] = inst_39767);

(statearr_40019_40212[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (23))){
var inst_39507 = (state_39896[(2)]);
var state_39896__$1 = state_39896;
var statearr_40020_40213 = state_39896__$1;
(statearr_40020_40213[(2)] = inst_39507);

(statearr_40020_40213[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (47))){
var inst_39554 = (state_39896[(2)]);
var state_39896__$1 = state_39896;
var statearr_40021_40214 = state_39896__$1;
(statearr_40021_40214[(2)] = inst_39554);

(statearr_40021_40214[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (35))){
var inst_39865 = (state_39896[(50)]);
var inst_39864 = (state_39896[(2)]);
var inst_39865__$1 = cljs.core.nth.call(null,inst_39864,(0),null);
var inst_39866 = cljs.core.nth.call(null,inst_39864,(1),null);
var inst_39867 = cljs.core.empty_QMARK_.call(null,inst_39865__$1);
var state_39896__$1 = (function (){var statearr_40022 = state_39896;
(statearr_40022[(50)] = inst_39865__$1);

(statearr_40022[(10)] = inst_39866);

return statearr_40022;
})();
if(inst_39867){
var statearr_40023_40215 = state_39896__$1;
(statearr_40023_40215[(1)] = (128));

} else {
var statearr_40024_40216 = state_39896__$1;
(statearr_40024_40216[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (127))){
var inst_39852 = (state_39896[(2)]);
var state_39896__$1 = state_39896;
var statearr_40025_40217 = state_39896__$1;
(statearr_40025_40217[(2)] = inst_39852);

(statearr_40025_40217[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (82))){
var inst_39659 = (state_39896[(30)]);
var state_39896__$1 = state_39896;
var statearr_40026_40218 = state_39896__$1;
(statearr_40026_40218[(2)] = inst_39659);

(statearr_40026_40218[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (76))){
var inst_39645 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39653 = flakes;
var inst_39654 = cljs.core.seq.call(null,inst_39653);
var inst_39655 = cljs.core.first.call(null,inst_39654);
var inst_39656 = cljs.core.next.call(null,inst_39654);
var inst_39657 = cljs.core.PersistentVector.EMPTY;
var inst_39658 = inst_39653;
var inst_39659 = inst_39657;
var state_39896__$1 = (function (){var statearr_40027 = state_39896;
(statearr_40027[(54)] = inst_39656);

(statearr_40027[(55)] = inst_39645);

(statearr_40027[(56)] = inst_39655);

(statearr_40027[(45)] = inst_39658);

(statearr_40027[(30)] = inst_39659);

return statearr_40027;
})();
var statearr_40028_40219 = state_39896__$1;
(statearr_40028_40219[(2)] = null);

(statearr_40028_40219[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (97))){
var inst_39725 = (state_39896[(48)]);
var inst_39732 = (state_39896[(40)]);
var inst_39731 = cljs.core.seq.call(null,inst_39725);
var inst_39732__$1 = cljs.core.first.call(null,inst_39731);
var inst_39733 = cljs.core.next.call(null,inst_39731);
var state_39896__$1 = (function (){var statearr_40029 = state_39896;
(statearr_40029[(46)] = inst_39733);

(statearr_40029[(40)] = inst_39732__$1);

return statearr_40029;
})();
if(cljs.core.truth_(inst_39732__$1)){
var statearr_40030_40220 = state_39896__$1;
(statearr_40030_40220[(1)] = (99));

} else {
var statearr_40031_40221 = state_39896__$1;
(statearr_40031_40221[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (19))){
var inst_39498 = (state_39896[(14)]);
var inst_39502 = (state_39896[(41)]);
var inst_39502__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_39498);
var state_39896__$1 = (function (){var statearr_40032 = state_39896;
(statearr_40032[(41)] = inst_39502__$1);

return statearr_40032;
})();
if(cljs.core.truth_(inst_39502__$1)){
var statearr_40033_40222 = state_39896__$1;
(statearr_40033_40222[(1)] = (21));

} else {
var statearr_40034_40223 = state_39896__$1;
(statearr_40034_40223[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (57))){
var inst_39498 = (state_39896[(14)]);
var inst_39578 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39579 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_39580 = (new cljs.core.PersistentVector(null,3,(5),inst_39578,inst_39579,null));
var inst_39581 = cljs.core.select_keys.call(null,inst_39498,inst_39580);
var inst_39582 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39590 = flakes;
var inst_39591 = cljs.core.seq.call(null,inst_39590);
var inst_39592 = cljs.core.first.call(null,inst_39591);
var inst_39593 = cljs.core.next.call(null,inst_39591);
var inst_39594 = cljs.core.PersistentVector.EMPTY;
var inst_39595 = inst_39590;
var inst_39596 = inst_39594;
var state_39896__$1 = (function (){var statearr_40035 = state_39896;
(statearr_40035[(57)] = inst_39592);

(statearr_40035[(53)] = inst_39581);

(statearr_40035[(24)] = inst_39595);

(statearr_40035[(58)] = inst_39593);

(statearr_40035[(51)] = inst_39582);

(statearr_40035[(9)] = inst_39596);

return statearr_40035;
})();
var statearr_40036_40224 = state_39896__$1;
(statearr_40036_40224[(2)] = null);

(statearr_40036_40224[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (68))){
var inst_39621 = (state_39896[(2)]);
var state_39896__$1 = (function (){var statearr_40037 = state_39896;
(statearr_40037[(22)] = inst_39621);

return statearr_40037;
})();
if(cljs.core.truth_(fuel)){
var statearr_40038_40225 = state_39896__$1;
(statearr_40038_40225[(1)] = (70));

} else {
var statearr_40039_40226 = state_39896__$1;
(statearr_40039_40226[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (11))){
var inst_39483 = (state_39896[(42)]);
var inst_39483__$1 = (state_39896[(2)]);
var inst_39485 = cljs.core.contains_QMARK_.call(null,inst_39483__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var inst_39486 = (!(inst_39485));
var state_39896__$1 = (function (){var statearr_40040 = state_39896;
(statearr_40040[(42)] = inst_39483__$1);

return statearr_40040;
})();
if(inst_39486){
var statearr_40041_40227 = state_39896__$1;
(statearr_40041_40227[(1)] = (12));

} else {
var statearr_40042_40228 = state_39896__$1;
(statearr_40042_40228[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (115))){
var inst_39842 = (state_39896[(2)]);
var state_39896__$1 = state_39896;
var statearr_40044_40229 = state_39896__$1;
(statearr_40044_40229[(2)] = inst_39842);

(statearr_40044_40229[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (9))){
var inst_39477 = cljs.core.first.call(null,flakes);
var inst_39478 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_39477);
var inst_39479 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_39480 = fluree.db.query.fql.wildcard_pred_spec.call(null,db,cache,inst_39478,inst_39479);
var state_39896__$1 = state_39896;
var statearr_40045_40230 = state_39896__$1;
(statearr_40045_40230[(2)] = inst_39480);

(statearr_40045_40230[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (5))){
var _ = (function (){var statearr_40046 = state_39896;
(statearr_40046[(4)] = cljs.core.rest.call(null,(state_39896[(4)])));

return statearr_40046;
})();
var state_39896__$1 = state_39896;
var ex40043 = (state_39896__$1[(2)]);
var statearr_40047_40231 = state_39896__$1;
(statearr_40047_40231[(5)] = ex40043);


if((ex40043 instanceof Error)){
var statearr_40048_40232 = state_39896__$1;
(statearr_40048_40232[(1)] = (4));

(statearr_40048_40232[(5)] = null);

} else {
throw ex40043;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (112))){
var inst_39854 = (state_39896[(2)]);
var state_39896__$1 = state_39896;
var statearr_40049_40233 = state_39896__$1;
(statearr_40049_40233[(2)] = inst_39854);

(statearr_40049_40233[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (83))){
var inst_39699 = (state_39896[(2)]);
var state_39896__$1 = state_39896;
var statearr_40050_40234 = state_39896__$1;
(statearr_40050_40234[(2)] = inst_39699);

(statearr_40050_40234[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (14))){
var inst_39483 = (state_39896[(42)]);
var inst_39491 = (state_39896[(2)]);
var inst_39492 = cljs.core.contains_QMARK_.call(null,inst_39483,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var inst_39493 = (!(inst_39492));
var state_39896__$1 = (function (){var statearr_40051 = state_39896;
(statearr_40051[(36)] = inst_39491);

return statearr_40051;
})();
if(inst_39493){
var statearr_40052_40235 = state_39896__$1;
(statearr_40052_40235[(1)] = (15));

} else {
var statearr_40053_40236 = state_39896__$1;
(statearr_40053_40236[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (45))){
var inst_39509 = (state_39896[(16)]);
var inst_39513 = (state_39896[(20)]);
var inst_39549 = cljs.core.get.call(null,acc,inst_39509);
var inst_39550 = cljs.core.count.call(null,inst_39549);
var inst_39551 = (inst_39550 >= inst_39513);
var state_39896__$1 = state_39896;
var statearr_40054_40237 = state_39896__$1;
(statearr_40054_40237[(2)] = inst_39551);

(statearr_40054_40237[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (53))){
var inst_39576 = (state_39896[(2)]);
var state_39896__$1 = state_39896;
if(cljs.core.truth_(inst_39576)){
var statearr_40055_40238 = state_39896__$1;
(statearr_40055_40238[(1)] = (57));

} else {
var statearr_40056_40239 = state_39896__$1;
(statearr_40056_40239[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (78))){
var inst_39858 = (state_39896[(2)]);
var state_39896__$1 = state_39896;
var statearr_40057_40240 = state_39896__$1;
(statearr_40057_40240[(2)] = inst_39858);

(statearr_40057_40240[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (132))){
var state_39896__$1 = state_39896;
var statearr_40059_40241 = state_39896__$1;
(statearr_40059_40241[(1)] = (134));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (26))){
var inst_39531 = (state_39896[(2)]);
var state_39896__$1 = state_39896;
if(cljs.core.truth_(inst_39531)){
var statearr_40061_40242 = state_39896__$1;
(statearr_40061_40242[(1)] = (33));

} else {
var statearr_40062_40243 = state_39896__$1;
(statearr_40062_40243[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (123))){
var inst_39811 = (state_39896[(39)]);
var inst_39804 = (state_39896[(33)]);
var tmp40058 = inst_39804;
var inst_39803 = inst_39811;
var inst_39804__$1 = tmp40058;
var state_39896__$1 = (function (){var statearr_40063 = state_39896;
(statearr_40063[(37)] = inst_39803);

(statearr_40063[(33)] = inst_39804__$1);

return statearr_40063;
})();
var statearr_40064_40244 = state_39896__$1;
(statearr_40064_40244[(2)] = null);

(statearr_40064_40244[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (16))){
var inst_39491 = (state_39896[(36)]);
var state_39896__$1 = state_39896;
var statearr_40065_40245 = state_39896__$1;
(statearr_40065_40245[(2)] = inst_39491);

(statearr_40065_40245[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (133))){
var inst_39889 = (state_39896[(2)]);
var state_39896__$1 = state_39896;
var statearr_40066_40246 = state_39896__$1;
(statearr_40066_40246[(2)] = inst_39889);

(statearr_40066_40246[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (81))){
var inst_39665 = (state_39896[(28)]);
var inst_39674 = (state_39896[(59)]);
var inst_39498 = (state_39896[(14)]);
var inst_39668 = cljs.core.deref.call(null,cache);
var inst_39669 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39670 = inst_39665.o;
var inst_39671 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_39498);
var inst_39672 = [inst_39670,inst_39671];
var inst_39673 = (new cljs.core.PersistentVector(null,2,(5),inst_39669,inst_39672,null));
var inst_39674__$1 = cljs.core.get.call(null,inst_39668,inst_39673);
var state_39896__$1 = (function (){var statearr_40067 = state_39896;
(statearr_40067[(59)] = inst_39674__$1);

return statearr_40067;
})();
if(cljs.core.truth_(inst_39674__$1)){
var statearr_40068_40247 = state_39896__$1;
(statearr_40068_40247[(1)] = (84));

} else {
var statearr_40069_40248 = state_39896__$1;
(statearr_40069_40248[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (120))){
var inst_39838 = (state_39896[(2)]);
var state_39896__$1 = state_39896;
var statearr_40070_40249 = state_39896__$1;
(statearr_40070_40249[(2)] = inst_39838);

(statearr_40070_40249[(1)] = (117));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (79))){
var inst_39665 = (state_39896[(28)]);
var inst_39658 = (state_39896[(45)]);
var inst_39664 = cljs.core.seq.call(null,inst_39658);
var inst_39665__$1 = cljs.core.first.call(null,inst_39664);
var inst_39666 = cljs.core.next.call(null,inst_39664);
var state_39896__$1 = (function (){var statearr_40071 = state_39896;
(statearr_40071[(28)] = inst_39665__$1);

(statearr_40071[(44)] = inst_39666);

return statearr_40071;
})();
if(cljs.core.truth_(inst_39665__$1)){
var statearr_40072_40250 = state_39896__$1;
(statearr_40072_40250[(1)] = (81));

} else {
var statearr_40073_40251 = state_39896__$1;
(statearr_40073_40251[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (38))){
var inst_39533 = (state_39896[(43)]);
var inst_39541 = (state_39896[(2)]);
var inst_39542 = [null,inst_39541];
var inst_39543 = (new cljs.core.PersistentVector(null,2,(5),inst_39533,inst_39542,null));
var state_39896__$1 = state_39896;
var statearr_40074_40252 = state_39896__$1;
(statearr_40074_40252[(2)] = inst_39543);

(statearr_40074_40252[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (126))){
var state_39896__$1 = state_39896;
var statearr_40075_40253 = state_39896__$1;
(statearr_40075_40253[(2)] = null);

(statearr_40075_40253[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (98))){
var inst_39712 = (state_39896[(60)]);
var inst_39776 = (state_39896[(2)]);
var inst_39777 = [inst_39776,offset_map];
var inst_39778 = (new cljs.core.PersistentVector(null,2,(5),inst_39712,inst_39777,null));
var state_39896__$1 = state_39896;
var statearr_40076_40254 = state_39896__$1;
(statearr_40076_40254[(2)] = inst_39778);

(statearr_40076_40254[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (124))){
var inst_39832 = (state_39896[(2)]);
var state_39896__$1 = state_39896;
var statearr_40077_40255 = state_39896__$1;
(statearr_40077_40255[(2)] = inst_39832);

(statearr_40077_40255[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (87))){
var inst_39665 = (state_39896[(28)]);
var inst_39498 = (state_39896[(14)]);
var inst_39681 = (state_39896[(2)]);
var inst_39682 = fluree.db.util.async.throw_err.call(null,inst_39681);
var inst_39683 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39684 = inst_39665.o;
var inst_39685 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_39498);
var inst_39686 = [inst_39684,inst_39685];
var inst_39687 = (new cljs.core.PersistentVector(null,2,(5),inst_39683,inst_39686,null));
var inst_39688 = fluree.db.query.fql.vswap_BANG_.call(null,cache,cljs.core.assoc,inst_39687,inst_39682);
var state_39896__$1 = (function (){var statearr_40078 = state_39896;
(statearr_40078[(61)] = inst_39688);

return statearr_40078;
})();
var statearr_40079_40256 = state_39896__$1;
(statearr_40079_40256[(2)] = inst_39682);

(statearr_40079_40256[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (30))){
var inst_39516 = (state_39896[(21)]);
var inst_39521 = cljs.core.get.call(null,offset_map,inst_39516);
var inst_39522 = cljs.core.not_EQ_.call(null,(0),inst_39521);
var state_39896__$1 = state_39896;
var statearr_40080_40257 = state_39896__$1;
(statearr_40080_40257[(2)] = inst_39522);

(statearr_40080_40257[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (73))){
var inst_39621 = (state_39896[(22)]);
var inst_39596 = (state_39896[(9)]);
var inst_39630 = cljs.core.conj.call(null,inst_39596,inst_39621);
var state_39896__$1 = state_39896;
var statearr_40081_40258 = state_39896__$1;
(statearr_40081_40258[(2)] = inst_39630);

(statearr_40081_40258[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (96))){
var inst_39856 = (state_39896[(2)]);
var state_39896__$1 = state_39896;
var statearr_40082_40259 = state_39896__$1;
(statearr_40082_40259[(2)] = inst_39856);

(statearr_40082_40259[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (10))){
var state_39896__$1 = state_39896;
var statearr_40083_40260 = state_39896__$1;
(statearr_40083_40260[(2)] = pred_spec);

(statearr_40083_40260[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (18))){
var inst_39499 = (state_39896[(52)]);
var state_39896__$1 = state_39896;
var statearr_40084_40261 = state_39896__$1;
(statearr_40084_40261[(2)] = inst_39499);

(statearr_40084_40261[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (105))){
var inst_39764 = (state_39896[(2)]);
var state_39896__$1 = (function (){var statearr_40085 = state_39896;
(statearr_40085[(47)] = inst_39764);

return statearr_40085;
})();
if(cljs.core.truth_(fuel)){
var statearr_40086_40262 = state_39896__$1;
(statearr_40086_40262[(1)] = (107));

} else {
var statearr_40087_40263 = state_39896__$1;
(statearr_40087_40263[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (52))){
var inst_39566 = (state_39896[(62)]);
var state_39896__$1 = state_39896;
var statearr_40088_40264 = state_39896__$1;
(statearr_40088_40264[(2)] = inst_39566);

(statearr_40088_40264[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (114))){
var inst_39798 = flakes;
var inst_39799 = cljs.core.seq.call(null,inst_39798);
var inst_39800 = cljs.core.first.call(null,inst_39799);
var inst_39801 = cljs.core.next.call(null,inst_39799);
var inst_39802 = cljs.core.PersistentVector.EMPTY;
var inst_39803 = inst_39798;
var inst_39804 = inst_39802;
var state_39896__$1 = (function (){var statearr_40089 = state_39896;
(statearr_40089[(37)] = inst_39803);

(statearr_40089[(33)] = inst_39804);

(statearr_40089[(63)] = inst_39801);

(statearr_40089[(64)] = inst_39800);

return statearr_40089;
})();
var statearr_40090_40265 = state_39896__$1;
(statearr_40090_40265[(2)] = null);

(statearr_40090_40265[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (67))){
var state_39896__$1 = state_39896;
var statearr_40091_40266 = state_39896__$1;
(statearr_40091_40266[(2)] = null);

(statearr_40091_40266[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (71))){
var state_39896__$1 = state_39896;
var statearr_40092_40267 = state_39896__$1;
(statearr_40092_40267[(2)] = null);

(statearr_40092_40267[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (42))){
var inst_39513 = (state_39896[(20)]);
var state_39896__$1 = state_39896;
if(cljs.core.truth_(inst_39513)){
var statearr_40093_40268 = state_39896__$1;
(statearr_40093_40268[(1)] = (45));

} else {
var statearr_40094_40269 = state_39896__$1;
(statearr_40094_40269[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (80))){
var inst_39645 = (state_39896[(55)]);
var inst_39701 = (state_39896[(2)]);
var inst_39702 = [inst_39701,offset_map];
var inst_39703 = (new cljs.core.PersistentVector(null,2,(5),inst_39645,inst_39702,null));
var state_39896__$1 = state_39896;
var statearr_40095_40270 = state_39896__$1;
(statearr_40095_40270[(2)] = inst_39703);

(statearr_40095_40270[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (37))){
var inst_39515 = (state_39896[(18)]);
var inst_39516 = (state_39896[(21)]);
var inst_39538 = (inst_39515 - (1));
var inst_39539 = cljs.core.assoc.call(null,offset_map,inst_39516,inst_39538);
var state_39896__$1 = state_39896;
var statearr_40096_40271 = state_39896__$1;
(statearr_40096_40271[(2)] = inst_39539);

(statearr_40096_40271[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (63))){
var inst_39596 = (state_39896[(9)]);
var state_39896__$1 = state_39896;
var statearr_40097_40272 = state_39896__$1;
(statearr_40097_40272[(2)] = inst_39596);

(statearr_40097_40272[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (94))){
var inst_39712 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39720 = flakes;
var inst_39721 = cljs.core.seq.call(null,inst_39720);
var inst_39722 = cljs.core.first.call(null,inst_39721);
var inst_39723 = cljs.core.next.call(null,inst_39721);
var inst_39724 = cljs.core.PersistentVector.EMPTY;
var inst_39725 = inst_39720;
var inst_39726 = inst_39724;
var state_39896__$1 = (function (){var statearr_40098 = state_39896;
(statearr_40098[(65)] = inst_39722);

(statearr_40098[(48)] = inst_39725);

(statearr_40098[(60)] = inst_39712);

(statearr_40098[(32)] = inst_39726);

(statearr_40098[(66)] = inst_39723);

return statearr_40098;
})();
var statearr_40099_40273 = state_39896__$1;
(statearr_40099_40273[(2)] = null);

(statearr_40099_40273[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (8))){
var inst_39475 = (state_39896[(2)]);
var state_39896__$1 = state_39896;
if(cljs.core.truth_(inst_39475)){
var statearr_40100_40274 = state_39896__$1;
(statearr_40100_40274[(1)] = (9));

} else {
var statearr_40101_40275 = state_39896__$1;
(statearr_40101_40275[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (49))){
var inst_39566 = (state_39896[(62)]);
var inst_39566__$1 = cljs.core.not.call(null,recur_QMARK_);
var state_39896__$1 = (function (){var statearr_40102 = state_39896;
(statearr_40102[(62)] = inst_39566__$1);

return statearr_40102;
})();
if(inst_39566__$1){
var statearr_40103_40276 = state_39896__$1;
(statearr_40103_40276[(1)] = (51));

} else {
var statearr_40104_40277 = state_39896__$1;
(statearr_40104_40277[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39897 === (84))){
var inst_39674 = (state_39896[(59)]);
var state_39896__$1 = state_39896;
var statearr_40105_40278 = state_39896__$1;
(statearr_40105_40278[(2)] = inst_39674);

(statearr_40105_40278[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16221__auto__ = null;
var fluree$db$query$fql$state_machine__16221__auto____0 = (function (){
var statearr_40106 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40106[(0)] = fluree$db$query$fql$state_machine__16221__auto__);

(statearr_40106[(1)] = (1));

return statearr_40106;
});
var fluree$db$query$fql$state_machine__16221__auto____1 = (function (state_39896){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_39896);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e40107){var ex__16224__auto__ = e40107;
var statearr_40108_40279 = state_39896;
(statearr_40108_40279[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_39896[(4)]))){
var statearr_40109_40280 = state_39896;
(statearr_40109_40280[(1)] = cljs.core.first.call(null,(state_39896[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40281 = state_39896;
state_39896 = G__40281;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16221__auto__ = function(state_39896){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16221__auto____1.call(this,state_39896);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16221__auto____0;
fluree$db$query$fql$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16221__auto____1;
return fluree$db$query$fql$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_40110 = f__16346__auto__.call(null);
(statearr_40110[(6)] = c__16345__auto__);

return statearr_40110;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid.call(null,subject_id);
var or__4212__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec.call(null,db,coll_id,cljs.core.get_in.call(null,base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.call(null,base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.call(null,lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
fluree.db.query.fql.vswap_BANG_.call(null,cache,cljs.core.assoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec);

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_40441){
var state_val_40442 = (state_40441[(1)]);
if((state_val_40442 === (7))){
var inst_40436 = (state_40441[(2)]);
var _ = (function (){var statearr_40443 = state_40441;
(statearr_40443[(4)] = cljs.core.rest.call(null,(state_40441[(4)])));

return statearr_40443;
})();
var state_40441__$1 = state_40441;
var statearr_40444_40526 = state_40441__$1;
(statearr_40444_40526[(2)] = inst_40436);

(statearr_40444_40526[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (20))){
var inst_40363 = (state_40441[(7)]);
var state_40441__$1 = state_40441;
var statearr_40445_40527 = state_40441__$1;
(statearr_40445_40527[(2)] = inst_40363);

(statearr_40445_40527[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (27))){
var inst_40318 = (state_40441[(8)]);
var state_40441__$1 = state_40441;
if(cljs.core.truth_(inst_40318)){
var statearr_40446_40528 = state_40441__$1;
(statearr_40446_40528[(1)] = (29));

} else {
var statearr_40447_40529 = state_40441__$1;
(statearr_40447_40529[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (1))){
var state_40441__$1 = state_40441;
var statearr_40448_40530 = state_40441__$1;
(statearr_40448_40530[(2)] = null);

(statearr_40448_40530[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (24))){
var inst_40319 = (state_40441[(9)]);
var state_40441__$1 = state_40441;
var statearr_40449_40531 = state_40441__$1;
(statearr_40449_40531[(2)] = inst_40319);

(statearr_40449_40531[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (39))){
var inst_40355 = (state_40441[(10)]);
var state_40441__$1 = state_40441;
var statearr_40450_40532 = state_40441__$1;
(statearr_40450_40532[(2)] = inst_40355);

(statearr_40450_40532[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (46))){
var inst_40320 = (state_40441[(11)]);
var state_40441__$1 = state_40441;
var statearr_40451_40533 = state_40441__$1;
(statearr_40451_40533[(2)] = inst_40320);

(statearr_40451_40533[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (4))){
var inst_40282 = (state_40441[(2)]);
var state_40441__$1 = state_40441;
var statearr_40452_40534 = state_40441__$1;
(statearr_40452_40534[(2)] = inst_40282);

(statearr_40452_40534[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (15))){
var inst_40331 = (state_40441[(12)]);
var inst_40337 = cljs.core.count.call(null,inst_40331);
var inst_40338 = fluree.db.query.fql.add_fuel.call(null,fuel,inst_40337,max_fuel);
var state_40441__$1 = state_40441;
var statearr_40453_40535 = state_40441__$1;
(statearr_40453_40535[(2)] = inst_40338);

(statearr_40453_40535[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (48))){
var inst_40300 = (state_40441[(13)]);
var inst_40422 = (state_40441[(14)]);
var inst_40307 = (state_40441[(15)]);
var inst_40430 = (state_40441[(2)]);
var inst_40431 = cljs.core.assoc.call(null,inst_40300,inst_40430,inst_40422);
var inst_40299 = inst_40307;
var inst_40300__$1 = inst_40431;
var state_40441__$1 = (function (){var statearr_40454 = state_40441;
(statearr_40454[(13)] = inst_40300__$1);

(statearr_40454[(16)] = inst_40299);

return statearr_40454;
})();
var statearr_40455_40536 = state_40441__$1;
(statearr_40455_40536[(2)] = null);

(statearr_40455_40536[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (50))){
var inst_40322 = (state_40441[(17)]);
var state_40441__$1 = state_40441;
var statearr_40456_40537 = state_40441__$1;
(statearr_40456_40537[(2)] = inst_40322);

(statearr_40456_40537[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (21))){
var inst_40319 = (state_40441[(9)]);
var state_40441__$1 = state_40441;
if(cljs.core.truth_(inst_40319)){
var statearr_40458_40538 = state_40441__$1;
(statearr_40458_40538[(1)] = (23));

} else {
var statearr_40459_40539 = state_40441__$1;
(statearr_40459_40539[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (31))){
var inst_40379 = (state_40441[(2)]);
var state_40441__$1 = state_40441;
if(cljs.core.truth_(inst_40379)){
var statearr_40460_40540 = state_40441__$1;
(statearr_40460_40540[(1)] = (32));

} else {
var statearr_40461_40541 = state_40441__$1;
(statearr_40461_40541[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (32))){
var inst_40354 = (state_40441[(18)]);
var inst_40355 = (state_40441[(10)]);
var inst_40362 = (state_40441[(19)]);
var inst_40381 = (inst_40354 + (1));
var tmp40457 = inst_40355;
var inst_40353 = inst_40362;
var inst_40354__$1 = inst_40381;
var inst_40355__$1 = tmp40457;
var state_40441__$1 = (function (){var statearr_40462 = state_40441;
(statearr_40462[(20)] = inst_40353);

(statearr_40462[(18)] = inst_40354__$1);

(statearr_40462[(10)] = inst_40355__$1);

return statearr_40462;
})();
var statearr_40463_40542 = state_40441__$1;
(statearr_40463_40542[(2)] = null);

(statearr_40463_40542[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (40))){
var state_40441__$1 = state_40441;
if(cljs.core.truth_(fuel)){
var statearr_40464_40543 = state_40441__$1;
(statearr_40464_40543[(1)] = (42));

} else {
var statearr_40465_40544 = state_40441__$1;
(statearr_40465_40544[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (33))){
var state_40441__$1 = state_40441;
var statearr_40466_40545 = state_40441__$1;
(statearr_40466_40545[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (13))){
var inst_40331 = (state_40441[(12)]);
var state_40441__$1 = state_40441;
var statearr_40468_40546 = state_40441__$1;
(statearr_40468_40546[(2)] = inst_40331);

(statearr_40468_40546[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (22))){
var inst_40372 = (state_40441[(2)]);
var state_40441__$1 = state_40441;
if(cljs.core.truth_(inst_40372)){
var statearr_40469_40547 = state_40441__$1;
(statearr_40469_40547[(1)] = (26));

} else {
var statearr_40470_40548 = state_40441__$1;
(statearr_40470_40548[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (36))){
var state_40441__$1 = state_40441;
var statearr_40471_40549 = state_40441__$1;
(statearr_40471_40549[(2)] = null);

(statearr_40471_40549[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (41))){
var inst_40354 = (state_40441[(18)]);
var inst_40362 = (state_40441[(19)]);
var inst_40411 = (state_40441[(2)]);
var inst_40412 = (inst_40354 + (1));
var inst_40353 = inst_40362;
var inst_40354__$1 = inst_40412;
var inst_40355 = inst_40411;
var state_40441__$1 = (function (){var statearr_40472 = state_40441;
(statearr_40472[(20)] = inst_40353);

(statearr_40472[(18)] = inst_40354__$1);

(statearr_40472[(10)] = inst_40355);

return statearr_40472;
})();
var statearr_40473_40550 = state_40441__$1;
(statearr_40473_40550[(2)] = null);

(statearr_40473_40550[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (43))){
var state_40441__$1 = state_40441;
var statearr_40474_40551 = state_40441__$1;
(statearr_40474_40551[(2)] = null);

(statearr_40474_40551[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (29))){
var inst_40354 = (state_40441[(18)]);
var inst_40318 = (state_40441[(8)]);
var inst_40376 = (inst_40354 < inst_40318);
var state_40441__$1 = state_40441;
var statearr_40475_40552 = state_40441__$1;
(statearr_40475_40552[(2)] = inst_40376);

(statearr_40475_40552[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (44))){
var inst_40395 = (state_40441[(21)]);
var inst_40391 = (state_40441[(22)]);
var inst_40404 = (state_40441[(2)]);
var inst_40405 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_40395,inst_40391);
var state_40441__$1 = (function (){var statearr_40476 = state_40441;
(statearr_40476[(23)] = inst_40404);

return statearr_40476;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40441__$1,(45),inst_40405);
} else {
if((state_val_40442 === (6))){
var inst_40299 = (state_40441[(16)]);
var inst_40306 = (state_40441[(24)]);
var inst_40305 = cljs.core.seq.call(null,inst_40299);
var inst_40306__$1 = cljs.core.first.call(null,inst_40305);
var inst_40307 = cljs.core.next.call(null,inst_40305);
var inst_40308 = cljs.core.not.call(null,inst_40306__$1);
var state_40441__$1 = (function (){var statearr_40477 = state_40441;
(statearr_40477[(15)] = inst_40307);

(statearr_40477[(24)] = inst_40306__$1);

return statearr_40477;
})();
if(inst_40308){
var statearr_40478_40553 = state_40441__$1;
(statearr_40478_40553[(1)] = (8));

} else {
var statearr_40479_40554 = state_40441__$1;
(statearr_40479_40554[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (28))){
var inst_40420 = (state_40441[(2)]);
var state_40441__$1 = state_40441;
var statearr_40480_40555 = state_40441__$1;
(statearr_40480_40555[(2)] = inst_40420);

(statearr_40480_40555[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (51))){
var inst_40428 = (state_40441[(2)]);
var state_40441__$1 = state_40441;
var statearr_40481_40556 = state_40441__$1;
(statearr_40481_40556[(2)] = inst_40428);

(statearr_40481_40556[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (25))){
var inst_40370 = (state_40441[(2)]);
var state_40441__$1 = state_40441;
var statearr_40482_40557 = state_40441__$1;
(statearr_40482_40557[(2)] = inst_40370);

(statearr_40482_40557[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (34))){
var inst_40418 = (state_40441[(2)]);
var state_40441__$1 = state_40441;
var statearr_40483_40558 = state_40441__$1;
(statearr_40483_40558[(2)] = inst_40418);

(statearr_40483_40558[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (17))){
var inst_40331 = (state_40441[(12)]);
var inst_40341 = (state_40441[(2)]);
var inst_40349 = cljs.core.seq.call(null,inst_40331);
var inst_40350 = cljs.core.first.call(null,inst_40349);
var inst_40351 = cljs.core.next.call(null,inst_40349);
var inst_40352 = cljs.core.PersistentVector.EMPTY;
var inst_40353 = inst_40331;
var inst_40354 = (0);
var inst_40355 = inst_40352;
var state_40441__$1 = (function (){var statearr_40484 = state_40441;
(statearr_40484[(25)] = inst_40341);

(statearr_40484[(20)] = inst_40353);

(statearr_40484[(18)] = inst_40354);

(statearr_40484[(10)] = inst_40355);

(statearr_40484[(26)] = inst_40351);

(statearr_40484[(27)] = inst_40350);

return statearr_40484;
})();
var statearr_40485_40559 = state_40441__$1;
(statearr_40485_40559[(2)] = null);

(statearr_40485_40559[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (3))){
var inst_40439 = (state_40441[(2)]);
var state_40441__$1 = state_40441;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40441__$1,inst_40439);
} else {
if((state_val_40442 === (12))){
var state_40441__$1 = state_40441;
var statearr_40486_40560 = state_40441__$1;
(statearr_40486_40560[(2)] = fuel);

(statearr_40486_40560[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (2))){
var _ = (function (){var statearr_40487 = state_40441;
(statearr_40487[(4)] = cljs.core.cons.call(null,(5),(state_40441[(4)])));

return statearr_40487;
})();
var inst_40295 = reverse_refs_specs;
var inst_40296 = cljs.core.seq.call(null,inst_40295);
var inst_40297 = cljs.core.first.call(null,inst_40296);
var inst_40298 = cljs.core.next.call(null,inst_40296);
var inst_40299 = inst_40295;
var inst_40300 = null;
var state_40441__$1 = (function (){var statearr_40488 = state_40441;
(statearr_40488[(28)] = inst_40297);

(statearr_40488[(13)] = inst_40300);

(statearr_40488[(16)] = inst_40299);

(statearr_40488[(29)] = inst_40298);

return statearr_40488;
})();
var statearr_40489_40561 = state_40441__$1;
(statearr_40489_40561[(2)] = null);

(statearr_40489_40561[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (23))){
var inst_40354 = (state_40441[(18)]);
var inst_40319 = (state_40441[(9)]);
var inst_40367 = (inst_40354 >= inst_40319);
var state_40441__$1 = state_40441;
var statearr_40490_40562 = state_40441__$1;
(statearr_40490_40562[(2)] = inst_40367);

(statearr_40490_40562[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (47))){
var inst_40321 = (state_40441[(30)]);
var state_40441__$1 = state_40441;
if(cljs.core.truth_(inst_40321)){
var statearr_40491_40563 = state_40441__$1;
(statearr_40491_40563[(1)] = (49));

} else {
var statearr_40492_40564 = state_40441__$1;
(statearr_40492_40564[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (35))){
var inst_40361 = (state_40441[(31)]);
var inst_40385 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40386 = [inst_40361];
var inst_40387 = (new cljs.core.PersistentVector(null,1,(5),inst_40385,inst_40386,null));
var inst_40388 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_40387);
var state_40441__$1 = state_40441;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40441__$1,(38),inst_40388);
} else {
if((state_val_40442 === (19))){
var inst_40320 = (state_40441[(11)]);
var inst_40422 = (state_40441[(2)]);
var state_40441__$1 = (function (){var statearr_40493 = state_40441;
(statearr_40493[(14)] = inst_40422);

return statearr_40493;
})();
if(cljs.core.truth_(inst_40320)){
var statearr_40494_40565 = state_40441__$1;
(statearr_40494_40565[(1)] = (46));

} else {
var statearr_40495_40566 = state_40441__$1;
(statearr_40495_40566[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (11))){
var inst_40331 = (state_40441[(12)]);
var inst_40328 = (state_40441[(2)]);
var inst_40329 = fluree.db.util.async.throw_err.call(null,inst_40328);
var inst_40330 = cljs.core.map.call(null,fluree.db.query.fql.s,inst_40329);
var inst_40331__$1 = cljs.core.not_empty.call(null,inst_40330);
var state_40441__$1 = (function (){var statearr_40497 = state_40441;
(statearr_40497[(12)] = inst_40331__$1);

return statearr_40497;
})();
if(cljs.core.truth_(inst_40331__$1)){
var statearr_40498_40567 = state_40441__$1;
(statearr_40498_40567[(1)] = (12));

} else {
var statearr_40499_40568 = state_40441__$1;
(statearr_40499_40568[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (9))){
var inst_40316 = (state_40441[(32)]);
var inst_40306 = (state_40441[(24)]);
var inst_40315 = cljs.core.nth.call(null,inst_40306,(0),null);
var inst_40316__$1 = cljs.core.nth.call(null,inst_40306,(1),null);
var inst_40317 = cljs.core.__destructure_map.call(null,inst_40316__$1);
var inst_40318 = cljs.core.get.call(null,inst_40317,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_40319 = cljs.core.get.call(null,inst_40317,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_40320 = cljs.core.get.call(null,inst_40317,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_40321 = cljs.core.get.call(null,inst_40317,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_40322 = cljs.core.get.call(null,inst_40317,new cljs.core.Keyword(null,"p","p",151049309));
var inst_40323 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40324 = [subject_id,inst_40315];
var inst_40325 = (new cljs.core.PersistentVector(null,2,(5),inst_40323,inst_40324,null));
var inst_40326 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_40325);
var state_40441__$1 = (function (){var statearr_40500 = state_40441;
(statearr_40500[(11)] = inst_40320);

(statearr_40500[(32)] = inst_40316__$1);

(statearr_40500[(8)] = inst_40318);

(statearr_40500[(30)] = inst_40321);

(statearr_40500[(9)] = inst_40319);

(statearr_40500[(17)] = inst_40322);

return statearr_40500;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40441__$1,(11),inst_40326);
} else {
if((state_val_40442 === (5))){
var _ = (function (){var statearr_40501 = state_40441;
(statearr_40501[(4)] = cljs.core.rest.call(null,(state_40441[(4)])));

return statearr_40501;
})();
var state_40441__$1 = state_40441;
var ex40496 = (state_40441__$1[(2)]);
var statearr_40502_40569 = state_40441__$1;
(statearr_40502_40569[(5)] = ex40496);


if((ex40496 instanceof Error)){
var statearr_40503_40570 = state_40441__$1;
(statearr_40503_40570[(1)] = (4));

(statearr_40503_40570[(5)] = null);

} else {
throw ex40496;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (14))){
var inst_40335 = (state_40441[(2)]);
var state_40441__$1 = state_40441;
if(cljs.core.truth_(inst_40335)){
var statearr_40504_40571 = state_40441__$1;
(statearr_40504_40571[(1)] = (15));

} else {
var statearr_40505_40572 = state_40441__$1;
(statearr_40505_40572[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (45))){
var inst_40355 = (state_40441[(10)]);
var inst_40407 = (state_40441[(2)]);
var inst_40408 = fluree.db.util.async.throw_err.call(null,inst_40407);
var inst_40409 = cljs.core.conj.call(null,inst_40355,inst_40408);
var state_40441__$1 = state_40441;
var statearr_40506_40573 = state_40441__$1;
(statearr_40506_40573[(2)] = inst_40409);

(statearr_40506_40573[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (26))){
var inst_40355 = (state_40441[(10)]);
var state_40441__$1 = state_40441;
var statearr_40507_40574 = state_40441__$1;
(statearr_40507_40574[(2)] = inst_40355);

(statearr_40507_40574[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (16))){
var state_40441__$1 = state_40441;
var statearr_40508_40575 = state_40441__$1;
(statearr_40508_40575[(2)] = null);

(statearr_40508_40575[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (38))){
var inst_40316 = (state_40441[(32)]);
var inst_40391 = (state_40441[(22)]);
var inst_40390 = (state_40441[(2)]);
var inst_40391__$1 = fluree.db.util.async.throw_err.call(null,inst_40390);
var inst_40392 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40393 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_40394 = (new cljs.core.PersistentVector(null,4,(5),inst_40392,inst_40393,null));
var inst_40395 = cljs.core.select_keys.call(null,inst_40316,inst_40394);
var inst_40396 = cljs.core.empty_QMARK_.call(null,inst_40391__$1);
var state_40441__$1 = (function (){var statearr_40509 = state_40441;
(statearr_40509[(21)] = inst_40395);

(statearr_40509[(22)] = inst_40391__$1);

return statearr_40509;
})();
if(inst_40396){
var statearr_40510_40576 = state_40441__$1;
(statearr_40510_40576[(1)] = (39));

} else {
var statearr_40511_40577 = state_40441__$1;
(statearr_40511_40577[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (30))){
var inst_40318 = (state_40441[(8)]);
var state_40441__$1 = state_40441;
var statearr_40512_40578 = state_40441__$1;
(statearr_40512_40578[(2)] = inst_40318);

(statearr_40512_40578[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (10))){
var inst_40434 = (state_40441[(2)]);
var state_40441__$1 = state_40441;
var statearr_40513_40579 = state_40441__$1;
(statearr_40513_40579[(2)] = inst_40434);

(statearr_40513_40579[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (18))){
var inst_40361 = (state_40441[(31)]);
var inst_40353 = (state_40441[(20)]);
var inst_40363 = (state_40441[(7)]);
var inst_40360 = cljs.core.seq.call(null,inst_40353);
var inst_40361__$1 = cljs.core.first.call(null,inst_40360);
var inst_40362 = cljs.core.next.call(null,inst_40360);
var inst_40363__$1 = cljs.core.not.call(null,inst_40361__$1);
var state_40441__$1 = (function (){var statearr_40514 = state_40441;
(statearr_40514[(31)] = inst_40361__$1);

(statearr_40514[(7)] = inst_40363__$1);

(statearr_40514[(19)] = inst_40362);

return statearr_40514;
})();
if(inst_40363__$1){
var statearr_40515_40580 = state_40441__$1;
(statearr_40515_40580[(1)] = (20));

} else {
var statearr_40516_40581 = state_40441__$1;
(statearr_40516_40581[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (42))){
var inst_40391 = (state_40441[(22)]);
var inst_40400 = cljs.core.count.call(null,inst_40391);
var inst_40401 = fluree.db.query.fql.add_fuel.call(null,fuel,inst_40400,max_fuel);
var state_40441__$1 = state_40441;
var statearr_40517_40582 = state_40441__$1;
(statearr_40517_40582[(2)] = inst_40401);

(statearr_40517_40582[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (37))){
var inst_40416 = (state_40441[(2)]);
var state_40441__$1 = state_40441;
var statearr_40518_40583 = state_40441__$1;
(statearr_40518_40583[(2)] = inst_40416);

(statearr_40518_40583[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (8))){
var inst_40300 = (state_40441[(13)]);
var state_40441__$1 = state_40441;
var statearr_40519_40584 = state_40441__$1;
(statearr_40519_40584[(2)] = inst_40300);

(statearr_40519_40584[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40442 === (49))){
var inst_40321 = (state_40441[(30)]);
var state_40441__$1 = state_40441;
var statearr_40520_40585 = state_40441__$1;
(statearr_40520_40585[(2)] = inst_40321);

(statearr_40520_40585[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16221__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16221__auto____0 = (function (){
var statearr_40521 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40521[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16221__auto__);

(statearr_40521[(1)] = (1));

return statearr_40521;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16221__auto____1 = (function (state_40441){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_40441);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e40522){var ex__16224__auto__ = e40522;
var statearr_40523_40586 = state_40441;
(statearr_40523_40586[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_40441[(4)]))){
var statearr_40524_40587 = state_40441;
(statearr_40524_40587[(1)] = cljs.core.first.call(null,(state_40441[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40588 = state_40441;
state_40441 = G__40588;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16221__auto__ = function(state_40441){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16221__auto____1.call(this,state_40441);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16221__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16221__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_40525 = f__16346__auto__.call(null);
(statearr_40525[(6)] = c__16345__auto__);

return statearr_40525;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_.call(null,pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4212__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.call(null,(function (acc,spec){
var key_spec = cljs.core.key.call(null,spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,spec)) == null))?cljs.core.assoc.call(null,cljs.core.val.call(null,spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val.call(null,spec));
return cljs.core.assoc.call(null,acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.call(null,coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__40589 = select_spec;
var map__40589__$1 = cljs.core.__destructure_map.call(null,map__40589);
var recur_seen = cljs.core.get.call(null,map__40589__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var recur_depth = cljs.core.get.call(null,map__40589__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
return cljs.core.select_keys.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057)], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687)], null),cljs.core.conj.call(null,recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"compact?","compact?",1216893298)], null));
});
/**
 * Performs recursion on a select spec graph crawl when specified. flakes input is list
 *   of flakes all with the same subject and predicate values.
 */
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flakes,select_spec,results,fuel,max_fuel,cache){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_40703){
var state_val_40704 = (state_40703[(1)]);
if((state_val_40704 === (7))){
var inst_40615 = flakes;
var inst_40616 = cljs.core.seq.call(null,inst_40615);
var inst_40617 = cljs.core.first.call(null,inst_40616);
var inst_40618 = cljs.core.next.call(null,inst_40616);
var inst_40619 = cljs.core.PersistentVector.EMPTY;
var inst_40620 = inst_40615;
var inst_40621 = (0);
var inst_40622 = inst_40619;
var state_40703__$1 = (function (){var statearr_40705 = state_40703;
(statearr_40705[(7)] = inst_40622);

(statearr_40705[(8)] = inst_40620);

(statearr_40705[(9)] = inst_40617);

(statearr_40705[(10)] = inst_40621);

(statearr_40705[(11)] = inst_40618);

return statearr_40705;
})();
var statearr_40706_40772 = state_40703__$1;
(statearr_40706_40772[(2)] = null);

(statearr_40706_40772[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40704 === (20))){
var state_40703__$1 = state_40703;
var statearr_40707_40773 = state_40703__$1;
(statearr_40707_40773[(2)] = results);

(statearr_40707_40773[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40704 === (27))){
var state_40703__$1 = state_40703;
var statearr_40708_40774 = state_40703__$1;
(statearr_40708_40774[(2)] = null);

(statearr_40708_40774[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40704 === (1))){
var state_40703__$1 = state_40703;
var statearr_40709_40775 = state_40703__$1;
(statearr_40709_40775[(2)] = null);

(statearr_40709_40775[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40704 === (24))){
var state_40703__$1 = state_40703;
var statearr_40710_40776 = state_40703__$1;
(statearr_40710_40776[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40704 === (39))){
var inst_40622 = (state_40703[(7)]);
var inst_40684 = (state_40703[(12)]);
var inst_40629 = (state_40703[(13)]);
var inst_40687 = (state_40703[(2)]);
var inst_40688 = fluree.db.util.async.throw_err.call(null,inst_40687);
var inst_40689 = cljs.core.conj.call(null,inst_40622,inst_40688);
var inst_40620 = inst_40629;
var inst_40621 = inst_40684;
var inst_40622__$1 = inst_40689;
var state_40703__$1 = (function (){var statearr_40712 = state_40703;
(statearr_40712[(7)] = inst_40622__$1);

(statearr_40712[(8)] = inst_40620);

(statearr_40712[(10)] = inst_40621);

return statearr_40712;
})();
var statearr_40713_40777 = state_40703__$1;
(statearr_40713_40777[(2)] = null);

(statearr_40713_40777[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40704 === (4))){
var inst_40590 = (state_40703[(2)]);
var state_40703__$1 = state_40703;
var statearr_40714_40778 = state_40703__$1;
(statearr_40714_40778[(2)] = inst_40590);

(statearr_40714_40778[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40704 === (15))){
var inst_40603 = (state_40703[(14)]);
var state_40703__$1 = state_40703;
var statearr_40715_40779 = state_40703__$1;
(statearr_40715_40779[(2)] = inst_40603);

(statearr_40715_40779[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40704 === (21))){
var inst_40599 = (state_40703[(15)]);
var state_40703__$1 = state_40703;
if(cljs.core.truth_(inst_40599)){
var statearr_40716_40780 = state_40703__$1;
(statearr_40716_40780[(1)] = (23));

} else {
var statearr_40717_40781 = state_40703__$1;
(statearr_40717_40781[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40704 === (31))){
var inst_40667 = (state_40703[(16)]);
var state_40703__$1 = state_40703;
var statearr_40718_40782 = state_40703__$1;
(statearr_40718_40782[(2)] = inst_40667);

(statearr_40718_40782[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40704 === (32))){
var inst_40659 = (state_40703[(17)]);
var inst_40673 = (state_40703[(2)]);
var state_40703__$1 = (function (){var statearr_40719 = state_40703;
(statearr_40719[(18)] = inst_40673);

return statearr_40719;
})();
if(cljs.core.truth_(inst_40659)){
var statearr_40720_40783 = state_40703__$1;
(statearr_40720_40783[(1)] = (33));

} else {
var statearr_40721_40784 = state_40703__$1;
(statearr_40721_40784[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40704 === (33))){
var inst_40659 = (state_40703[(17)]);
var state_40703__$1 = state_40703;
var statearr_40722_40785 = state_40703__$1;
(statearr_40722_40785[(2)] = inst_40659);

(statearr_40722_40785[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40704 === (13))){
var inst_40639 = (state_40703[(2)]);
var state_40703__$1 = state_40703;
if(cljs.core.truth_(inst_40639)){
var statearr_40724_40786 = state_40703__$1;
(statearr_40724_40786[(1)] = (17));

} else {
var statearr_40725_40787 = state_40703__$1;
(statearr_40725_40787[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40704 === (22))){
var inst_40656 = (state_40703[(2)]);
var state_40703__$1 = state_40703;
var statearr_40726_40788 = state_40703__$1;
(statearr_40726_40788[(2)] = inst_40656);

(statearr_40726_40788[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40704 === (36))){
var inst_40622 = (state_40703[(7)]);
var inst_40629 = (state_40703[(13)]);
var inst_40621 = (state_40703[(10)]);
var inst_40681 = (inst_40621 + (1));
var tmp40723 = inst_40622;
var inst_40620 = inst_40629;
var inst_40621__$1 = inst_40681;
var inst_40622__$1 = tmp40723;
var state_40703__$1 = (function (){var statearr_40727 = state_40703;
(statearr_40727[(7)] = inst_40622__$1);

(statearr_40727[(8)] = inst_40620);

(statearr_40727[(10)] = inst_40621__$1);

return statearr_40727;
})();
var statearr_40728_40789 = state_40703__$1;
(statearr_40728_40789[(2)] = null);

(statearr_40728_40789[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40704 === (29))){
var inst_40666 = (state_40703[(2)]);
var inst_40667 = fluree.db.util.async.throw_err.call(null,inst_40666);
var state_40703__$1 = (function (){var statearr_40729 = state_40703;
(statearr_40729[(16)] = inst_40667);

return statearr_40729;
})();
if(cljs.core.truth_(fuel)){
var statearr_40730_40790 = state_40703__$1;
(statearr_40730_40790[(1)] = (30));

} else {
var statearr_40731_40791 = state_40703__$1;
(statearr_40731_40791[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40704 === (6))){
var state_40703__$1 = state_40703;
var statearr_40732_40792 = state_40703__$1;
(statearr_40732_40792[(2)] = results);

(statearr_40732_40792[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40704 === (28))){
var inst_40652 = (state_40703[(2)]);
var state_40703__$1 = state_40703;
var statearr_40733_40793 = state_40703__$1;
(statearr_40733_40793[(2)] = inst_40652);

(statearr_40733_40793[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40704 === (25))){
var inst_40654 = (state_40703[(2)]);
var state_40703__$1 = state_40703;
var statearr_40734_40794 = state_40703__$1;
(statearr_40734_40794[(2)] = inst_40654);

(statearr_40734_40794[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40704 === (34))){
var inst_40673 = (state_40703[(18)]);
var inst_40676 = cljs.core.empty_QMARK_.call(null,inst_40673);
var state_40703__$1 = state_40703;
var statearr_40735_40795 = state_40703__$1;
(statearr_40735_40795[(2)] = inst_40676);

(statearr_40735_40795[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40704 === (17))){
var inst_40622 = (state_40703[(7)]);
var inst_40641 = cljs.core.empty_QMARK_.call(null,inst_40622);
var state_40703__$1 = state_40703;
if(inst_40641){
var statearr_40736_40796 = state_40703__$1;
(statearr_40736_40796[(1)] = (20));

} else {
var statearr_40737_40797 = state_40703__$1;
(statearr_40737_40797[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40704 === (3))){
var inst_40701 = (state_40703[(2)]);
var state_40703__$1 = state_40703;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40703__$1,inst_40701);
} else {
if((state_val_40704 === (12))){
var inst_40603 = (state_40703[(14)]);
var state_40703__$1 = state_40703;
if(cljs.core.truth_(inst_40603)){
var statearr_40738_40798 = state_40703__$1;
(statearr_40738_40798[(1)] = (14));

} else {
var statearr_40739_40799 = state_40703__$1;
(statearr_40739_40799[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40704 === (2))){
var _ = (function (){var statearr_40740 = state_40703;
(statearr_40740[(4)] = cljs.core.cons.call(null,(5),(state_40703[(4)])));

return statearr_40740;
})();
var inst_40597 = select_spec;
var inst_40598 = cljs.core.__destructure_map.call(null,inst_40597);
var inst_40599 = cljs.core.get.call(null,inst_40598,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_40600 = cljs.core.get.call(null,inst_40598,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_40601 = cljs.core.get.call(null,inst_40598,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var inst_40602 = cljs.core.get.call(null,inst_40598,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
var inst_40603 = cljs.core.get.call(null,inst_40598,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_40604 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(select_spec);
var inst_40605 = (inst_40602 > inst_40604);
var state_40703__$1 = (function (){var statearr_40741 = state_40703;
(statearr_40741[(19)] = inst_40601);

(statearr_40741[(15)] = inst_40599);

(statearr_40741[(20)] = inst_40600);

(statearr_40741[(14)] = inst_40603);

return statearr_40741;
})();
if(cljs.core.truth_(inst_40605)){
var statearr_40742_40800 = state_40703__$1;
(statearr_40742_40800[(1)] = (6));

} else {
var statearr_40743_40801 = state_40703__$1;
(statearr_40743_40801[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40704 === (23))){
var inst_40622 = (state_40703[(7)]);
var inst_40600 = (state_40703[(20)]);
var inst_40645 = cljs.core.assoc.call(null,results,inst_40600,inst_40622);
var state_40703__$1 = state_40703;
var statearr_40744_40802 = state_40703__$1;
(statearr_40744_40802[(2)] = inst_40645);

(statearr_40744_40802[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40704 === (35))){
var inst_40628 = (state_40703[(21)]);
var inst_40678 = (state_40703[(2)]);
var inst_40679 = fluree.db.query.fql.recur_select_spec.call(null,select_spec,inst_40628);
var state_40703__$1 = (function (){var statearr_40745 = state_40703;
(statearr_40745[(22)] = inst_40679);

return statearr_40745;
})();
if(cljs.core.truth_(inst_40678)){
var statearr_40746_40803 = state_40703__$1;
(statearr_40746_40803[(1)] = (36));

} else {
var statearr_40747_40804 = state_40703__$1;
(statearr_40747_40804[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40704 === (19))){
var inst_40694 = (state_40703[(2)]);
var state_40703__$1 = state_40703;
var statearr_40748_40805 = state_40703__$1;
(statearr_40748_40805[(2)] = inst_40694);

(statearr_40748_40805[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40704 === (11))){
var inst_40630 = (state_40703[(23)]);
var state_40703__$1 = state_40703;
var statearr_40750_40806 = state_40703__$1;
(statearr_40750_40806[(2)] = inst_40630);

(statearr_40750_40806[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40704 === (9))){
var inst_40620 = (state_40703[(8)]);
var inst_40628 = (state_40703[(21)]);
var inst_40630 = (state_40703[(23)]);
var inst_40627 = cljs.core.seq.call(null,inst_40620);
var inst_40628__$1 = cljs.core.first.call(null,inst_40627);
var inst_40629 = cljs.core.next.call(null,inst_40627);
var inst_40630__$1 = cljs.core.not.call(null,inst_40628__$1);
var state_40703__$1 = (function (){var statearr_40751 = state_40703;
(statearr_40751[(13)] = inst_40629);

(statearr_40751[(21)] = inst_40628__$1);

(statearr_40751[(23)] = inst_40630__$1);

return statearr_40751;
})();
if(inst_40630__$1){
var statearr_40752_40807 = state_40703__$1;
(statearr_40752_40807[(1)] = (11));

} else {
var statearr_40753_40808 = state_40703__$1;
(statearr_40753_40808[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40704 === (5))){
var _ = (function (){var statearr_40754 = state_40703;
(statearr_40754[(4)] = cljs.core.rest.call(null,(state_40703[(4)])));

return statearr_40754;
})();
var state_40703__$1 = state_40703;
var ex40749 = (state_40703__$1[(2)]);
var statearr_40755_40809 = state_40703__$1;
(statearr_40755_40809[(5)] = ex40749);


if((ex40749 instanceof Error)){
var statearr_40756_40810 = state_40703__$1;
(statearr_40756_40810[(1)] = (4));

(statearr_40756_40810[(5)] = null);

} else {
throw ex40749;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40704 === (14))){
var inst_40621 = (state_40703[(10)]);
var inst_40603 = (state_40703[(14)]);
var inst_40634 = (inst_40621 < inst_40603);
var state_40703__$1 = state_40703;
var statearr_40757_40811 = state_40703__$1;
(statearr_40757_40811[(2)] = inst_40634);

(statearr_40757_40811[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40704 === (26))){
var inst_40622 = (state_40703[(7)]);
var inst_40600 = (state_40703[(20)]);
var inst_40648 = cljs.core.first.call(null,inst_40622);
var inst_40649 = cljs.core.assoc.call(null,results,inst_40600,inst_40648);
var state_40703__$1 = state_40703;
var statearr_40758_40812 = state_40703__$1;
(statearr_40758_40812[(2)] = inst_40649);

(statearr_40758_40812[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40704 === (16))){
var inst_40637 = (state_40703[(2)]);
var state_40703__$1 = state_40703;
var statearr_40759_40813 = state_40703__$1;
(statearr_40759_40813[(2)] = inst_40637);

(statearr_40759_40813[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40704 === (38))){
var inst_40692 = (state_40703[(2)]);
var state_40703__$1 = state_40703;
var statearr_40760_40814 = state_40703__$1;
(statearr_40760_40814[(2)] = inst_40692);

(statearr_40760_40814[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40704 === (30))){
var inst_40667 = (state_40703[(16)]);
var inst_40669 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_40670 = cljs.core.sequence.call(null,inst_40669,inst_40667);
var state_40703__$1 = state_40703;
var statearr_40761_40815 = state_40703__$1;
(statearr_40761_40815[(2)] = inst_40670);

(statearr_40761_40815[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40704 === (10))){
var inst_40696 = (state_40703[(2)]);
var state_40703__$1 = state_40703;
var statearr_40762_40816 = state_40703__$1;
(statearr_40762_40816[(2)] = inst_40696);

(statearr_40762_40816[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40704 === (18))){
var inst_40601 = (state_40703[(19)]);
var inst_40628 = (state_40703[(21)]);
var inst_40658 = inst_40628.o;
var inst_40659 = cljs.core.contains_QMARK_.call(null,inst_40601,inst_40658);
var inst_40661 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40662 = [inst_40658];
var inst_40663 = (new cljs.core.PersistentVector(null,1,(5),inst_40661,inst_40662,null));
var inst_40664 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_40663);
var state_40703__$1 = (function (){var statearr_40763 = state_40703;
(statearr_40763[(17)] = inst_40659);

return statearr_40763;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40703__$1,(29),inst_40664);
} else {
if((state_val_40704 === (37))){
var inst_40673 = (state_40703[(18)]);
var inst_40621 = (state_40703[(10)]);
var inst_40679 = (state_40703[(22)]);
var inst_40684 = (inst_40621 + (1));
var inst_40685 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_40679,inst_40673);
var state_40703__$1 = (function (){var statearr_40764 = state_40703;
(statearr_40764[(12)] = inst_40684);

return statearr_40764;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40703__$1,(39),inst_40685);
} else {
if((state_val_40704 === (8))){
var inst_40698 = (state_40703[(2)]);
var _ = (function (){var statearr_40765 = state_40703;
(statearr_40765[(4)] = cljs.core.rest.call(null,(state_40703[(4)])));

return statearr_40765;
})();
var state_40703__$1 = state_40703;
var statearr_40766_40817 = state_40703__$1;
(statearr_40766_40817[(2)] = inst_40698);

(statearr_40766_40817[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__16221__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__16221__auto____0 = (function (){
var statearr_40767 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40767[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__16221__auto__);

(statearr_40767[(1)] = (1));

return statearr_40767;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__16221__auto____1 = (function (state_40703){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_40703);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e40768){var ex__16224__auto__ = e40768;
var statearr_40769_40818 = state_40703;
(statearr_40769_40818[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_40703[(4)]))){
var statearr_40770_40819 = state_40703;
(statearr_40770_40819[(1)] = cljs.core.first.call(null,(state_40703[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40820 = state_40703;
state_40703 = G__40820;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__16221__auto__ = function(state_40703){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__16221__auto____1.call(this,state_40703);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__16221__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__16221__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_40771 = f__16346__auto__.call(null);
(statearr_40771[(6)] = c__16345__auto__);

return statearr_40771;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_41001){
var state_val_41002 = (state_41001[(1)]);
if((state_val_41002 === (7))){
var state_41001__$1 = state_41001;
var statearr_41003_41089 = state_41001__$1;
(statearr_41003_41089[(2)] = null);

(statearr_41003_41089[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (20))){
var inst_40859 = cljs.core.PersistentHashMap.EMPTY;
var state_41001__$1 = state_41001;
var statearr_41004_41090 = state_41001__$1;
(statearr_41004_41090[(2)] = inst_40859);

(statearr_41004_41090[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (27))){
var inst_40861 = (state_41001[(7)]);
var inst_40841 = (state_41001[(8)]);
var inst_40877 = (state_41001[(9)]);
var inst_40847 = (state_41001[(10)]);
var inst_40980 = (state_41001[(2)]);
var inst_40981 = (function (){var top_level_subject = inst_40841;
var select_spec = inst_40847;
var base_acc = inst_40861;
var acc_PLUS_refs = inst_40877;
var result = inst_40980;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4212__auto__ = (function (){var and__4210__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4210__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4210__auto__;
}
})();
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var and__4210__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4210__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4210__auto__;
}
}
})())){
return cljs.core.conj.call(null,acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_40982 = cljs.core.PersistentVector.EMPTY;
var inst_40983 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_40847);
var inst_40984 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_40983);
var inst_40985 = cljs.core.vals.call(null,inst_40984);
var inst_40986 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_40847);
var inst_40987 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_40986);
var inst_40988 = cljs.core.vals.call(null,inst_40987);
var inst_40989 = cljs.core.concat.call(null,inst_40985,inst_40988);
var inst_40990 = cljs.core.reduce.call(null,inst_40981,inst_40982,inst_40989);
var inst_40992 = (function (){var top_level_subject = inst_40841;
var select_spec = inst_40847;
var base_acc = inst_40861;
var acc_PLUS_refs = inst_40877;
var result = inst_40980;
var sort_preds = inst_40990;
return (function (acc,p__40991){
var vec__41005 = p__40991;
var selectPred = cljs.core.nth.call(null,vec__41005,(0),null);
var sortOrder = cljs.core.nth.call(null,vec__41005,(1),null);
var sortPred = cljs.core.nth.call(null,vec__41005,(2),null);
var limit = cljs.core.nth.call(null,vec__41005,(3),null);
return cljs.core.assoc.call(null,acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res.call(null,sortPred,sortOrder,(0),limit,cljs.core.get.call(null,acc,selectPred)));
});
})();
var inst_40993 = cljs.core.reduce.call(null,inst_40992,inst_40980,inst_40990);
var state_41001__$1 = state_41001;
var statearr_41008_41091 = state_41001__$1;
(statearr_41008_41091[(2)] = inst_40993);

(statearr_41008_41091[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (1))){
var state_41001__$1 = state_41001;
var statearr_41009_41092 = state_41001__$1;
(statearr_41009_41092[(2)] = null);

(statearr_41009_41092[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (24))){
var inst_40877 = (state_41001[(9)]);
var inst_40877__$1 = (state_41001[(2)]);
var inst_40878 = cljs.core.partition_by.call(null,new cljs.core.Keyword(null,"p","p",151049309),flakes);
var inst_40879 = cljs.core.PersistentHashMap.EMPTY;
var inst_40880 = inst_40878;
var inst_40881 = inst_40877__$1;
var inst_40882 = inst_40879;
var state_41001__$1 = (function (){var statearr_41010 = state_41001;
(statearr_41010[(11)] = inst_40880);

(statearr_41010[(12)] = inst_40882);

(statearr_41010[(13)] = inst_40881);

(statearr_41010[(9)] = inst_40877__$1);

return statearr_41010;
})();
var statearr_41011_41093 = state_41001__$1;
(statearr_41011_41093[(2)] = null);

(statearr_41011_41093[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (39))){
var inst_40897 = (state_41001[(14)]);
var inst_40881 = (state_41001[(13)]);
var inst_40890 = (state_41001[(15)]);
var inst_40847 = (state_41001[(10)]);
var inst_40926 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40927 = fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,inst_40881,inst_40847,inst_40890,inst_40897,false);
var state_41001__$1 = (function (){var statearr_41012 = state_41001;
(statearr_41012[(16)] = inst_40926);

return statearr_41012;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41001__$1,(42),inst_40927);
} else {
if((state_val_41002 === (46))){
var inst_40880 = (state_41001[(11)]);
var inst_40882 = (state_41001[(12)]);
var inst_40890 = (state_41001[(15)]);
var inst_40944 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40945 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_40946 = cljs.core.first.call(null,inst_40890);
var inst_40947 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_40946);
var inst_40948 = [inst_40947];
var inst_40949 = cljs.core.PersistentHashMap.fromArrays(inst_40945,inst_40948);
var inst_40950 = cljs.core.rest.call(null,inst_40880);
var inst_40951 = [inst_40949,inst_40950,inst_40882];
var inst_40952 = (new cljs.core.PersistentVector(null,3,(5),inst_40944,inst_40951,null));
var state_41001__$1 = state_41001;
var statearr_41013_41094 = state_41001__$1;
(statearr_41013_41094[(2)] = inst_40952);

(statearr_41013_41094[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (4))){
var inst_40821 = (state_41001[(2)]);
var state_41001__$1 = state_41001;
var statearr_41014_41095 = state_41001__$1;
(statearr_41014_41095[(2)] = inst_40821);

(statearr_41014_41095[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (15))){
var inst_40848 = (state_41001[(17)]);
var inst_40847 = (state_41001[(10)]);
var inst_40847__$1 = (state_41001[(2)]);
var inst_40848__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_40847__$1);
var state_41001__$1 = (function (){var statearr_41015 = state_41001;
(statearr_41015[(17)] = inst_40848__$1);

(statearr_41015[(10)] = inst_40847__$1);

return statearr_41015;
})();
if(cljs.core.truth_(inst_40848__$1)){
var statearr_41016_41096 = state_41001__$1;
(statearr_41016_41096[(1)] = (16));

} else {
var statearr_41017_41097 = state_41001__$1;
(statearr_41017_41097[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (48))){
var inst_40963 = (state_41001[(2)]);
var state_41001__$1 = state_41001;
var statearr_41018_41098 = state_41001__$1;
(statearr_41018_41098[(2)] = inst_40963);

(statearr_41018_41098[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (50))){
var state_41001__$1 = state_41001;
var statearr_41019_41099 = state_41001__$1;
(statearr_41019_41099[(2)] = null);

(statearr_41019_41099[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (21))){
var inst_40847 = (state_41001[(10)]);
var inst_40861 = (state_41001[(2)]);
var inst_40862 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40863 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_40864 = (new cljs.core.PersistentVector(null,2,(5),inst_40862,inst_40863,null));
var inst_40865 = cljs.core.get_in.call(null,inst_40847,inst_40864);
var state_41001__$1 = (function (){var statearr_41020 = state_41001;
(statearr_41020[(7)] = inst_40861);

return statearr_41020;
})();
if(cljs.core.truth_(inst_40865)){
var statearr_41021_41100 = state_41001__$1;
(statearr_41021_41100[(1)] = (22));

} else {
var statearr_41022_41101 = state_41001__$1;
(statearr_41022_41101[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (31))){
var inst_40896 = (state_41001[(18)]);
var inst_40881 = (state_41001[(13)]);
var inst_40890 = (state_41001[(15)]);
var inst_40900 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40901 = fluree.db.query.fql.flake__GT_recur.call(null,db,inst_40890,inst_40896,inst_40881,fuel,max_fuel,cache);
var state_41001__$1 = (function (){var statearr_41023 = state_41001;
(statearr_41023[(19)] = inst_40900);

return statearr_41023;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41001__$1,(34),inst_40901);
} else {
if((state_val_41002 === (32))){
var inst_40896 = (state_41001[(18)]);
var state_41001__$1 = state_41001;
if(cljs.core.truth_(inst_40896)){
var statearr_41024_41102 = state_41001__$1;
(statearr_41024_41102[(1)] = (35));

} else {
var statearr_41025_41103 = state_41001__$1;
(statearr_41025_41103[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (40))){
var inst_40847 = (state_41001[(10)]);
var inst_40937 = (state_41001[(20)]);
var inst_40936 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_40847);
var inst_40937__$1 = cljs.core.empty_QMARK_.call(null,inst_40936);
var state_41001__$1 = (function (){var statearr_41026 = state_41001;
(statearr_41026[(20)] = inst_40937__$1);

return statearr_41026;
})();
if(inst_40937__$1){
var statearr_41027_41104 = state_41001__$1;
(statearr_41027_41104[(1)] = (43));

} else {
var statearr_41028_41105 = state_41001__$1;
(statearr_41028_41105[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (33))){
var inst_40890 = (state_41001[(15)]);
var inst_40969 = (state_41001[(2)]);
var inst_40970 = cljs.core.nth.call(null,inst_40969,(0),null);
var inst_40971 = cljs.core.nth.call(null,inst_40969,(1),null);
var inst_40972 = cljs.core.nth.call(null,inst_40969,(2),null);
var inst_40973 = cljs.core.first.call(null,inst_40890);
var inst_40974 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_40973);
var inst_40975 = cljs.core.assoc.call(null,inst_40970,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_40974);
var inst_40880 = inst_40971;
var inst_40881 = inst_40975;
var inst_40882 = inst_40972;
var state_41001__$1 = (function (){var statearr_41029 = state_41001;
(statearr_41029[(11)] = inst_40880);

(statearr_41029[(12)] = inst_40882);

(statearr_41029[(13)] = inst_40881);

return statearr_41029;
})();
var statearr_41030_41106 = state_41001__$1;
(statearr_41030_41106[(2)] = null);

(statearr_41030_41106[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (13))){
var inst_40841 = (state_41001[(8)]);
var inst_40844 = fluree.db.query.fql.full_select_spec.call(null,db,cache,base_select_spec,inst_40841);
var state_41001__$1 = state_41001;
var statearr_41031_41107 = state_41001__$1;
(statearr_41031_41107[(2)] = inst_40844);

(statearr_41031_41107[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (22))){
var inst_40847 = (state_41001[(10)]);
var inst_40867 = cljs.core.first.call(null,flakes);
var inst_40868 = fluree.db.query.fql.s.call(null,inst_40867);
var inst_40869 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs.call(null,inst_40847);
var inst_40870 = fluree.db.query.fql.resolve_reverse_refs.call(null,db,cache,fuel,max_fuel,inst_40868,inst_40869);
var state_41001__$1 = state_41001;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41001__$1,(25),inst_40870);
} else {
if((state_val_41002 === (36))){
var inst_40847 = (state_41001[(10)]);
var inst_40924 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_40847);
var state_41001__$1 = state_41001;
if(cljs.core.truth_(inst_40924)){
var statearr_41032_41108 = state_41001__$1;
(statearr_41032_41108[(1)] = (39));

} else {
var statearr_41033_41109 = state_41001__$1;
(statearr_41033_41109[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (41))){
var inst_40965 = (state_41001[(2)]);
var state_41001__$1 = state_41001;
var statearr_41034_41110 = state_41001__$1;
(statearr_41034_41110[(2)] = inst_40965);

(statearr_41034_41110[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (43))){
var inst_40847 = (state_41001[(10)]);
var inst_40939 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_40847);
var state_41001__$1 = state_41001;
var statearr_41035_41111 = state_41001__$1;
(statearr_41035_41111[(2)] = inst_40939);

(statearr_41035_41111[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (29))){
var inst_40896 = (state_41001[(18)]);
var inst_40880 = (state_41001[(11)]);
var inst_40890 = (state_41001[(15)]);
var inst_40847 = (state_41001[(10)]);
var inst_40890__$1 = cljs.core.first.call(null,inst_40880);
var inst_40891 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40892 = cljs.core.first.call(null,inst_40890__$1);
var inst_40893 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_40892);
var inst_40894 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_40893];
var inst_40895 = (new cljs.core.PersistentVector(null,3,(5),inst_40891,inst_40894,null));
var inst_40896__$1 = cljs.core.get_in.call(null,inst_40847,inst_40895);
var inst_40897 = fluree.db.query.fql.component_follow_QMARK_.call(null,inst_40896__$1,inst_40847);
var inst_40898 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_40896__$1);
var state_41001__$1 = (function (){var statearr_41036 = state_41001;
(statearr_41036[(18)] = inst_40896__$1);

(statearr_41036[(14)] = inst_40897);

(statearr_41036[(15)] = inst_40890__$1);

return statearr_41036;
})();
if(cljs.core.truth_(inst_40898)){
var statearr_41037_41112 = state_41001__$1;
(statearr_41037_41112[(1)] = (31));

} else {
var statearr_41038_41113 = state_41001__$1;
(statearr_41038_41113[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (44))){
var inst_40937 = (state_41001[(20)]);
var state_41001__$1 = state_41001;
var statearr_41039_41114 = state_41001__$1;
(statearr_41039_41114[(2)] = inst_40937);

(statearr_41039_41114[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (6))){
var state_41001__$1 = state_41001;
var statearr_41040_41115 = state_41001__$1;
(statearr_41040_41115[(2)] = null);

(statearr_41040_41115[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (28))){
var inst_40881 = (state_41001[(13)]);
var state_41001__$1 = state_41001;
var statearr_41041_41116 = state_41001__$1;
(statearr_41041_41116[(2)] = inst_40881);

(statearr_41041_41116[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (51))){
var inst_40961 = (state_41001[(2)]);
var state_41001__$1 = state_41001;
var statearr_41042_41117 = state_41001__$1;
(statearr_41042_41117[(2)] = inst_40961);

(statearr_41042_41117[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (25))){
var inst_40861 = (state_41001[(7)]);
var inst_40872 = (state_41001[(2)]);
var inst_40873 = fluree.db.util.async.throw_err.call(null,inst_40872);
var inst_40874 = cljs.core.merge.call(null,inst_40861,inst_40873);
var state_41001__$1 = state_41001;
var statearr_41043_41118 = state_41001__$1;
(statearr_41043_41118[(2)] = inst_40874);

(statearr_41043_41118[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (34))){
var inst_40900 = (state_41001[(19)]);
var inst_40880 = (state_41001[(11)]);
var inst_40882 = (state_41001[(12)]);
var inst_40903 = (state_41001[(2)]);
var inst_40904 = fluree.db.util.async.throw_err.call(null,inst_40903);
var inst_40905 = cljs.core.rest.call(null,inst_40880);
var inst_40906 = [inst_40904,inst_40905,inst_40882];
var inst_40907 = (new cljs.core.PersistentVector(null,3,(5),inst_40900,inst_40906,null));
var state_41001__$1 = state_41001;
var statearr_41044_41119 = state_41001__$1;
(statearr_41044_41119[(2)] = inst_40907);

(statearr_41044_41119[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (17))){
var inst_40847 = (state_41001[(10)]);
var inst_40851 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_40847);
var state_41001__$1 = state_41001;
var statearr_41046_41120 = state_41001__$1;
(statearr_41046_41120[(2)] = inst_40851);

(statearr_41046_41120[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (3))){
var inst_40999 = (state_41001[(2)]);
var state_41001__$1 = state_41001;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_41001__$1,inst_40999);
} else {
if((state_val_41002 === (12))){
var _ = (function (){var statearr_41047 = state_41001;
(statearr_41047[(4)] = cljs.core.rest.call(null,(state_41001[(4)])));

return statearr_41047;
})();
var state_41001__$1 = state_41001;
var ex41045 = (state_41001__$1[(2)]);
var statearr_41048_41121 = state_41001__$1;
(statearr_41048_41121[(5)] = ex41045);


var statearr_41049_41122 = state_41001__$1;
(statearr_41049_41122[(1)] = (11));

(statearr_41049_41122[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (2))){
var _ = (function (){var statearr_41050 = state_41001;
(statearr_41050[(4)] = cljs.core.cons.call(null,(5),(state_41001[(4)])));

return statearr_41050;
})();
var inst_40827 = cljs.core.not_empty.call(null,flakes);
var state_41001__$1 = state_41001;
if(cljs.core.truth_(inst_40827)){
var statearr_41051_41123 = state_41001__$1;
(statearr_41051_41123[(1)] = (6));

} else {
var statearr_41052_41124 = state_41001__$1;
(statearr_41052_41124[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (23))){
var inst_40861 = (state_41001[(7)]);
var state_41001__$1 = state_41001;
var statearr_41053_41125 = state_41001__$1;
(statearr_41053_41125[(2)] = inst_40861);

(statearr_41053_41125[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (47))){
var state_41001__$1 = state_41001;
var statearr_41054_41126 = state_41001__$1;
(statearr_41054_41126[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (35))){
var inst_40896 = (state_41001[(18)]);
var inst_40882 = (state_41001[(12)]);
var inst_40897 = (state_41001[(14)]);
var inst_40881 = (state_41001[(13)]);
var inst_40890 = (state_41001[(15)]);
var inst_40913 = fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,inst_40881,inst_40896,inst_40890,inst_40897,false,inst_40882);
var state_41001__$1 = state_41001;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41001__$1,(38),inst_40913);
} else {
if((state_val_41002 === (19))){
var inst_40841 = (state_41001[(8)]);
var inst_40855 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_40856 = [inst_40841];
var inst_40857 = cljs.core.PersistentHashMap.fromArrays(inst_40855,inst_40856);
var state_41001__$1 = state_41001;
var statearr_41056_41127 = state_41001__$1;
(statearr_41056_41127[(2)] = inst_40857);

(statearr_41056_41127[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (11))){
var inst_40829 = (state_41001[(2)]);
var inst_40830 = fluree.db.util.log.error.call(null,inst_40829);
var inst_40831 = (function(){throw inst_40829})();
var state_41001__$1 = (function (){var statearr_41058 = state_41001;
(statearr_41058[(21)] = inst_40830);

return statearr_41058;
})();
var statearr_41059_41128 = state_41001__$1;
(statearr_41059_41128[(2)] = inst_40831);

(statearr_41059_41128[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (9))){
var _ = (function (){var statearr_41060 = state_41001;
(statearr_41060[(4)] = cljs.core.cons.call(null,(12),(state_41001[(4)])));

return statearr_41060;
})();
var inst_40837 = cljs.core.first.call(null,flakes);
var inst_40838 = fluree.db.query.fql.s.call(null,inst_40837);
var ___$1 = (function (){var statearr_41061 = state_41001;
(statearr_41061[(4)] = cljs.core.rest.call(null,(state_41001[(4)])));

return statearr_41061;
})();
var state_41001__$1 = state_41001;
var statearr_41062_41129 = state_41001__$1;
(statearr_41062_41129[(2)] = inst_40838);

(statearr_41062_41129[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (5))){
var _ = (function (){var statearr_41063 = state_41001;
(statearr_41063[(4)] = cljs.core.rest.call(null,(state_41001[(4)])));

return statearr_41063;
})();
var state_41001__$1 = state_41001;
var ex41057 = (state_41001__$1[(2)]);
var statearr_41064_41130 = state_41001__$1;
(statearr_41064_41130[(5)] = ex41057);


if((ex41057 instanceof Error)){
var statearr_41065_41131 = state_41001__$1;
(statearr_41065_41131[(1)] = (4));

(statearr_41065_41131[(5)] = null);

} else {
throw ex41057;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (14))){
var state_41001__$1 = state_41001;
var statearr_41066_41132 = state_41001__$1;
(statearr_41066_41132[(2)] = base_select_spec);

(statearr_41066_41132[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (45))){
var inst_40942 = (state_41001[(2)]);
var state_41001__$1 = state_41001;
if(cljs.core.truth_(inst_40942)){
var statearr_41067_41133 = state_41001__$1;
(statearr_41067_41133[(1)] = (46));

} else {
var statearr_41068_41134 = state_41001__$1;
(statearr_41068_41134[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (26))){
var inst_40880 = (state_41001[(11)]);
var inst_40884 = cljs.core.empty_QMARK_.call(null,inst_40880);
var state_41001__$1 = state_41001;
if(inst_40884){
var statearr_41069_41135 = state_41001__$1;
(statearr_41069_41135[(1)] = (28));

} else {
var statearr_41070_41136 = state_41001__$1;
(statearr_41070_41136[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (16))){
var inst_40848 = (state_41001[(17)]);
var state_41001__$1 = state_41001;
var statearr_41071_41137 = state_41001__$1;
(statearr_41071_41137[(2)] = inst_40848);

(statearr_41071_41137[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (38))){
var inst_40880 = (state_41001[(11)]);
var inst_40915 = (state_41001[(2)]);
var inst_40916 = fluree.db.util.async.throw_err.call(null,inst_40915);
var inst_40917 = cljs.core.nth.call(null,inst_40916,(0),null);
var inst_40918 = cljs.core.nth.call(null,inst_40916,(1),null);
var inst_40919 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40920 = cljs.core.rest.call(null,inst_40880);
var inst_40921 = [inst_40917,inst_40920,inst_40918];
var inst_40922 = (new cljs.core.PersistentVector(null,3,(5),inst_40919,inst_40921,null));
var state_41001__$1 = state_41001;
var statearr_41072_41138 = state_41001__$1;
(statearr_41072_41138[(2)] = inst_40922);

(statearr_41072_41138[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (30))){
var inst_40978 = (state_41001[(2)]);
var state_41001__$1 = state_41001;
var statearr_41073_41139 = state_41001__$1;
(statearr_41073_41139[(2)] = inst_40978);

(statearr_41073_41139[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (10))){
var inst_40841 = (state_41001[(2)]);
var inst_40842 = fluree.db.query.fql.has_ns_lookups_QMARK_.call(null,base_select_spec);
var state_41001__$1 = (function (){var statearr_41074 = state_41001;
(statearr_41074[(8)] = inst_40841);

return statearr_41074;
})();
if(cljs.core.truth_(inst_40842)){
var statearr_41075_41140 = state_41001__$1;
(statearr_41075_41140[(1)] = (13));

} else {
var statearr_41076_41141 = state_41001__$1;
(statearr_41076_41141[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (18))){
var inst_40853 = (state_41001[(2)]);
var state_41001__$1 = state_41001;
if(cljs.core.truth_(inst_40853)){
var statearr_41077_41142 = state_41001__$1;
(statearr_41077_41142[(1)] = (19));

} else {
var statearr_41078_41143 = state_41001__$1;
(statearr_41078_41143[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (42))){
var inst_40926 = (state_41001[(16)]);
var inst_40880 = (state_41001[(11)]);
var inst_40882 = (state_41001[(12)]);
var inst_40929 = (state_41001[(2)]);
var inst_40930 = fluree.db.util.async.throw_err.call(null,inst_40929);
var inst_40931 = cljs.core.first.call(null,inst_40930);
var inst_40932 = cljs.core.rest.call(null,inst_40880);
var inst_40933 = [inst_40931,inst_40932,inst_40882];
var inst_40934 = (new cljs.core.PersistentVector(null,3,(5),inst_40926,inst_40933,null));
var state_41001__$1 = state_41001;
var statearr_41079_41144 = state_41001__$1;
(statearr_41079_41144[(2)] = inst_40934);

(statearr_41079_41144[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (37))){
var inst_40967 = (state_41001[(2)]);
var state_41001__$1 = state_41001;
var statearr_41080_41145 = state_41001__$1;
(statearr_41080_41145[(2)] = inst_40967);

(statearr_41080_41145[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (8))){
var inst_40996 = (state_41001[(2)]);
var _ = (function (){var statearr_41081 = state_41001;
(statearr_41081[(4)] = cljs.core.rest.call(null,(state_41001[(4)])));

return statearr_41081;
})();
var state_41001__$1 = state_41001;
var statearr_41082_41146 = state_41001__$1;
(statearr_41082_41146[(2)] = inst_40996);

(statearr_41082_41146[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41002 === (49))){
var inst_40880 = (state_41001[(11)]);
var inst_40882 = (state_41001[(12)]);
var inst_40881 = (state_41001[(13)]);
var inst_40955 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40956 = cljs.core.rest.call(null,inst_40880);
var inst_40957 = [inst_40881,inst_40956,inst_40882];
var inst_40958 = (new cljs.core.PersistentVector(null,3,(5),inst_40955,inst_40957,null));
var state_41001__$1 = state_41001;
var statearr_41083_41147 = state_41001__$1;
(statearr_41083_41147[(2)] = inst_40958);

(statearr_41083_41147[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__16221__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__16221__auto____0 = (function (){
var statearr_41084 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41084[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__16221__auto__);

(statearr_41084[(1)] = (1));

return statearr_41084;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__16221__auto____1 = (function (state_41001){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_41001);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e41085){var ex__16224__auto__ = e41085;
var statearr_41086_41148 = state_41001;
(statearr_41086_41148[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_41001[(4)]))){
var statearr_41087_41149 = state_41001;
(statearr_41087_41149[(1)] = cljs.core.first.call(null,(state_41001[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41150 = state_41001;
state_41001 = G__41150;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__16221__auto__ = function(state_41001){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__16221__auto____1.call(this,state_41001);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__16221__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__16221__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_41088 = f__16346__auto__.call(null);
(statearr_41088[(6)] = c__16345__auto__);

return statearr_41088;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__41153 = arguments.length;
switch (G__41153) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.call(null,db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.call(null,db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_41195){
var state_val_41196 = (state_41195[(1)]);
if((state_val_41196 === (7))){
var inst_41161 = (state_41195[(7)]);
var state_41195__$1 = state_41195;
var statearr_41197_41227 = state_41195__$1;
(statearr_41197_41227[(2)] = inst_41161);

(statearr_41197_41227[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41196 === (1))){
var state_41195__$1 = state_41195;
var statearr_41198_41228 = state_41195__$1;
(statearr_41198_41228[(2)] = null);

(statearr_41198_41228[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41196 === (4))){
var inst_41154 = (state_41195[(2)]);
var state_41195__$1 = state_41195;
var statearr_41199_41229 = state_41195__$1;
(statearr_41199_41229[(2)] = inst_41154);

(statearr_41199_41229[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41196 === (15))){
var inst_41189 = (state_41195[(2)]);
var inst_41190 = fluree.db.util.async.throw_err.call(null,inst_41189);
var _ = (function (){var statearr_41200 = state_41195;
(statearr_41200[(4)] = cljs.core.rest.call(null,(state_41195[(4)])));

return statearr_41200;
})();
var state_41195__$1 = state_41195;
var statearr_41201_41230 = state_41195__$1;
(statearr_41201_41230[(2)] = inst_41190);

(statearr_41201_41230[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41196 === (13))){
var inst_41173 = (state_41195[(8)]);
var state_41195__$1 = state_41195;
var statearr_41202_41231 = state_41195__$1;
(statearr_41202_41231[(2)] = inst_41173);

(statearr_41202_41231[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41196 === (6))){
var inst_41161 = (state_41195[(7)]);
var inst_41163 = fluree.db.query.fql.fuel_flakes_transducer.call(null,fuel,max_fuel);
var inst_41164 = cljs.core.comp.call(null,inst_41161,inst_41163);
var state_41195__$1 = state_41195;
var statearr_41203_41232 = state_41195__$1;
(statearr_41203_41232[(2)] = inst_41164);

(statearr_41203_41232[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41196 === (3))){
var inst_41193 = (state_41195[(2)]);
var state_41195__$1 = state_41195;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_41195__$1,inst_41193);
} else {
if((state_val_41196 === (12))){
var inst_41173 = (state_41195[(8)]);
var inst_41175 = cljs.core.take.call(null,limit);
var inst_41176 = cljs.core.comp.call(null,inst_41173,inst_41175);
var state_41195__$1 = state_41195;
var statearr_41204_41233 = state_41195__$1;
(statearr_41204_41233[(2)] = inst_41176);

(statearr_41204_41233[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41196 === (2))){
var _ = (function (){var statearr_41205 = state_41195;
(statearr_41205[(4)] = cljs.core.cons.call(null,(5),(state_41195[(4)])));

return statearr_41205;
})();
var inst_41161 = cljs.core.partition_by.call(null,fluree.db.query.fql.s);
var state_41195__$1 = (function (){var statearr_41206 = state_41195;
(statearr_41206[(7)] = inst_41161);

return statearr_41206;
})();
if(cljs.core.truth_(fuel)){
var statearr_41207_41234 = state_41195__$1;
(statearr_41207_41234[(1)] = (6));

} else {
var statearr_41208_41235 = state_41195__$1;
(statearr_41208_41235[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41196 === (11))){
var inst_41173 = (state_41195[(2)]);
var state_41195__$1 = (function (){var statearr_41210 = state_41195;
(statearr_41210[(8)] = inst_41173);

return statearr_41210;
})();
if(cljs.core.truth_(limit)){
var statearr_41211_41236 = state_41195__$1;
(statearr_41211_41236[(1)] = (12));

} else {
var statearr_41212_41237 = state_41195__$1;
(statearr_41212_41237[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41196 === (9))){
var inst_41167 = (state_41195[(9)]);
var inst_41169 = cljs.core.drop.call(null,offset);
var inst_41170 = cljs.core.comp.call(null,inst_41167,inst_41169);
var state_41195__$1 = state_41195;
var statearr_41213_41238 = state_41195__$1;
(statearr_41213_41238[(2)] = inst_41170);

(statearr_41213_41238[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41196 === (5))){
var _ = (function (){var statearr_41214 = state_41195;
(statearr_41214[(4)] = cljs.core.rest.call(null,(state_41195[(4)])));

return statearr_41214;
})();
var state_41195__$1 = state_41195;
var ex41209 = (state_41195__$1[(2)]);
var statearr_41215_41239 = state_41195__$1;
(statearr_41215_41239[(5)] = ex41209);


if((ex41209 instanceof Error)){
var statearr_41216_41240 = state_41195__$1;
(statearr_41216_41240[(1)] = (4));

(statearr_41216_41240[(5)] = null);

} else {
throw ex41209;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41196 === (14))){
var inst_41179 = (state_41195[(2)]);
var inst_41180 = (function (){return (function (x){
var and__4210__auto__ = max_fuel;
if(cljs.core.truth_(and__4210__auto__)){
return (cljs.core.deref.call(null,fuel) >= max_fuel);
} else {
return and__4210__auto__;
}
});
})();
var inst_41181 = cljs.core.halt_when.call(null,inst_41180);
var inst_41182 = cljs.core.comp.call(null,inst_41179,inst_41181);
var inst_41183 = cljs.core.sequence.call(null,inst_41182,flakes);
var inst_41184 = cljs.core.PersistentVector.EMPTY;
var inst_41185 = (function (){var xf = inst_41182;
var flakes_by_sub = inst_41183;
return (function (p1__41151_SHARP_){
return fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,select_spec,p1__41151_SHARP_);
});
})();
var inst_41186 = cljs.core.map.call(null,inst_41185,inst_41183);
var inst_41187 = fluree.db.util.async.merge_into_QMARK_.call(null,inst_41184,inst_41186);
var state_41195__$1 = state_41195;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41195__$1,(15),inst_41187);
} else {
if((state_val_41196 === (10))){
var inst_41167 = (state_41195[(9)]);
var state_41195__$1 = state_41195;
var statearr_41217_41241 = state_41195__$1;
(statearr_41217_41241[(2)] = inst_41167);

(statearr_41217_41241[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41196 === (8))){
var inst_41167 = (state_41195[(2)]);
var state_41195__$1 = (function (){var statearr_41218 = state_41195;
(statearr_41218[(9)] = inst_41167);

return statearr_41218;
})();
if(cljs.core.truth_(offset)){
var statearr_41219_41242 = state_41195__$1;
(statearr_41219_41242[(1)] = (9));

} else {
var statearr_41220_41243 = state_41195__$1;
(statearr_41220_41243[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16221__auto__ = null;
var fluree$db$query$fql$state_machine__16221__auto____0 = (function (){
var statearr_41221 = [null,null,null,null,null,null,null,null,null,null];
(statearr_41221[(0)] = fluree$db$query$fql$state_machine__16221__auto__);

(statearr_41221[(1)] = (1));

return statearr_41221;
});
var fluree$db$query$fql$state_machine__16221__auto____1 = (function (state_41195){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_41195);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e41222){var ex__16224__auto__ = e41222;
var statearr_41223_41244 = state_41195;
(statearr_41223_41244[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_41195[(4)]))){
var statearr_41224_41245 = state_41195;
(statearr_41224_41245[(1)] = cljs.core.first.call(null,(state_41195[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41246 = state_41195;
state_41195 = G__41246;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16221__auto__ = function(state_41195){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16221__auto____1.call(this,state_41195);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16221__auto____0;
fluree$db$query$fql$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16221__auto____1;
return fluree$db$query$fql$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_41225 = f__16346__auto__.call(null);
(statearr_41225[(6)] = c__16345__auto__);

return statearr_41225;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__41248 = arguments.length;
switch (G__41248) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.call(null,db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.call(null,db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_41334){
var state_val_41335 = (state_41334[(1)]);
if((state_val_41335 === (7))){
var inst_41329 = (state_41334[(2)]);
var _ = (function (){var statearr_41337 = state_41334;
(statearr_41337[(4)] = cljs.core.rest.call(null,(state_41334[(4)])));

return statearr_41337;
})();
var state_41334__$1 = state_41334;
var statearr_41338_41390 = state_41334__$1;
(statearr_41338_41390[(2)] = inst_41329);

(statearr_41338_41390[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41335 === (20))){
var inst_41276 = (state_41334[(7)]);
var inst_41269 = (state_41334[(8)]);
var inst_41268 = (state_41334[(9)]);
var inst_41297 = (inst_41268 + (1));
var tmp41336 = inst_41269;
var inst_41267 = inst_41276;
var inst_41268__$1 = inst_41297;
var inst_41269__$1 = tmp41336;
var state_41334__$1 = (function (){var statearr_41339 = state_41334;
(statearr_41339[(8)] = inst_41269__$1);

(statearr_41339[(10)] = inst_41267);

(statearr_41339[(9)] = inst_41268__$1);

return statearr_41339;
})();
var statearr_41340_41391 = state_41334__$1;
(statearr_41340_41391[(2)] = null);

(statearr_41340_41391[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41335 === (27))){
var inst_41307 = (state_41334[(11)]);
var inst_41309 = cljs.core.count.call(null,inst_41307);
var inst_41310 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_41309);
var state_41334__$1 = state_41334;
var statearr_41341_41392 = state_41334__$1;
(statearr_41341_41392[(2)] = inst_41310);

(statearr_41341_41392[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41335 === (1))){
var state_41334__$1 = state_41334;
var statearr_41342_41393 = state_41334__$1;
(statearr_41342_41393[(2)] = null);

(statearr_41342_41393[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41335 === (24))){
var state_41334__$1 = state_41334;
var statearr_41343_41394 = state_41334__$1;
(statearr_41343_41394[(2)] = null);

(statearr_41343_41394[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41335 === (4))){
var inst_41249 = (state_41334[(2)]);
var state_41334__$1 = state_41334;
var statearr_41344_41395 = state_41334__$1;
(statearr_41344_41395[(2)] = inst_41249);

(statearr_41344_41395[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41335 === (15))){
var inst_41290 = (state_41334[(12)]);
var inst_41290__$1 = offset;
var state_41334__$1 = (function (){var statearr_41345 = state_41334;
(statearr_41345[(12)] = inst_41290__$1);

return statearr_41345;
})();
if(cljs.core.truth_(inst_41290__$1)){
var statearr_41346_41396 = state_41334__$1;
(statearr_41346_41396[(1)] = (17));

} else {
var statearr_41347_41397 = state_41334__$1;
(statearr_41347_41397[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41335 === (21))){
var state_41334__$1 = state_41334;
var statearr_41348_41398 = state_41334__$1;
(statearr_41348_41398[(1)] = (23));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41335 === (13))){
var inst_41285 = (state_41334[(2)]);
var state_41334__$1 = state_41334;
var statearr_41350_41399 = state_41334__$1;
(statearr_41350_41399[(2)] = inst_41285);

(statearr_41350_41399[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41335 === (22))){
var inst_41325 = (state_41334[(2)]);
var state_41334__$1 = state_41334;
var statearr_41351_41400 = state_41334__$1;
(statearr_41351_41400[(2)] = inst_41325);

(statearr_41351_41400[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41335 === (29))){
var inst_41307 = (state_41334[(11)]);
var inst_41268 = (state_41334[(9)]);
var inst_41313 = (state_41334[(2)]);
var inst_41314 = (inst_41268 + (1));
var inst_41315 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,select_spec,inst_41307);
var state_41334__$1 = (function (){var statearr_41352 = state_41334;
(statearr_41352[(13)] = inst_41314);

(statearr_41352[(14)] = inst_41313);

return statearr_41352;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41334__$1,(30),inst_41315);
} else {
if((state_val_41335 === (6))){
var inst_41275 = (state_41334[(15)]);
var inst_41277 = (state_41334[(16)]);
var inst_41267 = (state_41334[(10)]);
var inst_41274 = cljs.core.seq.call(null,inst_41267);
var inst_41275__$1 = cljs.core.first.call(null,inst_41274);
var inst_41276 = cljs.core.next.call(null,inst_41274);
var inst_41277__$1 = (inst_41275__$1 == null);
var state_41334__$1 = (function (){var statearr_41353 = state_41334;
(statearr_41353[(15)] = inst_41275__$1);

(statearr_41353[(7)] = inst_41276);

(statearr_41353[(16)] = inst_41277__$1);

return statearr_41353;
})();
if(cljs.core.truth_(inst_41277__$1)){
var statearr_41354_41401 = state_41334__$1;
(statearr_41354_41401[(1)] = (8));

} else {
var statearr_41355_41402 = state_41334__$1;
(statearr_41355_41402[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41335 === (28))){
var state_41334__$1 = state_41334;
var statearr_41356_41403 = state_41334__$1;
(statearr_41356_41403[(2)] = null);

(statearr_41356_41403[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41335 === (25))){
var inst_41323 = (state_41334[(2)]);
var state_41334__$1 = state_41334;
var statearr_41357_41404 = state_41334__$1;
(statearr_41357_41404[(2)] = inst_41323);

(statearr_41357_41404[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41335 === (17))){
var inst_41268 = (state_41334[(9)]);
var inst_41292 = (inst_41268 < offset);
var state_41334__$1 = state_41334;
var statearr_41358_41405 = state_41334__$1;
(statearr_41358_41405[(2)] = inst_41292);

(statearr_41358_41405[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41335 === (3))){
var inst_41332 = (state_41334[(2)]);
var state_41334__$1 = state_41334;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_41334__$1,inst_41332);
} else {
if((state_val_41335 === (12))){
var inst_41280 = (state_41334[(17)]);
var state_41334__$1 = state_41334;
var statearr_41359_41406 = state_41334__$1;
(statearr_41359_41406[(2)] = inst_41280);

(statearr_41359_41406[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41335 === (2))){
var _ = (function (){var statearr_41360 = state_41334;
(statearr_41360[(4)] = cljs.core.cons.call(null,(5),(state_41334[(4)])));

return statearr_41360;
})();
var inst_41262 = subjects;
var inst_41263 = cljs.core.seq.call(null,inst_41262);
var inst_41264 = cljs.core.first.call(null,inst_41263);
var inst_41265 = cljs.core.next.call(null,inst_41263);
var inst_41266 = cljs.core.PersistentVector.EMPTY;
var inst_41267 = inst_41262;
var inst_41268 = (0);
var inst_41269 = inst_41266;
var state_41334__$1 = (function (){var statearr_41361 = state_41334;
(statearr_41361[(18)] = inst_41265);

(statearr_41361[(8)] = inst_41269);

(statearr_41361[(19)] = inst_41264);

(statearr_41361[(10)] = inst_41267);

(statearr_41361[(9)] = inst_41268);

return statearr_41361;
})();
var statearr_41362_41407 = state_41334__$1;
(statearr_41362_41407[(2)] = null);

(statearr_41362_41407[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41335 === (23))){
var inst_41275 = (state_41334[(15)]);
var inst_41301 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41302 = [inst_41275];
var inst_41303 = (new cljs.core.PersistentVector(null,1,(5),inst_41301,inst_41302,null));
var inst_41304 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_41303);
var state_41334__$1 = state_41334;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41334__$1,(26),inst_41304);
} else {
if((state_val_41335 === (19))){
var inst_41295 = (state_41334[(2)]);
var state_41334__$1 = state_41334;
if(cljs.core.truth_(inst_41295)){
var statearr_41363_41408 = state_41334__$1;
(statearr_41363_41408[(1)] = (20));

} else {
var statearr_41364_41409 = state_41334__$1;
(statearr_41364_41409[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41335 === (11))){
var inst_41268 = (state_41334[(9)]);
var inst_41282 = (inst_41268 > limit);
var state_41334__$1 = state_41334;
var statearr_41366_41410 = state_41334__$1;
(statearr_41366_41410[(2)] = inst_41282);

(statearr_41366_41410[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41335 === (9))){
var inst_41280 = (state_41334[(17)]);
var inst_41280__$1 = limit;
var state_41334__$1 = (function (){var statearr_41367 = state_41334;
(statearr_41367[(17)] = inst_41280__$1);

return statearr_41367;
})();
if(cljs.core.truth_(inst_41280__$1)){
var statearr_41368_41411 = state_41334__$1;
(statearr_41368_41411[(1)] = (11));

} else {
var statearr_41369_41412 = state_41334__$1;
(statearr_41369_41412[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41335 === (5))){
var _ = (function (){var statearr_41370 = state_41334;
(statearr_41370[(4)] = cljs.core.rest.call(null,(state_41334[(4)])));

return statearr_41370;
})();
var state_41334__$1 = state_41334;
var ex41365 = (state_41334__$1[(2)]);
var statearr_41371_41413 = state_41334__$1;
(statearr_41371_41413[(5)] = ex41365);


if((ex41365 instanceof Error)){
var statearr_41372_41414 = state_41334__$1;
(statearr_41372_41414[(1)] = (4));

(statearr_41372_41414[(5)] = null);

} else {
throw ex41365;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41335 === (14))){
var inst_41269 = (state_41334[(8)]);
var state_41334__$1 = state_41334;
var statearr_41373_41415 = state_41334__$1;
(statearr_41373_41415[(2)] = inst_41269);

(statearr_41373_41415[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41335 === (26))){
var inst_41306 = (state_41334[(2)]);
var inst_41307 = fluree.db.util.async.throw_err.call(null,inst_41306);
var state_41334__$1 = (function (){var statearr_41374 = state_41334;
(statearr_41374[(11)] = inst_41307);

return statearr_41374;
})();
if(cljs.core.truth_(fuel)){
var statearr_41375_41416 = state_41334__$1;
(statearr_41375_41416[(1)] = (27));

} else {
var statearr_41376_41417 = state_41334__$1;
(statearr_41376_41417[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41335 === (16))){
var inst_41327 = (state_41334[(2)]);
var state_41334__$1 = state_41334;
var statearr_41377_41418 = state_41334__$1;
(statearr_41377_41418[(2)] = inst_41327);

(statearr_41377_41418[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41335 === (30))){
var inst_41276 = (state_41334[(7)]);
var inst_41269 = (state_41334[(8)]);
var inst_41314 = (state_41334[(13)]);
var inst_41317 = (state_41334[(2)]);
var inst_41318 = fluree.db.util.async.throw_err.call(null,inst_41317);
var inst_41319 = cljs.core.conj.call(null,inst_41269,inst_41318);
var inst_41267 = inst_41276;
var inst_41268 = inst_41314;
var inst_41269__$1 = inst_41319;
var state_41334__$1 = (function (){var statearr_41378 = state_41334;
(statearr_41378[(8)] = inst_41269__$1);

(statearr_41378[(10)] = inst_41267);

(statearr_41378[(9)] = inst_41268);

return statearr_41378;
})();
var statearr_41379_41419 = state_41334__$1;
(statearr_41379_41419[(2)] = null);

(statearr_41379_41419[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41335 === (10))){
var inst_41287 = (state_41334[(2)]);
var state_41334__$1 = state_41334;
if(cljs.core.truth_(inst_41287)){
var statearr_41380_41420 = state_41334__$1;
(statearr_41380_41420[(1)] = (14));

} else {
var statearr_41381_41421 = state_41334__$1;
(statearr_41381_41421[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41335 === (18))){
var inst_41290 = (state_41334[(12)]);
var state_41334__$1 = state_41334;
var statearr_41382_41422 = state_41334__$1;
(statearr_41382_41422[(2)] = inst_41290);

(statearr_41382_41422[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41335 === (8))){
var inst_41277 = (state_41334[(16)]);
var state_41334__$1 = state_41334;
var statearr_41383_41423 = state_41334__$1;
(statearr_41383_41423[(2)] = inst_41277);

(statearr_41383_41423[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16221__auto__ = null;
var fluree$db$query$fql$state_machine__16221__auto____0 = (function (){
var statearr_41384 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41384[(0)] = fluree$db$query$fql$state_machine__16221__auto__);

(statearr_41384[(1)] = (1));

return statearr_41384;
});
var fluree$db$query$fql$state_machine__16221__auto____1 = (function (state_41334){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_41334);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e41385){var ex__16224__auto__ = e41385;
var statearr_41386_41424 = state_41334;
(statearr_41386_41424[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_41334[(4)]))){
var statearr_41387_41425 = state_41334;
(statearr_41387_41425[(1)] = cljs.core.first.call(null,(state_41334[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41426 = state_41334;
state_41334 = G__41426;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16221__auto__ = function(state_41334){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16221__auto____1.call(this,state_41334);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16221__auto____0;
fluree$db$query$fql$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16221__auto____1;
return fluree$db$query$fql$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_41388 = f__16346__auto__.call(null);
(statearr_41388[(6)] = c__16345__auto__);

return statearr_41388;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4212__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p);
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223),fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"type","type",1174270348),p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__41428 = arguments.length;
switch (G__41428) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.call(null,db,where_clause,null,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4 = (function (db,where_clause,default_collection,p__41429){
var map__41430 = p__41429;
var map__41430__$1 = cljs.core.__destructure_map.call(null,map__41430);
var limit = cljs.core.get.call(null,map__41430__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__41430__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_41694){
var state_val_41695 = (state_41694[(1)]);
if((state_val_41695 === (65))){
var inst_41657 = (state_41694[(7)]);
var inst_41657__$1 = (state_41694[(2)]);
var state_41694__$1 = (function (){var statearr_41696 = state_41694;
(statearr_41696[(7)] = inst_41657__$1);

return statearr_41696;
})();
if(cljs.core.truth_(inst_41657__$1)){
var statearr_41697_41815 = state_41694__$1;
(statearr_41697_41815[(1)] = (66));

} else {
var statearr_41698_41816 = state_41694__$1;
(statearr_41698_41816[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (70))){
var inst_41660 = (state_41694[(8)]);
var state_41694__$1 = state_41694;
var statearr_41699_41817 = state_41694__$1;
(statearr_41699_41817[(2)] = inst_41660);

(statearr_41699_41817[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (62))){
var inst_41648 = (state_41694[(2)]);
var state_41694__$1 = state_41694;
var statearr_41700_41818 = state_41694__$1;
(statearr_41700_41818[(2)] = inst_41648);

(statearr_41700_41818[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (74))){
var inst_41667 = (state_41694[(2)]);
var state_41694__$1 = state_41694;
var statearr_41701_41819 = state_41694__$1;
(statearr_41701_41819[(2)] = inst_41667);

(statearr_41701_41819[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (7))){
var inst_41443 = (state_41694[(9)]);
var state_41694__$1 = state_41694;
var statearr_41702_41820 = state_41694__$1;
(statearr_41702_41820[(2)] = inst_41443);

(statearr_41702_41820[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (59))){
var inst_41472 = (state_41694[(10)]);
var inst_41640 = cljs.core.empty_QMARK_.call(null,inst_41472);
var state_41694__$1 = state_41694;
if(inst_41640){
var statearr_41703_41821 = state_41694__$1;
(statearr_41703_41821[(1)] = (60));

} else {
var statearr_41704_41822 = state_41694__$1;
(statearr_41704_41822[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (20))){
var state_41694__$1 = state_41694;
if(cljs.core.truth_(offset)){
var statearr_41705_41823 = state_41694__$1;
(statearr_41705_41823[(1)] = (23));

} else {
var statearr_41706_41824 = state_41694__$1;
(statearr_41706_41824[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (72))){
var inst_41457 = (state_41694[(11)]);
var inst_41637 = (state_41694[(12)]);
var inst_41663 = cljs.core.count.call(null,inst_41637);
var inst_41664 = (inst_41663 > inst_41457);
var state_41694__$1 = state_41694;
var statearr_41707_41825 = state_41694__$1;
(statearr_41707_41825[(2)] = inst_41664);

(statearr_41707_41825[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (58))){
var inst_41637 = (state_41694[(12)]);
var inst_41472 = (state_41694[(10)]);
var inst_41638 = cljs.core.into.call(null,inst_41472,inst_41637);
var state_41694__$1 = state_41694;
var statearr_41708_41826 = state_41694__$1;
(statearr_41708_41826[(2)] = inst_41638);

(statearr_41708_41826[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (60))){
var inst_41637 = (state_41694[(12)]);
var inst_41472 = (state_41694[(10)]);
var inst_41642 = cljs.core.into.call(null,inst_41472,inst_41637);
var state_41694__$1 = state_41694;
var statearr_41709_41827 = state_41694__$1;
(statearr_41709_41827[(2)] = inst_41642);

(statearr_41709_41827[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (27))){
var inst_41487 = (state_41694[(13)]);
var state_41694__$1 = state_41694;
var statearr_41710_41828 = state_41694__$1;
(statearr_41710_41828[(2)] = inst_41487);

(statearr_41710_41828[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (1))){
var state_41694__$1 = state_41694;
var statearr_41711_41829 = state_41694__$1;
(statearr_41711_41829[(2)] = null);

(statearr_41711_41829[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (69))){
var inst_41457 = (state_41694[(11)]);
var state_41694__$1 = state_41694;
if(cljs.core.truth_(inst_41457)){
var statearr_41712_41830 = state_41694__$1;
(statearr_41712_41830[(1)] = (72));

} else {
var statearr_41713_41831 = state_41694__$1;
(statearr_41713_41831[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (24))){
var inst_41472 = (state_41694[(10)]);
var state_41694__$1 = state_41694;
var statearr_41714_41832 = state_41694__$1;
(statearr_41714_41832[(2)] = inst_41472);

(statearr_41714_41832[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (55))){
var inst_41626 = (state_41694[(2)]);
var state_41694__$1 = state_41694;
var statearr_41715_41833 = state_41694__$1;
(statearr_41715_41833[(2)] = inst_41626);

(statearr_41715_41833[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (39))){
var inst_41634 = (state_41694[(2)]);
var state_41694__$1 = state_41694;
var statearr_41716_41834 = state_41694__$1;
(statearr_41716_41834[(2)] = inst_41634);

(statearr_41716_41834[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (46))){
var inst_41498 = (state_41694[(14)]);
var inst_41516 = (state_41694[(15)]);
var inst_41592 = inst_41516.call(null,cljs.core._LT_,inst_41498);
var state_41694__$1 = state_41694;
if(cljs.core.truth_(inst_41592)){
var statearr_41717_41835 = state_41694__$1;
(statearr_41717_41835[(1)] = (49));

} else {
var statearr_41718_41836 = state_41694__$1;
(statearr_41718_41836[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (4))){
var inst_41431 = (state_41694[(2)]);
var state_41694__$1 = state_41694;
var statearr_41719_41837 = state_41694__$1;
(statearr_41719_41837[(2)] = inst_41431);

(statearr_41719_41837[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (77))){
var inst_41682 = (state_41694[(2)]);
var state_41694__$1 = state_41694;
var statearr_41720_41838 = state_41694__$1;
(statearr_41720_41838[(2)] = inst_41682);

(statearr_41720_41838[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (54))){
var inst_41624 = cljs.core.PersistentVector.EMPTY;
var state_41694__$1 = state_41694;
var statearr_41721_41839 = state_41694__$1;
(statearr_41721_41839[(2)] = inst_41624);

(statearr_41721_41839[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (15))){
var inst_41442 = (state_41694[(16)]);
var inst_41467 = cljs.core.seq.call(null,inst_41442);
var inst_41468 = cljs.core.first.call(null,inst_41467);
var inst_41469 = cljs.core.next.call(null,inst_41467);
var inst_41470 = cljs.core.PersistentHashSet.EMPTY;
var inst_41471 = inst_41442;
var inst_41472 = inst_41470;
var state_41694__$1 = (function (){var statearr_41722 = state_41694;
(statearr_41722[(17)] = inst_41471);

(statearr_41722[(18)] = inst_41468);

(statearr_41722[(19)] = inst_41469);

(statearr_41722[(10)] = inst_41472);

return statearr_41722;
})();
var statearr_41723_41840 = state_41694__$1;
(statearr_41723_41840[(2)] = null);

(statearr_41723_41840[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (48))){
var inst_41589 = (state_41694[(2)]);
var inst_41590 = fluree.db.util.async.throw_err.call(null,inst_41589);
var state_41694__$1 = state_41694;
var statearr_41724_41841 = state_41694__$1;
(statearr_41724_41841[(2)] = inst_41590);

(statearr_41724_41841[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (50))){
var inst_41498 = (state_41694[(14)]);
var inst_41516 = (state_41694[(15)]);
var inst_41608 = inst_41516.call(null,cljs.core._LT__EQ_,inst_41498);
var state_41694__$1 = state_41694;
if(cljs.core.truth_(inst_41608)){
var statearr_41725_41842 = state_41694__$1;
(statearr_41725_41842[(1)] = (53));

} else {
var statearr_41726_41843 = state_41694__$1;
(statearr_41726_41843[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (75))){
var state_41694__$1 = state_41694;
if(cljs.core.truth_(offset)){
var statearr_41727_41844 = state_41694__$1;
(statearr_41727_41844[(1)] = (78));

} else {
var statearr_41728_41845 = state_41694__$1;
(statearr_41728_41845[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (21))){
var inst_41497 = (state_41694[(20)]);
var inst_41478 = (state_41694[(21)]);
var inst_41497__$1 = cljs.core.nth.call(null,inst_41478,(0),null);
var inst_41498 = cljs.core.nth.call(null,inst_41478,(1),null);
var inst_41499 = cljs.core.nth.call(null,inst_41478,(2),null);
var inst_41500 = fluree.db.query.fql.valid_where_predicate_QMARK_.call(null,db,inst_41497__$1);
var inst_41501 = cljs.core.not.call(null,inst_41500);
var state_41694__$1 = (function (){var statearr_41729 = state_41694;
(statearr_41729[(20)] = inst_41497__$1);

(statearr_41729[(14)] = inst_41498);

(statearr_41729[(22)] = inst_41499);

return statearr_41729;
})();
if(inst_41501){
var statearr_41730_41846 = state_41694__$1;
(statearr_41730_41846[(1)] = (29));

} else {
var statearr_41731_41847 = state_41694__$1;
(statearr_41731_41847[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (31))){
var inst_41498 = (state_41694[(14)]);
var inst_41516 = (state_41694[(15)]);
var inst_41512 = (state_41694[(2)]);
var inst_41516__$1 = cljs.core.identical_QMARK_;
var inst_41517 = inst_41516__$1.call(null,cljs.core.not_EQ_,inst_41498);
var state_41694__$1 = (function (){var statearr_41732 = state_41694;
(statearr_41732[(23)] = inst_41512);

(statearr_41732[(15)] = inst_41516__$1);

return statearr_41732;
})();
if(cljs.core.truth_(inst_41517)){
var statearr_41733_41848 = state_41694__$1;
(statearr_41733_41848[(1)] = (32));

} else {
var statearr_41734_41849 = state_41694__$1;
(statearr_41734_41849[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (32))){
var inst_41457 = (state_41694[(11)]);
var inst_41497 = (state_41694[(20)]);
var inst_41499 = (state_41694[(22)]);
var inst_41519 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41520 = [inst_41497,inst_41499];
var inst_41521 = (new cljs.core.PersistentVector(null,2,(5),inst_41519,inst_41520,null));
var inst_41522 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41523 = [inst_41497];
var inst_41524 = (new cljs.core.PersistentVector(null,1,(5),inst_41522,inst_41523,null));
var inst_41525 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_41526 = [inst_41457];
var inst_41527 = cljs.core.PersistentHashMap.fromArrays(inst_41525,inst_41526);
var inst_41528 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_41521,cljs.core._LT__EQ_,inst_41524,inst_41527);
var state_41694__$1 = state_41694;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41694__$1,(35),inst_41528);
} else {
if((state_val_41695 === (40))){
var inst_41557 = (state_41694[(2)]);
var inst_41558 = fluree.db.util.async.throw_err.call(null,inst_41557);
var state_41694__$1 = state_41694;
var statearr_41735_41850 = state_41694__$1;
(statearr_41735_41850[(2)] = inst_41558);

(statearr_41735_41850[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (56))){
var inst_41621 = (state_41694[(2)]);
var inst_41622 = fluree.db.util.async.throw_err.call(null,inst_41621);
var state_41694__$1 = state_41694;
var statearr_41736_41851 = state_41694__$1;
(statearr_41736_41851[(2)] = inst_41622);

(statearr_41736_41851[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (33))){
var inst_41498 = (state_41694[(14)]);
var inst_41516 = (state_41694[(15)]);
var inst_41547 = inst_41516.call(null,cljs.core._EQ_,inst_41498);
var state_41694__$1 = state_41694;
if(cljs.core.truth_(inst_41547)){
var statearr_41737_41852 = state_41694__$1;
(statearr_41737_41852[(1)] = (37));

} else {
var statearr_41738_41853 = state_41694__$1;
(statearr_41738_41853[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (13))){
var state_41694__$1 = state_41694;
var statearr_41739_41854 = state_41694__$1;
(statearr_41739_41854[(2)] = limit);

(statearr_41739_41854[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (22))){
var inst_41684 = (state_41694[(2)]);
var state_41694__$1 = state_41694;
var statearr_41740_41855 = state_41694__$1;
(statearr_41740_41855[(2)] = inst_41684);

(statearr_41740_41855[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (36))){
var inst_41531 = (state_41694[(24)]);
var inst_41543 = (state_41694[(2)]);
var inst_41544 = fluree.db.util.async.throw_err.call(null,inst_41543);
var inst_41545 = cljs.core.concat.call(null,inst_41531,inst_41544);
var state_41694__$1 = state_41694;
var statearr_41741_41856 = state_41694__$1;
(statearr_41741_41856[(2)] = inst_41545);

(statearr_41741_41856[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (41))){
var inst_41457 = (state_41694[(11)]);
var inst_41497 = (state_41694[(20)]);
var inst_41499 = (state_41694[(22)]);
var inst_41562 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41563 = [inst_41497,inst_41499];
var inst_41564 = (new cljs.core.PersistentVector(null,2,(5),inst_41562,inst_41563,null));
var inst_41565 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41566 = [inst_41497];
var inst_41567 = (new cljs.core.PersistentVector(null,1,(5),inst_41565,inst_41566,null));
var inst_41568 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_41569 = [inst_41457];
var inst_41570 = cljs.core.PersistentHashMap.fromArrays(inst_41568,inst_41569);
var inst_41571 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_41564,cljs.core._LT__EQ_,inst_41567,inst_41570);
var state_41694__$1 = state_41694;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41694__$1,(44),inst_41571);
} else {
if((state_val_41695 === (43))){
var inst_41632 = (state_41694[(2)]);
var state_41694__$1 = state_41694;
var statearr_41742_41857 = state_41694__$1;
(statearr_41742_41857[(2)] = inst_41632);

(statearr_41742_41857[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (61))){
var inst_41637 = (state_41694[(12)]);
var inst_41472 = (state_41694[(10)]);
var inst_41644 = cljs.core.PersistentHashSet.EMPTY;
var inst_41645 = cljs.core.into.call(null,inst_41644,inst_41637);
var inst_41646 = clojure.set.intersection.call(null,inst_41472,inst_41645);
var state_41694__$1 = state_41694;
var statearr_41743_41858 = state_41694__$1;
(statearr_41743_41858[(2)] = inst_41646);

(statearr_41743_41858[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (29))){
var inst_41497 = (state_41694[(20)]);
var inst_41503 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_41497);
var inst_41504 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_41503)].join('');
var inst_41505 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_41506 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_41507 = cljs.core.PersistentHashMap.fromArrays(inst_41505,inst_41506);
var inst_41508 = cljs.core.ex_info.call(null,inst_41504,inst_41507);
var inst_41509 = (function(){throw inst_41508})();
var state_41694__$1 = state_41694;
var statearr_41744_41859 = state_41694__$1;
(statearr_41744_41859[(2)] = inst_41509);

(statearr_41744_41859[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (44))){
var inst_41573 = (state_41694[(2)]);
var inst_41574 = fluree.db.util.async.throw_err.call(null,inst_41573);
var state_41694__$1 = state_41694;
var statearr_41745_41860 = state_41694__$1;
(statearr_41745_41860[(2)] = inst_41574);

(statearr_41745_41860[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (6))){
var inst_41441 = (state_41694[(25)]);
var inst_41445 = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"and","and",-971899817),inst_41441);
var state_41694__$1 = state_41694;
var statearr_41746_41861 = state_41694__$1;
(statearr_41746_41861[(2)] = inst_41445);

(statearr_41746_41861[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (28))){
var inst_41492 = (state_41694[(2)]);
var state_41694__$1 = state_41694;
var statearr_41747_41862 = state_41694__$1;
(statearr_41747_41862[(2)] = inst_41492);

(statearr_41747_41862[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (64))){
var inst_41652 = (state_41694[(26)]);
var state_41694__$1 = state_41694;
var statearr_41748_41863 = state_41694__$1;
(statearr_41748_41863[(2)] = inst_41652);

(statearr_41748_41863[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (51))){
var inst_41628 = (state_41694[(2)]);
var state_41694__$1 = state_41694;
var statearr_41749_41864 = state_41694__$1;
(statearr_41749_41864[(2)] = inst_41628);

(statearr_41749_41864[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (25))){
var inst_41487 = (state_41694[(2)]);
var state_41694__$1 = (function (){var statearr_41750 = state_41694;
(statearr_41750[(13)] = inst_41487);

return statearr_41750;
})();
if(cljs.core.truth_(limit)){
var statearr_41751_41865 = state_41694__$1;
(statearr_41751_41865[(1)] = (26));

} else {
var statearr_41752_41866 = state_41694__$1;
(statearr_41752_41866[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (34))){
var inst_41441 = (state_41694[(25)]);
var inst_41636 = (state_41694[(2)]);
var inst_41637 = cljs.core.map.call(null,fluree.db.query.fql.s,inst_41636);
var state_41694__$1 = (function (){var statearr_41753 = state_41694;
(statearr_41753[(12)] = inst_41637);

return statearr_41753;
})();
var G__41754_41867 = inst_41441;
var G__41754_41868__$1 = (((G__41754_41867 instanceof cljs.core.Keyword))?G__41754_41867.fqn:null);
switch (G__41754_41868__$1) {
case "or":
var statearr_41755_41870 = state_41694__$1;
(statearr_41755_41870[(1)] = (58));


break;
case "and":
var statearr_41756_41871 = state_41694__$1;
(statearr_41756_41871[(1)] = (59));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__41754_41868__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (17))){
var inst_41689 = (state_41694[(2)]);
var _ = (function (){var statearr_41757 = state_41694;
(statearr_41757[(4)] = cljs.core.rest.call(null,(state_41694[(4)])));

return statearr_41757;
})();
var state_41694__$1 = state_41694;
var statearr_41758_41872 = state_41694__$1;
(statearr_41758_41872[(2)] = inst_41689);

(statearr_41758_41872[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (3))){
var inst_41692 = (state_41694[(2)]);
var state_41694__$1 = state_41694;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_41694__$1,inst_41692);
} else {
if((state_val_41695 === (12))){
var inst_41451 = (offset + limit);
var state_41694__$1 = state_41694;
var statearr_41759_41873 = state_41694__$1;
(statearr_41759_41873[(2)] = inst_41451);

(statearr_41759_41873[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (2))){
var inst_41443 = (state_41694[(9)]);
var _ = (function (){var statearr_41760 = state_41694;
(statearr_41760[(4)] = cljs.core.cons.call(null,(5),(state_41694[(4)])));

return statearr_41760;
})();
var inst_41440 = fluree.db.query.fql_parser.parse_where.call(null,db,where_clause,default_collection);
var inst_41441 = cljs.core.nth.call(null,inst_41440,(0),null);
var inst_41442 = cljs.core.nth.call(null,inst_41440,(1),null);
var inst_41443__$1 = limit;
var state_41694__$1 = (function (){var statearr_41761 = state_41694;
(statearr_41761[(16)] = inst_41442);

(statearr_41761[(25)] = inst_41441);

(statearr_41761[(9)] = inst_41443__$1);

return statearr_41761;
})();
if(cljs.core.truth_(inst_41443__$1)){
var statearr_41762_41874 = state_41694__$1;
(statearr_41762_41874[(1)] = (6));

} else {
var statearr_41763_41875 = state_41694__$1;
(statearr_41763_41875[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (66))){
var inst_41657 = (state_41694[(7)]);
var state_41694__$1 = state_41694;
var statearr_41764_41876 = state_41694__$1;
(statearr_41764_41876[(2)] = inst_41657);

(statearr_41764_41876[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (23))){
var inst_41472 = (state_41694[(10)]);
var inst_41484 = cljs.core.drop.call(null,offset,inst_41472);
var state_41694__$1 = state_41694;
var statearr_41765_41877 = state_41694__$1;
(statearr_41765_41877[(2)] = inst_41484);

(statearr_41765_41877[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (47))){
var inst_41630 = (state_41694[(2)]);
var state_41694__$1 = state_41694;
var statearr_41766_41878 = state_41694__$1;
(statearr_41766_41878[(2)] = inst_41630);

(statearr_41766_41878[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (35))){
var inst_41457 = (state_41694[(11)]);
var inst_41497 = (state_41694[(20)]);
var inst_41499 = (state_41694[(22)]);
var inst_41530 = (state_41694[(2)]);
var inst_41531 = fluree.db.util.async.throw_err.call(null,inst_41530);
var inst_41532 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41533 = [inst_41497];
var inst_41534 = (new cljs.core.PersistentVector(null,1,(5),inst_41532,inst_41533,null));
var inst_41535 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41536 = [inst_41497,inst_41499];
var inst_41537 = (new cljs.core.PersistentVector(null,2,(5),inst_41535,inst_41536,null));
var inst_41538 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_41539 = [inst_41457];
var inst_41540 = cljs.core.PersistentHashMap.fromArrays(inst_41538,inst_41539);
var inst_41541 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_41534,cljs.core._LT_,inst_41537,inst_41540);
var state_41694__$1 = (function (){var statearr_41767 = state_41694;
(statearr_41767[(24)] = inst_41531);

return statearr_41767;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41694__$1,(36),inst_41541);
} else {
if((state_val_41695 === (76))){
var inst_41479 = (state_41694[(27)]);
var inst_41651 = (state_41694[(28)]);
var inst_41471 = inst_41479;
var inst_41472 = inst_41651;
var state_41694__$1 = (function (){var statearr_41768 = state_41694;
(statearr_41768[(17)] = inst_41471);

(statearr_41768[(10)] = inst_41472);

return statearr_41768;
})();
var statearr_41769_41879 = state_41694__$1;
(statearr_41769_41879[(2)] = null);

(statearr_41769_41879[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (19))){
var inst_41686 = (state_41694[(2)]);
var state_41694__$1 = state_41694;
var statearr_41770_41880 = state_41694__$1;
(statearr_41770_41880[(2)] = inst_41686);

(statearr_41770_41880[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (57))){
var inst_41652 = (state_41694[(26)]);
var inst_41441 = (state_41694[(25)]);
var inst_41651 = (state_41694[(2)]);
var inst_41652__$1 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"and","and",-971899817),inst_41441);
var state_41694__$1 = (function (){var statearr_41771 = state_41694;
(statearr_41771[(26)] = inst_41652__$1);

(statearr_41771[(28)] = inst_41651);

return statearr_41771;
})();
if(inst_41652__$1){
var statearr_41772_41881 = state_41694__$1;
(statearr_41772_41881[(1)] = (63));

} else {
var statearr_41773_41882 = state_41694__$1;
(statearr_41773_41882[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (68))){
var inst_41672 = (state_41694[(2)]);
var state_41694__$1 = state_41694;
if(cljs.core.truth_(inst_41672)){
var statearr_41774_41883 = state_41694__$1;
(statearr_41774_41883[(1)] = (75));

} else {
var statearr_41775_41884 = state_41694__$1;
(statearr_41775_41884[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (11))){
var inst_41442 = (state_41694[(16)]);
var inst_41457 = (state_41694[(2)]);
var inst_41458 = cljs.core.not_empty.call(null,inst_41442);
var state_41694__$1 = (function (){var statearr_41777 = state_41694;
(statearr_41777[(11)] = inst_41457);

return statearr_41777;
})();
if(cljs.core.truth_(inst_41458)){
var statearr_41778_41885 = state_41694__$1;
(statearr_41778_41885[(1)] = (15));

} else {
var statearr_41779_41886 = state_41694__$1;
(statearr_41779_41886[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (9))){
var state_41694__$1 = state_41694;
if(cljs.core.truth_(offset)){
var statearr_41780_41887 = state_41694__$1;
(statearr_41780_41887[(1)] = (12));

} else {
var statearr_41781_41888 = state_41694__$1;
(statearr_41781_41888[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (5))){
var _ = (function (){var statearr_41782 = state_41694;
(statearr_41782[(4)] = cljs.core.rest.call(null,(state_41694[(4)])));

return statearr_41782;
})();
var state_41694__$1 = state_41694;
var ex41776 = (state_41694__$1[(2)]);
var statearr_41783_41889 = state_41694__$1;
(statearr_41783_41889[(5)] = ex41776);


if((ex41776 instanceof Error)){
var statearr_41784_41890 = state_41694__$1;
(statearr_41784_41890[(1)] = (4));

(statearr_41784_41890[(5)] = null);

} else {
throw ex41776;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (14))){
var inst_41454 = (state_41694[(2)]);
var state_41694__$1 = state_41694;
var statearr_41785_41891 = state_41694__$1;
(statearr_41785_41891[(2)] = inst_41454);

(statearr_41785_41891[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (45))){
var inst_41457 = (state_41694[(11)]);
var inst_41497 = (state_41694[(20)]);
var inst_41499 = (state_41694[(22)]);
var inst_41578 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41579 = [inst_41497,inst_41499];
var inst_41580 = (new cljs.core.PersistentVector(null,2,(5),inst_41578,inst_41579,null));
var inst_41581 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41582 = [inst_41497];
var inst_41583 = (new cljs.core.PersistentVector(null,1,(5),inst_41581,inst_41582,null));
var inst_41584 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_41585 = [inst_41457];
var inst_41586 = cljs.core.PersistentHashMap.fromArrays(inst_41584,inst_41585);
var inst_41587 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_41580,cljs.core._LT__EQ_,inst_41583,inst_41586);
var state_41694__$1 = state_41694;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41694__$1,(48),inst_41587);
} else {
if((state_val_41695 === (53))){
var inst_41457 = (state_41694[(11)]);
var inst_41497 = (state_41694[(20)]);
var inst_41499 = (state_41694[(22)]);
var inst_41610 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41611 = [inst_41497];
var inst_41612 = (new cljs.core.PersistentVector(null,1,(5),inst_41610,inst_41611,null));
var inst_41613 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41614 = [inst_41497,inst_41499];
var inst_41615 = (new cljs.core.PersistentVector(null,2,(5),inst_41613,inst_41614,null));
var inst_41616 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_41617 = [inst_41457];
var inst_41618 = cljs.core.PersistentHashMap.fromArrays(inst_41616,inst_41617);
var inst_41619 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_41612,cljs.core._LT__EQ_,inst_41615,inst_41618);
var state_41694__$1 = state_41694;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41694__$1,(56),inst_41619);
} else {
if((state_val_41695 === (78))){
var inst_41651 = (state_41694[(28)]);
var inst_41675 = cljs.core.drop.call(null,offset,inst_41651);
var state_41694__$1 = state_41694;
var statearr_41786_41892 = state_41694__$1;
(statearr_41786_41892[(2)] = inst_41675);

(statearr_41786_41892[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (26))){
var inst_41487 = (state_41694[(13)]);
var inst_41489 = cljs.core.take.call(null,limit,inst_41487);
var state_41694__$1 = state_41694;
var statearr_41787_41893 = state_41694__$1;
(statearr_41787_41893[(2)] = inst_41489);

(statearr_41787_41893[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (16))){
var state_41694__$1 = state_41694;
var statearr_41788_41894 = state_41694__$1;
(statearr_41788_41894[(2)] = null);

(statearr_41788_41894[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (79))){
var inst_41651 = (state_41694[(28)]);
var state_41694__$1 = state_41694;
var statearr_41789_41895 = state_41694__$1;
(statearr_41789_41895[(2)] = inst_41651);

(statearr_41789_41895[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (38))){
var inst_41498 = (state_41694[(14)]);
var inst_41516 = (state_41694[(15)]);
var inst_41560 = inst_41516.call(null,cljs.core._GT_,inst_41498);
var state_41694__$1 = state_41694;
if(cljs.core.truth_(inst_41560)){
var statearr_41790_41896 = state_41694__$1;
(statearr_41790_41896[(1)] = (41));

} else {
var statearr_41791_41897 = state_41694__$1;
(statearr_41791_41897[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (30))){
var state_41694__$1 = state_41694;
var statearr_41792_41898 = state_41694__$1;
(statearr_41792_41898[(2)] = null);

(statearr_41792_41898[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (73))){
var inst_41457 = (state_41694[(11)]);
var state_41694__$1 = state_41694;
var statearr_41793_41899 = state_41694__$1;
(statearr_41793_41899[(2)] = inst_41457);

(statearr_41793_41899[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (10))){
var state_41694__$1 = state_41694;
var statearr_41794_41900 = state_41694__$1;
(statearr_41794_41900[(2)] = null);

(statearr_41794_41900[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (18))){
var inst_41471 = (state_41694[(17)]);
var inst_41478 = (state_41694[(21)]);
var inst_41477 = cljs.core.seq.call(null,inst_41471);
var inst_41478__$1 = cljs.core.first.call(null,inst_41477);
var inst_41479 = cljs.core.next.call(null,inst_41477);
var inst_41480 = cljs.core.not.call(null,inst_41478__$1);
var state_41694__$1 = (function (){var statearr_41795 = state_41694;
(statearr_41795[(27)] = inst_41479);

(statearr_41795[(21)] = inst_41478__$1);

return statearr_41795;
})();
if(inst_41480){
var statearr_41796_41901 = state_41694__$1;
(statearr_41796_41901[(1)] = (20));

} else {
var statearr_41797_41902 = state_41694__$1;
(statearr_41797_41902[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (52))){
var inst_41605 = (state_41694[(2)]);
var inst_41606 = fluree.db.util.async.throw_err.call(null,inst_41605);
var state_41694__$1 = state_41694;
var statearr_41798_41903 = state_41694__$1;
(statearr_41798_41903[(2)] = inst_41606);

(statearr_41798_41903[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (67))){
var inst_41660 = (state_41694[(8)]);
var inst_41441 = (state_41694[(25)]);
var inst_41660__$1 = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"and","and",-971899817),inst_41441);
var state_41694__$1 = (function (){var statearr_41799 = state_41694;
(statearr_41799[(8)] = inst_41660__$1);

return statearr_41799;
})();
if(inst_41660__$1){
var statearr_41800_41904 = state_41694__$1;
(statearr_41800_41904[(1)] = (69));

} else {
var statearr_41801_41905 = state_41694__$1;
(statearr_41801_41905[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (71))){
var inst_41670 = (state_41694[(2)]);
var state_41694__$1 = state_41694;
var statearr_41802_41906 = state_41694__$1;
(statearr_41802_41906[(2)] = inst_41670);

(statearr_41802_41906[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (42))){
var inst_41498 = (state_41694[(14)]);
var inst_41516 = (state_41694[(15)]);
var inst_41576 = inst_41516.call(null,cljs.core._GT__EQ_,inst_41498);
var state_41694__$1 = state_41694;
if(cljs.core.truth_(inst_41576)){
var statearr_41803_41907 = state_41694__$1;
(statearr_41803_41907[(1)] = (45));

} else {
var statearr_41804_41908 = state_41694__$1;
(statearr_41804_41908[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (80))){
var inst_41678 = (state_41694[(2)]);
var state_41694__$1 = state_41694;
var statearr_41805_41909 = state_41694__$1;
(statearr_41805_41909[(2)] = inst_41678);

(statearr_41805_41909[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (37))){
var inst_41457 = (state_41694[(11)]);
var inst_41497 = (state_41694[(20)]);
var inst_41499 = (state_41694[(22)]);
var inst_41549 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41550 = [inst_41497,inst_41499];
var inst_41551 = (new cljs.core.PersistentVector(null,2,(5),inst_41549,inst_41550,null));
var inst_41552 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_41553 = [inst_41457];
var inst_41554 = cljs.core.PersistentHashMap.fromArrays(inst_41552,inst_41553);
var inst_41555 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_41551,inst_41554);
var state_41694__$1 = state_41694;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41694__$1,(40),inst_41555);
} else {
if((state_val_41695 === (63))){
var inst_41651 = (state_41694[(28)]);
var inst_41654 = cljs.core.empty_QMARK_.call(null,inst_41651);
var state_41694__$1 = state_41694;
var statearr_41806_41910 = state_41694__$1;
(statearr_41806_41910[(2)] = inst_41654);

(statearr_41806_41910[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (8))){
var inst_41448 = (state_41694[(2)]);
var state_41694__$1 = state_41694;
if(cljs.core.truth_(inst_41448)){
var statearr_41807_41911 = state_41694__$1;
(statearr_41807_41911[(1)] = (9));

} else {
var statearr_41808_41912 = state_41694__$1;
(statearr_41808_41912[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41695 === (49))){
var inst_41457 = (state_41694[(11)]);
var inst_41497 = (state_41694[(20)]);
var inst_41499 = (state_41694[(22)]);
var inst_41594 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41595 = [inst_41497];
var inst_41596 = (new cljs.core.PersistentVector(null,1,(5),inst_41594,inst_41595,null));
var inst_41597 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41598 = [inst_41497,inst_41499];
var inst_41599 = (new cljs.core.PersistentVector(null,2,(5),inst_41597,inst_41598,null));
var inst_41600 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_41601 = [inst_41457];
var inst_41602 = cljs.core.PersistentHashMap.fromArrays(inst_41600,inst_41601);
var inst_41603 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_41596,cljs.core._LT_,inst_41599,inst_41602);
var state_41694__$1 = state_41694;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41694__$1,(52),inst_41603);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16221__auto__ = null;
var fluree$db$query$fql$state_machine__16221__auto____0 = (function (){
var statearr_41809 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41809[(0)] = fluree$db$query$fql$state_machine__16221__auto__);

(statearr_41809[(1)] = (1));

return statearr_41809;
});
var fluree$db$query$fql$state_machine__16221__auto____1 = (function (state_41694){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_41694);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e41810){var ex__16224__auto__ = e41810;
var statearr_41811_41913 = state_41694;
(statearr_41811_41913[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_41694[(4)]))){
var statearr_41812_41914 = state_41694;
(statearr_41812_41914[(1)] = cljs.core.first.call(null,(state_41694[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41915 = state_41694;
state_41694 = G__41915;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16221__auto__ = function(state_41694){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16221__auto____1.call(this,state_41694);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16221__auto____0;
fluree$db$query$fql$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16221__auto____1;
return fluree$db$query$fql$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_41813 = f__16346__auto__.call(null);
(statearr_41813[(6)] = c__16345__auto__);

return statearr_41813;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 4);

fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,cljs.core.keys.call(null,x))))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var var_as_symbol = cljs.core.symbol.call(null,cljs.core.first.call(null,cljs.core.keys.call(null,x)));
var ___$1 = (cljs.core.truth_(valid_var.call(null,var_as_symbol))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_as_symbol,new cljs.core.Keyword(null,"selection","selection",975998651),cljs.core.first.call(null,cljs.core.vals.call(null,x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4212__auto__ = cljs.core.every_QMARK_.call(null,(function (p1__41916_SHARP_){
return ((typeof p1__41916_SHARP_ === 'string') || (cljs.core.map_QMARK_.call(null,p1__41916_SHARP_)));
}),select_smt);
if(or__4212__auto__){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vars__$1 = cljs.core.set.call(null,vars);
var all_vars = cljs.core.set.call(null,cljs.core.concat.call(null,vars__$1,cljs.core.keys.call(null,interim_vars)));
return cljs.core.map.call(null,(function (select){
var var_symbol = ((cljs.core.map_QMARK_.call(null,select))?null:cljs.core.symbol.call(null,select));
if(cljs.core.truth_(vars__$1.call(null,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_.call(null,select))){
return fluree.db.query.analytical.parse_aggregate.call(null,select,vars__$1);
} else {
if(cljs.core.map_QMARK_.call(null,select)){
return fluree.db.query.fql.parse_map.call(null,select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.call(null,interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.get.call(null,interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.call(null,(function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies.call(null,vars);
if(cljs.core.every_QMARK_.call(null,(function (p1__41917_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__41917_SHARP_);
}),cljs.core.vals.call(null,freqs))){
return vars;
} else {
var G__41921 = vars;
var vec__41922 = G__41921;
var seq__41923 = cljs.core.seq.call(null,vec__41922);
var first__41924 = cljs.core.first.call(null,seq__41923);
var seq__41923__$1 = cljs.core.next.call(null,seq__41923);
var var$ = first__41924;
var r = seq__41923__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__41921__$1 = G__41921;
var all_vars__$1 = all_vars;
while(true){
var vec__41928 = G__41921__$1;
var seq__41929 = cljs.core.seq.call(null,vec__41928);
var first__41930 = cljs.core.first.call(null,seq__41929);
var seq__41929__$1 = cljs.core.next.call(null,seq__41929);
var var$__$1 = first__41930;
var r__$1 = seq__41929__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not.call(null,var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_(cljs.core.set.call(null,all_vars__$2).call(null,var$__$1))){
var G__41931 = r__$1;
var G__41932 = cljs.core.conj.call(null,all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,all_vars__$2))].join(''));
G__41921__$1 = G__41931;
all_vars__$1 = G__41932;
continue;
} else {
var G__41933 = r__$1;
var G__41934 = cljs.core.conj.call(null,all_vars__$2,var$__$1);
G__41921__$1 = G__41933;
all_vars__$1 = G__41934;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_41969){
var state_val_41970 = (state_41969[(1)]);
if((state_val_41970 === (1))){
var inst_41942 = functionArray;
var inst_41943 = cljs.core.seq.call(null,inst_41942);
var inst_41944 = cljs.core.first.call(null,inst_41943);
var inst_41945 = cljs.core.next.call(null,inst_41943);
var inst_41946 = cljs.core.PersistentVector.EMPTY;
var inst_41947 = inst_41942;
var inst_41948 = inst_41946;
var state_41969__$1 = (function (){var statearr_41971 = state_41969;
(statearr_41971[(7)] = inst_41945);

(statearr_41971[(8)] = inst_41948);

(statearr_41971[(9)] = inst_41947);

(statearr_41971[(10)] = inst_41944);

return statearr_41971;
})();
var statearr_41972_41985 = state_41969__$1;
(statearr_41972_41985[(2)] = null);

(statearr_41972_41985[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41970 === (2))){
var inst_41947 = (state_41969[(9)]);
var inst_41954 = (state_41969[(11)]);
var inst_41953 = cljs.core.seq.call(null,inst_41947);
var inst_41954__$1 = cljs.core.first.call(null,inst_41953);
var inst_41955 = cljs.core.next.call(null,inst_41953);
var state_41969__$1 = (function (){var statearr_41973 = state_41969;
(statearr_41973[(11)] = inst_41954__$1);

(statearr_41973[(12)] = inst_41955);

return statearr_41973;
})();
if(cljs.core.truth_(inst_41954__$1)){
var statearr_41974_41986 = state_41969__$1;
(statearr_41974_41986[(1)] = (4));

} else {
var statearr_41975_41987 = state_41969__$1;
(statearr_41975_41987[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41970 === (3))){
var inst_41967 = (state_41969[(2)]);
var state_41969__$1 = state_41969;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_41969__$1,inst_41967);
} else {
if((state_val_41970 === (4))){
var inst_41954 = (state_41969[(11)]);
var inst_41957 = inst_41954.call(null,tuple);
var state_41969__$1 = state_41969;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41969__$1,(7),inst_41957);
} else {
if((state_val_41970 === (5))){
var inst_41948 = (state_41969[(8)]);
var state_41969__$1 = state_41969;
var statearr_41976_41988 = state_41969__$1;
(statearr_41976_41988[(2)] = inst_41948);

(statearr_41976_41988[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41970 === (6))){
var inst_41965 = (state_41969[(2)]);
var state_41969__$1 = state_41969;
var statearr_41977_41989 = state_41969__$1;
(statearr_41977_41989[(2)] = inst_41965);

(statearr_41977_41989[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41970 === (7))){
var inst_41948 = (state_41969[(8)]);
var inst_41955 = (state_41969[(12)]);
var inst_41959 = (state_41969[(2)]);
var inst_41960 = fluree.db.util.async.throw_err.call(null,inst_41959);
var inst_41961 = cljs.core.conj.call(null,inst_41948,inst_41960);
var inst_41947 = inst_41955;
var inst_41948__$1 = inst_41961;
var state_41969__$1 = (function (){var statearr_41978 = state_41969;
(statearr_41978[(8)] = inst_41948__$1);

(statearr_41978[(9)] = inst_41947);

return statearr_41978;
})();
var statearr_41979_41990 = state_41969__$1;
(statearr_41979_41990[(2)] = null);

(statearr_41979_41990[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__16221__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__16221__auto____0 = (function (){
var statearr_41980 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41980[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__16221__auto__);

(statearr_41980[(1)] = (1));

return statearr_41980;
});
var fluree$db$query$fql$format_tuple_$_state_machine__16221__auto____1 = (function (state_41969){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_41969);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e41981){var ex__16224__auto__ = e41981;
var statearr_41982_41991 = state_41969;
(statearr_41982_41991[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_41969[(4)]))){
var statearr_41983_41992 = state_41969;
(statearr_41983_41992[(1)] = cljs.core.first.call(null,(state_41969[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41993 = state_41969;
state_41969 = G__41993;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__16221__auto__ = function(state_41969){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__16221__auto____1.call(this,state_41969);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__16221__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__16221__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_41984 = f__16346__auto__.call(null);
(statearr_41984[(6)] = c__16345__auto__);

return statearr_41984;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,cljs.core.map.call(null,cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.call(null,(function (idx,select_item){
var temp__5753__auto__ = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5753__auto__)){
var query_map = temp__5753__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.call(null,pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__41994){
var vec__41995 = p__41994;
var tuple_index = cljs.core.nth.call(null,vec__41995,(0),null);
var query_map = cljs.core.nth.call(null,vec__41995,(1),null);
var temp__5753__auto__ = cljs.core.get.call(null,tuple_result,tuple_index);
if(cljs.core.truth_(temp__5753__auto__)){
var _id = temp__5753__auto__;
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_42009){
var state_val_42010 = (state_42009[(1)]);
if((state_val_42010 === (1))){
var inst_41998 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41999 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_42000 = [query_map,_id,query_opts];
var inst_42001 = cljs.core.PersistentHashMap.fromArrays(inst_41999,inst_42000);
var inst_42002 = fluree.db.query.fql.query.call(null,db,inst_42001);
var state_42009__$1 = (function (){var statearr_42011 = state_42009;
(statearr_42011[(7)] = inst_41998);

return statearr_42011;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42009__$1,(2),inst_42002);
} else {
if((state_val_42010 === (2))){
var inst_41998 = (state_42009[(7)]);
var inst_42004 = (state_42009[(2)]);
var inst_42005 = fluree.db.util.async.throw_err.call(null,inst_42004);
var inst_42006 = [tuple_index,inst_42005];
var inst_42007 = (new cljs.core.PersistentVector(null,2,(5),inst_41998,inst_42006,null));
var state_42009__$1 = state_42009;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42009__$1,inst_42007);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__16221__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__16221__auto____0 = (function (){
var statearr_42012 = [null,null,null,null,null,null,null,null];
(statearr_42012[(0)] = fluree$db$query$fql$expand_map_$_state_machine__16221__auto__);

(statearr_42012[(1)] = (1));

return statearr_42012;
});
var fluree$db$query$fql$expand_map_$_state_machine__16221__auto____1 = (function (state_42009){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_42009);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e42013){var ex__16224__auto__ = e42013;
var statearr_42014_42017 = state_42009;
(statearr_42014_42017[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_42009[(4)]))){
var statearr_42015_42018 = state_42009;
(statearr_42015_42018[(1)] = cljs.core.first.call(null,(state_42009[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42019 = state_42009;
state_42009 = G__42019;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__16221__auto__ = function(state_42009){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__16221__auto____1.call(this,state_42009);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__16221__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__16221__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_42016 = f__16346__auto__.call(null);
(statearr_42016[(6)] = c__16345__auto__);

return statearr_42016;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_.call(null,expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__42020 = expand_map_tuple;
var tuple_index = cljs.core.nth.call(null,vec__42020,(0),null);
var query_map_result = cljs.core.nth.call(null,vec__42020,(1),null);
return cljs.core.assoc.call(null,tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_42083){
var state_val_42084 = (state_42083[(1)]);
if((state_val_42084 === (7))){
var inst_42078 = (state_42083[(2)]);
var _ = (function (){var statearr_42085 = state_42083;
(statearr_42085[(4)] = cljs.core.rest.call(null,(state_42083[(4)])));

return statearr_42085;
})();
var state_42083__$1 = state_42083;
var statearr_42086_42177 = state_42083__$1;
(statearr_42086_42177[(2)] = inst_42078);

(statearr_42086_42177[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42084 === (20))){
var inst_42069 = (state_42083[(2)]);
var state_42083__$1 = state_42083;
var statearr_42087_42178 = state_42083__$1;
(statearr_42087_42178[(2)] = inst_42069);

(statearr_42087_42178[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42084 === (1))){
var state_42083__$1 = state_42083;
var statearr_42088_42179 = state_42083__$1;
(statearr_42088_42179[(2)] = null);

(statearr_42088_42179[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42084 === (4))){
var inst_42025 = (state_42083[(2)]);
var state_42083__$1 = state_42083;
var statearr_42089_42180 = state_42083__$1;
(statearr_42089_42180[(2)] = inst_42025);

(statearr_42089_42180[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42084 === (15))){
var inst_42045 = (state_42083[(7)]);
var inst_42054 = cljs.core.second.call(null,inst_42045);
var inst_42055 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_42054);
var inst_42056 = (inst_42055 > max_fuel);
var state_42083__$1 = state_42083;
if(cljs.core.truth_(inst_42056)){
var statearr_42090_42181 = state_42083__$1;
(statearr_42090_42181[(1)] = (18));

} else {
var statearr_42091_42182 = state_42083__$1;
(statearr_42091_42182[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42084 === (13))){
var state_42083__$1 = state_42083;
var statearr_42092_42183 = state_42083__$1;
(statearr_42092_42183[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42084 === (6))){
var inst_42033 = (state_42083[(8)]);
var state_42083__$1 = state_42083;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42083__$1,(8),inst_42033);
} else {
if((state_val_42084 === (17))){
var inst_42072 = (state_42083[(2)]);
var state_42083__$1 = state_42083;
var statearr_42094_42184 = state_42083__$1;
(statearr_42094_42184[(2)] = inst_42072);

(statearr_42094_42184[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42084 === (3))){
var inst_42081 = (state_42083[(2)]);
var state_42083__$1 = state_42083;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42083__$1,inst_42081);
} else {
if((state_val_42084 === (12))){
var inst_42045 = (state_42083[(7)]);
var inst_42034 = (state_42083[(9)]);
var inst_42051 = inst_42034.call(null);
var state_42083__$1 = (function (){var statearr_42095 = state_42083;
(statearr_42095[(10)] = inst_42051);

return statearr_42095;
})();
var statearr_42096_42185 = state_42083__$1;
(statearr_42096_42185[(2)] = inst_42045);

(statearr_42096_42185[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42084 === (2))){
var inst_42034 = (state_42083[(9)]);
var inst_42033 = (state_42083[(8)]);
var _ = (function (){var statearr_42097 = state_42083;
(statearr_42097[(4)] = cljs.core.cons.call(null,(5),(state_42083[(4)])));

return statearr_42097;
})();
var inst_42031 = fluree.db.query.fql.build_expand_map.call(null,select,pp_keys);
var inst_42032 = cljs.core.async.chan.call(null);
var inst_42033__$1 = cljs.core.async.chan.call(null);
var inst_42034__$1 = (function (){var expandMaps = inst_42031;
var queue_ch = inst_42032;
var res_ch = inst_42033__$1;
return (function (){
cljs.core.async.close_BANG_.call(null,queue_ch);

return cljs.core.async.close_BANG_.call(null,res_ch);
});
})();
var inst_42035 = cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var inst_42036 = cljs.core.volatile_BANG_.call(null,(0));
var inst_42037 = cljs.core.assoc.call(null,inst_42035,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_42036);
var inst_42038 = (function (){var expandMaps = inst_42031;
var queue_ch = inst_42032;
var res_ch = inst_42033__$1;
var stop_BANG_ = inst_42034__$1;
var opts_STAR_ = inst_42037;
return (function (tuple_res,port){
var c__16345__auto____$1 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_42130){
var state_val_42131 = (state_42130[(1)]);
if((state_val_42131 === (7))){
var state_42130__$1 = state_42130;
var statearr_42132_42186 = state_42130__$1;
(statearr_42132_42186[(2)] = tuple_res);

(statearr_42132_42186[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42131 === (1))){
var state_42130__$1 = state_42130;
var statearr_42133_42187 = state_42130__$1;
(statearr_42133_42187[(2)] = null);

(statearr_42133_42187[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42131 === (4))){
var inst_42098 = (state_42130[(2)]);
var inst_42099 = cljs.core.async.put_BANG_.call(null,port,inst_42098);
var inst_42100 = cljs.core.async.close_BANG_.call(null,port);
var state_42130__$1 = (function (){var statearr_42134 = state_42130;
(statearr_42134[(7)] = inst_42099);

return statearr_42134;
})();
var statearr_42135_42188 = state_42130__$1;
(statearr_42135_42188[(2)] = inst_42100);

(statearr_42135_42188[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42131 === (6))){
var inst_42107 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42108 = [tuple_res];
var inst_42109 = (new cljs.core.PersistentVector(null,1,(5),inst_42107,inst_42108,null));
var state_42130__$1 = state_42130;
var statearr_42136_42189 = state_42130__$1;
(statearr_42136_42189[(2)] = inst_42109);

(statearr_42136_42189[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42131 === (3))){
var inst_42128 = (state_42130[(2)]);
var state_42130__$1 = state_42130;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42130__$1,inst_42128);
} else {
if((state_val_42131 === (2))){
var ___$1 = (function (){var statearr_42138 = state_42130;
(statearr_42138[(4)] = cljs.core.cons.call(null,(5),(state_42130[(4)])));

return statearr_42138;
})();
var state_42130__$1 = state_42130;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_42139_42190 = state_42130__$1;
(statearr_42139_42190[(1)] = (6));

} else {
var statearr_42140_42191 = state_42130__$1;
(statearr_42140_42191[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42131 === (9))){
var inst_42114 = (state_42130[(8)]);
var inst_42112 = (state_42130[(9)]);
var inst_42121 = (state_42130[(2)]);
var inst_42122 = cljs.core.reduce.call(null,fluree.db.query.fql.replace_expand_maps,inst_42112,inst_42121);
var inst_42123 = inst_42114.call(null,inst_42122);
var inst_42124 = cljs.core.async.put_BANG_.call(null,port,inst_42123);
var inst_42125 = cljs.core.async.close_BANG_.call(null,port);
var ___$1 = (function (){var statearr_42141 = state_42130;
(statearr_42141[(4)] = cljs.core.rest.call(null,(state_42130[(4)])));

return statearr_42141;
})();
var state_42130__$1 = (function (){var statearr_42142 = state_42130;
(statearr_42142[(10)] = inst_42124);

return statearr_42142;
})();
var statearr_42143_42192 = state_42130__$1;
(statearr_42143_42192[(2)] = inst_42125);

(statearr_42143_42192[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42131 === (5))){
var ___$1 = (function (){var statearr_42144 = state_42130;
(statearr_42144[(4)] = cljs.core.rest.call(null,(state_42130[(4)])));

return statearr_42144;
})();
var state_42130__$1 = state_42130;
var ex42137 = (state_42130__$1[(2)]);
var statearr_42145_42193 = state_42130__$1;
(statearr_42145_42193[(5)] = ex42137);


var statearr_42146_42194 = state_42130__$1;
(statearr_42146_42194[(1)] = (4));

(statearr_42146_42194[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42131 === (8))){
var inst_42112 = (state_42130[(9)]);
var inst_42112__$1 = (state_42130[(2)]);
var inst_42113 = cljs.core.volatile_BANG_.call(null,(0));
var inst_42114 = (function (){var tuple_res_SINGLEQUOTE_ = inst_42112__$1;
var query_fuel = inst_42113;
return (function (p1__42024_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,p1__42024_SHARP_),cljs.core.deref.call(null,query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__42024_SHARP_,cljs.core.deref.call(null,query_fuel)], null);
}
});
})();
var inst_42115 = cljs.core.PersistentVector.EMPTY;
var inst_42116 = (function (){var tuple_res_SINGLEQUOTE_ = inst_42112__$1;
var query_fuel = inst_42113;
return (function (p1__42023_SHARP_){
return fluree.db.query.fql.expand_map.call(null,db,cljs.core.assoc.call(null,opts_STAR_,new cljs.core.Keyword(null,"fuel","fuel",10405485),fuel),tuple_res_SINGLEQUOTE_,p1__42023_SHARP_);
});
})();
var inst_42117 = cljs.core.keep.call(null,inst_42116,expandMaps);
var inst_42118 = cljs.core.async.merge.call(null,inst_42117);
var inst_42119 = cljs.core.async.into.call(null,inst_42115,inst_42118);
var state_42130__$1 = (function (){var statearr_42147 = state_42130;
(statearr_42147[(8)] = inst_42114);

(statearr_42147[(9)] = inst_42112__$1);

return statearr_42147;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42130__$1,(9),inst_42119);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16221__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16221__auto____0 = (function (){
var statearr_42148 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_42148[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16221__auto__);

(statearr_42148[(1)] = (1));

return statearr_42148;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16221__auto____1 = (function (state_42130){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_42130);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e42149){var ex__16224__auto__ = e42149;
var statearr_42150_42195 = state_42130;
(statearr_42150_42195[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_42130[(4)]))){
var statearr_42151_42196 = state_42130;
(statearr_42151_42196[(1)] = cljs.core.first.call(null,(state_42130[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42197 = state_42130;
state_42130 = G__42197;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16221__auto__ = function(state_42130){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16221__auto____1.call(this,state_42130);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16221__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16221__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_42152 = f__16346__auto__.call(null);
(statearr_42152[(6)] = c__16345__auto____$1);

return statearr_42152;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto____$1;
});
})();
var inst_42039 = cljs.core.async.onto_chan_BANG_.call(null,inst_42032,tuples_res);
var inst_42040 = cljs.core.async.pipeline_async.call(null,parallelism,inst_42033__$1,inst_42038,inst_42032);
var inst_42041 = cljs.core.PersistentVector.EMPTY;
var inst_42042 = inst_42041;
var state_42083__$1 = (function (){var statearr_42153 = state_42083;
(statearr_42153[(9)] = inst_42034__$1);

(statearr_42153[(11)] = inst_42039);

(statearr_42153[(8)] = inst_42033__$1);

(statearr_42153[(12)] = inst_42042);

(statearr_42153[(13)] = inst_42040);

return statearr_42153;
})();
var statearr_42154_42198 = state_42083__$1;
(statearr_42154_42198[(2)] = null);

(statearr_42154_42198[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42084 === (19))){
var inst_42045 = (state_42083[(7)]);
var inst_42042 = (state_42083[(12)]);
var inst_42065 = cljs.core.first.call(null,inst_42045);
var inst_42066 = cljs.core.conj.call(null,inst_42042,inst_42065);
var inst_42042__$1 = inst_42066;
var state_42083__$1 = (function (){var statearr_42155 = state_42083;
(statearr_42155[(12)] = inst_42042__$1);

return statearr_42155;
})();
var statearr_42156_42199 = state_42083__$1;
(statearr_42156_42199[(2)] = null);

(statearr_42156_42199[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42084 === (11))){
var inst_42076 = (state_42083[(2)]);
var state_42083__$1 = state_42083;
var statearr_42158_42200 = state_42083__$1;
(statearr_42158_42200[(2)] = inst_42076);

(statearr_42158_42200[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42084 === (9))){
var inst_42042 = (state_42083[(12)]);
var state_42083__$1 = state_42083;
var statearr_42159_42201 = state_42083__$1;
(statearr_42159_42201[(2)] = inst_42042);

(statearr_42159_42201[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42084 === (5))){
var _ = (function (){var statearr_42160 = state_42083;
(statearr_42160[(4)] = cljs.core.rest.call(null,(state_42083[(4)])));

return statearr_42160;
})();
var state_42083__$1 = state_42083;
var ex42157 = (state_42083__$1[(2)]);
var statearr_42161_42202 = state_42083__$1;
(statearr_42161_42202[(5)] = ex42157);


if((ex42157 instanceof Error)){
var statearr_42162_42203 = state_42083__$1;
(statearr_42162_42203[(1)] = (4));

(statearr_42162_42203[(5)] = null);

} else {
throw ex42157;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42084 === (14))){
var inst_42074 = (state_42083[(2)]);
var state_42083__$1 = state_42083;
var statearr_42163_42204 = state_42083__$1;
(statearr_42163_42204[(2)] = inst_42074);

(statearr_42163_42204[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42084 === (16))){
var state_42083__$1 = state_42083;
var statearr_42164_42205 = state_42083__$1;
(statearr_42164_42205[(2)] = null);

(statearr_42164_42205[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42084 === (10))){
var inst_42045 = (state_42083[(7)]);
var inst_42049 = fluree.db.util.core.exception_QMARK_.call(null,inst_42045);
var state_42083__$1 = state_42083;
if(inst_42049){
var statearr_42165_42206 = state_42083__$1;
(statearr_42165_42206[(1)] = (12));

} else {
var statearr_42166_42207 = state_42083__$1;
(statearr_42166_42207[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42084 === (18))){
var inst_42034 = (state_42083[(9)]);
var inst_42058 = inst_42034.call(null);
var inst_42059 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_42060 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_42061 = [new cljs.core.Keyword("db","insufficient-fuel","db/insufficient-fuel",344386102),(400)];
var inst_42062 = cljs.core.PersistentHashMap.fromArrays(inst_42060,inst_42061);
var inst_42063 = cljs.core.ex_info.call(null,inst_42059,inst_42062);
var state_42083__$1 = (function (){var statearr_42167 = state_42083;
(statearr_42167[(14)] = inst_42058);

return statearr_42167;
})();
var statearr_42168_42208 = state_42083__$1;
(statearr_42168_42208[(2)] = inst_42063);

(statearr_42168_42208[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42084 === (8))){
var inst_42045 = (state_42083[(7)]);
var inst_42045__$1 = (state_42083[(2)]);
var inst_42046 = (inst_42045__$1 == null);
var state_42083__$1 = (function (){var statearr_42169 = state_42083;
(statearr_42169[(7)] = inst_42045__$1);

return statearr_42169;
})();
if(cljs.core.truth_(inst_42046)){
var statearr_42170_42209 = state_42083__$1;
(statearr_42170_42209[(1)] = (9));

} else {
var statearr_42171_42210 = state_42083__$1;
(statearr_42171_42210[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16221__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16221__auto____0 = (function (){
var statearr_42172 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42172[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16221__auto__);

(statearr_42172[(1)] = (1));

return statearr_42172;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16221__auto____1 = (function (state_42083){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_42083);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e42173){var ex__16224__auto__ = e42173;
var statearr_42174_42211 = state_42083;
(statearr_42174_42211[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_42083[(4)]))){
var statearr_42175_42212 = state_42083;
(statearr_42175_42212[(1)] = cljs.core.first.call(null,(state_42083[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42213 = state_42083;
state_42083 = G__42213;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16221__auto__ = function(state_42083){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16221__auto____1.call(this,state_42083);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16221__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16221__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_42176 = f__16346__auto__.call(null);
(statearr_42176[(6)] = c__16345__auto__);

return statearr_42176;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__42214 = select;
var map__42214__$1 = cljs.core.__destructure_map.call(null,map__42214);
var as = cljs.core.get.call(null,map__42214__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var variable = cljs.core.get.call(null,map__42214__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var value = cljs.core.get.call(null,map__42214__$1,new cljs.core.Keyword(null,"value","value",305978217));
var select_val = (function (){var or__4212__auto__ = as;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx.call(null,headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly.call(null,value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.call(null,tuple,idx);
}):(cljs.core.truth_(cljs.core.get.call(null,vars,select_val))?cljs.core.constantly.call(null,cljs.core.get.call(null,vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.call(null,cljs.core.juxt,cljs.core.map.call(null,cljs.core.partial.call(null,fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__42217 = orderBy;
var order = cljs.core.nth.call(null,vec__42217,(0),null);
var var$ = cljs.core.nth.call(null,vec__42217,(1),null);
var option = cljs.core.nth.call(null,vec__42217,(2),null);
var comparator = ((cljs.core._EQ_.call(null,"DESC",order))?(function (a,b){
return cljs.core.compare.call(null,b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of.call(null,headers,cljs.core.symbol.call(null,var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.call(null,"NOCASE",clojure.string.upper_case.call(null,option))));
var keyfn = ((no_case_QMARK_)?(function (p1__42215_SHARP_){
return clojure.string.upper_case.call(null,cljs.core.nth.call(null,p1__42215_SHARP_,compare_idx));
}):(function (p1__42216_SHARP_){
return cljs.core.nth.call(null,p1__42216_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,(((no_case_QMARK_)?(4):(2)) * cljs.core.count.call(null,tuples)));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return cljs.core.sort_by.call(null,keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__42222 = arguments.length;
switch (G__42222) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__42223,p__42224,group_limit,opts){
var map__42225 = p__42223;
var map__42225__$1 = cljs.core.__destructure_map.call(null,map__42225);
var res = map__42225__$1;
var vars = cljs.core.get.call(null,map__42225__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__42226 = p__42224;
var map__42226__$1 = cljs.core.__destructure_map.call(null,map__42226);
var select_spec = map__42226__$1;
var inVector_QMARK_ = cljs.core.get.call(null,map__42226__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.call(null,map__42226__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.call(null,map__42226__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var expandMaps_QMARK_ = cljs.core.get.call(null,map__42226__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var limit = cljs.core.get.call(null,map__42226__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__42226__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.call(null,map__42226__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.call(null,map__42226__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__42226__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.call(null,map__42226__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_42363){
var state_val_42364 = (state_42363[(1)]);
if((state_val_42364 === (7))){
var inst_42233 = (state_42363[(7)]);
var state_42363__$1 = state_42363;
var statearr_42365_42467 = state_42363__$1;
(statearr_42365_42467[(2)] = inst_42233);

(statearr_42365_42467[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (59))){
var inst_42356 = (state_42363[(2)]);
var state_42363__$1 = state_42363;
var statearr_42366_42468 = state_42363__$1;
(statearr_42366_42468[(2)] = inst_42356);

(statearr_42366_42468[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (20))){
var inst_42272 = (state_42363[(8)]);
var inst_42269 = (state_42363[(9)]);
var inst_42268 = (state_42363[(2)]);
var inst_42269__$1 = cljs.core.__destructure_map.call(null,inst_42268);
var inst_42270 = cljs.core.get.call(null,inst_42269__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_42271 = cljs.core.get.call(null,inst_42269__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_42272__$1 = offset;
var state_42363__$1 = (function (){var statearr_42367 = state_42363;
(statearr_42367[(8)] = inst_42272__$1);

(statearr_42367[(10)] = inst_42271);

(statearr_42367[(9)] = inst_42269__$1);

(statearr_42367[(11)] = inst_42270);

return statearr_42367;
})();
if(cljs.core.truth_(inst_42272__$1)){
var statearr_42368_42469 = state_42363__$1;
(statearr_42368_42469[(1)] = (21));

} else {
var statearr_42369_42470 = state_42363__$1;
(statearr_42369_42470[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (58))){
var inst_42348 = (state_42363[(12)]);
var state_42363__$1 = state_42363;
var statearr_42370_42471 = state_42363__$1;
(statearr_42370_42471[(2)] = inst_42348);

(statearr_42370_42471[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (60))){
var inst_42352 = (state_42363[(2)]);
var inst_42353 = fluree.db.util.async.throw_err.call(null,inst_42352);
var state_42363__$1 = state_42363;
var statearr_42371_42472 = state_42363__$1;
(statearr_42371_42472[(2)] = inst_42353);

(statearr_42371_42472[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (27))){
var inst_42284 = cljs.core.not.call(null,inVector_QMARK_);
var state_42363__$1 = state_42363;
var statearr_42372_42473 = state_42363__$1;
(statearr_42372_42473[(2)] = inst_42284);

(statearr_42372_42473[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (1))){
var state_42363__$1 = state_42363;
var statearr_42373_42474 = state_42363__$1;
(statearr_42373_42474[(2)] = null);

(statearr_42373_42474[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (24))){
var state_42363__$1 = state_42363;
var statearr_42374_42475 = state_42363__$1;
(statearr_42374_42475[(2)] = offset);

(statearr_42374_42475[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (55))){
var inst_42342 = (state_42363[(13)]);
var state_42363__$1 = state_42363;
var statearr_42375_42476 = state_42363__$1;
(statearr_42375_42476[(2)] = inst_42342);

(statearr_42375_42476[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (39))){
var inst_42310 = (state_42363[(14)]);
var inst_42312 = cljs.core.distinct.call(null);
var inst_42313 = cljs.core.conj.call(null,inst_42310,inst_42312);
var state_42363__$1 = state_42363;
var statearr_42376_42477 = state_42363__$1;
(statearr_42376_42477[(2)] = inst_42313);

(statearr_42376_42477[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (46))){
var inst_42322 = (state_42363[(15)]);
var state_42363__$1 = state_42363;
var statearr_42377_42478 = state_42363__$1;
(statearr_42377_42478[(2)] = inst_42322);

(statearr_42377_42478[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (4))){
var inst_42227 = (state_42363[(2)]);
var state_42363__$1 = state_42363;
var statearr_42378_42479 = state_42363__$1;
(statearr_42378_42479[(2)] = inst_42227);

(statearr_42378_42479[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (54))){
var inst_42336 = (state_42363[(16)]);
var inst_42342 = (state_42363[(13)]);
var inst_42344 = cljs.core.PersistentVector.EMPTY;
var inst_42345 = cljs.core.into.call(null,inst_42344,inst_42336,inst_42342);
var state_42363__$1 = state_42363;
var statearr_42379_42480 = state_42363__$1;
(statearr_42379_42480[(2)] = inst_42345);

(statearr_42379_42480[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (15))){
var inst_42254 = (state_42363[(17)]);
var inst_42256 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42257 = [inst_42254];
var inst_42258 = (new cljs.core.PersistentVector(null,1,(5),inst_42256,inst_42257,null));
var state_42363__$1 = state_42363;
var statearr_42380_42481 = state_42363__$1;
(statearr_42380_42481[(2)] = inst_42258);

(statearr_42380_42481[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (48))){
var inst_42281 = (state_42363[(18)]);
var inst_42328 = (state_42363[(19)]);
var inst_42271 = (state_42363[(10)]);
var inst_42269 = (state_42363[(9)]);
var inst_42270 = (state_42363[(11)]);
var inst_42292 = (state_42363[(20)]);
var inst_42287 = (state_42363[(21)]);
var inst_42330 = (function (){var map__42263 = inst_42269;
var headers = inst_42270;
var tuples = inst_42271;
var offset_SINGLEQUOTE_ = inst_42281;
var single_result_QMARK_ = inst_42287;
var pp_keys = inst_42292;
var G__42293 = inst_42328;
return (function (p1__42220_SHARP_){
return cljs.core.zipmap.call(null,fluree.db.query.fql.get_pretty_print_keys.call(null,select),p1__42220_SHARP_);
});
})();
var inst_42331 = cljs.core.map.call(null,inst_42330);
var inst_42332 = cljs.core.conj.call(null,inst_42328,inst_42331);
var state_42363__$1 = state_42363;
var statearr_42381_42482 = state_42363__$1;
(statearr_42381_42482[(2)] = inst_42332);

(statearr_42381_42482[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (50))){
var inst_42335 = (state_42363[(2)]);
var inst_42336 = cljs.core.apply.call(null,cljs.core.comp,inst_42335);
var state_42363__$1 = (function (){var statearr_42382 = state_42363;
(statearr_42382[(16)] = inst_42336);

return statearr_42382;
})();
if(cljs.core.truth_(orderBy)){
var statearr_42383_42483 = state_42363__$1;
(statearr_42383_42483[(1)] = (51));

} else {
var statearr_42384_42484 = state_42363__$1;
(statearr_42384_42484[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (21))){
var inst_42274 = cljs.core.not.call(null,groupBy);
var state_42363__$1 = state_42363;
var statearr_42385_42485 = state_42363__$1;
(statearr_42385_42485[(2)] = inst_42274);

(statearr_42385_42485[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (31))){
var state_42363__$1 = state_42363;
var statearr_42386_42486 = state_42363__$1;
(statearr_42386_42486[(2)] = null);

(statearr_42386_42486[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (32))){
var inst_42270 = (state_42363[(11)]);
var inst_42287 = (state_42363[(21)]);
var inst_42292 = (state_42363[(2)]);
var inst_42294 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42295 = fluree.db.query.fql.select_tuples_fn.call(null,inst_42270,vars,select);
var inst_42296 = cljs.core.map.call(null,inst_42295);
var inst_42297 = [inst_42296];
var inst_42298 = (new cljs.core.PersistentVector(null,1,(5),inst_42294,inst_42297,null));
var state_42363__$1 = (function (){var statearr_42387 = state_42363;
(statearr_42387[(22)] = inst_42298);

(statearr_42387[(20)] = inst_42292);

return statearr_42387;
})();
if(cljs.core.truth_(inst_42287)){
var statearr_42388_42487 = state_42363__$1;
(statearr_42388_42487[(1)] = (33));

} else {
var statearr_42389_42488 = state_42363__$1;
(statearr_42389_42488[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (40))){
var inst_42310 = (state_42363[(14)]);
var state_42363__$1 = state_42363;
var statearr_42390_42489 = state_42363__$1;
(statearr_42390_42489[(2)] = inst_42310);

(statearr_42390_42489[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (56))){
var inst_42348 = (state_42363[(2)]);
var state_42363__$1 = (function (){var statearr_42391 = state_42363;
(statearr_42391[(12)] = inst_42348);

return statearr_42391;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_42392_42490 = state_42363__$1;
(statearr_42392_42490[(1)] = (57));

} else {
var statearr_42393_42491 = state_42363__$1;
(statearr_42393_42491[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (33))){
var inst_42298 = (state_42363[(22)]);
var inst_42300 = cljs.core.map.call(null,cljs.core.first);
var inst_42301 = cljs.core.conj.call(null,inst_42298,inst_42300);
var state_42363__$1 = state_42363;
var statearr_42394_42492 = state_42363__$1;
(statearr_42394_42492[(2)] = inst_42301);

(statearr_42394_42492[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (13))){
var inst_42243 = (state_42363[(23)]);
var state_42363__$1 = state_42363;
var statearr_42395_42493 = state_42363__$1;
(statearr_42395_42493[(2)] = inst_42243);

(statearr_42395_42493[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (22))){
var inst_42272 = (state_42363[(8)]);
var state_42363__$1 = state_42363;
var statearr_42396_42494 = state_42363__$1;
(statearr_42396_42494[(2)] = inst_42272);

(statearr_42396_42494[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (36))){
var inst_42304 = (state_42363[(24)]);
var inst_42306 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel,(5));
var inst_42307 = cljs.core.conj.call(null,inst_42304,inst_42306);
var state_42363__$1 = state_42363;
var statearr_42397_42495 = state_42363__$1;
(statearr_42397_42495[(2)] = inst_42307);

(statearr_42397_42495[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (41))){
var inst_42281 = (state_42363[(18)]);
var inst_42316 = (state_42363[(2)]);
var state_42363__$1 = (function (){var statearr_42398 = state_42363;
(statearr_42398[(25)] = inst_42316);

return statearr_42398;
})();
if(cljs.core.truth_(inst_42281)){
var statearr_42399_42496 = state_42363__$1;
(statearr_42399_42496[(1)] = (42));

} else {
var statearr_42400_42497 = state_42363__$1;
(statearr_42400_42497[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (43))){
var inst_42316 = (state_42363[(25)]);
var state_42363__$1 = state_42363;
var statearr_42401_42498 = state_42363__$1;
(statearr_42401_42498[(2)] = inst_42316);

(statearr_42401_42498[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (29))){
var inst_42287 = (state_42363[(2)]);
var state_42363__$1 = (function (){var statearr_42402 = state_42363;
(statearr_42402[(21)] = inst_42287);

return statearr_42402;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_42403_42499 = state_42363__$1;
(statearr_42403_42499[(1)] = (30));

} else {
var statearr_42404_42500 = state_42363__$1;
(statearr_42404_42500[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (44))){
var inst_42322 = (state_42363[(2)]);
var state_42363__$1 = (function (){var statearr_42405 = state_42363;
(statearr_42405[(15)] = inst_42322);

return statearr_42405;
})();
if(cljs.core.truth_(group_limit)){
var statearr_42406_42501 = state_42363__$1;
(statearr_42406_42501[(1)] = (45));

} else {
var statearr_42407_42502 = state_42363__$1;
(statearr_42407_42502[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (6))){
var inst_42235 = cljs.core.count.call(null,select);
var inst_42236 = cljs.core._EQ_.call(null,(1),inst_42235);
var state_42363__$1 = state_42363;
var statearr_42408_42503 = state_42363__$1;
(statearr_42408_42503[(2)] = inst_42236);

(statearr_42408_42503[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (28))){
var inst_42282 = (state_42363[(26)]);
var state_42363__$1 = state_42363;
var statearr_42409_42504 = state_42363__$1;
(statearr_42409_42504[(2)] = inst_42282);

(statearr_42409_42504[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (51))){
var inst_42271 = (state_42363[(10)]);
var inst_42270 = (state_42363[(11)]);
var inst_42339 = fluree.db.query.fql.order_result_tuples.call(null,fuel,max_fuel,inst_42270,orderBy,inst_42271);
var state_42363__$1 = state_42363;
var statearr_42410_42505 = state_42363__$1;
(statearr_42410_42505[(2)] = inst_42339);

(statearr_42410_42505[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (25))){
var state_42363__$1 = state_42363;
var statearr_42411_42506 = state_42363__$1;
(statearr_42411_42506[(2)] = null);

(statearr_42411_42506[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (34))){
var inst_42298 = (state_42363[(22)]);
var state_42363__$1 = state_42363;
var statearr_42412_42507 = state_42363__$1;
(statearr_42412_42507[(2)] = inst_42298);

(statearr_42412_42507[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (17))){
var inst_42261 = (state_42363[(2)]);
var state_42363__$1 = state_42363;
var statearr_42413_42508 = state_42363__$1;
(statearr_42413_42508[(2)] = inst_42261);

(statearr_42413_42508[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (3))){
var inst_42361 = (state_42363[(2)]);
var state_42363__$1 = state_42363;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42363__$1,inst_42361);
} else {
if((state_val_42364 === (12))){
var inst_42243 = (state_42363[(23)]);
var inst_42245 = cljs.core.first.call(null,select);
var inst_42246 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_42245);
var inst_42247 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_42246);
var inst_42248 = cljs.core.subs.call(null,inst_42247,(1));
var inst_42249 = [inst_42248];
var inst_42250 = [inst_42243];
var inst_42251 = cljs.core.PersistentHashMap.fromArrays(inst_42249,inst_42250);
var state_42363__$1 = state_42363;
var statearr_42414_42509 = state_42363__$1;
(statearr_42414_42509[(2)] = inst_42251);

(statearr_42414_42509[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (2))){
var inst_42233 = (state_42363[(7)]);
var _ = (function (){var statearr_42415 = state_42363;
(statearr_42415[(4)] = cljs.core.cons.call(null,(5),(state_42363[(4)])));

return statearr_42415;
})();
var inst_42233__$1 = aggregates;
var state_42363__$1 = (function (){var statearr_42416 = state_42363;
(statearr_42416[(7)] = inst_42233__$1);

return statearr_42416;
})();
if(cljs.core.truth_(inst_42233__$1)){
var statearr_42417_42510 = state_42363__$1;
(statearr_42417_42510[(1)] = (6));

} else {
var statearr_42418_42511 = state_42363__$1;
(statearr_42418_42511[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (23))){
var inst_42277 = (state_42363[(2)]);
var state_42363__$1 = state_42363;
if(cljs.core.truth_(inst_42277)){
var statearr_42419_42512 = state_42363__$1;
(statearr_42419_42512[(1)] = (24));

} else {
var statearr_42420_42513 = state_42363__$1;
(statearr_42420_42513[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (47))){
var inst_42328 = (state_42363[(2)]);
var state_42363__$1 = (function (){var statearr_42421 = state_42363;
(statearr_42421[(19)] = inst_42328);

return statearr_42421;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_42422_42514 = state_42363__$1;
(statearr_42422_42514[(1)] = (48));

} else {
var statearr_42423_42515 = state_42363__$1;
(statearr_42423_42515[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (35))){
var inst_42304 = (state_42363[(2)]);
var state_42363__$1 = (function (){var statearr_42424 = state_42363;
(statearr_42424[(24)] = inst_42304);

return statearr_42424;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_42425_42516 = state_42363__$1;
(statearr_42425_42516[(1)] = (36));

} else {
var statearr_42426_42517 = state_42363__$1;
(statearr_42426_42517[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (19))){
var state_42363__$1 = state_42363;
var statearr_42427_42518 = state_42363__$1;
(statearr_42427_42518[(2)] = res);

(statearr_42427_42518[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (57))){
var inst_42348 = (state_42363[(12)]);
var inst_42292 = (state_42363[(20)]);
var inst_42287 = (state_42363[(21)]);
var inst_42350 = fluree.db.query.fql.pipeline_expandmaps_result.call(null,select,inst_42292,inst_42287,db,fuel,max_fuel,opts,(8),inst_42348);
var state_42363__$1 = state_42363;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42363__$1,(60),inst_42350);
} else {
if((state_val_42364 === (11))){
var inst_42358 = (state_42363[(2)]);
var _ = (function (){var statearr_42429 = state_42363;
(statearr_42429[(4)] = cljs.core.rest.call(null,(state_42363[(4)])));

return statearr_42429;
})();
var state_42363__$1 = state_42363;
var statearr_42430_42519 = state_42363__$1;
(statearr_42430_42519[(2)] = inst_42358);

(statearr_42430_42519[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (9))){
var inst_42241 = cljs.core.first.call(null,aggregates);
var inst_42242 = fluree.db.query.analytical.calculate_aggregate.call(null,res,inst_42241);
var inst_42243 = cljs.core.second.call(null,inst_42242);
var state_42363__$1 = (function (){var statearr_42431 = state_42363;
(statearr_42431[(23)] = inst_42243);

return statearr_42431;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_42432_42520 = state_42363__$1;
(statearr_42432_42520[(1)] = (12));

} else {
var statearr_42433_42521 = state_42363__$1;
(statearr_42433_42521[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (5))){
var _ = (function (){var statearr_42434 = state_42363;
(statearr_42434[(4)] = cljs.core.rest.call(null,(state_42363[(4)])));

return statearr_42434;
})();
var state_42363__$1 = state_42363;
var ex42428 = (state_42363__$1[(2)]);
var statearr_42435_42522 = state_42363__$1;
(statearr_42435_42522[(5)] = ex42428);


if((ex42428 instanceof Error)){
var statearr_42436_42523 = state_42363__$1;
(statearr_42436_42523[(1)] = (4));

(statearr_42436_42523[(5)] = null);

} else {
throw ex42428;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (14))){
var inst_42254 = (state_42363[(2)]);
var state_42363__$1 = (function (){var statearr_42437 = state_42363;
(statearr_42437[(17)] = inst_42254);

return statearr_42437;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_42438_42524 = state_42363__$1;
(statearr_42438_42524[(1)] = (15));

} else {
var statearr_42439_42525 = state_42363__$1;
(statearr_42439_42525[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (45))){
var inst_42322 = (state_42363[(15)]);
var inst_42324 = cljs.core.take.call(null,group_limit);
var inst_42325 = cljs.core.conj.call(null,inst_42322,inst_42324);
var state_42363__$1 = state_42363;
var statearr_42440_42526 = state_42363__$1;
(statearr_42440_42526[(2)] = inst_42325);

(statearr_42440_42526[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (53))){
var inst_42342 = (state_42363[(2)]);
var state_42363__$1 = (function (){var statearr_42441 = state_42363;
(statearr_42441[(13)] = inst_42342);

return statearr_42441;
})();
var statearr_42442_42527 = state_42363__$1;
(statearr_42442_42527[(1)] = (54));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (26))){
var inst_42282 = (state_42363[(26)]);
var inst_42281 = (state_42363[(2)]);
var inst_42282__$1 = cljs.core.not.call(null,prettyPrint);
var state_42363__$1 = (function (){var statearr_42444 = state_42363;
(statearr_42444[(18)] = inst_42281);

(statearr_42444[(26)] = inst_42282__$1);

return statearr_42444;
})();
if(inst_42282__$1){
var statearr_42445_42528 = state_42363__$1;
(statearr_42445_42528[(1)] = (27));

} else {
var statearr_42446_42529 = state_42363__$1;
(statearr_42446_42529[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (16))){
var inst_42254 = (state_42363[(17)]);
var state_42363__$1 = state_42363;
var statearr_42447_42530 = state_42363__$1;
(statearr_42447_42530[(2)] = inst_42254);

(statearr_42447_42530[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (38))){
var inst_42310 = (state_42363[(2)]);
var state_42363__$1 = (function (){var statearr_42448 = state_42363;
(statearr_42448[(14)] = inst_42310);

return statearr_42448;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_42449_42531 = state_42363__$1;
(statearr_42449_42531[(1)] = (39));

} else {
var statearr_42450_42532 = state_42363__$1;
(statearr_42450_42532[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (30))){
var inst_42289 = fluree.db.query.fql.get_pretty_print_keys.call(null,select);
var state_42363__$1 = state_42363;
var statearr_42451_42533 = state_42363__$1;
(statearr_42451_42533[(2)] = inst_42289);

(statearr_42451_42533[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (10))){
var state_42363__$1 = state_42363;
if(cljs.core.truth_(aggregates)){
var statearr_42452_42534 = state_42363__$1;
(statearr_42452_42534[(1)] = (18));

} else {
var statearr_42453_42535 = state_42363__$1;
(statearr_42453_42535[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (18))){
var inst_42265 = fluree.db.query.analytical.add_aggregate_cols.call(null,res,aggregates);
var state_42363__$1 = state_42363;
var statearr_42454_42536 = state_42363__$1;
(statearr_42454_42536[(2)] = inst_42265);

(statearr_42454_42536[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (52))){
var inst_42271 = (state_42363[(10)]);
var state_42363__$1 = state_42363;
var statearr_42455_42537 = state_42363__$1;
(statearr_42455_42537[(2)] = inst_42271);

(statearr_42455_42537[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (42))){
var inst_42281 = (state_42363[(18)]);
var inst_42316 = (state_42363[(25)]);
var inst_42318 = cljs.core.drop.call(null,inst_42281);
var inst_42319 = cljs.core.conj.call(null,inst_42316,inst_42318);
var state_42363__$1 = state_42363;
var statearr_42456_42538 = state_42363__$1;
(statearr_42456_42538[(2)] = inst_42319);

(statearr_42456_42538[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (37))){
var inst_42304 = (state_42363[(24)]);
var state_42363__$1 = state_42363;
var statearr_42457_42539 = state_42363__$1;
(statearr_42457_42539[(2)] = inst_42304);

(statearr_42457_42539[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (8))){
var inst_42239 = (state_42363[(2)]);
var state_42363__$1 = state_42363;
if(cljs.core.truth_(inst_42239)){
var statearr_42458_42540 = state_42363__$1;
(statearr_42458_42540[(1)] = (9));

} else {
var statearr_42459_42541 = state_42363__$1;
(statearr_42459_42541[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42364 === (49))){
var inst_42328 = (state_42363[(19)]);
var state_42363__$1 = state_42363;
var statearr_42460_42542 = state_42363__$1;
(statearr_42460_42542[(2)] = inst_42328);

(statearr_42460_42542[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16221__auto__ = null;
var fluree$db$query$fql$state_machine__16221__auto____0 = (function (){
var statearr_42461 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42461[(0)] = fluree$db$query$fql$state_machine__16221__auto__);

(statearr_42461[(1)] = (1));

return statearr_42461;
});
var fluree$db$query$fql$state_machine__16221__auto____1 = (function (state_42363){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_42363);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e42462){var ex__16224__auto__ = e42462;
var statearr_42463_42543 = state_42363;
(statearr_42463_42543[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_42363[(4)]))){
var statearr_42464_42544 = state_42363;
(statearr_42464_42544[(1)] = cljs.core.first.call(null,(state_42363[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42545 = state_42363;
state_42363 = G__42545;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16221__auto__ = function(state_42363){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16221__auto____1.call(this,state_42363);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16221__auto____0;
fluree$db$query$fql$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16221__auto____1;
return fluree$db$query$fql$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_42465 = f__16346__auto__.call(null);
(statearr_42465[(6)] = c__16345__auto__);

return statearr_42465;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__42548,groupBy){
var map__42549 = p__42548;
var map__42549__$1 = cljs.core.__destructure_map.call(null,map__42549);
var res = map__42549__$1;
var headers = cljs.core.get.call(null,map__42549__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__42549__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__42550 = ((cljs.core.vector_QMARK_.call(null,groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.call(null,cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,groupBy)], null)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.call(null,vec__42550,(0),null);
var groupBy__$1 = cljs.core.nth.call(null,vec__42550,(1),null);
var group_idxs = cljs.core.map.call(null,(function (p1__42546_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__42546_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some.call(null,cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.call(null,(function (res__$1,tuple){
var k = cljs.core.map.call(null,(function (p1__42547_SHARP_){
return cljs.core.nth.call(null,tuple,p1__42547_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,k):cljs.core.first.call(null,k));
var v = tuple;
return cljs.core.assoc.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.conj.call(null,cljs.core.get.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__42553 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.call(null,vec__42553,(0),null);
var sortCriteria = cljs.core.nth.call(null,vec__42553,(1),null);
if(cljs.core._EQ_.call(null,sortCriteria,groupBy)){
if(cljs.core._EQ_.call(null,sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_.call(null,groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of.call(null,groupBy,sortCriteria);
if(cljs.core._EQ_.call(null,"DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__42556,p__42557,opts){
var map__42558 = p__42556;
var map__42558__$1 = cljs.core.__destructure_map.call(null,map__42558);
var res = map__42558__$1;
var headers = cljs.core.get.call(null,map__42558__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__42558__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__42559 = p__42557;
var map__42559__$1 = cljs.core.__destructure_map.call(null,map__42559);
var select_spec = map__42559__$1;
var groupBy = cljs.core.get.call(null,map__42559__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.call(null,map__42559__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.call(null,map__42559__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.call(null,map__42559__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__42559__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.call(null,map__42559__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.call(null,map__42559__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_42801){
var state_val_42802 = (state_42801[(1)]);
if((state_val_42802 === (65))){
var state_42801__$1 = state_42801;
var statearr_42803_42954 = state_42801__$1;
(statearr_42803_42954[(1)] = (67));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (70))){
var inst_42722 = (state_42801[(7)]);
var state_42801__$1 = state_42801;
var statearr_42805_42955 = state_42801__$1;
(statearr_42805_42955[(2)] = inst_42722);

(statearr_42805_42955[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (62))){
var state_42801__$1 = state_42801;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_42806_42956 = state_42801__$1;
(statearr_42806_42956[(1)] = (64));

} else {
var statearr_42807_42957 = state_42801__$1;
(statearr_42807_42957[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (74))){
var inst_42638 = (state_42801[(8)]);
var inst_42697 = (state_42801[(9)]);
var inst_42629 = (state_42801[(10)]);
var inst_42730 = cljs.core.assoc.call(null,inst_42629,inst_42638,inst_42697);
var state_42801__$1 = state_42801;
var statearr_42808_42958 = state_42801__$1;
(statearr_42808_42958[(2)] = inst_42730);

(statearr_42808_42958[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (7))){
var state_42801__$1 = state_42801;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_42809_42959 = state_42801__$1;
(statearr_42809_42959[(1)] = (82));

} else {
var statearr_42810_42960 = state_42801__$1;
(statearr_42810_42960[(1)] = (83));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (59))){
var inst_42697 = (state_42801[(9)]);
var inst_42627 = (state_42801[(11)]);
var inst_42701 = cljs.core.count.call(null,inst_42697);
var inst_42702 = (inst_42627 - inst_42701);
var state_42801__$1 = state_42801;
var statearr_42811_42961 = state_42801__$1;
(statearr_42811_42961[(2)] = inst_42702);

(statearr_42811_42961[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (86))){
var state_42801__$1 = state_42801;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_42812_42962 = state_42801__$1;
(statearr_42812_42962[(1)] = (89));

} else {
var statearr_42813_42963 = state_42801__$1;
(statearr_42813_42963[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (20))){
var state_42801__$1 = state_42801;
var statearr_42814_42964 = state_42801__$1;
(statearr_42814_42964[(2)] = (0));

(statearr_42814_42964[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (72))){
var inst_42727 = (state_42801[(2)]);
var state_42801__$1 = state_42801;
if(cljs.core.truth_(inst_42727)){
var statearr_42815_42965 = state_42801__$1;
(statearr_42815_42965[(1)] = (73));

} else {
var statearr_42816_42966 = state_42801__$1;
(statearr_42816_42966[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (58))){
var state_42801__$1 = state_42801;
var statearr_42817_42967 = state_42801__$1;
(statearr_42817_42967[(2)] = null);

(statearr_42817_42967[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (60))){
var inst_42628 = (state_42801[(12)]);
var inst_42704 = (state_42801[(2)]);
var inst_42705 = (inst_42628 <= (0));
var state_42801__$1 = (function (){var statearr_42818 = state_42801;
(statearr_42818[(13)] = inst_42704);

return statearr_42818;
})();
if(cljs.core.truth_(inst_42705)){
var statearr_42819_42968 = state_42801__$1;
(statearr_42819_42968[(1)] = (61));

} else {
var statearr_42820_42969 = state_42801__$1;
(statearr_42820_42969[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (27))){
var inst_42627 = (state_42801[(11)]);
var inst_42651 = (inst_42627 < (1));
var state_42801__$1 = state_42801;
var statearr_42821_42970 = state_42801__$1;
(statearr_42821_42970[(2)] = inst_42651);

(statearr_42821_42970[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (1))){
var state_42801__$1 = state_42801;
var statearr_42822_42971 = state_42801__$1;
(statearr_42822_42971[(2)] = null);

(statearr_42822_42971[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (69))){
var inst_42717 = (state_42801[(2)]);
var state_42801__$1 = state_42801;
var statearr_42823_42972 = state_42801__$1;
(statearr_42823_42972[(2)] = inst_42717);

(statearr_42823_42972[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (24))){
var inst_42629 = (state_42801[(10)]);
var state_42801__$1 = state_42801;
var statearr_42824_42973 = state_42801__$1;
(statearr_42824_42973[(2)] = inst_42629);

(statearr_42824_42973[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (55))){
var inst_42687 = (state_42801[(14)]);
var inst_42627 = (state_42801[(11)]);
var inst_42694 = cljs.core.take.call(null,inst_42627,inst_42687);
var state_42801__$1 = state_42801;
var statearr_42825_42974 = state_42801__$1;
(statearr_42825_42974[(2)] = inst_42694);

(statearr_42825_42974[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (85))){
var inst_42772 = (state_42801[(15)]);
var inst_42771 = (state_42801[(2)]);
var inst_42772__$1 = fluree.db.util.async.throw_err.call(null,inst_42771);
var inst_42773 = cljs.core.coll_QMARK_.call(null,inst_42772__$1);
var inst_42774 = (!(inst_42773));
var state_42801__$1 = (function (){var statearr_42826 = state_42801;
(statearr_42826[(15)] = inst_42772__$1);

return statearr_42826;
})();
if(inst_42774){
var statearr_42827_42975 = state_42801__$1;
(statearr_42827_42975[(1)] = (86));

} else {
var statearr_42828_42976 = state_42801__$1;
(statearr_42828_42976[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (39))){
var inst_42646 = (state_42801[(16)]);
var inst_42668 = cljs.core.assoc.call(null,select_spec,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),null,new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null);
var inst_42669 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null);
var inst_42670 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,inst_42646,inst_42668,inst_42669);
var state_42801__$1 = state_42801;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42801__$1,(42),inst_42670);
} else {
if((state_val_42802 === (88))){
var inst_42794 = (state_42801[(2)]);
var state_42801__$1 = state_42801;
var statearr_42829_42977 = state_42801__$1;
(statearr_42829_42977[(2)] = inst_42794);

(statearr_42829_42977[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (46))){
var inst_42628 = (state_42801[(12)]);
var inst_42682 = ((0) < inst_42628);
var state_42801__$1 = state_42801;
if(cljs.core.truth_(inst_42682)){
var statearr_42830_42978 = state_42801__$1;
(statearr_42830_42978[(1)] = (49));

} else {
var statearr_42831_42979 = state_42801__$1;
(statearr_42831_42979[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (4))){
var inst_42560 = (state_42801[(2)]);
var state_42801__$1 = state_42801;
var statearr_42832_42980 = state_42801__$1;
(statearr_42832_42980[(2)] = inst_42560);

(statearr_42832_42980[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (77))){
var inst_42627 = (state_42801[(11)]);
var inst_42738 = (inst_42627 - (1));
var state_42801__$1 = state_42801;
var statearr_42833_42981 = state_42801__$1;
(statearr_42833_42981[(2)] = inst_42738);

(statearr_42833_42981[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (95))){
var inst_42772 = (state_42801[(15)]);
var state_42801__$1 = state_42801;
var statearr_42834_42982 = state_42801__$1;
(statearr_42834_42982[(2)] = inst_42772);

(statearr_42834_42982[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (54))){
var inst_42692 = (state_42801[(2)]);
var state_42801__$1 = state_42801;
if(cljs.core.truth_(inst_42692)){
var statearr_42835_42983 = state_42801__$1;
(statearr_42835_42983[(1)] = (55));

} else {
var statearr_42836_42984 = state_42801__$1;
(statearr_42836_42984[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (92))){
var inst_42772 = (state_42801[(15)]);
var inst_42785 = cljs.core.first.call(null,inst_42772);
var state_42801__$1 = state_42801;
var statearr_42837_42985 = state_42801__$1;
(statearr_42837_42985[(2)] = inst_42785);

(statearr_42837_42985[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (15))){
var inst_42578 = (state_42801[(17)]);
var inst_42586 = (state_42801[(2)]);
var inst_42587 = fluree.db.util.async.throw_err.call(null,inst_42586);
var inst_42588 = [inst_42578];
var inst_42589 = [inst_42587];
var inst_42590 = cljs.core.PersistentHashMap.fromArrays(inst_42588,inst_42589);
var state_42801__$1 = state_42801;
var statearr_42838_42986 = state_42801__$1;
(statearr_42838_42986[(2)] = inst_42590);

(statearr_42838_42986[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (48))){
var inst_42750 = (state_42801[(2)]);
var state_42801__$1 = state_42801;
var statearr_42839_42987 = state_42801__$1;
(statearr_42839_42987[(2)] = inst_42750);

(statearr_42839_42987[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (50))){
var inst_42673 = (state_42801[(18)]);
var state_42801__$1 = state_42801;
var statearr_42840_42988 = state_42801__$1;
(statearr_42840_42988[(2)] = inst_42673);

(statearr_42840_42988[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (75))){
var inst_42704 = (state_42801[(13)]);
var inst_42642 = (state_42801[(19)]);
var inst_42639 = (state_42801[(20)]);
var inst_42721 = (state_42801[(21)]);
var inst_42732 = (state_42801[(2)]);
var inst_42625 = inst_42639;
var inst_42626 = inst_42642;
var inst_42627 = inst_42704;
var inst_42628 = inst_42721;
var inst_42629 = inst_42732;
var state_42801__$1 = (function (){var statearr_42841 = state_42801;
(statearr_42841[(22)] = inst_42626);

(statearr_42841[(23)] = inst_42625);

(statearr_42841[(12)] = inst_42628);

(statearr_42841[(10)] = inst_42629);

(statearr_42841[(11)] = inst_42627);

return statearr_42841;
})();
var statearr_42842_42989 = state_42801__$1;
(statearr_42842_42989[(2)] = null);

(statearr_42842_42989[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (21))){
var inst_42618 = (state_42801[(24)]);
var inst_42610 = (state_42801[(25)]);
var inst_42606 = (state_42801[(26)]);
var inst_42623 = (state_42801[(2)]);
var inst_42624 = cljs.core.PersistentHashMap.EMPTY;
var inst_42625 = inst_42606;
var inst_42626 = inst_42610;
var inst_42627 = inst_42618;
var inst_42628 = inst_42623;
var inst_42629 = inst_42624;
var state_42801__$1 = (function (){var statearr_42843 = state_42801;
(statearr_42843[(22)] = inst_42626);

(statearr_42843[(23)] = inst_42625);

(statearr_42843[(12)] = inst_42628);

(statearr_42843[(10)] = inst_42629);

(statearr_42843[(11)] = inst_42627);

return statearr_42843;
})();
var statearr_42844_42990 = state_42801__$1;
(statearr_42844_42990[(2)] = null);

(statearr_42844_42990[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (31))){
var inst_42643 = (state_42801[(27)]);
var inst_42628 = (state_42801[(12)]);
var inst_42657 = (inst_42628 >= inst_42643);
var state_42801__$1 = state_42801;
if(cljs.core.truth_(inst_42657)){
var statearr_42845_42991 = state_42801__$1;
(statearr_42845_42991[(1)] = (33));

} else {
var statearr_42846_42992 = state_42801__$1;
(statearr_42846_42992[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (32))){
var inst_42757 = (state_42801[(2)]);
var state_42801__$1 = state_42801;
var statearr_42847_42993 = state_42801__$1;
(statearr_42847_42993[(2)] = inst_42757);

(statearr_42847_42993[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (40))){
var state_42801__$1 = state_42801;
var statearr_42848_42994 = state_42801__$1;
(statearr_42848_42994[(2)] = null);

(statearr_42848_42994[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (91))){
var inst_42782 = (state_42801[(2)]);
var state_42801__$1 = state_42801;
var statearr_42849_42995 = state_42801__$1;
(statearr_42849_42995[(2)] = inst_42782);

(statearr_42849_42995[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (56))){
var inst_42687 = (state_42801[(14)]);
var state_42801__$1 = state_42801;
var statearr_42850_42996 = state_42801__$1;
(statearr_42850_42996[(2)] = inst_42687);

(statearr_42850_42996[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (33))){
var state_42801__$1 = state_42801;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_42851_42997 = state_42801__$1;
(statearr_42851_42997[(1)] = (36));

} else {
var statearr_42852_42998 = state_42801__$1;
(statearr_42852_42998[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (13))){
var inst_42575 = (state_42801[(28)]);
var inst_42610 = (state_42801[(25)]);
var inst_42606 = (state_42801[(26)]);
var inst_42606__$1 = cljs.core.keys.call(null,inst_42575);
var inst_42607 = cljs.core.seq.call(null,inst_42606__$1);
var inst_42608 = cljs.core.first.call(null,inst_42607);
var inst_42609 = cljs.core.next.call(null,inst_42607);
var inst_42610__$1 = cljs.core.vals.call(null,inst_42575);
var inst_42611 = cljs.core.seq.call(null,inst_42610__$1);
var inst_42612 = cljs.core.first.call(null,inst_42611);
var inst_42613 = cljs.core.next.call(null,inst_42611);
var inst_42614 = cljs.core._EQ_.call(null,(0),limit);
var state_42801__$1 = (function (){var statearr_42853 = state_42801;
(statearr_42853[(29)] = inst_42613);

(statearr_42853[(30)] = inst_42609);

(statearr_42853[(25)] = inst_42610__$1);

(statearr_42853[(26)] = inst_42606__$1);

(statearr_42853[(31)] = inst_42612);

(statearr_42853[(32)] = inst_42608);

return statearr_42853;
})();
if(inst_42614){
var statearr_42854_42999 = state_42801__$1;
(statearr_42854_42999[(1)] = (16));

} else {
var statearr_42855_43000 = state_42801__$1;
(statearr_42855_43000[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (22))){
var inst_42626 = (state_42801[(22)]);
var inst_42625 = (state_42801[(23)]);
var inst_42637 = cljs.core.seq.call(null,inst_42625);
var inst_42638 = cljs.core.first.call(null,inst_42637);
var inst_42639 = cljs.core.next.call(null,inst_42637);
var inst_42640 = cljs.core.seq.call(null,inst_42626);
var inst_42641 = cljs.core.first.call(null,inst_42640);
var inst_42642 = cljs.core.next.call(null,inst_42640);
var inst_42643 = cljs.core.count.call(null,inst_42641);
var inst_42644 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_42645 = [headers,vars,inst_42641];
var inst_42646 = cljs.core.PersistentHashMap.fromArrays(inst_42644,inst_42645);
var inst_42647 = (inst_42641 == null);
var state_42801__$1 = (function (){var statearr_42856 = state_42801;
(statearr_42856[(8)] = inst_42638);

(statearr_42856[(27)] = inst_42643);

(statearr_42856[(19)] = inst_42642);

(statearr_42856[(20)] = inst_42639);

(statearr_42856[(16)] = inst_42646);

return statearr_42856;
})();
if(cljs.core.truth_(inst_42647)){
var statearr_42857_43001 = state_42801__$1;
(statearr_42857_43001[(1)] = (24));

} else {
var statearr_42858_43002 = state_42801__$1;
(statearr_42858_43002[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (90))){
var inst_42772 = (state_42801[(15)]);
var state_42801__$1 = state_42801;
var statearr_42859_43003 = state_42801__$1;
(statearr_42859_43003[(2)] = inst_42772);

(statearr_42859_43003[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (36))){
var inst_42628 = (state_42801[(12)]);
var inst_42660 = (inst_42628 - (1));
var state_42801__$1 = state_42801;
var statearr_42860_43004 = state_42801__$1;
(statearr_42860_43004[(2)] = inst_42660);

(statearr_42860_43004[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (41))){
var inst_42753 = (state_42801[(2)]);
var state_42801__$1 = state_42801;
var statearr_42861_43005 = state_42801__$1;
(statearr_42861_43005[(2)] = inst_42753);

(statearr_42861_43005[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (89))){
var inst_42772 = (state_42801[(15)]);
var inst_42777 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42778 = [inst_42772];
var inst_42779 = (new cljs.core.PersistentVector(null,1,(5),inst_42777,inst_42778,null));
var state_42801__$1 = state_42801;
var statearr_42862_43006 = state_42801__$1;
(statearr_42862_43006[(2)] = inst_42779);

(statearr_42862_43006[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (43))){
var inst_42673 = (state_42801[(18)]);
var inst_42676 = cljs.core.seq.call(null,inst_42673);
var state_42801__$1 = state_42801;
var statearr_42863_43007 = state_42801__$1;
(statearr_42863_43007[(2)] = inst_42676);

(statearr_42863_43007[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (61))){
var state_42801__$1 = state_42801;
var statearr_42864_43008 = state_42801__$1;
(statearr_42864_43008[(2)] = (0));

(statearr_42864_43008[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (29))){
var inst_42654 = (state_42801[(2)]);
var state_42801__$1 = state_42801;
if(cljs.core.truth_(inst_42654)){
var statearr_42865_43009 = state_42801__$1;
(statearr_42865_43009[(1)] = (30));

} else {
var statearr_42866_43010 = state_42801__$1;
(statearr_42866_43010[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (44))){
var inst_42674 = (state_42801[(33)]);
var state_42801__$1 = state_42801;
var statearr_42867_43011 = state_42801__$1;
(statearr_42867_43011[(2)] = inst_42674);

(statearr_42867_43011[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (93))){
var state_42801__$1 = state_42801;
var statearr_42868_43012 = state_42801__$1;
(statearr_42868_43012[(1)] = (95));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (6))){
var inst_42567 = (state_42801[(34)]);
var inst_42567__$1 = fluree.db.query.fql.build_order_fn.call(null,orderBy,groupBy);
var inst_42569 = fluree.db.query.fql.ad_hoc_group_by.call(null,res,groupBy);
var state_42801__$1 = (function (){var statearr_42870 = state_42801;
(statearr_42870[(35)] = inst_42569);

(statearr_42870[(34)] = inst_42567__$1);

return statearr_42870;
})();
if(cljs.core.truth_(inst_42567__$1)){
var statearr_42871_43013 = state_42801__$1;
(statearr_42871_43013[(1)] = (9));

} else {
var statearr_42872_43014 = state_42801__$1;
(statearr_42872_43014[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (28))){
var inst_42627 = (state_42801[(11)]);
var state_42801__$1 = state_42801;
var statearr_42873_43015 = state_42801__$1;
(statearr_42873_43015[(2)] = inst_42627);

(statearr_42873_43015[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (64))){
var inst_42628 = (state_42801[(12)]);
var inst_42709 = (inst_42628 - (1));
var state_42801__$1 = state_42801;
var statearr_42874_43016 = state_42801__$1;
(statearr_42874_43016[(2)] = inst_42709);

(statearr_42874_43016[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (51))){
var inst_42627 = (state_42801[(11)]);
var inst_42687 = (state_42801[(2)]);
var state_42801__$1 = (function (){var statearr_42875 = state_42801;
(statearr_42875[(14)] = inst_42687);

return statearr_42875;
})();
if(cljs.core.truth_(inst_42627)){
var statearr_42876_43017 = state_42801__$1;
(statearr_42876_43017[(1)] = (52));

} else {
var statearr_42877_43018 = state_42801__$1;
(statearr_42877_43018[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (25))){
var inst_42627 = (state_42801[(11)]);
var state_42801__$1 = state_42801;
if(cljs.core.truth_(inst_42627)){
var statearr_42878_43019 = state_42801__$1;
(statearr_42878_43019[(1)] = (27));

} else {
var statearr_42879_43020 = state_42801__$1;
(statearr_42879_43020[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (34))){
var state_42801__$1 = state_42801;
var statearr_42880_43021 = state_42801__$1;
(statearr_42880_43021[(1)] = (39));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (17))){
var state_42801__$1 = state_42801;
var statearr_42882_43022 = state_42801__$1;
(statearr_42882_43022[(2)] = limit);

(statearr_42882_43022[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (3))){
var inst_42799 = (state_42801[(2)]);
var state_42801__$1 = state_42801;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42801__$1,inst_42799);
} else {
if((state_val_42802 === (12))){
var inst_42575 = (state_42801[(28)]);
var inst_42577 = cljs.core.keys.call(null,inst_42575);
var inst_42578 = cljs.core.first.call(null,inst_42577);
var inst_42579 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_42580 = cljs.core.vals.call(null,inst_42575);
var inst_42581 = cljs.core.first.call(null,inst_42580);
var inst_42582 = [headers,vars,inst_42581];
var inst_42583 = cljs.core.PersistentHashMap.fromArrays(inst_42579,inst_42582);
var inst_42584 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,inst_42583,select_spec,limit,opts);
var state_42801__$1 = (function (){var statearr_42883 = state_42801;
(statearr_42883[(17)] = inst_42578);

return statearr_42883;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42801__$1,(15),inst_42584);
} else {
if((state_val_42802 === (2))){
var _ = (function (){var statearr_42884 = state_42801;
(statearr_42884[(4)] = cljs.core.cons.call(null,(5),(state_42801[(4)])));

return statearr_42884;
})();
var state_42801__$1 = state_42801;
if(cljs.core.truth_(groupBy)){
var statearr_42885_43023 = state_42801__$1;
(statearr_42885_43023[(1)] = (6));

} else {
var statearr_42886_43024 = state_42801__$1;
(statearr_42886_43024[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (66))){
var inst_42719 = (state_42801[(2)]);
var state_42801__$1 = state_42801;
var statearr_42887_43025 = state_42801__$1;
(statearr_42887_43025[(2)] = inst_42719);

(statearr_42887_43025[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (23))){
var inst_42761 = (state_42801[(2)]);
var state_42801__$1 = state_42801;
var statearr_42888_43026 = state_42801__$1;
(statearr_42888_43026[(2)] = inst_42761);

(statearr_42888_43026[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (47))){
var inst_42627 = (state_42801[(11)]);
var inst_42735 = (inst_42627 == null);
var state_42801__$1 = state_42801;
if(cljs.core.truth_(inst_42735)){
var statearr_42889_43027 = state_42801__$1;
(statearr_42889_43027[(1)] = (76));

} else {
var statearr_42890_43028 = state_42801__$1;
(statearr_42890_43028[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (35))){
var inst_42755 = (state_42801[(2)]);
var state_42801__$1 = state_42801;
var statearr_42891_43029 = state_42801__$1;
(statearr_42891_43029[(2)] = inst_42755);

(statearr_42891_43029[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (82))){
var state_42801__$1 = state_42801;
var statearr_42892_43030 = state_42801__$1;
(statearr_42892_43030[(2)] = (1));

(statearr_42892_43030[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (76))){
var state_42801__$1 = state_42801;
var statearr_42893_43031 = state_42801__$1;
(statearr_42893_43031[(2)] = null);

(statearr_42893_43031[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (97))){
var inst_42790 = (state_42801[(2)]);
var state_42801__$1 = state_42801;
var statearr_42894_43032 = state_42801__$1;
(statearr_42894_43032[(2)] = inst_42790);

(statearr_42894_43032[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (19))){
var inst_42619 = (state_42801[(36)]);
var state_42801__$1 = state_42801;
var statearr_42895_43033 = state_42801__$1;
(statearr_42895_43033[(2)] = inst_42619);

(statearr_42895_43033[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (57))){
var inst_42627 = (state_42801[(11)]);
var inst_42697 = (state_42801[(2)]);
var inst_42698 = (inst_42627 == null);
var state_42801__$1 = (function (){var statearr_42896 = state_42801;
(statearr_42896[(9)] = inst_42697);

return statearr_42896;
})();
if(cljs.core.truth_(inst_42698)){
var statearr_42897_43034 = state_42801__$1;
(statearr_42897_43034[(1)] = (58));

} else {
var statearr_42898_43035 = state_42801__$1;
(statearr_42898_43035[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (68))){
var state_42801__$1 = state_42801;
var statearr_42899_43036 = state_42801__$1;
(statearr_42899_43036[(2)] = null);

(statearr_42899_43036[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (11))){
var inst_42575 = (state_42801[(2)]);
var state_42801__$1 = (function (){var statearr_42901 = state_42801;
(statearr_42901[(28)] = inst_42575);

return statearr_42901;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_42902_43037 = state_42801__$1;
(statearr_42902_43037[(1)] = (12));

} else {
var statearr_42903_43038 = state_42801__$1;
(statearr_42903_43038[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (9))){
var inst_42569 = (state_42801[(35)]);
var inst_42567 = (state_42801[(34)]);
var inst_42571 = cljs.core.sorted_map_by.call(null,inst_42567);
var inst_42572 = cljs.core.into.call(null,inst_42571,inst_42569);
var state_42801__$1 = state_42801;
var statearr_42904_43039 = state_42801__$1;
(statearr_42904_43039[(2)] = inst_42572);

(statearr_42904_43039[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (5))){
var _ = (function (){var statearr_42905 = state_42801;
(statearr_42905[(4)] = cljs.core.rest.call(null,(state_42801[(4)])));

return statearr_42905;
})();
var state_42801__$1 = state_42801;
var ex42900 = (state_42801__$1[(2)]);
var statearr_42906_43040 = state_42801__$1;
(statearr_42906_43040[(5)] = ex42900);


if((ex42900 instanceof Error)){
var statearr_42907_43041 = state_42801__$1;
(statearr_42907_43041[(1)] = (4));

(statearr_42907_43041[(5)] = null);

} else {
throw ex42900;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (83))){
var state_42801__$1 = state_42801;
var statearr_42908_43042 = state_42801__$1;
(statearr_42908_43042[(2)] = limit);

(statearr_42908_43042[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (14))){
var inst_42763 = (state_42801[(2)]);
var state_42801__$1 = state_42801;
var statearr_42909_43043 = state_42801__$1;
(statearr_42909_43043[(2)] = inst_42763);

(statearr_42909_43043[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (45))){
var inst_42679 = (state_42801[(2)]);
var state_42801__$1 = state_42801;
if(cljs.core.truth_(inst_42679)){
var statearr_42910_43044 = state_42801__$1;
(statearr_42910_43044[(1)] = (46));

} else {
var statearr_42911_43045 = state_42801__$1;
(statearr_42911_43045[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (53))){
var inst_42627 = (state_42801[(11)]);
var state_42801__$1 = state_42801;
var statearr_42912_43046 = state_42801__$1;
(statearr_42912_43046[(2)] = inst_42627);

(statearr_42912_43046[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (78))){
var inst_42628 = (state_42801[(12)]);
var inst_42740 = (state_42801[(2)]);
var inst_42741 = (inst_42628 <= (0));
var state_42801__$1 = (function (){var statearr_42913 = state_42801;
(statearr_42913[(37)] = inst_42740);

return statearr_42913;
})();
if(cljs.core.truth_(inst_42741)){
var statearr_42914_43047 = state_42801__$1;
(statearr_42914_43047[(1)] = (79));

} else {
var statearr_42915_43048 = state_42801__$1;
(statearr_42915_43048[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (26))){
var inst_42759 = (state_42801[(2)]);
var state_42801__$1 = state_42801;
var statearr_42916_43049 = state_42801__$1;
(statearr_42916_43049[(2)] = inst_42759);

(statearr_42916_43049[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (16))){
var state_42801__$1 = state_42801;
var statearr_42917_43050 = state_42801__$1;
(statearr_42917_43050[(2)] = null);

(statearr_42917_43050[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (81))){
var inst_42638 = (state_42801[(8)]);
var inst_42740 = (state_42801[(37)]);
var inst_42642 = (state_42801[(19)]);
var inst_42639 = (state_42801[(20)]);
var inst_42673 = (state_42801[(18)]);
var inst_42629 = (state_42801[(10)]);
var inst_42746 = (state_42801[(2)]);
var inst_42747 = cljs.core.assoc.call(null,inst_42629,inst_42638,inst_42673);
var inst_42625 = inst_42639;
var inst_42626 = inst_42642;
var inst_42627 = inst_42740;
var inst_42628 = inst_42746;
var inst_42629__$1 = inst_42747;
var state_42801__$1 = (function (){var statearr_42920 = state_42801;
(statearr_42920[(22)] = inst_42626);

(statearr_42920[(23)] = inst_42625);

(statearr_42920[(12)] = inst_42628);

(statearr_42920[(10)] = inst_42629__$1);

(statearr_42920[(11)] = inst_42627);

return statearr_42920;
})();
var statearr_42921_43051 = state_42801__$1;
(statearr_42921_43051[(2)] = null);

(statearr_42921_43051[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (79))){
var state_42801__$1 = state_42801;
var statearr_42922_43052 = state_42801__$1;
(statearr_42922_43052[(2)] = (0));

(statearr_42922_43052[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (38))){
var inst_42642 = (state_42801[(19)]);
var inst_42639 = (state_42801[(20)]);
var inst_42629 = (state_42801[(10)]);
var inst_42627 = (state_42801[(11)]);
var inst_42664 = (state_42801[(2)]);
var tmp42918 = inst_42629;
var tmp42919 = inst_42627;
var inst_42625 = inst_42639;
var inst_42626 = inst_42642;
var inst_42627__$1 = tmp42919;
var inst_42628 = inst_42664;
var inst_42629__$1 = tmp42918;
var state_42801__$1 = (function (){var statearr_42923 = state_42801;
(statearr_42923[(22)] = inst_42626);

(statearr_42923[(23)] = inst_42625);

(statearr_42923[(12)] = inst_42628);

(statearr_42923[(10)] = inst_42629__$1);

(statearr_42923[(11)] = inst_42627__$1);

return statearr_42923;
})();
var statearr_42924_43053 = state_42801__$1;
(statearr_42924_43053[(2)] = null);

(statearr_42924_43053[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (87))){
var state_42801__$1 = state_42801;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_42925_43054 = state_42801__$1;
(statearr_42925_43054[(1)] = (92));

} else {
var statearr_42926_43055 = state_42801__$1;
(statearr_42926_43055[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (30))){
var inst_42629 = (state_42801[(10)]);
var state_42801__$1 = state_42801;
var statearr_42927_43056 = state_42801__$1;
(statearr_42927_43056[(2)] = inst_42629);

(statearr_42927_43056[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (73))){
var inst_42629 = (state_42801[(10)]);
var state_42801__$1 = state_42801;
var statearr_42928_43057 = state_42801__$1;
(statearr_42928_43057[(2)] = inst_42629);

(statearr_42928_43057[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (96))){
var state_42801__$1 = state_42801;
var statearr_42929_43058 = state_42801__$1;
(statearr_42929_43058[(2)] = null);

(statearr_42929_43058[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (10))){
var inst_42569 = (state_42801[(35)]);
var state_42801__$1 = state_42801;
var statearr_42930_43059 = state_42801__$1;
(statearr_42930_43059[(2)] = inst_42569);

(statearr_42930_43059[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (18))){
var inst_42619 = (state_42801[(36)]);
var inst_42618 = (state_42801[(2)]);
var inst_42619__$1 = offset;
var state_42801__$1 = (function (){var statearr_42931 = state_42801;
(statearr_42931[(24)] = inst_42618);

(statearr_42931[(36)] = inst_42619__$1);

return statearr_42931;
})();
if(cljs.core.truth_(inst_42619__$1)){
var statearr_42932_43060 = state_42801__$1;
(statearr_42932_43060[(1)] = (19));

} else {
var statearr_42933_43061 = state_42801__$1;
(statearr_42933_43061[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (52))){
var inst_42627 = (state_42801[(11)]);
var inst_42689 = ((0) < inst_42627);
var state_42801__$1 = state_42801;
var statearr_42934_43062 = state_42801__$1;
(statearr_42934_43062[(2)] = inst_42689);

(statearr_42934_43062[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (67))){
var inst_42643 = (state_42801[(27)]);
var inst_42697 = (state_42801[(9)]);
var inst_42628 = (state_42801[(12)]);
var inst_42712 = cljs.core.count.call(null,inst_42697);
var inst_42713 = (inst_42643 - inst_42712);
var inst_42714 = (inst_42628 - inst_42713);
var state_42801__$1 = state_42801;
var statearr_42935_43063 = state_42801__$1;
(statearr_42935_43063[(2)] = inst_42714);

(statearr_42935_43063[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (71))){
var inst_42697 = (state_42801[(9)]);
var inst_42725 = cljs.core.empty_QMARK_.call(null,inst_42697);
var state_42801__$1 = state_42801;
var statearr_42936_43064 = state_42801__$1;
(statearr_42936_43064[(2)] = inst_42725);

(statearr_42936_43064[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (42))){
var inst_42674 = (state_42801[(33)]);
var inst_42673 = (state_42801[(18)]);
var inst_42672 = (state_42801[(2)]);
var inst_42673__$1 = fluree.db.util.async.throw_err.call(null,inst_42672);
var inst_42674__$1 = cljs.core.coll_QMARK_.call(null,inst_42673__$1);
var state_42801__$1 = (function (){var statearr_42937 = state_42801;
(statearr_42937[(33)] = inst_42674__$1);

(statearr_42937[(18)] = inst_42673__$1);

return statearr_42937;
})();
if(inst_42674__$1){
var statearr_42938_43065 = state_42801__$1;
(statearr_42938_43065[(1)] = (43));

} else {
var statearr_42939_43066 = state_42801__$1;
(statearr_42939_43066[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (80))){
var inst_42628 = (state_42801[(12)]);
var inst_42744 = (inst_42628 - (1));
var state_42801__$1 = state_42801;
var statearr_42940_43067 = state_42801__$1;
(statearr_42940_43067[(2)] = inst_42744);

(statearr_42940_43067[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (37))){
var inst_42643 = (state_42801[(27)]);
var inst_42628 = (state_42801[(12)]);
var inst_42662 = (inst_42628 - inst_42643);
var state_42801__$1 = state_42801;
var statearr_42941_43068 = state_42801__$1;
(statearr_42941_43068[(2)] = inst_42662);

(statearr_42941_43068[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (63))){
var inst_42697 = (state_42801[(9)]);
var inst_42722 = (state_42801[(7)]);
var inst_42721 = (state_42801[(2)]);
var inst_42722__$1 = (inst_42697 == null);
var state_42801__$1 = (function (){var statearr_42942 = state_42801;
(statearr_42942[(7)] = inst_42722__$1);

(statearr_42942[(21)] = inst_42721);

return statearr_42942;
})();
if(cljs.core.truth_(inst_42722__$1)){
var statearr_42943_43069 = state_42801__$1;
(statearr_42943_43069[(1)] = (70));

} else {
var statearr_42944_43070 = state_42801__$1;
(statearr_42944_43070[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (94))){
var inst_42792 = (state_42801[(2)]);
var state_42801__$1 = state_42801;
var statearr_42945_43071 = state_42801__$1;
(statearr_42945_43071[(2)] = inst_42792);

(statearr_42945_43071[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (8))){
var inst_42796 = (state_42801[(2)]);
var _ = (function (){var statearr_42946 = state_42801;
(statearr_42946[(4)] = cljs.core.rest.call(null,(state_42801[(4)])));

return statearr_42946;
})();
var state_42801__$1 = state_42801;
var statearr_42947_43072 = state_42801__$1;
(statearr_42947_43072[(2)] = inst_42796);

(statearr_42947_43072[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (49))){
var inst_42673 = (state_42801[(18)]);
var inst_42628 = (state_42801[(12)]);
var inst_42684 = cljs.core.drop.call(null,inst_42628,inst_42673);
var state_42801__$1 = state_42801;
var statearr_42948_43073 = state_42801__$1;
(statearr_42948_43073[(2)] = inst_42684);

(statearr_42948_43073[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42802 === (84))){
var inst_42768 = (state_42801[(2)]);
var inst_42769 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,res,select_spec,inst_42768,opts);
var state_42801__$1 = state_42801;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42801__$1,(85),inst_42769);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16221__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16221__auto____0 = (function (){
var statearr_42949 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42949[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16221__auto__);

(statearr_42949[(1)] = (1));

return statearr_42949;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16221__auto____1 = (function (state_42801){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_42801);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e42950){var ex__16224__auto__ = e42950;
var statearr_42951_43074 = state_42801;
(statearr_42951_43074[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_42801[(4)]))){
var statearr_42952_43075 = state_42801;
(statearr_42952_43075[(1)] = cljs.core.first.call(null,(state_42801[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43076 = state_42801;
state_42801 = G__43076;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16221__auto__ = function(state_42801){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16221__auto____1.call(this,state_42801);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16221__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16221__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_42953 = f__16346__auto__.call(null);
(statearr_42953[(6)] = c__16345__auto__);

return statearr_42953;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__43079,opts){
var map__43080 = p__43079;
var map__43080__$1 = cljs.core.__destructure_map.call(null,map__43080);
var selectOne = cljs.core.get.call(null,map__43080__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var select = cljs.core.get.call(null,map__43080__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var selectDistinct = cljs.core.get.call(null,map__43080__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var selectReduced = cljs.core.get.call(null,map__43080__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var select_smt = (function (){var or__4212__auto__ = selectOne;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = select;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
var or__4212__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4212__auto____$2)){
return or__4212__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_.call(null,select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select.call(null,headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.call(null,(function (p1__43077_SHARP_){
return cljs.core.contains_QMARK_.call(null,p1__43077_SHARP_,new cljs.core.Keyword(null,"code","code",1586293142));
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some.call(null,(function (p1__43078_SHARP_){
return cljs.core.contains_QMARK_.call(null,p1__43078_SHARP_,new cljs.core.Keyword(null,"selection","selection",975998651));
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_.call(null,aggregates))?null:aggregates);
var orderBy = (function (){var temp__5753__auto__ = new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5753__auto__)){
var orderBy = temp__5753__auto__;
if(cljs.core.truth_((function (){var or__4212__auto__ = typeof orderBy === 'string';
if(or__4212__auto__){
return or__4212__auto__;
} else {
var and__4210__auto__ = cljs.core.vector_QMARK_.call(null,orderBy);
if(and__4210__auto__){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null).call(null,cljs.core.first.call(null,orderBy));
} else {
return and__4210__auto__;
}
}
})())){
if(cljs.core.vector_QMARK_.call(null,orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.call(null,["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289),new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"inVector?","inVector?",1948069375)],[expandMap_QMARK_,(function (){var or__4212__auto__ = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (100);
}
})(),(function (){var or__4212__auto__ = new cljs.core.Keyword(null,"offset","offset",296498311).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$.call(null,selectOne),(function (){var or__4212__auto__ = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return false;
}
})(),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667).cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$.call(null,(function (){var or__4212__auto__ = selectDistinct;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__43081,p__43082){
var map__43083 = p__43081;
var map__43083__$1 = cljs.core.__destructure_map.call(null,map__43083);
var query_map = map__43083__$1;
var construct = cljs.core.get.call(null,map__43083__$1,new cljs.core.Keyword(null,"construct","construct",692547932));
var map__43084 = p__43082;
var map__43084__$1 = cljs.core.__destructure_map.call(null,map__43084);
var where_result = map__43084__$1;
var headers = cljs.core.get.call(null,map__43084__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__43084__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__43085 = cljs.core.map.call(null,(function (construct_item){
var temp__5751__auto__ = fluree.db.util.core.index_of.call(null,headers,cljs.core.symbol.call(null,construct_item));
if(cljs.core.truth_(temp__5751__auto__)){
var index_of = temp__5751__auto__;
return (function (row){
return cljs.core.nth.call(null,row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.call(null,vec__43085,(0),null);
var fn2 = cljs.core.nth.call(null,vec__43085,(1),null);
var fn3 = cljs.core.nth.call(null,vec__43085,(2),null);
return cljs.core.map.call(null,(function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fn1.call(null,res),fn2.call(null,res),fn3.call(null,res)], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_43118){
var state_val_43119 = (state_43118[(1)]);
if((state_val_43119 === (7))){
var inst_43097 = (state_43118[(7)]);
var state_43118__$1 = state_43118;
var statearr_43120_43143 = state_43118__$1;
(statearr_43120_43143[(2)] = inst_43097);

(statearr_43120_43143[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43119 === (1))){
var state_43118__$1 = state_43118;
var statearr_43121_43144 = state_43118__$1;
(statearr_43121_43144[(2)] = null);

(statearr_43121_43144[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43119 === (4))){
var inst_43088 = (state_43118[(2)]);
var state_43118__$1 = state_43118;
var statearr_43122_43145 = state_43118__$1;
(statearr_43122_43145[(2)] = inst_43088);

(statearr_43122_43145[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43119 === (13))){
var inst_43107 = (state_43118[(2)]);
var inst_43108 = fluree.db.util.async.throw_err.call(null,inst_43107);
var state_43118__$1 = state_43118;
var statearr_43123_43146 = state_43118__$1;
(statearr_43123_43146[(2)] = inst_43108);

(statearr_43123_43146[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43119 === (6))){
var inst_43097 = (state_43118[(7)]);
var inst_43096 = (state_43118[(2)]);
var inst_43097__$1 = fluree.db.util.async.throw_err.call(null,inst_43096);
var inst_43098 = fluree.db.util.core.exception_QMARK_.call(null,inst_43097__$1);
var state_43118__$1 = (function (){var statearr_43124 = state_43118;
(statearr_43124[(7)] = inst_43097__$1);

return statearr_43124;
})();
if(inst_43098){
var statearr_43125_43147 = state_43118__$1;
(statearr_43125_43147[(1)] = (7));

} else {
var statearr_43126_43148 = state_43118__$1;
(statearr_43126_43148[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43119 === (3))){
var inst_43116 = (state_43118[(2)]);
var state_43118__$1 = state_43118;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43118__$1,inst_43116);
} else {
if((state_val_43119 === (12))){
var inst_43111 = (state_43118[(2)]);
var state_43118__$1 = state_43118;
var statearr_43127_43149 = state_43118__$1;
(statearr_43127_43149[(2)] = inst_43111);

(statearr_43127_43149[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43119 === (2))){
var _ = (function (){var statearr_43128 = state_43118;
(statearr_43128[(4)] = cljs.core.cons.call(null,(5),(state_43118[(4)])));

return statearr_43128;
})();
var inst_43094 = fluree.db.query.analytical.q.call(null,query_map,fuel,max_fuel,db,opts);
var state_43118__$1 = state_43118;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43118__$1,(6),inst_43094);
} else {
if((state_val_43119 === (11))){
var state_43118__$1 = state_43118;
var statearr_43130_43150 = state_43118__$1;
(statearr_43130_43150[(2)] = null);

(statearr_43130_43150[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43119 === (9))){
var inst_43113 = (state_43118[(2)]);
var _ = (function (){var statearr_43131 = state_43118;
(statearr_43131[(4)] = cljs.core.rest.call(null,(state_43118[(4)])));

return statearr_43131;
})();
var state_43118__$1 = state_43118;
var statearr_43132_43151 = state_43118__$1;
(statearr_43132_43151[(2)] = inst_43113);

(statearr_43132_43151[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43119 === (5))){
var _ = (function (){var statearr_43133 = state_43118;
(statearr_43133[(4)] = cljs.core.rest.call(null,(state_43118[(4)])));

return statearr_43133;
})();
var state_43118__$1 = state_43118;
var ex43129 = (state_43118__$1[(2)]);
var statearr_43134_43152 = state_43118__$1;
(statearr_43134_43152[(5)] = ex43129);


if((ex43129 instanceof Error)){
var statearr_43135_43153 = state_43118__$1;
(statearr_43135_43153[(1)] = (4));

(statearr_43135_43153[(5)] = null);

} else {
throw ex43129;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43119 === (10))){
var inst_43097 = (state_43118[(7)]);
var inst_43102 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_43097);
var inst_43103 = new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(inst_43097);
var inst_43104 = fluree.db.query.fql.get_ad_hoc_select_spec.call(null,inst_43102,inst_43103,query_map,opts);
var inst_43105 = fluree.db.query.fql.process_ad_hoc_res.call(null,db,fuel,max_fuel,inst_43097,inst_43104,opts);
var state_43118__$1 = state_43118;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43118__$1,(13),inst_43105);
} else {
if((state_val_43119 === (8))){
var state_43118__$1 = state_43118;
var statearr_43136_43154 = state_43118__$1;
(statearr_43136_43154[(1)] = (10));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__16221__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__16221__auto____0 = (function (){
var statearr_43138 = [null,null,null,null,null,null,null,null];
(statearr_43138[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__16221__auto__);

(statearr_43138[(1)] = (1));

return statearr_43138;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__16221__auto____1 = (function (state_43118){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_43118);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e43139){var ex__16224__auto__ = e43139;
var statearr_43140_43155 = state_43118;
(statearr_43140_43155[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_43118[(4)]))){
var statearr_43141_43156 = state_43118;
(statearr_43141_43156[(1)] = cljs.core.first.call(null,(state_43118[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43157 = state_43118;
state_43118 = G__43157;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__16221__auto__ = function(state_43118){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__16221__auto____1.call(this,state_43118);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__16221__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__16221__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_43142 = f__16346__auto__.call(null);
(statearr_43142[(6)] = c__16345__auto__);

return statearr_43142;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
fluree.db.util.log.debug.call(null,"Running query:",cljs.core.pr_str.call(null,query_map));

var map__43158 = query_map;
var map__43158__$1 = cljs.core.__destructure_map.call(null,map__43158);
var select = cljs.core.get.call(null,map__43158__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.call(null,map__43158__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var where = cljs.core.get.call(null,map__43158__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.call(null,map__43158__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__43158__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var component = cljs.core.get.call(null,map__43158__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var selectDistinct = cljs.core.get.call(null,map__43158__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var prettyPrint = cljs.core.get.call(null,map__43158__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectOne = cljs.core.get.call(null,map__43158__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var from = cljs.core.get.call(null,map__43158__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var opts = cljs.core.get.call(null,map__43158__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var groupBy = cljs.core.get.call(null,map__43158__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var opts_SINGLEQUOTE_ = (function (){var G__43159 = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"limit","limit",-1355822363),limit,new cljs.core.Keyword(null,"offset","offset",296498311),(function (){var or__4212__auto__ = offset;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})(),new cljs.core.Keyword(null,"component","component",1555936782),component,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),orderBy,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),groupBy,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),prettyPrint], null),opts);
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.call(null,G__43159,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
} else {
return G__43159;
}
})();
var max_fuel = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__4212__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
if(cljs.core.truth_((function (){var or__4212__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_.call(null,(0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_.call(null,where)){
return fluree.db.query.fql.ad_hoc_query.call(null,db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_43515){
var state_val_43516 = (state_43515[(1)]);
if((state_val_43516 === (121))){
var inst_43476 = (state_43515[(2)]);
var state_43515__$1 = state_43515;
var statearr_43517_43712 = state_43515__$1;
(statearr_43517_43712[(2)] = inst_43476);

(statearr_43517_43712[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (65))){
var inst_43353 = typeof from === 'string';
var state_43515__$1 = state_43515;
if(cljs.core.truth_(inst_43353)){
var statearr_43518_43713 = state_43515__$1;
(statearr_43518_43713[(1)] = (72));

} else {
var statearr_43519_43714 = state_43515__$1;
(statearr_43519_43714[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (70))){
var inst_43219 = (state_43515[(7)]);
var inst_43221 = (state_43515[(8)]);
var inst_43346 = (state_43515[(2)]);
var inst_43347 = fluree.db.util.async.throw_err.call(null,inst_43346);
var inst_43348 = fluree.db.query.fql.flake_select.call(null,db,inst_43221,fuel,max_fuel,inst_43219,inst_43347);
var state_43515__$1 = state_43515;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43515__$1,(71),inst_43348);
} else {
if((state_val_43516 === (62))){
var inst_43326 = (state_43515[(9)]);
var state_43515__$1 = state_43515;
var statearr_43520_43715 = state_43515__$1;
(statearr_43520_43715[(2)] = inst_43326);

(statearr_43520_43715[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (74))){
var inst_43482 = (state_43515[(2)]);
var state_43515__$1 = state_43515;
var statearr_43521_43716 = state_43515__$1;
(statearr_43521_43716[(2)] = inst_43482);

(statearr_43521_43716[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (110))){
var inst_43417 = (state_43515[(10)]);
var state_43515__$1 = state_43515;
var statearr_43522_43717 = state_43515__$1;
(statearr_43522_43717[(2)] = inst_43417);

(statearr_43522_43717[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (130))){
var inst_43502 = (state_43515[(2)]);
var state_43515__$1 = state_43515;
var statearr_43523_43718 = state_43515__$1;
(statearr_43523_43718[(2)] = inst_43502);

(statearr_43523_43718[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (128))){
var inst_43493 = (state_43515[(11)]);
var inst_43498 = fluree.db.util.core.exception_QMARK_.call(null,inst_43493);
var inst_43499 = (!(inst_43498));
var state_43515__$1 = state_43515;
var statearr_43524_43719 = state_43515__$1;
(statearr_43524_43719[(2)] = inst_43499);

(statearr_43524_43719[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (7))){
var inst_43189 = (state_43515[(12)]);
var inst_43189__$1 = selectOne;
var state_43515__$1 = (function (){var statearr_43525 = state_43515;
(statearr_43525[(12)] = inst_43189__$1);

return statearr_43525;
})();
if(cljs.core.truth_(inst_43189__$1)){
var statearr_43526_43720 = state_43515__$1;
(statearr_43526_43720[(1)] = (9));

} else {
var statearr_43527_43721 = state_43515__$1;
(statearr_43527_43721[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (59))){
var inst_43209 = (state_43515[(13)]);
var inst_43219 = (state_43515[(7)]);
var inst_43304 = (state_43515[(14)]);
var inst_43221 = (state_43515[(8)]);
var inst_43318 = (state_43515[(2)]);
var inst_43319 = fluree.db.util.async.throw_err.call(null,inst_43318);
var inst_43320 = cljs.core.sequence.call(null,inst_43304,inst_43319);
var inst_43321 = fluree.db.query.fql.subject_select.call(null,db,inst_43221,fuel,max_fuel,inst_43219,inst_43320,inst_43209);
var state_43515__$1 = state_43515;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43515__$1,(60),inst_43321);
} else {
if((state_val_43516 === (86))){
var inst_43209 = (state_43515[(13)]);
var inst_43211 = (state_43515[(15)]);
var inst_43219 = (state_43515[(7)]);
var inst_43221 = (state_43515[(8)]);
var inst_43386 = (state_43515[(2)]);
var inst_43387 = fluree.db.query.fql.subject_select.call(null,db,inst_43221,fuel,max_fuel,inst_43219,inst_43386,inst_43209,inst_43211);
var state_43515__$1 = state_43515;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43515__$1,(87),inst_43387);
} else {
if((state_val_43516 === (20))){
var inst_43253 = (state_43515[(2)]);
var inst_43254 = cljs.core.nth.call(null,inst_43253,(0),null);
var inst_43255 = cljs.core.nth.call(null,inst_43253,(1),null);
var inst_43256 = typeof where === 'string';
var state_43515__$1 = (function (){var statearr_43528 = state_43515;
(statearr_43528[(16)] = inst_43254);

(statearr_43528[(17)] = inst_43255);

return statearr_43528;
})();
if(cljs.core.truth_(inst_43256)){
var statearr_43529_43722 = state_43515__$1;
(statearr_43529_43722[(1)] = (30));

} else {
var statearr_43530_43723 = state_43515__$1;
(statearr_43530_43723[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (72))){
var inst_43208 = (state_43515[(18)]);
var state_43515__$1 = state_43515;
if(cljs.core.truth_(inst_43208)){
var statearr_43531_43724 = state_43515__$1;
(statearr_43531_43724[(1)] = (75));

} else {
var statearr_43532_43725 = state_43515__$1;
(statearr_43532_43725[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (58))){
var inst_43312 = (state_43515[(2)]);
var inst_43313 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43314 = [from];
var inst_43315 = (new cljs.core.PersistentVector(null,1,(5),inst_43313,inst_43314,null));
var inst_43316 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_43315,inst_43312);
var state_43515__$1 = state_43515;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43515__$1,(59),inst_43316);
} else {
if((state_val_43516 === (60))){
var inst_43323 = (state_43515[(2)]);
var inst_43324 = fluree.db.util.async.throw_err.call(null,inst_43323);
var state_43515__$1 = state_43515;
var statearr_43533_43726 = state_43515__$1;
(statearr_43533_43726[(2)] = inst_43324);

(statearr_43533_43726[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (27))){
var inst_43238 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43239 = [null,null];
var inst_43240 = (new cljs.core.PersistentVector(null,2,(5),inst_43238,inst_43239,null));
var state_43515__$1 = state_43515;
var statearr_43534_43727 = state_43515__$1;
(statearr_43534_43727[(2)] = inst_43240);

(statearr_43534_43727[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (1))){
var state_43515__$1 = state_43515;
var statearr_43535_43728 = state_43515__$1;
(statearr_43535_43728[(2)] = null);

(statearr_43535_43728[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (69))){
var inst_43343 = (state_43515[(2)]);
var inst_43344 = fluree.db.query.range._block_or_tx_collection.call(null,db,inst_43343);
var state_43515__$1 = state_43515;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43515__$1,(70),inst_43344);
} else {
if((state_val_43516 === (101))){
var inst_43449 = (state_43515[(2)]);
var state_43515__$1 = state_43515;
var statearr_43536_43729 = state_43515__$1;
(statearr_43536_43729[(2)] = inst_43449);

(statearr_43536_43729[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (24))){
var inst_43208 = (state_43515[(18)]);
var inst_43233 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43234 = [inst_43208,"ASC"];
var inst_43235 = (new cljs.core.PersistentVector(null,2,(5),inst_43233,inst_43234,null));
var state_43515__$1 = state_43515;
var statearr_43537_43730 = state_43515__$1;
(statearr_43537_43730[(2)] = inst_43235);

(statearr_43537_43730[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (102))){
var inst_43423 = (state_43515[(19)]);
var state_43515__$1 = state_43515;
var statearr_43538_43731 = state_43515__$1;
(statearr_43538_43731[(2)] = inst_43423);

(statearr_43538_43731[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (55))){
var inst_43208 = (state_43515[(18)]);
var inst_43304 = (state_43515[(2)]);
var state_43515__$1 = (function (){var statearr_43539 = state_43515;
(statearr_43539[(14)] = inst_43304);

return statearr_43539;
})();
if(cljs.core.truth_(inst_43208)){
var statearr_43540_43732 = state_43515__$1;
(statearr_43540_43732[(1)] = (56));

} else {
var statearr_43541_43733 = state_43515__$1;
(statearr_43541_43733[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (85))){
var inst_43378 = (state_43515[(20)]);
var inst_43382 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43383 = [inst_43378];
var inst_43384 = (new cljs.core.PersistentVector(null,1,(5),inst_43382,inst_43383,null));
var state_43515__$1 = state_43515;
var statearr_43542_43734 = state_43515__$1;
(statearr_43542_43734[(2)] = inst_43384);

(statearr_43542_43734[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (39))){
var inst_43209 = (state_43515[(13)]);
var state_43515__$1 = state_43515;
var statearr_43543_43735 = state_43515__$1;
(statearr_43543_43735[(2)] = inst_43209);

(statearr_43543_43735[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (88))){
var inst_43392 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core.inc);
var state_43515__$1 = state_43515;
var statearr_43544_43736 = state_43515__$1;
(statearr_43544_43736[(2)] = inst_43392);

(statearr_43544_43736[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (46))){
var inst_43289 = (state_43515[(2)]);
var state_43515__$1 = state_43515;
if(cljs.core.truth_(inst_43289)){
var statearr_43545_43737 = state_43515__$1;
(statearr_43545_43737[(1)] = (47));

} else {
var statearr_43546_43738 = state_43515__$1;
(statearr_43546_43738[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (4))){
var inst_43176 = (state_43515[(2)]);
var state_43515__$1 = state_43515;
var statearr_43547_43739 = state_43515__$1;
(statearr_43547_43739[(2)] = inst_43176);

(statearr_43547_43739[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (77))){
var inst_43362 = (state_43515[(2)]);
var inst_43363 = fluree.db.query.range.collection.call(null,db,from,inst_43362);
var state_43515__$1 = state_43515;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43515__$1,(78),inst_43363);
} else {
if((state_val_43516 === (106))){
var state_43515__$1 = state_43515;
var statearr_43548_43740 = state_43515__$1;
(statearr_43548_43740[(2)] = null);

(statearr_43548_43740[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (119))){
var inst_43468 = cljs.core.pr_str.call(null,query_map);
var inst_43469 = ["Invalid 'from' in query:",inst_43468].join('');
var inst_43470 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_43471 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_43472 = cljs.core.PersistentHashMap.fromArrays(inst_43470,inst_43471);
var inst_43473 = cljs.core.ex_info.call(null,inst_43469,inst_43472);
var state_43515__$1 = state_43515;
var statearr_43549_43741 = state_43515__$1;
(statearr_43549_43741[(2)] = inst_43473);

(statearr_43549_43741[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (95))){
var state_43515__$1 = state_43515;
var statearr_43550_43742 = state_43515__$1;
(statearr_43550_43742[(1)] = (119));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (54))){
var inst_43298 = (state_43515[(21)]);
var state_43515__$1 = state_43515;
var statearr_43552_43743 = state_43515__$1;
(statearr_43552_43743[(2)] = inst_43298);

(statearr_43552_43743[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (92))){
var inst_43397 = (state_43515[(22)]);
var state_43515__$1 = state_43515;
var statearr_43553_43744 = state_43515__$1;
(statearr_43553_43744[(2)] = inst_43397);

(statearr_43553_43744[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (104))){
var inst_43441 = (state_43515[(23)]);
var inst_43441__$1 = (state_43515[(2)]);
var state_43515__$1 = (function (){var statearr_43554 = state_43515;
(statearr_43554[(23)] = inst_43441__$1);

return statearr_43554;
})();
if(cljs.core.truth_(inst_43441__$1)){
var statearr_43555_43745 = state_43515__$1;
(statearr_43555_43745[(1)] = (109));

} else {
var statearr_43556_43746 = state_43515__$1;
(statearr_43556_43746[(1)] = (110));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (15))){
var inst_43212 = (state_43515[(24)]);
var inst_43210 = (state_43515[(25)]);
var inst_43216 = cljs.core.assoc.call(null,inst_43212,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),inst_43210);
var state_43515__$1 = state_43515;
var statearr_43557_43747 = state_43515__$1;
(statearr_43557_43747[(2)] = inst_43216);

(statearr_43557_43747[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (48))){
var inst_43326 = (state_43515[(9)]);
var inst_43326__$1 = typeof from === 'string';
var state_43515__$1 = (function (){var statearr_43558 = state_43515;
(statearr_43558[(9)] = inst_43326__$1);

return statearr_43558;
})();
if(cljs.core.truth_(inst_43326__$1)){
var statearr_43559_43748 = state_43515__$1;
(statearr_43559_43748[(1)] = (61));

} else {
var statearr_43560_43749 = state_43515__$1;
(statearr_43560_43749[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (50))){
var inst_43292 = (state_43515[(26)]);
var inst_43294 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_43295 = cljs.core.comp.call(null,inst_43292,inst_43294);
var state_43515__$1 = state_43515;
var statearr_43561_43750 = state_43515__$1;
(statearr_43561_43750[(2)] = inst_43295);

(statearr_43561_43750[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (116))){
var state_43515__$1 = state_43515;
var statearr_43562_43751 = state_43515__$1;
(statearr_43562_43751[(2)] = null);

(statearr_43562_43751[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (75))){
var inst_43356 = cljs.core.PersistentHashMap.EMPTY;
var state_43515__$1 = state_43515;
var statearr_43563_43752 = state_43515__$1;
(statearr_43563_43752[(2)] = inst_43356);

(statearr_43563_43752[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (99))){
var inst_43417 = (state_43515[(10)]);
var state_43515__$1 = state_43515;
var statearr_43564_43753 = state_43515__$1;
(statearr_43564_43753[(2)] = inst_43417);

(statearr_43564_43753[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (21))){
var inst_43208 = (state_43515[(18)]);
var inst_43225 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43226 = cljs.core.second.call(null,inst_43208);
var inst_43227 = cljs.core.first.call(null,inst_43208);
var inst_43228 = [inst_43226,inst_43227];
var inst_43229 = (new cljs.core.PersistentVector(null,2,(5),inst_43225,inst_43228,null));
var state_43515__$1 = state_43515;
var statearr_43565_43754 = state_43515__$1;
(statearr_43565_43754[(2)] = inst_43229);

(statearr_43565_43754[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (31))){
var inst_43283 = (state_43515[(27)]);
var inst_43283__$1 = typeof from === 'string';
var state_43515__$1 = (function (){var statearr_43566 = state_43515;
(statearr_43566[(27)] = inst_43283__$1);

return statearr_43566;
})();
if(cljs.core.truth_(inst_43283__$1)){
var statearr_43567_43755 = state_43515__$1;
(statearr_43567_43755[(1)] = (44));

} else {
var statearr_43568_43756 = state_43515__$1;
(statearr_43568_43756[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (113))){
var state_43515__$1 = state_43515;
var statearr_43569_43757 = state_43515__$1;
(statearr_43569_43757[(2)] = null);

(statearr_43569_43757[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (32))){
var inst_43254 = (state_43515[(16)]);
var inst_43488 = (state_43515[(2)]);
var state_43515__$1 = (function (){var statearr_43570 = state_43515;
(statearr_43570[(28)] = inst_43488);

return statearr_43570;
})();
if(cljs.core.truth_(inst_43254)){
var statearr_43571_43758 = state_43515__$1;
(statearr_43571_43758[(1)] = (122));

} else {
var statearr_43572_43759 = state_43515__$1;
(statearr_43572_43759[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (40))){
var inst_43208 = (state_43515[(18)]);
var inst_43273 = (state_43515[(2)]);
var state_43515__$1 = (function (){var statearr_43573 = state_43515;
(statearr_43573[(29)] = inst_43273);

return statearr_43573;
})();
if(cljs.core.truth_(inst_43208)){
var statearr_43574_43760 = state_43515__$1;
(statearr_43574_43760[(1)] = (41));

} else {
var statearr_43575_43761 = state_43515__$1;
(statearr_43575_43761[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (129))){
var inst_43496 = (state_43515[(30)]);
var state_43515__$1 = state_43515;
var statearr_43576_43762 = state_43515__$1;
(statearr_43576_43762[(2)] = inst_43496);

(statearr_43576_43762[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (91))){
var inst_43399 = cljs.core.every_QMARK_.call(null,fluree.db.util.core.subj_ident_QMARK_,from);
var state_43515__$1 = state_43515;
var statearr_43577_43763 = state_43515__$1;
(statearr_43577_43763[(2)] = inst_43399);

(statearr_43577_43763[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (117))){
var inst_43211 = (state_43515[(15)]);
var state_43515__$1 = state_43515;
var statearr_43578_43764 = state_43515__$1;
(statearr_43578_43764[(2)] = inst_43211);

(statearr_43578_43764[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (108))){
var inst_43438 = (state_43515[(2)]);
var inst_43439 = fluree.db.util.async.throw_err.call(null,inst_43438);
var state_43515__$1 = state_43515;
var statearr_43579_43765 = state_43515__$1;
(statearr_43579_43765[(2)] = inst_43439);

(statearr_43579_43765[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (56))){
var inst_43306 = cljs.core.PersistentHashMap.EMPTY;
var state_43515__$1 = state_43515;
var statearr_43580_43766 = state_43515__$1;
(statearr_43580_43766[(2)] = inst_43306);

(statearr_43580_43766[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (33))){
var state_43515__$1 = state_43515;
var statearr_43581_43767 = state_43515__$1;
(statearr_43581_43767[(2)] = from);

(statearr_43581_43767[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (13))){
var inst_43195 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_43196 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_43197 = cljs.core.PersistentHashMap.fromArrays(inst_43195,inst_43196);
var inst_43198 = cljs.core.ex_info.call(null,"Query missing :select or :selectOne.",inst_43197);
var inst_43199 = (function(){throw inst_43198})();
var state_43515__$1 = state_43515;
var statearr_43582_43768 = state_43515__$1;
(statearr_43582_43768[(2)] = inst_43199);

(statearr_43582_43768[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (22))){
var inst_43208 = (state_43515[(18)]);
var inst_43231 = typeof inst_43208 === 'string';
var state_43515__$1 = state_43515;
if(cljs.core.truth_(inst_43231)){
var statearr_43583_43769 = state_43515__$1;
(statearr_43583_43769[(1)] = (24));

} else {
var statearr_43584_43770 = state_43515__$1;
(statearr_43584_43770[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (90))){
var inst_43390 = (state_43515[(31)]);
var inst_43395 = (state_43515[(2)]);
var state_43515__$1 = (function (){var statearr_43585 = state_43515;
(statearr_43585[(32)] = inst_43395);

return statearr_43585;
})();
var statearr_43586_43771 = state_43515__$1;
(statearr_43586_43771[(2)] = inst_43390);

(statearr_43586_43771[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (109))){
var inst_43417 = (state_43515[(10)]);
var inst_43441 = (state_43515[(23)]);
var inst_43443 = cljs.core.conj.call(null,inst_43417,inst_43441);
var state_43515__$1 = state_43515;
var statearr_43587_43772 = state_43515__$1;
(statearr_43587_43772[(2)] = inst_43443);

(statearr_43587_43772[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (36))){
var inst_43208 = (state_43515[(18)]);
var inst_43268 = (state_43515[(2)]);
var inst_43269 = fluree.db.util.async.throw_err.call(null,inst_43268);
var state_43515__$1 = (function (){var statearr_43588 = state_43515;
(statearr_43588[(33)] = inst_43269);

return statearr_43588;
})();
if(cljs.core.truth_(inst_43208)){
var statearr_43589_43773 = state_43515__$1;
(statearr_43589_43773[(1)] = (38));

} else {
var statearr_43590_43774 = state_43515__$1;
(statearr_43590_43774[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (41))){
var state_43515__$1 = state_43515;
var statearr_43591_43775 = state_43515__$1;
(statearr_43591_43775[(2)] = null);

(statearr_43591_43775[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (118))){
var inst_43457 = (state_43515[(34)]);
var inst_43219 = (state_43515[(7)]);
var inst_43221 = (state_43515[(8)]);
var inst_43453 = (state_43515[(35)]);
var inst_43461 = (state_43515[(2)]);
var inst_43462 = fluree.db.query.fql.subject_select.call(null,db,inst_43221,fuel,max_fuel,inst_43219,inst_43453,inst_43457,inst_43461);
var state_43515__$1 = state_43515;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43515__$1,(112),inst_43462);
} else {
if((state_val_43516 === (89))){
var state_43515__$1 = state_43515;
var statearr_43592_43776 = state_43515__$1;
(statearr_43592_43776[(2)] = null);

(statearr_43592_43776[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (100))){
var inst_43423 = (state_43515[(19)]);
var inst_43428 = cljs.core.int_QMARK_.call(null,inst_43423);
var state_43515__$1 = state_43515;
if(inst_43428){
var statearr_43593_43777 = state_43515__$1;
(statearr_43593_43777[(1)] = (102));

} else {
var statearr_43594_43778 = state_43515__$1;
(statearr_43594_43778[(1)] = (103));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (131))){
var inst_43493 = (state_43515[(11)]);
var inst_43507 = cljs.core.first.call(null,inst_43493);
var state_43515__$1 = state_43515;
var statearr_43595_43779 = state_43515__$1;
(statearr_43595_43779[(2)] = inst_43507);

(statearr_43595_43779[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (122))){
var inst_43209 = (state_43515[(13)]);
var inst_43211 = (state_43515[(15)]);
var inst_43488 = (state_43515[(28)]);
var inst_43254 = (state_43515[(16)]);
var inst_43255 = (state_43515[(17)]);
var inst_43490 = fluree.db.query.fql.sort_offset_and_limit_res.call(null,inst_43254,inst_43255,inst_43211,inst_43209,inst_43488);
var state_43515__$1 = state_43515;
var statearr_43596_43780 = state_43515__$1;
(statearr_43596_43780[(2)] = inst_43490);

(statearr_43596_43780[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (43))){
var inst_43269 = (state_43515[(33)]);
var inst_43219 = (state_43515[(7)]);
var inst_43221 = (state_43515[(8)]);
var inst_43273 = (state_43515[(29)]);
var inst_43277 = (state_43515[(2)]);
var inst_43278 = fluree.db.query.fql.subject_select.call(null,db,inst_43221,fuel,max_fuel,inst_43219,inst_43269,inst_43273,inst_43277);
var state_43515__$1 = state_43515;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43515__$1,(37),inst_43278);
} else {
if((state_val_43516 === (61))){
var inst_43328 = ["_tx",null,"_block",null];
var inst_43329 = (new cljs.core.PersistentArrayMap(null,2,inst_43328,null));
var inst_43330 = (new cljs.core.PersistentHashSet(null,inst_43329,null));
var inst_43331 = inst_43330.call(null,from);
var state_43515__$1 = state_43515;
var statearr_43597_43781 = state_43515__$1;
(statearr_43597_43781[(2)] = inst_43331);

(statearr_43597_43781[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (29))){
var inst_43243 = (state_43515[(2)]);
var state_43515__$1 = state_43515;
var statearr_43598_43782 = state_43515__$1;
(statearr_43598_43782[(2)] = inst_43243);

(statearr_43598_43782[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (44))){
var inst_43285 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_43286 = clojure.string.includes_QMARK_.call(null,inst_43285,"/");
var state_43515__$1 = state_43515;
var statearr_43599_43783 = state_43515__$1;
(statearr_43599_43783[(2)] = inst_43286);

(statearr_43599_43783[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (93))){
var inst_43402 = (state_43515[(2)]);
var state_43515__$1 = state_43515;
if(cljs.core.truth_(inst_43402)){
var statearr_43600_43784 = state_43515__$1;
(statearr_43600_43784[(1)] = (94));

} else {
var statearr_43601_43785 = state_43515__$1;
(statearr_43601_43785[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (6))){
var inst_43186 = (state_43515[(36)]);
var state_43515__$1 = state_43515;
var statearr_43602_43786 = state_43515__$1;
(statearr_43602_43786[(2)] = inst_43186);

(statearr_43602_43786[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (111))){
var inst_43424 = (state_43515[(37)]);
var inst_43446 = (state_43515[(2)]);
var inst_43416 = inst_43424;
var inst_43417 = inst_43446;
var state_43515__$1 = (function (){var statearr_43603 = state_43515;
(statearr_43603[(38)] = inst_43416);

(statearr_43603[(10)] = inst_43417);

return statearr_43603;
})();
var statearr_43604_43787 = state_43515__$1;
(statearr_43604_43787[(2)] = null);

(statearr_43604_43787[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (28))){
var state_43515__$1 = state_43515;
var statearr_43605_43788 = state_43515__$1;
(statearr_43605_43788[(2)] = null);

(statearr_43605_43788[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (64))){
var inst_43208 = (state_43515[(18)]);
var state_43515__$1 = state_43515;
if(cljs.core.truth_(inst_43208)){
var statearr_43606_43789 = state_43515__$1;
(statearr_43606_43789[(1)] = (67));

} else {
var statearr_43607_43790 = state_43515__$1;
(statearr_43607_43790[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (103))){
var state_43515__$1 = state_43515;
if(cljs.core.truth_(fuel)){
var statearr_43608_43791 = state_43515__$1;
(statearr_43608_43791[(1)] = (105));

} else {
var statearr_43609_43792 = state_43515__$1;
(statearr_43609_43792[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (51))){
var inst_43292 = (state_43515[(26)]);
var state_43515__$1 = state_43515;
var statearr_43610_43793 = state_43515__$1;
(statearr_43610_43793[(2)] = inst_43292);

(statearr_43610_43793[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (25))){
var state_43515__$1 = state_43515;
var statearr_43611_43794 = state_43515__$1;
(statearr_43611_43794[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (34))){
var state_43515__$1 = state_43515;
var statearr_43613_43795 = state_43515__$1;
(statearr_43613_43795[(2)] = null);

(statearr_43613_43795[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (125))){
var inst_43496 = (state_43515[(30)]);
var inst_43493 = (state_43515[(11)]);
var inst_43496__$1 = cljs.core.coll_QMARK_.call(null,inst_43493);
var state_43515__$1 = (function (){var statearr_43614 = state_43515;
(statearr_43614[(30)] = inst_43496__$1);

return statearr_43614;
})();
if(inst_43496__$1){
var statearr_43615_43796 = state_43515__$1;
(statearr_43615_43796[(1)] = (128));

} else {
var statearr_43616_43797 = state_43515__$1;
(statearr_43616_43797[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (17))){
var inst_43208 = (state_43515[(18)]);
var inst_43219 = (state_43515[(2)]);
var inst_43220 = cljs.core.PersistentHashMap.EMPTY;
var inst_43221 = cljs.core.volatile_BANG_.call(null,inst_43220);
var state_43515__$1 = (function (){var statearr_43617 = state_43515;
(statearr_43617[(7)] = inst_43219);

(statearr_43617[(8)] = inst_43221);

return statearr_43617;
})();
if(cljs.core.truth_(inst_43208)){
var statearr_43618_43798 = state_43515__$1;
(statearr_43618_43798[(1)] = (18));

} else {
var statearr_43619_43799 = state_43515__$1;
(statearr_43619_43799[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (3))){
var inst_43513 = (state_43515[(2)]);
var state_43515__$1 = state_43515;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43515__$1,inst_43513);
} else {
if((state_val_43516 === (12))){
var inst_43192 = (state_43515[(39)]);
var state_43515__$1 = state_43515;
var statearr_43620_43800 = state_43515__$1;
(statearr_43620_43800[(2)] = inst_43192);

(statearr_43620_43800[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (2))){
var inst_43186 = (state_43515[(36)]);
var _ = (function (){var statearr_43621 = state_43515;
(statearr_43621[(4)] = cljs.core.cons.call(null,(5),(state_43515[(4)])));

return statearr_43621;
})();
var inst_43186__$1 = select;
var state_43515__$1 = (function (){var statearr_43622 = state_43515;
(statearr_43622[(36)] = inst_43186__$1);

return statearr_43622;
})();
if(cljs.core.truth_(inst_43186__$1)){
var statearr_43623_43801 = state_43515__$1;
(statearr_43623_43801[(1)] = (6));

} else {
var statearr_43624_43802 = state_43515__$1;
(statearr_43624_43802[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (66))){
var inst_43484 = (state_43515[(2)]);
var state_43515__$1 = state_43515;
var statearr_43625_43803 = state_43515__$1;
(statearr_43625_43803[(2)] = inst_43484);

(statearr_43625_43803[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (107))){
var inst_43423 = (state_43515[(19)]);
var inst_43435 = (state_43515[(2)]);
var inst_43436 = fluree.db.dbproto._subid.call(null,db,inst_43423,false);
var state_43515__$1 = (function (){var statearr_43626 = state_43515;
(statearr_43626[(40)] = inst_43435);

return statearr_43626;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43515__$1,(108),inst_43436);
} else {
if((state_val_43516 === (23))){
var inst_43247 = (state_43515[(2)]);
var state_43515__$1 = state_43515;
var statearr_43627_43804 = state_43515__$1;
(statearr_43627_43804[(2)] = inst_43247);

(statearr_43627_43804[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (47))){
var inst_43292 = cljs.core.map.call(null,fluree.db.query.fql.s);
var state_43515__$1 = (function (){var statearr_43628 = state_43515;
(statearr_43628[(26)] = inst_43292);

return statearr_43628;
})();
if(cljs.core.truth_(fuel)){
var statearr_43629_43805 = state_43515__$1;
(statearr_43629_43805[(1)] = (50));

} else {
var statearr_43630_43806 = state_43515__$1;
(statearr_43630_43806[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (35))){
var inst_43209 = (state_43515[(13)]);
var inst_43211 = (state_43515[(15)]);
var inst_43262 = (state_43515[(2)]);
var inst_43263 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_43264 = [inst_43209,inst_43211];
var inst_43265 = cljs.core.PersistentHashMap.fromArrays(inst_43263,inst_43264);
var inst_43266 = fluree.db.query.fql.where_filter.call(null,db,where,inst_43262,inst_43265);
var state_43515__$1 = state_43515;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43515__$1,(36),inst_43266);
} else {
if((state_val_43516 === (127))){
var inst_43505 = (state_43515[(2)]);
var state_43515__$1 = state_43515;
if(cljs.core.truth_(inst_43505)){
var statearr_43631_43807 = state_43515__$1;
(statearr_43631_43807[(1)] = (131));

} else {
var statearr_43632_43808 = state_43515__$1;
(statearr_43632_43808[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (82))){
var inst_43480 = (state_43515[(2)]);
var state_43515__$1 = state_43515;
var statearr_43633_43809 = state_43515__$1;
(statearr_43633_43809[(2)] = inst_43480);

(statearr_43633_43809[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (76))){
var inst_43209 = (state_43515[(13)]);
var inst_43211 = (state_43515[(15)]);
var inst_43358 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_43359 = [inst_43209,inst_43211];
var inst_43360 = cljs.core.PersistentHashMap.fromArrays(inst_43358,inst_43359);
var state_43515__$1 = state_43515;
var statearr_43634_43810 = state_43515__$1;
(statearr_43634_43810[(2)] = inst_43360);

(statearr_43634_43810[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (97))){
var inst_43423 = (state_43515[(19)]);
var inst_43416 = (state_43515[(38)]);
var inst_43422 = cljs.core.seq.call(null,inst_43416);
var inst_43423__$1 = cljs.core.first.call(null,inst_43422);
var inst_43424 = cljs.core.next.call(null,inst_43422);
var inst_43425 = cljs.core.not.call(null,inst_43423__$1);
var state_43515__$1 = (function (){var statearr_43635 = state_43515;
(statearr_43635[(37)] = inst_43424);

(statearr_43635[(19)] = inst_43423__$1);

return statearr_43635;
})();
if(inst_43425){
var statearr_43636_43811 = state_43515__$1;
(statearr_43636_43811[(1)] = (99));

} else {
var statearr_43637_43812 = state_43515__$1;
(statearr_43637_43812[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (19))){
var inst_43249 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43250 = [null,null];
var inst_43251 = (new cljs.core.PersistentVector(null,2,(5),inst_43249,inst_43250,null));
var state_43515__$1 = state_43515;
var statearr_43638_43813 = state_43515__$1;
(statearr_43638_43813[(2)] = inst_43251);

(statearr_43638_43813[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (57))){
var inst_43209 = (state_43515[(13)]);
var inst_43211 = (state_43515[(15)]);
var inst_43308 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_43309 = [inst_43209,inst_43211];
var inst_43310 = cljs.core.PersistentHashMap.fromArrays(inst_43308,inst_43309);
var state_43515__$1 = state_43515;
var statearr_43639_43814 = state_43515__$1;
(statearr_43639_43814[(2)] = inst_43310);

(statearr_43639_43814[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (68))){
var inst_43209 = (state_43515[(13)]);
var inst_43211 = (state_43515[(15)]);
var inst_43339 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_43340 = [inst_43209,inst_43211];
var inst_43341 = cljs.core.PersistentHashMap.fromArrays(inst_43339,inst_43340);
var state_43515__$1 = state_43515;
var statearr_43640_43815 = state_43515__$1;
(statearr_43640_43815[(2)] = inst_43341);

(statearr_43640_43815[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (11))){
var inst_43203 = (state_43515[(2)]);
var state_43515__$1 = state_43515;
var statearr_43641_43816 = state_43515__$1;
(statearr_43641_43816[(2)] = inst_43203);

(statearr_43641_43816[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (115))){
var inst_43208 = (state_43515[(18)]);
var inst_43457 = (state_43515[(2)]);
var state_43515__$1 = (function (){var statearr_43643 = state_43515;
(statearr_43643[(34)] = inst_43457);

return statearr_43643;
})();
if(cljs.core.truth_(inst_43208)){
var statearr_43644_43817 = state_43515__$1;
(statearr_43644_43817[(1)] = (116));

} else {
var statearr_43645_43818 = state_43515__$1;
(statearr_43645_43818[(1)] = (117));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (9))){
var inst_43189 = (state_43515[(12)]);
var state_43515__$1 = state_43515;
var statearr_43646_43819 = state_43515__$1;
(statearr_43646_43819[(2)] = inst_43189);

(statearr_43646_43819[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (5))){
var _ = (function (){var statearr_43647 = state_43515;
(statearr_43647[(4)] = cljs.core.rest.call(null,(state_43515[(4)])));

return statearr_43647;
})();
var state_43515__$1 = state_43515;
var ex43642 = (state_43515__$1[(2)]);
var statearr_43648_43820 = state_43515__$1;
(statearr_43648_43820[(5)] = ex43642);


if((ex43642 instanceof Error)){
var statearr_43649_43821 = state_43515__$1;
(statearr_43649_43821[(1)] = (4));

(statearr_43649_43821[(5)] = null);

} else {
throw ex43642;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (112))){
var inst_43464 = (state_43515[(2)]);
var inst_43465 = fluree.db.util.async.throw_err.call(null,inst_43464);
var state_43515__$1 = state_43515;
var statearr_43650_43822 = state_43515__$1;
(statearr_43650_43822[(2)] = inst_43465);

(statearr_43650_43822[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (83))){
var inst_43378 = (state_43515[(20)]);
var inst_43377 = (state_43515[(2)]);
var inst_43378__$1 = fluree.db.util.async.throw_err.call(null,inst_43377);
var inst_43379 = (inst_43378__$1 == null);
var state_43515__$1 = (function (){var statearr_43651 = state_43515;
(statearr_43651[(20)] = inst_43378__$1);

return statearr_43651;
})();
if(cljs.core.truth_(inst_43379)){
var statearr_43652_43823 = state_43515__$1;
(statearr_43652_43823[(1)] = (84));

} else {
var statearr_43653_43824 = state_43515__$1;
(statearr_43653_43824[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (14))){
var inst_43201 = (state_43515[(2)]);
var state_43515__$1 = state_43515;
var statearr_43654_43825 = state_43515__$1;
(statearr_43654_43825[(2)] = inst_43201);

(statearr_43654_43825[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (45))){
var inst_43283 = (state_43515[(27)]);
var state_43515__$1 = state_43515;
var statearr_43655_43826 = state_43515__$1;
(statearr_43655_43826[(2)] = inst_43283);

(statearr_43655_43826[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (53))){
var inst_43298 = (state_43515[(21)]);
var inst_43300 = cljs.core.distinct.call(null);
var inst_43301 = cljs.core.comp.call(null,inst_43298,inst_43300);
var state_43515__$1 = state_43515;
var statearr_43656_43827 = state_43515__$1;
(statearr_43656_43827[(2)] = inst_43301);

(statearr_43656_43827[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (78))){
var inst_43219 = (state_43515[(7)]);
var inst_43221 = (state_43515[(8)]);
var inst_43365 = (state_43515[(2)]);
var inst_43366 = fluree.db.util.async.throw_err.call(null,inst_43365);
var inst_43367 = fluree.db.query.fql.flake_select.call(null,db,inst_43221,fuel,max_fuel,inst_43219,inst_43366);
var state_43515__$1 = state_43515;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43515__$1,(79),inst_43367);
} else {
if((state_val_43516 === (132))){
var inst_43493 = (state_43515[(11)]);
var state_43515__$1 = state_43515;
var statearr_43657_43828 = state_43515__$1;
(statearr_43657_43828[(2)] = inst_43493);

(statearr_43657_43828[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (26))){
var inst_43245 = (state_43515[(2)]);
var state_43515__$1 = state_43515;
var statearr_43658_43829 = state_43515__$1;
(statearr_43658_43829[(2)] = inst_43245);

(statearr_43658_43829[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (123))){
var inst_43488 = (state_43515[(28)]);
var state_43515__$1 = state_43515;
var statearr_43659_43830 = state_43515__$1;
(statearr_43659_43830[(2)] = inst_43488);

(statearr_43659_43830[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (16))){
var inst_43212 = (state_43515[(24)]);
var state_43515__$1 = state_43515;
var statearr_43660_43831 = state_43515__$1;
(statearr_43660_43831[(2)] = inst_43212);

(statearr_43660_43831[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (133))){
var inst_43510 = (state_43515[(2)]);
var _ = (function (){var statearr_43661 = state_43515;
(statearr_43661[(4)] = cljs.core.rest.call(null,(state_43515[(4)])));

return statearr_43661;
})();
var state_43515__$1 = state_43515;
var statearr_43662_43832 = state_43515__$1;
(statearr_43662_43832[(2)] = inst_43510);

(statearr_43662_43832[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (81))){
var inst_43397 = (state_43515[(22)]);
var inst_43397__$1 = cljs.core.sequential_QMARK_.call(null,from);
var state_43515__$1 = (function (){var statearr_43663 = state_43515;
(statearr_43663[(22)] = inst_43397__$1);

return statearr_43663;
})();
if(inst_43397__$1){
var statearr_43664_43833 = state_43515__$1;
(statearr_43664_43833[(1)] = (91));

} else {
var statearr_43665_43834 = state_43515__$1;
(statearr_43665_43834[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (120))){
var state_43515__$1 = state_43515;
var statearr_43666_43835 = state_43515__$1;
(statearr_43666_43835[(2)] = null);

(statearr_43666_43835[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (79))){
var inst_43369 = (state_43515[(2)]);
var inst_43370 = fluree.db.util.async.throw_err.call(null,inst_43369);
var state_43515__$1 = state_43515;
var statearr_43667_43836 = state_43515__$1;
(statearr_43667_43836[(2)] = inst_43370);

(statearr_43667_43836[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (38))){
var state_43515__$1 = state_43515;
var statearr_43668_43837 = state_43515__$1;
(statearr_43668_43837[(2)] = null);

(statearr_43668_43837[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (126))){
var inst_43494 = (state_43515[(41)]);
var state_43515__$1 = state_43515;
var statearr_43669_43838 = state_43515__$1;
(statearr_43669_43838[(2)] = inst_43494);

(statearr_43669_43838[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (98))){
var inst_43208 = (state_43515[(18)]);
var inst_43451 = (state_43515[(2)]);
var inst_43452 = cljs.core.PersistentVector.EMPTY;
var inst_43453 = cljs.core.into.call(null,inst_43452,inst_43451);
var state_43515__$1 = (function (){var statearr_43670 = state_43515;
(statearr_43670[(35)] = inst_43453);

return statearr_43670;
})();
if(cljs.core.truth_(inst_43208)){
var statearr_43671_43839 = state_43515__$1;
(statearr_43671_43839[(1)] = (113));

} else {
var statearr_43672_43840 = state_43515__$1;
(statearr_43672_43840[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (124))){
var inst_43494 = (state_43515[(41)]);
var inst_43493 = (state_43515[(2)]);
var inst_43494__$1 = selectOne;
var state_43515__$1 = (function (){var statearr_43673 = state_43515;
(statearr_43673[(41)] = inst_43494__$1);

(statearr_43673[(11)] = inst_43493);

return statearr_43673;
})();
if(cljs.core.truth_(inst_43494__$1)){
var statearr_43674_43841 = state_43515__$1;
(statearr_43674_43841[(1)] = (125));

} else {
var statearr_43675_43842 = state_43515__$1;
(statearr_43675_43842[(1)] = (126));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (87))){
var inst_43389 = (state_43515[(2)]);
var inst_43390 = fluree.db.util.async.throw_err.call(null,inst_43389);
var state_43515__$1 = (function (){var statearr_43676 = state_43515;
(statearr_43676[(31)] = inst_43390);

return statearr_43676;
})();
if(cljs.core.truth_(fuel)){
var statearr_43677_43843 = state_43515__$1;
(statearr_43677_43843[(1)] = (88));

} else {
var statearr_43678_43844 = state_43515__$1;
(statearr_43678_43844[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (30))){
var inst_43258 = typeof from === 'string';
var state_43515__$1 = state_43515;
if(cljs.core.truth_(inst_43258)){
var statearr_43679_43845 = state_43515__$1;
(statearr_43679_43845[(1)] = (33));

} else {
var statearr_43680_43846 = state_43515__$1;
(statearr_43680_43846[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (73))){
var inst_43372 = fluree.db.util.core.subj_ident_QMARK_.call(null,from);
var state_43515__$1 = state_43515;
if(inst_43372){
var statearr_43681_43847 = state_43515__$1;
(statearr_43681_43847[(1)] = (80));

} else {
var statearr_43682_43848 = state_43515__$1;
(statearr_43682_43848[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (96))){
var inst_43478 = (state_43515[(2)]);
var state_43515__$1 = state_43515;
var statearr_43683_43849 = state_43515__$1;
(statearr_43683_43849[(2)] = inst_43478);

(statearr_43683_43849[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (10))){
var inst_43192 = (state_43515[(39)]);
var inst_43192__$1 = selectDistinct;
var state_43515__$1 = (function (){var statearr_43684 = state_43515;
(statearr_43684[(39)] = inst_43192__$1);

return statearr_43684;
})();
if(cljs.core.truth_(inst_43192__$1)){
var statearr_43685_43850 = state_43515__$1;
(statearr_43685_43850[(1)] = (12));

} else {
var statearr_43686_43851 = state_43515__$1;
(statearr_43686_43851[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (18))){
var inst_43208 = (state_43515[(18)]);
var inst_43223 = cljs.core.vector_QMARK_.call(null,inst_43208);
var state_43515__$1 = state_43515;
if(inst_43223){
var statearr_43687_43852 = state_43515__$1;
(statearr_43687_43852[(1)] = (21));

} else {
var statearr_43688_43853 = state_43515__$1;
(statearr_43688_43853[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (105))){
var inst_43432 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core.inc);
var state_43515__$1 = state_43515;
var statearr_43689_43854 = state_43515__$1;
(statearr_43689_43854[(2)] = inst_43432);

(statearr_43689_43854[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (52))){
var inst_43298 = (state_43515[(2)]);
var state_43515__$1 = (function (){var statearr_43690 = state_43515;
(statearr_43690[(21)] = inst_43298);

return statearr_43690;
})();
var statearr_43691_43855 = state_43515__$1;
(statearr_43691_43855[(1)] = (53));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (114))){
var inst_43209 = (state_43515[(13)]);
var state_43515__$1 = state_43515;
var statearr_43693_43856 = state_43515__$1;
(statearr_43693_43856[(2)] = inst_43209);

(statearr_43693_43856[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (67))){
var inst_43337 = cljs.core.PersistentHashMap.EMPTY;
var state_43515__$1 = state_43515;
var statearr_43694_43857 = state_43515__$1;
(statearr_43694_43857[(2)] = inst_43337);

(statearr_43694_43857[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (71))){
var inst_43350 = (state_43515[(2)]);
var inst_43351 = fluree.db.util.async.throw_err.call(null,inst_43350);
var state_43515__$1 = state_43515;
var statearr_43695_43858 = state_43515__$1;
(statearr_43695_43858[(2)] = inst_43351);

(statearr_43695_43858[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (42))){
var inst_43211 = (state_43515[(15)]);
var state_43515__$1 = state_43515;
var statearr_43696_43859 = state_43515__$1;
(statearr_43696_43859[(2)] = inst_43211);

(statearr_43696_43859[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (80))){
var inst_43375 = fluree.db.dbproto._subid.call(null,db,from,false);
var state_43515__$1 = state_43515;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43515__$1,(83),inst_43375);
} else {
if((state_val_43516 === (37))){
var inst_43280 = (state_43515[(2)]);
var inst_43281 = fluree.db.util.async.throw_err.call(null,inst_43280);
var state_43515__$1 = state_43515;
var statearr_43697_43860 = state_43515__$1;
(statearr_43697_43860[(2)] = inst_43281);

(statearr_43697_43860[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (63))){
var inst_43334 = (state_43515[(2)]);
var state_43515__$1 = state_43515;
if(cljs.core.truth_(inst_43334)){
var statearr_43698_43861 = state_43515__$1;
(statearr_43698_43861[(1)] = (64));

} else {
var statearr_43699_43862 = state_43515__$1;
(statearr_43699_43862[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (94))){
var inst_43411 = from;
var inst_43412 = cljs.core.seq.call(null,inst_43411);
var inst_43413 = cljs.core.first.call(null,inst_43412);
var inst_43414 = cljs.core.next.call(null,inst_43412);
var inst_43415 = cljs.core.PersistentVector.EMPTY;
var inst_43416 = inst_43411;
var inst_43417 = inst_43415;
var state_43515__$1 = (function (){var statearr_43700 = state_43515;
(statearr_43700[(42)] = inst_43413);

(statearr_43700[(43)] = inst_43414);

(statearr_43700[(38)] = inst_43416);

(statearr_43700[(10)] = inst_43417);

return statearr_43700;
})();
var statearr_43701_43863 = state_43515__$1;
(statearr_43701_43863[(2)] = null);

(statearr_43701_43863[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (8))){
var inst_43210 = (state_43515[(25)]);
var inst_43205 = (state_43515[(2)]);
var inst_43206 = opts_SINGLEQUOTE_;
var inst_43207 = cljs.core.__destructure_map.call(null,inst_43206);
var inst_43208 = cljs.core.get.call(null,inst_43207,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_43209 = cljs.core.get.call(null,inst_43207,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_43210__$1 = cljs.core.get.call(null,inst_43207,new cljs.core.Keyword(null,"component","component",1555936782));
var inst_43211 = cljs.core.get.call(null,inst_43207,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_43212 = fluree.db.query.fql_parser.parse_db.call(null,db,inst_43205,opts_SINGLEQUOTE_);
var inst_43213 = (inst_43210__$1 == null);
var inst_43214 = cljs.core.not.call(null,inst_43213);
var state_43515__$1 = (function (){var statearr_43702 = state_43515;
(statearr_43702[(13)] = inst_43209);

(statearr_43702[(15)] = inst_43211);

(statearr_43702[(24)] = inst_43212);

(statearr_43702[(18)] = inst_43208);

(statearr_43702[(25)] = inst_43210__$1);

return statearr_43702;
})();
if(inst_43214){
var statearr_43703_43864 = state_43515__$1;
(statearr_43703_43864[(1)] = (15));

} else {
var statearr_43704_43865 = state_43515__$1;
(statearr_43704_43865[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (49))){
var inst_43486 = (state_43515[(2)]);
var state_43515__$1 = state_43515;
var statearr_43705_43866 = state_43515__$1;
(statearr_43705_43866[(2)] = inst_43486);

(statearr_43705_43866[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43516 === (84))){
var state_43515__$1 = state_43515;
var statearr_43706_43867 = state_43515__$1;
(statearr_43706_43867[(2)] = null);

(statearr_43706_43867[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__16221__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__16221__auto____0 = (function (){
var statearr_43707 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43707[(0)] = fluree$db$query$fql$query_$_state_machine__16221__auto__);

(statearr_43707[(1)] = (1));

return statearr_43707;
});
var fluree$db$query$fql$query_$_state_machine__16221__auto____1 = (function (state_43515){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_43515);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e43708){var ex__16224__auto__ = e43708;
var statearr_43709_43868 = state_43515;
(statearr_43709_43868[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_43515[(4)]))){
var statearr_43710_43869 = state_43515;
(statearr_43710_43869[(1)] = cljs.core.first.call(null,(state_43515[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43870 = state_43515;
state_43515 = G__43870;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__16221__auto__ = function(state_43515){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__16221__auto____1.call(this,state_43515);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__16221__auto____0;
fluree$db$query$fql$query_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__16221__auto____1;
return fluree$db$query$fql$query_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_43711 = f__16346__auto__.call(null);
(statearr_43711[(6)] = c__16345__auto__);

return statearr_43711;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}

});
