// Compiled by ClojureScript 1.10.879 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.call(null,(function (value_group){
var stringified = cljs.core.map.call(null,(function (p1__37304_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__37304_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.call(null," ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.call(null," ",value_groups);
return ["VALUES ( ",clojure.string.join.call(null," ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__37308 = coll;
var vec__37309 = G__37308;
var seq__37310 = cljs.core.seq.call(null,vec__37309);
var first__37311 = cljs.core.first.call(null,seq__37310);
var seq__37310__$1 = cljs.core.next.call(null,seq__37310);
var clause = first__37311;
var r = seq__37310__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__37308__$1 = G__37308;
var res__$1 = res;
while(true){
var vec__37315 = G__37308__$1;
var seq__37316 = cljs.core.seq.call(null,vec__37315);
var first__37317 = cljs.core.first.call(null,seq__37316);
var seq__37316__$1 = cljs.core.next.call(null,seq__37316);
var clause__$1 = first__37317;
var r__$1 = seq__37316__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__37318 = r__$1;
var G__37319 = cljs.core.conj.call(null,res__$2,clause__$1);
G__37308__$1 = G__37318;
res__$1 = G__37319;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.call(null,(function (res,p__37320){
var map__37321 = p__37320;
var map__37321__$1 = cljs.core.__destructure_map.call(null,map__37321);
var optional = cljs.core.get.call(null,map__37321__$1,new cljs.core.Keyword(null,"optional","optional",2053951509));
if(cljs.core.truth_(optional)){
return cljs.core.into.call(null,res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__37325 = coll;
var vec__37326 = G__37325;
var seq__37327 = cljs.core.seq.call(null,vec__37326);
var first__37328 = cljs.core.first.call(null,seq__37327);
var seq__37327__$1 = cljs.core.next.call(null,seq__37327);
var clause = first__37328;
var r = seq__37327__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__37325__$1 = G__37325;
var res__$1 = res;
while(true){
var vec__37332 = G__37325__$1;
var seq__37333 = cljs.core.seq.call(null,vec__37332);
var first__37334 = cljs.core.first.call(null,seq__37333);
var seq__37333__$1 = cljs.core.next.call(null,seq__37333);
var clause__$1 = first__37334;
var r__$1 = seq__37333__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__37335 = r__$1;
var G__37336 = cljs.core.conj.call(null,res__$2,cljs.core.rest.call(null,clause__$1));
G__37325__$1 = G__37335;
res__$1 = G__37336;
continue;
} else {
var G__37337 = r__$1;
var G__37338 = res__$2;
G__37325__$1 = G__37337;
res__$1 = G__37338;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__37342 = coll;
var vec__37343 = G__37342;
var seq__37344 = cljs.core.seq.call(null,vec__37343);
var first__37345 = cljs.core.first.call(null,seq__37344);
var seq__37344__$1 = cljs.core.next.call(null,seq__37344);
var clause = first__37345;
var r = seq__37344__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__37342__$1 = G__37342;
var res__$1 = res;
while(true){
var vec__37349 = G__37342__$1;
var seq__37350 = cljs.core.seq.call(null,vec__37349);
var first__37351 = cljs.core.first.call(null,seq__37350);
var seq__37350__$1 = cljs.core.next.call(null,seq__37350);
var clause__$1 = first__37351;
var r__$1 = seq__37350__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__37352 = r__$1;
var G__37353 = res__$2;
G__37342__$1 = G__37352;
res__$1 = G__37353;
continue;
} else {
var G__37354 = r__$1;
var G__37355 = cljs.core.conj.call(null,res__$2,clause__$1);
G__37342__$1 = G__37354;
res__$1 = G__37355;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__37358 = clause;
var G__37358__$1 = ((cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause)))?cljs.core.drop.call(null,(1),G__37358):G__37358);
var G__37358__$2 = clojure.string.join.call(null," ",G__37358__$1)
;
var G__37358__$3 = (function (p1__37356_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__37356_SHARP_)," ."].join('');
}).call(null,G__37358__$2)
;
if(cljs.core.truth_(optional_QMARK_)){
return (function (p1__37357_SHARP_){
return ["OPTIONAL {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__37357_SHARP_),"}"].join('');
}).call(null,G__37358__$3);
} else {
return G__37358__$3;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.call(null,(function (acc_str,prefix){
var pfx = cljs.core.symbol.call(null,[fluree.db.util.core.keyword__GT_str.call(null,cljs.core.key.call(null,prefix)),":"].join(''));
var source = cljs.core.symbol.call(null,cljs.core.val.call(null,prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map));
var map__37362 = opts;
var map__37362__$1 = cljs.core.__destructure_map.call(null,map__37362);
var limit = cljs.core.get.call(null,map__37362__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__37362__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.call(null,map__37362__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.call(null,map__37362__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.call(null,map__37362__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes.call(null,prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.call(null," ",cljs.core.map.call(null,(function (p1__37359_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__37359_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.call(null," ",select_vars)].join('');
var where_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__37360_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__37360_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__37361_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__37361_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4212__auto__ = language;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_37376){
var state_val_37377 = (state_37376[(1)]);
if((state_val_37377 === (1))){
var inst_37363 = fluree.db.util.core.url_encode.call(null,query);
var inst_37364 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_37363)].join('');
var inst_37365 = ["User-Agent","Accept"];
var inst_37366 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_37367 = cljs.core.PersistentHashMap.fromArrays(inst_37365,inst_37366);
var inst_37368 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_37369 = [inst_37367,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_37370 = cljs.core.PersistentHashMap.fromArrays(inst_37368,inst_37369);
var inst_37371 = fluree.db.util.xhttp.get.call(null,inst_37364,inst_37370);
var state_37376__$1 = state_37376;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37376__$1,(2),inst_37371);
} else {
if((state_val_37377 === (2))){
var inst_37373 = (state_37376[(2)]);
var inst_37374 = fluree.db.util.async.throw_err.call(null,inst_37373);
var state_37376__$1 = state_37376;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37376__$1,inst_37374);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16221__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16221__auto____0 = (function (){
var statearr_37378 = [null,null,null,null,null,null,null];
(statearr_37378[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16221__auto__);

(statearr_37378[(1)] = (1));

return statearr_37378;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16221__auto____1 = (function (state_37376){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_37376);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e37379){var ex__16224__auto__ = e37379;
var statearr_37380_37383 = state_37376;
(statearr_37380_37383[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_37376[(4)]))){
var statearr_37381_37384 = state_37376;
(statearr_37381_37384[(1)] = cljs.core.first.call(null,(state_37376[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37385 = state_37376;
state_37376 = G__37385;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16221__auto__ = function(state_37376){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16221__auto____1.call(this,state_37376);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16221__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16221__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_37382 = f__16346__auto__.call(null);
(statearr_37382[(6)] = c__16345__auto__);

return statearr_37382;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_37403){
var state_val_37404 = (state_37403[(1)]);
if((state_val_37404 === (1))){
var inst_37386 = fluree.db.query.analytical_wikidata.submit_wikidata_query.call(null,query);
var state_37403__$1 = state_37403;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37403__$1,(2),inst_37386);
} else {
if((state_val_37404 === (2))){
var inst_37389 = (state_37403[(7)]);
var inst_37388 = (state_37403[(2)]);
var inst_37389__$1 = fluree.db.util.async.throw_err.call(null,inst_37388);
var inst_37390 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_37389__$1);
var inst_37391 = cljs.core.not_EQ_.call(null,(200),inst_37390);
var state_37403__$1 = (function (){var statearr_37405 = state_37403;
(statearr_37405[(7)] = inst_37389__$1);

return statearr_37405;
})();
if(inst_37391){
var statearr_37406_37415 = state_37403__$1;
(statearr_37406_37415[(1)] = (3));

} else {
var statearr_37407_37416 = state_37403__$1;
(statearr_37407_37416[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37404 === (3))){
var inst_37389 = (state_37403[(7)]);
var state_37403__$1 = state_37403;
var statearr_37408_37417 = state_37403__$1;
(statearr_37408_37417[(2)] = inst_37389);

(statearr_37408_37417[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37404 === (4))){
var inst_37389 = (state_37403[(7)]);
var inst_37394 = (function (){var body = inst_37389;
return (function (item){
return cljs.core.reduce.call(null,(function (acc,k_v){
return cljs.core.assoc.call(null,acc,cljs.core.key.call(null,k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_37395 = cljs.core.second.call(null,inst_37389);
var inst_37396 = cljs.core.second.call(null,inst_37395);
var inst_37397 = cljs.core.first.call(null,inst_37396);
var inst_37398 = cljs.core.second.call(null,inst_37397);
var inst_37399 = cljs.core.mapv.call(null,inst_37394,inst_37398);
var state_37403__$1 = state_37403;
var statearr_37409_37418 = state_37403__$1;
(statearr_37409_37418[(2)] = inst_37399);

(statearr_37409_37418[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37404 === (5))){
var inst_37401 = (state_37403[(2)]);
var state_37403__$1 = state_37403;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37403__$1,inst_37401);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16221__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16221__auto____0 = (function (){
var statearr_37410 = [null,null,null,null,null,null,null,null];
(statearr_37410[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16221__auto__);

(statearr_37410[(1)] = (1));

return statearr_37410;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16221__auto____1 = (function (state_37403){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_37403);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e37411){var ex__16224__auto__ = e37411;
var statearr_37412_37419 = state_37403;
(statearr_37412_37419[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_37403[(4)]))){
var statearr_37413_37420 = state_37403;
(statearr_37413_37420[(1)] = cljs.core.first.call(null,(state_37403[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37421 = state_37403;
state_37403 = G__37421;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16221__auto__ = function(state_37403){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16221__auto____1.call(this,state_37403);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16221__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16221__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_37414 = f__16346__auto__.call(null);
(statearr_37414[(6)] = c__16345__auto__);

return statearr_37414;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.call(null,(function (p1__37422_SHARP_){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__37422_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.call(null,cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.call(null,(function (p1__37423_SHARP_){
return fluree.db.util.core.str__GT_keyword.call(null,cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__37423_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.call(null,(function (res){
return cljs.core.map.call(null,(function (p1__37424_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(p1__37424_SHARP_.call(null,res));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_37470){
var state_val_37471 = (state_37470[(1)]);
if((state_val_37471 === (7))){
var inst_37435 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt.call(null,matching_vars,matching_vals);
var state_37470__$1 = state_37470;
var statearr_37472_37500 = state_37470__$1;
(statearr_37472_37500[(2)] = inst_37435);

(statearr_37472_37500[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37471 === (1))){
var state_37470__$1 = state_37470;
var statearr_37473_37501 = state_37470__$1;
(statearr_37473_37501[(2)] = null);

(statearr_37473_37501[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37471 === (4))){
var inst_37425 = (state_37470[(2)]);
var state_37470__$1 = state_37470;
var statearr_37474_37502 = state_37470__$1;
(statearr_37474_37502[(2)] = inst_37425);

(statearr_37474_37502[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37471 === (15))){
var inst_37449 = (state_37470[(7)]);
var inst_37444 = (state_37470[(8)]);
var inst_37443 = (state_37470[(9)]);
var inst_37454 = (state_37470[(2)]);
var inst_37455 = cljs.core.subs.call(null,inst_37449,(0),inst_37454);
var inst_37456 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_37457 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_37443);
var inst_37458 = [inst_37444,inst_37457];
var inst_37459 = cljs.core.PersistentHashMap.fromArrays(inst_37456,inst_37458);
var inst_37460 = cljs.core.ex_info.call(null,inst_37455,inst_37459);
var inst_37461 = (function(){throw inst_37460})();
var state_37470__$1 = state_37470;
var statearr_37475_37503 = state_37470__$1;
(statearr_37475_37503[(2)] = inst_37461);

(statearr_37475_37503[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37471 === (13))){
var inst_37448 = (state_37470[(10)]);
var state_37470__$1 = state_37470;
var statearr_37476_37504 = state_37470__$1;
(statearr_37476_37504[(2)] = inst_37448);

(statearr_37476_37504[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37471 === (6))){
var state_37470__$1 = state_37470;
var statearr_37477_37505 = state_37470__$1;
(statearr_37477_37505[(2)] = null);

(statearr_37477_37505[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37471 === (3))){
var inst_37468 = (state_37470[(2)]);
var state_37470__$1 = state_37470;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37470__$1,inst_37468);
} else {
if((state_val_37471 === (12))){
var inst_37465 = (state_37470[(2)]);
var _ = (function (){var statearr_37478 = state_37470;
(statearr_37478[(4)] = cljs.core.rest.call(null,(state_37470[(4)])));

return statearr_37478;
})();
var state_37470__$1 = state_37470;
var statearr_37479_37506 = state_37470__$1;
(statearr_37479_37506[(2)] = inst_37465);

(statearr_37479_37506[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37471 === (2))){
var _ = (function (){var statearr_37480 = state_37470;
(statearr_37480[(4)] = cljs.core.cons.call(null,(5),(state_37470[(4)])));

return statearr_37480;
})();
var inst_37432 = cljs.core.empty_QMARK_.call(null,matching_vars);
var state_37470__$1 = state_37470;
if(inst_37432){
var statearr_37481_37507 = state_37470__$1;
(statearr_37481_37507[(1)] = (6));

} else {
var statearr_37482_37508 = state_37470__$1;
(statearr_37482_37508[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37471 === (11))){
var inst_37443 = (state_37470[(9)]);
var inst_37463 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples.call(null,inst_37443,all_vars);
var state_37470__$1 = state_37470;
var statearr_37484_37509 = state_37470__$1;
(statearr_37484_37509[(2)] = inst_37463);

(statearr_37484_37509[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37471 === (9))){
var inst_37444 = (state_37470[(8)]);
var inst_37443 = (state_37470[(9)]);
var inst_37441 = (state_37470[(2)]);
var inst_37442 = fluree.db.util.async.throw_err.call(null,inst_37441);
var inst_37443__$1 = cljs.core.__destructure_map.call(null,inst_37442);
var inst_37444__$1 = cljs.core.get.call(null,inst_37443__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_37445 = cljs.core.get.call(null,inst_37443__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_37446 = cljs.core._EQ_.call(null,(400),inst_37444__$1);
var state_37470__$1 = (function (){var statearr_37485 = state_37470;
(statearr_37485[(11)] = inst_37445);

(statearr_37485[(8)] = inst_37444__$1);

(statearr_37485[(9)] = inst_37443__$1);

return statearr_37485;
})();
if(inst_37446){
var statearr_37486_37510 = state_37470__$1;
(statearr_37486_37510[(1)] = (10));

} else {
var statearr_37487_37511 = state_37470__$1;
(statearr_37487_37511[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37471 === (5))){
var _ = (function (){var statearr_37488 = state_37470;
(statearr_37488[(4)] = cljs.core.rest.call(null,(state_37470[(4)])));

return statearr_37488;
})();
var state_37470__$1 = state_37470;
var ex37483 = (state_37470__$1[(2)]);
var statearr_37489_37512 = state_37470__$1;
(statearr_37489_37512[(5)] = ex37483);


if((ex37483 instanceof Error)){
var statearr_37490_37513 = state_37470__$1;
(statearr_37490_37513[(1)] = (4));

(statearr_37490_37513[(5)] = null);

} else {
throw ex37483;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37471 === (14))){
var state_37470__$1 = state_37470;
var statearr_37491_37514 = state_37470__$1;
(statearr_37491_37514[(2)] = (1000));

(statearr_37491_37514[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37471 === (10))){
var inst_37445 = (state_37470[(11)]);
var inst_37448 = (state_37470[(10)]);
var inst_37443 = (state_37470[(9)]);
var inst_37448__$1 = cljs.core.count.call(null,inst_37445);
var inst_37449 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_37443);
var inst_37450 = (inst_37448__$1 < (1000));
var state_37470__$1 = (function (){var statearr_37492 = state_37470;
(statearr_37492[(7)] = inst_37449);

(statearr_37492[(10)] = inst_37448__$1);

return statearr_37492;
})();
if(cljs.core.truth_(inst_37450)){
var statearr_37493_37515 = state_37470__$1;
(statearr_37493_37515[(1)] = (13));

} else {
var statearr_37494_37516 = state_37470__$1;
(statearr_37494_37516[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37471 === (8))){
var inst_37437 = (state_37470[(2)]);
var inst_37438 = fluree.db.query.analytical_wikidata.generateWikiDataQuery.call(null,q_map,clauses,all_vars,inst_37437,optional_clauses);
var inst_37439 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query.call(null,inst_37438);
var state_37470__$1 = state_37470;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37470__$1,(9),inst_37439);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16221__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16221__auto____0 = (function (){
var statearr_37495 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37495[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16221__auto__);

(statearr_37495[(1)] = (1));

return statearr_37495;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16221__auto____1 = (function (state_37470){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_37470);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e37496){var ex__16224__auto__ = e37496;
var statearr_37497_37517 = state_37470;
(statearr_37497_37517[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_37470[(4)]))){
var statearr_37498_37518 = state_37470;
(statearr_37498_37518[(1)] = cljs.core.first.call(null,(state_37470[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37519 = state_37470;
state_37470 = G__37519;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16221__auto__ = function(state_37470){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16221__auto____1.call(this,state_37470);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16221__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16221__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_37499 = f__16346__auto__.call(null);
(statearr_37499[(6)] = c__16345__auto__);

return statearr_37499;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
