// Compiled by ClojureScript 1.10.879 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.query.union');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (((cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"#")) && (cljs.core._EQ_.call(null,cljs.core.second.call(null,cljs.core.name.call(null,form)),"(")))))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"\"")) && (cljs.core._EQ_.call(null,cljs.core.last.call(null,cljs.core.name.call(null,form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.call(null,string);
}catch (e37522){var e = e37522;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some.call(null,(function (p1__37523_SHARP_){
var or__4212__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,p1__37523_SHARP_);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
if(cljs.core.coll_QMARK_.call(null,p1__37523_SHARP_)){
return fluree.db.query.analytical.get_vars.call(null,p1__37523_SHARP_);
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv.call(null,(function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_.call(null,key);
var static_value = cljs.core.get.call(null,interm_vars,key_as_var);
if(((cljs.core._EQ_.call(null,idx,(1))) && (((cljs.core.not.call(null,key_as_var)) && (((cljs.core.not_EQ_.call(null,"_id",key)) && (cljs.core.not.call(null,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find.call(null,/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.call(null,["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__37524_SHARP_){
return cljs.core.conj.call(null,p1__37524_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__37525_SHARP_){
return cljs.core.conj.call(null,p1__37525_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = fluree.db.query.analytical.internal_filter_QMARK_.call(null,key);
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core._EQ_.call(null,idx,(2));
} else {
return and__4210__auto__;
}
})())){
var filter_code = cljs.reader.read_string.call(null,cljs.core.subs.call(null,key,(1)));
var var$ = (function (){var or__4212__auto__ = fluree.db.query.analytical.get_vars.call(null,filter_code);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.call(null,["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__37530 = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.call(null,vec__37530,(0),null);
var _ = cljs.core.nth.call(null,vec__37530,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn.call(null,var$,fun);
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__37526_SHARP_){
return cljs.core.conj.call(null,p1__37526_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.core._EQ_.call(null,idx,(1));
if(and__4210__auto__){
return cljs.core.re_find.call(null,/\+/,key);
} else {
return and__4210__auto__;
}
})())){
var vec__37533 = clojure.string.split.call(null,key,/\+/);
var pred = cljs.core.nth.call(null,vec__37533,(0),null);
var recur_amt = cljs.core.nth.call(null,vec__37533,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4212__auto__ = fluree.db.query.analytical.safe_read_string.call(null,recur_amt);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__37527_SHARP_){
return cljs.core.conj.call(null,p1__37527_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_.call(null,key)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__37528_SHARP_){
return cljs.core.conj.call(null,p1__37528_SHARP_,fluree.db.query.analytical.safe_read_string.call(null,key));
}));
} else {
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__37529_SHARP_){
return cljs.core.conj.call(null,p1__37529_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.call(null,(function (array){
return cljs.core.map.call(null,(function (p1__37536_SHARP_){
return cljs.core.nth.call(null,array,p1__37536_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.call(null,(function (acc,var$){
var temp__5751__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var$);
if(cljs.core.truth_(temp__5751__auto__)){
var var$__$1 = temp__5751__auto__;
return cljs.core.conj.call(null,acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys.call(null,clause);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(rel_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(a_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.call(null,(function (acc,var_smt){
var temp__5751__auto__ = (function (){var or__4212__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var_smt);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var var$ = temp__5751__auto__;
return cljs.core.conj.call(null,acc,fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays.call(null,ns,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4210__auto__ = max_fuel;
if(cljs.core.truth_(and__4210__auto__)){
return (add_amount > max_fuel);
} else {
return and__4210__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = fuel;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.volatile_QMARK_.call(null,fuel);
} else {
return and__4210__auto__;
}
})())){
return cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.call(null,(function (clause){
return cljs.core.mapv.call(null,(function (clause_item){
var temp__5751__auto__ = intersecting_vars.call(null,cljs.core.symbol.call(null,clause_item));
if(cljs.core.truth_(temp__5751__auto__)){
var key_replace = temp__5751__auto__;
var replacement = cljs.core.get.call(null,vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.call(null,replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__37539,optional_QMARK_,fuel,max_fuel){
var map__37540 = p__37539;
var map__37540__$1 = cljs.core.__destructure_map.call(null,map__37540);
var res = map__37540__$1;
var vars = cljs.core.get.call(null,map__37540__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_37606){
var state_val_37607 = (state_37606[(1)]);
if((state_val_37607 === (7))){
var inst_37595 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37596 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses.call(null,r);
var inst_37597 = cljs.core.conj.call(null,inst_37596,clause);
var inst_37598 = [null,inst_37597];
var inst_37599 = (new cljs.core.PersistentVector(null,2,(5),inst_37595,inst_37598,null));
var state_37606__$1 = state_37606;
var statearr_37608_37636 = state_37606__$1;
(statearr_37608_37636[(2)] = inst_37599);

(statearr_37608_37636[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37607 === (1))){
var state_37606__$1 = state_37606;
var statearr_37609_37637 = state_37606__$1;
(statearr_37609_37637[(2)] = null);

(statearr_37609_37637[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37607 === (4))){
var inst_37541 = (state_37606[(2)]);
var state_37606__$1 = state_37606;
var statearr_37610_37638 = state_37606__$1;
(statearr_37610_37638[(2)] = inst_37541);

(statearr_37610_37638[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37607 === (15))){
var inst_37584 = (state_37606[(2)]);
var inst_37585 = fluree.db.util.async.throw_err.call(null,inst_37584);
var inst_37586 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_37585);
var inst_37587 = cljs.core.count.call(null,inst_37586);
var inst_37588 = fluree.db.query.analytical.add_fuel.call(null,inst_37587,fuel,max_fuel);
var inst_37589 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37590 = [inst_37585,r];
var inst_37591 = (new cljs.core.PersistentVector(null,2,(5),inst_37589,inst_37590,null));
var state_37606__$1 = (function (){var statearr_37611 = state_37606;
(statearr_37611[(7)] = inst_37588);

return statearr_37611;
})();
var statearr_37612_37639 = state_37606__$1;
(statearr_37612_37639[(2)] = inst_37591);

(statearr_37612_37639[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37607 === (13))){
var inst_37550 = (state_37606[(8)]);
var inst_37563 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_37564 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses.call(null,inst_37563);
var inst_37565 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_37550);
var inst_37566 = cljs.core.apply.call(null,cljs.core.concat,inst_37565);
var inst_37567 = cljs.core.set.call(null,inst_37566);
var inst_37568 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_37564);
var inst_37569 = cljs.core.apply.call(null,cljs.core.concat,inst_37568);
var inst_37570 = cljs.core.into.call(null,inst_37567,inst_37569);
var inst_37571 = (function (){var all_wd = inst_37550;
var optional = inst_37564;
var all_wd_vars = inst_37567;
var all_vars = inst_37570;
return (function (p1__37537_SHARP_){
return all_vars.call(null,p1__37537_SHARP_);
});
})();
var inst_37572 = cljs.core.keys.call(null,vars);
var inst_37573 = cljs.core.map.call(null,inst_37571,inst_37572);
var inst_37574 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_37573);
var inst_37575 = cljs.core.set.call(null,inst_37574);
var inst_37576 = (function (){var all_wd = inst_37550;
var optional = inst_37564;
var all_wd_vars = inst_37567;
var all_vars = inst_37570;
var intersecting_vars = inst_37575;
return (function (p1__37538_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,p1__37538_SHARP_);
});
})();
var inst_37577 = cljs.core.map.call(null,inst_37576,inst_37550);
var inst_37578 = cljs.core.apply.call(null,cljs.core.concat,inst_37577);
var inst_37579 = fluree.db.query.analytical.select_from_tuples.call(null,inst_37578,res);
var inst_37580 = fluree.db.query.analytical.replace_vars_wikidata.call(null,inst_37550,inst_37575,vars);
var inst_37581 = cljs.core.remove.call(null,inst_37575,inst_37570);
var inst_37582 = fluree.db.query.analytical_wikidata.get_wikidata_tuples.call(null,q_map,inst_37580,inst_37578,inst_37579,inst_37581,inst_37564);
var state_37606__$1 = state_37606;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37606__$1,(15),inst_37582);
} else {
if((state_val_37607 === (6))){
var inst_37551 = (state_37606[(9)]);
var inst_37549 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_37550 = fluree.db.query.analytical_wikidata.get_all_wd_clauses.call(null,inst_37549);
var inst_37551__$1 = optional_QMARK_;
var state_37606__$1 = (function (){var statearr_37613 = state_37606;
(statearr_37613[(9)] = inst_37551__$1);

(statearr_37613[(8)] = inst_37550);

return statearr_37613;
})();
if(cljs.core.truth_(inst_37551__$1)){
var statearr_37614_37640 = state_37606__$1;
(statearr_37614_37640[(1)] = (9));

} else {
var statearr_37615_37641 = state_37606__$1;
(statearr_37615_37641[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37607 === (3))){
var inst_37604 = (state_37606[(2)]);
var state_37606__$1 = state_37606;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37606__$1,inst_37604);
} else {
if((state_val_37607 === (12))){
var inst_37559 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37560 = [null,r];
var inst_37561 = (new cljs.core.PersistentVector(null,2,(5),inst_37559,inst_37560,null));
var state_37606__$1 = state_37606;
var statearr_37616_37642 = state_37606__$1;
(statearr_37616_37642[(2)] = inst_37561);

(statearr_37616_37642[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37607 === (2))){
var _ = (function (){var statearr_37617 = state_37606;
(statearr_37617[(4)] = cljs.core.cons.call(null,(5),(state_37606[(4)])));

return statearr_37617;
})();
var inst_37547 = (r == null);
var state_37606__$1 = state_37606;
if(cljs.core.truth_(inst_37547)){
var statearr_37618_37643 = state_37606__$1;
(statearr_37618_37643[(1)] = (6));

} else {
var statearr_37619_37644 = state_37606__$1;
(statearr_37619_37644[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37607 === (11))){
var inst_37557 = (state_37606[(2)]);
var state_37606__$1 = state_37606;
if(cljs.core.truth_(inst_37557)){
var statearr_37621_37645 = state_37606__$1;
(statearr_37621_37645[(1)] = (12));

} else {
var statearr_37622_37646 = state_37606__$1;
(statearr_37622_37646[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37607 === (9))){
var inst_37550 = (state_37606[(8)]);
var inst_37553 = cljs.core.empty_QMARK_.call(null,inst_37550);
var inst_37554 = (!(inst_37553));
var state_37606__$1 = state_37606;
var statearr_37623_37647 = state_37606__$1;
(statearr_37623_37647[(2)] = inst_37554);

(statearr_37623_37647[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37607 === (5))){
var _ = (function (){var statearr_37624 = state_37606;
(statearr_37624[(4)] = cljs.core.rest.call(null,(state_37606[(4)])));

return statearr_37624;
})();
var state_37606__$1 = state_37606;
var ex37620 = (state_37606__$1[(2)]);
var statearr_37625_37648 = state_37606__$1;
(statearr_37625_37648[(5)] = ex37620);


if((ex37620 instanceof Error)){
var statearr_37626_37649 = state_37606__$1;
(statearr_37626_37649[(1)] = (4));

(statearr_37626_37649[(5)] = null);

} else {
throw ex37620;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37607 === (14))){
var inst_37593 = (state_37606[(2)]);
var state_37606__$1 = state_37606;
var statearr_37627_37650 = state_37606__$1;
(statearr_37627_37650[(2)] = inst_37593);

(statearr_37627_37650[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37607 === (10))){
var inst_37551 = (state_37606[(9)]);
var state_37606__$1 = state_37606;
var statearr_37628_37651 = state_37606__$1;
(statearr_37628_37651[(2)] = inst_37551);

(statearr_37628_37651[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37607 === (8))){
var inst_37601 = (state_37606[(2)]);
var _ = (function (){var statearr_37629 = state_37606;
(statearr_37629[(4)] = cljs.core.rest.call(null,(state_37606[(4)])));

return statearr_37629;
})();
var state_37606__$1 = state_37606;
var statearr_37630_37652 = state_37606__$1;
(statearr_37630_37652[(2)] = inst_37601);

(statearr_37630_37652[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16221__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16221__auto____0 = (function (){
var statearr_37631 = [null,null,null,null,null,null,null,null,null,null];
(statearr_37631[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16221__auto__);

(statearr_37631[(1)] = (1));

return statearr_37631;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16221__auto____1 = (function (state_37606){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_37606);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e37632){var ex__16224__auto__ = e37632;
var statearr_37633_37653 = state_37606;
(statearr_37633_37653[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_37606[(4)]))){
var statearr_37634_37654 = state_37606;
(statearr_37634_37654[(1)] = cljs.core.first.call(null,(state_37606[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37655 = state_37606;
state_37606 = G__37655;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16221__auto__ = function(state_37606){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16221__auto____1.call(this,state_37606);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16221__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16221__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_37635 = f__16346__auto__.call(null);
(statearr_37635[(6)] = c__16345__auto__);

return statearr_37635;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string.call(null,block);
if(cljs.core.int_QMARK_.call(null,block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find.call(null,/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find.call(null,/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__37657 = arguments.length;
switch (G__37657) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.call(null,db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_37751){
var state_val_37752 = (state_37751[(1)]);
if((state_val_37752 === (7))){
var inst_37664 = (state_37751[(7)]);
var inst_37674 = clojure.string.starts_with_QMARK_.call(null,inst_37664,"$fdb");
var state_37751__$1 = state_37751;
if(inst_37674){
var statearr_37753_37802 = state_37751__$1;
(statearr_37753_37802[(1)] = (9));

} else {
var statearr_37754_37803 = state_37751__$1;
(statearr_37754_37803[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37752 === (20))){
var state_37751__$1 = state_37751;
var statearr_37755_37804 = state_37751__$1;
(statearr_37755_37804[(2)] = null);

(statearr_37755_37804[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37752 === (27))){
var inst_37714 = (state_37751[(8)]);
var state_37751__$1 = state_37751;
var statearr_37756_37805 = state_37751__$1;
(statearr_37756_37805[(2)] = inst_37714);

(statearr_37756_37805[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37752 === (1))){
var state_37751__$1 = state_37751;
var statearr_37757_37806 = state_37751__$1;
(statearr_37757_37806[(2)] = null);

(statearr_37757_37806[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37752 === (24))){
var inst_37737 = (state_37751[(2)]);
var state_37751__$1 = state_37751;
var statearr_37758_37807 = state_37751__$1;
(statearr_37758_37807[(2)] = inst_37737);

(statearr_37758_37807[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37752 === (4))){
var inst_37658 = (state_37751[(2)]);
var state_37751__$1 = state_37751;
var statearr_37759_37808 = state_37751__$1;
(statearr_37759_37808[(2)] = inst_37658);

(statearr_37759_37808[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37752 === (15))){
var inst_37681 = (state_37751[(9)]);
var inst_37687 = (state_37751[(2)]);
var inst_37688 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37689 = cljs.core.PersistentVector.EMPTY;
var inst_37690 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_37691 = cljs.core.into.call(null,inst_37689,inst_37690);
var inst_37692 = [inst_37681,inst_37691];
var inst_37693 = (new cljs.core.PersistentVector(null,2,(5),inst_37688,inst_37692,null));
var state_37751__$1 = (function (){var statearr_37760 = state_37751;
(statearr_37760[(10)] = inst_37687);

return statearr_37760;
})();
var statearr_37761_37809 = state_37751__$1;
(statearr_37761_37809[(2)] = inst_37693);

(statearr_37761_37809[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37752 === (21))){
var inst_37740 = (state_37751[(2)]);
var state_37751__$1 = state_37751;
var statearr_37762_37810 = state_37751__$1;
(statearr_37762_37810[(2)] = inst_37740);

(statearr_37762_37810[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37752 === (13))){
var inst_37681 = (state_37751[(9)]);
var inst_37684 = (function(){throw inst_37681})();
var state_37751__$1 = state_37751;
var statearr_37763_37811 = state_37751__$1;
(statearr_37763_37811[(2)] = inst_37684);

(statearr_37763_37811[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37752 === (22))){
var inst_37705 = (state_37751[(11)]);
var inst_37703 = (state_37751[(12)]);
var inst_37707 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_37703);
var inst_37708 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37709 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_37705];
var inst_37710 = (new cljs.core.PersistentVector(null,2,(5),inst_37708,inst_37709,null));
var inst_37711 = cljs.core.get_in.call(null,opts,inst_37710);
var state_37751__$1 = (function (){var statearr_37764 = state_37751;
(statearr_37764[(13)] = inst_37707);

return statearr_37764;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37751__$1,(25),inst_37711);
} else {
if((state_val_37752 === (29))){
var inst_37718 = (state_37751[(2)]);
var inst_37719 = fluree.db.util.async.throw_err.call(null,inst_37718);
var state_37751__$1 = state_37751;
var statearr_37765_37812 = state_37751__$1;
(statearr_37765_37812[(2)] = inst_37719);

(statearr_37765_37812[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37752 === (6))){
var inst_37667 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37668 = cljs.core.PersistentVector.EMPTY;
var inst_37669 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_37670 = cljs.core.into.call(null,inst_37668,inst_37669);
var inst_37671 = [db,inst_37670];
var inst_37672 = (new cljs.core.PersistentVector(null,2,(5),inst_37667,inst_37671,null));
var state_37751__$1 = state_37751;
var statearr_37766_37813 = state_37751__$1;
(statearr_37766_37813[(2)] = inst_37672);

(statearr_37766_37813[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37752 === (28))){
var inst_37722 = (state_37751[(2)]);
var inst_37723 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37724 = cljs.core.PersistentVector.EMPTY;
var inst_37725 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_37726 = cljs.core.into.call(null,inst_37724,inst_37725);
var inst_37727 = [inst_37722,inst_37726];
var inst_37728 = (new cljs.core.PersistentVector(null,2,(5),inst_37723,inst_37727,null));
var state_37751__$1 = state_37751;
var statearr_37767_37814 = state_37751__$1;
(statearr_37767_37814[(2)] = inst_37728);

(statearr_37767_37814[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37752 === (25))){
var inst_37707 = (state_37751[(13)]);
var inst_37713 = (state_37751[(2)]);
var inst_37714 = fluree.db.util.async.throw_err.call(null,inst_37713);
var state_37751__$1 = (function (){var statearr_37768 = state_37751;
(statearr_37768[(8)] = inst_37714);

return statearr_37768;
})();
if(cljs.core.truth_(inst_37707)){
var statearr_37769_37815 = state_37751__$1;
(statearr_37769_37815[(1)] = (26));

} else {
var statearr_37770_37816 = state_37751__$1;
(statearr_37770_37816[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37752 === (17))){
var state_37751__$1 = state_37751;
var statearr_37771_37817 = state_37751__$1;
(statearr_37771_37817[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37752 === (3))){
var inst_37749 = (state_37751[(2)]);
var state_37751__$1 = state_37751;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37751__$1,inst_37749);
} else {
if((state_val_37752 === (12))){
var inst_37681 = (state_37751[(9)]);
var inst_37680 = (state_37751[(2)]);
var inst_37681__$1 = fluree.db.util.async.throw_err.call(null,inst_37680);
var inst_37682 = fluree.db.util.core.exception_QMARK_.call(null,inst_37681__$1);
var state_37751__$1 = (function (){var statearr_37773 = state_37751;
(statearr_37773[(9)] = inst_37681__$1);

return statearr_37773;
})();
if(inst_37682){
var statearr_37774_37818 = state_37751__$1;
(statearr_37774_37818[(1)] = (13));

} else {
var statearr_37775_37819 = state_37751__$1;
(statearr_37775_37819[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37752 === (2))){
var inst_37664 = (state_37751[(7)]);
var _ = (function (){var statearr_37776 = state_37751;
(statearr_37776[(4)] = cljs.core.cons.call(null,(5),(state_37751[(4)])));

return statearr_37776;
})();
var inst_37664__$1 = cljs.core.first.call(null,clause);
var inst_37665 = cljs.core._EQ_.call(null,"$fdb",inst_37664__$1);
var state_37751__$1 = (function (){var statearr_37777 = state_37751;
(statearr_37777[(7)] = inst_37664__$1);

return statearr_37777;
})();
if(inst_37665){
var statearr_37778_37820 = state_37751__$1;
(statearr_37778_37820[(1)] = (6));

} else {
var statearr_37779_37821 = state_37751__$1;
(statearr_37779_37821[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37752 === (23))){
var inst_37664 = (state_37751[(7)]);
var inst_37730 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_37664)," is not supported in Fluree"].join('');
var inst_37731 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_37732 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_37733 = cljs.core.PersistentHashMap.fromArrays(inst_37731,inst_37732);
var inst_37734 = cljs.core.ex_info.call(null,inst_37730,inst_37733);
var inst_37735 = (function(){throw inst_37734})();
var state_37751__$1 = state_37751;
var statearr_37780_37822 = state_37751__$1;
(statearr_37780_37822[(2)] = inst_37735);

(statearr_37780_37822[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37752 === (19))){
var inst_37705 = (state_37751[(11)]);
var inst_37664 = (state_37751[(7)]);
var inst_37702 = fluree.db.query.analytical.isolate_source_name.call(null,inst_37664);
var inst_37703 = fluree.db.query.analytical.isolate_source_block.call(null,inst_37664);
var inst_37704 = cljs.core.keyword.call(null,inst_37702);
var inst_37705__$1 = cljs.core.get.call(null,prefixes,inst_37704);
var state_37751__$1 = (function (){var statearr_37781 = state_37751;
(statearr_37781[(11)] = inst_37705__$1);

(statearr_37781[(12)] = inst_37703);

return statearr_37781;
})();
if(cljs.core.truth_(inst_37705__$1)){
var statearr_37782_37823 = state_37751__$1;
(statearr_37782_37823[(1)] = (22));

} else {
var statearr_37783_37824 = state_37751__$1;
(statearr_37783_37824[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37752 === (11))){
var inst_37744 = (state_37751[(2)]);
var state_37751__$1 = state_37751;
var statearr_37785_37825 = state_37751__$1;
(statearr_37785_37825[(2)] = inst_37744);

(statearr_37785_37825[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37752 === (9))){
var inst_37664 = (state_37751[(7)]);
var inst_37676 = cljs.core.subs.call(null,inst_37664,(4));
var inst_37677 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_37676);
var inst_37678 = fluree.db.time_travel.as_of_block.call(null,db,inst_37677);
var state_37751__$1 = state_37751;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37751__$1,(12),inst_37678);
} else {
if((state_val_37752 === (5))){
var _ = (function (){var statearr_37786 = state_37751;
(statearr_37786[(4)] = cljs.core.rest.call(null,(state_37751[(4)])));

return statearr_37786;
})();
var state_37751__$1 = state_37751;
var ex37784 = (state_37751__$1[(2)]);
var statearr_37787_37826 = state_37751__$1;
(statearr_37787_37826[(5)] = ex37784);


if((ex37784 instanceof Error)){
var statearr_37788_37827 = state_37751__$1;
(statearr_37788_37827[(1)] = (4));

(statearr_37788_37827[(5)] = null);

} else {
throw ex37784;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37752 === (14))){
var state_37751__$1 = state_37751;
var statearr_37789_37828 = state_37751__$1;
(statearr_37789_37828[(2)] = null);

(statearr_37789_37828[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37752 === (26))){
var inst_37714 = (state_37751[(8)]);
var inst_37707 = (state_37751[(13)]);
var inst_37716 = fluree.db.time_travel.as_of_block.call(null,inst_37714,inst_37707);
var state_37751__$1 = state_37751;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37751__$1,(29),inst_37716);
} else {
if((state_val_37752 === (16))){
var inst_37697 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37698 = ["$wd",clause];
var inst_37699 = (new cljs.core.PersistentVector(null,2,(5),inst_37697,inst_37698,null));
var state_37751__$1 = state_37751;
var statearr_37790_37829 = state_37751__$1;
(statearr_37790_37829[(2)] = inst_37699);

(statearr_37790_37829[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37752 === (10))){
var inst_37664 = (state_37751[(7)]);
var inst_37695 = cljs.core._EQ_.call(null,"$wd",inst_37664);
var state_37751__$1 = state_37751;
if(inst_37695){
var statearr_37791_37830 = state_37751__$1;
(statearr_37791_37830[(1)] = (16));

} else {
var statearr_37792_37831 = state_37751__$1;
(statearr_37792_37831[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37752 === (18))){
var inst_37742 = (state_37751[(2)]);
var state_37751__$1 = state_37751;
var statearr_37793_37832 = state_37751__$1;
(statearr_37793_37832[(2)] = inst_37742);

(statearr_37793_37832[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37752 === (8))){
var inst_37746 = (state_37751[(2)]);
var _ = (function (){var statearr_37794 = state_37751;
(statearr_37794[(4)] = cljs.core.rest.call(null,(state_37751[(4)])));

return statearr_37794;
})();
var state_37751__$1 = state_37751;
var statearr_37795_37833 = state_37751__$1;
(statearr_37795_37833[(2)] = inst_37746);

(statearr_37795_37833[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__16221__auto__ = null;
var fluree$db$query$analytical$state_machine__16221__auto____0 = (function (){
var statearr_37796 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37796[(0)] = fluree$db$query$analytical$state_machine__16221__auto__);

(statearr_37796[(1)] = (1));

return statearr_37796;
});
var fluree$db$query$analytical$state_machine__16221__auto____1 = (function (state_37751){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_37751);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e37797){var ex__16224__auto__ = e37797;
var statearr_37798_37834 = state_37751;
(statearr_37798_37834[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_37751[(4)]))){
var statearr_37799_37835 = state_37751;
(statearr_37799_37835[(1)] = cljs.core.first.call(null,(state_37751[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37836 = state_37751;
state_37751 = G__37836;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__16221__auto__ = function(state_37751){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__16221__auto____1.call(this,state_37751);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__16221__auto____0;
fluree$db$query$analytical$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__16221__auto____1;
return fluree$db$query$analytical$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_37800 = f__16346__auto__.call(null);
(statearr_37800[(6)] = c__16345__auto__);

return statearr_37800;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.call(null,(function (acc,p__37837){
var vec__37838 = p__37837;
var sub = cljs.core.nth.call(null,vec__37838,(0),null);
var obj = cljs.core.nth.call(null,vec__37838,(1),null);
return cljs.core.update.call(null,acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap.call(null,cljs.core.keys.call(null,tuple_map),cljs.core.map.call(null,(function (p1__37841_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set.call(null,p1__37841_SHARP_)]);
}),cljs.core.vals.call(null,tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map.call(null,tuple_map);
var G__37845 = subjects;
var vec__37846 = G__37845;
var seq__37847 = cljs.core.seq.call(null,vec__37846);
var first__37848 = cljs.core.first.call(null,seq__37847);
var seq__37847__$1 = cljs.core.next.call(null,seq__37847);
var subject = first__37848;
var r = seq__37847__$1;
var acc = expanded_map;
var G__37845__$1 = G__37845;
var acc__$1 = acc;
while(true){
var vec__37852 = G__37845__$1;
var seq__37853 = cljs.core.seq.call(null,vec__37852);
var first__37854 = cljs.core.first.call(null,seq__37853);
var seq__37853__$1 = cljs.core.next.call(null,seq__37853);
var subject__$1 = first__37854;
var r__$1 = seq__37853__$1;
var acc__$2 = acc__$1;
if(cljs.core.not.call(null,subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__37855 = r__$1;
var G__37856 = acc__$2;
G__37845__$1 = G__37855;
acc__$1 = G__37856;
continue;
} else {
var subject_all = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.call(null,subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.call(null,((function (G__37845__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__37852,seq__37853,first__37854,seq__37853__$1,subject__$1,r__$1,acc__$2,G__37845,vec__37846,seq__37847,first__37848,seq__37847__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.call(null,subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:all_followed.call(null,subject_to_follow));
var acc_SINGLEQUOTE_ = cljs.core.update_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4212__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__37845__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__37852,seq__37853,first__37854,seq__37853__$1,subject__$1,r__$1,acc__$2,G__37845,vec__37846,seq__37847,first__37848,seq__37847__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__37845__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__37852,seq__37853,first__37854,seq__37853__$1,subject__$1,r__$1,acc__$2,G__37845,vec__37846,seq__37847,first__37848,seq__37847__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__37845__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__37852,seq__37853,first__37854,seq__37853__$1,subject__$1,r__$1,acc__$2,G__37845,vec__37846,seq__37847,first__37848,seq__37847__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__37845__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__37852,seq__37853,first__37854,seq__37853__$1,subject__$1,r__$1,acc__$2,G__37845,vec__37846,seq__37847,first__37848,seq__37847__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__37845__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__37852,seq__37853,first__37854,seq__37853__$1,subject__$1,r__$1,acc__$2,G__37845,vec__37846,seq__37847,first__37848,seq__37847__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.call(null,subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__37857 = r__$1;
var G__37858 = cljs.core.assoc_in.call(null,acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__37845__$1 = G__37857;
acc__$1 = G__37858;
continue;
} else {
var G__37859 = subjects;
var G__37860 = acc_STAR_;
G__37845__$1 = G__37859;
acc__$1 = G__37860;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.call(null,(function (acc,subject){
var subject_vals = cljs.core.get_in.call(null,recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.call(null,acc,cljs.core.map.call(null,(function (p1__37861_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__37861_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_37952){
var state_val_37953 = (state_37952[(1)]);
if((state_val_37953 === (7))){
var state_37952__$1 = state_37952;
var statearr_37954_38000 = state_37952__$1;
(statearr_37954_38000[(2)] = (100));

(statearr_37954_38000[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37953 === (20))){
var inst_37901 = (state_37952[(7)]);
var state_37952__$1 = state_37952;
var statearr_37955_38001 = state_37952__$1;
(statearr_37955_38001[(2)] = inst_37901);

(statearr_37955_38001[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37953 === (1))){
var state_37952__$1 = state_37952;
var statearr_37956_38002 = state_37952__$1;
(statearr_37956_38002[(2)] = null);

(statearr_37956_38002[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37953 === (24))){
var inst_37873 = (state_37952[(8)]);
var inst_37940 = (state_37952[(9)]);
var inst_37939 = (state_37952[(10)]);
var inst_37938 = (state_37952[(11)]);
var inst_37943 = (function (){var max_depth = inst_37873;
var recur_map__$1 = inst_37939;
var subjects = inst_37938;
var tuples = inst_37940;
return (function (p1__37862_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second.call(null,p1__37862_SHARP_)],null));
});
})();
var inst_37944 = cljs.core.map.call(null,inst_37943,inst_37940);
var inst_37945 = cljs.core.distinct.call(null,inst_37944);
var state_37952__$1 = state_37952;
var statearr_37957_38003 = state_37952__$1;
(statearr_37957_38003[(2)] = inst_37945);

(statearr_37957_38003[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37953 === (4))){
var inst_37863 = (state_37952[(2)]);
var state_37952__$1 = state_37952;
var statearr_37958_38004 = state_37952__$1;
(statearr_37958_38004[(2)] = inst_37863);

(statearr_37958_38004[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37953 === (15))){
var inst_37886 = (state_37952[(12)]);
var inst_37897 = cljs.core.PersistentVector.EMPTY;
var inst_37898 = cljs.core.seq.call(null,inst_37886);
var inst_37899 = cljs.core.first.call(null,inst_37898);
var inst_37900 = cljs.core.next.call(null,inst_37898);
var inst_37901 = inst_37897;
var inst_37902 = inst_37886;
var state_37952__$1 = (function (){var statearr_37959 = state_37952;
(statearr_37959[(13)] = inst_37900);

(statearr_37959[(14)] = inst_37902);

(statearr_37959[(7)] = inst_37901);

(statearr_37959[(15)] = inst_37899);

return statearr_37959;
})();
var statearr_37960_38005 = state_37952__$1;
(statearr_37960_38005[(2)] = null);

(statearr_37960_38005[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37953 === (21))){
var inst_37922 = (state_37952[(2)]);
var state_37952__$1 = state_37952;
var statearr_37961_38006 = state_37952__$1;
(statearr_37961_38006[(2)] = inst_37922);

(statearr_37961_38006[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37953 === (13))){
var inst_37935 = (state_37952[(2)]);
var state_37952__$1 = state_37952;
var statearr_37962_38007 = state_37952__$1;
(statearr_37962_38007[(2)] = inst_37935);

(statearr_37962_38007[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37953 === (22))){
var inst_37909 = (state_37952[(16)]);
var inst_37901 = (state_37952[(7)]);
var inst_37916 = (state_37952[(2)]);
var inst_37917 = fluree.db.util.async.throw_err.call(null,inst_37916);
var inst_37918 = cljs.core.concat.call(null,inst_37901,inst_37917);
var inst_37901__$1 = inst_37918;
var inst_37902 = inst_37909;
var state_37952__$1 = (function (){var statearr_37963 = state_37952;
(statearr_37963[(14)] = inst_37902);

(statearr_37963[(7)] = inst_37901__$1);

return statearr_37963;
})();
var statearr_37964_38008 = state_37952__$1;
(statearr_37964_38008[(2)] = null);

(statearr_37964_38008[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37953 === (6))){
var inst_37869 = (state_37952[(17)]);
var state_37952__$1 = state_37952;
var statearr_37965_38009 = state_37952__$1;
(statearr_37965_38009[(2)] = inst_37869);

(statearr_37965_38009[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37953 === (25))){
var inst_37947 = (state_37952[(2)]);
var _ = (function (){var statearr_37966 = state_37952;
(statearr_37966[(4)] = cljs.core.rest.call(null,(state_37952[(4)])));

return statearr_37966;
})();
var state_37952__$1 = state_37952;
var statearr_37967_38010 = state_37952__$1;
(statearr_37967_38010[(2)] = inst_37947);

(statearr_37967_38010[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37953 === (17))){
var inst_37902 = (state_37952[(14)]);
var inst_37908 = (state_37952[(18)]);
var inst_37907 = cljs.core.seq.call(null,inst_37902);
var inst_37908__$1 = cljs.core.first.call(null,inst_37907);
var inst_37909 = cljs.core.next.call(null,inst_37907);
var state_37952__$1 = (function (){var statearr_37968 = state_37952;
(statearr_37968[(16)] = inst_37909);

(statearr_37968[(18)] = inst_37908__$1);

return statearr_37968;
})();
if(cljs.core.truth_(inst_37908__$1)){
var statearr_37969_38011 = state_37952__$1;
(statearr_37969_38011[(1)] = (19));

} else {
var statearr_37970_38012 = state_37952__$1;
(statearr_37970_38012[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37953 === (3))){
var inst_37950 = (state_37952[(2)]);
var state_37952__$1 = state_37952;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37952__$1,inst_37950);
} else {
if((state_val_37953 === (12))){
var inst_37886 = (state_37952[(12)]);
var inst_37875 = (state_37952[(19)]);
var inst_37881 = cljs.core.vals.call(null,inst_37875);
var inst_37882 = cljs.core.flatten.call(null,inst_37881);
var inst_37883 = cljs.core.set.call(null,inst_37882);
var inst_37884 = cljs.core.keys.call(null,inst_37875);
var inst_37885 = cljs.core.set.call(null,inst_37884);
var inst_37886__$1 = clojure.set.difference.call(null,inst_37883,inst_37885);
var inst_37887 = cljs.core.empty_QMARK_.call(null,inst_37886__$1);
var state_37952__$1 = (function (){var statearr_37971 = state_37952;
(statearr_37971[(12)] = inst_37886__$1);

return statearr_37971;
})();
if(inst_37887){
var statearr_37972_38013 = state_37952__$1;
(statearr_37972_38013[(1)] = (14));

} else {
var statearr_37973_38014 = state_37952__$1;
(statearr_37973_38014[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37953 === (2))){
var inst_37869 = (state_37952[(17)]);
var _ = (function (){var statearr_37974 = state_37952;
(statearr_37974[(4)] = cljs.core.cons.call(null,(5),(state_37952[(4)])));

return statearr_37974;
})();
var inst_37869__$1 = depth;
var state_37952__$1 = (function (){var statearr_37975 = state_37952;
(statearr_37975[(17)] = inst_37869__$1);

return statearr_37975;
})();
if(cljs.core.truth_(inst_37869__$1)){
var statearr_37976_38015 = state_37952__$1;
(statearr_37976_38015[(1)] = (6));

} else {
var statearr_37977_38016 = state_37952__$1;
(statearr_37977_38016[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37953 === (23))){
var inst_37940 = (state_37952[(9)]);
var state_37952__$1 = state_37952;
var statearr_37978_38017 = state_37952__$1;
(statearr_37978_38017[(2)] = inst_37940);

(statearr_37978_38017[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37953 === (19))){
var inst_37908 = (state_37952[(18)]);
var inst_37911 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37912 = [inst_37908,predicate];
var inst_37913 = (new cljs.core.PersistentVector(null,2,(5),inst_37911,inst_37912,null));
var inst_37914 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_37913);
var state_37952__$1 = state_37952;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37952__$1,(22),inst_37914);
} else {
if((state_val_37953 === (11))){
var inst_37875 = (state_37952[(19)]);
var state_37952__$1 = state_37952;
var statearr_37980_38018 = state_37952__$1;
(statearr_37980_38018[(2)] = inst_37875);

(statearr_37980_38018[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37953 === (9))){
var inst_37873 = (state_37952[(8)]);
var inst_37876 = (state_37952[(20)]);
var inst_37878 = (inst_37876 >= inst_37873);
var state_37952__$1 = state_37952;
if(cljs.core.truth_(inst_37878)){
var statearr_37981_38019 = state_37952__$1;
(statearr_37981_38019[(1)] = (11));

} else {
var statearr_37982_38020 = state_37952__$1;
(statearr_37982_38020[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37953 === (5))){
var _ = (function (){var statearr_37983 = state_37952;
(statearr_37983[(4)] = cljs.core.rest.call(null,(state_37952[(4)])));

return statearr_37983;
})();
var state_37952__$1 = state_37952;
var ex37979 = (state_37952__$1[(2)]);
var statearr_37984_38021 = state_37952__$1;
(statearr_37984_38021[(5)] = ex37979);


if((ex37979 instanceof Error)){
var statearr_37985_38022 = state_37952__$1;
(statearr_37985_38022[(1)] = (4));

(statearr_37985_38022[(5)] = null);

} else {
throw ex37979;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37953 === (14))){
var inst_37875 = (state_37952[(19)]);
var state_37952__$1 = state_37952;
var statearr_37986_38023 = state_37952__$1;
(statearr_37986_38023[(2)] = inst_37875);

(statearr_37986_38023[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37953 === (16))){
var inst_37933 = (state_37952[(2)]);
var state_37952__$1 = state_37952;
var statearr_37987_38024 = state_37952__$1;
(statearr_37987_38024[(2)] = inst_37933);

(statearr_37987_38024[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37953 === (10))){
var inst_37939 = (state_37952[(10)]);
var inst_37938 = (state_37952[(11)]);
var inst_37937 = (state_37952[(2)]);
var inst_37938__$1 = cljs.core.keys.call(null,inst_37937);
var inst_37939__$1 = fluree.db.query.analytical.follow_all_original_subject_paths.call(null,inst_37938__$1,inst_37937);
var inst_37940 = fluree.db.query.analytical.recur_map__GT_tuples.call(null,inst_37938__$1,inst_37939__$1);
var state_37952__$1 = (function (){var statearr_37988 = state_37952;
(statearr_37988[(9)] = inst_37940);

(statearr_37988[(10)] = inst_37939__$1);

(statearr_37988[(11)] = inst_37938__$1);

return statearr_37988;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_37989_38025 = state_37952__$1;
(statearr_37989_38025[(1)] = (23));

} else {
var statearr_37990_38026 = state_37952__$1;
(statearr_37990_38026[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37953 === (18))){
var inst_37876 = (state_37952[(20)]);
var inst_37875 = (state_37952[(19)]);
var inst_37924 = (state_37952[(2)]);
var inst_37925 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37926 = [(0),(2)];
var inst_37927 = (new cljs.core.PersistentVector(null,2,(5),inst_37925,inst_37926,null));
var inst_37928 = fluree.db.query.analytical.get_ns_arrays.call(null,inst_37927,inst_37924);
var inst_37929 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_37875,inst_37928);
var inst_37930 = (inst_37876 + (1));
var inst_37875__$1 = inst_37929;
var inst_37876__$1 = inst_37930;
var state_37952__$1 = (function (){var statearr_37991 = state_37952;
(statearr_37991[(20)] = inst_37876__$1);

(statearr_37991[(19)] = inst_37875__$1);

return statearr_37991;
})();
var statearr_37992_38027 = state_37952__$1;
(statearr_37992_38027[(2)] = null);

(statearr_37992_38027[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37953 === (8))){
var inst_37873 = (state_37952[(2)]);
var inst_37874 = recur_map;
var inst_37875 = inst_37874;
var inst_37876 = (1);
var state_37952__$1 = (function (){var statearr_37993 = state_37952;
(statearr_37993[(8)] = inst_37873);

(statearr_37993[(20)] = inst_37876);

(statearr_37993[(19)] = inst_37875);

return statearr_37993;
})();
var statearr_37994_38028 = state_37952__$1;
(statearr_37994_38028[(2)] = null);

(statearr_37994_38028[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16221__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16221__auto____0 = (function (){
var statearr_37995 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37995[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16221__auto__);

(statearr_37995[(1)] = (1));

return statearr_37995;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16221__auto____1 = (function (state_37952){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_37952);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e37996){var ex__16224__auto__ = e37996;
var statearr_37997_38029 = state_37952;
(statearr_37997_38029[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_37952[(4)]))){
var statearr_37998_38030 = state_37952;
(statearr_37998_38030[(1)] = cljs.core.first.call(null,(state_37952[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38031 = state_37952;
state_37952 = G__38031;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16221__auto__ = function(state_37952){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16221__auto____1.call(this,state_37952);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16221__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16221__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_37999 = f__16346__auto__.call(null);
(statearr_37999[(6)] = c__16345__auto__);

return statearr_37999;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__38032,clause,fuel,max_fuel){
var map__38033 = p__38032;
var map__38033__$1 = cljs.core.__destructure_map.call(null,map__38033);
var res = map__38033__$1;
var headers = cljs.core.get.call(null,map__38033__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__38033__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.call(null,map__38033__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_38144){
var state_val_38145 = (state_38144[(1)]);
if((state_val_38145 === (7))){
var inst_38050 = (state_38144[(7)]);
var state_38144__$1 = state_38144;
var statearr_38146_38199 = state_38144__$1;
(statearr_38146_38199[(2)] = inst_38050);

(statearr_38146_38199[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38145 === (20))){
var inst_38078 = (state_38144[(8)]);
var inst_38109 = typeof inst_38078 === 'number';
var state_38144__$1 = state_38144;
if(cljs.core.truth_(inst_38109)){
var statearr_38147_38200 = state_38144__$1;
(statearr_38147_38200[(1)] = (22));

} else {
var statearr_38148_38201 = state_38144__$1;
(statearr_38148_38201[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38145 === (27))){
var inst_38124 = (state_38144[(2)]);
var state_38144__$1 = state_38144;
var statearr_38149_38202 = state_38144__$1;
(statearr_38149_38202[(2)] = inst_38124);

(statearr_38149_38202[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38145 === (1))){
var state_38144__$1 = state_38144;
var statearr_38150_38203 = state_38144__$1;
(statearr_38150_38203[(2)] = null);

(statearr_38150_38203[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38145 === (24))){
var inst_38126 = (state_38144[(2)]);
var state_38144__$1 = state_38144;
var statearr_38151_38204 = state_38144__$1;
(statearr_38151_38204[(2)] = inst_38126);

(statearr_38151_38204[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38145 === (4))){
var inst_38034 = (state_38144[(2)]);
var state_38144__$1 = state_38144;
var statearr_38152_38205 = state_38144__$1;
(statearr_38152_38205[(2)] = inst_38034);

(statearr_38152_38205[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38145 === (15))){
var inst_38092 = (state_38144[(2)]);
var inst_38093 = cljs.core.nth.call(null,clause,(2));
var inst_38094 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_38093);
var state_38144__$1 = (function (){var statearr_38153 = state_38144;
(statearr_38153[(9)] = inst_38092);

return statearr_38153;
})();
if(cljs.core.truth_(inst_38094)){
var statearr_38154_38206 = state_38144__$1;
(statearr_38154_38206[(1)] = (16));

} else {
var statearr_38155_38207 = state_38144__$1;
(statearr_38155_38207[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38145 === (21))){
var inst_38081 = (state_38144[(10)]);
var inst_38080 = (state_38144[(11)]);
var inst_38051 = (state_38144[(12)]);
var inst_38128 = (state_38144[(2)]);
var inst_38129 = fluree.db.query.analytical.tuples__GT_recur.call(null,db,inst_38081,inst_38128,inst_38051,inst_38080);
var state_38144__$1 = state_38144;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38144__$1,(28),inst_38129);
} else {
if((state_val_38145 === (13))){
var inst_38060 = (state_38144[(13)]);
var inst_38084 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38060)].join('');
var inst_38085 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_38086 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_38087 = cljs.core.PersistentHashMap.fromArrays(inst_38085,inst_38086);
var inst_38088 = cljs.core.ex_info.call(null,inst_38084,inst_38087);
var inst_38089 = (function(){throw inst_38088})();
var state_38144__$1 = state_38144;
var statearr_38156_38208 = state_38144__$1;
(statearr_38156_38208[(2)] = inst_38089);

(statearr_38156_38208[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38145 === (22))){
var inst_38078 = (state_38144[(8)]);
var inst_38076 = (state_38144[(14)]);
var inst_38111 = cljs.core.PersistentHashMap.EMPTY;
var inst_38112 = cljs.core.flatten.call(null,inst_38076);
var inst_38113 = cljs.core.assoc.call(null,inst_38111,inst_38078,inst_38112);
var state_38144__$1 = state_38144;
var statearr_38157_38209 = state_38144__$1;
(statearr_38157_38209[(2)] = inst_38113);

(statearr_38157_38209[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38145 === (6))){
var inst_38062 = (state_38144[(15)]);
var state_38144__$1 = state_38144;
var statearr_38158_38210 = state_38144__$1;
(statearr_38158_38210[(2)] = inst_38062);

(statearr_38158_38210[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38145 === (28))){
var inst_38131 = (state_38144[(2)]);
var inst_38132 = fluree.db.util.async.throw_err.call(null,inst_38131);
var state_38144__$1 = state_38144;
var statearr_38159_38211 = state_38144__$1;
(statearr_38159_38211[(2)] = inst_38132);

(statearr_38159_38211[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38145 === (25))){
var inst_38072 = (state_38144[(16)]);
var inst_38076 = (state_38144[(14)]);
var inst_38117 = cljs.core.PersistentHashMap.EMPTY;
var inst_38118 = cljs.core.first.call(null,inst_38072);
var inst_38119 = cljs.core.first.call(null,inst_38118);
var inst_38120 = cljs.core.flatten.call(null,inst_38076);
var inst_38121 = cljs.core.assoc.call(null,inst_38117,inst_38119,inst_38120);
var state_38144__$1 = state_38144;
var statearr_38160_38212 = state_38144__$1;
(statearr_38160_38212[(2)] = inst_38121);

(statearr_38160_38212[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38145 === (17))){
var inst_38060 = (state_38144[(13)]);
var inst_38097 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38060)].join('');
var inst_38098 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_38099 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_38100 = cljs.core.PersistentHashMap.fromArrays(inst_38098,inst_38099);
var inst_38101 = cljs.core.ex_info.call(null,inst_38097,inst_38100);
var inst_38102 = (function(){throw inst_38101})();
var state_38144__$1 = state_38144;
var statearr_38161_38213 = state_38144__$1;
(statearr_38161_38213[(2)] = inst_38102);

(statearr_38161_38213[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38145 === (3))){
var inst_38142 = (state_38144[(2)]);
var state_38144__$1 = state_38144;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38144__$1,inst_38142);
} else {
if((state_val_38145 === (12))){
var inst_38047 = (state_38144[(17)]);
var inst_38135 = (state_38144[(2)]);
var inst_38136 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_38137 = cljs.core.keys.call(null,inst_38047);
var inst_38138 = [inst_38137,vars,inst_38135];
var inst_38139 = cljs.core.PersistentHashMap.fromArrays(inst_38136,inst_38138);
var _ = (function (){var statearr_38162 = state_38144;
(statearr_38162[(4)] = cljs.core.rest.call(null,(state_38144[(4)])));

return statearr_38162;
})();
var state_38144__$1 = state_38144;
var statearr_38163_38214 = state_38144__$1;
(statearr_38163_38214[(2)] = inst_38139);

(statearr_38163_38214[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38145 === (2))){
var inst_38047 = (state_38144[(17)]);
var inst_38050 = (state_38144[(7)]);
var inst_38051 = (state_38144[(12)]);
var inst_38062 = (state_38144[(15)]);
var _ = (function (){var statearr_38164 = state_38144;
(statearr_38164[(4)] = cljs.core.cons.call(null,(5),(state_38144[(4)])));

return statearr_38164;
})();
var inst_38044 = fluree.db.query.analytical.clause__GT_rel.call(null,db,vars,clause);
var inst_38045 = cljs.core.__destructure_map.call(null,inst_38044);
var inst_38046 = cljs.core.get.call(null,inst_38045,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_38047__$1 = cljs.core.get.call(null,inst_38045,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_38048 = cljs.core.get.call(null,inst_38045,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_38049 = fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,clause);
var inst_38050__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_38048);
var inst_38051__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_38048);
var inst_38053 = (function (){var map__38040 = inst_38045;
var search = inst_38046;
var rel = inst_38047__$1;
var opts = inst_38048;
var common_keys = inst_38049;
var object_fn = inst_38050__$1;
var recur_depth = inst_38051__$1;
return (function (p__38052,common_key){
var vec__38165 = p__38052;
var acc = cljs.core.nth.call(null,vec__38165,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__38165,(1),null);
var idx_of = fluree.db.util.core.index_of.call(null,clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__38168 = cljs.core._EQ_;
var expr__38169 = idx_of;
if(cljs.core.truth_(pred__38168.call(null,(0),expr__38169))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_(pred__38168.call(null,(1),expr__38169))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_(pred__38168.call(null,(2),expr__38169))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__38169)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of.call(null,headers,common_key);
var v = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,cljs.core.first,fluree.db.query.analytical.get_ns_arrays.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,v));
var v__$1 = (cljs.core.truth_((function (){var and__4210__auto__ = (!(single_v_QMARK_));
if(and__4210__auto__){
var and__4210__auto____$1 = object_fn;
if(cljs.core.truth_(and__4210__auto____$1)){
return cljs.core._EQ_.call(null,k,object_fn);
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
})())?cljs.core.comp.call(null,v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.call(null,clause_SINGLEQUOTE_,idx_of,cljs.core.first.call(null,v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_38054 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38055 = cljs.core.PersistentHashMap.EMPTY;
var inst_38056 = [inst_38055,inst_38046];
var inst_38057 = (new cljs.core.PersistentVector(null,2,(5),inst_38054,inst_38056,null));
var inst_38058 = cljs.core.reduce.call(null,inst_38053,inst_38057,inst_38049);
var inst_38059 = cljs.core.nth.call(null,inst_38058,(0),null);
var inst_38060 = cljs.core.nth.call(null,inst_38058,(1),null);
var inst_38061 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_38062__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_38059);
var state_38144__$1 = (function (){var statearr_38171 = state_38144;
(statearr_38171[(13)] = inst_38060);

(statearr_38171[(17)] = inst_38047__$1);

(statearr_38171[(7)] = inst_38050__$1);

(statearr_38171[(18)] = inst_38061);

(statearr_38171[(12)] = inst_38051__$1);

(statearr_38171[(15)] = inst_38062__$1);

return statearr_38171;
})();
if(cljs.core.truth_(inst_38062__$1)){
var statearr_38172_38215 = state_38144__$1;
(statearr_38172_38215[(1)] = (6));

} else {
var statearr_38173_38216 = state_38144__$1;
(statearr_38173_38216[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38145 === (23))){
var inst_38078 = (state_38144[(8)]);
var inst_38115 = cljs.core.coll_QMARK_.call(null,inst_38078);
var state_38144__$1 = state_38144;
if(inst_38115){
var statearr_38174_38217 = state_38144__$1;
(statearr_38174_38217[(1)] = (25));

} else {
var statearr_38175_38218 = state_38144__$1;
(statearr_38175_38218[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38145 === (19))){
var inst_38076 = (state_38144[(14)]);
var inst_38106 = cljs.core.PersistentHashMap.EMPTY;
var inst_38107 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_38106,inst_38076);
var state_38144__$1 = state_38144;
var statearr_38176_38219 = state_38144__$1;
(statearr_38176_38219[(2)] = inst_38107);

(statearr_38176_38219[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38145 === (11))){
var inst_38076 = (state_38144[(14)]);
var state_38144__$1 = state_38144;
var statearr_38178_38220 = state_38144__$1;
(statearr_38178_38220[(2)] = inst_38076);

(statearr_38178_38220[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38145 === (9))){
var inst_38072 = (state_38144[(16)]);
var inst_38047 = (state_38144[(17)]);
var inst_38051 = (state_38144[(12)]);
var inst_38071 = (state_38144[(2)]);
var inst_38072__$1 = fluree.db.util.async.throw_err.call(null,inst_38071);
var inst_38073 = cljs.core.count.call(null,inst_38072__$1);
var inst_38074 = fluree.db.query.analytical.add_fuel.call(null,inst_38073,fuel,max_fuel);
var inst_38075 = cljs.core.vals.call(null,inst_38047);
var inst_38076 = fluree.db.query.analytical.get_ns_arrays.call(null,inst_38075,inst_38072__$1);
var state_38144__$1 = (function (){var statearr_38179 = state_38144;
(statearr_38179[(16)] = inst_38072__$1);

(statearr_38179[(19)] = inst_38074);

(statearr_38179[(14)] = inst_38076);

return statearr_38179;
})();
if(cljs.core.truth_(inst_38051)){
var statearr_38180_38221 = state_38144__$1;
(statearr_38180_38221[(1)] = (10));

} else {
var statearr_38181_38222 = state_38144__$1;
(statearr_38181_38222[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38145 === (5))){
var _ = (function (){var statearr_38182 = state_38144;
(statearr_38182[(4)] = cljs.core.rest.call(null,(state_38144[(4)])));

return statearr_38182;
})();
var state_38144__$1 = state_38144;
var ex38177 = (state_38144__$1[(2)]);
var statearr_38183_38223 = state_38144__$1;
(statearr_38183_38223[(5)] = ex38177);


if((ex38177 instanceof Error)){
var statearr_38184_38224 = state_38144__$1;
(statearr_38184_38224[(1)] = (4));

(statearr_38184_38224[(5)] = null);

} else {
throw ex38177;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38145 === (14))){
var state_38144__$1 = state_38144;
var statearr_38185_38225 = state_38144__$1;
(statearr_38185_38225[(2)] = null);

(statearr_38185_38225[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38145 === (26))){
var state_38144__$1 = state_38144;
var statearr_38186_38226 = state_38144__$1;
(statearr_38186_38226[(2)] = null);

(statearr_38186_38226[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38145 === (16))){
var state_38144__$1 = state_38144;
var statearr_38187_38227 = state_38144__$1;
(statearr_38187_38227[(2)] = null);

(statearr_38187_38227[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38145 === (10))){
var inst_38081 = (state_38144[(10)]);
var inst_38060 = (state_38144[(13)]);
var inst_38078 = cljs.core.first.call(null,inst_38060);
var inst_38079 = cljs.core.first.call(null,clause);
var inst_38080 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_38079);
var inst_38081__$1 = cljs.core.nth.call(null,inst_38060,(1));
var inst_38082 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_38081__$1);
var state_38144__$1 = (function (){var statearr_38188 = state_38144;
(statearr_38188[(10)] = inst_38081__$1);

(statearr_38188[(11)] = inst_38080);

(statearr_38188[(8)] = inst_38078);

return statearr_38188;
})();
if(cljs.core.truth_(inst_38082)){
var statearr_38189_38228 = state_38144__$1;
(statearr_38189_38228[(1)] = (13));

} else {
var statearr_38190_38229 = state_38144__$1;
(statearr_38190_38229[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38145 === (18))){
var inst_38080 = (state_38144[(11)]);
var inst_38104 = (state_38144[(2)]);
var state_38144__$1 = (function (){var statearr_38191 = state_38144;
(statearr_38191[(20)] = inst_38104);

return statearr_38191;
})();
if(cljs.core.truth_(inst_38080)){
var statearr_38192_38230 = state_38144__$1;
(statearr_38192_38230[(1)] = (19));

} else {
var statearr_38193_38231 = state_38144__$1;
(statearr_38193_38231[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38145 === (8))){
var inst_38060 = (state_38144[(13)]);
var inst_38061 = (state_38144[(18)]);
var inst_38066 = (state_38144[(2)]);
var inst_38067 = [inst_38066];
var inst_38068 = cljs.core.PersistentHashMap.fromArrays(inst_38061,inst_38067);
var inst_38069 = fluree.db.query.range.search.call(null,db,inst_38060,inst_38068);
var state_38144__$1 = state_38144;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38144__$1,(9),inst_38069);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16221__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16221__auto____0 = (function (){
var statearr_38194 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38194[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16221__auto__);

(statearr_38194[(1)] = (1));

return statearr_38194;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16221__auto____1 = (function (state_38144){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_38144);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e38195){var ex__16224__auto__ = e38195;
var statearr_38196_38232 = state_38144;
(statearr_38196_38232[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_38144[(4)]))){
var statearr_38197_38233 = state_38144;
(statearr_38197_38233[(1)] = cljs.core.first.call(null,(state_38144[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38234 = state_38144;
state_38144 = G__38234;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16221__auto__ = function(state_38144){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16221__auto____1.call(this,state_38144);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16221__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16221__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_38198 = f__16346__auto__.call(null);
(statearr_38198[(6)] = c__16345__auto__);

return statearr_38198;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__38235,res,clause){
var map__38236 = p__38235;
var map__38236__$1 = cljs.core.__destructure_map.call(null,map__38236);
var db = map__38236__$1;
var conn = cljs.core.get.call(null,map__38236__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__38236__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__38236__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
throw cljs.core.ex_info.call(null,"Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_38345){
var state_val_38346 = (state_38345[(1)]);
if((state_val_38346 === (7))){
var inst_38245 = (state_38345[(7)]);
var state_38345__$1 = state_38345;
var statearr_38347_38388 = state_38345__$1;
(statearr_38347_38388[(2)] = inst_38245);

(statearr_38347_38388[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38346 === (20))){
var state_38345__$1 = state_38345;
var statearr_38348_38389 = state_38345__$1;
(statearr_38348_38389[(2)] = null);

(statearr_38348_38389[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38346 === (1))){
var state_38345__$1 = state_38345;
var statearr_38349_38390 = state_38345__$1;
(statearr_38349_38390[(2)] = null);

(statearr_38349_38390[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38346 === (24))){
var inst_38247 = (state_38345[(8)]);
var inst_38318 = (state_38345[(2)]);
var inst_38319 = fluree.db.flake.sid__GT_cid.call(null,inst_38318);
var inst_38320 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_38319);
var inst_38321 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_38322 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38323 = [inst_38247];
var inst_38324 = (new cljs.core.PersistentVector(null,1,(5),inst_38322,inst_38323,null));
var inst_38325 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38326 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38327 = [inst_38320];
var inst_38328 = (new cljs.core.PersistentVector(null,1,(5),inst_38326,inst_38327,null));
var inst_38329 = [inst_38328];
var inst_38330 = (new cljs.core.PersistentVector(null,1,(5),inst_38325,inst_38329,null));
var inst_38331 = cljs.core.PersistentHashMap.EMPTY;
var inst_38332 = [inst_38324,inst_38330,inst_38331];
var inst_38333 = cljs.core.PersistentHashMap.fromArrays(inst_38321,inst_38332);
var state_38345__$1 = state_38345;
var statearr_38350_38391 = state_38345__$1;
(statearr_38350_38391[(2)] = inst_38333);

(statearr_38350_38391[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38346 === (4))){
var inst_38238 = (state_38345[(2)]);
var state_38345__$1 = state_38345;
var statearr_38351_38392 = state_38345__$1;
(statearr_38351_38392[(2)] = inst_38238);

(statearr_38351_38392[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38346 === (15))){
var inst_38247 = (state_38345[(8)]);
var inst_38245 = (state_38345[(7)]);
var inst_38266 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_38267 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_38268 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38269 = [inst_38245];
var inst_38270 = (new cljs.core.PersistentVector(null,1,(5),inst_38268,inst_38269,null));
var inst_38271 = (function (){var subject_var = inst_38245;
var object_var = inst_38247;
var min_sid = inst_38266;
var max_sid = (0);
return (function (p1__38237_SHARP_){
return cljs.core.conj.call(null,cljs.core.PersistentVector.EMPTY,p1__38237_SHARP_);
});
})();
var inst_38272 = cljs.core.range.call(null,inst_38266,(0));
var inst_38273 = cljs.core.map.call(null,inst_38271,inst_38272);
var inst_38274 = cljs.core.PersistentHashMap.EMPTY;
var inst_38275 = [inst_38270,inst_38273,inst_38274];
var inst_38276 = cljs.core.PersistentHashMap.fromArrays(inst_38267,inst_38275);
var state_38345__$1 = state_38345;
var statearr_38352_38393 = state_38345__$1;
(statearr_38352_38393[(2)] = inst_38276);

(statearr_38352_38393[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38346 === (21))){
var inst_38336 = (state_38345[(2)]);
var state_38345__$1 = state_38345;
var statearr_38353_38394 = state_38345__$1;
(statearr_38353_38394[(2)] = inst_38336);

(statearr_38353_38394[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38346 === (13))){
var inst_38247 = (state_38345[(8)]);
var state_38345__$1 = state_38345;
if(cljs.core.truth_(inst_38247)){
var statearr_38354_38395 = state_38345__$1;
(statearr_38354_38395[(1)] = (19));

} else {
var statearr_38355_38396 = state_38345__$1;
(statearr_38355_38396[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38346 === (22))){
var inst_38309 = (state_38345[(9)]);
var state_38345__$1 = state_38345;
var statearr_38356_38397 = state_38345__$1;
(statearr_38356_38397[(2)] = inst_38309);

(statearr_38356_38397[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38346 === (6))){
var inst_38247 = (state_38345[(8)]);
var state_38345__$1 = state_38345;
var statearr_38357_38398 = state_38345__$1;
(statearr_38357_38398[(2)] = inst_38247);

(statearr_38357_38398[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38346 === (25))){
var inst_38315 = (state_38345[(2)]);
var inst_38316 = fluree.db.util.async.throw_err.call(null,inst_38315);
var state_38345__$1 = state_38345;
var statearr_38358_38399 = state_38345__$1;
(statearr_38358_38399[(2)] = inst_38316);

(statearr_38358_38399[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38346 === (17))){
var inst_38306 = (state_38345[(2)]);
var state_38345__$1 = state_38345;
var statearr_38359_38400 = state_38345__$1;
(statearr_38359_38400[(2)] = inst_38306);

(statearr_38359_38400[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38346 === (3))){
var inst_38343 = (state_38345[(2)]);
var state_38345__$1 = state_38345;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38345__$1,inst_38343);
} else {
if((state_val_38346 === (12))){
var inst_38260 = ["_tx",null,"_block",null];
var inst_38261 = (new cljs.core.PersistentArrayMap(null,2,inst_38260,null));
var inst_38262 = (new cljs.core.PersistentHashSet(null,inst_38261,null));
var inst_38263 = cljs.core.last.call(null,clause);
var inst_38264 = inst_38262.call(null,inst_38263);
var state_38345__$1 = state_38345;
if(cljs.core.truth_(inst_38264)){
var statearr_38360_38401 = state_38345__$1;
(statearr_38360_38401[(1)] = (15));

} else {
var statearr_38361_38402 = state_38345__$1;
(statearr_38361_38402[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38346 === (2))){
var inst_38245 = (state_38345[(7)]);
var _ = (function (){var statearr_38362 = state_38345;
(statearr_38362[(4)] = cljs.core.cons.call(null,(5),(state_38345[(4)])));

return statearr_38362;
})();
var inst_38244 = cljs.core.first.call(null,clause);
var inst_38245__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_38244);
var inst_38246 = cljs.core.last.call(null,clause);
var inst_38247 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_38246);
var state_38345__$1 = (function (){var statearr_38363 = state_38345;
(statearr_38363[(8)] = inst_38247);

(statearr_38363[(7)] = inst_38245__$1);

return statearr_38363;
})();
if(cljs.core.truth_(inst_38245__$1)){
var statearr_38364_38403 = state_38345__$1;
(statearr_38364_38403[(1)] = (6));

} else {
var statearr_38365_38404 = state_38345__$1;
(statearr_38365_38404[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38346 === (23))){
var inst_38309 = (state_38345[(9)]);
var inst_38313 = fluree.db.dbproto._subid.call(null,db,inst_38309);
var state_38345__$1 = state_38345;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38345__$1,(25),inst_38313);
} else {
if((state_val_38346 === (19))){
var inst_38309 = (state_38345[(9)]);
var inst_38309__$1 = cljs.core.first.call(null,clause);
var inst_38310 = typeof inst_38309__$1 === 'number';
var state_38345__$1 = (function (){var statearr_38366 = state_38345;
(statearr_38366[(9)] = inst_38309__$1);

return statearr_38366;
})();
if(cljs.core.truth_(inst_38310)){
var statearr_38367_38405 = state_38345__$1;
(statearr_38367_38405[(1)] = (22));

} else {
var statearr_38368_38406 = state_38345__$1;
(statearr_38368_38406[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38346 === (11))){
var inst_38340 = (state_38345[(2)]);
var _ = (function (){var statearr_38370 = state_38345;
(statearr_38370[(4)] = cljs.core.rest.call(null,(state_38345[(4)])));

return statearr_38370;
})();
var state_38345__$1 = state_38345;
var statearr_38371_38407 = state_38345__$1;
(statearr_38371_38407[(2)] = inst_38340);

(statearr_38371_38407[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38346 === (9))){
var inst_38253 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_38254 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_38255 = cljs.core.PersistentHashMap.fromArrays(inst_38253,inst_38254);
var inst_38256 = cljs.core.ex_info.call(null,"When using rdf:type, either a subject or a type (collection) must be specified.",inst_38255);
var inst_38257 = (function(){throw inst_38256})();
var state_38345__$1 = state_38345;
var statearr_38372_38408 = state_38345__$1;
(statearr_38372_38408[(2)] = inst_38257);

(statearr_38372_38408[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38346 === (5))){
var _ = (function (){var statearr_38373 = state_38345;
(statearr_38373[(4)] = cljs.core.rest.call(null,(state_38345[(4)])));

return statearr_38373;
})();
var state_38345__$1 = state_38345;
var ex38369 = (state_38345__$1[(2)]);
var statearr_38374_38409 = state_38345__$1;
(statearr_38374_38409[(5)] = ex38369);


if((ex38369 instanceof Error)){
var statearr_38375_38410 = state_38345__$1;
(statearr_38375_38410[(1)] = (4));

(statearr_38375_38410[(5)] = null);

} else {
throw ex38369;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38346 === (14))){
var inst_38338 = (state_38345[(2)]);
var state_38345__$1 = state_38345;
var statearr_38376_38411 = state_38345__$1;
(statearr_38376_38411[(2)] = inst_38338);

(statearr_38376_38411[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38346 === (16))){
var inst_38282 = (state_38345[(10)]);
var inst_38281 = (state_38345[(11)]);
var inst_38279 = (state_38345[(12)]);
var inst_38278 = cljs.core.last.call(null,clause);
var inst_38279__$1 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"partition","partition",1174740751),inst_38278);
var inst_38280 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_38281__$1 = cljs.core.get.call(null,inst_38280,inst_38279__$1);
var inst_38282__$1 = fluree.db.flake.min_subject_id.call(null,inst_38279__$1);
var inst_38283 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38284 = [inst_38281__$1];
var inst_38285 = (new cljs.core.PersistentVector(null,1,(5),inst_38283,inst_38284,null));
var inst_38286 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38287 = [inst_38282__$1];
var inst_38288 = (new cljs.core.PersistentVector(null,1,(5),inst_38286,inst_38287,null));
var inst_38289 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_38285,cljs.core._LT__EQ_,inst_38288);
var state_38345__$1 = (function (){var statearr_38377 = state_38345;
(statearr_38377[(10)] = inst_38282__$1);

(statearr_38377[(11)] = inst_38281__$1);

(statearr_38377[(12)] = inst_38279__$1);

return statearr_38377;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38345__$1,(18),inst_38289);
} else {
if((state_val_38346 === (10))){
var inst_38245 = (state_38345[(7)]);
var state_38345__$1 = state_38345;
if(cljs.core.truth_(inst_38245)){
var statearr_38378_38412 = state_38345__$1;
(statearr_38378_38412[(1)] = (12));

} else {
var statearr_38379_38413 = state_38345__$1;
(statearr_38379_38413[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38346 === (18))){
var inst_38247 = (state_38345[(8)]);
var inst_38282 = (state_38345[(10)]);
var inst_38245 = (state_38345[(7)]);
var inst_38281 = (state_38345[(11)]);
var inst_38279 = (state_38345[(12)]);
var inst_38291 = (state_38345[(2)]);
var inst_38292 = fluree.db.util.async.throw_err.call(null,inst_38291);
var inst_38293 = (function (){var subject_var = inst_38245;
var object_var = inst_38247;
var partition = inst_38279;
var max_sid = inst_38281;
var min_sid = inst_38282;
var flakes = inst_38292;
return (function (f){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s], null);
});
})();
var inst_38294 = cljs.core.map.call(null,inst_38293);
var inst_38295 = cljs.core.distinct.call(null);
var inst_38296 = cljs.core.comp.call(null,inst_38294,inst_38295);
var inst_38297 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_38298 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38299 = [inst_38245];
var inst_38300 = (new cljs.core.PersistentVector(null,1,(5),inst_38298,inst_38299,null));
var inst_38301 = cljs.core.sequence.call(null,inst_38296,inst_38292);
var inst_38302 = cljs.core.PersistentHashMap.EMPTY;
var inst_38303 = [inst_38300,inst_38301,inst_38302];
var inst_38304 = cljs.core.PersistentHashMap.fromArrays(inst_38297,inst_38303);
var state_38345__$1 = state_38345;
var statearr_38380_38414 = state_38345__$1;
(statearr_38380_38414[(2)] = inst_38304);

(statearr_38380_38414[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38346 === (8))){
var inst_38251 = (state_38345[(2)]);
var state_38345__$1 = state_38345;
if(cljs.core.truth_(inst_38251)){
var statearr_38381_38415 = state_38345__$1;
(statearr_38381_38415[(1)] = (9));

} else {
var statearr_38382_38416 = state_38345__$1;
(statearr_38382_38416[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16221__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16221__auto____0 = (function (){
var statearr_38383 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38383[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16221__auto__);

(statearr_38383[(1)] = (1));

return statearr_38383;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16221__auto____1 = (function (state_38345){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_38345);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e38384){var ex__16224__auto__ = e38384;
var statearr_38385_38417 = state_38345;
(statearr_38385_38417[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_38345[(4)]))){
var statearr_38386_38418 = state_38345;
(statearr_38386_38418[(1)] = cljs.core.first.call(null,(state_38345[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38419 = state_38345;
state_38345 = G__38419;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16221__auto__ = function(state_38345){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16221__auto____1.call(this,state_38345);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16221__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16221__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_38387 = f__16346__auto__.call(null);
(statearr_38387[(6)] = c__16345__auto__);

return statearr_38387;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.call(null,cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum.call(null,coll) / cljs.core.count.call(null,coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.call(null,coll);
var size = cljs.core.count.call(null,coll);
var med = (size >> (1));
var G__38425 = cljs.core.nth.call(null,terms,med);
if(cljs.core.even_QMARK_.call(null,size)){
return ((G__38425 + cljs.core.nth.call(null,terms,(med - (1)))) / (2));
} else {
return G__38425;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg.call(null,coll);
var sum__$1 = sum.call(null,(function (){var iter__4611__auto__ = (function fluree$db$query$analytical$variance_$_iter__38426(s__38427){
return (new cljs.core.LazySeq(null,(function (){
var s__38427__$1 = s__38427;
while(true){
var temp__5753__auto__ = cljs.core.seq.call(null,s__38427__$1);
if(temp__5753__auto__){
var s__38427__$2 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__38427__$2)){
var c__4609__auto__ = cljs.core.chunk_first.call(null,s__38427__$2);
var size__4610__auto__ = cljs.core.count.call(null,c__4609__auto__);
var b__38429 = cljs.core.chunk_buffer.call(null,size__4610__auto__);
if((function (){var i__38428 = (0);
while(true){
if((i__38428 < size__4610__auto__)){
var x = cljs.core._nth.call(null,c__4609__auto__,i__38428);
var delta = (x - mean);
cljs.core.chunk_append.call(null,b__38429,(delta * delta));

var G__38430 = (i__38428 + (1));
i__38428 = G__38430;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__38429),fluree$db$query$analytical$variance_$_iter__38426.call(null,cljs.core.chunk_rest.call(null,s__38427__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__38429),null);
}
} else {
var x = cljs.core.first.call(null,s__38427__$2);
var delta = (x - mean);
return cljs.core.cons.call(null,(delta * delta),fluree$db$query$analytical$variance_$_iter__38426.call(null,cljs.core.rest.call(null,s__38427__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__.call(null,coll);
})());
return (sum__$1 / cljs.core.count.call(null,coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
return Math.sqrt(variance.call(null,coll));
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4295__auto__ = n;
var y__4296__auto__ = (- n);
return ((x__4295__auto__ > y__4296__auto__) ? x__4295__auto__ : y__4296__auto__);
}),(function() {
var G__38431 = null;
var G__38431__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__38431__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.last.call(null,acc)) < (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.butlast.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__38431 = function(n,coll){
switch(arguments.length){
case 1:
return G__38431__1.call(this,n);
case 2:
return G__38431__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__38431.cljs$core$IFn$_invoke$arity$1 = G__38431__1;
G__38431.cljs$core$IFn$_invoke$arity$2 = G__38431__2;
return G__38431;
})()
,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__38432 = null;
var G__38432__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__38432__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.first.call(null,acc)) > (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.next.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__38432 = function(n,coll){
switch(arguments.length){
case 1:
return G__38432__1.call(this,n);
case 2:
return G__38432__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__38432.cljs$core$IFn$_invoke$arity$1 = G__38432__1;
G__38432.cljs$core$IFn$_invoke$arity$2 = G__38432__2;
return G__38432;
})()
,(function (coll){
return cljs.core.count.call(null,cljs.core.distinct.call(null,coll));
}),avg,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__38433 = null;
var G__38433__1 = (function (coll){
return cljs.core.rand_nth.call(null,coll);
});
var G__38433__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.repeatedly.call(null,n,(function (){
return cljs.core.rand_nth.call(null,coll);
})));
});
G__38433 = function(n,coll){
switch(arguments.length){
case 1:
return G__38433__1.call(this,n);
case 2:
return G__38433__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__38433.cljs$core$IFn$_invoke$arity$1 = G__38433__1;
G__38433.cljs$core$IFn$_invoke$arity$2 = G__38433__2;
return G__38433;
})()
,(function (n,coll){
return cljs.core.vec.call(null,cljs.core.take.call(null,n,cljs.core.shuffle.call(null,coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__4210__auto__ = typeof x === 'string';
if(and__4210__auto__){
return cljs.core.re_matches.call(null,/^\(.+\)$/,x);
} else {
return and__4210__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__4210__auto__ = typeof x === 'string';
if(and__4210__auto__){
return cljs.core.re_matches.call(null,/^#\(.+\)$/,x);
} else {
return and__4210__auto__;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.call(null,x);
var as_QMARK_ = cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first.call(null,list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,list_agg))].join('')):cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second.call(null,list_agg);
if(cljs.core.coll_QMARK_.call(null,func_list)){
return func_list;
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
var list_count = cljs.core.count.call(null,func_list);
var vec__38434 = ((cljs.core._EQ_.call(null,(3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,func_list),cljs.core.second.call(null,func_list),cljs.core.last.call(null,func_list)], null):((((cljs.core._EQ_.call(null,(2),list_count)) && (cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first.call(null,func_list)))))?(function(){throw cljs.core.ex_info.call(null,["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((cljs.core._EQ_.call(null,(2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,func_list),null,cljs.core.last.call(null,func_list)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var fun = cljs.core.nth.call(null,vec__38434,(0),null);
var arg = cljs.core.nth.call(null,vec__38434,(1),null);
var var$ = cljs.core.nth.call(null,vec__38434,(2),null);
var agg_fn = (function (){var temp__5751__auto__ = fluree.db.query.analytical.built_in_aggregates.call(null,fun);
if(cljs.core.truth_(temp__5751__auto__)){
var agg_fn = temp__5751__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return agg_fn.call(null,arg,coll);
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__38437 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_.call(null,var$)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second.call(null,var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
return agg_fn.call(null,cljs.core.distinct.call(null,coll));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.call(null,vec__38437,(0),null);
var variable = cljs.core.nth.call(null,vec__38437,(1),null);
var _ = (cljs.core.truth_(valid_var.call(null,variable))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"code","code",1586293142),agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__38440 = agg;
var map__38440__$1 = cljs.core.__destructure_map.call(null,map__38440);
var variable = cljs.core.get.call(null,map__38440__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.call(null,map__38440__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var code = cljs.core.get.call(null,map__38440__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var agg_params = cljs.core.flatten.call(null,fluree.db.query.analytical.select_from_tuples.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = code.call(null,agg_params);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.call(null,(function (res__$1,agg){
var vec__38442 = fluree.db.query.analytical.calculate_aggregate.call(null,res__$1,agg);
var as = cljs.core.nth.call(null,vec__38442,(0),null);
var agg_result = cljs.core.nth.call(null,vec__38442,(1),null);
var map__38445 = res__$1;
var map__38445__$1 = cljs.core.__destructure_map.call(null,map__38445);
var headers = cljs.core.get.call(null,map__38445__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__38445__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__38441_SHARP_){
return cljs.core.conj.call(null,cljs.core.vec.call(null,p1__38441_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,cljs.core.vec.call(null,headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.call(null,cljs.core.symbol,cljs.core.keys.call(null,q_map));
var vals = cljs.core.vals.call(null,q_map);
return cljs.core.zipmap.call(null,keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.call(null,(function (acc,tuple){
var b_compare = cljs.core.map.call(null,(function (p1__38446_SHARP_){
return cljs.core.nth.call(null,tuple,p1__38446_SHARP_);
}),b_idxs);
return cljs.core.update.call(null,acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq.call(null,cljs.core.reduce.call(null,(function (acc,a_tuple){
var a_compare = cljs.core.map.call(null,(function (p1__38447_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__38447_SHARP_);
}),a_idxs);
var temp__5751__auto__ = cljs.core.get.call(null,b_map,a_compare);
if(cljs.core.truth_(temp__5751__auto__)){
var b_matched = temp__5751__auto__;
return cljs.core.reduce.call(null,(function (p1__38448_SHARP_,p2__38449_SHARP_){
return cljs.core.conj.call(null,p1__38448_SHARP_,cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (idx){
return cljs.core.nth.call(null,p2__38449_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.call(null,acc,cljs.core.concat.call(null,a_tuple,cljs.core.repeat.call(null,cljs.core.count.call(null,b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.call(null,(function (p1__38450_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__38450_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv.call(null,(function (p__38453,row,b_tuple){
var vec__38454 = p__38453;
var acc = cljs.core.nth.call(null,vec__38454,(0),null);
var b_rows = cljs.core.nth.call(null,vec__38454,(1),null);
if(cljs.core._EQ_.call(null,a_tuple_part,cljs.core.map.call(null,(function (p1__38451_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__38451_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,(function (){var or__4212__auto__ = acc;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (p1__38452_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__38452_SHARP_);
}),b_not_idxs))),cljs.core.conj.call(null,b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_res,b_res);
var a_idxs = cljs.core.map.call(null,(function (p1__38457_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__38457_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__38458_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__38458_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__38460_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__38460_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__38459_SHARP_){
return cljs.core.range.call(null,(0),p1__38459_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = fluree.db.query.analytical.match_tuples_lists.call(null,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.call(null,(function (p1__38461_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__38461_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_tuples,b_tuples);
var a_idxs = cljs.core.map.call(null,(function (p1__38462_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__38462_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__38463_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__38463_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__38465_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__38465_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__38464_SHARP_){
return cljs.core.range.call(null,(0),p1__38464_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = fluree.db.query.analytical.match_tuples_lists.call(null,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.call(null,(function (p1__38466_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__38466_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.call(null," ",filter_code_req),")"].join('');
var vec__38468 = (function (){var or__4212__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.call(null,vec__38468,(0),null);
var _ = cljs.core.nth.call(null,vec__38468,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.call(null,(function (p1__38467_SHARP_){
return fluree.db.query.analytical_filter.filter_row.call(null,headers,p1__38467_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.call(null,(function (tuples__$1,filt){
var var_atom = cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY);
var vec__38473 = (function (){var or__4212__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.call(null,vec__38473,(0),null);
var filt_vars = cljs.core.nth.call(null,vec__38473,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.call(null,(function (p1__38471_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__38471_SHARP_);
}),cljs.core.deref.call(null,filt_vars));
var filtered_tuples = cljs.core.reduce.call(null,(function (acc,clause){
if(cljs.core.every_QMARK_.call(null,(function (p1__38472_SHARP_){
return cljs.core.nth.call(null,clause,p1__38472_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row.call(null,headers,clause,filt_str))){
return cljs.core.conj.call(null,acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.call(null,acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__38476,filters,optional_QMARK_){
var map__38477 = p__38476;
var map__38477__$1 = cljs.core.__destructure_map.call(null,map__38477);
var tuple_map = map__38477__$1;
var headers = cljs.core.get.call(null,map__38477__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__38477__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.call(null,map__38477__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set.call(null,headers);
var header_vec = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.call(null,["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters.call(null,filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required.call(null,header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters.call(null,filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__38478 = clause;
var k = cljs.core.nth.call(null,vec__38478,(0),null);
var v = cljs.core.nth.call(null,vec__38478,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.call(null,["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__38481 = res;
var map__38481__$1 = cljs.core.__destructure_map.call(null,map__38481);
var headers = cljs.core.get.call(null,map__38481__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__38481__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_.call(null,v))?cljs.core.second.call(null,fluree.db.query.analytical.calculate_aggregate.call(null,res,fluree.db.query.analytical.parse_aggregate.call(null,cljs.core.subs.call(null,v,(1)),cljs.core.set.call(null,(function (){var temp__5751__auto__ = cljs.core.keys.call(null,vars);
if(cljs.core.truth_(temp__5751__auto__)){
var valid_var = temp__5751__auto__;
return cljs.core.conj.call(null,headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_38537){
var state_val_38538 = (state_38537[(1)]);
if((state_val_38538 === (7))){
var inst_38511 = (state_38537[(7)]);
var inst_38509 = (state_38537[(2)]);
var inst_38510 = fluree.db.util.async.throw_err.call(null,inst_38509);
var inst_38511__$1 = cljs.core.nth.call(null,inst_38510,(0),null);
var inst_38512 = cljs.core.nth.call(null,inst_38510,(1),null);
var inst_38513 = (inst_38511__$1 == null);
var state_38537__$1 = (function (){var statearr_38539 = state_38537;
(statearr_38539[(8)] = inst_38512);

(statearr_38539[(7)] = inst_38511__$1);

return statearr_38539;
})();
if(cljs.core.truth_(inst_38513)){
var statearr_38540_38569 = state_38537__$1;
(statearr_38540_38569[(1)] = (8));

} else {
var statearr_38541_38570 = state_38537__$1;
(statearr_38541_38570[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38538 === (1))){
var inst_38489 = optional_clauses;
var inst_38490 = cljs.core.seq.call(null,inst_38489);
var inst_38491 = cljs.core.first.call(null,inst_38490);
var inst_38492 = cljs.core.next.call(null,inst_38490);
var inst_38493 = where_tuples;
var inst_38494 = inst_38489;
var inst_38495 = inst_38493;
var state_38537__$1 = (function (){var statearr_38542 = state_38537;
(statearr_38542[(9)] = inst_38492);

(statearr_38542[(10)] = inst_38494);

(statearr_38542[(11)] = inst_38491);

(statearr_38542[(12)] = inst_38495);

return statearr_38542;
})();
var statearr_38543_38571 = state_38537__$1;
(statearr_38543_38571[(2)] = null);

(statearr_38543_38571[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38538 === (4))){
var inst_38501 = (state_38537[(13)]);
var inst_38502 = (state_38537[(14)]);
var inst_38495 = (state_38537[(12)]);
var inst_38507 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_38495,inst_38501,inst_38502,true,fuel,max_fuel,opts);
var state_38537__$1 = state_38537;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38537__$1,(7),inst_38507);
} else {
if((state_val_38538 === (15))){
var state_38537__$1 = state_38537;
var statearr_38544_38572 = state_38537__$1;
(statearr_38544_38572[(2)] = null);

(statearr_38544_38572[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38538 === (13))){
var inst_38528 = (state_38537[(2)]);
var state_38537__$1 = state_38537;
var statearr_38545_38573 = state_38537__$1;
(statearr_38545_38573[(2)] = inst_38528);

(statearr_38545_38573[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38538 === (6))){
var inst_38533 = (state_38537[(2)]);
var state_38537__$1 = state_38537;
var statearr_38546_38574 = state_38537__$1;
(statearr_38546_38574[(2)] = inst_38533);

(statearr_38546_38574[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38538 === (3))){
var inst_38535 = (state_38537[(2)]);
var state_38537__$1 = state_38537;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38537__$1,inst_38535);
} else {
if((state_val_38538 === (12))){
var state_38537__$1 = state_38537;
var statearr_38547_38575 = state_38537__$1;
(statearr_38547_38575[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38538 === (2))){
var inst_38494 = (state_38537[(10)]);
var inst_38501 = (state_38537[(13)]);
var inst_38500 = cljs.core.seq.call(null,inst_38494);
var inst_38501__$1 = cljs.core.first.call(null,inst_38500);
var inst_38502 = cljs.core.next.call(null,inst_38500);
var state_38537__$1 = (function (){var statearr_38549 = state_38537;
(statearr_38549[(13)] = inst_38501__$1);

(statearr_38549[(14)] = inst_38502);

return statearr_38549;
})();
if(cljs.core.truth_(inst_38501__$1)){
var statearr_38550_38576 = state_38537__$1;
(statearr_38550_38576[(1)] = (4));

} else {
var statearr_38551_38577 = state_38537__$1;
(statearr_38551_38577[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38538 === (11))){
var inst_38512 = (state_38537[(8)]);
var inst_38511 = (state_38537[(7)]);
var inst_38494 = inst_38512;
var inst_38495 = inst_38511;
var state_38537__$1 = (function (){var statearr_38552 = state_38537;
(statearr_38552[(10)] = inst_38494);

(statearr_38552[(12)] = inst_38495);

return statearr_38552;
})();
var statearr_38553_38578 = state_38537__$1;
(statearr_38553_38578[(2)] = null);

(statearr_38553_38578[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38538 === (9))){
var inst_38501 = (state_38537[(13)]);
var inst_38517 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_38501);
var state_38537__$1 = state_38537;
if(cljs.core.truth_(inst_38517)){
var statearr_38554_38579 = state_38537__$1;
(statearr_38554_38579[(1)] = (11));

} else {
var statearr_38555_38580 = state_38537__$1;
(statearr_38555_38580[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38538 === (5))){
var inst_38495 = (state_38537[(12)]);
var state_38537__$1 = state_38537;
var statearr_38556_38581 = state_38537__$1;
(statearr_38556_38581[(2)] = inst_38495);

(statearr_38556_38581[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38538 === (14))){
var inst_38512 = (state_38537[(8)]);
var inst_38495 = (state_38537[(12)]);
var inst_38511 = (state_38537[(7)]);
var inst_38522 = fluree.db.query.analytical.left_outer_join.call(null,inst_38495,inst_38511);
var inst_38494 = inst_38512;
var inst_38495__$1 = inst_38522;
var state_38537__$1 = (function (){var statearr_38557 = state_38537;
(statearr_38557[(10)] = inst_38494);

(statearr_38557[(12)] = inst_38495__$1);

return statearr_38557;
})();
var statearr_38558_38582 = state_38537__$1;
(statearr_38558_38582[(2)] = null);

(statearr_38558_38582[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38538 === (16))){
var inst_38526 = (state_38537[(2)]);
var state_38537__$1 = state_38537;
var statearr_38560_38583 = state_38537__$1;
(statearr_38560_38583[(2)] = inst_38526);

(statearr_38560_38583[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38538 === (10))){
var inst_38530 = (state_38537[(2)]);
var state_38537__$1 = state_38537;
var statearr_38561_38584 = state_38537__$1;
(statearr_38561_38584[(2)] = inst_38530);

(statearr_38561_38584[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38538 === (8))){
var inst_38512 = (state_38537[(8)]);
var inst_38495 = (state_38537[(12)]);
var tmp38559 = inst_38495;
var inst_38494 = inst_38512;
var inst_38495__$1 = tmp38559;
var state_38537__$1 = (function (){var statearr_38562 = state_38537;
(statearr_38562[(10)] = inst_38494);

(statearr_38562[(12)] = inst_38495__$1);

return statearr_38562;
})();
var statearr_38563_38585 = state_38537__$1;
(statearr_38563_38585[(2)] = null);

(statearr_38563_38585[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16221__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16221__auto____0 = (function (){
var statearr_38564 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38564[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16221__auto__);

(statearr_38564[(1)] = (1));

return statearr_38564;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16221__auto____1 = (function (state_38537){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_38537);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e38565){var ex__16224__auto__ = e38565;
var statearr_38566_38586 = state_38537;
(statearr_38566_38586[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_38537[(4)]))){
var statearr_38567_38587 = state_38537;
(statearr_38567_38587[(1)] = cljs.core.first.call(null,(state_38537[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38588 = state_38537;
state_38537 = G__38588;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16221__auto__ = function(state_38537){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16221__auto____1.call(this,state_38537);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16221__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16221__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_38568 = f__16346__auto__.call(null);
(statearr_38568[(6)] = c__16345__auto__);

return statearr_38568;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.call(null,(function (acc,p__38590){
var vec__38591 = p__38590;
var var_name = cljs.core.nth.call(null,vec__38591,(0),null);
var var_val = cljs.core.nth.call(null,vec__38591,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__38589_SHARP_){
return cljs.core.conj.call(null,p1__38589_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__38595,p__38596,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__38597 = p__38595;
var map__38597__$1 = cljs.core.__destructure_map.call(null,map__38597);
var q_map = map__38597__$1;
var prefixes = cljs.core.get.call(null,map__38597__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__38598 = p__38596;
var map__38598__$1 = cljs.core.__destructure_map.call(null,map__38598);
var res = map__38598__$1;
var vars = cljs.core.get.call(null,map__38598__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_38835){
var state_val_38836 = (state_38835[(1)]);
if((state_val_38836 === (65))){
var inst_38785 = (state_38835[(7)]);
var inst_38784 = (state_38835[(8)]);
var inst_38796 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38797 = fluree.db.query.analytical.full_text__GT_tuples.call(null,inst_38784,res,inst_38785);
var inst_38798 = [inst_38797,r];
var inst_38799 = (new cljs.core.PersistentVector(null,2,(5),inst_38796,inst_38798,null));
var state_38835__$1 = state_38835;
var statearr_38837_38942 = state_38835__$1;
(statearr_38837_38942[(2)] = inst_38799);

(statearr_38837_38942[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (70))){
var inst_38811 = (state_38835[(2)]);
var state_38835__$1 = state_38835;
var statearr_38838_38943 = state_38835__$1;
(statearr_38838_38943[(2)] = inst_38811);

(statearr_38838_38943[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (62))){
var inst_38785 = (state_38835[(7)]);
var inst_38793 = cljs.core.second.call(null,inst_38785);
var inst_38794 = clojure.string.starts_with_QMARK_.call(null,inst_38793,"fullText:");
var state_38835__$1 = state_38835;
if(inst_38794){
var statearr_38839_38944 = state_38835__$1;
(statearr_38839_38944[(1)] = (65));

} else {
var statearr_38840_38945 = state_38835__$1;
(statearr_38840_38945[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (7))){
var inst_38704 = (state_38835[(9)]);
var inst_38703 = cljs.core.count.call(null,clause);
var inst_38704__$1 = cljs.core._EQ_.call(null,(3),inst_38703);
var state_38835__$1 = (function (){var statearr_38841 = state_38835;
(statearr_38841[(9)] = inst_38704__$1);

return statearr_38841;
})();
if(inst_38704__$1){
var statearr_38842_38946 = state_38835__$1;
(statearr_38842_38946[(1)] = (31));

} else {
var statearr_38843_38947 = state_38835__$1;
(statearr_38843_38947[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (59))){
var inst_38818 = (state_38835[(2)]);
var state_38835__$1 = state_38835;
var statearr_38844_38948 = state_38835__$1;
(statearr_38844_38948[(2)] = inst_38818);

(statearr_38844_38948[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (20))){
var inst_38667 = (state_38835[(2)]);
var state_38835__$1 = state_38835;
var statearr_38845_38949 = state_38835__$1;
(statearr_38845_38949[(2)] = inst_38667);

(statearr_38845_38949[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (58))){
var state_38835__$1 = state_38835;
var statearr_38846_38950 = state_38835__$1;
(statearr_38846_38950[(2)] = null);

(statearr_38846_38950[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (60))){
var inst_38784 = (state_38835[(8)]);
var inst_38782 = (state_38835[(2)]);
var inst_38783 = fluree.db.util.async.throw_err.call(null,inst_38782);
var inst_38784__$1 = cljs.core.nth.call(null,inst_38783,(0),null);
var inst_38785 = cljs.core.nth.call(null,inst_38783,(1),null);
var inst_38786 = cljs.core._EQ_.call(null,"$wd",inst_38784__$1);
var state_38835__$1 = (function (){var statearr_38847 = state_38835;
(statearr_38847[(7)] = inst_38785);

(statearr_38847[(8)] = inst_38784__$1);

return statearr_38847;
})();
if(inst_38786){
var statearr_38848_38951 = state_38835__$1;
(statearr_38848_38951[(1)] = (61));

} else {
var statearr_38849_38952 = state_38835__$1;
(statearr_38849_38952[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (27))){
var inst_38697 = (state_38835[(2)]);
var state_38835__$1 = state_38835;
var statearr_38850_38953 = state_38835__$1;
(statearr_38850_38953[(2)] = inst_38697);

(statearr_38850_38953[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (1))){
var state_38835__$1 = state_38835;
var statearr_38851_38954 = state_38835__$1;
(statearr_38851_38954[(2)] = null);

(statearr_38851_38954[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (69))){
var state_38835__$1 = state_38835;
var statearr_38852_38955 = state_38835__$1;
(statearr_38852_38955[(2)] = null);

(statearr_38852_38955[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (24))){
var inst_38661 = (state_38835[(2)]);
var state_38835__$1 = state_38835;
var statearr_38853_38956 = state_38835__$1;
(statearr_38853_38956[(2)] = inst_38661);

(statearr_38853_38956[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (55))){
var inst_38767 = ["Invalid where clause, it should have 2+ tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_38768 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_38769 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_38770 = cljs.core.PersistentHashMap.fromArrays(inst_38768,inst_38769);
var inst_38771 = cljs.core.ex_info.call(null,inst_38767,inst_38770);
var inst_38772 = (function(){throw inst_38771})();
var state_38835__$1 = state_38835;
var statearr_38854_38957 = state_38835__$1;
(statearr_38854_38957[(2)] = inst_38772);

(statearr_38854_38957[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (39))){
var inst_38724 = (state_38835[(2)]);
var state_38835__$1 = state_38835;
if(cljs.core.truth_(inst_38724)){
var statearr_38855_38958 = state_38835__$1;
(statearr_38855_38958[(1)] = (40));

} else {
var statearr_38856_38959 = state_38835__$1;
(statearr_38856_38959[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (46))){
var inst_38824 = (state_38835[(2)]);
var state_38835__$1 = state_38835;
var statearr_38857_38960 = state_38835__$1;
(statearr_38857_38960[(2)] = inst_38824);

(statearr_38857_38960[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (4))){
var inst_38599 = (state_38835[(2)]);
var state_38835__$1 = state_38835;
var statearr_38858_38961 = state_38835__$1;
(statearr_38858_38961[(2)] = inst_38599);

(statearr_38858_38961[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (54))){
var inst_38760 = ["Invalid where clause, it appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_38761 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_38762 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_38763 = cljs.core.PersistentHashMap.fromArrays(inst_38761,inst_38762);
var inst_38764 = cljs.core.ex_info.call(null,inst_38760,inst_38763);
var inst_38765 = (function(){throw inst_38764})();
var state_38835__$1 = state_38835;
var statearr_38859_38962 = state_38835__$1;
(statearr_38859_38962[(2)] = inst_38765);

(statearr_38859_38962[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (15))){
var inst_38699 = (state_38835[(2)]);
var state_38835__$1 = state_38835;
var statearr_38860_38963 = state_38835__$1;
(statearr_38860_38963[(2)] = inst_38699);

(statearr_38860_38963[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (48))){
var inst_38748 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38749 = fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,clause);
var inst_38750 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_38749);
var inst_38751 = [inst_38750,r];
var inst_38752 = (new cljs.core.PersistentVector(null,2,(5),inst_38748,inst_38751,null));
var state_38835__$1 = state_38835;
var statearr_38861_38964 = state_38835__$1;
(statearr_38861_38964[(2)] = inst_38752);

(statearr_38861_38964[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (50))){
var inst_38822 = (state_38835[(2)]);
var state_38835__$1 = state_38835;
var statearr_38862_38965 = state_38835__$1;
(statearr_38862_38965[(2)] = inst_38822);

(statearr_38862_38965[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (21))){
var inst_38608 = (state_38835[(10)]);
var inst_38638 = (state_38835[(11)]);
var inst_38644 = (state_38835[(12)]);
var inst_38633 = (state_38835[(13)]);
var inst_38612 = (state_38835[(14)]);
var inst_38637 = (state_38835[(15)]);
var inst_38645 = (state_38835[(16)]);
var inst_38636 = (state_38835[(17)]);
var inst_38635 = (state_38835[(18)]);
var inst_38649 = (state_38835[(2)]);
var inst_38650 = fluree.db.util.async.throw_err.call(null,inst_38649);
var inst_38651 = (function (){var seq__38641 = inst_38645;
var new_res = inst_38650;
var rest = inst_38645;
var vec__38640 = inst_38637;
var vec__38630 = inst_38633;
var seq__38631 = inst_38636;
var expr__38610 = inst_38608;
var tuples = inst_38638;
var first__38632 = inst_38635;
var segment_type = inst_38608;
var pred__38609 = inst_38612;
var first__38642 = inst_38644;
var G__38629 = inst_38637;
var clause_group = inst_38644;
return (function (res__$1,var$){
return cljs.core.update.call(null,new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_38652 = cljs.core.keys.call(null,vars);
var inst_38653 = cljs.core.reduce.call(null,inst_38651,inst_38650,inst_38652);
var inst_38654 = fluree.db.query.analytical.res_absorb_vars.call(null,inst_38653);
var state_38835__$1 = (function (){var statearr_38863 = state_38835;
(statearr_38863[(19)] = inst_38654);

return statearr_38863;
})();
if(cljs.core.truth_(inst_38638)){
var statearr_38864_38966 = state_38835__$1;
(statearr_38864_38966[(1)] = (22));

} else {
var statearr_38865_38967 = state_38835__$1;
(statearr_38865_38967[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (31))){
var inst_38706 = cljs.core.second.call(null,clause);
var inst_38707 = clojure.string.starts_with_QMARK_.call(null,inst_38706,"fullText:");
var state_38835__$1 = state_38835;
var statearr_38866_38968 = state_38835__$1;
(statearr_38866_38968[(2)] = inst_38707);

(statearr_38866_38968[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (32))){
var inst_38704 = (state_38835[(9)]);
var state_38835__$1 = state_38835;
var statearr_38867_38969 = state_38835__$1;
(statearr_38867_38969[(2)] = inst_38704);

(statearr_38867_38969[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (40))){
var inst_38726 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38727 = fluree.db.query.analytical.collection__GT_tuples.call(null,db,res,clause);
var state_38835__$1 = (function (){var statearr_38868 = state_38835;
(statearr_38868[(20)] = inst_38726);

return statearr_38868;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38835__$1,(43),inst_38727);
} else {
if((state_val_38836 === (56))){
var inst_38774 = (state_38835[(2)]);
var state_38835__$1 = state_38835;
var statearr_38869_38970 = state_38835__$1;
(statearr_38869_38970[(2)] = inst_38774);

(statearr_38869_38970[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (33))){
var inst_38710 = (state_38835[(2)]);
var state_38835__$1 = state_38835;
if(cljs.core.truth_(inst_38710)){
var statearr_38870_38971 = state_38835__$1;
(statearr_38870_38971[(1)] = (34));

} else {
var statearr_38871_38972 = state_38835__$1;
(statearr_38871_38972[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (13))){
var inst_38633 = (state_38835[(13)]);
var inst_38633__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_38634 = cljs.core.seq.call(null,inst_38633__$1);
var inst_38635 = cljs.core.first.call(null,inst_38634);
var inst_38636 = cljs.core.next.call(null,inst_38634);
var inst_38637 = inst_38633__$1;
var inst_38638 = null;
var state_38835__$1 = (function (){var statearr_38872 = state_38835;
(statearr_38872[(11)] = inst_38638);

(statearr_38872[(13)] = inst_38633__$1);

(statearr_38872[(15)] = inst_38637);

(statearr_38872[(17)] = inst_38636);

(statearr_38872[(18)] = inst_38635);

return statearr_38872;
})();
var statearr_38873_38973 = state_38835__$1;
(statearr_38873_38973[(2)] = null);

(statearr_38873_38973[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (22))){
var inst_38638 = (state_38835[(11)]);
var inst_38654 = (state_38835[(19)]);
var inst_38645 = (state_38835[(16)]);
var inst_38656 = fluree.db.query.union.results.call(null,inst_38638,inst_38654);
var inst_38637 = inst_38645;
var inst_38638__$1 = inst_38656;
var state_38835__$1 = (function (){var statearr_38874 = state_38835;
(statearr_38874[(11)] = inst_38638__$1);

(statearr_38874[(15)] = inst_38637);

return statearr_38874;
})();
var statearr_38875_38974 = state_38835__$1;
(statearr_38875_38974[(2)] = null);

(statearr_38875_38974[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (36))){
var inst_38828 = (state_38835[(2)]);
var state_38835__$1 = state_38835;
var statearr_38876_38975 = state_38835__$1;
(statearr_38876_38975[(2)] = inst_38828);

(statearr_38876_38975[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (41))){
var inst_38734 = cljs.core.count.call(null,clause);
var inst_38735 = cljs.core._EQ_.call(null,(3),inst_38734);
var state_38835__$1 = state_38835;
if(inst_38735){
var statearr_38877_38976 = state_38835__$1;
(statearr_38877_38976[(1)] = (44));

} else {
var statearr_38878_38977 = state_38835__$1;
(statearr_38878_38977[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (43))){
var inst_38726 = (state_38835[(20)]);
var inst_38729 = (state_38835[(2)]);
var inst_38730 = fluree.db.util.async.throw_err.call(null,inst_38729);
var inst_38731 = [inst_38730,r];
var inst_38732 = (new cljs.core.PersistentVector(null,2,(5),inst_38726,inst_38731,null));
var state_38835__$1 = state_38835;
var statearr_38879_38978 = state_38835__$1;
(statearr_38879_38978[(2)] = inst_38732);

(statearr_38879_38978[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (61))){
var inst_38785 = (state_38835[(7)]);
var inst_38788 = fluree.db.query.analytical.wikidata__GT_tuples.call(null,q_map,inst_38785,r,res,optional_QMARK_,fuel,max_fuel);
var state_38835__$1 = state_38835;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38835__$1,(64),inst_38788);
} else {
if((state_val_38836 === (29))){
var inst_38608 = (state_38835[(10)]);
var inst_38691 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38608)].join('');
var inst_38692 = (new Error(inst_38691));
var inst_38693 = (function(){throw inst_38692})();
var state_38835__$1 = state_38835;
var statearr_38880_38979 = state_38835__$1;
(statearr_38880_38979[(2)] = inst_38693);

(statearr_38880_38979[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (44))){
var inst_38737 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38738 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,db,res,clause,fuel,max_fuel);
var state_38835__$1 = (function (){var statearr_38881 = state_38835;
(statearr_38881[(21)] = inst_38737);

return statearr_38881;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38835__$1,(47),inst_38738);
} else {
if((state_val_38836 === (6))){
var inst_38608 = (state_38835[(10)]);
var inst_38612 = (state_38835[(14)]);
var inst_38607 = cljs.core.keys.call(null,clause);
var inst_38608__$1 = cljs.core.first.call(null,inst_38607);
var inst_38612__$1 = cljs.core._EQ_;
var inst_38613 = inst_38612__$1.call(null,new cljs.core.Keyword(null,"optional","optional",2053951509),inst_38608__$1);
var state_38835__$1 = (function (){var statearr_38882 = state_38835;
(statearr_38882[(10)] = inst_38608__$1);

(statearr_38882[(14)] = inst_38612__$1);

return statearr_38882;
})();
if(cljs.core.truth_(inst_38613)){
var statearr_38883_38980 = state_38835__$1;
(statearr_38883_38980[(1)] = (9));

} else {
var statearr_38884_38981 = state_38835__$1;
(statearr_38884_38981[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (28))){
var inst_38685 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38686 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_38687 = fluree.db.query.analytical.tuples__GT_filtered.call(null,res,inst_38686,optional_QMARK_);
var inst_38688 = [inst_38687,r];
var inst_38689 = (new cljs.core.PersistentVector(null,2,(5),inst_38685,inst_38688,null));
var state_38835__$1 = state_38835;
var statearr_38885_38982 = state_38835__$1;
(statearr_38885_38982[(2)] = inst_38689);

(statearr_38885_38982[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (64))){
var inst_38790 = (state_38835[(2)]);
var inst_38791 = fluree.db.util.async.throw_err.call(null,inst_38790);
var state_38835__$1 = state_38835;
var statearr_38886_38983 = state_38835__$1;
(statearr_38886_38983[(2)] = inst_38791);

(statearr_38886_38983[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (51))){
var inst_38757 = cljs.core.first.call(null,clause);
var inst_38758 = cljs.core.sequential_QMARK_.call(null,inst_38757);
var state_38835__$1 = state_38835;
if(inst_38758){
var statearr_38887_38984 = state_38835__$1;
(statearr_38887_38984[(1)] = (54));

} else {
var statearr_38888_38985 = state_38835__$1;
(statearr_38888_38985[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (25))){
var inst_38608 = (state_38835[(10)]);
var inst_38612 = (state_38835[(14)]);
var inst_38673 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_38674 = (function (){var segment_type = inst_38608;
var pred__38609 = inst_38612;
var expr__38610 = inst_38608;
var bindings = inst_38673;
return (function (p1__38594_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,p1__38594_SHARP_);
});
})();
var inst_38675 = cljs.core.map.call(null,inst_38674,inst_38673);
var inst_38676 = cljs.core.PersistentHashMap.EMPTY;
var inst_38677 = cljs.core.into.call(null,inst_38676,inst_38675);
var inst_38678 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38679 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_38677);
var inst_38680 = [inst_38679,r];
var inst_38681 = (new cljs.core.PersistentVector(null,2,(5),inst_38678,inst_38680,null));
var state_38835__$1 = state_38835;
var statearr_38889_38986 = state_38835__$1;
(statearr_38889_38986[(2)] = inst_38681);

(statearr_38889_38986[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (34))){
var inst_38712 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38713 = fluree.db.query.analytical.full_text__GT_tuples.call(null,db,res,clause);
var inst_38714 = [inst_38713,r];
var inst_38715 = (new cljs.core.PersistentVector(null,2,(5),inst_38712,inst_38714,null));
var state_38835__$1 = state_38835;
var statearr_38890_38987 = state_38835__$1;
(statearr_38890_38987[(2)] = inst_38715);

(statearr_38890_38987[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (17))){
var inst_38669 = (state_38835[(2)]);
var state_38835__$1 = state_38835;
var statearr_38891_38988 = state_38835__$1;
(statearr_38891_38988[(2)] = inst_38669);

(statearr_38891_38988[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (3))){
var inst_38833 = (state_38835[(2)]);
var state_38835__$1 = state_38835;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38835__$1,inst_38833);
} else {
if((state_val_38836 === (12))){
var inst_38615 = (state_38835[(22)]);
var inst_38619 = (state_38835[(2)]);
var inst_38620 = fluree.db.util.async.throw_err.call(null,inst_38619);
var inst_38621 = [inst_38620,r];
var inst_38622 = (new cljs.core.PersistentVector(null,2,(5),inst_38615,inst_38621,null));
var state_38835__$1 = state_38835;
var statearr_38892_38989 = state_38835__$1;
(statearr_38892_38989[(2)] = inst_38622);

(statearr_38892_38989[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (2))){
var _ = (function (){var statearr_38893 = state_38835;
(statearr_38893[(4)] = cljs.core.cons.call(null,(5),(state_38835[(4)])));

return statearr_38893;
})();
var inst_38605 = cljs.core.map_QMARK_.call(null,clause);
var state_38835__$1 = state_38835;
if(inst_38605){
var statearr_38894_38990 = state_38835__$1;
(statearr_38894_38990[(1)] = (6));

} else {
var statearr_38895_38991 = state_38835__$1;
(statearr_38895_38991[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (66))){
var state_38835__$1 = state_38835;
var statearr_38896_38992 = state_38835__$1;
(statearr_38896_38992[(1)] = (68));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (23))){
var inst_38654 = (state_38835[(19)]);
var inst_38645 = (state_38835[(16)]);
var inst_38637 = inst_38645;
var inst_38638 = inst_38654;
var state_38835__$1 = (function (){var statearr_38898 = state_38835;
(statearr_38898[(11)] = inst_38638);

(statearr_38898[(15)] = inst_38637);

return statearr_38898;
})();
var statearr_38899_38993 = state_38835__$1;
(statearr_38899_38993[(2)] = null);

(statearr_38899_38993[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (47))){
var inst_38737 = (state_38835[(21)]);
var inst_38740 = (state_38835[(2)]);
var inst_38741 = fluree.db.util.async.throw_err.call(null,inst_38740);
var inst_38742 = [inst_38741,r];
var inst_38743 = (new cljs.core.PersistentVector(null,2,(5),inst_38737,inst_38742,null));
var state_38835__$1 = state_38835;
var statearr_38900_38994 = state_38835__$1;
(statearr_38900_38994[(2)] = inst_38743);

(statearr_38900_38994[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (35))){
var inst_38718 = (state_38835[(23)]);
var inst_38717 = cljs.core.count.call(null,clause);
var inst_38718__$1 = cljs.core._EQ_.call(null,(3),inst_38717);
var state_38835__$1 = (function (){var statearr_38901 = state_38835;
(statearr_38901[(23)] = inst_38718__$1);

return statearr_38901;
})();
if(inst_38718__$1){
var statearr_38902_38995 = state_38835__$1;
(statearr_38902_38995[(1)] = (37));

} else {
var statearr_38903_38996 = state_38835__$1;
(statearr_38903_38996[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (19))){
var inst_38638 = (state_38835[(11)]);
var inst_38663 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38664 = [inst_38638,r];
var inst_38665 = (new cljs.core.PersistentVector(null,2,(5),inst_38663,inst_38664,null));
var state_38835__$1 = state_38835;
var statearr_38904_38997 = state_38835__$1;
(statearr_38904_38997[(2)] = inst_38665);

(statearr_38904_38997[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (57))){
var inst_38780 = fluree.db.query.analytical.get_source_clause.call(null,db,clause,prefixes,opts);
var state_38835__$1 = state_38835;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38835__$1,(60),inst_38780);
} else {
if((state_val_38836 === (68))){
var inst_38785 = (state_38835[(7)]);
var inst_38784 = (state_38835[(8)]);
var inst_38802 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38803 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,inst_38784,res,inst_38785,fuel,max_fuel);
var state_38835__$1 = (function (){var statearr_38905 = state_38835;
(statearr_38905[(24)] = inst_38802);

return statearr_38905;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38835__$1,(71),inst_38803);
} else {
if((state_val_38836 === (11))){
var inst_38701 = (state_38835[(2)]);
var state_38835__$1 = state_38835;
var statearr_38907_38998 = state_38835__$1;
(statearr_38907_38998[(2)] = inst_38701);

(statearr_38907_38998[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (9))){
var inst_38615 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38616 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_38617 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_38616,res,fuel,max_fuel,opts);
var state_38835__$1 = (function (){var statearr_38908 = state_38835;
(statearr_38908[(22)] = inst_38615);

return statearr_38908;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38835__$1,(12),inst_38617);
} else {
if((state_val_38836 === (5))){
var _ = (function (){var statearr_38909 = state_38835;
(statearr_38909[(4)] = cljs.core.rest.call(null,(state_38835[(4)])));

return statearr_38909;
})();
var state_38835__$1 = state_38835;
var ex38906 = (state_38835__$1[(2)]);
var statearr_38910_38999 = state_38835__$1;
(statearr_38910_38999[(5)] = ex38906);


if((ex38906 instanceof Error)){
var statearr_38911_39000 = state_38835__$1;
(statearr_38911_39000[(1)] = (4));

(statearr_38911_39000[(5)] = null);

} else {
throw ex38906;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (14))){
var inst_38608 = (state_38835[(10)]);
var inst_38612 = (state_38835[(14)]);
var inst_38671 = inst_38612.call(null,new cljs.core.Keyword(null,"bind","bind",-113428417),inst_38608);
var state_38835__$1 = state_38835;
if(cljs.core.truth_(inst_38671)){
var statearr_38912_39001 = state_38835__$1;
(statearr_38912_39001[(1)] = (25));

} else {
var statearr_38913_39002 = state_38835__$1;
(statearr_38913_39002[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (45))){
var inst_38745 = cljs.core.count.call(null,clause);
var inst_38746 = cljs.core._EQ_.call(null,(2),inst_38745);
var state_38835__$1 = state_38835;
if(inst_38746){
var statearr_38914_39003 = state_38835__$1;
(statearr_38914_39003[(1)] = (48));

} else {
var statearr_38915_39004 = state_38835__$1;
(statearr_38915_39004[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (53))){
var inst_38820 = (state_38835[(2)]);
var state_38835__$1 = state_38835;
var statearr_38916_39005 = state_38835__$1;
(statearr_38916_39005[(2)] = inst_38820);

(statearr_38916_39005[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (26))){
var inst_38608 = (state_38835[(10)]);
var inst_38612 = (state_38835[(14)]);
var inst_38683 = inst_38612.call(null,new cljs.core.Keyword(null,"filter","filter",-948537934),inst_38608);
var state_38835__$1 = state_38835;
if(cljs.core.truth_(inst_38683)){
var statearr_38917_39006 = state_38835__$1;
(statearr_38917_39006[(1)] = (28));

} else {
var statearr_38918_39007 = state_38835__$1;
(statearr_38918_39007[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (16))){
var inst_38644 = (state_38835[(12)]);
var inst_38637 = (state_38835[(15)]);
var inst_38643 = cljs.core.seq.call(null,inst_38637);
var inst_38644__$1 = cljs.core.first.call(null,inst_38643);
var inst_38645 = cljs.core.next.call(null,inst_38643);
var state_38835__$1 = (function (){var statearr_38919 = state_38835;
(statearr_38919[(12)] = inst_38644__$1);

(statearr_38919[(16)] = inst_38645);

return statearr_38919;
})();
if(cljs.core.truth_(inst_38644__$1)){
var statearr_38920_39008 = state_38835__$1;
(statearr_38920_39008[(1)] = (18));

} else {
var statearr_38921_39009 = state_38835__$1;
(statearr_38921_39009[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (38))){
var inst_38718 = (state_38835[(23)]);
var state_38835__$1 = state_38835;
var statearr_38922_39010 = state_38835__$1;
(statearr_38922_39010[(2)] = inst_38718);

(statearr_38922_39010[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (30))){
var inst_38695 = (state_38835[(2)]);
var state_38835__$1 = state_38835;
var statearr_38923_39011 = state_38835__$1;
(statearr_38923_39011[(2)] = inst_38695);

(statearr_38923_39011[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (10))){
var inst_38608 = (state_38835[(10)]);
var inst_38612 = (state_38835[(14)]);
var inst_38624 = inst_38612.call(null,new cljs.core.Keyword(null,"union","union",2142937499),inst_38608);
var state_38835__$1 = state_38835;
if(cljs.core.truth_(inst_38624)){
var statearr_38924_39012 = state_38835__$1;
(statearr_38924_39012[(1)] = (13));

} else {
var statearr_38925_39013 = state_38835__$1;
(statearr_38925_39013[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (18))){
var inst_38644 = (state_38835[(12)]);
var inst_38647 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_38644,q_map,vars,fuel,max_fuel,opts);
var state_38835__$1 = state_38835;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38835__$1,(21),inst_38647);
} else {
if((state_val_38836 === (52))){
var state_38835__$1 = state_38835;
var statearr_38926_39014 = state_38835__$1;
(statearr_38926_39014[(1)] = (57));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (67))){
var inst_38813 = (state_38835[(2)]);
var state_38835__$1 = state_38835;
var statearr_38928_39015 = state_38835__$1;
(statearr_38928_39015[(2)] = inst_38813);

(statearr_38928_39015[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (71))){
var inst_38802 = (state_38835[(24)]);
var inst_38805 = (state_38835[(2)]);
var inst_38806 = fluree.db.util.async.throw_err.call(null,inst_38805);
var inst_38807 = [inst_38806,r];
var inst_38808 = (new cljs.core.PersistentVector(null,2,(5),inst_38802,inst_38807,null));
var state_38835__$1 = state_38835;
var statearr_38929_39016 = state_38835__$1;
(statearr_38929_39016[(2)] = inst_38808);

(statearr_38929_39016[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (42))){
var inst_38826 = (state_38835[(2)]);
var state_38835__$1 = state_38835;
var statearr_38930_39017 = state_38835__$1;
(statearr_38930_39017[(2)] = inst_38826);

(statearr_38930_39017[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (37))){
var inst_38720 = cljs.core.second.call(null,clause);
var inst_38721 = cljs.core._EQ_.call(null,inst_38720,"rdf:type");
var state_38835__$1 = state_38835;
var statearr_38931_39018 = state_38835__$1;
(statearr_38931_39018[(2)] = inst_38721);

(statearr_38931_39018[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (63))){
var inst_38815 = (state_38835[(2)]);
var state_38835__$1 = state_38835;
var statearr_38932_39019 = state_38835__$1;
(statearr_38932_39019[(2)] = inst_38815);

(statearr_38932_39019[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (8))){
var inst_38830 = (state_38835[(2)]);
var _ = (function (){var statearr_38933 = state_38835;
(statearr_38933[(4)] = cljs.core.rest.call(null,(state_38835[(4)])));

return statearr_38933;
})();
var state_38835__$1 = state_38835;
var statearr_38934_39020 = state_38835__$1;
(statearr_38934_39020[(2)] = inst_38830);

(statearr_38934_39020[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38836 === (49))){
var inst_38754 = cljs.core.count.call(null,clause);
var inst_38755 = cljs.core._EQ_.call(null,(1),inst_38754);
var state_38835__$1 = state_38835;
if(inst_38755){
var statearr_38935_39021 = state_38835__$1;
(statearr_38935_39021[(1)] = (51));

} else {
var statearr_38936_39022 = state_38835__$1;
(statearr_38936_39022[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16221__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16221__auto____0 = (function (){
var statearr_38937 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38937[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16221__auto__);

(statearr_38937[(1)] = (1));

return statearr_38937;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16221__auto____1 = (function (state_38835){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_38835);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e38938){var ex__16224__auto__ = e38938;
var statearr_38939_39023 = state_38835;
(statearr_38939_39023[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_38835[(4)]))){
var statearr_38940_39024 = state_38835;
(statearr_38940_39024[(1)] = cljs.core.first.call(null,(state_38835[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39025 = state_38835;
state_38835 = G__39025;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16221__auto__ = function(state_38835){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16221__auto____1.call(this,state_38835);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16221__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16221__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_38941 = f__16346__auto__.call(null);
(statearr_38941[(6)] = c__16345__auto__);

return statearr_38941;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__39027 = arguments.length;
switch (G__39027) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.call(null,db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_39107){
var state_val_39108 = (state_39107[(1)]);
if((state_val_39108 === (7))){
var inst_39102 = (state_39107[(2)]);
var _ = (function (){var statearr_39109 = state_39107;
(statearr_39109[(4)] = cljs.core.rest.call(null,(state_39107[(4)])));

return statearr_39109;
})();
var state_39107__$1 = state_39107;
var statearr_39110_39158 = state_39107__$1;
(statearr_39110_39158[(2)] = inst_39102);

(statearr_39110_39158[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39108 === (20))){
var inst_39067 = (state_39107[(7)]);
var inst_39079 = (state_39107[(2)]);
var inst_39049 = inst_39067;
var inst_39050 = inst_39079;
var state_39107__$1 = (function (){var statearr_39111 = state_39107;
(statearr_39111[(8)] = inst_39049);

(statearr_39111[(9)] = inst_39050);

return statearr_39111;
})();
var statearr_39112_39159 = state_39107__$1;
(statearr_39112_39159[(2)] = null);

(statearr_39112_39159[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39108 === (1))){
var state_39107__$1 = state_39107;
var statearr_39113_39160 = state_39107__$1;
(statearr_39113_39160[(2)] = null);

(statearr_39113_39160[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39108 === (24))){
var inst_39066 = (state_39107[(10)]);
var inst_39067 = (state_39107[(7)]);
var inst_39050 = (state_39107[(9)]);
var inst_39087 = fluree.db.query.analytical.inner_join.call(null,inst_39050,inst_39066);
var inst_39049 = inst_39067;
var inst_39050__$1 = inst_39087;
var state_39107__$1 = (function (){var statearr_39114 = state_39107;
(statearr_39114[(8)] = inst_39049);

(statearr_39114[(9)] = inst_39050__$1);

return statearr_39114;
})();
var statearr_39115_39161 = state_39107__$1;
(statearr_39115_39161[(2)] = null);

(statearr_39115_39161[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39108 === (4))){
var inst_39028 = (state_39107[(2)]);
var state_39107__$1 = state_39107;
var statearr_39117_39162 = state_39107__$1;
(statearr_39117_39162[(2)] = inst_39028);

(statearr_39117_39162[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39108 === (15))){
var inst_39066 = (state_39107[(10)]);
var state_39107__$1 = state_39107;
if(cljs.core.truth_(inst_39066)){
var statearr_39118_39163 = state_39107__$1;
(statearr_39118_39163[(1)] = (18));

} else {
var statearr_39119_39164 = state_39107__$1;
(statearr_39119_39164[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39108 === (21))){
var inst_39067 = (state_39107[(7)]);
var inst_39050 = (state_39107[(9)]);
var tmp39116 = inst_39050;
var inst_39049 = inst_39067;
var inst_39050__$1 = tmp39116;
var state_39107__$1 = (function (){var statearr_39120 = state_39107;
(statearr_39120[(8)] = inst_39049);

(statearr_39120[(9)] = inst_39050__$1);

return statearr_39120;
})();
var statearr_39121_39165 = state_39107__$1;
(statearr_39121_39165[(2)] = null);

(statearr_39121_39165[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39108 === (13))){
var inst_39050 = (state_39107[(9)]);
var inst_39073 = cljs.core.dissoc.call(null,inst_39050,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_39074 = cljs.core.empty_QMARK_.call(null,inst_39073);
var state_39107__$1 = state_39107;
if(inst_39074){
var statearr_39122_39166 = state_39107__$1;
(statearr_39122_39166[(1)] = (15));

} else {
var statearr_39123_39167 = state_39107__$1;
(statearr_39123_39167[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39108 === (22))){
var state_39107__$1 = state_39107;
var statearr_39124_39168 = state_39107__$1;
(statearr_39124_39168[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39108 === (6))){
var inst_39049 = (state_39107[(8)]);
var inst_39056 = (state_39107[(11)]);
var inst_39055 = cljs.core.seq.call(null,inst_39049);
var inst_39056__$1 = cljs.core.first.call(null,inst_39055);
var inst_39057 = cljs.core.next.call(null,inst_39055);
var state_39107__$1 = (function (){var statearr_39126 = state_39107;
(statearr_39126[(11)] = inst_39056__$1);

(statearr_39126[(12)] = inst_39057);

return statearr_39126;
})();
if(cljs.core.truth_(inst_39056__$1)){
var statearr_39127_39169 = state_39107__$1;
(statearr_39127_39169[(1)] = (8));

} else {
var statearr_39128_39170 = state_39107__$1;
(statearr_39128_39170[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39108 === (25))){
var state_39107__$1 = state_39107;
var statearr_39129_39171 = state_39107__$1;
(statearr_39129_39171[(2)] = null);

(statearr_39129_39171[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39108 === (17))){
var inst_39095 = (state_39107[(2)]);
var state_39107__$1 = state_39107;
var statearr_39130_39172 = state_39107__$1;
(statearr_39130_39172[(2)] = inst_39095);

(statearr_39130_39172[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39108 === (3))){
var inst_39105 = (state_39107[(2)]);
var state_39107__$1 = state_39107;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39107__$1,inst_39105);
} else {
if((state_val_39108 === (12))){
var inst_39066 = (state_39107[(10)]);
var inst_39067 = (state_39107[(7)]);
var inst_39049 = inst_39067;
var inst_39050 = inst_39066;
var state_39107__$1 = (function (){var statearr_39131 = state_39107;
(statearr_39131[(8)] = inst_39049);

(statearr_39131[(9)] = inst_39050);

return statearr_39131;
})();
var statearr_39132_39173 = state_39107__$1;
(statearr_39132_39173[(2)] = null);

(statearr_39132_39173[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39108 === (2))){
var _ = (function (){var statearr_39133 = state_39107;
(statearr_39133[(4)] = cljs.core.cons.call(null,(5),(state_39107[(4)])));

return statearr_39133;
})();
var inst_39041 = where;
var inst_39042 = cljs.core.seq.call(null,inst_39041);
var inst_39043 = cljs.core.first.call(null,inst_39042);
var inst_39044 = cljs.core.next.call(null,inst_39042);
var inst_39045 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_39046 = fluree.db.query.analytical.symbolize_keys.call(null,vars);
var inst_39047 = [inst_39046];
var inst_39048 = cljs.core.PersistentHashMap.fromArrays(inst_39045,inst_39047);
var inst_39049 = inst_39041;
var inst_39050 = inst_39048;
var state_39107__$1 = (function (){var statearr_39134 = state_39107;
(statearr_39134[(8)] = inst_39049);

(statearr_39134[(13)] = inst_39043);

(statearr_39134[(9)] = inst_39050);

(statearr_39134[(14)] = inst_39044);

return statearr_39134;
})();
var statearr_39135_39174 = state_39107__$1;
(statearr_39135_39174[(2)] = null);

(statearr_39135_39174[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39108 === (23))){
var inst_39093 = (state_39107[(2)]);
var state_39107__$1 = state_39107;
var statearr_39136_39175 = state_39107__$1;
(statearr_39136_39175[(2)] = inst_39093);

(statearr_39136_39175[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39108 === (19))){
var inst_39050 = (state_39107[(9)]);
var state_39107__$1 = state_39107;
var statearr_39137_39176 = state_39107__$1;
(statearr_39137_39176[(2)] = inst_39050);

(statearr_39137_39176[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39108 === (11))){
var inst_39056 = (state_39107[(11)]);
var inst_39064 = (state_39107[(2)]);
var inst_39065 = fluree.db.util.async.throw_err.call(null,inst_39064);
var inst_39066 = cljs.core.nth.call(null,inst_39065,(0),null);
var inst_39067 = cljs.core.nth.call(null,inst_39065,(1),null);
var inst_39068 = cljs.core.count.call(null,inst_39056);
var inst_39069 = cljs.core._EQ_.call(null,(2),inst_39068);
var state_39107__$1 = (function (){var statearr_39139 = state_39107;
(statearr_39139[(10)] = inst_39066);

(statearr_39139[(7)] = inst_39067);

return statearr_39139;
})();
if(inst_39069){
var statearr_39140_39177 = state_39107__$1;
(statearr_39140_39177[(1)] = (12));

} else {
var statearr_39141_39178 = state_39107__$1;
(statearr_39141_39178[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39108 === (9))){
var inst_39050 = (state_39107[(9)]);
var state_39107__$1 = state_39107;
var statearr_39142_39179 = state_39107__$1;
(statearr_39142_39179[(2)] = inst_39050);

(statearr_39142_39179[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39108 === (5))){
var _ = (function (){var statearr_39143 = state_39107;
(statearr_39143[(4)] = cljs.core.rest.call(null,(state_39107[(4)])));

return statearr_39143;
})();
var state_39107__$1 = state_39107;
var ex39138 = (state_39107__$1[(2)]);
var statearr_39144_39180 = state_39107__$1;
(statearr_39144_39180[(5)] = ex39138);


if((ex39138 instanceof Error)){
var statearr_39145_39181 = state_39107__$1;
(statearr_39145_39181[(1)] = (4));

(statearr_39145_39181[(5)] = null);

} else {
throw ex39138;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39108 === (14))){
var inst_39097 = (state_39107[(2)]);
var state_39107__$1 = state_39107;
var statearr_39146_39182 = state_39107__$1;
(statearr_39146_39182[(2)] = inst_39097);

(statearr_39146_39182[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39108 === (26))){
var inst_39091 = (state_39107[(2)]);
var state_39107__$1 = state_39107;
var statearr_39147_39183 = state_39107__$1;
(statearr_39147_39183[(2)] = inst_39091);

(statearr_39147_39183[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39108 === (16))){
var inst_39066 = (state_39107[(10)]);
var inst_39082 = (inst_39066 == null);
var state_39107__$1 = state_39107;
if(cljs.core.truth_(inst_39082)){
var statearr_39148_39184 = state_39107__$1;
(statearr_39148_39184[(1)] = (21));

} else {
var statearr_39149_39185 = state_39107__$1;
(statearr_39149_39185[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39108 === (10))){
var inst_39100 = (state_39107[(2)]);
var state_39107__$1 = state_39107;
var statearr_39150_39186 = state_39107__$1;
(statearr_39150_39186[(2)] = inst_39100);

(statearr_39150_39186[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39108 === (18))){
var inst_39066 = (state_39107[(10)]);
var state_39107__$1 = state_39107;
var statearr_39151_39187 = state_39107__$1;
(statearr_39151_39187[(2)] = inst_39066);

(statearr_39151_39187[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39108 === (8))){
var inst_39056 = (state_39107[(11)]);
var inst_39057 = (state_39107[(12)]);
var inst_39050 = (state_39107[(9)]);
var inst_39062 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_39050,inst_39056,inst_39057,false,fuel,max_fuel,opts);
var state_39107__$1 = state_39107;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39107__$1,(11),inst_39062);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__16221__auto__ = null;
var fluree$db$query$analytical$state_machine__16221__auto____0 = (function (){
var statearr_39152 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39152[(0)] = fluree$db$query$analytical$state_machine__16221__auto__);

(statearr_39152[(1)] = (1));

return statearr_39152;
});
var fluree$db$query$analytical$state_machine__16221__auto____1 = (function (state_39107){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_39107);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e39153){var ex__16224__auto__ = e39153;
var statearr_39154_39188 = state_39107;
(statearr_39154_39188[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_39107[(4)]))){
var statearr_39155_39189 = state_39107;
(statearr_39155_39189[(1)] = cljs.core.first.call(null,(state_39107[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39190 = state_39107;
state_39107 = G__39190;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__16221__auto__ = function(state_39107){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__16221__auto____1.call(this,state_39107);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__16221__auto____0;
fluree$db$query$analytical$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__16221__auto____1;
return fluree$db$query$analytical$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_39156 = f__16346__auto__.call(null);
(statearr_39156[(6)] = c__16345__auto__);

return statearr_39156;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_39225){
var state_val_39226 = (state_39225[(1)]);
if((state_val_39226 === (7))){
var inst_39202 = (state_39225[(7)]);
var inst_39207 = (state_39225[(8)]);
var inst_39209 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_39202,inst_39207,fuel,max_fuel,opts);
var state_39225__$1 = state_39225;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39225__$1,(10),inst_39209);
} else {
if((state_val_39226 === (1))){
var state_39225__$1 = state_39225;
var statearr_39227_39252 = state_39225__$1;
(statearr_39227_39252[(2)] = null);

(statearr_39227_39252[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39226 === (4))){
var inst_39191 = (state_39225[(2)]);
var state_39225__$1 = state_39225;
var statearr_39228_39253 = state_39225__$1;
(statearr_39228_39253[(2)] = inst_39191);

(statearr_39228_39253[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39226 === (13))){
var inst_39220 = (state_39225[(2)]);
var _ = (function (){var statearr_39229 = state_39225;
(statearr_39229[(4)] = cljs.core.rest.call(null,(state_39225[(4)])));

return statearr_39229;
})();
var state_39225__$1 = state_39225;
var statearr_39230_39254 = state_39225__$1;
(statearr_39230_39254[(2)] = inst_39220);

(statearr_39230_39254[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39226 === (6))){
var inst_39202 = (state_39225[(7)]);
var inst_39206 = (state_39225[(2)]);
var inst_39207 = fluree.db.util.async.throw_err.call(null,inst_39206);
var state_39225__$1 = (function (){var statearr_39231 = state_39225;
(statearr_39231[(8)] = inst_39207);

return statearr_39231;
})();
if(cljs.core.truth_(inst_39202)){
var statearr_39232_39255 = state_39225__$1;
(statearr_39232_39255[(1)] = (7));

} else {
var statearr_39233_39256 = state_39225__$1;
(statearr_39233_39256[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39226 === (3))){
var inst_39223 = (state_39225[(2)]);
var state_39225__$1 = state_39225;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39225__$1,inst_39223);
} else {
if((state_val_39226 === (12))){
var inst_39215 = (state_39225[(9)]);
var state_39225__$1 = state_39225;
var statearr_39234_39257 = state_39225__$1;
(statearr_39234_39257[(2)] = inst_39215);

(statearr_39234_39257[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39226 === (2))){
var _ = (function (){var statearr_39235 = state_39225;
(statearr_39235[(4)] = cljs.core.cons.call(null,(5),(state_39225[(4)])));

return statearr_39235;
})();
var inst_39198 = q_map;
var inst_39199 = cljs.core.__destructure_map.call(null,inst_39198);
var inst_39200 = cljs.core.get.call(null,inst_39199,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_39201 = cljs.core.get.call(null,inst_39199,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_39202 = cljs.core.get.call(null,inst_39199,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_39203 = cljs.core.get.call(null,inst_39199,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_39204 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_39201,q_map,inst_39200,fuel,max_fuel,opts);
var state_39225__$1 = (function (){var statearr_39236 = state_39225;
(statearr_39236[(10)] = inst_39203);

(statearr_39236[(7)] = inst_39202);

return statearr_39236;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39225__$1,(6),inst_39204);
} else {
if((state_val_39226 === (11))){
var inst_39203 = (state_39225[(10)]);
var inst_39215 = (state_39225[(9)]);
var inst_39217 = fluree.db.query.analytical.tuples__GT_filtered.call(null,inst_39215,inst_39203,null);
var state_39225__$1 = state_39225;
var statearr_39238_39258 = state_39225__$1;
(statearr_39238_39258[(2)] = inst_39217);

(statearr_39238_39258[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39226 === (9))){
var inst_39203 = (state_39225[(10)]);
var inst_39215 = (state_39225[(2)]);
var state_39225__$1 = (function (){var statearr_39239 = state_39225;
(statearr_39239[(9)] = inst_39215);

return statearr_39239;
})();
if(cljs.core.truth_(inst_39203)){
var statearr_39240_39259 = state_39225__$1;
(statearr_39240_39259[(1)] = (11));

} else {
var statearr_39241_39260 = state_39225__$1;
(statearr_39241_39260[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39226 === (5))){
var _ = (function (){var statearr_39242 = state_39225;
(statearr_39242[(4)] = cljs.core.rest.call(null,(state_39225[(4)])));

return statearr_39242;
})();
var state_39225__$1 = state_39225;
var ex39237 = (state_39225__$1[(2)]);
var statearr_39243_39261 = state_39225__$1;
(statearr_39243_39261[(5)] = ex39237);


if((ex39237 instanceof Error)){
var statearr_39244_39262 = state_39225__$1;
(statearr_39244_39262[(1)] = (4));

(statearr_39244_39262[(5)] = null);

} else {
throw ex39237;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39226 === (10))){
var inst_39211 = (state_39225[(2)]);
var inst_39212 = fluree.db.util.async.throw_err.call(null,inst_39211);
var state_39225__$1 = state_39225;
var statearr_39245_39263 = state_39225__$1;
(statearr_39245_39263[(2)] = inst_39212);

(statearr_39245_39263[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39226 === (8))){
var inst_39207 = (state_39225[(8)]);
var state_39225__$1 = state_39225;
var statearr_39246_39264 = state_39225__$1;
(statearr_39246_39264[(2)] = inst_39207);

(statearr_39246_39264[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__16221__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__16221__auto____0 = (function (){
var statearr_39247 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_39247[(0)] = fluree$db$query$analytical$q_$_state_machine__16221__auto__);

(statearr_39247[(1)] = (1));

return statearr_39247;
});
var fluree$db$query$analytical$q_$_state_machine__16221__auto____1 = (function (state_39225){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_39225);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e39248){var ex__16224__auto__ = e39248;
var statearr_39249_39265 = state_39225;
(statearr_39249_39265[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_39225[(4)]))){
var statearr_39250_39266 = state_39225;
(statearr_39250_39266[(1)] = cljs.core.first.call(null,(state_39225[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39267 = state_39225;
state_39225 = G__39267;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__16221__auto__ = function(state_39225){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__16221__auto____1.call(this,state_39225);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__16221__auto____0;
fluree$db$query$analytical$q_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__16221__auto____1;
return fluree$db$query$analytical$q_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_39251 = f__16346__auto__.call(null);
(statearr_39251[(6)] = c__16345__auto__);

return statearr_39251;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
