// Compiled by ClojureScript 1.10.879 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__36146 = arguments.length;
switch (G__36146) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.call(null,operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid.call(null));
var header = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"op","op",-1882987955),operation,new cljs.core.Keyword(null,"req-id","req-id",-471642231),req_id,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),fluree.db.util.core.current_time_millis.call(null),new cljs.core.Keyword(null,"timeout","timeout",-318625318),timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__36149 = arguments.length;
switch (G__36149) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.call(null,conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__16345__auto___36202 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_36180){
var state_val_36181 = (state_36180[(1)]);
if((state_val_36181 === (1))){
var state_36180__$1 = state_36180;
var statearr_36182_36203 = state_36180__$1;
(statearr_36182_36203[(2)] = null);

(statearr_36182_36203[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36181 === (2))){
var _ = (function (){var statearr_36183 = state_36180;
(statearr_36183[(4)] = cljs.core.cons.call(null,(5),(state_36180[(4)])));

return statearr_36183;
})();
var inst_36157 = fluree.db.operations.conn_closed_QMARK_.call(null,conn);
var state_36180__$1 = state_36180;
if(cljs.core.truth_(inst_36157)){
var statearr_36184_36204 = state_36180__$1;
(statearr_36184_36204[(1)] = (6));

} else {
var statearr_36185_36205 = state_36180__$1;
(statearr_36185_36205[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36181 === (3))){
var inst_36178 = (state_36180[(2)]);
var state_36180__$1 = state_36180;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36180__$1,inst_36178);
} else {
if((state_val_36181 === (4))){
var inst_36150 = (state_36180[(2)]);
var inst_36151 = cljs.core.async.put_BANG_.call(null,pc,inst_36150);
var state_36180__$1 = state_36180;
var statearr_36187_36206 = state_36180__$1;
(statearr_36187_36206[(2)] = inst_36151);

(statearr_36187_36206[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36181 === (5))){
var _ = (function (){var statearr_36188 = state_36180;
(statearr_36188[(4)] = cljs.core.rest.call(null,(state_36180[(4)])));

return statearr_36188;
})();
var state_36180__$1 = state_36180;
var ex36186 = (state_36180__$1[(2)]);
var statearr_36189_36207 = state_36180__$1;
(statearr_36189_36207[(5)] = ex36186);


var statearr_36190_36208 = state_36180__$1;
(statearr_36190_36208[(1)] = (4));

(statearr_36190_36208[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36181 === (6))){
var inst_36159 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_36160 = [(400),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)];
var inst_36161 = cljs.core.PersistentHashMap.fromArrays(inst_36159,inst_36160);
var inst_36162 = cljs.core.ex_info.call(null,"Connection was closed.",inst_36161);
var inst_36163 = (function(){throw inst_36162})();
var state_36180__$1 = state_36180;
var statearr_36191_36209 = state_36180__$1;
(statearr_36191_36209[(2)] = inst_36163);

(statearr_36191_36209[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36181 === (7))){
var inst_36165 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_36166 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36167 = [operation,data,pc,opts];
var inst_36168 = (new cljs.core.PersistentVector(null,4,(5),inst_36166,inst_36167,null));
var inst_36169 = cljs.core.async.put_BANG_.call(null,inst_36165,inst_36168);
var inst_36170 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36171 = [operation,data,pc,opts];
var inst_36172 = (new cljs.core.PersistentVector(null,4,(5),inst_36170,inst_36171,null));
var inst_36173 = fluree.db.util.log.trace.call(null,"Put operation on connection req-chan: ",inst_36172);
var state_36180__$1 = (function (){var statearr_36192 = state_36180;
(statearr_36192[(7)] = inst_36169);

return statearr_36192;
})();
var statearr_36193_36210 = state_36180__$1;
(statearr_36193_36210[(2)] = inst_36173);

(statearr_36193_36210[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36181 === (8))){
var inst_36175 = (state_36180[(2)]);
var _ = (function (){var statearr_36194 = state_36180;
(statearr_36194[(4)] = cljs.core.rest.call(null,(state_36180[(4)])));

return statearr_36194;
})();
var state_36180__$1 = state_36180;
var statearr_36195_36211 = state_36180__$1;
(statearr_36195_36211[(2)] = inst_36175);

(statearr_36195_36211[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__16221__auto__ = null;
var fluree$db$operations$state_machine__16221__auto____0 = (function (){
var statearr_36196 = [null,null,null,null,null,null,null,null];
(statearr_36196[(0)] = fluree$db$operations$state_machine__16221__auto__);

(statearr_36196[(1)] = (1));

return statearr_36196;
});
var fluree$db$operations$state_machine__16221__auto____1 = (function (state_36180){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_36180);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e36197){var ex__16224__auto__ = e36197;
var statearr_36198_36212 = state_36180;
(statearr_36198_36212[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_36180[(4)]))){
var statearr_36199_36213 = state_36180;
(statearr_36199_36213[(1)] = cljs.core.first.call(null,(state_36180[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36214 = state_36180;
state_36180 = G__36214;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$operations$state_machine__16221__auto__ = function(state_36180){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__16221__auto____1.call(this,state_36180);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__16221__auto____0;
fluree$db$operations$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__16221__auto____1;
return fluree$db$operations$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_36200 = f__16346__auto__.call(null);
(statearr_36200[(6)] = c__16345__auto___36202);

return statearr_36200;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__36216 = arguments.length;
switch (G__36216) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.call(null,session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__36217){
var map__36218 = p__36217;
var map__36218__$1 = cljs.core.__destructure_map.call(null,map__36218);
var opts = map__36218__$1;
var snapshot_QMARK_ = cljs.core.get.call(null,map__36218__$1,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670));
var map__36219 = session;
var map__36219__$1 = cljs.core.__destructure_map.call(null,map__36219);
var dbid = cljs.core.get.call(null,map__36219__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var network = cljs.core.get.call(null,map__36219__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.call(null,map__36219__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"delete-db","delete-db",1646085839),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670),snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4824__auto__ = [];
var len__4818__auto___36246 = arguments.length;
var i__4819__auto___36247 = (0);
while(true){
if((i__4819__auto___36247 < len__4818__auto___36246)){
args__4824__auto__.push((arguments[i__4819__auto___36247]));

var G__36248 = (i__4819__auto___36247 + (1));
i__4819__auto___36247 = G__36248;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__36223){
var vec__36224 = p__36223;
var map__36227 = cljs.core.nth.call(null,vec__36224,(0),null);
var map__36227__$1 = cljs.core.__destructure_map.call(null,map__36227);
var toBlock = cljs.core.get.call(null,map__36227__$1,new cljs.core.Keyword(null,"toBlock","toBlock",1609458185));
var toTime = cljs.core.get.call(null,map__36227__$1,new cljs.core.Keyword(null,"toTime","toTime",903224641));
var opts = vec__36224;
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_36239){
var state_val_36240 = (state_36239[(1)]);
if((state_val_36240 === (1))){
var inst_36229 = session;
var inst_36230 = cljs.core.__destructure_map.call(null,inst_36229);
var inst_36231 = cljs.core.get.call(null,inst_36230,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_36232 = cljs.core.get.call(null,inst_36230,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_36233 = cljs.core.get.call(null,inst_36230,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_36234 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"toBlock","toBlock",1609458185),new cljs.core.Keyword(null,"toTime","toTime",903224641)];
var inst_36235 = [inst_36231,inst_36232,toBlock,toTime];
var inst_36236 = cljs.core.PersistentHashMap.fromArrays(inst_36234,inst_36235);
var inst_36237 = fluree.db.operations.send_operation.call(null,inst_36233,new cljs.core.Keyword(null,"garbage","garbage",-2063107600),inst_36236);
var state_36239__$1 = state_36239;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36239__$1,inst_36237);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__16221__auto__ = null;
var fluree$db$operations$state_machine__16221__auto____0 = (function (){
var statearr_36241 = [null,null,null,null,null,null,null];
(statearr_36241[(0)] = fluree$db$operations$state_machine__16221__auto__);

(statearr_36241[(1)] = (1));

return statearr_36241;
});
var fluree$db$operations$state_machine__16221__auto____1 = (function (state_36239){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_36239);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e36242){var ex__16224__auto__ = e36242;
var statearr_36243_36249 = state_36239;
(statearr_36243_36249[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_36239[(4)]))){
var statearr_36244_36250 = state_36239;
(statearr_36244_36250[(1)] = cljs.core.first.call(null,(state_36239[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36251 = state_36239;
state_36239 = G__36251;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$operations$state_machine__16221__auto__ = function(state_36239){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__16221__auto____1.call(this,state_36239);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__16221__auto____0;
fluree$db$operations$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__16221__auto____1;
return fluree$db$operations$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_36245 = f__16346__auto__.call(null);
(statearr_36245[(6)] = c__16345__auto__);

return statearr_36245;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq36221){
var G__36222 = cljs.core.first.call(null,seq36221);
var seq36221__$1 = cljs.core.next.call(null,seq36221);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__36222,seq36221__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__36252 = session;
var map__36252__$1 = cljs.core.__destructure_map.call(null,map__36252);
var network = cljs.core.get.call(null,map__36252__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__36252__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var conn = cljs.core.get.call(null,map__36252__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"snapshot-db","snapshot-db",199417128),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"unsigned-cmd","unsigned-cmd",1466012010),unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-stats","ledger-stats",765646297),ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"db-list","db-list",230589843),null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.call(null,"Sending transaction async: ",tx_map);

return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"tx","tx",466630418),tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__36254 = arguments.length;
switch (G__36254) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.call(null,session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__36255 = opts;
var map__36255__$1 = cljs.core.__destructure_map.call(null,map__36255);
var auth = cljs.core.get.call(null,map__36255__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.call(null,map__36255__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4212__auto__ = auth;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.call(null,"Subscribe to: ",new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt);
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"subscribe","subscribe",416253756),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"unsbuscribe","unsbuscribe",888593047),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null));
});
