// Compiled by ClojureScript 1.10.879 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4867__auto___70593 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null)))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_70644){
var state_val_70645 = (state_70644[(1)]);
if((state_val_70645 === (7))){
var inst_70639 = (state_70644[(2)]);
var _ = (function (){var statearr_70646 = state_70644;
(statearr_70646[(4)] = cljs.core.rest.call(null,(state_70644[(4)])));

return statearr_70646;
})();
var state_70644__$1 = state_70644;
var statearr_70647_70674 = state_70644__$1;
(statearr_70647_70674[(2)] = inst_70639);

(statearr_70647_70674[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70645 === (1))){
var state_70644__$1 = state_70644;
var statearr_70648_70675 = state_70644__$1;
(statearr_70648_70675[(2)] = null);

(statearr_70648_70675[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70645 === (4))){
var inst_70594 = (state_70644[(2)]);
var state_70644__$1 = state_70644;
var statearr_70649_70676 = state_70644__$1;
(statearr_70649_70676[(2)] = inst_70594);

(statearr_70649_70676[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70645 === (13))){
var inst_70635 = (state_70644[(2)]);
var state_70644__$1 = state_70644;
var statearr_70650_70677 = state_70644__$1;
(statearr_70650_70677[(2)] = inst_70635);

(statearr_70650_70677[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70645 === (6))){
var inst_70612 = (state_70644[(7)]);
var inst_70619 = (state_70644[(8)]);
var inst_70618 = cljs.core.seq.call(null,inst_70612);
var inst_70619__$1 = cljs.core.first.call(null,inst_70618);
var inst_70620 = cljs.core.next.call(null,inst_70618);
var inst_70621 = cljs.core.not.call(null,inst_70619__$1);
var state_70644__$1 = (function (){var statearr_70651 = state_70644;
(statearr_70651[(9)] = inst_70620);

(statearr_70651[(8)] = inst_70619__$1);

return statearr_70651;
})();
if(inst_70621){
var statearr_70652_70678 = state_70644__$1;
(statearr_70652_70678[(1)] = (8));

} else {
var statearr_70653_70679 = state_70644__$1;
(statearr_70653_70679[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70645 === (3))){
var inst_70642 = (state_70644[(2)]);
var state_70644__$1 = state_70644;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70644__$1,inst_70642);
} else {
if((state_val_70645 === (12))){
var inst_70620 = (state_70644[(9)]);
var inst_70613 = (state_70644[(10)]);
var inst_70619 = (state_70644[(8)]);
var inst_70632 = cljs.core.conj.call(null,inst_70613,inst_70619);
var inst_70612 = inst_70620;
var inst_70613__$1 = inst_70632;
var state_70644__$1 = (function (){var statearr_70654 = state_70644;
(statearr_70654[(10)] = inst_70613__$1);

(statearr_70654[(7)] = inst_70612);

return statearr_70654;
})();
var statearr_70655_70680 = state_70644__$1;
(statearr_70655_70680[(2)] = null);

(statearr_70655_70680[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70645 === (2))){
var _ = (function (){var statearr_70656 = state_70644;
(statearr_70656[(4)] = cljs.core.cons.call(null,(5),(state_70644[(4)])));

return statearr_70656;
})();
var inst_70607 = args;
var inst_70608 = cljs.core.seq.call(null,inst_70607);
var inst_70609 = cljs.core.first.call(null,inst_70608);
var inst_70610 = cljs.core.next.call(null,inst_70608);
var inst_70611 = cljs.core.PersistentVector.EMPTY;
var inst_70612 = inst_70607;
var inst_70613 = inst_70611;
var state_70644__$1 = (function (){var statearr_70657 = state_70644;
(statearr_70657[(10)] = inst_70613);

(statearr_70657[(7)] = inst_70612);

(statearr_70657[(11)] = inst_70610);

(statearr_70657[(12)] = inst_70609);

return statearr_70657;
})();
var statearr_70658_70681 = state_70644__$1;
(statearr_70658_70681[(2)] = null);

(statearr_70658_70681[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70645 === (11))){
var inst_70619 = (state_70644[(8)]);
var state_70644__$1 = state_70644;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70644__$1,(14),inst_70619);
} else {
if((state_val_70645 === (9))){
var inst_70619 = (state_70644[(8)]);
var inst_70624 = fluree.db.util.async.channel_QMARK_.call(null,inst_70619);
var state_70644__$1 = state_70644;
if(inst_70624){
var statearr_70660_70682 = state_70644__$1;
(statearr_70660_70682[(1)] = (11));

} else {
var statearr_70661_70683 = state_70644__$1;
(statearr_70661_70683[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70645 === (5))){
var _ = (function (){var statearr_70662 = state_70644;
(statearr_70662[(4)] = cljs.core.rest.call(null,(state_70644[(4)])));

return statearr_70662;
})();
var state_70644__$1 = state_70644;
var ex70659 = (state_70644__$1[(2)]);
var statearr_70663_70684 = state_70644__$1;
(statearr_70663_70684[(5)] = ex70659);


if((ex70659 instanceof Error)){
var statearr_70664_70685 = state_70644__$1;
(statearr_70664_70685[(1)] = (4));

(statearr_70664_70685[(5)] = null);

} else {
throw ex70659;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70645 === (14))){
var inst_70620 = (state_70644[(9)]);
var inst_70613 = (state_70644[(10)]);
var inst_70627 = (state_70644[(2)]);
var inst_70628 = fluree.db.util.async.throw_err.call(null,inst_70627);
var inst_70629 = cljs.core.conj.call(null,inst_70613,inst_70628);
var inst_70612 = inst_70620;
var inst_70613__$1 = inst_70629;
var state_70644__$1 = (function (){var statearr_70665 = state_70644;
(statearr_70665[(10)] = inst_70613__$1);

(statearr_70665[(7)] = inst_70612);

return statearr_70665;
})();
var statearr_70666_70686 = state_70644__$1;
(statearr_70666_70686[(2)] = null);

(statearr_70666_70686[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70645 === (10))){
var inst_70637 = (state_70644[(2)]);
var state_70644__$1 = state_70644;
var statearr_70667_70687 = state_70644__$1;
(statearr_70667_70687[(2)] = inst_70637);

(statearr_70667_70687[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70645 === (8))){
var inst_70613 = (state_70644[(10)]);
var state_70644__$1 = state_70644;
var statearr_70668_70688 = state_70644__$1;
(statearr_70668_70688[(2)] = inst_70613);

(statearr_70668_70688[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16221__auto____0 = (function (){
var statearr_70669 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70669[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16221__auto__);

(statearr_70669[(1)] = (1));

return statearr_70669;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16221__auto____1 = (function (state_70644){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_70644);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e70670){var ex__16224__auto__ = e70670;
var statearr_70671_70689 = state_70644;
(statearr_70671_70689[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_70644[(4)]))){
var statearr_70672_70690 = state_70644;
(statearr_70672_70690[(1)] = cljs.core.first.call(null,(state_70644[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70691 = state_70644;
state_70644 = G__70691;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16221__auto__ = function(state_70644){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16221__auto____1.call(this,state_70644);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_70673 = f__16346__auto__.call(null);
(statearr_70673[(6)] = c__16345__auto__);

return statearr_70673;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__70692 = entry;
var res = cljs.core.nth.call(null,vec__70692,(0),null);
var cost = cljs.core.nth.call(null,vec__70692,(1),null);
fluree.db.util.log.debug.call(null,"Smart function stack: ",res);

return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj.call(null,new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(s),entry),new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._.call(null,new cljs.core.Keyword(null,"credits","credits",785860820).cljs$core$IFn$_invoke$arity$1(s),cost),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_.call(null,new cljs.core.Keyword(null,"spent","spent",-62769180).cljs$core$IFn$_invoke$arity$1(s),cost));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.call(null,msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack.call(null,_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_70740){
var state_val_70741 = (state_70740[(1)]);
if((state_val_70741 === (7))){
var state_70740__$1 = state_70740;
var statearr_70742_70771 = state_70740__$1;
(statearr_70742_70771[(2)] = coll);

(statearr_70742_70771[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70741 === (1))){
var state_70740__$1 = state_70740;
var statearr_70743_70772 = state_70740__$1;
(statearr_70743_70772[(2)] = null);

(statearr_70743_70772[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70741 === (4))){
var inst_70695 = (state_70740[(2)]);
var state_70740__$1 = state_70740;
var statearr_70744_70773 = state_70740__$1;
(statearr_70744_70773[(2)] = inst_70695);

(statearr_70744_70773[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70741 === (15))){
var inst_70714 = (state_70740[(7)]);
var inst_70722 = (state_70740[(2)]);
var inst_70723 = fluree.db.dbfunctions.internal.nth.call(null,inst_70714,inst_70722);
var inst_70724 = cljs.core.count.call(null,inst_70714);
var inst_70725 = ((9) + inst_70724);
var inst_70726 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70727 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_70728 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70729 = [inst_70714,inst_70722];
var inst_70730 = (new cljs.core.PersistentVector(null,2,(5),inst_70728,inst_70729,null));
var inst_70731 = ["nth",inst_70730,inst_70723];
var inst_70732 = cljs.core.PersistentHashMap.fromArrays(inst_70727,inst_70731);
var inst_70733 = [inst_70732,inst_70725];
var inst_70734 = (new cljs.core.PersistentVector(null,2,(5),inst_70726,inst_70733,null));
var inst_70735 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_70734);
var _ = (function (){var statearr_70745 = state_70740;
(statearr_70745[(4)] = cljs.core.rest.call(null,(state_70740[(4)])));

return statearr_70745;
})();
var state_70740__$1 = (function (){var statearr_70746 = state_70740;
(statearr_70746[(8)] = inst_70735);

return statearr_70746;
})();
var statearr_70747_70774 = state_70740__$1;
(statearr_70747_70774[(2)] = inst_70723);

(statearr_70747_70774[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70741 === (13))){
var state_70740__$1 = state_70740;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70740__$1,(16),key);
} else {
if((state_val_70741 === (6))){
var state_70740__$1 = state_70740;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70740__$1,(9),coll);
} else {
if((state_val_70741 === (3))){
var inst_70738 = (state_70740[(2)]);
var state_70740__$1 = state_70740;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70740__$1,inst_70738);
} else {
if((state_val_70741 === (12))){
var inst_70714 = (state_70740[(2)]);
var inst_70715 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_70740__$1 = (function (){var statearr_70748 = state_70740;
(statearr_70748[(7)] = inst_70714);

return statearr_70748;
})();
if(inst_70715){
var statearr_70749_70775 = state_70740__$1;
(statearr_70749_70775[(1)] = (13));

} else {
var statearr_70750_70776 = state_70740__$1;
(statearr_70750_70776[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70741 === (2))){
var _ = (function (){var statearr_70751 = state_70740;
(statearr_70751[(4)] = cljs.core.cons.call(null,(5),(state_70740[(4)])));

return statearr_70751;
})();
var inst_70701 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_70740__$1 = state_70740;
if(inst_70701){
var statearr_70752_70777 = state_70740__$1;
(statearr_70752_70777[(1)] = (6));

} else {
var statearr_70753_70778 = state_70740__$1;
(statearr_70753_70778[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70741 === (11))){
var inst_70708 = (state_70740[(9)]);
var state_70740__$1 = state_70740;
var statearr_70755_70779 = state_70740__$1;
(statearr_70755_70779[(2)] = inst_70708);

(statearr_70755_70779[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70741 === (9))){
var inst_70704 = (state_70740[(2)]);
var inst_70705 = fluree.db.util.async.throw_err.call(null,inst_70704);
var state_70740__$1 = state_70740;
var statearr_70756_70780 = state_70740__$1;
(statearr_70756_70780[(2)] = inst_70705);

(statearr_70756_70780[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70741 === (5))){
var _ = (function (){var statearr_70757 = state_70740;
(statearr_70757[(4)] = cljs.core.rest.call(null,(state_70740[(4)])));

return statearr_70757;
})();
var state_70740__$1 = state_70740;
var ex70754 = (state_70740__$1[(2)]);
var statearr_70758_70781 = state_70740__$1;
(statearr_70758_70781[(5)] = ex70754);


if((ex70754 instanceof Error)){
var statearr_70759_70782 = state_70740__$1;
(statearr_70759_70782[(1)] = (4));

(statearr_70759_70782[(5)] = null);

} else {
throw ex70754;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70741 === (14))){
var state_70740__$1 = state_70740;
var statearr_70760_70783 = state_70740__$1;
(statearr_70760_70783[(2)] = key);

(statearr_70760_70783[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70741 === (16))){
var inst_70718 = (state_70740[(2)]);
var inst_70719 = fluree.db.util.async.throw_err.call(null,inst_70718);
var state_70740__$1 = state_70740;
var statearr_70761_70784 = state_70740__$1;
(statearr_70761_70784[(2)] = inst_70719);

(statearr_70761_70784[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70741 === (10))){
var inst_70708 = (state_70740[(9)]);
var inst_70711 = cljs.core.vec.call(null,inst_70708);
var state_70740__$1 = state_70740;
var statearr_70762_70785 = state_70740__$1;
(statearr_70762_70785[(2)] = inst_70711);

(statearr_70762_70785[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70741 === (8))){
var inst_70708 = (state_70740[(9)]);
var inst_70708__$1 = (state_70740[(2)]);
var inst_70709 = cljs.core.set_QMARK_.call(null,inst_70708__$1);
var state_70740__$1 = (function (){var statearr_70763 = state_70740;
(statearr_70763[(9)] = inst_70708__$1);

return statearr_70763;
})();
if(inst_70709){
var statearr_70764_70786 = state_70740__$1;
(statearr_70764_70786[(1)] = (10));

} else {
var statearr_70765_70787 = state_70740__$1;
(statearr_70765_70787[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__16221__auto____0 = (function (){
var statearr_70766 = [null,null,null,null,null,null,null,null,null,null];
(statearr_70766[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__16221__auto__);

(statearr_70766[(1)] = (1));

return statearr_70766;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__16221__auto____1 = (function (state_70740){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_70740);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e70767){var ex__16224__auto__ = e70767;
var statearr_70768_70788 = state_70740;
(statearr_70768_70788[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_70740[(4)]))){
var statearr_70769_70789 = state_70740;
(statearr_70769_70789[(1)] = cljs.core.first.call(null,(state_70740[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70790 = state_70740;
state_70740 = G__70790;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__16221__auto__ = function(state_70740){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__16221__auto____1.call(this,state_70740);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_70770 = f__16346__auto__.call(null);
(statearr_70770[(6)] = c__16345__auto__);

return statearr_70770;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_70851){
var state_val_70852 = (state_70851[(1)]);
if((state_val_70852 === (7))){
var state_70851__$1 = state_70851;
var statearr_70853_70887 = state_70851__$1;
(statearr_70853_70887[(2)] = test);

(statearr_70853_70887[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70852 === (20))){
var inst_70825 = (state_70851[(2)]);
var inst_70826 = fluree.db.util.async.throw_err.call(null,inst_70825);
var state_70851__$1 = state_70851;
var statearr_70854_70888 = state_70851__$1;
(statearr_70854_70888[(2)] = inst_70826);

(statearr_70854_70888[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70852 === (1))){
var state_70851__$1 = state_70851;
var statearr_70855_70889 = state_70851__$1;
(statearr_70855_70889[(2)] = null);

(statearr_70855_70889[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70852 === (4))){
var inst_70791 = (state_70851[(2)]);
var state_70851__$1 = state_70851;
var statearr_70856_70890 = state_70851__$1;
(statearr_70856_70890[(2)] = inst_70791);

(statearr_70856_70890[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70852 === (15))){
var inst_70809 = (state_70851[(7)]);
var inst_70817 = (state_70851[(2)]);
var inst_70818 = [inst_70817,f];
var inst_70819 = (new cljs.core.PersistentVector(null,2,(5),inst_70809,inst_70818,null));
var state_70851__$1 = state_70851;
var statearr_70857_70891 = state_70851__$1;
(statearr_70857_70891[(2)] = inst_70819);

(statearr_70857_70891[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70852 === (13))){
var state_70851__$1 = state_70851;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70851__$1,(16),t);
} else {
if((state_val_70852 === (6))){
var state_70851__$1 = state_70851;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70851__$1,(9),test);
} else {
if((state_val_70852 === (17))){
var state_70851__$1 = state_70851;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70851__$1,(20),f);
} else {
if((state_val_70852 === (3))){
var inst_70849 = (state_70851[(2)]);
var state_70851__$1 = state_70851;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70851__$1,inst_70849);
} else {
if((state_val_70852 === (12))){
var inst_70807 = (state_70851[(8)]);
var inst_70833 = (state_70851[(2)]);
var inst_70834 = cljs.core.nth.call(null,inst_70833,(0),null);
var inst_70835 = cljs.core.nth.call(null,inst_70833,(1),null);
var inst_70836 = fluree.db.dbfunctions.internal.if_else.call(null,inst_70807,inst_70834,inst_70835);
var inst_70837 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70838 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_70839 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70840 = [inst_70807,inst_70834,inst_70835];
var inst_70841 = (new cljs.core.PersistentVector(null,3,(5),inst_70839,inst_70840,null));
var inst_70842 = ["if-else",inst_70841,inst_70836];
var inst_70843 = cljs.core.PersistentHashMap.fromArrays(inst_70838,inst_70842);
var inst_70844 = [inst_70843,(10)];
var inst_70845 = (new cljs.core.PersistentVector(null,2,(5),inst_70837,inst_70844,null));
var inst_70846 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_70845);
var _ = (function (){var statearr_70858 = state_70851;
(statearr_70858[(4)] = cljs.core.rest.call(null,(state_70851[(4)])));

return statearr_70858;
})();
var state_70851__$1 = (function (){var statearr_70859 = state_70851;
(statearr_70859[(9)] = inst_70846);

return statearr_70859;
})();
var statearr_70860_70892 = state_70851__$1;
(statearr_70860_70892[(2)] = inst_70836);

(statearr_70860_70892[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70852 === (2))){
var _ = (function (){var statearr_70861 = state_70851;
(statearr_70861[(4)] = cljs.core.cons.call(null,(5),(state_70851[(4)])));

return statearr_70861;
})();
var inst_70800 = fluree.db.util.async.channel_QMARK_.call(null,test);
var state_70851__$1 = state_70851;
if(inst_70800){
var statearr_70862_70893 = state_70851__$1;
(statearr_70862_70893[(1)] = (6));

} else {
var statearr_70863_70894 = state_70851__$1;
(statearr_70863_70894[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70852 === (19))){
var inst_70821 = (state_70851[(10)]);
var inst_70829 = (state_70851[(2)]);
var inst_70830 = [f,inst_70829];
var inst_70831 = (new cljs.core.PersistentVector(null,2,(5),inst_70821,inst_70830,null));
var state_70851__$1 = state_70851;
var statearr_70864_70895 = state_70851__$1;
(statearr_70864_70895[(2)] = inst_70831);

(statearr_70864_70895[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70852 === (11))){
var inst_70821 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70822 = fluree.db.util.async.channel_QMARK_.call(null,f);
var state_70851__$1 = (function (){var statearr_70866 = state_70851;
(statearr_70866[(10)] = inst_70821);

return statearr_70866;
})();
if(inst_70822){
var statearr_70867_70896 = state_70851__$1;
(statearr_70867_70896[(1)] = (17));

} else {
var statearr_70868_70897 = state_70851__$1;
(statearr_70868_70897[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70852 === (9))){
var inst_70803 = (state_70851[(2)]);
var inst_70804 = fluree.db.util.async.throw_err.call(null,inst_70803);
var state_70851__$1 = state_70851;
var statearr_70869_70898 = state_70851__$1;
(statearr_70869_70898[(2)] = inst_70804);

(statearr_70869_70898[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70852 === (5))){
var _ = (function (){var statearr_70870 = state_70851;
(statearr_70870[(4)] = cljs.core.rest.call(null,(state_70851[(4)])));

return statearr_70870;
})();
var state_70851__$1 = state_70851;
var ex70865 = (state_70851__$1[(2)]);
var statearr_70871_70899 = state_70851__$1;
(statearr_70871_70899[(5)] = ex70865);


if((ex70865 instanceof Error)){
var statearr_70872_70900 = state_70851__$1;
(statearr_70872_70900[(1)] = (4));

(statearr_70872_70900[(5)] = null);

} else {
throw ex70865;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70852 === (14))){
var state_70851__$1 = state_70851;
var statearr_70873_70901 = state_70851__$1;
(statearr_70873_70901[(2)] = t);

(statearr_70873_70901[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70852 === (16))){
var inst_70813 = (state_70851[(2)]);
var inst_70814 = fluree.db.util.async.throw_err.call(null,inst_70813);
var state_70851__$1 = state_70851;
var statearr_70874_70902 = state_70851__$1;
(statearr_70874_70902[(2)] = inst_70814);

(statearr_70874_70902[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70852 === (10))){
var inst_70809 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70810 = fluree.db.util.async.channel_QMARK_.call(null,t);
var state_70851__$1 = (function (){var statearr_70875 = state_70851;
(statearr_70875[(7)] = inst_70809);

return statearr_70875;
})();
if(inst_70810){
var statearr_70876_70903 = state_70851__$1;
(statearr_70876_70903[(1)] = (13));

} else {
var statearr_70877_70904 = state_70851__$1;
(statearr_70877_70904[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70852 === (18))){
var state_70851__$1 = state_70851;
var statearr_70878_70905 = state_70851__$1;
(statearr_70878_70905[(2)] = f);

(statearr_70878_70905[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70852 === (8))){
var inst_70807 = (state_70851[(8)]);
var inst_70807__$1 = (state_70851[(2)]);
var state_70851__$1 = (function (){var statearr_70879 = state_70851;
(statearr_70879[(8)] = inst_70807__$1);

return statearr_70879;
})();
if(cljs.core.truth_(inst_70807__$1)){
var statearr_70880_70906 = state_70851__$1;
(statearr_70880_70906[(1)] = (10));

} else {
var statearr_70881_70907 = state_70851__$1;
(statearr_70881_70907[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__16221__auto____0 = (function (){
var statearr_70882 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_70882[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__16221__auto__);

(statearr_70882[(1)] = (1));

return statearr_70882;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__16221__auto____1 = (function (state_70851){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_70851);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e70883){var ex__16224__auto__ = e70883;
var statearr_70884_70908 = state_70851;
(statearr_70884_70908[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_70851[(4)]))){
var statearr_70885_70909 = state_70851;
(statearr_70885_70909[(1)] = cljs.core.first.call(null,(state_70851[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70910 = state_70851;
state_70851 = G__70910;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__16221__auto__ = function(state_70851){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__16221__auto____1.call(this,state_70851);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_70886 = f__16346__auto__.call(null);
(statearr_70886[(6)] = c__16345__auto__);

return statearr_70886;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_70940){
var state_val_70941 = (state_70940[(1)]);
if((state_val_70941 === (7))){
var state_70940__$1 = state_70940;
var statearr_70942_70961 = state_70940__$1;
(statearr_70942_70961[(2)] = arg);

(statearr_70942_70961[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70941 === (1))){
var state_70940__$1 = state_70940;
var statearr_70943_70962 = state_70940__$1;
(statearr_70943_70962[(2)] = null);

(statearr_70943_70962[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70941 === (4))){
var inst_70911 = (state_70940[(2)]);
var state_70940__$1 = state_70940;
var statearr_70944_70963 = state_70940__$1;
(statearr_70944_70963[(2)] = inst_70911);

(statearr_70944_70963[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70941 === (6))){
var state_70940__$1 = state_70940;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70940__$1,(9),arg);
} else {
if((state_val_70941 === (3))){
var inst_70938 = (state_70940[(2)]);
var state_70940__$1 = state_70940;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70940__$1,inst_70938);
} else {
if((state_val_70941 === (2))){
var _ = (function (){var statearr_70946 = state_70940;
(statearr_70946[(4)] = cljs.core.cons.call(null,(5),(state_70940[(4)])));

return statearr_70946;
})();
var inst_70917 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_70940__$1 = state_70940;
if(inst_70917){
var statearr_70947_70964 = state_70940__$1;
(statearr_70947_70964[(1)] = (6));

} else {
var statearr_70948_70965 = state_70940__$1;
(statearr_70948_70965[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70941 === (9))){
var inst_70920 = (state_70940[(2)]);
var inst_70921 = fluree.db.util.async.throw_err.call(null,inst_70920);
var state_70940__$1 = state_70940;
var statearr_70949_70966 = state_70940__$1;
(statearr_70949_70966[(2)] = inst_70921);

(statearr_70949_70966[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70941 === (5))){
var _ = (function (){var statearr_70950 = state_70940;
(statearr_70950[(4)] = cljs.core.rest.call(null,(state_70940[(4)])));

return statearr_70950;
})();
var state_70940__$1 = state_70940;
var ex70945 = (state_70940__$1[(2)]);
var statearr_70951_70967 = state_70940__$1;
(statearr_70951_70967[(5)] = ex70945);


if((ex70945 instanceof Error)){
var statearr_70952_70968 = state_70940__$1;
(statearr_70952_70968[(1)] = (4));

(statearr_70952_70968[(5)] = null);

} else {
throw ex70945;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70941 === (8))){
var inst_70924 = (state_70940[(2)]);
var inst_70925 = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,inst_70924);
var inst_70926 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70927 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_70928 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70929 = [inst_70924];
var inst_70930 = (new cljs.core.PersistentVector(null,1,(5),inst_70928,inst_70929,null));
var inst_70931 = ["nil?",inst_70930,inst_70925];
var inst_70932 = cljs.core.PersistentHashMap.fromArrays(inst_70927,inst_70931);
var inst_70933 = [inst_70932,(10)];
var inst_70934 = (new cljs.core.PersistentVector(null,2,(5),inst_70926,inst_70933,null));
var inst_70935 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_70934);
var _ = (function (){var statearr_70953 = state_70940;
(statearr_70953[(4)] = cljs.core.rest.call(null,(state_70940[(4)])));

return statearr_70953;
})();
var state_70940__$1 = (function (){var statearr_70954 = state_70940;
(statearr_70954[(7)] = inst_70935);

return statearr_70954;
})();
var statearr_70955_70969 = state_70940__$1;
(statearr_70955_70969[(2)] = inst_70925);

(statearr_70955_70969[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16221__auto____0 = (function (){
var statearr_70956 = [null,null,null,null,null,null,null,null];
(statearr_70956[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16221__auto__);

(statearr_70956[(1)] = (1));

return statearr_70956;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16221__auto____1 = (function (state_70940){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_70940);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e70957){var ex__16224__auto__ = e70957;
var statearr_70958_70970 = state_70940;
(statearr_70958_70970[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_70940[(4)]))){
var statearr_70959_70971 = state_70940;
(statearr_70959_70971[(1)] = cljs.core.first.call(null,(state_70940[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70972 = state_70940;
state_70940 = G__70972;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16221__auto__ = function(state_70940){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16221__auto____1.call(this,state_70940);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_70960 = f__16346__auto__.call(null);
(statearr_70960[(6)] = c__16345__auto__);

return statearr_70960;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_71002){
var state_val_71003 = (state_71002[(1)]);
if((state_val_71003 === (7))){
var state_71002__$1 = state_71002;
var statearr_71004_71023 = state_71002__$1;
(statearr_71004_71023[(2)] = arg);

(statearr_71004_71023[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71003 === (1))){
var state_71002__$1 = state_71002;
var statearr_71005_71024 = state_71002__$1;
(statearr_71005_71024[(2)] = null);

(statearr_71005_71024[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71003 === (4))){
var inst_70973 = (state_71002[(2)]);
var state_71002__$1 = state_71002;
var statearr_71006_71025 = state_71002__$1;
(statearr_71006_71025[(2)] = inst_70973);

(statearr_71006_71025[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71003 === (6))){
var state_71002__$1 = state_71002;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71002__$1,(9),arg);
} else {
if((state_val_71003 === (3))){
var inst_71000 = (state_71002[(2)]);
var state_71002__$1 = state_71002;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71002__$1,inst_71000);
} else {
if((state_val_71003 === (2))){
var _ = (function (){var statearr_71008 = state_71002;
(statearr_71008[(4)] = cljs.core.cons.call(null,(5),(state_71002[(4)])));

return statearr_71008;
})();
var inst_70979 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_71002__$1 = state_71002;
if(inst_70979){
var statearr_71009_71026 = state_71002__$1;
(statearr_71009_71026[(1)] = (6));

} else {
var statearr_71010_71027 = state_71002__$1;
(statearr_71010_71027[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71003 === (9))){
var inst_70982 = (state_71002[(2)]);
var inst_70983 = fluree.db.util.async.throw_err.call(null,inst_70982);
var state_71002__$1 = state_71002;
var statearr_71011_71028 = state_71002__$1;
(statearr_71011_71028[(2)] = inst_70983);

(statearr_71011_71028[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71003 === (5))){
var _ = (function (){var statearr_71012 = state_71002;
(statearr_71012[(4)] = cljs.core.rest.call(null,(state_71002[(4)])));

return statearr_71012;
})();
var state_71002__$1 = state_71002;
var ex71007 = (state_71002__$1[(2)]);
var statearr_71013_71029 = state_71002__$1;
(statearr_71013_71029[(5)] = ex71007);


if((ex71007 instanceof Error)){
var statearr_71014_71030 = state_71002__$1;
(statearr_71014_71030[(1)] = (4));

(statearr_71014_71030[(5)] = null);

} else {
throw ex71007;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71003 === (8))){
var inst_70986 = (state_71002[(2)]);
var inst_70987 = fluree.db.dbfunctions.internal.not.call(null,inst_70986);
var inst_70988 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70989 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_70990 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70991 = [inst_70986];
var inst_70992 = (new cljs.core.PersistentVector(null,1,(5),inst_70990,inst_70991,null));
var inst_70993 = ["not?",inst_70992,inst_70987];
var inst_70994 = cljs.core.PersistentHashMap.fromArrays(inst_70989,inst_70993);
var inst_70995 = [inst_70994,(10)];
var inst_70996 = (new cljs.core.PersistentVector(null,2,(5),inst_70988,inst_70995,null));
var inst_70997 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_70996);
var _ = (function (){var statearr_71015 = state_71002;
(statearr_71015[(4)] = cljs.core.rest.call(null,(state_71002[(4)])));

return statearr_71015;
})();
var state_71002__$1 = (function (){var statearr_71016 = state_71002;
(statearr_71016[(7)] = inst_70997);

return statearr_71016;
})();
var statearr_71017_71031 = state_71002__$1;
(statearr_71017_71031[(2)] = inst_70987);

(statearr_71017_71031[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__16221__auto____0 = (function (){
var statearr_71018 = [null,null,null,null,null,null,null,null];
(statearr_71018[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__16221__auto__);

(statearr_71018[(1)] = (1));

return statearr_71018;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__16221__auto____1 = (function (state_71002){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_71002);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e71019){var ex__16224__auto__ = e71019;
var statearr_71020_71032 = state_71002;
(statearr_71020_71032[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_71002[(4)]))){
var statearr_71021_71033 = state_71002;
(statearr_71021_71033[(1)] = cljs.core.first.call(null,(state_71002[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71034 = state_71002;
state_71002 = G__71034;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__16221__auto__ = function(state_71002){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__16221__auto____1.call(this,state_71002);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_71022 = f__16346__auto__.call(null);
(statearr_71022[(6)] = c__16345__auto__);

return statearr_71022;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_71064){
var state_val_71065 = (state_71064[(1)]);
if((state_val_71065 === (7))){
var state_71064__$1 = state_71064;
var statearr_71066_71085 = state_71064__$1;
(statearr_71066_71085[(2)] = arg);

(statearr_71066_71085[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71065 === (1))){
var state_71064__$1 = state_71064;
var statearr_71067_71086 = state_71064__$1;
(statearr_71067_71086[(2)] = null);

(statearr_71067_71086[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71065 === (4))){
var inst_71035 = (state_71064[(2)]);
var state_71064__$1 = state_71064;
var statearr_71068_71087 = state_71064__$1;
(statearr_71068_71087[(2)] = inst_71035);

(statearr_71068_71087[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71065 === (6))){
var state_71064__$1 = state_71064;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71064__$1,(9),arg);
} else {
if((state_val_71065 === (3))){
var inst_71062 = (state_71064[(2)]);
var state_71064__$1 = state_71064;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71064__$1,inst_71062);
} else {
if((state_val_71065 === (2))){
var _ = (function (){var statearr_71070 = state_71064;
(statearr_71070[(4)] = cljs.core.cons.call(null,(5),(state_71064[(4)])));

return statearr_71070;
})();
var inst_71041 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_71064__$1 = state_71064;
if(inst_71041){
var statearr_71071_71088 = state_71064__$1;
(statearr_71071_71088[(1)] = (6));

} else {
var statearr_71072_71089 = state_71064__$1;
(statearr_71072_71089[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71065 === (9))){
var inst_71044 = (state_71064[(2)]);
var inst_71045 = fluree.db.util.async.throw_err.call(null,inst_71044);
var state_71064__$1 = state_71064;
var statearr_71073_71090 = state_71064__$1;
(statearr_71073_71090[(2)] = inst_71045);

(statearr_71073_71090[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71065 === (5))){
var _ = (function (){var statearr_71074 = state_71064;
(statearr_71074[(4)] = cljs.core.rest.call(null,(state_71064[(4)])));

return statearr_71074;
})();
var state_71064__$1 = state_71064;
var ex71069 = (state_71064__$1[(2)]);
var statearr_71075_71091 = state_71064__$1;
(statearr_71075_71091[(5)] = ex71069);


if((ex71069 instanceof Error)){
var statearr_71076_71092 = state_71064__$1;
(statearr_71076_71092[(1)] = (4));

(statearr_71076_71092[(5)] = null);

} else {
throw ex71069;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71065 === (8))){
var inst_71048 = (state_71064[(2)]);
var inst_71049 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_71048);
var inst_71050 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71051 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_71052 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71053 = [inst_71048];
var inst_71054 = (new cljs.core.PersistentVector(null,1,(5),inst_71052,inst_71053,null));
var inst_71055 = ["empty?",inst_71054,inst_71049];
var inst_71056 = cljs.core.PersistentHashMap.fromArrays(inst_71051,inst_71055);
var inst_71057 = [inst_71056,(10)];
var inst_71058 = (new cljs.core.PersistentVector(null,2,(5),inst_71050,inst_71057,null));
var inst_71059 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_71058);
var _ = (function (){var statearr_71077 = state_71064;
(statearr_71077[(4)] = cljs.core.rest.call(null,(state_71064[(4)])));

return statearr_71077;
})();
var state_71064__$1 = (function (){var statearr_71078 = state_71064;
(statearr_71078[(7)] = inst_71059);

return statearr_71078;
})();
var statearr_71079_71093 = state_71064__$1;
(statearr_71079_71093[(2)] = inst_71049);

(statearr_71079_71093[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16221__auto____0 = (function (){
var statearr_71080 = [null,null,null,null,null,null,null,null];
(statearr_71080[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16221__auto__);

(statearr_71080[(1)] = (1));

return statearr_71080;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16221__auto____1 = (function (state_71064){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_71064);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e71081){var ex__16224__auto__ = e71081;
var statearr_71082_71094 = state_71064;
(statearr_71082_71094[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_71064[(4)]))){
var statearr_71083_71095 = state_71064;
(statearr_71083_71095[(1)] = cljs.core.first.call(null,(state_71064[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71096 = state_71064;
state_71064 = G__71096;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16221__auto__ = function(state_71064){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16221__auto____1.call(this,state_71064);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_71084 = f__16346__auto__.call(null);
(statearr_71084[(6)] = c__16345__auto__);

return statearr_71084;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4824__auto__ = [];
var len__4818__auto___71141 = arguments.length;
var i__4819__auto___71142 = (0);
while(true){
if((i__4819__auto___71142 < len__4818__auto___71141)){
args__4824__auto__.push((arguments[i__4819__auto___71142]));

var G__71143 = (i__4819__auto___71142 + (1));
i__4819__auto___71142 = G__71143;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_71124){
var state_val_71125 = (state_71124[(1)]);
if((state_val_71125 === (1))){
var state_71124__$1 = state_71124;
var statearr_71126_71144 = state_71124__$1;
(statearr_71126_71144[(2)] = null);

(statearr_71126_71144[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71125 === (2))){
var _ = (function (){var statearr_71127 = state_71124;
(statearr_71127[(4)] = cljs.core.cons.call(null,(5),(state_71124[(4)])));

return statearr_71127;
})();
var inst_71105 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_71124__$1 = state_71124;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71124__$1,(6),inst_71105);
} else {
if((state_val_71125 === (3))){
var inst_71122 = (state_71124[(2)]);
var state_71124__$1 = state_71124;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71124__$1,inst_71122);
} else {
if((state_val_71125 === (4))){
var inst_71099 = (state_71124[(2)]);
var state_71124__$1 = state_71124;
var statearr_71129_71145 = state_71124__$1;
(statearr_71129_71145[(2)] = inst_71099);

(statearr_71129_71145[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71125 === (5))){
var _ = (function (){var statearr_71130 = state_71124;
(statearr_71130[(4)] = cljs.core.rest.call(null,(state_71124[(4)])));

return statearr_71130;
})();
var state_71124__$1 = state_71124;
var ex71128 = (state_71124__$1[(2)]);
var statearr_71131_71146 = state_71124__$1;
(statearr_71131_71146[(5)] = ex71128);


if((ex71128 instanceof Error)){
var statearr_71132_71147 = state_71124__$1;
(statearr_71132_71147[(1)] = (4));

(statearr_71132_71147[(5)] = null);

} else {
throw ex71128;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71125 === (6))){
var inst_71107 = (state_71124[(2)]);
var inst_71108 = fluree.db.util.async.throw_err.call(null,inst_71107);
var inst_71109 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.str,inst_71108);
var inst_71110 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71111 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_71112 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71113 = [inst_71108];
var inst_71114 = (new cljs.core.PersistentVector(null,1,(5),inst_71112,inst_71113,null));
var inst_71115 = ["str",inst_71114,inst_71109];
var inst_71116 = cljs.core.PersistentHashMap.fromArrays(inst_71111,inst_71115);
var inst_71117 = [inst_71116,(10)];
var inst_71118 = (new cljs.core.PersistentVector(null,2,(5),inst_71110,inst_71117,null));
var inst_71119 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_71118);
var _ = (function (){var statearr_71133 = state_71124;
(statearr_71133[(4)] = cljs.core.rest.call(null,(state_71124[(4)])));

return statearr_71133;
})();
var state_71124__$1 = (function (){var statearr_71134 = state_71124;
(statearr_71134[(7)] = inst_71119);

return statearr_71134;
})();
var statearr_71135_71148 = state_71124__$1;
(statearr_71135_71148[(2)] = inst_71109);

(statearr_71135_71148[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16221__auto____0 = (function (){
var statearr_71136 = [null,null,null,null,null,null,null,null];
(statearr_71136[(0)] = fluree$db$dbfunctions$fns$state_machine__16221__auto__);

(statearr_71136[(1)] = (1));

return statearr_71136;
});
var fluree$db$dbfunctions$fns$state_machine__16221__auto____1 = (function (state_71124){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_71124);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e71137){var ex__16224__auto__ = e71137;
var statearr_71138_71149 = state_71124;
(statearr_71138_71149[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_71124[(4)]))){
var statearr_71139_71150 = state_71124;
(statearr_71139_71150[(1)] = cljs.core.first.call(null,(state_71124[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71151 = state_71124;
state_71124 = G__71151;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16221__auto__ = function(state_71124){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____1.call(this,state_71124);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_71140 = f__16346__auto__.call(null);
(statearr_71140[(6)] = c__16345__auto__);

return statearr_71140;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq71097){
var G__71098 = cljs.core.first.call(null,seq71097);
var seq71097__$1 = cljs.core.next.call(null,seq71097);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71098,seq71097__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_71177){
var state_val_71178 = (state_71177[(1)]);
if((state_val_71178 === (1))){
var state_71177__$1 = state_71177;
var statearr_71179_71194 = state_71177__$1;
(statearr_71179_71194[(2)] = null);

(statearr_71179_71194[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71178 === (2))){
var _ = (function (){var statearr_71180 = state_71177;
(statearr_71180[(4)] = cljs.core.cons.call(null,(5),(state_71177[(4)])));

return statearr_71180;
})();
var inst_71158 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_71177__$1 = state_71177;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71177__$1,(6),inst_71158);
} else {
if((state_val_71178 === (3))){
var inst_71175 = (state_71177[(2)]);
var state_71177__$1 = state_71177;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71177__$1,inst_71175);
} else {
if((state_val_71178 === (4))){
var inst_71152 = (state_71177[(2)]);
var state_71177__$1 = state_71177;
var statearr_71182_71195 = state_71177__$1;
(statearr_71182_71195[(2)] = inst_71152);

(statearr_71182_71195[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71178 === (5))){
var _ = (function (){var statearr_71183 = state_71177;
(statearr_71183[(4)] = cljs.core.rest.call(null,(state_71177[(4)])));

return statearr_71183;
})();
var state_71177__$1 = state_71177;
var ex71181 = (state_71177__$1[(2)]);
var statearr_71184_71196 = state_71177__$1;
(statearr_71184_71196[(5)] = ex71181);


if((ex71181 instanceof Error)){
var statearr_71185_71197 = state_71177__$1;
(statearr_71185_71197[(1)] = (4));

(statearr_71185_71197[(5)] = null);

} else {
throw ex71181;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71178 === (6))){
var inst_71160 = (state_71177[(2)]);
var inst_71161 = fluree.db.util.async.throw_err.call(null,inst_71160);
var inst_71162 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.subs,inst_71161);
var inst_71163 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71164 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_71165 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71166 = [inst_71161];
var inst_71167 = (new cljs.core.PersistentVector(null,1,(5),inst_71165,inst_71166,null));
var inst_71168 = ["subs",inst_71167,inst_71162];
var inst_71169 = cljs.core.PersistentHashMap.fromArrays(inst_71164,inst_71168);
var inst_71170 = [inst_71169,(30)];
var inst_71171 = (new cljs.core.PersistentVector(null,2,(5),inst_71163,inst_71170,null));
var inst_71172 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_71171);
var _ = (function (){var statearr_71186 = state_71177;
(statearr_71186[(4)] = cljs.core.rest.call(null,(state_71177[(4)])));

return statearr_71186;
})();
var state_71177__$1 = (function (){var statearr_71187 = state_71177;
(statearr_71187[(7)] = inst_71172);

return statearr_71187;
})();
var statearr_71188_71198 = state_71177__$1;
(statearr_71188_71198[(2)] = inst_71162);

(statearr_71188_71198[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__16221__auto____0 = (function (){
var statearr_71189 = [null,null,null,null,null,null,null,null];
(statearr_71189[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__16221__auto__);

(statearr_71189[(1)] = (1));

return statearr_71189;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__16221__auto____1 = (function (state_71177){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_71177);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e71190){var ex__16224__auto__ = e71190;
var statearr_71191_71199 = state_71177;
(statearr_71191_71199[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_71177[(4)]))){
var statearr_71192_71200 = state_71177;
(statearr_71192_71200[(1)] = cljs.core.first.call(null,(state_71177[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71201 = state_71177;
state_71177 = G__71201;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__16221__auto__ = function(state_71177){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__16221__auto____1.call(this,state_71177);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_71193 = f__16346__auto__.call(null);
(statearr_71193[(6)] = c__16345__auto__);

return statearr_71193;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_71231){
var state_val_71232 = (state_71231[(1)]);
if((state_val_71232 === (7))){
var state_71231__$1 = state_71231;
var statearr_71233_71252 = state_71231__$1;
(statearr_71233_71252[(2)] = str);

(statearr_71233_71252[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71232 === (1))){
var state_71231__$1 = state_71231;
var statearr_71234_71253 = state_71231__$1;
(statearr_71234_71253[(2)] = null);

(statearr_71234_71253[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71232 === (4))){
var inst_71202 = (state_71231[(2)]);
var state_71231__$1 = state_71231;
var statearr_71235_71254 = state_71231__$1;
(statearr_71235_71254[(2)] = inst_71202);

(statearr_71235_71254[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71232 === (6))){
var state_71231__$1 = state_71231;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71231__$1,(9),str);
} else {
if((state_val_71232 === (3))){
var inst_71229 = (state_71231[(2)]);
var state_71231__$1 = state_71231;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71231__$1,inst_71229);
} else {
if((state_val_71232 === (2))){
var _ = (function (){var statearr_71237 = state_71231;
(statearr_71237[(4)] = cljs.core.cons.call(null,(5),(state_71231[(4)])));

return statearr_71237;
})();
var inst_71208 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_71231__$1 = state_71231;
if(inst_71208){
var statearr_71238_71255 = state_71231__$1;
(statearr_71238_71255[(1)] = (6));

} else {
var statearr_71239_71256 = state_71231__$1;
(statearr_71239_71256[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71232 === (9))){
var inst_71211 = (state_71231[(2)]);
var inst_71212 = fluree.db.util.async.throw_err.call(null,inst_71211);
var state_71231__$1 = state_71231;
var statearr_71240_71257 = state_71231__$1;
(statearr_71240_71257[(2)] = inst_71212);

(statearr_71240_71257[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71232 === (5))){
var _ = (function (){var statearr_71241 = state_71231;
(statearr_71241[(4)] = cljs.core.rest.call(null,(state_71231[(4)])));

return statearr_71241;
})();
var state_71231__$1 = state_71231;
var ex71236 = (state_71231__$1[(2)]);
var statearr_71242_71258 = state_71231__$1;
(statearr_71242_71258[(5)] = ex71236);


if((ex71236 instanceof Error)){
var statearr_71243_71259 = state_71231__$1;
(statearr_71243_71259[(1)] = (4));

(statearr_71243_71259[(5)] = null);

} else {
throw ex71236;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71232 === (8))){
var inst_71215 = (state_71231[(2)]);
var inst_71216 = fluree.db.dbfunctions.internal.lower_case.call(null,inst_71215);
var inst_71217 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71218 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_71219 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71220 = [inst_71215];
var inst_71221 = (new cljs.core.PersistentVector(null,1,(5),inst_71219,inst_71220,null));
var inst_71222 = ["lower-case",inst_71221,inst_71216];
var inst_71223 = cljs.core.PersistentHashMap.fromArrays(inst_71218,inst_71222);
var inst_71224 = [inst_71223,(10)];
var inst_71225 = (new cljs.core.PersistentVector(null,2,(5),inst_71217,inst_71224,null));
var inst_71226 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_71225);
var _ = (function (){var statearr_71244 = state_71231;
(statearr_71244[(4)] = cljs.core.rest.call(null,(state_71231[(4)])));

return statearr_71244;
})();
var state_71231__$1 = (function (){var statearr_71245 = state_71231;
(statearr_71245[(7)] = inst_71226);

return statearr_71245;
})();
var statearr_71246_71260 = state_71231__$1;
(statearr_71246_71260[(2)] = inst_71216);

(statearr_71246_71260[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__16221__auto____0 = (function (){
var statearr_71247 = [null,null,null,null,null,null,null,null];
(statearr_71247[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__16221__auto__);

(statearr_71247[(1)] = (1));

return statearr_71247;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__16221__auto____1 = (function (state_71231){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_71231);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e71248){var ex__16224__auto__ = e71248;
var statearr_71249_71261 = state_71231;
(statearr_71249_71261[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_71231[(4)]))){
var statearr_71250_71262 = state_71231;
(statearr_71250_71262[(1)] = cljs.core.first.call(null,(state_71231[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71263 = state_71231;
state_71231 = G__71263;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__16221__auto__ = function(state_71231){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__16221__auto____1.call(this,state_71231);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_71251 = f__16346__auto__.call(null);
(statearr_71251[(6)] = c__16345__auto__);

return statearr_71251;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_71293){
var state_val_71294 = (state_71293[(1)]);
if((state_val_71294 === (7))){
var state_71293__$1 = state_71293;
var statearr_71295_71314 = state_71293__$1;
(statearr_71295_71314[(2)] = str);

(statearr_71295_71314[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71294 === (1))){
var state_71293__$1 = state_71293;
var statearr_71296_71315 = state_71293__$1;
(statearr_71296_71315[(2)] = null);

(statearr_71296_71315[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71294 === (4))){
var inst_71264 = (state_71293[(2)]);
var state_71293__$1 = state_71293;
var statearr_71297_71316 = state_71293__$1;
(statearr_71297_71316[(2)] = inst_71264);

(statearr_71297_71316[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71294 === (6))){
var state_71293__$1 = state_71293;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71293__$1,(9),str);
} else {
if((state_val_71294 === (3))){
var inst_71291 = (state_71293[(2)]);
var state_71293__$1 = state_71293;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71293__$1,inst_71291);
} else {
if((state_val_71294 === (2))){
var _ = (function (){var statearr_71299 = state_71293;
(statearr_71299[(4)] = cljs.core.cons.call(null,(5),(state_71293[(4)])));

return statearr_71299;
})();
var inst_71270 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_71293__$1 = state_71293;
if(inst_71270){
var statearr_71300_71317 = state_71293__$1;
(statearr_71300_71317[(1)] = (6));

} else {
var statearr_71301_71318 = state_71293__$1;
(statearr_71301_71318[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71294 === (9))){
var inst_71273 = (state_71293[(2)]);
var inst_71274 = fluree.db.util.async.throw_err.call(null,inst_71273);
var state_71293__$1 = state_71293;
var statearr_71302_71319 = state_71293__$1;
(statearr_71302_71319[(2)] = inst_71274);

(statearr_71302_71319[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71294 === (5))){
var _ = (function (){var statearr_71303 = state_71293;
(statearr_71303[(4)] = cljs.core.rest.call(null,(state_71293[(4)])));

return statearr_71303;
})();
var state_71293__$1 = state_71293;
var ex71298 = (state_71293__$1[(2)]);
var statearr_71304_71320 = state_71293__$1;
(statearr_71304_71320[(5)] = ex71298);


if((ex71298 instanceof Error)){
var statearr_71305_71321 = state_71293__$1;
(statearr_71305_71321[(1)] = (4));

(statearr_71305_71321[(5)] = null);

} else {
throw ex71298;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71294 === (8))){
var inst_71277 = (state_71293[(2)]);
var inst_71278 = fluree.db.dbfunctions.internal.upper_case.call(null,inst_71277);
var inst_71279 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71280 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_71281 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71282 = [inst_71277];
var inst_71283 = (new cljs.core.PersistentVector(null,1,(5),inst_71281,inst_71282,null));
var inst_71284 = ["upper-case",inst_71283,inst_71278];
var inst_71285 = cljs.core.PersistentHashMap.fromArrays(inst_71280,inst_71284);
var inst_71286 = [inst_71285,(10)];
var inst_71287 = (new cljs.core.PersistentVector(null,2,(5),inst_71279,inst_71286,null));
var inst_71288 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_71287);
var _ = (function (){var statearr_71306 = state_71293;
(statearr_71306[(4)] = cljs.core.rest.call(null,(state_71293[(4)])));

return statearr_71306;
})();
var state_71293__$1 = (function (){var statearr_71307 = state_71293;
(statearr_71307[(7)] = inst_71288);

return statearr_71307;
})();
var statearr_71308_71322 = state_71293__$1;
(statearr_71308_71322[(2)] = inst_71278);

(statearr_71308_71322[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__16221__auto____0 = (function (){
var statearr_71309 = [null,null,null,null,null,null,null,null];
(statearr_71309[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__16221__auto__);

(statearr_71309[(1)] = (1));

return statearr_71309;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__16221__auto____1 = (function (state_71293){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_71293);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e71310){var ex__16224__auto__ = e71310;
var statearr_71311_71323 = state_71293;
(statearr_71311_71323[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_71293[(4)]))){
var statearr_71312_71324 = state_71293;
(statearr_71312_71324[(1)] = cljs.core.first.call(null,(state_71293[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71325 = state_71293;
state_71293 = G__71325;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__16221__auto__ = function(state_71293){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__16221__auto____1.call(this,state_71293);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_71313 = f__16346__auto__.call(null);
(statearr_71313[(6)] = c__16345__auto__);

return statearr_71313;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4210__auto__)){
return (!(typeof cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__4210__auto__;
}
})())){
var res = cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__71327 = arguments.length;
switch (G__71327) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_71355){
var state_val_71356 = (state_71355[(1)]);
if((state_val_71356 === (1))){
var state_71355__$1 = state_71355;
var statearr_71357_71373 = state_71355__$1;
(statearr_71357_71373[(2)] = null);

(statearr_71357_71373[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71356 === (2))){
var _ = (function (){var statearr_71358 = state_71355;
(statearr_71358[(4)] = cljs.core.cons.call(null,(5),(state_71355[(4)])));

return statearr_71358;
})();
var inst_71337 = fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,additional_select);
var state_71355__$1 = state_71355;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71355__$1,(6),inst_71337);
} else {
if((state_val_71356 === (3))){
var inst_71353 = (state_71355[(2)]);
var state_71355__$1 = state_71355;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71355__$1,inst_71353);
} else {
if((state_val_71356 === (4))){
var inst_71328 = (state_71355[(2)]);
var state_71355__$1 = state_71355;
var statearr_71360_71374 = state_71355__$1;
(statearr_71360_71374[(2)] = inst_71328);

(statearr_71360_71374[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71356 === (5))){
var _ = (function (){var statearr_71361 = state_71355;
(statearr_71361[(4)] = cljs.core.rest.call(null,(state_71355[(4)])));

return statearr_71361;
})();
var state_71355__$1 = state_71355;
var ex71359 = (state_71355__$1[(2)]);
var statearr_71362_71375 = state_71355__$1;
(statearr_71362_71375[(5)] = ex71359);


if((ex71359 instanceof Error)){
var statearr_71363_71376 = state_71355__$1;
(statearr_71363_71376[(1)] = (4));

(statearr_71363_71376[(5)] = null);

} else {
throw ex71359;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71356 === (6))){
var inst_71339 = (state_71355[(2)]);
var inst_71340 = fluree.db.util.async.throw_err.call(null,inst_71339);
var inst_71341 = cljs.core.nth.call(null,inst_71340,(0),null);
var inst_71342 = cljs.core.nth.call(null,inst_71340,(1),null);
var inst_71343 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71344 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_71345 = ["?s","?ctx",inst_71341];
var inst_71346 = cljs.core.PersistentHashMap.fromArrays(inst_71344,inst_71345);
var inst_71347 = ((10) + inst_71342);
var inst_71348 = [inst_71346,inst_71347];
var inst_71349 = (new cljs.core.PersistentVector(null,2,(5),inst_71343,inst_71348,null));
var inst_71350 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_71349);
var _ = (function (){var statearr_71364 = state_71355;
(statearr_71364[(4)] = cljs.core.rest.call(null,(state_71355[(4)])));

return statearr_71364;
})();
var state_71355__$1 = (function (){var statearr_71365 = state_71355;
(statearr_71365[(7)] = inst_71350);

return statearr_71365;
})();
var statearr_71366_71377 = state_71355__$1;
(statearr_71366_71377[(2)] = inst_71341);

(statearr_71366_71377[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16221__auto____0 = (function (){
var statearr_71367 = [null,null,null,null,null,null,null,null];
(statearr_71367[(0)] = fluree$db$dbfunctions$fns$state_machine__16221__auto__);

(statearr_71367[(1)] = (1));

return statearr_71367;
});
var fluree$db$dbfunctions$fns$state_machine__16221__auto____1 = (function (state_71355){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_71355);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e71368){var ex__16224__auto__ = e71368;
var statearr_71369_71378 = state_71355;
(statearr_71369_71378[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_71355[(4)]))){
var statearr_71370_71379 = state_71355;
(statearr_71370_71379[(1)] = cljs.core.first.call(null,(state_71355[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71380 = state_71355;
state_71355 = G__71380;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16221__auto__ = function(state_71355){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____1.call(this,state_71355);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_71371 = f__16346__auto__.call(null);
(statearr_71371[(6)] = c__16345__auto__);

return statearr_71371;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__71382 = arguments.length;
switch (G__71382) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_71420){
var state_val_71421 = (state_71420[(1)]);
if((state_val_71421 === (7))){
var inst_71413 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?p from this function interface");
var state_71420__$1 = state_71420;
var statearr_71422_71442 = state_71420__$1;
(statearr_71422_71442[(2)] = inst_71413);

(statearr_71422_71442[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71421 === (1))){
var state_71420__$1 = state_71420;
var statearr_71423_71443 = state_71420__$1;
(statearr_71423_71443[(2)] = null);

(statearr_71423_71443[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71421 === (4))){
var inst_71383 = (state_71420[(2)]);
var state_71420__$1 = state_71420;
var statearr_71424_71444 = state_71420__$1;
(statearr_71424_71444[(2)] = inst_71383);

(statearr_71424_71444[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71421 === (6))){
var inst_71394 = fluree.db.dbfunctions.fns.coerce_args.call(null,additional_select);
var state_71420__$1 = state_71420;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71420__$1,(10),inst_71394);
} else {
if((state_val_71421 === (3))){
var inst_71418 = (state_71420[(2)]);
var state_71420__$1 = state_71420;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71420__$1,inst_71418);
} else {
if((state_val_71421 === (2))){
var _ = (function (){var statearr_71426 = state_71420;
(statearr_71426[(4)] = cljs.core.cons.call(null,(5),(state_71420[(4)])));

return statearr_71426;
})();
var inst_71389 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_71420__$1 = state_71420;
if(cljs.core.truth_(inst_71389)){
var statearr_71427_71445 = state_71420__$1;
(statearr_71427_71445[(1)] = (6));

} else {
var statearr_71428_71446 = state_71420__$1;
(statearr_71428_71446[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71421 === (9))){
var inst_71400 = (state_71420[(2)]);
var inst_71401 = fluree.db.util.async.throw_err.call(null,inst_71400);
var inst_71402 = cljs.core.nth.call(null,inst_71401,(0),null);
var inst_71403 = cljs.core.nth.call(null,inst_71401,(1),null);
var inst_71404 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71405 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_71406 = ["?p","?ctx",inst_71402];
var inst_71407 = cljs.core.PersistentHashMap.fromArrays(inst_71405,inst_71406);
var inst_71408 = ((10) + inst_71403);
var inst_71409 = [inst_71407,inst_71408];
var inst_71410 = (new cljs.core.PersistentVector(null,2,(5),inst_71404,inst_71409,null));
var inst_71411 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_71410);
var state_71420__$1 = (function (){var statearr_71429 = state_71420;
(statearr_71429[(7)] = inst_71411);

return statearr_71429;
})();
var statearr_71430_71447 = state_71420__$1;
(statearr_71430_71447[(2)] = inst_71402);

(statearr_71430_71447[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71421 === (5))){
var _ = (function (){var statearr_71431 = state_71420;
(statearr_71431[(4)] = cljs.core.rest.call(null,(state_71420[(4)])));

return statearr_71431;
})();
var state_71420__$1 = state_71420;
var ex71425 = (state_71420__$1[(2)]);
var statearr_71432_71448 = state_71420__$1;
(statearr_71432_71448[(5)] = ex71425);


if((ex71425 instanceof Error)){
var statearr_71433_71449 = state_71420__$1;
(statearr_71433_71449[(1)] = (4));

(statearr_71433_71449[(5)] = null);

} else {
throw ex71425;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71421 === (10))){
var inst_71396 = (state_71420[(2)]);
var inst_71397 = fluree.db.util.async.throw_err.call(null,inst_71396);
var inst_71398 = fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,inst_71397);
var state_71420__$1 = state_71420;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71420__$1,(9),inst_71398);
} else {
if((state_val_71421 === (8))){
var inst_71415 = (state_71420[(2)]);
var _ = (function (){var statearr_71434 = state_71420;
(statearr_71434[(4)] = cljs.core.rest.call(null,(state_71420[(4)])));

return statearr_71434;
})();
var state_71420__$1 = state_71420;
var statearr_71435_71450 = state_71420__$1;
(statearr_71435_71450[(2)] = inst_71415);

(statearr_71435_71450[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16221__auto____0 = (function (){
var statearr_71436 = [null,null,null,null,null,null,null,null];
(statearr_71436[(0)] = fluree$db$dbfunctions$fns$state_machine__16221__auto__);

(statearr_71436[(1)] = (1));

return statearr_71436;
});
var fluree$db$dbfunctions$fns$state_machine__16221__auto____1 = (function (state_71420){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_71420);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e71437){var ex__16224__auto__ = e71437;
var statearr_71438_71451 = state_71420;
(statearr_71438_71451[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_71420[(4)]))){
var statearr_71439_71452 = state_71420;
(statearr_71439_71452[(1)] = cljs.core.first.call(null,(state_71420[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71453 = state_71420;
state_71420 = G__71453;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16221__auto__ = function(state_71420){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____1.call(this,state_71420);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_71440 = f__16346__auto__.call(null);
(statearr_71440[(6)] = c__16345__auto__);

return statearr_71440;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4824__auto__ = [];
var len__4818__auto___71502 = arguments.length;
var i__4819__auto___71503 = (0);
while(true){
if((i__4819__auto___71503 < len__4818__auto___71502)){
args__4824__auto__.push((arguments[i__4819__auto___71503]));

var G__71504 = (i__4819__auto___71503 + (1));
i__4819__auto___71503 = G__71504;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_71485){
var state_val_71486 = (state_71485[(1)]);
if((state_val_71486 === (1))){
var state_71485__$1 = state_71485;
var statearr_71487_71505 = state_71485__$1;
(statearr_71487_71505[(2)] = null);

(statearr_71487_71505[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71486 === (2))){
var _ = (function (){var statearr_71488 = state_71485;
(statearr_71488[(4)] = cljs.core.cons.call(null,(5),(state_71485[(4)])));

return statearr_71488;
})();
var inst_71462 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_71485__$1 = state_71485;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71485__$1,(6),inst_71462);
} else {
if((state_val_71486 === (3))){
var inst_71483 = (state_71485[(2)]);
var state_71485__$1 = state_71485;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71485__$1,inst_71483);
} else {
if((state_val_71486 === (4))){
var inst_71456 = (state_71485[(2)]);
var state_71485__$1 = state_71485;
var statearr_71490_71506 = state_71485__$1;
(statearr_71490_71506[(2)] = inst_71456);

(statearr_71490_71506[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71486 === (5))){
var _ = (function (){var statearr_71491 = state_71485;
(statearr_71491[(4)] = cljs.core.rest.call(null,(state_71485[(4)])));

return statearr_71491;
})();
var state_71485__$1 = state_71485;
var ex71489 = (state_71485__$1[(2)]);
var statearr_71492_71507 = state_71485__$1;
(statearr_71492_71507[(5)] = ex71489);


if((ex71489 instanceof Error)){
var statearr_71493_71508 = state_71485__$1;
(statearr_71493_71508[(1)] = (4));

(statearr_71493_71508[(5)] = null);

} else {
throw ex71489;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71486 === (6))){
var inst_71464 = (state_71485[(2)]);
var inst_71465 = fluree.db.util.async.throw_err.call(null,inst_71464);
var inst_71466 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.and,inst_71465);
var inst_71467 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71468 = [inst_71465];
var inst_71469 = (new cljs.core.PersistentVector(null,1,(5),inst_71467,inst_71468,null));
var inst_71470 = cljs.core.count.call(null,inst_71469);
var inst_71471 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71472 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_71473 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71474 = [inst_71465];
var inst_71475 = (new cljs.core.PersistentVector(null,1,(5),inst_71473,inst_71474,null));
var inst_71476 = ["and",inst_71475,inst_71466];
var inst_71477 = cljs.core.PersistentHashMap.fromArrays(inst_71472,inst_71476);
var inst_71478 = [inst_71477,inst_71470];
var inst_71479 = (new cljs.core.PersistentVector(null,2,(5),inst_71471,inst_71478,null));
var inst_71480 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_71479);
var _ = (function (){var statearr_71494 = state_71485;
(statearr_71494[(4)] = cljs.core.rest.call(null,(state_71485[(4)])));

return statearr_71494;
})();
var state_71485__$1 = (function (){var statearr_71495 = state_71485;
(statearr_71495[(7)] = inst_71480);

return statearr_71495;
})();
var statearr_71496_71509 = state_71485__$1;
(statearr_71496_71509[(2)] = inst_71466);

(statearr_71496_71509[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16221__auto____0 = (function (){
var statearr_71497 = [null,null,null,null,null,null,null,null];
(statearr_71497[(0)] = fluree$db$dbfunctions$fns$state_machine__16221__auto__);

(statearr_71497[(1)] = (1));

return statearr_71497;
});
var fluree$db$dbfunctions$fns$state_machine__16221__auto____1 = (function (state_71485){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_71485);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e71498){var ex__16224__auto__ = e71498;
var statearr_71499_71510 = state_71485;
(statearr_71499_71510[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_71485[(4)]))){
var statearr_71500_71511 = state_71485;
(statearr_71500_71511[(1)] = cljs.core.first.call(null,(state_71485[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71512 = state_71485;
state_71485 = G__71512;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16221__auto__ = function(state_71485){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____1.call(this,state_71485);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_71501 = f__16346__auto__.call(null);
(statearr_71501[(6)] = c__16345__auto__);

return statearr_71501;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq71454){
var G__71455 = cljs.core.first.call(null,seq71454);
var seq71454__$1 = cljs.core.next.call(null,seq71454);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71455,seq71454__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4824__auto__ = [];
var len__4818__auto___71561 = arguments.length;
var i__4819__auto___71562 = (0);
while(true){
if((i__4819__auto___71562 < len__4818__auto___71561)){
args__4824__auto__.push((arguments[i__4819__auto___71562]));

var G__71563 = (i__4819__auto___71562 + (1));
i__4819__auto___71562 = G__71563;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_71544){
var state_val_71545 = (state_71544[(1)]);
if((state_val_71545 === (1))){
var state_71544__$1 = state_71544;
var statearr_71546_71564 = state_71544__$1;
(statearr_71546_71564[(2)] = null);

(statearr_71546_71564[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71545 === (2))){
var _ = (function (){var statearr_71547 = state_71544;
(statearr_71547[(4)] = cljs.core.cons.call(null,(5),(state_71544[(4)])));

return statearr_71547;
})();
var inst_71521 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_71544__$1 = state_71544;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71544__$1,(6),inst_71521);
} else {
if((state_val_71545 === (3))){
var inst_71542 = (state_71544[(2)]);
var state_71544__$1 = state_71544;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71544__$1,inst_71542);
} else {
if((state_val_71545 === (4))){
var inst_71515 = (state_71544[(2)]);
var state_71544__$1 = state_71544;
var statearr_71549_71565 = state_71544__$1;
(statearr_71549_71565[(2)] = inst_71515);

(statearr_71549_71565[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71545 === (5))){
var _ = (function (){var statearr_71550 = state_71544;
(statearr_71550[(4)] = cljs.core.rest.call(null,(state_71544[(4)])));

return statearr_71550;
})();
var state_71544__$1 = state_71544;
var ex71548 = (state_71544__$1[(2)]);
var statearr_71551_71566 = state_71544__$1;
(statearr_71551_71566[(5)] = ex71548);


if((ex71548 instanceof Error)){
var statearr_71552_71567 = state_71544__$1;
(statearr_71552_71567[(1)] = (4));

(statearr_71552_71567[(5)] = null);

} else {
throw ex71548;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71545 === (6))){
var inst_71523 = (state_71544[(2)]);
var inst_71524 = fluree.db.util.async.throw_err.call(null,inst_71523);
var inst_71525 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.or,inst_71524);
var inst_71526 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71527 = [inst_71524];
var inst_71528 = (new cljs.core.PersistentVector(null,1,(5),inst_71526,inst_71527,null));
var inst_71529 = cljs.core.count.call(null,inst_71528);
var inst_71530 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71531 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_71532 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71533 = [inst_71524];
var inst_71534 = (new cljs.core.PersistentVector(null,1,(5),inst_71532,inst_71533,null));
var inst_71535 = ["or",inst_71534,inst_71525];
var inst_71536 = cljs.core.PersistentHashMap.fromArrays(inst_71531,inst_71535);
var inst_71537 = [inst_71536,inst_71529];
var inst_71538 = (new cljs.core.PersistentVector(null,2,(5),inst_71530,inst_71537,null));
var inst_71539 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_71538);
var _ = (function (){var statearr_71553 = state_71544;
(statearr_71553[(4)] = cljs.core.rest.call(null,(state_71544[(4)])));

return statearr_71553;
})();
var state_71544__$1 = (function (){var statearr_71554 = state_71544;
(statearr_71554[(7)] = inst_71539);

return statearr_71554;
})();
var statearr_71555_71568 = state_71544__$1;
(statearr_71555_71568[(2)] = inst_71525);

(statearr_71555_71568[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16221__auto____0 = (function (){
var statearr_71556 = [null,null,null,null,null,null,null,null];
(statearr_71556[(0)] = fluree$db$dbfunctions$fns$state_machine__16221__auto__);

(statearr_71556[(1)] = (1));

return statearr_71556;
});
var fluree$db$dbfunctions$fns$state_machine__16221__auto____1 = (function (state_71544){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_71544);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e71557){var ex__16224__auto__ = e71557;
var statearr_71558_71569 = state_71544;
(statearr_71558_71569[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_71544[(4)]))){
var statearr_71559_71570 = state_71544;
(statearr_71559_71570[(1)] = cljs.core.first.call(null,(state_71544[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71571 = state_71544;
state_71544 = G__71571;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16221__auto__ = function(state_71544){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____1.call(this,state_71544);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_71560 = f__16346__auto__.call(null);
(statearr_71560[(6)] = c__16345__auto__);

return statearr_71560;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq71513){
var G__71514 = cljs.core.first.call(null,seq71513);
var seq71513__$1 = cljs.core.next.call(null,seq71513);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71514,seq71513__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_71609){
var state_val_71610 = (state_71609[(1)]);
if((state_val_71610 === (7))){
var inst_71585 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_71609__$1 = state_71609;
if(inst_71585){
var statearr_71611_71634 = state_71609__$1;
(statearr_71611_71634[(1)] = (10));

} else {
var statearr_71612_71635 = state_71609__$1;
(statearr_71612_71635[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71610 === (1))){
var state_71609__$1 = state_71609;
var statearr_71613_71636 = state_71609__$1;
(statearr_71613_71636[(2)] = null);

(statearr_71613_71636[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71610 === (4))){
var inst_71572 = (state_71609[(2)]);
var state_71609__$1 = state_71609;
var statearr_71614_71637 = state_71609__$1;
(statearr_71614_71637[(2)] = inst_71572);

(statearr_71614_71637[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71610 === (13))){
var inst_71588 = (state_71609[(2)]);
var inst_71589 = fluree.db.util.async.throw_err.call(null,inst_71588);
var state_71609__$1 = state_71609;
var statearr_71615_71638 = state_71609__$1;
(statearr_71615_71638[(2)] = inst_71589);

(statearr_71615_71638[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71610 === (6))){
var inst_71580 = fluree.db.dbfunctions.fns.coerce_args.call(null,coll);
var state_71609__$1 = state_71609;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71609__$1,(9),inst_71580);
} else {
if((state_val_71610 === (3))){
var inst_71607 = (state_71609[(2)]);
var state_71609__$1 = state_71609;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71609__$1,inst_71607);
} else {
if((state_val_71610 === (12))){
var inst_71592 = (state_71609[(2)]);
var state_71609__$1 = state_71609;
var statearr_71616_71639 = state_71609__$1;
(statearr_71616_71639[(2)] = inst_71592);

(statearr_71616_71639[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71610 === (2))){
var _ = (function (){var statearr_71617 = state_71609;
(statearr_71617[(4)] = cljs.core.cons.call(null,(5),(state_71609[(4)])));

return statearr_71617;
})();
var inst_71578 = cljs.core.vector_QMARK_.call(null,coll);
var state_71609__$1 = state_71609;
if(inst_71578){
var statearr_71618_71640 = state_71609__$1;
(statearr_71618_71640[(1)] = (6));

} else {
var statearr_71619_71641 = state_71609__$1;
(statearr_71619_71641[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71610 === (11))){
var state_71609__$1 = state_71609;
var statearr_71621_71642 = state_71609__$1;
(statearr_71621_71642[(2)] = coll);

(statearr_71621_71642[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71610 === (9))){
var inst_71582 = (state_71609[(2)]);
var inst_71583 = fluree.db.util.async.throw_err.call(null,inst_71582);
var state_71609__$1 = state_71609;
var statearr_71622_71643 = state_71609__$1;
(statearr_71622_71643[(2)] = inst_71583);

(statearr_71622_71643[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71610 === (5))){
var _ = (function (){var statearr_71623 = state_71609;
(statearr_71623[(4)] = cljs.core.rest.call(null,(state_71609[(4)])));

return statearr_71623;
})();
var state_71609__$1 = state_71609;
var ex71620 = (state_71609__$1[(2)]);
var statearr_71624_71644 = state_71609__$1;
(statearr_71624_71644[(5)] = ex71620);


if((ex71620 instanceof Error)){
var statearr_71625_71645 = state_71609__$1;
(statearr_71625_71645[(1)] = (4));

(statearr_71625_71645[(5)] = null);

} else {
throw ex71620;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71610 === (10))){
var state_71609__$1 = state_71609;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71609__$1,(13),coll);
} else {
if((state_val_71610 === (8))){
var inst_71594 = (state_71609[(2)]);
var inst_71595 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_71594);
var inst_71596 = cljs.core.count.call(null,inst_71595);
var inst_71597 = ((9) + inst_71596);
var inst_71598 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71599 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_71600 = ["count",inst_71594,inst_71596];
var inst_71601 = cljs.core.PersistentHashMap.fromArrays(inst_71599,inst_71600);
var inst_71602 = [inst_71601,inst_71597];
var inst_71603 = (new cljs.core.PersistentVector(null,2,(5),inst_71598,inst_71602,null));
var inst_71604 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_71603);
var _ = (function (){var statearr_71626 = state_71609;
(statearr_71626[(4)] = cljs.core.rest.call(null,(state_71609[(4)])));

return statearr_71626;
})();
var state_71609__$1 = (function (){var statearr_71627 = state_71609;
(statearr_71627[(7)] = inst_71604);

return statearr_71627;
})();
var statearr_71628_71646 = state_71609__$1;
(statearr_71628_71646[(2)] = inst_71596);

(statearr_71628_71646[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__16221__auto____0 = (function (){
var statearr_71629 = [null,null,null,null,null,null,null,null];
(statearr_71629[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__16221__auto__);

(statearr_71629[(1)] = (1));

return statearr_71629;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__16221__auto____1 = (function (state_71609){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_71609);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e71630){var ex__16224__auto__ = e71630;
var statearr_71631_71647 = state_71609;
(statearr_71631_71647[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_71609[(4)]))){
var statearr_71632_71648 = state_71609;
(statearr_71632_71648[(1)] = cljs.core.first.call(null,(state_71609[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71649 = state_71609;
state_71609 = G__71649;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__16221__auto__ = function(state_71609){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__16221__auto____1.call(this,state_71609);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_71633 = f__16346__auto__.call(null);
(statearr_71633[(6)] = c__16345__auto__);

return statearr_71633;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_71699){
var state_val_71700 = (state_71699[(1)]);
if((state_val_71700 === (7))){
var state_71699__$1 = state_71699;
var statearr_71701_71734 = state_71699__$1;
(statearr_71701_71734[(2)] = subject);

(statearr_71701_71734[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71700 === (1))){
var state_71699__$1 = state_71699;
var statearr_71702_71735 = state_71699__$1;
(statearr_71702_71735[(2)] = null);

(statearr_71702_71735[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71700 === (4))){
var inst_71650 = (state_71699[(2)]);
var state_71699__$1 = state_71699;
var statearr_71703_71736 = state_71699__$1;
(statearr_71703_71736[(2)] = inst_71650);

(statearr_71703_71736[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71700 === (15))){
var inst_71663 = (state_71699[(7)]);
var state_71699__$1 = state_71699;
var statearr_71704_71737 = state_71699__$1;
(statearr_71704_71737[(2)] = inst_71663);

(statearr_71704_71737[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71700 === (13))){
var inst_71667 = (state_71699[(2)]);
var inst_71668 = fluree.db.util.async.throw_err.call(null,inst_71667);
var state_71699__$1 = state_71699;
var statearr_71705_71738 = state_71699__$1;
(statearr_71705_71738[(2)] = inst_71668);

(statearr_71705_71738[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71700 === (6))){
var state_71699__$1 = state_71699;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71699__$1,(9),subject);
} else {
if((state_val_71700 === (17))){
var inst_71663 = (state_71699[(7)]);
var inst_71677 = cljs.core.first.call(null,inst_71663);
var state_71699__$1 = state_71699;
var statearr_71706_71739 = state_71699__$1;
(statearr_71706_71739[(2)] = inst_71677);

(statearr_71706_71739[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71700 === (3))){
var inst_71697 = (state_71699[(2)]);
var state_71699__$1 = state_71699;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71699__$1,inst_71697);
} else {
if((state_val_71700 === (12))){
var inst_71663 = (state_71699[(7)]);
var inst_71671 = (state_71699[(2)]);
var inst_71672 = cljs.core.vector_QMARK_.call(null,inst_71663);
var state_71699__$1 = (function (){var statearr_71707 = state_71699;
(statearr_71707[(8)] = inst_71671);

return statearr_71707;
})();
if(inst_71672){
var statearr_71708_71740 = state_71699__$1;
(statearr_71708_71740[(1)] = (14));

} else {
var statearr_71709_71741 = state_71699__$1;
(statearr_71709_71741[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71700 === (2))){
var _ = (function (){var statearr_71710 = state_71699;
(statearr_71710[(4)] = cljs.core.cons.call(null,(5),(state_71699[(4)])));

return statearr_71710;
})();
var inst_71656 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_71699__$1 = state_71699;
if(inst_71656){
var statearr_71711_71742 = state_71699__$1;
(statearr_71711_71742[(1)] = (6));

} else {
var statearr_71712_71743 = state_71699__$1;
(statearr_71712_71743[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71700 === (19))){
var inst_71680 = (state_71699[(2)]);
var state_71699__$1 = state_71699;
var statearr_71713_71744 = state_71699__$1;
(statearr_71713_71744[(2)] = inst_71680);

(statearr_71713_71744[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71700 === (11))){
var state_71699__$1 = state_71699;
var statearr_71715_71745 = state_71699__$1;
(statearr_71715_71745[(2)] = pred);

(statearr_71715_71745[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71700 === (9))){
var inst_71659 = (state_71699[(2)]);
var inst_71660 = fluree.db.util.async.throw_err.call(null,inst_71659);
var state_71699__$1 = state_71699;
var statearr_71716_71746 = state_71699__$1;
(statearr_71716_71746[(2)] = inst_71660);

(statearr_71716_71746[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71700 === (5))){
var _ = (function (){var statearr_71717 = state_71699;
(statearr_71717[(4)] = cljs.core.rest.call(null,(state_71699[(4)])));

return statearr_71717;
})();
var state_71699__$1 = state_71699;
var ex71714 = (state_71699__$1[(2)]);
var statearr_71718_71747 = state_71699__$1;
(statearr_71718_71747[(5)] = ex71714);


if((ex71714 instanceof Error)){
var statearr_71719_71748 = state_71699__$1;
(statearr_71719_71748[(1)] = (4));

(statearr_71719_71748[(5)] = null);

} else {
throw ex71714;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71700 === (14))){
var inst_71663 = (state_71699[(7)]);
var inst_71674 = cljs.core.count.call(null,inst_71663);
var inst_71675 = cljs.core._EQ_.call(null,(1),inst_71674);
var state_71699__$1 = state_71699;
if(inst_71675){
var statearr_71720_71749 = state_71699__$1;
(statearr_71720_71749[(1)] = (17));

} else {
var statearr_71721_71750 = state_71699__$1;
(statearr_71721_71750[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71700 === (16))){
var inst_71671 = (state_71699[(8)]);
var inst_71663 = (state_71699[(7)]);
var inst_71683 = (state_71699[(2)]);
var inst_71684 = fluree.db.dbfunctions.internal.get.call(null,inst_71683,inst_71671);
var inst_71685 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71686 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_71687 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71688 = [inst_71663,inst_71671];
var inst_71689 = (new cljs.core.PersistentVector(null,2,(5),inst_71687,inst_71688,null));
var inst_71690 = ["get",inst_71689,inst_71684];
var inst_71691 = cljs.core.PersistentHashMap.fromArrays(inst_71686,inst_71690);
var inst_71692 = [inst_71691,(10)];
var inst_71693 = (new cljs.core.PersistentVector(null,2,(5),inst_71685,inst_71692,null));
var inst_71694 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_71693);
var _ = (function (){var statearr_71722 = state_71699;
(statearr_71722[(4)] = cljs.core.rest.call(null,(state_71699[(4)])));

return statearr_71722;
})();
var state_71699__$1 = (function (){var statearr_71723 = state_71699;
(statearr_71723[(9)] = inst_71694);

return statearr_71723;
})();
var statearr_71724_71751 = state_71699__$1;
(statearr_71724_71751[(2)] = inst_71684);

(statearr_71724_71751[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71700 === (10))){
var state_71699__$1 = state_71699;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71699__$1,(13),pred);
} else {
if((state_val_71700 === (18))){
var inst_71663 = (state_71699[(7)]);
var state_71699__$1 = state_71699;
var statearr_71725_71752 = state_71699__$1;
(statearr_71725_71752[(2)] = inst_71663);

(statearr_71725_71752[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71700 === (8))){
var inst_71663 = (state_71699[(2)]);
var inst_71664 = fluree.db.util.async.channel_QMARK_.call(null,pred);
var state_71699__$1 = (function (){var statearr_71726 = state_71699;
(statearr_71726[(7)] = inst_71663);

return statearr_71726;
})();
if(inst_71664){
var statearr_71727_71753 = state_71699__$1;
(statearr_71727_71753[(1)] = (10));

} else {
var statearr_71728_71754 = state_71699__$1;
(statearr_71728_71754[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__16221__auto____0 = (function (){
var statearr_71729 = [null,null,null,null,null,null,null,null,null,null];
(statearr_71729[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__16221__auto__);

(statearr_71729[(1)] = (1));

return statearr_71729;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__16221__auto____1 = (function (state_71699){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_71699);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e71730){var ex__16224__auto__ = e71730;
var statearr_71731_71755 = state_71699;
(statearr_71731_71755[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_71699[(4)]))){
var statearr_71732_71756 = state_71699;
(statearr_71732_71756[(1)] = cljs.core.first.call(null,(state_71699[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71757 = state_71699;
state_71699 = G__71757;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__16221__auto__ = function(state_71699){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__16221__auto____1.call(this,state_71699);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_71733 = f__16346__auto__.call(null);
(statearr_71733[(6)] = c__16345__auto__);

return statearr_71733;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_71796){
var state_val_71797 = (state_71796[(1)]);
if((state_val_71797 === (7))){
var inst_71764 = (state_71796[(7)]);
var state_71796__$1 = state_71796;
var statearr_71798_71822 = state_71796__$1;
(statearr_71798_71822[(2)] = inst_71764);

(statearr_71798_71822[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71797 === (1))){
var state_71796__$1 = state_71796;
var statearr_71799_71823 = state_71796__$1;
(statearr_71799_71823[(2)] = null);

(statearr_71799_71823[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71797 === (4))){
var inst_71758 = (state_71796[(2)]);
var state_71796__$1 = state_71796;
var statearr_71800_71824 = state_71796__$1;
(statearr_71800_71824[(2)] = inst_71758);

(statearr_71800_71824[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71797 === (6))){
var inst_71766 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_71796__$1 = state_71796;
var statearr_71801_71825 = state_71796__$1;
(statearr_71801_71825[(2)] = inst_71766);

(statearr_71801_71825[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71797 === (3))){
var inst_71794 = (state_71796[(2)]);
var state_71796__$1 = state_71796;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71796__$1,inst_71794);
} else {
if((state_val_71797 === (12))){
var inst_71776 = (state_71796[(2)]);
var inst_71777 = fluree.db.util.async.throw_err.call(null,inst_71776);
var inst_71778 = cljs.core.nth.call(null,inst_71777,(0),null);
var inst_71779 = cljs.core.nth.call(null,inst_71777,(1),null);
var inst_71780 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71781 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_71782 = ["?pO","?ctx",inst_71778];
var inst_71783 = cljs.core.PersistentHashMap.fromArrays(inst_71781,inst_71782);
var inst_71784 = ((10) + inst_71779);
var inst_71785 = [inst_71783,inst_71784];
var inst_71786 = (new cljs.core.PersistentVector(null,2,(5),inst_71780,inst_71785,null));
var inst_71787 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_71786);
var state_71796__$1 = (function (){var statearr_71802 = state_71796;
(statearr_71802[(8)] = inst_71787);

return statearr_71802;
})();
var statearr_71803_71826 = state_71796__$1;
(statearr_71803_71826[(2)] = inst_71778);

(statearr_71803_71826[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71797 === (2))){
var inst_71764 = (state_71796[(7)]);
var _ = (function (){var statearr_71804 = state_71796;
(statearr_71804[(4)] = cljs.core.cons.call(null,(5),(state_71796[(4)])));

return statearr_71804;
})();
var inst_71764__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_71796__$1 = (function (){var statearr_71805 = state_71796;
(statearr_71805[(7)] = inst_71764__$1);

return statearr_71805;
})();
if(cljs.core.truth_(inst_71764__$1)){
var statearr_71806_71827 = state_71796__$1;
(statearr_71806_71827[(1)] = (6));

} else {
var statearr_71807_71828 = state_71796__$1;
(statearr_71807_71828[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71797 === (11))){
var inst_71791 = (state_71796[(2)]);
var _ = (function (){var statearr_71809 = state_71796;
(statearr_71809[(4)] = cljs.core.rest.call(null,(state_71796[(4)])));

return statearr_71809;
})();
var state_71796__$1 = state_71796;
var statearr_71810_71829 = state_71796__$1;
(statearr_71810_71829[(2)] = inst_71791);

(statearr_71810_71829[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71797 === (9))){
var inst_71774 = fluree.db.dbfunctions.internal._QMARK_pO.call(null,_QMARK_ctx);
var state_71796__$1 = state_71796;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71796__$1,(12),inst_71774);
} else {
if((state_val_71797 === (5))){
var _ = (function (){var statearr_71811 = state_71796;
(statearr_71811[(4)] = cljs.core.rest.call(null,(state_71796[(4)])));

return statearr_71811;
})();
var state_71796__$1 = state_71796;
var ex71808 = (state_71796__$1[(2)]);
var statearr_71812_71830 = state_71796__$1;
(statearr_71812_71830[(5)] = ex71808);


if((ex71808 instanceof Error)){
var statearr_71813_71831 = state_71796__$1;
(statearr_71813_71831[(1)] = (4));

(statearr_71813_71831[(5)] = null);

} else {
throw ex71808;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71797 === (10))){
var inst_71789 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_71796__$1 = state_71796;
var statearr_71814_71832 = state_71796__$1;
(statearr_71814_71832[(2)] = inst_71789);

(statearr_71814_71832[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71797 === (8))){
var inst_71769 = (state_71796[(2)]);
var state_71796__$1 = state_71796;
if(cljs.core.truth_(inst_71769)){
var statearr_71815_71833 = state_71796__$1;
(statearr_71815_71833[(1)] = (9));

} else {
var statearr_71816_71834 = state_71796__$1;
(statearr_71816_71834[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16221__auto____0 = (function (){
var statearr_71817 = [null,null,null,null,null,null,null,null,null];
(statearr_71817[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16221__auto__);

(statearr_71817[(1)] = (1));

return statearr_71817;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16221__auto____1 = (function (state_71796){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_71796);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e71818){var ex__16224__auto__ = e71818;
var statearr_71819_71835 = state_71796;
(statearr_71819_71835[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_71796[(4)]))){
var statearr_71820_71836 = state_71796;
(statearr_71820_71836[(1)] = cljs.core.first.call(null,(state_71796[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71837 = state_71796;
state_71796 = G__71837;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16221__auto__ = function(state_71796){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16221__auto____1.call(this,state_71796);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_71821 = f__16346__auto__.call(null);
(statearr_71821[(6)] = c__16345__auto__);

return statearr_71821;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_71889){
var state_val_71890 = (state_71889[(1)]);
if((state_val_71890 === (7))){
var state_71889__$1 = state_71889;
var statearr_71891_71924 = state_71889__$1;
(statearr_71891_71924[(2)] = subject);

(statearr_71891_71924[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (1))){
var state_71889__$1 = state_71889;
var statearr_71892_71925 = state_71889__$1;
(statearr_71892_71925[(2)] = null);

(statearr_71892_71925[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (4))){
var inst_71838 = (state_71889[(2)]);
var state_71889__$1 = state_71889;
var statearr_71893_71926 = state_71889__$1;
(statearr_71893_71926[(2)] = inst_71838);

(statearr_71893_71926[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (15))){
var inst_71851 = (state_71889[(7)]);
var state_71889__$1 = state_71889;
var statearr_71894_71927 = state_71889__$1;
(statearr_71894_71927[(2)] = inst_71851);

(statearr_71894_71927[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (13))){
var inst_71855 = (state_71889[(2)]);
var inst_71856 = fluree.db.util.async.throw_err.call(null,inst_71855);
var state_71889__$1 = state_71889;
var statearr_71895_71928 = state_71889__$1;
(statearr_71895_71928[(2)] = inst_71856);

(statearr_71895_71928[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (6))){
var state_71889__$1 = state_71889;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71889__$1,(9),subject);
} else {
if((state_val_71890 === (17))){
var inst_71851 = (state_71889[(7)]);
var inst_71865 = cljs.core.first.call(null,inst_71851);
var state_71889__$1 = state_71889;
var statearr_71896_71929 = state_71889__$1;
(statearr_71896_71929[(2)] = inst_71865);

(statearr_71896_71929[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (3))){
var inst_71887 = (state_71889[(2)]);
var state_71889__$1 = state_71889;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71889__$1,inst_71887);
} else {
if((state_val_71890 === (12))){
var inst_71851 = (state_71889[(7)]);
var inst_71859 = (state_71889[(2)]);
var inst_71860 = cljs.core.vector_QMARK_.call(null,inst_71851);
var state_71889__$1 = (function (){var statearr_71897 = state_71889;
(statearr_71897[(8)] = inst_71859);

return statearr_71897;
})();
if(inst_71860){
var statearr_71898_71930 = state_71889__$1;
(statearr_71898_71930[(1)] = (14));

} else {
var statearr_71899_71931 = state_71889__$1;
(statearr_71899_71931[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (2))){
var _ = (function (){var statearr_71900 = state_71889;
(statearr_71900[(4)] = cljs.core.cons.call(null,(5),(state_71889[(4)])));

return statearr_71900;
})();
var inst_71844 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_71889__$1 = state_71889;
if(inst_71844){
var statearr_71901_71932 = state_71889__$1;
(statearr_71901_71932[(1)] = (6));

} else {
var statearr_71902_71933 = state_71889__$1;
(statearr_71902_71933[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (19))){
var inst_71868 = (state_71889[(2)]);
var state_71889__$1 = state_71889;
var statearr_71903_71934 = state_71889__$1;
(statearr_71903_71934[(2)] = inst_71868);

(statearr_71903_71934[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (11))){
var state_71889__$1 = state_71889;
var statearr_71905_71935 = state_71889__$1;
(statearr_71905_71935[(2)] = path);

(statearr_71905_71935[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (9))){
var inst_71847 = (state_71889[(2)]);
var inst_71848 = fluree.db.util.async.throw_err.call(null,inst_71847);
var state_71889__$1 = state_71889;
var statearr_71906_71936 = state_71889__$1;
(statearr_71906_71936[(2)] = inst_71848);

(statearr_71906_71936[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (5))){
var _ = (function (){var statearr_71907 = state_71889;
(statearr_71907[(4)] = cljs.core.rest.call(null,(state_71889[(4)])));

return statearr_71907;
})();
var state_71889__$1 = state_71889;
var ex71904 = (state_71889__$1[(2)]);
var statearr_71908_71937 = state_71889__$1;
(statearr_71908_71937[(5)] = ex71904);


if((ex71904 instanceof Error)){
var statearr_71909_71938 = state_71889__$1;
(statearr_71909_71938[(1)] = (4));

(statearr_71909_71938[(5)] = null);

} else {
throw ex71904;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (14))){
var inst_71851 = (state_71889[(7)]);
var inst_71862 = cljs.core.count.call(null,inst_71851);
var inst_71863 = cljs.core._EQ_.call(null,(1),inst_71862);
var state_71889__$1 = state_71889;
if(inst_71863){
var statearr_71910_71939 = state_71889__$1;
(statearr_71910_71939[(1)] = (17));

} else {
var statearr_71911_71940 = state_71889__$1;
(statearr_71911_71940[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (16))){
var inst_71851 = (state_71889[(7)]);
var inst_71859 = (state_71889[(8)]);
var inst_71871 = (state_71889[(2)]);
var inst_71872 = fluree.db.dbfunctions.internal.get_all.call(null,inst_71871,inst_71859);
var inst_71873 = cljs.core.count.call(null,inst_71859);
var inst_71874 = ((9) + inst_71873);
var inst_71875 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71876 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_71877 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71878 = [inst_71851,inst_71859];
var inst_71879 = (new cljs.core.PersistentVector(null,2,(5),inst_71877,inst_71878,null));
var inst_71880 = ["get-all",inst_71879,inst_71872];
var inst_71881 = cljs.core.PersistentHashMap.fromArrays(inst_71876,inst_71880);
var inst_71882 = [inst_71881,inst_71874];
var inst_71883 = (new cljs.core.PersistentVector(null,2,(5),inst_71875,inst_71882,null));
var inst_71884 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_71883);
var _ = (function (){var statearr_71912 = state_71889;
(statearr_71912[(4)] = cljs.core.rest.call(null,(state_71889[(4)])));

return statearr_71912;
})();
var state_71889__$1 = (function (){var statearr_71913 = state_71889;
(statearr_71913[(9)] = inst_71884);

return statearr_71913;
})();
var statearr_71914_71941 = state_71889__$1;
(statearr_71914_71941[(2)] = inst_71872);

(statearr_71914_71941[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (10))){
var state_71889__$1 = state_71889;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71889__$1,(13),path);
} else {
if((state_val_71890 === (18))){
var inst_71851 = (state_71889[(7)]);
var state_71889__$1 = state_71889;
var statearr_71915_71942 = state_71889__$1;
(statearr_71915_71942[(2)] = inst_71851);

(statearr_71915_71942[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71890 === (8))){
var inst_71851 = (state_71889[(2)]);
var inst_71852 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_71889__$1 = (function (){var statearr_71916 = state_71889;
(statearr_71916[(7)] = inst_71851);

return statearr_71916;
})();
if(inst_71852){
var statearr_71917_71943 = state_71889__$1;
(statearr_71917_71943[(1)] = (10));

} else {
var statearr_71918_71944 = state_71889__$1;
(statearr_71918_71944[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__16221__auto____0 = (function (){
var statearr_71919 = [null,null,null,null,null,null,null,null,null,null];
(statearr_71919[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__16221__auto__);

(statearr_71919[(1)] = (1));

return statearr_71919;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__16221__auto____1 = (function (state_71889){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_71889);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e71920){var ex__16224__auto__ = e71920;
var statearr_71921_71945 = state_71889;
(statearr_71921_71945[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_71889[(4)]))){
var statearr_71922_71946 = state_71889;
(statearr_71922_71946[(1)] = cljs.core.first.call(null,(state_71889[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71947 = state_71889;
state_71889 = G__71947;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__16221__auto__ = function(state_71889){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__16221__auto____1.call(this,state_71889);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_71923 = f__16346__auto__.call(null);
(statearr_71923[(6)] = c__16345__auto__);

return statearr_71923;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Returns the value of a nested structure
 */
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_71986){
var state_val_71987 = (state_71986[(1)]);
if((state_val_71987 === (7))){
var state_71986__$1 = state_71986;
var statearr_71988_72012 = state_71986__$1;
(statearr_71988_72012[(2)] = subject);

(statearr_71988_72012[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71987 === (1))){
var state_71986__$1 = state_71986;
var statearr_71989_72013 = state_71986__$1;
(statearr_71989_72013[(2)] = null);

(statearr_71989_72013[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71987 === (4))){
var inst_71948 = (state_71986[(2)]);
var state_71986__$1 = state_71986;
var statearr_71990_72014 = state_71986__$1;
(statearr_71990_72014[(2)] = inst_71948);

(statearr_71990_72014[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71987 === (13))){
var inst_71965 = (state_71986[(2)]);
var inst_71966 = fluree.db.util.async.throw_err.call(null,inst_71965);
var state_71986__$1 = state_71986;
var statearr_71991_72015 = state_71986__$1;
(statearr_71991_72015[(2)] = inst_71966);

(statearr_71991_72015[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71987 === (6))){
var state_71986__$1 = state_71986;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71986__$1,(9),subject);
} else {
if((state_val_71987 === (3))){
var inst_71984 = (state_71986[(2)]);
var state_71986__$1 = state_71986;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71986__$1,inst_71984);
} else {
if((state_val_71987 === (12))){
var inst_71961 = (state_71986[(7)]);
var inst_71969 = (state_71986[(2)]);
var inst_71970 = fluree.db.dbfunctions.internal.get_in.call(null,inst_71961,inst_71969);
var inst_71971 = cljs.core.count.call(null,inst_71969);
var inst_71972 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71973 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_71974 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71975 = [inst_71961,inst_71969];
var inst_71976 = (new cljs.core.PersistentVector(null,2,(5),inst_71974,inst_71975,null));
var inst_71977 = ["get-in",inst_71976,inst_71970];
var inst_71978 = cljs.core.PersistentHashMap.fromArrays(inst_71973,inst_71977);
var inst_71979 = [inst_71978,inst_71971];
var inst_71980 = (new cljs.core.PersistentVector(null,2,(5),inst_71972,inst_71979,null));
var inst_71981 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_71980);
var _ = (function (){var statearr_71992 = state_71986;
(statearr_71992[(4)] = cljs.core.rest.call(null,(state_71986[(4)])));

return statearr_71992;
})();
var state_71986__$1 = (function (){var statearr_71993 = state_71986;
(statearr_71993[(8)] = inst_71981);

return statearr_71993;
})();
var statearr_71994_72016 = state_71986__$1;
(statearr_71994_72016[(2)] = inst_71970);

(statearr_71994_72016[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71987 === (2))){
var _ = (function (){var statearr_71995 = state_71986;
(statearr_71995[(4)] = cljs.core.cons.call(null,(5),(state_71986[(4)])));

return statearr_71995;
})();
var inst_71954 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_71986__$1 = state_71986;
if(inst_71954){
var statearr_71996_72017 = state_71986__$1;
(statearr_71996_72017[(1)] = (6));

} else {
var statearr_71997_72018 = state_71986__$1;
(statearr_71997_72018[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71987 === (11))){
var state_71986__$1 = state_71986;
var statearr_71999_72019 = state_71986__$1;
(statearr_71999_72019[(2)] = path);

(statearr_71999_72019[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71987 === (9))){
var inst_71957 = (state_71986[(2)]);
var inst_71958 = fluree.db.util.async.throw_err.call(null,inst_71957);
var state_71986__$1 = state_71986;
var statearr_72000_72020 = state_71986__$1;
(statearr_72000_72020[(2)] = inst_71958);

(statearr_72000_72020[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71987 === (5))){
var _ = (function (){var statearr_72001 = state_71986;
(statearr_72001[(4)] = cljs.core.rest.call(null,(state_71986[(4)])));

return statearr_72001;
})();
var state_71986__$1 = state_71986;
var ex71998 = (state_71986__$1[(2)]);
var statearr_72002_72021 = state_71986__$1;
(statearr_72002_72021[(5)] = ex71998);


if((ex71998 instanceof Error)){
var statearr_72003_72022 = state_71986__$1;
(statearr_72003_72022[(1)] = (4));

(statearr_72003_72022[(5)] = null);

} else {
throw ex71998;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71987 === (10))){
var state_71986__$1 = state_71986;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71986__$1,(13),path);
} else {
if((state_val_71987 === (8))){
var inst_71961 = (state_71986[(2)]);
var inst_71962 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_71986__$1 = (function (){var statearr_72004 = state_71986;
(statearr_72004[(7)] = inst_71961);

return statearr_72004;
})();
if(inst_71962){
var statearr_72005_72023 = state_71986__$1;
(statearr_72005_72023[(1)] = (10));

} else {
var statearr_72006_72024 = state_71986__$1;
(statearr_72006_72024[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__16221__auto____0 = (function (){
var statearr_72007 = [null,null,null,null,null,null,null,null,null];
(statearr_72007[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__16221__auto__);

(statearr_72007[(1)] = (1));

return statearr_72007;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__16221__auto____1 = (function (state_71986){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_71986);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e72008){var ex__16224__auto__ = e72008;
var statearr_72009_72025 = state_71986;
(statearr_72009_72025[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_71986[(4)]))){
var statearr_72010_72026 = state_71986;
(statearr_72010_72026[(1)] = cljs.core.first.call(null,(state_71986[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72027 = state_71986;
state_71986 = G__72027;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__16221__auto__ = function(state_71986){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__16221__auto____1.call(this,state_71986);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_72011 = f__16346__auto__.call(null);
(statearr_72011[(6)] = c__16345__auto__);

return statearr_72011;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_72072){
var state_val_72073 = (state_72072[(1)]);
if((state_val_72073 === (7))){
var state_72072__$1 = state_72072;
var statearr_72074_72103 = state_72072__$1;
(statearr_72074_72103[(2)] = coll);

(statearr_72074_72103[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72073 === (1))){
var state_72072__$1 = state_72072;
var statearr_72075_72104 = state_72072__$1;
(statearr_72075_72104[(2)] = null);

(statearr_72075_72104[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72073 === (4))){
var inst_72028 = (state_72072[(2)]);
var state_72072__$1 = state_72072;
var statearr_72076_72105 = state_72072__$1;
(statearr_72076_72105[(2)] = inst_72028);

(statearr_72076_72105[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72073 === (15))){
var inst_72048 = (state_72072[(7)]);
var inst_72056 = (state_72072[(2)]);
var inst_72057 = fluree.db.dbfunctions.internal.contains_QMARK_.call(null,inst_72048,inst_72056);
var inst_72058 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72059 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_72060 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72061 = [inst_72048,inst_72056];
var inst_72062 = (new cljs.core.PersistentVector(null,2,(5),inst_72060,inst_72061,null));
var inst_72063 = ["contains?",inst_72062,inst_72057];
var inst_72064 = cljs.core.PersistentHashMap.fromArrays(inst_72059,inst_72063);
var inst_72065 = [inst_72064,(10)];
var inst_72066 = (new cljs.core.PersistentVector(null,2,(5),inst_72058,inst_72065,null));
var inst_72067 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_72066);
var _ = (function (){var statearr_72077 = state_72072;
(statearr_72077[(4)] = cljs.core.rest.call(null,(state_72072[(4)])));

return statearr_72077;
})();
var state_72072__$1 = (function (){var statearr_72078 = state_72072;
(statearr_72078[(8)] = inst_72067);

return statearr_72078;
})();
var statearr_72079_72106 = state_72072__$1;
(statearr_72079_72106[(2)] = inst_72057);

(statearr_72079_72106[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72073 === (13))){
var state_72072__$1 = state_72072;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72072__$1,(16),key);
} else {
if((state_val_72073 === (6))){
var state_72072__$1 = state_72072;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72072__$1,(9),coll);
} else {
if((state_val_72073 === (3))){
var inst_72070 = (state_72072[(2)]);
var state_72072__$1 = state_72072;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72072__$1,inst_72070);
} else {
if((state_val_72073 === (12))){
var inst_72048 = (state_72072[(2)]);
var inst_72049 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_72072__$1 = (function (){var statearr_72080 = state_72072;
(statearr_72080[(7)] = inst_72048);

return statearr_72080;
})();
if(inst_72049){
var statearr_72081_72107 = state_72072__$1;
(statearr_72081_72107[(1)] = (13));

} else {
var statearr_72082_72108 = state_72072__$1;
(statearr_72082_72108[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72073 === (2))){
var _ = (function (){var statearr_72083 = state_72072;
(statearr_72083[(4)] = cljs.core.cons.call(null,(5),(state_72072[(4)])));

return statearr_72083;
})();
var inst_72034 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_72072__$1 = state_72072;
if(inst_72034){
var statearr_72084_72109 = state_72072__$1;
(statearr_72084_72109[(1)] = (6));

} else {
var statearr_72085_72110 = state_72072__$1;
(statearr_72085_72110[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72073 === (11))){
var inst_72041 = (state_72072[(9)]);
var inst_72045 = cljs.core.flatten.call(null,inst_72041);
var inst_72046 = cljs.core.set.call(null,inst_72045);
var state_72072__$1 = state_72072;
var statearr_72087_72111 = state_72072__$1;
(statearr_72087_72111[(2)] = inst_72046);

(statearr_72087_72111[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72073 === (9))){
var inst_72037 = (state_72072[(2)]);
var inst_72038 = fluree.db.util.async.throw_err.call(null,inst_72037);
var state_72072__$1 = state_72072;
var statearr_72088_72112 = state_72072__$1;
(statearr_72088_72112[(2)] = inst_72038);

(statearr_72088_72112[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72073 === (5))){
var _ = (function (){var statearr_72089 = state_72072;
(statearr_72089[(4)] = cljs.core.rest.call(null,(state_72072[(4)])));

return statearr_72089;
})();
var state_72072__$1 = state_72072;
var ex72086 = (state_72072__$1[(2)]);
var statearr_72090_72113 = state_72072__$1;
(statearr_72090_72113[(5)] = ex72086);


if((ex72086 instanceof Error)){
var statearr_72091_72114 = state_72072__$1;
(statearr_72091_72114[(1)] = (4));

(statearr_72091_72114[(5)] = null);

} else {
throw ex72086;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72073 === (14))){
var state_72072__$1 = state_72072;
var statearr_72092_72115 = state_72072__$1;
(statearr_72092_72115[(2)] = key);

(statearr_72092_72115[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72073 === (16))){
var inst_72052 = (state_72072[(2)]);
var inst_72053 = fluree.db.util.async.throw_err.call(null,inst_72052);
var state_72072__$1 = state_72072;
var statearr_72093_72116 = state_72072__$1;
(statearr_72093_72116[(2)] = inst_72053);

(statearr_72093_72116[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72073 === (10))){
var inst_72041 = (state_72072[(9)]);
var state_72072__$1 = state_72072;
var statearr_72094_72117 = state_72072__$1;
(statearr_72094_72117[(2)] = inst_72041);

(statearr_72094_72117[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72073 === (8))){
var inst_72041 = (state_72072[(9)]);
var inst_72041__$1 = (state_72072[(2)]);
var inst_72042 = cljs.core.set_QMARK_.call(null,inst_72041__$1);
var state_72072__$1 = (function (){var statearr_72095 = state_72072;
(statearr_72095[(9)] = inst_72041__$1);

return statearr_72095;
})();
if(inst_72042){
var statearr_72096_72118 = state_72072__$1;
(statearr_72096_72118[(1)] = (10));

} else {
var statearr_72097_72119 = state_72072__$1;
(statearr_72097_72119[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16221__auto____0 = (function (){
var statearr_72098 = [null,null,null,null,null,null,null,null,null,null];
(statearr_72098[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16221__auto__);

(statearr_72098[(1)] = (1));

return statearr_72098;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16221__auto____1 = (function (state_72072){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_72072);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e72099){var ex__16224__auto__ = e72099;
var statearr_72100_72120 = state_72072;
(statearr_72100_72120[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_72072[(4)]))){
var statearr_72101_72121 = state_72072;
(statearr_72101_72121[(1)] = cljs.core.first.call(null,(state_72072[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72122 = state_72072;
state_72072 = G__72122;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16221__auto__ = function(state_72072){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16221__auto____1.call(this,state_72072);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_72102 = f__16346__auto__.call(null);
(statearr_72102[(6)] = c__16345__auto__);

return statearr_72102;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Returns a hash-set of values
 */
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4824__auto__ = [];
var len__4818__auto___72194 = arguments.length;
var i__4819__auto___72195 = (0);
while(true){
if((i__4819__auto___72195 < len__4818__auto___72194)){
args__4824__auto__.push((arguments[i__4819__auto___72195]));

var G__72196 = (i__4819__auto___72195 + (1));
i__4819__auto___72195 = G__72196;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_72168){
var state_val_72169 = (state_72168[(1)]);
if((state_val_72169 === (7))){
var inst_72134 = (state_72168[(7)]);
var inst_72138 = cljs.core.first.call(null,inst_72134);
var inst_72139 = cljs.core.coll_QMARK_.call(null,inst_72138);
var state_72168__$1 = state_72168;
var statearr_72170_72197 = state_72168__$1;
(statearr_72170_72197[(2)] = inst_72139);

(statearr_72170_72197[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72169 === (1))){
var state_72168__$1 = state_72168;
var statearr_72171_72198 = state_72168__$1;
(statearr_72171_72198[(2)] = null);

(statearr_72171_72198[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72169 === (4))){
var inst_72125 = (state_72168[(2)]);
var state_72168__$1 = state_72168;
var statearr_72172_72199 = state_72168__$1;
(statearr_72172_72199[(2)] = inst_72125);

(statearr_72172_72199[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72169 === (6))){
var inst_72136 = (state_72168[(8)]);
var inst_72134 = (state_72168[(7)]);
var inst_72133 = (state_72168[(2)]);
var inst_72134__$1 = fluree.db.util.async.throw_err.call(null,inst_72133);
var inst_72135 = cljs.core.count.call(null,inst_72134__$1);
var inst_72136__$1 = cljs.core._EQ_.call(null,(1),inst_72135);
var state_72168__$1 = (function (){var statearr_72173 = state_72168;
(statearr_72173[(8)] = inst_72136__$1);

(statearr_72173[(7)] = inst_72134__$1);

return statearr_72173;
})();
if(inst_72136__$1){
var statearr_72174_72200 = state_72168__$1;
(statearr_72174_72200[(1)] = (7));

} else {
var statearr_72175_72201 = state_72168__$1;
(statearr_72175_72201[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72169 === (3))){
var inst_72166 = (state_72168[(2)]);
var state_72168__$1 = state_72168;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72168__$1,inst_72166);
} else {
if((state_val_72169 === (12))){
var inst_72147 = (state_72168[(2)]);
var inst_72148 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.hash_set,inst_72147);
var inst_72149 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72150 = [inst_72147];
var inst_72151 = (new cljs.core.PersistentVector(null,1,(5),inst_72149,inst_72150,null));
var inst_72152 = cljs.core.count.call(null,inst_72151);
var inst_72153 = ((9) + inst_72152);
var inst_72154 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72155 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_72156 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72157 = [inst_72147];
var inst_72158 = (new cljs.core.PersistentVector(null,1,(5),inst_72156,inst_72157,null));
var inst_72159 = ["hash-set",inst_72158,inst_72148];
var inst_72160 = cljs.core.PersistentHashMap.fromArrays(inst_72155,inst_72159);
var inst_72161 = [inst_72160,inst_72153];
var inst_72162 = (new cljs.core.PersistentVector(null,2,(5),inst_72154,inst_72161,null));
var inst_72163 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_72162);
var _ = (function (){var statearr_72176 = state_72168;
(statearr_72176[(4)] = cljs.core.rest.call(null,(state_72168[(4)])));

return statearr_72176;
})();
var state_72168__$1 = (function (){var statearr_72177 = state_72168;
(statearr_72177[(9)] = inst_72163);

return statearr_72177;
})();
var statearr_72178_72202 = state_72168__$1;
(statearr_72178_72202[(2)] = inst_72148);

(statearr_72178_72202[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72169 === (2))){
var _ = (function (){var statearr_72179 = state_72168;
(statearr_72179[(4)] = cljs.core.cons.call(null,(5),(state_72168[(4)])));

return statearr_72179;
})();
var inst_72131 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_72168__$1 = state_72168;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72168__$1,(6),inst_72131);
} else {
if((state_val_72169 === (11))){
var inst_72134 = (state_72168[(7)]);
var state_72168__$1 = state_72168;
var statearr_72181_72203 = state_72168__$1;
(statearr_72181_72203[(2)] = inst_72134);

(statearr_72181_72203[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72169 === (9))){
var inst_72142 = (state_72168[(2)]);
var state_72168__$1 = state_72168;
if(cljs.core.truth_(inst_72142)){
var statearr_72182_72204 = state_72168__$1;
(statearr_72182_72204[(1)] = (10));

} else {
var statearr_72183_72205 = state_72168__$1;
(statearr_72183_72205[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72169 === (5))){
var _ = (function (){var statearr_72184 = state_72168;
(statearr_72184[(4)] = cljs.core.rest.call(null,(state_72168[(4)])));

return statearr_72184;
})();
var state_72168__$1 = state_72168;
var ex72180 = (state_72168__$1[(2)]);
var statearr_72185_72206 = state_72168__$1;
(statearr_72185_72206[(5)] = ex72180);


if((ex72180 instanceof Error)){
var statearr_72186_72207 = state_72168__$1;
(statearr_72186_72207[(1)] = (4));

(statearr_72186_72207[(5)] = null);

} else {
throw ex72180;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72169 === (10))){
var inst_72134 = (state_72168[(7)]);
var inst_72144 = cljs.core.first.call(null,inst_72134);
var state_72168__$1 = state_72168;
var statearr_72187_72208 = state_72168__$1;
(statearr_72187_72208[(2)] = inst_72144);

(statearr_72187_72208[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72169 === (8))){
var inst_72136 = (state_72168[(8)]);
var state_72168__$1 = state_72168;
var statearr_72188_72209 = state_72168__$1;
(statearr_72188_72209[(2)] = inst_72136);

(statearr_72188_72209[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16221__auto____0 = (function (){
var statearr_72189 = [null,null,null,null,null,null,null,null,null,null];
(statearr_72189[(0)] = fluree$db$dbfunctions$fns$state_machine__16221__auto__);

(statearr_72189[(1)] = (1));

return statearr_72189;
});
var fluree$db$dbfunctions$fns$state_machine__16221__auto____1 = (function (state_72168){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_72168);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e72190){var ex__16224__auto__ = e72190;
var statearr_72191_72210 = state_72168;
(statearr_72191_72210[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_72168[(4)]))){
var statearr_72192_72211 = state_72168;
(statearr_72192_72211[(1)] = cljs.core.first.call(null,(state_72168[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72212 = state_72168;
state_72168 = G__72212;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16221__auto__ = function(state_72168){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____1.call(this,state_72168);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_72193 = f__16346__auto__.call(null);
(statearr_72193[(6)] = c__16345__auto__);

return statearr_72193;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq72123){
var G__72124 = cljs.core.first.call(null,seq72123);
var seq72123__$1 = cljs.core.next.call(null,seq72123);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72124,seq72123__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___72262 = arguments.length;
var i__4819__auto___72263 = (0);
while(true){
if((i__4819__auto___72263 < len__4818__auto___72262)){
args__4824__auto__.push((arguments[i__4819__auto___72263]));

var G__72264 = (i__4819__auto___72263 + (1));
i__4819__auto___72263 = G__72264;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_72245){
var state_val_72246 = (state_72245[(1)]);
if((state_val_72246 === (1))){
var state_72245__$1 = state_72245;
var statearr_72247_72265 = state_72245__$1;
(statearr_72247_72265[(2)] = null);

(statearr_72247_72265[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72246 === (2))){
var _ = (function (){var statearr_72248 = state_72245;
(statearr_72248[(4)] = cljs.core.cons.call(null,(5),(state_72245[(4)])));

return statearr_72248;
})();
var inst_72221 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_72245__$1 = state_72245;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72245__$1,(6),inst_72221);
} else {
if((state_val_72246 === (3))){
var inst_72243 = (state_72245[(2)]);
var state_72245__$1 = state_72245;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72245__$1,inst_72243);
} else {
if((state_val_72246 === (4))){
var inst_72215 = (state_72245[(2)]);
var state_72245__$1 = state_72245;
var statearr_72250_72266 = state_72245__$1;
(statearr_72250_72266[(2)] = inst_72215);

(statearr_72250_72266[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72246 === (5))){
var _ = (function (){var statearr_72251 = state_72245;
(statearr_72251[(4)] = cljs.core.rest.call(null,(state_72245[(4)])));

return statearr_72251;
})();
var state_72245__$1 = state_72245;
var ex72249 = (state_72245__$1[(2)]);
var statearr_72252_72267 = state_72245__$1;
(statearr_72252_72267[(5)] = ex72249);


if((ex72249 instanceof Error)){
var statearr_72253_72268 = state_72245__$1;
(statearr_72253_72268[(1)] = (4));

(statearr_72253_72268[(5)] = null);

} else {
throw ex72249;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72246 === (6))){
var inst_72223 = (state_72245[(2)]);
var inst_72224 = fluree.db.util.async.throw_err.call(null,inst_72223);
var inst_72225 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._EQ__EQ_,inst_72224);
var inst_72226 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72227 = [inst_72224];
var inst_72228 = (new cljs.core.PersistentVector(null,1,(5),inst_72226,inst_72227,null));
var inst_72229 = cljs.core.count.call(null,inst_72228);
var inst_72230 = ((9) + inst_72229);
var inst_72231 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72232 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_72233 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72234 = [inst_72224];
var inst_72235 = (new cljs.core.PersistentVector(null,1,(5),inst_72233,inst_72234,null));
var inst_72236 = ["==",inst_72235,inst_72225];
var inst_72237 = cljs.core.PersistentHashMap.fromArrays(inst_72232,inst_72236);
var inst_72238 = [inst_72237,inst_72230];
var inst_72239 = (new cljs.core.PersistentVector(null,2,(5),inst_72231,inst_72238,null));
var inst_72240 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_72239);
var _ = (function (){var statearr_72254 = state_72245;
(statearr_72254[(4)] = cljs.core.rest.call(null,(state_72245[(4)])));

return statearr_72254;
})();
var state_72245__$1 = (function (){var statearr_72255 = state_72245;
(statearr_72255[(7)] = inst_72240);

return statearr_72255;
})();
var statearr_72256_72269 = state_72245__$1;
(statearr_72256_72269[(2)] = inst_72225);

(statearr_72256_72269[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16221__auto____0 = (function (){
var statearr_72257 = [null,null,null,null,null,null,null,null];
(statearr_72257[(0)] = fluree$db$dbfunctions$fns$state_machine__16221__auto__);

(statearr_72257[(1)] = (1));

return statearr_72257;
});
var fluree$db$dbfunctions$fns$state_machine__16221__auto____1 = (function (state_72245){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_72245);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e72258){var ex__16224__auto__ = e72258;
var statearr_72259_72270 = state_72245;
(statearr_72259_72270[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_72245[(4)]))){
var statearr_72260_72271 = state_72245;
(statearr_72260_72271[(1)] = cljs.core.first.call(null,(state_72245[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72272 = state_72245;
state_72245 = G__72272;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16221__auto__ = function(state_72245){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____1.call(this,state_72245);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_72261 = f__16346__auto__.call(null);
(statearr_72261[(6)] = c__16345__auto__);

return statearr_72261;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq72213){
var G__72214 = cljs.core.first.call(null,seq72213);
var seq72213__$1 = cljs.core.next.call(null,seq72213);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72214,seq72213__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___72322 = arguments.length;
var i__4819__auto___72323 = (0);
while(true){
if((i__4819__auto___72323 < len__4818__auto___72322)){
args__4824__auto__.push((arguments[i__4819__auto___72323]));

var G__72324 = (i__4819__auto___72323 + (1));
i__4819__auto___72323 = G__72324;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_72305){
var state_val_72306 = (state_72305[(1)]);
if((state_val_72306 === (1))){
var state_72305__$1 = state_72305;
var statearr_72307_72325 = state_72305__$1;
(statearr_72307_72325[(2)] = null);

(statearr_72307_72325[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72306 === (2))){
var _ = (function (){var statearr_72308 = state_72305;
(statearr_72308[(4)] = cljs.core.cons.call(null,(5),(state_72305[(4)])));

return statearr_72308;
})();
var inst_72281 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_72305__$1 = state_72305;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72305__$1,(6),inst_72281);
} else {
if((state_val_72306 === (3))){
var inst_72303 = (state_72305[(2)]);
var state_72305__$1 = state_72305;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72305__$1,inst_72303);
} else {
if((state_val_72306 === (4))){
var inst_72275 = (state_72305[(2)]);
var state_72305__$1 = state_72305;
var statearr_72310_72326 = state_72305__$1;
(statearr_72310_72326[(2)] = inst_72275);

(statearr_72310_72326[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72306 === (5))){
var _ = (function (){var statearr_72311 = state_72305;
(statearr_72311[(4)] = cljs.core.rest.call(null,(state_72305[(4)])));

return statearr_72311;
})();
var state_72305__$1 = state_72305;
var ex72309 = (state_72305__$1[(2)]);
var statearr_72312_72327 = state_72305__$1;
(statearr_72312_72327[(5)] = ex72309);


if((ex72309 instanceof Error)){
var statearr_72313_72328 = state_72305__$1;
(statearr_72313_72328[(1)] = (4));

(statearr_72313_72328[(5)] = null);

} else {
throw ex72309;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72306 === (6))){
var inst_72283 = (state_72305[(2)]);
var inst_72284 = fluree.db.util.async.throw_err.call(null,inst_72283);
var inst_72285 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT_,inst_72284);
var inst_72286 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72287 = [inst_72284];
var inst_72288 = (new cljs.core.PersistentVector(null,1,(5),inst_72286,inst_72287,null));
var inst_72289 = cljs.core.count.call(null,inst_72288);
var inst_72290 = ((9) + inst_72289);
var inst_72291 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72292 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_72293 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72294 = [inst_72284];
var inst_72295 = (new cljs.core.PersistentVector(null,1,(5),inst_72293,inst_72294,null));
var inst_72296 = [">",inst_72295,inst_72285];
var inst_72297 = cljs.core.PersistentHashMap.fromArrays(inst_72292,inst_72296);
var inst_72298 = [inst_72297,inst_72290];
var inst_72299 = (new cljs.core.PersistentVector(null,2,(5),inst_72291,inst_72298,null));
var inst_72300 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_72299);
var _ = (function (){var statearr_72314 = state_72305;
(statearr_72314[(4)] = cljs.core.rest.call(null,(state_72305[(4)])));

return statearr_72314;
})();
var state_72305__$1 = (function (){var statearr_72315 = state_72305;
(statearr_72315[(7)] = inst_72300);

return statearr_72315;
})();
var statearr_72316_72329 = state_72305__$1;
(statearr_72316_72329[(2)] = inst_72285);

(statearr_72316_72329[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16221__auto____0 = (function (){
var statearr_72317 = [null,null,null,null,null,null,null,null];
(statearr_72317[(0)] = fluree$db$dbfunctions$fns$state_machine__16221__auto__);

(statearr_72317[(1)] = (1));

return statearr_72317;
});
var fluree$db$dbfunctions$fns$state_machine__16221__auto____1 = (function (state_72305){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_72305);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e72318){var ex__16224__auto__ = e72318;
var statearr_72319_72330 = state_72305;
(statearr_72319_72330[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_72305[(4)]))){
var statearr_72320_72331 = state_72305;
(statearr_72320_72331[(1)] = cljs.core.first.call(null,(state_72305[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72332 = state_72305;
state_72305 = G__72332;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16221__auto__ = function(state_72305){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____1.call(this,state_72305);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_72321 = f__16346__auto__.call(null);
(statearr_72321[(6)] = c__16345__auto__);

return statearr_72321;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq72273){
var G__72274 = cljs.core.first.call(null,seq72273);
var seq72273__$1 = cljs.core.next.call(null,seq72273);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72274,seq72273__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___72382 = arguments.length;
var i__4819__auto___72383 = (0);
while(true){
if((i__4819__auto___72383 < len__4818__auto___72382)){
args__4824__auto__.push((arguments[i__4819__auto___72383]));

var G__72384 = (i__4819__auto___72383 + (1));
i__4819__auto___72383 = G__72384;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_72365){
var state_val_72366 = (state_72365[(1)]);
if((state_val_72366 === (1))){
var state_72365__$1 = state_72365;
var statearr_72367_72385 = state_72365__$1;
(statearr_72367_72385[(2)] = null);

(statearr_72367_72385[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72366 === (2))){
var _ = (function (){var statearr_72368 = state_72365;
(statearr_72368[(4)] = cljs.core.cons.call(null,(5),(state_72365[(4)])));

return statearr_72368;
})();
var inst_72341 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_72365__$1 = state_72365;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72365__$1,(6),inst_72341);
} else {
if((state_val_72366 === (3))){
var inst_72363 = (state_72365[(2)]);
var state_72365__$1 = state_72365;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72365__$1,inst_72363);
} else {
if((state_val_72366 === (4))){
var inst_72335 = (state_72365[(2)]);
var state_72365__$1 = state_72365;
var statearr_72370_72386 = state_72365__$1;
(statearr_72370_72386[(2)] = inst_72335);

(statearr_72370_72386[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72366 === (5))){
var _ = (function (){var statearr_72371 = state_72365;
(statearr_72371[(4)] = cljs.core.rest.call(null,(state_72365[(4)])));

return statearr_72371;
})();
var state_72365__$1 = state_72365;
var ex72369 = (state_72365__$1[(2)]);
var statearr_72372_72387 = state_72365__$1;
(statearr_72372_72387[(5)] = ex72369);


if((ex72369 instanceof Error)){
var statearr_72373_72388 = state_72365__$1;
(statearr_72373_72388[(1)] = (4));

(statearr_72373_72388[(5)] = null);

} else {
throw ex72369;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72366 === (6))){
var inst_72343 = (state_72365[(2)]);
var inst_72344 = fluree.db.util.async.throw_err.call(null,inst_72343);
var inst_72345 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT_,inst_72344);
var inst_72346 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72347 = [inst_72344];
var inst_72348 = (new cljs.core.PersistentVector(null,1,(5),inst_72346,inst_72347,null));
var inst_72349 = cljs.core.count.call(null,inst_72348);
var inst_72350 = ((9) + inst_72349);
var inst_72351 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72352 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_72353 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72354 = [inst_72344];
var inst_72355 = (new cljs.core.PersistentVector(null,1,(5),inst_72353,inst_72354,null));
var inst_72356 = ["<",inst_72355,inst_72345];
var inst_72357 = cljs.core.PersistentHashMap.fromArrays(inst_72352,inst_72356);
var inst_72358 = [inst_72357,inst_72350];
var inst_72359 = (new cljs.core.PersistentVector(null,2,(5),inst_72351,inst_72358,null));
var inst_72360 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_72359);
var _ = (function (){var statearr_72374 = state_72365;
(statearr_72374[(4)] = cljs.core.rest.call(null,(state_72365[(4)])));

return statearr_72374;
})();
var state_72365__$1 = (function (){var statearr_72375 = state_72365;
(statearr_72375[(7)] = inst_72360);

return statearr_72375;
})();
var statearr_72376_72389 = state_72365__$1;
(statearr_72376_72389[(2)] = inst_72345);

(statearr_72376_72389[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16221__auto____0 = (function (){
var statearr_72377 = [null,null,null,null,null,null,null,null];
(statearr_72377[(0)] = fluree$db$dbfunctions$fns$state_machine__16221__auto__);

(statearr_72377[(1)] = (1));

return statearr_72377;
});
var fluree$db$dbfunctions$fns$state_machine__16221__auto____1 = (function (state_72365){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_72365);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e72378){var ex__16224__auto__ = e72378;
var statearr_72379_72390 = state_72365;
(statearr_72379_72390[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_72365[(4)]))){
var statearr_72380_72391 = state_72365;
(statearr_72380_72391[(1)] = cljs.core.first.call(null,(state_72365[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72392 = state_72365;
state_72365 = G__72392;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16221__auto__ = function(state_72365){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____1.call(this,state_72365);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_72381 = f__16346__auto__.call(null);
(statearr_72381[(6)] = c__16345__auto__);

return statearr_72381;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq72333){
var G__72334 = cljs.core.first.call(null,seq72333);
var seq72333__$1 = cljs.core.next.call(null,seq72333);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72334,seq72333__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___72442 = arguments.length;
var i__4819__auto___72443 = (0);
while(true){
if((i__4819__auto___72443 < len__4818__auto___72442)){
args__4824__auto__.push((arguments[i__4819__auto___72443]));

var G__72444 = (i__4819__auto___72443 + (1));
i__4819__auto___72443 = G__72444;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_72425){
var state_val_72426 = (state_72425[(1)]);
if((state_val_72426 === (1))){
var state_72425__$1 = state_72425;
var statearr_72427_72445 = state_72425__$1;
(statearr_72427_72445[(2)] = null);

(statearr_72427_72445[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72426 === (2))){
var _ = (function (){var statearr_72428 = state_72425;
(statearr_72428[(4)] = cljs.core.cons.call(null,(5),(state_72425[(4)])));

return statearr_72428;
})();
var inst_72401 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_72425__$1 = state_72425;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72425__$1,(6),inst_72401);
} else {
if((state_val_72426 === (3))){
var inst_72423 = (state_72425[(2)]);
var state_72425__$1 = state_72425;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72425__$1,inst_72423);
} else {
if((state_val_72426 === (4))){
var inst_72395 = (state_72425[(2)]);
var state_72425__$1 = state_72425;
var statearr_72430_72446 = state_72425__$1;
(statearr_72430_72446[(2)] = inst_72395);

(statearr_72430_72446[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72426 === (5))){
var _ = (function (){var statearr_72431 = state_72425;
(statearr_72431[(4)] = cljs.core.rest.call(null,(state_72425[(4)])));

return statearr_72431;
})();
var state_72425__$1 = state_72425;
var ex72429 = (state_72425__$1[(2)]);
var statearr_72432_72447 = state_72425__$1;
(statearr_72432_72447[(5)] = ex72429);


if((ex72429 instanceof Error)){
var statearr_72433_72448 = state_72425__$1;
(statearr_72433_72448[(1)] = (4));

(statearr_72433_72448[(5)] = null);

} else {
throw ex72429;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72426 === (6))){
var inst_72403 = (state_72425[(2)]);
var inst_72404 = fluree.db.util.async.throw_err.call(null,inst_72403);
var inst_72405 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT__EQ_,inst_72404);
var inst_72406 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72407 = [inst_72404];
var inst_72408 = (new cljs.core.PersistentVector(null,1,(5),inst_72406,inst_72407,null));
var inst_72409 = cljs.core.count.call(null,inst_72408);
var inst_72410 = ((9) + inst_72409);
var inst_72411 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72412 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_72413 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72414 = [inst_72404];
var inst_72415 = (new cljs.core.PersistentVector(null,1,(5),inst_72413,inst_72414,null));
var inst_72416 = ["<=",inst_72415,inst_72405];
var inst_72417 = cljs.core.PersistentHashMap.fromArrays(inst_72412,inst_72416);
var inst_72418 = [inst_72417,inst_72410];
var inst_72419 = (new cljs.core.PersistentVector(null,2,(5),inst_72411,inst_72418,null));
var inst_72420 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_72419);
var _ = (function (){var statearr_72434 = state_72425;
(statearr_72434[(4)] = cljs.core.rest.call(null,(state_72425[(4)])));

return statearr_72434;
})();
var state_72425__$1 = (function (){var statearr_72435 = state_72425;
(statearr_72435[(7)] = inst_72420);

return statearr_72435;
})();
var statearr_72436_72449 = state_72425__$1;
(statearr_72436_72449[(2)] = inst_72405);

(statearr_72436_72449[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16221__auto____0 = (function (){
var statearr_72437 = [null,null,null,null,null,null,null,null];
(statearr_72437[(0)] = fluree$db$dbfunctions$fns$state_machine__16221__auto__);

(statearr_72437[(1)] = (1));

return statearr_72437;
});
var fluree$db$dbfunctions$fns$state_machine__16221__auto____1 = (function (state_72425){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_72425);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e72438){var ex__16224__auto__ = e72438;
var statearr_72439_72450 = state_72425;
(statearr_72439_72450[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_72425[(4)]))){
var statearr_72440_72451 = state_72425;
(statearr_72440_72451[(1)] = cljs.core.first.call(null,(state_72425[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72452 = state_72425;
state_72425 = G__72452;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16221__auto__ = function(state_72425){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____1.call(this,state_72425);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_72441 = f__16346__auto__.call(null);
(statearr_72441[(6)] = c__16345__auto__);

return statearr_72441;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq72393){
var G__72394 = cljs.core.first.call(null,seq72393);
var seq72393__$1 = cljs.core.next.call(null,seq72393);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72394,seq72393__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___72502 = arguments.length;
var i__4819__auto___72503 = (0);
while(true){
if((i__4819__auto___72503 < len__4818__auto___72502)){
args__4824__auto__.push((arguments[i__4819__auto___72503]));

var G__72504 = (i__4819__auto___72503 + (1));
i__4819__auto___72503 = G__72504;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_72485){
var state_val_72486 = (state_72485[(1)]);
if((state_val_72486 === (1))){
var state_72485__$1 = state_72485;
var statearr_72487_72505 = state_72485__$1;
(statearr_72487_72505[(2)] = null);

(statearr_72487_72505[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72486 === (2))){
var _ = (function (){var statearr_72488 = state_72485;
(statearr_72488[(4)] = cljs.core.cons.call(null,(5),(state_72485[(4)])));

return statearr_72488;
})();
var inst_72461 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_72485__$1 = state_72485;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72485__$1,(6),inst_72461);
} else {
if((state_val_72486 === (3))){
var inst_72483 = (state_72485[(2)]);
var state_72485__$1 = state_72485;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72485__$1,inst_72483);
} else {
if((state_val_72486 === (4))){
var inst_72455 = (state_72485[(2)]);
var state_72485__$1 = state_72485;
var statearr_72490_72506 = state_72485__$1;
(statearr_72490_72506[(2)] = inst_72455);

(statearr_72490_72506[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72486 === (5))){
var _ = (function (){var statearr_72491 = state_72485;
(statearr_72491[(4)] = cljs.core.rest.call(null,(state_72485[(4)])));

return statearr_72491;
})();
var state_72485__$1 = state_72485;
var ex72489 = (state_72485__$1[(2)]);
var statearr_72492_72507 = state_72485__$1;
(statearr_72492_72507[(5)] = ex72489);


if((ex72489 instanceof Error)){
var statearr_72493_72508 = state_72485__$1;
(statearr_72493_72508[(1)] = (4));

(statearr_72493_72508[(5)] = null);

} else {
throw ex72489;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72486 === (6))){
var inst_72463 = (state_72485[(2)]);
var inst_72464 = fluree.db.util.async.throw_err.call(null,inst_72463);
var inst_72465 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT__EQ_,inst_72464);
var inst_72466 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72467 = [inst_72464];
var inst_72468 = (new cljs.core.PersistentVector(null,1,(5),inst_72466,inst_72467,null));
var inst_72469 = cljs.core.count.call(null,inst_72468);
var inst_72470 = ((9) + inst_72469);
var inst_72471 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72472 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_72473 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72474 = [inst_72464];
var inst_72475 = (new cljs.core.PersistentVector(null,1,(5),inst_72473,inst_72474,null));
var inst_72476 = [">=",inst_72475,inst_72465];
var inst_72477 = cljs.core.PersistentHashMap.fromArrays(inst_72472,inst_72476);
var inst_72478 = [inst_72477,inst_72470];
var inst_72479 = (new cljs.core.PersistentVector(null,2,(5),inst_72471,inst_72478,null));
var inst_72480 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_72479);
var _ = (function (){var statearr_72494 = state_72485;
(statearr_72494[(4)] = cljs.core.rest.call(null,(state_72485[(4)])));

return statearr_72494;
})();
var state_72485__$1 = (function (){var statearr_72495 = state_72485;
(statearr_72495[(7)] = inst_72480);

return statearr_72495;
})();
var statearr_72496_72509 = state_72485__$1;
(statearr_72496_72509[(2)] = inst_72465);

(statearr_72496_72509[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16221__auto____0 = (function (){
var statearr_72497 = [null,null,null,null,null,null,null,null];
(statearr_72497[(0)] = fluree$db$dbfunctions$fns$state_machine__16221__auto__);

(statearr_72497[(1)] = (1));

return statearr_72497;
});
var fluree$db$dbfunctions$fns$state_machine__16221__auto____1 = (function (state_72485){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_72485);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e72498){var ex__16224__auto__ = e72498;
var statearr_72499_72510 = state_72485;
(statearr_72499_72510[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_72485[(4)]))){
var statearr_72500_72511 = state_72485;
(statearr_72500_72511[(1)] = cljs.core.first.call(null,(state_72485[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72512 = state_72485;
state_72485 = G__72512;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16221__auto__ = function(state_72485){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____1.call(this,state_72485);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_72501 = f__16346__auto__.call(null);
(statearr_72501[(6)] = c__16345__auto__);

return statearr_72501;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq72453){
var G__72454 = cljs.core.first.call(null,seq72453);
var seq72453__$1 = cljs.core.next.call(null,seq72453);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72454,seq72453__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___72562 = arguments.length;
var i__4819__auto___72563 = (0);
while(true){
if((i__4819__auto___72563 < len__4818__auto___72562)){
args__4824__auto__.push((arguments[i__4819__auto___72563]));

var G__72564 = (i__4819__auto___72563 + (1));
i__4819__auto___72563 = G__72564;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_72545){
var state_val_72546 = (state_72545[(1)]);
if((state_val_72546 === (1))){
var state_72545__$1 = state_72545;
var statearr_72547_72565 = state_72545__$1;
(statearr_72547_72565[(2)] = null);

(statearr_72547_72565[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72546 === (2))){
var _ = (function (){var statearr_72548 = state_72545;
(statearr_72548[(4)] = cljs.core.cons.call(null,(5),(state_72545[(4)])));

return statearr_72548;
})();
var inst_72521 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_72545__$1 = state_72545;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72545__$1,(6),inst_72521);
} else {
if((state_val_72546 === (3))){
var inst_72543 = (state_72545[(2)]);
var state_72545__$1 = state_72545;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72545__$1,inst_72543);
} else {
if((state_val_72546 === (4))){
var inst_72515 = (state_72545[(2)]);
var state_72545__$1 = state_72545;
var statearr_72550_72566 = state_72545__$1;
(statearr_72550_72566[(2)] = inst_72515);

(statearr_72550_72566[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72546 === (5))){
var _ = (function (){var statearr_72551 = state_72545;
(statearr_72551[(4)] = cljs.core.rest.call(null,(state_72545[(4)])));

return statearr_72551;
})();
var state_72545__$1 = state_72545;
var ex72549 = (state_72545__$1[(2)]);
var statearr_72552_72567 = state_72545__$1;
(statearr_72552_72567[(5)] = ex72549);


if((ex72549 instanceof Error)){
var statearr_72553_72568 = state_72545__$1;
(statearr_72553_72568[(1)] = (4));

(statearr_72553_72568[(5)] = null);

} else {
throw ex72549;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72546 === (6))){
var inst_72523 = (state_72545[(2)]);
var inst_72524 = fluree.db.util.async.throw_err.call(null,inst_72523);
var inst_72525 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.not_EQ_,inst_72524);
var inst_72526 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72527 = [inst_72524];
var inst_72528 = (new cljs.core.PersistentVector(null,1,(5),inst_72526,inst_72527,null));
var inst_72529 = cljs.core.count.call(null,inst_72528);
var inst_72530 = ((9) + inst_72529);
var inst_72531 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72532 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_72533 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72534 = [inst_72524];
var inst_72535 = (new cljs.core.PersistentVector(null,1,(5),inst_72533,inst_72534,null));
var inst_72536 = ["not=",inst_72535,inst_72525];
var inst_72537 = cljs.core.PersistentHashMap.fromArrays(inst_72532,inst_72536);
var inst_72538 = [inst_72537,inst_72530];
var inst_72539 = (new cljs.core.PersistentVector(null,2,(5),inst_72531,inst_72538,null));
var inst_72540 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_72539);
var _ = (function (){var statearr_72554 = state_72545;
(statearr_72554[(4)] = cljs.core.rest.call(null,(state_72545[(4)])));

return statearr_72554;
})();
var state_72545__$1 = (function (){var statearr_72555 = state_72545;
(statearr_72555[(7)] = inst_72540);

return statearr_72555;
})();
var statearr_72556_72569 = state_72545__$1;
(statearr_72556_72569[(2)] = inst_72525);

(statearr_72556_72569[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16221__auto____0 = (function (){
var statearr_72557 = [null,null,null,null,null,null,null,null];
(statearr_72557[(0)] = fluree$db$dbfunctions$fns$state_machine__16221__auto__);

(statearr_72557[(1)] = (1));

return statearr_72557;
});
var fluree$db$dbfunctions$fns$state_machine__16221__auto____1 = (function (state_72545){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_72545);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e72558){var ex__16224__auto__ = e72558;
var statearr_72559_72570 = state_72545;
(statearr_72559_72570[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_72545[(4)]))){
var statearr_72560_72571 = state_72545;
(statearr_72560_72571[(1)] = cljs.core.first.call(null,(state_72545[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72572 = state_72545;
state_72545 = G__72572;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16221__auto__ = function(state_72545){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____1.call(this,state_72545);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_72561 = f__16346__auto__.call(null);
(statearr_72561[(6)] = c__16345__auto__);

return statearr_72561;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq72513){
var G__72514 = cljs.core.first.call(null,seq72513);
var seq72513__$1 = cljs.core.next.call(null,seq72513);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72514,seq72513__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4824__auto__ = [];
var len__4818__auto___72622 = arguments.length;
var i__4819__auto___72623 = (0);
while(true){
if((i__4819__auto___72623 < len__4818__auto___72622)){
args__4824__auto__.push((arguments[i__4819__auto___72623]));

var G__72624 = (i__4819__auto___72623 + (1));
i__4819__auto___72623 = G__72624;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_72605){
var state_val_72606 = (state_72605[(1)]);
if((state_val_72606 === (1))){
var state_72605__$1 = state_72605;
var statearr_72607_72625 = state_72605__$1;
(statearr_72607_72625[(2)] = null);

(statearr_72607_72625[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72606 === (2))){
var _ = (function (){var statearr_72608 = state_72605;
(statearr_72608[(4)] = cljs.core.cons.call(null,(5),(state_72605[(4)])));

return statearr_72608;
})();
var inst_72581 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_72605__$1 = state_72605;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72605__$1,(6),inst_72581);
} else {
if((state_val_72606 === (3))){
var inst_72603 = (state_72605[(2)]);
var state_72605__$1 = state_72605;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72605__$1,inst_72603);
} else {
if((state_val_72606 === (4))){
var inst_72575 = (state_72605[(2)]);
var state_72605__$1 = state_72605;
var statearr_72610_72626 = state_72605__$1;
(statearr_72610_72626[(2)] = inst_72575);

(statearr_72610_72626[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72606 === (5))){
var _ = (function (){var statearr_72611 = state_72605;
(statearr_72611[(4)] = cljs.core.rest.call(null,(state_72605[(4)])));

return statearr_72611;
})();
var state_72605__$1 = state_72605;
var ex72609 = (state_72605__$1[(2)]);
var statearr_72612_72627 = state_72605__$1;
(statearr_72612_72627[(5)] = ex72609);


if((ex72609 instanceof Error)){
var statearr_72613_72628 = state_72605__$1;
(statearr_72613_72628[(1)] = (4));

(statearr_72613_72628[(5)] = null);

} else {
throw ex72609;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72606 === (6))){
var inst_72583 = (state_72605[(2)]);
var inst_72584 = fluree.db.util.async.throw_err.call(null,inst_72583);
var inst_72585 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_72584);
var inst_72586 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72587 = [inst_72584];
var inst_72588 = (new cljs.core.PersistentVector(null,1,(5),inst_72586,inst_72587,null));
var inst_72589 = cljs.core.count.call(null,inst_72588);
var inst_72590 = ((9) + inst_72589);
var inst_72591 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72592 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_72593 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72594 = [inst_72584];
var inst_72595 = (new cljs.core.PersistentVector(null,1,(5),inst_72593,inst_72594,null));
var inst_72596 = ["max",inst_72595,inst_72585];
var inst_72597 = cljs.core.PersistentHashMap.fromArrays(inst_72592,inst_72596);
var inst_72598 = [inst_72597,inst_72590];
var inst_72599 = (new cljs.core.PersistentVector(null,2,(5),inst_72591,inst_72598,null));
var inst_72600 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_72599);
var _ = (function (){var statearr_72614 = state_72605;
(statearr_72614[(4)] = cljs.core.rest.call(null,(state_72605[(4)])));

return statearr_72614;
})();
var state_72605__$1 = (function (){var statearr_72615 = state_72605;
(statearr_72615[(7)] = inst_72600);

return statearr_72615;
})();
var statearr_72616_72629 = state_72605__$1;
(statearr_72616_72629[(2)] = inst_72585);

(statearr_72616_72629[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16221__auto____0 = (function (){
var statearr_72617 = [null,null,null,null,null,null,null,null];
(statearr_72617[(0)] = fluree$db$dbfunctions$fns$state_machine__16221__auto__);

(statearr_72617[(1)] = (1));

return statearr_72617;
});
var fluree$db$dbfunctions$fns$state_machine__16221__auto____1 = (function (state_72605){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_72605);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e72618){var ex__16224__auto__ = e72618;
var statearr_72619_72630 = state_72605;
(statearr_72619_72630[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_72605[(4)]))){
var statearr_72620_72631 = state_72605;
(statearr_72620_72631[(1)] = cljs.core.first.call(null,(state_72605[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72632 = state_72605;
state_72605 = G__72632;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16221__auto__ = function(state_72605){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____1.call(this,state_72605);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_72621 = f__16346__auto__.call(null);
(statearr_72621[(6)] = c__16345__auto__);

return statearr_72621;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq72573){
var G__72574 = cljs.core.first.call(null,seq72573);
var seq72573__$1 = cljs.core.next.call(null,seq72573);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72574,seq72573__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4824__auto__ = [];
var len__4818__auto___72682 = arguments.length;
var i__4819__auto___72683 = (0);
while(true){
if((i__4819__auto___72683 < len__4818__auto___72682)){
args__4824__auto__.push((arguments[i__4819__auto___72683]));

var G__72684 = (i__4819__auto___72683 + (1));
i__4819__auto___72683 = G__72684;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_72665){
var state_val_72666 = (state_72665[(1)]);
if((state_val_72666 === (1))){
var state_72665__$1 = state_72665;
var statearr_72667_72685 = state_72665__$1;
(statearr_72667_72685[(2)] = null);

(statearr_72667_72685[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72666 === (2))){
var _ = (function (){var statearr_72668 = state_72665;
(statearr_72668[(4)] = cljs.core.cons.call(null,(5),(state_72665[(4)])));

return statearr_72668;
})();
var inst_72641 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_72665__$1 = state_72665;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72665__$1,(6),inst_72641);
} else {
if((state_val_72666 === (3))){
var inst_72663 = (state_72665[(2)]);
var state_72665__$1 = state_72665;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72665__$1,inst_72663);
} else {
if((state_val_72666 === (4))){
var inst_72635 = (state_72665[(2)]);
var state_72665__$1 = state_72665;
var statearr_72670_72686 = state_72665__$1;
(statearr_72670_72686[(2)] = inst_72635);

(statearr_72670_72686[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72666 === (5))){
var _ = (function (){var statearr_72671 = state_72665;
(statearr_72671[(4)] = cljs.core.rest.call(null,(state_72665[(4)])));

return statearr_72671;
})();
var state_72665__$1 = state_72665;
var ex72669 = (state_72665__$1[(2)]);
var statearr_72672_72687 = state_72665__$1;
(statearr_72672_72687[(5)] = ex72669);


if((ex72669 instanceof Error)){
var statearr_72673_72688 = state_72665__$1;
(statearr_72673_72688[(1)] = (4));

(statearr_72673_72688[(5)] = null);

} else {
throw ex72669;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72666 === (6))){
var inst_72643 = (state_72665[(2)]);
var inst_72644 = fluree.db.util.async.throw_err.call(null,inst_72643);
var inst_72645 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.min,inst_72644);
var inst_72646 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72647 = [inst_72644];
var inst_72648 = (new cljs.core.PersistentVector(null,1,(5),inst_72646,inst_72647,null));
var inst_72649 = cljs.core.count.call(null,inst_72648);
var inst_72650 = ((9) + inst_72649);
var inst_72651 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72652 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_72653 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72654 = [inst_72644];
var inst_72655 = (new cljs.core.PersistentVector(null,1,(5),inst_72653,inst_72654,null));
var inst_72656 = ["min",inst_72655,inst_72645];
var inst_72657 = cljs.core.PersistentHashMap.fromArrays(inst_72652,inst_72656);
var inst_72658 = [inst_72657,inst_72650];
var inst_72659 = (new cljs.core.PersistentVector(null,2,(5),inst_72651,inst_72658,null));
var inst_72660 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_72659);
var _ = (function (){var statearr_72674 = state_72665;
(statearr_72674[(4)] = cljs.core.rest.call(null,(state_72665[(4)])));

return statearr_72674;
})();
var state_72665__$1 = (function (){var statearr_72675 = state_72665;
(statearr_72675[(7)] = inst_72660);

return statearr_72675;
})();
var statearr_72676_72689 = state_72665__$1;
(statearr_72676_72689[(2)] = inst_72645);

(statearr_72676_72689[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16221__auto____0 = (function (){
var statearr_72677 = [null,null,null,null,null,null,null,null];
(statearr_72677[(0)] = fluree$db$dbfunctions$fns$state_machine__16221__auto__);

(statearr_72677[(1)] = (1));

return statearr_72677;
});
var fluree$db$dbfunctions$fns$state_machine__16221__auto____1 = (function (state_72665){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_72665);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e72678){var ex__16224__auto__ = e72678;
var statearr_72679_72690 = state_72665;
(statearr_72679_72690[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_72665[(4)]))){
var statearr_72680_72691 = state_72665;
(statearr_72680_72691[(1)] = cljs.core.first.call(null,(state_72665[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72692 = state_72665;
state_72665 = G__72692;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16221__auto__ = function(state_72665){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____1.call(this,state_72665);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_72681 = f__16346__auto__.call(null);
(statearr_72681[(6)] = c__16345__auto__);

return statearr_72681;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq72633){
var G__72634 = cljs.core.first.call(null,seq72633);
var seq72633__$1 = cljs.core.next.call(null,seq72633);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72634,seq72633__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__72694 = arguments.length;
switch (G__72694) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_72739){
var state_val_72740 = (state_72739[(1)]);
if((state_val_72740 === (7))){
var state_72739__$1 = state_72739;
var statearr_72741_72878 = state_72739__$1;
(statearr_72741_72878[(2)] = query_map);

(statearr_72741_72878[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72740 === (1))){
var state_72739__$1 = state_72739;
var statearr_72742_72879 = state_72739__$1;
(statearr_72742_72879[(2)] = null);

(statearr_72742_72879[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72740 === (4))){
var inst_72695 = (state_72739[(2)]);
var state_72739__$1 = state_72739;
var statearr_72743_72880 = state_72739__$1;
(statearr_72743_72880[(2)] = inst_72695);

(statearr_72743_72880[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72740 === (13))){
var inst_72717 = (state_72739[(7)]);
var inst_72721 = (state_72739[(2)]);
var inst_72722 = fluree.db.util.async.throw_err.call(null,inst_72721);
var inst_72723 = cljs.core.nth.call(null,inst_72722,(0),null);
var inst_72724 = cljs.core.nth.call(null,inst_72722,(1),null);
var inst_72725 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72726 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_72727 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72728 = [inst_72717];
var inst_72729 = (new cljs.core.PersistentVector(null,1,(5),inst_72727,inst_72728,null));
var inst_72730 = ["query",inst_72729,inst_72723];
var inst_72731 = cljs.core.PersistentHashMap.fromArrays(inst_72726,inst_72730);
var inst_72732 = [inst_72731,inst_72724];
var inst_72733 = (new cljs.core.PersistentVector(null,2,(5),inst_72725,inst_72732,null));
var inst_72734 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_72733);
var _ = (function (){var statearr_72744 = state_72739;
(statearr_72744[(4)] = cljs.core.rest.call(null,(state_72739[(4)])));

return statearr_72744;
})();
var state_72739__$1 = (function (){var statearr_72745 = state_72739;
(statearr_72745[(8)] = inst_72734);

return statearr_72745;
})();
var statearr_72746_72881 = state_72739__$1;
(statearr_72746_72881[(2)] = inst_72723);

(statearr_72746_72881[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72740 === (6))){
var state_72739__$1 = state_72739;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72739__$1,(9),query_map);
} else {
if((state_val_72740 === (3))){
var inst_72737 = (state_72739[(2)]);
var state_72739__$1 = state_72739;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72739__$1,inst_72737);
} else {
if((state_val_72740 === (12))){
var inst_72717 = (state_72739[(7)]);
var inst_72717__$1 = (state_72739[(2)]);
var inst_72718 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_72719 = fluree.db.dbfunctions.internal.query.call(null,inst_72718,inst_72717__$1);
var state_72739__$1 = (function (){var statearr_72747 = state_72739;
(statearr_72747[(7)] = inst_72717__$1);

return statearr_72747;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72739__$1,(13),inst_72719);
} else {
if((state_val_72740 === (2))){
var _ = (function (){var statearr_72748 = state_72739;
(statearr_72748[(4)] = cljs.core.cons.call(null,(5),(state_72739[(4)])));

return statearr_72748;
})();
var inst_72704 = fluree.db.util.async.channel_QMARK_.call(null,query_map);
var state_72739__$1 = state_72739;
if(inst_72704){
var statearr_72749_72882 = state_72739__$1;
(statearr_72749_72882[(1)] = (6));

} else {
var statearr_72750_72883 = state_72739__$1;
(statearr_72750_72883[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72740 === (11))){
var inst_72711 = (state_72739[(9)]);
var state_72739__$1 = state_72739;
var statearr_72752_72884 = state_72739__$1;
(statearr_72752_72884[(2)] = inst_72711);

(statearr_72752_72884[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72740 === (9))){
var inst_72707 = (state_72739[(2)]);
var inst_72708 = fluree.db.util.async.throw_err.call(null,inst_72707);
var state_72739__$1 = state_72739;
var statearr_72753_72885 = state_72739__$1;
(statearr_72753_72885[(2)] = inst_72708);

(statearr_72753_72885[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72740 === (5))){
var _ = (function (){var statearr_72754 = state_72739;
(statearr_72754[(4)] = cljs.core.rest.call(null,(state_72739[(4)])));

return statearr_72754;
})();
var state_72739__$1 = state_72739;
var ex72751 = (state_72739__$1[(2)]);
var statearr_72755_72886 = state_72739__$1;
(statearr_72755_72886[(5)] = ex72751);


if((ex72751 instanceof Error)){
var statearr_72756_72887 = state_72739__$1;
(statearr_72756_72887[(1)] = (4));

(statearr_72756_72887[(5)] = null);

} else {
throw ex72751;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72740 === (10))){
var inst_72711 = (state_72739[(9)]);
var inst_72714 = fluree.db.util.json.parse.call(null,inst_72711);
var state_72739__$1 = state_72739;
var statearr_72757_72888 = state_72739__$1;
(statearr_72757_72888[(2)] = inst_72714);

(statearr_72757_72888[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72740 === (8))){
var inst_72711 = (state_72739[(9)]);
var inst_72711__$1 = (state_72739[(2)]);
var inst_72712 = typeof inst_72711__$1 === 'string';
var state_72739__$1 = (function (){var statearr_72758 = state_72739;
(statearr_72758[(9)] = inst_72711__$1);

return statearr_72758;
})();
if(cljs.core.truth_(inst_72712)){
var statearr_72759_72889 = state_72739__$1;
(statearr_72759_72889[(1)] = (10));

} else {
var statearr_72760_72890 = state_72739__$1;
(statearr_72760_72890[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16221__auto____0 = (function (){
var statearr_72761 = [null,null,null,null,null,null,null,null,null,null];
(statearr_72761[(0)] = fluree$db$dbfunctions$fns$state_machine__16221__auto__);

(statearr_72761[(1)] = (1));

return statearr_72761;
});
var fluree$db$dbfunctions$fns$state_machine__16221__auto____1 = (function (state_72739){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_72739);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e72762){var ex__16224__auto__ = e72762;
var statearr_72763_72891 = state_72739;
(statearr_72763_72891[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_72739[(4)]))){
var statearr_72764_72892 = state_72739;
(statearr_72764_72892[(1)] = cljs.core.first.call(null,(state_72739[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72893 = state_72739;
state_72739 = G__72893;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16221__auto__ = function(state_72739){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____1.call(this,state_72739);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_72765 = f__16346__auto__.call(null);
(statearr_72765[(6)] = c__16345__auto__);

return statearr_72765;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_72836){
var state_val_72837 = (state_72836[(1)]);
if((state_val_72837 === (7))){
var state_72836__$1 = state_72836;
var statearr_72838_72894 = state_72836__$1;
(statearr_72838_72894[(2)] = select);

(statearr_72838_72894[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72837 === (20))){
var inst_72806 = (state_72836[(2)]);
var inst_72807 = fluree.db.util.async.channel_QMARK_.call(null,limit);
var state_72836__$1 = (function (){var statearr_72839 = state_72836;
(statearr_72839[(7)] = inst_72806);

return statearr_72839;
})();
if(inst_72807){
var statearr_72840_72895 = state_72836__$1;
(statearr_72840_72895[(1)] = (22));

} else {
var statearr_72841_72896 = state_72836__$1;
(statearr_72841_72896[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72837 === (1))){
var state_72836__$1 = state_72836;
var statearr_72842_72897 = state_72836__$1;
(statearr_72842_72897[(2)] = null);

(statearr_72842_72897[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72837 === (24))){
var inst_72790 = (state_72836[(8)]);
var inst_72806 = (state_72836[(7)]);
var inst_72782 = (state_72836[(9)]);
var inst_72798 = (state_72836[(10)]);
var inst_72814 = (state_72836[(2)]);
var inst_72815 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_72816 = fluree.db.dbfunctions.internal.query.call(null,inst_72815,inst_72782,inst_72790,inst_72798,inst_72806,inst_72814);
var state_72836__$1 = state_72836;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72836__$1,(26),inst_72816);
} else {
if((state_val_72837 === (4))){
var inst_72766 = (state_72836[(2)]);
var state_72836__$1 = state_72836;
var statearr_72843_72898 = state_72836__$1;
(statearr_72843_72898[(2)] = inst_72766);

(statearr_72843_72898[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72837 === (15))){
var state_72836__$1 = state_72836;
var statearr_72844_72899 = state_72836__$1;
(statearr_72844_72899[(2)] = where);

(statearr_72844_72899[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72837 === (21))){
var inst_72802 = (state_72836[(2)]);
var inst_72803 = fluree.db.util.async.throw_err.call(null,inst_72802);
var state_72836__$1 = state_72836;
var statearr_72845_72900 = state_72836__$1;
(statearr_72845_72900[(2)] = inst_72803);

(statearr_72845_72900[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72837 === (13))){
var inst_72786 = (state_72836[(2)]);
var inst_72787 = fluree.db.util.async.throw_err.call(null,inst_72786);
var state_72836__$1 = state_72836;
var statearr_72846_72901 = state_72836__$1;
(statearr_72846_72901[(2)] = inst_72787);

(statearr_72846_72901[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72837 === (22))){
var state_72836__$1 = state_72836;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72836__$1,(25),limit);
} else {
if((state_val_72837 === (6))){
var state_72836__$1 = state_72836;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72836__$1,(9),select);
} else {
if((state_val_72837 === (25))){
var inst_72810 = (state_72836[(2)]);
var inst_72811 = fluree.db.util.async.throw_err.call(null,inst_72810);
var state_72836__$1 = state_72836;
var statearr_72847_72902 = state_72836__$1;
(statearr_72847_72902[(2)] = inst_72811);

(statearr_72847_72902[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72837 === (17))){
var inst_72794 = (state_72836[(2)]);
var inst_72795 = fluree.db.util.async.throw_err.call(null,inst_72794);
var state_72836__$1 = state_72836;
var statearr_72848_72903 = state_72836__$1;
(statearr_72848_72903[(2)] = inst_72795);

(statearr_72848_72903[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72837 === (3))){
var inst_72834 = (state_72836[(2)]);
var state_72836__$1 = state_72836;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72836__$1,inst_72834);
} else {
if((state_val_72837 === (12))){
var inst_72790 = (state_72836[(2)]);
var inst_72791 = fluree.db.util.async.channel_QMARK_.call(null,where);
var state_72836__$1 = (function (){var statearr_72849 = state_72836;
(statearr_72849[(8)] = inst_72790);

return statearr_72849;
})();
if(inst_72791){
var statearr_72850_72904 = state_72836__$1;
(statearr_72850_72904[(1)] = (14));

} else {
var statearr_72851_72905 = state_72836__$1;
(statearr_72851_72905[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72837 === (2))){
var _ = (function (){var statearr_72852 = state_72836;
(statearr_72852[(4)] = cljs.core.cons.call(null,(5),(state_72836[(4)])));

return statearr_72852;
})();
var inst_72775 = fluree.db.util.async.channel_QMARK_.call(null,select);
var state_72836__$1 = state_72836;
if(inst_72775){
var statearr_72853_72906 = state_72836__$1;
(statearr_72853_72906[(1)] = (6));

} else {
var statearr_72854_72907 = state_72836__$1;
(statearr_72854_72907[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72837 === (23))){
var state_72836__$1 = state_72836;
var statearr_72855_72908 = state_72836__$1;
(statearr_72855_72908[(2)] = limit);

(statearr_72855_72908[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72837 === (19))){
var state_72836__$1 = state_72836;
var statearr_72856_72909 = state_72836__$1;
(statearr_72856_72909[(2)] = block);

(statearr_72856_72909[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72837 === (11))){
var state_72836__$1 = state_72836;
var statearr_72858_72910 = state_72836__$1;
(statearr_72858_72910[(2)] = from);

(statearr_72858_72910[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72837 === (9))){
var inst_72778 = (state_72836[(2)]);
var inst_72779 = fluree.db.util.async.throw_err.call(null,inst_72778);
var state_72836__$1 = state_72836;
var statearr_72859_72911 = state_72836__$1;
(statearr_72859_72911[(2)] = inst_72779);

(statearr_72859_72911[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72837 === (5))){
var _ = (function (){var statearr_72860 = state_72836;
(statearr_72860[(4)] = cljs.core.rest.call(null,(state_72836[(4)])));

return statearr_72860;
})();
var state_72836__$1 = state_72836;
var ex72857 = (state_72836__$1[(2)]);
var statearr_72861_72912 = state_72836__$1;
(statearr_72861_72912[(5)] = ex72857);


if((ex72857 instanceof Error)){
var statearr_72862_72913 = state_72836__$1;
(statearr_72862_72913[(1)] = (4));

(statearr_72862_72913[(5)] = null);

} else {
throw ex72857;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72837 === (14))){
var state_72836__$1 = state_72836;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72836__$1,(17),where);
} else {
if((state_val_72837 === (26))){
var inst_72790 = (state_72836[(8)]);
var inst_72806 = (state_72836[(7)]);
var inst_72782 = (state_72836[(9)]);
var inst_72798 = (state_72836[(10)]);
var inst_72818 = (state_72836[(2)]);
var inst_72819 = fluree.db.util.async.throw_err.call(null,inst_72818);
var inst_72820 = cljs.core.nth.call(null,inst_72819,(0),null);
var inst_72821 = cljs.core.nth.call(null,inst_72819,(1),null);
var inst_72822 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72823 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_72824 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72825 = [inst_72782,inst_72790,inst_72798,inst_72806];
var inst_72826 = (new cljs.core.PersistentVector(null,4,(5),inst_72824,inst_72825,null));
var inst_72827 = ["query",inst_72826,inst_72820];
var inst_72828 = cljs.core.PersistentHashMap.fromArrays(inst_72823,inst_72827);
var inst_72829 = [inst_72828,inst_72821];
var inst_72830 = (new cljs.core.PersistentVector(null,2,(5),inst_72822,inst_72829,null));
var inst_72831 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_72830);
var _ = (function (){var statearr_72863 = state_72836;
(statearr_72863[(4)] = cljs.core.rest.call(null,(state_72836[(4)])));

return statearr_72863;
})();
var state_72836__$1 = (function (){var statearr_72864 = state_72836;
(statearr_72864[(11)] = inst_72831);

return statearr_72864;
})();
var statearr_72865_72914 = state_72836__$1;
(statearr_72865_72914[(2)] = inst_72820);

(statearr_72865_72914[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72837 === (16))){
var inst_72798 = (state_72836[(2)]);
var inst_72799 = fluree.db.util.async.channel_QMARK_.call(null,block);
var state_72836__$1 = (function (){var statearr_72866 = state_72836;
(statearr_72866[(10)] = inst_72798);

return statearr_72866;
})();
if(inst_72799){
var statearr_72867_72915 = state_72836__$1;
(statearr_72867_72915[(1)] = (18));

} else {
var statearr_72868_72916 = state_72836__$1;
(statearr_72868_72916[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72837 === (10))){
var state_72836__$1 = state_72836;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72836__$1,(13),from);
} else {
if((state_val_72837 === (18))){
var state_72836__$1 = state_72836;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72836__$1,(21),block);
} else {
if((state_val_72837 === (8))){
var inst_72782 = (state_72836[(2)]);
var inst_72783 = fluree.db.util.async.channel_QMARK_.call(null,from);
var state_72836__$1 = (function (){var statearr_72869 = state_72836;
(statearr_72869[(9)] = inst_72782);

return statearr_72869;
})();
if(inst_72783){
var statearr_72870_72917 = state_72836__$1;
(statearr_72870_72917[(1)] = (10));

} else {
var statearr_72871_72918 = state_72836__$1;
(statearr_72871_72918[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16221__auto____0 = (function (){
var statearr_72872 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72872[(0)] = fluree$db$dbfunctions$fns$state_machine__16221__auto__);

(statearr_72872[(1)] = (1));

return statearr_72872;
});
var fluree$db$dbfunctions$fns$state_machine__16221__auto____1 = (function (state_72836){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_72836);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e72873){var ex__16224__auto__ = e72873;
var statearr_72874_72919 = state_72836;
(statearr_72874_72919[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_72836[(4)]))){
var statearr_72875_72920 = state_72836;
(statearr_72875_72920[(1)] = cljs.core.first.call(null,(state_72836[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72921 = state_72836;
state_72836 = G__72921;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16221__auto__ = function(state_72836){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____1.call(this,state_72836);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_72876 = f__16346__auto__.call(null);
(statearr_72876[(6)] = c__16345__auto__);

return statearr_72876;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_72977){
var state_val_72978 = (state_72977[(1)]);
if((state_val_72978 === (7))){
var state_72977__$1 = state_72977;
var statearr_72979_73010 = state_72977__$1;
(statearr_72979_73010[(2)] = startSubject);

(statearr_72979_73010[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72978 === (1))){
var state_72977__$1 = state_72977;
var statearr_72980_73011 = state_72977__$1;
(statearr_72980_73011[(2)] = null);

(statearr_72980_73011[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72978 === (4))){
var inst_72922 = (state_72977[(2)]);
var state_72977__$1 = state_72977;
var statearr_72981_73012 = state_72977__$1;
(statearr_72981_73012[(2)] = inst_72922);

(statearr_72981_73012[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72978 === (15))){
var inst_72954 = (state_72977[(2)]);
var inst_72955 = fluree.db.util.async.throw_err.call(null,inst_72954);
var inst_72956 = cljs.core.nth.call(null,inst_72955,(0),null);
var inst_72957 = cljs.core.nth.call(null,inst_72955,(1),null);
var inst_72958 = cljs.core.empty_QMARK_.call(null,inst_72956);
var state_72977__$1 = (function (){var statearr_72982 = state_72977;
(statearr_72982[(7)] = inst_72957);

return statearr_72982;
})();
if(inst_72958){
var statearr_72983_73013 = state_72977__$1;
(statearr_72983_73013[(1)] = (16));

} else {
var statearr_72984_73014 = state_72977__$1;
(statearr_72984_73014[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72978 === (13))){
var inst_72950 = (state_72977[(8)]);
var inst_72942 = (state_72977[(9)]);
var inst_72938 = (state_72977[(10)]);
var inst_72950__$1 = (state_72977[(2)]);
var inst_72951 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_72952 = fluree.db.dbfunctions.internal.relationship_QMARK_.call(null,inst_72951,inst_72938,inst_72942,inst_72950__$1);
var state_72977__$1 = (function (){var statearr_72985 = state_72977;
(statearr_72985[(8)] = inst_72950__$1);

return statearr_72985;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72977__$1,(15),inst_72952);
} else {
if((state_val_72978 === (6))){
var state_72977__$1 = state_72977;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72977__$1,(9),startSubject);
} else {
if((state_val_72978 === (17))){
var state_72977__$1 = state_72977;
var statearr_72986_73015 = state_72977__$1;
(statearr_72986_73015[(2)] = true);

(statearr_72986_73015[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72978 === (3))){
var inst_72975 = (state_72977[(2)]);
var state_72977__$1 = state_72977;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72977__$1,inst_72975);
} else {
if((state_val_72978 === (12))){
var state_72977__$1 = state_72977;
var statearr_72987_73016 = state_72977__$1;
(statearr_72987_73016[(2)] = endSubject);

(statearr_72987_73016[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72978 === (2))){
var _ = (function (){var statearr_72988 = state_72977;
(statearr_72988[(4)] = cljs.core.cons.call(null,(5),(state_72977[(4)])));

return statearr_72988;
})();
var inst_72931 = fluree.db.util.async.channel_QMARK_.call(null,startSubject);
var state_72977__$1 = state_72977;
if(inst_72931){
var statearr_72989_73017 = state_72977__$1;
(statearr_72989_73017[(1)] = (6));

} else {
var statearr_72990_73018 = state_72977__$1;
(statearr_72990_73018[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72978 === (11))){
var state_72977__$1 = state_72977;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72977__$1,(14),endSubject);
} else {
if((state_val_72978 === (9))){
var inst_72934 = (state_72977[(2)]);
var inst_72935 = fluree.db.util.async.throw_err.call(null,inst_72934);
var state_72977__$1 = state_72977;
var statearr_72992_73019 = state_72977__$1;
(statearr_72992_73019[(2)] = inst_72935);

(statearr_72992_73019[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72978 === (5))){
var _ = (function (){var statearr_72993 = state_72977;
(statearr_72993[(4)] = cljs.core.rest.call(null,(state_72977[(4)])));

return statearr_72993;
})();
var state_72977__$1 = state_72977;
var ex72991 = (state_72977__$1[(2)]);
var statearr_72994_73020 = state_72977__$1;
(statearr_72994_73020[(5)] = ex72991);


if((ex72991 instanceof Error)){
var statearr_72995_73021 = state_72977__$1;
(statearr_72995_73021[(1)] = (4));

(statearr_72995_73021[(5)] = null);

} else {
throw ex72991;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72978 === (14))){
var inst_72946 = (state_72977[(2)]);
var inst_72947 = fluree.db.util.async.throw_err.call(null,inst_72946);
var state_72977__$1 = state_72977;
var statearr_72996_73022 = state_72977__$1;
(statearr_72996_73022[(2)] = inst_72947);

(statearr_72996_73022[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72978 === (16))){
var state_72977__$1 = state_72977;
var statearr_72997_73023 = state_72977__$1;
(statearr_72997_73023[(2)] = false);

(statearr_72997_73023[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72978 === (10))){
var inst_72941 = (state_72977[(2)]);
var inst_72942 = fluree.db.util.async.throw_err.call(null,inst_72941);
var inst_72943 = fluree.db.util.async.channel_QMARK_.call(null,endSubject);
var state_72977__$1 = (function (){var statearr_72998 = state_72977;
(statearr_72998[(9)] = inst_72942);

return statearr_72998;
})();
if(inst_72943){
var statearr_72999_73024 = state_72977__$1;
(statearr_72999_73024[(1)] = (11));

} else {
var statearr_73000_73025 = state_72977__$1;
(statearr_73000_73025[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72978 === (18))){
var inst_72950 = (state_72977[(8)]);
var inst_72957 = (state_72977[(7)]);
var inst_72942 = (state_72977[(9)]);
var inst_72938 = (state_72977[(10)]);
var inst_72962 = (state_72977[(2)]);
var inst_72963 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72964 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_72965 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72966 = [inst_72938,inst_72942,inst_72950];
var inst_72967 = (new cljs.core.PersistentVector(null,3,(5),inst_72965,inst_72966,null));
var inst_72968 = ["relationship?",inst_72967,inst_72962];
var inst_72969 = cljs.core.PersistentHashMap.fromArrays(inst_72964,inst_72968);
var inst_72970 = [inst_72969,inst_72957];
var inst_72971 = (new cljs.core.PersistentVector(null,2,(5),inst_72963,inst_72970,null));
var inst_72972 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_72971);
var _ = (function (){var statearr_73001 = state_72977;
(statearr_73001[(4)] = cljs.core.rest.call(null,(state_72977[(4)])));

return statearr_73001;
})();
var state_72977__$1 = (function (){var statearr_73002 = state_72977;
(statearr_73002[(11)] = inst_72972);

return statearr_73002;
})();
var statearr_73003_73026 = state_72977__$1;
(statearr_73003_73026[(2)] = inst_72962);

(statearr_73003_73026[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72978 === (8))){
var inst_72938 = (state_72977[(2)]);
var inst_72939 = fluree.db.dbfunctions.fns.coerce_args.call(null,path);
var state_72977__$1 = (function (){var statearr_73004 = state_72977;
(statearr_73004[(10)] = inst_72938);

return statearr_73004;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72977__$1,(10),inst_72939);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16221__auto____0 = (function (){
var statearr_73005 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73005[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16221__auto__);

(statearr_73005[(1)] = (1));

return statearr_73005;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16221__auto____1 = (function (state_72977){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_72977);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e73006){var ex__16224__auto__ = e73006;
var statearr_73007_73027 = state_72977;
(statearr_73007_73027[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_72977[(4)]))){
var statearr_73008_73028 = state_72977;
(statearr_73008_73028[(1)] = cljs.core.first.call(null,(state_72977[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73029 = state_72977;
state_72977 = G__73029;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16221__auto__ = function(state_72977){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16221__auto____1.call(this,state_72977);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_73009 = f__16346__auto__.call(null);
(statearr_73009[(6)] = c__16345__auto__);

return statearr_73009;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_73066){
var state_val_73067 = (state_73066[(1)]);
if((state_val_73067 === (7))){
var state_73066__$1 = state_73066;
var statearr_73068_73088 = state_73066__$1;
(statearr_73068_73088[(2)] = pred_name);

(statearr_73068_73088[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73067 === (1))){
var state_73066__$1 = state_73066;
var statearr_73069_73089 = state_73066__$1;
(statearr_73069_73089[(2)] = null);

(statearr_73069_73089[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73067 === (4))){
var inst_73030 = (state_73066[(2)]);
var state_73066__$1 = state_73066;
var statearr_73070_73090 = state_73066__$1;
(statearr_73070_73090[(2)] = inst_73030);

(statearr_73070_73090[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73067 === (6))){
var state_73066__$1 = state_73066;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73066__$1,(9),pred_name);
} else {
if((state_val_73067 === (3))){
var inst_73064 = (state_73066[(2)]);
var state_73066__$1 = state_73066;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73066__$1,inst_73064);
} else {
if((state_val_73067 === (2))){
var _ = (function (){var statearr_73072 = state_73066;
(statearr_73072[(4)] = cljs.core.cons.call(null,(5),(state_73066[(4)])));

return statearr_73072;
})();
var inst_73039 = fluree.db.util.async.channel_QMARK_.call(null,pred_name);
var state_73066__$1 = state_73066;
if(inst_73039){
var statearr_73073_73091 = state_73066__$1;
(statearr_73073_73091[(1)] = (6));

} else {
var statearr_73074_73092 = state_73066__$1;
(statearr_73074_73092[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73067 === (9))){
var inst_73042 = (state_73066[(2)]);
var inst_73043 = fluree.db.util.async.throw_err.call(null,inst_73042);
var state_73066__$1 = state_73066;
var statearr_73075_73093 = state_73066__$1;
(statearr_73075_73093[(2)] = inst_73043);

(statearr_73075_73093[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73067 === (5))){
var _ = (function (){var statearr_73076 = state_73066;
(statearr_73076[(4)] = cljs.core.rest.call(null,(state_73066[(4)])));

return statearr_73076;
})();
var state_73066__$1 = state_73066;
var ex73071 = (state_73066__$1[(2)]);
var statearr_73077_73094 = state_73066__$1;
(statearr_73077_73094[(5)] = ex73071);


if((ex73071 instanceof Error)){
var statearr_73078_73095 = state_73066__$1;
(statearr_73078_73095[(1)] = (4));

(statearr_73078_73095[(5)] = null);

} else {
throw ex73071;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73067 === (10))){
var inst_73046 = (state_73066[(7)]);
var inst_73050 = (state_73066[(2)]);
var inst_73051 = fluree.db.util.async.throw_err.call(null,inst_73050);
var inst_73052 = cljs.core.nth.call(null,inst_73051,(0),null);
var inst_73053 = cljs.core.nth.call(null,inst_73051,(1),null);
var inst_73054 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73055 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_73056 = ["max-pred-val",inst_73046,inst_73052];
var inst_73057 = cljs.core.PersistentHashMap.fromArrays(inst_73055,inst_73056);
var inst_73058 = (inst_73053 + (10));
var inst_73059 = [inst_73057,inst_73058];
var inst_73060 = (new cljs.core.PersistentVector(null,2,(5),inst_73054,inst_73059,null));
var inst_73061 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_73060);
var _ = (function (){var statearr_73079 = state_73066;
(statearr_73079[(4)] = cljs.core.rest.call(null,(state_73066[(4)])));

return statearr_73079;
})();
var state_73066__$1 = (function (){var statearr_73080 = state_73066;
(statearr_73080[(8)] = inst_73061);

return statearr_73080;
})();
var statearr_73081_73096 = state_73066__$1;
(statearr_73081_73096[(2)] = inst_73052);

(statearr_73081_73096[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73067 === (8))){
var inst_73046 = (state_73066[(7)]);
var inst_73046__$1 = (state_73066[(2)]);
var inst_73047 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_73048 = fluree.db.dbfunctions.internal.max_pred_val.call(null,inst_73047,inst_73046__$1,null);
var state_73066__$1 = (function (){var statearr_73082 = state_73066;
(statearr_73082[(7)] = inst_73046__$1);

return statearr_73082;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73066__$1,(10),inst_73048);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16221__auto____0 = (function (){
var statearr_73083 = [null,null,null,null,null,null,null,null,null];
(statearr_73083[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16221__auto__);

(statearr_73083[(1)] = (1));

return statearr_73083;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16221__auto____1 = (function (state_73066){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_73066);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e73084){var ex__16224__auto__ = e73084;
var statearr_73085_73097 = state_73066;
(statearr_73085_73097[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_73066[(4)]))){
var statearr_73086_73098 = state_73066;
(statearr_73086_73098[(1)] = cljs.core.first.call(null,(state_73066[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73099 = state_73066;
state_73066 = G__73099;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16221__auto__ = function(state_73066){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16221__auto____1.call(this,state_73066);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_73087 = f__16346__auto__.call(null);
(statearr_73087[(6)] = c__16345__auto__);

return statearr_73087;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_73126){
var state_val_73127 = (state_73126[(1)]);
if((state_val_73127 === (7))){
var state_73126__$1 = state_73126;
var statearr_73128_73147 = state_73126__$1;
(statearr_73128_73147[(2)] = n);

(statearr_73128_73147[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73127 === (1))){
var state_73126__$1 = state_73126;
var statearr_73129_73148 = state_73126__$1;
(statearr_73129_73148[(2)] = null);

(statearr_73129_73148[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73127 === (4))){
var inst_73100 = (state_73126[(2)]);
var state_73126__$1 = state_73126;
var statearr_73130_73149 = state_73126__$1;
(statearr_73130_73149[(2)] = inst_73100);

(statearr_73130_73149[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73127 === (6))){
var state_73126__$1 = state_73126;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73126__$1,(9),n);
} else {
if((state_val_73127 === (3))){
var inst_73124 = (state_73126[(2)]);
var state_73126__$1 = state_73126;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73126__$1,inst_73124);
} else {
if((state_val_73127 === (2))){
var _ = (function (){var statearr_73132 = state_73126;
(statearr_73132[(4)] = cljs.core.cons.call(null,(5),(state_73126[(4)])));

return statearr_73132;
})();
var inst_73106 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_73126__$1 = state_73126;
if(inst_73106){
var statearr_73133_73150 = state_73126__$1;
(statearr_73133_73150[(1)] = (6));

} else {
var statearr_73134_73151 = state_73126__$1;
(statearr_73134_73151[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73127 === (9))){
var inst_73109 = (state_73126[(2)]);
var inst_73110 = fluree.db.util.async.throw_err.call(null,inst_73109);
var state_73126__$1 = state_73126;
var statearr_73135_73152 = state_73126__$1;
(statearr_73135_73152[(2)] = inst_73110);

(statearr_73135_73152[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73127 === (5))){
var _ = (function (){var statearr_73136 = state_73126;
(statearr_73136[(4)] = cljs.core.rest.call(null,(state_73126[(4)])));

return statearr_73136;
})();
var state_73126__$1 = state_73126;
var ex73131 = (state_73126__$1[(2)]);
var statearr_73137_73153 = state_73126__$1;
(statearr_73137_73153[(5)] = ex73131);


if((ex73131 instanceof Error)){
var statearr_73138_73154 = state_73126__$1;
(statearr_73138_73154[(1)] = (4));

(statearr_73138_73154[(5)] = null);

} else {
throw ex73131;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73127 === (8))){
var inst_73113 = (state_73126[(2)]);
var inst_73114 = fluree.db.dbfunctions.internal.inc.call(null,inst_73113);
var inst_73115 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73116 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_73117 = ["inc",inst_73113,inst_73114];
var inst_73118 = cljs.core.PersistentHashMap.fromArrays(inst_73116,inst_73117);
var inst_73119 = [inst_73118,(10)];
var inst_73120 = (new cljs.core.PersistentVector(null,2,(5),inst_73115,inst_73119,null));
var inst_73121 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_73120);
var _ = (function (){var statearr_73139 = state_73126;
(statearr_73139[(4)] = cljs.core.rest.call(null,(state_73126[(4)])));

return statearr_73139;
})();
var state_73126__$1 = (function (){var statearr_73140 = state_73126;
(statearr_73140[(7)] = inst_73121);

return statearr_73140;
})();
var statearr_73141_73155 = state_73126__$1;
(statearr_73141_73155[(2)] = inst_73114);

(statearr_73141_73155[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__16221__auto____0 = (function (){
var statearr_73142 = [null,null,null,null,null,null,null,null];
(statearr_73142[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__16221__auto__);

(statearr_73142[(1)] = (1));

return statearr_73142;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__16221__auto____1 = (function (state_73126){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_73126);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e73143){var ex__16224__auto__ = e73143;
var statearr_73144_73156 = state_73126;
(statearr_73144_73156[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_73126[(4)]))){
var statearr_73145_73157 = state_73126;
(statearr_73145_73157[(1)] = cljs.core.first.call(null,(state_73126[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73158 = state_73126;
state_73126 = G__73158;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__16221__auto__ = function(state_73126){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__16221__auto____1.call(this,state_73126);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_73146 = f__16346__auto__.call(null);
(statearr_73146[(6)] = c__16345__auto__);

return statearr_73146;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_73185){
var state_val_73186 = (state_73185[(1)]);
if((state_val_73186 === (7))){
var state_73185__$1 = state_73185;
var statearr_73187_73206 = state_73185__$1;
(statearr_73187_73206[(2)] = n);

(statearr_73187_73206[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73186 === (1))){
var state_73185__$1 = state_73185;
var statearr_73188_73207 = state_73185__$1;
(statearr_73188_73207[(2)] = null);

(statearr_73188_73207[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73186 === (4))){
var inst_73159 = (state_73185[(2)]);
var state_73185__$1 = state_73185;
var statearr_73189_73208 = state_73185__$1;
(statearr_73189_73208[(2)] = inst_73159);

(statearr_73189_73208[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73186 === (6))){
var state_73185__$1 = state_73185;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73185__$1,(9),n);
} else {
if((state_val_73186 === (3))){
var inst_73183 = (state_73185[(2)]);
var state_73185__$1 = state_73185;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73185__$1,inst_73183);
} else {
if((state_val_73186 === (2))){
var _ = (function (){var statearr_73191 = state_73185;
(statearr_73191[(4)] = cljs.core.cons.call(null,(5),(state_73185[(4)])));

return statearr_73191;
})();
var inst_73165 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_73185__$1 = state_73185;
if(inst_73165){
var statearr_73192_73209 = state_73185__$1;
(statearr_73192_73209[(1)] = (6));

} else {
var statearr_73193_73210 = state_73185__$1;
(statearr_73193_73210[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73186 === (9))){
var inst_73168 = (state_73185[(2)]);
var inst_73169 = fluree.db.util.async.throw_err.call(null,inst_73168);
var state_73185__$1 = state_73185;
var statearr_73194_73211 = state_73185__$1;
(statearr_73194_73211[(2)] = inst_73169);

(statearr_73194_73211[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73186 === (5))){
var _ = (function (){var statearr_73195 = state_73185;
(statearr_73195[(4)] = cljs.core.rest.call(null,(state_73185[(4)])));

return statearr_73195;
})();
var state_73185__$1 = state_73185;
var ex73190 = (state_73185__$1[(2)]);
var statearr_73196_73212 = state_73185__$1;
(statearr_73196_73212[(5)] = ex73190);


if((ex73190 instanceof Error)){
var statearr_73197_73213 = state_73185__$1;
(statearr_73197_73213[(1)] = (4));

(statearr_73197_73213[(5)] = null);

} else {
throw ex73190;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73186 === (8))){
var inst_73172 = (state_73185[(2)]);
var inst_73173 = fluree.db.dbfunctions.internal.dec.call(null,inst_73172);
var inst_73174 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73175 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_73176 = ["dec",inst_73172,inst_73173];
var inst_73177 = cljs.core.PersistentHashMap.fromArrays(inst_73175,inst_73176);
var inst_73178 = [inst_73177,(10)];
var inst_73179 = (new cljs.core.PersistentVector(null,2,(5),inst_73174,inst_73178,null));
var inst_73180 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_73179);
var _ = (function (){var statearr_73198 = state_73185;
(statearr_73198[(4)] = cljs.core.rest.call(null,(state_73185[(4)])));

return statearr_73198;
})();
var state_73185__$1 = (function (){var statearr_73199 = state_73185;
(statearr_73199[(7)] = inst_73180);

return statearr_73199;
})();
var statearr_73200_73214 = state_73185__$1;
(statearr_73200_73214[(2)] = inst_73173);

(statearr_73200_73214[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__16221__auto____0 = (function (){
var statearr_73201 = [null,null,null,null,null,null,null,null];
(statearr_73201[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__16221__auto__);

(statearr_73201[(1)] = (1));

return statearr_73201;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__16221__auto____1 = (function (state_73185){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_73185);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e73202){var ex__16224__auto__ = e73202;
var statearr_73203_73215 = state_73185;
(statearr_73203_73215[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_73185[(4)]))){
var statearr_73204_73216 = state_73185;
(statearr_73204_73216[(1)] = cljs.core.first.call(null,(state_73185[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73217 = state_73185;
state_73185 = G__73217;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__16221__auto__ = function(state_73185){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__16221__auto____1.call(this,state_73185);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_73205 = f__16346__auto__.call(null);
(statearr_73205[(6)] = c__16345__auto__);

return statearr_73205;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___73267 = arguments.length;
var i__4819__auto___73268 = (0);
while(true){
if((i__4819__auto___73268 < len__4818__auto___73267)){
args__4824__auto__.push((arguments[i__4819__auto___73268]));

var G__73269 = (i__4819__auto___73268 + (1));
i__4819__auto___73268 = G__73269;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_73250){
var state_val_73251 = (state_73250[(1)]);
if((state_val_73251 === (1))){
var state_73250__$1 = state_73250;
var statearr_73252_73270 = state_73250__$1;
(statearr_73252_73270[(2)] = null);

(statearr_73252_73270[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (2))){
var _ = (function (){var statearr_73253 = state_73250;
(statearr_73253[(4)] = cljs.core.cons.call(null,(5),(state_73250[(4)])));

return statearr_73253;
})();
var inst_73226 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_73250__$1 = state_73250;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73250__$1,(6),inst_73226);
} else {
if((state_val_73251 === (3))){
var inst_73248 = (state_73250[(2)]);
var state_73250__$1 = state_73250;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73250__$1,inst_73248);
} else {
if((state_val_73251 === (4))){
var inst_73220 = (state_73250[(2)]);
var state_73250__$1 = state_73250;
var statearr_73255_73271 = state_73250__$1;
(statearr_73255_73271[(2)] = inst_73220);

(statearr_73255_73271[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (5))){
var _ = (function (){var statearr_73256 = state_73250;
(statearr_73256[(4)] = cljs.core.rest.call(null,(state_73250[(4)])));

return statearr_73256;
})();
var state_73250__$1 = state_73250;
var ex73254 = (state_73250__$1[(2)]);
var statearr_73257_73272 = state_73250__$1;
(statearr_73257_73272[(5)] = ex73254);


if((ex73254 instanceof Error)){
var statearr_73258_73273 = state_73250__$1;
(statearr_73258_73273[(1)] = (4));

(statearr_73258_73273[(5)] = null);

} else {
throw ex73254;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73251 === (6))){
var inst_73228 = (state_73250[(2)]);
var inst_73229 = fluree.db.util.async.throw_err.call(null,inst_73228);
var inst_73230 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._PLUS_,inst_73229);
var inst_73231 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73232 = [inst_73229];
var inst_73233 = (new cljs.core.PersistentVector(null,1,(5),inst_73231,inst_73232,null));
var inst_73234 = cljs.core.count.call(null,inst_73233);
var inst_73235 = ((9) + inst_73234);
var inst_73236 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73237 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_73238 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73239 = [inst_73229];
var inst_73240 = (new cljs.core.PersistentVector(null,1,(5),inst_73238,inst_73239,null));
var inst_73241 = ["+",inst_73240,inst_73230];
var inst_73242 = cljs.core.PersistentHashMap.fromArrays(inst_73237,inst_73241);
var inst_73243 = [inst_73242,inst_73235];
var inst_73244 = (new cljs.core.PersistentVector(null,2,(5),inst_73236,inst_73243,null));
var inst_73245 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_73244);
var _ = (function (){var statearr_73259 = state_73250;
(statearr_73259[(4)] = cljs.core.rest.call(null,(state_73250[(4)])));

return statearr_73259;
})();
var state_73250__$1 = (function (){var statearr_73260 = state_73250;
(statearr_73260[(7)] = inst_73245);

return statearr_73260;
})();
var statearr_73261_73274 = state_73250__$1;
(statearr_73261_73274[(2)] = inst_73230);

(statearr_73261_73274[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16221__auto____0 = (function (){
var statearr_73262 = [null,null,null,null,null,null,null,null];
(statearr_73262[(0)] = fluree$db$dbfunctions$fns$state_machine__16221__auto__);

(statearr_73262[(1)] = (1));

return statearr_73262;
});
var fluree$db$dbfunctions$fns$state_machine__16221__auto____1 = (function (state_73250){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_73250);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e73263){var ex__16224__auto__ = e73263;
var statearr_73264_73275 = state_73250;
(statearr_73264_73275[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_73250[(4)]))){
var statearr_73265_73276 = state_73250;
(statearr_73265_73276[(1)] = cljs.core.first.call(null,(state_73250[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73277 = state_73250;
state_73250 = G__73277;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16221__auto__ = function(state_73250){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____1.call(this,state_73250);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_73266 = f__16346__auto__.call(null);
(statearr_73266[(6)] = c__16345__auto__);

return statearr_73266;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq73218){
var G__73219 = cljs.core.first.call(null,seq73218);
var seq73218__$1 = cljs.core.next.call(null,seq73218);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73219,seq73218__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___73327 = arguments.length;
var i__4819__auto___73328 = (0);
while(true){
if((i__4819__auto___73328 < len__4818__auto___73327)){
args__4824__auto__.push((arguments[i__4819__auto___73328]));

var G__73329 = (i__4819__auto___73328 + (1));
i__4819__auto___73328 = G__73329;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_73310){
var state_val_73311 = (state_73310[(1)]);
if((state_val_73311 === (1))){
var state_73310__$1 = state_73310;
var statearr_73312_73330 = state_73310__$1;
(statearr_73312_73330[(2)] = null);

(statearr_73312_73330[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73311 === (2))){
var _ = (function (){var statearr_73313 = state_73310;
(statearr_73313[(4)] = cljs.core.cons.call(null,(5),(state_73310[(4)])));

return statearr_73313;
})();
var inst_73286 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_73310__$1 = state_73310;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73310__$1,(6),inst_73286);
} else {
if((state_val_73311 === (3))){
var inst_73308 = (state_73310[(2)]);
var state_73310__$1 = state_73310;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73310__$1,inst_73308);
} else {
if((state_val_73311 === (4))){
var inst_73280 = (state_73310[(2)]);
var state_73310__$1 = state_73310;
var statearr_73315_73331 = state_73310__$1;
(statearr_73315_73331[(2)] = inst_73280);

(statearr_73315_73331[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73311 === (5))){
var _ = (function (){var statearr_73316 = state_73310;
(statearr_73316[(4)] = cljs.core.rest.call(null,(state_73310[(4)])));

return statearr_73316;
})();
var state_73310__$1 = state_73310;
var ex73314 = (state_73310__$1[(2)]);
var statearr_73317_73332 = state_73310__$1;
(statearr_73317_73332[(5)] = ex73314);


if((ex73314 instanceof Error)){
var statearr_73318_73333 = state_73310__$1;
(statearr_73318_73333[(1)] = (4));

(statearr_73318_73333[(5)] = null);

} else {
throw ex73314;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73311 === (6))){
var inst_73288 = (state_73310[(2)]);
var inst_73289 = fluree.db.util.async.throw_err.call(null,inst_73288);
var inst_73290 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._,inst_73289);
var inst_73291 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73292 = [inst_73289];
var inst_73293 = (new cljs.core.PersistentVector(null,1,(5),inst_73291,inst_73292,null));
var inst_73294 = cljs.core.count.call(null,inst_73293);
var inst_73295 = ((9) + inst_73294);
var inst_73296 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73297 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_73298 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73299 = [inst_73289];
var inst_73300 = (new cljs.core.PersistentVector(null,1,(5),inst_73298,inst_73299,null));
var inst_73301 = ["-",inst_73300,inst_73290];
var inst_73302 = cljs.core.PersistentHashMap.fromArrays(inst_73297,inst_73301);
var inst_73303 = [inst_73302,inst_73295];
var inst_73304 = (new cljs.core.PersistentVector(null,2,(5),inst_73296,inst_73303,null));
var inst_73305 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_73304);
var _ = (function (){var statearr_73319 = state_73310;
(statearr_73319[(4)] = cljs.core.rest.call(null,(state_73310[(4)])));

return statearr_73319;
})();
var state_73310__$1 = (function (){var statearr_73320 = state_73310;
(statearr_73320[(7)] = inst_73305);

return statearr_73320;
})();
var statearr_73321_73334 = state_73310__$1;
(statearr_73321_73334[(2)] = inst_73290);

(statearr_73321_73334[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16221__auto____0 = (function (){
var statearr_73322 = [null,null,null,null,null,null,null,null];
(statearr_73322[(0)] = fluree$db$dbfunctions$fns$state_machine__16221__auto__);

(statearr_73322[(1)] = (1));

return statearr_73322;
});
var fluree$db$dbfunctions$fns$state_machine__16221__auto____1 = (function (state_73310){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_73310);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e73323){var ex__16224__auto__ = e73323;
var statearr_73324_73335 = state_73310;
(statearr_73324_73335[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_73310[(4)]))){
var statearr_73325_73336 = state_73310;
(statearr_73325_73336[(1)] = cljs.core.first.call(null,(state_73310[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73337 = state_73310;
state_73310 = G__73337;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16221__auto__ = function(state_73310){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____1.call(this,state_73310);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_73326 = f__16346__auto__.call(null);
(statearr_73326[(6)] = c__16345__auto__);

return statearr_73326;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq73278){
var G__73279 = cljs.core.first.call(null,seq73278);
var seq73278__$1 = cljs.core.next.call(null,seq73278);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73279,seq73278__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___73387 = arguments.length;
var i__4819__auto___73388 = (0);
while(true){
if((i__4819__auto___73388 < len__4818__auto___73387)){
args__4824__auto__.push((arguments[i__4819__auto___73388]));

var G__73389 = (i__4819__auto___73388 + (1));
i__4819__auto___73388 = G__73389;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_73370){
var state_val_73371 = (state_73370[(1)]);
if((state_val_73371 === (1))){
var state_73370__$1 = state_73370;
var statearr_73372_73390 = state_73370__$1;
(statearr_73372_73390[(2)] = null);

(statearr_73372_73390[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (2))){
var _ = (function (){var statearr_73373 = state_73370;
(statearr_73373[(4)] = cljs.core.cons.call(null,(5),(state_73370[(4)])));

return statearr_73373;
})();
var inst_73346 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_73370__$1 = state_73370;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73370__$1,(6),inst_73346);
} else {
if((state_val_73371 === (3))){
var inst_73368 = (state_73370[(2)]);
var state_73370__$1 = state_73370;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73370__$1,inst_73368);
} else {
if((state_val_73371 === (4))){
var inst_73340 = (state_73370[(2)]);
var state_73370__$1 = state_73370;
var statearr_73375_73391 = state_73370__$1;
(statearr_73375_73391[(2)] = inst_73340);

(statearr_73375_73391[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (5))){
var _ = (function (){var statearr_73376 = state_73370;
(statearr_73376[(4)] = cljs.core.rest.call(null,(state_73370[(4)])));

return statearr_73376;
})();
var state_73370__$1 = state_73370;
var ex73374 = (state_73370__$1[(2)]);
var statearr_73377_73392 = state_73370__$1;
(statearr_73377_73392[(5)] = ex73374);


if((ex73374 instanceof Error)){
var statearr_73378_73393 = state_73370__$1;
(statearr_73378_73393[(1)] = (4));

(statearr_73378_73393[(5)] = null);

} else {
throw ex73374;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73371 === (6))){
var inst_73348 = (state_73370[(2)]);
var inst_73349 = fluree.db.util.async.throw_err.call(null,inst_73348);
var inst_73350 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._STAR_,inst_73349);
var inst_73351 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73352 = [inst_73349];
var inst_73353 = (new cljs.core.PersistentVector(null,1,(5),inst_73351,inst_73352,null));
var inst_73354 = cljs.core.count.call(null,inst_73353);
var inst_73355 = ((9) + inst_73354);
var inst_73356 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73357 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_73358 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73359 = [inst_73349];
var inst_73360 = (new cljs.core.PersistentVector(null,1,(5),inst_73358,inst_73359,null));
var inst_73361 = ["*",inst_73360,inst_73350];
var inst_73362 = cljs.core.PersistentHashMap.fromArrays(inst_73357,inst_73361);
var inst_73363 = [inst_73362,inst_73355];
var inst_73364 = (new cljs.core.PersistentVector(null,2,(5),inst_73356,inst_73363,null));
var inst_73365 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_73364);
var _ = (function (){var statearr_73379 = state_73370;
(statearr_73379[(4)] = cljs.core.rest.call(null,(state_73370[(4)])));

return statearr_73379;
})();
var state_73370__$1 = (function (){var statearr_73380 = state_73370;
(statearr_73380[(7)] = inst_73365);

return statearr_73380;
})();
var statearr_73381_73394 = state_73370__$1;
(statearr_73381_73394[(2)] = inst_73350);

(statearr_73381_73394[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16221__auto____0 = (function (){
var statearr_73382 = [null,null,null,null,null,null,null,null];
(statearr_73382[(0)] = fluree$db$dbfunctions$fns$state_machine__16221__auto__);

(statearr_73382[(1)] = (1));

return statearr_73382;
});
var fluree$db$dbfunctions$fns$state_machine__16221__auto____1 = (function (state_73370){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_73370);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e73383){var ex__16224__auto__ = e73383;
var statearr_73384_73395 = state_73370;
(statearr_73384_73395[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_73370[(4)]))){
var statearr_73385_73396 = state_73370;
(statearr_73385_73396[(1)] = cljs.core.first.call(null,(state_73370[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73397 = state_73370;
state_73370 = G__73397;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16221__auto__ = function(state_73370){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____1.call(this,state_73370);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_73386 = f__16346__auto__.call(null);
(statearr_73386[(6)] = c__16345__auto__);

return statearr_73386;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq73338){
var G__73339 = cljs.core.first.call(null,seq73338);
var seq73338__$1 = cljs.core.next.call(null,seq73338);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73339,seq73338__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___73447 = arguments.length;
var i__4819__auto___73448 = (0);
while(true){
if((i__4819__auto___73448 < len__4818__auto___73447)){
args__4824__auto__.push((arguments[i__4819__auto___73448]));

var G__73449 = (i__4819__auto___73448 + (1));
i__4819__auto___73448 = G__73449;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_73430){
var state_val_73431 = (state_73430[(1)]);
if((state_val_73431 === (1))){
var state_73430__$1 = state_73430;
var statearr_73432_73450 = state_73430__$1;
(statearr_73432_73450[(2)] = null);

(statearr_73432_73450[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73431 === (2))){
var _ = (function (){var statearr_73433 = state_73430;
(statearr_73433[(4)] = cljs.core.cons.call(null,(5),(state_73430[(4)])));

return statearr_73433;
})();
var inst_73406 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_73430__$1 = state_73430;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73430__$1,(6),inst_73406);
} else {
if((state_val_73431 === (3))){
var inst_73428 = (state_73430[(2)]);
var state_73430__$1 = state_73430;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73430__$1,inst_73428);
} else {
if((state_val_73431 === (4))){
var inst_73400 = (state_73430[(2)]);
var state_73430__$1 = state_73430;
var statearr_73435_73451 = state_73430__$1;
(statearr_73435_73451[(2)] = inst_73400);

(statearr_73435_73451[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73431 === (5))){
var _ = (function (){var statearr_73436 = state_73430;
(statearr_73436[(4)] = cljs.core.rest.call(null,(state_73430[(4)])));

return statearr_73436;
})();
var state_73430__$1 = state_73430;
var ex73434 = (state_73430__$1[(2)]);
var statearr_73437_73452 = state_73430__$1;
(statearr_73437_73452[(5)] = ex73434);


if((ex73434 instanceof Error)){
var statearr_73438_73453 = state_73430__$1;
(statearr_73438_73453[(1)] = (4));

(statearr_73438_73453[(5)] = null);

} else {
throw ex73434;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73431 === (6))){
var inst_73408 = (state_73430[(2)]);
var inst_73409 = fluree.db.util.async.throw_err.call(null,inst_73408);
var inst_73410 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._SLASH_,inst_73409);
var inst_73411 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73412 = [inst_73409];
var inst_73413 = (new cljs.core.PersistentVector(null,1,(5),inst_73411,inst_73412,null));
var inst_73414 = cljs.core.count.call(null,inst_73413);
var inst_73415 = ((9) + inst_73414);
var inst_73416 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73417 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_73418 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73419 = [inst_73409];
var inst_73420 = (new cljs.core.PersistentVector(null,1,(5),inst_73418,inst_73419,null));
var inst_73421 = ["/",inst_73420,inst_73410];
var inst_73422 = cljs.core.PersistentHashMap.fromArrays(inst_73417,inst_73421);
var inst_73423 = [inst_73422,inst_73415];
var inst_73424 = (new cljs.core.PersistentVector(null,2,(5),inst_73416,inst_73423,null));
var inst_73425 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_73424);
var _ = (function (){var statearr_73439 = state_73430;
(statearr_73439[(4)] = cljs.core.rest.call(null,(state_73430[(4)])));

return statearr_73439;
})();
var state_73430__$1 = (function (){var statearr_73440 = state_73430;
(statearr_73440[(7)] = inst_73425);

return statearr_73440;
})();
var statearr_73441_73454 = state_73430__$1;
(statearr_73441_73454[(2)] = inst_73410);

(statearr_73441_73454[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16221__auto____0 = (function (){
var statearr_73442 = [null,null,null,null,null,null,null,null];
(statearr_73442[(0)] = fluree$db$dbfunctions$fns$state_machine__16221__auto__);

(statearr_73442[(1)] = (1));

return statearr_73442;
});
var fluree$db$dbfunctions$fns$state_machine__16221__auto____1 = (function (state_73430){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_73430);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e73443){var ex__16224__auto__ = e73443;
var statearr_73444_73455 = state_73430;
(statearr_73444_73455[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_73430[(4)]))){
var statearr_73445_73456 = state_73430;
(statearr_73445_73456[(1)] = cljs.core.first.call(null,(state_73430[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73457 = state_73430;
state_73430 = G__73457;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16221__auto__ = function(state_73430){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____1.call(this,state_73430);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_73446 = f__16346__auto__.call(null);
(statearr_73446[(6)] = c__16345__auto__);

return statearr_73446;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq73398){
var G__73399 = cljs.core.first.call(null,seq73398);
var seq73398__$1 = cljs.core.next.call(null,seq73398);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73399,seq73398__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_73495){
var state_val_73496 = (state_73495[(1)]);
if((state_val_73496 === (7))){
var state_73495__$1 = state_73495;
var statearr_73497_73521 = state_73495__$1;
(statearr_73497_73521[(2)] = n);

(statearr_73497_73521[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73496 === (1))){
var state_73495__$1 = state_73495;
var statearr_73498_73522 = state_73495__$1;
(statearr_73498_73522[(2)] = null);

(statearr_73498_73522[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73496 === (4))){
var inst_73458 = (state_73495[(2)]);
var state_73495__$1 = state_73495;
var statearr_73499_73523 = state_73495__$1;
(statearr_73499_73523[(2)] = inst_73458);

(statearr_73499_73523[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73496 === (13))){
var inst_73475 = (state_73495[(2)]);
var inst_73476 = fluree.db.util.async.throw_err.call(null,inst_73475);
var state_73495__$1 = state_73495;
var statearr_73500_73524 = state_73495__$1;
(statearr_73500_73524[(2)] = inst_73476);

(statearr_73500_73524[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73496 === (6))){
var state_73495__$1 = state_73495;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73495__$1,(9),n);
} else {
if((state_val_73496 === (3))){
var inst_73493 = (state_73495[(2)]);
var state_73495__$1 = state_73495;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73495__$1,inst_73493);
} else {
if((state_val_73496 === (12))){
var inst_73471 = (state_73495[(7)]);
var inst_73479 = (state_73495[(2)]);
var inst_73480 = fluree.db.dbfunctions.internal.quot.call(null,inst_73471,inst_73479);
var inst_73481 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73482 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_73483 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73484 = [inst_73471,inst_73479];
var inst_73485 = (new cljs.core.PersistentVector(null,2,(5),inst_73483,inst_73484,null));
var inst_73486 = ["quot",inst_73485,inst_73480];
var inst_73487 = cljs.core.PersistentHashMap.fromArrays(inst_73482,inst_73486);
var inst_73488 = [inst_73487,(2)];
var inst_73489 = (new cljs.core.PersistentVector(null,2,(5),inst_73481,inst_73488,null));
var inst_73490 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_73489);
var _ = (function (){var statearr_73501 = state_73495;
(statearr_73501[(4)] = cljs.core.rest.call(null,(state_73495[(4)])));

return statearr_73501;
})();
var state_73495__$1 = (function (){var statearr_73502 = state_73495;
(statearr_73502[(8)] = inst_73490);

return statearr_73502;
})();
var statearr_73503_73525 = state_73495__$1;
(statearr_73503_73525[(2)] = inst_73480);

(statearr_73503_73525[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73496 === (2))){
var _ = (function (){var statearr_73504 = state_73495;
(statearr_73504[(4)] = cljs.core.cons.call(null,(5),(state_73495[(4)])));

return statearr_73504;
})();
var inst_73464 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_73495__$1 = state_73495;
if(inst_73464){
var statearr_73505_73526 = state_73495__$1;
(statearr_73505_73526[(1)] = (6));

} else {
var statearr_73506_73527 = state_73495__$1;
(statearr_73506_73527[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73496 === (11))){
var state_73495__$1 = state_73495;
var statearr_73508_73528 = state_73495__$1;
(statearr_73508_73528[(2)] = d);

(statearr_73508_73528[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73496 === (9))){
var inst_73467 = (state_73495[(2)]);
var inst_73468 = fluree.db.util.async.throw_err.call(null,inst_73467);
var state_73495__$1 = state_73495;
var statearr_73509_73529 = state_73495__$1;
(statearr_73509_73529[(2)] = inst_73468);

(statearr_73509_73529[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73496 === (5))){
var _ = (function (){var statearr_73510 = state_73495;
(statearr_73510[(4)] = cljs.core.rest.call(null,(state_73495[(4)])));

return statearr_73510;
})();
var state_73495__$1 = state_73495;
var ex73507 = (state_73495__$1[(2)]);
var statearr_73511_73530 = state_73495__$1;
(statearr_73511_73530[(5)] = ex73507);


if((ex73507 instanceof Error)){
var statearr_73512_73531 = state_73495__$1;
(statearr_73512_73531[(1)] = (4));

(statearr_73512_73531[(5)] = null);

} else {
throw ex73507;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73496 === (10))){
var state_73495__$1 = state_73495;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73495__$1,(13),d);
} else {
if((state_val_73496 === (8))){
var inst_73471 = (state_73495[(2)]);
var inst_73472 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_73495__$1 = (function (){var statearr_73513 = state_73495;
(statearr_73513[(7)] = inst_73471);

return statearr_73513;
})();
if(inst_73472){
var statearr_73514_73532 = state_73495__$1;
(statearr_73514_73532[(1)] = (10));

} else {
var statearr_73515_73533 = state_73495__$1;
(statearr_73515_73533[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__16221__auto____0 = (function (){
var statearr_73516 = [null,null,null,null,null,null,null,null,null];
(statearr_73516[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__16221__auto__);

(statearr_73516[(1)] = (1));

return statearr_73516;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__16221__auto____1 = (function (state_73495){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_73495);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e73517){var ex__16224__auto__ = e73517;
var statearr_73518_73534 = state_73495;
(statearr_73518_73534[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_73495[(4)]))){
var statearr_73519_73535 = state_73495;
(statearr_73519_73535[(1)] = cljs.core.first.call(null,(state_73495[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73536 = state_73495;
state_73495 = G__73536;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__16221__auto__ = function(state_73495){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__16221__auto____1.call(this,state_73495);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_73520 = f__16346__auto__.call(null);
(statearr_73520[(6)] = c__16345__auto__);

return statearr_73520;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_73574){
var state_val_73575 = (state_73574[(1)]);
if((state_val_73575 === (7))){
var state_73574__$1 = state_73574;
var statearr_73576_73600 = state_73574__$1;
(statearr_73576_73600[(2)] = n);

(statearr_73576_73600[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73575 === (1))){
var state_73574__$1 = state_73574;
var statearr_73577_73601 = state_73574__$1;
(statearr_73577_73601[(2)] = null);

(statearr_73577_73601[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73575 === (4))){
var inst_73537 = (state_73574[(2)]);
var state_73574__$1 = state_73574;
var statearr_73578_73602 = state_73574__$1;
(statearr_73578_73602[(2)] = inst_73537);

(statearr_73578_73602[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73575 === (13))){
var inst_73554 = (state_73574[(2)]);
var inst_73555 = fluree.db.util.async.throw_err.call(null,inst_73554);
var state_73574__$1 = state_73574;
var statearr_73579_73603 = state_73574__$1;
(statearr_73579_73603[(2)] = inst_73555);

(statearr_73579_73603[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73575 === (6))){
var state_73574__$1 = state_73574;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73574__$1,(9),n);
} else {
if((state_val_73575 === (3))){
var inst_73572 = (state_73574[(2)]);
var state_73574__$1 = state_73574;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73574__$1,inst_73572);
} else {
if((state_val_73575 === (12))){
var inst_73550 = (state_73574[(7)]);
var inst_73558 = (state_73574[(2)]);
var inst_73559 = fluree.db.dbfunctions.internal.mod.call(null,inst_73550,inst_73558);
var inst_73560 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73561 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_73562 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73563 = [inst_73550,inst_73558];
var inst_73564 = (new cljs.core.PersistentVector(null,2,(5),inst_73562,inst_73563,null));
var inst_73565 = ["mod",inst_73564,inst_73559];
var inst_73566 = cljs.core.PersistentHashMap.fromArrays(inst_73561,inst_73565);
var inst_73567 = [inst_73566,(2)];
var inst_73568 = (new cljs.core.PersistentVector(null,2,(5),inst_73560,inst_73567,null));
var inst_73569 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_73568);
var _ = (function (){var statearr_73580 = state_73574;
(statearr_73580[(4)] = cljs.core.rest.call(null,(state_73574[(4)])));

return statearr_73580;
})();
var state_73574__$1 = (function (){var statearr_73581 = state_73574;
(statearr_73581[(8)] = inst_73569);

return statearr_73581;
})();
var statearr_73582_73604 = state_73574__$1;
(statearr_73582_73604[(2)] = inst_73559);

(statearr_73582_73604[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73575 === (2))){
var _ = (function (){var statearr_73583 = state_73574;
(statearr_73583[(4)] = cljs.core.cons.call(null,(5),(state_73574[(4)])));

return statearr_73583;
})();
var inst_73543 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_73574__$1 = state_73574;
if(inst_73543){
var statearr_73584_73605 = state_73574__$1;
(statearr_73584_73605[(1)] = (6));

} else {
var statearr_73585_73606 = state_73574__$1;
(statearr_73585_73606[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73575 === (11))){
var state_73574__$1 = state_73574;
var statearr_73587_73607 = state_73574__$1;
(statearr_73587_73607[(2)] = d);

(statearr_73587_73607[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73575 === (9))){
var inst_73546 = (state_73574[(2)]);
var inst_73547 = fluree.db.util.async.throw_err.call(null,inst_73546);
var state_73574__$1 = state_73574;
var statearr_73588_73608 = state_73574__$1;
(statearr_73588_73608[(2)] = inst_73547);

(statearr_73588_73608[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73575 === (5))){
var _ = (function (){var statearr_73589 = state_73574;
(statearr_73589[(4)] = cljs.core.rest.call(null,(state_73574[(4)])));

return statearr_73589;
})();
var state_73574__$1 = state_73574;
var ex73586 = (state_73574__$1[(2)]);
var statearr_73590_73609 = state_73574__$1;
(statearr_73590_73609[(5)] = ex73586);


if((ex73586 instanceof Error)){
var statearr_73591_73610 = state_73574__$1;
(statearr_73591_73610[(1)] = (4));

(statearr_73591_73610[(5)] = null);

} else {
throw ex73586;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73575 === (10))){
var state_73574__$1 = state_73574;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73574__$1,(13),d);
} else {
if((state_val_73575 === (8))){
var inst_73550 = (state_73574[(2)]);
var inst_73551 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_73574__$1 = (function (){var statearr_73592 = state_73574;
(statearr_73592[(7)] = inst_73550);

return statearr_73592;
})();
if(inst_73551){
var statearr_73593_73611 = state_73574__$1;
(statearr_73593_73611[(1)] = (10));

} else {
var statearr_73594_73612 = state_73574__$1;
(statearr_73594_73612[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__16221__auto____0 = (function (){
var statearr_73595 = [null,null,null,null,null,null,null,null,null];
(statearr_73595[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__16221__auto__);

(statearr_73595[(1)] = (1));

return statearr_73595;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__16221__auto____1 = (function (state_73574){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_73574);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e73596){var ex__16224__auto__ = e73596;
var statearr_73597_73613 = state_73574;
(statearr_73597_73613[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_73574[(4)]))){
var statearr_73598_73614 = state_73574;
(statearr_73598_73614[(1)] = cljs.core.first.call(null,(state_73574[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73615 = state_73574;
state_73574 = G__73615;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__16221__auto__ = function(state_73574){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__16221__auto____1.call(this,state_73574);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_73599 = f__16346__auto__.call(null);
(statearr_73599[(6)] = c__16345__auto__);

return statearr_73599;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_73653){
var state_val_73654 = (state_73653[(1)]);
if((state_val_73654 === (7))){
var state_73653__$1 = state_73653;
var statearr_73655_73679 = state_73653__$1;
(statearr_73655_73679[(2)] = n);

(statearr_73655_73679[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73654 === (1))){
var state_73653__$1 = state_73653;
var statearr_73656_73680 = state_73653__$1;
(statearr_73656_73680[(2)] = null);

(statearr_73656_73680[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73654 === (4))){
var inst_73616 = (state_73653[(2)]);
var state_73653__$1 = state_73653;
var statearr_73657_73681 = state_73653__$1;
(statearr_73657_73681[(2)] = inst_73616);

(statearr_73657_73681[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73654 === (13))){
var inst_73633 = (state_73653[(2)]);
var inst_73634 = fluree.db.util.async.throw_err.call(null,inst_73633);
var state_73653__$1 = state_73653;
var statearr_73658_73682 = state_73653__$1;
(statearr_73658_73682[(2)] = inst_73634);

(statearr_73658_73682[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73654 === (6))){
var state_73653__$1 = state_73653;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73653__$1,(9),n);
} else {
if((state_val_73654 === (3))){
var inst_73651 = (state_73653[(2)]);
var state_73653__$1 = state_73653;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73653__$1,inst_73651);
} else {
if((state_val_73654 === (12))){
var inst_73629 = (state_73653[(7)]);
var inst_73637 = (state_73653[(2)]);
var inst_73638 = fluree.db.dbfunctions.internal.rem.call(null,inst_73629,inst_73637);
var inst_73639 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73640 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_73641 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73642 = [inst_73629,inst_73637];
var inst_73643 = (new cljs.core.PersistentVector(null,2,(5),inst_73641,inst_73642,null));
var inst_73644 = ["rem",inst_73643,inst_73638];
var inst_73645 = cljs.core.PersistentHashMap.fromArrays(inst_73640,inst_73644);
var inst_73646 = [inst_73645,(2)];
var inst_73647 = (new cljs.core.PersistentVector(null,2,(5),inst_73639,inst_73646,null));
var inst_73648 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_73647);
var _ = (function (){var statearr_73659 = state_73653;
(statearr_73659[(4)] = cljs.core.rest.call(null,(state_73653[(4)])));

return statearr_73659;
})();
var state_73653__$1 = (function (){var statearr_73660 = state_73653;
(statearr_73660[(8)] = inst_73648);

return statearr_73660;
})();
var statearr_73661_73683 = state_73653__$1;
(statearr_73661_73683[(2)] = inst_73638);

(statearr_73661_73683[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73654 === (2))){
var _ = (function (){var statearr_73662 = state_73653;
(statearr_73662[(4)] = cljs.core.cons.call(null,(5),(state_73653[(4)])));

return statearr_73662;
})();
var inst_73622 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_73653__$1 = state_73653;
if(inst_73622){
var statearr_73663_73684 = state_73653__$1;
(statearr_73663_73684[(1)] = (6));

} else {
var statearr_73664_73685 = state_73653__$1;
(statearr_73664_73685[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73654 === (11))){
var state_73653__$1 = state_73653;
var statearr_73666_73686 = state_73653__$1;
(statearr_73666_73686[(2)] = d);

(statearr_73666_73686[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73654 === (9))){
var inst_73625 = (state_73653[(2)]);
var inst_73626 = fluree.db.util.async.throw_err.call(null,inst_73625);
var state_73653__$1 = state_73653;
var statearr_73667_73687 = state_73653__$1;
(statearr_73667_73687[(2)] = inst_73626);

(statearr_73667_73687[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73654 === (5))){
var _ = (function (){var statearr_73668 = state_73653;
(statearr_73668[(4)] = cljs.core.rest.call(null,(state_73653[(4)])));

return statearr_73668;
})();
var state_73653__$1 = state_73653;
var ex73665 = (state_73653__$1[(2)]);
var statearr_73669_73688 = state_73653__$1;
(statearr_73669_73688[(5)] = ex73665);


if((ex73665 instanceof Error)){
var statearr_73670_73689 = state_73653__$1;
(statearr_73670_73689[(1)] = (4));

(statearr_73670_73689[(5)] = null);

} else {
throw ex73665;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73654 === (10))){
var state_73653__$1 = state_73653;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73653__$1,(13),d);
} else {
if((state_val_73654 === (8))){
var inst_73629 = (state_73653[(2)]);
var inst_73630 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_73653__$1 = (function (){var statearr_73671 = state_73653;
(statearr_73671[(7)] = inst_73629);

return statearr_73671;
})();
if(inst_73630){
var statearr_73672_73690 = state_73653__$1;
(statearr_73672_73690[(1)] = (10));

} else {
var statearr_73673_73691 = state_73653__$1;
(statearr_73673_73691[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__16221__auto____0 = (function (){
var statearr_73674 = [null,null,null,null,null,null,null,null,null];
(statearr_73674[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__16221__auto__);

(statearr_73674[(1)] = (1));

return statearr_73674;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__16221__auto____1 = (function (state_73653){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_73653);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e73675){var ex__16224__auto__ = e73675;
var statearr_73676_73692 = state_73653;
(statearr_73676_73692[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_73653[(4)]))){
var statearr_73677_73693 = state_73653;
(statearr_73677_73693[(1)] = cljs.core.first.call(null,(state_73653[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73694 = state_73653;
state_73653 = G__73694;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__16221__auto__ = function(state_73653){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__16221__auto____1.call(this,state_73653);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_73678 = f__16346__auto__.call(null);
(statearr_73678[(6)] = c__16345__auto__);

return statearr_73678;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_73721){
var state_val_73722 = (state_73721[(1)]);
if((state_val_73722 === (7))){
var state_73721__$1 = state_73721;
var statearr_73723_73742 = state_73721__$1;
(statearr_73723_73742[(2)] = x);

(statearr_73723_73742[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73722 === (1))){
var state_73721__$1 = state_73721;
var statearr_73724_73743 = state_73721__$1;
(statearr_73724_73743[(2)] = null);

(statearr_73724_73743[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73722 === (4))){
var inst_73695 = (state_73721[(2)]);
var state_73721__$1 = state_73721;
var statearr_73725_73744 = state_73721__$1;
(statearr_73725_73744[(2)] = inst_73695);

(statearr_73725_73744[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73722 === (6))){
var state_73721__$1 = state_73721;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73721__$1,(9),x);
} else {
if((state_val_73722 === (3))){
var inst_73719 = (state_73721[(2)]);
var state_73721__$1 = state_73721;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73721__$1,inst_73719);
} else {
if((state_val_73722 === (2))){
var _ = (function (){var statearr_73727 = state_73721;
(statearr_73727[(4)] = cljs.core.cons.call(null,(5),(state_73721[(4)])));

return statearr_73727;
})();
var inst_73701 = fluree.db.util.async.channel_QMARK_.call(null,x);
var state_73721__$1 = state_73721;
if(inst_73701){
var statearr_73728_73745 = state_73721__$1;
(statearr_73728_73745[(1)] = (6));

} else {
var statearr_73729_73746 = state_73721__$1;
(statearr_73729_73746[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73722 === (9))){
var inst_73704 = (state_73721[(2)]);
var inst_73705 = fluree.db.util.async.throw_err.call(null,inst_73704);
var state_73721__$1 = state_73721;
var statearr_73730_73747 = state_73721__$1;
(statearr_73730_73747[(2)] = inst_73705);

(statearr_73730_73747[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73722 === (5))){
var _ = (function (){var statearr_73731 = state_73721;
(statearr_73731[(4)] = cljs.core.rest.call(null,(state_73721[(4)])));

return statearr_73731;
})();
var state_73721__$1 = state_73721;
var ex73726 = (state_73721__$1[(2)]);
var statearr_73732_73748 = state_73721__$1;
(statearr_73732_73748[(5)] = ex73726);


if((ex73726 instanceof Error)){
var statearr_73733_73749 = state_73721__$1;
(statearr_73733_73749[(1)] = (4));

(statearr_73733_73749[(5)] = null);

} else {
throw ex73726;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73722 === (8))){
var inst_73708 = (state_73721[(2)]);
var inst_73709 = fluree.db.dbfunctions.internal.boolean$.call(null,inst_73708);
var inst_73710 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73711 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_73712 = ["boolean",inst_73708,inst_73709];
var inst_73713 = cljs.core.PersistentHashMap.fromArrays(inst_73711,inst_73712);
var inst_73714 = [inst_73713,(10)];
var inst_73715 = (new cljs.core.PersistentVector(null,2,(5),inst_73710,inst_73714,null));
var inst_73716 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_73715);
var _ = (function (){var statearr_73734 = state_73721;
(statearr_73734[(4)] = cljs.core.rest.call(null,(state_73721[(4)])));

return statearr_73734;
})();
var state_73721__$1 = (function (){var statearr_73735 = state_73721;
(statearr_73735[(7)] = inst_73716);

return statearr_73735;
})();
var statearr_73736_73750 = state_73721__$1;
(statearr_73736_73750[(2)] = inst_73709);

(statearr_73736_73750[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__16221__auto____0 = (function (){
var statearr_73737 = [null,null,null,null,null,null,null,null];
(statearr_73737[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__16221__auto__);

(statearr_73737[(1)] = (1));

return statearr_73737;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__16221__auto____1 = (function (state_73721){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_73721);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e73738){var ex__16224__auto__ = e73738;
var statearr_73739_73751 = state_73721;
(statearr_73739_73751[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_73721[(4)]))){
var statearr_73740_73752 = state_73721;
(statearr_73740_73752[(1)] = cljs.core.first.call(null,(state_73721[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73753 = state_73721;
state_73721 = G__73753;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__16221__auto__ = function(state_73721){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__16221__auto____1.call(this,state_73721);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_73741 = f__16346__auto__.call(null);
(statearr_73741[(6)] = c__16345__auto__);

return statearr_73741;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_73791){
var state_val_73792 = (state_73791[(1)]);
if((state_val_73792 === (7))){
var state_73791__$1 = state_73791;
var statearr_73793_73817 = state_73791__$1;
(statearr_73793_73817[(2)] = pattern);

(statearr_73793_73817[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73792 === (1))){
var state_73791__$1 = state_73791;
var statearr_73794_73818 = state_73791__$1;
(statearr_73794_73818[(2)] = null);

(statearr_73794_73818[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73792 === (4))){
var inst_73754 = (state_73791[(2)]);
var state_73791__$1 = state_73791;
var statearr_73795_73819 = state_73791__$1;
(statearr_73795_73819[(2)] = inst_73754);

(statearr_73795_73819[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73792 === (13))){
var inst_73771 = (state_73791[(2)]);
var inst_73772 = fluree.db.util.async.throw_err.call(null,inst_73771);
var state_73791__$1 = state_73791;
var statearr_73796_73820 = state_73791__$1;
(statearr_73796_73820[(2)] = inst_73772);

(statearr_73796_73820[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73792 === (6))){
var state_73791__$1 = state_73791;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73791__$1,(9),pattern);
} else {
if((state_val_73792 === (3))){
var inst_73789 = (state_73791[(2)]);
var state_73791__$1 = state_73791;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73791__$1,inst_73789);
} else {
if((state_val_73792 === (12))){
var inst_73767 = (state_73791[(7)]);
var inst_73775 = (state_73791[(2)]);
var inst_73776 = fluree.db.dbfunctions.internal.re_find.call(null,inst_73767,inst_73775);
var inst_73777 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73778 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_73779 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73780 = [inst_73767,inst_73775];
var inst_73781 = (new cljs.core.PersistentVector(null,2,(5),inst_73779,inst_73780,null));
var inst_73782 = ["re-find",inst_73781,inst_73776];
var inst_73783 = cljs.core.PersistentHashMap.fromArrays(inst_73778,inst_73782);
var inst_73784 = [inst_73783,(10)];
var inst_73785 = (new cljs.core.PersistentVector(null,2,(5),inst_73777,inst_73784,null));
var inst_73786 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_73785);
var _ = (function (){var statearr_73797 = state_73791;
(statearr_73797[(4)] = cljs.core.rest.call(null,(state_73791[(4)])));

return statearr_73797;
})();
var state_73791__$1 = (function (){var statearr_73798 = state_73791;
(statearr_73798[(8)] = inst_73786);

return statearr_73798;
})();
var statearr_73799_73821 = state_73791__$1;
(statearr_73799_73821[(2)] = inst_73776);

(statearr_73799_73821[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73792 === (2))){
var _ = (function (){var statearr_73800 = state_73791;
(statearr_73800[(4)] = cljs.core.cons.call(null,(5),(state_73791[(4)])));

return statearr_73800;
})();
var inst_73760 = fluree.db.util.async.channel_QMARK_.call(null,pattern);
var state_73791__$1 = state_73791;
if(inst_73760){
var statearr_73801_73822 = state_73791__$1;
(statearr_73801_73822[(1)] = (6));

} else {
var statearr_73802_73823 = state_73791__$1;
(statearr_73802_73823[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73792 === (11))){
var state_73791__$1 = state_73791;
var statearr_73804_73824 = state_73791__$1;
(statearr_73804_73824[(2)] = string);

(statearr_73804_73824[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73792 === (9))){
var inst_73763 = (state_73791[(2)]);
var inst_73764 = fluree.db.util.async.throw_err.call(null,inst_73763);
var state_73791__$1 = state_73791;
var statearr_73805_73825 = state_73791__$1;
(statearr_73805_73825[(2)] = inst_73764);

(statearr_73805_73825[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73792 === (5))){
var _ = (function (){var statearr_73806 = state_73791;
(statearr_73806[(4)] = cljs.core.rest.call(null,(state_73791[(4)])));

return statearr_73806;
})();
var state_73791__$1 = state_73791;
var ex73803 = (state_73791__$1[(2)]);
var statearr_73807_73826 = state_73791__$1;
(statearr_73807_73826[(5)] = ex73803);


if((ex73803 instanceof Error)){
var statearr_73808_73827 = state_73791__$1;
(statearr_73808_73827[(1)] = (4));

(statearr_73808_73827[(5)] = null);

} else {
throw ex73803;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73792 === (10))){
var state_73791__$1 = state_73791;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73791__$1,(13),string);
} else {
if((state_val_73792 === (8))){
var inst_73767 = (state_73791[(2)]);
var inst_73768 = fluree.db.util.async.channel_QMARK_.call(null,string);
var state_73791__$1 = (function (){var statearr_73809 = state_73791;
(statearr_73809[(7)] = inst_73767);

return statearr_73809;
})();
if(inst_73768){
var statearr_73810_73828 = state_73791__$1;
(statearr_73810_73828[(1)] = (10));

} else {
var statearr_73811_73829 = state_73791__$1;
(statearr_73811_73829[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__16221__auto____0 = (function (){
var statearr_73812 = [null,null,null,null,null,null,null,null,null];
(statearr_73812[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__16221__auto__);

(statearr_73812[(1)] = (1));

return statearr_73812;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__16221__auto____1 = (function (state_73791){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_73791);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e73813){var ex__16224__auto__ = e73813;
var statearr_73814_73830 = state_73791;
(statearr_73814_73830[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_73791[(4)]))){
var statearr_73815_73831 = state_73791;
(statearr_73815_73831[(1)] = cljs.core.first.call(null,(state_73791[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73832 = state_73791;
state_73791 = G__73832;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__16221__auto__ = function(state_73791){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__16221__auto____1.call(this,state_73791);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_73816 = f__16346__auto__.call(null);
(statearr_73816[(6)] = c__16345__auto__);

return statearr_73816;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_73859){
var state_val_73860 = (state_73859[(1)]);
if((state_val_73860 === (7))){
var state_73859__$1 = state_73859;
var statearr_73861_73880 = state_73859__$1;
(statearr_73861_73880[(2)] = email);

(statearr_73861_73880[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73860 === (1))){
var state_73859__$1 = state_73859;
var statearr_73862_73881 = state_73859__$1;
(statearr_73862_73881[(2)] = null);

(statearr_73862_73881[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73860 === (4))){
var inst_73833 = (state_73859[(2)]);
var state_73859__$1 = state_73859;
var statearr_73863_73882 = state_73859__$1;
(statearr_73863_73882[(2)] = inst_73833);

(statearr_73863_73882[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73860 === (6))){
var state_73859__$1 = state_73859;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73859__$1,(9),email);
} else {
if((state_val_73860 === (3))){
var inst_73857 = (state_73859[(2)]);
var state_73859__$1 = state_73859;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73859__$1,inst_73857);
} else {
if((state_val_73860 === (2))){
var _ = (function (){var statearr_73865 = state_73859;
(statearr_73865[(4)] = cljs.core.cons.call(null,(5),(state_73859[(4)])));

return statearr_73865;
})();
var inst_73839 = fluree.db.util.async.channel_QMARK_.call(null,email);
var state_73859__$1 = state_73859;
if(inst_73839){
var statearr_73866_73883 = state_73859__$1;
(statearr_73866_73883[(1)] = (6));

} else {
var statearr_73867_73884 = state_73859__$1;
(statearr_73867_73884[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73860 === (9))){
var inst_73842 = (state_73859[(2)]);
var inst_73843 = fluree.db.util.async.throw_err.call(null,inst_73842);
var state_73859__$1 = state_73859;
var statearr_73868_73885 = state_73859__$1;
(statearr_73868_73885[(2)] = inst_73843);

(statearr_73868_73885[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73860 === (5))){
var _ = (function (){var statearr_73869 = state_73859;
(statearr_73869[(4)] = cljs.core.rest.call(null,(state_73859[(4)])));

return statearr_73869;
})();
var state_73859__$1 = state_73859;
var ex73864 = (state_73859__$1[(2)]);
var statearr_73870_73886 = state_73859__$1;
(statearr_73870_73886[(5)] = ex73864);


if((ex73864 instanceof Error)){
var statearr_73871_73887 = state_73859__$1;
(statearr_73871_73887[(1)] = (4));

(statearr_73871_73887[(5)] = null);

} else {
throw ex73864;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73860 === (8))){
var inst_73846 = (state_73859[(2)]);
var inst_73847 = fluree.db.dbfunctions.internal.valid_email_QMARK_.call(null,inst_73846);
var inst_73848 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73849 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_73850 = ["re-find",inst_73846,inst_73847];
var inst_73851 = cljs.core.PersistentHashMap.fromArrays(inst_73849,inst_73850);
var inst_73852 = [inst_73851,(10)];
var inst_73853 = (new cljs.core.PersistentVector(null,2,(5),inst_73848,inst_73852,null));
var inst_73854 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_73853);
var _ = (function (){var statearr_73872 = state_73859;
(statearr_73872[(4)] = cljs.core.rest.call(null,(state_73859[(4)])));

return statearr_73872;
})();
var state_73859__$1 = (function (){var statearr_73873 = state_73859;
(statearr_73873[(7)] = inst_73854);

return statearr_73873;
})();
var statearr_73874_73888 = state_73859__$1;
(statearr_73874_73888[(2)] = inst_73847);

(statearr_73874_73888[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16221__auto____0 = (function (){
var statearr_73875 = [null,null,null,null,null,null,null,null];
(statearr_73875[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16221__auto__);

(statearr_73875[(1)] = (1));

return statearr_73875;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16221__auto____1 = (function (state_73859){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_73859);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e73876){var ex__16224__auto__ = e73876;
var statearr_73877_73889 = state_73859;
(statearr_73877_73889[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_73859[(4)]))){
var statearr_73878_73890 = state_73859;
(statearr_73878_73890[(1)] = cljs.core.first.call(null,(state_73859[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73891 = state_73859;
state_73859 = G__73891;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16221__auto__ = function(state_73859){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16221__auto____1.call(this,state_73859);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_73879 = f__16346__auto__.call(null);
(statearr_73879[(6)] = c__16345__auto__);

return statearr_73879;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_73938){
var state_val_73939 = (state_73938[(1)]);
if((state_val_73939 === (7))){
var inst_73908 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_73938__$1 = state_73938;
if(cljs.core.truth_(inst_73908)){
var statearr_73940_73967 = state_73938__$1;
(statearr_73940_73967[(1)] = (9));

} else {
var statearr_73941_73968 = state_73938__$1;
(statearr_73941_73968[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73939 === (1))){
var state_73938__$1 = state_73938;
var statearr_73942_73969 = state_73938__$1;
(statearr_73942_73969[(2)] = null);

(statearr_73942_73969[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73939 === (4))){
var inst_73892 = (state_73938[(2)]);
var state_73938__$1 = state_73938;
var statearr_73943_73970 = state_73938__$1;
(statearr_73943_73970[(2)] = inst_73892);

(statearr_73943_73970[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73939 === (15))){
var inst_73919 = (state_73938[(2)]);
var state_73938__$1 = state_73938;
var statearr_73944_73971 = state_73938__$1;
(statearr_73944_73971[(2)] = inst_73919);

(statearr_73944_73971[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73939 === (13))){
var inst_73916 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_73938__$1 = state_73938;
var statearr_73945_73972 = state_73938__$1;
(statearr_73945_73972[(2)] = inst_73916);

(statearr_73945_73972[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73939 === (6))){
var inst_73903 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73904 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_73905 = [inst_73904,(0)];
var inst_73906 = (new cljs.core.PersistentVector(null,2,(5),inst_73903,inst_73905,null));
var state_73938__$1 = state_73938;
var statearr_73946_73973 = state_73938__$1;
(statearr_73946_73973[(2)] = inst_73906);

(statearr_73946_73973[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73939 === (3))){
var inst_73936 = (state_73938[(2)]);
var state_73938__$1 = state_73938;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73938__$1,inst_73936);
} else {
if((state_val_73939 === (12))){
var inst_73912 = (state_73938[(2)]);
var inst_73913 = fluree.db.util.async.throw_err.call(null,inst_73912);
var state_73938__$1 = state_73938;
var statearr_73947_73974 = state_73938__$1;
(statearr_73947_73974[(2)] = inst_73913);

(statearr_73947_73974[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73939 === (2))){
var _ = (function (){var statearr_73948 = state_73938;
(statearr_73948[(4)] = cljs.core.cons.call(null,(5),(state_73938[(4)])));

return statearr_73948;
})();
var inst_73901 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_73938__$1 = state_73938;
if(cljs.core.truth_(inst_73901)){
var statearr_73949_73975 = state_73938__$1;
(statearr_73949_73975[(1)] = (6));

} else {
var statearr_73950_73976 = state_73938__$1;
(statearr_73950_73976[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73939 === (11))){
var inst_73921 = (state_73938[(2)]);
var state_73938__$1 = state_73938;
var statearr_73952_73977 = state_73938__$1;
(statearr_73952_73977[(2)] = inst_73921);

(statearr_73952_73977[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73939 === (9))){
var inst_73910 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth.call(null,_QMARK_ctx);
var state_73938__$1 = state_73938;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73938__$1,(12),inst_73910);
} else {
if((state_val_73939 === (5))){
var _ = (function (){var statearr_73953 = state_73938;
(statearr_73953[(4)] = cljs.core.rest.call(null,(state_73938[(4)])));

return statearr_73953;
})();
var state_73938__$1 = state_73938;
var ex73951 = (state_73938__$1[(2)]);
var statearr_73954_73978 = state_73938__$1;
(statearr_73954_73978[(5)] = ex73951);


if((ex73951 instanceof Error)){
var statearr_73955_73979 = state_73938__$1;
(statearr_73955_73979[(1)] = (4));

(statearr_73955_73979[(5)] = null);

} else {
throw ex73951;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73939 === (14))){
var state_73938__$1 = state_73938;
var statearr_73956_73980 = state_73938__$1;
(statearr_73956_73980[(2)] = null);

(statearr_73956_73980[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73939 === (10))){
var state_73938__$1 = state_73938;
var statearr_73957_73981 = state_73938__$1;
(statearr_73957_73981[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73939 === (8))){
var inst_73923 = (state_73938[(2)]);
var inst_73924 = cljs.core.nth.call(null,inst_73923,(0),null);
var inst_73925 = cljs.core.nth.call(null,inst_73923,(1),null);
var inst_73926 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73927 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_73928 = ["?user_id","?ctx",inst_73924];
var inst_73929 = cljs.core.PersistentHashMap.fromArrays(inst_73927,inst_73928);
var inst_73930 = ((10) + inst_73925);
var inst_73931 = [inst_73929,inst_73930];
var inst_73932 = (new cljs.core.PersistentVector(null,2,(5),inst_73926,inst_73931,null));
var inst_73933 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_73932);
var _ = (function (){var statearr_73959 = state_73938;
(statearr_73959[(4)] = cljs.core.rest.call(null,(state_73938[(4)])));

return statearr_73959;
})();
var state_73938__$1 = (function (){var statearr_73960 = state_73938;
(statearr_73960[(7)] = inst_73933);

return statearr_73960;
})();
var statearr_73961_73982 = state_73938__$1;
(statearr_73961_73982[(2)] = inst_73924);

(statearr_73961_73982[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16221__auto____0 = (function (){
var statearr_73962 = [null,null,null,null,null,null,null,null];
(statearr_73962[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16221__auto__);

(statearr_73962[(1)] = (1));

return statearr_73962;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16221__auto____1 = (function (state_73938){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_73938);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e73963){var ex__16224__auto__ = e73963;
var statearr_73964_73983 = state_73938;
(statearr_73964_73983[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_73938[(4)]))){
var statearr_73965_73984 = state_73938;
(statearr_73965_73984[(1)] = cljs.core.first.call(null,(state_73938[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73985 = state_73938;
state_73938 = G__73985;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16221__auto__ = function(state_73938){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16221__auto____1.call(this,state_73938);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_73966 = f__16346__auto__.call(null);
(statearr_73966[(6)] = c__16345__auto__);

return statearr_73966;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_74013){
var state_val_74014 = (state_74013[(1)]);
if((state_val_74014 === (7))){
var inst_74006 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_74013__$1 = state_74013;
var statearr_74015_74034 = state_74013__$1;
(statearr_74015_74034[(2)] = inst_74006);

(statearr_74015_74034[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74014 === (1))){
var state_74013__$1 = state_74013;
var statearr_74016_74035 = state_74013__$1;
(statearr_74016_74035[(2)] = null);

(statearr_74016_74035[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74014 === (4))){
var inst_73986 = (state_74013[(2)]);
var state_74013__$1 = state_74013;
var statearr_74017_74036 = state_74013__$1;
(statearr_74017_74036[(2)] = inst_73986);

(statearr_74017_74036[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74014 === (6))){
var inst_73994 = fluree.db.dbfunctions.internal._QMARK_auth_id.call(null,_QMARK_ctx);
var state_74013__$1 = state_74013;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74013__$1,(9),inst_73994);
} else {
if((state_val_74014 === (3))){
var inst_74011 = (state_74013[(2)]);
var state_74013__$1 = state_74013;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74013__$1,inst_74011);
} else {
if((state_val_74014 === (2))){
var _ = (function (){var statearr_74019 = state_74013;
(statearr_74019[(4)] = cljs.core.cons.call(null,(5),(state_74013[(4)])));

return statearr_74019;
})();
var inst_73992 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_74013__$1 = state_74013;
if(cljs.core.truth_(inst_73992)){
var statearr_74020_74037 = state_74013__$1;
(statearr_74020_74037[(1)] = (6));

} else {
var statearr_74021_74038 = state_74013__$1;
(statearr_74021_74038[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74014 === (9))){
var inst_73996 = (state_74013[(2)]);
var inst_73997 = fluree.db.util.async.throw_err.call(null,inst_73996);
var inst_73998 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73999 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_74000 = ["?auth_id","?ctx",inst_73997];
var inst_74001 = cljs.core.PersistentHashMap.fromArrays(inst_73999,inst_74000);
var inst_74002 = [inst_74001,(10)];
var inst_74003 = (new cljs.core.PersistentVector(null,2,(5),inst_73998,inst_74002,null));
var inst_74004 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_74003);
var state_74013__$1 = (function (){var statearr_74022 = state_74013;
(statearr_74022[(7)] = inst_74004);

return statearr_74022;
})();
var statearr_74023_74039 = state_74013__$1;
(statearr_74023_74039[(2)] = inst_73997);

(statearr_74023_74039[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74014 === (5))){
var _ = (function (){var statearr_74024 = state_74013;
(statearr_74024[(4)] = cljs.core.rest.call(null,(state_74013[(4)])));

return statearr_74024;
})();
var state_74013__$1 = state_74013;
var ex74018 = (state_74013__$1[(2)]);
var statearr_74025_74040 = state_74013__$1;
(statearr_74025_74040[(5)] = ex74018);


if((ex74018 instanceof Error)){
var statearr_74026_74041 = state_74013__$1;
(statearr_74026_74041[(1)] = (4));

(statearr_74026_74041[(5)] = null);

} else {
throw ex74018;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74014 === (8))){
var inst_74008 = (state_74013[(2)]);
var _ = (function (){var statearr_74027 = state_74013;
(statearr_74027[(4)] = cljs.core.rest.call(null,(state_74013[(4)])));

return statearr_74027;
})();
var state_74013__$1 = state_74013;
var statearr_74028_74042 = state_74013__$1;
(statearr_74028_74042[(2)] = inst_74008);

(statearr_74028_74042[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16221__auto____0 = (function (){
var statearr_74029 = [null,null,null,null,null,null,null,null];
(statearr_74029[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16221__auto__);

(statearr_74029[(1)] = (1));

return statearr_74029;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16221__auto____1 = (function (state_74013){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_74013);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e74030){var ex__16224__auto__ = e74030;
var statearr_74031_74043 = state_74013;
(statearr_74031_74043[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_74013[(4)]))){
var statearr_74032_74044 = state_74013;
(statearr_74032_74044[(1)] = cljs.core.first.call(null,(state_74013[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74045 = state_74013;
state_74013 = G__74045;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16221__auto__ = function(state_74013){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16221__auto____1.call(this,state_74013);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_74033 = f__16346__auto__.call(null);
(statearr_74033[(6)] = c__16345__auto__);

return statearr_74033;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__74047 = arguments.length;
switch (G__74047) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.call(null,_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_74089){
var state_val_74090 = (state_74089[(1)]);
if((state_val_74090 === (7))){
var state_74089__$1 = state_74089;
var statearr_74091_74121 = state_74089__$1;
(statearr_74091_74121[(2)] = seed);

(statearr_74091_74121[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74090 === (1))){
var state_74089__$1 = state_74089;
var statearr_74092_74122 = state_74089__$1;
(statearr_74092_74122[(2)] = null);

(statearr_74092_74122[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74090 === (4))){
var inst_74048 = (state_74089[(2)]);
var state_74089__$1 = state_74089;
var statearr_74093_74123 = state_74089__$1;
(statearr_74093_74123[(2)] = inst_74048);

(statearr_74093_74123[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74090 === (15))){
var state_74089__$1 = state_74089;
var statearr_74094_74124 = state_74089__$1;
(statearr_74094_74124[(2)] = (10));

(statearr_74094_74124[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74090 === (13))){
var inst_74065 = (state_74089[(2)]);
var inst_74066 = fluree.db.util.async.throw_err.call(null,inst_74065);
var state_74089__$1 = state_74089;
var statearr_74095_74125 = state_74089__$1;
(statearr_74095_74125[(2)] = inst_74066);

(statearr_74095_74125[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74090 === (6))){
var state_74089__$1 = state_74089;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74089__$1,(9),seed);
} else {
if((state_val_74090 === (3))){
var inst_74087 = (state_74089[(2)]);
var state_74089__$1 = state_74089;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74089__$1,inst_74087);
} else {
if((state_val_74090 === (12))){
var inst_74069 = (state_74089[(7)]);
var inst_74069__$1 = (state_74089[(2)]);
var state_74089__$1 = (function (){var statearr_74096 = state_74089;
(statearr_74096[(7)] = inst_74069__$1);

return statearr_74096;
})();
if(cljs.core.truth_(inst_74069__$1)){
var statearr_74097_74126 = state_74089__$1;
(statearr_74097_74126[(1)] = (14));

} else {
var statearr_74098_74127 = state_74089__$1;
(statearr_74098_74127[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74090 === (2))){
var _ = (function (){var statearr_74099 = state_74089;
(statearr_74099[(4)] = cljs.core.cons.call(null,(5),(state_74089[(4)])));

return statearr_74099;
})();
var inst_74054 = fluree.db.util.async.channel_QMARK_.call(null,seed);
var state_74089__$1 = state_74089;
if(inst_74054){
var statearr_74100_74128 = state_74089__$1;
(statearr_74100_74128[(1)] = (6));

} else {
var statearr_74101_74129 = state_74089__$1;
(statearr_74101_74129[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74090 === (11))){
var state_74089__$1 = state_74089;
var statearr_74103_74130 = state_74089__$1;
(statearr_74103_74130[(2)] = max);

(statearr_74103_74130[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74090 === (9))){
var inst_74057 = (state_74089[(2)]);
var inst_74058 = fluree.db.util.async.throw_err.call(null,inst_74057);
var state_74089__$1 = state_74089;
var statearr_74104_74131 = state_74089__$1;
(statearr_74104_74131[(2)] = inst_74058);

(statearr_74104_74131[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74090 === (5))){
var _ = (function (){var statearr_74105 = state_74089;
(statearr_74105[(4)] = cljs.core.rest.call(null,(state_74089[(4)])));

return statearr_74105;
})();
var state_74089__$1 = state_74089;
var ex74102 = (state_74089__$1[(2)]);
var statearr_74106_74132 = state_74089__$1;
(statearr_74106_74132[(5)] = ex74102);


if((ex74102 instanceof Error)){
var statearr_74107_74133 = state_74089__$1;
(statearr_74107_74133[(1)] = (4));

(statearr_74107_74133[(5)] = null);

} else {
throw ex74102;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74090 === (14))){
var inst_74069 = (state_74089[(7)]);
var state_74089__$1 = state_74089;
var statearr_74108_74134 = state_74089__$1;
(statearr_74108_74134[(2)] = inst_74069);

(statearr_74108_74134[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74090 === (16))){
var inst_74061 = (state_74089[(8)]);
var inst_74073 = (state_74089[(2)]);
var inst_74074 = fluree.db.dbfunctions.internal.rand.call(null,inst_74061,inst_74073);
var inst_74075 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74076 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_74077 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74078 = [max,seed];
var inst_74079 = (new cljs.core.PersistentVector(null,2,(5),inst_74077,inst_74078,null));
var inst_74080 = ["rand",inst_74079,inst_74074];
var inst_74081 = cljs.core.PersistentHashMap.fromArrays(inst_74076,inst_74080);
var inst_74082 = [inst_74081,(10)];
var inst_74083 = (new cljs.core.PersistentVector(null,2,(5),inst_74075,inst_74082,null));
var inst_74084 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_74083);
var _ = (function (){var statearr_74109 = state_74089;
(statearr_74109[(4)] = cljs.core.rest.call(null,(state_74089[(4)])));

return statearr_74109;
})();
var state_74089__$1 = (function (){var statearr_74110 = state_74089;
(statearr_74110[(9)] = inst_74084);

return statearr_74110;
})();
var statearr_74111_74135 = state_74089__$1;
(statearr_74111_74135[(2)] = inst_74074);

(statearr_74111_74135[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74090 === (10))){
var state_74089__$1 = state_74089;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74089__$1,(13),max);
} else {
if((state_val_74090 === (8))){
var inst_74061 = (state_74089[(2)]);
var inst_74062 = fluree.db.util.async.channel_QMARK_.call(null,max);
var state_74089__$1 = (function (){var statearr_74112 = state_74089;
(statearr_74112[(8)] = inst_74061);

return statearr_74112;
})();
if(inst_74062){
var statearr_74113_74136 = state_74089__$1;
(statearr_74113_74136[(1)] = (10));

} else {
var statearr_74114_74137 = state_74089__$1;
(statearr_74114_74137[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16221__auto____0 = (function (){
var statearr_74115 = [null,null,null,null,null,null,null,null,null,null];
(statearr_74115[(0)] = fluree$db$dbfunctions$fns$state_machine__16221__auto__);

(statearr_74115[(1)] = (1));

return statearr_74115;
});
var fluree$db$dbfunctions$fns$state_machine__16221__auto____1 = (function (state_74089){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_74089);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e74116){var ex__16224__auto__ = e74116;
var statearr_74117_74138 = state_74089;
(statearr_74117_74138[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_74089[(4)]))){
var statearr_74118_74139 = state_74089;
(statearr_74118_74139[(1)] = cljs.core.first.call(null,(state_74089[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74140 = state_74089;
state_74089 = G__74140;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16221__auto__ = function(state_74089){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16221__auto____1.call(this,state_74089);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_74119 = f__16346__auto__.call(null);
(statearr_74119[(6)] = c__16345__auto__);

return statearr_74119;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_74161){
var state_val_74162 = (state_74161[(1)]);
if((state_val_74162 === (1))){
var state_74161__$1 = state_74161;
var statearr_74163_74178 = state_74161__$1;
(statearr_74163_74178[(2)] = null);

(statearr_74163_74178[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74162 === (2))){
var _ = (function (){var statearr_74164 = state_74161;
(statearr_74164[(4)] = cljs.core.cons.call(null,(5),(state_74161[(4)])));

return statearr_74164;
})();
var inst_74147 = fluree.db.util.core.random_uuid.call(null);
var inst_74148 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74147);
var inst_74149 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74150 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_74151 = cljs.core.PersistentVector.EMPTY;
var inst_74152 = ["uuid",inst_74151,inst_74148];
var inst_74153 = cljs.core.PersistentHashMap.fromArrays(inst_74150,inst_74152);
var inst_74154 = [inst_74153,(10)];
var inst_74155 = (new cljs.core.PersistentVector(null,2,(5),inst_74149,inst_74154,null));
var inst_74156 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_74155);
var ___$1 = (function (){var statearr_74165 = state_74161;
(statearr_74165[(4)] = cljs.core.rest.call(null,(state_74161[(4)])));

return statearr_74165;
})();
var state_74161__$1 = (function (){var statearr_74166 = state_74161;
(statearr_74166[(7)] = inst_74156);

return statearr_74166;
})();
var statearr_74167_74179 = state_74161__$1;
(statearr_74167_74179[(2)] = inst_74148);

(statearr_74167_74179[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74162 === (3))){
var inst_74159 = (state_74161[(2)]);
var state_74161__$1 = state_74161;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74161__$1,inst_74159);
} else {
if((state_val_74162 === (4))){
var inst_74141 = (state_74161[(2)]);
var state_74161__$1 = state_74161;
var statearr_74169_74180 = state_74161__$1;
(statearr_74169_74180[(2)] = inst_74141);

(statearr_74169_74180[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74162 === (5))){
var _ = (function (){var statearr_74170 = state_74161;
(statearr_74170[(4)] = cljs.core.rest.call(null,(state_74161[(4)])));

return statearr_74170;
})();
var state_74161__$1 = state_74161;
var ex74168 = (state_74161__$1[(2)]);
var statearr_74171_74181 = state_74161__$1;
(statearr_74171_74181[(5)] = ex74168);


if((ex74168 instanceof Error)){
var statearr_74172_74182 = state_74161__$1;
(statearr_74172_74182[(1)] = (4));

(statearr_74172_74182[(5)] = null);

} else {
throw ex74168;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__16221__auto____0 = (function (){
var statearr_74173 = [null,null,null,null,null,null,null,null];
(statearr_74173[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__16221__auto__);

(statearr_74173[(1)] = (1));

return statearr_74173;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__16221__auto____1 = (function (state_74161){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_74161);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e74174){var ex__16224__auto__ = e74174;
var statearr_74175_74183 = state_74161;
(statearr_74175_74183[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_74161[(4)]))){
var statearr_74176_74184 = state_74161;
(statearr_74176_74184[(1)] = cljs.core.first.call(null,(state_74161[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74185 = state_74161;
state_74161 = G__74185;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__16221__auto__ = function(state_74161){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__16221__auto____1.call(this,state_74161);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_74177 = f__16346__auto__.call(null);
(statearr_74177[(6)] = c__16345__auto__);

return statearr_74177;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_74215){
var state_val_74216 = (state_74215[(1)]);
if((state_val_74216 === (7))){
var state_74215__$1 = state_74215;
var statearr_74217_74236 = state_74215__$1;
(statearr_74217_74236[(2)] = num);

(statearr_74217_74236[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74216 === (1))){
var state_74215__$1 = state_74215;
var statearr_74218_74237 = state_74215__$1;
(statearr_74218_74237[(2)] = null);

(statearr_74218_74237[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74216 === (4))){
var inst_74186 = (state_74215[(2)]);
var state_74215__$1 = state_74215;
var statearr_74219_74238 = state_74215__$1;
(statearr_74219_74238[(2)] = inst_74186);

(statearr_74219_74238[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74216 === (6))){
var state_74215__$1 = state_74215;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74215__$1,(9),num);
} else {
if((state_val_74216 === (3))){
var inst_74213 = (state_74215[(2)]);
var state_74215__$1 = state_74215;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74215__$1,inst_74213);
} else {
if((state_val_74216 === (2))){
var _ = (function (){var statearr_74221 = state_74215;
(statearr_74221[(4)] = cljs.core.cons.call(null,(5),(state_74215[(4)])));

return statearr_74221;
})();
var inst_74192 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_74215__$1 = state_74215;
if(inst_74192){
var statearr_74222_74239 = state_74215__$1;
(statearr_74222_74239[(1)] = (6));

} else {
var statearr_74223_74240 = state_74215__$1;
(statearr_74223_74240[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74216 === (9))){
var inst_74195 = (state_74215[(2)]);
var inst_74196 = fluree.db.util.async.throw_err.call(null,inst_74195);
var state_74215__$1 = state_74215;
var statearr_74224_74241 = state_74215__$1;
(statearr_74224_74241[(2)] = inst_74196);

(statearr_74224_74241[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74216 === (5))){
var _ = (function (){var statearr_74225 = state_74215;
(statearr_74225[(4)] = cljs.core.rest.call(null,(state_74215[(4)])));

return statearr_74225;
})();
var state_74215__$1 = state_74215;
var ex74220 = (state_74215__$1[(2)]);
var statearr_74226_74242 = state_74215__$1;
(statearr_74226_74242[(5)] = ex74220);


if((ex74220 instanceof Error)){
var statearr_74227_74243 = state_74215__$1;
(statearr_74227_74243[(1)] = (4));

(statearr_74227_74243[(5)] = null);

} else {
throw ex74220;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74216 === (8))){
var inst_74199 = (state_74215[(2)]);
var inst_74200 = fluree.db.dbfunctions.internal.ceil.call(null,inst_74199);
var inst_74201 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74202 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_74203 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74204 = [fluree.db.dbfunctions.fns.ceil];
var inst_74205 = (new cljs.core.PersistentVector(null,1,(5),inst_74203,inst_74204,null));
var inst_74206 = ["",inst_74205,inst_74200];
var inst_74207 = cljs.core.PersistentHashMap.fromArrays(inst_74202,inst_74206);
var inst_74208 = [inst_74207,(10)];
var inst_74209 = (new cljs.core.PersistentVector(null,2,(5),inst_74201,inst_74208,null));
var inst_74210 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_74209);
var _ = (function (){var statearr_74228 = state_74215;
(statearr_74228[(4)] = cljs.core.rest.call(null,(state_74215[(4)])));

return statearr_74228;
})();
var state_74215__$1 = (function (){var statearr_74229 = state_74215;
(statearr_74229[(7)] = inst_74210);

return statearr_74229;
})();
var statearr_74230_74244 = state_74215__$1;
(statearr_74230_74244[(2)] = inst_74200);

(statearr_74230_74244[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__16221__auto____0 = (function (){
var statearr_74231 = [null,null,null,null,null,null,null,null];
(statearr_74231[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__16221__auto__);

(statearr_74231[(1)] = (1));

return statearr_74231;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__16221__auto____1 = (function (state_74215){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_74215);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e74232){var ex__16224__auto__ = e74232;
var statearr_74233_74245 = state_74215;
(statearr_74233_74245[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_74215[(4)]))){
var statearr_74234_74246 = state_74215;
(statearr_74234_74246[(1)] = cljs.core.first.call(null,(state_74215[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74247 = state_74215;
state_74215 = G__74247;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__16221__auto__ = function(state_74215){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__16221__auto____1.call(this,state_74215);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_74235 = f__16346__auto__.call(null);
(statearr_74235[(6)] = c__16345__auto__);

return statearr_74235;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_74277){
var state_val_74278 = (state_74277[(1)]);
if((state_val_74278 === (7))){
var state_74277__$1 = state_74277;
var statearr_74279_74298 = state_74277__$1;
(statearr_74279_74298[(2)] = num);

(statearr_74279_74298[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74278 === (1))){
var state_74277__$1 = state_74277;
var statearr_74280_74299 = state_74277__$1;
(statearr_74280_74299[(2)] = null);

(statearr_74280_74299[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74278 === (4))){
var inst_74248 = (state_74277[(2)]);
var state_74277__$1 = state_74277;
var statearr_74281_74300 = state_74277__$1;
(statearr_74281_74300[(2)] = inst_74248);

(statearr_74281_74300[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74278 === (6))){
var state_74277__$1 = state_74277;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74277__$1,(9),num);
} else {
if((state_val_74278 === (3))){
var inst_74275 = (state_74277[(2)]);
var state_74277__$1 = state_74277;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74277__$1,inst_74275);
} else {
if((state_val_74278 === (2))){
var _ = (function (){var statearr_74283 = state_74277;
(statearr_74283[(4)] = cljs.core.cons.call(null,(5),(state_74277[(4)])));

return statearr_74283;
})();
var inst_74254 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_74277__$1 = state_74277;
if(inst_74254){
var statearr_74284_74301 = state_74277__$1;
(statearr_74284_74301[(1)] = (6));

} else {
var statearr_74285_74302 = state_74277__$1;
(statearr_74285_74302[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74278 === (9))){
var inst_74257 = (state_74277[(2)]);
var inst_74258 = fluree.db.util.async.throw_err.call(null,inst_74257);
var state_74277__$1 = state_74277;
var statearr_74286_74303 = state_74277__$1;
(statearr_74286_74303[(2)] = inst_74258);

(statearr_74286_74303[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74278 === (5))){
var _ = (function (){var statearr_74287 = state_74277;
(statearr_74287[(4)] = cljs.core.rest.call(null,(state_74277[(4)])));

return statearr_74287;
})();
var state_74277__$1 = state_74277;
var ex74282 = (state_74277__$1[(2)]);
var statearr_74288_74304 = state_74277__$1;
(statearr_74288_74304[(5)] = ex74282);


if((ex74282 instanceof Error)){
var statearr_74289_74305 = state_74277__$1;
(statearr_74289_74305[(1)] = (4));

(statearr_74289_74305[(5)] = null);

} else {
throw ex74282;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74278 === (8))){
var inst_74261 = (state_74277[(2)]);
var inst_74262 = fluree.db.dbfunctions.internal.floor.call(null,inst_74261);
var inst_74263 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74264 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_74265 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74266 = [fluree.db.dbfunctions.fns.floor];
var inst_74267 = (new cljs.core.PersistentVector(null,1,(5),inst_74265,inst_74266,null));
var inst_74268 = ["",inst_74267,inst_74262];
var inst_74269 = cljs.core.PersistentHashMap.fromArrays(inst_74264,inst_74268);
var inst_74270 = [inst_74269,(10)];
var inst_74271 = (new cljs.core.PersistentVector(null,2,(5),inst_74263,inst_74270,null));
var inst_74272 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_74271);
var _ = (function (){var statearr_74290 = state_74277;
(statearr_74290[(4)] = cljs.core.rest.call(null,(state_74277[(4)])));

return statearr_74290;
})();
var state_74277__$1 = (function (){var statearr_74291 = state_74277;
(statearr_74291[(7)] = inst_74272);

return statearr_74291;
})();
var statearr_74292_74306 = state_74277__$1;
(statearr_74292_74306[(2)] = inst_74262);

(statearr_74292_74306[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__16221__auto____0 = (function (){
var statearr_74293 = [null,null,null,null,null,null,null,null];
(statearr_74293[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__16221__auto__);

(statearr_74293[(1)] = (1));

return statearr_74293;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__16221__auto____1 = (function (state_74277){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_74277);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e74294){var ex__16224__auto__ = e74294;
var statearr_74295_74307 = state_74277;
(statearr_74295_74307[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_74277[(4)]))){
var statearr_74296_74308 = state_74277;
(statearr_74296_74308[(1)] = cljs.core.first.call(null,(state_74277[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74309 = state_74277;
state_74277 = G__74309;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__16221__auto__ = function(state_74277){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__16221__auto____1.call(this,state_74277);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_74297 = f__16346__auto__.call(null);
(statearr_74297[(6)] = c__16345__auto__);

return statearr_74297;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_74334){
var state_val_74335 = (state_74334[(1)]);
if((state_val_74335 === (1))){
var state_74334__$1 = state_74334;
var statearr_74336_74351 = state_74334__$1;
(statearr_74336_74351[(2)] = null);

(statearr_74336_74351[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74335 === (2))){
var _ = (function (){var statearr_74337 = state_74334;
(statearr_74337[(4)] = cljs.core.cons.call(null,(5),(state_74334[(4)])));

return statearr_74337;
})();
var inst_74316 = fluree.db.dbfunctions.internal.cas.call(null,_QMARK_ctx,compare_val,new_val);
var state_74334__$1 = state_74334;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74334__$1,(6),inst_74316);
} else {
if((state_val_74335 === (3))){
var inst_74332 = (state_74334[(2)]);
var state_74334__$1 = state_74334;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74334__$1,inst_74332);
} else {
if((state_val_74335 === (4))){
var inst_74310 = (state_74334[(2)]);
var state_74334__$1 = state_74334;
var statearr_74339_74352 = state_74334__$1;
(statearr_74339_74352[(2)] = inst_74310);

(statearr_74339_74352[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74335 === (5))){
var _ = (function (){var statearr_74340 = state_74334;
(statearr_74340[(4)] = cljs.core.rest.call(null,(state_74334[(4)])));

return statearr_74340;
})();
var state_74334__$1 = state_74334;
var ex74338 = (state_74334__$1[(2)]);
var statearr_74341_74353 = state_74334__$1;
(statearr_74341_74353[(5)] = ex74338);


if((ex74338 instanceof Error)){
var statearr_74342_74354 = state_74334__$1;
(statearr_74342_74354[(1)] = (4));

(statearr_74342_74354[(5)] = null);

} else {
throw ex74338;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74335 === (6))){
var inst_74318 = (state_74334[(2)]);
var inst_74319 = fluree.db.util.async.throw_err.call(null,inst_74318);
var inst_74320 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74321 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_74322 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74323 = [compare_val,new_val];
var inst_74324 = (new cljs.core.PersistentVector(null,2,(5),inst_74322,inst_74323,null));
var inst_74325 = ["",inst_74324,inst_74319];
var inst_74326 = cljs.core.PersistentHashMap.fromArrays(inst_74321,inst_74325);
var inst_74327 = [inst_74326,(10)];
var inst_74328 = (new cljs.core.PersistentVector(null,2,(5),inst_74320,inst_74327,null));
var inst_74329 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_74328);
var _ = (function (){var statearr_74343 = state_74334;
(statearr_74343[(4)] = cljs.core.rest.call(null,(state_74334[(4)])));

return statearr_74343;
})();
var state_74334__$1 = (function (){var statearr_74344 = state_74334;
(statearr_74344[(7)] = inst_74329);

return statearr_74344;
})();
var statearr_74345_74355 = state_74334__$1;
(statearr_74345_74355[(2)] = inst_74319);

(statearr_74345_74355[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__16221__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__16221__auto____0 = (function (){
var statearr_74346 = [null,null,null,null,null,null,null,null];
(statearr_74346[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__16221__auto__);

(statearr_74346[(1)] = (1));

return statearr_74346;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__16221__auto____1 = (function (state_74334){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_74334);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e74347){var ex__16224__auto__ = e74347;
var statearr_74348_74356 = state_74334;
(statearr_74348_74356[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_74334[(4)]))){
var statearr_74349_74357 = state_74334;
(statearr_74349_74357[(1)] = cljs.core.first.call(null,(state_74334[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74358 = state_74334;
state_74334 = G__74358;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__16221__auto__ = function(state_74334){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__16221__auto____1.call(this,state_74334);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__16221__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__16221__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_74350 = f__16346__auto__.call(null);
(statearr_74350[(6)] = c__16345__auto__);

return statearr_74350;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
