// Compiled by ClojureScript 1.10.879 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__79123_79292 = cljs.core.seq.call(null,servers);
var chunk__79124_79293 = null;
var count__79125_79294 = (0);
var i__79126_79295 = (0);
while(true){
if((i__79126_79295 < count__79125_79294)){
var server_79296 = cljs.core._nth.call(null,chunk__79124_79293,i__79126_79295);
var healthcheck_uri_79297 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_79296),"/fdb/health"].join('');
var resp_chan_79298 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_79297,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__16345__auto___79299 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__79123_79292,chunk__79124_79293,count__79125_79294,i__79126_79295,c__16345__auto___79299,healthcheck_uri_79297,resp_chan_79298,server_79296){
return (function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = ((function (seq__79123_79292,chunk__79124_79293,count__79125_79294,i__79126_79295,c__16345__auto___79299,healthcheck_uri_79297,resp_chan_79298,server_79296){
return (function (state_79187){
var state_val_79188 = (state_79187[(1)]);
if((state_val_79188 === (1))){
var state_79187__$1 = state_79187;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_79187__$1,(2),resp_chan_79298);
} else {
if((state_val_79188 === (2))){
var inst_79176 = (state_79187[(7)]);
var inst_79176__$1 = (state_79187[(2)]);
var inst_79177 = fluree.db.util.core.exception_QMARK_.call(null,inst_79176__$1);
var state_79187__$1 = (function (){var statearr_79189 = state_79187;
(statearr_79189[(7)] = inst_79176__$1);

return statearr_79189;
})();
if(inst_79177){
var statearr_79190_79300 = state_79187__$1;
(statearr_79190_79300[(1)] = (3));

} else {
var statearr_79191_79301 = state_79187__$1;
(statearr_79191_79301[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79188 === (3))){
var inst_79176 = (state_79187[(7)]);
var inst_79179 = cljs.core.ex_message.call(null,inst_79176);
var inst_79180 = cljs.core.ex_data.call(null,inst_79176);
var inst_79181 = fluree.db.util.log.warn.call(null,"Server contact error: ",inst_79179,inst_79180);
var state_79187__$1 = state_79187;
var statearr_79192_79302 = state_79187__$1;
(statearr_79192_79302[(2)] = inst_79181);

(statearr_79192_79302[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79188 === (4))){
var inst_79183 = cljs.core.async.put_BANG_.call(null,promise_chan,server_79296);
var state_79187__$1 = state_79187;
var statearr_79193_79303 = state_79187__$1;
(statearr_79193_79303[(2)] = inst_79183);

(statearr_79193_79303[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79188 === (5))){
var inst_79185 = (state_79187[(2)]);
var state_79187__$1 = state_79187;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79187__$1,inst_79185);
} else {
return null;
}
}
}
}
}
});})(seq__79123_79292,chunk__79124_79293,count__79125_79294,i__79126_79295,c__16345__auto___79299,healthcheck_uri_79297,resp_chan_79298,server_79296))
;
return ((function (seq__79123_79292,chunk__79124_79293,count__79125_79294,i__79126_79295,switch__16220__auto__,c__16345__auto___79299,healthcheck_uri_79297,resp_chan_79298,server_79296){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto____0 = (function (){
var statearr_79194 = [null,null,null,null,null,null,null,null];
(statearr_79194[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto__);

(statearr_79194[(1)] = (1));

return statearr_79194;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto____1 = (function (state_79187){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_79187);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e79195){var ex__16224__auto__ = e79195;
var statearr_79196_79304 = state_79187;
(statearr_79196_79304[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_79187[(4)]))){
var statearr_79197_79305 = state_79187;
(statearr_79197_79305[(1)] = cljs.core.first.call(null,(state_79187[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79306 = state_79187;
state_79187 = G__79306;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto__ = function(state_79187){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto____1.call(this,state_79187);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto__;
})()
;})(seq__79123_79292,chunk__79124_79293,count__79125_79294,i__79126_79295,switch__16220__auto__,c__16345__auto___79299,healthcheck_uri_79297,resp_chan_79298,server_79296))
})();
var state__16347__auto__ = (function (){var statearr_79198 = f__16346__auto__.call(null);
(statearr_79198[(6)] = c__16345__auto___79299);

return statearr_79198;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
});})(seq__79123_79292,chunk__79124_79293,count__79125_79294,i__79126_79295,c__16345__auto___79299,healthcheck_uri_79297,resp_chan_79298,server_79296))
);



var G__79307 = seq__79123_79292;
var G__79308 = chunk__79124_79293;
var G__79309 = count__79125_79294;
var G__79310 = (i__79126_79295 + (1));
seq__79123_79292 = G__79307;
chunk__79124_79293 = G__79308;
count__79125_79294 = G__79309;
i__79126_79295 = G__79310;
continue;
} else {
var temp__5753__auto___79311 = cljs.core.seq.call(null,seq__79123_79292);
if(temp__5753__auto___79311){
var seq__79123_79312__$1 = temp__5753__auto___79311;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__79123_79312__$1)){
var c__4638__auto___79313 = cljs.core.chunk_first.call(null,seq__79123_79312__$1);
var G__79314 = cljs.core.chunk_rest.call(null,seq__79123_79312__$1);
var G__79315 = c__4638__auto___79313;
var G__79316 = cljs.core.count.call(null,c__4638__auto___79313);
var G__79317 = (0);
seq__79123_79292 = G__79314;
chunk__79124_79293 = G__79315;
count__79125_79294 = G__79316;
i__79126_79295 = G__79317;
continue;
} else {
var server_79318 = cljs.core.first.call(null,seq__79123_79312__$1);
var healthcheck_uri_79319 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_79318),"/fdb/health"].join('');
var resp_chan_79320 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_79319,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__16345__auto___79321 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__79123_79292,chunk__79124_79293,count__79125_79294,i__79126_79295,c__16345__auto___79321,healthcheck_uri_79319,resp_chan_79320,server_79318,seq__79123_79312__$1,temp__5753__auto___79311){
return (function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = ((function (seq__79123_79292,chunk__79124_79293,count__79125_79294,i__79126_79295,c__16345__auto___79321,healthcheck_uri_79319,resp_chan_79320,server_79318,seq__79123_79312__$1,temp__5753__auto___79311){
return (function (state_79211){
var state_val_79212 = (state_79211[(1)]);
if((state_val_79212 === (1))){
var state_79211__$1 = state_79211;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_79211__$1,(2),resp_chan_79320);
} else {
if((state_val_79212 === (2))){
var inst_79200 = (state_79211[(7)]);
var inst_79200__$1 = (state_79211[(2)]);
var inst_79201 = fluree.db.util.core.exception_QMARK_.call(null,inst_79200__$1);
var state_79211__$1 = (function (){var statearr_79213 = state_79211;
(statearr_79213[(7)] = inst_79200__$1);

return statearr_79213;
})();
if(inst_79201){
var statearr_79214_79322 = state_79211__$1;
(statearr_79214_79322[(1)] = (3));

} else {
var statearr_79215_79323 = state_79211__$1;
(statearr_79215_79323[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79212 === (3))){
var inst_79200 = (state_79211[(7)]);
var inst_79203 = cljs.core.ex_message.call(null,inst_79200);
var inst_79204 = cljs.core.ex_data.call(null,inst_79200);
var inst_79205 = fluree.db.util.log.warn.call(null,"Server contact error: ",inst_79203,inst_79204);
var state_79211__$1 = state_79211;
var statearr_79216_79324 = state_79211__$1;
(statearr_79216_79324[(2)] = inst_79205);

(statearr_79216_79324[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79212 === (4))){
var inst_79207 = cljs.core.async.put_BANG_.call(null,promise_chan,server_79318);
var state_79211__$1 = state_79211;
var statearr_79217_79325 = state_79211__$1;
(statearr_79217_79325[(2)] = inst_79207);

(statearr_79217_79325[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79212 === (5))){
var inst_79209 = (state_79211[(2)]);
var state_79211__$1 = state_79211;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79211__$1,inst_79209);
} else {
return null;
}
}
}
}
}
});})(seq__79123_79292,chunk__79124_79293,count__79125_79294,i__79126_79295,c__16345__auto___79321,healthcheck_uri_79319,resp_chan_79320,server_79318,seq__79123_79312__$1,temp__5753__auto___79311))
;
return ((function (seq__79123_79292,chunk__79124_79293,count__79125_79294,i__79126_79295,switch__16220__auto__,c__16345__auto___79321,healthcheck_uri_79319,resp_chan_79320,server_79318,seq__79123_79312__$1,temp__5753__auto___79311){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto____0 = (function (){
var statearr_79218 = [null,null,null,null,null,null,null,null];
(statearr_79218[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto__);

(statearr_79218[(1)] = (1));

return statearr_79218;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto____1 = (function (state_79211){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_79211);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e79219){var ex__16224__auto__ = e79219;
var statearr_79220_79326 = state_79211;
(statearr_79220_79326[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_79211[(4)]))){
var statearr_79221_79327 = state_79211;
(statearr_79221_79327[(1)] = cljs.core.first.call(null,(state_79211[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79328 = state_79211;
state_79211 = G__79328;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto__ = function(state_79211){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto____1.call(this,state_79211);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto__;
})()
;})(seq__79123_79292,chunk__79124_79293,count__79125_79294,i__79126_79295,switch__16220__auto__,c__16345__auto___79321,healthcheck_uri_79319,resp_chan_79320,server_79318,seq__79123_79312__$1,temp__5753__auto___79311))
})();
var state__16347__auto__ = (function (){var statearr_79222 = f__16346__auto__.call(null);
(statearr_79222[(6)] = c__16345__auto___79321);

return statearr_79222;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
});})(seq__79123_79292,chunk__79124_79293,count__79125_79294,i__79126_79295,c__16345__auto___79321,healthcheck_uri_79319,resp_chan_79320,server_79318,seq__79123_79312__$1,temp__5753__auto___79311))
);



var G__79329 = cljs.core.next.call(null,seq__79123_79312__$1);
var G__79330 = null;
var G__79331 = (0);
var G__79332 = (0);
seq__79123_79292 = G__79329;
chunk__79124_79293 = G__79330;
count__79125_79294 = G__79331;
i__79126_79295 = G__79332;
continue;
}
} else {
}
}
break;
}

var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_79266){
var state_val_79267 = (state_79266[(1)]);
if((state_val_79267 === (7))){
var inst_79238 = (state_79266[(7)]);
var inst_79245 = cljs.core._EQ_.call(null,inst_79238,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_79266__$1 = state_79266;
if(inst_79245){
var statearr_79268_79333 = state_79266__$1;
(statearr_79268_79333[(1)] = (9));

} else {
var statearr_79269_79334 = state_79266__$1;
(statearr_79269_79334[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79267 === (1))){
var inst_79231 = (state_79266[(8)]);
var inst_79230 = (state_79266[(9)]);
var inst_79230__$1 = promise_chan;
var inst_79231__$1 = cljs.core.async.timeout.call(null,(60000));
var inst_79232 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79233 = [inst_79230__$1,inst_79231__$1];
var inst_79234 = (new cljs.core.PersistentVector(null,2,(5),inst_79232,inst_79233,null));
var state_79266__$1 = (function (){var statearr_79270 = state_79266;
(statearr_79270[(8)] = inst_79231__$1);

(statearr_79270[(9)] = inst_79230__$1);

return statearr_79270;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_79266__$1,(2),inst_79234);
} else {
if((state_val_79267 === (4))){
var inst_79238 = (state_79266[(7)]);
var inst_79231 = (state_79266[(8)]);
var inst_79242 = cljs.core._EQ_.call(null,inst_79238,inst_79231);
var state_79266__$1 = state_79266;
if(inst_79242){
var statearr_79271_79335 = state_79266__$1;
(statearr_79271_79335[(1)] = (6));

} else {
var statearr_79272_79336 = state_79266__$1;
(statearr_79272_79336[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79267 === (13))){
var state_79266__$1 = state_79266;
var statearr_79273_79337 = state_79266__$1;
(statearr_79273_79337[(2)] = null);

(statearr_79273_79337[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79267 === (6))){
var state_79266__$1 = state_79266;
var statearr_79274_79338 = state_79266__$1;
(statearr_79274_79338[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_79274_79338[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79267 === (3))){
var state_79266__$1 = state_79266;
var statearr_79275_79339 = state_79266__$1;
(statearr_79275_79339[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_79275_79339[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79267 === (12))){
var inst_79256 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"server","server",1499190120));
var inst_79257 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_79258 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_79259 = cljs.core.PersistentHashMap.fromArrays(inst_79257,inst_79258);
var inst_79260 = cljs.core.ex_info.call(null,"Unable to find healthy server before timeout.",inst_79259);
var inst_79261 = cljs.core.async.put_BANG_.call(null,promise_chan,inst_79260);
var state_79266__$1 = (function (){var statearr_79276 = state_79266;
(statearr_79276[(10)] = inst_79256);

return statearr_79276;
})();
var statearr_79277_79340 = state_79266__$1;
(statearr_79277_79340[(2)] = inst_79261);

(statearr_79277_79340[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79267 === (2))){
var inst_79238 = (state_79266[(7)]);
var inst_79230 = (state_79266[(9)]);
var inst_79236 = (state_79266[(2)]);
var inst_79237 = cljs.core.nth.call(null,inst_79236,(0),null);
var inst_79238__$1 = cljs.core.nth.call(null,inst_79236,(1),null);
var inst_79239 = cljs.core._EQ_.call(null,inst_79238__$1,inst_79230);
var state_79266__$1 = (function (){var statearr_79278 = state_79266;
(statearr_79278[(7)] = inst_79238__$1);

(statearr_79278[(11)] = inst_79237);

return statearr_79278;
})();
if(inst_79239){
var statearr_79279_79341 = state_79266__$1;
(statearr_79279_79341[(1)] = (3));

} else {
var statearr_79280_79342 = state_79266__$1;
(statearr_79280_79342[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79267 === (11))){
var inst_79249 = (state_79266[(2)]);
var state_79266__$1 = state_79266;
var statearr_79281_79343 = state_79266__$1;
(statearr_79281_79343[(2)] = inst_79249);

(statearr_79281_79343[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79267 === (9))){
var inst_79237 = (state_79266[(11)]);
var state_79266__$1 = state_79266;
var statearr_79282_79344 = state_79266__$1;
(statearr_79282_79344[(2)] = inst_79237);

(statearr_79282_79344[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79267 === (5))){
var inst_79253 = (state_79266[(2)]);
var inst_79254 = cljs.core._EQ_.call(null,new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_79253);
var state_79266__$1 = state_79266;
if(inst_79254){
var statearr_79283_79345 = state_79266__$1;
(statearr_79283_79345[(1)] = (12));

} else {
var statearr_79284_79346 = state_79266__$1;
(statearr_79284_79346[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79267 === (14))){
var inst_79264 = (state_79266[(2)]);
var state_79266__$1 = state_79266;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79266__$1,inst_79264);
} else {
if((state_val_79267 === (10))){
var state_79266__$1 = state_79266;
var statearr_79285_79347 = state_79266__$1;
(statearr_79285_79347[(2)] = null);

(statearr_79285_79347[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79267 === (8))){
var inst_79251 = (state_79266[(2)]);
var state_79266__$1 = state_79266;
var statearr_79286_79348 = state_79266__$1;
(statearr_79286_79348[(2)] = inst_79251);

(statearr_79286_79348[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto____0 = (function (){
var statearr_79287 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_79287[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto__);

(statearr_79287[(1)] = (1));

return statearr_79287;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto____1 = (function (state_79266){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_79266);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e79288){var ex__16224__auto__ = e79288;
var statearr_79289_79349 = state_79266;
(statearr_79289_79349[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_79266[(4)]))){
var statearr_79290_79350 = state_79266;
(statearr_79290_79350[(1)] = cljs.core.first.call(null,(state_79266[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79351 = state_79266;
state_79266 = G__79351;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto__ = function(state_79266){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto____1.call(this,state_79266);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_79291 = f__16346__auto__.call(null);
(statearr_79291[(6)] = c__16345__auto__);

return statearr_79291;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid.call(null);
var new_state = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.call(null)], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.call(null,lock_id,cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server.call(null,conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_79395){
var state_val_79396 = (state_79395[(1)]);
if((state_val_79396 === (7))){
var state_79395__$1 = state_79395;
var statearr_79397_79423 = state_79395__$1;
(statearr_79397_79423[(2)] = null);

(statearr_79397_79423[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79396 === (1))){
var state_79395__$1 = state_79395;
var statearr_79398_79424 = state_79395__$1;
(statearr_79398_79424[(2)] = null);

(statearr_79398_79424[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79396 === (4))){
var inst_79352 = (state_79395[(2)]);
var state_79395__$1 = state_79395;
var statearr_79399_79425 = state_79395__$1;
(statearr_79399_79425[(2)] = inst_79352);

(statearr_79399_79425[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79396 === (6))){
var inst_79374 = fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
var state_79395__$1 = state_79395;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_79395__$1,(9),inst_79374);
} else {
if((state_val_79396 === (3))){
var inst_79393 = (state_79395[(2)]);
var state_79395__$1 = state_79395;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79395__$1,inst_79393);
} else {
if((state_val_79396 === (12))){
var inst_79387 = (state_79395[(2)]);
var state_79395__$1 = state_79395;
var statearr_79400_79426 = state_79395__$1;
(statearr_79400_79426[(2)] = inst_79387);

(statearr_79400_79426[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79396 === (2))){
var inst_79363 = (state_79395[(7)]);
var inst_79368 = (state_79395[(8)]);
var inst_79358 = (state_79395[(9)]);
var _ = (function (){var statearr_79401 = state_79395;
(statearr_79401[(4)] = cljs.core.cons.call(null,(5),(state_79395[(4)])));

return statearr_79401;
})();
var inst_79358__$1 = fluree.db.util.core.random_uuid.call(null);
var inst_79359 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79360 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_79361 = (new cljs.core.PersistentVector(null,2,(5),inst_79359,inst_79360,null));
var inst_79362 = (function (){var lock_id = inst_79358__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.call(null)], null);
}
});
})();
var inst_79363__$1 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_79361,inst_79362);
var inst_79364 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79365 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_79366 = (new cljs.core.PersistentVector(null,3,(5),inst_79364,inst_79365,null));
var inst_79367 = cljs.core.get_in.call(null,inst_79363__$1,inst_79366);
var inst_79368__$1 = cljs.core._EQ_.call(null,inst_79358__$1,inst_79367);
var inst_79369 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79370 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_79371 = (new cljs.core.PersistentVector(null,3,(5),inst_79369,inst_79370,null));
var inst_79372 = cljs.core.get_in.call(null,inst_79363__$1,inst_79371);
var state_79395__$1 = (function (){var statearr_79402 = state_79395;
(statearr_79402[(7)] = inst_79363__$1);

(statearr_79402[(8)] = inst_79368__$1);

(statearr_79402[(10)] = inst_79372);

(statearr_79402[(9)] = inst_79358__$1);

return statearr_79402;
})();
if(inst_79368__$1){
var statearr_79403_79427 = state_79395__$1;
(statearr_79403_79427[(1)] = (6));

} else {
var statearr_79404_79428 = state_79395__$1;
(statearr_79404_79428[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79396 === (11))){
var inst_79379 = (state_79395[(11)]);
var inst_79372 = (state_79395[(10)]);
var inst_79378 = (state_79395[(12)]);
var inst_79385 = fluree.db.util.xhttp.try_socket.call(null,inst_79378,sub_chan,pub_chan,inst_79372,(60000),inst_79379);
var state_79395__$1 = state_79395;
var statearr_79406_79429 = state_79395__$1;
(statearr_79406_79429[(2)] = inst_79385);

(statearr_79406_79429[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79396 === (9))){
var inst_79363 = (state_79395[(7)]);
var inst_79368 = (state_79395[(8)]);
var inst_79376 = (state_79395[(13)]);
var inst_79372 = (state_79395[(10)]);
var inst_79378 = (state_79395[(12)]);
var inst_79358 = (state_79395[(9)]);
var inst_79376__$1 = (state_79395[(2)]);
var inst_79377 = clojure.string.replace.call(null,inst_79376__$1,"http","ws");
var inst_79378__$1 = [inst_79377,"/fdb/ws"].join('');
var inst_79379 = (function (){var lock_id = inst_79358;
var state = inst_79363;
var have_lock_QMARK_ = inst_79368;
var resp_chan = inst_79372;
var healthy_server = inst_79376__$1;
var ws_url = inst_79378__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.call(null,conn_id);
});
})();
var inst_79380 = fluree.db.util.core.exception_QMARK_.call(null,inst_79376__$1);
var state_79395__$1 = (function (){var statearr_79407 = state_79395;
(statearr_79407[(11)] = inst_79379);

(statearr_79407[(13)] = inst_79376__$1);

(statearr_79407[(12)] = inst_79378__$1);

return statearr_79407;
})();
if(inst_79380){
var statearr_79408_79430 = state_79395__$1;
(statearr_79408_79430[(1)] = (10));

} else {
var statearr_79409_79431 = state_79395__$1;
(statearr_79409_79431[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79396 === (5))){
var _ = (function (){var statearr_79410 = state_79395;
(statearr_79410[(4)] = cljs.core.rest.call(null,(state_79395[(4)])));

return statearr_79410;
})();
var state_79395__$1 = state_79395;
var ex79405 = (state_79395__$1[(2)]);
var statearr_79411_79432 = state_79395__$1;
(statearr_79411_79432[(5)] = ex79405);


if((ex79405 instanceof Error)){
var statearr_79412_79433 = state_79395__$1;
(statearr_79412_79433[(1)] = (4));

(statearr_79412_79433[(5)] = null);

} else {
throw ex79405;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79396 === (10))){
var inst_79376 = (state_79395[(13)]);
var inst_79372 = (state_79395[(10)]);
var inst_79382 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"ws","ws",86841443));
var inst_79383 = cljs.core.async.put_BANG_.call(null,inst_79372,inst_79376);
var state_79395__$1 = (function (){var statearr_79413 = state_79395;
(statearr_79413[(14)] = inst_79382);

return statearr_79413;
})();
var statearr_79414_79434 = state_79395__$1;
(statearr_79414_79434[(2)] = inst_79383);

(statearr_79414_79434[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79396 === (8))){
var inst_79372 = (state_79395[(10)]);
var inst_79390 = (state_79395[(2)]);
var _ = (function (){var statearr_79415 = state_79395;
(statearr_79415[(4)] = cljs.core.rest.call(null,(state_79395[(4)])));

return statearr_79415;
})();
var state_79395__$1 = (function (){var statearr_79416 = state_79395;
(statearr_79416[(15)] = inst_79390);

return statearr_79416;
})();
var statearr_79417_79435 = state_79395__$1;
(statearr_79417_79435[(2)] = inst_79372);

(statearr_79417_79435[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__16221__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__16221__auto____0 = (function (){
var statearr_79418 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_79418[(0)] = fluree$db$connection$establish_socket_$_state_machine__16221__auto__);

(statearr_79418[(1)] = (1));

return statearr_79418;
});
var fluree$db$connection$establish_socket_$_state_machine__16221__auto____1 = (function (state_79395){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_79395);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e79419){var ex__16224__auto__ = e79419;
var statearr_79420_79436 = state_79395;
(statearr_79420_79436[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_79395[(4)]))){
var statearr_79421_79437 = state_79395;
(statearr_79421_79437[(1)] = cljs.core.first.call(null,(state_79395[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79438 = state_79395;
state_79395 = G__79438;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__16221__auto__ = function(state_79395){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__16221__auto____1.call(this,state_79395);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__16221__auto____0;
fluree$db$connection$establish_socket_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__16221__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_79422 = f__16346__auto__.call(null);
(statearr_79422[(6)] = c__16345__auto__);

return statearr_79422;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.group = group;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k79440,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__79444 = k79440;
var G__79444__$1 = (((G__79444 instanceof cljs.core.Keyword))?G__79444.fqn:null);
switch (G__79444__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "group":
return self__.group;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k79440,else__4464__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4484__auto__,p__79445){
var vec__79446 = p__79445;
var k__4485__auto__ = cljs.core.nth.call(null,vec__79446,(0),null);
var v__4486__auto__ = cljs.core.nth.call(null,vec__79446,(1),null);
return f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__);
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.connection.Connection{",", ","}",opts__4478__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"group","group",582596132),self__.group],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__79439){
var self__ = this;
var G__79439__$1 = this;
return (new cljs.core.RecordIter((0),G__79439__$1,22,new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (22 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (coll__4458__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll.call(null,coll__4458__auto__));
}).call(null,this__4457__auto____$1);
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this79441,other79442){
var self__ = this;
var this79441__$1 = this;
return (((!((other79442 == null)))) && ((((this79441__$1.constructor === other79442.constructor)) && (((cljs.core._EQ_.call(null,this79441__$1.id,other79442.id)) && (((cljs.core._EQ_.call(null,this79441__$1.servers,other79442.servers)) && (((cljs.core._EQ_.call(null,this79441__$1.state,other79442.state)) && (((cljs.core._EQ_.call(null,this79441__$1.req_chan,other79442.req_chan)) && (((cljs.core._EQ_.call(null,this79441__$1.sub_chan,other79442.sub_chan)) && (((cljs.core._EQ_.call(null,this79441__$1.pub_chan,other79442.pub_chan)) && (((cljs.core._EQ_.call(null,this79441__$1.group,other79442.group)) && (((cljs.core._EQ_.call(null,this79441__$1.storage_read,other79442.storage_read)) && (((cljs.core._EQ_.call(null,this79441__$1.storage_write,other79442.storage_write)) && (((cljs.core._EQ_.call(null,this79441__$1.object_cache,other79442.object_cache)) && (((cljs.core._EQ_.call(null,this79441__$1.parallelism,other79442.parallelism)) && (((cljs.core._EQ_.call(null,this79441__$1.serializer,other79442.serializer)) && (((cljs.core._EQ_.call(null,this79441__$1.default_network,other79442.default_network)) && (((cljs.core._EQ_.call(null,this79441__$1.transactor_QMARK_,other79442.transactor_QMARK_)) && (((cljs.core._EQ_.call(null,this79441__$1.publish,other79442.publish)) && (((cljs.core._EQ_.call(null,this79441__$1.transact_handler,other79442.transact_handler)) && (((cljs.core._EQ_.call(null,this79441__$1.tx_private_key,other79442.tx_private_key)) && (((cljs.core._EQ_.call(null,this79441__$1.tx_key_id,other79442.tx_key_id)) && (((cljs.core._EQ_.call(null,this79441__$1.meta,other79442.meta)) && (((cljs.core._EQ_.call(null,this79441__$1.add_listener,other79442.add_listener)) && (((cljs.core._EQ_.call(null,this79441__$1.remove_listener,other79442.remove_listener)) && (((cljs.core._EQ_.call(null,this79441__$1.close,other79442.close)) && (cljs.core._EQ_.call(null,this79441__$1.__extmap,other79442.__extmap)))))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 22, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"group","group",582596132),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__4472__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k79440){
var self__ = this;
var this__4468__auto____$1 = this;
var G__79449 = k79440;
var G__79449__$1 = (((G__79449 instanceof cljs.core.Keyword))?G__79449.fqn:null);
switch (G__79449__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "group":
case "storage-read":
case "storage-write":
case "object-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k79440);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__79439){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__79450 = cljs.core.keyword_identical_QMARK_;
var expr__79451 = k__4470__auto__;
if(cljs.core.truth_(pred__79450.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__79451))){
return (new fluree.db.connection.Connection(G__79439,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__79450.call(null,new cljs.core.Keyword(null,"servers","servers",1881102005),expr__79451))){
return (new fluree.db.connection.Connection(self__.id,G__79439,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__79450.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__79451))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__79439,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__79450.call(null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),expr__79451))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__79439,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__79450.call(null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),expr__79451))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__79439,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__79450.call(null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),expr__79451))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__79439,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__79450.call(null,new cljs.core.Keyword(null,"group","group",582596132),expr__79451))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__79439,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__79450.call(null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),expr__79451))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,G__79439,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__79450.call(null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),expr__79451))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,G__79439,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__79450.call(null,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),expr__79451))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,G__79439,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__79450.call(null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),expr__79451))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,G__79439,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__79450.call(null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),expr__79451))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__79439,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__79450.call(null,new cljs.core.Keyword(null,"default-network","default-network",586420705),expr__79451))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__79439,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__79450.call(null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),expr__79451))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__79439,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__79450.call(null,new cljs.core.Keyword(null,"publish","publish",-1178026850),expr__79451))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__79439,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__79450.call(null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),expr__79451))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__79439,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__79450.call(null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),expr__79451))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__79439,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__79450.call(null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),expr__79451))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__79439,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__79450.call(null,new cljs.core.Keyword(null,"meta","meta",1499536964),expr__79451))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__79439,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__79450.call(null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),expr__79451))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__79439,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__79450.call(null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),expr__79451))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__79439,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__79450.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__79451))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__79439,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4470__auto__,G__79439),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"group","group",582596132),self__.group,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__79439){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__79439,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4467__auto__,(0)),cljs.core._nth.call(null,entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"group","group",-2071839637,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write.call(null,writer__4506__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__79443){
var extmap__4501__auto__ = (function (){var G__79453 = cljs.core.dissoc.call(null,G__79443,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582));
if(cljs.core.record_QMARK_.call(null,G__79443)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__79453);
} else {
return G__79453;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__79443),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__79443),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__79443),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__79443),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__79443),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__79443),new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(G__79443),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__79443),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__79443),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__79443),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__79443),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__79443),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__79443),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__79443),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__79443),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__79443),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__79443),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__79443),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__79443),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__79443),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__79443),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__79443),null,cljs.core.not_empty.call(null,extmap__4501__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.call(null,servers,/,/):servers);
if(((cljs.core.empty_QMARK_.call(null,servers)) && (cljs.core.not.call(null,transactor_QMARK_)))){
throw cljs.core.ex_info.call(null,"At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty.call(null,servers_STAR_))){
var G__79459 = servers_STAR_;
var vec__79460 = G__79459;
var seq__79461 = cljs.core.seq.call(null,vec__79460);
var first__79462 = cljs.core.first.call(null,seq__79461);
var seq__79461__$1 = cljs.core.next.call(null,seq__79461);
var server = first__79462;
var r = seq__79461__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__79459__$1 = G__79459;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__79466 = G__79459__$1;
var seq__79467 = cljs.core.seq.call(null,vec__79466);
var first__79468 = cljs.core.first.call(null,seq__79467);
var seq__79467__$1 = cljs.core.next.call(null,seq__79467);
var server__$1 = first__79468;
var r__$1 = seq__79467__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.call(null,["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.call(null,server__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace.call(null,server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches.call(null,/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_.call(null,server__$2,"//"))?(function(){throw cljs.core.ex_info.call(null,["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches.call(null,/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_.call(null,server__$2,"https://");
var result_STAR_ = cljs.core.conj.call(null,result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches.call(null,fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.call(null,["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__4210__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.not_EQ_.call(null,is_https_QMARK_,https_QMARK___$2);
} else {
return and__4210__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_.call(null,r__$1)){
return cljs.core.shuffle.call(null,result_STAR_);
} else {
var G__79469 = r__$1;
var G__79470 = is_https_QMARK_;
var G__79471 = result_STAR_;
G__79459__$1 = G__79469;
https_QMARK___$1 = G__79470;
result__$1 = G__79471;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__79472 = cljs.core.get_in.call(null,fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__79472 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_.call(null,G__79472);
}
})();
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket.call(null,existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_79501){
var state_val_79502 = (state_79501[(1)]);
if((state_val_79502 === (7))){
var inst_79487 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_79488 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_79489 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_79490 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_79491 = fluree.db.connection.establish_socket.call(null,inst_79487,inst_79488,inst_79489,inst_79490);
var state_79501__$1 = state_79501;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_79501__$1,(9),inst_79491);
} else {
if((state_val_79502 === (1))){
var state_79501__$1 = state_79501;
var statearr_79503_79522 = state_79501__$1;
(statearr_79503_79522[(2)] = null);

(statearr_79503_79522[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79502 === (4))){
var inst_79473 = (state_79501[(2)]);
var state_79501__$1 = state_79501;
var statearr_79504_79523 = state_79501__$1;
(statearr_79504_79523[(2)] = inst_79473);

(statearr_79504_79523[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79502 === (6))){
var inst_79484 = (state_79501[(7)]);
var state_79501__$1 = state_79501;
var statearr_79505_79524 = state_79501__$1;
(statearr_79505_79524[(2)] = inst_79484);

(statearr_79505_79524[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79502 === (3))){
var inst_79499 = (state_79501[(2)]);
var state_79501__$1 = state_79501;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79501__$1,inst_79499);
} else {
if((state_val_79502 === (2))){
var inst_79484 = (state_79501[(7)]);
var _ = (function (){var statearr_79507 = state_79501;
(statearr_79507[(4)] = cljs.core.cons.call(null,(5),(state_79501[(4)])));

return statearr_79507;
})();
var inst_79479 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_79480 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79481 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_79482 = [inst_79481,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_79483 = (new cljs.core.PersistentVector(null,3,(5),inst_79480,inst_79482,null));
var inst_79484__$1 = cljs.core.get_in.call(null,inst_79479,inst_79483);
var state_79501__$1 = (function (){var statearr_79508 = state_79501;
(statearr_79508[(7)] = inst_79484__$1);

return statearr_79508;
})();
if(cljs.core.truth_(inst_79484__$1)){
var statearr_79509_79525 = state_79501__$1;
(statearr_79509_79525[(1)] = (6));

} else {
var statearr_79510_79526 = state_79501__$1;
(statearr_79510_79526[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79502 === (9))){
var inst_79493 = (state_79501[(2)]);
var inst_79494 = fluree.db.util.async.throw_err.call(null,inst_79493);
var state_79501__$1 = state_79501;
var statearr_79511_79527 = state_79501__$1;
(statearr_79511_79527[(2)] = inst_79494);

(statearr_79511_79527[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79502 === (5))){
var _ = (function (){var statearr_79512 = state_79501;
(statearr_79512[(4)] = cljs.core.rest.call(null,(state_79501[(4)])));

return statearr_79512;
})();
var state_79501__$1 = state_79501;
var ex79506 = (state_79501__$1[(2)]);
var statearr_79513_79528 = state_79501__$1;
(statearr_79513_79528[(5)] = ex79506);


if((ex79506 instanceof Error)){
var statearr_79514_79529 = state_79501__$1;
(statearr_79514_79529[(1)] = (4));

(statearr_79514_79529[(5)] = null);

} else {
throw ex79506;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79502 === (8))){
var inst_79496 = (state_79501[(2)]);
var _ = (function (){var statearr_79515 = state_79501;
(statearr_79515[(4)] = cljs.core.rest.call(null,(state_79501[(4)])));

return statearr_79515;
})();
var state_79501__$1 = state_79501;
var statearr_79516_79530 = state_79501__$1;
(statearr_79516_79530[(2)] = inst_79496);

(statearr_79516_79530[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__16221__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__16221__auto____0 = (function (){
var statearr_79517 = [null,null,null,null,null,null,null,null];
(statearr_79517[(0)] = fluree$db$connection$get_socket_$_state_machine__16221__auto__);

(statearr_79517[(1)] = (1));

return statearr_79517;
});
var fluree$db$connection$get_socket_$_state_machine__16221__auto____1 = (function (state_79501){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_79501);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e79518){var ex__16224__auto__ = e79518;
var statearr_79519_79531 = state_79501;
(statearr_79519_79531[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_79501[(4)]))){
var statearr_79520_79532 = state_79501;
(statearr_79520_79532[(1)] = cljs.core.first.call(null,(state_79501[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79533 = state_79501;
state_79501 = G__79533;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__16221__auto__ = function(state_79501){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__16221__auto____1.call(this,state_79501);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__16221__auto____0;
fluree$db$connection$get_socket_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__16221__auto____1;
return fluree$db$connection$get_socket_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_79521 = f__16346__auto__.call(null);
(statearr_79521[(6)] = c__16345__auto__);

return statearr_79521;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__4212__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.call(null);
var msg = (function (){try{return fluree.db.util.json.stringify.call(null,message);
}catch (e79534){var e = e79534;
fluree.db.util.log.error.call(null,"Unable to publish message on websocket. Error encoding JSON message: ",message);

cljs.core.async.put_BANG_.call(null,resp_chan,cljs.core.ex_info.call(null,["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.call(null,pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__4212__auto__ = new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_79661){
var state_val_79662 = (state_79661[(1)]);
if((state_val_79662 === (7))){
var inst_79657 = (state_79661[(2)]);
var state_79661__$1 = state_79661;
var statearr_79664_79734 = state_79661__$1;
(statearr_79664_79734[(2)] = inst_79657);

(statearr_79664_79734[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79662 === (20))){
var _ = (function (){var statearr_79665 = state_79661;
(statearr_79665[(4)] = cljs.core.rest.call(null,(state_79661[(4)])));

return statearr_79665;
})();
var state_79661__$1 = state_79661;
var ex79663 = (state_79661__$1[(2)]);
var statearr_79666_79735 = state_79661__$1;
(statearr_79666_79735[(5)] = ex79663);


var statearr_79667_79736 = state_79661__$1;
(statearr_79667_79736[(1)] = (10));

(statearr_79667_79736[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79662 === (27))){
var inst_79649 = (state_79661[(2)]);
var _ = (function (){var statearr_79668 = state_79661;
(statearr_79668[(4)] = cljs.core.rest.call(null,(state_79661[(4)])));

return statearr_79668;
})();
var state_79661__$1 = state_79661;
var statearr_79669_79737 = state_79661__$1;
(statearr_79669_79737[(2)] = inst_79649);

(statearr_79669_79737[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79662 === (1))){
var inst_79536 = (0);
var state_79661__$1 = (function (){var statearr_79670 = state_79661;
(statearr_79670[(7)] = inst_79536);

return statearr_79670;
})();
var statearr_79671_79738 = state_79661__$1;
(statearr_79671_79738[(2)] = null);

(statearr_79671_79738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79662 === (24))){
var inst_79627 = (state_79661[(8)]);
var inst_79627__$1 = (state_79661[(2)]);
var inst_79628 = inst_79627__$1 === true;
var state_79661__$1 = (function (){var statearr_79672 = state_79661;
(statearr_79672[(8)] = inst_79627__$1);

return statearr_79672;
})();
if(cljs.core.truth_(inst_79628)){
var statearr_79673_79739 = state_79661__$1;
(statearr_79673_79739[(1)] = (25));

} else {
var statearr_79674_79740 = state_79661__$1;
(statearr_79674_79740[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79662 === (4))){
var inst_79539 = (state_79661[(9)]);
var inst_79539__$1 = (state_79661[(2)]);
var state_79661__$1 = (function (){var statearr_79675 = state_79661;
(statearr_79675[(9)] = inst_79539__$1);

return statearr_79675;
})();
if(cljs.core.truth_(inst_79539__$1)){
var statearr_79676_79741 = state_79661__$1;
(statearr_79676_79741[(1)] = (5));

} else {
var statearr_79677_79742 = state_79661__$1;
(statearr_79677_79742[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79662 === (15))){
var inst_79552 = (state_79661[(10)]);
var state_79661__$1 = state_79661;
var statearr_79678_79743 = state_79661__$1;
(statearr_79678_79743[(2)] = inst_79552);

(statearr_79678_79743[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79662 === (21))){
var inst_79578 = (state_79661[(11)]);
var inst_79576 = (state_79661[(12)]);
var inst_79577 = (state_79661[(13)]);
var inst_79579 = (state_79661[(14)]);
var inst_79584 = (state_79661[(15)]);
var inst_79583 = (state_79661[(16)]);
var inst_79575 = (state_79661[(17)]);
var inst_79539 = (state_79661[(9)]);
var inst_79536 = (state_79661[(7)]);
var inst_79580 = (state_79661[(18)]);
var inst_79586 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79587 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_79583];
var inst_79588 = (new cljs.core.PersistentVector(null,2,(5),inst_79586,inst_79587,null));
var inst_79589 = cljs.core.swap_BANG_.call(null,state,cljs.core.assoc_in,inst_79588,inst_79578);
var inst_79616 = cljs.core.async.chan.call(null,(1));
var inst_79617 = (function (){var resp_chan = inst_79578;
var timeout = inst_79584;
var map__79574 = inst_79580;
var i = inst_79536;
var data = inst_79577;
var vec__79571 = inst_79539;
var _ = inst_79575;
var req_id = inst_79583;
var operation = inst_79576;
var msg = inst_79539;
var opts = inst_79579;
var c__16345__auto____$1 = inst_79616;
return (function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_79614){
var state_val_79615 = (state_79614[(1)]);
if((state_val_79615 === (1))){
var inst_79593 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79594 = cljs.core.async.timeout.call(null,timeout);
var inst_79595 = [resp_chan,inst_79594];
var inst_79596 = (new cljs.core.PersistentVector(null,2,(5),inst_79593,inst_79595,null));
var state_79614__$1 = state_79614;
return cljs.core.async.ioc_alts_BANG_.call(null,state_79614__$1,(2),inst_79596);
} else {
if((state_val_79615 === (2))){
var inst_79599 = (state_79614[(7)]);
var inst_79598 = (state_79614[(2)]);
var inst_79599__$1 = cljs.core.nth.call(null,inst_79598,(0),null);
var inst_79600 = cljs.core.nth.call(null,inst_79598,(1),null);
var inst_79601 = (function (){var vec__79590 = inst_79598;
var resp = inst_79599__$1;
var c = inst_79600;
return (function (p1__79535_SHARP_){
return cljs.core.dissoc.call(null,p1__79535_SHARP_,req_id);
});
})();
var inst_79602 = cljs.core.swap_BANG_.call(null,state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_79601);
var inst_79603 = cljs.core._EQ_.call(null,inst_79600,resp_chan);
var state_79614__$1 = (function (){var statearr_79679 = state_79614;
(statearr_79679[(7)] = inst_79599__$1);

(statearr_79679[(8)] = inst_79602);

return statearr_79679;
})();
if(inst_79603){
var statearr_79680_79744 = state_79614__$1;
(statearr_79680_79744[(1)] = (3));

} else {
var statearr_79681_79745 = state_79614__$1;
(statearr_79681_79745[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79615 === (3))){
var inst_79599 = (state_79614[(7)]);
var state_79614__$1 = state_79614;
var statearr_79682_79746 = state_79614__$1;
(statearr_79682_79746[(2)] = inst_79599);

(statearr_79682_79746[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79615 === (4))){
var inst_79606 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_79607 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_79608 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_79609 = cljs.core.PersistentHashMap.fromArrays(inst_79607,inst_79608);
var inst_79610 = cljs.core.ex_info.call(null,inst_79606,inst_79609);
var state_79614__$1 = state_79614;
var statearr_79683_79747 = state_79614__$1;
(statearr_79683_79747[(2)] = inst_79610);

(statearr_79683_79747[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79615 === (5))){
var inst_79612 = (state_79614[(2)]);
var state_79614__$1 = state_79614;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79614__$1,inst_79612);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__16221__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__16221__auto____0 = (function (){
var statearr_79684 = [null,null,null,null,null,null,null,null,null];
(statearr_79684[(0)] = fluree$db$connection$msg_producer_$_state_machine__16221__auto__);

(statearr_79684[(1)] = (1));

return statearr_79684;
});
var fluree$db$connection$msg_producer_$_state_machine__16221__auto____1 = (function (state_79614){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_79614);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e79685){var ex__16224__auto__ = e79685;
var statearr_79686_79748 = state_79614;
(statearr_79686_79748[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_79614[(4)]))){
var statearr_79687_79749 = state_79614;
(statearr_79687_79749[(1)] = cljs.core.first.call(null,(state_79614[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79750 = state_79614;
state_79614 = G__79750;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__16221__auto__ = function(state_79614){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__16221__auto____1.call(this,state_79614);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__16221__auto____0;
fluree$db$connection$msg_producer_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__16221__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_79688 = f__16346__auto__.call(null);
(statearr_79688[(6)] = c__16345__auto____$1);

return statearr_79688;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
});
})();
var inst_79618 = cljs.core.async.impl.dispatch.run.call(null,inst_79617);
var state_79661__$1 = (function (){var statearr_79689 = state_79661;
(statearr_79689[(19)] = inst_79618);

(statearr_79689[(20)] = inst_79589);

return statearr_79689;
})();
var statearr_79690_79751 = state_79661__$1;
(statearr_79690_79751[(2)] = inst_79616);

(statearr_79690_79751[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79662 === (31))){
var inst_79637 = fluree.db.util.log.error.call(null,"Error processing message in producer. Socket closed.");
var state_79661__$1 = state_79661;
var statearr_79691_79752 = state_79661__$1;
(statearr_79691_79752[(2)] = inst_79637);

(statearr_79691_79752[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79662 === (32))){
var state_79661__$1 = state_79661;
var statearr_79692_79753 = state_79661__$1;
(statearr_79692_79753[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79662 === (33))){
var inst_79645 = (state_79661[(2)]);
var state_79661__$1 = state_79661;
var statearr_79694_79754 = state_79661__$1;
(statearr_79694_79754[(2)] = inst_79645);

(statearr_79694_79754[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79662 === (13))){
var inst_79552 = (state_79661[(10)]);
var inst_79549 = (state_79661[(2)]);
var inst_79550 = cljs.core.nth.call(null,inst_79549,(0),null);
var inst_79551 = cljs.core.nth.call(null,inst_79549,(1),null);
var inst_79552__$1 = cljs.core.nth.call(null,inst_79549,(2),null);
var state_79661__$1 = (function (){var statearr_79695 = state_79661;
(statearr_79695[(21)] = inst_79550);

(statearr_79695[(10)] = inst_79552__$1);

(statearr_79695[(22)] = inst_79551);

return statearr_79695;
})();
if(cljs.core.truth_(inst_79552__$1)){
var statearr_79696_79755 = state_79661__$1;
(statearr_79696_79755[(1)] = (14));

} else {
var statearr_79697_79756 = state_79661__$1;
(statearr_79697_79756[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79662 === (22))){
var state_79661__$1 = state_79661;
var statearr_79698_79757 = state_79661__$1;
(statearr_79698_79757[(2)] = null);

(statearr_79698_79757[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79662 === (36))){
var inst_79643 = (state_79661[(2)]);
var state_79661__$1 = state_79661;
var statearr_79699_79758 = state_79661__$1;
(statearr_79699_79758[(2)] = inst_79643);

(statearr_79699_79758[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79662 === (29))){
var inst_79627 = (state_79661[(8)]);
var inst_79635 = (inst_79627 == null);
var state_79661__$1 = state_79661;
if(cljs.core.truth_(inst_79635)){
var statearr_79700_79759 = state_79661__$1;
(statearr_79700_79759[(1)] = (31));

} else {
var statearr_79701_79760 = state_79661__$1;
(statearr_79701_79760[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79662 === (6))){
var state_79661__$1 = state_79661;
var statearr_79702_79761 = state_79661__$1;
(statearr_79702_79761[(2)] = null);

(statearr_79702_79761[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79662 === (28))){
var inst_79627 = (state_79661[(8)]);
var inst_79633 = fluree.db.util.log.error.call(null,inst_79627,"Error processing message in producer.");
var state_79661__$1 = state_79661;
var statearr_79703_79762 = state_79661__$1;
(statearr_79703_79762[(2)] = inst_79633);

(statearr_79703_79762[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79662 === (25))){
var state_79661__$1 = state_79661;
var statearr_79704_79763 = state_79661__$1;
(statearr_79704_79763[(2)] = null);

(statearr_79704_79763[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79662 === (34))){
var inst_79627 = (state_79661[(8)]);
var inst_79640 = fluree.db.util.log.error.call(null,"Error processing message in producer. Socket closed. Published result",inst_79627);
var state_79661__$1 = state_79661;
var statearr_79705_79764 = state_79661__$1;
(statearr_79705_79764[(2)] = inst_79640);

(statearr_79705_79764[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79662 === (17))){
var inst_79552 = (state_79661[(10)]);
var inst_79541 = (state_79661[(23)]);
var inst_79559 = cljs.core.async.put_BANG_.call(null,inst_79552,inst_79541);
var state_79661__$1 = state_79661;
var statearr_79706_79765 = state_79661__$1;
(statearr_79706_79765[(2)] = inst_79559);

(statearr_79706_79765[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79662 === (3))){
var inst_79659 = (state_79661[(2)]);
var state_79661__$1 = state_79661;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79661__$1,inst_79659);
} else {
if((state_val_79662 === (12))){
var state_79661__$1 = state_79661;
var statearr_79707_79766 = state_79661__$1;
(statearr_79707_79766[(2)] = null);

(statearr_79707_79766[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79662 === (2))){
var state_79661__$1 = state_79661;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_79661__$1,(4),req_chan);
} else {
if((state_val_79662 === (23))){
var inst_79576 = (state_79661[(12)]);
var inst_79577 = (state_79661[(13)]);
var inst_79583 = (state_79661[(16)]);
var inst_79621 = (state_79661[(2)]);
var inst_79622 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79623 = [inst_79576,inst_79583,inst_79577];
var inst_79624 = (new cljs.core.PersistentVector(null,3,(5),inst_79622,inst_79623,null));
var inst_79625 = publish_fn.call(null,conn,inst_79624);
var state_79661__$1 = (function (){var statearr_79708 = state_79661;
(statearr_79708[(24)] = inst_79621);

return statearr_79708;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_79661__$1,(24),inst_79625);
} else {
if((state_val_79662 === (35))){
var state_79661__$1 = state_79661;
var statearr_79709_79767 = state_79661__$1;
(statearr_79709_79767[(2)] = null);

(statearr_79709_79767[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79662 === (19))){
var inst_79565 = (state_79661[(2)]);
var state_79661__$1 = state_79661;
var statearr_79710_79768 = state_79661__$1;
(statearr_79710_79768[(2)] = inst_79565);

(statearr_79710_79768[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79662 === (11))){
var inst_79539 = (state_79661[(9)]);
var state_79661__$1 = state_79661;
var statearr_79711_79769 = state_79661__$1;
(statearr_79711_79769[(2)] = inst_79539);

(statearr_79711_79769[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79662 === (9))){
var inst_79536 = (state_79661[(7)]);
var inst_79652 = (state_79661[(2)]);
var inst_79653 = (inst_79536 + (1));
var inst_79536__$1 = inst_79653;
var state_79661__$1 = (function (){var statearr_79712 = state_79661;
(statearr_79712[(7)] = inst_79536__$1);

(statearr_79712[(25)] = inst_79652);

return statearr_79712;
})();
var statearr_79713_79770 = state_79661__$1;
(statearr_79713_79770[(2)] = null);

(statearr_79713_79770[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79662 === (5))){
var state_79661__$1 = state_79661;
var statearr_79714_79771 = state_79661__$1;
(statearr_79714_79771[(2)] = null);

(statearr_79714_79771[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79662 === (14))){
var inst_79552 = (state_79661[(10)]);
var inst_79554 = fluree.db.util.async.channel_QMARK_.call(null,inst_79552);
var state_79661__$1 = state_79661;
var statearr_79715_79772 = state_79661__$1;
(statearr_79715_79772[(2)] = inst_79554);

(statearr_79715_79772[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79662 === (26))){
var inst_79627 = (state_79661[(8)]);
var inst_79631 = fluree.db.util.core.exception_QMARK_.call(null,inst_79627);
var state_79661__$1 = state_79661;
if(inst_79631){
var statearr_79716_79773 = state_79661__$1;
(statearr_79716_79773[(1)] = (28));

} else {
var statearr_79717_79774 = state_79661__$1;
(statearr_79717_79774[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79662 === (16))){
var inst_79557 = (state_79661[(2)]);
var state_79661__$1 = state_79661;
if(cljs.core.truth_(inst_79557)){
var statearr_79718_79775 = state_79661__$1;
(statearr_79718_79775[(1)] = (17));

} else {
var statearr_79719_79776 = state_79661__$1;
(statearr_79719_79776[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79662 === (30))){
var inst_79647 = (state_79661[(2)]);
var state_79661__$1 = state_79661;
var statearr_79720_79777 = state_79661__$1;
(statearr_79720_79777[(2)] = inst_79647);

(statearr_79720_79777[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79662 === (10))){
var inst_79539 = (state_79661[(9)]);
var inst_79541 = (state_79661[(2)]);
var inst_79545 = cljs.core.sequential_QMARK_.call(null,inst_79539);
var state_79661__$1 = (function (){var statearr_79721 = state_79661;
(statearr_79721[(23)] = inst_79541);

return statearr_79721;
})();
if(inst_79545){
var statearr_79722_79778 = state_79661__$1;
(statearr_79722_79778[(1)] = (11));

} else {
var statearr_79723_79779 = state_79661__$1;
(statearr_79723_79779[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79662 === (18))){
var inst_79539 = (state_79661[(9)]);
var inst_79541 = (state_79661[(23)]);
var inst_79561 = cljs.core.pr_str.call(null,inst_79539);
var inst_79562 = ["Error processing ledger request, no valid return channel: ",inst_79561].join('');
var inst_79563 = fluree.db.util.log.error.call(null,inst_79541,inst_79562);
var state_79661__$1 = state_79661;
var statearr_79724_79780 = state_79661__$1;
(statearr_79724_79780[(2)] = inst_79563);

(statearr_79724_79780[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79662 === (8))){
var inst_79578 = (state_79661[(11)]);
var inst_79579 = (state_79661[(14)]);
var inst_79539 = (state_79661[(9)]);
var inst_79580 = (state_79661[(18)]);
var _ = (function (){var statearr_79725 = state_79661;
(statearr_79725[(4)] = cljs.core.cons.call(null,(20),(state_79661[(4)])));

return statearr_79725;
})();
var inst_79575 = fluree.db.util.log.trace.call(null,"Outgoing message to websocket: ",inst_79539);
var inst_79576 = cljs.core.nth.call(null,inst_79539,(0),null);
var inst_79577 = cljs.core.nth.call(null,inst_79539,(1),null);
var inst_79578__$1 = cljs.core.nth.call(null,inst_79539,(2),null);
var inst_79579__$1 = cljs.core.nth.call(null,inst_79539,(3),null);
var inst_79580__$1 = cljs.core.__destructure_map.call(null,inst_79579__$1);
var inst_79581 = fluree.db.util.core.random_uuid.call(null);
var inst_79582 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_79581);
var inst_79583 = cljs.core.get.call(null,inst_79580__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_79582);
var inst_79584 = cljs.core.get.call(null,inst_79580__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_79661__$1 = (function (){var statearr_79726 = state_79661;
(statearr_79726[(11)] = inst_79578__$1);

(statearr_79726[(12)] = inst_79576);

(statearr_79726[(13)] = inst_79577);

(statearr_79726[(14)] = inst_79579__$1);

(statearr_79726[(15)] = inst_79584);

(statearr_79726[(16)] = inst_79583);

(statearr_79726[(17)] = inst_79575);

(statearr_79726[(18)] = inst_79580__$1);

return statearr_79726;
})();
if(cljs.core.truth_(inst_79578__$1)){
var statearr_79727_79781 = state_79661__$1;
(statearr_79727_79781[(1)] = (21));

} else {
var statearr_79728_79782 = state_79661__$1;
(statearr_79728_79782[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__16221__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__16221__auto____0 = (function (){
var statearr_79729 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_79729[(0)] = fluree$db$connection$msg_producer_$_state_machine__16221__auto__);

(statearr_79729[(1)] = (1));

return statearr_79729;
});
var fluree$db$connection$msg_producer_$_state_machine__16221__auto____1 = (function (state_79661){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_79661);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e79730){var ex__16224__auto__ = e79730;
var statearr_79731_79783 = state_79661;
(statearr_79731_79783[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_79661[(4)]))){
var statearr_79732_79784 = state_79661;
(statearr_79732_79784[(1)] = cljs.core.first.call(null,(state_79661[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79785 = state_79661;
state_79661 = G__79785;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__16221__auto__ = function(state_79661){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__16221__auto____1.call(this,state_79661);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__16221__auto____0;
fluree$db$connection$msg_producer_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__16221__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_79733 = f__16346__auto__.call(null);
(statearr_79733[(6)] = c__16345__auto__);

return statearr_79733;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.call(null,req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__79786 = conn;
var map__79786__$1 = cljs.core.__destructure_map.call(null,map__79786);
var sub_chan = cljs.core.get.call(null,map__79786__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_79871){
var state_val_79872 = (state_79871[(1)]);
if((state_val_79872 === (7))){
var inst_79867 = (state_79871[(2)]);
var state_79871__$1 = state_79871;
var statearr_79873_79924 = state_79871__$1;
(statearr_79873_79924[(2)] = inst_79867);

(statearr_79873_79924[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79872 === (20))){
var inst_79805 = (state_79871[(7)]);
var inst_79819 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_79820 = [inst_79805];
var inst_79821 = cljs.core.PersistentHashMap.fromArrays(inst_79819,inst_79820);
var inst_79822 = fluree.db.util.log.warn.call(null,"Unsupported callback registered",inst_79821);
var state_79871__$1 = state_79871;
var statearr_79874_79925 = state_79871__$1;
(statearr_79874_79925[(2)] = inst_79822);

(statearr_79874_79925[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79872 === (27))){
var state_79871__$1 = state_79871;
var statearr_79875_79926 = state_79871__$1;
(statearr_79875_79926[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79872 === (1))){
var inst_79787 = (0);
var state_79871__$1 = (function (){var statearr_79877 = state_79871;
(statearr_79877[(8)] = inst_79787);

return statearr_79877;
})();
var statearr_79878_79927 = state_79871__$1;
(statearr_79878_79927[(2)] = null);

(statearr_79878_79927[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79872 === (24))){
var inst_79798 = (state_79871[(9)]);
var inst_79847 = fluree.db.util.core.exception_QMARK_.call(null,inst_79798);
var state_79871__$1 = state_79871;
if(inst_79847){
var statearr_79879_79928 = state_79871__$1;
(statearr_79879_79928[(1)] = (26));

} else {
var statearr_79880_79929 = state_79871__$1;
(statearr_79880_79929[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79872 === (4))){
var inst_79792 = (state_79871[(10)]);
var inst_79797 = (state_79871[(2)]);
var inst_79798 = cljs.core.nth.call(null,inst_79797,(0),null);
var inst_79799 = cljs.core.nth.call(null,inst_79797,(1),null);
var inst_79800 = cljs.core._EQ_.call(null,inst_79799,inst_79792);
var state_79871__$1 = (function (){var statearr_79881 = state_79871;
(statearr_79881[(9)] = inst_79798);

return statearr_79881;
})();
if(inst_79800){
var statearr_79882_79930 = state_79871__$1;
(statearr_79882_79930[(1)] = (5));

} else {
var statearr_79883_79931 = state_79871__$1;
(statearr_79883_79931[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79872 === (15))){
var inst_79805 = (state_79871[(7)]);
var inst_79814 = typeof inst_79805 === 'string';
var state_79871__$1 = state_79871;
if(cljs.core.truth_(inst_79814)){
var statearr_79884_79932 = state_79871__$1;
(statearr_79884_79932[(1)] = (17));

} else {
var statearr_79885_79933 = state_79871__$1;
(statearr_79885_79933[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79872 === (21))){
var state_79871__$1 = state_79871;
var statearr_79886_79934 = state_79871__$1;
(statearr_79886_79934[(2)] = null);

(statearr_79886_79934[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79872 === (31))){
var inst_79861 = (state_79871[(2)]);
var state_79871__$1 = state_79871;
var statearr_79887_79935 = state_79871__$1;
(statearr_79887_79935[(2)] = inst_79861);

(statearr_79887_79935[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79872 === (13))){
var inst_79831 = (state_79871[(2)]);
var inst_79832 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_79833 = fluree.db.connection.close_websocket.call(null,inst_79832);
var inst_79834 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_79835 = fluree.db.session.close_all_sessions.call(null,inst_79834);
var state_79871__$1 = (function (){var statearr_79888 = state_79871;
(statearr_79888[(11)] = inst_79833);

(statearr_79888[(12)] = inst_79831);

return statearr_79888;
})();
var statearr_79889_79936 = state_79871__$1;
(statearr_79889_79936[(2)] = inst_79835);

(statearr_79889_79936[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79872 === (22))){
var inst_79825 = (state_79871[(2)]);
var state_79871__$1 = state_79871;
var statearr_79890_79937 = state_79871__$1;
(statearr_79890_79937[(2)] = inst_79825);

(statearr_79890_79937[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79872 === (29))){
var inst_79798 = (state_79871[(9)]);
var inst_79853 = fluree.db.util.json.parse.call(null,inst_79798);
var inst_79854 = cljs.core.pr_str.call(null,inst_79853);
var inst_79855 = fluree.db.util.log.trace.call(null,"Received message:",inst_79854);
var inst_79856 = fluree.db.util.json.parse.call(null,inst_79798);
var inst_79857 = fluree.db.conn_events.process_events.call(null,conn,inst_79856);
var inst_79787 = (0);
var state_79871__$1 = (function (){var statearr_79891 = state_79871;
(statearr_79891[(13)] = inst_79855);

(statearr_79891[(8)] = inst_79787);

(statearr_79891[(14)] = inst_79857);

return statearr_79891;
})();
var statearr_79892_79938 = state_79871__$1;
(statearr_79892_79938[(2)] = null);

(statearr_79892_79938[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79872 === (6))){
var inst_79798 = (state_79871[(9)]);
var inst_79843 = (inst_79798 == null);
var state_79871__$1 = state_79871;
if(cljs.core.truth_(inst_79843)){
var statearr_79893_79939 = state_79871__$1;
(statearr_79893_79939[(1)] = (23));

} else {
var statearr_79894_79940 = state_79871__$1;
(statearr_79894_79940[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79872 === (28))){
var inst_79863 = (state_79871[(2)]);
var state_79871__$1 = state_79871;
var statearr_79895_79941 = state_79871__$1;
(statearr_79895_79941[(2)] = inst_79863);

(statearr_79895_79941[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79872 === (25))){
var inst_79865 = (state_79871[(2)]);
var state_79871__$1 = state_79871;
var statearr_79896_79942 = state_79871__$1;
(statearr_79896_79942[(2)] = inst_79865);

(statearr_79896_79942[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79872 === (17))){
var inst_79805 = (state_79871[(7)]);
var inst_79816 = cljs.core.eval.call(null,inst_79805);
var state_79871__$1 = state_79871;
var statearr_79897_79943 = state_79871__$1;
(statearr_79897_79943[(2)] = inst_79816);

(statearr_79897_79943[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79872 === (3))){
var inst_79869 = (state_79871[(2)]);
var state_79871__$1 = state_79871;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79871__$1,inst_79869);
} else {
if((state_val_79872 === (12))){
var inst_79805 = (state_79871[(7)]);
var inst_79810 = cljs.core.fn_QMARK_.call(null,inst_79805);
var state_79871__$1 = state_79871;
if(inst_79810){
var statearr_79898_79944 = state_79871__$1;
(statearr_79898_79944[(1)] = (14));

} else {
var statearr_79899_79945 = state_79871__$1;
(statearr_79899_79945[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79872 === (2))){
var inst_79792 = (state_79871[(10)]);
var inst_79792__$1 = cljs.core.async.timeout.call(null,ping_transactor_after);
var inst_79793 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79794 = [sub_chan,inst_79792__$1];
var inst_79795 = (new cljs.core.PersistentVector(null,2,(5),inst_79793,inst_79794,null));
var state_79871__$1 = (function (){var statearr_79900 = state_79871;
(statearr_79900[(10)] = inst_79792__$1);

return statearr_79900;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_79871__$1,(4),inst_79795);
} else {
if((state_val_79872 === (23))){
var inst_79845 = fluree.db.util.log.info.call(null,"Connection closed.");
var state_79871__$1 = state_79871;
var statearr_79901_79946 = state_79871__$1;
(statearr_79901_79946[(2)] = inst_79845);

(statearr_79901_79946[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79872 === (19))){
var inst_79827 = (state_79871[(2)]);
var state_79871__$1 = state_79871;
var statearr_79902_79947 = state_79871__$1;
(statearr_79902_79947[(2)] = inst_79827);

(statearr_79902_79947[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79872 === (11))){
var inst_79808 = fluree.db.util.log.trace.call(null,"No keep-alive callback is registered");
var state_79871__$1 = state_79871;
var statearr_79903_79948 = state_79871__$1;
(statearr_79903_79948[(2)] = inst_79808);

(statearr_79903_79948[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79872 === (9))){
var inst_79787 = (state_79871[(8)]);
var inst_79837 = fluree.db.connection.ping_transactor.call(null,conn);
var inst_79838 = (inst_79787 + (1));
var inst_79787__$1 = inst_79838;
var state_79871__$1 = (function (){var statearr_79904 = state_79871;
(statearr_79904[(8)] = inst_79787__$1);

(statearr_79904[(15)] = inst_79837);

return statearr_79904;
})();
var statearr_79905_79949 = state_79871__$1;
(statearr_79905_79949[(2)] = null);

(statearr_79905_79949[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79872 === (5))){
var inst_79787 = (state_79871[(8)]);
var inst_79802 = cljs.core._EQ_.call(null,(2),inst_79787);
var state_79871__$1 = state_79871;
if(inst_79802){
var statearr_79906_79950 = state_79871__$1;
(statearr_79906_79950[(1)] = (8));

} else {
var statearr_79907_79951 = state_79871__$1;
(statearr_79907_79951[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79872 === (14))){
var inst_79805 = (state_79871[(7)]);
var inst_79812 = inst_79805.call(null);
var state_79871__$1 = state_79871;
var statearr_79908_79952 = state_79871__$1;
(statearr_79908_79952[(2)] = inst_79812);

(statearr_79908_79952[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79872 === (26))){
var inst_79798 = (state_79871[(9)]);
var inst_79849 = fluree.db.util.log.error.call(null,inst_79798);
var inst_79787 = (0);
var state_79871__$1 = (function (){var statearr_79909 = state_79871;
(statearr_79909[(8)] = inst_79787);

(statearr_79909[(16)] = inst_79849);

return statearr_79909;
})();
var statearr_79910_79953 = state_79871__$1;
(statearr_79910_79953[(2)] = null);

(statearr_79910_79953[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79872 === (16))){
var inst_79829 = (state_79871[(2)]);
var state_79871__$1 = state_79871;
var statearr_79911_79954 = state_79871__$1;
(statearr_79911_79954[(2)] = inst_79829);

(statearr_79911_79954[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79872 === (30))){
var state_79871__$1 = state_79871;
var statearr_79912_79955 = state_79871__$1;
(statearr_79912_79955[(2)] = null);

(statearr_79912_79955[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79872 === (10))){
var inst_79841 = (state_79871[(2)]);
var state_79871__$1 = state_79871;
var statearr_79913_79956 = state_79871__$1;
(statearr_79913_79956[(2)] = inst_79841);

(statearr_79913_79956[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79872 === (18))){
var state_79871__$1 = state_79871;
var statearr_79914_79957 = state_79871__$1;
(statearr_79914_79957[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79872 === (8))){
var inst_79805 = (state_79871[(7)]);
var inst_79804 = fluree.db.util.log.warn.call(null,"Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket.");
var inst_79805__$1 = new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581).cljs$core$IFn$_invoke$arity$1(conn);
var inst_79806 = (inst_79805__$1 == null);
var state_79871__$1 = (function (){var statearr_79916 = state_79871;
(statearr_79916[(17)] = inst_79804);

(statearr_79916[(7)] = inst_79805__$1);

return statearr_79916;
})();
if(cljs.core.truth_(inst_79806)){
var statearr_79917_79958 = state_79871__$1;
(statearr_79917_79958[(1)] = (11));

} else {
var statearr_79918_79959 = state_79871__$1;
(statearr_79918_79959[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__16221__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__16221__auto____0 = (function (){
var statearr_79919 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_79919[(0)] = fluree$db$connection$msg_consumer_$_state_machine__16221__auto__);

(statearr_79919[(1)] = (1));

return statearr_79919;
});
var fluree$db$connection$msg_consumer_$_state_machine__16221__auto____1 = (function (state_79871){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_79871);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e79920){var ex__16224__auto__ = e79920;
var statearr_79921_79960 = state_79871;
(statearr_79921_79960[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_79871[(4)]))){
var statearr_79922_79961 = state_79871;
(statearr_79922_79961[(1)] = cljs.core.first.call(null,(state_79871[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79962 = state_79871;
state_79871 = G__79962;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__16221__auto__ = function(state_79871){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__16221__auto____1.call(this,state_79871);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__16221__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__16221__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_79923 = f__16346__auto__.call(null);
(statearr_79923[(6)] = c__16345__auto__);

return statearr_79923;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__79964 = arguments.length;
switch (G__79964) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.call(null,conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__79965 = opts;
var map__79965__$1 = cljs.core.__destructure_map.call(null,map__79965);
var private$ = cljs.core.get.call(null,map__79965__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.call(null,map__79965__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__16345__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_80017){
var state_val_80018 = (state_80017[(1)]);
if((state_val_80018 === (7))){
var inst_79975 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_79976 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79977 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_79978 = (new cljs.core.PersistentVector(null,2,(5),inst_79976,inst_79977,null));
var inst_79979 = cljs.core.get_in.call(null,inst_79975,inst_79978);
var state_80017__$1 = state_80017;
var statearr_80019_80050 = state_80017__$1;
(statearr_80019_80050[(2)] = inst_79979);

(statearr_80019_80050[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80018 === (1))){
var state_80017__$1 = state_80017;
var statearr_80020_80051 = state_80017__$1;
(statearr_80020_80051[(2)] = null);

(statearr_80020_80051[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80018 === (4))){
var inst_79966 = (state_80017[(2)]);
var state_80017__$1 = state_80017;
var statearr_80021_80052 = state_80017__$1;
(statearr_80021_80052[(2)] = inst_79966);

(statearr_80021_80052[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80018 === (15))){
var inst_79986 = (state_80017[(7)]);
var inst_80005 = (state_80017[(2)]);
var inst_80006 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_80007 = [(5000),inst_80005,new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_80008 = cljs.core.PersistentHashMap.fromArrays(inst_80006,inst_80007);
var inst_80009 = fluree.db.util.xhttp.get.call(null,inst_79986,inst_80008);
var state_80017__$1 = state_80017;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80017__$1,(16),inst_80009);
} else {
if((state_val_80018 === (13))){
var inst_79996 = (state_80017[(8)]);
var inst_79986 = (state_80017[(7)]);
var inst_79998 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_79999 = [inst_79996];
var inst_80000 = cljs.core.PersistentHashMap.fromArrays(inst_79998,inst_79999);
var inst_80001 = fluree.db.query.http_signatures.sign_request.call(null,"get",inst_79986,inst_80000,private$);
var inst_80002 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_80001);
var state_80017__$1 = state_80017;
var statearr_80022_80053 = state_80017__$1;
(statearr_80022_80053[(2)] = inst_80002);

(statearr_80022_80053[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80018 === (6))){
var inst_79972 = (state_80017[(9)]);
var state_80017__$1 = state_80017;
var statearr_80023_80054 = state_80017__$1;
(statearr_80023_80054[(2)] = inst_79972);

(statearr_80023_80054[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80018 === (3))){
var inst_80015 = (state_80017[(2)]);
var state_80017__$1 = state_80017;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80017__$1,inst_80015);
} else {
if((state_val_80018 === (12))){
var inst_79996 = (state_80017[(2)]);
var state_80017__$1 = (function (){var statearr_80024 = state_80017;
(statearr_80024[(8)] = inst_79996);

return statearr_80024;
})();
if(cljs.core.truth_(private$)){
var statearr_80025_80055 = state_80017__$1;
(statearr_80025_80055[(1)] = (13));

} else {
var statearr_80026_80056 = state_80017__$1;
(statearr_80026_80056[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80018 === (2))){
var inst_79972 = (state_80017[(9)]);
var _ = (function (){var statearr_80027 = state_80017;
(statearr_80027[(4)] = cljs.core.cons.call(null,(5),(state_80017[(4)])));

return statearr_80027;
})();
var inst_79972__$1 = jwt;
var state_80017__$1 = (function (){var statearr_80028 = state_80017;
(statearr_80028[(9)] = inst_79972__$1);

return statearr_80028;
})();
if(cljs.core.truth_(inst_79972__$1)){
var statearr_80029_80057 = state_80017__$1;
(statearr_80029_80057[(1)] = (6));

} else {
var statearr_80030_80058 = state_80017__$1;
(statearr_80030_80058[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80018 === (11))){
var inst_79990 = (state_80017[(10)]);
var state_80017__$1 = state_80017;
var statearr_80032_80059 = state_80017__$1;
(statearr_80032_80059[(2)] = inst_79990);

(statearr_80032_80059[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80018 === (9))){
var inst_79981 = (state_80017[(11)]);
var inst_79982 = (state_80017[(12)]);
var inst_79985 = (state_80017[(2)]);
var inst_79986 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_79985),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_79982)].join('');
var inst_79988 = ["Accept"];
var inst_79989 = ["application/json"];
var inst_79990 = cljs.core.PersistentHashMap.fromArrays(inst_79988,inst_79989);
var state_80017__$1 = (function (){var statearr_80033 = state_80017;
(statearr_80033[(7)] = inst_79986);

(statearr_80033[(10)] = inst_79990);

return statearr_80033;
})();
if(cljs.core.truth_(inst_79981)){
var statearr_80034_80060 = state_80017__$1;
(statearr_80034_80060[(1)] = (10));

} else {
var statearr_80035_80061 = state_80017__$1;
(statearr_80035_80061[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80018 === (5))){
var _ = (function (){var statearr_80036 = state_80017;
(statearr_80036[(4)] = cljs.core.rest.call(null,(state_80017[(4)])));

return statearr_80036;
})();
var state_80017__$1 = state_80017;
var ex80031 = (state_80017__$1[(2)]);
var statearr_80037_80062 = state_80017__$1;
(statearr_80037_80062[(5)] = ex80031);


if((ex80031 instanceof Error)){
var statearr_80038_80063 = state_80017__$1;
(statearr_80038_80063[(1)] = (4));

(statearr_80038_80063[(5)] = null);

} else {
throw ex80031;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80018 === (14))){
var inst_79996 = (state_80017[(8)]);
var state_80017__$1 = state_80017;
var statearr_80039_80064 = state_80017__$1;
(statearr_80039_80064[(2)] = inst_79996);

(statearr_80039_80064[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80018 === (16))){
var inst_80011 = (state_80017[(2)]);
var inst_80012 = fluree.db.util.async.throw_err.call(null,inst_80011);
var _ = (function (){var statearr_80040 = state_80017;
(statearr_80040[(4)] = cljs.core.rest.call(null,(state_80017[(4)])));

return statearr_80040;
})();
var state_80017__$1 = state_80017;
var statearr_80041_80065 = state_80017__$1;
(statearr_80041_80065[(2)] = inst_80012);

(statearr_80041_80065[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80018 === (10))){
var inst_79981 = (state_80017[(11)]);
var inst_79990 = (state_80017[(10)]);
var inst_79992 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_79981)].join('');
var inst_79993 = cljs.core.assoc.call(null,inst_79990,"Authorization",inst_79992);
var state_80017__$1 = state_80017;
var statearr_80042_80066 = state_80017__$1;
(statearr_80042_80066[(2)] = inst_79993);

(statearr_80042_80066[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80018 === (8))){
var inst_79981 = (state_80017[(2)]);
var inst_79982 = clojure.string.replace.call(null,k,"_","/");
var inst_79983 = fluree.db.connection.get_server.call(null,conn_id,servers);
var state_80017__$1 = (function (){var statearr_80043 = state_80017;
(statearr_80043[(11)] = inst_79981);

(statearr_80043[(12)] = inst_79982);

return statearr_80043;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80017__$1,(9),inst_79983);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__16221__auto__ = null;
var fluree$db$connection$state_machine__16221__auto____0 = (function (){
var statearr_80044 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_80044[(0)] = fluree$db$connection$state_machine__16221__auto__);

(statearr_80044[(1)] = (1));

return statearr_80044;
});
var fluree$db$connection$state_machine__16221__auto____1 = (function (state_80017){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_80017);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e80045){var ex__16224__auto__ = e80045;
var statearr_80046_80067 = state_80017;
(statearr_80046_80067[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_80017[(4)]))){
var statearr_80047_80068 = state_80017;
(statearr_80047_80068[(1)] = cljs.core.first.call(null,(state_80017[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80069 = state_80017;
state_80017 = G__80069;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$connection$state_machine__16221__auto__ = function(state_80017){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__16221__auto____1.call(this,state_80017);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__16221__auto____0;
fluree$db$connection$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__16221__auto____1;
return fluree$db$connection$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_80048 = f__16346__auto__.call(null);
(statearr_80048[(6)] = c__16345__auto__);

return statearr_80048;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

return c__16345__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.evict,k);
} else {
var temp__5751__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache_atom),k);
if(cljs.core.truth_(temp__5751__auto__)){
var v = temp__5751__auto__;
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = value_fn.call(null,k);
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size);
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_.call(null,fn)){
} else {
throw cljs.core.ex_info.call(null,"add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.call(null,"add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__80070_SHARP_){
if(cljs.core.truth_(p1__80070_SHARP_)){
throw cljs.core.ex_info.call(null,["add-listener key already in use: ",cljs.core.pr_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,key);

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db.call(null,conn,ledger,null);
return fluree.db.connection.add_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__80071_SHARP_){
var or__4212__auto__ = p1__80071_SHARP_;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return token;
}
}));

return true;
}catch (e80072){var e = e80072;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__80073 = opts;
var map__80073__$1 = cljs.core.__destructure_map.call(null,map__80073);
var sub_chan = cljs.core.get.call(null,map__80073__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.call(null));
var storage_rename = cljs.core.get.call(null,map__80073__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.call(null,map__80073__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var publish = cljs.core.get.call(null,map__80073__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.call(null,map__80073__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.call(null,map__80073__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.call(null,map__80073__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.call(null,map__80073__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.call(null,map__80073__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var group = cljs.core.get.call(null,map__80073__$1,new cljs.core.Keyword(null,"group","group",582596132));
var meta = cljs.core.get.call(null,map__80073__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.call(null,map__80073__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.call(null,map__80073__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.call(null,map__80073__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.call(null,map__80073__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.call(null,map__80073__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde.call(null));
var memory = cljs.core.get.call(null,map__80073__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.call(null,map__80073__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var storage_write = cljs.core.get.call(null,map__80073__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.call(null,["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.call(null,map__80073__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.call(null,map__80073__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.call(null));
var pub_chan = cljs.core.get.call(null,map__80073__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.call(null));
var private_key_file = cljs.core.get.call(null,map__80073__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.call(null,map__80073__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot.call(null,memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.call(null,["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.call(null,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));
var object_cache_fn = (function (){var or__4212__auto__ = object_cache;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.connection.default_object_cache_fn.call(null,default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid.call(null));
var close = (function (){
cljs.core.async.close_BANG_.call(null,req_chan);

cljs.core.async.close_BANG_.call(null,sub_chan);

cljs.core.async.close_BANG_.call(null,pub_chan);

fluree.db.connection.close_websocket.call(null,conn_id);

cljs.core.swap_BANG_.call(null,state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

if(("nodejs" === cljs.core._STAR_target_STAR_)){
fluree.db.dbfunctions.core.clear_db_fn_cache.call(null);
} else {
}

fluree.db.session.close_all_sessions.call(null,conn_id);

cljs.core.reset_BANG_.call(null,default_cache_atom,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));

if(cljs.core.fn_QMARK_.call(null,close_fn)){
close_fn.call(null);
} else {
}

return fluree.db.util.log.info.call(null,new cljs.core.Keyword(null,"conn-closed","conn-closed",-541764356));
});
var servers_STAR_ = fluree.db.connection.normalize_servers.call(null,servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__4212__auto__ = storage_read;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__4212__auto__ = storage_exists;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = storage_read;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_.call(null,storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.call(null,storage_read)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_.call(null,storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.call(null,storage_exists)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__4210__auto__ = storage_write;
if(cljs.core.truth_(and__4210__auto__)){
return (!(cljs.core.fn_QMARK_.call(null,storage_write)));
} else {
return and__4210__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.call(null,storage_write)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.call(null,fluree.db.connection.add_listener_STAR_,state_atom),group,meta,tx_private_key,cljs.core.partial.call(null,fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_.call(null,keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection.call(null,settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_.call(null,conn))){
return false;
} else {
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn).call(null);

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__4824__auto__ = [];
var len__4818__auto___80114 = arguments.length;
var i__4819__auto___80115 = (0);
while(true){
if((i__4819__auto___80115 < len__4818__auto___80114)){
args__4824__auto__.push((arguments[i__4819__auto___80115]));

var G__80116 = (i__4819__auto___80115 + (1));
i__4819__auto___80115 = G__80116;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__80076){
var vec__80077 = p__80076;
var opts = cljs.core.nth.call(null,vec__80077,(0),null);
var conn = fluree.db.connection.generate_connection.call(null,servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__16345__auto___80117 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__16346__auto__ = (function (){var switch__16220__auto__ = (function (state_80097){
var state_val_80098 = (state_80097[(1)]);
if((state_val_80098 === (1))){
var inst_80080 = fluree.db.connection.get_socket.call(null,conn);
var state_80097__$1 = state_80097;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80097__$1,(2),inst_80080);
} else {
if((state_val_80098 === (2))){
var inst_80083 = (state_80097[(7)]);
var inst_80082 = (state_80097[(8)]);
var inst_80082__$1 = (state_80097[(2)]);
var inst_80083__$1 = (inst_80082__$1 == null);
var state_80097__$1 = (function (){var statearr_80099 = state_80097;
(statearr_80099[(7)] = inst_80083__$1);

(statearr_80099[(8)] = inst_80082__$1);

return statearr_80099;
})();
if(cljs.core.truth_(inst_80083__$1)){
var statearr_80100_80118 = state_80097__$1;
(statearr_80100_80118[(1)] = (3));

} else {
var statearr_80101_80119 = state_80097__$1;
(statearr_80101_80119[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80098 === (3))){
var inst_80083 = (state_80097[(7)]);
var state_80097__$1 = state_80097;
var statearr_80102_80120 = state_80097__$1;
(statearr_80102_80120[(2)] = inst_80083);

(statearr_80102_80120[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80098 === (4))){
var inst_80082 = (state_80097[(8)]);
var inst_80086 = fluree.db.util.core.exception_QMARK_.call(null,inst_80082);
var state_80097__$1 = state_80097;
var statearr_80103_80121 = state_80097__$1;
(statearr_80103_80121[(2)] = inst_80086);

(statearr_80103_80121[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80098 === (5))){
var inst_80088 = (state_80097[(2)]);
var state_80097__$1 = state_80097;
if(cljs.core.truth_(inst_80088)){
var statearr_80104_80122 = state_80097__$1;
(statearr_80104_80122[(1)] = (6));

} else {
var statearr_80105_80123 = state_80097__$1;
(statearr_80105_80123[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80098 === (6))){
var inst_80082 = (state_80097[(8)]);
var inst_80090 = fluree.db.util.log.error.call(null,inst_80082,"Cannot establish connection to a healthy server, disconnecting.");
var inst_80091 = cljs.core.async.close_BANG_.call(null,conn);
var state_80097__$1 = (function (){var statearr_80106 = state_80097;
(statearr_80106[(9)] = inst_80090);

return statearr_80106;
})();
var statearr_80107_80124 = state_80097__$1;
(statearr_80107_80124[(2)] = inst_80091);

(statearr_80107_80124[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80098 === (7))){
var inst_80093 = fluree.db.connection.msg_consumer.call(null,conn);
var state_80097__$1 = state_80097;
var statearr_80108_80125 = state_80097__$1;
(statearr_80108_80125[(2)] = inst_80093);

(statearr_80108_80125[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80098 === (8))){
var inst_80095 = (state_80097[(2)]);
var state_80097__$1 = state_80097;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80097__$1,inst_80095);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__16221__auto__ = null;
var fluree$db$connection$state_machine__16221__auto____0 = (function (){
var statearr_80109 = [null,null,null,null,null,null,null,null,null,null];
(statearr_80109[(0)] = fluree$db$connection$state_machine__16221__auto__);

(statearr_80109[(1)] = (1));

return statearr_80109;
});
var fluree$db$connection$state_machine__16221__auto____1 = (function (state_80097){
while(true){
var ret_value__16222__auto__ = (function (){try{while(true){
var result__16223__auto__ = switch__16220__auto__.call(null,state_80097);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16223__auto__;
}
break;
}
}catch (e80110){var ex__16224__auto__ = e80110;
var statearr_80111_80126 = state_80097;
(statearr_80111_80126[(2)] = ex__16224__auto__);


if(cljs.core.seq.call(null,(state_80097[(4)]))){
var statearr_80112_80127 = state_80097;
(statearr_80112_80127[(1)] = cljs.core.first.call(null,(state_80097[(4)])));

} else {
throw ex__16224__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80128 = state_80097;
state_80097 = G__80128;
continue;
} else {
return ret_value__16222__auto__;
}
break;
}
});
fluree$db$connection$state_machine__16221__auto__ = function(state_80097){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__16221__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__16221__auto____1.call(this,state_80097);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__16221__auto____0;
fluree$db$connection$state_machine__16221__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__16221__auto____1;
return fluree$db$connection$state_machine__16221__auto__;
})()
})();
var state__16347__auto__ = (function (){var statearr_80113 = f__16346__auto__.call(null);
(statearr_80113[(6)] = c__16345__auto___80117);

return statearr_80113;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16347__auto__);
}));

}

fluree.db.connection.msg_producer.call(null,conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq80074){
var G__80075 = cljs.core.first.call(null,seq80074);
var seq80074__$1 = cljs.core.next.call(null,seq80074);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__80075,seq80074__$1);
}));

