// Compiled by ClojureScript 1.10.879 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.conn_events');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.conn_events !== 'undefined') && (typeof fluree.db.conn_events.process_event !== 'undefined')){
} else {
fluree.db.conn_events.process_event = (function (){var method_table__4701__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4702__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4703__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4704__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4705__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fluree.db.conn-events","process-event"),(function (_,event_type,___$1,___$2){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4705__auto__,method_table__4701__auto__,prefer_table__4702__auto__,method_cache__4703__auto__,cached_hierarchy__4704__auto__));
})();
}
cljs.core._add_method.call(null,fluree.db.conn_events.process_event,new cljs.core.Keyword(null,"set-ws-id","set-ws-id",-1586193013),(function (conn,_,___$1,ws_id){
fluree.db.util.log.trace.call(null,"set websocket id:",ws_id);

return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),ws_id);
}));
cljs.core._add_method.call(null,fluree.db.conn_events.process_event,new cljs.core.Keyword(null,"default","default",-1987822328),(function (conn,event_type,subject,event_data){
fluree.db.util.log.trace.call(null,"process event:",event_type,event_data);

var callbacks = cljs.core.get_in.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),subject], null));
var seq__30470 = cljs.core.seq.call(null,callbacks);
var chunk__30471 = null;
var count__30472 = (0);
var i__30473 = (0);
while(true){
if((i__30473 < count__30472)){
var vec__30482 = cljs.core._nth.call(null,chunk__30471,i__30473);
var k = cljs.core.nth.call(null,vec__30482,(0),null);
var f = cljs.core.nth.call(null,vec__30482,(1),null);
try{f.call(null,event_type,event_data);
}catch (e30485){var e_30490 = e30485;
fluree.db.util.log.error.call(null,e_30490,["Error calling registered callback: ",cljs.core.pr_str.call(null,k)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.call(null,event_data),"."].join(''));
}

var G__30491 = seq__30470;
var G__30492 = chunk__30471;
var G__30493 = count__30472;
var G__30494 = (i__30473 + (1));
seq__30470 = G__30491;
chunk__30471 = G__30492;
count__30472 = G__30493;
i__30473 = G__30494;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__30470);
if(temp__5753__auto__){
var seq__30470__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30470__$1)){
var c__4638__auto__ = cljs.core.chunk_first.call(null,seq__30470__$1);
var G__30495 = cljs.core.chunk_rest.call(null,seq__30470__$1);
var G__30496 = c__4638__auto__;
var G__30497 = cljs.core.count.call(null,c__4638__auto__);
var G__30498 = (0);
seq__30470 = G__30495;
chunk__30471 = G__30496;
count__30472 = G__30497;
i__30473 = G__30498;
continue;
} else {
var vec__30486 = cljs.core.first.call(null,seq__30470__$1);
var k = cljs.core.nth.call(null,vec__30486,(0),null);
var f = cljs.core.nth.call(null,vec__30486,(1),null);
try{f.call(null,event_type,event_data);
}catch (e30489){var e_30499 = e30489;
fluree.db.util.log.error.call(null,e_30499,["Error calling registered callback: ",cljs.core.pr_str.call(null,k)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.call(null,event_data),"."].join(''));
}

var G__30500 = cljs.core.next.call(null,seq__30470__$1);
var G__30501 = null;
var G__30502 = (0);
var G__30503 = (0);
seq__30470 = G__30500;
chunk__30471 = G__30501;
count__30472 = G__30502;
i__30473 = G__30503;
continue;
}
} else {
return null;
}
}
break;
}
}));
/**
 * Processes incoming events from the ledger.
 * 
 *   Requests that carry a :req-id in the header will attempt to lookup a
 *   corresponding return channel and send the message along on it.
 * 
 *   Otherwise looks for database events and updates local state accordingly.
 */
fluree.db.conn_events.process_events = (function fluree$db$conn_events$process_events(conn,msg){
try{var _ = fluree.db.util.log.trace.call(null,"Process events: ",msg);
var vec__30506 = msg;
var event_type = cljs.core.nth.call(null,vec__30506,(0),null);
var subject = cljs.core.nth.call(null,vec__30506,(1),null);
var event_data = cljs.core.nth.call(null,vec__30506,(2),null);
var error_data = cljs.core.nth.call(null,vec__30506,(3),null);
var event_type__$1 = cljs.core.keyword.call(null,event_type);
var map__30509 = conn;
var map__30509__$1 = cljs.core.__destructure_map.call(null,map__30509);
var state = cljs.core.get.call(null,map__30509__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var G__30510 = event_type__$1;
var G__30510__$1 = (((G__30510 instanceof cljs.core.Keyword))?G__30510.fqn:null);
switch (G__30510__$1) {
case "response":
var temp__5753__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,state),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),subject], null));
if(cljs.core.truth_(temp__5753__auto__)){
var res_chan = temp__5753__auto__;
fluree.db.util.log.trace.call(null,"Found response channel for subject",subject);

cljs.core.swap_BANG_.call(null,state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),(function (p1__30504_SHARP_){
return cljs.core.dissoc.call(null,p1__30504_SHARP_,subject);
}));

if(cljs.core.truth_(error_data)){
var map__30511 = error_data;
var map__30511__$1 = cljs.core.__destructure_map.call(null,map__30511);
var message = cljs.core.get.call(null,map__30511__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var exception = cljs.core.ex_info.call(null,(function (){var or__4212__auto__ = message;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.pr_str.call(null,error_data);
}
})(),cljs.core.dissoc.call(null,error_data,new cljs.core.Keyword(null,"message","message",-406056002)));
return cljs.core.async.put_BANG_.call(null,res_chan,exception);
} else {
if(cljs.core.truth_(event_data)){
return cljs.core.async.put_BANG_.call(null,res_chan,event_data);
} else {
return cljs.core.async.close_BANG_.call(null,res_chan);

}
}
} else {
return null;
}

break;
case "pong":
return null;

break;
default:
return fluree.db.conn_events.process_event.call(null,conn,event_type__$1,subject,event_data);

}
}catch (e30505){var e = e30505;
return fluree.db.util.log.error.call(null,e);
}});
